{"version":5,"vars":[{"line":88,"containerName":"","kind":2,"name":"base"},{"kind":12,"range":{"end":{"line":117,"character":9999},"start":{"line":105,"character":0}},"line":105,"signature":{"documentation":"1;\n# $Id: BlastHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Hit::GenericHit\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::BlastHit - Blast-specific subclass of Bio::Search::Hit::GenericHit\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Hit::BlastHit;\n    my $hit = Bio::Search::Hit::BlastHit->new(-algorithm => 'blastp');\n\n# See Bio::Search::Hit::GenericHit for information about working with Hits.\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHit objects.\n\n=head1 DESCRIPTION\n\nThis object is a subclass of Bio::Search::Hit::GenericHit\nand provides some operations that facilitate working with BLAST\nand PSI-BLAST Hits.\n\nFor general information about working with Hits, see \nBio::Search::Hit::GenericHit.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason@bioperl.org\nEmail sac@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Hit::BlastHit;\nuse strict;\n\nuse Bio::Search::SearchUtils;\n\nuse base qw(Bio::Search::Hit::GenericHit);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Hit::GenericHit->new();\n Function: Builds a new Bio::Search::Hit::GenericHit object \n Returns : Bio::Search::Hit::GenericHit\n Args    : See Bio::Search::Hit::GenericHit() for other args.\n           Here are the BLAST-specific args that can be used when\n           creating BlastHit objects:\n           -iteration    => integer for the PSI-Blast iteration number\n           -found_again  => boolean, true if hit appears in a \n                            \"previously found\" section of a PSI-Blast report.","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"},"containerName":"main::","name":"new","children":[{"definition":"my","line":106,"containerName":"new","localvar":"my","kind":13,"name":"$class"},{"kind":13,"containerName":"new","name":"@args","line":106},{"line":108,"containerName":"new","localvar":"my","kind":13,"name":"$self","definition":"my"},{"line":108,"name":"$class","containerName":"new","kind":13},{"name":"@args","containerName":"new","kind":13,"line":108},{"kind":13,"localvar":"my","containerName":"new","name":"$iter","line":109,"definition":"my"},{"line":109,"name":"$found","containerName":"new","kind":13},{"name":"$self","kind":13,"containerName":"new","line":109},{"line":109,"kind":12,"containerName":"new","name":"_rearrange"},{"line":111,"name":"@args","containerName":"new","kind":13},{"line":113,"kind":13,"containerName":"new","name":"$iter"},{"kind":13,"containerName":"new","name":"$self","line":113},{"name":"iteration","containerName":"new","kind":12,"line":113},{"kind":13,"containerName":"new","name":"$iter","line":113},{"line":114,"name":"$found","containerName":"new","kind":13},{"name":"$self","containerName":"new","kind":13,"line":114},{"name":"found_again","containerName":"new","kind":12,"line":114},{"line":114,"containerName":"new","kind":13,"name":"$found"},{"line":116,"kind":13,"containerName":"new","name":"$self"}],"detail":"($class,@args)","definition":"sub"},{"line":108,"name":"SUPER","containerName":"new","kind":12},{"definition":"sub","detail":"($self,$value)","children":[{"line":135,"name":"$self","localvar":"my","kind":13,"containerName":"iteration","definition":"my"},{"name":"$value","containerName":"iteration","kind":13,"line":135},{"name":"$value","containerName":"iteration","kind":13,"line":136},{"line":137,"kind":13,"containerName":"iteration","name":"$self"},{"line":137,"name":"$value","kind":13,"containerName":"iteration"},{"line":139,"name":"$self","kind":13,"containerName":"iteration"}],"containerName":"main::","name":"iteration","signature":{"documentation":"1;\n# $Id: BlastHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Hit::GenericHit\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::BlastHit - Blast-specific subclass of Bio::Search::Hit::GenericHit\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Hit::BlastHit;\n    my $hit = Bio::Search::Hit::BlastHit->new(-algorithm => 'blastp');\n\n# See Bio::Search::Hit::GenericHit for information about working with Hits.\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHit objects.\n\n=head1 DESCRIPTION\n\nThis object is a subclass of Bio::Search::Hit::GenericHit\nand provides some operations that facilitate working with BLAST\nand PSI-BLAST Hits.\n\nFor general information about working with Hits, see \nBio::Search::Hit::GenericHit.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason@bioperl.org\nEmail sac@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Hit::BlastHit;\nuse strict;\n\nuse Bio::Search::SearchUtils;\n\nuse base qw(Bio::Search::Hit::GenericHit);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Hit::GenericHit->new();\n Function: Builds a new Bio::Search::Hit::GenericHit object \n Returns : Bio::Search::Hit::GenericHit\n Args    : See Bio::Search::Hit::GenericHit() for other args.\n           Here are the BLAST-specific args that can be used when\n           creating BlastHit objects:\n           -iteration    => integer for the PSI-Blast iteration number\n           -found_again  => boolean, true if hit appears in a \n                            \"previously found\" section of a PSI-Blast report.\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($iter,$found) = $self->_rearrange([qw(ITERATION \n                                            FOUND_AGAIN\n                                           )], @args);\n\n  defined $iter   && $self->iteration($iter);\n  defined $found  && $self->found_again($found);\n\n  return $self;\n}\n\n=head2 iteration\n\n Usage     : $hit->iteration( $iteration_num );\n Purpose   : Gets the iteration number in which the Hit was found.\n Example   : $iteration_num = $sbjct->iteration();\n Returns   : Integer greater than or equal to 1\n             Non-PSI-BLAST reports will report iteration as 1, but this number\n             is only meaningful for PSI-BLAST reports.\n Argument  : iteration_num (optional, used when setting only)\n Throws    : none\n\nSee Also   : L<found_again()|found_again>","parameters":[{"label":"$self"},{"label":"$value"}],"label":"iteration($self,$value)"},"line":134,"range":{"end":{"line":140,"character":9999},"start":{"line":134,"character":0}},"kind":12},{"line":169,"kind":12,"range":{"start":{"line":169,"character":0},"end":{"character":9999,"line":173}},"children":[{"localvar":"my","containerName":"found_again","kind":13,"name":"$self","line":170,"definition":"my"},{"containerName":"found_again","kind":13,"name":"$self","line":171},{"line":172,"kind":13,"containerName":"found_again","name":"$self"}],"containerName":"main::","name":"found_again","definition":"sub"},{"kind":12,"range":{"end":{"character":9999,"line":176},"start":{"character":0,"line":176}},"line":176,"definition":"sub","name":"expect","containerName":"main::","children":[{"line":176,"kind":12,"containerName":"expect","name":"significance"}]}]}