{"version":5,"vars":[{"line":79,"name":"base","kind":2,"containerName":""},{"range":{"start":{"line":135,"character":0},"end":{"line":142,"character":9999}},"kind":12,"line":135,"signature":{"label":"meta($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: ModelHSP.pm 16147 2009-09-22 01:26:32Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::ModelHSP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields at bioperl dot org>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::ModelHSP - A HSP object for model-based searches\n\n=head1 SYNOPSIS\n\n    use Bio::Search::HSP::ModelHSP;\n    # us it just like a Bio::Search::HSP::ModelHSP object\n\n=head1 DESCRIPTION\n\nThis object is a specialization of L<Bio::Search::HSP::ModelHSP> and is used\nfor searches which involve a query model, such as a Hidden Markov Model (HMM),\ncovariance model (CM), descriptor, or anything else besides a sequence. Note\nthat results from any HSPI class methods which rely on the query being a\nsequence are unreliable and have thus been overridden with warnings indicating\nthey have not been implemented at this time.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields at bioperl dot org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::ModelHSP;\nuse strict;\nuse Bio::Seq::Meta;\n\nuse base qw(Bio::Search::HSP::GenericHSP);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::HSP::ModelHSP->new();\n Function: Builds a new Bio::Search::HSP::ModelHSP object \n Returns : Bio::Search::HSP::ModelHSP\n Args    :\n\nPlus Bio::Seach::HSP::ModelHSP methods\n\n           -algorithm => algorithm used (Infernal, RNAMotif, ERPIN, etc)\n           -evalue    => evalue\n           -pvalue    => pvalue\n           -bits      => bit value for HSP\n           -score     => score value for HSP (typically z-score but depends on\n\t\t\t\t\t      analysis)\n           -hsp_length=> Length of the HSP (including gaps)\n           -identical => # of residues that that matched identically\n           -conserved => # of residues that matched conservatively \n                           (only protein comparisions; \n\t\t\t    conserved == identical in nucleotide comparisons)\n           -hsp_gaps   => # of gaps in the HSP\n           -query_gaps => # of gaps in the query in the alignment\n           -hit_gaps   => # of gaps in the subject in the alignment    \n           -query_name  => HSP Query sequence name (if available)\n           -query_start => HSP Query start (in original query sequence coords)\n           -query_end   => HSP Query end (in original query sequence coords)\n           -hit_name    => HSP Hit sequence name (if available)\n           -hit_start   => HSP Hit start (in original hit sequence coords)\n           -hit_end     => HSP Hit end (in original hit sequence coords)\n           -hit_length  => total length of the hit sequence\n           -query_length=> total length of the query sequence\n           -query_seq   => query sequence portion of the HSP\n           -hit_seq     => hit sequence portion of the HSP\n           -homology_seq=> homology sequence for the HSP\n           -hit_frame   => hit frame (only if hit is translated protein)\n           -query_frame => query frame (only if query is translated protein)\n           -meta        => optional meta data (sec structure, markup, etc)\n           -custom_score=> custom score data\n\n\n=head2 meta\n\n Title   : meta\n Usage   : my $meta = $hsp->meta();\n Function: Returns meta data for this HSP or undef\n Returns : string of meta data or undef\n Args    : [optional] string to set value\n Note    : At some point very soon this will likely be a Bio::AnnotationI.\n           Don't get used to a simple string!"},"name":"meta","containerName":"main::","children":[{"line":136,"kind":13,"localvar":"my","containerName":"meta","name":"$self","definition":"my"},{"line":136,"containerName":"meta","kind":13,"name":"$value"},{"definition":"my","line":137,"name":"$previous","kind":13,"localvar":"my","containerName":"meta"},{"line":137,"name":"$self","containerName":"meta","kind":13},{"name":"$value","kind":13,"containerName":"meta","line":138},{"line":139,"containerName":"meta","kind":13,"name":"$self"},{"kind":13,"containerName":"meta","name":"$value","line":139},{"line":141,"name":"$previous","kind":13,"containerName":"meta"}],"detail":"($self,$value)","definition":"sub"},{"signature":{"label":"custom_score($self,$value)","documentation":"1;\n# $Id: ModelHSP.pm 16147 2009-09-22 01:26:32Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::ModelHSP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields at bioperl dot org>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::ModelHSP - A HSP object for model-based searches\n\n=head1 SYNOPSIS\n\n    use Bio::Search::HSP::ModelHSP;\n    # us it just like a Bio::Search::HSP::ModelHSP object\n\n=head1 DESCRIPTION\n\nThis object is a specialization of L<Bio::Search::HSP::ModelHSP> and is used\nfor searches which involve a query model, such as a Hidden Markov Model (HMM),\ncovariance model (CM), descriptor, or anything else besides a sequence. Note\nthat results from any HSPI class methods which rely on the query being a\nsequence are unreliable and have thus been overridden with warnings indicating\nthey have not been implemented at this time.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields at bioperl dot org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::ModelHSP;\nuse strict;\nuse Bio::Seq::Meta;\n\nuse base qw(Bio::Search::HSP::GenericHSP);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::HSP::ModelHSP->new();\n Function: Builds a new Bio::Search::HSP::ModelHSP object \n Returns : Bio::Search::HSP::ModelHSP\n Args    :\n\nPlus Bio::Seach::HSP::ModelHSP methods\n\n           -algorithm => algorithm used (Infernal, RNAMotif, ERPIN, etc)\n           -evalue    => evalue\n           -pvalue    => pvalue\n           -bits      => bit value for HSP\n           -score     => score value for HSP (typically z-score but depends on\n\t\t\t\t\t      analysis)\n           -hsp_length=> Length of the HSP (including gaps)\n           -identical => # of residues that that matched identically\n           -conserved => # of residues that matched conservatively \n                           (only protein comparisions; \n\t\t\t    conserved == identical in nucleotide comparisons)\n           -hsp_gaps   => # of gaps in the HSP\n           -query_gaps => # of gaps in the query in the alignment\n           -hit_gaps   => # of gaps in the subject in the alignment    \n           -query_name  => HSP Query sequence name (if available)\n           -query_start => HSP Query start (in original query sequence coords)\n           -query_end   => HSP Query end (in original query sequence coords)\n           -hit_name    => HSP Hit sequence name (if available)\n           -hit_start   => HSP Hit start (in original hit sequence coords)\n           -hit_end     => HSP Hit end (in original hit sequence coords)\n           -hit_length  => total length of the hit sequence\n           -query_length=> total length of the query sequence\n           -query_seq   => query sequence portion of the HSP\n           -hit_seq     => hit sequence portion of the HSP\n           -homology_seq=> homology sequence for the HSP\n           -hit_frame   => hit frame (only if hit is translated protein)\n           -query_frame => query frame (only if query is translated protein)\n           -meta        => optional meta data (sec structure, markup, etc)\n           -custom_score=> custom score data\n\n\n=head2 meta\n\n Title   : meta\n Usage   : my $meta = $hsp->meta();\n Function: Returns meta data for this HSP or undef\n Returns : string of meta data or undef\n Args    : [optional] string to set value\n Note    : At some point very soon this will likely be a Bio::AnnotationI.\n           Don't get used to a simple string!\n\n\nsub meta {\n    my ($self,$value) = @_;\n    my $previous = $self->{'META'};\n    if( defined $value  ) {\n        $self->{'META'} = $value;\n    }\n    return $previous;\n}\n\n=head2 custom_score\n\n Title   : custom_score\n Usage   : my $data = $hsp->custom_score();\n Function: Returns custom_score data for this HSP, or undef\n Returns : custom_score data or undef\n Args    : [optional] custom_score\n Note    : This is a Get/Set used to deal with odd score-like data generated\n           from RNAMotif (and other programs) where the score section\n           can be customized to include non-standard data, including sequence\n           data, user-based scores, and other values.","parameters":[{"label":"$self"},{"label":"$value"}]},"range":{"start":{"line":158,"character":0},"end":{"line":165,"character":9999}},"kind":12,"line":158,"detail":"($self,$value)","definition":"sub","name":"custom_score","containerName":"main::","children":[{"name":"$self","containerName":"custom_score","localvar":"my","kind":13,"line":159,"definition":"my"},{"line":159,"name":"$value","kind":13,"containerName":"custom_score"},{"localvar":"my","containerName":"custom_score","kind":13,"name":"$previous","line":160,"definition":"my"},{"name":"$self","containerName":"custom_score","kind":13,"line":160},{"line":161,"kind":13,"containerName":"custom_score","name":"$value"},{"line":162,"containerName":"custom_score","kind":13,"name":"$self"},{"line":162,"kind":13,"containerName":"custom_score","name":"$value"},{"line":164,"containerName":"custom_score","kind":13,"name":"$previous"}]},{"children":[{"definition":"my","line":219,"kind":13,"localvar":"my","containerName":"seq","name":"$self"},{"line":219,"kind":13,"containerName":"seq","name":"$seqType"},{"kind":13,"containerName":"seq","name":"$seqType","line":220},{"line":221,"name":"$seqType","kind":13,"containerName":"seq"},{"name":"$seqType","kind":13,"containerName":"seq","line":221},{"definition":"my","containerName":"seq","localvar":"my","kind":13,"name":"$str","line":222},{"name":"$self","containerName":"seq","kind":13,"line":222},{"kind":12,"containerName":"seq","name":"seq_str","line":222},{"line":222,"containerName":"seq","kind":13,"name":"$seqType"},{"line":223,"containerName":"seq","kind":13,"name":"$seqType"},{"line":224,"kind":13,"containerName":"seq","name":"$self"},{"line":224,"containerName":"seq","kind":12,"name":"throw"},{"kind":13,"localvar":"my","containerName":"seq","name":"$id","line":227,"definition":"my"},{"kind":13,"containerName":"seq","name":"$seqType","line":227},{"line":227,"name":"$self","containerName":"seq","kind":13},{"containerName":"seq","kind":12,"name":"query","line":227},{"name":"seq_id","kind":12,"containerName":"seq","line":227},{"name":"$self","kind":13,"containerName":"seq","line":227},{"containerName":"seq","kind":12,"name":"hit","line":227},{"containerName":"seq","kind":12,"name":"seq_id","line":227},{"kind":13,"containerName":"seq","name":"$str","line":228},{"line":229,"name":"$str","kind":13,"containerName":"seq"},{"name":"$seq","containerName":"seq","localvar":"my","kind":13,"line":230,"definition":"my"},{"line":230,"kind":12,"containerName":"seq","name":"new"},{"name":"$id","containerName":"seq","kind":13,"line":230},{"kind":13,"containerName":"seq","name":"$self","line":231},{"name":"start","kind":12,"containerName":"seq","line":231},{"line":231,"name":"$seqType","kind":13,"containerName":"seq"},{"line":232,"name":"$self","kind":13,"containerName":"seq"},{"line":232,"kind":12,"containerName":"seq","name":"end"},{"line":232,"kind":13,"containerName":"seq","name":"$seqType"},{"line":233,"name":"$self","containerName":"seq","kind":13},{"kind":12,"containerName":"seq","name":"strand","line":233},{"containerName":"seq","kind":13,"name":"$seqType","line":233},{"name":"$seq","containerName":"seq","kind":13,"line":236},{"kind":12,"containerName":"seq","name":"seq","line":236},{"line":236,"name":"$str","kind":13,"containerName":"seq"},{"name":"$str","kind":13,"containerName":"seq","line":236},{"containerName":"seq","kind":13,"name":"$seq","line":237}],"name":"seq","containerName":"main::","definition":"sub","detail":"($self,$seqType)","line":217,"range":{"end":{"line":238,"character":9999},"start":{"line":217,"character":0}},"kind":12,"signature":{"label":"seq($self,$seqType)","documentation":"1;\n# $Id: ModelHSP.pm 16147 2009-09-22 01:26:32Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::ModelHSP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields at bioperl dot org>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::ModelHSP - A HSP object for model-based searches\n\n=head1 SYNOPSIS\n\n    use Bio::Search::HSP::ModelHSP;\n    # us it just like a Bio::Search::HSP::ModelHSP object\n\n=head1 DESCRIPTION\n\nThis object is a specialization of L<Bio::Search::HSP::ModelHSP> and is used\nfor searches which involve a query model, such as a Hidden Markov Model (HMM),\ncovariance model (CM), descriptor, or anything else besides a sequence. Note\nthat results from any HSPI class methods which rely on the query being a\nsequence are unreliable and have thus been overridden with warnings indicating\nthey have not been implemented at this time.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields at bioperl dot org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::ModelHSP;\nuse strict;\nuse Bio::Seq::Meta;\n\nuse base qw(Bio::Search::HSP::GenericHSP);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::HSP::ModelHSP->new();\n Function: Builds a new Bio::Search::HSP::ModelHSP object \n Returns : Bio::Search::HSP::ModelHSP\n Args    :\n\nPlus Bio::Seach::HSP::ModelHSP methods\n\n           -algorithm => algorithm used (Infernal, RNAMotif, ERPIN, etc)\n           -evalue    => evalue\n           -pvalue    => pvalue\n           -bits      => bit value for HSP\n           -score     => score value for HSP (typically z-score but depends on\n\t\t\t\t\t      analysis)\n           -hsp_length=> Length of the HSP (including gaps)\n           -identical => # of residues that that matched identically\n           -conserved => # of residues that matched conservatively \n                           (only protein comparisions; \n\t\t\t    conserved == identical in nucleotide comparisons)\n           -hsp_gaps   => # of gaps in the HSP\n           -query_gaps => # of gaps in the query in the alignment\n           -hit_gaps   => # of gaps in the subject in the alignment    \n           -query_name  => HSP Query sequence name (if available)\n           -query_start => HSP Query start (in original query sequence coords)\n           -query_end   => HSP Query end (in original query sequence coords)\n           -hit_name    => HSP Hit sequence name (if available)\n           -hit_start   => HSP Hit start (in original hit sequence coords)\n           -hit_end     => HSP Hit end (in original hit sequence coords)\n           -hit_length  => total length of the hit sequence\n           -query_length=> total length of the query sequence\n           -query_seq   => query sequence portion of the HSP\n           -hit_seq     => hit sequence portion of the HSP\n           -homology_seq=> homology sequence for the HSP\n           -hit_frame   => hit frame (only if hit is translated protein)\n           -query_frame => query frame (only if query is translated protein)\n           -meta        => optional meta data (sec structure, markup, etc)\n           -custom_score=> custom score data\n\n\n=head2 meta\n\n Title   : meta\n Usage   : my $meta = $hsp->meta();\n Function: Returns meta data for this HSP or undef\n Returns : string of meta data or undef\n Args    : [optional] string to set value\n Note    : At some point very soon this will likely be a Bio::AnnotationI.\n           Don't get used to a simple string!\n\n\nsub meta {\n    my ($self,$value) = @_;\n    my $previous = $self->{'META'};\n    if( defined $value  ) {\n        $self->{'META'} = $value;\n    }\n    return $previous;\n}\n\n=head2 custom_score\n\n Title   : custom_score\n Usage   : my $data = $hsp->custom_score();\n Function: Returns custom_score data for this HSP, or undef\n Returns : custom_score data or undef\n Args    : [optional] custom_score\n Note    : This is a Get/Set used to deal with odd score-like data generated\n           from RNAMotif (and other programs) where the score section\n           can be customized to include non-standard data, including sequence\n           data, user-based scores, and other values.\n\n\nsub custom_score {\n    my ($self,$value) = @_;\n    my $previous = $self->{'CUSTOMSCORE'};\n    if( defined $value  ) {\n        $self->{'CUSTOMSCORE'} = $value;\n    }\n    return $previous;\n}\n\n=head2 Bio::Search::HSP::HSPI methods\n\nImplementation of Bio::Search::HSP::HSPI methods follow\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the HSP\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\n=head2 strand\n\n Title   : strand\n Usage   : $hsp->strand('hit')\n Function: Retrieves the strand for the HSP component requested\n Returns : +1 or -1 (0 if unknown)\n Args    : 'hit' or 'subject' or 'sbjct' to retrieve the strand of the subject.\n           There is no strand available for 'query', as the query is a model\n           and not a true sequence.\n\n\n# overrides HSPI::seq()\n\n=head2 seq\n\n Usage     : $hsp->seq( [seq_type] );\n Purpose   : Get the query or sbjct sequence as a Bio::Seq.pm object.\n Example   : $seqObj = $hsp->seq('sbjct');\n Returns   : Object reference for a Bio::Seq.pm object.\n Argument  : seq_type = 'query' or 'hit' or 'sbjct' (default = 'sbjct').\n           :  ('sbjct' is synonymous with 'hit') \n           : default is 'sbjct'\n           : Note: if there is no sequence available (eg for a model-based\n           : search), this returns a LocatableSeq object w/o a sequence\n Throws    : Propagates any exception that occurs during construction\n           : of the Bio::Seq.pm object.\n Comments  : The sequence is returned in an array of strings corresponding\n           : to the strings in the original format of the Blast alignment.\n           : (i.e., same spacing).\n\nSee Also   : L<seq_str()|seq_str>, L<Bio::Seq>","parameters":[{"label":"$self"},{"label":"$seqType"}]}},{"name":"Bio","containerName":"LocatableSeq","kind":12,"line":227},{"kind":12,"containerName":"LocatableSeq","name":"Bio","line":230},{"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: ModelHSP.pm 16147 2009-09-22 01:26:32Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::ModelHSP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields at bioperl dot org>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::ModelHSP - A HSP object for model-based searches\n\n=head1 SYNOPSIS\n\n    use Bio::Search::HSP::ModelHSP;\n    # us it just like a Bio::Search::HSP::ModelHSP object\n\n=head1 DESCRIPTION\n\nThis object is a specialization of L<Bio::Search::HSP::ModelHSP> and is used\nfor searches which involve a query model, such as a Hidden Markov Model (HMM),\ncovariance model (CM), descriptor, or anything else besides a sequence. Note\nthat results from any HSPI class methods which rely on the query being a\nsequence are unreliable and have thus been overridden with warnings indicating\nthey have not been implemented at this time.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields at bioperl dot org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::ModelHSP;\nuse strict;\nuse Bio::Seq::Meta;\n\nuse base qw(Bio::Search::HSP::GenericHSP);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::HSP::ModelHSP->new();\n Function: Builds a new Bio::Search::HSP::ModelHSP object \n Returns : Bio::Search::HSP::ModelHSP\n Args    :\n\nPlus Bio::Seach::HSP::ModelHSP methods\n\n           -algorithm => algorithm used (Infernal, RNAMotif, ERPIN, etc)\n           -evalue    => evalue\n           -pvalue    => pvalue\n           -bits      => bit value for HSP\n           -score     => score value for HSP (typically z-score but depends on\n\t\t\t\t\t      analysis)\n           -hsp_length=> Length of the HSP (including gaps)\n           -identical => # of residues that that matched identically\n           -conserved => # of residues that matched conservatively \n                           (only protein comparisions; \n\t\t\t    conserved == identical in nucleotide comparisons)\n           -hsp_gaps   => # of gaps in the HSP\n           -query_gaps => # of gaps in the query in the alignment\n           -hit_gaps   => # of gaps in the subject in the alignment    \n           -query_name  => HSP Query sequence name (if available)\n           -query_start => HSP Query start (in original query sequence coords)\n           -query_end   => HSP Query end (in original query sequence coords)\n           -hit_name    => HSP Hit sequence name (if available)\n           -hit_start   => HSP Hit start (in original hit sequence coords)\n           -hit_end     => HSP Hit end (in original hit sequence coords)\n           -hit_length  => total length of the hit sequence\n           -query_length=> total length of the query sequence\n           -query_seq   => query sequence portion of the HSP\n           -hit_seq     => hit sequence portion of the HSP\n           -homology_seq=> homology sequence for the HSP\n           -hit_frame   => hit frame (only if hit is translated protein)\n           -query_frame => query frame (only if query is translated protein)\n           -meta        => optional meta data (sec structure, markup, etc)\n           -custom_score=> custom score data\n\n\n=head2 meta\n\n Title   : meta\n Usage   : my $meta = $hsp->meta();\n Function: Returns meta data for this HSP or undef\n Returns : string of meta data or undef\n Args    : [optional] string to set value\n Note    : At some point very soon this will likely be a Bio::AnnotationI.\n           Don't get used to a simple string!\n\n\nsub meta {\n    my ($self,$value) = @_;\n    my $previous = $self->{'META'};\n    if( defined $value  ) {\n        $self->{'META'} = $value;\n    }\n    return $previous;\n}\n\n=head2 custom_score\n\n Title   : custom_score\n Usage   : my $data = $hsp->custom_score();\n Function: Returns custom_score data for this HSP, or undef\n Returns : custom_score data or undef\n Args    : [optional] custom_score\n Note    : This is a Get/Set used to deal with odd score-like data generated\n           from RNAMotif (and other programs) where the score section\n           can be customized to include non-standard data, including sequence\n           data, user-based scores, and other values.\n\n\nsub custom_score {\n    my ($self,$value) = @_;\n    my $previous = $self->{'CUSTOMSCORE'};\n    if( defined $value  ) {\n        $self->{'CUSTOMSCORE'} = $value;\n    }\n    return $previous;\n}\n\n=head2 Bio::Search::HSP::HSPI methods\n\nImplementation of Bio::Search::HSP::HSPI methods follow\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the HSP\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\n=head2 strand\n\n Title   : strand\n Usage   : $hsp->strand('hit')\n Function: Retrieves the strand for the HSP component requested\n Returns : +1 or -1 (0 if unknown)\n Args    : 'hit' or 'subject' or 'sbjct' to retrieve the strand of the subject.\n           There is no strand available for 'query', as the query is a model\n           and not a true sequence.\n\n\n# overrides HSPI::seq()\n\n=head2 seq\n\n Usage     : $hsp->seq( [seq_type] );\n Purpose   : Get the query or sbjct sequence as a Bio::Seq.pm object.\n Example   : $seqObj = $hsp->seq('sbjct');\n Returns   : Object reference for a Bio::Seq.pm object.\n Argument  : seq_type = 'query' or 'hit' or 'sbjct' (default = 'sbjct').\n           :  ('sbjct' is synonymous with 'hit') \n           : default is 'sbjct'\n           : Note: if there is no sequence available (eg for a model-based\n           : search), this returns a LocatableSeq object w/o a sequence\n Throws    : Propagates any exception that occurs during construction\n           : of the Bio::Seq.pm object.\n Comments  : The sequence is returned in an array of strings corresponding\n           : to the strings in the original format of the Blast alignment.\n           : (i.e., same spacing).\n\nSee Also   : L<seq_str()|seq_str>, L<Bio::Seq>\n\n\n#-------\nsub seq {\n#-------\n    my($self,$seqType) = @_; \n    $seqType ||= 'sbjct';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n    my $str = $self->seq_str($seqType);\n    if( $seqType =~ /^(m|ho)/i ) {\n        $self->throw(\"cannot call seq on the homology match string, it isn't really a sequence, use get_aln to convert the HSP to a Bio::AlignIO and generate a consensus from that.\");\n    }\n    require Bio::LocatableSeq;\n    my $id = $seqType =~ /^q/i ? $self->query->seq_id : $self->hit->seq_id;\n    $str =~ s{\\*\\[\\s*(\\d+)\\s*\\]\\*}{'N' x $1}ge;\n    $str =~ s{\\s+}{}g;\n    my $seq = Bio::LocatableSeq->new (-ID    => $id,\n                           -START => $self->start($seqType),\n                           -END   => $self->end($seqType),\n                           -STRAND=> $self->strand($seqType),\n                           -DESC  => \"$seqType sequence \",\n                           );\n    $seq->seq($str) if $str;\n    $seq;\n}\n\n=head2 pvalue\n\n Title   : pvalue\n Usage   : my $pvalue = $hsp->pvalue();\n Function: Returns the P-value for this HSP or undef \n Returns : float or exponential (2e-10)\n           P-value is not defined with NCBI Blast2 reports.\n Args    : [optional] numeric to set value\n\n\n=head2 evalue\n\n Title   : evalue\n Usage   : my $evalue = $hsp->evalue();\n Function: Returns the e-value for this HSP\n Returns : float or exponential (2e-10)\n Args    : [optional] numeric to set value\n\n\n=head2 gaps\n\n Title    : gaps\n Usage    : my $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n Function : Get the number of gaps in the query, hit, or total alignment.\n Returns  : Integer, number of gaps or 0 if none\n Args     : arg 1: 'query' = num gaps in query seq\n                   'hit'   = num gaps in hit seq\n                   'total' = num gaps in whole alignment \n                   default = 'total' \n            arg 2: [optional] integer gap value to set for the type requested\n\n\n=head2 query_string\n\n Title   : query_string\n Usage   : my $qseq = $hsp->query_string;\n Function: Retrieves the query sequence of this HSP as a string\n Returns : string\n Args    : [optional] string to set for query sequence\n\n\n=head2 hit_string\n\n Title   : hit_string\n Usage   : my $hseq = $hsp->hit_string;\n Function: Retrieves the hit sequence of this HSP as a string\n Returns : string\n Args    : [optional] string to set for hit sequence\n\n\n=head2 homology_string\n\n Title   : homology_string\n Usage   : my $homo_string = $hsp->homology_string;\n Function: Retrieves the homology sequence for this HSP as a string.\n         : The homology sequence is the string of symbols in between the \n         : query and hit sequences in the alignment indicating the degree\n         : of conservation (e.g., identical, similar, not similar).\n Returns : string\n Args    : [optional] string to set for homology sequence\n\n\n=head2 length\n\n Title    : length\n Usage    : my $len = $hsp->length( ['query'|'hit'|'total'] );\n Function : Returns the length of the query or hit in the alignment \n            (without gaps) \n            or the aggregate length of the HSP (including gaps;\n            this may be greater than either hit or query )\n Returns  : integer\n Args     : arg 1: 'query' = length of query seq (without gaps)\n                   'hit'   = length of hit seq (without gaps)\n                   'total' = length of alignment (with gaps)\n                   default = 'total' \n            arg 2: [optional] integer length value to set for specific type\n\n\n=head2 frame\n\n Title   : frame\n Usage   : my ($qframe, $hframe) = $hsp->frame('list',$queryframe,$subjectframe)\n Function: Set the Frame for both query and subject and insure that\n           they agree.\n           This overrides the frame() method implementation in\n           FeaturePair.\n Returns : array of query and subject frame if return type wants an array\n           or query frame if defined or subject frame if not defined\n Args    : 'hit' or 'subject' or 'sbjct' to retrieve the frame of the subject (default)\n           'query' to retrieve the query frame \n           'list' or 'array' to retrieve both query and hit frames together\n Note    : Frames are stored in the GFF way (0-2) not 1-3\n           as they are in BLAST (negative frames are deduced by checking\n                                 the strand of the query or hit)\n\n\n=head2 get_aln\n\n Title   : get_aln\n Usage   : my $aln = $hsp->gel_aln\n Function: Returns a Bio::SimpleAlign representing the HSP alignment\n Returns : Bio::SimpleAlign\n Args    : none","label":"get_aln($self)"},"line":354,"kind":12,"range":{"start":{"line":354,"character":0},"end":{"line":404,"character":9999}},"definition":"sub","detail":"($self)","children":[{"line":355,"localvar":"my","containerName":"get_aln","kind":13,"name":"$self","definition":"my"},{"kind":13,"localvar":"my","containerName":"get_aln","name":"$aln","line":358,"definition":"my"},{"kind":12,"containerName":"get_aln","name":"new","line":358},{"name":"%hsp","containerName":"get_aln","localvar":"my","kind":13,"line":359,"definition":"my"},{"line":359,"name":"$self","kind":13,"containerName":"get_aln"},{"name":"hit_string","kind":12,"containerName":"get_aln","line":359},{"line":360,"containerName":"get_aln","kind":13,"name":"$self"},{"kind":12,"containerName":"get_aln","name":"homology_string","line":360},{"kind":13,"containerName":"get_aln","name":"$self","line":361},{"line":361,"name":"query_string","containerName":"get_aln","kind":12},{"kind":13,"containerName":"get_aln","name":"$self","line":362},{"line":362,"name":"meta","kind":12,"containerName":"get_aln"},{"kind":13,"containerName":"get_aln","name":"$hsp","line":365},{"line":365,"name":"$hsp","kind":13,"containerName":"get_aln"},{"name":"$self","containerName":"get_aln","kind":13,"line":366},{"kind":12,"containerName":"get_aln","name":"_postprocess_hsp","line":366},{"line":366,"name":"%hsp","containerName":"get_aln","kind":13},{"line":369,"kind":13,"containerName":"get_aln","name":"$hsp"},{"containerName":"get_aln","kind":13,"name":"$self","line":370},{"name":"warn","containerName":"get_aln","kind":12,"line":370},{"localvar":"my","kind":13,"containerName":"get_aln","name":"$seqonly","line":374,"definition":"my"},{"line":374,"kind":13,"containerName":"get_aln","name":"$hsp"},{"kind":13,"containerName":"get_aln","name":"$seqonly","line":375},{"containerName":"get_aln","localvar":"my","kind":13,"name":"$q_nm","line":376,"definition":"my"},{"kind":13,"containerName":"get_aln","name":"$s_nm","line":376},{"line":376,"name":"$self","kind":13,"containerName":"get_aln"},{"kind":12,"containerName":"get_aln","name":"query","line":376},{"line":376,"name":"seq_id","kind":12,"containerName":"get_aln"},{"line":377,"containerName":"get_aln","kind":13,"name":"$self"},{"containerName":"get_aln","kind":12,"name":"hit","line":377},{"line":377,"name":"seq_id","kind":12,"containerName":"get_aln"},{"name":"$q_nm","kind":13,"containerName":"get_aln","line":378},{"kind":13,"containerName":"get_aln","name":"$q_nm","line":378},{"line":379,"kind":13,"containerName":"get_aln","name":"$q_nm"},{"line":381,"name":"$s_nm","kind":13,"containerName":"get_aln"},{"kind":13,"containerName":"get_aln","name":"$s_nm","line":381},{"line":382,"name":"$s_nm","kind":13,"containerName":"get_aln"},{"definition":"my","containerName":"get_aln","localvar":"my","kind":13,"name":"$query","line":384},{"containerName":"get_aln","kind":12,"name":"new","line":384},{"kind":13,"containerName":"get_aln","name":"$hsp","line":384},{"line":385,"name":"$q_nm","kind":13,"containerName":"get_aln"},{"kind":13,"containerName":"get_aln","name":"$self","line":386},{"line":386,"kind":12,"containerName":"get_aln","name":"query"},{"line":386,"kind":12,"containerName":"get_aln","name":"start"},{"line":387,"name":"$self","containerName":"get_aln","kind":13},{"line":387,"name":"query","containerName":"get_aln","kind":12},{"line":387,"containerName":"get_aln","kind":12,"name":"end"},{"line":389,"kind":13,"containerName":"get_aln","name":"$seqonly"},{"line":389,"name":"$hsp","kind":13,"containerName":"get_aln"},{"line":390,"containerName":"get_aln","kind":13,"name":"$seqonly"},{"definition":"my","line":391,"localvar":"my","kind":13,"containerName":"get_aln","name":"$hit"},{"name":"new","containerName":"get_aln","kind":12,"line":391},{"line":391,"name":"$hsp","containerName":"get_aln","kind":13},{"line":392,"name":"$s_nm","kind":13,"containerName":"get_aln"},{"name":"$self","kind":13,"containerName":"get_aln","line":393},{"name":"hit","kind":12,"containerName":"get_aln","line":393},{"name":"start","containerName":"get_aln","kind":12,"line":393},{"line":394,"name":"$self","kind":13,"containerName":"get_aln"},{"line":394,"containerName":"get_aln","kind":12,"name":"hit"},{"line":394,"kind":12,"containerName":"get_aln","name":"end"},{"name":"$aln","kind":13,"containerName":"get_aln","line":396},{"line":396,"name":"add_seq","kind":12,"containerName":"get_aln"},{"line":396,"name":"$query","containerName":"get_aln","kind":13},{"kind":13,"containerName":"get_aln","name":"$aln","line":397},{"line":397,"name":"add_seq","kind":12,"containerName":"get_aln"},{"line":397,"containerName":"get_aln","kind":13,"name":"$hit"},{"kind":13,"containerName":"get_aln","name":"$hsp","line":398},{"line":399,"name":"$meta_obj","kind":13,"localvar":"my","containerName":"get_aln","definition":"my"},{"line":399,"containerName":"get_aln","kind":12,"name":"new"},{"line":400,"kind":13,"containerName":"get_aln","name":"$meta_obj"},{"name":"named_meta","containerName":"get_aln","kind":12,"line":400},{"line":400,"kind":13,"containerName":"get_aln","name":"$hsp"},{"containerName":"get_aln","kind":13,"name":"$aln","line":401},{"containerName":"get_aln","kind":12,"name":"consensus_meta","line":401},{"name":"$meta_obj","kind":13,"containerName":"get_aln","line":401},{"line":403,"name":"$aln","containerName":"get_aln","kind":13}],"containerName":"main::","name":"get_aln"},{"line":358,"kind":12,"containerName":"LocatableSeq::Bio::SimpleAlign","name":"Bio"},{"containerName":"SimpleAlign","kind":12,"name":"Bio","line":358},{"line":359,"name":"hit","kind":12},{"kind":12,"name":"midline","line":360},{"kind":12,"name":"query","line":361},{"name":"meta","kind":12,"line":362},{"name":"meta","kind":12,"line":365},{"line":365,"name":"meta","kind":12},{"line":369,"name":"query","kind":12},{"line":374,"name":"query","kind":12},{"name":"CORE","containerName":"length","kind":12,"line":378},{"line":381,"name":"CORE","kind":12,"containerName":"length"},{"name":"Bio","containerName":"LocatableSeq","kind":12,"line":384},{"line":384,"name":"query","kind":12},{"name":"hit","kind":12,"line":389},{"kind":12,"containerName":"LocatableSeq","name":"Bio","line":391},{"line":391,"kind":12,"name":"hit"},{"kind":12,"name":"meta","line":398},{"kind":12,"containerName":"Seq::Meta","name":"Bio","line":399},{"kind":12,"name":"meta","line":400},{"line":468,"range":{"end":{"character":9999,"line":472},"start":{"line":468,"character":0}},"kind":12,"definition":"sub","children":[{"line":469,"containerName":"seq_inds","localvar":"my","kind":13,"name":"$self","definition":"my"},{"line":470,"kind":13,"containerName":"seq_inds","name":"$self"},{"line":470,"kind":12,"containerName":"seq_inds","name":"warn"}],"name":"seq_inds","containerName":"main::"},{"definition":"sub","containerName":"main::","name":"frac_identical","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"frac_identical","name":"$self","line":479},{"kind":13,"containerName":"frac_identical","name":"$self","line":480},{"name":"warn","kind":12,"containerName":"frac_identical","line":480}],"range":{"end":{"line":482,"character":9999},"start":{"line":478,"character":0}},"kind":12,"line":478},{"containerName":"main::","name":"frac_conserved","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"frac_conserved","line":489},{"line":490,"name":"$self","containerName":"frac_conserved","kind":13},{"name":"warn","kind":12,"containerName":"frac_conserved","line":490}],"definition":"sub","kind":12,"range":{"start":{"line":488,"character":0},"end":{"line":492,"character":9999}},"line":488},{"containerName":"main::","name":"matches","children":[{"line":499,"localvar":"my","containerName":"matches","kind":13,"name":"$self","definition":"my"},{"name":"$self","kind":13,"containerName":"matches","line":500},{"line":500,"kind":12,"containerName":"matches","name":"warn"}],"definition":"sub","kind":12,"range":{"end":{"line":502,"character":9999},"start":{"line":498,"character":0}},"line":498},{"kind":12,"range":{"start":{"line":508,"character":0},"end":{"character":9999,"line":512}},"line":508,"definition":"sub","name":"num_conserved","containerName":"main::","children":[{"kind":13,"localvar":"my","containerName":"num_conserved","name":"$self","line":509,"definition":"my"},{"name":"$self","containerName":"num_conserved","kind":13,"line":510},{"line":510,"kind":12,"containerName":"num_conserved","name":"warn"}]},{"kind":12,"range":{"start":{"line":518,"character":0},"end":{"character":9999,"line":522}},"line":518,"containerName":"main::","name":"num_identical","children":[{"line":519,"name":"$self","localvar":"my","containerName":"num_identical","kind":13,"definition":"my"},{"name":"$self","kind":13,"containerName":"num_identical","line":520},{"kind":12,"containerName":"num_identical","name":"warn","line":520}],"definition":"sub"},{"kind":12,"range":{"end":{"line":533,"character":9999},"start":{"character":0,"line":529}},"line":529,"definition":"sub","name":"cigar_string","containerName":"main::","children":[{"definition":"my","line":530,"name":"$self","kind":13,"localvar":"my","containerName":"cigar_string"},{"line":531,"name":"$self","kind":13,"containerName":"cigar_string"},{"line":531,"name":"warn","containerName":"cigar_string","kind":12}]},{"children":[{"definition":"my","line":540,"localvar":"my","containerName":"generate_cigar_string","kind":13,"name":"$self"},{"containerName":"generate_cigar_string","kind":13,"name":"$self","line":541},{"name":"warn","kind":12,"containerName":"generate_cigar_string","line":541}],"name":"generate_cigar_string","containerName":"main::","definition":"sub","line":539,"range":{"end":{"line":543,"character":9999},"start":{"character":0,"line":539}},"kind":12},{"children":[{"name":"$self","localvar":"my","containerName":"percent_identity","kind":13,"line":550,"definition":"my"},{"name":"$self","kind":13,"containerName":"percent_identity","line":551},{"line":551,"name":"warn","containerName":"percent_identity","kind":12}],"name":"percent_identity","containerName":"main::","definition":"sub","line":549,"range":{"start":{"character":0,"line":549},"end":{"line":553,"character":9999}},"kind":12},{"name":"$SEQ_REGEX","localvar":"my","kind":13,"containerName":null,"line":561,"definition":"my"},{"definition":"my","line":562,"name":"$META_REGEX","localvar":"my","containerName":null,"kind":13},{"children":[{"line":565,"containerName":"_postprocess_hsp","localvar":"my","kind":13,"name":"$self","definition":"my"},{"line":565,"name":"$hsp","kind":13,"containerName":"_postprocess_hsp"},{"containerName":"_postprocess_hsp","kind":13,"name":"$self","line":566},{"line":566,"name":"throw","containerName":"_postprocess_hsp","kind":12},{"containerName":"_postprocess_hsp","kind":13,"name":"$hsp","line":566},{"definition":"my","name":"@ins","localvar":"my","containerName":"_postprocess_hsp","kind":13,"line":567},{"containerName":"_postprocess_hsp","localvar":"my","kind":13,"name":"$type","line":568,"definition":"my"},{"line":569,"containerName":"_postprocess_hsp","kind":13,"name":"$hsp"},{"line":569,"name":"$type","kind":13,"containerName":"_postprocess_hsp"},{"definition":"my","localvar":"my","kind":13,"containerName":"_postprocess_hsp","name":"$str","line":570},{"line":570,"name":"$hsp","containerName":"_postprocess_hsp","kind":13},{"line":570,"name":"$type","containerName":"_postprocess_hsp","kind":13},{"name":"$regex","kind":13,"localvar":"my","containerName":"_postprocess_hsp","line":571,"definition":"my"},{"line":571,"containerName":"_postprocess_hsp","kind":13,"name":"$type"},{"name":"$META_REGEX","containerName":"_postprocess_hsp","kind":13,"line":571},{"containerName":"_postprocess_hsp","kind":13,"name":"$SEQ_REGEX","line":571},{"definition":"my","name":"$ind","kind":13,"localvar":"my","containerName":"_postprocess_hsp","line":572},{"name":"$str","containerName":"_postprocess_hsp","kind":13,"line":573},{"line":574,"name":"$ins","containerName":"_postprocess_hsp","kind":13},{"line":574,"name":"$ind","containerName":"_postprocess_hsp","kind":13},{"name":"$type","containerName":"_postprocess_hsp","kind":13,"line":574},{"line":574,"containerName":"_postprocess_hsp","kind":13,"name":"$str"},{"line":575,"name":"$ind","kind":13,"containerName":"_postprocess_hsp"},{"definition":"my","line":578,"containerName":"_postprocess_hsp","localvar":"my","kind":13,"name":"$chunk"},{"line":578,"kind":13,"containerName":"_postprocess_hsp","name":"@ins"},{"definition":"my","name":"$max","localvar":"my","kind":13,"containerName":"_postprocess_hsp","line":579},{"name":"$min","kind":13,"containerName":"_postprocess_hsp","line":579},{"name":"$chunk","kind":13,"containerName":"_postprocess_hsp","line":579},{"kind":13,"containerName":"_postprocess_hsp","name":"$chunk","line":579},{"kind":13,"localvar":"my","containerName":"_postprocess_hsp","name":"%rep","line":581,"definition":"my"},{"containerName":"_postprocess_hsp","kind":13,"name":"$rep","line":582},{"line":582,"kind":13,"containerName":"_postprocess_hsp","name":"$max"},{"kind":13,"containerName":"_postprocess_hsp","name":"$chunk","line":582},{"line":582,"kind":13,"containerName":"_postprocess_hsp","name":"$max"},{"line":583,"name":"$rep","kind":13,"containerName":"_postprocess_hsp"},{"containerName":"_postprocess_hsp","kind":13,"name":"$min","line":583},{"containerName":"_postprocess_hsp","kind":13,"name":"$chunk","line":583},{"line":583,"kind":13,"containerName":"_postprocess_hsp","name":"$min"},{"line":584,"name":"$chunk","containerName":"_postprocess_hsp","kind":13},{"name":"$max","kind":13,"containerName":"_postprocess_hsp","line":584},{"name":"$chunk","containerName":"_postprocess_hsp","kind":13,"line":584},{"name":"$min","containerName":"_postprocess_hsp","kind":13,"line":584},{"line":585,"name":"$rep","containerName":"_postprocess_hsp","kind":13},{"name":"$chunk","kind":13,"containerName":"_postprocess_hsp","line":585},{"name":"$max","kind":13,"containerName":"_postprocess_hsp","line":585},{"name":"$rep","kind":13,"containerName":"_postprocess_hsp","line":586},{"kind":13,"containerName":"_postprocess_hsp","name":"$chunk","line":586},{"name":"$max","containerName":"_postprocess_hsp","kind":13,"line":586},{"definition":"my","name":"$t","kind":13,"localvar":"my","containerName":"_postprocess_hsp","line":587},{"name":"$hsp","containerName":"_postprocess_hsp","kind":13,"line":588},{"containerName":"_postprocess_hsp","kind":13,"name":"$t","line":588},{"line":588,"name":"$chunk","containerName":"_postprocess_hsp","kind":13},{"containerName":"_postprocess_hsp","kind":13,"name":"$chunk","line":588},{"line":588,"name":"$rep","kind":13,"containerName":"_postprocess_hsp"},{"line":588,"name":"$t","containerName":"_postprocess_hsp","kind":13}],"containerName":"main::","name":"_postprocess_hsp","definition":"sub","detail":"($self,$hsp)","line":564,"range":{"end":{"character":9999,"line":591},"start":{"line":564,"character":0}},"kind":12,"signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$hsp"}],"label":"_postprocess_hsp($self,$hsp)"}},{"name":"pos","kind":12,"line":574},{"name":"str","kind":12,"line":574},{"kind":12,"name":"hit","line":579},{"name":"str","kind":12,"line":579},{"line":579,"kind":12,"name":"query"},{"line":579,"kind":12,"name":"str"},{"name":"str","kind":12,"line":582},{"name":"str","kind":12,"line":583},{"line":584,"kind":12,"name":"str"},{"name":"str","kind":12,"line":584},{"name":"str","kind":12,"line":585},{"line":586,"kind":12,"name":"str"},{"kind":12,"name":"meta","line":588},{"name":"pos","kind":12,"line":588},{"line":588,"name":"meta","kind":12},{"kind":12,"name":"str","line":588}]}