{"version":5,"vars":[{"line":128,"name":"base","containerName":"","kind":2},{"definition":"sub","detail":"($self,@args)","children":[{"definition":"my","line":142,"name":"$self","localvar":"my","containerName":"algorithm","kind":13},{"containerName":"algorithm","kind":13,"name":"@args","line":142},{"name":"$self","kind":13,"containerName":"algorithm","line":143},{"line":143,"containerName":"algorithm","kind":12,"name":"throw_not_implemented"}],"name":"algorithm","containerName":"main::","signature":{"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: HSPI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::HSPI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n# and Jason Stajich <jason@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::HSPI - Interface for a High Scoring Pair in a similarity search result\n\n=head1 SYNOPSIS\n\n    # Bio::Search::HSP::HSPI objects cannot be instantiated since this\n    # module defines a pure interface.\n\n    # Given an object that implements the Bio::Search::HSP::HSPI  interface,\n    # you can do the following things with it:\n\n    $r_type = $hsp->algorithm;\n\n    $pvalue = $hsp->pvalue();\n\n    $evalue = $hsp->evalue();\n\n    $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n\n    $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n\n    $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n\n    $qseq = $hsp->query_string;\n\n    $hseq = $hsp->hit_string;\n\n    $homology_string = $hsp->homology_string;\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $rank = $hsp->rank;\n\n=head1 DESCRIPTION\n\nBio::Search::HSP::HSPI objects cannot be instantiated since this\nmodule defines a pure interface.\n\nGiven an object that implements the L<Bio::Search::HSP::HSPI> interface,\nyou can do the following things with it:\n\n=head1 SEE ALSO\n\nThis interface inherits methods from these other modules:\n\nL<Bio::SeqFeatureI>,\nL<Bio::SeqFeature::FeaturePair>\nL<Bio::SeqFeature::SimilarityPair>\n\nPlease refer to these modules for documentation of the \nmany additional inherited methods.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Steve Chervitz, Jason Stajich\n\nEmail sac-at-bioperl.org\nEmail jason-at-bioperl.org\n\n=head1 COPYRIGHT\n\nCopyright (c) 2001 Steve Chervitz, Jason Stajich. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::HSP::HSPI;\n\n\nuse strict;\nuse Carp;\n\nuse base qw(Bio::SeqFeature::SimilarityPair Bio::Root::RootI);\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the HSP\n Returns : string (e.g., BLASTP)\n Args    : none","parameters":[{"label":"$self"},{"label":"@args"}],"label":"algorithm($self,@args)"},"line":141,"kind":12,"range":{"end":{"line":144,"character":9999},"start":{"line":141,"character":0}}},{"children":[{"line":158,"name":"$self","kind":13,"localvar":"my","containerName":"pvalue","definition":"my"},{"line":159,"containerName":"pvalue","kind":13,"name":"$self"},{"line":159,"name":"throw_not_implemented","kind":12,"containerName":"pvalue"}],"containerName":"main::","name":"pvalue","definition":"sub","detail":"($self)","line":157,"kind":12,"range":{"end":{"character":9999,"line":160},"start":{"line":157,"character":0}},"signature":{"label":"pvalue($self)","parameters":[{"label":"$self"}],"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: HSPI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::HSPI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n# and Jason Stajich <jason@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::HSPI - Interface for a High Scoring Pair in a similarity search result\n\n=head1 SYNOPSIS\n\n    # Bio::Search::HSP::HSPI objects cannot be instantiated since this\n    # module defines a pure interface.\n\n    # Given an object that implements the Bio::Search::HSP::HSPI  interface,\n    # you can do the following things with it:\n\n    $r_type = $hsp->algorithm;\n\n    $pvalue = $hsp->pvalue();\n\n    $evalue = $hsp->evalue();\n\n    $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n\n    $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n\n    $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n\n    $qseq = $hsp->query_string;\n\n    $hseq = $hsp->hit_string;\n\n    $homology_string = $hsp->homology_string;\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $rank = $hsp->rank;\n\n=head1 DESCRIPTION\n\nBio::Search::HSP::HSPI objects cannot be instantiated since this\nmodule defines a pure interface.\n\nGiven an object that implements the L<Bio::Search::HSP::HSPI> interface,\nyou can do the following things with it:\n\n=head1 SEE ALSO\n\nThis interface inherits methods from these other modules:\n\nL<Bio::SeqFeatureI>,\nL<Bio::SeqFeature::FeaturePair>\nL<Bio::SeqFeature::SimilarityPair>\n\nPlease refer to these modules for documentation of the \nmany additional inherited methods.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Steve Chervitz, Jason Stajich\n\nEmail sac-at-bioperl.org\nEmail jason-at-bioperl.org\n\n=head1 COPYRIGHT\n\nCopyright (c) 2001 Steve Chervitz, Jason Stajich. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::HSP::HSPI;\n\n\nuse strict;\nuse Carp;\n\nuse base qw(Bio::SeqFeature::SimilarityPair Bio::Root::RootI);\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the HSP\n Returns : string (e.g., BLASTP)\n Args    : none\n\n\nsub algorithm{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 pvalue\n\n Title   : pvalue\n Usage   : my $pvalue = $hsp->pvalue();\n Function: Returns the P-value for this HSP or undef \n Returns : float or exponential (2e-10)\n           P-value is not defined with NCBI Blast2 reports.\n Args    : none"}},{"definition":"sub","detail":"($self)","children":[{"localvar":"my","kind":13,"containerName":"evalue","name":"$self","line":173,"definition":"my"},{"line":174,"name":"$self","containerName":"evalue","kind":13},{"line":174,"kind":12,"containerName":"evalue","name":"throw_not_implemented"}],"name":"evalue","containerName":"main::","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: HSPI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::HSPI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n# and Jason Stajich <jason@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::HSPI - Interface for a High Scoring Pair in a similarity search result\n\n=head1 SYNOPSIS\n\n    # Bio::Search::HSP::HSPI objects cannot be instantiated since this\n    # module defines a pure interface.\n\n    # Given an object that implements the Bio::Search::HSP::HSPI  interface,\n    # you can do the following things with it:\n\n    $r_type = $hsp->algorithm;\n\n    $pvalue = $hsp->pvalue();\n\n    $evalue = $hsp->evalue();\n\n    $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n\n    $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n\n    $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n\n    $qseq = $hsp->query_string;\n\n    $hseq = $hsp->hit_string;\n\n    $homology_string = $hsp->homology_string;\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $rank = $hsp->rank;\n\n=head1 DESCRIPTION\n\nBio::Search::HSP::HSPI objects cannot be instantiated since this\nmodule defines a pure interface.\n\nGiven an object that implements the L<Bio::Search::HSP::HSPI> interface,\nyou can do the following things with it:\n\n=head1 SEE ALSO\n\nThis interface inherits methods from these other modules:\n\nL<Bio::SeqFeatureI>,\nL<Bio::SeqFeature::FeaturePair>\nL<Bio::SeqFeature::SimilarityPair>\n\nPlease refer to these modules for documentation of the \nmany additional inherited methods.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Steve Chervitz, Jason Stajich\n\nEmail sac-at-bioperl.org\nEmail jason-at-bioperl.org\n\n=head1 COPYRIGHT\n\nCopyright (c) 2001 Steve Chervitz, Jason Stajich. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::HSP::HSPI;\n\n\nuse strict;\nuse Carp;\n\nuse base qw(Bio::SeqFeature::SimilarityPair Bio::Root::RootI);\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the HSP\n Returns : string (e.g., BLASTP)\n Args    : none\n\n\nsub algorithm{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 pvalue\n\n Title   : pvalue\n Usage   : my $pvalue = $hsp->pvalue();\n Function: Returns the P-value for this HSP or undef \n Returns : float or exponential (2e-10)\n           P-value is not defined with NCBI Blast2 reports.\n Args    : none\n\n\nsub pvalue {\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 evalue\n\n Title   : evalue\n Usage   : my $evalue = $hsp->evalue();\n Function: Returns the e-value for this HSP\n Returns : float or exponential (2e-10)\n Args    : none","label":"evalue($self)"},"line":172,"range":{"start":{"line":172,"character":0},"end":{"character":9999,"line":175}},"kind":12},{"line":191,"kind":12,"range":{"start":{"character":0,"line":191},"end":{"line":194,"character":9999}},"signature":{"label":"frac_identical($self,$type)","parameters":[{"label":"$self"},{"label":"$type"}],"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: HSPI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::HSPI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n# and Jason Stajich <jason@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::HSPI - Interface for a High Scoring Pair in a similarity search result\n\n=head1 SYNOPSIS\n\n    # Bio::Search::HSP::HSPI objects cannot be instantiated since this\n    # module defines a pure interface.\n\n    # Given an object that implements the Bio::Search::HSP::HSPI  interface,\n    # you can do the following things with it:\n\n    $r_type = $hsp->algorithm;\n\n    $pvalue = $hsp->pvalue();\n\n    $evalue = $hsp->evalue();\n\n    $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n\n    $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n\n    $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n\n    $qseq = $hsp->query_string;\n\n    $hseq = $hsp->hit_string;\n\n    $homology_string = $hsp->homology_string;\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $rank = $hsp->rank;\n\n=head1 DESCRIPTION\n\nBio::Search::HSP::HSPI objects cannot be instantiated since this\nmodule defines a pure interface.\n\nGiven an object that implements the L<Bio::Search::HSP::HSPI> interface,\nyou can do the following things with it:\n\n=head1 SEE ALSO\n\nThis interface inherits methods from these other modules:\n\nL<Bio::SeqFeatureI>,\nL<Bio::SeqFeature::FeaturePair>\nL<Bio::SeqFeature::SimilarityPair>\n\nPlease refer to these modules for documentation of the \nmany additional inherited methods.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Steve Chervitz, Jason Stajich\n\nEmail sac-at-bioperl.org\nEmail jason-at-bioperl.org\n\n=head1 COPYRIGHT\n\nCopyright (c) 2001 Steve Chervitz, Jason Stajich. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::HSP::HSPI;\n\n\nuse strict;\nuse Carp;\n\nuse base qw(Bio::SeqFeature::SimilarityPair Bio::Root::RootI);\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the HSP\n Returns : string (e.g., BLASTP)\n Args    : none\n\n\nsub algorithm{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 pvalue\n\n Title   : pvalue\n Usage   : my $pvalue = $hsp->pvalue();\n Function: Returns the P-value for this HSP or undef \n Returns : float or exponential (2e-10)\n           P-value is not defined with NCBI Blast2 reports.\n Args    : none\n\n\nsub pvalue {\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 evalue\n\n Title   : evalue\n Usage   : my $evalue = $hsp->evalue();\n Function: Returns the e-value for this HSP\n Returns : float or exponential (2e-10)\n Args    : none\n\n\nsub evalue {\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : my $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n Function: Returns the fraction of identitical positions for this HSP \n Returns : Float in range 0.0 -> 1.0\n Args    : 'query' = num identical / length of query seq (without gaps)\n           'hit'   = num identical / length of hit seq (without gaps)\n           'total' = num identical / length of alignment (with gaps)\n           default = 'total' "},"children":[{"name":"$self","localvar":"my","containerName":"frac_identical","kind":13,"line":192,"definition":"my"},{"line":192,"containerName":"frac_identical","kind":13,"name":"$type"},{"line":193,"name":"$self","kind":13,"containerName":"frac_identical"},{"line":193,"kind":12,"containerName":"frac_identical","name":"throw_not_implemented"}],"name":"frac_identical","containerName":"main::","definition":"sub","detail":"($self,$type)"},{"line":211,"range":{"start":{"character":0,"line":211},"end":{"character":9999,"line":214}},"kind":12,"signature":{"label":"frac_conserved($self,$type)","documentation":"1;\n#-----------------------------------------------------------------\n# $Id: HSPI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::HSPI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n# and Jason Stajich <jason@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::HSPI - Interface for a High Scoring Pair in a similarity search result\n\n=head1 SYNOPSIS\n\n    # Bio::Search::HSP::HSPI objects cannot be instantiated since this\n    # module defines a pure interface.\n\n    # Given an object that implements the Bio::Search::HSP::HSPI  interface,\n    # you can do the following things with it:\n\n    $r_type = $hsp->algorithm;\n\n    $pvalue = $hsp->pvalue();\n\n    $evalue = $hsp->evalue();\n\n    $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n\n    $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n\n    $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n\n    $qseq = $hsp->query_string;\n\n    $hseq = $hsp->hit_string;\n\n    $homology_string = $hsp->homology_string;\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $rank = $hsp->rank;\n\n=head1 DESCRIPTION\n\nBio::Search::HSP::HSPI objects cannot be instantiated since this\nmodule defines a pure interface.\n\nGiven an object that implements the L<Bio::Search::HSP::HSPI> interface,\nyou can do the following things with it:\n\n=head1 SEE ALSO\n\nThis interface inherits methods from these other modules:\n\nL<Bio::SeqFeatureI>,\nL<Bio::SeqFeature::FeaturePair>\nL<Bio::SeqFeature::SimilarityPair>\n\nPlease refer to these modules for documentation of the \nmany additional inherited methods.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Steve Chervitz, Jason Stajich\n\nEmail sac-at-bioperl.org\nEmail jason-at-bioperl.org\n\n=head1 COPYRIGHT\n\nCopyright (c) 2001 Steve Chervitz, Jason Stajich. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::HSP::HSPI;\n\n\nuse strict;\nuse Carp;\n\nuse base qw(Bio::SeqFeature::SimilarityPair Bio::Root::RootI);\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the HSP\n Returns : string (e.g., BLASTP)\n Args    : none\n\n\nsub algorithm{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 pvalue\n\n Title   : pvalue\n Usage   : my $pvalue = $hsp->pvalue();\n Function: Returns the P-value for this HSP or undef \n Returns : float or exponential (2e-10)\n           P-value is not defined with NCBI Blast2 reports.\n Args    : none\n\n\nsub pvalue {\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 evalue\n\n Title   : evalue\n Usage   : my $evalue = $hsp->evalue();\n Function: Returns the e-value for this HSP\n Returns : float or exponential (2e-10)\n Args    : none\n\n\nsub evalue {\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : my $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n Function: Returns the fraction of identitical positions for this HSP \n Returns : Float in range 0.0 -> 1.0\n Args    : 'query' = num identical / length of query seq (without gaps)\n           'hit'   = num identical / length of hit seq (without gaps)\n           'total' = num identical / length of alignment (with gaps)\n           default = 'total' \n\n\nsub frac_identical {\n   my ($self, $type) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 frac_conserved\n\n Title    : frac_conserved\n Usage    : my $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n Function : Returns the fraction of conserved positions for this HSP.\n            This is the fraction of symbols in the alignment with a \n            positive score.\n Returns : Float in range 0.0 -> 1.0\n Args    : 'query' = num conserved / length of query seq (without gaps)\n           'hit'   = num conserved / length of hit seq (without gaps)\n           'total' = num conserved / length of alignment (with gaps)\n           default = 'total' ","parameters":[{"label":"$self"},{"label":"$type"}]},"children":[{"line":212,"name":"$self","containerName":"frac_conserved","localvar":"my","kind":13,"definition":"my"},{"line":212,"name":"$type","containerName":"frac_conserved","kind":13},{"containerName":"frac_conserved","kind":13,"name":"$self","line":213},{"containerName":"frac_conserved","kind":12,"name":"throw_not_implemented","line":213}],"name":"frac_conserved","containerName":"main::","definition":"sub","detail":"($self,$type)"},{"kind":12,"range":{"start":{"character":0,"line":227},"end":{"line":229,"character":9999}},"line":227,"name":"num_identical","containerName":"main::","children":[{"name":"throw_not_implemented","containerName":"num_identical","kind":12,"line":228}],"definition":"sub"},{"name":"num_conserved","containerName":"main::","children":[{"containerName":"num_conserved","kind":12,"name":"throw_not_implemented","line":243}],"definition":"sub","range":{"end":{"line":244,"character":9999},"start":{"line":242,"character":0}},"kind":12,"line":242},{"children":[{"definition":"my","line":260,"name":"$self","localvar":"my","kind":13,"containerName":"gaps"},{"line":260,"containerName":"gaps","kind":13,"name":"$type"},{"line":261,"name":"$self","containerName":"gaps","kind":13},{"line":261,"name":"throw_not_implemented","containerName":"gaps","kind":12}],"name":"gaps","containerName":"main::","definition":"sub","detail":"($self,$type)","line":259,"kind":12,"range":{"end":{"line":262,"character":9999},"start":{"line":259,"character":0}},"signature":{"label":"gaps($self,$type)","documentation":"1;\n#-----------------------------------------------------------------\n# $Id: HSPI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::HSPI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n# and Jason Stajich <jason@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::HSPI - Interface for a High Scoring Pair in a similarity search result\n\n=head1 SYNOPSIS\n\n    # Bio::Search::HSP::HSPI objects cannot be instantiated since this\n    # module defines a pure interface.\n\n    # Given an object that implements the Bio::Search::HSP::HSPI  interface,\n    # you can do the following things with it:\n\n    $r_type = $hsp->algorithm;\n\n    $pvalue = $hsp->pvalue();\n\n    $evalue = $hsp->evalue();\n\n    $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n\n    $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n\n    $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n\n    $qseq = $hsp->query_string;\n\n    $hseq = $hsp->hit_string;\n\n    $homology_string = $hsp->homology_string;\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $rank = $hsp->rank;\n\n=head1 DESCRIPTION\n\nBio::Search::HSP::HSPI objects cannot be instantiated since this\nmodule defines a pure interface.\n\nGiven an object that implements the L<Bio::Search::HSP::HSPI> interface,\nyou can do the following things with it:\n\n=head1 SEE ALSO\n\nThis interface inherits methods from these other modules:\n\nL<Bio::SeqFeatureI>,\nL<Bio::SeqFeature::FeaturePair>\nL<Bio::SeqFeature::SimilarityPair>\n\nPlease refer to these modules for documentation of the \nmany additional inherited methods.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Steve Chervitz, Jason Stajich\n\nEmail sac-at-bioperl.org\nEmail jason-at-bioperl.org\n\n=head1 COPYRIGHT\n\nCopyright (c) 2001 Steve Chervitz, Jason Stajich. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::HSP::HSPI;\n\n\nuse strict;\nuse Carp;\n\nuse base qw(Bio::SeqFeature::SimilarityPair Bio::Root::RootI);\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the HSP\n Returns : string (e.g., BLASTP)\n Args    : none\n\n\nsub algorithm{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 pvalue\n\n Title   : pvalue\n Usage   : my $pvalue = $hsp->pvalue();\n Function: Returns the P-value for this HSP or undef \n Returns : float or exponential (2e-10)\n           P-value is not defined with NCBI Blast2 reports.\n Args    : none\n\n\nsub pvalue {\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 evalue\n\n Title   : evalue\n Usage   : my $evalue = $hsp->evalue();\n Function: Returns the e-value for this HSP\n Returns : float or exponential (2e-10)\n Args    : none\n\n\nsub evalue {\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : my $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n Function: Returns the fraction of identitical positions for this HSP \n Returns : Float in range 0.0 -> 1.0\n Args    : 'query' = num identical / length of query seq (without gaps)\n           'hit'   = num identical / length of hit seq (without gaps)\n           'total' = num identical / length of alignment (with gaps)\n           default = 'total' \n\n\nsub frac_identical {\n   my ($self, $type) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 frac_conserved\n\n Title    : frac_conserved\n Usage    : my $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n Function : Returns the fraction of conserved positions for this HSP.\n            This is the fraction of symbols in the alignment with a \n            positive score.\n Returns : Float in range 0.0 -> 1.0\n Args    : 'query' = num conserved / length of query seq (without gaps)\n           'hit'   = num conserved / length of hit seq (without gaps)\n           'total' = num conserved / length of alignment (with gaps)\n           default = 'total' \n\n\nsub frac_conserved {\n    my ($self, $type) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 num_identical\n\n Title   : num_identical\n Usage   : $obj->num_identical($newval)\n Function: returns the number of identical residues in the alignment\n Returns : integer\n Args    : integer (optional)\n\n\n\nsub num_identical{\n    shift->throw_not_implemented;\n}\n\n=head2 num_conserved\n\n Title   : num_conserved\n Usage   : $obj->num_conserved($newval)\n Function: returns the number of conserved residues in the alignment\n Returns : inetger\n Args    : integer (optional)\n\n\n\nsub num_conserved{\n    shift->throw_not_implemented();\n}\n\n=head2 gaps\n\n Title    : gaps\n Usage    : my $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n Function : Get the number of gap characters in the query, hit, or total alignment.\n Returns  : Integer, number of gap characters or 0 if none\n Args     : 'query' = num conserved / length of query seq (without gaps)\n            'hit'   = num conserved / length of hit seq (without gaps)\n            'total' = num conserved / length of alignment (with gaps)\n            default = 'total' ","parameters":[{"label":"$self"},{"label":"$type"}]}},{"signature":{"label":"query_string($self)","documentation":"1;\n#-----------------------------------------------------------------\n# $Id: HSPI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::HSPI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n# and Jason Stajich <jason@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::HSPI - Interface for a High Scoring Pair in a similarity search result\n\n=head1 SYNOPSIS\n\n    # Bio::Search::HSP::HSPI objects cannot be instantiated since this\n    # module defines a pure interface.\n\n    # Given an object that implements the Bio::Search::HSP::HSPI  interface,\n    # you can do the following things with it:\n\n    $r_type = $hsp->algorithm;\n\n    $pvalue = $hsp->pvalue();\n\n    $evalue = $hsp->evalue();\n\n    $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n\n    $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n\n    $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n\n    $qseq = $hsp->query_string;\n\n    $hseq = $hsp->hit_string;\n\n    $homology_string = $hsp->homology_string;\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $rank = $hsp->rank;\n\n=head1 DESCRIPTION\n\nBio::Search::HSP::HSPI objects cannot be instantiated since this\nmodule defines a pure interface.\n\nGiven an object that implements the L<Bio::Search::HSP::HSPI> interface,\nyou can do the following things with it:\n\n=head1 SEE ALSO\n\nThis interface inherits methods from these other modules:\n\nL<Bio::SeqFeatureI>,\nL<Bio::SeqFeature::FeaturePair>\nL<Bio::SeqFeature::SimilarityPair>\n\nPlease refer to these modules for documentation of the \nmany additional inherited methods.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Steve Chervitz, Jason Stajich\n\nEmail sac-at-bioperl.org\nEmail jason-at-bioperl.org\n\n=head1 COPYRIGHT\n\nCopyright (c) 2001 Steve Chervitz, Jason Stajich. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::HSP::HSPI;\n\n\nuse strict;\nuse Carp;\n\nuse base qw(Bio::SeqFeature::SimilarityPair Bio::Root::RootI);\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the HSP\n Returns : string (e.g., BLASTP)\n Args    : none\n\n\nsub algorithm{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 pvalue\n\n Title   : pvalue\n Usage   : my $pvalue = $hsp->pvalue();\n Function: Returns the P-value for this HSP or undef \n Returns : float or exponential (2e-10)\n           P-value is not defined with NCBI Blast2 reports.\n Args    : none\n\n\nsub pvalue {\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 evalue\n\n Title   : evalue\n Usage   : my $evalue = $hsp->evalue();\n Function: Returns the e-value for this HSP\n Returns : float or exponential (2e-10)\n Args    : none\n\n\nsub evalue {\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : my $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n Function: Returns the fraction of identitical positions for this HSP \n Returns : Float in range 0.0 -> 1.0\n Args    : 'query' = num identical / length of query seq (without gaps)\n           'hit'   = num identical / length of hit seq (without gaps)\n           'total' = num identical / length of alignment (with gaps)\n           default = 'total' \n\n\nsub frac_identical {\n   my ($self, $type) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 frac_conserved\n\n Title    : frac_conserved\n Usage    : my $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n Function : Returns the fraction of conserved positions for this HSP.\n            This is the fraction of symbols in the alignment with a \n            positive score.\n Returns : Float in range 0.0 -> 1.0\n Args    : 'query' = num conserved / length of query seq (without gaps)\n           'hit'   = num conserved / length of hit seq (without gaps)\n           'total' = num conserved / length of alignment (with gaps)\n           default = 'total' \n\n\nsub frac_conserved {\n    my ($self, $type) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 num_identical\n\n Title   : num_identical\n Usage   : $obj->num_identical($newval)\n Function: returns the number of identical residues in the alignment\n Returns : integer\n Args    : integer (optional)\n\n\n\nsub num_identical{\n    shift->throw_not_implemented;\n}\n\n=head2 num_conserved\n\n Title   : num_conserved\n Usage   : $obj->num_conserved($newval)\n Function: returns the number of conserved residues in the alignment\n Returns : inetger\n Args    : integer (optional)\n\n\n\nsub num_conserved{\n    shift->throw_not_implemented();\n}\n\n=head2 gaps\n\n Title    : gaps\n Usage    : my $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n Function : Get the number of gap characters in the query, hit, or total alignment.\n Returns  : Integer, number of gap characters or 0 if none\n Args     : 'query' = num conserved / length of query seq (without gaps)\n            'hit'   = num conserved / length of hit seq (without gaps)\n            'total' = num conserved / length of alignment (with gaps)\n            default = 'total' \n\n\nsub gaps        {\n    my ($self, $type) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 query_string\n\n Title   : query_string\n Usage   : my $qseq = $hsp->query_string;\n Function: Retrieves the query sequence of this HSP as a string\n Returns : string\n Args    : none","parameters":[{"label":"$self"}]},"kind":12,"range":{"start":{"character":0,"line":275},"end":{"line":278,"character":9999}},"line":275,"detail":"($self)","definition":"sub","containerName":"main::","name":"query_string","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"query_string","line":276},{"kind":13,"containerName":"query_string","name":"$self","line":277},{"line":277,"kind":12,"containerName":"query_string","name":"throw_not_implemented"}]},{"line":291,"kind":12,"range":{"start":{"line":291,"character":0},"end":{"character":9999,"line":294}},"signature":{"label":"hit_string($self)","documentation":"1;\n#-----------------------------------------------------------------\n# $Id: HSPI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::HSPI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n# and Jason Stajich <jason@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::HSPI - Interface for a High Scoring Pair in a similarity search result\n\n=head1 SYNOPSIS\n\n    # Bio::Search::HSP::HSPI objects cannot be instantiated since this\n    # module defines a pure interface.\n\n    # Given an object that implements the Bio::Search::HSP::HSPI  interface,\n    # you can do the following things with it:\n\n    $r_type = $hsp->algorithm;\n\n    $pvalue = $hsp->pvalue();\n\n    $evalue = $hsp->evalue();\n\n    $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n\n    $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n\n    $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n\n    $qseq = $hsp->query_string;\n\n    $hseq = $hsp->hit_string;\n\n    $homology_string = $hsp->homology_string;\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $rank = $hsp->rank;\n\n=head1 DESCRIPTION\n\nBio::Search::HSP::HSPI objects cannot be instantiated since this\nmodule defines a pure interface.\n\nGiven an object that implements the L<Bio::Search::HSP::HSPI> interface,\nyou can do the following things with it:\n\n=head1 SEE ALSO\n\nThis interface inherits methods from these other modules:\n\nL<Bio::SeqFeatureI>,\nL<Bio::SeqFeature::FeaturePair>\nL<Bio::SeqFeature::SimilarityPair>\n\nPlease refer to these modules for documentation of the \nmany additional inherited methods.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Steve Chervitz, Jason Stajich\n\nEmail sac-at-bioperl.org\nEmail jason-at-bioperl.org\n\n=head1 COPYRIGHT\n\nCopyright (c) 2001 Steve Chervitz, Jason Stajich. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::HSP::HSPI;\n\n\nuse strict;\nuse Carp;\n\nuse base qw(Bio::SeqFeature::SimilarityPair Bio::Root::RootI);\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the HSP\n Returns : string (e.g., BLASTP)\n Args    : none\n\n\nsub algorithm{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 pvalue\n\n Title   : pvalue\n Usage   : my $pvalue = $hsp->pvalue();\n Function: Returns the P-value for this HSP or undef \n Returns : float or exponential (2e-10)\n           P-value is not defined with NCBI Blast2 reports.\n Args    : none\n\n\nsub pvalue {\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 evalue\n\n Title   : evalue\n Usage   : my $evalue = $hsp->evalue();\n Function: Returns the e-value for this HSP\n Returns : float or exponential (2e-10)\n Args    : none\n\n\nsub evalue {\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : my $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n Function: Returns the fraction of identitical positions for this HSP \n Returns : Float in range 0.0 -> 1.0\n Args    : 'query' = num identical / length of query seq (without gaps)\n           'hit'   = num identical / length of hit seq (without gaps)\n           'total' = num identical / length of alignment (with gaps)\n           default = 'total' \n\n\nsub frac_identical {\n   my ($self, $type) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 frac_conserved\n\n Title    : frac_conserved\n Usage    : my $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n Function : Returns the fraction of conserved positions for this HSP.\n            This is the fraction of symbols in the alignment with a \n            positive score.\n Returns : Float in range 0.0 -> 1.0\n Args    : 'query' = num conserved / length of query seq (without gaps)\n           'hit'   = num conserved / length of hit seq (without gaps)\n           'total' = num conserved / length of alignment (with gaps)\n           default = 'total' \n\n\nsub frac_conserved {\n    my ($self, $type) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 num_identical\n\n Title   : num_identical\n Usage   : $obj->num_identical($newval)\n Function: returns the number of identical residues in the alignment\n Returns : integer\n Args    : integer (optional)\n\n\n\nsub num_identical{\n    shift->throw_not_implemented;\n}\n\n=head2 num_conserved\n\n Title   : num_conserved\n Usage   : $obj->num_conserved($newval)\n Function: returns the number of conserved residues in the alignment\n Returns : inetger\n Args    : integer (optional)\n\n\n\nsub num_conserved{\n    shift->throw_not_implemented();\n}\n\n=head2 gaps\n\n Title    : gaps\n Usage    : my $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n Function : Get the number of gap characters in the query, hit, or total alignment.\n Returns  : Integer, number of gap characters or 0 if none\n Args     : 'query' = num conserved / length of query seq (without gaps)\n            'hit'   = num conserved / length of hit seq (without gaps)\n            'total' = num conserved / length of alignment (with gaps)\n            default = 'total' \n\n\nsub gaps        {\n    my ($self, $type) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 query_string\n\n Title   : query_string\n Usage   : my $qseq = $hsp->query_string;\n Function: Retrieves the query sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\n\nsub query_string{\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 hit_string\n\n Title   : hit_string\n Usage   : my $hseq = $hsp->hit_string;\n Function: Retrieves the hit sequence of this HSP as a string\n Returns : string\n Args    : none","parameters":[{"label":"$self"}]},"children":[{"localvar":"my","containerName":"hit_string","kind":13,"name":"$self","line":292,"definition":"my"},{"line":293,"containerName":"hit_string","kind":13,"name":"$self"},{"line":293,"containerName":"hit_string","kind":12,"name":"throw_not_implemented"}],"containerName":"main::","name":"hit_string","definition":"sub","detail":"($self)"},{"signature":{"label":"homology_string($self)","parameters":[{"label":"$self"}],"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: HSPI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::HSPI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n# and Jason Stajich <jason@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::HSPI - Interface for a High Scoring Pair in a similarity search result\n\n=head1 SYNOPSIS\n\n    # Bio::Search::HSP::HSPI objects cannot be instantiated since this\n    # module defines a pure interface.\n\n    # Given an object that implements the Bio::Search::HSP::HSPI  interface,\n    # you can do the following things with it:\n\n    $r_type = $hsp->algorithm;\n\n    $pvalue = $hsp->pvalue();\n\n    $evalue = $hsp->evalue();\n\n    $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n\n    $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n\n    $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n\n    $qseq = $hsp->query_string;\n\n    $hseq = $hsp->hit_string;\n\n    $homology_string = $hsp->homology_string;\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $rank = $hsp->rank;\n\n=head1 DESCRIPTION\n\nBio::Search::HSP::HSPI objects cannot be instantiated since this\nmodule defines a pure interface.\n\nGiven an object that implements the L<Bio::Search::HSP::HSPI> interface,\nyou can do the following things with it:\n\n=head1 SEE ALSO\n\nThis interface inherits methods from these other modules:\n\nL<Bio::SeqFeatureI>,\nL<Bio::SeqFeature::FeaturePair>\nL<Bio::SeqFeature::SimilarityPair>\n\nPlease refer to these modules for documentation of the \nmany additional inherited methods.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Steve Chervitz, Jason Stajich\n\nEmail sac-at-bioperl.org\nEmail jason-at-bioperl.org\n\n=head1 COPYRIGHT\n\nCopyright (c) 2001 Steve Chervitz, Jason Stajich. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::HSP::HSPI;\n\n\nuse strict;\nuse Carp;\n\nuse base qw(Bio::SeqFeature::SimilarityPair Bio::Root::RootI);\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the HSP\n Returns : string (e.g., BLASTP)\n Args    : none\n\n\nsub algorithm{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 pvalue\n\n Title   : pvalue\n Usage   : my $pvalue = $hsp->pvalue();\n Function: Returns the P-value for this HSP or undef \n Returns : float or exponential (2e-10)\n           P-value is not defined with NCBI Blast2 reports.\n Args    : none\n\n\nsub pvalue {\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 evalue\n\n Title   : evalue\n Usage   : my $evalue = $hsp->evalue();\n Function: Returns the e-value for this HSP\n Returns : float or exponential (2e-10)\n Args    : none\n\n\nsub evalue {\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : my $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n Function: Returns the fraction of identitical positions for this HSP \n Returns : Float in range 0.0 -> 1.0\n Args    : 'query' = num identical / length of query seq (without gaps)\n           'hit'   = num identical / length of hit seq (without gaps)\n           'total' = num identical / length of alignment (with gaps)\n           default = 'total' \n\n\nsub frac_identical {\n   my ($self, $type) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 frac_conserved\n\n Title    : frac_conserved\n Usage    : my $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n Function : Returns the fraction of conserved positions for this HSP.\n            This is the fraction of symbols in the alignment with a \n            positive score.\n Returns : Float in range 0.0 -> 1.0\n Args    : 'query' = num conserved / length of query seq (without gaps)\n           'hit'   = num conserved / length of hit seq (without gaps)\n           'total' = num conserved / length of alignment (with gaps)\n           default = 'total' \n\n\nsub frac_conserved {\n    my ($self, $type) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 num_identical\n\n Title   : num_identical\n Usage   : $obj->num_identical($newval)\n Function: returns the number of identical residues in the alignment\n Returns : integer\n Args    : integer (optional)\n\n\n\nsub num_identical{\n    shift->throw_not_implemented;\n}\n\n=head2 num_conserved\n\n Title   : num_conserved\n Usage   : $obj->num_conserved($newval)\n Function: returns the number of conserved residues in the alignment\n Returns : inetger\n Args    : integer (optional)\n\n\n\nsub num_conserved{\n    shift->throw_not_implemented();\n}\n\n=head2 gaps\n\n Title    : gaps\n Usage    : my $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n Function : Get the number of gap characters in the query, hit, or total alignment.\n Returns  : Integer, number of gap characters or 0 if none\n Args     : 'query' = num conserved / length of query seq (without gaps)\n            'hit'   = num conserved / length of hit seq (without gaps)\n            'total' = num conserved / length of alignment (with gaps)\n            default = 'total' \n\n\nsub gaps        {\n    my ($self, $type) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 query_string\n\n Title   : query_string\n Usage   : my $qseq = $hsp->query_string;\n Function: Retrieves the query sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\n\nsub query_string{\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 hit_string\n\n Title   : hit_string\n Usage   : my $hseq = $hsp->hit_string;\n Function: Retrieves the hit sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\n\nsub hit_string{\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 homology_string\n\n Title   : homology_string\n Usage   : my $homo_string = $hsp->homology_string;\n Function: Retrieves the homology sequence for this HSP as a string.\n         : The homology sequence is the string of symbols in between the \n         : query and hit sequences in the alignment indicating the degree\n         : of conservation (e.g., identical, similar, not similar).\n Returns : string\n Args    : none"},"range":{"end":{"line":312,"character":9999},"start":{"line":309,"character":0}},"kind":12,"line":309,"detail":"($self)","definition":"sub","name":"homology_string","containerName":"main::","children":[{"localvar":"my","containerName":"homology_string","kind":13,"name":"$self","line":310,"definition":"my"},{"containerName":"homology_string","kind":13,"name":"$self","line":311},{"name":"throw_not_implemented","kind":12,"containerName":"homology_string","line":311}]},{"definition":"sub","children":[{"line":331,"kind":12,"containerName":"length","name":"throw_not_implemented"}],"name":"length","containerName":"main::","line":330,"range":{"start":{"character":0,"line":330},"end":{"line":332,"character":9999}},"kind":12},{"line":345,"range":{"end":{"character":9999,"line":348},"start":{"line":345,"character":0}},"kind":12,"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: HSPI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::HSPI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n# and Jason Stajich <jason@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::HSPI - Interface for a High Scoring Pair in a similarity search result\n\n=head1 SYNOPSIS\n\n    # Bio::Search::HSP::HSPI objects cannot be instantiated since this\n    # module defines a pure interface.\n\n    # Given an object that implements the Bio::Search::HSP::HSPI  interface,\n    # you can do the following things with it:\n\n    $r_type = $hsp->algorithm;\n\n    $pvalue = $hsp->pvalue();\n\n    $evalue = $hsp->evalue();\n\n    $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n\n    $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n\n    $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n\n    $qseq = $hsp->query_string;\n\n    $hseq = $hsp->hit_string;\n\n    $homology_string = $hsp->homology_string;\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $rank = $hsp->rank;\n\n=head1 DESCRIPTION\n\nBio::Search::HSP::HSPI objects cannot be instantiated since this\nmodule defines a pure interface.\n\nGiven an object that implements the L<Bio::Search::HSP::HSPI> interface,\nyou can do the following things with it:\n\n=head1 SEE ALSO\n\nThis interface inherits methods from these other modules:\n\nL<Bio::SeqFeatureI>,\nL<Bio::SeqFeature::FeaturePair>\nL<Bio::SeqFeature::SimilarityPair>\n\nPlease refer to these modules for documentation of the \nmany additional inherited methods.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Steve Chervitz, Jason Stajich\n\nEmail sac-at-bioperl.org\nEmail jason-at-bioperl.org\n\n=head1 COPYRIGHT\n\nCopyright (c) 2001 Steve Chervitz, Jason Stajich. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::HSP::HSPI;\n\n\nuse strict;\nuse Carp;\n\nuse base qw(Bio::SeqFeature::SimilarityPair Bio::Root::RootI);\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the HSP\n Returns : string (e.g., BLASTP)\n Args    : none\n\n\nsub algorithm{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 pvalue\n\n Title   : pvalue\n Usage   : my $pvalue = $hsp->pvalue();\n Function: Returns the P-value for this HSP or undef \n Returns : float or exponential (2e-10)\n           P-value is not defined with NCBI Blast2 reports.\n Args    : none\n\n\nsub pvalue {\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 evalue\n\n Title   : evalue\n Usage   : my $evalue = $hsp->evalue();\n Function: Returns the e-value for this HSP\n Returns : float or exponential (2e-10)\n Args    : none\n\n\nsub evalue {\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : my $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n Function: Returns the fraction of identitical positions for this HSP \n Returns : Float in range 0.0 -> 1.0\n Args    : 'query' = num identical / length of query seq (without gaps)\n           'hit'   = num identical / length of hit seq (without gaps)\n           'total' = num identical / length of alignment (with gaps)\n           default = 'total' \n\n\nsub frac_identical {\n   my ($self, $type) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 frac_conserved\n\n Title    : frac_conserved\n Usage    : my $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n Function : Returns the fraction of conserved positions for this HSP.\n            This is the fraction of symbols in the alignment with a \n            positive score.\n Returns : Float in range 0.0 -> 1.0\n Args    : 'query' = num conserved / length of query seq (without gaps)\n           'hit'   = num conserved / length of hit seq (without gaps)\n           'total' = num conserved / length of alignment (with gaps)\n           default = 'total' \n\n\nsub frac_conserved {\n    my ($self, $type) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 num_identical\n\n Title   : num_identical\n Usage   : $obj->num_identical($newval)\n Function: returns the number of identical residues in the alignment\n Returns : integer\n Args    : integer (optional)\n\n\n\nsub num_identical{\n    shift->throw_not_implemented;\n}\n\n=head2 num_conserved\n\n Title   : num_conserved\n Usage   : $obj->num_conserved($newval)\n Function: returns the number of conserved residues in the alignment\n Returns : inetger\n Args    : integer (optional)\n\n\n\nsub num_conserved{\n    shift->throw_not_implemented();\n}\n\n=head2 gaps\n\n Title    : gaps\n Usage    : my $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n Function : Get the number of gap characters in the query, hit, or total alignment.\n Returns  : Integer, number of gap characters or 0 if none\n Args     : 'query' = num conserved / length of query seq (without gaps)\n            'hit'   = num conserved / length of hit seq (without gaps)\n            'total' = num conserved / length of alignment (with gaps)\n            default = 'total' \n\n\nsub gaps        {\n    my ($self, $type) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 query_string\n\n Title   : query_string\n Usage   : my $qseq = $hsp->query_string;\n Function: Retrieves the query sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\n\nsub query_string{\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 hit_string\n\n Title   : hit_string\n Usage   : my $hseq = $hsp->hit_string;\n Function: Retrieves the hit sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\n\nsub hit_string{\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 homology_string\n\n Title   : homology_string\n Usage   : my $homo_string = $hsp->homology_string;\n Function: Retrieves the homology sequence for this HSP as a string.\n         : The homology sequence is the string of symbols in between the \n         : query and hit sequences in the alignment indicating the degree\n         : of conservation (e.g., identical, similar, not similar).\n Returns : string\n Args    : none\n\n\nsub homology_string{\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 length\n\n Title    : length\n Usage    : my $len = $hsp->length( ['query'|'hit'|'total'] );\n Function : Returns the length of the query or hit in the alignment (without gaps) \n            or the aggregate length of the HSP (including gaps;\n            this may be greater than either hit or query )\n Returns  : integer\n Args     : 'query' = length of query seq (without gaps)\n            'hit'   = length of hit seq (without gaps)\n            'total' = length of alignment (with gaps)\n            default = 'total' \n Args    : none\n\n\nsub length{\n    shift->throw_not_implemented();\n}\n\n=head2 percent_identity\n\n Title   : percent_identity\n Usage   : my $percentid = $hsp->percent_identity()\n Function: Returns the calculated percent identity for an HSP\n Returns : floating point between 0 and 100 \n Args    : none","label":"percent_identity($self)"},"children":[{"definition":"my","name":"$self","localvar":"my","containerName":"percent_identity","kind":13,"line":346},{"line":347,"name":"$self","kind":13,"containerName":"percent_identity"},{"containerName":"percent_identity","kind":12,"name":"frac_identical","line":347}],"containerName":"main::","name":"percent_identity","definition":"sub","detail":"($self)"},{"children":[{"definition":"my","kind":13,"localvar":"my","containerName":"get_aln","name":"$self","line":361},{"line":362,"name":"$self","containerName":"get_aln","kind":13},{"line":362,"kind":12,"containerName":"get_aln","name":"throw_not_implemented"}],"containerName":"main::","name":"get_aln","definition":"sub","detail":"($self)","line":360,"range":{"end":{"line":363,"character":9999},"start":{"line":360,"character":0}},"kind":12,"signature":{"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: HSPI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::HSPI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n# and Jason Stajich <jason@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::HSPI - Interface for a High Scoring Pair in a similarity search result\n\n=head1 SYNOPSIS\n\n    # Bio::Search::HSP::HSPI objects cannot be instantiated since this\n    # module defines a pure interface.\n\n    # Given an object that implements the Bio::Search::HSP::HSPI  interface,\n    # you can do the following things with it:\n\n    $r_type = $hsp->algorithm;\n\n    $pvalue = $hsp->pvalue();\n\n    $evalue = $hsp->evalue();\n\n    $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n\n    $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n\n    $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n\n    $qseq = $hsp->query_string;\n\n    $hseq = $hsp->hit_string;\n\n    $homology_string = $hsp->homology_string;\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $rank = $hsp->rank;\n\n=head1 DESCRIPTION\n\nBio::Search::HSP::HSPI objects cannot be instantiated since this\nmodule defines a pure interface.\n\nGiven an object that implements the L<Bio::Search::HSP::HSPI> interface,\nyou can do the following things with it:\n\n=head1 SEE ALSO\n\nThis interface inherits methods from these other modules:\n\nL<Bio::SeqFeatureI>,\nL<Bio::SeqFeature::FeaturePair>\nL<Bio::SeqFeature::SimilarityPair>\n\nPlease refer to these modules for documentation of the \nmany additional inherited methods.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Steve Chervitz, Jason Stajich\n\nEmail sac-at-bioperl.org\nEmail jason-at-bioperl.org\n\n=head1 COPYRIGHT\n\nCopyright (c) 2001 Steve Chervitz, Jason Stajich. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::HSP::HSPI;\n\n\nuse strict;\nuse Carp;\n\nuse base qw(Bio::SeqFeature::SimilarityPair Bio::Root::RootI);\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the HSP\n Returns : string (e.g., BLASTP)\n Args    : none\n\n\nsub algorithm{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 pvalue\n\n Title   : pvalue\n Usage   : my $pvalue = $hsp->pvalue();\n Function: Returns the P-value for this HSP or undef \n Returns : float or exponential (2e-10)\n           P-value is not defined with NCBI Blast2 reports.\n Args    : none\n\n\nsub pvalue {\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 evalue\n\n Title   : evalue\n Usage   : my $evalue = $hsp->evalue();\n Function: Returns the e-value for this HSP\n Returns : float or exponential (2e-10)\n Args    : none\n\n\nsub evalue {\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : my $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n Function: Returns the fraction of identitical positions for this HSP \n Returns : Float in range 0.0 -> 1.0\n Args    : 'query' = num identical / length of query seq (without gaps)\n           'hit'   = num identical / length of hit seq (without gaps)\n           'total' = num identical / length of alignment (with gaps)\n           default = 'total' \n\n\nsub frac_identical {\n   my ($self, $type) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 frac_conserved\n\n Title    : frac_conserved\n Usage    : my $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n Function : Returns the fraction of conserved positions for this HSP.\n            This is the fraction of symbols in the alignment with a \n            positive score.\n Returns : Float in range 0.0 -> 1.0\n Args    : 'query' = num conserved / length of query seq (without gaps)\n           'hit'   = num conserved / length of hit seq (without gaps)\n           'total' = num conserved / length of alignment (with gaps)\n           default = 'total' \n\n\nsub frac_conserved {\n    my ($self, $type) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 num_identical\n\n Title   : num_identical\n Usage   : $obj->num_identical($newval)\n Function: returns the number of identical residues in the alignment\n Returns : integer\n Args    : integer (optional)\n\n\n\nsub num_identical{\n    shift->throw_not_implemented;\n}\n\n=head2 num_conserved\n\n Title   : num_conserved\n Usage   : $obj->num_conserved($newval)\n Function: returns the number of conserved residues in the alignment\n Returns : inetger\n Args    : integer (optional)\n\n\n\nsub num_conserved{\n    shift->throw_not_implemented();\n}\n\n=head2 gaps\n\n Title    : gaps\n Usage    : my $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n Function : Get the number of gap characters in the query, hit, or total alignment.\n Returns  : Integer, number of gap characters or 0 if none\n Args     : 'query' = num conserved / length of query seq (without gaps)\n            'hit'   = num conserved / length of hit seq (without gaps)\n            'total' = num conserved / length of alignment (with gaps)\n            default = 'total' \n\n\nsub gaps        {\n    my ($self, $type) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 query_string\n\n Title   : query_string\n Usage   : my $qseq = $hsp->query_string;\n Function: Retrieves the query sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\n\nsub query_string{\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 hit_string\n\n Title   : hit_string\n Usage   : my $hseq = $hsp->hit_string;\n Function: Retrieves the hit sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\n\nsub hit_string{\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 homology_string\n\n Title   : homology_string\n Usage   : my $homo_string = $hsp->homology_string;\n Function: Retrieves the homology sequence for this HSP as a string.\n         : The homology sequence is the string of symbols in between the \n         : query and hit sequences in the alignment indicating the degree\n         : of conservation (e.g., identical, similar, not similar).\n Returns : string\n Args    : none\n\n\nsub homology_string{\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 length\n\n Title    : length\n Usage    : my $len = $hsp->length( ['query'|'hit'|'total'] );\n Function : Returns the length of the query or hit in the alignment (without gaps) \n            or the aggregate length of the HSP (including gaps;\n            this may be greater than either hit or query )\n Returns  : integer\n Args     : 'query' = length of query seq (without gaps)\n            'hit'   = length of hit seq (without gaps)\n            'total' = length of alignment (with gaps)\n            default = 'total' \n Args    : none\n\n\nsub length{\n    shift->throw_not_implemented();\n}\n\n=head2 percent_identity\n\n Title   : percent_identity\n Usage   : my $percentid = $hsp->percent_identity()\n Function: Returns the calculated percent identity for an HSP\n Returns : floating point between 0 and 100 \n Args    : none\n\n\n\nsub percent_identity{\n   my ($self) = @_;\n   return $self->frac_identical('hsp') * 100;   \n}\n\n=head2 get_aln\n\n Title   : get_aln\n Usage   : my $aln = $hsp->get_aln\n Function: Returns a Bio::SimpleAlign representing the HSP alignment\n Returns : Bio::SimpleAlign\n Args    : none","parameters":[{"label":"$self"}],"label":"get_aln($self)"}},{"definition":"sub","name":"seq_inds","containerName":"main::","children":[{"name":"throw_not_implemented","kind":12,"containerName":"seq_inds","line":394}],"kind":12,"range":{"end":{"line":395,"character":9999},"start":{"character":0,"line":393}},"line":393},{"definition":"sub","name":"strand","containerName":"main::","children":[{"localvar":"my","containerName":"strand","kind":13,"name":"$self","line":462,"definition":"my"},{"line":463,"containerName":"strand","localvar":"my","kind":13,"name":"$val","definition":"my"},{"containerName":"strand","kind":13,"name":"$val","line":464},{"line":464,"containerName":"strand","kind":13,"name":"$val"},{"line":465,"kind":13,"containerName":"strand","name":"$val"},{"line":467,"containerName":"strand","kind":13,"name":"$val"},{"line":468,"containerName":"strand","kind":13,"name":"$self"},{"name":"query","containerName":"strand","kind":12,"line":468},{"line":468,"name":"strand","containerName":"strand","kind":12},{"line":469,"kind":13,"containerName":"strand","name":"$val"},{"kind":13,"containerName":"strand","name":"$self","line":470},{"line":470,"containerName":"strand","kind":12,"name":"hit"},{"line":470,"containerName":"strand","kind":12,"name":"strand"},{"kind":13,"containerName":"strand","name":"$val","line":471},{"line":475,"containerName":"strand","kind":13,"name":"$self"},{"containerName":"strand","kind":12,"name":"query","line":475},{"line":475,"kind":12,"containerName":"strand","name":"strand"},{"line":476,"containerName":"strand","kind":13,"name":"$self"},{"line":476,"kind":12,"containerName":"strand","name":"hit"},{"line":476,"kind":12,"containerName":"strand","name":"strand"},{"name":"$self","kind":13,"containerName":"strand","line":478},{"line":478,"name":"warn","containerName":"strand","kind":12}],"kind":12,"range":{"end":{"character":9999,"line":481},"start":{"character":0,"line":461}},"line":461},{"definition":"sub","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"start","line":495},{"line":496,"name":"$val","localvar":"my","containerName":"start","kind":13,"definition":"my"},{"name":"$val","containerName":"start","kind":13,"line":497},{"line":497,"kind":13,"containerName":"start","name":"$val"},{"line":498,"kind":13,"containerName":"start","name":"$val"},{"line":500,"name":"$val","containerName":"start","kind":13},{"line":501,"kind":13,"containerName":"start","name":"$self"},{"line":501,"containerName":"start","kind":12,"name":"query"},{"name":"start","containerName":"start","kind":12,"line":501},{"kind":13,"containerName":"start","name":"$val","line":502},{"line":503,"name":"$self","containerName":"start","kind":13},{"line":503,"containerName":"start","kind":12,"name":"hit"},{"line":503,"kind":12,"containerName":"start","name":"start"},{"line":504,"name":"$val","kind":13,"containerName":"start"},{"line":508,"name":"$self","kind":13,"containerName":"start"},{"line":508,"name":"query","containerName":"start","kind":12},{"kind":12,"containerName":"start","name":"start","line":508},{"name":"$self","kind":13,"containerName":"start","line":509},{"kind":12,"containerName":"start","name":"hit","line":509},{"line":509,"name":"start","kind":12,"containerName":"start"},{"name":"$self","kind":13,"containerName":"start","line":511},{"name":"warn","kind":12,"containerName":"start","line":511}],"containerName":"main::","name":"start","line":494,"range":{"start":{"line":494,"character":0},"end":{"character":9999,"line":514}},"kind":12},{"children":[{"name":"$self","localvar":"my","kind":13,"containerName":"end","line":528,"definition":"my"},{"name":"$val","containerName":"end","localvar":"my","kind":13,"line":529,"definition":"my"},{"name":"$val","kind":13,"containerName":"end","line":530},{"line":530,"kind":13,"containerName":"end","name":"$val"},{"line":531,"name":"$val","containerName":"end","kind":13},{"line":533,"containerName":"end","kind":13,"name":"$val"},{"name":"$self","containerName":"end","kind":13,"line":534},{"line":534,"kind":12,"containerName":"end","name":"query"},{"name":"end","containerName":"end","kind":12,"line":534},{"line":535,"containerName":"end","kind":13,"name":"$val"},{"name":"$self","containerName":"end","kind":13,"line":536},{"line":536,"containerName":"end","kind":12,"name":"hit"},{"name":"end","kind":12,"containerName":"end","line":536},{"name":"$val","kind":13,"containerName":"end","line":537},{"line":541,"name":"$self","kind":13,"containerName":"end"},{"kind":12,"containerName":"end","name":"query","line":541},{"line":541,"kind":12,"containerName":"end","name":"end"},{"line":542,"containerName":"end","kind":13,"name":"$self"},{"line":542,"name":"hit","containerName":"end","kind":12},{"name":"end","containerName":"end","kind":12,"line":542},{"line":544,"kind":13,"containerName":"end","name":"$self"},{"name":"warn","kind":12,"containerName":"end","line":544}],"name":"end","containerName":"main::","definition":"sub","line":527,"kind":12,"range":{"start":{"character":0,"line":527},"end":{"line":547,"character":9999}}},{"detail":"($self,$seqType)","definition":"sub","containerName":"main::","name":"seq","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"seq","name":"$self","line":569},{"name":"$seqType","containerName":"seq","kind":13,"line":569},{"line":570,"name":"$seqType","containerName":"seq","kind":13},{"line":571,"containerName":"seq","kind":13,"name":"$seqType"},{"line":571,"name":"$seqType","containerName":"seq","kind":13},{"definition":"my","line":572,"localvar":"my","containerName":"seq","kind":13,"name":"$str"},{"kind":13,"containerName":"seq","name":"$self","line":572},{"kind":12,"containerName":"seq","name":"seq_str","line":572},{"line":572,"name":"$seqType","containerName":"seq","kind":13},{"line":573,"containerName":"seq","kind":13,"name":"$seqType"},{"name":"$self","containerName":"seq","kind":13,"line":574},{"kind":12,"containerName":"seq","name":"throw","line":574},{"definition":"my","name":"$id","localvar":"my","containerName":"seq","kind":13,"line":577},{"line":577,"name":"$seqType","kind":13,"containerName":"seq"},{"line":577,"kind":13,"containerName":"seq","name":"$self"},{"name":"query","containerName":"seq","kind":12,"line":577},{"line":577,"containerName":"seq","kind":12,"name":"seq_id"},{"containerName":"seq","kind":13,"name":"$self","line":577},{"line":577,"kind":12,"containerName":"seq","name":"hit"},{"line":577,"containerName":"seq","kind":12,"name":"seq_id"},{"name":"new","kind":12,"containerName":"seq","line":578},{"line":578,"name":"$id","kind":13,"containerName":"seq"},{"line":579,"name":"$str","kind":13,"containerName":"seq"},{"name":"$self","containerName":"seq","kind":13,"line":580},{"line":580,"name":"start","containerName":"seq","kind":12},{"line":580,"name":"$seqType","kind":13,"containerName":"seq"},{"name":"$self","kind":13,"containerName":"seq","line":581},{"name":"end","kind":12,"containerName":"seq","line":581},{"name":"$seqType","kind":13,"containerName":"seq","line":581},{"line":582,"name":"$self","kind":13,"containerName":"seq"},{"name":"strand","containerName":"seq","kind":12,"line":582},{"name":"$seqType","kind":13,"containerName":"seq","line":582},{"kind":13,"containerName":"seq","name":"$id","line":583}],"signature":{"label":"seq($self,$seqType)","documentation":"1;\n#-----------------------------------------------------------------\n# $Id: HSPI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::HSPI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n# and Jason Stajich <jason@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::HSPI - Interface for a High Scoring Pair in a similarity search result\n\n=head1 SYNOPSIS\n\n    # Bio::Search::HSP::HSPI objects cannot be instantiated since this\n    # module defines a pure interface.\n\n    # Given an object that implements the Bio::Search::HSP::HSPI  interface,\n    # you can do the following things with it:\n\n    $r_type = $hsp->algorithm;\n\n    $pvalue = $hsp->pvalue();\n\n    $evalue = $hsp->evalue();\n\n    $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n\n    $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n\n    $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n\n    $qseq = $hsp->query_string;\n\n    $hseq = $hsp->hit_string;\n\n    $homology_string = $hsp->homology_string;\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $rank = $hsp->rank;\n\n=head1 DESCRIPTION\n\nBio::Search::HSP::HSPI objects cannot be instantiated since this\nmodule defines a pure interface.\n\nGiven an object that implements the L<Bio::Search::HSP::HSPI> interface,\nyou can do the following things with it:\n\n=head1 SEE ALSO\n\nThis interface inherits methods from these other modules:\n\nL<Bio::SeqFeatureI>,\nL<Bio::SeqFeature::FeaturePair>\nL<Bio::SeqFeature::SimilarityPair>\n\nPlease refer to these modules for documentation of the \nmany additional inherited methods.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Steve Chervitz, Jason Stajich\n\nEmail sac-at-bioperl.org\nEmail jason-at-bioperl.org\n\n=head1 COPYRIGHT\n\nCopyright (c) 2001 Steve Chervitz, Jason Stajich. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::HSP::HSPI;\n\n\nuse strict;\nuse Carp;\n\nuse base qw(Bio::SeqFeature::SimilarityPair Bio::Root::RootI);\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the HSP\n Returns : string (e.g., BLASTP)\n Args    : none\n\n\nsub algorithm{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 pvalue\n\n Title   : pvalue\n Usage   : my $pvalue = $hsp->pvalue();\n Function: Returns the P-value for this HSP or undef \n Returns : float or exponential (2e-10)\n           P-value is not defined with NCBI Blast2 reports.\n Args    : none\n\n\nsub pvalue {\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 evalue\n\n Title   : evalue\n Usage   : my $evalue = $hsp->evalue();\n Function: Returns the e-value for this HSP\n Returns : float or exponential (2e-10)\n Args    : none\n\n\nsub evalue {\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : my $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n Function: Returns the fraction of identitical positions for this HSP \n Returns : Float in range 0.0 -> 1.0\n Args    : 'query' = num identical / length of query seq (without gaps)\n           'hit'   = num identical / length of hit seq (without gaps)\n           'total' = num identical / length of alignment (with gaps)\n           default = 'total' \n\n\nsub frac_identical {\n   my ($self, $type) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 frac_conserved\n\n Title    : frac_conserved\n Usage    : my $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n Function : Returns the fraction of conserved positions for this HSP.\n            This is the fraction of symbols in the alignment with a \n            positive score.\n Returns : Float in range 0.0 -> 1.0\n Args    : 'query' = num conserved / length of query seq (without gaps)\n           'hit'   = num conserved / length of hit seq (without gaps)\n           'total' = num conserved / length of alignment (with gaps)\n           default = 'total' \n\n\nsub frac_conserved {\n    my ($self, $type) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 num_identical\n\n Title   : num_identical\n Usage   : $obj->num_identical($newval)\n Function: returns the number of identical residues in the alignment\n Returns : integer\n Args    : integer (optional)\n\n\n\nsub num_identical{\n    shift->throw_not_implemented;\n}\n\n=head2 num_conserved\n\n Title   : num_conserved\n Usage   : $obj->num_conserved($newval)\n Function: returns the number of conserved residues in the alignment\n Returns : inetger\n Args    : integer (optional)\n\n\n\nsub num_conserved{\n    shift->throw_not_implemented();\n}\n\n=head2 gaps\n\n Title    : gaps\n Usage    : my $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n Function : Get the number of gap characters in the query, hit, or total alignment.\n Returns  : Integer, number of gap characters or 0 if none\n Args     : 'query' = num conserved / length of query seq (without gaps)\n            'hit'   = num conserved / length of hit seq (without gaps)\n            'total' = num conserved / length of alignment (with gaps)\n            default = 'total' \n\n\nsub gaps        {\n    my ($self, $type) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 query_string\n\n Title   : query_string\n Usage   : my $qseq = $hsp->query_string;\n Function: Retrieves the query sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\n\nsub query_string{\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 hit_string\n\n Title   : hit_string\n Usage   : my $hseq = $hsp->hit_string;\n Function: Retrieves the hit sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\n\nsub hit_string{\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 homology_string\n\n Title   : homology_string\n Usage   : my $homo_string = $hsp->homology_string;\n Function: Retrieves the homology sequence for this HSP as a string.\n         : The homology sequence is the string of symbols in between the \n         : query and hit sequences in the alignment indicating the degree\n         : of conservation (e.g., identical, similar, not similar).\n Returns : string\n Args    : none\n\n\nsub homology_string{\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 length\n\n Title    : length\n Usage    : my $len = $hsp->length( ['query'|'hit'|'total'] );\n Function : Returns the length of the query or hit in the alignment (without gaps) \n            or the aggregate length of the HSP (including gaps;\n            this may be greater than either hit or query )\n Returns  : integer\n Args     : 'query' = length of query seq (without gaps)\n            'hit'   = length of hit seq (without gaps)\n            'total' = length of alignment (with gaps)\n            default = 'total' \n Args    : none\n\n\nsub length{\n    shift->throw_not_implemented();\n}\n\n=head2 percent_identity\n\n Title   : percent_identity\n Usage   : my $percentid = $hsp->percent_identity()\n Function: Returns the calculated percent identity for an HSP\n Returns : floating point between 0 and 100 \n Args    : none\n\n\n\nsub percent_identity{\n   my ($self) = @_;\n   return $self->frac_identical('hsp') * 100;   \n}\n\n=head2 get_aln\n\n Title   : get_aln\n Usage   : my $aln = $hsp->get_aln\n Function: Returns a Bio::SimpleAlign representing the HSP alignment\n Returns : Bio::SimpleAlign\n Args    : none\n\n\nsub get_aln {\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n\n=head2 seq_inds\n\n Title   : seq_inds\n Purpose   : Get a list of residue positions (indices) for all identical \n           : or conserved residues in the query or sbjct sequence.\n Example   : @s_ind = $hsp->seq_inds('query', 'identical');\n           : @h_ind = $hsp->seq_inds('hit', 'conserved');\n           : @h_ind = $hsp->seq_inds('hit', 'conserved', 1);\n Returns   : List of integers \n           : May include ranges if collapse is true.\n Argument  : seq_type  = 'query' or 'hit' or 'sbjct'  (default = query)\n              ('sbjct' is synonymous with 'hit') \n             class     = 'identical' or 'conserved' or 'nomatch' or 'gap'\n                          (default = identical)\n                          (can be shortened to 'id' or 'cons')\n\n             collapse  = boolean, if true, consecutive positions are merged\n                         using a range notation, e.g., \"1 2 3 4 5 7 9 10 11\" \n                         collapses to \"1-5 7 9-11\". This is useful for \n                         consolidating long lists. Default = no collapse.\n Throws    : n/a.\n Comments  : \n\nSee Also   : L<Bio::Search::BlastUtils::collapse_nums()|Bio::Search::BlastUtils>, L<Bio::Search::Hit::HitI::seq_inds()|Bio::Search::Hit::HitI>\n\n\nsub seq_inds {\n    shift->throw_not_implemented();\n}\n\n=head2 Inherited from L<Bio::SeqFeature::SimilarityPair>\n\nThese methods come from L<Bio::SeqFeature::SimilarityPair>\n\n=head2 query\n\n Title   : query\n Usage   : my $query = $hsp->query\n Function: Returns a SeqFeature representing the query in the HSP\n Returns : Bio::SeqFeature::Similarity\n Args    : [optional] new value to set\n\n\n=head2 hit\n\n Title   : hit\n Usage   : my $hit = $hsp->hit\n Function: Returns a SeqFeature representing the hit in the HSP\n Returns : Bio::SeqFeature::Similarity\n Args    : [optional] new value to set\n\n\n=head2 significance\n\n Title   : significance\n Usage   : $evalue = $obj->significance();\n           $obj->significance($evalue);\n Function: Get/Set the significance value (see Bio::SeqFeature::SimilarityPair)\n Returns : significance value (scientific notation string)\n Args    : significance value (sci notation string)\n\n\n=head2 score\n\n Title   : score\n Usage   : my $score = $hsp->score();\n Function: Returns the score for this HSP or undef \n Returns : numeric           \n Args    : [optional] numeric to set value\n\n=head2 bits\n\n Title   : bits\n Usage   : my $bits = $hsp->bits();\n Function: Returns the bit value for this HSP or undef \n Returns : numeric\n Args    : none\n\n\n# override \n\n=head2 strand\n\n Title   : strand\n Usage   : $hsp->strand('query')\n Function: Retrieves the strand for the HSP component requested\n Returns : +1 or -1 (0 if unknown)\n Args    : 'hit' or 'subject' or 'sbjct' to retrieve the strand of the subject\n           'query' to retrieve the query strand (default)\n           'list' or 'array' to retreive both query and hit together\n\n\nsub strand {\n    my $self = shift;\n    my $val = shift;\n    $val = 'query' unless defined $val;\n    $val =~ s/^\\s+//;\n\n    if( $val =~ /^q/i ) {\n\treturn $self->query->strand(@_);\n    } elsif( $val =~ /^hi|^s/i ) {\n\treturn $self->hit->strand(@_);\n    } elsif (  $val =~ /^list|array/i ) {\n\t# do we really need to pass on additional arguments here? HL\n\t# (formerly this was strand(shift) which is really bad coding because\n\t# it breaks if the callee allows setting to undef)\n\treturn ($self->query->strand(@_), \n\t\t$self->hit->strand(@_) );\n    } else { \n\t$self->warn(\"unrecognized component '$val' requested\\n\");\n    }\n    return 0;\n}\n\n=head2 start\n\n Title   : start\n Usage   : $hsp->start('query')\n Function: Retrieves the start for the HSP component requested\n Returns : integer\n Args    : 'hit' or 'subject' or 'sbjct' to retrieve the start of the subject\n           'query' to retrieve the query start (default)\n\n\nsub start {\n    my $self = shift;\n    my $val = shift;\n    $val = 'query' unless defined $val;\n    $val =~ s/^\\s+//;\n\n    if( $val =~ /^q/i ) { \n        return $self->query->start(@_);\n    } elsif( $val =~ /^(hi|s)/i ) {\n\treturn $self->hit->start(@_);\n    } elsif (  $val =~ /^list|array/i ) {\t\n\t# do we really need to pass on additional arguments here? HL\n\t# (formerly this was strand(shift) which is really bad coding because\n\t# it breaks if the callee allows setting to undef)\n\treturn ($self->query->start(@_), \n\t\t$self->hit->start(@_) );\n    } else { \n\t$self->warn(\"unrecognized component '$val' requested\\n\");\n    }\n    return 0;\n}\n\n=head2 end\n\n Title   : end\n Usage   : $hsp->end('query')\n Function: Retrieves the end for the HSP component requested\n Returns : integer\n Args    : 'hit' or 'subject' or 'sbjct' to retrieve the end of the subject\n           'query' to retrieve the query end (default)\n\n\nsub end {\n    my $self = shift;\n    my $val = shift;\n    $val = 'query' unless defined $val;\n    $val =~ s/^\\s+//;\n\n    if( $val =~ /^q/i ) { \n        return $self->query->end(@_);\n    } elsif( $val =~ /^(hi|s)/i ) {\n\treturn $self->hit->end(@_);\n    } elsif (  $val =~ /^list|array/i ) {\t\n\t# do we really need to pass on additional arguments here? HL\n\t# (formerly this was strand(shift) which is really bad coding because\n\t# it breaks if the callee allows setting to undef)\n\treturn ($self->query->end(@_), \n\t\t$self->hit->end(@_) );\n    } else {\n\t$self->warn(\"unrecognized end component '$val' requested\\n\");\n    }\n    return 0;\n}\n\n=head2 seq\n\n Usage     : $hsp->seq( [seq_type] );\n Purpose   : Get the query or sbjct sequence as a Bio::Seq.pm object.\n Example   : $seqObj = $hsp->seq('query');\n Returns   : Object reference for a Bio::Seq.pm object.\n Argument  : seq_type = 'query' or 'hit' or 'sbjct' (default = 'query').\n           :  ('sbjct' is synonymous with 'hit') \n           : default is 'query'\n Throws    : Propagates any exception that occurs during construction\n           : of the Bio::Seq.pm object.\n Comments  : The sequence is returned in an array of strings corresponding\n           : to the strings in the original format of the Blast alignment.\n           : (i.e., same spacing).\n\nSee Also   : L</seq_str>, L</seq_inds>, L<Bio::Seq>","parameters":[{"label":"$self"},{"label":"$seqType"}]},"range":{"end":{"character":9999,"line":585},"start":{"character":0,"line":568}},"kind":12,"line":568},{"line":577,"containerName":"LocatableSeq","kind":12,"name":"Bio"},{"name":"Bio","containerName":"LocatableSeq","kind":12,"line":578},{"children":[{"definition":"my","name":"$self","localvar":"my","containerName":"seq_str","kind":13,"line":606},{"definition":"my","line":607,"name":"$type","localvar":"my","containerName":"seq_str","kind":13},{"name":"$type","kind":13,"containerName":"seq_str","line":609},{"line":609,"name":"$self","kind":13,"containerName":"seq_str"},{"line":609,"kind":12,"containerName":"seq_str","name":"query_string"},{"name":"$type","kind":13,"containerName":"seq_str","line":610},{"name":"$self","containerName":"seq_str","kind":13,"line":610},{"containerName":"seq_str","kind":12,"name":"hit_string","line":610},{"line":611,"containerName":"seq_str","kind":13,"name":"$type"},{"name":"$self","containerName":"seq_str","kind":13,"line":611},{"line":611,"name":"homology_string","kind":12,"containerName":"seq_str"},{"line":613,"kind":13,"containerName":"seq_str","name":"$self"},{"kind":12,"containerName":"seq_str","name":"warn","line":613}],"name":"seq_str","containerName":"main::","definition":"sub","line":605,"range":{"end":{"line":616,"character":9999},"start":{"line":605,"character":0}},"kind":12},{"kind":12,"range":{"start":{"line":629,"character":0},"end":{"line":629,"character":9999}},"line":629,"definition":"sub","containerName":"main::","name":"rank","children":[{"name":"throw_not_implemented","kind":12,"containerName":"rank","line":629}]},{"children":[{"line":662,"name":"$self","localvar":"my","kind":13,"containerName":"matches","definition":"my"},{"line":662,"containerName":"matches","kind":13,"name":"%param"},{"localvar":"my","kind":13,"containerName":"matches","name":"@data","line":663,"definition":"my"},{"line":664,"localvar":"my","containerName":"matches","kind":13,"name":"$seqType","definition":"my"},{"line":664,"name":"$beg","kind":13,"containerName":"matches"},{"line":664,"name":"$end","containerName":"matches","kind":13},{"name":"$param","containerName":"matches","kind":13,"line":664},{"line":665,"containerName":"matches","kind":13,"name":"$param"},{"name":"$param","kind":13,"containerName":"matches","line":666},{"kind":13,"containerName":"matches","name":"$seqType","line":667},{"containerName":"matches","kind":13,"name":"$seqType","line":668},{"name":"$seqType","containerName":"matches","kind":13,"line":668},{"name":"$beg","containerName":"matches","kind":13,"line":670},{"kind":13,"containerName":"matches","name":"$end","line":670},{"line":670,"name":"$self","containerName":"matches","kind":13},{"kind":12,"containerName":"matches","name":"seq_str","line":670},{"name":"@data","kind":13,"containerName":"matches","line":672},{"name":"$self","containerName":"matches","kind":13,"line":672},{"kind":12,"containerName":"matches","name":"num_identical","line":672},{"name":"$self","kind":13,"containerName":"matches","line":672},{"line":672,"name":"num_conserved","kind":12,"containerName":"matches"},{"line":676,"kind":13,"containerName":"matches","name":"$beg"},{"line":677,"kind":13,"containerName":"matches","name":"$end"},{"containerName":"matches","localvar":"my","kind":13,"name":"$start","line":678,"definition":"my"},{"name":"$stop","containerName":"matches","kind":13,"line":678},{"line":678,"name":"$self","containerName":"matches","kind":13},{"line":678,"name":"range","containerName":"matches","kind":12},{"line":678,"kind":13,"containerName":"matches","name":"$seqType"},{"kind":13,"containerName":"matches","name":"$beg","line":679},{"kind":13,"containerName":"matches","name":"$beg","line":679},{"line":679,"name":"$start","kind":13,"containerName":"matches"},{"line":679,"kind":13,"containerName":"matches","name":"$end"},{"containerName":"matches","kind":13,"name":"$beg","line":679},{"line":679,"kind":13,"containerName":"matches","name":"$end"},{"line":680,"name":"$end","kind":13,"containerName":"matches"},{"line":680,"name":"$end","kind":13,"containerName":"matches"},{"line":680,"containerName":"matches","kind":13,"name":"$stop"},{"line":680,"name":"$beg","kind":13,"containerName":"matches"},{"line":680,"containerName":"matches","kind":13,"name":"$end"},{"name":"$beg","kind":13,"containerName":"matches","line":680},{"line":682,"containerName":"matches","kind":13,"name":"$end"},{"containerName":"matches","kind":13,"name":"$stop","line":682},{"line":682,"name":"$end","containerName":"matches","kind":13},{"line":682,"kind":13,"containerName":"matches","name":"$stop"},{"line":683,"name":"$beg","containerName":"matches","kind":13},{"containerName":"matches","kind":13,"name":"$start","line":683},{"name":"$beg","containerName":"matches","kind":13,"line":683},{"name":"$start","kind":13,"containerName":"matches","line":683},{"definition":"my","line":686,"containerName":"matches","localvar":"my","kind":13,"name":"$match_str"},{"containerName":"matches","kind":13,"name":"$self","line":686},{"kind":12,"containerName":"matches","name":"seq_str","line":686},{"line":687,"name":"$self","kind":13,"containerName":"matches"},{"line":687,"kind":12,"containerName":"matches","name":"gaps"},{"line":690,"kind":13,"containerName":"matches","name":"$match_str"},{"line":690,"containerName":"matches","kind":13,"name":"$self"},{"containerName":"matches","kind":12,"name":"seq_str","line":690},{"line":691,"name":"$tgt","kind":13,"localvar":"my","containerName":"matches","definition":"my"},{"containerName":"matches","kind":13,"name":"$self","line":691},{"line":691,"kind":12,"containerName":"matches","name":"seq_str"},{"line":691,"containerName":"matches","kind":13,"name":"$seqType"},{"line":692,"kind":13,"localvar":"my","containerName":"matches","name":"$encode","definition":"my"},{"line":692,"containerName":"matches","kind":13,"name":"$match_str"},{"name":"$tgt","containerName":"matches","kind":13,"line":692},{"name":"$zap","containerName":"matches","localvar":"my","kind":13,"line":693,"definition":"my"},{"line":694,"containerName":"matches","kind":13,"name":"$encode"},{"name":"$tgt","containerName":"matches","kind":13,"line":695},{"containerName":"matches","kind":13,"name":"$match_str","line":696},{"name":"$tgt","kind":13,"containerName":"matches","line":696},{"line":696,"name":"$encode","kind":13,"containerName":"matches"},{"definition":"my","line":700,"localvar":"my","containerName":"matches","kind":13,"name":"$seq"},{"name":"$self","containerName":"matches","kind":13,"line":701},{"kind":12,"containerName":"matches","name":"algorithm","line":701},{"line":701,"name":"$seqType","containerName":"matches","kind":13},{"line":703,"name":"$seq","kind":13,"containerName":"matches"},{"kind":13,"containerName":"matches","name":"$match_str","line":703},{"line":704,"name":"$beg","containerName":"matches","kind":13},{"line":704,"kind":13,"containerName":"matches","name":"$start"},{"kind":13,"containerName":"matches","name":"$end","line":705},{"name":"$beg","kind":13,"containerName":"matches","line":705},{"line":707,"name":"$self","kind":13,"containerName":"matches"},{"name":"algorithm","kind":12,"containerName":"matches","line":707},{"name":"$seqType","containerName":"matches","kind":13,"line":707},{"line":708,"name":"$seq","kind":13,"containerName":"matches"},{"line":708,"name":"$match_str","containerName":"matches","kind":13},{"line":709,"containerName":"matches","kind":13,"name":"$beg"},{"containerName":"matches","kind":13,"name":"$start","line":709},{"line":709,"kind":13,"containerName":"matches","name":"$end"},{"kind":13,"containerName":"matches","name":"$beg","line":709},{"name":"$seq","kind":13,"containerName":"matches","line":711},{"kind":13,"containerName":"matches","name":"$match_str","line":711},{"kind":13,"containerName":"matches","name":"$beg","line":712},{"containerName":"matches","kind":13,"name":"$start","line":712},{"line":712,"name":"$end","kind":13,"containerName":"matches"},{"kind":13,"containerName":"matches","name":"$beg","line":712},{"kind":13,"containerName":"matches","name":"$seq","line":716},{"line":717,"name":"$self","kind":13,"containerName":"matches"},{"line":717,"containerName":"matches","kind":12,"name":"throw"},{"kind":13,"containerName":"matches","name":"$seq","line":720},{"definition":"my","line":721,"localvar":"my","containerName":"matches","kind":13,"name":"$len_cons"},{"line":721,"containerName":"matches","kind":13,"name":"$seq"},{"kind":13,"containerName":"matches","name":"$seq","line":722},{"localvar":"my","containerName":"matches","kind":13,"name":"$len_id","line":723,"definition":"my"},{"line":723,"name":"$seq","kind":13,"containerName":"matches"},{"line":724,"name":"@data","containerName":"matches","kind":13},{"line":724,"name":"$len_id","containerName":"matches","kind":13},{"line":724,"kind":13,"containerName":"matches","name":"$len_cons"},{"line":726,"kind":13,"containerName":"matches","name":"@data"}],"name":"matches","containerName":"main::","definition":"sub","detail":"($self,%param)","line":660,"kind":12,"range":{"end":{"line":727,"character":9999},"start":{"character":0,"line":660}},"signature":{"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: HSPI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::HSPI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n# and Jason Stajich <jason@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::HSPI - Interface for a High Scoring Pair in a similarity search result\n\n=head1 SYNOPSIS\n\n    # Bio::Search::HSP::HSPI objects cannot be instantiated since this\n    # module defines a pure interface.\n\n    # Given an object that implements the Bio::Search::HSP::HSPI  interface,\n    # you can do the following things with it:\n\n    $r_type = $hsp->algorithm;\n\n    $pvalue = $hsp->pvalue();\n\n    $evalue = $hsp->evalue();\n\n    $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n\n    $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n\n    $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n\n    $qseq = $hsp->query_string;\n\n    $hseq = $hsp->hit_string;\n\n    $homology_string = $hsp->homology_string;\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $rank = $hsp->rank;\n\n=head1 DESCRIPTION\n\nBio::Search::HSP::HSPI objects cannot be instantiated since this\nmodule defines a pure interface.\n\nGiven an object that implements the L<Bio::Search::HSP::HSPI> interface,\nyou can do the following things with it:\n\n=head1 SEE ALSO\n\nThis interface inherits methods from these other modules:\n\nL<Bio::SeqFeatureI>,\nL<Bio::SeqFeature::FeaturePair>\nL<Bio::SeqFeature::SimilarityPair>\n\nPlease refer to these modules for documentation of the \nmany additional inherited methods.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Steve Chervitz, Jason Stajich\n\nEmail sac-at-bioperl.org\nEmail jason-at-bioperl.org\n\n=head1 COPYRIGHT\n\nCopyright (c) 2001 Steve Chervitz, Jason Stajich. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::HSP::HSPI;\n\n\nuse strict;\nuse Carp;\n\nuse base qw(Bio::SeqFeature::SimilarityPair Bio::Root::RootI);\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the HSP\n Returns : string (e.g., BLASTP)\n Args    : none\n\n\nsub algorithm{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 pvalue\n\n Title   : pvalue\n Usage   : my $pvalue = $hsp->pvalue();\n Function: Returns the P-value for this HSP or undef \n Returns : float or exponential (2e-10)\n           P-value is not defined with NCBI Blast2 reports.\n Args    : none\n\n\nsub pvalue {\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 evalue\n\n Title   : evalue\n Usage   : my $evalue = $hsp->evalue();\n Function: Returns the e-value for this HSP\n Returns : float or exponential (2e-10)\n Args    : none\n\n\nsub evalue {\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : my $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n Function: Returns the fraction of identitical positions for this HSP \n Returns : Float in range 0.0 -> 1.0\n Args    : 'query' = num identical / length of query seq (without gaps)\n           'hit'   = num identical / length of hit seq (without gaps)\n           'total' = num identical / length of alignment (with gaps)\n           default = 'total' \n\n\nsub frac_identical {\n   my ($self, $type) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 frac_conserved\n\n Title    : frac_conserved\n Usage    : my $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n Function : Returns the fraction of conserved positions for this HSP.\n            This is the fraction of symbols in the alignment with a \n            positive score.\n Returns : Float in range 0.0 -> 1.0\n Args    : 'query' = num conserved / length of query seq (without gaps)\n           'hit'   = num conserved / length of hit seq (without gaps)\n           'total' = num conserved / length of alignment (with gaps)\n           default = 'total' \n\n\nsub frac_conserved {\n    my ($self, $type) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 num_identical\n\n Title   : num_identical\n Usage   : $obj->num_identical($newval)\n Function: returns the number of identical residues in the alignment\n Returns : integer\n Args    : integer (optional)\n\n\n\nsub num_identical{\n    shift->throw_not_implemented;\n}\n\n=head2 num_conserved\n\n Title   : num_conserved\n Usage   : $obj->num_conserved($newval)\n Function: returns the number of conserved residues in the alignment\n Returns : inetger\n Args    : integer (optional)\n\n\n\nsub num_conserved{\n    shift->throw_not_implemented();\n}\n\n=head2 gaps\n\n Title    : gaps\n Usage    : my $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n Function : Get the number of gap characters in the query, hit, or total alignment.\n Returns  : Integer, number of gap characters or 0 if none\n Args     : 'query' = num conserved / length of query seq (without gaps)\n            'hit'   = num conserved / length of hit seq (without gaps)\n            'total' = num conserved / length of alignment (with gaps)\n            default = 'total' \n\n\nsub gaps        {\n    my ($self, $type) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 query_string\n\n Title   : query_string\n Usage   : my $qseq = $hsp->query_string;\n Function: Retrieves the query sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\n\nsub query_string{\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 hit_string\n\n Title   : hit_string\n Usage   : my $hseq = $hsp->hit_string;\n Function: Retrieves the hit sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\n\nsub hit_string{\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 homology_string\n\n Title   : homology_string\n Usage   : my $homo_string = $hsp->homology_string;\n Function: Retrieves the homology sequence for this HSP as a string.\n         : The homology sequence is the string of symbols in between the \n         : query and hit sequences in the alignment indicating the degree\n         : of conservation (e.g., identical, similar, not similar).\n Returns : string\n Args    : none\n\n\nsub homology_string{\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 length\n\n Title    : length\n Usage    : my $len = $hsp->length( ['query'|'hit'|'total'] );\n Function : Returns the length of the query or hit in the alignment (without gaps) \n            or the aggregate length of the HSP (including gaps;\n            this may be greater than either hit or query )\n Returns  : integer\n Args     : 'query' = length of query seq (without gaps)\n            'hit'   = length of hit seq (without gaps)\n            'total' = length of alignment (with gaps)\n            default = 'total' \n Args    : none\n\n\nsub length{\n    shift->throw_not_implemented();\n}\n\n=head2 percent_identity\n\n Title   : percent_identity\n Usage   : my $percentid = $hsp->percent_identity()\n Function: Returns the calculated percent identity for an HSP\n Returns : floating point between 0 and 100 \n Args    : none\n\n\n\nsub percent_identity{\n   my ($self) = @_;\n   return $self->frac_identical('hsp') * 100;   \n}\n\n=head2 get_aln\n\n Title   : get_aln\n Usage   : my $aln = $hsp->get_aln\n Function: Returns a Bio::SimpleAlign representing the HSP alignment\n Returns : Bio::SimpleAlign\n Args    : none\n\n\nsub get_aln {\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n\n=head2 seq_inds\n\n Title   : seq_inds\n Purpose   : Get a list of residue positions (indices) for all identical \n           : or conserved residues in the query or sbjct sequence.\n Example   : @s_ind = $hsp->seq_inds('query', 'identical');\n           : @h_ind = $hsp->seq_inds('hit', 'conserved');\n           : @h_ind = $hsp->seq_inds('hit', 'conserved', 1);\n Returns   : List of integers \n           : May include ranges if collapse is true.\n Argument  : seq_type  = 'query' or 'hit' or 'sbjct'  (default = query)\n              ('sbjct' is synonymous with 'hit') \n             class     = 'identical' or 'conserved' or 'nomatch' or 'gap'\n                          (default = identical)\n                          (can be shortened to 'id' or 'cons')\n\n             collapse  = boolean, if true, consecutive positions are merged\n                         using a range notation, e.g., \"1 2 3 4 5 7 9 10 11\" \n                         collapses to \"1-5 7 9-11\". This is useful for \n                         consolidating long lists. Default = no collapse.\n Throws    : n/a.\n Comments  : \n\nSee Also   : L<Bio::Search::BlastUtils::collapse_nums()|Bio::Search::BlastUtils>, L<Bio::Search::Hit::HitI::seq_inds()|Bio::Search::Hit::HitI>\n\n\nsub seq_inds {\n    shift->throw_not_implemented();\n}\n\n=head2 Inherited from L<Bio::SeqFeature::SimilarityPair>\n\nThese methods come from L<Bio::SeqFeature::SimilarityPair>\n\n=head2 query\n\n Title   : query\n Usage   : my $query = $hsp->query\n Function: Returns a SeqFeature representing the query in the HSP\n Returns : Bio::SeqFeature::Similarity\n Args    : [optional] new value to set\n\n\n=head2 hit\n\n Title   : hit\n Usage   : my $hit = $hsp->hit\n Function: Returns a SeqFeature representing the hit in the HSP\n Returns : Bio::SeqFeature::Similarity\n Args    : [optional] new value to set\n\n\n=head2 significance\n\n Title   : significance\n Usage   : $evalue = $obj->significance();\n           $obj->significance($evalue);\n Function: Get/Set the significance value (see Bio::SeqFeature::SimilarityPair)\n Returns : significance value (scientific notation string)\n Args    : significance value (sci notation string)\n\n\n=head2 score\n\n Title   : score\n Usage   : my $score = $hsp->score();\n Function: Returns the score for this HSP or undef \n Returns : numeric           \n Args    : [optional] numeric to set value\n\n=head2 bits\n\n Title   : bits\n Usage   : my $bits = $hsp->bits();\n Function: Returns the bit value for this HSP or undef \n Returns : numeric\n Args    : none\n\n\n# override \n\n=head2 strand\n\n Title   : strand\n Usage   : $hsp->strand('query')\n Function: Retrieves the strand for the HSP component requested\n Returns : +1 or -1 (0 if unknown)\n Args    : 'hit' or 'subject' or 'sbjct' to retrieve the strand of the subject\n           'query' to retrieve the query strand (default)\n           'list' or 'array' to retreive both query and hit together\n\n\nsub strand {\n    my $self = shift;\n    my $val = shift;\n    $val = 'query' unless defined $val;\n    $val =~ s/^\\s+//;\n\n    if( $val =~ /^q/i ) {\n\treturn $self->query->strand(@_);\n    } elsif( $val =~ /^hi|^s/i ) {\n\treturn $self->hit->strand(@_);\n    } elsif (  $val =~ /^list|array/i ) {\n\t# do we really need to pass on additional arguments here? HL\n\t# (formerly this was strand(shift) which is really bad coding because\n\t# it breaks if the callee allows setting to undef)\n\treturn ($self->query->strand(@_), \n\t\t$self->hit->strand(@_) );\n    } else { \n\t$self->warn(\"unrecognized component '$val' requested\\n\");\n    }\n    return 0;\n}\n\n=head2 start\n\n Title   : start\n Usage   : $hsp->start('query')\n Function: Retrieves the start for the HSP component requested\n Returns : integer\n Args    : 'hit' or 'subject' or 'sbjct' to retrieve the start of the subject\n           'query' to retrieve the query start (default)\n\n\nsub start {\n    my $self = shift;\n    my $val = shift;\n    $val = 'query' unless defined $val;\n    $val =~ s/^\\s+//;\n\n    if( $val =~ /^q/i ) { \n        return $self->query->start(@_);\n    } elsif( $val =~ /^(hi|s)/i ) {\n\treturn $self->hit->start(@_);\n    } elsif (  $val =~ /^list|array/i ) {\t\n\t# do we really need to pass on additional arguments here? HL\n\t# (formerly this was strand(shift) which is really bad coding because\n\t# it breaks if the callee allows setting to undef)\n\treturn ($self->query->start(@_), \n\t\t$self->hit->start(@_) );\n    } else { \n\t$self->warn(\"unrecognized component '$val' requested\\n\");\n    }\n    return 0;\n}\n\n=head2 end\n\n Title   : end\n Usage   : $hsp->end('query')\n Function: Retrieves the end for the HSP component requested\n Returns : integer\n Args    : 'hit' or 'subject' or 'sbjct' to retrieve the end of the subject\n           'query' to retrieve the query end (default)\n\n\nsub end {\n    my $self = shift;\n    my $val = shift;\n    $val = 'query' unless defined $val;\n    $val =~ s/^\\s+//;\n\n    if( $val =~ /^q/i ) { \n        return $self->query->end(@_);\n    } elsif( $val =~ /^(hi|s)/i ) {\n\treturn $self->hit->end(@_);\n    } elsif (  $val =~ /^list|array/i ) {\t\n\t# do we really need to pass on additional arguments here? HL\n\t# (formerly this was strand(shift) which is really bad coding because\n\t# it breaks if the callee allows setting to undef)\n\treturn ($self->query->end(@_), \n\t\t$self->hit->end(@_) );\n    } else {\n\t$self->warn(\"unrecognized end component '$val' requested\\n\");\n    }\n    return 0;\n}\n\n=head2 seq\n\n Usage     : $hsp->seq( [seq_type] );\n Purpose   : Get the query or sbjct sequence as a Bio::Seq.pm object.\n Example   : $seqObj = $hsp->seq('query');\n Returns   : Object reference for a Bio::Seq.pm object.\n Argument  : seq_type = 'query' or 'hit' or 'sbjct' (default = 'query').\n           :  ('sbjct' is synonymous with 'hit') \n           : default is 'query'\n Throws    : Propagates any exception that occurs during construction\n           : of the Bio::Seq.pm object.\n Comments  : The sequence is returned in an array of strings corresponding\n           : to the strings in the original format of the Blast alignment.\n           : (i.e., same spacing).\n\nSee Also   : L</seq_str>, L</seq_inds>, L<Bio::Seq>\n\n\nsub seq {\n    my($self,$seqType) = @_; \n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n    my $str = $self->seq_str($seqType);\n    if( $seqType =~ /^(m|ho)/i ) {\n        $self->throw(\"cannot call seq on the homology match string, it isn't really a sequence, use get_aln to convert the HSP to a Bio::AlignIO and generate a consensus from that.\");\n    }\n    require Bio::LocatableSeq;\n    my $id = $seqType =~ /^q/i ? $self->query->seq_id : $self->hit->seq_id;\n    return Bio::LocatableSeq->new(  -ID        => $id,\n                                    -SEQ       => $str,\n                                    -START     => $self->start($seqType),\n                                    -END       => $self->end($seqType),\n                                    -STRAND    => $self->strand($seqType),\n                                    -FORCE_NSE => $id ? 0 : 1,\n                                    -DESC      => \"$seqType sequence \" );\n}\n\n=head2 seq_str\n\n Usage     : $hsp->seq_str( seq_type );\n Purpose   : Get the full query, sbjct, or 'match' sequence as a string.\n           : The 'match' sequence is the string of symbols in between the \n           : query and sbjct sequences.\n Example   : $str = $hsp->seq_str('query');\n Returns   : String\n Argument  : seq_Type = 'query' or 'hit' or 'sbjct' or 'match'\n           :  ('sbjct' is synonymous with 'hit')\n           : default is 'query'\n Throws    : Exception if the argument does not match an accepted seq_type.\n Comments  : \n\nSee Also   : L</seq>, L</seq_inds>, C<_set_match_seq>\n\n\nsub seq_str {  \n    my $self = shift;\n    my $type = shift || 'query';\n\n    if( $type =~ /^q/i ) { return $self->query_string(@_) }\n    elsif( $type =~ /^(s)|(hi)/i ) { return $self->hit_string(@_)}\n    elsif ( $type =~ /^(ho)|(ma)/i  ) { return $self->homology_string(@_) }\n    else { \n        $self->warn(\"unknown sequence type $type\");\n    }\n    return '';\n}\n\n\n=head2 rank\n\n Usage     : $hsp->rank( [string] );\n Purpose   : Get the rank of the HSP within a given Blast hit.\n Example   : $rank = $hsp->rank;\n Returns   : Integer (1..n) corresponding to the order in which the HSP\n             appears in the BLAST report.\n\n\nsub rank { shift->throw_not_implemented }\n\n=head2 matches\n\n Usage     : $hsp->matches(-seq   => 'hit'|'query', \n                           -start => $start, \n                           -stop  => $stop);\n Purpose   : Get the total number of identical and conservative matches \n           : in the query or sbjct sequence for the given HSP. Optionally can\n           : report data within a defined interval along the seq.\n           : (Note: 'conservative' matches are called 'positives' in the\n           : Blast report.)\n Example   : ($id,$cons) = $hsp_object->matches(-seq   => 'hit');\n           : ($id,$cons) = $hsp_object->matches(-seq   => 'query',\n                                                -start => 300,\n                                                -stop  => 400);\n Returns   : 2-element array of integers \n Argument  : (1) seq_type = 'query' or 'hit' or 'sbjct' (default = query)\n           :  ('sbjct' is synonymous with 'hit') \n           : (2) start = Starting coordinate (optional)\n           : (3) stop  = Ending coordinate (optional)\n Throws    : Exception if the supplied coordinates are out of range.\n Comments  : Relies on seq_str('match') to get the string of alignment symbols\n           : between the query and sbjct lines which are used for determining\n           : the number of identical and conservative matches.\n\nSee Also   : L</length>, L</gaps>, L</seq_str>, L<Bio::Search::Hit::BlastHit::_adjust_contigs()|Bio::Search::Hit::BlastHit>","parameters":[{"label":"$self"},{"label":"%param"}],"label":"matches($self,%param)"}},{"containerName":"length","kind":12,"name":"CORE","line":716},{"line":722,"containerName":"length","kind":12,"name":"CORE"},{"name":"CORE","kind":12,"containerName":"length","line":724},{"range":{"end":{"line":747,"character":9999},"start":{"character":0,"line":747}},"kind":12,"line":747,"containerName":"main::","name":"n","children":[{"containerName":"n","kind":12,"name":"throw_not_implemented","line":747}],"definition":"sub"},{"definition":"sub","name":"range","containerName":"main::","children":[{"containerName":"range","kind":12,"name":"throw_not_implemented","line":765}],"kind":12,"range":{"end":{"line":765,"character":9999},"start":{"character":0,"line":765}},"line":765},{"kind":12,"range":{"start":{"line":767,"character":0},"end":{"character":9999,"line":767}},"line":767,"name":"expect","containerName":"main::","children":[{"name":"evalue","kind":12,"containerName":"expect","line":767}],"definition":"sub"}]}