{"vars":[{"name":"base","containerName":"","kind":2,"line":87},{"children":[{"definition":"my","line":107,"localvar":"my","containerName":"new","kind":13,"name":"$class"},{"name":"@args","kind":13,"containerName":"new","line":107},{"line":108,"kind":13,"localvar":"my","containerName":"new","name":"$self","definition":"my"},{"line":108,"kind":13,"containerName":"new","name":"$class"},{"kind":13,"containerName":"new","name":"@args","line":108},{"line":110,"kind":13,"containerName":"new","name":"$self"},{"containerName":"new","kind":12,"name":"_setup","line":110},{"name":"@args","kind":13,"containerName":"new","line":110},{"name":"$fields","kind":13,"localvar":"my","containerName":"new","line":112,"definition":"my"},{"containerName":"new","kind":13,"name":"$self","line":112},{"line":112,"name":"_fields","kind":12,"containerName":"new"},{"line":113,"name":"$field","containerName":"new","localvar":"my","kind":13,"definition":"my"},{"kind":13,"containerName":"new","name":"$fields","line":114},{"name":"$field","containerName":"new","kind":13,"line":114},{"name":"$self","kind":13,"containerName":"new","line":117},{"kind":12,"containerName":"new","name":"_dependencies","line":117},{"line":140,"name":"$self","kind":13,"containerName":"new"}],"containerName":"main::","name":"new","definition":"sub","detail":"($class,@args)","line":106,"range":{"start":{"line":106,"character":0},"end":{"character":9999,"line":141}},"kind":12,"signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: BlastPullHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::BlastPullHSP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::BlastPullHSP - A parser and HSP object for BlastN hsps\n\n=head1 SYNOPSIS\n\n    # generally we use Bio::SearchIO to build these objects\n    use Bio::SearchIO;\n    my $in = Bio::SearchIO->new(-format => 'hmmer_pull',\n\t\t\t\t\t\t\t   -file   => 'result.blast');\n\n    while (my $result = $in->next_result) {\n\t\twhile (my $hit = $result->next_hit) {\n\t\t\tprint $hit->name, \"\\n\";\n\t\t\tprint $hit->score, \"\\n\";\n\t\t\tprint $hit->significance, \"\\n\";\n\n\t\t\twhile (my $hsp = $hit->next_hsp) {\n\t\t\t\t# process HSPI objects\n\t\t\t}\n\t\t}\n    }\n\n=head1 DESCRIPTION\n\nThis object implements a parser for BlastN hsp output.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::BlastPullHSP;\n\nuse strict;\nuse base qw(Bio::Search::HSP::PullHSPI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::HSP::BlastNHSP->new();\n Function: Builds a new Bio::Search::HSP::BlastNHSP object.\n Returns : Bio::Search::HSP::BlastNHSP\n Args    : -chunk  => [Bio::Root::IO, $start, $end] (required if no -parent)\n           -parent => Bio::PullParserI object (required if no -chunk)\n\n           where the array ref provided to -chunk contains an IO object\n           for a filehandle to something representing the raw data of the\n           hsp, and $start and $end define the tell() position within the\n           filehandle that the hsp data starts and ends (optional; defaults\n           to start and end of the entire thing described by the filehandle)","label":"new($class,@args)"}},{"line":108,"name":"SUPER","kind":12,"containerName":"new"},{"name":"score","kind":12,"line":117},{"line":118,"name":"bits","kind":12},{"line":119,"kind":12,"name":"evalue"},{"name":"total_gaps","kind":12,"line":120},{"kind":12,"name":"query_strand","line":121},{"line":122,"kind":12,"name":"hit_strand"},{"line":123,"kind":12,"name":"alignment"},{"line":124,"kind":12,"name":"query_string"},{"kind":12,"name":"hit_string","line":125},{"name":"homology_string","kind":12,"line":126},{"name":"query_start","kind":12,"line":127},{"kind":12,"name":"query_end","line":128},{"line":129,"name":"hit_start","kind":12},{"name":"hit_end","kind":12,"line":130},{"kind":12,"name":"hit_identical_inds","line":131},{"line":132,"name":"hit_conserved_inds","kind":12},{"line":133,"name":"hit_nomatch_inds","kind":12},{"kind":12,"name":"hit_gap_inds","line":134},{"name":"query_identical_inds","kind":12,"line":135},{"name":"query_conserved_inds","kind":12,"line":136},{"line":137,"kind":12,"name":"query_nomatch_inds"},{"kind":12,"name":"query_gap_inds","line":138},{"definition":"sub","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"_discover_header","line":148},{"containerName":"_discover_header","kind":13,"name":"$self","line":149},{"line":149,"kind":12,"containerName":"_discover_header","name":"_chunk_seek"},{"definition":"my","containerName":"_discover_header","localvar":"my","kind":13,"name":"$header","line":150},{"line":150,"containerName":"_discover_header","kind":13,"name":"$self"},{"line":150,"name":"_get_chunk_by_end","containerName":"_discover_header","kind":12},{"name":"$self","kind":13,"containerName":"_discover_header","line":151},{"containerName":"_discover_header","kind":13,"name":"$self","line":151},{"line":151,"kind":12,"containerName":"_discover_header","name":"_chunk_tell"},{"name":"$self","containerName":"_discover_header","kind":13,"line":153},{"line":153,"name":"_fields","kind":12,"containerName":"_discover_header"},{"containerName":"_discover_header","kind":13,"name":"$self","line":153},{"line":153,"name":"_fields","containerName":"_discover_header","kind":12},{"name":"$self","containerName":"_discover_header","kind":13,"line":153},{"name":"_fields","kind":12,"containerName":"_discover_header","line":153},{"line":154,"name":"$self","containerName":"_discover_header","kind":13},{"name":"_fields","kind":12,"containerName":"_discover_header","line":154},{"name":"$self","kind":13,"containerName":"_discover_header","line":154},{"kind":12,"containerName":"_discover_header","name":"_fields","line":154},{"line":154,"kind":13,"containerName":"_discover_header","name":"$self"},{"line":154,"containerName":"_discover_header","kind":12,"name":"_fields"},{"line":155,"kind":13,"containerName":"_discover_header","name":"$header"},{"containerName":"_discover_header","kind":13,"name":"$self","line":157},{"line":157,"name":"_fields","containerName":"_discover_header","kind":12},{"line":159,"name":"$strand_type","kind":13,"localvar":"my","containerName":"_discover_header","definition":"my"},{"line":160,"name":"$self","containerName":"_discover_header","kind":13},{"name":"_fields","containerName":"_discover_header","kind":12,"line":160},{"kind":13,"containerName":"_discover_header","name":"$strand_type","line":160},{"line":160,"containerName":"_discover_header","kind":13,"name":"$self"},{"line":160,"name":"_fields","containerName":"_discover_header","kind":12},{"line":160,"kind":13,"containerName":"_discover_header","name":"$strand_type"},{"line":164,"containerName":"_discover_header","kind":13,"name":"$self"},{"line":164,"kind":12,"containerName":"_discover_header","name":"_fields"},{"kind":13,"containerName":"_discover_header","name":"$self","line":165},{"name":"_fields","containerName":"_discover_header","kind":12,"line":165},{"line":168,"kind":13,"containerName":"_discover_header","name":"$self"},{"line":168,"kind":12,"containerName":"_discover_header","name":"_fields"},{"line":169,"name":"$self","containerName":"_discover_header","kind":13},{"name":"_fields","kind":12,"containerName":"_discover_header","line":169},{"line":169,"containerName":"_discover_header","kind":13,"name":"$self"},{"line":169,"kind":12,"containerName":"_discover_header","name":"_fields"},{"name":"$self","kind":13,"containerName":"_discover_header","line":173},{"name":"_fields","kind":12,"containerName":"_discover_header","line":173},{"name":"$self","kind":13,"containerName":"_discover_header","line":173},{"line":173,"name":"_fields","kind":12,"containerName":"_discover_header"},{"name":"$self","kind":13,"containerName":"_discover_header","line":175},{"name":"_fields","containerName":"_discover_header","kind":12,"line":175}],"containerName":"main::","name":"_discover_header","line":147,"range":{"start":{"line":147,"character":0},"end":{"line":176,"character":9999}},"kind":12},{"line":151,"kind":12,"name":"_after_header"},{"line":153,"name":"bits","kind":12},{"kind":12,"name":"score","line":153},{"name":"evalue","kind":12,"line":153},{"line":154,"kind":12,"name":"total_gaps"},{"name":"query_strand","kind":12,"line":154},{"name":"hit_strand","kind":12,"line":154},{"line":157,"kind":12,"name":"query_strand"},{"kind":12,"name":"query_strand","line":164},{"name":"hit_strand","kind":12,"line":165},{"line":168,"kind":12,"name":"evalue"},{"kind":12,"name":"evalue","line":169},{"name":"evalue","kind":12,"line":169},{"name":"total_gaps","kind":12,"line":173},{"line":173,"name":"total_gaps","kind":12},{"line":175,"kind":12,"name":"header"},{"line":178,"range":{"end":{"character":9999,"line":231},"start":{"line":178,"character":0}},"kind":12,"definition":"sub","children":[{"line":179,"containerName":"_discover_alignment","localvar":"my","kind":13,"name":"$self","definition":"my"},{"name":"$self","kind":13,"containerName":"_discover_alignment","line":180},{"line":180,"name":"_chunk_seek","containerName":"_discover_alignment","kind":12},{"name":"$self","kind":13,"containerName":"_discover_alignment","line":180},{"line":185,"name":"$query_string","kind":13,"localvar":"my","containerName":"_discover_alignment","definition":"my"},{"containerName":"_discover_alignment","kind":13,"name":"$hit_string","line":185},{"name":"$homology_string","kind":13,"containerName":"_discover_alignment","line":185},{"kind":13,"containerName":"_discover_alignment","name":"$q_start","line":185},{"line":185,"kind":13,"containerName":"_discover_alignment","name":"$h_start"},{"line":185,"containerName":"_discover_alignment","kind":13,"name":"$q_end"},{"kind":13,"containerName":"_discover_alignment","name":"$h_end","line":185},{"definition":"my","name":"$strip","containerName":"_discover_alignment","localvar":"my","kind":13,"line":186},{"line":186,"containerName":"_discover_alignment","kind":13,"name":"$self"},{"line":186,"containerName":"_discover_alignment","kind":12,"name":"_get_chunk_by_end"},{"line":186,"kind":13,"containerName":"_discover_alignment","name":"$self"},{"line":186,"name":"_get_chunk_by_nol","containerName":"_discover_alignment","kind":12},{"line":187,"name":"$strip","kind":13,"containerName":"_discover_alignment"},{"line":188,"name":"$q1","containerName":"_discover_alignment","localvar":"my","kind":13,"definition":"my"},{"name":"$query_string","containerName":"_discover_alignment","kind":13,"line":189},{"definition":"my","name":"$q2","localvar":"my","containerName":"_discover_alignment","kind":13,"line":190},{"definition":"my","line":191,"name":"$hom","kind":13,"localvar":"my","containerName":"_discover_alignment"},{"definition":"my","line":192,"localvar":"my","kind":13,"containerName":"_discover_alignment","name":"$h1"},{"line":193,"name":"$hit_string","containerName":"_discover_alignment","kind":13},{"localvar":"my","containerName":"_discover_alignment","kind":13,"name":"$h2","line":194,"definition":"my"},{"line":196,"name":"$hom","containerName":"_discover_alignment","kind":13},{"line":196,"kind":13,"containerName":"_discover_alignment","name":"$hom"},{"line":196,"containerName":"_discover_alignment","kind":13,"name":"$hom"},{"containerName":"_discover_alignment","kind":13,"name":"$homology_string","line":197},{"line":197,"kind":13,"containerName":"_discover_alignment","name":"$hom"},{"definition":"my","containerName":"_discover_alignment","localvar":"my","kind":13,"name":"$q","line":199},{"name":"$q1","kind":13,"containerName":"_discover_alignment","line":199},{"line":199,"containerName":"_discover_alignment","kind":13,"name":"$q2"},{"line":200,"containerName":"_discover_alignment","kind":13,"name":"$q_start"},{"line":200,"kind":13,"containerName":"_discover_alignment","name":"$q"},{"line":200,"kind":13,"containerName":"_discover_alignment","name":"$q_start"},{"line":201,"name":"$q_start","containerName":"_discover_alignment","kind":13},{"kind":13,"containerName":"_discover_alignment","name":"$q","line":201},{"line":203,"containerName":"_discover_alignment","kind":13,"name":"$q_end"},{"line":203,"containerName":"_discover_alignment","kind":13,"name":"$q"},{"line":203,"name":"$q_end","containerName":"_discover_alignment","kind":13},{"line":204,"name":"$q_end","containerName":"_discover_alignment","kind":13},{"line":204,"name":"$q","containerName":"_discover_alignment","kind":13},{"definition":"my","name":"$h","containerName":"_discover_alignment","localvar":"my","kind":13,"line":207},{"containerName":"_discover_alignment","kind":13,"name":"$h1","line":207},{"line":207,"kind":13,"containerName":"_discover_alignment","name":"$h2"},{"containerName":"_discover_alignment","kind":13,"name":"$h_start","line":208},{"name":"$h","containerName":"_discover_alignment","kind":13,"line":208},{"line":208,"name":"$h_start","containerName":"_discover_alignment","kind":13},{"containerName":"_discover_alignment","kind":13,"name":"$h_start","line":209},{"line":209,"containerName":"_discover_alignment","kind":13,"name":"$h"},{"line":211,"name":"$h_end","containerName":"_discover_alignment","kind":13},{"name":"$h","kind":13,"containerName":"_discover_alignment","line":211},{"name":"$h_end","containerName":"_discover_alignment","kind":13,"line":211},{"line":212,"kind":13,"containerName":"_discover_alignment","name":"$h_end"},{"line":212,"containerName":"_discover_alignment","kind":13,"name":"$h"},{"line":217,"kind":13,"containerName":"_discover_alignment","name":"$self"},{"kind":12,"containerName":"_discover_alignment","name":"_fields","line":217},{"name":"$query_string","containerName":"_discover_alignment","kind":13,"line":217},{"line":218,"kind":13,"containerName":"_discover_alignment","name":"$self"},{"kind":12,"containerName":"_discover_alignment","name":"_fields","line":218},{"line":218,"name":"$hit_string","kind":13,"containerName":"_discover_alignment"},{"containerName":"_discover_alignment","kind":13,"name":"$self","line":219},{"name":"_fields","kind":12,"containerName":"_discover_alignment","line":219},{"line":219,"name":"$homology_string","kind":13,"containerName":"_discover_alignment"},{"line":221,"name":"$self","kind":13,"containerName":"_discover_alignment"},{"line":221,"name":"_fields","containerName":"_discover_alignment","kind":12},{"name":"$q_start","kind":13,"containerName":"_discover_alignment","line":221},{"containerName":"_discover_alignment","kind":13,"name":"$self","line":222},{"kind":12,"containerName":"_discover_alignment","name":"_fields","line":222},{"containerName":"_discover_alignment","kind":13,"name":"$q_end","line":222},{"line":223,"name":"$self","containerName":"_discover_alignment","kind":13},{"name":"_fields","kind":12,"containerName":"_discover_alignment","line":223},{"name":"$h_start","containerName":"_discover_alignment","kind":13,"line":223},{"line":224,"kind":13,"containerName":"_discover_alignment","name":"$self"},{"containerName":"_discover_alignment","kind":12,"name":"_fields","line":224},{"kind":13,"containerName":"_discover_alignment","name":"$h_end","line":224},{"line":226,"containerName":"_discover_alignment","kind":13,"name":"$self"},{"line":226,"name":"$query_string","containerName":"_discover_alignment","kind":13},{"containerName":"_discover_alignment","kind":13,"name":"$self","line":227},{"line":227,"name":"$hit_string","kind":13,"containerName":"_discover_alignment"},{"line":228,"kind":13,"containerName":"_discover_alignment","name":"$self"},{"kind":13,"containerName":"_discover_alignment","name":"$self","line":228},{"line":228,"containerName":"_discover_alignment","kind":13,"name":"$self"},{"line":230,"name":"$self","containerName":"_discover_alignment","kind":13},{"line":230,"containerName":"_discover_alignment","kind":12,"name":"_fields"}],"name":"_discover_alignment","containerName":"main::"},{"kind":12,"name":"_after_header","line":180},{"line":217,"name":"query_string","kind":12},{"line":218,"kind":12,"name":"hit_string"},{"line":219,"kind":12,"name":"homology_string"},{"kind":12,"name":"query_start","line":221},{"line":222,"kind":12,"name":"query_end"},{"line":223,"name":"hit_start","kind":12},{"line":224,"kind":12,"name":"hit_end"},{"line":226,"name":"_query_gaps","kind":12},{"line":227,"name":"_hit_gaps","kind":12},{"name":"_total_gaps","kind":12,"line":228},{"line":228,"name":"_query_gaps","kind":12},{"name":"_hit_gaps","kind":12,"line":228},{"kind":12,"name":"alignment","line":230},{"containerName":"main::","name":"_discover_seq_inds","children":[{"name":"$self","localvar":"my","kind":13,"containerName":"_discover_seq_inds","line":235,"definition":"my"},{"definition":"my","kind":13,"localvar":"my","containerName":"_discover_seq_inds","name":"$seqString","line":236},{"name":"$qseq","containerName":"_discover_seq_inds","kind":13,"line":236},{"line":236,"name":"$sseq","containerName":"_discover_seq_inds","kind":13},{"name":"$self","kind":13,"containerName":"_discover_seq_inds","line":236},{"kind":12,"containerName":"_discover_seq_inds","name":"get_field","line":236},{"line":237,"containerName":"_discover_seq_inds","kind":13,"name":"$self"},{"name":"get_field","kind":12,"containerName":"_discover_seq_inds","line":237},{"name":"$self","containerName":"_discover_seq_inds","kind":13,"line":238},{"line":238,"containerName":"_discover_seq_inds","kind":12,"name":"get_field"},{"definition":"my","line":243,"localvar":"my","containerName":"_discover_seq_inds","kind":13,"name":"%identicalList_query"},{"name":"%identicalList_sbjct","localvar":"my","containerName":"_discover_seq_inds","kind":13,"line":244,"definition":"my"},{"name":"%conservedList_query","localvar":"my","kind":13,"containerName":"_discover_seq_inds","line":245,"definition":"my"},{"definition":"my","localvar":"my","kind":13,"containerName":"_discover_seq_inds","name":"%conservedList_sbjct","line":246},{"name":"@gapList_query","localvar":"my","containerName":"_discover_seq_inds","kind":13,"line":247,"definition":"my"},{"line":248,"name":"@gapList_sbjct","localvar":"my","containerName":"_discover_seq_inds","kind":13,"definition":"my"},{"definition":"my","containerName":"_discover_seq_inds","localvar":"my","kind":13,"name":"%nomatchList_query","line":249},{"containerName":"_discover_seq_inds","localvar":"my","kind":13,"name":"%nomatchList_sbjct","line":250,"definition":"my"},{"line":252,"name":"$resCount_query","kind":13,"localvar":"my","containerName":"_discover_seq_inds","definition":"my"},{"line":252,"containerName":"_discover_seq_inds","kind":13,"name":"$self"},{"line":252,"containerName":"_discover_seq_inds","kind":12,"name":"get_field"},{"definition":"my","containerName":"_discover_seq_inds","localvar":"my","kind":13,"name":"$resCount_sbjct","line":253},{"name":"$self","kind":13,"containerName":"_discover_seq_inds","line":253},{"name":"get_field","containerName":"_discover_seq_inds","kind":12,"line":253},{"definition":"my","line":255,"localvar":"my","kind":13,"containerName":"_discover_seq_inds","name":"$mchar"},{"line":255,"name":"$schar","containerName":"_discover_seq_inds","kind":13},{"line":255,"containerName":"_discover_seq_inds","kind":13,"name":"$qchar"},{"name":"$mchar","containerName":"_discover_seq_inds","kind":13,"line":256},{"line":256,"name":"$seqString","kind":13,"containerName":"_discover_seq_inds"},{"line":257,"kind":13,"containerName":"_discover_seq_inds","name":"$qchar"},{"kind":13,"containerName":"_discover_seq_inds","name":"$schar","line":257},{"line":257,"name":"$qseq","containerName":"_discover_seq_inds","kind":13},{"line":257,"name":"$sseq","containerName":"_discover_seq_inds","kind":13},{"name":"$mchar","kind":13,"containerName":"_discover_seq_inds","line":259},{"name":"$mchar","containerName":"_discover_seq_inds","kind":13,"line":259},{"name":"$mchar","containerName":"_discover_seq_inds","kind":13,"line":259},{"name":"$conservedList_query","containerName":"_discover_seq_inds","kind":13,"line":260},{"kind":13,"containerName":"_discover_seq_inds","name":"$resCount_query","line":260},{"line":261,"containerName":"_discover_seq_inds","kind":13,"name":"$conservedList_sbjct"},{"name":"$resCount_sbjct","containerName":"_discover_seq_inds","kind":13,"line":261},{"name":"$mchar","containerName":"_discover_seq_inds","kind":13,"line":263},{"containerName":"_discover_seq_inds","kind":13,"name":"$nomatchList_query","line":264},{"name":"$resCount_query","kind":13,"containerName":"_discover_seq_inds","line":264},{"line":265,"containerName":"_discover_seq_inds","kind":13,"name":"$nomatchList_sbjct"},{"name":"$resCount_sbjct","containerName":"_discover_seq_inds","kind":13,"line":265},{"line":268,"name":"$identicalList_query","containerName":"_discover_seq_inds","kind":13},{"line":268,"containerName":"_discover_seq_inds","kind":13,"name":"$resCount_query"},{"name":"$identicalList_sbjct","kind":13,"containerName":"_discover_seq_inds","line":269},{"line":269,"name":"$resCount_sbjct","kind":13,"containerName":"_discover_seq_inds"},{"line":272,"containerName":"_discover_seq_inds","kind":13,"name":"$qchar"},{"name":"@gapList_query","containerName":"_discover_seq_inds","kind":13,"line":273},{"name":"$resCount_query","kind":13,"containerName":"_discover_seq_inds","line":273},{"name":"$resCount_query","containerName":"_discover_seq_inds","kind":13,"line":276},{"kind":13,"containerName":"_discover_seq_inds","name":"$schar","line":278},{"line":279,"name":"@gapList_sbjct","kind":13,"containerName":"_discover_seq_inds"},{"name":"$resCount_sbjct","containerName":"_discover_seq_inds","kind":13,"line":279},{"containerName":"_discover_seq_inds","kind":13,"name":"$resCount_sbjct","line":282},{"line":286,"name":"$fields","kind":13,"localvar":"my","containerName":"_discover_seq_inds","definition":"my"},{"name":"$self","containerName":"_discover_seq_inds","kind":13,"line":286},{"name":"_fields","kind":12,"containerName":"_discover_seq_inds","line":286},{"line":287,"containerName":"_discover_seq_inds","kind":13,"name":"$fields"},{"line":287,"name":"$a","containerName":"_discover_seq_inds","kind":13},{"containerName":"_discover_seq_inds","kind":13,"name":"$b","line":287},{"line":287,"containerName":"_discover_seq_inds","kind":13,"name":"%identicalList_sbjct"},{"name":"$fields","containerName":"_discover_seq_inds","kind":13,"line":288},{"containerName":"_discover_seq_inds","kind":13,"name":"$a","line":288},{"kind":13,"containerName":"_discover_seq_inds","name":"$b","line":288},{"line":288,"name":"%conservedList_sbjct","containerName":"_discover_seq_inds","kind":13},{"kind":13,"containerName":"_discover_seq_inds","name":"$fields","line":289},{"name":"$a","containerName":"_discover_seq_inds","kind":13,"line":289},{"line":289,"containerName":"_discover_seq_inds","kind":13,"name":"$b"},{"name":"%nomatchList_sbjct","containerName":"_discover_seq_inds","kind":13,"line":289},{"name":"$fields","containerName":"_discover_seq_inds","kind":13,"line":290},{"name":"@gapList_sbjct","containerName":"_discover_seq_inds","kind":13,"line":290},{"line":291,"containerName":"_discover_seq_inds","kind":13,"name":"$fields"},{"line":291,"name":"$a","kind":13,"containerName":"_discover_seq_inds"},{"line":291,"name":"$b","containerName":"_discover_seq_inds","kind":13},{"line":291,"kind":13,"containerName":"_discover_seq_inds","name":"%identicalList_query"},{"line":292,"kind":13,"containerName":"_discover_seq_inds","name":"$fields"},{"name":"$a","kind":13,"containerName":"_discover_seq_inds","line":292},{"line":292,"name":"$b","containerName":"_discover_seq_inds","kind":13},{"line":292,"containerName":"_discover_seq_inds","kind":13,"name":"%conservedList_query"},{"line":293,"containerName":"_discover_seq_inds","kind":13,"name":"$fields"},{"line":293,"name":"$a","kind":13,"containerName":"_discover_seq_inds"},{"kind":13,"containerName":"_discover_seq_inds","name":"$b","line":293},{"name":"%nomatchList_query","containerName":"_discover_seq_inds","kind":13,"line":293},{"kind":13,"containerName":"_discover_seq_inds","name":"$fields","line":294},{"line":294,"containerName":"_discover_seq_inds","kind":13,"name":"@gapList_query"},{"line":296,"containerName":"_discover_seq_inds","kind":13,"name":"$fields"}],"definition":"sub","range":{"start":{"character":0,"line":234},"end":{"line":297,"character":9999}},"kind":12,"line":234},{"line":287,"name":"hit_identical_inds","kind":12},{"name":"hit_conserved_inds","kind":12,"line":288},{"line":289,"name":"hit_nomatch_inds","kind":12},{"kind":12,"name":"hit_gap_inds","line":290},{"name":"query_identical_inds","kind":12,"line":291},{"kind":12,"name":"query_conserved_inds","line":292},{"name":"query_nomatch_inds","kind":12,"line":293},{"kind":12,"name":"query_gap_inds","line":294},{"line":296,"kind":12,"name":"seq_inds"},{"definition":"sub","name":"query","containerName":"main::","children":[{"definition":"my","localvar":"my","containerName":"query","kind":13,"name":"$self","line":310},{"name":"$self","kind":13,"containerName":"query","line":311},{"line":312,"containerName":"query","kind":13,"name":"$self"},{"kind":13,"containerName":"query","name":"$self","line":313},{"line":313,"containerName":"query","kind":12,"name":"primary_tag"},{"name":"$self","containerName":"query","kind":13,"line":314},{"containerName":"query","kind":12,"name":"get_field","line":314},{"line":315,"name":"$self","containerName":"query","kind":13},{"name":"get_field","kind":12,"containerName":"query","line":315},{"line":316,"name":"$self","containerName":"query","kind":13},{"line":316,"containerName":"query","kind":12,"name":"get_field"},{"containerName":"query","kind":13,"name":"$self","line":317},{"line":317,"name":"get_field","containerName":"query","kind":12},{"name":"$self","kind":13,"containerName":"query","line":318},{"line":318,"kind":12,"containerName":"query","name":"get_field"},{"containerName":"query","kind":13,"name":"$self","line":319},{"containerName":"query","kind":12,"name":"get_field","line":319},{"line":320,"name":"$self","kind":13,"containerName":"query"},{"line":320,"containerName":"query","kind":12,"name":"get_field"},{"line":321,"name":"$self","kind":13,"containerName":"query"},{"kind":12,"containerName":"query","name":"get_field","line":321},{"line":322,"name":"$self","containerName":"query","kind":13},{"kind":12,"containerName":"query","name":"get_field","line":322},{"name":"$self","containerName":"query","kind":13,"line":325},{"name":"$self","containerName":"query","kind":13,"line":327}],"kind":12,"range":{"end":{"character":9999,"line":328},"start":{"line":309,"character":0}},"line":309},{"name":"_created_query","kind":12,"line":311},{"line":312,"containerName":"query","kind":12,"name":"SUPER"},{"containerName":"SeqFeature::Similarity","kind":12,"name":"Bio","line":313},{"line":325,"kind":12,"name":"_created_query"},{"line":327,"name":"SUPER","containerName":"query","kind":12},{"name":"hit","containerName":"main::","children":[{"line":341,"name":"$self","containerName":"hit","localvar":"my","kind":13,"definition":"my"},{"name":"$self","kind":13,"containerName":"hit","line":342},{"kind":13,"containerName":"hit","name":"$self","line":343},{"line":344,"name":"$self","kind":13,"containerName":"hit"},{"line":344,"name":"primary_tag","containerName":"hit","kind":12},{"name":"$self","containerName":"hit","kind":13,"line":345},{"kind":12,"containerName":"hit","name":"get_field","line":345},{"line":346,"name":"$self","containerName":"hit","kind":13},{"name":"get_field","kind":12,"containerName":"hit","line":346},{"line":347,"containerName":"hit","kind":13,"name":"$self"},{"kind":12,"containerName":"hit","name":"get_field","line":347},{"name":"$self","kind":13,"containerName":"hit","line":348},{"kind":12,"containerName":"hit","name":"get_field","line":348},{"containerName":"hit","kind":13,"name":"$self","line":349},{"line":349,"name":"get_field","kind":12,"containerName":"hit"},{"containerName":"hit","kind":13,"name":"$self","line":350},{"line":350,"kind":12,"containerName":"hit","name":"get_field"},{"line":351,"containerName":"hit","kind":13,"name":"$self"},{"name":"get_field","kind":12,"containerName":"hit","line":351},{"kind":13,"containerName":"hit","name":"$self","line":352},{"name":"get_field","containerName":"hit","kind":12,"line":352},{"name":"$self","kind":13,"containerName":"hit","line":353},{"name":"get_field","containerName":"hit","kind":12,"line":353},{"line":356,"name":"$self","containerName":"hit","kind":13},{"containerName":"hit","kind":13,"name":"$self","line":358}],"definition":"sub","range":{"start":{"line":340,"character":0},"end":{"line":359,"character":9999}},"kind":12,"line":340},{"kind":12,"name":"_created_hit","line":342},{"name":"SUPER","containerName":"hit","kind":12,"line":343},{"line":344,"kind":12,"containerName":"SeqFeature::Similarity","name":"Bio"},{"line":356,"kind":12,"name":"_created_hit"},{"line":358,"name":"SUPER","kind":12,"containerName":"hit"},{"signature":{"documentation":"1;\n# $Id: BlastPullHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::BlastPullHSP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::BlastPullHSP - A parser and HSP object for BlastN hsps\n\n=head1 SYNOPSIS\n\n    # generally we use Bio::SearchIO to build these objects\n    use Bio::SearchIO;\n    my $in = Bio::SearchIO->new(-format => 'hmmer_pull',\n\t\t\t\t\t\t\t   -file   => 'result.blast');\n\n    while (my $result = $in->next_result) {\n\t\twhile (my $hit = $result->next_hit) {\n\t\t\tprint $hit->name, \"\\n\";\n\t\t\tprint $hit->score, \"\\n\";\n\t\t\tprint $hit->significance, \"\\n\";\n\n\t\t\twhile (my $hsp = $hit->next_hsp) {\n\t\t\t\t# process HSPI objects\n\t\t\t}\n\t\t}\n    }\n\n=head1 DESCRIPTION\n\nThis object implements a parser for BlastN hsp output.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::BlastPullHSP;\n\nuse strict;\nuse base qw(Bio::Search::HSP::PullHSPI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::HSP::BlastNHSP->new();\n Function: Builds a new Bio::Search::HSP::BlastNHSP object.\n Returns : Bio::Search::HSP::BlastNHSP\n Args    : -chunk  => [Bio::Root::IO, $start, $end] (required if no -parent)\n           -parent => Bio::PullParserI object (required if no -chunk)\n\n           where the array ref provided to -chunk contains an IO object\n           for a filehandle to something representing the raw data of the\n           hsp, and $start and $end define the tell() position within the\n           filehandle that the hsp data starts and ends (optional; defaults\n           to start and end of the entire thing described by the filehandle)\n\n\nsub new {\n    my ($class, @args) = @_;\n\tmy $self = $class->SUPER::new(@args);\n\t\n\t$self->_setup(@args);\n\t\n\tmy $fields = $self->_fields;\n\tforeach my $field (qw( header alignment query_strand hit_strand )) {\n\t\t$fields->{$field} = undef;\n\t}\n\t\n\t$self->_dependencies( { ( score => 'header',\n                              bits => 'header',\n                              evalue => 'header',\n                              total_gaps => 'header',\n                              query_strand => 'header',\n                              hit_strand => 'header',\n                              alignment => 'header',\n                              query_string => 'alignment',\n                              hit_string => 'alignment',\n                              homology_string => 'alignment',\n                              query_start => 'alignment',\n                              query_end => 'alignment',\n                              hit_start => 'alignment',\n                              hit_end => 'alignment',\n                              hit_identical_inds => 'seq_inds',\n\t\t\t\t\t\t\t  hit_conserved_inds => 'seq_inds',\n\t\t\t\t\t\t\t  hit_nomatch_inds => 'seq_inds',\n                              hit_gap_inds => 'seq_inds',\n                              query_identical_inds => 'seq_inds',\n\t\t\t\t\t\t\t  query_conserved_inds => 'seq_inds',\n\t\t\t\t\t\t\t  query_nomatch_inds => 'seq_inds',\n\t\t\t\t\t\t\t  query_gap_inds => 'seq_inds' ) } );\n\t\n    return $self;\n}\n\n#\n# PullParserI discovery methods so we can answer all HitI questions\n#\n\nsub _discover_header {\n    my $self = shift;\n    $self->_chunk_seek(0);\n\tmy $header = $self->_get_chunk_by_end(\"\\nQuery\");\n\t$self->{_after_header} = $self->_chunk_tell;\n\t\n\t($self->_fields->{bits}, $self->_fields->{score}, $self->_fields->{evalue},\n     $self->_fields->{total_gaps}, $self->_fields->{query_strand}, $self->_fields->{hit_strand})\n     = $header =~ /^\\s*(\\S+) bits \\((\\d+)\\),\\s+Expect = (\\S+)(?:\\s+.+Gaps = (\\d+))?(?:.+Strand\\s*=\\s*(\\w+)\\s*\\/\\s*(\\w+))?/sm;\n    \n    if ($self->_fields->{query_strand}) {\n        # protein blasts don't have strand\n        for my $strand_type ('query_strand', 'hit_strand') {\n            $self->_fields->{$strand_type} = $self->_fields->{$strand_type} eq 'Plus' ? 1 : -1;\n        }\n    }\n    else {\n        $self->_fields->{query_strand} = 0;\n        $self->_fields->{hit_strand} = 0;\n    }\n\t\n\tif ($self->_fields->{evalue} =~ /^e/) {\n\t\t$self->_fields->{evalue} = '1'.$self->_fields->{evalue};\n\t}\n    \n    # query_gaps isn't always given\n    $self->_fields->{total_gaps} = '[unset]' unless $self->_fields->{total_gaps};\n    \n\t$self->_fields->{header} = 1;\n}\n\nsub _discover_alignment {\n    my $self = shift;\n    $self->_chunk_seek($self->{_after_header});\n    \n    # work out various basic fields for the hsp\n    # (quicker to do this all at once instead of each method working on\n    # alignment itself)\n    my ($query_string, $hit_string, $homology_string, $q_start, $h_start, $q_end, $h_end);\n    while (my $strip = $self->_get_chunk_by_end(\"\\nQuery\") || $self->_get_chunk_by_nol(4)) {\n        $strip =~ /\\s+(\\d+)\\s+(\\S+)\\s+(\\d+)\\s+(\\S.+)\\nSbjct:?\\s+(\\d+)\\s+(\\S+)\\s+(\\d+)/gm || last;\n        my $q1 = $1;\n        $query_string .= $2;\n        my $q2 = $3;\n        my $hom = $4;\n        my $h1 = $5;\n        $hit_string .= $6;\n        my $h2 = $7;\n        \n        $hom = ' 'x(length($6) - length($hom)).$hom;\n        $homology_string .= $hom;\n        \n        for my $q ($q1, $q2) {\n            if (! defined $q_start || $q < $q_start) {\n                $q_start = $q;\n            }\n            if (! defined $q_end || $q > $q_end) {\n                $q_end = $q;\n            }\n        }\n        for my $h ($h1, $h2) {\n            if (! defined $h_start || $h < $h_start) {\n                $h_start = $h;\n            }\n            if (! defined $h_end || $h > $h_end) {\n                $h_end = $h;\n            }\n        }\n    }\n    \n    $self->_fields->{query_string} = $query_string;\n    $self->_fields->{hit_string} = $hit_string;\n    $self->_fields->{homology_string} = $homology_string;\n    \n    $self->_fields->{query_start} = $q_start;\n    $self->_fields->{query_end} = $q_end;\n    $self->_fields->{hit_start} = $h_start;\n    $self->_fields->{hit_end} = $h_end;\n    \n    ($self->{_query_gaps}) = $query_string =~ tr/-//;\n    ($self->{_hit_gaps}) = $hit_string =~ tr/-//;\n    ($self->{_total_gaps}) = $self->{_query_gaps} + $self->{_hit_gaps};\n    \n    $self->_fields->{alignment} = 1; # stop this method being called again\n}\n\n# seq_inds related methods, all just need seq_inds field to have been gotten\nsub _discover_seq_inds {\n    my $self = shift;\n    my ($seqString, $qseq, $sseq) = ( $self->get_field('homology_string'),\n                                      $self->get_field('query_string'),\n                                      $self->get_field('hit_string') );\n    \n    # (code largely lifted from GenericHSP)\n    \n    # Using hashes to avoid saving duplicate residue numbers.\n    my %identicalList_query = ();\n    my %identicalList_sbjct = ();\n    my %conservedList_query = ();\n    my %conservedList_sbjct = ();\n    my @gapList_query = ();\n    my @gapList_sbjct = ();\n    my %nomatchList_query = ();\n    my %nomatchList_sbjct = ();\n    \n    my $resCount_query = $self->get_field('query_end');\n    my $resCount_sbjct = $self->get_field('hit_end');\n    \n    my ($mchar, $schar, $qchar);\n    while ($mchar = chop($seqString) ) {\n        ($qchar, $schar) = (chop($qseq), chop($sseq));\n        \n        if ($mchar eq '+' || $mchar eq '.' || $mchar eq ':') { \n            $conservedList_query{ $resCount_query } = 1; \n            $conservedList_sbjct{ $resCount_sbjct } = 1;\n        }\n        elsif ($mchar eq ' ') { \n            $nomatchList_query{ $resCount_query } = 1;\n            $nomatchList_sbjct{ $resCount_sbjct } = 1;\n        }\n        else { \n            $identicalList_query{ $resCount_query } = 1; \n            $identicalList_sbjct{ $resCount_sbjct } = 1;\n        }\n        \n        if ($qchar eq '-') {\n            push(@gapList_query, $resCount_query);\n        }\n        else { \t    \n            $resCount_query -= 1;\n        }\n        if ($schar eq '-') {\n            push(@gapList_sbjct, $resCount_sbjct);\n        }\n        else { \t    \n            $resCount_sbjct -= 1;\n        }\n    }\n    \n    my $fields = $self->_fields;\n    $fields->{hit_identical_inds} = [ sort { $a <=> $b } keys %identicalList_sbjct ];\n    $fields->{hit_conserved_inds} = [ sort { $a <=> $b } keys %conservedList_sbjct ];\n    $fields->{hit_nomatch_inds} = [ sort { $a <=> $b } keys %nomatchList_sbjct ];\n    $fields->{hit_gap_inds} = [ reverse @gapList_sbjct ];\n    $fields->{query_identical_inds} = [ sort { $a <=> $b } keys %identicalList_query ];\n    $fields->{query_conserved_inds} = [ sort { $a <=> $b } keys %conservedList_query ];\n    $fields->{query_nomatch_inds} = [ sort { $a <=> $b } keys %nomatchList_query ];\n    $fields->{query_gap_inds} = [ reverse @gapList_query ];\n    \n    $fields->{seq_inds} = 1;\n}\n\n=head2 query\n\n Title   : query\n Usage   : my $query = $hsp->query\n Function: Returns a SeqFeature representing the query in the HSP\n Returns : L<Bio::SeqFeature::Similarity>\n Args    : none\n\n\nsub query {\n    my $self = shift;\n    unless ($self->{_created_query}) {\n        $self->SUPER::query( new  Bio::SeqFeature::Similarity\n                  ('-primary'  => $self->primary_tag,\n                   '-start'    => $self->get_field('query_start'),\n                   '-end'      => $self->get_field('query_end'),\n                   '-expect'   => $self->get_field('evalue'),\n                   '-score'    => $self->get_field('score'),\n                   '-strand'   => $self->get_field('query_strand'),\n                   '-seq_id'   => $self->get_field('query_name'),\n                   '-seqlength'=> $self->get_field('query_length'),\n                   '-source'   => $self->get_field('algorithm'),\n                   '-seqdesc'  => $self->get_field('query_description'),\n                   '-frame'    => 0 # not known?\n                   ) );\n\t\t$self->{_created_query} = 1;\n    }\n    return $self->SUPER::query(@_);\n}\n\n=head2 hit\n\n Title   : hit\n Usage   : my $hit = $hsp->hit\n Function: Returns a SeqFeature representing the hit in the HSP\n Returns : L<Bio::SeqFeature::Similarity>\n Args    : [optional] new value to set\n\n\nsub hit {\n    my $self = shift;\n    unless ($self->{_created_hit}) {\n        $self->SUPER::hit( new  Bio::SeqFeature::Similarity\n                  ('-primary'  => $self->primary_tag,\n                   '-start'    => $self->get_field('hit_start'),\n                   '-end'      => $self->get_field('hit_end'),\n                   '-expect'   => $self->get_field('evalue'),\n                   '-score'    => $self->get_field('score'),\n                   '-strand'   => $self->get_field('hit_strand'),\n                   '-seq_id'   => $self->get_field('name'),\n                   '-seqlength'=> $self->get_field('length'),\n                   '-source'   => $self->get_field('algorithm'),\n                   '-seqdesc'  => $self->get_field('description'),\n                   '-frame'    => 0 # not known?\n                   ) );\n\t\t$self->{_created_hit} = 1;\n    }\n    return $self->SUPER::hit(@_);\n}\n\n=head2 gaps\n\n Title    : gaps\n Usage    : my $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n Function : Get the number of gap characters in the query, hit, or total alignment.\n Returns  : Integer, number of gap characters or 0 if none\n Args     : 'query' = num conserved / length of query seq (without gaps)\n            'hit'   = num conserved / length of hit seq (without gaps)\n            'total' = num conserved / length of alignment (with gaps)\n            default = 'total' ","parameters":[{"label":"$self"},{"label":"$type"}],"label":"gaps($self,$type)"},"line":374,"range":{"end":{"character":9999,"line":389},"start":{"line":374,"character":0}},"kind":12,"definition":"sub","detail":"($self,$type)","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"gaps","line":375},{"name":"$type","kind":13,"containerName":"gaps","line":375},{"line":377,"containerName":"gaps","kind":13,"name":"$type"},{"line":377,"containerName":"gaps","kind":13,"name":"$type"},{"line":377,"name":"$type","kind":13,"containerName":"gaps"},{"containerName":"gaps","kind":13,"name":"$type","line":378},{"kind":13,"containerName":"gaps","name":"$type","line":378},{"kind":13,"containerName":"gaps","name":"$type","line":378},{"line":378,"name":"$type","kind":13,"containerName":"gaps"},{"name":"$type","kind":13,"containerName":"gaps","line":379},{"kind":13,"containerName":"gaps","name":"$type","line":379},{"line":381,"kind":13,"containerName":"gaps","name":"$type"},{"line":382,"localvar":"my","containerName":"gaps","kind":13,"name":"$answer","definition":"my"},{"name":"$self","containerName":"gaps","kind":13,"line":382},{"line":382,"name":"get_field","kind":12,"containerName":"gaps"},{"line":383,"name":"$answer","kind":13,"containerName":"gaps"},{"line":383,"kind":13,"containerName":"gaps","name":"$answer"},{"line":386,"name":"$self","containerName":"gaps","kind":13},{"name":"get_field","kind":12,"containerName":"gaps","line":386},{"name":"$self","kind":13,"containerName":"gaps","line":388},{"name":"$type","containerName":"gaps","kind":13,"line":388}],"containerName":"main::","name":"gaps"},{"containerName":"main::","name":"strand","children":[{"definition":"my","line":404,"localvar":"my","containerName":"strand","kind":13,"name":"$self"},{"line":405,"name":"$val","localvar":"my","containerName":"strand","kind":13,"definition":"my"},{"name":"$val","kind":13,"containerName":"strand","line":406},{"name":"$val","containerName":"strand","kind":13,"line":406},{"line":407,"name":"$val","kind":13,"containerName":"strand"},{"line":409,"name":"$val","kind":13,"containerName":"strand"},{"name":"$self","containerName":"strand","kind":13,"line":410},{"line":410,"containerName":"strand","kind":12,"name":"get_field"},{"line":412,"kind":13,"containerName":"strand","name":"$val"},{"line":413,"name":"$self","containerName":"strand","kind":13},{"line":413,"name":"get_field","kind":12,"containerName":"strand"},{"line":415,"name":"$val","kind":13,"containerName":"strand"},{"line":416,"name":"$self","kind":13,"containerName":"strand"},{"line":416,"kind":12,"containerName":"strand","name":"get_field"},{"line":416,"name":"$self","containerName":"strand","kind":13},{"line":416,"kind":12,"containerName":"strand","name":"get_field"},{"name":"$self","kind":13,"containerName":"strand","line":419},{"name":"warn","containerName":"strand","kind":12,"line":419}],"definition":"sub","kind":12,"range":{"start":{"line":403,"character":0},"end":{"line":422,"character":9999}},"line":403},{"definition":"sub","children":[{"line":437,"name":"$self","localvar":"my","containerName":"start","kind":13,"definition":"my"},{"definition":"my","line":438,"kind":13,"localvar":"my","containerName":"start","name":"$val"},{"line":439,"kind":13,"containerName":"start","name":"$val"},{"name":"$val","kind":13,"containerName":"start","line":439},{"containerName":"start","kind":13,"name":"$val","line":440},{"line":442,"containerName":"start","kind":13,"name":"$val"},{"line":443,"containerName":"start","kind":13,"name":"$self"},{"name":"get_field","kind":12,"containerName":"start","line":443},{"line":445,"kind":13,"containerName":"start","name":"$val"},{"line":446,"name":"$self","kind":13,"containerName":"start"},{"kind":12,"containerName":"start","name":"get_field","line":446},{"name":"$val","kind":13,"containerName":"start","line":448},{"name":"$self","kind":13,"containerName":"start","line":449},{"line":449,"kind":12,"containerName":"start","name":"get_field"},{"line":449,"kind":13,"containerName":"start","name":"$self"},{"line":449,"containerName":"start","kind":12,"name":"get_field"},{"name":"$self","containerName":"start","kind":13,"line":452},{"kind":12,"containerName":"start","name":"warn","line":452}],"name":"start","containerName":"main::","line":436,"range":{"end":{"line":455,"character":9999},"start":{"character":0,"line":436}},"kind":12},{"line":469,"range":{"end":{"line":488,"character":9999},"start":{"character":0,"line":469}},"kind":12,"definition":"sub","children":[{"definition":"my","line":470,"kind":13,"localvar":"my","containerName":"end","name":"$self"},{"definition":"my","localvar":"my","kind":13,"containerName":"end","name":"$val","line":471},{"containerName":"end","kind":13,"name":"$val","line":472},{"containerName":"end","kind":13,"name":"$val","line":472},{"name":"$val","containerName":"end","kind":13,"line":473},{"line":475,"name":"$val","containerName":"end","kind":13},{"name":"$self","containerName":"end","kind":13,"line":476},{"kind":12,"containerName":"end","name":"get_field","line":476},{"kind":13,"containerName":"end","name":"$val","line":478},{"name":"$self","containerName":"end","kind":13,"line":479},{"line":479,"name":"get_field","kind":12,"containerName":"end"},{"kind":13,"containerName":"end","name":"$val","line":481},{"line":482,"containerName":"end","kind":13,"name":"$self"},{"name":"get_field","kind":12,"containerName":"end","line":482},{"line":482,"name":"$self","kind":13,"containerName":"end"},{"line":482,"kind":12,"containerName":"end","name":"get_field"},{"line":485,"containerName":"end","kind":13,"name":"$self"},{"line":485,"name":"warn","kind":12,"containerName":"end"}],"name":"end","containerName":"main::"},{"line":500,"range":{"end":{"character":9999,"line":500},"start":{"character":0,"line":500}},"kind":12,"children":[],"containerName":"main::","name":"pvalue","definition":"sub"}],"version":5}