{"vars":[{"line":160,"name":"UNIVERSAL","containerName":"","kind":2},{"line":164,"kind":2,"containerName":"","name":"base"},{"containerName":"main::","name":"new","children":[{"name":"$class","kind":13,"localvar":"my","containerName":"new","line":181,"definition":"my"},{"name":"@args","kind":13,"containerName":"new","line":181},{"definition":"my","line":182,"name":"$self","containerName":"new","localvar":"my","kind":13},{"kind":13,"containerName":"new","name":"$class","line":182},{"name":"@args","kind":13,"containerName":"new","line":182},{"line":184,"localvar":"my","kind":13,"containerName":"new","name":"$empty","definition":"my"},{"name":"$enzymes","kind":13,"containerName":"new","line":184},{"name":"$self","kind":13,"containerName":"new","line":185},{"line":185,"kind":12,"containerName":"new","name":"_rearrange"},{"line":189,"name":"@args","containerName":"new","kind":13},{"name":"$self","kind":13,"containerName":"new","line":191},{"name":"$self","containerName":"new","kind":13,"line":192},{"kind":13,"containerName":"new","name":"$self","line":194},{"line":194,"containerName":"new","kind":13,"name":"$empty"},{"line":197,"name":"$enzymes","containerName":"new","kind":13},{"line":199,"name":"$self","containerName":"new","kind":13},{"name":"throw","kind":12,"containerName":"new","line":199},{"name":"$enzymes","kind":13,"containerName":"new","line":199},{"containerName":"new","kind":13,"name":"$self","line":200},{"line":200,"kind":12,"containerName":"new","name":"enzymes"},{"name":"$enzymes","kind":13,"containerName":"new","line":200},{"line":201,"name":"$self","kind":13,"containerName":"new"},{"line":205,"containerName":"new","localvar":"my","kind":13,"name":"$in","definition":"my"},{"name":"new","kind":12,"containerName":"new","line":205},{"line":205,"name":"$self","kind":13,"containerName":"new"},{"line":205,"name":"verbose","containerName":"new","kind":12},{"kind":13,"containerName":"new","name":"$in","line":206},{"line":206,"kind":12,"containerName":"new","name":"read"}],"detail":"($class,@args)","definition":"sub","range":{"start":{"line":180,"character":0},"end":{"line":208,"character":9999}},"kind":12,"line":180,"signature":{"documentation":"1;\n# $Id: EnzymeCollection.pm 16123 2009-09-17 12:57:27Z cjfields $\n#-------------------------------------------------------------------------------\n#\n# BioPerl module Bio::Restriction::EnzymeCollection\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Rob Edwards <redwards@utmem.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#-------------------------------------------------------------------------------\n\n## POD Documentation:\n\n=head1 NAME\n\nBio::Restriction::EnzymeCollection - Set of restriction endonucleases\n\n=head1 SYNOPSIS\n\n  use Bio::Restriction::EnzymeCollection;\n\n  # Create a collection with the default enzymes.\n  my $default_collection = Bio::Restriction::EnzymeCollection->new();\n\n  # Or create a collection from a REBASE 'withrefm' file obtained from\n  # ftp://ftp.neb.com/pub/rebase/. (See Bio::Restriction::IO for more\n  # information.)\n  my $rebase = Bio::Restriction::IO->new(\n      -file   => 'withrefm.610',\n      -format => 'withrefm' );\n  my $rebase_collection = $rebase->read();\n\n  # Or create an empty collection and set the enzymes later. See\n  # 'CUSTOM COLLECTIONS' below for more information.\n  my $empty_collection =\n    Bio::Restriction::EnzymeCollection->new( -empty => 1 );\n\n  # Get an array of Bio::Restriction::Enzyme objects from the collection.\n  my @enzymes = $default_collection->each_enzyme();\n\n  # Get a Bio::Restriction::Enzyme object for a particular enzyme by name.\n  my $enz = $default_collection->get_enzyme( 'EcoRI' );\n\n  # Get a Bio::Restriction::EnzymeCollection object containing the enzymes\n  # that have the equivalent of 6-bp recognition sequences.\n  my $six_cutters = $default_collection->cutters( 6 );\n\n  # Get a Bio::Restriction::EnzymeCollection object containing the enzymes\n  # that are rare cutters.\n  my $rare_cutters = $default_collection->cutters( -start => 6, -end => 8 );\n\n  # Get a Bio::Restriction::EnzymeCollection object that contains enzymes\n  # that generate blunt ends:\n  my $blunt_cutters = $default_collection->blunt_enzymes();\n\n  # See 'CUSTOM COLLECTIONS' below for an example of creating a\n  # Bio::Restriction::EnzymeCollection object with a specified subset of\n  # enzymes using methods provided by the Bio::RestrictionEnzyme class.\n\n=head1 DESCRIPTION\n\nBio::Restriction::EnzymeCollection represents a collection of\nrestriction enzymes.\n\nIf you create a new collection directly rather than from a REBASE\nfile using L<Bio::Restriction::IO>, it will be populated by a\ndefault set of enzymes with site and cut information\nonly.\n\nUse L<Bio::Restriction::Analysis> to figure out which enzymes are\navailable and where they cut your sequence.\n\n=head1 CUSTOM COLLECTIONS\n\nNote that the underlying L<Bio::Restriction::Enzyme> objects have a rich\nvariety of methods that allow more complicated selections than the methods\nthat are defined by Bio::Restriction::EnzymeCollection.\n\nFor example, the way to create a custom collection of Type II enzymes\nis as follows:\n\n  my $complete_collection =\n      Bio::Restriction::EnzymeCollection->new();\n  my $type_ii_collection  =\n      Bio::Restriction::EnzymeCollection->new( -empty => 1 );\n  $type_ii_collection->enzymes(\n      grep { $_->type() eq 'II' } $complete_collection->each_enzyme() );\n\n=head1 SEE ALSO\n\nL<Bio::Restriction::IO> - read in enzymes from REBASE files\n\nL<Bio::Restriction::Analysis> - figure out what enzymes cut a sequence\n\nL<Bio::Restriction::Enzyme> - define a single restriction enzyme\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists \n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nRob Edwards, redwards@utmem.edu\n\n=head1 CONTRIBUTORS\n\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 COPYRIGHT\n\nCopyright (c) 2003 Rob Edwards.\n\nSome of this work is Copyright (c) 1997-2002 Steve A. Chervitz. All\nRights Reserved.\n\nThis module is free software; you can redistribute it and/or modify it\nunder the same terms as Perl itself.\n\n=head1 APPENDIX\n\nMethods beginning with a leading underscore are considered private and\nare intended for internal use by this module. They are not considered\npart of the public interface and are described here for documentation\npurposes only.\n\n\n\npackage Bio::Restriction::EnzymeCollection;\nuse strict;\n\nuse Bio::Restriction::Enzyme;\nuse Bio::Restriction::IO;\nuse UNIVERSAL qw(isa);\n\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title     : new\n Function  : Initializes the Restriction::EnzymeCollection object\n Returns   : The Restriction::EnzymeCollection object\n Arguments : optional named parameter -empty\n\nSet parameter -empty to true if you do NOT want the collection be\npopulated by the default set of prototype type II enzymes.\n\nAlternatively, pass an array of enzymes to -enzymes parameter.","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"}},{"line":182,"name":"SUPER","containerName":"new","kind":12},{"kind":12,"containerName":"Restriction::IO","name":"Bio","line":205},{"range":{"end":{"character":9999,"line":241},"start":{"line":224,"character":0}},"kind":12,"line":224,"signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"@enzs"}],"label":"enzymes($self,@enzs)"},"containerName":"main::","name":"enzymes","children":[{"kind":13,"localvar":"my","containerName":"enzymes","name":"$self","line":225,"definition":"my"},{"containerName":"enzymes","kind":13,"name":"@enzs","line":225},{"definition":"my","line":226,"containerName":"enzymes","localvar":"my","kind":13,"name":"$e"},{"line":226,"name":"@enzs","containerName":"enzymes","kind":13},{"line":227,"name":"$e","containerName":"enzymes","kind":13},{"line":230,"name":"$e","containerName":"enzymes","kind":13},{"line":230,"containerName":"enzymes","kind":12,"name":"isa"},{"line":231,"name":"$self","kind":13,"containerName":"enzymes"},{"line":231,"containerName":"enzymes","kind":13,"name":"$e"},{"containerName":"enzymes","kind":13,"name":"$self","line":232},{"name":"$e","containerName":"enzymes","kind":13,"line":232},{"name":"name","kind":12,"containerName":"enzymes","line":232},{"line":232,"kind":13,"containerName":"enzymes","name":"$e"},{"kind":13,"containerName":"enzymes","name":"$e","line":234},{"containerName":"enzymes","kind":12,"name":"isa","line":234},{"name":"$self","kind":13,"containerName":"enzymes","line":235},{"containerName":"enzymes","kind":12,"name":"enzymes","line":235},{"line":235,"name":"$e","containerName":"enzymes","kind":13},{"kind":12,"containerName":"enzymes","name":"each_enzyme","line":235},{"line":237,"localvar":"my","kind":13,"containerName":"enzymes","name":"$r","definition":"my"},{"line":238,"kind":13,"containerName":"enzymes","name":"$self"},{"kind":12,"containerName":"enzymes","name":"warn","line":238},{"name":"$e","kind":13,"containerName":"enzymes","line":239}],"detail":"($self,@enzs)","definition":"sub"},{"line":242,"kind":13,"containerName":null,"name":"$self"},{"range":{"start":{"line":258,"character":0},"end":{"character":9999,"line":260}},"kind":12,"line":258,"definition":"sub","name":"each_enzyme","containerName":"main::","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"each_enzyme","name":"$self","line":259},{"line":260,"name":"$self","containerName":"each_enzyme","kind":13}]},{"line":272,"range":{"end":{"character":9999,"line":275},"start":{"line":272,"character":0}},"kind":12,"signature":{"label":"get_enzyme($self,$name)","documentation":"","parameters":[{"label":"$self"},{"label":"$name"}]},"children":[{"definition":"my","line":273,"localvar":"my","kind":13,"containerName":"get_enzyme","name":"$self"},{"kind":13,"containerName":"get_enzyme","name":"$name","line":273},{"kind":13,"containerName":"get_enzyme","name":"$self","line":274},{"containerName":"get_enzyme","kind":13,"name":"$name","line":274}],"name":"get_enzyme","containerName":"main::","definition":"sub","detail":"($self,$name)"},{"detail":"($self,$size)","definition":"sub","containerName":"main::","name":"available_list","children":[{"definition":"my","line":291,"containerName":"available_list","localvar":"my","kind":13,"name":"$self"},{"line":291,"kind":13,"containerName":"available_list","name":"$size"},{"localvar":"my","containerName":"available_list","kind":13,"name":"@keys","line":292,"definition":"my"},{"line":292,"name":"$self","kind":13,"containerName":"available_list"}],"signature":{"label":"available_list($self,$size)","documentation":"","parameters":[{"label":"$self"},{"label":"$size"}]},"range":{"start":{"character":0,"line":290},"end":{"character":9999,"line":292}},"kind":12,"line":290},{"line":293,"name":"@keys","kind":13,"containerName":null},{"name":"longest_cutter","containerName":"main::","children":[{"definition":"my","line":308,"name":"$self","containerName":"longest_cutter","localvar":"my","kind":13},{"localvar":"my","kind":13,"containerName":"longest_cutter","name":"$longest","line":309,"definition":"my"},{"definition":"my","name":"$longest_enz","kind":13,"localvar":"my","containerName":"longest_cutter","line":309},{"line":310,"kind":13,"localvar":"my","containerName":"longest_cutter","name":"$enz","definition":"my"},{"line":310,"kind":13,"containerName":"longest_cutter","name":"$self"},{"line":310,"name":"each_enzyme","containerName":"longest_cutter","kind":12},{"localvar":"my","containerName":"longest_cutter","kind":13,"name":"$len","line":311,"definition":"my"},{"containerName":"longest_cutter","kind":13,"name":"$enz","line":311},{"line":311,"name":"recognition_length","kind":12,"containerName":"longest_cutter"},{"containerName":"longest_cutter","kind":13,"name":"$len","line":312},{"line":312,"kind":13,"containerName":"longest_cutter","name":"$longest"},{"line":312,"containerName":"longest_cutter","kind":13,"name":"$longest"},{"name":"$len","containerName":"longest_cutter","kind":13,"line":312},{"line":312,"name":"$longest_enz","containerName":"longest_cutter","kind":13},{"line":312,"kind":13,"containerName":"longest_cutter","name":"$enz"},{"kind":13,"containerName":"longest_cutter","name":"$longest_enz","line":314}],"detail":"($self)","definition":"sub","kind":12,"range":{"start":{"character":0,"line":307},"end":{"character":9999,"line":315}},"line":307,"signature":{"label":"longest_cutter($self)","documentation":"","parameters":[{"label":"$self"}]}},{"range":{"start":{"line":335,"character":0},"end":{"line":339,"character":9999}},"kind":12,"line":335,"name":"blunt_enzymes","containerName":"main::","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"blunt_enzymes","line":336},{"line":337,"containerName":"blunt_enzymes","localvar":"my","kind":13,"name":"$bs","definition":"my"},{"containerName":"blunt_enzymes","kind":12,"name":"new","line":337},{"name":"$bs","kind":13,"containerName":"blunt_enzymes","line":338},{"name":"enzymes","containerName":"blunt_enzymes","kind":12,"line":338},{"line":338,"name":"overhang","containerName":"blunt_enzymes","kind":12},{"containerName":"blunt_enzymes","kind":13,"name":"$self","line":338},{"line":338,"name":"each_enzyme","kind":12,"containerName":"blunt_enzymes"}],"definition":"sub"},{"name":"Bio","containerName":"Restriction::EnzymeCollection","kind":12,"line":337},{"line":360,"kind":12,"range":{"end":{"line":380,"character":9999},"start":{"line":360,"character":0}},"children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"cutters","line":361},{"definition":"my","localvar":"my","containerName":"cutters","kind":13,"name":"$size","line":366},{"line":367,"name":"@sizes","containerName":"cutters","localvar":"my","kind":13,"definition":"my"},{"name":"$size","kind":13,"containerName":"cutters","line":368},{"line":368,"name":"@sizes","kind":13,"containerName":"cutters"},{"line":368,"name":"$size","kind":13,"containerName":"cutters"},{"line":368,"containerName":"cutters","kind":13,"name":"@sizes"},{"name":"$size","kind":13,"containerName":"cutters","line":368},{"definition":"my","line":369,"localvar":"my","containerName":"cutters","kind":13,"name":"$bs"},{"name":"new","containerName":"cutters","kind":12,"line":369},{"definition":"my","containerName":"cutters","localvar":"my","kind":13,"name":"$size","line":370},{"line":370,"containerName":"cutters","kind":13,"name":"@sizes"},{"kind":13,"containerName":"cutters","name":"$self","line":371},{"line":371,"name":"throw","kind":12,"containerName":"cutters"},{"name":"$size","containerName":"cutters","kind":13,"line":372},{"definition":"my","line":373,"localvar":"my","containerName":"cutters","kind":13,"name":"$e"},{"line":373,"containerName":"cutters","kind":13,"name":"$self"},{"kind":12,"containerName":"cutters","name":"each_enzyme","line":373},{"line":375,"containerName":"cutters","kind":13,"name":"$bs"},{"line":375,"kind":12,"containerName":"cutters","name":"enzymes"},{"name":"$e","kind":13,"containerName":"cutters","line":375},{"kind":13,"containerName":"cutters","name":"$e","line":375},{"line":375,"kind":12,"containerName":"cutters","name":"cutter"},{"containerName":"cutters","kind":13,"name":"$size","line":375},{"kind":13,"containerName":"cutters","name":"$bs","line":378}],"containerName":"main::","name":"cutters","definition":"sub"},{"kind":12,"containerName":"Restriction::EnzymeCollection","name":"Bio","line":369},{"definition":"my","line":382,"name":"$start","containerName":null,"localvar":"my","kind":13},{"containerName":null,"kind":13,"name":"$end","line":382},{"name":"$inclusive","containerName":null,"kind":13,"line":382},{"name":"$exclusive","containerName":null,"kind":13,"line":382},{"kind":13,"containerName":null,"name":"$self","line":383},{"line":383,"kind":12,"containerName":"main::","name":"_rearrange"},{"line":391,"name":"$self","containerName":null,"kind":13},{"name":"throw","containerName":"main::","kind":12,"line":391},{"line":392,"containerName":null,"kind":13,"name":"$start"},{"line":393,"name":"$self","containerName":null,"kind":13},{"kind":12,"containerName":"main::","name":"throw","line":393},{"name":"$end","kind":13,"containerName":null,"line":394},{"definition":"my","localvar":"my","containerName":null,"kind":13,"name":"$limits","line":396},{"name":"$inclusive","kind":13,"containerName":null,"line":397},{"containerName":null,"kind":13,"name":"$inclusive","line":397},{"line":397,"containerName":null,"kind":13,"name":"$exclusive"},{"name":"$inclusive","containerName":null,"kind":13,"line":398},{"kind":13,"containerName":null,"name":"$exclusive","line":398},{"line":400,"localvar":"my","containerName":null,"kind":13,"name":"$bs","definition":"my"},{"kind":12,"containerName":"Restriction::EnzymeCollection","name":"Bio","line":400},{"name":"new","kind":12,"containerName":"main::","line":400},{"line":401,"kind":13,"containerName":null,"name":"%inclusive"},{"line":402,"containerName":null,"localvar":"my","kind":13,"name":"$e","definition":"my"},{"containerName":null,"kind":13,"name":"$self","line":402},{"line":402,"name":"each_enzyme","kind":12,"containerName":"main::"},{"line":403,"name":"$bs","kind":13,"containerName":null},{"line":403,"name":"enzymes","kind":12,"containerName":"main::"},{"name":"$e","containerName":null,"kind":13,"line":403},{"kind":13,"containerName":null,"name":"$e","line":403},{"kind":12,"containerName":"main::","name":"cutter","line":403},{"name":"$start","kind":13,"containerName":null,"line":403},{"kind":13,"containerName":null,"name":"$e","line":403},{"kind":12,"containerName":"main::","name":"cutter","line":403},{"name":"%end","kind":13,"containerName":null,"line":403},{"definition":"my","kind":13,"localvar":"my","containerName":null,"name":"$e","line":406},{"line":406,"name":"$self","containerName":null,"kind":13},{"kind":12,"containerName":"main::","name":"each_enzyme","line":406},{"line":407,"containerName":null,"kind":13,"name":"$bs"},{"line":407,"kind":12,"containerName":"main::","name":"enzymes"},{"name":"$e","kind":13,"containerName":null,"line":407},{"kind":13,"containerName":null,"name":"$e","line":407},{"line":407,"containerName":"main::","kind":12,"name":"cutter"},{"line":407,"name":"$start","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"$e","line":407},{"line":407,"containerName":"main::","kind":12,"name":"cutter"},{"name":"$end","containerName":null,"kind":13,"line":407},{"containerName":null,"kind":13,"name":"$bs","line":410}],"version":5}