{"version":5,"vars":[{"line":94,"containerName":"","kind":2,"name":"vars"},{"line":96,"kind":2,"containerName":"","name":"base"},{"kind":13,"containerName":null,"name":"%STRAND_OPTIONS","line":100},{"signature":{"label":"_strong($r1,$r2)","parameters":[{"label":"$r1"},{"label":"$r2"}],"documentation":" utility methods\n\n returns true if strands are equal and non-zero"},"range":{"end":{"line":117,"character":9999},"start":{"line":112,"character":0}},"kind":12,"line":112,"detail":"($r1,$r2)","definition":"sub","containerName":"main::","name":"_strong","children":[{"localvar":"my","containerName":"_strong","kind":13,"name":"$r1","line":113,"definition":"my"},{"containerName":"_strong","kind":13,"name":"$r2","line":113},{"containerName":"_strong","localvar":"my","kind":13,"name":"$s1","line":114,"definition":"my"},{"name":"$s2","containerName":"_strong","kind":13,"line":114},{"line":114,"name":"$r1","kind":13,"containerName":"_strong"},{"name":"strand","containerName":"_strong","kind":12,"line":114},{"name":"$r2","kind":13,"containerName":"_strong","line":114},{"line":114,"name":"strand","kind":12,"containerName":"_strong"},{"containerName":"_strong","kind":13,"name":"$s1","line":116},{"name":"$s1","kind":13,"containerName":"_strong","line":116},{"name":"$s2","kind":13,"containerName":"_strong","line":116}]},{"name":"_weak","containerName":"main::","children":[{"definition":"my","name":"$r1","kind":13,"localvar":"my","containerName":"_weak","line":121},{"name":"$r2","kind":13,"containerName":"_weak","line":121},{"definition":"my","containerName":"_weak","localvar":"my","kind":13,"name":"$s1","line":122},{"line":122,"kind":13,"containerName":"_weak","name":"$s2"},{"containerName":"_weak","kind":13,"name":"$r1","line":122},{"line":122,"containerName":"_weak","kind":12,"name":"strand"},{"name":"$r2","kind":13,"containerName":"_weak","line":122},{"kind":12,"containerName":"_weak","name":"strand","line":122},{"line":123,"kind":13,"containerName":"_weak","name":"$s1"},{"line":123,"containerName":"_weak","kind":13,"name":"$s2"},{"name":"$s1","containerName":"_weak","kind":13,"line":123},{"containerName":"_weak","kind":13,"name":"$s2","line":123}],"detail":"($r1,$r2)","definition":"sub","range":{"end":{"line":124,"character":9999},"start":{"character":0,"line":120}},"kind":12,"line":120,"signature":{"label":"_weak($r1,$r2)","parameters":[{"label":"$r1"},{"label":"$r2"}],"documentation":" returns true if strands are equal or either is zero"}},{"line":127,"kind":12,"range":{"end":{"line":129,"character":9999},"start":{"character":0,"line":127}},"definition":"sub","children":[],"containerName":"main::","name":"_ignore"},{"definition":"sub","detail":"()","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"_testStrand","name":"$r1","line":134},{"line":134,"name":"$r2","containerName":"_testStrand","kind":13},{"kind":13,"containerName":"_testStrand","name":"$comp","line":134},{"line":135,"name":"$comp","containerName":"_testStrand","kind":13},{"containerName":"_testStrand","localvar":"my","kind":13,"name":"$func","line":136,"definition":"my"},{"name":"$STRAND_OPTIONS","kind":13,"containerName":"_testStrand","line":136},{"line":136,"name":"$comp","containerName":"_testStrand","kind":13},{"line":137,"name":"$r1","kind":13,"containerName":"_testStrand"},{"line":137,"name":"$func","containerName":"_testStrand","kind":13},{"line":137,"name":"$r2","containerName":"_testStrand","kind":13}],"containerName":"main::","name":"_testStrand","signature":{"parameters":[],"documentation":" works out what test to use for the strictness and returns true/false\n e.g. $r1->_testStrand($r2, 'strong')","label":"_testStrand()"},"line":133,"range":{"start":{"character":0,"line":133},"end":{"character":9999,"line":138}},"kind":12},{"definition":"sub","name":"start","containerName":"main::","children":[{"line":156,"containerName":"start","kind":12,"name":"throw_not_implemented"}],"range":{"start":{"line":155,"character":0},"end":{"character":9999,"line":157}},"kind":12,"line":155},{"children":[{"line":171,"name":"throw_not_implemented","kind":12,"containerName":"end"}],"name":"end","containerName":"main::","definition":"sub","line":170,"kind":12,"range":{"end":{"line":172,"character":9999},"start":{"character":0,"line":170}}},{"definition":"sub","containerName":"main::","name":"length","children":[{"line":186,"name":"throw_not_implemented","kind":12,"containerName":"length"}],"range":{"start":{"line":185,"character":0},"end":{"line":187,"character":9999}},"kind":12,"line":185},{"definition":"sub","children":[{"line":201,"kind":12,"containerName":"strand","name":"throw_not_implemented"}],"name":"strand","containerName":"main::","line":200,"kind":12,"range":{"start":{"line":200,"character":0},"end":{"line":202,"character":9999}}},{"name":"overlaps","containerName":"main::","children":[{"definition":"my","line":223,"name":"$self","containerName":"overlaps","localvar":"my","kind":13},{"name":"$other","kind":13,"containerName":"overlaps","line":223},{"line":223,"containerName":"overlaps","kind":13,"name":"$so"},{"containerName":"overlaps","kind":13,"name":"$self","line":225},{"kind":12,"containerName":"overlaps","name":"throw","line":225},{"line":225,"name":"$self","kind":13,"containerName":"overlaps"},{"name":"start","kind":12,"containerName":"overlaps","line":225},{"line":226,"name":"$self","containerName":"overlaps","kind":13},{"name":"throw","containerName":"overlaps","kind":12,"line":226},{"line":226,"name":"$self","containerName":"overlaps","kind":13},{"line":226,"containerName":"overlaps","kind":12,"name":"end"},{"containerName":"overlaps","kind":13,"name":"$self","line":227},{"name":"throw","containerName":"overlaps","kind":12,"line":227},{"kind":13,"containerName":"overlaps","name":"$other","line":227},{"name":"$other","containerName":"overlaps","kind":13,"line":228},{"line":228,"kind":12,"containerName":"overlaps","name":"isa"},{"line":229,"name":"$other","containerName":"overlaps","kind":13},{"line":229,"name":"throw","containerName":"overlaps","kind":12},{"name":"$other","kind":13,"containerName":"overlaps","line":229},{"name":"start","kind":12,"containerName":"overlaps","line":229},{"name":"$other","kind":13,"containerName":"overlaps","line":230},{"name":"throw","kind":12,"containerName":"overlaps","line":230},{"kind":13,"containerName":"overlaps","name":"$other","line":230},{"kind":12,"containerName":"overlaps","name":"end","line":230},{"containerName":"overlaps","kind":13,"name":"$self","line":233},{"kind":12,"containerName":"overlaps","name":"_testStrand","line":233},{"line":233,"kind":13,"containerName":"overlaps","name":"$other"},{"line":233,"containerName":"overlaps","kind":13,"name":"$so"},{"containerName":"overlaps","kind":13,"name":"$self","line":235},{"containerName":"overlaps","kind":12,"name":"start","line":235},{"kind":13,"containerName":"overlaps","name":"$other","line":235},{"line":235,"name":"end","containerName":"overlaps","kind":12},{"name":"$self","kind":13,"containerName":"overlaps","line":236},{"name":"end","kind":12,"containerName":"overlaps","line":236},{"line":236,"name":"$other","containerName":"overlaps","kind":13},{"name":"start","kind":12,"containerName":"overlaps","line":236}],"detail":"($self,$other,$so)","definition":"sub","range":{"start":{"line":222,"character":0},"end":{"line":238,"character":9999}},"kind":12,"line":222,"signature":{"label":"overlaps($self,$other,$so)","parameters":[{"label":"$self"},{"label":"$other"},{"label":"$so"}],"documentation":"1;\n# $Id: RangeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::RangeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Matthew Pocock\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::RangeI - Range interface\n\n=head1 SYNOPSIS\n\n  #Do not run this module directly\n\n=head1 DESCRIPTION\n\nThis provides a standard BioPerl range interface that should be\nimplemented by any object that wants to be treated as a range. This\nserves purely as an abstract base class for implementers and can not\nbe instantiated.\n\nRanges are modeled as having (start, end, length, strand). They use\nBio-coordinates - all points E<gt>= start and E<lt>= end are within the\nrange. End is always greater-than or equal-to start, and length is\ngreater than or equal to 1. The behaviour of a range is undefined if\nranges with negative numbers or zero are used.\n\nSo, in summary:\n\n  length = end - start + 1\n  end >= start\n  strand = (-1 | 0 | +1)\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.bioperl.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nJuha Muilu (muilu@ebi.ac.uk)\nSendu Bala (bix@sendu.me.uk)\nMalcolm Cook (mec@stowers-institute.org)\nStephen Montgomery (sm8 at sanger.ac.uk)\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::RangeI;\n\nuse strict;\nuse Carp;\nuse integer;\nuse vars qw(%STRAND_OPTIONS);\n\nuse base qw(Bio::Root::RootI);\n\nBEGIN {\n# STRAND_OPTIONS contains the legal values for the strand-testing options\n    %STRAND_OPTIONS = map { $_, '_' . $_ }\n    (\n     'strong', # ranges must have the same strand\n     'weak',   # ranges must have the same strand or no strand\n     'ignore', # ignore strand information\n     );\n}\n\n# utility methods\n#\n\n# returns true if strands are equal and non-zero\nsub _strong {\n    my ($r1, $r2) = @_;\n    my ($s1, $s2) = ($r1->strand(), $r2->strand());\n\n    return 1 if $s1 != 0 && $s1 == $s2;\n}\n\n# returns true if strands are equal or either is zero\nsub _weak {\n    my ($r1, $r2) = @_;\n    my ($s1, $s2) = ($r1->strand(), $r2->strand());\n    return 1 if $s1 == 0 || $s2 == 0 || $s1 == $s2;\n}\n\n# returns true for any strandedness\nsub _ignore {\n    return 1;\n}\n\n# works out what test to use for the strictness and returns true/false\n# e.g. $r1->_testStrand($r2, 'strong')\nsub _testStrand() {\n    my ($r1, $r2, $comp) = @_;\n    return 1 unless $comp;\n    my $func = $STRAND_OPTIONS{$comp};\n    return $r1->$func($r2);\n}\n\n=head1 Abstract methods\n\nThese methods must be implemented in all subclasses.\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $range->start();\n  Function: get/set the start of this range\n  Returns : the start of this range\n  Args    : optionally allows the start to be set\n            using $range->start($start)\n\n\nsub start {\n    shift->throw_not_implemented();\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $range->end();\n  Function: get/set the end of this range\n  Returns : the end of this range\n  Args    : optionally allows the end to be set\n            using $range->end($end)\n\n\nsub end {\n    shift->throw_not_implemented();\n}\n\n=head2 length\n\n  Title   : length\n  Usage   : $length = $range->length();\n  Function: get/set the length of this range\n  Returns : the length of this range\n  Args    : optionally allows the length to be set\n             using $range->length($length)\n\n\nsub length {\n    shift->throw_not_implemented();\n}\n\n=head2 strand\n\n  Title   : strand\n  Usage   : $strand = $range->strand();\n  Function: get/set the strand of this range\n  Returns : the strandedness (-1, 0, +1)\n  Args    : optionally allows the strand to be set\n            using $range->strand($strand)\n\n\nsub strand {\n    shift->throw_not_implemented();\n}\n\n=head1 Boolean Methods\n\nThese methods return true or false. They throw an error if start and\nend are not defined.\n\n  $range->overlaps($otherRange) && print \"Ranges overlap\\n\";\n\n=head2 overlaps\n\n  Title   : overlaps\n  Usage   : if($r1->overlaps($r2)) { do stuff }\n  Function: tests if $r2 overlaps $r1\n  Args    : arg #1 = a range to compare this one to (mandatory)\n            arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n  Returns : true if the ranges overlap, false otherwise"}},{"detail":"($self,$other,$so)","definition":"sub","name":"contains","containerName":"main::","children":[{"line":253,"containerName":"contains","localvar":"my","kind":13,"name":"$self","definition":"my"},{"name":"$other","kind":13,"containerName":"contains","line":253},{"line":253,"name":"$so","kind":13,"containerName":"contains"},{"line":254,"name":"$self","containerName":"contains","kind":13},{"line":254,"containerName":"contains","kind":12,"name":"throw"},{"line":254,"name":"$self","containerName":"contains","kind":13},{"name":"start","kind":12,"containerName":"contains","line":254},{"line":255,"containerName":"contains","kind":13,"name":"$self"},{"containerName":"contains","kind":12,"name":"throw","line":255},{"line":255,"containerName":"contains","kind":13,"name":"$self"},{"line":255,"name":"end","containerName":"contains","kind":12},{"line":257,"name":"$other","kind":13,"containerName":"contains"},{"name":"$other","kind":13,"containerName":"contains","line":257},{"line":258,"containerName":"contains","kind":13,"name":"$other"},{"containerName":"contains","kind":12,"name":"throw","line":258},{"name":"$other","kind":13,"containerName":"contains","line":258},{"name":"isa","containerName":"contains","kind":12,"line":258},{"name":"$other","containerName":"contains","kind":13,"line":259},{"name":"throw","containerName":"contains","kind":12,"line":259},{"name":"$other","kind":13,"containerName":"contains","line":259},{"containerName":"contains","kind":12,"name":"start","line":259},{"name":"$other","kind":13,"containerName":"contains","line":260},{"name":"throw","containerName":"contains","kind":12,"line":260},{"line":260,"containerName":"contains","kind":13,"name":"$other"},{"line":260,"name":"end","containerName":"contains","kind":12},{"name":"$self","kind":13,"containerName":"contains","line":262},{"name":"_testStrand","kind":12,"containerName":"contains","line":262},{"line":262,"kind":13,"containerName":"contains","name":"$other"},{"name":"$so","containerName":"contains","kind":13,"line":262},{"containerName":"contains","kind":13,"name":"$other","line":263},{"line":263,"name":"start","containerName":"contains","kind":12},{"name":"$self","containerName":"contains","kind":13,"line":263},{"kind":12,"containerName":"contains","name":"start","line":263},{"name":"$other","kind":13,"containerName":"contains","line":264},{"kind":12,"containerName":"contains","name":"end","line":264},{"line":264,"containerName":"contains","kind":13,"name":"$self"},{"containerName":"contains","kind":12,"name":"end","line":264},{"line":266,"kind":13,"containerName":"contains","name":"$self"},{"kind":12,"containerName":"contains","name":"throw","line":266},{"line":266,"kind":13,"containerName":"contains","name":"$other"},{"kind":13,"containerName":"contains","name":"$other","line":267},{"name":"$self","kind":13,"containerName":"contains","line":267},{"line":267,"name":"start","kind":12,"containerName":"contains"},{"containerName":"contains","kind":13,"name":"$other","line":267},{"name":"$self","kind":13,"containerName":"contains","line":267},{"line":267,"kind":12,"containerName":"contains","name":"end"}],"signature":{"parameters":[{"label":"$self"},{"label":"$other"},{"label":"$so"}],"documentation":"1;\n# $Id: RangeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::RangeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Matthew Pocock\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::RangeI - Range interface\n\n=head1 SYNOPSIS\n\n  #Do not run this module directly\n\n=head1 DESCRIPTION\n\nThis provides a standard BioPerl range interface that should be\nimplemented by any object that wants to be treated as a range. This\nserves purely as an abstract base class for implementers and can not\nbe instantiated.\n\nRanges are modeled as having (start, end, length, strand). They use\nBio-coordinates - all points E<gt>= start and E<lt>= end are within the\nrange. End is always greater-than or equal-to start, and length is\ngreater than or equal to 1. The behaviour of a range is undefined if\nranges with negative numbers or zero are used.\n\nSo, in summary:\n\n  length = end - start + 1\n  end >= start\n  strand = (-1 | 0 | +1)\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.bioperl.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nJuha Muilu (muilu@ebi.ac.uk)\nSendu Bala (bix@sendu.me.uk)\nMalcolm Cook (mec@stowers-institute.org)\nStephen Montgomery (sm8 at sanger.ac.uk)\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::RangeI;\n\nuse strict;\nuse Carp;\nuse integer;\nuse vars qw(%STRAND_OPTIONS);\n\nuse base qw(Bio::Root::RootI);\n\nBEGIN {\n# STRAND_OPTIONS contains the legal values for the strand-testing options\n    %STRAND_OPTIONS = map { $_, '_' . $_ }\n    (\n     'strong', # ranges must have the same strand\n     'weak',   # ranges must have the same strand or no strand\n     'ignore', # ignore strand information\n     );\n}\n\n# utility methods\n#\n\n# returns true if strands are equal and non-zero\nsub _strong {\n    my ($r1, $r2) = @_;\n    my ($s1, $s2) = ($r1->strand(), $r2->strand());\n\n    return 1 if $s1 != 0 && $s1 == $s2;\n}\n\n# returns true if strands are equal or either is zero\nsub _weak {\n    my ($r1, $r2) = @_;\n    my ($s1, $s2) = ($r1->strand(), $r2->strand());\n    return 1 if $s1 == 0 || $s2 == 0 || $s1 == $s2;\n}\n\n# returns true for any strandedness\nsub _ignore {\n    return 1;\n}\n\n# works out what test to use for the strictness and returns true/false\n# e.g. $r1->_testStrand($r2, 'strong')\nsub _testStrand() {\n    my ($r1, $r2, $comp) = @_;\n    return 1 unless $comp;\n    my $func = $STRAND_OPTIONS{$comp};\n    return $r1->$func($r2);\n}\n\n=head1 Abstract methods\n\nThese methods must be implemented in all subclasses.\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $range->start();\n  Function: get/set the start of this range\n  Returns : the start of this range\n  Args    : optionally allows the start to be set\n            using $range->start($start)\n\n\nsub start {\n    shift->throw_not_implemented();\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $range->end();\n  Function: get/set the end of this range\n  Returns : the end of this range\n  Args    : optionally allows the end to be set\n            using $range->end($end)\n\n\nsub end {\n    shift->throw_not_implemented();\n}\n\n=head2 length\n\n  Title   : length\n  Usage   : $length = $range->length();\n  Function: get/set the length of this range\n  Returns : the length of this range\n  Args    : optionally allows the length to be set\n             using $range->length($length)\n\n\nsub length {\n    shift->throw_not_implemented();\n}\n\n=head2 strand\n\n  Title   : strand\n  Usage   : $strand = $range->strand();\n  Function: get/set the strand of this range\n  Returns : the strandedness (-1, 0, +1)\n  Args    : optionally allows the strand to be set\n            using $range->strand($strand)\n\n\nsub strand {\n    shift->throw_not_implemented();\n}\n\n=head1 Boolean Methods\n\nThese methods return true or false. They throw an error if start and\nend are not defined.\n\n  $range->overlaps($otherRange) && print \"Ranges overlap\\n\";\n\n=head2 overlaps\n\n  Title   : overlaps\n  Usage   : if($r1->overlaps($r2)) { do stuff }\n  Function: tests if $r2 overlaps $r1\n  Args    : arg #1 = a range to compare this one to (mandatory)\n            arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n  Returns : true if the ranges overlap, false otherwise\n\n\nsub overlaps {\n\tmy ($self, $other, $so) = @_;\n\n\t$self->throw(\"start is undefined\") unless defined $self->start;\n\t$self->throw(\"end is undefined\") unless defined $self->end;\n\t$self->throw(\"not a Bio::RangeI object\") unless defined $other &&\n\t  $other->isa('Bio::RangeI');\n\t$other->throw(\"start is undefined\") unless defined $other->start;\n\t$other->throw(\"end is undefined\") unless defined $other->end;\n\n\treturn\n\t  ($self->_testStrand($other, $so)\n\t\tand not (\n\t\t\t\t\t($self->start() > $other->end() or\n\t\t\t\t\t $self->end() < $other->start()   )\n\t\t\t\t  ));\n}\n\n=head2 contains\n\n  Title   : contains\n  Usage   : if($r1->contains($r2) { do stuff }\n  Function: tests whether $r1 totally contains $r2\n  Args    : arg #1 = a range to compare this one to (mandatory)\n\t             alternatively, integer scalar to test\n            arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n  Returns : true if the argument is totally contained within this range","label":"contains($self,$other,$so)"},"kind":12,"range":{"end":{"character":9999,"line":269},"start":{"line":252,"character":0}},"line":252},{"line":282,"kind":12,"range":{"start":{"line":282,"character":0},"end":{"line":294,"character":9999}},"signature":{"label":"equals($self,$other,$so)","documentation":"1;\n# $Id: RangeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::RangeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Matthew Pocock\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::RangeI - Range interface\n\n=head1 SYNOPSIS\n\n  #Do not run this module directly\n\n=head1 DESCRIPTION\n\nThis provides a standard BioPerl range interface that should be\nimplemented by any object that wants to be treated as a range. This\nserves purely as an abstract base class for implementers and can not\nbe instantiated.\n\nRanges are modeled as having (start, end, length, strand). They use\nBio-coordinates - all points E<gt>= start and E<lt>= end are within the\nrange. End is always greater-than or equal-to start, and length is\ngreater than or equal to 1. The behaviour of a range is undefined if\nranges with negative numbers or zero are used.\n\nSo, in summary:\n\n  length = end - start + 1\n  end >= start\n  strand = (-1 | 0 | +1)\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.bioperl.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nJuha Muilu (muilu@ebi.ac.uk)\nSendu Bala (bix@sendu.me.uk)\nMalcolm Cook (mec@stowers-institute.org)\nStephen Montgomery (sm8 at sanger.ac.uk)\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::RangeI;\n\nuse strict;\nuse Carp;\nuse integer;\nuse vars qw(%STRAND_OPTIONS);\n\nuse base qw(Bio::Root::RootI);\n\nBEGIN {\n# STRAND_OPTIONS contains the legal values for the strand-testing options\n    %STRAND_OPTIONS = map { $_, '_' . $_ }\n    (\n     'strong', # ranges must have the same strand\n     'weak',   # ranges must have the same strand or no strand\n     'ignore', # ignore strand information\n     );\n}\n\n# utility methods\n#\n\n# returns true if strands are equal and non-zero\nsub _strong {\n    my ($r1, $r2) = @_;\n    my ($s1, $s2) = ($r1->strand(), $r2->strand());\n\n    return 1 if $s1 != 0 && $s1 == $s2;\n}\n\n# returns true if strands are equal or either is zero\nsub _weak {\n    my ($r1, $r2) = @_;\n    my ($s1, $s2) = ($r1->strand(), $r2->strand());\n    return 1 if $s1 == 0 || $s2 == 0 || $s1 == $s2;\n}\n\n# returns true for any strandedness\nsub _ignore {\n    return 1;\n}\n\n# works out what test to use for the strictness and returns true/false\n# e.g. $r1->_testStrand($r2, 'strong')\nsub _testStrand() {\n    my ($r1, $r2, $comp) = @_;\n    return 1 unless $comp;\n    my $func = $STRAND_OPTIONS{$comp};\n    return $r1->$func($r2);\n}\n\n=head1 Abstract methods\n\nThese methods must be implemented in all subclasses.\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $range->start();\n  Function: get/set the start of this range\n  Returns : the start of this range\n  Args    : optionally allows the start to be set\n            using $range->start($start)\n\n\nsub start {\n    shift->throw_not_implemented();\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $range->end();\n  Function: get/set the end of this range\n  Returns : the end of this range\n  Args    : optionally allows the end to be set\n            using $range->end($end)\n\n\nsub end {\n    shift->throw_not_implemented();\n}\n\n=head2 length\n\n  Title   : length\n  Usage   : $length = $range->length();\n  Function: get/set the length of this range\n  Returns : the length of this range\n  Args    : optionally allows the length to be set\n             using $range->length($length)\n\n\nsub length {\n    shift->throw_not_implemented();\n}\n\n=head2 strand\n\n  Title   : strand\n  Usage   : $strand = $range->strand();\n  Function: get/set the strand of this range\n  Returns : the strandedness (-1, 0, +1)\n  Args    : optionally allows the strand to be set\n            using $range->strand($strand)\n\n\nsub strand {\n    shift->throw_not_implemented();\n}\n\n=head1 Boolean Methods\n\nThese methods return true or false. They throw an error if start and\nend are not defined.\n\n  $range->overlaps($otherRange) && print \"Ranges overlap\\n\";\n\n=head2 overlaps\n\n  Title   : overlaps\n  Usage   : if($r1->overlaps($r2)) { do stuff }\n  Function: tests if $r2 overlaps $r1\n  Args    : arg #1 = a range to compare this one to (mandatory)\n            arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n  Returns : true if the ranges overlap, false otherwise\n\n\nsub overlaps {\n\tmy ($self, $other, $so) = @_;\n\n\t$self->throw(\"start is undefined\") unless defined $self->start;\n\t$self->throw(\"end is undefined\") unless defined $self->end;\n\t$self->throw(\"not a Bio::RangeI object\") unless defined $other &&\n\t  $other->isa('Bio::RangeI');\n\t$other->throw(\"start is undefined\") unless defined $other->start;\n\t$other->throw(\"end is undefined\") unless defined $other->end;\n\n\treturn\n\t  ($self->_testStrand($other, $so)\n\t\tand not (\n\t\t\t\t\t($self->start() > $other->end() or\n\t\t\t\t\t $self->end() < $other->start()   )\n\t\t\t\t  ));\n}\n\n=head2 contains\n\n  Title   : contains\n  Usage   : if($r1->contains($r2) { do stuff }\n  Function: tests whether $r1 totally contains $r2\n  Args    : arg #1 = a range to compare this one to (mandatory)\n\t             alternatively, integer scalar to test\n            arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n  Returns : true if the argument is totally contained within this range\n\n\nsub contains {\n\tmy ($self, $other, $so) = @_;\n\t$self->throw(\"start is undefined\") unless defined $self->start;\n\t$self->throw(\"end is undefined\") unless defined $self->end;\n\n\tif(defined $other && ref $other) { # a range object?\n      $other->throw(\"Not a Bio::RangeI object: $other\") unless  $other->isa('Bio::RangeI');\n      $other->throw(\"start is undefined\") unless defined $other->start;\n      $other->throw(\"end is undefined\") unless defined $other->end;\n\n      return ($self->_testStrand($other, $so)      and\n\t\t\t\t  $other->start() >= $self->start() and\n\t\t\t\t  $other->end() <= $self->end());\n  } else { # a scalar?\n\t  $self->throw(\"'$other' is not an integer.\\n\") unless $other =~ /^[-+]?\\d+$/;\n\t  return ($other >= $self->start() and $other <= $self->end());\n  }\n}\n\n=head2 equals\n\n  Title   : equals\n  Usage   : if($r1->equals($r2))\n  Function: test whether $r1 has the same start, end, length as $r2\n  Args    : arg #1 = a range to compare this one to (mandatory)\n            arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n  Returns : true if they are describing the same range","parameters":[{"label":"$self"},{"label":"$other"},{"label":"$so"}]},"children":[{"line":283,"name":"$self","localvar":"my","containerName":"equals","kind":13,"definition":"my"},{"name":"$other","kind":13,"containerName":"equals","line":283},{"containerName":"equals","kind":13,"name":"$so","line":283},{"kind":13,"containerName":"equals","name":"$self","line":285},{"line":285,"name":"throw","kind":12,"containerName":"equals"},{"name":"$self","kind":13,"containerName":"equals","line":285},{"name":"start","containerName":"equals","kind":12,"line":285},{"line":286,"name":"$self","containerName":"equals","kind":13},{"line":286,"kind":12,"containerName":"equals","name":"throw"},{"line":286,"kind":13,"containerName":"equals","name":"$self"},{"line":286,"containerName":"equals","kind":12,"name":"end"},{"line":287,"kind":13,"containerName":"equals","name":"$other"},{"line":287,"name":"throw","containerName":"equals","kind":12},{"line":287,"name":"$other","containerName":"equals","kind":13},{"line":287,"name":"isa","containerName":"equals","kind":12},{"line":288,"containerName":"equals","kind":13,"name":"$other"},{"line":288,"name":"throw","containerName":"equals","kind":12},{"kind":13,"containerName":"equals","name":"$other","line":288},{"line":288,"containerName":"equals","kind":12,"name":"start"},{"line":289,"containerName":"equals","kind":13,"name":"$other"},{"containerName":"equals","kind":12,"name":"throw","line":289},{"line":289,"name":"$other","containerName":"equals","kind":13},{"kind":12,"containerName":"equals","name":"end","line":289},{"name":"$self","kind":13,"containerName":"equals","line":291},{"line":291,"containerName":"equals","kind":12,"name":"_testStrand"},{"line":291,"name":"$other","containerName":"equals","kind":13},{"kind":13,"containerName":"equals","name":"$so","line":291},{"line":292,"name":"$self","containerName":"equals","kind":13},{"line":292,"containerName":"equals","kind":12,"name":"start"},{"line":292,"name":"$other","containerName":"equals","kind":13},{"kind":12,"containerName":"equals","name":"start","line":292},{"line":293,"name":"$self","containerName":"equals","kind":13},{"kind":12,"containerName":"equals","name":"end","line":293},{"name":"$other","kind":13,"containerName":"equals","line":293},{"line":293,"kind":12,"containerName":"equals","name":"end"}],"name":"equals","containerName":"main::","definition":"sub","detail":"($self,$other,$so)"},{"definition":"sub","detail":"($self,$given,$so)","children":[{"definition":"my","line":320,"name":"$self","localvar":"my","kind":13,"containerName":"intersection"},{"line":320,"kind":13,"containerName":"intersection","name":"$given"},{"line":320,"name":"$so","kind":13,"containerName":"intersection"},{"line":321,"kind":13,"containerName":"intersection","name":"$self"},{"line":321,"name":"throw","kind":12,"containerName":"intersection"},{"line":321,"containerName":"intersection","kind":13,"name":"$given"},{"name":"@ranges","containerName":"intersection","localvar":"my","kind":13,"line":323,"definition":"my"},{"line":324,"name":"$self","containerName":"intersection","kind":13},{"line":325,"containerName":"intersection","kind":13,"name":"$self"},{"line":326,"name":"$self","containerName":"intersection","kind":13},{"name":"warn","kind":12,"containerName":"intersection","line":326},{"line":328,"name":"$self","kind":13,"containerName":"intersection"},{"kind":13,"containerName":"intersection","name":"@ranges","line":329},{"line":329,"kind":13,"containerName":"intersection","name":"$self"},{"kind":13,"containerName":"intersection","name":"$given","line":331},{"name":"@ranges","containerName":"intersection","kind":13,"line":331},{"kind":13,"containerName":"intersection","name":"$given","line":331}],"name":"intersection","containerName":"main::","signature":{"label":"intersection($self,$given,$so)","documentation":"1;\n# $Id: RangeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::RangeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Matthew Pocock\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::RangeI - Range interface\n\n=head1 SYNOPSIS\n\n  #Do not run this module directly\n\n=head1 DESCRIPTION\n\nThis provides a standard BioPerl range interface that should be\nimplemented by any object that wants to be treated as a range. This\nserves purely as an abstract base class for implementers and can not\nbe instantiated.\n\nRanges are modeled as having (start, end, length, strand). They use\nBio-coordinates - all points E<gt>= start and E<lt>= end are within the\nrange. End is always greater-than or equal-to start, and length is\ngreater than or equal to 1. The behaviour of a range is undefined if\nranges with negative numbers or zero are used.\n\nSo, in summary:\n\n  length = end - start + 1\n  end >= start\n  strand = (-1 | 0 | +1)\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.bioperl.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nJuha Muilu (muilu@ebi.ac.uk)\nSendu Bala (bix@sendu.me.uk)\nMalcolm Cook (mec@stowers-institute.org)\nStephen Montgomery (sm8 at sanger.ac.uk)\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::RangeI;\n\nuse strict;\nuse Carp;\nuse integer;\nuse vars qw(%STRAND_OPTIONS);\n\nuse base qw(Bio::Root::RootI);\n\nBEGIN {\n# STRAND_OPTIONS contains the legal values for the strand-testing options\n    %STRAND_OPTIONS = map { $_, '_' . $_ }\n    (\n     'strong', # ranges must have the same strand\n     'weak',   # ranges must have the same strand or no strand\n     'ignore', # ignore strand information\n     );\n}\n\n# utility methods\n#\n\n# returns true if strands are equal and non-zero\nsub _strong {\n    my ($r1, $r2) = @_;\n    my ($s1, $s2) = ($r1->strand(), $r2->strand());\n\n    return 1 if $s1 != 0 && $s1 == $s2;\n}\n\n# returns true if strands are equal or either is zero\nsub _weak {\n    my ($r1, $r2) = @_;\n    my ($s1, $s2) = ($r1->strand(), $r2->strand());\n    return 1 if $s1 == 0 || $s2 == 0 || $s1 == $s2;\n}\n\n# returns true for any strandedness\nsub _ignore {\n    return 1;\n}\n\n# works out what test to use for the strictness and returns true/false\n# e.g. $r1->_testStrand($r2, 'strong')\nsub _testStrand() {\n    my ($r1, $r2, $comp) = @_;\n    return 1 unless $comp;\n    my $func = $STRAND_OPTIONS{$comp};\n    return $r1->$func($r2);\n}\n\n=head1 Abstract methods\n\nThese methods must be implemented in all subclasses.\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $range->start();\n  Function: get/set the start of this range\n  Returns : the start of this range\n  Args    : optionally allows the start to be set\n            using $range->start($start)\n\n\nsub start {\n    shift->throw_not_implemented();\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $range->end();\n  Function: get/set the end of this range\n  Returns : the end of this range\n  Args    : optionally allows the end to be set\n            using $range->end($end)\n\n\nsub end {\n    shift->throw_not_implemented();\n}\n\n=head2 length\n\n  Title   : length\n  Usage   : $length = $range->length();\n  Function: get/set the length of this range\n  Returns : the length of this range\n  Args    : optionally allows the length to be set\n             using $range->length($length)\n\n\nsub length {\n    shift->throw_not_implemented();\n}\n\n=head2 strand\n\n  Title   : strand\n  Usage   : $strand = $range->strand();\n  Function: get/set the strand of this range\n  Returns : the strandedness (-1, 0, +1)\n  Args    : optionally allows the strand to be set\n            using $range->strand($strand)\n\n\nsub strand {\n    shift->throw_not_implemented();\n}\n\n=head1 Boolean Methods\n\nThese methods return true or false. They throw an error if start and\nend are not defined.\n\n  $range->overlaps($otherRange) && print \"Ranges overlap\\n\";\n\n=head2 overlaps\n\n  Title   : overlaps\n  Usage   : if($r1->overlaps($r2)) { do stuff }\n  Function: tests if $r2 overlaps $r1\n  Args    : arg #1 = a range to compare this one to (mandatory)\n            arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n  Returns : true if the ranges overlap, false otherwise\n\n\nsub overlaps {\n\tmy ($self, $other, $so) = @_;\n\n\t$self->throw(\"start is undefined\") unless defined $self->start;\n\t$self->throw(\"end is undefined\") unless defined $self->end;\n\t$self->throw(\"not a Bio::RangeI object\") unless defined $other &&\n\t  $other->isa('Bio::RangeI');\n\t$other->throw(\"start is undefined\") unless defined $other->start;\n\t$other->throw(\"end is undefined\") unless defined $other->end;\n\n\treturn\n\t  ($self->_testStrand($other, $so)\n\t\tand not (\n\t\t\t\t\t($self->start() > $other->end() or\n\t\t\t\t\t $self->end() < $other->start()   )\n\t\t\t\t  ));\n}\n\n=head2 contains\n\n  Title   : contains\n  Usage   : if($r1->contains($r2) { do stuff }\n  Function: tests whether $r1 totally contains $r2\n  Args    : arg #1 = a range to compare this one to (mandatory)\n\t             alternatively, integer scalar to test\n            arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n  Returns : true if the argument is totally contained within this range\n\n\nsub contains {\n\tmy ($self, $other, $so) = @_;\n\t$self->throw(\"start is undefined\") unless defined $self->start;\n\t$self->throw(\"end is undefined\") unless defined $self->end;\n\n\tif(defined $other && ref $other) { # a range object?\n      $other->throw(\"Not a Bio::RangeI object: $other\") unless  $other->isa('Bio::RangeI');\n      $other->throw(\"start is undefined\") unless defined $other->start;\n      $other->throw(\"end is undefined\") unless defined $other->end;\n\n      return ($self->_testStrand($other, $so)      and\n\t\t\t\t  $other->start() >= $self->start() and\n\t\t\t\t  $other->end() <= $self->end());\n  } else { # a scalar?\n\t  $self->throw(\"'$other' is not an integer.\\n\") unless $other =~ /^[-+]?\\d+$/;\n\t  return ($other >= $self->start() and $other <= $self->end());\n  }\n}\n\n=head2 equals\n\n  Title   : equals\n  Usage   : if($r1->equals($r2))\n  Function: test whether $r1 has the same start, end, length as $r2\n  Args    : arg #1 = a range to compare this one to (mandatory)\n            arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n  Returns : true if they are describing the same range\n\n\nsub equals {\n    my ($self, $other, $so) = @_;\n\n    $self->throw(\"start is undefined\") unless defined $self->start;\n    $self->throw(\"end is undefined\") unless defined $self->end;\n    $other->throw(\"Not a Bio::RangeI object\") unless  $other->isa('Bio::RangeI');\n    $other->throw(\"start is undefined\") unless defined $other->start;\n    $other->throw(\"end is undefined\") unless defined $other->end;\n\n    return ($self->_testStrand($other, $so)   and\n\t    $self->start() == $other->start() and\n\t    $self->end()   == $other->end()       );\n}\n\n=head1 Geometrical methods\n\nThese methods do things to the geometry of ranges, and return\nBio::RangeI compliant objects or triplets (start, stop, strand) from\nwhich new ranges could be built.\n\n=head2 intersection\n\n Title   : intersection\n Usage   : ($start, $stop, $strand) = $r1->intersection($r2); OR\n           ($start, $stop, $strand) = Bio::Range->intersection(\\@ranges); OR\n           my $containing_range = $r1->intersection($r2); OR\n           my $containing_range = Bio::Range->intersection(\\@ranges);\n Function: gives the range that is contained by all ranges\n Returns : undef if they do not overlap, or\n           the range that they do overlap (in the form of an object\n            like the calling one, OR a three element array)\n Args    : arg #1 = [REQUIRED] a range to compare this one to,\n                    or an array ref of ranges\n           arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')","parameters":[{"label":"$self"},{"label":"$given"},{"label":"$so"}]},"line":319,"range":{"start":{"character":0,"line":319},"end":{"line":331,"character":9999}},"kind":12},{"name":"@ranges","containerName":null,"kind":13,"line":331},{"name":"$given","kind":13,"containerName":null,"line":331},{"line":332,"containerName":null,"kind":13,"name":"$self"},{"kind":12,"containerName":"main::","name":"throw","line":332},{"kind":13,"containerName":null,"name":"@ranges","line":332},{"kind":13,"localvar":"my","containerName":null,"name":"$intersect","line":334,"definition":"my"},{"name":"@ranges","kind":13,"containerName":null,"line":335},{"kind":13,"containerName":null,"name":"%intersect","line":336},{"line":337,"kind":13,"containerName":null,"name":"$intersect"},{"line":337,"containerName":null,"kind":13,"name":"@ranges"},{"name":"$self","containerName":null,"kind":13,"line":338},{"name":"throw","kind":12,"containerName":"main::","line":338},{"line":338,"kind":13,"containerName":null,"name":"$intersect"},{"line":339,"name":"$self","containerName":null,"kind":13},{"kind":12,"containerName":"main::","name":"throw","line":339},{"name":"$intersect","kind":13,"containerName":null,"line":339},{"line":339,"name":"isa","containerName":"main::","kind":12},{"kind":13,"containerName":null,"name":"$self","line":340},{"line":340,"containerName":"main::","kind":12,"name":"throw"},{"line":340,"kind":13,"containerName":null,"name":"$intersect"},{"containerName":"main::","kind":12,"name":"start","line":340},{"line":341,"name":"$self","kind":13,"containerName":null},{"line":341,"containerName":"main::","kind":12,"name":"throw"},{"line":341,"kind":13,"containerName":null,"name":"$intersect"},{"line":341,"kind":12,"containerName":"main::","name":"end"},{"definition":"my","line":344,"localvar":"my","kind":13,"containerName":null,"name":"$compare"},{"line":344,"kind":13,"containerName":null,"name":"@ranges"},{"line":345,"name":"$self","kind":13,"containerName":null},{"line":345,"name":"throw","kind":12,"containerName":"main::"},{"line":345,"kind":13,"containerName":null,"name":"$compare"},{"line":346,"name":"$self","containerName":null,"kind":13},{"line":346,"name":"throw","kind":12,"containerName":"main::"},{"name":"$compare","containerName":null,"kind":13,"line":346},{"line":346,"name":"isa","kind":12,"containerName":"main::"},{"line":347,"containerName":null,"kind":13,"name":"$self"},{"line":347,"name":"throw","containerName":"main::","kind":12},{"name":"$compare","containerName":null,"kind":13,"line":347},{"line":347,"name":"start","containerName":"main::","kind":12},{"containerName":null,"kind":13,"name":"$self","line":348},{"line":348,"name":"throw","kind":12,"containerName":"main::"},{"kind":13,"containerName":null,"name":"$compare","line":348},{"name":"end","containerName":"main::","kind":12,"line":348},{"kind":13,"containerName":null,"name":"$compare","line":349},{"line":349,"containerName":"main::","kind":12,"name":"_testStrand"},{"name":"$intersect","containerName":null,"kind":13,"line":349},{"kind":13,"containerName":null,"name":"$so","line":349},{"name":"@starts","kind":13,"localvar":"my","containerName":null,"line":351,"definition":"my"},{"line":351,"kind":13,"containerName":null,"name":"$a"},{"line":351,"name":"$b","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"$intersect","line":351},{"line":351,"name":"start","kind":12,"containerName":"main::"},{"line":351,"containerName":null,"kind":13,"name":"$compare"},{"line":351,"name":"start","containerName":"main::","kind":12},{"definition":"my","name":"@ends","containerName":null,"localvar":"my","kind":13,"line":352},{"name":"$a","kind":13,"containerName":null,"line":352},{"name":"$b","kind":13,"containerName":null,"line":352},{"kind":13,"containerName":null,"name":"$intersect","line":352},{"kind":12,"containerName":"main::","name":"end","line":352},{"line":352,"containerName":null,"kind":13,"name":"$compare"},{"name":"end","kind":12,"containerName":"main::","line":352},{"line":354,"name":"$start","containerName":null,"localvar":"my","kind":13,"definition":"my"},{"name":"@starts","containerName":null,"kind":13,"line":354},{"definition":"my","name":"$end","kind":13,"localvar":"my","containerName":null,"line":355},{"kind":13,"containerName":null,"name":"@ends","line":355},{"name":"$intersect_strand","kind":13,"localvar":"my","containerName":null,"line":357,"definition":"my"},{"line":358,"kind":13,"containerName":null,"name":"$intersect"},{"name":"strand","kind":12,"containerName":"main::","line":358},{"line":358,"containerName":null,"kind":13,"name":"$compare"},{"containerName":"main::","kind":12,"name":"strand","line":358},{"line":358,"kind":13,"containerName":null,"name":"$intersect"},{"line":358,"kind":12,"containerName":"main::","name":"strand"},{"line":358,"containerName":null,"kind":13,"name":"$compare"},{"line":358,"kind":12,"containerName":"main::","name":"strand"},{"kind":13,"containerName":null,"name":"$intersect_strand","line":359},{"name":"$compare","containerName":null,"kind":13,"line":359},{"line":359,"name":"strand","kind":12,"containerName":"main::"},{"name":"$intersect_strand","containerName":null,"kind":13,"line":362},{"line":365,"kind":13,"containerName":null,"name":"$start"},{"name":"%end","containerName":null,"kind":13,"line":365},{"line":369,"kind":13,"containerName":null,"name":"$intersect"},{"containerName":null,"kind":13,"name":"$self","line":369},{"line":369,"name":"new","kind":12,"containerName":"main::"},{"line":369,"name":"$start","kind":13,"containerName":null},{"line":370,"kind":13,"containerName":null,"name":"$end"},{"line":371,"name":"%intersect_strand","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"$intersect","line":376},{"line":376,"kind":12,"containerName":"main::","name":"start"},{"line":376,"name":"$intersect","kind":13,"containerName":null},{"line":376,"kind":12,"containerName":"main::","name":"end"},{"line":376,"name":"$intersect","containerName":null,"kind":13},{"line":376,"name":"strand","kind":12,"containerName":"main::"},{"containerName":null,"kind":13,"name":"$intersect","line":379},{"name":"union","containerName":"main::","children":[{"definition":"my","line":398,"name":"$self","localvar":"my","containerName":"union","kind":13},{"definition":"my","localvar":"my","containerName":"union","kind":13,"name":"@ranges","line":399},{"line":400,"name":"$self","kind":13,"containerName":"union"},{"name":"$self","kind":13,"containerName":"union","line":401},{"line":402,"name":"$self","containerName":"union","kind":13},{"kind":12,"containerName":"union","name":"warn","line":402},{"containerName":"union","kind":13,"name":"$self","line":404},{"line":405,"name":"@ranges","containerName":"union","kind":13},{"line":405,"name":"$self","kind":13,"containerName":"union"},{"line":408,"kind":13,"localvar":"my","containerName":"union","name":"@start","definition":"my"},{"line":408,"name":"$a","kind":13,"containerName":"union"},{"name":"$b","containerName":"union","kind":13,"line":408},{"name":"start","containerName":"union","kind":12,"line":409},{"kind":13,"containerName":"union","name":"@ranges","line":409},{"name":"@end","localvar":"my","containerName":"union","kind":13,"line":410,"definition":"my"},{"name":"$a","containerName":"union","kind":13,"line":410},{"line":410,"kind":13,"containerName":"union","name":"$b"},{"line":411,"kind":12,"containerName":"union","name":"end"},{"name":"@ranges","kind":13,"containerName":"union","line":411},{"definition":"my","kind":13,"localvar":"my","containerName":"union","name":"$start","line":413},{"line":413,"name":"@start","containerName":"union","kind":13},{"line":414,"name":"$start","kind":13,"containerName":"union"},{"name":"$start","containerName":"union","kind":13,"line":415},{"kind":13,"containerName":"union","name":"@start","line":415},{"definition":"my","line":418,"name":"$end","containerName":"union","localvar":"my","kind":13},{"kind":13,"containerName":"union","name":"@end","line":418},{"line":420,"kind":13,"localvar":"my","containerName":"union","name":"$union_strand","definition":"my"},{"line":422,"name":"@ranges","kind":13,"containerName":"union"},{"kind":13,"containerName":"union","name":"$union_strand","line":423},{"line":424,"kind":13,"containerName":"union","name":"$union_strand"},{"line":424,"name":"strand","containerName":"union","kind":12},{"containerName":"union","kind":12,"name":"strand","line":427},{"name":"$union_strand","kind":13,"containerName":"union","line":427},{"name":"strand","kind":12,"containerName":"union","line":427},{"containerName":"union","kind":13,"name":"$union_strand","line":428},{"line":433,"kind":13,"containerName":"union","name":"$start"},{"line":433,"name":"$end","kind":13,"containerName":"union"},{"containerName":"union","kind":13,"name":"$start","line":435},{"name":"$end","kind":13,"containerName":"union","line":435},{"line":435,"containerName":"union","kind":13,"name":"$union_strand"},{"line":437,"kind":13,"containerName":"union","name":"$self"},{"name":"new","containerName":"union","kind":12,"line":437},{"name":"$start","kind":13,"containerName":"union","line":437},{"name":"$end","containerName":"union","kind":13,"line":438},{"line":440,"kind":13,"containerName":"union","name":"$union_strand"}],"definition":"sub","range":{"end":{"character":9999,"line":442},"start":{"character":0,"line":397}},"kind":12,"line":397},{"containerName":"main::","name":"overlap_extent","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"overlap_extent","name":"$a","line":459},{"line":459,"containerName":"overlap_extent","kind":13,"name":"$b"},{"containerName":"overlap_extent","kind":13,"name":"$a","line":461},{"line":461,"name":"throw","containerName":"overlap_extent","kind":12},{"name":"$a","containerName":"overlap_extent","kind":13,"line":461},{"line":461,"containerName":"overlap_extent","kind":12,"name":"start"},{"line":462,"name":"$a","kind":13,"containerName":"overlap_extent"},{"line":462,"kind":12,"containerName":"overlap_extent","name":"throw"},{"containerName":"overlap_extent","kind":13,"name":"$a","line":462},{"line":462,"name":"end","kind":12,"containerName":"overlap_extent"},{"line":463,"name":"$b","containerName":"overlap_extent","kind":13},{"containerName":"overlap_extent","kind":12,"name":"throw","line":463},{"name":"$b","kind":13,"containerName":"overlap_extent","line":463},{"line":463,"kind":12,"containerName":"overlap_extent","name":"isa"},{"name":"$b","kind":13,"containerName":"overlap_extent","line":464},{"name":"throw","kind":12,"containerName":"overlap_extent","line":464},{"line":464,"name":"$b","containerName":"overlap_extent","kind":13},{"line":464,"name":"start","containerName":"overlap_extent","kind":12},{"line":465,"name":"$b","kind":13,"containerName":"overlap_extent"},{"line":465,"containerName":"overlap_extent","kind":12,"name":"throw"},{"line":465,"name":"$b","containerName":"overlap_extent","kind":13},{"name":"end","kind":12,"containerName":"overlap_extent","line":465},{"line":467,"name":"$a","containerName":"overlap_extent","kind":13},{"line":467,"kind":12,"containerName":"overlap_extent","name":"overlaps"},{"name":"$b","kind":13,"containerName":"overlap_extent","line":467},{"name":"$a","kind":13,"containerName":"overlap_extent","line":468},{"containerName":"overlap_extent","kind":12,"name":"length","line":468},{"kind":13,"containerName":"overlap_extent","name":"$b","line":468},{"name":"length","containerName":"overlap_extent","kind":12,"line":468},{"definition":"my","line":471,"name":"$au","localvar":"my","kind":13,"containerName":"overlap_extent"},{"kind":13,"containerName":"overlap_extent","name":"$bu","line":471},{"name":"$a","containerName":"overlap_extent","kind":13,"line":472},{"kind":12,"containerName":"overlap_extent","name":"start","line":472},{"line":472,"name":"$b","containerName":"overlap_extent","kind":13},{"line":472,"containerName":"overlap_extent","kind":12,"name":"start"},{"line":473,"name":"$au","kind":13,"containerName":"overlap_extent"},{"line":473,"containerName":"overlap_extent","kind":13,"name":"$b"},{"kind":12,"containerName":"overlap_extent","name":"start","line":473},{"name":"$a","kind":13,"containerName":"overlap_extent","line":473},{"line":473,"containerName":"overlap_extent","kind":12,"name":"start"},{"containerName":"overlap_extent","kind":13,"name":"$bu","line":475},{"containerName":"overlap_extent","kind":13,"name":"$a","line":475},{"kind":12,"containerName":"overlap_extent","name":"start","line":475},{"kind":13,"containerName":"overlap_extent","name":"$b","line":475},{"name":"start","containerName":"overlap_extent","kind":12,"line":475},{"line":478,"name":"$a","containerName":"overlap_extent","kind":13},{"name":"end","containerName":"overlap_extent","kind":12,"line":478},{"name":"$b","containerName":"overlap_extent","kind":13,"line":478},{"containerName":"overlap_extent","kind":12,"name":"end","line":478},{"containerName":"overlap_extent","kind":13,"name":"$au","line":479},{"line":479,"name":"$a","kind":13,"containerName":"overlap_extent"},{"name":"end","containerName":"overlap_extent","kind":12,"line":479},{"line":479,"name":"$b","containerName":"overlap_extent","kind":13},{"line":479,"kind":12,"containerName":"overlap_extent","name":"end"},{"name":"$bu","kind":13,"containerName":"overlap_extent","line":481},{"line":481,"containerName":"overlap_extent","kind":13,"name":"$b"},{"line":481,"name":"end","containerName":"overlap_extent","kind":12},{"line":481,"name":"$a","kind":13,"containerName":"overlap_extent"},{"name":"end","kind":12,"containerName":"overlap_extent","line":481},{"line":484,"localvar":"my","kind":13,"containerName":"overlap_extent","name":"$intersect","definition":"my"},{"name":"$a","containerName":"overlap_extent","kind":13,"line":484},{"kind":12,"containerName":"overlap_extent","name":"intersection","line":484},{"line":484,"kind":13,"containerName":"overlap_extent","name":"$b"},{"containerName":"overlap_extent","kind":13,"name":"$intersect","line":485},{"line":487,"containerName":"overlap_extent","kind":13,"name":"$au"},{"line":487,"name":"$bu","containerName":"overlap_extent","kind":13},{"name":"$ie","localvar":"my","containerName":"overlap_extent","kind":13,"line":489,"definition":"my"},{"line":489,"kind":13,"containerName":"overlap_extent","name":"$intersect"},{"line":489,"name":"end","kind":12,"containerName":"overlap_extent"},{"definition":"my","containerName":"overlap_extent","localvar":"my","kind":13,"name":"$is","line":490},{"containerName":"overlap_extent","kind":13,"name":"$intersect","line":490},{"containerName":"overlap_extent","kind":12,"name":"start","line":490},{"kind":13,"containerName":"overlap_extent","name":"$au","line":491},{"line":491,"kind":13,"containerName":"overlap_extent","name":"$ie"},{"name":"$is","kind":13,"containerName":"overlap_extent","line":491},{"line":491,"name":"$bu","kind":13,"containerName":"overlap_extent"}],"detail":"($a,$b)","definition":"sub","kind":12,"range":{"end":{"character":9999,"line":493},"start":{"line":458,"character":0}},"line":458,"signature":{"parameters":[{"label":"$a"},{"label":"$b"}],"documentation":"1;\n# $Id: RangeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::RangeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Matthew Pocock\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::RangeI - Range interface\n\n=head1 SYNOPSIS\n\n  #Do not run this module directly\n\n=head1 DESCRIPTION\n\nThis provides a standard BioPerl range interface that should be\nimplemented by any object that wants to be treated as a range. This\nserves purely as an abstract base class for implementers and can not\nbe instantiated.\n\nRanges are modeled as having (start, end, length, strand). They use\nBio-coordinates - all points E<gt>= start and E<lt>= end are within the\nrange. End is always greater-than or equal-to start, and length is\ngreater than or equal to 1. The behaviour of a range is undefined if\nranges with negative numbers or zero are used.\n\nSo, in summary:\n\n  length = end - start + 1\n  end >= start\n  strand = (-1 | 0 | +1)\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.bioperl.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nJuha Muilu (muilu@ebi.ac.uk)\nSendu Bala (bix@sendu.me.uk)\nMalcolm Cook (mec@stowers-institute.org)\nStephen Montgomery (sm8 at sanger.ac.uk)\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::RangeI;\n\nuse strict;\nuse Carp;\nuse integer;\nuse vars qw(%STRAND_OPTIONS);\n\nuse base qw(Bio::Root::RootI);\n\nBEGIN {\n# STRAND_OPTIONS contains the legal values for the strand-testing options\n    %STRAND_OPTIONS = map { $_, '_' . $_ }\n    (\n     'strong', # ranges must have the same strand\n     'weak',   # ranges must have the same strand or no strand\n     'ignore', # ignore strand information\n     );\n}\n\n# utility methods\n#\n\n# returns true if strands are equal and non-zero\nsub _strong {\n    my ($r1, $r2) = @_;\n    my ($s1, $s2) = ($r1->strand(), $r2->strand());\n\n    return 1 if $s1 != 0 && $s1 == $s2;\n}\n\n# returns true if strands are equal or either is zero\nsub _weak {\n    my ($r1, $r2) = @_;\n    my ($s1, $s2) = ($r1->strand(), $r2->strand());\n    return 1 if $s1 == 0 || $s2 == 0 || $s1 == $s2;\n}\n\n# returns true for any strandedness\nsub _ignore {\n    return 1;\n}\n\n# works out what test to use for the strictness and returns true/false\n# e.g. $r1->_testStrand($r2, 'strong')\nsub _testStrand() {\n    my ($r1, $r2, $comp) = @_;\n    return 1 unless $comp;\n    my $func = $STRAND_OPTIONS{$comp};\n    return $r1->$func($r2);\n}\n\n=head1 Abstract methods\n\nThese methods must be implemented in all subclasses.\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $range->start();\n  Function: get/set the start of this range\n  Returns : the start of this range\n  Args    : optionally allows the start to be set\n            using $range->start($start)\n\n\nsub start {\n    shift->throw_not_implemented();\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $range->end();\n  Function: get/set the end of this range\n  Returns : the end of this range\n  Args    : optionally allows the end to be set\n            using $range->end($end)\n\n\nsub end {\n    shift->throw_not_implemented();\n}\n\n=head2 length\n\n  Title   : length\n  Usage   : $length = $range->length();\n  Function: get/set the length of this range\n  Returns : the length of this range\n  Args    : optionally allows the length to be set\n             using $range->length($length)\n\n\nsub length {\n    shift->throw_not_implemented();\n}\n\n=head2 strand\n\n  Title   : strand\n  Usage   : $strand = $range->strand();\n  Function: get/set the strand of this range\n  Returns : the strandedness (-1, 0, +1)\n  Args    : optionally allows the strand to be set\n            using $range->strand($strand)\n\n\nsub strand {\n    shift->throw_not_implemented();\n}\n\n=head1 Boolean Methods\n\nThese methods return true or false. They throw an error if start and\nend are not defined.\n\n  $range->overlaps($otherRange) && print \"Ranges overlap\\n\";\n\n=head2 overlaps\n\n  Title   : overlaps\n  Usage   : if($r1->overlaps($r2)) { do stuff }\n  Function: tests if $r2 overlaps $r1\n  Args    : arg #1 = a range to compare this one to (mandatory)\n            arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n  Returns : true if the ranges overlap, false otherwise\n\n\nsub overlaps {\n\tmy ($self, $other, $so) = @_;\n\n\t$self->throw(\"start is undefined\") unless defined $self->start;\n\t$self->throw(\"end is undefined\") unless defined $self->end;\n\t$self->throw(\"not a Bio::RangeI object\") unless defined $other &&\n\t  $other->isa('Bio::RangeI');\n\t$other->throw(\"start is undefined\") unless defined $other->start;\n\t$other->throw(\"end is undefined\") unless defined $other->end;\n\n\treturn\n\t  ($self->_testStrand($other, $so)\n\t\tand not (\n\t\t\t\t\t($self->start() > $other->end() or\n\t\t\t\t\t $self->end() < $other->start()   )\n\t\t\t\t  ));\n}\n\n=head2 contains\n\n  Title   : contains\n  Usage   : if($r1->contains($r2) { do stuff }\n  Function: tests whether $r1 totally contains $r2\n  Args    : arg #1 = a range to compare this one to (mandatory)\n\t             alternatively, integer scalar to test\n            arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n  Returns : true if the argument is totally contained within this range\n\n\nsub contains {\n\tmy ($self, $other, $so) = @_;\n\t$self->throw(\"start is undefined\") unless defined $self->start;\n\t$self->throw(\"end is undefined\") unless defined $self->end;\n\n\tif(defined $other && ref $other) { # a range object?\n      $other->throw(\"Not a Bio::RangeI object: $other\") unless  $other->isa('Bio::RangeI');\n      $other->throw(\"start is undefined\") unless defined $other->start;\n      $other->throw(\"end is undefined\") unless defined $other->end;\n\n      return ($self->_testStrand($other, $so)      and\n\t\t\t\t  $other->start() >= $self->start() and\n\t\t\t\t  $other->end() <= $self->end());\n  } else { # a scalar?\n\t  $self->throw(\"'$other' is not an integer.\\n\") unless $other =~ /^[-+]?\\d+$/;\n\t  return ($other >= $self->start() and $other <= $self->end());\n  }\n}\n\n=head2 equals\n\n  Title   : equals\n  Usage   : if($r1->equals($r2))\n  Function: test whether $r1 has the same start, end, length as $r2\n  Args    : arg #1 = a range to compare this one to (mandatory)\n            arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n  Returns : true if they are describing the same range\n\n\nsub equals {\n    my ($self, $other, $so) = @_;\n\n    $self->throw(\"start is undefined\") unless defined $self->start;\n    $self->throw(\"end is undefined\") unless defined $self->end;\n    $other->throw(\"Not a Bio::RangeI object\") unless  $other->isa('Bio::RangeI');\n    $other->throw(\"start is undefined\") unless defined $other->start;\n    $other->throw(\"end is undefined\") unless defined $other->end;\n\n    return ($self->_testStrand($other, $so)   and\n\t    $self->start() == $other->start() and\n\t    $self->end()   == $other->end()       );\n}\n\n=head1 Geometrical methods\n\nThese methods do things to the geometry of ranges, and return\nBio::RangeI compliant objects or triplets (start, stop, strand) from\nwhich new ranges could be built.\n\n=head2 intersection\n\n Title   : intersection\n Usage   : ($start, $stop, $strand) = $r1->intersection($r2); OR\n           ($start, $stop, $strand) = Bio::Range->intersection(\\@ranges); OR\n           my $containing_range = $r1->intersection($r2); OR\n           my $containing_range = Bio::Range->intersection(\\@ranges);\n Function: gives the range that is contained by all ranges\n Returns : undef if they do not overlap, or\n           the range that they do overlap (in the form of an object\n            like the calling one, OR a three element array)\n Args    : arg #1 = [REQUIRED] a range to compare this one to,\n                    or an array ref of ranges\n           arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n\n\nsub intersection {\n\tmy ($self, $given, $so) = @_;\n\t$self->throw(\"missing arg: you need to pass in another feature\") unless $given;\n\n    my @ranges;\n    if ($self eq \"Bio::RangeI\") {\n\t\t$self = \"Bio::Range\";\n\t\t$self->warn(\"calling static methods of an interface is deprecated; use $self instead\");\n\t}\n\tif (ref $self) {\n\t\tpush(@ranges, $self);\n\t}\n    ref($given) eq 'ARRAY' ? push(@ranges, @{$given}) : push(@ranges, $given);\n    $self->throw(\"Need at least 2 ranges\") unless @ranges >= 2;\n\n    my $intersect;\n    while (@ranges > 0) {\n        unless ($intersect) {\n            $intersect = shift(@ranges);\n            $self->throw(\"Not an object: $intersect\") unless ref($intersect);\n            $self->throw(\"Not a Bio::RangeI object: $intersect\") unless $intersect->isa('Bio::RangeI');\n            $self->throw(\"start is undefined\") unless defined $intersect->start;\n            $self->throw(\"end is undefined\") unless defined $intersect->end;\n        }\n\n        my $compare = shift(@ranges);\n        $self->throw(\"Not an object: $compare\") unless ref($compare);\n        $self->throw(\"Not a Bio::RangeI object: $compare\") unless $compare->isa('Bio::RangeI');\n        $self->throw(\"start is undefined\") unless defined $compare->start;\n        $self->throw(\"end is undefined\") unless defined $compare->end;\n        return unless $compare->_testStrand($intersect, $so);\n\n        my @starts = sort {$a <=> $b} ($intersect->start(), $compare->start());\n        my @ends   = sort {$a <=> $b} ($intersect->end(), $compare->end());\n\n        my $start = pop @starts; # larger of the 2 starts\n        my $end = shift @ends;   # smaller of the 2 ends\n\n        my $intersect_strand;    # strand for the intersection\n        if (defined($intersect->strand) && defined($compare->strand) && $intersect->strand == $compare->strand) {\n            $intersect_strand = $compare->strand;\n        }\n        else {\n            $intersect_strand = 0;\n        }\n\n        if ($start > $end) {\n            return;\n        }\n        else {\n            $intersect = $self->new(-start  => $start,\n                                    -end    => $end,\n                                    -strand => $intersect_strand);\n        }\n    }\n\n    if (wantarray()) {\n        return ($intersect->start, $intersect->end, $intersect->strand);\n    }\n    else {\n        return $intersect;\n    }\n}\n\n=head2 union\n\n   Title   : union\n    Usage   : ($start, $stop, $strand) = $r1->union($r2);\n            : ($start, $stop, $strand) = Bio::Range->union(@ranges);\n              my $newrange = Bio::Range->union(@ranges);\n    Function: finds the minimal Range that contains all of the Ranges\n    Args    : a Range or list of Range objects\n    Returns : the range containing all of the range\n              (in the form of an object like the calling one, OR\n              a three element array)\n\n\nsub union {\n\tmy $self = shift;\n\tmy @ranges = @_;\n\tif ($self eq \"Bio::RangeI\") {\n\t\t$self = \"Bio::Range\";\n\t\t$self->warn(\"calling static methods of an interface is deprecated; use $self instead\");\n\t}\n\tif(ref $self) {\n\t\tunshift @ranges, $self;\n\t}\n\n\tmy @start = sort {$a<=>$b}\n\t  map( { $_->start() } @ranges);\n\tmy @end   = sort {$a<=>$b}\n\t  map( { $_->end()   } @ranges);\n\n\tmy $start = shift @start;\n\twhile( !defined $start ) {\n\t\t$start = shift @start;\n\t}\n\n\tmy $end = pop @end;\n\n\tmy $union_strand;  # Strand for the union range object.\n\n\tforeach(@ranges) {\n\t\tif(! defined $union_strand) {\n\t\t\t$union_strand = $_->strand;\n\t\t\tnext;\n\t\t} else {\n\t\t\tif(not defined $_->strand or $union_strand ne $_->strand) {\n\t\t\t\t$union_strand = 0;\n\t\t\t\tlast;\n\t\t\t}\n\t\t}\n\t}\n\treturn unless $start or $end;\n\tif( wantarray() ) {\n\t\treturn ( $start,$end,$union_strand);\n\t} else {\n\t\treturn $self->new('-start' => $start,\n\t\t\t\t\t\t\t\t'-end' => $end,\n\t\t\t\t\t\t\t\t'-strand' => $union_strand\n\t\t\t\t\t\t\t  );\n\t}\n}\n\n=head2 overlap_extent\n\n Title   : overlap_extent\n Usage   : ($a_unique,$common,$b_unique) = $a->overlap_extent($b)\n Function: Provides actual amount of overlap between two different\n           ranges\n Example :\n Returns : array of values containing the length unique to the calling\n           range, the length common to both, and the length unique to\n           the argument range\n Args    : a range","label":"overlap_extent($a,$b)"}},{"kind":12,"range":{"start":{"line":508,"character":0},"end":{"character":9999,"line":575}},"line":508,"containerName":"main::","name":"disconnected_ranges","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"disconnected_ranges","line":509},{"name":"$self","containerName":"disconnected_ranges","kind":13,"line":510},{"line":511,"kind":13,"containerName":"disconnected_ranges","name":"$self"},{"name":"$self","containerName":"disconnected_ranges","kind":13,"line":512},{"name":"warn","kind":12,"containerName":"disconnected_ranges","line":512},{"definition":"my","kind":13,"localvar":"my","containerName":"disconnected_ranges","name":"@inranges","line":514},{"line":515,"containerName":"disconnected_ranges","kind":13,"name":"$self"},{"name":"@inranges","kind":13,"containerName":"disconnected_ranges","line":516},{"containerName":"disconnected_ranges","kind":13,"name":"$self","line":516},{"definition":"my","localvar":"my","kind":13,"containerName":"disconnected_ranges","name":"@outranges","line":519},{"line":525,"name":"$inrange","localvar":"my","kind":13,"containerName":"disconnected_ranges","definition":"my"},{"kind":13,"containerName":"disconnected_ranges","name":"@inranges","line":525},{"line":526,"localvar":"my","containerName":"disconnected_ranges","kind":13,"name":"$intersects","definition":"my"},{"definition":"my","line":527,"name":"@outranges_new","localvar":"my","kind":13,"containerName":"disconnected_ranges"},{"definition":"my","line":528,"name":"@intersecting_ranges","kind":13,"localvar":"my","containerName":"disconnected_ranges"},{"definition":"my","localvar":"my","containerName":"disconnected_ranges","kind":13,"name":"$i","line":534},{"containerName":"disconnected_ranges","kind":13,"name":"$i","line":534},{"name":"@outranges","kind":13,"containerName":"disconnected_ranges","line":534},{"kind":13,"containerName":"disconnected_ranges","name":"$i","line":534},{"line":535,"name":"$outrange","localvar":"my","containerName":"disconnected_ranges","kind":13,"definition":"my"},{"line":535,"containerName":"disconnected_ranges","kind":13,"name":"$outranges"},{"name":"$i","containerName":"disconnected_ranges","kind":13,"line":535},{"definition":"my","line":536,"localvar":"my","containerName":"disconnected_ranges","kind":13,"name":"$intersection"},{"kind":13,"containerName":"disconnected_ranges","name":"$inrange","line":536},{"line":536,"name":"intersection","containerName":"disconnected_ranges","kind":12},{"name":"$outrange","containerName":"disconnected_ranges","kind":13,"line":536},{"name":"$intersection","kind":13,"containerName":"disconnected_ranges","line":537},{"name":"$intersects","kind":13,"containerName":"disconnected_ranges","line":538},{"definition":"my","name":"$union","localvar":"my","containerName":"disconnected_ranges","kind":13,"line":539},{"name":"$inrange","kind":13,"containerName":"disconnected_ranges","line":539},{"name":"union","kind":12,"containerName":"disconnected_ranges","line":539},{"line":539,"name":"$outrange","kind":13,"containerName":"disconnected_ranges"},{"containerName":"disconnected_ranges","kind":13,"name":"@intersecting_ranges","line":540},{"line":540,"containerName":"disconnected_ranges","kind":13,"name":"$union"},{"kind":13,"containerName":"disconnected_ranges","name":"@outranges_new","line":543},{"kind":13,"containerName":"disconnected_ranges","name":"$outrange","line":543},{"line":546,"containerName":"disconnected_ranges","kind":13,"name":"@outranges"},{"line":546,"containerName":"disconnected_ranges","kind":13,"name":"@outranges_new"},{"containerName":"disconnected_ranges","kind":13,"name":"@intersecting_ranges","line":550},{"line":551,"containerName":"disconnected_ranges","kind":13,"name":"@intersecting_ranges"},{"definition":"my","name":"$merged_range","containerName":"disconnected_ranges","localvar":"my","kind":13,"line":555},{"line":556,"kind":13,"containerName":"disconnected_ranges","name":"$self"},{"line":556,"name":"union","containerName":"disconnected_ranges","kind":12},{"kind":13,"containerName":"disconnected_ranges","name":"@intersecting_ranges","line":556},{"containerName":"disconnected_ranges","kind":13,"name":"@outranges","line":557},{"line":557,"containerName":"disconnected_ranges","kind":13,"name":"$merged_range"},{"kind":13,"containerName":"disconnected_ranges","name":"@outranges","line":562},{"line":562,"name":"@intersecting_ranges","kind":13,"containerName":"disconnected_ranges"},{"line":567,"kind":13,"containerName":"disconnected_ranges","name":"@outranges"},{"kind":13,"containerName":"disconnected_ranges","name":"$self","line":568},{"line":568,"containerName":"disconnected_ranges","kind":12,"name":"new"},{"line":568,"name":"$inrange","containerName":"disconnected_ranges","kind":13},{"line":568,"kind":12,"containerName":"disconnected_ranges","name":"start"},{"containerName":"disconnected_ranges","kind":13,"name":"$inrange","line":569},{"line":569,"name":"end","containerName":"disconnected_ranges","kind":12},{"kind":13,"containerName":"disconnected_ranges","name":"$inrange","line":570},{"line":570,"name":"strand","containerName":"disconnected_ranges","kind":12},{"kind":13,"containerName":"disconnected_ranges","name":"@outranges","line":574}],"definition":"sub"},{"detail":"($self,$offset_fiveprime,$offset_threeprime)","definition":"sub","name":"offsetStranded","containerName":"main::","children":[{"definition":"my","line":590,"name":"$self","localvar":"my","kind":13,"containerName":"offsetStranded"},{"line":590,"name":"$offset_fiveprime","kind":13,"containerName":"offsetStranded"},{"line":590,"name":"$offset_threeprime","containerName":"offsetStranded","kind":13},{"definition":"my","line":591,"containerName":"offsetStranded","localvar":"my","kind":13,"name":"$offset_start"},{"line":591,"name":"$offset_end","kind":13,"containerName":"offsetStranded"},{"name":"$self","containerName":"offsetStranded","kind":13,"line":591},{"containerName":"offsetStranded","kind":12,"name":"strand","line":591},{"name":"$offset_threeprime","containerName":"offsetStranded","kind":13,"line":591},{"kind":13,"containerName":"offsetStranded","name":"$offset_fiveprime","line":591},{"name":"$offset_fiveprime","kind":13,"containerName":"offsetStranded","line":591},{"line":591,"name":"$offset_threeprime","containerName":"offsetStranded","kind":13},{"name":"$self","containerName":"offsetStranded","kind":13,"line":592},{"containerName":"offsetStranded","kind":12,"name":"start","line":592},{"name":"$self","containerName":"offsetStranded","kind":13,"line":592},{"line":592,"containerName":"offsetStranded","kind":12,"name":"start"},{"line":592,"name":"$offset_start","containerName":"offsetStranded","kind":13},{"kind":13,"containerName":"offsetStranded","name":"$self","line":593},{"name":"end","containerName":"offsetStranded","kind":12,"line":593},{"line":593,"containerName":"offsetStranded","kind":13,"name":"$self"},{"name":"end","kind":12,"containerName":"offsetStranded","line":593},{"name":"$offset_end","kind":13,"containerName":"offsetStranded","line":593},{"name":"$self","kind":13,"containerName":"offsetStranded","line":594}],"signature":{"label":"offsetStranded($self,$offset_fiveprime,$offset_threeprime)","documentation":"1;\n# $Id: RangeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::RangeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Matthew Pocock\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::RangeI - Range interface\n\n=head1 SYNOPSIS\n\n  #Do not run this module directly\n\n=head1 DESCRIPTION\n\nThis provides a standard BioPerl range interface that should be\nimplemented by any object that wants to be treated as a range. This\nserves purely as an abstract base class for implementers and can not\nbe instantiated.\n\nRanges are modeled as having (start, end, length, strand). They use\nBio-coordinates - all points E<gt>= start and E<lt>= end are within the\nrange. End is always greater-than or equal-to start, and length is\ngreater than or equal to 1. The behaviour of a range is undefined if\nranges with negative numbers or zero are used.\n\nSo, in summary:\n\n  length = end - start + 1\n  end >= start\n  strand = (-1 | 0 | +1)\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.bioperl.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nJuha Muilu (muilu@ebi.ac.uk)\nSendu Bala (bix@sendu.me.uk)\nMalcolm Cook (mec@stowers-institute.org)\nStephen Montgomery (sm8 at sanger.ac.uk)\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::RangeI;\n\nuse strict;\nuse Carp;\nuse integer;\nuse vars qw(%STRAND_OPTIONS);\n\nuse base qw(Bio::Root::RootI);\n\nBEGIN {\n# STRAND_OPTIONS contains the legal values for the strand-testing options\n    %STRAND_OPTIONS = map { $_, '_' . $_ }\n    (\n     'strong', # ranges must have the same strand\n     'weak',   # ranges must have the same strand or no strand\n     'ignore', # ignore strand information\n     );\n}\n\n# utility methods\n#\n\n# returns true if strands are equal and non-zero\nsub _strong {\n    my ($r1, $r2) = @_;\n    my ($s1, $s2) = ($r1->strand(), $r2->strand());\n\n    return 1 if $s1 != 0 && $s1 == $s2;\n}\n\n# returns true if strands are equal or either is zero\nsub _weak {\n    my ($r1, $r2) = @_;\n    my ($s1, $s2) = ($r1->strand(), $r2->strand());\n    return 1 if $s1 == 0 || $s2 == 0 || $s1 == $s2;\n}\n\n# returns true for any strandedness\nsub _ignore {\n    return 1;\n}\n\n# works out what test to use for the strictness and returns true/false\n# e.g. $r1->_testStrand($r2, 'strong')\nsub _testStrand() {\n    my ($r1, $r2, $comp) = @_;\n    return 1 unless $comp;\n    my $func = $STRAND_OPTIONS{$comp};\n    return $r1->$func($r2);\n}\n\n=head1 Abstract methods\n\nThese methods must be implemented in all subclasses.\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $range->start();\n  Function: get/set the start of this range\n  Returns : the start of this range\n  Args    : optionally allows the start to be set\n            using $range->start($start)\n\n\nsub start {\n    shift->throw_not_implemented();\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $range->end();\n  Function: get/set the end of this range\n  Returns : the end of this range\n  Args    : optionally allows the end to be set\n            using $range->end($end)\n\n\nsub end {\n    shift->throw_not_implemented();\n}\n\n=head2 length\n\n  Title   : length\n  Usage   : $length = $range->length();\n  Function: get/set the length of this range\n  Returns : the length of this range\n  Args    : optionally allows the length to be set\n             using $range->length($length)\n\n\nsub length {\n    shift->throw_not_implemented();\n}\n\n=head2 strand\n\n  Title   : strand\n  Usage   : $strand = $range->strand();\n  Function: get/set the strand of this range\n  Returns : the strandedness (-1, 0, +1)\n  Args    : optionally allows the strand to be set\n            using $range->strand($strand)\n\n\nsub strand {\n    shift->throw_not_implemented();\n}\n\n=head1 Boolean Methods\n\nThese methods return true or false. They throw an error if start and\nend are not defined.\n\n  $range->overlaps($otherRange) && print \"Ranges overlap\\n\";\n\n=head2 overlaps\n\n  Title   : overlaps\n  Usage   : if($r1->overlaps($r2)) { do stuff }\n  Function: tests if $r2 overlaps $r1\n  Args    : arg #1 = a range to compare this one to (mandatory)\n            arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n  Returns : true if the ranges overlap, false otherwise\n\n\nsub overlaps {\n\tmy ($self, $other, $so) = @_;\n\n\t$self->throw(\"start is undefined\") unless defined $self->start;\n\t$self->throw(\"end is undefined\") unless defined $self->end;\n\t$self->throw(\"not a Bio::RangeI object\") unless defined $other &&\n\t  $other->isa('Bio::RangeI');\n\t$other->throw(\"start is undefined\") unless defined $other->start;\n\t$other->throw(\"end is undefined\") unless defined $other->end;\n\n\treturn\n\t  ($self->_testStrand($other, $so)\n\t\tand not (\n\t\t\t\t\t($self->start() > $other->end() or\n\t\t\t\t\t $self->end() < $other->start()   )\n\t\t\t\t  ));\n}\n\n=head2 contains\n\n  Title   : contains\n  Usage   : if($r1->contains($r2) { do stuff }\n  Function: tests whether $r1 totally contains $r2\n  Args    : arg #1 = a range to compare this one to (mandatory)\n\t             alternatively, integer scalar to test\n            arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n  Returns : true if the argument is totally contained within this range\n\n\nsub contains {\n\tmy ($self, $other, $so) = @_;\n\t$self->throw(\"start is undefined\") unless defined $self->start;\n\t$self->throw(\"end is undefined\") unless defined $self->end;\n\n\tif(defined $other && ref $other) { # a range object?\n      $other->throw(\"Not a Bio::RangeI object: $other\") unless  $other->isa('Bio::RangeI');\n      $other->throw(\"start is undefined\") unless defined $other->start;\n      $other->throw(\"end is undefined\") unless defined $other->end;\n\n      return ($self->_testStrand($other, $so)      and\n\t\t\t\t  $other->start() >= $self->start() and\n\t\t\t\t  $other->end() <= $self->end());\n  } else { # a scalar?\n\t  $self->throw(\"'$other' is not an integer.\\n\") unless $other =~ /^[-+]?\\d+$/;\n\t  return ($other >= $self->start() and $other <= $self->end());\n  }\n}\n\n=head2 equals\n\n  Title   : equals\n  Usage   : if($r1->equals($r2))\n  Function: test whether $r1 has the same start, end, length as $r2\n  Args    : arg #1 = a range to compare this one to (mandatory)\n            arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n  Returns : true if they are describing the same range\n\n\nsub equals {\n    my ($self, $other, $so) = @_;\n\n    $self->throw(\"start is undefined\") unless defined $self->start;\n    $self->throw(\"end is undefined\") unless defined $self->end;\n    $other->throw(\"Not a Bio::RangeI object\") unless  $other->isa('Bio::RangeI');\n    $other->throw(\"start is undefined\") unless defined $other->start;\n    $other->throw(\"end is undefined\") unless defined $other->end;\n\n    return ($self->_testStrand($other, $so)   and\n\t    $self->start() == $other->start() and\n\t    $self->end()   == $other->end()       );\n}\n\n=head1 Geometrical methods\n\nThese methods do things to the geometry of ranges, and return\nBio::RangeI compliant objects or triplets (start, stop, strand) from\nwhich new ranges could be built.\n\n=head2 intersection\n\n Title   : intersection\n Usage   : ($start, $stop, $strand) = $r1->intersection($r2); OR\n           ($start, $stop, $strand) = Bio::Range->intersection(\\@ranges); OR\n           my $containing_range = $r1->intersection($r2); OR\n           my $containing_range = Bio::Range->intersection(\\@ranges);\n Function: gives the range that is contained by all ranges\n Returns : undef if they do not overlap, or\n           the range that they do overlap (in the form of an object\n            like the calling one, OR a three element array)\n Args    : arg #1 = [REQUIRED] a range to compare this one to,\n                    or an array ref of ranges\n           arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n\n\nsub intersection {\n\tmy ($self, $given, $so) = @_;\n\t$self->throw(\"missing arg: you need to pass in another feature\") unless $given;\n\n    my @ranges;\n    if ($self eq \"Bio::RangeI\") {\n\t\t$self = \"Bio::Range\";\n\t\t$self->warn(\"calling static methods of an interface is deprecated; use $self instead\");\n\t}\n\tif (ref $self) {\n\t\tpush(@ranges, $self);\n\t}\n    ref($given) eq 'ARRAY' ? push(@ranges, @{$given}) : push(@ranges, $given);\n    $self->throw(\"Need at least 2 ranges\") unless @ranges >= 2;\n\n    my $intersect;\n    while (@ranges > 0) {\n        unless ($intersect) {\n            $intersect = shift(@ranges);\n            $self->throw(\"Not an object: $intersect\") unless ref($intersect);\n            $self->throw(\"Not a Bio::RangeI object: $intersect\") unless $intersect->isa('Bio::RangeI');\n            $self->throw(\"start is undefined\") unless defined $intersect->start;\n            $self->throw(\"end is undefined\") unless defined $intersect->end;\n        }\n\n        my $compare = shift(@ranges);\n        $self->throw(\"Not an object: $compare\") unless ref($compare);\n        $self->throw(\"Not a Bio::RangeI object: $compare\") unless $compare->isa('Bio::RangeI');\n        $self->throw(\"start is undefined\") unless defined $compare->start;\n        $self->throw(\"end is undefined\") unless defined $compare->end;\n        return unless $compare->_testStrand($intersect, $so);\n\n        my @starts = sort {$a <=> $b} ($intersect->start(), $compare->start());\n        my @ends   = sort {$a <=> $b} ($intersect->end(), $compare->end());\n\n        my $start = pop @starts; # larger of the 2 starts\n        my $end = shift @ends;   # smaller of the 2 ends\n\n        my $intersect_strand;    # strand for the intersection\n        if (defined($intersect->strand) && defined($compare->strand) && $intersect->strand == $compare->strand) {\n            $intersect_strand = $compare->strand;\n        }\n        else {\n            $intersect_strand = 0;\n        }\n\n        if ($start > $end) {\n            return;\n        }\n        else {\n            $intersect = $self->new(-start  => $start,\n                                    -end    => $end,\n                                    -strand => $intersect_strand);\n        }\n    }\n\n    if (wantarray()) {\n        return ($intersect->start, $intersect->end, $intersect->strand);\n    }\n    else {\n        return $intersect;\n    }\n}\n\n=head2 union\n\n   Title   : union\n    Usage   : ($start, $stop, $strand) = $r1->union($r2);\n            : ($start, $stop, $strand) = Bio::Range->union(@ranges);\n              my $newrange = Bio::Range->union(@ranges);\n    Function: finds the minimal Range that contains all of the Ranges\n    Args    : a Range or list of Range objects\n    Returns : the range containing all of the range\n              (in the form of an object like the calling one, OR\n              a three element array)\n\n\nsub union {\n\tmy $self = shift;\n\tmy @ranges = @_;\n\tif ($self eq \"Bio::RangeI\") {\n\t\t$self = \"Bio::Range\";\n\t\t$self->warn(\"calling static methods of an interface is deprecated; use $self instead\");\n\t}\n\tif(ref $self) {\n\t\tunshift @ranges, $self;\n\t}\n\n\tmy @start = sort {$a<=>$b}\n\t  map( { $_->start() } @ranges);\n\tmy @end   = sort {$a<=>$b}\n\t  map( { $_->end()   } @ranges);\n\n\tmy $start = shift @start;\n\twhile( !defined $start ) {\n\t\t$start = shift @start;\n\t}\n\n\tmy $end = pop @end;\n\n\tmy $union_strand;  # Strand for the union range object.\n\n\tforeach(@ranges) {\n\t\tif(! defined $union_strand) {\n\t\t\t$union_strand = $_->strand;\n\t\t\tnext;\n\t\t} else {\n\t\t\tif(not defined $_->strand or $union_strand ne $_->strand) {\n\t\t\t\t$union_strand = 0;\n\t\t\t\tlast;\n\t\t\t}\n\t\t}\n\t}\n\treturn unless $start or $end;\n\tif( wantarray() ) {\n\t\treturn ( $start,$end,$union_strand);\n\t} else {\n\t\treturn $self->new('-start' => $start,\n\t\t\t\t\t\t\t\t'-end' => $end,\n\t\t\t\t\t\t\t\t'-strand' => $union_strand\n\t\t\t\t\t\t\t  );\n\t}\n}\n\n=head2 overlap_extent\n\n Title   : overlap_extent\n Usage   : ($a_unique,$common,$b_unique) = $a->overlap_extent($b)\n Function: Provides actual amount of overlap between two different\n           ranges\n Example :\n Returns : array of values containing the length unique to the calling\n           range, the length common to both, and the length unique to\n           the argument range\n Args    : a range\n\n\nsub overlap_extent{\n\tmy ($a,$b) = @_;\n\n\t$a->throw(\"start is undefined\") unless defined $a->start;\n\t$a->throw(\"end is undefined\") unless defined $a->end;\n\t$b->throw(\"Not a Bio::RangeI object\") unless  $b->isa('Bio::RangeI');\n\t$b->throw(\"start is undefined\") unless defined $b->start;\n\t$b->throw(\"end is undefined\") unless defined $b->end;\n\n\tif( ! $a->overlaps($b) ) {\n\t    return ($a->length,0,$b->length);\n\t}\n\n\tmy ($au,$bu) = (0, 0);\n\tif( $a->start < $b->start ) {\n\t\t$au = $b->start - $a->start;\n\t} else {\n\t\t$bu = $a->start - $b->start;\n\t}\n\n\tif( $a->end > $b->end ) {\n\t\t$au += $a->end - $b->end;\n\t} else {\n\t\t$bu += $b->end - $a->end;\n\t}\n\n\tmy $intersect = $a->intersection($b);\n\tif( ! $intersect ) {\n\t    warn(\"no intersection\\n\");\n\t    return ($au, 0, $bu);\n\t} else {\n\t    my $ie = $intersect->end;\n\t    my $is = $intersect->start;\n\t    return ($au,$ie-$is+1,$bu);\n\t}\n}\n\n=head2 disconnected_ranges\n\n    Title   : disconnected_ranges\n    Usage   : my @disc_ranges = Bio::Range->disconnected_ranges(@ranges);\n    Function: finds the minimal set of ranges such that each input range\n              is fully contained by at least one output range, and none of\n              the output ranges overlap\n    Args    : a list of ranges\n    Returns : a list of objects of the same type as the input\n              (conforms to RangeI)\n\n\nsub disconnected_ranges {\n    my $self = shift;\n    if ($self eq \"Bio::RangeI\") {\n\t$self = \"Bio::Range\";\n\t$self->warn(\"calling static methods of an interface is deprecated; use $self instead\");\n    }\n    my @inranges = @_;\n    if(ref $self) {\n\tunshift @inranges, $self;\n    }\n\n    my @outranges = (); # disconnected ranges\n\n    # iterate through all input ranges $inrange,\n    # adding each input range to the set of output ranges @outranges,\n    # provided $inrange does not overlap ANY range in @outranges\n    # - if it does overlap an outrange, then merge it\n    foreach my $inrange (@inranges) {\n\tmy $intersects = 0;\n\tmy @outranges_new = ();\n\tmy @intersecting_ranges = ();\n\n        # iterate through all @outranges, testing if it intersects\n        # current $inrange; if it does, merge and add to list\n        # of @intersecting_ranges, otherwise add $outrange to\n        # the new list of outranges that do NOT intersect\n\tfor (my $i=0; $i<@outranges; $i++) {\n\t    my $outrange = $outranges[$i];\n\t    my $intersection = $inrange->intersection($outrange);\n\t    if ($intersection) {\n\t\t$intersects = 1;\n\t\tmy $union = $inrange->union($outrange);\n\t\tpush(@intersecting_ranges, $union);\n\t    }\n\t    else {\n\t\tpush(@outranges_new, $outrange);\n\t    }\n\t}\n\t@outranges = @outranges_new;\n        # @outranges now contains a list of non-overlapping ranges\n        # that do not intersect the current $inrange\n\n\tif (@intersecting_ranges) {\n\t    if (@intersecting_ranges > 1) {\n\t\t# this sf intersected > 1 range, which means that\n\t\t# all the ranges it intersects should be joined\n\t\t# together in a new range\n                my $merged_range =\n                  $self->union(@intersecting_ranges);\n\t\tpush(@outranges, $merged_range);\n\n\t    }\n\t    else {\n\t\t# exactly 1 intersecting range\n\t\tpush(@outranges, @intersecting_ranges);\n\t    }\n\t}\n\telse {\n\t    # no intersections found - new range\n\t    push(@outranges,\n\t\t $self->new('-start'=>$inrange->start,\n\t\t\t    '-end'=>$inrange->end,\n\t\t\t    '-strand'=>$inrange->strand,\n\t\t\t   ));\n\t}\n    }\n    return @outranges;\n}\n\n=head2 offsetStranded\n\n    Title    : offsetStranded\n    Usage    : $rnge->ofsetStranded($fiveprime_offset, $threeprime_offset)\n    Function : destructively modifies RangeI implementing object to\n               offset its start and stop coordinates by values $fiveprime_offset and\n               $threeprime_offset (positive values being in the strand direction).\n    Args     : two integer offsets: $fiveprime_offset and $threeprime_offset\n    Returns  : $self, offset accordingly.","parameters":[{"label":"$self"},{"label":"$offset_fiveprime"},{"label":"$offset_threeprime"}]},"range":{"end":{"character":9999,"line":595},"start":{"line":589,"character":0}},"kind":12,"line":589},{"containerName":"main::","name":"subtract","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"subtract","line":612},{"containerName":"subtract","kind":13,"name":"$range","line":612},{"line":612,"kind":13,"containerName":"subtract","name":"$so"},{"line":613,"containerName":"subtract","kind":13,"name":"$self"},{"kind":12,"containerName":"subtract","name":"throw","line":613},{"name":"$range","kind":13,"containerName":"subtract","line":614},{"line":615,"name":"$self","kind":13,"containerName":"subtract"},{"name":"_testStrand","kind":12,"containerName":"subtract","line":615},{"line":615,"name":"$range","containerName":"subtract","kind":13},{"line":615,"containerName":"subtract","kind":13,"name":"$so"},{"containerName":"subtract","kind":13,"name":"$self","line":617},{"containerName":"subtract","kind":13,"name":"$self","line":618},{"line":619,"containerName":"subtract","kind":13,"name":"$self"},{"line":619,"kind":12,"containerName":"subtract","name":"warn"},{"containerName":"subtract","kind":13,"name":"$range","line":622},{"line":622,"containerName":"subtract","kind":12,"name":"throw"},{"name":"$range","containerName":"subtract","kind":13,"line":623},{"line":623,"containerName":"subtract","kind":12,"name":"isa"},{"containerName":"subtract","kind":13,"name":"$self","line":625},{"line":625,"kind":12,"containerName":"subtract","name":"overlaps"},{"name":"$range","kind":13,"containerName":"subtract","line":625},{"line":630,"kind":13,"containerName":"subtract","name":"$range"},{"line":630,"name":"contains","kind":12,"containerName":"subtract"},{"name":"$self","containerName":"subtract","kind":13,"line":630},{"definition":"my","name":"$start","kind":13,"localvar":"my","containerName":"subtract","line":634},{"name":"$end","containerName":"subtract","kind":13,"line":634},{"kind":13,"containerName":"subtract","name":"$strand","line":634},{"kind":13,"containerName":"subtract","name":"$self","line":634},{"containerName":"subtract","kind":12,"name":"intersection","line":634},{"kind":13,"containerName":"subtract","name":"$range","line":634},{"containerName":"subtract","kind":13,"name":"$so","line":634},{"definition":"my","line":637,"containerName":"subtract","localvar":"my","kind":13,"name":"@outranges"},{"line":638,"containerName":"subtract","kind":13,"name":"$self"},{"name":"start","kind":12,"containerName":"subtract","line":638},{"line":638,"name":"$start","kind":13,"containerName":"subtract"},{"line":639,"containerName":"subtract","kind":13,"name":"@outranges"},{"line":640,"name":"$self","containerName":"subtract","kind":13},{"line":640,"name":"new","kind":12,"containerName":"subtract"},{"line":640,"name":"$self","containerName":"subtract","kind":13},{"line":640,"containerName":"subtract","kind":12,"name":"start"},{"line":641,"containerName":"subtract","kind":13,"name":"$start"},{"name":"$self","kind":13,"containerName":"subtract","line":642},{"line":642,"containerName":"subtract","kind":12,"name":"strand"},{"name":"$self","kind":13,"containerName":"subtract","line":645},{"name":"end","containerName":"subtract","kind":12,"line":645},{"name":"$end","kind":13,"containerName":"subtract","line":645},{"name":"@outranges","containerName":"subtract","kind":13,"line":646},{"kind":13,"containerName":"subtract","name":"$self","line":647},{"kind":12,"containerName":"subtract","name":"new","line":647},{"containerName":"subtract","kind":13,"name":"$end","line":647},{"line":648,"kind":13,"containerName":"subtract","name":"$self"},{"name":"end","kind":12,"containerName":"subtract","line":648},{"containerName":"subtract","kind":13,"name":"$self","line":649},{"line":649,"containerName":"subtract","kind":12,"name":"strand"},{"line":652,"containerName":"subtract","kind":13,"name":"@outranges"}],"detail":"()","definition":"sub","range":{"end":{"character":9999,"line":653},"start":{"character":0,"line":611}},"kind":12,"line":611,"signature":{"label":"subtract()","documentation":"1;\n# $Id: RangeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::RangeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Matthew Pocock\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::RangeI - Range interface\n\n=head1 SYNOPSIS\n\n  #Do not run this module directly\n\n=head1 DESCRIPTION\n\nThis provides a standard BioPerl range interface that should be\nimplemented by any object that wants to be treated as a range. This\nserves purely as an abstract base class for implementers and can not\nbe instantiated.\n\nRanges are modeled as having (start, end, length, strand). They use\nBio-coordinates - all points E<gt>= start and E<lt>= end are within the\nrange. End is always greater-than or equal-to start, and length is\ngreater than or equal to 1. The behaviour of a range is undefined if\nranges with negative numbers or zero are used.\n\nSo, in summary:\n\n  length = end - start + 1\n  end >= start\n  strand = (-1 | 0 | +1)\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.bioperl.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nJuha Muilu (muilu@ebi.ac.uk)\nSendu Bala (bix@sendu.me.uk)\nMalcolm Cook (mec@stowers-institute.org)\nStephen Montgomery (sm8 at sanger.ac.uk)\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::RangeI;\n\nuse strict;\nuse Carp;\nuse integer;\nuse vars qw(%STRAND_OPTIONS);\n\nuse base qw(Bio::Root::RootI);\n\nBEGIN {\n# STRAND_OPTIONS contains the legal values for the strand-testing options\n    %STRAND_OPTIONS = map { $_, '_' . $_ }\n    (\n     'strong', # ranges must have the same strand\n     'weak',   # ranges must have the same strand or no strand\n     'ignore', # ignore strand information\n     );\n}\n\n# utility methods\n#\n\n# returns true if strands are equal and non-zero\nsub _strong {\n    my ($r1, $r2) = @_;\n    my ($s1, $s2) = ($r1->strand(), $r2->strand());\n\n    return 1 if $s1 != 0 && $s1 == $s2;\n}\n\n# returns true if strands are equal or either is zero\nsub _weak {\n    my ($r1, $r2) = @_;\n    my ($s1, $s2) = ($r1->strand(), $r2->strand());\n    return 1 if $s1 == 0 || $s2 == 0 || $s1 == $s2;\n}\n\n# returns true for any strandedness\nsub _ignore {\n    return 1;\n}\n\n# works out what test to use for the strictness and returns true/false\n# e.g. $r1->_testStrand($r2, 'strong')\nsub _testStrand() {\n    my ($r1, $r2, $comp) = @_;\n    return 1 unless $comp;\n    my $func = $STRAND_OPTIONS{$comp};\n    return $r1->$func($r2);\n}\n\n=head1 Abstract methods\n\nThese methods must be implemented in all subclasses.\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $range->start();\n  Function: get/set the start of this range\n  Returns : the start of this range\n  Args    : optionally allows the start to be set\n            using $range->start($start)\n\n\nsub start {\n    shift->throw_not_implemented();\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $range->end();\n  Function: get/set the end of this range\n  Returns : the end of this range\n  Args    : optionally allows the end to be set\n            using $range->end($end)\n\n\nsub end {\n    shift->throw_not_implemented();\n}\n\n=head2 length\n\n  Title   : length\n  Usage   : $length = $range->length();\n  Function: get/set the length of this range\n  Returns : the length of this range\n  Args    : optionally allows the length to be set\n             using $range->length($length)\n\n\nsub length {\n    shift->throw_not_implemented();\n}\n\n=head2 strand\n\n  Title   : strand\n  Usage   : $strand = $range->strand();\n  Function: get/set the strand of this range\n  Returns : the strandedness (-1, 0, +1)\n  Args    : optionally allows the strand to be set\n            using $range->strand($strand)\n\n\nsub strand {\n    shift->throw_not_implemented();\n}\n\n=head1 Boolean Methods\n\nThese methods return true or false. They throw an error if start and\nend are not defined.\n\n  $range->overlaps($otherRange) && print \"Ranges overlap\\n\";\n\n=head2 overlaps\n\n  Title   : overlaps\n  Usage   : if($r1->overlaps($r2)) { do stuff }\n  Function: tests if $r2 overlaps $r1\n  Args    : arg #1 = a range to compare this one to (mandatory)\n            arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n  Returns : true if the ranges overlap, false otherwise\n\n\nsub overlaps {\n\tmy ($self, $other, $so) = @_;\n\n\t$self->throw(\"start is undefined\") unless defined $self->start;\n\t$self->throw(\"end is undefined\") unless defined $self->end;\n\t$self->throw(\"not a Bio::RangeI object\") unless defined $other &&\n\t  $other->isa('Bio::RangeI');\n\t$other->throw(\"start is undefined\") unless defined $other->start;\n\t$other->throw(\"end is undefined\") unless defined $other->end;\n\n\treturn\n\t  ($self->_testStrand($other, $so)\n\t\tand not (\n\t\t\t\t\t($self->start() > $other->end() or\n\t\t\t\t\t $self->end() < $other->start()   )\n\t\t\t\t  ));\n}\n\n=head2 contains\n\n  Title   : contains\n  Usage   : if($r1->contains($r2) { do stuff }\n  Function: tests whether $r1 totally contains $r2\n  Args    : arg #1 = a range to compare this one to (mandatory)\n\t             alternatively, integer scalar to test\n            arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n  Returns : true if the argument is totally contained within this range\n\n\nsub contains {\n\tmy ($self, $other, $so) = @_;\n\t$self->throw(\"start is undefined\") unless defined $self->start;\n\t$self->throw(\"end is undefined\") unless defined $self->end;\n\n\tif(defined $other && ref $other) { # a range object?\n      $other->throw(\"Not a Bio::RangeI object: $other\") unless  $other->isa('Bio::RangeI');\n      $other->throw(\"start is undefined\") unless defined $other->start;\n      $other->throw(\"end is undefined\") unless defined $other->end;\n\n      return ($self->_testStrand($other, $so)      and\n\t\t\t\t  $other->start() >= $self->start() and\n\t\t\t\t  $other->end() <= $self->end());\n  } else { # a scalar?\n\t  $self->throw(\"'$other' is not an integer.\\n\") unless $other =~ /^[-+]?\\d+$/;\n\t  return ($other >= $self->start() and $other <= $self->end());\n  }\n}\n\n=head2 equals\n\n  Title   : equals\n  Usage   : if($r1->equals($r2))\n  Function: test whether $r1 has the same start, end, length as $r2\n  Args    : arg #1 = a range to compare this one to (mandatory)\n            arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n  Returns : true if they are describing the same range\n\n\nsub equals {\n    my ($self, $other, $so) = @_;\n\n    $self->throw(\"start is undefined\") unless defined $self->start;\n    $self->throw(\"end is undefined\") unless defined $self->end;\n    $other->throw(\"Not a Bio::RangeI object\") unless  $other->isa('Bio::RangeI');\n    $other->throw(\"start is undefined\") unless defined $other->start;\n    $other->throw(\"end is undefined\") unless defined $other->end;\n\n    return ($self->_testStrand($other, $so)   and\n\t    $self->start() == $other->start() and\n\t    $self->end()   == $other->end()       );\n}\n\n=head1 Geometrical methods\n\nThese methods do things to the geometry of ranges, and return\nBio::RangeI compliant objects or triplets (start, stop, strand) from\nwhich new ranges could be built.\n\n=head2 intersection\n\n Title   : intersection\n Usage   : ($start, $stop, $strand) = $r1->intersection($r2); OR\n           ($start, $stop, $strand) = Bio::Range->intersection(\\@ranges); OR\n           my $containing_range = $r1->intersection($r2); OR\n           my $containing_range = Bio::Range->intersection(\\@ranges);\n Function: gives the range that is contained by all ranges\n Returns : undef if they do not overlap, or\n           the range that they do overlap (in the form of an object\n            like the calling one, OR a three element array)\n Args    : arg #1 = [REQUIRED] a range to compare this one to,\n                    or an array ref of ranges\n           arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n\n\nsub intersection {\n\tmy ($self, $given, $so) = @_;\n\t$self->throw(\"missing arg: you need to pass in another feature\") unless $given;\n\n    my @ranges;\n    if ($self eq \"Bio::RangeI\") {\n\t\t$self = \"Bio::Range\";\n\t\t$self->warn(\"calling static methods of an interface is deprecated; use $self instead\");\n\t}\n\tif (ref $self) {\n\t\tpush(@ranges, $self);\n\t}\n    ref($given) eq 'ARRAY' ? push(@ranges, @{$given}) : push(@ranges, $given);\n    $self->throw(\"Need at least 2 ranges\") unless @ranges >= 2;\n\n    my $intersect;\n    while (@ranges > 0) {\n        unless ($intersect) {\n            $intersect = shift(@ranges);\n            $self->throw(\"Not an object: $intersect\") unless ref($intersect);\n            $self->throw(\"Not a Bio::RangeI object: $intersect\") unless $intersect->isa('Bio::RangeI');\n            $self->throw(\"start is undefined\") unless defined $intersect->start;\n            $self->throw(\"end is undefined\") unless defined $intersect->end;\n        }\n\n        my $compare = shift(@ranges);\n        $self->throw(\"Not an object: $compare\") unless ref($compare);\n        $self->throw(\"Not a Bio::RangeI object: $compare\") unless $compare->isa('Bio::RangeI');\n        $self->throw(\"start is undefined\") unless defined $compare->start;\n        $self->throw(\"end is undefined\") unless defined $compare->end;\n        return unless $compare->_testStrand($intersect, $so);\n\n        my @starts = sort {$a <=> $b} ($intersect->start(), $compare->start());\n        my @ends   = sort {$a <=> $b} ($intersect->end(), $compare->end());\n\n        my $start = pop @starts; # larger of the 2 starts\n        my $end = shift @ends;   # smaller of the 2 ends\n\n        my $intersect_strand;    # strand for the intersection\n        if (defined($intersect->strand) && defined($compare->strand) && $intersect->strand == $compare->strand) {\n            $intersect_strand = $compare->strand;\n        }\n        else {\n            $intersect_strand = 0;\n        }\n\n        if ($start > $end) {\n            return;\n        }\n        else {\n            $intersect = $self->new(-start  => $start,\n                                    -end    => $end,\n                                    -strand => $intersect_strand);\n        }\n    }\n\n    if (wantarray()) {\n        return ($intersect->start, $intersect->end, $intersect->strand);\n    }\n    else {\n        return $intersect;\n    }\n}\n\n=head2 union\n\n   Title   : union\n    Usage   : ($start, $stop, $strand) = $r1->union($r2);\n            : ($start, $stop, $strand) = Bio::Range->union(@ranges);\n              my $newrange = Bio::Range->union(@ranges);\n    Function: finds the minimal Range that contains all of the Ranges\n    Args    : a Range or list of Range objects\n    Returns : the range containing all of the range\n              (in the form of an object like the calling one, OR\n              a three element array)\n\n\nsub union {\n\tmy $self = shift;\n\tmy @ranges = @_;\n\tif ($self eq \"Bio::RangeI\") {\n\t\t$self = \"Bio::Range\";\n\t\t$self->warn(\"calling static methods of an interface is deprecated; use $self instead\");\n\t}\n\tif(ref $self) {\n\t\tunshift @ranges, $self;\n\t}\n\n\tmy @start = sort {$a<=>$b}\n\t  map( { $_->start() } @ranges);\n\tmy @end   = sort {$a<=>$b}\n\t  map( { $_->end()   } @ranges);\n\n\tmy $start = shift @start;\n\twhile( !defined $start ) {\n\t\t$start = shift @start;\n\t}\n\n\tmy $end = pop @end;\n\n\tmy $union_strand;  # Strand for the union range object.\n\n\tforeach(@ranges) {\n\t\tif(! defined $union_strand) {\n\t\t\t$union_strand = $_->strand;\n\t\t\tnext;\n\t\t} else {\n\t\t\tif(not defined $_->strand or $union_strand ne $_->strand) {\n\t\t\t\t$union_strand = 0;\n\t\t\t\tlast;\n\t\t\t}\n\t\t}\n\t}\n\treturn unless $start or $end;\n\tif( wantarray() ) {\n\t\treturn ( $start,$end,$union_strand);\n\t} else {\n\t\treturn $self->new('-start' => $start,\n\t\t\t\t\t\t\t\t'-end' => $end,\n\t\t\t\t\t\t\t\t'-strand' => $union_strand\n\t\t\t\t\t\t\t  );\n\t}\n}\n\n=head2 overlap_extent\n\n Title   : overlap_extent\n Usage   : ($a_unique,$common,$b_unique) = $a->overlap_extent($b)\n Function: Provides actual amount of overlap between two different\n           ranges\n Example :\n Returns : array of values containing the length unique to the calling\n           range, the length common to both, and the length unique to\n           the argument range\n Args    : a range\n\n\nsub overlap_extent{\n\tmy ($a,$b) = @_;\n\n\t$a->throw(\"start is undefined\") unless defined $a->start;\n\t$a->throw(\"end is undefined\") unless defined $a->end;\n\t$b->throw(\"Not a Bio::RangeI object\") unless  $b->isa('Bio::RangeI');\n\t$b->throw(\"start is undefined\") unless defined $b->start;\n\t$b->throw(\"end is undefined\") unless defined $b->end;\n\n\tif( ! $a->overlaps($b) ) {\n\t    return ($a->length,0,$b->length);\n\t}\n\n\tmy ($au,$bu) = (0, 0);\n\tif( $a->start < $b->start ) {\n\t\t$au = $b->start - $a->start;\n\t} else {\n\t\t$bu = $a->start - $b->start;\n\t}\n\n\tif( $a->end > $b->end ) {\n\t\t$au += $a->end - $b->end;\n\t} else {\n\t\t$bu += $b->end - $a->end;\n\t}\n\n\tmy $intersect = $a->intersection($b);\n\tif( ! $intersect ) {\n\t    warn(\"no intersection\\n\");\n\t    return ($au, 0, $bu);\n\t} else {\n\t    my $ie = $intersect->end;\n\t    my $is = $intersect->start;\n\t    return ($au,$ie-$is+1,$bu);\n\t}\n}\n\n=head2 disconnected_ranges\n\n    Title   : disconnected_ranges\n    Usage   : my @disc_ranges = Bio::Range->disconnected_ranges(@ranges);\n    Function: finds the minimal set of ranges such that each input range\n              is fully contained by at least one output range, and none of\n              the output ranges overlap\n    Args    : a list of ranges\n    Returns : a list of objects of the same type as the input\n              (conforms to RangeI)\n\n\nsub disconnected_ranges {\n    my $self = shift;\n    if ($self eq \"Bio::RangeI\") {\n\t$self = \"Bio::Range\";\n\t$self->warn(\"calling static methods of an interface is deprecated; use $self instead\");\n    }\n    my @inranges = @_;\n    if(ref $self) {\n\tunshift @inranges, $self;\n    }\n\n    my @outranges = (); # disconnected ranges\n\n    # iterate through all input ranges $inrange,\n    # adding each input range to the set of output ranges @outranges,\n    # provided $inrange does not overlap ANY range in @outranges\n    # - if it does overlap an outrange, then merge it\n    foreach my $inrange (@inranges) {\n\tmy $intersects = 0;\n\tmy @outranges_new = ();\n\tmy @intersecting_ranges = ();\n\n        # iterate through all @outranges, testing if it intersects\n        # current $inrange; if it does, merge and add to list\n        # of @intersecting_ranges, otherwise add $outrange to\n        # the new list of outranges that do NOT intersect\n\tfor (my $i=0; $i<@outranges; $i++) {\n\t    my $outrange = $outranges[$i];\n\t    my $intersection = $inrange->intersection($outrange);\n\t    if ($intersection) {\n\t\t$intersects = 1;\n\t\tmy $union = $inrange->union($outrange);\n\t\tpush(@intersecting_ranges, $union);\n\t    }\n\t    else {\n\t\tpush(@outranges_new, $outrange);\n\t    }\n\t}\n\t@outranges = @outranges_new;\n        # @outranges now contains a list of non-overlapping ranges\n        # that do not intersect the current $inrange\n\n\tif (@intersecting_ranges) {\n\t    if (@intersecting_ranges > 1) {\n\t\t# this sf intersected > 1 range, which means that\n\t\t# all the ranges it intersects should be joined\n\t\t# together in a new range\n                my $merged_range =\n                  $self->union(@intersecting_ranges);\n\t\tpush(@outranges, $merged_range);\n\n\t    }\n\t    else {\n\t\t# exactly 1 intersecting range\n\t\tpush(@outranges, @intersecting_ranges);\n\t    }\n\t}\n\telse {\n\t    # no intersections found - new range\n\t    push(@outranges,\n\t\t $self->new('-start'=>$inrange->start,\n\t\t\t    '-end'=>$inrange->end,\n\t\t\t    '-strand'=>$inrange->strand,\n\t\t\t   ));\n\t}\n    }\n    return @outranges;\n}\n\n=head2 offsetStranded\n\n    Title    : offsetStranded\n    Usage    : $rnge->ofsetStranded($fiveprime_offset, $threeprime_offset)\n    Function : destructively modifies RangeI implementing object to\n               offset its start and stop coordinates by values $fiveprime_offset and\n               $threeprime_offset (positive values being in the strand direction).\n    Args     : two integer offsets: $fiveprime_offset and $threeprime_offset\n    Returns  : $self, offset accordingly.\n\n\nsub offsetStranded {\n  my ($self, $offset_fiveprime, $offset_threeprime) = @_;\n  my ($offset_start, $offset_end) = $self->strand() eq -1 ? (- $offset_threeprime, - $offset_fiveprime) : ($offset_fiveprime, $offset_threeprime);\n  $self->start($self->start + $offset_start);\n  $self->end($self->end + $offset_end);\n  return $self;\n};\n\n=head2 subtract\n\n  Title   : subtract\n  Usage   : my @subtracted = $r1->subtract($r2)\n  Function: Subtract range r2 from range r1\n  Args    : arg #1 = a range to subtract from this one (mandatory)\n            arg #2 = strand option ('strong', 'weak', 'ignore') (optional)\n  Returns : undef if they do not overlap or r2 contains this RangeI,\n            or an arrayref of Range objects (this is an array since some\n            instances where the subtract range is enclosed within this range\n            will result in the creation of two new disjoint ranges)","parameters":[]}}]}