{"vars":[{"line":134,"containerName":"","kind":2,"name":"vars"},{"name":"base","kind":2,"containerName":"","line":139},{"kind":13,"containerName":null,"name":"$FORCE_TEMP_FILE","line":146},{"line":161,"kind":12,"range":{"end":{"character":9999,"line":170},"start":{"line":161,"character":0}},"children":[{"definition":"my","line":162,"name":"$self","containerName":"_fields","localvar":"my","kind":13},{"name":"$self","containerName":"_fields","kind":13,"line":164},{"containerName":"_fields","kind":13,"name":"$self","line":166},{"containerName":"_fields","kind":13,"name":"$self","line":167},{"line":169,"name":"$self","kind":13,"containerName":"_fields"}],"containerName":"main::","name":"_fields","definition":"sub"},{"kind":12,"name":"_fields","line":164},{"line":166,"name":"_fields","kind":12},{"kind":12,"name":"_fields","line":167},{"kind":12,"name":"_fields","line":169},{"signature":{"label":"has_field($self,$desired)","documentation":"1;\n# $Id: PullParserI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PullParserI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PullParserI - A base module for fast 'pull' parsing\n\n=head1 SYNOPSIS\n\n    # do not use this class, it is intended for parser module\n    # writers only\n\n=head1 DESCRIPTION\n\nIf you are writing a module to parse some new format, you may wish to use\na 'pull' approach whereby you only do work (reading file data, parsing it,\nturning the parsed data in an object) when absolutely necessary.\n\nPullParserI provides a system for doing exactly that. As a PullParser you\nneed a chunk. A chunk is just a Bio::Root::IO that contains all the raw data\nyou would want to parse. You can use the chunk() method to create a chunk from\na filename, existing filehandle or even a string. If you make a chunk from a\nlarge file, but actually only want your chunk to be some portion of the whole\nfile, supply start and end amounts in bytes to chunk() at the same time.\nThe methods _chunk_seek() and _chunk_tell() provide seeks and tells that are\nrelative to the start and end of your chunk, not the whole file.\n\nThe other thing you will need to decide when making a chunk is how to handle\npiped input. A PullParser typically needs seekable data to parse, so if your\ndata is piped in and unseekable, you must decide between creating a temp file\nor reading the input into memory, which will be done before the chunk becomes\nusable and you can begin any parsing. Alternatively you can choose to force\na sequential read, in which case you can make use of _dependencies() to define\nthe linear order of methods that would result in the file being read\nsequentially. The return value of _sequential() is also useful here, if you\nwould need to cache some data or otherwise behave differently during a\nsequential read.\n\nThe main method in the system is get_field(). This method relies on the\nexistance of a private hash reference accessible to it with the method\n_fields(). That hash ref should have as keys all the sorts of data you will want\nto parse (eg. 'score'), and prior to parsing the values would be undefined. A\nuser of your module can then call either $module-E<gt>get_field('score') or\n$module-E<gt>score and get_field will either return the answer from\n$self-E<gt>_fields-E<gt>{score} if it is defined, or call a method _discover_score()\nfirst if not. So for the system to work you need to define a _discover_*()\nmethod for every field in the fields hash, and ensure that the method stores an\nanswer in the fields hash.\n\nHow you implement your _discover_* methods is up to you, though you should never\ncall a _discover_* method directly yourself; always use get_field(), since\nget_field() will deal with calling dependant methods for you if a forced\nsequenctial read is in progress due to piped input. You will almost certainly\nwant to make use of the various chunk-related methods of this class (that are\ndenoted private by the leading '_'; this means you can use them as the author of\na parser class, but users of your parser should not). \n\nPrimary amongst them is _*_chunk_by_end() to which you provide text that\nrepresents the end of your desired chunk and it does a readline with your\nargument as $/. The chunk knows about its line-endings, so if you want your\nend definition to include a new line, just always use \"\\n\" and PullParserI will\ndo any necessary conversion for you.\n\nIf your input data is hierarchical (eg. report-E<gt>many results-E<gt>many hits-E<gt>many\nhsps), and you want an object at the leaf of the hierarchy to have access to\ninformation that is shared amongst all of them (is parsed in the root), you\ndon't have to copy the data to each leaf object; simply by defining parent(),\nwhen you call get_field() and the requested field isn't in your leaf's fields\nhash, the leaf's parent will be asked for the field instead, and so on till\nroot.\n\nSee Bio::SearchIO::hmmer_pull for an example of implementing a parser using\nPullParserI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 CONTRIBUTORS\n\nInspired by a posting by Aaron J. Mackey\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::PullParserI;\n\nuse vars qw($AUTOLOAD $FORCE_TEMP_FILE);\nuse strict;\n\nuse Bio::Root::IO;\n\nuse base qw(Bio::Root::RootI);\n\nBEGIN {\n    # chunk() needs perl 5.8 feature for modes other than temp_file, so will\n    # workaround by forcing temp_file mode in <5.8. Could also rewrite using\n    # IO::String, but don't want to.\n    if ($] < 5.008) {\n        $FORCE_TEMP_FILE = 1;\n    }\n}\n\n=head2 _fields\n\n Title   : _fields\n Usage   : $obj->_fields( { field1 => undef } );\n           my $fields_ref = $obj->_fields;\n Function: Get/set the hash reference containing all the fields for this parser\n Returns : hash ref\n Args    : none to get, OR hash ref to set\n\n\nsub _fields {\n    my $self = shift;\n    if (@_) {\n        $self->{_fields} = shift;\n    }\n    unless (defined $self->{_fields}) {\n        $self->{_fields} = { };\n    }\n    return $self->{_fields};\n}\n\n=head2 has_field\n\n Title   : has_field\n Usage   : if ($obj->has_field('field_name') {...}\n Function: Ask if a particular object has a given field (doesn't ask ancestors)\n Returns : boolean\n Args    : string (the field name to test)","parameters":[{"label":"$self"},{"label":"$desired"}]},"range":{"start":{"line":182,"character":0},"end":{"character":9999,"line":186}},"kind":12,"line":182,"detail":"($self,$desired)","definition":"sub","name":"has_field","containerName":"main::","children":[{"definition":"my","line":183,"localvar":"my","containerName":"has_field","kind":13,"name":"$self"},{"name":"$desired","containerName":"has_field","kind":13,"line":183},{"line":184,"kind":13,"containerName":"has_field","name":"$desired"},{"line":185,"containerName":"has_field","kind":13,"name":"$self"},{"line":185,"kind":12,"containerName":"has_field","name":"_fields"},{"line":185,"kind":13,"containerName":"has_field","name":"$desired"}]},{"definition":"sub","containerName":"main::","name":"get_field","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"get_field","line":202},{"definition":"my","name":"$desired","containerName":"get_field","localvar":"my","kind":13,"line":203},{"line":203,"name":"$self","containerName":"get_field","kind":13},{"line":203,"containerName":"get_field","kind":12,"name":"_fields"}],"range":{"start":{"character":0,"line":201},"end":{"character":9999,"line":203}},"kind":12,"line":201},{"kind":13,"containerName":null,"name":"$self","line":204},{"line":204,"containerName":"main::","kind":12,"name":"_fields"},{"name":"%desired","containerName":null,"kind":13,"line":204},{"line":205,"kind":13,"containerName":null,"name":"$self"},{"line":205,"name":"_fields","kind":12,"containerName":"main::"},{"line":205,"name":"%desired","kind":13,"containerName":null},{"name":"$method","kind":13,"localvar":"my","containerName":null,"line":206,"definition":"my"},{"line":206,"name":"$desired","kind":13,"containerName":null},{"name":"$dependency","localvar":"my","kind":13,"containerName":null,"line":208,"definition":"my"},{"containerName":null,"kind":13,"name":"$self","line":208},{"line":208,"name":"_dependencies","containerName":"main::","kind":12},{"kind":13,"containerName":null,"name":"$desired","line":208},{"name":"$dependency","containerName":null,"kind":13,"line":209},{"name":"$self","containerName":null,"kind":13,"line":209},{"line":209,"kind":12,"containerName":"main::","name":"_fields"},{"kind":13,"containerName":null,"name":"%dependency","line":209},{"containerName":null,"kind":13,"name":"$self","line":210},{"line":210,"name":"get_field","containerName":"main::","kind":12},{"line":210,"kind":13,"containerName":null,"name":"$dependency"},{"line":214,"name":"$self","kind":13,"containerName":null},{"name":"$method","kind":13,"containerName":null,"line":214},{"line":214,"containerName":null,"kind":13,"name":"$self"},{"name":"_fields","containerName":"main::","kind":12,"line":214},{"line":214,"name":"$desired","kind":13,"containerName":null},{"name":"$self","kind":13,"containerName":null,"line":216},{"kind":12,"containerName":"main::","name":"_fields","line":216},{"name":"$desired","containerName":null,"kind":13,"line":216},{"definition":"my","line":220,"kind":13,"localvar":"my","containerName":null,"name":"$parent"},{"kind":13,"containerName":null,"name":"$self","line":220},{"line":220,"name":"parent","containerName":"main::","kind":12},{"name":"$parent","kind":13,"containerName":null,"line":221},{"line":221,"name":"get_field","containerName":"main::","kind":12},{"name":"$desired","kind":13,"containerName":null,"line":221},{"line":224,"name":"$desired","containerName":null,"kind":13},{"name":"$self","containerName":null,"kind":13,"line":225},{"line":225,"name":"warn","containerName":"main::","kind":12},{"line":240,"range":{"end":{"character":9999,"line":244},"start":{"character":0,"line":240}},"kind":12,"children":[{"definition":"my","kind":13,"localvar":"my","containerName":"parent","name":"$self","line":241},{"line":242,"name":"$self","kind":13,"containerName":"parent"},{"name":"$self","containerName":"parent","kind":13,"line":243}],"name":"parent","containerName":"main::","definition":"sub"},{"name":"parent","kind":12,"line":242},{"kind":12,"name":"parent","line":243},{"definition":"sub","containerName":"main::","name":"chunk","children":[{"definition":"my","line":282,"name":"$self","kind":13,"localvar":"my","containerName":"chunk"},{"definition":"my","localvar":"my","containerName":"chunk","kind":13,"name":"$thing","line":285},{"name":"$self","containerName":"chunk","kind":13,"line":285},{"name":"throw","kind":12,"containerName":"chunk","line":285},{"line":286,"name":"$thing","containerName":"chunk","kind":13},{"line":287,"name":"$self","kind":13,"containerName":"chunk"},{"line":287,"name":"new","containerName":"chunk","kind":12},{"name":"$thing","kind":13,"containerName":"chunk","line":287},{"line":289,"name":"$thing","containerName":"chunk","kind":13},{"kind":13,"containerName":"chunk","name":"$thing","line":290},{"line":290,"kind":13,"containerName":"chunk","name":"$thing"},{"kind":13,"containerName":"chunk","name":"$self","line":291},{"name":"new","containerName":"chunk","kind":12,"line":291},{"kind":13,"containerName":"chunk","name":"$thing","line":291},{"line":294,"kind":13,"containerName":"chunk","name":"$FORCE_TEMP_FILE"},{"definition":"my","kind":13,"localvar":"my","containerName":"chunk","name":"$fake_fh","line":296},{"name":"$thing","kind":13,"containerName":"chunk","line":296},{"kind":13,"containerName":"chunk","name":"$self","line":297},{"name":"new","containerName":"chunk","kind":12,"line":297},{"line":297,"containerName":"chunk","kind":13,"name":"$fake_fh"},{"definition":"my","localvar":"my","kind":13,"containerName":"chunk","name":"$handle","line":300},{"name":"$self","containerName":"chunk","kind":13,"line":300},{"containerName":"chunk","kind":12,"name":"tempfile","line":300},{"containerName":"chunk","kind":13,"name":"$handle","line":301},{"line":301,"name":"$thing","kind":13,"containerName":"chunk"},{"line":302,"containerName":"chunk","kind":13,"name":"$self"},{"line":302,"name":"new","containerName":"chunk","kind":12},{"name":"$handle","containerName":"chunk","kind":13,"line":302},{"line":306,"name":"$thing","kind":13,"containerName":"chunk"},{"line":306,"kind":12,"containerName":"chunk","name":"isa"},{"line":307,"name":"$self","containerName":"chunk","kind":13},{"name":"$thing","kind":13,"containerName":"chunk","line":307},{"line":310,"name":"$self","kind":13,"containerName":"chunk"},{"line":310,"name":"throw","kind":12,"containerName":"chunk"},{"name":"$piped_behaviour","kind":13,"localvar":"my","containerName":"chunk","line":313,"definition":"my"},{"kind":13,"containerName":"chunk","name":"$start","line":313},{"line":313,"name":"$end","kind":13,"containerName":"chunk"},{"containerName":"chunk","kind":13,"name":"$piped_behaviour","line":315},{"line":315,"name":"$start","kind":13,"containerName":"chunk"},{"name":"$end","containerName":"chunk","kind":13,"line":315},{"name":"$self","containerName":"chunk","kind":13,"line":316},{"line":316,"containerName":"chunk","kind":12,"name":"_rearrange"},{"line":318,"name":"$piped_behaviour","kind":13,"containerName":"chunk"},{"line":319,"name":"$FORCE_TEMP_FILE","kind":13,"containerName":"chunk"},{"line":319,"kind":13,"containerName":"chunk","name":"$piped_behaviour"},{"name":"$start","containerName":"chunk","kind":13,"line":320},{"name":"$self","kind":13,"containerName":"chunk","line":321},{"kind":12,"containerName":"chunk","name":"_chunk_true_start","line":321},{"line":321,"kind":13,"containerName":"chunk","name":"$start"},{"containerName":"chunk","kind":13,"name":"$self","line":322},{"line":322,"kind":12,"containerName":"chunk","name":"_chunk_true_end"},{"line":322,"kind":13,"containerName":"chunk","name":"$end"},{"kind":13,"localvar":"my","containerName":"chunk","name":"$fh","line":325,"definition":"my"},{"line":325,"kind":13,"containerName":"chunk","name":"$self"},{"line":325,"name":"_fh","kind":12,"containerName":"chunk"},{"line":326,"kind":13,"containerName":"chunk","name":"$fh"},{"name":"$first_line","localvar":"my","containerName":"chunk","kind":13,"line":327,"definition":"my"},{"containerName":"chunk","kind":13,"name":"$fh","line":327},{"kind":13,"containerName":"chunk","name":"$fh","line":328},{"line":329,"name":"$seekable","containerName":"chunk","localvar":"my","kind":13,"definition":"my"},{"line":329,"kind":13,"containerName":"chunk","name":"$fh"},{"containerName":"chunk","kind":13,"name":"$seekable","line":330},{"kind":13,"containerName":"chunk","name":"$piped_behaviour","line":331},{"definition":"my","line":332,"containerName":"chunk","localvar":"my","kind":13,"name":"$string"},{"line":332,"kind":13,"containerName":"chunk","name":"$first_line"},{"name":"$fh","kind":13,"containerName":"chunk","line":333},{"line":334,"name":"$string","containerName":"chunk","kind":13},{"line":336,"name":"$self","containerName":"chunk","kind":13},{"name":"chunk","kind":12,"containerName":"chunk","line":336},{"name":"$string","kind":13,"containerName":"chunk","line":336},{"line":338,"name":"$piped_behaviour","kind":13,"containerName":"chunk"},{"definition":"my","name":"$handle","kind":13,"localvar":"my","containerName":"chunk","line":339},{"name":"$self","kind":13,"containerName":"chunk","line":339},{"name":"tempfile","kind":12,"containerName":"chunk","line":339},{"containerName":"chunk","kind":13,"name":"$handle","line":340},{"line":340,"containerName":"chunk","kind":13,"name":"$first_line"},{"name":"$fh","kind":13,"containerName":"chunk","line":341},{"containerName":"chunk","kind":13,"name":"$handle","line":342},{"containerName":"chunk","kind":13,"name":"$handle","line":344},{"name":"$self","containerName":"chunk","kind":13,"line":345},{"line":345,"containerName":"chunk","kind":12,"name":"chunk"},{"kind":13,"containerName":"chunk","name":"$handle","line":345},{"containerName":"chunk","kind":13,"name":"$piped_behaviour","line":347},{"containerName":"chunk","kind":13,"name":"$self","line":348},{"containerName":"chunk","kind":12,"name":"_pushback","line":348},{"containerName":"chunk","kind":13,"name":"$first_line","line":348},{"line":349,"name":"$self","kind":13,"containerName":"chunk"},{"name":"_sequential","kind":12,"containerName":"chunk","line":349},{"containerName":"chunk","kind":13,"name":"$self","line":352},{"line":352,"kind":12,"containerName":"chunk","name":"throw"},{"kind":13,"containerName":"chunk","name":"$first_line","line":357},{"line":358,"kind":13,"containerName":"chunk","name":"$self"},{"kind":12,"containerName":"chunk","name":"_line_ending","line":358},{"kind":13,"containerName":"chunk","name":"$first_line","line":360},{"kind":13,"containerName":"chunk","name":"$self","line":361},{"kind":12,"containerName":"chunk","name":"_line_ending","line":361},{"line":364,"containerName":"chunk","kind":13,"name":"$self"},{"line":364,"name":"_line_ending","kind":12,"containerName":"chunk"},{"name":"$self","containerName":"chunk","kind":13,"line":368}],"range":{"start":{"line":281,"character":0},"end":{"character":9999,"line":369}},"kind":12,"line":281},{"kind":12,"name":"_chunk","line":287},{"line":287,"name":"Bio","kind":12,"containerName":"Root::IO"},{"name":"_chunk","kind":12,"line":291},{"containerName":"Root::IO","kind":12,"name":"Bio","line":291},{"line":297,"kind":12,"name":"_chunk"},{"line":297,"kind":12,"containerName":"Root::IO","name":"Bio"},{"line":300,"kind":12,"name":"_chunk"},{"line":302,"name":"_chunk","kind":12},{"containerName":"Root::IO","kind":12,"name":"Bio","line":302},{"line":307,"kind":12,"name":"_chunk"},{"kind":12,"name":"_chunk","line":325},{"kind":12,"name":"_chunk","line":339},{"name":"_chunk","kind":12,"line":348},{"name":"_chunk","kind":12,"line":368},{"definition":"sub","children":[{"definition":"my","name":"$self","containerName":"_sequential","localvar":"my","kind":13,"line":384},{"name":"$self","kind":13,"containerName":"_sequential","line":386},{"line":388,"name":"$self","kind":13,"containerName":"_sequential"}],"name":"_sequential","containerName":"main::","line":383,"range":{"start":{"line":383,"character":0},"end":{"line":389,"character":9999}},"kind":12},{"line":386,"kind":12,"name":"_sequential"},{"line":388,"kind":12,"name":"_sequential"},{"name":"_dependencies","containerName":"main::","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"_dependencies","line":406},{"name":"$thing","kind":13,"containerName":"_dependencies","line":406},{"containerName":"_dependencies","kind":13,"name":"$thing","line":407},{"name":"$thing","kind":13,"containerName":"_dependencies","line":408},{"name":"$self","kind":13,"containerName":"_dependencies","line":409},{"name":"$thing","containerName":"_dependencies","kind":13,"line":409},{"name":"$self","kind":13,"containerName":"_dependencies","line":412},{"line":412,"name":"$thing","containerName":"_dependencies","kind":13}],"detail":"($self,$thing)","definition":"sub","kind":12,"range":{"start":{"line":405,"character":0},"end":{"character":9999,"line":414}},"line":405,"signature":{"label":"_dependencies($self,$thing)","documentation":"1;\n# $Id: PullParserI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PullParserI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PullParserI - A base module for fast 'pull' parsing\n\n=head1 SYNOPSIS\n\n    # do not use this class, it is intended for parser module\n    # writers only\n\n=head1 DESCRIPTION\n\nIf you are writing a module to parse some new format, you may wish to use\na 'pull' approach whereby you only do work (reading file data, parsing it,\nturning the parsed data in an object) when absolutely necessary.\n\nPullParserI provides a system for doing exactly that. As a PullParser you\nneed a chunk. A chunk is just a Bio::Root::IO that contains all the raw data\nyou would want to parse. You can use the chunk() method to create a chunk from\na filename, existing filehandle or even a string. If you make a chunk from a\nlarge file, but actually only want your chunk to be some portion of the whole\nfile, supply start and end amounts in bytes to chunk() at the same time.\nThe methods _chunk_seek() and _chunk_tell() provide seeks and tells that are\nrelative to the start and end of your chunk, not the whole file.\n\nThe other thing you will need to decide when making a chunk is how to handle\npiped input. A PullParser typically needs seekable data to parse, so if your\ndata is piped in and unseekable, you must decide between creating a temp file\nor reading the input into memory, which will be done before the chunk becomes\nusable and you can begin any parsing. Alternatively you can choose to force\na sequential read, in which case you can make use of _dependencies() to define\nthe linear order of methods that would result in the file being read\nsequentially. The return value of _sequential() is also useful here, if you\nwould need to cache some data or otherwise behave differently during a\nsequential read.\n\nThe main method in the system is get_field(). This method relies on the\nexistance of a private hash reference accessible to it with the method\n_fields(). That hash ref should have as keys all the sorts of data you will want\nto parse (eg. 'score'), and prior to parsing the values would be undefined. A\nuser of your module can then call either $module-E<gt>get_field('score') or\n$module-E<gt>score and get_field will either return the answer from\n$self-E<gt>_fields-E<gt>{score} if it is defined, or call a method _discover_score()\nfirst if not. So for the system to work you need to define a _discover_*()\nmethod for every field in the fields hash, and ensure that the method stores an\nanswer in the fields hash.\n\nHow you implement your _discover_* methods is up to you, though you should never\ncall a _discover_* method directly yourself; always use get_field(), since\nget_field() will deal with calling dependant methods for you if a forced\nsequenctial read is in progress due to piped input. You will almost certainly\nwant to make use of the various chunk-related methods of this class (that are\ndenoted private by the leading '_'; this means you can use them as the author of\na parser class, but users of your parser should not). \n\nPrimary amongst them is _*_chunk_by_end() to which you provide text that\nrepresents the end of your desired chunk and it does a readline with your\nargument as $/. The chunk knows about its line-endings, so if you want your\nend definition to include a new line, just always use \"\\n\" and PullParserI will\ndo any necessary conversion for you.\n\nIf your input data is hierarchical (eg. report-E<gt>many results-E<gt>many hits-E<gt>many\nhsps), and you want an object at the leaf of the hierarchy to have access to\ninformation that is shared amongst all of them (is parsed in the root), you\ndon't have to copy the data to each leaf object; simply by defining parent(),\nwhen you call get_field() and the requested field isn't in your leaf's fields\nhash, the leaf's parent will be asked for the field instead, and so on till\nroot.\n\nSee Bio::SearchIO::hmmer_pull for an example of implementing a parser using\nPullParserI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 CONTRIBUTORS\n\nInspired by a posting by Aaron J. Mackey\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::PullParserI;\n\nuse vars qw($AUTOLOAD $FORCE_TEMP_FILE);\nuse strict;\n\nuse Bio::Root::IO;\n\nuse base qw(Bio::Root::RootI);\n\nBEGIN {\n    # chunk() needs perl 5.8 feature for modes other than temp_file, so will\n    # workaround by forcing temp_file mode in <5.8. Could also rewrite using\n    # IO::String, but don't want to.\n    if ($] < 5.008) {\n        $FORCE_TEMP_FILE = 1;\n    }\n}\n\n=head2 _fields\n\n Title   : _fields\n Usage   : $obj->_fields( { field1 => undef } );\n           my $fields_ref = $obj->_fields;\n Function: Get/set the hash reference containing all the fields for this parser\n Returns : hash ref\n Args    : none to get, OR hash ref to set\n\n\nsub _fields {\n    my $self = shift;\n    if (@_) {\n        $self->{_fields} = shift;\n    }\n    unless (defined $self->{_fields}) {\n        $self->{_fields} = { };\n    }\n    return $self->{_fields};\n}\n\n=head2 has_field\n\n Title   : has_field\n Usage   : if ($obj->has_field('field_name') {...}\n Function: Ask if a particular object has a given field (doesn't ask ancestors)\n Returns : boolean\n Args    : string (the field name to test)\n\n\nsub has_field {\n    my ($self, $desired) = @_;\n    $desired || return;\n    return exists $self->_fields->{$desired};\n}\n\n=head2 get_field\n\n Title   : get_field\n Usage   : my $field_value = $obj->get_field('field_name');\n Function: Get the value of a given field. If this $obj doesn't have the field,\n           it's parent() will be asked, and so on until there are no more\n           parents.\n Returns : scalar, warns if a value for the field couldn't be found and returns\n           undef.\n Args    : string (the field to get)\n\n\nsub get_field {\n    my $self = shift;\n    my $desired = shift || return keys %{$self->_fields};\n    if (exists $self->_fields->{$desired}) {\n        unless (defined $self->_fields->{$desired}) {\n            my $method = '_discover_'.$desired;\n            \n            my $dependency = $self->_dependencies($desired);\n            if ($dependency && ! defined $self->_fields->{$dependency}) {\n                $self->get_field($dependency);\n            }\n            \n            # it might exist now\n            $self->$method unless defined $self->_fields->{$desired};\n        }\n        return $self->_fields->{$desired};\n    }\n    \n    # is it a field of our parent? (checks all ancestors)\n    if (my $parent = $self->parent) {\n        return $parent->get_field($desired);\n    }\n    \n    $desired =~ s/_discover_//;\n    $self->warn(\"This report does not hold information about '$desired'\");\n    return;\n}\n\n=head2 parent\n\n Title   : parent\n Usage   : $obj->parent($parent_obj);\n           my $parent_obj = $obj->parent;\n Function: Get/set the parent object of this one.\n Returns : Bio::PullParserI\n Args    : none to get, OR Bio::PullParserI to set\n\n\nsub parent {\n    my $self = shift;\n    if (@_) { $self->{parent} = shift }\n    return $self->{parent} || return;\n}\n\n=head2 chunk\n\n Title   : chunk\n Usage   : $obj->chunk($filename);\n           my $chunk = $obj->chunk;\n Function: Get/set the chunk of this parser.\n Returns : Bio:Root::IO\n Args    : none to get, OR\n           First argument of a GLOB reference, filename string, string data to\n           treat as the chunk, or Bio::Root::IO.\n           Optionally, also provide:\n           -start => int : the byte position within the thing described by the\n                           first arguement to consider as the start of this\n                           chunk (default 0)\n           -end   => int : the byte position to consider as the end (default\n                           true end)\n           -piped_behaviour => 'memory'|'temp_file'|'sequential_read'\n\n           The last option comes into effect when the first argument is\n           something that cannot be seeked (eg. piped input filehandle).\n            'memory'          means read all the piped input into a string\n                              first, then set the chunk to that string.\n            'temp_file'       means read all the piped input and output it to\n                              a temp file, then set the chunk to that temp file.\n            'sequential_read' means that the piped input should be read\n                              sequentially and your parsing code must cope with\n                              not being able to seek.\n           'memory' is the fastest but uses the most memory. 'temp_file' and\n           'sequential_read' can be slow, with 'temp_file' being the most memory\n           efficient but requiring disc space. The default is 'sequential_read'.\n           Note that in versions of perl earlier than 5.8 only temp_file works\n           and will be used regardless of what value is supplied here.\n\n\nsub chunk {\n    my $self = shift;\n    \n    if (@_) {\n        my $thing = shift || $self->throw(\"Trying to set chunk() to an undefined value\");\n        if (ref($thing) eq 'GLOB') {\n            $self->{_chunk} = Bio::Root::IO->new(-fh => $thing);\n        }\n        elsif (ref(\\$thing) eq 'SCALAR') {\n            if ($thing !~ /\\n/ && -e $thing) {\n                $self->{_chunk} = Bio::Root::IO->new(-file => $thing);\n            }\n            else {\n                unless ($FORCE_TEMP_FILE) {\n                    # treat a string as a filehandle\n                    open(my $fake_fh, \"+<\", \\$thing); # requires perl 5.8\n                    $self->{_chunk} = Bio::Root::IO->new(-fh => $fake_fh);\n                }\n                else {\n                    my ($handle) = $self->{_chunk}->tempfile();\n                    print $handle $thing;\n                    $self->{_chunk} = Bio::Root::IO->new(-fh => $handle);\n                }\n            }\n        }\n        elsif ($thing->isa('Bio::Root::IO')) {\n            $self->{_chunk} = $thing;\n        }\n        else {\n            $self->throw(\"Unknown input into chunk()\");\n        }\n        \n        my ($piped_behaviour, $start, $end);\n        if (@_) {\n            ($piped_behaviour, $start, $end) =\n                $self->_rearrange([qw(PIPED_BEHAVIOUR START END)], @_);\n        }\n        $piped_behaviour ||= 'sequential_read';\n        $FORCE_TEMP_FILE && ($piped_behaviour = 'temp_file');\n        $start ||= 0;\n        $self->_chunk_true_start($start);\n        $self->_chunk_true_end($end);\n        \n        # determine if the chunk is seekable\n        my $fh = $self->{_chunk}->_fh;\n        seek($fh, 0, 0);\n        my $first_line = <$fh>;\n        seek($fh, 0, 0);\n        my $seekable = tell($fh) == 0;\n        unless ($seekable) {\n            if ($piped_behaviour eq 'memory') {\n                my $string = $first_line;\n                while (<$fh>) {\n                    $string .= $_;\n                }\n                $self->chunk($string);\n            }\n            elsif ($piped_behaviour eq 'temp_file') {\n                my ($handle) = $self->{_chunk}->tempfile();\n                print $handle $first_line;\n                while (<$fh>) {\n                    print $handle $_;\n                }\n                seek($handle, 0, 0);\n                $self->chunk($handle);\n            }\n            elsif ($piped_behaviour eq 'sequential_read') {\n                $self->{_chunk}->_pushback($first_line);\n                $self->_sequential(1);\n            }\n            else {\n                $self->throw(\"Unknown piped behaviour type '$piped_behaviour'\");\n            }\n        }\n        \n        # determine our line ending\n        if ($first_line =~ /\\r\\n/) {\n            $self->_line_ending(\"\\r\\n\");\n        }\n        elsif ($first_line =~ /\\r/) {\n            $self->_line_ending(\"\\r\");\n        }\n        else {\n            $self->_line_ending(\"\\n\");\n        }\n    }\n    \n    return $self->{_chunk} || return;\n}\n\n=head2 _sequential\n\n Title   : _sequential\n Usage   : if ($obj->_sequential) {...}\n Function: Ask if we have to do operations such that the input is read\n           sequentially.\n Returns : boolean\n Args    : none to get, OR boolean to set (typically, you should never set this\n           yourself)\n\n\nsub _sequential {\n    my $self = shift;\n    if (@_) {\n        $self->{_sequential} = shift;\n    }\n    return $self->{_sequential} || 0;\n}\n\n=head2 _dependencies\n\n Title   : _dependencies\n Usage   : $obj->_dependencies( { field1 => field2 } );\n           my $dependancy = $obj->_dependencies('field_name');\n Function: Set the fields that are dependent on each other, or get the field\n           than another is dependent upon.\n Returns : string (a field name)\n Args    : string (a field name) to get, OR hash ref to initially set, with\n           field names as keys and values, key field being dependent upon value\n           field.","parameters":[{"label":"$self"},{"label":"$thing"}]}},{"line":409,"name":"_dependencies","kind":12},{"kind":12,"name":"_dependencies","line":412},{"children":[{"definition":"my","line":428,"name":"$self","localvar":"my","kind":13,"containerName":"_chunk_true_start"},{"name":"$self","kind":13,"containerName":"_chunk_true_start","line":430},{"name":"$self","containerName":"_chunk_true_start","kind":13,"line":432}],"containerName":"main::","name":"_chunk_true_start","definition":"sub","line":427,"kind":12,"range":{"start":{"character":0,"line":427},"end":{"character":9999,"line":433}}},{"name":"_chunk_start","kind":12,"line":430},{"name":"_chunk_start","kind":12,"line":432},{"line":446,"range":{"end":{"character":9999,"line":452},"start":{"character":0,"line":446}},"kind":12,"definition":"sub","children":[{"definition":"my","line":447,"containerName":"_chunk_true_end","localvar":"my","kind":13,"name":"$self"},{"line":449,"name":"$self","containerName":"_chunk_true_end","kind":13},{"line":451,"name":"$self","containerName":"_chunk_true_end","kind":13}],"containerName":"main::","name":"_chunk_true_end"},{"line":449,"name":"_chunk_end","kind":12},{"kind":12,"name":"_chunk_end","line":451},{"name":"_line_ending","containerName":"main::","children":[{"line":466,"localvar":"my","containerName":"_line_ending","kind":13,"name":"$self","definition":"my"},{"containerName":"_line_ending","kind":13,"name":"$self","line":468},{"line":470,"containerName":"_line_ending","kind":13,"name":"$self"}],"definition":"sub","range":{"end":{"character":9999,"line":471},"start":{"character":0,"line":465}},"kind":12,"line":465},{"name":"_chunk_line_ending","kind":12,"line":468},{"line":470,"name":"_chunk_line_ending","kind":12},{"name":"_chunk_seek","containerName":"main::","children":[{"definition":"my","line":488,"name":"$self","kind":13,"localvar":"my","containerName":"_chunk_seek"},{"kind":13,"containerName":"_chunk_seek","name":"$pos","line":488},{"name":"$self","kind":13,"containerName":"_chunk_seek","line":489},{"containerName":"_chunk_seek","kind":12,"name":"_sequential","line":489},{"line":491,"name":"$fh","localvar":"my","kind":13,"containerName":"_chunk_seek","definition":"my"},{"line":491,"containerName":"_chunk_seek","kind":13,"name":"$self"},{"line":491,"containerName":"_chunk_seek","kind":12,"name":"chunk"},{"kind":12,"containerName":"_chunk_seek","name":"_fh","line":491},{"name":"$fh","containerName":"_chunk_seek","kind":13,"line":494},{"name":"$self","kind":13,"containerName":"_chunk_seek","line":494},{"containerName":"_chunk_seek","kind":12,"name":"_chunk_true_start","line":494},{"name":"$fh","kind":13,"containerName":"_chunk_seek","line":497},{"line":497,"containerName":"_chunk_seek","kind":13,"name":"$pos"}],"detail":"($self,$pos)","definition":"sub","kind":12,"range":{"start":{"character":0,"line":487},"end":{"line":498,"character":9999}},"line":487,"signature":{"documentation":"1;\n# $Id: PullParserI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PullParserI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PullParserI - A base module for fast 'pull' parsing\n\n=head1 SYNOPSIS\n\n    # do not use this class, it is intended for parser module\n    # writers only\n\n=head1 DESCRIPTION\n\nIf you are writing a module to parse some new format, you may wish to use\na 'pull' approach whereby you only do work (reading file data, parsing it,\nturning the parsed data in an object) when absolutely necessary.\n\nPullParserI provides a system for doing exactly that. As a PullParser you\nneed a chunk. A chunk is just a Bio::Root::IO that contains all the raw data\nyou would want to parse. You can use the chunk() method to create a chunk from\na filename, existing filehandle or even a string. If you make a chunk from a\nlarge file, but actually only want your chunk to be some portion of the whole\nfile, supply start and end amounts in bytes to chunk() at the same time.\nThe methods _chunk_seek() and _chunk_tell() provide seeks and tells that are\nrelative to the start and end of your chunk, not the whole file.\n\nThe other thing you will need to decide when making a chunk is how to handle\npiped input. A PullParser typically needs seekable data to parse, so if your\ndata is piped in and unseekable, you must decide between creating a temp file\nor reading the input into memory, which will be done before the chunk becomes\nusable and you can begin any parsing. Alternatively you can choose to force\na sequential read, in which case you can make use of _dependencies() to define\nthe linear order of methods that would result in the file being read\nsequentially. The return value of _sequential() is also useful here, if you\nwould need to cache some data or otherwise behave differently during a\nsequential read.\n\nThe main method in the system is get_field(). This method relies on the\nexistance of a private hash reference accessible to it with the method\n_fields(). That hash ref should have as keys all the sorts of data you will want\nto parse (eg. 'score'), and prior to parsing the values would be undefined. A\nuser of your module can then call either $module-E<gt>get_field('score') or\n$module-E<gt>score and get_field will either return the answer from\n$self-E<gt>_fields-E<gt>{score} if it is defined, or call a method _discover_score()\nfirst if not. So for the system to work you need to define a _discover_*()\nmethod for every field in the fields hash, and ensure that the method stores an\nanswer in the fields hash.\n\nHow you implement your _discover_* methods is up to you, though you should never\ncall a _discover_* method directly yourself; always use get_field(), since\nget_field() will deal with calling dependant methods for you if a forced\nsequenctial read is in progress due to piped input. You will almost certainly\nwant to make use of the various chunk-related methods of this class (that are\ndenoted private by the leading '_'; this means you can use them as the author of\na parser class, but users of your parser should not). \n\nPrimary amongst them is _*_chunk_by_end() to which you provide text that\nrepresents the end of your desired chunk and it does a readline with your\nargument as $/. The chunk knows about its line-endings, so if you want your\nend definition to include a new line, just always use \"\\n\" and PullParserI will\ndo any necessary conversion for you.\n\nIf your input data is hierarchical (eg. report-E<gt>many results-E<gt>many hits-E<gt>many\nhsps), and you want an object at the leaf of the hierarchy to have access to\ninformation that is shared amongst all of them (is parsed in the root), you\ndon't have to copy the data to each leaf object; simply by defining parent(),\nwhen you call get_field() and the requested field isn't in your leaf's fields\nhash, the leaf's parent will be asked for the field instead, and so on till\nroot.\n\nSee Bio::SearchIO::hmmer_pull for an example of implementing a parser using\nPullParserI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 CONTRIBUTORS\n\nInspired by a posting by Aaron J. Mackey\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::PullParserI;\n\nuse vars qw($AUTOLOAD $FORCE_TEMP_FILE);\nuse strict;\n\nuse Bio::Root::IO;\n\nuse base qw(Bio::Root::RootI);\n\nBEGIN {\n    # chunk() needs perl 5.8 feature for modes other than temp_file, so will\n    # workaround by forcing temp_file mode in <5.8. Could also rewrite using\n    # IO::String, but don't want to.\n    if ($] < 5.008) {\n        $FORCE_TEMP_FILE = 1;\n    }\n}\n\n=head2 _fields\n\n Title   : _fields\n Usage   : $obj->_fields( { field1 => undef } );\n           my $fields_ref = $obj->_fields;\n Function: Get/set the hash reference containing all the fields for this parser\n Returns : hash ref\n Args    : none to get, OR hash ref to set\n\n\nsub _fields {\n    my $self = shift;\n    if (@_) {\n        $self->{_fields} = shift;\n    }\n    unless (defined $self->{_fields}) {\n        $self->{_fields} = { };\n    }\n    return $self->{_fields};\n}\n\n=head2 has_field\n\n Title   : has_field\n Usage   : if ($obj->has_field('field_name') {...}\n Function: Ask if a particular object has a given field (doesn't ask ancestors)\n Returns : boolean\n Args    : string (the field name to test)\n\n\nsub has_field {\n    my ($self, $desired) = @_;\n    $desired || return;\n    return exists $self->_fields->{$desired};\n}\n\n=head2 get_field\n\n Title   : get_field\n Usage   : my $field_value = $obj->get_field('field_name');\n Function: Get the value of a given field. If this $obj doesn't have the field,\n           it's parent() will be asked, and so on until there are no more\n           parents.\n Returns : scalar, warns if a value for the field couldn't be found and returns\n           undef.\n Args    : string (the field to get)\n\n\nsub get_field {\n    my $self = shift;\n    my $desired = shift || return keys %{$self->_fields};\n    if (exists $self->_fields->{$desired}) {\n        unless (defined $self->_fields->{$desired}) {\n            my $method = '_discover_'.$desired;\n            \n            my $dependency = $self->_dependencies($desired);\n            if ($dependency && ! defined $self->_fields->{$dependency}) {\n                $self->get_field($dependency);\n            }\n            \n            # it might exist now\n            $self->$method unless defined $self->_fields->{$desired};\n        }\n        return $self->_fields->{$desired};\n    }\n    \n    # is it a field of our parent? (checks all ancestors)\n    if (my $parent = $self->parent) {\n        return $parent->get_field($desired);\n    }\n    \n    $desired =~ s/_discover_//;\n    $self->warn(\"This report does not hold information about '$desired'\");\n    return;\n}\n\n=head2 parent\n\n Title   : parent\n Usage   : $obj->parent($parent_obj);\n           my $parent_obj = $obj->parent;\n Function: Get/set the parent object of this one.\n Returns : Bio::PullParserI\n Args    : none to get, OR Bio::PullParserI to set\n\n\nsub parent {\n    my $self = shift;\n    if (@_) { $self->{parent} = shift }\n    return $self->{parent} || return;\n}\n\n=head2 chunk\n\n Title   : chunk\n Usage   : $obj->chunk($filename);\n           my $chunk = $obj->chunk;\n Function: Get/set the chunk of this parser.\n Returns : Bio:Root::IO\n Args    : none to get, OR\n           First argument of a GLOB reference, filename string, string data to\n           treat as the chunk, or Bio::Root::IO.\n           Optionally, also provide:\n           -start => int : the byte position within the thing described by the\n                           first arguement to consider as the start of this\n                           chunk (default 0)\n           -end   => int : the byte position to consider as the end (default\n                           true end)\n           -piped_behaviour => 'memory'|'temp_file'|'sequential_read'\n\n           The last option comes into effect when the first argument is\n           something that cannot be seeked (eg. piped input filehandle).\n            'memory'          means read all the piped input into a string\n                              first, then set the chunk to that string.\n            'temp_file'       means read all the piped input and output it to\n                              a temp file, then set the chunk to that temp file.\n            'sequential_read' means that the piped input should be read\n                              sequentially and your parsing code must cope with\n                              not being able to seek.\n           'memory' is the fastest but uses the most memory. 'temp_file' and\n           'sequential_read' can be slow, with 'temp_file' being the most memory\n           efficient but requiring disc space. The default is 'sequential_read'.\n           Note that in versions of perl earlier than 5.8 only temp_file works\n           and will be used regardless of what value is supplied here.\n\n\nsub chunk {\n    my $self = shift;\n    \n    if (@_) {\n        my $thing = shift || $self->throw(\"Trying to set chunk() to an undefined value\");\n        if (ref($thing) eq 'GLOB') {\n            $self->{_chunk} = Bio::Root::IO->new(-fh => $thing);\n        }\n        elsif (ref(\\$thing) eq 'SCALAR') {\n            if ($thing !~ /\\n/ && -e $thing) {\n                $self->{_chunk} = Bio::Root::IO->new(-file => $thing);\n            }\n            else {\n                unless ($FORCE_TEMP_FILE) {\n                    # treat a string as a filehandle\n                    open(my $fake_fh, \"+<\", \\$thing); # requires perl 5.8\n                    $self->{_chunk} = Bio::Root::IO->new(-fh => $fake_fh);\n                }\n                else {\n                    my ($handle) = $self->{_chunk}->tempfile();\n                    print $handle $thing;\n                    $self->{_chunk} = Bio::Root::IO->new(-fh => $handle);\n                }\n            }\n        }\n        elsif ($thing->isa('Bio::Root::IO')) {\n            $self->{_chunk} = $thing;\n        }\n        else {\n            $self->throw(\"Unknown input into chunk()\");\n        }\n        \n        my ($piped_behaviour, $start, $end);\n        if (@_) {\n            ($piped_behaviour, $start, $end) =\n                $self->_rearrange([qw(PIPED_BEHAVIOUR START END)], @_);\n        }\n        $piped_behaviour ||= 'sequential_read';\n        $FORCE_TEMP_FILE && ($piped_behaviour = 'temp_file');\n        $start ||= 0;\n        $self->_chunk_true_start($start);\n        $self->_chunk_true_end($end);\n        \n        # determine if the chunk is seekable\n        my $fh = $self->{_chunk}->_fh;\n        seek($fh, 0, 0);\n        my $first_line = <$fh>;\n        seek($fh, 0, 0);\n        my $seekable = tell($fh) == 0;\n        unless ($seekable) {\n            if ($piped_behaviour eq 'memory') {\n                my $string = $first_line;\n                while (<$fh>) {\n                    $string .= $_;\n                }\n                $self->chunk($string);\n            }\n            elsif ($piped_behaviour eq 'temp_file') {\n                my ($handle) = $self->{_chunk}->tempfile();\n                print $handle $first_line;\n                while (<$fh>) {\n                    print $handle $_;\n                }\n                seek($handle, 0, 0);\n                $self->chunk($handle);\n            }\n            elsif ($piped_behaviour eq 'sequential_read') {\n                $self->{_chunk}->_pushback($first_line);\n                $self->_sequential(1);\n            }\n            else {\n                $self->throw(\"Unknown piped behaviour type '$piped_behaviour'\");\n            }\n        }\n        \n        # determine our line ending\n        if ($first_line =~ /\\r\\n/) {\n            $self->_line_ending(\"\\r\\n\");\n        }\n        elsif ($first_line =~ /\\r/) {\n            $self->_line_ending(\"\\r\");\n        }\n        else {\n            $self->_line_ending(\"\\n\");\n        }\n    }\n    \n    return $self->{_chunk} || return;\n}\n\n=head2 _sequential\n\n Title   : _sequential\n Usage   : if ($obj->_sequential) {...}\n Function: Ask if we have to do operations such that the input is read\n           sequentially.\n Returns : boolean\n Args    : none to get, OR boolean to set (typically, you should never set this\n           yourself)\n\n\nsub _sequential {\n    my $self = shift;\n    if (@_) {\n        $self->{_sequential} = shift;\n    }\n    return $self->{_sequential} || 0;\n}\n\n=head2 _dependencies\n\n Title   : _dependencies\n Usage   : $obj->_dependencies( { field1 => field2 } );\n           my $dependancy = $obj->_dependencies('field_name');\n Function: Set the fields that are dependent on each other, or get the field\n           than another is dependent upon.\n Returns : string (a field name)\n Args    : string (a field name) to get, OR hash ref to initially set, with\n           field names as keys and values, key field being dependent upon value\n           field.\n\n\nsub _dependencies {\n    my ($self, $thing) = @_;\n    $thing || return;\n    if (ref($thing) eq 'HASH') {\n        $self->{_dependencies} = $thing;\n    }\n    else {\n        return $self->{_dependencies}->{$thing};\n    }\n}\n\n=head2 _chunk_true_start\n\n Title   : _chunk_true_start\n Usage   : my $true_start = $obj->_chunk_true_start;\n Function: Get/set the true start position of the chunk within the filehandle\n           it is part of.\n Returns : int\n Args    : none to get, OR int to set (typically, you won't set this yourself)\n\n\nsub _chunk_true_start {\n    my $self = shift;\n    if (@_) {\n        $self->{_chunk_start} = shift;\n    }\n    return $self->{_chunk_start} || 0;\n}\n\n=head2 _chunk_true_end\n\n Title   : _chunk_true_end\n Usage   : my $true_end = $obj->_chunk_true_end;\n Function: Get/set for the true end position of the chunk within the filehandle\n           it is part of.\n Returns : int\n Args    : none to get, OR int to set (typically, you won't set this yourself)\n\n\nsub _chunk_true_end {\n    my $self = shift;\n    if (@_) {\n        $self->{_chunk_end} = shift;\n    }\n    return $self->{_chunk_end};\n}\n\n=head2 _line_ending\n\n Title   : _line_ending\n Usage   : my $line_ending = $obj->_line_ending;\n Function: Get/set for the line ending for the chunk.\n Returns : string\n Args    : none to get, OR string to set (typically, you won't set this\n           yourself)\n\n\nsub _line_ending {\n    my $self = shift;\n    if (@_) {\n        $self->{_chunk_line_ending} = shift;\n    }\n    return $self->{_chunk_line_ending};\n}\n\n=head2 _chunk_seek\n\n Title   : _chunk_seek\n Usage   : $obj->_chunk_seek($pos);\n Function: seek() the chunk to the provided position in bytes, relative to the\n           defined start of the chunk within its filehandle.\n\n           In _sequential() mode, this function does nothing.\n\n Returns : n/a\n Args    : int","parameters":[{"label":"$self"},{"label":"$pos"}],"label":"_chunk_seek($self,$pos)"}},{"line":514,"range":{"start":{"line":514,"character":0},"end":{"line":520,"character":9999}},"kind":12,"definition":"sub","children":[{"name":"$self","localvar":"my","containerName":"_chunk_tell","kind":13,"line":515,"definition":"my"},{"name":"$self","containerName":"_chunk_tell","kind":13,"line":516},{"name":"_sequential","containerName":"_chunk_tell","kind":12,"line":516},{"line":518,"kind":13,"localvar":"my","containerName":"_chunk_tell","name":"$fh","definition":"my"},{"name":"$self","containerName":"_chunk_tell","kind":13,"line":518},{"line":518,"name":"chunk","kind":12,"containerName":"_chunk_tell"},{"line":518,"name":"_fh","containerName":"_chunk_tell","kind":12},{"line":519,"name":"$fh","containerName":"_chunk_tell","kind":13},{"containerName":"_chunk_tell","kind":13,"name":"$self","line":519},{"line":519,"name":"_chunk_true_start","kind":12,"containerName":"_chunk_tell"}],"name":"_chunk_tell","containerName":"main::"},{"detail":"($self,$nol)","definition":"sub","containerName":"main::","name":"_get_chunk_by_nol","children":[{"definition":"my","line":534,"name":"$self","localvar":"my","containerName":"_get_chunk_by_nol","kind":13},{"line":534,"name":"$nol","containerName":"_get_chunk_by_nol","kind":13},{"name":"$nol","kind":13,"containerName":"_get_chunk_by_nol","line":535},{"line":535,"name":"$self","containerName":"_get_chunk_by_nol","kind":13},{"containerName":"_get_chunk_by_nol","kind":12,"name":"throw","line":535},{"line":539,"name":"$line","containerName":"_get_chunk_by_nol","localvar":"my","kind":13,"definition":"my"},{"name":"$count","kind":13,"containerName":"_get_chunk_by_nol","line":539},{"containerName":"_get_chunk_by_nol","kind":13,"name":"$self","line":540},{"line":540,"kind":12,"containerName":"_get_chunk_by_nol","name":"chunk"},{"line":540,"name":"_readline","containerName":"_get_chunk_by_nol","kind":12},{"name":"$line","kind":13,"containerName":"_get_chunk_by_nol","line":541},{"line":542,"kind":13,"containerName":"_get_chunk_by_nol","name":"$count"},{"name":"$count","kind":13,"containerName":"_get_chunk_by_nol","line":543},{"line":543,"name":"$nol","kind":13,"containerName":"_get_chunk_by_nol"},{"line":546,"kind":13,"localvar":"my","containerName":"_get_chunk_by_nol","name":"$current","definition":"my"},{"name":"$self","containerName":"_get_chunk_by_nol","kind":13,"line":546},{"name":"_chunk_tell","containerName":"_get_chunk_by_nol","kind":12,"line":546},{"definition":"my","name":"$end","containerName":"_get_chunk_by_nol","localvar":"my","kind":13,"line":547},{"name":"$current","containerName":"_get_chunk_by_nol","kind":13,"line":547},{"line":547,"name":"$self","kind":13,"containerName":"_get_chunk_by_nol"},{"line":547,"name":"_chunk_true_start","containerName":"_get_chunk_by_nol","kind":12},{"line":548,"containerName":"_get_chunk_by_nol","kind":13,"name":"$current"},{"containerName":"_get_chunk_by_nol","kind":13,"name":"$self","line":548},{"containerName":"_get_chunk_by_nol","kind":12,"name":"_chunk_true_end","line":548},{"name":"$end","containerName":"_get_chunk_by_nol","kind":13,"line":548},{"line":548,"containerName":"_get_chunk_by_nol","kind":13,"name":"$self"},{"containerName":"_get_chunk_by_nol","kind":12,"name":"_chunk_true_end","line":548},{"kind":13,"containerName":"_get_chunk_by_nol","name":"$line","line":549}],"signature":{"parameters":[{"label":"$self"},{"label":"$nol"}],"documentation":"1;\n# $Id: PullParserI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PullParserI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PullParserI - A base module for fast 'pull' parsing\n\n=head1 SYNOPSIS\n\n    # do not use this class, it is intended for parser module\n    # writers only\n\n=head1 DESCRIPTION\n\nIf you are writing a module to parse some new format, you may wish to use\na 'pull' approach whereby you only do work (reading file data, parsing it,\nturning the parsed data in an object) when absolutely necessary.\n\nPullParserI provides a system for doing exactly that. As a PullParser you\nneed a chunk. A chunk is just a Bio::Root::IO that contains all the raw data\nyou would want to parse. You can use the chunk() method to create a chunk from\na filename, existing filehandle or even a string. If you make a chunk from a\nlarge file, but actually only want your chunk to be some portion of the whole\nfile, supply start and end amounts in bytes to chunk() at the same time.\nThe methods _chunk_seek() and _chunk_tell() provide seeks and tells that are\nrelative to the start and end of your chunk, not the whole file.\n\nThe other thing you will need to decide when making a chunk is how to handle\npiped input. A PullParser typically needs seekable data to parse, so if your\ndata is piped in and unseekable, you must decide between creating a temp file\nor reading the input into memory, which will be done before the chunk becomes\nusable and you can begin any parsing. Alternatively you can choose to force\na sequential read, in which case you can make use of _dependencies() to define\nthe linear order of methods that would result in the file being read\nsequentially. The return value of _sequential() is also useful here, if you\nwould need to cache some data or otherwise behave differently during a\nsequential read.\n\nThe main method in the system is get_field(). This method relies on the\nexistance of a private hash reference accessible to it with the method\n_fields(). That hash ref should have as keys all the sorts of data you will want\nto parse (eg. 'score'), and prior to parsing the values would be undefined. A\nuser of your module can then call either $module-E<gt>get_field('score') or\n$module-E<gt>score and get_field will either return the answer from\n$self-E<gt>_fields-E<gt>{score} if it is defined, or call a method _discover_score()\nfirst if not. So for the system to work you need to define a _discover_*()\nmethod for every field in the fields hash, and ensure that the method stores an\nanswer in the fields hash.\n\nHow you implement your _discover_* methods is up to you, though you should never\ncall a _discover_* method directly yourself; always use get_field(), since\nget_field() will deal with calling dependant methods for you if a forced\nsequenctial read is in progress due to piped input. You will almost certainly\nwant to make use of the various chunk-related methods of this class (that are\ndenoted private by the leading '_'; this means you can use them as the author of\na parser class, but users of your parser should not). \n\nPrimary amongst them is _*_chunk_by_end() to which you provide text that\nrepresents the end of your desired chunk and it does a readline with your\nargument as $/. The chunk knows about its line-endings, so if you want your\nend definition to include a new line, just always use \"\\n\" and PullParserI will\ndo any necessary conversion for you.\n\nIf your input data is hierarchical (eg. report-E<gt>many results-E<gt>many hits-E<gt>many\nhsps), and you want an object at the leaf of the hierarchy to have access to\ninformation that is shared amongst all of them (is parsed in the root), you\ndon't have to copy the data to each leaf object; simply by defining parent(),\nwhen you call get_field() and the requested field isn't in your leaf's fields\nhash, the leaf's parent will be asked for the field instead, and so on till\nroot.\n\nSee Bio::SearchIO::hmmer_pull for an example of implementing a parser using\nPullParserI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 CONTRIBUTORS\n\nInspired by a posting by Aaron J. Mackey\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::PullParserI;\n\nuse vars qw($AUTOLOAD $FORCE_TEMP_FILE);\nuse strict;\n\nuse Bio::Root::IO;\n\nuse base qw(Bio::Root::RootI);\n\nBEGIN {\n    # chunk() needs perl 5.8 feature for modes other than temp_file, so will\n    # workaround by forcing temp_file mode in <5.8. Could also rewrite using\n    # IO::String, but don't want to.\n    if ($] < 5.008) {\n        $FORCE_TEMP_FILE = 1;\n    }\n}\n\n=head2 _fields\n\n Title   : _fields\n Usage   : $obj->_fields( { field1 => undef } );\n           my $fields_ref = $obj->_fields;\n Function: Get/set the hash reference containing all the fields for this parser\n Returns : hash ref\n Args    : none to get, OR hash ref to set\n\n\nsub _fields {\n    my $self = shift;\n    if (@_) {\n        $self->{_fields} = shift;\n    }\n    unless (defined $self->{_fields}) {\n        $self->{_fields} = { };\n    }\n    return $self->{_fields};\n}\n\n=head2 has_field\n\n Title   : has_field\n Usage   : if ($obj->has_field('field_name') {...}\n Function: Ask if a particular object has a given field (doesn't ask ancestors)\n Returns : boolean\n Args    : string (the field name to test)\n\n\nsub has_field {\n    my ($self, $desired) = @_;\n    $desired || return;\n    return exists $self->_fields->{$desired};\n}\n\n=head2 get_field\n\n Title   : get_field\n Usage   : my $field_value = $obj->get_field('field_name');\n Function: Get the value of a given field. If this $obj doesn't have the field,\n           it's parent() will be asked, and so on until there are no more\n           parents.\n Returns : scalar, warns if a value for the field couldn't be found and returns\n           undef.\n Args    : string (the field to get)\n\n\nsub get_field {\n    my $self = shift;\n    my $desired = shift || return keys %{$self->_fields};\n    if (exists $self->_fields->{$desired}) {\n        unless (defined $self->_fields->{$desired}) {\n            my $method = '_discover_'.$desired;\n            \n            my $dependency = $self->_dependencies($desired);\n            if ($dependency && ! defined $self->_fields->{$dependency}) {\n                $self->get_field($dependency);\n            }\n            \n            # it might exist now\n            $self->$method unless defined $self->_fields->{$desired};\n        }\n        return $self->_fields->{$desired};\n    }\n    \n    # is it a field of our parent? (checks all ancestors)\n    if (my $parent = $self->parent) {\n        return $parent->get_field($desired);\n    }\n    \n    $desired =~ s/_discover_//;\n    $self->warn(\"This report does not hold information about '$desired'\");\n    return;\n}\n\n=head2 parent\n\n Title   : parent\n Usage   : $obj->parent($parent_obj);\n           my $parent_obj = $obj->parent;\n Function: Get/set the parent object of this one.\n Returns : Bio::PullParserI\n Args    : none to get, OR Bio::PullParserI to set\n\n\nsub parent {\n    my $self = shift;\n    if (@_) { $self->{parent} = shift }\n    return $self->{parent} || return;\n}\n\n=head2 chunk\n\n Title   : chunk\n Usage   : $obj->chunk($filename);\n           my $chunk = $obj->chunk;\n Function: Get/set the chunk of this parser.\n Returns : Bio:Root::IO\n Args    : none to get, OR\n           First argument of a GLOB reference, filename string, string data to\n           treat as the chunk, or Bio::Root::IO.\n           Optionally, also provide:\n           -start => int : the byte position within the thing described by the\n                           first arguement to consider as the start of this\n                           chunk (default 0)\n           -end   => int : the byte position to consider as the end (default\n                           true end)\n           -piped_behaviour => 'memory'|'temp_file'|'sequential_read'\n\n           The last option comes into effect when the first argument is\n           something that cannot be seeked (eg. piped input filehandle).\n            'memory'          means read all the piped input into a string\n                              first, then set the chunk to that string.\n            'temp_file'       means read all the piped input and output it to\n                              a temp file, then set the chunk to that temp file.\n            'sequential_read' means that the piped input should be read\n                              sequentially and your parsing code must cope with\n                              not being able to seek.\n           'memory' is the fastest but uses the most memory. 'temp_file' and\n           'sequential_read' can be slow, with 'temp_file' being the most memory\n           efficient but requiring disc space. The default is 'sequential_read'.\n           Note that in versions of perl earlier than 5.8 only temp_file works\n           and will be used regardless of what value is supplied here.\n\n\nsub chunk {\n    my $self = shift;\n    \n    if (@_) {\n        my $thing = shift || $self->throw(\"Trying to set chunk() to an undefined value\");\n        if (ref($thing) eq 'GLOB') {\n            $self->{_chunk} = Bio::Root::IO->new(-fh => $thing);\n        }\n        elsif (ref(\\$thing) eq 'SCALAR') {\n            if ($thing !~ /\\n/ && -e $thing) {\n                $self->{_chunk} = Bio::Root::IO->new(-file => $thing);\n            }\n            else {\n                unless ($FORCE_TEMP_FILE) {\n                    # treat a string as a filehandle\n                    open(my $fake_fh, \"+<\", \\$thing); # requires perl 5.8\n                    $self->{_chunk} = Bio::Root::IO->new(-fh => $fake_fh);\n                }\n                else {\n                    my ($handle) = $self->{_chunk}->tempfile();\n                    print $handle $thing;\n                    $self->{_chunk} = Bio::Root::IO->new(-fh => $handle);\n                }\n            }\n        }\n        elsif ($thing->isa('Bio::Root::IO')) {\n            $self->{_chunk} = $thing;\n        }\n        else {\n            $self->throw(\"Unknown input into chunk()\");\n        }\n        \n        my ($piped_behaviour, $start, $end);\n        if (@_) {\n            ($piped_behaviour, $start, $end) =\n                $self->_rearrange([qw(PIPED_BEHAVIOUR START END)], @_);\n        }\n        $piped_behaviour ||= 'sequential_read';\n        $FORCE_TEMP_FILE && ($piped_behaviour = 'temp_file');\n        $start ||= 0;\n        $self->_chunk_true_start($start);\n        $self->_chunk_true_end($end);\n        \n        # determine if the chunk is seekable\n        my $fh = $self->{_chunk}->_fh;\n        seek($fh, 0, 0);\n        my $first_line = <$fh>;\n        seek($fh, 0, 0);\n        my $seekable = tell($fh) == 0;\n        unless ($seekable) {\n            if ($piped_behaviour eq 'memory') {\n                my $string = $first_line;\n                while (<$fh>) {\n                    $string .= $_;\n                }\n                $self->chunk($string);\n            }\n            elsif ($piped_behaviour eq 'temp_file') {\n                my ($handle) = $self->{_chunk}->tempfile();\n                print $handle $first_line;\n                while (<$fh>) {\n                    print $handle $_;\n                }\n                seek($handle, 0, 0);\n                $self->chunk($handle);\n            }\n            elsif ($piped_behaviour eq 'sequential_read') {\n                $self->{_chunk}->_pushback($first_line);\n                $self->_sequential(1);\n            }\n            else {\n                $self->throw(\"Unknown piped behaviour type '$piped_behaviour'\");\n            }\n        }\n        \n        # determine our line ending\n        if ($first_line =~ /\\r\\n/) {\n            $self->_line_ending(\"\\r\\n\");\n        }\n        elsif ($first_line =~ /\\r/) {\n            $self->_line_ending(\"\\r\");\n        }\n        else {\n            $self->_line_ending(\"\\n\");\n        }\n    }\n    \n    return $self->{_chunk} || return;\n}\n\n=head2 _sequential\n\n Title   : _sequential\n Usage   : if ($obj->_sequential) {...}\n Function: Ask if we have to do operations such that the input is read\n           sequentially.\n Returns : boolean\n Args    : none to get, OR boolean to set (typically, you should never set this\n           yourself)\n\n\nsub _sequential {\n    my $self = shift;\n    if (@_) {\n        $self->{_sequential} = shift;\n    }\n    return $self->{_sequential} || 0;\n}\n\n=head2 _dependencies\n\n Title   : _dependencies\n Usage   : $obj->_dependencies( { field1 => field2 } );\n           my $dependancy = $obj->_dependencies('field_name');\n Function: Set the fields that are dependent on each other, or get the field\n           than another is dependent upon.\n Returns : string (a field name)\n Args    : string (a field name) to get, OR hash ref to initially set, with\n           field names as keys and values, key field being dependent upon value\n           field.\n\n\nsub _dependencies {\n    my ($self, $thing) = @_;\n    $thing || return;\n    if (ref($thing) eq 'HASH') {\n        $self->{_dependencies} = $thing;\n    }\n    else {\n        return $self->{_dependencies}->{$thing};\n    }\n}\n\n=head2 _chunk_true_start\n\n Title   : _chunk_true_start\n Usage   : my $true_start = $obj->_chunk_true_start;\n Function: Get/set the true start position of the chunk within the filehandle\n           it is part of.\n Returns : int\n Args    : none to get, OR int to set (typically, you won't set this yourself)\n\n\nsub _chunk_true_start {\n    my $self = shift;\n    if (@_) {\n        $self->{_chunk_start} = shift;\n    }\n    return $self->{_chunk_start} || 0;\n}\n\n=head2 _chunk_true_end\n\n Title   : _chunk_true_end\n Usage   : my $true_end = $obj->_chunk_true_end;\n Function: Get/set for the true end position of the chunk within the filehandle\n           it is part of.\n Returns : int\n Args    : none to get, OR int to set (typically, you won't set this yourself)\n\n\nsub _chunk_true_end {\n    my $self = shift;\n    if (@_) {\n        $self->{_chunk_end} = shift;\n    }\n    return $self->{_chunk_end};\n}\n\n=head2 _line_ending\n\n Title   : _line_ending\n Usage   : my $line_ending = $obj->_line_ending;\n Function: Get/set for the line ending for the chunk.\n Returns : string\n Args    : none to get, OR string to set (typically, you won't set this\n           yourself)\n\n\nsub _line_ending {\n    my $self = shift;\n    if (@_) {\n        $self->{_chunk_line_ending} = shift;\n    }\n    return $self->{_chunk_line_ending};\n}\n\n=head2 _chunk_seek\n\n Title   : _chunk_seek\n Usage   : $obj->_chunk_seek($pos);\n Function: seek() the chunk to the provided position in bytes, relative to the\n           defined start of the chunk within its filehandle.\n\n           In _sequential() mode, this function does nothing.\n\n Returns : n/a\n Args    : int\n\n\nsub _chunk_seek {\n    my ($self, $pos) = @_;\n    return if $self->_sequential;\n    \n    my $fh = $self->chunk->_fh;\n    \n    # seek to the defined start\n    seek($fh, $self->_chunk_true_start, 0);\n    \n    # now seek to desired position relative to defined start\n    seek($fh, $pos, 1);\n}\n\n=head2 _chunk_tell\n\n Title   : _chunk_seek\n Usage   : my $pos = $obj->_chunk_tell;\n Function: Get the current tell() position within the chunk, relative to the\n           defined start of the chunk within its filehandle.\n\n           In _sequential() mode, this function does nothing.\n\n Returns : int\n Args    : none\n\n\nsub _chunk_tell {\n    my $self = shift;\n    return if $self->_sequential;\n    \n    my $fh = $self->chunk->_fh;\n    return tell($fh) - $self->_chunk_true_start;\n}\n\n=head2 _get_chunk_by_nol\n\n Title   : _chunk_seek\n Usage   : my $string = $obj->_get_chunk_by_nol;\n Function: Get a chunk of chunk() from the current position onward for the given\n           number of lines.\n Returns : string\n Args    : int (number of lines you want)","label":"_get_chunk_by_nol($self,$nol)"},"kind":12,"range":{"start":{"character":0,"line":533},"end":{"line":552,"character":9999}},"line":533},{"definition":"sub","detail":"($self,$chunk_ending)","children":[{"definition":"my","line":567,"containerName":"_get_chunk_by_end","localvar":"my","kind":13,"name":"$self"},{"line":567,"containerName":"_get_chunk_by_end","kind":13,"name":"$chunk_ending"},{"definition":"my","line":569,"name":"$start","containerName":"_get_chunk_by_end","localvar":"my","kind":13},{"line":569,"name":"$self","containerName":"_get_chunk_by_end","kind":13},{"line":569,"containerName":"_get_chunk_by_end","kind":12,"name":"_chunk_tell"},{"line":571,"localvar":"my","containerName":"_get_chunk_by_end","kind":13,"name":"$line_ending","definition":"my"},{"name":"$self","containerName":"_get_chunk_by_end","kind":13,"line":571},{"line":571,"name":"_line_ending","containerName":"_get_chunk_by_end","kind":12},{"name":"$chunk_ending","containerName":"_get_chunk_by_end","kind":13,"line":572},{"name":"$chunk_ending","kind":13,"containerName":"_get_chunk_by_end","line":573},{"definition":"my","localvar":"my","containerName":"_get_chunk_by_end","kind":13,"name":"$line","line":574},{"kind":13,"containerName":"_get_chunk_by_end","name":"$self","line":574},{"line":574,"kind":12,"containerName":"_get_chunk_by_end","name":"chunk"},{"kind":12,"containerName":"_get_chunk_by_end","name":"_readline","line":574},{"definition":"my","line":576,"localvar":"my","containerName":"_get_chunk_by_end","kind":13,"name":"$current"},{"line":576,"kind":13,"containerName":"_get_chunk_by_end","name":"$self"},{"line":576,"name":"_chunk_tell","kind":12,"containerName":"_get_chunk_by_end"},{"localvar":"my","kind":13,"containerName":"_get_chunk_by_end","name":"$end","line":577,"definition":"my"},{"line":577,"name":"$current","containerName":"_get_chunk_by_end","kind":13},{"name":"$self","kind":13,"containerName":"_get_chunk_by_end","line":577},{"name":"_chunk_true_start","kind":12,"containerName":"_get_chunk_by_end","line":577},{"name":"$current","containerName":"_get_chunk_by_end","kind":13,"line":578},{"line":578,"containerName":"_get_chunk_by_end","kind":13,"name":"$self"},{"name":"_chunk_true_end","kind":12,"containerName":"_get_chunk_by_end","line":578},{"line":578,"name":"$end","containerName":"_get_chunk_by_end","kind":13},{"line":578,"name":"$self","kind":13,"containerName":"_get_chunk_by_end"},{"containerName":"_get_chunk_by_end","kind":12,"name":"_chunk_true_end","line":578},{"kind":13,"containerName":"_get_chunk_by_end","name":"$line","line":579},{"containerName":"_get_chunk_by_end","kind":13,"name":"$self","line":582},{"kind":12,"containerName":"_get_chunk_by_end","name":"_chunk_seek","line":582},{"name":"$start","containerName":"_get_chunk_by_end","kind":13,"line":582}],"containerName":"main::","name":"_get_chunk_by_end","signature":{"documentation":"1;\n# $Id: PullParserI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PullParserI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PullParserI - A base module for fast 'pull' parsing\n\n=head1 SYNOPSIS\n\n    # do not use this class, it is intended for parser module\n    # writers only\n\n=head1 DESCRIPTION\n\nIf you are writing a module to parse some new format, you may wish to use\na 'pull' approach whereby you only do work (reading file data, parsing it,\nturning the parsed data in an object) when absolutely necessary.\n\nPullParserI provides a system for doing exactly that. As a PullParser you\nneed a chunk. A chunk is just a Bio::Root::IO that contains all the raw data\nyou would want to parse. You can use the chunk() method to create a chunk from\na filename, existing filehandle or even a string. If you make a chunk from a\nlarge file, but actually only want your chunk to be some portion of the whole\nfile, supply start and end amounts in bytes to chunk() at the same time.\nThe methods _chunk_seek() and _chunk_tell() provide seeks and tells that are\nrelative to the start and end of your chunk, not the whole file.\n\nThe other thing you will need to decide when making a chunk is how to handle\npiped input. A PullParser typically needs seekable data to parse, so if your\ndata is piped in and unseekable, you must decide between creating a temp file\nor reading the input into memory, which will be done before the chunk becomes\nusable and you can begin any parsing. Alternatively you can choose to force\na sequential read, in which case you can make use of _dependencies() to define\nthe linear order of methods that would result in the file being read\nsequentially. The return value of _sequential() is also useful here, if you\nwould need to cache some data or otherwise behave differently during a\nsequential read.\n\nThe main method in the system is get_field(). This method relies on the\nexistance of a private hash reference accessible to it with the method\n_fields(). That hash ref should have as keys all the sorts of data you will want\nto parse (eg. 'score'), and prior to parsing the values would be undefined. A\nuser of your module can then call either $module-E<gt>get_field('score') or\n$module-E<gt>score and get_field will either return the answer from\n$self-E<gt>_fields-E<gt>{score} if it is defined, or call a method _discover_score()\nfirst if not. So for the system to work you need to define a _discover_*()\nmethod for every field in the fields hash, and ensure that the method stores an\nanswer in the fields hash.\n\nHow you implement your _discover_* methods is up to you, though you should never\ncall a _discover_* method directly yourself; always use get_field(), since\nget_field() will deal with calling dependant methods for you if a forced\nsequenctial read is in progress due to piped input. You will almost certainly\nwant to make use of the various chunk-related methods of this class (that are\ndenoted private by the leading '_'; this means you can use them as the author of\na parser class, but users of your parser should not). \n\nPrimary amongst them is _*_chunk_by_end() to which you provide text that\nrepresents the end of your desired chunk and it does a readline with your\nargument as $/. The chunk knows about its line-endings, so if you want your\nend definition to include a new line, just always use \"\\n\" and PullParserI will\ndo any necessary conversion for you.\n\nIf your input data is hierarchical (eg. report-E<gt>many results-E<gt>many hits-E<gt>many\nhsps), and you want an object at the leaf of the hierarchy to have access to\ninformation that is shared amongst all of them (is parsed in the root), you\ndon't have to copy the data to each leaf object; simply by defining parent(),\nwhen you call get_field() and the requested field isn't in your leaf's fields\nhash, the leaf's parent will be asked for the field instead, and so on till\nroot.\n\nSee Bio::SearchIO::hmmer_pull for an example of implementing a parser using\nPullParserI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 CONTRIBUTORS\n\nInspired by a posting by Aaron J. Mackey\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::PullParserI;\n\nuse vars qw($AUTOLOAD $FORCE_TEMP_FILE);\nuse strict;\n\nuse Bio::Root::IO;\n\nuse base qw(Bio::Root::RootI);\n\nBEGIN {\n    # chunk() needs perl 5.8 feature for modes other than temp_file, so will\n    # workaround by forcing temp_file mode in <5.8. Could also rewrite using\n    # IO::String, but don't want to.\n    if ($] < 5.008) {\n        $FORCE_TEMP_FILE = 1;\n    }\n}\n\n=head2 _fields\n\n Title   : _fields\n Usage   : $obj->_fields( { field1 => undef } );\n           my $fields_ref = $obj->_fields;\n Function: Get/set the hash reference containing all the fields for this parser\n Returns : hash ref\n Args    : none to get, OR hash ref to set\n\n\nsub _fields {\n    my $self = shift;\n    if (@_) {\n        $self->{_fields} = shift;\n    }\n    unless (defined $self->{_fields}) {\n        $self->{_fields} = { };\n    }\n    return $self->{_fields};\n}\n\n=head2 has_field\n\n Title   : has_field\n Usage   : if ($obj->has_field('field_name') {...}\n Function: Ask if a particular object has a given field (doesn't ask ancestors)\n Returns : boolean\n Args    : string (the field name to test)\n\n\nsub has_field {\n    my ($self, $desired) = @_;\n    $desired || return;\n    return exists $self->_fields->{$desired};\n}\n\n=head2 get_field\n\n Title   : get_field\n Usage   : my $field_value = $obj->get_field('field_name');\n Function: Get the value of a given field. If this $obj doesn't have the field,\n           it's parent() will be asked, and so on until there are no more\n           parents.\n Returns : scalar, warns if a value for the field couldn't be found and returns\n           undef.\n Args    : string (the field to get)\n\n\nsub get_field {\n    my $self = shift;\n    my $desired = shift || return keys %{$self->_fields};\n    if (exists $self->_fields->{$desired}) {\n        unless (defined $self->_fields->{$desired}) {\n            my $method = '_discover_'.$desired;\n            \n            my $dependency = $self->_dependencies($desired);\n            if ($dependency && ! defined $self->_fields->{$dependency}) {\n                $self->get_field($dependency);\n            }\n            \n            # it might exist now\n            $self->$method unless defined $self->_fields->{$desired};\n        }\n        return $self->_fields->{$desired};\n    }\n    \n    # is it a field of our parent? (checks all ancestors)\n    if (my $parent = $self->parent) {\n        return $parent->get_field($desired);\n    }\n    \n    $desired =~ s/_discover_//;\n    $self->warn(\"This report does not hold information about '$desired'\");\n    return;\n}\n\n=head2 parent\n\n Title   : parent\n Usage   : $obj->parent($parent_obj);\n           my $parent_obj = $obj->parent;\n Function: Get/set the parent object of this one.\n Returns : Bio::PullParserI\n Args    : none to get, OR Bio::PullParserI to set\n\n\nsub parent {\n    my $self = shift;\n    if (@_) { $self->{parent} = shift }\n    return $self->{parent} || return;\n}\n\n=head2 chunk\n\n Title   : chunk\n Usage   : $obj->chunk($filename);\n           my $chunk = $obj->chunk;\n Function: Get/set the chunk of this parser.\n Returns : Bio:Root::IO\n Args    : none to get, OR\n           First argument of a GLOB reference, filename string, string data to\n           treat as the chunk, or Bio::Root::IO.\n           Optionally, also provide:\n           -start => int : the byte position within the thing described by the\n                           first arguement to consider as the start of this\n                           chunk (default 0)\n           -end   => int : the byte position to consider as the end (default\n                           true end)\n           -piped_behaviour => 'memory'|'temp_file'|'sequential_read'\n\n           The last option comes into effect when the first argument is\n           something that cannot be seeked (eg. piped input filehandle).\n            'memory'          means read all the piped input into a string\n                              first, then set the chunk to that string.\n            'temp_file'       means read all the piped input and output it to\n                              a temp file, then set the chunk to that temp file.\n            'sequential_read' means that the piped input should be read\n                              sequentially and your parsing code must cope with\n                              not being able to seek.\n           'memory' is the fastest but uses the most memory. 'temp_file' and\n           'sequential_read' can be slow, with 'temp_file' being the most memory\n           efficient but requiring disc space. The default is 'sequential_read'.\n           Note that in versions of perl earlier than 5.8 only temp_file works\n           and will be used regardless of what value is supplied here.\n\n\nsub chunk {\n    my $self = shift;\n    \n    if (@_) {\n        my $thing = shift || $self->throw(\"Trying to set chunk() to an undefined value\");\n        if (ref($thing) eq 'GLOB') {\n            $self->{_chunk} = Bio::Root::IO->new(-fh => $thing);\n        }\n        elsif (ref(\\$thing) eq 'SCALAR') {\n            if ($thing !~ /\\n/ && -e $thing) {\n                $self->{_chunk} = Bio::Root::IO->new(-file => $thing);\n            }\n            else {\n                unless ($FORCE_TEMP_FILE) {\n                    # treat a string as a filehandle\n                    open(my $fake_fh, \"+<\", \\$thing); # requires perl 5.8\n                    $self->{_chunk} = Bio::Root::IO->new(-fh => $fake_fh);\n                }\n                else {\n                    my ($handle) = $self->{_chunk}->tempfile();\n                    print $handle $thing;\n                    $self->{_chunk} = Bio::Root::IO->new(-fh => $handle);\n                }\n            }\n        }\n        elsif ($thing->isa('Bio::Root::IO')) {\n            $self->{_chunk} = $thing;\n        }\n        else {\n            $self->throw(\"Unknown input into chunk()\");\n        }\n        \n        my ($piped_behaviour, $start, $end);\n        if (@_) {\n            ($piped_behaviour, $start, $end) =\n                $self->_rearrange([qw(PIPED_BEHAVIOUR START END)], @_);\n        }\n        $piped_behaviour ||= 'sequential_read';\n        $FORCE_TEMP_FILE && ($piped_behaviour = 'temp_file');\n        $start ||= 0;\n        $self->_chunk_true_start($start);\n        $self->_chunk_true_end($end);\n        \n        # determine if the chunk is seekable\n        my $fh = $self->{_chunk}->_fh;\n        seek($fh, 0, 0);\n        my $first_line = <$fh>;\n        seek($fh, 0, 0);\n        my $seekable = tell($fh) == 0;\n        unless ($seekable) {\n            if ($piped_behaviour eq 'memory') {\n                my $string = $first_line;\n                while (<$fh>) {\n                    $string .= $_;\n                }\n                $self->chunk($string);\n            }\n            elsif ($piped_behaviour eq 'temp_file') {\n                my ($handle) = $self->{_chunk}->tempfile();\n                print $handle $first_line;\n                while (<$fh>) {\n                    print $handle $_;\n                }\n                seek($handle, 0, 0);\n                $self->chunk($handle);\n            }\n            elsif ($piped_behaviour eq 'sequential_read') {\n                $self->{_chunk}->_pushback($first_line);\n                $self->_sequential(1);\n            }\n            else {\n                $self->throw(\"Unknown piped behaviour type '$piped_behaviour'\");\n            }\n        }\n        \n        # determine our line ending\n        if ($first_line =~ /\\r\\n/) {\n            $self->_line_ending(\"\\r\\n\");\n        }\n        elsif ($first_line =~ /\\r/) {\n            $self->_line_ending(\"\\r\");\n        }\n        else {\n            $self->_line_ending(\"\\n\");\n        }\n    }\n    \n    return $self->{_chunk} || return;\n}\n\n=head2 _sequential\n\n Title   : _sequential\n Usage   : if ($obj->_sequential) {...}\n Function: Ask if we have to do operations such that the input is read\n           sequentially.\n Returns : boolean\n Args    : none to get, OR boolean to set (typically, you should never set this\n           yourself)\n\n\nsub _sequential {\n    my $self = shift;\n    if (@_) {\n        $self->{_sequential} = shift;\n    }\n    return $self->{_sequential} || 0;\n}\n\n=head2 _dependencies\n\n Title   : _dependencies\n Usage   : $obj->_dependencies( { field1 => field2 } );\n           my $dependancy = $obj->_dependencies('field_name');\n Function: Set the fields that are dependent on each other, or get the field\n           than another is dependent upon.\n Returns : string (a field name)\n Args    : string (a field name) to get, OR hash ref to initially set, with\n           field names as keys and values, key field being dependent upon value\n           field.\n\n\nsub _dependencies {\n    my ($self, $thing) = @_;\n    $thing || return;\n    if (ref($thing) eq 'HASH') {\n        $self->{_dependencies} = $thing;\n    }\n    else {\n        return $self->{_dependencies}->{$thing};\n    }\n}\n\n=head2 _chunk_true_start\n\n Title   : _chunk_true_start\n Usage   : my $true_start = $obj->_chunk_true_start;\n Function: Get/set the true start position of the chunk within the filehandle\n           it is part of.\n Returns : int\n Args    : none to get, OR int to set (typically, you won't set this yourself)\n\n\nsub _chunk_true_start {\n    my $self = shift;\n    if (@_) {\n        $self->{_chunk_start} = shift;\n    }\n    return $self->{_chunk_start} || 0;\n}\n\n=head2 _chunk_true_end\n\n Title   : _chunk_true_end\n Usage   : my $true_end = $obj->_chunk_true_end;\n Function: Get/set for the true end position of the chunk within the filehandle\n           it is part of.\n Returns : int\n Args    : none to get, OR int to set (typically, you won't set this yourself)\n\n\nsub _chunk_true_end {\n    my $self = shift;\n    if (@_) {\n        $self->{_chunk_end} = shift;\n    }\n    return $self->{_chunk_end};\n}\n\n=head2 _line_ending\n\n Title   : _line_ending\n Usage   : my $line_ending = $obj->_line_ending;\n Function: Get/set for the line ending for the chunk.\n Returns : string\n Args    : none to get, OR string to set (typically, you won't set this\n           yourself)\n\n\nsub _line_ending {\n    my $self = shift;\n    if (@_) {\n        $self->{_chunk_line_ending} = shift;\n    }\n    return $self->{_chunk_line_ending};\n}\n\n=head2 _chunk_seek\n\n Title   : _chunk_seek\n Usage   : $obj->_chunk_seek($pos);\n Function: seek() the chunk to the provided position in bytes, relative to the\n           defined start of the chunk within its filehandle.\n\n           In _sequential() mode, this function does nothing.\n\n Returns : n/a\n Args    : int\n\n\nsub _chunk_seek {\n    my ($self, $pos) = @_;\n    return if $self->_sequential;\n    \n    my $fh = $self->chunk->_fh;\n    \n    # seek to the defined start\n    seek($fh, $self->_chunk_true_start, 0);\n    \n    # now seek to desired position relative to defined start\n    seek($fh, $pos, 1);\n}\n\n=head2 _chunk_tell\n\n Title   : _chunk_seek\n Usage   : my $pos = $obj->_chunk_tell;\n Function: Get the current tell() position within the chunk, relative to the\n           defined start of the chunk within its filehandle.\n\n           In _sequential() mode, this function does nothing.\n\n Returns : int\n Args    : none\n\n\nsub _chunk_tell {\n    my $self = shift;\n    return if $self->_sequential;\n    \n    my $fh = $self->chunk->_fh;\n    return tell($fh) - $self->_chunk_true_start;\n}\n\n=head2 _get_chunk_by_nol\n\n Title   : _chunk_seek\n Usage   : my $string = $obj->_get_chunk_by_nol;\n Function: Get a chunk of chunk() from the current position onward for the given\n           number of lines.\n Returns : string\n Args    : int (number of lines you want)\n\n\nsub _get_chunk_by_nol {\n    my ($self, $nol) = @_;\n    $nol > 0 || $self->throw(\"Can't request a chunk of fewer than 1 lines\");\n    \n    # hope that $/ is \\n\n    \n    my ($line, $count);\n    while (defined($_ = $self->chunk->_readline)) {\n        $line .= $_;\n        $count++;\n        last if $count == $nol;\n    }\n    \n    my $current = $self->_chunk_tell;\n    my $end = ($current || 0) + $self->_chunk_true_start;\n    if (! $current || ($self->_chunk_true_end ? $end <= $self->_chunk_true_end : 1)) {\n        return $line;\n    }\n    return;\n}\n\n=head2 _get_chunk_by_end\n\n Title   : _get_chunk_by_end\n Usage   : my $string = $obj->_get_chunk_by_end;\n Function: Get a chunk of chunk() from the current position onward till the end\n           of the line, as defined by the supplied argument.\n Returns : string\n Args    : string (line ending - if you want the line ending to include a new\n           line, always use \\n)","parameters":[{"label":"$self"},{"label":"$chunk_ending"}],"label":"_get_chunk_by_end($self,$chunk_ending)"},"line":566,"kind":12,"range":{"end":{"line":584,"character":9999},"start":{"character":0,"line":566}}},{"detail":"($self,$chunk_ending)","definition":"sub","name":"_find_chunk_by_end","containerName":"main::","children":[{"definition":"my","line":603,"name":"$self","containerName":"_find_chunk_by_end","localvar":"my","kind":13},{"line":603,"kind":13,"containerName":"_find_chunk_by_end","name":"$chunk_ending"},{"containerName":"_find_chunk_by_end","kind":13,"name":"$self","line":604},{"kind":12,"containerName":"_find_chunk_by_end","name":"_sequential","line":604},{"localvar":"my","kind":13,"containerName":"_find_chunk_by_end","name":"$line_ending","line":606,"definition":"my"},{"line":606,"name":"$self","kind":13,"containerName":"_find_chunk_by_end"},{"name":"_line_ending","kind":12,"containerName":"_find_chunk_by_end","line":606},{"name":"$chunk_ending","kind":13,"containerName":"_find_chunk_by_end","line":607},{"line":608,"name":"$chunk_ending","containerName":"_find_chunk_by_end","kind":13},{"definition":"my","localvar":"my","containerName":"_find_chunk_by_end","kind":13,"name":"$start","line":610},{"line":610,"kind":13,"containerName":"_find_chunk_by_end","name":"$self"},{"line":610,"name":"_chunk_tell","containerName":"_find_chunk_by_end","kind":12},{"name":"$self","kind":13,"containerName":"_find_chunk_by_end","line":611},{"kind":12,"containerName":"_find_chunk_by_end","name":"chunk","line":611},{"line":611,"name":"_readline","containerName":"_find_chunk_by_end","kind":12},{"definition":"my","line":612,"name":"$end","localvar":"my","kind":13,"containerName":"_find_chunk_by_end"},{"line":612,"containerName":"_find_chunk_by_end","kind":13,"name":"$self"},{"kind":12,"containerName":"_find_chunk_by_end","name":"_chunk_tell","line":612},{"definition":"my","line":614,"kind":13,"localvar":"my","containerName":"_find_chunk_by_end","name":"$comp_end"},{"name":"$end","containerName":"_find_chunk_by_end","kind":13,"line":614},{"name":"$self","kind":13,"containerName":"_find_chunk_by_end","line":614},{"line":614,"containerName":"_find_chunk_by_end","kind":12,"name":"_chunk_true_start"},{"line":615,"containerName":"_find_chunk_by_end","kind":13,"name":"$self"},{"containerName":"_find_chunk_by_end","kind":12,"name":"_chunk_true_end","line":615},{"containerName":"_find_chunk_by_end","kind":13,"name":"$comp_end","line":615},{"line":615,"name":"$self","containerName":"_find_chunk_by_end","kind":13},{"containerName":"_find_chunk_by_end","kind":12,"name":"_chunk_true_end","line":615},{"kind":13,"containerName":"_find_chunk_by_end","name":"$start","line":616},{"name":"$end","kind":13,"containerName":"_find_chunk_by_end","line":616},{"line":619,"containerName":"_find_chunk_by_end","kind":13,"name":"$self"},{"containerName":"_find_chunk_by_end","kind":12,"name":"_chunk_seek","line":619},{"kind":13,"containerName":"_find_chunk_by_end","name":"$start","line":619}],"signature":{"label":"_find_chunk_by_end($self,$chunk_ending)","documentation":"1;\n# $Id: PullParserI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PullParserI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PullParserI - A base module for fast 'pull' parsing\n\n=head1 SYNOPSIS\n\n    # do not use this class, it is intended for parser module\n    # writers only\n\n=head1 DESCRIPTION\n\nIf you are writing a module to parse some new format, you may wish to use\na 'pull' approach whereby you only do work (reading file data, parsing it,\nturning the parsed data in an object) when absolutely necessary.\n\nPullParserI provides a system for doing exactly that. As a PullParser you\nneed a chunk. A chunk is just a Bio::Root::IO that contains all the raw data\nyou would want to parse. You can use the chunk() method to create a chunk from\na filename, existing filehandle or even a string. If you make a chunk from a\nlarge file, but actually only want your chunk to be some portion of the whole\nfile, supply start and end amounts in bytes to chunk() at the same time.\nThe methods _chunk_seek() and _chunk_tell() provide seeks and tells that are\nrelative to the start and end of your chunk, not the whole file.\n\nThe other thing you will need to decide when making a chunk is how to handle\npiped input. A PullParser typically needs seekable data to parse, so if your\ndata is piped in and unseekable, you must decide between creating a temp file\nor reading the input into memory, which will be done before the chunk becomes\nusable and you can begin any parsing. Alternatively you can choose to force\na sequential read, in which case you can make use of _dependencies() to define\nthe linear order of methods that would result in the file being read\nsequentially. The return value of _sequential() is also useful here, if you\nwould need to cache some data or otherwise behave differently during a\nsequential read.\n\nThe main method in the system is get_field(). This method relies on the\nexistance of a private hash reference accessible to it with the method\n_fields(). That hash ref should have as keys all the sorts of data you will want\nto parse (eg. 'score'), and prior to parsing the values would be undefined. A\nuser of your module can then call either $module-E<gt>get_field('score') or\n$module-E<gt>score and get_field will either return the answer from\n$self-E<gt>_fields-E<gt>{score} if it is defined, or call a method _discover_score()\nfirst if not. So for the system to work you need to define a _discover_*()\nmethod for every field in the fields hash, and ensure that the method stores an\nanswer in the fields hash.\n\nHow you implement your _discover_* methods is up to you, though you should never\ncall a _discover_* method directly yourself; always use get_field(), since\nget_field() will deal with calling dependant methods for you if a forced\nsequenctial read is in progress due to piped input. You will almost certainly\nwant to make use of the various chunk-related methods of this class (that are\ndenoted private by the leading '_'; this means you can use them as the author of\na parser class, but users of your parser should not). \n\nPrimary amongst them is _*_chunk_by_end() to which you provide text that\nrepresents the end of your desired chunk and it does a readline with your\nargument as $/. The chunk knows about its line-endings, so if you want your\nend definition to include a new line, just always use \"\\n\" and PullParserI will\ndo any necessary conversion for you.\n\nIf your input data is hierarchical (eg. report-E<gt>many results-E<gt>many hits-E<gt>many\nhsps), and you want an object at the leaf of the hierarchy to have access to\ninformation that is shared amongst all of them (is parsed in the root), you\ndon't have to copy the data to each leaf object; simply by defining parent(),\nwhen you call get_field() and the requested field isn't in your leaf's fields\nhash, the leaf's parent will be asked for the field instead, and so on till\nroot.\n\nSee Bio::SearchIO::hmmer_pull for an example of implementing a parser using\nPullParserI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 CONTRIBUTORS\n\nInspired by a posting by Aaron J. Mackey\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::PullParserI;\n\nuse vars qw($AUTOLOAD $FORCE_TEMP_FILE);\nuse strict;\n\nuse Bio::Root::IO;\n\nuse base qw(Bio::Root::RootI);\n\nBEGIN {\n    # chunk() needs perl 5.8 feature for modes other than temp_file, so will\n    # workaround by forcing temp_file mode in <5.8. Could also rewrite using\n    # IO::String, but don't want to.\n    if ($] < 5.008) {\n        $FORCE_TEMP_FILE = 1;\n    }\n}\n\n=head2 _fields\n\n Title   : _fields\n Usage   : $obj->_fields( { field1 => undef } );\n           my $fields_ref = $obj->_fields;\n Function: Get/set the hash reference containing all the fields for this parser\n Returns : hash ref\n Args    : none to get, OR hash ref to set\n\n\nsub _fields {\n    my $self = shift;\n    if (@_) {\n        $self->{_fields} = shift;\n    }\n    unless (defined $self->{_fields}) {\n        $self->{_fields} = { };\n    }\n    return $self->{_fields};\n}\n\n=head2 has_field\n\n Title   : has_field\n Usage   : if ($obj->has_field('field_name') {...}\n Function: Ask if a particular object has a given field (doesn't ask ancestors)\n Returns : boolean\n Args    : string (the field name to test)\n\n\nsub has_field {\n    my ($self, $desired) = @_;\n    $desired || return;\n    return exists $self->_fields->{$desired};\n}\n\n=head2 get_field\n\n Title   : get_field\n Usage   : my $field_value = $obj->get_field('field_name');\n Function: Get the value of a given field. If this $obj doesn't have the field,\n           it's parent() will be asked, and so on until there are no more\n           parents.\n Returns : scalar, warns if a value for the field couldn't be found and returns\n           undef.\n Args    : string (the field to get)\n\n\nsub get_field {\n    my $self = shift;\n    my $desired = shift || return keys %{$self->_fields};\n    if (exists $self->_fields->{$desired}) {\n        unless (defined $self->_fields->{$desired}) {\n            my $method = '_discover_'.$desired;\n            \n            my $dependency = $self->_dependencies($desired);\n            if ($dependency && ! defined $self->_fields->{$dependency}) {\n                $self->get_field($dependency);\n            }\n            \n            # it might exist now\n            $self->$method unless defined $self->_fields->{$desired};\n        }\n        return $self->_fields->{$desired};\n    }\n    \n    # is it a field of our parent? (checks all ancestors)\n    if (my $parent = $self->parent) {\n        return $parent->get_field($desired);\n    }\n    \n    $desired =~ s/_discover_//;\n    $self->warn(\"This report does not hold information about '$desired'\");\n    return;\n}\n\n=head2 parent\n\n Title   : parent\n Usage   : $obj->parent($parent_obj);\n           my $parent_obj = $obj->parent;\n Function: Get/set the parent object of this one.\n Returns : Bio::PullParserI\n Args    : none to get, OR Bio::PullParserI to set\n\n\nsub parent {\n    my $self = shift;\n    if (@_) { $self->{parent} = shift }\n    return $self->{parent} || return;\n}\n\n=head2 chunk\n\n Title   : chunk\n Usage   : $obj->chunk($filename);\n           my $chunk = $obj->chunk;\n Function: Get/set the chunk of this parser.\n Returns : Bio:Root::IO\n Args    : none to get, OR\n           First argument of a GLOB reference, filename string, string data to\n           treat as the chunk, or Bio::Root::IO.\n           Optionally, also provide:\n           -start => int : the byte position within the thing described by the\n                           first arguement to consider as the start of this\n                           chunk (default 0)\n           -end   => int : the byte position to consider as the end (default\n                           true end)\n           -piped_behaviour => 'memory'|'temp_file'|'sequential_read'\n\n           The last option comes into effect when the first argument is\n           something that cannot be seeked (eg. piped input filehandle).\n            'memory'          means read all the piped input into a string\n                              first, then set the chunk to that string.\n            'temp_file'       means read all the piped input and output it to\n                              a temp file, then set the chunk to that temp file.\n            'sequential_read' means that the piped input should be read\n                              sequentially and your parsing code must cope with\n                              not being able to seek.\n           'memory' is the fastest but uses the most memory. 'temp_file' and\n           'sequential_read' can be slow, with 'temp_file' being the most memory\n           efficient but requiring disc space. The default is 'sequential_read'.\n           Note that in versions of perl earlier than 5.8 only temp_file works\n           and will be used regardless of what value is supplied here.\n\n\nsub chunk {\n    my $self = shift;\n    \n    if (@_) {\n        my $thing = shift || $self->throw(\"Trying to set chunk() to an undefined value\");\n        if (ref($thing) eq 'GLOB') {\n            $self->{_chunk} = Bio::Root::IO->new(-fh => $thing);\n        }\n        elsif (ref(\\$thing) eq 'SCALAR') {\n            if ($thing !~ /\\n/ && -e $thing) {\n                $self->{_chunk} = Bio::Root::IO->new(-file => $thing);\n            }\n            else {\n                unless ($FORCE_TEMP_FILE) {\n                    # treat a string as a filehandle\n                    open(my $fake_fh, \"+<\", \\$thing); # requires perl 5.8\n                    $self->{_chunk} = Bio::Root::IO->new(-fh => $fake_fh);\n                }\n                else {\n                    my ($handle) = $self->{_chunk}->tempfile();\n                    print $handle $thing;\n                    $self->{_chunk} = Bio::Root::IO->new(-fh => $handle);\n                }\n            }\n        }\n        elsif ($thing->isa('Bio::Root::IO')) {\n            $self->{_chunk} = $thing;\n        }\n        else {\n            $self->throw(\"Unknown input into chunk()\");\n        }\n        \n        my ($piped_behaviour, $start, $end);\n        if (@_) {\n            ($piped_behaviour, $start, $end) =\n                $self->_rearrange([qw(PIPED_BEHAVIOUR START END)], @_);\n        }\n        $piped_behaviour ||= 'sequential_read';\n        $FORCE_TEMP_FILE && ($piped_behaviour = 'temp_file');\n        $start ||= 0;\n        $self->_chunk_true_start($start);\n        $self->_chunk_true_end($end);\n        \n        # determine if the chunk is seekable\n        my $fh = $self->{_chunk}->_fh;\n        seek($fh, 0, 0);\n        my $first_line = <$fh>;\n        seek($fh, 0, 0);\n        my $seekable = tell($fh) == 0;\n        unless ($seekable) {\n            if ($piped_behaviour eq 'memory') {\n                my $string = $first_line;\n                while (<$fh>) {\n                    $string .= $_;\n                }\n                $self->chunk($string);\n            }\n            elsif ($piped_behaviour eq 'temp_file') {\n                my ($handle) = $self->{_chunk}->tempfile();\n                print $handle $first_line;\n                while (<$fh>) {\n                    print $handle $_;\n                }\n                seek($handle, 0, 0);\n                $self->chunk($handle);\n            }\n            elsif ($piped_behaviour eq 'sequential_read') {\n                $self->{_chunk}->_pushback($first_line);\n                $self->_sequential(1);\n            }\n            else {\n                $self->throw(\"Unknown piped behaviour type '$piped_behaviour'\");\n            }\n        }\n        \n        # determine our line ending\n        if ($first_line =~ /\\r\\n/) {\n            $self->_line_ending(\"\\r\\n\");\n        }\n        elsif ($first_line =~ /\\r/) {\n            $self->_line_ending(\"\\r\");\n        }\n        else {\n            $self->_line_ending(\"\\n\");\n        }\n    }\n    \n    return $self->{_chunk} || return;\n}\n\n=head2 _sequential\n\n Title   : _sequential\n Usage   : if ($obj->_sequential) {...}\n Function: Ask if we have to do operations such that the input is read\n           sequentially.\n Returns : boolean\n Args    : none to get, OR boolean to set (typically, you should never set this\n           yourself)\n\n\nsub _sequential {\n    my $self = shift;\n    if (@_) {\n        $self->{_sequential} = shift;\n    }\n    return $self->{_sequential} || 0;\n}\n\n=head2 _dependencies\n\n Title   : _dependencies\n Usage   : $obj->_dependencies( { field1 => field2 } );\n           my $dependancy = $obj->_dependencies('field_name');\n Function: Set the fields that are dependent on each other, or get the field\n           than another is dependent upon.\n Returns : string (a field name)\n Args    : string (a field name) to get, OR hash ref to initially set, with\n           field names as keys and values, key field being dependent upon value\n           field.\n\n\nsub _dependencies {\n    my ($self, $thing) = @_;\n    $thing || return;\n    if (ref($thing) eq 'HASH') {\n        $self->{_dependencies} = $thing;\n    }\n    else {\n        return $self->{_dependencies}->{$thing};\n    }\n}\n\n=head2 _chunk_true_start\n\n Title   : _chunk_true_start\n Usage   : my $true_start = $obj->_chunk_true_start;\n Function: Get/set the true start position of the chunk within the filehandle\n           it is part of.\n Returns : int\n Args    : none to get, OR int to set (typically, you won't set this yourself)\n\n\nsub _chunk_true_start {\n    my $self = shift;\n    if (@_) {\n        $self->{_chunk_start} = shift;\n    }\n    return $self->{_chunk_start} || 0;\n}\n\n=head2 _chunk_true_end\n\n Title   : _chunk_true_end\n Usage   : my $true_end = $obj->_chunk_true_end;\n Function: Get/set for the true end position of the chunk within the filehandle\n           it is part of.\n Returns : int\n Args    : none to get, OR int to set (typically, you won't set this yourself)\n\n\nsub _chunk_true_end {\n    my $self = shift;\n    if (@_) {\n        $self->{_chunk_end} = shift;\n    }\n    return $self->{_chunk_end};\n}\n\n=head2 _line_ending\n\n Title   : _line_ending\n Usage   : my $line_ending = $obj->_line_ending;\n Function: Get/set for the line ending for the chunk.\n Returns : string\n Args    : none to get, OR string to set (typically, you won't set this\n           yourself)\n\n\nsub _line_ending {\n    my $self = shift;\n    if (@_) {\n        $self->{_chunk_line_ending} = shift;\n    }\n    return $self->{_chunk_line_ending};\n}\n\n=head2 _chunk_seek\n\n Title   : _chunk_seek\n Usage   : $obj->_chunk_seek($pos);\n Function: seek() the chunk to the provided position in bytes, relative to the\n           defined start of the chunk within its filehandle.\n\n           In _sequential() mode, this function does nothing.\n\n Returns : n/a\n Args    : int\n\n\nsub _chunk_seek {\n    my ($self, $pos) = @_;\n    return if $self->_sequential;\n    \n    my $fh = $self->chunk->_fh;\n    \n    # seek to the defined start\n    seek($fh, $self->_chunk_true_start, 0);\n    \n    # now seek to desired position relative to defined start\n    seek($fh, $pos, 1);\n}\n\n=head2 _chunk_tell\n\n Title   : _chunk_seek\n Usage   : my $pos = $obj->_chunk_tell;\n Function: Get the current tell() position within the chunk, relative to the\n           defined start of the chunk within its filehandle.\n\n           In _sequential() mode, this function does nothing.\n\n Returns : int\n Args    : none\n\n\nsub _chunk_tell {\n    my $self = shift;\n    return if $self->_sequential;\n    \n    my $fh = $self->chunk->_fh;\n    return tell($fh) - $self->_chunk_true_start;\n}\n\n=head2 _get_chunk_by_nol\n\n Title   : _chunk_seek\n Usage   : my $string = $obj->_get_chunk_by_nol;\n Function: Get a chunk of chunk() from the current position onward for the given\n           number of lines.\n Returns : string\n Args    : int (number of lines you want)\n\n\nsub _get_chunk_by_nol {\n    my ($self, $nol) = @_;\n    $nol > 0 || $self->throw(\"Can't request a chunk of fewer than 1 lines\");\n    \n    # hope that $/ is \\n\n    \n    my ($line, $count);\n    while (defined($_ = $self->chunk->_readline)) {\n        $line .= $_;\n        $count++;\n        last if $count == $nol;\n    }\n    \n    my $current = $self->_chunk_tell;\n    my $end = ($current || 0) + $self->_chunk_true_start;\n    if (! $current || ($self->_chunk_true_end ? $end <= $self->_chunk_true_end : 1)) {\n        return $line;\n    }\n    return;\n}\n\n=head2 _get_chunk_by_end\n\n Title   : _get_chunk_by_end\n Usage   : my $string = $obj->_get_chunk_by_end;\n Function: Get a chunk of chunk() from the current position onward till the end\n           of the line, as defined by the supplied argument.\n Returns : string\n Args    : string (line ending - if you want the line ending to include a new\n           line, always use \\n)\n\n\nsub _get_chunk_by_end {\n    my ($self, $chunk_ending) = @_;\n    \n    my $start = $self->_chunk_tell;\n    \n    my $line_ending = $self->_line_ending;\n    $chunk_ending =~ s/\\n/$line_ending/g;\n    local $/ = $chunk_ending || '';\n    my $line = $self->chunk->_readline;\n    \n    my $current = $self->_chunk_tell;\n    my $end = ($current || 0) + $self->_chunk_true_start;\n    if (! $current || ($self->_chunk_true_end ? $end <= $self->_chunk_true_end : 1)) {\n        return $line;\n    }\n    \n    $self->_chunk_seek($start);\n    return;\n}\n\n=head2 _find_chunk_by_end\n\n Title   : _find_chunk_by_end\n Usage   : my $string = $obj->_find_chunk_by_end;\n Function: Get the start and end of what would be a chunk of chunk() from the\n           current position onward till the end of the line, as defined by the\n           supplied argument.\n\n           In _sequential() mode, this function does nothing.\n\n Returns : _chunk_tell values for start and end in 2 element list\n Args    : string (line ending - if you want the line ending to include a new\n           line, always use \\n)","parameters":[{"label":"$self"},{"label":"$chunk_ending"}]},"kind":12,"range":{"start":{"line":602,"character":0},"end":{"character":9999,"line":621}},"line":602},{"definition":"sub","children":[{"definition":"my","line":635,"localvar":"my","kind":13,"containerName":"AUTOLOAD","name":"$self"},{"line":636,"name":"$self","kind":13,"containerName":"AUTOLOAD"},{"definition":"my","name":"$name","localvar":"my","containerName":"AUTOLOAD","kind":13,"line":638},{"containerName":"AUTOLOAD","kind":13,"name":"$AUTOLOAD","line":638},{"line":639,"name":"$name","containerName":"AUTOLOAD","kind":13},{"line":642,"name":"$self","kind":13,"containerName":"AUTOLOAD"},{"name":"get_field","containerName":"AUTOLOAD","kind":12,"line":642},{"line":642,"containerName":"AUTOLOAD","kind":13,"name":"$name"}],"containerName":"main::","name":"AUTOLOAD","line":634,"range":{"start":{"character":0,"line":634},"end":{"line":643,"character":9999}},"kind":12}],"version":5}