{"version":5,"vars":[{"kind":2,"containerName":"","name":"base","line":94},{"definition":"sub","detail":"($class,@args)","children":[{"definition":"my","line":113,"containerName":"new","localvar":"my","kind":13,"name":"$class"},{"line":113,"name":"@args","containerName":"new","kind":13},{"definition":"my","line":115,"localvar":"my","containerName":"new","kind":13,"name":"$self"},{"line":115,"name":"$class","containerName":"new","kind":13},{"kind":13,"containerName":"new","name":"@args","line":115},{"definition":"my","line":116,"name":"$population","containerName":"new","localvar":"my","kind":13},{"name":"$popsize","kind":13,"containerName":"new","line":117},{"containerName":"new","kind":13,"name":"$haploid","line":117},{"line":117,"containerName":"new","kind":13,"name":"$alleles"},{"line":117,"containerName":"new","kind":13,"name":"$self"},{"line":117,"name":"_rearrange","kind":12,"containerName":"new"},{"name":"@args","containerName":"new","kind":13,"line":120},{"line":121,"name":"$population","kind":13,"containerName":"new"},{"containerName":"new","kind":13,"name":"$population","line":121},{"line":122,"name":"$population","kind":13,"containerName":"new"},{"line":122,"name":"isa","containerName":"new","kind":12},{"line":123,"name":"$self","containerName":"new","kind":13},{"name":"population_size","kind":12,"containerName":"new","line":123},{"name":"$population","kind":13,"containerName":"new","line":123},{"containerName":"new","kind":12,"name":"get_number_individuals","line":123},{"line":123,"containerName":"new","kind":13,"name":"$popsize"},{"definition":"my","line":124,"name":"%f","localvar":"my","kind":13,"containerName":"new"},{"line":124,"kind":13,"containerName":"new","name":"$population"},{"line":124,"name":"get_Allele_Frequencies","kind":12,"containerName":"new"},{"line":125,"name":"$allele","localvar":"my","kind":13,"containerName":"new","definition":"my"},{"containerName":"new","kind":13,"name":"$freq","line":125},{"name":"%f","containerName":"new","kind":13,"line":125},{"line":126,"name":"$self","kind":13,"containerName":"new"},{"kind":12,"containerName":"new","name":"add_Allele_Frequency","line":126},{"name":"$allele","kind":13,"containerName":"new","line":126},{"line":126,"containerName":"new","kind":13,"name":"$freq"},{"containerName":"new","kind":13,"name":"$self","line":129},{"name":"population_size","containerName":"new","kind":12,"line":129},{"name":"$popsize","containerName":"new","kind":13,"line":129},{"line":131,"name":"$alleles","kind":13,"containerName":"new"},{"line":131,"name":"$alleles","containerName":"new","kind":13},{"line":132,"name":"$self","kind":13,"containerName":"new"},{"line":132,"containerName":"new","kind":12,"name":"throw"},{"definition":"my","name":"$allele","localvar":"my","containerName":"new","kind":13,"line":134},{"line":134,"name":"$freq","containerName":"new","kind":13},{"line":134,"kind":13,"containerName":"new","name":"$alleles"},{"line":135,"name":"$self","kind":13,"containerName":"new"},{"line":135,"containerName":"new","kind":12,"name":"add_Allele_Frequency"},{"name":"$allele","containerName":"new","kind":13,"line":135},{"line":135,"name":"$freq","kind":13,"containerName":"new"},{"line":138,"name":"$self","containerName":"new","kind":13},{"line":138,"containerName":"new","kind":12,"name":"validate_Frequencies"},{"kind":13,"containerName":"new","name":"$self","line":139},{"line":139,"name":"throw","kind":12,"containerName":"new"},{"line":141,"containerName":"new","kind":13,"name":"$self"}],"name":"new","containerName":"main::","signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: GeneticDrift.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Simulation::GeneticDrift\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Simulation::GeneticDrift - A simple genetic drift simulation\n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::Simulation::GeneticDrift;\n  my $sim = Bio::PopGen::Simulation::GeneticDrift->new(-popsize => 40,\n\t\t\t\t\t\t      -alleles => {A => 0.2,\n\t\t\t\t\t\t\t           B => 0.8});\n  for(my $i =0 ;$i < 10; $i++ ) {\n    my %f = $sim->next_generation; # get the freqs for each generation\n  }\n\n  for(my $i =0 ;$i < 10; $i++ ) {\n    # get the allele freqs as part of a Bio::PopGen::Population object\n    my $pop = $sim->next_generation('population'); \n  }\n\n=head1 DESCRIPTION\n\nA very simple 1 locus multi-allele random drift module, start with an\ninitial set of allele frequency and simulate what happens over time.\n\nThis isn't really useful for anything in particular yet but will be\nbuilt upon.\n\nSee Gillespie JH. (1998) \"Population Genetics: a Concise guide.\" The Johns\n              Hopkins University Press, Baltimore, USA.  pp.19-47.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Simulation::GeneticDrift;\nuse strict;\n\nuse Bio::PopGen::Population;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Simulation::GeneticDrift->new();\n Function: Builds a new Bio::PopGen::Simulation::GeneticDrift object \n Returns : an instance of Bio::PopGen::Simulation::GeneticDrift\n Args    : -popsize => starting N\n           -haploid => boolean if we should simulate haploids \n           -alleles => arrayref of the allele names\n           OR\n           -population => L<Bio::PopGen::PopulationI> object to initialize \n                          from some previously defined Population object\n                          (or result from a previous simulation)"},"line":112,"range":{"start":{"line":112,"character":0},"end":{"line":142,"character":9999}},"kind":12},{"name":"SUPER","containerName":"new","kind":12,"line":115},{"containerName":"main::","name":"next_generation","children":[{"definition":"my","line":159,"name":"$self","containerName":"next_generation","localvar":"my","kind":13},{"line":159,"kind":13,"containerName":"next_generation","name":"$rettype"},{"localvar":"my","containerName":"next_generation","kind":13,"name":"%initial","line":160,"definition":"my"},{"line":160,"name":"$self","containerName":"next_generation","kind":13},{"line":160,"name":"get_Allele_Frequencies","containerName":"next_generation","kind":12},{"line":161,"name":"$popsize","containerName":"next_generation","localvar":"my","kind":13,"definition":"my"},{"name":"$self","containerName":"next_generation","kind":13,"line":161},{"line":161,"kind":12,"containerName":"next_generation","name":"population_size"},{"name":"$self","kind":13,"containerName":"next_generation","line":162},{"containerName":"next_generation","kind":12,"name":"throw","line":162},{"line":166,"name":"$last","localvar":"my","containerName":"next_generation","kind":13,"definition":"my"},{"kind":13,"containerName":"next_generation","name":"@mapping","line":166},{"line":172,"containerName":"next_generation","localvar":"my","kind":13,"name":"$a","definition":"my"},{"name":"%initial","containerName":"next_generation","kind":13,"line":172},{"kind":13,"containerName":"next_generation","name":"@mapping","line":173},{"containerName":"next_generation","kind":13,"name":"$last","line":173},{"name":"$initial","containerName":"next_generation","kind":13,"line":173},{"line":173,"kind":13,"containerName":"next_generation","name":"$a"},{"line":173,"name":"$last","kind":13,"containerName":"next_generation"},{"containerName":"next_generation","kind":13,"name":"$a","line":173},{"containerName":"next_generation","kind":13,"name":"$last","line":174},{"name":"$initial","kind":13,"containerName":"next_generation","line":174},{"line":174,"containerName":"next_generation","kind":13,"name":"$a"},{"definition":"my","kind":13,"localvar":"my","containerName":"next_generation","name":"%f","line":177},{"line":178,"localvar":"my","kind":13,"containerName":"next_generation","name":"$i","definition":"my"},{"name":"$i","kind":13,"containerName":"next_generation","line":178},{"line":178,"name":"$popsize","kind":13,"containerName":"next_generation"},{"line":178,"containerName":"next_generation","kind":13,"name":"$i"},{"localvar":"my","kind":13,"containerName":"next_generation","name":"$rand","line":179,"definition":"my"},{"name":"$val","containerName":"next_generation","localvar":"my","kind":13,"line":180,"definition":"my"},{"line":180,"containerName":"next_generation","kind":13,"name":"@mapping"},{"line":181,"name":"$rand","kind":13,"containerName":"next_generation"},{"containerName":"next_generation","kind":13,"name":"$val","line":181},{"name":"$rand","kind":13,"containerName":"next_generation","line":181},{"line":181,"name":"$val","kind":13,"containerName":"next_generation"},{"line":182,"containerName":"next_generation","kind":13,"name":"$f"},{"name":"$val","kind":13,"containerName":"next_generation","line":182},{"line":187,"name":"$f","localvar":"my","kind":13,"containerName":"next_generation","definition":"my"},{"line":187,"kind":13,"containerName":"next_generation","name":"%f"},{"name":"$f","kind":13,"containerName":"next_generation","line":188},{"name":"$popsize","kind":13,"containerName":"next_generation","line":188},{"line":190,"containerName":"next_generation","kind":13,"name":"$self"}],"detail":"($self,$rettype)","definition":"sub","kind":12,"range":{"end":{"line":190,"character":9999},"start":{"line":158,"character":0}},"line":158,"signature":{"parameters":[{"label":"$self"},{"label":"$rettype"}],"documentation":"1;\n# $Id: GeneticDrift.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Simulation::GeneticDrift\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Simulation::GeneticDrift - A simple genetic drift simulation\n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::Simulation::GeneticDrift;\n  my $sim = Bio::PopGen::Simulation::GeneticDrift->new(-popsize => 40,\n\t\t\t\t\t\t      -alleles => {A => 0.2,\n\t\t\t\t\t\t\t           B => 0.8});\n  for(my $i =0 ;$i < 10; $i++ ) {\n    my %f = $sim->next_generation; # get the freqs for each generation\n  }\n\n  for(my $i =0 ;$i < 10; $i++ ) {\n    # get the allele freqs as part of a Bio::PopGen::Population object\n    my $pop = $sim->next_generation('population'); \n  }\n\n=head1 DESCRIPTION\n\nA very simple 1 locus multi-allele random drift module, start with an\ninitial set of allele frequency and simulate what happens over time.\n\nThis isn't really useful for anything in particular yet but will be\nbuilt upon.\n\nSee Gillespie JH. (1998) \"Population Genetics: a Concise guide.\" The Johns\n              Hopkins University Press, Baltimore, USA.  pp.19-47.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Simulation::GeneticDrift;\nuse strict;\n\nuse Bio::PopGen::Population;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Simulation::GeneticDrift->new();\n Function: Builds a new Bio::PopGen::Simulation::GeneticDrift object \n Returns : an instance of Bio::PopGen::Simulation::GeneticDrift\n Args    : -popsize => starting N\n           -haploid => boolean if we should simulate haploids \n           -alleles => arrayref of the allele names\n           OR\n           -population => L<Bio::PopGen::PopulationI> object to initialize \n                          from some previously defined Population object\n                          (or result from a previous simulation)\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($population,\n      $popsize, $haploid, $alleles) = $self->_rearrange([qw(POPULATION\n\t\t\t\t\t\t\t    POPSIZE\n\t\t\t\t\t\t\t    HAPLOID\n\t\t\t\t\t\t\t    ALLELES)],@args);\n  if( defined $population && ref($population) &&\n      $population->isa('Bio::PopGen::PopulationI') ) {\n      $self->population_size($population->get_number_individuals || $popsize);\n      my %f = $population->get_Allele_Frequencies;\n      while( my ($allele,$freq) = each %f ) {\n\t  $self->add_Allele_Frequency($allele,$freq);\n      }\n  } else { \n      $self->population_size($popsize);  \n  \n      if( ! defined $alleles || ref($alleles) !~ /HASH/i  ) {\n\t  $self->throw(\"Must provide a valid set of initial allele frequencies to $class as an hashref\");\n      } \n      while( my ($allele,$freq) = each %$alleles ) {\n\t  $self->add_Allele_Frequency($allele,$freq);\n      }\n  }\n  unless( $self->validate_Frequencies ) {\n      $self->throw(\"You specified allele frequencies which summed to more than 1\");\n  }\n  return $self;\n}\n\n\n=head2 next_generation\n\n Title   : next_generation\n Usage   : my %generation = $sim->next_generation\n Function: Get the next generation of allele frequencies based on the current\n           generation\n Returns : Hash of allele frequencies\n Args    : 'allelefreqs' or 'population' to get back a hash of allele \n                 frequencies (default) OR a L<Bio::PopGen::Population> object","label":"next_generation($self,$rettype)"}},{"name":"%f","containerName":null,"kind":13,"line":190},{"line":192,"containerName":null,"kind":13,"name":"$rettype"},{"name":"%rettype","containerName":null,"kind":13,"line":193},{"name":"Bio","containerName":"PopGen::Poulation","kind":12,"line":194},{"line":194,"containerName":"main::","kind":12,"name":"new"},{"name":"%f","kind":13,"containerName":null,"line":194},{"line":196,"containerName":null,"kind":13,"name":"%f"},{"range":{"end":{"line":218,"character":9999},"start":{"character":0,"line":213}},"kind":12,"line":213,"name":"population_size","containerName":"main::","children":[{"definition":"my","name":"$self","containerName":"population_size","localvar":"my","kind":13,"line":214},{"containerName":"population_size","kind":13,"name":"$self","line":216},{"name":"$self","kind":13,"containerName":"population_size","line":217}],"definition":"sub"},{"name":"set_Frequencies_Equivalent","containerName":"main::","children":[{"definition":"my","line":232,"name":"$self","localvar":"my","containerName":"set_Frequencies_Equivalent","kind":13},{"definition":"my","line":233,"name":"@alleles","localvar":"my","containerName":"set_Frequencies_Equivalent","kind":13},{"name":"$self","containerName":"set_Frequencies_Equivalent","kind":13,"line":233}],"detail":"($self)","definition":"sub","range":{"start":{"line":231,"character":0},"end":{"line":233,"character":9999}},"kind":12,"line":231,"signature":{"documentation":"1;\n# $Id: GeneticDrift.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Simulation::GeneticDrift\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Simulation::GeneticDrift - A simple genetic drift simulation\n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::Simulation::GeneticDrift;\n  my $sim = Bio::PopGen::Simulation::GeneticDrift->new(-popsize => 40,\n\t\t\t\t\t\t      -alleles => {A => 0.2,\n\t\t\t\t\t\t\t           B => 0.8});\n  for(my $i =0 ;$i < 10; $i++ ) {\n    my %f = $sim->next_generation; # get the freqs for each generation\n  }\n\n  for(my $i =0 ;$i < 10; $i++ ) {\n    # get the allele freqs as part of a Bio::PopGen::Population object\n    my $pop = $sim->next_generation('population'); \n  }\n\n=head1 DESCRIPTION\n\nA very simple 1 locus multi-allele random drift module, start with an\ninitial set of allele frequency and simulate what happens over time.\n\nThis isn't really useful for anything in particular yet but will be\nbuilt upon.\n\nSee Gillespie JH. (1998) \"Population Genetics: a Concise guide.\" The Johns\n              Hopkins University Press, Baltimore, USA.  pp.19-47.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Simulation::GeneticDrift;\nuse strict;\n\nuse Bio::PopGen::Population;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Simulation::GeneticDrift->new();\n Function: Builds a new Bio::PopGen::Simulation::GeneticDrift object \n Returns : an instance of Bio::PopGen::Simulation::GeneticDrift\n Args    : -popsize => starting N\n           -haploid => boolean if we should simulate haploids \n           -alleles => arrayref of the allele names\n           OR\n           -population => L<Bio::PopGen::PopulationI> object to initialize \n                          from some previously defined Population object\n                          (or result from a previous simulation)\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($population,\n      $popsize, $haploid, $alleles) = $self->_rearrange([qw(POPULATION\n\t\t\t\t\t\t\t    POPSIZE\n\t\t\t\t\t\t\t    HAPLOID\n\t\t\t\t\t\t\t    ALLELES)],@args);\n  if( defined $population && ref($population) &&\n      $population->isa('Bio::PopGen::PopulationI') ) {\n      $self->population_size($population->get_number_individuals || $popsize);\n      my %f = $population->get_Allele_Frequencies;\n      while( my ($allele,$freq) = each %f ) {\n\t  $self->add_Allele_Frequency($allele,$freq);\n      }\n  } else { \n      $self->population_size($popsize);  \n  \n      if( ! defined $alleles || ref($alleles) !~ /HASH/i  ) {\n\t  $self->throw(\"Must provide a valid set of initial allele frequencies to $class as an hashref\");\n      } \n      while( my ($allele,$freq) = each %$alleles ) {\n\t  $self->add_Allele_Frequency($allele,$freq);\n      }\n  }\n  unless( $self->validate_Frequencies ) {\n      $self->throw(\"You specified allele frequencies which summed to more than 1\");\n  }\n  return $self;\n}\n\n\n=head2 next_generation\n\n Title   : next_generation\n Usage   : my %generation = $sim->next_generation\n Function: Get the next generation of allele frequencies based on the current\n           generation\n Returns : Hash of allele frequencies\n Args    : 'allelefreqs' or 'population' to get back a hash of allele \n                 frequencies (default) OR a L<Bio::PopGen::Population> object\n\n\n\nsub next_generation{\n   my ($self,$rettype) = @_;\n   my %initial = $self->get_Allele_Frequencies;\n   my $popsize = $self->population_size || \n       $self->throw(\"Need to have set a valid population size when running the simulation\");\n   # we're going to construct a mapping of the rational space from 0->1 \n   # which will map to a particular allele and be proportional to it\n   # frequency\n   my ($last,@mapping) = (0);\n\n   # we'll make ranges that cover from >= left and < right in terms of the\n   # order doesn't matter - 'distance' does\n   # range that we're going to try and match\n   # since rand() goes from 0 up to 1 (not including 1)\n   foreach my $a ( keys %initial ) {\n       push @mapping, [$last,$initial{$a}+$last,$a];\n       $last += $initial{$a};\n   }\n\n   my %f;\n   for( my $i =0; $i < $popsize; $i++ ) {\n       my $rand = rand(1);\n       foreach my $val ( @mapping ) {\n\t   if( $rand >= $val->[0] && $rand < $val->[1] ) {\n\t       $f{$val->[2]}++;\n\t       last;\n\t }\n       }\n   }\n   foreach my $f ( values %f ) {\n       $f /= $popsize;\n   }\n   %{$self->{'_allele_freqs'}} = %f;\n   \n   if( defined $rettype && \n       $rettype =~ /population/i) {\n       return Bio::PopGen::Poulation->new(-frequencies => \\%f);\n   } else { \n       return %f;\n   }\n\n}\n\n=head2 population_size\n\n Title   : population_size\n Usage   : $obj->population_size($newval)\n Function: \n Example : \n Returns : value of population_size (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub population_size{\n    my $self = shift;\n\n    return $self->{'_population_size'} = shift if @_;\n    return $self->{'_population_size'};\n}\n\n=head2 set_Frequencies_Equivalent\n\n Title   : set_Frequencies_Equivalent\n Usage   : $sim->set_Frequencies_Equivalent\n Function: Reset the allele frequencies so they are all even\n Returns : none\n Args    : none","parameters":[{"label":"$self"}],"label":"set_Frequencies_Equivalent($self)"}},{"definition":"my","line":234,"name":"$eqfreq","localvar":"my","kind":13,"containerName":null},{"line":234,"kind":13,"containerName":null,"name":"@alleles"},{"containerName":null,"kind":13,"name":"@alleles","line":235},{"name":"%self","kind":13,"containerName":null,"line":235},{"containerName":null,"kind":13,"name":"$eqfreq","line":235},{"children":[],"name":"get_Allele_Frequencies","containerName":"main::","definition":"sub","line":254,"kind":12,"range":{"end":{"character":9999,"line":255},"start":{"character":0,"line":254}}},{"line":270,"kind":12,"range":{"end":{"character":9999,"line":273},"start":{"character":0,"line":270}},"signature":{"parameters":[{"label":"$self"},{"label":"$allele"},{"label":"$freq"}],"documentation":"1;\n# $Id: GeneticDrift.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Simulation::GeneticDrift\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Simulation::GeneticDrift - A simple genetic drift simulation\n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::Simulation::GeneticDrift;\n  my $sim = Bio::PopGen::Simulation::GeneticDrift->new(-popsize => 40,\n\t\t\t\t\t\t      -alleles => {A => 0.2,\n\t\t\t\t\t\t\t           B => 0.8});\n  for(my $i =0 ;$i < 10; $i++ ) {\n    my %f = $sim->next_generation; # get the freqs for each generation\n  }\n\n  for(my $i =0 ;$i < 10; $i++ ) {\n    # get the allele freqs as part of a Bio::PopGen::Population object\n    my $pop = $sim->next_generation('population'); \n  }\n\n=head1 DESCRIPTION\n\nA very simple 1 locus multi-allele random drift module, start with an\ninitial set of allele frequency and simulate what happens over time.\n\nThis isn't really useful for anything in particular yet but will be\nbuilt upon.\n\nSee Gillespie JH. (1998) \"Population Genetics: a Concise guide.\" The Johns\n              Hopkins University Press, Baltimore, USA.  pp.19-47.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Simulation::GeneticDrift;\nuse strict;\n\nuse Bio::PopGen::Population;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Simulation::GeneticDrift->new();\n Function: Builds a new Bio::PopGen::Simulation::GeneticDrift object \n Returns : an instance of Bio::PopGen::Simulation::GeneticDrift\n Args    : -popsize => starting N\n           -haploid => boolean if we should simulate haploids \n           -alleles => arrayref of the allele names\n           OR\n           -population => L<Bio::PopGen::PopulationI> object to initialize \n                          from some previously defined Population object\n                          (or result from a previous simulation)\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($population,\n      $popsize, $haploid, $alleles) = $self->_rearrange([qw(POPULATION\n\t\t\t\t\t\t\t    POPSIZE\n\t\t\t\t\t\t\t    HAPLOID\n\t\t\t\t\t\t\t    ALLELES)],@args);\n  if( defined $population && ref($population) &&\n      $population->isa('Bio::PopGen::PopulationI') ) {\n      $self->population_size($population->get_number_individuals || $popsize);\n      my %f = $population->get_Allele_Frequencies;\n      while( my ($allele,$freq) = each %f ) {\n\t  $self->add_Allele_Frequency($allele,$freq);\n      }\n  } else { \n      $self->population_size($popsize);  \n  \n      if( ! defined $alleles || ref($alleles) !~ /HASH/i  ) {\n\t  $self->throw(\"Must provide a valid set of initial allele frequencies to $class as an hashref\");\n      } \n      while( my ($allele,$freq) = each %$alleles ) {\n\t  $self->add_Allele_Frequency($allele,$freq);\n      }\n  }\n  unless( $self->validate_Frequencies ) {\n      $self->throw(\"You specified allele frequencies which summed to more than 1\");\n  }\n  return $self;\n}\n\n\n=head2 next_generation\n\n Title   : next_generation\n Usage   : my %generation = $sim->next_generation\n Function: Get the next generation of allele frequencies based on the current\n           generation\n Returns : Hash of allele frequencies\n Args    : 'allelefreqs' or 'population' to get back a hash of allele \n                 frequencies (default) OR a L<Bio::PopGen::Population> object\n\n\n\nsub next_generation{\n   my ($self,$rettype) = @_;\n   my %initial = $self->get_Allele_Frequencies;\n   my $popsize = $self->population_size || \n       $self->throw(\"Need to have set a valid population size when running the simulation\");\n   # we're going to construct a mapping of the rational space from 0->1 \n   # which will map to a particular allele and be proportional to it\n   # frequency\n   my ($last,@mapping) = (0);\n\n   # we'll make ranges that cover from >= left and < right in terms of the\n   # order doesn't matter - 'distance' does\n   # range that we're going to try and match\n   # since rand() goes from 0 up to 1 (not including 1)\n   foreach my $a ( keys %initial ) {\n       push @mapping, [$last,$initial{$a}+$last,$a];\n       $last += $initial{$a};\n   }\n\n   my %f;\n   for( my $i =0; $i < $popsize; $i++ ) {\n       my $rand = rand(1);\n       foreach my $val ( @mapping ) {\n\t   if( $rand >= $val->[0] && $rand < $val->[1] ) {\n\t       $f{$val->[2]}++;\n\t       last;\n\t }\n       }\n   }\n   foreach my $f ( values %f ) {\n       $f /= $popsize;\n   }\n   %{$self->{'_allele_freqs'}} = %f;\n   \n   if( defined $rettype && \n       $rettype =~ /population/i) {\n       return Bio::PopGen::Poulation->new(-frequencies => \\%f);\n   } else { \n       return %f;\n   }\n\n}\n\n=head2 population_size\n\n Title   : population_size\n Usage   : $obj->population_size($newval)\n Function: \n Example : \n Returns : value of population_size (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub population_size{\n    my $self = shift;\n\n    return $self->{'_population_size'} = shift if @_;\n    return $self->{'_population_size'};\n}\n\n=head2 set_Frequencies_Equivalent\n\n Title   : set_Frequencies_Equivalent\n Usage   : $sim->set_Frequencies_Equivalent\n Function: Reset the allele frequencies so they are all even\n Returns : none\n Args    : none\n\n\n\nsub set_Frequencies_Equivalent{\n   my ($self) = @_;\n   my @alleles = keys %{$self->{'_allele_freqs'}};\n   my $eqfreq  = 1 / scalar @alleles;\n   for ( @alleles ) { $self->{'_allele_freqs'}->{$_} = $eqfreq }\n   return;\n}\n\n\n=head2 get_Allele_Frequencies\n\n Title   : get_Allele_Frequencies\n Usage   : my %allele_freqs = $marker->get_Allele_Frequencies;\n Function: Get the alleles and their frequency (set relative to\n           a given population - you may want to create different\n           markers with the same name for different populations\n           with this current implementation\n Returns : Associative array where keys are the names of the alleles\n Args    : none\n\n\n\nsub get_Allele_Frequencies{\n   return %{$_[0]->{'_allele_freqs'}};\n}\n\n=head2 add_Allele_Frequency\n\n Title   : add_Allele_Frequency\n Usage   : $marker->add_Allele_Frequency($allele,$freq)\n Function: Adds an allele frequency\n Returns : None\n Args    : $allele - allele name\n           $freq   - frequency value","label":"add_Allele_Frequency($self,$allele,$freq)"},"children":[{"line":271,"kind":13,"localvar":"my","containerName":"add_Allele_Frequency","name":"$self","definition":"my"},{"name":"$allele","kind":13,"containerName":"add_Allele_Frequency","line":271},{"containerName":"add_Allele_Frequency","kind":13,"name":"$freq","line":271},{"line":272,"containerName":"add_Allele_Frequency","kind":13,"name":"$self"},{"line":272,"kind":13,"containerName":"add_Allele_Frequency","name":"$allele"},{"line":272,"containerName":"add_Allele_Frequency","kind":13,"name":"$freq"}],"containerName":"main::","name":"add_Allele_Frequency","definition":"sub","detail":"($self,$allele,$freq)"},{"line":286,"range":{"end":{"line":289,"character":9999},"start":{"character":0,"line":286}},"kind":12,"signature":{"documentation":"1;\n# $Id: GeneticDrift.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Simulation::GeneticDrift\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Simulation::GeneticDrift - A simple genetic drift simulation\n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::Simulation::GeneticDrift;\n  my $sim = Bio::PopGen::Simulation::GeneticDrift->new(-popsize => 40,\n\t\t\t\t\t\t      -alleles => {A => 0.2,\n\t\t\t\t\t\t\t           B => 0.8});\n  for(my $i =0 ;$i < 10; $i++ ) {\n    my %f = $sim->next_generation; # get the freqs for each generation\n  }\n\n  for(my $i =0 ;$i < 10; $i++ ) {\n    # get the allele freqs as part of a Bio::PopGen::Population object\n    my $pop = $sim->next_generation('population'); \n  }\n\n=head1 DESCRIPTION\n\nA very simple 1 locus multi-allele random drift module, start with an\ninitial set of allele frequency and simulate what happens over time.\n\nThis isn't really useful for anything in particular yet but will be\nbuilt upon.\n\nSee Gillespie JH. (1998) \"Population Genetics: a Concise guide.\" The Johns\n              Hopkins University Press, Baltimore, USA.  pp.19-47.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Simulation::GeneticDrift;\nuse strict;\n\nuse Bio::PopGen::Population;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Simulation::GeneticDrift->new();\n Function: Builds a new Bio::PopGen::Simulation::GeneticDrift object \n Returns : an instance of Bio::PopGen::Simulation::GeneticDrift\n Args    : -popsize => starting N\n           -haploid => boolean if we should simulate haploids \n           -alleles => arrayref of the allele names\n           OR\n           -population => L<Bio::PopGen::PopulationI> object to initialize \n                          from some previously defined Population object\n                          (or result from a previous simulation)\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($population,\n      $popsize, $haploid, $alleles) = $self->_rearrange([qw(POPULATION\n\t\t\t\t\t\t\t    POPSIZE\n\t\t\t\t\t\t\t    HAPLOID\n\t\t\t\t\t\t\t    ALLELES)],@args);\n  if( defined $population && ref($population) &&\n      $population->isa('Bio::PopGen::PopulationI') ) {\n      $self->population_size($population->get_number_individuals || $popsize);\n      my %f = $population->get_Allele_Frequencies;\n      while( my ($allele,$freq) = each %f ) {\n\t  $self->add_Allele_Frequency($allele,$freq);\n      }\n  } else { \n      $self->population_size($popsize);  \n  \n      if( ! defined $alleles || ref($alleles) !~ /HASH/i  ) {\n\t  $self->throw(\"Must provide a valid set of initial allele frequencies to $class as an hashref\");\n      } \n      while( my ($allele,$freq) = each %$alleles ) {\n\t  $self->add_Allele_Frequency($allele,$freq);\n      }\n  }\n  unless( $self->validate_Frequencies ) {\n      $self->throw(\"You specified allele frequencies which summed to more than 1\");\n  }\n  return $self;\n}\n\n\n=head2 next_generation\n\n Title   : next_generation\n Usage   : my %generation = $sim->next_generation\n Function: Get the next generation of allele frequencies based on the current\n           generation\n Returns : Hash of allele frequencies\n Args    : 'allelefreqs' or 'population' to get back a hash of allele \n                 frequencies (default) OR a L<Bio::PopGen::Population> object\n\n\n\nsub next_generation{\n   my ($self,$rettype) = @_;\n   my %initial = $self->get_Allele_Frequencies;\n   my $popsize = $self->population_size || \n       $self->throw(\"Need to have set a valid population size when running the simulation\");\n   # we're going to construct a mapping of the rational space from 0->1 \n   # which will map to a particular allele and be proportional to it\n   # frequency\n   my ($last,@mapping) = (0);\n\n   # we'll make ranges that cover from >= left and < right in terms of the\n   # order doesn't matter - 'distance' does\n   # range that we're going to try and match\n   # since rand() goes from 0 up to 1 (not including 1)\n   foreach my $a ( keys %initial ) {\n       push @mapping, [$last,$initial{$a}+$last,$a];\n       $last += $initial{$a};\n   }\n\n   my %f;\n   for( my $i =0; $i < $popsize; $i++ ) {\n       my $rand = rand(1);\n       foreach my $val ( @mapping ) {\n\t   if( $rand >= $val->[0] && $rand < $val->[1] ) {\n\t       $f{$val->[2]}++;\n\t       last;\n\t }\n       }\n   }\n   foreach my $f ( values %f ) {\n       $f /= $popsize;\n   }\n   %{$self->{'_allele_freqs'}} = %f;\n   \n   if( defined $rettype && \n       $rettype =~ /population/i) {\n       return Bio::PopGen::Poulation->new(-frequencies => \\%f);\n   } else { \n       return %f;\n   }\n\n}\n\n=head2 population_size\n\n Title   : population_size\n Usage   : $obj->population_size($newval)\n Function: \n Example : \n Returns : value of population_size (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub population_size{\n    my $self = shift;\n\n    return $self->{'_population_size'} = shift if @_;\n    return $self->{'_population_size'};\n}\n\n=head2 set_Frequencies_Equivalent\n\n Title   : set_Frequencies_Equivalent\n Usage   : $sim->set_Frequencies_Equivalent\n Function: Reset the allele frequencies so they are all even\n Returns : none\n Args    : none\n\n\n\nsub set_Frequencies_Equivalent{\n   my ($self) = @_;\n   my @alleles = keys %{$self->{'_allele_freqs'}};\n   my $eqfreq  = 1 / scalar @alleles;\n   for ( @alleles ) { $self->{'_allele_freqs'}->{$_} = $eqfreq }\n   return;\n}\n\n\n=head2 get_Allele_Frequencies\n\n Title   : get_Allele_Frequencies\n Usage   : my %allele_freqs = $marker->get_Allele_Frequencies;\n Function: Get the alleles and their frequency (set relative to\n           a given population - you may want to create different\n           markers with the same name for different populations\n           with this current implementation\n Returns : Associative array where keys are the names of the alleles\n Args    : none\n\n\n\nsub get_Allele_Frequencies{\n   return %{$_[0]->{'_allele_freqs'}};\n}\n\n=head2 add_Allele_Frequency\n\n Title   : add_Allele_Frequency\n Usage   : $marker->add_Allele_Frequency($allele,$freq)\n Function: Adds an allele frequency\n Returns : None\n Args    : $allele - allele name\n           $freq   - frequency value\n\n\n\nsub add_Allele_Frequency{\n   my ($self,$allele,$freq) = @_;\n   $self->{'_allele_freqs'}->{$allele} = $freq;\n}\n\n=head2 reset_alleles\n\n Title   : reset_alleles\n Usage   : $marker->reset_alleles();\n Function: Reset the alleles for a marker\n Returns : None\n Args    : None","parameters":[{"label":"$self"}],"label":"reset_alleles($self)"},"children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"reset_alleles","line":287},{"name":"$self","containerName":"reset_alleles","kind":13,"line":288}],"name":"reset_alleles","containerName":"main::","definition":"sub","detail":"($self)"},{"line":302,"kind":12,"range":{"end":{"character":9999,"line":311},"start":{"character":0,"line":302}},"signature":{"documentation":"1;\n# $Id: GeneticDrift.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Simulation::GeneticDrift\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Simulation::GeneticDrift - A simple genetic drift simulation\n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::Simulation::GeneticDrift;\n  my $sim = Bio::PopGen::Simulation::GeneticDrift->new(-popsize => 40,\n\t\t\t\t\t\t      -alleles => {A => 0.2,\n\t\t\t\t\t\t\t           B => 0.8});\n  for(my $i =0 ;$i < 10; $i++ ) {\n    my %f = $sim->next_generation; # get the freqs for each generation\n  }\n\n  for(my $i =0 ;$i < 10; $i++ ) {\n    # get the allele freqs as part of a Bio::PopGen::Population object\n    my $pop = $sim->next_generation('population'); \n  }\n\n=head1 DESCRIPTION\n\nA very simple 1 locus multi-allele random drift module, start with an\ninitial set of allele frequency and simulate what happens over time.\n\nThis isn't really useful for anything in particular yet but will be\nbuilt upon.\n\nSee Gillespie JH. (1998) \"Population Genetics: a Concise guide.\" The Johns\n              Hopkins University Press, Baltimore, USA.  pp.19-47.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Simulation::GeneticDrift;\nuse strict;\n\nuse Bio::PopGen::Population;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Simulation::GeneticDrift->new();\n Function: Builds a new Bio::PopGen::Simulation::GeneticDrift object \n Returns : an instance of Bio::PopGen::Simulation::GeneticDrift\n Args    : -popsize => starting N\n           -haploid => boolean if we should simulate haploids \n           -alleles => arrayref of the allele names\n           OR\n           -population => L<Bio::PopGen::PopulationI> object to initialize \n                          from some previously defined Population object\n                          (or result from a previous simulation)\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($population,\n      $popsize, $haploid, $alleles) = $self->_rearrange([qw(POPULATION\n\t\t\t\t\t\t\t    POPSIZE\n\t\t\t\t\t\t\t    HAPLOID\n\t\t\t\t\t\t\t    ALLELES)],@args);\n  if( defined $population && ref($population) &&\n      $population->isa('Bio::PopGen::PopulationI') ) {\n      $self->population_size($population->get_number_individuals || $popsize);\n      my %f = $population->get_Allele_Frequencies;\n      while( my ($allele,$freq) = each %f ) {\n\t  $self->add_Allele_Frequency($allele,$freq);\n      }\n  } else { \n      $self->population_size($popsize);  \n  \n      if( ! defined $alleles || ref($alleles) !~ /HASH/i  ) {\n\t  $self->throw(\"Must provide a valid set of initial allele frequencies to $class as an hashref\");\n      } \n      while( my ($allele,$freq) = each %$alleles ) {\n\t  $self->add_Allele_Frequency($allele,$freq);\n      }\n  }\n  unless( $self->validate_Frequencies ) {\n      $self->throw(\"You specified allele frequencies which summed to more than 1\");\n  }\n  return $self;\n}\n\n\n=head2 next_generation\n\n Title   : next_generation\n Usage   : my %generation = $sim->next_generation\n Function: Get the next generation of allele frequencies based on the current\n           generation\n Returns : Hash of allele frequencies\n Args    : 'allelefreqs' or 'population' to get back a hash of allele \n                 frequencies (default) OR a L<Bio::PopGen::Population> object\n\n\n\nsub next_generation{\n   my ($self,$rettype) = @_;\n   my %initial = $self->get_Allele_Frequencies;\n   my $popsize = $self->population_size || \n       $self->throw(\"Need to have set a valid population size when running the simulation\");\n   # we're going to construct a mapping of the rational space from 0->1 \n   # which will map to a particular allele and be proportional to it\n   # frequency\n   my ($last,@mapping) = (0);\n\n   # we'll make ranges that cover from >= left and < right in terms of the\n   # order doesn't matter - 'distance' does\n   # range that we're going to try and match\n   # since rand() goes from 0 up to 1 (not including 1)\n   foreach my $a ( keys %initial ) {\n       push @mapping, [$last,$initial{$a}+$last,$a];\n       $last += $initial{$a};\n   }\n\n   my %f;\n   for( my $i =0; $i < $popsize; $i++ ) {\n       my $rand = rand(1);\n       foreach my $val ( @mapping ) {\n\t   if( $rand >= $val->[0] && $rand < $val->[1] ) {\n\t       $f{$val->[2]}++;\n\t       last;\n\t }\n       }\n   }\n   foreach my $f ( values %f ) {\n       $f /= $popsize;\n   }\n   %{$self->{'_allele_freqs'}} = %f;\n   \n   if( defined $rettype && \n       $rettype =~ /population/i) {\n       return Bio::PopGen::Poulation->new(-frequencies => \\%f);\n   } else { \n       return %f;\n   }\n\n}\n\n=head2 population_size\n\n Title   : population_size\n Usage   : $obj->population_size($newval)\n Function: \n Example : \n Returns : value of population_size (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub population_size{\n    my $self = shift;\n\n    return $self->{'_population_size'} = shift if @_;\n    return $self->{'_population_size'};\n}\n\n=head2 set_Frequencies_Equivalent\n\n Title   : set_Frequencies_Equivalent\n Usage   : $sim->set_Frequencies_Equivalent\n Function: Reset the allele frequencies so they are all even\n Returns : none\n Args    : none\n\n\n\nsub set_Frequencies_Equivalent{\n   my ($self) = @_;\n   my @alleles = keys %{$self->{'_allele_freqs'}};\n   my $eqfreq  = 1 / scalar @alleles;\n   for ( @alleles ) { $self->{'_allele_freqs'}->{$_} = $eqfreq }\n   return;\n}\n\n\n=head2 get_Allele_Frequencies\n\n Title   : get_Allele_Frequencies\n Usage   : my %allele_freqs = $marker->get_Allele_Frequencies;\n Function: Get the alleles and their frequency (set relative to\n           a given population - you may want to create different\n           markers with the same name for different populations\n           with this current implementation\n Returns : Associative array where keys are the names of the alleles\n Args    : none\n\n\n\nsub get_Allele_Frequencies{\n   return %{$_[0]->{'_allele_freqs'}};\n}\n\n=head2 add_Allele_Frequency\n\n Title   : add_Allele_Frequency\n Usage   : $marker->add_Allele_Frequency($allele,$freq)\n Function: Adds an allele frequency\n Returns : None\n Args    : $allele - allele name\n           $freq   - frequency value\n\n\n\nsub add_Allele_Frequency{\n   my ($self,$allele,$freq) = @_;\n   $self->{'_allele_freqs'}->{$allele} = $freq;\n}\n\n=head2 reset_alleles\n\n Title   : reset_alleles\n Usage   : $marker->reset_alleles();\n Function: Reset the alleles for a marker\n Returns : None\n Args    : None\n\n\n\nsub reset_alleles{\n   my ($self) = @_;\n   $self->{'_allele_freqs'} = {};\n}\n\n=head2 validate_Frequencies\n\n Title   : validate_Frequencies\n Usage   : if( $sim->validate_Frequencies) {}\n Function: Sanity checker that allele frequencies sum to 1 or less\n Returns : boolean\n Args    : -strict => 1 boolean if you want to insure that sum of freqs is 1","parameters":[{"label":"$self"},{"label":"@args"}],"label":"validate_Frequencies($self,@args)"},"children":[{"line":303,"name":"$self","localvar":"my","kind":13,"containerName":"validate_Frequencies","definition":"my"},{"containerName":"validate_Frequencies","kind":13,"name":"@args","line":303},{"line":304,"name":"$strict","kind":13,"localvar":"my","containerName":"validate_Frequencies","definition":"my"},{"containerName":"validate_Frequencies","kind":13,"name":"$self","line":304},{"name":"_rearrange","kind":12,"containerName":"validate_Frequencies","line":304},{"containerName":"validate_Frequencies","kind":13,"name":"@args","line":304},{"line":305,"name":"$sum","localvar":"my","kind":13,"containerName":"validate_Frequencies","definition":"my"},{"containerName":"validate_Frequencies","localvar":"my","kind":13,"name":"%freq","line":306,"definition":"my"},{"line":306,"name":"$self","containerName":"validate_Frequencies","kind":13},{"line":306,"name":"get_Allele_Frequencies","kind":12,"containerName":"validate_Frequencies"},{"definition":"my","name":"$f","containerName":"validate_Frequencies","localvar":"my","kind":13,"line":307},{"name":"%freq","containerName":"validate_Frequencies","kind":13,"line":307},{"kind":13,"containerName":"validate_Frequencies","name":"$sum","line":308},{"line":308,"kind":13,"containerName":"validate_Frequencies","name":"$f"},{"line":310,"kind":13,"containerName":"validate_Frequencies","name":"$strict"},{"line":310,"name":"$sum","kind":13,"containerName":"validate_Frequencies"},{"line":310,"kind":13,"containerName":"validate_Frequencies","name":"$sum"}],"containerName":"main::","name":"validate_Frequencies","definition":"sub","detail":"($self,@args)"}]}