{"vars":[{"containerName":"","kind":2,"name":"base","line":85},{"detail":"($class,@args)","definition":"sub","name":"new","containerName":"main::","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"new","name":"$class","line":99},{"containerName":"new","kind":13,"name":"@args","line":99},{"line":101,"localvar":"my","kind":13,"containerName":"new","name":"$self","definition":"my"},{"containerName":"new","kind":13,"name":"$class","line":101},{"name":"@args","containerName":"new","kind":13,"line":101},{"definition":"my","line":102,"kind":13,"localvar":"my","containerName":"new","name":"$haploid"},{"line":102,"name":"$self","containerName":"new","kind":13},{"line":102,"containerName":"new","kind":12,"name":"_rearrange"},{"line":102,"name":"@args","containerName":"new","kind":13},{"kind":13,"containerName":"new","name":"$haploid","line":103},{"name":"$self","kind":13,"containerName":"new","line":103},{"line":103,"name":"haploid_status","kind":12,"containerName":"new"},{"name":"$self","kind":13,"containerName":"new","line":104}],"signature":{"documentation":"1;\n# $Id: PopStats.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::PopStats\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::PopStats - A collection of methods for calculating\nstatistics about a population or sets of populations\n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::PopStats;\n  my $stats = Bio::PopGen::PopStats->new(); # add -haploid => 1 \n                                           # to process haploid data\n\n=head1 DESCRIPTION\n\nCalculate various population structure statistics, most notably Wright's Fst.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, matthew.hahn-at-duke.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::PopStats;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::PopStats->new();\n Function: Builds a new Bio::PopGen::PopStats object \n Returns : an instance of Bio::PopGen::PopStats\n Args    : -haploid => 1 (if want to use haploid calculations)","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"},"range":{"end":{"line":105,"character":9999},"start":{"line":98,"character":0}},"kind":12,"line":98},{"name":"SUPER","containerName":"new","kind":12,"line":101},{"name":"haploid_status","containerName":"main::","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"haploid_status","kind":13,"line":121},{"line":122,"kind":13,"containerName":"haploid_status","name":"$self"},{"name":"$self","containerName":"haploid_status","kind":13,"line":123}],"definition":"sub","range":{"end":{"line":124,"character":9999},"start":{"line":120,"character":0}},"kind":12,"line":120},{"children":[{"definition":"my","kind":13,"localvar":"my","containerName":"Fst","name":"$self","line":145},{"containerName":"Fst","kind":13,"name":"$populations","line":145},{"line":145,"name":"$markernames","kind":13,"containerName":"Fst"},{"line":147,"containerName":"Fst","kind":13,"name":"$populations"},{"line":148,"kind":13,"containerName":"Fst","name":"$populations"},{"containerName":"Fst","kind":13,"name":"$self","line":149},{"line":149,"name":"warn","kind":12,"containerName":"Fst"},{"line":151,"containerName":"Fst","kind":13,"name":"$markernames"},{"containerName":"Fst","kind":13,"name":"$markernames","line":152},{"line":153,"containerName":"Fst","kind":13,"name":"$self"},{"containerName":"Fst","kind":12,"name":"warn","line":153},{"name":"$num_sub_pops","containerName":"Fst","localvar":"my","kind":13,"line":156,"definition":"my"},{"kind":13,"containerName":"Fst","name":"$populations","line":156},{"name":"$num_sub_pops","containerName":"Fst","kind":13,"line":158},{"line":159,"name":"$self","containerName":"Fst","kind":13},{"kind":12,"containerName":"Fst","name":"warn","line":159},{"definition":"my","localvar":"my","kind":13,"containerName":"Fst","name":"$Fst","line":166},{"line":167,"kind":13,"localvar":"my","containerName":"Fst","name":"$TS_sub1","definition":"my"},{"line":167,"name":"$TS_sub2","kind":13,"containerName":"Fst"},{"definition":"my","name":"$marker","localvar":"my","kind":13,"containerName":"Fst","line":169},{"name":"$markernames","containerName":"Fst","kind":13,"line":169},{"localvar":"my","kind":13,"containerName":"Fst","name":"%allAlleles","line":171,"definition":"my"},{"definition":"my","line":172,"name":"$allele","kind":13,"localvar":"my","containerName":"Fst"},{"name":"get_Alleles","kind":12,"containerName":"Fst","line":172},{"name":"get_Genotypes","kind":12,"containerName":"Fst","line":173},{"line":173,"name":"$marker","containerName":"Fst","kind":13},{"line":173,"name":"$populations","kind":13,"containerName":"Fst"},{"containerName":"Fst","kind":13,"name":"$allAlleles","line":174},{"name":"$allele","kind":13,"containerName":"Fst","line":174},{"line":176,"name":"@alleles","containerName":"Fst","localvar":"my","kind":13,"definition":"my"},{"line":176,"name":"%allAlleles","containerName":"Fst","kind":13},{"localvar":"my","containerName":"Fst","kind":13,"name":"$allele_name","line":178,"definition":"my"},{"name":"@alleles","containerName":"Fst","kind":13,"line":178},{"line":179,"name":"$avg_samp_size","localvar":"my","kind":13,"containerName":"Fst","definition":"my"},{"definition":"my","kind":13,"localvar":"my","containerName":"Fst","name":"$avg_allele_freq","line":180},{"line":182,"localvar":"my","containerName":"Fst","kind":13,"name":"$total_samples_squared","definition":"my"},{"definition":"my","name":"$sum_heterozygote","localvar":"my","containerName":"Fst","kind":13,"line":183},{"name":"@marker_freqs","localvar":"my","kind":13,"containerName":"Fst","line":185,"definition":"my"},{"definition":"my","name":"$pop","localvar":"my","kind":13,"containerName":"Fst","line":191},{"kind":13,"containerName":"Fst","name":"$populations","line":191},{"line":192,"kind":13,"localvar":"my","containerName":"Fst","name":"$s","definition":"my"},{"line":192,"containerName":"Fst","kind":13,"name":"$pop"},{"line":192,"containerName":"Fst","kind":12,"name":"get_number_individuals"},{"kind":13,"containerName":"Fst","name":"$marker","line":192},{"line":194,"containerName":"Fst","kind":13,"name":"$avg_samp_size"},{"name":"$s","containerName":"Fst","kind":13,"line":194},{"name":"$total_samples_squared","containerName":"Fst","kind":13,"line":195},{"name":"$s","containerName":"Fst","kind":13,"line":195},{"definition":"my","kind":13,"localvar":"my","containerName":"Fst","name":"$markerobj","line":197},{"line":197,"name":"$pop","kind":13,"containerName":"Fst"},{"containerName":"Fst","kind":12,"name":"get_Marker","line":197},{"line":197,"name":"$marker","containerName":"Fst","kind":13},{"line":198,"kind":13,"containerName":"Fst","name":"$markerobj"},{"containerName":"Fst","kind":13,"name":"$self","line":199},{"name":"warn","kind":12,"containerName":"Fst","line":199},{"line":200,"containerName":"Fst","kind":13,"name":"$pop"},{"line":200,"name":"name","containerName":"Fst","kind":12},{"localvar":"my","containerName":"Fst","kind":13,"name":"$freq_homozygotes","line":204,"definition":"my"},{"name":"$pop","containerName":"Fst","kind":13,"line":205},{"kind":12,"containerName":"Fst","name":"get_Frequency_Homozygotes","line":205},{"kind":13,"containerName":"Fst","name":"$marker","line":205},{"line":205,"name":"$allele_name","containerName":"Fst","kind":13},{"line":206,"name":"%af","containerName":"Fst","localvar":"my","kind":13,"definition":"my"},{"name":"$markerobj","kind":13,"containerName":"Fst","line":206},{"containerName":"Fst","kind":12,"name":"get_Allele_Frequencies","line":206},{"line":207,"kind":13,"localvar":"my","containerName":"Fst","name":"$all_freq","definition":"my"},{"line":207,"kind":13,"containerName":"Fst","name":"$af"},{"line":207,"name":"$allele_name","kind":13,"containerName":"Fst"},{"line":209,"containerName":"Fst","kind":13,"name":"$avg_allele_freq"},{"name":"$s","containerName":"Fst","kind":13,"line":209},{"line":209,"kind":13,"containerName":"Fst","name":"$all_freq"},{"name":"$sum_heterozygote","containerName":"Fst","kind":13,"line":210},{"name":"$s","kind":13,"containerName":"Fst","line":210},{"name":"$all_freq","kind":13,"containerName":"Fst","line":210},{"line":210,"kind":13,"containerName":"Fst","name":"$freq_homozygotes"},{"kind":13,"containerName":"Fst","name":"@marker_freqs","line":212},{"line":212,"containerName":"Fst","kind":13,"name":"%af"},{"line":214,"name":"$total_samples","localvar":"my","kind":13,"containerName":"Fst","definition":"my"},{"name":"$avg_samp_size","kind":13,"containerName":"Fst","line":214},{"containerName":"Fst","kind":13,"name":"$avg_samp_size","line":215},{"kind":13,"containerName":"Fst","name":"$num_sub_pops","line":215},{"line":216,"containerName":"Fst","kind":13,"name":"$avg_allele_freq"},{"name":"$total_samples","containerName":"Fst","kind":13,"line":216},{"definition":"my","localvar":"my","containerName":"Fst","kind":13,"name":"$adj_samp_size","line":219},{"line":219,"kind":13,"containerName":"Fst","name":"$num_sub_pops"},{"line":220,"containerName":"Fst","kind":13,"name":"$total_samples"},{"line":220,"kind":13,"containerName":"Fst","name":"$total_samples_squared"},{"line":220,"name":"$total_samples","kind":13,"containerName":"Fst"},{"definition":"my","localvar":"my","containerName":"Fst","kind":13,"name":"$variance","line":222},{"line":223,"localvar":"my","containerName":"Fst","kind":13,"name":"$sum_variance","definition":"my"},{"definition":"my","name":"$i","localvar":"my","kind":13,"containerName":"Fst","line":224},{"definition":"my","line":225,"name":"$pop","localvar":"my","kind":13,"containerName":"Fst"},{"line":225,"name":"$populations","kind":13,"containerName":"Fst"},{"definition":"my","name":"$s","kind":13,"localvar":"my","containerName":"Fst","line":226},{"line":226,"name":"$pop","containerName":"Fst","kind":13},{"name":"get_number_individuals","containerName":"Fst","kind":12,"line":226},{"kind":13,"containerName":"Fst","name":"$marker","line":226},{"definition":"my","name":"%af","localvar":"my","containerName":"Fst","kind":13,"line":227},{"line":227,"containerName":"Fst","kind":13,"name":"$marker_freqs"},{"line":227,"name":"$i","containerName":"Fst","kind":13},{"name":"$sum_variance","kind":13,"containerName":"Fst","line":228},{"name":"$s","kind":13,"containerName":"Fst","line":228},{"kind":13,"containerName":"Fst","name":"$af","line":228},{"name":"$allele_name","containerName":"Fst","kind":13,"line":228},{"line":229,"containerName":"Fst","kind":13,"name":"$avg_allele_freq"},{"name":"$variance","kind":13,"containerName":"Fst","line":231},{"line":231,"name":"$num_sub_pops","containerName":"Fst","kind":13},{"line":231,"name":"$avg_samp_size","kind":13,"containerName":"Fst"},{"name":"$sum_variance","containerName":"Fst","kind":13,"line":231},{"definition":"my","line":234,"name":"$freq_heterozygote","localvar":"my","containerName":"Fst","kind":13},{"containerName":"Fst","kind":13,"name":"$sum_heterozygote","line":234},{"line":234,"containerName":"Fst","kind":13,"name":"$total_samples"},{"kind":13,"containerName":"Fst","name":"$self","line":236},{"name":"haploid_status","kind":12,"containerName":"Fst","line":236},{"line":239,"localvar":"my","containerName":"Fst","kind":13,"name":"$T_sub1","definition":"my"},{"name":"$variance","kind":13,"containerName":"Fst","line":239},{"line":240,"kind":13,"containerName":"Fst","name":"$avg_samp_size"},{"containerName":"Fst","kind":13,"name":"$avg_allele_freq","line":241},{"line":241,"kind":13,"containerName":"Fst","name":"$avg_allele_freq"},{"line":242,"name":"$num_sub_pops","kind":13,"containerName":"Fst"},{"kind":13,"containerName":"Fst","name":"$num_sub_pops","line":242},{"name":"$variance","kind":13,"containerName":"Fst","line":242},{"definition":"my","line":243,"localvar":"my","containerName":"Fst","kind":13,"name":"$T_sub2"},{"line":243,"name":"$adj_samp_size","kind":13,"containerName":"Fst"},{"containerName":"Fst","kind":13,"name":"$avg_samp_size","line":243},{"line":244,"kind":13,"containerName":"Fst","name":"$avg_allele_freq"},{"kind":13,"containerName":"Fst","name":"$avg_allele_freq","line":244},{"line":245,"name":"$num_sub_pops","kind":13,"containerName":"Fst"},{"kind":13,"containerName":"Fst","name":"$avg_samp_size","line":246},{"line":246,"name":"$adj_samp_size","containerName":"Fst","kind":13},{"name":"$avg_samp_size","kind":13,"containerName":"Fst","line":247},{"name":"$variance","containerName":"Fst","kind":13,"line":248},{"kind":13,"containerName":"Fst","name":"$num_sub_pops","line":248},{"containerName":"Fst","kind":13,"name":"$TS_sub1","line":255},{"kind":13,"containerName":"Fst","name":"$T_sub1","line":255},{"line":256,"containerName":"Fst","kind":13,"name":"$TS_sub2"},{"name":"$T_sub2","containerName":"Fst","kind":13,"line":256},{"line":259,"name":"$S_sub1","localvar":"my","containerName":"Fst","kind":13,"definition":"my"},{"name":"$variance","kind":13,"containerName":"Fst","line":259},{"line":259,"name":"$avg_samp_size","containerName":"Fst","kind":13},{"kind":13,"containerName":"Fst","name":"$avg_allele_freq","line":260},{"kind":13,"containerName":"Fst","name":"$avg_allele_freq","line":261},{"name":"$num_sub_pops","containerName":"Fst","kind":13,"line":262},{"name":"$num_sub_pops","containerName":"Fst","kind":13,"line":262},{"line":263,"containerName":"Fst","kind":13,"name":"$variance"},{"name":"$freq_heterozygote","containerName":"Fst","kind":13,"line":263},{"definition":"my","line":264,"localvar":"my","kind":13,"containerName":"Fst","name":"$S_sub2"},{"kind":13,"containerName":"Fst","name":"$avg_allele_freq","line":264},{"containerName":"Fst","kind":13,"name":"$avg_allele_freq","line":264},{"name":"$avg_samp_size","kind":13,"containerName":"Fst","line":265},{"line":265,"kind":13,"containerName":"Fst","name":"$num_sub_pops"},{"line":265,"kind":13,"containerName":"Fst","name":"$avg_samp_size"},{"line":266,"name":"$num_sub_pops","containerName":"Fst","kind":13},{"containerName":"Fst","kind":13,"name":"$avg_samp_size","line":266},{"kind":13,"containerName":"Fst","name":"$adj_samp_size","line":266},{"name":"$avg_samp_size","containerName":"Fst","kind":13,"line":267},{"name":"$avg_allele_freq","containerName":"Fst","kind":13,"line":267},{"containerName":"Fst","kind":13,"name":"$avg_allele_freq","line":268},{"containerName":"Fst","kind":13,"name":"$avg_samp_size","line":269},{"kind":13,"containerName":"Fst","name":"$avg_samp_size","line":269},{"name":"$num_sub_pops","kind":13,"containerName":"Fst","line":270},{"kind":13,"containerName":"Fst","name":"$avg_samp_size","line":271},{"name":"$adj_samp_size","containerName":"Fst","kind":13,"line":272},{"line":272,"name":"$variance","containerName":"Fst","kind":13},{"kind":13,"containerName":"Fst","name":"$num_sub_pops","line":273},{"line":273,"containerName":"Fst","kind":13,"name":"$avg_samp_size"},{"kind":13,"containerName":"Fst","name":"$adj_samp_size","line":273},{"name":"$avg_samp_size","containerName":"Fst","kind":13,"line":274},{"containerName":"Fst","kind":13,"name":"$adj_samp_size","line":274},{"line":275,"containerName":"Fst","kind":13,"name":"$freq_heterozygote"},{"definition":"my","line":277,"localvar":"my","containerName":"Fst","kind":13,"name":"$S_sub3"},{"line":277,"name":"$adj_samp_size","kind":13,"containerName":"Fst"},{"kind":13,"containerName":"Fst","name":"$avg_samp_size","line":277},{"containerName":"Fst","kind":13,"name":"$freq_heterozygote","line":278},{"line":283,"containerName":"Fst","kind":13,"name":"$TS_sub1"},{"name":"$S_sub1","kind":13,"containerName":"Fst","line":283},{"line":284,"name":"$TS_sub2","kind":13,"containerName":"Fst"},{"line":284,"name":"$S_sub2","containerName":"Fst","kind":13}],"containerName":"main::","name":"Fst","definition":"sub","detail":"($self,$populations,$markernames)","line":144,"range":{"start":{"character":0,"line":144},"end":{"character":9999,"line":287}},"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$populations"},{"label":"$markernames"}],"documentation":"1;\n# $Id: PopStats.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::PopStats\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::PopStats - A collection of methods for calculating\nstatistics about a population or sets of populations\n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::PopStats;\n  my $stats = Bio::PopGen::PopStats->new(); # add -haploid => 1 \n                                           # to process haploid data\n\n=head1 DESCRIPTION\n\nCalculate various population structure statistics, most notably Wright's Fst.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, matthew.hahn-at-duke.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::PopStats;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::PopStats->new();\n Function: Builds a new Bio::PopGen::PopStats object \n Returns : an instance of Bio::PopGen::PopStats\n Args    : -haploid => 1 (if want to use haploid calculations)\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($haploid) = $self->_rearrange([qw(HAPLOID)],@args);\n  if( $haploid ) { $self->haploid_status(1) }\n  return $self;\n}\n\n\n=head2 haploid_status\n\n Title   : haploid_status\n Usage   : $obj->haploid_status($newval)\n Function: Boolean value for whether or not to do haploid \n           or diploid calculations, where appropriate\n Returns : Boolean\n Args    : on set, new boolean value optional)\n\n\n\nsub haploid_status{\n    my $self = shift;\n    return $self->{'haploid_status'} = shift if @_;\n    return $self->{'haploid_status'};\n}\n\n\n# Implementation provided my Matthew Hahn, massaged by Jason Stajich\n\n=head2 Fst\n\n Title   : Fst\n Usage   : my $fst = $stats->Fst(\\@populations,\\@markernames)\n Function: Calculate Wright's Fst based on a set of sub-populations\n           and specific markers\n Returns : Fst value (a value between 0 and 1)\n Args    : Arrayref of populations to process\n           Arrayref of marker names to process\n Note    : Based on diploid method in Weir BS, Genetics Data Analysis II, 1996\n           page 178.\n\n' make emacs happy here","label":"Fst($self,$populations,$markernames)"}},{"kind":13,"containerName":null,"name":"$Fst","line":291},{"line":291,"kind":13,"containerName":null,"name":"$TS_sub1"},{"name":"$TS_sub2","kind":13,"containerName":null,"line":291},{"line":293,"name":"$Fst","kind":13,"containerName":null}],"version":5}