{"vars":[{"name":"base","kind":2,"containerName":"","line":75},{"signature":{"documentation":"1; \n# $Id $\n#\n# BioPerl module for Bio::PopGen::GenotypeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::GenotypeI - A marker and alleles for a specific individual\n\n=head1 SYNOPSIS\n\nGive standard usage here\n\n=head1 DESCRIPTION\n\nDescribe the interface here\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::GenotypeI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head2 marker_name\n\n Title   : marker_name\n Usage   : my $name = $genotype->marker_name();\n Function: Get the marker name for a genotype result\n Returns : string\n Args    : none","parameters":[{"label":"$self"}],"label":"marker_name($self)"},"kind":12,"range":{"end":{"character":9999,"line":91},"start":{"line":88,"character":0}},"line":88,"detail":"($self)","definition":"sub","name":"marker_name","containerName":"main::","children":[{"definition":"my","line":89,"name":"$self","localvar":"my","kind":13,"containerName":"marker_name"},{"name":"$self","containerName":"marker_name","kind":13,"line":90},{"line":90,"kind":12,"containerName":"marker_name","name":"throw_not_implemented"}]},{"line":107,"kind":12,"range":{"start":{"line":107,"character":0},"end":{"line":110,"character":9999}},"signature":{"parameters":[{"label":"$self"}],"documentation":"1; \n# $Id $\n#\n# BioPerl module for Bio::PopGen::GenotypeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::GenotypeI - A marker and alleles for a specific individual\n\n=head1 SYNOPSIS\n\nGive standard usage here\n\n=head1 DESCRIPTION\n\nDescribe the interface here\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::GenotypeI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head2 marker_name\n\n Title   : marker_name\n Usage   : my $name = $genotype->marker_name();\n Function: Get the marker name for a genotype result\n Returns : string\n Args    : none\n\n\n\nsub marker_name{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 individual_id\n\n Title   : individual_id\n Usage   : my $indid = $genotype->individual_id();\n Function: Gets the individual id associated with a genotype\n           This is effectively a back reference since we will typically\n           associate a genotype with an individual with an \n           individual HAS-A genotype relationship.\n Returns : unique id string for an individual\n Args    : none","label":"individual_id($self)"},"children":[{"definition":"my","kind":13,"localvar":"my","containerName":"individual_id","name":"$self","line":108},{"line":109,"name":"$self","kind":13,"containerName":"individual_id"},{"containerName":"individual_id","kind":12,"name":"throw_not_implemented","line":109}],"containerName":"main::","name":"individual_id","definition":"sub","detail":"($self)"},{"signature":{"documentation":"1; \n# $Id $\n#\n# BioPerl module for Bio::PopGen::GenotypeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::GenotypeI - A marker and alleles for a specific individual\n\n=head1 SYNOPSIS\n\nGive standard usage here\n\n=head1 DESCRIPTION\n\nDescribe the interface here\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::GenotypeI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head2 marker_name\n\n Title   : marker_name\n Usage   : my $name = $genotype->marker_name();\n Function: Get the marker name for a genotype result\n Returns : string\n Args    : none\n\n\n\nsub marker_name{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 individual_id\n\n Title   : individual_id\n Usage   : my $indid = $genotype->individual_id();\n Function: Gets the individual id associated with a genotype\n           This is effectively a back reference since we will typically\n           associate a genotype with an individual with an \n           individual HAS-A genotype relationship.\n Returns : unique id string for an individual\n Args    : none\n\n\n\nsub individual_id{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 annotation\n\n Title   : annotation\n Usage   : my $annotation_collection = $genotype->annotation;\n Function: Get/set a Bio::AnnotationCollectionI for this genotype\n Returns : Bio::AnnotationCollectionI object\n Args    : [optional set] Bio::AnnotationCollectionI object","parameters":[{"label":"$self"}],"label":"annotation($self)"},"range":{"end":{"line":127,"character":9999},"start":{"character":0,"line":124}},"kind":12,"line":124,"detail":"($self)","definition":"sub","containerName":"main::","name":"annotation","children":[{"definition":"my","containerName":"annotation","localvar":"my","kind":13,"name":"$self","line":125},{"line":126,"name":"$self","containerName":"annotation","kind":13},{"name":"throw_not_implemented","kind":12,"containerName":"annotation","line":126}]},{"line":140,"range":{"end":{"character":9999,"line":143},"start":{"character":0,"line":140}},"kind":12,"signature":{"label":"get_Alleles($self)","parameters":[{"label":"$self"}],"documentation":"1; \n# $Id $\n#\n# BioPerl module for Bio::PopGen::GenotypeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::GenotypeI - A marker and alleles for a specific individual\n\n=head1 SYNOPSIS\n\nGive standard usage here\n\n=head1 DESCRIPTION\n\nDescribe the interface here\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::GenotypeI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head2 marker_name\n\n Title   : marker_name\n Usage   : my $name = $genotype->marker_name();\n Function: Get the marker name for a genotype result\n Returns : string\n Args    : none\n\n\n\nsub marker_name{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 individual_id\n\n Title   : individual_id\n Usage   : my $indid = $genotype->individual_id();\n Function: Gets the individual id associated with a genotype\n           This is effectively a back reference since we will typically\n           associate a genotype with an individual with an \n           individual HAS-A genotype relationship.\n Returns : unique id string for an individual\n Args    : none\n\n\n\nsub individual_id{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 annotation\n\n Title   : annotation\n Usage   : my $annotation_collection = $genotype->annotation;\n Function: Get/set a Bio::AnnotationCollectionI for this genotype\n Returns : Bio::AnnotationCollectionI object\n Args    : [optional set] Bio::AnnotationCollectionI object\n\n\n\nsub annotation{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 get_Alleles\n\n Title   : get_Alleles\n Usage   : my @alleles = $genotype->get_Alleles();\n Function: Get the alleles for a given marker and individual\n Returns : array of alleles (strings in many implementations)\n Args    : none"},"children":[{"line":141,"kind":13,"localvar":"my","containerName":"get_Alleles","name":"$self","definition":"my"},{"kind":13,"containerName":"get_Alleles","name":"$self","line":142},{"containerName":"get_Alleles","kind":12,"name":"throw_not_implemented","line":142}],"containerName":"main::","name":"get_Alleles","definition":"sub","detail":"($self)"}],"version":5}