{"vars":[{"name":"base","kind":2,"containerName":"","line":63},{"signature":{"label":"new($pkg,@args)","documentation":"1;\n# $Id: Factory.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork::Factory\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork::Factory - Module to sequentially generate\nPhylogenetic Networks\n\n=head1 SYNOPSIS\n\n use strict;\n use warnings;\n\n use Bio::PhyloNetwork;\n use Bio::PhyloNetwork::Factory;\n\n # Will generate sequentially all the 4059 binary tree-child phylogenetic\n # networks with 4 leaves\n\n my $factory=Bio::PhyloNetwork::Factory->new(-numleaves=>4);\n\n my @nets;\n\n while (my $net=$factory->next_network()) {\n   push @nets,$net;\n   print \"\".(scalar @nets).\": \".$net->eNewick().\"\\n\";\n }\n\n=head1 DESCRIPTION\n\nSequentially builds a (binary tree-child) phylogenetic network each time\nnext_network is called.\n\n=head1 AUTHOR\n\nGabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n\n=head1 SEE ALSO\n\nL<Bio::PhyloNetwork>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork::Factory;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork;\nuse Bio::PhyloNetwork::TreeFactory;\n\n=head2 new\n\n Title   : new\n Usage   : my $factory = new Bio::PhyloNetwork::Factory();\n Function: Creates a new Bio::PhyloNetwork::Factory\n Returns : Bio::PhyloNetwork::RandomFactory\n Args    : -numleaves => integer\n            OR\n           -leaves => reference to an array (of leaves names)\n           -numhybrids => integer [default = numleaves -1]\n           -recurse => boolean [optional]\n\nReturns a Bio::PhyloNetwork::Factory object. Such an object will\nsequentially create binary tree-child phylogenetic networks\neach time next_network is called.\n\nIf the parameter -leaves=E<gt>\\@leaves is given, then the set of leaves of\nthese networks will be @leaves. If it is given the parameter\n-numleaves=E<gt>$numleaves, then the set of leaves will be \"l1\"...\"l$numleaves\".\n\nIf the parameter -numhybrids=E<gt>$numhybrids is given, then the generated\nnetworks will have at most $numhybrids hybrid nodes. Note that, necessarily,\n$numhybrids E<lt> $numleaves.\n\nIf the parameter -recurse=E<gt>1 is given, then all networks with number of hybrid\nnodes less or equal to $numhybrids will be given; otherwise only those with\nexactly $numhybrids hybrid nodes.","parameters":[{"label":"$pkg"},{"label":"@args"}]},"kind":12,"range":{"start":{"line":98,"character":0},"end":{"character":9999,"line":146}},"line":98,"detail":"($pkg,@args)","definition":"sub","containerName":"main::","name":"new","children":[{"line":99,"name":"$pkg","localvar":"my","containerName":"new","kind":13,"definition":"my"},{"line":99,"name":"@args","kind":13,"containerName":"new"},{"localvar":"my","kind":13,"containerName":"new","name":"$self","line":101,"definition":"my"},{"line":101,"containerName":"new","kind":13,"name":"$pkg"},{"line":101,"kind":13,"containerName":"new","name":"@args"},{"name":"$leavesR","localvar":"my","containerName":"new","kind":13,"line":103,"definition":"my"},{"kind":13,"containerName":"new","name":"$numleaves","line":103},{"line":103,"name":"$numhybrids","kind":13,"containerName":"new"},{"name":"$recurse","kind":13,"containerName":"new","line":103},{"line":104,"containerName":"new","kind":13,"name":"$self"},{"line":104,"name":"_rearrange","containerName":"new","kind":12},{"containerName":"new","kind":13,"name":"@args","line":107},{"definition":"my","line":108,"localvar":"my","kind":13,"containerName":"new","name":"@leaves"},{"line":109,"kind":13,"containerName":"new","name":"$leavesR"},{"name":"$numleaves","containerName":"new","kind":13,"line":109},{"containerName":"new","kind":13,"name":"@leaves","line":110},{"line":110,"name":"$numleaves","kind":13,"containerName":"new"},{"containerName":"new","kind":13,"name":"$leavesR","line":111},{"line":111,"containerName":"new","kind":13,"name":"@leaves"},{"line":113,"containerName":"new","kind":13,"name":"$leavesR"},{"line":114,"name":"$self","kind":13,"containerName":"new"},{"line":114,"name":"throw","kind":12,"containerName":"new"},{"line":116,"kind":13,"containerName":"new","name":"@leaves"},{"name":"$leavesR","containerName":"new","kind":13,"line":116},{"line":117,"kind":13,"containerName":"new","name":"$self"},{"name":"$leavesR","kind":13,"containerName":"new","line":117},{"line":118,"name":"$numleaves","kind":13,"containerName":"new"},{"line":118,"kind":13,"containerName":"new","name":"@leaves"},{"containerName":"new","kind":13,"name":"$self","line":119},{"line":119,"name":"$numleaves","containerName":"new","kind":13},{"name":"$recurse","kind":13,"containerName":"new","line":121},{"line":122,"containerName":"new","kind":13,"name":"$numhybrids"},{"line":123,"kind":13,"containerName":"new","name":"$numhybrids"},{"containerName":"new","kind":13,"name":"$numleaves","line":123},{"line":124,"containerName":"new","kind":13,"name":"$recurse"},{"name":"$self","containerName":"new","kind":13,"line":126},{"kind":13,"containerName":"new","name":"$recurse","line":126},{"line":127,"name":"$self","kind":13,"containerName":"new"},{"name":"$numhybrids","containerName":"new","kind":13,"line":127},{"kind":13,"containerName":"new","name":"$numhybrids","line":128},{"line":129,"kind":12,"containerName":"new","name":"new"},{"containerName":"new","kind":13,"name":"@leaves","line":129},{"definition":"my","line":131,"name":"$parent","localvar":"my","kind":13,"containerName":"new"},{"name":"$numhybrids","containerName":"new","kind":13,"line":132},{"name":"$parent","kind":13,"containerName":"new","line":133},{"line":133,"kind":13,"containerName":"new","name":"$pkg"},{"containerName":"new","kind":13,"name":"@leaves","line":133},{"line":134,"name":"$numhybrids","containerName":"new","kind":13},{"line":135,"name":"$recurse","containerName":"new","kind":13},{"name":"$parent","containerName":"new","kind":13,"line":138},{"line":138,"name":"new","containerName":"new","kind":12},{"line":138,"containerName":"new","kind":13,"name":"@leaves"},{"kind":13,"containerName":"new","name":"$self","line":140},{"line":140,"containerName":"new","kind":13,"name":"$parent"},{"line":141,"name":"$oldnet","localvar":"my","containerName":"new","kind":13,"definition":"my"},{"line":141,"name":"$parent","containerName":"new","kind":13},{"name":"next_network","containerName":"new","kind":12,"line":141},{"name":"$self","kind":13,"containerName":"new","line":142},{"kind":13,"containerName":"new","name":"$oldnet","line":142},{"containerName":"new","kind":13,"name":"$self","line":143},{"containerName":"new","kind":12,"name":"update","line":143},{"kind":13,"containerName":"new","name":"$self","line":144},{"name":"$self","kind":13,"containerName":"new","line":145},{"containerName":"new","kind":13,"name":"$pkg","line":145}]},{"name":"TreeFactory","kind":2,"containerName":"Bio::PhyloNetwork::Bio::PhyloNetwork","line":99},{"line":101,"name":"SUPER","kind":12,"containerName":"new"},{"line":117,"name":"leaves","kind":12},{"kind":12,"name":"numleaves","line":119},{"kind":12,"name":"recurse","line":126},{"line":127,"name":"numhybrids","kind":12},{"line":129,"name":"Bio","kind":12,"containerName":"PhyloNetwork::TreeFactory"},{"name":"Bio","containerName":"PhyloNetwork::TreeFactory","kind":12,"line":138},{"name":"parent","kind":12,"line":140},{"line":142,"name":"oldnet","kind":12},{"name":"found","kind":12,"line":144},{"definition":"sub","detail":"($self)","children":[{"line":149,"kind":13,"localvar":"my","containerName":"update","name":"$self","definition":"my"},{"definition":"my","line":151,"name":"@candidates","containerName":"update","localvar":"my","kind":13},{"line":151,"containerName":"update","kind":13,"name":"$self"},{"line":151,"containerName":"update","kind":12,"name":"edges"},{"name":"$self","kind":13,"containerName":"update","line":152},{"line":152,"name":"@candidates","containerName":"update","kind":13},{"name":"$self","containerName":"update","kind":13,"line":153},{"name":"@candidates","containerName":"update","kind":13,"line":153},{"line":154,"kind":13,"containerName":"update","name":"$self"},{"line":154,"name":"$self","kind":13,"containerName":"update"},{"line":155,"kind":13,"containerName":"update","name":"$self"}],"name":"update","containerName":"main::","signature":{"documentation":"","parameters":[{"label":"$self"}],"label":"update($self)"},"line":148,"kind":12,"range":{"end":{"line":156,"character":9999},"start":{"character":0,"line":148}}},{"kind":12,"name":"oldnet","line":151},{"kind":12,"name":"candidates","line":152},{"line":153,"name":"numcandidates","kind":12},{"line":154,"name":"index1","kind":12},{"line":154,"name":"recurse","kind":12},{"line":155,"name":"index2","kind":12},{"signature":{"label":"next_network($self)","documentation":"1;\n# $Id: Factory.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork::Factory\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork::Factory - Module to sequentially generate\nPhylogenetic Networks\n\n=head1 SYNOPSIS\n\n use strict;\n use warnings;\n\n use Bio::PhyloNetwork;\n use Bio::PhyloNetwork::Factory;\n\n # Will generate sequentially all the 4059 binary tree-child phylogenetic\n # networks with 4 leaves\n\n my $factory=Bio::PhyloNetwork::Factory->new(-numleaves=>4);\n\n my @nets;\n\n while (my $net=$factory->next_network()) {\n   push @nets,$net;\n   print \"\".(scalar @nets).\": \".$net->eNewick().\"\\n\";\n }\n\n=head1 DESCRIPTION\n\nSequentially builds a (binary tree-child) phylogenetic network each time\nnext_network is called.\n\n=head1 AUTHOR\n\nGabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n\n=head1 SEE ALSO\n\nL<Bio::PhyloNetwork>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork::Factory;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork;\nuse Bio::PhyloNetwork::TreeFactory;\n\n=head2 new\n\n Title   : new\n Usage   : my $factory = new Bio::PhyloNetwork::Factory();\n Function: Creates a new Bio::PhyloNetwork::Factory\n Returns : Bio::PhyloNetwork::RandomFactory\n Args    : -numleaves => integer\n            OR\n           -leaves => reference to an array (of leaves names)\n           -numhybrids => integer [default = numleaves -1]\n           -recurse => boolean [optional]\n\nReturns a Bio::PhyloNetwork::Factory object. Such an object will\nsequentially create binary tree-child phylogenetic networks\neach time next_network is called.\n\nIf the parameter -leaves=E<gt>\\@leaves is given, then the set of leaves of\nthese networks will be @leaves. If it is given the parameter\n-numleaves=E<gt>$numleaves, then the set of leaves will be \"l1\"...\"l$numleaves\".\n\nIf the parameter -numhybrids=E<gt>$numhybrids is given, then the generated\nnetworks will have at most $numhybrids hybrid nodes. Note that, necessarily,\n$numhybrids E<lt> $numleaves.\n\nIf the parameter -recurse=E<gt>1 is given, then all networks with number of hybrid\nnodes less or equal to $numhybrids will be given; otherwise only those with\nexactly $numhybrids hybrid nodes.\n\n\nsub new {\n  my ($pkg,@args)=@_;\n\n  my $self=$pkg->SUPER::new(@args);\n\n  my ($leavesR,$numleaves,$numhybrids,$recurse)=\n    $self->_rearrange([qw(LEAVES\n\t\t\t  NUMLEAVES\n\t\t\t  NUMHYBRIDS\n\t\t\t  RECURSE)],@args);\n  my @leaves;\n  if ((! defined $leavesR) && (defined $numleaves)) {\n    @leaves=map {\"l$_\"} (1..$numleaves);\n    $leavesR=\\@leaves;\n  }\n  if (! defined $leavesR) {\n    $self->throw(\"No leaves set neither numleaves given\");\n  }\n  @leaves=@$leavesR;\n  $self->{leaves}=$leavesR;\n  $numleaves=@leaves;\n  $self->{numleaves}=$numleaves;\n\n  $recurse ||= 0;\n  if (! defined $numhybrids) {\n    $numhybrids=$numleaves-1;\n    $recurse=1;\n  }\n  $self->{recurse}=$recurse;\n  $self->{numhybrids}=$numhybrids;\n  if ($numhybrids ==0) {\n    return Bio::PhyloNetwork::TreeFactory->new(-leaves=>\\@leaves);\n  }\n  my $parent;\n  if ($numhybrids > 1) {\n    $parent=new($pkg,'-leaves'=>\\@leaves,\n\t\t'-numhybrids'=>($numhybrids-1),\n\t\t'-recurse'=>($recurse));\n  }\n  else {\n    $parent=Bio::PhyloNetwork::TreeFactory->new(-leaves=>\\@leaves);\n  }\n  $self->{parent}=$parent;\n  my $oldnet=$parent->next_network();\n  $self->{oldnet}=$oldnet;\n  $self->update();\n  $self->{found}=[];\n  bless($self,$pkg);\n}\n\nsub update {\n  my ($self)=@_;\n\n  my @candidates=$self->{oldnet}->edges();\n  $self->{candidates}=\\@candidates;\n  $self->{numcandidates}=(scalar @candidates);\n  $self->{index1}=-$self->{recurse};\n  $self->{index2}=0;\n}\n\n=head2 next_network\n\n Title   : next_network\n Usage   : my $net=$factory->next_network()\n Function: returns a network\n Returns : Bio::PhyloNetwork\n Args    : none","parameters":[{"label":"$self"}]},"line":168,"kind":12,"range":{"end":{"line":213,"character":9999},"start":{"line":168,"character":0}},"definition":"sub","detail":"($self)","children":[{"line":169,"name":"$self","kind":13,"localvar":"my","containerName":"next_network","definition":"my"},{"definition":"my","name":"$numleaves","containerName":"next_network","localvar":"my","kind":13,"line":170},{"containerName":"next_network","kind":13,"name":"$self","line":170},{"name":"$numhybrids","localvar":"my","containerName":"next_network","kind":13,"line":171,"definition":"my"},{"line":171,"name":"$self","kind":13,"containerName":"next_network"},{"line":173,"kind":13,"containerName":"next_network","name":"$self"},{"line":174,"name":"$self","kind":13,"containerName":"next_network"},{"line":175,"containerName":"next_network","kind":13,"name":"$self"},{"containerName":"next_network","kind":13,"name":"$self","line":177},{"containerName":"next_network","kind":13,"name":"$self","line":177},{"name":"$self","kind":13,"containerName":"next_network","line":178},{"containerName":"next_network","kind":13,"name":"$self","line":179},{"line":181,"name":"$self","kind":13,"containerName":"next_network"},{"line":181,"containerName":"next_network","kind":13,"name":"$self"},{"definition":"my","line":182,"containerName":"next_network","localvar":"my","kind":13,"name":"$oldnet"},{"line":182,"name":"$self","containerName":"next_network","kind":13},{"name":"next_network","kind":12,"containerName":"next_network","line":182},{"containerName":"next_network","kind":13,"name":"$oldnet","line":183},{"line":186,"name":"$self","containerName":"next_network","kind":13},{"line":186,"name":"$oldnet","containerName":"next_network","kind":13},{"line":187,"kind":13,"containerName":"next_network","name":"$self"},{"line":187,"containerName":"next_network","kind":12,"name":"update"},{"kind":13,"containerName":"next_network","name":"$self","line":190},{"line":190,"name":"hybrid_nodes","containerName":"next_network","kind":12},{"name":"$self","containerName":"next_network","kind":13,"line":190},{"kind":13,"containerName":"next_network","name":"$self","line":191},{"line":192,"name":"$self","kind":13,"containerName":"next_network"},{"localvar":"my","containerName":"next_network","kind":13,"name":"$u1","line":195,"definition":"my"},{"kind":13,"containerName":"next_network","name":"$self","line":195},{"kind":13,"containerName":"next_network","name":"$self","line":195},{"definition":"my","line":196,"localvar":"my","kind":13,"containerName":"next_network","name":"$v1"},{"line":196,"name":"$self","kind":13,"containerName":"next_network"},{"containerName":"next_network","kind":13,"name":"$self","line":196},{"line":197,"name":"$u2","containerName":"next_network","localvar":"my","kind":13,"definition":"my"},{"containerName":"next_network","kind":13,"name":"$self","line":197},{"line":197,"kind":13,"containerName":"next_network","name":"$self"},{"kind":13,"localvar":"my","containerName":"next_network","name":"$v2","line":198,"definition":"my"},{"containerName":"next_network","kind":13,"name":"$self","line":198},{"line":198,"kind":13,"containerName":"next_network","name":"$self"},{"name":"$lbl","containerName":"next_network","localvar":"my","kind":13,"line":199,"definition":"my"},{"line":199,"name":"$self","kind":13,"containerName":"next_network"},{"name":"$self","kind":13,"containerName":"next_network","line":200},{"name":"is_attackable","containerName":"next_network","kind":12,"line":200},{"line":200,"containerName":"next_network","kind":13,"name":"$u1"},{"containerName":"next_network","kind":13,"name":"$v1","line":200},{"containerName":"next_network","kind":13,"name":"$u2","line":200},{"name":"$v2","kind":13,"containerName":"next_network","line":200},{"definition":"my","line":201,"name":"$net","kind":13,"localvar":"my","containerName":"next_network"},{"line":201,"name":"new","containerName":"next_network","kind":12},{"name":"$self","containerName":"next_network","kind":13,"line":201},{"line":201,"kind":12,"containerName":"next_network","name":"graph"},{"name":"$net","containerName":"next_network","kind":13,"line":202},{"name":"do_attack","kind":12,"containerName":"next_network","line":202},{"name":"$u1","containerName":"next_network","kind":13,"line":202},{"line":202,"name":"$v1","kind":13,"containerName":"next_network"},{"line":202,"name":"$u2","containerName":"next_network","kind":13},{"kind":13,"containerName":"next_network","name":"$v2","line":202},{"containerName":"next_network","kind":13,"name":"$lbl","line":202},{"name":"$self","containerName":"next_network","kind":13,"line":203},{"line":204,"name":"@found","containerName":"next_network","localvar":"my","kind":13,"definition":"my"},{"line":204,"kind":13,"containerName":"next_network","name":"$self"},{"definition":"my","line":205,"localvar":"my","kind":13,"containerName":"next_network","name":"$netant"},{"containerName":"next_network","kind":13,"name":"@found","line":205},{"line":206,"containerName":"next_network","kind":13,"name":"$net"},{"name":"is_mu_isomorphic","kind":12,"containerName":"next_network","line":206},{"containerName":"next_network","kind":13,"name":"$netant","line":206},{"line":210,"name":"@found","kind":13,"containerName":"next_network"},{"name":"$net","containerName":"next_network","kind":13,"line":210},{"line":211,"containerName":"next_network","kind":13,"name":"$self"},{"kind":13,"containerName":"next_network","name":"@found","line":211},{"containerName":"next_network","kind":13,"name":"$net","line":212}],"name":"next_network","containerName":"main::"},{"kind":12,"name":"numleaves","line":170},{"kind":12,"name":"numhybrids","line":171},{"line":172,"kind":12,"name":"START"},{"line":173,"kind":12,"name":"index1"},{"line":174,"kind":12,"name":"index1"},{"kind":12,"name":"oldnet","line":175},{"line":177,"kind":12,"name":"index1"},{"name":"numcandidates","kind":12,"line":177},{"name":"index2","kind":12,"line":178},{"line":179,"name":"index1","kind":12},{"line":181,"kind":12,"name":"index2"},{"kind":12,"name":"numcandidates","line":181},{"name":"parent","kind":12,"line":182},{"line":186,"name":"oldnet","kind":12},{"kind":12,"name":"START","line":188},{"line":190,"kind":12,"name":"oldnet"},{"name":"numhybrids","kind":12,"line":190},{"kind":12,"name":"candidates","line":191},{"line":192,"kind":12,"name":"numcandidates"},{"line":193,"kind":12,"name":"START"},{"line":195,"kind":12,"name":"candidates"},{"line":195,"name":"index1","kind":12},{"line":196,"name":"candidates","kind":12},{"kind":12,"name":"index1","line":196},{"line":197,"name":"candidates","kind":12},{"line":197,"name":"index2","kind":12},{"line":198,"name":"candidates","kind":12},{"line":198,"name":"index2","kind":12},{"line":199,"kind":12,"name":"numhybrids"},{"line":200,"kind":12,"name":"oldnet"},{"name":"Bio","kind":12,"containerName":"PhyloNetwork","line":201},{"name":"oldnet","kind":12,"line":201},{"line":203,"name":"index1","kind":12},{"line":204,"kind":12,"name":"found"},{"line":207,"name":"START","kind":12},{"line":211,"kind":12,"name":"found"},{"line":215,"kind":13,"containerName":null,"name":"%self"},{"kind":12,"name":"index1","line":215},{"line":216,"kind":12,"name":"START"}],"version":5}