{"version":5,"vars":[{"name":"base","containerName":"","kind":2,"line":112},{"signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: Correlate.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Correlate\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Correlate - Representation of a correlating phenotype in a given species\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::Correlate;\n\n  $co = Bio::Phenotype::Correlate->new( -name        => \"4(Tas1r3)\",\n                                        -description => \"mouse correlate of human phenotype MIM 605865\",\n                                        -species     => $mouse,\n                                        -type        => \"homolog\",\n                                        -comment     => \"type=homolog is putative\" );\n\n  print $co->name();\n  print $co->description();\n  print $co->species()->binomial();\n  print $co->type();\n  print $co->comment();\n\n  print $co->to_string();\n\n=head1 DESCRIPTION\n\nThis class models correlating phenotypes.\nIts creation was inspired by the OMIM database where many human phenotypes\nhave a correlating mouse phenotype. Therefore, this class is intended\nto be used together with a phenotype class. \n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\npackage Bio::Phenotype::Correlate;\nuse strict;\nuse Bio::Species;\n\nuse base qw(Bio::Root::Root);\n\n\n=head2 new\n\n Title   : new\n Usage   : $co = Bio::Phenotype::Correlate->new( -name        => \"4(Tas1r3)\",\n                                                 -description => \"mouse correlate of human phenotype MIM 605865\",\n                                                 -species     => $mouse,\n                                                 -type        => \"homolog\",\n                                                 -comment     => \"type=homolog is putative\" );                      \n Function: Creates a new Correlate object.\n Returns : A new Correlate object.\n Args    : -name        => a name or id\n           -description => a description\n           -species     => the species of this correlating phenotype [Bio::Species]\n           -type        => the type of correlation\n           -comment     => a comment"},"kind":12,"range":{"end":{"line":156,"character":9999},"start":{"character":0,"line":133}},"line":133,"detail":"($class,@args)","definition":"sub","name":"new","containerName":"main::","children":[{"line":135,"localvar":"my","containerName":"new","kind":13,"name":"$class","definition":"my"},{"line":135,"containerName":"new","kind":13,"name":"@args"},{"definition":"my","line":137,"localvar":"my","kind":13,"containerName":"new","name":"$self"},{"line":137,"name":"$class","kind":13,"containerName":"new"},{"line":137,"kind":13,"containerName":"new","name":"@args"},{"kind":13,"localvar":"my","containerName":"new","name":"$name","line":139,"definition":"my"},{"line":139,"name":"$desc","containerName":"new","kind":13},{"line":139,"name":"$species","kind":13,"containerName":"new"},{"name":"$type","kind":13,"containerName":"new","line":139},{"line":139,"name":"$comment","kind":13,"containerName":"new"},{"line":140,"name":"$self","kind":13,"containerName":"new"},{"name":"_rearrange","containerName":"new","kind":12,"line":140},{"containerName":"new","kind":13,"name":"@args","line":144},{"line":146,"name":"$self","containerName":"new","kind":13},{"line":146,"containerName":"new","kind":12,"name":"init"},{"line":148,"name":"$name","kind":13,"containerName":"new"},{"name":"$self","kind":13,"containerName":"new","line":148},{"containerName":"new","kind":12,"name":"name","line":148},{"line":148,"kind":13,"containerName":"new","name":"$name"},{"line":149,"name":"$desc","kind":13,"containerName":"new"},{"kind":13,"containerName":"new","name":"$self","line":149},{"line":149,"name":"description","kind":12,"containerName":"new"},{"containerName":"new","kind":13,"name":"$desc","line":149},{"containerName":"new","kind":13,"name":"$species","line":150},{"line":150,"containerName":"new","kind":13,"name":"$self"},{"line":150,"kind":12,"containerName":"new","name":"species"},{"name":"$species","containerName":"new","kind":13,"line":150},{"line":151,"name":"$type","kind":13,"containerName":"new"},{"line":151,"name":"$self","kind":13,"containerName":"new"},{"line":151,"kind":12,"containerName":"new","name":"type"},{"line":151,"kind":13,"containerName":"new","name":"$type"},{"kind":13,"containerName":"new","name":"$comment","line":152},{"name":"$self","containerName":"new","kind":13,"line":152},{"name":"comment","containerName":"new","kind":12,"line":152},{"line":152,"name":"$comment","kind":13,"containerName":"new"},{"line":154,"kind":13,"containerName":"new","name":"$self"}]},{"name":"SUPER","kind":12,"containerName":"new","line":137},{"signature":{"documentation":"1;\n# $Id: Correlate.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Correlate\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Correlate - Representation of a correlating phenotype in a given species\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::Correlate;\n\n  $co = Bio::Phenotype::Correlate->new( -name        => \"4(Tas1r3)\",\n                                        -description => \"mouse correlate of human phenotype MIM 605865\",\n                                        -species     => $mouse,\n                                        -type        => \"homolog\",\n                                        -comment     => \"type=homolog is putative\" );\n\n  print $co->name();\n  print $co->description();\n  print $co->species()->binomial();\n  print $co->type();\n  print $co->comment();\n\n  print $co->to_string();\n\n=head1 DESCRIPTION\n\nThis class models correlating phenotypes.\nIts creation was inspired by the OMIM database where many human phenotypes\nhave a correlating mouse phenotype. Therefore, this class is intended\nto be used together with a phenotype class. \n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\npackage Bio::Phenotype::Correlate;\nuse strict;\nuse Bio::Species;\n\nuse base qw(Bio::Root::Root);\n\n\n=head2 new\n\n Title   : new\n Usage   : $co = Bio::Phenotype::Correlate->new( -name        => \"4(Tas1r3)\",\n                                                 -description => \"mouse correlate of human phenotype MIM 605865\",\n                                                 -species     => $mouse,\n                                                 -type        => \"homolog\",\n                                                 -comment     => \"type=homolog is putative\" );                      \n Function: Creates a new Correlate object.\n Returns : A new Correlate object.\n Args    : -name        => a name or id\n           -description => a description\n           -species     => the species of this correlating phenotype [Bio::Species]\n           -type        => the type of correlation\n           -comment     => a comment\n\n\nsub new {\n\n    my( $class, @args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n \n    my ( $name, $desc, $species, $type, $comment )\n    = $self->_rearrange( [ qw( NAME\n                               DESCRIPTION\n                               SPECIES\n                               TYPE\n                               COMMENT ) ], @args );\n                         \n    $self->init();                     \n   \n    $name    && $self->name( $name );\n    $desc    && $self->description( $desc );\n    $species && $self->species( $species );\n    $type    && $self->type( $type );\n    $comment && $self->comment( $comment );\n   \n    return $self;\n    \n} # new\n\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $co->init();   \n Function: Initializes this Correlate to all \"\".\n Returns : \n Args    :","parameters":[{"label":"$self"}],"label":"init($self)"},"range":{"end":{"character":9999,"line":183},"start":{"character":0,"line":171}},"kind":12,"line":171,"detail":"($self)","definition":"sub","name":"init","containerName":"main::","children":[{"line":173,"name":"$self","containerName":"init","localvar":"my","kind":13,"definition":"my"},{"name":"$self","containerName":"init","kind":13,"line":175},{"line":175,"containerName":"init","kind":12,"name":"name"},{"line":176,"containerName":"init","kind":13,"name":"$self"},{"name":"description","kind":12,"containerName":"init","line":176},{"definition":"my","line":177,"kind":13,"localvar":"my","containerName":"init","name":"$species"},{"line":177,"name":"new","kind":12,"containerName":"init"},{"line":178,"kind":13,"containerName":"init","name":"$species"},{"line":178,"name":"classification","containerName":"init","kind":12},{"line":179,"containerName":"init","kind":13,"name":"$self"},{"line":179,"name":"species","containerName":"init","kind":12},{"name":"$species","containerName":"init","kind":13,"line":179},{"line":180,"containerName":"init","kind":13,"name":"$self"},{"line":180,"kind":12,"containerName":"init","name":"type"},{"line":181,"name":"$self","kind":13,"containerName":"init"},{"containerName":"init","kind":12,"name":"comment","line":181}]},{"name":"Bio","containerName":"Species","kind":12,"line":177},{"children":[{"definition":"my","localvar":"my","kind":13,"containerName":"name","name":"$self","line":201},{"name":"$value","kind":13,"containerName":"name","line":201},{"name":"$value","kind":13,"containerName":"name","line":203},{"name":"$self","containerName":"name","kind":13,"line":204},{"containerName":"name","kind":13,"name":"$value","line":204},{"line":207,"containerName":"name","kind":13,"name":"$self"}],"containerName":"main::","name":"name","definition":"sub","detail":"($self,$value)","line":200,"range":{"end":{"line":209,"character":9999},"start":{"character":0,"line":200}},"kind":12,"signature":{"documentation":"1;\n# $Id: Correlate.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Correlate\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Correlate - Representation of a correlating phenotype in a given species\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::Correlate;\n\n  $co = Bio::Phenotype::Correlate->new( -name        => \"4(Tas1r3)\",\n                                        -description => \"mouse correlate of human phenotype MIM 605865\",\n                                        -species     => $mouse,\n                                        -type        => \"homolog\",\n                                        -comment     => \"type=homolog is putative\" );\n\n  print $co->name();\n  print $co->description();\n  print $co->species()->binomial();\n  print $co->type();\n  print $co->comment();\n\n  print $co->to_string();\n\n=head1 DESCRIPTION\n\nThis class models correlating phenotypes.\nIts creation was inspired by the OMIM database where many human phenotypes\nhave a correlating mouse phenotype. Therefore, this class is intended\nto be used together with a phenotype class. \n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\npackage Bio::Phenotype::Correlate;\nuse strict;\nuse Bio::Species;\n\nuse base qw(Bio::Root::Root);\n\n\n=head2 new\n\n Title   : new\n Usage   : $co = Bio::Phenotype::Correlate->new( -name        => \"4(Tas1r3)\",\n                                                 -description => \"mouse correlate of human phenotype MIM 605865\",\n                                                 -species     => $mouse,\n                                                 -type        => \"homolog\",\n                                                 -comment     => \"type=homolog is putative\" );                      \n Function: Creates a new Correlate object.\n Returns : A new Correlate object.\n Args    : -name        => a name or id\n           -description => a description\n           -species     => the species of this correlating phenotype [Bio::Species]\n           -type        => the type of correlation\n           -comment     => a comment\n\n\nsub new {\n\n    my( $class, @args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n \n    my ( $name, $desc, $species, $type, $comment )\n    = $self->_rearrange( [ qw( NAME\n                               DESCRIPTION\n                               SPECIES\n                               TYPE\n                               COMMENT ) ], @args );\n                         \n    $self->init();                     \n   \n    $name    && $self->name( $name );\n    $desc    && $self->description( $desc );\n    $species && $self->species( $species );\n    $type    && $self->type( $type );\n    $comment && $self->comment( $comment );\n   \n    return $self;\n    \n} # new\n\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $co->init();   \n Function: Initializes this Correlate to all \"\".\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n    $self->name( \"\" );\n    $self->description( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( species Undetermined ) );\n    $self->species( $species );\n    $self->type( \"\" );\n    $self->comment( \"\" );\n  \n} # init\n\n\n\n\n=head2 name\n\n Title   : name\n Usage   : $co->name( \"4(Tas1r3)\" );\n           or\n           print $co->name();\n Function: Set/get for the name or id of this Correlate.\n Returns : The name or id of this Correlate.\n Args    : The name or id of this Correlate (optional).","parameters":[{"label":"$self"},{"label":"$value"}],"label":"name($self,$value)"}},{"signature":{"label":"description($self,$value)","documentation":"1;\n# $Id: Correlate.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Correlate\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Correlate - Representation of a correlating phenotype in a given species\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::Correlate;\n\n  $co = Bio::Phenotype::Correlate->new( -name        => \"4(Tas1r3)\",\n                                        -description => \"mouse correlate of human phenotype MIM 605865\",\n                                        -species     => $mouse,\n                                        -type        => \"homolog\",\n                                        -comment     => \"type=homolog is putative\" );\n\n  print $co->name();\n  print $co->description();\n  print $co->species()->binomial();\n  print $co->type();\n  print $co->comment();\n\n  print $co->to_string();\n\n=head1 DESCRIPTION\n\nThis class models correlating phenotypes.\nIts creation was inspired by the OMIM database where many human phenotypes\nhave a correlating mouse phenotype. Therefore, this class is intended\nto be used together with a phenotype class. \n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\npackage Bio::Phenotype::Correlate;\nuse strict;\nuse Bio::Species;\n\nuse base qw(Bio::Root::Root);\n\n\n=head2 new\n\n Title   : new\n Usage   : $co = Bio::Phenotype::Correlate->new( -name        => \"4(Tas1r3)\",\n                                                 -description => \"mouse correlate of human phenotype MIM 605865\",\n                                                 -species     => $mouse,\n                                                 -type        => \"homolog\",\n                                                 -comment     => \"type=homolog is putative\" );                      \n Function: Creates a new Correlate object.\n Returns : A new Correlate object.\n Args    : -name        => a name or id\n           -description => a description\n           -species     => the species of this correlating phenotype [Bio::Species]\n           -type        => the type of correlation\n           -comment     => a comment\n\n\nsub new {\n\n    my( $class, @args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n \n    my ( $name, $desc, $species, $type, $comment )\n    = $self->_rearrange( [ qw( NAME\n                               DESCRIPTION\n                               SPECIES\n                               TYPE\n                               COMMENT ) ], @args );\n                         \n    $self->init();                     \n   \n    $name    && $self->name( $name );\n    $desc    && $self->description( $desc );\n    $species && $self->species( $species );\n    $type    && $self->type( $type );\n    $comment && $self->comment( $comment );\n   \n    return $self;\n    \n} # new\n\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $co->init();   \n Function: Initializes this Correlate to all \"\".\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n    $self->name( \"\" );\n    $self->description( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( species Undetermined ) );\n    $self->species( $species );\n    $self->type( \"\" );\n    $self->comment( \"\" );\n  \n} # init\n\n\n\n\n=head2 name\n\n Title   : name\n Usage   : $co->name( \"4(Tas1r3)\" );\n           or\n           print $co->name();\n Function: Set/get for the name or id of this Correlate.\n Returns : The name or id of this Correlate.\n Args    : The name or id of this Correlate (optional).\n\n\nsub name {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_name\" } = $value;\n    }\n\n    return $self->{ \"_name\" };\n\n} # name\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $co->description( \"mouse correlate of human phenotype MIM 03923\" );\n           or\n           print $co->description();\n Function: Set/get for the description of this Correlate.\n Returns : A description of this Correlate.\n Args    : A description of this Correlate (optional).","parameters":[{"label":"$self"},{"label":"$value"}]},"kind":12,"range":{"start":{"line":226,"character":0},"end":{"character":9999,"line":235}},"line":226,"detail":"($self,$value)","definition":"sub","containerName":"main::","name":"description","children":[{"line":227,"kind":13,"localvar":"my","containerName":"description","name":"$self","definition":"my"},{"name":"$value","kind":13,"containerName":"description","line":227},{"line":229,"kind":13,"containerName":"description","name":"$value"},{"kind":13,"containerName":"description","name":"$self","line":230},{"name":"$value","kind":13,"containerName":"description","line":230},{"line":233,"kind":13,"containerName":"description","name":"$self"}]},{"kind":12,"range":{"start":{"character":0,"line":252},"end":{"line":263,"character":9999}},"line":252,"signature":{"label":"species($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Correlate.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Correlate\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Correlate - Representation of a correlating phenotype in a given species\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::Correlate;\n\n  $co = Bio::Phenotype::Correlate->new( -name        => \"4(Tas1r3)\",\n                                        -description => \"mouse correlate of human phenotype MIM 605865\",\n                                        -species     => $mouse,\n                                        -type        => \"homolog\",\n                                        -comment     => \"type=homolog is putative\" );\n\n  print $co->name();\n  print $co->description();\n  print $co->species()->binomial();\n  print $co->type();\n  print $co->comment();\n\n  print $co->to_string();\n\n=head1 DESCRIPTION\n\nThis class models correlating phenotypes.\nIts creation was inspired by the OMIM database where many human phenotypes\nhave a correlating mouse phenotype. Therefore, this class is intended\nto be used together with a phenotype class. \n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\npackage Bio::Phenotype::Correlate;\nuse strict;\nuse Bio::Species;\n\nuse base qw(Bio::Root::Root);\n\n\n=head2 new\n\n Title   : new\n Usage   : $co = Bio::Phenotype::Correlate->new( -name        => \"4(Tas1r3)\",\n                                                 -description => \"mouse correlate of human phenotype MIM 605865\",\n                                                 -species     => $mouse,\n                                                 -type        => \"homolog\",\n                                                 -comment     => \"type=homolog is putative\" );                      \n Function: Creates a new Correlate object.\n Returns : A new Correlate object.\n Args    : -name        => a name or id\n           -description => a description\n           -species     => the species of this correlating phenotype [Bio::Species]\n           -type        => the type of correlation\n           -comment     => a comment\n\n\nsub new {\n\n    my( $class, @args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n \n    my ( $name, $desc, $species, $type, $comment )\n    = $self->_rearrange( [ qw( NAME\n                               DESCRIPTION\n                               SPECIES\n                               TYPE\n                               COMMENT ) ], @args );\n                         \n    $self->init();                     \n   \n    $name    && $self->name( $name );\n    $desc    && $self->description( $desc );\n    $species && $self->species( $species );\n    $type    && $self->type( $type );\n    $comment && $self->comment( $comment );\n   \n    return $self;\n    \n} # new\n\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $co->init();   \n Function: Initializes this Correlate to all \"\".\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n    $self->name( \"\" );\n    $self->description( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( species Undetermined ) );\n    $self->species( $species );\n    $self->type( \"\" );\n    $self->comment( \"\" );\n  \n} # init\n\n\n\n\n=head2 name\n\n Title   : name\n Usage   : $co->name( \"4(Tas1r3)\" );\n           or\n           print $co->name();\n Function: Set/get for the name or id of this Correlate.\n Returns : The name or id of this Correlate.\n Args    : The name or id of this Correlate (optional).\n\n\nsub name {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_name\" } = $value;\n    }\n\n    return $self->{ \"_name\" };\n\n} # name\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $co->description( \"mouse correlate of human phenotype MIM 03923\" );\n           or\n           print $co->description();\n Function: Set/get for the description of this Correlate.\n Returns : A description of this Correlate.\n Args    : A description of this Correlate (optional).\n\n\nsub description {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_description\" } = $value;\n    }\n\n    return $self->{ \"_description\" };\n\n} # description\n\n\n\n\n=head2 species\n\n Title   : species\n Usage   : $co->species( $species );\n           or\n           $species = $co->species();\n Function: Set/get for the species of this Correlate.\n Returns : The Bio::Species of this Correlate [Bio::Species].\n Args    : The Bio::Species of this Correlate [Bio::Species] (optional)."},"name":"species","containerName":"main::","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"species","line":254},{"line":254,"containerName":"species","kind":13,"name":"$value"},{"name":"$value","containerName":"species","kind":13,"line":256},{"line":257,"kind":13,"containerName":"species","name":"$self"},{"name":"_check_ref_type","kind":12,"containerName":"species","line":257},{"name":"$value","kind":13,"containerName":"species","line":257},{"line":258,"name":"$self","containerName":"species","kind":13},{"name":"$value","containerName":"species","kind":13,"line":258},{"name":"$self","containerName":"species","kind":13,"line":261}],"detail":"($self,$value)","definition":"sub"},{"detail":"($self,$value)","definition":"sub","containerName":"main::","name":"type","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"type","line":281},{"kind":13,"containerName":"type","name":"$value","line":281},{"line":283,"name":"$value","containerName":"type","kind":13},{"line":284,"containerName":"type","kind":13,"name":"$self"},{"line":284,"name":"$value","containerName":"type","kind":13},{"name":"$self","kind":13,"containerName":"type","line":287}],"signature":{"documentation":"1;\n# $Id: Correlate.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Correlate\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Correlate - Representation of a correlating phenotype in a given species\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::Correlate;\n\n  $co = Bio::Phenotype::Correlate->new( -name        => \"4(Tas1r3)\",\n                                        -description => \"mouse correlate of human phenotype MIM 605865\",\n                                        -species     => $mouse,\n                                        -type        => \"homolog\",\n                                        -comment     => \"type=homolog is putative\" );\n\n  print $co->name();\n  print $co->description();\n  print $co->species()->binomial();\n  print $co->type();\n  print $co->comment();\n\n  print $co->to_string();\n\n=head1 DESCRIPTION\n\nThis class models correlating phenotypes.\nIts creation was inspired by the OMIM database where many human phenotypes\nhave a correlating mouse phenotype. Therefore, this class is intended\nto be used together with a phenotype class. \n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\npackage Bio::Phenotype::Correlate;\nuse strict;\nuse Bio::Species;\n\nuse base qw(Bio::Root::Root);\n\n\n=head2 new\n\n Title   : new\n Usage   : $co = Bio::Phenotype::Correlate->new( -name        => \"4(Tas1r3)\",\n                                                 -description => \"mouse correlate of human phenotype MIM 605865\",\n                                                 -species     => $mouse,\n                                                 -type        => \"homolog\",\n                                                 -comment     => \"type=homolog is putative\" );                      \n Function: Creates a new Correlate object.\n Returns : A new Correlate object.\n Args    : -name        => a name or id\n           -description => a description\n           -species     => the species of this correlating phenotype [Bio::Species]\n           -type        => the type of correlation\n           -comment     => a comment\n\n\nsub new {\n\n    my( $class, @args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n \n    my ( $name, $desc, $species, $type, $comment )\n    = $self->_rearrange( [ qw( NAME\n                               DESCRIPTION\n                               SPECIES\n                               TYPE\n                               COMMENT ) ], @args );\n                         \n    $self->init();                     \n   \n    $name    && $self->name( $name );\n    $desc    && $self->description( $desc );\n    $species && $self->species( $species );\n    $type    && $self->type( $type );\n    $comment && $self->comment( $comment );\n   \n    return $self;\n    \n} # new\n\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $co->init();   \n Function: Initializes this Correlate to all \"\".\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n    $self->name( \"\" );\n    $self->description( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( species Undetermined ) );\n    $self->species( $species );\n    $self->type( \"\" );\n    $self->comment( \"\" );\n  \n} # init\n\n\n\n\n=head2 name\n\n Title   : name\n Usage   : $co->name( \"4(Tas1r3)\" );\n           or\n           print $co->name();\n Function: Set/get for the name or id of this Correlate.\n Returns : The name or id of this Correlate.\n Args    : The name or id of this Correlate (optional).\n\n\nsub name {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_name\" } = $value;\n    }\n\n    return $self->{ \"_name\" };\n\n} # name\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $co->description( \"mouse correlate of human phenotype MIM 03923\" );\n           or\n           print $co->description();\n Function: Set/get for the description of this Correlate.\n Returns : A description of this Correlate.\n Args    : A description of this Correlate (optional).\n\n\nsub description {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_description\" } = $value;\n    }\n\n    return $self->{ \"_description\" };\n\n} # description\n\n\n\n\n=head2 species\n\n Title   : species\n Usage   : $co->species( $species );\n           or\n           $species = $co->species();\n Function: Set/get for the species of this Correlate.\n Returns : The Bio::Species of this Correlate [Bio::Species].\n Args    : The Bio::Species of this Correlate [Bio::Species] (optional).\n\n\nsub species {\n\n    my ( $self, $value )  = @_;\n\n    if ( defined $value ) {\n        $self->_check_ref_type( $value, \"Bio::Species\" );\n        $self->{ \"_species\" } = $value;\n    }\n    \n    return $self->{ \"_species\" };\n    \n} # species\n\n\n\n\n=head2 type\n\n Title   : type\n Usage   : $co->type( \"homolog\" );\n           or\n           print $co->type();\n Function: Set/get for the type of this Correlate.\n Returns : The type of this Correlate.\n Args    : The type of this Correlate (optional).","parameters":[{"label":"$self"},{"label":"$value"}],"label":"type($self,$value)"},"range":{"end":{"character":9999,"line":289},"start":{"line":280,"character":0}},"kind":12,"line":280},{"children":[{"line":307,"containerName":"comment","localvar":"my","kind":13,"name":"$self","definition":"my"},{"line":307,"kind":13,"containerName":"comment","name":"$value"},{"name":"$value","containerName":"comment","kind":13,"line":309},{"line":310,"name":"$self","kind":13,"containerName":"comment"},{"kind":13,"containerName":"comment","name":"$value","line":310},{"containerName":"comment","kind":13,"name":"$self","line":313}],"containerName":"main::","name":"comment","definition":"sub","detail":"($self,$value)","line":306,"kind":12,"range":{"end":{"character":9999,"line":315},"start":{"character":0,"line":306}},"signature":{"documentation":"1;\n# $Id: Correlate.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Correlate\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Correlate - Representation of a correlating phenotype in a given species\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::Correlate;\n\n  $co = Bio::Phenotype::Correlate->new( -name        => \"4(Tas1r3)\",\n                                        -description => \"mouse correlate of human phenotype MIM 605865\",\n                                        -species     => $mouse,\n                                        -type        => \"homolog\",\n                                        -comment     => \"type=homolog is putative\" );\n\n  print $co->name();\n  print $co->description();\n  print $co->species()->binomial();\n  print $co->type();\n  print $co->comment();\n\n  print $co->to_string();\n\n=head1 DESCRIPTION\n\nThis class models correlating phenotypes.\nIts creation was inspired by the OMIM database where many human phenotypes\nhave a correlating mouse phenotype. Therefore, this class is intended\nto be used together with a phenotype class. \n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\npackage Bio::Phenotype::Correlate;\nuse strict;\nuse Bio::Species;\n\nuse base qw(Bio::Root::Root);\n\n\n=head2 new\n\n Title   : new\n Usage   : $co = Bio::Phenotype::Correlate->new( -name        => \"4(Tas1r3)\",\n                                                 -description => \"mouse correlate of human phenotype MIM 605865\",\n                                                 -species     => $mouse,\n                                                 -type        => \"homolog\",\n                                                 -comment     => \"type=homolog is putative\" );                      \n Function: Creates a new Correlate object.\n Returns : A new Correlate object.\n Args    : -name        => a name or id\n           -description => a description\n           -species     => the species of this correlating phenotype [Bio::Species]\n           -type        => the type of correlation\n           -comment     => a comment\n\n\nsub new {\n\n    my( $class, @args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n \n    my ( $name, $desc, $species, $type, $comment )\n    = $self->_rearrange( [ qw( NAME\n                               DESCRIPTION\n                               SPECIES\n                               TYPE\n                               COMMENT ) ], @args );\n                         \n    $self->init();                     \n   \n    $name    && $self->name( $name );\n    $desc    && $self->description( $desc );\n    $species && $self->species( $species );\n    $type    && $self->type( $type );\n    $comment && $self->comment( $comment );\n   \n    return $self;\n    \n} # new\n\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $co->init();   \n Function: Initializes this Correlate to all \"\".\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n    $self->name( \"\" );\n    $self->description( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( species Undetermined ) );\n    $self->species( $species );\n    $self->type( \"\" );\n    $self->comment( \"\" );\n  \n} # init\n\n\n\n\n=head2 name\n\n Title   : name\n Usage   : $co->name( \"4(Tas1r3)\" );\n           or\n           print $co->name();\n Function: Set/get for the name or id of this Correlate.\n Returns : The name or id of this Correlate.\n Args    : The name or id of this Correlate (optional).\n\n\nsub name {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_name\" } = $value;\n    }\n\n    return $self->{ \"_name\" };\n\n} # name\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $co->description( \"mouse correlate of human phenotype MIM 03923\" );\n           or\n           print $co->description();\n Function: Set/get for the description of this Correlate.\n Returns : A description of this Correlate.\n Args    : A description of this Correlate (optional).\n\n\nsub description {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_description\" } = $value;\n    }\n\n    return $self->{ \"_description\" };\n\n} # description\n\n\n\n\n=head2 species\n\n Title   : species\n Usage   : $co->species( $species );\n           or\n           $species = $co->species();\n Function: Set/get for the species of this Correlate.\n Returns : The Bio::Species of this Correlate [Bio::Species].\n Args    : The Bio::Species of this Correlate [Bio::Species] (optional).\n\n\nsub species {\n\n    my ( $self, $value )  = @_;\n\n    if ( defined $value ) {\n        $self->_check_ref_type( $value, \"Bio::Species\" );\n        $self->{ \"_species\" } = $value;\n    }\n    \n    return $self->{ \"_species\" };\n    \n} # species\n\n\n\n\n=head2 type\n\n Title   : type\n Usage   : $co->type( \"homolog\" );\n           or\n           print $co->type();\n Function: Set/get for the type of this Correlate.\n Returns : The type of this Correlate.\n Args    : The type of this Correlate (optional).\n\n\nsub type {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_type\" } = $value;\n    }\n\n    return $self->{ \"_type\" };\n\n} # type\n\n\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $co->comment( \"doubtful\" );\n           or \n           print $co->comment();\n Function: Set/get for an arbitrary comment about this Correlate.\n Returns : A comment.\n Args    : A comment (optional).","parameters":[{"label":"$self"},{"label":"$value"}],"label":"comment($self,$value)"}},{"signature":{"documentation":"1;\n# $Id: Correlate.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Correlate\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Correlate - Representation of a correlating phenotype in a given species\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::Correlate;\n\n  $co = Bio::Phenotype::Correlate->new( -name        => \"4(Tas1r3)\",\n                                        -description => \"mouse correlate of human phenotype MIM 605865\",\n                                        -species     => $mouse,\n                                        -type        => \"homolog\",\n                                        -comment     => \"type=homolog is putative\" );\n\n  print $co->name();\n  print $co->description();\n  print $co->species()->binomial();\n  print $co->type();\n  print $co->comment();\n\n  print $co->to_string();\n\n=head1 DESCRIPTION\n\nThis class models correlating phenotypes.\nIts creation was inspired by the OMIM database where many human phenotypes\nhave a correlating mouse phenotype. Therefore, this class is intended\nto be used together with a phenotype class. \n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\npackage Bio::Phenotype::Correlate;\nuse strict;\nuse Bio::Species;\n\nuse base qw(Bio::Root::Root);\n\n\n=head2 new\n\n Title   : new\n Usage   : $co = Bio::Phenotype::Correlate->new( -name        => \"4(Tas1r3)\",\n                                                 -description => \"mouse correlate of human phenotype MIM 605865\",\n                                                 -species     => $mouse,\n                                                 -type        => \"homolog\",\n                                                 -comment     => \"type=homolog is putative\" );                      \n Function: Creates a new Correlate object.\n Returns : A new Correlate object.\n Args    : -name        => a name or id\n           -description => a description\n           -species     => the species of this correlating phenotype [Bio::Species]\n           -type        => the type of correlation\n           -comment     => a comment\n\n\nsub new {\n\n    my( $class, @args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n \n    my ( $name, $desc, $species, $type, $comment )\n    = $self->_rearrange( [ qw( NAME\n                               DESCRIPTION\n                               SPECIES\n                               TYPE\n                               COMMENT ) ], @args );\n                         \n    $self->init();                     \n   \n    $name    && $self->name( $name );\n    $desc    && $self->description( $desc );\n    $species && $self->species( $species );\n    $type    && $self->type( $type );\n    $comment && $self->comment( $comment );\n   \n    return $self;\n    \n} # new\n\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $co->init();   \n Function: Initializes this Correlate to all \"\".\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n    $self->name( \"\" );\n    $self->description( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( species Undetermined ) );\n    $self->species( $species );\n    $self->type( \"\" );\n    $self->comment( \"\" );\n  \n} # init\n\n\n\n\n=head2 name\n\n Title   : name\n Usage   : $co->name( \"4(Tas1r3)\" );\n           or\n           print $co->name();\n Function: Set/get for the name or id of this Correlate.\n Returns : The name or id of this Correlate.\n Args    : The name or id of this Correlate (optional).\n\n\nsub name {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_name\" } = $value;\n    }\n\n    return $self->{ \"_name\" };\n\n} # name\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $co->description( \"mouse correlate of human phenotype MIM 03923\" );\n           or\n           print $co->description();\n Function: Set/get for the description of this Correlate.\n Returns : A description of this Correlate.\n Args    : A description of this Correlate (optional).\n\n\nsub description {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_description\" } = $value;\n    }\n\n    return $self->{ \"_description\" };\n\n} # description\n\n\n\n\n=head2 species\n\n Title   : species\n Usage   : $co->species( $species );\n           or\n           $species = $co->species();\n Function: Set/get for the species of this Correlate.\n Returns : The Bio::Species of this Correlate [Bio::Species].\n Args    : The Bio::Species of this Correlate [Bio::Species] (optional).\n\n\nsub species {\n\n    my ( $self, $value )  = @_;\n\n    if ( defined $value ) {\n        $self->_check_ref_type( $value, \"Bio::Species\" );\n        $self->{ \"_species\" } = $value;\n    }\n    \n    return $self->{ \"_species\" };\n    \n} # species\n\n\n\n\n=head2 type\n\n Title   : type\n Usage   : $co->type( \"homolog\" );\n           or\n           print $co->type();\n Function: Set/get for the type of this Correlate.\n Returns : The type of this Correlate.\n Args    : The type of this Correlate (optional).\n\n\nsub type {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_type\" } = $value;\n    }\n\n    return $self->{ \"_type\" };\n\n} # type\n\n\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $co->comment( \"doubtful\" );\n           or \n           print $co->comment();\n Function: Set/get for an arbitrary comment about this Correlate.\n Returns : A comment.\n Args    : A comment (optional).\n\n\nsub comment {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_comment\" } = $value;\n    }\n   \n    return $self->{ \"_comment\" };\n    \n} # comment\n\n\n\n=head2 to_string\n\n Title   : to_string()\n Usage   : print $co->to_string();\n Function: To string method for Correlate objects.\n Returns : A string representations of this Correlate.\n Args    :","parameters":[{"label":"$self"}],"label":"to_string($self)"},"line":329,"range":{"end":{"line":348,"character":9999},"start":{"character":0,"line":329}},"kind":12,"definition":"sub","detail":"($self)","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"to_string","line":331,"definition":"my"},{"line":333,"localvar":"my","kind":13,"containerName":"to_string","name":"$s","definition":"my"},{"line":335,"containerName":"to_string","kind":13,"name":"$s"},{"name":"$s","kind":13,"containerName":"to_string","line":336},{"line":336,"kind":13,"containerName":"to_string","name":"$self"},{"line":336,"kind":12,"containerName":"to_string","name":"name"},{"line":337,"kind":13,"containerName":"to_string","name":"$s"},{"name":"$s","containerName":"to_string","kind":13,"line":338},{"kind":13,"containerName":"to_string","name":"$self","line":338},{"kind":12,"containerName":"to_string","name":"description","line":338},{"line":339,"name":"$s","kind":13,"containerName":"to_string"},{"line":340,"containerName":"to_string","kind":13,"name":"$s"},{"kind":13,"containerName":"to_string","name":"$self","line":340},{"kind":12,"containerName":"to_string","name":"species","line":340},{"line":340,"name":"binomial","kind":12,"containerName":"to_string"},{"kind":13,"containerName":"to_string","name":"$s","line":341},{"line":342,"name":"$s","kind":13,"containerName":"to_string"},{"line":342,"name":"$self","kind":13,"containerName":"to_string"},{"line":342,"name":"type","kind":12,"containerName":"to_string"},{"line":343,"containerName":"to_string","kind":13,"name":"$s"},{"line":344,"name":"$s","kind":13,"containerName":"to_string"},{"name":"$self","kind":13,"containerName":"to_string","line":344},{"kind":12,"containerName":"to_string","name":"comment","line":344},{"name":"$s","kind":13,"containerName":"to_string","line":346}],"containerName":"main::","name":"to_string"},{"signature":{"label":"_check_ref_type($self,$value,$expected_class)","parameters":[{"label":"$self"},{"label":"$value"},{"label":"$expected_class"}],"documentation":" Title   : _check_ref_type\n Function: Checks for the correct type.\n Returns :\n Args    : The value to be checked, the expected class."},"line":357,"kind":12,"range":{"end":{"line":372,"character":9999},"start":{"line":357,"character":0}},"definition":"sub","detail":"($self,$value,$expected_class)","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"_check_ref_type","line":358},{"line":358,"name":"$value","kind":13,"containerName":"_check_ref_type"},{"line":358,"name":"$expected_class","kind":13,"containerName":"_check_ref_type"},{"line":360,"kind":13,"containerName":"_check_ref_type","name":"$value"},{"line":361,"name":"$self","kind":13,"containerName":"_check_ref_type"},{"line":361,"containerName":"_check_ref_type","kind":12,"name":"throw"},{"containerName":"_check_ref_type","kind":13,"name":"$value","line":364},{"line":365,"name":"$self","kind":13,"containerName":"_check_ref_type"},{"kind":12,"containerName":"_check_ref_type","name":"throw","line":365},{"line":368,"name":"$value","kind":13,"containerName":"_check_ref_type"},{"name":"isa","containerName":"_check_ref_type","kind":12,"line":368},{"line":368,"containerName":"_check_ref_type","kind":13,"name":"$expected_class"},{"name":"$self","containerName":"_check_ref_type","kind":13,"line":369},{"kind":12,"containerName":"_check_ref_type","name":"throw","line":369},{"line":369,"kind":13,"containerName":"_check_ref_type","name":"$value"}],"containerName":"main::","name":"_check_ref_type"}]}