{"vars":[{"kind":2,"containerName":"strict::Bio::Root::IO::Bio::Ontology::OBOEngine::Bio::Ontology::Ontology::Bio::Ontology::OntologyStore::Bio::Ontology::TermFactory::Bio::Annotation::Collection::Text","name":"Balanced","line":105},{"definition":1,"name":"TRUE","kind":14,"containerName":"main::","line":107},{"name":"FALSE","kind":14,"containerName":"main::","line":108,"definition":1},{"name":"base","kind":2,"containerName":"","line":110},{"line":137,"kind":12,"range":{"end":{"character":9999,"line":162},"start":{"character":0,"line":137}},"signature":{"parameters":[{"label":"$self"},{"label":"%arg"}],"documentation":"1;\n# $Id: obo.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::OntologyIO::obo\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sohel Merchant, s-merchant at northwestern.edu\n#\n# Copyright Sohel Merchant\n#\n# You may distribute this module under the same terms as perl itself\n\n\n=head1 NAME\n\nBio::OntologyIO::obo - a parser for OBO flat-file format from Gene Ontology Consortium\n\n=head1 SYNOPSIS\n\n  use Bio::OntologyIO;\n\n  # do not use directly -- use via Bio::OntologyIO\n  my $parser = Bio::OntologyIO->new\n        ( -format       => \"obo\",\n          -file        =>  \"gene_ontology.obo\");\n\n  while(my $ont = $parser->next_ontology()) {\n  print \"read ontology \",$ont->name(),\" with \",\n               scalar($ont->get_root_terms),\" root terms, and \",\n               scalar($ont->get_all_terms),\" total terms, and \",\n               scalar($ont->get_leaf_terms),\" leaf terms\\n\";\n  }\n\n\n=head1 DESCRIPTION\n\nNeeds Graph.pm from CPAN.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSohel Merchant\n\nEmail: s-merchant@northwestern.edu\n\n\nAddress:\n\n  Northwestern University\n  Center for Genetic Medicine (CGM), dictyBase\n  Suite 1206,\n  676 St. Clair st\n  Chicago IL 60611\n\n=head2 CONTRIBUTOR\n\n Hilmar Lapp, hlapp at gmx.net\n Chris Mungall,   cjm at fruitfly.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage  Bio::OntologyIO::obo;\n\nuse strict;\n\nuse Bio::Root::IO;\nuse Bio::Ontology::OBOEngine;\nuse Bio::Ontology::Ontology;\nuse Bio::Ontology::OntologyStore;\nuse Bio::Ontology::TermFactory;\nuse Bio::Annotation::Collection;\nuse Text::Balanced qw(extract_quotelike extract_bracketed);\n\nuse constant TRUE  => 1;\nuse constant FALSE => 0;\n\nuse base qw(Bio::OntologyIO);\n\n=head2 new\n\n Title   : new\n Usage   : $parser = Bio::OntologyIO->new(\n                             -format => \"obo\",\n                             -file => \"gene_ontology.obo\");\n Function: Creates a new dagflat parser.\n Returns : A new dagflat parser object, implementing Bio::OntologyIO.\n Args    : -file      => a single ontology flat file holding the\n                          terms, descriptions and relationships\n           -ontology_name => the name of the ontology; if not specified the\n                          parser will assign the name of the ontology as the\n                          default-namespace header value from the OBO file.\n           -engine     => the Bio::Ontology::OntologyEngineI object\n                          to be reused (will be created otherwise); note\n                          that every Bio::Ontology::OntologyI will\n                          qualify as well since that one inherits from the\n                          former.\n\nSee L<Bio::OntologyIO>.\n\n in reality, we let OntologyIO::new do the instantiation, and override\n _initialize for all initialization work","label":"_initialize($self,%arg)"},"children":[{"kind":13,"localvar":"my","containerName":"_initialize","name":"$self","line":138,"definition":"my"},{"name":"%arg","containerName":"_initialize","kind":13,"line":138},{"line":140,"name":"$file","localvar":"my","kind":13,"containerName":"_initialize","definition":"my"},{"line":140,"containerName":"_initialize","kind":13,"name":"$name"},{"name":"$eng","containerName":"_initialize","kind":13,"line":140},{"name":"$self","kind":13,"containerName":"_initialize","line":140},{"line":140,"kind":12,"containerName":"_initialize","name":"_rearrange"},{"line":147,"kind":13,"containerName":"_initialize","name":"%arg"},{"line":149,"name":"$self","containerName":"_initialize","kind":13},{"line":149,"name":"%arg","kind":13,"containerName":"_initialize"},{"name":"$self","containerName":"_initialize","kind":13,"line":150},{"containerName":"_initialize","kind":13,"name":"$eng","line":153},{"name":"new","containerName":"_initialize","kind":12,"line":153},{"name":"$eng","kind":13,"containerName":"_initialize","line":153},{"name":"$eng","kind":13,"containerName":"_initialize","line":154},{"name":"isa","containerName":"_initialize","kind":12,"line":154},{"line":155,"name":"$self","containerName":"_initialize","kind":13},{"line":155,"name":"ontology_name","kind":12,"containerName":"_initialize"},{"line":155,"containerName":"_initialize","kind":13,"name":"$eng"},{"line":155,"name":"name","containerName":"_initialize","kind":12},{"name":"$eng","containerName":"_initialize","kind":13,"line":156},{"line":156,"kind":13,"containerName":"_initialize","name":"$eng"},{"name":"engine","kind":12,"containerName":"_initialize","line":156},{"line":156,"kind":13,"containerName":"_initialize","name":"$eng"},{"line":156,"name":"can","containerName":"_initialize","kind":12},{"kind":13,"containerName":"_initialize","name":"$self","line":158},{"name":"_ont_engine","kind":12,"containerName":"_initialize","line":158},{"name":"$eng","containerName":"_initialize","kind":13,"line":158},{"line":160,"containerName":"_initialize","kind":13,"name":"$self"},{"line":160,"kind":12,"containerName":"_initialize","name":"ontology_name"},{"line":160,"name":"$name","kind":13,"containerName":"_initialize"},{"line":160,"name":"$name","containerName":"_initialize","kind":13}],"containerName":"main::","name":"_initialize","definition":"sub","detail":"($self,%arg)"},{"kind":12,"containerName":"_initialize","name":"SUPER","line":149},{"name":"Bio","kind":12,"containerName":"Ontology::OBOEngine","line":153},{"line":176,"range":{"start":{"line":176,"character":0},"end":{"character":9999,"line":181}},"kind":12,"definition":"sub","children":[{"line":177,"name":"$self","containerName":"ontology_name","localvar":"my","kind":13,"definition":"my"},{"line":179,"containerName":"ontology_name","kind":13,"name":"$self"},{"kind":13,"containerName":"ontology_name","name":"$self","line":180}],"containerName":"main::","name":"ontology_name"},{"line":199,"range":{"start":{"line":199,"character":0},"end":{"character":9999,"line":321}},"kind":12,"definition":"sub","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"parse","kind":13,"line":200},{"name":"$self","kind":13,"containerName":"parse","line":203},{"name":"term_factory","containerName":"parse","kind":12,"line":203},{"name":"new","containerName":"parse","kind":12,"line":204},{"kind":13,"containerName":"parse","name":"$self","line":205},{"line":205,"name":"term_factory","containerName":"parse","kind":12},{"definition":"my","line":208,"name":"$annotations_collection","localvar":"my","kind":13,"containerName":"parse"},{"line":208,"name":"$self","containerName":"parse","kind":13},{"name":"_header","kind":12,"containerName":"parse","line":208},{"name":"$ont","localvar":"my","kind":13,"containerName":"parse","line":211,"definition":"my"},{"line":211,"kind":12,"containerName":"parse","name":"new"},{"name":"$self","containerName":"parse","kind":13,"line":212},{"containerName":"parse","kind":12,"name":"ontology_name","line":212},{"containerName":"parse","kind":13,"name":"$self","line":213},{"name":"_ont_engine","containerName":"parse","kind":12,"line":213},{"line":217,"name":"$ont","kind":13,"containerName":"parse"},{"line":217,"containerName":"parse","kind":12,"name":"annotation"},{"line":217,"name":"$annotations_collection","containerName":"parse","kind":13},{"line":221,"containerName":"parse","kind":13,"name":"$self"},{"kind":12,"containerName":"parse","name":"_part_of_relationship","line":221},{"name":"$self","kind":13,"containerName":"parse","line":222},{"line":222,"kind":12,"containerName":"parse","name":"_is_a_relationship"},{"kind":13,"containerName":"parse","name":"$self","line":223},{"containerName":"parse","kind":12,"name":"_related_to_relationship","line":223},{"name":"$self","kind":13,"containerName":"parse","line":224},{"kind":12,"containerName":"parse","name":"_regulates_relationship","line":224},{"name":"$self","containerName":"parse","kind":13,"line":225},{"name":"_positively_regulates_relationship","containerName":"parse","kind":12,"line":225},{"line":226,"name":"$self","kind":13,"containerName":"parse"},{"kind":12,"containerName":"parse","name":"_negatively_regulates_relationship","line":226},{"kind":12,"containerName":"parse","name":"ontology","line":229},{"kind":13,"containerName":"parse","name":"$ont","line":229},{"name":"$self","kind":13,"containerName":"parse","line":233},{"name":"_add_ontology","kind":12,"containerName":"parse","line":233},{"name":"$ont","containerName":"parse","kind":13,"line":233},{"line":237,"name":"$term","localvar":"my","kind":13,"containerName":"parse","definition":"my"},{"line":237,"name":"$self","kind":13,"containerName":"parse"},{"name":"_next_term","kind":12,"containerName":"parse","line":237},{"line":240,"name":"$term","kind":13,"containerName":"parse"},{"line":240,"name":"identifier","containerName":"parse","kind":12},{"line":240,"kind":13,"containerName":"parse","name":"$term"},{"kind":12,"containerName":"parse","name":"name","line":240},{"containerName":"parse","kind":13,"name":"$self","line":241},{"containerName":"parse","kind":12,"name":"throw","line":241},{"containerName":"parse","kind":13,"name":"$self","line":242},{"definition":"my","line":250,"localvar":"my","containerName":"parse","kind":13,"name":"$new_ontology_flag"},{"containerName":"parse","localvar":"my","kind":13,"name":"$ontologies_array_ref","line":251,"definition":"my"},{"kind":13,"containerName":"parse","name":"$self","line":251},{"definition":"my","name":"$ontology","localvar":"my","kind":13,"containerName":"parse","line":252},{"line":252,"name":"$ontologies_array_ref","containerName":"parse","kind":13},{"definition":"my","kind":13,"localvar":"my","containerName":"parse","name":"$oname","line":253},{"kind":13,"containerName":"parse","name":"$t_ns","line":253},{"line":253,"kind":13,"containerName":"parse","name":"$ontology"},{"line":253,"kind":12,"containerName":"parse","name":"name"},{"line":253,"containerName":"parse","kind":13,"name":"$term"},{"line":253,"containerName":"parse","kind":12,"name":"namespace"},{"name":"$oname","kind":13,"containerName":"parse","line":254},{"name":"$t_ns","containerName":"parse","kind":13,"line":254},{"name":"$oname","kind":13,"containerName":"parse","line":255},{"line":255,"containerName":"parse","kind":13,"name":"$t_ns"},{"name":"$new_ontology_flag","kind":13,"containerName":"parse","line":257},{"name":"$ont","containerName":"parse","kind":13,"line":258},{"line":258,"kind":13,"containerName":"parse","name":"$ontology"},{"containerName":"parse","kind":13,"name":"$new_ontology_flag","line":262},{"line":262,"name":"$term","containerName":"parse","kind":13},{"line":262,"kind":12,"containerName":"parse","name":"namespace"},{"definition":"my","localvar":"my","kind":13,"containerName":"parse","name":"$new_ont","line":263},{"kind":12,"containerName":"parse","name":"new","line":263},{"containerName":"parse","kind":13,"name":"$term","line":264},{"line":264,"name":"namespace","containerName":"parse","kind":12},{"line":265,"containerName":"parse","kind":13,"name":"$self"},{"containerName":"parse","kind":12,"name":"_ont_engine","line":265},{"kind":13,"containerName":"parse","name":"$new_ont","line":267},{"name":"annotation","containerName":"parse","kind":12,"line":267},{"line":267,"containerName":"parse","kind":13,"name":"$annotations_collection"},{"name":"$self","containerName":"parse","kind":13,"line":268},{"kind":12,"containerName":"parse","name":"_add_ontology","line":268},{"kind":13,"containerName":"parse","name":"$new_ont","line":268},{"line":269,"kind":13,"containerName":"parse","name":"$ont"},{"name":"$new_ont","kind":13,"containerName":"parse","line":269},{"containerName":"parse","kind":13,"name":"$self","line":273},{"line":273,"kind":12,"containerName":"parse","name":"_add_term"},{"line":273,"kind":13,"containerName":"parse","name":"$term"},{"name":"$ont","containerName":"parse","kind":13,"line":273},{"line":276,"name":"$isa_parents_array_ref","containerName":"parse","localvar":"my","kind":13,"definition":"my"},{"line":276,"name":"$self","kind":13,"containerName":"parse"},{"definition":"my","name":"$parent_term","kind":13,"localvar":"my","containerName":"parse","line":277},{"line":277,"kind":13,"containerName":"parse","name":"$isa_parents_array_ref"},{"name":"$self","kind":13,"containerName":"parse","line":279},{"name":"_has_term","containerName":"parse","kind":12,"line":279},{"kind":13,"containerName":"parse","name":"$parent_term","line":279},{"line":280,"containerName":"parse","kind":13,"name":"$self"},{"line":280,"kind":12,"containerName":"parse","name":"_add_term"},{"line":280,"kind":13,"containerName":"parse","name":"$parent_term"},{"line":280,"name":"$ont","kind":13,"containerName":"parse"},{"line":283,"name":"$self","containerName":"parse","kind":13},{"kind":12,"containerName":"parse","name":"_add_relationship","line":283},{"line":283,"kind":13,"containerName":"parse","name":"$parent_term"},{"line":283,"name":"$term","containerName":"parse","kind":13},{"name":"$self","containerName":"parse","kind":13,"line":284},{"containerName":"parse","kind":12,"name":"_is_a_relationship","line":284},{"line":284,"name":"$ont","containerName":"parse","kind":13},{"localvar":"my","containerName":"parse","kind":13,"name":"$relationship_hash_ref","line":288,"definition":"my"},{"line":288,"name":"$self","kind":13,"containerName":"parse"},{"definition":"my","line":289,"name":"$relationship","kind":13,"localvar":"my","containerName":"parse"},{"name":"$relationship_hash_ref","containerName":"parse","kind":13,"line":289},{"definition":"my","containerName":"parse","localvar":"my","kind":13,"name":"$reltype","line":290},{"name":"$self","kind":13,"containerName":"parse","line":292},{"line":292,"name":"_ont_engine","kind":12,"containerName":"parse"},{"name":"get_relationship_type","kind":12,"containerName":"parse","line":292},{"kind":13,"containerName":"parse","name":"$relationship","line":292},{"containerName":"parse","kind":13,"name":"$reltype","line":293},{"line":294,"name":"$self","containerName":"parse","kind":13},{"line":294,"name":"_ont_engine","kind":12,"containerName":"parse"},{"line":294,"name":"get_relationship_type","containerName":"parse","kind":12},{"line":294,"name":"$relationship","kind":13,"containerName":"parse"},{"line":297,"containerName":"parse","kind":13,"name":"$self"},{"line":297,"kind":12,"containerName":"parse","name":"_ont_engine"},{"containerName":"parse","kind":12,"name":"add_relationship_type","line":297},{"kind":13,"containerName":"parse","name":"$relationship","line":297},{"containerName":"parse","kind":13,"name":"$ont","line":298},{"containerName":"parse","kind":13,"name":"$reltype","line":299},{"name":"$self","kind":13,"containerName":"parse","line":300},{"line":300,"kind":12,"containerName":"parse","name":"_ont_engine"},{"containerName":"parse","kind":12,"name":"get_relationship_type","line":300},{"name":"$relationship","kind":13,"containerName":"parse","line":300},{"line":304,"localvar":"my","kind":13,"containerName":"parse","name":"$id_array_ref","definition":"my"},{"name":"$relationship","containerName":"parse","kind":13,"line":304},{"name":"$id","localvar":"my","containerName":"parse","kind":13,"line":305,"definition":"my"},{"name":"$id_array_ref","kind":13,"containerName":"parse","line":305},{"name":"$parent_term","localvar":"my","containerName":"parse","kind":13,"line":306,"definition":"my"},{"line":306,"containerName":"parse","kind":13,"name":"$self"},{"kind":12,"containerName":"parse","name":"_create_term_object","line":306},{"kind":13,"containerName":"parse","name":"$parent_term","line":307},{"line":307,"name":"identifier","kind":12,"containerName":"parse"},{"line":307,"name":"$id","kind":13,"containerName":"parse"},{"line":308,"name":"$parent_term","containerName":"parse","kind":13},{"name":"ontology","kind":12,"containerName":"parse","line":308},{"name":"$ont","kind":13,"containerName":"parse","line":308},{"name":"$self","containerName":"parse","kind":13,"line":310},{"line":310,"containerName":"parse","kind":12,"name":"_has_term"},{"line":310,"name":"$parent_term","kind":13,"containerName":"parse"},{"kind":13,"containerName":"parse","name":"$self","line":311},{"name":"_add_term","kind":12,"containerName":"parse","line":311},{"kind":13,"containerName":"parse","name":"$parent_term","line":311},{"line":311,"name":"$ont","kind":13,"containerName":"parse"},{"line":314,"kind":13,"containerName":"parse","name":"$self"},{"name":"_add_relationship","containerName":"parse","kind":12,"line":314},{"line":314,"kind":13,"containerName":"parse","name":"$parent_term"},{"containerName":"parse","kind":13,"name":"$term","line":314},{"kind":13,"containerName":"parse","name":"$reltype","line":314},{"line":314,"name":"$ont","kind":13,"containerName":"parse"},{"name":"$self","kind":13,"containerName":"parse","line":320},{"containerName":"parse","kind":12,"name":"_ont_engine","line":320}],"name":"parse","containerName":"main::"},{"kind":12,"containerName":"Ontology::TermFactory","name":"Bio","line":204},{"kind":12,"containerName":"Ontology::Ontology","name":"Bio","line":211},{"name":"Bio","kind":12,"containerName":"Ontology::Ontology","line":263},{"line":304,"name":"relationship_hash_ref","kind":12},{"containerName":"main::","name":"next_ontology","children":[{"definition":"my","line":338,"localvar":"my","containerName":"next_ontology","kind":13,"name":"$self"},{"name":"$self","containerName":"next_ontology","kind":13,"line":341},{"line":341,"name":"parse","kind":12,"containerName":"next_ontology"},{"name":"$self","kind":13,"containerName":"next_ontology","line":341},{"line":344,"name":"$self","kind":13,"containerName":"next_ontology"},{"definition":"my","name":"$ont","localvar":"my","containerName":"next_ontology","kind":13,"line":345},{"line":345,"name":"$self","kind":13,"containerName":"next_ontology"},{"kind":13,"containerName":"next_ontology","name":"$ont","line":346},{"definition":"my","line":347,"kind":13,"localvar":"my","containerName":"next_ontology","name":"$store"},{"name":"new","containerName":"next_ontology","kind":12,"line":347},{"line":348,"containerName":"next_ontology","kind":13,"name":"$store"},{"line":348,"name":"register_ontology","kind":12,"containerName":"next_ontology"},{"line":348,"name":"$ont","containerName":"next_ontology","kind":13},{"name":"$ont","kind":13,"containerName":"next_ontology","line":350}],"definition":"sub","kind":12,"range":{"end":{"character":9999,"line":352},"start":{"character":0,"line":337}},"line":337},{"line":347,"name":"Bio","kind":12,"containerName":"Ontology::OntologyStore"},{"children":[{"containerName":"close","localvar":"my","kind":13,"name":"$self","line":376,"definition":"my"},{"line":379,"name":"$self","kind":13,"containerName":"close"}],"containerName":"main::","name":"close","definition":"sub","line":375,"kind":12,"range":{"end":{"line":380,"character":9999},"start":{"character":0,"line":375}}},{"line":379,"containerName":"close","kind":12,"name":"SUPER"},{"definition":"sub","name":"_add_ontology","containerName":"main::","children":[{"definition":"my","line":386,"name":"$self","localvar":"my","kind":13,"containerName":"_add_ontology"},{"line":387,"name":"$self","kind":13,"containerName":"_add_ontology"},{"kind":13,"containerName":"_add_ontology","name":"$self","line":387},{"line":388,"name":"$ont","kind":13,"localvar":"my","containerName":"_add_ontology","definition":"my"},{"line":389,"kind":13,"containerName":"_add_ontology","name":"$self"},{"line":389,"kind":12,"containerName":"_add_ontology","name":"throw"},{"line":390,"kind":13,"containerName":"_add_ontology","name":"$ont"},{"line":391,"name":"$ont","containerName":"_add_ontology","kind":13},{"line":391,"containerName":"_add_ontology","kind":13,"name":"$ont"},{"line":391,"name":"isa","kind":12,"containerName":"_add_ontology"},{"line":395,"kind":13,"containerName":"_add_ontology","name":"$ont"},{"containerName":"_add_ontology","kind":12,"name":"name","line":395},{"kind":13,"containerName":"_add_ontology","name":"$self","line":395},{"containerName":"_add_ontology","kind":12,"name":"ontology_name","line":395},{"kind":13,"containerName":"_add_ontology","name":"$ont","line":395},{"name":"name","containerName":"_add_ontology","kind":12,"line":395},{"line":396,"containerName":"_add_ontology","kind":13,"name":"$self"},{"line":396,"name":"$ont","kind":13,"containerName":"_add_ontology"}],"range":{"end":{"line":397,"character":9999},"start":{"line":385,"character":0}},"kind":12,"line":385},{"line":401,"kind":12,"range":{"end":{"character":9999,"line":405},"start":{"line":401,"character":0}},"signature":{"parameters":[{"label":"$self"},{"label":"$term"},{"label":"$ont"}],"documentation":" This simply delegates. See OBOEngine.","label":"_add_term($self,$term,$ont)"},"children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"_add_term","line":402},{"line":402,"name":"$term","kind":13,"containerName":"_add_term"},{"containerName":"_add_term","kind":13,"name":"$ont","line":402},{"name":"$term","containerName":"_add_term","kind":13,"line":403},{"kind":12,"containerName":"_add_term","name":"ontology","line":403},{"containerName":"_add_term","kind":13,"name":"$ont","line":403},{"name":"$ont","containerName":"_add_term","kind":13,"line":403},{"name":"$term","kind":13,"containerName":"_add_term","line":403},{"line":403,"name":"ontology","kind":12,"containerName":"_add_term"},{"line":404,"kind":13,"containerName":"_add_term","name":"$self"},{"name":"_ont_engine","containerName":"_add_term","kind":12,"line":404},{"kind":12,"containerName":"_add_term","name":"add_term","line":404},{"containerName":"_add_term","kind":13,"name":"$term","line":404}],"name":"_add_term","containerName":"main::","definition":"sub","detail":"($self,$term,$ont)"},{"line":408,"range":{"end":{"line":412,"character":9999},"start":{"character":0,"line":408}},"kind":12,"children":[{"definition":"my","line":409,"name":"$self","containerName":"_part_of_relationship","localvar":"my","kind":13},{"line":411,"containerName":"_part_of_relationship","kind":13,"name":"$self"},{"line":411,"name":"_ont_engine","kind":12,"containerName":"_part_of_relationship"},{"name":"part_of_relationship","containerName":"_part_of_relationship","kind":12,"line":411}],"containerName":"main::","name":"_part_of_relationship","definition":"sub"},{"children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"_is_a_relationship","line":416},{"name":"$self","kind":13,"containerName":"_is_a_relationship","line":418},{"kind":12,"containerName":"_is_a_relationship","name":"_ont_engine","line":418},{"line":418,"name":"is_a_relationship","containerName":"_is_a_relationship","kind":12}],"name":"_is_a_relationship","containerName":"main::","definition":"sub","line":415,"range":{"start":{"character":0,"line":415},"end":{"line":419,"character":9999}},"kind":12},{"kind":12,"range":{"end":{"character":9999,"line":426},"start":{"character":0,"line":422}},"line":422,"definition":"sub","name":"_related_to_relationship","containerName":"main::","children":[{"line":423,"kind":13,"localvar":"my","containerName":"_related_to_relationship","name":"$self","definition":"my"},{"line":425,"name":"$self","containerName":"_related_to_relationship","kind":13},{"containerName":"_related_to_relationship","kind":12,"name":"_ont_engine","line":425},{"kind":12,"containerName":"_related_to_relationship","name":"related_to_relationship","line":425}]},{"definition":"sub","children":[{"line":431,"name":"$self","containerName":"_regulates_relationship","localvar":"my","kind":13,"definition":"my"},{"kind":13,"containerName":"_regulates_relationship","name":"$self","line":433},{"line":433,"containerName":"_regulates_relationship","kind":12,"name":"_ont_engine"},{"containerName":"_regulates_relationship","kind":12,"name":"regulates_relationship","line":433}],"containerName":"main::","name":"_regulates_relationship","line":430,"range":{"end":{"line":434,"character":9999},"start":{"character":0,"line":430}},"kind":12},{"children":[{"definition":"my","localvar":"my","containerName":"_positively_regulates_relationship","kind":13,"name":"$self","line":438},{"name":"$self","containerName":"_positively_regulates_relationship","kind":13,"line":440},{"containerName":"_positively_regulates_relationship","kind":12,"name":"_ont_engine","line":440},{"name":"positively_regulates_relationship","containerName":"_positively_regulates_relationship","kind":12,"line":440}],"name":"_positively_regulates_relationship","containerName":"main::","definition":"sub","line":437,"range":{"end":{"line":441,"character":9999},"start":{"line":437,"character":0}},"kind":12},{"range":{"end":{"character":9999,"line":449},"start":{"character":0,"line":445}},"kind":12,"line":445,"definition":"sub","containerName":"main::","name":"_negatively_regulates_relationship","children":[{"definition":"my","name":"$self","containerName":"_negatively_regulates_relationship","localvar":"my","kind":13,"line":446},{"line":448,"name":"$self","kind":13,"containerName":"_negatively_regulates_relationship"},{"line":448,"kind":12,"containerName":"_negatively_regulates_relationship","name":"_ont_engine"},{"line":448,"name":"negatively_regulates_relationship","containerName":"_negatively_regulates_relationship","kind":12}]},{"detail":"($self,$parent,$child,$type,$ont)","definition":"sub","name":"_add_relationship","containerName":"main::","children":[{"line":453,"localvar":"my","kind":13,"containerName":"_add_relationship","name":"$self","definition":"my"},{"line":453,"name":"$parent","kind":13,"containerName":"_add_relationship"},{"line":453,"containerName":"_add_relationship","kind":13,"name":"$child"},{"containerName":"_add_relationship","kind":13,"name":"$type","line":453},{"name":"$ont","containerName":"_add_relationship","kind":13,"line":453},{"line":457,"name":"$self","containerName":"_add_relationship","kind":13},{"line":457,"kind":12,"containerName":"_add_relationship","name":"_ont_engine"},{"name":"add_relationship","containerName":"_add_relationship","kind":12,"line":457},{"line":457,"kind":13,"containerName":"_add_relationship","name":"$child"},{"name":"$type","kind":13,"containerName":"_add_relationship","line":457},{"line":457,"containerName":"_add_relationship","kind":13,"name":"$parent"},{"line":457,"containerName":"_add_relationship","kind":13,"name":"$ont"}],"signature":{"label":"_add_relationship($self,$parent,$child,$type,$ont)","documentation":" This simply delegates. See OBOEngine","parameters":[{"label":"$self"},{"label":"$parent"},{"label":"$child"},{"label":"$type"},{"label":"$ont"}]},"range":{"start":{"character":0,"line":452},"end":{"line":459,"character":9999}},"kind":12,"line":452},{"range":{"start":{"character":0,"line":462},"end":{"line":466,"character":9999}},"kind":12,"line":462,"definition":"sub","name":"_has_term","containerName":"main::","children":[{"definition":"my","name":"$self","containerName":"_has_term","localvar":"my","kind":13,"line":463},{"name":"$self","kind":13,"containerName":"_has_term","line":465},{"name":"_ont_engine","kind":12,"containerName":"_has_term","line":465},{"line":465,"kind":12,"containerName":"_has_term","name":"has_term"}]},{"children":[{"line":470,"kind":13,"localvar":"my","containerName":"_ont_engine","name":"$self","definition":"my"},{"line":470,"name":"$value","containerName":"_ont_engine","kind":13},{"line":472,"kind":13,"containerName":"_ont_engine","name":"$value"},{"line":473,"containerName":"_ont_engine","kind":13,"name":"$self"},{"line":473,"name":"$value","containerName":"_ont_engine","kind":13},{"line":476,"containerName":"_ont_engine","kind":13,"name":"$self"}],"containerName":"main::","name":"_ont_engine","definition":"sub","detail":"($self,$value)","line":469,"kind":12,"range":{"start":{"character":0,"line":469},"end":{"line":477,"character":9999}},"signature":{"label":"_ont_engine($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":" Holds the OBO engine to be parsed into"}},{"line":480,"range":{"start":{"line":480,"character":0},"end":{"line":501,"character":9999}},"kind":12,"signature":{"label":"_filter_line($self,$line)","parameters":[{"label":"$self"},{"label":"$line"}],"documentation":" Removes the escape chracters from the file"},"children":[{"line":481,"localvar":"my","kind":13,"containerName":"_filter_line","name":"$self","definition":"my"},{"name":"$line","containerName":"_filter_line","kind":13,"line":481},{"line":483,"containerName":"_filter_line","kind":13,"name":"$line"},{"line":484,"name":"$line","containerName":"_filter_line","kind":13},{"line":487,"name":"$line","kind":13,"containerName":"_filter_line"},{"line":489,"kind":13,"containerName":"_filter_line","name":"$line"},{"line":491,"kind":13,"containerName":"_filter_line","name":"$line"},{"line":492,"name":"$line","containerName":"_filter_line","kind":13},{"line":494,"name":"$line","kind":13,"containerName":"_filter_line"},{"name":"$line","containerName":"_filter_line","kind":13,"line":495},{"name":"$line","kind":13,"containerName":"_filter_line","line":496},{"name":"$line","containerName":"_filter_line","kind":13,"line":497},{"name":"$line","containerName":"_filter_line","kind":13,"line":498},{"name":"$line","kind":13,"containerName":"_filter_line","line":500}],"name":"_filter_line","containerName":"main::","definition":"sub","detail":"($self,$line)"},{"line":504,"range":{"end":{"line":566,"character":9999},"start":{"line":504,"character":0}},"kind":12,"definition":"sub","children":[{"definition":"my","line":505,"localvar":"my","containerName":"_header","kind":13,"name":"$self"},{"line":506,"name":"$annotation_collection","localvar":"my","containerName":"_header","kind":13,"definition":"my"},{"kind":12,"containerName":"_header","name":"new","line":506},{"definition":"my","line":507,"containerName":"_header","localvar":"my","kind":13,"name":"$tag"},{"name":"$value","containerName":"_header","kind":13,"line":507},{"definition":"my","line":508,"name":"$line_counter","containerName":"_header","localvar":"my","kind":13},{"containerName":"_header","kind":13,"name":"$self","line":509},{"definition":"my","localvar":"my","kind":13,"containerName":"_header","name":"$format_version_header_flag","line":510},{"line":511,"kind":13,"localvar":"my","containerName":"_header","name":"$default_namespace_header_flag","definition":"my"},{"name":"$line","localvar":"my","kind":13,"containerName":"_header","line":513,"definition":"my"},{"kind":13,"containerName":"_header","name":"$self","line":513},{"name":"_readline","kind":12,"containerName":"_header","line":513},{"containerName":"_header","kind":13,"name":"$line_counter","line":514},{"kind":13,"localvar":"my","containerName":"_header","name":"$line","line":515,"definition":"my"},{"line":515,"name":"$self","containerName":"_header","kind":13},{"line":515,"containerName":"_header","kind":12,"name":"_filter_line"},{"name":"$line","kind":13,"containerName":"_header","line":515},{"line":516,"containerName":"_header","kind":13,"name":"$line"},{"line":517,"kind":13,"containerName":"_header","name":"$format_version_header_flag"},{"line":517,"name":"$default_namespace_header_flag","containerName":"_header","kind":13},{"line":518,"name":"$self","containerName":"_header","kind":13},{"containerName":"_header","kind":12,"name":"throw","line":518},{"line":523,"kind":13,"containerName":"_header","name":"$self"},{"line":523,"kind":13,"containerName":"_header","name":"$line_counter"},{"kind":13,"containerName":"_header","name":"$annotation_collection","line":524},{"line":528,"name":"$line","kind":13,"containerName":"_header"},{"line":529,"name":"$self","kind":13,"containerName":"_header"},{"name":"throw","kind":12,"containerName":"_header","line":529},{"name":"$self","containerName":"_header","kind":13,"line":536},{"name":"_check_colon","kind":12,"containerName":"_header","line":536},{"line":536,"name":"$line","containerName":"_header","kind":13},{"line":536,"kind":13,"containerName":"_header","name":"$line_counter"},{"containerName":"_header","kind":13,"name":"$line","line":539},{"name":"$line","containerName":"_header","kind":13,"line":543},{"containerName":"_header","kind":13,"name":"$tag","line":544},{"name":"$value","kind":13,"containerName":"_header","line":544},{"containerName":"_header","kind":13,"name":"$tag","line":547},{"name":"$format_version_header_flag","containerName":"_header","kind":13,"line":548},{"line":549,"containerName":"_header","kind":13,"name":"$tag"},{"kind":13,"containerName":"_header","name":"$default_namespace_header_flag","line":550},{"line":553,"localvar":"my","containerName":"_header","kind":13,"name":"$header","definition":"my"},{"line":553,"kind":12,"containerName":"_header","name":"new"},{"kind":13,"containerName":"_header","name":"$value","line":553},{"name":"$annotation_collection","kind":13,"containerName":"_header","line":554},{"line":554,"containerName":"_header","kind":12,"name":"add_Annotation"},{"name":"$tag","kind":13,"containerName":"_header","line":554},{"line":554,"containerName":"_header","kind":13,"name":"$header"},{"kind":13,"containerName":"_header","name":"$tag","line":557},{"line":559,"containerName":"_header","kind":13,"name":"$self"},{"containerName":"_header","kind":12,"name":"ontology_name","line":559},{"line":559,"kind":13,"containerName":"_header","name":"$value"}],"containerName":"main::","name":"_header"},{"kind":12,"containerName":"Annotation::Collection","name":"Bio","line":506},{"containerName":"Annotation::SimpleValue","kind":12,"name":"Bio","line":553},{"kind":12,"range":{"start":{"character":0,"line":569},"end":{"line":705,"character":9999}},"line":569,"definition":"sub","containerName":"main::","name":"_next_term","children":[{"definition":"my","line":570,"containerName":"_next_term","localvar":"my","kind":13,"name":"$self"},{"line":571,"name":"$term","localvar":"my","kind":13,"containerName":"_next_term","definition":"my"},{"definition":"my","localvar":"my","kind":13,"containerName":"_next_term","name":"$skip_stanza_flag","line":572},{"definition":"my","line":573,"containerName":"_next_term","localvar":"my","kind":13,"name":"$line_counter"},{"line":573,"containerName":"_next_term","kind":13,"name":"$self"},{"name":"$line","localvar":"my","kind":13,"containerName":"_next_term","line":575,"definition":"my"},{"line":575,"name":"$self","kind":13,"containerName":"_next_term"},{"line":575,"name":"_readline","kind":12,"containerName":"_next_term"},{"name":"$line_counter","kind":13,"containerName":"_next_term","line":577},{"name":"$line","containerName":"_next_term","localvar":"my","kind":13,"line":578,"definition":"my"},{"name":"$self","kind":13,"containerName":"_next_term","line":578},{"line":578,"containerName":"_next_term","kind":12,"name":"_filter_line"},{"line":578,"name":"$line","kind":13,"containerName":"_next_term"},{"kind":13,"containerName":"_next_term","name":"$line","line":579},{"name":"$term","containerName":"_next_term","kind":13,"line":579},{"line":580,"name":"$self","containerName":"_next_term","kind":13},{"name":"$line_counter","kind":13,"containerName":"_next_term","line":580},{"line":581,"containerName":"_next_term","kind":13,"name":"$term"},{"kind":13,"containerName":"_next_term","name":"$line","line":584},{"name":"$term","containerName":"_next_term","kind":13,"line":588},{"name":"$self","containerName":"_next_term","kind":13,"line":588},{"line":588,"name":"_create_term_object","kind":12,"containerName":"_next_term"},{"line":589,"kind":13,"containerName":"_next_term","name":"$skip_stanza_flag"},{"line":591,"containerName":"_next_term","kind":13,"name":"$self"},{"line":592,"name":"$self","kind":13,"containerName":"_next_term"},{"line":595,"name":"$skip_stanza_flag","containerName":"_next_term","kind":13},{"line":599,"name":"$skip_stanza_flag","containerName":"_next_term","kind":13},{"containerName":"_next_term","kind":13,"name":"$self","line":600},{"name":"warn","containerName":"_next_term","kind":12,"line":600},{"name":"$self","containerName":"_next_term","kind":13,"line":608},{"name":"_check_colon","containerName":"_next_term","kind":12,"line":608},{"line":608,"containerName":"_next_term","kind":13,"name":"$line"},{"containerName":"_next_term","kind":13,"name":"$line_counter","line":608},{"line":614,"name":"$line","kind":13,"containerName":"_next_term"},{"kind":13,"containerName":"_next_term","name":"$skip_stanza_flag","line":618},{"kind":13,"containerName":"_next_term","name":"$line","line":620},{"line":621,"kind":13,"localvar":"my","containerName":"_next_term","name":"$tag","definition":"my"},{"kind":13,"containerName":"_next_term","name":"$val","line":621},{"kind":13,"containerName":"_next_term","name":"$val","line":624},{"line":625,"name":"$self","kind":13,"containerName":"_next_term"},{"kind":12,"containerName":"_next_term","name":"warn","line":625},{"name":"$qh","localvar":"my","containerName":"_next_term","kind":13,"line":630,"definition":"my"},{"line":631,"kind":13,"containerName":"_next_term","name":"$val"},{"containerName":"_next_term","kind":13,"name":"$qh","line":631},{"containerName":"_next_term","kind":13,"name":"$self","line":631},{"name":"_extract_quals","kind":12,"containerName":"_next_term","line":631},{"line":631,"containerName":"_next_term","kind":13,"name":"$val"},{"line":632,"name":"$val2","kind":13,"localvar":"my","containerName":"_next_term","definition":"my"},{"containerName":"_next_term","kind":13,"name":"$val","line":632},{"name":"$val2","containerName":"_next_term","kind":13,"line":633},{"containerName":"_next_term","kind":13,"name":"$tag","line":634},{"containerName":"_next_term","kind":13,"name":"$tag","line":634},{"containerName":"_next_term","kind":13,"name":"$tag","line":635},{"containerName":"_next_term","kind":13,"name":"$term","line":637},{"containerName":"_next_term","kind":12,"name":"identifier","line":637},{"name":"$val","containerName":"_next_term","kind":13,"line":637},{"line":638,"name":"$self","kind":13,"containerName":"_next_term"},{"kind":12,"containerName":"_next_term","name":"_has_term","line":638},{"name":"$term","containerName":"_next_term","kind":13,"line":638},{"kind":13,"containerName":"_next_term","name":"$term","line":639},{"line":639,"containerName":"_next_term","kind":13,"name":"$self"},{"line":639,"containerName":"_next_term","kind":12,"name":"_ont_engine"},{"line":639,"name":"get_terms","kind":12,"containerName":"_next_term"},{"line":639,"containerName":"_next_term","kind":13,"name":"$val"},{"line":643,"kind":13,"containerName":"_next_term","name":"$tag"},{"name":"$term","containerName":"_next_term","kind":13,"line":644},{"line":644,"kind":12,"containerName":"_next_term","name":"name"},{"line":644,"name":"$val","kind":13,"containerName":"_next_term"},{"line":646,"name":"$tag","kind":13,"containerName":"_next_term"},{"name":"$term","containerName":"_next_term","kind":13,"line":647},{"line":647,"name":"has_dbxref","kind":12,"containerName":"_next_term"},{"line":647,"name":"$val","kind":13,"containerName":"_next_term"},{"line":648,"containerName":"_next_term","kind":13,"name":"$term"},{"name":"add_dbxref","kind":12,"containerName":"_next_term","line":648},{"line":648,"kind":13,"containerName":"_next_term","name":"$self"},{"containerName":"_next_term","kind":12,"name":"_to_annotation","line":648},{"containerName":"_next_term","kind":13,"name":"$val","line":648},{"kind":13,"containerName":"_next_term","name":"$tag","line":651},{"line":652,"containerName":"_next_term","kind":13,"name":"$term"},{"name":"add_dbxref","kind":12,"containerName":"_next_term","line":652},{"line":652,"containerName":"_next_term","kind":13,"name":"$self"},{"name":"_to_annotation","containerName":"_next_term","kind":12,"line":652},{"kind":13,"containerName":"_next_term","name":"$val","line":652},{"line":654,"name":"$tag","kind":13,"containerName":"_next_term"},{"containerName":"_next_term","kind":13,"name":"$term","line":655},{"name":"namespace","kind":12,"containerName":"_next_term","line":655},{"line":655,"name":"$val","containerName":"_next_term","kind":13},{"line":657,"containerName":"_next_term","kind":13,"name":"$tag"},{"line":658,"name":"$defstr","localvar":"my","containerName":"_next_term","kind":13,"definition":"my"},{"line":658,"name":"$parts","containerName":"_next_term","kind":13},{"line":658,"containerName":"_next_term","kind":13,"name":"$self"},{"line":658,"name":"_extract_qstr","containerName":"_next_term","kind":12},{"name":"$val","containerName":"_next_term","kind":13,"line":658},{"line":659,"name":"$term","kind":13,"containerName":"_next_term"},{"line":659,"kind":12,"containerName":"_next_term","name":"definition"},{"line":659,"name":"$defstr","kind":13,"containerName":"_next_term"},{"definition":"my","kind":13,"localvar":"my","containerName":"_next_term","name":"$ann","line":660},{"name":"$self","kind":13,"containerName":"_next_term","line":660},{"name":"_to_annotation","kind":12,"containerName":"_next_term","line":660},{"kind":13,"containerName":"_next_term","name":"$parts","line":660},{"name":"$term","kind":13,"containerName":"_next_term","line":661},{"line":661,"name":"add_dbxref","containerName":"_next_term","kind":12},{"line":661,"containerName":"_next_term","kind":13,"name":"$ann"},{"name":"$tag","kind":13,"containerName":"_next_term","line":663},{"containerName":"_next_term","kind":13,"name":"$val","line":664},{"name":"$term","containerName":"_next_term","kind":13,"line":665},{"line":665,"kind":12,"containerName":"_next_term","name":"add_synonym"},{"name":"$val","containerName":"_next_term","kind":13,"line":665},{"line":667,"kind":13,"containerName":"_next_term","name":"$tag"},{"kind":13,"containerName":"_next_term","name":"$term","line":668},{"name":"add_secondary_id","containerName":"_next_term","kind":12,"line":668},{"name":"$val","containerName":"_next_term","kind":13,"line":668},{"line":670,"containerName":"_next_term","kind":13,"name":"$tag"},{"line":672,"containerName":"_next_term","kind":13,"name":"$val"},{"line":673,"name":"$val","containerName":"_next_term","kind":13},{"line":675,"name":"$val","containerName":"_next_term","kind":13},{"containerName":"_next_term","kind":13,"name":"$val","line":676},{"line":678,"name":"$term","containerName":"_next_term","kind":13},{"name":"is_obsolete","kind":12,"containerName":"_next_term","line":678},{"line":678,"name":"$val","kind":13,"containerName":"_next_term"},{"line":680,"name":"$tag","containerName":"_next_term","kind":13},{"line":681,"name":"$term","kind":13,"containerName":"_next_term"},{"line":681,"containerName":"_next_term","kind":12,"name":"comment"},{"name":"$val","containerName":"_next_term","kind":13,"line":681},{"line":683,"name":"$tag","kind":13,"containerName":"_next_term"},{"line":684,"name":"$self","containerName":"_next_term","kind":13},{"kind":12,"containerName":"_next_term","name":"_handle_relationship_tag","line":684},{"containerName":"_next_term","kind":13,"name":"$val","line":684},{"kind":13,"containerName":"_next_term","name":"$tag","line":686},{"name":"$val","kind":13,"containerName":"_next_term","line":688},{"localvar":"my","kind":13,"containerName":"_next_term","name":"$parent_term","line":689,"definition":"my"},{"line":689,"name":"$self","kind":13,"containerName":"_next_term"},{"kind":12,"containerName":"_next_term","name":"_create_term_object","line":689},{"containerName":"_next_term","kind":13,"name":"$parent_term","line":690},{"name":"identifier","kind":12,"containerName":"_next_term","line":690},{"line":690,"name":"$val","kind":13,"containerName":"_next_term"},{"line":692,"name":"$self","containerName":"_next_term","kind":13},{"definition":"my","line":693,"containerName":"_next_term","localvar":"my","kind":13,"name":"$isa_parents_array_ref"},{"name":"$self","containerName":"_next_term","kind":13,"line":693},{"kind":13,"containerName":"_next_term","name":"$isa_parents_array_ref","line":694},{"line":694,"containerName":"_next_term","kind":13,"name":"$parent_term"},{"containerName":"_next_term","localvar":"my","kind":13,"name":"@terms_array","line":697,"definition":"my"},{"kind":13,"containerName":"_next_term","name":"@terms_array","line":698},{"line":698,"name":"$parent_term","containerName":"_next_term","kind":13},{"kind":13,"containerName":"_next_term","name":"$self","line":699},{"name":"@terms_array","containerName":"_next_term","kind":13,"line":699},{"line":704,"name":"$term","containerName":"_next_term","kind":13}]},{"containerName":"main::","name":"_create_term_object","children":[{"containerName":"_create_term_object","localvar":"my","kind":13,"name":"$self","line":710,"definition":"my"},{"definition":"my","kind":13,"localvar":"my","containerName":"_create_term_object","name":"$term","line":711},{"kind":13,"containerName":"_create_term_object","name":"$self","line":711},{"line":711,"name":"term_factory","kind":12,"containerName":"_create_term_object"},{"line":711,"containerName":"_create_term_object","kind":12,"name":"create_object"},{"name":"$term","containerName":"_create_term_object","kind":13,"line":712}],"detail":"($self)","definition":"sub","range":{"start":{"line":708,"character":0},"end":{"line":714,"character":9999}},"kind":12,"line":708,"signature":{"documentation":" Creates a Bio::Ontology::OBOterm object","parameters":[{"label":"$self"}],"label":"_create_term_object($self)"}},{"detail":"($self,$str)","definition":"sub","containerName":"main::","name":"_extract_quals","children":[{"name":"$self","containerName":"_extract_quals","localvar":"my","kind":13,"line":718,"definition":"my"},{"line":718,"name":"$str","containerName":"_extract_quals","kind":13},{"line":720,"localvar":"my","containerName":"_extract_quals","kind":13,"name":"%q","definition":"my"},{"line":721,"name":"$str","containerName":"_extract_quals","kind":13},{"name":"$return_str","localvar":"my","containerName":"_extract_quals","kind":13,"line":722,"definition":"my"},{"line":723,"localvar":"my","kind":13,"containerName":"_extract_quals","name":"$extr","definition":"my"},{"line":724,"name":"$extr","containerName":"_extract_quals","kind":13},{"definition":"my","name":"@qparts","localvar":"my","containerName":"_extract_quals","kind":13,"line":725},{"name":"$self","kind":13,"containerName":"_extract_quals","line":725},{"line":725,"name":"_split_on_comma","containerName":"_extract_quals","kind":12},{"line":725,"kind":13,"containerName":"_extract_quals","name":"$extr"},{"line":726,"kind":13,"containerName":"_extract_quals","name":"@qparts"},{"line":728,"name":"$q","kind":13,"containerName":"_extract_quals"},{"name":"$q","containerName":"_extract_quals","kind":13,"line":731},{"name":"$return_str","containerName":"_extract_quals","kind":13,"line":738},{"containerName":"_extract_quals","kind":13,"name":"%q","line":738},{"line":741,"kind":13,"containerName":"_extract_quals","name":"$str"}],"signature":{"parameters":[{"label":"$self"},{"label":"$str"}],"documentation":"","label":"_extract_quals($self,$str)"},"range":{"end":{"character":9999,"line":743},"start":{"line":717,"character":0}},"kind":12,"line":717},{"definition":"sub","detail":"($self,$str)","children":[{"line":746,"name":"$self","kind":13,"localvar":"my","containerName":"_extract_qstr","definition":"my"},{"line":746,"name":"$str","kind":13,"containerName":"_extract_qstr"},{"definition":"my","localvar":"my","kind":13,"containerName":"_extract_qstr","name":"$extr","line":748},{"line":748,"name":"$rem","containerName":"_extract_qstr","kind":13},{"line":748,"name":"$prefix","kind":13,"containerName":"_extract_qstr"},{"line":748,"kind":13,"containerName":"_extract_qstr","name":"$str"},{"line":749,"name":"$txt","localvar":"my","containerName":"_extract_qstr","kind":13,"definition":"my"},{"containerName":"_extract_qstr","kind":13,"name":"$extr","line":749},{"kind":13,"containerName":"_extract_qstr","name":"$txt","line":750},{"kind":13,"containerName":"_extract_qstr","name":"$txt","line":751},{"line":752,"containerName":"_extract_qstr","kind":13,"name":"$prefix"},{"line":756,"name":"@extra","kind":13,"localvar":"my","containerName":"_extract_qstr","definition":"my"},{"line":759,"kind":13,"containerName":"_extract_qstr","name":"$rem"},{"name":"$rem","kind":13,"containerName":"_extract_qstr","line":760},{"line":761,"containerName":"_extract_qstr","kind":13,"name":"@extra"},{"definition":"my","line":764,"name":"@parts","kind":13,"localvar":"my","containerName":"_extract_qstr"},{"line":765,"kind":13,"containerName":"_extract_qstr","name":"$extr"},{"containerName":"_extract_qstr","kind":13,"name":"$rem","line":765},{"line":765,"name":"$prefix","kind":13,"containerName":"_extract_qstr"},{"line":765,"kind":13,"containerName":"_extract_qstr","name":"$rem"},{"kind":13,"containerName":"_extract_qstr","name":"$extr","line":766},{"kind":13,"containerName":"_extract_qstr","name":"$extr","line":767},{"line":768,"name":"$extr","kind":13,"containerName":"_extract_qstr"},{"line":769,"kind":13,"containerName":"_extract_qstr","name":"@parts"},{"name":"$extr","containerName":"_extract_qstr","kind":13,"line":769},{"name":"$extr","containerName":"_extract_qstr","kind":13,"line":769},{"name":"@parts","kind":13,"containerName":"_extract_qstr","line":771},{"name":"$self","kind":13,"containerName":"_extract_qstr","line":772},{"line":772,"name":"_split_on_comma","kind":12,"containerName":"_extract_qstr"},{"containerName":"_extract_qstr","kind":13,"name":"@parts","line":772},{"line":774,"containerName":"_extract_qstr","kind":13,"name":"$txt"},{"name":"$txt","kind":13,"containerName":"_extract_qstr","line":775},{"line":775,"name":"@parts","containerName":"_extract_qstr","kind":13},{"containerName":"_extract_qstr","kind":13,"name":"@extra","line":775}],"containerName":"main::","name":"_extract_qstr","signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$str"}],"label":"_extract_qstr($self,$str)"},"line":745,"kind":12,"range":{"end":{"line":776,"character":9999},"start":{"character":0,"line":745}}},{"kind":12,"name":"extract_quotelike","line":748},{"line":765,"name":"extract_bracketed","kind":12},{"containerName":"main::","name":"_split_on_comma","children":[{"definition":"my","line":779,"kind":13,"localvar":"my","containerName":"_split_on_comma","name":"$self"},{"line":779,"containerName":"_split_on_comma","kind":13,"name":"$str"},{"definition":"my","name":"@parts","localvar":"my","containerName":"_split_on_comma","kind":13,"line":780},{"line":781,"containerName":"_split_on_comma","kind":13,"name":"$str"},{"name":"$str","containerName":"_split_on_comma","kind":13,"line":782},{"line":783,"localvar":"my","containerName":"_split_on_comma","kind":13,"name":"$part","definition":"my"},{"kind":13,"containerName":"_split_on_comma","name":"@parts","line":784},{"containerName":"_split_on_comma","kind":13,"name":"$part","line":784},{"line":785,"name":"$str","kind":13,"containerName":"_split_on_comma"},{"line":787,"name":"@parts","containerName":"_split_on_comma","kind":13},{"name":"$str","kind":13,"containerName":"_split_on_comma","line":787},{"line":788,"kind":13,"containerName":"_split_on_comma","name":"@parts"}],"detail":"($self,$str)","definition":"sub","kind":12,"range":{"start":{"character":0,"line":778},"end":{"line":789,"character":9999}},"line":778,"signature":{"label":"_split_on_comma($self,$str)","parameters":[{"label":"$self"},{"label":"$str"}],"documentation":""}},{"signature":{"label":"_check_colon($self,$line,$line_no)","parameters":[{"label":"$self"},{"label":"$line"},{"label":"$line_no"}],"documentation":" This method checks for an existing colon in a line"},"line":792,"range":{"end":{"line":799,"character":9999},"start":{"line":792,"character":0}},"kind":12,"definition":"sub","detail":"($self,$line,$line_no)","children":[{"definition":"my","line":793,"name":"$self","kind":13,"localvar":"my","containerName":"_check_colon"},{"name":"$line","containerName":"_check_colon","kind":13,"line":793},{"kind":13,"containerName":"_check_colon","name":"$line_no","line":793},{"line":794,"kind":13,"containerName":"_check_colon","name":"$line"},{"kind":13,"containerName":"_check_colon","name":"$line","line":794},{"line":795,"name":"$self","containerName":"_check_colon","kind":13},{"line":795,"containerName":"_check_colon","kind":12,"name":"throw"}],"containerName":"main::","name":"_check_colon"},{"detail":"($self,$val)","definition":"sub","containerName":"main::","name":"_handle_relationship_tag","children":[{"definition":"my","line":803,"kind":13,"localvar":"my","containerName":"_handle_relationship_tag","name":"$self"},{"containerName":"_handle_relationship_tag","kind":13,"name":"$val","line":803},{"name":"@parts","localvar":"my","kind":13,"containerName":"_handle_relationship_tag","line":804,"definition":"my"},{"name":"$val","containerName":"_handle_relationship_tag","kind":13,"line":804},{"definition":"my","name":"$relationship","kind":13,"localvar":"my","containerName":"_handle_relationship_tag","line":805},{"kind":13,"containerName":"_handle_relationship_tag","name":"$parts","line":805},{"definition":"my","localvar":"my","kind":13,"containerName":"_handle_relationship_tag","name":"$id","line":806},{"line":806,"name":"$parts","kind":13,"containerName":"_handle_relationship_tag"},{"line":806,"kind":13,"containerName":"_handle_relationship_tag","name":"$parts"},{"definition":"my","line":807,"localvar":"my","containerName":"_handle_relationship_tag","kind":13,"name":"$parent_term"},{"line":807,"name":"$self","containerName":"_handle_relationship_tag","kind":13},{"line":807,"containerName":"_handle_relationship_tag","kind":12,"name":"_create_term_object"},{"kind":13,"containerName":"_handle_relationship_tag","name":"$parent_term","line":808},{"line":808,"name":"identifier","containerName":"_handle_relationship_tag","kind":12},{"kind":13,"containerName":"_handle_relationship_tag","name":"$id","line":808},{"definition":"my","line":810,"localvar":"my","containerName":"_handle_relationship_tag","kind":13,"name":"$realtionships_hash"},{"containerName":"_handle_relationship_tag","kind":13,"name":"$self","line":810},{"definition":"my","line":811,"localvar":"my","kind":13,"containerName":"_handle_relationship_tag","name":"$id_array_ref"},{"line":811,"containerName":"_handle_relationship_tag","kind":13,"name":"$relationship"},{"name":"$id_array_ref","kind":13,"containerName":"_handle_relationship_tag","line":812},{"definition":"my","line":813,"containerName":"_handle_relationship_tag","localvar":"my","kind":13,"name":"@ids"},{"containerName":"_handle_relationship_tag","kind":13,"name":"@ids","line":814},{"name":"$id","containerName":"_handle_relationship_tag","kind":13,"line":814},{"line":815,"containerName":"_handle_relationship_tag","kind":13,"name":"$relationship"},{"kind":13,"containerName":"_handle_relationship_tag","name":"@ids","line":815},{"line":819,"kind":13,"containerName":"_handle_relationship_tag","name":"$id_array_ref"},{"line":819,"containerName":"_handle_relationship_tag","kind":13,"name":"$id"}],"signature":{"documentation":" This method handles relationship tags","parameters":[{"label":"$self"},{"label":"$val"}],"label":"_handle_relationship_tag($self,$val)"},"kind":12,"range":{"start":{"character":0,"line":802},"end":{"character":9999,"line":824}},"line":802},{"line":811,"kind":12,"name":"realtionships_hash"},{"line":815,"name":"realtionships_hash","kind":12},{"definition":"sub","detail":"($self,$links)","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"_to_annotation","name":"$self","line":828},{"containerName":"_to_annotation","kind":13,"name":"$links","line":828},{"line":829,"name":"$links","kind":13,"containerName":"_to_annotation"},{"definition":"my","name":"@dbxrefs","localvar":"my","kind":13,"containerName":"_to_annotation","line":830},{"kind":13,"localvar":"my","containerName":"_to_annotation","name":"$string","line":831,"definition":"my"},{"line":831,"name":"$links","containerName":"_to_annotation","kind":13}],"name":"_to_annotation","containerName":"main::","signature":{"documentation":" convert simple strings to Bio::Annotation::DBLinks","parameters":[{"label":"$self"},{"label":"$links"}],"label":"_to_annotation($self,$links)"},"line":827,"kind":12,"range":{"start":{"character":0,"line":827},"end":{"character":9999,"line":831}}},{"definition":"my","name":"$db","localvar":"my","kind":13,"containerName":null,"line":832},{"name":"$id","containerName":null,"kind":13,"line":832},{"name":"$string","containerName":null,"kind":13,"line":832},{"kind":13,"containerName":null,"name":"@dbxrefs","line":833},{"line":833,"kind":12,"containerName":"Annotation::DBLink","name":"Bio"},{"name":"new","containerName":"main::","kind":12,"line":833},{"name":"$db","kind":13,"containerName":null,"line":833},{"line":833,"name":"$id","kind":13,"containerName":null},{"line":835,"kind":13,"containerName":null,"name":"@dbxrefs"}],"version":5}