{"vars":[{"line":100,"name":"base","kind":2,"containerName":""},{"line":115,"kind":12,"range":{"start":{"character":0,"line":115},"end":{"character":9999,"line":125}},"signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: TermFactory.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::TermFactory\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n#\n# (c) Hilmar Lapp, hlapp at gmx.net, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n# \n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::TermFactory - Instantiates a new \nBio::Ontology::TermI (or derived class) through a factory\n\n=head1 SYNOPSIS\n\n    use Bio::Ontology::TermFactory;\n\n    # the default type is Bio::Ontology::Term\n    my $factory = Bio::Ontology::TermFactory->new(\n                        -type => 'Bio::Ontology::GOterm');\n    my $term = $factory->create_object(-name => 'peroxisome',\n                                       -ontology => 'Gene Ontology',\n                                       -identifier => 'GO:0005777');\n\n\n=head1 DESCRIPTION\n\nThis object will build L<Bio::Ontology::TermI> objects generically.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp at gmx.net\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::TermFactory;\nuse strict;\n\nuse Bio::Root::Root;\n\nuse base qw(Bio::Factory::ObjectFactory);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Ontology::TermFactory->new();\n Function: Builds a new Bio::Ontology::TermFactory object \n Returns : Bio::Ontology::TermFactory\n Args    : -type => string, name of a Bio::Ontology::TermI derived class.\n                    The default is Bio::Ontology::Term.\n\nSee L<Bio::Ontology::TermI>, L<Bio::Ontology::Term>."},"children":[{"localvar":"my","kind":13,"containerName":"new","name":"$class","line":116,"definition":"my"},{"line":116,"kind":13,"containerName":"new","name":"@args"},{"line":118,"localvar":"my","kind":13,"containerName":"new","name":"$self","definition":"my"},{"name":"$class","containerName":"new","kind":13,"line":118},{"line":118,"containerName":"new","kind":13,"name":"@args"},{"line":121,"name":"$self","kind":13,"containerName":"new"},{"kind":12,"containerName":"new","name":"interface","line":121},{"line":122,"name":"$self","containerName":"new","kind":13},{"name":"type","kind":12,"containerName":"new","line":122},{"containerName":"new","kind":13,"name":"$self","line":122},{"line":122,"kind":12,"containerName":"new","name":"type"},{"containerName":"new","kind":13,"name":"$self","line":124}],"containerName":"main::","name":"new","definition":"sub","detail":"($class,@args)"},{"line":118,"containerName":"new","kind":12,"name":"SUPER"}],"version":5}