{"vars":[{"name":"base","kind":2,"containerName":"","line":135},{"detail":"($class)","definition":"sub","name":"new","containerName":"main::","children":[{"definition":"my","name":"$class","kind":13,"localvar":"my","containerName":"new","line":150},{"line":151,"name":"$class","containerName":"new","kind":13},{"containerName":"new","kind":13,"name":"$class","line":151},{"line":151,"name":"$class","containerName":"new","kind":13},{"line":153,"name":"$self","localvar":"my","containerName":"new","kind":13,"definition":"my"},{"line":154,"name":"$Graph","kind":13,"containerName":"new"},{"line":154,"name":"$Graph","containerName":"new","kind":13},{"name":"$class","kind":13,"containerName":"new","line":155},{"kind":13,"containerName":"new","name":"$self","line":157},{"kind":13,"containerName":"new","name":"$self","line":158},{"line":159,"containerName":"new","kind":13,"name":"$self"},{"line":160,"name":"$self","containerName":"new","kind":13}],"signature":{"label":"new($class)","parameters":[{"label":"$class"}],"documentation":"1;\n# $Id: GraphAdaptor.pm 10525 2006-09-26 22:03:22Z sendu $\n#\n# BioPerl Graph adaptor for Bio::Ontology::SimpleGOEngine\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Nat Goodman <natg at shore.net>\n#\n# (c) Nathan Goodman natg@shore.net 2005\n# (c) ISB, Institute for Systems Biology 2005\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::SimpleGOEngine::GraphAdaptor - Graph adaptor for\nBio::Ontology::SimpleGOEngine\n\n=head1 SYNOPSIS\n\n  use Bio::Ontology::SimpleGOEngine::GraphAdaptor;\n\n  my $graph = Bio::Ontology::SimpleGOEngine::GraphAdaptor;\n\n=head1 DESCRIPTION\n\nThis is a think adaptor to simplify use of the old and new versions of\nthe standard CPAN Graph module (old is versions 0.2x; new is 0.5x and\nbeyond) within Bio::Ontology::SimpleGOEngine.\n\nThis module implements only those Graph methods used by\nSimpleGOEngine.  It is far from a complete compatibility layer!  It\nalso implements workarounds for cerain performance problems in the\ncurrent versions of Graph v0.5x.\n\nThis class provides a 'new' method that determines which version of\nGraph is available.  The object returned by 'new' is blessed into this\nclass if the new version of Graph is available, else into the subclass\n\n  Bio::Ontology::SimpleGOEngine::GraphAdaptor02\n\nThis class provides implementations for the required graph methods\nusing the new version of Graph.  In most cases, these are simple\npass-throughs.  Methods that differ in v0.2x are implemented in the\nsubclass.\n\nThe methods implemented here or in the subclasses are listed below.\nIn all cases, we implemented the Graph v0.5x interface.  Consult the\nGraph v0.5x man page for details.\n\n  add_vertex\n  has_vertex\n  add_edge\n  has_edge\n  vertices\n  edges\n  edges_at\n  predecessors\n  successors\n  set_vertex_attribute\n  get_vertex_attribute\n  set_edge_attribute\n  get_edge_attribute\n  source_vertices\n  sink_vertices\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nNat Goodman\n\nEmail: natg at shore.net\n\nAddress:\n\n  Institute for Systems Biology\n  1441 N 34th St\n  Seattle, WA 98103-8904\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Ontology::SimpleGOEngine::GraphAdaptor;\n\nuse Graph::Directed;\n\nuse strict;\nuse Bio::Ontology::SimpleGOEngine::GraphAdaptor02;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : $graph = Bio::Ontology::SimpleGOEngine::GraphAdaptor->new()\n Function: Creates a new graph\n Returns : Bio::Ontology::SimpleGOEngine::GraphAdaptor02 or \n           Bio::Ontology::SimpleGOEngine::GraphAdaptor05 object, \n           depending on which Graph version is available\n Args    : none"},"range":{"end":{"character":9999,"line":161},"start":{"line":149,"character":0}},"kind":12,"line":149},{"name":"VERSION","kind":12,"containerName":"","line":154},{"containerName":"","kind":12,"name":"VERSION","line":154},{"kind":12,"name":"_graph","line":157},{"line":158,"containerName":"Directed","kind":12,"name":"Graph"},{"line":158,"name":"_vertex_attributes","kind":12},{"kind":12,"name":"_edge_attributes","line":159},{"name":"add_vertex","containerName":"main::","children":[{"localvar":"my","kind":13,"containerName":"add_vertex","name":"$self","line":166,"definition":"my"},{"kind":13,"containerName":"add_vertex","name":"$self","line":167},{"name":"_graph","containerName":"add_vertex","kind":12,"line":167},{"name":"add_vertex","kind":12,"containerName":"add_vertex","line":167}],"definition":"sub","kind":12,"range":{"end":{"character":9999,"line":168},"start":{"character":0,"line":165}},"line":165},{"kind":12,"range":{"start":{"character":0,"line":169},"end":{"line":172,"character":9999}},"line":169,"containerName":"main::","name":"has_vertex","children":[{"line":170,"localvar":"my","kind":13,"containerName":"has_vertex","name":"$self","definition":"my"},{"name":"$self","kind":13,"containerName":"has_vertex","line":171},{"kind":12,"containerName":"has_vertex","name":"_graph","line":171},{"line":171,"name":"has_vertex","kind":12,"containerName":"has_vertex"}],"definition":"sub"},{"kind":12,"range":{"end":{"character":9999,"line":176},"start":{"character":0,"line":173}},"line":173,"definition":"sub","containerName":"main::","name":"add_edge","children":[{"definition":"my","name":"$self","containerName":"add_edge","localvar":"my","kind":13,"line":174},{"line":175,"name":"$self","kind":13,"containerName":"add_edge"},{"containerName":"add_edge","kind":12,"name":"_graph","line":175},{"line":175,"name":"add_edge","kind":12,"containerName":"add_edge"}]},{"kind":12,"range":{"start":{"character":0,"line":177},"end":{"line":180,"character":9999}},"line":177,"definition":"sub","name":"has_edge","containerName":"main::","children":[{"containerName":"has_edge","localvar":"my","kind":13,"name":"$self","line":178,"definition":"my"},{"name":"$self","containerName":"has_edge","kind":13,"line":179},{"name":"_graph","kind":12,"containerName":"has_edge","line":179},{"containerName":"has_edge","kind":12,"name":"has_edge","line":179}]},{"definition":"sub","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"vertices","line":182},{"line":183,"kind":13,"containerName":"vertices","name":"$self"},{"line":183,"containerName":"vertices","kind":12,"name":"_graph"},{"kind":12,"containerName":"vertices","name":"vertices","line":183}],"containerName":"main::","name":"vertices","line":181,"range":{"start":{"line":181,"character":0},"end":{"character":9999,"line":184}},"kind":12},{"containerName":"main::","name":"edges","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"edges","name":"$self","line":186},{"name":"$self","containerName":"edges","kind":13,"line":187},{"line":187,"containerName":"edges","kind":12,"name":"_graph"},{"containerName":"edges","kind":12,"name":"edges","line":187}],"definition":"sub","range":{"start":{"line":185,"character":0},"end":{"character":9999,"line":188}},"kind":12,"line":185},{"range":{"end":{"character":9999,"line":192},"start":{"character":0,"line":189}},"kind":12,"line":189,"name":"edges_at","containerName":"main::","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"edges_at","line":190},{"containerName":"edges_at","kind":13,"name":"$self","line":191},{"containerName":"edges_at","kind":12,"name":"_graph","line":191},{"line":191,"containerName":"edges_at","kind":12,"name":"edges_at"}],"definition":"sub"},{"line":193,"range":{"start":{"line":193,"character":0},"end":{"line":196,"character":9999}},"kind":12,"children":[{"definition":"my","line":194,"localvar":"my","kind":13,"containerName":"predecessors","name":"$self"},{"kind":13,"containerName":"predecessors","name":"$self","line":195},{"line":195,"containerName":"predecessors","kind":12,"name":"_graph"},{"line":195,"kind":12,"containerName":"predecessors","name":"predecessors"}],"containerName":"main::","name":"predecessors","definition":"sub"},{"definition":"sub","containerName":"main::","name":"successors","children":[{"name":"$self","localvar":"my","kind":13,"containerName":"successors","line":198,"definition":"my"},{"name":"$self","containerName":"successors","kind":13,"line":199},{"line":199,"name":"_graph","kind":12,"containerName":"successors"},{"line":199,"containerName":"successors","kind":12,"name":"successors"}],"kind":12,"range":{"end":{"character":9999,"line":200},"start":{"line":197,"character":0}},"line":197},{"definition":"sub","children":[{"line":202,"containerName":"source_vertices","localvar":"my","kind":13,"name":"$self","definition":"my"},{"line":203,"kind":13,"containerName":"source_vertices","name":"$self"},{"line":203,"name":"_graph","containerName":"source_vertices","kind":12},{"line":203,"name":"source_vertices","kind":12,"containerName":"source_vertices"}],"containerName":"main::","name":"source_vertices","line":201,"kind":12,"range":{"start":{"character":0,"line":201},"end":{"character":9999,"line":204}}},{"range":{"end":{"line":208,"character":9999},"start":{"line":205,"character":0}},"kind":12,"line":205,"definition":"sub","containerName":"main::","name":"sink_vertices","children":[{"line":206,"kind":13,"localvar":"my","containerName":"sink_vertices","name":"$self","definition":"my"},{"kind":13,"containerName":"sink_vertices","name":"$self","line":207},{"containerName":"sink_vertices","kind":12,"name":"_graph","line":207},{"containerName":"sink_vertices","kind":12,"name":"sink_vertices","line":207}]},{"signature":{"documentation":" The following methods workaround a performance problem in Graph v0.5x\n when attributes are attached to the graph","parameters":[{"label":"$self"},{"label":"$v"},{"label":"$attribute"},{"label":"$value"}],"label":"set_vertex_attribute($self,$v,$attribute,$value)"},"line":211,"range":{"end":{"line":214,"character":9999},"start":{"line":211,"character":0}},"kind":12,"definition":"sub","detail":"($self,$v,$attribute,$value)","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"set_vertex_attribute","name":"$self","line":212},{"line":212,"kind":13,"containerName":"set_vertex_attribute","name":"$v"},{"line":212,"kind":13,"containerName":"set_vertex_attribute","name":"$attribute"},{"kind":13,"containerName":"set_vertex_attribute","name":"$value","line":212},{"line":213,"kind":13,"containerName":"set_vertex_attribute","name":"$self"},{"line":213,"containerName":"set_vertex_attribute","kind":12,"name":"_vertex2attributes"},{"line":213,"name":"$v","containerName":"set_vertex_attribute","kind":13},{"line":213,"kind":13,"containerName":"set_vertex_attribute","name":"$attribute"},{"line":213,"name":"$value","containerName":"set_vertex_attribute","kind":13}],"containerName":"main::","name":"set_vertex_attribute"},{"signature":{"parameters":[{"label":"$self"},{"label":"$v"},{"label":"$attribute"}],"documentation":"","label":"get_vertex_attribute($self,$v,$attribute)"},"range":{"start":{"character":0,"line":215},"end":{"character":9999,"line":218}},"kind":12,"line":215,"detail":"($self,$v,$attribute)","definition":"sub","name":"get_vertex_attribute","containerName":"main::","children":[{"definition":"my","line":216,"localvar":"my","containerName":"get_vertex_attribute","kind":13,"name":"$self"},{"name":"$v","kind":13,"containerName":"get_vertex_attribute","line":216},{"line":216,"name":"$attribute","containerName":"get_vertex_attribute","kind":13},{"name":"$self","containerName":"get_vertex_attribute","kind":13,"line":217},{"containerName":"get_vertex_attribute","kind":12,"name":"_vertex2attributes","line":217},{"name":"$v","kind":13,"containerName":"get_vertex_attribute","line":217},{"name":"$attribute","kind":13,"containerName":"get_vertex_attribute","line":217}]},{"line":219,"kind":12,"range":{"start":{"character":0,"line":219},"end":{"line":222,"character":9999}},"signature":{"label":"set_edge_attribute($self,$u,$v,$attribute,$value)","documentation":"","parameters":[{"label":"$self"},{"label":"$u"},{"label":"$v"},{"label":"$attribute"},{"label":"$value"}]},"children":[{"line":220,"localvar":"my","containerName":"set_edge_attribute","kind":13,"name":"$self","definition":"my"},{"line":220,"name":"$u","containerName":"set_edge_attribute","kind":13},{"line":220,"kind":13,"containerName":"set_edge_attribute","name":"$v"},{"kind":13,"containerName":"set_edge_attribute","name":"$attribute","line":220},{"line":220,"name":"$value","containerName":"set_edge_attribute","kind":13},{"line":221,"containerName":"set_edge_attribute","kind":13,"name":"$self"},{"name":"_edge2attributes","containerName":"set_edge_attribute","kind":12,"line":221},{"kind":13,"containerName":"set_edge_attribute","name":"$u","line":221},{"line":221,"containerName":"set_edge_attribute","kind":13,"name":"$v"},{"containerName":"set_edge_attribute","kind":13,"name":"$attribute","line":221},{"line":221,"containerName":"set_edge_attribute","kind":13,"name":"$value"}],"containerName":"main::","name":"set_edge_attribute","definition":"sub","detail":"($self,$u,$v,$attribute,$value)"},{"children":[{"definition":"my","line":224,"name":"$self","localvar":"my","containerName":"get_edge_attribute","kind":13},{"kind":13,"containerName":"get_edge_attribute","name":"$u","line":224},{"name":"$v","containerName":"get_edge_attribute","kind":13,"line":224},{"line":224,"name":"$attribute","kind":13,"containerName":"get_edge_attribute"},{"line":225,"name":"$self","containerName":"get_edge_attribute","kind":13},{"line":225,"containerName":"get_edge_attribute","kind":12,"name":"_edge2attributes"},{"line":225,"name":"$u","containerName":"get_edge_attribute","kind":13},{"line":225,"containerName":"get_edge_attribute","kind":13,"name":"$v"},{"name":"$attribute","containerName":"get_edge_attribute","kind":13,"line":225}],"containerName":"main::","name":"get_edge_attribute","definition":"sub","detail":"($self,$u,$v,$attribute)","line":223,"range":{"start":{"character":0,"line":223},"end":{"character":9999,"line":226}},"kind":12,"signature":{"label":"get_edge_attribute($self,$u,$v,$attribute)","parameters":[{"label":"$self"},{"label":"$u"},{"label":"$v"},{"label":"$attribute"}],"documentation":""}},{"line":238,"range":{"end":{"character":9999,"line":238},"start":{"line":238,"character":0}},"kind":12,"children":[],"name":"_graph","containerName":"main::","definition":"sub"},{"name":"_graph","kind":12,"line":238},{"kind":12,"range":{"start":{"character":0,"line":250},"end":{"character":9999,"line":250}},"line":250,"name":"_vertex_attributes","containerName":"main::","children":[],"definition":"sub"},{"line":250,"name":"_vertex_attributes","kind":12},{"definition":"sub","children":[],"name":"_edge_attributes","containerName":"main::","line":262,"kind":12,"range":{"end":{"line":262,"character":9999},"start":{"character":0,"line":262}}},{"line":262,"kind":12,"name":"_edge_attributes"},{"signature":{"documentation":"1;\n# $Id: GraphAdaptor.pm 10525 2006-09-26 22:03:22Z sendu $\n#\n# BioPerl Graph adaptor for Bio::Ontology::SimpleGOEngine\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Nat Goodman <natg at shore.net>\n#\n# (c) Nathan Goodman natg@shore.net 2005\n# (c) ISB, Institute for Systems Biology 2005\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::SimpleGOEngine::GraphAdaptor - Graph adaptor for\nBio::Ontology::SimpleGOEngine\n\n=head1 SYNOPSIS\n\n  use Bio::Ontology::SimpleGOEngine::GraphAdaptor;\n\n  my $graph = Bio::Ontology::SimpleGOEngine::GraphAdaptor;\n\n=head1 DESCRIPTION\n\nThis is a think adaptor to simplify use of the old and new versions of\nthe standard CPAN Graph module (old is versions 0.2x; new is 0.5x and\nbeyond) within Bio::Ontology::SimpleGOEngine.\n\nThis module implements only those Graph methods used by\nSimpleGOEngine.  It is far from a complete compatibility layer!  It\nalso implements workarounds for cerain performance problems in the\ncurrent versions of Graph v0.5x.\n\nThis class provides a 'new' method that determines which version of\nGraph is available.  The object returned by 'new' is blessed into this\nclass if the new version of Graph is available, else into the subclass\n\n  Bio::Ontology::SimpleGOEngine::GraphAdaptor02\n\nThis class provides implementations for the required graph methods\nusing the new version of Graph.  In most cases, these are simple\npass-throughs.  Methods that differ in v0.2x are implemented in the\nsubclass.\n\nThe methods implemented here or in the subclasses are listed below.\nIn all cases, we implemented the Graph v0.5x interface.  Consult the\nGraph v0.5x man page for details.\n\n  add_vertex\n  has_vertex\n  add_edge\n  has_edge\n  vertices\n  edges\n  edges_at\n  predecessors\n  successors\n  set_vertex_attribute\n  get_vertex_attribute\n  set_edge_attribute\n  get_edge_attribute\n  source_vertices\n  sink_vertices\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nNat Goodman\n\nEmail: natg at shore.net\n\nAddress:\n\n  Institute for Systems Biology\n  1441 N 34th St\n  Seattle, WA 98103-8904\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Ontology::SimpleGOEngine::GraphAdaptor;\n\nuse Graph::Directed;\n\nuse strict;\nuse Bio::Ontology::SimpleGOEngine::GraphAdaptor02;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : $graph = Bio::Ontology::SimpleGOEngine::GraphAdaptor->new()\n Function: Creates a new graph\n Returns : Bio::Ontology::SimpleGOEngine::GraphAdaptor02 or \n           Bio::Ontology::SimpleGOEngine::GraphAdaptor05 object, \n           depending on which Graph version is available\n Args    : none\n\n\nsub new {\n  my( $class ) = @_;\n  $class = ref $class || $class;\n\n  my $self=\n    ( defined $Graph::VERSION && $Graph::VERSION >= 0.5 ) ?\n      bless ( {}, $class ) :\n\tbless ( {}, 'Bio::Ontology::SimpleGOEngine::GraphAdaptor02' );\n  $self->{_graph}=new Graph::Directed;\n  $self->{_vertex_attributes}={};\n  $self->{_edge_attributes}={};\n  return $self;\n}\n\n# Here are the main methods\n\nsub add_vertex {\n  my $self=shift;\n  $self->_graph->add_vertex(@_);\n}\nsub has_vertex {\n  my $self=shift;\n  $self->_graph->has_vertex(@_);\n}\nsub add_edge {\n  my $self=shift;\n  $self->_graph->add_edge(@_);\n}\nsub has_edge {\n  my $self=shift;\n  $self->_graph->has_edge(@_);\n}\nsub vertices {\n  my $self=shift;\n  $self->_graph->vertices(@_);\n}\nsub edges {\n  my $self=shift;\n  $self->_graph->edges(@_);\n}\nsub edges_at {\n  my $self=shift;\n  $self->_graph->edges_at(@_);\n}\nsub predecessors {\n  my $self=shift;\n  $self->_graph->predecessors(@_);\n} \nsub successors {\n  my $self=shift;\n  $self->_graph->successors(@_);\n}\nsub source_vertices {\n  my $self=shift;\n  $self->_graph->source_vertices();\n}\nsub sink_vertices {\n  my $self=shift;\n  $self->_graph->sink_vertices();\n}\n# The following methods workaround a performance problem in Graph v0.5x \n# when attributes are attached to the graph\nsub set_vertex_attribute {\n  my($self,$v,$attribute,$value)=@_;\n  $self->_vertex2attributes($v)->{$attribute}=$value;\n}\nsub get_vertex_attribute {\n  my($self,$v,$attribute)=@_;\n  $self->_vertex2attributes($v)->{$attribute};\n}\nsub set_edge_attribute {\n  my($self,$u,$v,$attribute,$value)=@_;\n  $self->_edge2attributes($u,$v)->{$attribute}=$value;\n}\nsub get_edge_attribute {\n  my($self,$u,$v,$attribute)=@_;\n  $self->_edge2attributes($u,$v)->{$attribute};\n}\n\n=head2 _graph\n\n Title   : _graph\n Usage   : $self->_graph();\n Function: Internal method to access 'real' graph\n Returns : Graph::Directed object \n Args    : none\n\n\nsub _graph {$_[0]->{_graph}; }\n\n=head2 _vertex_attributes\n\n Title   : _vertex_attributes\n Usage   : $self->vertex_attributes();\n Function: Internal method to access HASH used to store vertex attributes\n Returns : Graph::Directed object \n Args    : none\n\n\nsub _vertex_attributes {$_[0]->{_vertex_attributes}; }\n\n=head2 _edge_attributes\n\n Title   : _edge_attributes\n Usage   : $self->edge_attributes();\n Function: Internal method to access HASH used to store edge attributes\n Returns : Graph::Directed object \n Args    : none\n\n\nsub _edge_attributes {$_[0]->{_edge_attributes}; }\n\n=head2 _vertex2attributes\n\n Title   : _vertex2attributes\n Usage   : $value=$graph->_vertex2attributes($v_->{ATTRIBUTE};\n           $graph->_vertex2attributes($v)->{ATTRIBUTE}=$value;\n Function: Internal method to access attributes for a specific vertex\n Returns : HASH\n Args    : none","parameters":[{"label":"$self"},{"label":"$vertex"}],"label":"_vertex2attributes($self,$vertex)"},"line":275,"range":{"end":{"line":278,"character":9999},"start":{"character":0,"line":275}},"kind":12,"definition":"sub","detail":"($self,$vertex)","children":[{"definition":"my","line":276,"name":"$self","localvar":"my","kind":13,"containerName":"_vertex2attributes"},{"kind":13,"containerName":"_vertex2attributes","name":"$vertex","line":276},{"containerName":"_vertex2attributes","kind":13,"name":"$self","line":277},{"containerName":"_vertex2attributes","kind":12,"name":"_vertex_attributes","line":277},{"line":277,"name":"$vertex","containerName":"_vertex2attributes","kind":13},{"line":277,"name":"$self","containerName":"_vertex2attributes","kind":13},{"line":277,"kind":12,"containerName":"_vertex2attributes","name":"_vertex_attributes"},{"line":277,"name":"$vertex","kind":13,"containerName":"_vertex2attributes"}],"containerName":"main::","name":"_vertex2attributes"},{"kind":12,"range":{"start":{"line":291,"character":0},"end":{"character":9999,"line":294}},"line":291,"signature":{"label":"_edge2attributes($self,$u,$v)","documentation":"1;\n# $Id: GraphAdaptor.pm 10525 2006-09-26 22:03:22Z sendu $\n#\n# BioPerl Graph adaptor for Bio::Ontology::SimpleGOEngine\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Nat Goodman <natg at shore.net>\n#\n# (c) Nathan Goodman natg@shore.net 2005\n# (c) ISB, Institute for Systems Biology 2005\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::SimpleGOEngine::GraphAdaptor - Graph adaptor for\nBio::Ontology::SimpleGOEngine\n\n=head1 SYNOPSIS\n\n  use Bio::Ontology::SimpleGOEngine::GraphAdaptor;\n\n  my $graph = Bio::Ontology::SimpleGOEngine::GraphAdaptor;\n\n=head1 DESCRIPTION\n\nThis is a think adaptor to simplify use of the old and new versions of\nthe standard CPAN Graph module (old is versions 0.2x; new is 0.5x and\nbeyond) within Bio::Ontology::SimpleGOEngine.\n\nThis module implements only those Graph methods used by\nSimpleGOEngine.  It is far from a complete compatibility layer!  It\nalso implements workarounds for cerain performance problems in the\ncurrent versions of Graph v0.5x.\n\nThis class provides a 'new' method that determines which version of\nGraph is available.  The object returned by 'new' is blessed into this\nclass if the new version of Graph is available, else into the subclass\n\n  Bio::Ontology::SimpleGOEngine::GraphAdaptor02\n\nThis class provides implementations for the required graph methods\nusing the new version of Graph.  In most cases, these are simple\npass-throughs.  Methods that differ in v0.2x are implemented in the\nsubclass.\n\nThe methods implemented here or in the subclasses are listed below.\nIn all cases, we implemented the Graph v0.5x interface.  Consult the\nGraph v0.5x man page for details.\n\n  add_vertex\n  has_vertex\n  add_edge\n  has_edge\n  vertices\n  edges\n  edges_at\n  predecessors\n  successors\n  set_vertex_attribute\n  get_vertex_attribute\n  set_edge_attribute\n  get_edge_attribute\n  source_vertices\n  sink_vertices\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nNat Goodman\n\nEmail: natg at shore.net\n\nAddress:\n\n  Institute for Systems Biology\n  1441 N 34th St\n  Seattle, WA 98103-8904\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Ontology::SimpleGOEngine::GraphAdaptor;\n\nuse Graph::Directed;\n\nuse strict;\nuse Bio::Ontology::SimpleGOEngine::GraphAdaptor02;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : $graph = Bio::Ontology::SimpleGOEngine::GraphAdaptor->new()\n Function: Creates a new graph\n Returns : Bio::Ontology::SimpleGOEngine::GraphAdaptor02 or \n           Bio::Ontology::SimpleGOEngine::GraphAdaptor05 object, \n           depending on which Graph version is available\n Args    : none\n\n\nsub new {\n  my( $class ) = @_;\n  $class = ref $class || $class;\n\n  my $self=\n    ( defined $Graph::VERSION && $Graph::VERSION >= 0.5 ) ?\n      bless ( {}, $class ) :\n\tbless ( {}, 'Bio::Ontology::SimpleGOEngine::GraphAdaptor02' );\n  $self->{_graph}=new Graph::Directed;\n  $self->{_vertex_attributes}={};\n  $self->{_edge_attributes}={};\n  return $self;\n}\n\n# Here are the main methods\n\nsub add_vertex {\n  my $self=shift;\n  $self->_graph->add_vertex(@_);\n}\nsub has_vertex {\n  my $self=shift;\n  $self->_graph->has_vertex(@_);\n}\nsub add_edge {\n  my $self=shift;\n  $self->_graph->add_edge(@_);\n}\nsub has_edge {\n  my $self=shift;\n  $self->_graph->has_edge(@_);\n}\nsub vertices {\n  my $self=shift;\n  $self->_graph->vertices(@_);\n}\nsub edges {\n  my $self=shift;\n  $self->_graph->edges(@_);\n}\nsub edges_at {\n  my $self=shift;\n  $self->_graph->edges_at(@_);\n}\nsub predecessors {\n  my $self=shift;\n  $self->_graph->predecessors(@_);\n} \nsub successors {\n  my $self=shift;\n  $self->_graph->successors(@_);\n}\nsub source_vertices {\n  my $self=shift;\n  $self->_graph->source_vertices();\n}\nsub sink_vertices {\n  my $self=shift;\n  $self->_graph->sink_vertices();\n}\n# The following methods workaround a performance problem in Graph v0.5x \n# when attributes are attached to the graph\nsub set_vertex_attribute {\n  my($self,$v,$attribute,$value)=@_;\n  $self->_vertex2attributes($v)->{$attribute}=$value;\n}\nsub get_vertex_attribute {\n  my($self,$v,$attribute)=@_;\n  $self->_vertex2attributes($v)->{$attribute};\n}\nsub set_edge_attribute {\n  my($self,$u,$v,$attribute,$value)=@_;\n  $self->_edge2attributes($u,$v)->{$attribute}=$value;\n}\nsub get_edge_attribute {\n  my($self,$u,$v,$attribute)=@_;\n  $self->_edge2attributes($u,$v)->{$attribute};\n}\n\n=head2 _graph\n\n Title   : _graph\n Usage   : $self->_graph();\n Function: Internal method to access 'real' graph\n Returns : Graph::Directed object \n Args    : none\n\n\nsub _graph {$_[0]->{_graph}; }\n\n=head2 _vertex_attributes\n\n Title   : _vertex_attributes\n Usage   : $self->vertex_attributes();\n Function: Internal method to access HASH used to store vertex attributes\n Returns : Graph::Directed object \n Args    : none\n\n\nsub _vertex_attributes {$_[0]->{_vertex_attributes}; }\n\n=head2 _edge_attributes\n\n Title   : _edge_attributes\n Usage   : $self->edge_attributes();\n Function: Internal method to access HASH used to store edge attributes\n Returns : Graph::Directed object \n Args    : none\n\n\nsub _edge_attributes {$_[0]->{_edge_attributes}; }\n\n=head2 _vertex2attributes\n\n Title   : _vertex2attributes\n Usage   : $value=$graph->_vertex2attributes($v_->{ATTRIBUTE};\n           $graph->_vertex2attributes($v)->{ATTRIBUTE}=$value;\n Function: Internal method to access attributes for a specific vertex\n Returns : HASH\n Args    : none\n\n\nsub _vertex2attributes {\n  my($self,$vertex)=@_;\n  $self->_vertex_attributes->{$vertex} or $self->_vertex_attributes->{$vertex}={};\n}\n\n=head2 _edge2attributes\n\n Title   : _edge2attributes\n Usage   : $value=$graph->_edge2attributes($u,$v)->{ATTRIBUTE};\n           $graph->_edge2attributes($u,$v)->{ATTRIBUTE}=$value;\n Function: Internal method to access HASH used to store edge attributes\n Returns : HASH\n Args    : none","parameters":[{"label":"$self"},{"label":"$u"},{"label":"$v"}]},"containerName":"main::","name":"_edge2attributes","children":[{"definition":"my","line":292,"localvar":"my","kind":13,"containerName":"_edge2attributes","name":"$self"},{"line":292,"name":"$u","containerName":"_edge2attributes","kind":13},{"line":292,"name":"$v","containerName":"_edge2attributes","kind":13},{"kind":13,"containerName":"_edge2attributes","name":"$self","line":293},{"line":293,"name":"_edge_attributes","kind":12,"containerName":"_edge2attributes"},{"name":"$u","containerName":"_edge2attributes","kind":13,"line":293},{"name":"$v","containerName":"_edge2attributes","kind":13,"line":293},{"name":"$self","containerName":"_edge2attributes","kind":13,"line":293},{"line":293,"name":"_edge_attributes","kind":12,"containerName":"_edge2attributes"},{"kind":13,"containerName":"_edge2attributes","name":"$u","line":293},{"name":"$v","kind":13,"containerName":"_edge2attributes","line":293}],"detail":"($self,$u,$v)","definition":"sub"}],"version":5}