{"version":5,"vars":[{"containerName":"","kind":2,"name":"base","line":118},{"definition":"sub","detail":"($class,@args)","children":[{"line":141,"name":"$class","localvar":"my","kind":13,"containerName":"new","definition":"my"},{"line":141,"kind":13,"containerName":"new","name":"@args"},{"name":"$self","containerName":"new","localvar":"my","kind":13,"line":143,"definition":"my"},{"line":143,"name":"$class","containerName":"new","kind":13},{"line":143,"kind":13,"containerName":"new","name":"@args"},{"line":145,"localvar":"my","kind":13,"containerName":"new","name":"$identifier","definition":"my"},{"line":146,"containerName":"new","kind":13,"name":"$subject_term"},{"kind":13,"containerName":"new","name":"$child","line":147},{"name":"$object_term","containerName":"new","kind":13,"line":148},{"line":149,"name":"$parent","kind":13,"containerName":"new"},{"line":150,"name":"$predicate_term","containerName":"new","kind":13},{"line":151,"kind":13,"containerName":"new","name":"$reltype"},{"name":"$ont","containerName":"new","kind":13,"line":152},{"line":153,"containerName":"new","kind":13,"name":"$self"},{"containerName":"new","kind":12,"name":"_rearrange","line":153},{"line":161,"kind":13,"containerName":"new","name":"@args"},{"containerName":"new","kind":13,"name":"$self","line":163},{"line":163,"kind":12,"containerName":"new","name":"init"},{"name":"$self","containerName":"new","kind":13,"line":165},{"name":"identifier","kind":12,"containerName":"new","line":165},{"line":165,"name":"$identifier","containerName":"new","kind":13},{"name":"$subject_term","containerName":"new","kind":13,"line":166},{"containerName":"new","kind":13,"name":"$child","line":166},{"name":"$subject_term","containerName":"new","kind":13,"line":166},{"line":167,"name":"$object_term","containerName":"new","kind":13},{"containerName":"new","kind":13,"name":"$parent","line":167},{"kind":13,"containerName":"new","name":"$object_term","line":167},{"name":"$predicate_term","containerName":"new","kind":13,"line":168},{"line":168,"name":"$reltype","containerName":"new","kind":13},{"kind":13,"containerName":"new","name":"$predicate_term","line":168},{"line":169,"kind":13,"containerName":"new","name":"$self"},{"name":"subject_term","kind":12,"containerName":"new","line":169},{"line":169,"kind":13,"containerName":"new","name":"$subject_term"},{"name":"$subject_term","containerName":"new","kind":13,"line":169},{"line":170,"containerName":"new","kind":13,"name":"$self"},{"containerName":"new","kind":12,"name":"object_term","line":170},{"name":"$object_term","kind":13,"containerName":"new","line":170},{"kind":13,"containerName":"new","name":"$object_term","line":170},{"line":171,"name":"$self","kind":13,"containerName":"new"},{"containerName":"new","kind":12,"name":"predicate_term","line":171},{"line":171,"name":"$predicate_term","containerName":"new","kind":13},{"line":171,"name":"$predicate_term","kind":13,"containerName":"new"},{"line":172,"containerName":"new","kind":13,"name":"$self"},{"line":172,"name":"ontology","kind":12,"containerName":"new"},{"line":172,"name":"$ont","containerName":"new","kind":13},{"containerName":"new","kind":13,"name":"$ont","line":172},{"containerName":"new","kind":13,"name":"$self","line":174}],"containerName":"main::","name":"new","signature":{"label":"new($class,@args)","documentation":"1;\n# $Id: Relationship.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Relationship\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::Relationship - a relationship for an ontology\n\n=head1 SYNOPSIS\n\n  $rel = Bio::Ontology::Relationship->new( -identifier     => \"16847\",\n                                           -subject_term   => $subj,\n                                           -object_term    => $obj,\n                                           -predicate_term => $pred );\n\n=head1 DESCRIPTION\n\nThis is a basic implementation of Bio::Ontology::RelationshipI. \n\nThe terminology we use here is the one commonly used for ontologies,\nnamely the triple of (subject, predicate, object), which in addition\nis scoped in a namespace (ontology). It is called triple because it is\na tuple of three ontology terms.\n\nThere are other terminologies in use for expressing relationships. For\nthose who it helps to better understand the concept, the triple of\n(child, relationship type, parent) would be equivalent to the\nterminology chosen here, disregarding the question whether the notion\nof parent and child is sensible in the context of the relationship\ntype or not. Especially in the case of ontologies with a wide variety\nof predicates the parent/child terminology and similar ones can\nquickly become ambiguous (e.g., A synthesises B), meaningless (e.g., A\nbinds B), or even conflicting (e.g., A is-parent-of B), and are\ntherefore strongly discouraged.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 CONTRIBUTORS\n\n Hilmar Lapp, email: hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::Relationship;\nuse strict;\nuse Bio::Ontology::TermI;\n\nuse base qw(Bio::Root::Root Bio::Ontology::RelationshipI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $rel = Bio::Ontology::Relationship->new(-identifier   => \"16847\",\n                                                   -subject_term => $subject,\n                                                   -object_term  => $object,\n                                                   -predicate_term => $type );\n Function: Creates a new Bio::Ontology::Relationship.\n Returns : A new Bio::Ontology::Relationship object.\n Args    : -identifier     => the identifier of this relationship [scalar]\n           -subject_term   => the subject term [Bio::Ontology::TermI]\n           -object_term    => the object term [Bio::Ontology::TermI]  \n           -predicate_term => the predicate term [Bio::Ontology::TermI]","parameters":[{"label":"$class"},{"label":"@args"}]},"line":139,"kind":12,"range":{"start":{"character":0,"line":139},"end":{"character":9999,"line":176}}},{"containerName":"new","kind":12,"name":"SUPER","line":143},{"children":[{"definition":"my","line":191,"localvar":"my","containerName":"init","kind":13,"name":"$self"},{"name":"$self","kind":13,"containerName":"init","line":193},{"line":194,"kind":13,"containerName":"init","name":"$self"},{"containerName":"init","kind":13,"name":"$self","line":195},{"kind":13,"containerName":"init","name":"$self","line":196},{"name":"$self","containerName":"init","kind":13,"line":197},{"name":"ontology","kind":12,"containerName":"init","line":197}],"containerName":"main::","name":"init","definition":"sub","detail":"($self)","line":190,"kind":12,"range":{"start":{"line":190,"character":0},"end":{"character":9999,"line":199}},"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Relationship.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Relationship\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::Relationship - a relationship for an ontology\n\n=head1 SYNOPSIS\n\n  $rel = Bio::Ontology::Relationship->new( -identifier     => \"16847\",\n                                           -subject_term   => $subj,\n                                           -object_term    => $obj,\n                                           -predicate_term => $pred );\n\n=head1 DESCRIPTION\n\nThis is a basic implementation of Bio::Ontology::RelationshipI. \n\nThe terminology we use here is the one commonly used for ontologies,\nnamely the triple of (subject, predicate, object), which in addition\nis scoped in a namespace (ontology). It is called triple because it is\na tuple of three ontology terms.\n\nThere are other terminologies in use for expressing relationships. For\nthose who it helps to better understand the concept, the triple of\n(child, relationship type, parent) would be equivalent to the\nterminology chosen here, disregarding the question whether the notion\nof parent and child is sensible in the context of the relationship\ntype or not. Especially in the case of ontologies with a wide variety\nof predicates the parent/child terminology and similar ones can\nquickly become ambiguous (e.g., A synthesises B), meaningless (e.g., A\nbinds B), or even conflicting (e.g., A is-parent-of B), and are\ntherefore strongly discouraged.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 CONTRIBUTORS\n\n Hilmar Lapp, email: hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::Relationship;\nuse strict;\nuse Bio::Ontology::TermI;\n\nuse base qw(Bio::Root::Root Bio::Ontology::RelationshipI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $rel = Bio::Ontology::Relationship->new(-identifier   => \"16847\",\n                                                   -subject_term => $subject,\n                                                   -object_term  => $object,\n                                                   -predicate_term => $type );\n Function: Creates a new Bio::Ontology::Relationship.\n Returns : A new Bio::Ontology::Relationship object.\n Args    : -identifier     => the identifier of this relationship [scalar]\n           -subject_term   => the subject term [Bio::Ontology::TermI]\n           -object_term    => the object term [Bio::Ontology::TermI]  \n           -predicate_term => the predicate term [Bio::Ontology::TermI]\n\n\nsub new {\n\n    my( $class, @args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n   \n    my ( $identifier,\n         $subject_term,\n\t\t\t$child,        # for backwards compatibility\n         $object_term,\n\t\t\t$parent,       # for backwards compatibility\n         $predicate_term,\n\t\t\t$reltype,      # for backwards compatibility\n\t\t\t$ont)\n\t= $self->_rearrange( [qw( IDENTIFIER\n\t\t\t\t  SUBJECT_TERM\n\t\t\t\t  CHILD_TERM\n\t\t\t\t  OBJECT_TERM\n\t\t\t\t  PARENT_TERM\n\t\t\t\t  PREDICATE_TERM\n\t\t\t\t  RELATIONSHIP_TYPE\n\t\t\t\t  ONTOLOGY)\n\t\t\t      ], @args );\n   \n    $self->init(); \n    \n    $self->identifier( $identifier );\n    $subject_term = $child unless $subject_term;\n    $object_term = $parent unless $object_term;\n    $predicate_term = $reltype unless $predicate_term;\n    $self->subject_term( $subject_term) if $subject_term;\n    $self->object_term( $object_term) if $object_term;\n    $self->predicate_term( $predicate_term ) if $predicate_term;\n    $self->ontology($ont) if $ont;\n                                                    \n    return $self;\n    \n} # new\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $rel->init();   \n Function: Initializes this Relationship to all undef.\n Returns : \n Args    :","label":"init($self)"}},{"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Relationship.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Relationship\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::Relationship - a relationship for an ontology\n\n=head1 SYNOPSIS\n\n  $rel = Bio::Ontology::Relationship->new( -identifier     => \"16847\",\n                                           -subject_term   => $subj,\n                                           -object_term    => $obj,\n                                           -predicate_term => $pred );\n\n=head1 DESCRIPTION\n\nThis is a basic implementation of Bio::Ontology::RelationshipI. \n\nThe terminology we use here is the one commonly used for ontologies,\nnamely the triple of (subject, predicate, object), which in addition\nis scoped in a namespace (ontology). It is called triple because it is\na tuple of three ontology terms.\n\nThere are other terminologies in use for expressing relationships. For\nthose who it helps to better understand the concept, the triple of\n(child, relationship type, parent) would be equivalent to the\nterminology chosen here, disregarding the question whether the notion\nof parent and child is sensible in the context of the relationship\ntype or not. Especially in the case of ontologies with a wide variety\nof predicates the parent/child terminology and similar ones can\nquickly become ambiguous (e.g., A synthesises B), meaningless (e.g., A\nbinds B), or even conflicting (e.g., A is-parent-of B), and are\ntherefore strongly discouraged.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 CONTRIBUTORS\n\n Hilmar Lapp, email: hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::Relationship;\nuse strict;\nuse Bio::Ontology::TermI;\n\nuse base qw(Bio::Root::Root Bio::Ontology::RelationshipI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $rel = Bio::Ontology::Relationship->new(-identifier   => \"16847\",\n                                                   -subject_term => $subject,\n                                                   -object_term  => $object,\n                                                   -predicate_term => $type );\n Function: Creates a new Bio::Ontology::Relationship.\n Returns : A new Bio::Ontology::Relationship object.\n Args    : -identifier     => the identifier of this relationship [scalar]\n           -subject_term   => the subject term [Bio::Ontology::TermI]\n           -object_term    => the object term [Bio::Ontology::TermI]  \n           -predicate_term => the predicate term [Bio::Ontology::TermI]\n\n\nsub new {\n\n    my( $class, @args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n   \n    my ( $identifier,\n         $subject_term,\n\t\t\t$child,        # for backwards compatibility\n         $object_term,\n\t\t\t$parent,       # for backwards compatibility\n         $predicate_term,\n\t\t\t$reltype,      # for backwards compatibility\n\t\t\t$ont)\n\t= $self->_rearrange( [qw( IDENTIFIER\n\t\t\t\t  SUBJECT_TERM\n\t\t\t\t  CHILD_TERM\n\t\t\t\t  OBJECT_TERM\n\t\t\t\t  PARENT_TERM\n\t\t\t\t  PREDICATE_TERM\n\t\t\t\t  RELATIONSHIP_TYPE\n\t\t\t\t  ONTOLOGY)\n\t\t\t      ], @args );\n   \n    $self->init(); \n    \n    $self->identifier( $identifier );\n    $subject_term = $child unless $subject_term;\n    $object_term = $parent unless $object_term;\n    $predicate_term = $reltype unless $predicate_term;\n    $self->subject_term( $subject_term) if $subject_term;\n    $self->object_term( $object_term) if $object_term;\n    $self->predicate_term( $predicate_term ) if $predicate_term;\n    $self->ontology($ont) if $ont;\n                                                    \n    return $self;\n    \n} # new\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $rel->init();   \n Function: Initializes this Relationship to all undef.\n Returns : \n Args    :\n\n\nsub init {\n    my( $self ) = @_;\n    \n    $self->{ \"_identifier\" }     = undef;\n    $self->{ \"_subject_term\" }   = undef;\n    $self->{ \"_object_term\" }    = undef;\n    $self->{ \"_predicate_term\" } = undef;\n    $self->ontology(undef);\n   \n} # init\n\n\n\n=head2 identifier\n\n Title   : identifier\n Usage   : $rel->identifier( \"100050\" );\n           or\n           print $rel->identifier();\n Function: Set/get for the identifier of this Relationship.\n Returns : The identifier [scalar].\n Args    : The identifier [scalar] (optional).","label":"identifier($self,$value)"},"line":215,"range":{"start":{"character":0,"line":215},"end":{"character":9999,"line":223}},"kind":12,"definition":"sub","detail":"($self,$value)","children":[{"definition":"my","line":216,"name":"$self","containerName":"identifier","localvar":"my","kind":13},{"containerName":"identifier","kind":13,"name":"$value","line":216},{"line":218,"name":"$value","containerName":"identifier","kind":13},{"kind":13,"containerName":"identifier","name":"$self","line":219},{"line":219,"name":"$value","containerName":"identifier","kind":13},{"name":"$self","kind":13,"containerName":"identifier","line":222}],"name":"identifier","containerName":"main::"},{"definition":"sub","detail":"($self,$term)","children":[{"definition":"my","localvar":"my","containerName":"subject_term","kind":13,"name":"$self","line":246},{"line":246,"containerName":"subject_term","kind":13,"name":"$term"},{"line":248,"kind":13,"containerName":"subject_term","name":"$term"},{"line":249,"name":"$self","containerName":"subject_term","kind":13},{"name":"_check_class","containerName":"subject_term","kind":12,"line":249},{"line":249,"kind":13,"containerName":"subject_term","name":"$term"},{"line":250,"name":"$self","kind":13,"containerName":"subject_term"},{"name":"$term","kind":13,"containerName":"subject_term","line":250},{"line":253,"name":"$self","containerName":"subject_term","kind":13}],"containerName":"main::","name":"subject_term","signature":{"parameters":[{"label":"$self"},{"label":"$term"}],"documentation":"1;\n# $Id: Relationship.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Relationship\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::Relationship - a relationship for an ontology\n\n=head1 SYNOPSIS\n\n  $rel = Bio::Ontology::Relationship->new( -identifier     => \"16847\",\n                                           -subject_term   => $subj,\n                                           -object_term    => $obj,\n                                           -predicate_term => $pred );\n\n=head1 DESCRIPTION\n\nThis is a basic implementation of Bio::Ontology::RelationshipI. \n\nThe terminology we use here is the one commonly used for ontologies,\nnamely the triple of (subject, predicate, object), which in addition\nis scoped in a namespace (ontology). It is called triple because it is\na tuple of three ontology terms.\n\nThere are other terminologies in use for expressing relationships. For\nthose who it helps to better understand the concept, the triple of\n(child, relationship type, parent) would be equivalent to the\nterminology chosen here, disregarding the question whether the notion\nof parent and child is sensible in the context of the relationship\ntype or not. Especially in the case of ontologies with a wide variety\nof predicates the parent/child terminology and similar ones can\nquickly become ambiguous (e.g., A synthesises B), meaningless (e.g., A\nbinds B), or even conflicting (e.g., A is-parent-of B), and are\ntherefore strongly discouraged.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 CONTRIBUTORS\n\n Hilmar Lapp, email: hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::Relationship;\nuse strict;\nuse Bio::Ontology::TermI;\n\nuse base qw(Bio::Root::Root Bio::Ontology::RelationshipI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $rel = Bio::Ontology::Relationship->new(-identifier   => \"16847\",\n                                                   -subject_term => $subject,\n                                                   -object_term  => $object,\n                                                   -predicate_term => $type );\n Function: Creates a new Bio::Ontology::Relationship.\n Returns : A new Bio::Ontology::Relationship object.\n Args    : -identifier     => the identifier of this relationship [scalar]\n           -subject_term   => the subject term [Bio::Ontology::TermI]\n           -object_term    => the object term [Bio::Ontology::TermI]  \n           -predicate_term => the predicate term [Bio::Ontology::TermI]\n\n\nsub new {\n\n    my( $class, @args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n   \n    my ( $identifier,\n         $subject_term,\n\t\t\t$child,        # for backwards compatibility\n         $object_term,\n\t\t\t$parent,       # for backwards compatibility\n         $predicate_term,\n\t\t\t$reltype,      # for backwards compatibility\n\t\t\t$ont)\n\t= $self->_rearrange( [qw( IDENTIFIER\n\t\t\t\t  SUBJECT_TERM\n\t\t\t\t  CHILD_TERM\n\t\t\t\t  OBJECT_TERM\n\t\t\t\t  PARENT_TERM\n\t\t\t\t  PREDICATE_TERM\n\t\t\t\t  RELATIONSHIP_TYPE\n\t\t\t\t  ONTOLOGY)\n\t\t\t      ], @args );\n   \n    $self->init(); \n    \n    $self->identifier( $identifier );\n    $subject_term = $child unless $subject_term;\n    $object_term = $parent unless $object_term;\n    $predicate_term = $reltype unless $predicate_term;\n    $self->subject_term( $subject_term) if $subject_term;\n    $self->object_term( $object_term) if $object_term;\n    $self->predicate_term( $predicate_term ) if $predicate_term;\n    $self->ontology($ont) if $ont;\n                                                    \n    return $self;\n    \n} # new\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $rel->init();   \n Function: Initializes this Relationship to all undef.\n Returns : \n Args    :\n\n\nsub init {\n    my( $self ) = @_;\n    \n    $self->{ \"_identifier\" }     = undef;\n    $self->{ \"_subject_term\" }   = undef;\n    $self->{ \"_object_term\" }    = undef;\n    $self->{ \"_predicate_term\" } = undef;\n    $self->ontology(undef);\n   \n} # init\n\n\n\n=head2 identifier\n\n Title   : identifier\n Usage   : $rel->identifier( \"100050\" );\n           or\n           print $rel->identifier();\n Function: Set/get for the identifier of this Relationship.\n Returns : The identifier [scalar].\n Args    : The identifier [scalar] (optional).\n\n\nsub identifier {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_identifier\" } = $value;\n    }\n\n    return $self->{ \"_identifier\" };\n} # identifier\n\n\n\n\n=head2 subject_term\n\n Title   : subject_term\n Usage   : $rel->subject_term( $subject );\n           or\n           $subject = $rel->subject_term();\n Function: Set/get for the subject term of this Relationship.\n\n           The common convention for ontologies is to express\n           relationships between terms as triples (subject, predicate,\n           object).\n\n Returns : The subject term [Bio::Ontology::TermI].\n Args    : The subject term [Bio::Ontology::TermI] (optional).","label":"subject_term($self,$term)"},"line":245,"range":{"end":{"character":9999,"line":255},"start":{"character":0,"line":245}},"kind":12},{"line":276,"range":{"start":{"line":276,"character":0},"end":{"character":9999,"line":285}},"kind":12,"signature":{"label":"object_term($self,$term)","parameters":[{"label":"$self"},{"label":"$term"}],"documentation":"1;\n# $Id: Relationship.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Relationship\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::Relationship - a relationship for an ontology\n\n=head1 SYNOPSIS\n\n  $rel = Bio::Ontology::Relationship->new( -identifier     => \"16847\",\n                                           -subject_term   => $subj,\n                                           -object_term    => $obj,\n                                           -predicate_term => $pred );\n\n=head1 DESCRIPTION\n\nThis is a basic implementation of Bio::Ontology::RelationshipI. \n\nThe terminology we use here is the one commonly used for ontologies,\nnamely the triple of (subject, predicate, object), which in addition\nis scoped in a namespace (ontology). It is called triple because it is\na tuple of three ontology terms.\n\nThere are other terminologies in use for expressing relationships. For\nthose who it helps to better understand the concept, the triple of\n(child, relationship type, parent) would be equivalent to the\nterminology chosen here, disregarding the question whether the notion\nof parent and child is sensible in the context of the relationship\ntype or not. Especially in the case of ontologies with a wide variety\nof predicates the parent/child terminology and similar ones can\nquickly become ambiguous (e.g., A synthesises B), meaningless (e.g., A\nbinds B), or even conflicting (e.g., A is-parent-of B), and are\ntherefore strongly discouraged.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 CONTRIBUTORS\n\n Hilmar Lapp, email: hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::Relationship;\nuse strict;\nuse Bio::Ontology::TermI;\n\nuse base qw(Bio::Root::Root Bio::Ontology::RelationshipI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $rel = Bio::Ontology::Relationship->new(-identifier   => \"16847\",\n                                                   -subject_term => $subject,\n                                                   -object_term  => $object,\n                                                   -predicate_term => $type );\n Function: Creates a new Bio::Ontology::Relationship.\n Returns : A new Bio::Ontology::Relationship object.\n Args    : -identifier     => the identifier of this relationship [scalar]\n           -subject_term   => the subject term [Bio::Ontology::TermI]\n           -object_term    => the object term [Bio::Ontology::TermI]  \n           -predicate_term => the predicate term [Bio::Ontology::TermI]\n\n\nsub new {\n\n    my( $class, @args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n   \n    my ( $identifier,\n         $subject_term,\n\t\t\t$child,        # for backwards compatibility\n         $object_term,\n\t\t\t$parent,       # for backwards compatibility\n         $predicate_term,\n\t\t\t$reltype,      # for backwards compatibility\n\t\t\t$ont)\n\t= $self->_rearrange( [qw( IDENTIFIER\n\t\t\t\t  SUBJECT_TERM\n\t\t\t\t  CHILD_TERM\n\t\t\t\t  OBJECT_TERM\n\t\t\t\t  PARENT_TERM\n\t\t\t\t  PREDICATE_TERM\n\t\t\t\t  RELATIONSHIP_TYPE\n\t\t\t\t  ONTOLOGY)\n\t\t\t      ], @args );\n   \n    $self->init(); \n    \n    $self->identifier( $identifier );\n    $subject_term = $child unless $subject_term;\n    $object_term = $parent unless $object_term;\n    $predicate_term = $reltype unless $predicate_term;\n    $self->subject_term( $subject_term) if $subject_term;\n    $self->object_term( $object_term) if $object_term;\n    $self->predicate_term( $predicate_term ) if $predicate_term;\n    $self->ontology($ont) if $ont;\n                                                    \n    return $self;\n    \n} # new\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $rel->init();   \n Function: Initializes this Relationship to all undef.\n Returns : \n Args    :\n\n\nsub init {\n    my( $self ) = @_;\n    \n    $self->{ \"_identifier\" }     = undef;\n    $self->{ \"_subject_term\" }   = undef;\n    $self->{ \"_object_term\" }    = undef;\n    $self->{ \"_predicate_term\" } = undef;\n    $self->ontology(undef);\n   \n} # init\n\n\n\n=head2 identifier\n\n Title   : identifier\n Usage   : $rel->identifier( \"100050\" );\n           or\n           print $rel->identifier();\n Function: Set/get for the identifier of this Relationship.\n Returns : The identifier [scalar].\n Args    : The identifier [scalar] (optional).\n\n\nsub identifier {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_identifier\" } = $value;\n    }\n\n    return $self->{ \"_identifier\" };\n} # identifier\n\n\n\n\n=head2 subject_term\n\n Title   : subject_term\n Usage   : $rel->subject_term( $subject );\n           or\n           $subject = $rel->subject_term();\n Function: Set/get for the subject term of this Relationship.\n\n           The common convention for ontologies is to express\n           relationships between terms as triples (subject, predicate,\n           object).\n\n Returns : The subject term [Bio::Ontology::TermI].\n Args    : The subject term [Bio::Ontology::TermI] (optional).\n\n\nsub subject_term {\n    my ( $self, $term ) = @_;\n  \n    if ( defined $term ) {\n        $self->_check_class( $term, \"Bio::Ontology::TermI\" );\n        $self->{ \"_subject_term\" } = $term;\n    }\n\n    return $self->{ \"_subject_term\" };\n    \n} # subject_term\n\n\n\n=head2 object_term\n\n Title   : object_term\n Usage   : $rel->object_term( $object );\n           or\n           $object = $rel->object_term();\n Function: Set/get for the object term of this Relationship.\n\n           The common convention for ontologies is to express\n           relationships between terms as triples (subject, predicate,\n           object).\n\n Returns : The object term [Bio::Ontology::TermI].\n Args    : The object term [Bio::Ontology::TermI] (optional)."},"children":[{"name":"$self","kind":13,"localvar":"my","containerName":"object_term","line":277,"definition":"my"},{"line":277,"kind":13,"containerName":"object_term","name":"$term"},{"line":279,"name":"$term","kind":13,"containerName":"object_term"},{"name":"$self","kind":13,"containerName":"object_term","line":280},{"line":280,"name":"_check_class","containerName":"object_term","kind":12},{"line":280,"containerName":"object_term","kind":13,"name":"$term"},{"kind":13,"containerName":"object_term","name":"$self","line":281},{"line":281,"kind":13,"containerName":"object_term","name":"$term"},{"name":"$self","kind":13,"containerName":"object_term","line":284}],"name":"object_term","containerName":"main::","definition":"sub","detail":"($self,$term)"},{"range":{"end":{"character":9999,"line":316},"start":{"line":307,"character":0}},"kind":12,"line":307,"signature":{"documentation":"1;\n# $Id: Relationship.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Relationship\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::Relationship - a relationship for an ontology\n\n=head1 SYNOPSIS\n\n  $rel = Bio::Ontology::Relationship->new( -identifier     => \"16847\",\n                                           -subject_term   => $subj,\n                                           -object_term    => $obj,\n                                           -predicate_term => $pred );\n\n=head1 DESCRIPTION\n\nThis is a basic implementation of Bio::Ontology::RelationshipI. \n\nThe terminology we use here is the one commonly used for ontologies,\nnamely the triple of (subject, predicate, object), which in addition\nis scoped in a namespace (ontology). It is called triple because it is\na tuple of three ontology terms.\n\nThere are other terminologies in use for expressing relationships. For\nthose who it helps to better understand the concept, the triple of\n(child, relationship type, parent) would be equivalent to the\nterminology chosen here, disregarding the question whether the notion\nof parent and child is sensible in the context of the relationship\ntype or not. Especially in the case of ontologies with a wide variety\nof predicates the parent/child terminology and similar ones can\nquickly become ambiguous (e.g., A synthesises B), meaningless (e.g., A\nbinds B), or even conflicting (e.g., A is-parent-of B), and are\ntherefore strongly discouraged.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 CONTRIBUTORS\n\n Hilmar Lapp, email: hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::Relationship;\nuse strict;\nuse Bio::Ontology::TermI;\n\nuse base qw(Bio::Root::Root Bio::Ontology::RelationshipI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $rel = Bio::Ontology::Relationship->new(-identifier   => \"16847\",\n                                                   -subject_term => $subject,\n                                                   -object_term  => $object,\n                                                   -predicate_term => $type );\n Function: Creates a new Bio::Ontology::Relationship.\n Returns : A new Bio::Ontology::Relationship object.\n Args    : -identifier     => the identifier of this relationship [scalar]\n           -subject_term   => the subject term [Bio::Ontology::TermI]\n           -object_term    => the object term [Bio::Ontology::TermI]  \n           -predicate_term => the predicate term [Bio::Ontology::TermI]\n\n\nsub new {\n\n    my( $class, @args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n   \n    my ( $identifier,\n         $subject_term,\n\t\t\t$child,        # for backwards compatibility\n         $object_term,\n\t\t\t$parent,       # for backwards compatibility\n         $predicate_term,\n\t\t\t$reltype,      # for backwards compatibility\n\t\t\t$ont)\n\t= $self->_rearrange( [qw( IDENTIFIER\n\t\t\t\t  SUBJECT_TERM\n\t\t\t\t  CHILD_TERM\n\t\t\t\t  OBJECT_TERM\n\t\t\t\t  PARENT_TERM\n\t\t\t\t  PREDICATE_TERM\n\t\t\t\t  RELATIONSHIP_TYPE\n\t\t\t\t  ONTOLOGY)\n\t\t\t      ], @args );\n   \n    $self->init(); \n    \n    $self->identifier( $identifier );\n    $subject_term = $child unless $subject_term;\n    $object_term = $parent unless $object_term;\n    $predicate_term = $reltype unless $predicate_term;\n    $self->subject_term( $subject_term) if $subject_term;\n    $self->object_term( $object_term) if $object_term;\n    $self->predicate_term( $predicate_term ) if $predicate_term;\n    $self->ontology($ont) if $ont;\n                                                    \n    return $self;\n    \n} # new\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $rel->init();   \n Function: Initializes this Relationship to all undef.\n Returns : \n Args    :\n\n\nsub init {\n    my( $self ) = @_;\n    \n    $self->{ \"_identifier\" }     = undef;\n    $self->{ \"_subject_term\" }   = undef;\n    $self->{ \"_object_term\" }    = undef;\n    $self->{ \"_predicate_term\" } = undef;\n    $self->ontology(undef);\n   \n} # init\n\n\n\n=head2 identifier\n\n Title   : identifier\n Usage   : $rel->identifier( \"100050\" );\n           or\n           print $rel->identifier();\n Function: Set/get for the identifier of this Relationship.\n Returns : The identifier [scalar].\n Args    : The identifier [scalar] (optional).\n\n\nsub identifier {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_identifier\" } = $value;\n    }\n\n    return $self->{ \"_identifier\" };\n} # identifier\n\n\n\n\n=head2 subject_term\n\n Title   : subject_term\n Usage   : $rel->subject_term( $subject );\n           or\n           $subject = $rel->subject_term();\n Function: Set/get for the subject term of this Relationship.\n\n           The common convention for ontologies is to express\n           relationships between terms as triples (subject, predicate,\n           object).\n\n Returns : The subject term [Bio::Ontology::TermI].\n Args    : The subject term [Bio::Ontology::TermI] (optional).\n\n\nsub subject_term {\n    my ( $self, $term ) = @_;\n  \n    if ( defined $term ) {\n        $self->_check_class( $term, \"Bio::Ontology::TermI\" );\n        $self->{ \"_subject_term\" } = $term;\n    }\n\n    return $self->{ \"_subject_term\" };\n    \n} # subject_term\n\n\n\n=head2 object_term\n\n Title   : object_term\n Usage   : $rel->object_term( $object );\n           or\n           $object = $rel->object_term();\n Function: Set/get for the object term of this Relationship.\n\n           The common convention for ontologies is to express\n           relationships between terms as triples (subject, predicate,\n           object).\n\n Returns : The object term [Bio::Ontology::TermI].\n Args    : The object term [Bio::Ontology::TermI] (optional).\n\n\nsub object_term {\n    my ( $self, $term ) = @_;\n  \n    if ( defined $term ) {\n        $self->_check_class( $term, \"Bio::Ontology::TermI\" );\n        $self->{ \"_object_term\" } = $term;\n    }\n\n    return $self->{ \"_object_term\" };\n}\n\n\n\n=head2 predicate_term\n\n Title   : predicate_term\n Usage   : $rel->predicate_term( $type );\n           or\n           $type = $rel->predicate_term();\n Function: Set/get for the predicate (relationship type) of this\n           relationship.\n\n           The common convention for ontologies is to express\n           relationships between terms as triples (subject, predicate,\n           object).\n\n Returns : The predicate term [Bio::Ontology::TermI].\n Args    : The predicate term [Bio::Ontology::TermI] (optional).","parameters":[{"label":"$self"},{"label":"$term"}],"label":"predicate_term($self,$term)"},"containerName":"main::","name":"predicate_term","children":[{"line":308,"localvar":"my","containerName":"predicate_term","kind":13,"name":"$self","definition":"my"},{"name":"$term","containerName":"predicate_term","kind":13,"line":308},{"name":"$term","containerName":"predicate_term","kind":13,"line":310},{"line":311,"kind":13,"containerName":"predicate_term","name":"$self"},{"name":"_check_class","containerName":"predicate_term","kind":12,"line":311},{"line":311,"containerName":"predicate_term","kind":13,"name":"$term"},{"kind":13,"containerName":"predicate_term","name":"$self","line":312},{"containerName":"predicate_term","kind":13,"name":"$term","line":312},{"line":315,"name":"$self","containerName":"predicate_term","kind":13}],"detail":"($self,$term)","definition":"sub"},{"definition":"sub","children":[{"localvar":"my","kind":13,"containerName":"ontology","name":"$self","line":334,"definition":"my"},{"definition":"my","localvar":"my","kind":13,"containerName":"ontology","name":"$ont","line":335},{"line":338,"name":"$ont","kind":13,"containerName":"ontology"},{"line":339,"name":"$ont","containerName":"ontology","kind":13},{"line":340,"containerName":"ontology","kind":13,"name":"$ont"},{"line":340,"name":"new","kind":12,"containerName":"ontology"},{"line":340,"name":"$ont","containerName":"ontology","kind":13},{"containerName":"ontology","kind":13,"name":"$ont","line":340},{"line":341,"containerName":"ontology","kind":13,"name":"$ont"},{"line":341,"containerName":"ontology","kind":12,"name":"isa"},{"line":342,"name":"$self","kind":13,"containerName":"ontology"},{"containerName":"ontology","kind":12,"name":"throw","line":342},{"kind":13,"containerName":"ontology","name":"$ont","line":342},{"containerName":"ontology","kind":13,"name":"$self","line":346},{"line":346,"name":"$ont","kind":13,"containerName":"ontology"},{"line":348,"containerName":"ontology","kind":13,"name":"$self"}],"containerName":"main::","name":"ontology","line":333,"range":{"start":{"character":0,"line":333},"end":{"line":349,"character":9999}},"kind":12},{"line":340,"name":"Bio","containerName":"Ontology::Ontology","kind":12},{"detail":"($self)","definition":"sub","containerName":"main::","name":"to_string","children":[{"localvar":"my","kind":13,"containerName":"to_string","name":"$self","line":362,"definition":"my"},{"definition":"my","localvar":"my","containerName":"to_string","kind":13,"name":"$s","line":366},{"name":"$s","kind":13,"containerName":"to_string","line":368},{"name":"$s","kind":13,"containerName":"to_string","line":369},{"name":"$self","kind":13,"containerName":"to_string","line":369},{"line":369,"containerName":"to_string","kind":12,"name":"identifier"},{"kind":13,"containerName":"to_string","name":"$s","line":370},{"name":"$s","kind":13,"containerName":"to_string","line":371},{"line":371,"containerName":"to_string","kind":13,"name":"$self"},{"name":"subject_term","containerName":"to_string","kind":12,"line":371},{"line":371,"name":"identifier","kind":12,"containerName":"to_string"},{"name":"$s","kind":13,"containerName":"to_string","line":372},{"line":373,"name":"$s","kind":13,"containerName":"to_string"},{"line":373,"kind":13,"containerName":"to_string","name":"$self"},{"line":373,"name":"object_term","kind":12,"containerName":"to_string"},{"name":"identifier","containerName":"to_string","kind":12,"line":373},{"containerName":"to_string","kind":13,"name":"$s","line":374},{"line":375,"containerName":"to_string","kind":13,"name":"$s"},{"containerName":"to_string","kind":13,"name":"$self","line":375},{"containerName":"to_string","kind":12,"name":"predicate_term","line":375},{"name":"identifier","kind":12,"containerName":"to_string","line":375},{"line":377,"name":"$s","kind":13,"containerName":"to_string"}],"signature":{"label":"to_string($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Relationship.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Relationship\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::Relationship - a relationship for an ontology\n\n=head1 SYNOPSIS\n\n  $rel = Bio::Ontology::Relationship->new( -identifier     => \"16847\",\n                                           -subject_term   => $subj,\n                                           -object_term    => $obj,\n                                           -predicate_term => $pred );\n\n=head1 DESCRIPTION\n\nThis is a basic implementation of Bio::Ontology::RelationshipI. \n\nThe terminology we use here is the one commonly used for ontologies,\nnamely the triple of (subject, predicate, object), which in addition\nis scoped in a namespace (ontology). It is called triple because it is\na tuple of three ontology terms.\n\nThere are other terminologies in use for expressing relationships. For\nthose who it helps to better understand the concept, the triple of\n(child, relationship type, parent) would be equivalent to the\nterminology chosen here, disregarding the question whether the notion\nof parent and child is sensible in the context of the relationship\ntype or not. Especially in the case of ontologies with a wide variety\nof predicates the parent/child terminology and similar ones can\nquickly become ambiguous (e.g., A synthesises B), meaningless (e.g., A\nbinds B), or even conflicting (e.g., A is-parent-of B), and are\ntherefore strongly discouraged.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 CONTRIBUTORS\n\n Hilmar Lapp, email: hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::Relationship;\nuse strict;\nuse Bio::Ontology::TermI;\n\nuse base qw(Bio::Root::Root Bio::Ontology::RelationshipI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $rel = Bio::Ontology::Relationship->new(-identifier   => \"16847\",\n                                                   -subject_term => $subject,\n                                                   -object_term  => $object,\n                                                   -predicate_term => $type );\n Function: Creates a new Bio::Ontology::Relationship.\n Returns : A new Bio::Ontology::Relationship object.\n Args    : -identifier     => the identifier of this relationship [scalar]\n           -subject_term   => the subject term [Bio::Ontology::TermI]\n           -object_term    => the object term [Bio::Ontology::TermI]  \n           -predicate_term => the predicate term [Bio::Ontology::TermI]\n\n\nsub new {\n\n    my( $class, @args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n   \n    my ( $identifier,\n         $subject_term,\n\t\t\t$child,        # for backwards compatibility\n         $object_term,\n\t\t\t$parent,       # for backwards compatibility\n         $predicate_term,\n\t\t\t$reltype,      # for backwards compatibility\n\t\t\t$ont)\n\t= $self->_rearrange( [qw( IDENTIFIER\n\t\t\t\t  SUBJECT_TERM\n\t\t\t\t  CHILD_TERM\n\t\t\t\t  OBJECT_TERM\n\t\t\t\t  PARENT_TERM\n\t\t\t\t  PREDICATE_TERM\n\t\t\t\t  RELATIONSHIP_TYPE\n\t\t\t\t  ONTOLOGY)\n\t\t\t      ], @args );\n   \n    $self->init(); \n    \n    $self->identifier( $identifier );\n    $subject_term = $child unless $subject_term;\n    $object_term = $parent unless $object_term;\n    $predicate_term = $reltype unless $predicate_term;\n    $self->subject_term( $subject_term) if $subject_term;\n    $self->object_term( $object_term) if $object_term;\n    $self->predicate_term( $predicate_term ) if $predicate_term;\n    $self->ontology($ont) if $ont;\n                                                    \n    return $self;\n    \n} # new\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $rel->init();   \n Function: Initializes this Relationship to all undef.\n Returns : \n Args    :\n\n\nsub init {\n    my( $self ) = @_;\n    \n    $self->{ \"_identifier\" }     = undef;\n    $self->{ \"_subject_term\" }   = undef;\n    $self->{ \"_object_term\" }    = undef;\n    $self->{ \"_predicate_term\" } = undef;\n    $self->ontology(undef);\n   \n} # init\n\n\n\n=head2 identifier\n\n Title   : identifier\n Usage   : $rel->identifier( \"100050\" );\n           or\n           print $rel->identifier();\n Function: Set/get for the identifier of this Relationship.\n Returns : The identifier [scalar].\n Args    : The identifier [scalar] (optional).\n\n\nsub identifier {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_identifier\" } = $value;\n    }\n\n    return $self->{ \"_identifier\" };\n} # identifier\n\n\n\n\n=head2 subject_term\n\n Title   : subject_term\n Usage   : $rel->subject_term( $subject );\n           or\n           $subject = $rel->subject_term();\n Function: Set/get for the subject term of this Relationship.\n\n           The common convention for ontologies is to express\n           relationships between terms as triples (subject, predicate,\n           object).\n\n Returns : The subject term [Bio::Ontology::TermI].\n Args    : The subject term [Bio::Ontology::TermI] (optional).\n\n\nsub subject_term {\n    my ( $self, $term ) = @_;\n  \n    if ( defined $term ) {\n        $self->_check_class( $term, \"Bio::Ontology::TermI\" );\n        $self->{ \"_subject_term\" } = $term;\n    }\n\n    return $self->{ \"_subject_term\" };\n    \n} # subject_term\n\n\n\n=head2 object_term\n\n Title   : object_term\n Usage   : $rel->object_term( $object );\n           or\n           $object = $rel->object_term();\n Function: Set/get for the object term of this Relationship.\n\n           The common convention for ontologies is to express\n           relationships between terms as triples (subject, predicate,\n           object).\n\n Returns : The object term [Bio::Ontology::TermI].\n Args    : The object term [Bio::Ontology::TermI] (optional).\n\n\nsub object_term {\n    my ( $self, $term ) = @_;\n  \n    if ( defined $term ) {\n        $self->_check_class( $term, \"Bio::Ontology::TermI\" );\n        $self->{ \"_object_term\" } = $term;\n    }\n\n    return $self->{ \"_object_term\" };\n}\n\n\n\n=head2 predicate_term\n\n Title   : predicate_term\n Usage   : $rel->predicate_term( $type );\n           or\n           $type = $rel->predicate_term();\n Function: Set/get for the predicate (relationship type) of this\n           relationship.\n\n           The common convention for ontologies is to express\n           relationships between terms as triples (subject, predicate,\n           object).\n\n Returns : The predicate term [Bio::Ontology::TermI].\n Args    : The predicate term [Bio::Ontology::TermI] (optional).\n\n\nsub predicate_term {\n    my ( $self, $term ) = @_;\n  \n    if ( defined $term ) {\n        $self->_check_class( $term, \"Bio::Ontology::TermI\" );\n        $self->{ \"_predicate_term\" } = $term;\n    }\n\n    return $self->{ \"_predicate_term\" };\n}\n\n\n=head2 ontology\n\n Title   : ontology\n Usage   : $ont = $obj->ontology()\n Function: Get/set the ontology that defined this relationship.\n Example : \n Returns : an object implementing L<Bio::Ontology::OntologyI>\n Args    : on set, undef or an object implementing \n           Bio::Ontology::OntologyI (optional)\n\nSee L<Bio::Ontology::OntologyI>.\n\n\nsub ontology{\n    my $self = shift;\n    my $ont;\n\n    if(@_) {\n\t$ont = shift;\n\tif($ont) {\n\t    $ont = Bio::Ontology::Ontology->new(-name => $ont) if ! ref($ont);\n\t    if(! $ont->isa(\"Bio::Ontology::OntologyI\")) {\n\t\t$self->throw(ref($ont).\" does not implement \".\n\t\t\t     \"Bio::Ontology::OntologyI. Bummer.\");\n\t    }\n\t} \n\treturn $self->{\"_ontology\"} = $ont;\n    } \n    return $self->{\"_ontology\"};\n}\n\n=head2 to_string\n\n Title   : to_string()\n Usage   : print $rel->to_string();\n Function: to_string method for Relationship.\n Returns : A string representation of this Relationship.\n Args    :"},"kind":12,"range":{"end":{"character":9999,"line":379},"start":{"character":0,"line":361}},"line":361},{"signature":{"label":"_check_class($self,$value,$expected_class)","parameters":[{"label":"$self"},{"label":"$value"},{"label":"$expected_class"}],"documentation":""},"kind":12,"range":{"end":{"character":9999,"line":396},"start":{"character":0,"line":383}},"line":383,"detail":"($self,$value,$expected_class)","definition":"sub","containerName":"main::","name":"_check_class","children":[{"definition":"my","name":"$self","containerName":"_check_class","localvar":"my","kind":13,"line":384},{"line":384,"name":"$value","containerName":"_check_class","kind":13},{"line":384,"containerName":"_check_class","kind":13,"name":"$expected_class"},{"line":386,"kind":13,"containerName":"_check_class","name":"$value"},{"line":387,"name":"$self","kind":13,"containerName":"_check_class"},{"containerName":"_check_class","kind":12,"name":"throw","line":387},{"line":389,"name":"$value","containerName":"_check_class","kind":13},{"containerName":"_check_class","kind":13,"name":"$self","line":390},{"containerName":"_check_class","kind":12,"name":"throw","line":390},{"line":392,"name":"$value","kind":13,"containerName":"_check_class"},{"containerName":"_check_class","kind":12,"name":"isa","line":392},{"containerName":"_check_class","kind":13,"name":"$expected_class","line":392},{"name":"$self","containerName":"_check_class","kind":13,"line":393},{"line":393,"name":"throw","kind":12,"containerName":"_check_class"},{"line":393,"kind":13,"containerName":"_check_class","name":"$value"}]}]}