{"vars":[{"line":90,"name":"base","kind":2,"containerName":""},{"containerName":"main::","name":"new","children":[{"line":110,"name":"$class","localvar":"my","containerName":"new","kind":13,"definition":"my"},{"line":110,"name":"@args","kind":13,"containerName":"new"},{"definition":"my","line":111,"name":"%args","localvar":"my","kind":13,"containerName":"new"},{"line":111,"name":"@args","kind":13,"containerName":"new"},{"line":112,"containerName":"new","kind":13,"name":"$args"},{"definition":"my","line":113,"localvar":"my","kind":13,"containerName":"new","name":"$end"},{"containerName":"new","kind":13,"name":"$args","line":113},{"name":"$args","containerName":"new","kind":13,"line":113},{"containerName":"new","kind":13,"name":"$args","line":114},{"kind":13,"containerName":"new","name":"$args","line":115},{"name":"@args","kind":13,"containerName":"new","line":116},{"kind":13,"containerName":"new","name":"%args","line":116},{"definition":"my","localvar":"my","kind":13,"containerName":"new","name":"$self","line":118},{"line":118,"containerName":"new","kind":13,"name":"$class"},{"line":118,"kind":13,"containerName":"new","name":"@args"},{"line":118,"name":"$end","containerName":"new","kind":13},{"name":"@args","kind":13,"containerName":"new","line":120},{"definition":"my","containerName":"new","localvar":"my","kind":13,"name":"$key","line":121},{"line":121,"name":"@args","containerName":"new","kind":13},{"line":122,"kind":13,"containerName":"new","name":"$args"},{"kind":13,"containerName":"new","name":"$key","line":122},{"line":122,"containerName":"new","kind":13,"name":"@args"},{"line":125,"name":"$args","kind":13,"containerName":"new"},{"line":125,"kind":13,"containerName":"new","name":"$args"},{"containerName":"new","kind":13,"name":"$args","line":126},{"line":129,"name":"$self","containerName":"new","kind":13},{"line":129,"kind":13,"containerName":"new","name":"$args"},{"containerName":"new","kind":13,"name":"$self","line":130},{"line":130,"containerName":"new","kind":12,"name":"seq"},{"line":130,"containerName":"new","kind":13,"name":"$args"},{"line":131,"kind":13,"containerName":"new","name":"$self"},{"name":"desc","containerName":"new","kind":12,"line":131},{"containerName":"new","kind":13,"name":"$args","line":131},{"line":132,"kind":13,"containerName":"new","name":"$self"},{"line":132,"name":"$args","containerName":"new","kind":13},{"line":133,"name":"$self","kind":13,"containerName":"new"},{"line":133,"name":"$args","containerName":"new","kind":13},{"kind":13,"containerName":"new","name":"$self","line":134},{"line":134,"kind":13,"containerName":"new","name":"$args"},{"line":135,"kind":13,"containerName":"new","name":"$self"},{"kind":13,"containerName":"new","name":"$args","line":135},{"line":136,"name":"$self","kind":13,"containerName":"new"}],"detail":"($class,@args)","definition":"sub","kind":12,"range":{"start":{"character":0,"line":109},"end":{"line":137,"character":9999}},"line":109,"signature":{"documentation":"1;\n# $Id: InstanceSite.pm 16123 2009-09-17 12:57:27Z cjfields $\n\n=head1 NAME\n\nBio::Matrix::PSM::InstanceSite - A PSM site occurance\n\n=head1 SYNOPSIS\n\n  use Bio::Matrix::PSM::InstanceSite;\n\n  #You can get an InstanceSite object either from a file:\n\n  my ($instances,$matrix)=$SomePSMFile->parse_next;\n\n  #or from memory\n\n  my %params=(seq=>'TATAAT',\n    id=>\"TATAbox1\", accession=>'ENSG00000122304', mid=>'TB1',\n    desc=>'TATA box, experimentally verified in PRM1 gene',\n    -relpos=>-35, -anchor=>'CHR7', -start=>35000921, -end=>35000926);\n\n  #Last 2 arguments are passed to create a Bio::LocatableSeq object\n  #Anchor shows the coordinates system for the Bio::LocatableSeq object\n\n=head1 DESCRIPTION\n\nAbstract interface to PSM site occurrence (PSM sequence\nmatch). InstanceSite objects may be used to describe a PSM (See\nL<Bio::Matrix::PSM::SiteMatrix>) sequence matches.  The usual\ncharacteristic of such a match is sequence coordinates, score,\nsequence and sequence (gene) identifier- accession number or other id.\n\nThis object inherits from Bio::LocatableSeq (which defines the real\nsequence) and might hold a SiteMatrix object, used to detect the CRE\n(cis-regulatory element), or created from this CRE.\n\nWhile the documentation states that the motif id and gene id\n(accession) combination should be unique, this is not entirely true-\nthere might be more than one occurrence of the same cis-regulatory\nelement in the upstream region of the same gene.  Therefore relpos\nwould be the third element to create a really unique combination.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head2 Description\n\nBio::Matrix::PSM::InstanceSiteI implementation\n\n=head1 AUTHOR - Stefan Kirov\n\nEmail skirov@utk.edu\n\n\n=head1 APPENDIX\n\n\n\n# Let the code begin...\npackage Bio::Matrix::PSM::InstanceSite;\nuse strict;\n\nuse base qw(Bio::LocatableSeq Bio::Matrix::PSM::InstanceSiteI);\n\n=head2 new\n\n Title   : new\n Usage   : my $isntance=Bio::Matrix::PSM::InstanceSite->new \n                         (-seq=>'TATAAT', -id=>\"TATAbox1\",\n                          -accession_number='ENSG00000122304', -mid=>'TB1',\n                          -desc=>'TATA box, experimentally verified in PRM1 gene',\n                          -relpos=>-35, -anchor=>'CHR7', -start=>35000921, -end=>35000926, strand=>1)\n Function: Creates an InstanceSite object from memory.\n Throws  :\n Example :\n Returns : Bio::Matrix::PSM::InstanceSite object\n Args    : hash","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"}},{"line":118,"name":"SUPER","kind":12,"containerName":"new"},{"kind":12,"name":"seq","line":125},{"line":125,"name":"seq","kind":12},{"line":126,"kind":12,"name":"seq"},{"kind":12,"name":"mid","line":129},{"line":129,"kind":12,"name":"mid"},{"line":130,"kind":12,"name":"seq"},{"line":131,"name":"desc","kind":12},{"line":132,"kind":12,"name":"score"},{"name":"score","kind":12,"line":132},{"line":133,"kind":12,"name":"relpos"},{"name":"relpos","kind":12,"line":133},{"kind":12,"name":"frame","line":134},{"kind":12,"name":"frame","line":134},{"name":"anchor","kind":12,"line":135},{"kind":12,"name":"anchor","line":135},{"line":153,"range":{"end":{"line":158,"character":9999},"start":{"line":153,"character":0}},"kind":12,"definition":"sub","children":[{"definition":"my","line":154,"localvar":"my","kind":13,"containerName":"mid","name":"$self"},{"definition":"my","line":155,"name":"$prev","localvar":"my","kind":13,"containerName":"mid"},{"containerName":"mid","kind":13,"name":"$self","line":155},{"containerName":"mid","kind":13,"name":"$self","line":156},{"line":157,"kind":13,"containerName":"mid","name":"$prev"}],"name":"mid","containerName":"main::"},{"name":"mid","kind":12,"line":155},{"line":156,"name":"mid","kind":12},{"kind":12,"range":{"start":{"line":173,"character":0},"end":{"line":178,"character":9999}},"line":173,"definition":"sub","containerName":"main::","name":"score","children":[{"line":174,"containerName":"score","localvar":"my","kind":13,"name":"$self","definition":"my"},{"definition":"my","name":"$prev","containerName":"score","localvar":"my","kind":13,"line":175},{"line":175,"name":"$self","kind":13,"containerName":"score"},{"name":"$self","kind":13,"containerName":"score","line":176},{"name":"$prev","containerName":"score","kind":13,"line":177}]},{"line":175,"name":"score","kind":12},{"line":176,"kind":12,"name":"score"},{"line":192,"range":{"start":{"line":192,"character":0},"end":{"line":197,"character":9999}},"kind":12,"children":[{"localvar":"my","containerName":"anchor","kind":13,"name":"$self","line":193,"definition":"my"},{"kind":13,"localvar":"my","containerName":"anchor","name":"$prev","line":194,"definition":"my"},{"kind":13,"containerName":"anchor","name":"$self","line":194},{"line":195,"kind":13,"containerName":"anchor","name":"$self"},{"line":196,"containerName":"anchor","kind":13,"name":"$prev"}],"name":"anchor","containerName":"main::","definition":"sub"},{"kind":12,"name":"anchor","line":194},{"kind":12,"name":"anchor","line":195},{"children":[{"line":228,"name":"$self","containerName":"minstance","localvar":"my","kind":13,"definition":"my"},{"line":229,"name":"$prev","localvar":"my","kind":13,"containerName":"minstance","definition":"my"},{"line":229,"containerName":"minstance","kind":13,"name":"$self"},{"line":230,"name":"$self","containerName":"minstance","kind":13},{"line":231,"kind":13,"containerName":"minstance","name":"$prev"}],"containerName":"main::","name":"minstance","definition":"sub","line":227,"range":{"end":{"line":232,"character":9999},"start":{"character":0,"line":227}},"kind":12},{"name":"minstance","kind":12,"line":229},{"kind":12,"name":"minstance","line":230},{"definition":"sub","name":"relpos","containerName":"main::","children":[{"line":248,"name":"$self","localvar":"my","containerName":"relpos","kind":13,"definition":"my"},{"name":"$prev","kind":13,"localvar":"my","containerName":"relpos","line":249,"definition":"my"},{"containerName":"relpos","kind":13,"name":"$self","line":249},{"name":"$self","kind":13,"containerName":"relpos","line":250},{"line":251,"containerName":"relpos","kind":13,"name":"$prev"}],"kind":12,"range":{"start":{"line":247,"character":0},"end":{"character":9999,"line":252}},"line":247},{"name":"relpos","kind":12,"line":249},{"line":250,"kind":12,"name":"relpos"},{"detail":"($obj,$value)","definition":"sub","name":"annotation","containerName":"main::","children":[{"line":268,"name":"$obj","kind":13,"localvar":"my","containerName":"annotation","definition":"my"},{"line":268,"kind":13,"containerName":"annotation","name":"$value"},{"line":269,"containerName":"annotation","kind":13,"name":"$value"},{"line":270,"kind":13,"containerName":"annotation","name":"$obj"},{"name":"throw","containerName":"annotation","kind":12,"line":270},{"kind":13,"containerName":"annotation","name":"$value","line":270},{"line":272,"name":"$value","containerName":"annotation","kind":13},{"line":272,"kind":12,"containerName":"annotation","name":"isa"},{"containerName":"annotation","kind":13,"name":"$obj","line":273},{"kind":13,"containerName":"annotation","name":"$value","line":273},{"name":"$obj","kind":13,"containerName":"annotation","line":274},{"name":"$obj","containerName":"annotation","kind":13,"line":275},{"line":275,"name":"new","kind":12,"containerName":"annotation"},{"line":277,"containerName":"annotation","kind":13,"name":"$obj"}],"signature":{"documentation":"1;\n# $Id: InstanceSite.pm 16123 2009-09-17 12:57:27Z cjfields $\n\n=head1 NAME\n\nBio::Matrix::PSM::InstanceSite - A PSM site occurance\n\n=head1 SYNOPSIS\n\n  use Bio::Matrix::PSM::InstanceSite;\n\n  #You can get an InstanceSite object either from a file:\n\n  my ($instances,$matrix)=$SomePSMFile->parse_next;\n\n  #or from memory\n\n  my %params=(seq=>'TATAAT',\n    id=>\"TATAbox1\", accession=>'ENSG00000122304', mid=>'TB1',\n    desc=>'TATA box, experimentally verified in PRM1 gene',\n    -relpos=>-35, -anchor=>'CHR7', -start=>35000921, -end=>35000926);\n\n  #Last 2 arguments are passed to create a Bio::LocatableSeq object\n  #Anchor shows the coordinates system for the Bio::LocatableSeq object\n\n=head1 DESCRIPTION\n\nAbstract interface to PSM site occurrence (PSM sequence\nmatch). InstanceSite objects may be used to describe a PSM (See\nL<Bio::Matrix::PSM::SiteMatrix>) sequence matches.  The usual\ncharacteristic of such a match is sequence coordinates, score,\nsequence and sequence (gene) identifier- accession number or other id.\n\nThis object inherits from Bio::LocatableSeq (which defines the real\nsequence) and might hold a SiteMatrix object, used to detect the CRE\n(cis-regulatory element), or created from this CRE.\n\nWhile the documentation states that the motif id and gene id\n(accession) combination should be unique, this is not entirely true-\nthere might be more than one occurrence of the same cis-regulatory\nelement in the upstream region of the same gene.  Therefore relpos\nwould be the third element to create a really unique combination.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head2 Description\n\nBio::Matrix::PSM::InstanceSiteI implementation\n\n=head1 AUTHOR - Stefan Kirov\n\nEmail skirov@utk.edu\n\n\n=head1 APPENDIX\n\n\n\n# Let the code begin...\npackage Bio::Matrix::PSM::InstanceSite;\nuse strict;\n\nuse base qw(Bio::LocatableSeq Bio::Matrix::PSM::InstanceSiteI);\n\n=head2 new\n\n Title   : new\n Usage   : my $isntance=Bio::Matrix::PSM::InstanceSite->new \n                         (-seq=>'TATAAT', -id=>\"TATAbox1\",\n                          -accession_number='ENSG00000122304', -mid=>'TB1',\n                          -desc=>'TATA box, experimentally verified in PRM1 gene',\n                          -relpos=>-35, -anchor=>'CHR7', -start=>35000921, -end=>35000926, strand=>1)\n Function: Creates an InstanceSite object from memory.\n Throws  :\n Example :\n Returns : Bio::Matrix::PSM::InstanceSite object\n Args    : hash\n\n\n\nsub new {\n    my ($class, @args) = @_;\n    my %args = @args; #Too many things to rearrange, and I am creating >1K such objects routinely, so this is a performance issue    \n    $args{'-start'} ||= 1;\n    my $end = $args{'-start'} + length($args{-seq}) -1;\n    if (!defined($args{-strand})) {\n\t$args{-strand}=1;\n\t@args=%args;\n    }\n    my $self = $class->SUPER::new(@args,'-end',$end);\n    \n    while( @args ) {\n\t(my $key = shift @args) =~ s/-//gi; #deletes all dashes (only dashes)!\n\t$args{$key} = shift @args;\n    }\n#should throw exception if seq is null, for now just warn\n    if (($args{seq} eq '') || (!defined($args{seq}))) {\n\t$args{seq}=\"AGCT\";\n\twarn \"No sequence?!\\n\";\n    }\n    $self->{mid}=$args{mid};\n    $self->seq($args{seq});\n    $self->desc($args{desc});\n    $self->{score}=$args{score};\n    $self->{relpos}=$args{relpos};\n    $self->{frame}=$args{frame};\n    $self->{anchor}=$args{anchor};\n    return $self;\n}\n\n\n=head2 mid\n\n Title   : mid\n Usage   : my $mid=$instance->mid;\n Function: Get/Set the motif id\n Throws  :\n Example :\n Returns : scalar\n Args    : scalar\n\n\n\nsub mid {\n    my $self = shift;\n    my $prev = $self->{mid};\n    if (@_) { $self->{mid} = shift; }\n    return $prev;\n}\n\n=head2 score\n\n Title   : score\n Usage   : my $score=$instance->score;\n Function: Get/Set the score (mismatches) between the instance and the attached (or\n            initial) PSM\n Throws  :\n Example :\n Returns : real number\n Args    : real number\n\n\nsub score {\n    my $self = shift;\n    my $prev = $self->{score};\n    if (@_) { $self->{score} = shift; }\n    return $prev;\n}\n\n=head2 anchor\n\n Title   : anchor\n Usage   : my $anchor=$instance->anchor;\n Function: Get/Set the anchor which shows what coordinate system start/end use\n Throws  :\n Example :\n Returns : string\n Args    : string\n\n\nsub anchor {\n    my $self = shift;\n    my $prev = $self->{anchor};\n    if (@_) { $self->{anchor} = shift; }\n    return $prev;\n}\n\n=head2 start\n\n Title   : start\n Usage   : my $start=$instance->start;\n Function: Get/Set the position of the instance on the sequence used\n Throws  :\n Example :\n Returns : integer\n Args    : integer\n\n\n\n#Provided by LocatableSeq\n\n=head2 minstance\n\n Title   : minstance\n Usage   : my $minstance=$misntance->score;\n Function: Get/Set the unique identifier- sequence id/motif id, for example PRM1_TATAbox.\n          Not necessarily human readable.\n Throws  :\n Example :\n Returns : string\n Args    : string\n\n\nsub minstance {\n    my $self = shift;\n    my $prev = $self->{minstance};\n    if (@_) { $self->{minstance} = shift; }\n    return $prev;\n}\n\n=head2 relpos\n\n Title   : relpos\n Usage   : my $seqpos=$instance->relpos;\n Function: Get/Set the relative position of the instance with respect to the transcription start\n            site (if known). Can and usually is negative.\n Throws  :\n Example :\n Returns : integer\n Args    : integer\n\n\nsub relpos {\n    my $self = shift;\n    my $prev = $self->{relpos};\n    if (@_) { $self->{relpos} = shift; }\n    return $prev;\n}\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $ann = $seq->annotation or $seq->annotation($annotation)\n Function: Gets or sets the annotation\n Returns : L<Bio::AnnotationCollectionI> object\n Args    : None or L<Bio::AnnotationCollectionI> object\n\nSee L<Bio::AnnotationCollectionI> and L<Bio::Annotation::Collection>\nfor more information","parameters":[{"label":"$obj"},{"label":"$value"}],"label":"annotation($obj,$value)"},"range":{"start":{"character":0,"line":267},"end":{"character":9999,"line":278}},"kind":12,"line":267},{"kind":12,"containerName":"Annotation::Collection","name":"Bio","line":275},{"range":{"start":{"line":292,"character":0},"end":{"line":299,"character":9999}},"kind":12,"line":292,"signature":{"label":"species($self,$species)","parameters":[{"label":"$self"},{"label":"$species"}],"documentation":"1;\n# $Id: InstanceSite.pm 16123 2009-09-17 12:57:27Z cjfields $\n\n=head1 NAME\n\nBio::Matrix::PSM::InstanceSite - A PSM site occurance\n\n=head1 SYNOPSIS\n\n  use Bio::Matrix::PSM::InstanceSite;\n\n  #You can get an InstanceSite object either from a file:\n\n  my ($instances,$matrix)=$SomePSMFile->parse_next;\n\n  #or from memory\n\n  my %params=(seq=>'TATAAT',\n    id=>\"TATAbox1\", accession=>'ENSG00000122304', mid=>'TB1',\n    desc=>'TATA box, experimentally verified in PRM1 gene',\n    -relpos=>-35, -anchor=>'CHR7', -start=>35000921, -end=>35000926);\n\n  #Last 2 arguments are passed to create a Bio::LocatableSeq object\n  #Anchor shows the coordinates system for the Bio::LocatableSeq object\n\n=head1 DESCRIPTION\n\nAbstract interface to PSM site occurrence (PSM sequence\nmatch). InstanceSite objects may be used to describe a PSM (See\nL<Bio::Matrix::PSM::SiteMatrix>) sequence matches.  The usual\ncharacteristic of such a match is sequence coordinates, score,\nsequence and sequence (gene) identifier- accession number or other id.\n\nThis object inherits from Bio::LocatableSeq (which defines the real\nsequence) and might hold a SiteMatrix object, used to detect the CRE\n(cis-regulatory element), or created from this CRE.\n\nWhile the documentation states that the motif id and gene id\n(accession) combination should be unique, this is not entirely true-\nthere might be more than one occurrence of the same cis-regulatory\nelement in the upstream region of the same gene.  Therefore relpos\nwould be the third element to create a really unique combination.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head2 Description\n\nBio::Matrix::PSM::InstanceSiteI implementation\n\n=head1 AUTHOR - Stefan Kirov\n\nEmail skirov@utk.edu\n\n\n=head1 APPENDIX\n\n\n\n# Let the code begin...\npackage Bio::Matrix::PSM::InstanceSite;\nuse strict;\n\nuse base qw(Bio::LocatableSeq Bio::Matrix::PSM::InstanceSiteI);\n\n=head2 new\n\n Title   : new\n Usage   : my $isntance=Bio::Matrix::PSM::InstanceSite->new \n                         (-seq=>'TATAAT', -id=>\"TATAbox1\",\n                          -accession_number='ENSG00000122304', -mid=>'TB1',\n                          -desc=>'TATA box, experimentally verified in PRM1 gene',\n                          -relpos=>-35, -anchor=>'CHR7', -start=>35000921, -end=>35000926, strand=>1)\n Function: Creates an InstanceSite object from memory.\n Throws  :\n Example :\n Returns : Bio::Matrix::PSM::InstanceSite object\n Args    : hash\n\n\n\nsub new {\n    my ($class, @args) = @_;\n    my %args = @args; #Too many things to rearrange, and I am creating >1K such objects routinely, so this is a performance issue    \n    $args{'-start'} ||= 1;\n    my $end = $args{'-start'} + length($args{-seq}) -1;\n    if (!defined($args{-strand})) {\n\t$args{-strand}=1;\n\t@args=%args;\n    }\n    my $self = $class->SUPER::new(@args,'-end',$end);\n    \n    while( @args ) {\n\t(my $key = shift @args) =~ s/-//gi; #deletes all dashes (only dashes)!\n\t$args{$key} = shift @args;\n    }\n#should throw exception if seq is null, for now just warn\n    if (($args{seq} eq '') || (!defined($args{seq}))) {\n\t$args{seq}=\"AGCT\";\n\twarn \"No sequence?!\\n\";\n    }\n    $self->{mid}=$args{mid};\n    $self->seq($args{seq});\n    $self->desc($args{desc});\n    $self->{score}=$args{score};\n    $self->{relpos}=$args{relpos};\n    $self->{frame}=$args{frame};\n    $self->{anchor}=$args{anchor};\n    return $self;\n}\n\n\n=head2 mid\n\n Title   : mid\n Usage   : my $mid=$instance->mid;\n Function: Get/Set the motif id\n Throws  :\n Example :\n Returns : scalar\n Args    : scalar\n\n\n\nsub mid {\n    my $self = shift;\n    my $prev = $self->{mid};\n    if (@_) { $self->{mid} = shift; }\n    return $prev;\n}\n\n=head2 score\n\n Title   : score\n Usage   : my $score=$instance->score;\n Function: Get/Set the score (mismatches) between the instance and the attached (or\n            initial) PSM\n Throws  :\n Example :\n Returns : real number\n Args    : real number\n\n\nsub score {\n    my $self = shift;\n    my $prev = $self->{score};\n    if (@_) { $self->{score} = shift; }\n    return $prev;\n}\n\n=head2 anchor\n\n Title   : anchor\n Usage   : my $anchor=$instance->anchor;\n Function: Get/Set the anchor which shows what coordinate system start/end use\n Throws  :\n Example :\n Returns : string\n Args    : string\n\n\nsub anchor {\n    my $self = shift;\n    my $prev = $self->{anchor};\n    if (@_) { $self->{anchor} = shift; }\n    return $prev;\n}\n\n=head2 start\n\n Title   : start\n Usage   : my $start=$instance->start;\n Function: Get/Set the position of the instance on the sequence used\n Throws  :\n Example :\n Returns : integer\n Args    : integer\n\n\n\n#Provided by LocatableSeq\n\n=head2 minstance\n\n Title   : minstance\n Usage   : my $minstance=$misntance->score;\n Function: Get/Set the unique identifier- sequence id/motif id, for example PRM1_TATAbox.\n          Not necessarily human readable.\n Throws  :\n Example :\n Returns : string\n Args    : string\n\n\nsub minstance {\n    my $self = shift;\n    my $prev = $self->{minstance};\n    if (@_) { $self->{minstance} = shift; }\n    return $prev;\n}\n\n=head2 relpos\n\n Title   : relpos\n Usage   : my $seqpos=$instance->relpos;\n Function: Get/Set the relative position of the instance with respect to the transcription start\n            site (if known). Can and usually is negative.\n Throws  :\n Example :\n Returns : integer\n Args    : integer\n\n\nsub relpos {\n    my $self = shift;\n    my $prev = $self->{relpos};\n    if (@_) { $self->{relpos} = shift; }\n    return $prev;\n}\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $ann = $seq->annotation or $seq->annotation($annotation)\n Function: Gets or sets the annotation\n Returns : L<Bio::AnnotationCollectionI> object\n Args    : None or L<Bio::AnnotationCollectionI> object\n\nSee L<Bio::AnnotationCollectionI> and L<Bio::Annotation::Collection>\nfor more information\n\n\nsub annotation {\n    my ($obj,$value) = @_;\n    if( defined $value ) {\n\t$obj->throw(\"object of class \".ref($value).\" does not implement \".\n\t\t    \"Bio::AnnotationCollectionI. Too bad.\")\n\t    unless $value->isa(\"Bio::AnnotationCollectionI\");\n\t$obj->{'_annotation'} = $value;\n    } elsif( ! defined $obj->{'_annotation'}) {\n\t$obj->{'_annotation'} = Bio::Annotation::Collection->new();\n    }\n    return $obj->{'_annotation'};\n}\n\n=head2 species\n\n Title   : species\n Usage   : $species = $seq->species() or $seq->species($species)\n Function: Gets or sets the species\n Returns : L<Bio::Species> object\n Args    : None or L<Bio::Species> object\n\nSee L<Bio::Species> for more information"},"containerName":"main::","name":"species","children":[{"definition":"my","line":293,"kind":13,"localvar":"my","containerName":"species","name":"$self"},{"line":293,"name":"$species","kind":13,"containerName":"species"},{"line":294,"name":"$species","containerName":"species","kind":13},{"containerName":"species","kind":13,"name":"$self","line":295},{"line":295,"containerName":"species","kind":13,"name":"$species"},{"name":"$self","containerName":"species","kind":13,"line":297}],"detail":"($self,$species)","definition":"sub"},{"line":315,"kind":12,"range":{"end":{"character":9999,"line":320},"start":{"line":315,"character":0}},"children":[{"line":316,"localvar":"my","kind":13,"containerName":"frame","name":"$self","definition":"my"},{"kind":13,"localvar":"my","containerName":"frame","name":"$prev","line":317,"definition":"my"},{"name":"$self","kind":13,"containerName":"frame","line":317},{"name":"$self","containerName":"frame","kind":13,"line":318},{"name":"$self","kind":13,"containerName":"frame","line":318},{"line":318,"name":"throw","containerName":"frame","kind":12},{"line":319,"kind":13,"containerName":"frame","name":"$prev"}],"name":"frame","containerName":"main::","definition":"sub"},{"line":317,"name":"frame","kind":12},{"line":318,"kind":12,"name":"frame"}],"version":5}