{"vars":[{"line":63,"containerName":"","kind":2,"name":"base"},{"signature":{"label":"new($class,@args)","documentation":"#---------------------------------------------------------\n# $Id: transfac.pm 16123 2009-09-17 12:57:27Z cjfields $\n\n=head1 NAME\n\nBio::Matrix::PSM::IO::transfac - PSM transfac parser\n\n=head1 SYNOPSIS\n\nSee Bio::Matrix::PSM::IO for documentation\n\n=head1 DESCRIPTION\n\n#\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Stefan Kirov\n\nEmail skirov@utk.edu\n\n=head1 APPENDIX\n\n\n\n# Let the code begin...\npackage Bio::Matrix::PSM::IO::transfac;\nuse Bio::Matrix::PSM::Psm;\nuse Bio::Root::Root;\nuse Bio::Annotation::Reference;\nuse Bio::Annotation::Comment;\nuse Bio::Annotation::DBLink;\nuse strict;\n\nuse base qw(Bio::Matrix::PSM::PsmHeader Bio::Matrix::PSM::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $psmIO =  Bio::Matrix::PSM::IO->new(-format=>'transfac', \n\t\t\t\t\t\t -file=>$file);\n Function: Associates a file with the appropriate parser\n Throws  :\n Example :\n Args    :\n Returns : \"Bio::Matrix::PSM::$format\"->new(@args);","parameters":[{"label":"$class"},{"label":"@args"}]},"kind":12,"range":{"start":{"line":78,"character":0},"end":{"character":9999,"line":88}},"line":78,"detail":"($class,@args)","definition":"sub","containerName":"main::","name":"new","children":[{"name":"$class","localvar":"my","containerName":"new","kind":13,"line":79,"definition":"my"},{"name":"@args","containerName":"new","kind":13,"line":79},{"line":80,"kind":13,"localvar":"my","containerName":"new","name":"$line","definition":"my"},{"kind":13,"localvar":"my","containerName":"new","name":"$self","line":81,"definition":"my"},{"kind":13,"containerName":"new","name":"$class","line":81},{"line":81,"kind":13,"containerName":"new","name":"@args"},{"line":82,"name":"$file","localvar":"my","containerName":"new","kind":13,"definition":"my"},{"line":82,"name":"$self","containerName":"new","kind":13},{"name":"_rearrange","containerName":"new","kind":12,"line":82},{"name":"@args","kind":13,"containerName":"new","line":82},{"name":"$self","containerName":"new","kind":13,"line":83},{"line":83,"containerName":"new","kind":12,"name":"_initialize_io"},{"kind":13,"containerName":"new","name":"@args","line":83},{"line":86,"containerName":"new","kind":13,"name":"$line"},{"name":"$self","kind":13,"containerName":"new","line":86},{"containerName":"new","kind":12,"name":"_readline","line":86},{"line":87,"kind":13,"containerName":"new","name":"$line"},{"name":"$self","kind":13,"containerName":"new","line":88},{"name":"$line","containerName":"new","kind":13,"line":88},{"line":88,"name":"$line","containerName":"new","kind":13}]},{"line":81,"name":"SUPER","kind":12,"containerName":"new"},{"name":"unstructured","kind":12,"line":88},{"line":88,"kind":13,"containerName":null,"name":"$line"},{"line":88,"name":"$line","kind":13,"containerName":null},{"name":"$self","containerName":null,"kind":13,"line":89},{"line":89,"name":"_initialize","kind":12,"containerName":"main::"},{"line":90,"kind":13,"containerName":null,"name":"$self"},{"line":106,"kind":12,"range":{"end":{"character":9999,"line":147},"start":{"line":106,"character":0}},"definition":"sub","children":[{"definition":"my","line":107,"kind":13,"localvar":"my","containerName":"next_psm","name":"$self"},{"kind":13,"localvar":"my","containerName":"next_psm","name":"$line","line":108,"definition":"my"},{"line":109,"name":"$self","kind":13,"containerName":"next_psm"},{"definition":"my","containerName":"next_psm","localvar":"my","kind":13,"name":"@a","line":110},{"line":110,"containerName":"next_psm","kind":13,"name":"@c"},{"name":"@g","containerName":"next_psm","kind":13,"line":110},{"name":"@t","kind":13,"containerName":"next_psm","line":110},{"line":110,"name":"$id","kind":13,"containerName":"next_psm"},{"name":"$tr1","kind":13,"containerName":"next_psm","line":110},{"line":110,"name":"@refs","kind":13,"containerName":"next_psm"},{"line":110,"containerName":"next_psm","kind":13,"name":"$accn"},{"line":110,"kind":13,"containerName":"next_psm","name":"$bf"},{"name":"$sites","containerName":"next_psm","kind":13,"line":110},{"definition":"my","localvar":"my","kind":13,"containerName":"next_psm","name":"$i","line":111},{"line":112,"containerName":"next_psm","kind":13,"name":"$line"},{"name":"$self","containerName":"next_psm","kind":13,"line":112},{"line":112,"kind":12,"containerName":"next_psm","name":"_readline"},{"line":113,"kind":13,"containerName":"next_psm","name":"$line"},{"line":114,"containerName":"next_psm","kind":13,"name":"$line"},{"line":115,"name":"$a","containerName":"next_psm","kind":13},{"line":115,"name":"$i","kind":13,"containerName":"next_psm"},{"line":115,"kind":13,"containerName":"next_psm","name":"$c"},{"name":"$i","kind":13,"containerName":"next_psm","line":115},{"kind":13,"containerName":"next_psm","name":"$g","line":115},{"line":115,"name":"$i","kind":13,"containerName":"next_psm"},{"line":115,"name":"$t","kind":13,"containerName":"next_psm"},{"name":"$i","kind":13,"containerName":"next_psm","line":115},{"line":115,"name":"$line","kind":13,"containerName":"next_psm"},{"name":"$i","kind":13,"containerName":"next_psm","line":116},{"line":118,"containerName":"next_psm","kind":13,"name":"$tr1"},{"line":118,"kind":13,"containerName":"next_psm","name":"$accn"},{"line":118,"kind":13,"containerName":"next_psm","name":"$line"},{"kind":13,"containerName":"next_psm","name":"$line","line":118},{"line":119,"kind":13,"containerName":"next_psm","name":"$tr1"},{"name":"$bf","kind":13,"containerName":"next_psm","line":119},{"line":119,"kind":13,"containerName":"next_psm","name":"$line"},{"kind":13,"containerName":"next_psm","name":"$line","line":119},{"line":120,"name":"$tr1","kind":13,"containerName":"next_psm"},{"containerName":"next_psm","kind":13,"name":"$id","line":120},{"name":"$line","containerName":"next_psm","kind":13,"line":120},{"containerName":"next_psm","kind":13,"name":"$line","line":120},{"name":"$line","containerName":"next_psm","kind":13,"line":121},{"line":121,"name":"$i","kind":13,"containerName":"next_psm"},{"line":123,"name":"$id","containerName":"next_psm","kind":13},{"name":"$accn","containerName":"next_psm","kind":13,"line":123},{"line":124,"kind":13,"containerName":"next_psm","name":"$self"},{"line":127,"containerName":"next_psm","kind":13,"name":"$line"},{"kind":13,"containerName":"next_psm","name":"$self","line":127},{"name":"_readline","containerName":"next_psm","kind":12,"line":127},{"line":128,"name":"$line","kind":13,"containerName":"next_psm"},{"definition":"my","line":129,"localvar":"my","kind":13,"containerName":"next_psm","name":"$tr1"},{"line":129,"containerName":"next_psm","kind":13,"name":"$ba"},{"line":129,"name":"$line","kind":13,"containerName":"next_psm"},{"line":130,"kind":13,"containerName":"next_psm","name":"$sites"},{"line":130,"name":"$ba","containerName":"next_psm","kind":13},{"line":132,"kind":13,"containerName":"next_psm","name":"$line"},{"definition":"my","line":135,"kind":13,"localvar":"my","containerName":"next_psm","name":"$ref"},{"name":"$self","kind":13,"containerName":"next_psm","line":135},{"line":136,"kind":13,"containerName":"next_psm","name":"@refs"},{"line":137,"kind":13,"containerName":"next_psm","name":"$ref"},{"name":"$line","kind":13,"containerName":"next_psm","line":138},{"kind":13,"localvar":"my","containerName":"next_psm","name":"%matrix","line":141,"definition":"my"},{"line":141,"containerName":"next_psm","kind":13,"name":"$self"},{"kind":13,"containerName":"next_psm","name":"@a","line":141},{"containerName":"next_psm","kind":13,"name":"@c","line":141},{"containerName":"next_psm","kind":13,"name":"@g","line":141},{"line":141,"name":"@t","kind":13,"containerName":"next_psm"},{"name":"$id","kind":13,"containerName":"next_psm","line":141},{"line":141,"name":"$accn","kind":13,"containerName":"next_psm"},{"kind":13,"containerName":"next_psm","name":"$matrix","line":142},{"containerName":"next_psm","kind":13,"name":"$sites","line":142},{"line":142,"kind":13,"containerName":"next_psm","name":"$sites"},{"name":"$matrix","containerName":"next_psm","kind":13,"line":143},{"line":143,"name":"@a","kind":13,"containerName":"next_psm"},{"localvar":"my","containerName":"next_psm","kind":13,"name":"$psm","line":144,"definition":"my"},{"name":"new","kind":12,"containerName":"next_psm","line":144},{"line":144,"kind":13,"containerName":"next_psm","name":"%matrix"},{"definition":"my","name":"$ref","localvar":"my","containerName":"next_psm","kind":13,"line":145},{"kind":13,"containerName":"next_psm","name":"@refs","line":145},{"line":145,"kind":13,"containerName":"next_psm","name":"$psm"},{"kind":12,"containerName":"next_psm","name":"add_Annotation","line":145},{"line":145,"name":"$ref","kind":13,"containerName":"next_psm"},{"line":146,"kind":13,"containerName":"next_psm","name":"$psm"}],"name":"next_psm","containerName":"main::"},{"kind":12,"name":"end","line":109},{"name":"_parse_matrix","kind":12,"line":115},{"name":"end","kind":12,"line":124},{"name":"_parse_ref","kind":12,"line":135},{"line":141,"name":"_make_matrix","kind":12},{"line":144,"name":"Bio","containerName":"Matrix::PSM::Psm","kind":12},{"definition":"sub","children":[{"line":162,"kind":13,"localvar":"my","containerName":"_parse_matrix","name":"$line","definition":"my"},{"line":163,"kind":13,"containerName":"_parse_matrix","name":"$line"},{"line":164,"name":"$tr","kind":13,"localvar":"my","containerName":"_parse_matrix","definition":"my"},{"line":164,"name":"$a","kind":13,"containerName":"_parse_matrix"},{"line":164,"kind":13,"containerName":"_parse_matrix","name":"$c"},{"line":164,"kind":13,"containerName":"_parse_matrix","name":"$g"},{"containerName":"_parse_matrix","kind":13,"name":"$t","line":164},{"line":164,"containerName":"_parse_matrix","kind":13,"name":"$line"},{"line":165,"name":"$a","containerName":"_parse_matrix","kind":13},{"line":165,"containerName":"_parse_matrix","kind":13,"name":"$c"},{"kind":13,"containerName":"_parse_matrix","name":"$g","line":165},{"line":165,"name":"$t","containerName":"_parse_matrix","kind":13}],"containerName":"main::","name":"_parse_matrix","line":161,"kind":12,"range":{"end":{"character":9999,"line":166},"start":{"character":0,"line":161}}},{"detail":"($self,$cA,$cC,$cG,$cT,$id,$accn)","definition":"sub","containerName":"main::","name":"_make_matrix","children":[{"definition":"my","name":"$a","kind":13,"localvar":"my","containerName":"_make_matrix","line":183},{"name":"$c","containerName":"_make_matrix","kind":13,"line":183},{"name":"$g","containerName":"_make_matrix","kind":13,"line":183},{"line":183,"name":"$t","kind":13,"containerName":"_make_matrix"},{"kind":13,"containerName":"_make_matrix","name":"@fa","line":183},{"kind":13,"containerName":"_make_matrix","name":"@fc","line":183},{"containerName":"_make_matrix","kind":13,"name":"@fg","line":183},{"line":183,"name":"@ft","containerName":"_make_matrix","kind":13},{"name":"@a","containerName":"_make_matrix","kind":13,"line":183},{"kind":13,"containerName":"_make_matrix","name":"@c","line":183},{"name":"@g","containerName":"_make_matrix","kind":13,"line":183},{"name":"@t","containerName":"_make_matrix","kind":13,"line":183},{"definition":"my","name":"$ave","localvar":"my","kind":13,"containerName":"_make_matrix","line":184},{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"_make_matrix","line":185},{"line":185,"kind":13,"containerName":"_make_matrix","name":"$cA"},{"line":185,"containerName":"_make_matrix","kind":13,"name":"$cC"},{"kind":13,"containerName":"_make_matrix","name":"$cG","line":185},{"containerName":"_make_matrix","kind":13,"name":"$cT","line":185},{"kind":13,"containerName":"_make_matrix","name":"$id","line":185},{"line":185,"kind":13,"containerName":"_make_matrix","name":"$accn"},{"line":187,"containerName":"_make_matrix","localvar":"my","kind":13,"name":"$i","definition":"my"},{"name":"$i","containerName":"_make_matrix","kind":13,"line":187},{"containerName":"_make_matrix","kind":13,"name":"$cA","line":187}],"signature":{"parameters":[{"label":"$self"},{"label":"$cA"},{"label":"$cC"},{"label":"$cG"},{"label":"$cT"},{"label":"$id"},{"label":"$accn"}],"documentation":"#---------------------------------------------------------\n# $Id: transfac.pm 16123 2009-09-17 12:57:27Z cjfields $\n\n=head1 NAME\n\nBio::Matrix::PSM::IO::transfac - PSM transfac parser\n\n=head1 SYNOPSIS\n\nSee Bio::Matrix::PSM::IO for documentation\n\n=head1 DESCRIPTION\n\n#\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Stefan Kirov\n\nEmail skirov@utk.edu\n\n=head1 APPENDIX\n\n\n\n# Let the code begin...\npackage Bio::Matrix::PSM::IO::transfac;\nuse Bio::Matrix::PSM::Psm;\nuse Bio::Root::Root;\nuse Bio::Annotation::Reference;\nuse Bio::Annotation::Comment;\nuse Bio::Annotation::DBLink;\nuse strict;\n\nuse base qw(Bio::Matrix::PSM::PsmHeader Bio::Matrix::PSM::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $psmIO =  Bio::Matrix::PSM::IO->new(-format=>'transfac', \n\t\t\t\t\t\t -file=>$file);\n Function: Associates a file with the appropriate parser\n Throws  :\n Example :\n Args    :\n Returns : \"Bio::Matrix::PSM::$format\"->new(@args);\n\n\nsub new {\n    my ($class,@args)=@_;\n    my $line;\n    my $self = $class->SUPER::new(@args);\n    my ($file)=$self->_rearrange(['FILE'], @args);\n    $self->_initialize_io(@args) || warn \"Did you intend to use STDIN?\"; #Read only for now\n    #Remove header\n    do {\n\t$line=$self->_readline;\n\tchomp $line;\n\tpush @{$self->{unstructured}},$line if (length($line)>2); } until ($line =~ m{^//}) || (!defined($line)); #Unstructured header\n    $self->_initialize;\n    return $self;\n}\n\n\n=head2 next_psm\n\n Title   : next_psm\n Usage   : my $psm=$psmIO->next_psm();\n Function: Reads the next PSM from the input file, associated with this object\n Throws  : Upon finding a line, defining the matrix, where one or more positions\n            are not defined, see _make_matrix\n Returns : Bio::Matrix::PSM::Psm object\n Args    : none\n\n\nsub next_psm {\n    my $self=shift;\n    my $line;\n    return if ($self->{end});\n    my (@a,@c,@g,@t, $id, $tr1, @refs,$accn, $bf, $sites);\n    my $i=0;\n    while (defined( $line=$self->_readline)) {\n\tchomp($line);\n\tif ($line=~/^\\d{2}/) {\t#Begining of the frequency data\n\t    ($a[$i],$c[$i],$g[$i],$t[$i])=_parse_matrix($line);\n\t    $i++;\n\t}\n\t($tr1,$accn)=split(/\\s{2}/,$line) if ($line=~/^AC\\s/);\n\t($tr1,$bf)=split(/\\s{2}/,$line) if ($line=~/^BF\\s/);\n\t($tr1,$id)=split(/\\s{2}/,$line) if ($line=~/^ID\\s/);\n\tlast if (($line=~/^XX/) && ($i>0));\n    }\n    if (!(defined($id) && defined($accn))) {\n\t$self->{end}=1;\n\treturn;\n    }\n    while (defined( $line=$self->_readline)) {\t#How many sites?\n\tif ($line=~/^BA\\s/) {\n\t    my ($tr1,$ba)=split(/\\s{2}/,$line);\n\t    ($sites)=split(/\\s/,$ba);\n\t}\n   if ($line=~/^RN/) { #Adding a reference as Bio::Annotation object (self)\n    # not interested in RN line itself, since has only transfac-specific\n    # reference id? - no push back of line\n    my $ref=_parse_ref($self);\n    push @refs,$ref\n  }\n\tlast if ($line=~m{^//});\n    }\n    # We have the frequencies, let's create a SiteMatrix object\n    my %matrix = &_make_matrix($self,\\@a,\\@c,\\@g,\\@t,$id, $accn);\n    $matrix{-sites}=$sites if ($sites);\n    $matrix{-width}=@a;\n    my $psm=Bio::Matrix::PSM::Psm->new(%matrix);\n    foreach my $ref (@refs) { $psm->add_Annotation('reference',$ref); }\n    return $psm;\n}\n\n=head2 _parseMatrix\n\n Title   : _parseMatrix\n Usage   :\n Function: Parses a line\n Throws  :\n Example :  Internal stuff\n Returns :  array (frequencies for A,C,G,T in this order).\n Args    :  string\n\n\nsub _parse_matrix {\n    my $line=shift;\n    $line=~s/\\s+/,/g;\n    my ($tr,$a,$c,$g,$t)=split(/,/,$line);\n    return $a,$c,$g,$t;\n}\n\n\n=head2 _make_matrix\n\n Title   : _make_matrix\n Usage   :\n Function:\n Throws  :  If a position is undefined, for example if you have line like this\n            in the file you are parsing: 08  4,7,,9\n Example :  Internal stuff\n Returns :\n Args    :","label":"_make_matrix($self,$cA,$cC,$cG,$cT,$id,$accn)"},"range":{"end":{"line":187,"character":9999},"start":{"line":182,"character":0}},"kind":12,"line":182},{"name":"%i","containerName":null,"kind":13,"line":187},{"line":190,"name":"$self","containerName":null,"kind":13},{"name":"throw","containerName":"main::","kind":12,"line":190},{"line":190,"containerName":null,"kind":13,"name":"$i"},{"kind":13,"containerName":null,"name":"$cA","line":190},{"line":190,"kind":13,"containerName":null,"name":"$cG"},{"containerName":null,"kind":13,"name":"$cC","line":190},{"containerName":null,"kind":13,"name":"$cT","line":190},{"line":192,"containerName":null,"kind":13,"name":"@cA"},{"line":192,"kind":13,"containerName":null,"name":"$i"},{"line":192,"kind":13,"containerName":null,"name":"@cC"},{"containerName":null,"kind":13,"name":"$i","line":192},{"name":"@cG","containerName":null,"kind":13,"line":193},{"kind":13,"containerName":null,"name":"$i","line":193},{"name":"@cT","containerName":null,"kind":13,"line":193},{"kind":13,"containerName":null,"name":"%i","line":193},{"containerName":null,"kind":13,"name":"@a","line":194},{"line":194,"kind":13,"containerName":null,"name":"$ave"},{"name":"@c","containerName":null,"kind":13,"line":195},{"line":195,"name":"$ave","containerName":null,"kind":13},{"line":196,"kind":13,"containerName":null,"name":"@g"},{"name":"$ave","kind":13,"containerName":null,"line":196},{"name":"@t","kind":13,"containerName":null,"line":197},{"line":197,"name":"%ave","containerName":null,"kind":13},{"name":"@a","kind":13,"containerName":null,"line":200},{"line":200,"name":"@cA","containerName":null,"kind":13},{"line":200,"containerName":null,"kind":13,"name":"$i"},{"name":"@c","kind":13,"containerName":null,"line":201},{"line":201,"containerName":null,"kind":13,"name":"@cC"},{"line":201,"containerName":null,"kind":13,"name":"$i"},{"kind":13,"containerName":null,"name":"@g","line":202},{"line":202,"kind":13,"containerName":null,"name":"@cG"},{"kind":13,"containerName":null,"name":"$i","line":202},{"line":203,"name":"@t","kind":13,"containerName":null},{"line":203,"containerName":null,"kind":13,"name":"@cT"},{"line":203,"containerName":null,"kind":13,"name":"$i"},{"name":"$ave","containerName":null,"kind":13,"line":204},{"line":204,"name":"@cA","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"$i","line":204},{"line":204,"name":"@cC","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"$i","line":204},{"line":205,"name":"@cG","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"$i","line":205},{"line":205,"containerName":null,"kind":13,"name":"@cT"},{"kind":13,"containerName":null,"name":"$i","line":205},{"name":"$ave","kind":13,"containerName":null,"line":205},{"definition":"my","line":209,"containerName":null,"localvar":"my","kind":13,"name":"$i"},{"line":209,"name":"$i","containerName":null,"kind":13},{"line":209,"name":"@a","kind":13,"containerName":null},{"line":209,"name":"%i","containerName":null,"kind":13},{"name":"$zero","localvar":"my","containerName":null,"kind":13,"line":210,"definition":"my"},{"line":210,"name":"@a","containerName":null,"kind":13},{"line":210,"name":"$i","containerName":null,"kind":13},{"line":210,"name":"@c","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"$i","line":210},{"line":210,"name":"@g","containerName":null,"kind":13},{"name":"$i","containerName":null,"kind":13,"line":210},{"name":"@t","containerName":null,"kind":13,"line":210},{"containerName":null,"kind":13,"name":"$i","line":210},{"kind":13,"containerName":null,"name":"$zero","line":211},{"name":"@fa","containerName":null,"kind":13,"line":212},{"name":"@a","containerName":null,"kind":13,"line":212},{"containerName":null,"kind":13,"name":"$i","line":212},{"name":"@fc","containerName":null,"kind":13,"line":213},{"containerName":null,"kind":13,"name":"@c","line":213},{"containerName":null,"kind":13,"name":"$i","line":213},{"line":214,"name":"@fg","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"@g","line":214},{"line":214,"name":"$i","containerName":null,"kind":13},{"name":"@ft","containerName":null,"kind":13,"line":215},{"name":"@t","containerName":null,"kind":13,"line":215},{"line":215,"kind":13,"containerName":null,"name":"$i"},{"name":"@fa","kind":13,"containerName":null,"line":217},{"name":"@fc","containerName":null,"kind":13,"line":217},{"line":217,"containerName":null,"kind":13,"name":"@fg"},{"line":217,"name":"@ft","kind":13,"containerName":null},{"line":217,"containerName":null,"kind":13,"name":"$id"},{"name":"$accn","kind":13,"containerName":null,"line":217},{"definition":"sub","name":"_parse_ref","containerName":"main::","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"_parse_ref","kind":13,"line":221},{"definition":"my","line":222,"name":"$authors","kind":13,"localvar":"my","containerName":"_parse_ref"},{"kind":13,"containerName":"_parse_ref","name":"$title","line":222},{"containerName":"_parse_ref","kind":13,"name":"$loc","line":222},{"line":222,"name":"@refs","kind":13,"containerName":"_parse_ref"},{"line":222,"name":"$tr","containerName":"_parse_ref","kind":13},{"line":222,"containerName":"_parse_ref","kind":13,"name":"$db"},{"kind":13,"containerName":"_parse_ref","name":"$dbid","line":222},{"line":223,"name":"$refline","localvar":"my","containerName":"_parse_ref","kind":13,"definition":"my"},{"kind":13,"containerName":"_parse_ref","name":"$self","line":223},{"name":"_readline","kind":12,"containerName":"_parse_ref","line":223},{"name":"$refline","kind":13,"containerName":"_parse_ref","line":224},{"definition":"my","name":"$field","localvar":"my","kind":13,"containerName":"_parse_ref","line":225},{"containerName":"_parse_ref","kind":13,"name":"$arg","line":225},{"name":"$refline","containerName":"_parse_ref","kind":13,"line":225},{"containerName":"_parse_ref","kind":13,"name":"$field","line":226},{"containerName":"_parse_ref","kind":13,"name":"$field","line":227},{"name":"$field","kind":13,"containerName":"_parse_ref","line":229},{"line":230,"name":"$refline","containerName":"_parse_ref","kind":13},{"line":231,"kind":13,"containerName":"_parse_ref","name":"$tr"},{"line":231,"kind":13,"containerName":"_parse_ref","name":"$db"},{"line":231,"name":"$dbid","containerName":"_parse_ref","kind":13},{"line":231,"kind":13,"containerName":"_parse_ref","name":"$refline"},{"kind":13,"containerName":"_parse_ref","name":"$field","line":234},{"containerName":"_parse_ref","kind":13,"name":"$title","line":235},{"kind":13,"containerName":"_parse_ref","name":"$arg","line":235},{"line":238,"name":"$field","containerName":"_parse_ref","kind":13},{"kind":13,"containerName":"_parse_ref","name":"$authors","line":239},{"line":239,"name":"$arg","containerName":"_parse_ref","kind":13},{"line":242,"name":"$field","containerName":"_parse_ref","kind":13},{"line":243,"name":"$loc","containerName":"_parse_ref","kind":13},{"line":243,"name":"$arg","containerName":"_parse_ref","kind":13},{"name":"$reference","containerName":"_parse_ref","localvar":"my","kind":13,"line":248,"definition":"my"},{"line":248,"containerName":"_parse_ref","kind":12,"name":"new"},{"line":248,"name":"$authors","containerName":"_parse_ref","kind":13},{"line":248,"containerName":"_parse_ref","kind":13,"name":"$title"},{"line":249,"name":"$loc","containerName":"_parse_ref","kind":13},{"kind":13,"containerName":"_parse_ref","name":"$db","line":250},{"name":"$reference","containerName":"_parse_ref","kind":13,"line":252},{"containerName":"_parse_ref","kind":12,"name":"medline","line":252},{"containerName":"_parse_ref","kind":13,"name":"$dbid","line":252},{"line":254,"name":"$dbid","containerName":"_parse_ref","kind":13},{"name":"$reference","containerName":"_parse_ref","kind":13,"line":255},{"name":"pubmed","containerName":"_parse_ref","kind":12,"line":255},{"line":255,"name":"$dbid","kind":13,"containerName":"_parse_ref"},{"line":257,"name":"$reference","kind":13,"containerName":"_parse_ref"}],"kind":12,"range":{"end":{"character":9999,"line":258},"start":{"line":220,"character":0}},"line":220},{"kind":12,"name":"REF","line":228},{"line":232,"kind":12,"name":"REF"},{"kind":12,"name":"REF","line":236},{"kind":12,"name":"REF","line":240},{"line":244,"name":"REF","kind":12},{"line":248,"name":"Bio","containerName":"Annotation::Reference","kind":12},{"definition":"sub","containerName":"main::","name":"DESTROY","children":[{"definition":"my","localvar":"my","containerName":"DESTROY","kind":13,"name":"$self","line":261},{"line":262,"kind":13,"containerName":"DESTROY","name":"$self"},{"containerName":"DESTROY","kind":12,"name":"close","line":262}],"kind":12,"range":{"start":{"line":260,"character":0},"end":{"line":263,"character":9999}},"line":260}],"version":5}