{"version":5,"vars":[{"line":69,"name":"base","kind":2,"containerName":""},{"containerName":"main::","name":"new","children":[{"definition":"my","line":89,"localvar":"my","kind":13,"containerName":"new","name":"$class"},{"containerName":"new","kind":13,"name":"@args","line":89},{"localvar":"my","kind":13,"containerName":"new","name":"$self","line":90,"definition":"my"},{"line":90,"name":"$class","kind":13,"containerName":"new"},{"line":90,"name":"@args","containerName":"new","kind":13},{"definition":"my","kind":13,"localvar":"my","containerName":"new","name":"%instances","line":91},{"line":91,"name":"@header","containerName":"new","kind":13},{"kind":13,"containerName":"new","name":"$n","line":91},{"line":92,"name":"$file","localvar":"my","containerName":"new","kind":13,"definition":"my"},{"kind":13,"containerName":"new","name":"$self","line":92},{"containerName":"new","kind":12,"name":"_rearrange","line":92},{"line":92,"containerName":"new","kind":13,"name":"@args"},{"line":93,"name":"$self","kind":13,"containerName":"new"},{"line":93,"name":"$file","containerName":"new","kind":13},{"line":94,"name":"$self","kind":13,"containerName":"new"},{"name":"$self","kind":13,"containerName":"new","line":95},{"name":"_initialize_io","containerName":"new","kind":12,"line":95},{"line":95,"name":"@args","containerName":"new","kind":13},{"kind":13,"containerName":"new","name":"$self","line":96},{"containerName":"new","kind":13,"name":"$self","line":97},{"line":98,"name":"$self","kind":13,"containerName":"new"},{"containerName":"new","kind":13,"name":"$file","line":98},{"name":"$buf","containerName":"new","localvar":"my","kind":13,"line":99,"definition":"my"},{"line":99,"containerName":"new","kind":13,"name":"$self"},{"line":99,"containerName":"new","kind":12,"name":"_readline"},{"line":100,"name":"$self","kind":13,"containerName":"new"},{"name":"throw","kind":12,"containerName":"new","line":100},{"line":100,"name":"$buf","kind":13,"containerName":"new"},{"name":"$buf","containerName":"new","kind":13,"line":102},{"line":102,"name":"$self","containerName":"new","kind":13},{"line":102,"name":"_readline","containerName":"new","kind":12},{"line":103,"name":"$buf","containerName":"new","kind":13},{"line":104,"kind":13,"containerName":"new","name":"$buf"},{"line":105,"name":"$buf","containerName":"new","kind":13},{"line":105,"kind":13,"containerName":"new","name":"$self"},{"line":105,"name":"_readline","kind":12,"containerName":"new"},{"line":106,"containerName":"new","kind":13,"name":"$buf"},{"line":107,"name":"$buf","kind":13,"containerName":"new"},{"name":"$buf","containerName":"new","kind":13,"line":108},{"name":"$n","containerName":"new","kind":13,"line":109},{"line":109,"kind":13,"containerName":"new","name":"$self"},{"line":109,"name":"$self","kind":13,"containerName":"new"},{"name":"$buf","containerName":"new","kind":13,"line":109},{"line":110,"kind":13,"containerName":"new","name":"$self"},{"line":112,"name":"$buf","kind":13,"containerName":"new"},{"name":"$buf","kind":13,"containerName":"new","line":113},{"containerName":"new","kind":13,"name":"$buf","line":114},{"line":115,"containerName":"new","kind":13,"name":"$n"},{"name":"$self","kind":13,"containerName":"new","line":115},{"line":115,"kind":13,"containerName":"new","name":"$self"},{"line":115,"name":"$buf","kind":13,"containerName":"new"},{"line":116,"containerName":"new","kind":13,"name":"$self"},{"line":120,"name":"$self","containerName":"new","kind":13},{"name":"$self","containerName":"new","kind":13,"line":120},{"name":"$self","containerName":"new","kind":13,"line":121},{"name":"$self","kind":13,"containerName":"new","line":122},{"name":"$buf","containerName":"new","kind":13,"line":125},{"line":126,"name":"$self","kind":13,"containerName":"new"},{"containerName":"new","kind":12,"name":"_readline","line":126},{"line":127,"name":"$buf","containerName":"new","kind":13},{"kind":13,"containerName":"new","name":"$self","line":127},{"name":"_readline","kind":12,"containerName":"new","line":127},{"name":"$buf","containerName":"new","kind":13,"line":128},{"kind":13,"containerName":"new","name":"$buf","line":129},{"containerName":"new","kind":13,"name":"$buf","line":130},{"line":131,"containerName":"new","localvar":"my","kind":13,"name":"$id","definition":"my"},{"line":131,"name":"$width","kind":13,"containerName":"new"},{"line":131,"containerName":"new","kind":13,"name":"$seq"},{"line":131,"name":"$buf","kind":13,"containerName":"new"},{"name":"$self","containerName":"new","kind":13,"line":132},{"line":132,"containerName":"new","kind":13,"name":"$id"},{"line":133,"name":"$self","kind":13,"containerName":"new"},{"name":"$id","containerName":"new","kind":13,"line":133},{"name":"$width","containerName":"new","kind":13,"line":133},{"name":"$self","kind":13,"containerName":"new","line":134},{"line":134,"name":"$id","containerName":"new","kind":13},{"kind":13,"containerName":"new","name":"$seq","line":134},{"line":138,"kind":13,"containerName":"new","name":"$buf"},{"name":"$self","containerName":"new","kind":13,"line":139},{"line":139,"containerName":"new","kind":12,"name":"_readline"},{"kind":13,"containerName":"new","name":"$self","line":140},{"line":140,"containerName":"new","kind":12,"name":"_readline"},{"name":"$self","kind":13,"containerName":"new","line":141},{"line":141,"containerName":"new","kind":12,"name":"_readline"},{"containerName":"new","kind":13,"name":"%instances","line":142},{"name":"$self","kind":13,"containerName":"new","line":142},{"line":143,"name":"$self","containerName":"new","kind":13},{"line":143,"containerName":"new","kind":13,"name":"%instances"},{"name":"%instances","kind":13,"containerName":"new","line":144},{"kind":13,"containerName":"new","name":"$self","line":145},{"kind":12,"containerName":"new","name":"warn","line":145},{"line":146,"name":"$self","containerName":"new","kind":13},{"line":150,"name":"$buf","containerName":"new","kind":13},{"line":151,"name":"$self","containerName":"new","kind":13},{"line":151,"name":"_readline","containerName":"new","kind":12},{"kind":13,"containerName":"new","name":"$self","line":152},{"line":152,"name":"_readline","containerName":"new","kind":12},{"name":"$self","kind":13,"containerName":"new","line":153},{"line":153,"kind":12,"containerName":"new","name":"_readline"},{"line":156,"containerName":"new","kind":13,"name":"$buf"},{"kind":13,"containerName":"new","name":"@header","line":157},{"line":157,"containerName":"new","kind":13,"name":"$buf"},{"line":157,"name":"$buf","containerName":"new","kind":13},{"name":"$buf","kind":13,"containerName":"new","line":157}],"detail":"($class,@args)","definition":"sub","kind":12,"range":{"end":{"character":9999,"line":158},"start":{"character":0,"line":88}},"line":88,"signature":{"label":"new($class,@args)","documentation":"1;\n# $Id: mast.pm 16123 2009-09-17 12:57:27Z cjfields $\n\n=head1 NAME\n\nBio::Matrix::PSM::IO::mast - PSM mast parser implementation\n\n=head1 SYNOPSIS\n\nSee Bio::Matrix::PSM::IO for detailed documentation on how to \nuse PSM parsers\n\n=head1 DESCRIPTION\n\nParser for mast. This driver unlike meme or transfac for example is\ndedicated more to PSM sequence matches, than to PSM themselves.\n\n=head1 TO DO\n\nSection III should be parsed too, otherwise no real sequence is\navailable, so we supply 'NNNNN....' as a seq which is not right.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\nto one of the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Stefan Kirov\n\nEmail skirov@utk.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\npackage Bio::Matrix::PSM::IO::mast;\nuse Bio::Matrix::PSM::InstanceSite;\nuse Bio::Matrix::PSM::Psm;\nuse Bio::Root::Root;\nuse strict;\n\nuse base qw(Bio::Matrix::PSM::PsmHeader Bio::Matrix::PSM::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $psmIO =  Bio::Matrix::PSM::IO->new(-format=>'mast', \n\t\t\t\t\t\t                               -file=>$file);\n Function: Associates a file with the appropriate parser\n Throws  : Throws if the file passed is in HTML format or if \n           some criteria for the file\n           format are not met.\n Example :\n Returns : psm object, associated with a file with matrix file\n Args    : hash\n return  : \"Bio::Matrix::PSM::$format\"->new(@args);","parameters":[{"label":"$class"},{"label":"@args"}]}},{"line":90,"containerName":"new","kind":12,"name":"SUPER"},{"line":93,"name":"file","kind":12},{"line":94,"kind":12,"name":"_factor"},{"line":96,"kind":12,"name":"_end"},{"line":97,"kind":12,"name":"hid"},{"name":"_dbname","kind":12,"line":109},{"name":"_dbtype","kind":12,"line":109},{"line":110,"name":"_dbtype","kind":12},{"line":115,"kind":12,"name":"_mrsc"},{"line":115,"name":"_msrctype","kind":12},{"name":"_msrctype","kind":12,"line":116},{"line":120,"kind":12,"name":"_msrctype"},{"line":120,"name":"_dbtype","kind":12},{"line":121,"name":"_factor","kind":12},{"kind":12,"name":"_mixquery","line":122},{"line":132,"name":"hid","kind":12},{"kind":12,"name":"length","line":133},{"kind":12,"name":"seq","line":134},{"name":"_get_genes","kind":12,"line":142},{"line":143,"kind":12,"name":"instances"},{"line":159,"name":"$self","kind":13,"containerName":null},{"containerName":"main::","kind":12,"name":"throw","line":159},{"kind":13,"containerName":null,"name":"%instances","line":159},{"line":160,"kind":13,"containerName":null,"name":"$self"},{"kind":12,"containerName":"main::","name":"warn","line":160},{"containerName":null,"kind":13,"name":"@header","line":160},{"line":162,"name":"%self","containerName":null,"kind":13},{"kind":12,"name":"unstructured","line":162},{"name":"@header","kind":13,"containerName":null,"line":162},{"kind":13,"containerName":null,"name":"$self","line":163},{"kind":12,"containerName":"main::","name":"_initialize","line":163},{"containerName":null,"kind":13,"name":"$self","line":164},{"children":[{"definition":"my","containerName":"_get_genes","localvar":"my","kind":13,"name":"$self","line":171},{"line":172,"name":"%llid","containerName":"_get_genes","localvar":"my","kind":13,"definition":"my"},{"name":"$ok","localvar":"my","containerName":"_get_genes","kind":13,"line":173,"definition":"my"},{"kind":13,"localvar":"my","containerName":"_get_genes","name":"$i","line":174,"definition":"my"},{"line":175,"name":"%instances","containerName":"_get_genes","localvar":"my","kind":13,"definition":"my"},{"name":"$line","localvar":"my","containerName":"_get_genes","kind":13,"line":176,"definition":"my"},{"kind":13,"containerName":"_get_genes","name":"$self","line":176},{"line":176,"kind":12,"containerName":"_get_genes","name":"_readline"},{"containerName":"_get_genes","kind":13,"name":"$line","line":177},{"line":178,"kind":13,"containerName":"_get_genes","name":"$line"},{"containerName":"_get_genes","kind":13,"name":"$i","line":179},{"line":180,"name":"$line","containerName":"_get_genes","kind":13},{"kind":13,"containerName":"_get_genes","name":"$line","line":181},{"definition":"my","localvar":"my","containerName":"_get_genes","kind":13,"name":"$id","line":182},{"line":182,"name":"$key","kind":13,"containerName":"_get_genes"},{"line":182,"containerName":"_get_genes","kind":13,"name":"$eval"},{"name":"$len","kind":13,"containerName":"_get_genes","line":182},{"kind":13,"containerName":"_get_genes","name":"$line","line":182},{"name":"$len","containerName":"_get_genes","kind":13,"line":183},{"name":"$instances","containerName":"_get_genes","kind":13,"line":187},{"name":"$id","kind":13,"containerName":"_get_genes","line":187},{"kind":12,"containerName":"_get_genes","name":"new","line":187},{"line":187,"containerName":"_get_genes","kind":13,"name":"$id"},{"name":"$key","containerName":"_get_genes","kind":13,"line":188},{"line":189,"name":"$eval","kind":13,"containerName":"_get_genes"},{"line":190,"containerName":"_get_genes","kind":13,"name":"$len"},{"line":193,"name":"%instances","containerName":"_get_genes","kind":13}],"name":"_get_genes","containerName":"main::","definition":"sub","line":170,"range":{"start":{"character":0,"line":170},"end":{"character":9999,"line":194}},"kind":12},{"line":187,"containerName":"Matrix::PSM::InstanceSite","kind":12,"name":"Bio"},{"children":[{"name":"$self","localvar":"my","containerName":"next_psm","kind":13,"line":212,"definition":"my"},{"line":213,"name":"$self","kind":13,"containerName":"next_psm"},{"name":"@lmotifsm","containerName":"next_psm","localvar":"my","kind":13,"line":214,"definition":"my"},{"name":"%index","kind":13,"containerName":"next_psm","line":214},{"line":214,"containerName":"next_psm","kind":13,"name":"$eval"},{"line":214,"kind":13,"containerName":"next_psm","name":"$scheme"},{"line":214,"containerName":"next_psm","kind":13,"name":"$sid"},{"name":"%index","containerName":"next_psm","kind":13,"line":215},{"kind":13,"containerName":"next_psm","name":"$self","line":215}],"name":"next_psm","containerName":"main::","definition":"sub","line":211,"range":{"end":{"character":9999,"line":215},"start":{"line":211,"character":0}},"kind":12},{"line":213,"name":"_end","kind":12},{"line":215,"kind":12,"name":"length"},{"definition":"my","line":216,"name":"@instances","kind":13,"localvar":"my","containerName":null},{"containerName":null,"kind":13,"name":"%instances","line":216},{"definition":"my","line":217,"containerName":null,"localvar":"my","kind":13,"name":"$line"},{"line":217,"name":"$self","kind":13,"containerName":null},{"line":217,"kind":12,"containerName":"main::","name":"_readline"},{"line":218,"name":"$line","containerName":null,"kind":13},{"line":219,"containerName":null,"kind":13,"name":"%line"},{"line":220,"name":"%self","containerName":null,"kind":13},{"kind":12,"name":"_end","line":220},{"line":224,"containerName":null,"kind":13,"name":"%line"},{"line":225,"name":"$sid","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"$eval","line":225},{"containerName":null,"kind":13,"name":"$scheme","line":225},{"name":"%line","containerName":null,"kind":13,"line":225},{"name":"$scheme","kind":13,"containerName":null,"line":228},{"line":228,"name":"$line","containerName":null,"kind":13},{"line":229,"name":"$line","containerName":null,"kind":13},{"name":"$self","containerName":null,"kind":13,"line":229},{"line":229,"name":"_readline","containerName":"main::","kind":12},{"line":230,"containerName":null,"kind":13,"name":"$line"},{"line":231,"name":"$line","kind":13,"containerName":null},{"line":232,"localvar":"my","kind":13,"containerName":null,"name":"$pos","definition":"my"},{"kind":13,"containerName":null,"name":"$scheme","line":233},{"kind":13,"containerName":null,"name":"$scheme","line":234},{"definition":"my","name":"@motifs","localvar":"my","kind":13,"containerName":null,"line":235},{"name":"$scheme","kind":13,"containerName":null,"line":235},{"line":236,"name":"@motifs","kind":13,"containerName":null},{"definition":"my","localvar":"my","containerName":null,"kind":13,"name":"$next","line":237},{"line":237,"name":"@motifs","containerName":null,"kind":13},{"line":238,"name":"%next","containerName":null,"kind":13},{"line":239,"kind":13,"containerName":null,"name":"@motifs"},{"name":"$pos","kind":13,"containerName":null,"line":240},{"kind":13,"containerName":null,"name":"$next","line":240},{"name":"$id","localvar":"my","kind":13,"containerName":null,"line":243,"definition":"my"},{"kind":13,"containerName":null,"name":"$next","line":243},{"localvar":"my","containerName":null,"kind":13,"name":"$score","line":244,"definition":"my"},{"containerName":null,"kind":13,"name":"$id","line":244},{"definition":"my","name":"$frame","kind":13,"localvar":"my","containerName":null,"line":245},{"line":246,"kind":13,"localvar":"my","containerName":null,"name":"$strand","definition":"my"},{"line":246,"name":"$id","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"%self","line":247},{"line":247,"name":"_mixquery","kind":12},{"line":248,"name":"$frame","containerName":null,"kind":13},{"line":248,"kind":13,"containerName":null,"name":"$id"},{"line":249,"name":"$frame","containerName":null,"kind":13},{"name":"$id","containerName":null,"kind":13,"line":249},{"name":"$frame","kind":13,"containerName":null,"line":250},{"line":250,"name":"$id","kind":13,"containerName":null},{"line":252,"containerName":null,"kind":13,"name":"$id"},{"definition":"my","localvar":"my","kind":13,"containerName":null,"name":"@s","line":254},{"definition":"my","line":255,"containerName":null,"localvar":"my","kind":13,"name":"$width"},{"line":255,"containerName":null,"kind":13,"name":"%index"},{"line":255,"kind":13,"containerName":null,"name":"$id"},{"name":"$seq","kind":13,"localvar":"my","containerName":null,"line":257,"definition":"my"},{"name":"$width","kind":13,"containerName":null,"line":257},{"line":257,"name":"%self","kind":13,"containerName":null},{"name":"_factor","kind":12,"line":257},{"definition":"my","line":258,"localvar":"my","containerName":null,"kind":13,"name":"$instance"},{"line":258,"name":"Bio","kind":12,"containerName":"Matrix::PSM::InstanceSite"},{"line":258,"name":"new","kind":12,"containerName":"main::"},{"name":"$id","kind":13,"containerName":null,"line":260},{"containerName":null,"kind":13,"name":"$sid","line":261},{"containerName":null,"kind":13,"name":"$score","line":263},{"name":"$seq","containerName":null,"kind":13,"line":264},{"name":"$pos","containerName":null,"kind":13,"line":266},{"kind":13,"containerName":null,"name":"$strand","line":267},{"name":"$instance","kind":13,"containerName":null,"line":268},{"line":268,"containerName":"main::","kind":12,"name":"frame"},{"name":"$frame","containerName":null,"kind":13,"line":268},{"kind":13,"containerName":null,"name":"%self","line":268},{"kind":12,"name":"_mixquery","line":268},{"containerName":null,"kind":13,"name":"@instances","line":269},{"line":269,"containerName":null,"kind":13,"name":"$instance"},{"line":270,"containerName":null,"kind":13,"name":"$pos"},{"containerName":null,"kind":13,"name":"%index","line":270},{"containerName":null,"kind":13,"name":"$id","line":270},{"kind":13,"containerName":null,"name":"%self","line":270},{"name":"_factor","kind":12,"line":270},{"localvar":"my","kind":13,"containerName":null,"name":"$psm","line":272,"definition":"my"},{"kind":12,"containerName":"Matrix::PSM::Psm","name":"Bio","line":272},{"line":272,"kind":12,"containerName":"main::","name":"new"},{"line":272,"name":"@instances","kind":13,"containerName":null},{"line":273,"containerName":null,"kind":13,"name":"$eval"},{"kind":13,"containerName":null,"name":"$sid","line":274},{"name":"$self","kind":13,"containerName":null,"line":275},{"line":275,"name":"_pushback","containerName":"main::","kind":12},{"containerName":null,"kind":13,"name":"$line","line":275},{"line":276,"containerName":null,"kind":13,"name":"$psm"},{"children":[{"kind":13,"localvar":"my","containerName":"write_psm","name":"$self","line":299,"definition":"my"},{"name":"$matrix","kind":13,"containerName":"write_psm","line":299},{"definition":"my","line":301,"name":"$w","containerName":"write_psm","localvar":"my","kind":13},{"kind":13,"containerName":"write_psm","name":"$matrix","line":301},{"name":"width","kind":12,"containerName":"write_psm","line":301},{"line":302,"name":"$header","localvar":"my","kind":13,"containerName":"write_psm","definition":"my"},{"kind":13,"containerName":"write_psm","name":"$self","line":303},{"containerName":"write_psm","kind":12,"name":"_print","line":303},{"line":303,"kind":13,"containerName":"write_psm","name":"$header"},{"line":304,"name":"$matrix","containerName":"write_psm","kind":13},{"line":304,"name":"get_logs_array","containerName":"write_psm","kind":12},{"line":306,"name":"$matrix","kind":13,"containerName":"write_psm"},{"line":306,"name":"calc_weight","kind":12,"containerName":"write_psm"},{"definition":"my","name":"%h","containerName":"write_psm","localvar":"my","kind":13,"line":308},{"containerName":"write_psm","kind":13,"name":"$matrix","line":308},{"line":308,"containerName":"write_psm","kind":12,"name":"next_pos"},{"name":"$self","kind":13,"containerName":"write_psm","line":309},{"line":309,"name":"_print","containerName":"write_psm","kind":12},{"name":"$h","kind":13,"containerName":"write_psm","line":309},{"line":309,"kind":13,"containerName":"write_psm","name":"$h"},{"line":309,"name":"$h","kind":13,"containerName":"write_psm"},{"kind":13,"containerName":"write_psm","name":"$h","line":309}],"name":"write_psm","containerName":"main::","definition":"sub","detail":"($self,$matrix)","line":298,"kind":12,"range":{"start":{"line":298,"character":0},"end":{"character":9999,"line":311}},"signature":{"label":"write_psm($self,$matrix)","parameters":[{"label":"$self"},{"label":"$matrix"}],"documentation":"1;\n# $Id: mast.pm 16123 2009-09-17 12:57:27Z cjfields $\n\n=head1 NAME\n\nBio::Matrix::PSM::IO::mast - PSM mast parser implementation\n\n=head1 SYNOPSIS\n\nSee Bio::Matrix::PSM::IO for detailed documentation on how to \nuse PSM parsers\n\n=head1 DESCRIPTION\n\nParser for mast. This driver unlike meme or transfac for example is\ndedicated more to PSM sequence matches, than to PSM themselves.\n\n=head1 TO DO\n\nSection III should be parsed too, otherwise no real sequence is\navailable, so we supply 'NNNNN....' as a seq which is not right.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\nto one of the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Stefan Kirov\n\nEmail skirov@utk.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\npackage Bio::Matrix::PSM::IO::mast;\nuse Bio::Matrix::PSM::InstanceSite;\nuse Bio::Matrix::PSM::Psm;\nuse Bio::Root::Root;\nuse strict;\n\nuse base qw(Bio::Matrix::PSM::PsmHeader Bio::Matrix::PSM::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $psmIO =  Bio::Matrix::PSM::IO->new(-format=>'mast', \n\t\t\t\t\t\t                               -file=>$file);\n Function: Associates a file with the appropriate parser\n Throws  : Throws if the file passed is in HTML format or if \n           some criteria for the file\n           format are not met.\n Example :\n Returns : psm object, associated with a file with matrix file\n Args    : hash\n return  : \"Bio::Matrix::PSM::$format\"->new(@args);\n\n\n\nsub new {\n    my($class, @args)=@_;\n    my $self = $class->SUPER::new(@args);\n    my (%instances,@header,$n);\n    my ($file)=$self->_rearrange(['FILE'], @args);\n    $self->{file} = $file;\n    $self->{_factor}=1;\n    $self->_initialize_io(@args) || warn \"Did you intend to use STDIN?\"; #Read only for now\n    $self->{_end}=0;\n    undef $self->{hid};\n    return $self if ($file=~/^>/);#Just writing\n    my $buf=$self->_readline;\n\t$self->throw('Cannot parse HTML format yet') if ($buf =~/^<HTML>/); \n    # this should probably be moved to its own function\n    while ( defined($buf=$self->_readline)) {\n\tchomp($buf);\n\tif ($buf=~/DATABASE AND MOTIFS/) {\n\t\twhile ($buf=$self->_readline) {\n\t\t\tif ($buf=~/DATABASE/) {\n\t\t\t\t\t$buf=~s/^[\\s\\t]+//;\n\t\t\t\t\tchomp $buf;\n\t\t\t\t\t($n,$self->{_dbname},$self->{_dbtype})=split(/\\s/,$buf);\n\t\t\t\t\t$self->{_dbtype}=~s/[\\(\\)]//g;\n\t\t\t}\n\t\t\tif ($buf=~/MOTIFS/) {\n\t\t\t\t\t$buf=~s/^[\\s\\t]+//;\n\t\t\t\t\tchomp $buf;\n\t\t\t\t\t($n,$self->{_mrsc},$self->{_msrctype})=split(/\\s/,$buf);\n\t\t\t\t\t$self->{_msrctype}=~s/[\\(\\)]//g;\n\t\t\t\t\tlast;\n\t\t\t}\n\t\t}\n\t\tif ($self->{_msrctype} ne $self->{_dbtype}) {#Assume we have protein motifs, nuc DB (not handling opp.)\n\t\t\t$self->{_factor}=3;\n\t\t\t$self->{_mixquery}=1;\n\t\t}\n\t}\n\tif ($buf=~m/MOTIF WIDTH BEST POSSIBLE MATCH/) {\n\t    $self->_readline;\n\t    while (defined($buf=$self->_readline)) {\n\t\tlast if ($buf!~/\\w/);\n\t\t$buf=~s/\\t+//g;\n\t\t$buf=~s/^\\s+//g;\n\t\tmy ($id,$width,$seq)=split(/\\s+/,$buf);\n\t\tpush @{$self->{hid}},$id;\n\t\t$self->{length}->{$id}=$width;\n\t\t$self->{seq}->{$id}=$seq;\n\t    }\n\t    next;\n\t}\n\tif ($buf=~m/section i:/i) {\n\t    $self->_readline;\n\t    $self->_readline;\n\t    $self->_readline;\n\t    %instances=_get_genes($self);\n\t    $self->{instances}=\\%instances;\n      \tif (!(%instances)) {\n        \t$self->warn (\"Your MAST analysis did not find any matches satisfying the current threshold.\\nSee MAST documentation for more information.\\n\");\n        \treturn $self; #The header might be useful so we return the object, not undef\n      \t}\n\t    next;\n\t}\n\tif ($buf=~m/section ii:/i) {\n\t    $self->_readline;\n\t    $self->_readline;\n\t    $self->_readline;\n\t    last;\n\t}\n\t$buf=~s/[\\t+\\s+]/ /g;\n\tpush @header,$buf unless (($buf=~/\\*{10,}/)||($buf!~/\\w/));\n    }\n    $self->throw('Could not read Section I, probably wrong format, make sure it is not HTML, giving up...') if !(%instances);\n    $self->warn( \"This file might be an unreadable version, proceed with caution!\\n\") if (!grep(/\\s+MAST\\s+version\\s+3/,@header));\n\n    $self->{unstructured} = \\@header;\n    $self->_initialize;\n    return $self;\n}\n\n\n# Get the file header and put store it as a hash, which later we'll use to create\n# the header for each Psm. See Bio::Matrix::PSM::PsmI for header function.\nsub _get_genes {\n\tmy $self=shift;\n\tmy %llid;\n\tmy $ok=0;\n\tmy $i=0;\n\tmy %instances;\n\twhile (my $line=$self->_readline) {\n\t\tlast if ($line=~/^[\\s\\t*]/); # Well, ids can be nearly anything...???\n\t\tchomp($line);\n\t\t$i++;\n\t\tnext if ($line eq '');\n\t\t$line=~s/\\s+/,/g;\n\t\tmy ($id,$key,$eval,$len)=split(/,/,$line);\n\t\tunless ($len) {\n\t\t\twarn \"Malformed data found: $line\\n\";\n\t\t\tnext;\n\t\t}\n\t\t$instances{$id}=Bio::Matrix::PSM::InstanceSite->new(-id=>$id,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t  -desc=>$key,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t  -score=>$eval, \n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t  -width=>$len,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t  -seq=>'ACGT');\n\t}\n\treturn %instances;\n}\n\n\n=head2 next_psm\n\n Title   : next_psm\n Usage   : my $psm=$psmIO->next_psm();\n Function: Reads the next PSM from the input file, associated with this object\n Throws  : Throws if there ara format violations in the input file (checking is not\n            very strict with all drivers).\n Example :\n Returns : Bio::Matrix::PSM::Psm object\n Args    : none\n\n\n\nsub next_psm {\n    my $self=shift;\n    return if ($self->{_end}==1);\n    my (@lmotifsm,%index,$eval,$scheme,$sid);\n    %index= %{$self->{length}};\n    my (@instances,%instances);\n    my $line=$self->_readline;\n    $line=~s/[\\t\\n]//;\n    if ($line =~ /\\*{10,}/) { #Endo of Section II if we do only section II\n        $self->{_end}=1;\n        return ;\n    }\n    do {\n\tif ($line!~/^\\s/) {\n\t    ($sid,$eval,$scheme)=split(/\\s+/,$line,3);\n\t}\n\telse\n\t{ $scheme .=$line; }\n\t$line=$self->_readline;\n\t$line=~s/[\\t\\n]//;\n    } until ($line!~/^\\s/);\n    my $pos=1;\n    $scheme=~s/\\s+//g;\n    $scheme=~s/\\n//g;\n    my @motifs=split(/_/,$scheme);\n    while (@motifs) {\n\tmy $next=shift(@motifs);\n\tif (!($next=~/\\D/)) {\n\t    last if (!@motifs);\n\t    $pos+=$next;\n\t    next;\n\t}\n        my $id=$next;\n\tmy $score= $id=~m/\\[/ ? 'strong' : 'weak' ;\n\tmy $frame;\n\tmy $strand = $id =~ m/\\-\\d/ ? -1 : 1 ;\n\tif ($self->{_mixquery}) {\n\t\t$frame = 0 if $id =~ m/\\d+a/ ;\n\t\t$frame = 1 if $id =~ m/\\d+b/ ;\n\t\t$frame = 2 if $id =~ m/\\d+c/ ;\n\t}\n\t$id=~s/\\D+//g;\n\n\tmy @s;\n\tmy $width=$index{$id};\n    #We don't know the sequence, but we know the length\n\tmy $seq='N' x ($width*$self->{_factor}); #Future version will have to parse Section tree nad get the real seq\n\tmy $instance=Bio::Matrix::PSM::InstanceSite->new \n\t    ( -id=>\"$id\\@$sid\", \n\t      -mid=>$id, \n\t      -accession_number=>$sid,\n\t      -desc=>\"Motif $id occurrance in $sid\",\n\t      -score=>$score, \n\t      -seq=>$seq,\n\t\t  -alphabet => 'dna', \n\t      -start=>$pos,\n\t      -strand=>$strand);\n\t  $instance->frame($frame) if ($self->{_mixquery});\n\tpush @instances,$instance;\n\t$pos+=$index{$id}*$self->{_factor};\n    }\n    my $psm= Bio::Matrix::PSM::Psm->new(-instances=> \\@instances, \n\t\t\t\t\t-e_val    => $eval, \n\t\t\t\t\t-id       => $sid);\n    $self->_pushback($line);\n    return $psm;\n}\n\n\n=head2 write_psm\n\n Title   : write_psm\n Usage   : #Get SiteMatrix object somehow (see Bio::Matrix::PSM::SiteMatrix)\n            my $matrix=$psmin->next_matrix;\n            #Create the stream\n            my $psmio=new(-file=>\">psms.mast\",-format=>'mast');\n            $psmio->write_psm($matrix);\n            #Will warn if only PFM data is contained in $matrix, recalculate the PWM\n            #based on normal distribution (A=>0.25, C=>0.25, etc)\n Function: writes pwm in mast format\n Throws  :\n Example : \n Args    : SiteMatrix object\n Returns : "}},{"line":309,"name":"lA","kind":12},{"name":"lC","kind":12,"line":309},{"line":309,"name":"lG","kind":12},{"line":309,"kind":12,"name":"lT"}]}