{"version":5,"vars":[{"containerName":"","kind":2,"name":"vars","line":111},{"name":"base","containerName":"","kind":2,"line":114},{"kind":13,"containerName":null,"name":"@PSMFORMATS","line":116},{"detail":"($caller,@args)","definition":"sub","containerName":"main::","name":"new","children":[{"line":135,"kind":13,"localvar":"my","containerName":"new","name":"$caller","definition":"my"},{"containerName":"new","kind":13,"name":"@args","line":135},{"line":136,"name":"$class","containerName":"new","localvar":"my","kind":13,"definition":"my"},{"name":"$caller","containerName":"new","kind":13,"line":136},{"kind":13,"containerName":"new","name":"$caller","line":136},{"line":137,"localvar":"my","containerName":"new","kind":13,"name":"$self","definition":"my"},{"line":140,"name":"$class","kind":13,"containerName":"new"},{"line":141,"name":"$self","containerName":"new","kind":13},{"containerName":"new","kind":13,"name":"$class","line":141},{"name":"@args","containerName":"new","kind":13,"line":141},{"containerName":"new","kind":13,"name":"$self","line":142},{"line":142,"containerName":"new","kind":12,"name":"_initialize"},{"containerName":"new","kind":13,"name":"@args","line":142},{"name":"$self","kind":13,"containerName":"new","line":143},{"definition":"my","line":145,"kind":13,"localvar":"my","containerName":"new","name":"%param"},{"line":145,"name":"@args","containerName":"new","kind":13},{"line":146,"containerName":"new","kind":13,"name":"@param"},{"line":146,"containerName":"new","kind":13,"name":"%param"},{"name":"%param","containerName":"new","kind":13,"line":146},{"definition":"my","kind":13,"localvar":"my","containerName":"new","name":"$format","line":147},{"line":147,"name":"$param","kind":13,"containerName":"new"},{"containerName":"new","kind":13,"name":"$class","line":148},{"name":"_guess_format","containerName":"new","kind":12,"line":148},{"line":148,"kind":13,"containerName":"new","name":"$param"},{"line":148,"name":"$ARGV","containerName":"new","kind":13},{"line":150,"kind":13,"containerName":"new","name":"$class"},{"line":150,"name":"throw","containerName":"new","kind":12},{"name":"@Bio","kind":13,"containerName":"new","line":150},{"name":"$format","containerName":"new","kind":13,"line":151},{"line":154,"kind":13,"containerName":"new","name":"$class"},{"name":"_load_format_module","kind":12,"containerName":"new","line":154},{"name":"$format","containerName":"new","kind":13,"line":154},{"name":"new","containerName":"new","kind":12,"line":155},{"line":155,"kind":13,"containerName":"new","name":"@args"}],"signature":{"parameters":[{"label":"$caller"},{"label":"@args"}],"documentation":"1;\n#---------------------------------------------------------\n# $Id: IO.pm 16123 2009-09-17 12:57:27Z cjfields $\n\n=head1 NAME\n\nBio::Matrix::PSM::IO - PSM parser\n\n=head1 SYNOPSIS\n\n  use Bio::Matrix::PSM::IO;\n\n  my $psmIO= Bio::Matrix::PSM::IO->new(-file=>$file, -format=>'transfac');\n\n  my $release=$psmIO->release; #Using Bio::Matrix::PSM::PsmHeader methods\n\n  my $release=$psmIO->release;\n\n  while (my $psm=$psmIO->next_psm) {\n   my %psm_header=$psm->header;\n   my $ic=$psm_header{IC};\n   my $sites=$psm_header{sites};\n   my $width=$psm_header{width};\n   my $score=$psm_header{e_val};\n   my $IUPAC=$psm->IUPAC;\n  }\n\n  my $instances=$psm->instances;\n  foreach my $instance (@{$instances}) {\n    my $id=$instance->primary_id;\n  }\n\n\n=head1 DESCRIPTION\n\nThis module allows you to read DNA position scoring matrices and/or\ntheir respective sequence matches from a file.\n\nThere are two header methods, one belonging to\nBio::Matrix::PSM::IO::driver and the other to\nBio::Matrix::PSM::Psm. They provide general information about the file\n(driver) and for the current PSM result (Psm) respectively. Psm header\nmethod always returns the same thing, but some values in the hash\nmight be empty, depending on the file you are parsing. You will get\nundef in this case (no exceptions are thrown).\n\nPlease note that the file header data (commenatries, version, input\ndata, configuration, etc.)  might be obtained through\nBio::Matrix::PSM::PsmHeader methods. Some methods are driver specific\n(meme, transfac, etc.): meme: weight mast: seq, instances\n\nIf called when you parse a different file type you will get undef. For\nexample:\n\n  my $psmIO= Bio::Matrix::PSM::IO->new(file=>$file, format=>'transfac');\n  my %seq=$psmIO->seq;\n\nwill return an empty hash. To see all methods and how to use them go\nto Bio::Matrix::PSM::PsmHeaderI.\n\nSee also Bio::Matrix::PSM::PsmI for details on using and manipulating\nthe parsed data.\n\nThe only way to write PFM/PWM is through masta module (something like fasta for\nDNA matrices). You can see an example by reading Bio::Matrix::PSM::IO::masta\ndocumentation.\n\n=head1 See also\n\nBio::Matrix::PSM::PsmI, Bio::Matrix::PSM::PsmHeaderI, Bio::Matrix::PSM::IO::masta\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Stefan Kirov\n\nEmail skirov@utk.edu\n\n=head1 APPENDIX\n\n\n\n# Let the code begin...\npackage Bio::Matrix::PSM::IO;\nuse vars qw(@PSMFORMATS);\nuse strict;\n\nuse base qw(Bio::Root::IO);\n\n@PSMFORMATS = qw(meme transfac mast psiblast masta);\n\n=head2 new\n\n Title   : new\n Usage   : my $psmIO =  Bio::Matrix::PSM::IO->new(-format=>'meme', \n\t\t\t\t\t\t -file=>$file);\n Function: Associates a file with the appropriate parser\n Throws  : Throws if the file passed is in HTML format or \n           if some criteria for the file\n           format are not met. See L<Bio::Matrix::PSM::IO::meme> and \n           L<Bio::Matrix::PSM::IO::transfac> for more details.\n Example :\n Returns : psm object, associated with a file with matrix file\n Args    : hash","label":"new($caller,@args)"},"range":{"end":{"character":9999,"line":157},"start":{"line":134,"character":0}},"kind":12,"line":134},{"line":141,"name":"SUPER","kind":12,"containerName":"new"},{"name":"Matrix","kind":12,"containerName":"PSM::IO::PSMFORMATS","line":150},{"children":[{"localvar":"my","containerName":"fh","kind":13,"name":"$self","line":172,"definition":"my"},{"definition":"my","line":173,"kind":13,"localvar":"my","containerName":"fh","name":"$class"},{"name":"$self","kind":13,"containerName":"fh","line":173},{"line":173,"name":"$self","kind":13,"containerName":"fh"},{"containerName":"fh","localvar":"my","kind":13,"name":"$s","line":174,"definition":"my"},{"line":175,"name":"$class","containerName":"fh","kind":13},{"kind":13,"containerName":"fh","name":"$self","line":175},{"line":176,"name":"$s","containerName":"fh","kind":13}],"containerName":"main::","name":"fh","definition":"sub","line":171,"kind":12,"range":{"end":{"character":9999,"line":177},"start":{"character":0,"line":171}}},{"line":175,"kind":12,"containerName":"gensym","name":"Symbol"},{"range":{"end":{"character":9999,"line":207},"start":{"line":188,"character":0}},"kind":12,"line":188,"signature":{"parameters":[{"label":"$self"},{"label":"$format"}],"documentation":"1;\n#---------------------------------------------------------\n# $Id: IO.pm 16123 2009-09-17 12:57:27Z cjfields $\n\n=head1 NAME\n\nBio::Matrix::PSM::IO - PSM parser\n\n=head1 SYNOPSIS\n\n  use Bio::Matrix::PSM::IO;\n\n  my $psmIO= Bio::Matrix::PSM::IO->new(-file=>$file, -format=>'transfac');\n\n  my $release=$psmIO->release; #Using Bio::Matrix::PSM::PsmHeader methods\n\n  my $release=$psmIO->release;\n\n  while (my $psm=$psmIO->next_psm) {\n   my %psm_header=$psm->header;\n   my $ic=$psm_header{IC};\n   my $sites=$psm_header{sites};\n   my $width=$psm_header{width};\n   my $score=$psm_header{e_val};\n   my $IUPAC=$psm->IUPAC;\n  }\n\n  my $instances=$psm->instances;\n  foreach my $instance (@{$instances}) {\n    my $id=$instance->primary_id;\n  }\n\n\n=head1 DESCRIPTION\n\nThis module allows you to read DNA position scoring matrices and/or\ntheir respective sequence matches from a file.\n\nThere are two header methods, one belonging to\nBio::Matrix::PSM::IO::driver and the other to\nBio::Matrix::PSM::Psm. They provide general information about the file\n(driver) and for the current PSM result (Psm) respectively. Psm header\nmethod always returns the same thing, but some values in the hash\nmight be empty, depending on the file you are parsing. You will get\nundef in this case (no exceptions are thrown).\n\nPlease note that the file header data (commenatries, version, input\ndata, configuration, etc.)  might be obtained through\nBio::Matrix::PSM::PsmHeader methods. Some methods are driver specific\n(meme, transfac, etc.): meme: weight mast: seq, instances\n\nIf called when you parse a different file type you will get undef. For\nexample:\n\n  my $psmIO= Bio::Matrix::PSM::IO->new(file=>$file, format=>'transfac');\n  my %seq=$psmIO->seq;\n\nwill return an empty hash. To see all methods and how to use them go\nto Bio::Matrix::PSM::PsmHeaderI.\n\nSee also Bio::Matrix::PSM::PsmI for details on using and manipulating\nthe parsed data.\n\nThe only way to write PFM/PWM is through masta module (something like fasta for\nDNA matrices). You can see an example by reading Bio::Matrix::PSM::IO::masta\ndocumentation.\n\n=head1 See also\n\nBio::Matrix::PSM::PsmI, Bio::Matrix::PSM::PsmHeaderI, Bio::Matrix::PSM::IO::masta\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Stefan Kirov\n\nEmail skirov@utk.edu\n\n=head1 APPENDIX\n\n\n\n# Let the code begin...\npackage Bio::Matrix::PSM::IO;\nuse vars qw(@PSMFORMATS);\nuse strict;\n\nuse base qw(Bio::Root::IO);\n\n@PSMFORMATS = qw(meme transfac mast psiblast masta);\n\n=head2 new\n\n Title   : new\n Usage   : my $psmIO =  Bio::Matrix::PSM::IO->new(-format=>'meme', \n\t\t\t\t\t\t -file=>$file);\n Function: Associates a file with the appropriate parser\n Throws  : Throws if the file passed is in HTML format or \n           if some criteria for the file\n           format are not met. See L<Bio::Matrix::PSM::IO::meme> and \n           L<Bio::Matrix::PSM::IO::transfac> for more details.\n Example :\n Returns : psm object, associated with a file with matrix file\n Args    : hash\n\n\nsub new {\n    my($caller,@args) = @_;\n    my $class = ref($caller) || $caller;\n    my $self;\n    # or do we want to call SUPER on an object if $caller is an\n    # object?\n    if( $class =~ /Bio::Matrix::PSM::IO(\\S+)/ ) {\n\t$self = $class->SUPER::new(@args);\n\t$self->_initialize(@args);\n\treturn $self;\n    } else {\n\tmy %param = @args;\n\t@param{ map { lc $_ } keys %param } = values %param; # lowercase keys\n\tmy $format = $param{'-format'} ||\n\t    $class->_guess_format( $param{'-file'} || $ARGV[0] ) ||\n\t    'scoring';\n\t$class->throw(\"$format format unrecognized or an argument error occured\\n.\") if (!grep(/$format/,@Bio::Matrix::PSM::IO::PSMFORMATS));\n\t$format = \"\\L$format\"; # normalize capitalization to lower case\n\n\t# normalize capitalization\n\treturn unless( $class->_load_format_module($format) );\n\treturn \"Bio::Matrix::PSM::IO::$format\"->new(@args);\n    }\n}\n\n=head2 fh\n\n Title   : fh\n Usage   : $obj->fh\n Function: Get a filehandle type access to the matrix parser\n Example : $fh = $obj->fh;      # make a tied filehandle\n           $matrix = <$fh>;     # read a matrix object\n Returns : filehandle tied to Bio::Matrix::PSM::IO class\n Args    : none\n\n\nsub fh {\n    my $self = shift;\n    my $class = ref($self) || $self;\n    my $s = Symbol::gensym;\n    tie $$s,$class,$self;\n    return $s;\n}\n\n\n=head2 _load_format_module\n\n Title   : _load_format_module\n Usage   : *INTERNAL Matrix::PSM::IO stuff*\n Function: Loads up (like use) a module at run time on demand","label":"_load_format_module($self,$format)"},"name":"_load_format_module","containerName":"main::","children":[{"line":189,"localvar":"my","containerName":"_load_format_module","kind":13,"name":"$self","definition":"my"},{"line":189,"name":"$format","containerName":"_load_format_module","kind":13},{"definition":"my","line":190,"name":"$module","containerName":"_load_format_module","localvar":"my","kind":13},{"name":"$format","containerName":"_load_format_module","kind":13,"line":190},{"definition":"my","name":"$ok","localvar":"my","kind":13,"containerName":"_load_format_module","line":191},{"name":"$ok","containerName":"_load_format_module","kind":13,"line":194},{"name":"$self","kind":13,"containerName":"_load_format_module","line":194},{"line":194,"name":"_load_module","containerName":"_load_format_module","kind":12},{"line":194,"name":"$module","containerName":"_load_format_module","kind":13},{"name":"$ok","kind":13,"containerName":"_load_format_module","line":206}],"detail":"($self,$format)","definition":"sub"},{"containerName":"main::","name":"_guess_format","children":[{"line":220,"name":"$class","localvar":"my","containerName":"_guess_format","kind":13,"definition":"my"}],"definition":"sub","range":{"end":{"character":9999,"line":225},"start":{"line":219,"character":0}},"kind":12,"line":219},{"line":240,"kind":12,"range":{"end":{"line":243,"character":9999},"start":{"line":240,"character":0}},"definition":"sub","children":[{"definition":"my","line":241,"containerName":"next_psm","localvar":"my","kind":13,"name":"$self"},{"line":242,"name":"$self","kind":13,"containerName":"next_psm"},{"name":"throw_not_implemented","containerName":"next_psm","kind":12,"line":242}],"name":"next_psm","containerName":"main::"},{"definition":"sub","name":"_parseMatrix","containerName":"main::","children":[{"localvar":"my","kind":13,"containerName":"_parseMatrix","name":"$self","line":258,"definition":"my"},{"containerName":"_parseMatrix","kind":13,"name":"$self","line":259},{"line":259,"name":"throw_not_implemented","containerName":"_parseMatrix","kind":12}],"range":{"end":{"line":260,"character":9999},"start":{"line":257,"character":0}},"kind":12,"line":257},{"range":{"start":{"character":0,"line":274},"end":{"character":9999,"line":277}},"kind":12,"line":274,"containerName":"main::","name":"_parseInstance","children":[{"definition":"my","line":275,"name":"$self","kind":13,"localvar":"my","containerName":"_parseInstance"},{"containerName":"_parseInstance","kind":13,"name":"$self","line":276},{"name":"throw_not_implemented","kind":12,"containerName":"_parseInstance","line":276}],"definition":"sub"},{"definition":"sub","children":[{"line":292,"name":"$self","kind":13,"localvar":"my","containerName":"_parse_coordinates","definition":"my"},{"line":293,"name":"$self","kind":13,"containerName":"_parse_coordinates"},{"line":293,"name":"throw_not_implemented","containerName":"_parse_coordinates","kind":12}],"name":"_parse_coordinates","containerName":"main::","line":291,"kind":12,"range":{"end":{"line":294,"character":9999},"start":{"line":291,"character":0}}},{"kind":12,"range":{"end":{"character":9999,"line":311},"start":{"line":308,"character":0}},"line":308,"containerName":"main::","name":"header","children":[{"definition":"my","containerName":"header","localvar":"my","kind":13,"name":"$self","line":309},{"line":310,"name":"$self","containerName":"header","kind":13},{"containerName":"header","kind":12,"name":"throw_not_implemented","line":310}],"definition":"sub"},{"line":325,"range":{"start":{"character":0,"line":325},"end":{"line":328,"character":9999}},"kind":12,"definition":"sub","children":[{"definition":"my","localvar":"my","containerName":"_make_matrix","kind":13,"name":"$self","line":326},{"containerName":"_make_matrix","kind":13,"name":"$self","line":327},{"line":327,"name":"throw_not_implemented","kind":12,"containerName":"_make_matrix"}],"containerName":"main::","name":"_make_matrix"},{"line":331,"range":{"end":{"line":334,"character":9999},"start":{"line":331,"character":0}},"kind":12,"definition":"sub","children":[{"definition":"my","localvar":"my","containerName":"DESTROY","kind":13,"name":"$self","line":332},{"kind":13,"containerName":"DESTROY","name":"$self","line":333},{"line":333,"containerName":"DESTROY","kind":12,"name":"close"}],"containerName":"main::","name":"DESTROY"}]}