{"version":5,"vars":[{"line":87,"containerName":"","kind":2,"name":"base"},{"signature":{"documentation":"1;\n# $Id: Generic.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Matrix::Generic\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::Generic - A generic matrix implementation\n\n=head1 SYNOPSIS\n\n  # A matrix has columns and rows \n  my $matrix = Bio::Matrix::Generic->new;\n  $matrix->add_column(1,$column1);\n  $matrix->add_column(2,$column2);\n\n  my $element = $matrix->entry_by_num(1,2);\n  $matrix->entry_by_num(1,2,$newval);\n\n  my $entry = $matrix->entry('human', 'mouse');\n\n  $matrix->entry('human','mouse', $newval);\n\n\n=head1 DESCRIPTION\n\nThis is a general purpose matrix object for dealing with row+column\ndata which is typical when enumerating all the pairwise combinations\nand desiring to get slices of the data.\n\nData can be accessed by column and row names or indexes.  Matrix\nindexes start at 0.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Matrix::Generic;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Matrix::MatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Matrix::Generic->new();\n Function: Builds a new Bio::Matrix::Generic object \n Returns : an instance of Bio::Matrix::Generic\n Args    : -values     => arrayref of arrayrefs of data initialization \n           -rownames   => arrayref of row names\n           -colnames   => arrayref of col names\n           -matrix_id  => id of the matrix\n           -matrix_name=> name of the matrix\n           -matrix_init_value => default value to initialize empty cells","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"},"kind":12,"range":{"end":{"character":9999,"line":130},"start":{"character":0,"line":104}},"line":104,"detail":"($class,@args)","definition":"sub","containerName":"main::","name":"new","children":[{"definition":"my","name":"$class","containerName":"new","localvar":"my","kind":13,"line":105},{"containerName":"new","kind":13,"name":"@args","line":105},{"definition":"my","name":"$self","containerName":"new","localvar":"my","kind":13,"line":107},{"name":"$class","kind":13,"containerName":"new","line":107},{"kind":13,"containerName":"new","name":"@args","line":107},{"localvar":"my","containerName":"new","kind":13,"name":"$values","line":108,"definition":"my"},{"line":108,"name":"$rownames","containerName":"new","kind":13},{"line":108,"kind":13,"containerName":"new","name":"$colnames"},{"containerName":"new","kind":13,"name":"$id","line":109},{"name":"$name","containerName":"new","kind":13,"line":109},{"line":109,"name":"$init_val","containerName":"new","kind":13},{"line":110,"containerName":"new","kind":13,"name":"$self"},{"containerName":"new","kind":12,"name":"_rearrange","line":110},{"containerName":"new","kind":13,"name":"@args","line":112},{"name":"$self","containerName":"new","kind":13,"line":113},{"containerName":"new","kind":12,"name":"matrix_id","line":113},{"name":"$id","kind":13,"containerName":"new","line":113},{"name":"$id","kind":13,"containerName":"new","line":113},{"containerName":"new","kind":13,"name":"$self","line":114},{"kind":12,"containerName":"new","name":"matrix_name","line":114},{"line":114,"name":"$name","containerName":"new","kind":13},{"line":114,"kind":13,"containerName":"new","name":"$name"},{"line":115,"name":"$rownames","containerName":"new","kind":13},{"line":115,"name":"$colnames","kind":13,"containerName":"new"},{"line":116,"kind":13,"containerName":"new","name":"$rownames"},{"name":"$self","kind":13,"containerName":"new","line":117},{"name":"throw","containerName":"new","kind":12,"line":117},{"line":120,"name":"$self","kind":13,"containerName":"new"},{"containerName":"new","kind":13,"name":"$rownames","line":120},{"line":121,"containerName":"new","localvar":"my","kind":13,"name":"$count","definition":"my"},{"line":122,"kind":13,"containerName":"new","name":"$self"},{"name":"$count","containerName":"new","kind":13,"line":122},{"name":"$rownames","containerName":"new","kind":13,"line":122},{"line":124,"name":"$colnames","kind":13,"containerName":"new"},{"containerName":"new","kind":13,"name":"$self","line":125},{"containerName":"new","kind":12,"name":"throw","line":125},{"line":128,"kind":13,"containerName":"new","name":"$self"},{"containerName":"new","kind":13,"name":"$colnames","line":128},{"line":129,"name":"$count","containerName":"new","kind":13},{"kind":13,"containerName":"new","name":"$self","line":130}]},{"line":107,"name":"SUPER","containerName":"new","kind":12},{"name":"$count","kind":13,"containerName":null,"line":130},{"line":130,"name":"$colnames","containerName":null,"kind":13},{"line":132,"name":"%self","kind":13,"containerName":null},{"name":"%values","kind":13,"containerName":null,"line":133},{"line":134,"name":"%values","containerName":null,"kind":13},{"line":135,"kind":13,"containerName":null,"name":"$self"},{"line":135,"name":"throw","containerName":"main::","kind":12},{"name":"%v","localvar":"my","containerName":null,"kind":13,"line":137,"definition":"my"},{"name":"%v","containerName":null,"kind":13,"line":138},{"name":"$self","kind":13,"containerName":null,"line":139},{"line":139,"name":"throw","kind":12,"containerName":"main::"},{"kind":13,"containerName":null,"name":"%self","line":141},{"containerName":null,"kind":13,"name":"%v","line":141},{"line":144,"name":"@fill","kind":13,"localvar":"my","containerName":null,"definition":"my"},{"kind":13,"containerName":null,"name":"$init_val","line":144},{"line":144,"kind":13,"containerName":null,"name":"$colnames"},{"line":145,"kind":13,"containerName":null,"name":"%rownames"},{"line":146,"name":"%self","containerName":null,"kind":13},{"name":"@fill","kind":13,"containerName":null,"line":146},{"line":149,"kind":13,"containerName":null,"name":"$rownames"},{"name":"$colnames","containerName":null,"kind":13,"line":149},{"line":149,"kind":13,"containerName":null,"name":"%values"},{"line":150,"name":"%self","kind":13,"containerName":null},{"name":"%self","containerName":null,"kind":13,"line":151},{"kind":13,"containerName":null,"name":"%self","line":152},{"containerName":null,"kind":13,"name":"$self","line":154},{"containerName":"main::","kind":12,"name":"throw","line":154},{"line":157,"containerName":null,"kind":13,"name":"$self"},{"definition":"sub","children":[{"definition":"my","line":173,"name":"$self","localvar":"my","containerName":"matrix_id","kind":13},{"name":"$self","containerName":"matrix_id","kind":13,"line":174},{"line":175,"containerName":"matrix_id","kind":13,"name":"$self"}],"containerName":"main::","name":"matrix_id","line":172,"kind":12,"range":{"end":{"line":178,"character":9999},"start":{"character":0,"line":172}}},{"children":[{"line":192,"containerName":"matrix_name","localvar":"my","kind":13,"name":"$self","definition":"my"},{"line":193,"name":"$self","containerName":"matrix_name","kind":13},{"line":194,"kind":13,"containerName":"matrix_name","name":"$self"}],"name":"matrix_name","containerName":"main::","definition":"sub","line":191,"range":{"start":{"character":0,"line":191},"end":{"line":195,"character":9999}},"kind":12},{"children":[{"definition":"my","line":212,"name":"$self","localvar":"my","kind":13,"containerName":"entry"},{"line":212,"name":"$row","containerName":"entry","kind":13},{"kind":13,"containerName":"entry","name":"$column","line":212},{"line":212,"kind":13,"containerName":"entry","name":"$newvalue"},{"name":"$row","containerName":"entry","kind":13,"line":213},{"line":213,"kind":13,"containerName":"entry","name":"$column"},{"name":"$self","containerName":"entry","kind":13,"line":214},{"containerName":"entry","kind":12,"name":"throw","line":214},{"definition":"my","line":217,"kind":13,"localvar":"my","containerName":"entry","name":"$rownum"},{"containerName":"entry","kind":13,"name":"$self","line":217},{"name":"row_num_for_name","kind":12,"containerName":"entry","line":217},{"kind":13,"containerName":"entry","name":"$row","line":217},{"definition":"my","line":218,"name":"$colnum","containerName":"entry","localvar":"my","kind":13},{"kind":13,"containerName":"entry","name":"$self","line":218},{"name":"column_num_for_name","kind":12,"containerName":"entry","line":218},{"containerName":"entry","kind":13,"name":"$column","line":218},{"containerName":"entry","kind":13,"name":"$self","line":219},{"line":219,"name":"entry_by_num","kind":12,"containerName":"entry"},{"containerName":"entry","kind":13,"name":"$rownum","line":219},{"name":"$colnum","containerName":"entry","kind":13,"line":219},{"line":219,"name":"$newvalue","containerName":"entry","kind":13}],"containerName":"main::","name":"entry","definition":"sub","detail":"($self,$row,$column,$newvalue)","line":211,"range":{"end":{"character":9999,"line":220},"start":{"character":0,"line":211}},"kind":12,"signature":{"label":"entry($self,$row,$column,$newvalue)","parameters":[{"label":"$self"},{"label":"$row"},{"label":"$column"},{"label":"$newvalue"}],"documentation":"1;\n# $Id: Generic.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Matrix::Generic\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::Generic - A generic matrix implementation\n\n=head1 SYNOPSIS\n\n  # A matrix has columns and rows \n  my $matrix = Bio::Matrix::Generic->new;\n  $matrix->add_column(1,$column1);\n  $matrix->add_column(2,$column2);\n\n  my $element = $matrix->entry_by_num(1,2);\n  $matrix->entry_by_num(1,2,$newval);\n\n  my $entry = $matrix->entry('human', 'mouse');\n\n  $matrix->entry('human','mouse', $newval);\n\n\n=head1 DESCRIPTION\n\nThis is a general purpose matrix object for dealing with row+column\ndata which is typical when enumerating all the pairwise combinations\nand desiring to get slices of the data.\n\nData can be accessed by column and row names or indexes.  Matrix\nindexes start at 0.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Matrix::Generic;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Matrix::MatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Matrix::Generic->new();\n Function: Builds a new Bio::Matrix::Generic object \n Returns : an instance of Bio::Matrix::Generic\n Args    : -values     => arrayref of arrayrefs of data initialization \n           -rownames   => arrayref of row names\n           -colnames   => arrayref of col names\n           -matrix_id  => id of the matrix\n           -matrix_name=> name of the matrix\n           -matrix_init_value => default value to initialize empty cells\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($values, $rownames, $colnames,\n      $id,$name,$init_val) = \n\t  $self->_rearrange([qw(VALUES ROWNAMES COLNAMES \n\t\t\t        MATRIX_ID MATRIX_NAME \n                                MATRIX_INIT_VALUE)],@args);\n  $self->matrix_id($id) if  defined $id;\n  $self->matrix_name($name) if defined $name;\n  if( defined $rownames && defined $colnames ) {\n      if( ref($rownames) !~ /ARRAY/i ) {\n\t  $self->throw(\"need an arrayref for the -rownames option\");\n      }\n      # insure we copy the values\n      $self->{'_rownames'} = [ @$rownames ];\n      my $count = 0;\n      %{$self->{'_rownamesmap'}} = map { $_ => $count++ } @$rownames; \n\n      if( ref($colnames) !~ /ARRAY/i ) {\n\t  $self->throw(\"need an arrayref for the -colnames option\");\n      }\n      # insure we copy the values\n      $self->{'_colnames'} = [ @$colnames ];\n      $count = 0;\n      %{$self->{'_colnamesmap'}} = map { $_ => $count++ } @$colnames; \n\n      $self->{'_values'} = [];\n      if( defined $values ) {\n\t  if( ref($values) !~ /ARRAY/i ) {\n\t      $self->throw(\"Need an arrayref of arrayrefs (matrix) for -values option\");\n\t  }\t  \n\t  for my $v ( @$values ) {\n\t      if( ref($v) !~ /ARRAY/i ) {\n\t\t  $self->throw(\"Need and array of arrayrefs (matrix) for -values option\");\n\t      }\n\t      push @{$self->{'_values'}}, [@$v];\n\t  }\n      } else {\n\t  my @fill = ($init_val) x scalar @$colnames; # undef init_val will be default\n\t  for ( @$rownames ) {\n\t      push @{$self->{'_values'}}, [@fill];\n\t  }\n      }\n  } elsif( ! defined $rownames && ! defined $colnames && ! defined $values ) {\n      $self->{'_values'}   = [];\n      $self->{'_rownames'} = [];\n      $self->{'_colnames'} = [];\n  } else { \n      $self->throw(\"Must have either provided no values/colnames/rownames or provided all three\");\n  }\n\n  return $self;\n}\n\n\n=head2 matrix_id\n\n Title   : matrix_id\n Usage   : my $id = $matrix->matrix_id\n Function: Get/Set the matrix ID\n Returns : scalar value\n Args    : [optional] new id value to store\n\n\n\nsub matrix_id{\n   my $self = shift;\n   return $self->{'_matid'} = shift if @_;\n   return $self->{'_matid'};\n\n   \n}\n\n=head2 matrix_name\n\n Title   : matrix_name\n Usage   : my $name = $matrix->matrix_name();\n Function: Get/Set the matrix name\n Returns : scalar value\n Args    : [optional] new matrix name value\n\n\n\nsub matrix_name{\n   my $self = shift;\n   return $self->{'_matname'} = shift if @_;\n   return $self->{'_matname'};\n}\n\n\n=head2 entry\n\n Title   : entry\n Usage   : my $entry = $matrix->entry($row,$col)\n Function: Get the value for a specific cell as specified\n           by the row and column names\n Returns : scalar value or undef if row or col does not\n           exist\n Args    : $rowname - name of the row\n           $colname - column name"}},{"containerName":"main::","name":"get_entry","children":[{"line":234,"kind":12,"containerName":"get_entry","name":"entry"}],"definition":"sub","range":{"end":{"character":9999,"line":234},"start":{"character":0,"line":234}},"kind":12,"line":234},{"signature":{"documentation":"1;\n# $Id: Generic.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Matrix::Generic\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::Generic - A generic matrix implementation\n\n=head1 SYNOPSIS\n\n  # A matrix has columns and rows \n  my $matrix = Bio::Matrix::Generic->new;\n  $matrix->add_column(1,$column1);\n  $matrix->add_column(2,$column2);\n\n  my $element = $matrix->entry_by_num(1,2);\n  $matrix->entry_by_num(1,2,$newval);\n\n  my $entry = $matrix->entry('human', 'mouse');\n\n  $matrix->entry('human','mouse', $newval);\n\n\n=head1 DESCRIPTION\n\nThis is a general purpose matrix object for dealing with row+column\ndata which is typical when enumerating all the pairwise combinations\nand desiring to get slices of the data.\n\nData can be accessed by column and row names or indexes.  Matrix\nindexes start at 0.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Matrix::Generic;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Matrix::MatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Matrix::Generic->new();\n Function: Builds a new Bio::Matrix::Generic object \n Returns : an instance of Bio::Matrix::Generic\n Args    : -values     => arrayref of arrayrefs of data initialization \n           -rownames   => arrayref of row names\n           -colnames   => arrayref of col names\n           -matrix_id  => id of the matrix\n           -matrix_name=> name of the matrix\n           -matrix_init_value => default value to initialize empty cells\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($values, $rownames, $colnames,\n      $id,$name,$init_val) = \n\t  $self->_rearrange([qw(VALUES ROWNAMES COLNAMES \n\t\t\t        MATRIX_ID MATRIX_NAME \n                                MATRIX_INIT_VALUE)],@args);\n  $self->matrix_id($id) if  defined $id;\n  $self->matrix_name($name) if defined $name;\n  if( defined $rownames && defined $colnames ) {\n      if( ref($rownames) !~ /ARRAY/i ) {\n\t  $self->throw(\"need an arrayref for the -rownames option\");\n      }\n      # insure we copy the values\n      $self->{'_rownames'} = [ @$rownames ];\n      my $count = 0;\n      %{$self->{'_rownamesmap'}} = map { $_ => $count++ } @$rownames; \n\n      if( ref($colnames) !~ /ARRAY/i ) {\n\t  $self->throw(\"need an arrayref for the -colnames option\");\n      }\n      # insure we copy the values\n      $self->{'_colnames'} = [ @$colnames ];\n      $count = 0;\n      %{$self->{'_colnamesmap'}} = map { $_ => $count++ } @$colnames; \n\n      $self->{'_values'} = [];\n      if( defined $values ) {\n\t  if( ref($values) !~ /ARRAY/i ) {\n\t      $self->throw(\"Need an arrayref of arrayrefs (matrix) for -values option\");\n\t  }\t  \n\t  for my $v ( @$values ) {\n\t      if( ref($v) !~ /ARRAY/i ) {\n\t\t  $self->throw(\"Need and array of arrayrefs (matrix) for -values option\");\n\t      }\n\t      push @{$self->{'_values'}}, [@$v];\n\t  }\n      } else {\n\t  my @fill = ($init_val) x scalar @$colnames; # undef init_val will be default\n\t  for ( @$rownames ) {\n\t      push @{$self->{'_values'}}, [@fill];\n\t  }\n      }\n  } elsif( ! defined $rownames && ! defined $colnames && ! defined $values ) {\n      $self->{'_values'}   = [];\n      $self->{'_rownames'} = [];\n      $self->{'_colnames'} = [];\n  } else { \n      $self->throw(\"Must have either provided no values/colnames/rownames or provided all three\");\n  }\n\n  return $self;\n}\n\n\n=head2 matrix_id\n\n Title   : matrix_id\n Usage   : my $id = $matrix->matrix_id\n Function: Get/Set the matrix ID\n Returns : scalar value\n Args    : [optional] new id value to store\n\n\n\nsub matrix_id{\n   my $self = shift;\n   return $self->{'_matid'} = shift if @_;\n   return $self->{'_matid'};\n\n   \n}\n\n=head2 matrix_name\n\n Title   : matrix_name\n Usage   : my $name = $matrix->matrix_name();\n Function: Get/Set the matrix name\n Returns : scalar value\n Args    : [optional] new matrix name value\n\n\n\nsub matrix_name{\n   my $self = shift;\n   return $self->{'_matname'} = shift if @_;\n   return $self->{'_matname'};\n}\n\n\n=head2 entry\n\n Title   : entry\n Usage   : my $entry = $matrix->entry($row,$col)\n Function: Get the value for a specific cell as specified\n           by the row and column names\n Returns : scalar value or undef if row or col does not\n           exist\n Args    : $rowname - name of the row\n           $colname - column name\n\n\nsub entry{\n   my ($self,$row,$column,$newvalue) = @_;\n   if( ! defined $row || ! defined $column ) {\n       $self->throw(\"Need at least 2 ids\");\n   }\n\n   my ($rownum) = $self->row_num_for_name($row);\n   my ($colnum) = $self->column_num_for_name($column);\n   return $self->entry_by_num($rownum,$colnum,$newvalue);\n}\n\n=head2 get_entry\n\n Title   : get_entry\n Usage   : my $entry = $matrix->get_entry($rowname,$columname)\n Function: Get the entry for a given row,column pair\n Returns : scalar\n Args    : $row name\n           $column name \n\n\n\nsub get_entry{ $_[0]->entry($_[1],$_[2]) }\n\n=head2 entry_by_num\n\n Title   : entry_by_num\n Usage   : my $entry = $matrix->entry_by_num($rownum,$colnum)\n Function: Get an entry by row and column numbers instead of by name\n           (rows and columns start at 0)\n Returns : scalar value or undef if row or column name does not\n           exist\n Args    : $row - row number\n           $col - column number\n           [optional] $newvalue to store at this cell","parameters":[{"label":"$self"},{"label":"$row"},{"label":"$col"},{"label":"$newvalue"}],"label":"entry_by_num($self,$row,$col,$newvalue)"},"line":250,"kind":12,"range":{"end":{"character":9999,"line":264},"start":{"line":250,"character":0}},"definition":"sub","detail":"($self,$row,$col,$newvalue)","children":[{"definition":"my","line":251,"localvar":"my","containerName":"entry_by_num","kind":13,"name":"$self"},{"line":251,"containerName":"entry_by_num","kind":13,"name":"$row"},{"line":251,"name":"$col","kind":13,"containerName":"entry_by_num"},{"line":251,"name":"$newvalue","kind":13,"containerName":"entry_by_num"},{"line":252,"name":"$row","kind":13,"containerName":"entry_by_num"},{"line":252,"name":"$col","kind":13,"containerName":"entry_by_num"},{"name":"$row","containerName":"entry_by_num","kind":13,"line":253},{"line":254,"name":"$col","kind":13,"containerName":"entry_by_num"},{"line":255,"kind":13,"containerName":"entry_by_num","name":"$self"},{"kind":12,"containerName":"entry_by_num","name":"warn","line":255},{"kind":13,"containerName":"entry_by_num","name":"$newvalue","line":259},{"line":260,"name":"$self","kind":13,"containerName":"entry_by_num"},{"kind":12,"containerName":"entry_by_num","name":"_values","line":260},{"kind":13,"containerName":"entry_by_num","name":"$row","line":260},{"line":260,"name":"$col","kind":13,"containerName":"entry_by_num"},{"name":"$newvalue","containerName":"entry_by_num","kind":13,"line":260},{"line":262,"kind":13,"containerName":"entry_by_num","name":"$self"},{"line":262,"containerName":"entry_by_num","kind":12,"name":"_values"},{"line":262,"kind":13,"containerName":"entry_by_num","name":"$row"},{"containerName":"entry_by_num","kind":13,"name":"$col","line":262}],"name":"entry_by_num","containerName":"main::"},{"line":266,"kind":12,"range":{"start":{"character":0,"line":266},"end":{"character":9999,"line":269}},"children":[{"definition":"my","line":267,"kind":13,"localvar":"my","containerName":"get_element","name":"$self"},{"kind":13,"containerName":"get_element","name":"$self","line":268},{"line":268,"name":"entry","kind":12,"containerName":"get_element"}],"name":"get_element","containerName":"main::","definition":"sub"},{"definition":"sub","detail":"($self,$column,$newcol)","children":[{"definition":"my","line":289,"name":"$self","kind":13,"localvar":"my","containerName":"column"},{"line":289,"kind":13,"containerName":"column","name":"$column"},{"line":289,"kind":13,"containerName":"column","name":"$newcol"},{"kind":13,"containerName":"column","name":"$column","line":291},{"name":"$self","kind":13,"containerName":"column","line":292},{"line":292,"name":"warn","kind":12,"containerName":"column"},{"line":295,"localvar":"my","containerName":"column","kind":13,"name":"$colnum","definition":"my"},{"line":295,"containerName":"column","kind":13,"name":"$self"},{"name":"column_num_for_name","containerName":"column","kind":12,"line":295},{"name":"$column","kind":13,"containerName":"column","line":295},{"containerName":"column","kind":13,"name":"$colnum","line":296},{"line":297,"containerName":"column","kind":13,"name":"$self"},{"name":"warn","kind":12,"containerName":"column","line":297},{"kind":13,"containerName":"column","name":"$self","line":300},{"line":300,"containerName":"column","kind":12,"name":"column_by_num"},{"name":"$colnum","kind":13,"containerName":"column","line":300},{"name":"$newcol","containerName":"column","kind":13,"line":300}],"name":"column","containerName":"main::","signature":{"documentation":"1;\n# $Id: Generic.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Matrix::Generic\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::Generic - A generic matrix implementation\n\n=head1 SYNOPSIS\n\n  # A matrix has columns and rows \n  my $matrix = Bio::Matrix::Generic->new;\n  $matrix->add_column(1,$column1);\n  $matrix->add_column(2,$column2);\n\n  my $element = $matrix->entry_by_num(1,2);\n  $matrix->entry_by_num(1,2,$newval);\n\n  my $entry = $matrix->entry('human', 'mouse');\n\n  $matrix->entry('human','mouse', $newval);\n\n\n=head1 DESCRIPTION\n\nThis is a general purpose matrix object for dealing with row+column\ndata which is typical when enumerating all the pairwise combinations\nand desiring to get slices of the data.\n\nData can be accessed by column and row names or indexes.  Matrix\nindexes start at 0.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Matrix::Generic;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Matrix::MatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Matrix::Generic->new();\n Function: Builds a new Bio::Matrix::Generic object \n Returns : an instance of Bio::Matrix::Generic\n Args    : -values     => arrayref of arrayrefs of data initialization \n           -rownames   => arrayref of row names\n           -colnames   => arrayref of col names\n           -matrix_id  => id of the matrix\n           -matrix_name=> name of the matrix\n           -matrix_init_value => default value to initialize empty cells\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($values, $rownames, $colnames,\n      $id,$name,$init_val) = \n\t  $self->_rearrange([qw(VALUES ROWNAMES COLNAMES \n\t\t\t        MATRIX_ID MATRIX_NAME \n                                MATRIX_INIT_VALUE)],@args);\n  $self->matrix_id($id) if  defined $id;\n  $self->matrix_name($name) if defined $name;\n  if( defined $rownames && defined $colnames ) {\n      if( ref($rownames) !~ /ARRAY/i ) {\n\t  $self->throw(\"need an arrayref for the -rownames option\");\n      }\n      # insure we copy the values\n      $self->{'_rownames'} = [ @$rownames ];\n      my $count = 0;\n      %{$self->{'_rownamesmap'}} = map { $_ => $count++ } @$rownames; \n\n      if( ref($colnames) !~ /ARRAY/i ) {\n\t  $self->throw(\"need an arrayref for the -colnames option\");\n      }\n      # insure we copy the values\n      $self->{'_colnames'} = [ @$colnames ];\n      $count = 0;\n      %{$self->{'_colnamesmap'}} = map { $_ => $count++ } @$colnames; \n\n      $self->{'_values'} = [];\n      if( defined $values ) {\n\t  if( ref($values) !~ /ARRAY/i ) {\n\t      $self->throw(\"Need an arrayref of arrayrefs (matrix) for -values option\");\n\t  }\t  \n\t  for my $v ( @$values ) {\n\t      if( ref($v) !~ /ARRAY/i ) {\n\t\t  $self->throw(\"Need and array of arrayrefs (matrix) for -values option\");\n\t      }\n\t      push @{$self->{'_values'}}, [@$v];\n\t  }\n      } else {\n\t  my @fill = ($init_val) x scalar @$colnames; # undef init_val will be default\n\t  for ( @$rownames ) {\n\t      push @{$self->{'_values'}}, [@fill];\n\t  }\n      }\n  } elsif( ! defined $rownames && ! defined $colnames && ! defined $values ) {\n      $self->{'_values'}   = [];\n      $self->{'_rownames'} = [];\n      $self->{'_colnames'} = [];\n  } else { \n      $self->throw(\"Must have either provided no values/colnames/rownames or provided all three\");\n  }\n\n  return $self;\n}\n\n\n=head2 matrix_id\n\n Title   : matrix_id\n Usage   : my $id = $matrix->matrix_id\n Function: Get/Set the matrix ID\n Returns : scalar value\n Args    : [optional] new id value to store\n\n\n\nsub matrix_id{\n   my $self = shift;\n   return $self->{'_matid'} = shift if @_;\n   return $self->{'_matid'};\n\n   \n}\n\n=head2 matrix_name\n\n Title   : matrix_name\n Usage   : my $name = $matrix->matrix_name();\n Function: Get/Set the matrix name\n Returns : scalar value\n Args    : [optional] new matrix name value\n\n\n\nsub matrix_name{\n   my $self = shift;\n   return $self->{'_matname'} = shift if @_;\n   return $self->{'_matname'};\n}\n\n\n=head2 entry\n\n Title   : entry\n Usage   : my $entry = $matrix->entry($row,$col)\n Function: Get the value for a specific cell as specified\n           by the row and column names\n Returns : scalar value or undef if row or col does not\n           exist\n Args    : $rowname - name of the row\n           $colname - column name\n\n\nsub entry{\n   my ($self,$row,$column,$newvalue) = @_;\n   if( ! defined $row || ! defined $column ) {\n       $self->throw(\"Need at least 2 ids\");\n   }\n\n   my ($rownum) = $self->row_num_for_name($row);\n   my ($colnum) = $self->column_num_for_name($column);\n   return $self->entry_by_num($rownum,$colnum,$newvalue);\n}\n\n=head2 get_entry\n\n Title   : get_entry\n Usage   : my $entry = $matrix->get_entry($rowname,$columname)\n Function: Get the entry for a given row,column pair\n Returns : scalar\n Args    : $row name\n           $column name \n\n\n\nsub get_entry{ $_[0]->entry($_[1],$_[2]) }\n\n=head2 entry_by_num\n\n Title   : entry_by_num\n Usage   : my $entry = $matrix->entry_by_num($rownum,$colnum)\n Function: Get an entry by row and column numbers instead of by name\n           (rows and columns start at 0)\n Returns : scalar value or undef if row or column name does not\n           exist\n Args    : $row - row number\n           $col - column number\n           [optional] $newvalue to store at this cell\n\n\nsub entry_by_num {\n    my ($self,$row,$col,$newvalue) = @_;\n    if( ! defined $row || ! defined $col || \n\t$row !~ /^\\d+$/ ||\n\t$col !~ /^\\d+$/ ) {\n\t$self->warn(\"expected to get 2 number for entry_by_num\");\n\treturn;\n    }\n    \n    if( defined $newvalue ) {\n       return $self->_values->[$row][$col] = $newvalue;\n   } else { \n       return $self->_values->[$row][$col];\n   }\n}\n\nsub get_element { \n    my $self = shift;\n    $self->entry(@_);\n}\n\n\n=head2 column\n\n Title   : column\n Usage   : my @col = $matrix->column('ALPHA');\n           OR\n           $matrix->column('ALPHA', \\@col);\n Function: Get/Set a particular column\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values.  \n           For setting will warn if the new column is of a different\n           length from the rest of the columns.\n Args    : name of the column\n           [optional] new column to store here ","parameters":[{"label":"$self"},{"label":"$column"},{"label":"$newcol"}],"label":"column($self,$column,$newcol)"},"line":288,"range":{"end":{"character":9999,"line":301},"start":{"line":288,"character":0}},"kind":12},{"containerName":"main::","name":"get_column","children":[{"containerName":"get_column","kind":12,"name":"column","line":316}],"definition":"sub","kind":12,"range":{"start":{"line":316,"character":0},"end":{"line":316,"character":9999}},"line":316},{"containerName":"main::","name":"column_by_num","children":[{"definition":"my","line":335,"name":"$self","localvar":"my","containerName":"column_by_num","kind":13},{"containerName":"column_by_num","kind":13,"name":"$colnum","line":335},{"line":335,"name":"$newcol","kind":13,"containerName":"column_by_num"},{"line":336,"kind":13,"containerName":"column_by_num","name":"$colnum"},{"line":337,"name":"$self","kind":13,"containerName":"column_by_num"},{"name":"warn","containerName":"column_by_num","kind":12,"line":337},{"definition":"my","kind":13,"localvar":"my","containerName":"column_by_num","name":"$rowcount","line":340},{"name":"$self","containerName":"column_by_num","kind":13,"line":340},{"name":"num_rows","kind":12,"containerName":"column_by_num","line":340},{"definition":"my","line":341,"containerName":"column_by_num","localvar":"my","kind":13,"name":"$colcount"},{"name":"$self","kind":13,"containerName":"column_by_num","line":341},{"kind":12,"containerName":"column_by_num","name":"num_columns","line":341},{"name":"$ret","containerName":"column_by_num","localvar":"my","kind":13,"line":342,"definition":"my"},{"line":344,"kind":13,"containerName":"column_by_num","name":"$newcol"},{"line":345,"containerName":"column_by_num","kind":13,"name":"$newcol"},{"line":346,"containerName":"column_by_num","kind":13,"name":"$self"},{"line":346,"name":"warn","kind":12,"containerName":"column_by_num"},{"name":"$newcol","kind":13,"containerName":"column_by_num","line":349},{"containerName":"column_by_num","kind":13,"name":"$rowcount","line":349},{"name":"$self","kind":13,"containerName":"column_by_num","line":350},{"name":"warn","containerName":"column_by_num","kind":12,"line":350},{"line":353,"localvar":"my","containerName":"column_by_num","kind":13,"name":"$i","definition":"my"},{"name":"$i","kind":13,"containerName":"column_by_num","line":353},{"line":353,"name":"$rowcount","containerName":"column_by_num","kind":13},{"containerName":"column_by_num","kind":13,"name":"$i","line":353},{"name":"$self","kind":13,"containerName":"column_by_num","line":354},{"name":"entry_by_num","containerName":"column_by_num","kind":12,"line":354},{"kind":13,"containerName":"column_by_num","name":"$i","line":354},{"line":354,"name":"$colnum","containerName":"column_by_num","kind":13},{"name":"$newcol","containerName":"column_by_num","kind":13,"line":354},{"name":"$i","kind":13,"containerName":"column_by_num","line":354},{"line":356,"name":"$ret","containerName":"column_by_num","kind":13},{"name":"$newcol","kind":13,"containerName":"column_by_num","line":356},{"kind":13,"containerName":"column_by_num","name":"$ret","line":358},{"name":"$i","localvar":"my","kind":13,"containerName":"column_by_num","line":359,"definition":"my"},{"name":"$i","containerName":"column_by_num","kind":13,"line":359},{"name":"$rowcount","kind":13,"containerName":"column_by_num","line":359},{"name":"$i","containerName":"column_by_num","kind":13,"line":359},{"line":360,"name":"$ret","containerName":"column_by_num","kind":13},{"line":360,"kind":13,"containerName":"column_by_num","name":"$self"},{"line":360,"name":"entry_by_num","containerName":"column_by_num","kind":12},{"kind":13,"containerName":"column_by_num","name":"$i","line":360},{"containerName":"column_by_num","kind":13,"name":"$colnum","line":360},{"line":363,"containerName":"column_by_num","kind":13,"name":"$ret"},{"line":364,"name":"$ret","kind":13,"containerName":"column_by_num"}],"detail":"($self,$colnum,$newcol)","definition":"sub","range":{"end":{"character":9999,"line":366},"start":{"line":334,"character":0}},"kind":12,"line":334,"signature":{"label":"column_by_num($self,$colnum,$newcol)","parameters":[{"label":"$self"},{"label":"$colnum"},{"label":"$newcol"}],"documentation":"1;\n# $Id: Generic.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Matrix::Generic\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::Generic - A generic matrix implementation\n\n=head1 SYNOPSIS\n\n  # A matrix has columns and rows \n  my $matrix = Bio::Matrix::Generic->new;\n  $matrix->add_column(1,$column1);\n  $matrix->add_column(2,$column2);\n\n  my $element = $matrix->entry_by_num(1,2);\n  $matrix->entry_by_num(1,2,$newval);\n\n  my $entry = $matrix->entry('human', 'mouse');\n\n  $matrix->entry('human','mouse', $newval);\n\n\n=head1 DESCRIPTION\n\nThis is a general purpose matrix object for dealing with row+column\ndata which is typical when enumerating all the pairwise combinations\nand desiring to get slices of the data.\n\nData can be accessed by column and row names or indexes.  Matrix\nindexes start at 0.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Matrix::Generic;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Matrix::MatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Matrix::Generic->new();\n Function: Builds a new Bio::Matrix::Generic object \n Returns : an instance of Bio::Matrix::Generic\n Args    : -values     => arrayref of arrayrefs of data initialization \n           -rownames   => arrayref of row names\n           -colnames   => arrayref of col names\n           -matrix_id  => id of the matrix\n           -matrix_name=> name of the matrix\n           -matrix_init_value => default value to initialize empty cells\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($values, $rownames, $colnames,\n      $id,$name,$init_val) = \n\t  $self->_rearrange([qw(VALUES ROWNAMES COLNAMES \n\t\t\t        MATRIX_ID MATRIX_NAME \n                                MATRIX_INIT_VALUE)],@args);\n  $self->matrix_id($id) if  defined $id;\n  $self->matrix_name($name) if defined $name;\n  if( defined $rownames && defined $colnames ) {\n      if( ref($rownames) !~ /ARRAY/i ) {\n\t  $self->throw(\"need an arrayref for the -rownames option\");\n      }\n      # insure we copy the values\n      $self->{'_rownames'} = [ @$rownames ];\n      my $count = 0;\n      %{$self->{'_rownamesmap'}} = map { $_ => $count++ } @$rownames; \n\n      if( ref($colnames) !~ /ARRAY/i ) {\n\t  $self->throw(\"need an arrayref for the -colnames option\");\n      }\n      # insure we copy the values\n      $self->{'_colnames'} = [ @$colnames ];\n      $count = 0;\n      %{$self->{'_colnamesmap'}} = map { $_ => $count++ } @$colnames; \n\n      $self->{'_values'} = [];\n      if( defined $values ) {\n\t  if( ref($values) !~ /ARRAY/i ) {\n\t      $self->throw(\"Need an arrayref of arrayrefs (matrix) for -values option\");\n\t  }\t  \n\t  for my $v ( @$values ) {\n\t      if( ref($v) !~ /ARRAY/i ) {\n\t\t  $self->throw(\"Need and array of arrayrefs (matrix) for -values option\");\n\t      }\n\t      push @{$self->{'_values'}}, [@$v];\n\t  }\n      } else {\n\t  my @fill = ($init_val) x scalar @$colnames; # undef init_val will be default\n\t  for ( @$rownames ) {\n\t      push @{$self->{'_values'}}, [@fill];\n\t  }\n      }\n  } elsif( ! defined $rownames && ! defined $colnames && ! defined $values ) {\n      $self->{'_values'}   = [];\n      $self->{'_rownames'} = [];\n      $self->{'_colnames'} = [];\n  } else { \n      $self->throw(\"Must have either provided no values/colnames/rownames or provided all three\");\n  }\n\n  return $self;\n}\n\n\n=head2 matrix_id\n\n Title   : matrix_id\n Usage   : my $id = $matrix->matrix_id\n Function: Get/Set the matrix ID\n Returns : scalar value\n Args    : [optional] new id value to store\n\n\n\nsub matrix_id{\n   my $self = shift;\n   return $self->{'_matid'} = shift if @_;\n   return $self->{'_matid'};\n\n   \n}\n\n=head2 matrix_name\n\n Title   : matrix_name\n Usage   : my $name = $matrix->matrix_name();\n Function: Get/Set the matrix name\n Returns : scalar value\n Args    : [optional] new matrix name value\n\n\n\nsub matrix_name{\n   my $self = shift;\n   return $self->{'_matname'} = shift if @_;\n   return $self->{'_matname'};\n}\n\n\n=head2 entry\n\n Title   : entry\n Usage   : my $entry = $matrix->entry($row,$col)\n Function: Get the value for a specific cell as specified\n           by the row and column names\n Returns : scalar value or undef if row or col does not\n           exist\n Args    : $rowname - name of the row\n           $colname - column name\n\n\nsub entry{\n   my ($self,$row,$column,$newvalue) = @_;\n   if( ! defined $row || ! defined $column ) {\n       $self->throw(\"Need at least 2 ids\");\n   }\n\n   my ($rownum) = $self->row_num_for_name($row);\n   my ($colnum) = $self->column_num_for_name($column);\n   return $self->entry_by_num($rownum,$colnum,$newvalue);\n}\n\n=head2 get_entry\n\n Title   : get_entry\n Usage   : my $entry = $matrix->get_entry($rowname,$columname)\n Function: Get the entry for a given row,column pair\n Returns : scalar\n Args    : $row name\n           $column name \n\n\n\nsub get_entry{ $_[0]->entry($_[1],$_[2]) }\n\n=head2 entry_by_num\n\n Title   : entry_by_num\n Usage   : my $entry = $matrix->entry_by_num($rownum,$colnum)\n Function: Get an entry by row and column numbers instead of by name\n           (rows and columns start at 0)\n Returns : scalar value or undef if row or column name does not\n           exist\n Args    : $row - row number\n           $col - column number\n           [optional] $newvalue to store at this cell\n\n\nsub entry_by_num {\n    my ($self,$row,$col,$newvalue) = @_;\n    if( ! defined $row || ! defined $col || \n\t$row !~ /^\\d+$/ ||\n\t$col !~ /^\\d+$/ ) {\n\t$self->warn(\"expected to get 2 number for entry_by_num\");\n\treturn;\n    }\n    \n    if( defined $newvalue ) {\n       return $self->_values->[$row][$col] = $newvalue;\n   } else { \n       return $self->_values->[$row][$col];\n   }\n}\n\nsub get_element { \n    my $self = shift;\n    $self->entry(@_);\n}\n\n\n=head2 column\n\n Title   : column\n Usage   : my @col = $matrix->column('ALPHA');\n           OR\n           $matrix->column('ALPHA', \\@col);\n Function: Get/Set a particular column\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values.  \n           For setting will warn if the new column is of a different\n           length from the rest of the columns.\n Args    : name of the column\n           [optional] new column to store here \n\n\nsub column{\n    my ($self,$column,$newcol) = @_;\n\n    if( ! defined $column ) {\n\t$self->warn(\"Need at least a column id\");\n\treturn;\n    }\n    my $colnum  = $self->column_num_for_name($column);\n    if( ! defined $colnum ) { \n\t$self->warn(\"could not find column number for $column\");\n\treturn;\n    }\n    return $self->column_by_num($colnum,$newcol);\n}\n\n\n=head2 get_column\n\n Title   : get_column\n Usage   : my @row = $matrix->get_column('ALPHA');\n Function: Get a particular column\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the column\n\n\n\nsub get_column { $_[0]->column($_[1]) }\n\n\n=head2 column_by_num\n\n Title   : column_by_num\n Usage   : my @col = $matrix->column_by_num(1);\n           OR\n           $matrix->column_by_num(1,\\@newcol);\n Function: Get/Set a column by its number instead of name\n           (cols/rows start at 0)\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the column\n           [optional] new value to store for a particular column"}},{"signature":{"label":"row($self,$row,$newrow)","parameters":[{"label":"$self"},{"label":"$row"},{"label":"$newrow"}],"documentation":"1;\n# $Id: Generic.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Matrix::Generic\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::Generic - A generic matrix implementation\n\n=head1 SYNOPSIS\n\n  # A matrix has columns and rows \n  my $matrix = Bio::Matrix::Generic->new;\n  $matrix->add_column(1,$column1);\n  $matrix->add_column(2,$column2);\n\n  my $element = $matrix->entry_by_num(1,2);\n  $matrix->entry_by_num(1,2,$newval);\n\n  my $entry = $matrix->entry('human', 'mouse');\n\n  $matrix->entry('human','mouse', $newval);\n\n\n=head1 DESCRIPTION\n\nThis is a general purpose matrix object for dealing with row+column\ndata which is typical when enumerating all the pairwise combinations\nand desiring to get slices of the data.\n\nData can be accessed by column and row names or indexes.  Matrix\nindexes start at 0.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Matrix::Generic;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Matrix::MatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Matrix::Generic->new();\n Function: Builds a new Bio::Matrix::Generic object \n Returns : an instance of Bio::Matrix::Generic\n Args    : -values     => arrayref of arrayrefs of data initialization \n           -rownames   => arrayref of row names\n           -colnames   => arrayref of col names\n           -matrix_id  => id of the matrix\n           -matrix_name=> name of the matrix\n           -matrix_init_value => default value to initialize empty cells\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($values, $rownames, $colnames,\n      $id,$name,$init_val) = \n\t  $self->_rearrange([qw(VALUES ROWNAMES COLNAMES \n\t\t\t        MATRIX_ID MATRIX_NAME \n                                MATRIX_INIT_VALUE)],@args);\n  $self->matrix_id($id) if  defined $id;\n  $self->matrix_name($name) if defined $name;\n  if( defined $rownames && defined $colnames ) {\n      if( ref($rownames) !~ /ARRAY/i ) {\n\t  $self->throw(\"need an arrayref for the -rownames option\");\n      }\n      # insure we copy the values\n      $self->{'_rownames'} = [ @$rownames ];\n      my $count = 0;\n      %{$self->{'_rownamesmap'}} = map { $_ => $count++ } @$rownames; \n\n      if( ref($colnames) !~ /ARRAY/i ) {\n\t  $self->throw(\"need an arrayref for the -colnames option\");\n      }\n      # insure we copy the values\n      $self->{'_colnames'} = [ @$colnames ];\n      $count = 0;\n      %{$self->{'_colnamesmap'}} = map { $_ => $count++ } @$colnames; \n\n      $self->{'_values'} = [];\n      if( defined $values ) {\n\t  if( ref($values) !~ /ARRAY/i ) {\n\t      $self->throw(\"Need an arrayref of arrayrefs (matrix) for -values option\");\n\t  }\t  \n\t  for my $v ( @$values ) {\n\t      if( ref($v) !~ /ARRAY/i ) {\n\t\t  $self->throw(\"Need and array of arrayrefs (matrix) for -values option\");\n\t      }\n\t      push @{$self->{'_values'}}, [@$v];\n\t  }\n      } else {\n\t  my @fill = ($init_val) x scalar @$colnames; # undef init_val will be default\n\t  for ( @$rownames ) {\n\t      push @{$self->{'_values'}}, [@fill];\n\t  }\n      }\n  } elsif( ! defined $rownames && ! defined $colnames && ! defined $values ) {\n      $self->{'_values'}   = [];\n      $self->{'_rownames'} = [];\n      $self->{'_colnames'} = [];\n  } else { \n      $self->throw(\"Must have either provided no values/colnames/rownames or provided all three\");\n  }\n\n  return $self;\n}\n\n\n=head2 matrix_id\n\n Title   : matrix_id\n Usage   : my $id = $matrix->matrix_id\n Function: Get/Set the matrix ID\n Returns : scalar value\n Args    : [optional] new id value to store\n\n\n\nsub matrix_id{\n   my $self = shift;\n   return $self->{'_matid'} = shift if @_;\n   return $self->{'_matid'};\n\n   \n}\n\n=head2 matrix_name\n\n Title   : matrix_name\n Usage   : my $name = $matrix->matrix_name();\n Function: Get/Set the matrix name\n Returns : scalar value\n Args    : [optional] new matrix name value\n\n\n\nsub matrix_name{\n   my $self = shift;\n   return $self->{'_matname'} = shift if @_;\n   return $self->{'_matname'};\n}\n\n\n=head2 entry\n\n Title   : entry\n Usage   : my $entry = $matrix->entry($row,$col)\n Function: Get the value for a specific cell as specified\n           by the row and column names\n Returns : scalar value or undef if row or col does not\n           exist\n Args    : $rowname - name of the row\n           $colname - column name\n\n\nsub entry{\n   my ($self,$row,$column,$newvalue) = @_;\n   if( ! defined $row || ! defined $column ) {\n       $self->throw(\"Need at least 2 ids\");\n   }\n\n   my ($rownum) = $self->row_num_for_name($row);\n   my ($colnum) = $self->column_num_for_name($column);\n   return $self->entry_by_num($rownum,$colnum,$newvalue);\n}\n\n=head2 get_entry\n\n Title   : get_entry\n Usage   : my $entry = $matrix->get_entry($rowname,$columname)\n Function: Get the entry for a given row,column pair\n Returns : scalar\n Args    : $row name\n           $column name \n\n\n\nsub get_entry{ $_[0]->entry($_[1],$_[2]) }\n\n=head2 entry_by_num\n\n Title   : entry_by_num\n Usage   : my $entry = $matrix->entry_by_num($rownum,$colnum)\n Function: Get an entry by row and column numbers instead of by name\n           (rows and columns start at 0)\n Returns : scalar value or undef if row or column name does not\n           exist\n Args    : $row - row number\n           $col - column number\n           [optional] $newvalue to store at this cell\n\n\nsub entry_by_num {\n    my ($self,$row,$col,$newvalue) = @_;\n    if( ! defined $row || ! defined $col || \n\t$row !~ /^\\d+$/ ||\n\t$col !~ /^\\d+$/ ) {\n\t$self->warn(\"expected to get 2 number for entry_by_num\");\n\treturn;\n    }\n    \n    if( defined $newvalue ) {\n       return $self->_values->[$row][$col] = $newvalue;\n   } else { \n       return $self->_values->[$row][$col];\n   }\n}\n\nsub get_element { \n    my $self = shift;\n    $self->entry(@_);\n}\n\n\n=head2 column\n\n Title   : column\n Usage   : my @col = $matrix->column('ALPHA');\n           OR\n           $matrix->column('ALPHA', \\@col);\n Function: Get/Set a particular column\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values.  \n           For setting will warn if the new column is of a different\n           length from the rest of the columns.\n Args    : name of the column\n           [optional] new column to store here \n\n\nsub column{\n    my ($self,$column,$newcol) = @_;\n\n    if( ! defined $column ) {\n\t$self->warn(\"Need at least a column id\");\n\treturn;\n    }\n    my $colnum  = $self->column_num_for_name($column);\n    if( ! defined $colnum ) { \n\t$self->warn(\"could not find column number for $column\");\n\treturn;\n    }\n    return $self->column_by_num($colnum,$newcol);\n}\n\n\n=head2 get_column\n\n Title   : get_column\n Usage   : my @row = $matrix->get_column('ALPHA');\n Function: Get a particular column\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the column\n\n\n\nsub get_column { $_[0]->column($_[1]) }\n\n\n=head2 column_by_num\n\n Title   : column_by_num\n Usage   : my @col = $matrix->column_by_num(1);\n           OR\n           $matrix->column_by_num(1,\\@newcol);\n Function: Get/Set a column by its number instead of name\n           (cols/rows start at 0)\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the column\n           [optional] new value to store for a particular column\n\n\nsub column_by_num{\n    my ($self,$colnum,$newcol) = @_;\n    if( ! defined $colnum ) {\n\t$self->warn(\"need at least a column number\");\n\treturn;\n    }\n    my $rowcount = $self->num_rows;\n    my $colcount = $self->num_columns;\n    my $ret;\n    \n    if( defined $newcol ) {\n\tif( ref($newcol) !~ /ARRAY/i) {\n\t    $self->warn(\"expected a valid arrayref for resetting a column\");\n\t    return;\n\t}\n\tif( scalar @$newcol != $rowcount ) {\n\t    $self->warn(\"new column is not the correct length ($rowcount) - call add or remove row to shrink or grow the number of rows first\");\n\t    return;\n\t}\n\tfor(my $i=0; $i < $rowcount; $i++) {\n\t    $self->entry_by_num($i,$colnum,$newcol->[$i]);\n\t}\n\t$ret = $newcol;\n    } else { \n\t$ret = [];\n\tfor(my $i=0; $i < $rowcount; $i++) {\n\t    push @$ret,$self->entry_by_num($i,$colnum);\n\t}\n    }\n    if( wantarray ) { return @$ret } \n    return $ret;\n\n}\n\n=head2 row\n\n Title   : row\n Usage   : my @row = $matrix->row($rowname);\n             OR\n           $matrix->row($rowname,\\@rowvalues);\n Function: Get/Set the row of the matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n Args    : rowname\n           [optional] new value of row to store"},"line":382,"kind":12,"range":{"end":{"character":9999,"line":390},"start":{"character":0,"line":382}},"definition":"sub","detail":"($self,$row,$newrow)","children":[{"line":383,"name":"$self","localvar":"my","kind":13,"containerName":"row","definition":"my"},{"name":"$row","kind":13,"containerName":"row","line":383},{"name":"$newrow","kind":13,"containerName":"row","line":383},{"line":384,"containerName":"row","kind":13,"name":"$row"},{"name":"$self","containerName":"row","kind":13,"line":385},{"line":385,"containerName":"row","kind":12,"name":"warn"},{"line":388,"containerName":"row","localvar":"my","kind":13,"name":"$rownum","definition":"my"},{"line":388,"name":"$self","kind":13,"containerName":"row"},{"name":"row_num_for_name","containerName":"row","kind":12,"line":388},{"line":388,"kind":13,"containerName":"row","name":"$row"},{"kind":13,"containerName":"row","name":"$self","line":389},{"line":389,"containerName":"row","kind":12,"name":"row_by_num"},{"line":389,"name":"$rownum","kind":13,"containerName":"row"},{"name":"$newrow","kind":13,"containerName":"row","line":389}],"containerName":"main::","name":"row"},{"children":[{"line":404,"containerName":"get_row","kind":12,"name":"row"}],"containerName":"main::","name":"get_row","definition":"sub","line":404,"range":{"end":{"line":404,"character":9999},"start":{"character":0,"line":404}},"kind":12},{"definition":"sub","detail":"($self,$rownum,$newrow)","children":[{"name":"$self","localvar":"my","kind":13,"containerName":"row_by_num","line":420,"definition":"my"},{"name":"$rownum","containerName":"row_by_num","kind":13,"line":420},{"name":"$newrow","kind":13,"containerName":"row_by_num","line":420},{"line":421,"kind":13,"containerName":"row_by_num","name":"$rownum"},{"containerName":"row_by_num","kind":13,"name":"$self","line":422},{"line":422,"kind":12,"containerName":"row_by_num","name":"warn"},{"line":425,"localvar":"my","kind":13,"containerName":"row_by_num","name":"$colcount","definition":"my"},{"name":"$self","containerName":"row_by_num","kind":13,"line":425},{"containerName":"row_by_num","kind":12,"name":"num_columns","line":425},{"definition":"my","line":426,"name":"$ret","kind":13,"localvar":"my","containerName":"row_by_num"},{"line":427,"name":"$newrow","containerName":"row_by_num","kind":13},{"line":428,"containerName":"row_by_num","kind":13,"name":"$newrow"},{"line":429,"name":"$self","containerName":"row_by_num","kind":13},{"containerName":"row_by_num","kind":12,"name":"warn","line":429},{"line":432,"name":"$newrow","containerName":"row_by_num","kind":13},{"name":"$colcount","kind":13,"containerName":"row_by_num","line":432},{"line":433,"name":"$self","containerName":"row_by_num","kind":13},{"line":433,"containerName":"row_by_num","kind":12,"name":"warn"},{"containerName":"row_by_num","localvar":"my","kind":13,"name":"$i","line":436,"definition":"my"},{"line":436,"kind":13,"containerName":"row_by_num","name":"$i"},{"name":"$colcount","containerName":"row_by_num","kind":13,"line":436},{"name":"$i","containerName":"row_by_num","kind":13,"line":436},{"kind":13,"containerName":"row_by_num","name":"$self","line":437},{"kind":12,"containerName":"row_by_num","name":"entry_by_num","line":437},{"line":437,"kind":13,"containerName":"row_by_num","name":"$rownum"},{"line":437,"kind":13,"containerName":"row_by_num","name":"$i"},{"containerName":"row_by_num","kind":13,"name":"$newrow","line":437},{"kind":13,"containerName":"row_by_num","name":"$i","line":437},{"name":"$ret","kind":13,"containerName":"row_by_num","line":439},{"name":"$newrow","containerName":"row_by_num","kind":13,"line":439},{"line":441,"kind":13,"containerName":"row_by_num","name":"$ret"},{"definition":"my","containerName":"row_by_num","localvar":"my","kind":13,"name":"$i","line":442},{"line":442,"containerName":"row_by_num","kind":13,"name":"$i"},{"containerName":"row_by_num","kind":13,"name":"$colcount","line":442},{"line":442,"name":"$i","containerName":"row_by_num","kind":13},{"line":445,"name":"$ret","containerName":"row_by_num","kind":13},{"kind":13,"containerName":"row_by_num","name":"$self","line":445},{"line":445,"kind":12,"containerName":"row_by_num","name":"entry_by_num"},{"line":445,"containerName":"row_by_num","kind":13,"name":"$rownum"},{"kind":13,"containerName":"row_by_num","name":"$i","line":445},{"line":448,"name":"$ret","containerName":"row_by_num","kind":13},{"containerName":"row_by_num","kind":13,"name":"$ret","line":449}],"containerName":"main::","name":"row_by_num","signature":{"label":"row_by_num($self,$rownum,$newrow)","parameters":[{"label":"$self"},{"label":"$rownum"},{"label":"$newrow"}],"documentation":"1;\n# $Id: Generic.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Matrix::Generic\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::Generic - A generic matrix implementation\n\n=head1 SYNOPSIS\n\n  # A matrix has columns and rows \n  my $matrix = Bio::Matrix::Generic->new;\n  $matrix->add_column(1,$column1);\n  $matrix->add_column(2,$column2);\n\n  my $element = $matrix->entry_by_num(1,2);\n  $matrix->entry_by_num(1,2,$newval);\n\n  my $entry = $matrix->entry('human', 'mouse');\n\n  $matrix->entry('human','mouse', $newval);\n\n\n=head1 DESCRIPTION\n\nThis is a general purpose matrix object for dealing with row+column\ndata which is typical when enumerating all the pairwise combinations\nand desiring to get slices of the data.\n\nData can be accessed by column and row names or indexes.  Matrix\nindexes start at 0.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Matrix::Generic;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Matrix::MatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Matrix::Generic->new();\n Function: Builds a new Bio::Matrix::Generic object \n Returns : an instance of Bio::Matrix::Generic\n Args    : -values     => arrayref of arrayrefs of data initialization \n           -rownames   => arrayref of row names\n           -colnames   => arrayref of col names\n           -matrix_id  => id of the matrix\n           -matrix_name=> name of the matrix\n           -matrix_init_value => default value to initialize empty cells\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($values, $rownames, $colnames,\n      $id,$name,$init_val) = \n\t  $self->_rearrange([qw(VALUES ROWNAMES COLNAMES \n\t\t\t        MATRIX_ID MATRIX_NAME \n                                MATRIX_INIT_VALUE)],@args);\n  $self->matrix_id($id) if  defined $id;\n  $self->matrix_name($name) if defined $name;\n  if( defined $rownames && defined $colnames ) {\n      if( ref($rownames) !~ /ARRAY/i ) {\n\t  $self->throw(\"need an arrayref for the -rownames option\");\n      }\n      # insure we copy the values\n      $self->{'_rownames'} = [ @$rownames ];\n      my $count = 0;\n      %{$self->{'_rownamesmap'}} = map { $_ => $count++ } @$rownames; \n\n      if( ref($colnames) !~ /ARRAY/i ) {\n\t  $self->throw(\"need an arrayref for the -colnames option\");\n      }\n      # insure we copy the values\n      $self->{'_colnames'} = [ @$colnames ];\n      $count = 0;\n      %{$self->{'_colnamesmap'}} = map { $_ => $count++ } @$colnames; \n\n      $self->{'_values'} = [];\n      if( defined $values ) {\n\t  if( ref($values) !~ /ARRAY/i ) {\n\t      $self->throw(\"Need an arrayref of arrayrefs (matrix) for -values option\");\n\t  }\t  \n\t  for my $v ( @$values ) {\n\t      if( ref($v) !~ /ARRAY/i ) {\n\t\t  $self->throw(\"Need and array of arrayrefs (matrix) for -values option\");\n\t      }\n\t      push @{$self->{'_values'}}, [@$v];\n\t  }\n      } else {\n\t  my @fill = ($init_val) x scalar @$colnames; # undef init_val will be default\n\t  for ( @$rownames ) {\n\t      push @{$self->{'_values'}}, [@fill];\n\t  }\n      }\n  } elsif( ! defined $rownames && ! defined $colnames && ! defined $values ) {\n      $self->{'_values'}   = [];\n      $self->{'_rownames'} = [];\n      $self->{'_colnames'} = [];\n  } else { \n      $self->throw(\"Must have either provided no values/colnames/rownames or provided all three\");\n  }\n\n  return $self;\n}\n\n\n=head2 matrix_id\n\n Title   : matrix_id\n Usage   : my $id = $matrix->matrix_id\n Function: Get/Set the matrix ID\n Returns : scalar value\n Args    : [optional] new id value to store\n\n\n\nsub matrix_id{\n   my $self = shift;\n   return $self->{'_matid'} = shift if @_;\n   return $self->{'_matid'};\n\n   \n}\n\n=head2 matrix_name\n\n Title   : matrix_name\n Usage   : my $name = $matrix->matrix_name();\n Function: Get/Set the matrix name\n Returns : scalar value\n Args    : [optional] new matrix name value\n\n\n\nsub matrix_name{\n   my $self = shift;\n   return $self->{'_matname'} = shift if @_;\n   return $self->{'_matname'};\n}\n\n\n=head2 entry\n\n Title   : entry\n Usage   : my $entry = $matrix->entry($row,$col)\n Function: Get the value for a specific cell as specified\n           by the row and column names\n Returns : scalar value or undef if row or col does not\n           exist\n Args    : $rowname - name of the row\n           $colname - column name\n\n\nsub entry{\n   my ($self,$row,$column,$newvalue) = @_;\n   if( ! defined $row || ! defined $column ) {\n       $self->throw(\"Need at least 2 ids\");\n   }\n\n   my ($rownum) = $self->row_num_for_name($row);\n   my ($colnum) = $self->column_num_for_name($column);\n   return $self->entry_by_num($rownum,$colnum,$newvalue);\n}\n\n=head2 get_entry\n\n Title   : get_entry\n Usage   : my $entry = $matrix->get_entry($rowname,$columname)\n Function: Get the entry for a given row,column pair\n Returns : scalar\n Args    : $row name\n           $column name \n\n\n\nsub get_entry{ $_[0]->entry($_[1],$_[2]) }\n\n=head2 entry_by_num\n\n Title   : entry_by_num\n Usage   : my $entry = $matrix->entry_by_num($rownum,$colnum)\n Function: Get an entry by row and column numbers instead of by name\n           (rows and columns start at 0)\n Returns : scalar value or undef if row or column name does not\n           exist\n Args    : $row - row number\n           $col - column number\n           [optional] $newvalue to store at this cell\n\n\nsub entry_by_num {\n    my ($self,$row,$col,$newvalue) = @_;\n    if( ! defined $row || ! defined $col || \n\t$row !~ /^\\d+$/ ||\n\t$col !~ /^\\d+$/ ) {\n\t$self->warn(\"expected to get 2 number for entry_by_num\");\n\treturn;\n    }\n    \n    if( defined $newvalue ) {\n       return $self->_values->[$row][$col] = $newvalue;\n   } else { \n       return $self->_values->[$row][$col];\n   }\n}\n\nsub get_element { \n    my $self = shift;\n    $self->entry(@_);\n}\n\n\n=head2 column\n\n Title   : column\n Usage   : my @col = $matrix->column('ALPHA');\n           OR\n           $matrix->column('ALPHA', \\@col);\n Function: Get/Set a particular column\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values.  \n           For setting will warn if the new column is of a different\n           length from the rest of the columns.\n Args    : name of the column\n           [optional] new column to store here \n\n\nsub column{\n    my ($self,$column,$newcol) = @_;\n\n    if( ! defined $column ) {\n\t$self->warn(\"Need at least a column id\");\n\treturn;\n    }\n    my $colnum  = $self->column_num_for_name($column);\n    if( ! defined $colnum ) { \n\t$self->warn(\"could not find column number for $column\");\n\treturn;\n    }\n    return $self->column_by_num($colnum,$newcol);\n}\n\n\n=head2 get_column\n\n Title   : get_column\n Usage   : my @row = $matrix->get_column('ALPHA');\n Function: Get a particular column\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the column\n\n\n\nsub get_column { $_[0]->column($_[1]) }\n\n\n=head2 column_by_num\n\n Title   : column_by_num\n Usage   : my @col = $matrix->column_by_num(1);\n           OR\n           $matrix->column_by_num(1,\\@newcol);\n Function: Get/Set a column by its number instead of name\n           (cols/rows start at 0)\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the column\n           [optional] new value to store for a particular column\n\n\nsub column_by_num{\n    my ($self,$colnum,$newcol) = @_;\n    if( ! defined $colnum ) {\n\t$self->warn(\"need at least a column number\");\n\treturn;\n    }\n    my $rowcount = $self->num_rows;\n    my $colcount = $self->num_columns;\n    my $ret;\n    \n    if( defined $newcol ) {\n\tif( ref($newcol) !~ /ARRAY/i) {\n\t    $self->warn(\"expected a valid arrayref for resetting a column\");\n\t    return;\n\t}\n\tif( scalar @$newcol != $rowcount ) {\n\t    $self->warn(\"new column is not the correct length ($rowcount) - call add or remove row to shrink or grow the number of rows first\");\n\t    return;\n\t}\n\tfor(my $i=0; $i < $rowcount; $i++) {\n\t    $self->entry_by_num($i,$colnum,$newcol->[$i]);\n\t}\n\t$ret = $newcol;\n    } else { \n\t$ret = [];\n\tfor(my $i=0; $i < $rowcount; $i++) {\n\t    push @$ret,$self->entry_by_num($i,$colnum);\n\t}\n    }\n    if( wantarray ) { return @$ret } \n    return $ret;\n\n}\n\n=head2 row\n\n Title   : row\n Usage   : my @row = $matrix->row($rowname);\n             OR\n           $matrix->row($rowname,\\@rowvalues);\n Function: Get/Set the row of the matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n Args    : rowname\n           [optional] new value of row to store\n\n\n\nsub row {\n    my ($self,$row,$newrow) = @_;\n    if( ! defined $row) {\n\t$self->warn(\"Need at least a row id\");\n\treturn;\n    }\n    my $rownum = $self->row_num_for_name($row);\n    return $self->row_by_num($rownum,$newrow);\n}\n\n\n=head2 get_row\n\n Title   : get_row\n Usage   : my @row = $matrix->get_row('ALPHA');\n Function: Get a particular row\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the row\n\n\nsub get_row { $_[0]->row($_[1]) }\n\n=head2 row_by_num\n\n Title   : row_by_num\n Usage   : my @row = $matrix->row_by_num($rownum);\n             OR\n           $matrix->row($rownum,\\@rowvalues);\n Function: Get/Set the row of the matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n Args    : rowname\n           [optional] new value of row to store"},"line":419,"range":{"end":{"line":452,"character":9999},"start":{"character":0,"line":419}},"kind":12},{"children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"get_diagonal","line":468},{"line":469,"name":"@diag","kind":13,"localvar":"my","containerName":"get_diagonal","definition":"my"},{"definition":"my","name":"$rowcount","localvar":"my","kind":13,"containerName":"get_diagonal","line":470},{"name":"$self","kind":13,"containerName":"get_diagonal","line":470},{"name":"num_rows","kind":12,"containerName":"get_diagonal","line":470},{"definition":"my","name":"$colcount","localvar":"my","containerName":"get_diagonal","kind":13,"line":471},{"line":471,"kind":13,"containerName":"get_diagonal","name":"$self"},{"line":471,"name":"num_columns","kind":12,"containerName":"get_diagonal"},{"definition":"my","kind":13,"localvar":"my","containerName":"get_diagonal","name":"$i","line":472},{"line":472,"name":"$i","containerName":"get_diagonal","kind":13},{"line":472,"name":"$rowcount","kind":13,"containerName":"get_diagonal"},{"name":"$i","containerName":"get_diagonal","kind":13,"line":472},{"name":"@diag","kind":13,"containerName":"get_diagonal","line":473},{"kind":13,"containerName":"get_diagonal","name":"$self","line":473},{"line":473,"name":"entry_by_num","containerName":"get_diagonal","kind":12},{"name":"$i","containerName":"get_diagonal","kind":13,"line":473},{"containerName":"get_diagonal","kind":13,"name":"$i","line":473},{"name":"@diag","kind":13,"containerName":"get_diagonal","line":475}],"containerName":"main::","name":"get_diagonal","definition":"sub","detail":"($self)","line":467,"kind":12,"range":{"start":{"line":467,"character":0},"end":{"line":476,"character":9999}},"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Generic.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Matrix::Generic\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::Generic - A generic matrix implementation\n\n=head1 SYNOPSIS\n\n  # A matrix has columns and rows \n  my $matrix = Bio::Matrix::Generic->new;\n  $matrix->add_column(1,$column1);\n  $matrix->add_column(2,$column2);\n\n  my $element = $matrix->entry_by_num(1,2);\n  $matrix->entry_by_num(1,2,$newval);\n\n  my $entry = $matrix->entry('human', 'mouse');\n\n  $matrix->entry('human','mouse', $newval);\n\n\n=head1 DESCRIPTION\n\nThis is a general purpose matrix object for dealing with row+column\ndata which is typical when enumerating all the pairwise combinations\nand desiring to get slices of the data.\n\nData can be accessed by column and row names or indexes.  Matrix\nindexes start at 0.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Matrix::Generic;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Matrix::MatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Matrix::Generic->new();\n Function: Builds a new Bio::Matrix::Generic object \n Returns : an instance of Bio::Matrix::Generic\n Args    : -values     => arrayref of arrayrefs of data initialization \n           -rownames   => arrayref of row names\n           -colnames   => arrayref of col names\n           -matrix_id  => id of the matrix\n           -matrix_name=> name of the matrix\n           -matrix_init_value => default value to initialize empty cells\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($values, $rownames, $colnames,\n      $id,$name,$init_val) = \n\t  $self->_rearrange([qw(VALUES ROWNAMES COLNAMES \n\t\t\t        MATRIX_ID MATRIX_NAME \n                                MATRIX_INIT_VALUE)],@args);\n  $self->matrix_id($id) if  defined $id;\n  $self->matrix_name($name) if defined $name;\n  if( defined $rownames && defined $colnames ) {\n      if( ref($rownames) !~ /ARRAY/i ) {\n\t  $self->throw(\"need an arrayref for the -rownames option\");\n      }\n      # insure we copy the values\n      $self->{'_rownames'} = [ @$rownames ];\n      my $count = 0;\n      %{$self->{'_rownamesmap'}} = map { $_ => $count++ } @$rownames; \n\n      if( ref($colnames) !~ /ARRAY/i ) {\n\t  $self->throw(\"need an arrayref for the -colnames option\");\n      }\n      # insure we copy the values\n      $self->{'_colnames'} = [ @$colnames ];\n      $count = 0;\n      %{$self->{'_colnamesmap'}} = map { $_ => $count++ } @$colnames; \n\n      $self->{'_values'} = [];\n      if( defined $values ) {\n\t  if( ref($values) !~ /ARRAY/i ) {\n\t      $self->throw(\"Need an arrayref of arrayrefs (matrix) for -values option\");\n\t  }\t  \n\t  for my $v ( @$values ) {\n\t      if( ref($v) !~ /ARRAY/i ) {\n\t\t  $self->throw(\"Need and array of arrayrefs (matrix) for -values option\");\n\t      }\n\t      push @{$self->{'_values'}}, [@$v];\n\t  }\n      } else {\n\t  my @fill = ($init_val) x scalar @$colnames; # undef init_val will be default\n\t  for ( @$rownames ) {\n\t      push @{$self->{'_values'}}, [@fill];\n\t  }\n      }\n  } elsif( ! defined $rownames && ! defined $colnames && ! defined $values ) {\n      $self->{'_values'}   = [];\n      $self->{'_rownames'} = [];\n      $self->{'_colnames'} = [];\n  } else { \n      $self->throw(\"Must have either provided no values/colnames/rownames or provided all three\");\n  }\n\n  return $self;\n}\n\n\n=head2 matrix_id\n\n Title   : matrix_id\n Usage   : my $id = $matrix->matrix_id\n Function: Get/Set the matrix ID\n Returns : scalar value\n Args    : [optional] new id value to store\n\n\n\nsub matrix_id{\n   my $self = shift;\n   return $self->{'_matid'} = shift if @_;\n   return $self->{'_matid'};\n\n   \n}\n\n=head2 matrix_name\n\n Title   : matrix_name\n Usage   : my $name = $matrix->matrix_name();\n Function: Get/Set the matrix name\n Returns : scalar value\n Args    : [optional] new matrix name value\n\n\n\nsub matrix_name{\n   my $self = shift;\n   return $self->{'_matname'} = shift if @_;\n   return $self->{'_matname'};\n}\n\n\n=head2 entry\n\n Title   : entry\n Usage   : my $entry = $matrix->entry($row,$col)\n Function: Get the value for a specific cell as specified\n           by the row and column names\n Returns : scalar value or undef if row or col does not\n           exist\n Args    : $rowname - name of the row\n           $colname - column name\n\n\nsub entry{\n   my ($self,$row,$column,$newvalue) = @_;\n   if( ! defined $row || ! defined $column ) {\n       $self->throw(\"Need at least 2 ids\");\n   }\n\n   my ($rownum) = $self->row_num_for_name($row);\n   my ($colnum) = $self->column_num_for_name($column);\n   return $self->entry_by_num($rownum,$colnum,$newvalue);\n}\n\n=head2 get_entry\n\n Title   : get_entry\n Usage   : my $entry = $matrix->get_entry($rowname,$columname)\n Function: Get the entry for a given row,column pair\n Returns : scalar\n Args    : $row name\n           $column name \n\n\n\nsub get_entry{ $_[0]->entry($_[1],$_[2]) }\n\n=head2 entry_by_num\n\n Title   : entry_by_num\n Usage   : my $entry = $matrix->entry_by_num($rownum,$colnum)\n Function: Get an entry by row and column numbers instead of by name\n           (rows and columns start at 0)\n Returns : scalar value or undef if row or column name does not\n           exist\n Args    : $row - row number\n           $col - column number\n           [optional] $newvalue to store at this cell\n\n\nsub entry_by_num {\n    my ($self,$row,$col,$newvalue) = @_;\n    if( ! defined $row || ! defined $col || \n\t$row !~ /^\\d+$/ ||\n\t$col !~ /^\\d+$/ ) {\n\t$self->warn(\"expected to get 2 number for entry_by_num\");\n\treturn;\n    }\n    \n    if( defined $newvalue ) {\n       return $self->_values->[$row][$col] = $newvalue;\n   } else { \n       return $self->_values->[$row][$col];\n   }\n}\n\nsub get_element { \n    my $self = shift;\n    $self->entry(@_);\n}\n\n\n=head2 column\n\n Title   : column\n Usage   : my @col = $matrix->column('ALPHA');\n           OR\n           $matrix->column('ALPHA', \\@col);\n Function: Get/Set a particular column\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values.  \n           For setting will warn if the new column is of a different\n           length from the rest of the columns.\n Args    : name of the column\n           [optional] new column to store here \n\n\nsub column{\n    my ($self,$column,$newcol) = @_;\n\n    if( ! defined $column ) {\n\t$self->warn(\"Need at least a column id\");\n\treturn;\n    }\n    my $colnum  = $self->column_num_for_name($column);\n    if( ! defined $colnum ) { \n\t$self->warn(\"could not find column number for $column\");\n\treturn;\n    }\n    return $self->column_by_num($colnum,$newcol);\n}\n\n\n=head2 get_column\n\n Title   : get_column\n Usage   : my @row = $matrix->get_column('ALPHA');\n Function: Get a particular column\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the column\n\n\n\nsub get_column { $_[0]->column($_[1]) }\n\n\n=head2 column_by_num\n\n Title   : column_by_num\n Usage   : my @col = $matrix->column_by_num(1);\n           OR\n           $matrix->column_by_num(1,\\@newcol);\n Function: Get/Set a column by its number instead of name\n           (cols/rows start at 0)\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the column\n           [optional] new value to store for a particular column\n\n\nsub column_by_num{\n    my ($self,$colnum,$newcol) = @_;\n    if( ! defined $colnum ) {\n\t$self->warn(\"need at least a column number\");\n\treturn;\n    }\n    my $rowcount = $self->num_rows;\n    my $colcount = $self->num_columns;\n    my $ret;\n    \n    if( defined $newcol ) {\n\tif( ref($newcol) !~ /ARRAY/i) {\n\t    $self->warn(\"expected a valid arrayref for resetting a column\");\n\t    return;\n\t}\n\tif( scalar @$newcol != $rowcount ) {\n\t    $self->warn(\"new column is not the correct length ($rowcount) - call add or remove row to shrink or grow the number of rows first\");\n\t    return;\n\t}\n\tfor(my $i=0; $i < $rowcount; $i++) {\n\t    $self->entry_by_num($i,$colnum,$newcol->[$i]);\n\t}\n\t$ret = $newcol;\n    } else { \n\t$ret = [];\n\tfor(my $i=0; $i < $rowcount; $i++) {\n\t    push @$ret,$self->entry_by_num($i,$colnum);\n\t}\n    }\n    if( wantarray ) { return @$ret } \n    return $ret;\n\n}\n\n=head2 row\n\n Title   : row\n Usage   : my @row = $matrix->row($rowname);\n             OR\n           $matrix->row($rowname,\\@rowvalues);\n Function: Get/Set the row of the matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n Args    : rowname\n           [optional] new value of row to store\n\n\n\nsub row {\n    my ($self,$row,$newrow) = @_;\n    if( ! defined $row) {\n\t$self->warn(\"Need at least a row id\");\n\treturn;\n    }\n    my $rownum = $self->row_num_for_name($row);\n    return $self->row_by_num($rownum,$newrow);\n}\n\n\n=head2 get_row\n\n Title   : get_row\n Usage   : my @row = $matrix->get_row('ALPHA');\n Function: Get a particular row\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the row\n\n\nsub get_row { $_[0]->row($_[1]) }\n\n=head2 row_by_num\n\n Title   : row_by_num\n Usage   : my @row = $matrix->row_by_num($rownum);\n             OR\n           $matrix->row($rownum,\\@rowvalues);\n Function: Get/Set the row of the matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n Args    : rowname\n           [optional] new value of row to store\n\n\nsub row_by_num{\n   my ($self,$rownum,$newrow) = @_;\n   if( ! defined $rownum ) {\n       $self->warn(\"need at least a row number\");\n       return;\n   }\n    my $colcount = $self->num_columns;\n    my $ret;\n    if( defined $newrow ) {\n\tif( ref($newrow) !~ /ARRAY/i) {\n\t    $self->warn(\"expected a valid arrayref for resetting a row\");\n\t    return;\n\t}\n\tif( scalar @$newrow != $colcount ) {\n\t    $self->warn(\"new row is not the correct length ($colcount) - call add or remove column to shrink or grow the number of columns first\");\n\t    return;\n\t}\n\tfor(my $i=0; $i < $colcount; $i++) {\n\t    $self->entry_by_num($rownum,$i, $newrow->[$i]);\n\t}\n\t$ret = $newrow;\n    } else { \n\t$ret = [];\n\tfor(my $i=0; $i < $colcount; $i++) {\n\t    # we're doing this to explicitly \n\t    # copy the entire row\n\t    push @$ret, $self->entry_by_num($rownum,$i);\n\t}\n    }\n    if( wantarray ) { return @$ret } \n    return $ret;\n\n\n}\n\n\n=head2 diagonal\n\n Title   : diagonal\n Usage   : my @diagonal = $matrix->get_diagonal()\n Function: Get the diagonal of a matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values which lie along the diagonal\n Args    : none","label":"get_diagonal($self)"}},{"signature":{"documentation":"1;\n# $Id: Generic.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Matrix::Generic\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::Generic - A generic matrix implementation\n\n=head1 SYNOPSIS\n\n  # A matrix has columns and rows \n  my $matrix = Bio::Matrix::Generic->new;\n  $matrix->add_column(1,$column1);\n  $matrix->add_column(2,$column2);\n\n  my $element = $matrix->entry_by_num(1,2);\n  $matrix->entry_by_num(1,2,$newval);\n\n  my $entry = $matrix->entry('human', 'mouse');\n\n  $matrix->entry('human','mouse', $newval);\n\n\n=head1 DESCRIPTION\n\nThis is a general purpose matrix object for dealing with row+column\ndata which is typical when enumerating all the pairwise combinations\nand desiring to get slices of the data.\n\nData can be accessed by column and row names or indexes.  Matrix\nindexes start at 0.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Matrix::Generic;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Matrix::MatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Matrix::Generic->new();\n Function: Builds a new Bio::Matrix::Generic object \n Returns : an instance of Bio::Matrix::Generic\n Args    : -values     => arrayref of arrayrefs of data initialization \n           -rownames   => arrayref of row names\n           -colnames   => arrayref of col names\n           -matrix_id  => id of the matrix\n           -matrix_name=> name of the matrix\n           -matrix_init_value => default value to initialize empty cells\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($values, $rownames, $colnames,\n      $id,$name,$init_val) = \n\t  $self->_rearrange([qw(VALUES ROWNAMES COLNAMES \n\t\t\t        MATRIX_ID MATRIX_NAME \n                                MATRIX_INIT_VALUE)],@args);\n  $self->matrix_id($id) if  defined $id;\n  $self->matrix_name($name) if defined $name;\n  if( defined $rownames && defined $colnames ) {\n      if( ref($rownames) !~ /ARRAY/i ) {\n\t  $self->throw(\"need an arrayref for the -rownames option\");\n      }\n      # insure we copy the values\n      $self->{'_rownames'} = [ @$rownames ];\n      my $count = 0;\n      %{$self->{'_rownamesmap'}} = map { $_ => $count++ } @$rownames; \n\n      if( ref($colnames) !~ /ARRAY/i ) {\n\t  $self->throw(\"need an arrayref for the -colnames option\");\n      }\n      # insure we copy the values\n      $self->{'_colnames'} = [ @$colnames ];\n      $count = 0;\n      %{$self->{'_colnamesmap'}} = map { $_ => $count++ } @$colnames; \n\n      $self->{'_values'} = [];\n      if( defined $values ) {\n\t  if( ref($values) !~ /ARRAY/i ) {\n\t      $self->throw(\"Need an arrayref of arrayrefs (matrix) for -values option\");\n\t  }\t  \n\t  for my $v ( @$values ) {\n\t      if( ref($v) !~ /ARRAY/i ) {\n\t\t  $self->throw(\"Need and array of arrayrefs (matrix) for -values option\");\n\t      }\n\t      push @{$self->{'_values'}}, [@$v];\n\t  }\n      } else {\n\t  my @fill = ($init_val) x scalar @$colnames; # undef init_val will be default\n\t  for ( @$rownames ) {\n\t      push @{$self->{'_values'}}, [@fill];\n\t  }\n      }\n  } elsif( ! defined $rownames && ! defined $colnames && ! defined $values ) {\n      $self->{'_values'}   = [];\n      $self->{'_rownames'} = [];\n      $self->{'_colnames'} = [];\n  } else { \n      $self->throw(\"Must have either provided no values/colnames/rownames or provided all three\");\n  }\n\n  return $self;\n}\n\n\n=head2 matrix_id\n\n Title   : matrix_id\n Usage   : my $id = $matrix->matrix_id\n Function: Get/Set the matrix ID\n Returns : scalar value\n Args    : [optional] new id value to store\n\n\n\nsub matrix_id{\n   my $self = shift;\n   return $self->{'_matid'} = shift if @_;\n   return $self->{'_matid'};\n\n   \n}\n\n=head2 matrix_name\n\n Title   : matrix_name\n Usage   : my $name = $matrix->matrix_name();\n Function: Get/Set the matrix name\n Returns : scalar value\n Args    : [optional] new matrix name value\n\n\n\nsub matrix_name{\n   my $self = shift;\n   return $self->{'_matname'} = shift if @_;\n   return $self->{'_matname'};\n}\n\n\n=head2 entry\n\n Title   : entry\n Usage   : my $entry = $matrix->entry($row,$col)\n Function: Get the value for a specific cell as specified\n           by the row and column names\n Returns : scalar value or undef if row or col does not\n           exist\n Args    : $rowname - name of the row\n           $colname - column name\n\n\nsub entry{\n   my ($self,$row,$column,$newvalue) = @_;\n   if( ! defined $row || ! defined $column ) {\n       $self->throw(\"Need at least 2 ids\");\n   }\n\n   my ($rownum) = $self->row_num_for_name($row);\n   my ($colnum) = $self->column_num_for_name($column);\n   return $self->entry_by_num($rownum,$colnum,$newvalue);\n}\n\n=head2 get_entry\n\n Title   : get_entry\n Usage   : my $entry = $matrix->get_entry($rowname,$columname)\n Function: Get the entry for a given row,column pair\n Returns : scalar\n Args    : $row name\n           $column name \n\n\n\nsub get_entry{ $_[0]->entry($_[1],$_[2]) }\n\n=head2 entry_by_num\n\n Title   : entry_by_num\n Usage   : my $entry = $matrix->entry_by_num($rownum,$colnum)\n Function: Get an entry by row and column numbers instead of by name\n           (rows and columns start at 0)\n Returns : scalar value or undef if row or column name does not\n           exist\n Args    : $row - row number\n           $col - column number\n           [optional] $newvalue to store at this cell\n\n\nsub entry_by_num {\n    my ($self,$row,$col,$newvalue) = @_;\n    if( ! defined $row || ! defined $col || \n\t$row !~ /^\\d+$/ ||\n\t$col !~ /^\\d+$/ ) {\n\t$self->warn(\"expected to get 2 number for entry_by_num\");\n\treturn;\n    }\n    \n    if( defined $newvalue ) {\n       return $self->_values->[$row][$col] = $newvalue;\n   } else { \n       return $self->_values->[$row][$col];\n   }\n}\n\nsub get_element { \n    my $self = shift;\n    $self->entry(@_);\n}\n\n\n=head2 column\n\n Title   : column\n Usage   : my @col = $matrix->column('ALPHA');\n           OR\n           $matrix->column('ALPHA', \\@col);\n Function: Get/Set a particular column\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values.  \n           For setting will warn if the new column is of a different\n           length from the rest of the columns.\n Args    : name of the column\n           [optional] new column to store here \n\n\nsub column{\n    my ($self,$column,$newcol) = @_;\n\n    if( ! defined $column ) {\n\t$self->warn(\"Need at least a column id\");\n\treturn;\n    }\n    my $colnum  = $self->column_num_for_name($column);\n    if( ! defined $colnum ) { \n\t$self->warn(\"could not find column number for $column\");\n\treturn;\n    }\n    return $self->column_by_num($colnum,$newcol);\n}\n\n\n=head2 get_column\n\n Title   : get_column\n Usage   : my @row = $matrix->get_column('ALPHA');\n Function: Get a particular column\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the column\n\n\n\nsub get_column { $_[0]->column($_[1]) }\n\n\n=head2 column_by_num\n\n Title   : column_by_num\n Usage   : my @col = $matrix->column_by_num(1);\n           OR\n           $matrix->column_by_num(1,\\@newcol);\n Function: Get/Set a column by its number instead of name\n           (cols/rows start at 0)\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the column\n           [optional] new value to store for a particular column\n\n\nsub column_by_num{\n    my ($self,$colnum,$newcol) = @_;\n    if( ! defined $colnum ) {\n\t$self->warn(\"need at least a column number\");\n\treturn;\n    }\n    my $rowcount = $self->num_rows;\n    my $colcount = $self->num_columns;\n    my $ret;\n    \n    if( defined $newcol ) {\n\tif( ref($newcol) !~ /ARRAY/i) {\n\t    $self->warn(\"expected a valid arrayref for resetting a column\");\n\t    return;\n\t}\n\tif( scalar @$newcol != $rowcount ) {\n\t    $self->warn(\"new column is not the correct length ($rowcount) - call add or remove row to shrink or grow the number of rows first\");\n\t    return;\n\t}\n\tfor(my $i=0; $i < $rowcount; $i++) {\n\t    $self->entry_by_num($i,$colnum,$newcol->[$i]);\n\t}\n\t$ret = $newcol;\n    } else { \n\t$ret = [];\n\tfor(my $i=0; $i < $rowcount; $i++) {\n\t    push @$ret,$self->entry_by_num($i,$colnum);\n\t}\n    }\n    if( wantarray ) { return @$ret } \n    return $ret;\n\n}\n\n=head2 row\n\n Title   : row\n Usage   : my @row = $matrix->row($rowname);\n             OR\n           $matrix->row($rowname,\\@rowvalues);\n Function: Get/Set the row of the matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n Args    : rowname\n           [optional] new value of row to store\n\n\n\nsub row {\n    my ($self,$row,$newrow) = @_;\n    if( ! defined $row) {\n\t$self->warn(\"Need at least a row id\");\n\treturn;\n    }\n    my $rownum = $self->row_num_for_name($row);\n    return $self->row_by_num($rownum,$newrow);\n}\n\n\n=head2 get_row\n\n Title   : get_row\n Usage   : my @row = $matrix->get_row('ALPHA');\n Function: Get a particular row\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the row\n\n\nsub get_row { $_[0]->row($_[1]) }\n\n=head2 row_by_num\n\n Title   : row_by_num\n Usage   : my @row = $matrix->row_by_num($rownum);\n             OR\n           $matrix->row($rownum,\\@rowvalues);\n Function: Get/Set the row of the matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n Args    : rowname\n           [optional] new value of row to store\n\n\nsub row_by_num{\n   my ($self,$rownum,$newrow) = @_;\n   if( ! defined $rownum ) {\n       $self->warn(\"need at least a row number\");\n       return;\n   }\n    my $colcount = $self->num_columns;\n    my $ret;\n    if( defined $newrow ) {\n\tif( ref($newrow) !~ /ARRAY/i) {\n\t    $self->warn(\"expected a valid arrayref for resetting a row\");\n\t    return;\n\t}\n\tif( scalar @$newrow != $colcount ) {\n\t    $self->warn(\"new row is not the correct length ($colcount) - call add or remove column to shrink or grow the number of columns first\");\n\t    return;\n\t}\n\tfor(my $i=0; $i < $colcount; $i++) {\n\t    $self->entry_by_num($rownum,$i, $newrow->[$i]);\n\t}\n\t$ret = $newrow;\n    } else { \n\t$ret = [];\n\tfor(my $i=0; $i < $colcount; $i++) {\n\t    # we're doing this to explicitly \n\t    # copy the entire row\n\t    push @$ret, $self->entry_by_num($rownum,$i);\n\t}\n    }\n    if( wantarray ) { return @$ret } \n    return $ret;\n\n\n}\n\n\n=head2 diagonal\n\n Title   : diagonal\n Usage   : my @diagonal = $matrix->get_diagonal()\n Function: Get the diagonal of a matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values which lie along the diagonal\n Args    : none\n\n\n\nsub get_diagonal{\n   my ($self) = @_;\n   my @diag;\n   my $rowcount = $self->num_rows;\n   my $colcount = $self->num_columns;\n   for(my $i = 0; $i < $rowcount; $i++ ) {\n       push @diag, $self->entry_by_num($i,$i);\n   }\n   return @diag;\n}\n\n\n=head2 add_row\n\n Title   : add_row\n Usage   : $matrix->add_row($index,\\@newrow);\n Function: Adds a row at particular location in the matrix.\n           If $index < the rowcount will shift all the rows down\n           by the number of new rows.\n           To add a single empty row, simply call\n           $matrix->add_row($index,undef);\n Returns : the updated number of total rows in the matrix\n Args    : index to store\n           name of the row (header)\n           newrow to add, if this is undef will add a single\n                     row with all values set to undef ","parameters":[{"label":"$self"},{"label":"$index"},{"label":"$name"},{"label":"$newrow"}],"label":"add_row($self,$index,$name,$newrow)"},"range":{"start":{"line":496,"character":0},"end":{"character":9999,"line":525}},"kind":12,"line":496,"detail":"($self,$index,$name,$newrow)","definition":"sub","name":"add_row","containerName":"main::","children":[{"definition":"my","line":497,"name":"$self","localvar":"my","containerName":"add_row","kind":13},{"containerName":"add_row","kind":13,"name":"$index","line":497},{"line":497,"containerName":"add_row","kind":13,"name":"$name"},{"line":497,"name":"$newrow","kind":13,"containerName":"add_row"},{"name":"$index","kind":13,"containerName":"add_row","line":498},{"kind":13,"containerName":"add_row","name":"$index","line":499},{"name":"$self","kind":13,"containerName":"add_row","line":500},{"line":500,"name":"warn","containerName":"add_row","kind":12},{"line":502,"kind":13,"containerName":"add_row","name":"$name"},{"line":503,"name":"$self","kind":13,"containerName":"add_row"},{"line":503,"name":"warn","kind":12,"containerName":"add_row"},{"name":"$self","kind":13,"containerName":"add_row","line":505},{"line":505,"name":"row_num_for_name","kind":12,"containerName":"add_row"},{"line":505,"kind":13,"containerName":"add_row","name":"$name"},{"name":"$self","containerName":"add_row","kind":13,"line":506},{"line":506,"containerName":"add_row","kind":12,"name":"warn"},{"line":509,"kind":13,"localvar":"my","containerName":"add_row","name":"$colcount","definition":"my"},{"containerName":"add_row","kind":13,"name":"$self","line":509},{"line":509,"name":"num_columns","kind":12,"containerName":"add_row"},{"name":"$rowcount","kind":13,"localvar":"my","containerName":"add_row","line":510,"definition":"my"},{"kind":13,"containerName":"add_row","name":"$self","line":510},{"line":510,"containerName":"add_row","kind":12,"name":"num_rows"},{"name":"$index","containerName":"add_row","kind":13,"line":512},{"kind":13,"containerName":"add_row","name":"$rowcount","line":512},{"name":"$self","containerName":"add_row","kind":13,"line":513},{"kind":12,"containerName":"add_row","name":"warn","line":513},{"kind":13,"containerName":"add_row","name":"$index","line":514},{"kind":13,"containerName":"add_row","name":"$rowcount","line":514},{"kind":13,"containerName":"add_row","name":"$newrow","line":517},{"containerName":"add_row","kind":13,"name":"$newrow","line":518},{"line":519,"containerName":"add_row","kind":13,"name":"$newrow"},{"line":519,"name":"$colcount","kind":13,"containerName":"add_row"},{"containerName":"add_row","kind":13,"name":"$newrow","line":520},{"line":521,"name":"$self","kind":13,"containerName":"add_row"},{"kind":12,"containerName":"add_row","name":"throw","line":521},{"kind":13,"containerName":"add_row","name":"$self","line":525}]},{"line":525,"name":"@index","containerName":null,"kind":13},{"containerName":null,"localvar":"my","kind":13,"name":"$i","line":526,"definition":"my"},{"name":"$i","kind":13,"containerName":null,"line":526},{"line":526,"containerName":null,"kind":13,"name":"$colcount"},{"line":526,"name":"%i","containerName":null,"kind":13},{"line":527,"containerName":null,"kind":13,"name":"$self"},{"name":"entry_by_num","kind":12,"containerName":"main::","line":527},{"name":"$index","containerName":null,"kind":13,"line":527},{"line":527,"kind":13,"containerName":null,"name":"$i"},{"kind":13,"containerName":null,"name":"@newrow","line":527},{"containerName":null,"kind":13,"name":"$i","line":527},{"containerName":null,"kind":13,"name":"%self","line":529},{"name":"$index","containerName":null,"kind":13,"line":529},{"line":529,"name":"$name","kind":13,"containerName":null},{"definition":"my","kind":13,"localvar":"my","containerName":null,"name":"$ct","line":533},{"line":534,"containerName":null,"kind":13,"name":"%self"},{"line":534,"name":"$ct","kind":13,"containerName":null},{"line":534,"name":"%self","kind":13,"containerName":null},{"line":535,"name":"$self","containerName":null,"kind":13},{"line":535,"name":"num_rows","containerName":"main::","kind":12},{"containerName":"main::","name":"remove_row","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"remove_row","line":551},{"containerName":"remove_row","kind":13,"name":"$rowindex","line":551},{"line":552,"name":"$rowcount","kind":13,"localvar":"my","containerName":"remove_row","definition":"my"},{"line":552,"containerName":"remove_row","kind":13,"name":"$self"},{"line":552,"name":"num_rows","kind":12,"containerName":"remove_row"},{"line":554,"kind":13,"containerName":"remove_row","name":"$rowindex"},{"line":554,"name":"$rowcount","kind":13,"containerName":"remove_row"},{"line":555,"name":"$self","kind":13,"containerName":"remove_row"},{"line":555,"name":"warn","kind":12,"containerName":"remove_row"},{"kind":13,"containerName":"remove_row","name":"$self","line":558},{"containerName":"remove_row","kind":12,"name":"_values","line":558},{"line":558,"name":"$rowindex","containerName":"remove_row","kind":13},{"line":559,"kind":13,"containerName":"remove_row","name":"$self"},{"kind":13,"containerName":"remove_row","name":"$self","line":559},{"containerName":"remove_row","kind":13,"name":"$rowindex","line":559},{"line":560,"kind":13,"containerName":"remove_row","name":"$self"}],"detail":"($self,$rowindex)","definition":"sub","range":{"start":{"character":0,"line":550},"end":{"line":560,"character":9999}},"kind":12,"line":550,"signature":{"documentation":"1;\n# $Id: Generic.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Matrix::Generic\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::Generic - A generic matrix implementation\n\n=head1 SYNOPSIS\n\n  # A matrix has columns and rows \n  my $matrix = Bio::Matrix::Generic->new;\n  $matrix->add_column(1,$column1);\n  $matrix->add_column(2,$column2);\n\n  my $element = $matrix->entry_by_num(1,2);\n  $matrix->entry_by_num(1,2,$newval);\n\n  my $entry = $matrix->entry('human', 'mouse');\n\n  $matrix->entry('human','mouse', $newval);\n\n\n=head1 DESCRIPTION\n\nThis is a general purpose matrix object for dealing with row+column\ndata which is typical when enumerating all the pairwise combinations\nand desiring to get slices of the data.\n\nData can be accessed by column and row names or indexes.  Matrix\nindexes start at 0.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Matrix::Generic;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Matrix::MatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Matrix::Generic->new();\n Function: Builds a new Bio::Matrix::Generic object \n Returns : an instance of Bio::Matrix::Generic\n Args    : -values     => arrayref of arrayrefs of data initialization \n           -rownames   => arrayref of row names\n           -colnames   => arrayref of col names\n           -matrix_id  => id of the matrix\n           -matrix_name=> name of the matrix\n           -matrix_init_value => default value to initialize empty cells\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($values, $rownames, $colnames,\n      $id,$name,$init_val) = \n\t  $self->_rearrange([qw(VALUES ROWNAMES COLNAMES \n\t\t\t        MATRIX_ID MATRIX_NAME \n                                MATRIX_INIT_VALUE)],@args);\n  $self->matrix_id($id) if  defined $id;\n  $self->matrix_name($name) if defined $name;\n  if( defined $rownames && defined $colnames ) {\n      if( ref($rownames) !~ /ARRAY/i ) {\n\t  $self->throw(\"need an arrayref for the -rownames option\");\n      }\n      # insure we copy the values\n      $self->{'_rownames'} = [ @$rownames ];\n      my $count = 0;\n      %{$self->{'_rownamesmap'}} = map { $_ => $count++ } @$rownames; \n\n      if( ref($colnames) !~ /ARRAY/i ) {\n\t  $self->throw(\"need an arrayref for the -colnames option\");\n      }\n      # insure we copy the values\n      $self->{'_colnames'} = [ @$colnames ];\n      $count = 0;\n      %{$self->{'_colnamesmap'}} = map { $_ => $count++ } @$colnames; \n\n      $self->{'_values'} = [];\n      if( defined $values ) {\n\t  if( ref($values) !~ /ARRAY/i ) {\n\t      $self->throw(\"Need an arrayref of arrayrefs (matrix) for -values option\");\n\t  }\t  \n\t  for my $v ( @$values ) {\n\t      if( ref($v) !~ /ARRAY/i ) {\n\t\t  $self->throw(\"Need and array of arrayrefs (matrix) for -values option\");\n\t      }\n\t      push @{$self->{'_values'}}, [@$v];\n\t  }\n      } else {\n\t  my @fill = ($init_val) x scalar @$colnames; # undef init_val will be default\n\t  for ( @$rownames ) {\n\t      push @{$self->{'_values'}}, [@fill];\n\t  }\n      }\n  } elsif( ! defined $rownames && ! defined $colnames && ! defined $values ) {\n      $self->{'_values'}   = [];\n      $self->{'_rownames'} = [];\n      $self->{'_colnames'} = [];\n  } else { \n      $self->throw(\"Must have either provided no values/colnames/rownames or provided all three\");\n  }\n\n  return $self;\n}\n\n\n=head2 matrix_id\n\n Title   : matrix_id\n Usage   : my $id = $matrix->matrix_id\n Function: Get/Set the matrix ID\n Returns : scalar value\n Args    : [optional] new id value to store\n\n\n\nsub matrix_id{\n   my $self = shift;\n   return $self->{'_matid'} = shift if @_;\n   return $self->{'_matid'};\n\n   \n}\n\n=head2 matrix_name\n\n Title   : matrix_name\n Usage   : my $name = $matrix->matrix_name();\n Function: Get/Set the matrix name\n Returns : scalar value\n Args    : [optional] new matrix name value\n\n\n\nsub matrix_name{\n   my $self = shift;\n   return $self->{'_matname'} = shift if @_;\n   return $self->{'_matname'};\n}\n\n\n=head2 entry\n\n Title   : entry\n Usage   : my $entry = $matrix->entry($row,$col)\n Function: Get the value for a specific cell as specified\n           by the row and column names\n Returns : scalar value or undef if row or col does not\n           exist\n Args    : $rowname - name of the row\n           $colname - column name\n\n\nsub entry{\n   my ($self,$row,$column,$newvalue) = @_;\n   if( ! defined $row || ! defined $column ) {\n       $self->throw(\"Need at least 2 ids\");\n   }\n\n   my ($rownum) = $self->row_num_for_name($row);\n   my ($colnum) = $self->column_num_for_name($column);\n   return $self->entry_by_num($rownum,$colnum,$newvalue);\n}\n\n=head2 get_entry\n\n Title   : get_entry\n Usage   : my $entry = $matrix->get_entry($rowname,$columname)\n Function: Get the entry for a given row,column pair\n Returns : scalar\n Args    : $row name\n           $column name \n\n\n\nsub get_entry{ $_[0]->entry($_[1],$_[2]) }\n\n=head2 entry_by_num\n\n Title   : entry_by_num\n Usage   : my $entry = $matrix->entry_by_num($rownum,$colnum)\n Function: Get an entry by row and column numbers instead of by name\n           (rows and columns start at 0)\n Returns : scalar value or undef if row or column name does not\n           exist\n Args    : $row - row number\n           $col - column number\n           [optional] $newvalue to store at this cell\n\n\nsub entry_by_num {\n    my ($self,$row,$col,$newvalue) = @_;\n    if( ! defined $row || ! defined $col || \n\t$row !~ /^\\d+$/ ||\n\t$col !~ /^\\d+$/ ) {\n\t$self->warn(\"expected to get 2 number for entry_by_num\");\n\treturn;\n    }\n    \n    if( defined $newvalue ) {\n       return $self->_values->[$row][$col] = $newvalue;\n   } else { \n       return $self->_values->[$row][$col];\n   }\n}\n\nsub get_element { \n    my $self = shift;\n    $self->entry(@_);\n}\n\n\n=head2 column\n\n Title   : column\n Usage   : my @col = $matrix->column('ALPHA');\n           OR\n           $matrix->column('ALPHA', \\@col);\n Function: Get/Set a particular column\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values.  \n           For setting will warn if the new column is of a different\n           length from the rest of the columns.\n Args    : name of the column\n           [optional] new column to store here \n\n\nsub column{\n    my ($self,$column,$newcol) = @_;\n\n    if( ! defined $column ) {\n\t$self->warn(\"Need at least a column id\");\n\treturn;\n    }\n    my $colnum  = $self->column_num_for_name($column);\n    if( ! defined $colnum ) { \n\t$self->warn(\"could not find column number for $column\");\n\treturn;\n    }\n    return $self->column_by_num($colnum,$newcol);\n}\n\n\n=head2 get_column\n\n Title   : get_column\n Usage   : my @row = $matrix->get_column('ALPHA');\n Function: Get a particular column\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the column\n\n\n\nsub get_column { $_[0]->column($_[1]) }\n\n\n=head2 column_by_num\n\n Title   : column_by_num\n Usage   : my @col = $matrix->column_by_num(1);\n           OR\n           $matrix->column_by_num(1,\\@newcol);\n Function: Get/Set a column by its number instead of name\n           (cols/rows start at 0)\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the column\n           [optional] new value to store for a particular column\n\n\nsub column_by_num{\n    my ($self,$colnum,$newcol) = @_;\n    if( ! defined $colnum ) {\n\t$self->warn(\"need at least a column number\");\n\treturn;\n    }\n    my $rowcount = $self->num_rows;\n    my $colcount = $self->num_columns;\n    my $ret;\n    \n    if( defined $newcol ) {\n\tif( ref($newcol) !~ /ARRAY/i) {\n\t    $self->warn(\"expected a valid arrayref for resetting a column\");\n\t    return;\n\t}\n\tif( scalar @$newcol != $rowcount ) {\n\t    $self->warn(\"new column is not the correct length ($rowcount) - call add or remove row to shrink or grow the number of rows first\");\n\t    return;\n\t}\n\tfor(my $i=0; $i < $rowcount; $i++) {\n\t    $self->entry_by_num($i,$colnum,$newcol->[$i]);\n\t}\n\t$ret = $newcol;\n    } else { \n\t$ret = [];\n\tfor(my $i=0; $i < $rowcount; $i++) {\n\t    push @$ret,$self->entry_by_num($i,$colnum);\n\t}\n    }\n    if( wantarray ) { return @$ret } \n    return $ret;\n\n}\n\n=head2 row\n\n Title   : row\n Usage   : my @row = $matrix->row($rowname);\n             OR\n           $matrix->row($rowname,\\@rowvalues);\n Function: Get/Set the row of the matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n Args    : rowname\n           [optional] new value of row to store\n\n\n\nsub row {\n    my ($self,$row,$newrow) = @_;\n    if( ! defined $row) {\n\t$self->warn(\"Need at least a row id\");\n\treturn;\n    }\n    my $rownum = $self->row_num_for_name($row);\n    return $self->row_by_num($rownum,$newrow);\n}\n\n\n=head2 get_row\n\n Title   : get_row\n Usage   : my @row = $matrix->get_row('ALPHA');\n Function: Get a particular row\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the row\n\n\nsub get_row { $_[0]->row($_[1]) }\n\n=head2 row_by_num\n\n Title   : row_by_num\n Usage   : my @row = $matrix->row_by_num($rownum);\n             OR\n           $matrix->row($rownum,\\@rowvalues);\n Function: Get/Set the row of the matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n Args    : rowname\n           [optional] new value of row to store\n\n\nsub row_by_num{\n   my ($self,$rownum,$newrow) = @_;\n   if( ! defined $rownum ) {\n       $self->warn(\"need at least a row number\");\n       return;\n   }\n    my $colcount = $self->num_columns;\n    my $ret;\n    if( defined $newrow ) {\n\tif( ref($newrow) !~ /ARRAY/i) {\n\t    $self->warn(\"expected a valid arrayref for resetting a row\");\n\t    return;\n\t}\n\tif( scalar @$newrow != $colcount ) {\n\t    $self->warn(\"new row is not the correct length ($colcount) - call add or remove column to shrink or grow the number of columns first\");\n\t    return;\n\t}\n\tfor(my $i=0; $i < $colcount; $i++) {\n\t    $self->entry_by_num($rownum,$i, $newrow->[$i]);\n\t}\n\t$ret = $newrow;\n    } else { \n\t$ret = [];\n\tfor(my $i=0; $i < $colcount; $i++) {\n\t    # we're doing this to explicitly \n\t    # copy the entire row\n\t    push @$ret, $self->entry_by_num($rownum,$i);\n\t}\n    }\n    if( wantarray ) { return @$ret } \n    return $ret;\n\n\n}\n\n\n=head2 diagonal\n\n Title   : diagonal\n Usage   : my @diagonal = $matrix->get_diagonal()\n Function: Get the diagonal of a matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values which lie along the diagonal\n Args    : none\n\n\n\nsub get_diagonal{\n   my ($self) = @_;\n   my @diag;\n   my $rowcount = $self->num_rows;\n   my $colcount = $self->num_columns;\n   for(my $i = 0; $i < $rowcount; $i++ ) {\n       push @diag, $self->entry_by_num($i,$i);\n   }\n   return @diag;\n}\n\n\n=head2 add_row\n\n Title   : add_row\n Usage   : $matrix->add_row($index,\\@newrow);\n Function: Adds a row at particular location in the matrix.\n           If $index < the rowcount will shift all the rows down\n           by the number of new rows.\n           To add a single empty row, simply call\n           $matrix->add_row($index,undef);\n Returns : the updated number of total rows in the matrix\n Args    : index to store\n           name of the row (header)\n           newrow to add, if this is undef will add a single\n                     row with all values set to undef \n\n\nsub add_row{\n   my ($self,$index,$name,$newrow) = @_;\n   if( !defined $index || \n       $index !~ /^\\d+$/ ) {\n       $self->warn(\"expected a valid row index in add_row\");\n       return;\n   } elsif( ! defined $name) {\n       $self->warn(\"Need a row name or heading\");\n       return;\n   } elsif( defined $self->row_num_for_name($name) ) {\n       $self->warn(\"Need a unqiue name for the column heading, $name is already used\");\n       return;\n   }\n   my $colcount = $self->num_columns;\n   my $rowcount = $self->num_rows;\n\n   if( $index >  $rowcount ) { \n       $self->warn(\"cannot add a row beyond 1+last row at the end ($rowcount) not $index - adding at $rowcount instead\");\n       $index = $rowcount;\n   }\n\n   if( ! defined $newrow ) {\n       $newrow = [];\n       $newrow->[$colcount] = undef;\n   } elsif( ref($newrow) !~ /ARRAY/i ) {\n       $self->throw(\"Expected either undef or a valid arrayref for add_row\");\n   }\n   # add this row to the matrix by carving out space for it with \n   # splice\n   splice(@{$self->{'_values'}}, $index,0,[]);\n   for( my $i = 0; $i < $colcount; $i++ ) {\n       $self->entry_by_num($index,$i,$newrow->[$i]);\n   }\n   splice(@{$self->{'_rownames'}}, $index,0,$name);\n   # Sadly we have to remap these each time (except for the case\n   # when we're adding a new column to the end, but I don't think\n   # the speedup for that case warrants the extra code at this time.\n   my $ct = 0;\n   %{$self->{'_rownamesmap'}} = map { $_ => $ct++} @{$self->{'_rownames'}};\n   return $self->num_rows;\n}\n\n=head2 remove_row\n\n Title   : remove_row\n Usage   : $matrix->remove_row($colnum)\n Function: remove a row from the matrix shifting all the rows\n           up by one\n Returns : Updated number of rows in the matrix\n Args    : row index","parameters":[{"label":"$self"},{"label":"$rowindex"}],"label":"remove_row($self,$rowindex)"}},{"name":"$rowindex","kind":13,"containerName":null,"line":560},{"name":"$ct","kind":13,"localvar":"my","containerName":null,"line":562,"definition":"my"},{"containerName":null,"kind":13,"name":"%self","line":563},{"name":"$ct","containerName":null,"kind":13,"line":563},{"line":563,"name":"%self","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"$self","line":564},{"line":564,"name":"num_rows","kind":12,"containerName":"main::"},{"signature":{"label":"add_column($self,$index,$name,$newcol)","documentation":"1;\n# $Id: Generic.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Matrix::Generic\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::Generic - A generic matrix implementation\n\n=head1 SYNOPSIS\n\n  # A matrix has columns and rows \n  my $matrix = Bio::Matrix::Generic->new;\n  $matrix->add_column(1,$column1);\n  $matrix->add_column(2,$column2);\n\n  my $element = $matrix->entry_by_num(1,2);\n  $matrix->entry_by_num(1,2,$newval);\n\n  my $entry = $matrix->entry('human', 'mouse');\n\n  $matrix->entry('human','mouse', $newval);\n\n\n=head1 DESCRIPTION\n\nThis is a general purpose matrix object for dealing with row+column\ndata which is typical when enumerating all the pairwise combinations\nand desiring to get slices of the data.\n\nData can be accessed by column and row names or indexes.  Matrix\nindexes start at 0.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Matrix::Generic;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Matrix::MatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Matrix::Generic->new();\n Function: Builds a new Bio::Matrix::Generic object \n Returns : an instance of Bio::Matrix::Generic\n Args    : -values     => arrayref of arrayrefs of data initialization \n           -rownames   => arrayref of row names\n           -colnames   => arrayref of col names\n           -matrix_id  => id of the matrix\n           -matrix_name=> name of the matrix\n           -matrix_init_value => default value to initialize empty cells\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($values, $rownames, $colnames,\n      $id,$name,$init_val) = \n\t  $self->_rearrange([qw(VALUES ROWNAMES COLNAMES \n\t\t\t        MATRIX_ID MATRIX_NAME \n                                MATRIX_INIT_VALUE)],@args);\n  $self->matrix_id($id) if  defined $id;\n  $self->matrix_name($name) if defined $name;\n  if( defined $rownames && defined $colnames ) {\n      if( ref($rownames) !~ /ARRAY/i ) {\n\t  $self->throw(\"need an arrayref for the -rownames option\");\n      }\n      # insure we copy the values\n      $self->{'_rownames'} = [ @$rownames ];\n      my $count = 0;\n      %{$self->{'_rownamesmap'}} = map { $_ => $count++ } @$rownames; \n\n      if( ref($colnames) !~ /ARRAY/i ) {\n\t  $self->throw(\"need an arrayref for the -colnames option\");\n      }\n      # insure we copy the values\n      $self->{'_colnames'} = [ @$colnames ];\n      $count = 0;\n      %{$self->{'_colnamesmap'}} = map { $_ => $count++ } @$colnames; \n\n      $self->{'_values'} = [];\n      if( defined $values ) {\n\t  if( ref($values) !~ /ARRAY/i ) {\n\t      $self->throw(\"Need an arrayref of arrayrefs (matrix) for -values option\");\n\t  }\t  \n\t  for my $v ( @$values ) {\n\t      if( ref($v) !~ /ARRAY/i ) {\n\t\t  $self->throw(\"Need and array of arrayrefs (matrix) for -values option\");\n\t      }\n\t      push @{$self->{'_values'}}, [@$v];\n\t  }\n      } else {\n\t  my @fill = ($init_val) x scalar @$colnames; # undef init_val will be default\n\t  for ( @$rownames ) {\n\t      push @{$self->{'_values'}}, [@fill];\n\t  }\n      }\n  } elsif( ! defined $rownames && ! defined $colnames && ! defined $values ) {\n      $self->{'_values'}   = [];\n      $self->{'_rownames'} = [];\n      $self->{'_colnames'} = [];\n  } else { \n      $self->throw(\"Must have either provided no values/colnames/rownames or provided all three\");\n  }\n\n  return $self;\n}\n\n\n=head2 matrix_id\n\n Title   : matrix_id\n Usage   : my $id = $matrix->matrix_id\n Function: Get/Set the matrix ID\n Returns : scalar value\n Args    : [optional] new id value to store\n\n\n\nsub matrix_id{\n   my $self = shift;\n   return $self->{'_matid'} = shift if @_;\n   return $self->{'_matid'};\n\n   \n}\n\n=head2 matrix_name\n\n Title   : matrix_name\n Usage   : my $name = $matrix->matrix_name();\n Function: Get/Set the matrix name\n Returns : scalar value\n Args    : [optional] new matrix name value\n\n\n\nsub matrix_name{\n   my $self = shift;\n   return $self->{'_matname'} = shift if @_;\n   return $self->{'_matname'};\n}\n\n\n=head2 entry\n\n Title   : entry\n Usage   : my $entry = $matrix->entry($row,$col)\n Function: Get the value for a specific cell as specified\n           by the row and column names\n Returns : scalar value or undef if row or col does not\n           exist\n Args    : $rowname - name of the row\n           $colname - column name\n\n\nsub entry{\n   my ($self,$row,$column,$newvalue) = @_;\n   if( ! defined $row || ! defined $column ) {\n       $self->throw(\"Need at least 2 ids\");\n   }\n\n   my ($rownum) = $self->row_num_for_name($row);\n   my ($colnum) = $self->column_num_for_name($column);\n   return $self->entry_by_num($rownum,$colnum,$newvalue);\n}\n\n=head2 get_entry\n\n Title   : get_entry\n Usage   : my $entry = $matrix->get_entry($rowname,$columname)\n Function: Get the entry for a given row,column pair\n Returns : scalar\n Args    : $row name\n           $column name \n\n\n\nsub get_entry{ $_[0]->entry($_[1],$_[2]) }\n\n=head2 entry_by_num\n\n Title   : entry_by_num\n Usage   : my $entry = $matrix->entry_by_num($rownum,$colnum)\n Function: Get an entry by row and column numbers instead of by name\n           (rows and columns start at 0)\n Returns : scalar value or undef if row or column name does not\n           exist\n Args    : $row - row number\n           $col - column number\n           [optional] $newvalue to store at this cell\n\n\nsub entry_by_num {\n    my ($self,$row,$col,$newvalue) = @_;\n    if( ! defined $row || ! defined $col || \n\t$row !~ /^\\d+$/ ||\n\t$col !~ /^\\d+$/ ) {\n\t$self->warn(\"expected to get 2 number for entry_by_num\");\n\treturn;\n    }\n    \n    if( defined $newvalue ) {\n       return $self->_values->[$row][$col] = $newvalue;\n   } else { \n       return $self->_values->[$row][$col];\n   }\n}\n\nsub get_element { \n    my $self = shift;\n    $self->entry(@_);\n}\n\n\n=head2 column\n\n Title   : column\n Usage   : my @col = $matrix->column('ALPHA');\n           OR\n           $matrix->column('ALPHA', \\@col);\n Function: Get/Set a particular column\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values.  \n           For setting will warn if the new column is of a different\n           length from the rest of the columns.\n Args    : name of the column\n           [optional] new column to store here \n\n\nsub column{\n    my ($self,$column,$newcol) = @_;\n\n    if( ! defined $column ) {\n\t$self->warn(\"Need at least a column id\");\n\treturn;\n    }\n    my $colnum  = $self->column_num_for_name($column);\n    if( ! defined $colnum ) { \n\t$self->warn(\"could not find column number for $column\");\n\treturn;\n    }\n    return $self->column_by_num($colnum,$newcol);\n}\n\n\n=head2 get_column\n\n Title   : get_column\n Usage   : my @row = $matrix->get_column('ALPHA');\n Function: Get a particular column\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the column\n\n\n\nsub get_column { $_[0]->column($_[1]) }\n\n\n=head2 column_by_num\n\n Title   : column_by_num\n Usage   : my @col = $matrix->column_by_num(1);\n           OR\n           $matrix->column_by_num(1,\\@newcol);\n Function: Get/Set a column by its number instead of name\n           (cols/rows start at 0)\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the column\n           [optional] new value to store for a particular column\n\n\nsub column_by_num{\n    my ($self,$colnum,$newcol) = @_;\n    if( ! defined $colnum ) {\n\t$self->warn(\"need at least a column number\");\n\treturn;\n    }\n    my $rowcount = $self->num_rows;\n    my $colcount = $self->num_columns;\n    my $ret;\n    \n    if( defined $newcol ) {\n\tif( ref($newcol) !~ /ARRAY/i) {\n\t    $self->warn(\"expected a valid arrayref for resetting a column\");\n\t    return;\n\t}\n\tif( scalar @$newcol != $rowcount ) {\n\t    $self->warn(\"new column is not the correct length ($rowcount) - call add or remove row to shrink or grow the number of rows first\");\n\t    return;\n\t}\n\tfor(my $i=0; $i < $rowcount; $i++) {\n\t    $self->entry_by_num($i,$colnum,$newcol->[$i]);\n\t}\n\t$ret = $newcol;\n    } else { \n\t$ret = [];\n\tfor(my $i=0; $i < $rowcount; $i++) {\n\t    push @$ret,$self->entry_by_num($i,$colnum);\n\t}\n    }\n    if( wantarray ) { return @$ret } \n    return $ret;\n\n}\n\n=head2 row\n\n Title   : row\n Usage   : my @row = $matrix->row($rowname);\n             OR\n           $matrix->row($rowname,\\@rowvalues);\n Function: Get/Set the row of the matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n Args    : rowname\n           [optional] new value of row to store\n\n\n\nsub row {\n    my ($self,$row,$newrow) = @_;\n    if( ! defined $row) {\n\t$self->warn(\"Need at least a row id\");\n\treturn;\n    }\n    my $rownum = $self->row_num_for_name($row);\n    return $self->row_by_num($rownum,$newrow);\n}\n\n\n=head2 get_row\n\n Title   : get_row\n Usage   : my @row = $matrix->get_row('ALPHA');\n Function: Get a particular row\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the row\n\n\nsub get_row { $_[0]->row($_[1]) }\n\n=head2 row_by_num\n\n Title   : row_by_num\n Usage   : my @row = $matrix->row_by_num($rownum);\n             OR\n           $matrix->row($rownum,\\@rowvalues);\n Function: Get/Set the row of the matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n Args    : rowname\n           [optional] new value of row to store\n\n\nsub row_by_num{\n   my ($self,$rownum,$newrow) = @_;\n   if( ! defined $rownum ) {\n       $self->warn(\"need at least a row number\");\n       return;\n   }\n    my $colcount = $self->num_columns;\n    my $ret;\n    if( defined $newrow ) {\n\tif( ref($newrow) !~ /ARRAY/i) {\n\t    $self->warn(\"expected a valid arrayref for resetting a row\");\n\t    return;\n\t}\n\tif( scalar @$newrow != $colcount ) {\n\t    $self->warn(\"new row is not the correct length ($colcount) - call add or remove column to shrink or grow the number of columns first\");\n\t    return;\n\t}\n\tfor(my $i=0; $i < $colcount; $i++) {\n\t    $self->entry_by_num($rownum,$i, $newrow->[$i]);\n\t}\n\t$ret = $newrow;\n    } else { \n\t$ret = [];\n\tfor(my $i=0; $i < $colcount; $i++) {\n\t    # we're doing this to explicitly \n\t    # copy the entire row\n\t    push @$ret, $self->entry_by_num($rownum,$i);\n\t}\n    }\n    if( wantarray ) { return @$ret } \n    return $ret;\n\n\n}\n\n\n=head2 diagonal\n\n Title   : diagonal\n Usage   : my @diagonal = $matrix->get_diagonal()\n Function: Get the diagonal of a matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values which lie along the diagonal\n Args    : none\n\n\n\nsub get_diagonal{\n   my ($self) = @_;\n   my @diag;\n   my $rowcount = $self->num_rows;\n   my $colcount = $self->num_columns;\n   for(my $i = 0; $i < $rowcount; $i++ ) {\n       push @diag, $self->entry_by_num($i,$i);\n   }\n   return @diag;\n}\n\n\n=head2 add_row\n\n Title   : add_row\n Usage   : $matrix->add_row($index,\\@newrow);\n Function: Adds a row at particular location in the matrix.\n           If $index < the rowcount will shift all the rows down\n           by the number of new rows.\n           To add a single empty row, simply call\n           $matrix->add_row($index,undef);\n Returns : the updated number of total rows in the matrix\n Args    : index to store\n           name of the row (header)\n           newrow to add, if this is undef will add a single\n                     row with all values set to undef \n\n\nsub add_row{\n   my ($self,$index,$name,$newrow) = @_;\n   if( !defined $index || \n       $index !~ /^\\d+$/ ) {\n       $self->warn(\"expected a valid row index in add_row\");\n       return;\n   } elsif( ! defined $name) {\n       $self->warn(\"Need a row name or heading\");\n       return;\n   } elsif( defined $self->row_num_for_name($name) ) {\n       $self->warn(\"Need a unqiue name for the column heading, $name is already used\");\n       return;\n   }\n   my $colcount = $self->num_columns;\n   my $rowcount = $self->num_rows;\n\n   if( $index >  $rowcount ) { \n       $self->warn(\"cannot add a row beyond 1+last row at the end ($rowcount) not $index - adding at $rowcount instead\");\n       $index = $rowcount;\n   }\n\n   if( ! defined $newrow ) {\n       $newrow = [];\n       $newrow->[$colcount] = undef;\n   } elsif( ref($newrow) !~ /ARRAY/i ) {\n       $self->throw(\"Expected either undef or a valid arrayref for add_row\");\n   }\n   # add this row to the matrix by carving out space for it with \n   # splice\n   splice(@{$self->{'_values'}}, $index,0,[]);\n   for( my $i = 0; $i < $colcount; $i++ ) {\n       $self->entry_by_num($index,$i,$newrow->[$i]);\n   }\n   splice(@{$self->{'_rownames'}}, $index,0,$name);\n   # Sadly we have to remap these each time (except for the case\n   # when we're adding a new column to the end, but I don't think\n   # the speedup for that case warrants the extra code at this time.\n   my $ct = 0;\n   %{$self->{'_rownamesmap'}} = map { $_ => $ct++} @{$self->{'_rownames'}};\n   return $self->num_rows;\n}\n\n=head2 remove_row\n\n Title   : remove_row\n Usage   : $matrix->remove_row($colnum)\n Function: remove a row from the matrix shifting all the rows\n           up by one\n Returns : Updated number of rows in the matrix\n Args    : row index\n\n\n\nsub remove_row{\n   my ($self,$rowindex) = @_;\n   my $rowcount = $self->num_rows;\n   \n   if( $rowindex > $rowcount ) {\n       $self->warn(\"rowindex $rowindex is greater than number of rows $rowcount, cannot process\");\n       return 0;\n   } else { \n       splice(@{$self->_values},$rowindex,1);\n       delete $self->{'_rownamesmap'}->{$self->{'_rownames'}->[$rowindex]};\n       splice(@{$self->{'_rownames'}},$rowindex,1);\n   }\n   my $ct = 0;\n   %{$self->{'_rownamesmap'}} = map { $_ => $ct++} @{$self->{'_rownames'}};\n   return $self->num_rows;\n}\n\n=head2 add_column\n\n Title   : add_column\n Usage   : $matrix->add_column($index,$colname,\\@newcol);\n Function: Adds a column at particular location in the matrix.\n           If $index < the colcount will shift all the columns right\n           by the number of new columns.\n           To add a single empty column, simply call\n           $matrix->add_column($index,undef);\n Returns : the updated number of total columns in the matrix\n Args    : index to store\n           name of the column (header)\n           newcolumn to add, if this is undef will add a single\n                 column with all values set to undef ","parameters":[{"label":"$self"},{"label":"$index"},{"label":"$name"},{"label":"$newcol"}]},"line":586,"range":{"start":{"line":586,"character":0},"end":{"character":9999,"line":616}},"kind":12,"definition":"sub","detail":"($self,$index,$name,$newcol)","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"add_column","line":587},{"name":"$index","kind":13,"containerName":"add_column","line":587},{"line":587,"containerName":"add_column","kind":13,"name":"$name"},{"name":"$newcol","containerName":"add_column","kind":13,"line":587},{"line":588,"name":"$index","kind":13,"containerName":"add_column"},{"line":589,"containerName":"add_column","kind":13,"name":"$index"},{"name":"$self","kind":13,"containerName":"add_column","line":590},{"kind":12,"containerName":"add_column","name":"warn","line":590},{"line":592,"name":"$name","kind":13,"containerName":"add_column"},{"line":593,"name":"$self","kind":13,"containerName":"add_column"},{"name":"warn","containerName":"add_column","kind":12,"line":593},{"containerName":"add_column","kind":13,"name":"$self","line":595},{"line":595,"containerName":"add_column","kind":12,"name":"column_num_for_name"},{"name":"$name","kind":13,"containerName":"add_column","line":595},{"line":596,"containerName":"add_column","kind":13,"name":"$self"},{"kind":12,"containerName":"add_column","name":"warn","line":596},{"definition":"my","name":"$colcount","localvar":"my","containerName":"add_column","kind":13,"line":599},{"name":"$self","containerName":"add_column","kind":13,"line":599},{"line":599,"name":"num_columns","kind":12,"containerName":"add_column"},{"definition":"my","line":600,"containerName":"add_column","localvar":"my","kind":13,"name":"$rowcount"},{"containerName":"add_column","kind":13,"name":"$self","line":600},{"line":600,"name":"num_rows","containerName":"add_column","kind":12},{"line":601,"containerName":"add_column","kind":13,"name":"$index"},{"line":601,"name":"$colcount","kind":13,"containerName":"add_column"},{"name":"$self","containerName":"add_column","kind":13,"line":602},{"line":602,"name":"warn","kind":12,"containerName":"add_column"},{"line":603,"containerName":"add_column","kind":13,"name":"$index"},{"name":"$colcount","kind":13,"containerName":"add_column","line":603},{"kind":13,"containerName":"add_column","name":"$newcol","line":606},{"kind":13,"containerName":"add_column","name":"$newcol","line":607},{"name":"$newcol","containerName":"add_column","kind":13,"line":608},{"line":608,"containerName":"add_column","kind":13,"name":"$rowcount"},{"name":"$newcol","kind":13,"containerName":"add_column","line":609},{"name":"$self","kind":13,"containerName":"add_column","line":610},{"line":610,"name":"throw","containerName":"add_column","kind":12},{"line":612,"containerName":"add_column","localvar":"my","kind":13,"name":"$i","definition":"my"},{"containerName":"add_column","kind":13,"name":"$i","line":612},{"name":"$rowcount","containerName":"add_column","kind":13,"line":612},{"line":612,"name":"$i","kind":13,"containerName":"add_column"},{"line":614,"kind":13,"containerName":"add_column","name":"$self"},{"line":614,"name":"_values","containerName":"add_column","kind":12},{"line":614,"containerName":"add_column","kind":13,"name":"$i"},{"containerName":"add_column","kind":13,"name":"$index","line":614},{"line":615,"name":"$self","kind":13,"containerName":"add_column"},{"kind":12,"containerName":"add_column","name":"entry_by_num","line":615},{"line":615,"name":"$i","kind":13,"containerName":"add_column"},{"name":"$index","containerName":"add_column","kind":13,"line":615},{"line":615,"containerName":"add_column","kind":13,"name":"$newcol"},{"line":615,"name":"$i","containerName":"add_column","kind":13}],"name":"add_column","containerName":"main::"},{"kind":13,"containerName":null,"name":"%self","line":617},{"line":617,"name":"$index","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"$name","line":617},{"line":621,"containerName":null,"localvar":"my","kind":13,"name":"$ct","definition":"my"},{"name":"%self","kind":13,"containerName":null,"line":622},{"containerName":null,"kind":13,"name":"$ct","line":622},{"containerName":null,"kind":13,"name":"%self","line":622},{"containerName":null,"kind":13,"name":"$self","line":623},{"name":"num_columns","kind":12,"containerName":"main::","line":623},{"line":637,"range":{"end":{"line":650,"character":9999},"start":{"line":637,"character":0}},"kind":12,"signature":{"label":"remove_column($self,$colindex)","documentation":"1;\n# $Id: Generic.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Matrix::Generic\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::Generic - A generic matrix implementation\n\n=head1 SYNOPSIS\n\n  # A matrix has columns and rows \n  my $matrix = Bio::Matrix::Generic->new;\n  $matrix->add_column(1,$column1);\n  $matrix->add_column(2,$column2);\n\n  my $element = $matrix->entry_by_num(1,2);\n  $matrix->entry_by_num(1,2,$newval);\n\n  my $entry = $matrix->entry('human', 'mouse');\n\n  $matrix->entry('human','mouse', $newval);\n\n\n=head1 DESCRIPTION\n\nThis is a general purpose matrix object for dealing with row+column\ndata which is typical when enumerating all the pairwise combinations\nand desiring to get slices of the data.\n\nData can be accessed by column and row names or indexes.  Matrix\nindexes start at 0.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Matrix::Generic;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Matrix::MatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Matrix::Generic->new();\n Function: Builds a new Bio::Matrix::Generic object \n Returns : an instance of Bio::Matrix::Generic\n Args    : -values     => arrayref of arrayrefs of data initialization \n           -rownames   => arrayref of row names\n           -colnames   => arrayref of col names\n           -matrix_id  => id of the matrix\n           -matrix_name=> name of the matrix\n           -matrix_init_value => default value to initialize empty cells\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($values, $rownames, $colnames,\n      $id,$name,$init_val) = \n\t  $self->_rearrange([qw(VALUES ROWNAMES COLNAMES \n\t\t\t        MATRIX_ID MATRIX_NAME \n                                MATRIX_INIT_VALUE)],@args);\n  $self->matrix_id($id) if  defined $id;\n  $self->matrix_name($name) if defined $name;\n  if( defined $rownames && defined $colnames ) {\n      if( ref($rownames) !~ /ARRAY/i ) {\n\t  $self->throw(\"need an arrayref for the -rownames option\");\n      }\n      # insure we copy the values\n      $self->{'_rownames'} = [ @$rownames ];\n      my $count = 0;\n      %{$self->{'_rownamesmap'}} = map { $_ => $count++ } @$rownames; \n\n      if( ref($colnames) !~ /ARRAY/i ) {\n\t  $self->throw(\"need an arrayref for the -colnames option\");\n      }\n      # insure we copy the values\n      $self->{'_colnames'} = [ @$colnames ];\n      $count = 0;\n      %{$self->{'_colnamesmap'}} = map { $_ => $count++ } @$colnames; \n\n      $self->{'_values'} = [];\n      if( defined $values ) {\n\t  if( ref($values) !~ /ARRAY/i ) {\n\t      $self->throw(\"Need an arrayref of arrayrefs (matrix) for -values option\");\n\t  }\t  \n\t  for my $v ( @$values ) {\n\t      if( ref($v) !~ /ARRAY/i ) {\n\t\t  $self->throw(\"Need and array of arrayrefs (matrix) for -values option\");\n\t      }\n\t      push @{$self->{'_values'}}, [@$v];\n\t  }\n      } else {\n\t  my @fill = ($init_val) x scalar @$colnames; # undef init_val will be default\n\t  for ( @$rownames ) {\n\t      push @{$self->{'_values'}}, [@fill];\n\t  }\n      }\n  } elsif( ! defined $rownames && ! defined $colnames && ! defined $values ) {\n      $self->{'_values'}   = [];\n      $self->{'_rownames'} = [];\n      $self->{'_colnames'} = [];\n  } else { \n      $self->throw(\"Must have either provided no values/colnames/rownames or provided all three\");\n  }\n\n  return $self;\n}\n\n\n=head2 matrix_id\n\n Title   : matrix_id\n Usage   : my $id = $matrix->matrix_id\n Function: Get/Set the matrix ID\n Returns : scalar value\n Args    : [optional] new id value to store\n\n\n\nsub matrix_id{\n   my $self = shift;\n   return $self->{'_matid'} = shift if @_;\n   return $self->{'_matid'};\n\n   \n}\n\n=head2 matrix_name\n\n Title   : matrix_name\n Usage   : my $name = $matrix->matrix_name();\n Function: Get/Set the matrix name\n Returns : scalar value\n Args    : [optional] new matrix name value\n\n\n\nsub matrix_name{\n   my $self = shift;\n   return $self->{'_matname'} = shift if @_;\n   return $self->{'_matname'};\n}\n\n\n=head2 entry\n\n Title   : entry\n Usage   : my $entry = $matrix->entry($row,$col)\n Function: Get the value for a specific cell as specified\n           by the row and column names\n Returns : scalar value or undef if row or col does not\n           exist\n Args    : $rowname - name of the row\n           $colname - column name\n\n\nsub entry{\n   my ($self,$row,$column,$newvalue) = @_;\n   if( ! defined $row || ! defined $column ) {\n       $self->throw(\"Need at least 2 ids\");\n   }\n\n   my ($rownum) = $self->row_num_for_name($row);\n   my ($colnum) = $self->column_num_for_name($column);\n   return $self->entry_by_num($rownum,$colnum,$newvalue);\n}\n\n=head2 get_entry\n\n Title   : get_entry\n Usage   : my $entry = $matrix->get_entry($rowname,$columname)\n Function: Get the entry for a given row,column pair\n Returns : scalar\n Args    : $row name\n           $column name \n\n\n\nsub get_entry{ $_[0]->entry($_[1],$_[2]) }\n\n=head2 entry_by_num\n\n Title   : entry_by_num\n Usage   : my $entry = $matrix->entry_by_num($rownum,$colnum)\n Function: Get an entry by row and column numbers instead of by name\n           (rows and columns start at 0)\n Returns : scalar value or undef if row or column name does not\n           exist\n Args    : $row - row number\n           $col - column number\n           [optional] $newvalue to store at this cell\n\n\nsub entry_by_num {\n    my ($self,$row,$col,$newvalue) = @_;\n    if( ! defined $row || ! defined $col || \n\t$row !~ /^\\d+$/ ||\n\t$col !~ /^\\d+$/ ) {\n\t$self->warn(\"expected to get 2 number for entry_by_num\");\n\treturn;\n    }\n    \n    if( defined $newvalue ) {\n       return $self->_values->[$row][$col] = $newvalue;\n   } else { \n       return $self->_values->[$row][$col];\n   }\n}\n\nsub get_element { \n    my $self = shift;\n    $self->entry(@_);\n}\n\n\n=head2 column\n\n Title   : column\n Usage   : my @col = $matrix->column('ALPHA');\n           OR\n           $matrix->column('ALPHA', \\@col);\n Function: Get/Set a particular column\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values.  \n           For setting will warn if the new column is of a different\n           length from the rest of the columns.\n Args    : name of the column\n           [optional] new column to store here \n\n\nsub column{\n    my ($self,$column,$newcol) = @_;\n\n    if( ! defined $column ) {\n\t$self->warn(\"Need at least a column id\");\n\treturn;\n    }\n    my $colnum  = $self->column_num_for_name($column);\n    if( ! defined $colnum ) { \n\t$self->warn(\"could not find column number for $column\");\n\treturn;\n    }\n    return $self->column_by_num($colnum,$newcol);\n}\n\n\n=head2 get_column\n\n Title   : get_column\n Usage   : my @row = $matrix->get_column('ALPHA');\n Function: Get a particular column\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the column\n\n\n\nsub get_column { $_[0]->column($_[1]) }\n\n\n=head2 column_by_num\n\n Title   : column_by_num\n Usage   : my @col = $matrix->column_by_num(1);\n           OR\n           $matrix->column_by_num(1,\\@newcol);\n Function: Get/Set a column by its number instead of name\n           (cols/rows start at 0)\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the column\n           [optional] new value to store for a particular column\n\n\nsub column_by_num{\n    my ($self,$colnum,$newcol) = @_;\n    if( ! defined $colnum ) {\n\t$self->warn(\"need at least a column number\");\n\treturn;\n    }\n    my $rowcount = $self->num_rows;\n    my $colcount = $self->num_columns;\n    my $ret;\n    \n    if( defined $newcol ) {\n\tif( ref($newcol) !~ /ARRAY/i) {\n\t    $self->warn(\"expected a valid arrayref for resetting a column\");\n\t    return;\n\t}\n\tif( scalar @$newcol != $rowcount ) {\n\t    $self->warn(\"new column is not the correct length ($rowcount) - call add or remove row to shrink or grow the number of rows first\");\n\t    return;\n\t}\n\tfor(my $i=0; $i < $rowcount; $i++) {\n\t    $self->entry_by_num($i,$colnum,$newcol->[$i]);\n\t}\n\t$ret = $newcol;\n    } else { \n\t$ret = [];\n\tfor(my $i=0; $i < $rowcount; $i++) {\n\t    push @$ret,$self->entry_by_num($i,$colnum);\n\t}\n    }\n    if( wantarray ) { return @$ret } \n    return $ret;\n\n}\n\n=head2 row\n\n Title   : row\n Usage   : my @row = $matrix->row($rowname);\n             OR\n           $matrix->row($rowname,\\@rowvalues);\n Function: Get/Set the row of the matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n Args    : rowname\n           [optional] new value of row to store\n\n\n\nsub row {\n    my ($self,$row,$newrow) = @_;\n    if( ! defined $row) {\n\t$self->warn(\"Need at least a row id\");\n\treturn;\n    }\n    my $rownum = $self->row_num_for_name($row);\n    return $self->row_by_num($rownum,$newrow);\n}\n\n\n=head2 get_row\n\n Title   : get_row\n Usage   : my @row = $matrix->get_row('ALPHA');\n Function: Get a particular row\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the row\n\n\nsub get_row { $_[0]->row($_[1]) }\n\n=head2 row_by_num\n\n Title   : row_by_num\n Usage   : my @row = $matrix->row_by_num($rownum);\n             OR\n           $matrix->row($rownum,\\@rowvalues);\n Function: Get/Set the row of the matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n Args    : rowname\n           [optional] new value of row to store\n\n\nsub row_by_num{\n   my ($self,$rownum,$newrow) = @_;\n   if( ! defined $rownum ) {\n       $self->warn(\"need at least a row number\");\n       return;\n   }\n    my $colcount = $self->num_columns;\n    my $ret;\n    if( defined $newrow ) {\n\tif( ref($newrow) !~ /ARRAY/i) {\n\t    $self->warn(\"expected a valid arrayref for resetting a row\");\n\t    return;\n\t}\n\tif( scalar @$newrow != $colcount ) {\n\t    $self->warn(\"new row is not the correct length ($colcount) - call add or remove column to shrink or grow the number of columns first\");\n\t    return;\n\t}\n\tfor(my $i=0; $i < $colcount; $i++) {\n\t    $self->entry_by_num($rownum,$i, $newrow->[$i]);\n\t}\n\t$ret = $newrow;\n    } else { \n\t$ret = [];\n\tfor(my $i=0; $i < $colcount; $i++) {\n\t    # we're doing this to explicitly \n\t    # copy the entire row\n\t    push @$ret, $self->entry_by_num($rownum,$i);\n\t}\n    }\n    if( wantarray ) { return @$ret } \n    return $ret;\n\n\n}\n\n\n=head2 diagonal\n\n Title   : diagonal\n Usage   : my @diagonal = $matrix->get_diagonal()\n Function: Get the diagonal of a matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values which lie along the diagonal\n Args    : none\n\n\n\nsub get_diagonal{\n   my ($self) = @_;\n   my @diag;\n   my $rowcount = $self->num_rows;\n   my $colcount = $self->num_columns;\n   for(my $i = 0; $i < $rowcount; $i++ ) {\n       push @diag, $self->entry_by_num($i,$i);\n   }\n   return @diag;\n}\n\n\n=head2 add_row\n\n Title   : add_row\n Usage   : $matrix->add_row($index,\\@newrow);\n Function: Adds a row at particular location in the matrix.\n           If $index < the rowcount will shift all the rows down\n           by the number of new rows.\n           To add a single empty row, simply call\n           $matrix->add_row($index,undef);\n Returns : the updated number of total rows in the matrix\n Args    : index to store\n           name of the row (header)\n           newrow to add, if this is undef will add a single\n                     row with all values set to undef \n\n\nsub add_row{\n   my ($self,$index,$name,$newrow) = @_;\n   if( !defined $index || \n       $index !~ /^\\d+$/ ) {\n       $self->warn(\"expected a valid row index in add_row\");\n       return;\n   } elsif( ! defined $name) {\n       $self->warn(\"Need a row name or heading\");\n       return;\n   } elsif( defined $self->row_num_for_name($name) ) {\n       $self->warn(\"Need a unqiue name for the column heading, $name is already used\");\n       return;\n   }\n   my $colcount = $self->num_columns;\n   my $rowcount = $self->num_rows;\n\n   if( $index >  $rowcount ) { \n       $self->warn(\"cannot add a row beyond 1+last row at the end ($rowcount) not $index - adding at $rowcount instead\");\n       $index = $rowcount;\n   }\n\n   if( ! defined $newrow ) {\n       $newrow = [];\n       $newrow->[$colcount] = undef;\n   } elsif( ref($newrow) !~ /ARRAY/i ) {\n       $self->throw(\"Expected either undef or a valid arrayref for add_row\");\n   }\n   # add this row to the matrix by carving out space for it with \n   # splice\n   splice(@{$self->{'_values'}}, $index,0,[]);\n   for( my $i = 0; $i < $colcount; $i++ ) {\n       $self->entry_by_num($index,$i,$newrow->[$i]);\n   }\n   splice(@{$self->{'_rownames'}}, $index,0,$name);\n   # Sadly we have to remap these each time (except for the case\n   # when we're adding a new column to the end, but I don't think\n   # the speedup for that case warrants the extra code at this time.\n   my $ct = 0;\n   %{$self->{'_rownamesmap'}} = map { $_ => $ct++} @{$self->{'_rownames'}};\n   return $self->num_rows;\n}\n\n=head2 remove_row\n\n Title   : remove_row\n Usage   : $matrix->remove_row($colnum)\n Function: remove a row from the matrix shifting all the rows\n           up by one\n Returns : Updated number of rows in the matrix\n Args    : row index\n\n\n\nsub remove_row{\n   my ($self,$rowindex) = @_;\n   my $rowcount = $self->num_rows;\n   \n   if( $rowindex > $rowcount ) {\n       $self->warn(\"rowindex $rowindex is greater than number of rows $rowcount, cannot process\");\n       return 0;\n   } else { \n       splice(@{$self->_values},$rowindex,1);\n       delete $self->{'_rownamesmap'}->{$self->{'_rownames'}->[$rowindex]};\n       splice(@{$self->{'_rownames'}},$rowindex,1);\n   }\n   my $ct = 0;\n   %{$self->{'_rownamesmap'}} = map { $_ => $ct++} @{$self->{'_rownames'}};\n   return $self->num_rows;\n}\n\n=head2 add_column\n\n Title   : add_column\n Usage   : $matrix->add_column($index,$colname,\\@newcol);\n Function: Adds a column at particular location in the matrix.\n           If $index < the colcount will shift all the columns right\n           by the number of new columns.\n           To add a single empty column, simply call\n           $matrix->add_column($index,undef);\n Returns : the updated number of total columns in the matrix\n Args    : index to store\n           name of the column (header)\n           newcolumn to add, if this is undef will add a single\n                 column with all values set to undef \n\n\n\n\nsub add_column{\n   my ($self,$index,$name,$newcol) = @_;\n   if( !defined $index ||\n       $index !~ /^\\d+$/ ) {\n       $self->warn(\"expected a valid col index in add_column\");\n       return;\n   } elsif( ! defined $name) {\n       $self->warn(\"Need a column name or heading\");\n       return;\n   } elsif( defined $self->column_num_for_name($name) ) {\n       $self->warn(\"Need a unqiue name for the column heading, $name is already used\");\n       return;\n   }\n   my $colcount = $self->num_columns;\n   my $rowcount = $self->num_rows;\n   if( $index > $colcount ) { \n       $self->warn(\"cannot add a column beyond 1+last column at the end ($colcount) not $index - adding at $colcount instead\");\n       $index = $colcount;\n   }\n\n   if( ! defined $newcol ) {\n       $newcol = [];\n       $newcol->[$rowcount] = undef; # make the array '$rowcount' long\n   } elsif( ref($newcol) !~ /ARRAY/i ) {\n       $self->throw(\"Expected either undef or a valid arrayref for add_row\");\n   }\n   for( my $i = 0; $i < $rowcount; $i++ ) {\n       # add this column to each row\n       splice(@{$self->_values->[$i]},$index,0,[]);\n       $self->entry_by_num($i,$index,$newcol->[$i]);\n   }\n   splice(@{$self->{'_colnames'}}, $index,0,$name);\n   # Sadly we have to remap these each time (except for the case\n   # when we're adding a new column to the end, but I don't think\n   # the speedup for that case warrants the extra code at this time.\n   my $ct = 0;\n   %{$self->{'_colnamesmap'}} = map {$_ => $ct++} @{$self->{'_colnames'}};\n   return $self->num_columns;\n}\n\n=head2 remove_column\n\n Title   : remove_column\n Usage   : $matrix->remove_column($colnum)\n Function: remove a column from the matrix shifting all the columns\n           to the left by one\n Returns : Updated number of columns in the matrix\n Args    : column index","parameters":[{"label":"$self"},{"label":"$colindex"}]},"children":[{"line":638,"name":"$self","localvar":"my","kind":13,"containerName":"remove_column","definition":"my"},{"line":638,"name":"$colindex","kind":13,"containerName":"remove_column"},{"definition":"my","kind":13,"localvar":"my","containerName":"remove_column","name":"$colcount","line":640},{"line":640,"kind":13,"containerName":"remove_column","name":"$self"},{"line":640,"name":"num_columns","containerName":"remove_column","kind":12},{"definition":"my","line":641,"name":"$rowcount","localvar":"my","containerName":"remove_column","kind":13},{"kind":13,"containerName":"remove_column","name":"$self","line":641},{"name":"num_rows","containerName":"remove_column","kind":12,"line":641},{"line":642,"name":"$colindex","kind":13,"containerName":"remove_column"},{"name":"$colcount","containerName":"remove_column","kind":13,"line":642},{"line":643,"name":"$self","containerName":"remove_column","kind":13},{"name":"warn","containerName":"remove_column","kind":12,"line":643},{"definition":"my","localvar":"my","kind":13,"containerName":"remove_column","name":"$i","line":646},{"name":"$i","kind":13,"containerName":"remove_column","line":646},{"line":646,"containerName":"remove_column","kind":13,"name":"$rowcount"},{"name":"$i","containerName":"remove_column","kind":13,"line":646},{"containerName":"remove_column","kind":13,"name":"$self","line":647},{"name":"_values","kind":12,"containerName":"remove_column","line":647},{"line":647,"containerName":"remove_column","kind":13,"name":"$i"},{"line":647,"name":"$colindex","kind":13,"containerName":"remove_column"},{"line":649,"containerName":"remove_column","kind":13,"name":"$self"},{"line":649,"name":"$self","kind":13,"containerName":"remove_column"},{"kind":13,"containerName":"remove_column","name":"$colindex","line":649},{"kind":13,"containerName":"remove_column","name":"$self","line":650}],"containerName":"main::","name":"remove_column","definition":"sub","detail":"($self,$colindex)"},{"name":"$colindex","containerName":null,"kind":13,"line":650},{"definition":"my","name":"$ct","localvar":"my","kind":13,"containerName":null,"line":652},{"name":"%self","containerName":null,"kind":13,"line":653},{"line":653,"name":"$ct","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"%self","line":653},{"line":654,"name":"$self","containerName":null,"kind":13},{"name":"num_columns","kind":12,"containerName":"main::","line":654},{"detail":"($self,$name)","definition":"sub","containerName":"main::","name":"column_num_for_name","children":[{"definition":"my","name":"$self","containerName":"column_num_for_name","localvar":"my","kind":13,"line":669},{"line":669,"kind":13,"containerName":"column_num_for_name","name":"$name"},{"line":671,"containerName":"column_num_for_name","kind":13,"name":"$self"},{"containerName":"column_num_for_name","kind":13,"name":"$name","line":671}],"signature":{"parameters":[{"label":"$self"},{"label":"$name"}],"documentation":"1;\n# $Id: Generic.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Matrix::Generic\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::Generic - A generic matrix implementation\n\n=head1 SYNOPSIS\n\n  # A matrix has columns and rows \n  my $matrix = Bio::Matrix::Generic->new;\n  $matrix->add_column(1,$column1);\n  $matrix->add_column(2,$column2);\n\n  my $element = $matrix->entry_by_num(1,2);\n  $matrix->entry_by_num(1,2,$newval);\n\n  my $entry = $matrix->entry('human', 'mouse');\n\n  $matrix->entry('human','mouse', $newval);\n\n\n=head1 DESCRIPTION\n\nThis is a general purpose matrix object for dealing with row+column\ndata which is typical when enumerating all the pairwise combinations\nand desiring to get slices of the data.\n\nData can be accessed by column and row names or indexes.  Matrix\nindexes start at 0.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Matrix::Generic;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Matrix::MatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Matrix::Generic->new();\n Function: Builds a new Bio::Matrix::Generic object \n Returns : an instance of Bio::Matrix::Generic\n Args    : -values     => arrayref of arrayrefs of data initialization \n           -rownames   => arrayref of row names\n           -colnames   => arrayref of col names\n           -matrix_id  => id of the matrix\n           -matrix_name=> name of the matrix\n           -matrix_init_value => default value to initialize empty cells\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($values, $rownames, $colnames,\n      $id,$name,$init_val) = \n\t  $self->_rearrange([qw(VALUES ROWNAMES COLNAMES \n\t\t\t        MATRIX_ID MATRIX_NAME \n                                MATRIX_INIT_VALUE)],@args);\n  $self->matrix_id($id) if  defined $id;\n  $self->matrix_name($name) if defined $name;\n  if( defined $rownames && defined $colnames ) {\n      if( ref($rownames) !~ /ARRAY/i ) {\n\t  $self->throw(\"need an arrayref for the -rownames option\");\n      }\n      # insure we copy the values\n      $self->{'_rownames'} = [ @$rownames ];\n      my $count = 0;\n      %{$self->{'_rownamesmap'}} = map { $_ => $count++ } @$rownames; \n\n      if( ref($colnames) !~ /ARRAY/i ) {\n\t  $self->throw(\"need an arrayref for the -colnames option\");\n      }\n      # insure we copy the values\n      $self->{'_colnames'} = [ @$colnames ];\n      $count = 0;\n      %{$self->{'_colnamesmap'}} = map { $_ => $count++ } @$colnames; \n\n      $self->{'_values'} = [];\n      if( defined $values ) {\n\t  if( ref($values) !~ /ARRAY/i ) {\n\t      $self->throw(\"Need an arrayref of arrayrefs (matrix) for -values option\");\n\t  }\t  \n\t  for my $v ( @$values ) {\n\t      if( ref($v) !~ /ARRAY/i ) {\n\t\t  $self->throw(\"Need and array of arrayrefs (matrix) for -values option\");\n\t      }\n\t      push @{$self->{'_values'}}, [@$v];\n\t  }\n      } else {\n\t  my @fill = ($init_val) x scalar @$colnames; # undef init_val will be default\n\t  for ( @$rownames ) {\n\t      push @{$self->{'_values'}}, [@fill];\n\t  }\n      }\n  } elsif( ! defined $rownames && ! defined $colnames && ! defined $values ) {\n      $self->{'_values'}   = [];\n      $self->{'_rownames'} = [];\n      $self->{'_colnames'} = [];\n  } else { \n      $self->throw(\"Must have either provided no values/colnames/rownames or provided all three\");\n  }\n\n  return $self;\n}\n\n\n=head2 matrix_id\n\n Title   : matrix_id\n Usage   : my $id = $matrix->matrix_id\n Function: Get/Set the matrix ID\n Returns : scalar value\n Args    : [optional] new id value to store\n\n\n\nsub matrix_id{\n   my $self = shift;\n   return $self->{'_matid'} = shift if @_;\n   return $self->{'_matid'};\n\n   \n}\n\n=head2 matrix_name\n\n Title   : matrix_name\n Usage   : my $name = $matrix->matrix_name();\n Function: Get/Set the matrix name\n Returns : scalar value\n Args    : [optional] new matrix name value\n\n\n\nsub matrix_name{\n   my $self = shift;\n   return $self->{'_matname'} = shift if @_;\n   return $self->{'_matname'};\n}\n\n\n=head2 entry\n\n Title   : entry\n Usage   : my $entry = $matrix->entry($row,$col)\n Function: Get the value for a specific cell as specified\n           by the row and column names\n Returns : scalar value or undef if row or col does not\n           exist\n Args    : $rowname - name of the row\n           $colname - column name\n\n\nsub entry{\n   my ($self,$row,$column,$newvalue) = @_;\n   if( ! defined $row || ! defined $column ) {\n       $self->throw(\"Need at least 2 ids\");\n   }\n\n   my ($rownum) = $self->row_num_for_name($row);\n   my ($colnum) = $self->column_num_for_name($column);\n   return $self->entry_by_num($rownum,$colnum,$newvalue);\n}\n\n=head2 get_entry\n\n Title   : get_entry\n Usage   : my $entry = $matrix->get_entry($rowname,$columname)\n Function: Get the entry for a given row,column pair\n Returns : scalar\n Args    : $row name\n           $column name \n\n\n\nsub get_entry{ $_[0]->entry($_[1],$_[2]) }\n\n=head2 entry_by_num\n\n Title   : entry_by_num\n Usage   : my $entry = $matrix->entry_by_num($rownum,$colnum)\n Function: Get an entry by row and column numbers instead of by name\n           (rows and columns start at 0)\n Returns : scalar value or undef if row or column name does not\n           exist\n Args    : $row - row number\n           $col - column number\n           [optional] $newvalue to store at this cell\n\n\nsub entry_by_num {\n    my ($self,$row,$col,$newvalue) = @_;\n    if( ! defined $row || ! defined $col || \n\t$row !~ /^\\d+$/ ||\n\t$col !~ /^\\d+$/ ) {\n\t$self->warn(\"expected to get 2 number for entry_by_num\");\n\treturn;\n    }\n    \n    if( defined $newvalue ) {\n       return $self->_values->[$row][$col] = $newvalue;\n   } else { \n       return $self->_values->[$row][$col];\n   }\n}\n\nsub get_element { \n    my $self = shift;\n    $self->entry(@_);\n}\n\n\n=head2 column\n\n Title   : column\n Usage   : my @col = $matrix->column('ALPHA');\n           OR\n           $matrix->column('ALPHA', \\@col);\n Function: Get/Set a particular column\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values.  \n           For setting will warn if the new column is of a different\n           length from the rest of the columns.\n Args    : name of the column\n           [optional] new column to store here \n\n\nsub column{\n    my ($self,$column,$newcol) = @_;\n\n    if( ! defined $column ) {\n\t$self->warn(\"Need at least a column id\");\n\treturn;\n    }\n    my $colnum  = $self->column_num_for_name($column);\n    if( ! defined $colnum ) { \n\t$self->warn(\"could not find column number for $column\");\n\treturn;\n    }\n    return $self->column_by_num($colnum,$newcol);\n}\n\n\n=head2 get_column\n\n Title   : get_column\n Usage   : my @row = $matrix->get_column('ALPHA');\n Function: Get a particular column\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the column\n\n\n\nsub get_column { $_[0]->column($_[1]) }\n\n\n=head2 column_by_num\n\n Title   : column_by_num\n Usage   : my @col = $matrix->column_by_num(1);\n           OR\n           $matrix->column_by_num(1,\\@newcol);\n Function: Get/Set a column by its number instead of name\n           (cols/rows start at 0)\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the column\n           [optional] new value to store for a particular column\n\n\nsub column_by_num{\n    my ($self,$colnum,$newcol) = @_;\n    if( ! defined $colnum ) {\n\t$self->warn(\"need at least a column number\");\n\treturn;\n    }\n    my $rowcount = $self->num_rows;\n    my $colcount = $self->num_columns;\n    my $ret;\n    \n    if( defined $newcol ) {\n\tif( ref($newcol) !~ /ARRAY/i) {\n\t    $self->warn(\"expected a valid arrayref for resetting a column\");\n\t    return;\n\t}\n\tif( scalar @$newcol != $rowcount ) {\n\t    $self->warn(\"new column is not the correct length ($rowcount) - call add or remove row to shrink or grow the number of rows first\");\n\t    return;\n\t}\n\tfor(my $i=0; $i < $rowcount; $i++) {\n\t    $self->entry_by_num($i,$colnum,$newcol->[$i]);\n\t}\n\t$ret = $newcol;\n    } else { \n\t$ret = [];\n\tfor(my $i=0; $i < $rowcount; $i++) {\n\t    push @$ret,$self->entry_by_num($i,$colnum);\n\t}\n    }\n    if( wantarray ) { return @$ret } \n    return $ret;\n\n}\n\n=head2 row\n\n Title   : row\n Usage   : my @row = $matrix->row($rowname);\n             OR\n           $matrix->row($rowname,\\@rowvalues);\n Function: Get/Set the row of the matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n Args    : rowname\n           [optional] new value of row to store\n\n\n\nsub row {\n    my ($self,$row,$newrow) = @_;\n    if( ! defined $row) {\n\t$self->warn(\"Need at least a row id\");\n\treturn;\n    }\n    my $rownum = $self->row_num_for_name($row);\n    return $self->row_by_num($rownum,$newrow);\n}\n\n\n=head2 get_row\n\n Title   : get_row\n Usage   : my @row = $matrix->get_row('ALPHA');\n Function: Get a particular row\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the row\n\n\nsub get_row { $_[0]->row($_[1]) }\n\n=head2 row_by_num\n\n Title   : row_by_num\n Usage   : my @row = $matrix->row_by_num($rownum);\n             OR\n           $matrix->row($rownum,\\@rowvalues);\n Function: Get/Set the row of the matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n Args    : rowname\n           [optional] new value of row to store\n\n\nsub row_by_num{\n   my ($self,$rownum,$newrow) = @_;\n   if( ! defined $rownum ) {\n       $self->warn(\"need at least a row number\");\n       return;\n   }\n    my $colcount = $self->num_columns;\n    my $ret;\n    if( defined $newrow ) {\n\tif( ref($newrow) !~ /ARRAY/i) {\n\t    $self->warn(\"expected a valid arrayref for resetting a row\");\n\t    return;\n\t}\n\tif( scalar @$newrow != $colcount ) {\n\t    $self->warn(\"new row is not the correct length ($colcount) - call add or remove column to shrink or grow the number of columns first\");\n\t    return;\n\t}\n\tfor(my $i=0; $i < $colcount; $i++) {\n\t    $self->entry_by_num($rownum,$i, $newrow->[$i]);\n\t}\n\t$ret = $newrow;\n    } else { \n\t$ret = [];\n\tfor(my $i=0; $i < $colcount; $i++) {\n\t    # we're doing this to explicitly \n\t    # copy the entire row\n\t    push @$ret, $self->entry_by_num($rownum,$i);\n\t}\n    }\n    if( wantarray ) { return @$ret } \n    return $ret;\n\n\n}\n\n\n=head2 diagonal\n\n Title   : diagonal\n Usage   : my @diagonal = $matrix->get_diagonal()\n Function: Get the diagonal of a matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values which lie along the diagonal\n Args    : none\n\n\n\nsub get_diagonal{\n   my ($self) = @_;\n   my @diag;\n   my $rowcount = $self->num_rows;\n   my $colcount = $self->num_columns;\n   for(my $i = 0; $i < $rowcount; $i++ ) {\n       push @diag, $self->entry_by_num($i,$i);\n   }\n   return @diag;\n}\n\n\n=head2 add_row\n\n Title   : add_row\n Usage   : $matrix->add_row($index,\\@newrow);\n Function: Adds a row at particular location in the matrix.\n           If $index < the rowcount will shift all the rows down\n           by the number of new rows.\n           To add a single empty row, simply call\n           $matrix->add_row($index,undef);\n Returns : the updated number of total rows in the matrix\n Args    : index to store\n           name of the row (header)\n           newrow to add, if this is undef will add a single\n                     row with all values set to undef \n\n\nsub add_row{\n   my ($self,$index,$name,$newrow) = @_;\n   if( !defined $index || \n       $index !~ /^\\d+$/ ) {\n       $self->warn(\"expected a valid row index in add_row\");\n       return;\n   } elsif( ! defined $name) {\n       $self->warn(\"Need a row name or heading\");\n       return;\n   } elsif( defined $self->row_num_for_name($name) ) {\n       $self->warn(\"Need a unqiue name for the column heading, $name is already used\");\n       return;\n   }\n   my $colcount = $self->num_columns;\n   my $rowcount = $self->num_rows;\n\n   if( $index >  $rowcount ) { \n       $self->warn(\"cannot add a row beyond 1+last row at the end ($rowcount) not $index - adding at $rowcount instead\");\n       $index = $rowcount;\n   }\n\n   if( ! defined $newrow ) {\n       $newrow = [];\n       $newrow->[$colcount] = undef;\n   } elsif( ref($newrow) !~ /ARRAY/i ) {\n       $self->throw(\"Expected either undef or a valid arrayref for add_row\");\n   }\n   # add this row to the matrix by carving out space for it with \n   # splice\n   splice(@{$self->{'_values'}}, $index,0,[]);\n   for( my $i = 0; $i < $colcount; $i++ ) {\n       $self->entry_by_num($index,$i,$newrow->[$i]);\n   }\n   splice(@{$self->{'_rownames'}}, $index,0,$name);\n   # Sadly we have to remap these each time (except for the case\n   # when we're adding a new column to the end, but I don't think\n   # the speedup for that case warrants the extra code at this time.\n   my $ct = 0;\n   %{$self->{'_rownamesmap'}} = map { $_ => $ct++} @{$self->{'_rownames'}};\n   return $self->num_rows;\n}\n\n=head2 remove_row\n\n Title   : remove_row\n Usage   : $matrix->remove_row($colnum)\n Function: remove a row from the matrix shifting all the rows\n           up by one\n Returns : Updated number of rows in the matrix\n Args    : row index\n\n\n\nsub remove_row{\n   my ($self,$rowindex) = @_;\n   my $rowcount = $self->num_rows;\n   \n   if( $rowindex > $rowcount ) {\n       $self->warn(\"rowindex $rowindex is greater than number of rows $rowcount, cannot process\");\n       return 0;\n   } else { \n       splice(@{$self->_values},$rowindex,1);\n       delete $self->{'_rownamesmap'}->{$self->{'_rownames'}->[$rowindex]};\n       splice(@{$self->{'_rownames'}},$rowindex,1);\n   }\n   my $ct = 0;\n   %{$self->{'_rownamesmap'}} = map { $_ => $ct++} @{$self->{'_rownames'}};\n   return $self->num_rows;\n}\n\n=head2 add_column\n\n Title   : add_column\n Usage   : $matrix->add_column($index,$colname,\\@newcol);\n Function: Adds a column at particular location in the matrix.\n           If $index < the colcount will shift all the columns right\n           by the number of new columns.\n           To add a single empty column, simply call\n           $matrix->add_column($index,undef);\n Returns : the updated number of total columns in the matrix\n Args    : index to store\n           name of the column (header)\n           newcolumn to add, if this is undef will add a single\n                 column with all values set to undef \n\n\n\n\nsub add_column{\n   my ($self,$index,$name,$newcol) = @_;\n   if( !defined $index ||\n       $index !~ /^\\d+$/ ) {\n       $self->warn(\"expected a valid col index in add_column\");\n       return;\n   } elsif( ! defined $name) {\n       $self->warn(\"Need a column name or heading\");\n       return;\n   } elsif( defined $self->column_num_for_name($name) ) {\n       $self->warn(\"Need a unqiue name for the column heading, $name is already used\");\n       return;\n   }\n   my $colcount = $self->num_columns;\n   my $rowcount = $self->num_rows;\n   if( $index > $colcount ) { \n       $self->warn(\"cannot add a column beyond 1+last column at the end ($colcount) not $index - adding at $colcount instead\");\n       $index = $colcount;\n   }\n\n   if( ! defined $newcol ) {\n       $newcol = [];\n       $newcol->[$rowcount] = undef; # make the array '$rowcount' long\n   } elsif( ref($newcol) !~ /ARRAY/i ) {\n       $self->throw(\"Expected either undef or a valid arrayref for add_row\");\n   }\n   for( my $i = 0; $i < $rowcount; $i++ ) {\n       # add this column to each row\n       splice(@{$self->_values->[$i]},$index,0,[]);\n       $self->entry_by_num($i,$index,$newcol->[$i]);\n   }\n   splice(@{$self->{'_colnames'}}, $index,0,$name);\n   # Sadly we have to remap these each time (except for the case\n   # when we're adding a new column to the end, but I don't think\n   # the speedup for that case warrants the extra code at this time.\n   my $ct = 0;\n   %{$self->{'_colnamesmap'}} = map {$_ => $ct++} @{$self->{'_colnames'}};\n   return $self->num_columns;\n}\n\n=head2 remove_column\n\n Title   : remove_column\n Usage   : $matrix->remove_column($colnum)\n Function: remove a column from the matrix shifting all the columns\n           to the left by one\n Returns : Updated number of columns in the matrix\n Args    : column index\n\n\nsub remove_column{\n   my ($self,$colindex) = @_;\n\n   my $colcount = $self->num_columns;\n   my $rowcount = $self->num_rows;\n   if( $colindex > $colcount ) {\n\t\t$self->warn(\"colindex $colindex is greater than number of columns ($colcount), cannot process\");\n\t\treturn 0;\n   } else { \n\t\tfor(my $i = 0; $i < $rowcount; $i++ ) {\n\t\t\tsplice(@{$self->_values->[$i]},$colindex,1);\n\t\t}\n\t\tdelete $self->{'_colnamesmap'}->{$self->{'_colnames'}->[$colindex]};\n\t\tsplice(@{$self->{'_colnames'}},$colindex,1);\n   }\n   my $ct = 0;\n   %{$self->{'_colnamesmap'}} = map {$_ => $ct++} @{$self->{'_colnames'}};\n   return $self->num_columns;\n}\n\n=head2 column_num_for_name\n\n Title   : column_num_for_name\n Usage   : my $num = $matrix->column_num_for_name($name)\n Function: Gets the column number for a particular column name\n Returns : integer\n Args    : string","label":"column_num_for_name($self,$name)"},"range":{"start":{"character":0,"line":668},"end":{"character":9999,"line":672}},"kind":12,"line":668},{"kind":12,"range":{"start":{"line":685,"character":0},"end":{"character":9999,"line":688}},"line":685,"signature":{"label":"row_num_for_name($self,$name)","parameters":[{"label":"$self"},{"label":"$name"}],"documentation":"1;\n# $Id: Generic.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Matrix::Generic\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::Generic - A generic matrix implementation\n\n=head1 SYNOPSIS\n\n  # A matrix has columns and rows \n  my $matrix = Bio::Matrix::Generic->new;\n  $matrix->add_column(1,$column1);\n  $matrix->add_column(2,$column2);\n\n  my $element = $matrix->entry_by_num(1,2);\n  $matrix->entry_by_num(1,2,$newval);\n\n  my $entry = $matrix->entry('human', 'mouse');\n\n  $matrix->entry('human','mouse', $newval);\n\n\n=head1 DESCRIPTION\n\nThis is a general purpose matrix object for dealing with row+column\ndata which is typical when enumerating all the pairwise combinations\nand desiring to get slices of the data.\n\nData can be accessed by column and row names or indexes.  Matrix\nindexes start at 0.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Matrix::Generic;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Matrix::MatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Matrix::Generic->new();\n Function: Builds a new Bio::Matrix::Generic object \n Returns : an instance of Bio::Matrix::Generic\n Args    : -values     => arrayref of arrayrefs of data initialization \n           -rownames   => arrayref of row names\n           -colnames   => arrayref of col names\n           -matrix_id  => id of the matrix\n           -matrix_name=> name of the matrix\n           -matrix_init_value => default value to initialize empty cells\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($values, $rownames, $colnames,\n      $id,$name,$init_val) = \n\t  $self->_rearrange([qw(VALUES ROWNAMES COLNAMES \n\t\t\t        MATRIX_ID MATRIX_NAME \n                                MATRIX_INIT_VALUE)],@args);\n  $self->matrix_id($id) if  defined $id;\n  $self->matrix_name($name) if defined $name;\n  if( defined $rownames && defined $colnames ) {\n      if( ref($rownames) !~ /ARRAY/i ) {\n\t  $self->throw(\"need an arrayref for the -rownames option\");\n      }\n      # insure we copy the values\n      $self->{'_rownames'} = [ @$rownames ];\n      my $count = 0;\n      %{$self->{'_rownamesmap'}} = map { $_ => $count++ } @$rownames; \n\n      if( ref($colnames) !~ /ARRAY/i ) {\n\t  $self->throw(\"need an arrayref for the -colnames option\");\n      }\n      # insure we copy the values\n      $self->{'_colnames'} = [ @$colnames ];\n      $count = 0;\n      %{$self->{'_colnamesmap'}} = map { $_ => $count++ } @$colnames; \n\n      $self->{'_values'} = [];\n      if( defined $values ) {\n\t  if( ref($values) !~ /ARRAY/i ) {\n\t      $self->throw(\"Need an arrayref of arrayrefs (matrix) for -values option\");\n\t  }\t  \n\t  for my $v ( @$values ) {\n\t      if( ref($v) !~ /ARRAY/i ) {\n\t\t  $self->throw(\"Need and array of arrayrefs (matrix) for -values option\");\n\t      }\n\t      push @{$self->{'_values'}}, [@$v];\n\t  }\n      } else {\n\t  my @fill = ($init_val) x scalar @$colnames; # undef init_val will be default\n\t  for ( @$rownames ) {\n\t      push @{$self->{'_values'}}, [@fill];\n\t  }\n      }\n  } elsif( ! defined $rownames && ! defined $colnames && ! defined $values ) {\n      $self->{'_values'}   = [];\n      $self->{'_rownames'} = [];\n      $self->{'_colnames'} = [];\n  } else { \n      $self->throw(\"Must have either provided no values/colnames/rownames or provided all three\");\n  }\n\n  return $self;\n}\n\n\n=head2 matrix_id\n\n Title   : matrix_id\n Usage   : my $id = $matrix->matrix_id\n Function: Get/Set the matrix ID\n Returns : scalar value\n Args    : [optional] new id value to store\n\n\n\nsub matrix_id{\n   my $self = shift;\n   return $self->{'_matid'} = shift if @_;\n   return $self->{'_matid'};\n\n   \n}\n\n=head2 matrix_name\n\n Title   : matrix_name\n Usage   : my $name = $matrix->matrix_name();\n Function: Get/Set the matrix name\n Returns : scalar value\n Args    : [optional] new matrix name value\n\n\n\nsub matrix_name{\n   my $self = shift;\n   return $self->{'_matname'} = shift if @_;\n   return $self->{'_matname'};\n}\n\n\n=head2 entry\n\n Title   : entry\n Usage   : my $entry = $matrix->entry($row,$col)\n Function: Get the value for a specific cell as specified\n           by the row and column names\n Returns : scalar value or undef if row or col does not\n           exist\n Args    : $rowname - name of the row\n           $colname - column name\n\n\nsub entry{\n   my ($self,$row,$column,$newvalue) = @_;\n   if( ! defined $row || ! defined $column ) {\n       $self->throw(\"Need at least 2 ids\");\n   }\n\n   my ($rownum) = $self->row_num_for_name($row);\n   my ($colnum) = $self->column_num_for_name($column);\n   return $self->entry_by_num($rownum,$colnum,$newvalue);\n}\n\n=head2 get_entry\n\n Title   : get_entry\n Usage   : my $entry = $matrix->get_entry($rowname,$columname)\n Function: Get the entry for a given row,column pair\n Returns : scalar\n Args    : $row name\n           $column name \n\n\n\nsub get_entry{ $_[0]->entry($_[1],$_[2]) }\n\n=head2 entry_by_num\n\n Title   : entry_by_num\n Usage   : my $entry = $matrix->entry_by_num($rownum,$colnum)\n Function: Get an entry by row and column numbers instead of by name\n           (rows and columns start at 0)\n Returns : scalar value or undef if row or column name does not\n           exist\n Args    : $row - row number\n           $col - column number\n           [optional] $newvalue to store at this cell\n\n\nsub entry_by_num {\n    my ($self,$row,$col,$newvalue) = @_;\n    if( ! defined $row || ! defined $col || \n\t$row !~ /^\\d+$/ ||\n\t$col !~ /^\\d+$/ ) {\n\t$self->warn(\"expected to get 2 number for entry_by_num\");\n\treturn;\n    }\n    \n    if( defined $newvalue ) {\n       return $self->_values->[$row][$col] = $newvalue;\n   } else { \n       return $self->_values->[$row][$col];\n   }\n}\n\nsub get_element { \n    my $self = shift;\n    $self->entry(@_);\n}\n\n\n=head2 column\n\n Title   : column\n Usage   : my @col = $matrix->column('ALPHA');\n           OR\n           $matrix->column('ALPHA', \\@col);\n Function: Get/Set a particular column\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values.  \n           For setting will warn if the new column is of a different\n           length from the rest of the columns.\n Args    : name of the column\n           [optional] new column to store here \n\n\nsub column{\n    my ($self,$column,$newcol) = @_;\n\n    if( ! defined $column ) {\n\t$self->warn(\"Need at least a column id\");\n\treturn;\n    }\n    my $colnum  = $self->column_num_for_name($column);\n    if( ! defined $colnum ) { \n\t$self->warn(\"could not find column number for $column\");\n\treturn;\n    }\n    return $self->column_by_num($colnum,$newcol);\n}\n\n\n=head2 get_column\n\n Title   : get_column\n Usage   : my @row = $matrix->get_column('ALPHA');\n Function: Get a particular column\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the column\n\n\n\nsub get_column { $_[0]->column($_[1]) }\n\n\n=head2 column_by_num\n\n Title   : column_by_num\n Usage   : my @col = $matrix->column_by_num(1);\n           OR\n           $matrix->column_by_num(1,\\@newcol);\n Function: Get/Set a column by its number instead of name\n           (cols/rows start at 0)\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the column\n           [optional] new value to store for a particular column\n\n\nsub column_by_num{\n    my ($self,$colnum,$newcol) = @_;\n    if( ! defined $colnum ) {\n\t$self->warn(\"need at least a column number\");\n\treturn;\n    }\n    my $rowcount = $self->num_rows;\n    my $colcount = $self->num_columns;\n    my $ret;\n    \n    if( defined $newcol ) {\n\tif( ref($newcol) !~ /ARRAY/i) {\n\t    $self->warn(\"expected a valid arrayref for resetting a column\");\n\t    return;\n\t}\n\tif( scalar @$newcol != $rowcount ) {\n\t    $self->warn(\"new column is not the correct length ($rowcount) - call add or remove row to shrink or grow the number of rows first\");\n\t    return;\n\t}\n\tfor(my $i=0; $i < $rowcount; $i++) {\n\t    $self->entry_by_num($i,$colnum,$newcol->[$i]);\n\t}\n\t$ret = $newcol;\n    } else { \n\t$ret = [];\n\tfor(my $i=0; $i < $rowcount; $i++) {\n\t    push @$ret,$self->entry_by_num($i,$colnum);\n\t}\n    }\n    if( wantarray ) { return @$ret } \n    return $ret;\n\n}\n\n=head2 row\n\n Title   : row\n Usage   : my @row = $matrix->row($rowname);\n             OR\n           $matrix->row($rowname,\\@rowvalues);\n Function: Get/Set the row of the matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n Args    : rowname\n           [optional] new value of row to store\n\n\n\nsub row {\n    my ($self,$row,$newrow) = @_;\n    if( ! defined $row) {\n\t$self->warn(\"Need at least a row id\");\n\treturn;\n    }\n    my $rownum = $self->row_num_for_name($row);\n    return $self->row_by_num($rownum,$newrow);\n}\n\n\n=head2 get_row\n\n Title   : get_row\n Usage   : my @row = $matrix->get_row('ALPHA');\n Function: Get a particular row\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the row\n\n\nsub get_row { $_[0]->row($_[1]) }\n\n=head2 row_by_num\n\n Title   : row_by_num\n Usage   : my @row = $matrix->row_by_num($rownum);\n             OR\n           $matrix->row($rownum,\\@rowvalues);\n Function: Get/Set the row of the matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n Args    : rowname\n           [optional] new value of row to store\n\n\nsub row_by_num{\n   my ($self,$rownum,$newrow) = @_;\n   if( ! defined $rownum ) {\n       $self->warn(\"need at least a row number\");\n       return;\n   }\n    my $colcount = $self->num_columns;\n    my $ret;\n    if( defined $newrow ) {\n\tif( ref($newrow) !~ /ARRAY/i) {\n\t    $self->warn(\"expected a valid arrayref for resetting a row\");\n\t    return;\n\t}\n\tif( scalar @$newrow != $colcount ) {\n\t    $self->warn(\"new row is not the correct length ($colcount) - call add or remove column to shrink or grow the number of columns first\");\n\t    return;\n\t}\n\tfor(my $i=0; $i < $colcount; $i++) {\n\t    $self->entry_by_num($rownum,$i, $newrow->[$i]);\n\t}\n\t$ret = $newrow;\n    } else { \n\t$ret = [];\n\tfor(my $i=0; $i < $colcount; $i++) {\n\t    # we're doing this to explicitly \n\t    # copy the entire row\n\t    push @$ret, $self->entry_by_num($rownum,$i);\n\t}\n    }\n    if( wantarray ) { return @$ret } \n    return $ret;\n\n\n}\n\n\n=head2 diagonal\n\n Title   : diagonal\n Usage   : my @diagonal = $matrix->get_diagonal()\n Function: Get the diagonal of a matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values which lie along the diagonal\n Args    : none\n\n\n\nsub get_diagonal{\n   my ($self) = @_;\n   my @diag;\n   my $rowcount = $self->num_rows;\n   my $colcount = $self->num_columns;\n   for(my $i = 0; $i < $rowcount; $i++ ) {\n       push @diag, $self->entry_by_num($i,$i);\n   }\n   return @diag;\n}\n\n\n=head2 add_row\n\n Title   : add_row\n Usage   : $matrix->add_row($index,\\@newrow);\n Function: Adds a row at particular location in the matrix.\n           If $index < the rowcount will shift all the rows down\n           by the number of new rows.\n           To add a single empty row, simply call\n           $matrix->add_row($index,undef);\n Returns : the updated number of total rows in the matrix\n Args    : index to store\n           name of the row (header)\n           newrow to add, if this is undef will add a single\n                     row with all values set to undef \n\n\nsub add_row{\n   my ($self,$index,$name,$newrow) = @_;\n   if( !defined $index || \n       $index !~ /^\\d+$/ ) {\n       $self->warn(\"expected a valid row index in add_row\");\n       return;\n   } elsif( ! defined $name) {\n       $self->warn(\"Need a row name or heading\");\n       return;\n   } elsif( defined $self->row_num_for_name($name) ) {\n       $self->warn(\"Need a unqiue name for the column heading, $name is already used\");\n       return;\n   }\n   my $colcount = $self->num_columns;\n   my $rowcount = $self->num_rows;\n\n   if( $index >  $rowcount ) { \n       $self->warn(\"cannot add a row beyond 1+last row at the end ($rowcount) not $index - adding at $rowcount instead\");\n       $index = $rowcount;\n   }\n\n   if( ! defined $newrow ) {\n       $newrow = [];\n       $newrow->[$colcount] = undef;\n   } elsif( ref($newrow) !~ /ARRAY/i ) {\n       $self->throw(\"Expected either undef or a valid arrayref for add_row\");\n   }\n   # add this row to the matrix by carving out space for it with \n   # splice\n   splice(@{$self->{'_values'}}, $index,0,[]);\n   for( my $i = 0; $i < $colcount; $i++ ) {\n       $self->entry_by_num($index,$i,$newrow->[$i]);\n   }\n   splice(@{$self->{'_rownames'}}, $index,0,$name);\n   # Sadly we have to remap these each time (except for the case\n   # when we're adding a new column to the end, but I don't think\n   # the speedup for that case warrants the extra code at this time.\n   my $ct = 0;\n   %{$self->{'_rownamesmap'}} = map { $_ => $ct++} @{$self->{'_rownames'}};\n   return $self->num_rows;\n}\n\n=head2 remove_row\n\n Title   : remove_row\n Usage   : $matrix->remove_row($colnum)\n Function: remove a row from the matrix shifting all the rows\n           up by one\n Returns : Updated number of rows in the matrix\n Args    : row index\n\n\n\nsub remove_row{\n   my ($self,$rowindex) = @_;\n   my $rowcount = $self->num_rows;\n   \n   if( $rowindex > $rowcount ) {\n       $self->warn(\"rowindex $rowindex is greater than number of rows $rowcount, cannot process\");\n       return 0;\n   } else { \n       splice(@{$self->_values},$rowindex,1);\n       delete $self->{'_rownamesmap'}->{$self->{'_rownames'}->[$rowindex]};\n       splice(@{$self->{'_rownames'}},$rowindex,1);\n   }\n   my $ct = 0;\n   %{$self->{'_rownamesmap'}} = map { $_ => $ct++} @{$self->{'_rownames'}};\n   return $self->num_rows;\n}\n\n=head2 add_column\n\n Title   : add_column\n Usage   : $matrix->add_column($index,$colname,\\@newcol);\n Function: Adds a column at particular location in the matrix.\n           If $index < the colcount will shift all the columns right\n           by the number of new columns.\n           To add a single empty column, simply call\n           $matrix->add_column($index,undef);\n Returns : the updated number of total columns in the matrix\n Args    : index to store\n           name of the column (header)\n           newcolumn to add, if this is undef will add a single\n                 column with all values set to undef \n\n\n\n\nsub add_column{\n   my ($self,$index,$name,$newcol) = @_;\n   if( !defined $index ||\n       $index !~ /^\\d+$/ ) {\n       $self->warn(\"expected a valid col index in add_column\");\n       return;\n   } elsif( ! defined $name) {\n       $self->warn(\"Need a column name or heading\");\n       return;\n   } elsif( defined $self->column_num_for_name($name) ) {\n       $self->warn(\"Need a unqiue name for the column heading, $name is already used\");\n       return;\n   }\n   my $colcount = $self->num_columns;\n   my $rowcount = $self->num_rows;\n   if( $index > $colcount ) { \n       $self->warn(\"cannot add a column beyond 1+last column at the end ($colcount) not $index - adding at $colcount instead\");\n       $index = $colcount;\n   }\n\n   if( ! defined $newcol ) {\n       $newcol = [];\n       $newcol->[$rowcount] = undef; # make the array '$rowcount' long\n   } elsif( ref($newcol) !~ /ARRAY/i ) {\n       $self->throw(\"Expected either undef or a valid arrayref for add_row\");\n   }\n   for( my $i = 0; $i < $rowcount; $i++ ) {\n       # add this column to each row\n       splice(@{$self->_values->[$i]},$index,0,[]);\n       $self->entry_by_num($i,$index,$newcol->[$i]);\n   }\n   splice(@{$self->{'_colnames'}}, $index,0,$name);\n   # Sadly we have to remap these each time (except for the case\n   # when we're adding a new column to the end, but I don't think\n   # the speedup for that case warrants the extra code at this time.\n   my $ct = 0;\n   %{$self->{'_colnamesmap'}} = map {$_ => $ct++} @{$self->{'_colnames'}};\n   return $self->num_columns;\n}\n\n=head2 remove_column\n\n Title   : remove_column\n Usage   : $matrix->remove_column($colnum)\n Function: remove a column from the matrix shifting all the columns\n           to the left by one\n Returns : Updated number of columns in the matrix\n Args    : column index\n\n\nsub remove_column{\n   my ($self,$colindex) = @_;\n\n   my $colcount = $self->num_columns;\n   my $rowcount = $self->num_rows;\n   if( $colindex > $colcount ) {\n\t\t$self->warn(\"colindex $colindex is greater than number of columns ($colcount), cannot process\");\n\t\treturn 0;\n   } else { \n\t\tfor(my $i = 0; $i < $rowcount; $i++ ) {\n\t\t\tsplice(@{$self->_values->[$i]},$colindex,1);\n\t\t}\n\t\tdelete $self->{'_colnamesmap'}->{$self->{'_colnames'}->[$colindex]};\n\t\tsplice(@{$self->{'_colnames'}},$colindex,1);\n   }\n   my $ct = 0;\n   %{$self->{'_colnamesmap'}} = map {$_ => $ct++} @{$self->{'_colnames'}};\n   return $self->num_columns;\n}\n\n=head2 column_num_for_name\n\n Title   : column_num_for_name\n Usage   : my $num = $matrix->column_num_for_name($name)\n Function: Gets the column number for a particular column name\n Returns : integer\n Args    : string\n\n\n\nsub column_num_for_name{\n   my ($self,$name) = @_;\n   \n   return $self->{'_colnamesmap'}->{$name};\n}\n\n=head2 row_num_for_name\n\n Title   : row_num_for_name\n Usage   : my $num = $matrix->row_num_for_name\n Function: Gets the row number for a particular row name\n Returns : integer\n Args    : string"},"name":"row_num_for_name","containerName":"main::","children":[{"name":"$self","containerName":"row_num_for_name","localvar":"my","kind":13,"line":686,"definition":"my"},{"containerName":"row_num_for_name","kind":13,"name":"$name","line":686},{"line":687,"kind":13,"containerName":"row_num_for_name","name":"$self"},{"line":687,"name":"$name","containerName":"row_num_for_name","kind":13}],"detail":"($self,$name)","definition":"sub"},{"name":"column_header","containerName":"main::","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"column_header","name":"$self","line":703},{"name":"$num","containerName":"column_header","kind":13,"line":703},{"kind":13,"containerName":"column_header","name":"$self","line":704},{"name":"$num","kind":13,"containerName":"column_header","line":704}],"detail":"($self,$num)","definition":"sub","kind":12,"range":{"start":{"line":702,"character":0},"end":{"character":9999,"line":705}},"line":702,"signature":{"label":"column_header($self,$num)","documentation":"1;\n# $Id: Generic.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Matrix::Generic\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::Generic - A generic matrix implementation\n\n=head1 SYNOPSIS\n\n  # A matrix has columns and rows \n  my $matrix = Bio::Matrix::Generic->new;\n  $matrix->add_column(1,$column1);\n  $matrix->add_column(2,$column2);\n\n  my $element = $matrix->entry_by_num(1,2);\n  $matrix->entry_by_num(1,2,$newval);\n\n  my $entry = $matrix->entry('human', 'mouse');\n\n  $matrix->entry('human','mouse', $newval);\n\n\n=head1 DESCRIPTION\n\nThis is a general purpose matrix object for dealing with row+column\ndata which is typical when enumerating all the pairwise combinations\nand desiring to get slices of the data.\n\nData can be accessed by column and row names or indexes.  Matrix\nindexes start at 0.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Matrix::Generic;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Matrix::MatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Matrix::Generic->new();\n Function: Builds a new Bio::Matrix::Generic object \n Returns : an instance of Bio::Matrix::Generic\n Args    : -values     => arrayref of arrayrefs of data initialization \n           -rownames   => arrayref of row names\n           -colnames   => arrayref of col names\n           -matrix_id  => id of the matrix\n           -matrix_name=> name of the matrix\n           -matrix_init_value => default value to initialize empty cells\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($values, $rownames, $colnames,\n      $id,$name,$init_val) = \n\t  $self->_rearrange([qw(VALUES ROWNAMES COLNAMES \n\t\t\t        MATRIX_ID MATRIX_NAME \n                                MATRIX_INIT_VALUE)],@args);\n  $self->matrix_id($id) if  defined $id;\n  $self->matrix_name($name) if defined $name;\n  if( defined $rownames && defined $colnames ) {\n      if( ref($rownames) !~ /ARRAY/i ) {\n\t  $self->throw(\"need an arrayref for the -rownames option\");\n      }\n      # insure we copy the values\n      $self->{'_rownames'} = [ @$rownames ];\n      my $count = 0;\n      %{$self->{'_rownamesmap'}} = map { $_ => $count++ } @$rownames; \n\n      if( ref($colnames) !~ /ARRAY/i ) {\n\t  $self->throw(\"need an arrayref for the -colnames option\");\n      }\n      # insure we copy the values\n      $self->{'_colnames'} = [ @$colnames ];\n      $count = 0;\n      %{$self->{'_colnamesmap'}} = map { $_ => $count++ } @$colnames; \n\n      $self->{'_values'} = [];\n      if( defined $values ) {\n\t  if( ref($values) !~ /ARRAY/i ) {\n\t      $self->throw(\"Need an arrayref of arrayrefs (matrix) for -values option\");\n\t  }\t  \n\t  for my $v ( @$values ) {\n\t      if( ref($v) !~ /ARRAY/i ) {\n\t\t  $self->throw(\"Need and array of arrayrefs (matrix) for -values option\");\n\t      }\n\t      push @{$self->{'_values'}}, [@$v];\n\t  }\n      } else {\n\t  my @fill = ($init_val) x scalar @$colnames; # undef init_val will be default\n\t  for ( @$rownames ) {\n\t      push @{$self->{'_values'}}, [@fill];\n\t  }\n      }\n  } elsif( ! defined $rownames && ! defined $colnames && ! defined $values ) {\n      $self->{'_values'}   = [];\n      $self->{'_rownames'} = [];\n      $self->{'_colnames'} = [];\n  } else { \n      $self->throw(\"Must have either provided no values/colnames/rownames or provided all three\");\n  }\n\n  return $self;\n}\n\n\n=head2 matrix_id\n\n Title   : matrix_id\n Usage   : my $id = $matrix->matrix_id\n Function: Get/Set the matrix ID\n Returns : scalar value\n Args    : [optional] new id value to store\n\n\n\nsub matrix_id{\n   my $self = shift;\n   return $self->{'_matid'} = shift if @_;\n   return $self->{'_matid'};\n\n   \n}\n\n=head2 matrix_name\n\n Title   : matrix_name\n Usage   : my $name = $matrix->matrix_name();\n Function: Get/Set the matrix name\n Returns : scalar value\n Args    : [optional] new matrix name value\n\n\n\nsub matrix_name{\n   my $self = shift;\n   return $self->{'_matname'} = shift if @_;\n   return $self->{'_matname'};\n}\n\n\n=head2 entry\n\n Title   : entry\n Usage   : my $entry = $matrix->entry($row,$col)\n Function: Get the value for a specific cell as specified\n           by the row and column names\n Returns : scalar value or undef if row or col does not\n           exist\n Args    : $rowname - name of the row\n           $colname - column name\n\n\nsub entry{\n   my ($self,$row,$column,$newvalue) = @_;\n   if( ! defined $row || ! defined $column ) {\n       $self->throw(\"Need at least 2 ids\");\n   }\n\n   my ($rownum) = $self->row_num_for_name($row);\n   my ($colnum) = $self->column_num_for_name($column);\n   return $self->entry_by_num($rownum,$colnum,$newvalue);\n}\n\n=head2 get_entry\n\n Title   : get_entry\n Usage   : my $entry = $matrix->get_entry($rowname,$columname)\n Function: Get the entry for a given row,column pair\n Returns : scalar\n Args    : $row name\n           $column name \n\n\n\nsub get_entry{ $_[0]->entry($_[1],$_[2]) }\n\n=head2 entry_by_num\n\n Title   : entry_by_num\n Usage   : my $entry = $matrix->entry_by_num($rownum,$colnum)\n Function: Get an entry by row and column numbers instead of by name\n           (rows and columns start at 0)\n Returns : scalar value or undef if row or column name does not\n           exist\n Args    : $row - row number\n           $col - column number\n           [optional] $newvalue to store at this cell\n\n\nsub entry_by_num {\n    my ($self,$row,$col,$newvalue) = @_;\n    if( ! defined $row || ! defined $col || \n\t$row !~ /^\\d+$/ ||\n\t$col !~ /^\\d+$/ ) {\n\t$self->warn(\"expected to get 2 number for entry_by_num\");\n\treturn;\n    }\n    \n    if( defined $newvalue ) {\n       return $self->_values->[$row][$col] = $newvalue;\n   } else { \n       return $self->_values->[$row][$col];\n   }\n}\n\nsub get_element { \n    my $self = shift;\n    $self->entry(@_);\n}\n\n\n=head2 column\n\n Title   : column\n Usage   : my @col = $matrix->column('ALPHA');\n           OR\n           $matrix->column('ALPHA', \\@col);\n Function: Get/Set a particular column\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values.  \n           For setting will warn if the new column is of a different\n           length from the rest of the columns.\n Args    : name of the column\n           [optional] new column to store here \n\n\nsub column{\n    my ($self,$column,$newcol) = @_;\n\n    if( ! defined $column ) {\n\t$self->warn(\"Need at least a column id\");\n\treturn;\n    }\n    my $colnum  = $self->column_num_for_name($column);\n    if( ! defined $colnum ) { \n\t$self->warn(\"could not find column number for $column\");\n\treturn;\n    }\n    return $self->column_by_num($colnum,$newcol);\n}\n\n\n=head2 get_column\n\n Title   : get_column\n Usage   : my @row = $matrix->get_column('ALPHA');\n Function: Get a particular column\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the column\n\n\n\nsub get_column { $_[0]->column($_[1]) }\n\n\n=head2 column_by_num\n\n Title   : column_by_num\n Usage   : my @col = $matrix->column_by_num(1);\n           OR\n           $matrix->column_by_num(1,\\@newcol);\n Function: Get/Set a column by its number instead of name\n           (cols/rows start at 0)\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the column\n           [optional] new value to store for a particular column\n\n\nsub column_by_num{\n    my ($self,$colnum,$newcol) = @_;\n    if( ! defined $colnum ) {\n\t$self->warn(\"need at least a column number\");\n\treturn;\n    }\n    my $rowcount = $self->num_rows;\n    my $colcount = $self->num_columns;\n    my $ret;\n    \n    if( defined $newcol ) {\n\tif( ref($newcol) !~ /ARRAY/i) {\n\t    $self->warn(\"expected a valid arrayref for resetting a column\");\n\t    return;\n\t}\n\tif( scalar @$newcol != $rowcount ) {\n\t    $self->warn(\"new column is not the correct length ($rowcount) - call add or remove row to shrink or grow the number of rows first\");\n\t    return;\n\t}\n\tfor(my $i=0; $i < $rowcount; $i++) {\n\t    $self->entry_by_num($i,$colnum,$newcol->[$i]);\n\t}\n\t$ret = $newcol;\n    } else { \n\t$ret = [];\n\tfor(my $i=0; $i < $rowcount; $i++) {\n\t    push @$ret,$self->entry_by_num($i,$colnum);\n\t}\n    }\n    if( wantarray ) { return @$ret } \n    return $ret;\n\n}\n\n=head2 row\n\n Title   : row\n Usage   : my @row = $matrix->row($rowname);\n             OR\n           $matrix->row($rowname,\\@rowvalues);\n Function: Get/Set the row of the matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n Args    : rowname\n           [optional] new value of row to store\n\n\n\nsub row {\n    my ($self,$row,$newrow) = @_;\n    if( ! defined $row) {\n\t$self->warn(\"Need at least a row id\");\n\treturn;\n    }\n    my $rownum = $self->row_num_for_name($row);\n    return $self->row_by_num($rownum,$newrow);\n}\n\n\n=head2 get_row\n\n Title   : get_row\n Usage   : my @row = $matrix->get_row('ALPHA');\n Function: Get a particular row\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the row\n\n\nsub get_row { $_[0]->row($_[1]) }\n\n=head2 row_by_num\n\n Title   : row_by_num\n Usage   : my @row = $matrix->row_by_num($rownum);\n             OR\n           $matrix->row($rownum,\\@rowvalues);\n Function: Get/Set the row of the matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n Args    : rowname\n           [optional] new value of row to store\n\n\nsub row_by_num{\n   my ($self,$rownum,$newrow) = @_;\n   if( ! defined $rownum ) {\n       $self->warn(\"need at least a row number\");\n       return;\n   }\n    my $colcount = $self->num_columns;\n    my $ret;\n    if( defined $newrow ) {\n\tif( ref($newrow) !~ /ARRAY/i) {\n\t    $self->warn(\"expected a valid arrayref for resetting a row\");\n\t    return;\n\t}\n\tif( scalar @$newrow != $colcount ) {\n\t    $self->warn(\"new row is not the correct length ($colcount) - call add or remove column to shrink or grow the number of columns first\");\n\t    return;\n\t}\n\tfor(my $i=0; $i < $colcount; $i++) {\n\t    $self->entry_by_num($rownum,$i, $newrow->[$i]);\n\t}\n\t$ret = $newrow;\n    } else { \n\t$ret = [];\n\tfor(my $i=0; $i < $colcount; $i++) {\n\t    # we're doing this to explicitly \n\t    # copy the entire row\n\t    push @$ret, $self->entry_by_num($rownum,$i);\n\t}\n    }\n    if( wantarray ) { return @$ret } \n    return $ret;\n\n\n}\n\n\n=head2 diagonal\n\n Title   : diagonal\n Usage   : my @diagonal = $matrix->get_diagonal()\n Function: Get the diagonal of a matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values which lie along the diagonal\n Args    : none\n\n\n\nsub get_diagonal{\n   my ($self) = @_;\n   my @diag;\n   my $rowcount = $self->num_rows;\n   my $colcount = $self->num_columns;\n   for(my $i = 0; $i < $rowcount; $i++ ) {\n       push @diag, $self->entry_by_num($i,$i);\n   }\n   return @diag;\n}\n\n\n=head2 add_row\n\n Title   : add_row\n Usage   : $matrix->add_row($index,\\@newrow);\n Function: Adds a row at particular location in the matrix.\n           If $index < the rowcount will shift all the rows down\n           by the number of new rows.\n           To add a single empty row, simply call\n           $matrix->add_row($index,undef);\n Returns : the updated number of total rows in the matrix\n Args    : index to store\n           name of the row (header)\n           newrow to add, if this is undef will add a single\n                     row with all values set to undef \n\n\nsub add_row{\n   my ($self,$index,$name,$newrow) = @_;\n   if( !defined $index || \n       $index !~ /^\\d+$/ ) {\n       $self->warn(\"expected a valid row index in add_row\");\n       return;\n   } elsif( ! defined $name) {\n       $self->warn(\"Need a row name or heading\");\n       return;\n   } elsif( defined $self->row_num_for_name($name) ) {\n       $self->warn(\"Need a unqiue name for the column heading, $name is already used\");\n       return;\n   }\n   my $colcount = $self->num_columns;\n   my $rowcount = $self->num_rows;\n\n   if( $index >  $rowcount ) { \n       $self->warn(\"cannot add a row beyond 1+last row at the end ($rowcount) not $index - adding at $rowcount instead\");\n       $index = $rowcount;\n   }\n\n   if( ! defined $newrow ) {\n       $newrow = [];\n       $newrow->[$colcount] = undef;\n   } elsif( ref($newrow) !~ /ARRAY/i ) {\n       $self->throw(\"Expected either undef or a valid arrayref for add_row\");\n   }\n   # add this row to the matrix by carving out space for it with \n   # splice\n   splice(@{$self->{'_values'}}, $index,0,[]);\n   for( my $i = 0; $i < $colcount; $i++ ) {\n       $self->entry_by_num($index,$i,$newrow->[$i]);\n   }\n   splice(@{$self->{'_rownames'}}, $index,0,$name);\n   # Sadly we have to remap these each time (except for the case\n   # when we're adding a new column to the end, but I don't think\n   # the speedup for that case warrants the extra code at this time.\n   my $ct = 0;\n   %{$self->{'_rownamesmap'}} = map { $_ => $ct++} @{$self->{'_rownames'}};\n   return $self->num_rows;\n}\n\n=head2 remove_row\n\n Title   : remove_row\n Usage   : $matrix->remove_row($colnum)\n Function: remove a row from the matrix shifting all the rows\n           up by one\n Returns : Updated number of rows in the matrix\n Args    : row index\n\n\n\nsub remove_row{\n   my ($self,$rowindex) = @_;\n   my $rowcount = $self->num_rows;\n   \n   if( $rowindex > $rowcount ) {\n       $self->warn(\"rowindex $rowindex is greater than number of rows $rowcount, cannot process\");\n       return 0;\n   } else { \n       splice(@{$self->_values},$rowindex,1);\n       delete $self->{'_rownamesmap'}->{$self->{'_rownames'}->[$rowindex]};\n       splice(@{$self->{'_rownames'}},$rowindex,1);\n   }\n   my $ct = 0;\n   %{$self->{'_rownamesmap'}} = map { $_ => $ct++} @{$self->{'_rownames'}};\n   return $self->num_rows;\n}\n\n=head2 add_column\n\n Title   : add_column\n Usage   : $matrix->add_column($index,$colname,\\@newcol);\n Function: Adds a column at particular location in the matrix.\n           If $index < the colcount will shift all the columns right\n           by the number of new columns.\n           To add a single empty column, simply call\n           $matrix->add_column($index,undef);\n Returns : the updated number of total columns in the matrix\n Args    : index to store\n           name of the column (header)\n           newcolumn to add, if this is undef will add a single\n                 column with all values set to undef \n\n\n\n\nsub add_column{\n   my ($self,$index,$name,$newcol) = @_;\n   if( !defined $index ||\n       $index !~ /^\\d+$/ ) {\n       $self->warn(\"expected a valid col index in add_column\");\n       return;\n   } elsif( ! defined $name) {\n       $self->warn(\"Need a column name or heading\");\n       return;\n   } elsif( defined $self->column_num_for_name($name) ) {\n       $self->warn(\"Need a unqiue name for the column heading, $name is already used\");\n       return;\n   }\n   my $colcount = $self->num_columns;\n   my $rowcount = $self->num_rows;\n   if( $index > $colcount ) { \n       $self->warn(\"cannot add a column beyond 1+last column at the end ($colcount) not $index - adding at $colcount instead\");\n       $index = $colcount;\n   }\n\n   if( ! defined $newcol ) {\n       $newcol = [];\n       $newcol->[$rowcount] = undef; # make the array '$rowcount' long\n   } elsif( ref($newcol) !~ /ARRAY/i ) {\n       $self->throw(\"Expected either undef or a valid arrayref for add_row\");\n   }\n   for( my $i = 0; $i < $rowcount; $i++ ) {\n       # add this column to each row\n       splice(@{$self->_values->[$i]},$index,0,[]);\n       $self->entry_by_num($i,$index,$newcol->[$i]);\n   }\n   splice(@{$self->{'_colnames'}}, $index,0,$name);\n   # Sadly we have to remap these each time (except for the case\n   # when we're adding a new column to the end, but I don't think\n   # the speedup for that case warrants the extra code at this time.\n   my $ct = 0;\n   %{$self->{'_colnamesmap'}} = map {$_ => $ct++} @{$self->{'_colnames'}};\n   return $self->num_columns;\n}\n\n=head2 remove_column\n\n Title   : remove_column\n Usage   : $matrix->remove_column($colnum)\n Function: remove a column from the matrix shifting all the columns\n           to the left by one\n Returns : Updated number of columns in the matrix\n Args    : column index\n\n\nsub remove_column{\n   my ($self,$colindex) = @_;\n\n   my $colcount = $self->num_columns;\n   my $rowcount = $self->num_rows;\n   if( $colindex > $colcount ) {\n\t\t$self->warn(\"colindex $colindex is greater than number of columns ($colcount), cannot process\");\n\t\treturn 0;\n   } else { \n\t\tfor(my $i = 0; $i < $rowcount; $i++ ) {\n\t\t\tsplice(@{$self->_values->[$i]},$colindex,1);\n\t\t}\n\t\tdelete $self->{'_colnamesmap'}->{$self->{'_colnames'}->[$colindex]};\n\t\tsplice(@{$self->{'_colnames'}},$colindex,1);\n   }\n   my $ct = 0;\n   %{$self->{'_colnamesmap'}} = map {$_ => $ct++} @{$self->{'_colnames'}};\n   return $self->num_columns;\n}\n\n=head2 column_num_for_name\n\n Title   : column_num_for_name\n Usage   : my $num = $matrix->column_num_for_name($name)\n Function: Gets the column number for a particular column name\n Returns : integer\n Args    : string\n\n\n\nsub column_num_for_name{\n   my ($self,$name) = @_;\n   \n   return $self->{'_colnamesmap'}->{$name};\n}\n\n=head2 row_num_for_name\n\n Title   : row_num_for_name\n Usage   : my $num = $matrix->row_num_for_name\n Function: Gets the row number for a particular row name\n Returns : integer\n Args    : string\n\n\n\nsub row_num_for_name{\n   my ($self,$name) = @_;\n   return $self->{'_rownamesmap'}->{$name}\n}\n\n\n=head2 column_header\n\n Title   : column_header\n Usage   : my $name = $matrix->column_header(0)\n Function: Gets the column header for a particular column number\n Returns : string\n Args    : integer","parameters":[{"label":"$self"},{"label":"$num"}]}},{"detail":"($self,$num)","definition":"sub","name":"row_header","containerName":"main::","children":[{"definition":"my","containerName":"row_header","localvar":"my","kind":13,"name":"$self","line":720},{"line":720,"containerName":"row_header","kind":13,"name":"$num"},{"line":721,"containerName":"row_header","kind":13,"name":"$self"},{"containerName":"row_header","kind":13,"name":"$num","line":721}],"signature":{"label":"row_header($self,$num)","documentation":"1;\n# $Id: Generic.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Matrix::Generic\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::Generic - A generic matrix implementation\n\n=head1 SYNOPSIS\n\n  # A matrix has columns and rows \n  my $matrix = Bio::Matrix::Generic->new;\n  $matrix->add_column(1,$column1);\n  $matrix->add_column(2,$column2);\n\n  my $element = $matrix->entry_by_num(1,2);\n  $matrix->entry_by_num(1,2,$newval);\n\n  my $entry = $matrix->entry('human', 'mouse');\n\n  $matrix->entry('human','mouse', $newval);\n\n\n=head1 DESCRIPTION\n\nThis is a general purpose matrix object for dealing with row+column\ndata which is typical when enumerating all the pairwise combinations\nand desiring to get slices of the data.\n\nData can be accessed by column and row names or indexes.  Matrix\nindexes start at 0.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Matrix::Generic;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Matrix::MatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Matrix::Generic->new();\n Function: Builds a new Bio::Matrix::Generic object \n Returns : an instance of Bio::Matrix::Generic\n Args    : -values     => arrayref of arrayrefs of data initialization \n           -rownames   => arrayref of row names\n           -colnames   => arrayref of col names\n           -matrix_id  => id of the matrix\n           -matrix_name=> name of the matrix\n           -matrix_init_value => default value to initialize empty cells\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($values, $rownames, $colnames,\n      $id,$name,$init_val) = \n\t  $self->_rearrange([qw(VALUES ROWNAMES COLNAMES \n\t\t\t        MATRIX_ID MATRIX_NAME \n                                MATRIX_INIT_VALUE)],@args);\n  $self->matrix_id($id) if  defined $id;\n  $self->matrix_name($name) if defined $name;\n  if( defined $rownames && defined $colnames ) {\n      if( ref($rownames) !~ /ARRAY/i ) {\n\t  $self->throw(\"need an arrayref for the -rownames option\");\n      }\n      # insure we copy the values\n      $self->{'_rownames'} = [ @$rownames ];\n      my $count = 0;\n      %{$self->{'_rownamesmap'}} = map { $_ => $count++ } @$rownames; \n\n      if( ref($colnames) !~ /ARRAY/i ) {\n\t  $self->throw(\"need an arrayref for the -colnames option\");\n      }\n      # insure we copy the values\n      $self->{'_colnames'} = [ @$colnames ];\n      $count = 0;\n      %{$self->{'_colnamesmap'}} = map { $_ => $count++ } @$colnames; \n\n      $self->{'_values'} = [];\n      if( defined $values ) {\n\t  if( ref($values) !~ /ARRAY/i ) {\n\t      $self->throw(\"Need an arrayref of arrayrefs (matrix) for -values option\");\n\t  }\t  \n\t  for my $v ( @$values ) {\n\t      if( ref($v) !~ /ARRAY/i ) {\n\t\t  $self->throw(\"Need and array of arrayrefs (matrix) for -values option\");\n\t      }\n\t      push @{$self->{'_values'}}, [@$v];\n\t  }\n      } else {\n\t  my @fill = ($init_val) x scalar @$colnames; # undef init_val will be default\n\t  for ( @$rownames ) {\n\t      push @{$self->{'_values'}}, [@fill];\n\t  }\n      }\n  } elsif( ! defined $rownames && ! defined $colnames && ! defined $values ) {\n      $self->{'_values'}   = [];\n      $self->{'_rownames'} = [];\n      $self->{'_colnames'} = [];\n  } else { \n      $self->throw(\"Must have either provided no values/colnames/rownames or provided all three\");\n  }\n\n  return $self;\n}\n\n\n=head2 matrix_id\n\n Title   : matrix_id\n Usage   : my $id = $matrix->matrix_id\n Function: Get/Set the matrix ID\n Returns : scalar value\n Args    : [optional] new id value to store\n\n\n\nsub matrix_id{\n   my $self = shift;\n   return $self->{'_matid'} = shift if @_;\n   return $self->{'_matid'};\n\n   \n}\n\n=head2 matrix_name\n\n Title   : matrix_name\n Usage   : my $name = $matrix->matrix_name();\n Function: Get/Set the matrix name\n Returns : scalar value\n Args    : [optional] new matrix name value\n\n\n\nsub matrix_name{\n   my $self = shift;\n   return $self->{'_matname'} = shift if @_;\n   return $self->{'_matname'};\n}\n\n\n=head2 entry\n\n Title   : entry\n Usage   : my $entry = $matrix->entry($row,$col)\n Function: Get the value for a specific cell as specified\n           by the row and column names\n Returns : scalar value or undef if row or col does not\n           exist\n Args    : $rowname - name of the row\n           $colname - column name\n\n\nsub entry{\n   my ($self,$row,$column,$newvalue) = @_;\n   if( ! defined $row || ! defined $column ) {\n       $self->throw(\"Need at least 2 ids\");\n   }\n\n   my ($rownum) = $self->row_num_for_name($row);\n   my ($colnum) = $self->column_num_for_name($column);\n   return $self->entry_by_num($rownum,$colnum,$newvalue);\n}\n\n=head2 get_entry\n\n Title   : get_entry\n Usage   : my $entry = $matrix->get_entry($rowname,$columname)\n Function: Get the entry for a given row,column pair\n Returns : scalar\n Args    : $row name\n           $column name \n\n\n\nsub get_entry{ $_[0]->entry($_[1],$_[2]) }\n\n=head2 entry_by_num\n\n Title   : entry_by_num\n Usage   : my $entry = $matrix->entry_by_num($rownum,$colnum)\n Function: Get an entry by row and column numbers instead of by name\n           (rows and columns start at 0)\n Returns : scalar value or undef if row or column name does not\n           exist\n Args    : $row - row number\n           $col - column number\n           [optional] $newvalue to store at this cell\n\n\nsub entry_by_num {\n    my ($self,$row,$col,$newvalue) = @_;\n    if( ! defined $row || ! defined $col || \n\t$row !~ /^\\d+$/ ||\n\t$col !~ /^\\d+$/ ) {\n\t$self->warn(\"expected to get 2 number for entry_by_num\");\n\treturn;\n    }\n    \n    if( defined $newvalue ) {\n       return $self->_values->[$row][$col] = $newvalue;\n   } else { \n       return $self->_values->[$row][$col];\n   }\n}\n\nsub get_element { \n    my $self = shift;\n    $self->entry(@_);\n}\n\n\n=head2 column\n\n Title   : column\n Usage   : my @col = $matrix->column('ALPHA');\n           OR\n           $matrix->column('ALPHA', \\@col);\n Function: Get/Set a particular column\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values.  \n           For setting will warn if the new column is of a different\n           length from the rest of the columns.\n Args    : name of the column\n           [optional] new column to store here \n\n\nsub column{\n    my ($self,$column,$newcol) = @_;\n\n    if( ! defined $column ) {\n\t$self->warn(\"Need at least a column id\");\n\treturn;\n    }\n    my $colnum  = $self->column_num_for_name($column);\n    if( ! defined $colnum ) { \n\t$self->warn(\"could not find column number for $column\");\n\treturn;\n    }\n    return $self->column_by_num($colnum,$newcol);\n}\n\n\n=head2 get_column\n\n Title   : get_column\n Usage   : my @row = $matrix->get_column('ALPHA');\n Function: Get a particular column\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the column\n\n\n\nsub get_column { $_[0]->column($_[1]) }\n\n\n=head2 column_by_num\n\n Title   : column_by_num\n Usage   : my @col = $matrix->column_by_num(1);\n           OR\n           $matrix->column_by_num(1,\\@newcol);\n Function: Get/Set a column by its number instead of name\n           (cols/rows start at 0)\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the column\n           [optional] new value to store for a particular column\n\n\nsub column_by_num{\n    my ($self,$colnum,$newcol) = @_;\n    if( ! defined $colnum ) {\n\t$self->warn(\"need at least a column number\");\n\treturn;\n    }\n    my $rowcount = $self->num_rows;\n    my $colcount = $self->num_columns;\n    my $ret;\n    \n    if( defined $newcol ) {\n\tif( ref($newcol) !~ /ARRAY/i) {\n\t    $self->warn(\"expected a valid arrayref for resetting a column\");\n\t    return;\n\t}\n\tif( scalar @$newcol != $rowcount ) {\n\t    $self->warn(\"new column is not the correct length ($rowcount) - call add or remove row to shrink or grow the number of rows first\");\n\t    return;\n\t}\n\tfor(my $i=0; $i < $rowcount; $i++) {\n\t    $self->entry_by_num($i,$colnum,$newcol->[$i]);\n\t}\n\t$ret = $newcol;\n    } else { \n\t$ret = [];\n\tfor(my $i=0; $i < $rowcount; $i++) {\n\t    push @$ret,$self->entry_by_num($i,$colnum);\n\t}\n    }\n    if( wantarray ) { return @$ret } \n    return $ret;\n\n}\n\n=head2 row\n\n Title   : row\n Usage   : my @row = $matrix->row($rowname);\n             OR\n           $matrix->row($rowname,\\@rowvalues);\n Function: Get/Set the row of the matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n Args    : rowname\n           [optional] new value of row to store\n\n\n\nsub row {\n    my ($self,$row,$newrow) = @_;\n    if( ! defined $row) {\n\t$self->warn(\"Need at least a row id\");\n\treturn;\n    }\n    my $rownum = $self->row_num_for_name($row);\n    return $self->row_by_num($rownum,$newrow);\n}\n\n\n=head2 get_row\n\n Title   : get_row\n Usage   : my @row = $matrix->get_row('ALPHA');\n Function: Get a particular row\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the row\n\n\nsub get_row { $_[0]->row($_[1]) }\n\n=head2 row_by_num\n\n Title   : row_by_num\n Usage   : my @row = $matrix->row_by_num($rownum);\n             OR\n           $matrix->row($rownum,\\@rowvalues);\n Function: Get/Set the row of the matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n Args    : rowname\n           [optional] new value of row to store\n\n\nsub row_by_num{\n   my ($self,$rownum,$newrow) = @_;\n   if( ! defined $rownum ) {\n       $self->warn(\"need at least a row number\");\n       return;\n   }\n    my $colcount = $self->num_columns;\n    my $ret;\n    if( defined $newrow ) {\n\tif( ref($newrow) !~ /ARRAY/i) {\n\t    $self->warn(\"expected a valid arrayref for resetting a row\");\n\t    return;\n\t}\n\tif( scalar @$newrow != $colcount ) {\n\t    $self->warn(\"new row is not the correct length ($colcount) - call add or remove column to shrink or grow the number of columns first\");\n\t    return;\n\t}\n\tfor(my $i=0; $i < $colcount; $i++) {\n\t    $self->entry_by_num($rownum,$i, $newrow->[$i]);\n\t}\n\t$ret = $newrow;\n    } else { \n\t$ret = [];\n\tfor(my $i=0; $i < $colcount; $i++) {\n\t    # we're doing this to explicitly \n\t    # copy the entire row\n\t    push @$ret, $self->entry_by_num($rownum,$i);\n\t}\n    }\n    if( wantarray ) { return @$ret } \n    return $ret;\n\n\n}\n\n\n=head2 diagonal\n\n Title   : diagonal\n Usage   : my @diagonal = $matrix->get_diagonal()\n Function: Get the diagonal of a matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values which lie along the diagonal\n Args    : none\n\n\n\nsub get_diagonal{\n   my ($self) = @_;\n   my @diag;\n   my $rowcount = $self->num_rows;\n   my $colcount = $self->num_columns;\n   for(my $i = 0; $i < $rowcount; $i++ ) {\n       push @diag, $self->entry_by_num($i,$i);\n   }\n   return @diag;\n}\n\n\n=head2 add_row\n\n Title   : add_row\n Usage   : $matrix->add_row($index,\\@newrow);\n Function: Adds a row at particular location in the matrix.\n           If $index < the rowcount will shift all the rows down\n           by the number of new rows.\n           To add a single empty row, simply call\n           $matrix->add_row($index,undef);\n Returns : the updated number of total rows in the matrix\n Args    : index to store\n           name of the row (header)\n           newrow to add, if this is undef will add a single\n                     row with all values set to undef \n\n\nsub add_row{\n   my ($self,$index,$name,$newrow) = @_;\n   if( !defined $index || \n       $index !~ /^\\d+$/ ) {\n       $self->warn(\"expected a valid row index in add_row\");\n       return;\n   } elsif( ! defined $name) {\n       $self->warn(\"Need a row name or heading\");\n       return;\n   } elsif( defined $self->row_num_for_name($name) ) {\n       $self->warn(\"Need a unqiue name for the column heading, $name is already used\");\n       return;\n   }\n   my $colcount = $self->num_columns;\n   my $rowcount = $self->num_rows;\n\n   if( $index >  $rowcount ) { \n       $self->warn(\"cannot add a row beyond 1+last row at the end ($rowcount) not $index - adding at $rowcount instead\");\n       $index = $rowcount;\n   }\n\n   if( ! defined $newrow ) {\n       $newrow = [];\n       $newrow->[$colcount] = undef;\n   } elsif( ref($newrow) !~ /ARRAY/i ) {\n       $self->throw(\"Expected either undef or a valid arrayref for add_row\");\n   }\n   # add this row to the matrix by carving out space for it with \n   # splice\n   splice(@{$self->{'_values'}}, $index,0,[]);\n   for( my $i = 0; $i < $colcount; $i++ ) {\n       $self->entry_by_num($index,$i,$newrow->[$i]);\n   }\n   splice(@{$self->{'_rownames'}}, $index,0,$name);\n   # Sadly we have to remap these each time (except for the case\n   # when we're adding a new column to the end, but I don't think\n   # the speedup for that case warrants the extra code at this time.\n   my $ct = 0;\n   %{$self->{'_rownamesmap'}} = map { $_ => $ct++} @{$self->{'_rownames'}};\n   return $self->num_rows;\n}\n\n=head2 remove_row\n\n Title   : remove_row\n Usage   : $matrix->remove_row($colnum)\n Function: remove a row from the matrix shifting all the rows\n           up by one\n Returns : Updated number of rows in the matrix\n Args    : row index\n\n\n\nsub remove_row{\n   my ($self,$rowindex) = @_;\n   my $rowcount = $self->num_rows;\n   \n   if( $rowindex > $rowcount ) {\n       $self->warn(\"rowindex $rowindex is greater than number of rows $rowcount, cannot process\");\n       return 0;\n   } else { \n       splice(@{$self->_values},$rowindex,1);\n       delete $self->{'_rownamesmap'}->{$self->{'_rownames'}->[$rowindex]};\n       splice(@{$self->{'_rownames'}},$rowindex,1);\n   }\n   my $ct = 0;\n   %{$self->{'_rownamesmap'}} = map { $_ => $ct++} @{$self->{'_rownames'}};\n   return $self->num_rows;\n}\n\n=head2 add_column\n\n Title   : add_column\n Usage   : $matrix->add_column($index,$colname,\\@newcol);\n Function: Adds a column at particular location in the matrix.\n           If $index < the colcount will shift all the columns right\n           by the number of new columns.\n           To add a single empty column, simply call\n           $matrix->add_column($index,undef);\n Returns : the updated number of total columns in the matrix\n Args    : index to store\n           name of the column (header)\n           newcolumn to add, if this is undef will add a single\n                 column with all values set to undef \n\n\n\n\nsub add_column{\n   my ($self,$index,$name,$newcol) = @_;\n   if( !defined $index ||\n       $index !~ /^\\d+$/ ) {\n       $self->warn(\"expected a valid col index in add_column\");\n       return;\n   } elsif( ! defined $name) {\n       $self->warn(\"Need a column name or heading\");\n       return;\n   } elsif( defined $self->column_num_for_name($name) ) {\n       $self->warn(\"Need a unqiue name for the column heading, $name is already used\");\n       return;\n   }\n   my $colcount = $self->num_columns;\n   my $rowcount = $self->num_rows;\n   if( $index > $colcount ) { \n       $self->warn(\"cannot add a column beyond 1+last column at the end ($colcount) not $index - adding at $colcount instead\");\n       $index = $colcount;\n   }\n\n   if( ! defined $newcol ) {\n       $newcol = [];\n       $newcol->[$rowcount] = undef; # make the array '$rowcount' long\n   } elsif( ref($newcol) !~ /ARRAY/i ) {\n       $self->throw(\"Expected either undef or a valid arrayref for add_row\");\n   }\n   for( my $i = 0; $i < $rowcount; $i++ ) {\n       # add this column to each row\n       splice(@{$self->_values->[$i]},$index,0,[]);\n       $self->entry_by_num($i,$index,$newcol->[$i]);\n   }\n   splice(@{$self->{'_colnames'}}, $index,0,$name);\n   # Sadly we have to remap these each time (except for the case\n   # when we're adding a new column to the end, but I don't think\n   # the speedup for that case warrants the extra code at this time.\n   my $ct = 0;\n   %{$self->{'_colnamesmap'}} = map {$_ => $ct++} @{$self->{'_colnames'}};\n   return $self->num_columns;\n}\n\n=head2 remove_column\n\n Title   : remove_column\n Usage   : $matrix->remove_column($colnum)\n Function: remove a column from the matrix shifting all the columns\n           to the left by one\n Returns : Updated number of columns in the matrix\n Args    : column index\n\n\nsub remove_column{\n   my ($self,$colindex) = @_;\n\n   my $colcount = $self->num_columns;\n   my $rowcount = $self->num_rows;\n   if( $colindex > $colcount ) {\n\t\t$self->warn(\"colindex $colindex is greater than number of columns ($colcount), cannot process\");\n\t\treturn 0;\n   } else { \n\t\tfor(my $i = 0; $i < $rowcount; $i++ ) {\n\t\t\tsplice(@{$self->_values->[$i]},$colindex,1);\n\t\t}\n\t\tdelete $self->{'_colnamesmap'}->{$self->{'_colnames'}->[$colindex]};\n\t\tsplice(@{$self->{'_colnames'}},$colindex,1);\n   }\n   my $ct = 0;\n   %{$self->{'_colnamesmap'}} = map {$_ => $ct++} @{$self->{'_colnames'}};\n   return $self->num_columns;\n}\n\n=head2 column_num_for_name\n\n Title   : column_num_for_name\n Usage   : my $num = $matrix->column_num_for_name($name)\n Function: Gets the column number for a particular column name\n Returns : integer\n Args    : string\n\n\n\nsub column_num_for_name{\n   my ($self,$name) = @_;\n   \n   return $self->{'_colnamesmap'}->{$name};\n}\n\n=head2 row_num_for_name\n\n Title   : row_num_for_name\n Usage   : my $num = $matrix->row_num_for_name\n Function: Gets the row number for a particular row name\n Returns : integer\n Args    : string\n\n\n\nsub row_num_for_name{\n   my ($self,$name) = @_;\n   return $self->{'_rownamesmap'}->{$name}\n}\n\n\n=head2 column_header\n\n Title   : column_header\n Usage   : my $name = $matrix->column_header(0)\n Function: Gets the column header for a particular column number\n Returns : string\n Args    : integer\n\n\n\nsub column_header{\n   my ($self,$num) = @_;\n   return $self->{'_colnames'}->[$num];\n}\n\n\n=head2 row_header\n\n Title   : row_header\n Usage   : my $name = $matrix->row_header(0)\n Function: Gets the row header for a particular row number\n Returns : string\n Args    : integer","parameters":[{"label":"$self"},{"label":"$num"}]},"kind":12,"range":{"end":{"line":722,"character":9999},"start":{"line":719,"character":0}},"line":719},{"signature":{"documentation":"1;\n# $Id: Generic.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Matrix::Generic\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::Generic - A generic matrix implementation\n\n=head1 SYNOPSIS\n\n  # A matrix has columns and rows \n  my $matrix = Bio::Matrix::Generic->new;\n  $matrix->add_column(1,$column1);\n  $matrix->add_column(2,$column2);\n\n  my $element = $matrix->entry_by_num(1,2);\n  $matrix->entry_by_num(1,2,$newval);\n\n  my $entry = $matrix->entry('human', 'mouse');\n\n  $matrix->entry('human','mouse', $newval);\n\n\n=head1 DESCRIPTION\n\nThis is a general purpose matrix object for dealing with row+column\ndata which is typical when enumerating all the pairwise combinations\nand desiring to get slices of the data.\n\nData can be accessed by column and row names or indexes.  Matrix\nindexes start at 0.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Matrix::Generic;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Matrix::MatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Matrix::Generic->new();\n Function: Builds a new Bio::Matrix::Generic object \n Returns : an instance of Bio::Matrix::Generic\n Args    : -values     => arrayref of arrayrefs of data initialization \n           -rownames   => arrayref of row names\n           -colnames   => arrayref of col names\n           -matrix_id  => id of the matrix\n           -matrix_name=> name of the matrix\n           -matrix_init_value => default value to initialize empty cells\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($values, $rownames, $colnames,\n      $id,$name,$init_val) = \n\t  $self->_rearrange([qw(VALUES ROWNAMES COLNAMES \n\t\t\t        MATRIX_ID MATRIX_NAME \n                                MATRIX_INIT_VALUE)],@args);\n  $self->matrix_id($id) if  defined $id;\n  $self->matrix_name($name) if defined $name;\n  if( defined $rownames && defined $colnames ) {\n      if( ref($rownames) !~ /ARRAY/i ) {\n\t  $self->throw(\"need an arrayref for the -rownames option\");\n      }\n      # insure we copy the values\n      $self->{'_rownames'} = [ @$rownames ];\n      my $count = 0;\n      %{$self->{'_rownamesmap'}} = map { $_ => $count++ } @$rownames; \n\n      if( ref($colnames) !~ /ARRAY/i ) {\n\t  $self->throw(\"need an arrayref for the -colnames option\");\n      }\n      # insure we copy the values\n      $self->{'_colnames'} = [ @$colnames ];\n      $count = 0;\n      %{$self->{'_colnamesmap'}} = map { $_ => $count++ } @$colnames; \n\n      $self->{'_values'} = [];\n      if( defined $values ) {\n\t  if( ref($values) !~ /ARRAY/i ) {\n\t      $self->throw(\"Need an arrayref of arrayrefs (matrix) for -values option\");\n\t  }\t  \n\t  for my $v ( @$values ) {\n\t      if( ref($v) !~ /ARRAY/i ) {\n\t\t  $self->throw(\"Need and array of arrayrefs (matrix) for -values option\");\n\t      }\n\t      push @{$self->{'_values'}}, [@$v];\n\t  }\n      } else {\n\t  my @fill = ($init_val) x scalar @$colnames; # undef init_val will be default\n\t  for ( @$rownames ) {\n\t      push @{$self->{'_values'}}, [@fill];\n\t  }\n      }\n  } elsif( ! defined $rownames && ! defined $colnames && ! defined $values ) {\n      $self->{'_values'}   = [];\n      $self->{'_rownames'} = [];\n      $self->{'_colnames'} = [];\n  } else { \n      $self->throw(\"Must have either provided no values/colnames/rownames or provided all three\");\n  }\n\n  return $self;\n}\n\n\n=head2 matrix_id\n\n Title   : matrix_id\n Usage   : my $id = $matrix->matrix_id\n Function: Get/Set the matrix ID\n Returns : scalar value\n Args    : [optional] new id value to store\n\n\n\nsub matrix_id{\n   my $self = shift;\n   return $self->{'_matid'} = shift if @_;\n   return $self->{'_matid'};\n\n   \n}\n\n=head2 matrix_name\n\n Title   : matrix_name\n Usage   : my $name = $matrix->matrix_name();\n Function: Get/Set the matrix name\n Returns : scalar value\n Args    : [optional] new matrix name value\n\n\n\nsub matrix_name{\n   my $self = shift;\n   return $self->{'_matname'} = shift if @_;\n   return $self->{'_matname'};\n}\n\n\n=head2 entry\n\n Title   : entry\n Usage   : my $entry = $matrix->entry($row,$col)\n Function: Get the value for a specific cell as specified\n           by the row and column names\n Returns : scalar value or undef if row or col does not\n           exist\n Args    : $rowname - name of the row\n           $colname - column name\n\n\nsub entry{\n   my ($self,$row,$column,$newvalue) = @_;\n   if( ! defined $row || ! defined $column ) {\n       $self->throw(\"Need at least 2 ids\");\n   }\n\n   my ($rownum) = $self->row_num_for_name($row);\n   my ($colnum) = $self->column_num_for_name($column);\n   return $self->entry_by_num($rownum,$colnum,$newvalue);\n}\n\n=head2 get_entry\n\n Title   : get_entry\n Usage   : my $entry = $matrix->get_entry($rowname,$columname)\n Function: Get the entry for a given row,column pair\n Returns : scalar\n Args    : $row name\n           $column name \n\n\n\nsub get_entry{ $_[0]->entry($_[1],$_[2]) }\n\n=head2 entry_by_num\n\n Title   : entry_by_num\n Usage   : my $entry = $matrix->entry_by_num($rownum,$colnum)\n Function: Get an entry by row and column numbers instead of by name\n           (rows and columns start at 0)\n Returns : scalar value or undef if row or column name does not\n           exist\n Args    : $row - row number\n           $col - column number\n           [optional] $newvalue to store at this cell\n\n\nsub entry_by_num {\n    my ($self,$row,$col,$newvalue) = @_;\n    if( ! defined $row || ! defined $col || \n\t$row !~ /^\\d+$/ ||\n\t$col !~ /^\\d+$/ ) {\n\t$self->warn(\"expected to get 2 number for entry_by_num\");\n\treturn;\n    }\n    \n    if( defined $newvalue ) {\n       return $self->_values->[$row][$col] = $newvalue;\n   } else { \n       return $self->_values->[$row][$col];\n   }\n}\n\nsub get_element { \n    my $self = shift;\n    $self->entry(@_);\n}\n\n\n=head2 column\n\n Title   : column\n Usage   : my @col = $matrix->column('ALPHA');\n           OR\n           $matrix->column('ALPHA', \\@col);\n Function: Get/Set a particular column\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values.  \n           For setting will warn if the new column is of a different\n           length from the rest of the columns.\n Args    : name of the column\n           [optional] new column to store here \n\n\nsub column{\n    my ($self,$column,$newcol) = @_;\n\n    if( ! defined $column ) {\n\t$self->warn(\"Need at least a column id\");\n\treturn;\n    }\n    my $colnum  = $self->column_num_for_name($column);\n    if( ! defined $colnum ) { \n\t$self->warn(\"could not find column number for $column\");\n\treturn;\n    }\n    return $self->column_by_num($colnum,$newcol);\n}\n\n\n=head2 get_column\n\n Title   : get_column\n Usage   : my @row = $matrix->get_column('ALPHA');\n Function: Get a particular column\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the column\n\n\n\nsub get_column { $_[0]->column($_[1]) }\n\n\n=head2 column_by_num\n\n Title   : column_by_num\n Usage   : my @col = $matrix->column_by_num(1);\n           OR\n           $matrix->column_by_num(1,\\@newcol);\n Function: Get/Set a column by its number instead of name\n           (cols/rows start at 0)\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the column\n           [optional] new value to store for a particular column\n\n\nsub column_by_num{\n    my ($self,$colnum,$newcol) = @_;\n    if( ! defined $colnum ) {\n\t$self->warn(\"need at least a column number\");\n\treturn;\n    }\n    my $rowcount = $self->num_rows;\n    my $colcount = $self->num_columns;\n    my $ret;\n    \n    if( defined $newcol ) {\n\tif( ref($newcol) !~ /ARRAY/i) {\n\t    $self->warn(\"expected a valid arrayref for resetting a column\");\n\t    return;\n\t}\n\tif( scalar @$newcol != $rowcount ) {\n\t    $self->warn(\"new column is not the correct length ($rowcount) - call add or remove row to shrink or grow the number of rows first\");\n\t    return;\n\t}\n\tfor(my $i=0; $i < $rowcount; $i++) {\n\t    $self->entry_by_num($i,$colnum,$newcol->[$i]);\n\t}\n\t$ret = $newcol;\n    } else { \n\t$ret = [];\n\tfor(my $i=0; $i < $rowcount; $i++) {\n\t    push @$ret,$self->entry_by_num($i,$colnum);\n\t}\n    }\n    if( wantarray ) { return @$ret } \n    return $ret;\n\n}\n\n=head2 row\n\n Title   : row\n Usage   : my @row = $matrix->row($rowname);\n             OR\n           $matrix->row($rowname,\\@rowvalues);\n Function: Get/Set the row of the matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n Args    : rowname\n           [optional] new value of row to store\n\n\n\nsub row {\n    my ($self,$row,$newrow) = @_;\n    if( ! defined $row) {\n\t$self->warn(\"Need at least a row id\");\n\treturn;\n    }\n    my $rownum = $self->row_num_for_name($row);\n    return $self->row_by_num($rownum,$newrow);\n}\n\n\n=head2 get_row\n\n Title   : get_row\n Usage   : my @row = $matrix->get_row('ALPHA');\n Function: Get a particular row\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the row\n\n\nsub get_row { $_[0]->row($_[1]) }\n\n=head2 row_by_num\n\n Title   : row_by_num\n Usage   : my @row = $matrix->row_by_num($rownum);\n             OR\n           $matrix->row($rownum,\\@rowvalues);\n Function: Get/Set the row of the matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n Args    : rowname\n           [optional] new value of row to store\n\n\nsub row_by_num{\n   my ($self,$rownum,$newrow) = @_;\n   if( ! defined $rownum ) {\n       $self->warn(\"need at least a row number\");\n       return;\n   }\n    my $colcount = $self->num_columns;\n    my $ret;\n    if( defined $newrow ) {\n\tif( ref($newrow) !~ /ARRAY/i) {\n\t    $self->warn(\"expected a valid arrayref for resetting a row\");\n\t    return;\n\t}\n\tif( scalar @$newrow != $colcount ) {\n\t    $self->warn(\"new row is not the correct length ($colcount) - call add or remove column to shrink or grow the number of columns first\");\n\t    return;\n\t}\n\tfor(my $i=0; $i < $colcount; $i++) {\n\t    $self->entry_by_num($rownum,$i, $newrow->[$i]);\n\t}\n\t$ret = $newrow;\n    } else { \n\t$ret = [];\n\tfor(my $i=0; $i < $colcount; $i++) {\n\t    # we're doing this to explicitly \n\t    # copy the entire row\n\t    push @$ret, $self->entry_by_num($rownum,$i);\n\t}\n    }\n    if( wantarray ) { return @$ret } \n    return $ret;\n\n\n}\n\n\n=head2 diagonal\n\n Title   : diagonal\n Usage   : my @diagonal = $matrix->get_diagonal()\n Function: Get the diagonal of a matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values which lie along the diagonal\n Args    : none\n\n\n\nsub get_diagonal{\n   my ($self) = @_;\n   my @diag;\n   my $rowcount = $self->num_rows;\n   my $colcount = $self->num_columns;\n   for(my $i = 0; $i < $rowcount; $i++ ) {\n       push @diag, $self->entry_by_num($i,$i);\n   }\n   return @diag;\n}\n\n\n=head2 add_row\n\n Title   : add_row\n Usage   : $matrix->add_row($index,\\@newrow);\n Function: Adds a row at particular location in the matrix.\n           If $index < the rowcount will shift all the rows down\n           by the number of new rows.\n           To add a single empty row, simply call\n           $matrix->add_row($index,undef);\n Returns : the updated number of total rows in the matrix\n Args    : index to store\n           name of the row (header)\n           newrow to add, if this is undef will add a single\n                     row with all values set to undef \n\n\nsub add_row{\n   my ($self,$index,$name,$newrow) = @_;\n   if( !defined $index || \n       $index !~ /^\\d+$/ ) {\n       $self->warn(\"expected a valid row index in add_row\");\n       return;\n   } elsif( ! defined $name) {\n       $self->warn(\"Need a row name or heading\");\n       return;\n   } elsif( defined $self->row_num_for_name($name) ) {\n       $self->warn(\"Need a unqiue name for the column heading, $name is already used\");\n       return;\n   }\n   my $colcount = $self->num_columns;\n   my $rowcount = $self->num_rows;\n\n   if( $index >  $rowcount ) { \n       $self->warn(\"cannot add a row beyond 1+last row at the end ($rowcount) not $index - adding at $rowcount instead\");\n       $index = $rowcount;\n   }\n\n   if( ! defined $newrow ) {\n       $newrow = [];\n       $newrow->[$colcount] = undef;\n   } elsif( ref($newrow) !~ /ARRAY/i ) {\n       $self->throw(\"Expected either undef or a valid arrayref for add_row\");\n   }\n   # add this row to the matrix by carving out space for it with \n   # splice\n   splice(@{$self->{'_values'}}, $index,0,[]);\n   for( my $i = 0; $i < $colcount; $i++ ) {\n       $self->entry_by_num($index,$i,$newrow->[$i]);\n   }\n   splice(@{$self->{'_rownames'}}, $index,0,$name);\n   # Sadly we have to remap these each time (except for the case\n   # when we're adding a new column to the end, but I don't think\n   # the speedup for that case warrants the extra code at this time.\n   my $ct = 0;\n   %{$self->{'_rownamesmap'}} = map { $_ => $ct++} @{$self->{'_rownames'}};\n   return $self->num_rows;\n}\n\n=head2 remove_row\n\n Title   : remove_row\n Usage   : $matrix->remove_row($colnum)\n Function: remove a row from the matrix shifting all the rows\n           up by one\n Returns : Updated number of rows in the matrix\n Args    : row index\n\n\n\nsub remove_row{\n   my ($self,$rowindex) = @_;\n   my $rowcount = $self->num_rows;\n   \n   if( $rowindex > $rowcount ) {\n       $self->warn(\"rowindex $rowindex is greater than number of rows $rowcount, cannot process\");\n       return 0;\n   } else { \n       splice(@{$self->_values},$rowindex,1);\n       delete $self->{'_rownamesmap'}->{$self->{'_rownames'}->[$rowindex]};\n       splice(@{$self->{'_rownames'}},$rowindex,1);\n   }\n   my $ct = 0;\n   %{$self->{'_rownamesmap'}} = map { $_ => $ct++} @{$self->{'_rownames'}};\n   return $self->num_rows;\n}\n\n=head2 add_column\n\n Title   : add_column\n Usage   : $matrix->add_column($index,$colname,\\@newcol);\n Function: Adds a column at particular location in the matrix.\n           If $index < the colcount will shift all the columns right\n           by the number of new columns.\n           To add a single empty column, simply call\n           $matrix->add_column($index,undef);\n Returns : the updated number of total columns in the matrix\n Args    : index to store\n           name of the column (header)\n           newcolumn to add, if this is undef will add a single\n                 column with all values set to undef \n\n\n\n\nsub add_column{\n   my ($self,$index,$name,$newcol) = @_;\n   if( !defined $index ||\n       $index !~ /^\\d+$/ ) {\n       $self->warn(\"expected a valid col index in add_column\");\n       return;\n   } elsif( ! defined $name) {\n       $self->warn(\"Need a column name or heading\");\n       return;\n   } elsif( defined $self->column_num_for_name($name) ) {\n       $self->warn(\"Need a unqiue name for the column heading, $name is already used\");\n       return;\n   }\n   my $colcount = $self->num_columns;\n   my $rowcount = $self->num_rows;\n   if( $index > $colcount ) { \n       $self->warn(\"cannot add a column beyond 1+last column at the end ($colcount) not $index - adding at $colcount instead\");\n       $index = $colcount;\n   }\n\n   if( ! defined $newcol ) {\n       $newcol = [];\n       $newcol->[$rowcount] = undef; # make the array '$rowcount' long\n   } elsif( ref($newcol) !~ /ARRAY/i ) {\n       $self->throw(\"Expected either undef or a valid arrayref for add_row\");\n   }\n   for( my $i = 0; $i < $rowcount; $i++ ) {\n       # add this column to each row\n       splice(@{$self->_values->[$i]},$index,0,[]);\n       $self->entry_by_num($i,$index,$newcol->[$i]);\n   }\n   splice(@{$self->{'_colnames'}}, $index,0,$name);\n   # Sadly we have to remap these each time (except for the case\n   # when we're adding a new column to the end, but I don't think\n   # the speedup for that case warrants the extra code at this time.\n   my $ct = 0;\n   %{$self->{'_colnamesmap'}} = map {$_ => $ct++} @{$self->{'_colnames'}};\n   return $self->num_columns;\n}\n\n=head2 remove_column\n\n Title   : remove_column\n Usage   : $matrix->remove_column($colnum)\n Function: remove a column from the matrix shifting all the columns\n           to the left by one\n Returns : Updated number of columns in the matrix\n Args    : column index\n\n\nsub remove_column{\n   my ($self,$colindex) = @_;\n\n   my $colcount = $self->num_columns;\n   my $rowcount = $self->num_rows;\n   if( $colindex > $colcount ) {\n\t\t$self->warn(\"colindex $colindex is greater than number of columns ($colcount), cannot process\");\n\t\treturn 0;\n   } else { \n\t\tfor(my $i = 0; $i < $rowcount; $i++ ) {\n\t\t\tsplice(@{$self->_values->[$i]},$colindex,1);\n\t\t}\n\t\tdelete $self->{'_colnamesmap'}->{$self->{'_colnames'}->[$colindex]};\n\t\tsplice(@{$self->{'_colnames'}},$colindex,1);\n   }\n   my $ct = 0;\n   %{$self->{'_colnamesmap'}} = map {$_ => $ct++} @{$self->{'_colnames'}};\n   return $self->num_columns;\n}\n\n=head2 column_num_for_name\n\n Title   : column_num_for_name\n Usage   : my $num = $matrix->column_num_for_name($name)\n Function: Gets the column number for a particular column name\n Returns : integer\n Args    : string\n\n\n\nsub column_num_for_name{\n   my ($self,$name) = @_;\n   \n   return $self->{'_colnamesmap'}->{$name};\n}\n\n=head2 row_num_for_name\n\n Title   : row_num_for_name\n Usage   : my $num = $matrix->row_num_for_name\n Function: Gets the row number for a particular row name\n Returns : integer\n Args    : string\n\n\n\nsub row_num_for_name{\n   my ($self,$name) = @_;\n   return $self->{'_rownamesmap'}->{$name}\n}\n\n\n=head2 column_header\n\n Title   : column_header\n Usage   : my $name = $matrix->column_header(0)\n Function: Gets the column header for a particular column number\n Returns : string\n Args    : integer\n\n\n\nsub column_header{\n   my ($self,$num) = @_;\n   return $self->{'_colnames'}->[$num];\n}\n\n\n=head2 row_header\n\n Title   : row_header\n Usage   : my $name = $matrix->row_header(0)\n Function: Gets the row header for a particular row number\n Returns : string\n Args    : integer\n\n\n\nsub row_header{\n   my ($self,$num) = @_;\n   return $self->{'_rownames'}->[$num];\n}\n\n=head2 num_rows\n\n Title   : num_rows\n Usage   : my $rowcount = $matrix->num_rows;\n Function: Get the number of rows\n Returns : integer\n Args    : none","parameters":[{"label":"$self"}],"label":"num_rows($self)"},"line":735,"range":{"end":{"character":9999,"line":737},"start":{"character":0,"line":735}},"kind":12,"definition":"sub","detail":"($self)","children":[{"containerName":"num_rows","localvar":"my","kind":13,"name":"$self","line":736,"definition":"my"},{"line":737,"containerName":"num_rows","kind":13,"name":"$self"},{"name":"_values","kind":12,"containerName":"num_rows","line":737}],"name":"num_rows","containerName":"main::"},{"kind":12,"range":{"start":{"character":0,"line":752},"end":{"line":754,"character":9999}},"line":752,"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Generic.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Matrix::Generic\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::Generic - A generic matrix implementation\n\n=head1 SYNOPSIS\n\n  # A matrix has columns and rows \n  my $matrix = Bio::Matrix::Generic->new;\n  $matrix->add_column(1,$column1);\n  $matrix->add_column(2,$column2);\n\n  my $element = $matrix->entry_by_num(1,2);\n  $matrix->entry_by_num(1,2,$newval);\n\n  my $entry = $matrix->entry('human', 'mouse');\n\n  $matrix->entry('human','mouse', $newval);\n\n\n=head1 DESCRIPTION\n\nThis is a general purpose matrix object for dealing with row+column\ndata which is typical when enumerating all the pairwise combinations\nand desiring to get slices of the data.\n\nData can be accessed by column and row names or indexes.  Matrix\nindexes start at 0.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Matrix::Generic;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Matrix::MatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Matrix::Generic->new();\n Function: Builds a new Bio::Matrix::Generic object \n Returns : an instance of Bio::Matrix::Generic\n Args    : -values     => arrayref of arrayrefs of data initialization \n           -rownames   => arrayref of row names\n           -colnames   => arrayref of col names\n           -matrix_id  => id of the matrix\n           -matrix_name=> name of the matrix\n           -matrix_init_value => default value to initialize empty cells\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($values, $rownames, $colnames,\n      $id,$name,$init_val) = \n\t  $self->_rearrange([qw(VALUES ROWNAMES COLNAMES \n\t\t\t        MATRIX_ID MATRIX_NAME \n                                MATRIX_INIT_VALUE)],@args);\n  $self->matrix_id($id) if  defined $id;\n  $self->matrix_name($name) if defined $name;\n  if( defined $rownames && defined $colnames ) {\n      if( ref($rownames) !~ /ARRAY/i ) {\n\t  $self->throw(\"need an arrayref for the -rownames option\");\n      }\n      # insure we copy the values\n      $self->{'_rownames'} = [ @$rownames ];\n      my $count = 0;\n      %{$self->{'_rownamesmap'}} = map { $_ => $count++ } @$rownames; \n\n      if( ref($colnames) !~ /ARRAY/i ) {\n\t  $self->throw(\"need an arrayref for the -colnames option\");\n      }\n      # insure we copy the values\n      $self->{'_colnames'} = [ @$colnames ];\n      $count = 0;\n      %{$self->{'_colnamesmap'}} = map { $_ => $count++ } @$colnames; \n\n      $self->{'_values'} = [];\n      if( defined $values ) {\n\t  if( ref($values) !~ /ARRAY/i ) {\n\t      $self->throw(\"Need an arrayref of arrayrefs (matrix) for -values option\");\n\t  }\t  \n\t  for my $v ( @$values ) {\n\t      if( ref($v) !~ /ARRAY/i ) {\n\t\t  $self->throw(\"Need and array of arrayrefs (matrix) for -values option\");\n\t      }\n\t      push @{$self->{'_values'}}, [@$v];\n\t  }\n      } else {\n\t  my @fill = ($init_val) x scalar @$colnames; # undef init_val will be default\n\t  for ( @$rownames ) {\n\t      push @{$self->{'_values'}}, [@fill];\n\t  }\n      }\n  } elsif( ! defined $rownames && ! defined $colnames && ! defined $values ) {\n      $self->{'_values'}   = [];\n      $self->{'_rownames'} = [];\n      $self->{'_colnames'} = [];\n  } else { \n      $self->throw(\"Must have either provided no values/colnames/rownames or provided all three\");\n  }\n\n  return $self;\n}\n\n\n=head2 matrix_id\n\n Title   : matrix_id\n Usage   : my $id = $matrix->matrix_id\n Function: Get/Set the matrix ID\n Returns : scalar value\n Args    : [optional] new id value to store\n\n\n\nsub matrix_id{\n   my $self = shift;\n   return $self->{'_matid'} = shift if @_;\n   return $self->{'_matid'};\n\n   \n}\n\n=head2 matrix_name\n\n Title   : matrix_name\n Usage   : my $name = $matrix->matrix_name();\n Function: Get/Set the matrix name\n Returns : scalar value\n Args    : [optional] new matrix name value\n\n\n\nsub matrix_name{\n   my $self = shift;\n   return $self->{'_matname'} = shift if @_;\n   return $self->{'_matname'};\n}\n\n\n=head2 entry\n\n Title   : entry\n Usage   : my $entry = $matrix->entry($row,$col)\n Function: Get the value for a specific cell as specified\n           by the row and column names\n Returns : scalar value or undef if row or col does not\n           exist\n Args    : $rowname - name of the row\n           $colname - column name\n\n\nsub entry{\n   my ($self,$row,$column,$newvalue) = @_;\n   if( ! defined $row || ! defined $column ) {\n       $self->throw(\"Need at least 2 ids\");\n   }\n\n   my ($rownum) = $self->row_num_for_name($row);\n   my ($colnum) = $self->column_num_for_name($column);\n   return $self->entry_by_num($rownum,$colnum,$newvalue);\n}\n\n=head2 get_entry\n\n Title   : get_entry\n Usage   : my $entry = $matrix->get_entry($rowname,$columname)\n Function: Get the entry for a given row,column pair\n Returns : scalar\n Args    : $row name\n           $column name \n\n\n\nsub get_entry{ $_[0]->entry($_[1],$_[2]) }\n\n=head2 entry_by_num\n\n Title   : entry_by_num\n Usage   : my $entry = $matrix->entry_by_num($rownum,$colnum)\n Function: Get an entry by row and column numbers instead of by name\n           (rows and columns start at 0)\n Returns : scalar value or undef if row or column name does not\n           exist\n Args    : $row - row number\n           $col - column number\n           [optional] $newvalue to store at this cell\n\n\nsub entry_by_num {\n    my ($self,$row,$col,$newvalue) = @_;\n    if( ! defined $row || ! defined $col || \n\t$row !~ /^\\d+$/ ||\n\t$col !~ /^\\d+$/ ) {\n\t$self->warn(\"expected to get 2 number for entry_by_num\");\n\treturn;\n    }\n    \n    if( defined $newvalue ) {\n       return $self->_values->[$row][$col] = $newvalue;\n   } else { \n       return $self->_values->[$row][$col];\n   }\n}\n\nsub get_element { \n    my $self = shift;\n    $self->entry(@_);\n}\n\n\n=head2 column\n\n Title   : column\n Usage   : my @col = $matrix->column('ALPHA');\n           OR\n           $matrix->column('ALPHA', \\@col);\n Function: Get/Set a particular column\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values.  \n           For setting will warn if the new column is of a different\n           length from the rest of the columns.\n Args    : name of the column\n           [optional] new column to store here \n\n\nsub column{\n    my ($self,$column,$newcol) = @_;\n\n    if( ! defined $column ) {\n\t$self->warn(\"Need at least a column id\");\n\treturn;\n    }\n    my $colnum  = $self->column_num_for_name($column);\n    if( ! defined $colnum ) { \n\t$self->warn(\"could not find column number for $column\");\n\treturn;\n    }\n    return $self->column_by_num($colnum,$newcol);\n}\n\n\n=head2 get_column\n\n Title   : get_column\n Usage   : my @row = $matrix->get_column('ALPHA');\n Function: Get a particular column\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the column\n\n\n\nsub get_column { $_[0]->column($_[1]) }\n\n\n=head2 column_by_num\n\n Title   : column_by_num\n Usage   : my @col = $matrix->column_by_num(1);\n           OR\n           $matrix->column_by_num(1,\\@newcol);\n Function: Get/Set a column by its number instead of name\n           (cols/rows start at 0)\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the column\n           [optional] new value to store for a particular column\n\n\nsub column_by_num{\n    my ($self,$colnum,$newcol) = @_;\n    if( ! defined $colnum ) {\n\t$self->warn(\"need at least a column number\");\n\treturn;\n    }\n    my $rowcount = $self->num_rows;\n    my $colcount = $self->num_columns;\n    my $ret;\n    \n    if( defined $newcol ) {\n\tif( ref($newcol) !~ /ARRAY/i) {\n\t    $self->warn(\"expected a valid arrayref for resetting a column\");\n\t    return;\n\t}\n\tif( scalar @$newcol != $rowcount ) {\n\t    $self->warn(\"new column is not the correct length ($rowcount) - call add or remove row to shrink or grow the number of rows first\");\n\t    return;\n\t}\n\tfor(my $i=0; $i < $rowcount; $i++) {\n\t    $self->entry_by_num($i,$colnum,$newcol->[$i]);\n\t}\n\t$ret = $newcol;\n    } else { \n\t$ret = [];\n\tfor(my $i=0; $i < $rowcount; $i++) {\n\t    push @$ret,$self->entry_by_num($i,$colnum);\n\t}\n    }\n    if( wantarray ) { return @$ret } \n    return $ret;\n\n}\n\n=head2 row\n\n Title   : row\n Usage   : my @row = $matrix->row($rowname);\n             OR\n           $matrix->row($rowname,\\@rowvalues);\n Function: Get/Set the row of the matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n Args    : rowname\n           [optional] new value of row to store\n\n\n\nsub row {\n    my ($self,$row,$newrow) = @_;\n    if( ! defined $row) {\n\t$self->warn(\"Need at least a row id\");\n\treturn;\n    }\n    my $rownum = $self->row_num_for_name($row);\n    return $self->row_by_num($rownum,$newrow);\n}\n\n\n=head2 get_row\n\n Title   : get_row\n Usage   : my @row = $matrix->get_row('ALPHA');\n Function: Get a particular row\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the row\n\n\nsub get_row { $_[0]->row($_[1]) }\n\n=head2 row_by_num\n\n Title   : row_by_num\n Usage   : my @row = $matrix->row_by_num($rownum);\n             OR\n           $matrix->row($rownum,\\@rowvalues);\n Function: Get/Set the row of the matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n Args    : rowname\n           [optional] new value of row to store\n\n\nsub row_by_num{\n   my ($self,$rownum,$newrow) = @_;\n   if( ! defined $rownum ) {\n       $self->warn(\"need at least a row number\");\n       return;\n   }\n    my $colcount = $self->num_columns;\n    my $ret;\n    if( defined $newrow ) {\n\tif( ref($newrow) !~ /ARRAY/i) {\n\t    $self->warn(\"expected a valid arrayref for resetting a row\");\n\t    return;\n\t}\n\tif( scalar @$newrow != $colcount ) {\n\t    $self->warn(\"new row is not the correct length ($colcount) - call add or remove column to shrink or grow the number of columns first\");\n\t    return;\n\t}\n\tfor(my $i=0; $i < $colcount; $i++) {\n\t    $self->entry_by_num($rownum,$i, $newrow->[$i]);\n\t}\n\t$ret = $newrow;\n    } else { \n\t$ret = [];\n\tfor(my $i=0; $i < $colcount; $i++) {\n\t    # we're doing this to explicitly \n\t    # copy the entire row\n\t    push @$ret, $self->entry_by_num($rownum,$i);\n\t}\n    }\n    if( wantarray ) { return @$ret } \n    return $ret;\n\n\n}\n\n\n=head2 diagonal\n\n Title   : diagonal\n Usage   : my @diagonal = $matrix->get_diagonal()\n Function: Get the diagonal of a matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values which lie along the diagonal\n Args    : none\n\n\n\nsub get_diagonal{\n   my ($self) = @_;\n   my @diag;\n   my $rowcount = $self->num_rows;\n   my $colcount = $self->num_columns;\n   for(my $i = 0; $i < $rowcount; $i++ ) {\n       push @diag, $self->entry_by_num($i,$i);\n   }\n   return @diag;\n}\n\n\n=head2 add_row\n\n Title   : add_row\n Usage   : $matrix->add_row($index,\\@newrow);\n Function: Adds a row at particular location in the matrix.\n           If $index < the rowcount will shift all the rows down\n           by the number of new rows.\n           To add a single empty row, simply call\n           $matrix->add_row($index,undef);\n Returns : the updated number of total rows in the matrix\n Args    : index to store\n           name of the row (header)\n           newrow to add, if this is undef will add a single\n                     row with all values set to undef \n\n\nsub add_row{\n   my ($self,$index,$name,$newrow) = @_;\n   if( !defined $index || \n       $index !~ /^\\d+$/ ) {\n       $self->warn(\"expected a valid row index in add_row\");\n       return;\n   } elsif( ! defined $name) {\n       $self->warn(\"Need a row name or heading\");\n       return;\n   } elsif( defined $self->row_num_for_name($name) ) {\n       $self->warn(\"Need a unqiue name for the column heading, $name is already used\");\n       return;\n   }\n   my $colcount = $self->num_columns;\n   my $rowcount = $self->num_rows;\n\n   if( $index >  $rowcount ) { \n       $self->warn(\"cannot add a row beyond 1+last row at the end ($rowcount) not $index - adding at $rowcount instead\");\n       $index = $rowcount;\n   }\n\n   if( ! defined $newrow ) {\n       $newrow = [];\n       $newrow->[$colcount] = undef;\n   } elsif( ref($newrow) !~ /ARRAY/i ) {\n       $self->throw(\"Expected either undef or a valid arrayref for add_row\");\n   }\n   # add this row to the matrix by carving out space for it with \n   # splice\n   splice(@{$self->{'_values'}}, $index,0,[]);\n   for( my $i = 0; $i < $colcount; $i++ ) {\n       $self->entry_by_num($index,$i,$newrow->[$i]);\n   }\n   splice(@{$self->{'_rownames'}}, $index,0,$name);\n   # Sadly we have to remap these each time (except for the case\n   # when we're adding a new column to the end, but I don't think\n   # the speedup for that case warrants the extra code at this time.\n   my $ct = 0;\n   %{$self->{'_rownamesmap'}} = map { $_ => $ct++} @{$self->{'_rownames'}};\n   return $self->num_rows;\n}\n\n=head2 remove_row\n\n Title   : remove_row\n Usage   : $matrix->remove_row($colnum)\n Function: remove a row from the matrix shifting all the rows\n           up by one\n Returns : Updated number of rows in the matrix\n Args    : row index\n\n\n\nsub remove_row{\n   my ($self,$rowindex) = @_;\n   my $rowcount = $self->num_rows;\n   \n   if( $rowindex > $rowcount ) {\n       $self->warn(\"rowindex $rowindex is greater than number of rows $rowcount, cannot process\");\n       return 0;\n   } else { \n       splice(@{$self->_values},$rowindex,1);\n       delete $self->{'_rownamesmap'}->{$self->{'_rownames'}->[$rowindex]};\n       splice(@{$self->{'_rownames'}},$rowindex,1);\n   }\n   my $ct = 0;\n   %{$self->{'_rownamesmap'}} = map { $_ => $ct++} @{$self->{'_rownames'}};\n   return $self->num_rows;\n}\n\n=head2 add_column\n\n Title   : add_column\n Usage   : $matrix->add_column($index,$colname,\\@newcol);\n Function: Adds a column at particular location in the matrix.\n           If $index < the colcount will shift all the columns right\n           by the number of new columns.\n           To add a single empty column, simply call\n           $matrix->add_column($index,undef);\n Returns : the updated number of total columns in the matrix\n Args    : index to store\n           name of the column (header)\n           newcolumn to add, if this is undef will add a single\n                 column with all values set to undef \n\n\n\n\nsub add_column{\n   my ($self,$index,$name,$newcol) = @_;\n   if( !defined $index ||\n       $index !~ /^\\d+$/ ) {\n       $self->warn(\"expected a valid col index in add_column\");\n       return;\n   } elsif( ! defined $name) {\n       $self->warn(\"Need a column name or heading\");\n       return;\n   } elsif( defined $self->column_num_for_name($name) ) {\n       $self->warn(\"Need a unqiue name for the column heading, $name is already used\");\n       return;\n   }\n   my $colcount = $self->num_columns;\n   my $rowcount = $self->num_rows;\n   if( $index > $colcount ) { \n       $self->warn(\"cannot add a column beyond 1+last column at the end ($colcount) not $index - adding at $colcount instead\");\n       $index = $colcount;\n   }\n\n   if( ! defined $newcol ) {\n       $newcol = [];\n       $newcol->[$rowcount] = undef; # make the array '$rowcount' long\n   } elsif( ref($newcol) !~ /ARRAY/i ) {\n       $self->throw(\"Expected either undef or a valid arrayref for add_row\");\n   }\n   for( my $i = 0; $i < $rowcount; $i++ ) {\n       # add this column to each row\n       splice(@{$self->_values->[$i]},$index,0,[]);\n       $self->entry_by_num($i,$index,$newcol->[$i]);\n   }\n   splice(@{$self->{'_colnames'}}, $index,0,$name);\n   # Sadly we have to remap these each time (except for the case\n   # when we're adding a new column to the end, but I don't think\n   # the speedup for that case warrants the extra code at this time.\n   my $ct = 0;\n   %{$self->{'_colnamesmap'}} = map {$_ => $ct++} @{$self->{'_colnames'}};\n   return $self->num_columns;\n}\n\n=head2 remove_column\n\n Title   : remove_column\n Usage   : $matrix->remove_column($colnum)\n Function: remove a column from the matrix shifting all the columns\n           to the left by one\n Returns : Updated number of columns in the matrix\n Args    : column index\n\n\nsub remove_column{\n   my ($self,$colindex) = @_;\n\n   my $colcount = $self->num_columns;\n   my $rowcount = $self->num_rows;\n   if( $colindex > $colcount ) {\n\t\t$self->warn(\"colindex $colindex is greater than number of columns ($colcount), cannot process\");\n\t\treturn 0;\n   } else { \n\t\tfor(my $i = 0; $i < $rowcount; $i++ ) {\n\t\t\tsplice(@{$self->_values->[$i]},$colindex,1);\n\t\t}\n\t\tdelete $self->{'_colnamesmap'}->{$self->{'_colnames'}->[$colindex]};\n\t\tsplice(@{$self->{'_colnames'}},$colindex,1);\n   }\n   my $ct = 0;\n   %{$self->{'_colnamesmap'}} = map {$_ => $ct++} @{$self->{'_colnames'}};\n   return $self->num_columns;\n}\n\n=head2 column_num_for_name\n\n Title   : column_num_for_name\n Usage   : my $num = $matrix->column_num_for_name($name)\n Function: Gets the column number for a particular column name\n Returns : integer\n Args    : string\n\n\n\nsub column_num_for_name{\n   my ($self,$name) = @_;\n   \n   return $self->{'_colnamesmap'}->{$name};\n}\n\n=head2 row_num_for_name\n\n Title   : row_num_for_name\n Usage   : my $num = $matrix->row_num_for_name\n Function: Gets the row number for a particular row name\n Returns : integer\n Args    : string\n\n\n\nsub row_num_for_name{\n   my ($self,$name) = @_;\n   return $self->{'_rownamesmap'}->{$name}\n}\n\n\n=head2 column_header\n\n Title   : column_header\n Usage   : my $name = $matrix->column_header(0)\n Function: Gets the column header for a particular column number\n Returns : string\n Args    : integer\n\n\n\nsub column_header{\n   my ($self,$num) = @_;\n   return $self->{'_colnames'}->[$num];\n}\n\n\n=head2 row_header\n\n Title   : row_header\n Usage   : my $name = $matrix->row_header(0)\n Function: Gets the row header for a particular row number\n Returns : string\n Args    : integer\n\n\n\nsub row_header{\n   my ($self,$num) = @_;\n   return $self->{'_rownames'}->[$num];\n}\n\n=head2 num_rows\n\n Title   : num_rows\n Usage   : my $rowcount = $matrix->num_rows;\n Function: Get the number of rows\n Returns : integer\n Args    : none\n\n\n\nsub num_rows{\n   my ($self) = @_;\n   return scalar @{$self->_values};\n}\n\n\n=head2 num_columns\n\n Title   : num_columns\n Usage   : my $colcount = $matrix->num_columns\n Function: Get the number of columns\n Returns : integer\n Args    : none","label":"num_columns($self)"},"name":"num_columns","containerName":"main::","children":[{"definition":"my","name":"$self","containerName":"num_columns","localvar":"my","kind":13,"line":753},{"name":"$self","containerName":"num_columns","kind":13,"line":754},{"line":754,"name":"_values","containerName":"num_columns","kind":12}],"detail":"($self)","definition":"sub"},{"line":769,"range":{"start":{"character":0,"line":769},"end":{"line":772,"character":9999}},"kind":12,"definition":"sub","children":[],"name":"row_names","containerName":"main::"},{"line":771,"name":"shift","kind":12},{"definition":"sub","name":"column_names","containerName":"main::","children":[],"kind":12,"range":{"start":{"character":0,"line":789},"end":{"line":792,"character":9999}},"line":789},{"name":"shift","kind":12,"line":791},{"signature":{"label":"_values($self,$val)","parameters":[{"label":"$self"},{"label":"$val"}],"documentation":"1;\n# $Id: Generic.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Matrix::Generic\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::Generic - A generic matrix implementation\n\n=head1 SYNOPSIS\n\n  # A matrix has columns and rows \n  my $matrix = Bio::Matrix::Generic->new;\n  $matrix->add_column(1,$column1);\n  $matrix->add_column(2,$column2);\n\n  my $element = $matrix->entry_by_num(1,2);\n  $matrix->entry_by_num(1,2,$newval);\n\n  my $entry = $matrix->entry('human', 'mouse');\n\n  $matrix->entry('human','mouse', $newval);\n\n\n=head1 DESCRIPTION\n\nThis is a general purpose matrix object for dealing with row+column\ndata which is typical when enumerating all the pairwise combinations\nand desiring to get slices of the data.\n\nData can be accessed by column and row names or indexes.  Matrix\nindexes start at 0.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Matrix::Generic;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Matrix::MatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Matrix::Generic->new();\n Function: Builds a new Bio::Matrix::Generic object \n Returns : an instance of Bio::Matrix::Generic\n Args    : -values     => arrayref of arrayrefs of data initialization \n           -rownames   => arrayref of row names\n           -colnames   => arrayref of col names\n           -matrix_id  => id of the matrix\n           -matrix_name=> name of the matrix\n           -matrix_init_value => default value to initialize empty cells\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($values, $rownames, $colnames,\n      $id,$name,$init_val) = \n\t  $self->_rearrange([qw(VALUES ROWNAMES COLNAMES \n\t\t\t        MATRIX_ID MATRIX_NAME \n                                MATRIX_INIT_VALUE)],@args);\n  $self->matrix_id($id) if  defined $id;\n  $self->matrix_name($name) if defined $name;\n  if( defined $rownames && defined $colnames ) {\n      if( ref($rownames) !~ /ARRAY/i ) {\n\t  $self->throw(\"need an arrayref for the -rownames option\");\n      }\n      # insure we copy the values\n      $self->{'_rownames'} = [ @$rownames ];\n      my $count = 0;\n      %{$self->{'_rownamesmap'}} = map { $_ => $count++ } @$rownames; \n\n      if( ref($colnames) !~ /ARRAY/i ) {\n\t  $self->throw(\"need an arrayref for the -colnames option\");\n      }\n      # insure we copy the values\n      $self->{'_colnames'} = [ @$colnames ];\n      $count = 0;\n      %{$self->{'_colnamesmap'}} = map { $_ => $count++ } @$colnames; \n\n      $self->{'_values'} = [];\n      if( defined $values ) {\n\t  if( ref($values) !~ /ARRAY/i ) {\n\t      $self->throw(\"Need an arrayref of arrayrefs (matrix) for -values option\");\n\t  }\t  \n\t  for my $v ( @$values ) {\n\t      if( ref($v) !~ /ARRAY/i ) {\n\t\t  $self->throw(\"Need and array of arrayrefs (matrix) for -values option\");\n\t      }\n\t      push @{$self->{'_values'}}, [@$v];\n\t  }\n      } else {\n\t  my @fill = ($init_val) x scalar @$colnames; # undef init_val will be default\n\t  for ( @$rownames ) {\n\t      push @{$self->{'_values'}}, [@fill];\n\t  }\n      }\n  } elsif( ! defined $rownames && ! defined $colnames && ! defined $values ) {\n      $self->{'_values'}   = [];\n      $self->{'_rownames'} = [];\n      $self->{'_colnames'} = [];\n  } else { \n      $self->throw(\"Must have either provided no values/colnames/rownames or provided all three\");\n  }\n\n  return $self;\n}\n\n\n=head2 matrix_id\n\n Title   : matrix_id\n Usage   : my $id = $matrix->matrix_id\n Function: Get/Set the matrix ID\n Returns : scalar value\n Args    : [optional] new id value to store\n\n\n\nsub matrix_id{\n   my $self = shift;\n   return $self->{'_matid'} = shift if @_;\n   return $self->{'_matid'};\n\n   \n}\n\n=head2 matrix_name\n\n Title   : matrix_name\n Usage   : my $name = $matrix->matrix_name();\n Function: Get/Set the matrix name\n Returns : scalar value\n Args    : [optional] new matrix name value\n\n\n\nsub matrix_name{\n   my $self = shift;\n   return $self->{'_matname'} = shift if @_;\n   return $self->{'_matname'};\n}\n\n\n=head2 entry\n\n Title   : entry\n Usage   : my $entry = $matrix->entry($row,$col)\n Function: Get the value for a specific cell as specified\n           by the row and column names\n Returns : scalar value or undef if row or col does not\n           exist\n Args    : $rowname - name of the row\n           $colname - column name\n\n\nsub entry{\n   my ($self,$row,$column,$newvalue) = @_;\n   if( ! defined $row || ! defined $column ) {\n       $self->throw(\"Need at least 2 ids\");\n   }\n\n   my ($rownum) = $self->row_num_for_name($row);\n   my ($colnum) = $self->column_num_for_name($column);\n   return $self->entry_by_num($rownum,$colnum,$newvalue);\n}\n\n=head2 get_entry\n\n Title   : get_entry\n Usage   : my $entry = $matrix->get_entry($rowname,$columname)\n Function: Get the entry for a given row,column pair\n Returns : scalar\n Args    : $row name\n           $column name \n\n\n\nsub get_entry{ $_[0]->entry($_[1],$_[2]) }\n\n=head2 entry_by_num\n\n Title   : entry_by_num\n Usage   : my $entry = $matrix->entry_by_num($rownum,$colnum)\n Function: Get an entry by row and column numbers instead of by name\n           (rows and columns start at 0)\n Returns : scalar value or undef if row or column name does not\n           exist\n Args    : $row - row number\n           $col - column number\n           [optional] $newvalue to store at this cell\n\n\nsub entry_by_num {\n    my ($self,$row,$col,$newvalue) = @_;\n    if( ! defined $row || ! defined $col || \n\t$row !~ /^\\d+$/ ||\n\t$col !~ /^\\d+$/ ) {\n\t$self->warn(\"expected to get 2 number for entry_by_num\");\n\treturn;\n    }\n    \n    if( defined $newvalue ) {\n       return $self->_values->[$row][$col] = $newvalue;\n   } else { \n       return $self->_values->[$row][$col];\n   }\n}\n\nsub get_element { \n    my $self = shift;\n    $self->entry(@_);\n}\n\n\n=head2 column\n\n Title   : column\n Usage   : my @col = $matrix->column('ALPHA');\n           OR\n           $matrix->column('ALPHA', \\@col);\n Function: Get/Set a particular column\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values.  \n           For setting will warn if the new column is of a different\n           length from the rest of the columns.\n Args    : name of the column\n           [optional] new column to store here \n\n\nsub column{\n    my ($self,$column,$newcol) = @_;\n\n    if( ! defined $column ) {\n\t$self->warn(\"Need at least a column id\");\n\treturn;\n    }\n    my $colnum  = $self->column_num_for_name($column);\n    if( ! defined $colnum ) { \n\t$self->warn(\"could not find column number for $column\");\n\treturn;\n    }\n    return $self->column_by_num($colnum,$newcol);\n}\n\n\n=head2 get_column\n\n Title   : get_column\n Usage   : my @row = $matrix->get_column('ALPHA');\n Function: Get a particular column\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the column\n\n\n\nsub get_column { $_[0]->column($_[1]) }\n\n\n=head2 column_by_num\n\n Title   : column_by_num\n Usage   : my @col = $matrix->column_by_num(1);\n           OR\n           $matrix->column_by_num(1,\\@newcol);\n Function: Get/Set a column by its number instead of name\n           (cols/rows start at 0)\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the column\n           [optional] new value to store for a particular column\n\n\nsub column_by_num{\n    my ($self,$colnum,$newcol) = @_;\n    if( ! defined $colnum ) {\n\t$self->warn(\"need at least a column number\");\n\treturn;\n    }\n    my $rowcount = $self->num_rows;\n    my $colcount = $self->num_columns;\n    my $ret;\n    \n    if( defined $newcol ) {\n\tif( ref($newcol) !~ /ARRAY/i) {\n\t    $self->warn(\"expected a valid arrayref for resetting a column\");\n\t    return;\n\t}\n\tif( scalar @$newcol != $rowcount ) {\n\t    $self->warn(\"new column is not the correct length ($rowcount) - call add or remove row to shrink or grow the number of rows first\");\n\t    return;\n\t}\n\tfor(my $i=0; $i < $rowcount; $i++) {\n\t    $self->entry_by_num($i,$colnum,$newcol->[$i]);\n\t}\n\t$ret = $newcol;\n    } else { \n\t$ret = [];\n\tfor(my $i=0; $i < $rowcount; $i++) {\n\t    push @$ret,$self->entry_by_num($i,$colnum);\n\t}\n    }\n    if( wantarray ) { return @$ret } \n    return $ret;\n\n}\n\n=head2 row\n\n Title   : row\n Usage   : my @row = $matrix->row($rowname);\n             OR\n           $matrix->row($rowname,\\@rowvalues);\n Function: Get/Set the row of the matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n Args    : rowname\n           [optional] new value of row to store\n\n\n\nsub row {\n    my ($self,$row,$newrow) = @_;\n    if( ! defined $row) {\n\t$self->warn(\"Need at least a row id\");\n\treturn;\n    }\n    my $rownum = $self->row_num_for_name($row);\n    return $self->row_by_num($rownum,$newrow);\n}\n\n\n=head2 get_row\n\n Title   : get_row\n Usage   : my @row = $matrix->get_row('ALPHA');\n Function: Get a particular row\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the row\n\n\nsub get_row { $_[0]->row($_[1]) }\n\n=head2 row_by_num\n\n Title   : row_by_num\n Usage   : my @row = $matrix->row_by_num($rownum);\n             OR\n           $matrix->row($rownum,\\@rowvalues);\n Function: Get/Set the row of the matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n Args    : rowname\n           [optional] new value of row to store\n\n\nsub row_by_num{\n   my ($self,$rownum,$newrow) = @_;\n   if( ! defined $rownum ) {\n       $self->warn(\"need at least a row number\");\n       return;\n   }\n    my $colcount = $self->num_columns;\n    my $ret;\n    if( defined $newrow ) {\n\tif( ref($newrow) !~ /ARRAY/i) {\n\t    $self->warn(\"expected a valid arrayref for resetting a row\");\n\t    return;\n\t}\n\tif( scalar @$newrow != $colcount ) {\n\t    $self->warn(\"new row is not the correct length ($colcount) - call add or remove column to shrink or grow the number of columns first\");\n\t    return;\n\t}\n\tfor(my $i=0; $i < $colcount; $i++) {\n\t    $self->entry_by_num($rownum,$i, $newrow->[$i]);\n\t}\n\t$ret = $newrow;\n    } else { \n\t$ret = [];\n\tfor(my $i=0; $i < $colcount; $i++) {\n\t    # we're doing this to explicitly \n\t    # copy the entire row\n\t    push @$ret, $self->entry_by_num($rownum,$i);\n\t}\n    }\n    if( wantarray ) { return @$ret } \n    return $ret;\n\n\n}\n\n\n=head2 diagonal\n\n Title   : diagonal\n Usage   : my @diagonal = $matrix->get_diagonal()\n Function: Get the diagonal of a matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values which lie along the diagonal\n Args    : none\n\n\n\nsub get_diagonal{\n   my ($self) = @_;\n   my @diag;\n   my $rowcount = $self->num_rows;\n   my $colcount = $self->num_columns;\n   for(my $i = 0; $i < $rowcount; $i++ ) {\n       push @diag, $self->entry_by_num($i,$i);\n   }\n   return @diag;\n}\n\n\n=head2 add_row\n\n Title   : add_row\n Usage   : $matrix->add_row($index,\\@newrow);\n Function: Adds a row at particular location in the matrix.\n           If $index < the rowcount will shift all the rows down\n           by the number of new rows.\n           To add a single empty row, simply call\n           $matrix->add_row($index,undef);\n Returns : the updated number of total rows in the matrix\n Args    : index to store\n           name of the row (header)\n           newrow to add, if this is undef will add a single\n                     row with all values set to undef \n\n\nsub add_row{\n   my ($self,$index,$name,$newrow) = @_;\n   if( !defined $index || \n       $index !~ /^\\d+$/ ) {\n       $self->warn(\"expected a valid row index in add_row\");\n       return;\n   } elsif( ! defined $name) {\n       $self->warn(\"Need a row name or heading\");\n       return;\n   } elsif( defined $self->row_num_for_name($name) ) {\n       $self->warn(\"Need a unqiue name for the column heading, $name is already used\");\n       return;\n   }\n   my $colcount = $self->num_columns;\n   my $rowcount = $self->num_rows;\n\n   if( $index >  $rowcount ) { \n       $self->warn(\"cannot add a row beyond 1+last row at the end ($rowcount) not $index - adding at $rowcount instead\");\n       $index = $rowcount;\n   }\n\n   if( ! defined $newrow ) {\n       $newrow = [];\n       $newrow->[$colcount] = undef;\n   } elsif( ref($newrow) !~ /ARRAY/i ) {\n       $self->throw(\"Expected either undef or a valid arrayref for add_row\");\n   }\n   # add this row to the matrix by carving out space for it with \n   # splice\n   splice(@{$self->{'_values'}}, $index,0,[]);\n   for( my $i = 0; $i < $colcount; $i++ ) {\n       $self->entry_by_num($index,$i,$newrow->[$i]);\n   }\n   splice(@{$self->{'_rownames'}}, $index,0,$name);\n   # Sadly we have to remap these each time (except for the case\n   # when we're adding a new column to the end, but I don't think\n   # the speedup for that case warrants the extra code at this time.\n   my $ct = 0;\n   %{$self->{'_rownamesmap'}} = map { $_ => $ct++} @{$self->{'_rownames'}};\n   return $self->num_rows;\n}\n\n=head2 remove_row\n\n Title   : remove_row\n Usage   : $matrix->remove_row($colnum)\n Function: remove a row from the matrix shifting all the rows\n           up by one\n Returns : Updated number of rows in the matrix\n Args    : row index\n\n\n\nsub remove_row{\n   my ($self,$rowindex) = @_;\n   my $rowcount = $self->num_rows;\n   \n   if( $rowindex > $rowcount ) {\n       $self->warn(\"rowindex $rowindex is greater than number of rows $rowcount, cannot process\");\n       return 0;\n   } else { \n       splice(@{$self->_values},$rowindex,1);\n       delete $self->{'_rownamesmap'}->{$self->{'_rownames'}->[$rowindex]};\n       splice(@{$self->{'_rownames'}},$rowindex,1);\n   }\n   my $ct = 0;\n   %{$self->{'_rownamesmap'}} = map { $_ => $ct++} @{$self->{'_rownames'}};\n   return $self->num_rows;\n}\n\n=head2 add_column\n\n Title   : add_column\n Usage   : $matrix->add_column($index,$colname,\\@newcol);\n Function: Adds a column at particular location in the matrix.\n           If $index < the colcount will shift all the columns right\n           by the number of new columns.\n           To add a single empty column, simply call\n           $matrix->add_column($index,undef);\n Returns : the updated number of total columns in the matrix\n Args    : index to store\n           name of the column (header)\n           newcolumn to add, if this is undef will add a single\n                 column with all values set to undef \n\n\n\n\nsub add_column{\n   my ($self,$index,$name,$newcol) = @_;\n   if( !defined $index ||\n       $index !~ /^\\d+$/ ) {\n       $self->warn(\"expected a valid col index in add_column\");\n       return;\n   } elsif( ! defined $name) {\n       $self->warn(\"Need a column name or heading\");\n       return;\n   } elsif( defined $self->column_num_for_name($name) ) {\n       $self->warn(\"Need a unqiue name for the column heading, $name is already used\");\n       return;\n   }\n   my $colcount = $self->num_columns;\n   my $rowcount = $self->num_rows;\n   if( $index > $colcount ) { \n       $self->warn(\"cannot add a column beyond 1+last column at the end ($colcount) not $index - adding at $colcount instead\");\n       $index = $colcount;\n   }\n\n   if( ! defined $newcol ) {\n       $newcol = [];\n       $newcol->[$rowcount] = undef; # make the array '$rowcount' long\n   } elsif( ref($newcol) !~ /ARRAY/i ) {\n       $self->throw(\"Expected either undef or a valid arrayref for add_row\");\n   }\n   for( my $i = 0; $i < $rowcount; $i++ ) {\n       # add this column to each row\n       splice(@{$self->_values->[$i]},$index,0,[]);\n       $self->entry_by_num($i,$index,$newcol->[$i]);\n   }\n   splice(@{$self->{'_colnames'}}, $index,0,$name);\n   # Sadly we have to remap these each time (except for the case\n   # when we're adding a new column to the end, but I don't think\n   # the speedup for that case warrants the extra code at this time.\n   my $ct = 0;\n   %{$self->{'_colnamesmap'}} = map {$_ => $ct++} @{$self->{'_colnames'}};\n   return $self->num_columns;\n}\n\n=head2 remove_column\n\n Title   : remove_column\n Usage   : $matrix->remove_column($colnum)\n Function: remove a column from the matrix shifting all the columns\n           to the left by one\n Returns : Updated number of columns in the matrix\n Args    : column index\n\n\nsub remove_column{\n   my ($self,$colindex) = @_;\n\n   my $colcount = $self->num_columns;\n   my $rowcount = $self->num_rows;\n   if( $colindex > $colcount ) {\n\t\t$self->warn(\"colindex $colindex is greater than number of columns ($colcount), cannot process\");\n\t\treturn 0;\n   } else { \n\t\tfor(my $i = 0; $i < $rowcount; $i++ ) {\n\t\t\tsplice(@{$self->_values->[$i]},$colindex,1);\n\t\t}\n\t\tdelete $self->{'_colnamesmap'}->{$self->{'_colnames'}->[$colindex]};\n\t\tsplice(@{$self->{'_colnames'}},$colindex,1);\n   }\n   my $ct = 0;\n   %{$self->{'_colnamesmap'}} = map {$_ => $ct++} @{$self->{'_colnames'}};\n   return $self->num_columns;\n}\n\n=head2 column_num_for_name\n\n Title   : column_num_for_name\n Usage   : my $num = $matrix->column_num_for_name($name)\n Function: Gets the column number for a particular column name\n Returns : integer\n Args    : string\n\n\n\nsub column_num_for_name{\n   my ($self,$name) = @_;\n   \n   return $self->{'_colnamesmap'}->{$name};\n}\n\n=head2 row_num_for_name\n\n Title   : row_num_for_name\n Usage   : my $num = $matrix->row_num_for_name\n Function: Gets the row number for a particular row name\n Returns : integer\n Args    : string\n\n\n\nsub row_num_for_name{\n   my ($self,$name) = @_;\n   return $self->{'_rownamesmap'}->{$name}\n}\n\n\n=head2 column_header\n\n Title   : column_header\n Usage   : my $name = $matrix->column_header(0)\n Function: Gets the column header for a particular column number\n Returns : string\n Args    : integer\n\n\n\nsub column_header{\n   my ($self,$num) = @_;\n   return $self->{'_colnames'}->[$num];\n}\n\n\n=head2 row_header\n\n Title   : row_header\n Usage   : my $name = $matrix->row_header(0)\n Function: Gets the row header for a particular row number\n Returns : string\n Args    : integer\n\n\n\nsub row_header{\n   my ($self,$num) = @_;\n   return $self->{'_rownames'}->[$num];\n}\n\n=head2 num_rows\n\n Title   : num_rows\n Usage   : my $rowcount = $matrix->num_rows;\n Function: Get the number of rows\n Returns : integer\n Args    : none\n\n\n\nsub num_rows{\n   my ($self) = @_;\n   return scalar @{$self->_values};\n}\n\n\n=head2 num_columns\n\n Title   : num_columns\n Usage   : my $colcount = $matrix->num_columns\n Function: Get the number of columns\n Returns : integer\n Args    : none\n\n\n\nsub num_columns{\n   my ($self) = @_;\n   return scalar @{$self->_values->[0] || []};\n}\n\n\n=head2 row_names\n\n Title   : row_names\n Usage   : my @rows = $matrix->row_names\n Function: The names of all the rows\n Returns : array in array context, arrayref in scalar context\n Args    : none\n\n\n\nsub row_names{\n   if( wantarray ) { \n       return @{shift->{'_rownames'}};\n   } else { \n       return shift->{'_rownames'};\n   }\n}\n\n\n=head2 column_names\n\n Title   : column_names\n Usage   : my @columns = $matrix->column_names\n Function: The names of all the columns\n Returns : array in array context, arrayref in scalar context\n Args    : none\n\n\n\nsub column_names{\n   if( wantarray ) { \n       return @{shift->{'_colnames'}};\n   } else { \n       return shift->{'_colnames'};\n   }\n}\n\n=head2 private methods\n\nPrivate methods for a Generic Matrix\n\n=head2 _values\n\n Title   : _values\n Usage   : $matrix->_values();\n Function: get/set for array ref of the matrix containing\n           distance values \n Returns : an array reference \n Args    : an array reference"},"kind":12,"range":{"end":{"line":819,"character":9999},"start":{"character":0,"line":813}},"line":813,"detail":"($self,$val)","definition":"sub","containerName":"main::","name":"_values","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"_values","kind":13,"line":814},{"line":814,"name":"$val","kind":13,"containerName":"_values"},{"name":"$val","containerName":"_values","kind":13,"line":815},{"name":"$self","kind":13,"containerName":"_values","line":816},{"containerName":"_values","kind":13,"name":"$val","line":816},{"line":818,"name":"$self","kind":13,"containerName":"_values"}]}]}