{"version":5,"vars":[{"name":"Util","containerName":"strict::Bio::Map::PositionHandler::Bio::Map::Mappable::Scalar","kind":2,"line":93},{"line":95,"name":"base","kind":2,"containerName":""},{"kind":12,"range":{"start":{"character":0,"line":114},"end":{"character":9999,"line":122}},"line":114,"name":"get_position_handler","containerName":"main::","children":[{"definition":"my","line":115,"containerName":"get_position_handler","localvar":"my","kind":13,"name":"$self"},{"name":"$self","kind":13,"containerName":"get_position_handler","line":116},{"line":117,"name":"$ph","localvar":"my","kind":13,"containerName":"get_position_handler","definition":"my"},{"name":"new","containerName":"get_position_handler","kind":12,"line":117},{"kind":13,"containerName":"get_position_handler","name":"$self","line":117},{"name":"$self","containerName":"get_position_handler","kind":13,"line":118},{"kind":13,"containerName":"get_position_handler","name":"$ph","line":118},{"line":119,"containerName":"get_position_handler","kind":13,"name":"$ph"},{"line":119,"name":"register","containerName":"get_position_handler","kind":12},{"line":121,"name":"$self","kind":13,"containerName":"get_position_handler"}],"definition":"sub"},{"line":116,"kind":12,"name":"_eh"},{"line":117,"kind":12,"containerName":"Map::PositionHandler","name":"Bio"},{"name":"_eh","kind":12,"line":118},{"line":121,"kind":12,"name":"_eh"},{"line":143,"range":{"end":{"line":146,"character":9999},"start":{"character":0,"line":143}},"kind":12,"signature":{"documentation":"1;\n# $Id: PositionI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::PositionI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::PositionI - Abstracts the notion of a position having a value in the context of a marker and a Map\n\n=head1 SYNOPSIS\n\n    # do not use this module directly\n    # See Bio::Map::Position for an example of\n    # implementation.\n\n=head1 DESCRIPTION\n\nThis object stores one of the postions that a mappable object\n(e.g. Marker) may have in a map.\n\nPositions can have non-numeric values or other methods to store the locations,\nso they have a method numeric() which does the conversion. numeric()\nreturns the position in a form that can be compared between other positions of\nthe same type. It is not necessarily a value suitable for sorting positions (it\nmay be the distance from the previous position); for that purpose the result of\nsortable() should be used.\n\nA 'position', in addition to being a single point, can also be an area and so\ncan be imagined as a range and compared with other positions on the basis of\noverlap, intersection etc.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nLincoln Stein, lstein-at-cshl.org\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::PositionI;\nuse strict;\nuse Bio::Map::PositionHandler;\nuse Bio::Map::Mappable;\nuse Scalar::Util qw(looks_like_number);\n\nuse base qw(Bio::Map::EntityI Bio::RangeI);\n\n=head2 EntityI methods\n\n These are fundamental to coordination of Positions and other entities, so are\n implemented at the interface level\n\n\n=head2 get_position_handler\n\n Title   : get_position_handler\n Usage   : my $position_handler = $entity->get_position_handler();\n Function: Gets a PositionHandlerI that $entity is registered with.\n Returns : Bio::Map::PositionHandlerI object\n Args    : none\n\n\nsub get_position_handler {\n    my $self = shift;\n    unless (defined $self->{_eh}) {\n        my $ph = Bio::Map::PositionHandler->new(-self => $self);\n        $self->{_eh} = $ph;\n        $ph->register;\n    }\n    return $self->{_eh};\n}\n\n=head2 PositionHandlerI-related methods\n\n These are fundamental to coordination of Positions and other entities, so are\n implemented at the interface level\n\n\n=head2 map\n\n Title   : map\n Usage   : my $map = $position->map();\n           $position->map($map);\n Function: Get/Set the map the position is in.\n Returns : L<Bio::Map::MapI>\n Args    : none to get\n           new L<Bio::Map::MapI> to set","parameters":[{"label":"$self"},{"label":"$map"}],"label":"map($self,$map)"},"children":[{"definition":"my","line":144,"kind":13,"localvar":"my","containerName":"map","name":"$self"},{"line":144,"containerName":"map","kind":13,"name":"$map"},{"name":"$self","containerName":"map","kind":13,"line":145},{"line":145,"name":"get_position_handler","kind":12,"containerName":"map"},{"containerName":"map","kind":12,"name":"map","line":145},{"line":145,"name":"$map","kind":13,"containerName":"map"}],"containerName":"main::","name":"map","definition":"sub","detail":"($self,$map)"},{"definition":"sub","detail":"($self,$element)","children":[{"name":"$self","localvar":"my","kind":13,"containerName":"element","line":161,"definition":"my"},{"line":161,"containerName":"element","kind":13,"name":"$element"},{"line":162,"kind":13,"containerName":"element","name":"$self"},{"name":"get_position_handler","kind":12,"containerName":"element","line":162},{"line":162,"name":"element","kind":12,"containerName":"element"},{"line":162,"name":"$element","kind":13,"containerName":"element"}],"name":"element","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$element"}],"documentation":"1;\n# $Id: PositionI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::PositionI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::PositionI - Abstracts the notion of a position having a value in the context of a marker and a Map\n\n=head1 SYNOPSIS\n\n    # do not use this module directly\n    # See Bio::Map::Position for an example of\n    # implementation.\n\n=head1 DESCRIPTION\n\nThis object stores one of the postions that a mappable object\n(e.g. Marker) may have in a map.\n\nPositions can have non-numeric values or other methods to store the locations,\nso they have a method numeric() which does the conversion. numeric()\nreturns the position in a form that can be compared between other positions of\nthe same type. It is not necessarily a value suitable for sorting positions (it\nmay be the distance from the previous position); for that purpose the result of\nsortable() should be used.\n\nA 'position', in addition to being a single point, can also be an area and so\ncan be imagined as a range and compared with other positions on the basis of\noverlap, intersection etc.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nLincoln Stein, lstein-at-cshl.org\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::PositionI;\nuse strict;\nuse Bio::Map::PositionHandler;\nuse Bio::Map::Mappable;\nuse Scalar::Util qw(looks_like_number);\n\nuse base qw(Bio::Map::EntityI Bio::RangeI);\n\n=head2 EntityI methods\n\n These are fundamental to coordination of Positions and other entities, so are\n implemented at the interface level\n\n\n=head2 get_position_handler\n\n Title   : get_position_handler\n Usage   : my $position_handler = $entity->get_position_handler();\n Function: Gets a PositionHandlerI that $entity is registered with.\n Returns : Bio::Map::PositionHandlerI object\n Args    : none\n\n\nsub get_position_handler {\n    my $self = shift;\n    unless (defined $self->{_eh}) {\n        my $ph = Bio::Map::PositionHandler->new(-self => $self);\n        $self->{_eh} = $ph;\n        $ph->register;\n    }\n    return $self->{_eh};\n}\n\n=head2 PositionHandlerI-related methods\n\n These are fundamental to coordination of Positions and other entities, so are\n implemented at the interface level\n\n\n=head2 map\n\n Title   : map\n Usage   : my $map = $position->map();\n           $position->map($map);\n Function: Get/Set the map the position is in.\n Returns : L<Bio::Map::MapI>\n Args    : none to get\n           new L<Bio::Map::MapI> to set\n\n\nsub map {\n    my ($self, $map) = @_;\n    return $self->get_position_handler->map($map);\n}\n\n=head2 element\n\n Title   : element\n Usage   : my $element = $position->element();\n           $position->element($element);\n Function: Get/Set the element the position is for.\n Returns : L<Bio::Map::MappableI>\n Args    : none to get\n           new L<Bio::Map::MappableI> to set","label":"element($self,$element)"},"line":160,"kind":12,"range":{"start":{"line":160,"character":0},"end":{"line":163,"character":9999}}},{"definition":"sub","children":[{"name":"$self","containerName":"value","localvar":"my","kind":13,"line":190,"definition":"my"},{"line":191,"name":"$self","containerName":"value","kind":13},{"line":191,"kind":12,"containerName":"value","name":"throw_not_implemented"}],"name":"value","containerName":"main::","line":189,"range":{"end":{"line":192,"character":9999},"start":{"character":0,"line":189}},"kind":12},{"kind":12,"range":{"end":{"character":9999,"line":210},"start":{"character":0,"line":207}},"line":207,"definition":"sub","name":"numeric","containerName":"main::","children":[{"definition":"my","line":208,"name":"$self","localvar":"my","containerName":"numeric","kind":13},{"line":209,"name":"$self","kind":13,"containerName":"numeric"},{"line":209,"containerName":"numeric","kind":12,"name":"throw_not_implemented"}]},{"line":225,"range":{"end":{"line":228,"character":9999},"start":{"character":0,"line":225}},"kind":12,"children":[{"definition":"my","line":226,"containerName":"sortable","localvar":"my","kind":13,"name":"$self"},{"line":227,"name":"$self","containerName":"sortable","kind":13},{"line":227,"kind":12,"containerName":"sortable","name":"throw_not_implemented"}],"name":"sortable","containerName":"main::","definition":"sub"},{"line":244,"range":{"end":{"line":247,"character":9999},"start":{"character":0,"line":244}},"kind":12,"children":[{"localvar":"my","containerName":"relative","kind":13,"name":"$self","line":245,"definition":"my"},{"line":246,"containerName":"relative","kind":13,"name":"$self"},{"name":"throw_not_implemented","containerName":"relative","kind":12,"line":246}],"name":"relative","containerName":"main::","definition":"sub"},{"line":273,"range":{"end":{"line":276,"character":9999},"start":{"line":273,"character":0}},"kind":12,"children":[{"definition":"my","line":274,"containerName":"absolute","localvar":"my","kind":13,"name":"$self"},{"name":"$self","kind":13,"containerName":"absolute","line":275},{"line":275,"containerName":"absolute","kind":12,"name":"throw_not_implemented"}],"containerName":"main::","name":"absolute","definition":"sub"},{"kind":12,"range":{"end":{"line":333,"character":9999},"start":{"line":331,"character":0}},"line":331,"name":"strand","containerName":"main::","children":[],"definition":"sub"},{"line":346,"kind":12,"range":{"end":{"line":349,"character":9999},"start":{"line":346,"character":0}},"children":[{"definition":"my","line":347,"name":"$self","containerName":"toString","localvar":"my","kind":13},{"line":348,"name":"$self","kind":13,"containerName":"toString"},{"containerName":"toString","kind":12,"name":"throw_not_implemented","line":348}],"containerName":"main::","name":"toString","definition":"sub"},{"signature":{"parameters":[{"label":"$self"},{"label":"$other"},{"label":"$so"},{"label":"$rel"}],"documentation":"1;\n# $Id: PositionI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::PositionI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::PositionI - Abstracts the notion of a position having a value in the context of a marker and a Map\n\n=head1 SYNOPSIS\n\n    # do not use this module directly\n    # See Bio::Map::Position for an example of\n    # implementation.\n\n=head1 DESCRIPTION\n\nThis object stores one of the postions that a mappable object\n(e.g. Marker) may have in a map.\n\nPositions can have non-numeric values or other methods to store the locations,\nso they have a method numeric() which does the conversion. numeric()\nreturns the position in a form that can be compared between other positions of\nthe same type. It is not necessarily a value suitable for sorting positions (it\nmay be the distance from the previous position); for that purpose the result of\nsortable() should be used.\n\nA 'position', in addition to being a single point, can also be an area and so\ncan be imagined as a range and compared with other positions on the basis of\noverlap, intersection etc.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nLincoln Stein, lstein-at-cshl.org\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::PositionI;\nuse strict;\nuse Bio::Map::PositionHandler;\nuse Bio::Map::Mappable;\nuse Scalar::Util qw(looks_like_number);\n\nuse base qw(Bio::Map::EntityI Bio::RangeI);\n\n=head2 EntityI methods\n\n These are fundamental to coordination of Positions and other entities, so are\n implemented at the interface level\n\n\n=head2 get_position_handler\n\n Title   : get_position_handler\n Usage   : my $position_handler = $entity->get_position_handler();\n Function: Gets a PositionHandlerI that $entity is registered with.\n Returns : Bio::Map::PositionHandlerI object\n Args    : none\n\n\nsub get_position_handler {\n    my $self = shift;\n    unless (defined $self->{_eh}) {\n        my $ph = Bio::Map::PositionHandler->new(-self => $self);\n        $self->{_eh} = $ph;\n        $ph->register;\n    }\n    return $self->{_eh};\n}\n\n=head2 PositionHandlerI-related methods\n\n These are fundamental to coordination of Positions and other entities, so are\n implemented at the interface level\n\n\n=head2 map\n\n Title   : map\n Usage   : my $map = $position->map();\n           $position->map($map);\n Function: Get/Set the map the position is in.\n Returns : L<Bio::Map::MapI>\n Args    : none to get\n           new L<Bio::Map::MapI> to set\n\n\nsub map {\n    my ($self, $map) = @_;\n    return $self->get_position_handler->map($map);\n}\n\n=head2 element\n\n Title   : element\n Usage   : my $element = $position->element();\n           $position->element($element);\n Function: Get/Set the element the position is for.\n Returns : L<Bio::Map::MappableI>\n Args    : none to get\n           new L<Bio::Map::MappableI> to set\n\n\nsub element {\n    my ($self, $element) = @_;\n    return $self->get_position_handler->element($element);\n}\n\n=head2 marker\n\n Title   : marker\n Function: This is a synonym of the element() method\n Status  : deprecated, will be removed in the next version\n\n\n*marker = \\&element;\n\n=head2 PositionI-specific methods\n\n\n=head2 value\n\n Title   : value\n Usage   : my $pos = $position->value();\n Function: Get/Set the value for this position\n Returns : scalar, value\n Args    : [optional] new value to set\n\n\nsub value {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head2 numeric\n\n Title   : numeric\n Usage   : my $num = $position->numeric;\n Function: Read-only method that is guaranteed to return a numeric \n           representation of the start of this position. \n Returns : scalar numeric\n Args    : none to get the co-ordinate normally (see absolute() method), OR\n           Bio::Map::RelativeI to get the co-ordinate converted to be\n           relative to what this Relative describes.\n\n\nsub numeric {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head2 sortable\n\n Title   : sortable\n Usage   : my $num = $position->sortable();\n Function: Read-only method that is guaranteed to return a value suitable\n           for correctly sorting this kind of position amongst other positions\n           of the same kind on the same map. Note that sorting different kinds\n           of position together is unlikely to give sane results.\n Returns : numeric\n Args    : none\n\n\nsub sortable {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head2 relative\n\n  Title   : relative\n  Usage   : my $relative = $position->relative();\n            $position->relative($relative);\n  Function: Get/set the thing this Position's coordinates (numerical(), start(),\n            end()) are relative to, as described by a Relative object.\n  Returns : Bio::Map::RelativeI (default is one describing \"relative to the\n            start of the Position's map\")\n  Args    : none to get, OR\n            Bio::Map::RelativeI to set\n\n\nsub relative {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head2 absolute\n\n  Title   : absolute\n  Usage   : my $absolute = $position->absolute();\n            $position->absolute($absolute);\n  Function: Get/set how this Position's co-ordinates (numerical(), start(),\n            end()) are reported. When absolute is off, co-ordinates are\n            relative to the thing described by relative(). Ie. the value\n            returned by start() will be the same as the value you set start()\n            to. When absolute is on, co-ordinates are converted to be relative\n            to the start of the map.\n\n            So if relative() currently points to a Relative object describing\n            \"relative to another position which is 100 bp from the start of\n            the map\", this Position's start() had been set to 50 and absolute()\n            returns 1, $position->start() will return 150. If absolute() returns\n            0 in the same situation, $position->start() would return 50.\n\n  Returns : boolean (default 0)\n  Args    : none to get, OR\n            boolean to set\n\n\nsub absolute {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head2 RangeI-based methods\n\n\n=head2 start\n\n  Title   : start\n  Usage   : my $start = $position->start();\n            $position->start($start);\n  Function: Get/set the start co-ordinate of this position.\n  Returns : the start of this position\n  Args    : scalar numeric to set, OR\n            none to get the co-ordinate normally (see absolute() method), OR\n            Bio::Map::RelativeI to get the co-ordinate converted to be\n            relative to what this Relative describes.\n\n\n=head2 end\n\n  Title   : end\n  Usage   : my $end = $position->end();\n            $position->end($end);\n  Function: Get/set the end co-ordinate of this position.\n  Returns : the end of this position\n  Args    : scalar numeric to set, OR\n            none to get the co-ordinate normally (see absolute() method), OR\n            Bio::Map::RelativeI to get the co-ordinate converted to be\n            relative to what this Relative describes.\n\n\n=head2 length\n\n  Title   : length\n  Usage   : $length = $position->length();\n  Function: Get the length of this position.\n  Returns : the length of this position\n  Args    : none\n\n\n=head2 strand\n\n  Title   : strand\n  Usage   : $strand = $position->strand();\n  Function: Get the strand of this position; it is always 1 since maps to not\n            have strands.\n  Returns : 1\n  Args    : none\n\n\nsub strand {\n    return 1;\n}\n\n=head2 toString\n\n  Title   : toString\n  Usage   : print $position->toString(), \"\\n\";\n  Function: stringifies this range\n  Returns : a string representation of the range of this Position\n  Args    : optional Bio::Map::RelativeI to have the co-ordinates reported\n            relative to the thing described by that Relative\n\n\nsub toString {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head1 RangeI-related methods\n\nThese methods work by considering only the values of start() and end(), as\nmodified by considering every such co-ordinate relative to the start of the map\n(ie. absolute(1) is set temporarily during the calculation), or any supplied\nRelative. For the boolean methods, when the comparison Position is on the same\nmap as the calling Position, there is no point supplying a Relative since the\nanswer will be the same as without. Relative is most useful when comparing\nPositions on different maps and you have a Relative that describes some special\nplace on each map like 'the start of the gene', where the actual start of the\ngene relative to the start of the map is different for each map.\n\nThe methods do not consider maps during their calculations - things on different\nmaps can overlap/contain/intersect/etc. each other.\n\nThe geometrical methods (intersect, union etc.) do things to the geometry of\nranges, and return Bio::Map::PositionI compliant objects or triplets (start,\nstop, strand) from which new positions could be built. When a PositionI is made\nit will have a map transferred to it if all the arguments shared the same map.\nIf a Relative was supplied the result will have that same Relative.\n\nNote that the strand-testing args are there for compatability with the RangeI\ninterface. They have no meaning when only using PositionI objects since maps do\nnot have strands. Typically you will just set the argument to undef if you want\nto supply the argument after it.\n\n=head2 equals\n\n  Title   : equals\n  Usage   : if ($p1->equals($p2)) {...}\n  Function: Test whether $p1 has the same start, end, length as $p2.\n  Returns : true if they are describing the same position (regardless of map)\n  Args    : arg #1 = a Bio::RangeI (eg. a Bio::Map::Position) to compare this\n                     one to (mandatory)\n            arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n            arg #3 = optional Bio::Map::RelativeI to ask if the Positions\n                     equal in terms of their relative position to the thing\n                     described by that Relative","label":"equals($self,$other,$so,$rel)"},"line":392,"range":{"start":{"line":392,"character":0},"end":{"line":401,"character":9999}},"kind":12,"definition":"sub","detail":"($self,$other,$so,$rel)","children":[{"line":394,"name":"$self","kind":13,"localvar":"my","containerName":"equals","definition":"my"},{"line":394,"containerName":"equals","kind":13,"name":"$other"},{"kind":13,"containerName":"equals","name":"$so","line":394},{"line":394,"kind":13,"containerName":"equals","name":"$rel"},{"definition":"my","kind":13,"localvar":"my","containerName":"equals","name":"$own_start","line":396},{"kind":13,"containerName":"equals","name":"$own_end","line":396},{"line":396,"containerName":"equals","kind":13,"name":"$self"},{"name":"_pre_rangei","containerName":"equals","kind":12,"line":396},{"name":"$self","kind":13,"containerName":"equals","line":396},{"line":396,"name":"$rel","containerName":"equals","kind":13},{"definition":"my","line":397,"name":"$other_start","containerName":"equals","localvar":"my","kind":13},{"kind":13,"containerName":"equals","name":"$other_end","line":397},{"name":"$self","containerName":"equals","kind":13,"line":397},{"name":"_pre_rangei","containerName":"equals","kind":12,"line":397},{"containerName":"equals","kind":13,"name":"$other","line":397},{"line":397,"containerName":"equals","kind":13,"name":"$rel"},{"line":399,"name":"$self","kind":13,"containerName":"equals"},{"line":399,"name":"_testStrand","kind":12,"containerName":"equals"},{"line":399,"name":"$other","containerName":"equals","kind":13},{"name":"$so","kind":13,"containerName":"equals","line":399},{"line":400,"name":"$own_start","containerName":"equals","kind":13},{"name":"$other_start","containerName":"equals","kind":13,"line":400},{"containerName":"equals","kind":13,"name":"$own_end","line":400},{"line":400,"containerName":"equals","kind":13,"name":"$other_end"}],"name":"equals","containerName":"main::"},{"name":"less_than","containerName":"main::","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"less_than","line":419},{"name":"$other","kind":13,"containerName":"less_than","line":419},{"name":"$rel","containerName":"less_than","kind":13,"line":419},{"name":"$own_start","containerName":"less_than","localvar":"my","kind":13,"line":421,"definition":"my"},{"line":421,"containerName":"less_than","kind":13,"name":"$own_end"},{"containerName":"less_than","kind":13,"name":"$self","line":421},{"line":421,"name":"_pre_rangei","containerName":"less_than","kind":12},{"line":421,"name":"$self","kind":13,"containerName":"less_than"},{"line":421,"name":"$rel","containerName":"less_than","kind":13},{"definition":"my","name":"$other_start","localvar":"my","kind":13,"containerName":"less_than","line":422},{"line":422,"name":"$other_end","containerName":"less_than","kind":13},{"containerName":"less_than","kind":13,"name":"$self","line":422},{"line":422,"name":"_pre_rangei","kind":12,"containerName":"less_than"},{"kind":13,"containerName":"less_than","name":"$other","line":422},{"name":"$rel","kind":13,"containerName":"less_than","line":422},{"line":424,"kind":13,"containerName":"less_than","name":"$own_end"},{"line":424,"name":"$other_start","kind":13,"containerName":"less_than"}],"detail":"($self,$other,$rel)","definition":"sub","kind":12,"range":{"start":{"line":418,"character":0},"end":{"character":9999,"line":425}},"line":418,"signature":{"label":"less_than($self,$other,$rel)","parameters":[{"label":"$self"},{"label":"$other"},{"label":"$rel"}],"documentation":"1;\n# $Id: PositionI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::PositionI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::PositionI - Abstracts the notion of a position having a value in the context of a marker and a Map\n\n=head1 SYNOPSIS\n\n    # do not use this module directly\n    # See Bio::Map::Position for an example of\n    # implementation.\n\n=head1 DESCRIPTION\n\nThis object stores one of the postions that a mappable object\n(e.g. Marker) may have in a map.\n\nPositions can have non-numeric values or other methods to store the locations,\nso they have a method numeric() which does the conversion. numeric()\nreturns the position in a form that can be compared between other positions of\nthe same type. It is not necessarily a value suitable for sorting positions (it\nmay be the distance from the previous position); for that purpose the result of\nsortable() should be used.\n\nA 'position', in addition to being a single point, can also be an area and so\ncan be imagined as a range and compared with other positions on the basis of\noverlap, intersection etc.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nLincoln Stein, lstein-at-cshl.org\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::PositionI;\nuse strict;\nuse Bio::Map::PositionHandler;\nuse Bio::Map::Mappable;\nuse Scalar::Util qw(looks_like_number);\n\nuse base qw(Bio::Map::EntityI Bio::RangeI);\n\n=head2 EntityI methods\n\n These are fundamental to coordination of Positions and other entities, so are\n implemented at the interface level\n\n\n=head2 get_position_handler\n\n Title   : get_position_handler\n Usage   : my $position_handler = $entity->get_position_handler();\n Function: Gets a PositionHandlerI that $entity is registered with.\n Returns : Bio::Map::PositionHandlerI object\n Args    : none\n\n\nsub get_position_handler {\n    my $self = shift;\n    unless (defined $self->{_eh}) {\n        my $ph = Bio::Map::PositionHandler->new(-self => $self);\n        $self->{_eh} = $ph;\n        $ph->register;\n    }\n    return $self->{_eh};\n}\n\n=head2 PositionHandlerI-related methods\n\n These are fundamental to coordination of Positions and other entities, so are\n implemented at the interface level\n\n\n=head2 map\n\n Title   : map\n Usage   : my $map = $position->map();\n           $position->map($map);\n Function: Get/Set the map the position is in.\n Returns : L<Bio::Map::MapI>\n Args    : none to get\n           new L<Bio::Map::MapI> to set\n\n\nsub map {\n    my ($self, $map) = @_;\n    return $self->get_position_handler->map($map);\n}\n\n=head2 element\n\n Title   : element\n Usage   : my $element = $position->element();\n           $position->element($element);\n Function: Get/Set the element the position is for.\n Returns : L<Bio::Map::MappableI>\n Args    : none to get\n           new L<Bio::Map::MappableI> to set\n\n\nsub element {\n    my ($self, $element) = @_;\n    return $self->get_position_handler->element($element);\n}\n\n=head2 marker\n\n Title   : marker\n Function: This is a synonym of the element() method\n Status  : deprecated, will be removed in the next version\n\n\n*marker = \\&element;\n\n=head2 PositionI-specific methods\n\n\n=head2 value\n\n Title   : value\n Usage   : my $pos = $position->value();\n Function: Get/Set the value for this position\n Returns : scalar, value\n Args    : [optional] new value to set\n\n\nsub value {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head2 numeric\n\n Title   : numeric\n Usage   : my $num = $position->numeric;\n Function: Read-only method that is guaranteed to return a numeric \n           representation of the start of this position. \n Returns : scalar numeric\n Args    : none to get the co-ordinate normally (see absolute() method), OR\n           Bio::Map::RelativeI to get the co-ordinate converted to be\n           relative to what this Relative describes.\n\n\nsub numeric {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head2 sortable\n\n Title   : sortable\n Usage   : my $num = $position->sortable();\n Function: Read-only method that is guaranteed to return a value suitable\n           for correctly sorting this kind of position amongst other positions\n           of the same kind on the same map. Note that sorting different kinds\n           of position together is unlikely to give sane results.\n Returns : numeric\n Args    : none\n\n\nsub sortable {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head2 relative\n\n  Title   : relative\n  Usage   : my $relative = $position->relative();\n            $position->relative($relative);\n  Function: Get/set the thing this Position's coordinates (numerical(), start(),\n            end()) are relative to, as described by a Relative object.\n  Returns : Bio::Map::RelativeI (default is one describing \"relative to the\n            start of the Position's map\")\n  Args    : none to get, OR\n            Bio::Map::RelativeI to set\n\n\nsub relative {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head2 absolute\n\n  Title   : absolute\n  Usage   : my $absolute = $position->absolute();\n            $position->absolute($absolute);\n  Function: Get/set how this Position's co-ordinates (numerical(), start(),\n            end()) are reported. When absolute is off, co-ordinates are\n            relative to the thing described by relative(). Ie. the value\n            returned by start() will be the same as the value you set start()\n            to. When absolute is on, co-ordinates are converted to be relative\n            to the start of the map.\n\n            So if relative() currently points to a Relative object describing\n            \"relative to another position which is 100 bp from the start of\n            the map\", this Position's start() had been set to 50 and absolute()\n            returns 1, $position->start() will return 150. If absolute() returns\n            0 in the same situation, $position->start() would return 50.\n\n  Returns : boolean (default 0)\n  Args    : none to get, OR\n            boolean to set\n\n\nsub absolute {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head2 RangeI-based methods\n\n\n=head2 start\n\n  Title   : start\n  Usage   : my $start = $position->start();\n            $position->start($start);\n  Function: Get/set the start co-ordinate of this position.\n  Returns : the start of this position\n  Args    : scalar numeric to set, OR\n            none to get the co-ordinate normally (see absolute() method), OR\n            Bio::Map::RelativeI to get the co-ordinate converted to be\n            relative to what this Relative describes.\n\n\n=head2 end\n\n  Title   : end\n  Usage   : my $end = $position->end();\n            $position->end($end);\n  Function: Get/set the end co-ordinate of this position.\n  Returns : the end of this position\n  Args    : scalar numeric to set, OR\n            none to get the co-ordinate normally (see absolute() method), OR\n            Bio::Map::RelativeI to get the co-ordinate converted to be\n            relative to what this Relative describes.\n\n\n=head2 length\n\n  Title   : length\n  Usage   : $length = $position->length();\n  Function: Get the length of this position.\n  Returns : the length of this position\n  Args    : none\n\n\n=head2 strand\n\n  Title   : strand\n  Usage   : $strand = $position->strand();\n  Function: Get the strand of this position; it is always 1 since maps to not\n            have strands.\n  Returns : 1\n  Args    : none\n\n\nsub strand {\n    return 1;\n}\n\n=head2 toString\n\n  Title   : toString\n  Usage   : print $position->toString(), \"\\n\";\n  Function: stringifies this range\n  Returns : a string representation of the range of this Position\n  Args    : optional Bio::Map::RelativeI to have the co-ordinates reported\n            relative to the thing described by that Relative\n\n\nsub toString {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head1 RangeI-related methods\n\nThese methods work by considering only the values of start() and end(), as\nmodified by considering every such co-ordinate relative to the start of the map\n(ie. absolute(1) is set temporarily during the calculation), or any supplied\nRelative. For the boolean methods, when the comparison Position is on the same\nmap as the calling Position, there is no point supplying a Relative since the\nanswer will be the same as without. Relative is most useful when comparing\nPositions on different maps and you have a Relative that describes some special\nplace on each map like 'the start of the gene', where the actual start of the\ngene relative to the start of the map is different for each map.\n\nThe methods do not consider maps during their calculations - things on different\nmaps can overlap/contain/intersect/etc. each other.\n\nThe geometrical methods (intersect, union etc.) do things to the geometry of\nranges, and return Bio::Map::PositionI compliant objects or triplets (start,\nstop, strand) from which new positions could be built. When a PositionI is made\nit will have a map transferred to it if all the arguments shared the same map.\nIf a Relative was supplied the result will have that same Relative.\n\nNote that the strand-testing args are there for compatability with the RangeI\ninterface. They have no meaning when only using PositionI objects since maps do\nnot have strands. Typically you will just set the argument to undef if you want\nto supply the argument after it.\n\n=head2 equals\n\n  Title   : equals\n  Usage   : if ($p1->equals($p2)) {...}\n  Function: Test whether $p1 has the same start, end, length as $p2.\n  Returns : true if they are describing the same position (regardless of map)\n  Args    : arg #1 = a Bio::RangeI (eg. a Bio::Map::Position) to compare this\n                     one to (mandatory)\n            arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n            arg #3 = optional Bio::Map::RelativeI to ask if the Positions\n                     equal in terms of their relative position to the thing\n                     described by that Relative\n\n\nsub equals {\n    # overriding the RangeI implementation so we can handle Relative\n    my ($self, $other, $so, $rel) = @_;\n    \n    my ($own_start, $own_end) = $self->_pre_rangei($self, $rel);\n    my ($other_start, $other_end) = $self->_pre_rangei($other, $rel);\n    \n    return ($self->_testStrand($other, $so) and\n            $own_start == $other_start and $own_end == $other_end);\n}\n\n\n=head2 less_than\n\n Title   : less_than\n Usage   : if ($position->less_than($other_position)) {...}\n Function: Ask if this Position ends before another starts.\n Returns : boolean\n Args    : arg #1 = a Bio::RangeI (eg. a Bio::Map::Position) to compare this\n                    one to (mandatory)\n           arg #2 = optional Bio::Map::RelativeI to ask if the Position is less\n                    in terms of their relative position to the thing described\n                    by that Relative"}},{"detail":"($self,$other,$rel)","definition":"sub","name":"greater_than","containerName":"main::","children":[{"line":442,"localvar":"my","kind":13,"containerName":"greater_than","name":"$self","definition":"my"},{"kind":13,"containerName":"greater_than","name":"$other","line":442},{"line":442,"kind":13,"containerName":"greater_than","name":"$rel"},{"definition":"my","line":444,"localvar":"my","containerName":"greater_than","kind":13,"name":"$own_start"},{"line":444,"containerName":"greater_than","kind":13,"name":"$own_end"},{"line":444,"name":"$self","containerName":"greater_than","kind":13},{"line":444,"kind":12,"containerName":"greater_than","name":"_pre_rangei"},{"name":"$self","containerName":"greater_than","kind":13,"line":444},{"line":444,"name":"$rel","kind":13,"containerName":"greater_than"},{"name":"$other_start","localvar":"my","containerName":"greater_than","kind":13,"line":445,"definition":"my"},{"containerName":"greater_than","kind":13,"name":"$other_end","line":445},{"line":445,"name":"$self","kind":13,"containerName":"greater_than"},{"line":445,"name":"_pre_rangei","containerName":"greater_than","kind":12},{"containerName":"greater_than","kind":13,"name":"$other","line":445},{"kind":13,"containerName":"greater_than","name":"$rel","line":445},{"name":"$own_start","kind":13,"containerName":"greater_than","line":447},{"name":"$other_end","containerName":"greater_than","kind":13,"line":447}],"signature":{"documentation":"1;\n# $Id: PositionI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::PositionI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::PositionI - Abstracts the notion of a position having a value in the context of a marker and a Map\n\n=head1 SYNOPSIS\n\n    # do not use this module directly\n    # See Bio::Map::Position for an example of\n    # implementation.\n\n=head1 DESCRIPTION\n\nThis object stores one of the postions that a mappable object\n(e.g. Marker) may have in a map.\n\nPositions can have non-numeric values or other methods to store the locations,\nso they have a method numeric() which does the conversion. numeric()\nreturns the position in a form that can be compared between other positions of\nthe same type. It is not necessarily a value suitable for sorting positions (it\nmay be the distance from the previous position); for that purpose the result of\nsortable() should be used.\n\nA 'position', in addition to being a single point, can also be an area and so\ncan be imagined as a range and compared with other positions on the basis of\noverlap, intersection etc.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nLincoln Stein, lstein-at-cshl.org\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::PositionI;\nuse strict;\nuse Bio::Map::PositionHandler;\nuse Bio::Map::Mappable;\nuse Scalar::Util qw(looks_like_number);\n\nuse base qw(Bio::Map::EntityI Bio::RangeI);\n\n=head2 EntityI methods\n\n These are fundamental to coordination of Positions and other entities, so are\n implemented at the interface level\n\n\n=head2 get_position_handler\n\n Title   : get_position_handler\n Usage   : my $position_handler = $entity->get_position_handler();\n Function: Gets a PositionHandlerI that $entity is registered with.\n Returns : Bio::Map::PositionHandlerI object\n Args    : none\n\n\nsub get_position_handler {\n    my $self = shift;\n    unless (defined $self->{_eh}) {\n        my $ph = Bio::Map::PositionHandler->new(-self => $self);\n        $self->{_eh} = $ph;\n        $ph->register;\n    }\n    return $self->{_eh};\n}\n\n=head2 PositionHandlerI-related methods\n\n These are fundamental to coordination of Positions and other entities, so are\n implemented at the interface level\n\n\n=head2 map\n\n Title   : map\n Usage   : my $map = $position->map();\n           $position->map($map);\n Function: Get/Set the map the position is in.\n Returns : L<Bio::Map::MapI>\n Args    : none to get\n           new L<Bio::Map::MapI> to set\n\n\nsub map {\n    my ($self, $map) = @_;\n    return $self->get_position_handler->map($map);\n}\n\n=head2 element\n\n Title   : element\n Usage   : my $element = $position->element();\n           $position->element($element);\n Function: Get/Set the element the position is for.\n Returns : L<Bio::Map::MappableI>\n Args    : none to get\n           new L<Bio::Map::MappableI> to set\n\n\nsub element {\n    my ($self, $element) = @_;\n    return $self->get_position_handler->element($element);\n}\n\n=head2 marker\n\n Title   : marker\n Function: This is a synonym of the element() method\n Status  : deprecated, will be removed in the next version\n\n\n*marker = \\&element;\n\n=head2 PositionI-specific methods\n\n\n=head2 value\n\n Title   : value\n Usage   : my $pos = $position->value();\n Function: Get/Set the value for this position\n Returns : scalar, value\n Args    : [optional] new value to set\n\n\nsub value {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head2 numeric\n\n Title   : numeric\n Usage   : my $num = $position->numeric;\n Function: Read-only method that is guaranteed to return a numeric \n           representation of the start of this position. \n Returns : scalar numeric\n Args    : none to get the co-ordinate normally (see absolute() method), OR\n           Bio::Map::RelativeI to get the co-ordinate converted to be\n           relative to what this Relative describes.\n\n\nsub numeric {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head2 sortable\n\n Title   : sortable\n Usage   : my $num = $position->sortable();\n Function: Read-only method that is guaranteed to return a value suitable\n           for correctly sorting this kind of position amongst other positions\n           of the same kind on the same map. Note that sorting different kinds\n           of position together is unlikely to give sane results.\n Returns : numeric\n Args    : none\n\n\nsub sortable {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head2 relative\n\n  Title   : relative\n  Usage   : my $relative = $position->relative();\n            $position->relative($relative);\n  Function: Get/set the thing this Position's coordinates (numerical(), start(),\n            end()) are relative to, as described by a Relative object.\n  Returns : Bio::Map::RelativeI (default is one describing \"relative to the\n            start of the Position's map\")\n  Args    : none to get, OR\n            Bio::Map::RelativeI to set\n\n\nsub relative {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head2 absolute\n\n  Title   : absolute\n  Usage   : my $absolute = $position->absolute();\n            $position->absolute($absolute);\n  Function: Get/set how this Position's co-ordinates (numerical(), start(),\n            end()) are reported. When absolute is off, co-ordinates are\n            relative to the thing described by relative(). Ie. the value\n            returned by start() will be the same as the value you set start()\n            to. When absolute is on, co-ordinates are converted to be relative\n            to the start of the map.\n\n            So if relative() currently points to a Relative object describing\n            \"relative to another position which is 100 bp from the start of\n            the map\", this Position's start() had been set to 50 and absolute()\n            returns 1, $position->start() will return 150. If absolute() returns\n            0 in the same situation, $position->start() would return 50.\n\n  Returns : boolean (default 0)\n  Args    : none to get, OR\n            boolean to set\n\n\nsub absolute {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head2 RangeI-based methods\n\n\n=head2 start\n\n  Title   : start\n  Usage   : my $start = $position->start();\n            $position->start($start);\n  Function: Get/set the start co-ordinate of this position.\n  Returns : the start of this position\n  Args    : scalar numeric to set, OR\n            none to get the co-ordinate normally (see absolute() method), OR\n            Bio::Map::RelativeI to get the co-ordinate converted to be\n            relative to what this Relative describes.\n\n\n=head2 end\n\n  Title   : end\n  Usage   : my $end = $position->end();\n            $position->end($end);\n  Function: Get/set the end co-ordinate of this position.\n  Returns : the end of this position\n  Args    : scalar numeric to set, OR\n            none to get the co-ordinate normally (see absolute() method), OR\n            Bio::Map::RelativeI to get the co-ordinate converted to be\n            relative to what this Relative describes.\n\n\n=head2 length\n\n  Title   : length\n  Usage   : $length = $position->length();\n  Function: Get the length of this position.\n  Returns : the length of this position\n  Args    : none\n\n\n=head2 strand\n\n  Title   : strand\n  Usage   : $strand = $position->strand();\n  Function: Get the strand of this position; it is always 1 since maps to not\n            have strands.\n  Returns : 1\n  Args    : none\n\n\nsub strand {\n    return 1;\n}\n\n=head2 toString\n\n  Title   : toString\n  Usage   : print $position->toString(), \"\\n\";\n  Function: stringifies this range\n  Returns : a string representation of the range of this Position\n  Args    : optional Bio::Map::RelativeI to have the co-ordinates reported\n            relative to the thing described by that Relative\n\n\nsub toString {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head1 RangeI-related methods\n\nThese methods work by considering only the values of start() and end(), as\nmodified by considering every such co-ordinate relative to the start of the map\n(ie. absolute(1) is set temporarily during the calculation), or any supplied\nRelative. For the boolean methods, when the comparison Position is on the same\nmap as the calling Position, there is no point supplying a Relative since the\nanswer will be the same as without. Relative is most useful when comparing\nPositions on different maps and you have a Relative that describes some special\nplace on each map like 'the start of the gene', where the actual start of the\ngene relative to the start of the map is different for each map.\n\nThe methods do not consider maps during their calculations - things on different\nmaps can overlap/contain/intersect/etc. each other.\n\nThe geometrical methods (intersect, union etc.) do things to the geometry of\nranges, and return Bio::Map::PositionI compliant objects or triplets (start,\nstop, strand) from which new positions could be built. When a PositionI is made\nit will have a map transferred to it if all the arguments shared the same map.\nIf a Relative was supplied the result will have that same Relative.\n\nNote that the strand-testing args are there for compatability with the RangeI\ninterface. They have no meaning when only using PositionI objects since maps do\nnot have strands. Typically you will just set the argument to undef if you want\nto supply the argument after it.\n\n=head2 equals\n\n  Title   : equals\n  Usage   : if ($p1->equals($p2)) {...}\n  Function: Test whether $p1 has the same start, end, length as $p2.\n  Returns : true if they are describing the same position (regardless of map)\n  Args    : arg #1 = a Bio::RangeI (eg. a Bio::Map::Position) to compare this\n                     one to (mandatory)\n            arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n            arg #3 = optional Bio::Map::RelativeI to ask if the Positions\n                     equal in terms of their relative position to the thing\n                     described by that Relative\n\n\nsub equals {\n    # overriding the RangeI implementation so we can handle Relative\n    my ($self, $other, $so, $rel) = @_;\n    \n    my ($own_start, $own_end) = $self->_pre_rangei($self, $rel);\n    my ($other_start, $other_end) = $self->_pre_rangei($other, $rel);\n    \n    return ($self->_testStrand($other, $so) and\n            $own_start == $other_start and $own_end == $other_end);\n}\n\n\n=head2 less_than\n\n Title   : less_than\n Usage   : if ($position->less_than($other_position)) {...}\n Function: Ask if this Position ends before another starts.\n Returns : boolean\n Args    : arg #1 = a Bio::RangeI (eg. a Bio::Map::Position) to compare this\n                    one to (mandatory)\n           arg #2 = optional Bio::Map::RelativeI to ask if the Position is less\n                    in terms of their relative position to the thing described\n                    by that Relative\n\n\nsub less_than {\n    my ($self, $other, $rel) = @_;\n    \n    my ($own_start, $own_end) = $self->_pre_rangei($self, $rel);\n    my ($other_start, $other_end) = $self->_pre_rangei($other, $rel);\n    \n    return $own_end < $other_start;\n}\n\n=head2 greater_than\n\n Title   : greater_than\n Usage   : if ($position->greater_than($other_position)) {...}\n Function: Ask if this Position starts after another ends.\n Returns : boolean\n Args    : arg #1 = a Bio::RangeI (eg. a Bio::Map::Position) to compare this\n                    one to (mandatory)\n           arg #2 = optional Bio::Map::RelativeI to ask if the Position is\n                    greater in terms of their relative position to the thing\n                    described by that Relative","parameters":[{"label":"$self"},{"label":"$other"},{"label":"$rel"}],"label":"greater_than($self,$other,$rel)"},"range":{"end":{"line":448,"character":9999},"start":{"character":0,"line":441}},"kind":12,"line":441},{"range":{"end":{"character":9999,"line":484},"start":{"line":467,"character":0}},"kind":12,"line":467,"signature":{"documentation":"1;\n# $Id: PositionI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::PositionI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::PositionI - Abstracts the notion of a position having a value in the context of a marker and a Map\n\n=head1 SYNOPSIS\n\n    # do not use this module directly\n    # See Bio::Map::Position for an example of\n    # implementation.\n\n=head1 DESCRIPTION\n\nThis object stores one of the postions that a mappable object\n(e.g. Marker) may have in a map.\n\nPositions can have non-numeric values or other methods to store the locations,\nso they have a method numeric() which does the conversion. numeric()\nreturns the position in a form that can be compared between other positions of\nthe same type. It is not necessarily a value suitable for sorting positions (it\nmay be the distance from the previous position); for that purpose the result of\nsortable() should be used.\n\nA 'position', in addition to being a single point, can also be an area and so\ncan be imagined as a range and compared with other positions on the basis of\noverlap, intersection etc.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nLincoln Stein, lstein-at-cshl.org\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::PositionI;\nuse strict;\nuse Bio::Map::PositionHandler;\nuse Bio::Map::Mappable;\nuse Scalar::Util qw(looks_like_number);\n\nuse base qw(Bio::Map::EntityI Bio::RangeI);\n\n=head2 EntityI methods\n\n These are fundamental to coordination of Positions and other entities, so are\n implemented at the interface level\n\n\n=head2 get_position_handler\n\n Title   : get_position_handler\n Usage   : my $position_handler = $entity->get_position_handler();\n Function: Gets a PositionHandlerI that $entity is registered with.\n Returns : Bio::Map::PositionHandlerI object\n Args    : none\n\n\nsub get_position_handler {\n    my $self = shift;\n    unless (defined $self->{_eh}) {\n        my $ph = Bio::Map::PositionHandler->new(-self => $self);\n        $self->{_eh} = $ph;\n        $ph->register;\n    }\n    return $self->{_eh};\n}\n\n=head2 PositionHandlerI-related methods\n\n These are fundamental to coordination of Positions and other entities, so are\n implemented at the interface level\n\n\n=head2 map\n\n Title   : map\n Usage   : my $map = $position->map();\n           $position->map($map);\n Function: Get/Set the map the position is in.\n Returns : L<Bio::Map::MapI>\n Args    : none to get\n           new L<Bio::Map::MapI> to set\n\n\nsub map {\n    my ($self, $map) = @_;\n    return $self->get_position_handler->map($map);\n}\n\n=head2 element\n\n Title   : element\n Usage   : my $element = $position->element();\n           $position->element($element);\n Function: Get/Set the element the position is for.\n Returns : L<Bio::Map::MappableI>\n Args    : none to get\n           new L<Bio::Map::MappableI> to set\n\n\nsub element {\n    my ($self, $element) = @_;\n    return $self->get_position_handler->element($element);\n}\n\n=head2 marker\n\n Title   : marker\n Function: This is a synonym of the element() method\n Status  : deprecated, will be removed in the next version\n\n\n*marker = \\&element;\n\n=head2 PositionI-specific methods\n\n\n=head2 value\n\n Title   : value\n Usage   : my $pos = $position->value();\n Function: Get/Set the value for this position\n Returns : scalar, value\n Args    : [optional] new value to set\n\n\nsub value {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head2 numeric\n\n Title   : numeric\n Usage   : my $num = $position->numeric;\n Function: Read-only method that is guaranteed to return a numeric \n           representation of the start of this position. \n Returns : scalar numeric\n Args    : none to get the co-ordinate normally (see absolute() method), OR\n           Bio::Map::RelativeI to get the co-ordinate converted to be\n           relative to what this Relative describes.\n\n\nsub numeric {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head2 sortable\n\n Title   : sortable\n Usage   : my $num = $position->sortable();\n Function: Read-only method that is guaranteed to return a value suitable\n           for correctly sorting this kind of position amongst other positions\n           of the same kind on the same map. Note that sorting different kinds\n           of position together is unlikely to give sane results.\n Returns : numeric\n Args    : none\n\n\nsub sortable {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head2 relative\n\n  Title   : relative\n  Usage   : my $relative = $position->relative();\n            $position->relative($relative);\n  Function: Get/set the thing this Position's coordinates (numerical(), start(),\n            end()) are relative to, as described by a Relative object.\n  Returns : Bio::Map::RelativeI (default is one describing \"relative to the\n            start of the Position's map\")\n  Args    : none to get, OR\n            Bio::Map::RelativeI to set\n\n\nsub relative {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head2 absolute\n\n  Title   : absolute\n  Usage   : my $absolute = $position->absolute();\n            $position->absolute($absolute);\n  Function: Get/set how this Position's co-ordinates (numerical(), start(),\n            end()) are reported. When absolute is off, co-ordinates are\n            relative to the thing described by relative(). Ie. the value\n            returned by start() will be the same as the value you set start()\n            to. When absolute is on, co-ordinates are converted to be relative\n            to the start of the map.\n\n            So if relative() currently points to a Relative object describing\n            \"relative to another position which is 100 bp from the start of\n            the map\", this Position's start() had been set to 50 and absolute()\n            returns 1, $position->start() will return 150. If absolute() returns\n            0 in the same situation, $position->start() would return 50.\n\n  Returns : boolean (default 0)\n  Args    : none to get, OR\n            boolean to set\n\n\nsub absolute {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head2 RangeI-based methods\n\n\n=head2 start\n\n  Title   : start\n  Usage   : my $start = $position->start();\n            $position->start($start);\n  Function: Get/set the start co-ordinate of this position.\n  Returns : the start of this position\n  Args    : scalar numeric to set, OR\n            none to get the co-ordinate normally (see absolute() method), OR\n            Bio::Map::RelativeI to get the co-ordinate converted to be\n            relative to what this Relative describes.\n\n\n=head2 end\n\n  Title   : end\n  Usage   : my $end = $position->end();\n            $position->end($end);\n  Function: Get/set the end co-ordinate of this position.\n  Returns : the end of this position\n  Args    : scalar numeric to set, OR\n            none to get the co-ordinate normally (see absolute() method), OR\n            Bio::Map::RelativeI to get the co-ordinate converted to be\n            relative to what this Relative describes.\n\n\n=head2 length\n\n  Title   : length\n  Usage   : $length = $position->length();\n  Function: Get the length of this position.\n  Returns : the length of this position\n  Args    : none\n\n\n=head2 strand\n\n  Title   : strand\n  Usage   : $strand = $position->strand();\n  Function: Get the strand of this position; it is always 1 since maps to not\n            have strands.\n  Returns : 1\n  Args    : none\n\n\nsub strand {\n    return 1;\n}\n\n=head2 toString\n\n  Title   : toString\n  Usage   : print $position->toString(), \"\\n\";\n  Function: stringifies this range\n  Returns : a string representation of the range of this Position\n  Args    : optional Bio::Map::RelativeI to have the co-ordinates reported\n            relative to the thing described by that Relative\n\n\nsub toString {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head1 RangeI-related methods\n\nThese methods work by considering only the values of start() and end(), as\nmodified by considering every such co-ordinate relative to the start of the map\n(ie. absolute(1) is set temporarily during the calculation), or any supplied\nRelative. For the boolean methods, when the comparison Position is on the same\nmap as the calling Position, there is no point supplying a Relative since the\nanswer will be the same as without. Relative is most useful when comparing\nPositions on different maps and you have a Relative that describes some special\nplace on each map like 'the start of the gene', where the actual start of the\ngene relative to the start of the map is different for each map.\n\nThe methods do not consider maps during their calculations - things on different\nmaps can overlap/contain/intersect/etc. each other.\n\nThe geometrical methods (intersect, union etc.) do things to the geometry of\nranges, and return Bio::Map::PositionI compliant objects or triplets (start,\nstop, strand) from which new positions could be built. When a PositionI is made\nit will have a map transferred to it if all the arguments shared the same map.\nIf a Relative was supplied the result will have that same Relative.\n\nNote that the strand-testing args are there for compatability with the RangeI\ninterface. They have no meaning when only using PositionI objects since maps do\nnot have strands. Typically you will just set the argument to undef if you want\nto supply the argument after it.\n\n=head2 equals\n\n  Title   : equals\n  Usage   : if ($p1->equals($p2)) {...}\n  Function: Test whether $p1 has the same start, end, length as $p2.\n  Returns : true if they are describing the same position (regardless of map)\n  Args    : arg #1 = a Bio::RangeI (eg. a Bio::Map::Position) to compare this\n                     one to (mandatory)\n            arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n            arg #3 = optional Bio::Map::RelativeI to ask if the Positions\n                     equal in terms of their relative position to the thing\n                     described by that Relative\n\n\nsub equals {\n    # overriding the RangeI implementation so we can handle Relative\n    my ($self, $other, $so, $rel) = @_;\n    \n    my ($own_start, $own_end) = $self->_pre_rangei($self, $rel);\n    my ($other_start, $other_end) = $self->_pre_rangei($other, $rel);\n    \n    return ($self->_testStrand($other, $so) and\n            $own_start == $other_start and $own_end == $other_end);\n}\n\n\n=head2 less_than\n\n Title   : less_than\n Usage   : if ($position->less_than($other_position)) {...}\n Function: Ask if this Position ends before another starts.\n Returns : boolean\n Args    : arg #1 = a Bio::RangeI (eg. a Bio::Map::Position) to compare this\n                    one to (mandatory)\n           arg #2 = optional Bio::Map::RelativeI to ask if the Position is less\n                    in terms of their relative position to the thing described\n                    by that Relative\n\n\nsub less_than {\n    my ($self, $other, $rel) = @_;\n    \n    my ($own_start, $own_end) = $self->_pre_rangei($self, $rel);\n    my ($other_start, $other_end) = $self->_pre_rangei($other, $rel);\n    \n    return $own_end < $other_start;\n}\n\n=head2 greater_than\n\n Title   : greater_than\n Usage   : if ($position->greater_than($other_position)) {...}\n Function: Ask if this Position starts after another ends.\n Returns : boolean\n Args    : arg #1 = a Bio::RangeI (eg. a Bio::Map::Position) to compare this\n                    one to (mandatory)\n           arg #2 = optional Bio::Map::RelativeI to ask if the Position is\n                    greater in terms of their relative position to the thing\n                    described by that Relative\n\n\nsub greater_than {\n    my ($self, $other, $rel) = @_;\n    \n    my ($own_start, $own_end) = $self->_pre_rangei($self, $rel);\n    my ($other_start, $other_end) = $self->_pre_rangei($other, $rel);\n    \n    return $own_start > $other_end;\n}\n\n=head2 overlaps\n\n  Title   : overlaps\n  Usage   : if ($p1->overlaps($p2)) {...}\n  Function: Tests if $p1 overlaps $p2.\n  Returns : True if the positions overlap (regardless of map), false otherwise\n  Args    : arg #1 = a Bio::RangeI (eg. a Bio::Map::Position) to compare this\n                     one to (mandatory)\n            arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n            arg #3 = optional Bio::Map::RelativeI to ask if the Positions\n                     overlap in terms of their relative position to the thing\n                     described by that Relative\n            arg #4 = optional minimum percentage length of the overlap before\n                     reporting an overlap exists (default 0)","parameters":[{"label":"$self"},{"label":"$other"},{"label":"$so"},{"label":"$rel"},{"label":"$min_percent"}],"label":"overlaps($self,$other,$so,$rel,$min_percent)"},"name":"overlaps","containerName":"main::","children":[{"definition":"my","line":469,"containerName":"overlaps","localvar":"my","kind":13,"name":"$self"},{"line":469,"containerName":"overlaps","kind":13,"name":"$other"},{"containerName":"overlaps","kind":13,"name":"$so","line":469},{"line":469,"name":"$rel","containerName":"overlaps","kind":13},{"name":"$min_percent","containerName":"overlaps","kind":13,"line":469},{"name":"$min_percent","kind":13,"containerName":"overlaps","line":470},{"line":472,"containerName":"overlaps","localvar":"my","kind":13,"name":"$own_min","definition":"my"},{"kind":13,"containerName":"overlaps","name":"$other_min","line":472},{"name":"$min_percent","kind":13,"containerName":"overlaps","line":473},{"line":474,"name":"$own_min","containerName":"overlaps","kind":13},{"containerName":"overlaps","kind":13,"name":"$self","line":474},{"name":"length","containerName":"overlaps","kind":12,"line":474},{"name":"$min_percent","containerName":"overlaps","kind":13,"line":474},{"name":"$other_min","kind":13,"containerName":"overlaps","line":475},{"line":475,"name":"$other","kind":13,"containerName":"overlaps"},{"containerName":"overlaps","kind":12,"name":"length","line":475},{"kind":13,"containerName":"overlaps","name":"$min_percent","line":475},{"definition":"my","line":478,"kind":13,"localvar":"my","containerName":"overlaps","name":"$own_start"},{"kind":13,"containerName":"overlaps","name":"$own_end","line":478},{"line":478,"kind":13,"containerName":"overlaps","name":"$self"},{"name":"_pre_rangei","kind":12,"containerName":"overlaps","line":478},{"line":478,"kind":13,"containerName":"overlaps","name":"$self"},{"name":"$rel","containerName":"overlaps","kind":13,"line":478},{"line":479,"name":"$other_start","kind":13,"localvar":"my","containerName":"overlaps","definition":"my"},{"kind":13,"containerName":"overlaps","name":"$other_end","line":479},{"name":"$self","kind":13,"containerName":"overlaps","line":479},{"line":479,"kind":12,"containerName":"overlaps","name":"_pre_rangei"},{"line":479,"containerName":"overlaps","kind":13,"name":"$other"},{"line":479,"name":"$rel","kind":13,"containerName":"overlaps"},{"name":"$self","containerName":"overlaps","kind":13,"line":481},{"containerName":"overlaps","kind":12,"name":"_testStrand","line":481},{"line":481,"name":"$other","kind":13,"containerName":"overlaps"},{"line":481,"name":"$so","containerName":"overlaps","kind":13},{"line":482,"containerName":"overlaps","kind":13,"name":"$own_start"},{"containerName":"overlaps","kind":13,"name":"$own_min","line":482},{"name":"$other_end","containerName":"overlaps","kind":13,"line":482},{"name":"$own_end","containerName":"overlaps","kind":13,"line":482},{"line":482,"containerName":"overlaps","kind":13,"name":"$own_min"},{"containerName":"overlaps","kind":13,"name":"$other_start","line":482},{"name":"$own_start","kind":13,"containerName":"overlaps","line":483},{"line":483,"kind":13,"containerName":"overlaps","name":"$other_end"},{"kind":13,"containerName":"overlaps","name":"$other_min","line":483},{"line":483,"name":"$own_end","kind":13,"containerName":"overlaps"},{"line":483,"name":"$other_start","kind":13,"containerName":"overlaps"},{"name":"$other_min","containerName":"overlaps","kind":13,"line":483}],"detail":"($self,$other,$so,$rel,$min_percent)","definition":"sub"},{"signature":{"documentation":"1;\n# $Id: PositionI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::PositionI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::PositionI - Abstracts the notion of a position having a value in the context of a marker and a Map\n\n=head1 SYNOPSIS\n\n    # do not use this module directly\n    # See Bio::Map::Position for an example of\n    # implementation.\n\n=head1 DESCRIPTION\n\nThis object stores one of the postions that a mappable object\n(e.g. Marker) may have in a map.\n\nPositions can have non-numeric values or other methods to store the locations,\nso they have a method numeric() which does the conversion. numeric()\nreturns the position in a form that can be compared between other positions of\nthe same type. It is not necessarily a value suitable for sorting positions (it\nmay be the distance from the previous position); for that purpose the result of\nsortable() should be used.\n\nA 'position', in addition to being a single point, can also be an area and so\ncan be imagined as a range and compared with other positions on the basis of\noverlap, intersection etc.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nLincoln Stein, lstein-at-cshl.org\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::PositionI;\nuse strict;\nuse Bio::Map::PositionHandler;\nuse Bio::Map::Mappable;\nuse Scalar::Util qw(looks_like_number);\n\nuse base qw(Bio::Map::EntityI Bio::RangeI);\n\n=head2 EntityI methods\n\n These are fundamental to coordination of Positions and other entities, so are\n implemented at the interface level\n\n\n=head2 get_position_handler\n\n Title   : get_position_handler\n Usage   : my $position_handler = $entity->get_position_handler();\n Function: Gets a PositionHandlerI that $entity is registered with.\n Returns : Bio::Map::PositionHandlerI object\n Args    : none\n\n\nsub get_position_handler {\n    my $self = shift;\n    unless (defined $self->{_eh}) {\n        my $ph = Bio::Map::PositionHandler->new(-self => $self);\n        $self->{_eh} = $ph;\n        $ph->register;\n    }\n    return $self->{_eh};\n}\n\n=head2 PositionHandlerI-related methods\n\n These are fundamental to coordination of Positions and other entities, so are\n implemented at the interface level\n\n\n=head2 map\n\n Title   : map\n Usage   : my $map = $position->map();\n           $position->map($map);\n Function: Get/Set the map the position is in.\n Returns : L<Bio::Map::MapI>\n Args    : none to get\n           new L<Bio::Map::MapI> to set\n\n\nsub map {\n    my ($self, $map) = @_;\n    return $self->get_position_handler->map($map);\n}\n\n=head2 element\n\n Title   : element\n Usage   : my $element = $position->element();\n           $position->element($element);\n Function: Get/Set the element the position is for.\n Returns : L<Bio::Map::MappableI>\n Args    : none to get\n           new L<Bio::Map::MappableI> to set\n\n\nsub element {\n    my ($self, $element) = @_;\n    return $self->get_position_handler->element($element);\n}\n\n=head2 marker\n\n Title   : marker\n Function: This is a synonym of the element() method\n Status  : deprecated, will be removed in the next version\n\n\n*marker = \\&element;\n\n=head2 PositionI-specific methods\n\n\n=head2 value\n\n Title   : value\n Usage   : my $pos = $position->value();\n Function: Get/Set the value for this position\n Returns : scalar, value\n Args    : [optional] new value to set\n\n\nsub value {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head2 numeric\n\n Title   : numeric\n Usage   : my $num = $position->numeric;\n Function: Read-only method that is guaranteed to return a numeric \n           representation of the start of this position. \n Returns : scalar numeric\n Args    : none to get the co-ordinate normally (see absolute() method), OR\n           Bio::Map::RelativeI to get the co-ordinate converted to be\n           relative to what this Relative describes.\n\n\nsub numeric {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head2 sortable\n\n Title   : sortable\n Usage   : my $num = $position->sortable();\n Function: Read-only method that is guaranteed to return a value suitable\n           for correctly sorting this kind of position amongst other positions\n           of the same kind on the same map. Note that sorting different kinds\n           of position together is unlikely to give sane results.\n Returns : numeric\n Args    : none\n\n\nsub sortable {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head2 relative\n\n  Title   : relative\n  Usage   : my $relative = $position->relative();\n            $position->relative($relative);\n  Function: Get/set the thing this Position's coordinates (numerical(), start(),\n            end()) are relative to, as described by a Relative object.\n  Returns : Bio::Map::RelativeI (default is one describing \"relative to the\n            start of the Position's map\")\n  Args    : none to get, OR\n            Bio::Map::RelativeI to set\n\n\nsub relative {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head2 absolute\n\n  Title   : absolute\n  Usage   : my $absolute = $position->absolute();\n            $position->absolute($absolute);\n  Function: Get/set how this Position's co-ordinates (numerical(), start(),\n            end()) are reported. When absolute is off, co-ordinates are\n            relative to the thing described by relative(). Ie. the value\n            returned by start() will be the same as the value you set start()\n            to. When absolute is on, co-ordinates are converted to be relative\n            to the start of the map.\n\n            So if relative() currently points to a Relative object describing\n            \"relative to another position which is 100 bp from the start of\n            the map\", this Position's start() had been set to 50 and absolute()\n            returns 1, $position->start() will return 150. If absolute() returns\n            0 in the same situation, $position->start() would return 50.\n\n  Returns : boolean (default 0)\n  Args    : none to get, OR\n            boolean to set\n\n\nsub absolute {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head2 RangeI-based methods\n\n\n=head2 start\n\n  Title   : start\n  Usage   : my $start = $position->start();\n            $position->start($start);\n  Function: Get/set the start co-ordinate of this position.\n  Returns : the start of this position\n  Args    : scalar numeric to set, OR\n            none to get the co-ordinate normally (see absolute() method), OR\n            Bio::Map::RelativeI to get the co-ordinate converted to be\n            relative to what this Relative describes.\n\n\n=head2 end\n\n  Title   : end\n  Usage   : my $end = $position->end();\n            $position->end($end);\n  Function: Get/set the end co-ordinate of this position.\n  Returns : the end of this position\n  Args    : scalar numeric to set, OR\n            none to get the co-ordinate normally (see absolute() method), OR\n            Bio::Map::RelativeI to get the co-ordinate converted to be\n            relative to what this Relative describes.\n\n\n=head2 length\n\n  Title   : length\n  Usage   : $length = $position->length();\n  Function: Get the length of this position.\n  Returns : the length of this position\n  Args    : none\n\n\n=head2 strand\n\n  Title   : strand\n  Usage   : $strand = $position->strand();\n  Function: Get the strand of this position; it is always 1 since maps to not\n            have strands.\n  Returns : 1\n  Args    : none\n\n\nsub strand {\n    return 1;\n}\n\n=head2 toString\n\n  Title   : toString\n  Usage   : print $position->toString(), \"\\n\";\n  Function: stringifies this range\n  Returns : a string representation of the range of this Position\n  Args    : optional Bio::Map::RelativeI to have the co-ordinates reported\n            relative to the thing described by that Relative\n\n\nsub toString {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head1 RangeI-related methods\n\nThese methods work by considering only the values of start() and end(), as\nmodified by considering every such co-ordinate relative to the start of the map\n(ie. absolute(1) is set temporarily during the calculation), or any supplied\nRelative. For the boolean methods, when the comparison Position is on the same\nmap as the calling Position, there is no point supplying a Relative since the\nanswer will be the same as without. Relative is most useful when comparing\nPositions on different maps and you have a Relative that describes some special\nplace on each map like 'the start of the gene', where the actual start of the\ngene relative to the start of the map is different for each map.\n\nThe methods do not consider maps during their calculations - things on different\nmaps can overlap/contain/intersect/etc. each other.\n\nThe geometrical methods (intersect, union etc.) do things to the geometry of\nranges, and return Bio::Map::PositionI compliant objects or triplets (start,\nstop, strand) from which new positions could be built. When a PositionI is made\nit will have a map transferred to it if all the arguments shared the same map.\nIf a Relative was supplied the result will have that same Relative.\n\nNote that the strand-testing args are there for compatability with the RangeI\ninterface. They have no meaning when only using PositionI objects since maps do\nnot have strands. Typically you will just set the argument to undef if you want\nto supply the argument after it.\n\n=head2 equals\n\n  Title   : equals\n  Usage   : if ($p1->equals($p2)) {...}\n  Function: Test whether $p1 has the same start, end, length as $p2.\n  Returns : true if they are describing the same position (regardless of map)\n  Args    : arg #1 = a Bio::RangeI (eg. a Bio::Map::Position) to compare this\n                     one to (mandatory)\n            arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n            arg #3 = optional Bio::Map::RelativeI to ask if the Positions\n                     equal in terms of their relative position to the thing\n                     described by that Relative\n\n\nsub equals {\n    # overriding the RangeI implementation so we can handle Relative\n    my ($self, $other, $so, $rel) = @_;\n    \n    my ($own_start, $own_end) = $self->_pre_rangei($self, $rel);\n    my ($other_start, $other_end) = $self->_pre_rangei($other, $rel);\n    \n    return ($self->_testStrand($other, $so) and\n            $own_start == $other_start and $own_end == $other_end);\n}\n\n\n=head2 less_than\n\n Title   : less_than\n Usage   : if ($position->less_than($other_position)) {...}\n Function: Ask if this Position ends before another starts.\n Returns : boolean\n Args    : arg #1 = a Bio::RangeI (eg. a Bio::Map::Position) to compare this\n                    one to (mandatory)\n           arg #2 = optional Bio::Map::RelativeI to ask if the Position is less\n                    in terms of their relative position to the thing described\n                    by that Relative\n\n\nsub less_than {\n    my ($self, $other, $rel) = @_;\n    \n    my ($own_start, $own_end) = $self->_pre_rangei($self, $rel);\n    my ($other_start, $other_end) = $self->_pre_rangei($other, $rel);\n    \n    return $own_end < $other_start;\n}\n\n=head2 greater_than\n\n Title   : greater_than\n Usage   : if ($position->greater_than($other_position)) {...}\n Function: Ask if this Position starts after another ends.\n Returns : boolean\n Args    : arg #1 = a Bio::RangeI (eg. a Bio::Map::Position) to compare this\n                    one to (mandatory)\n           arg #2 = optional Bio::Map::RelativeI to ask if the Position is\n                    greater in terms of their relative position to the thing\n                    described by that Relative\n\n\nsub greater_than {\n    my ($self, $other, $rel) = @_;\n    \n    my ($own_start, $own_end) = $self->_pre_rangei($self, $rel);\n    my ($other_start, $other_end) = $self->_pre_rangei($other, $rel);\n    \n    return $own_start > $other_end;\n}\n\n=head2 overlaps\n\n  Title   : overlaps\n  Usage   : if ($p1->overlaps($p2)) {...}\n  Function: Tests if $p1 overlaps $p2.\n  Returns : True if the positions overlap (regardless of map), false otherwise\n  Args    : arg #1 = a Bio::RangeI (eg. a Bio::Map::Position) to compare this\n                     one to (mandatory)\n            arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n            arg #3 = optional Bio::Map::RelativeI to ask if the Positions\n                     overlap in terms of their relative position to the thing\n                     described by that Relative\n            arg #4 = optional minimum percentage length of the overlap before\n                     reporting an overlap exists (default 0)\n\n\nsub overlaps {\n    # overriding the RangeI implementation so we can handle Relative\n    my ($self, $other, $so, $rel, $min_percent) = @_;\n    $min_percent ||= 0;\n    \n    my ($own_min, $other_min) = (0, 0);\n    if ($min_percent > 0) {\n        $own_min = (($self->length / 100) * $min_percent) - 1;\n        $other_min = (($other->length / 100) * $min_percent) - 1;\n    }\n    \n    my ($own_start, $own_end) = $self->_pre_rangei($self, $rel);\n    my ($other_start, $other_end) = $self->_pre_rangei($other, $rel);\n    \n    return ($self->_testStrand($other, $so) and not\n            (($own_start + $own_min > $other_end or $own_end - $own_min < $other_start) ||\n             ($own_start > $other_end - $other_min or $own_end < $other_start + $other_min)));\n}\n\n=head2 contains\n\n  Title   : contains\n  Usage   : if ($p1->contains($p2)) {...}\n  Function: Tests whether $p1 totally contains $p2.\n  Returns : true if the argument is totally contained within this position\n            (regardless of map), false otherwise\n  Args    : arg #1 = a Bio::RangeI (eg. a Bio::Map::Position) to compare this\n                     one to, or scalar number (mandatory)\n            arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n            arg #3 = optional Bio::Map::RelativeI to ask if the Position\n                     is contained in terms of their relative position to the\n                     thing described by that Relative","parameters":[{"label":"$self"},{"label":"$other"},{"label":"$so"},{"label":"$rel"}],"label":"contains($self,$other,$so,$rel)"},"line":502,"kind":12,"range":{"start":{"character":0,"line":502},"end":{"line":511,"character":9999}},"definition":"sub","detail":"($self,$other,$so,$rel)","children":[{"definition":"my","line":504,"name":"$self","kind":13,"localvar":"my","containerName":"contains"},{"containerName":"contains","kind":13,"name":"$other","line":504},{"line":504,"kind":13,"containerName":"contains","name":"$so"},{"line":504,"name":"$rel","kind":13,"containerName":"contains"},{"definition":"my","line":506,"localvar":"my","containerName":"contains","kind":13,"name":"$own_start"},{"line":506,"kind":13,"containerName":"contains","name":"$own_end"},{"line":506,"name":"$self","containerName":"contains","kind":13},{"line":506,"containerName":"contains","kind":12,"name":"_pre_rangei"},{"containerName":"contains","kind":13,"name":"$self","line":506},{"name":"$rel","containerName":"contains","kind":13,"line":506},{"definition":"my","kind":13,"localvar":"my","containerName":"contains","name":"$other_start","line":507},{"line":507,"name":"$other_end","kind":13,"containerName":"contains"},{"line":507,"kind":13,"containerName":"contains","name":"$self"},{"line":507,"containerName":"contains","kind":12,"name":"_pre_rangei"},{"kind":13,"containerName":"contains","name":"$other","line":507},{"line":507,"name":"$rel","kind":13,"containerName":"contains"},{"line":509,"name":"$self","kind":13,"containerName":"contains"},{"name":"_testStrand","containerName":"contains","kind":12,"line":509},{"containerName":"contains","kind":13,"name":"$other","line":509},{"containerName":"contains","kind":13,"name":"$so","line":509},{"line":510,"containerName":"contains","kind":13,"name":"$other_start"},{"line":510,"name":"$own_start","kind":13,"containerName":"contains"},{"line":510,"kind":13,"containerName":"contains","name":"$other_end"},{"name":"$own_end","kind":13,"containerName":"contains","line":510}],"name":"contains","containerName":"main::"},{"line":535,"kind":12,"range":{"start":{"line":535,"character":0},"end":{"character":9999,"line":549}},"signature":{"parameters":[{"label":"$self"},{"label":"$given"},{"label":"$so"},{"label":"$rel"}],"documentation":"1;\n# $Id: PositionI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::PositionI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::PositionI - Abstracts the notion of a position having a value in the context of a marker and a Map\n\n=head1 SYNOPSIS\n\n    # do not use this module directly\n    # See Bio::Map::Position for an example of\n    # implementation.\n\n=head1 DESCRIPTION\n\nThis object stores one of the postions that a mappable object\n(e.g. Marker) may have in a map.\n\nPositions can have non-numeric values or other methods to store the locations,\nso they have a method numeric() which does the conversion. numeric()\nreturns the position in a form that can be compared between other positions of\nthe same type. It is not necessarily a value suitable for sorting positions (it\nmay be the distance from the previous position); for that purpose the result of\nsortable() should be used.\n\nA 'position', in addition to being a single point, can also be an area and so\ncan be imagined as a range and compared with other positions on the basis of\noverlap, intersection etc.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nLincoln Stein, lstein-at-cshl.org\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::PositionI;\nuse strict;\nuse Bio::Map::PositionHandler;\nuse Bio::Map::Mappable;\nuse Scalar::Util qw(looks_like_number);\n\nuse base qw(Bio::Map::EntityI Bio::RangeI);\n\n=head2 EntityI methods\n\n These are fundamental to coordination of Positions and other entities, so are\n implemented at the interface level\n\n\n=head2 get_position_handler\n\n Title   : get_position_handler\n Usage   : my $position_handler = $entity->get_position_handler();\n Function: Gets a PositionHandlerI that $entity is registered with.\n Returns : Bio::Map::PositionHandlerI object\n Args    : none\n\n\nsub get_position_handler {\n    my $self = shift;\n    unless (defined $self->{_eh}) {\n        my $ph = Bio::Map::PositionHandler->new(-self => $self);\n        $self->{_eh} = $ph;\n        $ph->register;\n    }\n    return $self->{_eh};\n}\n\n=head2 PositionHandlerI-related methods\n\n These are fundamental to coordination of Positions and other entities, so are\n implemented at the interface level\n\n\n=head2 map\n\n Title   : map\n Usage   : my $map = $position->map();\n           $position->map($map);\n Function: Get/Set the map the position is in.\n Returns : L<Bio::Map::MapI>\n Args    : none to get\n           new L<Bio::Map::MapI> to set\n\n\nsub map {\n    my ($self, $map) = @_;\n    return $self->get_position_handler->map($map);\n}\n\n=head2 element\n\n Title   : element\n Usage   : my $element = $position->element();\n           $position->element($element);\n Function: Get/Set the element the position is for.\n Returns : L<Bio::Map::MappableI>\n Args    : none to get\n           new L<Bio::Map::MappableI> to set\n\n\nsub element {\n    my ($self, $element) = @_;\n    return $self->get_position_handler->element($element);\n}\n\n=head2 marker\n\n Title   : marker\n Function: This is a synonym of the element() method\n Status  : deprecated, will be removed in the next version\n\n\n*marker = \\&element;\n\n=head2 PositionI-specific methods\n\n\n=head2 value\n\n Title   : value\n Usage   : my $pos = $position->value();\n Function: Get/Set the value for this position\n Returns : scalar, value\n Args    : [optional] new value to set\n\n\nsub value {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head2 numeric\n\n Title   : numeric\n Usage   : my $num = $position->numeric;\n Function: Read-only method that is guaranteed to return a numeric \n           representation of the start of this position. \n Returns : scalar numeric\n Args    : none to get the co-ordinate normally (see absolute() method), OR\n           Bio::Map::RelativeI to get the co-ordinate converted to be\n           relative to what this Relative describes.\n\n\nsub numeric {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head2 sortable\n\n Title   : sortable\n Usage   : my $num = $position->sortable();\n Function: Read-only method that is guaranteed to return a value suitable\n           for correctly sorting this kind of position amongst other positions\n           of the same kind on the same map. Note that sorting different kinds\n           of position together is unlikely to give sane results.\n Returns : numeric\n Args    : none\n\n\nsub sortable {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head2 relative\n\n  Title   : relative\n  Usage   : my $relative = $position->relative();\n            $position->relative($relative);\n  Function: Get/set the thing this Position's coordinates (numerical(), start(),\n            end()) are relative to, as described by a Relative object.\n  Returns : Bio::Map::RelativeI (default is one describing \"relative to the\n            start of the Position's map\")\n  Args    : none to get, OR\n            Bio::Map::RelativeI to set\n\n\nsub relative {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head2 absolute\n\n  Title   : absolute\n  Usage   : my $absolute = $position->absolute();\n            $position->absolute($absolute);\n  Function: Get/set how this Position's co-ordinates (numerical(), start(),\n            end()) are reported. When absolute is off, co-ordinates are\n            relative to the thing described by relative(). Ie. the value\n            returned by start() will be the same as the value you set start()\n            to. When absolute is on, co-ordinates are converted to be relative\n            to the start of the map.\n\n            So if relative() currently points to a Relative object describing\n            \"relative to another position which is 100 bp from the start of\n            the map\", this Position's start() had been set to 50 and absolute()\n            returns 1, $position->start() will return 150. If absolute() returns\n            0 in the same situation, $position->start() would return 50.\n\n  Returns : boolean (default 0)\n  Args    : none to get, OR\n            boolean to set\n\n\nsub absolute {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head2 RangeI-based methods\n\n\n=head2 start\n\n  Title   : start\n  Usage   : my $start = $position->start();\n            $position->start($start);\n  Function: Get/set the start co-ordinate of this position.\n  Returns : the start of this position\n  Args    : scalar numeric to set, OR\n            none to get the co-ordinate normally (see absolute() method), OR\n            Bio::Map::RelativeI to get the co-ordinate converted to be\n            relative to what this Relative describes.\n\n\n=head2 end\n\n  Title   : end\n  Usage   : my $end = $position->end();\n            $position->end($end);\n  Function: Get/set the end co-ordinate of this position.\n  Returns : the end of this position\n  Args    : scalar numeric to set, OR\n            none to get the co-ordinate normally (see absolute() method), OR\n            Bio::Map::RelativeI to get the co-ordinate converted to be\n            relative to what this Relative describes.\n\n\n=head2 length\n\n  Title   : length\n  Usage   : $length = $position->length();\n  Function: Get the length of this position.\n  Returns : the length of this position\n  Args    : none\n\n\n=head2 strand\n\n  Title   : strand\n  Usage   : $strand = $position->strand();\n  Function: Get the strand of this position; it is always 1 since maps to not\n            have strands.\n  Returns : 1\n  Args    : none\n\n\nsub strand {\n    return 1;\n}\n\n=head2 toString\n\n  Title   : toString\n  Usage   : print $position->toString(), \"\\n\";\n  Function: stringifies this range\n  Returns : a string representation of the range of this Position\n  Args    : optional Bio::Map::RelativeI to have the co-ordinates reported\n            relative to the thing described by that Relative\n\n\nsub toString {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head1 RangeI-related methods\n\nThese methods work by considering only the values of start() and end(), as\nmodified by considering every such co-ordinate relative to the start of the map\n(ie. absolute(1) is set temporarily during the calculation), or any supplied\nRelative. For the boolean methods, when the comparison Position is on the same\nmap as the calling Position, there is no point supplying a Relative since the\nanswer will be the same as without. Relative is most useful when comparing\nPositions on different maps and you have a Relative that describes some special\nplace on each map like 'the start of the gene', where the actual start of the\ngene relative to the start of the map is different for each map.\n\nThe methods do not consider maps during their calculations - things on different\nmaps can overlap/contain/intersect/etc. each other.\n\nThe geometrical methods (intersect, union etc.) do things to the geometry of\nranges, and return Bio::Map::PositionI compliant objects or triplets (start,\nstop, strand) from which new positions could be built. When a PositionI is made\nit will have a map transferred to it if all the arguments shared the same map.\nIf a Relative was supplied the result will have that same Relative.\n\nNote that the strand-testing args are there for compatability with the RangeI\ninterface. They have no meaning when only using PositionI objects since maps do\nnot have strands. Typically you will just set the argument to undef if you want\nto supply the argument after it.\n\n=head2 equals\n\n  Title   : equals\n  Usage   : if ($p1->equals($p2)) {...}\n  Function: Test whether $p1 has the same start, end, length as $p2.\n  Returns : true if they are describing the same position (regardless of map)\n  Args    : arg #1 = a Bio::RangeI (eg. a Bio::Map::Position) to compare this\n                     one to (mandatory)\n            arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n            arg #3 = optional Bio::Map::RelativeI to ask if the Positions\n                     equal in terms of their relative position to the thing\n                     described by that Relative\n\n\nsub equals {\n    # overriding the RangeI implementation so we can handle Relative\n    my ($self, $other, $so, $rel) = @_;\n    \n    my ($own_start, $own_end) = $self->_pre_rangei($self, $rel);\n    my ($other_start, $other_end) = $self->_pre_rangei($other, $rel);\n    \n    return ($self->_testStrand($other, $so) and\n            $own_start == $other_start and $own_end == $other_end);\n}\n\n\n=head2 less_than\n\n Title   : less_than\n Usage   : if ($position->less_than($other_position)) {...}\n Function: Ask if this Position ends before another starts.\n Returns : boolean\n Args    : arg #1 = a Bio::RangeI (eg. a Bio::Map::Position) to compare this\n                    one to (mandatory)\n           arg #2 = optional Bio::Map::RelativeI to ask if the Position is less\n                    in terms of their relative position to the thing described\n                    by that Relative\n\n\nsub less_than {\n    my ($self, $other, $rel) = @_;\n    \n    my ($own_start, $own_end) = $self->_pre_rangei($self, $rel);\n    my ($other_start, $other_end) = $self->_pre_rangei($other, $rel);\n    \n    return $own_end < $other_start;\n}\n\n=head2 greater_than\n\n Title   : greater_than\n Usage   : if ($position->greater_than($other_position)) {...}\n Function: Ask if this Position starts after another ends.\n Returns : boolean\n Args    : arg #1 = a Bio::RangeI (eg. a Bio::Map::Position) to compare this\n                    one to (mandatory)\n           arg #2 = optional Bio::Map::RelativeI to ask if the Position is\n                    greater in terms of their relative position to the thing\n                    described by that Relative\n\n\nsub greater_than {\n    my ($self, $other, $rel) = @_;\n    \n    my ($own_start, $own_end) = $self->_pre_rangei($self, $rel);\n    my ($other_start, $other_end) = $self->_pre_rangei($other, $rel);\n    \n    return $own_start > $other_end;\n}\n\n=head2 overlaps\n\n  Title   : overlaps\n  Usage   : if ($p1->overlaps($p2)) {...}\n  Function: Tests if $p1 overlaps $p2.\n  Returns : True if the positions overlap (regardless of map), false otherwise\n  Args    : arg #1 = a Bio::RangeI (eg. a Bio::Map::Position) to compare this\n                     one to (mandatory)\n            arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n            arg #3 = optional Bio::Map::RelativeI to ask if the Positions\n                     overlap in terms of their relative position to the thing\n                     described by that Relative\n            arg #4 = optional minimum percentage length of the overlap before\n                     reporting an overlap exists (default 0)\n\n\nsub overlaps {\n    # overriding the RangeI implementation so we can handle Relative\n    my ($self, $other, $so, $rel, $min_percent) = @_;\n    $min_percent ||= 0;\n    \n    my ($own_min, $other_min) = (0, 0);\n    if ($min_percent > 0) {\n        $own_min = (($self->length / 100) * $min_percent) - 1;\n        $other_min = (($other->length / 100) * $min_percent) - 1;\n    }\n    \n    my ($own_start, $own_end) = $self->_pre_rangei($self, $rel);\n    my ($other_start, $other_end) = $self->_pre_rangei($other, $rel);\n    \n    return ($self->_testStrand($other, $so) and not\n            (($own_start + $own_min > $other_end or $own_end - $own_min < $other_start) ||\n             ($own_start > $other_end - $other_min or $own_end < $other_start + $other_min)));\n}\n\n=head2 contains\n\n  Title   : contains\n  Usage   : if ($p1->contains($p2)) {...}\n  Function: Tests whether $p1 totally contains $p2.\n  Returns : true if the argument is totally contained within this position\n            (regardless of map), false otherwise\n  Args    : arg #1 = a Bio::RangeI (eg. a Bio::Map::Position) to compare this\n                     one to, or scalar number (mandatory)\n            arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n            arg #3 = optional Bio::Map::RelativeI to ask if the Position\n                     is contained in terms of their relative position to the\n                     thing described by that Relative\n\n\nsub contains {\n    # overriding the RangeI implementation so we can handle Relative\n    my ($self, $other, $so, $rel) = @_;\n    \n    my ($own_start, $own_end) = $self->_pre_rangei($self, $rel);\n    my ($other_start, $other_end) = $self->_pre_rangei($other, $rel);\n    \n    return ($self->_testStrand($other, $so) and\n\t\t\t$other_start >= $own_start and $other_end <= $own_end);\n}\n\n=head2 intersection\n\n Title   : intersection\n Usage   : ($start, $stop, $strand) = $p1->intersection($p2)\n           ($start, $stop, $strand) = Bio::Map::Position->intersection(\\@positions);\n           $mappable = $p1->intersection($p2, undef, $relative);\n           $mappable = Bio::Map::Position->intersection(\\@positions);\n Function: gives the range that is contained by all ranges\n Returns : undef if they do not overlap, OR\n           Bio::Map::Mappable object who's positions are the\n           cross-map-calculated intersection of the input positions on all the\n           maps that the input positions belong to, OR, in list context, a three\n           element array (start, end, strand)\n Args    : arg #1 = [REQUIRED] a Bio::RangeI (eg. a Bio::Map::Position) to\n                    compare this one to, or an array ref of Bio::RangeI\n           arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n           arg #3 = optional Bio::Map::RelativeI to ask how the Positions\n                    intersect in terms of their relative position to the thing\n                    described by that Relative","label":"intersection($self,$given,$so,$rel)"},"children":[{"name":"$self","localvar":"my","containerName":"intersection","kind":13,"line":538,"definition":"my"},{"containerName":"intersection","kind":13,"name":"$given","line":538},{"line":538,"containerName":"intersection","kind":13,"name":"$so"},{"containerName":"intersection","kind":13,"name":"$rel","line":538},{"line":539,"kind":13,"containerName":"intersection","name":"$self"},{"name":"throw","kind":12,"containerName":"intersection","line":539},{"line":539,"name":"$given","kind":13,"containerName":"intersection"},{"localvar":"my","kind":13,"containerName":"intersection","name":"@positions","line":541,"definition":"my"},{"line":542,"kind":13,"containerName":"intersection","name":"$self"},{"line":543,"kind":13,"containerName":"intersection","name":"$self"},{"line":544,"name":"$self","containerName":"intersection","kind":13},{"line":544,"kind":12,"containerName":"intersection","name":"warn"},{"name":"$self","containerName":"intersection","kind":13,"line":546},{"containerName":"intersection","kind":13,"name":"@positions","line":547},{"line":547,"kind":13,"containerName":"intersection","name":"$self"},{"line":549,"containerName":"intersection","kind":13,"name":"$given"},{"line":549,"containerName":"intersection","kind":13,"name":"@positions"},{"name":"$given","containerName":"intersection","kind":13,"line":549}],"name":"intersection","containerName":"main::","definition":"sub","detail":"($self,$given,$so,$rel)"},{"line":549,"kind":13,"containerName":null,"name":"@positions"},{"line":549,"kind":13,"containerName":null,"name":"$given"},{"line":550,"name":"$self","kind":13,"containerName":null},{"name":"throw","containerName":"main::","kind":12,"line":550},{"name":"@positions","kind":13,"containerName":null,"line":550},{"line":552,"name":"$intersect","containerName":null,"localvar":"my","kind":13,"definition":"my"},{"name":"$i_start","containerName":null,"kind":13,"line":552},{"name":"$i_end","containerName":null,"kind":13,"line":552},{"name":"$c_start","kind":13,"containerName":null,"line":552},{"line":552,"kind":13,"containerName":null,"name":"$c_end"},{"line":552,"containerName":null,"kind":13,"name":"%known_maps"},{"line":553,"containerName":null,"kind":13,"name":"@positions"},{"kind":13,"containerName":null,"name":"%intersect","line":554},{"containerName":null,"kind":13,"name":"$intersect","line":555},{"line":555,"name":"@positions","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"$i_start","line":556},{"name":"$i_end","containerName":null,"kind":13,"line":556},{"kind":13,"containerName":null,"name":"$self","line":556},{"line":556,"kind":12,"containerName":"main::","name":"_pre_rangei"},{"line":556,"kind":13,"containerName":null,"name":"$intersect"},{"containerName":null,"kind":13,"name":"$rel","line":556},{"definition":"my","line":557,"localvar":"my","containerName":null,"kind":13,"name":"$map"},{"kind":13,"containerName":null,"name":"$intersect","line":557},{"name":"map","containerName":"main::","kind":12,"line":557},{"line":558,"name":"%known_maps","kind":13,"containerName":null},{"line":558,"name":"$map","containerName":null,"kind":13},{"name":"unique_id","kind":12,"containerName":"main::","line":558},{"line":558,"name":"$map","kind":13,"containerName":null},{"definition":"my","name":"$compare","localvar":"my","containerName":null,"kind":13,"line":561},{"line":561,"containerName":null,"kind":13,"name":"@positions"},{"name":"$c_start","kind":13,"containerName":null,"line":562},{"kind":13,"containerName":null,"name":"$c_end","line":562},{"kind":13,"containerName":null,"name":"$self","line":562},{"containerName":"main::","kind":12,"name":"_pre_rangei","line":562},{"line":562,"name":"$compare","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"$rel","line":562},{"line":563,"kind":13,"containerName":null,"name":"$compare"},{"kind":12,"containerName":"main::","name":"_testStrand","line":563},{"line":563,"kind":13,"containerName":null,"name":"$intersect"},{"name":"$so","kind":13,"containerName":null,"line":563},{"kind":13,"containerName":null,"name":"$compare","line":564},{"containerName":"main::","kind":12,"name":"isa","line":564},{"definition":"my","localvar":"my","kind":13,"containerName":null,"name":"$this_map","line":565},{"containerName":null,"kind":13,"name":"$compare","line":565},{"line":565,"name":"map","containerName":"main::","kind":12},{"line":566,"name":"%this_map","kind":13,"containerName":null},{"line":567,"kind":13,"containerName":null,"name":"%known_maps"},{"line":567,"name":"$this_map","kind":13,"containerName":null},{"line":567,"name":"unique_id","kind":12,"containerName":"main::"},{"line":567,"containerName":null,"kind":13,"name":"%this_map"},{"line":571,"name":"$self","kind":13,"containerName":null},{"kind":12,"containerName":"main::","name":"throw","line":571},{"line":574,"name":"@starts","containerName":null,"localvar":"my","kind":13,"definition":"my"},{"line":574,"containerName":null,"kind":13,"name":"$a"},{"name":"$b","containerName":null,"kind":13,"line":574},{"line":574,"name":"$i_start","kind":13,"containerName":null},{"line":574,"containerName":null,"kind":13,"name":"$c_start"},{"definition":"my","name":"@ends","localvar":"my","containerName":null,"kind":13,"line":575},{"kind":13,"containerName":null,"name":"$a","line":575},{"kind":13,"containerName":null,"name":"$b","line":575},{"line":575,"kind":13,"containerName":null,"name":"$i_end"},{"line":575,"containerName":null,"kind":13,"name":"$c_end"},{"localvar":"my","kind":13,"containerName":null,"name":"$start","line":577,"definition":"my"},{"kind":13,"containerName":null,"name":"@starts","line":577},{"definition":"my","name":"$end","localvar":"my","containerName":null,"kind":13,"line":578},{"line":578,"kind":13,"containerName":null,"name":"@ends"},{"definition":"my","line":580,"name":"$intersect_strand","localvar":"my","kind":13,"containerName":null},{"line":581,"name":"$intersect","containerName":null,"kind":13},{"line":581,"kind":12,"containerName":"main::","name":"strand"},{"line":581,"containerName":null,"kind":13,"name":"$compare"},{"line":581,"name":"strand","kind":12,"containerName":"main::"},{"containerName":null,"kind":13,"name":"$intersect","line":581},{"line":581,"containerName":"main::","kind":12,"name":"strand"},{"line":581,"name":"$compare","kind":13,"containerName":null},{"line":581,"name":"strand","kind":12,"containerName":"main::"},{"line":582,"kind":13,"containerName":null,"name":"$intersect_strand"},{"line":582,"containerName":null,"kind":13,"name":"$compare"},{"line":582,"containerName":"main::","kind":12,"name":"strand"},{"containerName":null,"kind":13,"name":"$intersect_strand","line":585},{"kind":13,"containerName":null,"name":"$start","line":588},{"name":"%end","containerName":null,"kind":13,"line":588},{"line":592,"kind":13,"containerName":null,"name":"$intersect"},{"line":592,"name":"$self","containerName":null,"kind":13},{"kind":12,"containerName":"main::","name":"new","line":592},{"line":592,"kind":13,"containerName":null,"name":"$start"},{"line":593,"containerName":null,"kind":13,"name":"$end"},{"name":"$intersect_strand","containerName":null,"kind":13,"line":594},{"name":"$intersect","containerName":null,"kind":13,"line":598},{"definition":"my","line":599,"kind":13,"localvar":"my","containerName":null,"name":"$start"},{"name":"$end","kind":13,"containerName":null,"line":599},{"name":"$strand","containerName":null,"kind":13,"line":599},{"line":599,"containerName":null,"kind":13,"name":"$intersect"},{"kind":12,"containerName":"main::","name":"start","line":599},{"name":"$intersect","kind":13,"containerName":null,"line":599},{"line":599,"kind":12,"containerName":"main::","name":"end"},{"line":599,"name":"$intersect","kind":13,"containerName":null},{"line":599,"kind":12,"containerName":"main::","name":"strand"},{"line":601,"localvar":"my","kind":13,"containerName":null,"name":"@intersects","definition":"my"},{"definition":"my","line":602,"name":"$known_map","localvar":"my","kind":13,"containerName":null},{"line":602,"containerName":null,"kind":13,"name":"%known_maps"},{"definition":"my","line":603,"containerName":null,"localvar":"my","kind":13,"name":"$new_intersect"},{"line":603,"name":"$intersect","kind":13,"containerName":null},{"name":"new","kind":12,"containerName":"main::","line":603},{"name":"$start","kind":13,"containerName":null,"line":603},{"name":"$end","containerName":null,"kind":13,"line":604},{"name":"$strand","kind":13,"containerName":null,"line":605},{"kind":13,"containerName":null,"name":"$known_map","line":606},{"line":607,"containerName":null,"kind":13,"name":"$new_intersect"},{"kind":12,"containerName":"main::","name":"relative","line":607},{"line":607,"name":"$rel","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"$rel","line":607},{"line":608,"kind":13,"containerName":null,"name":"@intersects"},{"line":608,"name":"$new_intersect","containerName":null,"kind":13},{"name":"@intersects","containerName":null,"kind":13,"line":610},{"line":611,"name":"$intersect","containerName":null,"kind":13},{"name":"relative","kind":12,"containerName":"main::","line":611},{"line":611,"kind":13,"containerName":null,"name":"$rel"},{"line":611,"name":"$rel","kind":13,"containerName":null},{"line":612,"name":"@intersects","containerName":null,"kind":13},{"name":"$intersect","kind":13,"containerName":null,"line":612},{"containerName":null,"localvar":"my","kind":13,"name":"$result","line":615,"definition":"my"},{"containerName":"Map::Mappable","kind":12,"name":"Bio","line":615},{"line":615,"containerName":"main::","kind":12,"name":"new"},{"line":616,"name":"$result","kind":13,"containerName":null},{"name":"add_position","kind":12,"containerName":"main::","line":616},{"line":616,"name":"@intersects","containerName":null,"kind":13},{"line":617,"name":"$result","containerName":null,"kind":13},{"signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: PositionI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::PositionI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::PositionI - Abstracts the notion of a position having a value in the context of a marker and a Map\n\n=head1 SYNOPSIS\n\n    # do not use this module directly\n    # See Bio::Map::Position for an example of\n    # implementation.\n\n=head1 DESCRIPTION\n\nThis object stores one of the postions that a mappable object\n(e.g. Marker) may have in a map.\n\nPositions can have non-numeric values or other methods to store the locations,\nso they have a method numeric() which does the conversion. numeric()\nreturns the position in a form that can be compared between other positions of\nthe same type. It is not necessarily a value suitable for sorting positions (it\nmay be the distance from the previous position); for that purpose the result of\nsortable() should be used.\n\nA 'position', in addition to being a single point, can also be an area and so\ncan be imagined as a range and compared with other positions on the basis of\noverlap, intersection etc.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nLincoln Stein, lstein-at-cshl.org\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::PositionI;\nuse strict;\nuse Bio::Map::PositionHandler;\nuse Bio::Map::Mappable;\nuse Scalar::Util qw(looks_like_number);\n\nuse base qw(Bio::Map::EntityI Bio::RangeI);\n\n=head2 EntityI methods\n\n These are fundamental to coordination of Positions and other entities, so are\n implemented at the interface level\n\n\n=head2 get_position_handler\n\n Title   : get_position_handler\n Usage   : my $position_handler = $entity->get_position_handler();\n Function: Gets a PositionHandlerI that $entity is registered with.\n Returns : Bio::Map::PositionHandlerI object\n Args    : none\n\n\nsub get_position_handler {\n    my $self = shift;\n    unless (defined $self->{_eh}) {\n        my $ph = Bio::Map::PositionHandler->new(-self => $self);\n        $self->{_eh} = $ph;\n        $ph->register;\n    }\n    return $self->{_eh};\n}\n\n=head2 PositionHandlerI-related methods\n\n These are fundamental to coordination of Positions and other entities, so are\n implemented at the interface level\n\n\n=head2 map\n\n Title   : map\n Usage   : my $map = $position->map();\n           $position->map($map);\n Function: Get/Set the map the position is in.\n Returns : L<Bio::Map::MapI>\n Args    : none to get\n           new L<Bio::Map::MapI> to set\n\n\nsub map {\n    my ($self, $map) = @_;\n    return $self->get_position_handler->map($map);\n}\n\n=head2 element\n\n Title   : element\n Usage   : my $element = $position->element();\n           $position->element($element);\n Function: Get/Set the element the position is for.\n Returns : L<Bio::Map::MappableI>\n Args    : none to get\n           new L<Bio::Map::MappableI> to set\n\n\nsub element {\n    my ($self, $element) = @_;\n    return $self->get_position_handler->element($element);\n}\n\n=head2 marker\n\n Title   : marker\n Function: This is a synonym of the element() method\n Status  : deprecated, will be removed in the next version\n\n\n*marker = \\&element;\n\n=head2 PositionI-specific methods\n\n\n=head2 value\n\n Title   : value\n Usage   : my $pos = $position->value();\n Function: Get/Set the value for this position\n Returns : scalar, value\n Args    : [optional] new value to set\n\n\nsub value {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head2 numeric\n\n Title   : numeric\n Usage   : my $num = $position->numeric;\n Function: Read-only method that is guaranteed to return a numeric \n           representation of the start of this position. \n Returns : scalar numeric\n Args    : none to get the co-ordinate normally (see absolute() method), OR\n           Bio::Map::RelativeI to get the co-ordinate converted to be\n           relative to what this Relative describes.\n\n\nsub numeric {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head2 sortable\n\n Title   : sortable\n Usage   : my $num = $position->sortable();\n Function: Read-only method that is guaranteed to return a value suitable\n           for correctly sorting this kind of position amongst other positions\n           of the same kind on the same map. Note that sorting different kinds\n           of position together is unlikely to give sane results.\n Returns : numeric\n Args    : none\n\n\nsub sortable {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head2 relative\n\n  Title   : relative\n  Usage   : my $relative = $position->relative();\n            $position->relative($relative);\n  Function: Get/set the thing this Position's coordinates (numerical(), start(),\n            end()) are relative to, as described by a Relative object.\n  Returns : Bio::Map::RelativeI (default is one describing \"relative to the\n            start of the Position's map\")\n  Args    : none to get, OR\n            Bio::Map::RelativeI to set\n\n\nsub relative {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head2 absolute\n\n  Title   : absolute\n  Usage   : my $absolute = $position->absolute();\n            $position->absolute($absolute);\n  Function: Get/set how this Position's co-ordinates (numerical(), start(),\n            end()) are reported. When absolute is off, co-ordinates are\n            relative to the thing described by relative(). Ie. the value\n            returned by start() will be the same as the value you set start()\n            to. When absolute is on, co-ordinates are converted to be relative\n            to the start of the map.\n\n            So if relative() currently points to a Relative object describing\n            \"relative to another position which is 100 bp from the start of\n            the map\", this Position's start() had been set to 50 and absolute()\n            returns 1, $position->start() will return 150. If absolute() returns\n            0 in the same situation, $position->start() would return 50.\n\n  Returns : boolean (default 0)\n  Args    : none to get, OR\n            boolean to set\n\n\nsub absolute {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head2 RangeI-based methods\n\n\n=head2 start\n\n  Title   : start\n  Usage   : my $start = $position->start();\n            $position->start($start);\n  Function: Get/set the start co-ordinate of this position.\n  Returns : the start of this position\n  Args    : scalar numeric to set, OR\n            none to get the co-ordinate normally (see absolute() method), OR\n            Bio::Map::RelativeI to get the co-ordinate converted to be\n            relative to what this Relative describes.\n\n\n=head2 end\n\n  Title   : end\n  Usage   : my $end = $position->end();\n            $position->end($end);\n  Function: Get/set the end co-ordinate of this position.\n  Returns : the end of this position\n  Args    : scalar numeric to set, OR\n            none to get the co-ordinate normally (see absolute() method), OR\n            Bio::Map::RelativeI to get the co-ordinate converted to be\n            relative to what this Relative describes.\n\n\n=head2 length\n\n  Title   : length\n  Usage   : $length = $position->length();\n  Function: Get the length of this position.\n  Returns : the length of this position\n  Args    : none\n\n\n=head2 strand\n\n  Title   : strand\n  Usage   : $strand = $position->strand();\n  Function: Get the strand of this position; it is always 1 since maps to not\n            have strands.\n  Returns : 1\n  Args    : none\n\n\nsub strand {\n    return 1;\n}\n\n=head2 toString\n\n  Title   : toString\n  Usage   : print $position->toString(), \"\\n\";\n  Function: stringifies this range\n  Returns : a string representation of the range of this Position\n  Args    : optional Bio::Map::RelativeI to have the co-ordinates reported\n            relative to the thing described by that Relative\n\n\nsub toString {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head1 RangeI-related methods\n\nThese methods work by considering only the values of start() and end(), as\nmodified by considering every such co-ordinate relative to the start of the map\n(ie. absolute(1) is set temporarily during the calculation), or any supplied\nRelative. For the boolean methods, when the comparison Position is on the same\nmap as the calling Position, there is no point supplying a Relative since the\nanswer will be the same as without. Relative is most useful when comparing\nPositions on different maps and you have a Relative that describes some special\nplace on each map like 'the start of the gene', where the actual start of the\ngene relative to the start of the map is different for each map.\n\nThe methods do not consider maps during their calculations - things on different\nmaps can overlap/contain/intersect/etc. each other.\n\nThe geometrical methods (intersect, union etc.) do things to the geometry of\nranges, and return Bio::Map::PositionI compliant objects or triplets (start,\nstop, strand) from which new positions could be built. When a PositionI is made\nit will have a map transferred to it if all the arguments shared the same map.\nIf a Relative was supplied the result will have that same Relative.\n\nNote that the strand-testing args are there for compatability with the RangeI\ninterface. They have no meaning when only using PositionI objects since maps do\nnot have strands. Typically you will just set the argument to undef if you want\nto supply the argument after it.\n\n=head2 equals\n\n  Title   : equals\n  Usage   : if ($p1->equals($p2)) {...}\n  Function: Test whether $p1 has the same start, end, length as $p2.\n  Returns : true if they are describing the same position (regardless of map)\n  Args    : arg #1 = a Bio::RangeI (eg. a Bio::Map::Position) to compare this\n                     one to (mandatory)\n            arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n            arg #3 = optional Bio::Map::RelativeI to ask if the Positions\n                     equal in terms of their relative position to the thing\n                     described by that Relative\n\n\nsub equals {\n    # overriding the RangeI implementation so we can handle Relative\n    my ($self, $other, $so, $rel) = @_;\n    \n    my ($own_start, $own_end) = $self->_pre_rangei($self, $rel);\n    my ($other_start, $other_end) = $self->_pre_rangei($other, $rel);\n    \n    return ($self->_testStrand($other, $so) and\n            $own_start == $other_start and $own_end == $other_end);\n}\n\n\n=head2 less_than\n\n Title   : less_than\n Usage   : if ($position->less_than($other_position)) {...}\n Function: Ask if this Position ends before another starts.\n Returns : boolean\n Args    : arg #1 = a Bio::RangeI (eg. a Bio::Map::Position) to compare this\n                    one to (mandatory)\n           arg #2 = optional Bio::Map::RelativeI to ask if the Position is less\n                    in terms of their relative position to the thing described\n                    by that Relative\n\n\nsub less_than {\n    my ($self, $other, $rel) = @_;\n    \n    my ($own_start, $own_end) = $self->_pre_rangei($self, $rel);\n    my ($other_start, $other_end) = $self->_pre_rangei($other, $rel);\n    \n    return $own_end < $other_start;\n}\n\n=head2 greater_than\n\n Title   : greater_than\n Usage   : if ($position->greater_than($other_position)) {...}\n Function: Ask if this Position starts after another ends.\n Returns : boolean\n Args    : arg #1 = a Bio::RangeI (eg. a Bio::Map::Position) to compare this\n                    one to (mandatory)\n           arg #2 = optional Bio::Map::RelativeI to ask if the Position is\n                    greater in terms of their relative position to the thing\n                    described by that Relative\n\n\nsub greater_than {\n    my ($self, $other, $rel) = @_;\n    \n    my ($own_start, $own_end) = $self->_pre_rangei($self, $rel);\n    my ($other_start, $other_end) = $self->_pre_rangei($other, $rel);\n    \n    return $own_start > $other_end;\n}\n\n=head2 overlaps\n\n  Title   : overlaps\n  Usage   : if ($p1->overlaps($p2)) {...}\n  Function: Tests if $p1 overlaps $p2.\n  Returns : True if the positions overlap (regardless of map), false otherwise\n  Args    : arg #1 = a Bio::RangeI (eg. a Bio::Map::Position) to compare this\n                     one to (mandatory)\n            arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n            arg #3 = optional Bio::Map::RelativeI to ask if the Positions\n                     overlap in terms of their relative position to the thing\n                     described by that Relative\n            arg #4 = optional minimum percentage length of the overlap before\n                     reporting an overlap exists (default 0)\n\n\nsub overlaps {\n    # overriding the RangeI implementation so we can handle Relative\n    my ($self, $other, $so, $rel, $min_percent) = @_;\n    $min_percent ||= 0;\n    \n    my ($own_min, $other_min) = (0, 0);\n    if ($min_percent > 0) {\n        $own_min = (($self->length / 100) * $min_percent) - 1;\n        $other_min = (($other->length / 100) * $min_percent) - 1;\n    }\n    \n    my ($own_start, $own_end) = $self->_pre_rangei($self, $rel);\n    my ($other_start, $other_end) = $self->_pre_rangei($other, $rel);\n    \n    return ($self->_testStrand($other, $so) and not\n            (($own_start + $own_min > $other_end or $own_end - $own_min < $other_start) ||\n             ($own_start > $other_end - $other_min or $own_end < $other_start + $other_min)));\n}\n\n=head2 contains\n\n  Title   : contains\n  Usage   : if ($p1->contains($p2)) {...}\n  Function: Tests whether $p1 totally contains $p2.\n  Returns : true if the argument is totally contained within this position\n            (regardless of map), false otherwise\n  Args    : arg #1 = a Bio::RangeI (eg. a Bio::Map::Position) to compare this\n                     one to, or scalar number (mandatory)\n            arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n            arg #3 = optional Bio::Map::RelativeI to ask if the Position\n                     is contained in terms of their relative position to the\n                     thing described by that Relative\n\n\nsub contains {\n    # overriding the RangeI implementation so we can handle Relative\n    my ($self, $other, $so, $rel) = @_;\n    \n    my ($own_start, $own_end) = $self->_pre_rangei($self, $rel);\n    my ($other_start, $other_end) = $self->_pre_rangei($other, $rel);\n    \n    return ($self->_testStrand($other, $so) and\n\t\t\t$other_start >= $own_start and $other_end <= $own_end);\n}\n\n=head2 intersection\n\n Title   : intersection\n Usage   : ($start, $stop, $strand) = $p1->intersection($p2)\n           ($start, $stop, $strand) = Bio::Map::Position->intersection(\\@positions);\n           $mappable = $p1->intersection($p2, undef, $relative);\n           $mappable = Bio::Map::Position->intersection(\\@positions);\n Function: gives the range that is contained by all ranges\n Returns : undef if they do not overlap, OR\n           Bio::Map::Mappable object who's positions are the\n           cross-map-calculated intersection of the input positions on all the\n           maps that the input positions belong to, OR, in list context, a three\n           element array (start, end, strand)\n Args    : arg #1 = [REQUIRED] a Bio::RangeI (eg. a Bio::Map::Position) to\n                    compare this one to, or an array ref of Bio::RangeI\n           arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n           arg #3 = optional Bio::Map::RelativeI to ask how the Positions\n                    intersect in terms of their relative position to the thing\n                    described by that Relative\n\n\nsub intersection {\n    # overriding the RangeI implementation so we can transfer map and handle\n    # Relative\n    my ($self, $given, $so, $rel) = @_;\n\t$self->throw(\"missing arg: you need to pass in another argument\") unless $given;\n    \n    my @positions;\n    if ($self eq \"Bio::Map::PositionI\") {\n\t\t$self = \"Bio::Map::Position\";\n\t\t$self->warn(\"calling static methods of an interface is deprecated; use $self instead\");\n\t}\n\tif (ref $self) {\n\t\tpush(@positions, $self);\n\t}\n    ref($given) eq 'ARRAY' ? push(@positions, @{$given}) : push(@positions, $given);\n    $self->throw(\"Need at least 2 Positions\") unless @positions >= 2;\n    \n    my ($intersect, $i_start, $i_end, $c_start, $c_end, %known_maps);\n    while (@positions > 0) {\n        unless ($intersect) {\n            $intersect = shift(@positions);\n            ($i_start, $i_end) = $self->_pre_rangei($intersect, $rel);\n            my $map = $intersect->map;\n            $known_maps{$map->unique_id} = $map;\n        }\n        \n        my $compare = shift(@positions);\n        ($c_start, $c_end) = $self->_pre_rangei($compare, $rel);\n        return unless $compare->_testStrand($intersect, $so);\n        if ($compare->isa('Bio::Map::PositionI')) {\n            my $this_map = $compare->map;\n            if ($this_map) {\n                $known_maps{$this_map->unique_id} = $this_map;\n            }\n        }\n        else {\n            $self->throw(\"Only Bio::Map::PositionI objects are supported, not [$compare]\");\n        }\n        \n        my @starts = sort {$a <=> $b} ($i_start, $c_start);\n        my @ends   = sort {$a <=> $b} ($i_end, $c_end);\n        \n        my $start = pop @starts; # larger of the 2 starts\n        my $end = shift @ends;   # smaller of the 2 ends\n        \n        my $intersect_strand;    # strand for the intersection\n        if (defined($intersect->strand) && defined($compare->strand) && $intersect->strand == $compare->strand) {\n            $intersect_strand = $compare->strand;\n        }\n        else {\n            $intersect_strand = 0;\n        }\n        \n        if ($start > $end) {\n            return;\n        }\n        else {\n            $intersect = $self->new(-start  => $start,\n                                    -end    => $end,\n                                    -strand => $intersect_strand);\n        }\n    }\n    \n    $intersect || return;\n    my ($start, $end, $strand) = ($intersect->start, $intersect->end, $intersect->strand);\n    \n    my @intersects;\n    foreach my $known_map (values %known_maps) {\n        my $new_intersect = $intersect->new(-start => $start,\n                                            -end => $end,\n                                            -strand => $strand,\n                                            -map => $known_map);\n        $new_intersect->relative($rel) if $rel;\n        push(@intersects, $new_intersect);\n    }\n    unless (@intersects) {\n        $intersect->relative($rel) if $rel;\n        @intersects = ($intersect);\n    }\n    \n    my $result = Bio::Map::Mappable->new();\n    $result->add_position(@intersects); # sneaky, add_position can take a list of positions\n    return $result;\n}\n\n=head2 union\n\n Title   : union\n Usage   : ($start, $stop, $strand) = $p1->union($p2);\n           ($start, $stop, $strand) = Bio::Map::Position->union(@positions);\n           my $mappable = $p1->union($p2);\n           my $mappable = Bio::Map::Position->union(@positions);\n Function: finds the minimal position/range that contains all of the positions\n Returns : Bio::Map::Mappable object who's positions are the\n           cross-map-calculated union of the input positions on all the maps\n           that the input positions belong to, OR, in list context, a three\n           element array (start, end, strand)\n Args    : a Bio::Map::PositionI to compare this one to, or a list of such\n           OR\n           a single Bio::Map::PositionI or array ref of such AND a\n           Bio::Map::RelativeI to ask for the Position's union in terms of their\n           relative position to the thing described by that Relative","label":"union($self,@args)"},"kind":12,"range":{"end":{"line":657,"character":9999},"start":{"line":640,"character":0}},"line":640,"detail":"($self,@args)","definition":"sub","name":"union","containerName":"main::","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"union","line":643},{"line":643,"containerName":"union","kind":13,"name":"@args"},{"line":644,"name":"$self","containerName":"union","kind":13},{"name":"throw","containerName":"union","kind":12,"line":644},{"line":644,"name":"@args","kind":13,"containerName":"union"},{"definition":"my","line":646,"name":"@positions","containerName":"union","localvar":"my","kind":13},{"definition":"my","line":647,"containerName":"union","localvar":"my","kind":13,"name":"$rel"},{"name":"$self","kind":13,"containerName":"union","line":648},{"line":649,"containerName":"union","kind":13,"name":"$self"},{"containerName":"union","kind":13,"name":"$self","line":650},{"containerName":"union","kind":12,"name":"warn","line":650},{"name":"$self","kind":13,"containerName":"union","line":652},{"kind":13,"containerName":"union","name":"@positions","line":653},{"name":"$self","kind":13,"containerName":"union","line":653},{"name":"$args","containerName":"union","kind":13,"line":655},{"line":656,"name":"@positions","containerName":"union","kind":13},{"line":656,"kind":13,"containerName":"union","name":"@args"}]},{"kind":12,"name":"shift","line":656},{"line":659,"name":"@positions","kind":13,"containerName":null},{"name":"@args","kind":13,"containerName":null,"line":659},{"name":"@args","kind":13,"containerName":null,"line":661},{"line":661,"name":"@args","kind":13,"containerName":null},{"line":661,"kind":12,"containerName":"main::","name":"isa"},{"line":662,"name":"$rel","containerName":null,"kind":13},{"line":662,"kind":13,"containerName":null,"name":"@args"},{"line":664,"localvar":"my","containerName":null,"kind":13,"name":"$arg","definition":"my"},{"name":"@args","kind":13,"containerName":null,"line":664},{"name":"@positions","containerName":null,"kind":13,"line":666},{"containerName":null,"kind":13,"name":"$arg","line":666},{"line":666,"containerName":null,"kind":13,"name":"$arg"},{"name":"$self","kind":13,"containerName":null,"line":668},{"line":668,"name":"throw","containerName":"main::","kind":12},{"line":668,"name":"@positions","kind":13,"containerName":null},{"definition":"my","localvar":"my","containerName":null,"kind":13,"name":"@starts","line":670},{"containerName":null,"kind":13,"name":"@ends","line":670},{"containerName":null,"kind":13,"name":"%known_maps","line":670},{"containerName":null,"kind":13,"name":"$union_strand","line":670},{"localvar":"my","kind":13,"containerName":null,"name":"$compare","line":671,"definition":"my"},{"line":671,"containerName":null,"kind":13,"name":"@positions"},{"definition":"my","name":"$start","localvar":"my","kind":13,"containerName":null,"line":674},{"line":674,"name":"$end","kind":13,"containerName":null},{"line":674,"kind":13,"containerName":null,"name":"$self"},{"line":674,"containerName":"main::","kind":12,"name":"_pre_rangei"},{"line":674,"kind":13,"containerName":null,"name":"$compare"},{"line":674,"kind":13,"containerName":null,"name":"$rel"},{"name":"$compare","kind":13,"containerName":null,"line":676},{"line":676,"name":"isa","kind":12,"containerName":"main::"},{"localvar":"my","kind":13,"containerName":null,"name":"$this_map","line":677,"definition":"my"},{"containerName":null,"kind":13,"name":"$compare","line":677},{"kind":12,"containerName":"main::","name":"map","line":677},{"line":678,"kind":13,"containerName":null,"name":"%this_map"},{"containerName":null,"kind":13,"name":"%known_maps","line":679},{"line":679,"kind":13,"containerName":null,"name":"$this_map"},{"name":"unique_id","containerName":"main::","kind":12,"line":679},{"kind":13,"containerName":null,"name":"%this_map","line":679},{"containerName":null,"kind":13,"name":"$self","line":683},{"containerName":"main::","kind":12,"name":"throw","line":683},{"line":686,"name":"%union_strand","containerName":null,"kind":13},{"name":"$union_strand","kind":13,"containerName":null,"line":687},{"containerName":null,"kind":13,"name":"$compare","line":687},{"containerName":"main::","kind":12,"name":"strand","line":687},{"containerName":null,"kind":13,"name":"$compare","line":690},{"name":"strand","kind":12,"containerName":"main::","line":690},{"line":690,"name":"$union_strand","containerName":null,"kind":13},{"line":690,"name":"$compare","kind":13,"containerName":null},{"containerName":"main::","kind":12,"name":"strand","line":690},{"line":691,"kind":13,"containerName":null,"name":"$union_strand"},{"kind":13,"containerName":null,"name":"@starts","line":695},{"line":695,"containerName":null,"kind":13,"name":"$start"},{"line":696,"name":"@ends","containerName":null,"kind":13},{"name":"$end","containerName":null,"kind":13,"line":696},{"kind":13,"containerName":null,"name":"@starts","line":699},{"line":699,"name":"$a","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"$b","line":699},{"line":699,"containerName":null,"kind":13,"name":"@starts"},{"line":700,"containerName":null,"kind":13,"name":"@ends"},{"name":"$a","kind":13,"containerName":null,"line":700},{"line":700,"kind":13,"containerName":null,"name":"$b"},{"kind":13,"containerName":null,"name":"@ends","line":700},{"line":701,"name":"$start","kind":13,"localvar":"my","containerName":null,"definition":"my"},{"line":701,"kind":13,"containerName":null,"name":"@starts"},{"definition":"my","line":702,"containerName":null,"localvar":"my","kind":13,"name":"$end"},{"name":"@ends","containerName":null,"kind":13,"line":702},{"definition":"my","name":"@unions","containerName":null,"localvar":"my","kind":13,"line":704},{"definition":"my","line":705,"localvar":"my","containerName":null,"kind":13,"name":"$known_map"},{"name":"%known_maps","containerName":null,"kind":13,"line":705},{"localvar":"my","kind":13,"containerName":null,"name":"$new_union","line":706,"definition":"my"},{"name":"$self","kind":13,"containerName":null,"line":706},{"containerName":"main::","kind":12,"name":"new","line":706},{"containerName":null,"kind":13,"name":"$start","line":706},{"line":707,"name":"$end","containerName":null,"kind":13},{"line":708,"name":"$union_strand","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"$known_map","line":709},{"kind":13,"containerName":null,"name":"$new_union","line":710},{"line":710,"name":"relative","containerName":"main::","kind":12},{"line":710,"name":"$rel","containerName":null,"kind":13},{"line":710,"name":"$rel","kind":13,"containerName":null},{"line":711,"name":"@unions","containerName":null,"kind":13},{"line":711,"kind":13,"containerName":null,"name":"$new_union"},{"name":"@unions","kind":13,"containerName":null,"line":713},{"line":714,"containerName":null,"kind":13,"name":"@unions"},{"line":714,"kind":13,"containerName":null,"name":"$self"},{"kind":12,"containerName":"main::","name":"new","line":714},{"kind":13,"containerName":null,"name":"$start","line":714},{"line":715,"kind":13,"containerName":null,"name":"$end"},{"line":716,"name":"$union_strand","kind":13,"containerName":null},{"line":717,"name":"@unions","containerName":null,"kind":13},{"containerName":"main::","kind":12,"name":"relative","line":717},{"line":717,"kind":13,"containerName":null,"name":"$rel"},{"line":717,"kind":13,"containerName":null,"name":"$rel"},{"containerName":null,"localvar":"my","kind":13,"name":"$result","line":720,"definition":"my"},{"name":"Bio","containerName":"Map::Mappable","kind":12,"line":720},{"kind":12,"containerName":"main::","name":"new","line":720},{"line":721,"name":"$result","containerName":null,"kind":13},{"line":721,"name":"add_position","containerName":"main::","kind":12},{"line":721,"containerName":null,"kind":13,"name":"@unions"},{"line":722,"kind":13,"containerName":null,"name":"$result"},{"signature":{"documentation":"1;\n# $Id: PositionI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::PositionI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::PositionI - Abstracts the notion of a position having a value in the context of a marker and a Map\n\n=head1 SYNOPSIS\n\n    # do not use this module directly\n    # See Bio::Map::Position for an example of\n    # implementation.\n\n=head1 DESCRIPTION\n\nThis object stores one of the postions that a mappable object\n(e.g. Marker) may have in a map.\n\nPositions can have non-numeric values or other methods to store the locations,\nso they have a method numeric() which does the conversion. numeric()\nreturns the position in a form that can be compared between other positions of\nthe same type. It is not necessarily a value suitable for sorting positions (it\nmay be the distance from the previous position); for that purpose the result of\nsortable() should be used.\n\nA 'position', in addition to being a single point, can also be an area and so\ncan be imagined as a range and compared with other positions on the basis of\noverlap, intersection etc.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nLincoln Stein, lstein-at-cshl.org\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::PositionI;\nuse strict;\nuse Bio::Map::PositionHandler;\nuse Bio::Map::Mappable;\nuse Scalar::Util qw(looks_like_number);\n\nuse base qw(Bio::Map::EntityI Bio::RangeI);\n\n=head2 EntityI methods\n\n These are fundamental to coordination of Positions and other entities, so are\n implemented at the interface level\n\n\n=head2 get_position_handler\n\n Title   : get_position_handler\n Usage   : my $position_handler = $entity->get_position_handler();\n Function: Gets a PositionHandlerI that $entity is registered with.\n Returns : Bio::Map::PositionHandlerI object\n Args    : none\n\n\nsub get_position_handler {\n    my $self = shift;\n    unless (defined $self->{_eh}) {\n        my $ph = Bio::Map::PositionHandler->new(-self => $self);\n        $self->{_eh} = $ph;\n        $ph->register;\n    }\n    return $self->{_eh};\n}\n\n=head2 PositionHandlerI-related methods\n\n These are fundamental to coordination of Positions and other entities, so are\n implemented at the interface level\n\n\n=head2 map\n\n Title   : map\n Usage   : my $map = $position->map();\n           $position->map($map);\n Function: Get/Set the map the position is in.\n Returns : L<Bio::Map::MapI>\n Args    : none to get\n           new L<Bio::Map::MapI> to set\n\n\nsub map {\n    my ($self, $map) = @_;\n    return $self->get_position_handler->map($map);\n}\n\n=head2 element\n\n Title   : element\n Usage   : my $element = $position->element();\n           $position->element($element);\n Function: Get/Set the element the position is for.\n Returns : L<Bio::Map::MappableI>\n Args    : none to get\n           new L<Bio::Map::MappableI> to set\n\n\nsub element {\n    my ($self, $element) = @_;\n    return $self->get_position_handler->element($element);\n}\n\n=head2 marker\n\n Title   : marker\n Function: This is a synonym of the element() method\n Status  : deprecated, will be removed in the next version\n\n\n*marker = \\&element;\n\n=head2 PositionI-specific methods\n\n\n=head2 value\n\n Title   : value\n Usage   : my $pos = $position->value();\n Function: Get/Set the value for this position\n Returns : scalar, value\n Args    : [optional] new value to set\n\n\nsub value {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head2 numeric\n\n Title   : numeric\n Usage   : my $num = $position->numeric;\n Function: Read-only method that is guaranteed to return a numeric \n           representation of the start of this position. \n Returns : scalar numeric\n Args    : none to get the co-ordinate normally (see absolute() method), OR\n           Bio::Map::RelativeI to get the co-ordinate converted to be\n           relative to what this Relative describes.\n\n\nsub numeric {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head2 sortable\n\n Title   : sortable\n Usage   : my $num = $position->sortable();\n Function: Read-only method that is guaranteed to return a value suitable\n           for correctly sorting this kind of position amongst other positions\n           of the same kind on the same map. Note that sorting different kinds\n           of position together is unlikely to give sane results.\n Returns : numeric\n Args    : none\n\n\nsub sortable {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head2 relative\n\n  Title   : relative\n  Usage   : my $relative = $position->relative();\n            $position->relative($relative);\n  Function: Get/set the thing this Position's coordinates (numerical(), start(),\n            end()) are relative to, as described by a Relative object.\n  Returns : Bio::Map::RelativeI (default is one describing \"relative to the\n            start of the Position's map\")\n  Args    : none to get, OR\n            Bio::Map::RelativeI to set\n\n\nsub relative {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head2 absolute\n\n  Title   : absolute\n  Usage   : my $absolute = $position->absolute();\n            $position->absolute($absolute);\n  Function: Get/set how this Position's co-ordinates (numerical(), start(),\n            end()) are reported. When absolute is off, co-ordinates are\n            relative to the thing described by relative(). Ie. the value\n            returned by start() will be the same as the value you set start()\n            to. When absolute is on, co-ordinates are converted to be relative\n            to the start of the map.\n\n            So if relative() currently points to a Relative object describing\n            \"relative to another position which is 100 bp from the start of\n            the map\", this Position's start() had been set to 50 and absolute()\n            returns 1, $position->start() will return 150. If absolute() returns\n            0 in the same situation, $position->start() would return 50.\n\n  Returns : boolean (default 0)\n  Args    : none to get, OR\n            boolean to set\n\n\nsub absolute {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head2 RangeI-based methods\n\n\n=head2 start\n\n  Title   : start\n  Usage   : my $start = $position->start();\n            $position->start($start);\n  Function: Get/set the start co-ordinate of this position.\n  Returns : the start of this position\n  Args    : scalar numeric to set, OR\n            none to get the co-ordinate normally (see absolute() method), OR\n            Bio::Map::RelativeI to get the co-ordinate converted to be\n            relative to what this Relative describes.\n\n\n=head2 end\n\n  Title   : end\n  Usage   : my $end = $position->end();\n            $position->end($end);\n  Function: Get/set the end co-ordinate of this position.\n  Returns : the end of this position\n  Args    : scalar numeric to set, OR\n            none to get the co-ordinate normally (see absolute() method), OR\n            Bio::Map::RelativeI to get the co-ordinate converted to be\n            relative to what this Relative describes.\n\n\n=head2 length\n\n  Title   : length\n  Usage   : $length = $position->length();\n  Function: Get the length of this position.\n  Returns : the length of this position\n  Args    : none\n\n\n=head2 strand\n\n  Title   : strand\n  Usage   : $strand = $position->strand();\n  Function: Get the strand of this position; it is always 1 since maps to not\n            have strands.\n  Returns : 1\n  Args    : none\n\n\nsub strand {\n    return 1;\n}\n\n=head2 toString\n\n  Title   : toString\n  Usage   : print $position->toString(), \"\\n\";\n  Function: stringifies this range\n  Returns : a string representation of the range of this Position\n  Args    : optional Bio::Map::RelativeI to have the co-ordinates reported\n            relative to the thing described by that Relative\n\n\nsub toString {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head1 RangeI-related methods\n\nThese methods work by considering only the values of start() and end(), as\nmodified by considering every such co-ordinate relative to the start of the map\n(ie. absolute(1) is set temporarily during the calculation), or any supplied\nRelative. For the boolean methods, when the comparison Position is on the same\nmap as the calling Position, there is no point supplying a Relative since the\nanswer will be the same as without. Relative is most useful when comparing\nPositions on different maps and you have a Relative that describes some special\nplace on each map like 'the start of the gene', where the actual start of the\ngene relative to the start of the map is different for each map.\n\nThe methods do not consider maps during their calculations - things on different\nmaps can overlap/contain/intersect/etc. each other.\n\nThe geometrical methods (intersect, union etc.) do things to the geometry of\nranges, and return Bio::Map::PositionI compliant objects or triplets (start,\nstop, strand) from which new positions could be built. When a PositionI is made\nit will have a map transferred to it if all the arguments shared the same map.\nIf a Relative was supplied the result will have that same Relative.\n\nNote that the strand-testing args are there for compatability with the RangeI\ninterface. They have no meaning when only using PositionI objects since maps do\nnot have strands. Typically you will just set the argument to undef if you want\nto supply the argument after it.\n\n=head2 equals\n\n  Title   : equals\n  Usage   : if ($p1->equals($p2)) {...}\n  Function: Test whether $p1 has the same start, end, length as $p2.\n  Returns : true if they are describing the same position (regardless of map)\n  Args    : arg #1 = a Bio::RangeI (eg. a Bio::Map::Position) to compare this\n                     one to (mandatory)\n            arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n            arg #3 = optional Bio::Map::RelativeI to ask if the Positions\n                     equal in terms of their relative position to the thing\n                     described by that Relative\n\n\nsub equals {\n    # overriding the RangeI implementation so we can handle Relative\n    my ($self, $other, $so, $rel) = @_;\n    \n    my ($own_start, $own_end) = $self->_pre_rangei($self, $rel);\n    my ($other_start, $other_end) = $self->_pre_rangei($other, $rel);\n    \n    return ($self->_testStrand($other, $so) and\n            $own_start == $other_start and $own_end == $other_end);\n}\n\n\n=head2 less_than\n\n Title   : less_than\n Usage   : if ($position->less_than($other_position)) {...}\n Function: Ask if this Position ends before another starts.\n Returns : boolean\n Args    : arg #1 = a Bio::RangeI (eg. a Bio::Map::Position) to compare this\n                    one to (mandatory)\n           arg #2 = optional Bio::Map::RelativeI to ask if the Position is less\n                    in terms of their relative position to the thing described\n                    by that Relative\n\n\nsub less_than {\n    my ($self, $other, $rel) = @_;\n    \n    my ($own_start, $own_end) = $self->_pre_rangei($self, $rel);\n    my ($other_start, $other_end) = $self->_pre_rangei($other, $rel);\n    \n    return $own_end < $other_start;\n}\n\n=head2 greater_than\n\n Title   : greater_than\n Usage   : if ($position->greater_than($other_position)) {...}\n Function: Ask if this Position starts after another ends.\n Returns : boolean\n Args    : arg #1 = a Bio::RangeI (eg. a Bio::Map::Position) to compare this\n                    one to (mandatory)\n           arg #2 = optional Bio::Map::RelativeI to ask if the Position is\n                    greater in terms of their relative position to the thing\n                    described by that Relative\n\n\nsub greater_than {\n    my ($self, $other, $rel) = @_;\n    \n    my ($own_start, $own_end) = $self->_pre_rangei($self, $rel);\n    my ($other_start, $other_end) = $self->_pre_rangei($other, $rel);\n    \n    return $own_start > $other_end;\n}\n\n=head2 overlaps\n\n  Title   : overlaps\n  Usage   : if ($p1->overlaps($p2)) {...}\n  Function: Tests if $p1 overlaps $p2.\n  Returns : True if the positions overlap (regardless of map), false otherwise\n  Args    : arg #1 = a Bio::RangeI (eg. a Bio::Map::Position) to compare this\n                     one to (mandatory)\n            arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n            arg #3 = optional Bio::Map::RelativeI to ask if the Positions\n                     overlap in terms of their relative position to the thing\n                     described by that Relative\n            arg #4 = optional minimum percentage length of the overlap before\n                     reporting an overlap exists (default 0)\n\n\nsub overlaps {\n    # overriding the RangeI implementation so we can handle Relative\n    my ($self, $other, $so, $rel, $min_percent) = @_;\n    $min_percent ||= 0;\n    \n    my ($own_min, $other_min) = (0, 0);\n    if ($min_percent > 0) {\n        $own_min = (($self->length / 100) * $min_percent) - 1;\n        $other_min = (($other->length / 100) * $min_percent) - 1;\n    }\n    \n    my ($own_start, $own_end) = $self->_pre_rangei($self, $rel);\n    my ($other_start, $other_end) = $self->_pre_rangei($other, $rel);\n    \n    return ($self->_testStrand($other, $so) and not\n            (($own_start + $own_min > $other_end or $own_end - $own_min < $other_start) ||\n             ($own_start > $other_end - $other_min or $own_end < $other_start + $other_min)));\n}\n\n=head2 contains\n\n  Title   : contains\n  Usage   : if ($p1->contains($p2)) {...}\n  Function: Tests whether $p1 totally contains $p2.\n  Returns : true if the argument is totally contained within this position\n            (regardless of map), false otherwise\n  Args    : arg #1 = a Bio::RangeI (eg. a Bio::Map::Position) to compare this\n                     one to, or scalar number (mandatory)\n            arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n            arg #3 = optional Bio::Map::RelativeI to ask if the Position\n                     is contained in terms of their relative position to the\n                     thing described by that Relative\n\n\nsub contains {\n    # overriding the RangeI implementation so we can handle Relative\n    my ($self, $other, $so, $rel) = @_;\n    \n    my ($own_start, $own_end) = $self->_pre_rangei($self, $rel);\n    my ($other_start, $other_end) = $self->_pre_rangei($other, $rel);\n    \n    return ($self->_testStrand($other, $so) and\n\t\t\t$other_start >= $own_start and $other_end <= $own_end);\n}\n\n=head2 intersection\n\n Title   : intersection\n Usage   : ($start, $stop, $strand) = $p1->intersection($p2)\n           ($start, $stop, $strand) = Bio::Map::Position->intersection(\\@positions);\n           $mappable = $p1->intersection($p2, undef, $relative);\n           $mappable = Bio::Map::Position->intersection(\\@positions);\n Function: gives the range that is contained by all ranges\n Returns : undef if they do not overlap, OR\n           Bio::Map::Mappable object who's positions are the\n           cross-map-calculated intersection of the input positions on all the\n           maps that the input positions belong to, OR, in list context, a three\n           element array (start, end, strand)\n Args    : arg #1 = [REQUIRED] a Bio::RangeI (eg. a Bio::Map::Position) to\n                    compare this one to, or an array ref of Bio::RangeI\n           arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n           arg #3 = optional Bio::Map::RelativeI to ask how the Positions\n                    intersect in terms of their relative position to the thing\n                    described by that Relative\n\n\nsub intersection {\n    # overriding the RangeI implementation so we can transfer map and handle\n    # Relative\n    my ($self, $given, $so, $rel) = @_;\n\t$self->throw(\"missing arg: you need to pass in another argument\") unless $given;\n    \n    my @positions;\n    if ($self eq \"Bio::Map::PositionI\") {\n\t\t$self = \"Bio::Map::Position\";\n\t\t$self->warn(\"calling static methods of an interface is deprecated; use $self instead\");\n\t}\n\tif (ref $self) {\n\t\tpush(@positions, $self);\n\t}\n    ref($given) eq 'ARRAY' ? push(@positions, @{$given}) : push(@positions, $given);\n    $self->throw(\"Need at least 2 Positions\") unless @positions >= 2;\n    \n    my ($intersect, $i_start, $i_end, $c_start, $c_end, %known_maps);\n    while (@positions > 0) {\n        unless ($intersect) {\n            $intersect = shift(@positions);\n            ($i_start, $i_end) = $self->_pre_rangei($intersect, $rel);\n            my $map = $intersect->map;\n            $known_maps{$map->unique_id} = $map;\n        }\n        \n        my $compare = shift(@positions);\n        ($c_start, $c_end) = $self->_pre_rangei($compare, $rel);\n        return unless $compare->_testStrand($intersect, $so);\n        if ($compare->isa('Bio::Map::PositionI')) {\n            my $this_map = $compare->map;\n            if ($this_map) {\n                $known_maps{$this_map->unique_id} = $this_map;\n            }\n        }\n        else {\n            $self->throw(\"Only Bio::Map::PositionI objects are supported, not [$compare]\");\n        }\n        \n        my @starts = sort {$a <=> $b} ($i_start, $c_start);\n        my @ends   = sort {$a <=> $b} ($i_end, $c_end);\n        \n        my $start = pop @starts; # larger of the 2 starts\n        my $end = shift @ends;   # smaller of the 2 ends\n        \n        my $intersect_strand;    # strand for the intersection\n        if (defined($intersect->strand) && defined($compare->strand) && $intersect->strand == $compare->strand) {\n            $intersect_strand = $compare->strand;\n        }\n        else {\n            $intersect_strand = 0;\n        }\n        \n        if ($start > $end) {\n            return;\n        }\n        else {\n            $intersect = $self->new(-start  => $start,\n                                    -end    => $end,\n                                    -strand => $intersect_strand);\n        }\n    }\n    \n    $intersect || return;\n    my ($start, $end, $strand) = ($intersect->start, $intersect->end, $intersect->strand);\n    \n    my @intersects;\n    foreach my $known_map (values %known_maps) {\n        my $new_intersect = $intersect->new(-start => $start,\n                                            -end => $end,\n                                            -strand => $strand,\n                                            -map => $known_map);\n        $new_intersect->relative($rel) if $rel;\n        push(@intersects, $new_intersect);\n    }\n    unless (@intersects) {\n        $intersect->relative($rel) if $rel;\n        @intersects = ($intersect);\n    }\n    \n    my $result = Bio::Map::Mappable->new();\n    $result->add_position(@intersects); # sneaky, add_position can take a list of positions\n    return $result;\n}\n\n=head2 union\n\n Title   : union\n Usage   : ($start, $stop, $strand) = $p1->union($p2);\n           ($start, $stop, $strand) = Bio::Map::Position->union(@positions);\n           my $mappable = $p1->union($p2);\n           my $mappable = Bio::Map::Position->union(@positions);\n Function: finds the minimal position/range that contains all of the positions\n Returns : Bio::Map::Mappable object who's positions are the\n           cross-map-calculated union of the input positions on all the maps\n           that the input positions belong to, OR, in list context, a three\n           element array (start, end, strand)\n Args    : a Bio::Map::PositionI to compare this one to, or a list of such\n           OR\n           a single Bio::Map::PositionI or array ref of such AND a\n           Bio::Map::RelativeI to ask for the Position's union in terms of their\n           relative position to the thing described by that Relative\n\n\nsub union {\n    # overriding the RangeI implementation so we can transfer map and handle\n    # Relative\n    my ($self, @args) = @_;\n    $self->throw(\"Not enough arguments\") unless @args >= 1;\n    \n    my @positions;\n    my $rel;\n    if ($self eq \"Bio::Map::PositionI\") {\n\t\t$self = \"Bio::Map::Position\";\n\t\t$self->warn(\"calling static methods of an interface is deprecated; use $self instead\");\n\t}\n\tif (ref $self) {\n\t\tpush(@positions, $self);\n\t}\n    if (ref $args[0] eq 'ARRAY') {\n        push(@positions, @{shift(@args)});\n    }\n    else {\n        push(@positions, shift(@args));\n    }\n    if ($args[0] && $args[0]->isa('Bio::Map::RelativeI')) {\n        $rel = shift(@args);\n    }\n    foreach my $arg (@args) {\n        # avoid pushing undefined values into @positions\n        push(@positions, $arg) if $arg;\n    }\n    $self->throw(\"Need at least 2 Positions\") unless @positions >= 2;\n    \n    my (@starts, @ends, %known_maps, $union_strand);\n    foreach my $compare (@positions) {\n        # RangeI union allows start or end to be undefined; however _pre_rangei\n        # will throw\n        my ($start, $end) = $self->_pre_rangei($compare, $rel);\n        \n        if ($compare->isa('Bio::Map::PositionI')) {\n            my $this_map = $compare->map;\n            if ($this_map) {\n                $known_maps{$this_map->unique_id} = $this_map;\n            }\n        }\n        else {\n            $self->throw(\"Only Bio::Map::PositionI objects are supported, not [$compare]\");\n        }\n        \n        if (! defined $union_strand) {\n\t\t\t$union_strand = $compare->strand;\n\t\t}\n        else {\n\t\t\tif (! defined $compare->strand or $union_strand ne $compare->strand) {\n\t\t\t\t$union_strand = 0;\n\t\t\t}\n\t\t}\n        \n        push(@starts, $start);\n        push(@ends, $end);\n    }\n    \n\t@starts = sort { $a <=> $b } @starts;\n\t@ends   = sort { $a <=> $b } @ends;\n\tmy $start = shift @starts;\n\tmy $end = pop @ends;\n    \n    my @unions;\n    foreach my $known_map (values %known_maps) {\n        my $new_union = $self->new(-start => $start,\n                                   -end => $end,\n                                   -strand => $union_strand,\n                                   -map => $known_map);\n        $new_union->relative($rel) if $rel;\n        push(@unions, $new_union);\n    }\n    unless (@unions) {\n        @unions = ($self->new(-start => $start,\n                         -end => $end,\n                         -strand => $union_strand));\n        $unions[0]->relative($rel) if $rel;\n    }\n    \n    my $result = Bio::Map::Mappable->new();\n    $result->add_position(@unions); # sneaky, add_position can take a list of positions\n    return $result;\n}\n\n=head2 overlap_extent\n\n Title   : overlap_extent\n Usage   : ($a_unique,$common,$b_unique) = $a->overlap_extent($b)\n Function: Provides actual amount of overlap between two different\n           positions\n Example :\n Returns : array of values containing the length unique to the calling \n           position, the length common to both, and the length unique to \n           the argument position\n Args    : a position\n\n\n#*** should this be overridden from RangeI?\n\n=head2 disconnected_ranges\n\n Title   : disconnected_ranges\n Usage   : my @disc_ranges = Bio::Map::Position->disconnected_ranges(@ranges);\n Function: Creates the minimal set of positions such that each input position is\n           fully contained by at least one output position, and none of the\n           output positions overlap.\n Returns : Bio::Map::Mappable with the calculated disconnected ranges\n Args    : a Bio::Map::PositionI to compare this one to, or a list of such,\n           OR\n           a single Bio::Map::PositionI or array ref of such AND a\n           Bio::Map::RelativeI to consider all Position's co-ordinates in terms\n           of their relative position to the thing described by that Relative,\n           AND, optionally, an int for the minimum percentage of overlap that\n           must be present before considering two ranges to be overlapping\n           (default 0)","parameters":[{"label":"$self"},{"label":"@args"}],"label":"disconnected_ranges($self,@args)"},"line":760,"range":{"start":{"line":760,"character":0},"end":{"character":9999,"line":778}},"kind":12,"definition":"sub","detail":"($self,@args)","children":[{"name":"$self","containerName":"disconnected_ranges","localvar":"my","kind":13,"line":763,"definition":"my"},{"line":763,"containerName":"disconnected_ranges","kind":13,"name":"@args"},{"line":764,"containerName":"disconnected_ranges","kind":13,"name":"$self"},{"containerName":"disconnected_ranges","kind":12,"name":"throw","line":764},{"line":764,"name":"@args","containerName":"disconnected_ranges","kind":13},{"line":766,"name":"@positions","kind":13,"localvar":"my","containerName":"disconnected_ranges","definition":"my"},{"localvar":"my","kind":13,"containerName":"disconnected_ranges","name":"$rel","line":767,"definition":"my"},{"name":"$overlap","containerName":"disconnected_ranges","localvar":"my","kind":13,"line":768,"definition":"my"},{"name":"$self","kind":13,"containerName":"disconnected_ranges","line":769},{"name":"$self","kind":13,"containerName":"disconnected_ranges","line":770},{"line":771,"name":"$self","kind":13,"containerName":"disconnected_ranges"},{"line":771,"name":"warn","kind":12,"containerName":"disconnected_ranges"},{"name":"$self","kind":13,"containerName":"disconnected_ranges","line":773},{"line":774,"name":"@positions","containerName":"disconnected_ranges","kind":13},{"kind":13,"containerName":"disconnected_ranges","name":"$self","line":774},{"line":776,"name":"$args","containerName":"disconnected_ranges","kind":13},{"line":777,"containerName":"disconnected_ranges","kind":13,"name":"@positions"},{"line":777,"name":"@args","kind":13,"containerName":"disconnected_ranges"}],"name":"disconnected_ranges","containerName":"main::"},{"kind":12,"name":"shift","line":777},{"containerName":null,"kind":13,"name":"@positions","line":780},{"line":780,"containerName":null,"kind":13,"name":"@args"},{"containerName":null,"kind":13,"name":"@args","line":782},{"name":"@args","kind":13,"containerName":null,"line":782},{"containerName":"main::","kind":12,"name":"isa","line":782},{"name":"$rel","kind":13,"containerName":null,"line":783},{"name":"@args","containerName":null,"kind":13,"line":783},{"containerName":null,"kind":13,"name":"$overlap","line":784},{"line":784,"containerName":null,"kind":13,"name":"@args"},{"localvar":"my","containerName":null,"kind":13,"name":"$arg","line":786,"definition":"my"},{"kind":13,"containerName":null,"name":"@args","line":786},{"line":787,"kind":13,"containerName":null,"name":"@positions"},{"line":787,"name":"$arg","kind":13,"containerName":null},{"name":"$arg","containerName":null,"kind":13,"line":787},{"line":789,"name":"$self","containerName":null,"kind":13},{"line":789,"containerName":"main::","kind":12,"name":"throw"},{"name":"@positions","kind":13,"containerName":null,"line":789},{"definition":"my","line":791,"containerName":null,"localvar":"my","kind":13,"name":"%known_maps"},{"definition":"my","line":792,"name":"$pos","localvar":"my","kind":13,"containerName":null},{"line":792,"name":"@positions","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"$pos","line":793},{"name":"isa","kind":12,"containerName":"main::","line":793},{"line":793,"containerName":null,"kind":13,"name":"$self"},{"name":"throw","kind":12,"containerName":"main::","line":793},{"line":794,"name":"$map","localvar":"my","kind":13,"containerName":null,"definition":"my"},{"name":"$pos","kind":13,"containerName":null,"line":794},{"line":794,"name":"map","containerName":"main::","kind":12},{"line":795,"name":"%known_maps","kind":13,"containerName":null},{"line":795,"containerName":null,"kind":13,"name":"$map"},{"line":795,"kind":12,"containerName":"main::","name":"unique_id"},{"line":795,"kind":13,"containerName":null,"name":"$map"},{"definition":"my","name":"%prior_positions","localvar":"my","kind":13,"containerName":null,"line":797},{"definition":"my","name":"$map","localvar":"my","kind":13,"containerName":null,"line":798},{"line":798,"name":"%known_maps","containerName":null,"kind":13},{"definition":"my","line":799,"name":"$pos","containerName":null,"localvar":"my","kind":13},{"line":799,"name":"$map","kind":13,"containerName":null},{"line":799,"name":"get_positions","kind":12,"containerName":"main::"},{"line":800,"name":"%prior_positions","kind":13,"containerName":null},{"line":800,"name":"$pos","containerName":null,"kind":13},{"definition":"my","name":"@outranges","localvar":"my","containerName":null,"kind":13,"line":804},{"definition":"my","kind":13,"localvar":"my","containerName":null,"name":"$inrange","line":805},{"line":805,"name":"@positions","kind":13,"containerName":null},{"name":"@outranges_new","localvar":"my","containerName":null,"kind":13,"line":806,"definition":"my"},{"name":"%overlapping_ranges","kind":13,"localvar":"my","containerName":null,"line":807,"definition":"my"},{"definition":"my","name":"$i","kind":13,"localvar":"my","containerName":null,"line":809},{"name":"$i","kind":13,"containerName":null,"line":809},{"name":"@outranges","kind":13,"containerName":null,"line":809},{"name":"%i","containerName":null,"kind":13,"line":809},{"definition":"my","name":"$outrange","localvar":"my","kind":13,"containerName":null,"line":810},{"name":"@outranges","containerName":null,"kind":13,"line":810},{"line":810,"name":"$i","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"$inrange","line":811},{"containerName":"main::","kind":12,"name":"overlaps","line":811},{"line":811,"containerName":null,"kind":13,"name":"$outrange"},{"line":811,"name":"$rel","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"%overlap","line":811},{"definition":"my","line":812,"name":"$union_able","localvar":"my","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"$inrange","line":812},{"line":812,"containerName":"main::","kind":12,"name":"union"},{"name":"$outrange","containerName":null,"kind":13,"line":812},{"line":812,"containerName":null,"kind":13,"name":"$rel"},{"definition":"my","line":814,"name":"$pos","kind":13,"localvar":"my","containerName":null},{"line":814,"name":"$union_able","kind":13,"containerName":null},{"line":814,"name":"get_positions","containerName":"main::","kind":12},{"name":"%overlapping_ranges","containerName":null,"kind":13,"line":815},{"line":815,"name":"$pos","containerName":null,"kind":13},{"kind":12,"containerName":"main::","name":"toString","line":815},{"containerName":null,"kind":13,"name":"%pos","line":815},{"kind":13,"containerName":null,"name":"@outranges_new","line":822},{"line":822,"kind":13,"containerName":null,"name":"$outrange"},{"name":"@outranges","containerName":null,"kind":13,"line":826},{"containerName":null,"kind":13,"name":"@outranges_new","line":826},{"line":828,"name":"@overlappers","containerName":null,"localvar":"my","kind":13,"definition":"my"},{"containerName":null,"kind":13,"name":"%overlapping_ranges","line":828},{"kind":13,"containerName":null,"name":"@overlappers","line":829},{"line":830,"name":"@overlappers","kind":13,"containerName":null},{"name":"$merged_range_able","containerName":null,"localvar":"my","kind":13,"line":831,"definition":"my"},{"name":"@overlappers","containerName":null,"kind":13,"line":831},{"line":831,"kind":12,"containerName":"main::","name":"union"},{"containerName":null,"kind":13,"name":"@overlappers","line":831},{"kind":13,"containerName":null,"name":"$rel","line":831},{"line":832,"kind":13,"containerName":null,"name":"@outranges"},{"name":"$merged_range_able","kind":13,"containerName":null,"line":832},{"line":832,"containerName":"main::","kind":12,"name":"get_positions"},{"kind":13,"containerName":null,"name":"@outranges","line":835},{"line":835,"name":"@overlappers","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"@outranges","line":839},{"name":"$self","containerName":null,"kind":13,"line":839},{"kind":12,"containerName":"main::","name":"new","line":839},{"line":839,"kind":13,"containerName":null,"name":"$inrange"},{"line":839,"name":"start","kind":12,"containerName":"main::"},{"line":839,"name":"$rel","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"$inrange","line":839},{"line":839,"containerName":"main::","kind":12,"name":"end"},{"containerName":null,"kind":13,"name":"$rel","line":839},{"line":839,"kind":13,"containerName":null,"name":"$inrange"},{"kind":12,"containerName":"main::","name":"strand","line":839},{"line":839,"name":"$inrange","kind":13,"containerName":null},{"line":839,"name":"map","containerName":"main::","kind":12},{"containerName":null,"kind":13,"name":"$rel","line":839},{"definition":"my","name":"%answers","kind":13,"localvar":"my","containerName":null,"line":845},{"line":845,"kind":13,"containerName":null,"name":"@outranges"},{"kind":13,"localvar":"my","containerName":null,"name":"$map","line":846,"definition":"my"},{"line":846,"name":"%known_maps","kind":13,"containerName":null},{"definition":"my","name":"$pos","containerName":null,"localvar":"my","kind":13,"line":847},{"containerName":null,"kind":13,"name":"$map","line":847},{"name":"get_positions","containerName":"main::","kind":12,"line":847},{"kind":13,"containerName":null,"name":"%prior_positions","line":848},{"line":848,"containerName":null,"kind":13,"name":"$pos"},{"line":848,"containerName":null,"kind":13,"name":"%answers"},{"line":848,"name":"%pos","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"$map","line":849},{"line":849,"name":"purge_positions","containerName":"main::","kind":12},{"name":"$pos","kind":13,"containerName":null,"line":849},{"line":854,"name":"%post_positions","localvar":"my","containerName":null,"kind":13,"definition":"my"},{"line":855,"name":"$map","localvar":"my","containerName":null,"kind":13,"definition":"my"},{"line":855,"name":"%known_maps","containerName":null,"kind":13},{"name":"$pos","kind":13,"localvar":"my","containerName":null,"line":856,"definition":"my"},{"line":856,"kind":13,"containerName":null,"name":"$map"},{"line":856,"containerName":"main::","kind":12,"name":"get_positions"},{"containerName":null,"kind":13,"name":"%post_positions","line":857},{"name":"$pos","containerName":null,"kind":13,"line":857},{"name":"@outranges","kind":13,"containerName":null,"line":861},{"containerName":null,"localvar":"my","kind":13,"name":"@final_positions","line":864,"definition":"my"},{"line":865,"name":"$map","localvar":"my","kind":13,"containerName":null,"definition":"my"},{"line":865,"containerName":null,"kind":13,"name":"%known_maps"},{"definition":"my","name":"$pos","containerName":null,"localvar":"my","kind":13,"line":866},{"name":"@outranges","containerName":null,"kind":13,"line":866},{"line":867,"kind":13,"containerName":null,"name":"$pos"},{"kind":12,"containerName":"main::","name":"map","line":867},{"name":"%map","containerName":null,"kind":13,"line":867},{"line":868,"kind":13,"containerName":null,"name":"@final_positions"},{"line":868,"containerName":null,"kind":13,"name":"%pos"},{"line":871,"kind":13,"containerName":null,"name":"@final_positions"},{"line":871,"containerName":null,"kind":13,"name":"$pos"},{"line":871,"name":"new","kind":12,"containerName":"main::"},{"kind":13,"containerName":null,"name":"$pos","line":871},{"line":871,"kind":12,"containerName":"main::","name":"start"},{"line":872,"name":"$pos","containerName":null,"kind":13},{"line":872,"name":"end","kind":12,"containerName":"main::"},{"line":873,"containerName":null,"kind":13,"name":"$pos"},{"line":873,"name":"relative","containerName":"main::","kind":12},{"containerName":null,"kind":13,"name":"$map","line":874},{"definition":"my","name":"$result","kind":13,"localvar":"my","containerName":null,"line":880},{"line":880,"kind":12,"containerName":"Map::Mappable","name":"Bio"},{"line":880,"kind":12,"containerName":"main::","name":"new"},{"name":"$result","containerName":null,"kind":13,"line":881},{"name":"add_position","containerName":"main::","kind":12,"line":881},{"containerName":null,"kind":13,"name":"@final_positions","line":881},{"name":"$result","kind":13,"containerName":null,"line":882},{"name":"_pre_rangei","containerName":"main::","children":[{"name":"$self","localvar":"my","containerName":"_pre_rangei","kind":13,"line":887,"definition":"my"},{"line":887,"name":"$other","kind":13,"containerName":"_pre_rangei"},{"line":887,"kind":13,"containerName":"_pre_rangei","name":"$rel"},{"line":888,"containerName":"_pre_rangei","kind":13,"name":"$self"},{"name":"throw","kind":12,"containerName":"_pre_rangei","line":888},{"line":888,"containerName":"_pre_rangei","kind":13,"name":"$other"},{"containerName":"_pre_rangei","kind":13,"name":"$rel","line":889},{"line":890,"kind":13,"containerName":"_pre_rangei","name":"$self"},{"line":890,"name":"throw","containerName":"_pre_rangei","kind":12},{"line":890,"containerName":"_pre_rangei","kind":13,"name":"$rel"},{"containerName":"_pre_rangei","kind":13,"name":"$self","line":891},{"name":"throw","kind":12,"containerName":"_pre_rangei","line":891},{"name":"$rel","containerName":"_pre_rangei","kind":13,"line":891},{"name":"isa","kind":12,"containerName":"_pre_rangei","line":891},{"definition":"my","line":894,"name":"$other_start","localvar":"my","containerName":"_pre_rangei","kind":13},{"containerName":"_pre_rangei","kind":13,"name":"$other_end","line":894},{"line":895,"name":"$other","containerName":"_pre_rangei","kind":13},{"containerName":"_pre_rangei","kind":13,"name":"$other","line":896},{"line":897,"name":"$self","kind":13,"containerName":"_pre_rangei"},{"kind":12,"containerName":"_pre_rangei","name":"throw","line":897},{"line":899,"kind":13,"containerName":"_pre_rangei","name":"$self"},{"name":"throw","containerName":"_pre_rangei","kind":12,"line":899},{"line":899,"containerName":"_pre_rangei","kind":13,"name":"$other"},{"line":899,"containerName":"_pre_rangei","kind":13,"name":"$other"},{"line":899,"kind":12,"containerName":"_pre_rangei","name":"isa"},{"containerName":"_pre_rangei","kind":13,"name":"$other","line":901},{"name":"isa","kind":12,"containerName":"_pre_rangei","line":901},{"localvar":"my","kind":13,"containerName":"_pre_rangei","name":"$other_map","line":907,"definition":"my"},{"containerName":"_pre_rangei","kind":13,"name":"$other","line":907},{"kind":12,"containerName":"_pre_rangei","name":"map","line":907},{"kind":13,"containerName":"_pre_rangei","name":"$other_map","line":908},{"definition":"my","line":909,"name":"$self_map","containerName":"_pre_rangei","localvar":"my","kind":13},{"line":909,"kind":13,"containerName":"_pre_rangei","name":"$self"},{"kind":12,"containerName":"_pre_rangei","name":"map","line":909},{"line":909,"name":"$self","kind":13,"containerName":"_pre_rangei"},{"line":909,"containerName":"_pre_rangei","kind":12,"name":"throw"},{"line":910,"kind":13,"containerName":"_pre_rangei","name":"$other"},{"line":910,"name":"map","kind":12,"containerName":"_pre_rangei"},{"name":"$self_map","kind":13,"containerName":"_pre_rangei","line":910},{"name":"$rel","kind":13,"containerName":"_pre_rangei","line":914},{"name":"$other","containerName":"_pre_rangei","kind":13,"line":914},{"line":914,"kind":12,"containerName":"_pre_rangei","name":"absolute_relative"},{"line":915,"kind":13,"containerName":"_pre_rangei","name":"$other_start"},{"line":915,"kind":13,"containerName":"_pre_rangei","name":"$other"},{"containerName":"_pre_rangei","kind":12,"name":"start","line":915},{"line":915,"kind":13,"containerName":"_pre_rangei","name":"$rel"},{"line":916,"containerName":"_pre_rangei","kind":13,"name":"$other_end"},{"line":916,"name":"$other","kind":13,"containerName":"_pre_rangei"},{"line":916,"name":"end","kind":12,"containerName":"_pre_rangei"},{"kind":13,"containerName":"_pre_rangei","name":"$rel","line":916},{"line":918,"kind":13,"containerName":"_pre_rangei","name":"$other_map"},{"line":919,"containerName":"_pre_rangei","kind":13,"name":"$self"},{"containerName":"_pre_rangei","kind":12,"name":"map","line":919},{"line":919,"kind":13,"containerName":"_pre_rangei","name":"$other"},{"kind":13,"containerName":"_pre_rangei","name":"$other_start","line":923},{"line":923,"name":"$other","containerName":"_pre_rangei","kind":13},{"containerName":"_pre_rangei","kind":12,"name":"start","line":923},{"line":924,"kind":13,"containerName":"_pre_rangei","name":"$other_end"},{"line":924,"name":"$other","containerName":"_pre_rangei","kind":13},{"name":"end","containerName":"_pre_rangei","kind":12,"line":924},{"containerName":"_pre_rangei","kind":13,"name":"$self","line":928},{"name":"throw","containerName":"_pre_rangei","kind":12,"line":928},{"name":"$other","kind":13,"containerName":"_pre_rangei","line":928},{"name":"$other_start","kind":13,"containerName":"_pre_rangei","line":929},{"line":929,"containerName":"_pre_rangei","kind":13,"name":"$other_end"},{"line":929,"kind":13,"containerName":"_pre_rangei","name":"$other"},{"containerName":"_pre_rangei","kind":13,"name":"$other","line":932},{"name":"throw","containerName":"_pre_rangei","kind":12,"line":932},{"name":"$other_start","kind":13,"containerName":"_pre_rangei","line":932},{"line":933,"containerName":"_pre_rangei","kind":13,"name":"$other"},{"line":933,"containerName":"_pre_rangei","kind":12,"name":"throw"},{"name":"$other_end","containerName":"_pre_rangei","kind":13,"line":933},{"line":935,"kind":13,"containerName":"_pre_rangei","name":"$other_start"},{"containerName":"_pre_rangei","kind":13,"name":"$other_end","line":935}],"detail":"($self,$other,$rel)","definition":"sub","kind":12,"range":{"end":{"character":9999,"line":936},"start":{"line":886,"character":0}},"line":886,"signature":{"label":"_pre_rangei($self,$other,$rel)","documentation":" get start & end suitable for rangeI methods, taking relative into account","parameters":[{"label":"$self"},{"label":"$other"},{"label":"$rel"}]}},{"line":919,"name":"purge_positions","kind":12},{"kind":12,"name":"looks_like_number","line":928}]}