{"vars":[{"name":"base","containerName":"","kind":2,"line":109},{"range":{"end":{"character":9999,"line":148},"start":{"line":137,"character":0}},"kind":12,"line":137,"signature":{"label":"new($class,@args)","documentation":"1;\n# $Id: GenePosition.pm,v 1.19 2006/09/20 10:20:01 sendu Exp $\n#\n# BioPerl module for Bio::Map::GenePosition\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::GenePosition - A typed position, suitable for modelling the various\n                         regions of a gene.\n\n=head1 SYNOPSIS\n\n    use Bio::Map::GenePosition;\n    use Bio::Map::GeneMap;\n\n    # say that the first transcript of a particular gene on a particular map\n    # (species) is 1000bp long\n    my $map = Bio::Map:GeneMap->get(-universal_name => 'BRCA2',\n                                    -species => 'human');\n    my $gene = $map->gene;\n    Bio::Map::GenePosition->new(-map => $map, \n                                -element => $gene,\n                                -start => 0,\n                                -length => 1000,\n                                -type => 'transcript');\n\n    # say that the coding region of the gene starts 30bp into the first\n    # transcript\n    Bio::Map::GenePosition->new(-map => $map, \n                                -element => $gene,\n                                -start => 30,\n                                -length => 600,\n                                -type => 'coding');\n\n    # A GenePosition isa PositionWithSequence, so can have sequence associated\n    # with it\n    my $exon = Bio::Map::GenePosition->new(-map => $map, \n                                -element => $gene,\n                                -start => 0,\n                                -type => 'exon',\n                                -seq => 'ATGGGGTGGG');\n    my $length = $exon->length; # $length is 10\n\n=head1 DESCRIPTION\n\nDefine where various sub-regions (transcripts, exons, introns etc.) of a gene\nare. Do this so that you can then go onto to model other mappable elements as\nhaving positions 20bp upstream of transcript 2, or 10bp into intron 3 etc., all\nwithout having to know the absolute position of anything.\n\nSee Bio::Map::GeneRelative and t/Map/Map.t for more example usage.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::GenePosition;\nuse strict;\n\nuse Bio::Map::GeneRelative;\n\nuse base qw(Bio::Map::PositionWithSequence);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Map::GenePosition->new();\n Function: Builds a new Bio::Map::GenePosition object \n Returns : Bio::Map::GenePosition\n Args    : -map      => Bio::Map::GeneMap object\n           -element  => Bio::Map::Gene object\n           -relative => Bio::Map::GeneRelative object\n           -type     => 'transcript|coding|exon|intron', REQUIRED\n           -seq      => string, length of this string will set the length\n                        of this position's range\n\n           * If this position has no range, or if a single value can describe\n             the range *\n           -value => scalar             : something that describes the single\n                                          point position or range of this\n                                          Position, most likely an int\n\n           * Or if this position has a range, at least two of *\n           -start => int                : value of the start co-ordinate\n           -end => int                  : value of the end co-ordinate\n           -length => int               : length of the range","parameters":[{"label":"$class"},{"label":"@args"}]},"containerName":"main::","name":"new","children":[{"line":138,"localvar":"my","containerName":"new","kind":13,"name":"$class","definition":"my"},{"line":138,"containerName":"new","kind":13,"name":"@args"},{"localvar":"my","containerName":"new","kind":13,"name":"$self","line":139,"definition":"my"},{"containerName":"new","kind":13,"name":"$class","line":139},{"name":"@args","containerName":"new","kind":13,"line":139},{"definition":"my","line":141,"localvar":"my","kind":13,"containerName":"new","name":"$type"},{"line":141,"kind":13,"containerName":"new","name":"$self"},{"kind":12,"containerName":"new","name":"_rearrange","line":141},{"line":141,"name":"@args","kind":13,"containerName":"new"},{"kind":13,"containerName":"new","name":"$type","line":142},{"name":"$self","containerName":"new","kind":13,"line":142},{"line":142,"name":"throw","containerName":"new","kind":12},{"line":143,"containerName":"new","kind":13,"name":"$self"},{"kind":12,"containerName":"new","name":"type","line":143},{"kind":13,"containerName":"new","name":"$type","line":143},{"name":"$self","containerName":"new","kind":13,"line":145},{"line":147,"name":"$self","containerName":"new","kind":13}],"detail":"($class,@args)","definition":"sub"},{"name":"SUPER","containerName":"new","kind":12,"line":139},{"line":145,"kind":12,"name":"_relative_not_implicit"},{"range":{"end":{"character":9999,"line":168},"start":{"line":162,"character":0}},"kind":12,"line":162,"signature":{"label":"map($self,$map)","documentation":"1;\n# $Id: GenePosition.pm,v 1.19 2006/09/20 10:20:01 sendu Exp $\n#\n# BioPerl module for Bio::Map::GenePosition\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::GenePosition - A typed position, suitable for modelling the various\n                         regions of a gene.\n\n=head1 SYNOPSIS\n\n    use Bio::Map::GenePosition;\n    use Bio::Map::GeneMap;\n\n    # say that the first transcript of a particular gene on a particular map\n    # (species) is 1000bp long\n    my $map = Bio::Map:GeneMap->get(-universal_name => 'BRCA2',\n                                    -species => 'human');\n    my $gene = $map->gene;\n    Bio::Map::GenePosition->new(-map => $map, \n                                -element => $gene,\n                                -start => 0,\n                                -length => 1000,\n                                -type => 'transcript');\n\n    # say that the coding region of the gene starts 30bp into the first\n    # transcript\n    Bio::Map::GenePosition->new(-map => $map, \n                                -element => $gene,\n                                -start => 30,\n                                -length => 600,\n                                -type => 'coding');\n\n    # A GenePosition isa PositionWithSequence, so can have sequence associated\n    # with it\n    my $exon = Bio::Map::GenePosition->new(-map => $map, \n                                -element => $gene,\n                                -start => 0,\n                                -type => 'exon',\n                                -seq => 'ATGGGGTGGG');\n    my $length = $exon->length; # $length is 10\n\n=head1 DESCRIPTION\n\nDefine where various sub-regions (transcripts, exons, introns etc.) of a gene\nare. Do this so that you can then go onto to model other mappable elements as\nhaving positions 20bp upstream of transcript 2, or 10bp into intron 3 etc., all\nwithout having to know the absolute position of anything.\n\nSee Bio::Map::GeneRelative and t/Map/Map.t for more example usage.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::GenePosition;\nuse strict;\n\nuse Bio::Map::GeneRelative;\n\nuse base qw(Bio::Map::PositionWithSequence);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Map::GenePosition->new();\n Function: Builds a new Bio::Map::GenePosition object \n Returns : Bio::Map::GenePosition\n Args    : -map      => Bio::Map::GeneMap object\n           -element  => Bio::Map::Gene object\n           -relative => Bio::Map::GeneRelative object\n           -type     => 'transcript|coding|exon|intron', REQUIRED\n           -seq      => string, length of this string will set the length\n                        of this position's range\n\n           * If this position has no range, or if a single value can describe\n             the range *\n           -value => scalar             : something that describes the single\n                                          point position or range of this\n                                          Position, most likely an int\n\n           * Or if this position has a range, at least two of *\n           -start => int                : value of the start co-ordinate\n           -end => int                  : value of the end co-ordinate\n           -length => int               : length of the range\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($type) = $self->_rearrange([qw( TYPE )], @args);\n\t$type || $self->throw(\"type must be supplied\");\n    $self->type($type);\n    \n    $self->{_relative_not_implicit} = 1;\n    \n    return $self;\n}\n\n=head2 map\n\n Title   : map\n Usage   : my $map = $position->map();\n           $position->map($map);\n Function: Get/set the map the position is in.\n Returns : L<Bio::Map::MapI>\n Args    : none to get\n           new L<Bio::Map::MapI> to set","parameters":[{"label":"$self"},{"label":"$map"}]},"containerName":"main::","name":"map","children":[{"localvar":"my","containerName":"map","kind":13,"name":"$self","line":163,"definition":"my"},{"name":"$map","containerName":"map","kind":13,"line":163},{"name":"$map","containerName":"map","kind":13,"line":164},{"containerName":"map","kind":13,"name":"$map","line":165},{"line":165,"name":"isa","containerName":"map","kind":12},{"name":"$self","kind":13,"containerName":"map","line":165},{"line":165,"name":"throw","kind":12,"containerName":"map"},{"name":"$self","kind":13,"containerName":"map","line":167},{"containerName":"map","kind":13,"name":"$map","line":167}],"detail":"($self,$map)","definition":"sub"},{"name":"SUPER","kind":12,"containerName":"map","line":167},{"detail":"($self,$element)","definition":"sub","name":"element","containerName":"main::","children":[{"line":183,"name":"$self","containerName":"element","localvar":"my","kind":13,"definition":"my"},{"line":183,"kind":13,"containerName":"element","name":"$element"},{"line":184,"name":"$element","kind":13,"containerName":"element"},{"name":"$element","kind":13,"containerName":"element","line":185},{"containerName":"element","kind":12,"name":"isa","line":185},{"containerName":"element","kind":13,"name":"$self","line":185},{"line":185,"name":"throw","containerName":"element","kind":12},{"line":187,"name":"$self","containerName":"element","kind":13},{"containerName":"element","kind":13,"name":"$element","line":187}],"signature":{"label":"element($self,$element)","documentation":"1;\n# $Id: GenePosition.pm,v 1.19 2006/09/20 10:20:01 sendu Exp $\n#\n# BioPerl module for Bio::Map::GenePosition\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::GenePosition - A typed position, suitable for modelling the various\n                         regions of a gene.\n\n=head1 SYNOPSIS\n\n    use Bio::Map::GenePosition;\n    use Bio::Map::GeneMap;\n\n    # say that the first transcript of a particular gene on a particular map\n    # (species) is 1000bp long\n    my $map = Bio::Map:GeneMap->get(-universal_name => 'BRCA2',\n                                    -species => 'human');\n    my $gene = $map->gene;\n    Bio::Map::GenePosition->new(-map => $map, \n                                -element => $gene,\n                                -start => 0,\n                                -length => 1000,\n                                -type => 'transcript');\n\n    # say that the coding region of the gene starts 30bp into the first\n    # transcript\n    Bio::Map::GenePosition->new(-map => $map, \n                                -element => $gene,\n                                -start => 30,\n                                -length => 600,\n                                -type => 'coding');\n\n    # A GenePosition isa PositionWithSequence, so can have sequence associated\n    # with it\n    my $exon = Bio::Map::GenePosition->new(-map => $map, \n                                -element => $gene,\n                                -start => 0,\n                                -type => 'exon',\n                                -seq => 'ATGGGGTGGG');\n    my $length = $exon->length; # $length is 10\n\n=head1 DESCRIPTION\n\nDefine where various sub-regions (transcripts, exons, introns etc.) of a gene\nare. Do this so that you can then go onto to model other mappable elements as\nhaving positions 20bp upstream of transcript 2, or 10bp into intron 3 etc., all\nwithout having to know the absolute position of anything.\n\nSee Bio::Map::GeneRelative and t/Map/Map.t for more example usage.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::GenePosition;\nuse strict;\n\nuse Bio::Map::GeneRelative;\n\nuse base qw(Bio::Map::PositionWithSequence);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Map::GenePosition->new();\n Function: Builds a new Bio::Map::GenePosition object \n Returns : Bio::Map::GenePosition\n Args    : -map      => Bio::Map::GeneMap object\n           -element  => Bio::Map::Gene object\n           -relative => Bio::Map::GeneRelative object\n           -type     => 'transcript|coding|exon|intron', REQUIRED\n           -seq      => string, length of this string will set the length\n                        of this position's range\n\n           * If this position has no range, or if a single value can describe\n             the range *\n           -value => scalar             : something that describes the single\n                                          point position or range of this\n                                          Position, most likely an int\n\n           * Or if this position has a range, at least two of *\n           -start => int                : value of the start co-ordinate\n           -end => int                  : value of the end co-ordinate\n           -length => int               : length of the range\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($type) = $self->_rearrange([qw( TYPE )], @args);\n\t$type || $self->throw(\"type must be supplied\");\n    $self->type($type);\n    \n    $self->{_relative_not_implicit} = 1;\n    \n    return $self;\n}\n\n=head2 map\n\n Title   : map\n Usage   : my $map = $position->map();\n           $position->map($map);\n Function: Get/set the map the position is in.\n Returns : L<Bio::Map::MapI>\n Args    : none to get\n           new L<Bio::Map::MapI> to set\n\n\nsub map {\n    my ($self, $map) = @_;\n    if ($map) {\n        $map->isa('Bio::Map::GeneMap') || $self->throw(\"This is [$map], not a Bio::Map::GeneMap\");\n    }\n    return $self->SUPER::map($map);\n}\n\n=head2 element\n\n Title   : element\n Usage   : my $element = $position->element();\n           $position->element($element);\n Function: Get/set the element the position is for.\n Returns : L<Bio::Map::MappableI>\n Args    : none to get\n           new L<Bio::Map::MappableI> to set","parameters":[{"label":"$self"},{"label":"$element"}]},"range":{"end":{"line":188,"character":9999},"start":{"line":182,"character":0}},"kind":12,"line":182},{"containerName":"element","kind":12,"name":"SUPER","line":187},{"children":[{"name":"$self","containerName":"type","localvar":"my","kind":13,"line":203,"definition":"my"},{"line":205,"localvar":"my","containerName":"type","kind":13,"name":"$type","definition":"my"},{"name":"$type","kind":13,"containerName":"type","line":206},{"containerName":"type","kind":13,"name":"$self","line":207},{"line":207,"kind":12,"containerName":"type","name":"throw"},{"line":209,"containerName":"type","kind":13,"name":"$self"},{"name":"$type","containerName":"type","kind":13,"line":209},{"line":211,"name":"$self","kind":13,"containerName":"type"}],"containerName":"main::","name":"type","definition":"sub","line":202,"kind":12,"range":{"start":{"character":0,"line":202},"end":{"character":9999,"line":212}}},{"name":"type","kind":12,"line":209},{"name":"type","kind":12,"line":211},{"children":[{"line":233,"localvar":"my","kind":13,"containerName":"relative","name":"$self","definition":"my"},{"name":"$relative","containerName":"relative","kind":13,"line":233},{"name":"$relative","kind":13,"containerName":"relative","line":234},{"kind":13,"containerName":"relative","name":"$self","line":235},{"line":235,"name":"throw","containerName":"relative","kind":12},{"name":"$relative","containerName":"relative","kind":13,"line":235},{"line":236,"kind":13,"containerName":"relative","name":"$self"},{"name":"throw","kind":12,"containerName":"relative","line":236},{"kind":13,"containerName":"relative","name":"$relative","line":236},{"line":236,"containerName":"relative","kind":12,"name":"isa"},{"containerName":"relative","kind":13,"name":"$self","line":237},{"kind":13,"containerName":"relative","name":"$relative","line":237},{"name":"$self","containerName":"relative","kind":13,"line":239},{"kind":13,"containerName":"relative","name":"$self","line":239},{"containerName":"relative","kind":12,"name":"_default_relative","line":239}],"name":"relative","containerName":"main::","definition":"sub","detail":"($self,$relative)","line":232,"kind":12,"range":{"start":{"line":232,"character":0},"end":{"line":240,"character":9999}},"signature":{"parameters":[{"label":"$self"},{"label":"$relative"}],"documentation":"1;\n# $Id: GenePosition.pm,v 1.19 2006/09/20 10:20:01 sendu Exp $\n#\n# BioPerl module for Bio::Map::GenePosition\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::GenePosition - A typed position, suitable for modelling the various\n                         regions of a gene.\n\n=head1 SYNOPSIS\n\n    use Bio::Map::GenePosition;\n    use Bio::Map::GeneMap;\n\n    # say that the first transcript of a particular gene on a particular map\n    # (species) is 1000bp long\n    my $map = Bio::Map:GeneMap->get(-universal_name => 'BRCA2',\n                                    -species => 'human');\n    my $gene = $map->gene;\n    Bio::Map::GenePosition->new(-map => $map, \n                                -element => $gene,\n                                -start => 0,\n                                -length => 1000,\n                                -type => 'transcript');\n\n    # say that the coding region of the gene starts 30bp into the first\n    # transcript\n    Bio::Map::GenePosition->new(-map => $map, \n                                -element => $gene,\n                                -start => 30,\n                                -length => 600,\n                                -type => 'coding');\n\n    # A GenePosition isa PositionWithSequence, so can have sequence associated\n    # with it\n    my $exon = Bio::Map::GenePosition->new(-map => $map, \n                                -element => $gene,\n                                -start => 0,\n                                -type => 'exon',\n                                -seq => 'ATGGGGTGGG');\n    my $length = $exon->length; # $length is 10\n\n=head1 DESCRIPTION\n\nDefine where various sub-regions (transcripts, exons, introns etc.) of a gene\nare. Do this so that you can then go onto to model other mappable elements as\nhaving positions 20bp upstream of transcript 2, or 10bp into intron 3 etc., all\nwithout having to know the absolute position of anything.\n\nSee Bio::Map::GeneRelative and t/Map/Map.t for more example usage.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::GenePosition;\nuse strict;\n\nuse Bio::Map::GeneRelative;\n\nuse base qw(Bio::Map::PositionWithSequence);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Map::GenePosition->new();\n Function: Builds a new Bio::Map::GenePosition object \n Returns : Bio::Map::GenePosition\n Args    : -map      => Bio::Map::GeneMap object\n           -element  => Bio::Map::Gene object\n           -relative => Bio::Map::GeneRelative object\n           -type     => 'transcript|coding|exon|intron', REQUIRED\n           -seq      => string, length of this string will set the length\n                        of this position's range\n\n           * If this position has no range, or if a single value can describe\n             the range *\n           -value => scalar             : something that describes the single\n                                          point position or range of this\n                                          Position, most likely an int\n\n           * Or if this position has a range, at least two of *\n           -start => int                : value of the start co-ordinate\n           -end => int                  : value of the end co-ordinate\n           -length => int               : length of the range\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($type) = $self->_rearrange([qw( TYPE )], @args);\n\t$type || $self->throw(\"type must be supplied\");\n    $self->type($type);\n    \n    $self->{_relative_not_implicit} = 1;\n    \n    return $self;\n}\n\n=head2 map\n\n Title   : map\n Usage   : my $map = $position->map();\n           $position->map($map);\n Function: Get/set the map the position is in.\n Returns : L<Bio::Map::MapI>\n Args    : none to get\n           new L<Bio::Map::MapI> to set\n\n\nsub map {\n    my ($self, $map) = @_;\n    if ($map) {\n        $map->isa('Bio::Map::GeneMap') || $self->throw(\"This is [$map], not a Bio::Map::GeneMap\");\n    }\n    return $self->SUPER::map($map);\n}\n\n=head2 element\n\n Title   : element\n Usage   : my $element = $position->element();\n           $position->element($element);\n Function: Get/set the element the position is for.\n Returns : L<Bio::Map::MappableI>\n Args    : none to get\n           new L<Bio::Map::MappableI> to set\n\n\nsub element {\n    my ($self, $element) = @_;\n    if ($element) {\n        $element->isa('Bio::Map::Gene') || $self->throw(\"This is [$element], not a Bio::Map::Gene\");\n    }\n    return $self->SUPER::element($element);\n}\n\n=head2 type\n\n Title   : type\n Usage   : my $type = $position->type();\n           $position->type($type);\n Function: Get/set the type of this position.\n Returns : string\n Args    : none to get, OR\n           string transcript|coding|exon|intron to set\n\n\nsub type {\n    my $self = shift;\n    if (@_) {\n        my $type = shift;\n        if ($type !~ /transcript|coding|exon|intron/i) {\n            $self->throw(\"type must be supplied and be one of 'transcript', 'coding', 'exon', 'intron'\");\n        }\n        $self->{type} = $type;\n    }\n    return $self->{type};\n}\n\n=head2 relative\n\n  Title   : relative\n  Usage   : my $relative = $position->relative();\n            $position->relative($relative);\n  Function: Get/set the thing this Position's coordinates (numerical(), start(),\n            end()) are relative to, as described by a RelativeI object.\n  Returns : Bio::Map::GeneRelative. The default GeneRelative returned has a\n            meaning that depends on the type() of GenePosition this is:\n            'transcript'         : \"relative to the start of the gene on the\n                                    Position's map\"\n            'coding|exon|intron' : \"relative to the start of the default\n                                    transcript of the gene on the Position's map\"\n  Args    : none to get, OR\n            Bio::Map::GeneRelative to set","label":"relative($self,$relative)"}},{"line":237,"kind":12,"name":"_relative"},{"line":239,"name":"_relative","kind":12},{"signature":{"documentation":"1;\n# $Id: GenePosition.pm,v 1.19 2006/09/20 10:20:01 sendu Exp $\n#\n# BioPerl module for Bio::Map::GenePosition\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::GenePosition - A typed position, suitable for modelling the various\n                         regions of a gene.\n\n=head1 SYNOPSIS\n\n    use Bio::Map::GenePosition;\n    use Bio::Map::GeneMap;\n\n    # say that the first transcript of a particular gene on a particular map\n    # (species) is 1000bp long\n    my $map = Bio::Map:GeneMap->get(-universal_name => 'BRCA2',\n                                    -species => 'human');\n    my $gene = $map->gene;\n    Bio::Map::GenePosition->new(-map => $map, \n                                -element => $gene,\n                                -start => 0,\n                                -length => 1000,\n                                -type => 'transcript');\n\n    # say that the coding region of the gene starts 30bp into the first\n    # transcript\n    Bio::Map::GenePosition->new(-map => $map, \n                                -element => $gene,\n                                -start => 30,\n                                -length => 600,\n                                -type => 'coding');\n\n    # A GenePosition isa PositionWithSequence, so can have sequence associated\n    # with it\n    my $exon = Bio::Map::GenePosition->new(-map => $map, \n                                -element => $gene,\n                                -start => 0,\n                                -type => 'exon',\n                                -seq => 'ATGGGGTGGG');\n    my $length = $exon->length; # $length is 10\n\n=head1 DESCRIPTION\n\nDefine where various sub-regions (transcripts, exons, introns etc.) of a gene\nare. Do this so that you can then go onto to model other mappable elements as\nhaving positions 20bp upstream of transcript 2, or 10bp into intron 3 etc., all\nwithout having to know the absolute position of anything.\n\nSee Bio::Map::GeneRelative and t/Map/Map.t for more example usage.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::GenePosition;\nuse strict;\n\nuse Bio::Map::GeneRelative;\n\nuse base qw(Bio::Map::PositionWithSequence);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Map::GenePosition->new();\n Function: Builds a new Bio::Map::GenePosition object \n Returns : Bio::Map::GenePosition\n Args    : -map      => Bio::Map::GeneMap object\n           -element  => Bio::Map::Gene object\n           -relative => Bio::Map::GeneRelative object\n           -type     => 'transcript|coding|exon|intron', REQUIRED\n           -seq      => string, length of this string will set the length\n                        of this position's range\n\n           * If this position has no range, or if a single value can describe\n             the range *\n           -value => scalar             : something that describes the single\n                                          point position or range of this\n                                          Position, most likely an int\n\n           * Or if this position has a range, at least two of *\n           -start => int                : value of the start co-ordinate\n           -end => int                  : value of the end co-ordinate\n           -length => int               : length of the range\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($type) = $self->_rearrange([qw( TYPE )], @args);\n\t$type || $self->throw(\"type must be supplied\");\n    $self->type($type);\n    \n    $self->{_relative_not_implicit} = 1;\n    \n    return $self;\n}\n\n=head2 map\n\n Title   : map\n Usage   : my $map = $position->map();\n           $position->map($map);\n Function: Get/set the map the position is in.\n Returns : L<Bio::Map::MapI>\n Args    : none to get\n           new L<Bio::Map::MapI> to set\n\n\nsub map {\n    my ($self, $map) = @_;\n    if ($map) {\n        $map->isa('Bio::Map::GeneMap') || $self->throw(\"This is [$map], not a Bio::Map::GeneMap\");\n    }\n    return $self->SUPER::map($map);\n}\n\n=head2 element\n\n Title   : element\n Usage   : my $element = $position->element();\n           $position->element($element);\n Function: Get/set the element the position is for.\n Returns : L<Bio::Map::MappableI>\n Args    : none to get\n           new L<Bio::Map::MappableI> to set\n\n\nsub element {\n    my ($self, $element) = @_;\n    if ($element) {\n        $element->isa('Bio::Map::Gene') || $self->throw(\"This is [$element], not a Bio::Map::Gene\");\n    }\n    return $self->SUPER::element($element);\n}\n\n=head2 type\n\n Title   : type\n Usage   : my $type = $position->type();\n           $position->type($type);\n Function: Get/set the type of this position.\n Returns : string\n Args    : none to get, OR\n           string transcript|coding|exon|intron to set\n\n\nsub type {\n    my $self = shift;\n    if (@_) {\n        my $type = shift;\n        if ($type !~ /transcript|coding|exon|intron/i) {\n            $self->throw(\"type must be supplied and be one of 'transcript', 'coding', 'exon', 'intron'\");\n        }\n        $self->{type} = $type;\n    }\n    return $self->{type};\n}\n\n=head2 relative\n\n  Title   : relative\n  Usage   : my $relative = $position->relative();\n            $position->relative($relative);\n  Function: Get/set the thing this Position's coordinates (numerical(), start(),\n            end()) are relative to, as described by a RelativeI object.\n  Returns : Bio::Map::GeneRelative. The default GeneRelative returned has a\n            meaning that depends on the type() of GenePosition this is:\n            'transcript'         : \"relative to the start of the gene on the\n                                    Position's map\"\n            'coding|exon|intron' : \"relative to the start of the default\n                                    transcript of the gene on the Position's map\"\n  Args    : none to get, OR\n            Bio::Map::GeneRelative to set\n\n\nsub relative {\n    my ($self, $relative) = @_;\n    if ($relative) {\n        $self->throw(\"Must supply an object\") unless ref($relative);\n        $self->throw(\"This is [$relative], not a Bio::Map::GeneRelative\") unless $relative->isa('Bio::Map::GeneRelative');\n        $self->{_relative} = $relative;\n    }\n    return $self->{_relative} || $self->_default_relative;\n}\n\n=head2 seq\n\n Title   : seq\n Usage   : my $string = $position->seq();\n Function: Get/set the sequence as a string of letters. If no sequence is\n           manually set by you, the position's map will be asked for the\n           sequence, and if available, that will be returned.\n Returns : scalar\n Args    : Optionally on set the new value (a string). An optional second\n           argument presets the alphabet (otherwise it will be guessed).","parameters":[{"label":"$self"},{"label":"$str"},{"label":"$alpha"},{"label":"$shortcut"}],"label":"seq($self,$str,$alpha,$shortcut)"},"kind":12,"range":{"end":{"line":272,"character":9999},"start":{"line":255,"character":0}},"line":255,"detail":"($self,$str,$alpha,$shortcut)","definition":"sub","containerName":"main::","name":"seq","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"seq","line":257},{"line":257,"name":"$str","containerName":"seq","kind":13},{"containerName":"seq","kind":13,"name":"$alpha","line":257},{"name":"$shortcut","kind":13,"containerName":"seq","line":257},{"name":"$seq","kind":13,"localvar":"my","containerName":"seq","line":259,"definition":"my"},{"line":259,"name":"$self","containerName":"seq","kind":13},{"line":259,"name":"$str","containerName":"seq","kind":13},{"line":259,"name":"$alpha","kind":13,"containerName":"seq"},{"line":261,"containerName":"seq","kind":13,"name":"$seq"},{"name":"$self","kind":13,"containerName":"seq","line":262},{"line":262,"name":"length","kind":12,"containerName":"seq"},{"line":262,"containerName":"seq","kind":13,"name":"$seq"},{"kind":13,"containerName":"seq","name":"$seq","line":263},{"name":"$shortcut","containerName":"seq","kind":13,"line":265},{"line":265,"localvar":"my","containerName":"seq","kind":13,"name":"$map","definition":"my"},{"containerName":"seq","kind":13,"name":"$self","line":265},{"line":265,"name":"map","kind":12,"containerName":"seq"},{"line":265,"name":"$self","containerName":"seq","kind":13},{"name":"$self","kind":13,"containerName":"seq","line":266},{"line":267,"containerName":"seq","kind":13,"name":"$seq"},{"name":"$map","containerName":"seq","kind":13,"line":267},{"name":"subseq","kind":12,"containerName":"seq","line":267},{"containerName":"seq","kind":13,"name":"$self","line":267},{"name":"$self","kind":13,"containerName":"seq","line":268},{"name":"$seq","containerName":"seq","kind":13,"line":269}]},{"line":259,"name":"SUPER","containerName":"seq","kind":12},{"name":"CORE","containerName":"length","kind":12,"line":262},{"line":265,"kind":12,"name":"_getting_seq"},{"line":266,"name":"_getting_seq","kind":12},{"kind":12,"name":"_getting_seq","line":268},{"line":275,"range":{"start":{"character":0,"line":275},"end":{"character":9999,"line":284}},"kind":12,"children":[{"kind":13,"localvar":"my","containerName":"_default_relative","name":"$self","line":276,"definition":"my"},{"definition":"my","localvar":"my","kind":13,"containerName":"_default_relative","name":"$type","line":277},{"line":277,"name":"$self","kind":13,"containerName":"_default_relative"},{"line":277,"name":"type","kind":12,"containerName":"_default_relative"},{"kind":13,"containerName":"_default_relative","name":"$type","line":278},{"line":279,"kind":12,"containerName":"_default_relative","name":"new"},{"containerName":"_default_relative","kind":12,"name":"new","line":282}],"name":"_default_relative","containerName":"main::","definition":"sub"},{"line":279,"name":"Bio","kind":12,"containerName":"Map::GeneRelative"},{"name":"Bio","containerName":"Map::GeneRelative","kind":12,"line":282}],"version":5}