{"vars":[{"line":128,"kind":2,"containerName":"","name":"base"},{"definition":"our","line":130,"kind":13,"containerName":"main::","name":"%GENEMAPS"},{"line":157,"kind":12,"range":{"start":{"line":157,"character":0},"end":{"character":9999,"line":183}},"signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: GeneMap.pm,v 1.17 2006/07/17 14:16:53 sendu Exp $\n#\n# BioPerl module for Bio::Map::GeneMap\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::GeneMap - A MapI implementation to represent the area around a gene\n\n=head1 SYNOPSIS\n\n    use Bio::Map::GeneMap;\n    use Bio::Map::Gene;\n    use Bio::Map::TranscriptionFactor;\n    use Bio::Map::GeneRelative;\n\n\t# make some maps that will represent an area around a particular gene in\n\t# particular species (by default, the map represents the area in the genome\n    # 1000bp upstream of the gene)\n    my $map1 = Bio::Map::GeneMap->get(-gene => 'BRCA2',\n                                      -species => 'human',\n                                      -description => 'breast cancer 2, early onset');\n\tmy $map2 = Bio::Map::GeneMap->get(-gene => 'BRCA2',\n                                      -species => 'mouse');\n\n\t# model a TF that binds 500bp upstream of the BRCA2 gene in humans and\n\t# 250bp upstream of BRCA2 in mice\n\tmy $rel = Bio::Map::GeneRelative->new(-description => \"gene start\");\n    my $tf = Bio::Map::TranscriptionFactor->get(-universal_name => 'tf1');\n\tBio::Map::Position->new(-map => $map1,\n                            -element => $tf,\n                            -start => -500,\n                            -length => 10,\n                            -relative => $rel);\n\tBio::Map::Position->new(-map => $map2,\n                            -element => $tf,\n                            -start => -250,\n                            -length => 10,\n                            -relative => $rel);\n\n\t# find out all the things that map near BRCA2 in all species\n\tforeach my $map ($gene->known_maps) {\n\t\tforeach my $thing ($map->get_elements) {\n            next if $thing eq $gene;\n            foreach my $pos ($thing->get_positions($map)) {\n                print \"In species \", $map->species, \", \",\n                      $thing->universal_name, \" maps at \", $pos->value,\n                      \" relative to \", $pos->relative->description, \" of gene \",\n                      $gene->universal_name, \"\\n\";\n            }\n\t\t}\n\t}\n    \n    # a GeneMap isa PrimarySeq and so can have sequence associated with it\n    $map1->seq('ATGC');\n    my $subseq = $map1->subseq(2,3); # TG\n\n=head1 DESCRIPTION\n\nModel the abstract notion of the area around a gene - you don't care exactly\nwhere this area is in the genome, you just want to be able to say \"something\nbinds upstream of gene X\" and \"something else binds 20bp upstream of the first\nsomething\" etc.\n\nIt's useful for modelling transcription factor bindings sites, letting you find\nout which transcription factors bind near a gene of interest, or which genes\nare bound by a transcription factor of interest.\n\nSee t/Map/Map.t for more example usage.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::GeneMap;\nuse strict;\n\nuse Bio::Map::Gene;\nuse Bio::Map::Position;\n\nuse base qw(Bio::Map::SimpleMap Bio::PrimarySeq);\n\nour $GENEMAPS = {};\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Map::GeneMap->new();\n Function: Builds a new Bio::Map::GeneMap object (that has placed on it a\n           mappable element (Bio::Map::Gene) representing a gene).\n Returns : Bio::Map::GeneMap\n Args    : -gene        => string name of the gene this map will be for\n                           (in a form common to all species that have the gene,\n                           but unique amongst non-orthologous genes) or a\n                           Bio::Map::Gene object, REQUIRED\n           -species     => Bio::Taxon or string representing species, REQUIRED\n           -uid         => string, unique identifier for this map (must be\n                           unique amongst all gene/species combinations)\n           -description => string, free text description of the gene\n           -upstream    => int, the number of bases the map extends before the\n                           start of the gene element (default 1000).\n           -downstream  => int, the number of bases the map extends beyond the\n                           end of the gene element (default 0).\n           -seq         => string, the sequence of the map, presumably the\n                           genomic sequence -upstream bases of the gene,\n                           including the gene, and -downstream bases of the gene"},"children":[{"line":158,"name":"$class","localvar":"my","containerName":"new","kind":13,"definition":"my"},{"line":158,"name":"@args","kind":13,"containerName":"new"},{"name":"$self","localvar":"my","containerName":"new","kind":13,"line":159,"definition":"my"},{"line":159,"name":"$class","containerName":"new","kind":13},{"line":159,"kind":13,"containerName":"new","name":"@args"},{"line":161,"localvar":"my","kind":13,"containerName":"new","name":"$uid","definition":"my"},{"line":161,"kind":13,"containerName":"new","name":"$gene"},{"line":161,"kind":13,"containerName":"new","name":"$species"},{"line":161,"kind":13,"containerName":"new","name":"$desc"},{"line":161,"name":"$up","kind":13,"containerName":"new"},{"name":"$down","kind":13,"containerName":"new","line":161},{"line":161,"name":"$seq","containerName":"new","kind":13},{"name":"$self","kind":13,"containerName":"new","line":161},{"name":"_rearrange","containerName":"new","kind":12,"line":161},{"containerName":"new","kind":13,"name":"@args","line":167},{"line":169,"containerName":"new","kind":13,"name":"$gene"},{"line":169,"containerName":"new","kind":13,"name":"$species"},{"line":170,"name":"$self","kind":13,"containerName":"new"},{"line":170,"kind":12,"containerName":"new","name":"throw"},{"line":173,"kind":13,"containerName":"new","name":"$self"},{"kind":12,"containerName":"new","name":"gene","line":173},{"kind":13,"containerName":"new","name":"$gene","line":173},{"line":173,"kind":13,"containerName":"new","name":"$desc"},{"line":173,"name":"$up","containerName":"new","kind":13},{"name":"$down","kind":13,"containerName":"new","line":173},{"line":174,"name":"$self","kind":13,"containerName":"new"},{"line":174,"containerName":"new","kind":12,"name":"seq"},{"kind":13,"containerName":"new","name":"$seq","line":174},{"line":174,"kind":13,"containerName":"new","name":"$seq"},{"line":176,"containerName":"new","kind":13,"name":"$uid"},{"name":"$self","containerName":"new","kind":13,"line":179},{"name":"unique_id","kind":12,"containerName":"new","line":179},{"containerName":"new","kind":13,"name":"$self","line":179},{"line":179,"kind":12,"containerName":"new","name":"unique_id"},{"kind":13,"containerName":"new","name":"$self","line":182}],"containerName":"main::","name":"new","definition":"sub","detail":"($class,@args)"},{"kind":12,"containerName":"new","name":"SUPER","line":159},{"definition":"sub","detail":"($class,@args)","children":[{"definition":"my","localvar":"my","containerName":"get","kind":13,"name":"$class","line":218},{"name":"@args","containerName":"get","kind":13,"line":218},{"definition":"my","containerName":"get","localvar":"my","kind":13,"name":"$uid","line":219},{"line":219,"name":"$gene","kind":13,"containerName":"get"},{"line":219,"name":"$species","containerName":"get","kind":13},{"containerName":"get","kind":13,"name":"$desc","line":219},{"line":219,"containerName":"get","kind":13,"name":"$up"},{"containerName":"get","kind":13,"name":"$down","line":219},{"line":219,"kind":13,"containerName":"get","name":"$seq"},{"line":219,"name":"_rearrange","kind":12,"containerName":"get"},{"name":"@args","containerName":"get","kind":13,"line":225},{"line":227,"containerName":"get","localvar":"my","kind":13,"name":"$gene_map","definition":"my"},{"containerName":"get","kind":13,"name":"$uid","line":228},{"name":"$GENEMAPS","kind":13,"containerName":"get","line":228},{"name":"$uid","containerName":"get","kind":13,"line":228},{"line":229,"kind":13,"containerName":"get","name":"$gene_map"},{"line":229,"kind":13,"containerName":"get","name":"$GENEMAPS"},{"name":"$uid","containerName":"get","kind":13,"line":229},{"containerName":"get","kind":13,"name":"$gene","line":231},{"line":231,"containerName":"get","kind":13,"name":"$species"},{"definition":"my","line":232,"name":"$name","containerName":"get","localvar":"my","kind":13},{"name":"$gene","kind":13,"containerName":"get","line":232},{"name":"$gene","kind":13,"containerName":"get","line":232},{"kind":12,"containerName":"get","name":"universal_name","line":232},{"name":"$gene","containerName":"get","kind":13,"line":232},{"containerName":"get","kind":13,"name":"$GENEMAPS","line":233},{"name":"$name","containerName":"get","kind":13,"line":233},{"name":"$species","kind":13,"containerName":"get","line":233},{"containerName":"get","kind":13,"name":"$gene_map","line":234},{"name":"$GENEMAPS","kind":13,"containerName":"get","line":234},{"name":"$name","containerName":"get","kind":13,"line":234},{"line":234,"containerName":"get","kind":13,"name":"$species"},{"line":237,"kind":13,"containerName":"get","name":"$gene_map"},{"line":238,"kind":13,"containerName":"get","name":"$gene_map"},{"name":"gene","containerName":"get","kind":12,"line":238},{"name":"description","kind":12,"containerName":"get","line":238},{"line":238,"kind":13,"containerName":"get","name":"$desc"},{"name":"$desc","kind":13,"containerName":"get","line":238},{"name":"$gene_map","kind":13,"containerName":"get","line":239},{"name":"upstream","kind":12,"containerName":"get","line":239},{"name":"$up","containerName":"get","kind":13,"line":239},{"line":239,"name":"$up","containerName":"get","kind":13},{"kind":13,"containerName":"get","name":"$gene_map","line":240},{"name":"downstream","kind":12,"containerName":"get","line":240},{"containerName":"get","kind":13,"name":"$down","line":240},{"line":240,"name":"$down","containerName":"get","kind":13},{"line":241,"name":"$gene_map","containerName":"get","kind":13},{"name":"seq","containerName":"get","kind":12,"line":241},{"line":241,"name":"$seq","containerName":"get","kind":13},{"line":241,"name":"$seq","containerName":"get","kind":13},{"line":242,"containerName":"get","kind":13,"name":"$gene_map"},{"kind":13,"containerName":"get","name":"$class","line":245},{"line":245,"containerName":"get","kind":12,"name":"new"},{"line":245,"containerName":"get","kind":13,"name":"@args"}],"name":"get","containerName":"main::","signature":{"documentation":"1;\n# $Id: GeneMap.pm,v 1.17 2006/07/17 14:16:53 sendu Exp $\n#\n# BioPerl module for Bio::Map::GeneMap\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::GeneMap - A MapI implementation to represent the area around a gene\n\n=head1 SYNOPSIS\n\n    use Bio::Map::GeneMap;\n    use Bio::Map::Gene;\n    use Bio::Map::TranscriptionFactor;\n    use Bio::Map::GeneRelative;\n\n\t# make some maps that will represent an area around a particular gene in\n\t# particular species (by default, the map represents the area in the genome\n    # 1000bp upstream of the gene)\n    my $map1 = Bio::Map::GeneMap->get(-gene => 'BRCA2',\n                                      -species => 'human',\n                                      -description => 'breast cancer 2, early onset');\n\tmy $map2 = Bio::Map::GeneMap->get(-gene => 'BRCA2',\n                                      -species => 'mouse');\n\n\t# model a TF that binds 500bp upstream of the BRCA2 gene in humans and\n\t# 250bp upstream of BRCA2 in mice\n\tmy $rel = Bio::Map::GeneRelative->new(-description => \"gene start\");\n    my $tf = Bio::Map::TranscriptionFactor->get(-universal_name => 'tf1');\n\tBio::Map::Position->new(-map => $map1,\n                            -element => $tf,\n                            -start => -500,\n                            -length => 10,\n                            -relative => $rel);\n\tBio::Map::Position->new(-map => $map2,\n                            -element => $tf,\n                            -start => -250,\n                            -length => 10,\n                            -relative => $rel);\n\n\t# find out all the things that map near BRCA2 in all species\n\tforeach my $map ($gene->known_maps) {\n\t\tforeach my $thing ($map->get_elements) {\n            next if $thing eq $gene;\n            foreach my $pos ($thing->get_positions($map)) {\n                print \"In species \", $map->species, \", \",\n                      $thing->universal_name, \" maps at \", $pos->value,\n                      \" relative to \", $pos->relative->description, \" of gene \",\n                      $gene->universal_name, \"\\n\";\n            }\n\t\t}\n\t}\n    \n    # a GeneMap isa PrimarySeq and so can have sequence associated with it\n    $map1->seq('ATGC');\n    my $subseq = $map1->subseq(2,3); # TG\n\n=head1 DESCRIPTION\n\nModel the abstract notion of the area around a gene - you don't care exactly\nwhere this area is in the genome, you just want to be able to say \"something\nbinds upstream of gene X\" and \"something else binds 20bp upstream of the first\nsomething\" etc.\n\nIt's useful for modelling transcription factor bindings sites, letting you find\nout which transcription factors bind near a gene of interest, or which genes\nare bound by a transcription factor of interest.\n\nSee t/Map/Map.t for more example usage.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::GeneMap;\nuse strict;\n\nuse Bio::Map::Gene;\nuse Bio::Map::Position;\n\nuse base qw(Bio::Map::SimpleMap Bio::PrimarySeq);\n\nour $GENEMAPS = {};\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Map::GeneMap->new();\n Function: Builds a new Bio::Map::GeneMap object (that has placed on it a\n           mappable element (Bio::Map::Gene) representing a gene).\n Returns : Bio::Map::GeneMap\n Args    : -gene        => string name of the gene this map will be for\n                           (in a form common to all species that have the gene,\n                           but unique amongst non-orthologous genes) or a\n                           Bio::Map::Gene object, REQUIRED\n           -species     => Bio::Taxon or string representing species, REQUIRED\n           -uid         => string, unique identifier for this map (must be\n                           unique amongst all gene/species combinations)\n           -description => string, free text description of the gene\n           -upstream    => int, the number of bases the map extends before the\n                           start of the gene element (default 1000).\n           -downstream  => int, the number of bases the map extends beyond the\n                           end of the gene element (default 0).\n           -seq         => string, the sequence of the map, presumably the\n                           genomic sequence -upstream bases of the gene,\n                           including the gene, and -downstream bases of the gene\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($uid, $gene, $species, $desc, $up, $down, $seq) = $self->_rearrange([qw(UID\n                                                    GENE\n                                                    SPECIES\n                                                    DESCRIPTION\n                                                    UPSTREAM\n                                                    DOWNSTREAM\n                                                    SEQ)], @args);\n    \n    unless (defined $gene && defined $species) {\n        $self->throw(\"You must supply both -species and -gene\");\n    }\n    \n    $self->gene(-gene => $gene, -description => $desc, -upstream => $up, -downstream => $down);\n    $self->seq($seq) if $seq;\n    \n    unless (defined($uid)) {\n        # trigger the special behaviour in our unique_id method by supplying it\n        # the unique_id we got from our parent class\n        $self->unique_id($self->unique_id);\n    }\n    \n    return $self;\n}\n\n=head2 get\n\n Title   : get\n Usage   : my $map = Bio::Map::GeneMap->get();\n Function: Builds a new Bio::Map::GeneMap object (like new()), or gets a\n           pre-existing one that corresponds to your arguements.\n Returns : Bio::Map::GeneMap\n Args    : -gene        => string name of the gene this map will be for\n                           (in a form common to all species that have the gene,\n                           but unique amongst non-orthologous genes) or a\n                           Bio::Map::Gene object, REQUIRED\n           -species     => Bio::Taxon or string representing species, REQUIRED\n           -uid         => string, unique identifier for this map (must be\n                           unique amongst all gene/species combinations)\n           -description => string, free text description of the gene\n           -upstream    => int, the number of bases the map extends before the\n                           start of the gene element (default 1000).\n           -downstream  => int, the number of bases the map extends beyond the\n                           end of the gene element (default 0).\n           -seq         => string, the sequence of the map, presumably the\n                           genomic sequence -upstream bases of the gene,\n                           including the gene, and -downstream bases of the gene\n\n           If you supply a -uid, and a map had previously been created and\n           given that uid, that same map object will be returned. Otherwise, the\n           combination of -gene and -species will be used to determine\n           if the same map had previously been made. If a corresponding map\n           hadn't previously been made, a new map object will be created and\n           returned.","parameters":[{"label":"$class"},{"label":"@args"}],"label":"get($class,@args)"},"line":217,"range":{"end":{"character":9999,"line":246},"start":{"character":0,"line":217}},"kind":12},{"kind":12,"containerName":"Root::Root","name":"Bio","line":219},{"name":"by_uid","kind":12,"line":228},{"line":229,"name":"by_uid","kind":12},{"kind":12,"name":"by_ns","line":233},{"name":"by_ns","kind":12,"line":234},{"signature":{"parameters":[{"label":"$self"},{"label":"$id"}],"documentation":"1;\n# $Id: GeneMap.pm,v 1.17 2006/07/17 14:16:53 sendu Exp $\n#\n# BioPerl module for Bio::Map::GeneMap\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::GeneMap - A MapI implementation to represent the area around a gene\n\n=head1 SYNOPSIS\n\n    use Bio::Map::GeneMap;\n    use Bio::Map::Gene;\n    use Bio::Map::TranscriptionFactor;\n    use Bio::Map::GeneRelative;\n\n\t# make some maps that will represent an area around a particular gene in\n\t# particular species (by default, the map represents the area in the genome\n    # 1000bp upstream of the gene)\n    my $map1 = Bio::Map::GeneMap->get(-gene => 'BRCA2',\n                                      -species => 'human',\n                                      -description => 'breast cancer 2, early onset');\n\tmy $map2 = Bio::Map::GeneMap->get(-gene => 'BRCA2',\n                                      -species => 'mouse');\n\n\t# model a TF that binds 500bp upstream of the BRCA2 gene in humans and\n\t# 250bp upstream of BRCA2 in mice\n\tmy $rel = Bio::Map::GeneRelative->new(-description => \"gene start\");\n    my $tf = Bio::Map::TranscriptionFactor->get(-universal_name => 'tf1');\n\tBio::Map::Position->new(-map => $map1,\n                            -element => $tf,\n                            -start => -500,\n                            -length => 10,\n                            -relative => $rel);\n\tBio::Map::Position->new(-map => $map2,\n                            -element => $tf,\n                            -start => -250,\n                            -length => 10,\n                            -relative => $rel);\n\n\t# find out all the things that map near BRCA2 in all species\n\tforeach my $map ($gene->known_maps) {\n\t\tforeach my $thing ($map->get_elements) {\n            next if $thing eq $gene;\n            foreach my $pos ($thing->get_positions($map)) {\n                print \"In species \", $map->species, \", \",\n                      $thing->universal_name, \" maps at \", $pos->value,\n                      \" relative to \", $pos->relative->description, \" of gene \",\n                      $gene->universal_name, \"\\n\";\n            }\n\t\t}\n\t}\n    \n    # a GeneMap isa PrimarySeq and so can have sequence associated with it\n    $map1->seq('ATGC');\n    my $subseq = $map1->subseq(2,3); # TG\n\n=head1 DESCRIPTION\n\nModel the abstract notion of the area around a gene - you don't care exactly\nwhere this area is in the genome, you just want to be able to say \"something\nbinds upstream of gene X\" and \"something else binds 20bp upstream of the first\nsomething\" etc.\n\nIt's useful for modelling transcription factor bindings sites, letting you find\nout which transcription factors bind near a gene of interest, or which genes\nare bound by a transcription factor of interest.\n\nSee t/Map/Map.t for more example usage.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::GeneMap;\nuse strict;\n\nuse Bio::Map::Gene;\nuse Bio::Map::Position;\n\nuse base qw(Bio::Map::SimpleMap Bio::PrimarySeq);\n\nour $GENEMAPS = {};\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Map::GeneMap->new();\n Function: Builds a new Bio::Map::GeneMap object (that has placed on it a\n           mappable element (Bio::Map::Gene) representing a gene).\n Returns : Bio::Map::GeneMap\n Args    : -gene        => string name of the gene this map will be for\n                           (in a form common to all species that have the gene,\n                           but unique amongst non-orthologous genes) or a\n                           Bio::Map::Gene object, REQUIRED\n           -species     => Bio::Taxon or string representing species, REQUIRED\n           -uid         => string, unique identifier for this map (must be\n                           unique amongst all gene/species combinations)\n           -description => string, free text description of the gene\n           -upstream    => int, the number of bases the map extends before the\n                           start of the gene element (default 1000).\n           -downstream  => int, the number of bases the map extends beyond the\n                           end of the gene element (default 0).\n           -seq         => string, the sequence of the map, presumably the\n                           genomic sequence -upstream bases of the gene,\n                           including the gene, and -downstream bases of the gene\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($uid, $gene, $species, $desc, $up, $down, $seq) = $self->_rearrange([qw(UID\n                                                    GENE\n                                                    SPECIES\n                                                    DESCRIPTION\n                                                    UPSTREAM\n                                                    DOWNSTREAM\n                                                    SEQ)], @args);\n    \n    unless (defined $gene && defined $species) {\n        $self->throw(\"You must supply both -species and -gene\");\n    }\n    \n    $self->gene(-gene => $gene, -description => $desc, -upstream => $up, -downstream => $down);\n    $self->seq($seq) if $seq;\n    \n    unless (defined($uid)) {\n        # trigger the special behaviour in our unique_id method by supplying it\n        # the unique_id we got from our parent class\n        $self->unique_id($self->unique_id);\n    }\n    \n    return $self;\n}\n\n=head2 get\n\n Title   : get\n Usage   : my $map = Bio::Map::GeneMap->get();\n Function: Builds a new Bio::Map::GeneMap object (like new()), or gets a\n           pre-existing one that corresponds to your arguements.\n Returns : Bio::Map::GeneMap\n Args    : -gene        => string name of the gene this map will be for\n                           (in a form common to all species that have the gene,\n                           but unique amongst non-orthologous genes) or a\n                           Bio::Map::Gene object, REQUIRED\n           -species     => Bio::Taxon or string representing species, REQUIRED\n           -uid         => string, unique identifier for this map (must be\n                           unique amongst all gene/species combinations)\n           -description => string, free text description of the gene\n           -upstream    => int, the number of bases the map extends before the\n                           start of the gene element (default 1000).\n           -downstream  => int, the number of bases the map extends beyond the\n                           end of the gene element (default 0).\n           -seq         => string, the sequence of the map, presumably the\n                           genomic sequence -upstream bases of the gene,\n                           including the gene, and -downstream bases of the gene\n\n           If you supply a -uid, and a map had previously been created and\n           given that uid, that same map object will be returned. Otherwise, the\n           combination of -gene and -species will be used to determine\n           if the same map had previously been made. If a corresponding map\n           hadn't previously been made, a new map object will be created and\n           returned.\n\n\nsub get {\n    my ($class, @args) = @_;\n    my ($uid, $gene, $species, $desc, $up, $down, $seq) = Bio::Root::Root->_rearrange([qw(UID\n                                                    GENE\n                                                    SPECIES\n                                                    DESCRIPTION\n                                                    UPSTREAM\n                                                    DOWNSTREAM\n                                                    SEQ)], @args);\n    \n    my $gene_map;\n    if ($uid && defined $GENEMAPS->{by_uid}->{$uid}) {\n        $gene_map = $GENEMAPS->{by_uid}->{$uid};\n    }\n    elsif ($gene && $species) {\n        my $name = ref($gene) ? $gene->universal_name : $gene;\n        if (defined $GENEMAPS->{by_ns}->{$name}->{$species}) {\n            $gene_map = $GENEMAPS->{by_ns}->{$name}->{$species};\n        }\n    }\n    if ($gene_map) {\n        $gene_map->gene->description($desc) if $desc;\n        $gene_map->upstream($up) if defined($up);\n        $gene_map->downstream($down) if defined($down);\n        $gene_map->seq($seq) if $seq;\n        return $gene_map;\n    }\n    \n    return $class->new(@args);\n}\n\n=head2 unique_id\n\n Title   : unique_id\n Usage   : my $id = $map->unique_id;\n Function: Get/set the unique ID for this map\n Returns : string\n Args    : none to get, OR string to set","label":"unique_id($self,$id)"},"line":258,"range":{"start":{"line":258,"character":0},"end":{"character":9999,"line":266}},"kind":12,"definition":"sub","detail":"($self,$id)","children":[{"line":259,"name":"$self","localvar":"my","kind":13,"containerName":"unique_id","definition":"my"},{"line":259,"name":"$id","containerName":"unique_id","kind":13},{"name":"$id","kind":13,"containerName":"unique_id","line":260},{"name":"$GENEMAPS","kind":13,"containerName":"unique_id","line":261},{"name":"$self","containerName":"unique_id","kind":13,"line":261},{"line":262,"name":"$self","containerName":"unique_id","kind":13},{"line":262,"name":"$id","containerName":"unique_id","kind":13},{"line":263,"containerName":"unique_id","kind":13,"name":"$GENEMAPS"},{"kind":13,"containerName":"unique_id","name":"$id","line":263},{"kind":13,"containerName":"unique_id","name":"$self","line":263},{"name":"$self","kind":13,"containerName":"unique_id","line":265}],"name":"unique_id","containerName":"main::"},{"line":261,"name":"by_uid","kind":12},{"line":263,"kind":12,"name":"by_uid"},{"signature":{"label":"species($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: GeneMap.pm,v 1.17 2006/07/17 14:16:53 sendu Exp $\n#\n# BioPerl module for Bio::Map::GeneMap\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::GeneMap - A MapI implementation to represent the area around a gene\n\n=head1 SYNOPSIS\n\n    use Bio::Map::GeneMap;\n    use Bio::Map::Gene;\n    use Bio::Map::TranscriptionFactor;\n    use Bio::Map::GeneRelative;\n\n\t# make some maps that will represent an area around a particular gene in\n\t# particular species (by default, the map represents the area in the genome\n    # 1000bp upstream of the gene)\n    my $map1 = Bio::Map::GeneMap->get(-gene => 'BRCA2',\n                                      -species => 'human',\n                                      -description => 'breast cancer 2, early onset');\n\tmy $map2 = Bio::Map::GeneMap->get(-gene => 'BRCA2',\n                                      -species => 'mouse');\n\n\t# model a TF that binds 500bp upstream of the BRCA2 gene in humans and\n\t# 250bp upstream of BRCA2 in mice\n\tmy $rel = Bio::Map::GeneRelative->new(-description => \"gene start\");\n    my $tf = Bio::Map::TranscriptionFactor->get(-universal_name => 'tf1');\n\tBio::Map::Position->new(-map => $map1,\n                            -element => $tf,\n                            -start => -500,\n                            -length => 10,\n                            -relative => $rel);\n\tBio::Map::Position->new(-map => $map2,\n                            -element => $tf,\n                            -start => -250,\n                            -length => 10,\n                            -relative => $rel);\n\n\t# find out all the things that map near BRCA2 in all species\n\tforeach my $map ($gene->known_maps) {\n\t\tforeach my $thing ($map->get_elements) {\n            next if $thing eq $gene;\n            foreach my $pos ($thing->get_positions($map)) {\n                print \"In species \", $map->species, \", \",\n                      $thing->universal_name, \" maps at \", $pos->value,\n                      \" relative to \", $pos->relative->description, \" of gene \",\n                      $gene->universal_name, \"\\n\";\n            }\n\t\t}\n\t}\n    \n    # a GeneMap isa PrimarySeq and so can have sequence associated with it\n    $map1->seq('ATGC');\n    my $subseq = $map1->subseq(2,3); # TG\n\n=head1 DESCRIPTION\n\nModel the abstract notion of the area around a gene - you don't care exactly\nwhere this area is in the genome, you just want to be able to say \"something\nbinds upstream of gene X\" and \"something else binds 20bp upstream of the first\nsomething\" etc.\n\nIt's useful for modelling transcription factor bindings sites, letting you find\nout which transcription factors bind near a gene of interest, or which genes\nare bound by a transcription factor of interest.\n\nSee t/Map/Map.t for more example usage.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::GeneMap;\nuse strict;\n\nuse Bio::Map::Gene;\nuse Bio::Map::Position;\n\nuse base qw(Bio::Map::SimpleMap Bio::PrimarySeq);\n\nour $GENEMAPS = {};\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Map::GeneMap->new();\n Function: Builds a new Bio::Map::GeneMap object (that has placed on it a\n           mappable element (Bio::Map::Gene) representing a gene).\n Returns : Bio::Map::GeneMap\n Args    : -gene        => string name of the gene this map will be for\n                           (in a form common to all species that have the gene,\n                           but unique amongst non-orthologous genes) or a\n                           Bio::Map::Gene object, REQUIRED\n           -species     => Bio::Taxon or string representing species, REQUIRED\n           -uid         => string, unique identifier for this map (must be\n                           unique amongst all gene/species combinations)\n           -description => string, free text description of the gene\n           -upstream    => int, the number of bases the map extends before the\n                           start of the gene element (default 1000).\n           -downstream  => int, the number of bases the map extends beyond the\n                           end of the gene element (default 0).\n           -seq         => string, the sequence of the map, presumably the\n                           genomic sequence -upstream bases of the gene,\n                           including the gene, and -downstream bases of the gene\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($uid, $gene, $species, $desc, $up, $down, $seq) = $self->_rearrange([qw(UID\n                                                    GENE\n                                                    SPECIES\n                                                    DESCRIPTION\n                                                    UPSTREAM\n                                                    DOWNSTREAM\n                                                    SEQ)], @args);\n    \n    unless (defined $gene && defined $species) {\n        $self->throw(\"You must supply both -species and -gene\");\n    }\n    \n    $self->gene(-gene => $gene, -description => $desc, -upstream => $up, -downstream => $down);\n    $self->seq($seq) if $seq;\n    \n    unless (defined($uid)) {\n        # trigger the special behaviour in our unique_id method by supplying it\n        # the unique_id we got from our parent class\n        $self->unique_id($self->unique_id);\n    }\n    \n    return $self;\n}\n\n=head2 get\n\n Title   : get\n Usage   : my $map = Bio::Map::GeneMap->get();\n Function: Builds a new Bio::Map::GeneMap object (like new()), or gets a\n           pre-existing one that corresponds to your arguements.\n Returns : Bio::Map::GeneMap\n Args    : -gene        => string name of the gene this map will be for\n                           (in a form common to all species that have the gene,\n                           but unique amongst non-orthologous genes) or a\n                           Bio::Map::Gene object, REQUIRED\n           -species     => Bio::Taxon or string representing species, REQUIRED\n           -uid         => string, unique identifier for this map (must be\n                           unique amongst all gene/species combinations)\n           -description => string, free text description of the gene\n           -upstream    => int, the number of bases the map extends before the\n                           start of the gene element (default 1000).\n           -downstream  => int, the number of bases the map extends beyond the\n                           end of the gene element (default 0).\n           -seq         => string, the sequence of the map, presumably the\n                           genomic sequence -upstream bases of the gene,\n                           including the gene, and -downstream bases of the gene\n\n           If you supply a -uid, and a map had previously been created and\n           given that uid, that same map object will be returned. Otherwise, the\n           combination of -gene and -species will be used to determine\n           if the same map had previously been made. If a corresponding map\n           hadn't previously been made, a new map object will be created and\n           returned.\n\n\nsub get {\n    my ($class, @args) = @_;\n    my ($uid, $gene, $species, $desc, $up, $down, $seq) = Bio::Root::Root->_rearrange([qw(UID\n                                                    GENE\n                                                    SPECIES\n                                                    DESCRIPTION\n                                                    UPSTREAM\n                                                    DOWNSTREAM\n                                                    SEQ)], @args);\n    \n    my $gene_map;\n    if ($uid && defined $GENEMAPS->{by_uid}->{$uid}) {\n        $gene_map = $GENEMAPS->{by_uid}->{$uid};\n    }\n    elsif ($gene && $species) {\n        my $name = ref($gene) ? $gene->universal_name : $gene;\n        if (defined $GENEMAPS->{by_ns}->{$name}->{$species}) {\n            $gene_map = $GENEMAPS->{by_ns}->{$name}->{$species};\n        }\n    }\n    if ($gene_map) {\n        $gene_map->gene->description($desc) if $desc;\n        $gene_map->upstream($up) if defined($up);\n        $gene_map->downstream($down) if defined($down);\n        $gene_map->seq($seq) if $seq;\n        return $gene_map;\n    }\n    \n    return $class->new(@args);\n}\n\n=head2 unique_id\n\n Title   : unique_id\n Usage   : my $id = $map->unique_id;\n Function: Get/set the unique ID for this map\n Returns : string\n Args    : none to get, OR string to set\n\n\nsub unique_id {\n    my ($self, $id) = @_;\n    if (defined $id) {\n        delete $GENEMAPS->{by_uid}->{$self->{'_uid'}};\n        $self->{'_uid'} = $id;\n        $GENEMAPS->{by_uid}->{$id} = $self;\n    }\n    return $self->{'_uid'};\n}\n\n=head2 species\n\n Title   : species\n Usage   : my $species = $map->species;\n Function: Get/set Species for a map. It is not recommended to change this once\n           set.\n Returns : Bio::Taxon object or string\n Args    : none to get, OR Bio::Taxon or string to set"},"line":279,"range":{"end":{"character":9999,"line":291},"start":{"character":0,"line":279}},"kind":12,"definition":"sub","detail":"($self,$value)","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"species","name":"$self","line":280},{"line":280,"name":"$value","kind":13,"containerName":"species"},{"name":"$value","containerName":"species","kind":13,"line":281},{"name":"$old_species","localvar":"my","containerName":"species","kind":13,"line":282,"definition":"my"},{"line":282,"name":"$self","kind":13,"containerName":"species"},{"line":283,"kind":13,"containerName":"species","name":"$self"},{"line":283,"name":"$value","kind":13,"containerName":"species"},{"definition":"my","line":284,"name":"$name","localvar":"my","kind":13,"containerName":"species"},{"line":284,"containerName":"species","kind":13,"name":"$self"},{"line":284,"name":"universal_name","containerName":"species","kind":12},{"line":284,"kind":13,"containerName":"species","name":"$value"},{"kind":13,"containerName":"species","name":"$old_species","line":285},{"line":286,"kind":13,"containerName":"species","name":"$GENEMAPS"},{"containerName":"species","kind":13,"name":"$name","line":286},{"containerName":"species","kind":13,"name":"$old_species","line":286},{"containerName":"species","kind":13,"name":"$GENEMAPS","line":288},{"kind":13,"containerName":"species","name":"$name","line":288},{"containerName":"species","kind":13,"name":"$value","line":288},{"line":288,"name":"$self","containerName":"species","kind":13},{"containerName":"species","kind":13,"name":"$self","line":290}],"name":"species","containerName":"main::"},{"name":"_species","kind":12,"line":282},{"kind":12,"name":"by_ns","line":286},{"line":288,"kind":12,"name":"by_ns"},{"definition":"sub","containerName":"main::","name":"type","children":[],"range":{"start":{"line":303,"character":0},"end":{"character":9999,"line":305}},"kind":12,"line":303},{"containerName":"main::","name":"gene","children":[{"line":328,"containerName":"gene","localvar":"my","kind":13,"name":"$self","definition":"my"},{"line":328,"kind":13,"containerName":"gene","name":"@args"},{"containerName":"gene","kind":13,"name":"@args","line":330},{"definition":"my","name":"$gene","containerName":"gene","localvar":"my","kind":13,"line":331},{"name":"$desc","kind":13,"containerName":"gene","line":331},{"kind":13,"containerName":"gene","name":"$up","line":331},{"name":"$down","kind":13,"containerName":"gene","line":331},{"containerName":"gene","kind":13,"name":"$self","line":331},{"line":331,"kind":12,"containerName":"gene","name":"_rearrange"},{"line":334,"name":"@args","containerName":"gene","kind":13},{"line":335,"name":"$self","kind":13,"containerName":"gene"},{"line":335,"containerName":"gene","kind":12,"name":"throw"},{"line":335,"kind":13,"containerName":"gene","name":"$gene"},{"kind":13,"localvar":"my","containerName":"gene","name":"$gene_obj","line":337,"definition":"my"},{"line":337,"kind":13,"containerName":"gene","name":"$gene"},{"name":"$gene","kind":13,"containerName":"gene","line":337},{"line":337,"name":"get","kind":12,"containerName":"gene"},{"containerName":"gene","kind":13,"name":"$gene","line":337},{"line":337,"name":"$desc","containerName":"gene","kind":13},{"line":338,"containerName":"gene","kind":13,"name":"$self"},{"line":339,"containerName":"gene","kind":13,"name":"$self"},{"name":"$gene_obj","containerName":"gene","kind":13,"line":339},{"name":"$self","kind":13,"containerName":"gene","line":340},{"kind":12,"containerName":"gene","name":"warn","line":340},{"name":"$self","kind":13,"containerName":"gene","line":341},{"kind":12,"containerName":"gene","name":"purge_positions","line":341},{"line":341,"name":"$self","containerName":"gene","kind":13},{"line":342,"name":"$GENEMAPS","containerName":"gene","kind":13},{"line":342,"name":"$self","kind":13,"containerName":"gene"},{"line":342,"kind":12,"containerName":"gene","name":"universal_name"},{"line":342,"kind":13,"containerName":"gene","name":"$self"},{"line":342,"name":"species","kind":12,"containerName":"gene"},{"containerName":"gene","kind":13,"name":"$self","line":343},{"line":343,"name":"$gene_obj","containerName":"gene","kind":13},{"line":347,"kind":13,"containerName":"gene","name":"$self"},{"name":"upstream","kind":12,"containerName":"gene","line":347},{"name":"$up","containerName":"gene","kind":13,"line":347},{"line":347,"kind":13,"containerName":"gene","name":"$up"},{"containerName":"gene","kind":13,"name":"$self","line":348},{"containerName":"gene","kind":12,"name":"downstream","line":348},{"kind":13,"containerName":"gene","name":"$down","line":348},{"name":"$down","containerName":"gene","kind":13,"line":348},{"containerName":"gene","kind":13,"name":"$up","line":352},{"line":353,"kind":13,"containerName":"gene","name":"$up"},{"name":"$self","containerName":"gene","kind":13,"line":353},{"name":"throw","kind":12,"containerName":"gene","line":353},{"kind":12,"containerName":"gene","name":"new","line":354},{"containerName":"gene","kind":13,"name":"$self","line":354},{"name":"$up","kind":13,"containerName":"gene","line":354},{"name":"$gene_obj","kind":13,"containerName":"gene","line":354},{"line":355,"name":"$self","containerName":"gene","kind":13},{"name":"$gene_obj","containerName":"gene","kind":13,"line":355},{"kind":13,"containerName":"gene","name":"$self","line":356},{"line":356,"kind":12,"containerName":"gene","name":"downstream"},{"line":356,"name":"$down","containerName":"gene","kind":13},{"name":"$gene_obj","containerName":"gene","kind":13,"line":359},{"containerName":"gene","kind":12,"name":"_set_from_db","line":359},{"line":359,"containerName":"gene","kind":13,"name":"$self"},{"name":"$GENEMAPS","containerName":"gene","kind":13,"line":362},{"line":362,"name":"$self","kind":13,"containerName":"gene"},{"name":"universal_name","kind":12,"containerName":"gene","line":362},{"kind":13,"containerName":"gene","name":"$self","line":362},{"name":"species","containerName":"gene","kind":12,"line":362},{"line":362,"containerName":"gene","kind":13,"name":"$self"},{"line":365,"name":"$self","kind":13,"containerName":"gene"}],"detail":"($self,@args)","definition":"sub","range":{"end":{"line":366,"character":9999},"start":{"character":0,"line":327}},"kind":12,"line":327,"signature":{"label":"gene($self,@args)","documentation":"1;\n# $Id: GeneMap.pm,v 1.17 2006/07/17 14:16:53 sendu Exp $\n#\n# BioPerl module for Bio::Map::GeneMap\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::GeneMap - A MapI implementation to represent the area around a gene\n\n=head1 SYNOPSIS\n\n    use Bio::Map::GeneMap;\n    use Bio::Map::Gene;\n    use Bio::Map::TranscriptionFactor;\n    use Bio::Map::GeneRelative;\n\n\t# make some maps that will represent an area around a particular gene in\n\t# particular species (by default, the map represents the area in the genome\n    # 1000bp upstream of the gene)\n    my $map1 = Bio::Map::GeneMap->get(-gene => 'BRCA2',\n                                      -species => 'human',\n                                      -description => 'breast cancer 2, early onset');\n\tmy $map2 = Bio::Map::GeneMap->get(-gene => 'BRCA2',\n                                      -species => 'mouse');\n\n\t# model a TF that binds 500bp upstream of the BRCA2 gene in humans and\n\t# 250bp upstream of BRCA2 in mice\n\tmy $rel = Bio::Map::GeneRelative->new(-description => \"gene start\");\n    my $tf = Bio::Map::TranscriptionFactor->get(-universal_name => 'tf1');\n\tBio::Map::Position->new(-map => $map1,\n                            -element => $tf,\n                            -start => -500,\n                            -length => 10,\n                            -relative => $rel);\n\tBio::Map::Position->new(-map => $map2,\n                            -element => $tf,\n                            -start => -250,\n                            -length => 10,\n                            -relative => $rel);\n\n\t# find out all the things that map near BRCA2 in all species\n\tforeach my $map ($gene->known_maps) {\n\t\tforeach my $thing ($map->get_elements) {\n            next if $thing eq $gene;\n            foreach my $pos ($thing->get_positions($map)) {\n                print \"In species \", $map->species, \", \",\n                      $thing->universal_name, \" maps at \", $pos->value,\n                      \" relative to \", $pos->relative->description, \" of gene \",\n                      $gene->universal_name, \"\\n\";\n            }\n\t\t}\n\t}\n    \n    # a GeneMap isa PrimarySeq and so can have sequence associated with it\n    $map1->seq('ATGC');\n    my $subseq = $map1->subseq(2,3); # TG\n\n=head1 DESCRIPTION\n\nModel the abstract notion of the area around a gene - you don't care exactly\nwhere this area is in the genome, you just want to be able to say \"something\nbinds upstream of gene X\" and \"something else binds 20bp upstream of the first\nsomething\" etc.\n\nIt's useful for modelling transcription factor bindings sites, letting you find\nout which transcription factors bind near a gene of interest, or which genes\nare bound by a transcription factor of interest.\n\nSee t/Map/Map.t for more example usage.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::GeneMap;\nuse strict;\n\nuse Bio::Map::Gene;\nuse Bio::Map::Position;\n\nuse base qw(Bio::Map::SimpleMap Bio::PrimarySeq);\n\nour $GENEMAPS = {};\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Map::GeneMap->new();\n Function: Builds a new Bio::Map::GeneMap object (that has placed on it a\n           mappable element (Bio::Map::Gene) representing a gene).\n Returns : Bio::Map::GeneMap\n Args    : -gene        => string name of the gene this map will be for\n                           (in a form common to all species that have the gene,\n                           but unique amongst non-orthologous genes) or a\n                           Bio::Map::Gene object, REQUIRED\n           -species     => Bio::Taxon or string representing species, REQUIRED\n           -uid         => string, unique identifier for this map (must be\n                           unique amongst all gene/species combinations)\n           -description => string, free text description of the gene\n           -upstream    => int, the number of bases the map extends before the\n                           start of the gene element (default 1000).\n           -downstream  => int, the number of bases the map extends beyond the\n                           end of the gene element (default 0).\n           -seq         => string, the sequence of the map, presumably the\n                           genomic sequence -upstream bases of the gene,\n                           including the gene, and -downstream bases of the gene\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($uid, $gene, $species, $desc, $up, $down, $seq) = $self->_rearrange([qw(UID\n                                                    GENE\n                                                    SPECIES\n                                                    DESCRIPTION\n                                                    UPSTREAM\n                                                    DOWNSTREAM\n                                                    SEQ)], @args);\n    \n    unless (defined $gene && defined $species) {\n        $self->throw(\"You must supply both -species and -gene\");\n    }\n    \n    $self->gene(-gene => $gene, -description => $desc, -upstream => $up, -downstream => $down);\n    $self->seq($seq) if $seq;\n    \n    unless (defined($uid)) {\n        # trigger the special behaviour in our unique_id method by supplying it\n        # the unique_id we got from our parent class\n        $self->unique_id($self->unique_id);\n    }\n    \n    return $self;\n}\n\n=head2 get\n\n Title   : get\n Usage   : my $map = Bio::Map::GeneMap->get();\n Function: Builds a new Bio::Map::GeneMap object (like new()), or gets a\n           pre-existing one that corresponds to your arguements.\n Returns : Bio::Map::GeneMap\n Args    : -gene        => string name of the gene this map will be for\n                           (in a form common to all species that have the gene,\n                           but unique amongst non-orthologous genes) or a\n                           Bio::Map::Gene object, REQUIRED\n           -species     => Bio::Taxon or string representing species, REQUIRED\n           -uid         => string, unique identifier for this map (must be\n                           unique amongst all gene/species combinations)\n           -description => string, free text description of the gene\n           -upstream    => int, the number of bases the map extends before the\n                           start of the gene element (default 1000).\n           -downstream  => int, the number of bases the map extends beyond the\n                           end of the gene element (default 0).\n           -seq         => string, the sequence of the map, presumably the\n                           genomic sequence -upstream bases of the gene,\n                           including the gene, and -downstream bases of the gene\n\n           If you supply a -uid, and a map had previously been created and\n           given that uid, that same map object will be returned. Otherwise, the\n           combination of -gene and -species will be used to determine\n           if the same map had previously been made. If a corresponding map\n           hadn't previously been made, a new map object will be created and\n           returned.\n\n\nsub get {\n    my ($class, @args) = @_;\n    my ($uid, $gene, $species, $desc, $up, $down, $seq) = Bio::Root::Root->_rearrange([qw(UID\n                                                    GENE\n                                                    SPECIES\n                                                    DESCRIPTION\n                                                    UPSTREAM\n                                                    DOWNSTREAM\n                                                    SEQ)], @args);\n    \n    my $gene_map;\n    if ($uid && defined $GENEMAPS->{by_uid}->{$uid}) {\n        $gene_map = $GENEMAPS->{by_uid}->{$uid};\n    }\n    elsif ($gene && $species) {\n        my $name = ref($gene) ? $gene->universal_name : $gene;\n        if (defined $GENEMAPS->{by_ns}->{$name}->{$species}) {\n            $gene_map = $GENEMAPS->{by_ns}->{$name}->{$species};\n        }\n    }\n    if ($gene_map) {\n        $gene_map->gene->description($desc) if $desc;\n        $gene_map->upstream($up) if defined($up);\n        $gene_map->downstream($down) if defined($down);\n        $gene_map->seq($seq) if $seq;\n        return $gene_map;\n    }\n    \n    return $class->new(@args);\n}\n\n=head2 unique_id\n\n Title   : unique_id\n Usage   : my $id = $map->unique_id;\n Function: Get/set the unique ID for this map\n Returns : string\n Args    : none to get, OR string to set\n\n\nsub unique_id {\n    my ($self, $id) = @_;\n    if (defined $id) {\n        delete $GENEMAPS->{by_uid}->{$self->{'_uid'}};\n        $self->{'_uid'} = $id;\n        $GENEMAPS->{by_uid}->{$id} = $self;\n    }\n    return $self->{'_uid'};\n}\n\n=head2 species\n\n Title   : species\n Usage   : my $species = $map->species;\n Function: Get/set Species for a map. It is not recommended to change this once\n           set.\n Returns : Bio::Taxon object or string\n Args    : none to get, OR Bio::Taxon or string to set\n\n\nsub species {\n    my ($self, $value) = @_;\n    if ($value) {\n        my $old_species = $self->{_species};\n        $self->{'_species'} = $value;\n        my $name = $self->universal_name || return $value;\n        if ($old_species) {\n            delete $GENEMAPS->{by_ns}->{$name}->{$old_species};\n        }\n        $GENEMAPS->{by_ns}->{$name}->{$value} = $self;\n    }\n    return $self->{'_species'};\n}\n\n=head2 type\n\n Title   : type\n Usage   : my $type = $map->type\n Function: Get Map type\n Returns : string 'gene'\n Args    : none\n\n\nsub type {\n    return 'gene';\n}\n\n=head2 gene\n\n Title   : gene\n Usage   : my $gene = $map->gene;\n           $map->gene(-gene => $gene);\n Function: Get/set the mappable element on this map that represents the gene\n           this map is for. Once set, it is not recommended to re-set the gene\n           to something else. Behaviour in that case is undefined.\n Returns : Bio::Map::Gene\n Args    : none to get, OR to set:\n           -gene        => Bio::Map::Gene or string of the universal name (see\n                           Bio::Map::Gene docs), REQUIRED\n           -description => string, applied to the Bio::Map::Gene\n           -upstream    => int, the number of bases the map extends before the\n                           start of the gene element (default 1000).\n           -downstream  => int, the number of bases the map extends beyond the\n                           end of the gene element (default 0).","parameters":[{"label":"$self"},{"label":"@args"}]}},{"name":"Bio","containerName":"Map::Gene","kind":12,"line":337},{"name":"gene","kind":12,"line":338},{"line":339,"kind":12,"name":"gene"},{"name":"gene","kind":12,"line":341},{"line":342,"kind":12,"name":"by_ns"},{"name":"gene","kind":12,"line":343},{"line":354,"containerName":"Map::Position","kind":12,"name":"Bio"},{"kind":12,"name":"gene","line":355},{"line":362,"kind":12,"name":"by_ns"},{"line":365,"name":"gene","kind":12},{"children":[{"line":380,"localvar":"my","kind":13,"containerName":"universal_name","name":"$self","definition":"my"},{"line":380,"name":"$value","kind":13,"containerName":"universal_name"},{"line":381,"name":"$self","kind":13,"containerName":"universal_name"},{"kind":12,"containerName":"universal_name","name":"gene","line":381},{"line":382,"kind":13,"containerName":"universal_name","name":"$value"},{"name":"$species","localvar":"my","kind":13,"containerName":"universal_name","line":383,"definition":"my"},{"name":"$self","kind":13,"containerName":"universal_name","line":383},{"containerName":"universal_name","kind":12,"name":"species","line":383},{"line":384,"containerName":"universal_name","kind":13,"name":"$GENEMAPS"},{"line":384,"name":"$self","containerName":"universal_name","kind":13},{"containerName":"universal_name","kind":12,"name":"gene","line":384},{"line":384,"containerName":"universal_name","kind":12,"name":"universal_name"},{"line":384,"name":"$species","kind":13,"containerName":"universal_name"},{"line":385,"name":"$self","kind":13,"containerName":"universal_name"},{"line":385,"kind":12,"containerName":"universal_name","name":"gene"},{"line":385,"kind":12,"containerName":"universal_name","name":"universal_name"},{"name":"$value","containerName":"universal_name","kind":13,"line":385},{"line":386,"name":"$GENEMAPS","containerName":"universal_name","kind":13},{"line":386,"name":"$value","kind":13,"containerName":"universal_name"},{"kind":13,"containerName":"universal_name","name":"$species","line":386},{"kind":13,"containerName":"universal_name","name":"$self","line":386},{"name":"$self","kind":13,"containerName":"universal_name","line":388},{"name":"gene","containerName":"universal_name","kind":12,"line":388},{"containerName":"universal_name","kind":12,"name":"universal_name","line":388}],"containerName":"main::","name":"universal_name","definition":"sub","detail":"($self,$value)","line":379,"kind":12,"range":{"start":{"line":379,"character":0},"end":{"character":9999,"line":389}},"signature":{"documentation":"1;\n# $Id: GeneMap.pm,v 1.17 2006/07/17 14:16:53 sendu Exp $\n#\n# BioPerl module for Bio::Map::GeneMap\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::GeneMap - A MapI implementation to represent the area around a gene\n\n=head1 SYNOPSIS\n\n    use Bio::Map::GeneMap;\n    use Bio::Map::Gene;\n    use Bio::Map::TranscriptionFactor;\n    use Bio::Map::GeneRelative;\n\n\t# make some maps that will represent an area around a particular gene in\n\t# particular species (by default, the map represents the area in the genome\n    # 1000bp upstream of the gene)\n    my $map1 = Bio::Map::GeneMap->get(-gene => 'BRCA2',\n                                      -species => 'human',\n                                      -description => 'breast cancer 2, early onset');\n\tmy $map2 = Bio::Map::GeneMap->get(-gene => 'BRCA2',\n                                      -species => 'mouse');\n\n\t# model a TF that binds 500bp upstream of the BRCA2 gene in humans and\n\t# 250bp upstream of BRCA2 in mice\n\tmy $rel = Bio::Map::GeneRelative->new(-description => \"gene start\");\n    my $tf = Bio::Map::TranscriptionFactor->get(-universal_name => 'tf1');\n\tBio::Map::Position->new(-map => $map1,\n                            -element => $tf,\n                            -start => -500,\n                            -length => 10,\n                            -relative => $rel);\n\tBio::Map::Position->new(-map => $map2,\n                            -element => $tf,\n                            -start => -250,\n                            -length => 10,\n                            -relative => $rel);\n\n\t# find out all the things that map near BRCA2 in all species\n\tforeach my $map ($gene->known_maps) {\n\t\tforeach my $thing ($map->get_elements) {\n            next if $thing eq $gene;\n            foreach my $pos ($thing->get_positions($map)) {\n                print \"In species \", $map->species, \", \",\n                      $thing->universal_name, \" maps at \", $pos->value,\n                      \" relative to \", $pos->relative->description, \" of gene \",\n                      $gene->universal_name, \"\\n\";\n            }\n\t\t}\n\t}\n    \n    # a GeneMap isa PrimarySeq and so can have sequence associated with it\n    $map1->seq('ATGC');\n    my $subseq = $map1->subseq(2,3); # TG\n\n=head1 DESCRIPTION\n\nModel the abstract notion of the area around a gene - you don't care exactly\nwhere this area is in the genome, you just want to be able to say \"something\nbinds upstream of gene X\" and \"something else binds 20bp upstream of the first\nsomething\" etc.\n\nIt's useful for modelling transcription factor bindings sites, letting you find\nout which transcription factors bind near a gene of interest, or which genes\nare bound by a transcription factor of interest.\n\nSee t/Map/Map.t for more example usage.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::GeneMap;\nuse strict;\n\nuse Bio::Map::Gene;\nuse Bio::Map::Position;\n\nuse base qw(Bio::Map::SimpleMap Bio::PrimarySeq);\n\nour $GENEMAPS = {};\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Map::GeneMap->new();\n Function: Builds a new Bio::Map::GeneMap object (that has placed on it a\n           mappable element (Bio::Map::Gene) representing a gene).\n Returns : Bio::Map::GeneMap\n Args    : -gene        => string name of the gene this map will be for\n                           (in a form common to all species that have the gene,\n                           but unique amongst non-orthologous genes) or a\n                           Bio::Map::Gene object, REQUIRED\n           -species     => Bio::Taxon or string representing species, REQUIRED\n           -uid         => string, unique identifier for this map (must be\n                           unique amongst all gene/species combinations)\n           -description => string, free text description of the gene\n           -upstream    => int, the number of bases the map extends before the\n                           start of the gene element (default 1000).\n           -downstream  => int, the number of bases the map extends beyond the\n                           end of the gene element (default 0).\n           -seq         => string, the sequence of the map, presumably the\n                           genomic sequence -upstream bases of the gene,\n                           including the gene, and -downstream bases of the gene\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($uid, $gene, $species, $desc, $up, $down, $seq) = $self->_rearrange([qw(UID\n                                                    GENE\n                                                    SPECIES\n                                                    DESCRIPTION\n                                                    UPSTREAM\n                                                    DOWNSTREAM\n                                                    SEQ)], @args);\n    \n    unless (defined $gene && defined $species) {\n        $self->throw(\"You must supply both -species and -gene\");\n    }\n    \n    $self->gene(-gene => $gene, -description => $desc, -upstream => $up, -downstream => $down);\n    $self->seq($seq) if $seq;\n    \n    unless (defined($uid)) {\n        # trigger the special behaviour in our unique_id method by supplying it\n        # the unique_id we got from our parent class\n        $self->unique_id($self->unique_id);\n    }\n    \n    return $self;\n}\n\n=head2 get\n\n Title   : get\n Usage   : my $map = Bio::Map::GeneMap->get();\n Function: Builds a new Bio::Map::GeneMap object (like new()), or gets a\n           pre-existing one that corresponds to your arguements.\n Returns : Bio::Map::GeneMap\n Args    : -gene        => string name of the gene this map will be for\n                           (in a form common to all species that have the gene,\n                           but unique amongst non-orthologous genes) or a\n                           Bio::Map::Gene object, REQUIRED\n           -species     => Bio::Taxon or string representing species, REQUIRED\n           -uid         => string, unique identifier for this map (must be\n                           unique amongst all gene/species combinations)\n           -description => string, free text description of the gene\n           -upstream    => int, the number of bases the map extends before the\n                           start of the gene element (default 1000).\n           -downstream  => int, the number of bases the map extends beyond the\n                           end of the gene element (default 0).\n           -seq         => string, the sequence of the map, presumably the\n                           genomic sequence -upstream bases of the gene,\n                           including the gene, and -downstream bases of the gene\n\n           If you supply a -uid, and a map had previously been created and\n           given that uid, that same map object will be returned. Otherwise, the\n           combination of -gene and -species will be used to determine\n           if the same map had previously been made. If a corresponding map\n           hadn't previously been made, a new map object will be created and\n           returned.\n\n\nsub get {\n    my ($class, @args) = @_;\n    my ($uid, $gene, $species, $desc, $up, $down, $seq) = Bio::Root::Root->_rearrange([qw(UID\n                                                    GENE\n                                                    SPECIES\n                                                    DESCRIPTION\n                                                    UPSTREAM\n                                                    DOWNSTREAM\n                                                    SEQ)], @args);\n    \n    my $gene_map;\n    if ($uid && defined $GENEMAPS->{by_uid}->{$uid}) {\n        $gene_map = $GENEMAPS->{by_uid}->{$uid};\n    }\n    elsif ($gene && $species) {\n        my $name = ref($gene) ? $gene->universal_name : $gene;\n        if (defined $GENEMAPS->{by_ns}->{$name}->{$species}) {\n            $gene_map = $GENEMAPS->{by_ns}->{$name}->{$species};\n        }\n    }\n    if ($gene_map) {\n        $gene_map->gene->description($desc) if $desc;\n        $gene_map->upstream($up) if defined($up);\n        $gene_map->downstream($down) if defined($down);\n        $gene_map->seq($seq) if $seq;\n        return $gene_map;\n    }\n    \n    return $class->new(@args);\n}\n\n=head2 unique_id\n\n Title   : unique_id\n Usage   : my $id = $map->unique_id;\n Function: Get/set the unique ID for this map\n Returns : string\n Args    : none to get, OR string to set\n\n\nsub unique_id {\n    my ($self, $id) = @_;\n    if (defined $id) {\n        delete $GENEMAPS->{by_uid}->{$self->{'_uid'}};\n        $self->{'_uid'} = $id;\n        $GENEMAPS->{by_uid}->{$id} = $self;\n    }\n    return $self->{'_uid'};\n}\n\n=head2 species\n\n Title   : species\n Usage   : my $species = $map->species;\n Function: Get/set Species for a map. It is not recommended to change this once\n           set.\n Returns : Bio::Taxon object or string\n Args    : none to get, OR Bio::Taxon or string to set\n\n\nsub species {\n    my ($self, $value) = @_;\n    if ($value) {\n        my $old_species = $self->{_species};\n        $self->{'_species'} = $value;\n        my $name = $self->universal_name || return $value;\n        if ($old_species) {\n            delete $GENEMAPS->{by_ns}->{$name}->{$old_species};\n        }\n        $GENEMAPS->{by_ns}->{$name}->{$value} = $self;\n    }\n    return $self->{'_species'};\n}\n\n=head2 type\n\n Title   : type\n Usage   : my $type = $map->type\n Function: Get Map type\n Returns : string 'gene'\n Args    : none\n\n\nsub type {\n    return 'gene';\n}\n\n=head2 gene\n\n Title   : gene\n Usage   : my $gene = $map->gene;\n           $map->gene(-gene => $gene);\n Function: Get/set the mappable element on this map that represents the gene\n           this map is for. Once set, it is not recommended to re-set the gene\n           to something else. Behaviour in that case is undefined.\n Returns : Bio::Map::Gene\n Args    : none to get, OR to set:\n           -gene        => Bio::Map::Gene or string of the universal name (see\n                           Bio::Map::Gene docs), REQUIRED\n           -description => string, applied to the Bio::Map::Gene\n           -upstream    => int, the number of bases the map extends before the\n                           start of the gene element (default 1000).\n           -downstream  => int, the number of bases the map extends beyond the\n                           end of the gene element (default 0).\n\n\nsub gene {\n    my ($self, @args) = @_;\n    \n    if (@args > 0) {\n        my ($gene, $desc, $up, $down) = $self->_rearrange([qw(GENE\n                                                    DESCRIPTION\n                                                    UPSTREAM\n                                                    DOWNSTREAM)], @args);\n        $self->throw(\"You must supply -gene\") unless $gene;\n        \n        my $gene_obj = ref($gene) ? $gene : Bio::Map::Gene->get(-universal_name => $gene, -description => $desc);\n        if (defined $self->{gene}) {\n            if ($self->{gene} ne $gene_obj) {\n                $self->warn(\"Changing the gene that this map is for, which could be bad\");\n                $self->purge_positions($self->{gene});\n                delete $GENEMAPS->{by_ns}->{$self->universal_name}->{$self->species};\n                $self->{gene} = $gene_obj;\n            }\n            \n            # change the gene's position on us if necessary\n            $self->upstream($up) if defined $up;\n            $self->downstream($down) if defined $down;\n        }\n        else {\n            # give the gene object a position on us\n            $up ||= 1000;\n            $up >= 0 || $self->throw(\"-upstream must be a positive integer\");\n            Bio::Map::Position->new(-map => $self, -start => ($up + 1), -element => $gene_obj);\n            $self->{gene} = $gene_obj;\n            $self->downstream($down || 0);\n            \n            # set other gene positions from db if already user-requested\n            $gene_obj->_set_from_db($self);\n        }\n        \n        $GENEMAPS->{by_ns}->{$self->universal_name}->{$self->species} = $self;\n    }\n    \n    return $self->{gene};\n}\n\n=head2 universal_name\n\n Title   : universal_name\n Usage   : my $name = $map->universal_name\n Function: Get/set the name of Bio::Map::Gene object associated with this map.\n           It is not recommended to change this once set.\n Returns : string\n Args    : none to get, OR string to set","parameters":[{"label":"$self"},{"label":"$value"}],"label":"universal_name($self,$value)"}},{"line":384,"name":"by_ns","kind":12},{"line":386,"kind":12,"name":"by_ns"},{"definition":"sub","detail":"($self,$value)","children":[{"containerName":"upstream","localvar":"my","kind":13,"name":"$self","line":405,"definition":"my"},{"line":405,"name":"$value","containerName":"upstream","kind":13},{"name":"$pos","localvar":"my","containerName":"upstream","kind":13,"line":407,"definition":"my"},{"name":"$self","kind":13,"containerName":"upstream","line":407},{"kind":12,"containerName":"upstream","name":"gene","line":407},{"containerName":"upstream","kind":12,"name":"position","line":407},{"line":407,"name":"$self","containerName":"upstream","kind":13},{"line":408,"kind":13,"containerName":"upstream","name":"$value"},{"kind":13,"containerName":"upstream","name":"$value","line":409},{"line":409,"name":"$self","kind":13,"containerName":"upstream"},{"kind":12,"containerName":"upstream","name":"throw","line":409},{"line":410,"kind":13,"containerName":"upstream","name":"$pos"},{"kind":12,"containerName":"upstream","name":"start","line":410},{"name":"$value","containerName":"upstream","kind":13,"line":410},{"name":"$pos","containerName":"upstream","kind":13,"line":413},{"line":413,"containerName":"upstream","kind":12,"name":"start"}],"name":"upstream","containerName":"main::","signature":{"label":"upstream($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: GeneMap.pm,v 1.17 2006/07/17 14:16:53 sendu Exp $\n#\n# BioPerl module for Bio::Map::GeneMap\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::GeneMap - A MapI implementation to represent the area around a gene\n\n=head1 SYNOPSIS\n\n    use Bio::Map::GeneMap;\n    use Bio::Map::Gene;\n    use Bio::Map::TranscriptionFactor;\n    use Bio::Map::GeneRelative;\n\n\t# make some maps that will represent an area around a particular gene in\n\t# particular species (by default, the map represents the area in the genome\n    # 1000bp upstream of the gene)\n    my $map1 = Bio::Map::GeneMap->get(-gene => 'BRCA2',\n                                      -species => 'human',\n                                      -description => 'breast cancer 2, early onset');\n\tmy $map2 = Bio::Map::GeneMap->get(-gene => 'BRCA2',\n                                      -species => 'mouse');\n\n\t# model a TF that binds 500bp upstream of the BRCA2 gene in humans and\n\t# 250bp upstream of BRCA2 in mice\n\tmy $rel = Bio::Map::GeneRelative->new(-description => \"gene start\");\n    my $tf = Bio::Map::TranscriptionFactor->get(-universal_name => 'tf1');\n\tBio::Map::Position->new(-map => $map1,\n                            -element => $tf,\n                            -start => -500,\n                            -length => 10,\n                            -relative => $rel);\n\tBio::Map::Position->new(-map => $map2,\n                            -element => $tf,\n                            -start => -250,\n                            -length => 10,\n                            -relative => $rel);\n\n\t# find out all the things that map near BRCA2 in all species\n\tforeach my $map ($gene->known_maps) {\n\t\tforeach my $thing ($map->get_elements) {\n            next if $thing eq $gene;\n            foreach my $pos ($thing->get_positions($map)) {\n                print \"In species \", $map->species, \", \",\n                      $thing->universal_name, \" maps at \", $pos->value,\n                      \" relative to \", $pos->relative->description, \" of gene \",\n                      $gene->universal_name, \"\\n\";\n            }\n\t\t}\n\t}\n    \n    # a GeneMap isa PrimarySeq and so can have sequence associated with it\n    $map1->seq('ATGC');\n    my $subseq = $map1->subseq(2,3); # TG\n\n=head1 DESCRIPTION\n\nModel the abstract notion of the area around a gene - you don't care exactly\nwhere this area is in the genome, you just want to be able to say \"something\nbinds upstream of gene X\" and \"something else binds 20bp upstream of the first\nsomething\" etc.\n\nIt's useful for modelling transcription factor bindings sites, letting you find\nout which transcription factors bind near a gene of interest, or which genes\nare bound by a transcription factor of interest.\n\nSee t/Map/Map.t for more example usage.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::GeneMap;\nuse strict;\n\nuse Bio::Map::Gene;\nuse Bio::Map::Position;\n\nuse base qw(Bio::Map::SimpleMap Bio::PrimarySeq);\n\nour $GENEMAPS = {};\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Map::GeneMap->new();\n Function: Builds a new Bio::Map::GeneMap object (that has placed on it a\n           mappable element (Bio::Map::Gene) representing a gene).\n Returns : Bio::Map::GeneMap\n Args    : -gene        => string name of the gene this map will be for\n                           (in a form common to all species that have the gene,\n                           but unique amongst non-orthologous genes) or a\n                           Bio::Map::Gene object, REQUIRED\n           -species     => Bio::Taxon or string representing species, REQUIRED\n           -uid         => string, unique identifier for this map (must be\n                           unique amongst all gene/species combinations)\n           -description => string, free text description of the gene\n           -upstream    => int, the number of bases the map extends before the\n                           start of the gene element (default 1000).\n           -downstream  => int, the number of bases the map extends beyond the\n                           end of the gene element (default 0).\n           -seq         => string, the sequence of the map, presumably the\n                           genomic sequence -upstream bases of the gene,\n                           including the gene, and -downstream bases of the gene\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($uid, $gene, $species, $desc, $up, $down, $seq) = $self->_rearrange([qw(UID\n                                                    GENE\n                                                    SPECIES\n                                                    DESCRIPTION\n                                                    UPSTREAM\n                                                    DOWNSTREAM\n                                                    SEQ)], @args);\n    \n    unless (defined $gene && defined $species) {\n        $self->throw(\"You must supply both -species and -gene\");\n    }\n    \n    $self->gene(-gene => $gene, -description => $desc, -upstream => $up, -downstream => $down);\n    $self->seq($seq) if $seq;\n    \n    unless (defined($uid)) {\n        # trigger the special behaviour in our unique_id method by supplying it\n        # the unique_id we got from our parent class\n        $self->unique_id($self->unique_id);\n    }\n    \n    return $self;\n}\n\n=head2 get\n\n Title   : get\n Usage   : my $map = Bio::Map::GeneMap->get();\n Function: Builds a new Bio::Map::GeneMap object (like new()), or gets a\n           pre-existing one that corresponds to your arguements.\n Returns : Bio::Map::GeneMap\n Args    : -gene        => string name of the gene this map will be for\n                           (in a form common to all species that have the gene,\n                           but unique amongst non-orthologous genes) or a\n                           Bio::Map::Gene object, REQUIRED\n           -species     => Bio::Taxon or string representing species, REQUIRED\n           -uid         => string, unique identifier for this map (must be\n                           unique amongst all gene/species combinations)\n           -description => string, free text description of the gene\n           -upstream    => int, the number of bases the map extends before the\n                           start of the gene element (default 1000).\n           -downstream  => int, the number of bases the map extends beyond the\n                           end of the gene element (default 0).\n           -seq         => string, the sequence of the map, presumably the\n                           genomic sequence -upstream bases of the gene,\n                           including the gene, and -downstream bases of the gene\n\n           If you supply a -uid, and a map had previously been created and\n           given that uid, that same map object will be returned. Otherwise, the\n           combination of -gene and -species will be used to determine\n           if the same map had previously been made. If a corresponding map\n           hadn't previously been made, a new map object will be created and\n           returned.\n\n\nsub get {\n    my ($class, @args) = @_;\n    my ($uid, $gene, $species, $desc, $up, $down, $seq) = Bio::Root::Root->_rearrange([qw(UID\n                                                    GENE\n                                                    SPECIES\n                                                    DESCRIPTION\n                                                    UPSTREAM\n                                                    DOWNSTREAM\n                                                    SEQ)], @args);\n    \n    my $gene_map;\n    if ($uid && defined $GENEMAPS->{by_uid}->{$uid}) {\n        $gene_map = $GENEMAPS->{by_uid}->{$uid};\n    }\n    elsif ($gene && $species) {\n        my $name = ref($gene) ? $gene->universal_name : $gene;\n        if (defined $GENEMAPS->{by_ns}->{$name}->{$species}) {\n            $gene_map = $GENEMAPS->{by_ns}->{$name}->{$species};\n        }\n    }\n    if ($gene_map) {\n        $gene_map->gene->description($desc) if $desc;\n        $gene_map->upstream($up) if defined($up);\n        $gene_map->downstream($down) if defined($down);\n        $gene_map->seq($seq) if $seq;\n        return $gene_map;\n    }\n    \n    return $class->new(@args);\n}\n\n=head2 unique_id\n\n Title   : unique_id\n Usage   : my $id = $map->unique_id;\n Function: Get/set the unique ID for this map\n Returns : string\n Args    : none to get, OR string to set\n\n\nsub unique_id {\n    my ($self, $id) = @_;\n    if (defined $id) {\n        delete $GENEMAPS->{by_uid}->{$self->{'_uid'}};\n        $self->{'_uid'} = $id;\n        $GENEMAPS->{by_uid}->{$id} = $self;\n    }\n    return $self->{'_uid'};\n}\n\n=head2 species\n\n Title   : species\n Usage   : my $species = $map->species;\n Function: Get/set Species for a map. It is not recommended to change this once\n           set.\n Returns : Bio::Taxon object or string\n Args    : none to get, OR Bio::Taxon or string to set\n\n\nsub species {\n    my ($self, $value) = @_;\n    if ($value) {\n        my $old_species = $self->{_species};\n        $self->{'_species'} = $value;\n        my $name = $self->universal_name || return $value;\n        if ($old_species) {\n            delete $GENEMAPS->{by_ns}->{$name}->{$old_species};\n        }\n        $GENEMAPS->{by_ns}->{$name}->{$value} = $self;\n    }\n    return $self->{'_species'};\n}\n\n=head2 type\n\n Title   : type\n Usage   : my $type = $map->type\n Function: Get Map type\n Returns : string 'gene'\n Args    : none\n\n\nsub type {\n    return 'gene';\n}\n\n=head2 gene\n\n Title   : gene\n Usage   : my $gene = $map->gene;\n           $map->gene(-gene => $gene);\n Function: Get/set the mappable element on this map that represents the gene\n           this map is for. Once set, it is not recommended to re-set the gene\n           to something else. Behaviour in that case is undefined.\n Returns : Bio::Map::Gene\n Args    : none to get, OR to set:\n           -gene        => Bio::Map::Gene or string of the universal name (see\n                           Bio::Map::Gene docs), REQUIRED\n           -description => string, applied to the Bio::Map::Gene\n           -upstream    => int, the number of bases the map extends before the\n                           start of the gene element (default 1000).\n           -downstream  => int, the number of bases the map extends beyond the\n                           end of the gene element (default 0).\n\n\nsub gene {\n    my ($self, @args) = @_;\n    \n    if (@args > 0) {\n        my ($gene, $desc, $up, $down) = $self->_rearrange([qw(GENE\n                                                    DESCRIPTION\n                                                    UPSTREAM\n                                                    DOWNSTREAM)], @args);\n        $self->throw(\"You must supply -gene\") unless $gene;\n        \n        my $gene_obj = ref($gene) ? $gene : Bio::Map::Gene->get(-universal_name => $gene, -description => $desc);\n        if (defined $self->{gene}) {\n            if ($self->{gene} ne $gene_obj) {\n                $self->warn(\"Changing the gene that this map is for, which could be bad\");\n                $self->purge_positions($self->{gene});\n                delete $GENEMAPS->{by_ns}->{$self->universal_name}->{$self->species};\n                $self->{gene} = $gene_obj;\n            }\n            \n            # change the gene's position on us if necessary\n            $self->upstream($up) if defined $up;\n            $self->downstream($down) if defined $down;\n        }\n        else {\n            # give the gene object a position on us\n            $up ||= 1000;\n            $up >= 0 || $self->throw(\"-upstream must be a positive integer\");\n            Bio::Map::Position->new(-map => $self, -start => ($up + 1), -element => $gene_obj);\n            $self->{gene} = $gene_obj;\n            $self->downstream($down || 0);\n            \n            # set other gene positions from db if already user-requested\n            $gene_obj->_set_from_db($self);\n        }\n        \n        $GENEMAPS->{by_ns}->{$self->universal_name}->{$self->species} = $self;\n    }\n    \n    return $self->{gene};\n}\n\n=head2 universal_name\n\n Title   : universal_name\n Usage   : my $name = $map->universal_name\n Function: Get/set the name of Bio::Map::Gene object associated with this map.\n           It is not recommended to change this once set.\n Returns : string\n Args    : none to get, OR string to set\n\n\nsub universal_name {\n    my ($self, $value) = @_;\n    $self->gene || return;\n    if ($value) {\n        my $species = $self->species;\n        delete $GENEMAPS->{by_ns}->{$self->gene->universal_name}->{$species};\n        $self->gene->universal_name($value);\n        $GENEMAPS->{by_ns}->{$value}->{$species} = $self;\n    }\n    return $self->gene->universal_name;\n}\n\n=head2 upstream\n\n Title   : upstream\n Usage   : my $distance = $map->upstream;\n           $map->upstream($distance);\n Function: Get/set how long the map is before the start of the Bio::Map::Gene\n           object on this map.\n Returns : int\n Args    : none to get, OR int to set (the number of bases the map extends\n           before the start of the gene)"},"line":404,"range":{"start":{"line":404,"character":0},"end":{"line":414,"character":9999}},"kind":12},{"line":429,"range":{"start":{"line":429,"character":0},"end":{"character":9999,"line":433}},"kind":12,"definition":"sub","children":[{"line":430,"name":"$self","containerName":"downstream","localvar":"my","kind":13,"definition":"my"},{"line":431,"name":"$self","containerName":"downstream","kind":13},{"name":"$self","kind":13,"containerName":"downstream","line":432}],"containerName":"main::","name":"downstream"},{"line":431,"kind":12,"name":"_downstream"},{"kind":12,"name":"_downstream","line":432},{"definition":"sub","children":[{"line":449,"name":"$self","localvar":"my","kind":13,"containerName":"length","definition":"my"},{"definition":"my","line":450,"localvar":"my","kind":13,"containerName":"length","name":"$expected_length"},{"line":450,"name":"$self","kind":13,"containerName":"length"},{"kind":12,"containerName":"length","name":"gene","line":450},{"name":"position","containerName":"length","kind":12,"line":450},{"line":450,"name":"$self","kind":13,"containerName":"length"},{"line":450,"kind":12,"containerName":"length","name":"length"},{"line":450,"containerName":"length","kind":13,"name":"$self"},{"line":450,"name":"upstream","kind":12,"containerName":"length"},{"line":450,"containerName":"length","kind":13,"name":"$self"},{"name":"downstream","kind":12,"containerName":"length","line":450},{"definition":"my","line":451,"localvar":"my","kind":13,"containerName":"length","name":"$actual_length"},{"kind":13,"containerName":"length","name":"$self","line":451},{"kind":13,"containerName":"length","name":"$actual_length","line":452},{"name":"$expected_length","kind":13,"containerName":"length","line":452},{"name":"$actual_length","containerName":"length","kind":13,"line":452},{"kind":13,"containerName":"length","name":"$expected_length","line":452}],"containerName":"main::","name":"length","line":448,"range":{"end":{"line":453,"character":9999},"start":{"character":0,"line":448}},"kind":12},{"containerName":"length","kind":12,"name":"SUPER","line":452},{"detail":"($self,@args)","definition":"sub","containerName":"main::","name":"seq","children":[{"definition":"my","line":473,"localvar":"my","containerName":"seq","kind":13,"name":"$self"},{"line":473,"kind":13,"containerName":"seq","name":"@args"},{"definition":"my","kind":13,"localvar":"my","containerName":"seq","name":"$seq","line":474},{"line":474,"name":"$self","kind":13,"containerName":"seq"},{"line":474,"containerName":"seq","kind":13,"name":"@args"},{"line":475,"localvar":"my","kind":13,"containerName":"seq","name":"$expected_length","definition":"my"},{"line":475,"name":"$self","containerName":"seq","kind":13},{"name":"length","kind":12,"containerName":"seq","line":475},{"line":476,"containerName":"seq","kind":13,"name":"$seq"},{"containerName":"seq","kind":13,"name":"$seq","line":476},{"containerName":"seq","kind":13,"name":"$expected_length","line":476},{"definition":"my","containerName":"seq","localvar":"my","kind":13,"name":"@have","line":477},{"line":477,"name":"$seq","kind":13,"containerName":"seq"},{"name":"@result","kind":13,"localvar":"my","containerName":"seq","line":478,"definition":"my"},{"name":"$expected_length","containerName":"seq","kind":13,"line":479},{"line":480,"kind":13,"containerName":"seq","name":"$result"},{"line":480,"kind":13,"containerName":"seq","name":"@have"},{"definition":"my","line":484,"name":"@slice_stuff","kind":13,"localvar":"my","containerName":"seq"},{"name":"$self","containerName":"seq","kind":13,"line":484},{"line":484,"name":"gene","kind":12,"containerName":"seq"},{"name":"_get_slice","containerName":"seq","kind":12,"line":484},{"line":484,"name":"$self","kind":13,"containerName":"seq"},{"line":485,"name":"@slice_stuff","containerName":"seq","kind":13},{"definition":"my","kind":13,"localvar":"my","containerName":"seq","name":"$slice_adaptor","line":486},{"containerName":"seq","kind":13,"name":"$slice","line":486},{"containerName":"seq","kind":13,"name":"$strand","line":486},{"line":486,"kind":13,"containerName":"seq","name":"@slice_stuff"},{"localvar":"my","containerName":"seq","kind":13,"name":"$start","line":487,"definition":"my"},{"line":487,"name":"$end","kind":13,"containerName":"seq"},{"name":"$gene_start","containerName":"seq","kind":13,"line":487},{"containerName":"seq","kind":13,"name":"$seq","line":487},{"kind":13,"containerName":"seq","name":"$expected_length","line":487},{"line":487,"name":"$self","kind":13,"containerName":"seq"},{"name":"upstream","containerName":"seq","kind":12,"line":487},{"definition":"my","localvar":"my","containerName":"seq","kind":13,"name":"$adjust","line":490},{"kind":13,"containerName":"seq","name":"$strand","line":490},{"kind":13,"containerName":"seq","name":"$slice","line":490},{"name":"end","kind":12,"containerName":"seq","line":490},{"containerName":"seq","kind":13,"name":"$slice","line":490},{"line":490,"containerName":"seq","kind":12,"name":"start"},{"line":491,"kind":13,"localvar":"my","containerName":"seq","name":"$adjustment","definition":"my"},{"kind":13,"containerName":"seq","name":"$strand","line":491},{"line":491,"kind":13,"containerName":"seq","name":"$adjust"},{"line":491,"kind":13,"containerName":"seq","name":"$adjust"},{"definition":"my","line":492,"name":"$converted_start","kind":13,"localvar":"my","containerName":"seq"},{"name":"$start","containerName":"seq","kind":13,"line":492},{"containerName":"seq","kind":13,"name":"$gene_start","line":492},{"definition":"my","line":493,"name":"$converted_end","containerName":"seq","localvar":"my","kind":13},{"name":"$end","containerName":"seq","kind":13,"line":493},{"line":493,"kind":13,"containerName":"seq","name":"$gene_start"},{"name":"$converted_start","kind":13,"containerName":"seq","line":494},{"line":494,"containerName":"seq","kind":13,"name":"$converted_end"},{"line":494,"name":"$converted_end","kind":13,"containerName":"seq"},{"kind":13,"containerName":"seq","name":"$converted_start","line":494},{"line":494,"name":"$converted_start","kind":13,"containerName":"seq"},{"line":494,"kind":13,"containerName":"seq","name":"$converted_end"},{"line":498,"containerName":"seq","localvar":"my","kind":13,"name":"$new_slice","definition":"my"},{"line":498,"name":"$slice_adaptor","containerName":"seq","kind":13},{"name":"fetch_by_region","containerName":"seq","kind":12,"line":498},{"kind":13,"containerName":"seq","name":"$slice","line":498},{"line":498,"containerName":"seq","kind":12,"name":"coord_system_name"},{"line":498,"name":"$slice","containerName":"seq","kind":13},{"line":498,"name":"seq_region_name","containerName":"seq","kind":12},{"containerName":"seq","kind":13,"name":"$converted_start","line":498},{"line":498,"name":"$converted_end","containerName":"seq","kind":13},{"line":499,"name":"$new_slice","kind":13,"containerName":"seq"},{"definition":"my","kind":13,"localvar":"my","containerName":"seq","name":"$seq_str","line":499},{"kind":13,"containerName":"seq","name":"$new_slice","line":499},{"name":"seq","containerName":"seq","kind":12,"line":499},{"kind":13,"containerName":"seq","name":"$strand","line":500},{"name":"$seq_str","kind":13,"containerName":"seq","line":501},{"kind":13,"containerName":"seq","name":"$self","line":501},{"line":501,"name":"_revcom","kind":12,"containerName":"seq"},{"containerName":"seq","kind":13,"name":"$seq_str","line":501},{"kind":13,"containerName":"seq","name":"@result","line":503},{"kind":13,"containerName":"seq","name":"$seq","line":503},{"name":"$seq_str","kind":13,"containerName":"seq","line":503},{"kind":13,"containerName":"seq","name":"$seq_str","line":503},{"line":507,"localvar":"my","containerName":"seq","kind":13,"name":"$pos","definition":"my"},{"line":507,"kind":13,"containerName":"seq","name":"$self"},{"line":507,"containerName":"seq","kind":12,"name":"get_positions"},{"line":508,"name":"$pos","containerName":"seq","kind":13},{"line":508,"name":"can","kind":12,"containerName":"seq"},{"definition":"my","containerName":"seq","localvar":"my","kind":13,"name":"@pos_seq","line":509},{"line":509,"name":"$pos","containerName":"seq","kind":13},{"name":"seq","kind":12,"containerName":"seq","line":509},{"line":510,"localvar":"my","kind":13,"containerName":"seq","name":"$i","definition":"my"},{"containerName":"seq","kind":13,"name":"$pos","line":510},{"line":510,"containerName":"seq","kind":12,"name":"start"},{"name":"$pos","kind":13,"containerName":"seq","line":510},{"name":"absolute_relative","kind":12,"containerName":"seq","line":510},{"kind":13,"containerName":"seq","name":"$pos","line":510},{"name":"end","containerName":"seq","kind":12,"line":510},{"line":510,"name":"$pos","containerName":"seq","kind":13},{"name":"absolute_relative","kind":12,"containerName":"seq","line":510},{"line":511,"kind":13,"containerName":"seq","name":"$i"},{"definition":"my","line":512,"name":"$base","kind":13,"localvar":"my","containerName":"seq"},{"line":512,"kind":13,"containerName":"seq","name":"@pos_seq"},{"line":513,"name":"$result","kind":13,"containerName":"seq"},{"kind":13,"containerName":"seq","name":"$i","line":513},{"line":514,"name":"$result","containerName":"seq","kind":13},{"name":"$i","containerName":"seq","kind":13,"line":514},{"line":514,"name":"$base","containerName":"seq","kind":13},{"name":"$seq","kind":13,"containerName":"seq","line":520},{"line":520,"containerName":"seq","kind":13,"name":"@result"},{"name":"$seq","kind":13,"containerName":"seq","line":522}],"signature":{"label":"seq($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: GeneMap.pm,v 1.17 2006/07/17 14:16:53 sendu Exp $\n#\n# BioPerl module for Bio::Map::GeneMap\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::GeneMap - A MapI implementation to represent the area around a gene\n\n=head1 SYNOPSIS\n\n    use Bio::Map::GeneMap;\n    use Bio::Map::Gene;\n    use Bio::Map::TranscriptionFactor;\n    use Bio::Map::GeneRelative;\n\n\t# make some maps that will represent an area around a particular gene in\n\t# particular species (by default, the map represents the area in the genome\n    # 1000bp upstream of the gene)\n    my $map1 = Bio::Map::GeneMap->get(-gene => 'BRCA2',\n                                      -species => 'human',\n                                      -description => 'breast cancer 2, early onset');\n\tmy $map2 = Bio::Map::GeneMap->get(-gene => 'BRCA2',\n                                      -species => 'mouse');\n\n\t# model a TF that binds 500bp upstream of the BRCA2 gene in humans and\n\t# 250bp upstream of BRCA2 in mice\n\tmy $rel = Bio::Map::GeneRelative->new(-description => \"gene start\");\n    my $tf = Bio::Map::TranscriptionFactor->get(-universal_name => 'tf1');\n\tBio::Map::Position->new(-map => $map1,\n                            -element => $tf,\n                            -start => -500,\n                            -length => 10,\n                            -relative => $rel);\n\tBio::Map::Position->new(-map => $map2,\n                            -element => $tf,\n                            -start => -250,\n                            -length => 10,\n                            -relative => $rel);\n\n\t# find out all the things that map near BRCA2 in all species\n\tforeach my $map ($gene->known_maps) {\n\t\tforeach my $thing ($map->get_elements) {\n            next if $thing eq $gene;\n            foreach my $pos ($thing->get_positions($map)) {\n                print \"In species \", $map->species, \", \",\n                      $thing->universal_name, \" maps at \", $pos->value,\n                      \" relative to \", $pos->relative->description, \" of gene \",\n                      $gene->universal_name, \"\\n\";\n            }\n\t\t}\n\t}\n    \n    # a GeneMap isa PrimarySeq and so can have sequence associated with it\n    $map1->seq('ATGC');\n    my $subseq = $map1->subseq(2,3); # TG\n\n=head1 DESCRIPTION\n\nModel the abstract notion of the area around a gene - you don't care exactly\nwhere this area is in the genome, you just want to be able to say \"something\nbinds upstream of gene X\" and \"something else binds 20bp upstream of the first\nsomething\" etc.\n\nIt's useful for modelling transcription factor bindings sites, letting you find\nout which transcription factors bind near a gene of interest, or which genes\nare bound by a transcription factor of interest.\n\nSee t/Map/Map.t for more example usage.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::GeneMap;\nuse strict;\n\nuse Bio::Map::Gene;\nuse Bio::Map::Position;\n\nuse base qw(Bio::Map::SimpleMap Bio::PrimarySeq);\n\nour $GENEMAPS = {};\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Map::GeneMap->new();\n Function: Builds a new Bio::Map::GeneMap object (that has placed on it a\n           mappable element (Bio::Map::Gene) representing a gene).\n Returns : Bio::Map::GeneMap\n Args    : -gene        => string name of the gene this map will be for\n                           (in a form common to all species that have the gene,\n                           but unique amongst non-orthologous genes) or a\n                           Bio::Map::Gene object, REQUIRED\n           -species     => Bio::Taxon or string representing species, REQUIRED\n           -uid         => string, unique identifier for this map (must be\n                           unique amongst all gene/species combinations)\n           -description => string, free text description of the gene\n           -upstream    => int, the number of bases the map extends before the\n                           start of the gene element (default 1000).\n           -downstream  => int, the number of bases the map extends beyond the\n                           end of the gene element (default 0).\n           -seq         => string, the sequence of the map, presumably the\n                           genomic sequence -upstream bases of the gene,\n                           including the gene, and -downstream bases of the gene\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($uid, $gene, $species, $desc, $up, $down, $seq) = $self->_rearrange([qw(UID\n                                                    GENE\n                                                    SPECIES\n                                                    DESCRIPTION\n                                                    UPSTREAM\n                                                    DOWNSTREAM\n                                                    SEQ)], @args);\n    \n    unless (defined $gene && defined $species) {\n        $self->throw(\"You must supply both -species and -gene\");\n    }\n    \n    $self->gene(-gene => $gene, -description => $desc, -upstream => $up, -downstream => $down);\n    $self->seq($seq) if $seq;\n    \n    unless (defined($uid)) {\n        # trigger the special behaviour in our unique_id method by supplying it\n        # the unique_id we got from our parent class\n        $self->unique_id($self->unique_id);\n    }\n    \n    return $self;\n}\n\n=head2 get\n\n Title   : get\n Usage   : my $map = Bio::Map::GeneMap->get();\n Function: Builds a new Bio::Map::GeneMap object (like new()), or gets a\n           pre-existing one that corresponds to your arguements.\n Returns : Bio::Map::GeneMap\n Args    : -gene        => string name of the gene this map will be for\n                           (in a form common to all species that have the gene,\n                           but unique amongst non-orthologous genes) or a\n                           Bio::Map::Gene object, REQUIRED\n           -species     => Bio::Taxon or string representing species, REQUIRED\n           -uid         => string, unique identifier for this map (must be\n                           unique amongst all gene/species combinations)\n           -description => string, free text description of the gene\n           -upstream    => int, the number of bases the map extends before the\n                           start of the gene element (default 1000).\n           -downstream  => int, the number of bases the map extends beyond the\n                           end of the gene element (default 0).\n           -seq         => string, the sequence of the map, presumably the\n                           genomic sequence -upstream bases of the gene,\n                           including the gene, and -downstream bases of the gene\n\n           If you supply a -uid, and a map had previously been created and\n           given that uid, that same map object will be returned. Otherwise, the\n           combination of -gene and -species will be used to determine\n           if the same map had previously been made. If a corresponding map\n           hadn't previously been made, a new map object will be created and\n           returned.\n\n\nsub get {\n    my ($class, @args) = @_;\n    my ($uid, $gene, $species, $desc, $up, $down, $seq) = Bio::Root::Root->_rearrange([qw(UID\n                                                    GENE\n                                                    SPECIES\n                                                    DESCRIPTION\n                                                    UPSTREAM\n                                                    DOWNSTREAM\n                                                    SEQ)], @args);\n    \n    my $gene_map;\n    if ($uid && defined $GENEMAPS->{by_uid}->{$uid}) {\n        $gene_map = $GENEMAPS->{by_uid}->{$uid};\n    }\n    elsif ($gene && $species) {\n        my $name = ref($gene) ? $gene->universal_name : $gene;\n        if (defined $GENEMAPS->{by_ns}->{$name}->{$species}) {\n            $gene_map = $GENEMAPS->{by_ns}->{$name}->{$species};\n        }\n    }\n    if ($gene_map) {\n        $gene_map->gene->description($desc) if $desc;\n        $gene_map->upstream($up) if defined($up);\n        $gene_map->downstream($down) if defined($down);\n        $gene_map->seq($seq) if $seq;\n        return $gene_map;\n    }\n    \n    return $class->new(@args);\n}\n\n=head2 unique_id\n\n Title   : unique_id\n Usage   : my $id = $map->unique_id;\n Function: Get/set the unique ID for this map\n Returns : string\n Args    : none to get, OR string to set\n\n\nsub unique_id {\n    my ($self, $id) = @_;\n    if (defined $id) {\n        delete $GENEMAPS->{by_uid}->{$self->{'_uid'}};\n        $self->{'_uid'} = $id;\n        $GENEMAPS->{by_uid}->{$id} = $self;\n    }\n    return $self->{'_uid'};\n}\n\n=head2 species\n\n Title   : species\n Usage   : my $species = $map->species;\n Function: Get/set Species for a map. It is not recommended to change this once\n           set.\n Returns : Bio::Taxon object or string\n Args    : none to get, OR Bio::Taxon or string to set\n\n\nsub species {\n    my ($self, $value) = @_;\n    if ($value) {\n        my $old_species = $self->{_species};\n        $self->{'_species'} = $value;\n        my $name = $self->universal_name || return $value;\n        if ($old_species) {\n            delete $GENEMAPS->{by_ns}->{$name}->{$old_species};\n        }\n        $GENEMAPS->{by_ns}->{$name}->{$value} = $self;\n    }\n    return $self->{'_species'};\n}\n\n=head2 type\n\n Title   : type\n Usage   : my $type = $map->type\n Function: Get Map type\n Returns : string 'gene'\n Args    : none\n\n\nsub type {\n    return 'gene';\n}\n\n=head2 gene\n\n Title   : gene\n Usage   : my $gene = $map->gene;\n           $map->gene(-gene => $gene);\n Function: Get/set the mappable element on this map that represents the gene\n           this map is for. Once set, it is not recommended to re-set the gene\n           to something else. Behaviour in that case is undefined.\n Returns : Bio::Map::Gene\n Args    : none to get, OR to set:\n           -gene        => Bio::Map::Gene or string of the universal name (see\n                           Bio::Map::Gene docs), REQUIRED\n           -description => string, applied to the Bio::Map::Gene\n           -upstream    => int, the number of bases the map extends before the\n                           start of the gene element (default 1000).\n           -downstream  => int, the number of bases the map extends beyond the\n                           end of the gene element (default 0).\n\n\nsub gene {\n    my ($self, @args) = @_;\n    \n    if (@args > 0) {\n        my ($gene, $desc, $up, $down) = $self->_rearrange([qw(GENE\n                                                    DESCRIPTION\n                                                    UPSTREAM\n                                                    DOWNSTREAM)], @args);\n        $self->throw(\"You must supply -gene\") unless $gene;\n        \n        my $gene_obj = ref($gene) ? $gene : Bio::Map::Gene->get(-universal_name => $gene, -description => $desc);\n        if (defined $self->{gene}) {\n            if ($self->{gene} ne $gene_obj) {\n                $self->warn(\"Changing the gene that this map is for, which could be bad\");\n                $self->purge_positions($self->{gene});\n                delete $GENEMAPS->{by_ns}->{$self->universal_name}->{$self->species};\n                $self->{gene} = $gene_obj;\n            }\n            \n            # change the gene's position on us if necessary\n            $self->upstream($up) if defined $up;\n            $self->downstream($down) if defined $down;\n        }\n        else {\n            # give the gene object a position on us\n            $up ||= 1000;\n            $up >= 0 || $self->throw(\"-upstream must be a positive integer\");\n            Bio::Map::Position->new(-map => $self, -start => ($up + 1), -element => $gene_obj);\n            $self->{gene} = $gene_obj;\n            $self->downstream($down || 0);\n            \n            # set other gene positions from db if already user-requested\n            $gene_obj->_set_from_db($self);\n        }\n        \n        $GENEMAPS->{by_ns}->{$self->universal_name}->{$self->species} = $self;\n    }\n    \n    return $self->{gene};\n}\n\n=head2 universal_name\n\n Title   : universal_name\n Usage   : my $name = $map->universal_name\n Function: Get/set the name of Bio::Map::Gene object associated with this map.\n           It is not recommended to change this once set.\n Returns : string\n Args    : none to get, OR string to set\n\n\nsub universal_name {\n    my ($self, $value) = @_;\n    $self->gene || return;\n    if ($value) {\n        my $species = $self->species;\n        delete $GENEMAPS->{by_ns}->{$self->gene->universal_name}->{$species};\n        $self->gene->universal_name($value);\n        $GENEMAPS->{by_ns}->{$value}->{$species} = $self;\n    }\n    return $self->gene->universal_name;\n}\n\n=head2 upstream\n\n Title   : upstream\n Usage   : my $distance = $map->upstream;\n           $map->upstream($distance);\n Function: Get/set how long the map is before the start of the Bio::Map::Gene\n           object on this map.\n Returns : int\n Args    : none to get, OR int to set (the number of bases the map extends\n           before the start of the gene)\n\n\nsub upstream {\n    my ($self, $value) = @_;\n    \n    my $pos = $self->gene->position($self);\n    if (defined($value)) {\n        $value >= 0 || $self->throw(\"Supplied value must be a positive integer\");\n        $pos->start($value + 1);\n    }\n    \n    return $pos->start - 1;\n}\n\n=head2 downstream\n\n Title   : downstream\n Usage   : my $distance = $map->downstream;\n           $map->downstream($distance);\n Function: Get/set the nominal end of the map relative to the end of the\n           Bio::Map::Gene object on this map.\n Returns : int\n Args    : none to get, OR int to set (the number of bases the map extends\n           beyond the end of the gene)\n\n\nsub downstream {\n    my $self = shift;\n    if (@_) { $self->{_downstream} = shift }\n    return $self->{_downstream} || 0;\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $length = $map->length();\n Function: Retrieves the length of the map. This is normally the length of the\n           upstream region + length of the gene + length of the downstream\n           region, but may be longer if positions have been placed on the map\n           beyond the end of the nominal downstream region.\n Returns : int\n Args    : none\n\n\nsub length {\n\tmy $self = shift;\n\tmy $expected_length = $self->gene->position($self)->length + $self->upstream + $self->downstream;\n    my $actual_length = $self->SUPER::length;\n    return $actual_length > $expected_length ? $actual_length : $expected_length;\n}\n\n=head2 seq\n\n Title   : seq\n Usage   : $string = $obj->seq()\n Function: Get/set the sequence as a string of letters. When getting, If the\n           GeneMap object didn't have sequence attached directly to it for the\n           region requested, the map's gene's database will be asked for the\n           sequence, and failing that, the map's gene's positions will be asked\n           for their sequences. Areas for which no sequence could be found will\n           be filled with Ns, unless no sequence was found anywhere, in which\n           case undef is returned.\n Returns : string\n Args    : Optionally on set the new value (a string). An optional second\n           argument presets the alphabet (otherwise it will be guessed)."},"kind":12,"range":{"start":{"character":0,"line":472},"end":{"line":523,"character":9999}},"line":472},{"name":"SUPER","kind":12,"containerName":"seq","line":474},{"containerName":"length","kind":12,"name":"CORE","line":476},{"line":487,"name":"CORE","kind":12,"containerName":"length"},{"line":492,"name":"adjustment","kind":12},{"kind":12,"name":"adjustment","line":493},{"line":503,"containerName":"length","kind":12,"name":"CORE"},{"containerName":"length","kind":12,"name":"CORE","line":503},{"detail":"($self,$start,$end)","definition":"sub","containerName":"main::","name":"subseq","children":[{"definition":"my","line":548,"kind":13,"localvar":"my","containerName":"subseq","name":"$self"},{"kind":13,"containerName":"subseq","name":"$start","line":548},{"kind":13,"containerName":"subseq","name":"$end","line":548},{"name":"$start","kind":13,"containerName":"subseq","line":550},{"line":550,"containerName":"subseq","kind":13,"name":"$start"},{"line":550,"name":"$start","containerName":"subseq","kind":13},{"line":550,"containerName":"subseq","kind":12,"name":"isa"},{"definition":"my","line":551,"name":"$thing","localvar":"my","containerName":"subseq","kind":13},{"name":"$start","kind":13,"containerName":"subseq","line":551},{"kind":13,"containerName":"subseq","name":"$start","line":552},{"line":552,"name":"isa","kind":12,"containerName":"subseq"},{"line":553,"kind":13,"containerName":"subseq","name":"$start"},{"name":"$end","containerName":"subseq","kind":13,"line":553},{"kind":13,"containerName":"subseq","name":"$thing","line":553},{"name":"start","kind":12,"containerName":"subseq","line":553},{"line":553,"name":"$thing","kind":13,"containerName":"subseq"},{"name":"absolute_relative","kind":12,"containerName":"subseq","line":553},{"line":553,"name":"$thing","containerName":"subseq","kind":13},{"line":553,"kind":12,"containerName":"subseq","name":"end"},{"name":"$thing","containerName":"subseq","kind":13,"line":553},{"name":"absolute_relative","kind":12,"containerName":"subseq","line":553},{"line":556,"name":"$start","containerName":"subseq","kind":13},{"name":"$end","kind":13,"containerName":"subseq","line":556},{"name":"$thing","kind":13,"containerName":"subseq","line":556},{"containerName":"subseq","kind":12,"name":"start","line":556},{"containerName":"subseq","kind":13,"name":"$thing","line":556},{"name":"end","kind":12,"containerName":"subseq","line":556},{"line":562,"localvar":"my","containerName":"subseq","kind":13,"name":"$orig_seq","definition":"my"},{"line":562,"kind":13,"containerName":"subseq","name":"$self"},{"line":563,"kind":13,"containerName":"subseq","name":"$self"},{"name":"$self","kind":13,"containerName":"subseq","line":563},{"line":563,"containerName":"subseq","kind":12,"name":"seq"},{"definition":"my","line":564,"name":"$subseq","localvar":"my","kind":13,"containerName":"subseq"},{"kind":13,"containerName":"subseq","name":"$self","line":564},{"containerName":"subseq","kind":13,"name":"$self","line":564},{"line":564,"kind":13,"containerName":"subseq","name":"$start"},{"name":"$end","containerName":"subseq","kind":13,"line":564},{"line":565,"name":"$self","containerName":"subseq","kind":13},{"line":565,"containerName":"subseq","kind":13,"name":"$orig_seq"},{"line":567,"name":"$subseq","kind":13,"containerName":"subseq"}],"signature":{"label":"subseq($self,$start,$end)","parameters":[{"label":"$self"},{"label":"$start"},{"label":"$end"}],"documentation":"1;\n# $Id: GeneMap.pm,v 1.17 2006/07/17 14:16:53 sendu Exp $\n#\n# BioPerl module for Bio::Map::GeneMap\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::GeneMap - A MapI implementation to represent the area around a gene\n\n=head1 SYNOPSIS\n\n    use Bio::Map::GeneMap;\n    use Bio::Map::Gene;\n    use Bio::Map::TranscriptionFactor;\n    use Bio::Map::GeneRelative;\n\n\t# make some maps that will represent an area around a particular gene in\n\t# particular species (by default, the map represents the area in the genome\n    # 1000bp upstream of the gene)\n    my $map1 = Bio::Map::GeneMap->get(-gene => 'BRCA2',\n                                      -species => 'human',\n                                      -description => 'breast cancer 2, early onset');\n\tmy $map2 = Bio::Map::GeneMap->get(-gene => 'BRCA2',\n                                      -species => 'mouse');\n\n\t# model a TF that binds 500bp upstream of the BRCA2 gene in humans and\n\t# 250bp upstream of BRCA2 in mice\n\tmy $rel = Bio::Map::GeneRelative->new(-description => \"gene start\");\n    my $tf = Bio::Map::TranscriptionFactor->get(-universal_name => 'tf1');\n\tBio::Map::Position->new(-map => $map1,\n                            -element => $tf,\n                            -start => -500,\n                            -length => 10,\n                            -relative => $rel);\n\tBio::Map::Position->new(-map => $map2,\n                            -element => $tf,\n                            -start => -250,\n                            -length => 10,\n                            -relative => $rel);\n\n\t# find out all the things that map near BRCA2 in all species\n\tforeach my $map ($gene->known_maps) {\n\t\tforeach my $thing ($map->get_elements) {\n            next if $thing eq $gene;\n            foreach my $pos ($thing->get_positions($map)) {\n                print \"In species \", $map->species, \", \",\n                      $thing->universal_name, \" maps at \", $pos->value,\n                      \" relative to \", $pos->relative->description, \" of gene \",\n                      $gene->universal_name, \"\\n\";\n            }\n\t\t}\n\t}\n    \n    # a GeneMap isa PrimarySeq and so can have sequence associated with it\n    $map1->seq('ATGC');\n    my $subseq = $map1->subseq(2,3); # TG\n\n=head1 DESCRIPTION\n\nModel the abstract notion of the area around a gene - you don't care exactly\nwhere this area is in the genome, you just want to be able to say \"something\nbinds upstream of gene X\" and \"something else binds 20bp upstream of the first\nsomething\" etc.\n\nIt's useful for modelling transcription factor bindings sites, letting you find\nout which transcription factors bind near a gene of interest, or which genes\nare bound by a transcription factor of interest.\n\nSee t/Map/Map.t for more example usage.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::GeneMap;\nuse strict;\n\nuse Bio::Map::Gene;\nuse Bio::Map::Position;\n\nuse base qw(Bio::Map::SimpleMap Bio::PrimarySeq);\n\nour $GENEMAPS = {};\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Map::GeneMap->new();\n Function: Builds a new Bio::Map::GeneMap object (that has placed on it a\n           mappable element (Bio::Map::Gene) representing a gene).\n Returns : Bio::Map::GeneMap\n Args    : -gene        => string name of the gene this map will be for\n                           (in a form common to all species that have the gene,\n                           but unique amongst non-orthologous genes) or a\n                           Bio::Map::Gene object, REQUIRED\n           -species     => Bio::Taxon or string representing species, REQUIRED\n           -uid         => string, unique identifier for this map (must be\n                           unique amongst all gene/species combinations)\n           -description => string, free text description of the gene\n           -upstream    => int, the number of bases the map extends before the\n                           start of the gene element (default 1000).\n           -downstream  => int, the number of bases the map extends beyond the\n                           end of the gene element (default 0).\n           -seq         => string, the sequence of the map, presumably the\n                           genomic sequence -upstream bases of the gene,\n                           including the gene, and -downstream bases of the gene\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($uid, $gene, $species, $desc, $up, $down, $seq) = $self->_rearrange([qw(UID\n                                                    GENE\n                                                    SPECIES\n                                                    DESCRIPTION\n                                                    UPSTREAM\n                                                    DOWNSTREAM\n                                                    SEQ)], @args);\n    \n    unless (defined $gene && defined $species) {\n        $self->throw(\"You must supply both -species and -gene\");\n    }\n    \n    $self->gene(-gene => $gene, -description => $desc, -upstream => $up, -downstream => $down);\n    $self->seq($seq) if $seq;\n    \n    unless (defined($uid)) {\n        # trigger the special behaviour in our unique_id method by supplying it\n        # the unique_id we got from our parent class\n        $self->unique_id($self->unique_id);\n    }\n    \n    return $self;\n}\n\n=head2 get\n\n Title   : get\n Usage   : my $map = Bio::Map::GeneMap->get();\n Function: Builds a new Bio::Map::GeneMap object (like new()), or gets a\n           pre-existing one that corresponds to your arguements.\n Returns : Bio::Map::GeneMap\n Args    : -gene        => string name of the gene this map will be for\n                           (in a form common to all species that have the gene,\n                           but unique amongst non-orthologous genes) or a\n                           Bio::Map::Gene object, REQUIRED\n           -species     => Bio::Taxon or string representing species, REQUIRED\n           -uid         => string, unique identifier for this map (must be\n                           unique amongst all gene/species combinations)\n           -description => string, free text description of the gene\n           -upstream    => int, the number of bases the map extends before the\n                           start of the gene element (default 1000).\n           -downstream  => int, the number of bases the map extends beyond the\n                           end of the gene element (default 0).\n           -seq         => string, the sequence of the map, presumably the\n                           genomic sequence -upstream bases of the gene,\n                           including the gene, and -downstream bases of the gene\n\n           If you supply a -uid, and a map had previously been created and\n           given that uid, that same map object will be returned. Otherwise, the\n           combination of -gene and -species will be used to determine\n           if the same map had previously been made. If a corresponding map\n           hadn't previously been made, a new map object will be created and\n           returned.\n\n\nsub get {\n    my ($class, @args) = @_;\n    my ($uid, $gene, $species, $desc, $up, $down, $seq) = Bio::Root::Root->_rearrange([qw(UID\n                                                    GENE\n                                                    SPECIES\n                                                    DESCRIPTION\n                                                    UPSTREAM\n                                                    DOWNSTREAM\n                                                    SEQ)], @args);\n    \n    my $gene_map;\n    if ($uid && defined $GENEMAPS->{by_uid}->{$uid}) {\n        $gene_map = $GENEMAPS->{by_uid}->{$uid};\n    }\n    elsif ($gene && $species) {\n        my $name = ref($gene) ? $gene->universal_name : $gene;\n        if (defined $GENEMAPS->{by_ns}->{$name}->{$species}) {\n            $gene_map = $GENEMAPS->{by_ns}->{$name}->{$species};\n        }\n    }\n    if ($gene_map) {\n        $gene_map->gene->description($desc) if $desc;\n        $gene_map->upstream($up) if defined($up);\n        $gene_map->downstream($down) if defined($down);\n        $gene_map->seq($seq) if $seq;\n        return $gene_map;\n    }\n    \n    return $class->new(@args);\n}\n\n=head2 unique_id\n\n Title   : unique_id\n Usage   : my $id = $map->unique_id;\n Function: Get/set the unique ID for this map\n Returns : string\n Args    : none to get, OR string to set\n\n\nsub unique_id {\n    my ($self, $id) = @_;\n    if (defined $id) {\n        delete $GENEMAPS->{by_uid}->{$self->{'_uid'}};\n        $self->{'_uid'} = $id;\n        $GENEMAPS->{by_uid}->{$id} = $self;\n    }\n    return $self->{'_uid'};\n}\n\n=head2 species\n\n Title   : species\n Usage   : my $species = $map->species;\n Function: Get/set Species for a map. It is not recommended to change this once\n           set.\n Returns : Bio::Taxon object or string\n Args    : none to get, OR Bio::Taxon or string to set\n\n\nsub species {\n    my ($self, $value) = @_;\n    if ($value) {\n        my $old_species = $self->{_species};\n        $self->{'_species'} = $value;\n        my $name = $self->universal_name || return $value;\n        if ($old_species) {\n            delete $GENEMAPS->{by_ns}->{$name}->{$old_species};\n        }\n        $GENEMAPS->{by_ns}->{$name}->{$value} = $self;\n    }\n    return $self->{'_species'};\n}\n\n=head2 type\n\n Title   : type\n Usage   : my $type = $map->type\n Function: Get Map type\n Returns : string 'gene'\n Args    : none\n\n\nsub type {\n    return 'gene';\n}\n\n=head2 gene\n\n Title   : gene\n Usage   : my $gene = $map->gene;\n           $map->gene(-gene => $gene);\n Function: Get/set the mappable element on this map that represents the gene\n           this map is for. Once set, it is not recommended to re-set the gene\n           to something else. Behaviour in that case is undefined.\n Returns : Bio::Map::Gene\n Args    : none to get, OR to set:\n           -gene        => Bio::Map::Gene or string of the universal name (see\n                           Bio::Map::Gene docs), REQUIRED\n           -description => string, applied to the Bio::Map::Gene\n           -upstream    => int, the number of bases the map extends before the\n                           start of the gene element (default 1000).\n           -downstream  => int, the number of bases the map extends beyond the\n                           end of the gene element (default 0).\n\n\nsub gene {\n    my ($self, @args) = @_;\n    \n    if (@args > 0) {\n        my ($gene, $desc, $up, $down) = $self->_rearrange([qw(GENE\n                                                    DESCRIPTION\n                                                    UPSTREAM\n                                                    DOWNSTREAM)], @args);\n        $self->throw(\"You must supply -gene\") unless $gene;\n        \n        my $gene_obj = ref($gene) ? $gene : Bio::Map::Gene->get(-universal_name => $gene, -description => $desc);\n        if (defined $self->{gene}) {\n            if ($self->{gene} ne $gene_obj) {\n                $self->warn(\"Changing the gene that this map is for, which could be bad\");\n                $self->purge_positions($self->{gene});\n                delete $GENEMAPS->{by_ns}->{$self->universal_name}->{$self->species};\n                $self->{gene} = $gene_obj;\n            }\n            \n            # change the gene's position on us if necessary\n            $self->upstream($up) if defined $up;\n            $self->downstream($down) if defined $down;\n        }\n        else {\n            # give the gene object a position on us\n            $up ||= 1000;\n            $up >= 0 || $self->throw(\"-upstream must be a positive integer\");\n            Bio::Map::Position->new(-map => $self, -start => ($up + 1), -element => $gene_obj);\n            $self->{gene} = $gene_obj;\n            $self->downstream($down || 0);\n            \n            # set other gene positions from db if already user-requested\n            $gene_obj->_set_from_db($self);\n        }\n        \n        $GENEMAPS->{by_ns}->{$self->universal_name}->{$self->species} = $self;\n    }\n    \n    return $self->{gene};\n}\n\n=head2 universal_name\n\n Title   : universal_name\n Usage   : my $name = $map->universal_name\n Function: Get/set the name of Bio::Map::Gene object associated with this map.\n           It is not recommended to change this once set.\n Returns : string\n Args    : none to get, OR string to set\n\n\nsub universal_name {\n    my ($self, $value) = @_;\n    $self->gene || return;\n    if ($value) {\n        my $species = $self->species;\n        delete $GENEMAPS->{by_ns}->{$self->gene->universal_name}->{$species};\n        $self->gene->universal_name($value);\n        $GENEMAPS->{by_ns}->{$value}->{$species} = $self;\n    }\n    return $self->gene->universal_name;\n}\n\n=head2 upstream\n\n Title   : upstream\n Usage   : my $distance = $map->upstream;\n           $map->upstream($distance);\n Function: Get/set how long the map is before the start of the Bio::Map::Gene\n           object on this map.\n Returns : int\n Args    : none to get, OR int to set (the number of bases the map extends\n           before the start of the gene)\n\n\nsub upstream {\n    my ($self, $value) = @_;\n    \n    my $pos = $self->gene->position($self);\n    if (defined($value)) {\n        $value >= 0 || $self->throw(\"Supplied value must be a positive integer\");\n        $pos->start($value + 1);\n    }\n    \n    return $pos->start - 1;\n}\n\n=head2 downstream\n\n Title   : downstream\n Usage   : my $distance = $map->downstream;\n           $map->downstream($distance);\n Function: Get/set the nominal end of the map relative to the end of the\n           Bio::Map::Gene object on this map.\n Returns : int\n Args    : none to get, OR int to set (the number of bases the map extends\n           beyond the end of the gene)\n\n\nsub downstream {\n    my $self = shift;\n    if (@_) { $self->{_downstream} = shift }\n    return $self->{_downstream} || 0;\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $length = $map->length();\n Function: Retrieves the length of the map. This is normally the length of the\n           upstream region + length of the gene + length of the downstream\n           region, but may be longer if positions have been placed on the map\n           beyond the end of the nominal downstream region.\n Returns : int\n Args    : none\n\n\nsub length {\n\tmy $self = shift;\n\tmy $expected_length = $self->gene->position($self)->length + $self->upstream + $self->downstream;\n    my $actual_length = $self->SUPER::length;\n    return $actual_length > $expected_length ? $actual_length : $expected_length;\n}\n\n=head2 seq\n\n Title   : seq\n Usage   : $string = $obj->seq()\n Function: Get/set the sequence as a string of letters. When getting, If the\n           GeneMap object didn't have sequence attached directly to it for the\n           region requested, the map's gene's database will be asked for the\n           sequence, and failing that, the map's gene's positions will be asked\n           for their sequences. Areas for which no sequence could be found will\n           be filled with Ns, unless no sequence was found anywhere, in which\n           case undef is returned.\n Returns : string\n Args    : Optionally on set the new value (a string). An optional second\n           argument presets the alphabet (otherwise it will be guessed).\n\n\nsub seq {\n    my ($self, @args) = @_;\n    my $seq = $self->SUPER::seq(@args);\n    my $expected_length = $self->length;\n    if (! $seq || CORE::length($seq) < $expected_length) {\n        my @have = split('', $seq || '');\n        my @result;\n        for (0..($expected_length - 1)) {\n            $result[$_] = shift(@have) || 'N';\n        }\n        \n        # build map sequence by asking gene or positions\n        my @slice_stuff = $self->gene->_get_slice($self);\n        if (@slice_stuff) {\n            my ($slice_adaptor, $slice, $strand) = @slice_stuff;\n            my ($start, $end, $gene_start) = (CORE::length($seq || '') + 1, $expected_length, $self->upstream + 1);\n            \n            # convert map coords to genomic coords\n            my $adjust = $strand == -1 ? $slice->end : $slice->start;\n            my $adjustment = sub { return $strand == -1 ? $adjust - shift() : shift() + $adjust; };\n            my $converted_start = &$adjustment($start - $gene_start);\n            my $converted_end = &$adjustment($end - $gene_start);\n            ($converted_start, $converted_end) = ($converted_end, $converted_start) if $converted_start > $converted_end;\n            \n            # get sequence from a new slice of desired region\n            #*** what happens if desired region starts or ends off end of chromo?...\n            my $new_slice = $slice_adaptor->fetch_by_region($slice->coord_system_name, $slice->seq_region_name, $converted_start, $converted_end);\n            if ($new_slice && (my $seq_str = $new_slice->seq)) {\n                if ($strand == -1) {\n                    $seq_str = $self->_revcom($seq_str);\n                }\n                splice(@result, CORE::length($seq || ''), CORE::length($seq_str), split('', $seq_str));\n            }\n        }\n        else {\n            foreach my $pos ($self->get_positions) {\n                next unless $pos->can('seq');\n                my @pos_seq = split('', $pos->seq(undef, undef, 1) || next);\n                for my $i ($pos->start($pos->absolute_relative)..$pos->end($pos->absolute_relative)) {\n                    $i--;\n                    my $base = shift(@pos_seq);\n                    if ($result[$i] eq 'N') {\n                        $result[$i] = $base;\n                    }\n                }\n            }\n        }\n        \n        $seq = join('', @result);\n    }\n    return $seq;\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10, 40);\n Function: Returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence. If the GeneMap object didn't have sequence\n           attached directly to it for the region requested, the map's gene's\n           database will be asked for the sequence, and failing that, the map's\n           gene's positions will be asked for their sequences. Areas for which\n           no sequence could be found will be filled with Ns, unless no\n           sequence was found anywhere, in which case undef is returned. subseq\n           requests that extend beyond the end of the map will throw.\n Returns : string\n Args    : integer for start position AND integer for end position\n                 OR\n           Bio::LocationI location for subseq (strand honored)\n                 OR\n           Bio::RangeI (eg. a Bio::Map::PositionI)"},"kind":12,"range":{"start":{"line":547,"character":0},"end":{"character":9999,"line":568}},"line":547},{"name":"seq","kind":12,"line":562},{"name":"seq","kind":12,"line":563},{"name":"seq","kind":12,"line":564},{"line":564,"name":"SUPER","containerName":"subseq","kind":12},{"line":565,"kind":12,"name":"seq"},{"signature":{"label":"_revcom($self,$seq)","parameters":[{"label":"$self"},{"label":"$seq"}],"documentation":" quick revcom for strings (silly to create a PrimarySeq just to revcom and then\n return a string again)"},"range":{"end":{"line":578,"character":9999},"start":{"character":0,"line":572}},"kind":12,"line":572,"detail":"($self,$seq)","definition":"sub","containerName":"main::","name":"_revcom","children":[{"definition":"my","localvar":"my","containerName":"_revcom","kind":13,"name":"$self","line":573},{"kind":13,"containerName":"_revcom","name":"$seq","line":573},{"name":"$seq","kind":13,"containerName":"_revcom","line":574},{"line":575,"name":"$seq","containerName":"_revcom","kind":13},{"name":"$seq","containerName":"_revcom","kind":13,"line":575},{"line":576,"name":"$seq","kind":13,"containerName":"_revcom"},{"line":577,"kind":13,"containerName":"_revcom","name":"$seq"}]}],"version":5}