{"version":5,"vars":[{"name":"base","kind":2,"containerName":"","line":111},{"signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: FPCMarker.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::fpcmarker\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gaurav Gupta <gaurav@genome.arizona.edu>\n#\n# Copyright Gaurav Gupta\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::FPCMarker - An central map object representing a marker\n\n=head1 SYNOPSIS\n\n   # get the marker object of $marker from the Bio::Map::FPCMarker\n   my $markerobj = $physical->get_markerobj($marker);\n\n   # acquire all the clones that hit this marker\n   foreach my $clone ($markerobj->each_cloneid()) {\n       print \"   +++$clone\\n\";\n   }\n\n   # find the position of this marker in $contig\n   print \"Position in contig $contig\",\" = \",$markerobj->position($contig),\n         \"\\n\";\n\n   # find the group of the marker\n   print \"Group : \",$markerobj->group();\n\n\nSee L<Bio::Map::Position> and L<Bio::Map::PositionI> for more information.\n\n=head1 DESCRIPTION\n\nThis object handles the notion of a marker.\nThis object is intended to be used by a map parser like fpc.pm.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Gaurav Gupta\n\nEmail gaurav@genome.arizona.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala  bix@sendu.me.uk\n\n=head1 PROJECT LEADERS\n\nJamie Hatfield      jamie@genome.arizona.edu\nDr. Cari Soderlund  cari@genome.arizona.edu\n\n=head1 PROJECT DESCRIPTION\n\nThe project was done in Arizona Genomics Computational Laboratory (AGCoL)\nat University of Arizona.\n\nThis work was funded by USDA-IFAFS grant #11180 titled \"Web Resources for \nthe Computation and Display of Physical Mapping Data\".\n\nFor more information on this project, please refer: \n  http://www.genome.arizona.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::FPCMarker;\nuse strict;\nuse Bio::Map::Position;\nuse Time::Local;\n\nuse base qw(Bio::Root::Root Bio::Map::MappableI);\n\n=head2 new\n\n Title   : new\n Usage   : my $clone = Bio::Map::FPCMarker->new\n                      (\n\t\t       -name    => $marker,\n\t\t       -type    => $type,\n\t\t       -global  => $global,\n\t\t       -frame   => $frame,\n\t\t       -group   => $group,\n\t\t       -subgroup=> $subgroup,\n\t\t       -anchor  => $anchor,\n\t\t       -clones  => \\%clones,\n\t\t       -contigs => \\%contigs,\n\t\t       -position => \\%markerpos,\n               -remark => $remark\n\t\t       );\n\n Function: Initialize a new Bio::Map::FPCMarker object\n           Most people will not use this directly but get Markers\n           through L<Bio::MapIO::fpc>\n Returns : L<Bio::Map::FPCMarker> object\n Args    : -name     => marker name string,\n\t       -type     => type string,\n\t       -global   => global position for marker,\n\t       -frame    => boolean if marker is framework or placement,\n\t       -group    => group number for marker,\n\t       -subgroup => subgroup number of marker,\n\t       -anchor   => boolean if marker is anchored,\n\t       -clones   => all the clone elements in map (hashref),\n\t       -contigs  => all the contig elements (hasref),\n\t       -position => mapping of marker names to map position (hasref),\n           -remark   => remarks, separated by newlines","label":"new($class,@args)"},"range":{"start":{"line":149,"character":0},"end":{"character":9999,"line":172}},"kind":12,"line":149,"detail":"($class,@args)","definition":"sub","containerName":"main::","name":"new","children":[{"line":150,"localvar":"my","containerName":"new","kind":13,"name":"$class","definition":"my"},{"containerName":"new","kind":13,"name":"@args","line":150},{"definition":"my","containerName":"new","localvar":"my","kind":13,"name":"$self","line":151},{"line":151,"containerName":"new","kind":13,"name":"$class"},{"line":151,"containerName":"new","kind":13,"name":"@args"},{"definition":"my","name":"$name","kind":13,"localvar":"my","containerName":"new","line":153},{"line":153,"kind":13,"containerName":"new","name":"$type"},{"line":153,"name":"$global","containerName":"new","kind":13},{"name":"$frame","containerName":"new","kind":13,"line":153},{"line":153,"kind":13,"containerName":"new","name":"$group"},{"line":154,"kind":13,"containerName":"new","name":"$subgroup"},{"line":154,"containerName":"new","kind":13,"name":"$anchor"},{"line":154,"containerName":"new","kind":13,"name":"$clones"},{"line":154,"kind":13,"containerName":"new","name":"$contigs"},{"kind":13,"containerName":"new","name":"$positions","line":155},{"line":155,"kind":13,"containerName":"new","name":"$remark"},{"name":"$self","kind":13,"containerName":"new","line":155},{"line":155,"name":"_rearrange","containerName":"new","kind":12},{"kind":13,"containerName":"new","name":"@args","line":157},{"kind":13,"containerName":"new","name":"$self","line":159},{"line":159,"name":"name","kind":12,"containerName":"new"},{"name":"$name","kind":13,"containerName":"new","line":159},{"line":159,"kind":13,"containerName":"new","name":"$name"},{"line":160,"containerName":"new","kind":13,"name":"$self"},{"line":160,"containerName":"new","kind":12,"name":"type"},{"kind":13,"containerName":"new","name":"$type","line":160},{"kind":13,"containerName":"new","name":"$type","line":160},{"line":161,"name":"$self","kind":13,"containerName":"new"},{"containerName":"new","kind":12,"name":"global","line":161},{"name":"$global","containerName":"new","kind":13,"line":161},{"line":161,"name":"$global","kind":13,"containerName":"new"},{"containerName":"new","kind":13,"name":"$self","line":162},{"line":162,"name":"group","containerName":"new","kind":12},{"line":162,"name":"$group","containerName":"new","kind":13},{"line":162,"kind":13,"containerName":"new","name":"$group"},{"name":"$self","kind":13,"containerName":"new","line":163},{"name":"subgroup","kind":12,"containerName":"new","line":163},{"name":"$group","kind":13,"containerName":"new","line":163},{"line":163,"name":"$subgroup","containerName":"new","kind":13},{"line":164,"name":"$self","kind":13,"containerName":"new"},{"line":164,"kind":12,"containerName":"new","name":"anchor"},{"line":164,"name":"$anchor","containerName":"new","kind":13},{"line":164,"containerName":"new","kind":13,"name":"$anchor"},{"name":"$self","kind":13,"containerName":"new","line":165},{"name":"remark","kind":12,"containerName":"new","line":165},{"line":165,"name":"$remark","kind":13,"containerName":"new"},{"name":"$remark","kind":13,"containerName":"new","line":165},{"line":167,"name":"$self","kind":13,"containerName":"new"},{"name":"set_clones","containerName":"new","kind":12,"line":167},{"line":167,"name":"$clones","containerName":"new","kind":13},{"line":167,"name":"$clones","containerName":"new","kind":13},{"containerName":"new","kind":13,"name":"$self","line":168},{"line":168,"kind":12,"containerName":"new","name":"set_contigs"},{"line":168,"kind":13,"containerName":"new","name":"$contigs"},{"kind":13,"containerName":"new","name":"$contigs","line":168},{"line":169,"name":"$self","kind":13,"containerName":"new"},{"line":169,"name":"set_positions","kind":12,"containerName":"new"},{"containerName":"new","kind":13,"name":"$positions","line":169},{"line":169,"name":"$positions","kind":13,"containerName":"new"},{"kind":13,"containerName":"new","name":"$self","line":171}]},{"containerName":"new","kind":12,"name":"SUPER","line":151},{"children":[{"name":"$self","localvar":"my","containerName":"name","kind":13,"line":189,"definition":"my"},{"line":190,"name":"$self","kind":13,"containerName":"name"},{"containerName":"name","kind":13,"name":"$self","line":191}],"name":"name","containerName":"main::","definition":"sub","line":188,"range":{"end":{"line":192,"character":9999},"start":{"character":0,"line":188}},"kind":12},{"range":{"start":{"character":0,"line":204},"end":{"character":9999,"line":208}},"kind":12,"line":204,"containerName":"main::","name":"type","children":[{"definition":"my","line":205,"localvar":"my","containerName":"type","kind":13,"name":"$self"},{"line":206,"kind":13,"containerName":"type","name":"$self"},{"kind":13,"containerName":"type","name":"$self","line":207}],"definition":"sub"},{"line":220,"kind":12,"range":{"end":{"line":224,"character":9999},"start":{"character":0,"line":220}},"definition":"sub","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"global","line":221},{"kind":13,"containerName":"global","name":"$self","line":222},{"line":223,"name":"$self","kind":13,"containerName":"global"}],"name":"global","containerName":"main::"},{"line":236,"kind":12,"range":{"start":{"character":0,"line":236},"end":{"character":9999,"line":240}},"children":[{"definition":"my","line":237,"name":"$self","kind":13,"localvar":"my","containerName":"anchor"},{"line":238,"kind":13,"containerName":"anchor","name":"$self"},{"line":239,"name":"$self","containerName":"anchor","kind":13}],"name":"anchor","containerName":"main::","definition":"sub"},{"definition":"sub","children":[{"line":254,"name":"$self","localvar":"my","containerName":"framework","kind":13,"definition":"my"},{"line":255,"name":"$self","kind":13,"containerName":"framework"},{"containerName":"framework","kind":13,"name":"$self","line":256}],"name":"framework","containerName":"main::","line":253,"range":{"end":{"character":9999,"line":257},"start":{"line":253,"character":0}},"kind":12},{"definition":"sub","children":[{"localvar":"my","containerName":"group","kind":13,"name":"$self","line":271,"definition":"my"},{"line":272,"kind":13,"containerName":"group","name":"$self"},{"name":"$self","containerName":"group","kind":13,"line":273}],"containerName":"main::","name":"group","line":270,"range":{"start":{"character":0,"line":270},"end":{"line":274,"character":9999}},"kind":12},{"kind":12,"range":{"start":{"line":289,"character":0},"end":{"line":293,"character":9999}},"line":289,"definition":"sub","containerName":"main::","name":"subgroup","children":[{"definition":"my","containerName":"subgroup","localvar":"my","kind":13,"name":"$self","line":290},{"name":"$self","kind":13,"containerName":"subgroup","line":291},{"name":"$self","containerName":"subgroup","kind":13,"line":292}]},{"containerName":"main::","name":"position","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"position","kind":13,"line":310},{"name":"$ctg","containerName":"position","kind":13,"line":310},{"name":"$ctg","kind":13,"containerName":"position","line":311},{"name":"$self","kind":13,"containerName":"position","line":313},{"kind":13,"containerName":"position","name":"$self","line":314},{"name":"$ctg","containerName":"position","kind":13,"line":314},{"line":315,"name":"$self","containerName":"position","kind":13},{"line":315,"name":"$ctg","containerName":"position","kind":13}],"detail":"($self,$ctg)","definition":"sub","range":{"start":{"character":0,"line":309},"end":{"line":316,"character":9999}},"kind":12,"line":309,"signature":{"documentation":"1;\n# $Id: FPCMarker.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::fpcmarker\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gaurav Gupta <gaurav@genome.arizona.edu>\n#\n# Copyright Gaurav Gupta\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::FPCMarker - An central map object representing a marker\n\n=head1 SYNOPSIS\n\n   # get the marker object of $marker from the Bio::Map::FPCMarker\n   my $markerobj = $physical->get_markerobj($marker);\n\n   # acquire all the clones that hit this marker\n   foreach my $clone ($markerobj->each_cloneid()) {\n       print \"   +++$clone\\n\";\n   }\n\n   # find the position of this marker in $contig\n   print \"Position in contig $contig\",\" = \",$markerobj->position($contig),\n         \"\\n\";\n\n   # find the group of the marker\n   print \"Group : \",$markerobj->group();\n\n\nSee L<Bio::Map::Position> and L<Bio::Map::PositionI> for more information.\n\n=head1 DESCRIPTION\n\nThis object handles the notion of a marker.\nThis object is intended to be used by a map parser like fpc.pm.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Gaurav Gupta\n\nEmail gaurav@genome.arizona.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala  bix@sendu.me.uk\n\n=head1 PROJECT LEADERS\n\nJamie Hatfield      jamie@genome.arizona.edu\nDr. Cari Soderlund  cari@genome.arizona.edu\n\n=head1 PROJECT DESCRIPTION\n\nThe project was done in Arizona Genomics Computational Laboratory (AGCoL)\nat University of Arizona.\n\nThis work was funded by USDA-IFAFS grant #11180 titled \"Web Resources for \nthe Computation and Display of Physical Mapping Data\".\n\nFor more information on this project, please refer: \n  http://www.genome.arizona.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::FPCMarker;\nuse strict;\nuse Bio::Map::Position;\nuse Time::Local;\n\nuse base qw(Bio::Root::Root Bio::Map::MappableI);\n\n=head2 new\n\n Title   : new\n Usage   : my $clone = Bio::Map::FPCMarker->new\n                      (\n\t\t       -name    => $marker,\n\t\t       -type    => $type,\n\t\t       -global  => $global,\n\t\t       -frame   => $frame,\n\t\t       -group   => $group,\n\t\t       -subgroup=> $subgroup,\n\t\t       -anchor  => $anchor,\n\t\t       -clones  => \\%clones,\n\t\t       -contigs => \\%contigs,\n\t\t       -position => \\%markerpos,\n               -remark => $remark\n\t\t       );\n\n Function: Initialize a new Bio::Map::FPCMarker object\n           Most people will not use this directly but get Markers\n           through L<Bio::MapIO::fpc>\n Returns : L<Bio::Map::FPCMarker> object\n Args    : -name     => marker name string,\n\t       -type     => type string,\n\t       -global   => global position for marker,\n\t       -frame    => boolean if marker is framework or placement,\n\t       -group    => group number for marker,\n\t       -subgroup => subgroup number of marker,\n\t       -anchor   => boolean if marker is anchored,\n\t       -clones   => all the clone elements in map (hashref),\n\t       -contigs  => all the contig elements (hasref),\n\t       -position => mapping of marker names to map position (hasref),\n           -remark   => remarks, separated by newlines\n\n\nsub new {\n   my ($class,@args) = @_;\n   my $self= $class->SUPER::new(@args);\n\n   my ($name,$type,$global,$frame,$group,\n       $subgroup, $anchor, $clones,$contigs,\n       $positions, $remark) = $self->_rearrange([qw(NAME TYPE GLOBAL FRAME\n\t\t\t\t\t   GROUP SUBGROUP ANCHOR\n\t\t\t\t\t   CLONES CONTIGS POSITIONS REMARK)],@args);\n\n   $self->name($name)                  if defined $name;\n   $self->type($type)                  if defined $type;\n   $self->global($global)              if defined $global;\n   $self->group($group)                if defined $group;\n   $self->subgroup($group)             if defined $subgroup;\n   $self->anchor($anchor)              if defined $anchor;\n   $self->remark($remark)              if defined $remark;\n\n   $self->set_clones($clones)          if defined $clones;\n   $self->set_contigs($contigs)        if defined $contigs;\n   $self->set_positions($positions)    if defined $positions;\n\n   return $self;\n}\n\n=head1 Access Methods\n\nThese methods let you get and set the member variables\n\n=head2 name\n\n Title   : name\n Usage   : my $name = $markerobj->name();\n Function: Get/set the name for this marker\n Returns : scalar representing the current name of this marker\n Args    : none to get, OR string to set\n\n\nsub name {\n    my ($self) = shift;\n    return $self->{'_name'} = shift if @_;\n    return $self->{'_name'};\n}\n\n=head2 type\n\n Title   : type\n Usage   : my $type = $markerobj->type();\n Function: Get/set the type for this marker\n Returns : scalar representing the current type of this marker\n Args    : none to get, OR string to set\n\n\nsub type {\n    my ($self) = shift;\n    return $self->{'_type'} = shift if @_;\n    return $self->{'_type'};\n}\n\n=head2 global\n\n Title   : global\n Usage   : my $type = $markerobj->global();\n Function: Get/set the global position for this marker\n Returns : scalar representing the current global position of this marker\n Args    : none to get, OR string to set\n\n\nsub global {\n    my ($self) = shift;\n    return $self->{'_global'} = shift if @_;\n    return $self->{'_global'};\n}\n\n=head2 anchor\n\n Title   : anchor\n Usage   : my $anchor = $markerobj->anchor();\n Function: indicate if the Marker is anchored or not (True | False)\n Returns : scalar representing the anchor (1 | 0) for this marker\n Args    : none to get, OR 1|0 to set\n\n\nsub anchor {\n    my ($self) = shift;\n    return $self->{'_anchor'} = shift if @_;\n    return $self->{'_anchor'};\n}\n\n=head2 framework\n\n Title   : framework\n Usage   : $frame = $markerobj->framework();\n Function: indicate if the Marker is framework or placement (1 | 0)\n Returns : scalar representing if the marker is framework\n           (1 if framework, 0 if placement)\n Args    : none to get, OR 1|0 to set\n\n\nsub framework {\n    my ($self) = shift;\n    return $self->{'_frame'} = shift if @_;\n    return $self->{'_frame'};\n}\n\n=head2 group\n\n Title   : group\n Usage   : $grpno = $markerobj->group();\n Function: Get/set the group number for this marker. This is a generic term,\n           used for Linkage-Groups as well as for Chromosomes.\n Returns : scalar representing the group number of this marker\n Args    : none to get, OR string to set\n\n\nsub group {\n    my ($self) = shift;\n    $self->{'_group'} = shift if @_;\n    return $self->{'_group'} || 0;\n}\n\n=head2 subgroup\n\n Title   : subgroup\n Usage   : $subgroup = $marker->subgroup();\t\n Function: Get/set the subgroup for this marker. This is a generic term:\n           subgroup here could represent subgroup of a Chromosome or of a\n           Linkage Group. The user must take care of which subgroup he/she is\n           querying for.\t\n Returns : scalar representing the subgroup of this marker\n Args    : none to get, OR string to set\n\n\nsub subgroup {\n    my ($self) = shift;\n    $self->{'_subgroup'} = shift if @_;\n    return $self->{'_subgroup'} || 0;\n}\n\n=head2 position\n\n Title   : position\n Usage   : $markerpos = $markerobj->position($ctg);\n Function: get the position of the marker in the contig\n Returns : scalar representing the position of the markernumber of\n           the contig\n Args    : $ctg is necessary to look for the position of the marker\n           in that contig.\n\n *** This has nothing to do with an actual Bio::Map::PositionI object ***","parameters":[{"label":"$self"},{"label":"$ctg"}],"label":"position($self,$ctg)"}},{"range":{"start":{"line":328,"character":0},"end":{"character":9999,"line":332}},"kind":12,"line":328,"name":"remark","containerName":"main::","children":[{"line":329,"name":"$self","localvar":"my","containerName":"remark","kind":13,"definition":"my"},{"name":"$self","containerName":"remark","kind":13,"line":330},{"name":"$self","kind":13,"containerName":"remark","line":331}],"definition":"sub"},{"children":[{"definition":"my","line":348,"name":"$self","kind":13,"localvar":"my","containerName":"each_cloneid"},{"name":"$self","kind":13,"containerName":"each_cloneid","line":349},{"line":349,"containerName":"each_cloneid","kind":12,"name":"_each_element"}],"name":"each_cloneid","containerName":"main::","definition":"sub","detail":"($self)","line":347,"kind":12,"range":{"start":{"character":0,"line":347},"end":{"character":9999,"line":350}},"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: FPCMarker.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::fpcmarker\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gaurav Gupta <gaurav@genome.arizona.edu>\n#\n# Copyright Gaurav Gupta\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::FPCMarker - An central map object representing a marker\n\n=head1 SYNOPSIS\n\n   # get the marker object of $marker from the Bio::Map::FPCMarker\n   my $markerobj = $physical->get_markerobj($marker);\n\n   # acquire all the clones that hit this marker\n   foreach my $clone ($markerobj->each_cloneid()) {\n       print \"   +++$clone\\n\";\n   }\n\n   # find the position of this marker in $contig\n   print \"Position in contig $contig\",\" = \",$markerobj->position($contig),\n         \"\\n\";\n\n   # find the group of the marker\n   print \"Group : \",$markerobj->group();\n\n\nSee L<Bio::Map::Position> and L<Bio::Map::PositionI> for more information.\n\n=head1 DESCRIPTION\n\nThis object handles the notion of a marker.\nThis object is intended to be used by a map parser like fpc.pm.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Gaurav Gupta\n\nEmail gaurav@genome.arizona.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala  bix@sendu.me.uk\n\n=head1 PROJECT LEADERS\n\nJamie Hatfield      jamie@genome.arizona.edu\nDr. Cari Soderlund  cari@genome.arizona.edu\n\n=head1 PROJECT DESCRIPTION\n\nThe project was done in Arizona Genomics Computational Laboratory (AGCoL)\nat University of Arizona.\n\nThis work was funded by USDA-IFAFS grant #11180 titled \"Web Resources for \nthe Computation and Display of Physical Mapping Data\".\n\nFor more information on this project, please refer: \n  http://www.genome.arizona.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::FPCMarker;\nuse strict;\nuse Bio::Map::Position;\nuse Time::Local;\n\nuse base qw(Bio::Root::Root Bio::Map::MappableI);\n\n=head2 new\n\n Title   : new\n Usage   : my $clone = Bio::Map::FPCMarker->new\n                      (\n\t\t       -name    => $marker,\n\t\t       -type    => $type,\n\t\t       -global  => $global,\n\t\t       -frame   => $frame,\n\t\t       -group   => $group,\n\t\t       -subgroup=> $subgroup,\n\t\t       -anchor  => $anchor,\n\t\t       -clones  => \\%clones,\n\t\t       -contigs => \\%contigs,\n\t\t       -position => \\%markerpos,\n               -remark => $remark\n\t\t       );\n\n Function: Initialize a new Bio::Map::FPCMarker object\n           Most people will not use this directly but get Markers\n           through L<Bio::MapIO::fpc>\n Returns : L<Bio::Map::FPCMarker> object\n Args    : -name     => marker name string,\n\t       -type     => type string,\n\t       -global   => global position for marker,\n\t       -frame    => boolean if marker is framework or placement,\n\t       -group    => group number for marker,\n\t       -subgroup => subgroup number of marker,\n\t       -anchor   => boolean if marker is anchored,\n\t       -clones   => all the clone elements in map (hashref),\n\t       -contigs  => all the contig elements (hasref),\n\t       -position => mapping of marker names to map position (hasref),\n           -remark   => remarks, separated by newlines\n\n\nsub new {\n   my ($class,@args) = @_;\n   my $self= $class->SUPER::new(@args);\n\n   my ($name,$type,$global,$frame,$group,\n       $subgroup, $anchor, $clones,$contigs,\n       $positions, $remark) = $self->_rearrange([qw(NAME TYPE GLOBAL FRAME\n\t\t\t\t\t   GROUP SUBGROUP ANCHOR\n\t\t\t\t\t   CLONES CONTIGS POSITIONS REMARK)],@args);\n\n   $self->name($name)                  if defined $name;\n   $self->type($type)                  if defined $type;\n   $self->global($global)              if defined $global;\n   $self->group($group)                if defined $group;\n   $self->subgroup($group)             if defined $subgroup;\n   $self->anchor($anchor)              if defined $anchor;\n   $self->remark($remark)              if defined $remark;\n\n   $self->set_clones($clones)          if defined $clones;\n   $self->set_contigs($contigs)        if defined $contigs;\n   $self->set_positions($positions)    if defined $positions;\n\n   return $self;\n}\n\n=head1 Access Methods\n\nThese methods let you get and set the member variables\n\n=head2 name\n\n Title   : name\n Usage   : my $name = $markerobj->name();\n Function: Get/set the name for this marker\n Returns : scalar representing the current name of this marker\n Args    : none to get, OR string to set\n\n\nsub name {\n    my ($self) = shift;\n    return $self->{'_name'} = shift if @_;\n    return $self->{'_name'};\n}\n\n=head2 type\n\n Title   : type\n Usage   : my $type = $markerobj->type();\n Function: Get/set the type for this marker\n Returns : scalar representing the current type of this marker\n Args    : none to get, OR string to set\n\n\nsub type {\n    my ($self) = shift;\n    return $self->{'_type'} = shift if @_;\n    return $self->{'_type'};\n}\n\n=head2 global\n\n Title   : global\n Usage   : my $type = $markerobj->global();\n Function: Get/set the global position for this marker\n Returns : scalar representing the current global position of this marker\n Args    : none to get, OR string to set\n\n\nsub global {\n    my ($self) = shift;\n    return $self->{'_global'} = shift if @_;\n    return $self->{'_global'};\n}\n\n=head2 anchor\n\n Title   : anchor\n Usage   : my $anchor = $markerobj->anchor();\n Function: indicate if the Marker is anchored or not (True | False)\n Returns : scalar representing the anchor (1 | 0) for this marker\n Args    : none to get, OR 1|0 to set\n\n\nsub anchor {\n    my ($self) = shift;\n    return $self->{'_anchor'} = shift if @_;\n    return $self->{'_anchor'};\n}\n\n=head2 framework\n\n Title   : framework\n Usage   : $frame = $markerobj->framework();\n Function: indicate if the Marker is framework or placement (1 | 0)\n Returns : scalar representing if the marker is framework\n           (1 if framework, 0 if placement)\n Args    : none to get, OR 1|0 to set\n\n\nsub framework {\n    my ($self) = shift;\n    return $self->{'_frame'} = shift if @_;\n    return $self->{'_frame'};\n}\n\n=head2 group\n\n Title   : group\n Usage   : $grpno = $markerobj->group();\n Function: Get/set the group number for this marker. This is a generic term,\n           used for Linkage-Groups as well as for Chromosomes.\n Returns : scalar representing the group number of this marker\n Args    : none to get, OR string to set\n\n\nsub group {\n    my ($self) = shift;\n    $self->{'_group'} = shift if @_;\n    return $self->{'_group'} || 0;\n}\n\n=head2 subgroup\n\n Title   : subgroup\n Usage   : $subgroup = $marker->subgroup();\t\n Function: Get/set the subgroup for this marker. This is a generic term:\n           subgroup here could represent subgroup of a Chromosome or of a\n           Linkage Group. The user must take care of which subgroup he/she is\n           querying for.\t\n Returns : scalar representing the subgroup of this marker\n Args    : none to get, OR string to set\n\n\nsub subgroup {\n    my ($self) = shift;\n    $self->{'_subgroup'} = shift if @_;\n    return $self->{'_subgroup'} || 0;\n}\n\n=head2 position\n\n Title   : position\n Usage   : $markerpos = $markerobj->position($ctg);\n Function: get the position of the marker in the contig\n Returns : scalar representing the position of the markernumber of\n           the contig\n Args    : $ctg is necessary to look for the position of the marker\n           in that contig.\n\n *** This has nothing to do with an actual Bio::Map::PositionI object ***\n\n\nsub position {\n    my ($self,$ctg) = @_;\n    return 0 unless defined $ctg;\n\n    return 0 unless( defined $self->{'_position'} &&\n\t\t     defined $self->{'_position'}{$ctg});\n    return $self->{'_position'}{$ctg};\n}\n\n=head2 remark\n\n Title   : remark\n Usage   : $markerremark = $markerobj->remark();\n Function: get the remarks for this marker\n Returns : scalar of newline-separated markers\n Args    : none\n\n\nsub remark {\n    my ($self) = shift;\n    return $self->{'_remark'} = shift if @_;\n    return $self->{'_remark'};\n}\n\n=head2 each_cloneid\n\n Title   : each_cloneid\n Usage   : my @clones  = $map->each_cloneid();\n Function: retrieves all the clone ids in a map unordered\n Returns : list of strings (ids)\n Args    : none\n\n *** This only supplies the ids set with the set_clones method ***\n *** It has nothing to do with actual Bio::Map::MappableI objects ***","label":"each_cloneid($self)"}},{"kind":12,"range":{"start":{"line":365,"character":0},"end":{"line":368,"character":9999}},"line":365,"signature":{"label":"each_contigid($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: FPCMarker.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::fpcmarker\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gaurav Gupta <gaurav@genome.arizona.edu>\n#\n# Copyright Gaurav Gupta\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::FPCMarker - An central map object representing a marker\n\n=head1 SYNOPSIS\n\n   # get the marker object of $marker from the Bio::Map::FPCMarker\n   my $markerobj = $physical->get_markerobj($marker);\n\n   # acquire all the clones that hit this marker\n   foreach my $clone ($markerobj->each_cloneid()) {\n       print \"   +++$clone\\n\";\n   }\n\n   # find the position of this marker in $contig\n   print \"Position in contig $contig\",\" = \",$markerobj->position($contig),\n         \"\\n\";\n\n   # find the group of the marker\n   print \"Group : \",$markerobj->group();\n\n\nSee L<Bio::Map::Position> and L<Bio::Map::PositionI> for more information.\n\n=head1 DESCRIPTION\n\nThis object handles the notion of a marker.\nThis object is intended to be used by a map parser like fpc.pm.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Gaurav Gupta\n\nEmail gaurav@genome.arizona.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala  bix@sendu.me.uk\n\n=head1 PROJECT LEADERS\n\nJamie Hatfield      jamie@genome.arizona.edu\nDr. Cari Soderlund  cari@genome.arizona.edu\n\n=head1 PROJECT DESCRIPTION\n\nThe project was done in Arizona Genomics Computational Laboratory (AGCoL)\nat University of Arizona.\n\nThis work was funded by USDA-IFAFS grant #11180 titled \"Web Resources for \nthe Computation and Display of Physical Mapping Data\".\n\nFor more information on this project, please refer: \n  http://www.genome.arizona.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::FPCMarker;\nuse strict;\nuse Bio::Map::Position;\nuse Time::Local;\n\nuse base qw(Bio::Root::Root Bio::Map::MappableI);\n\n=head2 new\n\n Title   : new\n Usage   : my $clone = Bio::Map::FPCMarker->new\n                      (\n\t\t       -name    => $marker,\n\t\t       -type    => $type,\n\t\t       -global  => $global,\n\t\t       -frame   => $frame,\n\t\t       -group   => $group,\n\t\t       -subgroup=> $subgroup,\n\t\t       -anchor  => $anchor,\n\t\t       -clones  => \\%clones,\n\t\t       -contigs => \\%contigs,\n\t\t       -position => \\%markerpos,\n               -remark => $remark\n\t\t       );\n\n Function: Initialize a new Bio::Map::FPCMarker object\n           Most people will not use this directly but get Markers\n           through L<Bio::MapIO::fpc>\n Returns : L<Bio::Map::FPCMarker> object\n Args    : -name     => marker name string,\n\t       -type     => type string,\n\t       -global   => global position for marker,\n\t       -frame    => boolean if marker is framework or placement,\n\t       -group    => group number for marker,\n\t       -subgroup => subgroup number of marker,\n\t       -anchor   => boolean if marker is anchored,\n\t       -clones   => all the clone elements in map (hashref),\n\t       -contigs  => all the contig elements (hasref),\n\t       -position => mapping of marker names to map position (hasref),\n           -remark   => remarks, separated by newlines\n\n\nsub new {\n   my ($class,@args) = @_;\n   my $self= $class->SUPER::new(@args);\n\n   my ($name,$type,$global,$frame,$group,\n       $subgroup, $anchor, $clones,$contigs,\n       $positions, $remark) = $self->_rearrange([qw(NAME TYPE GLOBAL FRAME\n\t\t\t\t\t   GROUP SUBGROUP ANCHOR\n\t\t\t\t\t   CLONES CONTIGS POSITIONS REMARK)],@args);\n\n   $self->name($name)                  if defined $name;\n   $self->type($type)                  if defined $type;\n   $self->global($global)              if defined $global;\n   $self->group($group)                if defined $group;\n   $self->subgroup($group)             if defined $subgroup;\n   $self->anchor($anchor)              if defined $anchor;\n   $self->remark($remark)              if defined $remark;\n\n   $self->set_clones($clones)          if defined $clones;\n   $self->set_contigs($contigs)        if defined $contigs;\n   $self->set_positions($positions)    if defined $positions;\n\n   return $self;\n}\n\n=head1 Access Methods\n\nThese methods let you get and set the member variables\n\n=head2 name\n\n Title   : name\n Usage   : my $name = $markerobj->name();\n Function: Get/set the name for this marker\n Returns : scalar representing the current name of this marker\n Args    : none to get, OR string to set\n\n\nsub name {\n    my ($self) = shift;\n    return $self->{'_name'} = shift if @_;\n    return $self->{'_name'};\n}\n\n=head2 type\n\n Title   : type\n Usage   : my $type = $markerobj->type();\n Function: Get/set the type for this marker\n Returns : scalar representing the current type of this marker\n Args    : none to get, OR string to set\n\n\nsub type {\n    my ($self) = shift;\n    return $self->{'_type'} = shift if @_;\n    return $self->{'_type'};\n}\n\n=head2 global\n\n Title   : global\n Usage   : my $type = $markerobj->global();\n Function: Get/set the global position for this marker\n Returns : scalar representing the current global position of this marker\n Args    : none to get, OR string to set\n\n\nsub global {\n    my ($self) = shift;\n    return $self->{'_global'} = shift if @_;\n    return $self->{'_global'};\n}\n\n=head2 anchor\n\n Title   : anchor\n Usage   : my $anchor = $markerobj->anchor();\n Function: indicate if the Marker is anchored or not (True | False)\n Returns : scalar representing the anchor (1 | 0) for this marker\n Args    : none to get, OR 1|0 to set\n\n\nsub anchor {\n    my ($self) = shift;\n    return $self->{'_anchor'} = shift if @_;\n    return $self->{'_anchor'};\n}\n\n=head2 framework\n\n Title   : framework\n Usage   : $frame = $markerobj->framework();\n Function: indicate if the Marker is framework or placement (1 | 0)\n Returns : scalar representing if the marker is framework\n           (1 if framework, 0 if placement)\n Args    : none to get, OR 1|0 to set\n\n\nsub framework {\n    my ($self) = shift;\n    return $self->{'_frame'} = shift if @_;\n    return $self->{'_frame'};\n}\n\n=head2 group\n\n Title   : group\n Usage   : $grpno = $markerobj->group();\n Function: Get/set the group number for this marker. This is a generic term,\n           used for Linkage-Groups as well as for Chromosomes.\n Returns : scalar representing the group number of this marker\n Args    : none to get, OR string to set\n\n\nsub group {\n    my ($self) = shift;\n    $self->{'_group'} = shift if @_;\n    return $self->{'_group'} || 0;\n}\n\n=head2 subgroup\n\n Title   : subgroup\n Usage   : $subgroup = $marker->subgroup();\t\n Function: Get/set the subgroup for this marker. This is a generic term:\n           subgroup here could represent subgroup of a Chromosome or of a\n           Linkage Group. The user must take care of which subgroup he/she is\n           querying for.\t\n Returns : scalar representing the subgroup of this marker\n Args    : none to get, OR string to set\n\n\nsub subgroup {\n    my ($self) = shift;\n    $self->{'_subgroup'} = shift if @_;\n    return $self->{'_subgroup'} || 0;\n}\n\n=head2 position\n\n Title   : position\n Usage   : $markerpos = $markerobj->position($ctg);\n Function: get the position of the marker in the contig\n Returns : scalar representing the position of the markernumber of\n           the contig\n Args    : $ctg is necessary to look for the position of the marker\n           in that contig.\n\n *** This has nothing to do with an actual Bio::Map::PositionI object ***\n\n\nsub position {\n    my ($self,$ctg) = @_;\n    return 0 unless defined $ctg;\n\n    return 0 unless( defined $self->{'_position'} &&\n\t\t     defined $self->{'_position'}{$ctg});\n    return $self->{'_position'}{$ctg};\n}\n\n=head2 remark\n\n Title   : remark\n Usage   : $markerremark = $markerobj->remark();\n Function: get the remarks for this marker\n Returns : scalar of newline-separated markers\n Args    : none\n\n\nsub remark {\n    my ($self) = shift;\n    return $self->{'_remark'} = shift if @_;\n    return $self->{'_remark'};\n}\n\n=head2 each_cloneid\n\n Title   : each_cloneid\n Usage   : my @clones  = $map->each_cloneid();\n Function: retrieves all the clone ids in a map unordered\n Returns : list of strings (ids)\n Args    : none\n\n *** This only supplies the ids set with the set_clones method ***\n *** It has nothing to do with actual Bio::Map::MappableI objects ***\n\n\nsub each_cloneid {\n    my ($self) = @_;\n    return $self->_each_element('clones');\n}\n\n=head2 each_contigid\n\n Title   : each_contigid\n Usage   : my @contigs = $map->each_contigid();\n Function: retrieves all the contig ids in a map unordered\n Returns : list of strings (ids)\n Args    : none\n\n *** This only supplies the ids set with the set_contigs method ***\n *** It has nothing to do with actual Bio::Map::MapI objects ***"},"name":"each_contigid","containerName":"main::","children":[{"definition":"my","localvar":"my","containerName":"each_contigid","kind":13,"name":"$self","line":366},{"name":"$self","containerName":"each_contigid","kind":13,"line":367},{"line":367,"kind":12,"containerName":"each_contigid","name":"_each_element"}],"detail":"($self)","definition":"sub"},{"definition":"sub","detail":"($self,$type)","children":[{"line":371,"name":"$self","localvar":"my","containerName":"_each_element","kind":13,"definition":"my"},{"line":371,"kind":13,"containerName":"_each_element","name":"$type"},{"name":"$type","containerName":"_each_element","kind":13,"line":373},{"name":"$type","kind":13,"containerName":"_each_element","line":373},{"name":"$type","kind":13,"containerName":"_each_element","line":374},{"name":"$self","kind":13,"containerName":"_each_element","line":376},{"containerName":"_each_element","kind":13,"name":"$type","line":376}],"containerName":"main::","name":"_each_element","signature":{"label":"_each_element($self,$type)","parameters":[{"label":"$self"},{"label":"$type"}],"documentation":""},"line":370,"kind":12,"range":{"end":{"character":9999,"line":376},"start":{"line":370,"character":0}}},{"signature":{"documentation":"1;\n# $Id: FPCMarker.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::fpcmarker\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gaurav Gupta <gaurav@genome.arizona.edu>\n#\n# Copyright Gaurav Gupta\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::FPCMarker - An central map object representing a marker\n\n=head1 SYNOPSIS\n\n   # get the marker object of $marker from the Bio::Map::FPCMarker\n   my $markerobj = $physical->get_markerobj($marker);\n\n   # acquire all the clones that hit this marker\n   foreach my $clone ($markerobj->each_cloneid()) {\n       print \"   +++$clone\\n\";\n   }\n\n   # find the position of this marker in $contig\n   print \"Position in contig $contig\",\" = \",$markerobj->position($contig),\n         \"\\n\";\n\n   # find the group of the marker\n   print \"Group : \",$markerobj->group();\n\n\nSee L<Bio::Map::Position> and L<Bio::Map::PositionI> for more information.\n\n=head1 DESCRIPTION\n\nThis object handles the notion of a marker.\nThis object is intended to be used by a map parser like fpc.pm.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Gaurav Gupta\n\nEmail gaurav@genome.arizona.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala  bix@sendu.me.uk\n\n=head1 PROJECT LEADERS\n\nJamie Hatfield      jamie@genome.arizona.edu\nDr. Cari Soderlund  cari@genome.arizona.edu\n\n=head1 PROJECT DESCRIPTION\n\nThe project was done in Arizona Genomics Computational Laboratory (AGCoL)\nat University of Arizona.\n\nThis work was funded by USDA-IFAFS grant #11180 titled \"Web Resources for \nthe Computation and Display of Physical Mapping Data\".\n\nFor more information on this project, please refer: \n  http://www.genome.arizona.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::FPCMarker;\nuse strict;\nuse Bio::Map::Position;\nuse Time::Local;\n\nuse base qw(Bio::Root::Root Bio::Map::MappableI);\n\n=head2 new\n\n Title   : new\n Usage   : my $clone = Bio::Map::FPCMarker->new\n                      (\n\t\t       -name    => $marker,\n\t\t       -type    => $type,\n\t\t       -global  => $global,\n\t\t       -frame   => $frame,\n\t\t       -group   => $group,\n\t\t       -subgroup=> $subgroup,\n\t\t       -anchor  => $anchor,\n\t\t       -clones  => \\%clones,\n\t\t       -contigs => \\%contigs,\n\t\t       -position => \\%markerpos,\n               -remark => $remark\n\t\t       );\n\n Function: Initialize a new Bio::Map::FPCMarker object\n           Most people will not use this directly but get Markers\n           through L<Bio::MapIO::fpc>\n Returns : L<Bio::Map::FPCMarker> object\n Args    : -name     => marker name string,\n\t       -type     => type string,\n\t       -global   => global position for marker,\n\t       -frame    => boolean if marker is framework or placement,\n\t       -group    => group number for marker,\n\t       -subgroup => subgroup number of marker,\n\t       -anchor   => boolean if marker is anchored,\n\t       -clones   => all the clone elements in map (hashref),\n\t       -contigs  => all the contig elements (hasref),\n\t       -position => mapping of marker names to map position (hasref),\n           -remark   => remarks, separated by newlines\n\n\nsub new {\n   my ($class,@args) = @_;\n   my $self= $class->SUPER::new(@args);\n\n   my ($name,$type,$global,$frame,$group,\n       $subgroup, $anchor, $clones,$contigs,\n       $positions, $remark) = $self->_rearrange([qw(NAME TYPE GLOBAL FRAME\n\t\t\t\t\t   GROUP SUBGROUP ANCHOR\n\t\t\t\t\t   CLONES CONTIGS POSITIONS REMARK)],@args);\n\n   $self->name($name)                  if defined $name;\n   $self->type($type)                  if defined $type;\n   $self->global($global)              if defined $global;\n   $self->group($group)                if defined $group;\n   $self->subgroup($group)             if defined $subgroup;\n   $self->anchor($anchor)              if defined $anchor;\n   $self->remark($remark)              if defined $remark;\n\n   $self->set_clones($clones)          if defined $clones;\n   $self->set_contigs($contigs)        if defined $contigs;\n   $self->set_positions($positions)    if defined $positions;\n\n   return $self;\n}\n\n=head1 Access Methods\n\nThese methods let you get and set the member variables\n\n=head2 name\n\n Title   : name\n Usage   : my $name = $markerobj->name();\n Function: Get/set the name for this marker\n Returns : scalar representing the current name of this marker\n Args    : none to get, OR string to set\n\n\nsub name {\n    my ($self) = shift;\n    return $self->{'_name'} = shift if @_;\n    return $self->{'_name'};\n}\n\n=head2 type\n\n Title   : type\n Usage   : my $type = $markerobj->type();\n Function: Get/set the type for this marker\n Returns : scalar representing the current type of this marker\n Args    : none to get, OR string to set\n\n\nsub type {\n    my ($self) = shift;\n    return $self->{'_type'} = shift if @_;\n    return $self->{'_type'};\n}\n\n=head2 global\n\n Title   : global\n Usage   : my $type = $markerobj->global();\n Function: Get/set the global position for this marker\n Returns : scalar representing the current global position of this marker\n Args    : none to get, OR string to set\n\n\nsub global {\n    my ($self) = shift;\n    return $self->{'_global'} = shift if @_;\n    return $self->{'_global'};\n}\n\n=head2 anchor\n\n Title   : anchor\n Usage   : my $anchor = $markerobj->anchor();\n Function: indicate if the Marker is anchored or not (True | False)\n Returns : scalar representing the anchor (1 | 0) for this marker\n Args    : none to get, OR 1|0 to set\n\n\nsub anchor {\n    my ($self) = shift;\n    return $self->{'_anchor'} = shift if @_;\n    return $self->{'_anchor'};\n}\n\n=head2 framework\n\n Title   : framework\n Usage   : $frame = $markerobj->framework();\n Function: indicate if the Marker is framework or placement (1 | 0)\n Returns : scalar representing if the marker is framework\n           (1 if framework, 0 if placement)\n Args    : none to get, OR 1|0 to set\n\n\nsub framework {\n    my ($self) = shift;\n    return $self->{'_frame'} = shift if @_;\n    return $self->{'_frame'};\n}\n\n=head2 group\n\n Title   : group\n Usage   : $grpno = $markerobj->group();\n Function: Get/set the group number for this marker. This is a generic term,\n           used for Linkage-Groups as well as for Chromosomes.\n Returns : scalar representing the group number of this marker\n Args    : none to get, OR string to set\n\n\nsub group {\n    my ($self) = shift;\n    $self->{'_group'} = shift if @_;\n    return $self->{'_group'} || 0;\n}\n\n=head2 subgroup\n\n Title   : subgroup\n Usage   : $subgroup = $marker->subgroup();\t\n Function: Get/set the subgroup for this marker. This is a generic term:\n           subgroup here could represent subgroup of a Chromosome or of a\n           Linkage Group. The user must take care of which subgroup he/she is\n           querying for.\t\n Returns : scalar representing the subgroup of this marker\n Args    : none to get, OR string to set\n\n\nsub subgroup {\n    my ($self) = shift;\n    $self->{'_subgroup'} = shift if @_;\n    return $self->{'_subgroup'} || 0;\n}\n\n=head2 position\n\n Title   : position\n Usage   : $markerpos = $markerobj->position($ctg);\n Function: get the position of the marker in the contig\n Returns : scalar representing the position of the markernumber of\n           the contig\n Args    : $ctg is necessary to look for the position of the marker\n           in that contig.\n\n *** This has nothing to do with an actual Bio::Map::PositionI object ***\n\n\nsub position {\n    my ($self,$ctg) = @_;\n    return 0 unless defined $ctg;\n\n    return 0 unless( defined $self->{'_position'} &&\n\t\t     defined $self->{'_position'}{$ctg});\n    return $self->{'_position'}{$ctg};\n}\n\n=head2 remark\n\n Title   : remark\n Usage   : $markerremark = $markerobj->remark();\n Function: get the remarks for this marker\n Returns : scalar of newline-separated markers\n Args    : none\n\n\nsub remark {\n    my ($self) = shift;\n    return $self->{'_remark'} = shift if @_;\n    return $self->{'_remark'};\n}\n\n=head2 each_cloneid\n\n Title   : each_cloneid\n Usage   : my @clones  = $map->each_cloneid();\n Function: retrieves all the clone ids in a map unordered\n Returns : list of strings (ids)\n Args    : none\n\n *** This only supplies the ids set with the set_clones method ***\n *** It has nothing to do with actual Bio::Map::MappableI objects ***\n\n\nsub each_cloneid {\n    my ($self) = @_;\n    return $self->_each_element('clones');\n}\n\n=head2 each_contigid\n\n Title   : each_contigid\n Usage   : my @contigs = $map->each_contigid();\n Function: retrieves all the contig ids in a map unordered\n Returns : list of strings (ids)\n Args    : none\n\n *** This only supplies the ids set with the set_contigs method ***\n *** It has nothing to do with actual Bio::Map::MapI objects ***\n\n\nsub each_contigid {\n    my ($self) = @_;\n    return $self->_each_element('contigs');\n}\n\nsub _each_element{\n    my ($self, $type) = @_;\n\n    $type = 'clones' unless defined $type;\n    $type = lc(\"_$type\");\n\n    return keys %{$self->{$type} || {}};\n}\n\n=head2 set_clones\n\n Title   : set_clones\n Usage   : $marker->set_clones(\\%clones)\n Function: Set the clone ids hashref\n Returns : None\n Args    : Hashref of clone ids\n\n *** This only sets a hash of ids ***\n *** It has nothing to do with actual Bio::Map::MappableI objects ***","parameters":[{"label":"$self"},{"label":"$clones"}],"label":"set_clones($self,$clones)"},"range":{"end":{"character":9999,"line":397},"start":{"line":392,"character":0}},"kind":12,"line":392,"detail":"($self,$clones)","definition":"sub","containerName":"main::","name":"set_clones","children":[{"name":"$self","localvar":"my","containerName":"set_clones","kind":13,"line":393,"definition":"my"},{"line":393,"name":"$clones","containerName":"set_clones","kind":13},{"name":"$clones","containerName":"set_clones","kind":13,"line":394},{"line":394,"name":"$clones","containerName":"set_clones","kind":13},{"name":"$self","containerName":"set_clones","kind":13,"line":395},{"line":395,"kind":13,"containerName":"set_clones","name":"$clones"}]},{"children":[{"line":413,"kind":13,"localvar":"my","containerName":"set_contigs","name":"$self","definition":"my"},{"line":413,"containerName":"set_contigs","kind":13,"name":"$contigs"},{"line":414,"name":"$contigs","containerName":"set_contigs","kind":13},{"line":414,"name":"$contigs","kind":13,"containerName":"set_contigs"},{"line":415,"name":"$self","containerName":"set_contigs","kind":13},{"line":415,"kind":13,"containerName":"set_contigs","name":"$contigs"}],"containerName":"main::","name":"set_contigs","definition":"sub","detail":"($self,$contigs)","line":412,"kind":12,"range":{"end":{"character":9999,"line":417},"start":{"character":0,"line":412}},"signature":{"parameters":[{"label":"$self"},{"label":"$contigs"}],"documentation":"1;\n# $Id: FPCMarker.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::fpcmarker\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gaurav Gupta <gaurav@genome.arizona.edu>\n#\n# Copyright Gaurav Gupta\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::FPCMarker - An central map object representing a marker\n\n=head1 SYNOPSIS\n\n   # get the marker object of $marker from the Bio::Map::FPCMarker\n   my $markerobj = $physical->get_markerobj($marker);\n\n   # acquire all the clones that hit this marker\n   foreach my $clone ($markerobj->each_cloneid()) {\n       print \"   +++$clone\\n\";\n   }\n\n   # find the position of this marker in $contig\n   print \"Position in contig $contig\",\" = \",$markerobj->position($contig),\n         \"\\n\";\n\n   # find the group of the marker\n   print \"Group : \",$markerobj->group();\n\n\nSee L<Bio::Map::Position> and L<Bio::Map::PositionI> for more information.\n\n=head1 DESCRIPTION\n\nThis object handles the notion of a marker.\nThis object is intended to be used by a map parser like fpc.pm.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Gaurav Gupta\n\nEmail gaurav@genome.arizona.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala  bix@sendu.me.uk\n\n=head1 PROJECT LEADERS\n\nJamie Hatfield      jamie@genome.arizona.edu\nDr. Cari Soderlund  cari@genome.arizona.edu\n\n=head1 PROJECT DESCRIPTION\n\nThe project was done in Arizona Genomics Computational Laboratory (AGCoL)\nat University of Arizona.\n\nThis work was funded by USDA-IFAFS grant #11180 titled \"Web Resources for \nthe Computation and Display of Physical Mapping Data\".\n\nFor more information on this project, please refer: \n  http://www.genome.arizona.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::FPCMarker;\nuse strict;\nuse Bio::Map::Position;\nuse Time::Local;\n\nuse base qw(Bio::Root::Root Bio::Map::MappableI);\n\n=head2 new\n\n Title   : new\n Usage   : my $clone = Bio::Map::FPCMarker->new\n                      (\n\t\t       -name    => $marker,\n\t\t       -type    => $type,\n\t\t       -global  => $global,\n\t\t       -frame   => $frame,\n\t\t       -group   => $group,\n\t\t       -subgroup=> $subgroup,\n\t\t       -anchor  => $anchor,\n\t\t       -clones  => \\%clones,\n\t\t       -contigs => \\%contigs,\n\t\t       -position => \\%markerpos,\n               -remark => $remark\n\t\t       );\n\n Function: Initialize a new Bio::Map::FPCMarker object\n           Most people will not use this directly but get Markers\n           through L<Bio::MapIO::fpc>\n Returns : L<Bio::Map::FPCMarker> object\n Args    : -name     => marker name string,\n\t       -type     => type string,\n\t       -global   => global position for marker,\n\t       -frame    => boolean if marker is framework or placement,\n\t       -group    => group number for marker,\n\t       -subgroup => subgroup number of marker,\n\t       -anchor   => boolean if marker is anchored,\n\t       -clones   => all the clone elements in map (hashref),\n\t       -contigs  => all the contig elements (hasref),\n\t       -position => mapping of marker names to map position (hasref),\n           -remark   => remarks, separated by newlines\n\n\nsub new {\n   my ($class,@args) = @_;\n   my $self= $class->SUPER::new(@args);\n\n   my ($name,$type,$global,$frame,$group,\n       $subgroup, $anchor, $clones,$contigs,\n       $positions, $remark) = $self->_rearrange([qw(NAME TYPE GLOBAL FRAME\n\t\t\t\t\t   GROUP SUBGROUP ANCHOR\n\t\t\t\t\t   CLONES CONTIGS POSITIONS REMARK)],@args);\n\n   $self->name($name)                  if defined $name;\n   $self->type($type)                  if defined $type;\n   $self->global($global)              if defined $global;\n   $self->group($group)                if defined $group;\n   $self->subgroup($group)             if defined $subgroup;\n   $self->anchor($anchor)              if defined $anchor;\n   $self->remark($remark)              if defined $remark;\n\n   $self->set_clones($clones)          if defined $clones;\n   $self->set_contigs($contigs)        if defined $contigs;\n   $self->set_positions($positions)    if defined $positions;\n\n   return $self;\n}\n\n=head1 Access Methods\n\nThese methods let you get and set the member variables\n\n=head2 name\n\n Title   : name\n Usage   : my $name = $markerobj->name();\n Function: Get/set the name for this marker\n Returns : scalar representing the current name of this marker\n Args    : none to get, OR string to set\n\n\nsub name {\n    my ($self) = shift;\n    return $self->{'_name'} = shift if @_;\n    return $self->{'_name'};\n}\n\n=head2 type\n\n Title   : type\n Usage   : my $type = $markerobj->type();\n Function: Get/set the type for this marker\n Returns : scalar representing the current type of this marker\n Args    : none to get, OR string to set\n\n\nsub type {\n    my ($self) = shift;\n    return $self->{'_type'} = shift if @_;\n    return $self->{'_type'};\n}\n\n=head2 global\n\n Title   : global\n Usage   : my $type = $markerobj->global();\n Function: Get/set the global position for this marker\n Returns : scalar representing the current global position of this marker\n Args    : none to get, OR string to set\n\n\nsub global {\n    my ($self) = shift;\n    return $self->{'_global'} = shift if @_;\n    return $self->{'_global'};\n}\n\n=head2 anchor\n\n Title   : anchor\n Usage   : my $anchor = $markerobj->anchor();\n Function: indicate if the Marker is anchored or not (True | False)\n Returns : scalar representing the anchor (1 | 0) for this marker\n Args    : none to get, OR 1|0 to set\n\n\nsub anchor {\n    my ($self) = shift;\n    return $self->{'_anchor'} = shift if @_;\n    return $self->{'_anchor'};\n}\n\n=head2 framework\n\n Title   : framework\n Usage   : $frame = $markerobj->framework();\n Function: indicate if the Marker is framework or placement (1 | 0)\n Returns : scalar representing if the marker is framework\n           (1 if framework, 0 if placement)\n Args    : none to get, OR 1|0 to set\n\n\nsub framework {\n    my ($self) = shift;\n    return $self->{'_frame'} = shift if @_;\n    return $self->{'_frame'};\n}\n\n=head2 group\n\n Title   : group\n Usage   : $grpno = $markerobj->group();\n Function: Get/set the group number for this marker. This is a generic term,\n           used for Linkage-Groups as well as for Chromosomes.\n Returns : scalar representing the group number of this marker\n Args    : none to get, OR string to set\n\n\nsub group {\n    my ($self) = shift;\n    $self->{'_group'} = shift if @_;\n    return $self->{'_group'} || 0;\n}\n\n=head2 subgroup\n\n Title   : subgroup\n Usage   : $subgroup = $marker->subgroup();\t\n Function: Get/set the subgroup for this marker. This is a generic term:\n           subgroup here could represent subgroup of a Chromosome or of a\n           Linkage Group. The user must take care of which subgroup he/she is\n           querying for.\t\n Returns : scalar representing the subgroup of this marker\n Args    : none to get, OR string to set\n\n\nsub subgroup {\n    my ($self) = shift;\n    $self->{'_subgroup'} = shift if @_;\n    return $self->{'_subgroup'} || 0;\n}\n\n=head2 position\n\n Title   : position\n Usage   : $markerpos = $markerobj->position($ctg);\n Function: get the position of the marker in the contig\n Returns : scalar representing the position of the markernumber of\n           the contig\n Args    : $ctg is necessary to look for the position of the marker\n           in that contig.\n\n *** This has nothing to do with an actual Bio::Map::PositionI object ***\n\n\nsub position {\n    my ($self,$ctg) = @_;\n    return 0 unless defined $ctg;\n\n    return 0 unless( defined $self->{'_position'} &&\n\t\t     defined $self->{'_position'}{$ctg});\n    return $self->{'_position'}{$ctg};\n}\n\n=head2 remark\n\n Title   : remark\n Usage   : $markerremark = $markerobj->remark();\n Function: get the remarks for this marker\n Returns : scalar of newline-separated markers\n Args    : none\n\n\nsub remark {\n    my ($self) = shift;\n    return $self->{'_remark'} = shift if @_;\n    return $self->{'_remark'};\n}\n\n=head2 each_cloneid\n\n Title   : each_cloneid\n Usage   : my @clones  = $map->each_cloneid();\n Function: retrieves all the clone ids in a map unordered\n Returns : list of strings (ids)\n Args    : none\n\n *** This only supplies the ids set with the set_clones method ***\n *** It has nothing to do with actual Bio::Map::MappableI objects ***\n\n\nsub each_cloneid {\n    my ($self) = @_;\n    return $self->_each_element('clones');\n}\n\n=head2 each_contigid\n\n Title   : each_contigid\n Usage   : my @contigs = $map->each_contigid();\n Function: retrieves all the contig ids in a map unordered\n Returns : list of strings (ids)\n Args    : none\n\n *** This only supplies the ids set with the set_contigs method ***\n *** It has nothing to do with actual Bio::Map::MapI objects ***\n\n\nsub each_contigid {\n    my ($self) = @_;\n    return $self->_each_element('contigs');\n}\n\nsub _each_element{\n    my ($self, $type) = @_;\n\n    $type = 'clones' unless defined $type;\n    $type = lc(\"_$type\");\n\n    return keys %{$self->{$type} || {}};\n}\n\n=head2 set_clones\n\n Title   : set_clones\n Usage   : $marker->set_clones(\\%clones)\n Function: Set the clone ids hashref\n Returns : None\n Args    : Hashref of clone ids\n\n *** This only sets a hash of ids ***\n *** It has nothing to do with actual Bio::Map::MappableI objects ***\n\n\nsub set_clones{\n   my ($self,$clones) = @_;\n   if( defined $clones && ref($clones) =~ /HASH/ ) {\n       $self->{'_clones'} = $clones;\n   }\n}\n\n=head2 set_contigs\n\n Title   : set_contigs\n Usage   : $marker->set_contigs(\\%contigs)\n Function: Set the contig ids hashref\n Returns : None\n Args    : Hashref of contig ids\n\n *** This only sets a hash of ids ***\n *** It has nothing to do with actual Bio::Map::MapI objects ***","label":"set_contigs($self,$contigs)"}},{"range":{"end":{"line":437,"character":9999},"start":{"line":432,"character":0}},"kind":12,"line":432,"signature":{"parameters":[{"label":"$self"},{"label":"$pos"}],"documentation":"1;\n# $Id: FPCMarker.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::fpcmarker\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gaurav Gupta <gaurav@genome.arizona.edu>\n#\n# Copyright Gaurav Gupta\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::FPCMarker - An central map object representing a marker\n\n=head1 SYNOPSIS\n\n   # get the marker object of $marker from the Bio::Map::FPCMarker\n   my $markerobj = $physical->get_markerobj($marker);\n\n   # acquire all the clones that hit this marker\n   foreach my $clone ($markerobj->each_cloneid()) {\n       print \"   +++$clone\\n\";\n   }\n\n   # find the position of this marker in $contig\n   print \"Position in contig $contig\",\" = \",$markerobj->position($contig),\n         \"\\n\";\n\n   # find the group of the marker\n   print \"Group : \",$markerobj->group();\n\n\nSee L<Bio::Map::Position> and L<Bio::Map::PositionI> for more information.\n\n=head1 DESCRIPTION\n\nThis object handles the notion of a marker.\nThis object is intended to be used by a map parser like fpc.pm.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Gaurav Gupta\n\nEmail gaurav@genome.arizona.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala  bix@sendu.me.uk\n\n=head1 PROJECT LEADERS\n\nJamie Hatfield      jamie@genome.arizona.edu\nDr. Cari Soderlund  cari@genome.arizona.edu\n\n=head1 PROJECT DESCRIPTION\n\nThe project was done in Arizona Genomics Computational Laboratory (AGCoL)\nat University of Arizona.\n\nThis work was funded by USDA-IFAFS grant #11180 titled \"Web Resources for \nthe Computation and Display of Physical Mapping Data\".\n\nFor more information on this project, please refer: \n  http://www.genome.arizona.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::FPCMarker;\nuse strict;\nuse Bio::Map::Position;\nuse Time::Local;\n\nuse base qw(Bio::Root::Root Bio::Map::MappableI);\n\n=head2 new\n\n Title   : new\n Usage   : my $clone = Bio::Map::FPCMarker->new\n                      (\n\t\t       -name    => $marker,\n\t\t       -type    => $type,\n\t\t       -global  => $global,\n\t\t       -frame   => $frame,\n\t\t       -group   => $group,\n\t\t       -subgroup=> $subgroup,\n\t\t       -anchor  => $anchor,\n\t\t       -clones  => \\%clones,\n\t\t       -contigs => \\%contigs,\n\t\t       -position => \\%markerpos,\n               -remark => $remark\n\t\t       );\n\n Function: Initialize a new Bio::Map::FPCMarker object\n           Most people will not use this directly but get Markers\n           through L<Bio::MapIO::fpc>\n Returns : L<Bio::Map::FPCMarker> object\n Args    : -name     => marker name string,\n\t       -type     => type string,\n\t       -global   => global position for marker,\n\t       -frame    => boolean if marker is framework or placement,\n\t       -group    => group number for marker,\n\t       -subgroup => subgroup number of marker,\n\t       -anchor   => boolean if marker is anchored,\n\t       -clones   => all the clone elements in map (hashref),\n\t       -contigs  => all the contig elements (hasref),\n\t       -position => mapping of marker names to map position (hasref),\n           -remark   => remarks, separated by newlines\n\n\nsub new {\n   my ($class,@args) = @_;\n   my $self= $class->SUPER::new(@args);\n\n   my ($name,$type,$global,$frame,$group,\n       $subgroup, $anchor, $clones,$contigs,\n       $positions, $remark) = $self->_rearrange([qw(NAME TYPE GLOBAL FRAME\n\t\t\t\t\t   GROUP SUBGROUP ANCHOR\n\t\t\t\t\t   CLONES CONTIGS POSITIONS REMARK)],@args);\n\n   $self->name($name)                  if defined $name;\n   $self->type($type)                  if defined $type;\n   $self->global($global)              if defined $global;\n   $self->group($group)                if defined $group;\n   $self->subgroup($group)             if defined $subgroup;\n   $self->anchor($anchor)              if defined $anchor;\n   $self->remark($remark)              if defined $remark;\n\n   $self->set_clones($clones)          if defined $clones;\n   $self->set_contigs($contigs)        if defined $contigs;\n   $self->set_positions($positions)    if defined $positions;\n\n   return $self;\n}\n\n=head1 Access Methods\n\nThese methods let you get and set the member variables\n\n=head2 name\n\n Title   : name\n Usage   : my $name = $markerobj->name();\n Function: Get/set the name for this marker\n Returns : scalar representing the current name of this marker\n Args    : none to get, OR string to set\n\n\nsub name {\n    my ($self) = shift;\n    return $self->{'_name'} = shift if @_;\n    return $self->{'_name'};\n}\n\n=head2 type\n\n Title   : type\n Usage   : my $type = $markerobj->type();\n Function: Get/set the type for this marker\n Returns : scalar representing the current type of this marker\n Args    : none to get, OR string to set\n\n\nsub type {\n    my ($self) = shift;\n    return $self->{'_type'} = shift if @_;\n    return $self->{'_type'};\n}\n\n=head2 global\n\n Title   : global\n Usage   : my $type = $markerobj->global();\n Function: Get/set the global position for this marker\n Returns : scalar representing the current global position of this marker\n Args    : none to get, OR string to set\n\n\nsub global {\n    my ($self) = shift;\n    return $self->{'_global'} = shift if @_;\n    return $self->{'_global'};\n}\n\n=head2 anchor\n\n Title   : anchor\n Usage   : my $anchor = $markerobj->anchor();\n Function: indicate if the Marker is anchored or not (True | False)\n Returns : scalar representing the anchor (1 | 0) for this marker\n Args    : none to get, OR 1|0 to set\n\n\nsub anchor {\n    my ($self) = shift;\n    return $self->{'_anchor'} = shift if @_;\n    return $self->{'_anchor'};\n}\n\n=head2 framework\n\n Title   : framework\n Usage   : $frame = $markerobj->framework();\n Function: indicate if the Marker is framework or placement (1 | 0)\n Returns : scalar representing if the marker is framework\n           (1 if framework, 0 if placement)\n Args    : none to get, OR 1|0 to set\n\n\nsub framework {\n    my ($self) = shift;\n    return $self->{'_frame'} = shift if @_;\n    return $self->{'_frame'};\n}\n\n=head2 group\n\n Title   : group\n Usage   : $grpno = $markerobj->group();\n Function: Get/set the group number for this marker. This is a generic term,\n           used for Linkage-Groups as well as for Chromosomes.\n Returns : scalar representing the group number of this marker\n Args    : none to get, OR string to set\n\n\nsub group {\n    my ($self) = shift;\n    $self->{'_group'} = shift if @_;\n    return $self->{'_group'} || 0;\n}\n\n=head2 subgroup\n\n Title   : subgroup\n Usage   : $subgroup = $marker->subgroup();\t\n Function: Get/set the subgroup for this marker. This is a generic term:\n           subgroup here could represent subgroup of a Chromosome or of a\n           Linkage Group. The user must take care of which subgroup he/she is\n           querying for.\t\n Returns : scalar representing the subgroup of this marker\n Args    : none to get, OR string to set\n\n\nsub subgroup {\n    my ($self) = shift;\n    $self->{'_subgroup'} = shift if @_;\n    return $self->{'_subgroup'} || 0;\n}\n\n=head2 position\n\n Title   : position\n Usage   : $markerpos = $markerobj->position($ctg);\n Function: get the position of the marker in the contig\n Returns : scalar representing the position of the markernumber of\n           the contig\n Args    : $ctg is necessary to look for the position of the marker\n           in that contig.\n\n *** This has nothing to do with an actual Bio::Map::PositionI object ***\n\n\nsub position {\n    my ($self,$ctg) = @_;\n    return 0 unless defined $ctg;\n\n    return 0 unless( defined $self->{'_position'} &&\n\t\t     defined $self->{'_position'}{$ctg});\n    return $self->{'_position'}{$ctg};\n}\n\n=head2 remark\n\n Title   : remark\n Usage   : $markerremark = $markerobj->remark();\n Function: get the remarks for this marker\n Returns : scalar of newline-separated markers\n Args    : none\n\n\nsub remark {\n    my ($self) = shift;\n    return $self->{'_remark'} = shift if @_;\n    return $self->{'_remark'};\n}\n\n=head2 each_cloneid\n\n Title   : each_cloneid\n Usage   : my @clones  = $map->each_cloneid();\n Function: retrieves all the clone ids in a map unordered\n Returns : list of strings (ids)\n Args    : none\n\n *** This only supplies the ids set with the set_clones method ***\n *** It has nothing to do with actual Bio::Map::MappableI objects ***\n\n\nsub each_cloneid {\n    my ($self) = @_;\n    return $self->_each_element('clones');\n}\n\n=head2 each_contigid\n\n Title   : each_contigid\n Usage   : my @contigs = $map->each_contigid();\n Function: retrieves all the contig ids in a map unordered\n Returns : list of strings (ids)\n Args    : none\n\n *** This only supplies the ids set with the set_contigs method ***\n *** It has nothing to do with actual Bio::Map::MapI objects ***\n\n\nsub each_contigid {\n    my ($self) = @_;\n    return $self->_each_element('contigs');\n}\n\nsub _each_element{\n    my ($self, $type) = @_;\n\n    $type = 'clones' unless defined $type;\n    $type = lc(\"_$type\");\n\n    return keys %{$self->{$type} || {}};\n}\n\n=head2 set_clones\n\n Title   : set_clones\n Usage   : $marker->set_clones(\\%clones)\n Function: Set the clone ids hashref\n Returns : None\n Args    : Hashref of clone ids\n\n *** This only sets a hash of ids ***\n *** It has nothing to do with actual Bio::Map::MappableI objects ***\n\n\nsub set_clones{\n   my ($self,$clones) = @_;\n   if( defined $clones && ref($clones) =~ /HASH/ ) {\n       $self->{'_clones'} = $clones;\n   }\n}\n\n=head2 set_contigs\n\n Title   : set_contigs\n Usage   : $marker->set_contigs(\\%contigs)\n Function: Set the contig ids hashref\n Returns : None\n Args    : Hashref of contig ids\n\n *** This only sets a hash of ids ***\n *** It has nothing to do with actual Bio::Map::MapI objects ***\n\n\nsub set_contigs{\n   my ($self,$contigs) = @_;\n   if( defined $contigs && ref($contigs) =~ /HASH/ ) {\n       $self->{'_contigs'} = $contigs;\n   }\n}\n\n=head2 set_positions\n\n Title   : set_positions\n Usage   : $marker->set_positions(\\%markerpos)\n Function: Set the positions hashref\n Returns : None\n Args    : Hashref of marker positions\n\n *** This only sets a hash of numbers ***\n *** It has nothing to do with actual Bio::Map::PositionI objects ***","label":"set_positions($self,$pos)"},"name":"set_positions","containerName":"main::","children":[{"localvar":"my","containerName":"set_positions","kind":13,"name":"$self","line":433,"definition":"my"},{"name":"$pos","containerName":"set_positions","kind":13,"line":433},{"name":"$pos","kind":13,"containerName":"set_positions","line":434},{"containerName":"set_positions","kind":13,"name":"$pos","line":434},{"line":435,"name":"$self","kind":13,"containerName":"set_positions"},{"name":"$pos","kind":13,"containerName":"set_positions","line":435}],"detail":"($self,$pos)","definition":"sub"}]}