{"version":5,"vars":[{"line":82,"name":"base","kind":2,"containerName":""},{"kind":12,"range":{"end":{"line":116,"character":9999},"start":{"line":104,"character":0}},"line":104,"signature":{"documentation":"1;\n# $Id: CytoMarker.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::CytoMarker\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::CytoMarker - An object representing a marker.\n\n=head1 SYNOPSIS\n\n  $o_usat = Bio::Map::CytoMarker->new(-name=>'Chad Super Marker 2',\n\t\t\t\t -position => $pos);\n\n=head1 DESCRIPTION\n\nThis object handles markers with a positon in a cytogenetic map known.\nThis marker will have a name and a position.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho \n\nEmail heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nChad Matsalla      bioinformatics1@dieselwurks.com\nLincoln Stein      lstein@cshl.org\nJason Stajich      jason@bioperl.org\nSendu Bala         bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::CytoMarker;\nuse strict;\nuse Bio::Map::CytoPosition;\n\nuse base qw(Bio::Map::Marker);\n\n\n=head2 Bio::Map::MarkerI methods\n\n\n=head2 get_position_object\n\n Title   : get_position_class\n Usage   : my $position = $marker->get_position_object();\n Function: To get an object of the default Position class\n           for this Marker. Subclasses should redefine this method.\n           The Position returned needs to be a L<Bio::Map::PositionI> with\n\t\t   -element set to self.\n Returns : L<Bio::Map::PositionI>\n Args    : none for an 'empty' PositionI object, optionally\n           Bio::Map::MapI and value string to set the Position's -map and -value\n           attributes.","parameters":[{"label":"$self"},{"label":"$map"},{"label":"$value"}],"label":"get_position_object($self,$map,$value)"},"name":"get_position_object","containerName":"main::","children":[{"line":105,"kind":13,"localvar":"my","containerName":"get_position_object","name":"$self","definition":"my"},{"name":"$map","containerName":"get_position_object","kind":13,"line":105},{"line":105,"containerName":"get_position_object","kind":13,"name":"$value"},{"name":"$map","containerName":"get_position_object","kind":13,"line":106},{"name":"$self","containerName":"get_position_object","kind":13,"line":106},{"line":106,"name":"default_map","containerName":"get_position_object","kind":12},{"line":107,"name":"$value","kind":13,"containerName":"get_position_object"},{"line":108,"name":"$self","containerName":"get_position_object","kind":13},{"name":"throw","kind":12,"containerName":"get_position_object","line":108},{"name":"$value","containerName":"get_position_object","kind":13,"line":108},{"definition":"my","line":111,"name":"$pos","kind":13,"localvar":"my","containerName":"get_position_object"},{"line":111,"name":"new","kind":12,"containerName":"get_position_object"},{"name":"$pos","kind":13,"containerName":"get_position_object","line":112},{"line":112,"containerName":"get_position_object","kind":12,"name":"map"},{"line":112,"kind":13,"containerName":"get_position_object","name":"$map"},{"line":112,"containerName":"get_position_object","kind":13,"name":"$map"},{"line":113,"name":"$pos","containerName":"get_position_object","kind":13},{"name":"value","kind":12,"containerName":"get_position_object","line":113},{"line":113,"kind":13,"containerName":"get_position_object","name":"$value"},{"line":113,"containerName":"get_position_object","kind":13,"name":"$value"},{"line":114,"name":"$pos","kind":13,"containerName":"get_position_object"},{"line":114,"name":"element","containerName":"get_position_object","kind":12},{"kind":13,"containerName":"get_position_object","name":"$self","line":114},{"line":115,"kind":13,"containerName":"get_position_object","name":"$pos"}],"detail":"($self,$map,$value)","definition":"sub"},{"line":111,"kind":12,"containerName":"Map::CytoPosition","name":"Bio"},{"detail":"($self)","definition":"sub","containerName":"main::","name":"get_chr","children":[{"definition":"my","line":144,"containerName":"get_chr","localvar":"my","kind":13,"name":"$self"},{"name":"$self","kind":13,"containerName":"get_chr","line":145},{"containerName":"get_chr","kind":12,"name":"position","line":145},{"name":"$self","kind":13,"containerName":"get_chr","line":146},{"containerName":"get_chr","kind":12,"name":"position","line":146},{"containerName":"get_chr","kind":12,"name":"chr","line":146}],"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: CytoMarker.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::CytoMarker\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::CytoMarker - An object representing a marker.\n\n=head1 SYNOPSIS\n\n  $o_usat = Bio::Map::CytoMarker->new(-name=>'Chad Super Marker 2',\n\t\t\t\t -position => $pos);\n\n=head1 DESCRIPTION\n\nThis object handles markers with a positon in a cytogenetic map known.\nThis marker will have a name and a position.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho \n\nEmail heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nChad Matsalla      bioinformatics1@dieselwurks.com\nLincoln Stein      lstein@cshl.org\nJason Stajich      jason@bioperl.org\nSendu Bala         bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::CytoMarker;\nuse strict;\nuse Bio::Map::CytoPosition;\n\nuse base qw(Bio::Map::Marker);\n\n\n=head2 Bio::Map::MarkerI methods\n\n\n=head2 get_position_object\n\n Title   : get_position_class\n Usage   : my $position = $marker->get_position_object();\n Function: To get an object of the default Position class\n           for this Marker. Subclasses should redefine this method.\n           The Position returned needs to be a L<Bio::Map::PositionI> with\n\t\t   -element set to self.\n Returns : L<Bio::Map::PositionI>\n Args    : none for an 'empty' PositionI object, optionally\n           Bio::Map::MapI and value string to set the Position's -map and -value\n           attributes.\n\n\nsub get_position_object {\n   my ($self, $map, $value) = @_;\n   $map ||= $self->default_map;\n   if ($value) {\n\t  $self->throw(\"Value better be scalar, not [$value]\") unless ref($value) eq '';\n   }\n   \n   my $pos = Bio::Map::CytoPosition->new();\n   $pos->map($map) if $map;\n   $pos->value($value) if $value;\n   $pos->element($self);\n   return $pos;\n}\n\n\n=head2 Comparison methods\n\nThe numeric values for cutogeneic loctions go from the p tip of\nchromosome 1, down to the q tip and similarly throgh consecutive\nchromosomes, through X and end the the q tip of X. See\nL<Bio::Map::CytoPosition::cytorange> for more details.\n\n\n=head2 New methods\n\n\n=head2 get_chr\n\n Title   : get_chr\n Usage   : my $mychr = $marker->get_chr();\n Function: Read only method for the  chromosome string of the location.\n           A shortcut to $marker->position->chr().\n Returns : chromosome value\n Args    : [optional] new chromosome value","label":"get_chr($self)"},"range":{"end":{"line":147,"character":9999},"start":{"character":0,"line":143}},"kind":12,"line":143}]}