{"vars":[{"kind":2,"containerName":"","name":"base","line":79},{"children":[{"line":92,"containerName":"location_type","localvar":"my","kind":13,"name":"$self","definition":"my"},{"name":"@args","kind":13,"containerName":"location_type","line":92},{"line":93,"containerName":"location_type","kind":13,"name":"$self"},{"line":93,"kind":12,"containerName":"location_type","name":"throw_not_implemented"}],"containerName":"main::","name":"location_type","definition":"sub","detail":"($self,@args)","line":91,"kind":12,"range":{"end":{"character":9999,"line":94},"start":{"line":91,"character":0}},"signature":{"label":"location_type($self,@args)","documentation":"1;\n# $Id: LocationI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::LocationI\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LocationI - Abstract interface of a Location on a Sequence\n\n=head1 SYNOPSIS\n\n    # get a LocationI somehow\n    printf( \"start = %d, end = %d, strand = %s, seq_id = %s\\n\", \n\t    $location->start, $location->end, $location->strand,\n\t    $location->seq_id);\n    print \"location str is \", $location->to_FTstring(), \"\\n\"; \n\n\n=head1 DESCRIPTION\n\nThis Interface defines the methods for a Bio::LocationI, an object\nwhich encapsulates a location on a biological sequence.  Locations\nneed not be attached to actual sequences as they are stand alone\nobjects.  LocationI objects are used by L<Bio::SeqFeatureI> objects to\nmanage and represent locations for a Sequence Feature.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::LocationI;\nuse strict;\n\nuse Carp;\n\nuse base qw(Bio::RangeI);\n\n=head2 location_type\n\n  Title   : location_type\n  Usage   : my $location_type = $location->location_type();\n  Function: Get location type encoded as text\n  Returns : string ('EXACT', 'WITHIN', 'IN-BETWEEN')\n  Args    : none","parameters":[{"label":"$self"},{"label":"@args"}]}},{"signature":{"label":"start($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: LocationI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::LocationI\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LocationI - Abstract interface of a Location on a Sequence\n\n=head1 SYNOPSIS\n\n    # get a LocationI somehow\n    printf( \"start = %d, end = %d, strand = %s, seq_id = %s\\n\", \n\t    $location->start, $location->end, $location->strand,\n\t    $location->seq_id);\n    print \"location str is \", $location->to_FTstring(), \"\\n\"; \n\n\n=head1 DESCRIPTION\n\nThis Interface defines the methods for a Bio::LocationI, an object\nwhich encapsulates a location on a biological sequence.  Locations\nneed not be attached to actual sequences as they are stand alone\nobjects.  LocationI objects are used by L<Bio::SeqFeatureI> objects to\nmanage and represent locations for a Sequence Feature.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::LocationI;\nuse strict;\n\nuse Carp;\n\nuse base qw(Bio::RangeI);\n\n=head2 location_type\n\n  Title   : location_type\n  Usage   : my $location_type = $location->location_type();\n  Function: Get location type encoded as text\n  Returns : string ('EXACT', 'WITHIN', 'IN-BETWEEN')\n  Args    : none\n\n\nsub location_type { \n    my ($self,@args) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $location->start();\n  Function: Get the start coordinate of this location as defined by\n            the currently active coordinate computation policy. In\n            simple cases, this will return the same number as\n            min_start() and max_start(), in more ambiguous cases like\n            fuzzy locations the number may be equal to one or neither\n            of both.\n\n            We override this here from RangeI in order to delegate\n            'get' to a L<Bio::Location::CoordinatePolicy> implementing\n            object.  Implementing classes may also wish to provide\n            'set' functionality, in which case they *must* override\n            this method. The implementation provided here will throw\n            an exception if called with arguments.\n\n  Returns : A positive integer value.\n  Args    : none\n\nSee L<Bio::Location::CoordinatePolicy> for more information"},"range":{"end":{"character":9999,"line":130},"start":{"character":0,"line":121}},"kind":12,"line":121,"detail":"($self,@args)","definition":"sub","containerName":"main::","name":"start","children":[{"definition":"my","line":122,"kind":13,"localvar":"my","containerName":"start","name":"$self"},{"line":122,"name":"@args","kind":13,"containerName":"start"},{"containerName":"start","kind":13,"name":"$self","line":128},{"line":128,"name":"throw_not_implemented","containerName":"start","kind":12},{"name":"@args","containerName":"start","kind":13,"line":128},{"line":129,"containerName":"start","kind":13,"name":"$self"},{"line":129,"kind":12,"containerName":"start","name":"coordinate_policy"},{"kind":12,"containerName":"start","name":"start","line":129},{"line":129,"containerName":"start","kind":13,"name":"$self"}]},{"signature":{"documentation":"1;\n# $Id: LocationI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::LocationI\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LocationI - Abstract interface of a Location on a Sequence\n\n=head1 SYNOPSIS\n\n    # get a LocationI somehow\n    printf( \"start = %d, end = %d, strand = %s, seq_id = %s\\n\", \n\t    $location->start, $location->end, $location->strand,\n\t    $location->seq_id);\n    print \"location str is \", $location->to_FTstring(), \"\\n\"; \n\n\n=head1 DESCRIPTION\n\nThis Interface defines the methods for a Bio::LocationI, an object\nwhich encapsulates a location on a biological sequence.  Locations\nneed not be attached to actual sequences as they are stand alone\nobjects.  LocationI objects are used by L<Bio::SeqFeatureI> objects to\nmanage and represent locations for a Sequence Feature.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::LocationI;\nuse strict;\n\nuse Carp;\n\nuse base qw(Bio::RangeI);\n\n=head2 location_type\n\n  Title   : location_type\n  Usage   : my $location_type = $location->location_type();\n  Function: Get location type encoded as text\n  Returns : string ('EXACT', 'WITHIN', 'IN-BETWEEN')\n  Args    : none\n\n\nsub location_type { \n    my ($self,@args) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $location->start();\n  Function: Get the start coordinate of this location as defined by\n            the currently active coordinate computation policy. In\n            simple cases, this will return the same number as\n            min_start() and max_start(), in more ambiguous cases like\n            fuzzy locations the number may be equal to one or neither\n            of both.\n\n            We override this here from RangeI in order to delegate\n            'get' to a L<Bio::Location::CoordinatePolicy> implementing\n            object.  Implementing classes may also wish to provide\n            'set' functionality, in which case they *must* override\n            this method. The implementation provided here will throw\n            an exception if called with arguments.\n\n  Returns : A positive integer value.\n  Args    : none\n\nSee L<Bio::Location::CoordinatePolicy> for more information\n\n\nsub start {\n    my ($self,@args) = @_;\n\n    # throw if @args means that we don't support updating information\n    # in the interface but will delegate to the coordinate policy object\n    # for interpreting the 'start' value\n\n    $self->throw_not_implemented if @args;\n    return $self->coordinate_policy()->start($self);\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $location->end();\n  Function: Get the end coordinate of this location as defined by the\n            currently active coordinate computation policy. In simple\n            cases, this will return the same number as min_end() and\n            max_end(), in more ambiguous cases like fuzzy locations\n            the number may be equal to one or neither of both.\n\n            We override this here from Bio::RangeI in order to delegate\n            'get' to a L<Bio::Location::CoordinatePolicy> implementing\n            object. Implementing classes may also wish to provide\n            'set' functionality, in which case they *must* override\n            this method. The implementation provided here will throw\n            an exception if called with arguments.\n\n  Returns : A positive integer value.\n  Args    : none\n\nSee L<Bio::Location::CoordinatePolicy> and L<Bio::RangeI> for more\ninformation","parameters":[{"label":"$self"},{"label":"@args"}],"label":"end($self,@args)"},"line":157,"kind":12,"range":{"start":{"line":157,"character":0},"end":{"character":9999,"line":165}},"definition":"sub","detail":"($self,@args)","children":[{"localvar":"my","containerName":"end","kind":13,"name":"$self","line":158,"definition":"my"},{"containerName":"end","kind":13,"name":"@args","line":158},{"name":"$self","kind":13,"containerName":"end","line":163},{"line":163,"containerName":"end","kind":12,"name":"throw_not_implemented"},{"line":163,"containerName":"end","kind":13,"name":"@args"},{"line":164,"name":"$self","containerName":"end","kind":13},{"kind":12,"containerName":"end","name":"coordinate_policy","line":164},{"name":"end","kind":12,"containerName":"end","line":164},{"line":164,"name":"$self","kind":13,"containerName":"end"}],"containerName":"main::","name":"end"},{"signature":{"documentation":"1;\n# $Id: LocationI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::LocationI\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LocationI - Abstract interface of a Location on a Sequence\n\n=head1 SYNOPSIS\n\n    # get a LocationI somehow\n    printf( \"start = %d, end = %d, strand = %s, seq_id = %s\\n\", \n\t    $location->start, $location->end, $location->strand,\n\t    $location->seq_id);\n    print \"location str is \", $location->to_FTstring(), \"\\n\"; \n\n\n=head1 DESCRIPTION\n\nThis Interface defines the methods for a Bio::LocationI, an object\nwhich encapsulates a location on a biological sequence.  Locations\nneed not be attached to actual sequences as they are stand alone\nobjects.  LocationI objects are used by L<Bio::SeqFeatureI> objects to\nmanage and represent locations for a Sequence Feature.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::LocationI;\nuse strict;\n\nuse Carp;\n\nuse base qw(Bio::RangeI);\n\n=head2 location_type\n\n  Title   : location_type\n  Usage   : my $location_type = $location->location_type();\n  Function: Get location type encoded as text\n  Returns : string ('EXACT', 'WITHIN', 'IN-BETWEEN')\n  Args    : none\n\n\nsub location_type { \n    my ($self,@args) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $location->start();\n  Function: Get the start coordinate of this location as defined by\n            the currently active coordinate computation policy. In\n            simple cases, this will return the same number as\n            min_start() and max_start(), in more ambiguous cases like\n            fuzzy locations the number may be equal to one or neither\n            of both.\n\n            We override this here from RangeI in order to delegate\n            'get' to a L<Bio::Location::CoordinatePolicy> implementing\n            object.  Implementing classes may also wish to provide\n            'set' functionality, in which case they *must* override\n            this method. The implementation provided here will throw\n            an exception if called with arguments.\n\n  Returns : A positive integer value.\n  Args    : none\n\nSee L<Bio::Location::CoordinatePolicy> for more information\n\n\nsub start {\n    my ($self,@args) = @_;\n\n    # throw if @args means that we don't support updating information\n    # in the interface but will delegate to the coordinate policy object\n    # for interpreting the 'start' value\n\n    $self->throw_not_implemented if @args;\n    return $self->coordinate_policy()->start($self);\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $location->end();\n  Function: Get the end coordinate of this location as defined by the\n            currently active coordinate computation policy. In simple\n            cases, this will return the same number as min_end() and\n            max_end(), in more ambiguous cases like fuzzy locations\n            the number may be equal to one or neither of both.\n\n            We override this here from Bio::RangeI in order to delegate\n            'get' to a L<Bio::Location::CoordinatePolicy> implementing\n            object. Implementing classes may also wish to provide\n            'set' functionality, in which case they *must* override\n            this method. The implementation provided here will throw\n            an exception if called with arguments.\n\n  Returns : A positive integer value.\n  Args    : none\n\nSee L<Bio::Location::CoordinatePolicy> and L<Bio::RangeI> for more\ninformation\n\n\nsub end {\n    my ($self,@args) = @_;\n\n    # throw if @args means that we don't support updating information\n    # in the interface but will delegate to the coordinate policy object\n    # for interpreting the 'end' value\n    $self->throw_not_implemented if @args;\n    return $self->coordinate_policy()->end($self);\n}\n\n=head2 min_start\n\n  Title   : min_start\n  Usage   : my $minstart = $location->min_start();\n  Function: Get minimum starting point of feature.\n\n            Note that an implementation must not call start() in this method.\n\n  Returns : integer or undef if no minimum starting point.\n  Args    : none","parameters":[{"label":"$self"}],"label":"min_start($self)"},"range":{"end":{"line":183,"character":9999},"start":{"line":180,"character":0}},"kind":12,"line":180,"detail":"($self)","definition":"sub","containerName":"main::","name":"min_start","children":[{"line":181,"name":"$self","kind":13,"localvar":"my","containerName":"min_start","definition":"my"},{"name":"$self","containerName":"min_start","kind":13,"line":182},{"kind":12,"containerName":"min_start","name":"throw_not_implemented","line":182}]},{"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: LocationI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::LocationI\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LocationI - Abstract interface of a Location on a Sequence\n\n=head1 SYNOPSIS\n\n    # get a LocationI somehow\n    printf( \"start = %d, end = %d, strand = %s, seq_id = %s\\n\", \n\t    $location->start, $location->end, $location->strand,\n\t    $location->seq_id);\n    print \"location str is \", $location->to_FTstring(), \"\\n\"; \n\n\n=head1 DESCRIPTION\n\nThis Interface defines the methods for a Bio::LocationI, an object\nwhich encapsulates a location on a biological sequence.  Locations\nneed not be attached to actual sequences as they are stand alone\nobjects.  LocationI objects are used by L<Bio::SeqFeatureI> objects to\nmanage and represent locations for a Sequence Feature.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::LocationI;\nuse strict;\n\nuse Carp;\n\nuse base qw(Bio::RangeI);\n\n=head2 location_type\n\n  Title   : location_type\n  Usage   : my $location_type = $location->location_type();\n  Function: Get location type encoded as text\n  Returns : string ('EXACT', 'WITHIN', 'IN-BETWEEN')\n  Args    : none\n\n\nsub location_type { \n    my ($self,@args) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $location->start();\n  Function: Get the start coordinate of this location as defined by\n            the currently active coordinate computation policy. In\n            simple cases, this will return the same number as\n            min_start() and max_start(), in more ambiguous cases like\n            fuzzy locations the number may be equal to one or neither\n            of both.\n\n            We override this here from RangeI in order to delegate\n            'get' to a L<Bio::Location::CoordinatePolicy> implementing\n            object.  Implementing classes may also wish to provide\n            'set' functionality, in which case they *must* override\n            this method. The implementation provided here will throw\n            an exception if called with arguments.\n\n  Returns : A positive integer value.\n  Args    : none\n\nSee L<Bio::Location::CoordinatePolicy> for more information\n\n\nsub start {\n    my ($self,@args) = @_;\n\n    # throw if @args means that we don't support updating information\n    # in the interface but will delegate to the coordinate policy object\n    # for interpreting the 'start' value\n\n    $self->throw_not_implemented if @args;\n    return $self->coordinate_policy()->start($self);\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $location->end();\n  Function: Get the end coordinate of this location as defined by the\n            currently active coordinate computation policy. In simple\n            cases, this will return the same number as min_end() and\n            max_end(), in more ambiguous cases like fuzzy locations\n            the number may be equal to one or neither of both.\n\n            We override this here from Bio::RangeI in order to delegate\n            'get' to a L<Bio::Location::CoordinatePolicy> implementing\n            object. Implementing classes may also wish to provide\n            'set' functionality, in which case they *must* override\n            this method. The implementation provided here will throw\n            an exception if called with arguments.\n\n  Returns : A positive integer value.\n  Args    : none\n\nSee L<Bio::Location::CoordinatePolicy> and L<Bio::RangeI> for more\ninformation\n\n\nsub end {\n    my ($self,@args) = @_;\n\n    # throw if @args means that we don't support updating information\n    # in the interface but will delegate to the coordinate policy object\n    # for interpreting the 'end' value\n    $self->throw_not_implemented if @args;\n    return $self->coordinate_policy()->end($self);\n}\n\n=head2 min_start\n\n  Title   : min_start\n  Usage   : my $minstart = $location->min_start();\n  Function: Get minimum starting point of feature.\n\n            Note that an implementation must not call start() in this method.\n\n  Returns : integer or undef if no minimum starting point.\n  Args    : none\n\n\nsub min_start {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 max_start\n\n  Title   : max_start\n  Usage   : my $maxstart = $location->max_start();\n  Function: Get maximum starting point of feature.\n\n            Note that an implementation must not call start() in this method\n            unless start() is overridden such as not to delegate to the\n            coordinate computation policy object.\n\n  Returns : integer or undef if no maximum starting point.\n  Args    : none","label":"max_start($self)"},"range":{"start":{"character":0,"line":200},"end":{"line":203,"character":9999}},"kind":12,"line":200,"detail":"($self)","definition":"sub","name":"max_start","containerName":"main::","children":[{"line":201,"localvar":"my","containerName":"max_start","kind":13,"name":"$self","definition":"my"},{"line":202,"name":"$self","kind":13,"containerName":"max_start"},{"kind":12,"containerName":"max_start","name":"throw_not_implemented","line":202}]},{"signature":{"label":"start_pos_type($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: LocationI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::LocationI\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LocationI - Abstract interface of a Location on a Sequence\n\n=head1 SYNOPSIS\n\n    # get a LocationI somehow\n    printf( \"start = %d, end = %d, strand = %s, seq_id = %s\\n\", \n\t    $location->start, $location->end, $location->strand,\n\t    $location->seq_id);\n    print \"location str is \", $location->to_FTstring(), \"\\n\"; \n\n\n=head1 DESCRIPTION\n\nThis Interface defines the methods for a Bio::LocationI, an object\nwhich encapsulates a location on a biological sequence.  Locations\nneed not be attached to actual sequences as they are stand alone\nobjects.  LocationI objects are used by L<Bio::SeqFeatureI> objects to\nmanage and represent locations for a Sequence Feature.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::LocationI;\nuse strict;\n\nuse Carp;\n\nuse base qw(Bio::RangeI);\n\n=head2 location_type\n\n  Title   : location_type\n  Usage   : my $location_type = $location->location_type();\n  Function: Get location type encoded as text\n  Returns : string ('EXACT', 'WITHIN', 'IN-BETWEEN')\n  Args    : none\n\n\nsub location_type { \n    my ($self,@args) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $location->start();\n  Function: Get the start coordinate of this location as defined by\n            the currently active coordinate computation policy. In\n            simple cases, this will return the same number as\n            min_start() and max_start(), in more ambiguous cases like\n            fuzzy locations the number may be equal to one or neither\n            of both.\n\n            We override this here from RangeI in order to delegate\n            'get' to a L<Bio::Location::CoordinatePolicy> implementing\n            object.  Implementing classes may also wish to provide\n            'set' functionality, in which case they *must* override\n            this method. The implementation provided here will throw\n            an exception if called with arguments.\n\n  Returns : A positive integer value.\n  Args    : none\n\nSee L<Bio::Location::CoordinatePolicy> for more information\n\n\nsub start {\n    my ($self,@args) = @_;\n\n    # throw if @args means that we don't support updating information\n    # in the interface but will delegate to the coordinate policy object\n    # for interpreting the 'start' value\n\n    $self->throw_not_implemented if @args;\n    return $self->coordinate_policy()->start($self);\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $location->end();\n  Function: Get the end coordinate of this location as defined by the\n            currently active coordinate computation policy. In simple\n            cases, this will return the same number as min_end() and\n            max_end(), in more ambiguous cases like fuzzy locations\n            the number may be equal to one or neither of both.\n\n            We override this here from Bio::RangeI in order to delegate\n            'get' to a L<Bio::Location::CoordinatePolicy> implementing\n            object. Implementing classes may also wish to provide\n            'set' functionality, in which case they *must* override\n            this method. The implementation provided here will throw\n            an exception if called with arguments.\n\n  Returns : A positive integer value.\n  Args    : none\n\nSee L<Bio::Location::CoordinatePolicy> and L<Bio::RangeI> for more\ninformation\n\n\nsub end {\n    my ($self,@args) = @_;\n\n    # throw if @args means that we don't support updating information\n    # in the interface but will delegate to the coordinate policy object\n    # for interpreting the 'end' value\n    $self->throw_not_implemented if @args;\n    return $self->coordinate_policy()->end($self);\n}\n\n=head2 min_start\n\n  Title   : min_start\n  Usage   : my $minstart = $location->min_start();\n  Function: Get minimum starting point of feature.\n\n            Note that an implementation must not call start() in this method.\n\n  Returns : integer or undef if no minimum starting point.\n  Args    : none\n\n\nsub min_start {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 max_start\n\n  Title   : max_start\n  Usage   : my $maxstart = $location->max_start();\n  Function: Get maximum starting point of feature.\n\n            Note that an implementation must not call start() in this method\n            unless start() is overridden such as not to delegate to the\n            coordinate computation policy object.\n\n  Returns : integer or undef if no maximum starting point.\n  Args    : none\n\n\nsub max_start {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 start_pos_type\n\n  Title   : start_pos_type\n  Usage   : my $start_pos_type = $location->start_pos_type();\n  Function: Get start position type encoded as text\n\n            Known valid values are 'BEFORE' (<5..100), 'AFTER' (>5..100), \n            'EXACT' (5..100), 'WITHIN' ((5.10)..100), 'BETWEEN', (5^6), with\n            their meaning best explained by their GenBank/EMBL location string\n            encoding in brackets.\n\n  Returns : string ('BEFORE', 'AFTER', 'EXACT','WITHIN', 'BETWEEN')\n  Args    : none"},"line":221,"range":{"start":{"line":221,"character":0},"end":{"line":224,"character":9999}},"kind":12,"definition":"sub","detail":"($self)","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"start_pos_type","line":222},{"line":223,"name":"$self","kind":13,"containerName":"start_pos_type"},{"line":223,"name":"throw_not_implemented","containerName":"start_pos_type","kind":12}],"name":"start_pos_type","containerName":"main::"},{"line":238,"range":{"start":{"character":0,"line":238},"end":{"character":9999,"line":241}},"kind":12,"definition":"sub","children":[{"line":239,"name":"$self","localvar":"my","kind":13,"containerName":"flip_strand","definition":"my"},{"name":"$self","kind":13,"containerName":"flip_strand","line":240},{"kind":12,"containerName":"flip_strand","name":"strand","line":240},{"kind":13,"containerName":"flip_strand","name":"$self","line":240},{"kind":12,"containerName":"flip_strand","name":"strand","line":240}],"name":"flip_strand","containerName":"main::"},{"signature":{"label":"min_end($self)","documentation":"1;\n# $Id: LocationI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::LocationI\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LocationI - Abstract interface of a Location on a Sequence\n\n=head1 SYNOPSIS\n\n    # get a LocationI somehow\n    printf( \"start = %d, end = %d, strand = %s, seq_id = %s\\n\", \n\t    $location->start, $location->end, $location->strand,\n\t    $location->seq_id);\n    print \"location str is \", $location->to_FTstring(), \"\\n\"; \n\n\n=head1 DESCRIPTION\n\nThis Interface defines the methods for a Bio::LocationI, an object\nwhich encapsulates a location on a biological sequence.  Locations\nneed not be attached to actual sequences as they are stand alone\nobjects.  LocationI objects are used by L<Bio::SeqFeatureI> objects to\nmanage and represent locations for a Sequence Feature.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::LocationI;\nuse strict;\n\nuse Carp;\n\nuse base qw(Bio::RangeI);\n\n=head2 location_type\n\n  Title   : location_type\n  Usage   : my $location_type = $location->location_type();\n  Function: Get location type encoded as text\n  Returns : string ('EXACT', 'WITHIN', 'IN-BETWEEN')\n  Args    : none\n\n\nsub location_type { \n    my ($self,@args) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $location->start();\n  Function: Get the start coordinate of this location as defined by\n            the currently active coordinate computation policy. In\n            simple cases, this will return the same number as\n            min_start() and max_start(), in more ambiguous cases like\n            fuzzy locations the number may be equal to one or neither\n            of both.\n\n            We override this here from RangeI in order to delegate\n            'get' to a L<Bio::Location::CoordinatePolicy> implementing\n            object.  Implementing classes may also wish to provide\n            'set' functionality, in which case they *must* override\n            this method. The implementation provided here will throw\n            an exception if called with arguments.\n\n  Returns : A positive integer value.\n  Args    : none\n\nSee L<Bio::Location::CoordinatePolicy> for more information\n\n\nsub start {\n    my ($self,@args) = @_;\n\n    # throw if @args means that we don't support updating information\n    # in the interface but will delegate to the coordinate policy object\n    # for interpreting the 'start' value\n\n    $self->throw_not_implemented if @args;\n    return $self->coordinate_policy()->start($self);\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $location->end();\n  Function: Get the end coordinate of this location as defined by the\n            currently active coordinate computation policy. In simple\n            cases, this will return the same number as min_end() and\n            max_end(), in more ambiguous cases like fuzzy locations\n            the number may be equal to one or neither of both.\n\n            We override this here from Bio::RangeI in order to delegate\n            'get' to a L<Bio::Location::CoordinatePolicy> implementing\n            object. Implementing classes may also wish to provide\n            'set' functionality, in which case they *must* override\n            this method. The implementation provided here will throw\n            an exception if called with arguments.\n\n  Returns : A positive integer value.\n  Args    : none\n\nSee L<Bio::Location::CoordinatePolicy> and L<Bio::RangeI> for more\ninformation\n\n\nsub end {\n    my ($self,@args) = @_;\n\n    # throw if @args means that we don't support updating information\n    # in the interface but will delegate to the coordinate policy object\n    # for interpreting the 'end' value\n    $self->throw_not_implemented if @args;\n    return $self->coordinate_policy()->end($self);\n}\n\n=head2 min_start\n\n  Title   : min_start\n  Usage   : my $minstart = $location->min_start();\n  Function: Get minimum starting point of feature.\n\n            Note that an implementation must not call start() in this method.\n\n  Returns : integer or undef if no minimum starting point.\n  Args    : none\n\n\nsub min_start {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 max_start\n\n  Title   : max_start\n  Usage   : my $maxstart = $location->max_start();\n  Function: Get maximum starting point of feature.\n\n            Note that an implementation must not call start() in this method\n            unless start() is overridden such as not to delegate to the\n            coordinate computation policy object.\n\n  Returns : integer or undef if no maximum starting point.\n  Args    : none\n\n\nsub max_start {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 start_pos_type\n\n  Title   : start_pos_type\n  Usage   : my $start_pos_type = $location->start_pos_type();\n  Function: Get start position type encoded as text\n\n            Known valid values are 'BEFORE' (<5..100), 'AFTER' (>5..100), \n            'EXACT' (5..100), 'WITHIN' ((5.10)..100), 'BETWEEN', (5^6), with\n            their meaning best explained by their GenBank/EMBL location string\n            encoding in brackets.\n\n  Returns : string ('BEFORE', 'AFTER', 'EXACT','WITHIN', 'BETWEEN')\n  Args    : none\n\n\nsub start_pos_type {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 flip_strand\n\n  Title   : flip_strand\n  Usage   : $location->flip_strand();\n  Function: Flip-flop a strand to the opposite\n  Returns : None\n  Args    : None\n\n\n\nsub flip_strand {\n    my $self= shift;\n    $self->strand($self->strand * -1);\n}\n\n=head2 min_end\n\n  Title   : min_end\n  Usage   : my $minend = $location->min_end();\n  Function: Get minimum ending point of feature. \n\n            Note that an implementation must not call end() in this method\n            unless end() is overridden such as not to delegate to the\n            coordinate computation policy object.\n\n  Returns : integer or undef if no minimum ending point.\n  Args    : none","parameters":[{"label":"$self"}]},"line":258,"range":{"start":{"line":258,"character":0},"end":{"character":9999,"line":261}},"kind":12,"definition":"sub","detail":"($self)","children":[{"containerName":"min_end","localvar":"my","kind":13,"name":"$self","line":259,"definition":"my"},{"line":260,"name":"$self","kind":13,"containerName":"min_end"},{"line":260,"kind":12,"containerName":"min_end","name":"throw_not_implemented"}],"containerName":"main::","name":"min_end"},{"name":"max_end","containerName":"main::","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"max_end","line":279},{"name":"$self","containerName":"max_end","kind":13,"line":280},{"kind":12,"containerName":"max_end","name":"throw_not_implemented","line":280}],"detail":"($self)","definition":"sub","kind":12,"range":{"end":{"character":9999,"line":281},"start":{"line":278,"character":0}},"line":278,"signature":{"label":"max_end($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: LocationI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::LocationI\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LocationI - Abstract interface of a Location on a Sequence\n\n=head1 SYNOPSIS\n\n    # get a LocationI somehow\n    printf( \"start = %d, end = %d, strand = %s, seq_id = %s\\n\", \n\t    $location->start, $location->end, $location->strand,\n\t    $location->seq_id);\n    print \"location str is \", $location->to_FTstring(), \"\\n\"; \n\n\n=head1 DESCRIPTION\n\nThis Interface defines the methods for a Bio::LocationI, an object\nwhich encapsulates a location on a biological sequence.  Locations\nneed not be attached to actual sequences as they are stand alone\nobjects.  LocationI objects are used by L<Bio::SeqFeatureI> objects to\nmanage and represent locations for a Sequence Feature.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::LocationI;\nuse strict;\n\nuse Carp;\n\nuse base qw(Bio::RangeI);\n\n=head2 location_type\n\n  Title   : location_type\n  Usage   : my $location_type = $location->location_type();\n  Function: Get location type encoded as text\n  Returns : string ('EXACT', 'WITHIN', 'IN-BETWEEN')\n  Args    : none\n\n\nsub location_type { \n    my ($self,@args) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $location->start();\n  Function: Get the start coordinate of this location as defined by\n            the currently active coordinate computation policy. In\n            simple cases, this will return the same number as\n            min_start() and max_start(), in more ambiguous cases like\n            fuzzy locations the number may be equal to one or neither\n            of both.\n\n            We override this here from RangeI in order to delegate\n            'get' to a L<Bio::Location::CoordinatePolicy> implementing\n            object.  Implementing classes may also wish to provide\n            'set' functionality, in which case they *must* override\n            this method. The implementation provided here will throw\n            an exception if called with arguments.\n\n  Returns : A positive integer value.\n  Args    : none\n\nSee L<Bio::Location::CoordinatePolicy> for more information\n\n\nsub start {\n    my ($self,@args) = @_;\n\n    # throw if @args means that we don't support updating information\n    # in the interface but will delegate to the coordinate policy object\n    # for interpreting the 'start' value\n\n    $self->throw_not_implemented if @args;\n    return $self->coordinate_policy()->start($self);\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $location->end();\n  Function: Get the end coordinate of this location as defined by the\n            currently active coordinate computation policy. In simple\n            cases, this will return the same number as min_end() and\n            max_end(), in more ambiguous cases like fuzzy locations\n            the number may be equal to one or neither of both.\n\n            We override this here from Bio::RangeI in order to delegate\n            'get' to a L<Bio::Location::CoordinatePolicy> implementing\n            object. Implementing classes may also wish to provide\n            'set' functionality, in which case they *must* override\n            this method. The implementation provided here will throw\n            an exception if called with arguments.\n\n  Returns : A positive integer value.\n  Args    : none\n\nSee L<Bio::Location::CoordinatePolicy> and L<Bio::RangeI> for more\ninformation\n\n\nsub end {\n    my ($self,@args) = @_;\n\n    # throw if @args means that we don't support updating information\n    # in the interface but will delegate to the coordinate policy object\n    # for interpreting the 'end' value\n    $self->throw_not_implemented if @args;\n    return $self->coordinate_policy()->end($self);\n}\n\n=head2 min_start\n\n  Title   : min_start\n  Usage   : my $minstart = $location->min_start();\n  Function: Get minimum starting point of feature.\n\n            Note that an implementation must not call start() in this method.\n\n  Returns : integer or undef if no minimum starting point.\n  Args    : none\n\n\nsub min_start {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 max_start\n\n  Title   : max_start\n  Usage   : my $maxstart = $location->max_start();\n  Function: Get maximum starting point of feature.\n\n            Note that an implementation must not call start() in this method\n            unless start() is overridden such as not to delegate to the\n            coordinate computation policy object.\n\n  Returns : integer or undef if no maximum starting point.\n  Args    : none\n\n\nsub max_start {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 start_pos_type\n\n  Title   : start_pos_type\n  Usage   : my $start_pos_type = $location->start_pos_type();\n  Function: Get start position type encoded as text\n\n            Known valid values are 'BEFORE' (<5..100), 'AFTER' (>5..100), \n            'EXACT' (5..100), 'WITHIN' ((5.10)..100), 'BETWEEN', (5^6), with\n            their meaning best explained by their GenBank/EMBL location string\n            encoding in brackets.\n\n  Returns : string ('BEFORE', 'AFTER', 'EXACT','WITHIN', 'BETWEEN')\n  Args    : none\n\n\nsub start_pos_type {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 flip_strand\n\n  Title   : flip_strand\n  Usage   : $location->flip_strand();\n  Function: Flip-flop a strand to the opposite\n  Returns : None\n  Args    : None\n\n\n\nsub flip_strand {\n    my $self= shift;\n    $self->strand($self->strand * -1);\n}\n\n=head2 min_end\n\n  Title   : min_end\n  Usage   : my $minend = $location->min_end();\n  Function: Get minimum ending point of feature. \n\n            Note that an implementation must not call end() in this method\n            unless end() is overridden such as not to delegate to the\n            coordinate computation policy object.\n\n  Returns : integer or undef if no minimum ending point.\n  Args    : none\n\n\nsub min_end {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 max_end\n\n  Title   : max_end\n  Usage   : my $maxend = $location->max_end();\n  Function: Get maximum ending point of feature.\n\n            Note that an implementation must not call end() in this method\n            unless end() is overridden such as not to delegate to the\n            coordinate computation policy object.\n\n  Returns : integer or undef if no maximum ending point.\n  Args    : none"}},{"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: LocationI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::LocationI\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LocationI - Abstract interface of a Location on a Sequence\n\n=head1 SYNOPSIS\n\n    # get a LocationI somehow\n    printf( \"start = %d, end = %d, strand = %s, seq_id = %s\\n\", \n\t    $location->start, $location->end, $location->strand,\n\t    $location->seq_id);\n    print \"location str is \", $location->to_FTstring(), \"\\n\"; \n\n\n=head1 DESCRIPTION\n\nThis Interface defines the methods for a Bio::LocationI, an object\nwhich encapsulates a location on a biological sequence.  Locations\nneed not be attached to actual sequences as they are stand alone\nobjects.  LocationI objects are used by L<Bio::SeqFeatureI> objects to\nmanage and represent locations for a Sequence Feature.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::LocationI;\nuse strict;\n\nuse Carp;\n\nuse base qw(Bio::RangeI);\n\n=head2 location_type\n\n  Title   : location_type\n  Usage   : my $location_type = $location->location_type();\n  Function: Get location type encoded as text\n  Returns : string ('EXACT', 'WITHIN', 'IN-BETWEEN')\n  Args    : none\n\n\nsub location_type { \n    my ($self,@args) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $location->start();\n  Function: Get the start coordinate of this location as defined by\n            the currently active coordinate computation policy. In\n            simple cases, this will return the same number as\n            min_start() and max_start(), in more ambiguous cases like\n            fuzzy locations the number may be equal to one or neither\n            of both.\n\n            We override this here from RangeI in order to delegate\n            'get' to a L<Bio::Location::CoordinatePolicy> implementing\n            object.  Implementing classes may also wish to provide\n            'set' functionality, in which case they *must* override\n            this method. The implementation provided here will throw\n            an exception if called with arguments.\n\n  Returns : A positive integer value.\n  Args    : none\n\nSee L<Bio::Location::CoordinatePolicy> for more information\n\n\nsub start {\n    my ($self,@args) = @_;\n\n    # throw if @args means that we don't support updating information\n    # in the interface but will delegate to the coordinate policy object\n    # for interpreting the 'start' value\n\n    $self->throw_not_implemented if @args;\n    return $self->coordinate_policy()->start($self);\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $location->end();\n  Function: Get the end coordinate of this location as defined by the\n            currently active coordinate computation policy. In simple\n            cases, this will return the same number as min_end() and\n            max_end(), in more ambiguous cases like fuzzy locations\n            the number may be equal to one or neither of both.\n\n            We override this here from Bio::RangeI in order to delegate\n            'get' to a L<Bio::Location::CoordinatePolicy> implementing\n            object. Implementing classes may also wish to provide\n            'set' functionality, in which case they *must* override\n            this method. The implementation provided here will throw\n            an exception if called with arguments.\n\n  Returns : A positive integer value.\n  Args    : none\n\nSee L<Bio::Location::CoordinatePolicy> and L<Bio::RangeI> for more\ninformation\n\n\nsub end {\n    my ($self,@args) = @_;\n\n    # throw if @args means that we don't support updating information\n    # in the interface but will delegate to the coordinate policy object\n    # for interpreting the 'end' value\n    $self->throw_not_implemented if @args;\n    return $self->coordinate_policy()->end($self);\n}\n\n=head2 min_start\n\n  Title   : min_start\n  Usage   : my $minstart = $location->min_start();\n  Function: Get minimum starting point of feature.\n\n            Note that an implementation must not call start() in this method.\n\n  Returns : integer or undef if no minimum starting point.\n  Args    : none\n\n\nsub min_start {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 max_start\n\n  Title   : max_start\n  Usage   : my $maxstart = $location->max_start();\n  Function: Get maximum starting point of feature.\n\n            Note that an implementation must not call start() in this method\n            unless start() is overridden such as not to delegate to the\n            coordinate computation policy object.\n\n  Returns : integer or undef if no maximum starting point.\n  Args    : none\n\n\nsub max_start {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 start_pos_type\n\n  Title   : start_pos_type\n  Usage   : my $start_pos_type = $location->start_pos_type();\n  Function: Get start position type encoded as text\n\n            Known valid values are 'BEFORE' (<5..100), 'AFTER' (>5..100), \n            'EXACT' (5..100), 'WITHIN' ((5.10)..100), 'BETWEEN', (5^6), with\n            their meaning best explained by their GenBank/EMBL location string\n            encoding in brackets.\n\n  Returns : string ('BEFORE', 'AFTER', 'EXACT','WITHIN', 'BETWEEN')\n  Args    : none\n\n\nsub start_pos_type {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 flip_strand\n\n  Title   : flip_strand\n  Usage   : $location->flip_strand();\n  Function: Flip-flop a strand to the opposite\n  Returns : None\n  Args    : None\n\n\n\nsub flip_strand {\n    my $self= shift;\n    $self->strand($self->strand * -1);\n}\n\n=head2 min_end\n\n  Title   : min_end\n  Usage   : my $minend = $location->min_end();\n  Function: Get minimum ending point of feature. \n\n            Note that an implementation must not call end() in this method\n            unless end() is overridden such as not to delegate to the\n            coordinate computation policy object.\n\n  Returns : integer or undef if no minimum ending point.\n  Args    : none\n\n\nsub min_end {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 max_end\n\n  Title   : max_end\n  Usage   : my $maxend = $location->max_end();\n  Function: Get maximum ending point of feature.\n\n            Note that an implementation must not call end() in this method\n            unless end() is overridden such as not to delegate to the\n            coordinate computation policy object.\n\n  Returns : integer or undef if no maximum ending point.\n  Args    : none\n\n\nsub max_end {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 end_pos_type\n\n  Title   : end_pos_type\n  Usage   : my $end_pos_type = $location->end_pos_type();\n  Function: Get end position encoded as text.\n\n            Known valid values are 'BEFORE' (5..<100), 'AFTER' (5..>100), \n            'EXACT' (5..100), 'WITHIN' (5..(90.100)), 'BETWEEN', (5^6), with\n            their meaning best explained by their GenBank/EMBL location string\n            encoding in brackets.\n\n  Returns : string ('BEFORE', 'AFTER', 'EXACT','WITHIN', 'BETWEEN')\n  Args    : none","label":"end_pos_type($self)"},"line":299,"kind":12,"range":{"start":{"line":299,"character":0},"end":{"line":302,"character":9999}},"definition":"sub","detail":"($self)","children":[{"name":"$self","localvar":"my","containerName":"end_pos_type","kind":13,"line":300,"definition":"my"},{"line":301,"name":"$self","kind":13,"containerName":"end_pos_type"},{"name":"throw_not_implemented","kind":12,"containerName":"end_pos_type","line":301}],"containerName":"main::","name":"end_pos_type"},{"line":314,"kind":12,"range":{"end":{"line":317,"character":9999},"start":{"character":0,"line":314}},"signature":{"documentation":"1;\n# $Id: LocationI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::LocationI\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LocationI - Abstract interface of a Location on a Sequence\n\n=head1 SYNOPSIS\n\n    # get a LocationI somehow\n    printf( \"start = %d, end = %d, strand = %s, seq_id = %s\\n\", \n\t    $location->start, $location->end, $location->strand,\n\t    $location->seq_id);\n    print \"location str is \", $location->to_FTstring(), \"\\n\"; \n\n\n=head1 DESCRIPTION\n\nThis Interface defines the methods for a Bio::LocationI, an object\nwhich encapsulates a location on a biological sequence.  Locations\nneed not be attached to actual sequences as they are stand alone\nobjects.  LocationI objects are used by L<Bio::SeqFeatureI> objects to\nmanage and represent locations for a Sequence Feature.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::LocationI;\nuse strict;\n\nuse Carp;\n\nuse base qw(Bio::RangeI);\n\n=head2 location_type\n\n  Title   : location_type\n  Usage   : my $location_type = $location->location_type();\n  Function: Get location type encoded as text\n  Returns : string ('EXACT', 'WITHIN', 'IN-BETWEEN')\n  Args    : none\n\n\nsub location_type { \n    my ($self,@args) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $location->start();\n  Function: Get the start coordinate of this location as defined by\n            the currently active coordinate computation policy. In\n            simple cases, this will return the same number as\n            min_start() and max_start(), in more ambiguous cases like\n            fuzzy locations the number may be equal to one or neither\n            of both.\n\n            We override this here from RangeI in order to delegate\n            'get' to a L<Bio::Location::CoordinatePolicy> implementing\n            object.  Implementing classes may also wish to provide\n            'set' functionality, in which case they *must* override\n            this method. The implementation provided here will throw\n            an exception if called with arguments.\n\n  Returns : A positive integer value.\n  Args    : none\n\nSee L<Bio::Location::CoordinatePolicy> for more information\n\n\nsub start {\n    my ($self,@args) = @_;\n\n    # throw if @args means that we don't support updating information\n    # in the interface but will delegate to the coordinate policy object\n    # for interpreting the 'start' value\n\n    $self->throw_not_implemented if @args;\n    return $self->coordinate_policy()->start($self);\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $location->end();\n  Function: Get the end coordinate of this location as defined by the\n            currently active coordinate computation policy. In simple\n            cases, this will return the same number as min_end() and\n            max_end(), in more ambiguous cases like fuzzy locations\n            the number may be equal to one or neither of both.\n\n            We override this here from Bio::RangeI in order to delegate\n            'get' to a L<Bio::Location::CoordinatePolicy> implementing\n            object. Implementing classes may also wish to provide\n            'set' functionality, in which case they *must* override\n            this method. The implementation provided here will throw\n            an exception if called with arguments.\n\n  Returns : A positive integer value.\n  Args    : none\n\nSee L<Bio::Location::CoordinatePolicy> and L<Bio::RangeI> for more\ninformation\n\n\nsub end {\n    my ($self,@args) = @_;\n\n    # throw if @args means that we don't support updating information\n    # in the interface but will delegate to the coordinate policy object\n    # for interpreting the 'end' value\n    $self->throw_not_implemented if @args;\n    return $self->coordinate_policy()->end($self);\n}\n\n=head2 min_start\n\n  Title   : min_start\n  Usage   : my $minstart = $location->min_start();\n  Function: Get minimum starting point of feature.\n\n            Note that an implementation must not call start() in this method.\n\n  Returns : integer or undef if no minimum starting point.\n  Args    : none\n\n\nsub min_start {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 max_start\n\n  Title   : max_start\n  Usage   : my $maxstart = $location->max_start();\n  Function: Get maximum starting point of feature.\n\n            Note that an implementation must not call start() in this method\n            unless start() is overridden such as not to delegate to the\n            coordinate computation policy object.\n\n  Returns : integer or undef if no maximum starting point.\n  Args    : none\n\n\nsub max_start {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 start_pos_type\n\n  Title   : start_pos_type\n  Usage   : my $start_pos_type = $location->start_pos_type();\n  Function: Get start position type encoded as text\n\n            Known valid values are 'BEFORE' (<5..100), 'AFTER' (>5..100), \n            'EXACT' (5..100), 'WITHIN' ((5.10)..100), 'BETWEEN', (5^6), with\n            their meaning best explained by their GenBank/EMBL location string\n            encoding in brackets.\n\n  Returns : string ('BEFORE', 'AFTER', 'EXACT','WITHIN', 'BETWEEN')\n  Args    : none\n\n\nsub start_pos_type {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 flip_strand\n\n  Title   : flip_strand\n  Usage   : $location->flip_strand();\n  Function: Flip-flop a strand to the opposite\n  Returns : None\n  Args    : None\n\n\n\nsub flip_strand {\n    my $self= shift;\n    $self->strand($self->strand * -1);\n}\n\n=head2 min_end\n\n  Title   : min_end\n  Usage   : my $minend = $location->min_end();\n  Function: Get minimum ending point of feature. \n\n            Note that an implementation must not call end() in this method\n            unless end() is overridden such as not to delegate to the\n            coordinate computation policy object.\n\n  Returns : integer or undef if no minimum ending point.\n  Args    : none\n\n\nsub min_end {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 max_end\n\n  Title   : max_end\n  Usage   : my $maxend = $location->max_end();\n  Function: Get maximum ending point of feature.\n\n            Note that an implementation must not call end() in this method\n            unless end() is overridden such as not to delegate to the\n            coordinate computation policy object.\n\n  Returns : integer or undef if no maximum ending point.\n  Args    : none\n\n\nsub max_end {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 end_pos_type\n\n  Title   : end_pos_type\n  Usage   : my $end_pos_type = $location->end_pos_type();\n  Function: Get end position encoded as text.\n\n            Known valid values are 'BEFORE' (5..<100), 'AFTER' (5..>100), \n            'EXACT' (5..100), 'WITHIN' (5..(90.100)), 'BETWEEN', (5^6), with\n            their meaning best explained by their GenBank/EMBL location string\n            encoding in brackets.\n\n  Returns : string ('BEFORE', 'AFTER', 'EXACT','WITHIN', 'BETWEEN')\n  Args    : none\n\n\nsub end_pos_type {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 seq_id\n\n  Title   : seq_id\n  Usage   : my $seqid = $location->seq_id();\n  Function: Get/Set seq_id that location refers to\n  Returns : seq_id (a string)\n  Args    : [optional] seq_id value to set","parameters":[{"label":"$self"}],"label":"seq_id($self)"},"children":[{"name":"$self","kind":13,"localvar":"my","containerName":"seq_id","line":315,"definition":"my"},{"line":316,"kind":13,"containerName":"seq_id","name":"$self"},{"containerName":"seq_id","kind":12,"name":"throw_not_implemented","line":316}],"name":"seq_id","containerName":"main::","definition":"sub","detail":"($self)"},{"line":345,"kind":12,"range":{"start":{"character":0,"line":345},"end":{"character":9999,"line":347}},"definition":"sub","children":[{"line":346,"name":"throw_not_implemented","kind":12,"containerName":"is_remote"}],"name":"is_remote","containerName":"main::"},{"definition":"sub","children":[{"name":"throw_not_implemented","kind":12,"containerName":"coordinate_policy","line":381}],"name":"coordinate_policy","containerName":"main::","line":380,"range":{"end":{"character":9999,"line":382},"start":{"line":380,"character":0}},"kind":12},{"name":"to_FTstring","containerName":"main::","children":[{"definition":"my","containerName":"to_FTstring","localvar":"my","kind":13,"name":"$self","line":395},{"line":396,"name":"$self","kind":13,"containerName":"to_FTstring"},{"name":"throw_not_implemented","kind":12,"containerName":"to_FTstring","line":396}],"detail":"($self)","definition":"sub","range":{"end":{"line":397,"character":9999},"start":{"character":0,"line":394}},"kind":12,"line":394,"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: LocationI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::LocationI\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LocationI - Abstract interface of a Location on a Sequence\n\n=head1 SYNOPSIS\n\n    # get a LocationI somehow\n    printf( \"start = %d, end = %d, strand = %s, seq_id = %s\\n\", \n\t    $location->start, $location->end, $location->strand,\n\t    $location->seq_id);\n    print \"location str is \", $location->to_FTstring(), \"\\n\"; \n\n\n=head1 DESCRIPTION\n\nThis Interface defines the methods for a Bio::LocationI, an object\nwhich encapsulates a location on a biological sequence.  Locations\nneed not be attached to actual sequences as they are stand alone\nobjects.  LocationI objects are used by L<Bio::SeqFeatureI> objects to\nmanage and represent locations for a Sequence Feature.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::LocationI;\nuse strict;\n\nuse Carp;\n\nuse base qw(Bio::RangeI);\n\n=head2 location_type\n\n  Title   : location_type\n  Usage   : my $location_type = $location->location_type();\n  Function: Get location type encoded as text\n  Returns : string ('EXACT', 'WITHIN', 'IN-BETWEEN')\n  Args    : none\n\n\nsub location_type { \n    my ($self,@args) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $location->start();\n  Function: Get the start coordinate of this location as defined by\n            the currently active coordinate computation policy. In\n            simple cases, this will return the same number as\n            min_start() and max_start(), in more ambiguous cases like\n            fuzzy locations the number may be equal to one or neither\n            of both.\n\n            We override this here from RangeI in order to delegate\n            'get' to a L<Bio::Location::CoordinatePolicy> implementing\n            object.  Implementing classes may also wish to provide\n            'set' functionality, in which case they *must* override\n            this method. The implementation provided here will throw\n            an exception if called with arguments.\n\n  Returns : A positive integer value.\n  Args    : none\n\nSee L<Bio::Location::CoordinatePolicy> for more information\n\n\nsub start {\n    my ($self,@args) = @_;\n\n    # throw if @args means that we don't support updating information\n    # in the interface but will delegate to the coordinate policy object\n    # for interpreting the 'start' value\n\n    $self->throw_not_implemented if @args;\n    return $self->coordinate_policy()->start($self);\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $location->end();\n  Function: Get the end coordinate of this location as defined by the\n            currently active coordinate computation policy. In simple\n            cases, this will return the same number as min_end() and\n            max_end(), in more ambiguous cases like fuzzy locations\n            the number may be equal to one or neither of both.\n\n            We override this here from Bio::RangeI in order to delegate\n            'get' to a L<Bio::Location::CoordinatePolicy> implementing\n            object. Implementing classes may also wish to provide\n            'set' functionality, in which case they *must* override\n            this method. The implementation provided here will throw\n            an exception if called with arguments.\n\n  Returns : A positive integer value.\n  Args    : none\n\nSee L<Bio::Location::CoordinatePolicy> and L<Bio::RangeI> for more\ninformation\n\n\nsub end {\n    my ($self,@args) = @_;\n\n    # throw if @args means that we don't support updating information\n    # in the interface but will delegate to the coordinate policy object\n    # for interpreting the 'end' value\n    $self->throw_not_implemented if @args;\n    return $self->coordinate_policy()->end($self);\n}\n\n=head2 min_start\n\n  Title   : min_start\n  Usage   : my $minstart = $location->min_start();\n  Function: Get minimum starting point of feature.\n\n            Note that an implementation must not call start() in this method.\n\n  Returns : integer or undef if no minimum starting point.\n  Args    : none\n\n\nsub min_start {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 max_start\n\n  Title   : max_start\n  Usage   : my $maxstart = $location->max_start();\n  Function: Get maximum starting point of feature.\n\n            Note that an implementation must not call start() in this method\n            unless start() is overridden such as not to delegate to the\n            coordinate computation policy object.\n\n  Returns : integer or undef if no maximum starting point.\n  Args    : none\n\n\nsub max_start {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 start_pos_type\n\n  Title   : start_pos_type\n  Usage   : my $start_pos_type = $location->start_pos_type();\n  Function: Get start position type encoded as text\n\n            Known valid values are 'BEFORE' (<5..100), 'AFTER' (>5..100), \n            'EXACT' (5..100), 'WITHIN' ((5.10)..100), 'BETWEEN', (5^6), with\n            their meaning best explained by their GenBank/EMBL location string\n            encoding in brackets.\n\n  Returns : string ('BEFORE', 'AFTER', 'EXACT','WITHIN', 'BETWEEN')\n  Args    : none\n\n\nsub start_pos_type {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 flip_strand\n\n  Title   : flip_strand\n  Usage   : $location->flip_strand();\n  Function: Flip-flop a strand to the opposite\n  Returns : None\n  Args    : None\n\n\n\nsub flip_strand {\n    my $self= shift;\n    $self->strand($self->strand * -1);\n}\n\n=head2 min_end\n\n  Title   : min_end\n  Usage   : my $minend = $location->min_end();\n  Function: Get minimum ending point of feature. \n\n            Note that an implementation must not call end() in this method\n            unless end() is overridden such as not to delegate to the\n            coordinate computation policy object.\n\n  Returns : integer or undef if no minimum ending point.\n  Args    : none\n\n\nsub min_end {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 max_end\n\n  Title   : max_end\n  Usage   : my $maxend = $location->max_end();\n  Function: Get maximum ending point of feature.\n\n            Note that an implementation must not call end() in this method\n            unless end() is overridden such as not to delegate to the\n            coordinate computation policy object.\n\n  Returns : integer or undef if no maximum ending point.\n  Args    : none\n\n\nsub max_end {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 end_pos_type\n\n  Title   : end_pos_type\n  Usage   : my $end_pos_type = $location->end_pos_type();\n  Function: Get end position encoded as text.\n\n            Known valid values are 'BEFORE' (5..<100), 'AFTER' (5..>100), \n            'EXACT' (5..100), 'WITHIN' (5..(90.100)), 'BETWEEN', (5^6), with\n            their meaning best explained by their GenBank/EMBL location string\n            encoding in brackets.\n\n  Returns : string ('BEFORE', 'AFTER', 'EXACT','WITHIN', 'BETWEEN')\n  Args    : none\n\n\nsub end_pos_type {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 seq_id\n\n  Title   : seq_id\n  Usage   : my $seqid = $location->seq_id();\n  Function: Get/Set seq_id that location refers to\n  Returns : seq_id (a string)\n  Args    : [optional] seq_id value to set\n\n\nsub seq_id {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 is_remote\n\n Title   : is_remote\n Usage   : $is_remote_loc = $loc->is_remote()\n Function: Whether or not a location is a remote location.\n\n           A location is said to be remote if it is on a different\n           'object' than the object which 'has' this\n           location. Typically, features on a sequence will sometimes\n           have a remote location, which means that the location of\n           the feature is on a different sequence than the one that is\n           attached to the feature. In such a case, $loc->seq_id will\n           be different from $feat->seq_id (usually they will be the\n           same).\n\n           While this may sound weird, it reflects the location of the\n           kind of AB18375:450-900 which can be found in GenBank/EMBL\n           feature tables.\n\n Example : \n Returns : TRUE if the location is a remote location, and FALSE otherwise\n Args    : \n\n\n\nsub is_remote{\n    shift->throw_not_implemented();\n}\n\n=head2 coordinate_policy\n\n  Title   : coordinate_policy\n  Usage   : $policy = $location->coordinate_policy();\n            $location->coordinate_policy($mypolicy); # set may not be possible\n  Function: Get the coordinate computing policy employed by this object.\n\n            See L<Bio::Location::CoordinatePolicyI> for documentation\n            about the policy object and its use.\n\n            The interface *does not* require implementing classes to\n            accept setting of a different policy. The implementation\n            provided here does, however, allow to do so.\n\n            Implementors of this interface are expected to initialize\n            every new instance with a\n            L<Bio::Location::CoordinatePolicyI> object. The\n            implementation provided here will return a default policy\n            object if none has been set yet. To change this default\n            policy object call this method as a class method with an\n            appropriate argument. Note that in this case only\n            subsequently created Location objects will be affected.\n\n  Returns : A L<Bio::Location::CoordinatePolicyI> implementing object.\n  Args    : On set, a L<Bio::Location::CoordinatePolicyI> implementing object.\n\nSee L<Bio::Location::CoordinatePolicyI> for more information\n\n\n\nsub coordinate_policy {\n    shift->throw_not_implemented();\n}\n\n=head2 to_FTstring\n\n  Title   : to_FTstring\n  Usage   : my $locstr = $location->to_FTstring()\n  Function: returns the FeatureTable string of this location\n  Returns : string\n  Args    : none","label":"to_FTstring($self)"}},{"containerName":"main::","name":"each_Location","children":[{"line":413,"containerName":"each_Location","localvar":"my","kind":13,"name":"$self","definition":"my"},{"name":"@args","kind":13,"containerName":"each_Location","line":413},{"kind":13,"containerName":"each_Location","name":"$self","line":414},{"line":414,"containerName":"each_Location","kind":12,"name":"throw_not_implemented"}],"detail":"($self,@args)","definition":"sub","range":{"start":{"line":412,"character":0},"end":{"character":9999,"line":415}},"kind":12,"line":412,"signature":{"documentation":"1;\n# $Id: LocationI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::LocationI\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LocationI - Abstract interface of a Location on a Sequence\n\n=head1 SYNOPSIS\n\n    # get a LocationI somehow\n    printf( \"start = %d, end = %d, strand = %s, seq_id = %s\\n\", \n\t    $location->start, $location->end, $location->strand,\n\t    $location->seq_id);\n    print \"location str is \", $location->to_FTstring(), \"\\n\"; \n\n\n=head1 DESCRIPTION\n\nThis Interface defines the methods for a Bio::LocationI, an object\nwhich encapsulates a location on a biological sequence.  Locations\nneed not be attached to actual sequences as they are stand alone\nobjects.  LocationI objects are used by L<Bio::SeqFeatureI> objects to\nmanage and represent locations for a Sequence Feature.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::LocationI;\nuse strict;\n\nuse Carp;\n\nuse base qw(Bio::RangeI);\n\n=head2 location_type\n\n  Title   : location_type\n  Usage   : my $location_type = $location->location_type();\n  Function: Get location type encoded as text\n  Returns : string ('EXACT', 'WITHIN', 'IN-BETWEEN')\n  Args    : none\n\n\nsub location_type { \n    my ($self,@args) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $location->start();\n  Function: Get the start coordinate of this location as defined by\n            the currently active coordinate computation policy. In\n            simple cases, this will return the same number as\n            min_start() and max_start(), in more ambiguous cases like\n            fuzzy locations the number may be equal to one or neither\n            of both.\n\n            We override this here from RangeI in order to delegate\n            'get' to a L<Bio::Location::CoordinatePolicy> implementing\n            object.  Implementing classes may also wish to provide\n            'set' functionality, in which case they *must* override\n            this method. The implementation provided here will throw\n            an exception if called with arguments.\n\n  Returns : A positive integer value.\n  Args    : none\n\nSee L<Bio::Location::CoordinatePolicy> for more information\n\n\nsub start {\n    my ($self,@args) = @_;\n\n    # throw if @args means that we don't support updating information\n    # in the interface but will delegate to the coordinate policy object\n    # for interpreting the 'start' value\n\n    $self->throw_not_implemented if @args;\n    return $self->coordinate_policy()->start($self);\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $location->end();\n  Function: Get the end coordinate of this location as defined by the\n            currently active coordinate computation policy. In simple\n            cases, this will return the same number as min_end() and\n            max_end(), in more ambiguous cases like fuzzy locations\n            the number may be equal to one or neither of both.\n\n            We override this here from Bio::RangeI in order to delegate\n            'get' to a L<Bio::Location::CoordinatePolicy> implementing\n            object. Implementing classes may also wish to provide\n            'set' functionality, in which case they *must* override\n            this method. The implementation provided here will throw\n            an exception if called with arguments.\n\n  Returns : A positive integer value.\n  Args    : none\n\nSee L<Bio::Location::CoordinatePolicy> and L<Bio::RangeI> for more\ninformation\n\n\nsub end {\n    my ($self,@args) = @_;\n\n    # throw if @args means that we don't support updating information\n    # in the interface but will delegate to the coordinate policy object\n    # for interpreting the 'end' value\n    $self->throw_not_implemented if @args;\n    return $self->coordinate_policy()->end($self);\n}\n\n=head2 min_start\n\n  Title   : min_start\n  Usage   : my $minstart = $location->min_start();\n  Function: Get minimum starting point of feature.\n\n            Note that an implementation must not call start() in this method.\n\n  Returns : integer or undef if no minimum starting point.\n  Args    : none\n\n\nsub min_start {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 max_start\n\n  Title   : max_start\n  Usage   : my $maxstart = $location->max_start();\n  Function: Get maximum starting point of feature.\n\n            Note that an implementation must not call start() in this method\n            unless start() is overridden such as not to delegate to the\n            coordinate computation policy object.\n\n  Returns : integer or undef if no maximum starting point.\n  Args    : none\n\n\nsub max_start {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 start_pos_type\n\n  Title   : start_pos_type\n  Usage   : my $start_pos_type = $location->start_pos_type();\n  Function: Get start position type encoded as text\n\n            Known valid values are 'BEFORE' (<5..100), 'AFTER' (>5..100), \n            'EXACT' (5..100), 'WITHIN' ((5.10)..100), 'BETWEEN', (5^6), with\n            their meaning best explained by their GenBank/EMBL location string\n            encoding in brackets.\n\n  Returns : string ('BEFORE', 'AFTER', 'EXACT','WITHIN', 'BETWEEN')\n  Args    : none\n\n\nsub start_pos_type {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 flip_strand\n\n  Title   : flip_strand\n  Usage   : $location->flip_strand();\n  Function: Flip-flop a strand to the opposite\n  Returns : None\n  Args    : None\n\n\n\nsub flip_strand {\n    my $self= shift;\n    $self->strand($self->strand * -1);\n}\n\n=head2 min_end\n\n  Title   : min_end\n  Usage   : my $minend = $location->min_end();\n  Function: Get minimum ending point of feature. \n\n            Note that an implementation must not call end() in this method\n            unless end() is overridden such as not to delegate to the\n            coordinate computation policy object.\n\n  Returns : integer or undef if no minimum ending point.\n  Args    : none\n\n\nsub min_end {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 max_end\n\n  Title   : max_end\n  Usage   : my $maxend = $location->max_end();\n  Function: Get maximum ending point of feature.\n\n            Note that an implementation must not call end() in this method\n            unless end() is overridden such as not to delegate to the\n            coordinate computation policy object.\n\n  Returns : integer or undef if no maximum ending point.\n  Args    : none\n\n\nsub max_end {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 end_pos_type\n\n  Title   : end_pos_type\n  Usage   : my $end_pos_type = $location->end_pos_type();\n  Function: Get end position encoded as text.\n\n            Known valid values are 'BEFORE' (5..<100), 'AFTER' (5..>100), \n            'EXACT' (5..100), 'WITHIN' (5..(90.100)), 'BETWEEN', (5^6), with\n            their meaning best explained by their GenBank/EMBL location string\n            encoding in brackets.\n\n  Returns : string ('BEFORE', 'AFTER', 'EXACT','WITHIN', 'BETWEEN')\n  Args    : none\n\n\nsub end_pos_type {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 seq_id\n\n  Title   : seq_id\n  Usage   : my $seqid = $location->seq_id();\n  Function: Get/Set seq_id that location refers to\n  Returns : seq_id (a string)\n  Args    : [optional] seq_id value to set\n\n\nsub seq_id {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 is_remote\n\n Title   : is_remote\n Usage   : $is_remote_loc = $loc->is_remote()\n Function: Whether or not a location is a remote location.\n\n           A location is said to be remote if it is on a different\n           'object' than the object which 'has' this\n           location. Typically, features on a sequence will sometimes\n           have a remote location, which means that the location of\n           the feature is on a different sequence than the one that is\n           attached to the feature. In such a case, $loc->seq_id will\n           be different from $feat->seq_id (usually they will be the\n           same).\n\n           While this may sound weird, it reflects the location of the\n           kind of AB18375:450-900 which can be found in GenBank/EMBL\n           feature tables.\n\n Example : \n Returns : TRUE if the location is a remote location, and FALSE otherwise\n Args    : \n\n\n\nsub is_remote{\n    shift->throw_not_implemented();\n}\n\n=head2 coordinate_policy\n\n  Title   : coordinate_policy\n  Usage   : $policy = $location->coordinate_policy();\n            $location->coordinate_policy($mypolicy); # set may not be possible\n  Function: Get the coordinate computing policy employed by this object.\n\n            See L<Bio::Location::CoordinatePolicyI> for documentation\n            about the policy object and its use.\n\n            The interface *does not* require implementing classes to\n            accept setting of a different policy. The implementation\n            provided here does, however, allow to do so.\n\n            Implementors of this interface are expected to initialize\n            every new instance with a\n            L<Bio::Location::CoordinatePolicyI> object. The\n            implementation provided here will return a default policy\n            object if none has been set yet. To change this default\n            policy object call this method as a class method with an\n            appropriate argument. Note that in this case only\n            subsequently created Location objects will be affected.\n\n  Returns : A L<Bio::Location::CoordinatePolicyI> implementing object.\n  Args    : On set, a L<Bio::Location::CoordinatePolicyI> implementing object.\n\nSee L<Bio::Location::CoordinatePolicyI> for more information\n\n\n\nsub coordinate_policy {\n    shift->throw_not_implemented();\n}\n\n=head2 to_FTstring\n\n  Title   : to_FTstring\n  Usage   : my $locstr = $location->to_FTstring()\n  Function: returns the FeatureTable string of this location\n  Returns : string\n  Args    : none\n\n\nsub to_FTstring { \n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_Location\n\n Title   : each_Location\n Usage   : @locations = $locObject->each_Location($order);\n Function: Conserved function call across Location:: modules - will\n           return an array containing the component Location(s) in\n           that object, regardless if the calling object is itself a\n           single location or one containing sublocations.\n Returns : an array of Bio::LocationI implementing objects\n Args    : Optional sort order to be passed to sub_Location() for Splits","parameters":[{"label":"$self"},{"label":"@args"}],"label":"each_Location($self,@args)"}},{"children":[{"localvar":"my","containerName":"valid_Location","kind":13,"name":"$self","line":430,"definition":"my"},{"kind":13,"containerName":"valid_Location","name":"@args","line":430},{"name":"$self","containerName":"valid_Location","kind":13,"line":431},{"line":431,"kind":12,"containerName":"valid_Location","name":"throw_not_implemented"}],"name":"valid_Location","containerName":"main::","definition":"sub","detail":"($self,@args)","line":429,"kind":12,"range":{"end":{"line":432,"character":9999},"start":{"character":0,"line":429}},"signature":{"documentation":"1;\n# $Id: LocationI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::LocationI\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LocationI - Abstract interface of a Location on a Sequence\n\n=head1 SYNOPSIS\n\n    # get a LocationI somehow\n    printf( \"start = %d, end = %d, strand = %s, seq_id = %s\\n\", \n\t    $location->start, $location->end, $location->strand,\n\t    $location->seq_id);\n    print \"location str is \", $location->to_FTstring(), \"\\n\"; \n\n\n=head1 DESCRIPTION\n\nThis Interface defines the methods for a Bio::LocationI, an object\nwhich encapsulates a location on a biological sequence.  Locations\nneed not be attached to actual sequences as they are stand alone\nobjects.  LocationI objects are used by L<Bio::SeqFeatureI> objects to\nmanage and represent locations for a Sequence Feature.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::LocationI;\nuse strict;\n\nuse Carp;\n\nuse base qw(Bio::RangeI);\n\n=head2 location_type\n\n  Title   : location_type\n  Usage   : my $location_type = $location->location_type();\n  Function: Get location type encoded as text\n  Returns : string ('EXACT', 'WITHIN', 'IN-BETWEEN')\n  Args    : none\n\n\nsub location_type { \n    my ($self,@args) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $location->start();\n  Function: Get the start coordinate of this location as defined by\n            the currently active coordinate computation policy. In\n            simple cases, this will return the same number as\n            min_start() and max_start(), in more ambiguous cases like\n            fuzzy locations the number may be equal to one or neither\n            of both.\n\n            We override this here from RangeI in order to delegate\n            'get' to a L<Bio::Location::CoordinatePolicy> implementing\n            object.  Implementing classes may also wish to provide\n            'set' functionality, in which case they *must* override\n            this method. The implementation provided here will throw\n            an exception if called with arguments.\n\n  Returns : A positive integer value.\n  Args    : none\n\nSee L<Bio::Location::CoordinatePolicy> for more information\n\n\nsub start {\n    my ($self,@args) = @_;\n\n    # throw if @args means that we don't support updating information\n    # in the interface but will delegate to the coordinate policy object\n    # for interpreting the 'start' value\n\n    $self->throw_not_implemented if @args;\n    return $self->coordinate_policy()->start($self);\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $location->end();\n  Function: Get the end coordinate of this location as defined by the\n            currently active coordinate computation policy. In simple\n            cases, this will return the same number as min_end() and\n            max_end(), in more ambiguous cases like fuzzy locations\n            the number may be equal to one or neither of both.\n\n            We override this here from Bio::RangeI in order to delegate\n            'get' to a L<Bio::Location::CoordinatePolicy> implementing\n            object. Implementing classes may also wish to provide\n            'set' functionality, in which case they *must* override\n            this method. The implementation provided here will throw\n            an exception if called with arguments.\n\n  Returns : A positive integer value.\n  Args    : none\n\nSee L<Bio::Location::CoordinatePolicy> and L<Bio::RangeI> for more\ninformation\n\n\nsub end {\n    my ($self,@args) = @_;\n\n    # throw if @args means that we don't support updating information\n    # in the interface but will delegate to the coordinate policy object\n    # for interpreting the 'end' value\n    $self->throw_not_implemented if @args;\n    return $self->coordinate_policy()->end($self);\n}\n\n=head2 min_start\n\n  Title   : min_start\n  Usage   : my $minstart = $location->min_start();\n  Function: Get minimum starting point of feature.\n\n            Note that an implementation must not call start() in this method.\n\n  Returns : integer or undef if no minimum starting point.\n  Args    : none\n\n\nsub min_start {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 max_start\n\n  Title   : max_start\n  Usage   : my $maxstart = $location->max_start();\n  Function: Get maximum starting point of feature.\n\n            Note that an implementation must not call start() in this method\n            unless start() is overridden such as not to delegate to the\n            coordinate computation policy object.\n\n  Returns : integer or undef if no maximum starting point.\n  Args    : none\n\n\nsub max_start {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 start_pos_type\n\n  Title   : start_pos_type\n  Usage   : my $start_pos_type = $location->start_pos_type();\n  Function: Get start position type encoded as text\n\n            Known valid values are 'BEFORE' (<5..100), 'AFTER' (>5..100), \n            'EXACT' (5..100), 'WITHIN' ((5.10)..100), 'BETWEEN', (5^6), with\n            their meaning best explained by their GenBank/EMBL location string\n            encoding in brackets.\n\n  Returns : string ('BEFORE', 'AFTER', 'EXACT','WITHIN', 'BETWEEN')\n  Args    : none\n\n\nsub start_pos_type {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 flip_strand\n\n  Title   : flip_strand\n  Usage   : $location->flip_strand();\n  Function: Flip-flop a strand to the opposite\n  Returns : None\n  Args    : None\n\n\n\nsub flip_strand {\n    my $self= shift;\n    $self->strand($self->strand * -1);\n}\n\n=head2 min_end\n\n  Title   : min_end\n  Usage   : my $minend = $location->min_end();\n  Function: Get minimum ending point of feature. \n\n            Note that an implementation must not call end() in this method\n            unless end() is overridden such as not to delegate to the\n            coordinate computation policy object.\n\n  Returns : integer or undef if no minimum ending point.\n  Args    : none\n\n\nsub min_end {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 max_end\n\n  Title   : max_end\n  Usage   : my $maxend = $location->max_end();\n  Function: Get maximum ending point of feature.\n\n            Note that an implementation must not call end() in this method\n            unless end() is overridden such as not to delegate to the\n            coordinate computation policy object.\n\n  Returns : integer or undef if no maximum ending point.\n  Args    : none\n\n\nsub max_end {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 end_pos_type\n\n  Title   : end_pos_type\n  Usage   : my $end_pos_type = $location->end_pos_type();\n  Function: Get end position encoded as text.\n\n            Known valid values are 'BEFORE' (5..<100), 'AFTER' (5..>100), \n            'EXACT' (5..100), 'WITHIN' (5..(90.100)), 'BETWEEN', (5^6), with\n            their meaning best explained by their GenBank/EMBL location string\n            encoding in brackets.\n\n  Returns : string ('BEFORE', 'AFTER', 'EXACT','WITHIN', 'BETWEEN')\n  Args    : none\n\n\nsub end_pos_type {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 seq_id\n\n  Title   : seq_id\n  Usage   : my $seqid = $location->seq_id();\n  Function: Get/Set seq_id that location refers to\n  Returns : seq_id (a string)\n  Args    : [optional] seq_id value to set\n\n\nsub seq_id {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 is_remote\n\n Title   : is_remote\n Usage   : $is_remote_loc = $loc->is_remote()\n Function: Whether or not a location is a remote location.\n\n           A location is said to be remote if it is on a different\n           'object' than the object which 'has' this\n           location. Typically, features on a sequence will sometimes\n           have a remote location, which means that the location of\n           the feature is on a different sequence than the one that is\n           attached to the feature. In such a case, $loc->seq_id will\n           be different from $feat->seq_id (usually they will be the\n           same).\n\n           While this may sound weird, it reflects the location of the\n           kind of AB18375:450-900 which can be found in GenBank/EMBL\n           feature tables.\n\n Example : \n Returns : TRUE if the location is a remote location, and FALSE otherwise\n Args    : \n\n\n\nsub is_remote{\n    shift->throw_not_implemented();\n}\n\n=head2 coordinate_policy\n\n  Title   : coordinate_policy\n  Usage   : $policy = $location->coordinate_policy();\n            $location->coordinate_policy($mypolicy); # set may not be possible\n  Function: Get the coordinate computing policy employed by this object.\n\n            See L<Bio::Location::CoordinatePolicyI> for documentation\n            about the policy object and its use.\n\n            The interface *does not* require implementing classes to\n            accept setting of a different policy. The implementation\n            provided here does, however, allow to do so.\n\n            Implementors of this interface are expected to initialize\n            every new instance with a\n            L<Bio::Location::CoordinatePolicyI> object. The\n            implementation provided here will return a default policy\n            object if none has been set yet. To change this default\n            policy object call this method as a class method with an\n            appropriate argument. Note that in this case only\n            subsequently created Location objects will be affected.\n\n  Returns : A L<Bio::Location::CoordinatePolicyI> implementing object.\n  Args    : On set, a L<Bio::Location::CoordinatePolicyI> implementing object.\n\nSee L<Bio::Location::CoordinatePolicyI> for more information\n\n\n\nsub coordinate_policy {\n    shift->throw_not_implemented();\n}\n\n=head2 to_FTstring\n\n  Title   : to_FTstring\n  Usage   : my $locstr = $location->to_FTstring()\n  Function: returns the FeatureTable string of this location\n  Returns : string\n  Args    : none\n\n\nsub to_FTstring { \n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_Location\n\n Title   : each_Location\n Usage   : @locations = $locObject->each_Location($order);\n Function: Conserved function call across Location:: modules - will\n           return an array containing the component Location(s) in\n           that object, regardless if the calling object is itself a\n           single location or one containing sublocations.\n Returns : an array of Bio::LocationI implementing objects\n Args    : Optional sort order to be passed to sub_Location() for Splits\n\n\nsub each_Location {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 valid_Location\n\n Title   : valid_Location\n Usage   : if ($location->valid_location) {...};\n Function: boolean method to determine whether location is considered valid\n           (has minimum requirements for a specific LocationI implementation)\n Returns : Boolean value: true if location is valid, false otherwise\n Args    : none","parameters":[{"label":"$self"},{"label":"@args"}],"label":"valid_Location($self,@args)"}}],"version":5}