{"vars":[{"line":80,"name":"base","kind":2,"containerName":""},{"line":82,"kind":12,"range":{"end":{"character":9999,"line":87},"start":{"line":82,"character":0}},"signature":{"documentation":"","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"},"children":[{"definition":"my","containerName":"new","localvar":"my","kind":13,"name":"$class","line":83},{"line":83,"name":"@args","kind":13,"containerName":"new"},{"line":84,"name":"$self","localvar":"my","containerName":"new","kind":13,"definition":"my"},{"line":84,"name":"$class","kind":13,"containerName":"new"},{"containerName":"new","kind":13,"name":"@args","line":84},{"kind":13,"containerName":"new","name":"$self","line":86}],"name":"new","containerName":"main::","definition":"sub","detail":"($class,@args)"},{"containerName":"new","kind":12,"name":"SUPER","line":84},{"detail":"($self,$loc)","definition":"sub","name":"start","containerName":"main::","children":[{"definition":"my","line":103,"name":"$self","containerName":"start","localvar":"my","kind":13},{"line":103,"name":"$loc","kind":13,"containerName":"start"},{"definition":"my","kind":13,"localvar":"my","containerName":"start","name":"$pos","line":107},{"line":107,"name":"$loc","kind":13,"containerName":"start"},{"name":"min_start","containerName":"start","kind":12,"line":107},{"name":"$pos","kind":13,"containerName":"start","line":109},{"name":"$loc","kind":13,"containerName":"start","line":109},{"kind":12,"containerName":"start","name":"max_start","line":109},{"line":109,"containerName":"start","kind":13,"name":"$pos"},{"line":110,"containerName":"start","kind":13,"name":"$pos"}],"signature":{"label":"start($self,$loc)","documentation":"1;\n# $Id: WidestCoordPolicy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::WidestCoordPolicy\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#          and Jason Stajich <jason@bioperl.org>\n#\n# Copyright Hilmar Lapp, Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::WidestCoordPolicy - class implementing \nBio::Location::CoordinatePolicy as the widest possible and reasonable range\n\n=head1 SYNOPSIS\n\nSee Bio::Location::CoordinatePolicyI\n\n=head1 DESCRIPTION\n\nCoordinatePolicyI implementing objects are used by Bio::LocationI\nimplementing objects to determine integer-valued coordinates when\nasked for it.\n\nThis class will compute the coordinates such that always the widest possible\nrange is returned, but by using some common sense. This means that e.g.\nlocations like \"E<lt>5..100\" (start before position 5) will return 5 as start\n(returned values have to be positive integers).\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp, Jason Stajich\n\nEmail E<lt>hlapp-at-gmx-dot-netE<gt>, E<lt>jason-at-bioperl-dot-orgE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n\npackage Bio::Location::WidestCoordPolicy;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Location::CoordinatePolicyI);\n\nsub new { \n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    return $self;\n}\n\n\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $policy->start($location);\n  Function: Get the integer-valued start coordinate of the given location as\n            computed by this computation policy.\n  Returns : A positive integer number.\n  Args    : A Bio::LocationI implementing object.","parameters":[{"label":"$self"},{"label":"$loc"}]},"kind":12,"range":{"end":{"character":9999,"line":111},"start":{"character":0,"line":102}},"line":102},{"name":"end","containerName":"main::","children":[{"definition":"my","line":125,"name":"$self","localvar":"my","kind":13,"containerName":"end"},{"name":"$loc","containerName":"end","kind":13,"line":125},{"definition":"my","containerName":"end","localvar":"my","kind":13,"name":"$pos","line":129},{"line":129,"name":"$loc","containerName":"end","kind":13},{"containerName":"end","kind":12,"name":"max_end","line":129},{"line":131,"name":"$pos","kind":13,"containerName":"end"},{"line":131,"kind":13,"containerName":"end","name":"$loc"},{"line":131,"name":"min_end","containerName":"end","kind":12},{"line":131,"kind":13,"containerName":"end","name":"$pos"},{"line":132,"kind":13,"containerName":"end","name":"$pos"}],"detail":"($self,$loc)","definition":"sub","kind":12,"range":{"end":{"character":9999,"line":133},"start":{"line":124,"character":0}},"line":124,"signature":{"documentation":"1;\n# $Id: WidestCoordPolicy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::WidestCoordPolicy\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#          and Jason Stajich <jason@bioperl.org>\n#\n# Copyright Hilmar Lapp, Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::WidestCoordPolicy - class implementing \nBio::Location::CoordinatePolicy as the widest possible and reasonable range\n\n=head1 SYNOPSIS\n\nSee Bio::Location::CoordinatePolicyI\n\n=head1 DESCRIPTION\n\nCoordinatePolicyI implementing objects are used by Bio::LocationI\nimplementing objects to determine integer-valued coordinates when\nasked for it.\n\nThis class will compute the coordinates such that always the widest possible\nrange is returned, but by using some common sense. This means that e.g.\nlocations like \"E<lt>5..100\" (start before position 5) will return 5 as start\n(returned values have to be positive integers).\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp, Jason Stajich\n\nEmail E<lt>hlapp-at-gmx-dot-netE<gt>, E<lt>jason-at-bioperl-dot-orgE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n\npackage Bio::Location::WidestCoordPolicy;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Location::CoordinatePolicyI);\n\nsub new { \n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    return $self;\n}\n\n\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $policy->start($location);\n  Function: Get the integer-valued start coordinate of the given location as\n            computed by this computation policy.\n  Returns : A positive integer number.\n  Args    : A Bio::LocationI implementing object.\n\n\nsub start {\n    my ($self,$loc) = @_;\n\n    # For performance reasons we don't check that it's indeed a Bio::LocationI\n    # object. Hopefully, Location-object programmers are smart enough.\n    my $pos = $loc->min_start();\n    # if min is not defined or equals 0 we resort to max\n    $pos = $loc->max_start() if(! $pos);\n    return $pos;\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $policy->end($location);\n  Function: Get the integer-valued end coordinate of the given location as\n            computed by this computation policy.\n  Returns : A positive integer number.\n  Args    : A Bio::LocationI implementing object.","parameters":[{"label":"$self"},{"label":"$loc"}],"label":"end($self,$loc)"}}],"version":5}