{"version":5,"vars":[{"name":"@CORBALOCATIONOPERATOR","containerName":"main::","kind":13,"line":97,"definition":"our"},{"line":97,"name":"Bio::Location::Split","kind":2,"definition":1},{"line":101,"kind":2,"containerName":"","name":"base"},{"range":{"end":{"character":9999,"line":120},"start":{"line":103,"character":0}},"kind":12,"line":103,"signature":{"label":"new($class,@args)","documentation":"","parameters":[{"label":"$class"},{"label":"@args"}]},"containerName":"Bio::Location::Split","name":"new","children":[{"definition":"my","name":"$class","localvar":"my","containerName":"new","kind":13,"line":104},{"name":"@args","kind":13,"containerName":"new","line":104},{"name":"$self","containerName":"new","localvar":"my","kind":13,"line":105,"definition":"my"},{"name":"$class","kind":13,"containerName":"new","line":105},{"line":105,"kind":13,"containerName":"new","name":"@args"},{"name":"$self","containerName":"new","kind":13,"line":107},{"definition":"my","line":108,"name":"$type","kind":13,"localvar":"my","containerName":"new"},{"name":"$seqid","kind":13,"containerName":"new","line":108},{"line":108,"name":"$locations","kind":13,"containerName":"new"},{"line":109,"kind":13,"containerName":"new","name":"$self"},{"containerName":"new","kind":12,"name":"_rearrange","line":109},{"line":112,"name":"@args","kind":13,"containerName":"new"},{"line":113,"name":"$locations","containerName":"new","kind":13},{"line":113,"name":"$locations","kind":13,"containerName":"new"},{"line":114,"containerName":"new","kind":13,"name":"$self"},{"name":"add_sub_Location","containerName":"new","kind":12,"line":114},{"line":114,"containerName":"new","kind":13,"name":"$locations"},{"kind":13,"containerName":"new","name":"$seqid","line":116},{"line":116,"name":"$self","kind":13,"containerName":"new"},{"name":"seq_id","kind":12,"containerName":"new","line":116},{"line":116,"containerName":"new","kind":13,"name":"$seqid"},{"line":117,"containerName":"new","kind":13,"name":"$type"},{"line":117,"containerName":"new","kind":13,"name":"$type"},{"containerName":"new","kind":13,"name":"$self","line":118},{"kind":12,"containerName":"new","name":"splittype","line":118},{"name":"$type","containerName":"new","kind":13,"line":118},{"line":119,"name":"$self","kind":13,"containerName":"new"}],"detail":"($class,@args)","definition":"sub"},{"line":105,"containerName":"new","kind":12,"name":"SUPER"},{"definition":"sub","detail":"($self,$order)","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"each_Location","name":"$self","line":136},{"containerName":"each_Location","kind":13,"name":"$order","line":136},{"line":137,"containerName":"each_Location","localvar":"my","kind":13,"name":"@locs","definition":"my"},{"definition":"my","line":138,"name":"$subloc","containerName":"each_Location","localvar":"my","kind":13},{"name":"$self","kind":13,"containerName":"each_Location","line":138},{"name":"sub_Location","kind":12,"containerName":"each_Location","line":138},{"kind":13,"containerName":"each_Location","name":"$order","line":138},{"line":140,"containerName":"each_Location","kind":13,"name":"@locs"},{"containerName":"each_Location","kind":13,"name":"$subloc","line":140},{"containerName":"each_Location","kind":12,"name":"each_Location","line":140},{"line":140,"name":"$order","kind":13,"containerName":"each_Location"},{"line":142,"containerName":"each_Location","kind":13,"name":"@locs"}],"name":"each_Location","containerName":"Bio::Location::Split","signature":{"documentation":"1;\n# $Id: Split.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::Split\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::Split - Implementation of a Location on a Sequence\nwhich has multiple locations (start/end points)\n\n=head1 SYNOPSIS\n\n    use Bio::Location::Split;\n\n    my $splitlocation = Bio::Location::Split->new();\n    $splitlocation->add_sub_Location(Bio::Location::Simple->new(-start=>1,\n\t\t\t\t\t\t\t       -end=>30,\n\t\t\t\t\t\t\t       -strand=>1));\n    $splitlocation->add_sub_Location(Bio::Location::Simple->new(-start=>50,\n\t\t\t\t\t\t\t       -end=>61,\n\t\t\t\t\t\t\t       -strand=>1));   \n    my @sublocs = $splitlocation->sub_Location();\n\n    my $count = 1;\n    # print the start/end points of the sub locations\n    foreach my $location ( sort { $a->start <=> $b->start } \n\t\t\t   @sublocs ) {\n\tprintf \"sub feature %d [%d..%d]\\n\", \n\t       $count, $location->start,$location->end, \"\\n\";\n        $count++;\n    }\n\n=head1 DESCRIPTION\n\nThis implementation handles locations which span more than one\nstart/end location, or and/or lie on different sequences, and can\nwork with split locations that depend on the specific order of the\nsublocations ('join') or don't have a specific order but represent\na feature spanning discontiguous sublocations ('order', 'bond').\n\nNote that the order in which sublocations are added may be very important,\ndepending on the specific split location type.  For instance, a 'join'\nmust have the sublocations added in the order that one expects to\njoin the sublocations, whereas all other types are sorted based on the\nsequence location.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl_DOT_org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Location::Split;\n\n# as defined by BSANE 0.03\nour @CORBALOCATIONOPERATOR = ('NONE','JOIN', undef, 'ORDER');;\n\nuse Bio::Root::Root;\n\nuse base qw(Bio::Location::Atomic Bio::Location::SplitLocationI);\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    # initialize\n    $self->{'_sublocations'} = [];\n    my ( $type, $seqid, $locations ) = \n\t$self->_rearrange([qw(SPLITTYPE\n                              SEQ_ID\n\t\t\t      LOCATIONS\n                              )], @args);\n    if( defined $locations && ref($locations) =~ /array/i ) {\n\t$self->add_sub_Location(@$locations);\n    }\n    $seqid  && $self->seq_id($seqid);\n    $type = lc ($type);    \n    $self->splittype($type || 'JOIN');\n    return $self;\n}\n\n=head2 each_Location\n\n Title   : each_Location\n Usage   : @locations = $locObject->each_Location($order);\n Function: Conserved function call across Location:: modules - will\n           return an array containing the component Location(s) in\n           that object, regardless if the calling object is itself a\n           single location or one containing sublocations.\n Returns : an array of Bio::LocationI implementing objects\n Args    : Optional sort order to be passed to sub_Location()","parameters":[{"label":"$self"},{"label":"$order"}],"label":"each_Location($self,$order)"},"line":135,"kind":12,"range":{"end":{"character":9999,"line":143},"start":{"character":0,"line":135}}},{"signature":{"label":"sub_Location($self,$order)","documentation":"1;\n# $Id: Split.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::Split\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::Split - Implementation of a Location on a Sequence\nwhich has multiple locations (start/end points)\n\n=head1 SYNOPSIS\n\n    use Bio::Location::Split;\n\n    my $splitlocation = Bio::Location::Split->new();\n    $splitlocation->add_sub_Location(Bio::Location::Simple->new(-start=>1,\n\t\t\t\t\t\t\t       -end=>30,\n\t\t\t\t\t\t\t       -strand=>1));\n    $splitlocation->add_sub_Location(Bio::Location::Simple->new(-start=>50,\n\t\t\t\t\t\t\t       -end=>61,\n\t\t\t\t\t\t\t       -strand=>1));   \n    my @sublocs = $splitlocation->sub_Location();\n\n    my $count = 1;\n    # print the start/end points of the sub locations\n    foreach my $location ( sort { $a->start <=> $b->start } \n\t\t\t   @sublocs ) {\n\tprintf \"sub feature %d [%d..%d]\\n\", \n\t       $count, $location->start,$location->end, \"\\n\";\n        $count++;\n    }\n\n=head1 DESCRIPTION\n\nThis implementation handles locations which span more than one\nstart/end location, or and/or lie on different sequences, and can\nwork with split locations that depend on the specific order of the\nsublocations ('join') or don't have a specific order but represent\na feature spanning discontiguous sublocations ('order', 'bond').\n\nNote that the order in which sublocations are added may be very important,\ndepending on the specific split location type.  For instance, a 'join'\nmust have the sublocations added in the order that one expects to\njoin the sublocations, whereas all other types are sorted based on the\nsequence location.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl_DOT_org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Location::Split;\n\n# as defined by BSANE 0.03\nour @CORBALOCATIONOPERATOR = ('NONE','JOIN', undef, 'ORDER');;\n\nuse Bio::Root::Root;\n\nuse base qw(Bio::Location::Atomic Bio::Location::SplitLocationI);\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    # initialize\n    $self->{'_sublocations'} = [];\n    my ( $type, $seqid, $locations ) = \n\t$self->_rearrange([qw(SPLITTYPE\n                              SEQ_ID\n\t\t\t      LOCATIONS\n                              )], @args);\n    if( defined $locations && ref($locations) =~ /array/i ) {\n\t$self->add_sub_Location(@$locations);\n    }\n    $seqid  && $self->seq_id($seqid);\n    $type = lc ($type);    \n    $self->splittype($type || 'JOIN');\n    return $self;\n}\n\n=head2 each_Location\n\n Title   : each_Location\n Usage   : @locations = $locObject->each_Location($order);\n Function: Conserved function call across Location:: modules - will\n           return an array containing the component Location(s) in\n           that object, regardless if the calling object is itself a\n           single location or one containing sublocations.\n Returns : an array of Bio::LocationI implementing objects\n Args    : Optional sort order to be passed to sub_Location()\n\n\nsub each_Location {\n    my ($self, $order) = @_;\n    my @locs = ();\n    foreach my $subloc ($self->sub_Location($order)) {\n\t# Recursively check to get hierarchical split locations:\n\tpush @locs, $subloc->each_Location($order);\n    }\n    return @locs;\n}\n\n=head2 sub_Location\n\n Title   : sub_Location\n Usage   : @sublocs = $splitloc->sub_Location();\n Function: Returns the array of sublocations making up this compound (split)\n           location. Those sublocations referring to the same sequence as\n           the root split location will be sorted by start position (forward\n           sort) or end position (reverse sort) and come first (before\n           those on other sequences).\n\n           The sort order can be optionally specified or suppressed by the\n           value of the first argument. The default is no sort.\n\n Returns : an array of Bio::LocationI implementing objects\n Args    : Optionally 1, 0, or -1 for specifying a forward, no, or reverse\n           sort order","parameters":[{"label":"$self"},{"label":"$order"}]},"kind":12,"range":{"start":{"line":164,"character":0},"end":{"character":9999,"line":172}},"line":164,"detail":"($self,$order)","definition":"sub","containerName":"Bio::Location::Split","name":"sub_Location","children":[{"line":165,"name":"$self","kind":13,"localvar":"my","containerName":"sub_Location","definition":"my"},{"name":"$order","kind":13,"containerName":"sub_Location","line":165},{"containerName":"sub_Location","kind":13,"name":"$order","line":166},{"containerName":"sub_Location","kind":13,"name":"$order","line":166},{"line":167,"name":"$order","kind":13,"containerName":"sub_Location"},{"kind":13,"containerName":"sub_Location","name":"$order","line":167},{"containerName":"sub_Location","kind":13,"name":"$self","line":168},{"line":168,"kind":12,"containerName":"sub_Location","name":"throw"},{"line":170,"kind":13,"containerName":"sub_Location","name":"$order"},{"line":170,"containerName":"sub_Location","kind":13,"name":"$order"},{"name":"$order","kind":13,"containerName":"sub_Location","line":171},{"line":171,"name":"$order","containerName":"sub_Location","kind":13},{"definition":"my","name":"@sublocs","localvar":"my","kind":13,"containerName":"sub_Location","line":172},{"line":172,"kind":13,"containerName":"sub_Location","name":"$self"},{"name":"$self","containerName":"sub_Location","kind":13,"line":172}]},{"line":175,"containerName":null,"kind":13,"name":"@sublocs"},{"containerName":null,"kind":13,"name":"$order","line":175},{"line":175,"name":"@sublocs","containerName":null,"kind":13},{"definition":"my","name":"$seqid","localvar":"my","kind":13,"containerName":null,"line":179},{"line":179,"name":"$self","kind":13,"containerName":null},{"line":179,"containerName":"Bio::Location::Split","kind":12,"name":"seq_id"},{"name":"$i","kind":13,"localvar":"my","containerName":null,"line":180,"definition":"my"},{"line":181,"name":"$seqid","containerName":null,"kind":13},{"line":181,"containerName":null,"kind":13,"name":"$i"},{"line":181,"name":"sublocs","kind":12},{"line":182,"name":"$seqid","containerName":null,"kind":13},{"line":182,"name":"@sublocs","kind":13,"containerName":null},{"line":182,"name":"$i","containerName":null,"kind":13},{"line":182,"name":"seq_id","kind":12,"containerName":"Bio::Location::Split"},{"name":"$self","kind":13,"containerName":null,"line":184},{"line":184,"name":"seq_id","kind":12,"containerName":"Bio::Location::Split"},{"line":184,"name":"%seqid","containerName":null,"kind":13},{"line":185,"kind":13,"containerName":null,"name":"$self"},{"name":"warn","kind":12,"containerName":"Bio::Location::Split","line":185},{"line":189,"localvar":"my","kind":13,"containerName":null,"name":"@locs","definition":"my"},{"line":189,"containerName":null,"kind":13,"name":"%seqid"},{"line":190,"name":"seq_id","containerName":"Bio::Location::Split","kind":12},{"kind":13,"containerName":null,"name":"$seqid","line":190},{"line":190,"name":"@sublocs","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"@sublocs","line":191},{"name":"@locs","containerName":null,"kind":13,"line":192},{"line":193,"containerName":null,"kind":13,"name":"%order"},{"containerName":null,"kind":13,"name":"@locs","line":195},{"line":197,"name":"$a","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"$b","line":197},{"name":"@a","kind":13,"containerName":null,"line":197},{"containerName":null,"kind":13,"name":"@b","line":197},{"line":198,"containerName":null,"kind":13,"name":"%a"},{"line":201,"name":"start","kind":12,"containerName":"Bio::Location::Split"},{"line":201,"name":"start","containerName":"Bio::Location::Split","kind":12},{"line":201,"name":"end","containerName":"Bio::Location::Split","kind":12},{"kind":13,"containerName":null,"name":"@locs","line":202},{"containerName":null,"kind":13,"name":"@locs","line":204},{"name":"$a","kind":13,"containerName":null,"line":206},{"name":"$b","containerName":null,"kind":13,"line":206},{"line":206,"name":"@b","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"@a","line":206},{"containerName":null,"kind":13,"name":"%a","line":207},{"line":210,"kind":12,"containerName":"Bio::Location::Split","name":"end"},{"containerName":"Bio::Location::Split","kind":12,"name":"end","line":210},{"line":210,"name":"start","containerName":"Bio::Location::Split","kind":12},{"line":211,"containerName":null,"kind":13,"name":"@locs"},{"line":215,"kind":13,"containerName":null,"name":"%seqid"},{"containerName":null,"kind":13,"name":"@locs","line":216},{"line":216,"name":"seq_id","containerName":"Bio::Location::Split","kind":12},{"line":216,"name":"$seqid","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"@sublocs","line":216},{"line":220,"containerName":null,"kind":13,"name":"@locs"},{"detail":"($self,@args)","definition":"sub","name":"add_sub_Location","containerName":"Bio::Location::Split","children":[{"definition":"my","name":"$self","containerName":"add_sub_Location","localvar":"my","kind":13,"line":234},{"name":"@args","containerName":"add_sub_Location","kind":13,"line":234},{"line":235,"name":"@locs","localvar":"my","containerName":"add_sub_Location","kind":13,"definition":"my"},{"containerName":"add_sub_Location","localvar":"my","kind":13,"name":"$loc","line":236,"definition":"my"},{"name":"@args","containerName":"add_sub_Location","kind":13,"line":236},{"kind":13,"containerName":"add_sub_Location","name":"$loc","line":237},{"line":237,"name":"$loc","containerName":"add_sub_Location","kind":13},{"kind":12,"containerName":"add_sub_Location","name":"isa","line":237},{"kind":13,"containerName":"add_sub_Location","name":"$self","line":238},{"name":"throw","containerName":"add_sub_Location","kind":12,"line":238},{"line":241,"containerName":"add_sub_Location","kind":13,"name":"$self"},{"line":241,"containerName":"add_sub_Location","kind":13,"name":"$loc"}],"signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: Split.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::Split\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::Split - Implementation of a Location on a Sequence\nwhich has multiple locations (start/end points)\n\n=head1 SYNOPSIS\n\n    use Bio::Location::Split;\n\n    my $splitlocation = Bio::Location::Split->new();\n    $splitlocation->add_sub_Location(Bio::Location::Simple->new(-start=>1,\n\t\t\t\t\t\t\t       -end=>30,\n\t\t\t\t\t\t\t       -strand=>1));\n    $splitlocation->add_sub_Location(Bio::Location::Simple->new(-start=>50,\n\t\t\t\t\t\t\t       -end=>61,\n\t\t\t\t\t\t\t       -strand=>1));   \n    my @sublocs = $splitlocation->sub_Location();\n\n    my $count = 1;\n    # print the start/end points of the sub locations\n    foreach my $location ( sort { $a->start <=> $b->start } \n\t\t\t   @sublocs ) {\n\tprintf \"sub feature %d [%d..%d]\\n\", \n\t       $count, $location->start,$location->end, \"\\n\";\n        $count++;\n    }\n\n=head1 DESCRIPTION\n\nThis implementation handles locations which span more than one\nstart/end location, or and/or lie on different sequences, and can\nwork with split locations that depend on the specific order of the\nsublocations ('join') or don't have a specific order but represent\na feature spanning discontiguous sublocations ('order', 'bond').\n\nNote that the order in which sublocations are added may be very important,\ndepending on the specific split location type.  For instance, a 'join'\nmust have the sublocations added in the order that one expects to\njoin the sublocations, whereas all other types are sorted based on the\nsequence location.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl_DOT_org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Location::Split;\n\n# as defined by BSANE 0.03\nour @CORBALOCATIONOPERATOR = ('NONE','JOIN', undef, 'ORDER');;\n\nuse Bio::Root::Root;\n\nuse base qw(Bio::Location::Atomic Bio::Location::SplitLocationI);\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    # initialize\n    $self->{'_sublocations'} = [];\n    my ( $type, $seqid, $locations ) = \n\t$self->_rearrange([qw(SPLITTYPE\n                              SEQ_ID\n\t\t\t      LOCATIONS\n                              )], @args);\n    if( defined $locations && ref($locations) =~ /array/i ) {\n\t$self->add_sub_Location(@$locations);\n    }\n    $seqid  && $self->seq_id($seqid);\n    $type = lc ($type);    \n    $self->splittype($type || 'JOIN');\n    return $self;\n}\n\n=head2 each_Location\n\n Title   : each_Location\n Usage   : @locations = $locObject->each_Location($order);\n Function: Conserved function call across Location:: modules - will\n           return an array containing the component Location(s) in\n           that object, regardless if the calling object is itself a\n           single location or one containing sublocations.\n Returns : an array of Bio::LocationI implementing objects\n Args    : Optional sort order to be passed to sub_Location()\n\n\nsub each_Location {\n    my ($self, $order) = @_;\n    my @locs = ();\n    foreach my $subloc ($self->sub_Location($order)) {\n\t# Recursively check to get hierarchical split locations:\n\tpush @locs, $subloc->each_Location($order);\n    }\n    return @locs;\n}\n\n=head2 sub_Location\n\n Title   : sub_Location\n Usage   : @sublocs = $splitloc->sub_Location();\n Function: Returns the array of sublocations making up this compound (split)\n           location. Those sublocations referring to the same sequence as\n           the root split location will be sorted by start position (forward\n           sort) or end position (reverse sort) and come first (before\n           those on other sequences).\n\n           The sort order can be optionally specified or suppressed by the\n           value of the first argument. The default is no sort.\n\n Returns : an array of Bio::LocationI implementing objects\n Args    : Optionally 1, 0, or -1 for specifying a forward, no, or reverse\n           sort order\n\n\nsub sub_Location {\n    my ($self, $order) = @_;\n    $order = 0 unless defined $order;\n    if( defined($order) && ($order !~ /^-?\\d+$/) ) {\n\t$self->throw(\"value $order passed in to sub_Location is $order, an invalid value\");\n    } \n    $order = 1 if($order > 1);\n    $order = -1 if($order < -1);\n    my @sublocs = defined $self->{'_sublocations'} ? @{$self->{'_sublocations'}} : ();\n\n    # return the array if no ordering requested\n    return @sublocs if( ($order == 0) || (! @sublocs) );\n    \t\n    # sort those locations that are on the same sequence as the top (`master')\n    # if the top seq is undefined, we take the first defined in a sublocation\n    my $seqid = $self->seq_id();\n    my $i = 0;\n    while((! defined($seqid)) && ($i <= $#sublocs)) {\n\t\t$seqid = $sublocs[$i++]->seq_id();\n    }\n    if((! $self->seq_id()) && $seqid) {\n\t\t$self->warn(\"sorted sublocation array requested but \".\n\t\t\t\t\"root location doesn't define seq_id \".\n\t\t\t\t\"(at least one sublocation does!)\");\n    }\n    my @locs = ($seqid ?\n\t\tgrep { $_->seq_id() eq $seqid; } @sublocs :\n\t\t@sublocs);\n    if(@locs) {\n\t\tif($order == 1) {\n\t\t\t# Schwartzian transforms for performance boost\t  \n\t\t\t@locs = map { $_->[0] }\n\t\t\tsort {\n\t\t\t\t(defined $a && defined $b) ? $a->[1] <=> $b->[1] :\n                $a                         ?  -1                 : 1\n\t\t\t\t}\n\t\t\tmap {\n\t\t\t\t[$_, (defined $_->start ? $_->start : $_->end)]\n\t\t\t\t} @locs;;\n\t\t} else { # $order == -1\n\t\t\t@locs = map { $_->[0]}\n\t\t\tsort { \n\t\t\t\t(defined $a && defined $b) ? $b->[1] <=> $a->[1] :\n\t\t\t\t$a                         ? -1                  : 1\n\t\t\t\t}\n\t\t\tmap {\n\t\t\t\t[$_, (defined $_->end ? $_->end : $_->start)]\n\t\t\t\t} @locs;\n\t\t}\n    }\n    # push the rest unsorted\n    if($seqid) {\n\t\tpush(@locs, grep { $_->seq_id() ne $seqid; } @sublocs);\n    }\n    # done!\n\n    return @locs;\n}\n\n=head2 add_sub_Location\n\n Title   : add_sub_Location\n Usage   : $splitloc->add_sub_Location(@locationIobjs);\n Function: add an additional sublocation\n Returns : number of current sub locations\n Args    : list of Bio::LocationI implementing object(s) to add","label":"add_sub_Location($self,@args)"},"kind":12,"range":{"end":{"line":242,"character":9999},"start":{"line":233,"character":0}},"line":233},{"line":244,"name":"%self","kind":13,"containerName":null},{"definition":"sub","detail":"($self,$value)","children":[{"line":258,"name":"$self","kind":13,"localvar":"my","containerName":"splittype","definition":"my"},{"containerName":"splittype","kind":13,"name":"$value","line":258},{"name":"$value","containerName":"splittype","kind":13,"line":259},{"name":"$self","containerName":"splittype","kind":13,"line":259},{"name":"$value","kind":13,"containerName":"splittype","line":260},{"name":"$value","kind":13,"containerName":"splittype","line":260},{"name":"$self","kind":13,"containerName":"splittype","line":261},{"containerName":"splittype","kind":13,"name":"$value","line":261},{"name":"$self","containerName":"splittype","kind":13,"line":263}],"name":"splittype","containerName":"Bio::Location::Split","signature":{"label":"splittype($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Split.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::Split\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::Split - Implementation of a Location on a Sequence\nwhich has multiple locations (start/end points)\n\n=head1 SYNOPSIS\n\n    use Bio::Location::Split;\n\n    my $splitlocation = Bio::Location::Split->new();\n    $splitlocation->add_sub_Location(Bio::Location::Simple->new(-start=>1,\n\t\t\t\t\t\t\t       -end=>30,\n\t\t\t\t\t\t\t       -strand=>1));\n    $splitlocation->add_sub_Location(Bio::Location::Simple->new(-start=>50,\n\t\t\t\t\t\t\t       -end=>61,\n\t\t\t\t\t\t\t       -strand=>1));   \n    my @sublocs = $splitlocation->sub_Location();\n\n    my $count = 1;\n    # print the start/end points of the sub locations\n    foreach my $location ( sort { $a->start <=> $b->start } \n\t\t\t   @sublocs ) {\n\tprintf \"sub feature %d [%d..%d]\\n\", \n\t       $count, $location->start,$location->end, \"\\n\";\n        $count++;\n    }\n\n=head1 DESCRIPTION\n\nThis implementation handles locations which span more than one\nstart/end location, or and/or lie on different sequences, and can\nwork with split locations that depend on the specific order of the\nsublocations ('join') or don't have a specific order but represent\na feature spanning discontiguous sublocations ('order', 'bond').\n\nNote that the order in which sublocations are added may be very important,\ndepending on the specific split location type.  For instance, a 'join'\nmust have the sublocations added in the order that one expects to\njoin the sublocations, whereas all other types are sorted based on the\nsequence location.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl_DOT_org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Location::Split;\n\n# as defined by BSANE 0.03\nour @CORBALOCATIONOPERATOR = ('NONE','JOIN', undef, 'ORDER');;\n\nuse Bio::Root::Root;\n\nuse base qw(Bio::Location::Atomic Bio::Location::SplitLocationI);\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    # initialize\n    $self->{'_sublocations'} = [];\n    my ( $type, $seqid, $locations ) = \n\t$self->_rearrange([qw(SPLITTYPE\n                              SEQ_ID\n\t\t\t      LOCATIONS\n                              )], @args);\n    if( defined $locations && ref($locations) =~ /array/i ) {\n\t$self->add_sub_Location(@$locations);\n    }\n    $seqid  && $self->seq_id($seqid);\n    $type = lc ($type);    \n    $self->splittype($type || 'JOIN');\n    return $self;\n}\n\n=head2 each_Location\n\n Title   : each_Location\n Usage   : @locations = $locObject->each_Location($order);\n Function: Conserved function call across Location:: modules - will\n           return an array containing the component Location(s) in\n           that object, regardless if the calling object is itself a\n           single location or one containing sublocations.\n Returns : an array of Bio::LocationI implementing objects\n Args    : Optional sort order to be passed to sub_Location()\n\n\nsub each_Location {\n    my ($self, $order) = @_;\n    my @locs = ();\n    foreach my $subloc ($self->sub_Location($order)) {\n\t# Recursively check to get hierarchical split locations:\n\tpush @locs, $subloc->each_Location($order);\n    }\n    return @locs;\n}\n\n=head2 sub_Location\n\n Title   : sub_Location\n Usage   : @sublocs = $splitloc->sub_Location();\n Function: Returns the array of sublocations making up this compound (split)\n           location. Those sublocations referring to the same sequence as\n           the root split location will be sorted by start position (forward\n           sort) or end position (reverse sort) and come first (before\n           those on other sequences).\n\n           The sort order can be optionally specified or suppressed by the\n           value of the first argument. The default is no sort.\n\n Returns : an array of Bio::LocationI implementing objects\n Args    : Optionally 1, 0, or -1 for specifying a forward, no, or reverse\n           sort order\n\n\nsub sub_Location {\n    my ($self, $order) = @_;\n    $order = 0 unless defined $order;\n    if( defined($order) && ($order !~ /^-?\\d+$/) ) {\n\t$self->throw(\"value $order passed in to sub_Location is $order, an invalid value\");\n    } \n    $order = 1 if($order > 1);\n    $order = -1 if($order < -1);\n    my @sublocs = defined $self->{'_sublocations'} ? @{$self->{'_sublocations'}} : ();\n\n    # return the array if no ordering requested\n    return @sublocs if( ($order == 0) || (! @sublocs) );\n    \t\n    # sort those locations that are on the same sequence as the top (`master')\n    # if the top seq is undefined, we take the first defined in a sublocation\n    my $seqid = $self->seq_id();\n    my $i = 0;\n    while((! defined($seqid)) && ($i <= $#sublocs)) {\n\t\t$seqid = $sublocs[$i++]->seq_id();\n    }\n    if((! $self->seq_id()) && $seqid) {\n\t\t$self->warn(\"sorted sublocation array requested but \".\n\t\t\t\t\"root location doesn't define seq_id \".\n\t\t\t\t\"(at least one sublocation does!)\");\n    }\n    my @locs = ($seqid ?\n\t\tgrep { $_->seq_id() eq $seqid; } @sublocs :\n\t\t@sublocs);\n    if(@locs) {\n\t\tif($order == 1) {\n\t\t\t# Schwartzian transforms for performance boost\t  \n\t\t\t@locs = map { $_->[0] }\n\t\t\tsort {\n\t\t\t\t(defined $a && defined $b) ? $a->[1] <=> $b->[1] :\n                $a                         ?  -1                 : 1\n\t\t\t\t}\n\t\t\tmap {\n\t\t\t\t[$_, (defined $_->start ? $_->start : $_->end)]\n\t\t\t\t} @locs;;\n\t\t} else { # $order == -1\n\t\t\t@locs = map { $_->[0]}\n\t\t\tsort { \n\t\t\t\t(defined $a && defined $b) ? $b->[1] <=> $a->[1] :\n\t\t\t\t$a                         ? -1                  : 1\n\t\t\t\t}\n\t\t\tmap {\n\t\t\t\t[$_, (defined $_->end ? $_->end : $_->start)]\n\t\t\t\t} @locs;\n\t\t}\n    }\n    # push the rest unsorted\n    if($seqid) {\n\t\tpush(@locs, grep { $_->seq_id() ne $seqid; } @sublocs);\n    }\n    # done!\n\n    return @locs;\n}\n\n=head2 add_sub_Location\n\n Title   : add_sub_Location\n Usage   : $splitloc->add_sub_Location(@locationIobjs);\n Function: add an additional sublocation\n Returns : number of current sub locations\n Args    : list of Bio::LocationI implementing object(s) to add\n\n\nsub add_sub_Location {\n    my ($self,@args) = @_;\n    my @locs;    \n    foreach my $loc ( @args ) {\n\tif( !ref($loc) || ! $loc->isa('Bio::LocationI') ) {\n\t    $self->throw(\"Trying to add $loc as a sub Location but it doesn't implement Bio::LocationI!\");\n\t    next;\n\t}\t\n\tpush @{$self->{'_sublocations'}}, $loc;\n    }\n\n    return scalar @{$self->{'_sublocations'}};\n}\n\n=head2 splittype\n\n  Title   : splittype\n  Usage   : $splittype = $location->splittype();\n  Function: get/set the split splittype\n  Returns : the splittype of split feature (join, order)\n  Args    : splittype to set"},"line":257,"range":{"start":{"character":0,"line":257},"end":{"line":264,"character":9999}},"kind":12},{"signature":{"label":"is_single_sequence($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Split.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::Split\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::Split - Implementation of a Location on a Sequence\nwhich has multiple locations (start/end points)\n\n=head1 SYNOPSIS\n\n    use Bio::Location::Split;\n\n    my $splitlocation = Bio::Location::Split->new();\n    $splitlocation->add_sub_Location(Bio::Location::Simple->new(-start=>1,\n\t\t\t\t\t\t\t       -end=>30,\n\t\t\t\t\t\t\t       -strand=>1));\n    $splitlocation->add_sub_Location(Bio::Location::Simple->new(-start=>50,\n\t\t\t\t\t\t\t       -end=>61,\n\t\t\t\t\t\t\t       -strand=>1));   \n    my @sublocs = $splitlocation->sub_Location();\n\n    my $count = 1;\n    # print the start/end points of the sub locations\n    foreach my $location ( sort { $a->start <=> $b->start } \n\t\t\t   @sublocs ) {\n\tprintf \"sub feature %d [%d..%d]\\n\", \n\t       $count, $location->start,$location->end, \"\\n\";\n        $count++;\n    }\n\n=head1 DESCRIPTION\n\nThis implementation handles locations which span more than one\nstart/end location, or and/or lie on different sequences, and can\nwork with split locations that depend on the specific order of the\nsublocations ('join') or don't have a specific order but represent\na feature spanning discontiguous sublocations ('order', 'bond').\n\nNote that the order in which sublocations are added may be very important,\ndepending on the specific split location type.  For instance, a 'join'\nmust have the sublocations added in the order that one expects to\njoin the sublocations, whereas all other types are sorted based on the\nsequence location.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl_DOT_org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Location::Split;\n\n# as defined by BSANE 0.03\nour @CORBALOCATIONOPERATOR = ('NONE','JOIN', undef, 'ORDER');;\n\nuse Bio::Root::Root;\n\nuse base qw(Bio::Location::Atomic Bio::Location::SplitLocationI);\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    # initialize\n    $self->{'_sublocations'} = [];\n    my ( $type, $seqid, $locations ) = \n\t$self->_rearrange([qw(SPLITTYPE\n                              SEQ_ID\n\t\t\t      LOCATIONS\n                              )], @args);\n    if( defined $locations && ref($locations) =~ /array/i ) {\n\t$self->add_sub_Location(@$locations);\n    }\n    $seqid  && $self->seq_id($seqid);\n    $type = lc ($type);    \n    $self->splittype($type || 'JOIN');\n    return $self;\n}\n\n=head2 each_Location\n\n Title   : each_Location\n Usage   : @locations = $locObject->each_Location($order);\n Function: Conserved function call across Location:: modules - will\n           return an array containing the component Location(s) in\n           that object, regardless if the calling object is itself a\n           single location or one containing sublocations.\n Returns : an array of Bio::LocationI implementing objects\n Args    : Optional sort order to be passed to sub_Location()\n\n\nsub each_Location {\n    my ($self, $order) = @_;\n    my @locs = ();\n    foreach my $subloc ($self->sub_Location($order)) {\n\t# Recursively check to get hierarchical split locations:\n\tpush @locs, $subloc->each_Location($order);\n    }\n    return @locs;\n}\n\n=head2 sub_Location\n\n Title   : sub_Location\n Usage   : @sublocs = $splitloc->sub_Location();\n Function: Returns the array of sublocations making up this compound (split)\n           location. Those sublocations referring to the same sequence as\n           the root split location will be sorted by start position (forward\n           sort) or end position (reverse sort) and come first (before\n           those on other sequences).\n\n           The sort order can be optionally specified or suppressed by the\n           value of the first argument. The default is no sort.\n\n Returns : an array of Bio::LocationI implementing objects\n Args    : Optionally 1, 0, or -1 for specifying a forward, no, or reverse\n           sort order\n\n\nsub sub_Location {\n    my ($self, $order) = @_;\n    $order = 0 unless defined $order;\n    if( defined($order) && ($order !~ /^-?\\d+$/) ) {\n\t$self->throw(\"value $order passed in to sub_Location is $order, an invalid value\");\n    } \n    $order = 1 if($order > 1);\n    $order = -1 if($order < -1);\n    my @sublocs = defined $self->{'_sublocations'} ? @{$self->{'_sublocations'}} : ();\n\n    # return the array if no ordering requested\n    return @sublocs if( ($order == 0) || (! @sublocs) );\n    \t\n    # sort those locations that are on the same sequence as the top (`master')\n    # if the top seq is undefined, we take the first defined in a sublocation\n    my $seqid = $self->seq_id();\n    my $i = 0;\n    while((! defined($seqid)) && ($i <= $#sublocs)) {\n\t\t$seqid = $sublocs[$i++]->seq_id();\n    }\n    if((! $self->seq_id()) && $seqid) {\n\t\t$self->warn(\"sorted sublocation array requested but \".\n\t\t\t\t\"root location doesn't define seq_id \".\n\t\t\t\t\"(at least one sublocation does!)\");\n    }\n    my @locs = ($seqid ?\n\t\tgrep { $_->seq_id() eq $seqid; } @sublocs :\n\t\t@sublocs);\n    if(@locs) {\n\t\tif($order == 1) {\n\t\t\t# Schwartzian transforms for performance boost\t  \n\t\t\t@locs = map { $_->[0] }\n\t\t\tsort {\n\t\t\t\t(defined $a && defined $b) ? $a->[1] <=> $b->[1] :\n                $a                         ?  -1                 : 1\n\t\t\t\t}\n\t\t\tmap {\n\t\t\t\t[$_, (defined $_->start ? $_->start : $_->end)]\n\t\t\t\t} @locs;;\n\t\t} else { # $order == -1\n\t\t\t@locs = map { $_->[0]}\n\t\t\tsort { \n\t\t\t\t(defined $a && defined $b) ? $b->[1] <=> $a->[1] :\n\t\t\t\t$a                         ? -1                  : 1\n\t\t\t\t}\n\t\t\tmap {\n\t\t\t\t[$_, (defined $_->end ? $_->end : $_->start)]\n\t\t\t\t} @locs;\n\t\t}\n    }\n    # push the rest unsorted\n    if($seqid) {\n\t\tpush(@locs, grep { $_->seq_id() ne $seqid; } @sublocs);\n    }\n    # done!\n\n    return @locs;\n}\n\n=head2 add_sub_Location\n\n Title   : add_sub_Location\n Usage   : $splitloc->add_sub_Location(@locationIobjs);\n Function: add an additional sublocation\n Returns : number of current sub locations\n Args    : list of Bio::LocationI implementing object(s) to add\n\n\nsub add_sub_Location {\n    my ($self,@args) = @_;\n    my @locs;    \n    foreach my $loc ( @args ) {\n\tif( !ref($loc) || ! $loc->isa('Bio::LocationI') ) {\n\t    $self->throw(\"Trying to add $loc as a sub Location but it doesn't implement Bio::LocationI!\");\n\t    next;\n\t}\t\n\tpush @{$self->{'_sublocations'}}, $loc;\n    }\n\n    return scalar @{$self->{'_sublocations'}};\n}\n\n=head2 splittype\n\n  Title   : splittype\n  Usage   : $splittype = $location->splittype();\n  Function: get/set the split splittype\n  Returns : the splittype of split feature (join, order)\n  Args    : splittype to set\n\n\nsub splittype {\n    my ($self, $value) = @_;\n    if( defined $value || ! defined $self->{'_splittype'} ) {\n\t$value = 'JOIN' unless( defined $value );\n\t$self->{'_splittype'} = uc ($value);\n    }\n    return $self->{'_splittype'};\n}\n\n=head2 is_single_sequence\n\n  Title   : is_single_sequence\n  Usage   : if($splitloc->is_single_sequence()) {\n                print \"Location object $splitloc is split \".\n                      \"but only across a single sequence\\n\";\n\t    }\n  Function: Determine whether this location is split across a single or\n            multiple sequences.\n\n            This implementation ignores (sub-)locations that do not define\n            seq_id(). The same holds true for the root location.\n\n  Returns : TRUE if all sublocations lie on the same sequence as the root\n            location (feature), and FALSE otherwise.\n  Args    : none"},"range":{"end":{"character":9999,"line":296},"start":{"character":0,"line":285}},"kind":12,"line":285,"detail":"($self)","definition":"sub","containerName":"Bio::Location::Split","name":"is_single_sequence","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"is_single_sequence","name":"$self","line":286},{"definition":"my","line":288,"name":"$seqid","localvar":"my","containerName":"is_single_sequence","kind":13},{"name":"$self","kind":13,"containerName":"is_single_sequence","line":288},{"line":288,"kind":12,"containerName":"is_single_sequence","name":"seq_id"},{"definition":"my","line":289,"name":"$loc","kind":13,"localvar":"my","containerName":"is_single_sequence"},{"containerName":"is_single_sequence","kind":13,"name":"$self","line":289},{"name":"sub_Location","kind":12,"containerName":"is_single_sequence","line":289},{"line":290,"containerName":"is_single_sequence","kind":13,"name":"$seqid"},{"kind":13,"containerName":"is_single_sequence","name":"$loc","line":290},{"name":"seq_id","containerName":"is_single_sequence","kind":12,"line":290},{"name":"$seqid","containerName":"is_single_sequence","kind":13,"line":290},{"name":"$loc","kind":13,"containerName":"is_single_sequence","line":291},{"containerName":"is_single_sequence","kind":12,"name":"seq_id","line":291},{"line":291,"containerName":"is_single_sequence","kind":13,"name":"$loc"},{"name":"seq_id","containerName":"is_single_sequence","kind":12,"line":291},{"containerName":"is_single_sequence","kind":13,"name":"$seqid","line":291}]},{"kind":12,"range":{"start":{"character":0,"line":310},"end":{"character":9999,"line":314}},"line":310,"definition":"sub","name":"guide_strand","containerName":"Bio::Location::Split","children":[{"definition":"my","line":311,"localvar":"my","kind":13,"containerName":"guide_strand","name":"$self"},{"line":312,"kind":13,"containerName":"guide_strand","name":"$self"},{"containerName":"guide_strand","kind":13,"name":"$self","line":313}]},{"containerName":"Bio::Location::Split","name":"strand","children":[{"line":339,"localvar":"my","kind":13,"containerName":"strand","name":"$self","definition":"my"},{"name":"$value","kind":13,"containerName":"strand","line":339},{"kind":13,"containerName":"strand","name":"$value","line":340},{"line":341,"name":"$self","containerName":"strand","kind":13},{"line":341,"kind":13,"containerName":"strand","name":"$value"},{"definition":"my","name":"$loc","kind":13,"localvar":"my","containerName":"strand","line":343},{"line":343,"name":"$self","containerName":"strand","kind":13},{"name":"sub_Location","kind":12,"containerName":"strand","line":343},{"containerName":"strand","kind":13,"name":"$loc","line":344},{"name":"strand","containerName":"strand","kind":12,"line":344},{"containerName":"strand","kind":13,"name":"$value","line":344},{"definition":"my","localvar":"my","containerName":"strand","kind":13,"name":"$strand","line":347},{"line":347,"name":"$lstrand","containerName":"strand","kind":13},{"definition":"my","name":"$loc","localvar":"my","containerName":"strand","kind":13,"line":348},{"name":"$self","kind":13,"containerName":"strand","line":348},{"name":"sub_Location","kind":12,"containerName":"strand","line":348},{"line":354,"containerName":"strand","kind":13,"name":"$lstrand"},{"line":354,"name":"$loc","containerName":"strand","kind":13},{"line":354,"name":"strand","containerName":"strand","kind":12},{"line":355,"kind":13,"containerName":"strand","name":"$lstrand"},{"name":"$strand","containerName":"strand","kind":13,"line":356},{"line":356,"kind":13,"containerName":"strand","name":"$strand"},{"line":356,"containerName":"strand","kind":13,"name":"$lstrand"},{"name":"$loc","containerName":"strand","kind":13,"line":357},{"line":357,"containerName":"strand","kind":12,"name":"is_remote"},{"line":358,"kind":13,"containerName":"strand","name":"$strand"},{"line":360,"name":"$strand","containerName":"strand","kind":13},{"line":361,"name":"$strand","kind":13,"containerName":"strand"},{"containerName":"strand","kind":13,"name":"$lstrand","line":361},{"line":364,"name":"$strand","kind":13,"containerName":"strand"}],"detail":"($self,$value)","definition":"sub","range":{"start":{"character":0,"line":338},"end":{"character":9999,"line":366}},"kind":12,"line":338,"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Split.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::Split\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::Split - Implementation of a Location on a Sequence\nwhich has multiple locations (start/end points)\n\n=head1 SYNOPSIS\n\n    use Bio::Location::Split;\n\n    my $splitlocation = Bio::Location::Split->new();\n    $splitlocation->add_sub_Location(Bio::Location::Simple->new(-start=>1,\n\t\t\t\t\t\t\t       -end=>30,\n\t\t\t\t\t\t\t       -strand=>1));\n    $splitlocation->add_sub_Location(Bio::Location::Simple->new(-start=>50,\n\t\t\t\t\t\t\t       -end=>61,\n\t\t\t\t\t\t\t       -strand=>1));   \n    my @sublocs = $splitlocation->sub_Location();\n\n    my $count = 1;\n    # print the start/end points of the sub locations\n    foreach my $location ( sort { $a->start <=> $b->start } \n\t\t\t   @sublocs ) {\n\tprintf \"sub feature %d [%d..%d]\\n\", \n\t       $count, $location->start,$location->end, \"\\n\";\n        $count++;\n    }\n\n=head1 DESCRIPTION\n\nThis implementation handles locations which span more than one\nstart/end location, or and/or lie on different sequences, and can\nwork with split locations that depend on the specific order of the\nsublocations ('join') or don't have a specific order but represent\na feature spanning discontiguous sublocations ('order', 'bond').\n\nNote that the order in which sublocations are added may be very important,\ndepending on the specific split location type.  For instance, a 'join'\nmust have the sublocations added in the order that one expects to\njoin the sublocations, whereas all other types are sorted based on the\nsequence location.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl_DOT_org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Location::Split;\n\n# as defined by BSANE 0.03\nour @CORBALOCATIONOPERATOR = ('NONE','JOIN', undef, 'ORDER');;\n\nuse Bio::Root::Root;\n\nuse base qw(Bio::Location::Atomic Bio::Location::SplitLocationI);\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    # initialize\n    $self->{'_sublocations'} = [];\n    my ( $type, $seqid, $locations ) = \n\t$self->_rearrange([qw(SPLITTYPE\n                              SEQ_ID\n\t\t\t      LOCATIONS\n                              )], @args);\n    if( defined $locations && ref($locations) =~ /array/i ) {\n\t$self->add_sub_Location(@$locations);\n    }\n    $seqid  && $self->seq_id($seqid);\n    $type = lc ($type);    \n    $self->splittype($type || 'JOIN');\n    return $self;\n}\n\n=head2 each_Location\n\n Title   : each_Location\n Usage   : @locations = $locObject->each_Location($order);\n Function: Conserved function call across Location:: modules - will\n           return an array containing the component Location(s) in\n           that object, regardless if the calling object is itself a\n           single location or one containing sublocations.\n Returns : an array of Bio::LocationI implementing objects\n Args    : Optional sort order to be passed to sub_Location()\n\n\nsub each_Location {\n    my ($self, $order) = @_;\n    my @locs = ();\n    foreach my $subloc ($self->sub_Location($order)) {\n\t# Recursively check to get hierarchical split locations:\n\tpush @locs, $subloc->each_Location($order);\n    }\n    return @locs;\n}\n\n=head2 sub_Location\n\n Title   : sub_Location\n Usage   : @sublocs = $splitloc->sub_Location();\n Function: Returns the array of sublocations making up this compound (split)\n           location. Those sublocations referring to the same sequence as\n           the root split location will be sorted by start position (forward\n           sort) or end position (reverse sort) and come first (before\n           those on other sequences).\n\n           The sort order can be optionally specified or suppressed by the\n           value of the first argument. The default is no sort.\n\n Returns : an array of Bio::LocationI implementing objects\n Args    : Optionally 1, 0, or -1 for specifying a forward, no, or reverse\n           sort order\n\n\nsub sub_Location {\n    my ($self, $order) = @_;\n    $order = 0 unless defined $order;\n    if( defined($order) && ($order !~ /^-?\\d+$/) ) {\n\t$self->throw(\"value $order passed in to sub_Location is $order, an invalid value\");\n    } \n    $order = 1 if($order > 1);\n    $order = -1 if($order < -1);\n    my @sublocs = defined $self->{'_sublocations'} ? @{$self->{'_sublocations'}} : ();\n\n    # return the array if no ordering requested\n    return @sublocs if( ($order == 0) || (! @sublocs) );\n    \t\n    # sort those locations that are on the same sequence as the top (`master')\n    # if the top seq is undefined, we take the first defined in a sublocation\n    my $seqid = $self->seq_id();\n    my $i = 0;\n    while((! defined($seqid)) && ($i <= $#sublocs)) {\n\t\t$seqid = $sublocs[$i++]->seq_id();\n    }\n    if((! $self->seq_id()) && $seqid) {\n\t\t$self->warn(\"sorted sublocation array requested but \".\n\t\t\t\t\"root location doesn't define seq_id \".\n\t\t\t\t\"(at least one sublocation does!)\");\n    }\n    my @locs = ($seqid ?\n\t\tgrep { $_->seq_id() eq $seqid; } @sublocs :\n\t\t@sublocs);\n    if(@locs) {\n\t\tif($order == 1) {\n\t\t\t# Schwartzian transforms for performance boost\t  \n\t\t\t@locs = map { $_->[0] }\n\t\t\tsort {\n\t\t\t\t(defined $a && defined $b) ? $a->[1] <=> $b->[1] :\n                $a                         ?  -1                 : 1\n\t\t\t\t}\n\t\t\tmap {\n\t\t\t\t[$_, (defined $_->start ? $_->start : $_->end)]\n\t\t\t\t} @locs;;\n\t\t} else { # $order == -1\n\t\t\t@locs = map { $_->[0]}\n\t\t\tsort { \n\t\t\t\t(defined $a && defined $b) ? $b->[1] <=> $a->[1] :\n\t\t\t\t$a                         ? -1                  : 1\n\t\t\t\t}\n\t\t\tmap {\n\t\t\t\t[$_, (defined $_->end ? $_->end : $_->start)]\n\t\t\t\t} @locs;\n\t\t}\n    }\n    # push the rest unsorted\n    if($seqid) {\n\t\tpush(@locs, grep { $_->seq_id() ne $seqid; } @sublocs);\n    }\n    # done!\n\n    return @locs;\n}\n\n=head2 add_sub_Location\n\n Title   : add_sub_Location\n Usage   : $splitloc->add_sub_Location(@locationIobjs);\n Function: add an additional sublocation\n Returns : number of current sub locations\n Args    : list of Bio::LocationI implementing object(s) to add\n\n\nsub add_sub_Location {\n    my ($self,@args) = @_;\n    my @locs;    \n    foreach my $loc ( @args ) {\n\tif( !ref($loc) || ! $loc->isa('Bio::LocationI') ) {\n\t    $self->throw(\"Trying to add $loc as a sub Location but it doesn't implement Bio::LocationI!\");\n\t    next;\n\t}\t\n\tpush @{$self->{'_sublocations'}}, $loc;\n    }\n\n    return scalar @{$self->{'_sublocations'}};\n}\n\n=head2 splittype\n\n  Title   : splittype\n  Usage   : $splittype = $location->splittype();\n  Function: get/set the split splittype\n  Returns : the splittype of split feature (join, order)\n  Args    : splittype to set\n\n\nsub splittype {\n    my ($self, $value) = @_;\n    if( defined $value || ! defined $self->{'_splittype'} ) {\n\t$value = 'JOIN' unless( defined $value );\n\t$self->{'_splittype'} = uc ($value);\n    }\n    return $self->{'_splittype'};\n}\n\n=head2 is_single_sequence\n\n  Title   : is_single_sequence\n  Usage   : if($splitloc->is_single_sequence()) {\n                print \"Location object $splitloc is split \".\n                      \"but only across a single sequence\\n\";\n\t    }\n  Function: Determine whether this location is split across a single or\n            multiple sequences.\n\n            This implementation ignores (sub-)locations that do not define\n            seq_id(). The same holds true for the root location.\n\n  Returns : TRUE if all sublocations lie on the same sequence as the root\n            location (feature), and FALSE otherwise.\n  Args    : none\n\n\nsub is_single_sequence {\n    my ($self) = @_;\n\n    my $seqid = $self->seq_id();\n    foreach my $loc ($self->sub_Location(0)) {\n\t$seqid = $loc->seq_id() if(! $seqid);\n\tif(defined($loc->seq_id()) && ($loc->seq_id() ne $seqid)) {\n\t    return 0;\n\t}\n    }\n    return 1;\n}\n\n=head2 guide_strand\n\n  Title   : guide_strand\n  Usage   : $str = $loc->guide_strand();\n  Function: Get/Set the guide strand.  Of use only if the split type is\n            a 'join' (this helps determine the order of sublocation\n\t\t\tretrieval)\n  Returns : value of guide strand (1, -1, or undef)\n  Args    : new value (-1 or 1, optional)\n\n\nsub guide_strand {\n\tmy $self = shift;\n\treturn $self->{'strand'} = shift if @_;\n\treturn $self->{'strand'};\n}\n\n=head1 LocationI methods\n\n=head2 strand\n\n Title   : strand\n Usage   : $obj->strand($newval)\n Function: For SplitLocations, setting the strand of the container\n           (this object) is a short-cut for setting the strand of all\n           sublocations.\n\n           In get-mode, checks if no sub-location is remote, and if\n           all have the same strand. If so, it returns that shared\n           strand value. Otherwise it returns undef.\n\n Example : \n Returns : on get, value of strand if identical between sublocations \n           (-1, 1, or undef)\n Args    : new value (-1 or 1, optional)","label":"strand($self,$value)"}},{"children":[{"definition":"my","line":380,"kind":13,"localvar":"my","containerName":"flip_strand","name":"$self"},{"name":"$loc","containerName":"flip_strand","localvar":"my","kind":13,"line":381,"definition":"my"},{"containerName":"flip_strand","kind":13,"name":"$self","line":381},{"kind":12,"containerName":"flip_strand","name":"sub_Location","line":381},{"kind":13,"containerName":"flip_strand","name":"$loc","line":382},{"name":"flip_strand","containerName":"flip_strand","kind":12,"line":382},{"kind":13,"containerName":"flip_strand","name":"$loc","line":383},{"kind":12,"containerName":"flip_strand","name":"isa","line":383},{"name":"$gs","localvar":"my","kind":13,"containerName":"flip_strand","line":384,"definition":"my"},{"kind":13,"containerName":"flip_strand","name":"$self","line":384},{"line":384,"kind":12,"containerName":"flip_strand","name":"guide_strand"},{"name":"$loc","kind":13,"containerName":"flip_strand","line":385},{"line":385,"name":"guide_strand","containerName":"flip_strand","kind":12},{"kind":13,"containerName":"flip_strand","name":"$gs","line":385}],"containerName":"Bio::Location::Split","name":"flip_strand","definition":"sub","line":379,"range":{"start":{"line":379,"character":0},"end":{"line":388,"character":9999}},"kind":12},{"kind":12,"range":{"start":{"character":0,"line":400},"end":{"line":407,"character":9999}},"line":400,"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Split.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::Split\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::Split - Implementation of a Location on a Sequence\nwhich has multiple locations (start/end points)\n\n=head1 SYNOPSIS\n\n    use Bio::Location::Split;\n\n    my $splitlocation = Bio::Location::Split->new();\n    $splitlocation->add_sub_Location(Bio::Location::Simple->new(-start=>1,\n\t\t\t\t\t\t\t       -end=>30,\n\t\t\t\t\t\t\t       -strand=>1));\n    $splitlocation->add_sub_Location(Bio::Location::Simple->new(-start=>50,\n\t\t\t\t\t\t\t       -end=>61,\n\t\t\t\t\t\t\t       -strand=>1));   \n    my @sublocs = $splitlocation->sub_Location();\n\n    my $count = 1;\n    # print the start/end points of the sub locations\n    foreach my $location ( sort { $a->start <=> $b->start } \n\t\t\t   @sublocs ) {\n\tprintf \"sub feature %d [%d..%d]\\n\", \n\t       $count, $location->start,$location->end, \"\\n\";\n        $count++;\n    }\n\n=head1 DESCRIPTION\n\nThis implementation handles locations which span more than one\nstart/end location, or and/or lie on different sequences, and can\nwork with split locations that depend on the specific order of the\nsublocations ('join') or don't have a specific order but represent\na feature spanning discontiguous sublocations ('order', 'bond').\n\nNote that the order in which sublocations are added may be very important,\ndepending on the specific split location type.  For instance, a 'join'\nmust have the sublocations added in the order that one expects to\njoin the sublocations, whereas all other types are sorted based on the\nsequence location.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl_DOT_org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Location::Split;\n\n# as defined by BSANE 0.03\nour @CORBALOCATIONOPERATOR = ('NONE','JOIN', undef, 'ORDER');;\n\nuse Bio::Root::Root;\n\nuse base qw(Bio::Location::Atomic Bio::Location::SplitLocationI);\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    # initialize\n    $self->{'_sublocations'} = [];\n    my ( $type, $seqid, $locations ) = \n\t$self->_rearrange([qw(SPLITTYPE\n                              SEQ_ID\n\t\t\t      LOCATIONS\n                              )], @args);\n    if( defined $locations && ref($locations) =~ /array/i ) {\n\t$self->add_sub_Location(@$locations);\n    }\n    $seqid  && $self->seq_id($seqid);\n    $type = lc ($type);    \n    $self->splittype($type || 'JOIN');\n    return $self;\n}\n\n=head2 each_Location\n\n Title   : each_Location\n Usage   : @locations = $locObject->each_Location($order);\n Function: Conserved function call across Location:: modules - will\n           return an array containing the component Location(s) in\n           that object, regardless if the calling object is itself a\n           single location or one containing sublocations.\n Returns : an array of Bio::LocationI implementing objects\n Args    : Optional sort order to be passed to sub_Location()\n\n\nsub each_Location {\n    my ($self, $order) = @_;\n    my @locs = ();\n    foreach my $subloc ($self->sub_Location($order)) {\n\t# Recursively check to get hierarchical split locations:\n\tpush @locs, $subloc->each_Location($order);\n    }\n    return @locs;\n}\n\n=head2 sub_Location\n\n Title   : sub_Location\n Usage   : @sublocs = $splitloc->sub_Location();\n Function: Returns the array of sublocations making up this compound (split)\n           location. Those sublocations referring to the same sequence as\n           the root split location will be sorted by start position (forward\n           sort) or end position (reverse sort) and come first (before\n           those on other sequences).\n\n           The sort order can be optionally specified or suppressed by the\n           value of the first argument. The default is no sort.\n\n Returns : an array of Bio::LocationI implementing objects\n Args    : Optionally 1, 0, or -1 for specifying a forward, no, or reverse\n           sort order\n\n\nsub sub_Location {\n    my ($self, $order) = @_;\n    $order = 0 unless defined $order;\n    if( defined($order) && ($order !~ /^-?\\d+$/) ) {\n\t$self->throw(\"value $order passed in to sub_Location is $order, an invalid value\");\n    } \n    $order = 1 if($order > 1);\n    $order = -1 if($order < -1);\n    my @sublocs = defined $self->{'_sublocations'} ? @{$self->{'_sublocations'}} : ();\n\n    # return the array if no ordering requested\n    return @sublocs if( ($order == 0) || (! @sublocs) );\n    \t\n    # sort those locations that are on the same sequence as the top (`master')\n    # if the top seq is undefined, we take the first defined in a sublocation\n    my $seqid = $self->seq_id();\n    my $i = 0;\n    while((! defined($seqid)) && ($i <= $#sublocs)) {\n\t\t$seqid = $sublocs[$i++]->seq_id();\n    }\n    if((! $self->seq_id()) && $seqid) {\n\t\t$self->warn(\"sorted sublocation array requested but \".\n\t\t\t\t\"root location doesn't define seq_id \".\n\t\t\t\t\"(at least one sublocation does!)\");\n    }\n    my @locs = ($seqid ?\n\t\tgrep { $_->seq_id() eq $seqid; } @sublocs :\n\t\t@sublocs);\n    if(@locs) {\n\t\tif($order == 1) {\n\t\t\t# Schwartzian transforms for performance boost\t  \n\t\t\t@locs = map { $_->[0] }\n\t\t\tsort {\n\t\t\t\t(defined $a && defined $b) ? $a->[1] <=> $b->[1] :\n                $a                         ?  -1                 : 1\n\t\t\t\t}\n\t\t\tmap {\n\t\t\t\t[$_, (defined $_->start ? $_->start : $_->end)]\n\t\t\t\t} @locs;;\n\t\t} else { # $order == -1\n\t\t\t@locs = map { $_->[0]}\n\t\t\tsort { \n\t\t\t\t(defined $a && defined $b) ? $b->[1] <=> $a->[1] :\n\t\t\t\t$a                         ? -1                  : 1\n\t\t\t\t}\n\t\t\tmap {\n\t\t\t\t[$_, (defined $_->end ? $_->end : $_->start)]\n\t\t\t\t} @locs;\n\t\t}\n    }\n    # push the rest unsorted\n    if($seqid) {\n\t\tpush(@locs, grep { $_->seq_id() ne $seqid; } @sublocs);\n    }\n    # done!\n\n    return @locs;\n}\n\n=head2 add_sub_Location\n\n Title   : add_sub_Location\n Usage   : $splitloc->add_sub_Location(@locationIobjs);\n Function: add an additional sublocation\n Returns : number of current sub locations\n Args    : list of Bio::LocationI implementing object(s) to add\n\n\nsub add_sub_Location {\n    my ($self,@args) = @_;\n    my @locs;    \n    foreach my $loc ( @args ) {\n\tif( !ref($loc) || ! $loc->isa('Bio::LocationI') ) {\n\t    $self->throw(\"Trying to add $loc as a sub Location but it doesn't implement Bio::LocationI!\");\n\t    next;\n\t}\t\n\tpush @{$self->{'_sublocations'}}, $loc;\n    }\n\n    return scalar @{$self->{'_sublocations'}};\n}\n\n=head2 splittype\n\n  Title   : splittype\n  Usage   : $splittype = $location->splittype();\n  Function: get/set the split splittype\n  Returns : the splittype of split feature (join, order)\n  Args    : splittype to set\n\n\nsub splittype {\n    my ($self, $value) = @_;\n    if( defined $value || ! defined $self->{'_splittype'} ) {\n\t$value = 'JOIN' unless( defined $value );\n\t$self->{'_splittype'} = uc ($value);\n    }\n    return $self->{'_splittype'};\n}\n\n=head2 is_single_sequence\n\n  Title   : is_single_sequence\n  Usage   : if($splitloc->is_single_sequence()) {\n                print \"Location object $splitloc is split \".\n                      \"but only across a single sequence\\n\";\n\t    }\n  Function: Determine whether this location is split across a single or\n            multiple sequences.\n\n            This implementation ignores (sub-)locations that do not define\n            seq_id(). The same holds true for the root location.\n\n  Returns : TRUE if all sublocations lie on the same sequence as the root\n            location (feature), and FALSE otherwise.\n  Args    : none\n\n\nsub is_single_sequence {\n    my ($self) = @_;\n\n    my $seqid = $self->seq_id();\n    foreach my $loc ($self->sub_Location(0)) {\n\t$seqid = $loc->seq_id() if(! $seqid);\n\tif(defined($loc->seq_id()) && ($loc->seq_id() ne $seqid)) {\n\t    return 0;\n\t}\n    }\n    return 1;\n}\n\n=head2 guide_strand\n\n  Title   : guide_strand\n  Usage   : $str = $loc->guide_strand();\n  Function: Get/Set the guide strand.  Of use only if the split type is\n            a 'join' (this helps determine the order of sublocation\n\t\t\tretrieval)\n  Returns : value of guide strand (1, -1, or undef)\n  Args    : new value (-1 or 1, optional)\n\n\nsub guide_strand {\n\tmy $self = shift;\n\treturn $self->{'strand'} = shift if @_;\n\treturn $self->{'strand'};\n}\n\n=head1 LocationI methods\n\n=head2 strand\n\n Title   : strand\n Usage   : $obj->strand($newval)\n Function: For SplitLocations, setting the strand of the container\n           (this object) is a short-cut for setting the strand of all\n           sublocations.\n\n           In get-mode, checks if no sub-location is remote, and if\n           all have the same strand. If so, it returns that shared\n           strand value. Otherwise it returns undef.\n\n Example : \n Returns : on get, value of strand if identical between sublocations \n           (-1, 1, or undef)\n Args    : new value (-1 or 1, optional)\n\n\n\nsub strand{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t\t$self->{'strand'} = $value;\n\t\t# propagate to all sublocs\n\t\tforeach my $loc ($self->sub_Location(0)) {\n\t\t\t$loc->strand($value);\n\t\t}\n    } else {\n\t\tmy ($strand, $lstrand);\n\t\tforeach my $loc ($self->sub_Location(0)) {\n\t\t\t# we give up upon any location that's remote or doesn't have\n\t\t\t# the strand specified, or has a differing one set than \n\t\t\t# previously seen.\n\t\t\t# calling strand() is potentially expensive if the subloc is also\n\t\t\t# a split location, so we cache it\n\t\t\t$lstrand = $loc->strand();\n\t\t\tif((! $lstrand) ||\n\t\t\t   ($strand && ($strand != $lstrand)) ||\n\t\t\t   $loc->is_remote()) {\n\t\t\t$strand = undef;\n\t\t\tlast;\n\t\t\t} elsif(! $strand) {\n\t\t\t$strand = $lstrand;\n\t\t\t}\n\t\t}\n\t\treturn $strand;\n    }\n}\n\n=head2 flip_strand\n\n  Title   : flip_strand\n  Usage   : $location->flip_strand();\n  Function: Flip-flop a strand to the opposite.  Also switch Split strand\n            from undef to -1 or -1 to undef\n  Returns : None\n  Args    : None\n\n\nsub flip_strand {\n    my $self = shift;\n    for my $loc ( $self->sub_Location(0) ) {\n\t\t$loc->flip_strand;\n\t\tif ($loc->isa('Bio::Location::SplitLocationI')) {\n\t\t\tmy $gs = ($self->guide_strand == -1) ? undef : -1;\n\t\t\t$loc->guide_strand($gs);\n\t\t}\n    }\n}\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $location->start();\n  Function: get the starting point of the first (sorted) sublocation\n  Returns : integer\n  Args    : none","label":"start($self,$value)"},"containerName":"Bio::Location::Split","name":"start","children":[{"definition":"my","line":401,"name":"$self","containerName":"start","localvar":"my","kind":13},{"line":401,"name":"$value","containerName":"start","kind":13},{"line":402,"kind":13,"containerName":"start","name":"$value"},{"containerName":"start","kind":13,"name":"$self","line":403},{"name":"throw","kind":12,"containerName":"start","line":403},{"line":406,"containerName":"start","kind":13,"name":"$self"}],"detail":"($self,$value)","definition":"sub"},{"kind":12,"containerName":"start","name":"SUPER","line":406},{"kind":12,"range":{"start":{"character":0,"line":419},"end":{"character":9999,"line":426}},"line":419,"signature":{"label":"end($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Split.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::Split\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::Split - Implementation of a Location on a Sequence\nwhich has multiple locations (start/end points)\n\n=head1 SYNOPSIS\n\n    use Bio::Location::Split;\n\n    my $splitlocation = Bio::Location::Split->new();\n    $splitlocation->add_sub_Location(Bio::Location::Simple->new(-start=>1,\n\t\t\t\t\t\t\t       -end=>30,\n\t\t\t\t\t\t\t       -strand=>1));\n    $splitlocation->add_sub_Location(Bio::Location::Simple->new(-start=>50,\n\t\t\t\t\t\t\t       -end=>61,\n\t\t\t\t\t\t\t       -strand=>1));   \n    my @sublocs = $splitlocation->sub_Location();\n\n    my $count = 1;\n    # print the start/end points of the sub locations\n    foreach my $location ( sort { $a->start <=> $b->start } \n\t\t\t   @sublocs ) {\n\tprintf \"sub feature %d [%d..%d]\\n\", \n\t       $count, $location->start,$location->end, \"\\n\";\n        $count++;\n    }\n\n=head1 DESCRIPTION\n\nThis implementation handles locations which span more than one\nstart/end location, or and/or lie on different sequences, and can\nwork with split locations that depend on the specific order of the\nsublocations ('join') or don't have a specific order but represent\na feature spanning discontiguous sublocations ('order', 'bond').\n\nNote that the order in which sublocations are added may be very important,\ndepending on the specific split location type.  For instance, a 'join'\nmust have the sublocations added in the order that one expects to\njoin the sublocations, whereas all other types are sorted based on the\nsequence location.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl_DOT_org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Location::Split;\n\n# as defined by BSANE 0.03\nour @CORBALOCATIONOPERATOR = ('NONE','JOIN', undef, 'ORDER');;\n\nuse Bio::Root::Root;\n\nuse base qw(Bio::Location::Atomic Bio::Location::SplitLocationI);\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    # initialize\n    $self->{'_sublocations'} = [];\n    my ( $type, $seqid, $locations ) = \n\t$self->_rearrange([qw(SPLITTYPE\n                              SEQ_ID\n\t\t\t      LOCATIONS\n                              )], @args);\n    if( defined $locations && ref($locations) =~ /array/i ) {\n\t$self->add_sub_Location(@$locations);\n    }\n    $seqid  && $self->seq_id($seqid);\n    $type = lc ($type);    \n    $self->splittype($type || 'JOIN');\n    return $self;\n}\n\n=head2 each_Location\n\n Title   : each_Location\n Usage   : @locations = $locObject->each_Location($order);\n Function: Conserved function call across Location:: modules - will\n           return an array containing the component Location(s) in\n           that object, regardless if the calling object is itself a\n           single location or one containing sublocations.\n Returns : an array of Bio::LocationI implementing objects\n Args    : Optional sort order to be passed to sub_Location()\n\n\nsub each_Location {\n    my ($self, $order) = @_;\n    my @locs = ();\n    foreach my $subloc ($self->sub_Location($order)) {\n\t# Recursively check to get hierarchical split locations:\n\tpush @locs, $subloc->each_Location($order);\n    }\n    return @locs;\n}\n\n=head2 sub_Location\n\n Title   : sub_Location\n Usage   : @sublocs = $splitloc->sub_Location();\n Function: Returns the array of sublocations making up this compound (split)\n           location. Those sublocations referring to the same sequence as\n           the root split location will be sorted by start position (forward\n           sort) or end position (reverse sort) and come first (before\n           those on other sequences).\n\n           The sort order can be optionally specified or suppressed by the\n           value of the first argument. The default is no sort.\n\n Returns : an array of Bio::LocationI implementing objects\n Args    : Optionally 1, 0, or -1 for specifying a forward, no, or reverse\n           sort order\n\n\nsub sub_Location {\n    my ($self, $order) = @_;\n    $order = 0 unless defined $order;\n    if( defined($order) && ($order !~ /^-?\\d+$/) ) {\n\t$self->throw(\"value $order passed in to sub_Location is $order, an invalid value\");\n    } \n    $order = 1 if($order > 1);\n    $order = -1 if($order < -1);\n    my @sublocs = defined $self->{'_sublocations'} ? @{$self->{'_sublocations'}} : ();\n\n    # return the array if no ordering requested\n    return @sublocs if( ($order == 0) || (! @sublocs) );\n    \t\n    # sort those locations that are on the same sequence as the top (`master')\n    # if the top seq is undefined, we take the first defined in a sublocation\n    my $seqid = $self->seq_id();\n    my $i = 0;\n    while((! defined($seqid)) && ($i <= $#sublocs)) {\n\t\t$seqid = $sublocs[$i++]->seq_id();\n    }\n    if((! $self->seq_id()) && $seqid) {\n\t\t$self->warn(\"sorted sublocation array requested but \".\n\t\t\t\t\"root location doesn't define seq_id \".\n\t\t\t\t\"(at least one sublocation does!)\");\n    }\n    my @locs = ($seqid ?\n\t\tgrep { $_->seq_id() eq $seqid; } @sublocs :\n\t\t@sublocs);\n    if(@locs) {\n\t\tif($order == 1) {\n\t\t\t# Schwartzian transforms for performance boost\t  \n\t\t\t@locs = map { $_->[0] }\n\t\t\tsort {\n\t\t\t\t(defined $a && defined $b) ? $a->[1] <=> $b->[1] :\n                $a                         ?  -1                 : 1\n\t\t\t\t}\n\t\t\tmap {\n\t\t\t\t[$_, (defined $_->start ? $_->start : $_->end)]\n\t\t\t\t} @locs;;\n\t\t} else { # $order == -1\n\t\t\t@locs = map { $_->[0]}\n\t\t\tsort { \n\t\t\t\t(defined $a && defined $b) ? $b->[1] <=> $a->[1] :\n\t\t\t\t$a                         ? -1                  : 1\n\t\t\t\t}\n\t\t\tmap {\n\t\t\t\t[$_, (defined $_->end ? $_->end : $_->start)]\n\t\t\t\t} @locs;\n\t\t}\n    }\n    # push the rest unsorted\n    if($seqid) {\n\t\tpush(@locs, grep { $_->seq_id() ne $seqid; } @sublocs);\n    }\n    # done!\n\n    return @locs;\n}\n\n=head2 add_sub_Location\n\n Title   : add_sub_Location\n Usage   : $splitloc->add_sub_Location(@locationIobjs);\n Function: add an additional sublocation\n Returns : number of current sub locations\n Args    : list of Bio::LocationI implementing object(s) to add\n\n\nsub add_sub_Location {\n    my ($self,@args) = @_;\n    my @locs;    \n    foreach my $loc ( @args ) {\n\tif( !ref($loc) || ! $loc->isa('Bio::LocationI') ) {\n\t    $self->throw(\"Trying to add $loc as a sub Location but it doesn't implement Bio::LocationI!\");\n\t    next;\n\t}\t\n\tpush @{$self->{'_sublocations'}}, $loc;\n    }\n\n    return scalar @{$self->{'_sublocations'}};\n}\n\n=head2 splittype\n\n  Title   : splittype\n  Usage   : $splittype = $location->splittype();\n  Function: get/set the split splittype\n  Returns : the splittype of split feature (join, order)\n  Args    : splittype to set\n\n\nsub splittype {\n    my ($self, $value) = @_;\n    if( defined $value || ! defined $self->{'_splittype'} ) {\n\t$value = 'JOIN' unless( defined $value );\n\t$self->{'_splittype'} = uc ($value);\n    }\n    return $self->{'_splittype'};\n}\n\n=head2 is_single_sequence\n\n  Title   : is_single_sequence\n  Usage   : if($splitloc->is_single_sequence()) {\n                print \"Location object $splitloc is split \".\n                      \"but only across a single sequence\\n\";\n\t    }\n  Function: Determine whether this location is split across a single or\n            multiple sequences.\n\n            This implementation ignores (sub-)locations that do not define\n            seq_id(). The same holds true for the root location.\n\n  Returns : TRUE if all sublocations lie on the same sequence as the root\n            location (feature), and FALSE otherwise.\n  Args    : none\n\n\nsub is_single_sequence {\n    my ($self) = @_;\n\n    my $seqid = $self->seq_id();\n    foreach my $loc ($self->sub_Location(0)) {\n\t$seqid = $loc->seq_id() if(! $seqid);\n\tif(defined($loc->seq_id()) && ($loc->seq_id() ne $seqid)) {\n\t    return 0;\n\t}\n    }\n    return 1;\n}\n\n=head2 guide_strand\n\n  Title   : guide_strand\n  Usage   : $str = $loc->guide_strand();\n  Function: Get/Set the guide strand.  Of use only if the split type is\n            a 'join' (this helps determine the order of sublocation\n\t\t\tretrieval)\n  Returns : value of guide strand (1, -1, or undef)\n  Args    : new value (-1 or 1, optional)\n\n\nsub guide_strand {\n\tmy $self = shift;\n\treturn $self->{'strand'} = shift if @_;\n\treturn $self->{'strand'};\n}\n\n=head1 LocationI methods\n\n=head2 strand\n\n Title   : strand\n Usage   : $obj->strand($newval)\n Function: For SplitLocations, setting the strand of the container\n           (this object) is a short-cut for setting the strand of all\n           sublocations.\n\n           In get-mode, checks if no sub-location is remote, and if\n           all have the same strand. If so, it returns that shared\n           strand value. Otherwise it returns undef.\n\n Example : \n Returns : on get, value of strand if identical between sublocations \n           (-1, 1, or undef)\n Args    : new value (-1 or 1, optional)\n\n\n\nsub strand{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t\t$self->{'strand'} = $value;\n\t\t# propagate to all sublocs\n\t\tforeach my $loc ($self->sub_Location(0)) {\n\t\t\t$loc->strand($value);\n\t\t}\n    } else {\n\t\tmy ($strand, $lstrand);\n\t\tforeach my $loc ($self->sub_Location(0)) {\n\t\t\t# we give up upon any location that's remote or doesn't have\n\t\t\t# the strand specified, or has a differing one set than \n\t\t\t# previously seen.\n\t\t\t# calling strand() is potentially expensive if the subloc is also\n\t\t\t# a split location, so we cache it\n\t\t\t$lstrand = $loc->strand();\n\t\t\tif((! $lstrand) ||\n\t\t\t   ($strand && ($strand != $lstrand)) ||\n\t\t\t   $loc->is_remote()) {\n\t\t\t$strand = undef;\n\t\t\tlast;\n\t\t\t} elsif(! $strand) {\n\t\t\t$strand = $lstrand;\n\t\t\t}\n\t\t}\n\t\treturn $strand;\n    }\n}\n\n=head2 flip_strand\n\n  Title   : flip_strand\n  Usage   : $location->flip_strand();\n  Function: Flip-flop a strand to the opposite.  Also switch Split strand\n            from undef to -1 or -1 to undef\n  Returns : None\n  Args    : None\n\n\nsub flip_strand {\n    my $self = shift;\n    for my $loc ( $self->sub_Location(0) ) {\n\t\t$loc->flip_strand;\n\t\tif ($loc->isa('Bio::Location::SplitLocationI')) {\n\t\t\tmy $gs = ($self->guide_strand == -1) ? undef : -1;\n\t\t\t$loc->guide_strand($gs);\n\t\t}\n    }\n}\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $location->start();\n  Function: get the starting point of the first (sorted) sublocation\n  Returns : integer\n  Args    : none\n\n\nsub start {\n    my ($self,$value) = @_;    \n    if( defined $value ) {\n\t$self->throw(\"Trying to set the starting point of a split location, \".\n\t\t\t\t \"that is not possible, try manipulating the sub Locations\");\n    }\n    return $self->SUPER::start();\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $location->end();\n  Function: get the ending point of the last (sorted) sublocation\n  Returns : integer\n  Args    : none"},"name":"end","containerName":"Bio::Location::Split","children":[{"definition":"my","containerName":"end","localvar":"my","kind":13,"name":"$self","line":420},{"line":420,"containerName":"end","kind":13,"name":"$value"},{"line":421,"name":"$value","containerName":"end","kind":13},{"name":"$self","containerName":"end","kind":13,"line":422},{"containerName":"end","kind":12,"name":"throw","line":422},{"name":"$self","kind":13,"containerName":"end","line":425}],"detail":"($self,$value)","definition":"sub"},{"kind":12,"containerName":"end","name":"SUPER","line":425},{"line":438,"range":{"start":{"line":438,"character":0},"end":{"line":448,"character":9999}},"kind":12,"signature":{"documentation":"1;\n# $Id: Split.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::Split\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::Split - Implementation of a Location on a Sequence\nwhich has multiple locations (start/end points)\n\n=head1 SYNOPSIS\n\n    use Bio::Location::Split;\n\n    my $splitlocation = Bio::Location::Split->new();\n    $splitlocation->add_sub_Location(Bio::Location::Simple->new(-start=>1,\n\t\t\t\t\t\t\t       -end=>30,\n\t\t\t\t\t\t\t       -strand=>1));\n    $splitlocation->add_sub_Location(Bio::Location::Simple->new(-start=>50,\n\t\t\t\t\t\t\t       -end=>61,\n\t\t\t\t\t\t\t       -strand=>1));   \n    my @sublocs = $splitlocation->sub_Location();\n\n    my $count = 1;\n    # print the start/end points of the sub locations\n    foreach my $location ( sort { $a->start <=> $b->start } \n\t\t\t   @sublocs ) {\n\tprintf \"sub feature %d [%d..%d]\\n\", \n\t       $count, $location->start,$location->end, \"\\n\";\n        $count++;\n    }\n\n=head1 DESCRIPTION\n\nThis implementation handles locations which span more than one\nstart/end location, or and/or lie on different sequences, and can\nwork with split locations that depend on the specific order of the\nsublocations ('join') or don't have a specific order but represent\na feature spanning discontiguous sublocations ('order', 'bond').\n\nNote that the order in which sublocations are added may be very important,\ndepending on the specific split location type.  For instance, a 'join'\nmust have the sublocations added in the order that one expects to\njoin the sublocations, whereas all other types are sorted based on the\nsequence location.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl_DOT_org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Location::Split;\n\n# as defined by BSANE 0.03\nour @CORBALOCATIONOPERATOR = ('NONE','JOIN', undef, 'ORDER');;\n\nuse Bio::Root::Root;\n\nuse base qw(Bio::Location::Atomic Bio::Location::SplitLocationI);\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    # initialize\n    $self->{'_sublocations'} = [];\n    my ( $type, $seqid, $locations ) = \n\t$self->_rearrange([qw(SPLITTYPE\n                              SEQ_ID\n\t\t\t      LOCATIONS\n                              )], @args);\n    if( defined $locations && ref($locations) =~ /array/i ) {\n\t$self->add_sub_Location(@$locations);\n    }\n    $seqid  && $self->seq_id($seqid);\n    $type = lc ($type);    \n    $self->splittype($type || 'JOIN');\n    return $self;\n}\n\n=head2 each_Location\n\n Title   : each_Location\n Usage   : @locations = $locObject->each_Location($order);\n Function: Conserved function call across Location:: modules - will\n           return an array containing the component Location(s) in\n           that object, regardless if the calling object is itself a\n           single location or one containing sublocations.\n Returns : an array of Bio::LocationI implementing objects\n Args    : Optional sort order to be passed to sub_Location()\n\n\nsub each_Location {\n    my ($self, $order) = @_;\n    my @locs = ();\n    foreach my $subloc ($self->sub_Location($order)) {\n\t# Recursively check to get hierarchical split locations:\n\tpush @locs, $subloc->each_Location($order);\n    }\n    return @locs;\n}\n\n=head2 sub_Location\n\n Title   : sub_Location\n Usage   : @sublocs = $splitloc->sub_Location();\n Function: Returns the array of sublocations making up this compound (split)\n           location. Those sublocations referring to the same sequence as\n           the root split location will be sorted by start position (forward\n           sort) or end position (reverse sort) and come first (before\n           those on other sequences).\n\n           The sort order can be optionally specified or suppressed by the\n           value of the first argument. The default is no sort.\n\n Returns : an array of Bio::LocationI implementing objects\n Args    : Optionally 1, 0, or -1 for specifying a forward, no, or reverse\n           sort order\n\n\nsub sub_Location {\n    my ($self, $order) = @_;\n    $order = 0 unless defined $order;\n    if( defined($order) && ($order !~ /^-?\\d+$/) ) {\n\t$self->throw(\"value $order passed in to sub_Location is $order, an invalid value\");\n    } \n    $order = 1 if($order > 1);\n    $order = -1 if($order < -1);\n    my @sublocs = defined $self->{'_sublocations'} ? @{$self->{'_sublocations'}} : ();\n\n    # return the array if no ordering requested\n    return @sublocs if( ($order == 0) || (! @sublocs) );\n    \t\n    # sort those locations that are on the same sequence as the top (`master')\n    # if the top seq is undefined, we take the first defined in a sublocation\n    my $seqid = $self->seq_id();\n    my $i = 0;\n    while((! defined($seqid)) && ($i <= $#sublocs)) {\n\t\t$seqid = $sublocs[$i++]->seq_id();\n    }\n    if((! $self->seq_id()) && $seqid) {\n\t\t$self->warn(\"sorted sublocation array requested but \".\n\t\t\t\t\"root location doesn't define seq_id \".\n\t\t\t\t\"(at least one sublocation does!)\");\n    }\n    my @locs = ($seqid ?\n\t\tgrep { $_->seq_id() eq $seqid; } @sublocs :\n\t\t@sublocs);\n    if(@locs) {\n\t\tif($order == 1) {\n\t\t\t# Schwartzian transforms for performance boost\t  \n\t\t\t@locs = map { $_->[0] }\n\t\t\tsort {\n\t\t\t\t(defined $a && defined $b) ? $a->[1] <=> $b->[1] :\n                $a                         ?  -1                 : 1\n\t\t\t\t}\n\t\t\tmap {\n\t\t\t\t[$_, (defined $_->start ? $_->start : $_->end)]\n\t\t\t\t} @locs;;\n\t\t} else { # $order == -1\n\t\t\t@locs = map { $_->[0]}\n\t\t\tsort { \n\t\t\t\t(defined $a && defined $b) ? $b->[1] <=> $a->[1] :\n\t\t\t\t$a                         ? -1                  : 1\n\t\t\t\t}\n\t\t\tmap {\n\t\t\t\t[$_, (defined $_->end ? $_->end : $_->start)]\n\t\t\t\t} @locs;\n\t\t}\n    }\n    # push the rest unsorted\n    if($seqid) {\n\t\tpush(@locs, grep { $_->seq_id() ne $seqid; } @sublocs);\n    }\n    # done!\n\n    return @locs;\n}\n\n=head2 add_sub_Location\n\n Title   : add_sub_Location\n Usage   : $splitloc->add_sub_Location(@locationIobjs);\n Function: add an additional sublocation\n Returns : number of current sub locations\n Args    : list of Bio::LocationI implementing object(s) to add\n\n\nsub add_sub_Location {\n    my ($self,@args) = @_;\n    my @locs;    \n    foreach my $loc ( @args ) {\n\tif( !ref($loc) || ! $loc->isa('Bio::LocationI') ) {\n\t    $self->throw(\"Trying to add $loc as a sub Location but it doesn't implement Bio::LocationI!\");\n\t    next;\n\t}\t\n\tpush @{$self->{'_sublocations'}}, $loc;\n    }\n\n    return scalar @{$self->{'_sublocations'}};\n}\n\n=head2 splittype\n\n  Title   : splittype\n  Usage   : $splittype = $location->splittype();\n  Function: get/set the split splittype\n  Returns : the splittype of split feature (join, order)\n  Args    : splittype to set\n\n\nsub splittype {\n    my ($self, $value) = @_;\n    if( defined $value || ! defined $self->{'_splittype'} ) {\n\t$value = 'JOIN' unless( defined $value );\n\t$self->{'_splittype'} = uc ($value);\n    }\n    return $self->{'_splittype'};\n}\n\n=head2 is_single_sequence\n\n  Title   : is_single_sequence\n  Usage   : if($splitloc->is_single_sequence()) {\n                print \"Location object $splitloc is split \".\n                      \"but only across a single sequence\\n\";\n\t    }\n  Function: Determine whether this location is split across a single or\n            multiple sequences.\n\n            This implementation ignores (sub-)locations that do not define\n            seq_id(). The same holds true for the root location.\n\n  Returns : TRUE if all sublocations lie on the same sequence as the root\n            location (feature), and FALSE otherwise.\n  Args    : none\n\n\nsub is_single_sequence {\n    my ($self) = @_;\n\n    my $seqid = $self->seq_id();\n    foreach my $loc ($self->sub_Location(0)) {\n\t$seqid = $loc->seq_id() if(! $seqid);\n\tif(defined($loc->seq_id()) && ($loc->seq_id() ne $seqid)) {\n\t    return 0;\n\t}\n    }\n    return 1;\n}\n\n=head2 guide_strand\n\n  Title   : guide_strand\n  Usage   : $str = $loc->guide_strand();\n  Function: Get/Set the guide strand.  Of use only if the split type is\n            a 'join' (this helps determine the order of sublocation\n\t\t\tretrieval)\n  Returns : value of guide strand (1, -1, or undef)\n  Args    : new value (-1 or 1, optional)\n\n\nsub guide_strand {\n\tmy $self = shift;\n\treturn $self->{'strand'} = shift if @_;\n\treturn $self->{'strand'};\n}\n\n=head1 LocationI methods\n\n=head2 strand\n\n Title   : strand\n Usage   : $obj->strand($newval)\n Function: For SplitLocations, setting the strand of the container\n           (this object) is a short-cut for setting the strand of all\n           sublocations.\n\n           In get-mode, checks if no sub-location is remote, and if\n           all have the same strand. If so, it returns that shared\n           strand value. Otherwise it returns undef.\n\n Example : \n Returns : on get, value of strand if identical between sublocations \n           (-1, 1, or undef)\n Args    : new value (-1 or 1, optional)\n\n\n\nsub strand{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t\t$self->{'strand'} = $value;\n\t\t# propagate to all sublocs\n\t\tforeach my $loc ($self->sub_Location(0)) {\n\t\t\t$loc->strand($value);\n\t\t}\n    } else {\n\t\tmy ($strand, $lstrand);\n\t\tforeach my $loc ($self->sub_Location(0)) {\n\t\t\t# we give up upon any location that's remote or doesn't have\n\t\t\t# the strand specified, or has a differing one set than \n\t\t\t# previously seen.\n\t\t\t# calling strand() is potentially expensive if the subloc is also\n\t\t\t# a split location, so we cache it\n\t\t\t$lstrand = $loc->strand();\n\t\t\tif((! $lstrand) ||\n\t\t\t   ($strand && ($strand != $lstrand)) ||\n\t\t\t   $loc->is_remote()) {\n\t\t\t$strand = undef;\n\t\t\tlast;\n\t\t\t} elsif(! $strand) {\n\t\t\t$strand = $lstrand;\n\t\t\t}\n\t\t}\n\t\treturn $strand;\n    }\n}\n\n=head2 flip_strand\n\n  Title   : flip_strand\n  Usage   : $location->flip_strand();\n  Function: Flip-flop a strand to the opposite.  Also switch Split strand\n            from undef to -1 or -1 to undef\n  Returns : None\n  Args    : None\n\n\nsub flip_strand {\n    my $self = shift;\n    for my $loc ( $self->sub_Location(0) ) {\n\t\t$loc->flip_strand;\n\t\tif ($loc->isa('Bio::Location::SplitLocationI')) {\n\t\t\tmy $gs = ($self->guide_strand == -1) ? undef : -1;\n\t\t\t$loc->guide_strand($gs);\n\t\t}\n    }\n}\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $location->start();\n  Function: get the starting point of the first (sorted) sublocation\n  Returns : integer\n  Args    : none\n\n\nsub start {\n    my ($self,$value) = @_;    \n    if( defined $value ) {\n\t$self->throw(\"Trying to set the starting point of a split location, \".\n\t\t\t\t \"that is not possible, try manipulating the sub Locations\");\n    }\n    return $self->SUPER::start();\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $location->end();\n  Function: get the ending point of the last (sorted) sublocation\n  Returns : integer\n  Args    : none\n\n\nsub end {\n    my ($self,$value) = @_;    \n    if( defined $value ) {\n\t$self->throw(\"Trying to set the ending point of a split location, \".\n\t\t\t\t \"that is not possible, try manipulating the sub Locations\");\n    }\n    return $self->SUPER::end();\n}\n\n=head2 min_start\n\n  Title   : min_start\n  Usage   : $min_start = $location->min_start();\n  Function: get the minimum starting point\n  Returns : the minimum starting point from the contained sublocations\n  Args    : none","parameters":[{"label":"$self"},{"label":"$value"}],"label":"min_start($self,$value)"},"children":[{"line":439,"localvar":"my","containerName":"min_start","kind":13,"name":"$self","definition":"my"},{"containerName":"min_start","kind":13,"name":"$value","line":439},{"name":"$value","containerName":"min_start","kind":13,"line":441},{"line":442,"kind":13,"containerName":"min_start","name":"$self"},{"name":"throw","kind":12,"containerName":"min_start","line":442},{"definition":"my","name":"@locs","kind":13,"localvar":"my","containerName":"min_start","line":445},{"containerName":"min_start","kind":13,"name":"$self","line":445},{"line":445,"containerName":"min_start","kind":12,"name":"sub_Location"},{"name":"$locs","containerName":"min_start","kind":13,"line":446},{"line":446,"name":"min_start","kind":12,"containerName":"min_start"},{"name":"@locs","kind":13,"containerName":"min_start","line":446}],"name":"min_start","containerName":"Bio::Location::Split","definition":"sub","detail":"($self,$value)"},{"line":460,"kind":12,"range":{"end":{"line":470,"character":9999},"start":{"line":460,"character":0}},"signature":{"label":"max_start($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Split.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::Split\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::Split - Implementation of a Location on a Sequence\nwhich has multiple locations (start/end points)\n\n=head1 SYNOPSIS\n\n    use Bio::Location::Split;\n\n    my $splitlocation = Bio::Location::Split->new();\n    $splitlocation->add_sub_Location(Bio::Location::Simple->new(-start=>1,\n\t\t\t\t\t\t\t       -end=>30,\n\t\t\t\t\t\t\t       -strand=>1));\n    $splitlocation->add_sub_Location(Bio::Location::Simple->new(-start=>50,\n\t\t\t\t\t\t\t       -end=>61,\n\t\t\t\t\t\t\t       -strand=>1));   \n    my @sublocs = $splitlocation->sub_Location();\n\n    my $count = 1;\n    # print the start/end points of the sub locations\n    foreach my $location ( sort { $a->start <=> $b->start } \n\t\t\t   @sublocs ) {\n\tprintf \"sub feature %d [%d..%d]\\n\", \n\t       $count, $location->start,$location->end, \"\\n\";\n        $count++;\n    }\n\n=head1 DESCRIPTION\n\nThis implementation handles locations which span more than one\nstart/end location, or and/or lie on different sequences, and can\nwork with split locations that depend on the specific order of the\nsublocations ('join') or don't have a specific order but represent\na feature spanning discontiguous sublocations ('order', 'bond').\n\nNote that the order in which sublocations are added may be very important,\ndepending on the specific split location type.  For instance, a 'join'\nmust have the sublocations added in the order that one expects to\njoin the sublocations, whereas all other types are sorted based on the\nsequence location.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl_DOT_org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Location::Split;\n\n# as defined by BSANE 0.03\nour @CORBALOCATIONOPERATOR = ('NONE','JOIN', undef, 'ORDER');;\n\nuse Bio::Root::Root;\n\nuse base qw(Bio::Location::Atomic Bio::Location::SplitLocationI);\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    # initialize\n    $self->{'_sublocations'} = [];\n    my ( $type, $seqid, $locations ) = \n\t$self->_rearrange([qw(SPLITTYPE\n                              SEQ_ID\n\t\t\t      LOCATIONS\n                              )], @args);\n    if( defined $locations && ref($locations) =~ /array/i ) {\n\t$self->add_sub_Location(@$locations);\n    }\n    $seqid  && $self->seq_id($seqid);\n    $type = lc ($type);    \n    $self->splittype($type || 'JOIN');\n    return $self;\n}\n\n=head2 each_Location\n\n Title   : each_Location\n Usage   : @locations = $locObject->each_Location($order);\n Function: Conserved function call across Location:: modules - will\n           return an array containing the component Location(s) in\n           that object, regardless if the calling object is itself a\n           single location or one containing sublocations.\n Returns : an array of Bio::LocationI implementing objects\n Args    : Optional sort order to be passed to sub_Location()\n\n\nsub each_Location {\n    my ($self, $order) = @_;\n    my @locs = ();\n    foreach my $subloc ($self->sub_Location($order)) {\n\t# Recursively check to get hierarchical split locations:\n\tpush @locs, $subloc->each_Location($order);\n    }\n    return @locs;\n}\n\n=head2 sub_Location\n\n Title   : sub_Location\n Usage   : @sublocs = $splitloc->sub_Location();\n Function: Returns the array of sublocations making up this compound (split)\n           location. Those sublocations referring to the same sequence as\n           the root split location will be sorted by start position (forward\n           sort) or end position (reverse sort) and come first (before\n           those on other sequences).\n\n           The sort order can be optionally specified or suppressed by the\n           value of the first argument. The default is no sort.\n\n Returns : an array of Bio::LocationI implementing objects\n Args    : Optionally 1, 0, or -1 for specifying a forward, no, or reverse\n           sort order\n\n\nsub sub_Location {\n    my ($self, $order) = @_;\n    $order = 0 unless defined $order;\n    if( defined($order) && ($order !~ /^-?\\d+$/) ) {\n\t$self->throw(\"value $order passed in to sub_Location is $order, an invalid value\");\n    } \n    $order = 1 if($order > 1);\n    $order = -1 if($order < -1);\n    my @sublocs = defined $self->{'_sublocations'} ? @{$self->{'_sublocations'}} : ();\n\n    # return the array if no ordering requested\n    return @sublocs if( ($order == 0) || (! @sublocs) );\n    \t\n    # sort those locations that are on the same sequence as the top (`master')\n    # if the top seq is undefined, we take the first defined in a sublocation\n    my $seqid = $self->seq_id();\n    my $i = 0;\n    while((! defined($seqid)) && ($i <= $#sublocs)) {\n\t\t$seqid = $sublocs[$i++]->seq_id();\n    }\n    if((! $self->seq_id()) && $seqid) {\n\t\t$self->warn(\"sorted sublocation array requested but \".\n\t\t\t\t\"root location doesn't define seq_id \".\n\t\t\t\t\"(at least one sublocation does!)\");\n    }\n    my @locs = ($seqid ?\n\t\tgrep { $_->seq_id() eq $seqid; } @sublocs :\n\t\t@sublocs);\n    if(@locs) {\n\t\tif($order == 1) {\n\t\t\t# Schwartzian transforms for performance boost\t  \n\t\t\t@locs = map { $_->[0] }\n\t\t\tsort {\n\t\t\t\t(defined $a && defined $b) ? $a->[1] <=> $b->[1] :\n                $a                         ?  -1                 : 1\n\t\t\t\t}\n\t\t\tmap {\n\t\t\t\t[$_, (defined $_->start ? $_->start : $_->end)]\n\t\t\t\t} @locs;;\n\t\t} else { # $order == -1\n\t\t\t@locs = map { $_->[0]}\n\t\t\tsort { \n\t\t\t\t(defined $a && defined $b) ? $b->[1] <=> $a->[1] :\n\t\t\t\t$a                         ? -1                  : 1\n\t\t\t\t}\n\t\t\tmap {\n\t\t\t\t[$_, (defined $_->end ? $_->end : $_->start)]\n\t\t\t\t} @locs;\n\t\t}\n    }\n    # push the rest unsorted\n    if($seqid) {\n\t\tpush(@locs, grep { $_->seq_id() ne $seqid; } @sublocs);\n    }\n    # done!\n\n    return @locs;\n}\n\n=head2 add_sub_Location\n\n Title   : add_sub_Location\n Usage   : $splitloc->add_sub_Location(@locationIobjs);\n Function: add an additional sublocation\n Returns : number of current sub locations\n Args    : list of Bio::LocationI implementing object(s) to add\n\n\nsub add_sub_Location {\n    my ($self,@args) = @_;\n    my @locs;    \n    foreach my $loc ( @args ) {\n\tif( !ref($loc) || ! $loc->isa('Bio::LocationI') ) {\n\t    $self->throw(\"Trying to add $loc as a sub Location but it doesn't implement Bio::LocationI!\");\n\t    next;\n\t}\t\n\tpush @{$self->{'_sublocations'}}, $loc;\n    }\n\n    return scalar @{$self->{'_sublocations'}};\n}\n\n=head2 splittype\n\n  Title   : splittype\n  Usage   : $splittype = $location->splittype();\n  Function: get/set the split splittype\n  Returns : the splittype of split feature (join, order)\n  Args    : splittype to set\n\n\nsub splittype {\n    my ($self, $value) = @_;\n    if( defined $value || ! defined $self->{'_splittype'} ) {\n\t$value = 'JOIN' unless( defined $value );\n\t$self->{'_splittype'} = uc ($value);\n    }\n    return $self->{'_splittype'};\n}\n\n=head2 is_single_sequence\n\n  Title   : is_single_sequence\n  Usage   : if($splitloc->is_single_sequence()) {\n                print \"Location object $splitloc is split \".\n                      \"but only across a single sequence\\n\";\n\t    }\n  Function: Determine whether this location is split across a single or\n            multiple sequences.\n\n            This implementation ignores (sub-)locations that do not define\n            seq_id(). The same holds true for the root location.\n\n  Returns : TRUE if all sublocations lie on the same sequence as the root\n            location (feature), and FALSE otherwise.\n  Args    : none\n\n\nsub is_single_sequence {\n    my ($self) = @_;\n\n    my $seqid = $self->seq_id();\n    foreach my $loc ($self->sub_Location(0)) {\n\t$seqid = $loc->seq_id() if(! $seqid);\n\tif(defined($loc->seq_id()) && ($loc->seq_id() ne $seqid)) {\n\t    return 0;\n\t}\n    }\n    return 1;\n}\n\n=head2 guide_strand\n\n  Title   : guide_strand\n  Usage   : $str = $loc->guide_strand();\n  Function: Get/Set the guide strand.  Of use only if the split type is\n            a 'join' (this helps determine the order of sublocation\n\t\t\tretrieval)\n  Returns : value of guide strand (1, -1, or undef)\n  Args    : new value (-1 or 1, optional)\n\n\nsub guide_strand {\n\tmy $self = shift;\n\treturn $self->{'strand'} = shift if @_;\n\treturn $self->{'strand'};\n}\n\n=head1 LocationI methods\n\n=head2 strand\n\n Title   : strand\n Usage   : $obj->strand($newval)\n Function: For SplitLocations, setting the strand of the container\n           (this object) is a short-cut for setting the strand of all\n           sublocations.\n\n           In get-mode, checks if no sub-location is remote, and if\n           all have the same strand. If so, it returns that shared\n           strand value. Otherwise it returns undef.\n\n Example : \n Returns : on get, value of strand if identical between sublocations \n           (-1, 1, or undef)\n Args    : new value (-1 or 1, optional)\n\n\n\nsub strand{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t\t$self->{'strand'} = $value;\n\t\t# propagate to all sublocs\n\t\tforeach my $loc ($self->sub_Location(0)) {\n\t\t\t$loc->strand($value);\n\t\t}\n    } else {\n\t\tmy ($strand, $lstrand);\n\t\tforeach my $loc ($self->sub_Location(0)) {\n\t\t\t# we give up upon any location that's remote or doesn't have\n\t\t\t# the strand specified, or has a differing one set than \n\t\t\t# previously seen.\n\t\t\t# calling strand() is potentially expensive if the subloc is also\n\t\t\t# a split location, so we cache it\n\t\t\t$lstrand = $loc->strand();\n\t\t\tif((! $lstrand) ||\n\t\t\t   ($strand && ($strand != $lstrand)) ||\n\t\t\t   $loc->is_remote()) {\n\t\t\t$strand = undef;\n\t\t\tlast;\n\t\t\t} elsif(! $strand) {\n\t\t\t$strand = $lstrand;\n\t\t\t}\n\t\t}\n\t\treturn $strand;\n    }\n}\n\n=head2 flip_strand\n\n  Title   : flip_strand\n  Usage   : $location->flip_strand();\n  Function: Flip-flop a strand to the opposite.  Also switch Split strand\n            from undef to -1 or -1 to undef\n  Returns : None\n  Args    : None\n\n\nsub flip_strand {\n    my $self = shift;\n    for my $loc ( $self->sub_Location(0) ) {\n\t\t$loc->flip_strand;\n\t\tif ($loc->isa('Bio::Location::SplitLocationI')) {\n\t\t\tmy $gs = ($self->guide_strand == -1) ? undef : -1;\n\t\t\t$loc->guide_strand($gs);\n\t\t}\n    }\n}\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $location->start();\n  Function: get the starting point of the first (sorted) sublocation\n  Returns : integer\n  Args    : none\n\n\nsub start {\n    my ($self,$value) = @_;    \n    if( defined $value ) {\n\t$self->throw(\"Trying to set the starting point of a split location, \".\n\t\t\t\t \"that is not possible, try manipulating the sub Locations\");\n    }\n    return $self->SUPER::start();\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $location->end();\n  Function: get the ending point of the last (sorted) sublocation\n  Returns : integer\n  Args    : none\n\n\nsub end {\n    my ($self,$value) = @_;    \n    if( defined $value ) {\n\t$self->throw(\"Trying to set the ending point of a split location, \".\n\t\t\t\t \"that is not possible, try manipulating the sub Locations\");\n    }\n    return $self->SUPER::end();\n}\n\n=head2 min_start\n\n  Title   : min_start\n  Usage   : $min_start = $location->min_start();\n  Function: get the minimum starting point\n  Returns : the minimum starting point from the contained sublocations\n  Args    : none\n\n\nsub min_start {\n    my ($self, $value) = @_;    \n\n    if( defined $value ) {\n\t$self->throw(\"Trying to set the minimum starting point of a split \".\n\t\t\t\t \"location, that is not possible, try manipulating the sub Locations\");\n    }\n    my @locs = $self->sub_Location(1);\n    return $locs[0]->min_start() if @locs; \n    return;\n}\n\n=head2 max_start\n\n  Title   : max_start\n  Usage   : my $maxstart = $location->max_start();\n  Function: Get maximum starting location of feature startpoint  \n  Returns : integer or undef if no maximum starting point.\n  Args    : none"},"children":[{"line":461,"name":"$self","containerName":"max_start","localvar":"my","kind":13,"definition":"my"},{"line":461,"name":"$value","containerName":"max_start","kind":13},{"line":463,"containerName":"max_start","kind":13,"name":"$value"},{"name":"$self","containerName":"max_start","kind":13,"line":464},{"kind":12,"containerName":"max_start","name":"throw","line":464},{"localvar":"my","kind":13,"containerName":"max_start","name":"@locs","line":467,"definition":"my"},{"name":"$self","kind":13,"containerName":"max_start","line":467},{"name":"sub_Location","containerName":"max_start","kind":12,"line":467},{"line":468,"kind":13,"containerName":"max_start","name":"$locs"},{"line":468,"name":"max_start","containerName":"max_start","kind":12},{"containerName":"max_start","kind":13,"name":"@locs","line":468}],"name":"max_start","containerName":"Bio::Location::Split","definition":"sub","detail":"($self,$value)"},{"detail":"($self,$value)","definition":"sub","name":"start_pos_type","containerName":"Bio::Location::Split","children":[{"name":"$self","localvar":"my","containerName":"start_pos_type","kind":13,"line":484,"definition":"my"},{"name":"$value","kind":13,"containerName":"start_pos_type","line":484},{"line":486,"name":"$value","containerName":"start_pos_type","kind":13},{"containerName":"start_pos_type","kind":13,"name":"$self","line":487},{"kind":12,"containerName":"start_pos_type","name":"throw","line":487},{"localvar":"my","kind":13,"containerName":"start_pos_type","name":"@locs","line":490,"definition":"my"},{"kind":13,"containerName":"start_pos_type","name":"$self","line":490},{"containerName":"start_pos_type","kind":12,"name":"sub_Location","line":490},{"line":491,"name":"@locs","containerName":"start_pos_type","kind":13},{"line":491,"containerName":"start_pos_type","kind":13,"name":"$locs"},{"line":491,"name":"start_pos_type","containerName":"start_pos_type","kind":12}],"signature":{"documentation":"1;\n# $Id: Split.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::Split\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::Split - Implementation of a Location on a Sequence\nwhich has multiple locations (start/end points)\n\n=head1 SYNOPSIS\n\n    use Bio::Location::Split;\n\n    my $splitlocation = Bio::Location::Split->new();\n    $splitlocation->add_sub_Location(Bio::Location::Simple->new(-start=>1,\n\t\t\t\t\t\t\t       -end=>30,\n\t\t\t\t\t\t\t       -strand=>1));\n    $splitlocation->add_sub_Location(Bio::Location::Simple->new(-start=>50,\n\t\t\t\t\t\t\t       -end=>61,\n\t\t\t\t\t\t\t       -strand=>1));   \n    my @sublocs = $splitlocation->sub_Location();\n\n    my $count = 1;\n    # print the start/end points of the sub locations\n    foreach my $location ( sort { $a->start <=> $b->start } \n\t\t\t   @sublocs ) {\n\tprintf \"sub feature %d [%d..%d]\\n\", \n\t       $count, $location->start,$location->end, \"\\n\";\n        $count++;\n    }\n\n=head1 DESCRIPTION\n\nThis implementation handles locations which span more than one\nstart/end location, or and/or lie on different sequences, and can\nwork with split locations that depend on the specific order of the\nsublocations ('join') or don't have a specific order but represent\na feature spanning discontiguous sublocations ('order', 'bond').\n\nNote that the order in which sublocations are added may be very important,\ndepending on the specific split location type.  For instance, a 'join'\nmust have the sublocations added in the order that one expects to\njoin the sublocations, whereas all other types are sorted based on the\nsequence location.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl_DOT_org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Location::Split;\n\n# as defined by BSANE 0.03\nour @CORBALOCATIONOPERATOR = ('NONE','JOIN', undef, 'ORDER');;\n\nuse Bio::Root::Root;\n\nuse base qw(Bio::Location::Atomic Bio::Location::SplitLocationI);\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    # initialize\n    $self->{'_sublocations'} = [];\n    my ( $type, $seqid, $locations ) = \n\t$self->_rearrange([qw(SPLITTYPE\n                              SEQ_ID\n\t\t\t      LOCATIONS\n                              )], @args);\n    if( defined $locations && ref($locations) =~ /array/i ) {\n\t$self->add_sub_Location(@$locations);\n    }\n    $seqid  && $self->seq_id($seqid);\n    $type = lc ($type);    \n    $self->splittype($type || 'JOIN');\n    return $self;\n}\n\n=head2 each_Location\n\n Title   : each_Location\n Usage   : @locations = $locObject->each_Location($order);\n Function: Conserved function call across Location:: modules - will\n           return an array containing the component Location(s) in\n           that object, regardless if the calling object is itself a\n           single location or one containing sublocations.\n Returns : an array of Bio::LocationI implementing objects\n Args    : Optional sort order to be passed to sub_Location()\n\n\nsub each_Location {\n    my ($self, $order) = @_;\n    my @locs = ();\n    foreach my $subloc ($self->sub_Location($order)) {\n\t# Recursively check to get hierarchical split locations:\n\tpush @locs, $subloc->each_Location($order);\n    }\n    return @locs;\n}\n\n=head2 sub_Location\n\n Title   : sub_Location\n Usage   : @sublocs = $splitloc->sub_Location();\n Function: Returns the array of sublocations making up this compound (split)\n           location. Those sublocations referring to the same sequence as\n           the root split location will be sorted by start position (forward\n           sort) or end position (reverse sort) and come first (before\n           those on other sequences).\n\n           The sort order can be optionally specified or suppressed by the\n           value of the first argument. The default is no sort.\n\n Returns : an array of Bio::LocationI implementing objects\n Args    : Optionally 1, 0, or -1 for specifying a forward, no, or reverse\n           sort order\n\n\nsub sub_Location {\n    my ($self, $order) = @_;\n    $order = 0 unless defined $order;\n    if( defined($order) && ($order !~ /^-?\\d+$/) ) {\n\t$self->throw(\"value $order passed in to sub_Location is $order, an invalid value\");\n    } \n    $order = 1 if($order > 1);\n    $order = -1 if($order < -1);\n    my @sublocs = defined $self->{'_sublocations'} ? @{$self->{'_sublocations'}} : ();\n\n    # return the array if no ordering requested\n    return @sublocs if( ($order == 0) || (! @sublocs) );\n    \t\n    # sort those locations that are on the same sequence as the top (`master')\n    # if the top seq is undefined, we take the first defined in a sublocation\n    my $seqid = $self->seq_id();\n    my $i = 0;\n    while((! defined($seqid)) && ($i <= $#sublocs)) {\n\t\t$seqid = $sublocs[$i++]->seq_id();\n    }\n    if((! $self->seq_id()) && $seqid) {\n\t\t$self->warn(\"sorted sublocation array requested but \".\n\t\t\t\t\"root location doesn't define seq_id \".\n\t\t\t\t\"(at least one sublocation does!)\");\n    }\n    my @locs = ($seqid ?\n\t\tgrep { $_->seq_id() eq $seqid; } @sublocs :\n\t\t@sublocs);\n    if(@locs) {\n\t\tif($order == 1) {\n\t\t\t# Schwartzian transforms for performance boost\t  \n\t\t\t@locs = map { $_->[0] }\n\t\t\tsort {\n\t\t\t\t(defined $a && defined $b) ? $a->[1] <=> $b->[1] :\n                $a                         ?  -1                 : 1\n\t\t\t\t}\n\t\t\tmap {\n\t\t\t\t[$_, (defined $_->start ? $_->start : $_->end)]\n\t\t\t\t} @locs;;\n\t\t} else { # $order == -1\n\t\t\t@locs = map { $_->[0]}\n\t\t\tsort { \n\t\t\t\t(defined $a && defined $b) ? $b->[1] <=> $a->[1] :\n\t\t\t\t$a                         ? -1                  : 1\n\t\t\t\t}\n\t\t\tmap {\n\t\t\t\t[$_, (defined $_->end ? $_->end : $_->start)]\n\t\t\t\t} @locs;\n\t\t}\n    }\n    # push the rest unsorted\n    if($seqid) {\n\t\tpush(@locs, grep { $_->seq_id() ne $seqid; } @sublocs);\n    }\n    # done!\n\n    return @locs;\n}\n\n=head2 add_sub_Location\n\n Title   : add_sub_Location\n Usage   : $splitloc->add_sub_Location(@locationIobjs);\n Function: add an additional sublocation\n Returns : number of current sub locations\n Args    : list of Bio::LocationI implementing object(s) to add\n\n\nsub add_sub_Location {\n    my ($self,@args) = @_;\n    my @locs;    \n    foreach my $loc ( @args ) {\n\tif( !ref($loc) || ! $loc->isa('Bio::LocationI') ) {\n\t    $self->throw(\"Trying to add $loc as a sub Location but it doesn't implement Bio::LocationI!\");\n\t    next;\n\t}\t\n\tpush @{$self->{'_sublocations'}}, $loc;\n    }\n\n    return scalar @{$self->{'_sublocations'}};\n}\n\n=head2 splittype\n\n  Title   : splittype\n  Usage   : $splittype = $location->splittype();\n  Function: get/set the split splittype\n  Returns : the splittype of split feature (join, order)\n  Args    : splittype to set\n\n\nsub splittype {\n    my ($self, $value) = @_;\n    if( defined $value || ! defined $self->{'_splittype'} ) {\n\t$value = 'JOIN' unless( defined $value );\n\t$self->{'_splittype'} = uc ($value);\n    }\n    return $self->{'_splittype'};\n}\n\n=head2 is_single_sequence\n\n  Title   : is_single_sequence\n  Usage   : if($splitloc->is_single_sequence()) {\n                print \"Location object $splitloc is split \".\n                      \"but only across a single sequence\\n\";\n\t    }\n  Function: Determine whether this location is split across a single or\n            multiple sequences.\n\n            This implementation ignores (sub-)locations that do not define\n            seq_id(). The same holds true for the root location.\n\n  Returns : TRUE if all sublocations lie on the same sequence as the root\n            location (feature), and FALSE otherwise.\n  Args    : none\n\n\nsub is_single_sequence {\n    my ($self) = @_;\n\n    my $seqid = $self->seq_id();\n    foreach my $loc ($self->sub_Location(0)) {\n\t$seqid = $loc->seq_id() if(! $seqid);\n\tif(defined($loc->seq_id()) && ($loc->seq_id() ne $seqid)) {\n\t    return 0;\n\t}\n    }\n    return 1;\n}\n\n=head2 guide_strand\n\n  Title   : guide_strand\n  Usage   : $str = $loc->guide_strand();\n  Function: Get/Set the guide strand.  Of use only if the split type is\n            a 'join' (this helps determine the order of sublocation\n\t\t\tretrieval)\n  Returns : value of guide strand (1, -1, or undef)\n  Args    : new value (-1 or 1, optional)\n\n\nsub guide_strand {\n\tmy $self = shift;\n\treturn $self->{'strand'} = shift if @_;\n\treturn $self->{'strand'};\n}\n\n=head1 LocationI methods\n\n=head2 strand\n\n Title   : strand\n Usage   : $obj->strand($newval)\n Function: For SplitLocations, setting the strand of the container\n           (this object) is a short-cut for setting the strand of all\n           sublocations.\n\n           In get-mode, checks if no sub-location is remote, and if\n           all have the same strand. If so, it returns that shared\n           strand value. Otherwise it returns undef.\n\n Example : \n Returns : on get, value of strand if identical between sublocations \n           (-1, 1, or undef)\n Args    : new value (-1 or 1, optional)\n\n\n\nsub strand{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t\t$self->{'strand'} = $value;\n\t\t# propagate to all sublocs\n\t\tforeach my $loc ($self->sub_Location(0)) {\n\t\t\t$loc->strand($value);\n\t\t}\n    } else {\n\t\tmy ($strand, $lstrand);\n\t\tforeach my $loc ($self->sub_Location(0)) {\n\t\t\t# we give up upon any location that's remote or doesn't have\n\t\t\t# the strand specified, or has a differing one set than \n\t\t\t# previously seen.\n\t\t\t# calling strand() is potentially expensive if the subloc is also\n\t\t\t# a split location, so we cache it\n\t\t\t$lstrand = $loc->strand();\n\t\t\tif((! $lstrand) ||\n\t\t\t   ($strand && ($strand != $lstrand)) ||\n\t\t\t   $loc->is_remote()) {\n\t\t\t$strand = undef;\n\t\t\tlast;\n\t\t\t} elsif(! $strand) {\n\t\t\t$strand = $lstrand;\n\t\t\t}\n\t\t}\n\t\treturn $strand;\n    }\n}\n\n=head2 flip_strand\n\n  Title   : flip_strand\n  Usage   : $location->flip_strand();\n  Function: Flip-flop a strand to the opposite.  Also switch Split strand\n            from undef to -1 or -1 to undef\n  Returns : None\n  Args    : None\n\n\nsub flip_strand {\n    my $self = shift;\n    for my $loc ( $self->sub_Location(0) ) {\n\t\t$loc->flip_strand;\n\t\tif ($loc->isa('Bio::Location::SplitLocationI')) {\n\t\t\tmy $gs = ($self->guide_strand == -1) ? undef : -1;\n\t\t\t$loc->guide_strand($gs);\n\t\t}\n    }\n}\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $location->start();\n  Function: get the starting point of the first (sorted) sublocation\n  Returns : integer\n  Args    : none\n\n\nsub start {\n    my ($self,$value) = @_;    \n    if( defined $value ) {\n\t$self->throw(\"Trying to set the starting point of a split location, \".\n\t\t\t\t \"that is not possible, try manipulating the sub Locations\");\n    }\n    return $self->SUPER::start();\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $location->end();\n  Function: get the ending point of the last (sorted) sublocation\n  Returns : integer\n  Args    : none\n\n\nsub end {\n    my ($self,$value) = @_;    \n    if( defined $value ) {\n\t$self->throw(\"Trying to set the ending point of a split location, \".\n\t\t\t\t \"that is not possible, try manipulating the sub Locations\");\n    }\n    return $self->SUPER::end();\n}\n\n=head2 min_start\n\n  Title   : min_start\n  Usage   : $min_start = $location->min_start();\n  Function: get the minimum starting point\n  Returns : the minimum starting point from the contained sublocations\n  Args    : none\n\n\nsub min_start {\n    my ($self, $value) = @_;    \n\n    if( defined $value ) {\n\t$self->throw(\"Trying to set the minimum starting point of a split \".\n\t\t\t\t \"location, that is not possible, try manipulating the sub Locations\");\n    }\n    my @locs = $self->sub_Location(1);\n    return $locs[0]->min_start() if @locs; \n    return;\n}\n\n=head2 max_start\n\n  Title   : max_start\n  Usage   : my $maxstart = $location->max_start();\n  Function: Get maximum starting location of feature startpoint  \n  Returns : integer or undef if no maximum starting point.\n  Args    : none\n\n\nsub max_start {\n    my ($self,$value) = @_;\n\n    if( defined $value ) {\n\t$self->throw(\"Trying to set the maximum starting point of a split \".\n\t\t\t\t \"location, that is not possible, try manipulating the sub Locations\");\n    }\n    my @locs = $self->sub_Location(1);\n    return $locs[0]->max_start() if @locs; \n    return;\n}\n\n=head2 start_pos_type\n\n  Title   : start_pos_type\n  Usage   : my $start_pos_type = $location->start_pos_type();\n  Function: Get start position type (ie <,>, ^) \n  Returns : type of position coded as text \n            ('BEFORE', 'AFTER', 'EXACT','WITHIN', 'BETWEEN')\n  Args    : none","parameters":[{"label":"$self"},{"label":"$value"}],"label":"start_pos_type($self,$value)"},"range":{"start":{"line":483,"character":0},"end":{"line":492,"character":9999}},"kind":12,"line":483},{"signature":{"label":"min_end($self,$value)","documentation":"1;\n# $Id: Split.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::Split\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::Split - Implementation of a Location on a Sequence\nwhich has multiple locations (start/end points)\n\n=head1 SYNOPSIS\n\n    use Bio::Location::Split;\n\n    my $splitlocation = Bio::Location::Split->new();\n    $splitlocation->add_sub_Location(Bio::Location::Simple->new(-start=>1,\n\t\t\t\t\t\t\t       -end=>30,\n\t\t\t\t\t\t\t       -strand=>1));\n    $splitlocation->add_sub_Location(Bio::Location::Simple->new(-start=>50,\n\t\t\t\t\t\t\t       -end=>61,\n\t\t\t\t\t\t\t       -strand=>1));   \n    my @sublocs = $splitlocation->sub_Location();\n\n    my $count = 1;\n    # print the start/end points of the sub locations\n    foreach my $location ( sort { $a->start <=> $b->start } \n\t\t\t   @sublocs ) {\n\tprintf \"sub feature %d [%d..%d]\\n\", \n\t       $count, $location->start,$location->end, \"\\n\";\n        $count++;\n    }\n\n=head1 DESCRIPTION\n\nThis implementation handles locations which span more than one\nstart/end location, or and/or lie on different sequences, and can\nwork with split locations that depend on the specific order of the\nsublocations ('join') or don't have a specific order but represent\na feature spanning discontiguous sublocations ('order', 'bond').\n\nNote that the order in which sublocations are added may be very important,\ndepending on the specific split location type.  For instance, a 'join'\nmust have the sublocations added in the order that one expects to\njoin the sublocations, whereas all other types are sorted based on the\nsequence location.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl_DOT_org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Location::Split;\n\n# as defined by BSANE 0.03\nour @CORBALOCATIONOPERATOR = ('NONE','JOIN', undef, 'ORDER');;\n\nuse Bio::Root::Root;\n\nuse base qw(Bio::Location::Atomic Bio::Location::SplitLocationI);\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    # initialize\n    $self->{'_sublocations'} = [];\n    my ( $type, $seqid, $locations ) = \n\t$self->_rearrange([qw(SPLITTYPE\n                              SEQ_ID\n\t\t\t      LOCATIONS\n                              )], @args);\n    if( defined $locations && ref($locations) =~ /array/i ) {\n\t$self->add_sub_Location(@$locations);\n    }\n    $seqid  && $self->seq_id($seqid);\n    $type = lc ($type);    \n    $self->splittype($type || 'JOIN');\n    return $self;\n}\n\n=head2 each_Location\n\n Title   : each_Location\n Usage   : @locations = $locObject->each_Location($order);\n Function: Conserved function call across Location:: modules - will\n           return an array containing the component Location(s) in\n           that object, regardless if the calling object is itself a\n           single location or one containing sublocations.\n Returns : an array of Bio::LocationI implementing objects\n Args    : Optional sort order to be passed to sub_Location()\n\n\nsub each_Location {\n    my ($self, $order) = @_;\n    my @locs = ();\n    foreach my $subloc ($self->sub_Location($order)) {\n\t# Recursively check to get hierarchical split locations:\n\tpush @locs, $subloc->each_Location($order);\n    }\n    return @locs;\n}\n\n=head2 sub_Location\n\n Title   : sub_Location\n Usage   : @sublocs = $splitloc->sub_Location();\n Function: Returns the array of sublocations making up this compound (split)\n           location. Those sublocations referring to the same sequence as\n           the root split location will be sorted by start position (forward\n           sort) or end position (reverse sort) and come first (before\n           those on other sequences).\n\n           The sort order can be optionally specified or suppressed by the\n           value of the first argument. The default is no sort.\n\n Returns : an array of Bio::LocationI implementing objects\n Args    : Optionally 1, 0, or -1 for specifying a forward, no, or reverse\n           sort order\n\n\nsub sub_Location {\n    my ($self, $order) = @_;\n    $order = 0 unless defined $order;\n    if( defined($order) && ($order !~ /^-?\\d+$/) ) {\n\t$self->throw(\"value $order passed in to sub_Location is $order, an invalid value\");\n    } \n    $order = 1 if($order > 1);\n    $order = -1 if($order < -1);\n    my @sublocs = defined $self->{'_sublocations'} ? @{$self->{'_sublocations'}} : ();\n\n    # return the array if no ordering requested\n    return @sublocs if( ($order == 0) || (! @sublocs) );\n    \t\n    # sort those locations that are on the same sequence as the top (`master')\n    # if the top seq is undefined, we take the first defined in a sublocation\n    my $seqid = $self->seq_id();\n    my $i = 0;\n    while((! defined($seqid)) && ($i <= $#sublocs)) {\n\t\t$seqid = $sublocs[$i++]->seq_id();\n    }\n    if((! $self->seq_id()) && $seqid) {\n\t\t$self->warn(\"sorted sublocation array requested but \".\n\t\t\t\t\"root location doesn't define seq_id \".\n\t\t\t\t\"(at least one sublocation does!)\");\n    }\n    my @locs = ($seqid ?\n\t\tgrep { $_->seq_id() eq $seqid; } @sublocs :\n\t\t@sublocs);\n    if(@locs) {\n\t\tif($order == 1) {\n\t\t\t# Schwartzian transforms for performance boost\t  \n\t\t\t@locs = map { $_->[0] }\n\t\t\tsort {\n\t\t\t\t(defined $a && defined $b) ? $a->[1] <=> $b->[1] :\n                $a                         ?  -1                 : 1\n\t\t\t\t}\n\t\t\tmap {\n\t\t\t\t[$_, (defined $_->start ? $_->start : $_->end)]\n\t\t\t\t} @locs;;\n\t\t} else { # $order == -1\n\t\t\t@locs = map { $_->[0]}\n\t\t\tsort { \n\t\t\t\t(defined $a && defined $b) ? $b->[1] <=> $a->[1] :\n\t\t\t\t$a                         ? -1                  : 1\n\t\t\t\t}\n\t\t\tmap {\n\t\t\t\t[$_, (defined $_->end ? $_->end : $_->start)]\n\t\t\t\t} @locs;\n\t\t}\n    }\n    # push the rest unsorted\n    if($seqid) {\n\t\tpush(@locs, grep { $_->seq_id() ne $seqid; } @sublocs);\n    }\n    # done!\n\n    return @locs;\n}\n\n=head2 add_sub_Location\n\n Title   : add_sub_Location\n Usage   : $splitloc->add_sub_Location(@locationIobjs);\n Function: add an additional sublocation\n Returns : number of current sub locations\n Args    : list of Bio::LocationI implementing object(s) to add\n\n\nsub add_sub_Location {\n    my ($self,@args) = @_;\n    my @locs;    \n    foreach my $loc ( @args ) {\n\tif( !ref($loc) || ! $loc->isa('Bio::LocationI') ) {\n\t    $self->throw(\"Trying to add $loc as a sub Location but it doesn't implement Bio::LocationI!\");\n\t    next;\n\t}\t\n\tpush @{$self->{'_sublocations'}}, $loc;\n    }\n\n    return scalar @{$self->{'_sublocations'}};\n}\n\n=head2 splittype\n\n  Title   : splittype\n  Usage   : $splittype = $location->splittype();\n  Function: get/set the split splittype\n  Returns : the splittype of split feature (join, order)\n  Args    : splittype to set\n\n\nsub splittype {\n    my ($self, $value) = @_;\n    if( defined $value || ! defined $self->{'_splittype'} ) {\n\t$value = 'JOIN' unless( defined $value );\n\t$self->{'_splittype'} = uc ($value);\n    }\n    return $self->{'_splittype'};\n}\n\n=head2 is_single_sequence\n\n  Title   : is_single_sequence\n  Usage   : if($splitloc->is_single_sequence()) {\n                print \"Location object $splitloc is split \".\n                      \"but only across a single sequence\\n\";\n\t    }\n  Function: Determine whether this location is split across a single or\n            multiple sequences.\n\n            This implementation ignores (sub-)locations that do not define\n            seq_id(). The same holds true for the root location.\n\n  Returns : TRUE if all sublocations lie on the same sequence as the root\n            location (feature), and FALSE otherwise.\n  Args    : none\n\n\nsub is_single_sequence {\n    my ($self) = @_;\n\n    my $seqid = $self->seq_id();\n    foreach my $loc ($self->sub_Location(0)) {\n\t$seqid = $loc->seq_id() if(! $seqid);\n\tif(defined($loc->seq_id()) && ($loc->seq_id() ne $seqid)) {\n\t    return 0;\n\t}\n    }\n    return 1;\n}\n\n=head2 guide_strand\n\n  Title   : guide_strand\n  Usage   : $str = $loc->guide_strand();\n  Function: Get/Set the guide strand.  Of use only if the split type is\n            a 'join' (this helps determine the order of sublocation\n\t\t\tretrieval)\n  Returns : value of guide strand (1, -1, or undef)\n  Args    : new value (-1 or 1, optional)\n\n\nsub guide_strand {\n\tmy $self = shift;\n\treturn $self->{'strand'} = shift if @_;\n\treturn $self->{'strand'};\n}\n\n=head1 LocationI methods\n\n=head2 strand\n\n Title   : strand\n Usage   : $obj->strand($newval)\n Function: For SplitLocations, setting the strand of the container\n           (this object) is a short-cut for setting the strand of all\n           sublocations.\n\n           In get-mode, checks if no sub-location is remote, and if\n           all have the same strand. If so, it returns that shared\n           strand value. Otherwise it returns undef.\n\n Example : \n Returns : on get, value of strand if identical between sublocations \n           (-1, 1, or undef)\n Args    : new value (-1 or 1, optional)\n\n\n\nsub strand{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t\t$self->{'strand'} = $value;\n\t\t# propagate to all sublocs\n\t\tforeach my $loc ($self->sub_Location(0)) {\n\t\t\t$loc->strand($value);\n\t\t}\n    } else {\n\t\tmy ($strand, $lstrand);\n\t\tforeach my $loc ($self->sub_Location(0)) {\n\t\t\t# we give up upon any location that's remote or doesn't have\n\t\t\t# the strand specified, or has a differing one set than \n\t\t\t# previously seen.\n\t\t\t# calling strand() is potentially expensive if the subloc is also\n\t\t\t# a split location, so we cache it\n\t\t\t$lstrand = $loc->strand();\n\t\t\tif((! $lstrand) ||\n\t\t\t   ($strand && ($strand != $lstrand)) ||\n\t\t\t   $loc->is_remote()) {\n\t\t\t$strand = undef;\n\t\t\tlast;\n\t\t\t} elsif(! $strand) {\n\t\t\t$strand = $lstrand;\n\t\t\t}\n\t\t}\n\t\treturn $strand;\n    }\n}\n\n=head2 flip_strand\n\n  Title   : flip_strand\n  Usage   : $location->flip_strand();\n  Function: Flip-flop a strand to the opposite.  Also switch Split strand\n            from undef to -1 or -1 to undef\n  Returns : None\n  Args    : None\n\n\nsub flip_strand {\n    my $self = shift;\n    for my $loc ( $self->sub_Location(0) ) {\n\t\t$loc->flip_strand;\n\t\tif ($loc->isa('Bio::Location::SplitLocationI')) {\n\t\t\tmy $gs = ($self->guide_strand == -1) ? undef : -1;\n\t\t\t$loc->guide_strand($gs);\n\t\t}\n    }\n}\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $location->start();\n  Function: get the starting point of the first (sorted) sublocation\n  Returns : integer\n  Args    : none\n\n\nsub start {\n    my ($self,$value) = @_;    \n    if( defined $value ) {\n\t$self->throw(\"Trying to set the starting point of a split location, \".\n\t\t\t\t \"that is not possible, try manipulating the sub Locations\");\n    }\n    return $self->SUPER::start();\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $location->end();\n  Function: get the ending point of the last (sorted) sublocation\n  Returns : integer\n  Args    : none\n\n\nsub end {\n    my ($self,$value) = @_;    \n    if( defined $value ) {\n\t$self->throw(\"Trying to set the ending point of a split location, \".\n\t\t\t\t \"that is not possible, try manipulating the sub Locations\");\n    }\n    return $self->SUPER::end();\n}\n\n=head2 min_start\n\n  Title   : min_start\n  Usage   : $min_start = $location->min_start();\n  Function: get the minimum starting point\n  Returns : the minimum starting point from the contained sublocations\n  Args    : none\n\n\nsub min_start {\n    my ($self, $value) = @_;    \n\n    if( defined $value ) {\n\t$self->throw(\"Trying to set the minimum starting point of a split \".\n\t\t\t\t \"location, that is not possible, try manipulating the sub Locations\");\n    }\n    my @locs = $self->sub_Location(1);\n    return $locs[0]->min_start() if @locs; \n    return;\n}\n\n=head2 max_start\n\n  Title   : max_start\n  Usage   : my $maxstart = $location->max_start();\n  Function: Get maximum starting location of feature startpoint  \n  Returns : integer or undef if no maximum starting point.\n  Args    : none\n\n\nsub max_start {\n    my ($self,$value) = @_;\n\n    if( defined $value ) {\n\t$self->throw(\"Trying to set the maximum starting point of a split \".\n\t\t\t\t \"location, that is not possible, try manipulating the sub Locations\");\n    }\n    my @locs = $self->sub_Location(1);\n    return $locs[0]->max_start() if @locs; \n    return;\n}\n\n=head2 start_pos_type\n\n  Title   : start_pos_type\n  Usage   : my $start_pos_type = $location->start_pos_type();\n  Function: Get start position type (ie <,>, ^) \n  Returns : type of position coded as text \n            ('BEFORE', 'AFTER', 'EXACT','WITHIN', 'BETWEEN')\n  Args    : none\n\n\nsub start_pos_type {\n    my ($self,$value) = @_;\n\n    if( defined $value ) {\n\t$self->throw(\"Trying to set the start_pos_type of a split location, \".\n\t\t\t\t \"that is not possible, try manipulating the sub Locations\");\n    }\n    my @locs = $self->sub_Location();\n    return ( @locs ) ? $locs[0]->start_pos_type() : undef;    \n}\n\n=head2 min_end\n\n  Title   : min_end\n  Usage   : my $minend = $location->min_end();\n  Function: Get minimum ending location of feature endpoint \n  Returns : integer or undef if no minimum ending point.\n  Args    : none","parameters":[{"label":"$self"},{"label":"$value"}]},"line":504,"kind":12,"range":{"end":{"line":515,"character":9999},"start":{"line":504,"character":0}},"definition":"sub","detail":"($self,$value)","children":[{"definition":"my","line":505,"name":"$self","containerName":"min_end","localvar":"my","kind":13},{"containerName":"min_end","kind":13,"name":"$value","line":505},{"line":507,"name":"$value","containerName":"min_end","kind":13},{"line":508,"name":"$self","containerName":"min_end","kind":13},{"line":508,"kind":12,"containerName":"min_end","name":"throw"},{"definition":"my","containerName":"min_end","localvar":"my","kind":13,"name":"@locs","line":512},{"name":"$self","containerName":"min_end","kind":13,"line":512},{"line":512,"containerName":"min_end","kind":12,"name":"sub_Location"},{"name":"$locs","containerName":"min_end","kind":13,"line":513},{"name":"min_end","containerName":"min_end","kind":12,"line":513},{"line":513,"kind":13,"containerName":"min_end","name":"@locs"}],"containerName":"Bio::Location::Split","name":"min_end"},{"kind":12,"range":{"end":{"character":9999,"line":538},"start":{"character":0,"line":527}},"line":527,"signature":{"documentation":"1;\n# $Id: Split.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::Split\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::Split - Implementation of a Location on a Sequence\nwhich has multiple locations (start/end points)\n\n=head1 SYNOPSIS\n\n    use Bio::Location::Split;\n\n    my $splitlocation = Bio::Location::Split->new();\n    $splitlocation->add_sub_Location(Bio::Location::Simple->new(-start=>1,\n\t\t\t\t\t\t\t       -end=>30,\n\t\t\t\t\t\t\t       -strand=>1));\n    $splitlocation->add_sub_Location(Bio::Location::Simple->new(-start=>50,\n\t\t\t\t\t\t\t       -end=>61,\n\t\t\t\t\t\t\t       -strand=>1));   \n    my @sublocs = $splitlocation->sub_Location();\n\n    my $count = 1;\n    # print the start/end points of the sub locations\n    foreach my $location ( sort { $a->start <=> $b->start } \n\t\t\t   @sublocs ) {\n\tprintf \"sub feature %d [%d..%d]\\n\", \n\t       $count, $location->start,$location->end, \"\\n\";\n        $count++;\n    }\n\n=head1 DESCRIPTION\n\nThis implementation handles locations which span more than one\nstart/end location, or and/or lie on different sequences, and can\nwork with split locations that depend on the specific order of the\nsublocations ('join') or don't have a specific order but represent\na feature spanning discontiguous sublocations ('order', 'bond').\n\nNote that the order in which sublocations are added may be very important,\ndepending on the specific split location type.  For instance, a 'join'\nmust have the sublocations added in the order that one expects to\njoin the sublocations, whereas all other types are sorted based on the\nsequence location.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl_DOT_org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Location::Split;\n\n# as defined by BSANE 0.03\nour @CORBALOCATIONOPERATOR = ('NONE','JOIN', undef, 'ORDER');;\n\nuse Bio::Root::Root;\n\nuse base qw(Bio::Location::Atomic Bio::Location::SplitLocationI);\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    # initialize\n    $self->{'_sublocations'} = [];\n    my ( $type, $seqid, $locations ) = \n\t$self->_rearrange([qw(SPLITTYPE\n                              SEQ_ID\n\t\t\t      LOCATIONS\n                              )], @args);\n    if( defined $locations && ref($locations) =~ /array/i ) {\n\t$self->add_sub_Location(@$locations);\n    }\n    $seqid  && $self->seq_id($seqid);\n    $type = lc ($type);    \n    $self->splittype($type || 'JOIN');\n    return $self;\n}\n\n=head2 each_Location\n\n Title   : each_Location\n Usage   : @locations = $locObject->each_Location($order);\n Function: Conserved function call across Location:: modules - will\n           return an array containing the component Location(s) in\n           that object, regardless if the calling object is itself a\n           single location or one containing sublocations.\n Returns : an array of Bio::LocationI implementing objects\n Args    : Optional sort order to be passed to sub_Location()\n\n\nsub each_Location {\n    my ($self, $order) = @_;\n    my @locs = ();\n    foreach my $subloc ($self->sub_Location($order)) {\n\t# Recursively check to get hierarchical split locations:\n\tpush @locs, $subloc->each_Location($order);\n    }\n    return @locs;\n}\n\n=head2 sub_Location\n\n Title   : sub_Location\n Usage   : @sublocs = $splitloc->sub_Location();\n Function: Returns the array of sublocations making up this compound (split)\n           location. Those sublocations referring to the same sequence as\n           the root split location will be sorted by start position (forward\n           sort) or end position (reverse sort) and come first (before\n           those on other sequences).\n\n           The sort order can be optionally specified or suppressed by the\n           value of the first argument. The default is no sort.\n\n Returns : an array of Bio::LocationI implementing objects\n Args    : Optionally 1, 0, or -1 for specifying a forward, no, or reverse\n           sort order\n\n\nsub sub_Location {\n    my ($self, $order) = @_;\n    $order = 0 unless defined $order;\n    if( defined($order) && ($order !~ /^-?\\d+$/) ) {\n\t$self->throw(\"value $order passed in to sub_Location is $order, an invalid value\");\n    } \n    $order = 1 if($order > 1);\n    $order = -1 if($order < -1);\n    my @sublocs = defined $self->{'_sublocations'} ? @{$self->{'_sublocations'}} : ();\n\n    # return the array if no ordering requested\n    return @sublocs if( ($order == 0) || (! @sublocs) );\n    \t\n    # sort those locations that are on the same sequence as the top (`master')\n    # if the top seq is undefined, we take the first defined in a sublocation\n    my $seqid = $self->seq_id();\n    my $i = 0;\n    while((! defined($seqid)) && ($i <= $#sublocs)) {\n\t\t$seqid = $sublocs[$i++]->seq_id();\n    }\n    if((! $self->seq_id()) && $seqid) {\n\t\t$self->warn(\"sorted sublocation array requested but \".\n\t\t\t\t\"root location doesn't define seq_id \".\n\t\t\t\t\"(at least one sublocation does!)\");\n    }\n    my @locs = ($seqid ?\n\t\tgrep { $_->seq_id() eq $seqid; } @sublocs :\n\t\t@sublocs);\n    if(@locs) {\n\t\tif($order == 1) {\n\t\t\t# Schwartzian transforms for performance boost\t  \n\t\t\t@locs = map { $_->[0] }\n\t\t\tsort {\n\t\t\t\t(defined $a && defined $b) ? $a->[1] <=> $b->[1] :\n                $a                         ?  -1                 : 1\n\t\t\t\t}\n\t\t\tmap {\n\t\t\t\t[$_, (defined $_->start ? $_->start : $_->end)]\n\t\t\t\t} @locs;;\n\t\t} else { # $order == -1\n\t\t\t@locs = map { $_->[0]}\n\t\t\tsort { \n\t\t\t\t(defined $a && defined $b) ? $b->[1] <=> $a->[1] :\n\t\t\t\t$a                         ? -1                  : 1\n\t\t\t\t}\n\t\t\tmap {\n\t\t\t\t[$_, (defined $_->end ? $_->end : $_->start)]\n\t\t\t\t} @locs;\n\t\t}\n    }\n    # push the rest unsorted\n    if($seqid) {\n\t\tpush(@locs, grep { $_->seq_id() ne $seqid; } @sublocs);\n    }\n    # done!\n\n    return @locs;\n}\n\n=head2 add_sub_Location\n\n Title   : add_sub_Location\n Usage   : $splitloc->add_sub_Location(@locationIobjs);\n Function: add an additional sublocation\n Returns : number of current sub locations\n Args    : list of Bio::LocationI implementing object(s) to add\n\n\nsub add_sub_Location {\n    my ($self,@args) = @_;\n    my @locs;    \n    foreach my $loc ( @args ) {\n\tif( !ref($loc) || ! $loc->isa('Bio::LocationI') ) {\n\t    $self->throw(\"Trying to add $loc as a sub Location but it doesn't implement Bio::LocationI!\");\n\t    next;\n\t}\t\n\tpush @{$self->{'_sublocations'}}, $loc;\n    }\n\n    return scalar @{$self->{'_sublocations'}};\n}\n\n=head2 splittype\n\n  Title   : splittype\n  Usage   : $splittype = $location->splittype();\n  Function: get/set the split splittype\n  Returns : the splittype of split feature (join, order)\n  Args    : splittype to set\n\n\nsub splittype {\n    my ($self, $value) = @_;\n    if( defined $value || ! defined $self->{'_splittype'} ) {\n\t$value = 'JOIN' unless( defined $value );\n\t$self->{'_splittype'} = uc ($value);\n    }\n    return $self->{'_splittype'};\n}\n\n=head2 is_single_sequence\n\n  Title   : is_single_sequence\n  Usage   : if($splitloc->is_single_sequence()) {\n                print \"Location object $splitloc is split \".\n                      \"but only across a single sequence\\n\";\n\t    }\n  Function: Determine whether this location is split across a single or\n            multiple sequences.\n\n            This implementation ignores (sub-)locations that do not define\n            seq_id(). The same holds true for the root location.\n\n  Returns : TRUE if all sublocations lie on the same sequence as the root\n            location (feature), and FALSE otherwise.\n  Args    : none\n\n\nsub is_single_sequence {\n    my ($self) = @_;\n\n    my $seqid = $self->seq_id();\n    foreach my $loc ($self->sub_Location(0)) {\n\t$seqid = $loc->seq_id() if(! $seqid);\n\tif(defined($loc->seq_id()) && ($loc->seq_id() ne $seqid)) {\n\t    return 0;\n\t}\n    }\n    return 1;\n}\n\n=head2 guide_strand\n\n  Title   : guide_strand\n  Usage   : $str = $loc->guide_strand();\n  Function: Get/Set the guide strand.  Of use only if the split type is\n            a 'join' (this helps determine the order of sublocation\n\t\t\tretrieval)\n  Returns : value of guide strand (1, -1, or undef)\n  Args    : new value (-1 or 1, optional)\n\n\nsub guide_strand {\n\tmy $self = shift;\n\treturn $self->{'strand'} = shift if @_;\n\treturn $self->{'strand'};\n}\n\n=head1 LocationI methods\n\n=head2 strand\n\n Title   : strand\n Usage   : $obj->strand($newval)\n Function: For SplitLocations, setting the strand of the container\n           (this object) is a short-cut for setting the strand of all\n           sublocations.\n\n           In get-mode, checks if no sub-location is remote, and if\n           all have the same strand. If so, it returns that shared\n           strand value. Otherwise it returns undef.\n\n Example : \n Returns : on get, value of strand if identical between sublocations \n           (-1, 1, or undef)\n Args    : new value (-1 or 1, optional)\n\n\n\nsub strand{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t\t$self->{'strand'} = $value;\n\t\t# propagate to all sublocs\n\t\tforeach my $loc ($self->sub_Location(0)) {\n\t\t\t$loc->strand($value);\n\t\t}\n    } else {\n\t\tmy ($strand, $lstrand);\n\t\tforeach my $loc ($self->sub_Location(0)) {\n\t\t\t# we give up upon any location that's remote or doesn't have\n\t\t\t# the strand specified, or has a differing one set than \n\t\t\t# previously seen.\n\t\t\t# calling strand() is potentially expensive if the subloc is also\n\t\t\t# a split location, so we cache it\n\t\t\t$lstrand = $loc->strand();\n\t\t\tif((! $lstrand) ||\n\t\t\t   ($strand && ($strand != $lstrand)) ||\n\t\t\t   $loc->is_remote()) {\n\t\t\t$strand = undef;\n\t\t\tlast;\n\t\t\t} elsif(! $strand) {\n\t\t\t$strand = $lstrand;\n\t\t\t}\n\t\t}\n\t\treturn $strand;\n    }\n}\n\n=head2 flip_strand\n\n  Title   : flip_strand\n  Usage   : $location->flip_strand();\n  Function: Flip-flop a strand to the opposite.  Also switch Split strand\n            from undef to -1 or -1 to undef\n  Returns : None\n  Args    : None\n\n\nsub flip_strand {\n    my $self = shift;\n    for my $loc ( $self->sub_Location(0) ) {\n\t\t$loc->flip_strand;\n\t\tif ($loc->isa('Bio::Location::SplitLocationI')) {\n\t\t\tmy $gs = ($self->guide_strand == -1) ? undef : -1;\n\t\t\t$loc->guide_strand($gs);\n\t\t}\n    }\n}\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $location->start();\n  Function: get the starting point of the first (sorted) sublocation\n  Returns : integer\n  Args    : none\n\n\nsub start {\n    my ($self,$value) = @_;    \n    if( defined $value ) {\n\t$self->throw(\"Trying to set the starting point of a split location, \".\n\t\t\t\t \"that is not possible, try manipulating the sub Locations\");\n    }\n    return $self->SUPER::start();\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $location->end();\n  Function: get the ending point of the last (sorted) sublocation\n  Returns : integer\n  Args    : none\n\n\nsub end {\n    my ($self,$value) = @_;    \n    if( defined $value ) {\n\t$self->throw(\"Trying to set the ending point of a split location, \".\n\t\t\t\t \"that is not possible, try manipulating the sub Locations\");\n    }\n    return $self->SUPER::end();\n}\n\n=head2 min_start\n\n  Title   : min_start\n  Usage   : $min_start = $location->min_start();\n  Function: get the minimum starting point\n  Returns : the minimum starting point from the contained sublocations\n  Args    : none\n\n\nsub min_start {\n    my ($self, $value) = @_;    \n\n    if( defined $value ) {\n\t$self->throw(\"Trying to set the minimum starting point of a split \".\n\t\t\t\t \"location, that is not possible, try manipulating the sub Locations\");\n    }\n    my @locs = $self->sub_Location(1);\n    return $locs[0]->min_start() if @locs; \n    return;\n}\n\n=head2 max_start\n\n  Title   : max_start\n  Usage   : my $maxstart = $location->max_start();\n  Function: Get maximum starting location of feature startpoint  \n  Returns : integer or undef if no maximum starting point.\n  Args    : none\n\n\nsub max_start {\n    my ($self,$value) = @_;\n\n    if( defined $value ) {\n\t$self->throw(\"Trying to set the maximum starting point of a split \".\n\t\t\t\t \"location, that is not possible, try manipulating the sub Locations\");\n    }\n    my @locs = $self->sub_Location(1);\n    return $locs[0]->max_start() if @locs; \n    return;\n}\n\n=head2 start_pos_type\n\n  Title   : start_pos_type\n  Usage   : my $start_pos_type = $location->start_pos_type();\n  Function: Get start position type (ie <,>, ^) \n  Returns : type of position coded as text \n            ('BEFORE', 'AFTER', 'EXACT','WITHIN', 'BETWEEN')\n  Args    : none\n\n\nsub start_pos_type {\n    my ($self,$value) = @_;\n\n    if( defined $value ) {\n\t$self->throw(\"Trying to set the start_pos_type of a split location, \".\n\t\t\t\t \"that is not possible, try manipulating the sub Locations\");\n    }\n    my @locs = $self->sub_Location();\n    return ( @locs ) ? $locs[0]->start_pos_type() : undef;    \n}\n\n=head2 min_end\n\n  Title   : min_end\n  Usage   : my $minend = $location->min_end();\n  Function: Get minimum ending location of feature endpoint \n  Returns : integer or undef if no minimum ending point.\n  Args    : none\n\n\nsub min_end {\n    my ($self,$value) = @_;\n\n    if( defined $value ) {\n\t$self->throw(\"Trying to set the minimum end point of a split location, \".\n\t\t\t\t \"that is not possible, try manipulating the sub Locations\");\n    }\n    # reverse sort locations by largest ending to smallest ending\n    my @locs = $self->sub_Location(-1);\n    return $locs[0]->min_end() if @locs; \n    return;\n}\n\n=head2 max_end\n\n  Title   : max_end\n  Usage   : my $maxend = $location->max_end();\n  Function: Get maximum ending location of feature endpoint \n  Returns : integer or undef if no maximum ending point.\n  Args    : none","parameters":[{"label":"$self"},{"label":"$value"}],"label":"max_end($self,$value)"},"name":"max_end","containerName":"Bio::Location::Split","children":[{"kind":13,"localvar":"my","containerName":"max_end","name":"$self","line":528,"definition":"my"},{"containerName":"max_end","kind":13,"name":"$value","line":528},{"kind":13,"containerName":"max_end","name":"$value","line":530},{"name":"$self","containerName":"max_end","kind":13,"line":531},{"line":531,"name":"throw","containerName":"max_end","kind":12},{"line":535,"kind":13,"localvar":"my","containerName":"max_end","name":"@locs","definition":"my"},{"line":535,"kind":13,"containerName":"max_end","name":"$self"},{"line":535,"kind":12,"containerName":"max_end","name":"sub_Location"},{"kind":13,"containerName":"max_end","name":"$locs","line":536},{"line":536,"name":"max_end","kind":12,"containerName":"max_end"},{"line":536,"containerName":"max_end","kind":13,"name":"@locs"}],"detail":"($self,$value)","definition":"sub"},{"signature":{"label":"end_pos_type($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Split.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::Split\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::Split - Implementation of a Location on a Sequence\nwhich has multiple locations (start/end points)\n\n=head1 SYNOPSIS\n\n    use Bio::Location::Split;\n\n    my $splitlocation = Bio::Location::Split->new();\n    $splitlocation->add_sub_Location(Bio::Location::Simple->new(-start=>1,\n\t\t\t\t\t\t\t       -end=>30,\n\t\t\t\t\t\t\t       -strand=>1));\n    $splitlocation->add_sub_Location(Bio::Location::Simple->new(-start=>50,\n\t\t\t\t\t\t\t       -end=>61,\n\t\t\t\t\t\t\t       -strand=>1));   \n    my @sublocs = $splitlocation->sub_Location();\n\n    my $count = 1;\n    # print the start/end points of the sub locations\n    foreach my $location ( sort { $a->start <=> $b->start } \n\t\t\t   @sublocs ) {\n\tprintf \"sub feature %d [%d..%d]\\n\", \n\t       $count, $location->start,$location->end, \"\\n\";\n        $count++;\n    }\n\n=head1 DESCRIPTION\n\nThis implementation handles locations which span more than one\nstart/end location, or and/or lie on different sequences, and can\nwork with split locations that depend on the specific order of the\nsublocations ('join') or don't have a specific order but represent\na feature spanning discontiguous sublocations ('order', 'bond').\n\nNote that the order in which sublocations are added may be very important,\ndepending on the specific split location type.  For instance, a 'join'\nmust have the sublocations added in the order that one expects to\njoin the sublocations, whereas all other types are sorted based on the\nsequence location.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl_DOT_org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Location::Split;\n\n# as defined by BSANE 0.03\nour @CORBALOCATIONOPERATOR = ('NONE','JOIN', undef, 'ORDER');;\n\nuse Bio::Root::Root;\n\nuse base qw(Bio::Location::Atomic Bio::Location::SplitLocationI);\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    # initialize\n    $self->{'_sublocations'} = [];\n    my ( $type, $seqid, $locations ) = \n\t$self->_rearrange([qw(SPLITTYPE\n                              SEQ_ID\n\t\t\t      LOCATIONS\n                              )], @args);\n    if( defined $locations && ref($locations) =~ /array/i ) {\n\t$self->add_sub_Location(@$locations);\n    }\n    $seqid  && $self->seq_id($seqid);\n    $type = lc ($type);    \n    $self->splittype($type || 'JOIN');\n    return $self;\n}\n\n=head2 each_Location\n\n Title   : each_Location\n Usage   : @locations = $locObject->each_Location($order);\n Function: Conserved function call across Location:: modules - will\n           return an array containing the component Location(s) in\n           that object, regardless if the calling object is itself a\n           single location or one containing sublocations.\n Returns : an array of Bio::LocationI implementing objects\n Args    : Optional sort order to be passed to sub_Location()\n\n\nsub each_Location {\n    my ($self, $order) = @_;\n    my @locs = ();\n    foreach my $subloc ($self->sub_Location($order)) {\n\t# Recursively check to get hierarchical split locations:\n\tpush @locs, $subloc->each_Location($order);\n    }\n    return @locs;\n}\n\n=head2 sub_Location\n\n Title   : sub_Location\n Usage   : @sublocs = $splitloc->sub_Location();\n Function: Returns the array of sublocations making up this compound (split)\n           location. Those sublocations referring to the same sequence as\n           the root split location will be sorted by start position (forward\n           sort) or end position (reverse sort) and come first (before\n           those on other sequences).\n\n           The sort order can be optionally specified or suppressed by the\n           value of the first argument. The default is no sort.\n\n Returns : an array of Bio::LocationI implementing objects\n Args    : Optionally 1, 0, or -1 for specifying a forward, no, or reverse\n           sort order\n\n\nsub sub_Location {\n    my ($self, $order) = @_;\n    $order = 0 unless defined $order;\n    if( defined($order) && ($order !~ /^-?\\d+$/) ) {\n\t$self->throw(\"value $order passed in to sub_Location is $order, an invalid value\");\n    } \n    $order = 1 if($order > 1);\n    $order = -1 if($order < -1);\n    my @sublocs = defined $self->{'_sublocations'} ? @{$self->{'_sublocations'}} : ();\n\n    # return the array if no ordering requested\n    return @sublocs if( ($order == 0) || (! @sublocs) );\n    \t\n    # sort those locations that are on the same sequence as the top (`master')\n    # if the top seq is undefined, we take the first defined in a sublocation\n    my $seqid = $self->seq_id();\n    my $i = 0;\n    while((! defined($seqid)) && ($i <= $#sublocs)) {\n\t\t$seqid = $sublocs[$i++]->seq_id();\n    }\n    if((! $self->seq_id()) && $seqid) {\n\t\t$self->warn(\"sorted sublocation array requested but \".\n\t\t\t\t\"root location doesn't define seq_id \".\n\t\t\t\t\"(at least one sublocation does!)\");\n    }\n    my @locs = ($seqid ?\n\t\tgrep { $_->seq_id() eq $seqid; } @sublocs :\n\t\t@sublocs);\n    if(@locs) {\n\t\tif($order == 1) {\n\t\t\t# Schwartzian transforms for performance boost\t  \n\t\t\t@locs = map { $_->[0] }\n\t\t\tsort {\n\t\t\t\t(defined $a && defined $b) ? $a->[1] <=> $b->[1] :\n                $a                         ?  -1                 : 1\n\t\t\t\t}\n\t\t\tmap {\n\t\t\t\t[$_, (defined $_->start ? $_->start : $_->end)]\n\t\t\t\t} @locs;;\n\t\t} else { # $order == -1\n\t\t\t@locs = map { $_->[0]}\n\t\t\tsort { \n\t\t\t\t(defined $a && defined $b) ? $b->[1] <=> $a->[1] :\n\t\t\t\t$a                         ? -1                  : 1\n\t\t\t\t}\n\t\t\tmap {\n\t\t\t\t[$_, (defined $_->end ? $_->end : $_->start)]\n\t\t\t\t} @locs;\n\t\t}\n    }\n    # push the rest unsorted\n    if($seqid) {\n\t\tpush(@locs, grep { $_->seq_id() ne $seqid; } @sublocs);\n    }\n    # done!\n\n    return @locs;\n}\n\n=head2 add_sub_Location\n\n Title   : add_sub_Location\n Usage   : $splitloc->add_sub_Location(@locationIobjs);\n Function: add an additional sublocation\n Returns : number of current sub locations\n Args    : list of Bio::LocationI implementing object(s) to add\n\n\nsub add_sub_Location {\n    my ($self,@args) = @_;\n    my @locs;    \n    foreach my $loc ( @args ) {\n\tif( !ref($loc) || ! $loc->isa('Bio::LocationI') ) {\n\t    $self->throw(\"Trying to add $loc as a sub Location but it doesn't implement Bio::LocationI!\");\n\t    next;\n\t}\t\n\tpush @{$self->{'_sublocations'}}, $loc;\n    }\n\n    return scalar @{$self->{'_sublocations'}};\n}\n\n=head2 splittype\n\n  Title   : splittype\n  Usage   : $splittype = $location->splittype();\n  Function: get/set the split splittype\n  Returns : the splittype of split feature (join, order)\n  Args    : splittype to set\n\n\nsub splittype {\n    my ($self, $value) = @_;\n    if( defined $value || ! defined $self->{'_splittype'} ) {\n\t$value = 'JOIN' unless( defined $value );\n\t$self->{'_splittype'} = uc ($value);\n    }\n    return $self->{'_splittype'};\n}\n\n=head2 is_single_sequence\n\n  Title   : is_single_sequence\n  Usage   : if($splitloc->is_single_sequence()) {\n                print \"Location object $splitloc is split \".\n                      \"but only across a single sequence\\n\";\n\t    }\n  Function: Determine whether this location is split across a single or\n            multiple sequences.\n\n            This implementation ignores (sub-)locations that do not define\n            seq_id(). The same holds true for the root location.\n\n  Returns : TRUE if all sublocations lie on the same sequence as the root\n            location (feature), and FALSE otherwise.\n  Args    : none\n\n\nsub is_single_sequence {\n    my ($self) = @_;\n\n    my $seqid = $self->seq_id();\n    foreach my $loc ($self->sub_Location(0)) {\n\t$seqid = $loc->seq_id() if(! $seqid);\n\tif(defined($loc->seq_id()) && ($loc->seq_id() ne $seqid)) {\n\t    return 0;\n\t}\n    }\n    return 1;\n}\n\n=head2 guide_strand\n\n  Title   : guide_strand\n  Usage   : $str = $loc->guide_strand();\n  Function: Get/Set the guide strand.  Of use only if the split type is\n            a 'join' (this helps determine the order of sublocation\n\t\t\tretrieval)\n  Returns : value of guide strand (1, -1, or undef)\n  Args    : new value (-1 or 1, optional)\n\n\nsub guide_strand {\n\tmy $self = shift;\n\treturn $self->{'strand'} = shift if @_;\n\treturn $self->{'strand'};\n}\n\n=head1 LocationI methods\n\n=head2 strand\n\n Title   : strand\n Usage   : $obj->strand($newval)\n Function: For SplitLocations, setting the strand of the container\n           (this object) is a short-cut for setting the strand of all\n           sublocations.\n\n           In get-mode, checks if no sub-location is remote, and if\n           all have the same strand. If so, it returns that shared\n           strand value. Otherwise it returns undef.\n\n Example : \n Returns : on get, value of strand if identical between sublocations \n           (-1, 1, or undef)\n Args    : new value (-1 or 1, optional)\n\n\n\nsub strand{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t\t$self->{'strand'} = $value;\n\t\t# propagate to all sublocs\n\t\tforeach my $loc ($self->sub_Location(0)) {\n\t\t\t$loc->strand($value);\n\t\t}\n    } else {\n\t\tmy ($strand, $lstrand);\n\t\tforeach my $loc ($self->sub_Location(0)) {\n\t\t\t# we give up upon any location that's remote or doesn't have\n\t\t\t# the strand specified, or has a differing one set than \n\t\t\t# previously seen.\n\t\t\t# calling strand() is potentially expensive if the subloc is also\n\t\t\t# a split location, so we cache it\n\t\t\t$lstrand = $loc->strand();\n\t\t\tif((! $lstrand) ||\n\t\t\t   ($strand && ($strand != $lstrand)) ||\n\t\t\t   $loc->is_remote()) {\n\t\t\t$strand = undef;\n\t\t\tlast;\n\t\t\t} elsif(! $strand) {\n\t\t\t$strand = $lstrand;\n\t\t\t}\n\t\t}\n\t\treturn $strand;\n    }\n}\n\n=head2 flip_strand\n\n  Title   : flip_strand\n  Usage   : $location->flip_strand();\n  Function: Flip-flop a strand to the opposite.  Also switch Split strand\n            from undef to -1 or -1 to undef\n  Returns : None\n  Args    : None\n\n\nsub flip_strand {\n    my $self = shift;\n    for my $loc ( $self->sub_Location(0) ) {\n\t\t$loc->flip_strand;\n\t\tif ($loc->isa('Bio::Location::SplitLocationI')) {\n\t\t\tmy $gs = ($self->guide_strand == -1) ? undef : -1;\n\t\t\t$loc->guide_strand($gs);\n\t\t}\n    }\n}\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $location->start();\n  Function: get the starting point of the first (sorted) sublocation\n  Returns : integer\n  Args    : none\n\n\nsub start {\n    my ($self,$value) = @_;    \n    if( defined $value ) {\n\t$self->throw(\"Trying to set the starting point of a split location, \".\n\t\t\t\t \"that is not possible, try manipulating the sub Locations\");\n    }\n    return $self->SUPER::start();\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $location->end();\n  Function: get the ending point of the last (sorted) sublocation\n  Returns : integer\n  Args    : none\n\n\nsub end {\n    my ($self,$value) = @_;    \n    if( defined $value ) {\n\t$self->throw(\"Trying to set the ending point of a split location, \".\n\t\t\t\t \"that is not possible, try manipulating the sub Locations\");\n    }\n    return $self->SUPER::end();\n}\n\n=head2 min_start\n\n  Title   : min_start\n  Usage   : $min_start = $location->min_start();\n  Function: get the minimum starting point\n  Returns : the minimum starting point from the contained sublocations\n  Args    : none\n\n\nsub min_start {\n    my ($self, $value) = @_;    \n\n    if( defined $value ) {\n\t$self->throw(\"Trying to set the minimum starting point of a split \".\n\t\t\t\t \"location, that is not possible, try manipulating the sub Locations\");\n    }\n    my @locs = $self->sub_Location(1);\n    return $locs[0]->min_start() if @locs; \n    return;\n}\n\n=head2 max_start\n\n  Title   : max_start\n  Usage   : my $maxstart = $location->max_start();\n  Function: Get maximum starting location of feature startpoint  \n  Returns : integer or undef if no maximum starting point.\n  Args    : none\n\n\nsub max_start {\n    my ($self,$value) = @_;\n\n    if( defined $value ) {\n\t$self->throw(\"Trying to set the maximum starting point of a split \".\n\t\t\t\t \"location, that is not possible, try manipulating the sub Locations\");\n    }\n    my @locs = $self->sub_Location(1);\n    return $locs[0]->max_start() if @locs; \n    return;\n}\n\n=head2 start_pos_type\n\n  Title   : start_pos_type\n  Usage   : my $start_pos_type = $location->start_pos_type();\n  Function: Get start position type (ie <,>, ^) \n  Returns : type of position coded as text \n            ('BEFORE', 'AFTER', 'EXACT','WITHIN', 'BETWEEN')\n  Args    : none\n\n\nsub start_pos_type {\n    my ($self,$value) = @_;\n\n    if( defined $value ) {\n\t$self->throw(\"Trying to set the start_pos_type of a split location, \".\n\t\t\t\t \"that is not possible, try manipulating the sub Locations\");\n    }\n    my @locs = $self->sub_Location();\n    return ( @locs ) ? $locs[0]->start_pos_type() : undef;    \n}\n\n=head2 min_end\n\n  Title   : min_end\n  Usage   : my $minend = $location->min_end();\n  Function: Get minimum ending location of feature endpoint \n  Returns : integer or undef if no minimum ending point.\n  Args    : none\n\n\nsub min_end {\n    my ($self,$value) = @_;\n\n    if( defined $value ) {\n\t$self->throw(\"Trying to set the minimum end point of a split location, \".\n\t\t\t\t \"that is not possible, try manipulating the sub Locations\");\n    }\n    # reverse sort locations by largest ending to smallest ending\n    my @locs = $self->sub_Location(-1);\n    return $locs[0]->min_end() if @locs; \n    return;\n}\n\n=head2 max_end\n\n  Title   : max_end\n  Usage   : my $maxend = $location->max_end();\n  Function: Get maximum ending location of feature endpoint \n  Returns : integer or undef if no maximum ending point.\n  Args    : none\n\n\nsub max_end {\n    my ($self,$value) = @_;\n\n    if( defined $value ) {\n\t$self->throw(\"Trying to set the maximum end point of a split location, \".\n\t\t\t\t \"that is not possible, try manipulating the sub Locations\");\n    }\n    # reverse sort locations by largest ending to smallest ending\n    my @locs = $self->sub_Location(-1);\n    return $locs[0]->max_end() if @locs; \n    return;\n}\n\n=head2 end_pos_type\n\n  Title   : end_pos_type\n  Usage   : my $end_pos_type = $location->end_pos_type();\n  Function: Get end position type (ie <,>, ^) \n  Returns : type of position coded as text \n            ('BEFORE', 'AFTER', 'EXACT','WITHIN', 'BETWEEN')\n  Args    : none"},"line":551,"kind":12,"range":{"start":{"character":0,"line":551},"end":{"line":560,"character":9999}},"definition":"sub","detail":"($self,$value)","children":[{"name":"$self","localvar":"my","containerName":"end_pos_type","kind":13,"line":552,"definition":"my"},{"kind":13,"containerName":"end_pos_type","name":"$value","line":552},{"name":"$value","containerName":"end_pos_type","kind":13,"line":554},{"name":"$self","containerName":"end_pos_type","kind":13,"line":555},{"line":555,"name":"throw","containerName":"end_pos_type","kind":12},{"definition":"my","line":558,"name":"@locs","kind":13,"localvar":"my","containerName":"end_pos_type"},{"line":558,"kind":13,"containerName":"end_pos_type","name":"$self"},{"kind":12,"containerName":"end_pos_type","name":"sub_Location","line":558},{"kind":13,"containerName":"end_pos_type","name":"@locs","line":559},{"name":"$locs","containerName":"end_pos_type","kind":13,"line":559},{"kind":12,"containerName":"end_pos_type","name":"end_pos_type","line":559}],"name":"end_pos_type","containerName":"Bio::Location::Split"},{"range":{"end":{"character":9999,"line":586},"start":{"line":577,"character":0}},"kind":12,"line":577,"name":"seq_id","containerName":"Bio::Location::Split","children":[{"line":578,"kind":13,"localvar":"my","containerName":"seq_id","name":"$self","definition":"my"},{"line":580,"kind":13,"containerName":"seq_id","name":"$self"},{"line":580,"containerName":"seq_id","kind":12,"name":"is_remote"},{"definition":"my","containerName":"seq_id","localvar":"my","kind":13,"name":"$subloc","line":581},{"name":"$self","kind":13,"containerName":"seq_id","line":581},{"line":581,"name":"sub_Location","containerName":"seq_id","kind":12},{"line":582,"name":"$subloc","containerName":"seq_id","kind":13},{"line":582,"containerName":"seq_id","kind":12,"name":"seq_id"},{"line":582,"kind":13,"containerName":"seq_id","name":"$subloc"},{"kind":12,"containerName":"seq_id","name":"is_remote","line":582},{"kind":13,"containerName":"seq_id","name":"$self","line":585}],"definition":"sub"},{"kind":12,"containerName":"seq_id","name":"SUPER","line":585},{"signature":{"label":"to_FTstring($self)","documentation":"1;\n# $Id: Split.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::Split\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::Split - Implementation of a Location on a Sequence\nwhich has multiple locations (start/end points)\n\n=head1 SYNOPSIS\n\n    use Bio::Location::Split;\n\n    my $splitlocation = Bio::Location::Split->new();\n    $splitlocation->add_sub_Location(Bio::Location::Simple->new(-start=>1,\n\t\t\t\t\t\t\t       -end=>30,\n\t\t\t\t\t\t\t       -strand=>1));\n    $splitlocation->add_sub_Location(Bio::Location::Simple->new(-start=>50,\n\t\t\t\t\t\t\t       -end=>61,\n\t\t\t\t\t\t\t       -strand=>1));   \n    my @sublocs = $splitlocation->sub_Location();\n\n    my $count = 1;\n    # print the start/end points of the sub locations\n    foreach my $location ( sort { $a->start <=> $b->start } \n\t\t\t   @sublocs ) {\n\tprintf \"sub feature %d [%d..%d]\\n\", \n\t       $count, $location->start,$location->end, \"\\n\";\n        $count++;\n    }\n\n=head1 DESCRIPTION\n\nThis implementation handles locations which span more than one\nstart/end location, or and/or lie on different sequences, and can\nwork with split locations that depend on the specific order of the\nsublocations ('join') or don't have a specific order but represent\na feature spanning discontiguous sublocations ('order', 'bond').\n\nNote that the order in which sublocations are added may be very important,\ndepending on the specific split location type.  For instance, a 'join'\nmust have the sublocations added in the order that one expects to\njoin the sublocations, whereas all other types are sorted based on the\nsequence location.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl_DOT_org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Location::Split;\n\n# as defined by BSANE 0.03\nour @CORBALOCATIONOPERATOR = ('NONE','JOIN', undef, 'ORDER');;\n\nuse Bio::Root::Root;\n\nuse base qw(Bio::Location::Atomic Bio::Location::SplitLocationI);\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    # initialize\n    $self->{'_sublocations'} = [];\n    my ( $type, $seqid, $locations ) = \n\t$self->_rearrange([qw(SPLITTYPE\n                              SEQ_ID\n\t\t\t      LOCATIONS\n                              )], @args);\n    if( defined $locations && ref($locations) =~ /array/i ) {\n\t$self->add_sub_Location(@$locations);\n    }\n    $seqid  && $self->seq_id($seqid);\n    $type = lc ($type);    \n    $self->splittype($type || 'JOIN');\n    return $self;\n}\n\n=head2 each_Location\n\n Title   : each_Location\n Usage   : @locations = $locObject->each_Location($order);\n Function: Conserved function call across Location:: modules - will\n           return an array containing the component Location(s) in\n           that object, regardless if the calling object is itself a\n           single location or one containing sublocations.\n Returns : an array of Bio::LocationI implementing objects\n Args    : Optional sort order to be passed to sub_Location()\n\n\nsub each_Location {\n    my ($self, $order) = @_;\n    my @locs = ();\n    foreach my $subloc ($self->sub_Location($order)) {\n\t# Recursively check to get hierarchical split locations:\n\tpush @locs, $subloc->each_Location($order);\n    }\n    return @locs;\n}\n\n=head2 sub_Location\n\n Title   : sub_Location\n Usage   : @sublocs = $splitloc->sub_Location();\n Function: Returns the array of sublocations making up this compound (split)\n           location. Those sublocations referring to the same sequence as\n           the root split location will be sorted by start position (forward\n           sort) or end position (reverse sort) and come first (before\n           those on other sequences).\n\n           The sort order can be optionally specified or suppressed by the\n           value of the first argument. The default is no sort.\n\n Returns : an array of Bio::LocationI implementing objects\n Args    : Optionally 1, 0, or -1 for specifying a forward, no, or reverse\n           sort order\n\n\nsub sub_Location {\n    my ($self, $order) = @_;\n    $order = 0 unless defined $order;\n    if( defined($order) && ($order !~ /^-?\\d+$/) ) {\n\t$self->throw(\"value $order passed in to sub_Location is $order, an invalid value\");\n    } \n    $order = 1 if($order > 1);\n    $order = -1 if($order < -1);\n    my @sublocs = defined $self->{'_sublocations'} ? @{$self->{'_sublocations'}} : ();\n\n    # return the array if no ordering requested\n    return @sublocs if( ($order == 0) || (! @sublocs) );\n    \t\n    # sort those locations that are on the same sequence as the top (`master')\n    # if the top seq is undefined, we take the first defined in a sublocation\n    my $seqid = $self->seq_id();\n    my $i = 0;\n    while((! defined($seqid)) && ($i <= $#sublocs)) {\n\t\t$seqid = $sublocs[$i++]->seq_id();\n    }\n    if((! $self->seq_id()) && $seqid) {\n\t\t$self->warn(\"sorted sublocation array requested but \".\n\t\t\t\t\"root location doesn't define seq_id \".\n\t\t\t\t\"(at least one sublocation does!)\");\n    }\n    my @locs = ($seqid ?\n\t\tgrep { $_->seq_id() eq $seqid; } @sublocs :\n\t\t@sublocs);\n    if(@locs) {\n\t\tif($order == 1) {\n\t\t\t# Schwartzian transforms for performance boost\t  \n\t\t\t@locs = map { $_->[0] }\n\t\t\tsort {\n\t\t\t\t(defined $a && defined $b) ? $a->[1] <=> $b->[1] :\n                $a                         ?  -1                 : 1\n\t\t\t\t}\n\t\t\tmap {\n\t\t\t\t[$_, (defined $_->start ? $_->start : $_->end)]\n\t\t\t\t} @locs;;\n\t\t} else { # $order == -1\n\t\t\t@locs = map { $_->[0]}\n\t\t\tsort { \n\t\t\t\t(defined $a && defined $b) ? $b->[1] <=> $a->[1] :\n\t\t\t\t$a                         ? -1                  : 1\n\t\t\t\t}\n\t\t\tmap {\n\t\t\t\t[$_, (defined $_->end ? $_->end : $_->start)]\n\t\t\t\t} @locs;\n\t\t}\n    }\n    # push the rest unsorted\n    if($seqid) {\n\t\tpush(@locs, grep { $_->seq_id() ne $seqid; } @sublocs);\n    }\n    # done!\n\n    return @locs;\n}\n\n=head2 add_sub_Location\n\n Title   : add_sub_Location\n Usage   : $splitloc->add_sub_Location(@locationIobjs);\n Function: add an additional sublocation\n Returns : number of current sub locations\n Args    : list of Bio::LocationI implementing object(s) to add\n\n\nsub add_sub_Location {\n    my ($self,@args) = @_;\n    my @locs;    \n    foreach my $loc ( @args ) {\n\tif( !ref($loc) || ! $loc->isa('Bio::LocationI') ) {\n\t    $self->throw(\"Trying to add $loc as a sub Location but it doesn't implement Bio::LocationI!\");\n\t    next;\n\t}\t\n\tpush @{$self->{'_sublocations'}}, $loc;\n    }\n\n    return scalar @{$self->{'_sublocations'}};\n}\n\n=head2 splittype\n\n  Title   : splittype\n  Usage   : $splittype = $location->splittype();\n  Function: get/set the split splittype\n  Returns : the splittype of split feature (join, order)\n  Args    : splittype to set\n\n\nsub splittype {\n    my ($self, $value) = @_;\n    if( defined $value || ! defined $self->{'_splittype'} ) {\n\t$value = 'JOIN' unless( defined $value );\n\t$self->{'_splittype'} = uc ($value);\n    }\n    return $self->{'_splittype'};\n}\n\n=head2 is_single_sequence\n\n  Title   : is_single_sequence\n  Usage   : if($splitloc->is_single_sequence()) {\n                print \"Location object $splitloc is split \".\n                      \"but only across a single sequence\\n\";\n\t    }\n  Function: Determine whether this location is split across a single or\n            multiple sequences.\n\n            This implementation ignores (sub-)locations that do not define\n            seq_id(). The same holds true for the root location.\n\n  Returns : TRUE if all sublocations lie on the same sequence as the root\n            location (feature), and FALSE otherwise.\n  Args    : none\n\n\nsub is_single_sequence {\n    my ($self) = @_;\n\n    my $seqid = $self->seq_id();\n    foreach my $loc ($self->sub_Location(0)) {\n\t$seqid = $loc->seq_id() if(! $seqid);\n\tif(defined($loc->seq_id()) && ($loc->seq_id() ne $seqid)) {\n\t    return 0;\n\t}\n    }\n    return 1;\n}\n\n=head2 guide_strand\n\n  Title   : guide_strand\n  Usage   : $str = $loc->guide_strand();\n  Function: Get/Set the guide strand.  Of use only if the split type is\n            a 'join' (this helps determine the order of sublocation\n\t\t\tretrieval)\n  Returns : value of guide strand (1, -1, or undef)\n  Args    : new value (-1 or 1, optional)\n\n\nsub guide_strand {\n\tmy $self = shift;\n\treturn $self->{'strand'} = shift if @_;\n\treturn $self->{'strand'};\n}\n\n=head1 LocationI methods\n\n=head2 strand\n\n Title   : strand\n Usage   : $obj->strand($newval)\n Function: For SplitLocations, setting the strand of the container\n           (this object) is a short-cut for setting the strand of all\n           sublocations.\n\n           In get-mode, checks if no sub-location is remote, and if\n           all have the same strand. If so, it returns that shared\n           strand value. Otherwise it returns undef.\n\n Example : \n Returns : on get, value of strand if identical between sublocations \n           (-1, 1, or undef)\n Args    : new value (-1 or 1, optional)\n\n\n\nsub strand{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t\t$self->{'strand'} = $value;\n\t\t# propagate to all sublocs\n\t\tforeach my $loc ($self->sub_Location(0)) {\n\t\t\t$loc->strand($value);\n\t\t}\n    } else {\n\t\tmy ($strand, $lstrand);\n\t\tforeach my $loc ($self->sub_Location(0)) {\n\t\t\t# we give up upon any location that's remote or doesn't have\n\t\t\t# the strand specified, or has a differing one set than \n\t\t\t# previously seen.\n\t\t\t# calling strand() is potentially expensive if the subloc is also\n\t\t\t# a split location, so we cache it\n\t\t\t$lstrand = $loc->strand();\n\t\t\tif((! $lstrand) ||\n\t\t\t   ($strand && ($strand != $lstrand)) ||\n\t\t\t   $loc->is_remote()) {\n\t\t\t$strand = undef;\n\t\t\tlast;\n\t\t\t} elsif(! $strand) {\n\t\t\t$strand = $lstrand;\n\t\t\t}\n\t\t}\n\t\treturn $strand;\n    }\n}\n\n=head2 flip_strand\n\n  Title   : flip_strand\n  Usage   : $location->flip_strand();\n  Function: Flip-flop a strand to the opposite.  Also switch Split strand\n            from undef to -1 or -1 to undef\n  Returns : None\n  Args    : None\n\n\nsub flip_strand {\n    my $self = shift;\n    for my $loc ( $self->sub_Location(0) ) {\n\t\t$loc->flip_strand;\n\t\tif ($loc->isa('Bio::Location::SplitLocationI')) {\n\t\t\tmy $gs = ($self->guide_strand == -1) ? undef : -1;\n\t\t\t$loc->guide_strand($gs);\n\t\t}\n    }\n}\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $location->start();\n  Function: get the starting point of the first (sorted) sublocation\n  Returns : integer\n  Args    : none\n\n\nsub start {\n    my ($self,$value) = @_;    \n    if( defined $value ) {\n\t$self->throw(\"Trying to set the starting point of a split location, \".\n\t\t\t\t \"that is not possible, try manipulating the sub Locations\");\n    }\n    return $self->SUPER::start();\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $location->end();\n  Function: get the ending point of the last (sorted) sublocation\n  Returns : integer\n  Args    : none\n\n\nsub end {\n    my ($self,$value) = @_;    \n    if( defined $value ) {\n\t$self->throw(\"Trying to set the ending point of a split location, \".\n\t\t\t\t \"that is not possible, try manipulating the sub Locations\");\n    }\n    return $self->SUPER::end();\n}\n\n=head2 min_start\n\n  Title   : min_start\n  Usage   : $min_start = $location->min_start();\n  Function: get the minimum starting point\n  Returns : the minimum starting point from the contained sublocations\n  Args    : none\n\n\nsub min_start {\n    my ($self, $value) = @_;    \n\n    if( defined $value ) {\n\t$self->throw(\"Trying to set the minimum starting point of a split \".\n\t\t\t\t \"location, that is not possible, try manipulating the sub Locations\");\n    }\n    my @locs = $self->sub_Location(1);\n    return $locs[0]->min_start() if @locs; \n    return;\n}\n\n=head2 max_start\n\n  Title   : max_start\n  Usage   : my $maxstart = $location->max_start();\n  Function: Get maximum starting location of feature startpoint  \n  Returns : integer or undef if no maximum starting point.\n  Args    : none\n\n\nsub max_start {\n    my ($self,$value) = @_;\n\n    if( defined $value ) {\n\t$self->throw(\"Trying to set the maximum starting point of a split \".\n\t\t\t\t \"location, that is not possible, try manipulating the sub Locations\");\n    }\n    my @locs = $self->sub_Location(1);\n    return $locs[0]->max_start() if @locs; \n    return;\n}\n\n=head2 start_pos_type\n\n  Title   : start_pos_type\n  Usage   : my $start_pos_type = $location->start_pos_type();\n  Function: Get start position type (ie <,>, ^) \n  Returns : type of position coded as text \n            ('BEFORE', 'AFTER', 'EXACT','WITHIN', 'BETWEEN')\n  Args    : none\n\n\nsub start_pos_type {\n    my ($self,$value) = @_;\n\n    if( defined $value ) {\n\t$self->throw(\"Trying to set the start_pos_type of a split location, \".\n\t\t\t\t \"that is not possible, try manipulating the sub Locations\");\n    }\n    my @locs = $self->sub_Location();\n    return ( @locs ) ? $locs[0]->start_pos_type() : undef;    \n}\n\n=head2 min_end\n\n  Title   : min_end\n  Usage   : my $minend = $location->min_end();\n  Function: Get minimum ending location of feature endpoint \n  Returns : integer or undef if no minimum ending point.\n  Args    : none\n\n\nsub min_end {\n    my ($self,$value) = @_;\n\n    if( defined $value ) {\n\t$self->throw(\"Trying to set the minimum end point of a split location, \".\n\t\t\t\t \"that is not possible, try manipulating the sub Locations\");\n    }\n    # reverse sort locations by largest ending to smallest ending\n    my @locs = $self->sub_Location(-1);\n    return $locs[0]->min_end() if @locs; \n    return;\n}\n\n=head2 max_end\n\n  Title   : max_end\n  Usage   : my $maxend = $location->max_end();\n  Function: Get maximum ending location of feature endpoint \n  Returns : integer or undef if no maximum ending point.\n  Args    : none\n\n\nsub max_end {\n    my ($self,$value) = @_;\n\n    if( defined $value ) {\n\t$self->throw(\"Trying to set the maximum end point of a split location, \".\n\t\t\t\t \"that is not possible, try manipulating the sub Locations\");\n    }\n    # reverse sort locations by largest ending to smallest ending\n    my @locs = $self->sub_Location(-1);\n    return $locs[0]->max_end() if @locs; \n    return;\n}\n\n=head2 end_pos_type\n\n  Title   : end_pos_type\n  Usage   : my $end_pos_type = $location->end_pos_type();\n  Function: Get end position type (ie <,>, ^) \n  Returns : type of position coded as text \n            ('BEFORE', 'AFTER', 'EXACT','WITHIN', 'BETWEEN')\n  Args    : none\n\n\nsub end_pos_type {\n    my ($self,$value) = @_;\n\n    if( defined $value ) {\n\t$self->throw(\"Trying to set end_pos_type of a split location, \".\n\t\t\t\t \"that is not possible, try manipulating the sub Locations\");\n    }\n    my @locs = $self->sub_Location();\n    return ( @locs ) ? $locs[0]->end_pos_type() : undef;    \n}\n\n\n=head2 seq_id\n\n  Title   : seq_id\n  Usage   : my $seqid = $location->seq_id();\n  Function: Get/Set seq_id that location refers to\n\n            We override this here in order to propagate to all sublocations\n            which are not remote (provided this root is not remote either)\n  Returns : seq_id\n  Args    : [optional] seq_id value to set\n\n\n\nsub seq_id {\n    my $self = shift;\n\n    if(@_ && !$self->is_remote()) {\n\tforeach my $subloc ($self->sub_Location(0)) {\n\t    $subloc->seq_id(@_) if !$subloc->is_remote();\n\t}\n    }\n    return $self->SUPER::seq_id(@_);\n}\n\n=head2 coordinate_policy\n\n  Title   : coordinate_policy\n  Usage   : $policy = $location->coordinate_policy();\n            $location->coordinate_policy($mypolicy); # set may not be possible\n  Function: Get the coordinate computing policy employed by this object.\n\n            See Bio::Location::CoordinatePolicyI for documentation about\n            the policy object and its use.\n\n            The interface *does not* require implementing classes to accept\n            setting of a different policy. The implementation provided here\n            does, however, allow to do so.\n\n            Implementors of this interface are expected to initialize every\n            new instance with a CoordinatePolicyI object. The implementation\n            provided here will return a default policy object if none has\n            been set yet. To change this default policy object call this\n            method as a class method with an appropriate argument. Note that\n            in this case only subsequently created Location objects will be\n            affected.\n\n  Returns : A Bio::Location::CoordinatePolicyI implementing object.\n  Args    : On set, a Bio::Location::CoordinatePolicyI implementing object.\n\n=head2 to_FTstring\n\n  Title   : to_FTstring\n  Usage   : my $locstr = $location->to_FTstring()\n  Function: returns the FeatureTable string of this location\n  Returns : string\n  Args    : none","parameters":[{"label":"$self"}]},"line":623,"kind":12,"range":{"start":{"line":623,"character":0},"end":{"line":667,"character":9999}},"definition":"sub","detail":"($self)","children":[{"line":624,"name":"$self","containerName":"to_FTstring","localvar":"my","kind":13,"definition":"my"},{"name":"@strs","containerName":"to_FTstring","localvar":"my","kind":13,"line":625,"definition":"my"},{"line":626,"name":"$strand","localvar":"my","kind":13,"containerName":"to_FTstring","definition":"my"},{"name":"$self","kind":13,"containerName":"to_FTstring","line":626},{"line":626,"kind":12,"containerName":"to_FTstring","name":"strand"},{"localvar":"my","kind":13,"containerName":"to_FTstring","name":"$stype","line":627,"definition":"my"},{"line":627,"kind":13,"containerName":"to_FTstring","name":"$self"},{"line":627,"kind":12,"containerName":"to_FTstring","name":"splittype"},{"line":628,"name":"$guide","localvar":"my","containerName":"to_FTstring","kind":13,"definition":"my"},{"line":628,"kind":13,"containerName":"to_FTstring","name":"$self"},{"name":"guide_strand","kind":12,"containerName":"to_FTstring","line":628},{"kind":13,"containerName":"to_FTstring","name":"$strand","line":630},{"kind":13,"containerName":"to_FTstring","name":"$self","line":631},{"name":"flip_strand","kind":12,"containerName":"to_FTstring","line":631},{"definition":"my","localvar":"my","containerName":"to_FTstring","kind":13,"name":"@locs","line":637},{"line":637,"name":"$stype","kind":13,"containerName":"to_FTstring"},{"line":637,"name":"$guide","containerName":"to_FTstring","kind":13},{"line":637,"containerName":"to_FTstring","kind":13,"name":"$strand"},{"name":"$self","containerName":"to_FTstring","kind":13,"line":638},{"line":638,"name":"sub_Location","containerName":"to_FTstring","kind":12},{"kind":13,"containerName":"to_FTstring","name":"$self","line":638},{"line":638,"name":"sub_Location","containerName":"to_FTstring","kind":12},{"definition":"my","name":"$loc","localvar":"my","containerName":"to_FTstring","kind":13,"line":640},{"containerName":"to_FTstring","kind":13,"name":"@locs","line":640},{"line":641,"name":"$loc","kind":13,"containerName":"to_FTstring"},{"line":641,"name":"verbose","kind":12,"containerName":"to_FTstring"},{"name":"$self","containerName":"to_FTstring","kind":13,"line":641},{"containerName":"to_FTstring","kind":12,"name":"verbose","line":641},{"definition":"my","name":"$str","containerName":"to_FTstring","localvar":"my","kind":13,"line":642},{"name":"$loc","containerName":"to_FTstring","kind":13,"line":642},{"line":642,"name":"to_FTstring","kind":12,"containerName":"to_FTstring"},{"line":646,"kind":13,"containerName":"to_FTstring","name":"$loc"},{"name":"is_remote","containerName":"to_FTstring","kind":12,"line":646},{"line":647,"containerName":"to_FTstring","kind":13,"name":"$self"},{"line":647,"containerName":"to_FTstring","kind":12,"name":"seq_id"},{"name":"$loc","containerName":"to_FTstring","kind":13,"line":647},{"line":647,"name":"seq_id","kind":12,"containerName":"to_FTstring"},{"name":"$loc","kind":13,"containerName":"to_FTstring","line":648},{"kind":12,"containerName":"to_FTstring","name":"seq_id","line":648},{"containerName":"to_FTstring","kind":13,"name":"$self","line":648},{"containerName":"to_FTstring","kind":12,"name":"seq_id","line":648},{"kind":13,"containerName":"to_FTstring","name":"$str","line":649},{"name":"$loc","containerName":"to_FTstring","kind":13,"line":649},{"line":649,"name":"seq_id","containerName":"to_FTstring","kind":12},{"line":649,"name":"$str","containerName":"to_FTstring","kind":13},{"containerName":"to_FTstring","kind":13,"name":"@strs","line":651},{"line":651,"name":"$str","containerName":"to_FTstring","kind":13},{"kind":13,"containerName":"to_FTstring","name":"$self","line":653},{"kind":12,"containerName":"to_FTstring","name":"flip_strand","line":653},{"name":"$strand","containerName":"to_FTstring","kind":13,"line":653},{"localvar":"my","kind":13,"containerName":"to_FTstring","name":"$str","line":654,"definition":"my"},{"line":655,"containerName":"to_FTstring","kind":13,"name":"@strs"},{"line":656,"containerName":"to_FTstring","kind":13,"name":"$str"},{"line":656,"containerName":"to_FTstring","kind":13,"name":"@strs"},{"name":"@strs","containerName":"to_FTstring","kind":13,"line":657},{"name":"$self","containerName":"to_FTstring","kind":13,"line":658},{"kind":12,"containerName":"to_FTstring","name":"warn","line":658},{"line":660,"name":"$str","containerName":"to_FTstring","kind":13},{"line":660,"kind":13,"containerName":"to_FTstring","name":"$self"},{"kind":12,"containerName":"to_FTstring","name":"splittype","line":660},{"containerName":"to_FTstring","kind":13,"name":"@strs","line":660},{"name":"$strand","kind":13,"containerName":"to_FTstring","line":662},{"name":"$str","kind":13,"containerName":"to_FTstring","line":663},{"name":"$str","kind":13,"containerName":"to_FTstring","line":663},{"containerName":"to_FTstring","kind":13,"name":"$str","line":666}],"name":"to_FTstring","containerName":"Bio::Location::Split"}]}