{"version":5,"vars":[{"line":84,"kind":2,"containerName":"","name":"base"},{"definition":"our","name":"@LOCATIONCODESBSANE","containerName":"main::","kind":13,"line":86},{"line":89,"name":"%FUZZYCODES","containerName":"main::","kind":13,"definition":"our"},{"containerName":"main::","kind":13,"name":"%FUZZYPOINTENCODE","line":107,"definition":"our"},{"kind":13,"containerName":"main::","name":"%FUZZYRANGEENCODE","line":118,"definition":"our"},{"signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: Fuzzy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::Fuzzy\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::Fuzzy - Implementation of a Location on a Sequence\nwhich has unclear start and/or end locations\n\n=head1 SYNOPSIS\n\n    use Bio::Location::Fuzzy;\n    my $fuzzylocation = Bio::Location::Fuzzy->new(\n                                                 -start => '<30',\n                                                 -end   => 90,\n                                                 -location_type => '..');\n\n    print \"location string is \", $fuzzylocation->to_FTstring(), \"\\n\";\n    print \"location is of the type \", $fuzzylocation->location_type, \"\\n\";\n\n=head1 DESCRIPTION\n\nThis module contains the necessary methods for representing a\nFuzzy Location, one that does not have clear start and/or end points.\nThis will initially serve to handle features from Genbank/EMBL feature\ntables that are written as 1^100 meaning between bases 1 and 100 or\nE<lt>100..300 meaning it starts somewhere before 100.  Advanced\nimplementations of this interface may be able to handle the necessary\nlogic of overlaps/intersection/contains/union.  It was constructed to\nhandle fuzzy locations that can be represented in Genbank/EMBL and\nSwissprot.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Location::Fuzzy;\nuse strict;\n\nuse base qw(Bio::Location::Atomic Bio::Location::FuzzyLocationI);\n\nour @LOCATIONCODESBSANE = (undef, 'EXACT', 'WITHIN', 'BETWEEN', 'UNCERTAIN',\n            'BEFORE', 'AFTER');\n\nour %FUZZYCODES = ( 'EXACT' => '..', # Position is 'exact\n   # Exact position is unknown, but is within the range specified, ((1.2)..100)\n            'WITHIN' => '.', \n            # 1^2\n            'BETWEEN'    => '^',\n            'IN-BETWEEN' => '^',\n            'UNCERTAIN'  => '?',\n            # <100\n            'BEFORE'  => '<',\n            # >10\n            'AFTER'   => '>');   \n   \n    # The following regular expressions map to fuzzy location types. Every\n    # expression must match the complete encoded point string, and must\n    # contain two groups identifying min and max. Empty matches are automatic.\n    # converted to undef, except for 'EXACT', for which max is set to equal\n    # min.\n    \nour %FUZZYPOINTENCODE = ( \n    '\\>(\\d+)(.{0})' => 'AFTER',\n    '\\<(.{0})(\\d+)' => 'BEFORE',\n    '(\\d+)'         => 'EXACT',\n    '\\?(\\d*)'       => 'UNCERTAIN',\n    '(\\d+)(.{0})\\>' => 'AFTER',\n    '(.{0})(\\d+)\\<' => 'BEFORE',\n    '(\\d+)\\.(\\d+)'  => 'WITHIN',\n    '(\\d+)\\^(\\d+)'  => 'BETWEEN',\n   );\n    \nour %FUZZYRANGEENCODE  = (  '\\.'   => 'WITHIN',\n                            '\\.\\.' => 'EXACT',\n                            '\\^'   => 'IN-BETWEEN' );\n\n=head2 new\n\n Title   : new\n Usage   : my $fuzzyloc = Bio::Location::Fuzzy->new( @args);\n Function:\n Returns : \n Args    : -start    => value for start  (initialize by superclass)\n           -end      => value for end    (initialize by superclass)\n           -strand   => value for strand (initialize by superclass)\n           -location_type => either ('EXACT','WITHIN','IN-BETWEEN',\n                             'UNCERTAIN') OR ( 1,2,3,4)\n           -start_ext=> extension for start - defaults to 0, \n           -start_fuz=  fuzzy code for start can be \n                      ('EXACT','WITHIN','BETWEEN','BEFORE','AFTER',\n                       'UNCERTAIN' ) OR\n                      a value 1 - 5 corresponding to index+1 above\n           -end_ext=> extension for end - defaults to 0, \n           -end_fuz=  fuzzy code for end can be \n                      ('EXACT','WITHIN','BETWEEN','BEFORE','AFTER',\n                       'UNCERTAIN') OR\n                      a value 1 - 5 corresponding to index+1 above","label":"new($class,@args)"},"line":146,"kind":12,"range":{"end":{"character":9999,"line":161},"start":{"character":0,"line":146}},"definition":"sub","detail":"($class,@args)","children":[{"containerName":"new","localvar":"my","kind":13,"name":"$class","line":147,"definition":"my"},{"kind":13,"containerName":"new","name":"@args","line":147},{"name":"$self","localvar":"my","containerName":"new","kind":13,"line":148,"definition":"my"},{"line":148,"kind":13,"containerName":"new","name":"$class"},{"kind":13,"containerName":"new","name":"@args","line":148},{"definition":"my","line":149,"kind":13,"localvar":"my","containerName":"new","name":"$location_type"},{"containerName":"new","kind":13,"name":"$start_ext","line":149},{"name":"$start_fuz","kind":13,"containerName":"new","line":149},{"line":149,"name":"$end_ext","kind":13,"containerName":"new"},{"line":149,"kind":13,"containerName":"new","name":"$end_fuz"},{"line":150,"name":"$self","kind":13,"containerName":"new"},{"kind":12,"containerName":"new","name":"_rearrange","line":150},{"kind":13,"containerName":"new","name":"@args","line":152},{"line":154,"kind":13,"containerName":"new","name":"$location_type"},{"name":"$self","kind":13,"containerName":"new","line":154},{"containerName":"new","kind":12,"name":"location_type","line":154},{"line":154,"containerName":"new","kind":13,"name":"$location_type"},{"name":"$start_ext","containerName":"new","kind":13,"line":155},{"line":155,"name":"$self","containerName":"new","kind":13},{"name":"max_start","containerName":"new","kind":12,"line":155},{"kind":13,"containerName":"new","name":"$self","line":155},{"line":155,"name":"min_start","kind":12,"containerName":"new"},{"containerName":"new","kind":13,"name":"$start_ext","line":155},{"line":156,"name":"$end_ext","containerName":"new","kind":13},{"name":"$self","kind":13,"containerName":"new","line":156},{"line":156,"name":"max_end","containerName":"new","kind":12},{"line":156,"name":"$self","containerName":"new","kind":13},{"line":156,"name":"min_end","kind":12,"containerName":"new"},{"line":156,"containerName":"new","kind":13,"name":"$end_ext"},{"name":"$start_fuz","kind":13,"containerName":"new","line":157},{"name":"$self","kind":13,"containerName":"new","line":157},{"line":157,"name":"start_pos_type","containerName":"new","kind":12},{"kind":13,"containerName":"new","name":"$start_fuz","line":157},{"containerName":"new","kind":13,"name":"$end_fuz","line":158},{"containerName":"new","kind":13,"name":"$self","line":158},{"name":"end_pos_type","kind":12,"containerName":"new","line":158},{"line":158,"name":"$end_fuz","containerName":"new","kind":13},{"kind":13,"containerName":"new","name":"$self","line":160}],"containerName":"main::","name":"new"},{"name":"SUPER","containerName":"new","kind":12,"line":148},{"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Fuzzy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::Fuzzy\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::Fuzzy - Implementation of a Location on a Sequence\nwhich has unclear start and/or end locations\n\n=head1 SYNOPSIS\n\n    use Bio::Location::Fuzzy;\n    my $fuzzylocation = Bio::Location::Fuzzy->new(\n                                                 -start => '<30',\n                                                 -end   => 90,\n                                                 -location_type => '..');\n\n    print \"location string is \", $fuzzylocation->to_FTstring(), \"\\n\";\n    print \"location is of the type \", $fuzzylocation->location_type, \"\\n\";\n\n=head1 DESCRIPTION\n\nThis module contains the necessary methods for representing a\nFuzzy Location, one that does not have clear start and/or end points.\nThis will initially serve to handle features from Genbank/EMBL feature\ntables that are written as 1^100 meaning between bases 1 and 100 or\nE<lt>100..300 meaning it starts somewhere before 100.  Advanced\nimplementations of this interface may be able to handle the necessary\nlogic of overlaps/intersection/contains/union.  It was constructed to\nhandle fuzzy locations that can be represented in Genbank/EMBL and\nSwissprot.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Location::Fuzzy;\nuse strict;\n\nuse base qw(Bio::Location::Atomic Bio::Location::FuzzyLocationI);\n\nour @LOCATIONCODESBSANE = (undef, 'EXACT', 'WITHIN', 'BETWEEN', 'UNCERTAIN',\n            'BEFORE', 'AFTER');\n\nour %FUZZYCODES = ( 'EXACT' => '..', # Position is 'exact\n   # Exact position is unknown, but is within the range specified, ((1.2)..100)\n            'WITHIN' => '.', \n            # 1^2\n            'BETWEEN'    => '^',\n            'IN-BETWEEN' => '^',\n            'UNCERTAIN'  => '?',\n            # <100\n            'BEFORE'  => '<',\n            # >10\n            'AFTER'   => '>');   \n   \n    # The following regular expressions map to fuzzy location types. Every\n    # expression must match the complete encoded point string, and must\n    # contain two groups identifying min and max. Empty matches are automatic.\n    # converted to undef, except for 'EXACT', for which max is set to equal\n    # min.\n    \nour %FUZZYPOINTENCODE = ( \n    '\\>(\\d+)(.{0})' => 'AFTER',\n    '\\<(.{0})(\\d+)' => 'BEFORE',\n    '(\\d+)'         => 'EXACT',\n    '\\?(\\d*)'       => 'UNCERTAIN',\n    '(\\d+)(.{0})\\>' => 'AFTER',\n    '(.{0})(\\d+)\\<' => 'BEFORE',\n    '(\\d+)\\.(\\d+)'  => 'WITHIN',\n    '(\\d+)\\^(\\d+)'  => 'BETWEEN',\n   );\n    \nour %FUZZYRANGEENCODE  = (  '\\.'   => 'WITHIN',\n                            '\\.\\.' => 'EXACT',\n                            '\\^'   => 'IN-BETWEEN' );\n\n=head2 new\n\n Title   : new\n Usage   : my $fuzzyloc = Bio::Location::Fuzzy->new( @args);\n Function:\n Returns : \n Args    : -start    => value for start  (initialize by superclass)\n           -end      => value for end    (initialize by superclass)\n           -strand   => value for strand (initialize by superclass)\n           -location_type => either ('EXACT','WITHIN','IN-BETWEEN',\n                             'UNCERTAIN') OR ( 1,2,3,4)\n           -start_ext=> extension for start - defaults to 0, \n           -start_fuz=  fuzzy code for start can be \n                      ('EXACT','WITHIN','BETWEEN','BEFORE','AFTER',\n                       'UNCERTAIN' ) OR\n                      a value 1 - 5 corresponding to index+1 above\n           -end_ext=> extension for end - defaults to 0, \n           -end_fuz=  fuzzy code for end can be \n                      ('EXACT','WITHIN','BETWEEN','BEFORE','AFTER',\n                       'UNCERTAIN') OR\n                      a value 1 - 5 corresponding to index+1 above\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($location_type, $start_ext, $start_fuz, $end_ext, $end_fuz) = \n        $self->_rearrange([ qw(LOCATION_TYPE START_EXT START_FUZ \n                   END_EXT END_FUZ )\n                ], @args);\n\n    $location_type  && $self->location_type($location_type);\n    $start_ext && $self->max_start($self->min_start + $start_ext);\n    $end_ext   && $self->max_end($self->min_end + $end_ext);\n    $start_fuz && $self->start_pos_type($start_fuz);\n    $end_fuz   && $self->end_pos_type($end_fuz);\n\n    return $self;\n}\n\n=head2 location_type\n\n  Title   : location_type\n  Usage   : my $location_type = $location->location_type();\n  Function: Get location type encoded as text\n  Returns : string ('EXACT', 'WITHIN', 'IN-BETWEEN', 'UNCERTAIN')\n  Args    : none","label":"location_type($self,$value)"},"kind":12,"range":{"end":{"character":9999,"line":199},"start":{"line":173,"character":0}},"line":173,"detail":"($self,$value)","definition":"sub","name":"location_type","containerName":"main::","children":[{"definition":"my","line":174,"localvar":"my","kind":13,"containerName":"location_type","name":"$self"},{"line":174,"containerName":"location_type","kind":13,"name":"$value"},{"line":175,"name":"$value","containerName":"location_type","kind":13},{"line":175,"containerName":"location_type","kind":13,"name":"$self"},{"line":176,"name":"$value","containerName":"location_type","kind":13},{"containerName":"location_type","kind":13,"name":"$value","line":176},{"name":"$FUZZYCODES","kind":13,"containerName":"location_type","line":177},{"name":"$value","containerName":"location_type","kind":13,"line":177},{"name":"$value","kind":13,"containerName":"location_type","line":178},{"line":178,"name":"$value","containerName":"location_type","kind":13},{"line":179,"name":"$value","kind":13,"containerName":"location_type"},{"line":180,"kind":13,"containerName":"location_type","name":"$value"},{"name":"$value","kind":13,"containerName":"location_type","line":181},{"containerName":"location_type","kind":13,"name":"$value","line":182},{"line":183,"name":"$value","containerName":"location_type","kind":13},{"kind":13,"containerName":"location_type","name":"$value","line":184},{"line":185,"name":"$self","kind":13,"containerName":"location_type"},{"line":185,"containerName":"location_type","kind":12,"name":"throw"},{"containerName":"location_type","kind":13,"name":"$self","line":186},{"containerName":"location_type","kind":12,"name":"start","line":186},{"line":186,"kind":13,"containerName":"location_type","name":"$self"},{"containerName":"location_type","kind":12,"name":"end","line":186},{"line":187,"name":"$self","kind":13,"containerName":"location_type"},{"line":187,"kind":12,"containerName":"location_type","name":"start"},{"line":187,"kind":13,"containerName":"location_type","name":"$self"},{"name":"end","kind":12,"containerName":"location_type","line":187},{"line":188,"containerName":"location_type","kind":13,"name":"$self"},{"line":188,"name":"end","containerName":"location_type","kind":12},{"containerName":"location_type","kind":13,"name":"$self","line":188},{"containerName":"location_type","kind":12,"name":"start","line":188},{"line":189,"name":"$value","containerName":"location_type","kind":13},{"containerName":"location_type","kind":13,"name":"$value","line":190},{"line":191,"kind":13,"containerName":"location_type","name":"$value"},{"line":191,"containerName":"location_type","kind":13,"name":"$value"},{"line":192,"kind":13,"containerName":"location_type","name":"$value"},{"line":193,"name":"$self","containerName":"location_type","kind":13},{"containerName":"location_type","kind":12,"name":"throw","line":193},{"line":196,"containerName":"location_type","kind":13,"name":"$self"},{"name":"$value","kind":13,"containerName":"location_type","line":196},{"line":198,"kind":13,"containerName":"location_type","name":"$self"}]},{"name":"start","containerName":"main::","children":[{"line":236,"localvar":"my","kind":13,"containerName":"start","name":"$self","definition":"my"},{"line":236,"containerName":"start","kind":13,"name":"$value"},{"line":237,"kind":13,"containerName":"start","name":"$value"},{"containerName":"start","localvar":"my","kind":13,"name":"$encode","line":238,"definition":"my"},{"name":"$min","kind":13,"containerName":"start","line":238},{"line":238,"name":"$max","kind":13,"containerName":"start"},{"line":238,"name":"$self","kind":13,"containerName":"start"},{"line":238,"name":"_fuzzypointdecode","containerName":"start","kind":12},{"kind":13,"containerName":"start","name":"$value","line":238},{"line":239,"name":"$self","containerName":"start","kind":13},{"line":239,"kind":12,"containerName":"start","name":"start_pos_type"},{"line":239,"name":"$encode","kind":13,"containerName":"start"},{"name":"$self","containerName":"start","kind":13,"line":240},{"containerName":"start","kind":12,"name":"min_start","line":240},{"line":240,"name":"$min","containerName":"start","kind":13},{"line":241,"kind":13,"containerName":"start","name":"$self"},{"name":"max_start","containerName":"start","kind":12,"line":241},{"name":"$max","containerName":"start","kind":13,"line":241},{"line":244,"containerName":"start","kind":13,"name":"$self"},{"line":244,"containerName":"start","kind":12,"name":"throw"},{"name":"$self","containerName":"start","kind":13,"line":245},{"kind":13,"containerName":"start","name":"$self","line":245},{"line":246,"name":"$self","kind":13,"containerName":"start"},{"name":"location_type","containerName":"start","kind":12,"line":246},{"line":246,"kind":13,"containerName":"start","name":"$self"},{"name":"$self","kind":13,"containerName":"start","line":247},{"name":"$self","kind":13,"containerName":"start","line":247},{"line":249,"name":"$self","kind":13,"containerName":"start"}],"detail":"($self,$value)","definition":"sub","range":{"end":{"character":9999,"line":250},"start":{"line":235,"character":0}},"kind":12,"line":235,"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Fuzzy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::Fuzzy\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::Fuzzy - Implementation of a Location on a Sequence\nwhich has unclear start and/or end locations\n\n=head1 SYNOPSIS\n\n    use Bio::Location::Fuzzy;\n    my $fuzzylocation = Bio::Location::Fuzzy->new(\n                                                 -start => '<30',\n                                                 -end   => 90,\n                                                 -location_type => '..');\n\n    print \"location string is \", $fuzzylocation->to_FTstring(), \"\\n\";\n    print \"location is of the type \", $fuzzylocation->location_type, \"\\n\";\n\n=head1 DESCRIPTION\n\nThis module contains the necessary methods for representing a\nFuzzy Location, one that does not have clear start and/or end points.\nThis will initially serve to handle features from Genbank/EMBL feature\ntables that are written as 1^100 meaning between bases 1 and 100 or\nE<lt>100..300 meaning it starts somewhere before 100.  Advanced\nimplementations of this interface may be able to handle the necessary\nlogic of overlaps/intersection/contains/union.  It was constructed to\nhandle fuzzy locations that can be represented in Genbank/EMBL and\nSwissprot.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Location::Fuzzy;\nuse strict;\n\nuse base qw(Bio::Location::Atomic Bio::Location::FuzzyLocationI);\n\nour @LOCATIONCODESBSANE = (undef, 'EXACT', 'WITHIN', 'BETWEEN', 'UNCERTAIN',\n            'BEFORE', 'AFTER');\n\nour %FUZZYCODES = ( 'EXACT' => '..', # Position is 'exact\n   # Exact position is unknown, but is within the range specified, ((1.2)..100)\n            'WITHIN' => '.', \n            # 1^2\n            'BETWEEN'    => '^',\n            'IN-BETWEEN' => '^',\n            'UNCERTAIN'  => '?',\n            # <100\n            'BEFORE'  => '<',\n            # >10\n            'AFTER'   => '>');   \n   \n    # The following regular expressions map to fuzzy location types. Every\n    # expression must match the complete encoded point string, and must\n    # contain two groups identifying min and max. Empty matches are automatic.\n    # converted to undef, except for 'EXACT', for which max is set to equal\n    # min.\n    \nour %FUZZYPOINTENCODE = ( \n    '\\>(\\d+)(.{0})' => 'AFTER',\n    '\\<(.{0})(\\d+)' => 'BEFORE',\n    '(\\d+)'         => 'EXACT',\n    '\\?(\\d*)'       => 'UNCERTAIN',\n    '(\\d+)(.{0})\\>' => 'AFTER',\n    '(.{0})(\\d+)\\<' => 'BEFORE',\n    '(\\d+)\\.(\\d+)'  => 'WITHIN',\n    '(\\d+)\\^(\\d+)'  => 'BETWEEN',\n   );\n    \nour %FUZZYRANGEENCODE  = (  '\\.'   => 'WITHIN',\n                            '\\.\\.' => 'EXACT',\n                            '\\^'   => 'IN-BETWEEN' );\n\n=head2 new\n\n Title   : new\n Usage   : my $fuzzyloc = Bio::Location::Fuzzy->new( @args);\n Function:\n Returns : \n Args    : -start    => value for start  (initialize by superclass)\n           -end      => value for end    (initialize by superclass)\n           -strand   => value for strand (initialize by superclass)\n           -location_type => either ('EXACT','WITHIN','IN-BETWEEN',\n                             'UNCERTAIN') OR ( 1,2,3,4)\n           -start_ext=> extension for start - defaults to 0, \n           -start_fuz=  fuzzy code for start can be \n                      ('EXACT','WITHIN','BETWEEN','BEFORE','AFTER',\n                       'UNCERTAIN' ) OR\n                      a value 1 - 5 corresponding to index+1 above\n           -end_ext=> extension for end - defaults to 0, \n           -end_fuz=  fuzzy code for end can be \n                      ('EXACT','WITHIN','BETWEEN','BEFORE','AFTER',\n                       'UNCERTAIN') OR\n                      a value 1 - 5 corresponding to index+1 above\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($location_type, $start_ext, $start_fuz, $end_ext, $end_fuz) = \n        $self->_rearrange([ qw(LOCATION_TYPE START_EXT START_FUZ \n                   END_EXT END_FUZ )\n                ], @args);\n\n    $location_type  && $self->location_type($location_type);\n    $start_ext && $self->max_start($self->min_start + $start_ext);\n    $end_ext   && $self->max_end($self->min_end + $end_ext);\n    $start_fuz && $self->start_pos_type($start_fuz);\n    $end_fuz   && $self->end_pos_type($end_fuz);\n\n    return $self;\n}\n\n=head2 location_type\n\n  Title   : location_type\n  Usage   : my $location_type = $location->location_type();\n  Function: Get location type encoded as text\n  Returns : string ('EXACT', 'WITHIN', 'IN-BETWEEN', 'UNCERTAIN')\n  Args    : none\n\n\nsub location_type {\n    my ($self,$value) = @_;\n    if( defined $value || ! defined $self->{'_location_type'} ) {\n        $value = 'EXACT' unless defined $value;\n        if(! defined $FUZZYCODES{$value} )  {\n            $value = uc($value);\n            if( $value =~ /\\.\\./ ) {\n                $value = 'EXACT';\n            } elsif( $value =~ /^\\.$/ ) {\n                $value = 'WITHIN';\n            } elsif( $value =~ /\\^/ ) {\n                $value = 'IN-BETWEEN';\n                $self->throw(\"Use Bio::Location::Simple for IN-BETWEEN locations [\".\n                             $self->start. \"] and [\". $self->end. \"]\")\n                  if defined $self->start && defined $self->end &&\n                            ($self->end - 1 == $self->start);\n            } elsif( $value =~ /\\?/ ) {\n                $value = 'UNCERTAIN';\n            } elsif( $value ne 'EXACT' && $value ne 'WITHIN' && \n                        $value ne 'IN-BETWEEN' ) {\n                $self->throw(\"Did not specify a valid location type\");\n            }\n        }\n        $self->{'_location_type'} = $value;\n    }\n    return $self->{'_location_type'};\n}\n\n=head1 LocationI methods\n\n=head2 length\n\n  Title   : length\n  Usage   : $length = $fuzzy_loc->length();\n  Function: Get the length of this location.\n\n            Note that the length of a fuzzy location will always depend\n            on the currently active interpretation of start and end. The\n            result will therefore vary for different CoordinatePolicy objects.\n\n  Returns : an integer\n  Args    : none\n\n\n#sub length {\n#    my($self) = @_;\n#    return $self->SUPER::length() if( !$self->start || !$self->end);\n#    $self->warn('Length is not valid for a FuzzyLocation'); \n#    return 0;\n#}\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $fuzzy->start();\n  Function: get/set start of this range, handling fuzzy_starts\n  Returns : a positive integer representing the start of the location\n  Args    : start location on set (can be fuzzy point string)","label":"start($self,$value)"}},{"containerName":"start","kind":12,"name":"SUPER","line":245},{"line":245,"name":"SUPER","containerName":"end","kind":12},{"name":"SUPER","kind":12,"containerName":"end","line":246},{"name":"SUPER","containerName":"end","kind":12,"line":247},{"line":247,"name":"SUPER","kind":12,"containerName":"start"},{"line":249,"kind":12,"containerName":"start","name":"SUPER"},{"detail":"($self,$value)","definition":"sub","name":"end","containerName":"main::","children":[{"localvar":"my","kind":13,"containerName":"end","name":"$self","line":263,"definition":"my"},{"line":263,"name":"$value","kind":13,"containerName":"end"},{"containerName":"end","kind":13,"name":"$value","line":264},{"kind":13,"localvar":"my","containerName":"end","name":"$encode","line":265,"definition":"my"},{"line":265,"kind":13,"containerName":"end","name":"$min"},{"line":265,"name":"$max","kind":13,"containerName":"end"},{"line":265,"kind":13,"containerName":"end","name":"$self"},{"name":"_fuzzypointdecode","containerName":"end","kind":12,"line":265},{"line":265,"containerName":"end","kind":13,"name":"$value"},{"line":266,"name":"$self","kind":13,"containerName":"end"},{"line":266,"name":"end_pos_type","kind":12,"containerName":"end"},{"name":"$encode","kind":13,"containerName":"end","line":266},{"line":267,"name":"$self","containerName":"end","kind":13},{"kind":12,"containerName":"end","name":"min_end","line":267},{"line":267,"name":"$min","kind":13,"containerName":"end"},{"name":"$self","kind":13,"containerName":"end","line":268},{"line":268,"kind":12,"containerName":"end","name":"max_end"},{"name":"$max","containerName":"end","kind":13,"line":268},{"line":271,"containerName":"end","kind":13,"name":"$self"},{"kind":12,"containerName":"end","name":"throw","line":271},{"line":272,"containerName":"end","kind":13,"name":"$self"},{"line":272,"containerName":"end","kind":13,"name":"$self"},{"line":273,"name":"$self","containerName":"end","kind":13},{"kind":12,"containerName":"end","name":"location_type","line":273},{"line":273,"name":"$self","kind":13,"containerName":"end"},{"kind":13,"containerName":"end","name":"$self","line":274},{"name":"$self","containerName":"end","kind":13,"line":274},{"name":"$self","containerName":"end","kind":13,"line":276}],"signature":{"documentation":"1;\n# $Id: Fuzzy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::Fuzzy\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::Fuzzy - Implementation of a Location on a Sequence\nwhich has unclear start and/or end locations\n\n=head1 SYNOPSIS\n\n    use Bio::Location::Fuzzy;\n    my $fuzzylocation = Bio::Location::Fuzzy->new(\n                                                 -start => '<30',\n                                                 -end   => 90,\n                                                 -location_type => '..');\n\n    print \"location string is \", $fuzzylocation->to_FTstring(), \"\\n\";\n    print \"location is of the type \", $fuzzylocation->location_type, \"\\n\";\n\n=head1 DESCRIPTION\n\nThis module contains the necessary methods for representing a\nFuzzy Location, one that does not have clear start and/or end points.\nThis will initially serve to handle features from Genbank/EMBL feature\ntables that are written as 1^100 meaning between bases 1 and 100 or\nE<lt>100..300 meaning it starts somewhere before 100.  Advanced\nimplementations of this interface may be able to handle the necessary\nlogic of overlaps/intersection/contains/union.  It was constructed to\nhandle fuzzy locations that can be represented in Genbank/EMBL and\nSwissprot.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Location::Fuzzy;\nuse strict;\n\nuse base qw(Bio::Location::Atomic Bio::Location::FuzzyLocationI);\n\nour @LOCATIONCODESBSANE = (undef, 'EXACT', 'WITHIN', 'BETWEEN', 'UNCERTAIN',\n            'BEFORE', 'AFTER');\n\nour %FUZZYCODES = ( 'EXACT' => '..', # Position is 'exact\n   # Exact position is unknown, but is within the range specified, ((1.2)..100)\n            'WITHIN' => '.', \n            # 1^2\n            'BETWEEN'    => '^',\n            'IN-BETWEEN' => '^',\n            'UNCERTAIN'  => '?',\n            # <100\n            'BEFORE'  => '<',\n            # >10\n            'AFTER'   => '>');   \n   \n    # The following regular expressions map to fuzzy location types. Every\n    # expression must match the complete encoded point string, and must\n    # contain two groups identifying min and max. Empty matches are automatic.\n    # converted to undef, except for 'EXACT', for which max is set to equal\n    # min.\n    \nour %FUZZYPOINTENCODE = ( \n    '\\>(\\d+)(.{0})' => 'AFTER',\n    '\\<(.{0})(\\d+)' => 'BEFORE',\n    '(\\d+)'         => 'EXACT',\n    '\\?(\\d*)'       => 'UNCERTAIN',\n    '(\\d+)(.{0})\\>' => 'AFTER',\n    '(.{0})(\\d+)\\<' => 'BEFORE',\n    '(\\d+)\\.(\\d+)'  => 'WITHIN',\n    '(\\d+)\\^(\\d+)'  => 'BETWEEN',\n   );\n    \nour %FUZZYRANGEENCODE  = (  '\\.'   => 'WITHIN',\n                            '\\.\\.' => 'EXACT',\n                            '\\^'   => 'IN-BETWEEN' );\n\n=head2 new\n\n Title   : new\n Usage   : my $fuzzyloc = Bio::Location::Fuzzy->new( @args);\n Function:\n Returns : \n Args    : -start    => value for start  (initialize by superclass)\n           -end      => value for end    (initialize by superclass)\n           -strand   => value for strand (initialize by superclass)\n           -location_type => either ('EXACT','WITHIN','IN-BETWEEN',\n                             'UNCERTAIN') OR ( 1,2,3,4)\n           -start_ext=> extension for start - defaults to 0, \n           -start_fuz=  fuzzy code for start can be \n                      ('EXACT','WITHIN','BETWEEN','BEFORE','AFTER',\n                       'UNCERTAIN' ) OR\n                      a value 1 - 5 corresponding to index+1 above\n           -end_ext=> extension for end - defaults to 0, \n           -end_fuz=  fuzzy code for end can be \n                      ('EXACT','WITHIN','BETWEEN','BEFORE','AFTER',\n                       'UNCERTAIN') OR\n                      a value 1 - 5 corresponding to index+1 above\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($location_type, $start_ext, $start_fuz, $end_ext, $end_fuz) = \n        $self->_rearrange([ qw(LOCATION_TYPE START_EXT START_FUZ \n                   END_EXT END_FUZ )\n                ], @args);\n\n    $location_type  && $self->location_type($location_type);\n    $start_ext && $self->max_start($self->min_start + $start_ext);\n    $end_ext   && $self->max_end($self->min_end + $end_ext);\n    $start_fuz && $self->start_pos_type($start_fuz);\n    $end_fuz   && $self->end_pos_type($end_fuz);\n\n    return $self;\n}\n\n=head2 location_type\n\n  Title   : location_type\n  Usage   : my $location_type = $location->location_type();\n  Function: Get location type encoded as text\n  Returns : string ('EXACT', 'WITHIN', 'IN-BETWEEN', 'UNCERTAIN')\n  Args    : none\n\n\nsub location_type {\n    my ($self,$value) = @_;\n    if( defined $value || ! defined $self->{'_location_type'} ) {\n        $value = 'EXACT' unless defined $value;\n        if(! defined $FUZZYCODES{$value} )  {\n            $value = uc($value);\n            if( $value =~ /\\.\\./ ) {\n                $value = 'EXACT';\n            } elsif( $value =~ /^\\.$/ ) {\n                $value = 'WITHIN';\n            } elsif( $value =~ /\\^/ ) {\n                $value = 'IN-BETWEEN';\n                $self->throw(\"Use Bio::Location::Simple for IN-BETWEEN locations [\".\n                             $self->start. \"] and [\". $self->end. \"]\")\n                  if defined $self->start && defined $self->end &&\n                            ($self->end - 1 == $self->start);\n            } elsif( $value =~ /\\?/ ) {\n                $value = 'UNCERTAIN';\n            } elsif( $value ne 'EXACT' && $value ne 'WITHIN' && \n                        $value ne 'IN-BETWEEN' ) {\n                $self->throw(\"Did not specify a valid location type\");\n            }\n        }\n        $self->{'_location_type'} = $value;\n    }\n    return $self->{'_location_type'};\n}\n\n=head1 LocationI methods\n\n=head2 length\n\n  Title   : length\n  Usage   : $length = $fuzzy_loc->length();\n  Function: Get the length of this location.\n\n            Note that the length of a fuzzy location will always depend\n            on the currently active interpretation of start and end. The\n            result will therefore vary for different CoordinatePolicy objects.\n\n  Returns : an integer\n  Args    : none\n\n\n#sub length {\n#    my($self) = @_;\n#    return $self->SUPER::length() if( !$self->start || !$self->end);\n#    $self->warn('Length is not valid for a FuzzyLocation'); \n#    return 0;\n#}\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $fuzzy->start();\n  Function: get/set start of this range, handling fuzzy_starts\n  Returns : a positive integer representing the start of the location\n  Args    : start location on set (can be fuzzy point string)\n\n\nsub start {\n    my($self,$value) = @_;\n    if( defined $value ) {\n    my ($encode,$min,$max) = $self->_fuzzypointdecode($value);\n    $self->start_pos_type($encode);\n    $self->min_start($min);\n    $self->max_start($max);\n    }\n\n    $self->throw(\"Use Bio::Location::Simple for IN-BETWEEN locations [\"\n                 . $self->SUPER::start. \"] and [\". $self->SUPER::end. \"]\")\n    if $self->location_type eq 'IN-BETWEEN'  && defined $self->SUPER::end &&\n                  ($self->SUPER::end - 1 == $self->SUPER::start);\n\n    return $self->SUPER::start();\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $fuzzy->end();\n  Function: get/set end of this range, handling fuzzy_ends\n  Returns : a positive integer representing the end of the range\n  Args    : end location on set (can be fuzzy string)","parameters":[{"label":"$self"},{"label":"$value"}],"label":"end($self,$value)"},"kind":12,"range":{"end":{"line":277,"character":9999},"start":{"character":0,"line":262}},"line":262},{"line":272,"containerName":"start","kind":12,"name":"SUPER"},{"kind":12,"containerName":"end","name":"SUPER","line":272},{"kind":12,"containerName":"start","name":"SUPER","line":273},{"kind":12,"containerName":"end","name":"SUPER","line":274},{"line":274,"kind":12,"containerName":"start","name":"SUPER"},{"line":276,"name":"SUPER","containerName":"end","kind":12},{"definition":"sub","detail":"($self,@args)","children":[{"definition":"my","localvar":"my","containerName":"min_start","kind":13,"name":"$self","line":290},{"kind":13,"containerName":"min_start","name":"@args","line":290},{"name":"@args","containerName":"min_start","kind":13,"line":292},{"kind":13,"containerName":"min_start","name":"$self","line":293},{"line":293,"containerName":"min_start","kind":13,"name":"$args"},{"line":295,"name":"$self","kind":13,"containerName":"min_start"}],"containerName":"main::","name":"min_start","signature":{"label":"min_start($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: Fuzzy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::Fuzzy\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::Fuzzy - Implementation of a Location on a Sequence\nwhich has unclear start and/or end locations\n\n=head1 SYNOPSIS\n\n    use Bio::Location::Fuzzy;\n    my $fuzzylocation = Bio::Location::Fuzzy->new(\n                                                 -start => '<30',\n                                                 -end   => 90,\n                                                 -location_type => '..');\n\n    print \"location string is \", $fuzzylocation->to_FTstring(), \"\\n\";\n    print \"location is of the type \", $fuzzylocation->location_type, \"\\n\";\n\n=head1 DESCRIPTION\n\nThis module contains the necessary methods for representing a\nFuzzy Location, one that does not have clear start and/or end points.\nThis will initially serve to handle features from Genbank/EMBL feature\ntables that are written as 1^100 meaning between bases 1 and 100 or\nE<lt>100..300 meaning it starts somewhere before 100.  Advanced\nimplementations of this interface may be able to handle the necessary\nlogic of overlaps/intersection/contains/union.  It was constructed to\nhandle fuzzy locations that can be represented in Genbank/EMBL and\nSwissprot.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Location::Fuzzy;\nuse strict;\n\nuse base qw(Bio::Location::Atomic Bio::Location::FuzzyLocationI);\n\nour @LOCATIONCODESBSANE = (undef, 'EXACT', 'WITHIN', 'BETWEEN', 'UNCERTAIN',\n            'BEFORE', 'AFTER');\n\nour %FUZZYCODES = ( 'EXACT' => '..', # Position is 'exact\n   # Exact position is unknown, but is within the range specified, ((1.2)..100)\n            'WITHIN' => '.', \n            # 1^2\n            'BETWEEN'    => '^',\n            'IN-BETWEEN' => '^',\n            'UNCERTAIN'  => '?',\n            # <100\n            'BEFORE'  => '<',\n            # >10\n            'AFTER'   => '>');   \n   \n    # The following regular expressions map to fuzzy location types. Every\n    # expression must match the complete encoded point string, and must\n    # contain two groups identifying min and max. Empty matches are automatic.\n    # converted to undef, except for 'EXACT', for which max is set to equal\n    # min.\n    \nour %FUZZYPOINTENCODE = ( \n    '\\>(\\d+)(.{0})' => 'AFTER',\n    '\\<(.{0})(\\d+)' => 'BEFORE',\n    '(\\d+)'         => 'EXACT',\n    '\\?(\\d*)'       => 'UNCERTAIN',\n    '(\\d+)(.{0})\\>' => 'AFTER',\n    '(.{0})(\\d+)\\<' => 'BEFORE',\n    '(\\d+)\\.(\\d+)'  => 'WITHIN',\n    '(\\d+)\\^(\\d+)'  => 'BETWEEN',\n   );\n    \nour %FUZZYRANGEENCODE  = (  '\\.'   => 'WITHIN',\n                            '\\.\\.' => 'EXACT',\n                            '\\^'   => 'IN-BETWEEN' );\n\n=head2 new\n\n Title   : new\n Usage   : my $fuzzyloc = Bio::Location::Fuzzy->new( @args);\n Function:\n Returns : \n Args    : -start    => value for start  (initialize by superclass)\n           -end      => value for end    (initialize by superclass)\n           -strand   => value for strand (initialize by superclass)\n           -location_type => either ('EXACT','WITHIN','IN-BETWEEN',\n                             'UNCERTAIN') OR ( 1,2,3,4)\n           -start_ext=> extension for start - defaults to 0, \n           -start_fuz=  fuzzy code for start can be \n                      ('EXACT','WITHIN','BETWEEN','BEFORE','AFTER',\n                       'UNCERTAIN' ) OR\n                      a value 1 - 5 corresponding to index+1 above\n           -end_ext=> extension for end - defaults to 0, \n           -end_fuz=  fuzzy code for end can be \n                      ('EXACT','WITHIN','BETWEEN','BEFORE','AFTER',\n                       'UNCERTAIN') OR\n                      a value 1 - 5 corresponding to index+1 above\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($location_type, $start_ext, $start_fuz, $end_ext, $end_fuz) = \n        $self->_rearrange([ qw(LOCATION_TYPE START_EXT START_FUZ \n                   END_EXT END_FUZ )\n                ], @args);\n\n    $location_type  && $self->location_type($location_type);\n    $start_ext && $self->max_start($self->min_start + $start_ext);\n    $end_ext   && $self->max_end($self->min_end + $end_ext);\n    $start_fuz && $self->start_pos_type($start_fuz);\n    $end_fuz   && $self->end_pos_type($end_fuz);\n\n    return $self;\n}\n\n=head2 location_type\n\n  Title   : location_type\n  Usage   : my $location_type = $location->location_type();\n  Function: Get location type encoded as text\n  Returns : string ('EXACT', 'WITHIN', 'IN-BETWEEN', 'UNCERTAIN')\n  Args    : none\n\n\nsub location_type {\n    my ($self,$value) = @_;\n    if( defined $value || ! defined $self->{'_location_type'} ) {\n        $value = 'EXACT' unless defined $value;\n        if(! defined $FUZZYCODES{$value} )  {\n            $value = uc($value);\n            if( $value =~ /\\.\\./ ) {\n                $value = 'EXACT';\n            } elsif( $value =~ /^\\.$/ ) {\n                $value = 'WITHIN';\n            } elsif( $value =~ /\\^/ ) {\n                $value = 'IN-BETWEEN';\n                $self->throw(\"Use Bio::Location::Simple for IN-BETWEEN locations [\".\n                             $self->start. \"] and [\". $self->end. \"]\")\n                  if defined $self->start && defined $self->end &&\n                            ($self->end - 1 == $self->start);\n            } elsif( $value =~ /\\?/ ) {\n                $value = 'UNCERTAIN';\n            } elsif( $value ne 'EXACT' && $value ne 'WITHIN' && \n                        $value ne 'IN-BETWEEN' ) {\n                $self->throw(\"Did not specify a valid location type\");\n            }\n        }\n        $self->{'_location_type'} = $value;\n    }\n    return $self->{'_location_type'};\n}\n\n=head1 LocationI methods\n\n=head2 length\n\n  Title   : length\n  Usage   : $length = $fuzzy_loc->length();\n  Function: Get the length of this location.\n\n            Note that the length of a fuzzy location will always depend\n            on the currently active interpretation of start and end. The\n            result will therefore vary for different CoordinatePolicy objects.\n\n  Returns : an integer\n  Args    : none\n\n\n#sub length {\n#    my($self) = @_;\n#    return $self->SUPER::length() if( !$self->start || !$self->end);\n#    $self->warn('Length is not valid for a FuzzyLocation'); \n#    return 0;\n#}\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $fuzzy->start();\n  Function: get/set start of this range, handling fuzzy_starts\n  Returns : a positive integer representing the start of the location\n  Args    : start location on set (can be fuzzy point string)\n\n\nsub start {\n    my($self,$value) = @_;\n    if( defined $value ) {\n    my ($encode,$min,$max) = $self->_fuzzypointdecode($value);\n    $self->start_pos_type($encode);\n    $self->min_start($min);\n    $self->max_start($max);\n    }\n\n    $self->throw(\"Use Bio::Location::Simple for IN-BETWEEN locations [\"\n                 . $self->SUPER::start. \"] and [\". $self->SUPER::end. \"]\")\n    if $self->location_type eq 'IN-BETWEEN'  && defined $self->SUPER::end &&\n                  ($self->SUPER::end - 1 == $self->SUPER::start);\n\n    return $self->SUPER::start();\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $fuzzy->end();\n  Function: get/set end of this range, handling fuzzy_ends\n  Returns : a positive integer representing the end of the range\n  Args    : end location on set (can be fuzzy string)\n\n\nsub end {\n    my($self,$value) = @_;\n    if( defined $value ) {\n    my ($encode,$min,$max) = $self->_fuzzypointdecode($value);\n    $self->end_pos_type($encode);\n    $self->min_end($min);\n    $self->max_end($max);\n    }\n\n    $self->throw(\"Use Bio::Location::Simple for IN-BETWEEN locations [\".\n                 $self->SUPER::start. \"] and [\". $self->SUPER::end. \"]\")\n    if $self->location_type eq 'IN-BETWEEN' && defined $self->SUPER::start &&\n                ($self->SUPER::end - 1 == $self->SUPER::start);\n\n    return $self->SUPER::end();\n}\n\n=head2 min_start\n\n  Title   : min_start\n  Usage   : $min_start = $fuzzy->min_start();\n  Function: get/set the minimum starting point\n  Returns : the minimum starting point from the contained sublocations\n  Args    : integer or undef on set"},"line":289,"range":{"start":{"character":0,"line":289},"end":{"character":9999,"line":296}},"kind":12},{"range":{"start":{"line":308,"character":0},"end":{"character":9999,"line":315}},"kind":12,"line":308,"signature":{"label":"max_start($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: Fuzzy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::Fuzzy\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::Fuzzy - Implementation of a Location on a Sequence\nwhich has unclear start and/or end locations\n\n=head1 SYNOPSIS\n\n    use Bio::Location::Fuzzy;\n    my $fuzzylocation = Bio::Location::Fuzzy->new(\n                                                 -start => '<30',\n                                                 -end   => 90,\n                                                 -location_type => '..');\n\n    print \"location string is \", $fuzzylocation->to_FTstring(), \"\\n\";\n    print \"location is of the type \", $fuzzylocation->location_type, \"\\n\";\n\n=head1 DESCRIPTION\n\nThis module contains the necessary methods for representing a\nFuzzy Location, one that does not have clear start and/or end points.\nThis will initially serve to handle features from Genbank/EMBL feature\ntables that are written as 1^100 meaning between bases 1 and 100 or\nE<lt>100..300 meaning it starts somewhere before 100.  Advanced\nimplementations of this interface may be able to handle the necessary\nlogic of overlaps/intersection/contains/union.  It was constructed to\nhandle fuzzy locations that can be represented in Genbank/EMBL and\nSwissprot.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Location::Fuzzy;\nuse strict;\n\nuse base qw(Bio::Location::Atomic Bio::Location::FuzzyLocationI);\n\nour @LOCATIONCODESBSANE = (undef, 'EXACT', 'WITHIN', 'BETWEEN', 'UNCERTAIN',\n            'BEFORE', 'AFTER');\n\nour %FUZZYCODES = ( 'EXACT' => '..', # Position is 'exact\n   # Exact position is unknown, but is within the range specified, ((1.2)..100)\n            'WITHIN' => '.', \n            # 1^2\n            'BETWEEN'    => '^',\n            'IN-BETWEEN' => '^',\n            'UNCERTAIN'  => '?',\n            # <100\n            'BEFORE'  => '<',\n            # >10\n            'AFTER'   => '>');   \n   \n    # The following regular expressions map to fuzzy location types. Every\n    # expression must match the complete encoded point string, and must\n    # contain two groups identifying min and max. Empty matches are automatic.\n    # converted to undef, except for 'EXACT', for which max is set to equal\n    # min.\n    \nour %FUZZYPOINTENCODE = ( \n    '\\>(\\d+)(.{0})' => 'AFTER',\n    '\\<(.{0})(\\d+)' => 'BEFORE',\n    '(\\d+)'         => 'EXACT',\n    '\\?(\\d*)'       => 'UNCERTAIN',\n    '(\\d+)(.{0})\\>' => 'AFTER',\n    '(.{0})(\\d+)\\<' => 'BEFORE',\n    '(\\d+)\\.(\\d+)'  => 'WITHIN',\n    '(\\d+)\\^(\\d+)'  => 'BETWEEN',\n   );\n    \nour %FUZZYRANGEENCODE  = (  '\\.'   => 'WITHIN',\n                            '\\.\\.' => 'EXACT',\n                            '\\^'   => 'IN-BETWEEN' );\n\n=head2 new\n\n Title   : new\n Usage   : my $fuzzyloc = Bio::Location::Fuzzy->new( @args);\n Function:\n Returns : \n Args    : -start    => value for start  (initialize by superclass)\n           -end      => value for end    (initialize by superclass)\n           -strand   => value for strand (initialize by superclass)\n           -location_type => either ('EXACT','WITHIN','IN-BETWEEN',\n                             'UNCERTAIN') OR ( 1,2,3,4)\n           -start_ext=> extension for start - defaults to 0, \n           -start_fuz=  fuzzy code for start can be \n                      ('EXACT','WITHIN','BETWEEN','BEFORE','AFTER',\n                       'UNCERTAIN' ) OR\n                      a value 1 - 5 corresponding to index+1 above\n           -end_ext=> extension for end - defaults to 0, \n           -end_fuz=  fuzzy code for end can be \n                      ('EXACT','WITHIN','BETWEEN','BEFORE','AFTER',\n                       'UNCERTAIN') OR\n                      a value 1 - 5 corresponding to index+1 above\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($location_type, $start_ext, $start_fuz, $end_ext, $end_fuz) = \n        $self->_rearrange([ qw(LOCATION_TYPE START_EXT START_FUZ \n                   END_EXT END_FUZ )\n                ], @args);\n\n    $location_type  && $self->location_type($location_type);\n    $start_ext && $self->max_start($self->min_start + $start_ext);\n    $end_ext   && $self->max_end($self->min_end + $end_ext);\n    $start_fuz && $self->start_pos_type($start_fuz);\n    $end_fuz   && $self->end_pos_type($end_fuz);\n\n    return $self;\n}\n\n=head2 location_type\n\n  Title   : location_type\n  Usage   : my $location_type = $location->location_type();\n  Function: Get location type encoded as text\n  Returns : string ('EXACT', 'WITHIN', 'IN-BETWEEN', 'UNCERTAIN')\n  Args    : none\n\n\nsub location_type {\n    my ($self,$value) = @_;\n    if( defined $value || ! defined $self->{'_location_type'} ) {\n        $value = 'EXACT' unless defined $value;\n        if(! defined $FUZZYCODES{$value} )  {\n            $value = uc($value);\n            if( $value =~ /\\.\\./ ) {\n                $value = 'EXACT';\n            } elsif( $value =~ /^\\.$/ ) {\n                $value = 'WITHIN';\n            } elsif( $value =~ /\\^/ ) {\n                $value = 'IN-BETWEEN';\n                $self->throw(\"Use Bio::Location::Simple for IN-BETWEEN locations [\".\n                             $self->start. \"] and [\". $self->end. \"]\")\n                  if defined $self->start && defined $self->end &&\n                            ($self->end - 1 == $self->start);\n            } elsif( $value =~ /\\?/ ) {\n                $value = 'UNCERTAIN';\n            } elsif( $value ne 'EXACT' && $value ne 'WITHIN' && \n                        $value ne 'IN-BETWEEN' ) {\n                $self->throw(\"Did not specify a valid location type\");\n            }\n        }\n        $self->{'_location_type'} = $value;\n    }\n    return $self->{'_location_type'};\n}\n\n=head1 LocationI methods\n\n=head2 length\n\n  Title   : length\n  Usage   : $length = $fuzzy_loc->length();\n  Function: Get the length of this location.\n\n            Note that the length of a fuzzy location will always depend\n            on the currently active interpretation of start and end. The\n            result will therefore vary for different CoordinatePolicy objects.\n\n  Returns : an integer\n  Args    : none\n\n\n#sub length {\n#    my($self) = @_;\n#    return $self->SUPER::length() if( !$self->start || !$self->end);\n#    $self->warn('Length is not valid for a FuzzyLocation'); \n#    return 0;\n#}\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $fuzzy->start();\n  Function: get/set start of this range, handling fuzzy_starts\n  Returns : a positive integer representing the start of the location\n  Args    : start location on set (can be fuzzy point string)\n\n\nsub start {\n    my($self,$value) = @_;\n    if( defined $value ) {\n    my ($encode,$min,$max) = $self->_fuzzypointdecode($value);\n    $self->start_pos_type($encode);\n    $self->min_start($min);\n    $self->max_start($max);\n    }\n\n    $self->throw(\"Use Bio::Location::Simple for IN-BETWEEN locations [\"\n                 . $self->SUPER::start. \"] and [\". $self->SUPER::end. \"]\")\n    if $self->location_type eq 'IN-BETWEEN'  && defined $self->SUPER::end &&\n                  ($self->SUPER::end - 1 == $self->SUPER::start);\n\n    return $self->SUPER::start();\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $fuzzy->end();\n  Function: get/set end of this range, handling fuzzy_ends\n  Returns : a positive integer representing the end of the range\n  Args    : end location on set (can be fuzzy string)\n\n\nsub end {\n    my($self,$value) = @_;\n    if( defined $value ) {\n    my ($encode,$min,$max) = $self->_fuzzypointdecode($value);\n    $self->end_pos_type($encode);\n    $self->min_end($min);\n    $self->max_end($max);\n    }\n\n    $self->throw(\"Use Bio::Location::Simple for IN-BETWEEN locations [\".\n                 $self->SUPER::start. \"] and [\". $self->SUPER::end. \"]\")\n    if $self->location_type eq 'IN-BETWEEN' && defined $self->SUPER::start &&\n                ($self->SUPER::end - 1 == $self->SUPER::start);\n\n    return $self->SUPER::end();\n}\n\n=head2 min_start\n\n  Title   : min_start\n  Usage   : $min_start = $fuzzy->min_start();\n  Function: get/set the minimum starting point\n  Returns : the minimum starting point from the contained sublocations\n  Args    : integer or undef on set\n\n\nsub min_start {\n    my ($self,@args) = @_;\n\n    if(@args) {\n    $self->{'_min_start'} = $args[0]; # the value may be undef!\n    }\n    return $self->{'_min_start'};\n}\n\n=head2 max_start\n\n  Title   : max_start\n  Usage   : my $maxstart = $location->max_start();\n  Function: Get/set maximum starting location of feature startpoint  \n  Returns : integer or undef if no maximum starting point.\n  Args    : integer or undef on set"},"name":"max_start","containerName":"main::","children":[{"definition":"my","line":309,"kind":13,"localvar":"my","containerName":"max_start","name":"$self"},{"kind":13,"containerName":"max_start","name":"@args","line":309},{"line":311,"kind":13,"containerName":"max_start","name":"@args"},{"kind":13,"containerName":"max_start","name":"$self","line":312},{"line":312,"kind":13,"containerName":"max_start","name":"$args"},{"name":"$self","containerName":"max_start","kind":13,"line":314}],"detail":"($self,@args)","definition":"sub"},{"signature":{"label":"start_pos_type($self,$value)","documentation":"1;\n# $Id: Fuzzy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::Fuzzy\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::Fuzzy - Implementation of a Location on a Sequence\nwhich has unclear start and/or end locations\n\n=head1 SYNOPSIS\n\n    use Bio::Location::Fuzzy;\n    my $fuzzylocation = Bio::Location::Fuzzy->new(\n                                                 -start => '<30',\n                                                 -end   => 90,\n                                                 -location_type => '..');\n\n    print \"location string is \", $fuzzylocation->to_FTstring(), \"\\n\";\n    print \"location is of the type \", $fuzzylocation->location_type, \"\\n\";\n\n=head1 DESCRIPTION\n\nThis module contains the necessary methods for representing a\nFuzzy Location, one that does not have clear start and/or end points.\nThis will initially serve to handle features from Genbank/EMBL feature\ntables that are written as 1^100 meaning between bases 1 and 100 or\nE<lt>100..300 meaning it starts somewhere before 100.  Advanced\nimplementations of this interface may be able to handle the necessary\nlogic of overlaps/intersection/contains/union.  It was constructed to\nhandle fuzzy locations that can be represented in Genbank/EMBL and\nSwissprot.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Location::Fuzzy;\nuse strict;\n\nuse base qw(Bio::Location::Atomic Bio::Location::FuzzyLocationI);\n\nour @LOCATIONCODESBSANE = (undef, 'EXACT', 'WITHIN', 'BETWEEN', 'UNCERTAIN',\n            'BEFORE', 'AFTER');\n\nour %FUZZYCODES = ( 'EXACT' => '..', # Position is 'exact\n   # Exact position is unknown, but is within the range specified, ((1.2)..100)\n            'WITHIN' => '.', \n            # 1^2\n            'BETWEEN'    => '^',\n            'IN-BETWEEN' => '^',\n            'UNCERTAIN'  => '?',\n            # <100\n            'BEFORE'  => '<',\n            # >10\n            'AFTER'   => '>');   \n   \n    # The following regular expressions map to fuzzy location types. Every\n    # expression must match the complete encoded point string, and must\n    # contain two groups identifying min and max. Empty matches are automatic.\n    # converted to undef, except for 'EXACT', for which max is set to equal\n    # min.\n    \nour %FUZZYPOINTENCODE = ( \n    '\\>(\\d+)(.{0})' => 'AFTER',\n    '\\<(.{0})(\\d+)' => 'BEFORE',\n    '(\\d+)'         => 'EXACT',\n    '\\?(\\d*)'       => 'UNCERTAIN',\n    '(\\d+)(.{0})\\>' => 'AFTER',\n    '(.{0})(\\d+)\\<' => 'BEFORE',\n    '(\\d+)\\.(\\d+)'  => 'WITHIN',\n    '(\\d+)\\^(\\d+)'  => 'BETWEEN',\n   );\n    \nour %FUZZYRANGEENCODE  = (  '\\.'   => 'WITHIN',\n                            '\\.\\.' => 'EXACT',\n                            '\\^'   => 'IN-BETWEEN' );\n\n=head2 new\n\n Title   : new\n Usage   : my $fuzzyloc = Bio::Location::Fuzzy->new( @args);\n Function:\n Returns : \n Args    : -start    => value for start  (initialize by superclass)\n           -end      => value for end    (initialize by superclass)\n           -strand   => value for strand (initialize by superclass)\n           -location_type => either ('EXACT','WITHIN','IN-BETWEEN',\n                             'UNCERTAIN') OR ( 1,2,3,4)\n           -start_ext=> extension for start - defaults to 0, \n           -start_fuz=  fuzzy code for start can be \n                      ('EXACT','WITHIN','BETWEEN','BEFORE','AFTER',\n                       'UNCERTAIN' ) OR\n                      a value 1 - 5 corresponding to index+1 above\n           -end_ext=> extension for end - defaults to 0, \n           -end_fuz=  fuzzy code for end can be \n                      ('EXACT','WITHIN','BETWEEN','BEFORE','AFTER',\n                       'UNCERTAIN') OR\n                      a value 1 - 5 corresponding to index+1 above\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($location_type, $start_ext, $start_fuz, $end_ext, $end_fuz) = \n        $self->_rearrange([ qw(LOCATION_TYPE START_EXT START_FUZ \n                   END_EXT END_FUZ )\n                ], @args);\n\n    $location_type  && $self->location_type($location_type);\n    $start_ext && $self->max_start($self->min_start + $start_ext);\n    $end_ext   && $self->max_end($self->min_end + $end_ext);\n    $start_fuz && $self->start_pos_type($start_fuz);\n    $end_fuz   && $self->end_pos_type($end_fuz);\n\n    return $self;\n}\n\n=head2 location_type\n\n  Title   : location_type\n  Usage   : my $location_type = $location->location_type();\n  Function: Get location type encoded as text\n  Returns : string ('EXACT', 'WITHIN', 'IN-BETWEEN', 'UNCERTAIN')\n  Args    : none\n\n\nsub location_type {\n    my ($self,$value) = @_;\n    if( defined $value || ! defined $self->{'_location_type'} ) {\n        $value = 'EXACT' unless defined $value;\n        if(! defined $FUZZYCODES{$value} )  {\n            $value = uc($value);\n            if( $value =~ /\\.\\./ ) {\n                $value = 'EXACT';\n            } elsif( $value =~ /^\\.$/ ) {\n                $value = 'WITHIN';\n            } elsif( $value =~ /\\^/ ) {\n                $value = 'IN-BETWEEN';\n                $self->throw(\"Use Bio::Location::Simple for IN-BETWEEN locations [\".\n                             $self->start. \"] and [\". $self->end. \"]\")\n                  if defined $self->start && defined $self->end &&\n                            ($self->end - 1 == $self->start);\n            } elsif( $value =~ /\\?/ ) {\n                $value = 'UNCERTAIN';\n            } elsif( $value ne 'EXACT' && $value ne 'WITHIN' && \n                        $value ne 'IN-BETWEEN' ) {\n                $self->throw(\"Did not specify a valid location type\");\n            }\n        }\n        $self->{'_location_type'} = $value;\n    }\n    return $self->{'_location_type'};\n}\n\n=head1 LocationI methods\n\n=head2 length\n\n  Title   : length\n  Usage   : $length = $fuzzy_loc->length();\n  Function: Get the length of this location.\n\n            Note that the length of a fuzzy location will always depend\n            on the currently active interpretation of start and end. The\n            result will therefore vary for different CoordinatePolicy objects.\n\n  Returns : an integer\n  Args    : none\n\n\n#sub length {\n#    my($self) = @_;\n#    return $self->SUPER::length() if( !$self->start || !$self->end);\n#    $self->warn('Length is not valid for a FuzzyLocation'); \n#    return 0;\n#}\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $fuzzy->start();\n  Function: get/set start of this range, handling fuzzy_starts\n  Returns : a positive integer representing the start of the location\n  Args    : start location on set (can be fuzzy point string)\n\n\nsub start {\n    my($self,$value) = @_;\n    if( defined $value ) {\n    my ($encode,$min,$max) = $self->_fuzzypointdecode($value);\n    $self->start_pos_type($encode);\n    $self->min_start($min);\n    $self->max_start($max);\n    }\n\n    $self->throw(\"Use Bio::Location::Simple for IN-BETWEEN locations [\"\n                 . $self->SUPER::start. \"] and [\". $self->SUPER::end. \"]\")\n    if $self->location_type eq 'IN-BETWEEN'  && defined $self->SUPER::end &&\n                  ($self->SUPER::end - 1 == $self->SUPER::start);\n\n    return $self->SUPER::start();\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $fuzzy->end();\n  Function: get/set end of this range, handling fuzzy_ends\n  Returns : a positive integer representing the end of the range\n  Args    : end location on set (can be fuzzy string)\n\n\nsub end {\n    my($self,$value) = @_;\n    if( defined $value ) {\n    my ($encode,$min,$max) = $self->_fuzzypointdecode($value);\n    $self->end_pos_type($encode);\n    $self->min_end($min);\n    $self->max_end($max);\n    }\n\n    $self->throw(\"Use Bio::Location::Simple for IN-BETWEEN locations [\".\n                 $self->SUPER::start. \"] and [\". $self->SUPER::end. \"]\")\n    if $self->location_type eq 'IN-BETWEEN' && defined $self->SUPER::start &&\n                ($self->SUPER::end - 1 == $self->SUPER::start);\n\n    return $self->SUPER::end();\n}\n\n=head2 min_start\n\n  Title   : min_start\n  Usage   : $min_start = $fuzzy->min_start();\n  Function: get/set the minimum starting point\n  Returns : the minimum starting point from the contained sublocations\n  Args    : integer or undef on set\n\n\nsub min_start {\n    my ($self,@args) = @_;\n\n    if(@args) {\n    $self->{'_min_start'} = $args[0]; # the value may be undef!\n    }\n    return $self->{'_min_start'};\n}\n\n=head2 max_start\n\n  Title   : max_start\n  Usage   : my $maxstart = $location->max_start();\n  Function: Get/set maximum starting location of feature startpoint  \n  Returns : integer or undef if no maximum starting point.\n  Args    : integer or undef on set\n\n\nsub max_start {\n    my ($self,@args) = @_;\n\n    if(@args) {\n        $self->{'_max_start'} = $args[0]; # the value may be undef!\n    }\n    return $self->{'_max_start'};\n}\n\n=head2 start_pos_type\n\n  Title   : start_pos_type\n  Usage   : my $start_pos_type = $location->start_pos_type();\n  Function: Get/set start position type.\n  Returns : type of position coded as text \n            ('BEFORE','AFTER','EXACT','WITHIN','BETWEEN','UNCERTAIN')\n  Args    : a string on set","parameters":[{"label":"$self"},{"label":"$value"}]},"range":{"end":{"character":9999,"line":346},"start":{"line":328,"character":0}},"kind":12,"line":328,"detail":"($self,$value)","definition":"sub","containerName":"main::","name":"start_pos_type","children":[{"line":329,"name":"$self","localvar":"my","kind":13,"containerName":"start_pos_type","definition":"my"},{"line":329,"name":"$value","kind":13,"containerName":"start_pos_type"},{"name":"$value","kind":13,"containerName":"start_pos_type","line":330},{"line":330,"kind":13,"containerName":"start_pos_type","name":"$value"},{"line":331,"name":"$value","containerName":"start_pos_type","kind":13},{"line":331,"name":"$value","kind":13,"containerName":"start_pos_type"},{"line":333,"name":"$v","localvar":"my","kind":13,"containerName":"start_pos_type","definition":"my"},{"line":333,"kind":13,"containerName":"start_pos_type","name":"$LOCATIONCODESBSANE"},{"name":"$value","kind":13,"containerName":"start_pos_type","line":333},{"name":"$v","containerName":"start_pos_type","kind":13,"line":334},{"line":335,"containerName":"start_pos_type","kind":13,"name":"$self"},{"line":335,"kind":12,"containerName":"start_pos_type","name":"warn"},{"containerName":"start_pos_type","kind":13,"name":"$v","line":337},{"name":"$value","containerName":"start_pos_type","kind":13,"line":339},{"line":339,"containerName":"start_pos_type","kind":13,"name":"$v"},{"name":"$value","containerName":"start_pos_type","kind":13,"line":342},{"line":343,"kind":13,"containerName":"start_pos_type","name":"$self"},{"line":343,"containerName":"start_pos_type","kind":13,"name":"$value"},{"line":345,"name":"$self","kind":13,"containerName":"start_pos_type"}]},{"signature":{"documentation":"1;\n# $Id: Fuzzy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::Fuzzy\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::Fuzzy - Implementation of a Location on a Sequence\nwhich has unclear start and/or end locations\n\n=head1 SYNOPSIS\n\n    use Bio::Location::Fuzzy;\n    my $fuzzylocation = Bio::Location::Fuzzy->new(\n                                                 -start => '<30',\n                                                 -end   => 90,\n                                                 -location_type => '..');\n\n    print \"location string is \", $fuzzylocation->to_FTstring(), \"\\n\";\n    print \"location is of the type \", $fuzzylocation->location_type, \"\\n\";\n\n=head1 DESCRIPTION\n\nThis module contains the necessary methods for representing a\nFuzzy Location, one that does not have clear start and/or end points.\nThis will initially serve to handle features from Genbank/EMBL feature\ntables that are written as 1^100 meaning between bases 1 and 100 or\nE<lt>100..300 meaning it starts somewhere before 100.  Advanced\nimplementations of this interface may be able to handle the necessary\nlogic of overlaps/intersection/contains/union.  It was constructed to\nhandle fuzzy locations that can be represented in Genbank/EMBL and\nSwissprot.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Location::Fuzzy;\nuse strict;\n\nuse base qw(Bio::Location::Atomic Bio::Location::FuzzyLocationI);\n\nour @LOCATIONCODESBSANE = (undef, 'EXACT', 'WITHIN', 'BETWEEN', 'UNCERTAIN',\n            'BEFORE', 'AFTER');\n\nour %FUZZYCODES = ( 'EXACT' => '..', # Position is 'exact\n   # Exact position is unknown, but is within the range specified, ((1.2)..100)\n            'WITHIN' => '.', \n            # 1^2\n            'BETWEEN'    => '^',\n            'IN-BETWEEN' => '^',\n            'UNCERTAIN'  => '?',\n            # <100\n            'BEFORE'  => '<',\n            # >10\n            'AFTER'   => '>');   \n   \n    # The following regular expressions map to fuzzy location types. Every\n    # expression must match the complete encoded point string, and must\n    # contain two groups identifying min and max. Empty matches are automatic.\n    # converted to undef, except for 'EXACT', for which max is set to equal\n    # min.\n    \nour %FUZZYPOINTENCODE = ( \n    '\\>(\\d+)(.{0})' => 'AFTER',\n    '\\<(.{0})(\\d+)' => 'BEFORE',\n    '(\\d+)'         => 'EXACT',\n    '\\?(\\d*)'       => 'UNCERTAIN',\n    '(\\d+)(.{0})\\>' => 'AFTER',\n    '(.{0})(\\d+)\\<' => 'BEFORE',\n    '(\\d+)\\.(\\d+)'  => 'WITHIN',\n    '(\\d+)\\^(\\d+)'  => 'BETWEEN',\n   );\n    \nour %FUZZYRANGEENCODE  = (  '\\.'   => 'WITHIN',\n                            '\\.\\.' => 'EXACT',\n                            '\\^'   => 'IN-BETWEEN' );\n\n=head2 new\n\n Title   : new\n Usage   : my $fuzzyloc = Bio::Location::Fuzzy->new( @args);\n Function:\n Returns : \n Args    : -start    => value for start  (initialize by superclass)\n           -end      => value for end    (initialize by superclass)\n           -strand   => value for strand (initialize by superclass)\n           -location_type => either ('EXACT','WITHIN','IN-BETWEEN',\n                             'UNCERTAIN') OR ( 1,2,3,4)\n           -start_ext=> extension for start - defaults to 0, \n           -start_fuz=  fuzzy code for start can be \n                      ('EXACT','WITHIN','BETWEEN','BEFORE','AFTER',\n                       'UNCERTAIN' ) OR\n                      a value 1 - 5 corresponding to index+1 above\n           -end_ext=> extension for end - defaults to 0, \n           -end_fuz=  fuzzy code for end can be \n                      ('EXACT','WITHIN','BETWEEN','BEFORE','AFTER',\n                       'UNCERTAIN') OR\n                      a value 1 - 5 corresponding to index+1 above\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($location_type, $start_ext, $start_fuz, $end_ext, $end_fuz) = \n        $self->_rearrange([ qw(LOCATION_TYPE START_EXT START_FUZ \n                   END_EXT END_FUZ )\n                ], @args);\n\n    $location_type  && $self->location_type($location_type);\n    $start_ext && $self->max_start($self->min_start + $start_ext);\n    $end_ext   && $self->max_end($self->min_end + $end_ext);\n    $start_fuz && $self->start_pos_type($start_fuz);\n    $end_fuz   && $self->end_pos_type($end_fuz);\n\n    return $self;\n}\n\n=head2 location_type\n\n  Title   : location_type\n  Usage   : my $location_type = $location->location_type();\n  Function: Get location type encoded as text\n  Returns : string ('EXACT', 'WITHIN', 'IN-BETWEEN', 'UNCERTAIN')\n  Args    : none\n\n\nsub location_type {\n    my ($self,$value) = @_;\n    if( defined $value || ! defined $self->{'_location_type'} ) {\n        $value = 'EXACT' unless defined $value;\n        if(! defined $FUZZYCODES{$value} )  {\n            $value = uc($value);\n            if( $value =~ /\\.\\./ ) {\n                $value = 'EXACT';\n            } elsif( $value =~ /^\\.$/ ) {\n                $value = 'WITHIN';\n            } elsif( $value =~ /\\^/ ) {\n                $value = 'IN-BETWEEN';\n                $self->throw(\"Use Bio::Location::Simple for IN-BETWEEN locations [\".\n                             $self->start. \"] and [\". $self->end. \"]\")\n                  if defined $self->start && defined $self->end &&\n                            ($self->end - 1 == $self->start);\n            } elsif( $value =~ /\\?/ ) {\n                $value = 'UNCERTAIN';\n            } elsif( $value ne 'EXACT' && $value ne 'WITHIN' && \n                        $value ne 'IN-BETWEEN' ) {\n                $self->throw(\"Did not specify a valid location type\");\n            }\n        }\n        $self->{'_location_type'} = $value;\n    }\n    return $self->{'_location_type'};\n}\n\n=head1 LocationI methods\n\n=head2 length\n\n  Title   : length\n  Usage   : $length = $fuzzy_loc->length();\n  Function: Get the length of this location.\n\n            Note that the length of a fuzzy location will always depend\n            on the currently active interpretation of start and end. The\n            result will therefore vary for different CoordinatePolicy objects.\n\n  Returns : an integer\n  Args    : none\n\n\n#sub length {\n#    my($self) = @_;\n#    return $self->SUPER::length() if( !$self->start || !$self->end);\n#    $self->warn('Length is not valid for a FuzzyLocation'); \n#    return 0;\n#}\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $fuzzy->start();\n  Function: get/set start of this range, handling fuzzy_starts\n  Returns : a positive integer representing the start of the location\n  Args    : start location on set (can be fuzzy point string)\n\n\nsub start {\n    my($self,$value) = @_;\n    if( defined $value ) {\n    my ($encode,$min,$max) = $self->_fuzzypointdecode($value);\n    $self->start_pos_type($encode);\n    $self->min_start($min);\n    $self->max_start($max);\n    }\n\n    $self->throw(\"Use Bio::Location::Simple for IN-BETWEEN locations [\"\n                 . $self->SUPER::start. \"] and [\". $self->SUPER::end. \"]\")\n    if $self->location_type eq 'IN-BETWEEN'  && defined $self->SUPER::end &&\n                  ($self->SUPER::end - 1 == $self->SUPER::start);\n\n    return $self->SUPER::start();\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $fuzzy->end();\n  Function: get/set end of this range, handling fuzzy_ends\n  Returns : a positive integer representing the end of the range\n  Args    : end location on set (can be fuzzy string)\n\n\nsub end {\n    my($self,$value) = @_;\n    if( defined $value ) {\n    my ($encode,$min,$max) = $self->_fuzzypointdecode($value);\n    $self->end_pos_type($encode);\n    $self->min_end($min);\n    $self->max_end($max);\n    }\n\n    $self->throw(\"Use Bio::Location::Simple for IN-BETWEEN locations [\".\n                 $self->SUPER::start. \"] and [\". $self->SUPER::end. \"]\")\n    if $self->location_type eq 'IN-BETWEEN' && defined $self->SUPER::start &&\n                ($self->SUPER::end - 1 == $self->SUPER::start);\n\n    return $self->SUPER::end();\n}\n\n=head2 min_start\n\n  Title   : min_start\n  Usage   : $min_start = $fuzzy->min_start();\n  Function: get/set the minimum starting point\n  Returns : the minimum starting point from the contained sublocations\n  Args    : integer or undef on set\n\n\nsub min_start {\n    my ($self,@args) = @_;\n\n    if(@args) {\n    $self->{'_min_start'} = $args[0]; # the value may be undef!\n    }\n    return $self->{'_min_start'};\n}\n\n=head2 max_start\n\n  Title   : max_start\n  Usage   : my $maxstart = $location->max_start();\n  Function: Get/set maximum starting location of feature startpoint  \n  Returns : integer or undef if no maximum starting point.\n  Args    : integer or undef on set\n\n\nsub max_start {\n    my ($self,@args) = @_;\n\n    if(@args) {\n        $self->{'_max_start'} = $args[0]; # the value may be undef!\n    }\n    return $self->{'_max_start'};\n}\n\n=head2 start_pos_type\n\n  Title   : start_pos_type\n  Usage   : my $start_pos_type = $location->start_pos_type();\n  Function: Get/set start position type.\n  Returns : type of position coded as text \n            ('BEFORE','AFTER','EXACT','WITHIN','BETWEEN','UNCERTAIN')\n  Args    : a string on set\n\n\nsub start_pos_type {\n    my ($self,$value) = @_;\n    if(defined $value &&  $value =~ /^\\d+$/ ) {\n        if( $value == 0 ) { $value = 'EXACT'; }\n        else { \n            my $v = $LOCATIONCODESBSANE[$value];\n            if( ! defined $v ) {\n                $self->warn(\"Provided value $value which I don't understand,\".\n                            \" reverting to 'EXACT'\");\n                $v = 'EXACT';\n            }\n            $value = $v;\n        }\n    }\n    if(defined($value)) {\n        $self->{'_start_pos_type'} = $value;\n    }\n    return $self->{'_start_pos_type'};\n}\n\n=head2 min_end\n\n  Title   : min_end\n  Usage   : my $minend = $location->min_end();\n  Function: Get/set minimum ending location of feature endpoint \n  Returns : integer or undef if no minimum ending point.\n  Args    : integer or undef on set","parameters":[{"label":"$self"},{"label":"@args"}],"label":"min_end($self,@args)"},"line":358,"kind":12,"range":{"start":{"line":358,"character":0},"end":{"character":9999,"line":365}},"definition":"sub","detail":"($self,@args)","children":[{"line":359,"kind":13,"localvar":"my","containerName":"min_end","name":"$self","definition":"my"},{"line":359,"name":"@args","kind":13,"containerName":"min_end"},{"containerName":"min_end","kind":13,"name":"@args","line":361},{"kind":13,"containerName":"min_end","name":"$self","line":362},{"name":"$args","kind":13,"containerName":"min_end","line":362},{"kind":13,"containerName":"min_end","name":"$self","line":364}],"name":"min_end","containerName":"main::"},{"detail":"($self,@args)","definition":"sub","name":"max_end","containerName":"main::","children":[{"definition":"my","line":378,"name":"$self","localvar":"my","containerName":"max_end","kind":13},{"line":378,"containerName":"max_end","kind":13,"name":"@args"},{"line":380,"name":"@args","kind":13,"containerName":"max_end"},{"line":381,"name":"$self","containerName":"max_end","kind":13},{"name":"$args","containerName":"max_end","kind":13,"line":381},{"name":"$self","containerName":"max_end","kind":13,"line":383}],"signature":{"documentation":"1;\n# $Id: Fuzzy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::Fuzzy\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::Fuzzy - Implementation of a Location on a Sequence\nwhich has unclear start and/or end locations\n\n=head1 SYNOPSIS\n\n    use Bio::Location::Fuzzy;\n    my $fuzzylocation = Bio::Location::Fuzzy->new(\n                                                 -start => '<30',\n                                                 -end   => 90,\n                                                 -location_type => '..');\n\n    print \"location string is \", $fuzzylocation->to_FTstring(), \"\\n\";\n    print \"location is of the type \", $fuzzylocation->location_type, \"\\n\";\n\n=head1 DESCRIPTION\n\nThis module contains the necessary methods for representing a\nFuzzy Location, one that does not have clear start and/or end points.\nThis will initially serve to handle features from Genbank/EMBL feature\ntables that are written as 1^100 meaning between bases 1 and 100 or\nE<lt>100..300 meaning it starts somewhere before 100.  Advanced\nimplementations of this interface may be able to handle the necessary\nlogic of overlaps/intersection/contains/union.  It was constructed to\nhandle fuzzy locations that can be represented in Genbank/EMBL and\nSwissprot.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Location::Fuzzy;\nuse strict;\n\nuse base qw(Bio::Location::Atomic Bio::Location::FuzzyLocationI);\n\nour @LOCATIONCODESBSANE = (undef, 'EXACT', 'WITHIN', 'BETWEEN', 'UNCERTAIN',\n            'BEFORE', 'AFTER');\n\nour %FUZZYCODES = ( 'EXACT' => '..', # Position is 'exact\n   # Exact position is unknown, but is within the range specified, ((1.2)..100)\n            'WITHIN' => '.', \n            # 1^2\n            'BETWEEN'    => '^',\n            'IN-BETWEEN' => '^',\n            'UNCERTAIN'  => '?',\n            # <100\n            'BEFORE'  => '<',\n            # >10\n            'AFTER'   => '>');   \n   \n    # The following regular expressions map to fuzzy location types. Every\n    # expression must match the complete encoded point string, and must\n    # contain two groups identifying min and max. Empty matches are automatic.\n    # converted to undef, except for 'EXACT', for which max is set to equal\n    # min.\n    \nour %FUZZYPOINTENCODE = ( \n    '\\>(\\d+)(.{0})' => 'AFTER',\n    '\\<(.{0})(\\d+)' => 'BEFORE',\n    '(\\d+)'         => 'EXACT',\n    '\\?(\\d*)'       => 'UNCERTAIN',\n    '(\\d+)(.{0})\\>' => 'AFTER',\n    '(.{0})(\\d+)\\<' => 'BEFORE',\n    '(\\d+)\\.(\\d+)'  => 'WITHIN',\n    '(\\d+)\\^(\\d+)'  => 'BETWEEN',\n   );\n    \nour %FUZZYRANGEENCODE  = (  '\\.'   => 'WITHIN',\n                            '\\.\\.' => 'EXACT',\n                            '\\^'   => 'IN-BETWEEN' );\n\n=head2 new\n\n Title   : new\n Usage   : my $fuzzyloc = Bio::Location::Fuzzy->new( @args);\n Function:\n Returns : \n Args    : -start    => value for start  (initialize by superclass)\n           -end      => value for end    (initialize by superclass)\n           -strand   => value for strand (initialize by superclass)\n           -location_type => either ('EXACT','WITHIN','IN-BETWEEN',\n                             'UNCERTAIN') OR ( 1,2,3,4)\n           -start_ext=> extension for start - defaults to 0, \n           -start_fuz=  fuzzy code for start can be \n                      ('EXACT','WITHIN','BETWEEN','BEFORE','AFTER',\n                       'UNCERTAIN' ) OR\n                      a value 1 - 5 corresponding to index+1 above\n           -end_ext=> extension for end - defaults to 0, \n           -end_fuz=  fuzzy code for end can be \n                      ('EXACT','WITHIN','BETWEEN','BEFORE','AFTER',\n                       'UNCERTAIN') OR\n                      a value 1 - 5 corresponding to index+1 above\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($location_type, $start_ext, $start_fuz, $end_ext, $end_fuz) = \n        $self->_rearrange([ qw(LOCATION_TYPE START_EXT START_FUZ \n                   END_EXT END_FUZ )\n                ], @args);\n\n    $location_type  && $self->location_type($location_type);\n    $start_ext && $self->max_start($self->min_start + $start_ext);\n    $end_ext   && $self->max_end($self->min_end + $end_ext);\n    $start_fuz && $self->start_pos_type($start_fuz);\n    $end_fuz   && $self->end_pos_type($end_fuz);\n\n    return $self;\n}\n\n=head2 location_type\n\n  Title   : location_type\n  Usage   : my $location_type = $location->location_type();\n  Function: Get location type encoded as text\n  Returns : string ('EXACT', 'WITHIN', 'IN-BETWEEN', 'UNCERTAIN')\n  Args    : none\n\n\nsub location_type {\n    my ($self,$value) = @_;\n    if( defined $value || ! defined $self->{'_location_type'} ) {\n        $value = 'EXACT' unless defined $value;\n        if(! defined $FUZZYCODES{$value} )  {\n            $value = uc($value);\n            if( $value =~ /\\.\\./ ) {\n                $value = 'EXACT';\n            } elsif( $value =~ /^\\.$/ ) {\n                $value = 'WITHIN';\n            } elsif( $value =~ /\\^/ ) {\n                $value = 'IN-BETWEEN';\n                $self->throw(\"Use Bio::Location::Simple for IN-BETWEEN locations [\".\n                             $self->start. \"] and [\". $self->end. \"]\")\n                  if defined $self->start && defined $self->end &&\n                            ($self->end - 1 == $self->start);\n            } elsif( $value =~ /\\?/ ) {\n                $value = 'UNCERTAIN';\n            } elsif( $value ne 'EXACT' && $value ne 'WITHIN' && \n                        $value ne 'IN-BETWEEN' ) {\n                $self->throw(\"Did not specify a valid location type\");\n            }\n        }\n        $self->{'_location_type'} = $value;\n    }\n    return $self->{'_location_type'};\n}\n\n=head1 LocationI methods\n\n=head2 length\n\n  Title   : length\n  Usage   : $length = $fuzzy_loc->length();\n  Function: Get the length of this location.\n\n            Note that the length of a fuzzy location will always depend\n            on the currently active interpretation of start and end. The\n            result will therefore vary for different CoordinatePolicy objects.\n\n  Returns : an integer\n  Args    : none\n\n\n#sub length {\n#    my($self) = @_;\n#    return $self->SUPER::length() if( !$self->start || !$self->end);\n#    $self->warn('Length is not valid for a FuzzyLocation'); \n#    return 0;\n#}\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $fuzzy->start();\n  Function: get/set start of this range, handling fuzzy_starts\n  Returns : a positive integer representing the start of the location\n  Args    : start location on set (can be fuzzy point string)\n\n\nsub start {\n    my($self,$value) = @_;\n    if( defined $value ) {\n    my ($encode,$min,$max) = $self->_fuzzypointdecode($value);\n    $self->start_pos_type($encode);\n    $self->min_start($min);\n    $self->max_start($max);\n    }\n\n    $self->throw(\"Use Bio::Location::Simple for IN-BETWEEN locations [\"\n                 . $self->SUPER::start. \"] and [\". $self->SUPER::end. \"]\")\n    if $self->location_type eq 'IN-BETWEEN'  && defined $self->SUPER::end &&\n                  ($self->SUPER::end - 1 == $self->SUPER::start);\n\n    return $self->SUPER::start();\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $fuzzy->end();\n  Function: get/set end of this range, handling fuzzy_ends\n  Returns : a positive integer representing the end of the range\n  Args    : end location on set (can be fuzzy string)\n\n\nsub end {\n    my($self,$value) = @_;\n    if( defined $value ) {\n    my ($encode,$min,$max) = $self->_fuzzypointdecode($value);\n    $self->end_pos_type($encode);\n    $self->min_end($min);\n    $self->max_end($max);\n    }\n\n    $self->throw(\"Use Bio::Location::Simple for IN-BETWEEN locations [\".\n                 $self->SUPER::start. \"] and [\". $self->SUPER::end. \"]\")\n    if $self->location_type eq 'IN-BETWEEN' && defined $self->SUPER::start &&\n                ($self->SUPER::end - 1 == $self->SUPER::start);\n\n    return $self->SUPER::end();\n}\n\n=head2 min_start\n\n  Title   : min_start\n  Usage   : $min_start = $fuzzy->min_start();\n  Function: get/set the minimum starting point\n  Returns : the minimum starting point from the contained sublocations\n  Args    : integer or undef on set\n\n\nsub min_start {\n    my ($self,@args) = @_;\n\n    if(@args) {\n    $self->{'_min_start'} = $args[0]; # the value may be undef!\n    }\n    return $self->{'_min_start'};\n}\n\n=head2 max_start\n\n  Title   : max_start\n  Usage   : my $maxstart = $location->max_start();\n  Function: Get/set maximum starting location of feature startpoint  \n  Returns : integer or undef if no maximum starting point.\n  Args    : integer or undef on set\n\n\nsub max_start {\n    my ($self,@args) = @_;\n\n    if(@args) {\n        $self->{'_max_start'} = $args[0]; # the value may be undef!\n    }\n    return $self->{'_max_start'};\n}\n\n=head2 start_pos_type\n\n  Title   : start_pos_type\n  Usage   : my $start_pos_type = $location->start_pos_type();\n  Function: Get/set start position type.\n  Returns : type of position coded as text \n            ('BEFORE','AFTER','EXACT','WITHIN','BETWEEN','UNCERTAIN')\n  Args    : a string on set\n\n\nsub start_pos_type {\n    my ($self,$value) = @_;\n    if(defined $value &&  $value =~ /^\\d+$/ ) {\n        if( $value == 0 ) { $value = 'EXACT'; }\n        else { \n            my $v = $LOCATIONCODESBSANE[$value];\n            if( ! defined $v ) {\n                $self->warn(\"Provided value $value which I don't understand,\".\n                            \" reverting to 'EXACT'\");\n                $v = 'EXACT';\n            }\n            $value = $v;\n        }\n    }\n    if(defined($value)) {\n        $self->{'_start_pos_type'} = $value;\n    }\n    return $self->{'_start_pos_type'};\n}\n\n=head2 min_end\n\n  Title   : min_end\n  Usage   : my $minend = $location->min_end();\n  Function: Get/set minimum ending location of feature endpoint \n  Returns : integer or undef if no minimum ending point.\n  Args    : integer or undef on set\n\n\nsub min_end {\n    my ($self,@args) = @_;\n\n    if(@args) {\n        $self->{'_min_end'} = $args[0]; # the value may be undef!\n    }\n    return $self->{'_min_end'};\n}\n\n=head2 max_end\n\n  Title   : max_end\n  Usage   : my $maxend = $location->max_end();\n  Function: Get/set maximum ending location of feature endpoint \n  Returns : integer or undef if no maximum ending point.\n  Args    : integer or undef on set","parameters":[{"label":"$self"},{"label":"@args"}],"label":"max_end($self,@args)"},"range":{"end":{"character":9999,"line":384},"start":{"line":377,"character":0}},"kind":12,"line":377},{"signature":{"label":"end_pos_type($self,$value)","documentation":"1;\n# $Id: Fuzzy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::Fuzzy\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::Fuzzy - Implementation of a Location on a Sequence\nwhich has unclear start and/or end locations\n\n=head1 SYNOPSIS\n\n    use Bio::Location::Fuzzy;\n    my $fuzzylocation = Bio::Location::Fuzzy->new(\n                                                 -start => '<30',\n                                                 -end   => 90,\n                                                 -location_type => '..');\n\n    print \"location string is \", $fuzzylocation->to_FTstring(), \"\\n\";\n    print \"location is of the type \", $fuzzylocation->location_type, \"\\n\";\n\n=head1 DESCRIPTION\n\nThis module contains the necessary methods for representing a\nFuzzy Location, one that does not have clear start and/or end points.\nThis will initially serve to handle features from Genbank/EMBL feature\ntables that are written as 1^100 meaning between bases 1 and 100 or\nE<lt>100..300 meaning it starts somewhere before 100.  Advanced\nimplementations of this interface may be able to handle the necessary\nlogic of overlaps/intersection/contains/union.  It was constructed to\nhandle fuzzy locations that can be represented in Genbank/EMBL and\nSwissprot.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Location::Fuzzy;\nuse strict;\n\nuse base qw(Bio::Location::Atomic Bio::Location::FuzzyLocationI);\n\nour @LOCATIONCODESBSANE = (undef, 'EXACT', 'WITHIN', 'BETWEEN', 'UNCERTAIN',\n            'BEFORE', 'AFTER');\n\nour %FUZZYCODES = ( 'EXACT' => '..', # Position is 'exact\n   # Exact position is unknown, but is within the range specified, ((1.2)..100)\n            'WITHIN' => '.', \n            # 1^2\n            'BETWEEN'    => '^',\n            'IN-BETWEEN' => '^',\n            'UNCERTAIN'  => '?',\n            # <100\n            'BEFORE'  => '<',\n            # >10\n            'AFTER'   => '>');   \n   \n    # The following regular expressions map to fuzzy location types. Every\n    # expression must match the complete encoded point string, and must\n    # contain two groups identifying min and max. Empty matches are automatic.\n    # converted to undef, except for 'EXACT', for which max is set to equal\n    # min.\n    \nour %FUZZYPOINTENCODE = ( \n    '\\>(\\d+)(.{0})' => 'AFTER',\n    '\\<(.{0})(\\d+)' => 'BEFORE',\n    '(\\d+)'         => 'EXACT',\n    '\\?(\\d*)'       => 'UNCERTAIN',\n    '(\\d+)(.{0})\\>' => 'AFTER',\n    '(.{0})(\\d+)\\<' => 'BEFORE',\n    '(\\d+)\\.(\\d+)'  => 'WITHIN',\n    '(\\d+)\\^(\\d+)'  => 'BETWEEN',\n   );\n    \nour %FUZZYRANGEENCODE  = (  '\\.'   => 'WITHIN',\n                            '\\.\\.' => 'EXACT',\n                            '\\^'   => 'IN-BETWEEN' );\n\n=head2 new\n\n Title   : new\n Usage   : my $fuzzyloc = Bio::Location::Fuzzy->new( @args);\n Function:\n Returns : \n Args    : -start    => value for start  (initialize by superclass)\n           -end      => value for end    (initialize by superclass)\n           -strand   => value for strand (initialize by superclass)\n           -location_type => either ('EXACT','WITHIN','IN-BETWEEN',\n                             'UNCERTAIN') OR ( 1,2,3,4)\n           -start_ext=> extension for start - defaults to 0, \n           -start_fuz=  fuzzy code for start can be \n                      ('EXACT','WITHIN','BETWEEN','BEFORE','AFTER',\n                       'UNCERTAIN' ) OR\n                      a value 1 - 5 corresponding to index+1 above\n           -end_ext=> extension for end - defaults to 0, \n           -end_fuz=  fuzzy code for end can be \n                      ('EXACT','WITHIN','BETWEEN','BEFORE','AFTER',\n                       'UNCERTAIN') OR\n                      a value 1 - 5 corresponding to index+1 above\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($location_type, $start_ext, $start_fuz, $end_ext, $end_fuz) = \n        $self->_rearrange([ qw(LOCATION_TYPE START_EXT START_FUZ \n                   END_EXT END_FUZ )\n                ], @args);\n\n    $location_type  && $self->location_type($location_type);\n    $start_ext && $self->max_start($self->min_start + $start_ext);\n    $end_ext   && $self->max_end($self->min_end + $end_ext);\n    $start_fuz && $self->start_pos_type($start_fuz);\n    $end_fuz   && $self->end_pos_type($end_fuz);\n\n    return $self;\n}\n\n=head2 location_type\n\n  Title   : location_type\n  Usage   : my $location_type = $location->location_type();\n  Function: Get location type encoded as text\n  Returns : string ('EXACT', 'WITHIN', 'IN-BETWEEN', 'UNCERTAIN')\n  Args    : none\n\n\nsub location_type {\n    my ($self,$value) = @_;\n    if( defined $value || ! defined $self->{'_location_type'} ) {\n        $value = 'EXACT' unless defined $value;\n        if(! defined $FUZZYCODES{$value} )  {\n            $value = uc($value);\n            if( $value =~ /\\.\\./ ) {\n                $value = 'EXACT';\n            } elsif( $value =~ /^\\.$/ ) {\n                $value = 'WITHIN';\n            } elsif( $value =~ /\\^/ ) {\n                $value = 'IN-BETWEEN';\n                $self->throw(\"Use Bio::Location::Simple for IN-BETWEEN locations [\".\n                             $self->start. \"] and [\". $self->end. \"]\")\n                  if defined $self->start && defined $self->end &&\n                            ($self->end - 1 == $self->start);\n            } elsif( $value =~ /\\?/ ) {\n                $value = 'UNCERTAIN';\n            } elsif( $value ne 'EXACT' && $value ne 'WITHIN' && \n                        $value ne 'IN-BETWEEN' ) {\n                $self->throw(\"Did not specify a valid location type\");\n            }\n        }\n        $self->{'_location_type'} = $value;\n    }\n    return $self->{'_location_type'};\n}\n\n=head1 LocationI methods\n\n=head2 length\n\n  Title   : length\n  Usage   : $length = $fuzzy_loc->length();\n  Function: Get the length of this location.\n\n            Note that the length of a fuzzy location will always depend\n            on the currently active interpretation of start and end. The\n            result will therefore vary for different CoordinatePolicy objects.\n\n  Returns : an integer\n  Args    : none\n\n\n#sub length {\n#    my($self) = @_;\n#    return $self->SUPER::length() if( !$self->start || !$self->end);\n#    $self->warn('Length is not valid for a FuzzyLocation'); \n#    return 0;\n#}\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $fuzzy->start();\n  Function: get/set start of this range, handling fuzzy_starts\n  Returns : a positive integer representing the start of the location\n  Args    : start location on set (can be fuzzy point string)\n\n\nsub start {\n    my($self,$value) = @_;\n    if( defined $value ) {\n    my ($encode,$min,$max) = $self->_fuzzypointdecode($value);\n    $self->start_pos_type($encode);\n    $self->min_start($min);\n    $self->max_start($max);\n    }\n\n    $self->throw(\"Use Bio::Location::Simple for IN-BETWEEN locations [\"\n                 . $self->SUPER::start. \"] and [\". $self->SUPER::end. \"]\")\n    if $self->location_type eq 'IN-BETWEEN'  && defined $self->SUPER::end &&\n                  ($self->SUPER::end - 1 == $self->SUPER::start);\n\n    return $self->SUPER::start();\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $fuzzy->end();\n  Function: get/set end of this range, handling fuzzy_ends\n  Returns : a positive integer representing the end of the range\n  Args    : end location on set (can be fuzzy string)\n\n\nsub end {\n    my($self,$value) = @_;\n    if( defined $value ) {\n    my ($encode,$min,$max) = $self->_fuzzypointdecode($value);\n    $self->end_pos_type($encode);\n    $self->min_end($min);\n    $self->max_end($max);\n    }\n\n    $self->throw(\"Use Bio::Location::Simple for IN-BETWEEN locations [\".\n                 $self->SUPER::start. \"] and [\". $self->SUPER::end. \"]\")\n    if $self->location_type eq 'IN-BETWEEN' && defined $self->SUPER::start &&\n                ($self->SUPER::end - 1 == $self->SUPER::start);\n\n    return $self->SUPER::end();\n}\n\n=head2 min_start\n\n  Title   : min_start\n  Usage   : $min_start = $fuzzy->min_start();\n  Function: get/set the minimum starting point\n  Returns : the minimum starting point from the contained sublocations\n  Args    : integer or undef on set\n\n\nsub min_start {\n    my ($self,@args) = @_;\n\n    if(@args) {\n    $self->{'_min_start'} = $args[0]; # the value may be undef!\n    }\n    return $self->{'_min_start'};\n}\n\n=head2 max_start\n\n  Title   : max_start\n  Usage   : my $maxstart = $location->max_start();\n  Function: Get/set maximum starting location of feature startpoint  \n  Returns : integer or undef if no maximum starting point.\n  Args    : integer or undef on set\n\n\nsub max_start {\n    my ($self,@args) = @_;\n\n    if(@args) {\n        $self->{'_max_start'} = $args[0]; # the value may be undef!\n    }\n    return $self->{'_max_start'};\n}\n\n=head2 start_pos_type\n\n  Title   : start_pos_type\n  Usage   : my $start_pos_type = $location->start_pos_type();\n  Function: Get/set start position type.\n  Returns : type of position coded as text \n            ('BEFORE','AFTER','EXACT','WITHIN','BETWEEN','UNCERTAIN')\n  Args    : a string on set\n\n\nsub start_pos_type {\n    my ($self,$value) = @_;\n    if(defined $value &&  $value =~ /^\\d+$/ ) {\n        if( $value == 0 ) { $value = 'EXACT'; }\n        else { \n            my $v = $LOCATIONCODESBSANE[$value];\n            if( ! defined $v ) {\n                $self->warn(\"Provided value $value which I don't understand,\".\n                            \" reverting to 'EXACT'\");\n                $v = 'EXACT';\n            }\n            $value = $v;\n        }\n    }\n    if(defined($value)) {\n        $self->{'_start_pos_type'} = $value;\n    }\n    return $self->{'_start_pos_type'};\n}\n\n=head2 min_end\n\n  Title   : min_end\n  Usage   : my $minend = $location->min_end();\n  Function: Get/set minimum ending location of feature endpoint \n  Returns : integer or undef if no minimum ending point.\n  Args    : integer or undef on set\n\n\nsub min_end {\n    my ($self,@args) = @_;\n\n    if(@args) {\n        $self->{'_min_end'} = $args[0]; # the value may be undef!\n    }\n    return $self->{'_min_end'};\n}\n\n=head2 max_end\n\n  Title   : max_end\n  Usage   : my $maxend = $location->max_end();\n  Function: Get/set maximum ending location of feature endpoint \n  Returns : integer or undef if no maximum ending point.\n  Args    : integer or undef on set\n\n\nsub max_end {\n    my ($self,@args) = @_;\n\n    if(@args) {\n        $self->{'_max_end'} = $args[0]; # the value may be undef!\n    }\n    return $self->{'_max_end'};\n}\n\n=head2 end_pos_type\n\n  Title   : end_pos_type\n  Usage   : my $end_pos_type = $location->end_pos_type();\n  Function: Get/set end position type.\n  Returns : type of position coded as text \n            ('BEFORE','AFTER','EXACT','WITHIN','BETWEEN','UNCERTAIN')\n  Args    : a string on set","parameters":[{"label":"$self"},{"label":"$value"}]},"line":397,"kind":12,"range":{"end":{"line":416,"character":9999},"start":{"character":0,"line":397}},"definition":"sub","detail":"($self,$value)","children":[{"containerName":"end_pos_type","localvar":"my","kind":13,"name":"$self","line":398,"definition":"my"},{"kind":13,"containerName":"end_pos_type","name":"$value","line":398},{"containerName":"end_pos_type","kind":13,"name":"$value","line":399},{"line":399,"kind":13,"containerName":"end_pos_type","name":"$value"},{"line":400,"kind":13,"containerName":"end_pos_type","name":"$value"},{"containerName":"end_pos_type","kind":13,"name":"$value","line":400},{"definition":"my","localvar":"my","containerName":"end_pos_type","kind":13,"name":"$v","line":402},{"line":402,"name":"$LOCATIONCODESBSANE","containerName":"end_pos_type","kind":13},{"line":402,"containerName":"end_pos_type","kind":13,"name":"$value"},{"line":403,"containerName":"end_pos_type","kind":13,"name":"$v"},{"line":404,"name":"$self","containerName":"end_pos_type","kind":13},{"line":404,"name":"warn","containerName":"end_pos_type","kind":12},{"containerName":"end_pos_type","kind":13,"name":"$v","line":406},{"line":408,"containerName":"end_pos_type","kind":13,"name":"$value"},{"line":408,"name":"$v","containerName":"end_pos_type","kind":13},{"name":"$value","containerName":"end_pos_type","kind":13,"line":412},{"line":413,"containerName":"end_pos_type","kind":13,"name":"$self"},{"line":413,"kind":13,"containerName":"end_pos_type","name":"$value"},{"name":"$self","kind":13,"containerName":"end_pos_type","line":415}],"containerName":"main::","name":"end_pos_type"},{"children":[{"definition":"my","line":469,"name":"$self","containerName":"to_FTstring","localvar":"my","kind":13},{"definition":"my","line":470,"containerName":"to_FTstring","localvar":"my","kind":13,"name":"%vals"},{"name":"$self","kind":13,"containerName":"to_FTstring","line":470},{"name":"start","containerName":"to_FTstring","kind":12,"line":470},{"name":"$self","kind":13,"containerName":"to_FTstring","line":471},{"line":471,"name":"min_start","kind":12,"containerName":"to_FTstring"},{"name":"$self","kind":13,"containerName":"to_FTstring","line":472},{"name":"max_start","containerName":"to_FTstring","kind":12,"line":472},{"line":473,"name":"$self","kind":13,"containerName":"to_FTstring"},{"name":"start_pos_type","containerName":"to_FTstring","kind":12,"line":473},{"line":474,"kind":13,"containerName":"to_FTstring","name":"$self"},{"line":474,"containerName":"to_FTstring","kind":12,"name":"end"},{"name":"$self","kind":13,"containerName":"to_FTstring","line":475},{"name":"min_end","containerName":"to_FTstring","kind":12,"line":475},{"name":"$self","containerName":"to_FTstring","kind":13,"line":476},{"containerName":"to_FTstring","kind":12,"name":"max_end","line":476},{"containerName":"to_FTstring","kind":13,"name":"$self","line":477},{"name":"end_pos_type","containerName":"to_FTstring","kind":12,"line":477},{"definition":"my","line":479,"name":"%strs","kind":13,"localvar":"my","containerName":"to_FTstring"},{"line":481,"name":"$delimiter","containerName":"to_FTstring","localvar":"my","kind":13,"definition":"my"},{"line":481,"name":"$FUZZYCODES","kind":13,"containerName":"to_FTstring"},{"line":481,"containerName":"to_FTstring","kind":13,"name":"$self"},{"line":481,"containerName":"to_FTstring","kind":12,"name":"location_type"},{"name":"$delimiter","kind":13,"containerName":"to_FTstring","line":482},{"name":"$FUZZYCODES","kind":13,"containerName":"to_FTstring","line":482},{"line":482,"name":"$self","containerName":"to_FTstring","kind":13},{"containerName":"to_FTstring","kind":12,"name":"location_type","line":482},{"definition":"my","line":484,"localvar":"my","kind":13,"containerName":"to_FTstring","name":"$policy"},{"name":"$self","kind":13,"containerName":"to_FTstring","line":484},{"line":484,"kind":12,"containerName":"to_FTstring","name":"coordinate_policy"},{"definition":"my","line":489,"name":"$point","containerName":"to_FTstring","localvar":"my","kind":13},{"name":"$vals","kind":13,"containerName":"to_FTstring","line":490},{"line":490,"name":"$point","containerName":"to_FTstring","kind":13},{"line":491,"containerName":"to_FTstring","kind":13,"name":"$vals"},{"line":491,"name":"$point","containerName":"to_FTstring","kind":13},{"line":494,"kind":13,"containerName":"to_FTstring","name":"$vals"},{"line":495,"name":"$vals","containerName":"to_FTstring","kind":13},{"containerName":"to_FTstring","kind":13,"name":"$vals","line":496},{"line":496,"name":"$point","containerName":"to_FTstring","kind":13},{"line":497,"containerName":"to_FTstring","kind":13,"name":"$vals"},{"name":"$point","kind":13,"containerName":"to_FTstring","line":497},{"kind":13,"containerName":"to_FTstring","name":"$vals","line":499},{"name":"$vals","kind":13,"containerName":"to_FTstring","line":499},{"name":"$vals","kind":13,"containerName":"to_FTstring","line":500},{"kind":13,"containerName":"to_FTstring","name":"$vals","line":500},{"line":502,"name":"$self","containerName":"to_FTstring","kind":13},{"line":502,"kind":12,"containerName":"to_FTstring","name":"warn"},{"line":503,"containerName":"to_FTstring","kind":13,"name":"$vals"},{"name":"$vals","containerName":"to_FTstring","kind":13,"line":504},{"name":"$vals","containerName":"to_FTstring","kind":13,"line":505},{"name":"$point","kind":13,"containerName":"to_FTstring","line":505},{"line":509,"name":"$vals","kind":13,"containerName":"to_FTstring"},{"line":509,"kind":13,"containerName":"to_FTstring","name":"$point"},{"name":"$vals","kind":13,"containerName":"to_FTstring","line":510},{"name":"$point","containerName":"to_FTstring","kind":13,"line":510},{"name":"$vals","containerName":"to_FTstring","kind":13,"line":511},{"containerName":"to_FTstring","kind":13,"name":"$point","line":511},{"line":513,"name":"$strs","containerName":"to_FTstring","kind":13},{"line":513,"name":"$point","containerName":"to_FTstring","kind":13},{"containerName":"to_FTstring","kind":13,"name":"$FUZZYCODES","line":513},{"line":513,"name":"$vals","containerName":"to_FTstring","kind":13},{"name":"$point","kind":13,"containerName":"to_FTstring","line":513},{"kind":13,"containerName":"to_FTstring","name":"$strs","line":514},{"containerName":"to_FTstring","kind":13,"name":"$point","line":514},{"name":"$vals","kind":13,"containerName":"to_FTstring","line":514},{"kind":13,"containerName":"to_FTstring","name":"$vals","line":517},{"kind":13,"containerName":"to_FTstring","name":"$point","line":517},{"containerName":"to_FTstring","kind":13,"name":"$vals","line":518},{"kind":13,"containerName":"to_FTstring","name":"$point","line":518},{"line":519,"name":"$vals","containerName":"to_FTstring","kind":13},{"line":519,"kind":13,"containerName":"to_FTstring","name":"$point"},{"name":"$strs","containerName":"to_FTstring","kind":13,"line":522},{"line":522,"name":"$point","kind":13,"containerName":"to_FTstring"},{"line":522,"containerName":"to_FTstring","kind":13,"name":"$point"},{"name":"$vals","containerName":"to_FTstring","kind":13,"line":523},{"line":524,"name":"$FUZZYCODES","containerName":"to_FTstring","kind":13},{"line":524,"containerName":"to_FTstring","kind":13,"name":"$vals"},{"line":524,"containerName":"to_FTstring","kind":13,"name":"$point"},{"line":525,"kind":13,"containerName":"to_FTstring","name":"$vals"},{"kind":13,"containerName":"to_FTstring","name":"$point","line":525},{"line":527,"containerName":"to_FTstring","kind":13,"name":"$vals"},{"line":527,"name":"$point","kind":13,"containerName":"to_FTstring"},{"name":"$FUZZYCODES","kind":13,"containerName":"to_FTstring","line":528},{"containerName":"to_FTstring","kind":13,"name":"$vals","line":528},{"line":528,"name":"$point","containerName":"to_FTstring","kind":13},{"line":529,"name":"$vals","kind":13,"containerName":"to_FTstring"},{"name":"$strs","kind":13,"containerName":"to_FTstring","line":530},{"line":530,"name":"$point","containerName":"to_FTstring","kind":13},{"line":530,"name":"$strs","containerName":"to_FTstring","kind":13},{"line":530,"kind":13,"containerName":"to_FTstring","name":"$point"},{"line":533,"name":"$vals","containerName":"to_FTstring","kind":13},{"kind":13,"containerName":"to_FTstring","name":"$point","line":533},{"name":"$strs","kind":13,"containerName":"to_FTstring","line":534},{"name":"$point","containerName":"to_FTstring","kind":13,"line":534},{"name":"$FUZZYCODES","kind":13,"containerName":"to_FTstring","line":534},{"line":534,"name":"$vals","kind":13,"containerName":"to_FTstring"},{"containerName":"to_FTstring","kind":13,"name":"$point","line":534},{"containerName":"to_FTstring","kind":13,"name":"$strs","line":535},{"name":"$point","containerName":"to_FTstring","kind":13,"line":535},{"kind":13,"containerName":"to_FTstring","name":"$vals","line":535},{"line":535,"containerName":"to_FTstring","kind":13,"name":"$point"},{"line":535,"containerName":"to_FTstring","kind":13,"name":"$vals"},{"line":535,"name":"$point","containerName":"to_FTstring","kind":13},{"line":537,"containerName":"to_FTstring","kind":13,"name":"$strs"},{"line":537,"name":"$point","kind":13,"containerName":"to_FTstring"},{"kind":13,"containerName":"to_FTstring","name":"$vals","line":537},{"line":537,"name":"$point","kind":13,"containerName":"to_FTstring"},{"kind":13,"localvar":"my","containerName":"to_FTstring","name":"$str","line":541,"definition":"my"},{"line":541,"containerName":"to_FTstring","kind":13,"name":"$strs"},{"line":541,"kind":13,"containerName":"to_FTstring","name":"$delimiter"},{"line":541,"name":"$strs","containerName":"to_FTstring","kind":13},{"containerName":"to_FTstring","kind":13,"name":"$self","line":542},{"line":542,"name":"is_remote","containerName":"to_FTstring","kind":12},{"name":"$self","kind":13,"containerName":"to_FTstring","line":542},{"line":542,"name":"seq_id","kind":12,"containerName":"to_FTstring"},{"name":"$str","kind":13,"containerName":"to_FTstring","line":543},{"line":543,"kind":13,"containerName":"to_FTstring","name":"$self"},{"line":543,"name":"seq_id","containerName":"to_FTstring","kind":12},{"name":"$str","containerName":"to_FTstring","kind":13,"line":543},{"containerName":"to_FTstring","kind":13,"name":"$self","line":545},{"containerName":"to_FTstring","kind":12,"name":"strand","line":545},{"containerName":"to_FTstring","kind":13,"name":"$self","line":546},{"line":546,"containerName":"to_FTstring","kind":12,"name":"strand"},{"containerName":"to_FTstring","kind":13,"name":"$self","line":547},{"kind":12,"containerName":"to_FTstring","name":"location_type","line":547},{"line":548,"kind":13,"containerName":"to_FTstring","name":"$str"},{"line":548,"containerName":"to_FTstring","kind":13,"name":"$str"},{"line":549,"name":"$self","kind":13,"containerName":"to_FTstring"},{"name":"location_type","kind":12,"containerName":"to_FTstring","line":549},{"line":550,"kind":13,"containerName":"to_FTstring","name":"$str"},{"containerName":"to_FTstring","kind":13,"name":"$str","line":550},{"line":552,"name":"$str","kind":13,"containerName":"to_FTstring"}],"name":"to_FTstring","containerName":"main::","definition":"sub","detail":"($self)","line":468,"kind":12,"range":{"end":{"character":9999,"line":553},"start":{"line":468,"character":0}},"signature":{"label":"to_FTstring($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Fuzzy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::Fuzzy\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::Fuzzy - Implementation of a Location on a Sequence\nwhich has unclear start and/or end locations\n\n=head1 SYNOPSIS\n\n    use Bio::Location::Fuzzy;\n    my $fuzzylocation = Bio::Location::Fuzzy->new(\n                                                 -start => '<30',\n                                                 -end   => 90,\n                                                 -location_type => '..');\n\n    print \"location string is \", $fuzzylocation->to_FTstring(), \"\\n\";\n    print \"location is of the type \", $fuzzylocation->location_type, \"\\n\";\n\n=head1 DESCRIPTION\n\nThis module contains the necessary methods for representing a\nFuzzy Location, one that does not have clear start and/or end points.\nThis will initially serve to handle features from Genbank/EMBL feature\ntables that are written as 1^100 meaning between bases 1 and 100 or\nE<lt>100..300 meaning it starts somewhere before 100.  Advanced\nimplementations of this interface may be able to handle the necessary\nlogic of overlaps/intersection/contains/union.  It was constructed to\nhandle fuzzy locations that can be represented in Genbank/EMBL and\nSwissprot.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Location::Fuzzy;\nuse strict;\n\nuse base qw(Bio::Location::Atomic Bio::Location::FuzzyLocationI);\n\nour @LOCATIONCODESBSANE = (undef, 'EXACT', 'WITHIN', 'BETWEEN', 'UNCERTAIN',\n            'BEFORE', 'AFTER');\n\nour %FUZZYCODES = ( 'EXACT' => '..', # Position is 'exact\n   # Exact position is unknown, but is within the range specified, ((1.2)..100)\n            'WITHIN' => '.', \n            # 1^2\n            'BETWEEN'    => '^',\n            'IN-BETWEEN' => '^',\n            'UNCERTAIN'  => '?',\n            # <100\n            'BEFORE'  => '<',\n            # >10\n            'AFTER'   => '>');   \n   \n    # The following regular expressions map to fuzzy location types. Every\n    # expression must match the complete encoded point string, and must\n    # contain two groups identifying min and max. Empty matches are automatic.\n    # converted to undef, except for 'EXACT', for which max is set to equal\n    # min.\n    \nour %FUZZYPOINTENCODE = ( \n    '\\>(\\d+)(.{0})' => 'AFTER',\n    '\\<(.{0})(\\d+)' => 'BEFORE',\n    '(\\d+)'         => 'EXACT',\n    '\\?(\\d*)'       => 'UNCERTAIN',\n    '(\\d+)(.{0})\\>' => 'AFTER',\n    '(.{0})(\\d+)\\<' => 'BEFORE',\n    '(\\d+)\\.(\\d+)'  => 'WITHIN',\n    '(\\d+)\\^(\\d+)'  => 'BETWEEN',\n   );\n    \nour %FUZZYRANGEENCODE  = (  '\\.'   => 'WITHIN',\n                            '\\.\\.' => 'EXACT',\n                            '\\^'   => 'IN-BETWEEN' );\n\n=head2 new\n\n Title   : new\n Usage   : my $fuzzyloc = Bio::Location::Fuzzy->new( @args);\n Function:\n Returns : \n Args    : -start    => value for start  (initialize by superclass)\n           -end      => value for end    (initialize by superclass)\n           -strand   => value for strand (initialize by superclass)\n           -location_type => either ('EXACT','WITHIN','IN-BETWEEN',\n                             'UNCERTAIN') OR ( 1,2,3,4)\n           -start_ext=> extension for start - defaults to 0, \n           -start_fuz=  fuzzy code for start can be \n                      ('EXACT','WITHIN','BETWEEN','BEFORE','AFTER',\n                       'UNCERTAIN' ) OR\n                      a value 1 - 5 corresponding to index+1 above\n           -end_ext=> extension for end - defaults to 0, \n           -end_fuz=  fuzzy code for end can be \n                      ('EXACT','WITHIN','BETWEEN','BEFORE','AFTER',\n                       'UNCERTAIN') OR\n                      a value 1 - 5 corresponding to index+1 above\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($location_type, $start_ext, $start_fuz, $end_ext, $end_fuz) = \n        $self->_rearrange([ qw(LOCATION_TYPE START_EXT START_FUZ \n                   END_EXT END_FUZ )\n                ], @args);\n\n    $location_type  && $self->location_type($location_type);\n    $start_ext && $self->max_start($self->min_start + $start_ext);\n    $end_ext   && $self->max_end($self->min_end + $end_ext);\n    $start_fuz && $self->start_pos_type($start_fuz);\n    $end_fuz   && $self->end_pos_type($end_fuz);\n\n    return $self;\n}\n\n=head2 location_type\n\n  Title   : location_type\n  Usage   : my $location_type = $location->location_type();\n  Function: Get location type encoded as text\n  Returns : string ('EXACT', 'WITHIN', 'IN-BETWEEN', 'UNCERTAIN')\n  Args    : none\n\n\nsub location_type {\n    my ($self,$value) = @_;\n    if( defined $value || ! defined $self->{'_location_type'} ) {\n        $value = 'EXACT' unless defined $value;\n        if(! defined $FUZZYCODES{$value} )  {\n            $value = uc($value);\n            if( $value =~ /\\.\\./ ) {\n                $value = 'EXACT';\n            } elsif( $value =~ /^\\.$/ ) {\n                $value = 'WITHIN';\n            } elsif( $value =~ /\\^/ ) {\n                $value = 'IN-BETWEEN';\n                $self->throw(\"Use Bio::Location::Simple for IN-BETWEEN locations [\".\n                             $self->start. \"] and [\". $self->end. \"]\")\n                  if defined $self->start && defined $self->end &&\n                            ($self->end - 1 == $self->start);\n            } elsif( $value =~ /\\?/ ) {\n                $value = 'UNCERTAIN';\n            } elsif( $value ne 'EXACT' && $value ne 'WITHIN' && \n                        $value ne 'IN-BETWEEN' ) {\n                $self->throw(\"Did not specify a valid location type\");\n            }\n        }\n        $self->{'_location_type'} = $value;\n    }\n    return $self->{'_location_type'};\n}\n\n=head1 LocationI methods\n\n=head2 length\n\n  Title   : length\n  Usage   : $length = $fuzzy_loc->length();\n  Function: Get the length of this location.\n\n            Note that the length of a fuzzy location will always depend\n            on the currently active interpretation of start and end. The\n            result will therefore vary for different CoordinatePolicy objects.\n\n  Returns : an integer\n  Args    : none\n\n\n#sub length {\n#    my($self) = @_;\n#    return $self->SUPER::length() if( !$self->start || !$self->end);\n#    $self->warn('Length is not valid for a FuzzyLocation'); \n#    return 0;\n#}\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $fuzzy->start();\n  Function: get/set start of this range, handling fuzzy_starts\n  Returns : a positive integer representing the start of the location\n  Args    : start location on set (can be fuzzy point string)\n\n\nsub start {\n    my($self,$value) = @_;\n    if( defined $value ) {\n    my ($encode,$min,$max) = $self->_fuzzypointdecode($value);\n    $self->start_pos_type($encode);\n    $self->min_start($min);\n    $self->max_start($max);\n    }\n\n    $self->throw(\"Use Bio::Location::Simple for IN-BETWEEN locations [\"\n                 . $self->SUPER::start. \"] and [\". $self->SUPER::end. \"]\")\n    if $self->location_type eq 'IN-BETWEEN'  && defined $self->SUPER::end &&\n                  ($self->SUPER::end - 1 == $self->SUPER::start);\n\n    return $self->SUPER::start();\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $fuzzy->end();\n  Function: get/set end of this range, handling fuzzy_ends\n  Returns : a positive integer representing the end of the range\n  Args    : end location on set (can be fuzzy string)\n\n\nsub end {\n    my($self,$value) = @_;\n    if( defined $value ) {\n    my ($encode,$min,$max) = $self->_fuzzypointdecode($value);\n    $self->end_pos_type($encode);\n    $self->min_end($min);\n    $self->max_end($max);\n    }\n\n    $self->throw(\"Use Bio::Location::Simple for IN-BETWEEN locations [\".\n                 $self->SUPER::start. \"] and [\". $self->SUPER::end. \"]\")\n    if $self->location_type eq 'IN-BETWEEN' && defined $self->SUPER::start &&\n                ($self->SUPER::end - 1 == $self->SUPER::start);\n\n    return $self->SUPER::end();\n}\n\n=head2 min_start\n\n  Title   : min_start\n  Usage   : $min_start = $fuzzy->min_start();\n  Function: get/set the minimum starting point\n  Returns : the minimum starting point from the contained sublocations\n  Args    : integer or undef on set\n\n\nsub min_start {\n    my ($self,@args) = @_;\n\n    if(@args) {\n    $self->{'_min_start'} = $args[0]; # the value may be undef!\n    }\n    return $self->{'_min_start'};\n}\n\n=head2 max_start\n\n  Title   : max_start\n  Usage   : my $maxstart = $location->max_start();\n  Function: Get/set maximum starting location of feature startpoint  \n  Returns : integer or undef if no maximum starting point.\n  Args    : integer or undef on set\n\n\nsub max_start {\n    my ($self,@args) = @_;\n\n    if(@args) {\n        $self->{'_max_start'} = $args[0]; # the value may be undef!\n    }\n    return $self->{'_max_start'};\n}\n\n=head2 start_pos_type\n\n  Title   : start_pos_type\n  Usage   : my $start_pos_type = $location->start_pos_type();\n  Function: Get/set start position type.\n  Returns : type of position coded as text \n            ('BEFORE','AFTER','EXACT','WITHIN','BETWEEN','UNCERTAIN')\n  Args    : a string on set\n\n\nsub start_pos_type {\n    my ($self,$value) = @_;\n    if(defined $value &&  $value =~ /^\\d+$/ ) {\n        if( $value == 0 ) { $value = 'EXACT'; }\n        else { \n            my $v = $LOCATIONCODESBSANE[$value];\n            if( ! defined $v ) {\n                $self->warn(\"Provided value $value which I don't understand,\".\n                            \" reverting to 'EXACT'\");\n                $v = 'EXACT';\n            }\n            $value = $v;\n        }\n    }\n    if(defined($value)) {\n        $self->{'_start_pos_type'} = $value;\n    }\n    return $self->{'_start_pos_type'};\n}\n\n=head2 min_end\n\n  Title   : min_end\n  Usage   : my $minend = $location->min_end();\n  Function: Get/set minimum ending location of feature endpoint \n  Returns : integer or undef if no minimum ending point.\n  Args    : integer or undef on set\n\n\nsub min_end {\n    my ($self,@args) = @_;\n\n    if(@args) {\n        $self->{'_min_end'} = $args[0]; # the value may be undef!\n    }\n    return $self->{'_min_end'};\n}\n\n=head2 max_end\n\n  Title   : max_end\n  Usage   : my $maxend = $location->max_end();\n  Function: Get/set maximum ending location of feature endpoint \n  Returns : integer or undef if no maximum ending point.\n  Args    : integer or undef on set\n\n\nsub max_end {\n    my ($self,@args) = @_;\n\n    if(@args) {\n        $self->{'_max_end'} = $args[0]; # the value may be undef!\n    }\n    return $self->{'_max_end'};\n}\n\n=head2 end_pos_type\n\n  Title   : end_pos_type\n  Usage   : my $end_pos_type = $location->end_pos_type();\n  Function: Get/set end position type.\n  Returns : type of position coded as text \n            ('BEFORE','AFTER','EXACT','WITHIN','BETWEEN','UNCERTAIN')\n  Args    : a string on set\n\n\nsub end_pos_type {\n    my ($self,$value) = @_;\n    if( defined $value && $value =~ /^\\d+$/ ) {\n        if( $value == 0 ) { $value = 'EXACT'; }\n        else { \n            my $v = $LOCATIONCODESBSANE[$value];\n            if( ! defined $v ) {\n                $self->warn(\"Provided value $value which I don't understand,\".\n                            \" reverting to 'EXACT'\");\n                $v = 'EXACT';\n            }\n            $value = $v;\n        }\n    }\n\n    if(defined($value)) {\n        $self->{'_end_pos_type'} = $value;\n    }\n    return $self->{'_end_pos_type'};\n}\n\n=head2 seq_id\n\n  Title   : seq_id\n  Usage   : my $seqid = $location->seq_id();\n  Function: Get/Set seq_id that location refers to\n  Returns : seq_id\n  Args    : [optional] seq_id value to set\n\n\n=head2 coordinate_policy\n\n  Title   : coordinate_policy\n\n  Usage   : $policy = $location->coordinate_policy();\n            $location->coordinate_policy($mypolicy); # set may not be possible\n  Function: Get the coordinate computing policy employed by this object.\n\n            See Bio::Location::CoordinatePolicyI for documentation about\n            the policy object and its use.\n\n            The interface *does not* require implementing classes to accept\n            setting of a different policy. The implementation provided here\n            does, however, allow to do so.\n\n            Implementors of this interface are expected to initialize every\n            new instance with a CoordinatePolicyI object. The implementation\n            provided here will return a default policy object if none has\n            been set yet. To change this default policy object call this\n            method as a class method with an appropriate argument. Note that\n            in this case only subsequently created Location objects will be\n            affected.\n\n  Returns : A Bio::Location::CoordinatePolicyI implementing object.\n  Args    : On set, a Bio::Location::CoordinatePolicyI implementing object.\n\nSee L<Bio::Location::CoordinatePolicyI>\n\n\n=head2 to_FTstring\n\n  Title   : to_FTstring\n  Usage   : my $locstr = $location->to_FTstring()\n  Function: Get/Set seq_id that location refers to\n  Returns : seq_id\n  Args    : [optional] seq_id value to set"}},{"containerName":"main::","name":"_fuzzypointdecode","children":[{"definition":"my","line":581,"containerName":"_fuzzypointdecode","localvar":"my","kind":13,"name":"$self"},{"line":581,"containerName":"_fuzzypointdecode","kind":13,"name":"$string"},{"kind":13,"containerName":"_fuzzypointdecode","name":"$string","line":582},{"line":584,"name":"$string","kind":13,"containerName":"_fuzzypointdecode"},{"definition":"my","line":585,"containerName":"_fuzzypointdecode","localvar":"my","kind":13,"name":"$pattern"},{"kind":13,"containerName":"_fuzzypointdecode","name":"%FUZZYPOINTENCODE","line":585},{"containerName":"_fuzzypointdecode","kind":13,"name":"$string","line":586},{"name":"$min","containerName":"_fuzzypointdecode","localvar":"my","kind":13,"line":587,"definition":"my"},{"name":"$max","kind":13,"containerName":"_fuzzypointdecode","line":587},{"line":588,"containerName":"_fuzzypointdecode","kind":13,"name":"$FUZZYPOINTENCODE"},{"containerName":"_fuzzypointdecode","kind":13,"name":"$pattern","line":588},{"line":589,"name":"$FUZZYPOINTENCODE","kind":13,"containerName":"_fuzzypointdecode"},{"name":"$pattern","containerName":"_fuzzypointdecode","kind":13,"line":589},{"line":591,"kind":13,"containerName":"_fuzzypointdecode","name":"$max"},{"name":"$min","kind":13,"containerName":"_fuzzypointdecode","line":591},{"name":"$max","containerName":"_fuzzypointdecode","kind":13,"line":593},{"line":593,"kind":13,"containerName":"_fuzzypointdecode","name":"$max"},{"line":593,"name":"$max","kind":13,"containerName":"_fuzzypointdecode"},{"containerName":"_fuzzypointdecode","kind":13,"name":"$min","line":594},{"line":594,"containerName":"_fuzzypointdecode","kind":13,"name":"$min"},{"line":594,"name":"$min","containerName":"_fuzzypointdecode","kind":13},{"line":596,"name":"$FUZZYPOINTENCODE","kind":13,"containerName":"_fuzzypointdecode"},{"line":596,"containerName":"_fuzzypointdecode","kind":13,"name":"$pattern"},{"name":"$min","containerName":"_fuzzypointdecode","kind":13,"line":596},{"name":"$max","containerName":"_fuzzypointdecode","kind":13,"line":596},{"line":599,"kind":13,"containerName":"_fuzzypointdecode","name":"$self"},{"line":599,"name":"verbose","containerName":"_fuzzypointdecode","kind":12},{"name":"$self","containerName":"_fuzzypointdecode","kind":13,"line":600},{"name":"warn","containerName":"_fuzzypointdecode","kind":12,"line":600}],"detail":"($self,$string)","definition":"sub","kind":12,"range":{"end":{"line":603,"character":9999},"start":{"character":0,"line":580}},"line":580,"signature":{"parameters":[{"label":"$self"},{"label":"$string"}],"documentation":"1;\n# $Id: Fuzzy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::Fuzzy\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::Fuzzy - Implementation of a Location on a Sequence\nwhich has unclear start and/or end locations\n\n=head1 SYNOPSIS\n\n    use Bio::Location::Fuzzy;\n    my $fuzzylocation = Bio::Location::Fuzzy->new(\n                                                 -start => '<30',\n                                                 -end   => 90,\n                                                 -location_type => '..');\n\n    print \"location string is \", $fuzzylocation->to_FTstring(), \"\\n\";\n    print \"location is of the type \", $fuzzylocation->location_type, \"\\n\";\n\n=head1 DESCRIPTION\n\nThis module contains the necessary methods for representing a\nFuzzy Location, one that does not have clear start and/or end points.\nThis will initially serve to handle features from Genbank/EMBL feature\ntables that are written as 1^100 meaning between bases 1 and 100 or\nE<lt>100..300 meaning it starts somewhere before 100.  Advanced\nimplementations of this interface may be able to handle the necessary\nlogic of overlaps/intersection/contains/union.  It was constructed to\nhandle fuzzy locations that can be represented in Genbank/EMBL and\nSwissprot.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Location::Fuzzy;\nuse strict;\n\nuse base qw(Bio::Location::Atomic Bio::Location::FuzzyLocationI);\n\nour @LOCATIONCODESBSANE = (undef, 'EXACT', 'WITHIN', 'BETWEEN', 'UNCERTAIN',\n            'BEFORE', 'AFTER');\n\nour %FUZZYCODES = ( 'EXACT' => '..', # Position is 'exact\n   # Exact position is unknown, but is within the range specified, ((1.2)..100)\n            'WITHIN' => '.', \n            # 1^2\n            'BETWEEN'    => '^',\n            'IN-BETWEEN' => '^',\n            'UNCERTAIN'  => '?',\n            # <100\n            'BEFORE'  => '<',\n            # >10\n            'AFTER'   => '>');   \n   \n    # The following regular expressions map to fuzzy location types. Every\n    # expression must match the complete encoded point string, and must\n    # contain two groups identifying min and max. Empty matches are automatic.\n    # converted to undef, except for 'EXACT', for which max is set to equal\n    # min.\n    \nour %FUZZYPOINTENCODE = ( \n    '\\>(\\d+)(.{0})' => 'AFTER',\n    '\\<(.{0})(\\d+)' => 'BEFORE',\n    '(\\d+)'         => 'EXACT',\n    '\\?(\\d*)'       => 'UNCERTAIN',\n    '(\\d+)(.{0})\\>' => 'AFTER',\n    '(.{0})(\\d+)\\<' => 'BEFORE',\n    '(\\d+)\\.(\\d+)'  => 'WITHIN',\n    '(\\d+)\\^(\\d+)'  => 'BETWEEN',\n   );\n    \nour %FUZZYRANGEENCODE  = (  '\\.'   => 'WITHIN',\n                            '\\.\\.' => 'EXACT',\n                            '\\^'   => 'IN-BETWEEN' );\n\n=head2 new\n\n Title   : new\n Usage   : my $fuzzyloc = Bio::Location::Fuzzy->new( @args);\n Function:\n Returns : \n Args    : -start    => value for start  (initialize by superclass)\n           -end      => value for end    (initialize by superclass)\n           -strand   => value for strand (initialize by superclass)\n           -location_type => either ('EXACT','WITHIN','IN-BETWEEN',\n                             'UNCERTAIN') OR ( 1,2,3,4)\n           -start_ext=> extension for start - defaults to 0, \n           -start_fuz=  fuzzy code for start can be \n                      ('EXACT','WITHIN','BETWEEN','BEFORE','AFTER',\n                       'UNCERTAIN' ) OR\n                      a value 1 - 5 corresponding to index+1 above\n           -end_ext=> extension for end - defaults to 0, \n           -end_fuz=  fuzzy code for end can be \n                      ('EXACT','WITHIN','BETWEEN','BEFORE','AFTER',\n                       'UNCERTAIN') OR\n                      a value 1 - 5 corresponding to index+1 above\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($location_type, $start_ext, $start_fuz, $end_ext, $end_fuz) = \n        $self->_rearrange([ qw(LOCATION_TYPE START_EXT START_FUZ \n                   END_EXT END_FUZ )\n                ], @args);\n\n    $location_type  && $self->location_type($location_type);\n    $start_ext && $self->max_start($self->min_start + $start_ext);\n    $end_ext   && $self->max_end($self->min_end + $end_ext);\n    $start_fuz && $self->start_pos_type($start_fuz);\n    $end_fuz   && $self->end_pos_type($end_fuz);\n\n    return $self;\n}\n\n=head2 location_type\n\n  Title   : location_type\n  Usage   : my $location_type = $location->location_type();\n  Function: Get location type encoded as text\n  Returns : string ('EXACT', 'WITHIN', 'IN-BETWEEN', 'UNCERTAIN')\n  Args    : none\n\n\nsub location_type {\n    my ($self,$value) = @_;\n    if( defined $value || ! defined $self->{'_location_type'} ) {\n        $value = 'EXACT' unless defined $value;\n        if(! defined $FUZZYCODES{$value} )  {\n            $value = uc($value);\n            if( $value =~ /\\.\\./ ) {\n                $value = 'EXACT';\n            } elsif( $value =~ /^\\.$/ ) {\n                $value = 'WITHIN';\n            } elsif( $value =~ /\\^/ ) {\n                $value = 'IN-BETWEEN';\n                $self->throw(\"Use Bio::Location::Simple for IN-BETWEEN locations [\".\n                             $self->start. \"] and [\". $self->end. \"]\")\n                  if defined $self->start && defined $self->end &&\n                            ($self->end - 1 == $self->start);\n            } elsif( $value =~ /\\?/ ) {\n                $value = 'UNCERTAIN';\n            } elsif( $value ne 'EXACT' && $value ne 'WITHIN' && \n                        $value ne 'IN-BETWEEN' ) {\n                $self->throw(\"Did not specify a valid location type\");\n            }\n        }\n        $self->{'_location_type'} = $value;\n    }\n    return $self->{'_location_type'};\n}\n\n=head1 LocationI methods\n\n=head2 length\n\n  Title   : length\n  Usage   : $length = $fuzzy_loc->length();\n  Function: Get the length of this location.\n\n            Note that the length of a fuzzy location will always depend\n            on the currently active interpretation of start and end. The\n            result will therefore vary for different CoordinatePolicy objects.\n\n  Returns : an integer\n  Args    : none\n\n\n#sub length {\n#    my($self) = @_;\n#    return $self->SUPER::length() if( !$self->start || !$self->end);\n#    $self->warn('Length is not valid for a FuzzyLocation'); \n#    return 0;\n#}\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $fuzzy->start();\n  Function: get/set start of this range, handling fuzzy_starts\n  Returns : a positive integer representing the start of the location\n  Args    : start location on set (can be fuzzy point string)\n\n\nsub start {\n    my($self,$value) = @_;\n    if( defined $value ) {\n    my ($encode,$min,$max) = $self->_fuzzypointdecode($value);\n    $self->start_pos_type($encode);\n    $self->min_start($min);\n    $self->max_start($max);\n    }\n\n    $self->throw(\"Use Bio::Location::Simple for IN-BETWEEN locations [\"\n                 . $self->SUPER::start. \"] and [\". $self->SUPER::end. \"]\")\n    if $self->location_type eq 'IN-BETWEEN'  && defined $self->SUPER::end &&\n                  ($self->SUPER::end - 1 == $self->SUPER::start);\n\n    return $self->SUPER::start();\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $fuzzy->end();\n  Function: get/set end of this range, handling fuzzy_ends\n  Returns : a positive integer representing the end of the range\n  Args    : end location on set (can be fuzzy string)\n\n\nsub end {\n    my($self,$value) = @_;\n    if( defined $value ) {\n    my ($encode,$min,$max) = $self->_fuzzypointdecode($value);\n    $self->end_pos_type($encode);\n    $self->min_end($min);\n    $self->max_end($max);\n    }\n\n    $self->throw(\"Use Bio::Location::Simple for IN-BETWEEN locations [\".\n                 $self->SUPER::start. \"] and [\". $self->SUPER::end. \"]\")\n    if $self->location_type eq 'IN-BETWEEN' && defined $self->SUPER::start &&\n                ($self->SUPER::end - 1 == $self->SUPER::start);\n\n    return $self->SUPER::end();\n}\n\n=head2 min_start\n\n  Title   : min_start\n  Usage   : $min_start = $fuzzy->min_start();\n  Function: get/set the minimum starting point\n  Returns : the minimum starting point from the contained sublocations\n  Args    : integer or undef on set\n\n\nsub min_start {\n    my ($self,@args) = @_;\n\n    if(@args) {\n    $self->{'_min_start'} = $args[0]; # the value may be undef!\n    }\n    return $self->{'_min_start'};\n}\n\n=head2 max_start\n\n  Title   : max_start\n  Usage   : my $maxstart = $location->max_start();\n  Function: Get/set maximum starting location of feature startpoint  \n  Returns : integer or undef if no maximum starting point.\n  Args    : integer or undef on set\n\n\nsub max_start {\n    my ($self,@args) = @_;\n\n    if(@args) {\n        $self->{'_max_start'} = $args[0]; # the value may be undef!\n    }\n    return $self->{'_max_start'};\n}\n\n=head2 start_pos_type\n\n  Title   : start_pos_type\n  Usage   : my $start_pos_type = $location->start_pos_type();\n  Function: Get/set start position type.\n  Returns : type of position coded as text \n            ('BEFORE','AFTER','EXACT','WITHIN','BETWEEN','UNCERTAIN')\n  Args    : a string on set\n\n\nsub start_pos_type {\n    my ($self,$value) = @_;\n    if(defined $value &&  $value =~ /^\\d+$/ ) {\n        if( $value == 0 ) { $value = 'EXACT'; }\n        else { \n            my $v = $LOCATIONCODESBSANE[$value];\n            if( ! defined $v ) {\n                $self->warn(\"Provided value $value which I don't understand,\".\n                            \" reverting to 'EXACT'\");\n                $v = 'EXACT';\n            }\n            $value = $v;\n        }\n    }\n    if(defined($value)) {\n        $self->{'_start_pos_type'} = $value;\n    }\n    return $self->{'_start_pos_type'};\n}\n\n=head2 min_end\n\n  Title   : min_end\n  Usage   : my $minend = $location->min_end();\n  Function: Get/set minimum ending location of feature endpoint \n  Returns : integer or undef if no minimum ending point.\n  Args    : integer or undef on set\n\n\nsub min_end {\n    my ($self,@args) = @_;\n\n    if(@args) {\n        $self->{'_min_end'} = $args[0]; # the value may be undef!\n    }\n    return $self->{'_min_end'};\n}\n\n=head2 max_end\n\n  Title   : max_end\n  Usage   : my $maxend = $location->max_end();\n  Function: Get/set maximum ending location of feature endpoint \n  Returns : integer or undef if no maximum ending point.\n  Args    : integer or undef on set\n\n\nsub max_end {\n    my ($self,@args) = @_;\n\n    if(@args) {\n        $self->{'_max_end'} = $args[0]; # the value may be undef!\n    }\n    return $self->{'_max_end'};\n}\n\n=head2 end_pos_type\n\n  Title   : end_pos_type\n  Usage   : my $end_pos_type = $location->end_pos_type();\n  Function: Get/set end position type.\n  Returns : type of position coded as text \n            ('BEFORE','AFTER','EXACT','WITHIN','BETWEEN','UNCERTAIN')\n  Args    : a string on set\n\n\nsub end_pos_type {\n    my ($self,$value) = @_;\n    if( defined $value && $value =~ /^\\d+$/ ) {\n        if( $value == 0 ) { $value = 'EXACT'; }\n        else { \n            my $v = $LOCATIONCODESBSANE[$value];\n            if( ! defined $v ) {\n                $self->warn(\"Provided value $value which I don't understand,\".\n                            \" reverting to 'EXACT'\");\n                $v = 'EXACT';\n            }\n            $value = $v;\n        }\n    }\n\n    if(defined($value)) {\n        $self->{'_end_pos_type'} = $value;\n    }\n    return $self->{'_end_pos_type'};\n}\n\n=head2 seq_id\n\n  Title   : seq_id\n  Usage   : my $seqid = $location->seq_id();\n  Function: Get/Set seq_id that location refers to\n  Returns : seq_id\n  Args    : [optional] seq_id value to set\n\n\n=head2 coordinate_policy\n\n  Title   : coordinate_policy\n\n  Usage   : $policy = $location->coordinate_policy();\n            $location->coordinate_policy($mypolicy); # set may not be possible\n  Function: Get the coordinate computing policy employed by this object.\n\n            See Bio::Location::CoordinatePolicyI for documentation about\n            the policy object and its use.\n\n            The interface *does not* require implementing classes to accept\n            setting of a different policy. The implementation provided here\n            does, however, allow to do so.\n\n            Implementors of this interface are expected to initialize every\n            new instance with a CoordinatePolicyI object. The implementation\n            provided here will return a default policy object if none has\n            been set yet. To change this default policy object call this\n            method as a class method with an appropriate argument. Note that\n            in this case only subsequently created Location objects will be\n            affected.\n\n  Returns : A Bio::Location::CoordinatePolicyI implementing object.\n  Args    : On set, a Bio::Location::CoordinatePolicyI implementing object.\n\nSee L<Bio::Location::CoordinatePolicyI>\n\n\n=head2 to_FTstring\n\n  Title   : to_FTstring\n  Usage   : my $locstr = $location->to_FTstring()\n  Function: Get/Set seq_id that location refers to\n  Returns : seq_id\n  Args    : [optional] seq_id value to set\n\n\nsub to_FTstring {\n    my ($self) = @_;    \n    my (%vals) = ( 'start' => $self->start,\n           'min_start' => $self->min_start,\n           'max_start' => $self->max_start,\n           'start_code' => $self->start_pos_type,\n           'end' => $self->end,\n           'min_end' => $self->min_end,\n           'max_end' => $self->max_end,\n           'end_code' => $self->end_pos_type );\n\n    my (%strs) = ( 'start' => '',\n           'end'   => '');\n    my ($delimiter) = $FUZZYCODES{$self->location_type};\n    $delimiter = $FUZZYCODES{'EXACT'} if ($self->location_type eq 'UNCERTAIN');\n    \n    my $policy = ref($self->coordinate_policy);\n    \n    # I'm lazy, lets do this in a loop since behaviour will be the same for \n    # start and end\n    # The CoordinatePolicy now dictates start/end data here (bug 992) - cjf\n    foreach my $point ( qw(start end) ) {\n        if( ($vals{$point.\"_code\"} ne 'EXACT') &&\n            ($vals{$point.\"_code\"} ne 'UNCERTAIN') ) {\n            \n            # must have max and min defined to use 'WITHIN', 'BETWEEN'\n            if ((!defined $vals{\"min_$point\"} ||\n                 !defined $vals{\"max_$point\"}) && \n                ( $vals{$point.\"_code\"} eq 'WITHIN' || \n                  $vals{$point.\"_code\"} eq 'BETWEEN'))\n            {\n                $vals{\"min_$point\"} = '' unless defined $vals{\"min_$point\"};\n                $vals{\"max_$point\"} = '' unless defined $vals{\"max_$point\"};\n                \n                $self->warn(\"Fuzzy codes for start are in a strange state, (\".\n                        join(\",\", ($vals{\"min_$point\"}, \n                               $vals{\"max_$point\"},\n                               $vals{$point.\"_code\"})). \")\");\n                return '';\n            }\n            \n            if (defined $vals{$point.\"_code\"} && \n               ($vals{$point.\"_code\"} eq 'BEFORE' ||\n                $vals{$point.\"_code\"} eq 'AFTER'))\n            {\n                $strs{$point} .= $FUZZYCODES{$vals{$point.\"_code\"}};\n                $strs{$point} .= $vals{\"$point\"};\n            }\n \n            if( defined $vals{$point.\"_code\"} && \n              ($vals{$point.\"_code\"} eq 'WITHIN' ||\n               $vals{$point.\"_code\"} eq 'BETWEEN'))\n            {\n                # Expect odd results with anything but WidestCoordPolicy for now\n                $strs{$point} .= ($point eq 'start') ?\n                        $vals{\"$point\"}.\n                        $FUZZYCODES{$vals{$point.\"_code\"}}.\n                        $vals{'max_'.$point}\n                        :\n                        $vals{'min_'.$point}.\n                        $FUZZYCODES{$vals{$point.\"_code\"}}.\n                        $vals{\"$point\"};\n                $strs{$point} = \"(\".$strs{$point}.\")\";\n            }\n            \n        } elsif ($vals{$point.\"_code\"} eq 'UNCERTAIN') {\n            $strs{$point}  = $FUZZYCODES{$vals{$point.\"_code\"}};\n            $strs{$point} .= $vals{$point} if defined $vals{$point};\n        } else {\n            $strs{$point} = $vals{$point};\n        }\n    }\n    \n    my $str = $strs{'start'} . $delimiter . $strs{'end'};\n    if($self->is_remote() && $self->seq_id()) {\n    $str = $self->seq_id() . \":\" . $str;\n    }\n    if( defined $self->strand && \n    $self->strand == -1 &&\n    $self->location_type() ne \"UNCERTAIN\") {\n    $str = \"complement(\" . $str . \")\";\n    } elsif($self->location_type() eq \"WITHIN\") {\n    $str = \"(\".$str.\")\";\n    }\n    return $str;\n}\n\n=head2 valid_Location\n\n Title   : valid_Location\n Usage   : if ($location->valid_location) {...};\n Function: boolean method to determine whether location is considered valid\n           (has minimum requirements for Simple implementation)\n Returns : Boolean value: true if location is valid, false otherwise\n Args    : none\n\n\n=head2 _fuzzypointdecode\n\n  Title   : _fuzzypointdecode\n  Usage   : ($type,$min,$max) = $self->_fuzzypointdecode('<5');\n  Function: Decode a fuzzy string.\n  Returns : A 3-element array consisting of the type of location, the\n            minimum integer, and the maximum integer describing the range\n            of coordinates this start or endpoint refers to. Minimum or\n            maximum coordinate may be undefined.\n          : Returns empty array on fail.\n  Args    : fuzzypoint string","label":"_fuzzypointdecode($self,$string)"}}]}