{"version":5,"vars":[{"containerName":"","kind":2,"name":"base","line":97},{"signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"","label":"new($class,@args)"},"range":{"end":{"line":119,"character":9999},"start":{"character":0,"line":99}},"kind":12,"line":99,"detail":"($class,@args)","definition":"sub","containerName":"main::","name":"new","children":[{"line":100,"localvar":"my","kind":13,"containerName":"new","name":"$class","definition":"my"},{"containerName":"new","kind":13,"name":"@args","line":100},{"definition":"my","line":101,"name":"$self","localvar":"my","kind":13,"containerName":"new"},{"name":"$self","containerName":"new","kind":13,"line":102},{"line":103,"kind":13,"containerName":"new","name":"$self"},{"name":"$class","containerName":"new","kind":13,"line":103},{"definition":"my","line":105,"localvar":"my","containerName":"new","kind":13,"name":"$gene"},{"name":"$numbering","containerName":"new","kind":13,"line":105},{"kind":13,"containerName":"new","name":"$self","line":106},{"line":106,"containerName":"new","kind":12,"name":"_rearrange"},{"containerName":"new","kind":13,"name":"@args","line":109},{"line":111,"name":"$self","containerName":"new","kind":13},{"line":113,"name":"$gene","containerName":"new","kind":13},{"line":113,"name":"$self","kind":13,"containerName":"new"},{"containerName":"new","kind":12,"name":"gene","line":113},{"line":113,"kind":13,"containerName":"new","name":"$gene"},{"line":114,"kind":13,"containerName":"new","name":"$numbering"},{"line":114,"name":"$self","containerName":"new","kind":13},{"line":114,"kind":12,"containerName":"new","name":"numbering"},{"line":114,"name":"$numbering","kind":13,"containerName":"new"},{"name":"$self","containerName":"new","kind":13,"line":117},{"name":"$self","containerName":"new","kind":13,"line":118}]},{"detail":"($self,$value)","definition":"sub","containerName":"main::","name":"gene","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"gene","name":"$self","line":140},{"containerName":"gene","kind":13,"name":"$value","line":140},{"line":141,"name":"$value","kind":13,"containerName":"gene"},{"name":"$value","containerName":"gene","kind":13,"line":142},{"line":142,"kind":12,"containerName":"gene","name":"isa"},{"name":"$self","containerName":"gene","kind":13,"line":143},{"name":"throw","kind":12,"containerName":"gene","line":143},{"name":"$self","kind":13,"containerName":"gene","line":147},{"name":"$value","kind":13,"containerName":"gene","line":147},{"containerName":"gene","kind":13,"name":"$self","line":150},{"kind":13,"containerName":"gene","name":"$self","line":153}],"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Mutator.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::Mutator\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::Mutator - Package mutating LiveSequences\n\n=head1 SYNOPSIS\n\n  # $gene is a Bio::LiveSeq::Gene object\n  my $mutate = Bio::LiveSeq::Mutator->new('-gene' => $gene,\n  \t\t\t\t\t  '-numbering' => \"coding\"\n  \t\t\t\t\t   );\n  # $mut is a Bio::LiveSeq::Mutation object\n  $mutate->add_Mutation($mut);\n  # $results is a Bio::Variation::SeqDiff object\n  my $results=$mutate->change_gene();\n  if ($results) {\n      my $out = Bio::Variation::IO->new( '-format' => 'flat');\n      $out->write($results);\n  }\n\n=head1 DESCRIPTION\n\nThis class mutates Bio::LiveSeq::Gene objects and returns a\nBio::Variation::SeqDiff object. Mutations are described as\nBio::LiveSeq::Mutation objects. See L<Bio::LiveSeq::Gene>,\nL<Bio::Variation::SeqDiff>, and L<Bio::LiveSeq::Mutation> for details.\n\n=head1 FEEDBACK\n\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho & Joseph A.L. Insana\n\n  Email:  heikki-at-bioperl-dot-org\n          insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\n  The rest of the documentation details each of the object\n  methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::Mutator;\nuse strict;\n\nuse Bio::Variation::SeqDiff;\nuse Bio::Variation::DNAMutation;\nuse Bio::Variation::RNAChange;\nuse Bio::Variation::AAChange;\nuse Bio::Variation::Allele;\nuse Bio::LiveSeq::Mutation;\n\n#use integer;\n# Object preamble - inheritance\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n    my($class,@args) = @_;\n    my $self;\n    $self = {};\n    bless $self, $class;\n\n    my ($gene, $numbering) =\n\t    $self->_rearrange([qw(GENE\n\t\t\t\t  NUMBERING\n\t\t\t\t  )],\n\t\t\t      @args);\n\n    $self->{ 'mutations' } = [];\n\n    $gene && $self->gene($gene);\n    $numbering && $self->numbering($numbering);\n\n    #class constant;\n    $self->{'flanklen'} = 25;\n    return $self; # success - we hope!\n}\n\n=head2 gene\n\n Title   : gene\n Usage   : $mutobj = $obj->gene;\n         : $mutobj = $obj->gene($objref);\n Function:\n\n           Returns or sets the link-reference to a\n           Bio::LiveSeq::Gene object. If no value has ben set, it\n           will return undef\n\n Returns : an object reference  or undef\n Args    : a Bio::LiveSeq::Gene\n\nSee L<Bio::LiveSeq::Gene> for more information.","label":"gene($self,$value)"},"range":{"end":{"line":155,"character":9999},"start":{"character":0,"line":139}},"kind":12,"line":139},{"line":174,"range":{"end":{"line":188,"character":9999},"start":{"line":174,"character":0}},"kind":12,"signature":{"label":"numbering($self,$value)","documentation":"1;\n# $Id: Mutator.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::Mutator\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::Mutator - Package mutating LiveSequences\n\n=head1 SYNOPSIS\n\n  # $gene is a Bio::LiveSeq::Gene object\n  my $mutate = Bio::LiveSeq::Mutator->new('-gene' => $gene,\n  \t\t\t\t\t  '-numbering' => \"coding\"\n  \t\t\t\t\t   );\n  # $mut is a Bio::LiveSeq::Mutation object\n  $mutate->add_Mutation($mut);\n  # $results is a Bio::Variation::SeqDiff object\n  my $results=$mutate->change_gene();\n  if ($results) {\n      my $out = Bio::Variation::IO->new( '-format' => 'flat');\n      $out->write($results);\n  }\n\n=head1 DESCRIPTION\n\nThis class mutates Bio::LiveSeq::Gene objects and returns a\nBio::Variation::SeqDiff object. Mutations are described as\nBio::LiveSeq::Mutation objects. See L<Bio::LiveSeq::Gene>,\nL<Bio::Variation::SeqDiff>, and L<Bio::LiveSeq::Mutation> for details.\n\n=head1 FEEDBACK\n\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho & Joseph A.L. Insana\n\n  Email:  heikki-at-bioperl-dot-org\n          insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\n  The rest of the documentation details each of the object\n  methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::Mutator;\nuse strict;\n\nuse Bio::Variation::SeqDiff;\nuse Bio::Variation::DNAMutation;\nuse Bio::Variation::RNAChange;\nuse Bio::Variation::AAChange;\nuse Bio::Variation::Allele;\nuse Bio::LiveSeq::Mutation;\n\n#use integer;\n# Object preamble - inheritance\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n    my($class,@args) = @_;\n    my $self;\n    $self = {};\n    bless $self, $class;\n\n    my ($gene, $numbering) =\n\t    $self->_rearrange([qw(GENE\n\t\t\t\t  NUMBERING\n\t\t\t\t  )],\n\t\t\t      @args);\n\n    $self->{ 'mutations' } = [];\n\n    $gene && $self->gene($gene);\n    $numbering && $self->numbering($numbering);\n\n    #class constant;\n    $self->{'flanklen'} = 25;\n    return $self; # success - we hope!\n}\n\n=head2 gene\n\n Title   : gene\n Usage   : $mutobj = $obj->gene;\n         : $mutobj = $obj->gene($objref);\n Function:\n\n           Returns or sets the link-reference to a\n           Bio::LiveSeq::Gene object. If no value has ben set, it\n           will return undef\n\n Returns : an object reference  or undef\n Args    : a Bio::LiveSeq::Gene\n\nSee L<Bio::LiveSeq::Gene> for more information.\n\n\nsub gene {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Gene') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::Gene object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'gene'} = $value;\n      }\n  }\n  unless (exists $self->{'gene'}) {\n      return;\n  } else {\n      return $self->{'gene'};\n  }\n}\n\n\n=head2 numbering\n\n Title   : numbering\n Usage   : $obj->numbering();\n Function:\n\n            Sets and returns coordinate system used in positioning the\n            mutations. See L<change_gene> for details.\n\n Example :\n Returns : string\n Args    : string (coding [transcript number] | gene | entry)","parameters":[{"label":"$self"},{"label":"$value"}]},"children":[{"line":175,"name":"$self","containerName":"numbering","localvar":"my","kind":13,"definition":"my"},{"line":175,"containerName":"numbering","kind":13,"name":"$value"},{"line":176,"name":"$value","kind":13,"containerName":"numbering"},{"line":177,"name":"$value","containerName":"numbering","kind":13},{"line":177,"containerName":"numbering","kind":13,"name":"$value"},{"name":"$value","kind":13,"containerName":"numbering","line":177},{"line":178,"name":"$self","containerName":"numbering","kind":13},{"containerName":"numbering","kind":13,"name":"$value","line":178},{"line":180,"name":"$self","kind":13,"containerName":"numbering"},{"kind":13,"containerName":"numbering","name":"$self","line":183},{"containerName":"numbering","kind":13,"name":"$self","line":186}],"name":"numbering","containerName":"main::","definition":"sub","detail":"($self,$value)"},{"kind":12,"range":{"start":{"line":203,"character":0},"end":{"line":218,"character":9999}},"line":203,"signature":{"documentation":"1;\n# $Id: Mutator.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::Mutator\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::Mutator - Package mutating LiveSequences\n\n=head1 SYNOPSIS\n\n  # $gene is a Bio::LiveSeq::Gene object\n  my $mutate = Bio::LiveSeq::Mutator->new('-gene' => $gene,\n  \t\t\t\t\t  '-numbering' => \"coding\"\n  \t\t\t\t\t   );\n  # $mut is a Bio::LiveSeq::Mutation object\n  $mutate->add_Mutation($mut);\n  # $results is a Bio::Variation::SeqDiff object\n  my $results=$mutate->change_gene();\n  if ($results) {\n      my $out = Bio::Variation::IO->new( '-format' => 'flat');\n      $out->write($results);\n  }\n\n=head1 DESCRIPTION\n\nThis class mutates Bio::LiveSeq::Gene objects and returns a\nBio::Variation::SeqDiff object. Mutations are described as\nBio::LiveSeq::Mutation objects. See L<Bio::LiveSeq::Gene>,\nL<Bio::Variation::SeqDiff>, and L<Bio::LiveSeq::Mutation> for details.\n\n=head1 FEEDBACK\n\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho & Joseph A.L. Insana\n\n  Email:  heikki-at-bioperl-dot-org\n          insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\n  The rest of the documentation details each of the object\n  methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::Mutator;\nuse strict;\n\nuse Bio::Variation::SeqDiff;\nuse Bio::Variation::DNAMutation;\nuse Bio::Variation::RNAChange;\nuse Bio::Variation::AAChange;\nuse Bio::Variation::Allele;\nuse Bio::LiveSeq::Mutation;\n\n#use integer;\n# Object preamble - inheritance\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n    my($class,@args) = @_;\n    my $self;\n    $self = {};\n    bless $self, $class;\n\n    my ($gene, $numbering) =\n\t    $self->_rearrange([qw(GENE\n\t\t\t\t  NUMBERING\n\t\t\t\t  )],\n\t\t\t      @args);\n\n    $self->{ 'mutations' } = [];\n\n    $gene && $self->gene($gene);\n    $numbering && $self->numbering($numbering);\n\n    #class constant;\n    $self->{'flanklen'} = 25;\n    return $self; # success - we hope!\n}\n\n=head2 gene\n\n Title   : gene\n Usage   : $mutobj = $obj->gene;\n         : $mutobj = $obj->gene($objref);\n Function:\n\n           Returns or sets the link-reference to a\n           Bio::LiveSeq::Gene object. If no value has ben set, it\n           will return undef\n\n Returns : an object reference  or undef\n Args    : a Bio::LiveSeq::Gene\n\nSee L<Bio::LiveSeq::Gene> for more information.\n\n\nsub gene {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Gene') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::Gene object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'gene'} = $value;\n      }\n  }\n  unless (exists $self->{'gene'}) {\n      return;\n  } else {\n      return $self->{'gene'};\n  }\n}\n\n\n=head2 numbering\n\n Title   : numbering\n Usage   : $obj->numbering();\n Function:\n\n            Sets and returns coordinate system used in positioning the\n            mutations. See L<change_gene> for details.\n\n Example :\n Returns : string\n Args    : string (coding [transcript number] | gene | entry)\n\n\n\nsub numbering {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif ($value =~ /(coding)( )?(\\d+)?/ or $value eq 'entry' or $value eq 'gene') {\n\t    $self->{'numbering'} = $value;\n\t} else { # defaulting to 'coding'\n\t    $self->{'numbering'} = 'coding';\n\t}\n    }\n    unless (exists $self->{'numbering'}) {\n\treturn 'coding';\n    } else {\n\treturn $self->{'numbering'};\n    }\n}\n\n=head2 add_Mutation\n\n Title   : add_Mutation\n Usage   : $self->add_Mutation($ref)\n Function: adds a Bio::LiveSeq::Mutation object\n Example :\n Returns :\n Args    : a Bio::LiveSeq::Mutation\n\nSee L<Bio::LiveSeq::Mutation> for more information.","parameters":[{"label":"$self"},{"label":"$value"}],"label":"add_Mutation($self,$value)"},"name":"add_Mutation","containerName":"main::","children":[{"definition":"my","line":204,"localvar":"my","containerName":"add_Mutation","kind":13,"name":"$self"},{"kind":13,"containerName":"add_Mutation","name":"$value","line":204},{"line":205,"name":"$value","containerName":"add_Mutation","kind":13},{"name":"isa","containerName":"add_Mutation","kind":12,"line":205},{"definition":"my","name":"$com","kind":13,"localvar":"my","containerName":"add_Mutation","line":206},{"kind":13,"containerName":"add_Mutation","name":"$value","line":206},{"kind":13,"containerName":"add_Mutation","name":"$self","line":207},{"containerName":"add_Mutation","kind":12,"name":"throw","line":207},{"containerName":"add_Mutation","kind":13,"name":"$value","line":210},{"line":210,"kind":12,"containerName":"add_Mutation","name":"pos"},{"line":211,"containerName":"add_Mutation","kind":13,"name":"$self"},{"kind":12,"containerName":"add_Mutation","name":"warn","line":211},{"line":214,"name":"$value","kind":13,"containerName":"add_Mutation"},{"kind":12,"containerName":"add_Mutation","name":"seq","line":214},{"name":"$value","containerName":"add_Mutation","kind":13,"line":214},{"line":214,"containerName":"add_Mutation","kind":12,"name":"len"},{"line":215,"containerName":"add_Mutation","kind":13,"name":"$self"},{"line":215,"name":"warn","containerName":"add_Mutation","kind":12},{"line":218,"name":"$self","kind":13,"containerName":"add_Mutation"}],"detail":"($self,$value)","definition":"sub"},{"name":"$value","kind":13,"containerName":null,"line":218},{"definition":"sub","detail":"($self)","children":[{"line":235,"localvar":"my","containerName":"each_Mutation","kind":13,"name":"$self","definition":"my"},{"containerName":"each_Mutation","kind":13,"name":"$self","line":236}],"name":"each_Mutation","containerName":"main::","signature":{"label":"each_Mutation($self)","documentation":"1;\n# $Id: Mutator.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::Mutator\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::Mutator - Package mutating LiveSequences\n\n=head1 SYNOPSIS\n\n  # $gene is a Bio::LiveSeq::Gene object\n  my $mutate = Bio::LiveSeq::Mutator->new('-gene' => $gene,\n  \t\t\t\t\t  '-numbering' => \"coding\"\n  \t\t\t\t\t   );\n  # $mut is a Bio::LiveSeq::Mutation object\n  $mutate->add_Mutation($mut);\n  # $results is a Bio::Variation::SeqDiff object\n  my $results=$mutate->change_gene();\n  if ($results) {\n      my $out = Bio::Variation::IO->new( '-format' => 'flat');\n      $out->write($results);\n  }\n\n=head1 DESCRIPTION\n\nThis class mutates Bio::LiveSeq::Gene objects and returns a\nBio::Variation::SeqDiff object. Mutations are described as\nBio::LiveSeq::Mutation objects. See L<Bio::LiveSeq::Gene>,\nL<Bio::Variation::SeqDiff>, and L<Bio::LiveSeq::Mutation> for details.\n\n=head1 FEEDBACK\n\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho & Joseph A.L. Insana\n\n  Email:  heikki-at-bioperl-dot-org\n          insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\n  The rest of the documentation details each of the object\n  methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::Mutator;\nuse strict;\n\nuse Bio::Variation::SeqDiff;\nuse Bio::Variation::DNAMutation;\nuse Bio::Variation::RNAChange;\nuse Bio::Variation::AAChange;\nuse Bio::Variation::Allele;\nuse Bio::LiveSeq::Mutation;\n\n#use integer;\n# Object preamble - inheritance\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n    my($class,@args) = @_;\n    my $self;\n    $self = {};\n    bless $self, $class;\n\n    my ($gene, $numbering) =\n\t    $self->_rearrange([qw(GENE\n\t\t\t\t  NUMBERING\n\t\t\t\t  )],\n\t\t\t      @args);\n\n    $self->{ 'mutations' } = [];\n\n    $gene && $self->gene($gene);\n    $numbering && $self->numbering($numbering);\n\n    #class constant;\n    $self->{'flanklen'} = 25;\n    return $self; # success - we hope!\n}\n\n=head2 gene\n\n Title   : gene\n Usage   : $mutobj = $obj->gene;\n         : $mutobj = $obj->gene($objref);\n Function:\n\n           Returns or sets the link-reference to a\n           Bio::LiveSeq::Gene object. If no value has ben set, it\n           will return undef\n\n Returns : an object reference  or undef\n Args    : a Bio::LiveSeq::Gene\n\nSee L<Bio::LiveSeq::Gene> for more information.\n\n\nsub gene {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Gene') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::Gene object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'gene'} = $value;\n      }\n  }\n  unless (exists $self->{'gene'}) {\n      return;\n  } else {\n      return $self->{'gene'};\n  }\n}\n\n\n=head2 numbering\n\n Title   : numbering\n Usage   : $obj->numbering();\n Function:\n\n            Sets and returns coordinate system used in positioning the\n            mutations. See L<change_gene> for details.\n\n Example :\n Returns : string\n Args    : string (coding [transcript number] | gene | entry)\n\n\n\nsub numbering {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif ($value =~ /(coding)( )?(\\d+)?/ or $value eq 'entry' or $value eq 'gene') {\n\t    $self->{'numbering'} = $value;\n\t} else { # defaulting to 'coding'\n\t    $self->{'numbering'} = 'coding';\n\t}\n    }\n    unless (exists $self->{'numbering'}) {\n\treturn 'coding';\n    } else {\n\treturn $self->{'numbering'};\n    }\n}\n\n=head2 add_Mutation\n\n Title   : add_Mutation\n Usage   : $self->add_Mutation($ref)\n Function: adds a Bio::LiveSeq::Mutation object\n Example :\n Returns :\n Args    : a Bio::LiveSeq::Mutation\n\nSee L<Bio::LiveSeq::Mutation> for more information.\n\n\nsub add_Mutation{\n    my ($self,$value) = @_;\n    if( $value->isa('Bio::Liveseq::Mutation') ) {\n\tmy $com = ref $value;\n\t$self->throw(\"Is not a Mutation object but a [$com]\" );\n\treturn;\n    }\n    if (! $value->pos) {\n\t$self->warn(\"No value for mutation position in the sequence!\");\n\treturn;\n    }\n    if (! $value->seq && ! $value->len) {\n\t$self->warn(\"Either mutated sequence or length of the deletion must be given!\");\n\treturn;\n    }\n    push(@{$self->{'mutations'}},$value);\n}\n\n=head2 each_Mutation\n\n Title   : each_Mutation\n Usage   : foreach $ref ( $a->each_Mutation )\n Function: gets an array of Bio::LiveSeq::Mutation objects\n Example :\n Returns : array of Mutations\n Args    :\n\nSee L<Bio::LiveSeq::Mutation> for more information.","parameters":[{"label":"$self"}]},"line":234,"range":{"end":{"line":236,"character":9999},"start":{"line":234,"character":0}},"kind":12},{"definition":"sub","detail":"($self,$value)","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"mutation","line":257},{"name":"$value","kind":13,"containerName":"mutation","line":257},{"name":"$value","containerName":"mutation","kind":13,"line":258},{"line":259,"containerName":"mutation","kind":13,"name":"$value"},{"name":"isa","kind":12,"containerName":"mutation","line":259},{"containerName":"mutation","kind":13,"name":"$self","line":260},{"line":260,"name":"throw","kind":12,"containerName":"mutation"},{"line":264,"kind":13,"containerName":"mutation","name":"$self"},{"line":264,"kind":13,"containerName":"mutation","name":"$value"},{"name":"$self","containerName":"mutation","kind":13,"line":267},{"name":"$self","containerName":"mutation","kind":13,"line":270}],"name":"mutation","containerName":"main::","signature":{"documentation":"1;\n# $Id: Mutator.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::Mutator\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::Mutator - Package mutating LiveSequences\n\n=head1 SYNOPSIS\n\n  # $gene is a Bio::LiveSeq::Gene object\n  my $mutate = Bio::LiveSeq::Mutator->new('-gene' => $gene,\n  \t\t\t\t\t  '-numbering' => \"coding\"\n  \t\t\t\t\t   );\n  # $mut is a Bio::LiveSeq::Mutation object\n  $mutate->add_Mutation($mut);\n  # $results is a Bio::Variation::SeqDiff object\n  my $results=$mutate->change_gene();\n  if ($results) {\n      my $out = Bio::Variation::IO->new( '-format' => 'flat');\n      $out->write($results);\n  }\n\n=head1 DESCRIPTION\n\nThis class mutates Bio::LiveSeq::Gene objects and returns a\nBio::Variation::SeqDiff object. Mutations are described as\nBio::LiveSeq::Mutation objects. See L<Bio::LiveSeq::Gene>,\nL<Bio::Variation::SeqDiff>, and L<Bio::LiveSeq::Mutation> for details.\n\n=head1 FEEDBACK\n\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho & Joseph A.L. Insana\n\n  Email:  heikki-at-bioperl-dot-org\n          insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\n  The rest of the documentation details each of the object\n  methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::Mutator;\nuse strict;\n\nuse Bio::Variation::SeqDiff;\nuse Bio::Variation::DNAMutation;\nuse Bio::Variation::RNAChange;\nuse Bio::Variation::AAChange;\nuse Bio::Variation::Allele;\nuse Bio::LiveSeq::Mutation;\n\n#use integer;\n# Object preamble - inheritance\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n    my($class,@args) = @_;\n    my $self;\n    $self = {};\n    bless $self, $class;\n\n    my ($gene, $numbering) =\n\t    $self->_rearrange([qw(GENE\n\t\t\t\t  NUMBERING\n\t\t\t\t  )],\n\t\t\t      @args);\n\n    $self->{ 'mutations' } = [];\n\n    $gene && $self->gene($gene);\n    $numbering && $self->numbering($numbering);\n\n    #class constant;\n    $self->{'flanklen'} = 25;\n    return $self; # success - we hope!\n}\n\n=head2 gene\n\n Title   : gene\n Usage   : $mutobj = $obj->gene;\n         : $mutobj = $obj->gene($objref);\n Function:\n\n           Returns or sets the link-reference to a\n           Bio::LiveSeq::Gene object. If no value has ben set, it\n           will return undef\n\n Returns : an object reference  or undef\n Args    : a Bio::LiveSeq::Gene\n\nSee L<Bio::LiveSeq::Gene> for more information.\n\n\nsub gene {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Gene') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::Gene object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'gene'} = $value;\n      }\n  }\n  unless (exists $self->{'gene'}) {\n      return;\n  } else {\n      return $self->{'gene'};\n  }\n}\n\n\n=head2 numbering\n\n Title   : numbering\n Usage   : $obj->numbering();\n Function:\n\n            Sets and returns coordinate system used in positioning the\n            mutations. See L<change_gene> for details.\n\n Example :\n Returns : string\n Args    : string (coding [transcript number] | gene | entry)\n\n\n\nsub numbering {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif ($value =~ /(coding)( )?(\\d+)?/ or $value eq 'entry' or $value eq 'gene') {\n\t    $self->{'numbering'} = $value;\n\t} else { # defaulting to 'coding'\n\t    $self->{'numbering'} = 'coding';\n\t}\n    }\n    unless (exists $self->{'numbering'}) {\n\treturn 'coding';\n    } else {\n\treturn $self->{'numbering'};\n    }\n}\n\n=head2 add_Mutation\n\n Title   : add_Mutation\n Usage   : $self->add_Mutation($ref)\n Function: adds a Bio::LiveSeq::Mutation object\n Example :\n Returns :\n Args    : a Bio::LiveSeq::Mutation\n\nSee L<Bio::LiveSeq::Mutation> for more information.\n\n\nsub add_Mutation{\n    my ($self,$value) = @_;\n    if( $value->isa('Bio::Liveseq::Mutation') ) {\n\tmy $com = ref $value;\n\t$self->throw(\"Is not a Mutation object but a [$com]\" );\n\treturn;\n    }\n    if (! $value->pos) {\n\t$self->warn(\"No value for mutation position in the sequence!\");\n\treturn;\n    }\n    if (! $value->seq && ! $value->len) {\n\t$self->warn(\"Either mutated sequence or length of the deletion must be given!\");\n\treturn;\n    }\n    push(@{$self->{'mutations'}},$value);\n}\n\n=head2 each_Mutation\n\n Title   : each_Mutation\n Usage   : foreach $ref ( $a->each_Mutation )\n Function: gets an array of Bio::LiveSeq::Mutation objects\n Example :\n Returns : array of Mutations\n Args    :\n\nSee L<Bio::LiveSeq::Mutation> for more information.\n\n\nsub each_Mutation{\n   my ($self) = @_;\n   return @{$self->{'mutations'}};\n}\n\n\n=head2 mutation\n\n Title   : mutation\n Usage   : $mutobj = $obj->mutation;\n         : $mutobj = $obj->mutation($objref);\n Function:\n\n           Returns or sets the link-reference to the current mutation\n           object.  If the value is not set, it will return undef.\n           Internal method.\n\n Returns : an object reference  or undef","parameters":[{"label":"$self"},{"label":"$value"}],"label":"mutation($self,$value)"},"line":256,"kind":12,"range":{"start":{"line":256,"character":0},"end":{"character":9999,"line":272}}},{"line":290,"range":{"start":{"character":0,"line":290},"end":{"character":9999,"line":306}},"kind":12,"signature":{"label":"DNA($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Mutator.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::Mutator\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::Mutator - Package mutating LiveSequences\n\n=head1 SYNOPSIS\n\n  # $gene is a Bio::LiveSeq::Gene object\n  my $mutate = Bio::LiveSeq::Mutator->new('-gene' => $gene,\n  \t\t\t\t\t  '-numbering' => \"coding\"\n  \t\t\t\t\t   );\n  # $mut is a Bio::LiveSeq::Mutation object\n  $mutate->add_Mutation($mut);\n  # $results is a Bio::Variation::SeqDiff object\n  my $results=$mutate->change_gene();\n  if ($results) {\n      my $out = Bio::Variation::IO->new( '-format' => 'flat');\n      $out->write($results);\n  }\n\n=head1 DESCRIPTION\n\nThis class mutates Bio::LiveSeq::Gene objects and returns a\nBio::Variation::SeqDiff object. Mutations are described as\nBio::LiveSeq::Mutation objects. See L<Bio::LiveSeq::Gene>,\nL<Bio::Variation::SeqDiff>, and L<Bio::LiveSeq::Mutation> for details.\n\n=head1 FEEDBACK\n\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho & Joseph A.L. Insana\n\n  Email:  heikki-at-bioperl-dot-org\n          insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\n  The rest of the documentation details each of the object\n  methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::Mutator;\nuse strict;\n\nuse Bio::Variation::SeqDiff;\nuse Bio::Variation::DNAMutation;\nuse Bio::Variation::RNAChange;\nuse Bio::Variation::AAChange;\nuse Bio::Variation::Allele;\nuse Bio::LiveSeq::Mutation;\n\n#use integer;\n# Object preamble - inheritance\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n    my($class,@args) = @_;\n    my $self;\n    $self = {};\n    bless $self, $class;\n\n    my ($gene, $numbering) =\n\t    $self->_rearrange([qw(GENE\n\t\t\t\t  NUMBERING\n\t\t\t\t  )],\n\t\t\t      @args);\n\n    $self->{ 'mutations' } = [];\n\n    $gene && $self->gene($gene);\n    $numbering && $self->numbering($numbering);\n\n    #class constant;\n    $self->{'flanklen'} = 25;\n    return $self; # success - we hope!\n}\n\n=head2 gene\n\n Title   : gene\n Usage   : $mutobj = $obj->gene;\n         : $mutobj = $obj->gene($objref);\n Function:\n\n           Returns or sets the link-reference to a\n           Bio::LiveSeq::Gene object. If no value has ben set, it\n           will return undef\n\n Returns : an object reference  or undef\n Args    : a Bio::LiveSeq::Gene\n\nSee L<Bio::LiveSeq::Gene> for more information.\n\n\nsub gene {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Gene') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::Gene object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'gene'} = $value;\n      }\n  }\n  unless (exists $self->{'gene'}) {\n      return;\n  } else {\n      return $self->{'gene'};\n  }\n}\n\n\n=head2 numbering\n\n Title   : numbering\n Usage   : $obj->numbering();\n Function:\n\n            Sets and returns coordinate system used in positioning the\n            mutations. See L<change_gene> for details.\n\n Example :\n Returns : string\n Args    : string (coding [transcript number] | gene | entry)\n\n\n\nsub numbering {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif ($value =~ /(coding)( )?(\\d+)?/ or $value eq 'entry' or $value eq 'gene') {\n\t    $self->{'numbering'} = $value;\n\t} else { # defaulting to 'coding'\n\t    $self->{'numbering'} = 'coding';\n\t}\n    }\n    unless (exists $self->{'numbering'}) {\n\treturn 'coding';\n    } else {\n\treturn $self->{'numbering'};\n    }\n}\n\n=head2 add_Mutation\n\n Title   : add_Mutation\n Usage   : $self->add_Mutation($ref)\n Function: adds a Bio::LiveSeq::Mutation object\n Example :\n Returns :\n Args    : a Bio::LiveSeq::Mutation\n\nSee L<Bio::LiveSeq::Mutation> for more information.\n\n\nsub add_Mutation{\n    my ($self,$value) = @_;\n    if( $value->isa('Bio::Liveseq::Mutation') ) {\n\tmy $com = ref $value;\n\t$self->throw(\"Is not a Mutation object but a [$com]\" );\n\treturn;\n    }\n    if (! $value->pos) {\n\t$self->warn(\"No value for mutation position in the sequence!\");\n\treturn;\n    }\n    if (! $value->seq && ! $value->len) {\n\t$self->warn(\"Either mutated sequence or length of the deletion must be given!\");\n\treturn;\n    }\n    push(@{$self->{'mutations'}},$value);\n}\n\n=head2 each_Mutation\n\n Title   : each_Mutation\n Usage   : foreach $ref ( $a->each_Mutation )\n Function: gets an array of Bio::LiveSeq::Mutation objects\n Example :\n Returns : array of Mutations\n Args    :\n\nSee L<Bio::LiveSeq::Mutation> for more information.\n\n\nsub each_Mutation{\n   my ($self) = @_;\n   return @{$self->{'mutations'}};\n}\n\n\n=head2 mutation\n\n Title   : mutation\n Usage   : $mutobj = $obj->mutation;\n         : $mutobj = $obj->mutation($objref);\n Function:\n\n           Returns or sets the link-reference to the current mutation\n           object.  If the value is not set, it will return undef.\n           Internal method.\n\n Returns : an object reference  or undef\n\n\n\nsub mutation {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Mutation') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::Mutation object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'mutation'} = $value;\n      }\n  }\n  unless (exists $self->{'mutation'}) {\n      return;\n  } else {\n      return $self->{'mutation'};\n  }\n}\n\n=head2 DNA\n\n Title   : DNA\n Usage   : $mutobj = $obj->DNA;\n         : $mutobj = $obj->DNA($objref);\n Function:\n\n           Returns or sets the reference to the LiveSeq object holding\n           the reference sequence. If there is no link, it will return\n           undef.\n           Internal method.\n\n Returns : an object reference or undef"},"children":[{"definition":"my","localvar":"my","kind":13,"containerName":"DNA","name":"$self","line":291},{"name":"$value","kind":13,"containerName":"DNA","line":291},{"name":"$value","containerName":"DNA","kind":13,"line":292},{"kind":13,"containerName":"DNA","name":"$value","line":293},{"containerName":"DNA","kind":12,"name":"isa","line":293},{"kind":13,"containerName":"DNA","name":"$value","line":293},{"line":293,"name":"isa","containerName":"DNA","kind":12},{"name":"$self","kind":13,"containerName":"DNA","line":294},{"line":294,"name":"throw","containerName":"DNA","kind":12},{"name":"$self","kind":13,"containerName":"DNA","line":298},{"containerName":"DNA","kind":13,"name":"$value","line":298},{"line":301,"kind":13,"containerName":"DNA","name":"$self"},{"line":304,"kind":13,"containerName":"DNA","name":"$self"}],"containerName":"main::","name":"DNA","definition":"sub","detail":"($self,$value)"},{"detail":"($self,$value)","definition":"sub","containerName":"main::","name":"RNA","children":[{"definition":"my","line":327,"containerName":"RNA","localvar":"my","kind":13,"name":"$self"},{"line":327,"kind":13,"containerName":"RNA","name":"$value"},{"kind":13,"containerName":"RNA","name":"$value","line":328},{"kind":13,"containerName":"RNA","name":"$value","line":329},{"line":329,"kind":12,"containerName":"RNA","name":"isa"},{"name":"$self","kind":13,"containerName":"RNA","line":330},{"line":330,"name":"throw","containerName":"RNA","kind":12},{"name":"$self","containerName":"RNA","kind":13,"line":334},{"line":334,"kind":13,"containerName":"RNA","name":"$value"},{"name":"$self","containerName":"RNA","kind":13,"line":337},{"line":340,"containerName":"RNA","kind":13,"name":"$self"}],"signature":{"label":"RNA($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Mutator.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::Mutator\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::Mutator - Package mutating LiveSequences\n\n=head1 SYNOPSIS\n\n  # $gene is a Bio::LiveSeq::Gene object\n  my $mutate = Bio::LiveSeq::Mutator->new('-gene' => $gene,\n  \t\t\t\t\t  '-numbering' => \"coding\"\n  \t\t\t\t\t   );\n  # $mut is a Bio::LiveSeq::Mutation object\n  $mutate->add_Mutation($mut);\n  # $results is a Bio::Variation::SeqDiff object\n  my $results=$mutate->change_gene();\n  if ($results) {\n      my $out = Bio::Variation::IO->new( '-format' => 'flat');\n      $out->write($results);\n  }\n\n=head1 DESCRIPTION\n\nThis class mutates Bio::LiveSeq::Gene objects and returns a\nBio::Variation::SeqDiff object. Mutations are described as\nBio::LiveSeq::Mutation objects. See L<Bio::LiveSeq::Gene>,\nL<Bio::Variation::SeqDiff>, and L<Bio::LiveSeq::Mutation> for details.\n\n=head1 FEEDBACK\n\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho & Joseph A.L. Insana\n\n  Email:  heikki-at-bioperl-dot-org\n          insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\n  The rest of the documentation details each of the object\n  methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::Mutator;\nuse strict;\n\nuse Bio::Variation::SeqDiff;\nuse Bio::Variation::DNAMutation;\nuse Bio::Variation::RNAChange;\nuse Bio::Variation::AAChange;\nuse Bio::Variation::Allele;\nuse Bio::LiveSeq::Mutation;\n\n#use integer;\n# Object preamble - inheritance\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n    my($class,@args) = @_;\n    my $self;\n    $self = {};\n    bless $self, $class;\n\n    my ($gene, $numbering) =\n\t    $self->_rearrange([qw(GENE\n\t\t\t\t  NUMBERING\n\t\t\t\t  )],\n\t\t\t      @args);\n\n    $self->{ 'mutations' } = [];\n\n    $gene && $self->gene($gene);\n    $numbering && $self->numbering($numbering);\n\n    #class constant;\n    $self->{'flanklen'} = 25;\n    return $self; # success - we hope!\n}\n\n=head2 gene\n\n Title   : gene\n Usage   : $mutobj = $obj->gene;\n         : $mutobj = $obj->gene($objref);\n Function:\n\n           Returns or sets the link-reference to a\n           Bio::LiveSeq::Gene object. If no value has ben set, it\n           will return undef\n\n Returns : an object reference  or undef\n Args    : a Bio::LiveSeq::Gene\n\nSee L<Bio::LiveSeq::Gene> for more information.\n\n\nsub gene {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Gene') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::Gene object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'gene'} = $value;\n      }\n  }\n  unless (exists $self->{'gene'}) {\n      return;\n  } else {\n      return $self->{'gene'};\n  }\n}\n\n\n=head2 numbering\n\n Title   : numbering\n Usage   : $obj->numbering();\n Function:\n\n            Sets and returns coordinate system used in positioning the\n            mutations. See L<change_gene> for details.\n\n Example :\n Returns : string\n Args    : string (coding [transcript number] | gene | entry)\n\n\n\nsub numbering {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif ($value =~ /(coding)( )?(\\d+)?/ or $value eq 'entry' or $value eq 'gene') {\n\t    $self->{'numbering'} = $value;\n\t} else { # defaulting to 'coding'\n\t    $self->{'numbering'} = 'coding';\n\t}\n    }\n    unless (exists $self->{'numbering'}) {\n\treturn 'coding';\n    } else {\n\treturn $self->{'numbering'};\n    }\n}\n\n=head2 add_Mutation\n\n Title   : add_Mutation\n Usage   : $self->add_Mutation($ref)\n Function: adds a Bio::LiveSeq::Mutation object\n Example :\n Returns :\n Args    : a Bio::LiveSeq::Mutation\n\nSee L<Bio::LiveSeq::Mutation> for more information.\n\n\nsub add_Mutation{\n    my ($self,$value) = @_;\n    if( $value->isa('Bio::Liveseq::Mutation') ) {\n\tmy $com = ref $value;\n\t$self->throw(\"Is not a Mutation object but a [$com]\" );\n\treturn;\n    }\n    if (! $value->pos) {\n\t$self->warn(\"No value for mutation position in the sequence!\");\n\treturn;\n    }\n    if (! $value->seq && ! $value->len) {\n\t$self->warn(\"Either mutated sequence or length of the deletion must be given!\");\n\treturn;\n    }\n    push(@{$self->{'mutations'}},$value);\n}\n\n=head2 each_Mutation\n\n Title   : each_Mutation\n Usage   : foreach $ref ( $a->each_Mutation )\n Function: gets an array of Bio::LiveSeq::Mutation objects\n Example :\n Returns : array of Mutations\n Args    :\n\nSee L<Bio::LiveSeq::Mutation> for more information.\n\n\nsub each_Mutation{\n   my ($self) = @_;\n   return @{$self->{'mutations'}};\n}\n\n\n=head2 mutation\n\n Title   : mutation\n Usage   : $mutobj = $obj->mutation;\n         : $mutobj = $obj->mutation($objref);\n Function:\n\n           Returns or sets the link-reference to the current mutation\n           object.  If the value is not set, it will return undef.\n           Internal method.\n\n Returns : an object reference  or undef\n\n\n\nsub mutation {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Mutation') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::Mutation object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'mutation'} = $value;\n      }\n  }\n  unless (exists $self->{'mutation'}) {\n      return;\n  } else {\n      return $self->{'mutation'};\n  }\n}\n\n=head2 DNA\n\n Title   : DNA\n Usage   : $mutobj = $obj->DNA;\n         : $mutobj = $obj->DNA($objref);\n Function:\n\n           Returns or sets the reference to the LiveSeq object holding\n           the reference sequence. If there is no link, it will return\n           undef.\n           Internal method.\n\n Returns : an object reference or undef\n\n\nsub DNA {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::DNA') and ! $value->isa('Bio::LiveSeq::Transcript') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::DNA/Transcript object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'DNA'} = $value;\n      }\n  }\n  unless (exists $self->{'DNA'}) {\n      return;\n  } else {\n      return $self->{'DNA'};\n  }\n}\n\n\n=head2 RNA\n\n Title   : RNA\n Usage   : $mutobj = $obj->RNA;\n         : $mutobj = $obj->RNA($objref);\n Function:\n\n           Returns or sets the reference to the LiveSeq object holding\n           the reference sequence. If the value is not set, it will return\n           undef.\n           Internal method.\n\n Returns : an object reference  or undef"},"kind":12,"range":{"end":{"line":342,"character":9999},"start":{"character":0,"line":326}},"line":326},{"signature":{"documentation":"1;\n# $Id: Mutator.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::Mutator\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::Mutator - Package mutating LiveSequences\n\n=head1 SYNOPSIS\n\n  # $gene is a Bio::LiveSeq::Gene object\n  my $mutate = Bio::LiveSeq::Mutator->new('-gene' => $gene,\n  \t\t\t\t\t  '-numbering' => \"coding\"\n  \t\t\t\t\t   );\n  # $mut is a Bio::LiveSeq::Mutation object\n  $mutate->add_Mutation($mut);\n  # $results is a Bio::Variation::SeqDiff object\n  my $results=$mutate->change_gene();\n  if ($results) {\n      my $out = Bio::Variation::IO->new( '-format' => 'flat');\n      $out->write($results);\n  }\n\n=head1 DESCRIPTION\n\nThis class mutates Bio::LiveSeq::Gene objects and returns a\nBio::Variation::SeqDiff object. Mutations are described as\nBio::LiveSeq::Mutation objects. See L<Bio::LiveSeq::Gene>,\nL<Bio::Variation::SeqDiff>, and L<Bio::LiveSeq::Mutation> for details.\n\n=head1 FEEDBACK\n\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho & Joseph A.L. Insana\n\n  Email:  heikki-at-bioperl-dot-org\n          insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\n  The rest of the documentation details each of the object\n  methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::Mutator;\nuse strict;\n\nuse Bio::Variation::SeqDiff;\nuse Bio::Variation::DNAMutation;\nuse Bio::Variation::RNAChange;\nuse Bio::Variation::AAChange;\nuse Bio::Variation::Allele;\nuse Bio::LiveSeq::Mutation;\n\n#use integer;\n# Object preamble - inheritance\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n    my($class,@args) = @_;\n    my $self;\n    $self = {};\n    bless $self, $class;\n\n    my ($gene, $numbering) =\n\t    $self->_rearrange([qw(GENE\n\t\t\t\t  NUMBERING\n\t\t\t\t  )],\n\t\t\t      @args);\n\n    $self->{ 'mutations' } = [];\n\n    $gene && $self->gene($gene);\n    $numbering && $self->numbering($numbering);\n\n    #class constant;\n    $self->{'flanklen'} = 25;\n    return $self; # success - we hope!\n}\n\n=head2 gene\n\n Title   : gene\n Usage   : $mutobj = $obj->gene;\n         : $mutobj = $obj->gene($objref);\n Function:\n\n           Returns or sets the link-reference to a\n           Bio::LiveSeq::Gene object. If no value has ben set, it\n           will return undef\n\n Returns : an object reference  or undef\n Args    : a Bio::LiveSeq::Gene\n\nSee L<Bio::LiveSeq::Gene> for more information.\n\n\nsub gene {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Gene') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::Gene object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'gene'} = $value;\n      }\n  }\n  unless (exists $self->{'gene'}) {\n      return;\n  } else {\n      return $self->{'gene'};\n  }\n}\n\n\n=head2 numbering\n\n Title   : numbering\n Usage   : $obj->numbering();\n Function:\n\n            Sets and returns coordinate system used in positioning the\n            mutations. See L<change_gene> for details.\n\n Example :\n Returns : string\n Args    : string (coding [transcript number] | gene | entry)\n\n\n\nsub numbering {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif ($value =~ /(coding)( )?(\\d+)?/ or $value eq 'entry' or $value eq 'gene') {\n\t    $self->{'numbering'} = $value;\n\t} else { # defaulting to 'coding'\n\t    $self->{'numbering'} = 'coding';\n\t}\n    }\n    unless (exists $self->{'numbering'}) {\n\treturn 'coding';\n    } else {\n\treturn $self->{'numbering'};\n    }\n}\n\n=head2 add_Mutation\n\n Title   : add_Mutation\n Usage   : $self->add_Mutation($ref)\n Function: adds a Bio::LiveSeq::Mutation object\n Example :\n Returns :\n Args    : a Bio::LiveSeq::Mutation\n\nSee L<Bio::LiveSeq::Mutation> for more information.\n\n\nsub add_Mutation{\n    my ($self,$value) = @_;\n    if( $value->isa('Bio::Liveseq::Mutation') ) {\n\tmy $com = ref $value;\n\t$self->throw(\"Is not a Mutation object but a [$com]\" );\n\treturn;\n    }\n    if (! $value->pos) {\n\t$self->warn(\"No value for mutation position in the sequence!\");\n\treturn;\n    }\n    if (! $value->seq && ! $value->len) {\n\t$self->warn(\"Either mutated sequence or length of the deletion must be given!\");\n\treturn;\n    }\n    push(@{$self->{'mutations'}},$value);\n}\n\n=head2 each_Mutation\n\n Title   : each_Mutation\n Usage   : foreach $ref ( $a->each_Mutation )\n Function: gets an array of Bio::LiveSeq::Mutation objects\n Example :\n Returns : array of Mutations\n Args    :\n\nSee L<Bio::LiveSeq::Mutation> for more information.\n\n\nsub each_Mutation{\n   my ($self) = @_;\n   return @{$self->{'mutations'}};\n}\n\n\n=head2 mutation\n\n Title   : mutation\n Usage   : $mutobj = $obj->mutation;\n         : $mutobj = $obj->mutation($objref);\n Function:\n\n           Returns or sets the link-reference to the current mutation\n           object.  If the value is not set, it will return undef.\n           Internal method.\n\n Returns : an object reference  or undef\n\n\n\nsub mutation {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Mutation') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::Mutation object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'mutation'} = $value;\n      }\n  }\n  unless (exists $self->{'mutation'}) {\n      return;\n  } else {\n      return $self->{'mutation'};\n  }\n}\n\n=head2 DNA\n\n Title   : DNA\n Usage   : $mutobj = $obj->DNA;\n         : $mutobj = $obj->DNA($objref);\n Function:\n\n           Returns or sets the reference to the LiveSeq object holding\n           the reference sequence. If there is no link, it will return\n           undef.\n           Internal method.\n\n Returns : an object reference or undef\n\n\nsub DNA {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::DNA') and ! $value->isa('Bio::LiveSeq::Transcript') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::DNA/Transcript object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'DNA'} = $value;\n      }\n  }\n  unless (exists $self->{'DNA'}) {\n      return;\n  } else {\n      return $self->{'DNA'};\n  }\n}\n\n\n=head2 RNA\n\n Title   : RNA\n Usage   : $mutobj = $obj->RNA;\n         : $mutobj = $obj->RNA($objref);\n Function:\n\n           Returns or sets the reference to the LiveSeq object holding\n           the reference sequence. If the value is not set, it will return\n           undef.\n           Internal method.\n\n Returns : an object reference  or undef\n\n\n\nsub RNA {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Transcript') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::RNA/Transcript object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'RNA'} = $value;\n      }\n  }\n  unless (exists $self->{'RNA'}) {\n      return;\n  } else {\n      return $self->{'RNA'};\n  }\n}\n\n\n=head2 dnamut\n\n Title   : dnamut\n Usage   : $mutobj = $obj->dnamut;\n         : $mutobj = $obj->dnamut($objref);\n Function:\n\n           Returns or sets the reference to the current DNAMutation object.\n           If the value is not set, it will return undef.\n           Internal method.\n\n Returns : a Bio::Variation::DNAMutation object or undef\n\nSee L<Bio::Variation::DNAMutation> for more information.","parameters":[{"label":"$self"},{"label":"$value"}],"label":"dnamut($self,$value)"},"line":363,"kind":12,"range":{"start":{"character":0,"line":363},"end":{"character":9999,"line":379}},"definition":"sub","detail":"($self,$value)","children":[{"line":364,"name":"$self","containerName":"dnamut","localvar":"my","kind":13,"definition":"my"},{"name":"$value","kind":13,"containerName":"dnamut","line":364},{"name":"$value","kind":13,"containerName":"dnamut","line":365},{"kind":13,"containerName":"dnamut","name":"$value","line":366},{"kind":12,"containerName":"dnamut","name":"isa","line":366},{"name":"$self","containerName":"dnamut","kind":13,"line":367},{"line":367,"containerName":"dnamut","kind":12,"name":"throw"},{"line":371,"kind":13,"containerName":"dnamut","name":"$self"},{"name":"$value","containerName":"dnamut","kind":13,"line":371},{"line":374,"name":"$self","kind":13,"containerName":"dnamut"},{"name":"$self","kind":13,"containerName":"dnamut","line":377}],"name":"dnamut","containerName":"main::"},{"detail":"($self,$value)","definition":"sub","containerName":"main::","name":"rnachange","children":[{"line":401,"localvar":"my","containerName":"rnachange","kind":13,"name":"$self","definition":"my"},{"line":401,"name":"$value","containerName":"rnachange","kind":13},{"line":402,"containerName":"rnachange","kind":13,"name":"$value"},{"name":"$value","kind":13,"containerName":"rnachange","line":403},{"line":403,"kind":12,"containerName":"rnachange","name":"isa"},{"name":"$self","kind":13,"containerName":"rnachange","line":404},{"name":"throw","containerName":"rnachange","kind":12,"line":404},{"line":408,"containerName":"rnachange","kind":13,"name":"$self"},{"kind":13,"containerName":"rnachange","name":"$value","line":408},{"name":"$self","containerName":"rnachange","kind":13,"line":411},{"line":414,"containerName":"rnachange","kind":13,"name":"$self"}],"signature":{"label":"rnachange($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Mutator.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::Mutator\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::Mutator - Package mutating LiveSequences\n\n=head1 SYNOPSIS\n\n  # $gene is a Bio::LiveSeq::Gene object\n  my $mutate = Bio::LiveSeq::Mutator->new('-gene' => $gene,\n  \t\t\t\t\t  '-numbering' => \"coding\"\n  \t\t\t\t\t   );\n  # $mut is a Bio::LiveSeq::Mutation object\n  $mutate->add_Mutation($mut);\n  # $results is a Bio::Variation::SeqDiff object\n  my $results=$mutate->change_gene();\n  if ($results) {\n      my $out = Bio::Variation::IO->new( '-format' => 'flat');\n      $out->write($results);\n  }\n\n=head1 DESCRIPTION\n\nThis class mutates Bio::LiveSeq::Gene objects and returns a\nBio::Variation::SeqDiff object. Mutations are described as\nBio::LiveSeq::Mutation objects. See L<Bio::LiveSeq::Gene>,\nL<Bio::Variation::SeqDiff>, and L<Bio::LiveSeq::Mutation> for details.\n\n=head1 FEEDBACK\n\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho & Joseph A.L. Insana\n\n  Email:  heikki-at-bioperl-dot-org\n          insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\n  The rest of the documentation details each of the object\n  methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::Mutator;\nuse strict;\n\nuse Bio::Variation::SeqDiff;\nuse Bio::Variation::DNAMutation;\nuse Bio::Variation::RNAChange;\nuse Bio::Variation::AAChange;\nuse Bio::Variation::Allele;\nuse Bio::LiveSeq::Mutation;\n\n#use integer;\n# Object preamble - inheritance\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n    my($class,@args) = @_;\n    my $self;\n    $self = {};\n    bless $self, $class;\n\n    my ($gene, $numbering) =\n\t    $self->_rearrange([qw(GENE\n\t\t\t\t  NUMBERING\n\t\t\t\t  )],\n\t\t\t      @args);\n\n    $self->{ 'mutations' } = [];\n\n    $gene && $self->gene($gene);\n    $numbering && $self->numbering($numbering);\n\n    #class constant;\n    $self->{'flanklen'} = 25;\n    return $self; # success - we hope!\n}\n\n=head2 gene\n\n Title   : gene\n Usage   : $mutobj = $obj->gene;\n         : $mutobj = $obj->gene($objref);\n Function:\n\n           Returns or sets the link-reference to a\n           Bio::LiveSeq::Gene object. If no value has ben set, it\n           will return undef\n\n Returns : an object reference  or undef\n Args    : a Bio::LiveSeq::Gene\n\nSee L<Bio::LiveSeq::Gene> for more information.\n\n\nsub gene {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Gene') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::Gene object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'gene'} = $value;\n      }\n  }\n  unless (exists $self->{'gene'}) {\n      return;\n  } else {\n      return $self->{'gene'};\n  }\n}\n\n\n=head2 numbering\n\n Title   : numbering\n Usage   : $obj->numbering();\n Function:\n\n            Sets and returns coordinate system used in positioning the\n            mutations. See L<change_gene> for details.\n\n Example :\n Returns : string\n Args    : string (coding [transcript number] | gene | entry)\n\n\n\nsub numbering {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif ($value =~ /(coding)( )?(\\d+)?/ or $value eq 'entry' or $value eq 'gene') {\n\t    $self->{'numbering'} = $value;\n\t} else { # defaulting to 'coding'\n\t    $self->{'numbering'} = 'coding';\n\t}\n    }\n    unless (exists $self->{'numbering'}) {\n\treturn 'coding';\n    } else {\n\treturn $self->{'numbering'};\n    }\n}\n\n=head2 add_Mutation\n\n Title   : add_Mutation\n Usage   : $self->add_Mutation($ref)\n Function: adds a Bio::LiveSeq::Mutation object\n Example :\n Returns :\n Args    : a Bio::LiveSeq::Mutation\n\nSee L<Bio::LiveSeq::Mutation> for more information.\n\n\nsub add_Mutation{\n    my ($self,$value) = @_;\n    if( $value->isa('Bio::Liveseq::Mutation') ) {\n\tmy $com = ref $value;\n\t$self->throw(\"Is not a Mutation object but a [$com]\" );\n\treturn;\n    }\n    if (! $value->pos) {\n\t$self->warn(\"No value for mutation position in the sequence!\");\n\treturn;\n    }\n    if (! $value->seq && ! $value->len) {\n\t$self->warn(\"Either mutated sequence or length of the deletion must be given!\");\n\treturn;\n    }\n    push(@{$self->{'mutations'}},$value);\n}\n\n=head2 each_Mutation\n\n Title   : each_Mutation\n Usage   : foreach $ref ( $a->each_Mutation )\n Function: gets an array of Bio::LiveSeq::Mutation objects\n Example :\n Returns : array of Mutations\n Args    :\n\nSee L<Bio::LiveSeq::Mutation> for more information.\n\n\nsub each_Mutation{\n   my ($self) = @_;\n   return @{$self->{'mutations'}};\n}\n\n\n=head2 mutation\n\n Title   : mutation\n Usage   : $mutobj = $obj->mutation;\n         : $mutobj = $obj->mutation($objref);\n Function:\n\n           Returns or sets the link-reference to the current mutation\n           object.  If the value is not set, it will return undef.\n           Internal method.\n\n Returns : an object reference  or undef\n\n\n\nsub mutation {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Mutation') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::Mutation object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'mutation'} = $value;\n      }\n  }\n  unless (exists $self->{'mutation'}) {\n      return;\n  } else {\n      return $self->{'mutation'};\n  }\n}\n\n=head2 DNA\n\n Title   : DNA\n Usage   : $mutobj = $obj->DNA;\n         : $mutobj = $obj->DNA($objref);\n Function:\n\n           Returns or sets the reference to the LiveSeq object holding\n           the reference sequence. If there is no link, it will return\n           undef.\n           Internal method.\n\n Returns : an object reference or undef\n\n\nsub DNA {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::DNA') and ! $value->isa('Bio::LiveSeq::Transcript') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::DNA/Transcript object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'DNA'} = $value;\n      }\n  }\n  unless (exists $self->{'DNA'}) {\n      return;\n  } else {\n      return $self->{'DNA'};\n  }\n}\n\n\n=head2 RNA\n\n Title   : RNA\n Usage   : $mutobj = $obj->RNA;\n         : $mutobj = $obj->RNA($objref);\n Function:\n\n           Returns or sets the reference to the LiveSeq object holding\n           the reference sequence. If the value is not set, it will return\n           undef.\n           Internal method.\n\n Returns : an object reference  or undef\n\n\n\nsub RNA {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Transcript') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::RNA/Transcript object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'RNA'} = $value;\n      }\n  }\n  unless (exists $self->{'RNA'}) {\n      return;\n  } else {\n      return $self->{'RNA'};\n  }\n}\n\n\n=head2 dnamut\n\n Title   : dnamut\n Usage   : $mutobj = $obj->dnamut;\n         : $mutobj = $obj->dnamut($objref);\n Function:\n\n           Returns or sets the reference to the current DNAMutation object.\n           If the value is not set, it will return undef.\n           Internal method.\n\n Returns : a Bio::Variation::DNAMutation object or undef\n\nSee L<Bio::Variation::DNAMutation> for more information.\n\n\n\nsub dnamut {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::DNAMutation') ) {\n\t  $self->throw(\"Is not a Bio::Variation::DNAMutation object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'dnamut'} = $value;\n      }\n  }\n  unless (exists $self->{'dnamut'}) {\n      return;\n  } else {\n      return $self->{'dnamut'};\n  }\n}\n\n\n=head2 rnachange\n\n Title   : rnachange\n Usage   : $mutobj = $obj->rnachange;\n         : $mutobj = $obj->rnachange($objref);\n Function:\n\n           Returns or sets the reference to the current RNAChange object.\n           If the value is not set, it will return undef.\n           Internal method.\n\n Returns : a Bio::Variation::RNAChange object or undef\n\nSee L<Bio::Variation::RNAChange> for more information."},"kind":12,"range":{"start":{"character":0,"line":400},"end":{"line":416,"character":9999}},"line":400},{"definition":"sub","detail":"($self,$value)","children":[{"definition":"my","line":438,"localvar":"my","containerName":"aachange","kind":13,"name":"$self"},{"containerName":"aachange","kind":13,"name":"$value","line":438},{"kind":13,"containerName":"aachange","name":"$value","line":439},{"kind":13,"containerName":"aachange","name":"$value","line":440},{"line":440,"name":"isa","containerName":"aachange","kind":12},{"name":"$self","containerName":"aachange","kind":13,"line":441},{"line":441,"containerName":"aachange","kind":12,"name":"throw"},{"name":"$self","containerName":"aachange","kind":13,"line":445},{"kind":13,"containerName":"aachange","name":"$value","line":445},{"line":448,"kind":13,"containerName":"aachange","name":"$self"},{"name":"$self","kind":13,"containerName":"aachange","line":451}],"containerName":"main::","name":"aachange","signature":{"documentation":"1;\n# $Id: Mutator.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::Mutator\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::Mutator - Package mutating LiveSequences\n\n=head1 SYNOPSIS\n\n  # $gene is a Bio::LiveSeq::Gene object\n  my $mutate = Bio::LiveSeq::Mutator->new('-gene' => $gene,\n  \t\t\t\t\t  '-numbering' => \"coding\"\n  \t\t\t\t\t   );\n  # $mut is a Bio::LiveSeq::Mutation object\n  $mutate->add_Mutation($mut);\n  # $results is a Bio::Variation::SeqDiff object\n  my $results=$mutate->change_gene();\n  if ($results) {\n      my $out = Bio::Variation::IO->new( '-format' => 'flat');\n      $out->write($results);\n  }\n\n=head1 DESCRIPTION\n\nThis class mutates Bio::LiveSeq::Gene objects and returns a\nBio::Variation::SeqDiff object. Mutations are described as\nBio::LiveSeq::Mutation objects. See L<Bio::LiveSeq::Gene>,\nL<Bio::Variation::SeqDiff>, and L<Bio::LiveSeq::Mutation> for details.\n\n=head1 FEEDBACK\n\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho & Joseph A.L. Insana\n\n  Email:  heikki-at-bioperl-dot-org\n          insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\n  The rest of the documentation details each of the object\n  methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::Mutator;\nuse strict;\n\nuse Bio::Variation::SeqDiff;\nuse Bio::Variation::DNAMutation;\nuse Bio::Variation::RNAChange;\nuse Bio::Variation::AAChange;\nuse Bio::Variation::Allele;\nuse Bio::LiveSeq::Mutation;\n\n#use integer;\n# Object preamble - inheritance\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n    my($class,@args) = @_;\n    my $self;\n    $self = {};\n    bless $self, $class;\n\n    my ($gene, $numbering) =\n\t    $self->_rearrange([qw(GENE\n\t\t\t\t  NUMBERING\n\t\t\t\t  )],\n\t\t\t      @args);\n\n    $self->{ 'mutations' } = [];\n\n    $gene && $self->gene($gene);\n    $numbering && $self->numbering($numbering);\n\n    #class constant;\n    $self->{'flanklen'} = 25;\n    return $self; # success - we hope!\n}\n\n=head2 gene\n\n Title   : gene\n Usage   : $mutobj = $obj->gene;\n         : $mutobj = $obj->gene($objref);\n Function:\n\n           Returns or sets the link-reference to a\n           Bio::LiveSeq::Gene object. If no value has ben set, it\n           will return undef\n\n Returns : an object reference  or undef\n Args    : a Bio::LiveSeq::Gene\n\nSee L<Bio::LiveSeq::Gene> for more information.\n\n\nsub gene {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Gene') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::Gene object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'gene'} = $value;\n      }\n  }\n  unless (exists $self->{'gene'}) {\n      return;\n  } else {\n      return $self->{'gene'};\n  }\n}\n\n\n=head2 numbering\n\n Title   : numbering\n Usage   : $obj->numbering();\n Function:\n\n            Sets and returns coordinate system used in positioning the\n            mutations. See L<change_gene> for details.\n\n Example :\n Returns : string\n Args    : string (coding [transcript number] | gene | entry)\n\n\n\nsub numbering {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif ($value =~ /(coding)( )?(\\d+)?/ or $value eq 'entry' or $value eq 'gene') {\n\t    $self->{'numbering'} = $value;\n\t} else { # defaulting to 'coding'\n\t    $self->{'numbering'} = 'coding';\n\t}\n    }\n    unless (exists $self->{'numbering'}) {\n\treturn 'coding';\n    } else {\n\treturn $self->{'numbering'};\n    }\n}\n\n=head2 add_Mutation\n\n Title   : add_Mutation\n Usage   : $self->add_Mutation($ref)\n Function: adds a Bio::LiveSeq::Mutation object\n Example :\n Returns :\n Args    : a Bio::LiveSeq::Mutation\n\nSee L<Bio::LiveSeq::Mutation> for more information.\n\n\nsub add_Mutation{\n    my ($self,$value) = @_;\n    if( $value->isa('Bio::Liveseq::Mutation') ) {\n\tmy $com = ref $value;\n\t$self->throw(\"Is not a Mutation object but a [$com]\" );\n\treturn;\n    }\n    if (! $value->pos) {\n\t$self->warn(\"No value for mutation position in the sequence!\");\n\treturn;\n    }\n    if (! $value->seq && ! $value->len) {\n\t$self->warn(\"Either mutated sequence or length of the deletion must be given!\");\n\treturn;\n    }\n    push(@{$self->{'mutations'}},$value);\n}\n\n=head2 each_Mutation\n\n Title   : each_Mutation\n Usage   : foreach $ref ( $a->each_Mutation )\n Function: gets an array of Bio::LiveSeq::Mutation objects\n Example :\n Returns : array of Mutations\n Args    :\n\nSee L<Bio::LiveSeq::Mutation> for more information.\n\n\nsub each_Mutation{\n   my ($self) = @_;\n   return @{$self->{'mutations'}};\n}\n\n\n=head2 mutation\n\n Title   : mutation\n Usage   : $mutobj = $obj->mutation;\n         : $mutobj = $obj->mutation($objref);\n Function:\n\n           Returns or sets the link-reference to the current mutation\n           object.  If the value is not set, it will return undef.\n           Internal method.\n\n Returns : an object reference  or undef\n\n\n\nsub mutation {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Mutation') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::Mutation object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'mutation'} = $value;\n      }\n  }\n  unless (exists $self->{'mutation'}) {\n      return;\n  } else {\n      return $self->{'mutation'};\n  }\n}\n\n=head2 DNA\n\n Title   : DNA\n Usage   : $mutobj = $obj->DNA;\n         : $mutobj = $obj->DNA($objref);\n Function:\n\n           Returns or sets the reference to the LiveSeq object holding\n           the reference sequence. If there is no link, it will return\n           undef.\n           Internal method.\n\n Returns : an object reference or undef\n\n\nsub DNA {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::DNA') and ! $value->isa('Bio::LiveSeq::Transcript') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::DNA/Transcript object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'DNA'} = $value;\n      }\n  }\n  unless (exists $self->{'DNA'}) {\n      return;\n  } else {\n      return $self->{'DNA'};\n  }\n}\n\n\n=head2 RNA\n\n Title   : RNA\n Usage   : $mutobj = $obj->RNA;\n         : $mutobj = $obj->RNA($objref);\n Function:\n\n           Returns or sets the reference to the LiveSeq object holding\n           the reference sequence. If the value is not set, it will return\n           undef.\n           Internal method.\n\n Returns : an object reference  or undef\n\n\n\nsub RNA {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Transcript') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::RNA/Transcript object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'RNA'} = $value;\n      }\n  }\n  unless (exists $self->{'RNA'}) {\n      return;\n  } else {\n      return $self->{'RNA'};\n  }\n}\n\n\n=head2 dnamut\n\n Title   : dnamut\n Usage   : $mutobj = $obj->dnamut;\n         : $mutobj = $obj->dnamut($objref);\n Function:\n\n           Returns or sets the reference to the current DNAMutation object.\n           If the value is not set, it will return undef.\n           Internal method.\n\n Returns : a Bio::Variation::DNAMutation object or undef\n\nSee L<Bio::Variation::DNAMutation> for more information.\n\n\n\nsub dnamut {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::DNAMutation') ) {\n\t  $self->throw(\"Is not a Bio::Variation::DNAMutation object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'dnamut'} = $value;\n      }\n  }\n  unless (exists $self->{'dnamut'}) {\n      return;\n  } else {\n      return $self->{'dnamut'};\n  }\n}\n\n\n=head2 rnachange\n\n Title   : rnachange\n Usage   : $mutobj = $obj->rnachange;\n         : $mutobj = $obj->rnachange($objref);\n Function:\n\n           Returns or sets the reference to the current RNAChange object.\n           If the value is not set, it will return undef.\n           Internal method.\n\n Returns : a Bio::Variation::RNAChange object or undef\n\nSee L<Bio::Variation::RNAChange> for more information.\n\n\n\nsub rnachange {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::RNAChange') ) {\n\t  $self->throw(\"Is not a Bio::Variation::RNAChange object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'rnachange'} = $value;\n      }\n  }\n  unless (exists $self->{'rnachange'}) {\n      return;\n  } else {\n      return $self->{'rnachange'};\n  }\n}\n\n\n=head2 aachange\n\n Title   : aachange\n Usage   : $mutobj = $obj->aachange;\n         : $mutobj = $obj->aachange($objref);\n Function:\n\n           Returns or sets the reference to the current AAChange object.\n           If the value is not set, it will return undef.\n           Internal method.\n\n Returns : a Bio::Variation::AAChange object or undef\n\nSee L<Bio::Variation::AAChange> for more information.","parameters":[{"label":"$self"},{"label":"$value"}],"label":"aachange($self,$value)"},"line":437,"kind":12,"range":{"start":{"line":437,"character":0},"end":{"character":9999,"line":453}}},{"signature":{"label":"exons($self,$value)","documentation":"1;\n# $Id: Mutator.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::Mutator\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::Mutator - Package mutating LiveSequences\n\n=head1 SYNOPSIS\n\n  # $gene is a Bio::LiveSeq::Gene object\n  my $mutate = Bio::LiveSeq::Mutator->new('-gene' => $gene,\n  \t\t\t\t\t  '-numbering' => \"coding\"\n  \t\t\t\t\t   );\n  # $mut is a Bio::LiveSeq::Mutation object\n  $mutate->add_Mutation($mut);\n  # $results is a Bio::Variation::SeqDiff object\n  my $results=$mutate->change_gene();\n  if ($results) {\n      my $out = Bio::Variation::IO->new( '-format' => 'flat');\n      $out->write($results);\n  }\n\n=head1 DESCRIPTION\n\nThis class mutates Bio::LiveSeq::Gene objects and returns a\nBio::Variation::SeqDiff object. Mutations are described as\nBio::LiveSeq::Mutation objects. See L<Bio::LiveSeq::Gene>,\nL<Bio::Variation::SeqDiff>, and L<Bio::LiveSeq::Mutation> for details.\n\n=head1 FEEDBACK\n\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho & Joseph A.L. Insana\n\n  Email:  heikki-at-bioperl-dot-org\n          insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\n  The rest of the documentation details each of the object\n  methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::Mutator;\nuse strict;\n\nuse Bio::Variation::SeqDiff;\nuse Bio::Variation::DNAMutation;\nuse Bio::Variation::RNAChange;\nuse Bio::Variation::AAChange;\nuse Bio::Variation::Allele;\nuse Bio::LiveSeq::Mutation;\n\n#use integer;\n# Object preamble - inheritance\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n    my($class,@args) = @_;\n    my $self;\n    $self = {};\n    bless $self, $class;\n\n    my ($gene, $numbering) =\n\t    $self->_rearrange([qw(GENE\n\t\t\t\t  NUMBERING\n\t\t\t\t  )],\n\t\t\t      @args);\n\n    $self->{ 'mutations' } = [];\n\n    $gene && $self->gene($gene);\n    $numbering && $self->numbering($numbering);\n\n    #class constant;\n    $self->{'flanklen'} = 25;\n    return $self; # success - we hope!\n}\n\n=head2 gene\n\n Title   : gene\n Usage   : $mutobj = $obj->gene;\n         : $mutobj = $obj->gene($objref);\n Function:\n\n           Returns or sets the link-reference to a\n           Bio::LiveSeq::Gene object. If no value has ben set, it\n           will return undef\n\n Returns : an object reference  or undef\n Args    : a Bio::LiveSeq::Gene\n\nSee L<Bio::LiveSeq::Gene> for more information.\n\n\nsub gene {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Gene') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::Gene object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'gene'} = $value;\n      }\n  }\n  unless (exists $self->{'gene'}) {\n      return;\n  } else {\n      return $self->{'gene'};\n  }\n}\n\n\n=head2 numbering\n\n Title   : numbering\n Usage   : $obj->numbering();\n Function:\n\n            Sets and returns coordinate system used in positioning the\n            mutations. See L<change_gene> for details.\n\n Example :\n Returns : string\n Args    : string (coding [transcript number] | gene | entry)\n\n\n\nsub numbering {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif ($value =~ /(coding)( )?(\\d+)?/ or $value eq 'entry' or $value eq 'gene') {\n\t    $self->{'numbering'} = $value;\n\t} else { # defaulting to 'coding'\n\t    $self->{'numbering'} = 'coding';\n\t}\n    }\n    unless (exists $self->{'numbering'}) {\n\treturn 'coding';\n    } else {\n\treturn $self->{'numbering'};\n    }\n}\n\n=head2 add_Mutation\n\n Title   : add_Mutation\n Usage   : $self->add_Mutation($ref)\n Function: adds a Bio::LiveSeq::Mutation object\n Example :\n Returns :\n Args    : a Bio::LiveSeq::Mutation\n\nSee L<Bio::LiveSeq::Mutation> for more information.\n\n\nsub add_Mutation{\n    my ($self,$value) = @_;\n    if( $value->isa('Bio::Liveseq::Mutation') ) {\n\tmy $com = ref $value;\n\t$self->throw(\"Is not a Mutation object but a [$com]\" );\n\treturn;\n    }\n    if (! $value->pos) {\n\t$self->warn(\"No value for mutation position in the sequence!\");\n\treturn;\n    }\n    if (! $value->seq && ! $value->len) {\n\t$self->warn(\"Either mutated sequence or length of the deletion must be given!\");\n\treturn;\n    }\n    push(@{$self->{'mutations'}},$value);\n}\n\n=head2 each_Mutation\n\n Title   : each_Mutation\n Usage   : foreach $ref ( $a->each_Mutation )\n Function: gets an array of Bio::LiveSeq::Mutation objects\n Example :\n Returns : array of Mutations\n Args    :\n\nSee L<Bio::LiveSeq::Mutation> for more information.\n\n\nsub each_Mutation{\n   my ($self) = @_;\n   return @{$self->{'mutations'}};\n}\n\n\n=head2 mutation\n\n Title   : mutation\n Usage   : $mutobj = $obj->mutation;\n         : $mutobj = $obj->mutation($objref);\n Function:\n\n           Returns or sets the link-reference to the current mutation\n           object.  If the value is not set, it will return undef.\n           Internal method.\n\n Returns : an object reference  or undef\n\n\n\nsub mutation {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Mutation') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::Mutation object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'mutation'} = $value;\n      }\n  }\n  unless (exists $self->{'mutation'}) {\n      return;\n  } else {\n      return $self->{'mutation'};\n  }\n}\n\n=head2 DNA\n\n Title   : DNA\n Usage   : $mutobj = $obj->DNA;\n         : $mutobj = $obj->DNA($objref);\n Function:\n\n           Returns or sets the reference to the LiveSeq object holding\n           the reference sequence. If there is no link, it will return\n           undef.\n           Internal method.\n\n Returns : an object reference or undef\n\n\nsub DNA {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::DNA') and ! $value->isa('Bio::LiveSeq::Transcript') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::DNA/Transcript object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'DNA'} = $value;\n      }\n  }\n  unless (exists $self->{'DNA'}) {\n      return;\n  } else {\n      return $self->{'DNA'};\n  }\n}\n\n\n=head2 RNA\n\n Title   : RNA\n Usage   : $mutobj = $obj->RNA;\n         : $mutobj = $obj->RNA($objref);\n Function:\n\n           Returns or sets the reference to the LiveSeq object holding\n           the reference sequence. If the value is not set, it will return\n           undef.\n           Internal method.\n\n Returns : an object reference  or undef\n\n\n\nsub RNA {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Transcript') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::RNA/Transcript object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'RNA'} = $value;\n      }\n  }\n  unless (exists $self->{'RNA'}) {\n      return;\n  } else {\n      return $self->{'RNA'};\n  }\n}\n\n\n=head2 dnamut\n\n Title   : dnamut\n Usage   : $mutobj = $obj->dnamut;\n         : $mutobj = $obj->dnamut($objref);\n Function:\n\n           Returns or sets the reference to the current DNAMutation object.\n           If the value is not set, it will return undef.\n           Internal method.\n\n Returns : a Bio::Variation::DNAMutation object or undef\n\nSee L<Bio::Variation::DNAMutation> for more information.\n\n\n\nsub dnamut {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::DNAMutation') ) {\n\t  $self->throw(\"Is not a Bio::Variation::DNAMutation object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'dnamut'} = $value;\n      }\n  }\n  unless (exists $self->{'dnamut'}) {\n      return;\n  } else {\n      return $self->{'dnamut'};\n  }\n}\n\n\n=head2 rnachange\n\n Title   : rnachange\n Usage   : $mutobj = $obj->rnachange;\n         : $mutobj = $obj->rnachange($objref);\n Function:\n\n           Returns or sets the reference to the current RNAChange object.\n           If the value is not set, it will return undef.\n           Internal method.\n\n Returns : a Bio::Variation::RNAChange object or undef\n\nSee L<Bio::Variation::RNAChange> for more information.\n\n\n\nsub rnachange {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::RNAChange') ) {\n\t  $self->throw(\"Is not a Bio::Variation::RNAChange object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'rnachange'} = $value;\n      }\n  }\n  unless (exists $self->{'rnachange'}) {\n      return;\n  } else {\n      return $self->{'rnachange'};\n  }\n}\n\n\n=head2 aachange\n\n Title   : aachange\n Usage   : $mutobj = $obj->aachange;\n         : $mutobj = $obj->aachange($objref);\n Function:\n\n           Returns or sets the reference to the current AAChange object.\n           If the value is not set, it will return undef.\n           Internal method.\n\n Returns : a Bio::Variation::AAChange object or undef\n\nSee L<Bio::Variation::AAChange> for more information.\n\n\n\nsub aachange {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::AAChange') ) {\n\t  $self->throw(\"Is not a Bio::Variation::AAChange object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'aachange'} = $value;\n      }\n  }\n  unless (exists $self->{'aachange'}) {\n      return;\n  } else {\n      return $self->{'aachange'};\n  }\n}\n\n\n=head2 exons\n\n Title   : exons\n Usage   : $mutobj = $obj->exons;\n         : $mutobj = $obj->exons($objref);\n Function:\n\n           Returns or sets the reference to a current array of Exons.\n           If the value is not set, it will return undef.\n           Internal method.\n\n Returns : an array of Bio::LiveSeq::Exon objects or undef\n\nSee L<Bio::LiveSeq::Exon> for more information.","parameters":[{"label":"$self"},{"label":"$value"}]},"range":{"start":{"character":0,"line":474},"end":{"character":9999,"line":484}},"kind":12,"line":474,"detail":"($self,$value)","definition":"sub","containerName":"main::","name":"exons","children":[{"definition":"my","line":475,"name":"$self","containerName":"exons","localvar":"my","kind":13},{"line":475,"kind":13,"containerName":"exons","name":"$value"},{"name":"$value","kind":13,"containerName":"exons","line":476},{"line":477,"name":"$self","containerName":"exons","kind":13},{"name":"$value","containerName":"exons","kind":13,"line":477},{"containerName":"exons","kind":13,"name":"$self","line":479},{"line":482,"name":"$self","containerName":"exons","kind":13}]},{"name":"change_gene_with_alignment","containerName":"main::","children":[{"kind":13,"localvar":"my","containerName":"change_gene_with_alignment","name":"$self","line":512,"definition":"my"},{"line":512,"containerName":"change_gene_with_alignment","kind":13,"name":"$aln"},{"line":518,"containerName":"change_gene_with_alignment","kind":13,"name":"$self"},{"line":518,"name":"throw","containerName":"change_gene_with_alignment","kind":12},{"line":519,"name":"$aln","kind":13,"containerName":"change_gene_with_alignment"},{"line":519,"containerName":"change_gene_with_alignment","kind":12,"name":"isa"},{"line":520,"name":"$self","kind":13,"containerName":"change_gene_with_alignment"},{"line":520,"containerName":"change_gene_with_alignment","kind":12,"name":"throw"},{"name":"$aln","containerName":"change_gene_with_alignment","kind":13,"line":521},{"kind":12,"containerName":"change_gene_with_alignment","name":"no_sequences","line":521},{"definition":"my","line":524,"name":"$queryseq_pos","localvar":"my","kind":13,"containerName":"change_gene_with_alignment"},{"kind":13,"localvar":"my","containerName":"change_gene_with_alignment","name":"$refseq_pos","line":525,"definition":"my"},{"line":526,"name":"$aln","kind":13,"containerName":"change_gene_with_alignment"},{"containerName":"change_gene_with_alignment","kind":12,"name":"get_seq_by_pos","line":526},{"line":526,"name":"id","kind":12,"containerName":"change_gene_with_alignment"},{"line":528,"name":"$aln","containerName":"change_gene_with_alignment","kind":13},{"line":528,"name":"get_seq_by_pos","containerName":"change_gene_with_alignment","kind":12},{"containerName":"change_gene_with_alignment","kind":12,"name":"id","line":528},{"name":"$queryseq_pos","kind":13,"containerName":"change_gene_with_alignment","line":529},{"line":530,"name":"$refseq_pos","kind":13,"containerName":"change_gene_with_alignment"},{"definition":"my","line":534,"name":"$start","localvar":"my","kind":13,"containerName":"change_gene_with_alignment"},{"line":534,"kind":13,"containerName":"change_gene_with_alignment","name":"$aln"},{"containerName":"change_gene_with_alignment","kind":12,"name":"column_from_residue_number","line":534},{"definition":"my","line":535,"localvar":"my","containerName":"change_gene_with_alignment","kind":13,"name":"$end"},{"line":535,"name":"$aln","kind":13,"containerName":"change_gene_with_alignment"},{"kind":12,"containerName":"change_gene_with_alignment","name":"column_from_residue_number","line":535},{"line":536,"name":"$aln","containerName":"change_gene_with_alignment","kind":13},{"line":536,"containerName":"change_gene_with_alignment","kind":12,"name":"get_seq_by_pos"},{"name":"$queryseq_pos","kind":13,"containerName":"change_gene_with_alignment","line":536},{"kind":12,"containerName":"change_gene_with_alignment","name":"end","line":536},{"line":538,"localvar":"my","kind":13,"containerName":"change_gene_with_alignment","name":"$aln2","definition":"my"},{"line":538,"name":"$aln","kind":13,"containerName":"change_gene_with_alignment"},{"name":"slice","containerName":"change_gene_with_alignment","kind":12,"line":538},{"kind":13,"containerName":"change_gene_with_alignment","name":"$start","line":538},{"line":538,"kind":13,"containerName":"change_gene_with_alignment","name":"$end"},{"containerName":"change_gene_with_alignment","localvar":"my","kind":13,"name":"$cs","line":544,"definition":"my"},{"kind":13,"containerName":"change_gene_with_alignment","name":"$aln2","line":544},{"kind":12,"containerName":"change_gene_with_alignment","name":"consensus_string","line":544},{"line":545,"name":"$queryseq","kind":13,"localvar":"my","containerName":"change_gene_with_alignment","definition":"my"},{"containerName":"change_gene_with_alignment","kind":13,"name":"$aln2","line":545},{"containerName":"change_gene_with_alignment","kind":12,"name":"get_seq_by_pos","line":545},{"name":"$queryseq_pos","kind":13,"containerName":"change_gene_with_alignment","line":545},{"definition":"my","localvar":"my","kind":13,"containerName":"change_gene_with_alignment","name":"$refseq","line":546},{"line":546,"name":"$aln2","kind":13,"containerName":"change_gene_with_alignment"},{"line":546,"containerName":"change_gene_with_alignment","kind":12,"name":"get_seq_by_pos"},{"name":"$refseq_pos","kind":13,"containerName":"change_gene_with_alignment","line":546},{"line":548,"name":"$cs","containerName":"change_gene_with_alignment","kind":13},{"line":550,"name":"$pos","kind":13,"localvar":"my","containerName":"change_gene_with_alignment","definition":"my"},{"line":550,"name":"$cs","containerName":"change_gene_with_alignment","kind":13},{"definition":"my","kind":13,"localvar":"my","containerName":"change_gene_with_alignment","name":"$mutation","line":551},{"line":551,"name":"$self","kind":13,"containerName":"change_gene_with_alignment"},{"name":"$refseq","kind":13,"containerName":"change_gene_with_alignment","line":552},{"name":"$queryseq","kind":13,"containerName":"change_gene_with_alignment","line":553},{"kind":13,"containerName":"change_gene_with_alignment","name":"$pos","line":554},{"line":558,"containerName":"change_gene_with_alignment","kind":13,"name":"$pos"},{"line":558,"containerName":"change_gene_with_alignment","kind":13,"name":"$refseq"},{"containerName":"change_gene_with_alignment","kind":12,"name":"start","line":558},{"kind":13,"containerName":"change_gene_with_alignment","name":"$mutation","line":559},{"line":559,"containerName":"change_gene_with_alignment","kind":12,"name":"pos"},{"kind":13,"containerName":"change_gene_with_alignment","name":"$pos","line":559},{"line":561,"containerName":"change_gene_with_alignment","kind":13,"name":"$self"},{"containerName":"change_gene_with_alignment","kind":12,"name":"add_Mutation","line":561},{"line":561,"name":"$mutation","kind":13,"containerName":"change_gene_with_alignment"},{"line":563,"name":"$self","kind":13,"containerName":"change_gene_with_alignment"},{"line":563,"containerName":"change_gene_with_alignment","kind":12,"name":"change_gene"}],"detail":"($self,$aln)","definition":"sub","range":{"start":{"line":511,"character":0},"end":{"line":564,"character":9999}},"kind":12,"line":511,"signature":{"label":"change_gene_with_alignment($self,$aln)","parameters":[{"label":"$self"},{"label":"$aln"}],"documentation":"1;\n# $Id: Mutator.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::Mutator\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::Mutator - Package mutating LiveSequences\n\n=head1 SYNOPSIS\n\n  # $gene is a Bio::LiveSeq::Gene object\n  my $mutate = Bio::LiveSeq::Mutator->new('-gene' => $gene,\n  \t\t\t\t\t  '-numbering' => \"coding\"\n  \t\t\t\t\t   );\n  # $mut is a Bio::LiveSeq::Mutation object\n  $mutate->add_Mutation($mut);\n  # $results is a Bio::Variation::SeqDiff object\n  my $results=$mutate->change_gene();\n  if ($results) {\n      my $out = Bio::Variation::IO->new( '-format' => 'flat');\n      $out->write($results);\n  }\n\n=head1 DESCRIPTION\n\nThis class mutates Bio::LiveSeq::Gene objects and returns a\nBio::Variation::SeqDiff object. Mutations are described as\nBio::LiveSeq::Mutation objects. See L<Bio::LiveSeq::Gene>,\nL<Bio::Variation::SeqDiff>, and L<Bio::LiveSeq::Mutation> for details.\n\n=head1 FEEDBACK\n\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho & Joseph A.L. Insana\n\n  Email:  heikki-at-bioperl-dot-org\n          insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\n  The rest of the documentation details each of the object\n  methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::Mutator;\nuse strict;\n\nuse Bio::Variation::SeqDiff;\nuse Bio::Variation::DNAMutation;\nuse Bio::Variation::RNAChange;\nuse Bio::Variation::AAChange;\nuse Bio::Variation::Allele;\nuse Bio::LiveSeq::Mutation;\n\n#use integer;\n# Object preamble - inheritance\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n    my($class,@args) = @_;\n    my $self;\n    $self = {};\n    bless $self, $class;\n\n    my ($gene, $numbering) =\n\t    $self->_rearrange([qw(GENE\n\t\t\t\t  NUMBERING\n\t\t\t\t  )],\n\t\t\t      @args);\n\n    $self->{ 'mutations' } = [];\n\n    $gene && $self->gene($gene);\n    $numbering && $self->numbering($numbering);\n\n    #class constant;\n    $self->{'flanklen'} = 25;\n    return $self; # success - we hope!\n}\n\n=head2 gene\n\n Title   : gene\n Usage   : $mutobj = $obj->gene;\n         : $mutobj = $obj->gene($objref);\n Function:\n\n           Returns or sets the link-reference to a\n           Bio::LiveSeq::Gene object. If no value has ben set, it\n           will return undef\n\n Returns : an object reference  or undef\n Args    : a Bio::LiveSeq::Gene\n\nSee L<Bio::LiveSeq::Gene> for more information.\n\n\nsub gene {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Gene') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::Gene object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'gene'} = $value;\n      }\n  }\n  unless (exists $self->{'gene'}) {\n      return;\n  } else {\n      return $self->{'gene'};\n  }\n}\n\n\n=head2 numbering\n\n Title   : numbering\n Usage   : $obj->numbering();\n Function:\n\n            Sets and returns coordinate system used in positioning the\n            mutations. See L<change_gene> for details.\n\n Example :\n Returns : string\n Args    : string (coding [transcript number] | gene | entry)\n\n\n\nsub numbering {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif ($value =~ /(coding)( )?(\\d+)?/ or $value eq 'entry' or $value eq 'gene') {\n\t    $self->{'numbering'} = $value;\n\t} else { # defaulting to 'coding'\n\t    $self->{'numbering'} = 'coding';\n\t}\n    }\n    unless (exists $self->{'numbering'}) {\n\treturn 'coding';\n    } else {\n\treturn $self->{'numbering'};\n    }\n}\n\n=head2 add_Mutation\n\n Title   : add_Mutation\n Usage   : $self->add_Mutation($ref)\n Function: adds a Bio::LiveSeq::Mutation object\n Example :\n Returns :\n Args    : a Bio::LiveSeq::Mutation\n\nSee L<Bio::LiveSeq::Mutation> for more information.\n\n\nsub add_Mutation{\n    my ($self,$value) = @_;\n    if( $value->isa('Bio::Liveseq::Mutation') ) {\n\tmy $com = ref $value;\n\t$self->throw(\"Is not a Mutation object but a [$com]\" );\n\treturn;\n    }\n    if (! $value->pos) {\n\t$self->warn(\"No value for mutation position in the sequence!\");\n\treturn;\n    }\n    if (! $value->seq && ! $value->len) {\n\t$self->warn(\"Either mutated sequence or length of the deletion must be given!\");\n\treturn;\n    }\n    push(@{$self->{'mutations'}},$value);\n}\n\n=head2 each_Mutation\n\n Title   : each_Mutation\n Usage   : foreach $ref ( $a->each_Mutation )\n Function: gets an array of Bio::LiveSeq::Mutation objects\n Example :\n Returns : array of Mutations\n Args    :\n\nSee L<Bio::LiveSeq::Mutation> for more information.\n\n\nsub each_Mutation{\n   my ($self) = @_;\n   return @{$self->{'mutations'}};\n}\n\n\n=head2 mutation\n\n Title   : mutation\n Usage   : $mutobj = $obj->mutation;\n         : $mutobj = $obj->mutation($objref);\n Function:\n\n           Returns or sets the link-reference to the current mutation\n           object.  If the value is not set, it will return undef.\n           Internal method.\n\n Returns : an object reference  or undef\n\n\n\nsub mutation {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Mutation') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::Mutation object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'mutation'} = $value;\n      }\n  }\n  unless (exists $self->{'mutation'}) {\n      return;\n  } else {\n      return $self->{'mutation'};\n  }\n}\n\n=head2 DNA\n\n Title   : DNA\n Usage   : $mutobj = $obj->DNA;\n         : $mutobj = $obj->DNA($objref);\n Function:\n\n           Returns or sets the reference to the LiveSeq object holding\n           the reference sequence. If there is no link, it will return\n           undef.\n           Internal method.\n\n Returns : an object reference or undef\n\n\nsub DNA {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::DNA') and ! $value->isa('Bio::LiveSeq::Transcript') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::DNA/Transcript object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'DNA'} = $value;\n      }\n  }\n  unless (exists $self->{'DNA'}) {\n      return;\n  } else {\n      return $self->{'DNA'};\n  }\n}\n\n\n=head2 RNA\n\n Title   : RNA\n Usage   : $mutobj = $obj->RNA;\n         : $mutobj = $obj->RNA($objref);\n Function:\n\n           Returns or sets the reference to the LiveSeq object holding\n           the reference sequence. If the value is not set, it will return\n           undef.\n           Internal method.\n\n Returns : an object reference  or undef\n\n\n\nsub RNA {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Transcript') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::RNA/Transcript object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'RNA'} = $value;\n      }\n  }\n  unless (exists $self->{'RNA'}) {\n      return;\n  } else {\n      return $self->{'RNA'};\n  }\n}\n\n\n=head2 dnamut\n\n Title   : dnamut\n Usage   : $mutobj = $obj->dnamut;\n         : $mutobj = $obj->dnamut($objref);\n Function:\n\n           Returns or sets the reference to the current DNAMutation object.\n           If the value is not set, it will return undef.\n           Internal method.\n\n Returns : a Bio::Variation::DNAMutation object or undef\n\nSee L<Bio::Variation::DNAMutation> for more information.\n\n\n\nsub dnamut {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::DNAMutation') ) {\n\t  $self->throw(\"Is not a Bio::Variation::DNAMutation object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'dnamut'} = $value;\n      }\n  }\n  unless (exists $self->{'dnamut'}) {\n      return;\n  } else {\n      return $self->{'dnamut'};\n  }\n}\n\n\n=head2 rnachange\n\n Title   : rnachange\n Usage   : $mutobj = $obj->rnachange;\n         : $mutobj = $obj->rnachange($objref);\n Function:\n\n           Returns or sets the reference to the current RNAChange object.\n           If the value is not set, it will return undef.\n           Internal method.\n\n Returns : a Bio::Variation::RNAChange object or undef\n\nSee L<Bio::Variation::RNAChange> for more information.\n\n\n\nsub rnachange {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::RNAChange') ) {\n\t  $self->throw(\"Is not a Bio::Variation::RNAChange object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'rnachange'} = $value;\n      }\n  }\n  unless (exists $self->{'rnachange'}) {\n      return;\n  } else {\n      return $self->{'rnachange'};\n  }\n}\n\n\n=head2 aachange\n\n Title   : aachange\n Usage   : $mutobj = $obj->aachange;\n         : $mutobj = $obj->aachange($objref);\n Function:\n\n           Returns or sets the reference to the current AAChange object.\n           If the value is not set, it will return undef.\n           Internal method.\n\n Returns : a Bio::Variation::AAChange object or undef\n\nSee L<Bio::Variation::AAChange> for more information.\n\n\n\nsub aachange {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::AAChange') ) {\n\t  $self->throw(\"Is not a Bio::Variation::AAChange object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'aachange'} = $value;\n      }\n  }\n  unless (exists $self->{'aachange'}) {\n      return;\n  } else {\n      return $self->{'aachange'};\n  }\n}\n\n\n=head2 exons\n\n Title   : exons\n Usage   : $mutobj = $obj->exons;\n         : $mutobj = $obj->exons($objref);\n Function:\n\n           Returns or sets the reference to a current array of Exons.\n           If the value is not set, it will return undef.\n           Internal method.\n\n Returns : an array of Bio::LiveSeq::Exon objects or undef\n\nSee L<Bio::LiveSeq::Exon> for more information.\n\n\n\nsub exons {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      $self->{'exons'} = $value;\n  }\n  unless (exists $self->{'exons'}) {\n      return;\n  } else {\n      return $self->{'exons'};\n  }\n}\n\n=head2 change_gene_with_alignment\n\n Title   : change_gene_with_alignment\n Usage   : $results=$mutate->change_gene_with_alignment($aln);\n\n Function:\n\n           Returns a Bio::Variation::SeqDiff object containing the\n           results of the changes in the alignment. The alignment has\n           to be pairwise and have one sequence named 'QUERY', the\n           other one is assumed to be a part of the sequence from\n           $gene.\n\n           This method offers a shortcut to change_gene and\n           automates the creation of Bio::LiveSeq::Mutation objects.\n           Use it with almost identical sequnces, e.g. to locate a SNP.\n\n Args    : Bio::SimpleAlign object representing a short local alignment\n Returns : Bio::Variation::SeqDiff object or 0 on error\n\nSee L<Bio::LiveSeq::Mutation>, L<Bio::SimpleAlign>, and\nL<Bio::Variation::SeqDiff>  for more information."}},{"kind":12,"name":"carp","line":527},{"name":"create_mutation","kind":12,"line":551},{"line":555,"name":"CORE","kind":12,"containerName":"length"},{"signature":{"label":"create_mutation($self,$refseq,$queryseq,$pos,$len)","parameters":[{"label":"$self"},{"label":"$refseq"},{"label":"$queryseq"},{"label":"$pos"},{"label":"$len"}],"documentation":"1;\n# $Id: Mutator.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::Mutator\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::Mutator - Package mutating LiveSequences\n\n=head1 SYNOPSIS\n\n  # $gene is a Bio::LiveSeq::Gene object\n  my $mutate = Bio::LiveSeq::Mutator->new('-gene' => $gene,\n  \t\t\t\t\t  '-numbering' => \"coding\"\n  \t\t\t\t\t   );\n  # $mut is a Bio::LiveSeq::Mutation object\n  $mutate->add_Mutation($mut);\n  # $results is a Bio::Variation::SeqDiff object\n  my $results=$mutate->change_gene();\n  if ($results) {\n      my $out = Bio::Variation::IO->new( '-format' => 'flat');\n      $out->write($results);\n  }\n\n=head1 DESCRIPTION\n\nThis class mutates Bio::LiveSeq::Gene objects and returns a\nBio::Variation::SeqDiff object. Mutations are described as\nBio::LiveSeq::Mutation objects. See L<Bio::LiveSeq::Gene>,\nL<Bio::Variation::SeqDiff>, and L<Bio::LiveSeq::Mutation> for details.\n\n=head1 FEEDBACK\n\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho & Joseph A.L. Insana\n\n  Email:  heikki-at-bioperl-dot-org\n          insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\n  The rest of the documentation details each of the object\n  methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::Mutator;\nuse strict;\n\nuse Bio::Variation::SeqDiff;\nuse Bio::Variation::DNAMutation;\nuse Bio::Variation::RNAChange;\nuse Bio::Variation::AAChange;\nuse Bio::Variation::Allele;\nuse Bio::LiveSeq::Mutation;\n\n#use integer;\n# Object preamble - inheritance\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n    my($class,@args) = @_;\n    my $self;\n    $self = {};\n    bless $self, $class;\n\n    my ($gene, $numbering) =\n\t    $self->_rearrange([qw(GENE\n\t\t\t\t  NUMBERING\n\t\t\t\t  )],\n\t\t\t      @args);\n\n    $self->{ 'mutations' } = [];\n\n    $gene && $self->gene($gene);\n    $numbering && $self->numbering($numbering);\n\n    #class constant;\n    $self->{'flanklen'} = 25;\n    return $self; # success - we hope!\n}\n\n=head2 gene\n\n Title   : gene\n Usage   : $mutobj = $obj->gene;\n         : $mutobj = $obj->gene($objref);\n Function:\n\n           Returns or sets the link-reference to a\n           Bio::LiveSeq::Gene object. If no value has ben set, it\n           will return undef\n\n Returns : an object reference  or undef\n Args    : a Bio::LiveSeq::Gene\n\nSee L<Bio::LiveSeq::Gene> for more information.\n\n\nsub gene {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Gene') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::Gene object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'gene'} = $value;\n      }\n  }\n  unless (exists $self->{'gene'}) {\n      return;\n  } else {\n      return $self->{'gene'};\n  }\n}\n\n\n=head2 numbering\n\n Title   : numbering\n Usage   : $obj->numbering();\n Function:\n\n            Sets and returns coordinate system used in positioning the\n            mutations. See L<change_gene> for details.\n\n Example :\n Returns : string\n Args    : string (coding [transcript number] | gene | entry)\n\n\n\nsub numbering {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif ($value =~ /(coding)( )?(\\d+)?/ or $value eq 'entry' or $value eq 'gene') {\n\t    $self->{'numbering'} = $value;\n\t} else { # defaulting to 'coding'\n\t    $self->{'numbering'} = 'coding';\n\t}\n    }\n    unless (exists $self->{'numbering'}) {\n\treturn 'coding';\n    } else {\n\treturn $self->{'numbering'};\n    }\n}\n\n=head2 add_Mutation\n\n Title   : add_Mutation\n Usage   : $self->add_Mutation($ref)\n Function: adds a Bio::LiveSeq::Mutation object\n Example :\n Returns :\n Args    : a Bio::LiveSeq::Mutation\n\nSee L<Bio::LiveSeq::Mutation> for more information.\n\n\nsub add_Mutation{\n    my ($self,$value) = @_;\n    if( $value->isa('Bio::Liveseq::Mutation') ) {\n\tmy $com = ref $value;\n\t$self->throw(\"Is not a Mutation object but a [$com]\" );\n\treturn;\n    }\n    if (! $value->pos) {\n\t$self->warn(\"No value for mutation position in the sequence!\");\n\treturn;\n    }\n    if (! $value->seq && ! $value->len) {\n\t$self->warn(\"Either mutated sequence or length of the deletion must be given!\");\n\treturn;\n    }\n    push(@{$self->{'mutations'}},$value);\n}\n\n=head2 each_Mutation\n\n Title   : each_Mutation\n Usage   : foreach $ref ( $a->each_Mutation )\n Function: gets an array of Bio::LiveSeq::Mutation objects\n Example :\n Returns : array of Mutations\n Args    :\n\nSee L<Bio::LiveSeq::Mutation> for more information.\n\n\nsub each_Mutation{\n   my ($self) = @_;\n   return @{$self->{'mutations'}};\n}\n\n\n=head2 mutation\n\n Title   : mutation\n Usage   : $mutobj = $obj->mutation;\n         : $mutobj = $obj->mutation($objref);\n Function:\n\n           Returns or sets the link-reference to the current mutation\n           object.  If the value is not set, it will return undef.\n           Internal method.\n\n Returns : an object reference  or undef\n\n\n\nsub mutation {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Mutation') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::Mutation object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'mutation'} = $value;\n      }\n  }\n  unless (exists $self->{'mutation'}) {\n      return;\n  } else {\n      return $self->{'mutation'};\n  }\n}\n\n=head2 DNA\n\n Title   : DNA\n Usage   : $mutobj = $obj->DNA;\n         : $mutobj = $obj->DNA($objref);\n Function:\n\n           Returns or sets the reference to the LiveSeq object holding\n           the reference sequence. If there is no link, it will return\n           undef.\n           Internal method.\n\n Returns : an object reference or undef\n\n\nsub DNA {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::DNA') and ! $value->isa('Bio::LiveSeq::Transcript') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::DNA/Transcript object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'DNA'} = $value;\n      }\n  }\n  unless (exists $self->{'DNA'}) {\n      return;\n  } else {\n      return $self->{'DNA'};\n  }\n}\n\n\n=head2 RNA\n\n Title   : RNA\n Usage   : $mutobj = $obj->RNA;\n         : $mutobj = $obj->RNA($objref);\n Function:\n\n           Returns or sets the reference to the LiveSeq object holding\n           the reference sequence. If the value is not set, it will return\n           undef.\n           Internal method.\n\n Returns : an object reference  or undef\n\n\n\nsub RNA {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Transcript') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::RNA/Transcript object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'RNA'} = $value;\n      }\n  }\n  unless (exists $self->{'RNA'}) {\n      return;\n  } else {\n      return $self->{'RNA'};\n  }\n}\n\n\n=head2 dnamut\n\n Title   : dnamut\n Usage   : $mutobj = $obj->dnamut;\n         : $mutobj = $obj->dnamut($objref);\n Function:\n\n           Returns or sets the reference to the current DNAMutation object.\n           If the value is not set, it will return undef.\n           Internal method.\n\n Returns : a Bio::Variation::DNAMutation object or undef\n\nSee L<Bio::Variation::DNAMutation> for more information.\n\n\n\nsub dnamut {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::DNAMutation') ) {\n\t  $self->throw(\"Is not a Bio::Variation::DNAMutation object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'dnamut'} = $value;\n      }\n  }\n  unless (exists $self->{'dnamut'}) {\n      return;\n  } else {\n      return $self->{'dnamut'};\n  }\n}\n\n\n=head2 rnachange\n\n Title   : rnachange\n Usage   : $mutobj = $obj->rnachange;\n         : $mutobj = $obj->rnachange($objref);\n Function:\n\n           Returns or sets the reference to the current RNAChange object.\n           If the value is not set, it will return undef.\n           Internal method.\n\n Returns : a Bio::Variation::RNAChange object or undef\n\nSee L<Bio::Variation::RNAChange> for more information.\n\n\n\nsub rnachange {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::RNAChange') ) {\n\t  $self->throw(\"Is not a Bio::Variation::RNAChange object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'rnachange'} = $value;\n      }\n  }\n  unless (exists $self->{'rnachange'}) {\n      return;\n  } else {\n      return $self->{'rnachange'};\n  }\n}\n\n\n=head2 aachange\n\n Title   : aachange\n Usage   : $mutobj = $obj->aachange;\n         : $mutobj = $obj->aachange($objref);\n Function:\n\n           Returns or sets the reference to the current AAChange object.\n           If the value is not set, it will return undef.\n           Internal method.\n\n Returns : a Bio::Variation::AAChange object or undef\n\nSee L<Bio::Variation::AAChange> for more information.\n\n\n\nsub aachange {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::AAChange') ) {\n\t  $self->throw(\"Is not a Bio::Variation::AAChange object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'aachange'} = $value;\n      }\n  }\n  unless (exists $self->{'aachange'}) {\n      return;\n  } else {\n      return $self->{'aachange'};\n  }\n}\n\n\n=head2 exons\n\n Title   : exons\n Usage   : $mutobj = $obj->exons;\n         : $mutobj = $obj->exons($objref);\n Function:\n\n           Returns or sets the reference to a current array of Exons.\n           If the value is not set, it will return undef.\n           Internal method.\n\n Returns : an array of Bio::LiveSeq::Exon objects or undef\n\nSee L<Bio::LiveSeq::Exon> for more information.\n\n\n\nsub exons {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      $self->{'exons'} = $value;\n  }\n  unless (exists $self->{'exons'}) {\n      return;\n  } else {\n      return $self->{'exons'};\n  }\n}\n\n=head2 change_gene_with_alignment\n\n Title   : change_gene_with_alignment\n Usage   : $results=$mutate->change_gene_with_alignment($aln);\n\n Function:\n\n           Returns a Bio::Variation::SeqDiff object containing the\n           results of the changes in the alignment. The alignment has\n           to be pairwise and have one sequence named 'QUERY', the\n           other one is assumed to be a part of the sequence from\n           $gene.\n\n           This method offers a shortcut to change_gene and\n           automates the creation of Bio::LiveSeq::Mutation objects.\n           Use it with almost identical sequnces, e.g. to locate a SNP.\n\n Args    : Bio::SimpleAlign object representing a short local alignment\n Returns : Bio::Variation::SeqDiff object or 0 on error\n\nSee L<Bio::LiveSeq::Mutation>, L<Bio::SimpleAlign>, and\nL<Bio::Variation::SeqDiff>  for more information.\n\n\nsub change_gene_with_alignment {\n    my ($self, $aln) = @_;\n\n    #\n    # Sanity checks\n    #\n\n    $self->throw(\"Argument is not a Bio::SimpleAlign object but a [$aln]\")\n\tunless $aln->isa('Bio::SimpleAlign');\n    $self->throw(\"'Pairwise alignments only, please\") \n\tif $aln->no_sequences != 2;\n\n    # find out the order the two sequences are given\n    my $queryseq_pos = 1; #default\n    my $refseq_pos = 2;\n    unless ($aln->get_seq_by_pos(1)->id eq 'QUERY') {\n\tcarp('Query sequence has to be named QUERY') \n\t    if $aln->get_seq_by_pos(2)->id ne 'QUERY';\n\t$queryseq_pos = 2; # alternative\n\t$refseq_pos = 1;\n    }\n\n    # trim the alignment\n    my $start =  $aln->column_from_residue_number('QUERY', 1);\n    my $end =  $aln->column_from_residue_number('QUERY', \n\t\t\t\t\t\t$aln->get_seq_by_pos($queryseq_pos)->end );\n    \n    my $aln2 = $aln->slice($start, $end);\n\n    #\n    # extracting mutations\n    #\n\n    my $cs = $aln2->consensus_string(51);\n    my $queryseq = $aln2->get_seq_by_pos($queryseq_pos);\n    my $refseq = $aln2->get_seq_by_pos($refseq_pos);\n\n    while ( $cs =~ /(\\?+)/g) {\n\t# pos in local coordinates\n\tmy $pos = pos($cs) - length($1) + 1;\n\tmy $mutation = create_mutation($self, \n\t\t\t\t       $refseq, \n\t\t\t\t       $queryseq, \n\t\t\t\t       $pos, \n\t\t\t\t       CORE::length($1)\n\t\t\t\t       );\n\t# reset pos to refseq coordinates\n\t$pos +=  $refseq->start - 1;\n\t$mutation->pos($pos);\n\n        $self->add_Mutation($mutation);\n    }\n    return $self->change_gene();\n}\n\n=head2 create_mutation\n\n Title   : create_mutation\n Usage   : \n Function:\n\n           Formats sequence differences from two sequences into\n           Bio::LiveSeq::Mutation objects which can be applied to a\n           gene.\n\n           To keep it generic, sequence arguments need not to be\n           Bio::LocatableSeq. Coordinate change to parent sequence\n           numbering needs to be done by the calling code.\n\n           Called from change_gene_with_alignment\n\n Args    : Bio::PrimarySeqI inheriting object for the reference sequence\n           Bio::PrimarySeqI inheriting object for the query sequence\n           integer for the start position of the local sequence difference\n           integer for the length of the sequence difference\n Returns : Bio::LiveSeq::Mutation object "},"line":590,"kind":12,"range":{"end":{"character":9999,"line":632},"start":{"line":590,"character":0}},"definition":"sub","detail":"($self,$refseq,$queryseq,$pos,$len)","children":[{"line":591,"name":"$self","localvar":"my","kind":13,"containerName":"create_mutation","definition":"my"},{"line":591,"name":"$refseq","kind":13,"containerName":"create_mutation"},{"containerName":"create_mutation","kind":13,"name":"$queryseq","line":591},{"line":591,"name":"$pos","containerName":"create_mutation","kind":13},{"containerName":"create_mutation","kind":13,"name":"$len","line":591},{"line":593,"kind":13,"containerName":"create_mutation","name":"$self"},{"line":593,"containerName":"create_mutation","kind":12,"name":"throw"},{"containerName":"create_mutation","kind":13,"name":"$refseq","line":594},{"line":594,"name":"isa","containerName":"create_mutation","kind":12},{"line":595,"kind":13,"containerName":"create_mutation","name":"$self"},{"line":595,"name":"throw","kind":12,"containerName":"create_mutation"},{"containerName":"create_mutation","kind":13,"name":"$queryseq","line":596},{"line":596,"containerName":"create_mutation","kind":12,"name":"isa"},{"line":597,"kind":13,"containerName":"create_mutation","name":"$self"},{"kind":12,"containerName":"create_mutation","name":"throw","line":597},{"kind":13,"containerName":"create_mutation","name":"$pos","line":598},{"name":"$self","containerName":"create_mutation","kind":13,"line":599},{"name":"throw","kind":12,"containerName":"create_mutation","line":599},{"line":600,"name":"$len","containerName":"create_mutation","kind":13},{"line":602,"name":"$mutation","kind":13,"localvar":"my","containerName":"create_mutation","definition":"my"},{"line":603,"name":"$refstring","containerName":"create_mutation","localvar":"my","kind":13,"definition":"my"},{"kind":13,"containerName":"create_mutation","name":"$refseq","line":603},{"kind":12,"containerName":"create_mutation","name":"subseq","line":603},{"kind":13,"containerName":"create_mutation","name":"$pos","line":603},{"line":603,"kind":13,"containerName":"create_mutation","name":"$pos"},{"line":603,"name":"$len","containerName":"create_mutation","kind":13},{"name":"$varstring","containerName":"create_mutation","localvar":"my","kind":13,"line":604,"definition":"my"},{"kind":13,"containerName":"create_mutation","name":"$queryseq","line":604},{"name":"subseq","containerName":"create_mutation","kind":12,"line":604},{"kind":13,"containerName":"create_mutation","name":"$pos","line":604},{"line":604,"kind":13,"containerName":"create_mutation","name":"$pos"},{"line":604,"name":"$len","kind":13,"containerName":"create_mutation"},{"line":606,"name":"$len","kind":13,"containerName":"create_mutation"},{"line":606,"containerName":"create_mutation","kind":13,"name":"$refstring"},{"line":607,"name":"$varstring","containerName":"create_mutation","kind":13},{"containerName":"create_mutation","kind":13,"name":"$mutation","line":608},{"line":608,"name":"new","containerName":"create_mutation","kind":12},{"containerName":"create_mutation","kind":13,"name":"$varstring","line":608},{"line":609,"name":"$pos","kind":13,"containerName":"create_mutation"},{"line":612,"name":"$refstring","containerName":"create_mutation","kind":13},{"line":613,"kind":13,"containerName":"create_mutation","name":"$varstring"},{"name":"$mutation","kind":13,"containerName":"create_mutation","line":614},{"line":614,"name":"new","containerName":"create_mutation","kind":12},{"containerName":"create_mutation","kind":13,"name":"$pos","line":614},{"line":616,"name":"$len","containerName":"create_mutation","kind":13},{"containerName":"create_mutation","kind":13,"name":"$refstring","line":618},{"name":"$varstring","kind":13,"containerName":"create_mutation","line":619},{"kind":13,"containerName":"create_mutation","name":"$mutation","line":620},{"name":"new","containerName":"create_mutation","kind":12,"line":620},{"line":620,"name":"$varstring","containerName":"create_mutation","kind":13},{"line":621,"name":"$pos","kind":13,"containerName":"create_mutation"},{"name":"$mutation","containerName":"create_mutation","kind":13,"line":625},{"kind":12,"containerName":"create_mutation","name":"new","line":625},{"name":"$varstring","kind":13,"containerName":"create_mutation","line":625},{"line":626,"kind":13,"containerName":"create_mutation","name":"$pos"},{"line":628,"name":"$len","containerName":"create_mutation","kind":13},{"kind":13,"containerName":"create_mutation","name":"$mutation","line":631}],"name":"create_mutation","containerName":"main::"},{"name":"Bio","kind":12,"containerName":"LiveSeq::Mutation","line":608},{"line":614,"name":"Bio","containerName":"LiveSeq::Mutation","kind":12},{"line":620,"name":"Bio","kind":12,"containerName":"LiveSeq::Mutation"},{"name":"Bio","kind":12,"containerName":"LiveSeq::Mutation","line":625},{"kind":12,"range":{"start":{"line":679,"character":0},"end":{"character":9999,"line":692}},"line":679,"signature":{"label":"change_gene($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Mutator.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::Mutator\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::Mutator - Package mutating LiveSequences\n\n=head1 SYNOPSIS\n\n  # $gene is a Bio::LiveSeq::Gene object\n  my $mutate = Bio::LiveSeq::Mutator->new('-gene' => $gene,\n  \t\t\t\t\t  '-numbering' => \"coding\"\n  \t\t\t\t\t   );\n  # $mut is a Bio::LiveSeq::Mutation object\n  $mutate->add_Mutation($mut);\n  # $results is a Bio::Variation::SeqDiff object\n  my $results=$mutate->change_gene();\n  if ($results) {\n      my $out = Bio::Variation::IO->new( '-format' => 'flat');\n      $out->write($results);\n  }\n\n=head1 DESCRIPTION\n\nThis class mutates Bio::LiveSeq::Gene objects and returns a\nBio::Variation::SeqDiff object. Mutations are described as\nBio::LiveSeq::Mutation objects. See L<Bio::LiveSeq::Gene>,\nL<Bio::Variation::SeqDiff>, and L<Bio::LiveSeq::Mutation> for details.\n\n=head1 FEEDBACK\n\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho & Joseph A.L. Insana\n\n  Email:  heikki-at-bioperl-dot-org\n          insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\n  The rest of the documentation details each of the object\n  methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::Mutator;\nuse strict;\n\nuse Bio::Variation::SeqDiff;\nuse Bio::Variation::DNAMutation;\nuse Bio::Variation::RNAChange;\nuse Bio::Variation::AAChange;\nuse Bio::Variation::Allele;\nuse Bio::LiveSeq::Mutation;\n\n#use integer;\n# Object preamble - inheritance\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n    my($class,@args) = @_;\n    my $self;\n    $self = {};\n    bless $self, $class;\n\n    my ($gene, $numbering) =\n\t    $self->_rearrange([qw(GENE\n\t\t\t\t  NUMBERING\n\t\t\t\t  )],\n\t\t\t      @args);\n\n    $self->{ 'mutations' } = [];\n\n    $gene && $self->gene($gene);\n    $numbering && $self->numbering($numbering);\n\n    #class constant;\n    $self->{'flanklen'} = 25;\n    return $self; # success - we hope!\n}\n\n=head2 gene\n\n Title   : gene\n Usage   : $mutobj = $obj->gene;\n         : $mutobj = $obj->gene($objref);\n Function:\n\n           Returns or sets the link-reference to a\n           Bio::LiveSeq::Gene object. If no value has ben set, it\n           will return undef\n\n Returns : an object reference  or undef\n Args    : a Bio::LiveSeq::Gene\n\nSee L<Bio::LiveSeq::Gene> for more information.\n\n\nsub gene {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Gene') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::Gene object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'gene'} = $value;\n      }\n  }\n  unless (exists $self->{'gene'}) {\n      return;\n  } else {\n      return $self->{'gene'};\n  }\n}\n\n\n=head2 numbering\n\n Title   : numbering\n Usage   : $obj->numbering();\n Function:\n\n            Sets and returns coordinate system used in positioning the\n            mutations. See L<change_gene> for details.\n\n Example :\n Returns : string\n Args    : string (coding [transcript number] | gene | entry)\n\n\n\nsub numbering {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif ($value =~ /(coding)( )?(\\d+)?/ or $value eq 'entry' or $value eq 'gene') {\n\t    $self->{'numbering'} = $value;\n\t} else { # defaulting to 'coding'\n\t    $self->{'numbering'} = 'coding';\n\t}\n    }\n    unless (exists $self->{'numbering'}) {\n\treturn 'coding';\n    } else {\n\treturn $self->{'numbering'};\n    }\n}\n\n=head2 add_Mutation\n\n Title   : add_Mutation\n Usage   : $self->add_Mutation($ref)\n Function: adds a Bio::LiveSeq::Mutation object\n Example :\n Returns :\n Args    : a Bio::LiveSeq::Mutation\n\nSee L<Bio::LiveSeq::Mutation> for more information.\n\n\nsub add_Mutation{\n    my ($self,$value) = @_;\n    if( $value->isa('Bio::Liveseq::Mutation') ) {\n\tmy $com = ref $value;\n\t$self->throw(\"Is not a Mutation object but a [$com]\" );\n\treturn;\n    }\n    if (! $value->pos) {\n\t$self->warn(\"No value for mutation position in the sequence!\");\n\treturn;\n    }\n    if (! $value->seq && ! $value->len) {\n\t$self->warn(\"Either mutated sequence or length of the deletion must be given!\");\n\treturn;\n    }\n    push(@{$self->{'mutations'}},$value);\n}\n\n=head2 each_Mutation\n\n Title   : each_Mutation\n Usage   : foreach $ref ( $a->each_Mutation )\n Function: gets an array of Bio::LiveSeq::Mutation objects\n Example :\n Returns : array of Mutations\n Args    :\n\nSee L<Bio::LiveSeq::Mutation> for more information.\n\n\nsub each_Mutation{\n   my ($self) = @_;\n   return @{$self->{'mutations'}};\n}\n\n\n=head2 mutation\n\n Title   : mutation\n Usage   : $mutobj = $obj->mutation;\n         : $mutobj = $obj->mutation($objref);\n Function:\n\n           Returns or sets the link-reference to the current mutation\n           object.  If the value is not set, it will return undef.\n           Internal method.\n\n Returns : an object reference  or undef\n\n\n\nsub mutation {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Mutation') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::Mutation object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'mutation'} = $value;\n      }\n  }\n  unless (exists $self->{'mutation'}) {\n      return;\n  } else {\n      return $self->{'mutation'};\n  }\n}\n\n=head2 DNA\n\n Title   : DNA\n Usage   : $mutobj = $obj->DNA;\n         : $mutobj = $obj->DNA($objref);\n Function:\n\n           Returns or sets the reference to the LiveSeq object holding\n           the reference sequence. If there is no link, it will return\n           undef.\n           Internal method.\n\n Returns : an object reference or undef\n\n\nsub DNA {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::DNA') and ! $value->isa('Bio::LiveSeq::Transcript') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::DNA/Transcript object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'DNA'} = $value;\n      }\n  }\n  unless (exists $self->{'DNA'}) {\n      return;\n  } else {\n      return $self->{'DNA'};\n  }\n}\n\n\n=head2 RNA\n\n Title   : RNA\n Usage   : $mutobj = $obj->RNA;\n         : $mutobj = $obj->RNA($objref);\n Function:\n\n           Returns or sets the reference to the LiveSeq object holding\n           the reference sequence. If the value is not set, it will return\n           undef.\n           Internal method.\n\n Returns : an object reference  or undef\n\n\n\nsub RNA {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Transcript') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::RNA/Transcript object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'RNA'} = $value;\n      }\n  }\n  unless (exists $self->{'RNA'}) {\n      return;\n  } else {\n      return $self->{'RNA'};\n  }\n}\n\n\n=head2 dnamut\n\n Title   : dnamut\n Usage   : $mutobj = $obj->dnamut;\n         : $mutobj = $obj->dnamut($objref);\n Function:\n\n           Returns or sets the reference to the current DNAMutation object.\n           If the value is not set, it will return undef.\n           Internal method.\n\n Returns : a Bio::Variation::DNAMutation object or undef\n\nSee L<Bio::Variation::DNAMutation> for more information.\n\n\n\nsub dnamut {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::DNAMutation') ) {\n\t  $self->throw(\"Is not a Bio::Variation::DNAMutation object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'dnamut'} = $value;\n      }\n  }\n  unless (exists $self->{'dnamut'}) {\n      return;\n  } else {\n      return $self->{'dnamut'};\n  }\n}\n\n\n=head2 rnachange\n\n Title   : rnachange\n Usage   : $mutobj = $obj->rnachange;\n         : $mutobj = $obj->rnachange($objref);\n Function:\n\n           Returns or sets the reference to the current RNAChange object.\n           If the value is not set, it will return undef.\n           Internal method.\n\n Returns : a Bio::Variation::RNAChange object or undef\n\nSee L<Bio::Variation::RNAChange> for more information.\n\n\n\nsub rnachange {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::RNAChange') ) {\n\t  $self->throw(\"Is not a Bio::Variation::RNAChange object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'rnachange'} = $value;\n      }\n  }\n  unless (exists $self->{'rnachange'}) {\n      return;\n  } else {\n      return $self->{'rnachange'};\n  }\n}\n\n\n=head2 aachange\n\n Title   : aachange\n Usage   : $mutobj = $obj->aachange;\n         : $mutobj = $obj->aachange($objref);\n Function:\n\n           Returns or sets the reference to the current AAChange object.\n           If the value is not set, it will return undef.\n           Internal method.\n\n Returns : a Bio::Variation::AAChange object or undef\n\nSee L<Bio::Variation::AAChange> for more information.\n\n\n\nsub aachange {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::AAChange') ) {\n\t  $self->throw(\"Is not a Bio::Variation::AAChange object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'aachange'} = $value;\n      }\n  }\n  unless (exists $self->{'aachange'}) {\n      return;\n  } else {\n      return $self->{'aachange'};\n  }\n}\n\n\n=head2 exons\n\n Title   : exons\n Usage   : $mutobj = $obj->exons;\n         : $mutobj = $obj->exons($objref);\n Function:\n\n           Returns or sets the reference to a current array of Exons.\n           If the value is not set, it will return undef.\n           Internal method.\n\n Returns : an array of Bio::LiveSeq::Exon objects or undef\n\nSee L<Bio::LiveSeq::Exon> for more information.\n\n\n\nsub exons {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      $self->{'exons'} = $value;\n  }\n  unless (exists $self->{'exons'}) {\n      return;\n  } else {\n      return $self->{'exons'};\n  }\n}\n\n=head2 change_gene_with_alignment\n\n Title   : change_gene_with_alignment\n Usage   : $results=$mutate->change_gene_with_alignment($aln);\n\n Function:\n\n           Returns a Bio::Variation::SeqDiff object containing the\n           results of the changes in the alignment. The alignment has\n           to be pairwise and have one sequence named 'QUERY', the\n           other one is assumed to be a part of the sequence from\n           $gene.\n\n           This method offers a shortcut to change_gene and\n           automates the creation of Bio::LiveSeq::Mutation objects.\n           Use it with almost identical sequnces, e.g. to locate a SNP.\n\n Args    : Bio::SimpleAlign object representing a short local alignment\n Returns : Bio::Variation::SeqDiff object or 0 on error\n\nSee L<Bio::LiveSeq::Mutation>, L<Bio::SimpleAlign>, and\nL<Bio::Variation::SeqDiff>  for more information.\n\n\nsub change_gene_with_alignment {\n    my ($self, $aln) = @_;\n\n    #\n    # Sanity checks\n    #\n\n    $self->throw(\"Argument is not a Bio::SimpleAlign object but a [$aln]\")\n\tunless $aln->isa('Bio::SimpleAlign');\n    $self->throw(\"'Pairwise alignments only, please\") \n\tif $aln->no_sequences != 2;\n\n    # find out the order the two sequences are given\n    my $queryseq_pos = 1; #default\n    my $refseq_pos = 2;\n    unless ($aln->get_seq_by_pos(1)->id eq 'QUERY') {\n\tcarp('Query sequence has to be named QUERY') \n\t    if $aln->get_seq_by_pos(2)->id ne 'QUERY';\n\t$queryseq_pos = 2; # alternative\n\t$refseq_pos = 1;\n    }\n\n    # trim the alignment\n    my $start =  $aln->column_from_residue_number('QUERY', 1);\n    my $end =  $aln->column_from_residue_number('QUERY', \n\t\t\t\t\t\t$aln->get_seq_by_pos($queryseq_pos)->end );\n    \n    my $aln2 = $aln->slice($start, $end);\n\n    #\n    # extracting mutations\n    #\n\n    my $cs = $aln2->consensus_string(51);\n    my $queryseq = $aln2->get_seq_by_pos($queryseq_pos);\n    my $refseq = $aln2->get_seq_by_pos($refseq_pos);\n\n    while ( $cs =~ /(\\?+)/g) {\n\t# pos in local coordinates\n\tmy $pos = pos($cs) - length($1) + 1;\n\tmy $mutation = create_mutation($self, \n\t\t\t\t       $refseq, \n\t\t\t\t       $queryseq, \n\t\t\t\t       $pos, \n\t\t\t\t       CORE::length($1)\n\t\t\t\t       );\n\t# reset pos to refseq coordinates\n\t$pos +=  $refseq->start - 1;\n\t$mutation->pos($pos);\n\n        $self->add_Mutation($mutation);\n    }\n    return $self->change_gene();\n}\n\n=head2 create_mutation\n\n Title   : create_mutation\n Usage   : \n Function:\n\n           Formats sequence differences from two sequences into\n           Bio::LiveSeq::Mutation objects which can be applied to a\n           gene.\n\n           To keep it generic, sequence arguments need not to be\n           Bio::LocatableSeq. Coordinate change to parent sequence\n           numbering needs to be done by the calling code.\n\n           Called from change_gene_with_alignment\n\n Args    : Bio::PrimarySeqI inheriting object for the reference sequence\n           Bio::PrimarySeqI inheriting object for the query sequence\n           integer for the start position of the local sequence difference\n           integer for the length of the sequence difference\n Returns : Bio::LiveSeq::Mutation object \n\n\nsub create_mutation {\n    my ($self, $refseq, $queryseq, $pos, $len) = @_;\n    \n    $self->throw(\"Is not a Bio::PrimarySeqI object but a [$refseq]\") \n\tunless $refseq->isa('Bio::PrimarySeqI');\n    $self->throw(\"Is not a Bio::PrimarySeqI object but a [$queryseq]\") \n\tunless $queryseq->isa('Bio::PrimarySeqI');\n    $self->throw(\"Position is not a positive integer but [$pos]\") \n\tunless $pos =~ /^\\+?\\d+$/;\n    $self->throw(\"Length is not a positive integer but [$len]\") \n\tunless $len =~ /^\\+?\\d+$/;\n\n    my $mutation;\n    my $refstring = $refseq->subseq($pos, $pos + $len - 1);\n    my $varstring = $queryseq->subseq($pos, $pos + $len - 1);\n    \n    if ($len == 1 and $refstring =~ /[^\\.\\-\\*\\?]/ and \n\t$varstring  =~ /[^\\.\\-\\*\\?]/ ) { #point\n\t$mutation = Bio::LiveSeq::Mutation->new(-seq => $varstring,\n\t\t\t\t\t\t-pos => $pos,\n\t\t\t\t\t\t);\n    }\n    elsif ( $refstring =~ /^[^\\.\\-\\*\\?]+$/ and \n\t    $varstring  !~ /^[^\\.\\-\\*\\?]+$/ ) { # deletion\n\t$mutation = Bio::LiveSeq::Mutation->new(-pos => $pos,\n\t\t\t\t\t\t-len => $len\n\t\t\t\t\t\t);\n    }\n    elsif ( $refstring !~ /^[^\\.\\-\\*\\?]+$/ and \n\t    $varstring  =~ /^[^\\.\\-\\*\\?]+$/ ) { # insertion\n\t$mutation = Bio::LiveSeq::Mutation->new(-seq => $varstring,\n\t\t\t\t\t\t-pos => $pos,\n\t\t\t\t\t\t-len => 0\n\t\t\t\t\t\t);\n    } else { # complex\n\t$mutation = Bio::LiveSeq::Mutation->new(-seq => $varstring,\n\t\t\t\t\t\t-pos => $pos,\n\t\t\t\t\t\t-len => $len\n\t\t\t\t\t\t);\n    }\n    \n    return $mutation;\n}\n\n=head2 change_gene\n\n Title   : change_gene\n Usage   : my $mutate = Bio::LiveSeq::Mutator->new(-gene => $gene,\n\t\t\t\t\t\t   numbering => \"coding\"\n\t\t\t\t\t\t   );\n           # $mut is Bio::LiveSeq::Mutation object\n           $mutate->add_Mutation($mut);\n           my $results=$mutate->change_gene();\n\n Function:\n\n           Returns a Bio::Variation::SeqDiff object containing the\n           results of the changes performed according to the\n           instructions present in Mutation(s).  The -numbering\n           argument decides what molecule is being changed and what\n           numbering scheme being used:\n\n            -numbering => \"entry\"\n\n               determines the DNA level, using the numbering from the\n               beginning of the sequence\n\n            -numbering => \"coding\"\n\n               determines the RNA level, using the numbering from the\n               beginning of the 1st transcript\n\n               Alternative transcripts can be used by specifying\n               \"coding 2\" or \"coding 3\" ...\n\n            -numbering => \"gene\"\n\n               determines the DNA level, using the numbering from the\n               beginning of the 1st transcript and inluding introns.\n               The meaning equals 'coding' if the reference molecule\n               is cDNA.\n\n Args    : Bio::LiveSeq::Gene object\n           Bio::LiveSeq::Mutation object(s)\n           string specifying a numbering scheme (defaults to 'coding')\n Returns : Bio::Variation::SeqDiff object or 0 on error"},"containerName":"main::","name":"change_gene","children":[{"definition":"my","containerName":"change_gene","localvar":"my","kind":13,"name":"$self","line":680},{"line":685,"name":"$self","containerName":"change_gene","kind":13},{"name":"gene","kind":12,"containerName":"change_gene","line":685},{"name":"$self","kind":13,"containerName":"change_gene","line":686},{"line":686,"containerName":"change_gene","kind":12,"name":"warn"},{"definition":"my","line":692,"containerName":"change_gene","localvar":"my","kind":13,"name":"@transcripts"},{"kind":13,"containerName":"change_gene","name":"$self","line":692},{"name":"gene","kind":12,"containerName":"change_gene","line":692},{"line":692,"containerName":"change_gene","kind":12,"name":"get_Transcripts"}],"detail":"($self)","definition":"sub"},{"line":693,"localvar":"my","kind":13,"containerName":null,"name":"$refseq","definition":"my"},{"line":696,"kind":13,"containerName":null,"name":"$self"},{"line":696,"kind":12,"containerName":"main::","name":"numbering"},{"name":"$self","containerName":null,"kind":13,"line":696},{"name":"gene","kind":12,"containerName":"main::","line":696},{"name":"get_DNA","kind":12,"containerName":"main::","line":696},{"kind":12,"containerName":"main::","name":"alphabet","line":696},{"line":696,"kind":13,"containerName":null,"name":"$self"},{"kind":12,"containerName":"main::","name":"numbering","line":696},{"name":"$self","containerName":null,"kind":13,"line":698},{"line":698,"containerName":"main::","kind":12,"name":"numbering"},{"line":699,"name":"$self","kind":13,"containerName":null},{"line":699,"name":"numbering","kind":12,"containerName":"main::"},{"definition":"my","name":"$transnumber","containerName":null,"localvar":"my","kind":13,"line":700},{"name":"$transnumber","kind":13,"containerName":null,"line":701},{"line":702,"name":"$transnumber","kind":13,"containerName":null},{"line":702,"name":"$transnumber","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"$transnumber","line":702},{"line":702,"name":"transcripts","kind":12},{"containerName":null,"kind":13,"name":"$refseq","line":703},{"line":703,"name":"@transcripts","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"%transnumber","line":703},{"line":705,"name":"$transnumber","containerName":null,"kind":13},{"name":"$self","kind":13,"containerName":null,"line":705},{"name":"warn","containerName":"main::","kind":12,"line":705},{"line":705,"kind":13,"containerName":null,"name":"$transnumber"},{"containerName":null,"kind":13,"name":"$refseq","line":707},{"line":707,"kind":13,"containerName":null,"name":"@transcripts"},{"line":710,"containerName":null,"kind":13,"name":"$refseq"},{"line":710,"kind":13,"containerName":null,"name":"@transcripts"},{"definition":"my","containerName":null,"localvar":"my","kind":13,"name":"$seqDiff","line":715},{"kind":12,"containerName":"Variation::SeqDiff","name":"Bio","line":715},{"containerName":"main::","kind":12,"name":"new","line":715},{"name":"$self","containerName":null,"kind":13,"line":715},{"containerName":"main::","kind":12,"name":"verbose","line":715},{"line":716,"kind":13,"containerName":null,"name":"$seqDiff"},{"kind":12,"containerName":"main::","name":"alphabet","line":716},{"line":716,"kind":13,"containerName":null,"name":"$self"},{"line":716,"containerName":"main::","kind":12,"name":"gene"},{"containerName":"main::","kind":12,"name":"get_DNA","line":716},{"line":716,"name":"alphabet","kind":12,"containerName":"main::"},{"line":717,"name":"$seqDiff","containerName":null,"kind":13},{"name":"numbering","kind":12,"containerName":"main::","line":717},{"name":"$self","containerName":null,"kind":13,"line":717},{"name":"numbering","kind":12,"containerName":"main::","line":717},{"line":718,"name":"$DNAobj","containerName":null,"localvar":"my","kind":13,"definition":"my"},{"line":718,"name":"$RNAobj","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"$refseq","line":719},{"line":719,"name":"isa","containerName":"main::","kind":12},{"name":"$self","containerName":null,"kind":13,"line":720},{"line":720,"containerName":"main::","kind":12,"name":"RNA"},{"name":"$refseq","containerName":null,"kind":13,"line":720},{"line":721,"name":"$self","containerName":null,"kind":13},{"kind":12,"containerName":"main::","name":"DNA","line":721},{"kind":13,"containerName":null,"name":"%refseq","line":721},{"containerName":null,"kind":13,"name":"$seqDiff","line":722},{"line":722,"containerName":"main::","kind":12,"name":"rna_ori"},{"line":722,"kind":13,"containerName":null,"name":"$refseq"},{"line":722,"kind":12,"containerName":"main::","name":"seq"},{"line":723,"name":"$seqDiff","kind":13,"containerName":null},{"line":723,"containerName":"main::","kind":12,"name":"aa_ori"},{"line":723,"name":"$refseq","kind":13,"containerName":null},{"name":"get_Translation","containerName":"main::","kind":12,"line":723},{"line":723,"kind":12,"containerName":"main::","name":"seq"},{"name":"$self","kind":13,"containerName":null,"line":725},{"line":725,"containerName":"main::","kind":12,"name":"DNA"},{"kind":13,"containerName":null,"name":"$refseq","line":725},{"name":"$self","kind":13,"containerName":null,"line":726},{"line":726,"kind":12,"containerName":"main::","name":"RNA"},{"line":726,"name":"@transcripts","kind":13,"containerName":null},{"name":"$seqDiff","kind":13,"containerName":null,"line":727},{"containerName":"main::","kind":12,"name":"rna_ori","line":727},{"line":727,"containerName":null,"kind":13,"name":"$self"},{"kind":12,"containerName":"main::","name":"RNA","line":727},{"line":727,"kind":12,"containerName":"main::","name":"seq"},{"name":"$seqDiff","containerName":null,"kind":13,"line":728},{"line":728,"name":"aa_ori","kind":12,"containerName":"main::"},{"line":728,"kind":13,"containerName":null,"name":"$self"},{"line":728,"name":"RNA","kind":12,"containerName":"main::"},{"kind":12,"containerName":"main::","name":"get_Translation","line":728},{"line":728,"kind":12,"containerName":"main::","name":"seq"},{"line":730,"name":"$seqDiff","containerName":null,"kind":13},{"line":730,"kind":12,"containerName":"main::","name":"dna_ori"},{"name":"$self","containerName":null,"kind":13,"line":730},{"name":"DNA","containerName":"main::","kind":12,"line":730},{"name":"seq","kind":12,"containerName":"main::","line":730},{"containerName":null,"kind":13,"name":"$seqDiff","line":732},{"kind":12,"containerName":"main::","name":"id","line":732},{"line":732,"name":"$self","containerName":null,"kind":13},{"name":"DNA","kind":12,"containerName":"main::","line":732},{"containerName":"main::","kind":12,"name":"accession_number","line":732},{"localvar":"my","kind":13,"containerName":null,"name":"$atg_label","line":736,"definition":"my"},{"line":736,"name":"$self","kind":13,"containerName":null},{"name":"RNA","kind":12,"containerName":"main::","line":736},{"containerName":"main::","kind":12,"name":"start","line":736},{"line":737,"localvar":"my","containerName":null,"kind":13,"name":"$atg_offset","definition":"my"},{"kind":13,"containerName":null,"name":"$self","line":737},{"line":737,"kind":12,"containerName":"main::","name":"DNA"},{"line":737,"kind":12,"containerName":"main::","name":"position"},{"containerName":null,"kind":13,"name":"$atg_label","line":737},{"line":737,"name":"$self","containerName":null,"kind":13},{"line":737,"kind":12,"containerName":"main::","name":"DNA"},{"containerName":"main::","kind":12,"name":"start","line":737},{"kind":13,"containerName":null,"name":"$seqDiff","line":738},{"line":738,"containerName":"main::","kind":12,"name":"offset"},{"name":"$atg_offset","kind":13,"containerName":null,"line":738},{"line":739,"name":"$self","containerName":null,"kind":13},{"line":739,"kind":12,"containerName":"main::","name":"DNA"},{"name":"coordinate_start","containerName":"main::","kind":12,"line":739},{"line":739,"name":"$atg_label","containerName":null,"kind":13},{"localvar":"my","containerName":null,"kind":13,"name":"@exons","line":741,"definition":"my"},{"name":"$self","containerName":null,"kind":13,"line":741},{"line":741,"containerName":"main::","kind":12,"name":"RNA"},{"name":"all_Exons","containerName":"main::","kind":12,"line":741},{"name":"$seqDiff","kind":13,"containerName":null,"line":742},{"line":742,"kind":12,"containerName":"main::","name":"cds_end"},{"containerName":null,"kind":13,"name":"@exons","line":742},{"line":742,"kind":12,"name":"exons"},{"name":"end","containerName":"main::","kind":12,"line":742},{"line":747,"kind":13,"containerName":null,"name":"$self"},{"kind":12,"containerName":"main::","name":"warn","line":747},{"line":748,"name":"$self","kind":13,"containerName":null},{"containerName":"main::","kind":12,"name":"_mutationpos2label","line":748},{"name":"$refseq","kind":13,"containerName":null,"line":748},{"containerName":null,"kind":13,"name":"$seqDiff","line":748},{"definition":"my","line":757,"name":"$k","kind":13,"localvar":"my","containerName":null},{"line":758,"name":"$mutation","containerName":null,"localvar":"my","kind":13,"definition":"my"},{"kind":13,"containerName":null,"name":"$self","line":758},{"name":"each_Mutation","kind":12,"containerName":"main::","line":758},{"name":"$mutation","kind":13,"containerName":null,"line":759},{"name":"label","kind":12,"containerName":"main::","line":759},{"line":760,"containerName":null,"kind":13,"name":"$self"},{"name":"mutation","containerName":"main::","kind":12,"line":760},{"kind":13,"containerName":null,"name":"$mutation","line":760},{"name":"$mutation","kind":13,"containerName":null,"line":762},{"containerName":"main::","kind":12,"name":"issue","line":762},{"kind":13,"containerName":null,"name":"$k","line":762},{"line":766,"name":"$self","kind":13,"containerName":null},{"line":766,"kind":12,"containerName":"main::","name":"numbering"},{"line":767,"name":"$mutation","kind":13,"containerName":null},{"line":767,"kind":12,"containerName":"main::","name":"transpos"},{"line":767,"containerName":null,"kind":13,"name":"$mutation"},{"line":767,"kind":12,"containerName":"main::","name":"pos"},{"line":770,"name":"$mutation","containerName":null,"kind":13},{"line":770,"name":"transpos","containerName":"main::","kind":12},{"kind":13,"containerName":null,"name":"$self","line":770},{"name":"RNA","containerName":"main::","kind":12,"line":770},{"line":770,"name":"position","kind":12,"containerName":"main::"},{"line":770,"name":"$mutation","containerName":null,"kind":13},{"name":"label","kind":12,"containerName":"main::","line":770},{"line":770,"containerName":null,"kind":13,"name":"$atg_label"},{"line":775,"name":"$mutation","kind":13,"containerName":null},{"line":775,"containerName":"main::","kind":12,"name":"prelabel"},{"kind":13,"containerName":null,"name":"$self","line":775},{"line":775,"name":"DNA","kind":12,"containerName":"main::"},{"line":775,"containerName":"main::","kind":12,"name":"label"},{"name":"$mutation","containerName":null,"kind":13,"line":775},{"containerName":"main::","kind":12,"name":"label","line":775},{"line":776,"name":"$mutation","kind":13,"containerName":null},{"line":776,"name":"len","kind":12,"containerName":"main::"},{"kind":13,"containerName":null,"name":"$mutation","line":777},{"name":"postlabel","containerName":"main::","kind":12,"line":777},{"line":777,"name":"$mutation","containerName":null,"kind":13},{"line":777,"name":"label","kind":12,"containerName":"main::"},{"name":"$mutation","containerName":null,"kind":13,"line":778},{"name":"lastlabel","kind":12,"containerName":"main::","line":778},{"containerName":null,"kind":13,"name":"$mutation","line":778},{"line":778,"kind":12,"containerName":"main::","name":"label"},{"name":"$mutation","containerName":null,"kind":13,"line":779},{"kind":12,"containerName":"main::","name":"len","line":779},{"line":780,"name":"$mutation","containerName":null,"kind":13},{"line":780,"name":"lastlabel","containerName":"main::","kind":12},{"line":780,"name":"$mutation","containerName":null,"kind":13},{"containerName":"main::","kind":12,"name":"label","line":780},{"line":781,"containerName":null,"kind":13,"name":"$mutation"},{"line":781,"name":"postlabel","containerName":"main::","kind":12},{"name":"$self","containerName":null,"kind":13,"line":781},{"line":781,"kind":12,"containerName":"main::","name":"DNA"},{"line":781,"kind":12,"containerName":"main::","name":"label"},{"line":781,"containerName":null,"kind":13,"name":"$mutation"},{"containerName":"main::","kind":12,"name":"lastlabel","line":781},{"kind":13,"containerName":null,"name":"$mutation","line":783},{"kind":12,"containerName":"main::","name":"lastlabel","line":783},{"name":"$self","kind":13,"containerName":null,"line":783},{"line":783,"containerName":"main::","kind":12,"name":"DNA"},{"line":783,"name":"label","kind":12,"containerName":"main::"},{"line":783,"containerName":null,"kind":13,"name":"$mutation"},{"kind":12,"containerName":"main::","name":"len","line":783},{"kind":13,"containerName":null,"name":"$mutation","line":783},{"name":"label","containerName":"main::","kind":12,"line":783},{"line":784,"kind":13,"containerName":null,"name":"$mutation"},{"kind":12,"containerName":"main::","name":"postlabel","line":784},{"name":"$self","kind":13,"containerName":null,"line":784},{"line":784,"name":"DNA","kind":12,"containerName":"main::"},{"line":784,"kind":12,"containerName":"main::","name":"label"},{"name":"$mutation","containerName":null,"kind":13,"line":784},{"name":"lastlabel","containerName":"main::","kind":12,"line":784},{"definition":"my","line":786,"kind":13,"localvar":"my","containerName":null,"name":"$dnamut"},{"name":"$self","containerName":null,"kind":13,"line":786},{"line":786,"name":"_set_DNAMutation","kind":12,"containerName":"main::"},{"kind":13,"containerName":null,"name":"$seqDiff","line":786},{"line":790,"name":"$self","kind":13,"containerName":null},{"kind":12,"containerName":"main::","name":"_rnaAffected","line":790},{"line":791,"kind":13,"containerName":null,"name":"$self"},{"line":791,"name":"_set_effects","containerName":"main::","kind":12},{"line":791,"name":"$seqDiff","kind":13,"containerName":null},{"name":"$dnamut","containerName":null,"kind":13,"line":791},{"line":793,"name":"$seqDiff","containerName":null,"kind":13},{"line":793,"name":"offset","kind":12,"containerName":"main::"},{"line":793,"containerName":null,"kind":13,"name":"$dnamut"},{"kind":12,"containerName":"main::","name":"region","line":793},{"name":"$self","containerName":null,"kind":13,"line":794},{"line":794,"name":"_untranslated","kind":12,"containerName":"main::"},{"line":794,"containerName":null,"kind":13,"name":"$seqDiff"},{"kind":13,"containerName":null,"name":"%dnamut","line":794},{"line":801,"name":"$refseq","containerName":null,"kind":13},{"line":801,"kind":12,"containerName":"main::","name":"labelchange"},{"line":801,"name":"$mutation","kind":13,"containerName":null},{"name":"seq","containerName":"main::","kind":12,"line":801},{"line":801,"containerName":null,"kind":13,"name":"$mutation"},{"name":"label","containerName":"main::","kind":12,"line":801},{"line":801,"kind":13,"containerName":null,"name":"$mutation"},{"name":"len","kind":12,"containerName":"main::","line":801},{"line":804,"name":"$self","kind":13,"containerName":null},{"line":804,"name":"_post_mutation","containerName":"main::","kind":12},{"line":804,"containerName":null,"kind":13,"name":"$seqDiff"},{"kind":13,"containerName":null,"name":"$self","line":806},{"line":806,"containerName":"main::","kind":12,"name":"dnamut"},{"name":"$self","kind":13,"containerName":null,"line":807},{"containerName":"main::","kind":12,"name":"rnachange","line":807},{"kind":13,"containerName":null,"name":"$self","line":808},{"line":808,"name":"aachange","containerName":"main::","kind":12},{"line":809,"name":"$self","kind":13,"containerName":null},{"containerName":"main::","kind":12,"name":"exons","line":809},{"line":812,"name":"$seqDiff","containerName":null,"kind":13},{"line":812,"containerName":"main::","kind":12,"name":"dna_mut"},{"containerName":null,"kind":13,"name":"$self","line":812},{"containerName":"main::","kind":12,"name":"DNA","line":812},{"line":812,"name":"seq","containerName":"main::","kind":12},{"line":813,"name":"$seqDiff","containerName":null,"kind":13},{"line":813,"name":"rna_mut","kind":12,"containerName":"main::"},{"name":"$self","kind":13,"containerName":null,"line":813},{"name":"RNA","containerName":"main::","kind":12,"line":813},{"line":813,"containerName":"main::","kind":12,"name":"seq"},{"kind":13,"containerName":null,"name":"$refseq","line":814},{"name":"isa","kind":12,"containerName":"main::","line":814},{"line":815,"name":"$seqDiff","kind":13,"containerName":null},{"containerName":"main::","kind":12,"name":"aa_mut","line":815},{"name":"$refseq","kind":13,"containerName":null,"line":815},{"containerName":"main::","kind":12,"name":"get_Translation","line":815},{"kind":12,"containerName":"main::","name":"seq","line":815},{"line":817,"name":"$seqDiff","kind":13,"containerName":null},{"line":817,"name":"aa_mut","containerName":"main::","kind":12},{"kind":13,"containerName":null,"name":"$self","line":817},{"line":817,"name":"RNA","kind":12,"containerName":"main::"},{"kind":12,"containerName":"main::","name":"get_Translation","line":817},{"line":817,"kind":12,"containerName":"main::","name":"seq"},{"kind":13,"containerName":null,"name":"$seqDiff","line":826},{"name":"_mutationpos2label","containerName":"main::","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"_mutationpos2label","name":"$self","line":841},{"containerName":"_mutationpos2label","kind":13,"name":"$refseq","line":841},{"kind":13,"containerName":"_mutationpos2label","name":"$SeqDiff","line":841},{"definition":"my","line":842,"name":"$count","containerName":"_mutationpos2label","localvar":"my","kind":13},{"line":843,"name":"@bb","localvar":"my","containerName":"_mutationpos2label","kind":13,"definition":"my"},{"kind":13,"containerName":"_mutationpos2label","name":"$self","line":843}],"detail":"($self,$refseq,$SeqDiff)","definition":"sub","range":{"end":{"character":9999,"line":843},"start":{"line":840,"character":0}},"kind":12,"line":840,"signature":{"label":"_mutationpos2label($self,$refseq,$SeqDiff)","documentation":"1;\n# $Id: Mutator.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::Mutator\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::Mutator - Package mutating LiveSequences\n\n=head1 SYNOPSIS\n\n  # $gene is a Bio::LiveSeq::Gene object\n  my $mutate = Bio::LiveSeq::Mutator->new('-gene' => $gene,\n  \t\t\t\t\t  '-numbering' => \"coding\"\n  \t\t\t\t\t   );\n  # $mut is a Bio::LiveSeq::Mutation object\n  $mutate->add_Mutation($mut);\n  # $results is a Bio::Variation::SeqDiff object\n  my $results=$mutate->change_gene();\n  if ($results) {\n      my $out = Bio::Variation::IO->new( '-format' => 'flat');\n      $out->write($results);\n  }\n\n=head1 DESCRIPTION\n\nThis class mutates Bio::LiveSeq::Gene objects and returns a\nBio::Variation::SeqDiff object. Mutations are described as\nBio::LiveSeq::Mutation objects. See L<Bio::LiveSeq::Gene>,\nL<Bio::Variation::SeqDiff>, and L<Bio::LiveSeq::Mutation> for details.\n\n=head1 FEEDBACK\n\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho & Joseph A.L. Insana\n\n  Email:  heikki-at-bioperl-dot-org\n          insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\n  The rest of the documentation details each of the object\n  methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::Mutator;\nuse strict;\n\nuse Bio::Variation::SeqDiff;\nuse Bio::Variation::DNAMutation;\nuse Bio::Variation::RNAChange;\nuse Bio::Variation::AAChange;\nuse Bio::Variation::Allele;\nuse Bio::LiveSeq::Mutation;\n\n#use integer;\n# Object preamble - inheritance\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n    my($class,@args) = @_;\n    my $self;\n    $self = {};\n    bless $self, $class;\n\n    my ($gene, $numbering) =\n\t    $self->_rearrange([qw(GENE\n\t\t\t\t  NUMBERING\n\t\t\t\t  )],\n\t\t\t      @args);\n\n    $self->{ 'mutations' } = [];\n\n    $gene && $self->gene($gene);\n    $numbering && $self->numbering($numbering);\n\n    #class constant;\n    $self->{'flanklen'} = 25;\n    return $self; # success - we hope!\n}\n\n=head2 gene\n\n Title   : gene\n Usage   : $mutobj = $obj->gene;\n         : $mutobj = $obj->gene($objref);\n Function:\n\n           Returns or sets the link-reference to a\n           Bio::LiveSeq::Gene object. If no value has ben set, it\n           will return undef\n\n Returns : an object reference  or undef\n Args    : a Bio::LiveSeq::Gene\n\nSee L<Bio::LiveSeq::Gene> for more information.\n\n\nsub gene {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Gene') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::Gene object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'gene'} = $value;\n      }\n  }\n  unless (exists $self->{'gene'}) {\n      return;\n  } else {\n      return $self->{'gene'};\n  }\n}\n\n\n=head2 numbering\n\n Title   : numbering\n Usage   : $obj->numbering();\n Function:\n\n            Sets and returns coordinate system used in positioning the\n            mutations. See L<change_gene> for details.\n\n Example :\n Returns : string\n Args    : string (coding [transcript number] | gene | entry)\n\n\n\nsub numbering {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif ($value =~ /(coding)( )?(\\d+)?/ or $value eq 'entry' or $value eq 'gene') {\n\t    $self->{'numbering'} = $value;\n\t} else { # defaulting to 'coding'\n\t    $self->{'numbering'} = 'coding';\n\t}\n    }\n    unless (exists $self->{'numbering'}) {\n\treturn 'coding';\n    } else {\n\treturn $self->{'numbering'};\n    }\n}\n\n=head2 add_Mutation\n\n Title   : add_Mutation\n Usage   : $self->add_Mutation($ref)\n Function: adds a Bio::LiveSeq::Mutation object\n Example :\n Returns :\n Args    : a Bio::LiveSeq::Mutation\n\nSee L<Bio::LiveSeq::Mutation> for more information.\n\n\nsub add_Mutation{\n    my ($self,$value) = @_;\n    if( $value->isa('Bio::Liveseq::Mutation') ) {\n\tmy $com = ref $value;\n\t$self->throw(\"Is not a Mutation object but a [$com]\" );\n\treturn;\n    }\n    if (! $value->pos) {\n\t$self->warn(\"No value for mutation position in the sequence!\");\n\treturn;\n    }\n    if (! $value->seq && ! $value->len) {\n\t$self->warn(\"Either mutated sequence or length of the deletion must be given!\");\n\treturn;\n    }\n    push(@{$self->{'mutations'}},$value);\n}\n\n=head2 each_Mutation\n\n Title   : each_Mutation\n Usage   : foreach $ref ( $a->each_Mutation )\n Function: gets an array of Bio::LiveSeq::Mutation objects\n Example :\n Returns : array of Mutations\n Args    :\n\nSee L<Bio::LiveSeq::Mutation> for more information.\n\n\nsub each_Mutation{\n   my ($self) = @_;\n   return @{$self->{'mutations'}};\n}\n\n\n=head2 mutation\n\n Title   : mutation\n Usage   : $mutobj = $obj->mutation;\n         : $mutobj = $obj->mutation($objref);\n Function:\n\n           Returns or sets the link-reference to the current mutation\n           object.  If the value is not set, it will return undef.\n           Internal method.\n\n Returns : an object reference  or undef\n\n\n\nsub mutation {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Mutation') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::Mutation object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'mutation'} = $value;\n      }\n  }\n  unless (exists $self->{'mutation'}) {\n      return;\n  } else {\n      return $self->{'mutation'};\n  }\n}\n\n=head2 DNA\n\n Title   : DNA\n Usage   : $mutobj = $obj->DNA;\n         : $mutobj = $obj->DNA($objref);\n Function:\n\n           Returns or sets the reference to the LiveSeq object holding\n           the reference sequence. If there is no link, it will return\n           undef.\n           Internal method.\n\n Returns : an object reference or undef\n\n\nsub DNA {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::DNA') and ! $value->isa('Bio::LiveSeq::Transcript') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::DNA/Transcript object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'DNA'} = $value;\n      }\n  }\n  unless (exists $self->{'DNA'}) {\n      return;\n  } else {\n      return $self->{'DNA'};\n  }\n}\n\n\n=head2 RNA\n\n Title   : RNA\n Usage   : $mutobj = $obj->RNA;\n         : $mutobj = $obj->RNA($objref);\n Function:\n\n           Returns or sets the reference to the LiveSeq object holding\n           the reference sequence. If the value is not set, it will return\n           undef.\n           Internal method.\n\n Returns : an object reference  or undef\n\n\n\nsub RNA {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Transcript') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::RNA/Transcript object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'RNA'} = $value;\n      }\n  }\n  unless (exists $self->{'RNA'}) {\n      return;\n  } else {\n      return $self->{'RNA'};\n  }\n}\n\n\n=head2 dnamut\n\n Title   : dnamut\n Usage   : $mutobj = $obj->dnamut;\n         : $mutobj = $obj->dnamut($objref);\n Function:\n\n           Returns or sets the reference to the current DNAMutation object.\n           If the value is not set, it will return undef.\n           Internal method.\n\n Returns : a Bio::Variation::DNAMutation object or undef\n\nSee L<Bio::Variation::DNAMutation> for more information.\n\n\n\nsub dnamut {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::DNAMutation') ) {\n\t  $self->throw(\"Is not a Bio::Variation::DNAMutation object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'dnamut'} = $value;\n      }\n  }\n  unless (exists $self->{'dnamut'}) {\n      return;\n  } else {\n      return $self->{'dnamut'};\n  }\n}\n\n\n=head2 rnachange\n\n Title   : rnachange\n Usage   : $mutobj = $obj->rnachange;\n         : $mutobj = $obj->rnachange($objref);\n Function:\n\n           Returns or sets the reference to the current RNAChange object.\n           If the value is not set, it will return undef.\n           Internal method.\n\n Returns : a Bio::Variation::RNAChange object or undef\n\nSee L<Bio::Variation::RNAChange> for more information.\n\n\n\nsub rnachange {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::RNAChange') ) {\n\t  $self->throw(\"Is not a Bio::Variation::RNAChange object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'rnachange'} = $value;\n      }\n  }\n  unless (exists $self->{'rnachange'}) {\n      return;\n  } else {\n      return $self->{'rnachange'};\n  }\n}\n\n\n=head2 aachange\n\n Title   : aachange\n Usage   : $mutobj = $obj->aachange;\n         : $mutobj = $obj->aachange($objref);\n Function:\n\n           Returns or sets the reference to the current AAChange object.\n           If the value is not set, it will return undef.\n           Internal method.\n\n Returns : a Bio::Variation::AAChange object or undef\n\nSee L<Bio::Variation::AAChange> for more information.\n\n\n\nsub aachange {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::AAChange') ) {\n\t  $self->throw(\"Is not a Bio::Variation::AAChange object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'aachange'} = $value;\n      }\n  }\n  unless (exists $self->{'aachange'}) {\n      return;\n  } else {\n      return $self->{'aachange'};\n  }\n}\n\n\n=head2 exons\n\n Title   : exons\n Usage   : $mutobj = $obj->exons;\n         : $mutobj = $obj->exons($objref);\n Function:\n\n           Returns or sets the reference to a current array of Exons.\n           If the value is not set, it will return undef.\n           Internal method.\n\n Returns : an array of Bio::LiveSeq::Exon objects or undef\n\nSee L<Bio::LiveSeq::Exon> for more information.\n\n\n\nsub exons {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      $self->{'exons'} = $value;\n  }\n  unless (exists $self->{'exons'}) {\n      return;\n  } else {\n      return $self->{'exons'};\n  }\n}\n\n=head2 change_gene_with_alignment\n\n Title   : change_gene_with_alignment\n Usage   : $results=$mutate->change_gene_with_alignment($aln);\n\n Function:\n\n           Returns a Bio::Variation::SeqDiff object containing the\n           results of the changes in the alignment. The alignment has\n           to be pairwise and have one sequence named 'QUERY', the\n           other one is assumed to be a part of the sequence from\n           $gene.\n\n           This method offers a shortcut to change_gene and\n           automates the creation of Bio::LiveSeq::Mutation objects.\n           Use it with almost identical sequnces, e.g. to locate a SNP.\n\n Args    : Bio::SimpleAlign object representing a short local alignment\n Returns : Bio::Variation::SeqDiff object or 0 on error\n\nSee L<Bio::LiveSeq::Mutation>, L<Bio::SimpleAlign>, and\nL<Bio::Variation::SeqDiff>  for more information.\n\n\nsub change_gene_with_alignment {\n    my ($self, $aln) = @_;\n\n    #\n    # Sanity checks\n    #\n\n    $self->throw(\"Argument is not a Bio::SimpleAlign object but a [$aln]\")\n\tunless $aln->isa('Bio::SimpleAlign');\n    $self->throw(\"'Pairwise alignments only, please\") \n\tif $aln->no_sequences != 2;\n\n    # find out the order the two sequences are given\n    my $queryseq_pos = 1; #default\n    my $refseq_pos = 2;\n    unless ($aln->get_seq_by_pos(1)->id eq 'QUERY') {\n\tcarp('Query sequence has to be named QUERY') \n\t    if $aln->get_seq_by_pos(2)->id ne 'QUERY';\n\t$queryseq_pos = 2; # alternative\n\t$refseq_pos = 1;\n    }\n\n    # trim the alignment\n    my $start =  $aln->column_from_residue_number('QUERY', 1);\n    my $end =  $aln->column_from_residue_number('QUERY', \n\t\t\t\t\t\t$aln->get_seq_by_pos($queryseq_pos)->end );\n    \n    my $aln2 = $aln->slice($start, $end);\n\n    #\n    # extracting mutations\n    #\n\n    my $cs = $aln2->consensus_string(51);\n    my $queryseq = $aln2->get_seq_by_pos($queryseq_pos);\n    my $refseq = $aln2->get_seq_by_pos($refseq_pos);\n\n    while ( $cs =~ /(\\?+)/g) {\n\t# pos in local coordinates\n\tmy $pos = pos($cs) - length($1) + 1;\n\tmy $mutation = create_mutation($self, \n\t\t\t\t       $refseq, \n\t\t\t\t       $queryseq, \n\t\t\t\t       $pos, \n\t\t\t\t       CORE::length($1)\n\t\t\t\t       );\n\t# reset pos to refseq coordinates\n\t$pos +=  $refseq->start - 1;\n\t$mutation->pos($pos);\n\n        $self->add_Mutation($mutation);\n    }\n    return $self->change_gene();\n}\n\n=head2 create_mutation\n\n Title   : create_mutation\n Usage   : \n Function:\n\n           Formats sequence differences from two sequences into\n           Bio::LiveSeq::Mutation objects which can be applied to a\n           gene.\n\n           To keep it generic, sequence arguments need not to be\n           Bio::LocatableSeq. Coordinate change to parent sequence\n           numbering needs to be done by the calling code.\n\n           Called from change_gene_with_alignment\n\n Args    : Bio::PrimarySeqI inheriting object for the reference sequence\n           Bio::PrimarySeqI inheriting object for the query sequence\n           integer for the start position of the local sequence difference\n           integer for the length of the sequence difference\n Returns : Bio::LiveSeq::Mutation object \n\n\nsub create_mutation {\n    my ($self, $refseq, $queryseq, $pos, $len) = @_;\n    \n    $self->throw(\"Is not a Bio::PrimarySeqI object but a [$refseq]\") \n\tunless $refseq->isa('Bio::PrimarySeqI');\n    $self->throw(\"Is not a Bio::PrimarySeqI object but a [$queryseq]\") \n\tunless $queryseq->isa('Bio::PrimarySeqI');\n    $self->throw(\"Position is not a positive integer but [$pos]\") \n\tunless $pos =~ /^\\+?\\d+$/;\n    $self->throw(\"Length is not a positive integer but [$len]\") \n\tunless $len =~ /^\\+?\\d+$/;\n\n    my $mutation;\n    my $refstring = $refseq->subseq($pos, $pos + $len - 1);\n    my $varstring = $queryseq->subseq($pos, $pos + $len - 1);\n    \n    if ($len == 1 and $refstring =~ /[^\\.\\-\\*\\?]/ and \n\t$varstring  =~ /[^\\.\\-\\*\\?]/ ) { #point\n\t$mutation = Bio::LiveSeq::Mutation->new(-seq => $varstring,\n\t\t\t\t\t\t-pos => $pos,\n\t\t\t\t\t\t);\n    }\n    elsif ( $refstring =~ /^[^\\.\\-\\*\\?]+$/ and \n\t    $varstring  !~ /^[^\\.\\-\\*\\?]+$/ ) { # deletion\n\t$mutation = Bio::LiveSeq::Mutation->new(-pos => $pos,\n\t\t\t\t\t\t-len => $len\n\t\t\t\t\t\t);\n    }\n    elsif ( $refstring !~ /^[^\\.\\-\\*\\?]+$/ and \n\t    $varstring  =~ /^[^\\.\\-\\*\\?]+$/ ) { # insertion\n\t$mutation = Bio::LiveSeq::Mutation->new(-seq => $varstring,\n\t\t\t\t\t\t-pos => $pos,\n\t\t\t\t\t\t-len => 0\n\t\t\t\t\t\t);\n    } else { # complex\n\t$mutation = Bio::LiveSeq::Mutation->new(-seq => $varstring,\n\t\t\t\t\t\t-pos => $pos,\n\t\t\t\t\t\t-len => $len\n\t\t\t\t\t\t);\n    }\n    \n    return $mutation;\n}\n\n=head2 change_gene\n\n Title   : change_gene\n Usage   : my $mutate = Bio::LiveSeq::Mutator->new(-gene => $gene,\n\t\t\t\t\t\t   numbering => \"coding\"\n\t\t\t\t\t\t   );\n           # $mut is Bio::LiveSeq::Mutation object\n           $mutate->add_Mutation($mut);\n           my $results=$mutate->change_gene();\n\n Function:\n\n           Returns a Bio::Variation::SeqDiff object containing the\n           results of the changes performed according to the\n           instructions present in Mutation(s).  The -numbering\n           argument decides what molecule is being changed and what\n           numbering scheme being used:\n\n            -numbering => \"entry\"\n\n               determines the DNA level, using the numbering from the\n               beginning of the sequence\n\n            -numbering => \"coding\"\n\n               determines the RNA level, using the numbering from the\n               beginning of the 1st transcript\n\n               Alternative transcripts can be used by specifying\n               \"coding 2\" or \"coding 3\" ...\n\n            -numbering => \"gene\"\n\n               determines the DNA level, using the numbering from the\n               beginning of the 1st transcript and inluding introns.\n               The meaning equals 'coding' if the reference molecule\n               is cDNA.\n\n Args    : Bio::LiveSeq::Gene object\n           Bio::LiveSeq::Mutation object(s)\n           string specifying a numbering scheme (defaults to 'coding')\n Returns : Bio::Variation::SeqDiff object or 0 on error\n\n\nsub change_gene {\n    my ($self) = @_;\n\n    #\n    # Sanity check\n    #\n    unless ($self->gene) {\n\t$self->warn(\"Input object Bio::LiveSeq::Gene is not given\");\n\treturn 0;\n    }\n    #\n    # Setting the reference sequence based on -numbering\n    #\n    my @transcripts=@{$self->gene->get_Transcripts};\n    my $refseq; # will hold Bio::LiveSeq:Transcript object or Bio::LiveSeq::DNA\n\n    # 'gene' eq 'coding' if reference sequence is cDNA\n    $self->numbering ('coding') if $self->gene->get_DNA->alphabet eq 'rna' and $self->numbering eq 'gene';\n\n    if ($self->numbering =~ /(coding)( )?(\\d+)?/ ) {\n\t$self->numbering($1);\n\tmy $transnumber = $3;\n\t$transnumber-- if $3; # 1 -> 0, 2 -> 1\n\tif ($transnumber && $transnumber >= 0 && $transnumber <= $#transcripts) {\n\t    $refseq=$transcripts[$transnumber];\n\t} else {\n\t    $transnumber && $self->warn(\"The alternative transcript number \". $transnumber+1 .\n\t    \"- does not exist. Reverting to the 1st transcript\\n\");\n\t    $refseq=$transcripts[0];\n\t}\n    } else {\n\t$refseq=$transcripts[0]->{'seq'};\n    }\n    #\n    # Recording the state: SeqDiff object creation  ?? transcript no.??\n    #\n    my $seqDiff = Bio::Variation::SeqDiff->new(-verbose => $self->verbose);\n    $seqDiff->alphabet($self->gene->get_DNA->alphabet);\n    $seqDiff->numbering($self->numbering);\n    my ($DNAobj, $RNAobj);\n    if ($refseq->isa(\"Bio::LiveSeq::Transcript\")) {\n\t$self->RNA($refseq);\n\t$self->DNA($refseq->{'seq'});\n\t$seqDiff->rna_ori($refseq->seq );\n\t$seqDiff->aa_ori($refseq->get_Translation->seq);\n    } else {\n\t$self->DNA($refseq);\n\t$self->RNA($transcripts[0]);\n\t$seqDiff->rna_ori($self->RNA->seq);\n\t$seqDiff->aa_ori($self->RNA->get_Translation->seq);\n    }\n    $seqDiff->dna_ori($self->DNA->seq);\n    # put the accession number into the SeqDiff object ID\n    $seqDiff->id($self->DNA->accession_number);\n\n    # the atg_offset takes in account that DNA object could be a subset of the\n    # whole entry (via the light_weight loader)\n    my $atg_label=$self->RNA->start;\n    my $atg_offset=$self->DNA->position($atg_label)+($self->DNA->start)-1;\n    $seqDiff->offset($atg_offset - 1);\n    $self->DNA->coordinate_start($atg_label);\n\n    my @exons = $self->RNA->all_Exons;\n    $seqDiff->cds_end($exons[$#exons]->end);\n\n    #\n    # Converting mutation positions to labels\n    #\n    $self->warn(\"no mutations\"), return 0 \n\tunless $self->_mutationpos2label($refseq, $seqDiff);\n\n    # need to add more than one rna & aa\n    #foreach $transcript (@transcripts) {\n    #  $seqDiff{\"ori_transcript_${i}_seq\"}=$transcript->seq;\n    #  $seqDiff{\"ori_translation_${i}_seq\"}=$transcript->get_Translation->seq;\n    #}\n\n    # do changes\n    my $k;\n    foreach my $mutation ($self->each_Mutation) {\n\tnext unless $mutation->label > 0;\n\t$self->mutation($mutation);\n\n\t$mutation->issue(++$k);\n\t#\n\t# current position on the transcript\n\t#\n\tif ($self->numbering =~ /coding/) {\n\t    $mutation->transpos($mutation->pos); # transpos given by user\n\t} else {\n\t    #transpos of label / It will be 0 if mutating an intron, negative if upstream of ATG\n\t    $mutation->transpos($self->RNA->position($mutation->label,$atg_label));\n\t}\n\t#\n\t# Calculate adjacent labels based on the position on the current sequence\n\t#\n\t$mutation->prelabel($self->DNA->label(-1, $mutation->label)); # 1 before label\n\tif ($mutation->len == 0) {\n\t    $mutation->postlabel($mutation->label);\n\t    $mutation->lastlabel($mutation->label);\n\t} elsif ($mutation->len == 1) {\n\t    $mutation->lastlabel($mutation->label); # last nucleotide affected\n\t    $mutation->postlabel($self->DNA->label(2,$mutation->lastlabel)); # $len after label\n\t} else {\n\t    $mutation->lastlabel($self->DNA->label($mutation->len,$mutation->label));\n\t    $mutation->postlabel($self->DNA->label(2,$mutation->lastlabel));\n\t}\n\tmy $dnamut = $self->_set_DNAMutation($seqDiff);\n\t#\n\t#\n\t#\n\tif ($self->_rnaAffected) {\n\t    $self->_set_effects($seqDiff, $dnamut);\n\t}\n\telsif ($seqDiff->offset != 0 and $dnamut->region ne 'intron') {\n\t    $self->_untranslated ($seqDiff, $dnamut);\n\t} else {\n\t    #$self->warn(\"Mutation starts outside coding region, RNAChange object not created\");\n\t}\n\n\t#########################################################################\n\t# Mutations are done here!                                              #\n\t$refseq->labelchange($mutation->seq, $mutation->label, $mutation->len); #\n\t#########################################################################\n\n\t$self->_post_mutation ($seqDiff);\n\n\t$self->dnamut(undef);\n\t$self->rnachange(undef);\n\t$self->aachange(undef);\n\t$self->exons(undef);\n    }\n    # record the final state of all three sequences\n    $seqDiff->dna_mut($self->DNA->seq);\n    $seqDiff->rna_mut($self->RNA->seq);\n    if ($refseq->isa(\"Bio::LiveSeq::Transcript\")) {\n\t$seqDiff->aa_mut($refseq->get_Translation->seq);\n    } else {\n\t$seqDiff->aa_mut($self->RNA->get_Translation->seq);\n    }\n\n    #$seqDiff{mut_dna_seq}=$gene->get_DNA->seq;\n    #my $i=1;\n    #foreach $transcript (@transcripts) {\n    #  $seqDiff{\"mut_transcript_${i}_seq\"}=$transcript->seq;\n    #  $seqDiff{\"mut_translation_${i}_seq\"}=$transcript->get_Translation->seq;\n    #}\n    return $seqDiff;\n}\n\n=head2 _mutationpos2label\n\n Title   : _mutationpos2label\n Usage   :\n Function: converts mutation positions into labels\n Example :\n Returns : number of valid mutations\n Args    : LiveSeq sequence object","parameters":[{"label":"$self"},{"label":"$refseq"},{"label":"$SeqDiff"}]}},{"line":844,"containerName":null,"localvar":"my","kind":13,"name":"$cc","definition":"my"},{"name":"@bb","containerName":null,"kind":13,"line":844},{"definition":"my","name":"$mut","localvar":"my","kind":13,"containerName":null,"line":845},{"name":"%self","kind":13,"containerName":null,"line":845},{"line":855,"containerName":null,"kind":13,"name":"$self"},{"kind":12,"containerName":"main::","name":"numbering","line":855},{"line":856,"localvar":"my","kind":13,"containerName":null,"name":"$tmp","definition":"my"},{"line":856,"containerName":null,"kind":13,"name":"$mut"},{"line":856,"name":"pos","containerName":"main::","kind":12},{"line":857,"kind":13,"containerName":null,"name":"$tmp"},{"name":"$SeqDiff","kind":13,"containerName":null,"line":857},{"line":857,"name":"offset","kind":12,"containerName":"main::"},{"line":858,"name":"$tmp","containerName":null,"kind":13},{"line":858,"containerName":null,"kind":13,"name":"$tmp"},{"name":"$mut","kind":13,"containerName":null,"line":859},{"line":859,"containerName":"main::","kind":12,"name":"pos"},{"line":859,"name":"$tmp","kind":13,"containerName":null},{"definition":"my","line":862,"name":"$label","containerName":null,"localvar":"my","kind":13},{"line":862,"name":"$refseq","containerName":null,"kind":13},{"line":862,"name":"label","kind":12,"containerName":"main::"},{"line":862,"name":"$mut","kind":13,"containerName":null},{"line":862,"containerName":"main::","kind":12,"name":"pos"},{"line":863,"name":"$mut","containerName":null,"kind":13},{"name":"label","containerName":"main::","kind":12,"line":863},{"kind":13,"containerName":null,"name":"$label","line":863},{"line":863,"name":"$count","kind":13,"containerName":null},{"line":863,"name":"$label","containerName":null,"kind":13},{"line":866,"containerName":null,"kind":13,"name":"$count"},{"line":891,"range":{"end":{"line":949,"character":9999},"start":{"line":891,"character":0}},"kind":12,"signature":{"label":"_set_DNAMutation($self,$seqDiff)","parameters":[{"label":"$self"},{"label":"$seqDiff"}],"documentation":"1;\n# $Id: Mutator.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::Mutator\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::Mutator - Package mutating LiveSequences\n\n=head1 SYNOPSIS\n\n  # $gene is a Bio::LiveSeq::Gene object\n  my $mutate = Bio::LiveSeq::Mutator->new('-gene' => $gene,\n  \t\t\t\t\t  '-numbering' => \"coding\"\n  \t\t\t\t\t   );\n  # $mut is a Bio::LiveSeq::Mutation object\n  $mutate->add_Mutation($mut);\n  # $results is a Bio::Variation::SeqDiff object\n  my $results=$mutate->change_gene();\n  if ($results) {\n      my $out = Bio::Variation::IO->new( '-format' => 'flat');\n      $out->write($results);\n  }\n\n=head1 DESCRIPTION\n\nThis class mutates Bio::LiveSeq::Gene objects and returns a\nBio::Variation::SeqDiff object. Mutations are described as\nBio::LiveSeq::Mutation objects. See L<Bio::LiveSeq::Gene>,\nL<Bio::Variation::SeqDiff>, and L<Bio::LiveSeq::Mutation> for details.\n\n=head1 FEEDBACK\n\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho & Joseph A.L. Insana\n\n  Email:  heikki-at-bioperl-dot-org\n          insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\n  The rest of the documentation details each of the object\n  methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::Mutator;\nuse strict;\n\nuse Bio::Variation::SeqDiff;\nuse Bio::Variation::DNAMutation;\nuse Bio::Variation::RNAChange;\nuse Bio::Variation::AAChange;\nuse Bio::Variation::Allele;\nuse Bio::LiveSeq::Mutation;\n\n#use integer;\n# Object preamble - inheritance\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n    my($class,@args) = @_;\n    my $self;\n    $self = {};\n    bless $self, $class;\n\n    my ($gene, $numbering) =\n\t    $self->_rearrange([qw(GENE\n\t\t\t\t  NUMBERING\n\t\t\t\t  )],\n\t\t\t      @args);\n\n    $self->{ 'mutations' } = [];\n\n    $gene && $self->gene($gene);\n    $numbering && $self->numbering($numbering);\n\n    #class constant;\n    $self->{'flanklen'} = 25;\n    return $self; # success - we hope!\n}\n\n=head2 gene\n\n Title   : gene\n Usage   : $mutobj = $obj->gene;\n         : $mutobj = $obj->gene($objref);\n Function:\n\n           Returns or sets the link-reference to a\n           Bio::LiveSeq::Gene object. If no value has ben set, it\n           will return undef\n\n Returns : an object reference  or undef\n Args    : a Bio::LiveSeq::Gene\n\nSee L<Bio::LiveSeq::Gene> for more information.\n\n\nsub gene {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Gene') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::Gene object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'gene'} = $value;\n      }\n  }\n  unless (exists $self->{'gene'}) {\n      return;\n  } else {\n      return $self->{'gene'};\n  }\n}\n\n\n=head2 numbering\n\n Title   : numbering\n Usage   : $obj->numbering();\n Function:\n\n            Sets and returns coordinate system used in positioning the\n            mutations. See L<change_gene> for details.\n\n Example :\n Returns : string\n Args    : string (coding [transcript number] | gene | entry)\n\n\n\nsub numbering {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif ($value =~ /(coding)( )?(\\d+)?/ or $value eq 'entry' or $value eq 'gene') {\n\t    $self->{'numbering'} = $value;\n\t} else { # defaulting to 'coding'\n\t    $self->{'numbering'} = 'coding';\n\t}\n    }\n    unless (exists $self->{'numbering'}) {\n\treturn 'coding';\n    } else {\n\treturn $self->{'numbering'};\n    }\n}\n\n=head2 add_Mutation\n\n Title   : add_Mutation\n Usage   : $self->add_Mutation($ref)\n Function: adds a Bio::LiveSeq::Mutation object\n Example :\n Returns :\n Args    : a Bio::LiveSeq::Mutation\n\nSee L<Bio::LiveSeq::Mutation> for more information.\n\n\nsub add_Mutation{\n    my ($self,$value) = @_;\n    if( $value->isa('Bio::Liveseq::Mutation') ) {\n\tmy $com = ref $value;\n\t$self->throw(\"Is not a Mutation object but a [$com]\" );\n\treturn;\n    }\n    if (! $value->pos) {\n\t$self->warn(\"No value for mutation position in the sequence!\");\n\treturn;\n    }\n    if (! $value->seq && ! $value->len) {\n\t$self->warn(\"Either mutated sequence or length of the deletion must be given!\");\n\treturn;\n    }\n    push(@{$self->{'mutations'}},$value);\n}\n\n=head2 each_Mutation\n\n Title   : each_Mutation\n Usage   : foreach $ref ( $a->each_Mutation )\n Function: gets an array of Bio::LiveSeq::Mutation objects\n Example :\n Returns : array of Mutations\n Args    :\n\nSee L<Bio::LiveSeq::Mutation> for more information.\n\n\nsub each_Mutation{\n   my ($self) = @_;\n   return @{$self->{'mutations'}};\n}\n\n\n=head2 mutation\n\n Title   : mutation\n Usage   : $mutobj = $obj->mutation;\n         : $mutobj = $obj->mutation($objref);\n Function:\n\n           Returns or sets the link-reference to the current mutation\n           object.  If the value is not set, it will return undef.\n           Internal method.\n\n Returns : an object reference  or undef\n\n\n\nsub mutation {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Mutation') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::Mutation object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'mutation'} = $value;\n      }\n  }\n  unless (exists $self->{'mutation'}) {\n      return;\n  } else {\n      return $self->{'mutation'};\n  }\n}\n\n=head2 DNA\n\n Title   : DNA\n Usage   : $mutobj = $obj->DNA;\n         : $mutobj = $obj->DNA($objref);\n Function:\n\n           Returns or sets the reference to the LiveSeq object holding\n           the reference sequence. If there is no link, it will return\n           undef.\n           Internal method.\n\n Returns : an object reference or undef\n\n\nsub DNA {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::DNA') and ! $value->isa('Bio::LiveSeq::Transcript') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::DNA/Transcript object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'DNA'} = $value;\n      }\n  }\n  unless (exists $self->{'DNA'}) {\n      return;\n  } else {\n      return $self->{'DNA'};\n  }\n}\n\n\n=head2 RNA\n\n Title   : RNA\n Usage   : $mutobj = $obj->RNA;\n         : $mutobj = $obj->RNA($objref);\n Function:\n\n           Returns or sets the reference to the LiveSeq object holding\n           the reference sequence. If the value is not set, it will return\n           undef.\n           Internal method.\n\n Returns : an object reference  or undef\n\n\n\nsub RNA {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Transcript') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::RNA/Transcript object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'RNA'} = $value;\n      }\n  }\n  unless (exists $self->{'RNA'}) {\n      return;\n  } else {\n      return $self->{'RNA'};\n  }\n}\n\n\n=head2 dnamut\n\n Title   : dnamut\n Usage   : $mutobj = $obj->dnamut;\n         : $mutobj = $obj->dnamut($objref);\n Function:\n\n           Returns or sets the reference to the current DNAMutation object.\n           If the value is not set, it will return undef.\n           Internal method.\n\n Returns : a Bio::Variation::DNAMutation object or undef\n\nSee L<Bio::Variation::DNAMutation> for more information.\n\n\n\nsub dnamut {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::DNAMutation') ) {\n\t  $self->throw(\"Is not a Bio::Variation::DNAMutation object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'dnamut'} = $value;\n      }\n  }\n  unless (exists $self->{'dnamut'}) {\n      return;\n  } else {\n      return $self->{'dnamut'};\n  }\n}\n\n\n=head2 rnachange\n\n Title   : rnachange\n Usage   : $mutobj = $obj->rnachange;\n         : $mutobj = $obj->rnachange($objref);\n Function:\n\n           Returns or sets the reference to the current RNAChange object.\n           If the value is not set, it will return undef.\n           Internal method.\n\n Returns : a Bio::Variation::RNAChange object or undef\n\nSee L<Bio::Variation::RNAChange> for more information.\n\n\n\nsub rnachange {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::RNAChange') ) {\n\t  $self->throw(\"Is not a Bio::Variation::RNAChange object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'rnachange'} = $value;\n      }\n  }\n  unless (exists $self->{'rnachange'}) {\n      return;\n  } else {\n      return $self->{'rnachange'};\n  }\n}\n\n\n=head2 aachange\n\n Title   : aachange\n Usage   : $mutobj = $obj->aachange;\n         : $mutobj = $obj->aachange($objref);\n Function:\n\n           Returns or sets the reference to the current AAChange object.\n           If the value is not set, it will return undef.\n           Internal method.\n\n Returns : a Bio::Variation::AAChange object or undef\n\nSee L<Bio::Variation::AAChange> for more information.\n\n\n\nsub aachange {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::AAChange') ) {\n\t  $self->throw(\"Is not a Bio::Variation::AAChange object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'aachange'} = $value;\n      }\n  }\n  unless (exists $self->{'aachange'}) {\n      return;\n  } else {\n      return $self->{'aachange'};\n  }\n}\n\n\n=head2 exons\n\n Title   : exons\n Usage   : $mutobj = $obj->exons;\n         : $mutobj = $obj->exons($objref);\n Function:\n\n           Returns or sets the reference to a current array of Exons.\n           If the value is not set, it will return undef.\n           Internal method.\n\n Returns : an array of Bio::LiveSeq::Exon objects or undef\n\nSee L<Bio::LiveSeq::Exon> for more information.\n\n\n\nsub exons {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      $self->{'exons'} = $value;\n  }\n  unless (exists $self->{'exons'}) {\n      return;\n  } else {\n      return $self->{'exons'};\n  }\n}\n\n=head2 change_gene_with_alignment\n\n Title   : change_gene_with_alignment\n Usage   : $results=$mutate->change_gene_with_alignment($aln);\n\n Function:\n\n           Returns a Bio::Variation::SeqDiff object containing the\n           results of the changes in the alignment. The alignment has\n           to be pairwise and have one sequence named 'QUERY', the\n           other one is assumed to be a part of the sequence from\n           $gene.\n\n           This method offers a shortcut to change_gene and\n           automates the creation of Bio::LiveSeq::Mutation objects.\n           Use it with almost identical sequnces, e.g. to locate a SNP.\n\n Args    : Bio::SimpleAlign object representing a short local alignment\n Returns : Bio::Variation::SeqDiff object or 0 on error\n\nSee L<Bio::LiveSeq::Mutation>, L<Bio::SimpleAlign>, and\nL<Bio::Variation::SeqDiff>  for more information.\n\n\nsub change_gene_with_alignment {\n    my ($self, $aln) = @_;\n\n    #\n    # Sanity checks\n    #\n\n    $self->throw(\"Argument is not a Bio::SimpleAlign object but a [$aln]\")\n\tunless $aln->isa('Bio::SimpleAlign');\n    $self->throw(\"'Pairwise alignments only, please\") \n\tif $aln->no_sequences != 2;\n\n    # find out the order the two sequences are given\n    my $queryseq_pos = 1; #default\n    my $refseq_pos = 2;\n    unless ($aln->get_seq_by_pos(1)->id eq 'QUERY') {\n\tcarp('Query sequence has to be named QUERY') \n\t    if $aln->get_seq_by_pos(2)->id ne 'QUERY';\n\t$queryseq_pos = 2; # alternative\n\t$refseq_pos = 1;\n    }\n\n    # trim the alignment\n    my $start =  $aln->column_from_residue_number('QUERY', 1);\n    my $end =  $aln->column_from_residue_number('QUERY', \n\t\t\t\t\t\t$aln->get_seq_by_pos($queryseq_pos)->end );\n    \n    my $aln2 = $aln->slice($start, $end);\n\n    #\n    # extracting mutations\n    #\n\n    my $cs = $aln2->consensus_string(51);\n    my $queryseq = $aln2->get_seq_by_pos($queryseq_pos);\n    my $refseq = $aln2->get_seq_by_pos($refseq_pos);\n\n    while ( $cs =~ /(\\?+)/g) {\n\t# pos in local coordinates\n\tmy $pos = pos($cs) - length($1) + 1;\n\tmy $mutation = create_mutation($self, \n\t\t\t\t       $refseq, \n\t\t\t\t       $queryseq, \n\t\t\t\t       $pos, \n\t\t\t\t       CORE::length($1)\n\t\t\t\t       );\n\t# reset pos to refseq coordinates\n\t$pos +=  $refseq->start - 1;\n\t$mutation->pos($pos);\n\n        $self->add_Mutation($mutation);\n    }\n    return $self->change_gene();\n}\n\n=head2 create_mutation\n\n Title   : create_mutation\n Usage   : \n Function:\n\n           Formats sequence differences from two sequences into\n           Bio::LiveSeq::Mutation objects which can be applied to a\n           gene.\n\n           To keep it generic, sequence arguments need not to be\n           Bio::LocatableSeq. Coordinate change to parent sequence\n           numbering needs to be done by the calling code.\n\n           Called from change_gene_with_alignment\n\n Args    : Bio::PrimarySeqI inheriting object for the reference sequence\n           Bio::PrimarySeqI inheriting object for the query sequence\n           integer for the start position of the local sequence difference\n           integer for the length of the sequence difference\n Returns : Bio::LiveSeq::Mutation object \n\n\nsub create_mutation {\n    my ($self, $refseq, $queryseq, $pos, $len) = @_;\n    \n    $self->throw(\"Is not a Bio::PrimarySeqI object but a [$refseq]\") \n\tunless $refseq->isa('Bio::PrimarySeqI');\n    $self->throw(\"Is not a Bio::PrimarySeqI object but a [$queryseq]\") \n\tunless $queryseq->isa('Bio::PrimarySeqI');\n    $self->throw(\"Position is not a positive integer but [$pos]\") \n\tunless $pos =~ /^\\+?\\d+$/;\n    $self->throw(\"Length is not a positive integer but [$len]\") \n\tunless $len =~ /^\\+?\\d+$/;\n\n    my $mutation;\n    my $refstring = $refseq->subseq($pos, $pos + $len - 1);\n    my $varstring = $queryseq->subseq($pos, $pos + $len - 1);\n    \n    if ($len == 1 and $refstring =~ /[^\\.\\-\\*\\?]/ and \n\t$varstring  =~ /[^\\.\\-\\*\\?]/ ) { #point\n\t$mutation = Bio::LiveSeq::Mutation->new(-seq => $varstring,\n\t\t\t\t\t\t-pos => $pos,\n\t\t\t\t\t\t);\n    }\n    elsif ( $refstring =~ /^[^\\.\\-\\*\\?]+$/ and \n\t    $varstring  !~ /^[^\\.\\-\\*\\?]+$/ ) { # deletion\n\t$mutation = Bio::LiveSeq::Mutation->new(-pos => $pos,\n\t\t\t\t\t\t-len => $len\n\t\t\t\t\t\t);\n    }\n    elsif ( $refstring !~ /^[^\\.\\-\\*\\?]+$/ and \n\t    $varstring  =~ /^[^\\.\\-\\*\\?]+$/ ) { # insertion\n\t$mutation = Bio::LiveSeq::Mutation->new(-seq => $varstring,\n\t\t\t\t\t\t-pos => $pos,\n\t\t\t\t\t\t-len => 0\n\t\t\t\t\t\t);\n    } else { # complex\n\t$mutation = Bio::LiveSeq::Mutation->new(-seq => $varstring,\n\t\t\t\t\t\t-pos => $pos,\n\t\t\t\t\t\t-len => $len\n\t\t\t\t\t\t);\n    }\n    \n    return $mutation;\n}\n\n=head2 change_gene\n\n Title   : change_gene\n Usage   : my $mutate = Bio::LiveSeq::Mutator->new(-gene => $gene,\n\t\t\t\t\t\t   numbering => \"coding\"\n\t\t\t\t\t\t   );\n           # $mut is Bio::LiveSeq::Mutation object\n           $mutate->add_Mutation($mut);\n           my $results=$mutate->change_gene();\n\n Function:\n\n           Returns a Bio::Variation::SeqDiff object containing the\n           results of the changes performed according to the\n           instructions present in Mutation(s).  The -numbering\n           argument decides what molecule is being changed and what\n           numbering scheme being used:\n\n            -numbering => \"entry\"\n\n               determines the DNA level, using the numbering from the\n               beginning of the sequence\n\n            -numbering => \"coding\"\n\n               determines the RNA level, using the numbering from the\n               beginning of the 1st transcript\n\n               Alternative transcripts can be used by specifying\n               \"coding 2\" or \"coding 3\" ...\n\n            -numbering => \"gene\"\n\n               determines the DNA level, using the numbering from the\n               beginning of the 1st transcript and inluding introns.\n               The meaning equals 'coding' if the reference molecule\n               is cDNA.\n\n Args    : Bio::LiveSeq::Gene object\n           Bio::LiveSeq::Mutation object(s)\n           string specifying a numbering scheme (defaults to 'coding')\n Returns : Bio::Variation::SeqDiff object or 0 on error\n\n\nsub change_gene {\n    my ($self) = @_;\n\n    #\n    # Sanity check\n    #\n    unless ($self->gene) {\n\t$self->warn(\"Input object Bio::LiveSeq::Gene is not given\");\n\treturn 0;\n    }\n    #\n    # Setting the reference sequence based on -numbering\n    #\n    my @transcripts=@{$self->gene->get_Transcripts};\n    my $refseq; # will hold Bio::LiveSeq:Transcript object or Bio::LiveSeq::DNA\n\n    # 'gene' eq 'coding' if reference sequence is cDNA\n    $self->numbering ('coding') if $self->gene->get_DNA->alphabet eq 'rna' and $self->numbering eq 'gene';\n\n    if ($self->numbering =~ /(coding)( )?(\\d+)?/ ) {\n\t$self->numbering($1);\n\tmy $transnumber = $3;\n\t$transnumber-- if $3; # 1 -> 0, 2 -> 1\n\tif ($transnumber && $transnumber >= 0 && $transnumber <= $#transcripts) {\n\t    $refseq=$transcripts[$transnumber];\n\t} else {\n\t    $transnumber && $self->warn(\"The alternative transcript number \". $transnumber+1 .\n\t    \"- does not exist. Reverting to the 1st transcript\\n\");\n\t    $refseq=$transcripts[0];\n\t}\n    } else {\n\t$refseq=$transcripts[0]->{'seq'};\n    }\n    #\n    # Recording the state: SeqDiff object creation  ?? transcript no.??\n    #\n    my $seqDiff = Bio::Variation::SeqDiff->new(-verbose => $self->verbose);\n    $seqDiff->alphabet($self->gene->get_DNA->alphabet);\n    $seqDiff->numbering($self->numbering);\n    my ($DNAobj, $RNAobj);\n    if ($refseq->isa(\"Bio::LiveSeq::Transcript\")) {\n\t$self->RNA($refseq);\n\t$self->DNA($refseq->{'seq'});\n\t$seqDiff->rna_ori($refseq->seq );\n\t$seqDiff->aa_ori($refseq->get_Translation->seq);\n    } else {\n\t$self->DNA($refseq);\n\t$self->RNA($transcripts[0]);\n\t$seqDiff->rna_ori($self->RNA->seq);\n\t$seqDiff->aa_ori($self->RNA->get_Translation->seq);\n    }\n    $seqDiff->dna_ori($self->DNA->seq);\n    # put the accession number into the SeqDiff object ID\n    $seqDiff->id($self->DNA->accession_number);\n\n    # the atg_offset takes in account that DNA object could be a subset of the\n    # whole entry (via the light_weight loader)\n    my $atg_label=$self->RNA->start;\n    my $atg_offset=$self->DNA->position($atg_label)+($self->DNA->start)-1;\n    $seqDiff->offset($atg_offset - 1);\n    $self->DNA->coordinate_start($atg_label);\n\n    my @exons = $self->RNA->all_Exons;\n    $seqDiff->cds_end($exons[$#exons]->end);\n\n    #\n    # Converting mutation positions to labels\n    #\n    $self->warn(\"no mutations\"), return 0 \n\tunless $self->_mutationpos2label($refseq, $seqDiff);\n\n    # need to add more than one rna & aa\n    #foreach $transcript (@transcripts) {\n    #  $seqDiff{\"ori_transcript_${i}_seq\"}=$transcript->seq;\n    #  $seqDiff{\"ori_translation_${i}_seq\"}=$transcript->get_Translation->seq;\n    #}\n\n    # do changes\n    my $k;\n    foreach my $mutation ($self->each_Mutation) {\n\tnext unless $mutation->label > 0;\n\t$self->mutation($mutation);\n\n\t$mutation->issue(++$k);\n\t#\n\t# current position on the transcript\n\t#\n\tif ($self->numbering =~ /coding/) {\n\t    $mutation->transpos($mutation->pos); # transpos given by user\n\t} else {\n\t    #transpos of label / It will be 0 if mutating an intron, negative if upstream of ATG\n\t    $mutation->transpos($self->RNA->position($mutation->label,$atg_label));\n\t}\n\t#\n\t# Calculate adjacent labels based on the position on the current sequence\n\t#\n\t$mutation->prelabel($self->DNA->label(-1, $mutation->label)); # 1 before label\n\tif ($mutation->len == 0) {\n\t    $mutation->postlabel($mutation->label);\n\t    $mutation->lastlabel($mutation->label);\n\t} elsif ($mutation->len == 1) {\n\t    $mutation->lastlabel($mutation->label); # last nucleotide affected\n\t    $mutation->postlabel($self->DNA->label(2,$mutation->lastlabel)); # $len after label\n\t} else {\n\t    $mutation->lastlabel($self->DNA->label($mutation->len,$mutation->label));\n\t    $mutation->postlabel($self->DNA->label(2,$mutation->lastlabel));\n\t}\n\tmy $dnamut = $self->_set_DNAMutation($seqDiff);\n\t#\n\t#\n\t#\n\tif ($self->_rnaAffected) {\n\t    $self->_set_effects($seqDiff, $dnamut);\n\t}\n\telsif ($seqDiff->offset != 0 and $dnamut->region ne 'intron') {\n\t    $self->_untranslated ($seqDiff, $dnamut);\n\t} else {\n\t    #$self->warn(\"Mutation starts outside coding region, RNAChange object not created\");\n\t}\n\n\t#########################################################################\n\t# Mutations are done here!                                              #\n\t$refseq->labelchange($mutation->seq, $mutation->label, $mutation->len); #\n\t#########################################################################\n\n\t$self->_post_mutation ($seqDiff);\n\n\t$self->dnamut(undef);\n\t$self->rnachange(undef);\n\t$self->aachange(undef);\n\t$self->exons(undef);\n    }\n    # record the final state of all three sequences\n    $seqDiff->dna_mut($self->DNA->seq);\n    $seqDiff->rna_mut($self->RNA->seq);\n    if ($refseq->isa(\"Bio::LiveSeq::Transcript\")) {\n\t$seqDiff->aa_mut($refseq->get_Translation->seq);\n    } else {\n\t$seqDiff->aa_mut($self->RNA->get_Translation->seq);\n    }\n\n    #$seqDiff{mut_dna_seq}=$gene->get_DNA->seq;\n    #my $i=1;\n    #foreach $transcript (@transcripts) {\n    #  $seqDiff{\"mut_transcript_${i}_seq\"}=$transcript->seq;\n    #  $seqDiff{\"mut_translation_${i}_seq\"}=$transcript->get_Translation->seq;\n    #}\n    return $seqDiff;\n}\n\n=head2 _mutationpos2label\n\n Title   : _mutationpos2label\n Usage   :\n Function: converts mutation positions into labels\n Example :\n Returns : number of valid mutations\n Args    : LiveSeq sequence object\n\n\nsub _mutationpos2label {\n    my ($self, $refseq, $SeqDiff) = @_;\n    my $count;\n    my @bb = @{$self->{'mutations'}};\n    my $cc = scalar @bb;\n    foreach my $mut (@{$self->{'mutations'}}) {\n#\t if ($self->numbering eq 'gene' and $mut->pos < 1) {\n#\t     my $tmp = $mut->pos;\n#\t     print STDERR \"pos: \", \"$tmp\\n\";\n#\t     $tmp++ if $tmp < 1;\n#\t     $tmp += $SeqDiff->offset;\n#\t     print STDERR \"pos2: \", \"$tmp\\n\";\n#\t     $mut->pos($tmp);\n#\t }\n#\telsif ($self->numbering eq 'entry') {\n\tif ($self->numbering eq 'entry') {\n\t    my $tmp = $mut->pos;\n\t    $tmp -= $SeqDiff->offset;\n\t    $tmp-- if $tmp < 1;\n\t    $mut->pos($tmp);\n\t}\n\n\tmy $label = $refseq->label($mut->pos); # get the label for the position\n\t$mut->label($label), $count++ if $label > 0 ;\n\t#print STDERR \"x\", $mut->pos,'|' ,$mut->label, \"\\n\";\n    }\n    return $count;\n}\n\n#\n# Calculate labels around mutated nucleotide\n#\n\n=head2 _set_DNAMutation\n\n Title   : _set_DNAMutation\n Usage   :\n Function:\n\n           Stores DNA level mutation attributes before mutation into\n           Bio::Variation::DNAMutation object.  Links it to SeqDiff\n           object.\n\n Example :\n Returns : Bio::Variation::DNAMutation object\n Args    : Bio::Variation::SeqDiff object\n\nSee L<Bio::Variation::DNAMutation> and L<Bio::Variation::SeqDiff>."},"children":[{"definition":"my","localvar":"my","kind":13,"containerName":"_set_DNAMutation","name":"$self","line":892},{"kind":13,"containerName":"_set_DNAMutation","name":"$seqDiff","line":892},{"definition":"my","line":894,"kind":13,"localvar":"my","containerName":"_set_DNAMutation","name":"$dnamut_start"},{"containerName":"_set_DNAMutation","kind":13,"name":"$self","line":894},{"line":894,"kind":12,"containerName":"_set_DNAMutation","name":"mutation"},{"line":894,"containerName":"_set_DNAMutation","kind":12,"name":"label"},{"line":894,"kind":13,"containerName":"_set_DNAMutation","name":"$seqDiff"},{"name":"offset","containerName":"_set_DNAMutation","kind":12,"line":894},{"line":896,"containerName":"_set_DNAMutation","kind":13,"name":"$dnamut_start"},{"kind":13,"containerName":"_set_DNAMutation","name":"$dnamut_start","line":896},{"name":"$dnamut_end","containerName":"_set_DNAMutation","localvar":"my","kind":13,"line":897,"definition":"my"},{"containerName":"_set_DNAMutation","kind":13,"name":"$self","line":898},{"line":898,"name":"mutation","kind":12,"containerName":"_set_DNAMutation"},{"containerName":"_set_DNAMutation","kind":12,"name":"len","line":898},{"line":898,"containerName":"_set_DNAMutation","kind":13,"name":"$self"},{"containerName":"_set_DNAMutation","kind":12,"name":"mutation","line":898},{"line":898,"name":"len","kind":12,"containerName":"_set_DNAMutation"},{"line":899,"kind":13,"containerName":"_set_DNAMutation","name":"$dnamut_end"},{"line":899,"containerName":"_set_DNAMutation","kind":13,"name":"$dnamut_start"},{"line":900,"name":"$dnamut_end","kind":13,"containerName":"_set_DNAMutation"},{"name":"$dnamut_start","containerName":"_set_DNAMutation","kind":13,"line":900},{"name":"$self","containerName":"_set_DNAMutation","kind":13,"line":900},{"line":900,"name":"mutation","kind":12,"containerName":"_set_DNAMutation"},{"name":"len","containerName":"_set_DNAMutation","kind":12,"line":900},{"localvar":"my","kind":13,"containerName":"_set_DNAMutation","name":"$dnamut","line":902,"definition":"my"},{"containerName":"_set_DNAMutation","kind":12,"name":"new","line":902},{"kind":13,"containerName":"_set_DNAMutation","name":"$dnamut_start","line":902},{"line":903,"name":"$dnamut_end","kind":13,"containerName":"_set_DNAMutation"},{"line":905,"name":"$dnamut","kind":13,"containerName":"_set_DNAMutation"},{"line":905,"name":"mut_number","kind":12,"containerName":"_set_DNAMutation"},{"line":905,"kind":13,"containerName":"_set_DNAMutation","name":"$self"},{"line":905,"name":"mutation","kind":12,"containerName":"_set_DNAMutation"},{"name":"issue","kind":12,"containerName":"_set_DNAMutation","line":905},{"line":906,"name":"$dnamut","containerName":"_set_DNAMutation","kind":13},{"line":906,"name":"isMutation","kind":12,"containerName":"_set_DNAMutation"},{"definition":"my","name":"$da_m","containerName":"_set_DNAMutation","localvar":"my","kind":13,"line":907},{"line":907,"containerName":"_set_DNAMutation","kind":12,"name":"new"},{"name":"$da_m","containerName":"_set_DNAMutation","kind":13,"line":908},{"name":"seq","containerName":"_set_DNAMutation","kind":12,"line":908},{"line":908,"kind":13,"containerName":"_set_DNAMutation","name":"$self"},{"line":908,"name":"mutation","kind":12,"containerName":"_set_DNAMutation"},{"name":"seq","kind":12,"containerName":"_set_DNAMutation","line":908},{"line":908,"name":"$self","kind":13,"containerName":"_set_DNAMutation"},{"containerName":"_set_DNAMutation","kind":12,"name":"mutation","line":908},{"line":908,"name":"seq","kind":12,"containerName":"_set_DNAMutation"},{"containerName":"_set_DNAMutation","kind":13,"name":"$dnamut","line":909},{"line":909,"containerName":"_set_DNAMutation","kind":12,"name":"allele_mut"},{"name":"$da_m","kind":13,"containerName":"_set_DNAMutation","line":909},{"line":910,"containerName":"_set_DNAMutation","kind":13,"name":"$dnamut"},{"containerName":"_set_DNAMutation","kind":12,"name":"add_Allele","line":910},{"line":910,"containerName":"_set_DNAMutation","kind":13,"name":"$da_m"},{"definition":"my","line":912,"kind":13,"localvar":"my","containerName":"_set_DNAMutation","name":"$allele_ori"},{"line":912,"name":"$self","kind":13,"containerName":"_set_DNAMutation"},{"line":912,"kind":12,"containerName":"_set_DNAMutation","name":"DNA"},{"line":912,"containerName":"_set_DNAMutation","kind":12,"name":"labelsubseq"},{"name":"$self","containerName":"_set_DNAMutation","kind":13,"line":912},{"kind":12,"containerName":"_set_DNAMutation","name":"mutation","line":912},{"name":"prelabel","kind":12,"containerName":"_set_DNAMutation","line":912},{"containerName":"_set_DNAMutation","kind":13,"name":"$self","line":914},{"line":914,"kind":12,"containerName":"_set_DNAMutation","name":"mutation"},{"line":914,"kind":12,"containerName":"_set_DNAMutation","name":"postlabel"},{"name":"$allele_ori","containerName":"_set_DNAMutation","kind":13,"line":915},{"line":916,"name":"$allele_ori","kind":13,"containerName":"_set_DNAMutation"},{"line":916,"containerName":"_set_DNAMutation","kind":13,"name":"$allele_ori"},{"definition":"my","line":917,"localvar":"my","kind":13,"containerName":"_set_DNAMutation","name":"$da_o"},{"line":917,"kind":12,"containerName":"_set_DNAMutation","name":"new"},{"line":918,"name":"$da_o","containerName":"_set_DNAMutation","kind":13},{"line":918,"kind":12,"containerName":"_set_DNAMutation","name":"seq"},{"containerName":"_set_DNAMutation","kind":13,"name":"$allele_ori","line":918},{"line":918,"name":"$allele_ori","kind":13,"containerName":"_set_DNAMutation"},{"line":919,"name":"$dnamut","containerName":"_set_DNAMutation","kind":13},{"line":919,"containerName":"_set_DNAMutation","kind":12,"name":"allele_ori"},{"containerName":"_set_DNAMutation","kind":13,"name":"$da_o","line":919},{"line":920,"kind":13,"containerName":"_set_DNAMutation","name":"$self"},{"line":920,"name":"mutation","kind":12,"containerName":"_set_DNAMutation"},{"line":920,"containerName":"_set_DNAMutation","kind":12,"name":"len"},{"name":"$dnamut","kind":13,"containerName":"_set_DNAMutation","line":921},{"name":"length","containerName":"_set_DNAMutation","kind":12,"line":921},{"name":"$self","containerName":"_set_DNAMutation","kind":13,"line":921},{"kind":12,"containerName":"_set_DNAMutation","name":"mutation","line":921},{"containerName":"_set_DNAMutation","kind":12,"name":"len","line":921},{"line":921,"kind":13,"containerName":"_set_DNAMutation","name":"$dnamut"},{"containerName":"_set_DNAMutation","kind":12,"name":"length","line":921},{"line":921,"name":"$allele_ori","kind":13,"containerName":"_set_DNAMutation"},{"name":"$seqDiff","kind":13,"containerName":"_set_DNAMutation","line":923},{"line":923,"name":"add_Variant","kind":12,"containerName":"_set_DNAMutation"},{"name":"$dnamut","kind":13,"containerName":"_set_DNAMutation","line":923},{"name":"$self","kind":13,"containerName":"_set_DNAMutation","line":924},{"kind":12,"containerName":"_set_DNAMutation","name":"dnamut","line":924},{"line":924,"name":"$dnamut","kind":13,"containerName":"_set_DNAMutation"},{"name":"$dnamut","kind":13,"containerName":"_set_DNAMutation","line":925},{"containerName":"_set_DNAMutation","kind":12,"name":"mut_number","line":925},{"line":925,"name":"$self","kind":13,"containerName":"_set_DNAMutation"},{"name":"mutation","containerName":"_set_DNAMutation","kind":12,"line":925},{"line":925,"kind":12,"containerName":"_set_DNAMutation","name":"issue"},{"containerName":"_set_DNAMutation","kind":13,"name":"$seqDiff","line":927},{"containerName":"_set_DNAMutation","kind":12,"name":"numbering","line":927},{"name":"$seqDiff","containerName":"_set_DNAMutation","kind":13,"line":927},{"containerName":"_set_DNAMutation","kind":12,"name":"numbering","line":927},{"line":928,"kind":13,"containerName":"_set_DNAMutation","name":"$dnamut"},{"line":928,"name":"proof","kind":12,"containerName":"_set_DNAMutation"},{"kind":13,"containerName":"_set_DNAMutation","name":"$dnamut","line":930},{"line":930,"name":"proof","kind":12,"containerName":"_set_DNAMutation"},{"line":933,"containerName":"_set_DNAMutation","localvar":"my","kind":13,"name":"$flanklen","definition":"my"},{"name":"$self","containerName":"_set_DNAMutation","kind":13,"line":933},{"name":"$uplabel","containerName":"_set_DNAMutation","localvar":"my","kind":13,"line":935,"definition":"my"},{"name":"$self","containerName":"_set_DNAMutation","kind":13,"line":935},{"name":"DNA","containerName":"_set_DNAMutation","kind":12,"line":935},{"name":"label","containerName":"_set_DNAMutation","kind":12,"line":935},{"kind":13,"containerName":"_set_DNAMutation","name":"$flanklen","line":935},{"line":935,"name":"$self","kind":13,"containerName":"_set_DNAMutation"},{"kind":12,"containerName":"_set_DNAMutation","name":"mutation","line":935},{"line":935,"name":"prelabel","kind":12,"containerName":"_set_DNAMutation"},{"definition":"my","name":"$upstreamseq","localvar":"my","containerName":"_set_DNAMutation","kind":13,"line":937},{"line":938,"kind":13,"containerName":"_set_DNAMutation","name":"$uplabel"},{"line":939,"kind":13,"containerName":"_set_DNAMutation","name":"$upstreamseq"},{"line":940,"name":"$self","containerName":"_set_DNAMutation","kind":13},{"name":"DNA","kind":12,"containerName":"_set_DNAMutation","line":940},{"kind":12,"containerName":"_set_DNAMutation","name":"labelsubseq","line":940},{"line":940,"containerName":"_set_DNAMutation","kind":13,"name":"$uplabel"},{"name":"$self","kind":13,"containerName":"_set_DNAMutation","line":940},{"line":940,"name":"mutation","containerName":"_set_DNAMutation","kind":12},{"name":"prelabel","kind":12,"containerName":"_set_DNAMutation","line":940},{"line":942,"name":"$upstreamseq","containerName":"_set_DNAMutation","kind":13},{"containerName":"_set_DNAMutation","kind":13,"name":"$self","line":943},{"kind":12,"containerName":"_set_DNAMutation","name":"DNA","line":943},{"containerName":"_set_DNAMutation","kind":12,"name":"labelsubseq","line":943},{"line":943,"name":"$self","kind":13,"containerName":"_set_DNAMutation"},{"line":943,"name":"DNA","containerName":"_set_DNAMutation","kind":12},{"line":943,"kind":12,"containerName":"_set_DNAMutation","name":"start"},{"line":943,"containerName":"_set_DNAMutation","kind":13,"name":"$self"},{"line":943,"name":"mutation","containerName":"_set_DNAMutation","kind":12},{"containerName":"_set_DNAMutation","kind":12,"name":"prelabel","line":943},{"name":"$dnamut","kind":13,"containerName":"_set_DNAMutation","line":945},{"line":945,"name":"upStreamSeq","kind":12,"containerName":"_set_DNAMutation"},{"line":945,"name":"$upstreamseq","containerName":"_set_DNAMutation","kind":13},{"definition":"my","line":946,"localvar":"my","kind":13,"containerName":"_set_DNAMutation","name":"$dnstreamseq"},{"name":"$self","containerName":"_set_DNAMutation","kind":13,"line":946},{"line":946,"kind":12,"containerName":"_set_DNAMutation","name":"DNA"},{"line":946,"name":"labelsubseq","containerName":"_set_DNAMutation","kind":12},{"name":"$self","kind":13,"containerName":"_set_DNAMutation","line":946},{"line":946,"name":"mutation","containerName":"_set_DNAMutation","kind":12},{"kind":12,"containerName":"_set_DNAMutation","name":"postlabel","line":946},{"line":946,"containerName":"_set_DNAMutation","kind":13,"name":"$flanklen"},{"line":947,"kind":13,"containerName":"_set_DNAMutation","name":"$dnamut"},{"name":"dnStreamSeq","kind":12,"containerName":"_set_DNAMutation","line":947},{"kind":13,"containerName":"_set_DNAMutation","name":"$dnstreamseq","line":947},{"name":"$dnamut","kind":13,"containerName":"_set_DNAMutation","line":948}],"name":"_set_DNAMutation","containerName":"main::","definition":"sub","detail":"($self,$seqDiff)"},{"name":"Bio","kind":12,"containerName":"Variation::DNAMutation","line":902},{"containerName":"Variation::Allele","kind":12,"name":"Bio","line":907},{"line":917,"containerName":"Variation::Allele","kind":12,"name":"Bio"},{"line":921,"name":"CORE","containerName":"length","kind":12},{"children":[{"line":960,"name":"$self","localvar":"my","kind":13,"containerName":"_rnaAffected","definition":"my"},{"line":961,"localvar":"my","containerName":"_rnaAffected","kind":13,"name":"@exons","definition":"my"},{"containerName":"_rnaAffected","kind":13,"name":"$self","line":961},{"kind":12,"containerName":"_rnaAffected","name":"RNA","line":961},{"line":961,"name":"all_Exons","kind":12,"containerName":"_rnaAffected"},{"definition":"my","name":"$RNAstart","kind":13,"localvar":"my","containerName":"_rnaAffected","line":962},{"line":962,"name":"$self","containerName":"_rnaAffected","kind":13},{"line":962,"name":"RNA","kind":12,"containerName":"_rnaAffected"},{"line":962,"containerName":"_rnaAffected","kind":12,"name":"start"},{"line":963,"name":"$RNAend","containerName":"_rnaAffected","localvar":"my","kind":13,"definition":"my"},{"line":963,"name":"$self","containerName":"_rnaAffected","kind":13},{"containerName":"_rnaAffected","kind":12,"name":"RNA","line":963},{"line":963,"containerName":"_rnaAffected","kind":12,"name":"end"},{"line":964,"name":"$firstexon","kind":13,"localvar":"my","containerName":"_rnaAffected","definition":"my"},{"line":964,"kind":13,"containerName":"_rnaAffected","name":"$before"},{"line":964,"name":"$after","kind":13,"containerName":"_rnaAffected"},{"name":"$i","containerName":"_rnaAffected","kind":13,"line":964},{"definition":"my","containerName":"_rnaAffected","localvar":"my","kind":13,"name":"$rnaAffected","line":965},{"line":968,"name":"$DNAend","localvar":"my","kind":13,"containerName":"_rnaAffected","definition":"my"},{"line":968,"kind":13,"containerName":"_rnaAffected","name":"$self"},{"kind":12,"containerName":"_rnaAffected","name":"RNA","line":968},{"line":968,"containerName":"_rnaAffected","kind":12,"name":"end"},{"line":969,"name":"$self","kind":13,"containerName":"_rnaAffected"},{"line":969,"name":"mutation","containerName":"_rnaAffected","kind":12},{"name":"prelabel","kind":12,"containerName":"_rnaAffected","line":969},{"line":969,"kind":13,"containerName":"_rnaAffected","name":"$DNAend"},{"name":"$self","kind":13,"containerName":"_rnaAffected","line":969},{"containerName":"_rnaAffected","kind":12,"name":"mutation","line":969},{"line":969,"name":"postlabel","containerName":"_rnaAffected","kind":12},{"name":"$DNAend","kind":13,"containerName":"_rnaAffected","line":969},{"line":973,"kind":13,"containerName":"_rnaAffected","name":"$self"},{"containerName":"_rnaAffected","kind":12,"name":"warn","line":973},{"containerName":"_rnaAffected","kind":13,"name":"$self","line":974},{"name":"mutation","containerName":"_rnaAffected","kind":12,"line":974},{"kind":12,"containerName":"_rnaAffected","name":"postlabel","line":974},{"name":"$RNAstart","kind":13,"containerName":"_rnaAffected","line":974},{"name":"$self","kind":13,"containerName":"_rnaAffected","line":974},{"line":974,"name":"mutation","containerName":"_rnaAffected","kind":12},{"line":974,"name":"postlabel","kind":12,"containerName":"_rnaAffected"},{"line":974,"containerName":"_rnaAffected","kind":13,"name":"$RNAstart"},{"name":"$self","kind":13,"containerName":"_rnaAffected","line":975},{"name":"warn","containerName":"_rnaAffected","kind":12,"line":975},{"name":"$RNAend","kind":13,"containerName":"_rnaAffected","line":977},{"line":977,"containerName":"_rnaAffected","kind":13,"name":"$self"},{"name":"mutation","containerName":"_rnaAffected","kind":12,"line":977},{"line":977,"containerName":"_rnaAffected","kind":12,"name":"prelabel"},{"containerName":"_rnaAffected","kind":13,"name":"$RNAend","line":977},{"containerName":"_rnaAffected","kind":13,"name":"$self","line":977},{"line":977,"name":"mutation","kind":12,"containerName":"_rnaAffected"},{"line":977,"name":"prelabel","kind":12,"containerName":"_rnaAffected"},{"name":"$self","kind":13,"containerName":"_rnaAffected","line":978},{"containerName":"_rnaAffected","kind":12,"name":"warn","line":978},{"name":"@exons","containerName":"_rnaAffected","kind":13,"line":980},{"kind":13,"containerName":"_rnaAffected","name":"$rnaAffected","line":982},{"name":"$firstexon","containerName":"_rnaAffected","kind":13,"line":985},{"name":"@exons","kind":13,"containerName":"_rnaAffected","line":985},{"line":986,"kind":13,"containerName":"_rnaAffected","name":"$before"},{"line":986,"name":"$firstexon","kind":13,"containerName":"_rnaAffected"},{"line":986,"containerName":"_rnaAffected","kind":12,"name":"end"},{"line":988,"containerName":"_rnaAffected","kind":13,"name":"$i"},{"line":989,"name":"$after","containerName":"_rnaAffected","kind":13},{"line":989,"name":"$exons","containerName":"_rnaAffected","kind":13},{"kind":13,"containerName":"_rnaAffected","name":"$i","line":989},{"kind":12,"containerName":"_rnaAffected","name":"start","line":989},{"line":990,"kind":13,"containerName":"_rnaAffected","name":"$self"},{"line":990,"name":"mutation","kind":12,"containerName":"_rnaAffected"},{"containerName":"_rnaAffected","kind":12,"name":"prelabel","line":990},{"kind":13,"containerName":"_rnaAffected","name":"$before","line":990},{"containerName":"_rnaAffected","kind":13,"name":"$after","line":991},{"line":991,"containerName":"_rnaAffected","kind":13,"name":"$self"},{"line":991,"name":"mutation","kind":12,"containerName":"_rnaAffected"},{"line":991,"containerName":"_rnaAffected","kind":12,"name":"prelabel"},{"name":"$after","containerName":"_rnaAffected","kind":13,"line":992},{"line":992,"name":"$self","containerName":"_rnaAffected","kind":13},{"kind":12,"containerName":"_rnaAffected","name":"mutation","line":992},{"line":992,"name":"prelabel","kind":12,"containerName":"_rnaAffected"},{"name":"$after","kind":13,"containerName":"_rnaAffected","line":993},{"kind":13,"containerName":"_rnaAffected","name":"$self","line":993},{"name":"mutation","containerName":"_rnaAffected","kind":12,"line":993},{"name":"postlabel","containerName":"_rnaAffected","kind":12,"line":993},{"kind":13,"containerName":"_rnaAffected","name":"$rnaAffected","line":995},{"name":"$before","kind":13,"containerName":"_rnaAffected","line":998},{"name":"$exons","containerName":"_rnaAffected","kind":13,"line":998},{"line":998,"name":"$i","kind":13,"containerName":"_rnaAffected"},{"line":998,"name":"end","kind":12,"containerName":"_rnaAffected"},{"line":1003,"containerName":"_rnaAffected","localvar":"my","kind":13,"name":"$strand","definition":"my"},{"name":"$exons","containerName":"_rnaAffected","kind":13,"line":1003},{"name":"strand","kind":12,"containerName":"_rnaAffected","line":1003},{"name":"$strand","kind":13,"containerName":"_rnaAffected","line":1004},{"line":1004,"name":"$self","kind":13,"containerName":"_rnaAffected"},{"name":"mutation","containerName":"_rnaAffected","kind":12,"line":1004},{"line":1004,"containerName":"_rnaAffected","kind":12,"name":"postlabel"},{"line":1004,"kind":13,"containerName":"_rnaAffected","name":"$RNAstart"},{"kind":13,"containerName":"_rnaAffected","name":"$strand","line":1005},{"name":"$self","containerName":"_rnaAffected","kind":13,"line":1005},{"line":1005,"containerName":"_rnaAffected","kind":12,"name":"mutation"},{"line":1005,"name":"postlabel","containerName":"_rnaAffected","kind":12},{"line":1005,"kind":13,"containerName":"_rnaAffected","name":"$RNAstart"},{"line":1007,"kind":13,"containerName":"_rnaAffected","name":"$rnaAffected"},{"line":1009,"kind":13,"containerName":"_rnaAffected","name":"$strand"},{"containerName":"_rnaAffected","kind":13,"name":"$self","line":1009},{"name":"mutation","kind":12,"containerName":"_rnaAffected","line":1009},{"containerName":"_rnaAffected","kind":12,"name":"prelabel","line":1009},{"line":1009,"kind":13,"containerName":"_rnaAffected","name":"$RNAend"},{"name":"$strand","containerName":"_rnaAffected","kind":13,"line":1010},{"line":1010,"kind":13,"containerName":"_rnaAffected","name":"$self"},{"containerName":"_rnaAffected","kind":12,"name":"mutation","line":1010},{"containerName":"_rnaAffected","kind":12,"name":"prelabel","line":1010},{"name":"$RNAend","containerName":"_rnaAffected","kind":13,"line":1010},{"line":1012,"name":"$rnaAffected","containerName":"_rnaAffected","kind":13},{"line":1013,"containerName":"_rnaAffected","localvar":"my","kind":13,"name":"$dist","definition":"my"},{"name":"$strand","kind":13,"containerName":"_rnaAffected","line":1014},{"line":1015,"kind":13,"containerName":"_rnaAffected","name":"$dist"},{"containerName":"_rnaAffected","kind":13,"name":"$self","line":1015},{"line":1015,"name":"mutation","containerName":"_rnaAffected","kind":12},{"line":1015,"name":"prelabel","kind":12,"containerName":"_rnaAffected"},{"containerName":"_rnaAffected","kind":13,"name":"$RNAend","line":1015},{"kind":13,"containerName":"_rnaAffected","name":"$dist","line":1017},{"line":1017,"name":"$RNAend","kind":13,"containerName":"_rnaAffected"},{"kind":13,"containerName":"_rnaAffected","name":"$self","line":1017},{"line":1017,"name":"mutation","containerName":"_rnaAffected","kind":12},{"line":1017,"name":"prelabel","containerName":"_rnaAffected","kind":12},{"line":1019,"containerName":"_rnaAffected","kind":13,"name":"$self"},{"name":"dnamut","containerName":"_rnaAffected","kind":12,"line":1019},{"line":1019,"kind":12,"containerName":"_rnaAffected","name":"region_dist"},{"line":1019,"kind":13,"containerName":"_rnaAffected","name":"$dist"},{"line":1021,"kind":13,"containerName":"_rnaAffected","name":"@exons"},{"line":1023,"name":"$rnaAffected","kind":13,"containerName":"_rnaAffected"},{"line":1026,"name":"$firstexon","containerName":"_rnaAffected","kind":13},{"line":1026,"kind":13,"containerName":"_rnaAffected","name":"@exons"},{"line":1027,"containerName":"_rnaAffected","kind":13,"name":"$before"},{"line":1027,"containerName":"_rnaAffected","kind":13,"name":"$firstexon"},{"line":1027,"kind":12,"containerName":"_rnaAffected","name":"end"},{"name":"$strand","containerName":"_rnaAffected","kind":13,"line":1028},{"name":"$self","containerName":"_rnaAffected","kind":13,"line":1028},{"containerName":"_rnaAffected","kind":12,"name":"mutation","line":1028},{"name":"prelabel","kind":12,"containerName":"_rnaAffected","line":1028},{"line":1028,"kind":13,"containerName":"_rnaAffected","name":"$before"},{"name":"$strand","kind":13,"containerName":"_rnaAffected","line":1029},{"line":1029,"name":"$self","kind":13,"containerName":"_rnaAffected"},{"name":"mutation","containerName":"_rnaAffected","kind":12,"line":1029},{"containerName":"_rnaAffected","kind":12,"name":"prelabel","line":1029},{"line":1029,"kind":13,"containerName":"_rnaAffected","name":"$before"},{"name":"$rnaAffected","kind":13,"containerName":"_rnaAffected","line":1031},{"definition":"my","line":1034,"name":"$afterdist","containerName":"_rnaAffected","localvar":"my","kind":13},{"name":"$self","kind":13,"containerName":"_rnaAffected","line":1034},{"containerName":"_rnaAffected","kind":12,"name":"mutation","line":1034},{"line":1034,"name":"prelabel","kind":12,"containerName":"_rnaAffected"},{"line":1034,"containerName":"_rnaAffected","kind":13,"name":"$firstexon"},{"line":1034,"name":"start","kind":12,"containerName":"_rnaAffected"},{"definition":"my","name":"$beforedist","kind":13,"localvar":"my","containerName":"_rnaAffected","line":1035},{"name":"$firstexon","containerName":"_rnaAffected","kind":13,"line":1035},{"line":1035,"name":"end","containerName":"_rnaAffected","kind":12},{"kind":13,"containerName":"_rnaAffected","name":"$self","line":1035},{"line":1035,"kind":12,"containerName":"_rnaAffected","name":"mutation"},{"line":1035,"containerName":"_rnaAffected","kind":12,"name":"postlabel"},{"name":"$exonvalue","localvar":"my","containerName":"_rnaAffected","kind":13,"line":1036,"definition":"my"},{"kind":13,"containerName":"_rnaAffected","name":"$i","line":1036},{"name":"$self","kind":13,"containerName":"_rnaAffected","line":1037},{"line":1037,"name":"dnamut","kind":12,"containerName":"_rnaAffected"},{"line":1037,"name":"region","containerName":"_rnaAffected","kind":12},{"line":1038,"name":"$self","kind":13,"containerName":"_rnaAffected"},{"name":"dnamut","containerName":"_rnaAffected","kind":12,"line":1038},{"kind":12,"containerName":"_rnaAffected","name":"region_value","line":1038},{"name":"$exonvalue","containerName":"_rnaAffected","kind":13,"line":1038},{"name":"$afterdist","kind":13,"containerName":"_rnaAffected","line":1039},{"line":1039,"name":"$beforedist","containerName":"_rnaAffected","kind":13},{"line":1040,"name":"$afterdist","containerName":"_rnaAffected","kind":13},{"line":1041,"containerName":"_rnaAffected","kind":13,"name":"$afterdist"},{"name":"$self","containerName":"_rnaAffected","kind":13,"line":1042},{"name":"dnamut","containerName":"_rnaAffected","kind":12,"line":1042},{"line":1042,"kind":12,"containerName":"_rnaAffected","name":"region_dist"},{"line":1042,"kind":13,"containerName":"_rnaAffected","name":"$afterdist"},{"line":1045,"kind":13,"containerName":"_rnaAffected","name":"$self"},{"containerName":"_rnaAffected","kind":12,"name":"dnamut","line":1045},{"name":"region_dist","containerName":"_rnaAffected","kind":12,"line":1045},{"kind":13,"containerName":"_rnaAffected","name":"$beforedist","line":1045},{"line":1050,"name":"$i","containerName":"_rnaAffected","kind":13},{"name":"$after","kind":13,"containerName":"_rnaAffected","line":1051},{"line":1051,"kind":13,"containerName":"_rnaAffected","name":"$exons"},{"line":1051,"name":"$i","kind":13,"containerName":"_rnaAffected"},{"containerName":"_rnaAffected","kind":12,"name":"start","line":1051},{"containerName":"_rnaAffected","kind":13,"name":"$strand","line":1053},{"line":1054,"name":"$self","containerName":"_rnaAffected","kind":13},{"containerName":"_rnaAffected","kind":12,"name":"mutation","line":1054},{"name":"prelabel","kind":12,"containerName":"_rnaAffected","line":1054},{"line":1054,"kind":13,"containerName":"_rnaAffected","name":"$before"},{"line":1055,"kind":13,"containerName":"_rnaAffected","name":"$self"},{"line":1055,"name":"mutation","kind":12,"containerName":"_rnaAffected"},{"containerName":"_rnaAffected","kind":12,"name":"postlabel","line":1055},{"line":1055,"name":"$after","kind":13,"containerName":"_rnaAffected"},{"line":1057,"name":"$strand","containerName":"_rnaAffected","kind":13},{"line":1058,"containerName":"_rnaAffected","kind":13,"name":"$self"},{"name":"mutation","kind":12,"containerName":"_rnaAffected","line":1058},{"line":1058,"name":"prelabel","containerName":"_rnaAffected","kind":12},{"name":"$before","containerName":"_rnaAffected","kind":13,"line":1058},{"name":"$self","containerName":"_rnaAffected","kind":13,"line":1059},{"line":1059,"name":"mutation","kind":12,"containerName":"_rnaAffected"},{"kind":12,"containerName":"_rnaAffected","name":"postlabel","line":1059},{"name":"$after","kind":13,"containerName":"_rnaAffected","line":1059},{"name":"$self","kind":13,"containerName":"_rnaAffected","line":1060},{"line":1060,"name":"dnamut","containerName":"_rnaAffected","kind":12},{"line":1060,"containerName":"_rnaAffected","kind":12,"name":"region"},{"line":1062,"kind":13,"localvar":"my","containerName":"_rnaAffected","name":"$afterdist","definition":"my"},{"line":1062,"name":"$self","containerName":"_rnaAffected","kind":13},{"line":1062,"kind":12,"containerName":"_rnaAffected","name":"mutation"},{"line":1062,"kind":12,"containerName":"_rnaAffected","name":"prelabel"},{"name":"$before","containerName":"_rnaAffected","kind":13,"line":1062},{"definition":"my","line":1063,"localvar":"my","kind":13,"containerName":"_rnaAffected","name":"$beforedist"},{"kind":13,"containerName":"_rnaAffected","name":"$after","line":1063},{"name":"$self","kind":13,"containerName":"_rnaAffected","line":1063},{"name":"mutation","kind":12,"containerName":"_rnaAffected","line":1063},{"line":1063,"containerName":"_rnaAffected","kind":12,"name":"postlabel"},{"containerName":"_rnaAffected","localvar":"my","kind":13,"name":"$intronvalue","line":1064,"definition":"my"},{"line":1064,"kind":13,"containerName":"_rnaAffected","name":"$i"},{"containerName":"_rnaAffected","kind":13,"name":"$afterdist","line":1065},{"containerName":"_rnaAffected","kind":13,"name":"$beforedist","line":1065},{"line":1066,"name":"$afterdist","containerName":"_rnaAffected","kind":13},{"kind":13,"containerName":"_rnaAffected","name":"$self","line":1067},{"line":1067,"kind":12,"containerName":"_rnaAffected","name":"dnamut"},{"line":1067,"kind":12,"containerName":"_rnaAffected","name":"region_value"},{"name":"$intronvalue","containerName":"_rnaAffected","kind":13,"line":1067},{"name":"$self","kind":13,"containerName":"_rnaAffected","line":1068},{"line":1068,"name":"dnamut","containerName":"_rnaAffected","kind":12},{"name":"region_dist","kind":12,"containerName":"_rnaAffected","line":1068},{"line":1068,"name":"$afterdist","containerName":"_rnaAffected","kind":13},{"line":1071,"name":"$self","kind":13,"containerName":"_rnaAffected"},{"line":1071,"containerName":"_rnaAffected","kind":12,"name":"dnamut"},{"line":1071,"containerName":"_rnaAffected","kind":12,"name":"region_value"},{"line":1071,"containerName":"_rnaAffected","kind":13,"name":"$intronvalue"},{"line":1072,"name":"$self","containerName":"_rnaAffected","kind":13},{"containerName":"_rnaAffected","kind":12,"name":"dnamut","line":1072},{"line":1072,"name":"region_dist","kind":12,"containerName":"_rnaAffected"},{"name":"$beforedist","kind":13,"containerName":"_rnaAffected","line":1072},{"name":"$self","kind":13,"containerName":"_rnaAffected","line":1075},{"name":"rnachange","containerName":"_rnaAffected","kind":12,"line":1075},{"containerName":"_rnaAffected","kind":13,"name":"$strand","line":1080},{"kind":13,"containerName":"_rnaAffected","name":"$exons","line":1081},{"containerName":"_rnaAffected","kind":13,"name":"$i","line":1081},{"name":"start","kind":12,"containerName":"_rnaAffected","line":1081},{"name":"$self","kind":13,"containerName":"_rnaAffected","line":1081},{"name":"mutation","kind":12,"containerName":"_rnaAffected","line":1081},{"line":1081,"name":"prelabel","containerName":"_rnaAffected","kind":12},{"line":1082,"name":"$exons","containerName":"_rnaAffected","kind":13},{"containerName":"_rnaAffected","kind":13,"name":"$i","line":1082},{"name":"end","containerName":"_rnaAffected","kind":12,"line":1082},{"line":1082,"name":"$self","kind":13,"containerName":"_rnaAffected"},{"line":1082,"kind":12,"containerName":"_rnaAffected","name":"mutation"},{"kind":12,"containerName":"_rnaAffected","name":"prelabel","line":1082},{"name":"$strand","kind":13,"containerName":"_rnaAffected","line":1083},{"line":1084,"containerName":"_rnaAffected","kind":13,"name":"$exons"},{"name":"$i","kind":13,"containerName":"_rnaAffected","line":1084},{"line":1084,"containerName":"_rnaAffected","kind":12,"name":"start"},{"name":"$self","containerName":"_rnaAffected","kind":13,"line":1084},{"kind":12,"containerName":"_rnaAffected","name":"mutation","line":1084},{"name":"postlabel","containerName":"_rnaAffected","kind":12,"line":1084},{"containerName":"_rnaAffected","kind":13,"name":"$exons","line":1085},{"line":1085,"containerName":"_rnaAffected","kind":13,"name":"$i"},{"name":"end","kind":12,"containerName":"_rnaAffected","line":1085},{"name":"$self","kind":13,"containerName":"_rnaAffected","line":1085},{"line":1085,"name":"mutation","kind":12,"containerName":"_rnaAffected"},{"line":1085,"kind":12,"containerName":"_rnaAffected","name":"postlabel"},{"containerName":"_rnaAffected","kind":13,"name":"$strand","line":1086},{"containerName":"_rnaAffected","kind":13,"name":"$exons","line":1087},{"kind":13,"containerName":"_rnaAffected","name":"$i","line":1087},{"name":"start","kind":12,"containerName":"_rnaAffected","line":1087},{"containerName":"_rnaAffected","kind":13,"name":"$self","line":1087},{"line":1087,"name":"mutation","kind":12,"containerName":"_rnaAffected"},{"line":1087,"name":"prelabel","kind":12,"containerName":"_rnaAffected"},{"line":1088,"containerName":"_rnaAffected","kind":13,"name":"$exons"},{"line":1088,"kind":13,"containerName":"_rnaAffected","name":"$i"},{"name":"end","containerName":"_rnaAffected","kind":12,"line":1088},{"line":1088,"kind":13,"containerName":"_rnaAffected","name":"$self"},{"name":"mutation","kind":12,"containerName":"_rnaAffected","line":1088},{"line":1088,"kind":12,"containerName":"_rnaAffected","name":"prelabel"},{"name":"$strand","containerName":"_rnaAffected","kind":13,"line":1089},{"name":"$exons","containerName":"_rnaAffected","kind":13,"line":1090},{"kind":13,"containerName":"_rnaAffected","name":"$i","line":1090},{"line":1090,"name":"start","kind":12,"containerName":"_rnaAffected"},{"containerName":"_rnaAffected","kind":13,"name":"$self","line":1090},{"name":"mutation","containerName":"_rnaAffected","kind":12,"line":1090},{"containerName":"_rnaAffected","kind":12,"name":"postlabel","line":1090},{"kind":13,"containerName":"_rnaAffected","name":"$exons","line":1091},{"line":1091,"kind":13,"containerName":"_rnaAffected","name":"$i"},{"name":"end","kind":12,"containerName":"_rnaAffected","line":1091},{"line":1091,"name":"$self","containerName":"_rnaAffected","kind":13},{"line":1091,"name":"mutation","kind":12,"containerName":"_rnaAffected"},{"line":1091,"name":"postlabel","containerName":"_rnaAffected","kind":12},{"line":1092,"name":"$rnaAffected","kind":13,"containerName":"_rnaAffected"},{"name":"$afterdist","containerName":"_rnaAffected","localvar":"my","kind":13,"line":1094,"definition":"my"},{"name":"$self","containerName":"_rnaAffected","kind":13,"line":1094},{"line":1094,"name":"mutation","containerName":"_rnaAffected","kind":12},{"name":"prelabel","containerName":"_rnaAffected","kind":12,"line":1094},{"line":1094,"containerName":"_rnaAffected","kind":13,"name":"$exons"},{"name":"$i","containerName":"_rnaAffected","kind":13,"line":1094},{"name":"start","kind":12,"containerName":"_rnaAffected","line":1094},{"line":1095,"kind":13,"localvar":"my","containerName":"_rnaAffected","name":"$beforedist","definition":"my"},{"containerName":"_rnaAffected","kind":13,"name":"$exons","line":1095},{"line":1095,"name":"$i","containerName":"_rnaAffected","kind":13},{"line":1095,"name":"end","kind":12,"containerName":"_rnaAffected"},{"line":1095,"name":"$self","containerName":"_rnaAffected","kind":13},{"kind":12,"containerName":"_rnaAffected","name":"mutation","line":1095},{"line":1095,"name":"postlabel","kind":12,"containerName":"_rnaAffected"},{"definition":"my","line":1096,"localvar":"my","kind":13,"containerName":"_rnaAffected","name":"$exonvalue"},{"line":1096,"containerName":"_rnaAffected","kind":13,"name":"$i"},{"containerName":"_rnaAffected","kind":13,"name":"$self","line":1097},{"line":1097,"name":"dnamut","containerName":"_rnaAffected","kind":12},{"line":1097,"kind":12,"containerName":"_rnaAffected","name":"region"},{"kind":13,"containerName":"_rnaAffected","name":"$afterdist","line":1098},{"name":"$beforedist","kind":13,"containerName":"_rnaAffected","line":1098},{"line":1099,"kind":13,"containerName":"_rnaAffected","name":"$afterdist"},{"containerName":"_rnaAffected","kind":13,"name":"$self","line":1100},{"kind":12,"containerName":"_rnaAffected","name":"dnamut","line":1100},{"line":1100,"containerName":"_rnaAffected","kind":12,"name":"region_value"},{"line":1100,"containerName":"_rnaAffected","kind":13,"name":"$exonvalue"},{"line":1101,"name":"$self","kind":13,"containerName":"_rnaAffected"},{"line":1101,"containerName":"_rnaAffected","kind":12,"name":"dnamut"},{"name":"region_dist","containerName":"_rnaAffected","kind":12,"line":1101},{"line":1101,"name":"$afterdist","containerName":"_rnaAffected","kind":13},{"kind":13,"containerName":"_rnaAffected","name":"$self","line":1105},{"line":1105,"name":"dnamut","kind":12,"containerName":"_rnaAffected"},{"line":1105,"name":"region_value","kind":12,"containerName":"_rnaAffected"},{"line":1105,"name":"$exonvalue","kind":13,"containerName":"_rnaAffected"},{"name":"$self","containerName":"_rnaAffected","kind":13,"line":1106},{"containerName":"_rnaAffected","kind":12,"name":"dnamut","line":1106},{"kind":12,"containerName":"_rnaAffected","name":"region_dist","line":1106},{"kind":13,"containerName":"_rnaAffected","name":"$beforedist","line":1106},{"line":1111,"containerName":"_rnaAffected","kind":13,"name":"$before"},{"line":1111,"name":"$exons","kind":13,"containerName":"_rnaAffected"},{"line":1111,"kind":13,"containerName":"_rnaAffected","name":"$i"},{"line":1111,"containerName":"_rnaAffected","kind":12,"name":"end"},{"line":1118,"name":"$rnaAffected","kind":13,"containerName":"_rnaAffected"}],"containerName":"main::","name":"_rnaAffected","definition":"sub","detail":"($self)","line":959,"kind":12,"range":{"start":{"character":0,"line":959},"end":{"character":9999,"line":1119}},"signature":{"parameters":[{"label":"$self"}],"documentation":"## Check if mutation propagates to RNA (and AA) level\n side effect: sets intron/exon information\n returns a boolean value","label":"_rnaAffected($self)"}},{"line":974,"kind":12,"name":"follows"},{"line":977,"name":"follows","kind":12},{"line":988,"name":"exons","kind":12},{"line":990,"name":"follows","kind":12},{"line":992,"name":"follows","kind":12},{"kind":12,"name":"follows","line":993},{"line":1050,"kind":12,"name":"exons"},{"kind":12,"range":{"end":{"line":1259,"character":9999},"start":{"character":0,"line":1146}},"line":1146,"signature":{"parameters":[{"label":"$self"},{"label":"$seqDiff"},{"label":"$dnamut"}],"documentation":"1;\n# $Id: Mutator.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::Mutator\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::Mutator - Package mutating LiveSequences\n\n=head1 SYNOPSIS\n\n  # $gene is a Bio::LiveSeq::Gene object\n  my $mutate = Bio::LiveSeq::Mutator->new('-gene' => $gene,\n  \t\t\t\t\t  '-numbering' => \"coding\"\n  \t\t\t\t\t   );\n  # $mut is a Bio::LiveSeq::Mutation object\n  $mutate->add_Mutation($mut);\n  # $results is a Bio::Variation::SeqDiff object\n  my $results=$mutate->change_gene();\n  if ($results) {\n      my $out = Bio::Variation::IO->new( '-format' => 'flat');\n      $out->write($results);\n  }\n\n=head1 DESCRIPTION\n\nThis class mutates Bio::LiveSeq::Gene objects and returns a\nBio::Variation::SeqDiff object. Mutations are described as\nBio::LiveSeq::Mutation objects. See L<Bio::LiveSeq::Gene>,\nL<Bio::Variation::SeqDiff>, and L<Bio::LiveSeq::Mutation> for details.\n\n=head1 FEEDBACK\n\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho & Joseph A.L. Insana\n\n  Email:  heikki-at-bioperl-dot-org\n          insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\n  The rest of the documentation details each of the object\n  methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::Mutator;\nuse strict;\n\nuse Bio::Variation::SeqDiff;\nuse Bio::Variation::DNAMutation;\nuse Bio::Variation::RNAChange;\nuse Bio::Variation::AAChange;\nuse Bio::Variation::Allele;\nuse Bio::LiveSeq::Mutation;\n\n#use integer;\n# Object preamble - inheritance\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n    my($class,@args) = @_;\n    my $self;\n    $self = {};\n    bless $self, $class;\n\n    my ($gene, $numbering) =\n\t    $self->_rearrange([qw(GENE\n\t\t\t\t  NUMBERING\n\t\t\t\t  )],\n\t\t\t      @args);\n\n    $self->{ 'mutations' } = [];\n\n    $gene && $self->gene($gene);\n    $numbering && $self->numbering($numbering);\n\n    #class constant;\n    $self->{'flanklen'} = 25;\n    return $self; # success - we hope!\n}\n\n=head2 gene\n\n Title   : gene\n Usage   : $mutobj = $obj->gene;\n         : $mutobj = $obj->gene($objref);\n Function:\n\n           Returns or sets the link-reference to a\n           Bio::LiveSeq::Gene object. If no value has ben set, it\n           will return undef\n\n Returns : an object reference  or undef\n Args    : a Bio::LiveSeq::Gene\n\nSee L<Bio::LiveSeq::Gene> for more information.\n\n\nsub gene {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Gene') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::Gene object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'gene'} = $value;\n      }\n  }\n  unless (exists $self->{'gene'}) {\n      return;\n  } else {\n      return $self->{'gene'};\n  }\n}\n\n\n=head2 numbering\n\n Title   : numbering\n Usage   : $obj->numbering();\n Function:\n\n            Sets and returns coordinate system used in positioning the\n            mutations. See L<change_gene> for details.\n\n Example :\n Returns : string\n Args    : string (coding [transcript number] | gene | entry)\n\n\n\nsub numbering {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif ($value =~ /(coding)( )?(\\d+)?/ or $value eq 'entry' or $value eq 'gene') {\n\t    $self->{'numbering'} = $value;\n\t} else { # defaulting to 'coding'\n\t    $self->{'numbering'} = 'coding';\n\t}\n    }\n    unless (exists $self->{'numbering'}) {\n\treturn 'coding';\n    } else {\n\treturn $self->{'numbering'};\n    }\n}\n\n=head2 add_Mutation\n\n Title   : add_Mutation\n Usage   : $self->add_Mutation($ref)\n Function: adds a Bio::LiveSeq::Mutation object\n Example :\n Returns :\n Args    : a Bio::LiveSeq::Mutation\n\nSee L<Bio::LiveSeq::Mutation> for more information.\n\n\nsub add_Mutation{\n    my ($self,$value) = @_;\n    if( $value->isa('Bio::Liveseq::Mutation') ) {\n\tmy $com = ref $value;\n\t$self->throw(\"Is not a Mutation object but a [$com]\" );\n\treturn;\n    }\n    if (! $value->pos) {\n\t$self->warn(\"No value for mutation position in the sequence!\");\n\treturn;\n    }\n    if (! $value->seq && ! $value->len) {\n\t$self->warn(\"Either mutated sequence or length of the deletion must be given!\");\n\treturn;\n    }\n    push(@{$self->{'mutations'}},$value);\n}\n\n=head2 each_Mutation\n\n Title   : each_Mutation\n Usage   : foreach $ref ( $a->each_Mutation )\n Function: gets an array of Bio::LiveSeq::Mutation objects\n Example :\n Returns : array of Mutations\n Args    :\n\nSee L<Bio::LiveSeq::Mutation> for more information.\n\n\nsub each_Mutation{\n   my ($self) = @_;\n   return @{$self->{'mutations'}};\n}\n\n\n=head2 mutation\n\n Title   : mutation\n Usage   : $mutobj = $obj->mutation;\n         : $mutobj = $obj->mutation($objref);\n Function:\n\n           Returns or sets the link-reference to the current mutation\n           object.  If the value is not set, it will return undef.\n           Internal method.\n\n Returns : an object reference  or undef\n\n\n\nsub mutation {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Mutation') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::Mutation object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'mutation'} = $value;\n      }\n  }\n  unless (exists $self->{'mutation'}) {\n      return;\n  } else {\n      return $self->{'mutation'};\n  }\n}\n\n=head2 DNA\n\n Title   : DNA\n Usage   : $mutobj = $obj->DNA;\n         : $mutobj = $obj->DNA($objref);\n Function:\n\n           Returns or sets the reference to the LiveSeq object holding\n           the reference sequence. If there is no link, it will return\n           undef.\n           Internal method.\n\n Returns : an object reference or undef\n\n\nsub DNA {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::DNA') and ! $value->isa('Bio::LiveSeq::Transcript') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::DNA/Transcript object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'DNA'} = $value;\n      }\n  }\n  unless (exists $self->{'DNA'}) {\n      return;\n  } else {\n      return $self->{'DNA'};\n  }\n}\n\n\n=head2 RNA\n\n Title   : RNA\n Usage   : $mutobj = $obj->RNA;\n         : $mutobj = $obj->RNA($objref);\n Function:\n\n           Returns or sets the reference to the LiveSeq object holding\n           the reference sequence. If the value is not set, it will return\n           undef.\n           Internal method.\n\n Returns : an object reference  or undef\n\n\n\nsub RNA {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Transcript') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::RNA/Transcript object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'RNA'} = $value;\n      }\n  }\n  unless (exists $self->{'RNA'}) {\n      return;\n  } else {\n      return $self->{'RNA'};\n  }\n}\n\n\n=head2 dnamut\n\n Title   : dnamut\n Usage   : $mutobj = $obj->dnamut;\n         : $mutobj = $obj->dnamut($objref);\n Function:\n\n           Returns or sets the reference to the current DNAMutation object.\n           If the value is not set, it will return undef.\n           Internal method.\n\n Returns : a Bio::Variation::DNAMutation object or undef\n\nSee L<Bio::Variation::DNAMutation> for more information.\n\n\n\nsub dnamut {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::DNAMutation') ) {\n\t  $self->throw(\"Is not a Bio::Variation::DNAMutation object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'dnamut'} = $value;\n      }\n  }\n  unless (exists $self->{'dnamut'}) {\n      return;\n  } else {\n      return $self->{'dnamut'};\n  }\n}\n\n\n=head2 rnachange\n\n Title   : rnachange\n Usage   : $mutobj = $obj->rnachange;\n         : $mutobj = $obj->rnachange($objref);\n Function:\n\n           Returns or sets the reference to the current RNAChange object.\n           If the value is not set, it will return undef.\n           Internal method.\n\n Returns : a Bio::Variation::RNAChange object or undef\n\nSee L<Bio::Variation::RNAChange> for more information.\n\n\n\nsub rnachange {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::RNAChange') ) {\n\t  $self->throw(\"Is not a Bio::Variation::RNAChange object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'rnachange'} = $value;\n      }\n  }\n  unless (exists $self->{'rnachange'}) {\n      return;\n  } else {\n      return $self->{'rnachange'};\n  }\n}\n\n\n=head2 aachange\n\n Title   : aachange\n Usage   : $mutobj = $obj->aachange;\n         : $mutobj = $obj->aachange($objref);\n Function:\n\n           Returns or sets the reference to the current AAChange object.\n           If the value is not set, it will return undef.\n           Internal method.\n\n Returns : a Bio::Variation::AAChange object or undef\n\nSee L<Bio::Variation::AAChange> for more information.\n\n\n\nsub aachange {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::AAChange') ) {\n\t  $self->throw(\"Is not a Bio::Variation::AAChange object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'aachange'} = $value;\n      }\n  }\n  unless (exists $self->{'aachange'}) {\n      return;\n  } else {\n      return $self->{'aachange'};\n  }\n}\n\n\n=head2 exons\n\n Title   : exons\n Usage   : $mutobj = $obj->exons;\n         : $mutobj = $obj->exons($objref);\n Function:\n\n           Returns or sets the reference to a current array of Exons.\n           If the value is not set, it will return undef.\n           Internal method.\n\n Returns : an array of Bio::LiveSeq::Exon objects or undef\n\nSee L<Bio::LiveSeq::Exon> for more information.\n\n\n\nsub exons {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      $self->{'exons'} = $value;\n  }\n  unless (exists $self->{'exons'}) {\n      return;\n  } else {\n      return $self->{'exons'};\n  }\n}\n\n=head2 change_gene_with_alignment\n\n Title   : change_gene_with_alignment\n Usage   : $results=$mutate->change_gene_with_alignment($aln);\n\n Function:\n\n           Returns a Bio::Variation::SeqDiff object containing the\n           results of the changes in the alignment. The alignment has\n           to be pairwise and have one sequence named 'QUERY', the\n           other one is assumed to be a part of the sequence from\n           $gene.\n\n           This method offers a shortcut to change_gene and\n           automates the creation of Bio::LiveSeq::Mutation objects.\n           Use it with almost identical sequnces, e.g. to locate a SNP.\n\n Args    : Bio::SimpleAlign object representing a short local alignment\n Returns : Bio::Variation::SeqDiff object or 0 on error\n\nSee L<Bio::LiveSeq::Mutation>, L<Bio::SimpleAlign>, and\nL<Bio::Variation::SeqDiff>  for more information.\n\n\nsub change_gene_with_alignment {\n    my ($self, $aln) = @_;\n\n    #\n    # Sanity checks\n    #\n\n    $self->throw(\"Argument is not a Bio::SimpleAlign object but a [$aln]\")\n\tunless $aln->isa('Bio::SimpleAlign');\n    $self->throw(\"'Pairwise alignments only, please\") \n\tif $aln->no_sequences != 2;\n\n    # find out the order the two sequences are given\n    my $queryseq_pos = 1; #default\n    my $refseq_pos = 2;\n    unless ($aln->get_seq_by_pos(1)->id eq 'QUERY') {\n\tcarp('Query sequence has to be named QUERY') \n\t    if $aln->get_seq_by_pos(2)->id ne 'QUERY';\n\t$queryseq_pos = 2; # alternative\n\t$refseq_pos = 1;\n    }\n\n    # trim the alignment\n    my $start =  $aln->column_from_residue_number('QUERY', 1);\n    my $end =  $aln->column_from_residue_number('QUERY', \n\t\t\t\t\t\t$aln->get_seq_by_pos($queryseq_pos)->end );\n    \n    my $aln2 = $aln->slice($start, $end);\n\n    #\n    # extracting mutations\n    #\n\n    my $cs = $aln2->consensus_string(51);\n    my $queryseq = $aln2->get_seq_by_pos($queryseq_pos);\n    my $refseq = $aln2->get_seq_by_pos($refseq_pos);\n\n    while ( $cs =~ /(\\?+)/g) {\n\t# pos in local coordinates\n\tmy $pos = pos($cs) - length($1) + 1;\n\tmy $mutation = create_mutation($self, \n\t\t\t\t       $refseq, \n\t\t\t\t       $queryseq, \n\t\t\t\t       $pos, \n\t\t\t\t       CORE::length($1)\n\t\t\t\t       );\n\t# reset pos to refseq coordinates\n\t$pos +=  $refseq->start - 1;\n\t$mutation->pos($pos);\n\n        $self->add_Mutation($mutation);\n    }\n    return $self->change_gene();\n}\n\n=head2 create_mutation\n\n Title   : create_mutation\n Usage   : \n Function:\n\n           Formats sequence differences from two sequences into\n           Bio::LiveSeq::Mutation objects which can be applied to a\n           gene.\n\n           To keep it generic, sequence arguments need not to be\n           Bio::LocatableSeq. Coordinate change to parent sequence\n           numbering needs to be done by the calling code.\n\n           Called from change_gene_with_alignment\n\n Args    : Bio::PrimarySeqI inheriting object for the reference sequence\n           Bio::PrimarySeqI inheriting object for the query sequence\n           integer for the start position of the local sequence difference\n           integer for the length of the sequence difference\n Returns : Bio::LiveSeq::Mutation object \n\n\nsub create_mutation {\n    my ($self, $refseq, $queryseq, $pos, $len) = @_;\n    \n    $self->throw(\"Is not a Bio::PrimarySeqI object but a [$refseq]\") \n\tunless $refseq->isa('Bio::PrimarySeqI');\n    $self->throw(\"Is not a Bio::PrimarySeqI object but a [$queryseq]\") \n\tunless $queryseq->isa('Bio::PrimarySeqI');\n    $self->throw(\"Position is not a positive integer but [$pos]\") \n\tunless $pos =~ /^\\+?\\d+$/;\n    $self->throw(\"Length is not a positive integer but [$len]\") \n\tunless $len =~ /^\\+?\\d+$/;\n\n    my $mutation;\n    my $refstring = $refseq->subseq($pos, $pos + $len - 1);\n    my $varstring = $queryseq->subseq($pos, $pos + $len - 1);\n    \n    if ($len == 1 and $refstring =~ /[^\\.\\-\\*\\?]/ and \n\t$varstring  =~ /[^\\.\\-\\*\\?]/ ) { #point\n\t$mutation = Bio::LiveSeq::Mutation->new(-seq => $varstring,\n\t\t\t\t\t\t-pos => $pos,\n\t\t\t\t\t\t);\n    }\n    elsif ( $refstring =~ /^[^\\.\\-\\*\\?]+$/ and \n\t    $varstring  !~ /^[^\\.\\-\\*\\?]+$/ ) { # deletion\n\t$mutation = Bio::LiveSeq::Mutation->new(-pos => $pos,\n\t\t\t\t\t\t-len => $len\n\t\t\t\t\t\t);\n    }\n    elsif ( $refstring !~ /^[^\\.\\-\\*\\?]+$/ and \n\t    $varstring  =~ /^[^\\.\\-\\*\\?]+$/ ) { # insertion\n\t$mutation = Bio::LiveSeq::Mutation->new(-seq => $varstring,\n\t\t\t\t\t\t-pos => $pos,\n\t\t\t\t\t\t-len => 0\n\t\t\t\t\t\t);\n    } else { # complex\n\t$mutation = Bio::LiveSeq::Mutation->new(-seq => $varstring,\n\t\t\t\t\t\t-pos => $pos,\n\t\t\t\t\t\t-len => $len\n\t\t\t\t\t\t);\n    }\n    \n    return $mutation;\n}\n\n=head2 change_gene\n\n Title   : change_gene\n Usage   : my $mutate = Bio::LiveSeq::Mutator->new(-gene => $gene,\n\t\t\t\t\t\t   numbering => \"coding\"\n\t\t\t\t\t\t   );\n           # $mut is Bio::LiveSeq::Mutation object\n           $mutate->add_Mutation($mut);\n           my $results=$mutate->change_gene();\n\n Function:\n\n           Returns a Bio::Variation::SeqDiff object containing the\n           results of the changes performed according to the\n           instructions present in Mutation(s).  The -numbering\n           argument decides what molecule is being changed and what\n           numbering scheme being used:\n\n            -numbering => \"entry\"\n\n               determines the DNA level, using the numbering from the\n               beginning of the sequence\n\n            -numbering => \"coding\"\n\n               determines the RNA level, using the numbering from the\n               beginning of the 1st transcript\n\n               Alternative transcripts can be used by specifying\n               \"coding 2\" or \"coding 3\" ...\n\n            -numbering => \"gene\"\n\n               determines the DNA level, using the numbering from the\n               beginning of the 1st transcript and inluding introns.\n               The meaning equals 'coding' if the reference molecule\n               is cDNA.\n\n Args    : Bio::LiveSeq::Gene object\n           Bio::LiveSeq::Mutation object(s)\n           string specifying a numbering scheme (defaults to 'coding')\n Returns : Bio::Variation::SeqDiff object or 0 on error\n\n\nsub change_gene {\n    my ($self) = @_;\n\n    #\n    # Sanity check\n    #\n    unless ($self->gene) {\n\t$self->warn(\"Input object Bio::LiveSeq::Gene is not given\");\n\treturn 0;\n    }\n    #\n    # Setting the reference sequence based on -numbering\n    #\n    my @transcripts=@{$self->gene->get_Transcripts};\n    my $refseq; # will hold Bio::LiveSeq:Transcript object or Bio::LiveSeq::DNA\n\n    # 'gene' eq 'coding' if reference sequence is cDNA\n    $self->numbering ('coding') if $self->gene->get_DNA->alphabet eq 'rna' and $self->numbering eq 'gene';\n\n    if ($self->numbering =~ /(coding)( )?(\\d+)?/ ) {\n\t$self->numbering($1);\n\tmy $transnumber = $3;\n\t$transnumber-- if $3; # 1 -> 0, 2 -> 1\n\tif ($transnumber && $transnumber >= 0 && $transnumber <= $#transcripts) {\n\t    $refseq=$transcripts[$transnumber];\n\t} else {\n\t    $transnumber && $self->warn(\"The alternative transcript number \". $transnumber+1 .\n\t    \"- does not exist. Reverting to the 1st transcript\\n\");\n\t    $refseq=$transcripts[0];\n\t}\n    } else {\n\t$refseq=$transcripts[0]->{'seq'};\n    }\n    #\n    # Recording the state: SeqDiff object creation  ?? transcript no.??\n    #\n    my $seqDiff = Bio::Variation::SeqDiff->new(-verbose => $self->verbose);\n    $seqDiff->alphabet($self->gene->get_DNA->alphabet);\n    $seqDiff->numbering($self->numbering);\n    my ($DNAobj, $RNAobj);\n    if ($refseq->isa(\"Bio::LiveSeq::Transcript\")) {\n\t$self->RNA($refseq);\n\t$self->DNA($refseq->{'seq'});\n\t$seqDiff->rna_ori($refseq->seq );\n\t$seqDiff->aa_ori($refseq->get_Translation->seq);\n    } else {\n\t$self->DNA($refseq);\n\t$self->RNA($transcripts[0]);\n\t$seqDiff->rna_ori($self->RNA->seq);\n\t$seqDiff->aa_ori($self->RNA->get_Translation->seq);\n    }\n    $seqDiff->dna_ori($self->DNA->seq);\n    # put the accession number into the SeqDiff object ID\n    $seqDiff->id($self->DNA->accession_number);\n\n    # the atg_offset takes in account that DNA object could be a subset of the\n    # whole entry (via the light_weight loader)\n    my $atg_label=$self->RNA->start;\n    my $atg_offset=$self->DNA->position($atg_label)+($self->DNA->start)-1;\n    $seqDiff->offset($atg_offset - 1);\n    $self->DNA->coordinate_start($atg_label);\n\n    my @exons = $self->RNA->all_Exons;\n    $seqDiff->cds_end($exons[$#exons]->end);\n\n    #\n    # Converting mutation positions to labels\n    #\n    $self->warn(\"no mutations\"), return 0 \n\tunless $self->_mutationpos2label($refseq, $seqDiff);\n\n    # need to add more than one rna & aa\n    #foreach $transcript (@transcripts) {\n    #  $seqDiff{\"ori_transcript_${i}_seq\"}=$transcript->seq;\n    #  $seqDiff{\"ori_translation_${i}_seq\"}=$transcript->get_Translation->seq;\n    #}\n\n    # do changes\n    my $k;\n    foreach my $mutation ($self->each_Mutation) {\n\tnext unless $mutation->label > 0;\n\t$self->mutation($mutation);\n\n\t$mutation->issue(++$k);\n\t#\n\t# current position on the transcript\n\t#\n\tif ($self->numbering =~ /coding/) {\n\t    $mutation->transpos($mutation->pos); # transpos given by user\n\t} else {\n\t    #transpos of label / It will be 0 if mutating an intron, negative if upstream of ATG\n\t    $mutation->transpos($self->RNA->position($mutation->label,$atg_label));\n\t}\n\t#\n\t# Calculate adjacent labels based on the position on the current sequence\n\t#\n\t$mutation->prelabel($self->DNA->label(-1, $mutation->label)); # 1 before label\n\tif ($mutation->len == 0) {\n\t    $mutation->postlabel($mutation->label);\n\t    $mutation->lastlabel($mutation->label);\n\t} elsif ($mutation->len == 1) {\n\t    $mutation->lastlabel($mutation->label); # last nucleotide affected\n\t    $mutation->postlabel($self->DNA->label(2,$mutation->lastlabel)); # $len after label\n\t} else {\n\t    $mutation->lastlabel($self->DNA->label($mutation->len,$mutation->label));\n\t    $mutation->postlabel($self->DNA->label(2,$mutation->lastlabel));\n\t}\n\tmy $dnamut = $self->_set_DNAMutation($seqDiff);\n\t#\n\t#\n\t#\n\tif ($self->_rnaAffected) {\n\t    $self->_set_effects($seqDiff, $dnamut);\n\t}\n\telsif ($seqDiff->offset != 0 and $dnamut->region ne 'intron') {\n\t    $self->_untranslated ($seqDiff, $dnamut);\n\t} else {\n\t    #$self->warn(\"Mutation starts outside coding region, RNAChange object not created\");\n\t}\n\n\t#########################################################################\n\t# Mutations are done here!                                              #\n\t$refseq->labelchange($mutation->seq, $mutation->label, $mutation->len); #\n\t#########################################################################\n\n\t$self->_post_mutation ($seqDiff);\n\n\t$self->dnamut(undef);\n\t$self->rnachange(undef);\n\t$self->aachange(undef);\n\t$self->exons(undef);\n    }\n    # record the final state of all three sequences\n    $seqDiff->dna_mut($self->DNA->seq);\n    $seqDiff->rna_mut($self->RNA->seq);\n    if ($refseq->isa(\"Bio::LiveSeq::Transcript\")) {\n\t$seqDiff->aa_mut($refseq->get_Translation->seq);\n    } else {\n\t$seqDiff->aa_mut($self->RNA->get_Translation->seq);\n    }\n\n    #$seqDiff{mut_dna_seq}=$gene->get_DNA->seq;\n    #my $i=1;\n    #foreach $transcript (@transcripts) {\n    #  $seqDiff{\"mut_transcript_${i}_seq\"}=$transcript->seq;\n    #  $seqDiff{\"mut_translation_${i}_seq\"}=$transcript->get_Translation->seq;\n    #}\n    return $seqDiff;\n}\n\n=head2 _mutationpos2label\n\n Title   : _mutationpos2label\n Usage   :\n Function: converts mutation positions into labels\n Example :\n Returns : number of valid mutations\n Args    : LiveSeq sequence object\n\n\nsub _mutationpos2label {\n    my ($self, $refseq, $SeqDiff) = @_;\n    my $count;\n    my @bb = @{$self->{'mutations'}};\n    my $cc = scalar @bb;\n    foreach my $mut (@{$self->{'mutations'}}) {\n#\t if ($self->numbering eq 'gene' and $mut->pos < 1) {\n#\t     my $tmp = $mut->pos;\n#\t     print STDERR \"pos: \", \"$tmp\\n\";\n#\t     $tmp++ if $tmp < 1;\n#\t     $tmp += $SeqDiff->offset;\n#\t     print STDERR \"pos2: \", \"$tmp\\n\";\n#\t     $mut->pos($tmp);\n#\t }\n#\telsif ($self->numbering eq 'entry') {\n\tif ($self->numbering eq 'entry') {\n\t    my $tmp = $mut->pos;\n\t    $tmp -= $SeqDiff->offset;\n\t    $tmp-- if $tmp < 1;\n\t    $mut->pos($tmp);\n\t}\n\n\tmy $label = $refseq->label($mut->pos); # get the label for the position\n\t$mut->label($label), $count++ if $label > 0 ;\n\t#print STDERR \"x\", $mut->pos,'|' ,$mut->label, \"\\n\";\n    }\n    return $count;\n}\n\n#\n# Calculate labels around mutated nucleotide\n#\n\n=head2 _set_DNAMutation\n\n Title   : _set_DNAMutation\n Usage   :\n Function:\n\n           Stores DNA level mutation attributes before mutation into\n           Bio::Variation::DNAMutation object.  Links it to SeqDiff\n           object.\n\n Example :\n Returns : Bio::Variation::DNAMutation object\n Args    : Bio::Variation::SeqDiff object\n\nSee L<Bio::Variation::DNAMutation> and L<Bio::Variation::SeqDiff>.\n\n\nsub _set_DNAMutation {\n    my ($self, $seqDiff) = @_;\n\n    my $dnamut_start = $self->mutation->label - $seqDiff->offset;\n    # if negative DNA positions (before ATG)\n    $dnamut_start-- if $dnamut_start <= 0;\n    my $dnamut_end;\n    ($self->mutation->len == 0 or $self->mutation->len == 1) ?\n\t($dnamut_end = $dnamut_start) :\n\t($dnamut_end = $dnamut_start+$self->mutation->len);\n    #print \"start:$dnamut_start, end:$dnamut_end\\n\";\n    my $dnamut = Bio::Variation::DNAMutation->new(-start => $dnamut_start,\n\t\t\t\t\t\t  -end => $dnamut_end,\n\t\t\t\t\t\t  );\n    $dnamut->mut_number($self->mutation->issue);\n    $dnamut->isMutation(1);\n    my $da_m = Bio::Variation::Allele->new;\n    $da_m->seq($self->mutation->seq) if $self->mutation->seq;\n    $dnamut->allele_mut($da_m);\n    $dnamut->add_Allele($da_m);\n    # allele_ori\n    my $allele_ori = $self->DNA->labelsubseq($self->mutation->prelabel,\n\t\t\t\t\t     undef,\n\t\t\t\t\t     $self->mutation->postlabel); # get seq\n    chop $allele_ori; # chop the postlabel nucleotide\n    $allele_ori=substr($allele_ori,1); # away the prelabel nucleotide\n    my $da_o = Bio::Variation::Allele->new;\n    $da_o->seq($allele_ori) if $allele_ori;\n    $dnamut->allele_ori($da_o);\n    ($self->mutation->len == 0) ?\n\t($dnamut->length($self->mutation->len)) : ($dnamut->length(CORE::length $allele_ori));\n    #print \" --------------- $dnamut_start -$len-  $dnamut_end -\\n\";\n    $seqDiff->add_Variant($dnamut);\n    $self->dnamut($dnamut);\n    $dnamut->mut_number($self->mutation->issue);\n    # setting proof\n    if ($seqDiff->numbering eq \"entry\" or $seqDiff->numbering eq \"gene\") {\n\t $dnamut->proof('experimental');\n    } else {\n\t $dnamut->proof('computed');\n    }\n    # how many nucleotides to store upstream and downstream of the change\n    my $flanklen = $self->{'flanklen'};\n    #print  `date`, \" flanking sequences start\\n\";\n    my $uplabel = $self->DNA->label(1-$flanklen,$self->mutation->prelabel); # this could be unavailable!\n\n    my $upstreamseq;\n    if ($uplabel > 0) {\n\t $upstreamseq =\n\t     $self->DNA->labelsubseq($uplabel, undef, $self->mutation->prelabel);\n    } else { # from start (less than $flanklen nucleotides)\n\t $upstreamseq =\n\t     $self->DNA->labelsubseq($self->DNA->start, undef, $self->mutation->prelabel);\n    }\n    $dnamut->upStreamSeq($upstreamseq);\n    my $dnstreamseq = $self->DNA->labelsubseq($self->mutation->postlabel, $flanklen);\n    $dnamut->dnStreamSeq($dnstreamseq); # $flanklen or less nucleotides\n    return $dnamut;\n}\n\n\n#\n### Check if mutation propagates to RNA (and AA) level\n#  \n# side effect: sets intron/exon information\n# returns a boolean value\n#\n\nsub _rnaAffected {\n    my ($self) = @_;\n    my @exons=$self->RNA->all_Exons;\n    my $RNAstart=$self->RNA->start;\n    my $RNAend=$self->RNA->end;\n    my ($firstexon,$before,$after,$i);\n    my ($rnaAffected) = 0;\n\n    # check for inserted labels (that require follows instead of <,>)\n    my $DNAend=$self->RNA->{'seq'}->end;\n    if ($self->mutation->prelabel > $DNAend or $self->mutation->postlabel > $DNAend) {\n\t #this means one of the two labels is an inserted one\n\t #(coming from a previous mutation. This would falsify all <,>\n\t #checks, so the follow() has to be used\n\t $self->warn(\"Attention, workaround not fully tested yet! Expect unpredictable results.\\n\");\n\t if (($self->mutation->postlabel==$RNAstart) or (follows($self->mutation->postlabel,$RNAstart))) {\n\t     $self->warn(\"RNA not affected because change occurs before RNAstart\");\n\t }\n\t elsif (($RNAend==$self->mutation->prelabel) or (follows($RNAend,$self->mutation->prelabel))) {\n\t     $self->warn(\"RNA not affected because change occurs after RNAend\");\n\t }\n\t elsif (scalar @exons == 1) {\n\t     #no introns, just one exon\n\t     $rnaAffected = 1; # then RNA is affected!\n\t } else {\n\t     # otherwise check for change occurring inside an intron\n\t     $firstexon=shift(@exons);\n\t     $before=$firstexon->end;\n\t\n\t     foreach $i (0..$#exons) {\n\t\t $after=$exons[$i]->start;\n\t\t if (follows($self->mutation->prelabel,$before) or\n\t\t\t($after==$self->mutation->prelabel) or\n\t\t\tfollows($after,$self->mutation->prelabel) or\n\t\t\tfollows($after,$self->mutation->postlabel)) {\n\n\t\t     $rnaAffected = 1;\n\t\t     # $i is number of exon and can be used for proximity check\n\t\t }\n\t\t $before=$exons[$i]->end;\n\t     }\n\t\n\t }\n    } else {\n\tmy $strand = $exons[0]->strand;\n\tif (($strand == 1 and $self->mutation->postlabel <= $RNAstart) or\n\t    ($strand != 1 and $self->mutation->postlabel >= $RNAstart)) {\n\t    #$self->warn(\"RNA not affected because change occurs before RNAstart\");\n\t    $rnaAffected = 0;\n\t}\n\telsif (($strand == 1 and $self->mutation->prelabel >= $RNAend) or\n\t\t($strand != 1 and $self->mutation->prelabel <= $RNAend)) {\n\t     #$self->warn(\"RNA not affected because change occurs after RNAend\");\n\t     $rnaAffected = 0;\n\t     my $dist;\n\t     if ($strand == 1){\n\t\t $dist = $self->mutation->prelabel - $RNAend;\n\t     } else {\n\t\t $dist = $RNAend - $self->mutation->prelabel;\n\t     }\n\t     $self->dnamut->region_dist($dist);\n\t }\n\t elsif (scalar @exons == 1) {\n\t     #if just one exon -> no introns, \n\t     $rnaAffected = 1; # then RNA is affected!\n\t } else {\t\n\t     # otherwise check for mutation occurring inside an intron\n\t     $firstexon=shift(@exons);\n\t     $before=$firstexon->end;\n\t     if ( ($strand == 1 and $self->mutation->prelabel < $before) or \n\t\t  ($strand == -1 and $self->mutation->prelabel > $before) \n\t\t  ) {\n\t\t $rnaAffected = 1 ;\n\n\t\t #print \"Exon 1 : \", $firstexon->start, \" - \", $firstexon->end, \"<br>\\n\";\n\t\t my $afterdist = $self->mutation->prelabel - $firstexon->start;\n\t\t my $beforedist =  $firstexon->end - $self->mutation->postlabel;\n\t\t my $exonvalue = $i + 1;\n\t\t $self->dnamut->region('exon');\n\t\t $self->dnamut->region_value($exonvalue);\n\t\t if ($afterdist < $beforedist) {\n\t\t     $afterdist++; \t\t  \n\t\t     $afterdist++;\n\t\t     $self->dnamut->region_dist($afterdist);\n\t\t     #print \"splice site $afterdist nt upstream!<br>\";\n\t\t } else {\n\t\t     $self->dnamut->region_dist($beforedist);\n\t\t     #print \"splice site $beforedist nt downstream!<br>\";\n\t\t }\n\t     } else {\n\t\t #print \"first exon  : \", $firstexon->start, \" - \", $firstexon->end, \"<br>\\n\";\n\t\t foreach $i (0..$#exons) {\n\t\t     $after=$exons[$i]->start;\n\t\t     #proximity test for intronic mutations\n\t\t     if ( ($strand == 1 and \n\t\t\t   $self->mutation->prelabel >=  $before and \n\t\t\t   $self->mutation->postlabel <= $after) \n\t\t\t  or\n\t\t\t  ($strand == -1 and \n\t\t\t   $self->mutation->prelabel <=  $before and \n\t\t\t   $self->mutation->postlabel >= $after)  ) {\n\t\t\t $self->dnamut->region('intron');\n\t\t\t #$self->dnamut->region_value($i);\n\t\t\t my $afterdist = $self->mutation->prelabel - $before;\n\t\t\t my $beforedist =  $after - $self->mutation->postlabel;\n\t\t\t my $intronvalue = $i + 1;\n\t\t\t if ($afterdist < $beforedist) {\n\t\t\t     $afterdist++;\n\t\t\t     $self->dnamut->region_value($intronvalue);\n\t\t\t     $self->dnamut->region_dist($afterdist);\n\t\t\t     #print \"splice site $afterdist nt upstream!<br>\";\n\t\t\t } else {\n\t\t\t     $self->dnamut->region_value($intronvalue);\n\t\t\t     $self->dnamut->region_dist($beforedist * -1);\n\t\t\t     #print \"splice site $beforedist nt downstream!<br>\";\n\t\t\t }\n\t\t\t $self->rnachange(undef);\n\t\t\t last;\n\t\t     } \n\t\t     #proximity test for exon mutations\n\t\t     #proximity test for exon mutations\n\t\t     elsif ( ( $strand == 1 and \n\t\t\t       $exons[$i]->start < $self->mutation->prelabel and \n\t\t\t       $exons[$i]->end > $self->mutation->prelabel) or \n\t\t\t     ( $strand == 1 and \n\t\t\t       $exons[$i]->start < $self->mutation->postlabel and \n\t\t\t       $exons[$i]->end > $self->mutation->postlabel) or \n\t\t\t     ( $strand == -1 and \n\t\t\t       $exons[$i]->start > $self->mutation->prelabel and \n\t\t\t       $exons[$i]->end < $self->mutation->prelabel) or\n\t\t\t     ( $strand == -1 and \n\t\t\t       $exons[$i]->start > $self->mutation->postlabel and \n\t\t\t       $exons[$i]->end < $self->mutation->postlabel) ) {\n\t\t\t $rnaAffected = 1;\n\n\t\t\t my $afterdist = $self->mutation->prelabel - $exons[$i]->start;\n\t\t\t my $beforedist =  $exons[$i]->end - $self->mutation->postlabel;\n\t\t\t my $exonvalue = $i + 1;\n\t\t\t $self->dnamut->region('exon');\n\t\t\t if ($afterdist < $beforedist) {\n\t\t\t     $afterdist++;\n\t\t\t     $self->dnamut->region_value($exonvalue+1);\n\t\t\t     $self->dnamut->region_dist($afterdist);\n\t\t\t     #print \"splice site $afterdist nt upstream!<br>\";\n\t\t\t } else {\n\t\t\t     #$beforedist;\n\t\t\t     $self->dnamut->region_value($exonvalue+1);\n\t\t\t     $self->dnamut->region_dist($beforedist * -1);\n\t\t\t     #print \"splice site $beforedist nt downstream!<br>\";\n\t\t\t }\n\t\t\t last;\n\t\t     }\n\t\t     $before=$exons[$i]->end;\n\t\t }\n\t     }\n\t }\n     }\n    #$self->warn(\"RNA not affected because change occurs inside an intron\");\n    #return(0); # if still not returned, then not affected, return 0\n    return $rnaAffected;\n}\n\n#\n# ### Creation of RNA and AA variation objects\n#\n\n=head2 _set_effects\n\n Title   : _set_effects\n Usage   :\n Function:\n\n           Stores RNA and AA level mutation attributes before mutation\n           into Bio::Variation::RNAChange and\n           Bio::Variation::AAChange objects.  Links them to\n           SeqDiff object.\n\n Example :\n Returns :\n Args    : Bio::Variation::SeqDiff object\n           Bio::Variation::DNAMutation object\n\nSee L<Bio::Variation::RNAChange>, L<Bio::Variation::RNAChange>,\nL<Bio::Variation::SeqDiff>, and L<Bio::Variation::DNAMutation>.","label":"_set_effects($self,$seqDiff,$dnamut)"},"containerName":"main::","name":"_set_effects","children":[{"definition":"my","line":1147,"kind":13,"localvar":"my","containerName":"_set_effects","name":"$self"},{"containerName":"_set_effects","kind":13,"name":"$seqDiff","line":1147},{"containerName":"_set_effects","kind":13,"name":"$dnamut","line":1147},{"definition":"my","line":1148,"containerName":"_set_effects","localvar":"my","kind":13,"name":"$rnapos_end"},{"kind":13,"containerName":"_set_effects","name":"$upstreamseq","line":1148},{"kind":13,"containerName":"_set_effects","name":"$dnstreamseq","line":1148},{"definition":"my","line":1149,"containerName":"_set_effects","localvar":"my","kind":13,"name":"$flanklen"},{"line":1149,"containerName":"_set_effects","kind":13,"name":"$self"},{"kind":13,"containerName":"_set_effects","name":"$self","line":1151},{"name":"mutation","containerName":"_set_effects","kind":12,"line":1151},{"kind":12,"containerName":"_set_effects","name":"len","line":1151},{"line":1152,"containerName":"_set_effects","kind":13,"name":"$rnapos_end"},{"line":1152,"containerName":"_set_effects","kind":13,"name":"$self"},{"name":"mutation","containerName":"_set_effects","kind":12,"line":1152},{"line":1152,"containerName":"_set_effects","kind":12,"name":"transpos"},{"line":1153,"name":"$rnapos_end","containerName":"_set_effects","kind":13},{"line":1153,"kind":13,"containerName":"_set_effects","name":"$self"},{"name":"mutation","kind":12,"containerName":"_set_effects","line":1153},{"kind":12,"containerName":"_set_effects","name":"transpos","line":1153},{"name":"$self","containerName":"_set_effects","kind":13,"line":1153},{"line":1153,"containerName":"_set_effects","kind":12,"name":"mutation"},{"line":1153,"name":"len","kind":12,"containerName":"_set_effects"},{"name":"$rnachange","containerName":"_set_effects","localvar":"my","kind":13,"line":1154,"definition":"my"},{"line":1154,"kind":12,"containerName":"_set_effects","name":"new"},{"line":1154,"containerName":"_set_effects","kind":13,"name":"$self"},{"line":1154,"name":"mutation","containerName":"_set_effects","kind":12},{"containerName":"_set_effects","kind":12,"name":"transpos","line":1154},{"name":"$rnapos_end","kind":13,"containerName":"_set_effects","line":1156},{"line":1157,"name":"$rnachange","kind":13,"containerName":"_set_effects"},{"line":1157,"name":"isMutation","kind":12,"containerName":"_set_effects"},{"name":"$seqDiff","containerName":"_set_effects","kind":13,"line":1160},{"kind":12,"containerName":"_set_effects","name":"numbering","line":1160},{"containerName":"_set_effects","kind":13,"name":"$rnachange","line":1161},{"name":"proof","kind":12,"containerName":"_set_effects","line":1161},{"line":1163,"name":"$rnachange","containerName":"_set_effects","kind":13},{"line":1163,"kind":12,"containerName":"_set_effects","name":"proof"},{"line":1166,"name":"$seqDiff","kind":13,"containerName":"_set_effects"},{"name":"add_Variant","kind":12,"containerName":"_set_effects","line":1166},{"name":"$rnachange","containerName":"_set_effects","kind":13,"line":1166},{"containerName":"_set_effects","kind":13,"name":"$self","line":1167},{"containerName":"_set_effects","kind":12,"name":"rnachange","line":1167},{"line":1167,"containerName":"_set_effects","kind":13,"name":"$rnachange"},{"kind":13,"containerName":"_set_effects","name":"$rnachange","line":1168},{"containerName":"_set_effects","kind":12,"name":"DNAMutation","line":1168},{"name":"$dnamut","containerName":"_set_effects","kind":13,"line":1168},{"line":1169,"name":"$dnamut","kind":13,"containerName":"_set_effects"},{"line":1169,"containerName":"_set_effects","kind":12,"name":"RNAChange"},{"kind":13,"containerName":"_set_effects","name":"$rnachange","line":1169},{"name":"$rnachange","containerName":"_set_effects","kind":13,"line":1170},{"line":1170,"kind":12,"containerName":"_set_effects","name":"mut_number"},{"name":"$self","containerName":"_set_effects","kind":13,"line":1170},{"line":1170,"containerName":"_set_effects","kind":12,"name":"mutation"},{"line":1170,"name":"issue","kind":12,"containerName":"_set_effects"},{"name":"$rnachange","containerName":"_set_effects","kind":13,"line":1173},{"line":1173,"name":"codon_pos","containerName":"_set_effects","kind":12},{"line":1173,"name":"$self","containerName":"_set_effects","kind":13},{"name":"RNA","containerName":"_set_effects","kind":12,"line":1173},{"containerName":"_set_effects","kind":12,"name":"frame","line":1173},{"name":"$self","kind":13,"containerName":"_set_effects","line":1173},{"name":"mutation","containerName":"_set_effects","kind":12,"line":1173},{"line":1173,"name":"label","containerName":"_set_effects","kind":12},{"definition":"my","line":1175,"localvar":"my","containerName":"_set_effects","kind":13,"name":"@exons"},{"line":1175,"containerName":"_set_effects","kind":13,"name":"$self"},{"line":1175,"name":"RNA","kind":12,"containerName":"_set_effects"},{"line":1175,"kind":12,"containerName":"_set_effects","name":"all_Exons"},{"kind":13,"containerName":"_set_effects","name":"$self","line":1176},{"name":"exons","containerName":"_set_effects","kind":12,"line":1176},{"line":1176,"name":"@exons","kind":13,"containerName":"_set_effects"},{"definition":"my","line":1181,"name":"$RNAprelabel","containerName":"_set_effects","localvar":"my","kind":13},{"line":1181,"name":"$self","containerName":"_set_effects","kind":13},{"line":1181,"name":"RNA","kind":12,"containerName":"_set_effects"},{"containerName":"_set_effects","kind":12,"name":"label","line":1181},{"containerName":"_set_effects","kind":13,"name":"$self","line":1181},{"containerName":"_set_effects","kind":12,"name":"mutation","line":1181},{"name":"label","containerName":"_set_effects","kind":12,"line":1181},{"definition":"my","line":1183,"name":"$uplabel","containerName":"_set_effects","localvar":"my","kind":13},{"line":1183,"name":"$self","kind":13,"containerName":"_set_effects"},{"line":1183,"name":"RNA","kind":12,"containerName":"_set_effects"},{"containerName":"_set_effects","kind":12,"name":"label","line":1183},{"line":1183,"containerName":"_set_effects","kind":13,"name":"$flanklen"},{"line":1183,"name":"$RNAprelabel","kind":13,"containerName":"_set_effects"},{"name":"$self","containerName":"_set_effects","kind":13,"line":1184},{"kind":12,"containerName":"_set_effects","name":"RNA","line":1184},{"kind":12,"containerName":"_set_effects","name":"valid","line":1184},{"kind":13,"containerName":"_set_effects","name":"$uplabel","line":1184},{"containerName":"_set_effects","kind":13,"name":"$upstreamseq","line":1185},{"line":1185,"containerName":"_set_effects","kind":13,"name":"$self"},{"containerName":"_set_effects","kind":12,"name":"RNA","line":1185},{"name":"labelsubseq","kind":12,"containerName":"_set_effects","line":1185},{"name":"$uplabel","kind":13,"containerName":"_set_effects","line":1185},{"line":1185,"kind":13,"containerName":"_set_effects","name":"$RNAprelabel"},{"containerName":"_set_effects","kind":13,"name":"$upstreamseq","line":1187},{"kind":13,"containerName":"_set_effects","name":"$self","line":1187},{"name":"RNA","containerName":"_set_effects","kind":12,"line":1187},{"line":1187,"kind":12,"containerName":"_set_effects","name":"labelsubseq"},{"containerName":"_set_effects","kind":13,"name":"$self","line":1187},{"line":1187,"kind":12,"containerName":"_set_effects","name":"RNA"},{"name":"start","kind":12,"containerName":"_set_effects","line":1187},{"line":1187,"name":"$RNAprelabel","kind":13,"containerName":"_set_effects"},{"line":1188,"name":"$self","containerName":"_set_effects","kind":13},{"line":1188,"containerName":"_set_effects","kind":12,"name":"RNA"},{"line":1188,"containerName":"_set_effects","kind":12,"name":"valid"},{"line":1188,"containerName":"_set_effects","kind":13,"name":"$RNAprelabel"},{"line":1189,"name":"$lacking","localvar":"my","kind":13,"containerName":"_set_effects","definition":"my"},{"line":1189,"name":"$flanklen-length","containerName":"_set_effects","kind":13},{"kind":13,"containerName":"_set_effects","name":"$upstreamseq","line":1189},{"line":1190,"containerName":"_set_effects","localvar":"my","kind":13,"name":"$upstream_atg","definition":"my"},{"line":1190,"name":"$exons","containerName":"_set_effects","kind":13},{"line":1190,"kind":12,"containerName":"_set_effects","name":"subseq"},{"line":1190,"name":"$lacking","containerName":"_set_effects","kind":13},{"containerName":"_set_effects","kind":13,"name":"$upstreamseq","line":1191},{"line":1191,"name":"$upstream_atg","kind":13,"containerName":"_set_effects"},{"line":1191,"containerName":"_set_effects","kind":13,"name":"$upstreamseq"},{"name":"$rnachange","containerName":"_set_effects","kind":13,"line":1194},{"line":1194,"name":"upStreamSeq","containerName":"_set_effects","kind":12},{"line":1194,"containerName":"_set_effects","kind":13,"name":"$upstreamseq"},{"definition":"my","name":"$RNApostlabel","containerName":"_set_effects","localvar":"my","kind":13,"line":1199},{"name":"$self","containerName":"_set_effects","kind":13,"line":1200},{"line":1200,"containerName":"_set_effects","kind":12,"name":"mutation"},{"containerName":"_set_effects","kind":12,"name":"len","line":1200},{"line":1201,"containerName":"_set_effects","kind":13,"name":"$RNApostlabel"},{"line":1201,"name":"$self","containerName":"_set_effects","kind":13},{"line":1201,"name":"mutation","kind":12,"containerName":"_set_effects"},{"line":1201,"name":"label","kind":12,"containerName":"_set_effects"},{"definition":"my","line":1203,"localvar":"my","kind":13,"containerName":"_set_effects","name":"$mutlen"},{"line":1203,"name":"$self","kind":13,"containerName":"_set_effects"},{"name":"mutation","containerName":"_set_effects","kind":12,"line":1203},{"line":1203,"kind":12,"containerName":"_set_effects","name":"len"},{"line":1204,"containerName":"_set_effects","kind":13,"name":"$RNApostlabel"},{"line":1204,"kind":13,"containerName":"_set_effects","name":"$self"},{"line":1204,"name":"RNA","containerName":"_set_effects","kind":12},{"name":"label","containerName":"_set_effects","kind":12,"line":1204},{"line":1204,"name":"$mutlen","containerName":"_set_effects","kind":13},{"line":1204,"containerName":"_set_effects","kind":13,"name":"$self"},{"line":1204,"containerName":"_set_effects","kind":12,"name":"mutation"},{"line":1204,"kind":12,"containerName":"_set_effects","name":"label"},{"kind":13,"containerName":"_set_effects","name":"$dnstreamseq","line":1206},{"line":1206,"name":"$self","kind":13,"containerName":"_set_effects"},{"containerName":"_set_effects","kind":12,"name":"RNA","line":1206},{"line":1206,"name":"labelsubseq","containerName":"_set_effects","kind":12},{"line":1206,"kind":13,"containerName":"_set_effects","name":"$RNApostlabel"},{"line":1206,"containerName":"_set_effects","kind":13,"name":"$flanklen"},{"kind":13,"containerName":"_set_effects","name":"$dnstreamseq","line":1207},{"line":1208,"name":"$lastexon","kind":13,"localvar":"my","containerName":"_set_effects","definition":"my"},{"line":1208,"name":"$exons","containerName":"_set_effects","kind":13},{"line":1209,"name":"$lastexonlength","localvar":"my","containerName":"_set_effects","kind":13,"definition":"my"},{"name":"$lastexon","kind":13,"containerName":"_set_effects","line":1209},{"kind":12,"containerName":"_set_effects","name":"length","line":1209},{"name":"$dnstreamseq","kind":13,"containerName":"_set_effects","line":1210},{"containerName":"_set_effects","kind":13,"name":"$self","line":1210},{"line":1210,"kind":12,"containerName":"_set_effects","name":"RNA"},{"line":1210,"containerName":"_set_effects","kind":12,"name":"labelsubseq"},{"line":1210,"kind":13,"containerName":"_set_effects","name":"$RNApostlabel"},{"definition":"my","line":1211,"name":"$lacking","containerName":"_set_effects","localvar":"my","kind":13},{"name":"$flanklen-length","kind":13,"containerName":"_set_effects","line":1211},{"kind":13,"containerName":"_set_effects","name":"$dnstreamseq","line":1211},{"line":1212,"localvar":"my","containerName":"_set_effects","kind":13,"name":"$downstream_stop","definition":"my"},{"line":1212,"name":"$lastexon","containerName":"_set_effects","kind":13},{"line":1212,"containerName":"_set_effects","kind":12,"name":"subseq"},{"line":1212,"name":"$lastexonlength","kind":13,"containerName":"_set_effects"},{"line":1212,"containerName":"_set_effects","kind":13,"name":"$lacking"},{"line":1213,"name":"$dnstreamseq","containerName":"_set_effects","kind":13},{"line":1213,"kind":13,"containerName":"_set_effects","name":"$downstream_stop"},{"line":1215,"containerName":"_set_effects","kind":13,"name":"$rnachange"},{"line":1215,"name":"dnStreamSeq","kind":12,"containerName":"_set_effects"},{"name":"$dnstreamseq","containerName":"_set_effects","kind":13,"line":1215},{"name":"$AAobj","localvar":"my","kind":13,"containerName":"_set_effects","line":1218,"definition":"my"},{"containerName":"_set_effects","kind":13,"name":"$self","line":1218},{"kind":12,"containerName":"_set_effects","name":"RNA","line":1218},{"containerName":"_set_effects","kind":12,"name":"get_Translation","line":1218},{"definition":"my","localvar":"my","containerName":"_set_effects","kind":13,"name":"$aachange","line":1220},{"containerName":"_set_effects","kind":12,"name":"new","line":1220},{"line":1221,"kind":13,"containerName":"_set_effects","name":"$RNAprelabel"},{"line":1222,"containerName":"_set_effects","kind":13,"name":"$aachange"},{"containerName":"_set_effects","kind":12,"name":"isMutation","line":1222},{"line":1223,"containerName":"_set_effects","kind":13,"name":"$aachange"},{"line":1223,"containerName":"_set_effects","kind":12,"name":"proof"},{"containerName":"_set_effects","kind":13,"name":"$seqDiff","line":1225},{"kind":12,"containerName":"_set_effects","name":"add_Variant","line":1225},{"kind":13,"containerName":"_set_effects","name":"$aachange","line":1225},{"kind":13,"containerName":"_set_effects","name":"$self","line":1226},{"containerName":"_set_effects","kind":12,"name":"aachange","line":1226},{"name":"$aachange","kind":13,"containerName":"_set_effects","line":1226},{"line":1227,"name":"$rnachange","containerName":"_set_effects","kind":13},{"line":1227,"name":"AAChange","kind":12,"containerName":"_set_effects"},{"line":1227,"containerName":"_set_effects","kind":13,"name":"$aachange"},{"line":1228,"kind":13,"containerName":"_set_effects","name":"$aachange"},{"name":"RNAChange","containerName":"_set_effects","kind":12,"line":1228},{"line":1228,"name":"$rnachange","containerName":"_set_effects","kind":13},{"name":"$aachange","containerName":"_set_effects","kind":13,"line":1230},{"containerName":"_set_effects","kind":12,"name":"mut_number","line":1230},{"line":1230,"name":"$self","containerName":"_set_effects","kind":13},{"line":1230,"name":"mutation","kind":12,"containerName":"_set_effects"},{"name":"issue","kind":12,"containerName":"_set_effects","line":1230},{"localvar":"my","kind":13,"containerName":"_set_effects","name":"$ra_o","line":1233,"definition":"my"},{"kind":12,"containerName":"_set_effects","name":"new","line":1233},{"line":1234,"name":"$ra_o","containerName":"_set_effects","kind":13},{"name":"seq","kind":12,"containerName":"_set_effects","line":1234},{"line":1234,"name":"$dnamut","kind":13,"containerName":"_set_effects"},{"name":"allele_ori","kind":12,"containerName":"_set_effects","line":1234},{"name":"seq","containerName":"_set_effects","kind":12,"line":1234},{"containerName":"_set_effects","kind":13,"name":"$dnamut","line":1234},{"name":"allele_ori","containerName":"_set_effects","kind":12,"line":1234},{"kind":12,"containerName":"_set_effects","name":"seq","line":1234},{"line":1235,"name":"$rnachange","kind":13,"containerName":"_set_effects"},{"kind":12,"containerName":"_set_effects","name":"allele_ori","line":1235},{"name":"$ra_o","containerName":"_set_effects","kind":13,"line":1235},{"line":1237,"kind":13,"containerName":"_set_effects","name":"$rnachange"},{"containerName":"_set_effects","kind":12,"name":"length","line":1237},{"line":1237,"name":"$rnachange","kind":13,"containerName":"_set_effects"},{"name":"allele_ori","kind":12,"containerName":"_set_effects","line":1237},{"line":1237,"kind":12,"containerName":"_set_effects","name":"seq"},{"definition":"my","name":"$ra_m","localvar":"my","kind":13,"containerName":"_set_effects","line":1239},{"containerName":"_set_effects","kind":12,"name":"new","line":1239},{"name":"$ra_m","containerName":"_set_effects","kind":13,"line":1240},{"line":1240,"kind":12,"containerName":"_set_effects","name":"seq"},{"containerName":"_set_effects","kind":13,"name":"$self","line":1240},{"line":1240,"containerName":"_set_effects","kind":12,"name":"mutation"},{"line":1240,"kind":12,"containerName":"_set_effects","name":"seq"},{"line":1240,"containerName":"_set_effects","kind":13,"name":"$self"},{"line":1240,"name":"mutation","kind":12,"containerName":"_set_effects"},{"name":"seq","containerName":"_set_effects","kind":12,"line":1240},{"line":1241,"kind":13,"containerName":"_set_effects","name":"$rnachange"},{"line":1241,"containerName":"_set_effects","kind":12,"name":"allele_mut"},{"name":"$ra_m","containerName":"_set_effects","kind":13,"line":1241},{"line":1242,"kind":13,"containerName":"_set_effects","name":"$rnachange"},{"name":"add_Allele","containerName":"_set_effects","kind":12,"line":1242},{"containerName":"_set_effects","kind":13,"name":"$ra_m","line":1242},{"line":1245,"containerName":"_set_effects","kind":13,"name":"$rnachange"},{"line":1245,"containerName":"_set_effects","kind":12,"name":"end"},{"line":1245,"name":"$rnachange","containerName":"_set_effects","kind":13},{"kind":12,"containerName":"_set_effects","name":"start","line":1245},{"line":1245,"containerName":"_set_effects","kind":13,"name":"$rnachange"},{"line":1245,"name":"length","containerName":"_set_effects","kind":12},{"definition":"my","name":"$aa_allele_ori","localvar":"my","containerName":"_set_effects","kind":13,"line":1248},{"name":"$AAobj","containerName":"_set_effects","kind":13,"line":1248},{"kind":12,"containerName":"_set_effects","name":"labelsubseq","line":1248},{"line":1248,"name":"$self","kind":13,"containerName":"_set_effects"},{"name":"mutation","kind":12,"containerName":"_set_effects","line":1248},{"line":1248,"name":"label","containerName":"_set_effects","kind":12},{"line":1249,"name":"$self","kind":13,"containerName":"_set_effects"},{"containerName":"_set_effects","kind":12,"name":"mutation","line":1249},{"name":"lastlabel","kind":12,"containerName":"_set_effects","line":1249},{"line":1251,"name":"$aa_o","containerName":"_set_effects","localvar":"my","kind":13,"definition":"my"},{"line":1251,"name":"new","containerName":"_set_effects","kind":12},{"containerName":"_set_effects","kind":13,"name":"$aa_o","line":1252},{"name":"seq","containerName":"_set_effects","kind":12,"line":1252},{"name":"$aa_allele_ori","containerName":"_set_effects","kind":13,"line":1252},{"line":1252,"name":"$aa_allele_ori","kind":13,"containerName":"_set_effects"},{"line":1253,"kind":13,"containerName":"_set_effects","name":"$aachange"},{"kind":12,"containerName":"_set_effects","name":"allele_ori","line":1253},{"line":1253,"name":"$aa_o","containerName":"_set_effects","kind":13},{"definition":"my","line":1256,"containerName":"_set_effects","localvar":"my","kind":13,"name":"$aa_length_ori"},{"containerName":"_set_effects","kind":13,"name":"$aa_allele_ori","line":1256},{"kind":13,"containerName":"_set_effects","name":"$aachange","line":1257},{"line":1257,"name":"length","kind":12,"containerName":"_set_effects"},{"name":"$aa_length_ori","kind":13,"containerName":"_set_effects","line":1257},{"line":1258,"containerName":"_set_effects","kind":13,"name":"$aachange"},{"line":1258,"containerName":"_set_effects","kind":12,"name":"end"},{"line":1258,"containerName":"_set_effects","kind":13,"name":"$aachange"},{"name":"start","kind":12,"containerName":"_set_effects","line":1258},{"line":1258,"name":"$aa_length_ori","kind":13,"containerName":"_set_effects"}],"detail":"($self,$seqDiff,$dnamut)","definition":"sub"},{"line":1154,"name":"Bio","kind":12,"containerName":"Variation::RNAChange"},{"containerName":"Variation::AAChange","kind":12,"name":"Bio","line":1220},{"name":"Bio","containerName":"Variation::Allele","kind":12,"line":1233},{"line":1237,"containerName":"length","kind":12,"name":"CORE"},{"name":"Bio","containerName":"Variation::Allele","kind":12,"line":1239},{"line":1251,"name":"Bio","containerName":"Variation::Allele","kind":12},{"children":[{"line":1282,"localvar":"my","kind":13,"containerName":"_untranslated","name":"$self","definition":"my"},{"name":"$seqDiff","kind":13,"containerName":"_untranslated","line":1282},{"line":1282,"containerName":"_untranslated","kind":13,"name":"$dnamut"},{"localvar":"my","containerName":"_untranslated","kind":13,"name":"$rnapos_end","line":1283,"definition":"my"},{"containerName":"_untranslated","kind":13,"name":"$self","line":1284},{"line":1284,"name":"mutation","kind":12,"containerName":"_untranslated"},{"containerName":"_untranslated","kind":12,"name":"len","line":1284},{"line":1285,"name":"$rnapos_end","containerName":"_untranslated","kind":13},{"name":"$self","kind":13,"containerName":"_untranslated","line":1285},{"containerName":"_untranslated","kind":12,"name":"mutation","line":1285},{"line":1285,"kind":12,"containerName":"_untranslated","name":"transpos"},{"containerName":"_untranslated","kind":13,"name":"$rnapos_end","line":1286},{"line":1286,"name":"$self","kind":13,"containerName":"_untranslated"},{"name":"mutation","containerName":"_untranslated","kind":12,"line":1286},{"line":1286,"containerName":"_untranslated","kind":12,"name":"transpos"},{"line":1286,"name":"$self","kind":13,"containerName":"_untranslated"},{"containerName":"_untranslated","kind":12,"name":"mutation","line":1286},{"name":"len","containerName":"_untranslated","kind":12,"line":1286},{"definition":"my","line":1287,"localvar":"my","containerName":"_untranslated","kind":13,"name":"$rnachange"},{"name":"new","kind":12,"containerName":"_untranslated","line":1287},{"name":"$self","containerName":"_untranslated","kind":13,"line":1287},{"containerName":"_untranslated","kind":12,"name":"mutation","line":1287},{"line":1287,"containerName":"_untranslated","kind":12,"name":"transpos"},{"line":1289,"name":"$rnapos_end","containerName":"_untranslated","kind":13},{"line":1292,"containerName":"_untranslated","kind":13,"name":"$rnachange"},{"line":1292,"kind":12,"containerName":"_untranslated","name":"isMutation"},{"line":1293,"kind":13,"localvar":"my","containerName":"_untranslated","name":"$ra_o","definition":"my"},{"line":1293,"name":"new","containerName":"_untranslated","kind":12},{"line":1294,"name":"$ra_o","containerName":"_untranslated","kind":13},{"kind":12,"containerName":"_untranslated","name":"seq","line":1294},{"line":1294,"name":"$dnamut","containerName":"_untranslated","kind":13},{"containerName":"_untranslated","kind":12,"name":"allele_ori","line":1294},{"kind":12,"containerName":"_untranslated","name":"seq","line":1294},{"line":1294,"kind":13,"containerName":"_untranslated","name":"$dnamut"},{"line":1294,"name":"allele_ori","containerName":"_untranslated","kind":12},{"line":1294,"name":"seq","containerName":"_untranslated","kind":12},{"kind":13,"containerName":"_untranslated","name":"$rnachange","line":1295},{"name":"allele_ori","containerName":"_untranslated","kind":12,"line":1295},{"kind":13,"containerName":"_untranslated","name":"$ra_o","line":1295},{"definition":"my","name":"$ra_m","containerName":"_untranslated","localvar":"my","kind":13,"line":1296},{"line":1296,"kind":12,"containerName":"_untranslated","name":"new"},{"line":1297,"name":"$ra_m","containerName":"_untranslated","kind":13},{"line":1297,"name":"seq","containerName":"_untranslated","kind":12},{"line":1297,"name":"$dnamut","containerName":"_untranslated","kind":13},{"kind":12,"containerName":"_untranslated","name":"allele_mut","line":1297},{"kind":12,"containerName":"_untranslated","name":"seq","line":1297},{"name":"$dnamut","kind":13,"containerName":"_untranslated","line":1297},{"containerName":"_untranslated","kind":12,"name":"allele_mut","line":1297},{"kind":12,"containerName":"_untranslated","name":"seq","line":1297},{"line":1298,"name":"$rnachange","containerName":"_untranslated","kind":13},{"containerName":"_untranslated","kind":12,"name":"allele_mut","line":1298},{"containerName":"_untranslated","kind":13,"name":"$ra_m","line":1298},{"name":"$rnachange","containerName":"_untranslated","kind":13,"line":1299},{"name":"add_Allele","kind":12,"containerName":"_untranslated","line":1299},{"containerName":"_untranslated","kind":13,"name":"$ra_m","line":1299},{"line":1300,"containerName":"_untranslated","kind":13,"name":"$rnachange"},{"name":"upStreamSeq","kind":12,"containerName":"_untranslated","line":1300},{"name":"$dnamut","containerName":"_untranslated","kind":13,"line":1300},{"line":1300,"name":"upStreamSeq","kind":12,"containerName":"_untranslated"},{"containerName":"_untranslated","kind":13,"name":"$rnachange","line":1301},{"name":"dnStreamSeq","containerName":"_untranslated","kind":12,"line":1301},{"line":1301,"containerName":"_untranslated","kind":13,"name":"$dnamut"},{"line":1301,"name":"dnStreamSeq","containerName":"_untranslated","kind":12},{"line":1302,"kind":13,"containerName":"_untranslated","name":"$rnachange"},{"line":1302,"containerName":"_untranslated","kind":12,"name":"length"},{"line":1302,"containerName":"_untranslated","kind":13,"name":"$dnamut"},{"kind":12,"containerName":"_untranslated","name":"length","line":1302},{"line":1303,"name":"$rnachange","containerName":"_untranslated","kind":13},{"kind":12,"containerName":"_untranslated","name":"mut_number","line":1303},{"line":1303,"containerName":"_untranslated","kind":13,"name":"$dnamut"},{"line":1303,"kind":12,"containerName":"_untranslated","name":"mut_number"},{"line":1305,"containerName":"_untranslated","kind":13,"name":"$seqDiff"},{"line":1305,"name":"numbering","containerName":"_untranslated","kind":12},{"line":1306,"kind":13,"containerName":"_untranslated","name":"$rnachange"},{"line":1306,"name":"proof","containerName":"_untranslated","kind":12},{"line":1308,"containerName":"_untranslated","kind":13,"name":"$rnachange"},{"name":"proof","containerName":"_untranslated","kind":12,"line":1308},{"definition":"my","line":1311,"localvar":"my","containerName":"_untranslated","kind":13,"name":"$dist"},{"line":1312,"kind":13,"containerName":"_untranslated","name":"$rnachange"},{"containerName":"_untranslated","kind":12,"name":"end","line":1312},{"line":1313,"containerName":"_untranslated","kind":13,"name":"$rnachange"},{"name":"region","containerName":"_untranslated","kind":12,"line":1313},{"line":1314,"name":"$dnamut","containerName":"_untranslated","kind":13},{"line":1314,"name":"region","containerName":"_untranslated","kind":12},{"definition":"my","kind":13,"localvar":"my","containerName":"_untranslated","name":"$dist","line":1315},{"line":1315,"kind":13,"containerName":"_untranslated","name":"$dnamut"},{"name":"end","kind":12,"containerName":"_untranslated","line":1315},{"line":1316,"name":"$dnamut","containerName":"_untranslated","kind":13},{"line":1316,"containerName":"_untranslated","kind":12,"name":"region_dist"},{"kind":13,"containerName":"_untranslated","name":"$dist","line":1316},{"containerName":"_untranslated","kind":13,"name":"$dist","line":1317},{"line":1317,"containerName":"_untranslated","kind":13,"name":"$seqDiff"},{"line":1317,"name":"offset","kind":12,"containerName":"_untranslated"},{"name":"$self","kind":13,"containerName":"_untranslated","line":1317},{"line":1317,"name":"gene","containerName":"_untranslated","kind":12},{"line":1317,"containerName":"_untranslated","kind":12,"name":"maxtranscript"},{"line":1317,"name":"start","kind":12,"containerName":"_untranslated"},{"containerName":"_untranslated","kind":13,"name":"$dist","line":1317},{"name":"$rnachange","kind":13,"containerName":"_untranslated","line":1318},{"name":"region_dist","containerName":"_untranslated","kind":12,"line":1318},{"line":1318,"kind":13,"containerName":"_untranslated","name":"$dist"},{"name":"$dist","kind":13,"containerName":"_untranslated","line":1319},{"name":"$rnachange","kind":13,"containerName":"_untranslated","line":1321},{"line":1321,"name":"region","containerName":"_untranslated","kind":12},{"containerName":"_untranslated","kind":13,"name":"$dnamut","line":1322},{"line":1322,"containerName":"_untranslated","kind":12,"name":"region"},{"definition":"my","kind":13,"localvar":"my","containerName":"_untranslated","name":"$dist","line":1323},{"line":1323,"name":"$dnamut","kind":13,"containerName":"_untranslated"},{"name":"start","containerName":"_untranslated","kind":12,"line":1323},{"name":"$seqDiff","kind":13,"containerName":"_untranslated","line":1323},{"line":1323,"name":"cds_end","containerName":"_untranslated","kind":12},{"name":"$seqDiff","containerName":"_untranslated","kind":13,"line":1323},{"containerName":"_untranslated","kind":12,"name":"offset","line":1323},{"name":"$dnamut","containerName":"_untranslated","kind":13,"line":1324},{"name":"region_dist","kind":12,"containerName":"_untranslated","line":1324},{"containerName":"_untranslated","kind":13,"name":"$dist","line":1324},{"line":1325,"name":"$dist","containerName":"_untranslated","kind":13},{"kind":13,"containerName":"_untranslated","name":"$seqDiff","line":1325},{"line":1325,"name":"cds_end","containerName":"_untranslated","kind":12},{"kind":13,"containerName":"_untranslated","name":"$self","line":1325},{"name":"gene","containerName":"_untranslated","kind":12,"line":1325},{"containerName":"_untranslated","kind":12,"name":"maxtranscript","line":1325},{"line":1325,"name":"end","containerName":"_untranslated","kind":12},{"line":1325,"containerName":"_untranslated","kind":13,"name":"$dist"},{"kind":13,"containerName":"_untranslated","name":"$rnachange","line":1326},{"name":"region_dist","containerName":"_untranslated","kind":12,"line":1326},{"name":"$dist","containerName":"_untranslated","kind":13,"line":1326},{"line":1327,"name":"$dist","kind":13,"containerName":"_untranslated"},{"containerName":"_untranslated","kind":13,"name":"$seqDiff","line":1329},{"line":1329,"kind":12,"containerName":"_untranslated","name":"add_Variant"},{"name":"$rnachange","containerName":"_untranslated","kind":13,"line":1329},{"line":1330,"name":"$self","kind":13,"containerName":"_untranslated"},{"containerName":"_untranslated","kind":12,"name":"rnachange","line":1330},{"containerName":"_untranslated","kind":13,"name":"$rnachange","line":1330},{"name":"$rnachange","kind":13,"containerName":"_untranslated","line":1331},{"containerName":"_untranslated","kind":12,"name":"DNAMutation","line":1331},{"line":1331,"name":"$dnamut","containerName":"_untranslated","kind":13},{"name":"$dnamut","containerName":"_untranslated","kind":13,"line":1332},{"line":1332,"containerName":"_untranslated","kind":12,"name":"RNAChange"},{"line":1332,"name":"$rnachange","containerName":"_untranslated","kind":13}],"name":"_untranslated","containerName":"main::","definition":"sub","detail":"($self,$seqDiff,$dnamut)","line":1281,"kind":12,"range":{"start":{"character":0,"line":1281},"end":{"character":9999,"line":1333}},"signature":{"label":"_untranslated($self,$seqDiff,$dnamut)","parameters":[{"label":"$self"},{"label":"$seqDiff"},{"label":"$dnamut"}],"documentation":"1;\n# $Id: Mutator.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::Mutator\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::Mutator - Package mutating LiveSequences\n\n=head1 SYNOPSIS\n\n  # $gene is a Bio::LiveSeq::Gene object\n  my $mutate = Bio::LiveSeq::Mutator->new('-gene' => $gene,\n  \t\t\t\t\t  '-numbering' => \"coding\"\n  \t\t\t\t\t   );\n  # $mut is a Bio::LiveSeq::Mutation object\n  $mutate->add_Mutation($mut);\n  # $results is a Bio::Variation::SeqDiff object\n  my $results=$mutate->change_gene();\n  if ($results) {\n      my $out = Bio::Variation::IO->new( '-format' => 'flat');\n      $out->write($results);\n  }\n\n=head1 DESCRIPTION\n\nThis class mutates Bio::LiveSeq::Gene objects and returns a\nBio::Variation::SeqDiff object. Mutations are described as\nBio::LiveSeq::Mutation objects. See L<Bio::LiveSeq::Gene>,\nL<Bio::Variation::SeqDiff>, and L<Bio::LiveSeq::Mutation> for details.\n\n=head1 FEEDBACK\n\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho & Joseph A.L. Insana\n\n  Email:  heikki-at-bioperl-dot-org\n          insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\n  The rest of the documentation details each of the object\n  methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::Mutator;\nuse strict;\n\nuse Bio::Variation::SeqDiff;\nuse Bio::Variation::DNAMutation;\nuse Bio::Variation::RNAChange;\nuse Bio::Variation::AAChange;\nuse Bio::Variation::Allele;\nuse Bio::LiveSeq::Mutation;\n\n#use integer;\n# Object preamble - inheritance\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n    my($class,@args) = @_;\n    my $self;\n    $self = {};\n    bless $self, $class;\n\n    my ($gene, $numbering) =\n\t    $self->_rearrange([qw(GENE\n\t\t\t\t  NUMBERING\n\t\t\t\t  )],\n\t\t\t      @args);\n\n    $self->{ 'mutations' } = [];\n\n    $gene && $self->gene($gene);\n    $numbering && $self->numbering($numbering);\n\n    #class constant;\n    $self->{'flanklen'} = 25;\n    return $self; # success - we hope!\n}\n\n=head2 gene\n\n Title   : gene\n Usage   : $mutobj = $obj->gene;\n         : $mutobj = $obj->gene($objref);\n Function:\n\n           Returns or sets the link-reference to a\n           Bio::LiveSeq::Gene object. If no value has ben set, it\n           will return undef\n\n Returns : an object reference  or undef\n Args    : a Bio::LiveSeq::Gene\n\nSee L<Bio::LiveSeq::Gene> for more information.\n\n\nsub gene {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Gene') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::Gene object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'gene'} = $value;\n      }\n  }\n  unless (exists $self->{'gene'}) {\n      return;\n  } else {\n      return $self->{'gene'};\n  }\n}\n\n\n=head2 numbering\n\n Title   : numbering\n Usage   : $obj->numbering();\n Function:\n\n            Sets and returns coordinate system used in positioning the\n            mutations. See L<change_gene> for details.\n\n Example :\n Returns : string\n Args    : string (coding [transcript number] | gene | entry)\n\n\n\nsub numbering {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif ($value =~ /(coding)( )?(\\d+)?/ or $value eq 'entry' or $value eq 'gene') {\n\t    $self->{'numbering'} = $value;\n\t} else { # defaulting to 'coding'\n\t    $self->{'numbering'} = 'coding';\n\t}\n    }\n    unless (exists $self->{'numbering'}) {\n\treturn 'coding';\n    } else {\n\treturn $self->{'numbering'};\n    }\n}\n\n=head2 add_Mutation\n\n Title   : add_Mutation\n Usage   : $self->add_Mutation($ref)\n Function: adds a Bio::LiveSeq::Mutation object\n Example :\n Returns :\n Args    : a Bio::LiveSeq::Mutation\n\nSee L<Bio::LiveSeq::Mutation> for more information.\n\n\nsub add_Mutation{\n    my ($self,$value) = @_;\n    if( $value->isa('Bio::Liveseq::Mutation') ) {\n\tmy $com = ref $value;\n\t$self->throw(\"Is not a Mutation object but a [$com]\" );\n\treturn;\n    }\n    if (! $value->pos) {\n\t$self->warn(\"No value for mutation position in the sequence!\");\n\treturn;\n    }\n    if (! $value->seq && ! $value->len) {\n\t$self->warn(\"Either mutated sequence or length of the deletion must be given!\");\n\treturn;\n    }\n    push(@{$self->{'mutations'}},$value);\n}\n\n=head2 each_Mutation\n\n Title   : each_Mutation\n Usage   : foreach $ref ( $a->each_Mutation )\n Function: gets an array of Bio::LiveSeq::Mutation objects\n Example :\n Returns : array of Mutations\n Args    :\n\nSee L<Bio::LiveSeq::Mutation> for more information.\n\n\nsub each_Mutation{\n   my ($self) = @_;\n   return @{$self->{'mutations'}};\n}\n\n\n=head2 mutation\n\n Title   : mutation\n Usage   : $mutobj = $obj->mutation;\n         : $mutobj = $obj->mutation($objref);\n Function:\n\n           Returns or sets the link-reference to the current mutation\n           object.  If the value is not set, it will return undef.\n           Internal method.\n\n Returns : an object reference  or undef\n\n\n\nsub mutation {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Mutation') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::Mutation object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'mutation'} = $value;\n      }\n  }\n  unless (exists $self->{'mutation'}) {\n      return;\n  } else {\n      return $self->{'mutation'};\n  }\n}\n\n=head2 DNA\n\n Title   : DNA\n Usage   : $mutobj = $obj->DNA;\n         : $mutobj = $obj->DNA($objref);\n Function:\n\n           Returns or sets the reference to the LiveSeq object holding\n           the reference sequence. If there is no link, it will return\n           undef.\n           Internal method.\n\n Returns : an object reference or undef\n\n\nsub DNA {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::DNA') and ! $value->isa('Bio::LiveSeq::Transcript') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::DNA/Transcript object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'DNA'} = $value;\n      }\n  }\n  unless (exists $self->{'DNA'}) {\n      return;\n  } else {\n      return $self->{'DNA'};\n  }\n}\n\n\n=head2 RNA\n\n Title   : RNA\n Usage   : $mutobj = $obj->RNA;\n         : $mutobj = $obj->RNA($objref);\n Function:\n\n           Returns or sets the reference to the LiveSeq object holding\n           the reference sequence. If the value is not set, it will return\n           undef.\n           Internal method.\n\n Returns : an object reference  or undef\n\n\n\nsub RNA {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Transcript') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::RNA/Transcript object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'RNA'} = $value;\n      }\n  }\n  unless (exists $self->{'RNA'}) {\n      return;\n  } else {\n      return $self->{'RNA'};\n  }\n}\n\n\n=head2 dnamut\n\n Title   : dnamut\n Usage   : $mutobj = $obj->dnamut;\n         : $mutobj = $obj->dnamut($objref);\n Function:\n\n           Returns or sets the reference to the current DNAMutation object.\n           If the value is not set, it will return undef.\n           Internal method.\n\n Returns : a Bio::Variation::DNAMutation object or undef\n\nSee L<Bio::Variation::DNAMutation> for more information.\n\n\n\nsub dnamut {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::DNAMutation') ) {\n\t  $self->throw(\"Is not a Bio::Variation::DNAMutation object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'dnamut'} = $value;\n      }\n  }\n  unless (exists $self->{'dnamut'}) {\n      return;\n  } else {\n      return $self->{'dnamut'};\n  }\n}\n\n\n=head2 rnachange\n\n Title   : rnachange\n Usage   : $mutobj = $obj->rnachange;\n         : $mutobj = $obj->rnachange($objref);\n Function:\n\n           Returns or sets the reference to the current RNAChange object.\n           If the value is not set, it will return undef.\n           Internal method.\n\n Returns : a Bio::Variation::RNAChange object or undef\n\nSee L<Bio::Variation::RNAChange> for more information.\n\n\n\nsub rnachange {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::RNAChange') ) {\n\t  $self->throw(\"Is not a Bio::Variation::RNAChange object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'rnachange'} = $value;\n      }\n  }\n  unless (exists $self->{'rnachange'}) {\n      return;\n  } else {\n      return $self->{'rnachange'};\n  }\n}\n\n\n=head2 aachange\n\n Title   : aachange\n Usage   : $mutobj = $obj->aachange;\n         : $mutobj = $obj->aachange($objref);\n Function:\n\n           Returns or sets the reference to the current AAChange object.\n           If the value is not set, it will return undef.\n           Internal method.\n\n Returns : a Bio::Variation::AAChange object or undef\n\nSee L<Bio::Variation::AAChange> for more information.\n\n\n\nsub aachange {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::AAChange') ) {\n\t  $self->throw(\"Is not a Bio::Variation::AAChange object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'aachange'} = $value;\n      }\n  }\n  unless (exists $self->{'aachange'}) {\n      return;\n  } else {\n      return $self->{'aachange'};\n  }\n}\n\n\n=head2 exons\n\n Title   : exons\n Usage   : $mutobj = $obj->exons;\n         : $mutobj = $obj->exons($objref);\n Function:\n\n           Returns or sets the reference to a current array of Exons.\n           If the value is not set, it will return undef.\n           Internal method.\n\n Returns : an array of Bio::LiveSeq::Exon objects or undef\n\nSee L<Bio::LiveSeq::Exon> for more information.\n\n\n\nsub exons {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      $self->{'exons'} = $value;\n  }\n  unless (exists $self->{'exons'}) {\n      return;\n  } else {\n      return $self->{'exons'};\n  }\n}\n\n=head2 change_gene_with_alignment\n\n Title   : change_gene_with_alignment\n Usage   : $results=$mutate->change_gene_with_alignment($aln);\n\n Function:\n\n           Returns a Bio::Variation::SeqDiff object containing the\n           results of the changes in the alignment. The alignment has\n           to be pairwise and have one sequence named 'QUERY', the\n           other one is assumed to be a part of the sequence from\n           $gene.\n\n           This method offers a shortcut to change_gene and\n           automates the creation of Bio::LiveSeq::Mutation objects.\n           Use it with almost identical sequnces, e.g. to locate a SNP.\n\n Args    : Bio::SimpleAlign object representing a short local alignment\n Returns : Bio::Variation::SeqDiff object or 0 on error\n\nSee L<Bio::LiveSeq::Mutation>, L<Bio::SimpleAlign>, and\nL<Bio::Variation::SeqDiff>  for more information.\n\n\nsub change_gene_with_alignment {\n    my ($self, $aln) = @_;\n\n    #\n    # Sanity checks\n    #\n\n    $self->throw(\"Argument is not a Bio::SimpleAlign object but a [$aln]\")\n\tunless $aln->isa('Bio::SimpleAlign');\n    $self->throw(\"'Pairwise alignments only, please\") \n\tif $aln->no_sequences != 2;\n\n    # find out the order the two sequences are given\n    my $queryseq_pos = 1; #default\n    my $refseq_pos = 2;\n    unless ($aln->get_seq_by_pos(1)->id eq 'QUERY') {\n\tcarp('Query sequence has to be named QUERY') \n\t    if $aln->get_seq_by_pos(2)->id ne 'QUERY';\n\t$queryseq_pos = 2; # alternative\n\t$refseq_pos = 1;\n    }\n\n    # trim the alignment\n    my $start =  $aln->column_from_residue_number('QUERY', 1);\n    my $end =  $aln->column_from_residue_number('QUERY', \n\t\t\t\t\t\t$aln->get_seq_by_pos($queryseq_pos)->end );\n    \n    my $aln2 = $aln->slice($start, $end);\n\n    #\n    # extracting mutations\n    #\n\n    my $cs = $aln2->consensus_string(51);\n    my $queryseq = $aln2->get_seq_by_pos($queryseq_pos);\n    my $refseq = $aln2->get_seq_by_pos($refseq_pos);\n\n    while ( $cs =~ /(\\?+)/g) {\n\t# pos in local coordinates\n\tmy $pos = pos($cs) - length($1) + 1;\n\tmy $mutation = create_mutation($self, \n\t\t\t\t       $refseq, \n\t\t\t\t       $queryseq, \n\t\t\t\t       $pos, \n\t\t\t\t       CORE::length($1)\n\t\t\t\t       );\n\t# reset pos to refseq coordinates\n\t$pos +=  $refseq->start - 1;\n\t$mutation->pos($pos);\n\n        $self->add_Mutation($mutation);\n    }\n    return $self->change_gene();\n}\n\n=head2 create_mutation\n\n Title   : create_mutation\n Usage   : \n Function:\n\n           Formats sequence differences from two sequences into\n           Bio::LiveSeq::Mutation objects which can be applied to a\n           gene.\n\n           To keep it generic, sequence arguments need not to be\n           Bio::LocatableSeq. Coordinate change to parent sequence\n           numbering needs to be done by the calling code.\n\n           Called from change_gene_with_alignment\n\n Args    : Bio::PrimarySeqI inheriting object for the reference sequence\n           Bio::PrimarySeqI inheriting object for the query sequence\n           integer for the start position of the local sequence difference\n           integer for the length of the sequence difference\n Returns : Bio::LiveSeq::Mutation object \n\n\nsub create_mutation {\n    my ($self, $refseq, $queryseq, $pos, $len) = @_;\n    \n    $self->throw(\"Is not a Bio::PrimarySeqI object but a [$refseq]\") \n\tunless $refseq->isa('Bio::PrimarySeqI');\n    $self->throw(\"Is not a Bio::PrimarySeqI object but a [$queryseq]\") \n\tunless $queryseq->isa('Bio::PrimarySeqI');\n    $self->throw(\"Position is not a positive integer but [$pos]\") \n\tunless $pos =~ /^\\+?\\d+$/;\n    $self->throw(\"Length is not a positive integer but [$len]\") \n\tunless $len =~ /^\\+?\\d+$/;\n\n    my $mutation;\n    my $refstring = $refseq->subseq($pos, $pos + $len - 1);\n    my $varstring = $queryseq->subseq($pos, $pos + $len - 1);\n    \n    if ($len == 1 and $refstring =~ /[^\\.\\-\\*\\?]/ and \n\t$varstring  =~ /[^\\.\\-\\*\\?]/ ) { #point\n\t$mutation = Bio::LiveSeq::Mutation->new(-seq => $varstring,\n\t\t\t\t\t\t-pos => $pos,\n\t\t\t\t\t\t);\n    }\n    elsif ( $refstring =~ /^[^\\.\\-\\*\\?]+$/ and \n\t    $varstring  !~ /^[^\\.\\-\\*\\?]+$/ ) { # deletion\n\t$mutation = Bio::LiveSeq::Mutation->new(-pos => $pos,\n\t\t\t\t\t\t-len => $len\n\t\t\t\t\t\t);\n    }\n    elsif ( $refstring !~ /^[^\\.\\-\\*\\?]+$/ and \n\t    $varstring  =~ /^[^\\.\\-\\*\\?]+$/ ) { # insertion\n\t$mutation = Bio::LiveSeq::Mutation->new(-seq => $varstring,\n\t\t\t\t\t\t-pos => $pos,\n\t\t\t\t\t\t-len => 0\n\t\t\t\t\t\t);\n    } else { # complex\n\t$mutation = Bio::LiveSeq::Mutation->new(-seq => $varstring,\n\t\t\t\t\t\t-pos => $pos,\n\t\t\t\t\t\t-len => $len\n\t\t\t\t\t\t);\n    }\n    \n    return $mutation;\n}\n\n=head2 change_gene\n\n Title   : change_gene\n Usage   : my $mutate = Bio::LiveSeq::Mutator->new(-gene => $gene,\n\t\t\t\t\t\t   numbering => \"coding\"\n\t\t\t\t\t\t   );\n           # $mut is Bio::LiveSeq::Mutation object\n           $mutate->add_Mutation($mut);\n           my $results=$mutate->change_gene();\n\n Function:\n\n           Returns a Bio::Variation::SeqDiff object containing the\n           results of the changes performed according to the\n           instructions present in Mutation(s).  The -numbering\n           argument decides what molecule is being changed and what\n           numbering scheme being used:\n\n            -numbering => \"entry\"\n\n               determines the DNA level, using the numbering from the\n               beginning of the sequence\n\n            -numbering => \"coding\"\n\n               determines the RNA level, using the numbering from the\n               beginning of the 1st transcript\n\n               Alternative transcripts can be used by specifying\n               \"coding 2\" or \"coding 3\" ...\n\n            -numbering => \"gene\"\n\n               determines the DNA level, using the numbering from the\n               beginning of the 1st transcript and inluding introns.\n               The meaning equals 'coding' if the reference molecule\n               is cDNA.\n\n Args    : Bio::LiveSeq::Gene object\n           Bio::LiveSeq::Mutation object(s)\n           string specifying a numbering scheme (defaults to 'coding')\n Returns : Bio::Variation::SeqDiff object or 0 on error\n\n\nsub change_gene {\n    my ($self) = @_;\n\n    #\n    # Sanity check\n    #\n    unless ($self->gene) {\n\t$self->warn(\"Input object Bio::LiveSeq::Gene is not given\");\n\treturn 0;\n    }\n    #\n    # Setting the reference sequence based on -numbering\n    #\n    my @transcripts=@{$self->gene->get_Transcripts};\n    my $refseq; # will hold Bio::LiveSeq:Transcript object or Bio::LiveSeq::DNA\n\n    # 'gene' eq 'coding' if reference sequence is cDNA\n    $self->numbering ('coding') if $self->gene->get_DNA->alphabet eq 'rna' and $self->numbering eq 'gene';\n\n    if ($self->numbering =~ /(coding)( )?(\\d+)?/ ) {\n\t$self->numbering($1);\n\tmy $transnumber = $3;\n\t$transnumber-- if $3; # 1 -> 0, 2 -> 1\n\tif ($transnumber && $transnumber >= 0 && $transnumber <= $#transcripts) {\n\t    $refseq=$transcripts[$transnumber];\n\t} else {\n\t    $transnumber && $self->warn(\"The alternative transcript number \". $transnumber+1 .\n\t    \"- does not exist. Reverting to the 1st transcript\\n\");\n\t    $refseq=$transcripts[0];\n\t}\n    } else {\n\t$refseq=$transcripts[0]->{'seq'};\n    }\n    #\n    # Recording the state: SeqDiff object creation  ?? transcript no.??\n    #\n    my $seqDiff = Bio::Variation::SeqDiff->new(-verbose => $self->verbose);\n    $seqDiff->alphabet($self->gene->get_DNA->alphabet);\n    $seqDiff->numbering($self->numbering);\n    my ($DNAobj, $RNAobj);\n    if ($refseq->isa(\"Bio::LiveSeq::Transcript\")) {\n\t$self->RNA($refseq);\n\t$self->DNA($refseq->{'seq'});\n\t$seqDiff->rna_ori($refseq->seq );\n\t$seqDiff->aa_ori($refseq->get_Translation->seq);\n    } else {\n\t$self->DNA($refseq);\n\t$self->RNA($transcripts[0]);\n\t$seqDiff->rna_ori($self->RNA->seq);\n\t$seqDiff->aa_ori($self->RNA->get_Translation->seq);\n    }\n    $seqDiff->dna_ori($self->DNA->seq);\n    # put the accession number into the SeqDiff object ID\n    $seqDiff->id($self->DNA->accession_number);\n\n    # the atg_offset takes in account that DNA object could be a subset of the\n    # whole entry (via the light_weight loader)\n    my $atg_label=$self->RNA->start;\n    my $atg_offset=$self->DNA->position($atg_label)+($self->DNA->start)-1;\n    $seqDiff->offset($atg_offset - 1);\n    $self->DNA->coordinate_start($atg_label);\n\n    my @exons = $self->RNA->all_Exons;\n    $seqDiff->cds_end($exons[$#exons]->end);\n\n    #\n    # Converting mutation positions to labels\n    #\n    $self->warn(\"no mutations\"), return 0 \n\tunless $self->_mutationpos2label($refseq, $seqDiff);\n\n    # need to add more than one rna & aa\n    #foreach $transcript (@transcripts) {\n    #  $seqDiff{\"ori_transcript_${i}_seq\"}=$transcript->seq;\n    #  $seqDiff{\"ori_translation_${i}_seq\"}=$transcript->get_Translation->seq;\n    #}\n\n    # do changes\n    my $k;\n    foreach my $mutation ($self->each_Mutation) {\n\tnext unless $mutation->label > 0;\n\t$self->mutation($mutation);\n\n\t$mutation->issue(++$k);\n\t#\n\t# current position on the transcript\n\t#\n\tif ($self->numbering =~ /coding/) {\n\t    $mutation->transpos($mutation->pos); # transpos given by user\n\t} else {\n\t    #transpos of label / It will be 0 if mutating an intron, negative if upstream of ATG\n\t    $mutation->transpos($self->RNA->position($mutation->label,$atg_label));\n\t}\n\t#\n\t# Calculate adjacent labels based on the position on the current sequence\n\t#\n\t$mutation->prelabel($self->DNA->label(-1, $mutation->label)); # 1 before label\n\tif ($mutation->len == 0) {\n\t    $mutation->postlabel($mutation->label);\n\t    $mutation->lastlabel($mutation->label);\n\t} elsif ($mutation->len == 1) {\n\t    $mutation->lastlabel($mutation->label); # last nucleotide affected\n\t    $mutation->postlabel($self->DNA->label(2,$mutation->lastlabel)); # $len after label\n\t} else {\n\t    $mutation->lastlabel($self->DNA->label($mutation->len,$mutation->label));\n\t    $mutation->postlabel($self->DNA->label(2,$mutation->lastlabel));\n\t}\n\tmy $dnamut = $self->_set_DNAMutation($seqDiff);\n\t#\n\t#\n\t#\n\tif ($self->_rnaAffected) {\n\t    $self->_set_effects($seqDiff, $dnamut);\n\t}\n\telsif ($seqDiff->offset != 0 and $dnamut->region ne 'intron') {\n\t    $self->_untranslated ($seqDiff, $dnamut);\n\t} else {\n\t    #$self->warn(\"Mutation starts outside coding region, RNAChange object not created\");\n\t}\n\n\t#########################################################################\n\t# Mutations are done here!                                              #\n\t$refseq->labelchange($mutation->seq, $mutation->label, $mutation->len); #\n\t#########################################################################\n\n\t$self->_post_mutation ($seqDiff);\n\n\t$self->dnamut(undef);\n\t$self->rnachange(undef);\n\t$self->aachange(undef);\n\t$self->exons(undef);\n    }\n    # record the final state of all three sequences\n    $seqDiff->dna_mut($self->DNA->seq);\n    $seqDiff->rna_mut($self->RNA->seq);\n    if ($refseq->isa(\"Bio::LiveSeq::Transcript\")) {\n\t$seqDiff->aa_mut($refseq->get_Translation->seq);\n    } else {\n\t$seqDiff->aa_mut($self->RNA->get_Translation->seq);\n    }\n\n    #$seqDiff{mut_dna_seq}=$gene->get_DNA->seq;\n    #my $i=1;\n    #foreach $transcript (@transcripts) {\n    #  $seqDiff{\"mut_transcript_${i}_seq\"}=$transcript->seq;\n    #  $seqDiff{\"mut_translation_${i}_seq\"}=$transcript->get_Translation->seq;\n    #}\n    return $seqDiff;\n}\n\n=head2 _mutationpos2label\n\n Title   : _mutationpos2label\n Usage   :\n Function: converts mutation positions into labels\n Example :\n Returns : number of valid mutations\n Args    : LiveSeq sequence object\n\n\nsub _mutationpos2label {\n    my ($self, $refseq, $SeqDiff) = @_;\n    my $count;\n    my @bb = @{$self->{'mutations'}};\n    my $cc = scalar @bb;\n    foreach my $mut (@{$self->{'mutations'}}) {\n#\t if ($self->numbering eq 'gene' and $mut->pos < 1) {\n#\t     my $tmp = $mut->pos;\n#\t     print STDERR \"pos: \", \"$tmp\\n\";\n#\t     $tmp++ if $tmp < 1;\n#\t     $tmp += $SeqDiff->offset;\n#\t     print STDERR \"pos2: \", \"$tmp\\n\";\n#\t     $mut->pos($tmp);\n#\t }\n#\telsif ($self->numbering eq 'entry') {\n\tif ($self->numbering eq 'entry') {\n\t    my $tmp = $mut->pos;\n\t    $tmp -= $SeqDiff->offset;\n\t    $tmp-- if $tmp < 1;\n\t    $mut->pos($tmp);\n\t}\n\n\tmy $label = $refseq->label($mut->pos); # get the label for the position\n\t$mut->label($label), $count++ if $label > 0 ;\n\t#print STDERR \"x\", $mut->pos,'|' ,$mut->label, \"\\n\";\n    }\n    return $count;\n}\n\n#\n# Calculate labels around mutated nucleotide\n#\n\n=head2 _set_DNAMutation\n\n Title   : _set_DNAMutation\n Usage   :\n Function:\n\n           Stores DNA level mutation attributes before mutation into\n           Bio::Variation::DNAMutation object.  Links it to SeqDiff\n           object.\n\n Example :\n Returns : Bio::Variation::DNAMutation object\n Args    : Bio::Variation::SeqDiff object\n\nSee L<Bio::Variation::DNAMutation> and L<Bio::Variation::SeqDiff>.\n\n\nsub _set_DNAMutation {\n    my ($self, $seqDiff) = @_;\n\n    my $dnamut_start = $self->mutation->label - $seqDiff->offset;\n    # if negative DNA positions (before ATG)\n    $dnamut_start-- if $dnamut_start <= 0;\n    my $dnamut_end;\n    ($self->mutation->len == 0 or $self->mutation->len == 1) ?\n\t($dnamut_end = $dnamut_start) :\n\t($dnamut_end = $dnamut_start+$self->mutation->len);\n    #print \"start:$dnamut_start, end:$dnamut_end\\n\";\n    my $dnamut = Bio::Variation::DNAMutation->new(-start => $dnamut_start,\n\t\t\t\t\t\t  -end => $dnamut_end,\n\t\t\t\t\t\t  );\n    $dnamut->mut_number($self->mutation->issue);\n    $dnamut->isMutation(1);\n    my $da_m = Bio::Variation::Allele->new;\n    $da_m->seq($self->mutation->seq) if $self->mutation->seq;\n    $dnamut->allele_mut($da_m);\n    $dnamut->add_Allele($da_m);\n    # allele_ori\n    my $allele_ori = $self->DNA->labelsubseq($self->mutation->prelabel,\n\t\t\t\t\t     undef,\n\t\t\t\t\t     $self->mutation->postlabel); # get seq\n    chop $allele_ori; # chop the postlabel nucleotide\n    $allele_ori=substr($allele_ori,1); # away the prelabel nucleotide\n    my $da_o = Bio::Variation::Allele->new;\n    $da_o->seq($allele_ori) if $allele_ori;\n    $dnamut->allele_ori($da_o);\n    ($self->mutation->len == 0) ?\n\t($dnamut->length($self->mutation->len)) : ($dnamut->length(CORE::length $allele_ori));\n    #print \" --------------- $dnamut_start -$len-  $dnamut_end -\\n\";\n    $seqDiff->add_Variant($dnamut);\n    $self->dnamut($dnamut);\n    $dnamut->mut_number($self->mutation->issue);\n    # setting proof\n    if ($seqDiff->numbering eq \"entry\" or $seqDiff->numbering eq \"gene\") {\n\t $dnamut->proof('experimental');\n    } else {\n\t $dnamut->proof('computed');\n    }\n    # how many nucleotides to store upstream and downstream of the change\n    my $flanklen = $self->{'flanklen'};\n    #print  `date`, \" flanking sequences start\\n\";\n    my $uplabel = $self->DNA->label(1-$flanklen,$self->mutation->prelabel); # this could be unavailable!\n\n    my $upstreamseq;\n    if ($uplabel > 0) {\n\t $upstreamseq =\n\t     $self->DNA->labelsubseq($uplabel, undef, $self->mutation->prelabel);\n    } else { # from start (less than $flanklen nucleotides)\n\t $upstreamseq =\n\t     $self->DNA->labelsubseq($self->DNA->start, undef, $self->mutation->prelabel);\n    }\n    $dnamut->upStreamSeq($upstreamseq);\n    my $dnstreamseq = $self->DNA->labelsubseq($self->mutation->postlabel, $flanklen);\n    $dnamut->dnStreamSeq($dnstreamseq); # $flanklen or less nucleotides\n    return $dnamut;\n}\n\n\n#\n### Check if mutation propagates to RNA (and AA) level\n#  \n# side effect: sets intron/exon information\n# returns a boolean value\n#\n\nsub _rnaAffected {\n    my ($self) = @_;\n    my @exons=$self->RNA->all_Exons;\n    my $RNAstart=$self->RNA->start;\n    my $RNAend=$self->RNA->end;\n    my ($firstexon,$before,$after,$i);\n    my ($rnaAffected) = 0;\n\n    # check for inserted labels (that require follows instead of <,>)\n    my $DNAend=$self->RNA->{'seq'}->end;\n    if ($self->mutation->prelabel > $DNAend or $self->mutation->postlabel > $DNAend) {\n\t #this means one of the two labels is an inserted one\n\t #(coming from a previous mutation. This would falsify all <,>\n\t #checks, so the follow() has to be used\n\t $self->warn(\"Attention, workaround not fully tested yet! Expect unpredictable results.\\n\");\n\t if (($self->mutation->postlabel==$RNAstart) or (follows($self->mutation->postlabel,$RNAstart))) {\n\t     $self->warn(\"RNA not affected because change occurs before RNAstart\");\n\t }\n\t elsif (($RNAend==$self->mutation->prelabel) or (follows($RNAend,$self->mutation->prelabel))) {\n\t     $self->warn(\"RNA not affected because change occurs after RNAend\");\n\t }\n\t elsif (scalar @exons == 1) {\n\t     #no introns, just one exon\n\t     $rnaAffected = 1; # then RNA is affected!\n\t } else {\n\t     # otherwise check for change occurring inside an intron\n\t     $firstexon=shift(@exons);\n\t     $before=$firstexon->end;\n\t\n\t     foreach $i (0..$#exons) {\n\t\t $after=$exons[$i]->start;\n\t\t if (follows($self->mutation->prelabel,$before) or\n\t\t\t($after==$self->mutation->prelabel) or\n\t\t\tfollows($after,$self->mutation->prelabel) or\n\t\t\tfollows($after,$self->mutation->postlabel)) {\n\n\t\t     $rnaAffected = 1;\n\t\t     # $i is number of exon and can be used for proximity check\n\t\t }\n\t\t $before=$exons[$i]->end;\n\t     }\n\t\n\t }\n    } else {\n\tmy $strand = $exons[0]->strand;\n\tif (($strand == 1 and $self->mutation->postlabel <= $RNAstart) or\n\t    ($strand != 1 and $self->mutation->postlabel >= $RNAstart)) {\n\t    #$self->warn(\"RNA not affected because change occurs before RNAstart\");\n\t    $rnaAffected = 0;\n\t}\n\telsif (($strand == 1 and $self->mutation->prelabel >= $RNAend) or\n\t\t($strand != 1 and $self->mutation->prelabel <= $RNAend)) {\n\t     #$self->warn(\"RNA not affected because change occurs after RNAend\");\n\t     $rnaAffected = 0;\n\t     my $dist;\n\t     if ($strand == 1){\n\t\t $dist = $self->mutation->prelabel - $RNAend;\n\t     } else {\n\t\t $dist = $RNAend - $self->mutation->prelabel;\n\t     }\n\t     $self->dnamut->region_dist($dist);\n\t }\n\t elsif (scalar @exons == 1) {\n\t     #if just one exon -> no introns, \n\t     $rnaAffected = 1; # then RNA is affected!\n\t } else {\t\n\t     # otherwise check for mutation occurring inside an intron\n\t     $firstexon=shift(@exons);\n\t     $before=$firstexon->end;\n\t     if ( ($strand == 1 and $self->mutation->prelabel < $before) or \n\t\t  ($strand == -1 and $self->mutation->prelabel > $before) \n\t\t  ) {\n\t\t $rnaAffected = 1 ;\n\n\t\t #print \"Exon 1 : \", $firstexon->start, \" - \", $firstexon->end, \"<br>\\n\";\n\t\t my $afterdist = $self->mutation->prelabel - $firstexon->start;\n\t\t my $beforedist =  $firstexon->end - $self->mutation->postlabel;\n\t\t my $exonvalue = $i + 1;\n\t\t $self->dnamut->region('exon');\n\t\t $self->dnamut->region_value($exonvalue);\n\t\t if ($afterdist < $beforedist) {\n\t\t     $afterdist++; \t\t  \n\t\t     $afterdist++;\n\t\t     $self->dnamut->region_dist($afterdist);\n\t\t     #print \"splice site $afterdist nt upstream!<br>\";\n\t\t } else {\n\t\t     $self->dnamut->region_dist($beforedist);\n\t\t     #print \"splice site $beforedist nt downstream!<br>\";\n\t\t }\n\t     } else {\n\t\t #print \"first exon  : \", $firstexon->start, \" - \", $firstexon->end, \"<br>\\n\";\n\t\t foreach $i (0..$#exons) {\n\t\t     $after=$exons[$i]->start;\n\t\t     #proximity test for intronic mutations\n\t\t     if ( ($strand == 1 and \n\t\t\t   $self->mutation->prelabel >=  $before and \n\t\t\t   $self->mutation->postlabel <= $after) \n\t\t\t  or\n\t\t\t  ($strand == -1 and \n\t\t\t   $self->mutation->prelabel <=  $before and \n\t\t\t   $self->mutation->postlabel >= $after)  ) {\n\t\t\t $self->dnamut->region('intron');\n\t\t\t #$self->dnamut->region_value($i);\n\t\t\t my $afterdist = $self->mutation->prelabel - $before;\n\t\t\t my $beforedist =  $after - $self->mutation->postlabel;\n\t\t\t my $intronvalue = $i + 1;\n\t\t\t if ($afterdist < $beforedist) {\n\t\t\t     $afterdist++;\n\t\t\t     $self->dnamut->region_value($intronvalue);\n\t\t\t     $self->dnamut->region_dist($afterdist);\n\t\t\t     #print \"splice site $afterdist nt upstream!<br>\";\n\t\t\t } else {\n\t\t\t     $self->dnamut->region_value($intronvalue);\n\t\t\t     $self->dnamut->region_dist($beforedist * -1);\n\t\t\t     #print \"splice site $beforedist nt downstream!<br>\";\n\t\t\t }\n\t\t\t $self->rnachange(undef);\n\t\t\t last;\n\t\t     } \n\t\t     #proximity test for exon mutations\n\t\t     #proximity test for exon mutations\n\t\t     elsif ( ( $strand == 1 and \n\t\t\t       $exons[$i]->start < $self->mutation->prelabel and \n\t\t\t       $exons[$i]->end > $self->mutation->prelabel) or \n\t\t\t     ( $strand == 1 and \n\t\t\t       $exons[$i]->start < $self->mutation->postlabel and \n\t\t\t       $exons[$i]->end > $self->mutation->postlabel) or \n\t\t\t     ( $strand == -1 and \n\t\t\t       $exons[$i]->start > $self->mutation->prelabel and \n\t\t\t       $exons[$i]->end < $self->mutation->prelabel) or\n\t\t\t     ( $strand == -1 and \n\t\t\t       $exons[$i]->start > $self->mutation->postlabel and \n\t\t\t       $exons[$i]->end < $self->mutation->postlabel) ) {\n\t\t\t $rnaAffected = 1;\n\n\t\t\t my $afterdist = $self->mutation->prelabel - $exons[$i]->start;\n\t\t\t my $beforedist =  $exons[$i]->end - $self->mutation->postlabel;\n\t\t\t my $exonvalue = $i + 1;\n\t\t\t $self->dnamut->region('exon');\n\t\t\t if ($afterdist < $beforedist) {\n\t\t\t     $afterdist++;\n\t\t\t     $self->dnamut->region_value($exonvalue+1);\n\t\t\t     $self->dnamut->region_dist($afterdist);\n\t\t\t     #print \"splice site $afterdist nt upstream!<br>\";\n\t\t\t } else {\n\t\t\t     #$beforedist;\n\t\t\t     $self->dnamut->region_value($exonvalue+1);\n\t\t\t     $self->dnamut->region_dist($beforedist * -1);\n\t\t\t     #print \"splice site $beforedist nt downstream!<br>\";\n\t\t\t }\n\t\t\t last;\n\t\t     }\n\t\t     $before=$exons[$i]->end;\n\t\t }\n\t     }\n\t }\n     }\n    #$self->warn(\"RNA not affected because change occurs inside an intron\");\n    #return(0); # if still not returned, then not affected, return 0\n    return $rnaAffected;\n}\n\n#\n# ### Creation of RNA and AA variation objects\n#\n\n=head2 _set_effects\n\n Title   : _set_effects\n Usage   :\n Function:\n\n           Stores RNA and AA level mutation attributes before mutation\n           into Bio::Variation::RNAChange and\n           Bio::Variation::AAChange objects.  Links them to\n           SeqDiff object.\n\n Example :\n Returns :\n Args    : Bio::Variation::SeqDiff object\n           Bio::Variation::DNAMutation object\n\nSee L<Bio::Variation::RNAChange>, L<Bio::Variation::RNAChange>,\nL<Bio::Variation::SeqDiff>, and L<Bio::Variation::DNAMutation>.\n\n\nsub _set_effects {\n    my ($self, $seqDiff, $dnamut) = @_;\n    my ($rnapos_end, $upstreamseq, $dnstreamseq);\n    my $flanklen = $self->{'flanklen'};\n\n    ($self->mutation->len == 0) ?\n\t($rnapos_end = $self->mutation->transpos) :\n\t($rnapos_end = $self->mutation->transpos + $self->mutation->len -1);\n    my $rnachange = Bio::Variation::RNAChange->new(-start => $self->mutation->transpos,\n\t\t\t\t\t\t    -end =>  $rnapos_end\n\t\t\t\t\t\t    );\n    $rnachange->isMutation(1);\n\n    # setting proof\n    if ($seqDiff->numbering eq \"coding\") {\n\t $rnachange->proof('experimental');\n    } else {\n\t $rnachange->proof('computed');\n    }\n\n    $seqDiff->add_Variant($rnachange);\n    $self->rnachange($rnachange);\n    $rnachange->DNAMutation($dnamut);\n    $dnamut->RNAChange($rnachange);\n    $rnachange->mut_number($self->mutation->issue);\n\n    # setting the codon_position of the \"start\" nucleotide of the change\n    $rnachange->codon_pos(($self->RNA->frame($self->mutation->label))+1); # codon_pos=frame+1\n\n    my @exons=$self->RNA->all_Exons;\n    $self->exons(\\@exons);\n    #print  `date`, \" before flank, after exons. RNAObj query\\n\";\n    # if cannot retrieve from Transcript, Transcript::upstream_seq will be used\n    # before \"fac7 g 65\" bug discovered\n    # $uplabel=$self->RNA->label(1-$flanklen,$prelabel);\n    my $RNAprelabel=$self->RNA->label(-1,$self->mutation->label); # to fix fac7g65 bug\n    # for the fix, all prelabel used in the next block have been changed to RNAprelabel\n    my $uplabel=$self->RNA->label(1-$flanklen,$RNAprelabel);\n    if ($self->RNA->valid($uplabel)) {\n\t $upstreamseq = $self->RNA->labelsubseq($uplabel, undef, $RNAprelabel);\n    } else {\n\t$upstreamseq = $self->RNA->labelsubseq($self->RNA->start, undef, $RNAprelabel)\n\t    if $self->RNA->valid($RNAprelabel);\n\tmy $lacking=$flanklen-length($upstreamseq); # how many missing\n\tmy $upstream_atg=$exons[0]->subseq(-$lacking,-1);\n\t$upstreamseq=$upstream_atg . $upstreamseq;\n    }\n\n    $rnachange->upStreamSeq($upstreamseq);\n\n    # won't work OK if postlabel NOT in Transcript\n    # now added RNApostlabel but this has to be /fully tested/\n    # for the fix, all postlabel used in the next block have been changed to RNApostlabel\n    my $RNApostlabel; # to fix fac7g64 bug\n    if ($self->mutation->len == 0) {\n      $RNApostlabel=$self->mutation->label;\n    } else {\n      my $mutlen = 1 + $self->mutation->len;\n      $RNApostlabel=$self->RNA->label($mutlen,$self->mutation->label);\n    }\n    $dnstreamseq=$self->RNA->labelsubseq($RNApostlabel, $flanklen);\n    if ($dnstreamseq eq '-1') { # if out of transcript was requested\n\t my $lastexon=$exons[-1];\n\t my $lastexonlength=$lastexon->length;\n\t $dnstreamseq=$self->RNA->labelsubseq($RNApostlabel); # retrieves till RNAend\n\t my $lacking=$flanklen-length($dnstreamseq); # how many missing\n\t my $downstream_stop=$lastexon->subseq($lastexonlength+1,undef,$lacking);\n\t $dnstreamseq .= $downstream_stop;\n    } else {\n\t $rnachange->dnStreamSeq($dnstreamseq);\n    }\n    # AAChange creation\n    my $AAobj=$self->RNA->get_Translation;\n    # storage of prelabel here, to be used in create_mut_objs_after\n    my $aachange = Bio::Variation::AAChange->new(-start => $RNAprelabel\n\t\t\t\t\t\t  );\n    $aachange->isMutation(1);\n    $aachange->proof('computed');\n\n    $seqDiff->add_Variant($aachange);\n    $self->aachange($aachange);\n    $rnachange->AAChange($aachange);\n    $aachange->RNAChange($rnachange);\n\n    $aachange->mut_number($self->mutation->issue);\n#    $before_mutation{aachange}=$aachange;\n\n    my $ra_o = Bio::Variation::Allele->new;\n    $ra_o->seq($dnamut->allele_ori->seq) if $dnamut->allele_ori->seq;\n    $rnachange->allele_ori($ra_o);\n\n    $rnachange->length(CORE::length $rnachange->allele_ori->seq);\n\n    my $ra_m = Bio::Variation::Allele->new;\n    $ra_m->seq($self->mutation->seq) if $self->mutation->seq;\n    $rnachange->allele_mut($ra_m);\n    $rnachange->add_Allele($ra_m);\n\n    #$rnachange->allele_mut($seq);\n    $rnachange->end($rnachange->start) if $rnachange->length == 0;\n\n    # this holds the aminoacid sequence that will be affected by the mutation\n    my $aa_allele_ori=$AAobj->labelsubseq($self->mutation->label,undef, \n\t\t\t\t\t  $self->mutation->lastlabel);\n\n    my $aa_o = Bio::Variation::Allele->new;\n    $aa_o->seq($aa_allele_ori) if $aa_allele_ori;\n    $aachange->allele_ori($aa_o);\n    #$aachange->allele_ori($aa_allele_ori);\n\n    my $aa_length_ori = length($aa_allele_ori);\n    $aachange->length($aa_length_ori); #print \"==========$aa_length_ori\\n\";\n    $aachange->end($aachange->start + $aa_length_ori - 1 );\n}\n\n=head2 _untranslated\n\n Title   : _untranslated\n Usage   :\n Function:\n\n           Stores RNA change attributes before mutation\n           into Bio::Variation::RNAChange object.  Links it to\n           SeqDiff object.\n\n Example :\n Returns :\n Args    : Bio::Variation::SeqDiff object\n           Bio::Variation::DNAMutation object\n\nSee L<Bio::Variation::RNAChange>, L<Bio::Variation::SeqDiff> and\nL<Bio::Variation::DNAMutation> for details."}},{"line":1287,"containerName":"Variation::RNAChange","kind":12,"name":"Bio"},{"name":"Bio","kind":12,"containerName":"Variation::Allele","line":1293},{"line":1296,"kind":12,"containerName":"Variation::Allele","name":"Bio"},{"signature":{"documentation":" args: reference to label changearray, reference to position changearray\n Function: take care of the creation of mutation objects, with\n information AFTER the change takes place","parameters":[{"label":"$self"},{"label":"$seqDiff"}],"label":"_post_mutation($self,$seqDiff)"},"range":{"start":{"line":1338,"character":0},"end":{"character":9999,"line":1444}},"kind":12,"line":1338,"detail":"($self,$seqDiff)","definition":"sub","name":"_post_mutation","containerName":"main::","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"_post_mutation","kind":13,"line":1339},{"name":"$seqDiff","containerName":"_post_mutation","kind":13,"line":1339},{"line":1341,"name":"$self","kind":13,"containerName":"_post_mutation"},{"line":1341,"name":"rnachange","containerName":"_post_mutation","kind":12},{"line":1341,"name":"$self","containerName":"_post_mutation","kind":13},{"line":1341,"name":"rnachange","kind":12,"containerName":"_post_mutation"},{"line":1341,"name":"region","containerName":"_post_mutation","kind":12},{"definition":"my","line":1345,"name":"$aachange","containerName":"_post_mutation","localvar":"my","kind":13},{"line":1345,"kind":13,"containerName":"_post_mutation","name":"$self"},{"line":1345,"containerName":"_post_mutation","kind":12,"name":"aachange"},{"line":1346,"name":"$AAobj","containerName":"_post_mutation","localvar":"my","kind":13,"definition":"my"},{"containerName":"_post_mutation","kind":13,"name":"$aa_start_prelabel","line":1346},{"line":1346,"kind":13,"containerName":"_post_mutation","name":"$aa_start"},{"line":1346,"containerName":"_post_mutation","kind":13,"name":"$mut_translation"},{"kind":13,"containerName":"_post_mutation","name":"$AAobj","line":1347},{"kind":13,"containerName":"_post_mutation","name":"$self","line":1347},{"line":1347,"name":"RNA","kind":12,"containerName":"_post_mutation"},{"name":"get_Translation","containerName":"_post_mutation","kind":12,"line":1347},{"line":1348,"name":"$aa_start_prelabel","containerName":"_post_mutation","kind":13},{"line":1348,"containerName":"_post_mutation","kind":13,"name":"$aachange"},{"kind":12,"containerName":"_post_mutation","name":"start","line":1348},{"name":"$aa_start","kind":13,"containerName":"_post_mutation","line":1349},{"line":1349,"name":"$AAobj","kind":13,"containerName":"_post_mutation"},{"line":1349,"name":"position","containerName":"_post_mutation","kind":12},{"line":1349,"name":"$self","kind":13,"containerName":"_post_mutation"},{"line":1349,"name":"RNA","containerName":"_post_mutation","kind":12},{"line":1349,"name":"label","containerName":"_post_mutation","kind":12},{"line":1349,"containerName":"_post_mutation","kind":13,"name":"$aa_start_prelabel"},{"containerName":"_post_mutation","kind":13,"name":"$aachange","line":1350},{"line":1350,"kind":12,"containerName":"_post_mutation","name":"start"},{"kind":13,"containerName":"_post_mutation","name":"$aa_start","line":1350},{"line":1351,"kind":13,"containerName":"_post_mutation","name":"$mut_translation"},{"line":1351,"name":"$AAobj","containerName":"_post_mutation","kind":13},{"name":"seq","kind":12,"containerName":"_post_mutation","line":1351},{"containerName":"_post_mutation","localvar":"my","kind":13,"name":"$aa_m","line":1354,"definition":"my"},{"containerName":"_post_mutation","kind":12,"name":"new","line":1354},{"line":1355,"kind":13,"containerName":"_post_mutation","name":"$aa_m"},{"line":1355,"containerName":"_post_mutation","kind":12,"name":"seq"},{"name":"$mut_translation","kind":13,"containerName":"_post_mutation","line":1355},{"containerName":"_post_mutation","kind":13,"name":"$aa_start","line":1355},{"containerName":"_post_mutation","kind":13,"name":"$mut_translation","line":1355},{"line":1355,"name":"$aa_start","containerName":"_post_mutation","kind":13},{"containerName":"_post_mutation","kind":13,"name":"$aachange","line":1356},{"line":1356,"kind":12,"containerName":"_post_mutation","name":"allele_mut"},{"line":1356,"name":"$aa_m","kind":13,"containerName":"_post_mutation"},{"name":"$aachange","kind":13,"containerName":"_post_mutation","line":1357},{"name":"add_Allele","kind":12,"containerName":"_post_mutation","line":1357},{"line":1357,"name":"$aa_m","kind":13,"containerName":"_post_mutation"},{"definition":"my","line":1360,"localvar":"my","kind":13,"containerName":"_post_mutation","name":"$rlenori"},{"line":1360,"name":"$rlenmut","kind":13,"containerName":"_post_mutation"},{"line":1361,"kind":13,"containerName":"_post_mutation","name":"$rlenori"},{"line":1361,"name":"$aachange","kind":13,"containerName":"_post_mutation"},{"line":1361,"name":"RNAChange","kind":12,"containerName":"_post_mutation"},{"line":1361,"name":"allele_ori","kind":12,"containerName":"_post_mutation"},{"line":1361,"name":"seq","containerName":"_post_mutation","kind":12},{"line":1362,"kind":13,"containerName":"_post_mutation","name":"$rlenmut"},{"line":1362,"containerName":"_post_mutation","kind":13,"name":"$aachange"},{"line":1362,"kind":12,"containerName":"_post_mutation","name":"RNAChange"},{"kind":12,"containerName":"_post_mutation","name":"allele_mut","line":1362},{"name":"seq","kind":12,"containerName":"_post_mutation","line":1362},{"containerName":"_post_mutation","kind":13,"name":"$rlenori","line":1365},{"containerName":"_post_mutation","kind":13,"name":"$rlenmut","line":1365},{"line":1365,"name":"$aachange","kind":13,"containerName":"_post_mutation"},{"line":1365,"containerName":"_post_mutation","kind":12,"name":"allele_ori"},{"line":1365,"name":"seq","containerName":"_post_mutation","kind":12},{"definition":"my","line":1366,"kind":13,"localvar":"my","containerName":"_post_mutation","name":"$alleleseq"},{"line":1367,"containerName":"_post_mutation","kind":13,"name":"$aachange"},{"containerName":"_post_mutation","kind":12,"name":"allele_mut","line":1367},{"line":1367,"kind":12,"containerName":"_post_mutation","name":"seq"},{"containerName":"_post_mutation","kind":13,"name":"$alleleseq","line":1368},{"line":1368,"name":"$aachange","kind":13,"containerName":"_post_mutation"},{"containerName":"_post_mutation","kind":12,"name":"allele_mut","line":1368},{"kind":12,"containerName":"_post_mutation","name":"seq","line":1368},{"line":1369,"kind":13,"containerName":"_post_mutation","name":"$aachange"},{"line":1369,"kind":12,"containerName":"_post_mutation","name":"allele_mut"},{"name":"seq","containerName":"_post_mutation","kind":12,"line":1369},{"line":1369,"name":"$alleleseq","containerName":"_post_mutation","kind":13},{"name":"$aachange","containerName":"_post_mutation","kind":13,"line":1371},{"name":"end","kind":12,"containerName":"_post_mutation","line":1371},{"line":1371,"name":"$aachange","kind":13,"containerName":"_post_mutation"},{"name":"start","kind":12,"containerName":"_post_mutation","line":1371},{"name":"$aachange","containerName":"_post_mutation","kind":13,"line":1372},{"line":1372,"kind":12,"containerName":"_post_mutation","name":"length"},{"name":"$rlenori","containerName":"_post_mutation","kind":13,"line":1374},{"line":1374,"name":"$rlenmut","containerName":"_post_mutation","kind":13},{"line":1375,"name":"$aachange","containerName":"_post_mutation","kind":13},{"name":"allele_ori","containerName":"_post_mutation","kind":12,"line":1375},{"kind":12,"containerName":"_post_mutation","name":"seq","line":1375},{"kind":13,"containerName":"_post_mutation","name":"$aachange","line":1376},{"name":"allele_mut","kind":12,"containerName":"_post_mutation","line":1376},{"name":"seq","containerName":"_post_mutation","kind":12,"line":1376},{"kind":13,"containerName":"_post_mutation","name":"$aachange","line":1376},{"name":"allele_mut","containerName":"_post_mutation","kind":12,"line":1376},{"line":1376,"name":"seq","kind":12,"containerName":"_post_mutation"},{"kind":13,"containerName":"_post_mutation","name":"$aachange","line":1378},{"line":1378,"name":"allele_ori","containerName":"_post_mutation","kind":12},{"line":1378,"kind":12,"containerName":"_post_mutation","name":"seq"},{"line":1381,"name":"$rlenori","containerName":"_post_mutation","kind":13},{"line":1381,"name":"$rlenmut","kind":13,"containerName":"_post_mutation"},{"line":1381,"containerName":"_post_mutation","kind":13,"name":"%3"},{"line":1382,"containerName":"_post_mutation","kind":13,"name":"$aachange"},{"line":1382,"name":"RNAChange","containerName":"_post_mutation","kind":12},{"containerName":"_post_mutation","kind":12,"name":"allele_mut","line":1382},{"line":1382,"name":"seq","kind":12,"containerName":"_post_mutation"},{"line":1383,"kind":13,"containerName":"_post_mutation","name":"$aachange"},{"line":1383,"kind":12,"containerName":"_post_mutation","name":"RNAChange"},{"line":1383,"kind":12,"containerName":"_post_mutation","name":"allele_ori"},{"line":1383,"name":"seq","kind":12,"containerName":"_post_mutation"},{"line":1385,"name":"$rna_len","localvar":"my","kind":13,"containerName":"_post_mutation","definition":"my"},{"line":1385,"name":"$aachange","kind":13,"containerName":"_post_mutation"},{"line":1385,"name":"RNAChange","kind":12,"containerName":"_post_mutation"},{"name":"allele_mut","containerName":"_post_mutation","kind":12,"line":1385},{"kind":12,"containerName":"_post_mutation","name":"seq","line":1385},{"name":"$len","kind":13,"localvar":"my","containerName":"_post_mutation","line":1386,"definition":"my"},{"line":1386,"name":"$rna_len","containerName":"_post_mutation","kind":13},{"name":"$len","kind":13,"containerName":"_post_mutation","line":1387},{"kind":13,"containerName":"_post_mutation","name":"$rna_len","line":1387},{"containerName":"_post_mutation","kind":13,"name":"%3","line":1387},{"line":1388,"name":"$aachange","kind":13,"containerName":"_post_mutation"},{"line":1388,"name":"allele_mut","kind":12,"containerName":"_post_mutation"},{"name":"seq","kind":12,"containerName":"_post_mutation","line":1388},{"containerName":"_post_mutation","kind":13,"name":"$aachange","line":1388},{"line":1388,"containerName":"_post_mutation","kind":12,"name":"allele_mut"},{"name":"seq","kind":12,"containerName":"_post_mutation","line":1388},{"containerName":"_post_mutation","kind":13,"name":"$len","line":1388},{"line":1390,"containerName":"_post_mutation","kind":13,"name":"$aachange"},{"kind":12,"containerName":"_post_mutation","name":"RNAChange","line":1390},{"line":1390,"kind":12,"containerName":"_post_mutation","name":"codon_pos"},{"name":"$aachange","containerName":"_post_mutation","kind":13,"line":1392},{"name":"RNAChange","containerName":"_post_mutation","kind":12,"line":1392},{"kind":12,"containerName":"_post_mutation","name":"allele_mut","line":1392},{"containerName":"_post_mutation","kind":12,"name":"seq","line":1392},{"line":1393,"name":"$aachange","kind":13,"containerName":"_post_mutation"},{"name":"allele_mut","containerName":"_post_mutation","kind":12,"line":1393},{"line":1393,"name":"seq","kind":12,"containerName":"_post_mutation"},{"line":1394,"kind":13,"containerName":"_post_mutation","name":"$aachange"},{"name":"end","kind":12,"containerName":"_post_mutation","line":1394},{"line":1394,"name":"$aachange","containerName":"_post_mutation","kind":13},{"line":1394,"name":"start","containerName":"_post_mutation","kind":12},{"line":1394,"name":"$aachange","containerName":"_post_mutation","kind":13},{"name":"length","kind":12,"containerName":"_post_mutation","line":1394},{"line":1397,"name":"$aachange","kind":13,"containerName":"_post_mutation"},{"line":1397,"kind":12,"containerName":"_post_mutation","name":"RNAChange"},{"line":1397,"containerName":"_post_mutation","kind":12,"name":"allele_ori"},{"kind":12,"containerName":"_post_mutation","name":"seq","line":1397},{"name":"$aachange","containerName":"_post_mutation","kind":13,"line":1398},{"name":"allele_mut","containerName":"_post_mutation","kind":12,"line":1398},{"line":1398,"name":"seq","containerName":"_post_mutation","kind":12},{"name":"$aachange","containerName":"_post_mutation","kind":13,"line":1398},{"line":1398,"name":"allele_mut","kind":12,"containerName":"_post_mutation"},{"kind":12,"containerName":"_post_mutation","name":"seq","line":1398},{"kind":13,"containerName":"_post_mutation","name":"$aachange","line":1399},{"line":1399,"name":"RNAChange","containerName":"_post_mutation","kind":12},{"kind":12,"containerName":"_post_mutation","name":"allele_mut","line":1399},{"name":"seq","containerName":"_post_mutation","kind":12,"line":1399},{"name":"$aachange","kind":13,"containerName":"_post_mutation","line":1400},{"line":1400,"kind":12,"containerName":"_post_mutation","name":"allele_ori"},{"name":"seq","containerName":"_post_mutation","kind":12,"line":1400},{"line":1401,"kind":13,"containerName":"_post_mutation","name":"$aachange"},{"line":1401,"name":"end","containerName":"_post_mutation","kind":12},{"line":1401,"kind":13,"containerName":"_post_mutation","name":"$aachange"},{"containerName":"_post_mutation","kind":12,"name":"start","line":1401},{"containerName":"_post_mutation","kind":13,"name":"$aachange","line":1401},{"line":1401,"name":"length","containerName":"_post_mutation","kind":12},{"line":1402,"name":"$aachange","containerName":"_post_mutation","kind":13},{"kind":12,"containerName":"_post_mutation","name":"length","line":1402},{"kind":13,"containerName":"_post_mutation","name":"$aachange","line":1407},{"kind":12,"containerName":"_post_mutation","name":"RNAChange","line":1407},{"line":1407,"name":"allele_mut","kind":12,"containerName":"_post_mutation"},{"name":"seq","kind":12,"containerName":"_post_mutation","line":1407},{"line":1408,"kind":13,"containerName":"_post_mutation","name":"$aachange"},{"line":1408,"containerName":"_post_mutation","kind":12,"name":"allele_mut"},{"line":1408,"name":"seq","kind":12,"containerName":"_post_mutation"},{"line":1408,"kind":13,"containerName":"_post_mutation","name":"$aachange"},{"line":1408,"name":"allele_mut","containerName":"_post_mutation","kind":12},{"name":"seq","kind":12,"containerName":"_post_mutation","line":1408},{"name":"$aachange","kind":13,"containerName":"_post_mutation","line":1411},{"line":1411,"kind":12,"containerName":"_post_mutation","name":"RNAChange"},{"containerName":"_post_mutation","kind":12,"name":"allele_ori","line":1411},{"name":"seq","kind":12,"containerName":"_post_mutation","line":1411},{"line":1412,"kind":13,"containerName":"_post_mutation","name":"$aachange"},{"line":1412,"containerName":"_post_mutation","kind":12,"name":"allele_mut"},{"name":"seq","kind":12,"containerName":"_post_mutation","line":1412},{"line":1412,"name":"$aachange","kind":13,"containerName":"_post_mutation"},{"kind":12,"containerName":"_post_mutation","name":"allele_mut","line":1412},{"line":1412,"containerName":"_post_mutation","kind":12,"name":"seq"},{"line":1413,"containerName":"_post_mutation","kind":13,"name":"$aachange"},{"line":1413,"kind":12,"containerName":"_post_mutation","name":"RNAChange"},{"containerName":"_post_mutation","kind":12,"name":"allele_mut","line":1413},{"line":1413,"containerName":"_post_mutation","kind":12,"name":"seq"},{"line":1420,"name":"$aachange","kind":13,"containerName":"_post_mutation"},{"kind":12,"containerName":"_post_mutation","name":"length","line":1420},{"line":1420,"containerName":"_post_mutation","kind":13,"name":"$aachange"},{"line":1420,"name":"allele_ori","kind":12,"containerName":"_post_mutation"},{"line":1420,"containerName":"_post_mutation","kind":12,"name":"seq"},{"name":"$aaend","localvar":"my","kind":13,"containerName":"_post_mutation","line":1421,"definition":"my"},{"kind":13,"containerName":"_post_mutation","name":"$aachange","line":1421},{"kind":12,"containerName":"_post_mutation","name":"start","line":1421},{"line":1421,"name":"$aachange","kind":13,"containerName":"_post_mutation"},{"containerName":"_post_mutation","kind":12,"name":"length","line":1421},{"name":"$aachange","containerName":"_post_mutation","kind":13,"line":1422},{"containerName":"_post_mutation","kind":12,"name":"end","line":1422},{"name":"$aachange","kind":13,"containerName":"_post_mutation","line":1422},{"name":"start","kind":12,"containerName":"_post_mutation","line":1422},{"definition":"my","line":1426,"name":"@beforeexons","localvar":"my","kind":13,"containerName":"_post_mutation"},{"line":1426,"kind":13,"containerName":"_post_mutation","name":"$self"},{"containerName":"_post_mutation","kind":12,"name":"exons","line":1426},{"definition":"my","name":"@afterexons","localvar":"my","containerName":"_post_mutation","kind":13,"line":1427},{"containerName":"_post_mutation","kind":13,"name":"$self","line":1427},{"line":1427,"name":"RNA","kind":12,"containerName":"_post_mutation"},{"kind":12,"containerName":"_post_mutation","name":"all_Exons","line":1427},{"line":1428,"localvar":"my","kind":13,"containerName":"_post_mutation","name":"$i","definition":"my"},{"line":1429,"name":"@beforeexons","kind":13,"containerName":"_post_mutation"},{"containerName":"_post_mutation","kind":13,"name":"@afterexons","line":1429},{"kind":13,"localvar":"my","containerName":"_post_mutation","name":"$mut_number","line":1430,"definition":"my"},{"line":1430,"containerName":"_post_mutation","kind":13,"name":"$self"},{"line":1430,"name":"mutation","kind":12,"containerName":"_post_mutation"},{"name":"issue","containerName":"_post_mutation","kind":12,"line":1430},{"name":"$self","kind":13,"containerName":"_post_mutation","line":1431},{"name":"warn","containerName":"_post_mutation","kind":12,"line":1431},{"line":1432,"name":"$self","containerName":"_post_mutation","kind":13},{"containerName":"_post_mutation","kind":12,"name":"rnachange","line":1432},{"line":1432,"name":"exons_modified","containerName":"_post_mutation","kind":12},{"line":1435,"kind":13,"containerName":"_post_mutation","name":"$i"},{"line":1436,"kind":13,"containerName":"_post_mutation","name":"$beforeexons"},{"kind":13,"containerName":"_post_mutation","name":"$i","line":1436},{"name":"$afterexons","kind":13,"containerName":"_post_mutation","line":1436},{"line":1436,"name":"$i","kind":13,"containerName":"_post_mutation"},{"definition":"my","line":1437,"localvar":"my","kind":13,"containerName":"_post_mutation","name":"$mut_number"},{"name":"$self","kind":13,"containerName":"_post_mutation","line":1437},{"line":1437,"kind":12,"containerName":"_post_mutation","name":"mutation"},{"line":1437,"containerName":"_post_mutation","kind":12,"name":"issue"},{"line":1438,"kind":13,"containerName":"_post_mutation","name":"$self"},{"line":1438,"kind":12,"containerName":"_post_mutation","name":"warn"},{"kind":13,"containerName":"_post_mutation","name":"$self","line":1439},{"name":"rnachange","containerName":"_post_mutation","kind":12,"line":1439},{"kind":12,"containerName":"_post_mutation","name":"exons_modified","line":1439}]},{"kind":12,"containerName":"Variation::Allele","name":"Bio","line":1354},{"containerName":"length","kind":12,"name":"CORE","line":1361},{"line":1362,"name":"CORE","kind":12,"containerName":"length"},{"name":"CORE","containerName":"length","kind":12,"line":1420},{"kind":12,"name":"EXONCHECK","line":1434},{"line":1435,"name":"beforeexons","kind":12},{"name":"EXONCHECK","kind":12,"line":1440}]}