{"version":5,"vars":[{"kind":2,"containerName":"","name":"Carp","line":44},{"signature":{"documentation":"1;\n# $Id: Loader.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::IO::Loader\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::IO::Loader - Parent Loader for LiveSeq\n\n=head1 SYNOPSIS\n\n  #documentation needed\n\n=head1 DESCRIPTION\n\nThis package holds common methods used by BioPerl and file loaders.\nIt contains methods to create LiveSeq objects out of entire entries or from a\nlocalized sequence region surrounding a particular gene.\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::IO::Loader;\n\nuse strict;\nuse Carp qw(cluck croak carp);\nuse Bio::LiveSeq::DNA;\nuse Bio::LiveSeq::Exon;\nuse Bio::LiveSeq::Transcript ;\nuse Bio::LiveSeq::Translation;\nuse Bio::LiveSeq::Gene;\nuse Bio::LiveSeq::Intron;\nuse Bio::LiveSeq::Prim_Transcript;\nuse Bio::LiveSeq::Repeat_Region;\nuse Bio::LiveSeq::Repeat_Unit;\nuse Bio::LiveSeq::AARange;\nuse Bio::Tools::CodonTable;\n\n=head2 entry2liveseq\n\n  Title   : entry2liveseq\n  Usage   : @translationobjects=$loader->entry2liveseq();\n          : @translationobjects=$loader->entry2liveseq(-getswissprotinfo => 0);\n  Function: creates LiveSeq objects from an entry previously loaded\n  Returns : array of references to objects of class Translation\n  Errorcode 0\n  Args    : optional boolean flag to avoid the retrieval of SwissProt\n            informations for all Transcripts containing SwissProt x-reference\n            default is 1 (to retrieve those informations and create AARange\n            LiveSeq objects)\n  Note    : this method can get really slow for big entries. The lightweight\n            gene2liveseq method is recommended","parameters":[{"label":"$self"},{"label":"%args"}],"label":"entry2liveseq($self,%args)"},"kind":12,"range":{"end":{"line":91,"character":9999},"start":{"character":0,"line":74}},"line":74,"detail":"($self,%args)","definition":"sub","name":"entry2liveseq","containerName":"main::","children":[{"localvar":"my","kind":13,"containerName":"entry2liveseq","name":"$self","line":75,"definition":"my"},{"name":"%args","containerName":"entry2liveseq","kind":13,"line":75},{"name":"$getswissprotinfo","containerName":"entry2liveseq","localvar":"my","kind":13,"line":76,"definition":"my"},{"line":76,"containerName":"entry2liveseq","kind":13,"name":"$args"},{"name":"$getswissprotinfo","containerName":"entry2liveseq","kind":13,"line":77},{"line":78,"name":"$getswissprotinfo","containerName":"entry2liveseq","kind":13},{"name":"$getswissprotinfo","kind":13,"containerName":"entry2liveseq","line":78},{"line":80,"name":"$getswissprotinfo","kind":13,"containerName":"entry2liveseq"},{"name":"$getswissprotinfo","containerName":"entry2liveseq","kind":13,"line":83},{"definition":"my","name":"$hashref","localvar":"my","containerName":"entry2liveseq","kind":13,"line":85},{"name":"$self","containerName":"entry2liveseq","kind":13,"line":85},{"line":86,"containerName":"entry2liveseq","kind":13,"name":"$hashref"},{"line":87,"name":"@translationobjects","localvar":"my","containerName":"entry2liveseq","kind":13,"definition":"my"},{"line":87,"name":"$self","containerName":"entry2liveseq","kind":13},{"kind":12,"containerName":"entry2liveseq","name":"hash2liveseq","line":87},{"name":"$hashref","kind":13,"containerName":"entry2liveseq","line":87},{"containerName":"entry2liveseq","kind":13,"name":"$getswissprotinfo","line":87},{"localvar":"my","kind":13,"containerName":"entry2liveseq","name":"$test_transl","line":88,"definition":"my"},{"line":89,"kind":13,"containerName":"entry2liveseq","name":"$test_transl"},{"containerName":"entry2liveseq","kind":13,"name":"$self","line":89},{"kind":12,"containerName":"entry2liveseq","name":"test_transl","line":89},{"line":89,"name":"$hashref","kind":13,"containerName":"entry2liveseq"},{"line":89,"name":"@translationobjects","containerName":"entry2liveseq","kind":13},{"kind":13,"containerName":"entry2liveseq","name":"@translationobjects","line":90}]},{"line":75,"containerName":"Bio::LiveSeq::DNA::Bio::LiveSeq::Exon::Bio::LiveSeq::Transcript::Bio::LiveSeq::Translation::Bio::LiveSeq::Gene::Bio::LiveSeq::Intron::Bio::LiveSeq::Prim_Transcript::Bio::LiveSeq::Repeat_Region::Bio::LiveSeq::Repeat_Unit::Bio::LiveSeq::AARange::Bio::Tools","kind":2,"name":"CodonTable"},{"line":79,"kind":12,"name":"carp"},{"signature":{"parameters":[{"label":"$self"},{"label":"%args"}],"documentation":"1;\n# $Id: Loader.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::IO::Loader\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::IO::Loader - Parent Loader for LiveSeq\n\n=head1 SYNOPSIS\n\n  #documentation needed\n\n=head1 DESCRIPTION\n\nThis package holds common methods used by BioPerl and file loaders.\nIt contains methods to create LiveSeq objects out of entire entries or from a\nlocalized sequence region surrounding a particular gene.\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::IO::Loader;\n\nuse strict;\nuse Carp qw(cluck croak carp);\nuse Bio::LiveSeq::DNA;\nuse Bio::LiveSeq::Exon;\nuse Bio::LiveSeq::Transcript ;\nuse Bio::LiveSeq::Translation;\nuse Bio::LiveSeq::Gene;\nuse Bio::LiveSeq::Intron;\nuse Bio::LiveSeq::Prim_Transcript;\nuse Bio::LiveSeq::Repeat_Region;\nuse Bio::LiveSeq::Repeat_Unit;\nuse Bio::LiveSeq::AARange;\nuse Bio::Tools::CodonTable;\n\n=head2 entry2liveseq\n\n  Title   : entry2liveseq\n  Usage   : @translationobjects=$loader->entry2liveseq();\n          : @translationobjects=$loader->entry2liveseq(-getswissprotinfo => 0);\n  Function: creates LiveSeq objects from an entry previously loaded\n  Returns : array of references to objects of class Translation\n  Errorcode 0\n  Args    : optional boolean flag to avoid the retrieval of SwissProt\n            informations for all Transcripts containing SwissProt x-reference\n            default is 1 (to retrieve those informations and create AARange\n            LiveSeq objects)\n  Note    : this method can get really slow for big entries. The lightweight\n            gene2liveseq method is recommended\n\n\nsub entry2liveseq {\n  my ($self, %args) = @_;\n  my ($getswissprotinfo)=($args{-getswissprotinfo});\n  if (defined($getswissprotinfo)) {\n    if (($getswissprotinfo ne 0)&&($getswissprotinfo ne 1)) {\n      carp \"-getswissprotinfo argument can take only boolean (1 or 0) values. Setting it to 0, i.e. not trying to retrieve SwissProt information....\";\n      $getswissprotinfo=0;\n    }\n  } else {\n    $getswissprotinfo=1;\n  }\n  my $hashref=$self->{'hash'};\n  unless ($hashref) { return (0); }\n  my @translationobjects=$self->hash2liveseq($hashref,$getswissprotinfo);\n  my $test_transl=0;\n  if ($test_transl) { $self->test_transl($hashref,\\@translationobjects);}\n  return @translationobjects;\n}\n\n=head2 novelaasequence2gene\n\n  Title   : novelaasequence2gene\n  Usage   : $gene=$loader->novelaasequence2gene(-aasequence => \"MGLAAPTRS*\");\n          : $gene=$loader->novelaasequence2gene(-aasequence => \"MGLAAPTRS*\");\n                                             -taxon => 9606,\n                                             -gene_name => \"tyr-kinase\");\n\n  Function: creates LiveSeq objects from a novel amino acid sequence,\n            using codon usage database to choose codons according to\n            relative frequencies.\n            If a taxon ID is not specified, the default is to use the human\n            one (taxonomy ID 9606).\n  Returns : reference to a Gene object containing references to LiveSeq objects\n  Errorcode 0\n  Args    : string containing an amino acid sequence\n            integer (optional) with a taxonomy ID\n            string specifying a gene name\n\n\n=head2 gene2liveseq\n\n  Title   : gene2liveseq\n  Usage   : $gene=$loader->gene2liveseq(-gene_name => \"gene name\");\n          : $gene=$loader->gene2liveseq(-gene_name => \"gene name\",\n                                        -flanking => 64);\n          : $gene=$loader->gene2liveseq(-gene_name => \"gene name\",\n                                        -getswissprotinfo => 0);\n          : $gene=$loader->gene2liveseq(-position => 4);\n\n  Function: creates LiveSeq objects from an entry previously loaded\n            It is a \"light weight\" creation because it creates\n            a LiveSequence just for the interesting region in an entry\n            (instead than for the total entry, like in entry2liveseq) and for\n            the flanking regions up to 500 nucleotides (default) or up to\n            the specified amount of nucleotides (given as argument) around the\n            Gene.\n  Returns : reference to a Gene object containing possibly alternative\n            Transcripts.\n  Errorcode 0\n  Args    : string containing the gene name as in the EMBL feature qualifier\n            integer (optional) \"flanking\": amount of flanking bases to be kept\n            boolean (optional) \"getswissprotinfo\": if set to \"0\" it will avoid\n             trying to fetch information from a crossreference to a SwissProt\n             entry, avoding the process of creation of AARange objects\n             It is \"1\" (on) by default\n\n            Alternative to a gene_name, a position can be given: an\n            integer (1-) containing the position of the desired CDS in the\n            loaded entry","label":"gene2liveseq($self,%args)"},"kind":12,"range":{"end":{"line":189,"character":9999},"start":{"line":147,"character":0}},"line":147,"detail":"($self,%args)","definition":"sub","name":"gene2liveseq","containerName":"main::","children":[{"definition":"my","line":148,"name":"$self","localvar":"my","kind":13,"containerName":"gene2liveseq"},{"line":148,"containerName":"gene2liveseq","kind":13,"name":"%args"},{"localvar":"my","containerName":"gene2liveseq","kind":13,"name":"$gene_name","line":149,"definition":"my"},{"line":149,"name":"$flanking","kind":13,"containerName":"gene2liveseq"},{"line":149,"name":"$getswissprotinfo","kind":13,"containerName":"gene2liveseq"},{"name":"$cds_position","containerName":"gene2liveseq","kind":13,"line":149},{"line":149,"containerName":"gene2liveseq","kind":13,"name":"$args"},{"line":149,"kind":13,"containerName":"gene2liveseq","name":"$args"},{"name":"$args","containerName":"gene2liveseq","kind":13,"line":149},{"containerName":"gene2liveseq","kind":13,"name":"$args","line":149},{"definition":"my","line":150,"localvar":"my","kind":13,"containerName":"gene2liveseq","name":"$input"},{"kind":13,"containerName":"gene2liveseq","name":"$gene_name","line":151},{"name":"$cds_position","containerName":"gene2liveseq","kind":13,"line":151},{"containerName":"gene2liveseq","kind":13,"name":"$gene_name","line":155},{"name":"$cds_position","containerName":"gene2liveseq","kind":13,"line":155},{"line":158,"name":"$gene_name","containerName":"gene2liveseq","kind":13},{"line":159,"name":"$input","containerName":"gene2liveseq","kind":13},{"line":159,"name":"$gene_name","containerName":"gene2liveseq","kind":13},{"line":161,"name":"$input","containerName":"gene2liveseq","kind":13},{"kind":13,"containerName":"gene2liveseq","name":"$cds_position","line":161},{"kind":13,"containerName":"gene2liveseq","name":"$getswissprotinfo","line":164},{"line":165,"kind":13,"containerName":"gene2liveseq","name":"$getswissprotinfo"},{"containerName":"gene2liveseq","kind":13,"name":"$getswissprotinfo","line":165},{"name":"$getswissprotinfo","containerName":"gene2liveseq","kind":13,"line":167},{"name":"$getswissprotinfo","kind":13,"containerName":"gene2liveseq","line":170},{"line":173,"containerName":"gene2liveseq","kind":13,"name":"$flanking"},{"containerName":"gene2liveseq","kind":13,"name":"$flanking","line":174},{"line":179,"containerName":"gene2liveseq","kind":13,"name":"$flanking"},{"definition":"my","line":181,"kind":13,"localvar":"my","containerName":"gene2liveseq","name":"$hashref"},{"line":181,"containerName":"gene2liveseq","kind":13,"name":"$self"},{"kind":13,"containerName":"gene2liveseq","name":"$hashref","line":182},{"definition":"my","containerName":"gene2liveseq","localvar":"my","kind":13,"name":"$gene","line":183},{"line":183,"name":"$self","containerName":"gene2liveseq","kind":13},{"line":183,"name":"hash2gene","containerName":"gene2liveseq","kind":12},{"kind":13,"containerName":"gene2liveseq","name":"$hashref","line":183},{"containerName":"gene2liveseq","kind":13,"name":"$input","line":183},{"kind":13,"containerName":"gene2liveseq","name":"$flanking","line":183},{"line":183,"name":"$getswissprotinfo","containerName":"gene2liveseq","kind":13},{"line":184,"name":"$gene","containerName":"gene2liveseq","kind":13},{"line":188,"kind":13,"containerName":"gene2liveseq","name":"$gene"}]},{"line":152,"kind":12,"name":"carp"},{"name":"carp","kind":12,"line":156},{"name":"carp","kind":12,"line":166},{"kind":12,"name":"carp","line":175},{"kind":12,"name":"carp","line":185},{"name":"test_transl","containerName":"main::","children":[{"definition":"my","line":194,"localvar":"my","kind":13,"containerName":"test_transl","name":"$self"},{"line":194,"containerName":"test_transl","kind":13,"name":"$entry"},{"definition":"my","line":195,"containerName":"test_transl","localvar":"my","kind":13,"name":"@features"},{"line":195,"containerName":"test_transl","kind":13,"name":"$entry"}],"detail":"($self,$entry)","definition":"sub","range":{"start":{"character":0,"line":193},"end":{"line":195,"character":9999}},"kind":12,"line":193,"signature":{"parameters":[{"label":"$self"},{"label":"$entry"}],"documentation":" TODO: update so that it will work even if CDS is not only accepted FEATURE!!\n this method is for now deprecated and not supported","label":"test_transl($self,$entry)"}},{"definition":"my","localvar":"my","containerName":null,"kind":13,"name":"@translationobjects","line":196},{"definition":"my","name":"$i","localvar":"my","kind":13,"containerName":null,"line":197},{"containerName":null,"kind":13,"name":"$translation","line":197},{"definition":"my","containerName":null,"localvar":"my","kind":13,"name":"$obj_transl","line":198},{"line":198,"kind":13,"containerName":null,"name":"$hash_transl"},{"definition":"my","line":199,"localvar":"my","containerName":null,"kind":13,"name":"@cds"},{"containerName":null,"kind":13,"name":"%entry","line":199},{"containerName":null,"kind":13,"name":"$translation","line":200},{"kind":13,"containerName":null,"name":"@translationobjects","line":200},{"kind":13,"containerName":null,"name":"$obj_transl","line":201},{"line":201,"containerName":null,"kind":13,"name":"$translation"},{"name":"seq","containerName":"main::","kind":12,"line":201},{"kind":13,"containerName":null,"name":"$hash_transl","line":202},{"name":"@cds","containerName":null,"kind":13,"line":202},{"name":"%i","containerName":null,"kind":13,"line":202},{"name":"$obj_transl","kind":13,"containerName":null,"line":204},{"line":204,"name":"%hash_transl","containerName":null,"kind":13},{"line":205,"kind":12,"name":"cluck"},{"line":206,"kind":12,"name":"carp"},{"line":206,"kind":13,"containerName":null,"name":"$hash_transl"},{"kind":12,"name":"carp","line":207},{"line":207,"containerName":null,"kind":13,"name":"$obj_transl"},{"containerName":null,"kind":13,"name":"$i","line":210},{"definition":"sub","detail":"($self,$entry,$getswissprotinfo)","children":[{"line":219,"kind":13,"localvar":"my","containerName":"hash2liveseq","name":"$self","definition":"my"},{"name":"$entry","containerName":"hash2liveseq","kind":13,"line":219},{"kind":13,"containerName":"hash2liveseq","name":"$getswissprotinfo","line":219},{"definition":"my","line":220,"name":"$i","localvar":"my","kind":13,"containerName":"hash2liveseq"},{"definition":"my","line":221,"name":"@transcripts","localvar":"my","kind":13,"containerName":"hash2liveseq"},{"line":222,"name":"$dna","containerName":"hash2liveseq","localvar":"my","kind":13,"definition":"my"},{"line":222,"containerName":"hash2liveseq","kind":12,"name":"new"},{"line":222,"name":"$entry","containerName":"hash2liveseq","kind":13},{"name":"$dna","containerName":"hash2liveseq","kind":13,"line":223},{"line":223,"containerName":"hash2liveseq","kind":12,"name":"alphabet"},{"line":223,"kind":13,"containerName":"hash2liveseq","name":"$entry"},{"line":224,"kind":13,"containerName":"hash2liveseq","name":"$dna"},{"line":224,"kind":12,"containerName":"hash2liveseq","name":"display_id"},{"name":"$entry","containerName":"hash2liveseq","kind":13,"line":224},{"line":225,"name":"$dna","containerName":"hash2liveseq","kind":13},{"name":"accession_number","kind":12,"containerName":"hash2liveseq","line":225},{"line":225,"kind":13,"containerName":"hash2liveseq","name":"$entry"},{"line":226,"kind":13,"containerName":"hash2liveseq","name":"$dna"},{"line":226,"name":"desc","containerName":"hash2liveseq","kind":12},{"name":"$entry","containerName":"hash2liveseq","kind":13,"line":226},{"line":227,"localvar":"my","kind":13,"containerName":"hash2liveseq","name":"@cds","definition":"my"},{"line":227,"name":"$entry","containerName":"hash2liveseq","kind":13}],"name":"hash2liveseq","containerName":"main::","signature":{"label":"hash2liveseq($self,$entry,$getswissprotinfo)","parameters":[{"label":"$self"},{"label":"$entry"},{"label":"$getswissprotinfo"}],"documentation":" argument: hashref containing the EMBL entry datas,\n           getswissprotinfo boolean flag\n creates the liveseq objects\n returns: an array of Translation object references"},"line":218,"range":{"end":{"character":9999,"line":227},"start":{"character":0,"line":218}},"kind":12},{"kind":12,"containerName":"LiveSeq::DNA","name":"Bio","line":222},{"line":228,"name":"$swissacc","containerName":null,"localvar":"my","kind":13,"definition":"my"},{"name":"$swisshash","containerName":null,"kind":13,"line":228},{"localvar":"my","kind":13,"containerName":null,"name":"@swisshashes","line":228,"definition":"my"},{"name":"$i","containerName":null,"kind":13,"line":229},{"kind":12,"name":"cds","line":229},{"line":233,"name":"@transcripts","containerName":null,"kind":13},{"line":233,"name":"@cds","kind":13,"containerName":null},{"line":233,"name":"%i","containerName":null,"kind":13},{"line":234,"name":"%getswissprotinfo","kind":13,"containerName":null},{"line":235,"containerName":null,"kind":13,"name":"$swissacc"},{"containerName":null,"kind":13,"name":"@cds","line":235},{"name":"%i","containerName":null,"kind":13,"line":235},{"kind":13,"containerName":null,"name":"$swisshash","line":236},{"line":236,"containerName":null,"kind":13,"name":"$self"},{"name":"get_swisshash","containerName":"main::","kind":12,"line":236},{"line":236,"name":"$swissacc","containerName":null,"kind":13},{"name":"@swisshashes","kind":13,"containerName":null,"line":238},{"name":"$swisshash","containerName":null,"kind":13,"line":238},{"definition":"my","kind":13,"localvar":"my","containerName":null,"name":"@translations","line":241},{"kind":13,"containerName":null,"name":"$self","line":241},{"line":241,"name":"transexonscreation","kind":12,"containerName":"main::"},{"line":241,"containerName":null,"kind":13,"name":"$dna"},{"line":241,"kind":13,"containerName":null,"name":"@transcripts"},{"definition":"my","line":242,"localvar":"my","kind":13,"containerName":null,"name":"$translation"},{"definition":"my","localvar":"my","containerName":null,"kind":13,"name":"$j","line":242},{"line":243,"name":"$translation","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"@translations","line":243},{"name":"@swisshashes","kind":13,"containerName":null,"line":244},{"name":"%j","kind":13,"containerName":null,"line":244},{"line":245,"containerName":null,"kind":13,"name":"$self"},{"line":245,"kind":12,"containerName":"main::","name":"swisshash2liveseq"},{"kind":13,"containerName":null,"name":"@swisshashes","line":245},{"line":245,"containerName":null,"kind":13,"name":"$j"},{"name":"$translation","kind":13,"containerName":null,"line":245},{"kind":13,"containerName":null,"name":"$j","line":247},{"line":249,"containerName":null,"kind":13,"name":"@translations"},{"kind":12,"range":{"start":{"line":263,"character":0},"end":{"character":9999,"line":268}},"line":263,"signature":{"documentation":" only features pertaining to a specified gene are created\n only the sequence of the gene and appropriate context flanking regions\n are created as chain\n arguments: hashref, gene_name (OR: cds_position), length_of_flanking_sequences, getswissprotinfo boolean flag\n returns: reference to Gene object\n\n Note: if entry contains just one CDS, all the features get added\n       this is useful because often the features in these entries do not\n       carry the /gene qualifier\n\n errorcode: 0","parameters":[{"label":"$self"},{"label":"$entry"},{"label":"$input"},{"label":"$flanking"},{"label":"$getswissprotinfo"}],"label":"hash2gene($self,$entry,$input,$flanking,$getswissprotinfo)"},"name":"hash2gene","containerName":"main::","children":[{"definition":"my","line":264,"name":"$self","localvar":"my","kind":13,"containerName":"hash2gene"},{"line":264,"name":"$entry","containerName":"hash2gene","kind":13},{"name":"$input","kind":13,"containerName":"hash2gene","line":264},{"name":"$flanking","kind":13,"containerName":"hash2gene","line":264},{"line":264,"name":"$getswissprotinfo","containerName":"hash2gene","kind":13},{"line":265,"name":"$entryfeature","kind":13,"localvar":"my","containerName":"hash2gene","definition":"my"},{"definition":"my","localvar":"my","containerName":"hash2gene","kind":13,"name":"$genefeatureshash","line":266},{"name":"@cds","kind":13,"localvar":"my","containerName":"hash2gene","line":268,"definition":"my"},{"line":268,"kind":13,"containerName":"hash2gene","name":"$entry"}],"detail":"($self,$entry,$input,$flanking,$getswissprotinfo)","definition":"sub"},{"containerName":null,"kind":13,"name":"%input","line":271},{"line":272,"name":"$cds_position","containerName":null,"localvar":"my","kind":13,"definition":"my"},{"line":272,"containerName":null,"kind":13,"name":"$input"},{"line":273,"containerName":null,"kind":13,"name":"$cds_position"},{"line":273,"name":"$cds_position","containerName":null,"kind":13},{"line":273,"kind":13,"containerName":null,"name":"@cds"},{"containerName":null,"kind":13,"name":"$genefeatureshash","line":274},{"name":"$self","kind":13,"containerName":null,"line":274},{"containerName":"main::","kind":12,"name":"_findgenefeatures","line":274},{"containerName":null,"kind":13,"name":"$entry","line":274},{"line":274,"name":"$cds_position","containerName":null,"kind":13},{"line":274,"name":"%getswissprotinfo","kind":13,"containerName":null},{"name":"$genefeatureshash","containerName":null,"kind":13,"line":277},{"line":277,"name":"$self","kind":13,"containerName":null},{"name":"_findgenefeatures","containerName":"main::","kind":12,"line":277},{"name":"$entry","containerName":null,"kind":13,"line":277},{"line":277,"containerName":null,"kind":13,"name":"$input"},{"name":"$getswissprotinfo","kind":13,"containerName":null,"line":277},{"line":280,"name":"$genefeatureshash","containerName":null,"kind":13},{"line":280,"containerName":null,"kind":13,"name":"%genefeatureshash"},{"name":"@genes","localvar":"my","kind":13,"containerName":null,"line":281,"definition":"my"},{"containerName":null,"kind":13,"name":"$self","line":281},{"line":281,"kind":12,"containerName":"main::","name":"genes"},{"kind":13,"containerName":null,"name":"$entry","line":281},{"name":"$cds_number","containerName":null,"localvar":"my","kind":13,"line":282,"definition":"my"},{"line":282,"containerName":null,"kind":13,"name":"@cds"},{"containerName":null,"localvar":"my","kind":13,"name":"$min","line":290,"definition":"my"},{"line":290,"containerName":null,"kind":13,"name":"$max"},{"line":290,"name":"$self","containerName":null,"kind":13},{"name":"rangeofarray","kind":12,"containerName":"main::","line":290},{"line":290,"containerName":null,"kind":13,"name":"%genefeatureshash"},{"definition":"my","name":"$seqlength","localvar":"my","kind":13,"containerName":null,"line":291},{"containerName":null,"kind":13,"name":"%entry","line":291},{"line":292,"kind":13,"localvar":"my","containerName":null,"name":"$mindna","definition":"my"},{"line":292,"name":"$maxdna","containerName":null,"kind":13},{"name":"$min","containerName":null,"kind":13,"line":293},{"containerName":null,"kind":13,"name":"%flanking","line":293},{"line":294,"name":"%mindna","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"$mindna","line":296},{"line":296,"name":"$min","containerName":null,"kind":13},{"line":296,"containerName":null,"kind":13,"name":"$flanking"},{"line":298,"name":"$max","kind":13,"containerName":null},{"name":"$flanking","containerName":null,"kind":13,"line":298},{"line":298,"containerName":null,"kind":13,"name":"%seqlength"},{"line":299,"containerName":null,"kind":13,"name":"$maxdna"},{"name":"%seqlength","kind":13,"containerName":null,"line":299},{"line":301,"containerName":null,"kind":13,"name":"$maxdna"},{"line":301,"name":"$max","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"$flanking","line":301},{"name":"$subseq","containerName":null,"localvar":"my","kind":13,"line":303,"definition":"my"},{"name":"%entry","kind":13,"containerName":null,"line":303},{"line":303,"name":"$mindna","kind":13,"containerName":null},{"name":"$maxdna","containerName":null,"kind":13,"line":303},{"name":"$mindna","containerName":null,"kind":13,"line":303},{"definition":"my","line":308,"kind":13,"localvar":"my","containerName":null,"name":"$dna"},{"line":308,"name":"Bio","kind":12,"containerName":"LiveSeq::DNA"},{"line":308,"name":"new","containerName":"main::","kind":12},{"line":308,"containerName":null,"kind":13,"name":"$subseq"},{"name":"$mindna","kind":13,"containerName":null,"line":308},{"containerName":null,"kind":13,"name":"$dna","line":309},{"line":309,"name":"alphabet","containerName":"main::","kind":12},{"line":309,"containerName":null,"kind":13,"name":"%entry"},{"kind":13,"containerName":null,"name":"$dna","line":310},{"line":310,"name":"source","containerName":"main::","kind":12},{"line":310,"kind":13,"containerName":null,"name":"%entry"},{"name":"$dna","containerName":null,"kind":13,"line":311},{"line":311,"containerName":"main::","kind":12,"name":"display_id"},{"containerName":null,"kind":13,"name":"%entry","line":311},{"line":312,"kind":13,"containerName":null,"name":"$dna"},{"line":312,"containerName":"main::","kind":12,"name":"accession_number"},{"line":312,"kind":13,"containerName":null,"name":"%entry"},{"containerName":null,"kind":13,"name":"$dna","line":313},{"line":313,"containerName":"main::","kind":12,"name":"desc"},{"line":313,"name":"%entry","containerName":null,"kind":13},{"definition":"my","line":315,"name":"@transcripts","localvar":"my","kind":13,"containerName":null},{"name":"%genefeatureshash","containerName":null,"kind":13,"line":315},{"line":317,"name":"@transcripts","kind":13,"containerName":null},{"line":318,"name":"cluck","kind":12},{"definition":"my","line":321,"localvar":"my","containerName":null,"kind":13,"name":"@translationobjs"},{"line":321,"kind":13,"containerName":null,"name":"$self"},{"name":"transexonscreation","kind":12,"containerName":"main::","line":321},{"containerName":null,"kind":13,"name":"$dna","line":321},{"line":321,"name":"@transcripts","kind":13,"containerName":null},{"definition":"my","name":"@transcriptobjs","localvar":"my","containerName":null,"kind":13,"line":322},{"name":"$translation","localvar":"my","kind":13,"containerName":null,"line":325,"definition":"my"},{"definition":"my","name":"$j","containerName":null,"localvar":"my","kind":13,"line":326},{"name":"@ttables","containerName":null,"localvar":"my","kind":13,"line":327,"definition":"my"},{"name":"%genefeatureshash","containerName":null,"kind":13,"line":327},{"line":328,"name":"@swisshashes","containerName":null,"localvar":"my","kind":13,"definition":"my"},{"name":"%genefeatureshash","kind":13,"containerName":null,"line":328},{"line":329,"name":"$translation","containerName":null,"kind":13},{"line":329,"containerName":null,"kind":13,"name":"@translationobjs"},{"name":"@transcriptobjs","containerName":null,"kind":13,"line":330},{"line":330,"containerName":null,"kind":13,"name":"$translation"},{"line":330,"name":"get_Transcript","containerName":"main::","kind":12},{"name":"@ttables","containerName":null,"kind":13,"line":331},{"containerName":null,"kind":13,"name":"%j","line":331},{"kind":13,"containerName":null,"name":"$translation","line":332},{"name":"get_Transcript","containerName":"main::","kind":12,"line":332},{"line":332,"name":"translation_table","containerName":"main::","kind":12},{"line":332,"containerName":null,"kind":13,"name":"@ttables"},{"name":"$j","kind":13,"containerName":null,"line":332},{"line":336,"containerName":null,"kind":13,"name":"@swisshashes"},{"line":336,"name":"%j","containerName":null,"kind":13},{"line":337,"name":"$self","kind":13,"containerName":null},{"name":"swisshash2liveseq","containerName":"main::","kind":12,"line":337},{"kind":13,"containerName":null,"name":"@swisshashes","line":337},{"line":337,"kind":13,"containerName":null,"name":"$j"},{"name":"$translation","kind":13,"containerName":null,"line":337},{"containerName":null,"kind":13,"name":"$j","line":339},{"name":"%gene","containerName":null,"localvar":"my","kind":13,"line":342,"definition":"my"},{"line":343,"kind":13,"containerName":null,"name":"%gene"},{"kind":12,"name":"DNA","line":343},{"name":"$dna","kind":13,"containerName":null,"line":343},{"name":"%gene","containerName":null,"kind":13,"line":344},{"kind":12,"name":"Transcripts","line":344},{"name":"@transcriptobjs","containerName":null,"kind":13,"line":344},{"kind":13,"containerName":null,"name":"%gene","line":345},{"kind":12,"name":"Translations","line":345},{"name":"@translationobjs","containerName":null,"kind":13,"line":345},{"definition":"my","line":347,"name":"@exonobjs","localvar":"my","containerName":null,"kind":13},{"localvar":"my","kind":13,"containerName":null,"name":"@intronobjs","line":347,"definition":"my"},{"definition":"my","localvar":"my","kind":13,"containerName":null,"name":"@repeatunitobjs","line":348},{"definition":"my","name":"@repeatregionobjs","localvar":"my","containerName":null,"kind":13,"line":348},{"definition":"my","name":"@primtranscriptobjs","localvar":"my","kind":13,"containerName":null,"line":349},{"definition":"my","line":351,"name":"$object","localvar":"my","kind":13,"containerName":null},{"name":"$range","containerName":null,"kind":13,"line":351},{"line":351,"containerName":null,"kind":13,"name":"$start"},{"kind":13,"containerName":null,"name":"$end","line":351},{"containerName":null,"kind":13,"name":"$strand","line":351},{"name":"@exons","containerName":null,"localvar":"my","kind":13,"line":353,"definition":"my"},{"line":353,"name":"%genefeatureshash","containerName":null,"kind":13},{"definition":"my","line":354,"containerName":null,"localvar":"my","kind":13,"name":"@exondescs"},{"line":354,"name":"%genefeatureshash","kind":13,"containerName":null},{"line":355,"containerName":null,"kind":13,"name":"@exons"},{"line":356,"name":"$exoncount","localvar":"my","kind":13,"containerName":null,"definition":"my"},{"containerName":null,"kind":13,"name":"$range","line":357},{"line":357,"name":"@exons","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"$start","line":358},{"name":"$end","containerName":null,"kind":13,"line":358},{"kind":13,"containerName":null,"name":"$strand","line":358},{"containerName":null,"kind":13,"name":"$range","line":358},{"kind":13,"containerName":null,"name":"$object","line":359},{"line":359,"containerName":"LiveSeq::Exon","kind":12,"name":"Bio"},{"line":359,"containerName":"main::","kind":12,"name":"new"},{"name":"$dna","kind":13,"containerName":null,"line":359},{"name":"$start","kind":13,"containerName":null,"line":359},{"line":359,"name":"$end","containerName":null,"kind":13},{"name":"$strand","containerName":null,"kind":13,"line":359},{"line":360,"containerName":null,"kind":13,"name":"%object"},{"line":361,"name":"$object","containerName":null,"kind":13},{"name":"desc","containerName":"main::","kind":12,"line":361},{"line":361,"containerName":null,"kind":13,"name":"@exondescs"},{"line":361,"containerName":null,"kind":13,"name":"$exoncount"},{"name":"@exondescs","kind":13,"containerName":null,"line":361},{"line":361,"containerName":null,"kind":13,"name":"$exoncount"},{"line":362,"containerName":null,"kind":13,"name":"$exoncount"},{"line":363,"name":"@exonobjs","containerName":null,"kind":13},{"line":363,"kind":13,"containerName":null,"name":"%object"},{"name":"$exoncount","containerName":null,"kind":13,"line":365},{"line":368,"name":"%gene","containerName":null,"kind":13},{"line":368,"name":"Exons","kind":12},{"kind":13,"containerName":null,"name":"@exonobjs","line":368},{"line":370,"name":"@introns","containerName":null,"localvar":"my","kind":13,"definition":"my"},{"line":370,"kind":13,"containerName":null,"name":"%genefeatureshash"},{"localvar":"my","kind":13,"containerName":null,"name":"@introndescs","line":371,"definition":"my"},{"line":371,"name":"%genefeatureshash","containerName":null,"kind":13},{"line":372,"name":"@introns","kind":13,"containerName":null},{"kind":13,"localvar":"my","containerName":null,"name":"$introncount","line":373,"definition":"my"},{"containerName":null,"kind":13,"name":"$range","line":374},{"containerName":null,"kind":13,"name":"@introns","line":374},{"line":375,"name":"$start","kind":13,"containerName":null},{"line":375,"name":"$end","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"$strand","line":375},{"line":375,"containerName":null,"kind":13,"name":"$range"},{"name":"$object","kind":13,"containerName":null,"line":376},{"line":376,"name":"Bio","containerName":"LiveSeq::Intron","kind":12},{"name":"new","kind":12,"containerName":"main::","line":376},{"containerName":null,"kind":13,"name":"$dna","line":376},{"containerName":null,"kind":13,"name":"$start","line":376},{"line":376,"containerName":null,"kind":13,"name":"$end"},{"kind":13,"containerName":null,"name":"$strand","line":376},{"line":377,"name":"%object","containerName":null,"kind":13},{"line":378,"kind":13,"containerName":null,"name":"$object"},{"name":"desc","containerName":"main::","kind":12,"line":378},{"containerName":null,"kind":13,"name":"@introndescs","line":378},{"line":378,"containerName":null,"kind":13,"name":"$introncount"},{"name":"$introncount","kind":13,"containerName":null,"line":379},{"line":380,"name":"@intronobjs","containerName":null,"kind":13},{"line":380,"name":"%object","containerName":null,"kind":13},{"line":382,"kind":13,"containerName":null,"name":"$introncount"},{"line":385,"name":"%gene","containerName":null,"kind":13},{"kind":12,"name":"Introns","line":385},{"line":385,"name":"@intronobjs","containerName":null,"kind":13},{"definition":"my","line":387,"name":"@prim_transcripts","kind":13,"localvar":"my","containerName":null},{"containerName":null,"kind":13,"name":"%genefeatureshash","line":387},{"line":388,"name":"@prim_transcripts","kind":13,"containerName":null},{"line":389,"containerName":null,"kind":13,"name":"$range"},{"containerName":null,"kind":13,"name":"@prim_transcripts","line":389},{"line":390,"name":"$start","kind":13,"containerName":null},{"name":"$end","containerName":null,"kind":13,"line":390},{"containerName":null,"kind":13,"name":"$strand","line":390},{"line":390,"name":"$range","kind":13,"containerName":null},{"line":391,"name":"$object","containerName":null,"kind":13},{"line":391,"name":"Bio","kind":12,"containerName":"LiveSeq::Prim_Transcript"},{"line":391,"containerName":"main::","kind":12,"name":"new"},{"name":"$dna","containerName":null,"kind":13,"line":391},{"line":391,"kind":13,"containerName":null,"name":"$start"},{"line":391,"kind":13,"containerName":null,"name":"$end"},{"line":391,"containerName":null,"kind":13,"name":"$strand"},{"line":392,"name":"%object","containerName":null,"kind":13},{"line":392,"containerName":null,"kind":13,"name":"@primtranscriptobjs"},{"containerName":null,"kind":13,"name":"$object","line":392},{"line":394,"containerName":null,"kind":13,"name":"%gene"},{"name":"Prim_Transcripts","kind":12,"line":394},{"line":394,"name":"@primtranscriptobjs","containerName":null,"kind":13},{"line":396,"containerName":null,"localvar":"my","kind":13,"name":"@repeat_regions","definition":"my"},{"line":396,"name":"%genefeatureshash","containerName":null,"kind":13},{"definition":"my","localvar":"my","containerName":null,"kind":13,"name":"@repeat_regions_family","line":397},{"kind":13,"containerName":null,"name":"%genefeatureshash","line":397},{"line":398,"containerName":null,"kind":13,"name":"@repeat_regions"},{"definition":"my","line":399,"containerName":null,"localvar":"my","kind":13,"name":"$k"},{"line":400,"containerName":null,"kind":13,"name":"$range"},{"kind":13,"containerName":null,"name":"@repeat_regions","line":400},{"name":"$start","kind":13,"containerName":null,"line":401},{"line":401,"name":"$end","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"$strand","line":401},{"containerName":null,"kind":13,"name":"$range","line":401},{"line":402,"name":"$object","kind":13,"containerName":null},{"line":402,"kind":12,"containerName":"LiveSeq::Repeat_Region","name":"Bio"},{"kind":12,"containerName":"main::","name":"new","line":402},{"containerName":null,"kind":13,"name":"$dna","line":402},{"line":402,"containerName":null,"kind":13,"name":"$start"},{"line":402,"kind":13,"containerName":null,"name":"$end"},{"line":402,"containerName":null,"kind":13,"name":"$strand"},{"line":403,"containerName":null,"kind":13,"name":"%object"},{"line":404,"containerName":null,"kind":13,"name":"$object"},{"line":404,"name":"desc","kind":12,"containerName":"main::"},{"containerName":null,"kind":13,"name":"@repeat_regions_family","line":404},{"line":404,"name":"$k","kind":13,"containerName":null},{"line":405,"containerName":null,"kind":13,"name":"$k"},{"name":"@repeatregionobjs","containerName":null,"kind":13,"line":406},{"name":"%object","containerName":null,"kind":13,"line":406},{"kind":13,"containerName":null,"name":"$k","line":408},{"containerName":null,"kind":13,"name":"%gene","line":411},{"name":"Repeat_Regions","kind":12,"line":411},{"line":411,"name":"@repeatregionobjs","kind":13,"containerName":null},{"definition":"my","line":413,"name":"@repeat_units","localvar":"my","containerName":null,"kind":13},{"line":413,"containerName":null,"kind":13,"name":"%genefeatureshash"},{"definition":"my","name":"@repeat_units_family","localvar":"my","kind":13,"containerName":null,"line":414},{"line":414,"containerName":null,"kind":13,"name":"%genefeatureshash"},{"kind":13,"containerName":null,"name":"@repeat_units","line":415},{"definition":"my","localvar":"my","containerName":null,"kind":13,"name":"$k","line":416},{"line":417,"kind":13,"containerName":null,"name":"$range"},{"line":417,"name":"@repeat_units","kind":13,"containerName":null},{"name":"$start","containerName":null,"kind":13,"line":418},{"line":418,"name":"$end","kind":13,"containerName":null},{"name":"$strand","containerName":null,"kind":13,"line":418},{"line":418,"name":"$range","containerName":null,"kind":13},{"line":419,"name":"$object","kind":13,"containerName":null},{"containerName":"LiveSeq::Repeat_Unit","kind":12,"name":"Bio","line":419},{"name":"new","containerName":"main::","kind":12,"line":419},{"name":"$dna","kind":13,"containerName":null,"line":419},{"line":419,"name":"$start","containerName":null,"kind":13},{"line":419,"kind":13,"containerName":null,"name":"$end"},{"line":419,"containerName":null,"kind":13,"name":"$strand"},{"name":"%object","containerName":null,"kind":13,"line":420},{"kind":13,"containerName":null,"name":"$object","line":421},{"line":421,"kind":12,"containerName":"main::","name":"desc"},{"line":421,"name":"@repeat_units_family","containerName":null,"kind":13},{"name":"$k","containerName":null,"kind":13,"line":421},{"line":422,"containerName":null,"kind":13,"name":"$k"},{"name":"@repeatunitobjs","containerName":null,"kind":13,"line":423},{"line":423,"containerName":null,"kind":13,"name":"%object"},{"containerName":null,"kind":13,"name":"$k","line":425},{"name":"%gene","containerName":null,"kind":13,"line":428},{"name":"Repeat_Units","kind":12,"line":428},{"name":"@repeatunitobjs","kind":13,"containerName":null,"line":428},{"definition":"my","name":"$gene_name","localvar":"my","containerName":null,"kind":13,"line":432},{"line":432,"containerName":null,"kind":13,"name":"%genefeatureshash"},{"name":"Bio","kind":12,"containerName":"LiveSeq::Gene","line":433},{"line":433,"name":"new","containerName":"main::","kind":12},{"line":433,"containerName":null,"kind":13,"name":"$gene_name"},{"kind":13,"containerName":null,"name":"%gene","line":433},{"containerName":null,"kind":13,"name":"$min","line":434},{"name":"$max","kind":13,"containerName":null,"line":434},{"name":"rangeofarray","containerName":"main::","children":[{"line":441,"name":"$self","localvar":"my","containerName":"rangeofarray","kind":13,"definition":"my"},{"line":442,"name":"@array","kind":13,"localvar":"my","containerName":"rangeofarray","definition":"my"},{"definition":"my","line":444,"name":"$max","localvar":"my","kind":13,"containerName":"rangeofarray"},{"name":"$min","containerName":"rangeofarray","kind":13,"line":444},{"kind":13,"containerName":"rangeofarray","name":"$element","line":444},{"name":"$min","containerName":"rangeofarray","kind":13,"line":445},{"line":445,"containerName":"rangeofarray","kind":13,"name":"$max"},{"containerName":"rangeofarray","kind":13,"name":"@array","line":445},{"line":446,"name":"$element","kind":13,"containerName":"rangeofarray"},{"containerName":"rangeofarray","kind":13,"name":"@array","line":446},{"line":447,"name":"$element","kind":13,"containerName":"rangeofarray"},{"containerName":"rangeofarray","kind":13,"name":"$element","line":447},{"containerName":"rangeofarray","kind":13,"name":"$element","line":448},{"containerName":"rangeofarray","kind":13,"name":"$min","line":448},{"line":449,"name":"$min","kind":13,"containerName":"rangeofarray"},{"line":449,"name":"$element","containerName":"rangeofarray","kind":13},{"line":451,"name":"$element","kind":13,"containerName":"rangeofarray"},{"name":"$max","containerName":"rangeofarray","kind":13,"line":451},{"line":452,"name":"$max","containerName":"rangeofarray","kind":13},{"line":452,"name":"$element","containerName":"rangeofarray","kind":13},{"name":"$min","kind":13,"containerName":"rangeofarray","line":456},{"line":456,"name":"$max","containerName":"rangeofarray","kind":13}],"definition":"sub","kind":12,"range":{"start":{"character":0,"line":440},"end":{"character":9999,"line":457}},"line":440},{"definition":"sub","containerName":"main::","name":"transexonscreation","children":[{"localvar":"my","kind":13,"containerName":"transexonscreation","name":"$self","line":463,"definition":"my"},{"definition":"my","name":"$dna","localvar":"my","kind":13,"containerName":"transexonscreation","line":464},{"definition":"my","containerName":"transexonscreation","localvar":"my","kind":13,"name":"@transcripts","line":465}],"range":{"end":{"line":465,"character":9999},"start":{"character":0,"line":462}},"kind":12,"line":462},{"definition":"my","line":467,"name":"@transexons","containerName":null,"localvar":"my","kind":13},{"containerName":null,"kind":13,"name":"$start","line":467},{"containerName":null,"kind":13,"name":"$end","line":467},{"line":467,"name":"$strand","kind":13,"containerName":null},{"line":467,"kind":13,"containerName":null,"name":"$exonref"},{"line":467,"name":"$exonobj","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"$transcript","line":467},{"name":"$transcriptobj","containerName":null,"kind":13,"line":467},{"definition":"my","line":468,"name":"$translationobj","localvar":"my","containerName":null,"kind":13},{"definition":"my","line":469,"localvar":"my","containerName":null,"kind":13,"name":"@translationobjects"},{"name":"$transcript","kind":13,"containerName":null,"line":470},{"line":470,"containerName":null,"kind":13,"name":"@transcripts"},{"line":471,"containerName":null,"kind":13,"name":"$exonref"},{"name":"%transcript","containerName":null,"kind":13,"line":471},{"line":472,"kind":13,"containerName":null,"name":"$start"},{"line":472,"name":"$end","kind":13,"containerName":null},{"line":472,"name":"$strand","containerName":null,"kind":13},{"line":472,"kind":13,"containerName":null,"name":"$exonref"},{"line":474,"kind":13,"containerName":null,"name":"$exonobj"},{"line":474,"kind":12,"containerName":"LiveSeq::Exon","name":"Bio"},{"containerName":"main::","kind":12,"name":"new","line":474},{"kind":13,"containerName":null,"name":"$dna","line":474},{"line":474,"name":"$start","containerName":null,"kind":13},{"name":"$end","kind":13,"containerName":null,"line":474},{"line":474,"kind":13,"containerName":null,"name":"$strand"},{"name":"@transexons","containerName":null,"kind":13,"line":476},{"line":476,"name":"$exonobj","kind":13,"containerName":null},{"line":478,"name":"$transcriptobj","containerName":null,"kind":13},{"kind":12,"containerName":"LiveSeq::Transcript","name":"Bio","line":478},{"name":"new","kind":12,"containerName":"main::","line":478},{"name":"@transexons","kind":13,"containerName":null,"line":478},{"line":479,"name":"%transcriptobj","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"$translationobj","line":480},{"line":480,"kind":12,"containerName":"LiveSeq::Translation","name":"Bio"},{"name":"new","kind":12,"containerName":"main::","line":480},{"name":"$transcriptobj","kind":13,"containerName":null,"line":480},{"name":"@transexons","containerName":null,"kind":13,"line":481},{"containerName":null,"kind":13,"name":"@translationobjects","line":483},{"name":"$translationobj","kind":13,"containerName":null,"line":483},{"line":486,"kind":13,"containerName":null,"name":"@translationobjects"},{"detail":"($self,$entry)","definition":"sub","name":"printswissprot","containerName":"main::","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"printswissprot","line":508,"definition":"my"},{"line":508,"containerName":"printswissprot","kind":13,"name":"$entry"},{"line":509,"containerName":"printswissprot","kind":13,"name":"$entry"},{"name":"$entry","containerName":"printswissprot","kind":13,"line":513},{"line":515,"containerName":"printswissprot","kind":13,"name":"$entry"},{"name":"$entry","containerName":"printswissprot","kind":13,"line":517},{"containerName":"printswissprot","kind":13,"name":"$entry","line":519},{"name":"$entry","kind":13,"containerName":"printswissprot","line":521},{"containerName":"printswissprot","kind":13,"name":"$entry","line":523},{"line":525,"containerName":"printswissprot","kind":13,"name":"$entry"},{"line":526,"name":"$entry","containerName":"printswissprot","kind":13},{"definition":"my","line":527,"name":"@features","containerName":"printswissprot","localvar":"my","kind":13},{"line":527,"name":"$entry","kind":13,"containerName":"printswissprot"},{"line":528,"containerName":"printswissprot","localvar":"my","kind":13,"name":"$i","definition":"my"},{"name":"$i","containerName":"printswissprot","kind":13,"line":529},{"line":530,"name":"$features","containerName":"printswissprot","kind":13},{"line":530,"name":"$i","kind":13,"containerName":"printswissprot"},{"line":531,"name":"$features","kind":13,"containerName":"printswissprot"},{"line":531,"name":"$i","containerName":"printswissprot","kind":13},{"containerName":"printswissprot","kind":13,"name":"$features","line":532},{"containerName":"printswissprot","kind":13,"name":"$i","line":532}],"signature":{"label":"printswissprot($self,$entry)","documentation":"1;\n# $Id: Loader.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::IO::Loader\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::IO::Loader - Parent Loader for LiveSeq\n\n=head1 SYNOPSIS\n\n  #documentation needed\n\n=head1 DESCRIPTION\n\nThis package holds common methods used by BioPerl and file loaders.\nIt contains methods to create LiveSeq objects out of entire entries or from a\nlocalized sequence region surrounding a particular gene.\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::IO::Loader;\n\nuse strict;\nuse Carp qw(cluck croak carp);\nuse Bio::LiveSeq::DNA;\nuse Bio::LiveSeq::Exon;\nuse Bio::LiveSeq::Transcript ;\nuse Bio::LiveSeq::Translation;\nuse Bio::LiveSeq::Gene;\nuse Bio::LiveSeq::Intron;\nuse Bio::LiveSeq::Prim_Transcript;\nuse Bio::LiveSeq::Repeat_Region;\nuse Bio::LiveSeq::Repeat_Unit;\nuse Bio::LiveSeq::AARange;\nuse Bio::Tools::CodonTable;\n\n=head2 entry2liveseq\n\n  Title   : entry2liveseq\n  Usage   : @translationobjects=$loader->entry2liveseq();\n          : @translationobjects=$loader->entry2liveseq(-getswissprotinfo => 0);\n  Function: creates LiveSeq objects from an entry previously loaded\n  Returns : array of references to objects of class Translation\n  Errorcode 0\n  Args    : optional boolean flag to avoid the retrieval of SwissProt\n            informations for all Transcripts containing SwissProt x-reference\n            default is 1 (to retrieve those informations and create AARange\n            LiveSeq objects)\n  Note    : this method can get really slow for big entries. The lightweight\n            gene2liveseq method is recommended\n\n\nsub entry2liveseq {\n  my ($self, %args) = @_;\n  my ($getswissprotinfo)=($args{-getswissprotinfo});\n  if (defined($getswissprotinfo)) {\n    if (($getswissprotinfo ne 0)&&($getswissprotinfo ne 1)) {\n      carp \"-getswissprotinfo argument can take only boolean (1 or 0) values. Setting it to 0, i.e. not trying to retrieve SwissProt information....\";\n      $getswissprotinfo=0;\n    }\n  } else {\n    $getswissprotinfo=1;\n  }\n  my $hashref=$self->{'hash'};\n  unless ($hashref) { return (0); }\n  my @translationobjects=$self->hash2liveseq($hashref,$getswissprotinfo);\n  my $test_transl=0;\n  if ($test_transl) { $self->test_transl($hashref,\\@translationobjects);}\n  return @translationobjects;\n}\n\n=head2 novelaasequence2gene\n\n  Title   : novelaasequence2gene\n  Usage   : $gene=$loader->novelaasequence2gene(-aasequence => \"MGLAAPTRS*\");\n          : $gene=$loader->novelaasequence2gene(-aasequence => \"MGLAAPTRS*\");\n                                             -taxon => 9606,\n                                             -gene_name => \"tyr-kinase\");\n\n  Function: creates LiveSeq objects from a novel amino acid sequence,\n            using codon usage database to choose codons according to\n            relative frequencies.\n            If a taxon ID is not specified, the default is to use the human\n            one (taxonomy ID 9606).\n  Returns : reference to a Gene object containing references to LiveSeq objects\n  Errorcode 0\n  Args    : string containing an amino acid sequence\n            integer (optional) with a taxonomy ID\n            string specifying a gene name\n\n\n=head2 gene2liveseq\n\n  Title   : gene2liveseq\n  Usage   : $gene=$loader->gene2liveseq(-gene_name => \"gene name\");\n          : $gene=$loader->gene2liveseq(-gene_name => \"gene name\",\n                                        -flanking => 64);\n          : $gene=$loader->gene2liveseq(-gene_name => \"gene name\",\n                                        -getswissprotinfo => 0);\n          : $gene=$loader->gene2liveseq(-position => 4);\n\n  Function: creates LiveSeq objects from an entry previously loaded\n            It is a \"light weight\" creation because it creates\n            a LiveSequence just for the interesting region in an entry\n            (instead than for the total entry, like in entry2liveseq) and for\n            the flanking regions up to 500 nucleotides (default) or up to\n            the specified amount of nucleotides (given as argument) around the\n            Gene.\n  Returns : reference to a Gene object containing possibly alternative\n            Transcripts.\n  Errorcode 0\n  Args    : string containing the gene name as in the EMBL feature qualifier\n            integer (optional) \"flanking\": amount of flanking bases to be kept\n            boolean (optional) \"getswissprotinfo\": if set to \"0\" it will avoid\n             trying to fetch information from a crossreference to a SwissProt\n             entry, avoding the process of creation of AARange objects\n             It is \"1\" (on) by default\n\n            Alternative to a gene_name, a position can be given: an\n            integer (1-) containing the position of the desired CDS in the\n            loaded entry\n\n\nsub gene2liveseq {\n  my ($self, %args) = @_;\n  my ($gene_name,$flanking,$getswissprotinfo,$cds_position)=($args{-gene_name},$args{-flanking},$args{-getswissprotinfo},$args{-position});\n  my $input;\n  unless (($gene_name)||($cds_position)) {\n    carp \"Gene_Name or Position not specified for gene2liveseq loading function\";\n    return (0);\n  }\n  if (($gene_name)&&($cds_position)) {\n    carp \"Gene_Name and Position cannot be given together\";\n    return (0);\n  } elsif ($gene_name) {\n    $input=$gene_name;\n  } else {\n    $input=\"cds-position:\".$cds_position;\n  }\n\n  if (defined($getswissprotinfo)) {\n    if (($getswissprotinfo ne 0)&&($getswissprotinfo ne 1)) {\n      carp \"-getswissprotinfo argument can take only boolean (1 or 0) values. Setting it to 0, i.e. not trying to retrieve SwissProt information....\";\n      $getswissprotinfo=0;\n    }\n  } else {\n    $getswissprotinfo=1;\n  }\n\n  if (defined($flanking)) {\n    unless ($flanking >= 0) {\n      carp \"No sense in specifying a number < 0 for flanking regions to be created for gene2liveseq loading function\";\n      return (0);\n    }\n  } else {\n    $flanking=500; # the default flanking length\n  }\n  my $hashref=$self->{'hash'};\n  unless ($hashref) { return (0); }\n  my $gene=$self->hash2gene($hashref,$input,$flanking,$getswissprotinfo);\n  unless ($gene) { # if $gene == 0 it means problems in hash2gene\n    carp \"gene2liveseq produced error\";\n    return (0);\n  }\n  return $gene;\n}\n\n# TODO: update so that it will work even if CDS is not only accepted FEATURE!!\n# this method is for now deprecated and not supported\nsub test_transl {\n  my ($self,$entry)=@_;\n  my @features=@{$entry->{'Features'}};\n  my @translationobjects=@{$_[1]};\n  my ($i,$translation);\n  my ($obj_transl,$hash_transl);\n  my @cds=@{$entry->{'CDS'}};\n  foreach $translation (@translationobjects) {\n    $obj_transl=$translation->seq;\n    $hash_transl=$cds[$i]->{'qualifiers'}->{'translation'};\n    #before seq was changed in Translation 1.4# chop $obj_transl; # to remove trailing \"*\"\n    unless ($obj_transl eq $hash_transl) {\n      cluck \"Serious error: Translation from the Entry does not match Translation from object's seq for CDS at position $i\";\n      carp \"\\nEntry's transl: \",$hash_transl,\"\\n\";\n      carp \"\\nObject's transl: \",$obj_transl,\"\\n\";\n      exit;\n    }\n    $i++;\n  }\n}\n\n# argument: hashref containing the EMBL entry datas,\n#           getswissprotinfo boolean flag\n# creates the liveseq objects\n# returns: an array of Translation object references\nsub hash2liveseq {\n  my ($self,$entry,$getswissprotinfo)=@_;\n  my $i;\n  my @transcripts;\n  my $dna=Bio::LiveSeq::DNA->new(-seq => $entry->{'Sequence'} );\n  $dna->alphabet(lc($entry->{'Molecule'}));\n  $dna->display_id($entry->{'ID'});\n  $dna->accession_number($entry->{'AccNumber'});\n  $dna->desc($entry->{'Description'});\n  my @cds=@{$entry->{'CDS'}};\n  my ($swissacc,$swisshash); my @swisshashes;\n  for $i (0..$#cds) {\n    #my @transcript=@{$cds[$i]->{'range'}};\n    #$transcript=\\@transcript;\n    #push (@transcripts,$transcript);\n    push (@transcripts,$cds[$i]->{'range'});\n    if ($getswissprotinfo) {\n      $swissacc=$cds[$i]->{'qualifiers'}->{'db_xref'};\n      $swisshash=$self->get_swisshash($swissacc);\n      #$self->printswissprot($swisshash); # DEBUG\n      push (@swisshashes,$swisshash);\n    }\n  }\n  my @translations=($self->transexonscreation($dna,\\@transcripts));\n  my $translation; my $j=0;\n  foreach $translation (@translations) {\n    if ($swisshashes[$j]) { # if not 0\n      $self->swisshash2liveseq($swisshashes[$j],$translation);\n    }\n    $j++;\n  }\n  return (@translations);\n}\n\n# only features pertaining to a specified gene are created\n# only the sequence of the gene and appropriate context flanking regions\n# are created as chain\n# arguments: hashref, gene_name (OR: cds_position), length_of_flanking_sequences, getswissprotinfo boolean flag\n# returns: reference to Gene object\n#\n# Note: if entry contains just one CDS, all the features get added\n#       this is useful because often the features in these entries do not\n#       carry the /gene qualifier\n#\n# errorcode: 0\nsub hash2gene {\n  my ($self,$entry,$input,$flanking,$getswissprotinfo)=@_;\n  my $entryfeature;\n  my $genefeatureshash;\n\n  my @cds=@{$entry->{'CDS'}};\n\n  # checking if a position has been given instead than a gene_name\n  if (index($input,\"cds-position:\") == 0 ) {\n    my $cds_position=substr($input,13); # extracting the cds position\n    if (($cds_position >= 1)&&($cds_position <= scalar(@cds))) {\n      $genefeatureshash=$self->_findgenefeatures($entry,undef,$cds_position,$getswissprotinfo);\n    }\n  } else {\n    $genefeatureshash=$self->_findgenefeatures($entry,$input,undef,$getswissprotinfo);\n  }\n\n  unless (($genefeatureshash)&&(scalar(@{$genefeatureshash->{'genefeatures'}}))) { # array empty, no gene features found\n    my @genes=$self->genes($entry);\n    my $cds_number=scalar(@cds);\n    warn \"Warning! Not even one genefeature found for /$input/....\n    The genes present in this entry are:\\n\\t@genes\\n\n    The number of CDS in this entry is:\\n\\t$cds_number\\n\";\n    return(0);\n  }\n\n  # get max and min, check flankings\n  my ($min,$max)=$self->rangeofarray(@{$genefeatureshash->{'labels'}}); # gene \"boundaries\"\n  my $seqlength=$entry->{'SeqLength'};\n  my ($mindna,$maxdna); # some flanking region next to the gene \"boundaries\"\n  if ($min-$flanking < 1) {\n    $mindna=1;\n  } else {\n    $mindna=$min-$flanking;\n  }\n  if ($max+$flanking > $seqlength) {\n    $maxdna=$seqlength;\n  } else {\n    $maxdna=$max+$flanking;\n  }\n  my $subseq=substr($entry->{'Sequence'},$mindna-1,$maxdna-$mindna+1);\n\n  # create LiveSeq objects\n\n  # create DNA\n  my $dna=Bio::LiveSeq::DNA->new(-seq => $subseq, -offset => $mindna);\n  $dna->alphabet(lc($entry->{'Molecule'}));\n  $dna->source($entry->{'Organism'});\n  $dna->display_id($entry->{'ID'});\n  $dna->accession_number($entry->{'AccNumber'});\n  $dna->desc($entry->{'Description'});\n\n  my @transcripts=@{$genefeatureshash->{'transcripts'}};\n  # create Translations, Transcripts, Exons out of the CDS\n  unless (@transcripts) {\n    cluck \"no CDS feature found for /$input/....\";\n    return(0);\n  }\n  my @translationobjs=$self->transexonscreation($dna,\\@transcripts);\n  my @transcriptobjs;\n\n  # get the Transcript obj_refs\n  my $translation;\n  my $j=0;\n  my @ttables=@{$genefeatureshash->{'ttables'}};\n  my @swisshashes=@{$genefeatureshash->{'swisshashes'}};\n  foreach $translation (@translationobjs) {\n    push(@transcriptobjs,$translation->get_Transcript);\n    if ($ttables[$j]) { # if not undef\n      $translation->get_Transcript->translation_table($ttables[$j]);\n    #} else { # DEBUG\n    #  print \"\\n\\t\\tno translation table information....\\n\";\n    }\n    if ($swisshashes[$j]) { # if not 0\n      $self->swisshash2liveseq($swisshashes[$j],$translation);\n    }\n    $j++;\n  }\n\n  my %gene; # this is the hash to store created object references\n  $gene{DNA}=$dna;\n  $gene{Transcripts}=\\@transcriptobjs;\n  $gene{Translations}=\\@translationobjs;\n\n  my @exonobjs; my @intronobjs;\n  my @repeatunitobjs; my @repeatregionobjs;\n  my @primtranscriptobjs;\n\n  my ($object,$range,$start,$end,$strand);\n\n  my @exons=@{$genefeatureshash->{'exons'}};\n  my @exondescs=@{$genefeatureshash->{'exondescs'}};\n  if (@exons) {\n    my $exoncount = 0;\n    foreach $range (@exons) {\n      ($start,$end,$strand)=@{$range};\n      $object = Bio::LiveSeq::Exon->new(-seq=>$dna,-start=>$start,-end=>$end,-strand=>$strand);\n      if ($object != -1) {\n\t$object->desc($exondescs[$exoncount]) if defined $exondescs[$exoncount];\n\t$exoncount++;\n\tpush (@exonobjs,$object);\n      } else {\n\t$exoncount++;\n      }\n    }\n    $gene{Exons}=\\@exonobjs;\n  }\n  my @introns=@{$genefeatureshash->{'introns'}};\n  my @introndescs=@{$genefeatureshash->{'introndescs'}};\n  if (@introns) {\n    my $introncount = 0;\n    foreach $range (@introns) {\n      ($start,$end,$strand)=@{$range};\n      $object=Bio::LiveSeq::Intron->new(-seq=>$dna,-start=>$start,-end=>$end,-strand=>$strand);\n      if ($object != -1) {\n\t$object->desc($introndescs[$introncount]);\n\t$introncount++;\n\tpush (@intronobjs,$object);\n      } else {\n\t$introncount++;\n      }\n    }\n    $gene{Introns}=\\@intronobjs;\n  }\n  my @prim_transcripts=@{$genefeatureshash->{'prim_transcripts'}};\n  if (@prim_transcripts) {\n    foreach $range (@prim_transcripts) {\n      ($start,$end,$strand)=@{$range};\n      $object=Bio::LiveSeq::Prim_Transcript->new(-seq=>$dna,-start=>$start,-end=>$end,-strand=>$strand);\n      if ($object != -1) { push (@primtranscriptobjs,$object); }\n    }\n    $gene{Prim_Transcripts}=\\@primtranscriptobjs;\n  }\n  my @repeat_regions=@{$genefeatureshash->{'repeat_regions'}};\n  my @repeat_regions_family=@{$genefeatureshash->{'repeat_regions_family'}};\n  if (@repeat_regions) {\n    my $k=0;\n    foreach $range (@repeat_regions) {\n      ($start,$end,$strand)=@{$range};\n      $object=Bio::LiveSeq::Repeat_Region->new(-seq=>$dna,-start=>$start,-end=>$end,-strand=>$strand);\n      if ($object != -1) {\n\t$object->desc($repeat_regions_family[$k]);\n\t$k++;\n\tpush (@repeatregionobjs,$object);\n      } else {\n\t$k++;\n      }\n    }\n    $gene{Repeat_Regions}=\\@repeatregionobjs;\n  }\n  my @repeat_units=@{$genefeatureshash->{'repeat_units'}};\n  my @repeat_units_family=@{$genefeatureshash->{'repeat_units_family'}};\n  if (@repeat_units) {\n    my $k=0;\n    foreach $range (@repeat_units) {\n      ($start,$end,$strand)=@{$range};\n      $object=Bio::LiveSeq::Repeat_Unit->new(-seq=>$dna,-start=>$start,-end=>$end,-strand=>$strand);\n      if ($object != -1) {\n\t$object->desc($repeat_units_family[$k]);\n\t$k++;\n\tpush (@repeatunitobjs,$object);\n      } else {\n\t$k++;\n      }\n    }\n    $gene{Repeat_Units}=\\@repeatunitobjs;\n  }\n\n  # create the Gene\n  my $gene_name=$genefeatureshash->{'gene_name'}; # either a name or a cdspos\n  return (Bio::LiveSeq::Gene->new(-name=>$gene_name,-features=>\\%gene,\n                                  -upbound=>$min,-downbound=>$max));\n}\n\n# maybe this function will be moved to general utility package\n# argument: array of numbers\n# returns: (min,max) numbers in the array\nsub rangeofarray {\n  my $self=shift;\n  my @array=@_;\n  #print \"\\n-=-=-=-=-=-=-=-=-=-=array: @array\\n\";\n  my ($max,$min,$element);\n  $min=$max=shift(@array);\n  foreach $element (@array) {\n      $element = 0 unless defined $element;\n    if ($element < $min) {\n      $min=$element;\n    }\n    if ($element > $max) {\n      $max=$element;\n    }\n  }\n  #print \"\\n-=-=-=-=-=-=-=-=-=-=min: $min\\tmax: $max\\n\";\n  return ($min,$max);\n}\n\n\n# argument: reference to DNA object, reference to array of transcripts\n# returns: an array of Translation object references\nsub transexonscreation {\n  my $self=shift;\n  my $dna=$_[0];\n  my @transcripts=@{$_[1]};\n\n  my (@transexons,$start,$end,$strand,$exonref,$exonobj,$transcript,$transcriptobj);\n  my $translationobj;\n  my @translationobjects;\n  foreach $transcript (@transcripts) {\n    foreach $exonref (@{$transcript}) {\n      ($start,$end,$strand)=@{$exonref};\n      #print \"Creating Exon: start $start end $end strand $strand\\n\";\n      $exonobj=Bio::LiveSeq::Exon->new(-seq=>$dna,-start=>$start,-end=>$end,-strand=>$strand);\n      #push (@exonobjects,$exonobj);\n      push (@transexons,$exonobj);\n    }\n    $transcriptobj=Bio::LiveSeq::Transcript->new(-exons => \\@transexons );\n    if ($transcriptobj != -1) {\n      $translationobj=Bio::LiveSeq::Translation->new(-transcript=>$transcriptobj);\n      @transexons=(); # cleans it\n      #push (@transcriptobjects,$transcriptobj);\n      push (@translationobjects,$translationobj);\n    }\n  }\n  return (@translationobjects);\n}\n\n#sub printgene {\n# deleted. Some functionality placed in Gene->printfeaturesnum\n\n=head2 printswissprot\n\n  Title   : printswissprot\n  Usage   : $loader->printswissprot($hashref);\n  Function: prints out all informations loaded from a database entry into the\n            loader. Mainly used for testing purposes.\n  Args    : a hashref containing the SWISSPROT entry datas\n  Note    : the hashref can be obtained with a call to the method\n               $loader->get_swisshash()      (BioPerl via Bio::DB::EMBL.pm)\n\t    that takes as argument a string like \"SWISS-PROT:P10275\"\n\n argument: hashref containing the SWISSPROT entry datas\n prints out that hash, showing the informations loaded","parameters":[{"label":"$self"},{"label":"$entry"}]},"kind":12,"range":{"end":{"line":534,"character":9999},"start":{"character":0,"line":507}},"line":507},{"name":"features","kind":12,"line":529},{"definition":"sub","detail":"($self,$entry)","children":[{"name":"$self","localvar":"my","containerName":"printembl","kind":13,"line":550,"definition":"my"},{"kind":13,"containerName":"printembl","name":"$entry","line":550},{"kind":13,"containerName":"printembl","name":"$entry","line":551},{"containerName":"printembl","kind":13,"name":"$entry","line":552},{"line":552,"kind":13,"containerName":"printembl","name":"$self"},{"definition":"my","line":554,"kind":13,"localvar":"my","containerName":"printembl","name":"$i"},{"name":"$featurename","containerName":"printembl","kind":13,"line":554},{"line":556,"kind":13,"containerName":"printembl","name":"$entry"},{"line":558,"name":"$entry","kind":13,"containerName":"printembl"},{"line":560,"kind":13,"containerName":"printembl","name":"$entry"},{"containerName":"printembl","kind":13,"name":"$entry","line":562},{"kind":13,"containerName":"printembl","name":"$entry","line":564},{"kind":13,"containerName":"printembl","name":"$entry","line":566},{"line":568,"name":"$entry","containerName":"printembl","kind":13},{"kind":13,"containerName":"printembl","name":"$entry","line":570},{"localvar":"my","containerName":"printembl","kind":13,"name":"@features","line":571,"definition":"my"},{"line":571,"kind":13,"containerName":"printembl","name":"$entry"}],"containerName":"main::","name":"printembl","signature":{"documentation":"1;\n# $Id: Loader.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::IO::Loader\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::IO::Loader - Parent Loader for LiveSeq\n\n=head1 SYNOPSIS\n\n  #documentation needed\n\n=head1 DESCRIPTION\n\nThis package holds common methods used by BioPerl and file loaders.\nIt contains methods to create LiveSeq objects out of entire entries or from a\nlocalized sequence region surrounding a particular gene.\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::IO::Loader;\n\nuse strict;\nuse Carp qw(cluck croak carp);\nuse Bio::LiveSeq::DNA;\nuse Bio::LiveSeq::Exon;\nuse Bio::LiveSeq::Transcript ;\nuse Bio::LiveSeq::Translation;\nuse Bio::LiveSeq::Gene;\nuse Bio::LiveSeq::Intron;\nuse Bio::LiveSeq::Prim_Transcript;\nuse Bio::LiveSeq::Repeat_Region;\nuse Bio::LiveSeq::Repeat_Unit;\nuse Bio::LiveSeq::AARange;\nuse Bio::Tools::CodonTable;\n\n=head2 entry2liveseq\n\n  Title   : entry2liveseq\n  Usage   : @translationobjects=$loader->entry2liveseq();\n          : @translationobjects=$loader->entry2liveseq(-getswissprotinfo => 0);\n  Function: creates LiveSeq objects from an entry previously loaded\n  Returns : array of references to objects of class Translation\n  Errorcode 0\n  Args    : optional boolean flag to avoid the retrieval of SwissProt\n            informations for all Transcripts containing SwissProt x-reference\n            default is 1 (to retrieve those informations and create AARange\n            LiveSeq objects)\n  Note    : this method can get really slow for big entries. The lightweight\n            gene2liveseq method is recommended\n\n\nsub entry2liveseq {\n  my ($self, %args) = @_;\n  my ($getswissprotinfo)=($args{-getswissprotinfo});\n  if (defined($getswissprotinfo)) {\n    if (($getswissprotinfo ne 0)&&($getswissprotinfo ne 1)) {\n      carp \"-getswissprotinfo argument can take only boolean (1 or 0) values. Setting it to 0, i.e. not trying to retrieve SwissProt information....\";\n      $getswissprotinfo=0;\n    }\n  } else {\n    $getswissprotinfo=1;\n  }\n  my $hashref=$self->{'hash'};\n  unless ($hashref) { return (0); }\n  my @translationobjects=$self->hash2liveseq($hashref,$getswissprotinfo);\n  my $test_transl=0;\n  if ($test_transl) { $self->test_transl($hashref,\\@translationobjects);}\n  return @translationobjects;\n}\n\n=head2 novelaasequence2gene\n\n  Title   : novelaasequence2gene\n  Usage   : $gene=$loader->novelaasequence2gene(-aasequence => \"MGLAAPTRS*\");\n          : $gene=$loader->novelaasequence2gene(-aasequence => \"MGLAAPTRS*\");\n                                             -taxon => 9606,\n                                             -gene_name => \"tyr-kinase\");\n\n  Function: creates LiveSeq objects from a novel amino acid sequence,\n            using codon usage database to choose codons according to\n            relative frequencies.\n            If a taxon ID is not specified, the default is to use the human\n            one (taxonomy ID 9606).\n  Returns : reference to a Gene object containing references to LiveSeq objects\n  Errorcode 0\n  Args    : string containing an amino acid sequence\n            integer (optional) with a taxonomy ID\n            string specifying a gene name\n\n\n=head2 gene2liveseq\n\n  Title   : gene2liveseq\n  Usage   : $gene=$loader->gene2liveseq(-gene_name => \"gene name\");\n          : $gene=$loader->gene2liveseq(-gene_name => \"gene name\",\n                                        -flanking => 64);\n          : $gene=$loader->gene2liveseq(-gene_name => \"gene name\",\n                                        -getswissprotinfo => 0);\n          : $gene=$loader->gene2liveseq(-position => 4);\n\n  Function: creates LiveSeq objects from an entry previously loaded\n            It is a \"light weight\" creation because it creates\n            a LiveSequence just for the interesting region in an entry\n            (instead than for the total entry, like in entry2liveseq) and for\n            the flanking regions up to 500 nucleotides (default) or up to\n            the specified amount of nucleotides (given as argument) around the\n            Gene.\n  Returns : reference to a Gene object containing possibly alternative\n            Transcripts.\n  Errorcode 0\n  Args    : string containing the gene name as in the EMBL feature qualifier\n            integer (optional) \"flanking\": amount of flanking bases to be kept\n            boolean (optional) \"getswissprotinfo\": if set to \"0\" it will avoid\n             trying to fetch information from a crossreference to a SwissProt\n             entry, avoding the process of creation of AARange objects\n             It is \"1\" (on) by default\n\n            Alternative to a gene_name, a position can be given: an\n            integer (1-) containing the position of the desired CDS in the\n            loaded entry\n\n\nsub gene2liveseq {\n  my ($self, %args) = @_;\n  my ($gene_name,$flanking,$getswissprotinfo,$cds_position)=($args{-gene_name},$args{-flanking},$args{-getswissprotinfo},$args{-position});\n  my $input;\n  unless (($gene_name)||($cds_position)) {\n    carp \"Gene_Name or Position not specified for gene2liveseq loading function\";\n    return (0);\n  }\n  if (($gene_name)&&($cds_position)) {\n    carp \"Gene_Name and Position cannot be given together\";\n    return (0);\n  } elsif ($gene_name) {\n    $input=$gene_name;\n  } else {\n    $input=\"cds-position:\".$cds_position;\n  }\n\n  if (defined($getswissprotinfo)) {\n    if (($getswissprotinfo ne 0)&&($getswissprotinfo ne 1)) {\n      carp \"-getswissprotinfo argument can take only boolean (1 or 0) values. Setting it to 0, i.e. not trying to retrieve SwissProt information....\";\n      $getswissprotinfo=0;\n    }\n  } else {\n    $getswissprotinfo=1;\n  }\n\n  if (defined($flanking)) {\n    unless ($flanking >= 0) {\n      carp \"No sense in specifying a number < 0 for flanking regions to be created for gene2liveseq loading function\";\n      return (0);\n    }\n  } else {\n    $flanking=500; # the default flanking length\n  }\n  my $hashref=$self->{'hash'};\n  unless ($hashref) { return (0); }\n  my $gene=$self->hash2gene($hashref,$input,$flanking,$getswissprotinfo);\n  unless ($gene) { # if $gene == 0 it means problems in hash2gene\n    carp \"gene2liveseq produced error\";\n    return (0);\n  }\n  return $gene;\n}\n\n# TODO: update so that it will work even if CDS is not only accepted FEATURE!!\n# this method is for now deprecated and not supported\nsub test_transl {\n  my ($self,$entry)=@_;\n  my @features=@{$entry->{'Features'}};\n  my @translationobjects=@{$_[1]};\n  my ($i,$translation);\n  my ($obj_transl,$hash_transl);\n  my @cds=@{$entry->{'CDS'}};\n  foreach $translation (@translationobjects) {\n    $obj_transl=$translation->seq;\n    $hash_transl=$cds[$i]->{'qualifiers'}->{'translation'};\n    #before seq was changed in Translation 1.4# chop $obj_transl; # to remove trailing \"*\"\n    unless ($obj_transl eq $hash_transl) {\n      cluck \"Serious error: Translation from the Entry does not match Translation from object's seq for CDS at position $i\";\n      carp \"\\nEntry's transl: \",$hash_transl,\"\\n\";\n      carp \"\\nObject's transl: \",$obj_transl,\"\\n\";\n      exit;\n    }\n    $i++;\n  }\n}\n\n# argument: hashref containing the EMBL entry datas,\n#           getswissprotinfo boolean flag\n# creates the liveseq objects\n# returns: an array of Translation object references\nsub hash2liveseq {\n  my ($self,$entry,$getswissprotinfo)=@_;\n  my $i;\n  my @transcripts;\n  my $dna=Bio::LiveSeq::DNA->new(-seq => $entry->{'Sequence'} );\n  $dna->alphabet(lc($entry->{'Molecule'}));\n  $dna->display_id($entry->{'ID'});\n  $dna->accession_number($entry->{'AccNumber'});\n  $dna->desc($entry->{'Description'});\n  my @cds=@{$entry->{'CDS'}};\n  my ($swissacc,$swisshash); my @swisshashes;\n  for $i (0..$#cds) {\n    #my @transcript=@{$cds[$i]->{'range'}};\n    #$transcript=\\@transcript;\n    #push (@transcripts,$transcript);\n    push (@transcripts,$cds[$i]->{'range'});\n    if ($getswissprotinfo) {\n      $swissacc=$cds[$i]->{'qualifiers'}->{'db_xref'};\n      $swisshash=$self->get_swisshash($swissacc);\n      #$self->printswissprot($swisshash); # DEBUG\n      push (@swisshashes,$swisshash);\n    }\n  }\n  my @translations=($self->transexonscreation($dna,\\@transcripts));\n  my $translation; my $j=0;\n  foreach $translation (@translations) {\n    if ($swisshashes[$j]) { # if not 0\n      $self->swisshash2liveseq($swisshashes[$j],$translation);\n    }\n    $j++;\n  }\n  return (@translations);\n}\n\n# only features pertaining to a specified gene are created\n# only the sequence of the gene and appropriate context flanking regions\n# are created as chain\n# arguments: hashref, gene_name (OR: cds_position), length_of_flanking_sequences, getswissprotinfo boolean flag\n# returns: reference to Gene object\n#\n# Note: if entry contains just one CDS, all the features get added\n#       this is useful because often the features in these entries do not\n#       carry the /gene qualifier\n#\n# errorcode: 0\nsub hash2gene {\n  my ($self,$entry,$input,$flanking,$getswissprotinfo)=@_;\n  my $entryfeature;\n  my $genefeatureshash;\n\n  my @cds=@{$entry->{'CDS'}};\n\n  # checking if a position has been given instead than a gene_name\n  if (index($input,\"cds-position:\") == 0 ) {\n    my $cds_position=substr($input,13); # extracting the cds position\n    if (($cds_position >= 1)&&($cds_position <= scalar(@cds))) {\n      $genefeatureshash=$self->_findgenefeatures($entry,undef,$cds_position,$getswissprotinfo);\n    }\n  } else {\n    $genefeatureshash=$self->_findgenefeatures($entry,$input,undef,$getswissprotinfo);\n  }\n\n  unless (($genefeatureshash)&&(scalar(@{$genefeatureshash->{'genefeatures'}}))) { # array empty, no gene features found\n    my @genes=$self->genes($entry);\n    my $cds_number=scalar(@cds);\n    warn \"Warning! Not even one genefeature found for /$input/....\n    The genes present in this entry are:\\n\\t@genes\\n\n    The number of CDS in this entry is:\\n\\t$cds_number\\n\";\n    return(0);\n  }\n\n  # get max and min, check flankings\n  my ($min,$max)=$self->rangeofarray(@{$genefeatureshash->{'labels'}}); # gene \"boundaries\"\n  my $seqlength=$entry->{'SeqLength'};\n  my ($mindna,$maxdna); # some flanking region next to the gene \"boundaries\"\n  if ($min-$flanking < 1) {\n    $mindna=1;\n  } else {\n    $mindna=$min-$flanking;\n  }\n  if ($max+$flanking > $seqlength) {\n    $maxdna=$seqlength;\n  } else {\n    $maxdna=$max+$flanking;\n  }\n  my $subseq=substr($entry->{'Sequence'},$mindna-1,$maxdna-$mindna+1);\n\n  # create LiveSeq objects\n\n  # create DNA\n  my $dna=Bio::LiveSeq::DNA->new(-seq => $subseq, -offset => $mindna);\n  $dna->alphabet(lc($entry->{'Molecule'}));\n  $dna->source($entry->{'Organism'});\n  $dna->display_id($entry->{'ID'});\n  $dna->accession_number($entry->{'AccNumber'});\n  $dna->desc($entry->{'Description'});\n\n  my @transcripts=@{$genefeatureshash->{'transcripts'}};\n  # create Translations, Transcripts, Exons out of the CDS\n  unless (@transcripts) {\n    cluck \"no CDS feature found for /$input/....\";\n    return(0);\n  }\n  my @translationobjs=$self->transexonscreation($dna,\\@transcripts);\n  my @transcriptobjs;\n\n  # get the Transcript obj_refs\n  my $translation;\n  my $j=0;\n  my @ttables=@{$genefeatureshash->{'ttables'}};\n  my @swisshashes=@{$genefeatureshash->{'swisshashes'}};\n  foreach $translation (@translationobjs) {\n    push(@transcriptobjs,$translation->get_Transcript);\n    if ($ttables[$j]) { # if not undef\n      $translation->get_Transcript->translation_table($ttables[$j]);\n    #} else { # DEBUG\n    #  print \"\\n\\t\\tno translation table information....\\n\";\n    }\n    if ($swisshashes[$j]) { # if not 0\n      $self->swisshash2liveseq($swisshashes[$j],$translation);\n    }\n    $j++;\n  }\n\n  my %gene; # this is the hash to store created object references\n  $gene{DNA}=$dna;\n  $gene{Transcripts}=\\@transcriptobjs;\n  $gene{Translations}=\\@translationobjs;\n\n  my @exonobjs; my @intronobjs;\n  my @repeatunitobjs; my @repeatregionobjs;\n  my @primtranscriptobjs;\n\n  my ($object,$range,$start,$end,$strand);\n\n  my @exons=@{$genefeatureshash->{'exons'}};\n  my @exondescs=@{$genefeatureshash->{'exondescs'}};\n  if (@exons) {\n    my $exoncount = 0;\n    foreach $range (@exons) {\n      ($start,$end,$strand)=@{$range};\n      $object = Bio::LiveSeq::Exon->new(-seq=>$dna,-start=>$start,-end=>$end,-strand=>$strand);\n      if ($object != -1) {\n\t$object->desc($exondescs[$exoncount]) if defined $exondescs[$exoncount];\n\t$exoncount++;\n\tpush (@exonobjs,$object);\n      } else {\n\t$exoncount++;\n      }\n    }\n    $gene{Exons}=\\@exonobjs;\n  }\n  my @introns=@{$genefeatureshash->{'introns'}};\n  my @introndescs=@{$genefeatureshash->{'introndescs'}};\n  if (@introns) {\n    my $introncount = 0;\n    foreach $range (@introns) {\n      ($start,$end,$strand)=@{$range};\n      $object=Bio::LiveSeq::Intron->new(-seq=>$dna,-start=>$start,-end=>$end,-strand=>$strand);\n      if ($object != -1) {\n\t$object->desc($introndescs[$introncount]);\n\t$introncount++;\n\tpush (@intronobjs,$object);\n      } else {\n\t$introncount++;\n      }\n    }\n    $gene{Introns}=\\@intronobjs;\n  }\n  my @prim_transcripts=@{$genefeatureshash->{'prim_transcripts'}};\n  if (@prim_transcripts) {\n    foreach $range (@prim_transcripts) {\n      ($start,$end,$strand)=@{$range};\n      $object=Bio::LiveSeq::Prim_Transcript->new(-seq=>$dna,-start=>$start,-end=>$end,-strand=>$strand);\n      if ($object != -1) { push (@primtranscriptobjs,$object); }\n    }\n    $gene{Prim_Transcripts}=\\@primtranscriptobjs;\n  }\n  my @repeat_regions=@{$genefeatureshash->{'repeat_regions'}};\n  my @repeat_regions_family=@{$genefeatureshash->{'repeat_regions_family'}};\n  if (@repeat_regions) {\n    my $k=0;\n    foreach $range (@repeat_regions) {\n      ($start,$end,$strand)=@{$range};\n      $object=Bio::LiveSeq::Repeat_Region->new(-seq=>$dna,-start=>$start,-end=>$end,-strand=>$strand);\n      if ($object != -1) {\n\t$object->desc($repeat_regions_family[$k]);\n\t$k++;\n\tpush (@repeatregionobjs,$object);\n      } else {\n\t$k++;\n      }\n    }\n    $gene{Repeat_Regions}=\\@repeatregionobjs;\n  }\n  my @repeat_units=@{$genefeatureshash->{'repeat_units'}};\n  my @repeat_units_family=@{$genefeatureshash->{'repeat_units_family'}};\n  if (@repeat_units) {\n    my $k=0;\n    foreach $range (@repeat_units) {\n      ($start,$end,$strand)=@{$range};\n      $object=Bio::LiveSeq::Repeat_Unit->new(-seq=>$dna,-start=>$start,-end=>$end,-strand=>$strand);\n      if ($object != -1) {\n\t$object->desc($repeat_units_family[$k]);\n\t$k++;\n\tpush (@repeatunitobjs,$object);\n      } else {\n\t$k++;\n      }\n    }\n    $gene{Repeat_Units}=\\@repeatunitobjs;\n  }\n\n  # create the Gene\n  my $gene_name=$genefeatureshash->{'gene_name'}; # either a name or a cdspos\n  return (Bio::LiveSeq::Gene->new(-name=>$gene_name,-features=>\\%gene,\n                                  -upbound=>$min,-downbound=>$max));\n}\n\n# maybe this function will be moved to general utility package\n# argument: array of numbers\n# returns: (min,max) numbers in the array\nsub rangeofarray {\n  my $self=shift;\n  my @array=@_;\n  #print \"\\n-=-=-=-=-=-=-=-=-=-=array: @array\\n\";\n  my ($max,$min,$element);\n  $min=$max=shift(@array);\n  foreach $element (@array) {\n      $element = 0 unless defined $element;\n    if ($element < $min) {\n      $min=$element;\n    }\n    if ($element > $max) {\n      $max=$element;\n    }\n  }\n  #print \"\\n-=-=-=-=-=-=-=-=-=-=min: $min\\tmax: $max\\n\";\n  return ($min,$max);\n}\n\n\n# argument: reference to DNA object, reference to array of transcripts\n# returns: an array of Translation object references\nsub transexonscreation {\n  my $self=shift;\n  my $dna=$_[0];\n  my @transcripts=@{$_[1]};\n\n  my (@transexons,$start,$end,$strand,$exonref,$exonobj,$transcript,$transcriptobj);\n  my $translationobj;\n  my @translationobjects;\n  foreach $transcript (@transcripts) {\n    foreach $exonref (@{$transcript}) {\n      ($start,$end,$strand)=@{$exonref};\n      #print \"Creating Exon: start $start end $end strand $strand\\n\";\n      $exonobj=Bio::LiveSeq::Exon->new(-seq=>$dna,-start=>$start,-end=>$end,-strand=>$strand);\n      #push (@exonobjects,$exonobj);\n      push (@transexons,$exonobj);\n    }\n    $transcriptobj=Bio::LiveSeq::Transcript->new(-exons => \\@transexons );\n    if ($transcriptobj != -1) {\n      $translationobj=Bio::LiveSeq::Translation->new(-transcript=>$transcriptobj);\n      @transexons=(); # cleans it\n      #push (@transcriptobjects,$transcriptobj);\n      push (@translationobjects,$translationobj);\n    }\n  }\n  return (@translationobjects);\n}\n\n#sub printgene {\n# deleted. Some functionality placed in Gene->printfeaturesnum\n\n=head2 printswissprot\n\n  Title   : printswissprot\n  Usage   : $loader->printswissprot($hashref);\n  Function: prints out all informations loaded from a database entry into the\n            loader. Mainly used for testing purposes.\n  Args    : a hashref containing the SWISSPROT entry datas\n  Note    : the hashref can be obtained with a call to the method\n               $loader->get_swisshash()      (BioPerl via Bio::DB::EMBL.pm)\n\t    that takes as argument a string like \"SWISS-PROT:P10275\"\n\n\n# argument: hashref containing the SWISSPROT entry datas\n# prints out that hash, showing the informations loaded\nsub printswissprot {\n  my ($self,$entry)=@_;\n  unless ($entry) {\n    return;\n  }\n  printf \"ID: %s\\n\",\n      $entry->{'ID'};\n  printf \"ACC: %s\\n\",\n      $entry->{'AccNumber'};\n  printf \"GENE: %s\\n\",\n      $entry->{'Gene'};\n  printf \"DES: %s\\n\",\n      $entry->{'Description'};\n  printf \"ORG: %s\\n\",\n      $entry->{'Organism'};\n  printf \"SEQLN: %s\\n\",\n      $entry->{'SeqLength'};\n  printf \"SEQ: %s\\n\",\n      substr($entry->{'Sequence'},0,64);\n  if ($entry->{'Features'}) {\n    my @features=@{$entry->{'Features'}};\n    my $i;\n    for $i (0..$#features) {\n      print \"|\",$features[$i]->{'name'},\"|\";\n      print \" at \",$features[$i]->{'location'},\": \";\n      print \"\",$features[$i]->{'desc'},\"\\n\";\n    }\n  }\n}\n\n=head2 printembl\n\n  Title   : printembl\n  Usage   : $loader->printembl();\n  Function: prints out all informations loaded from a database entry into the\n            loader. Mainly used for testing purposes.\n  Args    : none\n\n argument: hashref containing the EMBL entry datas\n prints out that hash, showing the informations loaded","parameters":[{"label":"$self"},{"label":"$entry"}],"label":"printembl($self,$entry)"},"line":549,"range":{"end":{"character":9999,"line":571},"start":{"character":0,"line":549}},"kind":12},{"definition":"my","name":"@cds","localvar":"my","containerName":null,"kind":13,"line":572},{"name":"%entry","kind":13,"containerName":null,"line":572},{"line":573,"name":"@cds","kind":13,"containerName":null},{"name":"%entry","kind":13,"containerName":null,"line":573},{"line":574,"localvar":"my","kind":13,"containerName":null,"name":"$exonref","definition":"my"},{"kind":13,"containerName":null,"name":"$transcript","line":574},{"name":"$qualifiernumber","kind":13,"localvar":"my","containerName":null,"line":575,"definition":"my"},{"line":575,"name":"$qualifiers","containerName":null,"kind":13},{"line":575,"name":"$key","kind":13,"containerName":null},{"definition":"my","line":576,"kind":13,"localvar":"my","containerName":null,"name":"$start"},{"kind":13,"containerName":null,"name":"$end","line":576},{"containerName":null,"kind":13,"name":"$strand","line":576},{"name":"$j","localvar":"my","containerName":null,"kind":13,"line":577,"definition":"my"},{"kind":13,"containerName":null,"name":"$i","line":578},{"line":578,"kind":12,"name":"features"},{"kind":13,"containerName":null,"name":"$featurename","line":579},{"containerName":null,"kind":13,"name":"@features","line":579},{"line":579,"name":"%i","kind":13,"containerName":null},{"line":580,"name":"%featurename","containerName":null,"kind":13},{"line":583,"name":"$transcript","containerName":null,"kind":13},{"name":"@features","containerName":null,"kind":13,"line":583},{"name":"%i","kind":13,"containerName":null,"line":583},{"line":584,"name":"$exonref","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"%transcript","line":584},{"kind":13,"containerName":null,"name":"$start","line":585},{"line":585,"name":"$end","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"$strand","line":585},{"line":585,"name":"$exonref","kind":13,"containerName":null},{"line":588,"containerName":null,"kind":13,"name":"%j"},{"line":592,"name":"@features","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"%i","line":592},{"line":595,"name":"$qualifiernumber","kind":13,"containerName":null},{"line":595,"name":"@features","kind":13,"containerName":null},{"line":595,"name":"%i","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"$qualifiers","line":596},{"name":"@features","containerName":null,"kind":13,"line":596},{"line":596,"name":"%i","containerName":null,"kind":13},{"name":"$key","containerName":null,"kind":13,"line":597},{"line":597,"kind":13,"containerName":null,"name":"%qualifiers"},{"containerName":null,"kind":13,"name":"$key","line":598},{"line":599,"kind":13,"containerName":null,"name":"%qualifiers"},{"line":599,"name":"$key","kind":13,"containerName":null},{"name":"genes","containerName":"main::","children":[{"line":617,"name":"$self","containerName":"genes","localvar":"my","kind":13,"definition":"my"},{"kind":13,"containerName":"genes","name":"$entry","line":617},{"name":"$entry","kind":13,"containerName":"genes","line":618},{"containerName":"genes","kind":13,"name":"$entry","line":619},{"name":"$self","kind":13,"containerName":"genes","line":619},{"definition":"my","line":621,"localvar":"my","kind":13,"containerName":"genes","name":"@entryfeatures"},{"line":621,"kind":13,"containerName":"genes","name":"$entry"}],"detail":"($self,$entry)","definition":"sub","kind":12,"range":{"end":{"line":621,"character":9999},"start":{"character":0,"line":616}},"line":616,"signature":{"label":"genes($self,$entry)","documentation":"1;\n# $Id: Loader.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::IO::Loader\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::IO::Loader - Parent Loader for LiveSeq\n\n=head1 SYNOPSIS\n\n  #documentation needed\n\n=head1 DESCRIPTION\n\nThis package holds common methods used by BioPerl and file loaders.\nIt contains methods to create LiveSeq objects out of entire entries or from a\nlocalized sequence region surrounding a particular gene.\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::IO::Loader;\n\nuse strict;\nuse Carp qw(cluck croak carp);\nuse Bio::LiveSeq::DNA;\nuse Bio::LiveSeq::Exon;\nuse Bio::LiveSeq::Transcript ;\nuse Bio::LiveSeq::Translation;\nuse Bio::LiveSeq::Gene;\nuse Bio::LiveSeq::Intron;\nuse Bio::LiveSeq::Prim_Transcript;\nuse Bio::LiveSeq::Repeat_Region;\nuse Bio::LiveSeq::Repeat_Unit;\nuse Bio::LiveSeq::AARange;\nuse Bio::Tools::CodonTable;\n\n=head2 entry2liveseq\n\n  Title   : entry2liveseq\n  Usage   : @translationobjects=$loader->entry2liveseq();\n          : @translationobjects=$loader->entry2liveseq(-getswissprotinfo => 0);\n  Function: creates LiveSeq objects from an entry previously loaded\n  Returns : array of references to objects of class Translation\n  Errorcode 0\n  Args    : optional boolean flag to avoid the retrieval of SwissProt\n            informations for all Transcripts containing SwissProt x-reference\n            default is 1 (to retrieve those informations and create AARange\n            LiveSeq objects)\n  Note    : this method can get really slow for big entries. The lightweight\n            gene2liveseq method is recommended\n\n\nsub entry2liveseq {\n  my ($self, %args) = @_;\n  my ($getswissprotinfo)=($args{-getswissprotinfo});\n  if (defined($getswissprotinfo)) {\n    if (($getswissprotinfo ne 0)&&($getswissprotinfo ne 1)) {\n      carp \"-getswissprotinfo argument can take only boolean (1 or 0) values. Setting it to 0, i.e. not trying to retrieve SwissProt information....\";\n      $getswissprotinfo=0;\n    }\n  } else {\n    $getswissprotinfo=1;\n  }\n  my $hashref=$self->{'hash'};\n  unless ($hashref) { return (0); }\n  my @translationobjects=$self->hash2liveseq($hashref,$getswissprotinfo);\n  my $test_transl=0;\n  if ($test_transl) { $self->test_transl($hashref,\\@translationobjects);}\n  return @translationobjects;\n}\n\n=head2 novelaasequence2gene\n\n  Title   : novelaasequence2gene\n  Usage   : $gene=$loader->novelaasequence2gene(-aasequence => \"MGLAAPTRS*\");\n          : $gene=$loader->novelaasequence2gene(-aasequence => \"MGLAAPTRS*\");\n                                             -taxon => 9606,\n                                             -gene_name => \"tyr-kinase\");\n\n  Function: creates LiveSeq objects from a novel amino acid sequence,\n            using codon usage database to choose codons according to\n            relative frequencies.\n            If a taxon ID is not specified, the default is to use the human\n            one (taxonomy ID 9606).\n  Returns : reference to a Gene object containing references to LiveSeq objects\n  Errorcode 0\n  Args    : string containing an amino acid sequence\n            integer (optional) with a taxonomy ID\n            string specifying a gene name\n\n\n=head2 gene2liveseq\n\n  Title   : gene2liveseq\n  Usage   : $gene=$loader->gene2liveseq(-gene_name => \"gene name\");\n          : $gene=$loader->gene2liveseq(-gene_name => \"gene name\",\n                                        -flanking => 64);\n          : $gene=$loader->gene2liveseq(-gene_name => \"gene name\",\n                                        -getswissprotinfo => 0);\n          : $gene=$loader->gene2liveseq(-position => 4);\n\n  Function: creates LiveSeq objects from an entry previously loaded\n            It is a \"light weight\" creation because it creates\n            a LiveSequence just for the interesting region in an entry\n            (instead than for the total entry, like in entry2liveseq) and for\n            the flanking regions up to 500 nucleotides (default) or up to\n            the specified amount of nucleotides (given as argument) around the\n            Gene.\n  Returns : reference to a Gene object containing possibly alternative\n            Transcripts.\n  Errorcode 0\n  Args    : string containing the gene name as in the EMBL feature qualifier\n            integer (optional) \"flanking\": amount of flanking bases to be kept\n            boolean (optional) \"getswissprotinfo\": if set to \"0\" it will avoid\n             trying to fetch information from a crossreference to a SwissProt\n             entry, avoding the process of creation of AARange objects\n             It is \"1\" (on) by default\n\n            Alternative to a gene_name, a position can be given: an\n            integer (1-) containing the position of the desired CDS in the\n            loaded entry\n\n\nsub gene2liveseq {\n  my ($self, %args) = @_;\n  my ($gene_name,$flanking,$getswissprotinfo,$cds_position)=($args{-gene_name},$args{-flanking},$args{-getswissprotinfo},$args{-position});\n  my $input;\n  unless (($gene_name)||($cds_position)) {\n    carp \"Gene_Name or Position not specified for gene2liveseq loading function\";\n    return (0);\n  }\n  if (($gene_name)&&($cds_position)) {\n    carp \"Gene_Name and Position cannot be given together\";\n    return (0);\n  } elsif ($gene_name) {\n    $input=$gene_name;\n  } else {\n    $input=\"cds-position:\".$cds_position;\n  }\n\n  if (defined($getswissprotinfo)) {\n    if (($getswissprotinfo ne 0)&&($getswissprotinfo ne 1)) {\n      carp \"-getswissprotinfo argument can take only boolean (1 or 0) values. Setting it to 0, i.e. not trying to retrieve SwissProt information....\";\n      $getswissprotinfo=0;\n    }\n  } else {\n    $getswissprotinfo=1;\n  }\n\n  if (defined($flanking)) {\n    unless ($flanking >= 0) {\n      carp \"No sense in specifying a number < 0 for flanking regions to be created for gene2liveseq loading function\";\n      return (0);\n    }\n  } else {\n    $flanking=500; # the default flanking length\n  }\n  my $hashref=$self->{'hash'};\n  unless ($hashref) { return (0); }\n  my $gene=$self->hash2gene($hashref,$input,$flanking,$getswissprotinfo);\n  unless ($gene) { # if $gene == 0 it means problems in hash2gene\n    carp \"gene2liveseq produced error\";\n    return (0);\n  }\n  return $gene;\n}\n\n# TODO: update so that it will work even if CDS is not only accepted FEATURE!!\n# this method is for now deprecated and not supported\nsub test_transl {\n  my ($self,$entry)=@_;\n  my @features=@{$entry->{'Features'}};\n  my @translationobjects=@{$_[1]};\n  my ($i,$translation);\n  my ($obj_transl,$hash_transl);\n  my @cds=@{$entry->{'CDS'}};\n  foreach $translation (@translationobjects) {\n    $obj_transl=$translation->seq;\n    $hash_transl=$cds[$i]->{'qualifiers'}->{'translation'};\n    #before seq was changed in Translation 1.4# chop $obj_transl; # to remove trailing \"*\"\n    unless ($obj_transl eq $hash_transl) {\n      cluck \"Serious error: Translation from the Entry does not match Translation from object's seq for CDS at position $i\";\n      carp \"\\nEntry's transl: \",$hash_transl,\"\\n\";\n      carp \"\\nObject's transl: \",$obj_transl,\"\\n\";\n      exit;\n    }\n    $i++;\n  }\n}\n\n# argument: hashref containing the EMBL entry datas,\n#           getswissprotinfo boolean flag\n# creates the liveseq objects\n# returns: an array of Translation object references\nsub hash2liveseq {\n  my ($self,$entry,$getswissprotinfo)=@_;\n  my $i;\n  my @transcripts;\n  my $dna=Bio::LiveSeq::DNA->new(-seq => $entry->{'Sequence'} );\n  $dna->alphabet(lc($entry->{'Molecule'}));\n  $dna->display_id($entry->{'ID'});\n  $dna->accession_number($entry->{'AccNumber'});\n  $dna->desc($entry->{'Description'});\n  my @cds=@{$entry->{'CDS'}};\n  my ($swissacc,$swisshash); my @swisshashes;\n  for $i (0..$#cds) {\n    #my @transcript=@{$cds[$i]->{'range'}};\n    #$transcript=\\@transcript;\n    #push (@transcripts,$transcript);\n    push (@transcripts,$cds[$i]->{'range'});\n    if ($getswissprotinfo) {\n      $swissacc=$cds[$i]->{'qualifiers'}->{'db_xref'};\n      $swisshash=$self->get_swisshash($swissacc);\n      #$self->printswissprot($swisshash); # DEBUG\n      push (@swisshashes,$swisshash);\n    }\n  }\n  my @translations=($self->transexonscreation($dna,\\@transcripts));\n  my $translation; my $j=0;\n  foreach $translation (@translations) {\n    if ($swisshashes[$j]) { # if not 0\n      $self->swisshash2liveseq($swisshashes[$j],$translation);\n    }\n    $j++;\n  }\n  return (@translations);\n}\n\n# only features pertaining to a specified gene are created\n# only the sequence of the gene and appropriate context flanking regions\n# are created as chain\n# arguments: hashref, gene_name (OR: cds_position), length_of_flanking_sequences, getswissprotinfo boolean flag\n# returns: reference to Gene object\n#\n# Note: if entry contains just one CDS, all the features get added\n#       this is useful because often the features in these entries do not\n#       carry the /gene qualifier\n#\n# errorcode: 0\nsub hash2gene {\n  my ($self,$entry,$input,$flanking,$getswissprotinfo)=@_;\n  my $entryfeature;\n  my $genefeatureshash;\n\n  my @cds=@{$entry->{'CDS'}};\n\n  # checking if a position has been given instead than a gene_name\n  if (index($input,\"cds-position:\") == 0 ) {\n    my $cds_position=substr($input,13); # extracting the cds position\n    if (($cds_position >= 1)&&($cds_position <= scalar(@cds))) {\n      $genefeatureshash=$self->_findgenefeatures($entry,undef,$cds_position,$getswissprotinfo);\n    }\n  } else {\n    $genefeatureshash=$self->_findgenefeatures($entry,$input,undef,$getswissprotinfo);\n  }\n\n  unless (($genefeatureshash)&&(scalar(@{$genefeatureshash->{'genefeatures'}}))) { # array empty, no gene features found\n    my @genes=$self->genes($entry);\n    my $cds_number=scalar(@cds);\n    warn \"Warning! Not even one genefeature found for /$input/....\n    The genes present in this entry are:\\n\\t@genes\\n\n    The number of CDS in this entry is:\\n\\t$cds_number\\n\";\n    return(0);\n  }\n\n  # get max and min, check flankings\n  my ($min,$max)=$self->rangeofarray(@{$genefeatureshash->{'labels'}}); # gene \"boundaries\"\n  my $seqlength=$entry->{'SeqLength'};\n  my ($mindna,$maxdna); # some flanking region next to the gene \"boundaries\"\n  if ($min-$flanking < 1) {\n    $mindna=1;\n  } else {\n    $mindna=$min-$flanking;\n  }\n  if ($max+$flanking > $seqlength) {\n    $maxdna=$seqlength;\n  } else {\n    $maxdna=$max+$flanking;\n  }\n  my $subseq=substr($entry->{'Sequence'},$mindna-1,$maxdna-$mindna+1);\n\n  # create LiveSeq objects\n\n  # create DNA\n  my $dna=Bio::LiveSeq::DNA->new(-seq => $subseq, -offset => $mindna);\n  $dna->alphabet(lc($entry->{'Molecule'}));\n  $dna->source($entry->{'Organism'});\n  $dna->display_id($entry->{'ID'});\n  $dna->accession_number($entry->{'AccNumber'});\n  $dna->desc($entry->{'Description'});\n\n  my @transcripts=@{$genefeatureshash->{'transcripts'}};\n  # create Translations, Transcripts, Exons out of the CDS\n  unless (@transcripts) {\n    cluck \"no CDS feature found for /$input/....\";\n    return(0);\n  }\n  my @translationobjs=$self->transexonscreation($dna,\\@transcripts);\n  my @transcriptobjs;\n\n  # get the Transcript obj_refs\n  my $translation;\n  my $j=0;\n  my @ttables=@{$genefeatureshash->{'ttables'}};\n  my @swisshashes=@{$genefeatureshash->{'swisshashes'}};\n  foreach $translation (@translationobjs) {\n    push(@transcriptobjs,$translation->get_Transcript);\n    if ($ttables[$j]) { # if not undef\n      $translation->get_Transcript->translation_table($ttables[$j]);\n    #} else { # DEBUG\n    #  print \"\\n\\t\\tno translation table information....\\n\";\n    }\n    if ($swisshashes[$j]) { # if not 0\n      $self->swisshash2liveseq($swisshashes[$j],$translation);\n    }\n    $j++;\n  }\n\n  my %gene; # this is the hash to store created object references\n  $gene{DNA}=$dna;\n  $gene{Transcripts}=\\@transcriptobjs;\n  $gene{Translations}=\\@translationobjs;\n\n  my @exonobjs; my @intronobjs;\n  my @repeatunitobjs; my @repeatregionobjs;\n  my @primtranscriptobjs;\n\n  my ($object,$range,$start,$end,$strand);\n\n  my @exons=@{$genefeatureshash->{'exons'}};\n  my @exondescs=@{$genefeatureshash->{'exondescs'}};\n  if (@exons) {\n    my $exoncount = 0;\n    foreach $range (@exons) {\n      ($start,$end,$strand)=@{$range};\n      $object = Bio::LiveSeq::Exon->new(-seq=>$dna,-start=>$start,-end=>$end,-strand=>$strand);\n      if ($object != -1) {\n\t$object->desc($exondescs[$exoncount]) if defined $exondescs[$exoncount];\n\t$exoncount++;\n\tpush (@exonobjs,$object);\n      } else {\n\t$exoncount++;\n      }\n    }\n    $gene{Exons}=\\@exonobjs;\n  }\n  my @introns=@{$genefeatureshash->{'introns'}};\n  my @introndescs=@{$genefeatureshash->{'introndescs'}};\n  if (@introns) {\n    my $introncount = 0;\n    foreach $range (@introns) {\n      ($start,$end,$strand)=@{$range};\n      $object=Bio::LiveSeq::Intron->new(-seq=>$dna,-start=>$start,-end=>$end,-strand=>$strand);\n      if ($object != -1) {\n\t$object->desc($introndescs[$introncount]);\n\t$introncount++;\n\tpush (@intronobjs,$object);\n      } else {\n\t$introncount++;\n      }\n    }\n    $gene{Introns}=\\@intronobjs;\n  }\n  my @prim_transcripts=@{$genefeatureshash->{'prim_transcripts'}};\n  if (@prim_transcripts) {\n    foreach $range (@prim_transcripts) {\n      ($start,$end,$strand)=@{$range};\n      $object=Bio::LiveSeq::Prim_Transcript->new(-seq=>$dna,-start=>$start,-end=>$end,-strand=>$strand);\n      if ($object != -1) { push (@primtranscriptobjs,$object); }\n    }\n    $gene{Prim_Transcripts}=\\@primtranscriptobjs;\n  }\n  my @repeat_regions=@{$genefeatureshash->{'repeat_regions'}};\n  my @repeat_regions_family=@{$genefeatureshash->{'repeat_regions_family'}};\n  if (@repeat_regions) {\n    my $k=0;\n    foreach $range (@repeat_regions) {\n      ($start,$end,$strand)=@{$range};\n      $object=Bio::LiveSeq::Repeat_Region->new(-seq=>$dna,-start=>$start,-end=>$end,-strand=>$strand);\n      if ($object != -1) {\n\t$object->desc($repeat_regions_family[$k]);\n\t$k++;\n\tpush (@repeatregionobjs,$object);\n      } else {\n\t$k++;\n      }\n    }\n    $gene{Repeat_Regions}=\\@repeatregionobjs;\n  }\n  my @repeat_units=@{$genefeatureshash->{'repeat_units'}};\n  my @repeat_units_family=@{$genefeatureshash->{'repeat_units_family'}};\n  if (@repeat_units) {\n    my $k=0;\n    foreach $range (@repeat_units) {\n      ($start,$end,$strand)=@{$range};\n      $object=Bio::LiveSeq::Repeat_Unit->new(-seq=>$dna,-start=>$start,-end=>$end,-strand=>$strand);\n      if ($object != -1) {\n\t$object->desc($repeat_units_family[$k]);\n\t$k++;\n\tpush (@repeatunitobjs,$object);\n      } else {\n\t$k++;\n      }\n    }\n    $gene{Repeat_Units}=\\@repeatunitobjs;\n  }\n\n  # create the Gene\n  my $gene_name=$genefeatureshash->{'gene_name'}; # either a name or a cdspos\n  return (Bio::LiveSeq::Gene->new(-name=>$gene_name,-features=>\\%gene,\n                                  -upbound=>$min,-downbound=>$max));\n}\n\n# maybe this function will be moved to general utility package\n# argument: array of numbers\n# returns: (min,max) numbers in the array\nsub rangeofarray {\n  my $self=shift;\n  my @array=@_;\n  #print \"\\n-=-=-=-=-=-=-=-=-=-=array: @array\\n\";\n  my ($max,$min,$element);\n  $min=$max=shift(@array);\n  foreach $element (@array) {\n      $element = 0 unless defined $element;\n    if ($element < $min) {\n      $min=$element;\n    }\n    if ($element > $max) {\n      $max=$element;\n    }\n  }\n  #print \"\\n-=-=-=-=-=-=-=-=-=-=min: $min\\tmax: $max\\n\";\n  return ($min,$max);\n}\n\n\n# argument: reference to DNA object, reference to array of transcripts\n# returns: an array of Translation object references\nsub transexonscreation {\n  my $self=shift;\n  my $dna=$_[0];\n  my @transcripts=@{$_[1]};\n\n  my (@transexons,$start,$end,$strand,$exonref,$exonobj,$transcript,$transcriptobj);\n  my $translationobj;\n  my @translationobjects;\n  foreach $transcript (@transcripts) {\n    foreach $exonref (@{$transcript}) {\n      ($start,$end,$strand)=@{$exonref};\n      #print \"Creating Exon: start $start end $end strand $strand\\n\";\n      $exonobj=Bio::LiveSeq::Exon->new(-seq=>$dna,-start=>$start,-end=>$end,-strand=>$strand);\n      #push (@exonobjects,$exonobj);\n      push (@transexons,$exonobj);\n    }\n    $transcriptobj=Bio::LiveSeq::Transcript->new(-exons => \\@transexons );\n    if ($transcriptobj != -1) {\n      $translationobj=Bio::LiveSeq::Translation->new(-transcript=>$transcriptobj);\n      @transexons=(); # cleans it\n      #push (@transcriptobjects,$transcriptobj);\n      push (@translationobjects,$translationobj);\n    }\n  }\n  return (@translationobjects);\n}\n\n#sub printgene {\n# deleted. Some functionality placed in Gene->printfeaturesnum\n\n=head2 printswissprot\n\n  Title   : printswissprot\n  Usage   : $loader->printswissprot($hashref);\n  Function: prints out all informations loaded from a database entry into the\n            loader. Mainly used for testing purposes.\n  Args    : a hashref containing the SWISSPROT entry datas\n  Note    : the hashref can be obtained with a call to the method\n               $loader->get_swisshash()      (BioPerl via Bio::DB::EMBL.pm)\n\t    that takes as argument a string like \"SWISS-PROT:P10275\"\n\n\n# argument: hashref containing the SWISSPROT entry datas\n# prints out that hash, showing the informations loaded\nsub printswissprot {\n  my ($self,$entry)=@_;\n  unless ($entry) {\n    return;\n  }\n  printf \"ID: %s\\n\",\n      $entry->{'ID'};\n  printf \"ACC: %s\\n\",\n      $entry->{'AccNumber'};\n  printf \"GENE: %s\\n\",\n      $entry->{'Gene'};\n  printf \"DES: %s\\n\",\n      $entry->{'Description'};\n  printf \"ORG: %s\\n\",\n      $entry->{'Organism'};\n  printf \"SEQLN: %s\\n\",\n      $entry->{'SeqLength'};\n  printf \"SEQ: %s\\n\",\n      substr($entry->{'Sequence'},0,64);\n  if ($entry->{'Features'}) {\n    my @features=@{$entry->{'Features'}};\n    my $i;\n    for $i (0..$#features) {\n      print \"|\",$features[$i]->{'name'},\"|\";\n      print \" at \",$features[$i]->{'location'},\": \";\n      print \"\",$features[$i]->{'desc'},\"\\n\";\n    }\n  }\n}\n\n=head2 printembl\n\n  Title   : printembl\n  Usage   : $loader->printembl();\n  Function: prints out all informations loaded from a database entry into the\n            loader. Mainly used for testing purposes.\n  Args    : none\n\n\n# argument: hashref containing the EMBL entry datas\n# prints out that hash, showing the informations loaded\nsub printembl {\n  my ($self,$entry)=@_;\n  unless ($entry) {\n    $entry=$self->{'hash'};\n  }\n  my ($i,$featurename);\n  printf \"ID: %s\\n\",\n      $entry->{'ID'};\n  printf \"ACC: %s\\n\",\n      $entry->{'AccNumber'};\n  printf \"MOL: %s\\n\",\n      $entry->{'Molecule'};\n  printf \"DIV: %s\\n\",\n      $entry->{'Division'};\n  printf \"DES: %s\\n\",\n      $entry->{'Description'};\n  printf \"ORG: %s\\n\",\n      $entry->{'Organism'};\n  printf \"SEQLN: %s\\n\",\n      $entry->{'SeqLength'};\n  printf \"SEQ: %s\\n\",\n      substr($entry->{'Sequence'},0,64);\n  my @features=@{$entry->{'Features'}};\n  my @cds=@{$entry->{'CDS'}};\n  print \"\\nFEATURES\\nNumber of CDS: \",scalar(@cds),\" (out of \",$entry->{'FeaturesNumber'}, \" total features)\\n\";\n  my ($exonref,$transcript);\n  my ($qualifiernumber,$qualifiers,$key);\n  my ($start,$end,$strand);\n  my $j=0;\n  for $i (0..$#features) {\n    $featurename=$features[$i]->{'name'};\n    if ($featurename eq \"CDS\") {\n      print \"|CDS| number $j at feature position: $i\\n\";\n      #print $features[$i]->{'location'},\"\\n\";\n      $transcript=$features[$i]->{'range'};\n      foreach $exonref (@{$transcript}) {\n\t($start,$end,$strand)=@{$exonref};\n\tprint \"\\tExon: start $start end $end strand $strand\\n\";\n      }\n      $j++;\n    } else {\n      print \"|$featurename| at feature position: $i\\n\";\n      print \"\\trange: \";\n      print join(\"\\t\",@{$features[$i]->{'range'}}),\"\\n\";\n      #print $features[$i]->{'location'},\"\\n\";\n    }\n    $qualifiernumber=$features[$i]->{'qual_number'};\n    $qualifiers=$features[$i]->{'qualifiers'}; # hash\n    foreach $key (keys (%{$qualifiers})) {\n    print \"\\t\\t\",$key,\": \";\n      print $qualifiers->{$key},\"\\n\";\n    }\n  }\n}\n\n=head2 genes\n\n  Title   : genes\n  Usage   : $loader->genes();\n  Function: Returns an array of gene_names (strings) contained in the loaded\n            entry.\n  Args    : none\n\n argument: entryhashref\n returns: array of genenames found in the entry","parameters":[{"label":"$self"},{"label":"$entry"}]}},{"definition":"my","localvar":"my","containerName":null,"kind":13,"name":"$genename","line":622},{"kind":13,"containerName":null,"name":"$genenames","line":622},{"line":622,"name":"$entryfeature","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"$entryfeature","line":623},{"line":623,"kind":13,"containerName":null,"name":"@entryfeatures"},{"name":"$genename","kind":13,"containerName":null,"line":624},{"line":624,"name":"%entryfeature","kind":13,"containerName":null},{"name":"%genename","kind":13,"containerName":null,"line":625},{"containerName":null,"kind":13,"name":"$genenames","line":626},{"line":626,"name":"%genename","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"$genenames","line":627},{"line":627,"name":"$genename","kind":13,"containerName":null},{"name":"$genenames","containerName":null,"kind":13,"line":631},{"name":"swisshash2liveseq","containerName":"main::","children":[{"line":638,"kind":13,"localvar":"my","containerName":"swisshash2liveseq","name":"$self","definition":"my"},{"line":638,"name":"$entry","containerName":"swisshash2liveseq","kind":13},{"name":"$translation","containerName":"swisshash2liveseq","kind":13,"line":638},{"definition":"my","localvar":"my","containerName":"swisshash2liveseq","kind":13,"name":"$translength","line":639},{"line":639,"kind":13,"containerName":"swisshash2liveseq","name":"$translation"},{"name":"length","containerName":"swisshash2liveseq","kind":12,"line":639},{"kind":13,"containerName":"swisshash2liveseq","name":"$translation","line":640},{"kind":12,"containerName":"swisshash2liveseq","name":"desc","line":640},{"containerName":"swisshash2liveseq","kind":13,"name":"$translation","line":640},{"line":640,"containerName":"swisshash2liveseq","kind":12,"name":"desc"},{"kind":13,"containerName":"swisshash2liveseq","name":"$entry","line":640},{"line":641,"containerName":"swisshash2liveseq","kind":13,"name":"$translation"},{"line":641,"name":"display_id","containerName":"swisshash2liveseq","kind":12},{"line":641,"name":"$entry","containerName":"swisshash2liveseq","kind":13},{"kind":13,"containerName":"swisshash2liveseq","name":"$translation","line":642},{"line":642,"name":"accession_number","kind":12,"containerName":"swisshash2liveseq"},{"kind":13,"containerName":"swisshash2liveseq","name":"$entry","line":642},{"name":"$translation","containerName":"swisshash2liveseq","kind":13,"line":643},{"line":643,"name":"name","kind":12,"containerName":"swisshash2liveseq"},{"kind":13,"containerName":"swisshash2liveseq","name":"$entry","line":643},{"line":644,"name":"$translation","kind":13,"containerName":"swisshash2liveseq"},{"line":644,"kind":12,"containerName":"swisshash2liveseq","name":"source"},{"kind":13,"containerName":"swisshash2liveseq","name":"$entry","line":644},{"line":645,"name":"@aarangeobjects","containerName":"swisshash2liveseq","localvar":"my","kind":13,"definition":"my"},{"definition":"my","line":646,"localvar":"my","containerName":"swisshash2liveseq","kind":13,"name":"$start"},{"line":646,"kind":13,"containerName":"swisshash2liveseq","name":"$end"},{"line":646,"name":"$aarangeobj","containerName":"swisshash2liveseq","kind":13},{"line":646,"name":"$feature","containerName":"swisshash2liveseq","kind":13},{"definition":"my","line":647,"name":"@features","kind":13,"localvar":"my","containerName":"swisshash2liveseq"},{"localvar":"my","containerName":"swisshash2liveseq","kind":13,"name":"@newfeatures","line":647,"definition":"my"},{"name":"$entry","kind":13,"containerName":"swisshash2liveseq","line":648},{"name":"@features","kind":13,"containerName":"swisshash2liveseq","line":649},{"line":649,"name":"$entry","kind":13,"containerName":"swisshash2liveseq"}],"detail":"($self,$entry,$translation)","definition":"sub","range":{"start":{"line":637,"character":0},"end":{"character":9999,"line":650}},"kind":12,"line":637,"signature":{"label":"swisshash2liveseq($self,$entry,$translation)","documentation":" arguments: swisshash, translation objref\n adds information to the Translation, creates AARange objects, sets the\n aa_range attribute on the Translation, pointing to those objects","parameters":[{"label":"$self"},{"label":"$entry"},{"label":"$translation"}]}},{"definition":"my","localvar":"my","kind":13,"containerName":null,"name":"$cleavedmet","line":651},{"line":653,"name":"$feature","kind":13,"containerName":null},{"line":653,"containerName":null,"kind":13,"name":"@features"},{"name":"%feature","kind":13,"containerName":null,"line":654},{"line":654,"name":"%feature","kind":13,"containerName":null},{"line":655,"kind":13,"containerName":null,"name":"$cleavedmet"},{"name":"%translation","containerName":null,"kind":13,"line":656},{"line":658,"containerName":null,"kind":13,"name":"@newfeatures"},{"line":658,"name":"$feature","kind":13,"containerName":null},{"definition":"my","localvar":"my","containerName":null,"kind":13,"name":"$swissseq","line":662},{"kind":13,"containerName":null,"name":"%entry","line":662},{"line":663,"name":"$liveseqtransl","localvar":"my","kind":13,"containerName":null,"definition":"my"},{"line":663,"containerName":null,"kind":13,"name":"$translation"},{"kind":12,"containerName":"main::","name":"seq","line":663},{"line":664,"name":"$liveseqtransl","kind":13,"containerName":null},{"definition":"my","line":665,"containerName":null,"localvar":"my","kind":13,"name":"$translated"},{"line":665,"containerName":null,"kind":13,"name":"$liveseqtransl"},{"name":"$cleavedmet","kind":13,"containerName":null,"line":665},{"line":667,"name":"$liveseq_aa","kind":13,"localvar":"my","containerName":null,"definition":"my"},{"name":"$swiss_aa","containerName":null,"kind":13,"line":667},{"name":"$codes_aa","containerName":null,"kind":13,"line":667},{"containerName":null,"kind":13,"name":"$self","line":667},{"line":667,"name":"_get_alignment","kind":12,"containerName":"main::"},{"name":"$translated","kind":13,"containerName":null,"line":667},{"containerName":null,"kind":13,"name":"$swissseq","line":667},{"name":"$liveseq_aa","containerName":null,"kind":13,"line":669},{"line":669,"kind":13,"containerName":null,"name":"%swiss_aa"},{"line":671,"kind":12,"name":"carp"},{"containerName":null,"kind":13,"name":"@features","line":676},{"line":676,"name":"@newfeatures","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"$feature","line":677},{"line":677,"name":"@features","containerName":null,"kind":13},{"line":679,"name":"$start","containerName":null,"kind":13},{"line":679,"kind":13,"containerName":null,"name":"$end"},{"line":679,"containerName":null,"kind":13,"name":"%feature"},{"containerName":null,"kind":13,"name":"$aarangeobj","line":681},{"line":681,"containerName":"LiveSeq::AARange","kind":12,"name":"Bio"},{"line":681,"name":"new","kind":12,"containerName":"main::"},{"line":681,"name":"$start","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"$cleavedmet","line":681},{"containerName":null,"kind":13,"name":"$end","line":681},{"kind":13,"containerName":null,"name":"$cleavedmet","line":681},{"line":681,"name":"%feature","kind":13,"containerName":null},{"name":"%feature","kind":13,"containerName":null,"line":681},{"name":"$translation","kind":13,"containerName":null,"line":681},{"kind":13,"containerName":null,"name":"$translength","line":681},{"line":682,"containerName":null,"kind":13,"name":"%aarangeobj"},{"line":683,"name":"@aarangeobjects","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"$aarangeobj","line":683},{"line":687,"name":"%translation","containerName":null,"kind":13},{"line":687,"kind":13,"containerName":null,"name":"@aarangeobjects"},{"kind":12,"range":{"start":{"line":692,"character":0},"end":{"line":694,"character":9999}},"line":692,"containerName":"main::","name":"get_swisshash","children":[],"definition":"sub"},{"children":[{"kind":13,"localvar":"my","containerName":"_findgenefeatures","name":"$self","line":704,"definition":"my"},{"name":"$entry","kind":13,"containerName":"_findgenefeatures","line":704},{"containerName":"_findgenefeatures","kind":13,"name":"$gene_name","line":704},{"line":704,"kind":13,"containerName":"_findgenefeatures","name":"$cds_position"},{"containerName":"_findgenefeatures","kind":13,"name":"$getswissprotinfo","line":704},{"line":706,"name":"@entryfeatures","containerName":"_findgenefeatures","localvar":"my","kind":13,"definition":"my"},{"containerName":"_findgenefeatures","kind":13,"name":"$entry","line":706}],"containerName":"main::","name":"_findgenefeatures","definition":"sub","detail":"($self,$entry,$gene_name,$cds_position,$getswissprotinfo)","line":703,"range":{"start":{"line":703,"character":0},"end":{"line":706,"character":9999}},"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$entry"},{"label":"$gene_name"},{"label":"$cds_position"},{"label":"$getswissprotinfo"}],"documentation":" Args: $entry hashref, gene_name OR cds_position (undef is used to\n choose between the two), getswissprotinfo boolean flag\n Returns: an hash holding various arrayref used in the hash2gene method\n Function: examines the nucleotide entry, identifying features belonging\n to the gene (defined either by its name or by the position of its CDS in\n the entry)","label":"_findgenefeatures($self,$entry,$gene_name,$cds_position,$getswissprotinfo)"}},{"definition":"my","line":707,"name":"@exons","containerName":null,"localvar":"my","kind":13},{"definition":"my","name":"@introns","localvar":"my","kind":13,"containerName":null,"line":707},{"definition":"my","line":707,"containerName":null,"localvar":"my","kind":13,"name":"@prim_transcripts"},{"definition":"my","localvar":"my","kind":13,"containerName":null,"name":"@transcripts","line":707},{"definition":"my","line":708,"name":"@repeat_units","localvar":"my","kind":13,"containerName":null},{"name":"@repeat_regions","kind":13,"localvar":"my","containerName":null,"line":708,"definition":"my"},{"definition":"my","line":709,"localvar":"my","kind":13,"containerName":null,"name":"@repeat_units_family"},{"line":709,"containerName":null,"localvar":"my","kind":13,"name":"@repeat_regions_family","definition":"my"},{"line":709,"containerName":null,"localvar":"my","kind":13,"name":"$rpt_family","definition":"my"},{"definition":"my","line":710,"kind":13,"localvar":"my","containerName":null,"name":"$entryfeature"},{"definition":"my","line":710,"containerName":null,"localvar":"my","kind":13,"name":"@genefeatures"},{"name":"$desc","localvar":"my","containerName":null,"kind":13,"line":711,"definition":"my"},{"definition":"my","line":711,"localvar":"my","containerName":null,"kind":13,"name":"@exondescs"},{"definition":"my","localvar":"my","kind":13,"containerName":null,"name":"@introndescs","line":711},{"line":714,"kind":13,"localvar":"my","containerName":null,"name":"$swissacc","definition":"my"},{"line":714,"name":"$swisshash","kind":13,"containerName":null},{"line":714,"kind":13,"localvar":"my","containerName":null,"name":"@swisshashes","definition":"my"},{"name":"@ttables","containerName":null,"localvar":"my","kind":13,"line":717,"definition":"my"},{"line":720,"kind":13,"localvar":"my","containerName":null,"name":"$name","definition":"my"},{"kind":13,"containerName":null,"name":"$exon","line":720},{"definition":"my","line":721,"name":"@range","localvar":"my","kind":13,"containerName":null},{"name":"@cdsexons","localvar":"my","containerName":null,"kind":13,"line":721,"definition":"my"},{"line":721,"containerName":null,"localvar":"my","kind":13,"name":"@labels","definition":"my"},{"definition":"my","name":"@cds","localvar":"my","kind":13,"containerName":null,"line":727},{"containerName":null,"kind":13,"name":"%entry","line":727},{"definition":"my","name":"$skipgenematch","containerName":null,"localvar":"my","kind":13,"line":729},{"line":730,"kind":13,"containerName":null,"name":"@cds"},{"containerName":null,"kind":13,"name":"$skipgenematch","line":732},{"definition":"my","name":"$cds_begin","localvar":"my","containerName":null,"kind":13,"line":735},{"containerName":null,"kind":13,"name":"$cds_end","line":735},{"line":735,"containerName":null,"kind":13,"name":"$proximity"},{"line":736,"containerName":null,"kind":13,"name":"%cds_position"},{"localvar":"my","containerName":null,"kind":13,"name":"@cds_exons","line":737,"definition":"my"},{"line":737,"containerName":null,"kind":13,"name":"@cds"},{"name":"%cds_position","kind":13,"containerName":null,"line":737},{"line":738,"name":"$cds_begin","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"$cds_end","line":738},{"line":738,"kind":13,"containerName":null,"name":"@cds_exons"},{"line":738,"containerName":null,"kind":13,"name":"@cds_exons"},{"containerName":null,"kind":13,"name":"$gene_name","line":739},{"line":739,"kind":13,"containerName":null,"name":"@cds"},{"kind":13,"containerName":null,"name":"%cds_position","line":739},{"containerName":null,"kind":13,"name":"%skipgenematch","line":741},{"name":"carp","kind":12,"line":742},{"line":744,"name":"$proximity","containerName":null,"kind":13},{"line":747,"name":"$entryfeature","kind":13,"containerName":null},{"name":"@entryfeatures","kind":13,"containerName":null,"line":747},{"line":748,"containerName":null,"kind":13,"name":"$skipgenematch"},{"line":748,"name":"$cds_position","kind":13,"containerName":null},{"line":748,"name":"$self","containerName":null,"kind":13},{"kind":12,"containerName":"main::","name":"_checkfeatureproximity","line":748},{"name":"%entryfeature","kind":13,"containerName":null,"line":748},{"line":748,"name":"$cds_begin","kind":13,"containerName":null},{"name":"$cds_end","containerName":null,"kind":13,"line":748},{"line":748,"name":"$proximity","containerName":null,"kind":13},{"line":748,"name":"$cds_position","kind":13,"containerName":null},{"line":748,"name":"%entryfeature","containerName":null,"kind":13},{"line":749,"kind":13,"containerName":null,"name":"@genefeatures"},{"line":749,"name":"$entryfeature","kind":13,"containerName":null},{"line":751,"localvar":"my","kind":13,"containerName":null,"name":"@range","definition":"my"},{"kind":13,"containerName":null,"name":"%entryfeature","line":751},{"line":752,"containerName":null,"kind":13,"name":"$name"},{"line":752,"containerName":null,"kind":13,"name":"%entryfeature"},{"line":753,"name":"%qualifierhash","localvar":"my","containerName":null,"kind":13,"definition":"my"},{"line":753,"name":"%entryfeature","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"%name","line":754},{"kind":13,"containerName":null,"name":"%getswissprotinfo","line":758},{"name":"$swissacc","kind":13,"containerName":null,"line":759},{"line":759,"name":"%entryfeature","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"$swisshash","line":760},{"line":760,"kind":13,"containerName":null,"name":"$self"},{"name":"get_swisshash","containerName":"main::","kind":12,"line":760},{"kind":13,"containerName":null,"name":"$swissacc","line":760},{"line":762,"name":"@swisshashes","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"$swisshash","line":762},{"line":765,"kind":13,"containerName":null,"name":"@ttables"},{"kind":13,"containerName":null,"name":"%entryfeature","line":765},{"line":768,"name":"$exon","containerName":null,"kind":13},{"line":768,"containerName":null,"kind":13,"name":"@range"},{"line":769,"containerName":null,"kind":13,"name":"@labels"},{"line":769,"name":"@exon","containerName":null,"kind":13},{"line":769,"kind":13,"containerName":null,"name":"@exon"},{"kind":13,"containerName":null,"name":"@transcripts","line":771},{"line":771,"containerName":null,"kind":13,"name":"%entryfeature"},{"line":777,"containerName":null,"kind":13,"name":"%entryfeature"},{"line":777,"containerName":null,"kind":13,"name":"%entryfeature"},{"kind":13,"containerName":null,"name":"@range","line":778},{"line":778,"name":"@range","kind":13,"containerName":null},{"name":"@range","containerName":null,"kind":13,"line":778},{"name":"@labels","containerName":null,"kind":13,"line":780},{"line":780,"containerName":null,"kind":13,"name":"@range"},{"line":780,"containerName":null,"kind":13,"name":"@range"},{"containerName":null,"kind":13,"name":"%name","line":781},{"line":782,"containerName":null,"kind":13,"name":"$desc"},{"line":782,"containerName":null,"kind":13,"name":"%entryfeature"},{"containerName":null,"kind":13,"name":"%entryfeature","line":783},{"line":784,"containerName":null,"kind":13,"name":"%desc"},{"kind":13,"containerName":null,"name":"$desc","line":785},{"containerName":null,"kind":13,"name":"%entryfeature","line":785},{"line":787,"name":"$desc","containerName":null,"kind":13},{"line":787,"name":"%entryfeature","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"@exondescs","line":790},{"containerName":null,"kind":13,"name":"$desc","line":790},{"line":791,"name":"@exons","kind":13,"containerName":null},{"name":"@range","kind":13,"containerName":null,"line":791},{"line":793,"name":"%name","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"$desc","line":794},{"line":794,"kind":13,"containerName":null,"name":"%entryfeature"},{"kind":13,"containerName":null,"name":"%desc","line":795},{"line":796,"name":"$desc","containerName":null,"kind":13},{"name":"%entryfeature","kind":13,"containerName":null,"line":796},{"line":798,"containerName":null,"kind":13,"name":"$desc"},{"line":798,"name":"%entryfeature","kind":13,"containerName":null},{"line":800,"kind":13,"containerName":null,"name":"@introndescs"},{"line":800,"name":"$desc","kind":13,"containerName":null},{"line":801,"name":"@introns","containerName":null,"kind":13},{"name":"@range","containerName":null,"kind":13,"line":801},{"line":803,"kind":13,"containerName":null,"name":"$name"},{"containerName":null,"kind":13,"name":"%name","line":803},{"line":803,"name":"@prim_transcripts","kind":13,"containerName":null},{"line":803,"name":"@range","kind":13,"containerName":null},{"name":"%name","kind":13,"containerName":null,"line":804},{"line":804,"name":"@repeat_units","containerName":null,"kind":13},{"line":804,"name":"@range","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"$rpt_family","line":805},{"line":805,"containerName":null,"kind":13,"name":"%entryfeature"},{"line":806,"name":"@repeat_units_family","containerName":null,"kind":13},{"name":"$rpt_family","containerName":null,"kind":13,"line":806},{"line":808,"kind":13,"containerName":null,"name":"%name"},{"line":808,"containerName":null,"kind":13,"name":"@repeat_regions"},{"line":808,"kind":13,"containerName":null,"name":"@range"},{"name":"$rpt_family","kind":13,"containerName":null,"line":809},{"kind":13,"containerName":null,"name":"%entryfeature","line":809},{"kind":13,"containerName":null,"name":"@repeat_regions_family","line":810},{"line":810,"kind":13,"containerName":null,"name":"$rpt_family"},{"name":"%gene_name","containerName":null,"kind":13,"line":815},{"name":"$gene_name","kind":13,"containerName":null,"line":815},{"name":"$cds_position","kind":13,"containerName":null,"line":815},{"name":"%genefeatureshash","kind":13,"localvar":"my","containerName":null,"line":816,"definition":"my"},{"line":817,"name":"%genefeatureshash","kind":13,"containerName":null},{"name":"gene_name","kind":12,"line":817},{"line":817,"containerName":null,"kind":13,"name":"$gene_name"},{"containerName":null,"kind":13,"name":"%genefeatureshash","line":818},{"line":818,"name":"genefeatures","kind":12},{"line":818,"name":"@genefeatures","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"%genefeatureshash","line":819},{"name":"labels","kind":12,"line":819},{"line":819,"kind":13,"containerName":null,"name":"@labels"},{"name":"%genefeatureshash","kind":13,"containerName":null,"line":820},{"kind":12,"name":"ttables","line":820},{"name":"@ttables","containerName":null,"kind":13,"line":820},{"containerName":null,"kind":13,"name":"%genefeatureshash","line":821},{"name":"swisshashes","kind":12,"line":821},{"line":821,"name":"@swisshashes","containerName":null,"kind":13},{"name":"%genefeatureshash","kind":13,"containerName":null,"line":822},{"name":"transcripts","kind":12,"line":822},{"kind":13,"containerName":null,"name":"@transcripts","line":822},{"line":823,"containerName":null,"kind":13,"name":"%genefeatureshash"},{"kind":12,"name":"exons","line":823},{"name":"@exons","containerName":null,"kind":13,"line":823},{"containerName":null,"kind":13,"name":"%genefeatureshash","line":824},{"line":824,"name":"exondescs","kind":12},{"containerName":null,"kind":13,"name":"@exondescs","line":824},{"line":825,"containerName":null,"kind":13,"name":"%genefeatureshash"},{"kind":12,"name":"introns","line":825},{"containerName":null,"kind":13,"name":"@introns","line":825},{"name":"%genefeatureshash","containerName":null,"kind":13,"line":826},{"kind":12,"name":"introndescs","line":826},{"line":826,"name":"@introndescs","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"%genefeatureshash","line":827},{"line":827,"name":"prim_transcripts","kind":12},{"line":827,"kind":13,"containerName":null,"name":"@prim_transcripts"},{"line":828,"name":"%genefeatureshash","containerName":null,"kind":13},{"line":828,"kind":12,"name":"repeat_units"},{"containerName":null,"kind":13,"name":"@repeat_units","line":828},{"name":"%genefeatureshash","kind":13,"containerName":null,"line":829},{"name":"repeat_regions","kind":12,"line":829},{"containerName":null,"kind":13,"name":"@repeat_regions","line":829},{"name":"%genefeatureshash","containerName":null,"kind":13,"line":830},{"kind":12,"name":"repeat_units_family","line":830},{"line":830,"name":"@repeat_units_family","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"%genefeatureshash","line":831},{"kind":12,"name":"repeat_regions_family","line":831},{"name":"@repeat_regions_family","containerName":null,"kind":13,"line":831},{"line":832,"containerName":null,"kind":13,"name":"%genefeatureshash"},{"signature":{"parameters":[{"label":"$self"},{"label":"$range"},{"label":"$cds_begin"},{"label":"$cds_end"},{"label":"$proximity"}],"documentation":" used by _findgenefeatures, when a CDS at a certain position is requested,\n to retrieve only features quite close to the wanted CDS.\n Args: range hashref, begin and end positions of the CDS, $proximity\n $proximity holds the maximum distance between the extremes of the CDS\n and of the feature under exam.\n Returns: boolean","label":"_checkfeatureproximity($self,$range,$cds_begin,$cds_end,$proximity)"},"range":{"end":{"line":844,"character":9999},"start":{"line":842,"character":0}},"kind":12,"line":842,"detail":"($self,$range,$cds_begin,$cds_end,$proximity)","definition":"sub","containerName":"main::","name":"_checkfeatureproximity","children":[{"name":"$self","containerName":"_checkfeatureproximity","localvar":"my","kind":13,"line":843,"definition":"my"},{"line":843,"containerName":"_checkfeatureproximity","kind":13,"name":"$range"},{"kind":13,"containerName":"_checkfeatureproximity","name":"$cds_begin","line":843},{"line":843,"name":"$cds_end","kind":13,"containerName":"_checkfeatureproximity"},{"name":"$proximity","kind":13,"containerName":"_checkfeatureproximity","line":843},{"definition":"my","kind":13,"localvar":"my","containerName":"_checkfeatureproximity","name":"@range","line":844},{"line":844,"name":"$range","kind":13,"containerName":"_checkfeatureproximity"}]},{"definition":"my","containerName":null,"localvar":"my","kind":13,"name":"$begin","line":845},{"line":845,"name":"$end","containerName":null,"kind":13},{"line":845,"containerName":null,"kind":13,"name":"$strand"},{"line":846,"name":"@range","containerName":null,"kind":13},{"line":847,"name":"$begin","containerName":null,"kind":13},{"line":847,"kind":13,"containerName":null,"name":"$end"},{"name":"$strand","containerName":null,"kind":13,"line":847},{"line":847,"name":"@range","kind":13,"containerName":null},{"line":847,"name":"@range","kind":13,"containerName":null},{"line":847,"name":"@range","kind":13,"containerName":null},{"line":849,"name":"$begin","kind":13,"containerName":null},{"name":"$end","kind":13,"containerName":null,"line":849},{"line":849,"containerName":null,"kind":13,"name":"$strand"},{"name":"@range","kind":13,"containerName":null,"line":849},{"kind":13,"containerName":null,"name":"$cds_begin","line":851},{"name":"%cds_end","kind":13,"containerName":null,"line":851},{"kind":13,"containerName":null,"name":"$cds_begin","line":852},{"kind":13,"containerName":null,"name":"$cds_end","line":852},{"name":"$cds_end","containerName":null,"kind":13,"line":852},{"containerName":null,"kind":13,"name":"$cds_begin","line":852},{"name":"%strand","containerName":null,"kind":13,"line":854},{"line":855,"containerName":null,"kind":13,"name":"$begin"},{"name":"$end","kind":13,"containerName":null,"line":855},{"name":"$end","kind":13,"containerName":null,"line":855},{"line":855,"kind":13,"containerName":null,"name":"$begin"},{"containerName":null,"kind":13,"name":"$cds_begin","line":857},{"name":"$end","containerName":null,"kind":13,"line":857},{"line":857,"containerName":null,"kind":13,"name":"%proximity"},{"name":"carp","kind":12,"line":858},{"line":861,"name":"$begin","containerName":null,"kind":13},{"name":"$cds_end","containerName":null,"kind":13,"line":861},{"name":"%proximity","containerName":null,"kind":13,"line":861},{"line":862,"name":"carp","kind":12},{"line":865,"name":"carp","kind":12},{"definition":"sub","detail":"($self,$seq1,$seq2)","children":[{"line":875,"name":"$self","containerName":"_get_alignment","localvar":"my","kind":13,"definition":"my"},{"name":"$seq1","kind":13,"containerName":"_get_alignment","line":875},{"kind":13,"containerName":"_get_alignment","name":"$seq2","line":875},{"definition":"my","name":"$fastafile1","localvar":"my","kind":13,"containerName":"_get_alignment","line":876},{"definition":"my","line":877,"name":"$fastafile2","containerName":"_get_alignment","localvar":"my","kind":13},{"line":878,"name":"$grepcut","localvar":"my","containerName":"_get_alignment","kind":13,"definition":"my"},{"definition":"my","line":879,"localvar":"my","containerName":"_get_alignment","kind":13,"name":"$alignprogram"},{"localvar":"my","containerName":"_get_alignment","kind":13,"name":"$TMPFASTAFILE1","line":880,"definition":"my"},{"definition":"my","line":881,"containerName":"_get_alignment","localvar":"my","kind":13,"name":"$TMPFASTAFILE2"},{"containerName":"_get_alignment","kind":13,"name":"$TMPFASTAFILE1","line":882},{"containerName":"_get_alignment","kind":13,"name":"$TMPFASTAFILE2","line":883},{"line":884,"kind":13,"containerName":"_get_alignment","name":"$TMPFASTAFILE1"},{"line":885,"containerName":"_get_alignment","kind":13,"name":"$TMPFASTAFILE2"},{"definition":"my","line":886,"name":"$alignment","kind":13,"localvar":"my","containerName":"_get_alignment"},{"containerName":"_get_alignment","localvar":"my","kind":13,"name":"@alignlines","line":887,"definition":"my"},{"name":"$alignment","kind":13,"containerName":"_get_alignment","line":887},{"definition":"my","line":888,"localvar":"my","kind":13,"containerName":"_get_alignment","name":"$linecount"},{"name":"$seq1_aligned","kind":13,"containerName":"_get_alignment","line":888},{"line":888,"name":"$seq2_aligned","containerName":"_get_alignment","kind":13},{"containerName":"_get_alignment","kind":13,"name":"$codes","line":888},{"line":889,"containerName":"_get_alignment","kind":13,"name":"$linecount"},{"kind":13,"containerName":"_get_alignment","name":"$linecount","line":889},{"line":889,"containerName":"_get_alignment","kind":13,"name":"@alignlines"},{"name":"$linecount","containerName":"_get_alignment","kind":13,"line":889},{"line":890,"kind":13,"containerName":"_get_alignment","name":"$seq1_aligned"},{"name":"$alignlines","containerName":"_get_alignment","kind":13,"line":890},{"kind":13,"containerName":"_get_alignment","name":"$linecount","line":890},{"name":"$codes","containerName":"_get_alignment","kind":13,"line":891},{"line":891,"name":"$alignlines","containerName":"_get_alignment","kind":13},{"kind":13,"containerName":"_get_alignment","name":"$linecount","line":891},{"kind":13,"containerName":"_get_alignment","name":"$seq2_aligned","line":892},{"containerName":"_get_alignment","kind":13,"name":"$alignlines","line":892},{"line":892,"kind":13,"containerName":"_get_alignment","name":"$linecount"},{"line":894,"name":"$seq1_aligned","kind":13,"containerName":"_get_alignment"},{"name":"$seq2_aligned","kind":13,"containerName":"_get_alignment","line":894},{"name":"$codes","kind":13,"containerName":"_get_alignment","line":894}],"containerName":"main::","name":"_get_alignment","signature":{"parameters":[{"label":"$self"},{"label":"$seq1"},{"label":"$seq2"}],"documentation":" function that calls the external program \"align\" (on the fasta2 package)\n to create an alignment between two sequences, returning the aligned\n strings and the codes for the identity (:: ::::)","label":"_get_alignment($self,$seq1,$seq2)"},"line":874,"range":{"start":{"character":0,"line":874},"end":{"line":895,"character":9999}},"kind":12},{"line":880,"kind":12,"name":"croak"},{"line":881,"kind":12,"name":"croak"},{"detail":"($species_codon_usage,$ttabid,$aasequence,$gene_name)","definition":"sub","name":"_common_novelaasequence2gene","containerName":"main::","children":[{"containerName":"_common_novelaasequence2gene","localvar":"my","kind":13,"name":"$species_codon_usage","line":901,"definition":"my"},{"kind":13,"containerName":"_common_novelaasequence2gene","name":"$ttabid","line":901},{"kind":13,"containerName":"_common_novelaasequence2gene","name":"$aasequence","line":901},{"line":901,"name":"$gene_name","containerName":"_common_novelaasequence2gene","kind":13},{"definition":"my","name":"@species_codon_usage","kind":13,"localvar":"my","containerName":"_common_novelaasequence2gene","line":902},{"line":902,"name":"$species_codon_usage","kind":13,"containerName":"_common_novelaasequence2gene"}],"signature":{"label":"_common_novelaasequence2gene($species_codon_usage,$ttabid,$aasequence,$gene_name)","documentation":" common part of the function to create a novel liveseq gene structure\n from an amino acid sequence, using codon usage frequencies\n args: codon_usage_array transltableid aasequence gene_name","parameters":[{"label":"$species_codon_usage"},{"label":"$ttabid"},{"label":"$aasequence"},{"label":"$gene_name"}]},"kind":12,"range":{"start":{"line":900,"character":0},"end":{"line":902,"character":9999}},"line":900},{"definition":"my","name":"@codon_usage_label","localvar":"my","kind":13,"containerName":null,"line":903},{"line":909,"name":"$i","kind":13,"localvar":"my","containerName":null,"definition":"my"},{"kind":13,"containerName":null,"name":"$j","line":909},{"definition":"my","localvar":"my","kind":13,"containerName":null,"name":"%codon_usage_value","line":910},{"line":911,"containerName":null,"localvar":"my","kind":13,"name":"$aa_codon_total","definition":"my"},{"containerName":null,"kind":13,"name":"$i","line":912},{"line":912,"containerName":null,"kind":13,"name":"$i"},{"name":"%i","kind":13,"containerName":null,"line":912},{"name":"%codon_usage_value","containerName":null,"kind":13,"line":913},{"name":"@codon_usage_label","containerName":null,"kind":13,"line":913},{"line":913,"name":"$i","containerName":null,"kind":13},{"line":913,"name":"@species_codon_usage","containerName":null,"kind":13},{"line":913,"containerName":null,"kind":13,"name":"$i"},{"definition":"my","name":"$CodonTable","localvar":"my","containerName":null,"kind":13,"line":916},{"name":"Bio","kind":12,"containerName":"Tools::CodonTable","line":916},{"containerName":"main::","kind":12,"name":"new","line":916},{"line":916,"containerName":null,"kind":13,"name":"$ttabid"},{"definition":"my","localvar":"my","kind":13,"containerName":null,"name":"@aminoacids","line":917},{"line":917,"kind":13,"containerName":null,"name":"$aasequence"},{"kind":13,"localvar":"my","containerName":null,"name":"@alt_codons","line":918,"definition":"my"},{"name":"$relativeusage","localvar":"my","kind":13,"containerName":null,"line":918,"definition":"my"},{"line":918,"kind":13,"containerName":null,"name":"$dnasequence"},{"name":"$chosen_codon","kind":13,"containerName":null,"line":918},{"line":918,"name":"$dice","kind":13,"containerName":null},{"name":"$partial","containerName":null,"kind":13,"line":918},{"name":"$thiscodon","containerName":null,"kind":13,"line":918},{"line":919,"name":"$i","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"@aminoacids","line":919},{"name":"@alt_codons","kind":13,"containerName":null,"line":920},{"name":"$CodonTable","containerName":null,"kind":13,"line":920},{"line":920,"containerName":"main::","kind":12,"name":"revtranslate"},{"line":920,"name":"$i","kind":13,"containerName":null},{"line":921,"name":"@alt_codons","containerName":null,"kind":13},{"line":922,"name":"carp","kind":12},{"line":923,"containerName":null,"kind":13,"name":"%dnasequence"},{"line":925,"kind":13,"containerName":null,"name":"$aa_codon_total"},{"line":926,"containerName":null,"kind":13,"name":"$j"},{"line":926,"name":"@alt_codons","kind":13,"containerName":null},{"name":"$aa_codon_total","containerName":null,"kind":13,"line":927},{"line":927,"containerName":null,"kind":13,"name":"%codon_usage_value"},{"name":"$j","containerName":null,"kind":13,"line":927},{"name":"$dice","containerName":null,"kind":13,"line":936},{"kind":13,"containerName":null,"name":"$partial","line":938},{"line":939,"kind":13,"containerName":null,"name":"$chosen_codon"},{"line":940,"name":"CODONCHOICE","kind":12},{"kind":13,"containerName":null,"name":"$j","line":941},{"line":941,"containerName":null,"kind":13,"name":"@alt_codons"},{"line":942,"name":"$thiscodon","containerName":null,"kind":13},{"line":942,"kind":13,"containerName":null,"name":"@alt_codons"},{"line":942,"name":"$j","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"$relativeusage","line":943},{"line":943,"name":"%codon_usage_value","kind":13,"containerName":null},{"name":"$thiscodon","containerName":null,"kind":13,"line":943},{"name":"$aa_codon_total","containerName":null,"kind":13,"line":943},{"line":944,"kind":13,"containerName":null,"name":"$dice"},{"line":944,"name":"$relativeusage","kind":13,"containerName":null},{"line":944,"name":"%partial","kind":13,"containerName":null},{"name":"$chosen_codon","kind":13,"containerName":null,"line":945},{"line":945,"name":"$thiscodon","kind":13,"containerName":null},{"line":946,"name":"CODONCHOICE","kind":12},{"name":"$partial","containerName":null,"kind":13,"line":948},{"line":948,"kind":13,"containerName":null,"name":"$relativeusage"},{"line":951,"name":"%chosen_codon","kind":13,"containerName":null},{"name":"$chosen_codon","kind":13,"containerName":null,"line":952},{"line":952,"kind":13,"containerName":null,"name":"@alt_codons"},{"line":955,"containerName":null,"kind":13,"name":"$dnasequence"},{"line":955,"containerName":null,"kind":13,"name":"$chosen_codon"},{"localvar":"my","kind":13,"containerName":null,"name":"$dna","line":959,"definition":"my"},{"line":959,"containerName":"LiveSeq::DNA","kind":12,"name":"Bio"},{"line":959,"kind":12,"containerName":"main::","name":"new"},{"line":959,"containerName":null,"kind":13,"name":"$dnasequence"},{"line":960,"name":"$min","localvar":"my","containerName":null,"kind":13,"definition":"my"},{"line":961,"name":"$max","localvar":"my","containerName":null,"kind":13,"definition":"my"},{"line":961,"name":"$dnasequence","containerName":null,"kind":13},{"line":962,"containerName":null,"localvar":"my","kind":13,"name":"$exon","definition":"my"},{"line":962,"containerName":"LiveSeq::Exon","kind":12,"name":"Bio"},{"line":962,"name":"new","containerName":"main::","kind":12},{"line":962,"kind":13,"containerName":null,"name":"$dna"},{"name":"$min","containerName":null,"kind":13,"line":962},{"name":"$max","kind":13,"containerName":null,"line":962},{"definition":"my","name":"@exons","kind":13,"localvar":"my","containerName":null,"line":963},{"line":963,"name":"$exon","kind":13,"containerName":null},{"line":964,"name":"$transcript","containerName":null,"localvar":"my","kind":13,"definition":"my"},{"line":964,"kind":12,"containerName":"LiveSeq::Transcript","name":"Bio"},{"name":"new","kind":12,"containerName":"main::","line":964},{"line":964,"containerName":null,"kind":13,"name":"@exons"},{"line":965,"name":"$transcript","containerName":null,"kind":13},{"line":965,"containerName":"main::","kind":12,"name":"translation_table"},{"line":965,"name":"$ttabid","containerName":null,"kind":13},{"localvar":"my","kind":13,"containerName":null,"name":"@transcripts","line":966,"definition":"my"},{"line":966,"name":"$transcript","containerName":null,"kind":13},{"definition":"my","localvar":"my","kind":13,"containerName":null,"name":"$translation","line":967},{"name":"Bio","containerName":"LiveSeq::Translation","kind":12,"line":967},{"name":"new","kind":12,"containerName":"main::","line":967},{"containerName":null,"kind":13,"name":"$transcript","line":967},{"localvar":"my","kind":13,"containerName":null,"name":"@translations","line":968,"definition":"my"},{"line":968,"containerName":null,"kind":13,"name":"$translation"},{"definition":"my","line":969,"localvar":"my","containerName":null,"kind":13,"name":"%features"},{"kind":12,"name":"DNA","line":969},{"line":969,"name":"$dna","kind":13,"containerName":null},{"line":969,"kind":12,"name":"Transcripts"},{"line":969,"kind":13,"containerName":null,"name":"@transcripts"},{"line":969,"name":"Translations","kind":12},{"line":969,"kind":13,"containerName":null,"name":"@translations"},{"definition":"my","name":"$gene","localvar":"my","containerName":null,"kind":13,"line":970},{"kind":12,"containerName":"LiveSeq::Gene","name":"Bio","line":970},{"kind":12,"containerName":"main::","name":"new","line":970},{"line":970,"name":"$gene_name","containerName":null,"kind":13},{"name":"%features","kind":13,"containerName":null,"line":970},{"line":970,"name":"$min","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"$max","line":970},{"line":973,"name":"%gene","kind":13,"containerName":null},{"name":"carp","kind":12,"line":974},{"line":977,"kind":13,"containerName":null,"name":"$gene"}]}