{"version":5,"vars":[{"name":"Carp","kind":2,"containerName":"","line":87},{"line":88,"name":"vars","containerName":"","kind":2},{"line":95,"containerName":null,"kind":13,"name":"$DBEMBLLOADED"},{"line":95,"kind":2,"containerName":"Bio::SeqIO::Bio::DB","name":"EMBL"},{"line":99,"containerName":"","kind":2,"name":"base"},{"definition":"sub","detail":"($thing,%args)","children":[{"definition":"my","name":"$thing","containerName":"load","localvar":"my","kind":13,"line":120},{"line":120,"name":"%args","kind":13,"containerName":"load"},{"definition":"my","name":"$class","kind":13,"localvar":"my","containerName":"load","line":121},{"name":"$thing","kind":13,"containerName":"load","line":121},{"line":121,"kind":13,"containerName":"load","name":"$thing"},{"definition":"my","name":"$obj","localvar":"my","containerName":"load","kind":13,"line":122},{"line":122,"kind":13,"containerName":"load","name":"%loader"},{"line":124,"name":"$db","localvar":"my","kind":13,"containerName":"load","definition":"my"},{"kind":13,"containerName":"load","name":"$filename","line":124},{"name":"$id","kind":13,"containerName":"load","line":124},{"kind":13,"containerName":"load","name":"$args","line":124},{"name":"$args","containerName":"load","kind":13,"line":124},{"line":124,"containerName":"load","kind":13,"name":"$args"},{"kind":13,"containerName":"load","name":"$db","line":126},{"name":"$db","containerName":"load","kind":13,"line":127},{"kind":13,"containerName":"load","name":"$db","line":132},{"containerName":"load","kind":13,"name":"$id","line":135},{"line":135,"name":"$filename","containerName":"load","kind":13},{"kind":13,"containerName":"load","name":"$id","line":140},{"line":140,"name":"$filename","containerName":"load","kind":13},{"name":"$hashref","localvar":"my","kind":13,"containerName":"load","line":145,"definition":"my"},{"line":146,"name":"$db","kind":13,"containerName":"load"},{"definition":"my","localvar":"my","kind":13,"containerName":"load","name":"$test_transl","line":147},{"definition":"my","line":150,"name":"@embl_valid_feature_names","localvar":"my","containerName":"load","kind":13},{"definition":"my","line":151,"name":"@embl_valid_qual_names","localvar":"my","containerName":"load","kind":13},{"line":155,"containerName":"load","kind":13,"name":"$test_transl"},{"name":"@embl_valid_qual_names","containerName":"load","kind":13,"line":156},{"line":159,"name":"$seqobj","containerName":"load","localvar":"my","kind":13,"definition":"my"},{"containerName":"load","kind":13,"name":"$filename","line":161},{"definition":"my","line":162,"localvar":"my","kind":13,"containerName":"load","name":"$stream"},{"line":162,"name":"new","containerName":"load","kind":12},{"line":162,"kind":13,"containerName":"load","name":"$filename"},{"line":163,"kind":13,"containerName":"load","name":"$seqobj"},{"line":163,"name":"$stream","containerName":"load","kind":13},{"containerName":"load","kind":12,"name":"next_seq","line":163},{"line":166,"name":"$DBEMBLLOADED","containerName":"load","kind":13},{"line":167,"localvar":"my","containerName":"load","kind":13,"name":"$embl","definition":"my"},{"line":167,"name":"new","kind":12,"containerName":"load"},{"containerName":"load","kind":13,"name":"$seqobj","line":168},{"name":"$embl","containerName":"load","kind":13,"line":168},{"line":168,"name":"get_Seq_by_id","containerName":"load","kind":12},{"name":"$id","kind":13,"containerName":"load","line":168},{"kind":13,"localvar":"my","containerName":"load","name":"$root","line":170,"definition":"my"},{"line":170,"name":"new","containerName":"load","kind":12},{"name":"$root","containerName":"load","kind":13,"line":171},{"name":"warn","kind":12,"containerName":"load","line":171},{"containerName":"load","kind":13,"name":"$hashref","line":176},{"line":176,"kind":13,"containerName":"load","name":"$seqobj"},{"line":176,"containerName":"load","kind":13,"name":"@embl_valid_feature_names"},{"containerName":"load","kind":13,"name":"@embl_valid_qual_names","line":176},{"name":"$hashref","kind":13,"containerName":"load","line":178},{"name":"%loader","containerName":"load","kind":13,"line":180},{"name":"$db","kind":13,"containerName":"load","line":180},{"name":"$filename","kind":13,"containerName":"load","line":180},{"line":180,"kind":13,"containerName":"load","name":"$id"},{"name":"$hashref","kind":13,"containerName":"load","line":180},{"line":181,"name":"$obj","containerName":"load","kind":13},{"line":181,"name":"%loader","containerName":"load","kind":13},{"line":182,"kind":13,"containerName":"load","name":"$obj"},{"line":182,"kind":13,"containerName":"load","name":"$obj"},{"containerName":"load","kind":13,"name":"$class","line":182},{"name":"$obj","kind":13,"containerName":"load","line":183}],"name":"load","containerName":"main::","signature":{"label":"load($thing,%args)","parameters":[{"label":"$thing"},{"label":"%args"}],"documentation":"1;\n# $Id: BioPerl.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::IO::BioPerl\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::IO::BioPerl - Loader for LiveSeq from EMBL entries with BioPerl\n\n=head1 SYNOPSIS\n\n  my $db=\"EMBL\";\n  my $file=\"../data/M20132\";\n  my $id=\"HSANDREC\";\n\n  my $loader=Bio::LiveSeq::IO::BioPerl->load(-db=>\"$db\", -file=>\"$file\");\n  #                      or\n  my $loader=Bio::LiveSeq::IO::BioPerl->load(-db=>\"$db\", -id=>\"$id\");\n\n  my @translationobjects=$loader->entry2liveseq();\n\n  my $genename=\"AR\";\n  my $gene=$loader->gene2liveseq(-gene_name => \"$genename\",\n                                    -getswissprotinfo => 0);\n\n  #NOTE1: The only -db now supported is EMBL. Hence it defaults to EMBL.\n  #NOTE2: -file requires a filename (and path if necessary) containing an\n  #             EMBL entry\n  #       -id will use Bio::DB::EMBL.pm to fetch the sequence from the web,\n  #             (bioperl wraparound to [w]getz from SRS)\n  #NOTE3: To retrieve the swissprot (if possible) attached to the embl entry\n  #             (to get protein domains at dna level), only Bio::DB::EMBL.pm\n  #             is supported under BioPerl. Refer to Bio::LiveSeq::IO::SRS\n  #             otherwise.\n  #NOTE4: NOTE3 is not implemented yet for bioperl, working on it\n\n\n=head1 DESCRIPTION\n\nThis package uses BioPerl (SeqIO) to fetch a sequence database entry,\nanalyse it and create LiveSeq objects out of it.\n\nA filename (or an ID that will fetch entry through the web) has to be passed\nto this package which will return references to all translation objects\ncreated from the EMBL entry. References to Transcription, DNA and Exon\nobjects can all be retrieved departing from these.\n\nAlternatively, a specific \"gene\" name can be specified, together with\nthe embl-acc ID. This will create a LiveSeq::Gene object with all\nrelevant gene features attached/created.\n\nATTENTION: if web fetching is requested, the package HTTP::Request needs\nto be installed.\n\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::IO::BioPerl;\n\n# TODO->TOCHECK\n# each_secondary_access not working\n# why array from each_tag_value($qual) ? When will there be more than one\n#                                        element in such array?\n# what is the annotation object? ($seqobj->annotation)\n# unsatisfied by both BioPerl binomial and SRS \"org\" to retrieve Organism info\n\nuse strict;\nuse Carp qw(cluck croak carp);\nuse vars qw($DBEMBLLOADED);\nuse Bio::SeqIO; # for -file entry loading\n\n# Note, the following requires HTTP::Request. If the modules are not installed\n# uncomment the following and use only -filename and don't request swissprotinfo\neval { \n    require Bio::DB::EMBL; # for -id entry loading\n    $DBEMBLLOADED = 1;\n};\n\n\nuse base qw(Bio::LiveSeq::IO::Loader);\n\n# This package can in the future host other databases loading subroutines.\n# e.g. ensembl2hash\n\n=head2 load\n\n  Title   : load\n  Usage   : my $filename=\"../data/M20132\";\n            $loader=Bio::LiveSeq::IO::BioPerl->load(-db=>\"EMBL\", -file=>\"$filename\");\n                                   or\n            $loader=Bio::LiveSeq::IO::BioPerl->load(-db=>\"EMBL\", -id=>\"HSANDREC\");\n\n  Function: loads an entry with BioPerl from a database into a hash\n  Returns : reference to a new object of class IO::BioPerl holding an entry\n  Errorcode 0\n  Args    : an filename containing an EMBL entry OR an ID or ACCESSION code"},"line":119,"kind":12,"range":{"start":{"line":119,"character":0},"end":{"line":184,"character":9999}}},{"line":128,"name":"carp","kind":12},{"name":"carp","kind":12,"line":136},{"line":141,"kind":12,"name":"carp"},{"name":"Bio","kind":12,"containerName":"SeqIO","line":162},{"line":167,"kind":12,"containerName":"DB::EMBL","name":"Bio"},{"line":170,"kind":12,"containerName":"Root::Root","name":"Bio"},{"kind":12,"name":"embl2hash","line":176},{"line":180,"kind":12,"name":"db"},{"kind":12,"name":"filename","line":180},{"line":180,"name":"id","kind":12},{"name":"hash","kind":12,"line":180},{"definition":"sub","children":[{"definition":"my","line":208,"localvar":"my","containerName":"embl2hash","kind":13,"name":"$seqobj"},{"definition":"my","localvar":"my","kind":13,"containerName":"embl2hash","name":"%valid_features","line":209},{"definition":"my","name":"%valid_names","localvar":"my","kind":13,"containerName":"embl2hash","line":209},{"containerName":"embl2hash","kind":13,"name":"%valid_features","line":211}],"name":"embl2hash","containerName":"main::","line":207,"kind":12,"range":{"end":{"line":212,"character":9999},"start":{"line":207,"character":0}}},{"containerName":null,"kind":13,"name":"%valid_names","line":214},{"definition":"my","line":217,"name":"$annobj","kind":13,"localvar":"my","containerName":null},{"line":217,"name":"$seqobj","containerName":null,"kind":13},{"line":217,"name":"annotation","containerName":"main::","kind":12},{"name":"$entry_Sequence","localvar":"my","containerName":null,"kind":13,"line":219,"definition":"my"},{"line":219,"containerName":null,"kind":13,"name":"$seqobj"},{"containerName":"main::","kind":12,"name":"seq","line":219},{"definition":"my","localvar":"my","containerName":null,"kind":13,"name":"$entry_ID","line":221},{"line":221,"kind":13,"containerName":null,"name":"$seqobj"},{"name":"display_id","containerName":"main::","kind":12,"line":221},{"line":222,"name":"$entry_AccNumber","localvar":"my","kind":13,"containerName":null,"definition":"my"},{"line":222,"kind":13,"containerName":null,"name":"$seqobj"},{"name":"accession","containerName":"main::","kind":12,"line":222},{"definition":"my","line":223,"name":"$secondary_acc","kind":13,"localvar":"my","containerName":null},{"name":"$secondary_acc","containerName":null,"kind":13,"line":224},{"name":"$seqobj","containerName":null,"kind":13,"line":224},{"name":"get_secondary_accessions","containerName":"main::","kind":12,"line":224},{"line":225,"name":"$entry_AccNumber","containerName":null,"kind":13},{"line":227,"name":"$entry_Molecule","containerName":null,"localvar":"my","kind":13,"definition":"my"},{"line":227,"kind":13,"containerName":null,"name":"$seqobj"},{"line":227,"containerName":"main::","kind":12,"name":"molecule"},{"name":"$entry_Division","containerName":null,"localvar":"my","kind":13,"line":228,"definition":"my"},{"line":228,"name":"$seqobj","containerName":null,"kind":13},{"line":228,"name":"division","kind":12,"containerName":"main::"},{"line":233,"name":"$entry_Description","localvar":"my","kind":13,"containerName":null,"definition":"my"},{"line":233,"name":"$seqobj","kind":13,"containerName":null},{"name":"desc","kind":12,"containerName":"main::","line":233},{"line":235,"kind":13,"localvar":"my","containerName":null,"name":"$speciesobj","definition":"my"},{"containerName":null,"kind":13,"name":"$seqobj","line":235},{"name":"species","kind":12,"containerName":"main::","line":235},{"line":236,"name":"$entry_Organism","localvar":"my","containerName":null,"kind":13,"definition":"my"},{"kind":13,"containerName":null,"name":"$speciesobj","line":236},{"line":236,"containerName":"main::","kind":12,"name":"binomial"},{"kind":13,"localvar":"my","containerName":null,"name":"$entry_SeqLength","line":238,"definition":"my"},{"kind":13,"containerName":null,"name":"$seqobj","line":238},{"line":238,"containerName":"main::","kind":12,"name":"length"},{"line":241,"name":"%entryhash","localvar":"my","kind":13,"containerName":null,"definition":"my"},{"kind":13,"containerName":null,"name":"%entryhash","line":242},{"line":242,"kind":12,"name":"ID"},{"line":242,"containerName":null,"kind":13,"name":"$entry_ID"},{"line":243,"name":"%entryhash","containerName":null,"kind":13},{"kind":12,"name":"AccNumber","line":243},{"line":243,"kind":13,"containerName":null,"name":"$entry_AccNumber"},{"containerName":null,"kind":13,"name":"%entryhash","line":244},{"name":"Molecule","kind":12,"line":244},{"containerName":null,"kind":13,"name":"$entry_Molecule","line":244},{"kind":13,"containerName":null,"name":"%entryhash","line":245},{"line":245,"name":"Division","kind":12},{"name":"$entry_Division","containerName":null,"kind":13,"line":245},{"line":246,"kind":13,"containerName":null,"name":"%entryhash"},{"line":246,"name":"Description","kind":12},{"name":"$entry_Description","containerName":null,"kind":13,"line":246},{"line":247,"containerName":null,"kind":13,"name":"%entryhash"},{"kind":12,"name":"Organism","line":247},{"containerName":null,"kind":13,"name":"$entry_Organism","line":247},{"line":248,"kind":13,"containerName":null,"name":"%entryhash"},{"line":248,"kind":12,"name":"Sequence"},{"kind":13,"containerName":null,"name":"$entry_Sequence","line":248},{"line":249,"name":"%entryhash","kind":13,"containerName":null},{"kind":12,"name":"SeqLength","line":249},{"name":"$entry_SeqLength","containerName":null,"kind":13,"line":249},{"name":"@topfeatures","kind":13,"localvar":"my","containerName":null,"line":251,"definition":"my"},{"containerName":null,"kind":13,"name":"$seqobj","line":251},{"line":251,"containerName":"main::","kind":12,"name":"top_SeqFeatures"},{"definition":"my","name":"$featuresnumber","localvar":"my","containerName":null,"kind":13,"line":253},{"containerName":null,"kind":13,"name":"@topfeatures","line":253},{"line":254,"name":"%entryhash","containerName":null,"kind":13},{"kind":12,"name":"FeaturesNumber","line":254},{"name":"$featuresnumber","containerName":null,"kind":13,"line":254},{"containerName":null,"localvar":"my","kind":13,"name":"$feature_name","line":255,"definition":"my"},{"containerName":null,"localvar":"my","kind":13,"name":"@feature_qual_names","line":256,"definition":"my"},{"containerName":null,"localvar":"my","kind":13,"name":"@feature_qual_value","line":256,"definition":"my"},{"definition":"my","line":257,"name":"$feature_qual_name","containerName":null,"localvar":"my","kind":13},{"kind":13,"containerName":null,"name":"$feature_qual_number","line":257},{"line":258,"localvar":"my","containerName":null,"kind":13,"name":"@features","definition":"my"},{"definition":"my","localvar":"my","containerName":null,"kind":13,"name":"$feat","line":260},{"line":260,"name":"$qual","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"$subfeat","line":260},{"name":"@subfeat","localvar":"my","kind":13,"containerName":null,"line":261,"definition":"my"},{"containerName":null,"localvar":"my","kind":13,"name":"$i","line":262,"definition":"my"},{"name":"$feat","containerName":null,"kind":13,"line":263},{"name":"@topfeatures","kind":13,"containerName":null,"line":263},{"name":"%feature","localvar":"my","kind":13,"containerName":null,"line":264,"definition":"my"},{"line":265,"name":"$feature_name","kind":13,"containerName":null},{"name":"$feat","kind":13,"containerName":null,"line":265},{"line":265,"kind":12,"containerName":"main::","name":"primary_tag"},{"line":266,"kind":13,"containerName":null,"name":"%valid_features"},{"line":266,"name":"%feature_name","containerName":null,"kind":13},{"name":"$featlocation","localvar":"my","kind":13,"containerName":null,"line":273,"definition":"my"},{"name":"$feat","containerName":null,"kind":13,"line":273},{"name":"location","kind":12,"containerName":"main::","line":273},{"containerName":null,"kind":13,"name":"$feature_name","line":274},{"name":"$featlocation","kind":13,"containerName":null,"line":274},{"line":274,"kind":12,"containerName":"main::","name":"isa"},{"line":276,"kind":13,"containerName":null,"name":"@subfeat"},{"name":"$featlocation","containerName":null,"kind":13,"line":276},{"kind":12,"containerName":"main::","name":"sub_Location","line":276},{"definition":"my","line":277,"name":"@transcript","containerName":null,"localvar":"my","kind":13},{"name":"$subfeat","containerName":null,"kind":13,"line":278},{"line":278,"name":"@subfeat","containerName":null,"kind":13},{"definition":"my","line":279,"name":"@range","localvar":"my","kind":13,"containerName":null},{"line":280,"containerName":null,"kind":13,"name":"$subfeat"},{"name":"strand","kind":12,"containerName":"main::","line":280},{"line":281,"name":"@range","containerName":null,"kind":13},{"line":281,"kind":13,"containerName":null,"name":"$subfeat"},{"containerName":"main::","kind":12,"name":"end","line":281},{"containerName":null,"kind":13,"name":"$subfeat","line":281},{"name":"start","containerName":"main::","kind":12,"line":281},{"kind":13,"containerName":null,"name":"$subfeat","line":281},{"line":281,"kind":12,"containerName":"main::","name":"strand"},{"line":283,"name":"@range","kind":13,"containerName":null},{"name":"$subfeat","containerName":null,"kind":13,"line":283},{"line":283,"kind":12,"containerName":"main::","name":"start"},{"kind":13,"containerName":null,"name":"$subfeat","line":283},{"containerName":"main::","kind":12,"name":"end","line":283},{"line":283,"name":"$subfeat","containerName":null,"kind":13},{"line":283,"name":"strand","containerName":"main::","kind":12},{"line":285,"name":"@transcript","containerName":null,"kind":13},{"name":"@range","containerName":null,"kind":13,"line":285},{"line":287,"containerName":null,"kind":13,"name":"%feature"},{"line":287,"name":"range","kind":12},{"containerName":null,"kind":13,"name":"@transcript","line":287},{"name":"@range","containerName":null,"localvar":"my","kind":13,"line":289,"definition":"my"},{"containerName":null,"kind":13,"name":"$feat","line":290},{"line":290,"name":"strand","kind":12,"containerName":"main::"},{"line":290,"name":"@range","containerName":null,"kind":13},{"name":"$feat","kind":13,"containerName":null,"line":290},{"line":290,"containerName":"main::","kind":12,"name":"end"},{"kind":13,"containerName":null,"name":"$feat","line":290},{"line":290,"kind":12,"containerName":"main::","name":"start"},{"containerName":null,"kind":13,"name":"$feat","line":290},{"name":"strand","containerName":"main::","kind":12,"line":290},{"name":"@range","containerName":null,"kind":13,"line":291},{"containerName":null,"kind":13,"name":"$feat","line":291},{"line":291,"containerName":"main::","kind":12,"name":"start"},{"line":291,"kind":13,"containerName":null,"name":"$feat"},{"line":291,"name":"end","kind":12,"containerName":"main::"},{"containerName":null,"kind":13,"name":"$feat","line":291},{"line":291,"name":"strand","containerName":"main::","kind":12},{"line":293,"kind":13,"containerName":null,"name":"%feature_name"},{"line":294,"containerName":null,"localvar":"my","kind":13,"name":"@transcript","definition":"my"},{"line":294,"kind":13,"containerName":null,"name":"@range"},{"containerName":null,"kind":13,"name":"%feature","line":295},{"line":295,"kind":12,"name":"range"},{"kind":13,"containerName":null,"name":"@transcript","line":295},{"name":"%feature","kind":13,"containerName":null,"line":297},{"line":297,"kind":12,"name":"range"},{"name":"@range","kind":13,"containerName":null,"line":297},{"line":300,"kind":13,"containerName":null,"name":"%feature"},{"line":300,"kind":12,"name":"location"},{"containerName":null,"kind":13,"name":"%feature","line":302},{"line":302,"kind":12,"name":"position"},{"line":302,"kind":13,"containerName":null,"name":"$i"},{"name":"%feature","containerName":null,"kind":13,"line":303},{"kind":12,"name":"name","line":303},{"name":"$feature_name","containerName":null,"kind":13,"line":303},{"line":305,"name":"@feature_qual_names","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"$feat","line":305},{"name":"all_tags","kind":12,"containerName":"main::","line":305},{"kind":13,"containerName":null,"name":"$feature_qual_number","line":306},{"kind":13,"containerName":null,"name":"@feature_qual_names","line":306},{"containerName":null,"kind":13,"name":"%feature","line":308},{"kind":12,"name":"qual_number","line":308},{"name":"$feature_qual_number","kind":13,"containerName":null,"line":308},{"definition":"my","name":"%feature_qualifiers","containerName":null,"localvar":"my","kind":13,"line":310},{"line":311,"containerName":null,"kind":13,"name":"$qual"},{"name":"@feature_qual_names","containerName":null,"kind":13,"line":311},{"line":312,"name":"$feature_qual_name","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"$qual","line":312},{"containerName":null,"kind":13,"name":"%valid_names","line":313},{"kind":13,"containerName":null,"name":"%feature_qual_name","line":313},{"name":"@feature_qual_value","containerName":null,"kind":13,"line":316},{"line":316,"kind":13,"containerName":null,"name":"$feat"},{"line":316,"containerName":"main::","kind":12,"name":"each_tag_value"},{"containerName":null,"kind":13,"name":"$qual","line":316},{"containerName":null,"kind":13,"name":"%feature_qualifiers","line":318},{"name":"$feature_qual_name","kind":13,"containerName":null,"line":318},{"kind":13,"containerName":null,"name":"@feature_qual_value","line":318},{"line":322,"kind":13,"containerName":null,"name":"%feature"},{"line":322,"kind":12,"name":"qualifiers"},{"name":"%feature_qualifiers","containerName":null,"kind":13,"line":322},{"name":"@features","kind":13,"containerName":null,"line":323},{"line":323,"name":"%feature","kind":13,"containerName":null},{"name":"$i","containerName":null,"kind":13,"line":324},{"line":326,"name":"%entryhash","containerName":null,"kind":13},{"line":326,"name":"Features","kind":12},{"containerName":null,"kind":13,"name":"@features","line":326},{"definition":"my","line":328,"localvar":"my","containerName":null,"kind":13,"name":"@cds"},{"line":329,"containerName":null,"kind":13,"name":"$i"},{"line":329,"name":"features","kind":12},{"name":"@features","containerName":null,"kind":13,"line":330},{"containerName":null,"kind":13,"name":"%i","line":330},{"line":331,"kind":13,"containerName":null,"name":"@cds"},{"line":331,"containerName":null,"kind":13,"name":"@features"},{"kind":13,"containerName":null,"name":"$i","line":331},{"containerName":null,"kind":13,"name":"%entryhash","line":334},{"line":334,"kind":12,"name":"CDS"},{"line":334,"name":"@cds","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"%entryhash","line":335},{"range":{"start":{"character":0,"line":365},"end":{"line":396,"character":9999}},"kind":12,"line":365,"signature":{"documentation":"1;\n# $Id: BioPerl.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::IO::BioPerl\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::IO::BioPerl - Loader for LiveSeq from EMBL entries with BioPerl\n\n=head1 SYNOPSIS\n\n  my $db=\"EMBL\";\n  my $file=\"../data/M20132\";\n  my $id=\"HSANDREC\";\n\n  my $loader=Bio::LiveSeq::IO::BioPerl->load(-db=>\"$db\", -file=>\"$file\");\n  #                      or\n  my $loader=Bio::LiveSeq::IO::BioPerl->load(-db=>\"$db\", -id=>\"$id\");\n\n  my @translationobjects=$loader->entry2liveseq();\n\n  my $genename=\"AR\";\n  my $gene=$loader->gene2liveseq(-gene_name => \"$genename\",\n                                    -getswissprotinfo => 0);\n\n  #NOTE1: The only -db now supported is EMBL. Hence it defaults to EMBL.\n  #NOTE2: -file requires a filename (and path if necessary) containing an\n  #             EMBL entry\n  #       -id will use Bio::DB::EMBL.pm to fetch the sequence from the web,\n  #             (bioperl wraparound to [w]getz from SRS)\n  #NOTE3: To retrieve the swissprot (if possible) attached to the embl entry\n  #             (to get protein domains at dna level), only Bio::DB::EMBL.pm\n  #             is supported under BioPerl. Refer to Bio::LiveSeq::IO::SRS\n  #             otherwise.\n  #NOTE4: NOTE3 is not implemented yet for bioperl, working on it\n\n\n=head1 DESCRIPTION\n\nThis package uses BioPerl (SeqIO) to fetch a sequence database entry,\nanalyse it and create LiveSeq objects out of it.\n\nA filename (or an ID that will fetch entry through the web) has to be passed\nto this package which will return references to all translation objects\ncreated from the EMBL entry. References to Transcription, DNA and Exon\nobjects can all be retrieved departing from these.\n\nAlternatively, a specific \"gene\" name can be specified, together with\nthe embl-acc ID. This will create a LiveSeq::Gene object with all\nrelevant gene features attached/created.\n\nATTENTION: if web fetching is requested, the package HTTP::Request needs\nto be installed.\n\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::IO::BioPerl;\n\n# TODO->TOCHECK\n# each_secondary_access not working\n# why array from each_tag_value($qual) ? When will there be more than one\n#                                        element in such array?\n# what is the annotation object? ($seqobj->annotation)\n# unsatisfied by both BioPerl binomial and SRS \"org\" to retrieve Organism info\n\nuse strict;\nuse Carp qw(cluck croak carp);\nuse vars qw($DBEMBLLOADED);\nuse Bio::SeqIO; # for -file entry loading\n\n# Note, the following requires HTTP::Request. If the modules are not installed\n# uncomment the following and use only -filename and don't request swissprotinfo\neval { \n    require Bio::DB::EMBL; # for -id entry loading\n    $DBEMBLLOADED = 1;\n};\n\n\nuse base qw(Bio::LiveSeq::IO::Loader);\n\n# This package can in the future host other databases loading subroutines.\n# e.g. ensembl2hash\n\n=head2 load\n\n  Title   : load\n  Usage   : my $filename=\"../data/M20132\";\n            $loader=Bio::LiveSeq::IO::BioPerl->load(-db=>\"EMBL\", -file=>\"$filename\");\n                                   or\n            $loader=Bio::LiveSeq::IO::BioPerl->load(-db=>\"EMBL\", -id=>\"HSANDREC\");\n\n  Function: loads an entry with BioPerl from a database into a hash\n  Returns : reference to a new object of class IO::BioPerl holding an entry\n  Errorcode 0\n  Args    : an filename containing an EMBL entry OR an ID or ACCESSION code\n\n\nsub load {\n  my ($thing, %args) = @_;\n  my $class = ref($thing) || $thing;\n  my ($obj,%loader);\n\n  my ($db,$filename,$id)=($args{-db},$args{-file},$args{-id});\n\n  if (defined($db)) {\n    unless ($db eq \"EMBL\") {\n      carp \"Note: only EMBL now supported!\";\n      return(0);\n    }\n  } else {\n    $db=\"EMBL\";\n  }\n\n  if (defined($id) && defined($filename)) {\n    carp \"You can either specify a -id or a -filename!\";\n    return(0);\n  }\n\n  unless (defined($id) || defined($filename)) {\n    carp \"You must specify either a -id or a -filename!\";\n    return(0);\n  }\n\n  my $hashref;\n  if ($db eq \"EMBL\") {\n    my $test_transl=0; # change to 0 to avoid comparison of translation\n\n    # these can be changed for future needs\n    my @embl_valid_feature_names=qw(CDS CDS_span exon prim_transcript intron repeat_unit repeat_region mRNA);\n    my @embl_valid_qual_names=qw(gene codon_start db_xref product note number rpt_family transl_table);\n\n    # dunno yet how to implement test_transl again....\n    # probably on a one-on-one basis with each translation?\n    if ($test_transl) {\n      push (@embl_valid_qual_names,\"translation\"); # needed for test_transl\n    }\n\n    my $seqobj; # bioperl sequence object, to be passed to embl2hash\n\n    if (defined($filename)) {\n      my $stream = Bio::SeqIO->new('-file' => $filename, '-format' => 'EMBL');\n      $seqobj = $stream->next_seq();\n    } else { # i.e. if -id\n\t\n\tif( $DBEMBLLOADED ) {\n\t    my $embl = Bio::DB::EMBL->new();\n\t    $seqobj = $embl->get_Seq_by_id($id); # EMBL ID or ACC\n\t} else { \n\t    my $root = Bio::Root::Root->new();\n\t    $root->warn(\"Must have HTTP::Request::Common installed, cannot run load without the -filename option specified, see docs for Bio::LiveSeq::IO::BioPerl\");\n\t    return;\n\t}\n    }\n\n    $hashref=&embl2hash($seqobj,\\@embl_valid_feature_names,\\@embl_valid_qual_names);\n  }\n  unless ($hashref) { return (0); }\n\n  %loader = (db => $db, filename => $filename, id => $id, hash => $hashref);\n  $obj = \\%loader;\n  $obj = bless $obj, $class;\n  return $obj;\n}\n\n=head2 embl2hash\n\n  Title   : embl2hash\n  Function: retrieves with BioPerl an EMBL entry, parses it and creates\n            a hash that contains all the information.\n  Returns : a reference to a hash\n  Errorcode: 0\n  Args    : a BioPerl Sequence Object (from file or web fetching)\n\t    two array references to skip features and qualifiers (for\n\t    performance)\n  Example: @valid_features=qw(CDS exon prim_transcript mRNA);\n           @valid_qualifiers=qw(gene codon_start db_xref product rpt_family);\n           $hashref=&embl2hash($seqobj,\\@valid_features,\\@valid_qualifiers);\n\n\n# arguments: Bioperl $seqobj\n# to skip features and qualifiers (for performance), two array\n# references must be passed (this can change into string arguments to\n# be passed....)\n# returns: a reference to a hash containing the important features requested\nsub embl2hash {\n  my $seqobj=$_[0];\n  my %valid_features; my %valid_names;\n  if ($_[1]) {\n    %valid_features = map {$_, 1} @{$_[1]}; # to skip features\n  }\n  if ($_[2]) {\n    %valid_names = map {$_, 1} @{$_[2]}; # to skip qualifiers\n  }\n\n  my $annobj = $seqobj->annotation(); # what's this?\n\n  my $entry_Sequence = lc($seqobj->seq()); # SRS returns lowercase\n\n  my $entry_ID = $seqobj->display_id;\n  my $entry_AccNumber = $seqobj->accession; # or maybe accession_number ?\n  my $secondary_acc; # to fetch the other acc numbers\n  foreach $secondary_acc ($seqobj->get_secondary_accessions) { # not working!\n    $entry_AccNumber .= \" $secondary_acc\";\n  }\n  my $entry_Molecule = $seqobj->molecule; # this alone returns molec+division\n  my $entry_Division = $seqobj->division;\n  # fixed: now Molecule works in BioPerl, no need for next lines\n  #my @Molecule=split(\" \",$entry_Molecule);\n  #my $entry_Division = pop(@Molecule); # only division\n  #$entry_Molecule = join(\" \",@Molecule); # only molecule\n  my $entry_Description = $seqobj->desc;\n\n  my $speciesobj = $seqobj->species;\n  my $entry_Organism = $speciesobj->binomial;\n\n  my $entry_SeqLength = $seqobj->length;\n  \n  # put into the hash\n  my %entryhash;\n  $entryhash{ID}=$entry_ID;\n  $entryhash{AccNumber}=$entry_AccNumber;\n  $entryhash{Molecule}=$entry_Molecule;\n  $entryhash{Division}=$entry_Division;\n  $entryhash{Description}=$entry_Description;\n  $entryhash{Organism}=$entry_Organism;\n  $entryhash{Sequence}=$entry_Sequence;\n  $entryhash{SeqLength}=$entry_SeqLength;\n\n  my @topfeatures=$seqobj->top_SeqFeatures();\n  # create features array\n  my $featuresnumber= scalar(@topfeatures);\n  $entryhash{FeaturesNumber}=$featuresnumber;\n  my $feature_name;\n  my @feature_qual_names; my @feature_qual_value;\n  my ($feature_qual_name,$feature_qual_number);\n  my @features;\n\n  my ($feat,$qual,$subfeat);\n  my @subfeat;\n  my $i=0;\n  foreach $feat (@topfeatures) {\n      my %feature;\n      $feature_name = $feat->primary_tag;\n      unless ($valid_features{$feature_name}) {\n\t  #print \"skipping $feature_name\\n\";\n\t  next;\n      }\n# works ok with 0.6.2\n#    if ($feature_name eq \"CDS_span\") { # case of CDS with various exons 0.6.2\n#      $feature_name=\"CDS\"; # 0.6.2\n      my $featlocation=$feat->location; # 0.7\n      if (($feature_name eq \"CDS\")&&($featlocation->isa('Bio::Location::SplitLocationI'))) { # case of CDS with various exons BioPerl 0.7\n#      @subfeat=$feat->sub_SeqFeature; # 0.6.2\n\t  @subfeat=$featlocation->sub_Location(); # 0.7\n\t  my @transcript;\n\t  foreach $subfeat (@subfeat) {\n\t      my @range;\n\t      if ($subfeat->strand == -1) {\n\t\t  @range=($subfeat->end,$subfeat->start,$subfeat->strand);\n\t      } else {\n\t\t  @range=($subfeat->start,$subfeat->end,$subfeat->strand);\n\t      }\n\t      push (@transcript,\\@range);\n\t  }\n\t  $feature{range}=\\@transcript;\n      } else {\n\t  my @range;\n\t  ($feat->strand == -1) ? (@range = ($feat->end, $feat->start, $feat->strand) ) :\n\t      (@range = ( $feat->start,$feat->end,$feat->strand) );\n# works ok with 0.6.2\n\t  if ($feature_name eq \"CDS\") { # case of single exon CDS (CDS name but not split location)\n\t      my @transcript=(\\@range);\n\t      $feature{range}=\\@transcript;\n\t  } else { # all other range features\n\t      $feature{range}=\\@range;\n\t  }\n      }\n      $feature{location}=\"deprecated\";\n      \n      $feature{position}=$i;\n      $feature{name}=$feature_name;\n      \n      @feature_qual_names= $feat->all_tags();\n      $feature_qual_number= scalar(@feature_qual_names);\n      \n      $feature{qual_number}=$feature_qual_number;\n      \n      my %feature_qualifiers;\n      for $qual (@feature_qual_names) {\n\t  $feature_qual_name=$qual;\n\t  unless ($valid_names{$feature_qual_name}) {\n\t      next;\n\t  }\n      @feature_qual_value=$feat->each_tag_value($qual);\n\t  #print \"$qual => @feature_qual_value \\n\";\n\t  $feature_qualifiers{$feature_qual_name}=$feature_qual_value[0]; # ?\n      # maybe the whole array should be entered, not just the 1st element?\n\t  # what could be the other elements? TOCHECK!\n      }\n      $feature{qualifiers}=\\%feature_qualifiers;\n      push (@features,\\%feature); # array of features\n      $i++;\n  }\n  $entryhash{Features}=\\@features; # put this also into the hash\n  \n  my @cds; # array just of CDSs\n  for $i (0..$#features) {\n      if ($features[$i]->{'name'} eq \"CDS\") {\n\t  push(@cds,$features[$i]);\n      }\n  }\n  $entryhash{CDS}=\\@cds; # put this also into the hash\n  return (\\%entryhash);\n}\n\n=head2 novelaasequence2gene\n\n  Title   : novelaasequence2gene\n  Usage   : $gene=Bio::LiveSeq::IO::BioPerl->novelaasequence2gene(-aasequence => \"MGLAAPTRS*\");\n          : $gene=Bio::LiveSeq::IO::BioPerl->novelaasequence2gene(-aasequence => \"MGLAAPTRS*\",\n                                             -cusg_data => \"58 44 7 29 3 3 480 267 105 143 122 39 144 162 14 59 53 25 233 292 19 113 88 246 28 68 161 231 27 102 128 151 67 60 138 131 48 61 153 19 233 73 150 31 129 38 147 71 138 43 181 81 44 15 255 118 312 392 236 82 20 10 14 141\");\n          : $gene=Bio::LiveSeq::IO::BioPerl->novelaasequence2gene(-aasequence => \"MGLAAPTRS*\",\n                                             -cusg_data => \"58 44 7 29 3 3 480 267 105 143 122 39 144 162 14 59 53 25 233 292 19 113 88 246 28 68 161 231 27 102 128 151 67 60 138 131 48 61 153 19 233 73 150 31 129 38 147 71 138 43 181 81 44 15 255 118 312 392 236 82 20 10 14 141\",\n                                             -translation_table => \"2\",\n                                             -gene_name => \"tyr-kinase\");\n\n  Function: creates LiveSeq objects from a novel amino acid sequence,\n            using codon usage information (loaded from a file) to choose\n            codons according to relative frequencies.\n            If a codon_usage information is not specified,\n            the default is to use Homo sapiens data (taxonomy ID 9606).\n            If a translation_table ID is not specified, it will default to 1\n            (standard code).\n  Returns : reference to a Gene object containing references to LiveSeq objects\n  Errorcode 0\n  Args    : string containing an amino acid sequence\n\t    string (optional) with codon usage data (64 integer numbers)\n            string (optional) specifying a gene_name\n            integer (optional) specifying a translation_table ID","parameters":[{"label":"$self"},{"label":"%args"}],"label":"novelaasequence2gene($self,%args)"},"containerName":"main::","name":"novelaasequence2gene","children":[{"definition":"my","localvar":"my","containerName":"novelaasequence2gene","kind":13,"name":"$self","line":366},{"line":366,"name":"%args","containerName":"novelaasequence2gene","kind":13},{"definition":"my","name":"$gene_name","localvar":"my","containerName":"novelaasequence2gene","kind":13,"line":367},{"name":"$cusg_data","kind":13,"containerName":"novelaasequence2gene","line":367},{"name":"$aasequence","containerName":"novelaasequence2gene","kind":13,"line":367},{"line":367,"name":"$ttabid","kind":13,"containerName":"novelaasequence2gene"},{"kind":13,"containerName":"novelaasequence2gene","name":"$args","line":367},{"line":367,"containerName":"novelaasequence2gene","kind":13,"name":"$args"},{"kind":13,"containerName":"novelaasequence2gene","name":"$args","line":367},{"name":"$args","kind":13,"containerName":"novelaasequence2gene","line":367},{"definition":"my","kind":13,"localvar":"my","containerName":"novelaasequence2gene","name":"@species_codon_usage","line":369},{"containerName":"novelaasequence2gene","kind":13,"name":"$aasequence","line":370},{"line":374,"kind":13,"containerName":"novelaasequence2gene","name":"$gene_name"},{"containerName":"novelaasequence2gene","kind":13,"name":"$gene_name","line":375},{"containerName":"novelaasequence2gene","kind":13,"name":"$ttabid","line":377},{"name":"$ttabid","kind":13,"containerName":"novelaasequence2gene","line":378},{"line":380,"name":"$cusg_data","containerName":"novelaasequence2gene","kind":13},{"line":381,"name":"@species_codon_usage","kind":13,"containerName":"novelaasequence2gene"},{"kind":13,"containerName":"novelaasequence2gene","name":"@species_codon_usage","line":391},{"kind":13,"containerName":"novelaasequence2gene","name":"$cusg_data","line":391},{"containerName":"novelaasequence2gene","localvar":"my","kind":13,"name":"$gene","line":394,"definition":"my"},{"name":"@species_codon_usage","kind":13,"containerName":"novelaasequence2gene","line":394},{"line":394,"name":"$ttabid","containerName":"novelaasequence2gene","kind":13},{"line":394,"containerName":"novelaasequence2gene","kind":13,"name":"$aasequence"},{"line":394,"kind":13,"containerName":"novelaasequence2gene","name":"$gene_name"},{"containerName":"novelaasequence2gene","kind":13,"name":"$gene","line":395}],"detail":"($self,%args)","definition":"sub"},{"line":371,"name":"carp","kind":12},{"name":"Bio","containerName":"LiveSeq::IO::Loader::_common_novelaasequence2gene","kind":12,"line":394}]}