{"vars":[{"line":85,"name":"Carp","containerName":"","kind":2},{"definition":"sub","children":[],"name":"up_chain2string","containerName":"main::","line":120,"range":{"end":{"line":122,"character":9999},"start":{"character":0,"line":120}},"kind":12},{"name":"_updown_chain2string","kind":12,"line":121},{"line":121,"kind":2,"containerName":"","name":"integer"},{"range":{"start":{"character":0,"line":123},"end":{"line":125,"character":9999}},"kind":12,"line":123,"definition":"sub","name":"down_chain2string","containerName":"main::","children":[]},{"kind":12,"name":"_updown_chain2string","line":124},{"detail":"($direction,$chain,$first,$len,$last)","definition":"sub","name":"_updown_chain2string","containerName":"main::","children":[{"definition":"my","line":128,"name":"$direction","containerName":"_updown_chain2string","localvar":"my","kind":13},{"line":128,"name":"$chain","kind":13,"containerName":"_updown_chain2string"},{"line":128,"name":"$first","containerName":"_updown_chain2string","kind":13},{"line":128,"name":"$len","kind":13,"containerName":"_updown_chain2string"},{"name":"$last","kind":13,"containerName":"_updown_chain2string","line":128},{"line":129,"name":"$chain","kind":13,"containerName":"_updown_chain2string"},{"line":130,"name":"$begin","containerName":"_updown_chain2string","localvar":"my","kind":13,"definition":"my"},{"containerName":"_updown_chain2string","kind":13,"name":"$chain","line":130},{"definition":"my","localvar":"my","containerName":"_updown_chain2string","kind":13,"name":"$end","line":131},{"line":131,"kind":13,"containerName":"_updown_chain2string","name":"$chain"},{"definition":"my","line":132,"name":"$flow","localvar":"my","kind":13,"containerName":"_updown_chain2string"},{"name":"$direction","kind":13,"containerName":"_updown_chain2string","line":134},{"kind":13,"containerName":"_updown_chain2string","name":"$flow","line":135},{"name":"$first","containerName":"_updown_chain2string","kind":13,"line":136},{"line":136,"containerName":"_updown_chain2string","kind":13,"name":"$first"},{"line":136,"name":"$end","kind":13,"containerName":"_updown_chain2string"},{"kind":13,"containerName":"_updown_chain2string","name":"$flow","line":138},{"line":139,"name":"$first","kind":13,"containerName":"_updown_chain2string"},{"line":139,"containerName":"_updown_chain2string","kind":13,"name":"$first"},{"name":"$begin","kind":13,"containerName":"_updown_chain2string","line":139},{"line":142,"name":"$chain","kind":13,"containerName":"_updown_chain2string"},{"name":"$first","containerName":"_updown_chain2string","kind":13,"line":142},{"line":144,"kind":13,"containerName":"_updown_chain2string","name":"$last"},{"containerName":"_updown_chain2string","kind":13,"name":"$chain","line":145},{"line":145,"name":"$last","kind":13,"containerName":"_updown_chain2string"},{"line":147,"name":"$len","kind":13,"containerName":"_updown_chain2string"},{"name":"$len","kind":13,"containerName":"_updown_chain2string","line":149},{"name":"$direction","containerName":"_updown_chain2string","kind":13,"line":152},{"line":153,"kind":13,"containerName":"_updown_chain2string","name":"$last"},{"line":153,"kind":13,"containerName":"_updown_chain2string","name":"$begin"},{"name":"$last","kind":13,"containerName":"_updown_chain2string","line":155},{"line":155,"name":"$end","containerName":"_updown_chain2string","kind":13},{"definition":"my","line":159,"name":"$string","kind":13,"localvar":"my","containerName":"_updown_chain2string"},{"line":159,"kind":13,"containerName":"_updown_chain2string","name":"@array"},{"line":160,"kind":13,"localvar":"my","containerName":"_updown_chain2string","name":"$label","definition":"my"},{"line":160,"containerName":"_updown_chain2string","kind":13,"name":"$first"},{"name":"$i","containerName":"_updown_chain2string","localvar":"my","kind":13,"line":160,"definition":"my"},{"definition":"my","line":161,"name":"$afterlast","localvar":"my","kind":13,"containerName":"_updown_chain2string"},{"line":161,"name":"$chain","kind":13,"containerName":"_updown_chain2string"},{"line":161,"kind":13,"containerName":"_updown_chain2string","name":"$last"},{"kind":13,"containerName":"_updown_chain2string","name":"$flow","line":161},{"line":162,"name":"$afterlast","kind":13,"containerName":"_updown_chain2string"},{"line":162,"name":"$afterlast","kind":13,"containerName":"_updown_chain2string"},{"line":166,"name":"$label","containerName":"_updown_chain2string","kind":13},{"line":166,"containerName":"_updown_chain2string","kind":13,"name":"$label"},{"line":166,"name":"$afterlast","containerName":"_updown_chain2string","kind":13},{"line":166,"name":"$i","kind":13,"containerName":"_updown_chain2string"},{"name":"$len","kind":13,"containerName":"_updown_chain2string","line":166},{"line":166,"kind":13,"containerName":"_updown_chain2string","name":"$i"},{"line":167,"kind":13,"containerName":"_updown_chain2string","name":"@array"},{"line":167,"name":"$chain","containerName":"_updown_chain2string","kind":13},{"kind":13,"containerName":"_updown_chain2string","name":"$label","line":167},{"line":168,"name":"$string","containerName":"_updown_chain2string","kind":13},{"line":168,"containerName":"_updown_chain2string","kind":13,"name":"$array"},{"line":169,"name":"$label","containerName":"_updown_chain2string","kind":13},{"kind":13,"containerName":"_updown_chain2string","name":"$array","line":169},{"name":"$flow","containerName":"_updown_chain2string","kind":13,"line":169},{"line":170,"kind":13,"containerName":"_updown_chain2string","name":"$i"}],"signature":{"label":"_updown_chain2string($direction,$chain,$first,$len,$last)","documentation":"","parameters":[{"label":"$direction"},{"label":"$chain"},{"label":"$first"},{"label":"$len"},{"label":"$last"}]},"kind":12,"range":{"end":{"line":171,"character":9999},"start":{"line":127,"character":0}},"line":127},{"kind":12,"name":"cluck","line":129},{"kind":12,"name":"cluck","line":143},{"line":146,"name":"cluck","kind":12},{"containerName":null,"kind":13,"name":"$string","line":172},{"name":"down_labels","containerName":"main::","children":[{"definition":"my","name":"$chain","kind":13,"localvar":"my","containerName":"down_labels","line":192},{"line":192,"containerName":"down_labels","kind":13,"name":"$first"},{"line":192,"kind":13,"containerName":"down_labels","name":"$last"},{"name":"$chain","kind":13,"containerName":"down_labels","line":193},{"containerName":"down_labels","kind":13,"name":"$first","line":193},{"line":193,"kind":13,"containerName":"down_labels","name":"$last"}],"detail":"($chain,$first,$last)","definition":"sub","kind":12,"range":{"end":{"character":9999,"line":194},"start":{"line":191,"character":0}},"line":191,"signature":{"label":"down_labels($chain,$first,$last)","documentation":"1; # returns 1\n#!/usr/bin/perl\n# $Id: Chain.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::Chain\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n#\n\n=head1 NAME\n\nBio::LiveSeq::Chain - DoubleChain DataStructure for Perl\n\n=head1 SYNOPSIS\n\n  #documentation needed\n\n=head1 DESCRIPTION\n\nThis is a general purpose module (that's why it's not in object-oriented\nform) that introduces a novel datastructure in PERL. It implements\nthe \"double linked chain\". The elements of the chain can contain basically\neverything. From chars to strings, from object references to arrays or hashes.\nIt is used in the LiveSequence project to create a dynamical DNA sequence,\neasier to manipulate and change. It's use is mainly for sequence variation\nanalysis but it could be used - for example - in e-cell projects.\nThe Chain module in itself doesn't have any biological bias, so can be\nused for any programming purpose.\n\nEach element of the chain (with the exclusion of the first and the last of the\nchain) is connected to other two elements (the PREVious and the NEXT one).\nThere is no absolute position (like in an array), hence if positions are\nimportant, they need to be computed (methods are provided).\nOtherwise it's easy to keep track of the elements with their \"LABELs\".\nThere is one LABEL (think of it as a pointer) to each ELEMENT. The labels\nwon't change after insertions or deletions of the chain. So it's\nalways possible to retrieve an element even if the chain has been\nmodified by successive insertions or deletions.\nFrom this the high potential profit for bioinformatics: dealing with\nsequences in a way that doesn't have to rely on positions, without\nthe need of constantly updating them if the sequence changes, even\ndramatically.\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n# DoubleChain Data Structure for PERL\n# by Joseph A.L. Insana - Deathson - Filius Mortis - Fal Mortais\n# insana@ebi.ac.uk, jinsana@gmx.net\n\npackage Bio::LiveSeq::Chain;\n# TODO_list:\n# **** cleanup code\n# **** performance concerns\n# *??* create hash2dchain ???? (with hashkeys used for label)\n# **????** how about using array of arrays instead than hash of arrays??\n#\n# further strict complaints:\n# in verbose $string assignment around line 721 ???\n\n# TERMINOLOGY update, naming convention:\n# \"chain\" the datastructure\n# \"element\" the individual units that compose a chain\n# \"label\" the unique name of a single element\n# \"position\" the position of an element into the chain according to a\n#            particular coordinate system (e.g. counting from the start)\n# \"value\" what is stored in a single element\n\nuse Carp qw(croak cluck carp);\nuse Bio::Root::Version;\nuse strict; \nuse integer; # WARNING: this is to increase performance\n             # a little bit of attention has to be given if float need to\n             # be stored as elements of the array\n             # the use of this \"integer\" affects all operations but not\n             # assignments. So float CAN be assigned as elements of the chain\n             # BUT, if you assign $z=-1.8;, $z will be equal to -1 because\n             # \"-\" counts as a unary operation!\n\n=head2 _updown_chain2string\n\n  Title   : chain2string\n  Usage   : $string = Bio::LiveSeq::Chain::chain2string(\"down\",$chain,6,9)\n  Function: reads the contents of the chain, outputting a string\n  Returns : a string\n  Examples:\n          : down_chain2string($chain) -> all the chain from begin to end\n          : down_chain2string($chain,6) -> from 6 to the end\n          : down_chain2string($chain,6,4) -> from 6, going on 4 elements\n          : down_chain2string($chain,6,\"\",10) -> from 6 to 10\n          : up_chain2string($chain,10,\"\",6) -> from 10 to 6 upstream\n  Defaults: start=first element; if len undef, goes to last\n            if last undef, goes to end\n            if last defined, it overrides len (undefining it)\n  Error code: -1\n  Args    : \"up\"||\"down\" as first argument to specify the reading direction \n            reference (to the chain)\n            [first] [len] [last] optional integer arguments to specify how\n            much and from (and to) where to read\n\n\n# methods rewritten 2.61\nsub up_chain2string {\n  _updown_chain2string(\"up\",@_);\n}\nsub down_chain2string {\n  _updown_chain2string(\"down\",@_);\n}\n\nsub _updown_chain2string {\n  my ($direction,$chain,$first,$len,$last)=@_;\n  unless($chain) { cluck \"no chain input\"; return (-1); }\n  my $begin=$chain->{'begin'}; # the label of the BEGIN element\n  my $end=$chain->{'end'}; # the label of the END element\n  my $flow;\n\n  if ($direction eq \"up\") {\n    $flow=2; # used to determine the direction of chain navigation\n    unless ($first) { $first=$end; } # if undef or 0, use $end\n  } else { # defaults to \"down\"\n    $flow=1; # used to determine the direction of chain navigation\n    unless ($first) { $first=$begin; } # if undef or 0, use $begin\n  }\n\n  unless($chain->{$first}) {\n    cluck \"label for first not defined\"; return (-1); }\n  if ($last) { # if last is defined, it gets priority and len is not used\n    unless($chain->{$last}) {\n      cluck \"label for last not defined\"; return (-1); }\n    if ($len) {\n      warn \"Warning chain2string: argument LAST:$last overriding LEN:$len!\";\n      undef $len;\n    }\n  } else {\n    if ($direction eq \"up\") {\n      $last=$begin; # if last not defined, go 'till begin (or upto len elements)\n    } else {\n      $last=$end; # if last not defined, go 'till end (or upto len elements)\n    }\n  }\n\n  my ($string,@array);\n  my $label=$first; my $i=1;\n  my $afterlast=$chain->{$last}[$flow]; # if last=end, afterlast is undef\n  unless (defined $afterlast) { $afterlast=0; } # keep strict happy\n\n  # proceed for len elements or until last, whichever comes first\n  # if $len undef goes till end\n  while (($label) && ($label != $afterlast) && ($i <= ($len || $i + 1))) {\n    @array=@{$chain->{$label}};\n    $string .= $array[0];\n    $label = $array[$flow];\n    $i++;\n  }\n  return ($string); # if chain is interrupted $string won't be complete\n}\n\n=head2 _updown_labels\n\n Title   : labels\n Usage   : @labels = Bio::LiveSeq::Chain::_updown_labels(\"down\",$chain,4,16)\n Function: returns all the labels in a chain or those between two\n           specified ones (termed \"first\" and \"last\")\n Returns : a reference to an array containing the labels\n Args    : \"up\"||\"down\" as first argument to specify the reading direction \n           reference (to the chain)\n           [first] [last] (integer for the starting and eneding labels)\n\n arguments: CHAIN_REF [FIRSTLABEL] [LASTLABEL]\n returns: reference to array containing the labels","parameters":[{"label":"$chain"},{"label":"$first"},{"label":"$last"}]}},{"line":193,"name":"_updown_labels","kind":12},{"range":{"start":{"line":195,"character":0},"end":{"line":198,"character":9999}},"kind":12,"line":195,"signature":{"parameters":[{"label":"$chain"},{"label":"$first"},{"label":"$last"}],"documentation":"","label":"up_labels($chain,$first,$last)"},"containerName":"main::","name":"up_labels","children":[{"definition":"my","name":"$chain","containerName":"up_labels","localvar":"my","kind":13,"line":196},{"kind":13,"containerName":"up_labels","name":"$first","line":196},{"kind":13,"containerName":"up_labels","name":"$last","line":196},{"kind":13,"containerName":"up_labels","name":"$chain","line":197},{"line":197,"containerName":"up_labels","kind":13,"name":"$first"},{"line":197,"kind":13,"containerName":"up_labels","name":"$last"}],"detail":"($chain,$first,$last)","definition":"sub"},{"line":197,"kind":12,"name":"_updown_labels"},{"children":[{"line":202,"containerName":"_updown_labels","localvar":"my","kind":13,"name":"$direction","definition":"my"},{"line":202,"kind":13,"containerName":"_updown_labels","name":"$chain"},{"kind":13,"containerName":"_updown_labels","name":"$first","line":202},{"name":"$last","containerName":"_updown_labels","kind":13,"line":202},{"name":"$chain","kind":13,"containerName":"_updown_labels","line":203},{"containerName":"_updown_labels","localvar":"my","kind":13,"name":"$begin","line":204,"definition":"my"},{"kind":13,"containerName":"_updown_labels","name":"$chain","line":204},{"name":"$end","localvar":"my","containerName":"_updown_labels","kind":13,"line":205,"definition":"my"},{"line":205,"name":"$chain","kind":13,"containerName":"_updown_labels"},{"name":"$flow","kind":13,"localvar":"my","containerName":"_updown_labels","line":206,"definition":"my"},{"containerName":"_updown_labels","kind":13,"name":"$direction","line":207},{"kind":13,"containerName":"_updown_labels","name":"$flow","line":207},{"name":"$first","kind":13,"containerName":"_updown_labels","line":208},{"name":"$first","kind":13,"containerName":"_updown_labels","line":208},{"name":"$end","containerName":"_updown_labels","kind":13,"line":208},{"line":209,"containerName":"_updown_labels","kind":13,"name":"$last"},{"line":209,"containerName":"_updown_labels","kind":13,"name":"$last"},{"name":"$begin","kind":13,"containerName":"_updown_labels","line":209},{"line":210,"kind":13,"containerName":"_updown_labels","name":"$flow"},{"line":211,"name":"$last","containerName":"_updown_labels","kind":13},{"line":211,"kind":13,"containerName":"_updown_labels","name":"$last"},{"name":"$end","kind":13,"containerName":"_updown_labels","line":211},{"line":212,"name":"$first","kind":13,"containerName":"_updown_labels"},{"name":"$first","containerName":"_updown_labels","kind":13,"line":212},{"line":212,"name":"$begin","kind":13,"containerName":"_updown_labels"},{"containerName":"_updown_labels","kind":13,"name":"$chain","line":214},{"kind":13,"containerName":"_updown_labels","name":"$first","line":214},{"line":215,"name":"$chain","kind":13,"containerName":"_updown_labels"},{"line":215,"kind":13,"containerName":"_updown_labels","name":"$last"},{"kind":13,"localvar":"my","containerName":"_updown_labels","name":"$label","line":217,"definition":"my"},{"line":217,"name":"$first","containerName":"_updown_labels","kind":13},{"definition":"my","line":217,"name":"@labels","localvar":"my","kind":13,"containerName":"_updown_labels"},{"definition":"my","kind":13,"localvar":"my","containerName":"_updown_labels","name":"$afterlast","line":218},{"name":"$chain","containerName":"_updown_labels","kind":13,"line":218},{"name":"$last","containerName":"_updown_labels","kind":13,"line":218},{"line":218,"name":"$flow","containerName":"_updown_labels","kind":13},{"line":219,"kind":13,"containerName":"_updown_labels","name":"$afterlast"},{"name":"$afterlast","kind":13,"containerName":"_updown_labels","line":219},{"kind":13,"containerName":"_updown_labels","name":"$label","line":221},{"name":"$label","containerName":"_updown_labels","kind":13,"line":221},{"kind":13,"containerName":"_updown_labels","name":"$afterlast","line":221},{"line":222,"name":"@labels","kind":13,"containerName":"_updown_labels"},{"line":222,"name":"$label","containerName":"_updown_labels","kind":13},{"line":223,"name":"$label","kind":13,"containerName":"_updown_labels"},{"containerName":"_updown_labels","kind":13,"name":"$chain","line":223},{"line":223,"name":"$label","containerName":"_updown_labels","kind":13},{"line":223,"kind":13,"containerName":"_updown_labels","name":"$flow"},{"line":225,"containerName":"_updown_labels","kind":13,"name":"@labels"}],"containerName":"main::","name":"_updown_labels","definition":"sub","detail":"($direction,$chain,$first,$last)","line":201,"kind":12,"range":{"start":{"line":201,"character":0},"end":{"character":9999,"line":226}},"signature":{"documentation":" arguments: \"up\"||\"down\" CHAIN_REF [FIRSTLABEL] [LASTLABEL]\n returns: reference to array containing the labels","parameters":[{"label":"$direction"},{"label":"$chain"},{"label":"$first"},{"label":"$last"}],"label":"_updown_labels($direction,$chain,$first,$last)"}},{"line":203,"name":"cluck","kind":12},{"line":239,"range":{"end":{"character":9999,"line":243},"start":{"line":239,"character":0}},"kind":12,"definition":"sub","children":[{"name":"$chain","containerName":"start","localvar":"my","kind":13,"line":240,"definition":"my"},{"line":241,"kind":13,"containerName":"start","name":"$chain"},{"name":"$chain","containerName":"start","kind":13,"line":242}],"name":"start","containerName":"main::"},{"kind":12,"name":"cluck","line":241},{"definition":"sub","children":[{"definition":"my","line":256,"name":"$chain","containerName":"end","localvar":"my","kind":13},{"line":257,"name":"$chain","kind":13,"containerName":"end"},{"name":"$chain","kind":13,"containerName":"end","line":258}],"name":"end","containerName":"main::","line":255,"range":{"end":{"line":259,"character":9999},"start":{"line":255,"character":0}},"kind":12},{"name":"cluck","kind":12,"line":257},{"signature":{"documentation":"1; # returns 1\n#!/usr/bin/perl\n# $Id: Chain.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::Chain\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n#\n\n=head1 NAME\n\nBio::LiveSeq::Chain - DoubleChain DataStructure for Perl\n\n=head1 SYNOPSIS\n\n  #documentation needed\n\n=head1 DESCRIPTION\n\nThis is a general purpose module (that's why it's not in object-oriented\nform) that introduces a novel datastructure in PERL. It implements\nthe \"double linked chain\". The elements of the chain can contain basically\neverything. From chars to strings, from object references to arrays or hashes.\nIt is used in the LiveSequence project to create a dynamical DNA sequence,\neasier to manipulate and change. It's use is mainly for sequence variation\nanalysis but it could be used - for example - in e-cell projects.\nThe Chain module in itself doesn't have any biological bias, so can be\nused for any programming purpose.\n\nEach element of the chain (with the exclusion of the first and the last of the\nchain) is connected to other two elements (the PREVious and the NEXT one).\nThere is no absolute position (like in an array), hence if positions are\nimportant, they need to be computed (methods are provided).\nOtherwise it's easy to keep track of the elements with their \"LABELs\".\nThere is one LABEL (think of it as a pointer) to each ELEMENT. The labels\nwon't change after insertions or deletions of the chain. So it's\nalways possible to retrieve an element even if the chain has been\nmodified by successive insertions or deletions.\nFrom this the high potential profit for bioinformatics: dealing with\nsequences in a way that doesn't have to rely on positions, without\nthe need of constantly updating them if the sequence changes, even\ndramatically.\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n# DoubleChain Data Structure for PERL\n# by Joseph A.L. Insana - Deathson - Filius Mortis - Fal Mortais\n# insana@ebi.ac.uk, jinsana@gmx.net\n\npackage Bio::LiveSeq::Chain;\n# TODO_list:\n# **** cleanup code\n# **** performance concerns\n# *??* create hash2dchain ???? (with hashkeys used for label)\n# **????** how about using array of arrays instead than hash of arrays??\n#\n# further strict complaints:\n# in verbose $string assignment around line 721 ???\n\n# TERMINOLOGY update, naming convention:\n# \"chain\" the datastructure\n# \"element\" the individual units that compose a chain\n# \"label\" the unique name of a single element\n# \"position\" the position of an element into the chain according to a\n#            particular coordinate system (e.g. counting from the start)\n# \"value\" what is stored in a single element\n\nuse Carp qw(croak cluck carp);\nuse Bio::Root::Version;\nuse strict; \nuse integer; # WARNING: this is to increase performance\n             # a little bit of attention has to be given if float need to\n             # be stored as elements of the array\n             # the use of this \"integer\" affects all operations but not\n             # assignments. So float CAN be assigned as elements of the chain\n             # BUT, if you assign $z=-1.8;, $z will be equal to -1 because\n             # \"-\" counts as a unary operation!\n\n=head2 _updown_chain2string\n\n  Title   : chain2string\n  Usage   : $string = Bio::LiveSeq::Chain::chain2string(\"down\",$chain,6,9)\n  Function: reads the contents of the chain, outputting a string\n  Returns : a string\n  Examples:\n          : down_chain2string($chain) -> all the chain from begin to end\n          : down_chain2string($chain,6) -> from 6 to the end\n          : down_chain2string($chain,6,4) -> from 6, going on 4 elements\n          : down_chain2string($chain,6,\"\",10) -> from 6 to 10\n          : up_chain2string($chain,10,\"\",6) -> from 10 to 6 upstream\n  Defaults: start=first element; if len undef, goes to last\n            if last undef, goes to end\n            if last defined, it overrides len (undefining it)\n  Error code: -1\n  Args    : \"up\"||\"down\" as first argument to specify the reading direction \n            reference (to the chain)\n            [first] [len] [last] optional integer arguments to specify how\n            much and from (and to) where to read\n\n\n# methods rewritten 2.61\nsub up_chain2string {\n  _updown_chain2string(\"up\",@_);\n}\nsub down_chain2string {\n  _updown_chain2string(\"down\",@_);\n}\n\nsub _updown_chain2string {\n  my ($direction,$chain,$first,$len,$last)=@_;\n  unless($chain) { cluck \"no chain input\"; return (-1); }\n  my $begin=$chain->{'begin'}; # the label of the BEGIN element\n  my $end=$chain->{'end'}; # the label of the END element\n  my $flow;\n\n  if ($direction eq \"up\") {\n    $flow=2; # used to determine the direction of chain navigation\n    unless ($first) { $first=$end; } # if undef or 0, use $end\n  } else { # defaults to \"down\"\n    $flow=1; # used to determine the direction of chain navigation\n    unless ($first) { $first=$begin; } # if undef or 0, use $begin\n  }\n\n  unless($chain->{$first}) {\n    cluck \"label for first not defined\"; return (-1); }\n  if ($last) { # if last is defined, it gets priority and len is not used\n    unless($chain->{$last}) {\n      cluck \"label for last not defined\"; return (-1); }\n    if ($len) {\n      warn \"Warning chain2string: argument LAST:$last overriding LEN:$len!\";\n      undef $len;\n    }\n  } else {\n    if ($direction eq \"up\") {\n      $last=$begin; # if last not defined, go 'till begin (or upto len elements)\n    } else {\n      $last=$end; # if last not defined, go 'till end (or upto len elements)\n    }\n  }\n\n  my ($string,@array);\n  my $label=$first; my $i=1;\n  my $afterlast=$chain->{$last}[$flow]; # if last=end, afterlast is undef\n  unless (defined $afterlast) { $afterlast=0; } # keep strict happy\n\n  # proceed for len elements or until last, whichever comes first\n  # if $len undef goes till end\n  while (($label) && ($label != $afterlast) && ($i <= ($len || $i + 1))) {\n    @array=@{$chain->{$label}};\n    $string .= $array[0];\n    $label = $array[$flow];\n    $i++;\n  }\n  return ($string); # if chain is interrupted $string won't be complete\n}\n\n=head2 _updown_labels\n\n Title   : labels\n Usage   : @labels = Bio::LiveSeq::Chain::_updown_labels(\"down\",$chain,4,16)\n Function: returns all the labels in a chain or those between two\n           specified ones (termed \"first\" and \"last\")\n Returns : a reference to an array containing the labels\n Args    : \"up\"||\"down\" as first argument to specify the reading direction \n           reference (to the chain)\n           [first] [last] (integer for the starting and eneding labels)\n\n\n\n# arguments: CHAIN_REF [FIRSTLABEL] [LASTLABEL]\n# returns: reference to array containing the labels\nsub down_labels {\n  my ($chain,$first,$last)=@_;\n  _updown_labels(\"down\",$chain,$first,$last);\n}\nsub up_labels {\n  my ($chain,$first,$last)=@_;\n  _updown_labels(\"up\",$chain,$first,$last);\n}\n# arguments: \"up\"||\"down\" CHAIN_REF [FIRSTLABEL] [LASTLABEL]\n# returns: reference to array containing the labels\nsub _updown_labels {\n  my ($direction,$chain,$first,$last)=@_;\n  unless($chain) { cluck \"no chain input\"; return (0); }\n  my $begin=$chain->{'begin'}; # the label of the BEGIN element\n  my $end=$chain->{'end'}; # the label of the END element\n  my $flow;\n  if ($direction eq \"up\") { $flow=2;\n    unless ($first) { $first=$end; }\n    unless ($last) { $last=$begin; }\n  } else { $flow=1;\n    unless ($last) { $last=$end; }\n    unless ($first) { $first=$begin; }\n  }\n  unless($chain->{$first}) { warn \"not existing label $first\"; return (0); }\n  unless($chain->{$last}) { warn \"not existing label $last\"; return (0); }\n\n  my $label=$first; my @labels;\n  my $afterlast=$chain->{$last}[$flow]; # if last=end, afterlast is undef\n  unless (defined $afterlast) { $afterlast=0; } # keep strict happy\n\n  while (($label)&&($label != $afterlast)) {\n    push(@labels,$label);\n    $label=$chain->{$label}[$flow];\n  }\n  return (\\@labels); # if chain is interrupted @labels won't be complete\n}\n\n\n=head2 start\n\n Title   : start\n Usage   : $start = Bio::LiveSeq::Chain::start()\n Returns : the label marking the start of the chain\n Errorcode: -1\n Args    : none\n\n\nsub start {\n  my $chain=$_[0];\n  unless($chain) { cluck \"no chain input\"; return (-1); }\n  return ($chain->{'begin'});\n}\n\n=head2 end\n\n Title   : end\n Usage   : $end = Bio::LiveSeq::Chain::end()\n Returns : the label marking the end of the chain\n Errorcode: -1\n Args    : none\n\n\nsub end {\n  my $chain=$_[0];\n  unless($chain) { cluck \"no chain input\"; return (-1); }\n  return ($chain->{'end'});\n}\n\n=head2 label_exists\n\n Title   : label_exists\n Usage   : $check = Bio::LiveSeq::Chain::label_exists($chain,$label)\n Function: It checks if a label is defined, i.e. if an element is there or\n           is not there anymore\n Returns : 1 if the label exists, 0 if it is not there, -1 error\n Errorcode: -1\n Args    : reference to the chain, integer","parameters":[{"label":"$chain"},{"label":"$label"}],"label":"label_exists($chain,$label)"},"range":{"end":{"character":9999,"line":277},"start":{"character":0,"line":273}},"kind":12,"line":273,"detail":"($chain,$label)","definition":"sub","name":"label_exists","containerName":"main::","children":[{"line":274,"name":"$chain","kind":13,"localvar":"my","containerName":"label_exists","definition":"my"},{"kind":13,"containerName":"label_exists","name":"$label","line":274},{"line":275,"name":"$chain","containerName":"label_exists","kind":13},{"line":276,"containerName":"label_exists","kind":13,"name":"$label"},{"name":"$chain","containerName":"label_exists","kind":13,"line":276},{"line":276,"kind":13,"containerName":"label_exists","name":"$label"}]},{"kind":12,"name":"cluck","line":275},{"containerName":"main::","name":"down_get_pos_of_label","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"down_get_pos_of_label","name":"$chain","line":298},{"line":298,"kind":13,"containerName":"down_get_pos_of_label","name":"$label"},{"name":"$first","containerName":"down_get_pos_of_label","kind":13,"line":298},{"kind":13,"containerName":"down_get_pos_of_label","name":"$chain","line":299},{"line":299,"name":"$first","containerName":"down_get_pos_of_label","kind":13},{"kind":13,"containerName":"down_get_pos_of_label","name":"$label","line":299}],"detail":"($chain,$label,$first)","definition":"sub","kind":12,"range":{"end":{"character":9999,"line":300},"start":{"character":0,"line":296}},"line":296,"signature":{"parameters":[{"label":"$chain"},{"label":"$label"},{"label":"$first"}],"documentation":"1; # returns 1\n#!/usr/bin/perl\n# $Id: Chain.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::Chain\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n#\n\n=head1 NAME\n\nBio::LiveSeq::Chain - DoubleChain DataStructure for Perl\n\n=head1 SYNOPSIS\n\n  #documentation needed\n\n=head1 DESCRIPTION\n\nThis is a general purpose module (that's why it's not in object-oriented\nform) that introduces a novel datastructure in PERL. It implements\nthe \"double linked chain\". The elements of the chain can contain basically\neverything. From chars to strings, from object references to arrays or hashes.\nIt is used in the LiveSequence project to create a dynamical DNA sequence,\neasier to manipulate and change. It's use is mainly for sequence variation\nanalysis but it could be used - for example - in e-cell projects.\nThe Chain module in itself doesn't have any biological bias, so can be\nused for any programming purpose.\n\nEach element of the chain (with the exclusion of the first and the last of the\nchain) is connected to other two elements (the PREVious and the NEXT one).\nThere is no absolute position (like in an array), hence if positions are\nimportant, they need to be computed (methods are provided).\nOtherwise it's easy to keep track of the elements with their \"LABELs\".\nThere is one LABEL (think of it as a pointer) to each ELEMENT. The labels\nwon't change after insertions or deletions of the chain. So it's\nalways possible to retrieve an element even if the chain has been\nmodified by successive insertions or deletions.\nFrom this the high potential profit for bioinformatics: dealing with\nsequences in a way that doesn't have to rely on positions, without\nthe need of constantly updating them if the sequence changes, even\ndramatically.\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n# DoubleChain Data Structure for PERL\n# by Joseph A.L. Insana - Deathson - Filius Mortis - Fal Mortais\n# insana@ebi.ac.uk, jinsana@gmx.net\n\npackage Bio::LiveSeq::Chain;\n# TODO_list:\n# **** cleanup code\n# **** performance concerns\n# *??* create hash2dchain ???? (with hashkeys used for label)\n# **????** how about using array of arrays instead than hash of arrays??\n#\n# further strict complaints:\n# in verbose $string assignment around line 721 ???\n\n# TERMINOLOGY update, naming convention:\n# \"chain\" the datastructure\n# \"element\" the individual units that compose a chain\n# \"label\" the unique name of a single element\n# \"position\" the position of an element into the chain according to a\n#            particular coordinate system (e.g. counting from the start)\n# \"value\" what is stored in a single element\n\nuse Carp qw(croak cluck carp);\nuse Bio::Root::Version;\nuse strict; \nuse integer; # WARNING: this is to increase performance\n             # a little bit of attention has to be given if float need to\n             # be stored as elements of the array\n             # the use of this \"integer\" affects all operations but not\n             # assignments. So float CAN be assigned as elements of the chain\n             # BUT, if you assign $z=-1.8;, $z will be equal to -1 because\n             # \"-\" counts as a unary operation!\n\n=head2 _updown_chain2string\n\n  Title   : chain2string\n  Usage   : $string = Bio::LiveSeq::Chain::chain2string(\"down\",$chain,6,9)\n  Function: reads the contents of the chain, outputting a string\n  Returns : a string\n  Examples:\n          : down_chain2string($chain) -> all the chain from begin to end\n          : down_chain2string($chain,6) -> from 6 to the end\n          : down_chain2string($chain,6,4) -> from 6, going on 4 elements\n          : down_chain2string($chain,6,\"\",10) -> from 6 to 10\n          : up_chain2string($chain,10,\"\",6) -> from 10 to 6 upstream\n  Defaults: start=first element; if len undef, goes to last\n            if last undef, goes to end\n            if last defined, it overrides len (undefining it)\n  Error code: -1\n  Args    : \"up\"||\"down\" as first argument to specify the reading direction \n            reference (to the chain)\n            [first] [len] [last] optional integer arguments to specify how\n            much and from (and to) where to read\n\n\n# methods rewritten 2.61\nsub up_chain2string {\n  _updown_chain2string(\"up\",@_);\n}\nsub down_chain2string {\n  _updown_chain2string(\"down\",@_);\n}\n\nsub _updown_chain2string {\n  my ($direction,$chain,$first,$len,$last)=@_;\n  unless($chain) { cluck \"no chain input\"; return (-1); }\n  my $begin=$chain->{'begin'}; # the label of the BEGIN element\n  my $end=$chain->{'end'}; # the label of the END element\n  my $flow;\n\n  if ($direction eq \"up\") {\n    $flow=2; # used to determine the direction of chain navigation\n    unless ($first) { $first=$end; } # if undef or 0, use $end\n  } else { # defaults to \"down\"\n    $flow=1; # used to determine the direction of chain navigation\n    unless ($first) { $first=$begin; } # if undef or 0, use $begin\n  }\n\n  unless($chain->{$first}) {\n    cluck \"label for first not defined\"; return (-1); }\n  if ($last) { # if last is defined, it gets priority and len is not used\n    unless($chain->{$last}) {\n      cluck \"label for last not defined\"; return (-1); }\n    if ($len) {\n      warn \"Warning chain2string: argument LAST:$last overriding LEN:$len!\";\n      undef $len;\n    }\n  } else {\n    if ($direction eq \"up\") {\n      $last=$begin; # if last not defined, go 'till begin (or upto len elements)\n    } else {\n      $last=$end; # if last not defined, go 'till end (or upto len elements)\n    }\n  }\n\n  my ($string,@array);\n  my $label=$first; my $i=1;\n  my $afterlast=$chain->{$last}[$flow]; # if last=end, afterlast is undef\n  unless (defined $afterlast) { $afterlast=0; } # keep strict happy\n\n  # proceed for len elements or until last, whichever comes first\n  # if $len undef goes till end\n  while (($label) && ($label != $afterlast) && ($i <= ($len || $i + 1))) {\n    @array=@{$chain->{$label}};\n    $string .= $array[0];\n    $label = $array[$flow];\n    $i++;\n  }\n  return ($string); # if chain is interrupted $string won't be complete\n}\n\n=head2 _updown_labels\n\n Title   : labels\n Usage   : @labels = Bio::LiveSeq::Chain::_updown_labels(\"down\",$chain,4,16)\n Function: returns all the labels in a chain or those between two\n           specified ones (termed \"first\" and \"last\")\n Returns : a reference to an array containing the labels\n Args    : \"up\"||\"down\" as first argument to specify the reading direction \n           reference (to the chain)\n           [first] [last] (integer for the starting and eneding labels)\n\n\n\n# arguments: CHAIN_REF [FIRSTLABEL] [LASTLABEL]\n# returns: reference to array containing the labels\nsub down_labels {\n  my ($chain,$first,$last)=@_;\n  _updown_labels(\"down\",$chain,$first,$last);\n}\nsub up_labels {\n  my ($chain,$first,$last)=@_;\n  _updown_labels(\"up\",$chain,$first,$last);\n}\n# arguments: \"up\"||\"down\" CHAIN_REF [FIRSTLABEL] [LASTLABEL]\n# returns: reference to array containing the labels\nsub _updown_labels {\n  my ($direction,$chain,$first,$last)=@_;\n  unless($chain) { cluck \"no chain input\"; return (0); }\n  my $begin=$chain->{'begin'}; # the label of the BEGIN element\n  my $end=$chain->{'end'}; # the label of the END element\n  my $flow;\n  if ($direction eq \"up\") { $flow=2;\n    unless ($first) { $first=$end; }\n    unless ($last) { $last=$begin; }\n  } else { $flow=1;\n    unless ($last) { $last=$end; }\n    unless ($first) { $first=$begin; }\n  }\n  unless($chain->{$first}) { warn \"not existing label $first\"; return (0); }\n  unless($chain->{$last}) { warn \"not existing label $last\"; return (0); }\n\n  my $label=$first; my @labels;\n  my $afterlast=$chain->{$last}[$flow]; # if last=end, afterlast is undef\n  unless (defined $afterlast) { $afterlast=0; } # keep strict happy\n\n  while (($label)&&($label != $afterlast)) {\n    push(@labels,$label);\n    $label=$chain->{$label}[$flow];\n  }\n  return (\\@labels); # if chain is interrupted @labels won't be complete\n}\n\n\n=head2 start\n\n Title   : start\n Usage   : $start = Bio::LiveSeq::Chain::start()\n Returns : the label marking the start of the chain\n Errorcode: -1\n Args    : none\n\n\nsub start {\n  my $chain=$_[0];\n  unless($chain) { cluck \"no chain input\"; return (-1); }\n  return ($chain->{'begin'});\n}\n\n=head2 end\n\n Title   : end\n Usage   : $end = Bio::LiveSeq::Chain::end()\n Returns : the label marking the end of the chain\n Errorcode: -1\n Args    : none\n\n\nsub end {\n  my $chain=$_[0];\n  unless($chain) { cluck \"no chain input\"; return (-1); }\n  return ($chain->{'end'});\n}\n\n=head2 label_exists\n\n Title   : label_exists\n Usage   : $check = Bio::LiveSeq::Chain::label_exists($chain,$label)\n Function: It checks if a label is defined, i.e. if an element is there or\n           is not there anymore\n Returns : 1 if the label exists, 0 if it is not there, -1 error\n Errorcode: -1\n Args    : reference to the chain, integer\n\n\nsub label_exists {\n  my ($chain,$label)=@_;\n  unless($chain) { cluck \"no chain input\"; return (-1); }\n  if ($label && $chain->{$label}) { return (1); } else { return (0) };\n}\n\n\n=head2 down_get_pos_of_label\n\n Title   : down_get_pos_of_label\n Usage   : $position = Bio::LiveSeq::Chain::down_get_pos_of_label($chain,$label,$first)\n Function: returns the position of $label counting from $first, i.e. taking\n           $first as 1 of coordinate system. If $first is not specified it will\n           count from the start of the chain.\n Returns : \n Errorcode: 0\n Args    : reference to the chain, integer (the label of interest)\n           optional: integer (a different label that will be taken as the\n           first one, i.e. the one to count from)\n Note:     It counts \"downstream\". To proceed backward use up_get_pos_of_label","label":"down_get_pos_of_label($chain,$label,$first)"}},{"line":299,"kind":12,"name":"_updown_count"},{"name":"up_get_pos_of_label","containerName":"main::","children":[{"localvar":"my","kind":13,"containerName":"up_get_pos_of_label","name":"$chain","line":303,"definition":"my"},{"containerName":"up_get_pos_of_label","kind":13,"name":"$label","line":303},{"containerName":"up_get_pos_of_label","kind":13,"name":"$first","line":303},{"kind":13,"containerName":"up_get_pos_of_label","name":"$chain","line":304},{"line":304,"kind":13,"containerName":"up_get_pos_of_label","name":"$first"},{"containerName":"up_get_pos_of_label","kind":13,"name":"$label","line":304}],"detail":"($chain,$label,$first)","definition":"sub","kind":12,"range":{"start":{"character":0,"line":301},"end":{"line":305,"character":9999}},"line":301,"signature":{"documentation":"","parameters":[{"label":"$chain"},{"label":"$label"},{"label":"$first"}],"label":"up_get_pos_of_label($chain,$label,$first)"}},{"kind":12,"name":"_updown_count","line":304},{"children":[{"definition":"my","line":323,"localvar":"my","containerName":"down_subchain_length","kind":13,"name":"$chain"},{"line":323,"containerName":"down_subchain_length","kind":13,"name":"$first"},{"name":"$last","containerName":"down_subchain_length","kind":13,"line":323},{"line":324,"name":"$chain","containerName":"down_subchain_length","kind":13},{"containerName":"down_subchain_length","kind":13,"name":"$first","line":324},{"line":324,"name":"$last","kind":13,"containerName":"down_subchain_length"}],"containerName":"main::","name":"down_subchain_length","definition":"sub","detail":"($chain,$first,$last)","line":321,"kind":12,"range":{"end":{"line":325,"character":9999},"start":{"line":321,"character":0}},"signature":{"label":"down_subchain_length($chain,$first,$last)","parameters":[{"label":"$chain"},{"label":"$first"},{"label":"$last"}],"documentation":"1; # returns 1\n#!/usr/bin/perl\n# $Id: Chain.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::Chain\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n#\n\n=head1 NAME\n\nBio::LiveSeq::Chain - DoubleChain DataStructure for Perl\n\n=head1 SYNOPSIS\n\n  #documentation needed\n\n=head1 DESCRIPTION\n\nThis is a general purpose module (that's why it's not in object-oriented\nform) that introduces a novel datastructure in PERL. It implements\nthe \"double linked chain\". The elements of the chain can contain basically\neverything. From chars to strings, from object references to arrays or hashes.\nIt is used in the LiveSequence project to create a dynamical DNA sequence,\neasier to manipulate and change. It's use is mainly for sequence variation\nanalysis but it could be used - for example - in e-cell projects.\nThe Chain module in itself doesn't have any biological bias, so can be\nused for any programming purpose.\n\nEach element of the chain (with the exclusion of the first and the last of the\nchain) is connected to other two elements (the PREVious and the NEXT one).\nThere is no absolute position (like in an array), hence if positions are\nimportant, they need to be computed (methods are provided).\nOtherwise it's easy to keep track of the elements with their \"LABELs\".\nThere is one LABEL (think of it as a pointer) to each ELEMENT. The labels\nwon't change after insertions or deletions of the chain. So it's\nalways possible to retrieve an element even if the chain has been\nmodified by successive insertions or deletions.\nFrom this the high potential profit for bioinformatics: dealing with\nsequences in a way that doesn't have to rely on positions, without\nthe need of constantly updating them if the sequence changes, even\ndramatically.\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n# DoubleChain Data Structure for PERL\n# by Joseph A.L. Insana - Deathson - Filius Mortis - Fal Mortais\n# insana@ebi.ac.uk, jinsana@gmx.net\n\npackage Bio::LiveSeq::Chain;\n# TODO_list:\n# **** cleanup code\n# **** performance concerns\n# *??* create hash2dchain ???? (with hashkeys used for label)\n# **????** how about using array of arrays instead than hash of arrays??\n#\n# further strict complaints:\n# in verbose $string assignment around line 721 ???\n\n# TERMINOLOGY update, naming convention:\n# \"chain\" the datastructure\n# \"element\" the individual units that compose a chain\n# \"label\" the unique name of a single element\n# \"position\" the position of an element into the chain according to a\n#            particular coordinate system (e.g. counting from the start)\n# \"value\" what is stored in a single element\n\nuse Carp qw(croak cluck carp);\nuse Bio::Root::Version;\nuse strict; \nuse integer; # WARNING: this is to increase performance\n             # a little bit of attention has to be given if float need to\n             # be stored as elements of the array\n             # the use of this \"integer\" affects all operations but not\n             # assignments. So float CAN be assigned as elements of the chain\n             # BUT, if you assign $z=-1.8;, $z will be equal to -1 because\n             # \"-\" counts as a unary operation!\n\n=head2 _updown_chain2string\n\n  Title   : chain2string\n  Usage   : $string = Bio::LiveSeq::Chain::chain2string(\"down\",$chain,6,9)\n  Function: reads the contents of the chain, outputting a string\n  Returns : a string\n  Examples:\n          : down_chain2string($chain) -> all the chain from begin to end\n          : down_chain2string($chain,6) -> from 6 to the end\n          : down_chain2string($chain,6,4) -> from 6, going on 4 elements\n          : down_chain2string($chain,6,\"\",10) -> from 6 to 10\n          : up_chain2string($chain,10,\"\",6) -> from 10 to 6 upstream\n  Defaults: start=first element; if len undef, goes to last\n            if last undef, goes to end\n            if last defined, it overrides len (undefining it)\n  Error code: -1\n  Args    : \"up\"||\"down\" as first argument to specify the reading direction \n            reference (to the chain)\n            [first] [len] [last] optional integer arguments to specify how\n            much and from (and to) where to read\n\n\n# methods rewritten 2.61\nsub up_chain2string {\n  _updown_chain2string(\"up\",@_);\n}\nsub down_chain2string {\n  _updown_chain2string(\"down\",@_);\n}\n\nsub _updown_chain2string {\n  my ($direction,$chain,$first,$len,$last)=@_;\n  unless($chain) { cluck \"no chain input\"; return (-1); }\n  my $begin=$chain->{'begin'}; # the label of the BEGIN element\n  my $end=$chain->{'end'}; # the label of the END element\n  my $flow;\n\n  if ($direction eq \"up\") {\n    $flow=2; # used to determine the direction of chain navigation\n    unless ($first) { $first=$end; } # if undef or 0, use $end\n  } else { # defaults to \"down\"\n    $flow=1; # used to determine the direction of chain navigation\n    unless ($first) { $first=$begin; } # if undef or 0, use $begin\n  }\n\n  unless($chain->{$first}) {\n    cluck \"label for first not defined\"; return (-1); }\n  if ($last) { # if last is defined, it gets priority and len is not used\n    unless($chain->{$last}) {\n      cluck \"label for last not defined\"; return (-1); }\n    if ($len) {\n      warn \"Warning chain2string: argument LAST:$last overriding LEN:$len!\";\n      undef $len;\n    }\n  } else {\n    if ($direction eq \"up\") {\n      $last=$begin; # if last not defined, go 'till begin (or upto len elements)\n    } else {\n      $last=$end; # if last not defined, go 'till end (or upto len elements)\n    }\n  }\n\n  my ($string,@array);\n  my $label=$first; my $i=1;\n  my $afterlast=$chain->{$last}[$flow]; # if last=end, afterlast is undef\n  unless (defined $afterlast) { $afterlast=0; } # keep strict happy\n\n  # proceed for len elements or until last, whichever comes first\n  # if $len undef goes till end\n  while (($label) && ($label != $afterlast) && ($i <= ($len || $i + 1))) {\n    @array=@{$chain->{$label}};\n    $string .= $array[0];\n    $label = $array[$flow];\n    $i++;\n  }\n  return ($string); # if chain is interrupted $string won't be complete\n}\n\n=head2 _updown_labels\n\n Title   : labels\n Usage   : @labels = Bio::LiveSeq::Chain::_updown_labels(\"down\",$chain,4,16)\n Function: returns all the labels in a chain or those between two\n           specified ones (termed \"first\" and \"last\")\n Returns : a reference to an array containing the labels\n Args    : \"up\"||\"down\" as first argument to specify the reading direction \n           reference (to the chain)\n           [first] [last] (integer for the starting and eneding labels)\n\n\n\n# arguments: CHAIN_REF [FIRSTLABEL] [LASTLABEL]\n# returns: reference to array containing the labels\nsub down_labels {\n  my ($chain,$first,$last)=@_;\n  _updown_labels(\"down\",$chain,$first,$last);\n}\nsub up_labels {\n  my ($chain,$first,$last)=@_;\n  _updown_labels(\"up\",$chain,$first,$last);\n}\n# arguments: \"up\"||\"down\" CHAIN_REF [FIRSTLABEL] [LASTLABEL]\n# returns: reference to array containing the labels\nsub _updown_labels {\n  my ($direction,$chain,$first,$last)=@_;\n  unless($chain) { cluck \"no chain input\"; return (0); }\n  my $begin=$chain->{'begin'}; # the label of the BEGIN element\n  my $end=$chain->{'end'}; # the label of the END element\n  my $flow;\n  if ($direction eq \"up\") { $flow=2;\n    unless ($first) { $first=$end; }\n    unless ($last) { $last=$begin; }\n  } else { $flow=1;\n    unless ($last) { $last=$end; }\n    unless ($first) { $first=$begin; }\n  }\n  unless($chain->{$first}) { warn \"not existing label $first\"; return (0); }\n  unless($chain->{$last}) { warn \"not existing label $last\"; return (0); }\n\n  my $label=$first; my @labels;\n  my $afterlast=$chain->{$last}[$flow]; # if last=end, afterlast is undef\n  unless (defined $afterlast) { $afterlast=0; } # keep strict happy\n\n  while (($label)&&($label != $afterlast)) {\n    push(@labels,$label);\n    $label=$chain->{$label}[$flow];\n  }\n  return (\\@labels); # if chain is interrupted @labels won't be complete\n}\n\n\n=head2 start\n\n Title   : start\n Usage   : $start = Bio::LiveSeq::Chain::start()\n Returns : the label marking the start of the chain\n Errorcode: -1\n Args    : none\n\n\nsub start {\n  my $chain=$_[0];\n  unless($chain) { cluck \"no chain input\"; return (-1); }\n  return ($chain->{'begin'});\n}\n\n=head2 end\n\n Title   : end\n Usage   : $end = Bio::LiveSeq::Chain::end()\n Returns : the label marking the end of the chain\n Errorcode: -1\n Args    : none\n\n\nsub end {\n  my $chain=$_[0];\n  unless($chain) { cluck \"no chain input\"; return (-1); }\n  return ($chain->{'end'});\n}\n\n=head2 label_exists\n\n Title   : label_exists\n Usage   : $check = Bio::LiveSeq::Chain::label_exists($chain,$label)\n Function: It checks if a label is defined, i.e. if an element is there or\n           is not there anymore\n Returns : 1 if the label exists, 0 if it is not there, -1 error\n Errorcode: -1\n Args    : reference to the chain, integer\n\n\nsub label_exists {\n  my ($chain,$label)=@_;\n  unless($chain) { cluck \"no chain input\"; return (-1); }\n  if ($label && $chain->{$label}) { return (1); } else { return (0) };\n}\n\n\n=head2 down_get_pos_of_label\n\n Title   : down_get_pos_of_label\n Usage   : $position = Bio::LiveSeq::Chain::down_get_pos_of_label($chain,$label,$first)\n Function: returns the position of $label counting from $first, i.e. taking\n           $first as 1 of coordinate system. If $first is not specified it will\n           count from the start of the chain.\n Returns : \n Errorcode: 0\n Args    : reference to the chain, integer (the label of interest)\n           optional: integer (a different label that will be taken as the\n           first one, i.e. the one to count from)\n Note:     It counts \"downstream\". To proceed backward use up_get_pos_of_label\n\n\nsub down_get_pos_of_label {\n  #down_chain2string($_[0],$_[2],undef,$_[1],\"counting\");\n  my ($chain,$label,$first)=@_;\n  _updown_count(\"down\",$chain,$first,$label);\n}\nsub up_get_pos_of_label {\n  #up_chain2string($_[0],$_[2],undef,$_[1],\"counting\");\n  my ($chain,$label,$first)=@_;\n  _updown_count(\"up\",$chain,$first,$label);\n}\n\n=head2 down_subchain_length\n\n Title   : down_subchain_length\n Usage   : $length = Bio::LiveSeq::Chain::down_subchain_length($chain,$first,$last)\n Function: returns the length of the chain between the labels \"first\" and \"last\", included\n Returns : integer\n Errorcode: 0\n Args    : reference to the chain, integer, integer\n Note:     It counts \"downstream\". To proceed backward use up_subchain_length\n\n arguments: chain_ref [first] [last]\n returns the length of the chain between first and last (included)"}},{"name":"_updown_count","kind":12,"line":324},{"line":326,"range":{"start":{"character":0,"line":326},"end":{"character":9999,"line":330}},"kind":12,"signature":{"parameters":[{"label":"$chain"},{"label":"$first"},{"label":"$last"}],"documentation":"","label":"up_subchain_length($chain,$first,$last)"},"children":[{"line":328,"name":"$chain","containerName":"up_subchain_length","localvar":"my","kind":13,"definition":"my"},{"kind":13,"containerName":"up_subchain_length","name":"$first","line":328},{"line":328,"name":"$last","containerName":"up_subchain_length","kind":13},{"line":329,"name":"$chain","kind":13,"containerName":"up_subchain_length"},{"line":329,"name":"$first","kind":13,"containerName":"up_subchain_length"},{"kind":13,"containerName":"up_subchain_length","name":"$last","line":329}],"name":"up_subchain_length","containerName":"main::","definition":"sub","detail":"($chain,$first,$last)"},{"kind":12,"name":"_updown_count","line":329},{"line":334,"kind":12,"range":{"start":{"line":334,"character":0},"end":{"line":359,"character":9999}},"signature":{"parameters":[{"label":"$direction"},{"label":"$chain"},{"label":"$first"},{"label":"$last"}],"documentation":" arguments: DIRECTION CHAIN_REF FIRSTLABEL LASTLABEL\n errorcode 0","label":"_updown_count($direction,$chain,$first,$last)"},"children":[{"line":335,"name":"$direction","containerName":"_updown_count","localvar":"my","kind":13,"definition":"my"},{"name":"$chain","kind":13,"containerName":"_updown_count","line":335},{"line":335,"kind":13,"containerName":"_updown_count","name":"$first"},{"line":335,"name":"$last","kind":13,"containerName":"_updown_count"},{"name":"$chain","containerName":"_updown_count","kind":13,"line":336},{"kind":13,"localvar":"my","containerName":"_updown_count","name":"$begin","line":337,"definition":"my"},{"containerName":"_updown_count","kind":13,"name":"$chain","line":337},{"name":"$end","localvar":"my","kind":13,"containerName":"_updown_count","line":338,"definition":"my"},{"containerName":"_updown_count","kind":13,"name":"$chain","line":338},{"line":339,"name":"$flow","localvar":"my","kind":13,"containerName":"_updown_count","definition":"my"},{"name":"$direction","containerName":"_updown_count","kind":13,"line":340},{"line":340,"name":"$flow","kind":13,"containerName":"_updown_count"},{"kind":13,"containerName":"_updown_count","name":"$first","line":341},{"line":341,"name":"$first","containerName":"_updown_count","kind":13},{"line":341,"kind":13,"containerName":"_updown_count","name":"$end"},{"name":"$last","containerName":"_updown_count","kind":13,"line":342},{"line":342,"name":"$last","kind":13,"containerName":"_updown_count"},{"line":342,"name":"$begin","kind":13,"containerName":"_updown_count"},{"name":"$flow","containerName":"_updown_count","kind":13,"line":343},{"line":344,"kind":13,"containerName":"_updown_count","name":"$last"},{"containerName":"_updown_count","kind":13,"name":"$last","line":344},{"containerName":"_updown_count","kind":13,"name":"$end","line":344},{"name":"$first","kind":13,"containerName":"_updown_count","line":345},{"line":345,"name":"$first","containerName":"_updown_count","kind":13},{"kind":13,"containerName":"_updown_count","name":"$begin","line":345},{"line":347,"name":"$chain","kind":13,"containerName":"_updown_count"},{"line":347,"containerName":"_updown_count","kind":13,"name":"$first"},{"name":"$chain","kind":13,"containerName":"_updown_count","line":348},{"name":"$last","containerName":"_updown_count","kind":13,"line":348},{"definition":"my","line":350,"localvar":"my","containerName":"_updown_count","kind":13,"name":"$label"},{"line":350,"name":"$first","kind":13,"containerName":"_updown_count"},{"line":350,"name":"$count","kind":13,"localvar":"my","containerName":"_updown_count","definition":"my"},{"name":"$afterlast","kind":13,"localvar":"my","containerName":"_updown_count","line":351,"definition":"my"},{"name":"$chain","kind":13,"containerName":"_updown_count","line":351},{"kind":13,"containerName":"_updown_count","name":"$last","line":351},{"kind":13,"containerName":"_updown_count","name":"$flow","line":351},{"name":"$afterlast","containerName":"_updown_count","kind":13,"line":352},{"kind":13,"containerName":"_updown_count","name":"$afterlast","line":352},{"name":"$label","kind":13,"containerName":"_updown_count","line":354},{"line":354,"kind":13,"containerName":"_updown_count","name":"$label"},{"line":354,"kind":13,"containerName":"_updown_count","name":"$afterlast"},{"kind":13,"containerName":"_updown_count","name":"$count","line":355},{"line":356,"kind":13,"containerName":"_updown_count","name":"$label"},{"containerName":"_updown_count","kind":13,"name":"$chain","line":356},{"containerName":"_updown_count","kind":13,"name":"$label","line":356},{"line":356,"kind":13,"containerName":"_updown_count","name":"$flow"},{"containerName":"_updown_count","kind":13,"name":"$count","line":358}],"name":"_updown_count","containerName":"main::","definition":"sub","detail":"($direction,$chain,$first,$last)"},{"line":336,"name":"cluck","kind":12},{"range":{"start":{"character":0,"line":372},"end":{"character":9999,"line":383}},"kind":12,"line":372,"definition":"sub","containerName":"main::","name":"invert_chain","children":[{"line":373,"kind":13,"localvar":"my","containerName":"invert_chain","name":"$chain","definition":"my"},{"line":374,"kind":13,"containerName":"invert_chain","name":"$chain"},{"definition":"my","line":375,"localvar":"my","containerName":"invert_chain","kind":13,"name":"$begin"},{"line":375,"containerName":"invert_chain","kind":13,"name":"$chain"},{"line":376,"name":"$end","kind":13,"localvar":"my","containerName":"invert_chain","definition":"my"},{"line":376,"name":"$chain","containerName":"invert_chain","kind":13},{"containerName":"invert_chain","localvar":"my","kind":13,"name":"$label","line":377,"definition":"my"},{"containerName":"invert_chain","kind":13,"name":"@array","line":377},{"line":378,"name":"$label","containerName":"invert_chain","kind":13},{"containerName":"invert_chain","kind":13,"name":"$begin","line":378},{"line":379,"kind":13,"containerName":"invert_chain","name":"$label"},{"line":380,"name":"@array","kind":13,"containerName":"invert_chain"},{"line":380,"name":"$chain","containerName":"invert_chain","kind":13},{"line":380,"kind":13,"containerName":"invert_chain","name":"$label"},{"containerName":"invert_chain","kind":13,"name":"$chain","line":381},{"line":381,"containerName":"invert_chain","kind":13,"name":"$label"},{"line":381,"kind":13,"containerName":"invert_chain","name":"$chain"},{"line":381,"name":"$label","containerName":"invert_chain","kind":13},{"line":381,"name":"$array","containerName":"invert_chain","kind":13},{"line":381,"kind":13,"containerName":"invert_chain","name":"$array"},{"line":382,"kind":13,"containerName":"invert_chain","name":"$label"},{"name":"$array","containerName":"invert_chain","kind":13,"line":382}]},{"kind":12,"name":"cluck","line":374},{"line":385,"name":"%chain","kind":13,"containerName":null},{"name":"%chain","containerName":null,"kind":13,"line":385},{"line":385,"name":"$end","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"$begin","line":385},{"signature":{"label":"down_get_value_at_pos($chain,$position,$first)","parameters":[{"label":"$chain"},{"label":"$position"},{"label":"$first"}],"documentation":"1; # returns 1\n#!/usr/bin/perl\n# $Id: Chain.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::Chain\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n#\n\n=head1 NAME\n\nBio::LiveSeq::Chain - DoubleChain DataStructure for Perl\n\n=head1 SYNOPSIS\n\n  #documentation needed\n\n=head1 DESCRIPTION\n\nThis is a general purpose module (that's why it's not in object-oriented\nform) that introduces a novel datastructure in PERL. It implements\nthe \"double linked chain\". The elements of the chain can contain basically\neverything. From chars to strings, from object references to arrays or hashes.\nIt is used in the LiveSequence project to create a dynamical DNA sequence,\neasier to manipulate and change. It's use is mainly for sequence variation\nanalysis but it could be used - for example - in e-cell projects.\nThe Chain module in itself doesn't have any biological bias, so can be\nused for any programming purpose.\n\nEach element of the chain (with the exclusion of the first and the last of the\nchain) is connected to other two elements (the PREVious and the NEXT one).\nThere is no absolute position (like in an array), hence if positions are\nimportant, they need to be computed (methods are provided).\nOtherwise it's easy to keep track of the elements with their \"LABELs\".\nThere is one LABEL (think of it as a pointer) to each ELEMENT. The labels\nwon't change after insertions or deletions of the chain. So it's\nalways possible to retrieve an element even if the chain has been\nmodified by successive insertions or deletions.\nFrom this the high potential profit for bioinformatics: dealing with\nsequences in a way that doesn't have to rely on positions, without\nthe need of constantly updating them if the sequence changes, even\ndramatically.\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n# DoubleChain Data Structure for PERL\n# by Joseph A.L. Insana - Deathson - Filius Mortis - Fal Mortais\n# insana@ebi.ac.uk, jinsana@gmx.net\n\npackage Bio::LiveSeq::Chain;\n# TODO_list:\n# **** cleanup code\n# **** performance concerns\n# *??* create hash2dchain ???? (with hashkeys used for label)\n# **????** how about using array of arrays instead than hash of arrays??\n#\n# further strict complaints:\n# in verbose $string assignment around line 721 ???\n\n# TERMINOLOGY update, naming convention:\n# \"chain\" the datastructure\n# \"element\" the individual units that compose a chain\n# \"label\" the unique name of a single element\n# \"position\" the position of an element into the chain according to a\n#            particular coordinate system (e.g. counting from the start)\n# \"value\" what is stored in a single element\n\nuse Carp qw(croak cluck carp);\nuse Bio::Root::Version;\nuse strict; \nuse integer; # WARNING: this is to increase performance\n             # a little bit of attention has to be given if float need to\n             # be stored as elements of the array\n             # the use of this \"integer\" affects all operations but not\n             # assignments. So float CAN be assigned as elements of the chain\n             # BUT, if you assign $z=-1.8;, $z will be equal to -1 because\n             # \"-\" counts as a unary operation!\n\n=head2 _updown_chain2string\n\n  Title   : chain2string\n  Usage   : $string = Bio::LiveSeq::Chain::chain2string(\"down\",$chain,6,9)\n  Function: reads the contents of the chain, outputting a string\n  Returns : a string\n  Examples:\n          : down_chain2string($chain) -> all the chain from begin to end\n          : down_chain2string($chain,6) -> from 6 to the end\n          : down_chain2string($chain,6,4) -> from 6, going on 4 elements\n          : down_chain2string($chain,6,\"\",10) -> from 6 to 10\n          : up_chain2string($chain,10,\"\",6) -> from 10 to 6 upstream\n  Defaults: start=first element; if len undef, goes to last\n            if last undef, goes to end\n            if last defined, it overrides len (undefining it)\n  Error code: -1\n  Args    : \"up\"||\"down\" as first argument to specify the reading direction \n            reference (to the chain)\n            [first] [len] [last] optional integer arguments to specify how\n            much and from (and to) where to read\n\n\n# methods rewritten 2.61\nsub up_chain2string {\n  _updown_chain2string(\"up\",@_);\n}\nsub down_chain2string {\n  _updown_chain2string(\"down\",@_);\n}\n\nsub _updown_chain2string {\n  my ($direction,$chain,$first,$len,$last)=@_;\n  unless($chain) { cluck \"no chain input\"; return (-1); }\n  my $begin=$chain->{'begin'}; # the label of the BEGIN element\n  my $end=$chain->{'end'}; # the label of the END element\n  my $flow;\n\n  if ($direction eq \"up\") {\n    $flow=2; # used to determine the direction of chain navigation\n    unless ($first) { $first=$end; } # if undef or 0, use $end\n  } else { # defaults to \"down\"\n    $flow=1; # used to determine the direction of chain navigation\n    unless ($first) { $first=$begin; } # if undef or 0, use $begin\n  }\n\n  unless($chain->{$first}) {\n    cluck \"label for first not defined\"; return (-1); }\n  if ($last) { # if last is defined, it gets priority and len is not used\n    unless($chain->{$last}) {\n      cluck \"label for last not defined\"; return (-1); }\n    if ($len) {\n      warn \"Warning chain2string: argument LAST:$last overriding LEN:$len!\";\n      undef $len;\n    }\n  } else {\n    if ($direction eq \"up\") {\n      $last=$begin; # if last not defined, go 'till begin (or upto len elements)\n    } else {\n      $last=$end; # if last not defined, go 'till end (or upto len elements)\n    }\n  }\n\n  my ($string,@array);\n  my $label=$first; my $i=1;\n  my $afterlast=$chain->{$last}[$flow]; # if last=end, afterlast is undef\n  unless (defined $afterlast) { $afterlast=0; } # keep strict happy\n\n  # proceed for len elements or until last, whichever comes first\n  # if $len undef goes till end\n  while (($label) && ($label != $afterlast) && ($i <= ($len || $i + 1))) {\n    @array=@{$chain->{$label}};\n    $string .= $array[0];\n    $label = $array[$flow];\n    $i++;\n  }\n  return ($string); # if chain is interrupted $string won't be complete\n}\n\n=head2 _updown_labels\n\n Title   : labels\n Usage   : @labels = Bio::LiveSeq::Chain::_updown_labels(\"down\",$chain,4,16)\n Function: returns all the labels in a chain or those between two\n           specified ones (termed \"first\" and \"last\")\n Returns : a reference to an array containing the labels\n Args    : \"up\"||\"down\" as first argument to specify the reading direction \n           reference (to the chain)\n           [first] [last] (integer for the starting and eneding labels)\n\n\n\n# arguments: CHAIN_REF [FIRSTLABEL] [LASTLABEL]\n# returns: reference to array containing the labels\nsub down_labels {\n  my ($chain,$first,$last)=@_;\n  _updown_labels(\"down\",$chain,$first,$last);\n}\nsub up_labels {\n  my ($chain,$first,$last)=@_;\n  _updown_labels(\"up\",$chain,$first,$last);\n}\n# arguments: \"up\"||\"down\" CHAIN_REF [FIRSTLABEL] [LASTLABEL]\n# returns: reference to array containing the labels\nsub _updown_labels {\n  my ($direction,$chain,$first,$last)=@_;\n  unless($chain) { cluck \"no chain input\"; return (0); }\n  my $begin=$chain->{'begin'}; # the label of the BEGIN element\n  my $end=$chain->{'end'}; # the label of the END element\n  my $flow;\n  if ($direction eq \"up\") { $flow=2;\n    unless ($first) { $first=$end; }\n    unless ($last) { $last=$begin; }\n  } else { $flow=1;\n    unless ($last) { $last=$end; }\n    unless ($first) { $first=$begin; }\n  }\n  unless($chain->{$first}) { warn \"not existing label $first\"; return (0); }\n  unless($chain->{$last}) { warn \"not existing label $last\"; return (0); }\n\n  my $label=$first; my @labels;\n  my $afterlast=$chain->{$last}[$flow]; # if last=end, afterlast is undef\n  unless (defined $afterlast) { $afterlast=0; } # keep strict happy\n\n  while (($label)&&($label != $afterlast)) {\n    push(@labels,$label);\n    $label=$chain->{$label}[$flow];\n  }\n  return (\\@labels); # if chain is interrupted @labels won't be complete\n}\n\n\n=head2 start\n\n Title   : start\n Usage   : $start = Bio::LiveSeq::Chain::start()\n Returns : the label marking the start of the chain\n Errorcode: -1\n Args    : none\n\n\nsub start {\n  my $chain=$_[0];\n  unless($chain) { cluck \"no chain input\"; return (-1); }\n  return ($chain->{'begin'});\n}\n\n=head2 end\n\n Title   : end\n Usage   : $end = Bio::LiveSeq::Chain::end()\n Returns : the label marking the end of the chain\n Errorcode: -1\n Args    : none\n\n\nsub end {\n  my $chain=$_[0];\n  unless($chain) { cluck \"no chain input\"; return (-1); }\n  return ($chain->{'end'});\n}\n\n=head2 label_exists\n\n Title   : label_exists\n Usage   : $check = Bio::LiveSeq::Chain::label_exists($chain,$label)\n Function: It checks if a label is defined, i.e. if an element is there or\n           is not there anymore\n Returns : 1 if the label exists, 0 if it is not there, -1 error\n Errorcode: -1\n Args    : reference to the chain, integer\n\n\nsub label_exists {\n  my ($chain,$label)=@_;\n  unless($chain) { cluck \"no chain input\"; return (-1); }\n  if ($label && $chain->{$label}) { return (1); } else { return (0) };\n}\n\n\n=head2 down_get_pos_of_label\n\n Title   : down_get_pos_of_label\n Usage   : $position = Bio::LiveSeq::Chain::down_get_pos_of_label($chain,$label,$first)\n Function: returns the position of $label counting from $first, i.e. taking\n           $first as 1 of coordinate system. If $first is not specified it will\n           count from the start of the chain.\n Returns : \n Errorcode: 0\n Args    : reference to the chain, integer (the label of interest)\n           optional: integer (a different label that will be taken as the\n           first one, i.e. the one to count from)\n Note:     It counts \"downstream\". To proceed backward use up_get_pos_of_label\n\n\nsub down_get_pos_of_label {\n  #down_chain2string($_[0],$_[2],undef,$_[1],\"counting\");\n  my ($chain,$label,$first)=@_;\n  _updown_count(\"down\",$chain,$first,$label);\n}\nsub up_get_pos_of_label {\n  #up_chain2string($_[0],$_[2],undef,$_[1],\"counting\");\n  my ($chain,$label,$first)=@_;\n  _updown_count(\"up\",$chain,$first,$label);\n}\n\n=head2 down_subchain_length\n\n Title   : down_subchain_length\n Usage   : $length = Bio::LiveSeq::Chain::down_subchain_length($chain,$first,$last)\n Function: returns the length of the chain between the labels \"first\" and \"last\", included\n Returns : integer\n Errorcode: 0\n Args    : reference to the chain, integer, integer\n Note:     It counts \"downstream\". To proceed backward use up_subchain_length\n\n\n# arguments: chain_ref [first] [last]\n# returns the length of the chain between first and last (included)\nsub down_subchain_length {\n  #down_chain2string($_[0],$_[1],undef,$_[2],\"counting\");\n  my ($chain,$first,$last)=@_;\n  _updown_count(\"down\",$chain,$first,$last);\n}\nsub up_subchain_length {\n  #up_chain2string($_[0],$_[1],undef,$_[2],\"counting\");\n  my ($chain,$first,$last)=@_;\n  _updown_count(\"up\",$chain,$first,$last);\n}\n\n# arguments: DIRECTION CHAIN_REF FIRSTLABEL LASTLABEL\n# errorcode 0\nsub _updown_count {\n  my ($direction,$chain,$first,$last)=@_;\n  unless($chain) { cluck \"no chain input\"; return (0); }\n  my $begin=$chain->{'begin'}; # the label of the BEGIN element\n  my $end=$chain->{'end'}; # the label of the END element\n  my $flow;\n  if ($direction eq \"up\") { $flow=2;\n    unless ($first) { $first=$end; }\n    unless ($last) { $last=$begin; }\n  } else { $flow=1;\n    unless ($last) { $last=$end; }\n    unless ($first) { $first=$begin; }\n  }\n  unless($chain->{$first}) { warn \"not existing label $first\"; return (0); }\n  unless($chain->{$last}) { warn \"not existing label $last\"; return (0); }\n\n  my $label=$first; my $count;\n  my $afterlast=$chain->{$last}[$flow]; # if last=end, afterlast is undef\n  unless (defined $afterlast) { $afterlast=0; } # keep strict happy\n\n  while (($label)&&($label != $afterlast)) {\n    $count++;\n    $label=$chain->{$label}[$flow];\n  }\n  return ($count); # if chain is interrupted, $i will be up to the breaking point\n}\n\n=head2 invert_chain\n\n Title   : invert_chain\n Usage   : $errorcode=Bio::LiveSeq::Chain::invert_chain($chain)\n Function: completely inverts the order of the chain elements; begin is swapped with end and all links updated (PREV&NEXT fields swapped)\n Returns : 1 if all OK, 0 if errors\n Errorcode: 0\n Args    : reference to the chain\n\n\nsub invert_chain {\n  my $chain=$_[0];\n  unless($chain) { cluck \"no chain input\"; return (0); }\n  my $begin=$chain->{'begin'}; # the name of the first element\n  my $end=$chain->{'end'}; # the name of the last element\n  my ($label,@array);\n  $label=$begin; # starts from the beginning\n  while ($label) { # proceed with linked elements, swapping PREV and NEXT\n    @array=@{$chain->{$label}};\n    ($chain->{$label}[1],$chain->{$label}[2])=($array[2],$array[1]); # swap\n    $label = $array[1]; # go to the next one\n  }\n  # now swap begin and end fields\n  ($chain->{'begin'},$chain->{'end'})=($end,$begin);\n  return (1); # that's it\n}\n\n# warning that method has changed name\n#sub mutate_element {\n  #croak \"Warning: old method name. Please update code to 'set_value_at_label'\\n\";\n  # &set_value_at_label;\n#}\n\n=head2 down_get_value_at_pos\n\n Title   : down_get_value_at_pos\n Usage   : $value = Bio::LiveSeq::Chain::down_get_value_at_pos($chain,$position,$first)\n Function: used to access the value of the chain at a particular position instead than directly with a label pointer. It will count the position from the start of the chain or from the label $first, if $first is specified\n Returns : whatever is stored in the element of the chain\n Errorcode: 0\n Args    : reference to the chain, integer, [integer]\n Note:     It works \"downstream\". To proceed backward use up_get_value_at_pos\n\nsub get_value_at_pos {\ncroak \"Please use instead: down_get_value_at_pos\";\n#&down_get_value_at_pos;\n}"},"line":411,"kind":12,"range":{"start":{"line":411,"character":0},"end":{"line":418,"character":9999}},"definition":"sub","detail":"($chain,$position,$first)","children":[{"line":412,"containerName":"down_get_value_at_pos","localvar":"my","kind":13,"name":"$chain","definition":"my"},{"kind":13,"containerName":"down_get_value_at_pos","name":"$position","line":412},{"line":412,"name":"$first","containerName":"down_get_value_at_pos","kind":13},{"definition":"my","line":413,"name":"$label","kind":13,"localvar":"my","containerName":"down_get_value_at_pos"},{"kind":13,"containerName":"down_get_value_at_pos","name":"$chain","line":413},{"line":413,"kind":13,"containerName":"down_get_value_at_pos","name":"$position"},{"line":413,"name":"$first","kind":13,"containerName":"down_get_value_at_pos"},{"kind":13,"containerName":"down_get_value_at_pos","name":"$label","line":415},{"kind":13,"containerName":"down_get_value_at_pos","name":"$label","line":415},{"line":417,"name":"$chain","kind":13,"containerName":"down_get_value_at_pos"},{"name":"$label","containerName":"down_get_value_at_pos","kind":13,"line":417}],"name":"down_get_value_at_pos","containerName":"main::"},{"line":413,"name":"down_get_label_at_pos","kind":12},{"line":417,"kind":12,"name":"_get_value"},{"name":"up_get_value_at_pos","containerName":"main::","children":[{"definition":"my","line":420,"kind":13,"localvar":"my","containerName":"up_get_value_at_pos","name":"$chain"},{"line":420,"name":"$position","kind":13,"containerName":"up_get_value_at_pos"},{"kind":13,"containerName":"up_get_value_at_pos","name":"$first","line":420},{"line":421,"name":"$label","kind":13,"localvar":"my","containerName":"up_get_value_at_pos","definition":"my"},{"name":"$chain","containerName":"up_get_value_at_pos","kind":13,"line":421},{"kind":13,"containerName":"up_get_value_at_pos","name":"$position","line":421},{"line":421,"kind":13,"containerName":"up_get_value_at_pos","name":"$first"},{"line":423,"name":"$label","kind":13,"containerName":"up_get_value_at_pos"},{"containerName":"up_get_value_at_pos","kind":13,"name":"$label","line":423},{"line":425,"containerName":"up_get_value_at_pos","kind":13,"name":"$chain"},{"line":425,"containerName":"up_get_value_at_pos","kind":13,"name":"$label"}],"detail":"($chain,$position,$first)","definition":"sub","range":{"end":{"line":426,"character":9999},"start":{"character":0,"line":419}},"kind":12,"line":419,"signature":{"documentation":"","parameters":[{"label":"$chain"},{"label":"$position"},{"label":"$first"}],"label":"up_get_value_at_pos($chain,$position,$first)"}},{"line":421,"name":"up_get_label_at_pos","kind":12},{"line":425,"name":"_get_value","kind":12},{"signature":{"label":"down_set_value_at_pos($chain,$value,$position,$first)","documentation":"1; # returns 1\n#!/usr/bin/perl\n# $Id: Chain.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::Chain\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n#\n\n=head1 NAME\n\nBio::LiveSeq::Chain - DoubleChain DataStructure for Perl\n\n=head1 SYNOPSIS\n\n  #documentation needed\n\n=head1 DESCRIPTION\n\nThis is a general purpose module (that's why it's not in object-oriented\nform) that introduces a novel datastructure in PERL. It implements\nthe \"double linked chain\". The elements of the chain can contain basically\neverything. From chars to strings, from object references to arrays or hashes.\nIt is used in the LiveSequence project to create a dynamical DNA sequence,\neasier to manipulate and change. It's use is mainly for sequence variation\nanalysis but it could be used - for example - in e-cell projects.\nThe Chain module in itself doesn't have any biological bias, so can be\nused for any programming purpose.\n\nEach element of the chain (with the exclusion of the first and the last of the\nchain) is connected to other two elements (the PREVious and the NEXT one).\nThere is no absolute position (like in an array), hence if positions are\nimportant, they need to be computed (methods are provided).\nOtherwise it's easy to keep track of the elements with their \"LABELs\".\nThere is one LABEL (think of it as a pointer) to each ELEMENT. The labels\nwon't change after insertions or deletions of the chain. So it's\nalways possible to retrieve an element even if the chain has been\nmodified by successive insertions or deletions.\nFrom this the high potential profit for bioinformatics: dealing with\nsequences in a way that doesn't have to rely on positions, without\nthe need of constantly updating them if the sequence changes, even\ndramatically.\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n# DoubleChain Data Structure for PERL\n# by Joseph A.L. Insana - Deathson - Filius Mortis - Fal Mortais\n# insana@ebi.ac.uk, jinsana@gmx.net\n\npackage Bio::LiveSeq::Chain;\n# TODO_list:\n# **** cleanup code\n# **** performance concerns\n# *??* create hash2dchain ???? (with hashkeys used for label)\n# **????** how about using array of arrays instead than hash of arrays??\n#\n# further strict complaints:\n# in verbose $string assignment around line 721 ???\n\n# TERMINOLOGY update, naming convention:\n# \"chain\" the datastructure\n# \"element\" the individual units that compose a chain\n# \"label\" the unique name of a single element\n# \"position\" the position of an element into the chain according to a\n#            particular coordinate system (e.g. counting from the start)\n# \"value\" what is stored in a single element\n\nuse Carp qw(croak cluck carp);\nuse Bio::Root::Version;\nuse strict; \nuse integer; # WARNING: this is to increase performance\n             # a little bit of attention has to be given if float need to\n             # be stored as elements of the array\n             # the use of this \"integer\" affects all operations but not\n             # assignments. So float CAN be assigned as elements of the chain\n             # BUT, if you assign $z=-1.8;, $z will be equal to -1 because\n             # \"-\" counts as a unary operation!\n\n=head2 _updown_chain2string\n\n  Title   : chain2string\n  Usage   : $string = Bio::LiveSeq::Chain::chain2string(\"down\",$chain,6,9)\n  Function: reads the contents of the chain, outputting a string\n  Returns : a string\n  Examples:\n          : down_chain2string($chain) -> all the chain from begin to end\n          : down_chain2string($chain,6) -> from 6 to the end\n          : down_chain2string($chain,6,4) -> from 6, going on 4 elements\n          : down_chain2string($chain,6,\"\",10) -> from 6 to 10\n          : up_chain2string($chain,10,\"\",6) -> from 10 to 6 upstream\n  Defaults: start=first element; if len undef, goes to last\n            if last undef, goes to end\n            if last defined, it overrides len (undefining it)\n  Error code: -1\n  Args    : \"up\"||\"down\" as first argument to specify the reading direction \n            reference (to the chain)\n            [first] [len] [last] optional integer arguments to specify how\n            much and from (and to) where to read\n\n\n# methods rewritten 2.61\nsub up_chain2string {\n  _updown_chain2string(\"up\",@_);\n}\nsub down_chain2string {\n  _updown_chain2string(\"down\",@_);\n}\n\nsub _updown_chain2string {\n  my ($direction,$chain,$first,$len,$last)=@_;\n  unless($chain) { cluck \"no chain input\"; return (-1); }\n  my $begin=$chain->{'begin'}; # the label of the BEGIN element\n  my $end=$chain->{'end'}; # the label of the END element\n  my $flow;\n\n  if ($direction eq \"up\") {\n    $flow=2; # used to determine the direction of chain navigation\n    unless ($first) { $first=$end; } # if undef or 0, use $end\n  } else { # defaults to \"down\"\n    $flow=1; # used to determine the direction of chain navigation\n    unless ($first) { $first=$begin; } # if undef or 0, use $begin\n  }\n\n  unless($chain->{$first}) {\n    cluck \"label for first not defined\"; return (-1); }\n  if ($last) { # if last is defined, it gets priority and len is not used\n    unless($chain->{$last}) {\n      cluck \"label for last not defined\"; return (-1); }\n    if ($len) {\n      warn \"Warning chain2string: argument LAST:$last overriding LEN:$len!\";\n      undef $len;\n    }\n  } else {\n    if ($direction eq \"up\") {\n      $last=$begin; # if last not defined, go 'till begin (or upto len elements)\n    } else {\n      $last=$end; # if last not defined, go 'till end (or upto len elements)\n    }\n  }\n\n  my ($string,@array);\n  my $label=$first; my $i=1;\n  my $afterlast=$chain->{$last}[$flow]; # if last=end, afterlast is undef\n  unless (defined $afterlast) { $afterlast=0; } # keep strict happy\n\n  # proceed for len elements or until last, whichever comes first\n  # if $len undef goes till end\n  while (($label) && ($label != $afterlast) && ($i <= ($len || $i + 1))) {\n    @array=@{$chain->{$label}};\n    $string .= $array[0];\n    $label = $array[$flow];\n    $i++;\n  }\n  return ($string); # if chain is interrupted $string won't be complete\n}\n\n=head2 _updown_labels\n\n Title   : labels\n Usage   : @labels = Bio::LiveSeq::Chain::_updown_labels(\"down\",$chain,4,16)\n Function: returns all the labels in a chain or those between two\n           specified ones (termed \"first\" and \"last\")\n Returns : a reference to an array containing the labels\n Args    : \"up\"||\"down\" as first argument to specify the reading direction \n           reference (to the chain)\n           [first] [last] (integer for the starting and eneding labels)\n\n\n\n# arguments: CHAIN_REF [FIRSTLABEL] [LASTLABEL]\n# returns: reference to array containing the labels\nsub down_labels {\n  my ($chain,$first,$last)=@_;\n  _updown_labels(\"down\",$chain,$first,$last);\n}\nsub up_labels {\n  my ($chain,$first,$last)=@_;\n  _updown_labels(\"up\",$chain,$first,$last);\n}\n# arguments: \"up\"||\"down\" CHAIN_REF [FIRSTLABEL] [LASTLABEL]\n# returns: reference to array containing the labels\nsub _updown_labels {\n  my ($direction,$chain,$first,$last)=@_;\n  unless($chain) { cluck \"no chain input\"; return (0); }\n  my $begin=$chain->{'begin'}; # the label of the BEGIN element\n  my $end=$chain->{'end'}; # the label of the END element\n  my $flow;\n  if ($direction eq \"up\") { $flow=2;\n    unless ($first) { $first=$end; }\n    unless ($last) { $last=$begin; }\n  } else { $flow=1;\n    unless ($last) { $last=$end; }\n    unless ($first) { $first=$begin; }\n  }\n  unless($chain->{$first}) { warn \"not existing label $first\"; return (0); }\n  unless($chain->{$last}) { warn \"not existing label $last\"; return (0); }\n\n  my $label=$first; my @labels;\n  my $afterlast=$chain->{$last}[$flow]; # if last=end, afterlast is undef\n  unless (defined $afterlast) { $afterlast=0; } # keep strict happy\n\n  while (($label)&&($label != $afterlast)) {\n    push(@labels,$label);\n    $label=$chain->{$label}[$flow];\n  }\n  return (\\@labels); # if chain is interrupted @labels won't be complete\n}\n\n\n=head2 start\n\n Title   : start\n Usage   : $start = Bio::LiveSeq::Chain::start()\n Returns : the label marking the start of the chain\n Errorcode: -1\n Args    : none\n\n\nsub start {\n  my $chain=$_[0];\n  unless($chain) { cluck \"no chain input\"; return (-1); }\n  return ($chain->{'begin'});\n}\n\n=head2 end\n\n Title   : end\n Usage   : $end = Bio::LiveSeq::Chain::end()\n Returns : the label marking the end of the chain\n Errorcode: -1\n Args    : none\n\n\nsub end {\n  my $chain=$_[0];\n  unless($chain) { cluck \"no chain input\"; return (-1); }\n  return ($chain->{'end'});\n}\n\n=head2 label_exists\n\n Title   : label_exists\n Usage   : $check = Bio::LiveSeq::Chain::label_exists($chain,$label)\n Function: It checks if a label is defined, i.e. if an element is there or\n           is not there anymore\n Returns : 1 if the label exists, 0 if it is not there, -1 error\n Errorcode: -1\n Args    : reference to the chain, integer\n\n\nsub label_exists {\n  my ($chain,$label)=@_;\n  unless($chain) { cluck \"no chain input\"; return (-1); }\n  if ($label && $chain->{$label}) { return (1); } else { return (0) };\n}\n\n\n=head2 down_get_pos_of_label\n\n Title   : down_get_pos_of_label\n Usage   : $position = Bio::LiveSeq::Chain::down_get_pos_of_label($chain,$label,$first)\n Function: returns the position of $label counting from $first, i.e. taking\n           $first as 1 of coordinate system. If $first is not specified it will\n           count from the start of the chain.\n Returns : \n Errorcode: 0\n Args    : reference to the chain, integer (the label of interest)\n           optional: integer (a different label that will be taken as the\n           first one, i.e. the one to count from)\n Note:     It counts \"downstream\". To proceed backward use up_get_pos_of_label\n\n\nsub down_get_pos_of_label {\n  #down_chain2string($_[0],$_[2],undef,$_[1],\"counting\");\n  my ($chain,$label,$first)=@_;\n  _updown_count(\"down\",$chain,$first,$label);\n}\nsub up_get_pos_of_label {\n  #up_chain2string($_[0],$_[2],undef,$_[1],\"counting\");\n  my ($chain,$label,$first)=@_;\n  _updown_count(\"up\",$chain,$first,$label);\n}\n\n=head2 down_subchain_length\n\n Title   : down_subchain_length\n Usage   : $length = Bio::LiveSeq::Chain::down_subchain_length($chain,$first,$last)\n Function: returns the length of the chain between the labels \"first\" and \"last\", included\n Returns : integer\n Errorcode: 0\n Args    : reference to the chain, integer, integer\n Note:     It counts \"downstream\". To proceed backward use up_subchain_length\n\n\n# arguments: chain_ref [first] [last]\n# returns the length of the chain between first and last (included)\nsub down_subchain_length {\n  #down_chain2string($_[0],$_[1],undef,$_[2],\"counting\");\n  my ($chain,$first,$last)=@_;\n  _updown_count(\"down\",$chain,$first,$last);\n}\nsub up_subchain_length {\n  #up_chain2string($_[0],$_[1],undef,$_[2],\"counting\");\n  my ($chain,$first,$last)=@_;\n  _updown_count(\"up\",$chain,$first,$last);\n}\n\n# arguments: DIRECTION CHAIN_REF FIRSTLABEL LASTLABEL\n# errorcode 0\nsub _updown_count {\n  my ($direction,$chain,$first,$last)=@_;\n  unless($chain) { cluck \"no chain input\"; return (0); }\n  my $begin=$chain->{'begin'}; # the label of the BEGIN element\n  my $end=$chain->{'end'}; # the label of the END element\n  my $flow;\n  if ($direction eq \"up\") { $flow=2;\n    unless ($first) { $first=$end; }\n    unless ($last) { $last=$begin; }\n  } else { $flow=1;\n    unless ($last) { $last=$end; }\n    unless ($first) { $first=$begin; }\n  }\n  unless($chain->{$first}) { warn \"not existing label $first\"; return (0); }\n  unless($chain->{$last}) { warn \"not existing label $last\"; return (0); }\n\n  my $label=$first; my $count;\n  my $afterlast=$chain->{$last}[$flow]; # if last=end, afterlast is undef\n  unless (defined $afterlast) { $afterlast=0; } # keep strict happy\n\n  while (($label)&&($label != $afterlast)) {\n    $count++;\n    $label=$chain->{$label}[$flow];\n  }\n  return ($count); # if chain is interrupted, $i will be up to the breaking point\n}\n\n=head2 invert_chain\n\n Title   : invert_chain\n Usage   : $errorcode=Bio::LiveSeq::Chain::invert_chain($chain)\n Function: completely inverts the order of the chain elements; begin is swapped with end and all links updated (PREV&NEXT fields swapped)\n Returns : 1 if all OK, 0 if errors\n Errorcode: 0\n Args    : reference to the chain\n\n\nsub invert_chain {\n  my $chain=$_[0];\n  unless($chain) { cluck \"no chain input\"; return (0); }\n  my $begin=$chain->{'begin'}; # the name of the first element\n  my $end=$chain->{'end'}; # the name of the last element\n  my ($label,@array);\n  $label=$begin; # starts from the beginning\n  while ($label) { # proceed with linked elements, swapping PREV and NEXT\n    @array=@{$chain->{$label}};\n    ($chain->{$label}[1],$chain->{$label}[2])=($array[2],$array[1]); # swap\n    $label = $array[1]; # go to the next one\n  }\n  # now swap begin and end fields\n  ($chain->{'begin'},$chain->{'end'})=($end,$begin);\n  return (1); # that's it\n}\n\n# warning that method has changed name\n#sub mutate_element {\n  #croak \"Warning: old method name. Please update code to 'set_value_at_label'\\n\";\n  # &set_value_at_label;\n#}\n\n=head2 down_get_value_at_pos\n\n Title   : down_get_value_at_pos\n Usage   : $value = Bio::LiveSeq::Chain::down_get_value_at_pos($chain,$position,$first)\n Function: used to access the value of the chain at a particular position instead than directly with a label pointer. It will count the position from the start of the chain or from the label $first, if $first is specified\n Returns : whatever is stored in the element of the chain\n Errorcode: 0\n Args    : reference to the chain, integer, [integer]\n Note:     It works \"downstream\". To proceed backward use up_get_value_at_pos\n\n\n#sub get_value_at_pos {\n  #croak \"Please use instead: down_get_value_at_pos\";\n  ##&down_get_value_at_pos;\n#}\nsub down_get_value_at_pos {\n  my ($chain,$position,$first)=@_;\n  my $label=down_get_label_at_pos($chain,$position,$first);\n  # check place of change\n  if (($label eq -1)||($label eq 0)) { # complain if label doesn't exist\n    warn \"not existing element $label\"; return (0); }\n  return _get_value($chain,$label);\n}\nsub up_get_value_at_pos {\n  my ($chain,$position,$first)=@_;\n  my $label=up_get_label_at_pos($chain,$position,$first);\n  # check place of change\n  if (($label eq -1)||($label eq 0)) { # complain if label doesn't exist\n    warn \"not existing element $label\"; return (0); }\n  return _get_value($chain,$label);\n}\n\n=head2 down_set_value_at_pos\n\n Title   : down_set_value_at_pos\n Usage   : $errorcode = Bio::LiveSeq::Chain::down_set_value_at_pos($chain,$newvalue,$position,$first)\n Function: used to store a new value inside an element of the chain at a particular position instead than directly with a label pointer. It will count the position from the start of the chain or from the label $first, if $first is specified\n Returns : 1\n Errorcode: 0\n Args    : reference to the chain, newvalue, integer, [integer]\n           (newvalue can be: integer, string, object reference, hash ref)\n Note:     It works \"downstream\". To proceed backward use up_set_value_at_pos\n Note2:    If the $newvalue is undef, it will delete the contents of the\n           element but it won't remove the element from the chain.\n\nsub set_value_at_pos {\ncroak \"Please use instead: down_set_value_at_pos\";\n#&down_set_value_at_pos;\n}","parameters":[{"label":"$chain"},{"label":"$value"},{"label":"$position"},{"label":"$first"}]},"kind":12,"range":{"start":{"line":447,"character":0},"end":{"line":455,"character":9999}},"line":447,"detail":"($chain,$value,$position,$first)","definition":"sub","name":"down_set_value_at_pos","containerName":"main::","children":[{"name":"$chain","localvar":"my","containerName":"down_set_value_at_pos","kind":13,"line":448,"definition":"my"},{"name":"$value","containerName":"down_set_value_at_pos","kind":13,"line":448},{"containerName":"down_set_value_at_pos","kind":13,"name":"$position","line":448},{"line":448,"containerName":"down_set_value_at_pos","kind":13,"name":"$first"},{"definition":"my","localvar":"my","containerName":"down_set_value_at_pos","kind":13,"name":"$label","line":449},{"kind":13,"containerName":"down_set_value_at_pos","name":"$chain","line":449},{"kind":13,"containerName":"down_set_value_at_pos","name":"$position","line":449},{"line":449,"kind":13,"containerName":"down_set_value_at_pos","name":"$first"},{"line":451,"kind":13,"containerName":"down_set_value_at_pos","name":"$label"},{"name":"$label","containerName":"down_set_value_at_pos","kind":13,"line":451},{"line":453,"name":"$chain","kind":13,"containerName":"down_set_value_at_pos"},{"line":453,"name":"$label","kind":13,"containerName":"down_set_value_at_pos"},{"line":453,"containerName":"down_set_value_at_pos","kind":13,"name":"$value"}]},{"line":449,"name":"down_get_label_at_pos","kind":12},{"line":453,"kind":12,"name":"_set_value"},{"signature":{"parameters":[{"label":"$chain"},{"label":"$value"},{"label":"$position"},{"label":"$first"}],"documentation":"","label":"up_set_value_at_pos($chain,$value,$position,$first)"},"line":456,"range":{"end":{"character":9999,"line":464},"start":{"line":456,"character":0}},"kind":12,"definition":"sub","detail":"($chain,$value,$position,$first)","children":[{"containerName":"up_set_value_at_pos","localvar":"my","kind":13,"name":"$chain","line":457,"definition":"my"},{"line":457,"containerName":"up_set_value_at_pos","kind":13,"name":"$value"},{"line":457,"name":"$position","kind":13,"containerName":"up_set_value_at_pos"},{"line":457,"containerName":"up_set_value_at_pos","kind":13,"name":"$first"},{"definition":"my","name":"$label","containerName":"up_set_value_at_pos","localvar":"my","kind":13,"line":458},{"line":458,"name":"$chain","kind":13,"containerName":"up_set_value_at_pos"},{"containerName":"up_set_value_at_pos","kind":13,"name":"$position","line":458},{"line":458,"name":"$first","containerName":"up_set_value_at_pos","kind":13},{"kind":13,"containerName":"up_set_value_at_pos","name":"$label","line":460},{"line":460,"name":"$label","kind":13,"containerName":"up_set_value_at_pos"},{"line":462,"containerName":"up_set_value_at_pos","kind":13,"name":"$chain"},{"kind":13,"containerName":"up_set_value_at_pos","name":"$label","line":462},{"line":462,"containerName":"up_set_value_at_pos","kind":13,"name":"$value"}],"containerName":"main::","name":"up_set_value_at_pos"},{"line":458,"name":"up_get_label_at_pos","kind":12},{"name":"_set_value","kind":12,"line":462},{"kind":12,"range":{"end":{"character":9999,"line":491},"start":{"line":482,"character":0}},"line":482,"signature":{"parameters":[{"label":"$chain"},{"label":"$value"},{"label":"$label"}],"documentation":"1; # returns 1\n#!/usr/bin/perl\n# $Id: Chain.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::Chain\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n#\n\n=head1 NAME\n\nBio::LiveSeq::Chain - DoubleChain DataStructure for Perl\n\n=head1 SYNOPSIS\n\n  #documentation needed\n\n=head1 DESCRIPTION\n\nThis is a general purpose module (that's why it's not in object-oriented\nform) that introduces a novel datastructure in PERL. It implements\nthe \"double linked chain\". The elements of the chain can contain basically\neverything. From chars to strings, from object references to arrays or hashes.\nIt is used in the LiveSequence project to create a dynamical DNA sequence,\neasier to manipulate and change. It's use is mainly for sequence variation\nanalysis but it could be used - for example - in e-cell projects.\nThe Chain module in itself doesn't have any biological bias, so can be\nused for any programming purpose.\n\nEach element of the chain (with the exclusion of the first and the last of the\nchain) is connected to other two elements (the PREVious and the NEXT one).\nThere is no absolute position (like in an array), hence if positions are\nimportant, they need to be computed (methods are provided).\nOtherwise it's easy to keep track of the elements with their \"LABELs\".\nThere is one LABEL (think of it as a pointer) to each ELEMENT. The labels\nwon't change after insertions or deletions of the chain. So it's\nalways possible to retrieve an element even if the chain has been\nmodified by successive insertions or deletions.\nFrom this the high potential profit for bioinformatics: dealing with\nsequences in a way that doesn't have to rely on positions, without\nthe need of constantly updating them if the sequence changes, even\ndramatically.\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n# DoubleChain Data Structure for PERL\n# by Joseph A.L. Insana - Deathson - Filius Mortis - Fal Mortais\n# insana@ebi.ac.uk, jinsana@gmx.net\n\npackage Bio::LiveSeq::Chain;\n# TODO_list:\n# **** cleanup code\n# **** performance concerns\n# *??* create hash2dchain ???? (with hashkeys used for label)\n# **????** how about using array of arrays instead than hash of arrays??\n#\n# further strict complaints:\n# in verbose $string assignment around line 721 ???\n\n# TERMINOLOGY update, naming convention:\n# \"chain\" the datastructure\n# \"element\" the individual units that compose a chain\n# \"label\" the unique name of a single element\n# \"position\" the position of an element into the chain according to a\n#            particular coordinate system (e.g. counting from the start)\n# \"value\" what is stored in a single element\n\nuse Carp qw(croak cluck carp);\nuse Bio::Root::Version;\nuse strict; \nuse integer; # WARNING: this is to increase performance\n             # a little bit of attention has to be given if float need to\n             # be stored as elements of the array\n             # the use of this \"integer\" affects all operations but not\n             # assignments. So float CAN be assigned as elements of the chain\n             # BUT, if you assign $z=-1.8;, $z will be equal to -1 because\n             # \"-\" counts as a unary operation!\n\n=head2 _updown_chain2string\n\n  Title   : chain2string\n  Usage   : $string = Bio::LiveSeq::Chain::chain2string(\"down\",$chain,6,9)\n  Function: reads the contents of the chain, outputting a string\n  Returns : a string\n  Examples:\n          : down_chain2string($chain) -> all the chain from begin to end\n          : down_chain2string($chain,6) -> from 6 to the end\n          : down_chain2string($chain,6,4) -> from 6, going on 4 elements\n          : down_chain2string($chain,6,\"\",10) -> from 6 to 10\n          : up_chain2string($chain,10,\"\",6) -> from 10 to 6 upstream\n  Defaults: start=first element; if len undef, goes to last\n            if last undef, goes to end\n            if last defined, it overrides len (undefining it)\n  Error code: -1\n  Args    : \"up\"||\"down\" as first argument to specify the reading direction \n            reference (to the chain)\n            [first] [len] [last] optional integer arguments to specify how\n            much and from (and to) where to read\n\n\n# methods rewritten 2.61\nsub up_chain2string {\n  _updown_chain2string(\"up\",@_);\n}\nsub down_chain2string {\n  _updown_chain2string(\"down\",@_);\n}\n\nsub _updown_chain2string {\n  my ($direction,$chain,$first,$len,$last)=@_;\n  unless($chain) { cluck \"no chain input\"; return (-1); }\n  my $begin=$chain->{'begin'}; # the label of the BEGIN element\n  my $end=$chain->{'end'}; # the label of the END element\n  my $flow;\n\n  if ($direction eq \"up\") {\n    $flow=2; # used to determine the direction of chain navigation\n    unless ($first) { $first=$end; } # if undef or 0, use $end\n  } else { # defaults to \"down\"\n    $flow=1; # used to determine the direction of chain navigation\n    unless ($first) { $first=$begin; } # if undef or 0, use $begin\n  }\n\n  unless($chain->{$first}) {\n    cluck \"label for first not defined\"; return (-1); }\n  if ($last) { # if last is defined, it gets priority and len is not used\n    unless($chain->{$last}) {\n      cluck \"label for last not defined\"; return (-1); }\n    if ($len) {\n      warn \"Warning chain2string: argument LAST:$last overriding LEN:$len!\";\n      undef $len;\n    }\n  } else {\n    if ($direction eq \"up\") {\n      $last=$begin; # if last not defined, go 'till begin (or upto len elements)\n    } else {\n      $last=$end; # if last not defined, go 'till end (or upto len elements)\n    }\n  }\n\n  my ($string,@array);\n  my $label=$first; my $i=1;\n  my $afterlast=$chain->{$last}[$flow]; # if last=end, afterlast is undef\n  unless (defined $afterlast) { $afterlast=0; } # keep strict happy\n\n  # proceed for len elements or until last, whichever comes first\n  # if $len undef goes till end\n  while (($label) && ($label != $afterlast) && ($i <= ($len || $i + 1))) {\n    @array=@{$chain->{$label}};\n    $string .= $array[0];\n    $label = $array[$flow];\n    $i++;\n  }\n  return ($string); # if chain is interrupted $string won't be complete\n}\n\n=head2 _updown_labels\n\n Title   : labels\n Usage   : @labels = Bio::LiveSeq::Chain::_updown_labels(\"down\",$chain,4,16)\n Function: returns all the labels in a chain or those between two\n           specified ones (termed \"first\" and \"last\")\n Returns : a reference to an array containing the labels\n Args    : \"up\"||\"down\" as first argument to specify the reading direction \n           reference (to the chain)\n           [first] [last] (integer for the starting and eneding labels)\n\n\n\n# arguments: CHAIN_REF [FIRSTLABEL] [LASTLABEL]\n# returns: reference to array containing the labels\nsub down_labels {\n  my ($chain,$first,$last)=@_;\n  _updown_labels(\"down\",$chain,$first,$last);\n}\nsub up_labels {\n  my ($chain,$first,$last)=@_;\n  _updown_labels(\"up\",$chain,$first,$last);\n}\n# arguments: \"up\"||\"down\" CHAIN_REF [FIRSTLABEL] [LASTLABEL]\n# returns: reference to array containing the labels\nsub _updown_labels {\n  my ($direction,$chain,$first,$last)=@_;\n  unless($chain) { cluck \"no chain input\"; return (0); }\n  my $begin=$chain->{'begin'}; # the label of the BEGIN element\n  my $end=$chain->{'end'}; # the label of the END element\n  my $flow;\n  if ($direction eq \"up\") { $flow=2;\n    unless ($first) { $first=$end; }\n    unless ($last) { $last=$begin; }\n  } else { $flow=1;\n    unless ($last) { $last=$end; }\n    unless ($first) { $first=$begin; }\n  }\n  unless($chain->{$first}) { warn \"not existing label $first\"; return (0); }\n  unless($chain->{$last}) { warn \"not existing label $last\"; return (0); }\n\n  my $label=$first; my @labels;\n  my $afterlast=$chain->{$last}[$flow]; # if last=end, afterlast is undef\n  unless (defined $afterlast) { $afterlast=0; } # keep strict happy\n\n  while (($label)&&($label != $afterlast)) {\n    push(@labels,$label);\n    $label=$chain->{$label}[$flow];\n  }\n  return (\\@labels); # if chain is interrupted @labels won't be complete\n}\n\n\n=head2 start\n\n Title   : start\n Usage   : $start = Bio::LiveSeq::Chain::start()\n Returns : the label marking the start of the chain\n Errorcode: -1\n Args    : none\n\n\nsub start {\n  my $chain=$_[0];\n  unless($chain) { cluck \"no chain input\"; return (-1); }\n  return ($chain->{'begin'});\n}\n\n=head2 end\n\n Title   : end\n Usage   : $end = Bio::LiveSeq::Chain::end()\n Returns : the label marking the end of the chain\n Errorcode: -1\n Args    : none\n\n\nsub end {\n  my $chain=$_[0];\n  unless($chain) { cluck \"no chain input\"; return (-1); }\n  return ($chain->{'end'});\n}\n\n=head2 label_exists\n\n Title   : label_exists\n Usage   : $check = Bio::LiveSeq::Chain::label_exists($chain,$label)\n Function: It checks if a label is defined, i.e. if an element is there or\n           is not there anymore\n Returns : 1 if the label exists, 0 if it is not there, -1 error\n Errorcode: -1\n Args    : reference to the chain, integer\n\n\nsub label_exists {\n  my ($chain,$label)=@_;\n  unless($chain) { cluck \"no chain input\"; return (-1); }\n  if ($label && $chain->{$label}) { return (1); } else { return (0) };\n}\n\n\n=head2 down_get_pos_of_label\n\n Title   : down_get_pos_of_label\n Usage   : $position = Bio::LiveSeq::Chain::down_get_pos_of_label($chain,$label,$first)\n Function: returns the position of $label counting from $first, i.e. taking\n           $first as 1 of coordinate system. If $first is not specified it will\n           count from the start of the chain.\n Returns : \n Errorcode: 0\n Args    : reference to the chain, integer (the label of interest)\n           optional: integer (a different label that will be taken as the\n           first one, i.e. the one to count from)\n Note:     It counts \"downstream\". To proceed backward use up_get_pos_of_label\n\n\nsub down_get_pos_of_label {\n  #down_chain2string($_[0],$_[2],undef,$_[1],\"counting\");\n  my ($chain,$label,$first)=@_;\n  _updown_count(\"down\",$chain,$first,$label);\n}\nsub up_get_pos_of_label {\n  #up_chain2string($_[0],$_[2],undef,$_[1],\"counting\");\n  my ($chain,$label,$first)=@_;\n  _updown_count(\"up\",$chain,$first,$label);\n}\n\n=head2 down_subchain_length\n\n Title   : down_subchain_length\n Usage   : $length = Bio::LiveSeq::Chain::down_subchain_length($chain,$first,$last)\n Function: returns the length of the chain between the labels \"first\" and \"last\", included\n Returns : integer\n Errorcode: 0\n Args    : reference to the chain, integer, integer\n Note:     It counts \"downstream\". To proceed backward use up_subchain_length\n\n\n# arguments: chain_ref [first] [last]\n# returns the length of the chain between first and last (included)\nsub down_subchain_length {\n  #down_chain2string($_[0],$_[1],undef,$_[2],\"counting\");\n  my ($chain,$first,$last)=@_;\n  _updown_count(\"down\",$chain,$first,$last);\n}\nsub up_subchain_length {\n  #up_chain2string($_[0],$_[1],undef,$_[2],\"counting\");\n  my ($chain,$first,$last)=@_;\n  _updown_count(\"up\",$chain,$first,$last);\n}\n\n# arguments: DIRECTION CHAIN_REF FIRSTLABEL LASTLABEL\n# errorcode 0\nsub _updown_count {\n  my ($direction,$chain,$first,$last)=@_;\n  unless($chain) { cluck \"no chain input\"; return (0); }\n  my $begin=$chain->{'begin'}; # the label of the BEGIN element\n  my $end=$chain->{'end'}; # the label of the END element\n  my $flow;\n  if ($direction eq \"up\") { $flow=2;\n    unless ($first) { $first=$end; }\n    unless ($last) { $last=$begin; }\n  } else { $flow=1;\n    unless ($last) { $last=$end; }\n    unless ($first) { $first=$begin; }\n  }\n  unless($chain->{$first}) { warn \"not existing label $first\"; return (0); }\n  unless($chain->{$last}) { warn \"not existing label $last\"; return (0); }\n\n  my $label=$first; my $count;\n  my $afterlast=$chain->{$last}[$flow]; # if last=end, afterlast is undef\n  unless (defined $afterlast) { $afterlast=0; } # keep strict happy\n\n  while (($label)&&($label != $afterlast)) {\n    $count++;\n    $label=$chain->{$label}[$flow];\n  }\n  return ($count); # if chain is interrupted, $i will be up to the breaking point\n}\n\n=head2 invert_chain\n\n Title   : invert_chain\n Usage   : $errorcode=Bio::LiveSeq::Chain::invert_chain($chain)\n Function: completely inverts the order of the chain elements; begin is swapped with end and all links updated (PREV&NEXT fields swapped)\n Returns : 1 if all OK, 0 if errors\n Errorcode: 0\n Args    : reference to the chain\n\n\nsub invert_chain {\n  my $chain=$_[0];\n  unless($chain) { cluck \"no chain input\"; return (0); }\n  my $begin=$chain->{'begin'}; # the name of the first element\n  my $end=$chain->{'end'}; # the name of the last element\n  my ($label,@array);\n  $label=$begin; # starts from the beginning\n  while ($label) { # proceed with linked elements, swapping PREV and NEXT\n    @array=@{$chain->{$label}};\n    ($chain->{$label}[1],$chain->{$label}[2])=($array[2],$array[1]); # swap\n    $label = $array[1]; # go to the next one\n  }\n  # now swap begin and end fields\n  ($chain->{'begin'},$chain->{'end'})=($end,$begin);\n  return (1); # that's it\n}\n\n# warning that method has changed name\n#sub mutate_element {\n  #croak \"Warning: old method name. Please update code to 'set_value_at_label'\\n\";\n  # &set_value_at_label;\n#}\n\n=head2 down_get_value_at_pos\n\n Title   : down_get_value_at_pos\n Usage   : $value = Bio::LiveSeq::Chain::down_get_value_at_pos($chain,$position,$first)\n Function: used to access the value of the chain at a particular position instead than directly with a label pointer. It will count the position from the start of the chain or from the label $first, if $first is specified\n Returns : whatever is stored in the element of the chain\n Errorcode: 0\n Args    : reference to the chain, integer, [integer]\n Note:     It works \"downstream\". To proceed backward use up_get_value_at_pos\n\n\n#sub get_value_at_pos {\n  #croak \"Please use instead: down_get_value_at_pos\";\n  ##&down_get_value_at_pos;\n#}\nsub down_get_value_at_pos {\n  my ($chain,$position,$first)=@_;\n  my $label=down_get_label_at_pos($chain,$position,$first);\n  # check place of change\n  if (($label eq -1)||($label eq 0)) { # complain if label doesn't exist\n    warn \"not existing element $label\"; return (0); }\n  return _get_value($chain,$label);\n}\nsub up_get_value_at_pos {\n  my ($chain,$position,$first)=@_;\n  my $label=up_get_label_at_pos($chain,$position,$first);\n  # check place of change\n  if (($label eq -1)||($label eq 0)) { # complain if label doesn't exist\n    warn \"not existing element $label\"; return (0); }\n  return _get_value($chain,$label);\n}\n\n=head2 down_set_value_at_pos\n\n Title   : down_set_value_at_pos\n Usage   : $errorcode = Bio::LiveSeq::Chain::down_set_value_at_pos($chain,$newvalue,$position,$first)\n Function: used to store a new value inside an element of the chain at a particular position instead than directly with a label pointer. It will count the position from the start of the chain or from the label $first, if $first is specified\n Returns : 1\n Errorcode: 0\n Args    : reference to the chain, newvalue, integer, [integer]\n           (newvalue can be: integer, string, object reference, hash ref)\n Note:     It works \"downstream\". To proceed backward use up_set_value_at_pos\n Note2:    If the $newvalue is undef, it will delete the contents of the\n           element but it won't remove the element from the chain.\n\n\n#sub set_value_at_pos {\n  #croak \"Please use instead: down_set_value_at_pos\";\n  ##&down_set_value_at_pos;\n#}\nsub down_set_value_at_pos {\n  my ($chain,$value,$position,$first)=@_;\n  my $label=down_get_label_at_pos($chain,$position,$first);\n  # check place of change\n  if (($label eq -1)||($label eq 0)) { # complain if label doesn't exist\n    warn \"not existing element $label\"; return (0); }\n  _set_value($chain,$label,$value);\n  return (1);\n}\nsub up_set_value_at_pos {\n  my ($chain,$value,$position,$first)=@_;\n  my $label=up_get_label_at_pos($chain,$position,$first);\n  # check place of change\n  if (($label eq -1)||($label eq 0)) { # complain if label doesn't exist\n    warn \"not existing element $label\"; return (0); }\n  _set_value($chain,$label,$value);\n  return (1);\n}\n\n\n=head2 down_set_value_at_label\n\n Title   : down_set_value_at_label\n Usage   : $errorcode = Bio::LiveSeq::Chain::down_set_value_at_label($chain,$newvalue,$label)\n Function: used to store a new value inside an element of the chain defined by its label.\n Returns : 1\n Errorcode: 0\n Args    : reference to the chain, newvalue, integer\n           (newvalue can be: integer, string, object reference, hash ref)\n Note:     It works \"downstream\". To proceed backward use up_set_value_at_label\n Note2:    If the $newvalue is undef, it will delete the contents of the\n           element but it won't remove the element from the chain.","label":"set_value_at_label($chain,$value,$label)"},"containerName":"main::","name":"set_value_at_label","children":[{"name":"$chain","localvar":"my","kind":13,"containerName":"set_value_at_label","line":483,"definition":"my"},{"containerName":"set_value_at_label","kind":13,"name":"$value","line":483},{"line":483,"kind":13,"containerName":"set_value_at_label","name":"$label"},{"name":"$chain","containerName":"set_value_at_label","kind":13,"line":484},{"line":487,"kind":13,"containerName":"set_value_at_label","name":"$chain"},{"containerName":"set_value_at_label","kind":13,"name":"$label","line":487},{"line":489,"name":"$chain","containerName":"set_value_at_label","kind":13},{"line":489,"name":"$label","containerName":"set_value_at_label","kind":13},{"line":489,"name":"$value","kind":13,"containerName":"set_value_at_label"}],"detail":"($chain,$value,$label)","definition":"sub"},{"line":484,"name":"cluck","kind":12},{"name":"_set_value","kind":12,"line":489},{"definition":"sub","children":[{"definition":"my","line":506,"name":"$chain","localvar":"my","containerName":"get_value_at_label","kind":13},{"line":507,"containerName":"get_value_at_label","kind":13,"name":"$chain"},{"line":508,"localvar":"my","kind":13,"containerName":"get_value_at_label","name":"$label","definition":"my"},{"name":"$chain","kind":13,"containerName":"get_value_at_label","line":511},{"line":511,"containerName":"get_value_at_label","kind":13,"name":"$label"},{"line":513,"containerName":"get_value_at_label","kind":13,"name":"$chain"},{"name":"$label","containerName":"get_value_at_label","kind":13,"line":513}],"name":"get_value_at_label","containerName":"main::","line":505,"range":{"start":{"character":0,"line":505},"end":{"character":9999,"line":514}},"kind":12},{"line":507,"kind":12,"name":"cluck"},{"line":513,"name":"_get_value","kind":12},{"detail":"($chain,$label,$value)","definition":"sub","name":"_set_value","containerName":"main::","children":[{"line":518,"containerName":"_set_value","localvar":"my","kind":13,"name":"$chain","definition":"my"},{"kind":13,"containerName":"_set_value","name":"$label","line":518},{"kind":13,"containerName":"_set_value","name":"$value","line":518},{"kind":13,"containerName":"_set_value","name":"$chain","line":519},{"line":519,"kind":13,"containerName":"_set_value","name":"$label"},{"line":519,"kind":13,"containerName":"_set_value","name":"$value"}],"signature":{"label":"_set_value($chain,$label,$value)","documentation":" arguments: CHAIN_REF LABEL VALUE","parameters":[{"label":"$chain"},{"label":"$label"},{"label":"$value"}]},"range":{"start":{"character":0,"line":517},"end":{"character":9999,"line":520}},"kind":12,"line":517},{"detail":"($chain,$label)","definition":"sub","containerName":"main::","name":"_get_value","children":[{"definition":"my","line":523,"localvar":"my","kind":13,"containerName":"_get_value","name":"$chain"},{"containerName":"_get_value","kind":13,"name":"$label","line":523},{"kind":13,"containerName":"_get_value","name":"$chain","line":524},{"line":524,"kind":13,"containerName":"_get_value","name":"$label"}],"signature":{"label":"_get_value($chain,$label)","parameters":[{"label":"$chain"},{"label":"$label"}],"documentation":" arguments: CHAIN_REF LABEL"},"range":{"end":{"line":525,"character":9999},"start":{"line":522,"character":0}},"kind":12,"line":522},{"kind":12,"range":{"end":{"line":543,"character":9999},"start":{"line":541,"character":0}},"line":541,"containerName":"main::","name":"down_get_label_at_pos","children":[],"definition":"sub"},{"name":"_updown_get_label_at_pos","kind":12,"line":542},{"containerName":"main::","name":"up_get_label_at_pos","children":[],"definition":"sub","kind":12,"range":{"start":{"line":544,"character":0},"end":{"character":9999,"line":546}},"line":544},{"name":"_updown_get_label_at_pos","kind":12,"line":545},{"signature":{"label":"_updown_get_label_at_pos($direction,$chain,$position,$first)","parameters":[{"label":"$direction"},{"label":"$chain"},{"label":"$position"},{"label":"$first"}],"documentation":" arguments: [DIRECTION] CHAIN_REF POSITION [FIRST]\n Default DIRECTION=\"down\"\n if FIRST is undefined, FIRST=START (if DIRECTION=down) or FIRST=END (up)"},"range":{"start":{"character":0,"line":552},"end":{"line":570,"character":9999}},"kind":12,"line":552,"detail":"($direction,$chain,$position,$first)","definition":"sub","containerName":"main::","name":"_updown_get_label_at_pos","children":[{"line":553,"localvar":"my","kind":13,"containerName":"_updown_get_label_at_pos","name":"$direction","definition":"my"},{"line":553,"kind":13,"containerName":"_updown_get_label_at_pos","name":"$chain"},{"line":553,"containerName":"_updown_get_label_at_pos","kind":13,"name":"$position"},{"kind":13,"containerName":"_updown_get_label_at_pos","name":"$first","line":553},{"containerName":"_updown_get_label_at_pos","kind":13,"name":"$chain","line":554},{"name":"$begin","localvar":"my","containerName":"_updown_get_label_at_pos","kind":13,"line":555,"definition":"my"},{"line":555,"containerName":"_updown_get_label_at_pos","kind":13,"name":"$chain"},{"line":556,"localvar":"my","kind":13,"containerName":"_updown_get_label_at_pos","name":"$end","definition":"my"},{"name":"$chain","kind":13,"containerName":"_updown_get_label_at_pos","line":556},{"definition":"my","kind":13,"localvar":"my","containerName":"_updown_get_label_at_pos","name":"$flow","line":557},{"containerName":"_updown_get_label_at_pos","kind":13,"name":"$direction","line":558},{"line":558,"name":"$flow","containerName":"_updown_get_label_at_pos","kind":13},{"line":558,"kind":13,"containerName":"_updown_get_label_at_pos","name":"$first"},{"name":"$first","kind":13,"containerName":"_updown_get_label_at_pos","line":558},{"line":558,"name":"$end","kind":13,"containerName":"_updown_get_label_at_pos"},{"containerName":"_updown_get_label_at_pos","kind":13,"name":"$flow","line":559},{"containerName":"_updown_get_label_at_pos","kind":13,"name":"$first","line":559},{"line":559,"containerName":"_updown_get_label_at_pos","kind":13,"name":"$first"},{"name":"$begin","kind":13,"containerName":"_updown_get_label_at_pos","line":559},{"containerName":"_updown_get_label_at_pos","kind":13,"name":"$chain","line":560},{"line":560,"name":"$first","containerName":"_updown_get_label_at_pos","kind":13},{"definition":"my","line":562,"kind":13,"localvar":"my","containerName":"_updown_get_label_at_pos","name":"$label"},{"line":562,"containerName":"_updown_get_label_at_pos","kind":13,"name":"$first"},{"name":"$i","kind":13,"localvar":"my","containerName":"_updown_get_label_at_pos","line":563,"definition":"my"},{"line":564,"name":"$i","kind":13,"containerName":"_updown_get_label_at_pos"},{"containerName":"_updown_get_label_at_pos","kind":13,"name":"$position","line":564},{"line":565,"name":"$label","containerName":"_updown_get_label_at_pos","kind":13},{"containerName":"_updown_get_label_at_pos","kind":13,"name":"$chain","line":565},{"containerName":"_updown_get_label_at_pos","kind":13,"name":"$label","line":565},{"line":565,"name":"$flow","kind":13,"containerName":"_updown_get_label_at_pos"},{"containerName":"_updown_get_label_at_pos","kind":13,"name":"$i","line":566},{"containerName":"_updown_get_label_at_pos","kind":13,"name":"$label","line":567},{"containerName":"_updown_get_label_at_pos","kind":13,"name":"$label","line":569}]},{"name":"cluck","kind":12,"line":554},{"children":[],"containerName":"main::","name":"preinsert_string","definition":"sub","line":573,"kind":12,"range":{"end":{"line":573,"character":9999},"start":{"character":0,"line":573}}},{"name":"praeinsert_string","kind":12,"line":573},{"line":574,"kind":12,"range":{"start":{"line":574,"character":0},"end":{"character":9999,"line":574}},"definition":"sub","children":[],"containerName":"main::","name":"preinsert_array"},{"kind":12,"name":"praeinsert_array","line":574},{"children":[{"line":582,"localvar":"my","kind":13,"containerName":"praeinsert_string","name":"@string","definition":"my"},{"name":"@string","kind":13,"containerName":"praeinsert_string","line":583}],"name":"praeinsert_string","containerName":"main::","definition":"sub","line":581,"range":{"start":{"line":581,"character":0},"end":{"character":9999,"line":584}},"kind":12},{"kind":12,"name":"praeinsert_array","line":583},{"range":{"start":{"line":591,"character":0},"end":{"character":9999,"line":594}},"kind":12,"line":591,"definition":"sub","containerName":"main::","name":"postinsert_string","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"postinsert_string","name":"@string","line":592},{"line":593,"kind":13,"containerName":"postinsert_string","name":"@string"}]},{"kind":12,"name":"postinsert_array","line":593},{"line":600,"kind":12,"range":{"end":{"line":602,"character":9999},"start":{"character":0,"line":600}},"definition":"sub","children":[],"name":"praeinsert_array","containerName":"main::"},{"name":"_praepostinsert_array","kind":12,"line":601},{"range":{"end":{"line":610,"character":9999},"start":{"character":0,"line":608}},"kind":12,"line":608,"definition":"sub","name":"postinsert_array","containerName":"main::","children":[]},{"name":"_praepostinsert_array","kind":12,"line":609},{"children":[{"line":629,"name":"$chain","containerName":"_praepostinsert_array","localvar":"my","kind":13,"definition":"my"},{"line":630,"name":"$chain","kind":13,"containerName":"_praepostinsert_array"},{"definition":"my","kind":13,"localvar":"my","containerName":"_praepostinsert_array","name":"$praepost","line":631},{"definition":"my","localvar":"my","containerName":"_praepostinsert_array","kind":13,"name":"$prae","line":632},{"containerName":"_praepostinsert_array","kind":13,"name":"$post","line":632},{"definition":"my","line":633,"name":"$position","localvar":"my","containerName":"_praepostinsert_array","kind":13},{"name":"$begin","kind":13,"localvar":"my","containerName":"_praepostinsert_array","line":634,"definition":"my"},{"line":634,"containerName":"_praepostinsert_array","kind":13,"name":"$chain"},{"line":635,"localvar":"my","containerName":"_praepostinsert_array","kind":13,"name":"$end","definition":"my"},{"line":635,"kind":13,"containerName":"_praepostinsert_array","name":"$chain"},{"name":"$praepost","containerName":"_praepostinsert_array","kind":13,"line":637},{"containerName":"_praepostinsert_array","kind":13,"name":"$prae","line":638},{"containerName":"_praepostinsert_array","kind":13,"name":"$position","line":639},{"name":"$position","kind":13,"containerName":"_praepostinsert_array","line":639},{"line":639,"kind":13,"containerName":"_praepostinsert_array","name":"$position"},{"line":639,"containerName":"_praepostinsert_array","kind":13,"name":"$begin"},{"line":641,"name":"$post","kind":13,"containerName":"_praepostinsert_array"},{"line":642,"kind":13,"containerName":"_praepostinsert_array","name":"$position"},{"line":642,"name":"$position","containerName":"_praepostinsert_array","kind":13},{"line":642,"name":"$position","kind":13,"containerName":"_praepostinsert_array"},{"line":642,"name":"$end","kind":13,"containerName":"_praepostinsert_array"},{"line":645,"name":"$chain","kind":13,"containerName":"_praepostinsert_array"},{"line":645,"name":"$position","containerName":"_praepostinsert_array","kind":13},{"definition":"my","name":"$elements","localvar":"my","containerName":"_praepostinsert_array","kind":13,"line":651},{"line":652,"name":"$elements_count","localvar":"my","kind":13,"containerName":"_praepostinsert_array","definition":"my"},{"name":"$elements","containerName":"_praepostinsert_array","kind":13,"line":652}],"name":"_praepostinsert_array","containerName":"main::","definition":"sub","line":628,"kind":12,"range":{"end":{"line":652,"character":9999},"start":{"line":628,"character":0}}},{"line":630,"kind":12,"name":"cluck"},{"line":653,"name":"%elements_count","containerName":null,"kind":13},{"name":"$insertbegin","containerName":null,"localvar":"my","kind":13,"line":657,"definition":"my"},{"line":657,"kind":13,"containerName":null,"name":"$insertend"},{"line":657,"name":"_create_chain_elements","kind":12},{"line":657,"name":"$chain","containerName":null,"kind":13},{"line":657,"containerName":null,"kind":13,"name":"$elements"},{"definition":"my","line":666,"name":"$noerror","containerName":null,"localvar":"my","kind":13},{"name":"%prae","containerName":null,"kind":13,"line":667},{"name":"$position","containerName":null,"kind":13,"line":668},{"name":"%begin","containerName":null,"kind":13,"line":668},{"containerName":null,"kind":13,"name":"$noerror","line":669},{"kind":12,"name":"_join_chain_elements","line":669},{"kind":13,"containerName":null,"name":"$chain","line":669},{"kind":13,"containerName":null,"name":"$insertend","line":669},{"kind":13,"containerName":null,"name":"$begin","line":669},{"line":670,"name":"%chain","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"%insertbegin","line":670},{"line":672,"kind":13,"containerName":null,"name":"$noerror"},{"line":672,"kind":12,"name":"_join_chain_elements"},{"line":672,"name":"$chain","containerName":null,"kind":13},{"line":672,"kind":12,"name":"up_element"},{"line":672,"kind":13,"containerName":null,"name":"$chain"},{"line":672,"name":"$position","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"$insertbegin","line":672},{"line":673,"name":"$noerror","containerName":null,"kind":13},{"name":"_join_chain_elements","kind":12,"line":673},{"containerName":null,"kind":13,"name":"$chain","line":673},{"line":673,"name":"$insertend","kind":13,"containerName":null},{"name":"$position","kind":13,"containerName":null,"line":673},{"line":675,"kind":13,"containerName":null,"name":"%post"},{"name":"$position","kind":13,"containerName":null,"line":676},{"containerName":null,"kind":13,"name":"%end","line":676},{"containerName":null,"kind":13,"name":"$noerror","line":677},{"line":677,"name":"_join_chain_elements","kind":12},{"containerName":null,"kind":13,"name":"$chain","line":677},{"line":677,"kind":13,"containerName":null,"name":"$end"},{"kind":13,"containerName":null,"name":"$insertbegin","line":677},{"kind":13,"containerName":null,"name":"%chain","line":678},{"name":"%insertend","containerName":null,"kind":13,"line":678},{"name":"$noerror","containerName":null,"kind":13,"line":680},{"kind":12,"name":"_join_chain_elements","line":680},{"kind":13,"containerName":null,"name":"$chain","line":680},{"line":680,"name":"$insertend","containerName":null,"kind":13},{"line":680,"name":"down_element","kind":12},{"name":"$chain","kind":13,"containerName":null,"line":680},{"line":680,"containerName":null,"kind":13,"name":"$position"},{"name":"$noerror","kind":13,"containerName":null,"line":681},{"name":"_join_chain_elements","kind":12,"line":681},{"name":"$chain","kind":13,"containerName":null,"line":681},{"line":681,"name":"$position","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"%insertbegin","line":681},{"name":"%noerror","kind":13,"containerName":null,"line":688},{"line":689,"kind":13,"containerName":null,"name":"$insertbegin"},{"kind":13,"containerName":null,"name":"%insertend","line":689},{"line":700,"kind":12,"range":{"end":{"character":9999,"line":705},"start":{"line":700,"character":0}},"children":[{"definition":"my","kind":13,"localvar":"my","containerName":"_create_chain_elements","name":"$chain","line":701},{"line":702,"name":"$chain","containerName":"_create_chain_elements","kind":13},{"definition":"my","name":"$arrayref","containerName":"_create_chain_elements","localvar":"my","kind":13,"line":704},{"line":705,"localvar":"my","kind":13,"containerName":"_create_chain_elements","name":"$array_count","definition":"my"},{"name":"$arrayref","containerName":"_create_chain_elements","kind":13,"line":705}],"name":"_create_chain_elements","containerName":"main::","definition":"sub"},{"line":706,"containerName":null,"kind":13,"name":"%array_count"},{"line":708,"localvar":"my","containerName":null,"kind":13,"name":"$begin","definition":"my"},{"name":"%chain","containerName":null,"kind":13,"line":708},{"definition":"my","line":709,"localvar":"my","containerName":null,"kind":13,"name":"$i"},{"line":709,"name":"$begin","kind":13,"containerName":null},{"definition":"my","name":"$element","localvar":"my","kind":13,"containerName":null,"line":710},{"line":711,"containerName":null,"kind":13,"name":"$element"},{"line":711,"name":"%arrayref","containerName":null,"kind":13},{"line":712,"kind":13,"containerName":null,"name":"$i"},{"line":713,"name":"%chain","containerName":null,"kind":13},{"name":"@i","containerName":null,"kind":13,"line":713},{"line":713,"containerName":null,"kind":13,"name":"$element"},{"containerName":null,"kind":13,"name":"$i","line":713},{"line":713,"name":"$i","kind":13,"containerName":null},{"line":715,"kind":13,"localvar":"my","containerName":null,"name":"$end","definition":"my"},{"line":715,"kind":13,"containerName":null,"name":"$i"},{"containerName":null,"kind":13,"name":"%chain","line":716},{"kind":13,"containerName":null,"name":"$i","line":716},{"name":"%chain","containerName":null,"kind":13,"line":717},{"line":717,"kind":13,"containerName":null,"name":"$end"},{"containerName":null,"kind":13,"name":"$begin","line":717},{"line":719,"name":"%chain","kind":13,"containerName":null},{"line":719,"containerName":null,"kind":13,"name":"@begin"},{"kind":13,"containerName":null,"name":"%chain","line":720},{"line":720,"name":"@end","containerName":null,"kind":13},{"line":721,"name":"$begin","containerName":null,"kind":13},{"line":721,"containerName":null,"kind":13,"name":"$end"},{"line":728,"range":{"end":{"character":9999,"line":730},"start":{"line":728,"character":0}},"kind":12,"definition":"sub","children":[],"containerName":"main::","name":"down_element"},{"kind":12,"name":"_updown_element","line":729},{"name":"up_element","containerName":"main::","children":[],"definition":"sub","range":{"end":{"character":9999,"line":737},"start":{"character":0,"line":735}},"kind":12,"line":735},{"line":736,"name":"_updown_element","kind":12},{"name":"_updown_element","containerName":"main::","children":[{"containerName":"_updown_element","localvar":"my","kind":13,"name":"$direction","line":741,"definition":"my"},{"definition":"my","name":"$flow","localvar":"my","containerName":"_updown_element","kind":13,"line":742},{"name":"$direction","containerName":"_updown_element","kind":13,"line":743},{"line":744,"kind":13,"containerName":"_updown_element","name":"$flow"},{"line":746,"name":"$flow","containerName":"_updown_element","kind":13},{"definition":"my","containerName":"_updown_element","localvar":"my","kind":13,"name":"$chain","line":748},{"line":749,"name":"$chain","kind":13,"containerName":"_updown_element"},{"definition":"my","line":751,"name":"$me","localvar":"my","containerName":"_updown_element","kind":13},{"line":752,"name":"$it","containerName":"_updown_element","localvar":"my","kind":13,"definition":"my"},{"kind":13,"containerName":"_updown_element","name":"$chain","line":752},{"line":752,"name":"$me","kind":13,"containerName":"_updown_element"},{"line":752,"kind":13,"containerName":"_updown_element","name":"$flow"},{"line":753,"name":"$it","kind":13,"containerName":"_updown_element"},{"name":"$it","containerName":"_updown_element","kind":13,"line":754}],"definition":"sub","kind":12,"range":{"end":{"line":758,"character":9999},"start":{"line":740,"character":0}},"line":740},{"children":[{"line":762,"name":"$direction","kind":13,"localvar":"my","containerName":"_is_updownstream","definition":"my"},{"definition":"my","line":763,"localvar":"my","kind":13,"containerName":"_is_updownstream","name":"$flow"},{"kind":13,"containerName":"_is_updownstream","name":"$direction","line":764},{"line":765,"name":"$flow","containerName":"_is_updownstream","kind":13},{"line":767,"name":"$flow","kind":13,"containerName":"_is_updownstream"},{"definition":"my","line":769,"name":"$chain","containerName":"_is_updownstream","localvar":"my","kind":13},{"name":"$chain","kind":13,"containerName":"_is_updownstream","line":770},{"definition":"my","containerName":"_is_updownstream","localvar":"my","kind":13,"name":"$first","line":772},{"containerName":"_is_updownstream","localvar":"my","kind":13,"name":"$second","line":773,"definition":"my"},{"kind":13,"containerName":"_is_updownstream","name":"$first","line":774},{"name":"$second","containerName":"_is_updownstream","kind":13,"line":774},{"line":776,"name":"$chain","containerName":"_is_updownstream","kind":13},{"name":"$first","kind":13,"containerName":"_is_updownstream","line":776},{"line":778,"name":"$chain","kind":13,"containerName":"_is_updownstream"},{"kind":13,"containerName":"_is_updownstream","name":"$second","line":778},{"line":780,"containerName":"_is_updownstream","localvar":"my","kind":13,"name":"$label","definition":"my"},{"name":"@array","containerName":"_is_updownstream","kind":13,"line":780},{"containerName":"_is_updownstream","kind":13,"name":"$label","line":781},{"line":781,"kind":13,"containerName":"_is_updownstream","name":"$first"},{"definition":"my","name":"$found","localvar":"my","kind":13,"containerName":"_is_updownstream","line":782},{"line":783,"containerName":"_is_updownstream","kind":13,"name":"$label"},{"name":"$found","containerName":"_is_updownstream","kind":13,"line":783},{"line":784,"name":"$label","containerName":"_is_updownstream","kind":13},{"name":"$second","containerName":"_is_updownstream","kind":13,"line":784},{"line":785,"name":"$found","containerName":"_is_updownstream","kind":13},{"line":787,"kind":13,"containerName":"_is_updownstream","name":"@array"},{"name":"$chain","kind":13,"containerName":"_is_updownstream","line":787},{"line":787,"kind":13,"containerName":"_is_updownstream","name":"$label"},{"containerName":"_is_updownstream","kind":13,"name":"$label","line":788},{"name":"$array","containerName":"_is_updownstream","kind":13,"line":788},{"line":788,"containerName":"_is_updownstream","kind":13,"name":"$flow"}],"name":"_is_updownstream","containerName":"main::","definition":"sub","line":761,"range":{"end":{"line":789,"character":9999},"start":{"line":761,"character":0}},"kind":12},{"kind":13,"containerName":null,"name":"$found","line":790},{"kind":12,"range":{"end":{"character":9999,"line":809},"start":{"character":0,"line":807}},"line":807,"containerName":"main::","name":"is_downstream","children":[],"definition":"sub"},{"definition":"sub","children":[],"containerName":"main::","name":"is_upstream","line":825,"range":{"start":{"line":825,"character":0},"end":{"character":9999,"line":827}},"kind":12},{"kind":12,"range":{"end":{"character":9999,"line":853},"start":{"character":0,"line":843}},"line":843,"definition":"sub","containerName":"main::","name":"check_chain","children":[{"definition":"my","name":"$chain","localvar":"my","containerName":"check_chain","kind":13,"line":844},{"kind":13,"containerName":"check_chain","name":"$chain","line":845},{"definition":"my","line":847,"localvar":"my","containerName":"check_chain","kind":13,"name":"$warnbound"},{"line":847,"containerName":"check_chain","kind":13,"name":"$warnsize"},{"line":847,"name":"$warnbacklink","kind":13,"containerName":"check_chain"},{"containerName":"check_chain","kind":13,"name":"$warnforlink","line":847},{"line":848,"containerName":"check_chain","kind":13,"name":"$warnbound"},{"kind":13,"containerName":"check_chain","name":"$warnsize","line":849},{"line":850,"name":"$warnbacklink","kind":13,"containerName":"check_chain"},{"line":851,"name":"$warnforlink","kind":13,"containerName":"check_chain"},{"line":852,"kind":13,"containerName":"check_chain","name":"$warnbound"},{"line":852,"containerName":"check_chain","kind":13,"name":"$warnsize"},{"line":852,"name":"$warnbacklink","kind":13,"containerName":"check_chain"},{"line":852,"kind":13,"containerName":"check_chain","name":"$warnforlink"}]},{"kind":12,"name":"_boundcheck","line":848},{"line":849,"name":"_sizecheck","kind":12},{"line":850,"name":"_downlinkcheck","kind":12},{"line":851,"name":"_uplinkcheck","kind":12},{"kind":12,"range":{"start":{"character":0,"line":858},"end":{"character":9999,"line":860}},"line":858,"name":"_uplinkcheck","containerName":"main::","children":[],"definition":"sub"},{"kind":12,"name":"_updownlinkcheck","line":859},{"children":[],"containerName":"main::","name":"_downlinkcheck","definition":"sub","line":865,"range":{"end":{"line":867,"character":9999},"start":{"character":0,"line":865}},"kind":12},{"line":866,"kind":12,"name":"_updownlinkcheck"},{"definition":"sub","name":"_updownlinkcheck","containerName":"main::","children":[{"line":873,"name":"$direction","localvar":"my","containerName":"_updownlinkcheck","kind":13,"definition":"my"},{"definition":"my","kind":13,"localvar":"my","containerName":"_updownlinkcheck","name":"$flow","line":874},{"line":874,"containerName":"_updownlinkcheck","kind":13,"name":"$wolf"},{"definition":"my","line":875,"localvar":"my","containerName":"_updownlinkcheck","kind":13,"name":"$chain"},{"line":876,"kind":13,"containerName":"_updownlinkcheck","name":"$chain"},{"definition":"my","name":"$begin","localvar":"my","containerName":"_updownlinkcheck","kind":13,"line":878},{"containerName":"_updownlinkcheck","kind":13,"name":"$chain","line":878},{"line":879,"kind":13,"localvar":"my","containerName":"_updownlinkcheck","name":"$end","definition":"my"},{"line":879,"name":"$chain","kind":13,"containerName":"_updownlinkcheck"},{"name":"$label","kind":13,"localvar":"my","containerName":"_updownlinkcheck","line":880,"definition":"my"},{"containerName":"_updownlinkcheck","kind":13,"name":"@array","line":880},{"name":"$me","kind":13,"containerName":"_updownlinkcheck","line":880},{"kind":13,"containerName":"_updownlinkcheck","name":"$it","line":880},{"line":880,"name":"$itpoints","kind":13,"containerName":"_updownlinkcheck"},{"line":881,"containerName":"_updownlinkcheck","kind":13,"name":"$direction"},{"line":882,"containerName":"_updownlinkcheck","kind":13,"name":"$flow"},{"name":"$wolf","containerName":"_updownlinkcheck","kind":13,"line":883},{"name":"$label","containerName":"_updownlinkcheck","kind":13,"line":884},{"name":"$end","kind":13,"containerName":"_updownlinkcheck","line":884},{"name":"$flow","containerName":"_updownlinkcheck","kind":13,"line":886},{"containerName":"_updownlinkcheck","kind":13,"name":"$wolf","line":887},{"name":"$label","containerName":"_updownlinkcheck","kind":13,"line":888},{"kind":13,"containerName":"_updownlinkcheck","name":"$begin","line":888},{"line":890,"name":"$warncode","kind":13,"localvar":"my","containerName":"_updownlinkcheck","definition":"my"},{"line":892,"kind":13,"containerName":"_updownlinkcheck","name":"$label"},{"containerName":"_updownlinkcheck","kind":13,"name":"$me","line":893},{"containerName":"_updownlinkcheck","kind":13,"name":"$label","line":893},{"line":894,"name":"@array","kind":13,"containerName":"_updownlinkcheck"},{"line":894,"containerName":"_updownlinkcheck","kind":13,"name":"$chain"},{"line":894,"kind":13,"containerName":"_updownlinkcheck","name":"$label"},{"line":895,"kind":13,"containerName":"_updownlinkcheck","name":"$label"},{"name":"$array","containerName":"_updownlinkcheck","kind":13,"line":895},{"name":"$flow","kind":13,"containerName":"_updownlinkcheck","line":895},{"kind":13,"containerName":"_updownlinkcheck","name":"$it","line":896},{"containerName":"_updownlinkcheck","kind":13,"name":"$label","line":896},{"name":"$it","containerName":"_updownlinkcheck","kind":13,"line":897},{"name":"@array","kind":13,"containerName":"_updownlinkcheck","line":898},{"line":898,"kind":13,"containerName":"_updownlinkcheck","name":"$chain"},{"line":898,"kind":13,"containerName":"_updownlinkcheck","name":"$label"},{"kind":13,"containerName":"_updownlinkcheck","name":"$itpoints","line":899},{"name":"$array","containerName":"_updownlinkcheck","kind":13,"line":899},{"line":899,"name":"$wolf","containerName":"_updownlinkcheck","kind":13},{"name":"$me","containerName":"_updownlinkcheck","kind":13,"line":900},{"kind":13,"containerName":"_updownlinkcheck","name":"$itpoints","line":900},{"line":902,"containerName":"_updownlinkcheck","kind":13,"name":"$warncode"}],"kind":12,"range":{"start":{"line":872,"character":0},"end":{"character":9999,"line":904}},"line":872},{"containerName":null,"kind":13,"name":"$warncode","line":906},{"kind":12,"range":{"end":{"line":926,"character":9999},"start":{"line":912,"character":0}},"line":912,"definition":"sub","name":"_sizecheck","containerName":"main::","children":[{"definition":"my","localvar":"my","containerName":"_sizecheck","kind":13,"name":"$chain","line":913},{"kind":13,"containerName":"_sizecheck","name":"$chain","line":914},{"name":"$begin","localvar":"my","containerName":"_sizecheck","kind":13,"line":916,"definition":"my"},{"line":916,"kind":13,"containerName":"_sizecheck","name":"$chain"},{"localvar":"my","containerName":"_sizecheck","kind":13,"name":"$warncode","line":917,"definition":"my"},{"definition":"my","name":"$label","kind":13,"localvar":"my","containerName":"_sizecheck","line":918},{"line":918,"containerName":"_sizecheck","kind":13,"name":"@array"},{"localvar":"my","containerName":"_sizecheck","kind":13,"name":"$size","line":919,"definition":"my"},{"line":919,"name":"$chain","kind":13,"containerName":"_sizecheck"},{"definition":"my","line":920,"name":"$count","localvar":"my","containerName":"_sizecheck","kind":13},{"name":"$label","containerName":"_sizecheck","kind":13,"line":921},{"name":"$begin","kind":13,"containerName":"_sizecheck","line":921},{"line":922,"kind":13,"containerName":"_sizecheck","name":"$label"},{"line":923,"kind":13,"containerName":"_sizecheck","name":"@array"},{"line":923,"name":"$chain","kind":13,"containerName":"_sizecheck"},{"line":923,"kind":13,"containerName":"_sizecheck","name":"$label"},{"line":924,"name":"$label","containerName":"_sizecheck","kind":13},{"line":924,"name":"$array","kind":13,"containerName":"_sizecheck"},{"line":925,"kind":13,"containerName":"_sizecheck","name":"$count"}]},{"name":"$size","kind":13,"containerName":null,"line":927},{"name":"%count","containerName":null,"kind":13,"line":927},{"line":929,"name":"$warncode","kind":13,"containerName":null},{"line":931,"name":"$warncode","containerName":null,"kind":13},{"children":[{"localvar":"my","containerName":"_boundcheck","kind":13,"name":"$chain","line":939,"definition":"my"},{"line":940,"kind":13,"containerName":"_boundcheck","name":"$chain"},{"line":942,"localvar":"my","kind":13,"containerName":"_boundcheck","name":"$begin","definition":"my"},{"kind":13,"containerName":"_boundcheck","name":"$chain","line":942},{"localvar":"my","kind":13,"containerName":"_boundcheck","name":"$end","line":943,"definition":"my"},{"line":943,"name":"$chain","containerName":"_boundcheck","kind":13},{"line":944,"name":"$warncode","kind":13,"localvar":"my","containerName":"_boundcheck","definition":"my"},{"line":947,"kind":13,"containerName":"_boundcheck","name":"$begin"},{"name":"$chain","containerName":"_boundcheck","kind":13,"line":947},{"line":947,"name":"$begin","containerName":"_boundcheck","kind":13},{"name":"$chain","kind":13,"containerName":"_boundcheck","line":948},{"name":"$begin","kind":13,"containerName":"_boundcheck","line":948},{"kind":13,"containerName":"_boundcheck","name":"$warncode","line":952},{"line":957,"kind":13,"containerName":"_boundcheck","name":"$warncode"},{"name":"$end","kind":13,"containerName":"_boundcheck","line":960},{"containerName":"_boundcheck","kind":13,"name":"$chain","line":960},{"kind":13,"containerName":"_boundcheck","name":"$end","line":960},{"name":"$chain","containerName":"_boundcheck","kind":13,"line":961},{"line":961,"name":"$end","containerName":"_boundcheck","kind":13},{"line":965,"containerName":"_boundcheck","kind":13,"name":"$warncode"},{"line":970,"name":"$warncode","kind":13,"containerName":"_boundcheck"},{"line":972,"name":"$warncode","kind":13,"containerName":"_boundcheck"}],"name":"_boundcheck","containerName":"main::","definition":"sub","line":938,"range":{"start":{"line":938,"character":0},"end":{"character":9999,"line":973}},"kind":12},{"line":978,"kind":12,"range":{"end":{"character":9999,"line":988},"start":{"line":978,"character":0}},"definition":"sub","children":[{"definition":"my","line":979,"localvar":"my","kind":13,"containerName":"chain_length","name":"$chain"},{"name":"$chain","containerName":"chain_length","kind":13,"line":980},{"line":982,"name":"$size","localvar":"my","kind":13,"containerName":"chain_length","definition":"my"},{"name":"$chain","containerName":"chain_length","kind":13,"line":982},{"name":"$size","containerName":"chain_length","kind":13,"line":983},{"kind":13,"containerName":"chain_length","name":"$size","line":984}],"name":"chain_length","containerName":"main::"},{"line":992,"kind":12,"range":{"end":{"line":1008,"character":9999},"start":{"character":0,"line":992}},"definition":"sub","children":[{"line":993,"name":"$chain","kind":13,"localvar":"my","containerName":"_join_chain_elements","definition":"my"},{"line":994,"kind":13,"containerName":"_join_chain_elements","name":"$chain"},{"name":"$leftelem","kind":13,"localvar":"my","containerName":"_join_chain_elements","line":996,"definition":"my"},{"name":"$rightelem","kind":13,"localvar":"my","containerName":"_join_chain_elements","line":997,"definition":"my"},{"line":998,"kind":13,"containerName":"_join_chain_elements","name":"$leftelem"},{"line":998,"containerName":"_join_chain_elements","kind":13,"name":"$rightelem"},{"name":"$chain","containerName":"_join_chain_elements","kind":13,"line":1000},{"kind":13,"containerName":"_join_chain_elements","name":"$leftelem","line":1000},{"name":"$chain","kind":13,"containerName":"_join_chain_elements","line":1000},{"line":1000,"name":"$rightelem","kind":13,"containerName":"_join_chain_elements"},{"name":"$chain","kind":13,"containerName":"_join_chain_elements","line":1001},{"name":"$leftelem","kind":13,"containerName":"_join_chain_elements","line":1001},{"name":"$rightelem","kind":13,"containerName":"_join_chain_elements","line":1001},{"containerName":"_join_chain_elements","kind":13,"name":"$chain","line":1002},{"kind":13,"containerName":"_join_chain_elements","name":"$rightelem","line":1002},{"containerName":"_join_chain_elements","kind":13,"name":"$leftelem","line":1002}],"name":"_join_chain_elements","containerName":"main::"},{"definition":"sub","containerName":"main::","name":"splice_chain","children":[{"kind":13,"localvar":"my","containerName":"splice_chain","name":"$chain","line":1026,"definition":"my"},{"line":1027,"kind":13,"containerName":"splice_chain","name":"$chain"},{"definition":"my","kind":13,"localvar":"my","containerName":"splice_chain","name":"$begin","line":1029},{"containerName":"splice_chain","kind":13,"name":"$chain","line":1029},{"definition":"my","name":"$end","localvar":"my","kind":13,"containerName":"splice_chain","line":1030},{"name":"$chain","containerName":"splice_chain","kind":13,"line":1030},{"line":1031,"name":"$first","containerName":"splice_chain","localvar":"my","kind":13,"definition":"my"},{"line":1032,"kind":13,"containerName":"splice_chain","name":"$first"},{"line":1032,"containerName":"splice_chain","kind":13,"name":"$first"},{"containerName":"splice_chain","kind":13,"name":"$first","line":1032},{"line":1032,"kind":13,"containerName":"splice_chain","name":"$begin"},{"line":1033,"name":"$len","localvar":"my","containerName":"splice_chain","kind":13,"definition":"my"},{"definition":"my","line":1034,"name":"$last","localvar":"my","kind":13,"containerName":"splice_chain"},{"line":1035,"localvar":"my","kind":13,"containerName":"splice_chain","name":"@array","definition":"my"},{"kind":13,"containerName":"splice_chain","name":"$string","line":1035},{"definition":"my","localvar":"my","containerName":"splice_chain","kind":13,"name":"$beforecut","line":1036},{"line":1036,"name":"$aftercut","containerName":"splice_chain","kind":13},{"line":1038,"containerName":"splice_chain","kind":13,"name":"$chain"},{"line":1038,"kind":13,"containerName":"splice_chain","name":"$first"},{"line":1040,"name":"$last","kind":13,"containerName":"splice_chain"},{"line":1041,"containerName":"splice_chain","kind":13,"name":"$chain"},{"name":"$last","kind":13,"containerName":"splice_chain","line":1041},{"line":1043,"containerName":"splice_chain","kind":13,"name":"$len"},{"name":"$len","containerName":"splice_chain","kind":13,"line":1045},{"line":1048,"name":"$last","containerName":"splice_chain","kind":13},{"containerName":"splice_chain","kind":13,"name":"$end","line":1048},{"containerName":"splice_chain","kind":13,"name":"$beforecut","line":1051},{"line":1051,"name":"$chain","containerName":"splice_chain","kind":13},{"containerName":"splice_chain","kind":13,"name":"$first","line":1051},{"line":1054,"name":"$i","localvar":"my","containerName":"splice_chain","kind":13,"definition":"my"},{"definition":"my","line":1055,"containerName":"splice_chain","localvar":"my","kind":13,"name":"$label"},{"name":"$first","containerName":"splice_chain","kind":13,"line":1055},{"definition":"my","name":"$afterlast","kind":13,"localvar":"my","containerName":"splice_chain","line":1056},{"line":1056,"kind":13,"containerName":"splice_chain","name":"$chain"},{"name":"$last","containerName":"splice_chain","kind":13,"line":1056},{"name":"$afterlast","kind":13,"containerName":"splice_chain","line":1057},{"line":1057,"kind":13,"containerName":"splice_chain","name":"$afterlast"},{"name":"$label","kind":13,"containerName":"splice_chain","line":1061},{"name":"$label","containerName":"splice_chain","kind":13,"line":1061},{"line":1061,"kind":13,"containerName":"splice_chain","name":"$afterlast"},{"line":1061,"name":"$i","containerName":"splice_chain","kind":13},{"containerName":"splice_chain","kind":13,"name":"$len","line":1061},{"line":1061,"name":"$i","containerName":"splice_chain","kind":13},{"containerName":"splice_chain","kind":13,"name":"@array","line":1062},{"name":"$chain","containerName":"splice_chain","kind":13,"line":1062},{"line":1062,"containerName":"splice_chain","kind":13,"name":"$label"},{"line":1063,"name":"$string","containerName":"splice_chain","kind":13},{"containerName":"splice_chain","kind":13,"name":"$array","line":1063},{"name":"$aftercut","kind":13,"containerName":"splice_chain","line":1064},{"containerName":"splice_chain","kind":13,"name":"$array","line":1064},{"name":"$chain","containerName":"splice_chain","kind":13,"line":1066},{"line":1066,"containerName":"splice_chain","kind":13,"name":"$label"},{"line":1067,"kind":13,"containerName":"splice_chain","name":"$label"},{"line":1067,"kind":13,"containerName":"splice_chain","name":"$aftercut"},{"kind":13,"containerName":"splice_chain","name":"$i","line":1068}],"range":{"end":{"line":1069,"character":9999},"start":{"line":1025,"character":0}},"kind":12,"line":1025},{"line":1075,"containerName":null,"kind":13,"name":"%beforecut"},{"line":1076,"kind":13,"containerName":null,"name":"%aftercut"},{"name":"$chain","containerName":null,"kind":13,"line":1077},{"containerName":null,"kind":13,"name":"$beforecut","line":1077},{"line":1077,"name":"%aftercut","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"%chain","line":1079},{"kind":13,"containerName":null,"name":"$beforecut","line":1079},{"line":1080,"containerName":null,"kind":13,"name":"%chain"},{"line":1080,"name":"@beforecut","containerName":null,"kind":13},{"name":"%aftercut","kind":13,"containerName":null,"line":1083},{"containerName":null,"kind":13,"name":"%chain","line":1084},{"line":1084,"name":"$aftercut","containerName":null,"kind":13},{"line":1085,"kind":13,"containerName":null,"name":"%chain"},{"line":1085,"name":"@aftercut","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"%chain","line":1087},{"line":1088,"name":"%chain","containerName":null,"kind":13},{"line":1091,"name":"%chain","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"%chain","line":1091},{"containerName":null,"kind":13,"name":"$i","line":1091},{"containerName":null,"kind":13,"name":"$string","line":1093},{"definition":"sub","children":[],"containerName":"main::","name":"chain2string_verbose","line":1163,"range":{"end":{"line":1166,"character":9999},"start":{"character":0,"line":1163}},"kind":12},{"kind":12,"name":"carp","line":1164},{"kind":12,"name":"old_down_chain2string_verbose","line":1165},{"line":1167,"kind":12,"range":{"end":{"line":1170,"character":9999},"start":{"character":0,"line":1167}},"definition":"sub","children":[],"containerName":"main::","name":"up_chain2string_verbose"},{"kind":12,"name":"carp","line":1168},{"name":"old_up_chain2string","kind":12,"line":1169},{"line":1171,"range":{"end":{"character":9999,"line":1174},"start":{"line":1171,"character":0}},"kind":12,"children":[],"containerName":"main::","name":"down_chain2string_verbose","definition":"sub"},{"line":1172,"name":"carp","kind":12},{"line":1173,"kind":12,"name":"old_down_chain2string"},{"kind":12,"range":{"end":{"character":9999,"line":1182},"start":{"character":0,"line":1180}},"line":1180,"definition":"sub","name":"old_up_chain2string","containerName":"main::","children":[]},{"line":1181,"kind":12,"name":"old_updown_chain2string"},{"containerName":"main::","name":"old_down_chain2string","children":[],"definition":"sub","kind":12,"range":{"end":{"character":9999,"line":1185},"start":{"character":0,"line":1183}},"line":1183},{"kind":12,"name":"old_updown_chain2string","line":1184},{"range":{"end":{"character":9999,"line":1266},"start":{"line":1200,"character":0}},"kind":12,"line":1200,"signature":{"label":"old_updown_chain2string($direction,$chain,$first,$len,$last,$option)","parameters":[{"label":"$direction"},{"label":"$chain"},{"label":"$first"},{"label":"$len"},{"label":"$last"},{"label":"$option"}],"documentation":" common to up_chain2string and down_chain2string\n arguments: \"up\"||\"down\" chain_ref [first] [len] [last] [option]\n [option] can be any of \"verbose\", \"counting\", \"elements\"\n error: return -1\n defaults: start = first element; if len undef, goes to last\n           if last undef, goes to end\n           if last def it overrides len (that gets undef)\n returns: a string\n example usage: down_chain2string($chain) -> all the chain from begin to end\n example usage: down_chain2string($chain,6) -> from 6 to the end\n example usage: down_chain2string($chain,6,4) -> from 6, going on 4 elements\n example usage: down_chain2string($chain,6,\"\",10) -> from 6 to 10\n example usage: up_chain2string($chain,10,\"\",6) -> from 10 to 6 upstream"},"name":"old_updown_chain2string","containerName":"main::","children":[{"definition":"my","line":1201,"name":"$direction","containerName":"old_updown_chain2string","localvar":"my","kind":13},{"line":1201,"name":"$chain","kind":13,"containerName":"old_updown_chain2string"},{"line":1201,"name":"$first","containerName":"old_updown_chain2string","kind":13},{"line":1201,"name":"$len","kind":13,"containerName":"old_updown_chain2string"},{"name":"$last","kind":13,"containerName":"old_updown_chain2string","line":1201},{"containerName":"old_updown_chain2string","kind":13,"name":"$option","line":1201},{"name":"$chain","kind":13,"containerName":"old_updown_chain2string","line":1202},{"definition":"my","containerName":"old_updown_chain2string","localvar":"my","kind":13,"name":"$begin","line":1204},{"kind":13,"containerName":"old_updown_chain2string","name":"$chain","line":1204},{"kind":13,"localvar":"my","containerName":"old_updown_chain2string","name":"$end","line":1205,"definition":"my"},{"line":1205,"name":"$chain","containerName":"old_updown_chain2string","kind":13},{"line":1206,"name":"$flow","localvar":"my","kind":13,"containerName":"old_updown_chain2string","definition":"my"},{"line":1207,"name":"$direction","kind":13,"containerName":"old_updown_chain2string"},{"line":1208,"name":"$flow","kind":13,"containerName":"old_updown_chain2string"},{"kind":13,"containerName":"old_updown_chain2string","name":"$first","line":1209},{"line":1209,"name":"$first","kind":13,"containerName":"old_updown_chain2string"},{"name":"$end","kind":13,"containerName":"old_updown_chain2string","line":1209},{"name":"$flow","containerName":"old_updown_chain2string","kind":13,"line":1211},{"line":1212,"name":"$first","containerName":"old_updown_chain2string","kind":13},{"line":1212,"name":"$first","containerName":"old_updown_chain2string","kind":13},{"kind":13,"containerName":"old_updown_chain2string","name":"$begin","line":1212},{"line":1215,"name":"$chain","kind":13,"containerName":"old_updown_chain2string"},{"line":1215,"name":"$first","containerName":"old_updown_chain2string","kind":13},{"name":"$last","containerName":"old_updown_chain2string","kind":13,"line":1217},{"containerName":"old_updown_chain2string","kind":13,"name":"$chain","line":1218},{"kind":13,"containerName":"old_updown_chain2string","name":"$last","line":1218},{"line":1220,"name":"$len","kind":13,"containerName":"old_updown_chain2string"},{"name":"$len","kind":13,"containerName":"old_updown_chain2string","line":1222},{"kind":13,"containerName":"old_updown_chain2string","name":"$direction","line":1225},{"line":1226,"containerName":"old_updown_chain2string","kind":13,"name":"$last"},{"name":"$begin","containerName":"old_updown_chain2string","kind":13,"line":1226},{"kind":13,"containerName":"old_updown_chain2string","name":"$last","line":1228},{"line":1228,"kind":13,"containerName":"old_updown_chain2string","name":"$end"},{"line":1231,"name":"@array","containerName":"old_updown_chain2string","localvar":"my","kind":13,"definition":"my"},{"line":1231,"kind":13,"containerName":"old_updown_chain2string","name":"$string"},{"containerName":"old_updown_chain2string","kind":13,"name":"$count","line":1231},{"name":"$verbose","localvar":"my","kind":13,"containerName":"old_updown_chain2string","line":1233,"definition":"my"},{"definition":"my","containerName":"old_updown_chain2string","localvar":"my","kind":13,"name":"$elements","line":1233},{"localvar":"my","containerName":"old_updown_chain2string","kind":13,"name":"@elements","line":1233,"definition":"my"},{"definition":"my","name":"$counting","containerName":"old_updown_chain2string","localvar":"my","kind":13,"line":1233},{"line":1234,"kind":13,"containerName":"old_updown_chain2string","name":"$option"},{"kind":13,"containerName":"old_updown_chain2string","name":"$option","line":1235},{"line":1235,"name":"$verbose","containerName":"old_updown_chain2string","kind":13},{"line":1236,"name":"$option","kind":13,"containerName":"old_updown_chain2string"},{"name":"$elements","containerName":"old_updown_chain2string","kind":13,"line":1236},{"name":"$option","kind":13,"containerName":"old_updown_chain2string","line":1237},{"name":"$counting","containerName":"old_updown_chain2string","kind":13,"line":1237},{"line":1240,"containerName":"old_updown_chain2string","kind":13,"name":"$verbose"},{"definition":"my","line":1245,"kind":13,"localvar":"my","containerName":"old_updown_chain2string","name":"$i"},{"kind":13,"localvar":"my","containerName":"old_updown_chain2string","name":"$label","line":1246,"definition":"my"},{"kind":13,"containerName":"old_updown_chain2string","name":"$first","line":1246},{"definition":"my","localvar":"my","containerName":"old_updown_chain2string","kind":13,"name":"$afterlast","line":1247},{"line":1247,"name":"$chain","containerName":"old_updown_chain2string","kind":13},{"name":"$last","containerName":"old_updown_chain2string","kind":13,"line":1247},{"line":1247,"name":"$flow","kind":13,"containerName":"old_updown_chain2string"},{"containerName":"old_updown_chain2string","kind":13,"name":"$afterlast","line":1248},{"line":1248,"name":"$afterlast","kind":13,"containerName":"old_updown_chain2string"},{"name":"$label","containerName":"old_updown_chain2string","kind":13,"line":1252},{"line":1252,"name":"$label","containerName":"old_updown_chain2string","kind":13},{"line":1252,"name":"$afterlast","kind":13,"containerName":"old_updown_chain2string"},{"line":1252,"name":"$i","containerName":"old_updown_chain2string","kind":13},{"line":1252,"kind":13,"containerName":"old_updown_chain2string","name":"$len"},{"line":1252,"name":"$i","kind":13,"containerName":"old_updown_chain2string"},{"name":"@array","kind":13,"containerName":"old_updown_chain2string","line":1253},{"kind":13,"containerName":"old_updown_chain2string","name":"$chain","line":1253},{"containerName":"old_updown_chain2string","kind":13,"name":"$label","line":1253},{"kind":13,"containerName":"old_updown_chain2string","name":"$verbose","line":1254},{"line":1255,"name":"$string","containerName":"old_updown_chain2string","kind":13},{"kind":13,"containerName":"old_updown_chain2string","name":"$count","line":1256},{"name":"$elements","kind":13,"containerName":"old_updown_chain2string","line":1257},{"name":"@elements","kind":13,"containerName":"old_updown_chain2string","line":1258},{"kind":13,"containerName":"old_updown_chain2string","name":"$label","line":1258},{"name":"$counting","kind":13,"containerName":"old_updown_chain2string","line":1259},{"line":1260,"name":"$count","containerName":"old_updown_chain2string","kind":13},{"line":1262,"containerName":"old_updown_chain2string","kind":13,"name":"$string"},{"name":"$array","containerName":"old_updown_chain2string","kind":13,"line":1262},{"line":1264,"name":"$label","kind":13,"containerName":"old_updown_chain2string"},{"line":1264,"kind":13,"containerName":"old_updown_chain2string","name":"$array"},{"line":1264,"name":"$flow","containerName":"old_updown_chain2string","kind":13},{"line":1265,"containerName":"old_updown_chain2string","kind":13,"name":"$i"}],"detail":"($direction,$chain,$first,$len,$last,$option)","definition":"sub"},{"line":1268,"containerName":null,"kind":13,"name":"%verbose"},{"line":1269,"kind":13,"containerName":null,"name":"%counting"},{"kind":13,"containerName":null,"name":"$count","line":1270},{"line":1271,"name":"%elements","kind":13,"containerName":null},{"line":1272,"kind":13,"containerName":null,"name":"@elements"},{"name":"$string","containerName":null,"kind":13,"line":1274},{"definition":"sub","containerName":"main::","name":"string2chain","children":[{"line":1291,"name":"@string","localvar":"my","kind":13,"containerName":"string2chain","definition":"my"},{"kind":13,"containerName":"string2chain","name":"@string","line":1292}],"range":{"start":{"line":1290,"character":0},"end":{"line":1293,"character":9999}},"kind":12,"line":1290},{"line":1292,"name":"array2chain","kind":12},{"line":1309,"kind":12,"range":{"start":{"character":0,"line":1309},"end":{"line":1311,"character":9999}},"children":[{"definition":"my","line":1310,"name":"$arrayref","localvar":"my","kind":13,"containerName":"array2chain"},{"definition":"my","line":1311,"localvar":"my","containerName":"array2chain","kind":13,"name":"$array_count"},{"line":1311,"kind":13,"containerName":"array2chain","name":"$arrayref"}],"name":"array2chain","containerName":"main::","definition":"sub"},{"line":1312,"kind":13,"containerName":null,"name":"%array_count"},{"name":"@begin","containerName":null,"localvar":"my","kind":13,"line":1314,"definition":"my"},{"line":1315,"name":"%begin","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"%begin","line":1316},{"name":"$begin","kind":13,"containerName":null,"line":1319},{"kind":13,"localvar":"my","containerName":null,"name":"$element","line":1321,"definition":"my"},{"kind":13,"containerName":null,"name":"%hash","line":1321},{"kind":13,"containerName":null,"name":"%hash","line":1322},{"line":1322,"name":"$begin","containerName":null,"kind":13},{"definition":"my","localvar":"my","containerName":null,"kind":13,"name":"$i","line":1323},{"name":"$begin","containerName":null,"kind":13,"line":1323},{"line":1324,"kind":13,"containerName":null,"name":"$element"},{"line":1324,"containerName":null,"kind":13,"name":"%arrayref"},{"kind":13,"containerName":null,"name":"$i","line":1325},{"line":1327,"containerName":null,"kind":13,"name":"%hash"},{"line":1327,"containerName":null,"kind":13,"name":"@i"},{"kind":13,"containerName":null,"name":"$element","line":1327},{"line":1327,"name":"$i","kind":13,"containerName":null},{"line":1327,"name":"$i","kind":13,"containerName":null},{"name":"$end","kind":13,"localvar":"my","containerName":null,"line":1329,"definition":"my"},{"line":1329,"containerName":null,"kind":13,"name":"$i"},{"name":"%hash","kind":13,"containerName":null,"line":1330},{"name":"$end","kind":13,"containerName":null,"line":1330},{"line":1331,"containerName":null,"kind":13,"name":"%hash"},{"line":1331,"name":"firstfree","kind":12},{"line":1331,"name":"$i","containerName":null,"kind":13},{"line":1332,"kind":13,"containerName":null,"name":"%hash"},{"kind":12,"name":"size","line":1332},{"line":1332,"kind":13,"containerName":null,"name":"$end"},{"line":1332,"name":"$begin","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"%hash","line":1335},{"line":1335,"name":"@begin","containerName":null,"kind":13},{"name":"%hash","kind":13,"containerName":null,"line":1336},{"kind":13,"containerName":null,"name":"@end","line":1336},{"kind":13,"containerName":null,"name":"%hash","line":1338}],"version":5}