{"vars":[{"line":127,"containerName":"","kind":2,"name":"base"},{"definition":"sub","children":[],"containerName":"main::","name":"_version","line":135,"range":{"end":{"line":137,"character":9999},"start":{"line":135,"character":0}},"kind":12},{"definition":"sub","containerName":"main::","name":"_file_format","children":[],"range":{"end":{"character":9999,"line":150},"start":{"line":148,"character":0}},"kind":12,"line":148},{"children":[{"name":"$self","kind":13,"localvar":"my","containerName":"_index_file","line":168,"definition":"my"},{"line":169,"kind":13,"containerName":"_index_file","name":"$file"},{"line":170,"name":"$i","containerName":"_index_file","kind":13},{"localvar":"my","containerName":"_index_file","kind":13,"name":"$begin","line":173,"definition":"my"},{"line":177,"name":"$begin","containerName":"_index_file","kind":13},{"name":"$id_parser","localvar":"my","kind":13,"containerName":"_index_file","line":179,"definition":"my"},{"line":179,"name":"$self","containerName":"_index_file","kind":13},{"line":179,"name":"id_parser","containerName":"_index_file","kind":12},{"definition":"my","line":181,"containerName":"_index_file","localvar":"my","kind":13,"name":"$QUAL"},{"line":181,"kind":13,"containerName":"_index_file","name":"$file"},{"line":181,"containerName":"_index_file","kind":13,"name":"$self"},{"line":181,"containerName":"_index_file","kind":12,"name":"throw"},{"line":184,"kind":13,"containerName":"_index_file","name":"$QUAL"},{"definition":"my","line":187,"containerName":"_index_file","localvar":"my","kind":13,"name":"$offset"},{"definition":"my","kind":13,"localvar":"my","containerName":"_index_file","name":"$begin","line":188},{"line":188,"name":"$QUAL","containerName":"_index_file","kind":13},{"name":"$offset","kind":13,"containerName":"_index_file","line":188},{"containerName":"_index_file","localvar":"my","kind":13,"name":"$id","line":190,"definition":"my"},{"line":191,"containerName":"_index_file","kind":13,"name":"$self"},{"name":"add_record","containerName":"_index_file","kind":12,"line":191},{"line":191,"name":"$id","containerName":"_index_file","kind":13},{"line":191,"kind":13,"containerName":"_index_file","name":"$i"},{"line":191,"name":"$begin","kind":13,"containerName":"_index_file"},{"line":196,"containerName":"_index_file","kind":13,"name":"$QUAL"}],"name":"_index_file","containerName":"main::","definition":"sub","detail":"($self,$file,$i)","line":167,"range":{"start":{"character":0,"line":167},"end":{"character":9999,"line":198}},"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$file"},{"label":"$i"}],"documentation":"1;\n#\n# $Id: Qual.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Index::Qual\n#\n# Copied almost verbatim from James Gilbert's Bio::Index::Fasta \n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Index::Qual - Interface for indexing (multiple) fasta qual files\n\n=head1 SYNOPSIS\n\n    # Complete code for making an index for several\n    # qual files\n    use Bio::Index::Qual;\n    use strict;\n\n    my $Index_File_Name = shift;\n    my $inx = Bio::Index::Qual->new(\n        '-filename' => $Index_File_Name,\n        '-write_flag' => 1);\n    $inx->make_index(@ARGV);\n\n    # Print out several sequences present in the index\n    # in Qual format\n    use Bio::Index::Qual;\n    use strict;\n\n    my $Index_File_Name = shift;\n    my $inx = Bio::Index::Qual->new('-filename' => $Index_File_Name);\n    my $out = Bio::SeqIO->new('-format' => 'qual','-fh' => \\*STDOUT);\n\n    foreach my $id (@ARGV) {\n        my $seq = $inx->fetch($id); # Returns Bio::Seq object\n\t$out->write_seq($seq);\n    }\n\n    # or, alternatively\n    my $id;\n    my $seq = $inx->get_Seq_by_id($id); #identical to fetch\n\n=head1 DESCRIPTION\n\nInherits functions for managing dbm files from Bio::Index::Abstract.pm,\nand provides the basic funtionallity for indexing qual files, and\nretrieving the sequence from them. For best results 'use strict'.\n\nBio::Index::Qual supports the Bio::DB::BioSeqI interface, meaning\nit can be used as a Sequence database for other parts of bioperl\n\nAdditional example code is available in scripts/index/*PLS and in \nthe Bioperl Tutorial (L<http://www.bioperl.org/wiki/Bptutorial.pl>).\n\nNote that by default the key for the sequence will be the first continuous\nstring after the 'E<gt>' in the qual header. If you want to use a specific\nsubstring of the qual header you must use the id_parser() method.\n\nYou can also set or customize the unique key used to retrieve by \nwriting your own function and calling the id_parser() method.\nFor example:\n\n   $inx->id_parser(\\&get_id);\n   # make the index\n   $inx->make_index($file_name);\n\n   # here is where the retrieval key is specified\n   sub get_id {\n      my $line = shift;\n      $line =~ /^(\\d+)/;\n      $1;\n   }\n\n=head1 FEED_BACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - James Gilbert, Mark Johnson\n\nEmail - jgrg@sanger.ac.uk, mjohnson@watson.wustl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Index::Qual;\n\nuse strict;\n\nuse Bio::Seq;\n\nuse base qw(Bio::Index::AbstractSeq);\n\n#\n# Suggested fix by Michael G Schwern <schwern@pobox.com> to\n# get around a clash with CPAN shell...\n#\n\n\nsub _version {\n\treturn 0.2;\n}\n\n=head2 _file_format\n\n Title   : _file_format\n Function: The file format for this package, which is needed\n           by the SeqIO system when reading the sequence.\n Returns : 'qual'\n\n\nsub _file_format {\n\treturn 'qual';\n}\n\n\n\n=head2 _index_file\n\n  Title   : _index_file\n  Usage   : $index->_index_file( $file_name, $i )\n  Function: Specialist function to index QUAL format files.\n            Is provided with a filename and an integer\n            by make_index in its SUPER class.\n  Example : \n  Returns : \n  Args    : ","label":"_index_file($self,$file,$i)"}},{"name":"id_parser","kind":12,"line":190},{"children":[{"name":"$self","localvar":"my","containerName":"id_parser","kind":13,"line":220,"definition":"my"},{"line":220,"kind":13,"containerName":"id_parser","name":"$code"},{"kind":13,"containerName":"id_parser","name":"$code","line":222},{"line":223,"name":"$self","kind":13,"containerName":"id_parser"},{"name":"$code","containerName":"id_parser","kind":13,"line":223},{"line":225,"containerName":"id_parser","kind":13,"name":"$self"}],"containerName":"main::","name":"id_parser","definition":"sub","detail":"($self,$code)","line":219,"range":{"end":{"line":226,"character":9999},"start":{"character":0,"line":219}},"kind":12,"signature":{"documentation":"1;\n#\n# $Id: Qual.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Index::Qual\n#\n# Copied almost verbatim from James Gilbert's Bio::Index::Fasta \n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Index::Qual - Interface for indexing (multiple) fasta qual files\n\n=head1 SYNOPSIS\n\n    # Complete code for making an index for several\n    # qual files\n    use Bio::Index::Qual;\n    use strict;\n\n    my $Index_File_Name = shift;\n    my $inx = Bio::Index::Qual->new(\n        '-filename' => $Index_File_Name,\n        '-write_flag' => 1);\n    $inx->make_index(@ARGV);\n\n    # Print out several sequences present in the index\n    # in Qual format\n    use Bio::Index::Qual;\n    use strict;\n\n    my $Index_File_Name = shift;\n    my $inx = Bio::Index::Qual->new('-filename' => $Index_File_Name);\n    my $out = Bio::SeqIO->new('-format' => 'qual','-fh' => \\*STDOUT);\n\n    foreach my $id (@ARGV) {\n        my $seq = $inx->fetch($id); # Returns Bio::Seq object\n\t$out->write_seq($seq);\n    }\n\n    # or, alternatively\n    my $id;\n    my $seq = $inx->get_Seq_by_id($id); #identical to fetch\n\n=head1 DESCRIPTION\n\nInherits functions for managing dbm files from Bio::Index::Abstract.pm,\nand provides the basic funtionallity for indexing qual files, and\nretrieving the sequence from them. For best results 'use strict'.\n\nBio::Index::Qual supports the Bio::DB::BioSeqI interface, meaning\nit can be used as a Sequence database for other parts of bioperl\n\nAdditional example code is available in scripts/index/*PLS and in \nthe Bioperl Tutorial (L<http://www.bioperl.org/wiki/Bptutorial.pl>).\n\nNote that by default the key for the sequence will be the first continuous\nstring after the 'E<gt>' in the qual header. If you want to use a specific\nsubstring of the qual header you must use the id_parser() method.\n\nYou can also set or customize the unique key used to retrieve by \nwriting your own function and calling the id_parser() method.\nFor example:\n\n   $inx->id_parser(\\&get_id);\n   # make the index\n   $inx->make_index($file_name);\n\n   # here is where the retrieval key is specified\n   sub get_id {\n      my $line = shift;\n      $line =~ /^(\\d+)/;\n      $1;\n   }\n\n=head1 FEED_BACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - James Gilbert, Mark Johnson\n\nEmail - jgrg@sanger.ac.uk, mjohnson@watson.wustl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Index::Qual;\n\nuse strict;\n\nuse Bio::Seq;\n\nuse base qw(Bio::Index::AbstractSeq);\n\n#\n# Suggested fix by Michael G Schwern <schwern@pobox.com> to\n# get around a clash with CPAN shell...\n#\n\n\nsub _version {\n\treturn 0.2;\n}\n\n=head2 _file_format\n\n Title   : _file_format\n Function: The file format for this package, which is needed\n           by the SeqIO system when reading the sequence.\n Returns : 'qual'\n\n\nsub _file_format {\n\treturn 'qual';\n}\n\n\n\n=head2 _index_file\n\n  Title   : _index_file\n  Usage   : $index->_index_file( $file_name, $i )\n  Function: Specialist function to index QUAL format files.\n            Is provided with a filename and an integer\n            by make_index in its SUPER class.\n  Example : \n  Returns : \n  Args    : \n\n\nsub _index_file {\n\tmy( $self,\n\t\t $file, # File name\n\t\t $i,    # Index-number of file being indexed\n\t  ) = @_;\n\n\tmy( $begin,     # Offset from start of file of the start\n                    # of the last found record.\n\t  );\n\n\t$begin = 0;\n\n\tmy $id_parser = $self->id_parser;\n\n\topen my $QUAL, '<', $file or $self->throw(\"Can't open file for read : $file\");\n\n\t# Main indexing loop\n\twhile (<$QUAL>) {\n\t\tif (/^>/) {\n\t\t\t# $begin is the position of the first character after the '>'\n                        my $offset = ( $^O =~ /mswin/i ) ? 0 : 1;\n\t\t\tmy $begin = tell($QUAL) - length( $_ ) + $offset;\n\n\t\t\tforeach my $id (&$id_parser($_)) {\n\t\t\t\t$self->add_record($id, $i, $begin);\n\t\t\t}\n\t\t}\n\t}\n\n\tclose $QUAL;\n\treturn 1;\n}\n\n=head2 id_parser\n\n  Title   : id_parser\n  Usage   : $index->id_parser( CODE )\n  Function: Stores or returns the code used by record_id to\n            parse the ID for record from a string.  Useful\n            for (for instance) specifying a different\n            parser for different flavours of Qual file. \n            Returns \\&default_id_parser (see below) if not\n            set. If you supply your own id_parser\n            subroutine, then it should expect a qual\n            description line.  An entry will be added to\n            the index for each string in the list returned.\n  Example : $index->id_parser( \\&my_id_parser )\n  Returns : ref to CODE if called without arguments\n  Args    : CODE","parameters":[{"label":"$self"},{"label":"$code"}],"label":"id_parser($self,$code)"}},{"name":"default_id_parser","kind":12,"line":225},{"containerName":"main::","name":"default_id_parser","children":[],"definition":"sub","range":{"start":{"character":0,"line":242},"end":{"line":248,"character":9999}},"kind":12,"line":242}],"version":5}