{"version":5,"vars":[{"name":"base","containerName":"","kind":2,"line":119},{"line":121,"range":{"end":{"line":123,"character":9999},"start":{"line":121,"character":0}},"kind":12,"children":[],"name":"_type_stamp","containerName":"main::","definition":"sub"},{"range":{"start":{"line":125,"character":0},"end":{"line":127,"character":9999}},"kind":12,"line":125,"definition":"sub","name":"_version","containerName":"main::","children":[]},{"definition":"sub","detail":"($self,$file,$i)","children":[{"definition":"my","line":143,"containerName":"_index_file","localvar":"my","kind":13,"name":"$self"},{"line":144,"kind":13,"containerName":"_index_file","name":"$file"},{"name":"$i","kind":13,"containerName":"_index_file","line":145},{"definition":"my","line":148,"localvar":"my","kind":13,"containerName":"_index_file","name":"$begin"},{"line":150,"name":"$id_parser","localvar":"my","containerName":"_index_file","kind":13,"definition":"my"},{"containerName":"_index_file","kind":13,"name":"$self","line":150},{"kind":12,"containerName":"_index_file","name":"id_parser","line":150},{"definition":"my","name":"$GENBANK","localvar":"my","containerName":"_index_file","kind":13,"line":152},{"name":"$file","kind":13,"containerName":"_index_file","line":152},{"name":"$self","kind":13,"containerName":"_index_file","line":153},{"line":153,"name":"throw","kind":12,"containerName":"_index_file"},{"definition":"my","line":155,"kind":13,"localvar":"my","containerName":"_index_file","name":"%done_ids"},{"name":"$GENBANK","kind":13,"containerName":"_index_file","line":156},{"line":158,"name":"$begin","kind":13,"containerName":"_index_file"},{"name":"$GENBANK","kind":13,"containerName":"_index_file","line":158},{"definition":"my","line":160,"containerName":"_index_file","localvar":"my","kind":13,"name":"$id"},{"kind":13,"containerName":"_index_file","name":"$done_ids","line":161},{"line":161,"containerName":"_index_file","kind":13,"name":"$id"},{"line":162,"name":"$self","kind":13,"containerName":"_index_file"},{"line":162,"containerName":"_index_file","kind":12,"name":"add_record"},{"name":"$id","containerName":"_index_file","kind":13,"line":162},{"containerName":"_index_file","kind":13,"name":"$i","line":162},{"line":162,"name":"$begin","containerName":"_index_file","kind":13},{"line":162,"containerName":"_index_file","kind":13,"name":"$id"},{"name":"$done_ids","kind":13,"containerName":"_index_file","line":163},{"name":"$id","kind":13,"containerName":"_index_file","line":163},{"line":166,"kind":13,"containerName":"_index_file","name":"%done_ids"},{"name":"$GENBANK","kind":13,"containerName":"_index_file","line":169}],"name":"_index_file","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$file"},{"label":"$i"}],"documentation":"__END__\n#\n# $Id: GenBank.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Index::Abstract\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Index::GenBank - Interface for indexing one or more GenBank\nfiles (i.e. flat file GenBank format).\n\n=head1 SYNOPSIS\n\n    # Complete code for making an index for one or more GenBank files\n    use strict;\n    use Bio::Index::GenBank;\n\n    my $Index_File_Name = shift;\n    my $inx = Bio::Index::GenBank->new(-filename => $Index_File_Name, \n\t\t\t\t                           -write_flag => 'WRITE');\n    $inx->make_index(@ARGV);\n\n    # Print out sequences present in the index in gcg format\n    use Bio::Index::GenBank;\n    use Bio::SeqIO;\n    use strict;\n\n    my $Index_File_Name = shift;\n    my $inx = Bio::Index::GenBank->new(-filename => $Index_File_Name);\n    my $seqio = Bio::SeqIO->new(-format => 'gcg');\n    foreach my $id (@ARGV) {\n        my $seq = $inx->fetch($id); # Returns Bio::Seq object\n        $seqio->write_seq($seq);\n    }\n\n    # alternatively\n    my ($locus, $acc);\n    my $seq1 = $inx->get_Seq_by_id($locus);\n    my $seq2 = $inx->get_Seq_by_acc($acc);\n\n=head1 DESCRIPTION\n\nBy default the index that is created uses the LOCUS, ACCESSION, and\nVERSION identifiers as keys. Inherits functions for managing dbm \nfiles from Bio::Index::Abstract.pm, and provides the basic \nfunctionality for indexing GenBank files, and retrieving the \nsequence from them. For best results 'use strict'.\n\nYou can also set or customize the unique key used to retrieve by \nwriting your own function and calling the id_parser() method.\nFor example:\n\n   $inx->id_parser(\\&get_id);\n   # make the index\n   $inx->make_index($file_name);\n\n   # here is where the retrieval key is specified\n   sub get_id {\n      my $line = shift;\n      $line =~ /clone=\"(\\S+)\"/;\n      $1;\n   }\n\n=head1 FEED_BACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail - birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. \nInternal methods are usually preceded with a _\n\n\n# Let's begin the code...\n\npackage Bio::Index::GenBank;\n\nuse strict;\n\nuse Bio::Seq;\n\nuse base qw(Bio::Index::AbstractSeq);\n\nsub _type_stamp {\n    return '__GenBank_FLAT__'; # What kind of index are we?\n}\n\nsub _version {\n    return 0.1;\n}\n\n=head2 _index_file\n\n  Title   : _index_file\n  Usage   : $index->_index_file($file_name, $i)\n  Function: Specialized function to index GenBank format files.\n            Is provided with a filename and an integer\n            by make_index in its SUPER class.\n  Example : \n  Returns : \n  Args    : ","label":"_index_file($self,$file,$i)"},"line":142,"kind":12,"range":{"end":{"line":171,"character":9999},"start":{"character":0,"line":142}}},{"kind":12,"name":"id_parser","line":160},{"children":[{"localvar":"my","kind":13,"containerName":"id_parser","name":"$self","line":189,"definition":"my"},{"line":189,"name":"$code","containerName":"id_parser","kind":13},{"containerName":"id_parser","kind":13,"name":"$code","line":191},{"containerName":"id_parser","kind":13,"name":"$self","line":192},{"line":192,"name":"$code","containerName":"id_parser","kind":13},{"line":194,"name":"$self","containerName":"id_parser","kind":13}],"name":"id_parser","containerName":"main::","definition":"sub","detail":"($self,$code)","line":188,"range":{"end":{"line":195,"character":9999},"start":{"character":0,"line":188}},"kind":12,"signature":{"documentation":"__END__\n#\n# $Id: GenBank.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Index::Abstract\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Index::GenBank - Interface for indexing one or more GenBank\nfiles (i.e. flat file GenBank format).\n\n=head1 SYNOPSIS\n\n    # Complete code for making an index for one or more GenBank files\n    use strict;\n    use Bio::Index::GenBank;\n\n    my $Index_File_Name = shift;\n    my $inx = Bio::Index::GenBank->new(-filename => $Index_File_Name, \n\t\t\t\t                           -write_flag => 'WRITE');\n    $inx->make_index(@ARGV);\n\n    # Print out sequences present in the index in gcg format\n    use Bio::Index::GenBank;\n    use Bio::SeqIO;\n    use strict;\n\n    my $Index_File_Name = shift;\n    my $inx = Bio::Index::GenBank->new(-filename => $Index_File_Name);\n    my $seqio = Bio::SeqIO->new(-format => 'gcg');\n    foreach my $id (@ARGV) {\n        my $seq = $inx->fetch($id); # Returns Bio::Seq object\n        $seqio->write_seq($seq);\n    }\n\n    # alternatively\n    my ($locus, $acc);\n    my $seq1 = $inx->get_Seq_by_id($locus);\n    my $seq2 = $inx->get_Seq_by_acc($acc);\n\n=head1 DESCRIPTION\n\nBy default the index that is created uses the LOCUS, ACCESSION, and\nVERSION identifiers as keys. Inherits functions for managing dbm \nfiles from Bio::Index::Abstract.pm, and provides the basic \nfunctionality for indexing GenBank files, and retrieving the \nsequence from them. For best results 'use strict'.\n\nYou can also set or customize the unique key used to retrieve by \nwriting your own function and calling the id_parser() method.\nFor example:\n\n   $inx->id_parser(\\&get_id);\n   # make the index\n   $inx->make_index($file_name);\n\n   # here is where the retrieval key is specified\n   sub get_id {\n      my $line = shift;\n      $line =~ /clone=\"(\\S+)\"/;\n      $1;\n   }\n\n=head1 FEED_BACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail - birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. \nInternal methods are usually preceded with a _\n\n\n# Let's begin the code...\n\npackage Bio::Index::GenBank;\n\nuse strict;\n\nuse Bio::Seq;\n\nuse base qw(Bio::Index::AbstractSeq);\n\nsub _type_stamp {\n    return '__GenBank_FLAT__'; # What kind of index are we?\n}\n\nsub _version {\n    return 0.1;\n}\n\n=head2 _index_file\n\n  Title   : _index_file\n  Usage   : $index->_index_file($file_name, $i)\n  Function: Specialized function to index GenBank format files.\n            Is provided with a filename and an integer\n            by make_index in its SUPER class.\n  Example : \n  Returns : \n  Args    : \n\n\nsub _index_file {\n    my( $self,\n\t$file,\t\t\t# File name\n\t$i\t\t\t# Index-number of file being indexed\n\t) = @_;\n\n    my $begin = 0;\n\n    my $id_parser = $self->id_parser;\n\n    open my $GENBANK, '<', $file or \n\t$self->throw(\"Can't open file for read : $file\");\n\n    my %done_ids;\n    while (<$GENBANK>) {\n        if (/^LOCUS/) {\n            $begin = tell($GENBANK) - length($_);\n        }\n        for my $id (&$id_parser($_)) {\n            next if exists $done_ids{$id};\n            $self->add_record($id, $i, $begin) if $id;\n            $done_ids{$id} = 1;\n        }\n        if (m{//}) {\n            %done_ids = ();\n        }\n    }\n    close $GENBANK;\n    return 1;\n}\n\n=head2 id_parser\n\n  Title   : id_parser\n  Usage   : $index->id_parser( CODE )\n  Function: Stores or returns the code used by record_id to\n            parse the ID for record from a string.\n            Returns \\&default_id_parser (see below) if not\n            set. An entry will be added to\n            the index for each string in the list returned.\n  Example : $index->id_parser( \\&my_id_parser )\n  Returns : reference to CODE if called without arguments\n  Args    : CODE","parameters":[{"label":"$self"},{"label":"$code"}],"label":"id_parser($self,$code)"}},{"kind":12,"name":"default_id_parser","line":194},{"line":209,"range":{"end":{"character":9999,"line":226},"start":{"character":0,"line":209}},"kind":12,"children":[{"definition":"my","name":"$line","localvar":"my","containerName":"default_id_parser","kind":13,"line":210},{"definition":"my","line":211,"kind":13,"localvar":"my","containerName":"default_id_parser","name":"%accs"},{"line":212,"name":"$line","containerName":"default_id_parser","kind":13},{"line":213,"name":"$accs","kind":13,"containerName":"default_id_parser"},{"line":214,"name":"$line","kind":13,"containerName":"default_id_parser"},{"line":215,"name":"$acc","localvar":"my","kind":13,"containerName":"default_id_parser","definition":"my"},{"name":"$accs","kind":13,"containerName":"default_id_parser","line":216},{"containerName":"default_id_parser","kind":13,"name":"$acc","line":216},{"definition":"my","localvar":"my","containerName":"default_id_parser","kind":13,"name":"$x","line":219},{"definition":"my","line":220,"name":"$acc","localvar":"my","kind":13,"containerName":"default_id_parser"},{"name":"$acc","kind":13,"containerName":"default_id_parser","line":221},{"line":222,"kind":13,"containerName":"default_id_parser","name":"$accs"},{"line":222,"containerName":"default_id_parser","kind":13,"name":"$acc"},{"line":225,"name":"%accs","containerName":"default_id_parser","kind":13}],"containerName":"main::","name":"default_id_parser","definition":"sub"},{"detail":"($self,@args)","definition":"sub","name":"_file_format","containerName":"main::","children":[{"line":240,"localvar":"my","kind":13,"containerName":"_file_format","name":"$self","definition":"my"},{"line":240,"containerName":"_file_format","kind":13,"name":"@args"}],"signature":{"documentation":"__END__\n#\n# $Id: GenBank.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Index::Abstract\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Index::GenBank - Interface for indexing one or more GenBank\nfiles (i.e. flat file GenBank format).\n\n=head1 SYNOPSIS\n\n    # Complete code for making an index for one or more GenBank files\n    use strict;\n    use Bio::Index::GenBank;\n\n    my $Index_File_Name = shift;\n    my $inx = Bio::Index::GenBank->new(-filename => $Index_File_Name, \n\t\t\t\t                           -write_flag => 'WRITE');\n    $inx->make_index(@ARGV);\n\n    # Print out sequences present in the index in gcg format\n    use Bio::Index::GenBank;\n    use Bio::SeqIO;\n    use strict;\n\n    my $Index_File_Name = shift;\n    my $inx = Bio::Index::GenBank->new(-filename => $Index_File_Name);\n    my $seqio = Bio::SeqIO->new(-format => 'gcg');\n    foreach my $id (@ARGV) {\n        my $seq = $inx->fetch($id); # Returns Bio::Seq object\n        $seqio->write_seq($seq);\n    }\n\n    # alternatively\n    my ($locus, $acc);\n    my $seq1 = $inx->get_Seq_by_id($locus);\n    my $seq2 = $inx->get_Seq_by_acc($acc);\n\n=head1 DESCRIPTION\n\nBy default the index that is created uses the LOCUS, ACCESSION, and\nVERSION identifiers as keys. Inherits functions for managing dbm \nfiles from Bio::Index::Abstract.pm, and provides the basic \nfunctionality for indexing GenBank files, and retrieving the \nsequence from them. For best results 'use strict'.\n\nYou can also set or customize the unique key used to retrieve by \nwriting your own function and calling the id_parser() method.\nFor example:\n\n   $inx->id_parser(\\&get_id);\n   # make the index\n   $inx->make_index($file_name);\n\n   # here is where the retrieval key is specified\n   sub get_id {\n      my $line = shift;\n      $line =~ /clone=\"(\\S+)\"/;\n      $1;\n   }\n\n=head1 FEED_BACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail - birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. \nInternal methods are usually preceded with a _\n\n\n# Let's begin the code...\n\npackage Bio::Index::GenBank;\n\nuse strict;\n\nuse Bio::Seq;\n\nuse base qw(Bio::Index::AbstractSeq);\n\nsub _type_stamp {\n    return '__GenBank_FLAT__'; # What kind of index are we?\n}\n\nsub _version {\n    return 0.1;\n}\n\n=head2 _index_file\n\n  Title   : _index_file\n  Usage   : $index->_index_file($file_name, $i)\n  Function: Specialized function to index GenBank format files.\n            Is provided with a filename and an integer\n            by make_index in its SUPER class.\n  Example : \n  Returns : \n  Args    : \n\n\nsub _index_file {\n    my( $self,\n\t$file,\t\t\t# File name\n\t$i\t\t\t# Index-number of file being indexed\n\t) = @_;\n\n    my $begin = 0;\n\n    my $id_parser = $self->id_parser;\n\n    open my $GENBANK, '<', $file or \n\t$self->throw(\"Can't open file for read : $file\");\n\n    my %done_ids;\n    while (<$GENBANK>) {\n        if (/^LOCUS/) {\n            $begin = tell($GENBANK) - length($_);\n        }\n        for my $id (&$id_parser($_)) {\n            next if exists $done_ids{$id};\n            $self->add_record($id, $i, $begin) if $id;\n            $done_ids{$id} = 1;\n        }\n        if (m{//}) {\n            %done_ids = ();\n        }\n    }\n    close $GENBANK;\n    return 1;\n}\n\n=head2 id_parser\n\n  Title   : id_parser\n  Usage   : $index->id_parser( CODE )\n  Function: Stores or returns the code used by record_id to\n            parse the ID for record from a string.\n            Returns \\&default_id_parser (see below) if not\n            set. An entry will be added to\n            the index for each string in the list returned.\n  Example : $index->id_parser( \\&my_id_parser )\n  Returns : reference to CODE if called without arguments\n  Args    : CODE\n\n\nsub id_parser {\n    my ($self,$code) = @_;\n\n    if ($code) {\n\t$self->{'_id_parser'} = $code;\n    }\n    return $self->{'_id_parser'} || \\&default_id_parser;\n}\n\n=head2 default_id_parser\n\n  Title   : default_id_parser\n  Usage   : $id = default_id_parser($line)\n  Function: The default parser for GenBank.pm\n  Returns : Array of specified ids\n  Args    : a line string\n\n\n#'\n\nsub default_id_parser {\n    my $line = shift;\n    my %accs;\n    if ( $line =~ /^LOCUS\\s+(\\S+)/ ) {\n\t$accs{$1}++;\n    } elsif ( $line =~ /^ACCESSION\\s+(.*)/ ) {\n\tfor my $acc ( split(/\\s+/,$1) ) {\n\t    $accs{$acc}++;\n\t}\n    } elsif ( /^VERSION\\s+(.*)/) {\t\n\tmy $x = $1;\n\tfor my $acc ( split(/\\s+/,$1) ) {\n\t    $acc=~ s/GI\\://;\n\t    $accs{$acc}++;\n\t}\n    }\n    keys %accs;\n}\n\n=head2 _file_format\n\n Title   : _file_format\n Usage   : Internal function for indexing system\n Function: Provides file format for this database\n Example :\n Returns : \n Args    :","parameters":[{"label":"$self"},{"label":"@args"}],"label":"_file_format($self,@args)"},"kind":12,"range":{"end":{"character":9999,"line":242},"start":{"line":239,"character":0}},"line":239}]}