{"version":5,"vars":[{"line":132,"containerName":"","kind":2,"name":"base"},{"line":139,"kind":12,"range":{"end":{"character":9999,"line":141},"start":{"character":0,"line":139}},"children":[],"name":"_version","containerName":"main::","definition":"sub"},{"line":152,"kind":12,"range":{"start":{"line":152,"character":0},"end":{"character":9999,"line":154}},"definition":"sub","children":[],"name":"_file_format","containerName":"main::"},{"definition":"sub","detail":"($self,$file,$i)","children":[{"line":170,"name":"$self","localvar":"my","containerName":"_index_file","kind":13,"definition":"my"},{"kind":13,"containerName":"_index_file","name":"$file","line":171},{"containerName":"_index_file","kind":13,"name":"$i","line":172},{"name":"$begin","containerName":"_index_file","localvar":"my","kind":13,"line":175,"definition":"my"},{"definition":"my","line":179,"containerName":"_index_file","localvar":"my","kind":13,"name":"$id_parser"},{"name":"$self","kind":13,"containerName":"_index_file","line":179},{"name":"id_parser","containerName":"_index_file","kind":12,"line":179},{"definition":"my","localvar":"my","kind":13,"containerName":"_index_file","name":"$FASTA","line":181},{"name":"$file","containerName":"_index_file","kind":13,"line":181},{"line":181,"kind":13,"containerName":"_index_file","name":"$self"},{"line":181,"kind":12,"containerName":"_index_file","name":"throw"},{"name":"$FASTA","containerName":"_index_file","kind":13,"line":184},{"containerName":"_index_file","localvar":"my","kind":13,"name":"$offset","line":190,"definition":"my"},{"line":191,"kind":13,"containerName":"_index_file","name":"$begin"},{"containerName":"_index_file","kind":13,"name":"$FASTA","line":191},{"name":"$offset","containerName":"_index_file","kind":13,"line":191},{"definition":"my","name":"$id","localvar":"my","kind":13,"containerName":"_index_file","line":193},{"line":194,"name":"$self","containerName":"_index_file","kind":13},{"kind":12,"containerName":"_index_file","name":"add_record","line":194},{"kind":13,"containerName":"_index_file","name":"$id","line":194},{"line":194,"name":"$i","containerName":"_index_file","kind":13},{"name":"$begin","kind":13,"containerName":"_index_file","line":194},{"line":198,"name":"$FASTA","containerName":"_index_file","kind":13}],"name":"_index_file","containerName":"main::","signature":{"documentation":"1;\n#\n# $Id: Fasta.pm 16168 2009-09-25 21:07:32Z cjfields $\n#\n# BioPerl module for Bio::Index::Fasta\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by James Gilbert <jgrg@sanger.ac.uk>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Index::Fasta - Interface for indexing (multiple) fasta files\n\n=head1 SYNOPSIS\n\n    # Make an index for one or more fasta files\n    use Bio::Index::Fasta;\n    use strict;\n\n    my $Index_File_Name = shift;\n    my $inx = Bio::Index::Fasta->new(-filename => $Index_File_Name,\n                                     -write_flag => 1);\n    $inx->make_index(@ARGV);\n\n\n    # Once the index is made it can accessed, either in the\n    # same script or a different one\n    use Bio::Index::Fasta;\n    use strict;\n\n    my $Index_File_Name = shift;\n    my $inx = Bio::Index::Fasta->new(-filename => $Index_File_Name);\n    my $out = Bio::SeqIO->new(-format => 'Fasta',\n                              -fh => \\*STDOUT);\n\n    foreach my $id (@ARGV) {\n        my $seq = $inx->fetch($id); # Returns Bio::Seq object\n         $out->write_seq($seq);\n    }\n\n    # or, alternatively\n    my $id;\n    my $seq = $inx->get_Seq_by_id($id); # identical to fetch()\n\n=head1 DESCRIPTION\n\nInherits functions for managing dbm files from Bio::Index::Abstract.pm,\nand provides the basic funtionallity for indexing fasta files, and\nretrieving the sequence from them. For best results 'use strict'.\n\nBio::Index::Fasta supports the Bio::DB::BioSeqI interface, meaning\nit can be used as a Sequence database for other parts of bioperl\n\nAdditional example code is available in scripts/index/*PLS and in \nthe Bioperl Tutorial (L<http://www.bioperl.org/wiki/Bptutorial.pl>)\n\nNote that by default the key for the sequence will be the first continuous\nstring after the 'E<gt>' in the fasta header. If you want to use a specific\nsubstring of the fasta header you must use the id_parser() method.\n\nYou can also set or customize the unique key used to retrieve by \nwriting your own function and calling the id_parser() method.\nFor example:\n\n   $inx->id_parser(\\&get_id);\n   # make the index\n   $inx->make_index($file_name);\n\n   # here is where the retrieval key is specified\n   sub get_id {\n      my $line = shift;\n      $line =~ /^>.+gi\\|(\\d+)/;\n      $1;\n   }\n\n\n=head1 FEED_BACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - James Gilbert\n\nEmail - jgrg@sanger.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Index::Fasta;\n\nuse strict;\nuse warnings;\n\nuse Bio::Seq;\n\nuse base qw(Bio::Index::AbstractSeq);\n\n#\n# Suggested fix by Michael G Schwern <schwern@pobox.com> to\n# get around a clash with CPAN shell...\n#\n\nsub _version {\n    return 0.2;\n}\n\n=head2 _file_format\n\n Title   : _file_format\n Function: The file format for this package, which is needed\n           by the SeqIO system when reading the sequence.\n Returns : 'Fasta'\n\n\nsub _file_format {\n    return 'Fasta';\n}\n\n=head2 _index_file\n\n  Title   : _index_file\n  Usage   : $index->_index_file( $file_name, $i )\n  Function: Specialist function to index FASTA format files.\n            Is provided with a filename and an integer\n            by make_index in its SUPER class.\n  Example : \n  Returns : \n  Args    : ","parameters":[{"label":"$self"},{"label":"$file"},{"label":"$i"}],"label":"_index_file($self,$file,$i)"},"line":169,"kind":12,"range":{"start":{"character":0,"line":169},"end":{"character":9999,"line":200}}},{"name":"id_parser","kind":12,"line":193},{"children":[{"definition":"my","line":222,"name":"$self","kind":13,"localvar":"my","containerName":"id_parser"},{"line":222,"name":"$code","containerName":"id_parser","kind":13},{"line":224,"name":"$code","kind":13,"containerName":"id_parser"},{"name":"$self","kind":13,"containerName":"id_parser","line":225},{"line":225,"kind":13,"containerName":"id_parser","name":"$code"},{"name":"$self","kind":13,"containerName":"id_parser","line":227}],"containerName":"main::","name":"id_parser","definition":"sub","detail":"($self,$code)","line":221,"kind":12,"range":{"end":{"line":228,"character":9999},"start":{"line":221,"character":0}},"signature":{"label":"id_parser($self,$code)","parameters":[{"label":"$self"},{"label":"$code"}],"documentation":"1;\n#\n# $Id: Fasta.pm 16168 2009-09-25 21:07:32Z cjfields $\n#\n# BioPerl module for Bio::Index::Fasta\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by James Gilbert <jgrg@sanger.ac.uk>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Index::Fasta - Interface for indexing (multiple) fasta files\n\n=head1 SYNOPSIS\n\n    # Make an index for one or more fasta files\n    use Bio::Index::Fasta;\n    use strict;\n\n    my $Index_File_Name = shift;\n    my $inx = Bio::Index::Fasta->new(-filename => $Index_File_Name,\n                                     -write_flag => 1);\n    $inx->make_index(@ARGV);\n\n\n    # Once the index is made it can accessed, either in the\n    # same script or a different one\n    use Bio::Index::Fasta;\n    use strict;\n\n    my $Index_File_Name = shift;\n    my $inx = Bio::Index::Fasta->new(-filename => $Index_File_Name);\n    my $out = Bio::SeqIO->new(-format => 'Fasta',\n                              -fh => \\*STDOUT);\n\n    foreach my $id (@ARGV) {\n        my $seq = $inx->fetch($id); # Returns Bio::Seq object\n         $out->write_seq($seq);\n    }\n\n    # or, alternatively\n    my $id;\n    my $seq = $inx->get_Seq_by_id($id); # identical to fetch()\n\n=head1 DESCRIPTION\n\nInherits functions for managing dbm files from Bio::Index::Abstract.pm,\nand provides the basic funtionallity for indexing fasta files, and\nretrieving the sequence from them. For best results 'use strict'.\n\nBio::Index::Fasta supports the Bio::DB::BioSeqI interface, meaning\nit can be used as a Sequence database for other parts of bioperl\n\nAdditional example code is available in scripts/index/*PLS and in \nthe Bioperl Tutorial (L<http://www.bioperl.org/wiki/Bptutorial.pl>)\n\nNote that by default the key for the sequence will be the first continuous\nstring after the 'E<gt>' in the fasta header. If you want to use a specific\nsubstring of the fasta header you must use the id_parser() method.\n\nYou can also set or customize the unique key used to retrieve by \nwriting your own function and calling the id_parser() method.\nFor example:\n\n   $inx->id_parser(\\&get_id);\n   # make the index\n   $inx->make_index($file_name);\n\n   # here is where the retrieval key is specified\n   sub get_id {\n      my $line = shift;\n      $line =~ /^>.+gi\\|(\\d+)/;\n      $1;\n   }\n\n\n=head1 FEED_BACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - James Gilbert\n\nEmail - jgrg@sanger.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Index::Fasta;\n\nuse strict;\nuse warnings;\n\nuse Bio::Seq;\n\nuse base qw(Bio::Index::AbstractSeq);\n\n#\n# Suggested fix by Michael G Schwern <schwern@pobox.com> to\n# get around a clash with CPAN shell...\n#\n\nsub _version {\n    return 0.2;\n}\n\n=head2 _file_format\n\n Title   : _file_format\n Function: The file format for this package, which is needed\n           by the SeqIO system when reading the sequence.\n Returns : 'Fasta'\n\n\nsub _file_format {\n    return 'Fasta';\n}\n\n=head2 _index_file\n\n  Title   : _index_file\n  Usage   : $index->_index_file( $file_name, $i )\n  Function: Specialist function to index FASTA format files.\n            Is provided with a filename and an integer\n            by make_index in its SUPER class.\n  Example : \n  Returns : \n  Args    : \n\n\nsub _index_file {\n    my( $self,\n         $file, # File name\n         $i,    # Index-number of file being indexed\n      ) = @_;\n\n    my( $begin,     # Offset from start of file of the start\n                     # of the last found record.\n    );\n\n    my $id_parser = $self->id_parser;\n\n    open my $FASTA, '<', $file or $self->throw(\"Can't open file for read : $file\");\n\n    # Main indexing loop\n    while (<$FASTA>) {\n        if (/^>/) {\n            \n            # the following was fixed to allow validation - cjfields\n            \n            # $begin is the position of the first character after the '>'\n            my $offset = ( $^O =~ /mswin/i ) ? 1 : 0;\n            $begin = tell($FASTA) - length( $_ ) - $offset;\n            \n            foreach my $id (&$id_parser($_)) {\n                $self->add_record($id, $i, $begin);\n            }\n        }\n    }\n    close $FASTA;\n    return 1;\n}\n\n=head2 id_parser\n\n  Title   : id_parser\n  Usage   : $index->id_parser( CODE )\n  Function: Stores or returns the code used by record_id to\n            parse the ID for record from a string.  Useful\n            for (for instance) specifying a different\n            parser for different flavours of FASTA file. \n            Returns \\&default_id_parser (see below) if not\n            set. If you supply your own id_parser\n            subroutine, then it should expect a fasta\n            description line.  An entry will be added to\n            the index for each string in the list returned.\n  Example : $index->id_parser( \\&my_id_parser )\n  Returns : ref to CODE if called without arguments\n  Args    : CODE"}},{"line":227,"kind":12,"name":"default_id_parser"},{"range":{"end":{"character":9999,"line":248},"start":{"line":242,"character":0}},"kind":12,"line":242,"definition":"sub","name":"default_id_parser","containerName":"main::","children":[]}]}