{"vars":[{"containerName":"","kind":2,"name":"base","line":110},{"containerName":"main::","name":"_type_stamp","children":[],"definition":"sub","range":{"start":{"line":112,"character":0},"end":{"line":114,"character":9999}},"kind":12,"line":112},{"name":"_version","containerName":"main::","children":[],"definition":"sub","kind":12,"range":{"start":{"line":117,"character":0},"end":{"line":119,"character":9999}},"line":117},{"detail":"($self,$file,$i)","definition":"sub","containerName":"main::","name":"_index_file","children":[{"localvar":"my","containerName":"_index_file","kind":13,"name":"$self","line":135,"definition":"my"},{"name":"$file","kind":13,"containerName":"_index_file","line":136},{"containerName":"_index_file","kind":13,"name":"$i","line":137},{"line":140,"containerName":"_index_file","localvar":"my","kind":13,"name":"$begin","definition":"my"},{"name":"$id","containerName":"_index_file","kind":13,"line":142},{"kind":13,"containerName":"_index_file","name":"@accs","line":143},{"line":146,"name":"$begin","kind":13,"containerName":"_index_file"},{"definition":"my","line":148,"localvar":"my","containerName":"_index_file","kind":13,"name":"$EMBL"},{"containerName":"_index_file","kind":13,"name":"$file","line":148},{"name":"$self","kind":13,"containerName":"_index_file","line":148},{"line":148,"name":"throw","kind":12,"containerName":"_index_file"},{"name":"$id","kind":13,"containerName":"_index_file","line":151},{"kind":13,"containerName":"_index_file","name":"@accs","line":152},{"line":153,"kind":13,"containerName":"_index_file","name":"$EMBL"},{"line":155,"containerName":"_index_file","kind":13,"name":"$id"},{"containerName":"_index_file","kind":13,"name":"$self","line":156},{"line":156,"kind":12,"containerName":"_index_file","name":"throw"},{"line":159,"kind":13,"containerName":"_index_file","name":"@accs"},{"line":160,"name":"$self","containerName":"_index_file","kind":13},{"kind":12,"containerName":"_index_file","name":"warn","line":160},{"line":163,"kind":13,"containerName":"_index_file","name":"$self"},{"line":163,"containerName":"_index_file","kind":12,"name":"add_record"},{"kind":13,"containerName":"_index_file","name":"$id","line":163},{"line":163,"name":"$i","kind":13,"containerName":"_index_file"},{"containerName":"_index_file","kind":13,"name":"$begin","line":163},{"definition":"my","line":165,"containerName":"_index_file","localvar":"my","kind":13,"name":"$acc"},{"name":"@accs","containerName":"_index_file","kind":13,"line":165},{"name":"$acc","kind":13,"containerName":"_index_file","line":166},{"line":166,"name":"$id","containerName":"_index_file","kind":13},{"name":"$self","kind":13,"containerName":"_index_file","line":167},{"line":167,"name":"add_record","containerName":"_index_file","kind":12},{"line":167,"kind":13,"containerName":"_index_file","name":"$acc"},{"containerName":"_index_file","kind":13,"name":"$i","line":167},{"line":167,"name":"$begin","containerName":"_index_file","kind":13},{"line":171,"name":"$id","kind":13,"containerName":"_index_file"},{"kind":13,"containerName":"_index_file","name":"$begin","line":174},{"line":174,"name":"$EMBL","containerName":"_index_file","kind":13},{"name":"@accs","containerName":"_index_file","kind":13,"line":177},{"line":183,"name":"$EMBL","kind":13,"containerName":"_index_file"}],"signature":{"label":"_index_file($self,$file,$i)","documentation":"1;\n# $Id: EMBL.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Index::EMBL\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Index::EMBL - Interface for indexing (multiple) EMBL/Swissprot\n.dat files (i.e. flat file EMBL/Swissprot format).\n\n=head1 SYNOPSIS\n\n    # Complete code for making an index for several\n    # EMBL files\n    use Bio::Index::EMBL;\n    use strict;\n\n    my $Index_File_Name = shift;\n    my $inx = Bio::Index::EMBL->new(-filename => $Index_File_Name,\n\t\t\t\t    -write_flag => 'WRITE');\n    $inx->make_index(@ARGV);\n\n    # Print out several sequences present in the index\n    # in Fasta format\n    use Bio::Index::EMBL;\n    use strict;\n\n    my $Index_File_Name = shift;\n    my $inx = Bio::Index::EMBL->new(-filename => $Index_File_Name);\n    my $out = Bio::SeqIO->new(-format => 'Fasta',-fh => \\*STDOUT);\n\n    foreach my $id (@ARGV) {\n        my $seq = $inx->fetch($id); # Returns Bio::Seq object\n\t$out->write_seq($seq);\n    }\n\n    # alternatively\n    my ($id, $acc);\n    my $seq1 = $inx->get_Seq_by_id($id);\n    my $seq2 = $inx->get_Seq_by_acc($acc);\n\n=head1 DESCRIPTION\n\nInherits functions for managing dbm files from Bio::Index::Abstract.pm,\nand provides the basic funtionallity for indexing EMBL files, and\nretrieving the sequence from them. Heavily snaffled from James Gilbert\nand his Fasta system. Note: for best results 'use strict'.\n\nThe keys are the identifiers in the ID and AC lines.\n\n=head1 FEED_BACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail - birney@sanger.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let's begin the code...\n\n\npackage Bio::Index::EMBL;\n\nuse strict;\n\nuse Bio::Seq;\n\nuse base qw(Bio::Index::AbstractSeq);\n\nsub _type_stamp {\n    return '__EMBL_FLAT__'; # What kind of index are we?\n}\n\n\nsub _version {\n    return 0.1;\n}\n\n=head2 _index_file\n\n  Title   : _index_file\n  Usage   : $index->_index_file( $file_name, $i )\n  Function: Specialist function to index EMBL format files.\n            Is provided with a filename and an integer\n            by make_index in its SUPER class.\n  Example : \n  Returns : \n  Args    : ","parameters":[{"label":"$self"},{"label":"$file"},{"label":"$i"}]},"kind":12,"range":{"start":{"line":134,"character":0},"end":{"character":9999,"line":185}},"line":134},{"detail":"($self,@args)","definition":"sub","name":"_file_format","containerName":"main::","children":[{"definition":"my","line":200,"localvar":"my","kind":13,"containerName":"_file_format","name":"$self"},{"line":200,"kind":13,"containerName":"_file_format","name":"@args"}],"signature":{"label":"_file_format($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: EMBL.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Index::EMBL\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Index::EMBL - Interface for indexing (multiple) EMBL/Swissprot\n.dat files (i.e. flat file EMBL/Swissprot format).\n\n=head1 SYNOPSIS\n\n    # Complete code for making an index for several\n    # EMBL files\n    use Bio::Index::EMBL;\n    use strict;\n\n    my $Index_File_Name = shift;\n    my $inx = Bio::Index::EMBL->new(-filename => $Index_File_Name,\n\t\t\t\t    -write_flag => 'WRITE');\n    $inx->make_index(@ARGV);\n\n    # Print out several sequences present in the index\n    # in Fasta format\n    use Bio::Index::EMBL;\n    use strict;\n\n    my $Index_File_Name = shift;\n    my $inx = Bio::Index::EMBL->new(-filename => $Index_File_Name);\n    my $out = Bio::SeqIO->new(-format => 'Fasta',-fh => \\*STDOUT);\n\n    foreach my $id (@ARGV) {\n        my $seq = $inx->fetch($id); # Returns Bio::Seq object\n\t$out->write_seq($seq);\n    }\n\n    # alternatively\n    my ($id, $acc);\n    my $seq1 = $inx->get_Seq_by_id($id);\n    my $seq2 = $inx->get_Seq_by_acc($acc);\n\n=head1 DESCRIPTION\n\nInherits functions for managing dbm files from Bio::Index::Abstract.pm,\nand provides the basic funtionallity for indexing EMBL files, and\nretrieving the sequence from them. Heavily snaffled from James Gilbert\nand his Fasta system. Note: for best results 'use strict'.\n\nThe keys are the identifiers in the ID and AC lines.\n\n=head1 FEED_BACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail - birney@sanger.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let's begin the code...\n\n\npackage Bio::Index::EMBL;\n\nuse strict;\n\nuse Bio::Seq;\n\nuse base qw(Bio::Index::AbstractSeq);\n\nsub _type_stamp {\n    return '__EMBL_FLAT__'; # What kind of index are we?\n}\n\n\nsub _version {\n    return 0.1;\n}\n\n=head2 _index_file\n\n  Title   : _index_file\n  Usage   : $index->_index_file( $file_name, $i )\n  Function: Specialist function to index EMBL format files.\n            Is provided with a filename and an integer\n            by make_index in its SUPER class.\n  Example : \n  Returns : \n  Args    : \n\n\nsub _index_file {\n    my( $self,\n        $file, # File name\n        $i     # Index-number of file being indexed\n        ) = @_;\n\n    my( $begin, # Offset from start of file of the start\n                # of the last found record.\n        $id,    # ID of last found record.\n\t@accs,   # accession of last record. Also put into the index\n        );\n\n    $begin = 0;\n\n    open my $EMBL, '<', $file or $self->throw(\"Can't open file for read : $file\");\n\n    # Main indexing loop\n    $id = undef;\n    @accs = ();\n    while (<$EMBL>) {\n\tif( m{^//} ) {\n\t    if( ! defined $id ) {\n\t\t$self->throw(\"Got to a end of entry line for an EMBL flat file with no parsed ID. Considering this a problem!\");\n\t\tnext;\n\t    }\n\t    if( ! @accs ) {\n\t\t$self->warn(\"For id [$id] in embl flat file, got no accession number. Storing id index anyway\");\n\t    }\n\n\t    $self->add_record($id, $i, $begin);\n\n\t    foreach my $acc (@accs) {\n\t\tif( $acc ne $id ) {\n\t\t    $self->add_record($acc, $i, $begin);\n\t\t}\n\t    }\n\t} elsif (/^ID\\s+(\\S+)/) {\n\t    $id = $1;\n\t    # not sure if I like this. Assummes tell is in bytes.\n\t    # we could tell before each line and save it.\n            $begin = tell($EMBL) - length( $_ );\n\t\n\t} elsif (/^AC\\s+(.*)?/) {\n            push @accs , split (/[; ]+/, $1);\n\t} else {\n\t    # do nothing\n\t}\n    }\n\n    close $EMBL;\n    return 1;\n}\n\n=head2 _file_format\n\n Title   : _file_format\n Usage   : Internal function for indexing system\n Function: Provides file format for this database\n Example :\n Returns : \n Args    :"},"range":{"start":{"character":0,"line":199},"end":{"character":9999,"line":203}},"kind":12,"line":199}],"version":5}