{"vars":[{"line":1,"kind":12,"name":"pod"},{"line":82,"containerName":"","kind":2,"name":"base"},{"containerName":"main::","name":"_initialize","children":[{"localvar":"my","containerName":"_initialize","kind":13,"name":"$self","line":94,"definition":"my"},{"line":94,"containerName":"_initialize","kind":13,"name":"%arg"},{"name":"$self","containerName":"_initialize","kind":13,"line":96},{"line":96,"name":"%arg","kind":13,"containerName":"_initialize"},{"line":98,"kind":13,"containerName":"_initialize","name":"$self"},{"name":"mode","kind":12,"containerName":"_initialize","line":98},{"line":99,"name":"$self","kind":13,"containerName":"_initialize"},{"name":"$self","kind":13,"containerName":"_initialize","line":100},{"name":"$self","containerName":"_initialize","kind":13,"line":103},{"line":103,"containerName":"_initialize","kind":12,"name":"throw"}],"detail":"($self,%arg)","definition":"sub","range":{"start":{"character":0,"line":93},"end":{"line":105,"character":9999}},"kind":12,"line":93,"signature":{"parameters":[{"label":"$self"},{"label":"%arg"}],"documentation":"=head1 NAME\n\nBio::FeatureIO::vecscreen_simple - read/write features from NCBI vecscreen -f 3\noutput\n\n=head1 SYNOPSIS\n\n    # read features \n    my $fin = Bio::FeatureIO->new(-file=>'vecscreen.out',\n                                  -format=>'vecscreen_simple');\n    my @vec_regions;\n    while (my $f = $fin->next_feature) {\n      push @vec_regions, $f;\n    }\n    \n    # write features NOT IMPLEMENTED\n\n=head1 DESCRIPTION\n\nvecscreen is a system for quickly identifying segments of a nucleic\nacid sequence that may be of vector origin.  NCBI developed vecscreen\nto minimize the incidence and impact of vector contamination in public\nsequence databases.  GenBank Annotation Staff use vecscreen to verify\nthat sequences submitted for inclusion in the database are free from\ncontaminating vector sequence. Any sequence can be screened for vector\ncontamination using vecscreen.\n\nThis module provides parsing for vecscreen '-f 3' output, described in\nthe vecscreen documentation as 'Text list, no alignments'\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n bioperl-l@bioperl.org                  - General discussion\n http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Robert Buels\n\nEmail rmb32 AT cornell.edu\n\n=head1 CONTRIBUTORS\n\nBased on ptt.pm by Torsten Seeman\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::FeatureIO::vecscreen_simple;\n\nuse strict;\nuse base qw(Bio::FeatureIO);\nuse Bio::SeqFeature::Generic;\n\n=head2 _initialize\n\nTitle   : _initialize\nFunction: Reading? parses the header of the input\n          Writing? ","label":"_initialize($self,%arg)"}},{"line":94,"containerName":"Bio::SeqFeature","kind":2,"name":"Generic"},{"containerName":"_initialize","kind":12,"name":"SUPER","line":96},{"kind":12,"name":"parse_state","line":99},{"kind":12,"name":"seqname","line":99},{"line":100,"kind":12,"name":"parse_state"},{"kind":12,"name":"matchtype","line":100},{"kind":12,"range":{"start":{"character":0,"line":117},"end":{"line":165,"character":9999}},"line":117,"definition":"sub","name":"next_feature","containerName":"main::","children":[{"line":118,"localvar":"my","containerName":"next_feature","kind":13,"name":"$self","definition":"my"},{"name":"$self","containerName":"next_feature","kind":13,"line":119},{"name":"mode","kind":12,"containerName":"next_feature","line":119},{"line":121,"name":"$line","localvar":"my","containerName":"next_feature","kind":13,"definition":"my"},{"line":121,"name":"$self","containerName":"next_feature","kind":13},{"containerName":"next_feature","kind":12,"name":"_readline","line":121},{"line":122,"containerName":"next_feature","kind":13,"name":"$line"},{"kind":13,"containerName":"next_feature","name":"$line","line":123},{"kind":13,"containerName":"next_feature","name":"$self","line":124},{"line":125,"name":"$line","kind":13,"containerName":"next_feature"},{"name":"$self","kind":13,"containerName":"next_feature","line":126},{"line":126,"name":"warn","containerName":"next_feature","kind":12},{"name":"$line","containerName":"next_feature","kind":13,"line":127},{"kind":13,"containerName":"next_feature","name":"$self","line":129},{"line":130,"name":"$self","containerName":"next_feature","kind":13},{"line":130,"name":"throw","kind":12,"containerName":"next_feature"},{"line":134,"containerName":"next_feature","localvar":"my","kind":13,"name":"$lcline","definition":"my"},{"name":"$line","kind":13,"containerName":"next_feature","line":134},{"name":"$line","kind":13,"containerName":"next_feature","line":136},{"definition":"my","containerName":"next_feature","localvar":"my","kind":13,"name":"$s","line":137},{"name":"$e","containerName":"next_feature","kind":13,"line":137},{"definition":"my","line":139,"localvar":"my","kind":13,"containerName":"next_feature","name":"$matchtype"},{"name":"$self","kind":13,"containerName":"next_feature","line":139},{"containerName":"next_feature","kind":13,"name":"$matchtype","line":140},{"line":141,"name":"new","kind":12,"containerName":"next_feature"},{"kind":13,"containerName":"next_feature","name":"$s","line":141},{"name":"$e","kind":13,"containerName":"next_feature","line":142},{"kind":13,"containerName":"next_feature","name":"$matchtype","line":143},{"containerName":"next_feature","kind":13,"name":"$self","line":144},{"name":"$lcline","containerName":"next_feature","kind":13,"line":146},{"line":147,"containerName":"next_feature","kind":13,"name":"$self"},{"line":148,"kind":13,"containerName":"next_feature","name":"$lcline"},{"line":149,"name":"$self","kind":13,"containerName":"next_feature"},{"line":149,"containerName":"next_feature","kind":13,"name":"$lcline"},{"line":151,"kind":13,"containerName":"next_feature","name":"$self"},{"containerName":"next_feature","kind":12,"name":"throw","line":151},{"line":156,"name":"$self","kind":13,"containerName":"next_feature"},{"name":"$self","containerName":"next_feature","kind":13,"line":160}]},{"name":"parse_state","kind":12,"line":124},{"name":"seqname","kind":12,"line":124},{"line":129,"kind":12,"name":"parse_state"},{"line":129,"name":"seqname","kind":12},{"name":"parse_state","kind":12,"line":139},{"line":139,"name":"matchtype","kind":12},{"name":"Bio","containerName":"SeqFeature::Generic","kind":12,"line":141},{"line":144,"kind":12,"name":"parse_state"},{"kind":12,"name":"seqname","line":144},{"line":147,"kind":12,"name":"parse_state"},{"kind":12,"name":"seqname","line":147},{"line":149,"name":"parse_state","kind":12},{"name":"matchtype","kind":12,"line":149},{"line":156,"name":"parse_state","kind":12},{"kind":12,"name":"seqname","line":156},{"line":160,"name":"parse_state","kind":12},{"line":160,"kind":12,"name":"matchtype"},{"definition":"sub","children":[{"line":179,"containerName":"write_feature","kind":12,"name":"throw_not_implemented"}],"name":"write_feature","containerName":"main::","line":178,"range":{"end":{"line":180,"character":9999},"start":{"character":0,"line":178}},"kind":12}],"version":5}