{"version":5,"vars":[{"line":97,"containerName":"","kind":2,"name":"base"},{"range":{"end":{"line":170,"character":9999},"start":{"line":118,"character":0}},"kind":12,"line":118,"signature":{"documentation":"1;\n# $Id: Utils.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Coordinate::Utils\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::Utils - Additional methods to create Bio::Coordinate objects\n\n=head1 SYNOPSIS\n\n    use Bio::Coordinate::Utils;\n    # get a Bio::Align::AlignI compliant object, $aln, somehow\n    # it could be a Bio::SimpleAlign\n\n    $mapper = Bio::Coordinate::Utils->from_align($aln, 1);\n\n    # Build a set of mappers which will map, for each sequence,\n    # that sequence position in the alignment (exon position to alignment \n    # position) \n    my @mappers = Bio::Coordinate::Utils->from_seq_to_alignmentpos($aln);\n\n\n=head1 DESCRIPTION\n\nThis class is a holder of methods that work on or create\nBio::Coordinate::MapperI- compliant objects. . These methods are not\npart of the Bio::Coordinate::MapperI interface and should in general\nnot be essential to the primary function of sequence objects. If you\nare thinking of adding essential functions, it might be better to\ncreate your own sequence class.  See L<Bio::PrimarySeqI>,\nL<Bio::PrimarySeq>, and L<Bio::Seq> for more.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\nJason Stajich jason at bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Coordinate::Utils;\n\nuse Bio::Location::Simple;\nuse Bio::Coordinate::Pair;\nuse Bio::Coordinate::Collection;\n\nuse strict;\n\nuse base qw(Bio::Root::Root);\n# new inherited from Root\n\n=head2 from_align\n\n Title   : from_align\n Usage   : $mapper = Bio::Coordinate::Utils->from_align($aln, 1);\n Function:\n           Create a mapper out of an alignment.\n           The mapper will return a value only when both ends of\n           the input range find a match.\n\n           Note: This implementation works only on pairwise alignments\n           and is not yet well tested!\n\n Returns : A Bio::Coordinate::MapperI\n Args    : Bio::Align::AlignI object\n           Id for the reference sequence, optional","parameters":[{"label":"$self"},{"label":"$aln"},{"label":"$ref"}],"label":"from_align($self,$aln,$ref)"},"name":"from_align","containerName":"main::","children":[{"line":119,"localvar":"my","containerName":"from_align","kind":13,"name":"$self","definition":"my"},{"line":119,"name":"$aln","kind":13,"containerName":"from_align"},{"name":"$ref","kind":13,"containerName":"from_align","line":119},{"containerName":"from_align","kind":13,"name":"$aln","line":121},{"line":121,"containerName":"from_align","kind":12,"name":"isa"},{"containerName":"from_align","kind":13,"name":"$self","line":122},{"kind":12,"containerName":"from_align","name":"throw","line":122},{"line":122,"name":"$aln","containerName":"from_align","kind":13},{"line":125,"name":"$ref","kind":13,"containerName":"from_align"},{"name":"$collection","containerName":"from_align","localvar":"my","kind":13,"line":127,"definition":"my"},{"line":127,"kind":12,"containerName":"from_align","name":"new"},{"line":132,"name":"$aln","kind":13,"containerName":"from_align"},{"name":"map_chars","kind":12,"containerName":"from_align","line":132},{"definition":"my","line":133,"name":"$cs","localvar":"my","kind":13,"containerName":"from_align"},{"containerName":"from_align","kind":13,"name":"$aln","line":133},{"containerName":"from_align","kind":12,"name":"gap_line","line":133},{"name":"$seq1","kind":13,"localvar":"my","containerName":"from_align","line":134,"definition":"my"},{"name":"$aln","kind":13,"containerName":"from_align","line":134},{"line":134,"kind":12,"containerName":"from_align","name":"get_seq_by_pos"},{"line":135,"kind":13,"localvar":"my","containerName":"from_align","name":"$seq2","definition":"my"},{"name":"$aln","containerName":"from_align","kind":13,"line":135},{"line":135,"containerName":"from_align","kind":12,"name":"get_seq_by_pos"},{"line":136,"kind":13,"containerName":"from_align","name":"$cs"},{"definition":"my","line":138,"localvar":"my","containerName":"from_align","kind":13,"name":"$lenmatch"},{"definition":"my","line":139,"kind":13,"localvar":"my","containerName":"from_align","name":"$start"},{"name":"$cs","containerName":"from_align","kind":13,"line":139},{"line":139,"name":"$lenmatch","kind":13,"containerName":"from_align"},{"definition":"my","name":"$end","kind":13,"localvar":"my","containerName":"from_align","line":140},{"line":140,"name":"$start","containerName":"from_align","kind":13},{"line":140,"name":"$lenmatch","containerName":"from_align","kind":13},{"definition":"my","kind":13,"localvar":"my","containerName":"from_align","name":"$match1","line":141},{"kind":12,"containerName":"from_align","name":"new","line":142},{"line":142,"containerName":"from_align","kind":13,"name":"$seq1"},{"kind":12,"containerName":"from_align","name":"id","line":142},{"line":143,"kind":13,"containerName":"from_align","name":"$seq1"},{"name":"location_from_column","kind":12,"containerName":"from_align","line":143},{"line":143,"name":"$start","kind":13,"containerName":"from_align"},{"name":"start","kind":12,"containerName":"from_align","line":143},{"name":"$seq1","containerName":"from_align","kind":13,"line":144},{"line":144,"kind":12,"containerName":"from_align","name":"location_from_column"},{"name":"$end","containerName":"from_align","kind":13,"line":144},{"name":"start","containerName":"from_align","kind":12,"line":144},{"name":"$seq1","containerName":"from_align","kind":13,"line":145},{"name":"strand","kind":12,"containerName":"from_align","line":145},{"definition":"my","kind":13,"localvar":"my","containerName":"from_align","name":"$match2","line":147},{"name":"new","containerName":"from_align","kind":12,"line":148},{"line":148,"name":"$seq2","kind":13,"containerName":"from_align"},{"line":148,"containerName":"from_align","kind":12,"name":"id"},{"line":149,"kind":13,"containerName":"from_align","name":"$seq2"},{"line":149,"kind":12,"containerName":"from_align","name":"location_from_column"},{"line":149,"name":"$start","kind":13,"containerName":"from_align"},{"line":149,"name":"start","containerName":"from_align","kind":12},{"line":150,"name":"$seq2","kind":13,"containerName":"from_align"},{"kind":12,"containerName":"from_align","name":"location_from_column","line":150},{"name":"$end","kind":13,"containerName":"from_align","line":150},{"containerName":"from_align","kind":12,"name":"start","line":150},{"containerName":"from_align","kind":13,"name":"$seq2","line":151},{"line":151,"name":"strand","containerName":"from_align","kind":12},{"line":153,"name":"$pair","localvar":"my","kind":13,"containerName":"from_align","definition":"my"},{"line":154,"containerName":"from_align","kind":12,"name":"new"},{"line":154,"kind":13,"containerName":"from_align","name":"$match1"},{"line":156,"name":"$match2","containerName":"from_align","kind":13},{"line":157,"kind":13,"containerName":"from_align","name":"$pair"},{"name":"test","kind":12,"containerName":"from_align","line":157},{"kind":13,"containerName":"from_align","name":"$self","line":158},{"kind":12,"containerName":"from_align","name":"warn","line":158},{"containerName":"from_align","kind":13,"name":"$match1","line":160},{"line":160,"containerName":"from_align","kind":12,"name":"to_FTstring"},{"name":"$match1","containerName":"from_align","kind":13,"line":161},{"kind":12,"containerName":"from_align","name":"length","line":161},{"line":162,"kind":13,"containerName":"from_align","name":"$match2"},{"name":"to_FTstring","kind":12,"containerName":"from_align","line":162},{"name":"$match2","kind":13,"containerName":"from_align","line":163},{"line":163,"name":"length","kind":12,"containerName":"from_align"},{"line":165,"kind":13,"containerName":"from_align","name":"$collection"},{"line":165,"name":"add_mapper","containerName":"from_align","kind":12},{"containerName":"from_align","kind":13,"name":"$pair","line":165},{"kind":13,"containerName":"from_align","name":"$collection","line":167},{"line":167,"name":"each_mapper","containerName":"from_align","kind":12},{"line":167,"name":"$collection","containerName":"from_align","kind":13},{"kind":12,"containerName":"from_align","name":"mapper_count","line":167},{"line":168,"name":"$collection","kind":13,"containerName":"from_align"}],"detail":"($self,$aln,$ref)","definition":"sub"},{"line":127,"containerName":"Coordinate::Collection","kind":12,"name":"Bio"},{"line":141,"name":"Bio","kind":12,"containerName":"Location::Simple"},{"line":147,"name":"Bio","containerName":"Location::Simple","kind":12},{"name":"Bio","kind":12,"containerName":"Coordinate::Pair","line":153},{"signature":{"documentation":"1;\n# $Id: Utils.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Coordinate::Utils\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::Utils - Additional methods to create Bio::Coordinate objects\n\n=head1 SYNOPSIS\n\n    use Bio::Coordinate::Utils;\n    # get a Bio::Align::AlignI compliant object, $aln, somehow\n    # it could be a Bio::SimpleAlign\n\n    $mapper = Bio::Coordinate::Utils->from_align($aln, 1);\n\n    # Build a set of mappers which will map, for each sequence,\n    # that sequence position in the alignment (exon position to alignment \n    # position) \n    my @mappers = Bio::Coordinate::Utils->from_seq_to_alignmentpos($aln);\n\n\n=head1 DESCRIPTION\n\nThis class is a holder of methods that work on or create\nBio::Coordinate::MapperI- compliant objects. . These methods are not\npart of the Bio::Coordinate::MapperI interface and should in general\nnot be essential to the primary function of sequence objects. If you\nare thinking of adding essential functions, it might be better to\ncreate your own sequence class.  See L<Bio::PrimarySeqI>,\nL<Bio::PrimarySeq>, and L<Bio::Seq> for more.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\nJason Stajich jason at bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Coordinate::Utils;\n\nuse Bio::Location::Simple;\nuse Bio::Coordinate::Pair;\nuse Bio::Coordinate::Collection;\n\nuse strict;\n\nuse base qw(Bio::Root::Root);\n# new inherited from Root\n\n=head2 from_align\n\n Title   : from_align\n Usage   : $mapper = Bio::Coordinate::Utils->from_align($aln, 1);\n Function:\n           Create a mapper out of an alignment.\n           The mapper will return a value only when both ends of\n           the input range find a match.\n\n           Note: This implementation works only on pairwise alignments\n           and is not yet well tested!\n\n Returns : A Bio::Coordinate::MapperI\n Args    : Bio::Align::AlignI object\n           Id for the reference sequence, optional\n\n\nsub from_align {\n   my ($self, $aln, $ref ) = @_;\n\n   $aln->isa('Bio::Align::AlignI') ||\n       $self->throw('Not a Bio::Align::AlignI object but ['. ref($aln). ']');\n\n   # default reference sequence to the first sequence\n   $ref ||= 1;\n   \n   my $collection = Bio::Coordinate::Collection->new(-return_match=>1);\n\n   # this works only for pairs, so split the MSA\n   # take the ref\n   #foreach remaining seq in aln, do:\n   $aln->map_chars('\\.','-');\n   my $cs = $aln->gap_line;\n   my $seq1 = $aln->get_seq_by_pos(1);\n   my $seq2 = $aln->get_seq_by_pos(2);   \n   while ( $cs =~ /([^\\-]+)/g) {\n       # alignment coordinates\n       my $lenmatch = length($1);\n       my $start = pos($cs) - $lenmatch +1;\n       my $end   = $start + $lenmatch -1;\n       my $match1 = Bio::Location::Simple->new\n\t   (-seq_id => $seq1->id,\n\t    -start  => $seq1->location_from_column($start)->start,\n\t    -end    => $seq1->location_from_column($end)->start,\n\t    -strand => $seq1->strand );\n\n       my $match2 = Bio::Location::Simple->new\n\t   (-seq_id => $seq2->id,\n\t    -start  => $seq2->location_from_column($start)->start,\n\t    -end    => $seq2->location_from_column($end)->start,\n\t    -strand => $seq2->strand );       \n       \n       my $pair = Bio::Coordinate::Pair->new\n\t   (-in  => $match1,\n\t    -out => $match2\n\t    );\n       unless( $pair->test ) {\n\t   $self->warn(join(\"\",\n\t\t\t    \"pair align did not pass test ($start..$end):\\n\",\n\t\t\t    \"\\tm1=\",$match1->to_FTstring(), \" len=\",\n\t\t\t    $match1->length, \n\t\t\t    \" m2=\", $match2->to_FTstring(),\" len=\", \n\t\t\t    $match2->length,\"\\n\"));\n       }\n       $collection->add_mapper($pair);\n   }\n   return ($collection->each_mapper)[0] if $collection->mapper_count == 1;\n   return $collection;\n\n}\n\n=head2 from_seq_to_alignmentpos\n\n Title   : from_seq_to_alignmentpos\n Usage   : $mapper = Bio::Coordinate::Utils->from_seq_to_alignmentpos($aln, 1);\n Function:\n           Create a mapper out of an alignment.\n           The mapper will map the position of a sequence into that position\n           in the alignment.\n\n           Will work on alignments of >= 2 sequences \n Returns : An array of Bio::Coordinate::MapperI\n Args    : Bio::Align::AlignI object","parameters":[{"label":"$self"},{"label":"$aln"}],"label":"from_seq_to_alignmentpos($self,$aln)"},"line":188,"range":{"end":{"character":9999,"line":240},"start":{"character":0,"line":188}},"kind":12,"definition":"sub","detail":"($self,$aln)","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"from_seq_to_alignmentpos","line":189},{"name":"$aln","containerName":"from_seq_to_alignmentpos","kind":13,"line":189},{"name":"$aln","kind":13,"containerName":"from_seq_to_alignmentpos","line":191},{"line":191,"name":"isa","containerName":"from_seq_to_alignmentpos","kind":12},{"kind":13,"containerName":"from_seq_to_alignmentpos","name":"$self","line":192},{"line":192,"kind":12,"containerName":"from_seq_to_alignmentpos","name":"throw"},{"line":192,"name":"$aln","kind":13,"containerName":"from_seq_to_alignmentpos"},{"kind":13,"localvar":"my","containerName":"from_seq_to_alignmentpos","name":"@mappers","line":195,"definition":"my"},{"line":196,"containerName":"from_seq_to_alignmentpos","kind":13,"name":"$aln"},{"line":196,"name":"map_chars","kind":12,"containerName":"from_seq_to_alignmentpos"},{"localvar":"my","containerName":"from_seq_to_alignmentpos","kind":13,"name":"$seq","line":197,"definition":"my"},{"line":197,"name":"$aln","containerName":"from_seq_to_alignmentpos","kind":13},{"kind":12,"containerName":"from_seq_to_alignmentpos","name":"each_seq","line":197},{"definition":"my","line":198,"name":"$collection","kind":13,"localvar":"my","containerName":"from_seq_to_alignmentpos"},{"containerName":"from_seq_to_alignmentpos","kind":12,"name":"new","line":198},{"line":199,"name":"$cs","localvar":"my","kind":13,"containerName":"from_seq_to_alignmentpos","definition":"my"},{"line":199,"name":"$seq","kind":13,"containerName":"from_seq_to_alignmentpos"},{"line":199,"name":"seq","kind":12,"containerName":"from_seq_to_alignmentpos"},{"name":"$cs","kind":13,"containerName":"from_seq_to_alignmentpos","line":201},{"definition":"my","containerName":"from_seq_to_alignmentpos","localvar":"my","kind":13,"name":"$lenmatch","line":203},{"definition":"my","line":204,"name":"$start","kind":13,"localvar":"my","containerName":"from_seq_to_alignmentpos"},{"line":204,"containerName":"from_seq_to_alignmentpos","kind":13,"name":"$cs"},{"line":204,"name":"$lenmatch","containerName":"from_seq_to_alignmentpos","kind":13},{"line":205,"localvar":"my","kind":13,"containerName":"from_seq_to_alignmentpos","name":"$end","definition":"my"},{"line":205,"name":"$start","kind":13,"containerName":"from_seq_to_alignmentpos"},{"containerName":"from_seq_to_alignmentpos","kind":13,"name":"$lenmatch","line":205},{"line":207,"containerName":"from_seq_to_alignmentpos","localvar":"my","kind":13,"name":"$match1","definition":"my"},{"kind":12,"containerName":"from_seq_to_alignmentpos","name":"new","line":208},{"line":208,"kind":13,"containerName":"from_seq_to_alignmentpos","name":"$seq"},{"name":"id","containerName":"from_seq_to_alignmentpos","kind":12,"line":208},{"line":209,"containerName":"from_seq_to_alignmentpos","kind":13,"name":"$seq"},{"line":209,"name":"location_from_column","containerName":"from_seq_to_alignmentpos","kind":12},{"line":209,"kind":13,"containerName":"from_seq_to_alignmentpos","name":"$start"},{"name":"start","containerName":"from_seq_to_alignmentpos","kind":12,"line":209},{"name":"$seq","containerName":"from_seq_to_alignmentpos","kind":13,"line":210},{"name":"location_from_column","containerName":"from_seq_to_alignmentpos","kind":12,"line":210},{"line":210,"name":"$end","kind":13,"containerName":"from_seq_to_alignmentpos"},{"line":210,"name":"start","kind":12,"containerName":"from_seq_to_alignmentpos"},{"line":211,"name":"$seq","containerName":"from_seq_to_alignmentpos","kind":13},{"line":211,"name":"strand","containerName":"from_seq_to_alignmentpos","kind":12},{"definition":"my","kind":13,"localvar":"my","containerName":"from_seq_to_alignmentpos","name":"$match2","line":213},{"line":214,"name":"new","containerName":"from_seq_to_alignmentpos","kind":12},{"line":215,"name":"$start","kind":13,"containerName":"from_seq_to_alignmentpos"},{"containerName":"from_seq_to_alignmentpos","kind":13,"name":"$end","line":216},{"line":219,"localvar":"my","kind":13,"containerName":"from_seq_to_alignmentpos","name":"$pair","definition":"my"},{"kind":12,"containerName":"from_seq_to_alignmentpos","name":"new","line":220},{"kind":13,"containerName":"from_seq_to_alignmentpos","name":"$match1","line":220},{"line":222,"containerName":"from_seq_to_alignmentpos","kind":13,"name":"$match2"},{"name":"$pair","containerName":"from_seq_to_alignmentpos","kind":13,"line":223},{"line":223,"containerName":"from_seq_to_alignmentpos","kind":12,"name":"test"},{"name":"$self","kind":13,"containerName":"from_seq_to_alignmentpos","line":224},{"kind":12,"containerName":"from_seq_to_alignmentpos","name":"warn","line":224},{"line":226,"kind":13,"containerName":"from_seq_to_alignmentpos","name":"$match1"},{"name":"to_FTstring","containerName":"from_seq_to_alignmentpos","kind":12,"line":226},{"line":227,"kind":13,"containerName":"from_seq_to_alignmentpos","name":"$match1"},{"name":"length","kind":12,"containerName":"from_seq_to_alignmentpos","line":227},{"name":"$match2","kind":13,"containerName":"from_seq_to_alignmentpos","line":228},{"line":228,"kind":12,"containerName":"from_seq_to_alignmentpos","name":"to_FTstring"},{"kind":13,"containerName":"from_seq_to_alignmentpos","name":"$match2","line":229},{"name":"length","containerName":"from_seq_to_alignmentpos","kind":12,"line":229},{"line":231,"kind":13,"containerName":"from_seq_to_alignmentpos","name":"$collection"},{"line":231,"containerName":"from_seq_to_alignmentpos","kind":12,"name":"add_mapper"},{"containerName":"from_seq_to_alignmentpos","kind":13,"name":"$pair","line":231},{"line":233,"containerName":"from_seq_to_alignmentpos","kind":13,"name":"$collection"},{"line":233,"kind":12,"containerName":"from_seq_to_alignmentpos","name":"mapper_count"},{"line":234,"kind":13,"containerName":"from_seq_to_alignmentpos","name":"@mappers"},{"line":234,"name":"$collection","kind":13,"containerName":"from_seq_to_alignmentpos"},{"line":234,"name":"each_mapper","containerName":"from_seq_to_alignmentpos","kind":12},{"line":236,"name":"@mappers","containerName":"from_seq_to_alignmentpos","kind":13},{"name":"$collection","kind":13,"containerName":"from_seq_to_alignmentpos","line":236},{"line":239,"containerName":"from_seq_to_alignmentpos","kind":13,"name":"@mappers"}],"containerName":"main::","name":"from_seq_to_alignmentpos"},{"name":"Bio","containerName":"Coordinate::Collection","kind":12,"line":198},{"line":207,"name":"Bio","kind":12,"containerName":"Location::Simple"},{"name":"Bio","containerName":"Location::Simple","kind":12,"line":213},{"containerName":"Coordinate::Pair","kind":12,"name":"Bio","line":219}]}