{"version":5,"vars":[{"line":91,"kind":2,"containerName":"","name":"base"},{"detail":"($class,@args)","definition":"sub","containerName":"main::","name":"new","children":[{"line":104,"containerName":"new","localvar":"my","kind":13,"name":"$class","definition":"my"},{"kind":13,"containerName":"new","name":"@args","line":104},{"line":105,"containerName":"new","localvar":"my","kind":13,"name":"$self","definition":"my"},{"line":105,"name":"$class","kind":13,"containerName":"new"},{"name":"@args","kind":13,"containerName":"new","line":105}],"signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"__END__\n# $Id: IO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::CodonUsage::IO\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Richard Adams (richard.adams@ed.ac.uk)\n#\n# Copyright Richard Adams\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::CodonUsage::IO - for reading and writing codon usage tables to file\n\n=head1 SYNOPSIS\n\n  use Bio::CodonUsage::IO;\n\n  ## read in a codon usage file\n  my $io = Bio::CodonUsage::IO->new(-file => \"in\");\n  my $cut = $io->next_data();\n\n  ## write it out again\n  my $out = Bio::CodonUsage::IO->new(-file => \">out\");\n  $out->write_data($cut);\n\n=head1 DESCRIPTION\n\nThis class provides standard IO methods for reading and writing text files\nof codon usage tables. These tables can initially be retrieved using\nBio::DB::CUTG. At present only this format is supported for read/write. \n\nReading a CUTG will return a Bio::CodonUsage::Table object. \n\n=head1 SEE ALSO\n\nL<Bio::Tools::CodonTable>, \nL<Bio::WebAgent>,\nL<Bio::CodonUsage::Table>,\nL<Bio::CodonUsage::IO>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS\n\nRichard Adams, Richard.Adams@ed.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin\n\npackage Bio::CodonUsage::IO;\nuse Bio::CodonUsage::Table;\n\nuse base qw(Bio::Root::IO);\n\n=head2  new\n\n Title  : new\n Usage  : my $io = Bio::CodonUsage::IO->new(-file => \"CUTfile\");\n Purpose: To  read/write a Bio:CodonUsage::Table object  \n Returns: A  Bio:CodonUsage::IO object\n Args   : a file or file handle ","label":"new($class,@args)"},"range":{"start":{"character":0,"line":103},"end":{"character":9999,"line":106}},"kind":12,"line":103},{"kind":12,"containerName":"new","name":"SUPER","line":105},{"kind":12,"range":{"start":{"character":0,"line":119},"end":{"character":9999,"line":123}},"line":119,"name":"next_data","containerName":"main::","children":[{"line":120,"name":"$self","containerName":"next_data","localvar":"my","kind":13,"definition":"my"},{"name":"$cut","localvar":"my","containerName":"next_data","kind":13,"line":121,"definition":"my"},{"containerName":"next_data","kind":13,"name":"$self","line":121},{"kind":12,"containerName":"next_data","name":"_parse","line":121},{"line":122,"name":"$cut","kind":13,"containerName":"next_data"}],"definition":"sub"},{"signature":{"documentation":"__END__\n# $Id: IO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::CodonUsage::IO\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Richard Adams (richard.adams@ed.ac.uk)\n#\n# Copyright Richard Adams\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::CodonUsage::IO - for reading and writing codon usage tables to file\n\n=head1 SYNOPSIS\n\n  use Bio::CodonUsage::IO;\n\n  ## read in a codon usage file\n  my $io = Bio::CodonUsage::IO->new(-file => \"in\");\n  my $cut = $io->next_data();\n\n  ## write it out again\n  my $out = Bio::CodonUsage::IO->new(-file => \">out\");\n  $out->write_data($cut);\n\n=head1 DESCRIPTION\n\nThis class provides standard IO methods for reading and writing text files\nof codon usage tables. These tables can initially be retrieved using\nBio::DB::CUTG. At present only this format is supported for read/write. \n\nReading a CUTG will return a Bio::CodonUsage::Table object. \n\n=head1 SEE ALSO\n\nL<Bio::Tools::CodonTable>, \nL<Bio::WebAgent>,\nL<Bio::CodonUsage::Table>,\nL<Bio::CodonUsage::IO>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS\n\nRichard Adams, Richard.Adams@ed.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin\n\npackage Bio::CodonUsage::IO;\nuse Bio::CodonUsage::Table;\n\nuse base qw(Bio::Root::IO);\n\n=head2  new\n\n Title  : new\n Usage  : my $io = Bio::CodonUsage::IO->new(-file => \"CUTfile\");\n Purpose: To  read/write a Bio:CodonUsage::Table object  \n Returns: A  Bio:CodonUsage::IO object\n Args   : a file or file handle \n\n\nsub new  {\n\tmy ($class , @args) = @_;\n\tmy $self = $class->SUPER::new(@args);\n}\n\n\n=head2  next_data\n\n Title  : next_data\n Usage  : my $cut = $io->next_data();\n Purpose: To  obtain a Bio:CodonUsage::Table object \n Returns: A  Bio:CodonUsage::Table object\n Args   : none\n\n\nsub next_data {\n\tmy $self = shift;\n\tmy $cut = $self->_parse;\n\treturn $cut;\n}\n\n=head2  write_data\n\n Title  : write_data\n Usage  : $io->write_data($cut);\n Purpose: To  write a CUT to file\n Returns: void\n Args   : a Bio::CodonUsage::Table object reference ","parameters":[{"label":"$self"},{"label":"$cut"}],"label":"write_data($self,$cut)"},"range":{"end":{"character":9999,"line":180},"start":{"line":136,"character":0}},"kind":12,"line":136,"detail":"($self,$cut)","definition":"sub","name":"write_data","containerName":"main::","children":[{"localvar":"my","kind":13,"containerName":"write_data","name":"$self","line":137,"definition":"my"},{"kind":13,"containerName":"write_data","name":"$cut","line":137},{"name":"$cut","kind":13,"containerName":"write_data","line":138},{"line":138,"name":"$cut","kind":13,"containerName":"write_data"},{"line":138,"name":"isa","kind":12,"containerName":"write_data"},{"line":139,"containerName":"write_data","kind":13,"name":"$self"},{"line":139,"containerName":"write_data","kind":12,"name":"throw"},{"line":141,"localvar":"my","kind":13,"containerName":"write_data","name":"$outstring","definition":"my"},{"name":"$sp_string","localvar":"my","kind":13,"containerName":"write_data","line":143,"definition":"my"},{"name":"$cut","kind":13,"containerName":"write_data","line":143},{"kind":12,"containerName":"write_data","name":"species","line":143},{"line":143,"name":"$cut","kind":13,"containerName":"write_data"},{"containerName":"write_data","kind":12,"name":"_gb_db","line":143},{"line":144,"containerName":"write_data","kind":13,"name":"$cut"},{"line":144,"name":"cds_count","containerName":"write_data","kind":12},{"line":145,"name":"$outstring","kind":13,"containerName":"write_data"},{"containerName":"write_data","kind":13,"name":"$sp_string","line":145},{"containerName":"write_data","localvar":"my","kind":13,"name":"$colhead","line":146,"definition":"my"},{"name":"$outstring","kind":13,"containerName":"write_data","line":148},{"containerName":"write_data","kind":13,"name":"$colhead","line":148},{"definition":"my","line":151,"name":"$ctable","localvar":"my","containerName":"write_data","kind":13},{"containerName":"write_data","kind":12,"name":"new","line":151},{"definition":"my","line":153,"kind":13,"localvar":"my","containerName":"write_data","name":"$f"},{"definition":"my","line":154,"containerName":"write_data","localvar":"my","kind":13,"name":"$s"},{"line":155,"containerName":"write_data","localvar":"my","kind":13,"name":"$t","definition":"my"},{"kind":13,"containerName":"write_data","name":"$cod","line":156},{"line":156,"name":"$f","containerName":"write_data","kind":13},{"line":156,"containerName":"write_data","kind":13,"name":"$s"},{"name":"$t","kind":13,"containerName":"write_data","line":156},{"definition":"my","line":157,"localvar":"my","kind":13,"containerName":"write_data","name":"$aa"},{"containerName":"write_data","kind":13,"name":"$Bio","line":157},{"line":157,"name":"$ctable","containerName":"write_data","kind":13},{"line":157,"name":"translate","containerName":"write_data","kind":12},{"containerName":"write_data","kind":13,"name":"$cod","line":157},{"definition":"my","line":158,"name":"$codstr","kind":13,"localvar":"my","containerName":"write_data"},{"name":"$aa","containerName":"write_data","kind":13,"line":160},{"line":160,"name":"$cod","containerName":"write_data","kind":13},{"definition":"my","kind":13,"localvar":"my","containerName":"write_data","name":"$tt","line":160},{"containerName":"write_data","kind":13,"name":"$cut","line":160},{"containerName":"write_data","kind":12,"name":"codon_count","line":160},{"line":160,"name":"$cod","containerName":"write_data","kind":13},{"line":161,"name":"$ll","localvar":"my","kind":13,"containerName":"write_data","definition":"my"},{"name":"$cut","kind":13,"containerName":"write_data","line":161},{"line":161,"containerName":"write_data","kind":13,"name":"$aa"},{"line":161,"name":"$cod","containerName":"write_data","kind":13},{"definition":"my","localvar":"my","containerName":"write_data","kind":13,"name":"$ss","line":162},{"line":162,"kind":13,"containerName":"write_data","name":"$cut"},{"kind":12,"containerName":"write_data","name":"codon_rel_frequency","line":162},{"line":162,"kind":13,"containerName":"write_data","name":"$cod"},{"kind":13,"containerName":"write_data","name":"$outstring","line":163},{"name":"$codstr","kind":13,"containerName":"write_data","line":163},{"line":165,"kind":13,"containerName":"write_data","name":"$outstring"},{"kind":13,"containerName":"write_data","name":"$outstring","line":168},{"name":"$outstring","kind":13,"containerName":"write_data","line":171},{"line":171,"kind":13,"containerName":"write_data","name":"$cut"},{"line":171,"containerName":"write_data","kind":12,"name":"get_coding_gc"},{"containerName":"write_data","kind":13,"name":"$outstring","line":172},{"line":172,"kind":13,"containerName":"write_data","name":"$cut"},{"name":"get_coding_gc","containerName":"write_data","kind":12,"line":172},{"name":"$outstring","kind":13,"containerName":"write_data","line":173},{"line":173,"name":"$cut","containerName":"write_data","kind":13},{"line":173,"kind":12,"containerName":"write_data","name":"get_coding_gc"},{"name":"$outstring","kind":13,"containerName":"write_data","line":174},{"line":174,"name":"$cut","kind":13,"containerName":"write_data"},{"line":174,"containerName":"write_data","kind":12,"name":"get_coding_gc"},{"name":"$outstring","containerName":"write_data","kind":13,"line":175},{"line":175,"containerName":"write_data","kind":13,"name":"$cut"},{"line":175,"kind":12,"containerName":"write_data","name":"genetic_code"},{"line":177,"name":"$self","containerName":"write_data","kind":13},{"name":"_print","containerName":"write_data","kind":12,"line":177},{"line":177,"kind":13,"containerName":"write_data","name":"$outstring"},{"line":178,"kind":13,"containerName":"write_data","name":"$self"},{"containerName":"write_data","kind":12,"name":"flush","line":178}]},{"name":"Bio","kind":12,"containerName":"CodonUsage::Table","line":138},{"line":151,"name":"Bio","kind":12,"containerName":"Tools::CodonTable"},{"kind":12,"containerName":"THREECODE","name":"SeqUtils","line":157},{"children":[{"name":"$self","localvar":"my","kind":13,"containerName":"_parse","line":183,"definition":"my"},{"definition":"my","line":184,"kind":13,"localvar":"my","containerName":"_parse","name":"$cdtableobj"},{"name":"new","kind":12,"containerName":"_parse","line":184},{"definition":"my","line":185,"name":"$line","containerName":"_parse","localvar":"my","kind":13},{"line":185,"name":"$self","kind":13,"containerName":"_parse"},{"line":185,"containerName":"_parse","kind":12,"name":"_readline"},{"containerName":"_parse","kind":13,"name":"$line","line":186},{"name":"$line","kind":13,"containerName":"_parse","line":187},{"line":190,"kind":13,"containerName":"_parse","name":"$line"},{"line":191,"containerName":"_parse","kind":13,"name":"$cdtableobj"},{"line":191,"containerName":"_parse","kind":12,"name":"species"},{"line":192,"containerName":"_parse","kind":13,"name":"$cdtableobj"},{"line":193,"kind":13,"containerName":"_parse","name":"$cdtableobj"},{"name":"cds_count","containerName":"_parse","kind":12,"line":193},{"line":197,"containerName":"_parse","kind":13,"name":"$line"},{"line":200,"name":"$cdtableobj","kind":13,"containerName":"_parse"},{"kind":13,"containerName":"_parse","name":"$line","line":209},{"line":210,"containerName":"_parse","kind":13,"name":"$cdtableobj"},{"name":"$line","containerName":"_parse","kind":13,"line":212},{"name":"$cdtableobj","kind":13,"containerName":"_parse","line":213},{"kind":13,"containerName":"_parse","name":"$line","line":215},{"containerName":"_parse","kind":13,"name":"$cdtableobj","line":216},{"line":218,"containerName":"_parse","kind":13,"name":"$line"},{"line":219,"name":"$cdtableobj","containerName":"_parse","kind":13},{"name":"$line","kind":13,"containerName":"_parse","line":222},{"line":223,"containerName":"_parse","kind":13,"name":"$cdtableobj"},{"name":"$cdtableobj","kind":13,"containerName":"_parse","line":227}],"containerName":"main::","name":"_parse","definition":"sub","line":182,"kind":12,"range":{"start":{"line":182,"character":0},"end":{"character":9999,"line":227}}},{"line":184,"name":"Bio","containerName":"CodonUsage::Table","kind":12},{"line":228,"name":"$cdtableobj","containerName":null,"kind":13},{"kind":12,"containerName":"main::","name":"warn","line":228},{"line":230,"kind":13,"containerName":null,"name":"$cdtableobj"}]}