{"vars":[{"kind":2,"containerName":"","name":"base","line":148},{"definition":"my","line":164,"name":"$entry","localvar":"my","kind":13,"containerName":null},{"kind":12,"range":{"start":{"line":166,"character":0},"end":{"character":9999,"line":187}},"line":166,"signature":{"parameters":[{"label":"$caller"},{"label":"@args"}],"documentation":"","label":"new($caller,@args)"},"containerName":"main::","name":"new","children":[{"definition":"my","name":"$caller","kind":13,"localvar":"my","containerName":"new","line":167},{"name":"@args","containerName":"new","kind":13,"line":167},{"definition":"my","line":168,"name":"$class","kind":13,"localvar":"my","containerName":"new"},{"line":168,"containerName":"new","kind":13,"name":"$caller"},{"kind":13,"containerName":"new","name":"$caller","line":168},{"containerName":"new","kind":13,"name":"$class","line":172},{"name":"$self","localvar":"my","containerName":"new","kind":13,"line":173,"definition":"my"},{"kind":13,"containerName":"new","name":"$class","line":173},{"kind":13,"containerName":"new","name":"@args","line":173},{"line":174,"name":"$self","kind":13,"containerName":"new"},{"kind":12,"containerName":"new","name":"_initialize","line":174},{"name":"@args","kind":13,"containerName":"new","line":174},{"line":175,"name":"$self","containerName":"new","kind":13},{"definition":"my","line":178,"kind":13,"localvar":"my","containerName":"new","name":"%param"},{"line":178,"kind":13,"containerName":"new","name":"@args"},{"containerName":"new","kind":13,"name":"@param","line":179},{"containerName":"new","kind":13,"name":"%param","line":179},{"name":"%param","containerName":"new","kind":13,"line":179},{"name":"$format","localvar":"my","kind":13,"containerName":"new","line":180,"definition":"my"},{"line":180,"name":"$param","containerName":"new","kind":13},{"containerName":"new","kind":13,"name":"$class","line":181},{"kind":12,"containerName":"new","name":"_guess_format","line":181},{"line":181,"kind":13,"containerName":"new","name":"$param"},{"line":181,"kind":13,"containerName":"new","name":"$ARGV"},{"containerName":"new","kind":13,"name":"$format","line":182},{"line":184,"name":"$class","containerName":"new","kind":13},{"kind":12,"containerName":"new","name":"_load_format_module","line":184},{"line":184,"name":"$format","containerName":"new","kind":13},{"name":"new","kind":12,"containerName":"new","line":185},{"containerName":"new","kind":13,"name":"@args","line":185}],"detail":"($caller,@args)","definition":"sub"},{"line":173,"containerName":"new","kind":12,"name":"SUPER"},{"signature":{"documentation":" _initialize is chained for all ClusterIO classes","parameters":[{"label":"$self"},{"label":"@args"}],"label":"_initialize($self,@args)"},"line":192,"range":{"end":{"character":9999,"line":196},"start":{"character":0,"line":192}},"kind":12,"definition":"sub","detail":"($self,@args)","children":[{"definition":"my","line":193,"name":"$self","localvar":"my","kind":13,"containerName":"_initialize"},{"name":"@args","containerName":"_initialize","kind":13,"line":193},{"name":"$self","kind":13,"containerName":"_initialize","line":195},{"line":195,"name":"_initialize_io","containerName":"_initialize","kind":12},{"line":195,"kind":13,"containerName":"_initialize","name":"@args"}],"containerName":"main::","name":"_initialize"},{"range":{"end":{"character":9999,"line":212},"start":{"line":209,"character":0}},"kind":12,"line":209,"signature":{"label":"next_cluster($self,$seq)","parameters":[{"label":"$self"},{"label":"$seq"}],"documentation":"1;\n# $Id: ClusterIO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::ClusterIO.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Andrew Macgregor <andrew@anatomy.otago.ac.nz>\n#\n# Copyright Andrew Macgregor, Jo-Ann Stanton, David Green\n# Molecular Embryology Group, Anatomy & Structural Biology, University of Otago\n# http://anatomy.otago.ac.nz/meg\n#\n# You may distribute this module under the same terms as perl itself\n#\n# _history\n#\n# May 7, 2002 - changed from UniGene.pm to more generic ClusterIO.pm\n# by Andrew Macgregor\n#\n# April 17, 2002 - Initial implementation by Andrew Macgregor\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::ClusterIO - Handler for Cluster Formats\n\n=head1 SYNOPSIS\n\n  #NB: This example is unigene specific\n\n  use Bio::ClusterIO;\n\n  $stream  = Bio::ClusterIO->new('-file' => \"Hs.data\", \n                                 '-format' => \"unigene\");\n  # note: we quote -format to keep older perl's from complaining.\n\n  while ( my $in = $stream->next_cluster() ) {\n      print $in->unigene_id() . \"\\n\";\n      while ( my $sequence = $in->next_seq() ) {\n          print $sequence->accession_number() . \"\\n\";\n      }\n  }\n  # Parsing errors are printed to STDERR.\n\n=head1 DESCRIPTION\n\nThe ClusterIO module works with the ClusterIO format module to read\nvarious cluster formats such as NCBI UniGene.\n\n\n=head1 CONSTRUCTORS\n\n=head2 Bio::ClusterIO-E<gt>new()\n\n   $str = Bio::ClusterIO->new(-file => 'filename',\n                              -format=>$format);\n\nThe new() class method constructs a new Bio::ClusterIO object.  The\nreturned object can be used to retrieve or print cluster\nobjects. new() accepts the following parameters:\n\n=over 4\n\n* -file\n\nA file path to be opened for reading.\n\n* -format\n\nSpecify the format of the file.  Supported formats include:\n\n   unigene\t\t*.data\tUniGene build files.\n   dbsnp\t\t*.xml\tdbSNP XML files\n\nIf no format is specified and a filename is given, then the module\nwill attempt to deduce it from the filename.  If this is unsuccessful,\nthe main UniGene build format is assumed.\n\nThe format name is case insensitive.  'UNIGENE', 'UniGene' and\n'unigene' are all supported, as are dbSNP, dbsnp, and DBSNP\n\n\n=head1 OBJECT METHODS\n\nSee below for more detailed summaries.  The main methods are:\n\n=head2 $cluster = $str-E<gt>next_cluster()\n\nFetch the next cluster from the stream.\n\n\n=head2 TIEHANDLE(), READLINE(), PRINT()\n\nThese I've left in here because they were in the SeqIO\nmodule. Feedback appreciated. There they provide the tie interface.\nSee L<perltie> for more details.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Andrew Macgregor\n\nEmail andrew@anatomy.otago.ac.nz\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#'\n# Let the code begin...\n\npackage Bio::ClusterIO;\n\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n\n\n=head2 new\n\n Title   : new\n Usage   : Bio::ClusterIO->new(-file => $filename, -format => 'format')\n Function: Returns a new cluster stream\n Returns : A Bio::ClusterIO::Handler initialised with the appropriate format\n Args    : -file => $filename\n           -format => format\n\n\n\nmy $entry = 0;\n\nsub new {\n    my ($caller,@args) = @_;\n    my $class = ref($caller) || $caller;\n    \n    # or do we want to call SUPER on an object if $caller is an\n    # object?\n    if( $class =~ /Bio::ClusterIO::(\\S+)/ ) {\n\tmy ($self) = $class->SUPER::new(@args);\t\n\t$self->_initialize(@args);\n\treturn $self;\n    } else { \n\n\tmy %param = @args;\n\t@param{ map { lc $_ } keys %param } = values %param; # lowercase keys\n\tmy $format = $param{'-format'} || \n\t    $class->_guess_format( $param{-file} || $ARGV[0] );\n\t$format = \"\\L$format\";\t# normalize capitalization to lower case\n\n\treturn unless( $class->_load_format_module($format) );\n\treturn \"Bio::ClusterIO::$format\"->new(@args);\n    }\n}\n\n\n# _initialize is chained for all ClusterIO classes\n\nsub _initialize {\n    my($self, @args) = @_;\n    # initialize the IO part\n    $self->_initialize_io(@args);\n}\n\n=head2 next_cluster\n\n Title   : next_cluster\n Usage   : $cluster = $stream->next_cluster()\n Function: Reads the next cluster object from the stream and returns it.\n Returns : a L<Bio::ClusterI> compliant object\n Args    : none"},"name":"next_cluster","containerName":"main::","children":[{"line":210,"name":"$self","containerName":"next_cluster","localvar":"my","kind":13,"definition":"my"},{"kind":13,"containerName":"next_cluster","name":"$seq","line":210},{"name":"$self","containerName":"next_cluster","kind":13,"line":211},{"containerName":"next_cluster","kind":12,"name":"throw","line":211}],"detail":"($self,$seq)","definition":"sub"},{"definition":"sub","children":[{"line":229,"localvar":"my","kind":13,"containerName":"cluster_factory","name":"$self","definition":"my"},{"name":"$self","containerName":"cluster_factory","kind":13,"line":231},{"line":232,"containerName":"cluster_factory","kind":13,"name":"$self"}],"containerName":"main::","name":"cluster_factory","line":228,"range":{"end":{"line":233,"character":9999},"start":{"line":228,"character":0}},"kind":12},{"line":248,"range":{"end":{"line":250,"character":9999},"start":{"character":0,"line":248}},"kind":12,"definition":"sub","children":[{"line":249,"name":"cluster_factory","kind":12,"containerName":"object_factory"}],"name":"object_factory","containerName":"main::"},{"name":"_load_format_module","containerName":"main::","children":[{"definition":"my","containerName":"_load_format_module","localvar":"my","kind":13,"name":"$self","line":264},{"line":264,"name":"$format","kind":13,"containerName":"_load_format_module"},{"definition":"my","line":265,"name":"$module","containerName":"_load_format_module","localvar":"my","kind":13},{"name":"$format","containerName":"_load_format_module","kind":13,"line":265},{"definition":"my","kind":13,"localvar":"my","containerName":"_load_format_module","name":"$ok","line":266},{"name":"$ok","kind":13,"containerName":"_load_format_module","line":269},{"line":269,"kind":13,"containerName":"_load_format_module","name":"$self"},{"kind":12,"containerName":"_load_format_module","name":"_load_module","line":269},{"line":269,"name":"$module","containerName":"_load_format_module","kind":13},{"line":278,"containerName":"_load_format_module","kind":13,"name":"$ok"}],"detail":"($self,$format)","definition":"sub","range":{"start":{"line":263,"character":0},"end":{"character":9999,"line":279}},"kind":12,"line":263,"signature":{"label":"_load_format_module($self,$format)","documentation":"1;\n# $Id: ClusterIO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::ClusterIO.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Andrew Macgregor <andrew@anatomy.otago.ac.nz>\n#\n# Copyright Andrew Macgregor, Jo-Ann Stanton, David Green\n# Molecular Embryology Group, Anatomy & Structural Biology, University of Otago\n# http://anatomy.otago.ac.nz/meg\n#\n# You may distribute this module under the same terms as perl itself\n#\n# _history\n#\n# May 7, 2002 - changed from UniGene.pm to more generic ClusterIO.pm\n# by Andrew Macgregor\n#\n# April 17, 2002 - Initial implementation by Andrew Macgregor\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::ClusterIO - Handler for Cluster Formats\n\n=head1 SYNOPSIS\n\n  #NB: This example is unigene specific\n\n  use Bio::ClusterIO;\n\n  $stream  = Bio::ClusterIO->new('-file' => \"Hs.data\", \n                                 '-format' => \"unigene\");\n  # note: we quote -format to keep older perl's from complaining.\n\n  while ( my $in = $stream->next_cluster() ) {\n      print $in->unigene_id() . \"\\n\";\n      while ( my $sequence = $in->next_seq() ) {\n          print $sequence->accession_number() . \"\\n\";\n      }\n  }\n  # Parsing errors are printed to STDERR.\n\n=head1 DESCRIPTION\n\nThe ClusterIO module works with the ClusterIO format module to read\nvarious cluster formats such as NCBI UniGene.\n\n\n=head1 CONSTRUCTORS\n\n=head2 Bio::ClusterIO-E<gt>new()\n\n   $str = Bio::ClusterIO->new(-file => 'filename',\n                              -format=>$format);\n\nThe new() class method constructs a new Bio::ClusterIO object.  The\nreturned object can be used to retrieve or print cluster\nobjects. new() accepts the following parameters:\n\n=over 4\n\n* -file\n\nA file path to be opened for reading.\n\n* -format\n\nSpecify the format of the file.  Supported formats include:\n\n   unigene\t\t*.data\tUniGene build files.\n   dbsnp\t\t*.xml\tdbSNP XML files\n\nIf no format is specified and a filename is given, then the module\nwill attempt to deduce it from the filename.  If this is unsuccessful,\nthe main UniGene build format is assumed.\n\nThe format name is case insensitive.  'UNIGENE', 'UniGene' and\n'unigene' are all supported, as are dbSNP, dbsnp, and DBSNP\n\n\n=head1 OBJECT METHODS\n\nSee below for more detailed summaries.  The main methods are:\n\n=head2 $cluster = $str-E<gt>next_cluster()\n\nFetch the next cluster from the stream.\n\n\n=head2 TIEHANDLE(), READLINE(), PRINT()\n\nThese I've left in here because they were in the SeqIO\nmodule. Feedback appreciated. There they provide the tie interface.\nSee L<perltie> for more details.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Andrew Macgregor\n\nEmail andrew@anatomy.otago.ac.nz\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#'\n# Let the code begin...\n\npackage Bio::ClusterIO;\n\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n\n\n=head2 new\n\n Title   : new\n Usage   : Bio::ClusterIO->new(-file => $filename, -format => 'format')\n Function: Returns a new cluster stream\n Returns : A Bio::ClusterIO::Handler initialised with the appropriate format\n Args    : -file => $filename\n           -format => format\n\n\n\nmy $entry = 0;\n\nsub new {\n    my ($caller,@args) = @_;\n    my $class = ref($caller) || $caller;\n    \n    # or do we want to call SUPER on an object if $caller is an\n    # object?\n    if( $class =~ /Bio::ClusterIO::(\\S+)/ ) {\n\tmy ($self) = $class->SUPER::new(@args);\t\n\t$self->_initialize(@args);\n\treturn $self;\n    } else { \n\n\tmy %param = @args;\n\t@param{ map { lc $_ } keys %param } = values %param; # lowercase keys\n\tmy $format = $param{'-format'} || \n\t    $class->_guess_format( $param{-file} || $ARGV[0] );\n\t$format = \"\\L$format\";\t# normalize capitalization to lower case\n\n\treturn unless( $class->_load_format_module($format) );\n\treturn \"Bio::ClusterIO::$format\"->new(@args);\n    }\n}\n\n\n# _initialize is chained for all ClusterIO classes\n\nsub _initialize {\n    my($self, @args) = @_;\n    # initialize the IO part\n    $self->_initialize_io(@args);\n}\n\n=head2 next_cluster\n\n Title   : next_cluster\n Usage   : $cluster = $stream->next_cluster()\n Function: Reads the next cluster object from the stream and returns it.\n Returns : a L<Bio::ClusterI> compliant object\n Args    : none\n\n\n\nsub next_cluster {\n   my ($self, $seq) = @_;\n   $self->throw(\"Sorry, you cannot read from a generic Bio::ClusterIO object.\");\n}\n\n=head2 cluster_factory\n\n Title   : cluster_factory\n Usage   : $obj->cluster_factory($newval)\n Function: Get/set the object factory to use for creating the cluster\n           objects.\n Example : \n Returns : a L<Bio::Factory::ObjectFactoryI> compliant object\n Args    : on set, new value (a L<Bio::Factory::ObjectFactoryI> \n           compliant object or undef, optional)\n\n\n\nsub cluster_factory{\n    my $self = shift;\n\n    return $self->{'cluster_factory'} = shift if @_;\n    return $self->{'cluster_factory'};\n}\n\n=head2 object_factory\n\n Title   : object_factory\n Usage   : $obj->object_factory($newval)\n Function: This is an alias to cluster_factory with a more generic name.\n Example : \n Returns : a L<Bio::Factory::ObjectFactoryI> compliant object\n Args    : on set, new value (a L<Bio::Factory::ObjectFactoryI> \n           compliant object or undef, optional)\n\n\n\nsub object_factory{\n    return shift->cluster_factory(@_);\n}\n\n=head2 _load_format_module\n\n Title   : _load_format_module\n Usage   : *INTERNAL ClusterIO stuff*\n Function: Loads up (like use) a module at run time on demand\n Example :\n Returns :\n Args    :","parameters":[{"label":"$self"},{"label":"$format"}]}},{"kind":12,"range":{"end":{"character":9999,"line":298},"start":{"character":0,"line":293}},"line":293,"definition":"sub","name":"_guess_format","containerName":"main::","children":[{"kind":13,"localvar":"my","containerName":"_guess_format","name":"$class","line":294,"definition":"my"}]},{"definition":"sub","children":[{"line":301,"localvar":"my","kind":13,"containerName":"DESTROY","name":"$self","definition":"my"},{"name":"$self","containerName":"DESTROY","kind":13,"line":303},{"line":303,"containerName":"DESTROY","kind":12,"name":"close"}],"containerName":"main::","name":"DESTROY","line":300,"range":{"start":{"line":300,"character":0},"end":{"character":9999,"line":304}},"kind":12},{"kind":12,"range":{"end":{"character":9999,"line":311},"start":{"line":308,"character":0}},"line":308,"signature":{"label":"TIEHANDLE($class,$val)","documentation":" I need some direction on these!! The module works so I haven't fiddled with them!","parameters":[{"label":"$class"},{"label":"$val"}]},"name":"TIEHANDLE","containerName":"main::","children":[{"line":309,"name":"$class","kind":13,"localvar":"my","containerName":"TIEHANDLE","definition":"my"},{"containerName":"TIEHANDLE","kind":13,"name":"$val","line":309},{"name":"$val","kind":13,"containerName":"TIEHANDLE","line":310},{"name":"$class","kind":13,"containerName":"TIEHANDLE","line":310}],"detail":"($class,$val)","definition":"sub"},{"containerName":"main::","name":"READLINE","children":[{"definition":"my","line":314,"name":"$self","localvar":"my","kind":13,"containerName":"READLINE"},{"name":"$self","kind":13,"containerName":"READLINE","line":315},{"line":315,"name":"next_seq","kind":12,"containerName":"READLINE"},{"line":316,"name":"@list","containerName":"READLINE","localvar":"my","kind":13,"definition":"my"},{"containerName":"READLINE","kind":13,"name":"$obj","line":316},{"line":317,"containerName":"READLINE","kind":13,"name":"@list"},{"line":317,"name":"$obj","kind":13,"containerName":"READLINE"},{"line":317,"name":"$obj","kind":13,"containerName":"READLINE"},{"name":"$self","kind":13,"containerName":"READLINE","line":317},{"kind":12,"containerName":"READLINE","name":"next_seq","line":317},{"line":318,"name":"@list","kind":13,"containerName":"READLINE"}],"definition":"sub","kind":12,"range":{"end":{"line":319,"character":9999},"start":{"line":313,"character":0}},"line":313},{"definition":"sub","children":[{"localvar":"my","containerName":"PRINT","kind":13,"name":"$self","line":322,"definition":"my"},{"line":323,"kind":13,"containerName":"PRINT","name":"$self"},{"line":323,"containerName":"PRINT","kind":12,"name":"write_seq"}],"containerName":"main::","name":"PRINT","line":321,"range":{"start":{"line":321,"character":0},"end":{"line":324,"character":9999}},"kind":12}],"version":5}