{"vars":[{"name":"vars","kind":2,"containerName":"","line":89},{"line":93,"kind":2,"containerName":"","name":"base"},{"signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"","label":"_initialize($self,@args)"},"range":{"start":{"character":0,"line":96},"end":{"character":9999,"line":147}},"kind":12,"line":96,"detail":"($self,@args)","definition":"sub","containerName":"main::","name":"_initialize","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"_initialize","name":"$self","line":97},{"line":97,"containerName":"_initialize","kind":13,"name":"@args"},{"definition":"my","containerName":"_initialize","localvar":"my","kind":13,"name":"%param","line":100},{"line":100,"name":"@args","kind":13,"containerName":"_initialize"},{"line":101,"kind":13,"containerName":"_initialize","name":"@param"},{"line":101,"containerName":"_initialize","kind":13,"name":"%param"},{"line":101,"name":"%param","containerName":"_initialize","kind":13},{"definition":"my","line":105,"name":"$new_key","localvar":"my","containerName":"_initialize","kind":13},{"kind":13,"localvar":"my","containerName":"_initialize","name":"$key","line":106,"definition":"my"},{"line":106,"containerName":"_initialize","kind":13,"name":"%param"},{"name":"$new_key","containerName":"_initialize","kind":13,"line":107},{"kind":13,"containerName":"_initialize","name":"$key","line":107},{"line":108,"kind":13,"containerName":"_initialize","name":"$self"},{"line":108,"containerName":"_initialize","kind":13,"name":"$new_key"},{"name":"$param","kind":13,"containerName":"_initialize","line":108},{"line":108,"name":"$key","containerName":"_initialize","kind":13},{"definition":"my","line":114,"name":"$result","localvar":"my","containerName":"_initialize","kind":13},{"line":114,"containerName":"_initialize","kind":13,"name":"$self"},{"line":115,"name":"$result","containerName":"_initialize","kind":13},{"line":120,"name":"$result","kind":13,"containerName":"_initialize"},{"kind":13,"containerName":"_initialize","name":"$result","line":123},{"kind":13,"containerName":"_initialize","name":"$Bio","line":124},{"containerName":"_initialize","kind":12,"name":"new","line":124},{"line":124,"name":"@args","kind":13,"containerName":"_initialize"},{"line":130,"name":"$self","containerName":"_initialize","kind":13},{"line":135,"name":"$self","containerName":"_initialize","kind":13},{"kind":13,"containerName":"_initialize","name":"$SUPER","line":144},{"kind":13,"containerName":"_initialize","name":"$self","line":144},{"kind":13,"containerName":"_initialize","name":"$self","line":145},{"name":"_parse","kind":12,"containerName":"_initialize","line":145}]},{"containerName":"Biblio::IO::_load_format_module","kind":12,"name":"Bio","line":123},{"line":124,"name":"Biblio","containerName":"IO::medlinexml::Convert","kind":12},{"line":130,"name":"new","kind":12},{"containerName":"Parser","kind":12,"name":"XML","line":130},{"name":"Handlers","kind":12,"line":130},{"line":130,"kind":12,"name":"Init"},{"line":130,"kind":12,"containerName":"Biblio::IO::medlinexml::handle_doc_start","name":"Bio"},{"line":131,"kind":12,"name":"Start"},{"name":"handle_start","kind":12,"line":131},{"name":"End","kind":12,"line":132},{"kind":12,"name":"handle_end","line":132},{"kind":12,"name":"Char","line":133},{"name":"Bio","kind":12,"containerName":"Biblio::IO::medlinexml::handle_char","line":133},{"name":"Final","kind":12,"line":134},{"line":134,"name":"Bio","containerName":"Biblio::IO::medlinexml::handle_doc_end","kind":12},{"line":144,"name":"Callback","kind":12,"containerName":""},{"line":163,"containerName":null,"kind":13,"name":"%PCDATA_NAMES"},{"kind":13,"containerName":null,"name":"%SIMPLE_TREATMENT","line":171},{"kind":13,"containerName":null,"name":"%POP_DATA_AND_PEEK_OBJ","line":179},{"kind":13,"containerName":null,"name":"%POP_AND_ADD_DATA_ELEMENT","line":191},{"signature":{"parameters":[{"label":"$expat"},{"label":"$e"},{"label":"%attrs"}],"documentation":"__END__\n# $Id: pubmedxml.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Biblio::IO::pubmedxml.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Martin Senger <senger@ebi.ac.uk>\n# For copyright and disclaimer see below.\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Biblio::IO::pubmedxml - A converter of XML files with PUBMED citations\n\n=head1 SYNOPSIS\n\nDo not use this object directly, it is recommended to access it and use\nit through the I<Bio::Biblio::IO> module:\n\n  use Bio::Biblio::IO;\n  my $io = Bio::Biblio::IO->new(-format => 'pubmedxml');\n\n=head1 DESCRIPTION\n\nThis object reads bibliographic citations in XML/MEDLINE format and\nconverts them into I<Bio::Biblio::RefI> objects. It is an\nimplementation of methods defined in I<Bio::Biblio::IO>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nMartin Senger (senger@ebi.ac.uk)\n\n=head1 COPYRIGHT\n\nCopyright (c) 2002 European Bioinformatics Institute. All Rights Reserved.\n\nThis module is free software; you can redistribute it and/or modify\nit under the same terms as Perl itself.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe main documentation details are to be found in\nL<Bio::Biblio::IO>.\n\nHere is the rest of the object methods.  Internal methods are preceded\nwith an underscore _.\n\n\n\n# Let the code begin...\n\n\npackage Bio::Biblio::IO::pubmedxml;\nuse vars qw(%PCDATA_NAMES %SIMPLE_TREATMENT %POP_DATA_AND_PEEK_OBJ %POP_AND_ADD_DATA_ELEMENT);\n\nuse strict;\n\nuse base qw(Bio::Biblio::IO::medlinexml);\n\n\nsub _initialize {\n    my ($self, @args) = @_;\n    \n    # make a hashtable from @args\n    my %param = @args;\n    @param { map { lc $_ } keys %param } = values %param; # lowercase keys\n\n    # copy all @args into this object (overwriting what may already be\n    # there) - changing '-key' into '_key', and making keys lowercase\n    my $new_key;\n    foreach my $key (keys %param) {\n\t($new_key = $key) =~ s/^-/_/;\n\t$self->{ lc $new_key } = $param { $key };\n    }\n\n    # find the format for output - and put it into a global $Convert\n    # because it will be used by the event handler who knows nothing\n    # about this object\n    my $result = $self->{'_result'} || 'pubmed2ref';\n    $result = \"\\L$result\";\t# normalize capitalization to lower case\n\n    # a special case is 'raw' when no converting module is loaded\n    # and citations will be returned as a hashtable (the one which\n    # is created during parsing XML file/stream)\n    unless ($result eq 'raw') {\n\n\t# load module with output converter - as defined in $result\n\tif (defined &Bio::Biblio::IO::_load_format_module ($result)) {\n\t    $Bio::Biblio::IO::medlinexml::Convert = \"Bio::Biblio::IO::$result\"->new (@args);\n\t}\n    }\n\n    # create an instance of the XML parser\n    # (unless it is already there...)\n    $self->{'_xml_parser'} = new XML::Parser (Handlers => {Init  => \\&Bio::Biblio::IO::medlinexml::handle_doc_start,\n\t\t\t\t\t\t\t   Start => \\&handle_start,\n\t\t\t\t\t\t\t   End   => \\&handle_end,\n\t\t\t\t\t\t\t   Char  => \\&Bio::Biblio::IO::medlinexml::handle_char,\n\t\t\t\t\t\t\t   Final => \\&Bio::Biblio::IO::medlinexml::handle_doc_end})\n\tunless $self->{'_xml_parser'};\n\n    # if there is an argument '-callback' then start parsing at once -\n    # the registered event handlers will use 'callback' to report\n    # back after each citation\n    #\n    # we need to remember this situation also in a global variable\n    # because the event handler subroutines know nothing about this\n    # object (unfortunately)\n    if ($SUPER::Callback = $self->{'_callback'}) {\n\t$self->_parse;\n    }\n}\n\n# ---------------------------------------------------------------------\n#\n#   Here are the event handlers (they do the real job!)\n#\n# Note that these methods do not know anything about the object they\n# are part of - they are called as subroutines. not as methods.\n# It also means that they need to use global variables to store and\n# exchnage intermediate results.\n#\n# ---------------------------------------------------------------------\n\n#\n# This is a list of #PCDATA elements.\n#\n%PCDATA_NAMES =\n    (\n     'PublicationStatus' => 1,\n     'ProviderId' => 1,\n     'ArticleId' => 1,\n     'URL' => 1,\n     );\n\n%SIMPLE_TREATMENT =\n    (\n     'History' => 1,\n     'PubMedArticle' => 1,\n     'PubmedArticle' => 1,\n     'PubmedData' => 1,\n     );\n\n%POP_DATA_AND_PEEK_OBJ =\n    (\n     'Year' => 1,\n     'Month' => 1,\n     'Day' => 1,\n     'Hour' => 1,\n     'Minute' => 1,\n     'Second' => 1,\n     'ProviderId' => 1,\n     'PublicationStatus' => 1,\n     );\n\n%POP_AND_ADD_DATA_ELEMENT =\n    (\n     'PubMedPubDate' => 'pubDates',\n     'History' => 'histories',\n     );\n\n\n=head2 VERSION and Revision\n\n Usage   : print $Bio::Biblio::IO::pubmedxml::VERSION;\n           print $Bio::Biblio::IO::pubmedxml::Revision;","label":"handle_start($expat,$e,%attrs)"},"line":206,"kind":12,"range":{"start":{"line":206,"character":0},"end":{"character":9999,"line":252}},"definition":"sub","detail":"($expat,$e,%attrs)","children":[{"definition":"my","name":"$expat","kind":13,"localvar":"my","containerName":"handle_start","line":207},{"line":207,"name":"$e","containerName":"handle_start","kind":13},{"kind":13,"containerName":"handle_start","name":"%attrs","line":207},{"line":215,"name":"$e","kind":13,"containerName":"handle_start"},{"line":216,"name":"%p","localvar":"my","kind":13,"containerName":"handle_start","definition":"my"},{"name":"$p","kind":13,"containerName":"handle_start","line":217},{"kind":13,"containerName":"handle_start","name":"$attrs","line":217},{"name":"$attrs","kind":13,"containerName":"handle_start","line":217},{"kind":13,"containerName":"handle_start","name":"@Bio","line":218},{"name":"%p","containerName":"handle_start","kind":13,"line":218},{"containerName":"handle_start","kind":13,"name":"$e","line":221},{"localvar":"my","containerName":"handle_start","kind":13,"name":"%p","line":222,"definition":"my"},{"line":223,"name":"$p","kind":13,"containerName":"handle_start"},{"name":"$attrs","kind":13,"containerName":"handle_start","line":223},{"line":223,"name":"$attrs","kind":13,"containerName":"handle_start"},{"line":224,"containerName":"handle_start","kind":13,"name":"$p"},{"line":224,"containerName":"handle_start","kind":13,"name":"$attrs"},{"line":224,"name":"$attrs","containerName":"handle_start","kind":13},{"line":225,"containerName":"handle_start","kind":13,"name":"@Bio"},{"line":225,"kind":13,"containerName":"handle_start","name":"%p"},{"line":232,"name":"$PCDATA_NAMES","containerName":"handle_start","kind":13},{"line":232,"name":"$e","containerName":"handle_start","kind":13},{"line":233,"name":"@Bio","kind":13,"containerName":"handle_start"},{"line":238,"name":"$SIMPLE_TREATMENT","containerName":"handle_start","kind":13},{"line":238,"name":"$e","kind":13,"containerName":"handle_start"},{"line":239,"containerName":"handle_start","kind":13,"name":"@Bio"},{"line":241,"containerName":"handle_start","kind":13,"name":"$e"},{"line":244,"name":"$e","containerName":"handle_start","kind":13},{"definition":"my","kind":13,"localvar":"my","containerName":"handle_start","name":"%p","line":245},{"name":"$p","kind":13,"containerName":"handle_start","line":246},{"line":246,"kind":13,"containerName":"handle_start","name":"$attrs"},{"line":246,"name":"$attrs","containerName":"handle_start","kind":13},{"name":"@Bio","kind":13,"containerName":"handle_start","line":247},{"kind":13,"containerName":"handle_start","name":"%p","line":247},{"line":250,"name":"$expat","containerName":"handle_start","kind":13},{"line":250,"name":"$e","kind":13,"containerName":"handle_start"},{"name":"%attrs","kind":13,"containerName":"handle_start","line":250}],"name":"handle_start","containerName":"main::"},{"line":218,"name":"Biblio","kind":12,"containerName":"IO::medlinexml::ObjectStack"},{"line":225,"kind":12,"containerName":"IO::medlinexml::ObjectStack","name":"Biblio"},{"kind":12,"containerName":"IO::medlinexml::PCDataStack","name":"Biblio","line":233},{"kind":12,"containerName":"IO::medlinexml::ObjectStack","name":"Biblio","line":239},{"line":247,"containerName":"IO::medlinexml::ObjectStack","kind":12,"name":"Biblio"},{"line":250,"name":"Bio","containerName":"Biblio::IO::medlinexml::handle_start","kind":12},{"signature":{"parameters":[{"label":"$expat"},{"label":"$e"}],"documentation":"","label":"handle_end($expat,$e)"},"kind":12,"range":{"end":{"character":9999,"line":309},"start":{"line":254,"character":0}},"line":254,"detail":"($expat,$e)","definition":"sub","containerName":"main::","name":"handle_end","children":[{"definition":"my","name":"$expat","containerName":"handle_end","localvar":"my","kind":13,"line":255},{"kind":13,"containerName":"handle_end","name":"$e","line":255},{"kind":13,"containerName":"handle_end","name":"$e","line":263},{"line":265,"name":"@Bio","containerName":"handle_end","kind":13},{"containerName":"handle_end","kind":13,"name":"$e","line":270},{"line":272,"kind":13,"containerName":"handle_end","name":"@Bio"},{"line":282,"kind":13,"containerName":"handle_end","name":"$POP_DATA_AND_PEEK_OBJ"},{"line":282,"containerName":"handle_end","kind":13,"name":"$e"},{"name":"$POP_AND_ADD_DATA_ELEMENT","kind":13,"containerName":"handle_end","line":285},{"line":285,"name":"$e","containerName":"handle_end","kind":13},{"line":286,"kind":13,"containerName":"handle_end","name":"$POP_AND_ADD_DATA_ELEMENT"},{"line":286,"name":"$e","kind":13,"containerName":"handle_end"},{"line":286,"name":"@Bio","kind":13,"containerName":"handle_end"},{"line":288,"name":"$e","containerName":"handle_end","kind":13},{"name":"$e","containerName":"handle_end","kind":13,"line":289},{"line":292,"name":"$e","containerName":"handle_end","kind":13},{"kind":13,"containerName":"handle_end","name":"$e","line":295},{"name":"$e","kind":13,"containerName":"handle_end","line":296},{"line":301,"containerName":"handle_end","kind":13,"name":"@Bio"},{"containerName":"handle_end","kind":13,"name":"$expat","line":304},{"kind":13,"containerName":"handle_end","name":"$e","line":304}]},{"containerName":"Biblio::IO::medlinexml::_data2obj","kind":12,"name":"Bio","line":264},{"line":265,"name":"Bio","kind":12,"containerName":"Biblio::IO::medlinexml::_add_element"},{"line":265,"name":"Biblio","kind":12,"containerName":"IO::medlinexml::ObjectStack"},{"line":271,"kind":12,"containerName":"Biblio::IO::medlinexml::_data2obj","name":"Bio"},{"containerName":"Biblio::IO::medlinexml::_add_element","kind":12,"name":"Bio","line":272},{"line":272,"name":"Biblio","kind":12,"containerName":"IO::medlinexml::ObjectStack"},{"kind":12,"containerName":"Biblio::IO::medlinexml::_data2obj","name":"Bio","line":283},{"kind":12,"containerName":"Biblio::IO::medlinexml::_add_element","name":"Bio","line":286},{"kind":12,"containerName":"IO::medlinexml::ObjectStack","name":"Biblio","line":286},{"name":"Bio","containerName":"Biblio::IO::medlinexml::_obj2obj","kind":12,"line":290},{"name":"Bio","kind":12,"containerName":"Biblio::IO::medlinexml::_obj2obj","line":293},{"line":301,"containerName":"Biblio::IO::medlinexml::_process_citation","kind":12,"name":"Bio"},{"name":"Biblio","kind":12,"containerName":"IO::medlinexml::ObjectStack","line":301},{"line":304,"kind":12,"containerName":"Biblio::IO::medlinexml::handle_end","name":"Bio"}],"version":5}