{"version":5,"vars":[{"kind":2,"containerName":"","name":"base","line":228},{"line":230,"name":"$entry","localvar":"my","containerName":null,"kind":13,"definition":"my"},{"name":"new","containerName":"main::","children":[{"definition":"my","line":233,"name":"$caller","kind":13,"localvar":"my","containerName":"new"},{"name":"@args","containerName":"new","kind":13,"line":233},{"definition":"my","line":234,"kind":13,"localvar":"my","containerName":"new","name":"$class"},{"containerName":"new","kind":13,"name":"$caller","line":234},{"line":234,"containerName":"new","kind":13,"name":"$caller"},{"kind":13,"containerName":"new","name":"$class","line":239},{"definition":"my","name":"$self","localvar":"my","containerName":"new","kind":13,"line":240},{"line":240,"name":"$class","containerName":"new","kind":13},{"containerName":"new","kind":13,"name":"@args","line":240},{"line":241,"containerName":"new","kind":13,"name":"$self"},{"line":241,"containerName":"new","kind":12,"name":"_initialize"},{"kind":13,"containerName":"new","name":"@args","line":241},{"name":"$self","containerName":"new","kind":13,"line":242},{"definition":"my","line":249,"containerName":"new","localvar":"my","kind":13,"name":"%param"},{"kind":13,"containerName":"new","name":"@args","line":249},{"name":"@param","containerName":"new","kind":13,"line":250},{"line":250,"name":"%param","containerName":"new","kind":13},{"containerName":"new","kind":13,"name":"%param","line":250},{"line":251,"name":"$format","localvar":"my","containerName":"new","kind":13,"definition":"my"},{"line":251,"name":"$param","containerName":"new","kind":13},{"name":"$class","containerName":"new","kind":13,"line":252},{"kind":12,"containerName":"new","name":"_guess_format","line":252},{"name":"$param","kind":13,"containerName":"new","line":252},{"line":252,"kind":13,"containerName":"new","name":"$ARGV"},{"containerName":"new","kind":13,"name":"$format","line":254},{"line":257,"containerName":"new","kind":13,"name":"$format"},{"kind":12,"containerName":"new","name":"new","line":261},{"line":261,"containerName":"new","kind":13,"name":"@args"}],"detail":"($caller,@args)","definition":"sub","kind":12,"range":{"end":{"line":263,"character":9999},"start":{"line":232,"character":0}},"line":232,"signature":{"label":"new($caller,@args)","parameters":[{"label":"$caller"},{"label":"@args"}],"documentation":""}},{"containerName":"new","kind":12,"name":"SUPER","line":240},{"line":257,"kind":12,"name":"_load_format_module"},{"line":265,"range":{"start":{"line":265,"character":0},"end":{"character":9999,"line":269}},"kind":12,"definition":"sub","children":[{"definition":"my","name":"$class","localvar":"my","containerName":"newFh","kind":13,"line":266},{"definition":"my","line":267,"localvar":"my","containerName":"newFh","kind":13,"name":"$self"},{"name":"$class","containerName":"newFh","kind":13,"line":267},{"line":267,"containerName":"newFh","kind":12,"name":"new"},{"containerName":"newFh","kind":13,"name":"$self","line":268},{"name":"fh","containerName":"newFh","kind":12,"line":268}],"name":"newFh","containerName":"main::"},{"containerName":"main::","name":"fh","children":[{"localvar":"my","kind":13,"containerName":"fh","name":"$self","line":273,"definition":"my"},{"line":274,"localvar":"my","kind":13,"containerName":"fh","name":"$class","definition":"my"},{"name":"$self","containerName":"fh","kind":13,"line":274},{"name":"$self","kind":13,"containerName":"fh","line":274},{"name":"$s","localvar":"my","containerName":"fh","kind":13,"line":275,"definition":"my"},{"line":276,"name":"$class","containerName":"fh","kind":13},{"line":276,"kind":13,"containerName":"fh","name":"$self"},{"line":277,"kind":13,"containerName":"fh","name":"$s"}],"definition":"sub","kind":12,"range":{"end":{"line":278,"character":9999},"start":{"line":272,"character":0}},"line":272},{"kind":12,"containerName":"gensym","name":"Symbol","line":276},{"signature":{"label":"_initialize($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":" _initialize is chained for all Bio::Biblio::IO classes"},"line":282,"range":{"end":{"line":286,"character":9999},"start":{"character":0,"line":282}},"kind":12,"definition":"sub","detail":"($self,@args)","children":[{"definition":"my","line":283,"name":"$self","containerName":"_initialize","localvar":"my","kind":13},{"line":283,"name":"@args","kind":13,"containerName":"_initialize"},{"line":285,"name":"$self","containerName":"_initialize","kind":13},{"containerName":"_initialize","kind":12,"name":"_initialize_io","line":285},{"containerName":"_initialize","kind":13,"name":"@args","line":285}],"containerName":"main::","name":"_initialize"},{"definition":"sub","name":"next_bibref","containerName":"main::","children":[{"definition":"my","localvar":"my","containerName":"next_bibref","kind":13,"name":"$self","line":300},{"containerName":"next_bibref","kind":13,"name":"$self","line":301},{"line":301,"kind":12,"containerName":"next_bibref","name":"throw"}],"range":{"end":{"character":9999,"line":302},"start":{"character":0,"line":299}},"kind":12,"line":299},{"name":"_load_format_module","containerName":"main::","children":[{"definition":"my","line":323,"name":"$format","containerName":"_load_format_module","localvar":"my","kind":13},{"name":"$module","kind":13,"localvar":"my","containerName":"_load_format_module","line":324,"definition":"my"},{"line":324,"name":"$load","containerName":"_load_format_module","kind":13},{"line":324,"containerName":"_load_format_module","kind":13,"name":"$m"},{"line":326,"kind":13,"containerName":"_load_format_module","name":"$module"},{"line":327,"containerName":"_load_format_module","kind":13,"name":"$load"},{"line":329,"name":"$main","kind":13,"containerName":"_load_format_module"},{"name":"$module","kind":13,"containerName":"_load_format_module","line":329},{"containerName":"_load_format_module","kind":13,"name":"$load","line":331},{"line":334,"name":"throw","kind":12,"containerName":"_load_format_module"}],"detail":"($format)","definition":"sub","range":{"start":{"line":322,"character":0},"end":{"character":9999,"line":343}},"kind":12,"line":322,"signature":{"parameters":[{"label":"$format"}],"documentation":"1;\n# $Id: IO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Biblio::IO\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Martin Senger <senger@ebi.ac.uk>\n# For copyright and disclaimer see below.\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Biblio::IO - Handling the bibliographic references\n\n=head1 SYNOPSIS\n\n    use Bio::Biblio::IO;\n\n    # getting citations from a file\n    $in = Bio::Biblio::IO->new ('-file' => 'myfile.xml' ,\n                                '-format' => 'medlinexml');\n  # --- OR ---\n\n    # getting citations from a string\n    $in = Bio::Biblio::IO->new ('-data' => '<MedlineCitation>...</MedlineCitation>' ,\n                                '-format' => 'medlinexml');\n  #--- OR ---\n\n    # getting citations from a string if IO::String is installed\n    use IO::String;\n    $in = Bio::Biblio::IO->new ('-fh' => IO::String->new ($citation),\n                                '-format' => 'medlinexml');\n\n    $in = Bio::Biblio::IO->new(-fh => $io_handle , '-format' => 'medlinexml');\n\n  #--- OR ---\n\n    # getting citations from any IO handler\n    $in = Bio::Biblio::IO->new('-fh' => $io_handle ,\n                               '-format' => 'medlinexml');\n\n\n    # now, having $in, we can read all citations\n    while ( my $citation = $in->next_bibref() ) {\n        &do_something_with_citation ($citation);\n    }\n\n  #--- OR ---\n\n    # again reading all citation but now a callback defined in your\n    # code is used (note that the reading starts already when new()\n    # is called)\n    $io = Bio::Biblio::IO->new('-format'   => 'medlinexml',\n                               '-file'     => $testfile,\n                               '-callback' => \\&callback);\n    sub callback {\n        my $citation = shift;\n        print $citation->{'_identifier'} . \"\\n\";\n    }\n\n  #Now, to actually get a citation in an XML format,\n  #use I<Bio::Biblio> module which returns an XML string:\n\n    use Bio::Biblio;\n    use Bio::Biblio::IO;\n    my $xml = Bio::Biblio->new->get_by_id ('12368254');\n    my $reader = Bio::Biblio::IO->new ('-data' => $xml,\n                                       '-format' => 'medlinexml');\n\n    while (my $citation = $reader->next_bibref()) {\n       #... do something here with $citation\n       }\n\n  #And, finally, the resulting citation can be received in different\n  #output formats:\n\n    $io = Bio::Biblio::IO->new('-format' => 'medlinexml',\n                               '-result' => 'raw');\n  #--- OR ---\n\n    $io = Bio::Biblio::IO->new('-format' => 'medlinexml',\n                               '-result' => 'medline2ref');\n\n  #--- OR ---\n\n    $io = Bio::Biblio::IO->new('-format' => 'pubmedxml',\n                               '-result' => 'pubmed2ref');\n\n=head1 DESCRIPTION\n\nBio::Biblio::IO is a handler module for accessing bibliographic\ncitations. The citations can be in different formats - assuming that\nthere is a corresponding module knowing that format in Bio::Biblio::IO\ndirectory (e.g. Bio::Biblio::IO::medlinexml). The format (and the\nmodule name) is given by the argument I<-format>.\n\nOnce an instance of C<Bio::Biblio::IO> class is available, the\ncitations can be read by calling repeatedly method I<next_bibref>:\n\n    while (my $citation = $reader->next_bibref()) {\n       ... do something here with $citation\n       }\n\nHowever, this may imply that all citations were already read into the\nmemory. If you expect a huge amount of citations to be read, you may\nchoose a I<callback> option. Your subroutine is specified in the\nC<new()> method and is called everytime a new citation is available\n(see an example above in SYNOPSIS).\n\nThe citations returned by I<next_bibref> or given to your callback\nroutine can be of different formats depending on the argument\nI<-result>. One result type is I<raw> and it is represented by a\nsimple, not blessed hash table:\n\n    $io = Bio::Biblio::IO->new('-result' => 'raw');\n\nWhat other result formats are available depends on the module who\nreads the citations in the first place. At the moment, the following\nones are available:\n\n    $io = Bio::Biblio::IO->new('-result' => 'medline2ref');\n\nThis is a default result format for reading citations by the\nI<medlinexml> module. The C<medlinexml> module is again the default\none. Which means that you can almost omit arguments (you still need to\nsay where the citations come from):\n\n    $io = Bio::Biblio::IO->new('-file' => 'data/medline_data.xml');\n\nAnother result format available is for PUBMED citations (which is a\nsuper-set of the MEDLINE citations having few more tags):\n\n    $io = Bio::Biblio::IO->new('-format' => 'pubmedxml',\n                               '-result' => 'pubmed2ref',\n                               '-data'   => $citation);\n\nOr, because C<pubmed2ref> is a default one for PUBMED citations, you can say just:\n\n    $io = Bio::Biblio::IO->new('-format' => 'pubmedxml',\n                               '-data'   => $citation);\n\nBoth C<medline2ref> and C<pubmed2ref> results are objects defined in\nthe directory C<Bio::Biblio>.\n\n=head1 SEE ALSO\n\n=over 4\n\n* *\n\nAn example script I<examples/biblio.pl>. It has many options and its\nown help.  The relevant options to this IO module are I<-f>\n(specifying what file to read) and I<-O> (specifying what result\nformat to achieve).\n\n* *\n\nOpenBQS home page: http://www.ebi.ac.uk/~senger/openbqs\n\n* *\n\nComments to the Perl client: http://www.ebi.ac.uk/~senger/openbqs/Client_perl.html\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nMartin Senger (senger@ebi.ac.uk)\n\n=head1 COPYRIGHT\n\nCopyright (c) 2002 European Bioinformatics Institute. All Rights Reserved.\n\nThis module is free software; you can redistribute it and/or modify\nit under the same terms as Perl itself.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Biblio::IO;\n\nuse strict;\n\nuse Symbol;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\nmy $entry = 0;\n\nsub new {\n    my ($caller, @args) = @_;\n    my $class = ref ($caller) || $caller;\n\n    # if $caller is an object, or if it is an underlying\n    # 'real-work-doing' class (e.g. Bio::Biblio::IO::medlinexml) then\n    # we want to call SUPER to create and bless an object\n    if( $class =~ /Bio::Biblio::IO::(\\S+)/ ) {\n\tmy ($self) = $class->SUPER::new (@args);\n\t$self->_initialize (@args);\n\treturn $self;\n\n    # this is called only the first time when somebody calls: 'new\n    # Bio::Biblio::IO (...)', and it actually loads a 'real-work-doing'\n    # module and call this new() method again (unless the loaded\n    # module has its own new() method)\n    } else {\n\tmy %param = @args;\n\t@param{ map { lc $_ } keys %param } = values %param; # lowercase keys\n\tmy $format = $param{'-format'} ||\n\t    $class->_guess_format( $param{-file} || $ARGV[0] ) ||\n\t\t'medlinexml';\n\t$format = \"\\L$format\";\t# normalize capitalization to lower case\n\n\t# load module with the real implementation - as defined in $format\n\treturn unless (&_load_format_module ($format));\n\n\t# this will call this same method new() - but rather its\n\t# upper (object) branche\n\treturn \"Bio::Biblio::IO::$format\"->new(@args);\n    }\n}\n\nsub newFh {\n  my $class = shift;\n  return unless my $self = $class->new(@_);\n  return $self->fh;\n}\n\n\nsub fh {\n  my $self = shift;\n  my $class = ref($self) || $self;\n  my $s = Symbol::gensym;\n  tie $$s,$class,$self;\n  return $s;\n}\n\n# _initialize is chained for all Bio::Biblio::IO classes\n\nsub _initialize {\n    my ($self, @args) = @_;\n    # initialize the IO part\n    $self->_initialize_io (@args);\n}\n\n=head2 next_bibref\n\n Usage   : $citation = stream->next_bibref\n Function: Reads the next citation object from the stream and returns it.\n Returns : a Bio::Biblio::Ref citation object, or something else\n           (depending on the '-result' argument given in the 'new()'\n\t    method).\n Args    : none\n\n\nsub next_bibref {\n   my ($self) = shift;\n   $self->throw (\"Sorry, you cannot read from a generic Bio::Biblio::IO object.\");\n}\n\n# -----------------------------------------------------------------------------\n\n=head2 _load_format_module\n\n Usage   : $class->_load_format_module ($format)\n Returns : 1 on success, undef on failure\n Args    : 'format' should contain the last part of the\n           name of a module who does the real implementation\n\nIt does (in run-time) a similar thing as\n\n   require Bio::Biblio::IO::$format\n\nIt throws an exception if it fails to find and load the module\n(for example, because of the compilation errors in the module).","label":"_load_format_module($format)"}},{"line":334,"kind":12,"containerName":"Root::Root","name":"Bio"},{"kind":12,"range":{"start":{"character":0,"line":356},"end":{"character":9999,"line":361}},"line":356,"containerName":"main::","name":"_guess_format","children":[{"kind":13,"localvar":"my","containerName":"_guess_format","name":"$class","line":357,"definition":"my"}],"definition":"sub"},{"line":363,"range":{"end":{"character":9999,"line":367},"start":{"line":363,"character":0}},"kind":12,"children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"DESTROY","line":364},{"name":"$self","kind":13,"containerName":"DESTROY","line":366},{"line":366,"containerName":"DESTROY","kind":12,"name":"close"}],"containerName":"main::","name":"DESTROY","definition":"sub"},{"range":{"end":{"line":372,"character":9999},"start":{"character":0,"line":369}},"kind":12,"line":369,"signature":{"parameters":[{"label":"$class"},{"label":"$val"}],"documentation":"","label":"TIEHANDLE($class,$val)"},"name":"TIEHANDLE","containerName":"main::","children":[{"line":370,"localvar":"my","kind":13,"containerName":"TIEHANDLE","name":"$class","definition":"my"},{"line":370,"kind":13,"containerName":"TIEHANDLE","name":"$val"},{"line":371,"containerName":"TIEHANDLE","kind":13,"name":"$val"},{"line":371,"containerName":"TIEHANDLE","kind":13,"name":"$class"}],"detail":"($class,$val)","definition":"sub"},{"kind":12,"range":{"start":{"line":374,"character":0},"end":{"line":380,"character":9999}},"line":374,"name":"READLINE","containerName":"main::","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"READLINE","line":375,"definition":"my"},{"line":376,"name":"$self","kind":13,"containerName":"READLINE"},{"line":376,"containerName":"READLINE","kind":12,"name":"next_bibref"},{"definition":"my","line":377,"name":"@list","localvar":"my","containerName":"READLINE","kind":13},{"line":377,"kind":13,"containerName":"READLINE","name":"$obj"},{"line":378,"containerName":"READLINE","kind":13,"name":"@list"},{"kind":13,"containerName":"READLINE","name":"$obj","line":378},{"containerName":"READLINE","kind":13,"name":"$obj","line":378},{"name":"$self","kind":13,"containerName":"READLINE","line":378},{"containerName":"READLINE","kind":12,"name":"next_bibref","line":378},{"containerName":"READLINE","kind":13,"name":"@list","line":379}],"definition":"sub"}]}