{"version":5,"vars":[{"name":"base","kind":2,"containerName":"","line":70},{"kind":13,"containerName":"main::","name":"$WIDTH","line":71,"definition":"our"},{"containerName":"main::","name":"next_aln","children":[{"localvar":"my","containerName":"next_aln","kind":13,"name":"$self","line":88,"definition":"my"},{"definition":"my","kind":13,"localvar":"my","containerName":"next_aln","name":"$width","line":89},{"name":"$self","containerName":"next_aln","kind":13,"line":89},{"name":"_rearrange","containerName":"next_aln","kind":12,"line":89},{"name":"$self","containerName":"next_aln","kind":13,"line":90},{"line":90,"kind":12,"containerName":"next_aln","name":"width"},{"kind":13,"containerName":"next_aln","name":"$width","line":90},{"line":90,"containerName":"next_aln","kind":13,"name":"$WIDTH"},{"definition":"my","line":92,"localvar":"my","kind":13,"containerName":"next_aln","name":"$name"},{"name":"$tempname","containerName":"next_aln","kind":13,"line":92},{"line":92,"containerName":"next_aln","kind":13,"name":"$seqchar"},{"line":93,"name":"$aln","kind":13,"localvar":"my","containerName":"next_aln","definition":"my"},{"kind":12,"containerName":"next_aln","name":"new","line":93},{"definition":"my","line":94,"name":"$seqs","containerName":"next_aln","localvar":"my","kind":13},{"localvar":"my","kind":13,"containerName":"next_aln","name":"$entry","line":96,"definition":"my"},{"line":96,"name":"$self","kind":13,"containerName":"next_aln"},{"name":"_readline","kind":12,"containerName":"next_aln","line":96},{"kind":13,"containerName":"next_aln","name":"$entry","line":97},{"line":98,"kind":13,"containerName":"next_aln","name":"$entry"},{"line":99,"name":"$name","kind":13,"containerName":"next_aln"},{"kind":13,"containerName":"next_aln","name":"$seqchar","line":99},{"line":100,"localvar":"my","kind":13,"containerName":"next_aln","name":"$seq","definition":"my"},{"line":100,"kind":13,"containerName":"next_aln","name":"$self"},{"line":100,"kind":12,"containerName":"next_aln","name":"_process_seq"},{"containerName":"next_aln","kind":13,"name":"$name","line":100},{"line":100,"name":"$seqchar","kind":13,"containerName":"next_aln"},{"line":101,"name":"$aln","containerName":"next_aln","kind":13},{"containerName":"next_aln","kind":12,"name":"add_seq","line":101},{"name":"$seq","containerName":"next_aln","kind":13,"line":101},{"line":103,"containerName":"next_aln","kind":13,"name":"$aln"},{"line":103,"name":"$entry","kind":13,"containerName":"next_aln"},{"line":104,"name":"$aln","containerName":"next_aln","kind":13},{"line":104,"containerName":"next_aln","kind":12,"name":"score"},{"line":106,"containerName":"next_aln","kind":13,"name":"$seqchar"},{"line":107,"kind":13,"containerName":"next_aln","name":"$name"},{"line":109,"containerName":"next_aln","kind":13,"name":"$entry"},{"line":110,"containerName":"next_aln","kind":13,"name":"$name"},{"line":111,"name":"$seq","kind":13,"localvar":"my","containerName":"next_aln","definition":"my"},{"name":"$self","kind":13,"containerName":"next_aln","line":111},{"name":"_process_seq","containerName":"next_aln","kind":12,"line":111},{"line":111,"containerName":"next_aln","kind":13,"name":"$name"},{"containerName":"next_aln","kind":13,"name":"$seqchar","line":111},{"line":112,"name":"$aln","containerName":"next_aln","kind":13},{"line":112,"containerName":"next_aln","kind":12,"name":"add_seq"},{"line":112,"name":"$seq","kind":13,"containerName":"next_aln"},{"line":114,"name":"$seqchar","containerName":"next_aln","kind":13},{"containerName":"next_aln","kind":13,"name":"$name","line":115},{"containerName":"next_aln","kind":13,"name":"$entry","line":115},{"line":117,"kind":13,"containerName":"next_aln","name":"$seqchar"},{"line":117,"name":"$entry","kind":13,"containerName":"next_aln"},{"kind":13,"containerName":"next_aln","name":"$name","line":122},{"kind":13,"localvar":"my","containerName":"next_aln","name":"$seq","line":123,"definition":"my"},{"name":"$self","kind":13,"containerName":"next_aln","line":123},{"name":"_process_seq","kind":12,"containerName":"next_aln","line":123},{"line":123,"name":"$name","containerName":"next_aln","kind":13},{"containerName":"next_aln","kind":13,"name":"$seqchar","line":123},{"name":"$aln","kind":13,"containerName":"next_aln","line":124},{"line":124,"name":"add_seq","kind":12,"containerName":"next_aln"},{"name":"$seq","containerName":"next_aln","kind":13,"line":124},{"line":126,"containerName":"next_aln","kind":13,"name":"$aln"},{"containerName":"next_aln","kind":12,"name":"num_sequences","line":126},{"line":126,"name":"$aln","kind":13,"containerName":"next_aln"}],"definition":"sub","kind":12,"range":{"start":{"line":87,"character":0},"end":{"character":9999,"line":127}},"line":87},{"name":"Bio","containerName":"SimpleAlign","kind":12,"line":93},{"signature":{"label":"write_aln($self,@aln)","documentation":"1;\n# $Id: xmfa.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::AlignIO::xmfa\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::AlignIO::xmfa - XMFA MSA Sequence input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the L<Bio::AlignIO> \nclass.\n\n=head1 DESCRIPTION\n\nThis object can transform L<Bio::SimpleAlign> objects from\nXMFA flat file databases.  For more information, see:\n\n  http://asap.ahabs.wisc.edu/mauve-aligner/mauve-user-guide/mauve-output-file-formats.html\n\nThis module is based on the AlignIO::fasta parser written by\nPeter Schattner\n\n=head1 TODO\n\nFinish write_aln(), clean up code, allow LargeLocatableSeq (ie for\nvery large sequences a'la Mauve)\n\n=head1 FEEDBACK\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS\n\nChris Fields\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::AlignIO::xmfa;\nuse strict;\n\nuse base qw(Bio::AlignIO);\nour $WIDTH = 60;\n\n=head2 next_aln\n\n Title   : next_aln\n Usage   : $aln = $stream->next_aln\n Function: returns the next alignment in the stream.\n Returns : Bio::Align::AlignI object - returns 0 on end of file\n            or on error\n Args    : -width => optional argument to specify the width sequence\n           will be written (60 chars by default)\n\nSee L<Bio::Align::AlignI>\n\n\nsub next_aln {\n    my $self = shift;\n    my ($width) = $self->_rearrange([qw(WIDTH)],@_);\n    $self->width($width || $WIDTH);\n\n    my ($name, $tempname, $seqchar);\n    my $aln = Bio::SimpleAlign->new();\n    my $seqs = 0;\n    # alignments\n    while (defined (my $entry = $self->_readline) ) {\n        chomp $entry;\n        if ( index($entry, '=') == 0 ) {\n            if (defined $name && $seqchar) {\n                my $seq = $self->_process_seq($name, $seqchar);\n                $aln->add_seq($seq);\n            }\n            if ($aln && $entry =~ m{score\\s*=\\s*(\\d+)}) {\n                $aln->score($1);\n            }\n            $seqchar = '';\n            undef $name;\n            last;\n        } elsif ( $entry =~ m{^>.+$}xms) {\n            if ( defined $name ) {\n                my $seq = $self->_process_seq($name, $seqchar);\n                $aln->add_seq($seq);\n            }\n            $seqchar = '';\n            $name = $entry;\n        } else {\n            $seqchar .= $entry;\n        }\n    }\n    \n    # this catches last sequence if '=' is not present (Mauve)\n    if ( defined $name ) {\n        my $seq = $self->_process_seq($name, $seqchar);\n        $aln->add_seq($seq);\n    }\n    $aln->num_sequences ? return $aln : return;\n}\n\n=head2 write_aln\n\n Title   : write_aln\n Usage   : $stream->write_aln(@aln)\n Function: writes the $aln object into the stream in xmfa format\n Returns : 1 for success and 0 for error\n Args    : L<Bio::Align::AlignI> object\n\nSee L<Bio::Align::AlignI>","parameters":[{"label":"$self"},{"label":"@aln"}]},"line":141,"kind":12,"range":{"start":{"line":141,"character":0},"end":{"character":9999,"line":182}},"definition":"sub","detail":"($self,@aln)","children":[{"definition":"my","line":142,"name":"$self","containerName":"write_aln","localvar":"my","kind":13},{"line":142,"kind":13,"containerName":"write_aln","name":"@aln"},{"name":"$width","localvar":"my","kind":13,"containerName":"write_aln","line":143,"definition":"my"},{"kind":13,"containerName":"write_aln","name":"$self","line":143},{"line":143,"name":"width","kind":12,"containerName":"write_aln"},{"definition":"my","kind":13,"localvar":"my","containerName":"write_aln","name":"$seq","line":144},{"name":"$desc","kind":13,"containerName":"write_aln","line":144},{"name":"$rseq","kind":13,"containerName":"write_aln","line":144},{"name":"$name","kind":13,"containerName":"write_aln","line":144},{"containerName":"write_aln","kind":13,"name":"$count","line":144},{"name":"$length","kind":13,"containerName":"write_aln","line":144},{"line":144,"kind":13,"containerName":"write_aln","name":"$seqsub"},{"line":144,"containerName":"write_aln","kind":13,"name":"$start"},{"line":144,"name":"$end","kind":13,"containerName":"write_aln"},{"line":144,"name":"$strand","containerName":"write_aln","kind":13},{"line":144,"name":"$id","containerName":"write_aln","kind":13},{"line":146,"name":"$aln","localvar":"my","containerName":"write_aln","kind":13,"definition":"my"},{"line":146,"kind":13,"containerName":"write_aln","name":"@aln"},{"line":147,"containerName":"write_aln","kind":13,"name":"$aln"},{"kind":13,"containerName":"write_aln","name":"$aln","line":147},{"name":"isa","containerName":"write_aln","kind":12,"line":147},{"line":148,"containerName":"write_aln","kind":13,"name":"$self"},{"line":148,"containerName":"write_aln","kind":12,"name":"warn"},{"definition":"my","line":154,"localvar":"my","containerName":"write_aln","kind":13,"name":"$seqct"},{"line":155,"name":"$rseq","containerName":"write_aln","kind":13},{"name":"$aln","containerName":"write_aln","kind":13,"line":155},{"containerName":"write_aln","kind":12,"name":"each_seq","line":155},{"line":156,"name":"$start","containerName":"write_aln","kind":13},{"line":156,"kind":13,"containerName":"write_aln","name":"$end"},{"name":"$strand","containerName":"write_aln","kind":13,"line":156},{"name":"$id","kind":13,"containerName":"write_aln","line":156},{"line":156,"containerName":"write_aln","kind":13,"name":"$rseq"},{"line":156,"kind":12,"containerName":"write_aln","name":"start"},{"containerName":"write_aln","kind":13,"name":"$rseq","line":156},{"line":156,"containerName":"write_aln","kind":12,"name":"end"},{"line":156,"name":"$rseq","containerName":"write_aln","kind":13},{"line":156,"kind":12,"containerName":"write_aln","name":"strand"},{"name":"$rseq","containerName":"write_aln","kind":13,"line":157},{"line":157,"kind":12,"containerName":"write_aln","name":"display_id"},{"kind":13,"containerName":"write_aln","name":"$strand","line":158},{"containerName":"write_aln","kind":13,"name":"$strand","line":158},{"name":"$strand","containerName":"write_aln","kind":13,"line":159},{"line":161,"containerName":"write_aln","kind":13,"name":"$name"},{"line":161,"name":"$seqct","kind":13,"containerName":"write_aln"},{"line":161,"kind":13,"containerName":"write_aln","name":"$start"},{"containerName":"write_aln","kind":13,"name":"$end","line":161},{"name":"$strand","containerName":"write_aln","kind":13,"line":161},{"line":161,"kind":13,"containerName":"write_aln","name":"$id"},{"containerName":"write_aln","kind":13,"name":"$seq","line":162},{"name":"$rseq","kind":13,"containerName":"write_aln","line":162},{"containerName":"write_aln","kind":12,"name":"seq","line":162},{"line":163,"containerName":"write_aln","kind":13,"name":"$desc"},{"containerName":"write_aln","kind":13,"name":"$rseq","line":163},{"line":163,"kind":12,"containerName":"write_aln","name":"description"},{"line":164,"containerName":"write_aln","kind":13,"name":"$self"},{"name":"_print","containerName":"write_aln","kind":12,"line":164},{"line":165,"name":"$count","containerName":"write_aln","kind":13},{"line":166,"name":"$length","containerName":"write_aln","kind":13},{"name":"$seq","containerName":"write_aln","kind":13,"line":166},{"containerName":"write_aln","kind":13,"name":"$seq","line":167},{"line":167,"containerName":"write_aln","kind":13,"name":"$length"},{"name":"$seq","kind":13,"containerName":"write_aln","line":168},{"kind":13,"containerName":"write_aln","name":"$seq","line":170},{"containerName":"write_aln","kind":13,"name":"$self","line":172},{"line":172,"name":"_print","kind":12,"containerName":"write_aln"},{"name":"$seq","kind":13,"containerName":"write_aln","line":172},{"line":173,"name":"$seqct","kind":13,"containerName":"write_aln"},{"name":"$alndesc","kind":13,"localvar":"my","containerName":"write_aln","line":175,"definition":"my"},{"line":176,"name":"$alndesc","kind":13,"containerName":"write_aln"},{"line":176,"name":"$aln","kind":13,"containerName":"write_aln"},{"name":"score","containerName":"write_aln","kind":12,"line":176},{"line":176,"name":"$aln","kind":13,"containerName":"write_aln"},{"kind":12,"containerName":"write_aln","name":"score","line":176},{"containerName":"write_aln","kind":13,"name":"$self","line":177},{"kind":12,"containerName":"write_aln","name":"_print","line":177},{"line":180,"name":"$self","containerName":"write_aln","kind":13},{"line":180,"name":"flush","containerName":"write_aln","kind":12},{"name":"$self","containerName":"write_aln","kind":13,"line":180},{"containerName":"write_aln","kind":12,"name":"_flush_on_write","line":180},{"name":"$self","kind":13,"containerName":"write_aln","line":180},{"name":"_fh","containerName":"write_aln","kind":12,"line":180}],"name":"write_aln","containerName":"main::"},{"detail":"($self,$seq)","definition":"sub","name":"_get_len","containerName":"main::","children":[{"line":195,"localvar":"my","containerName":"_get_len","kind":13,"name":"$self","definition":"my"},{"name":"$seq","containerName":"_get_len","kind":13,"line":195},{"name":"$seq","containerName":"_get_len","kind":13,"line":196},{"containerName":"_get_len","kind":13,"name":"$seq","line":197}],"signature":{"parameters":[{"label":"$self"},{"label":"$seq"}],"documentation":"1;\n# $Id: xmfa.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::AlignIO::xmfa\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::AlignIO::xmfa - XMFA MSA Sequence input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the L<Bio::AlignIO> \nclass.\n\n=head1 DESCRIPTION\n\nThis object can transform L<Bio::SimpleAlign> objects from\nXMFA flat file databases.  For more information, see:\n\n  http://asap.ahabs.wisc.edu/mauve-aligner/mauve-user-guide/mauve-output-file-formats.html\n\nThis module is based on the AlignIO::fasta parser written by\nPeter Schattner\n\n=head1 TODO\n\nFinish write_aln(), clean up code, allow LargeLocatableSeq (ie for\nvery large sequences a'la Mauve)\n\n=head1 FEEDBACK\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS\n\nChris Fields\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::AlignIO::xmfa;\nuse strict;\n\nuse base qw(Bio::AlignIO);\nour $WIDTH = 60;\n\n=head2 next_aln\n\n Title   : next_aln\n Usage   : $aln = $stream->next_aln\n Function: returns the next alignment in the stream.\n Returns : Bio::Align::AlignI object - returns 0 on end of file\n            or on error\n Args    : -width => optional argument to specify the width sequence\n           will be written (60 chars by default)\n\nSee L<Bio::Align::AlignI>\n\n\nsub next_aln {\n    my $self = shift;\n    my ($width) = $self->_rearrange([qw(WIDTH)],@_);\n    $self->width($width || $WIDTH);\n\n    my ($name, $tempname, $seqchar);\n    my $aln = Bio::SimpleAlign->new();\n    my $seqs = 0;\n    # alignments\n    while (defined (my $entry = $self->_readline) ) {\n        chomp $entry;\n        if ( index($entry, '=') == 0 ) {\n            if (defined $name && $seqchar) {\n                my $seq = $self->_process_seq($name, $seqchar);\n                $aln->add_seq($seq);\n            }\n            if ($aln && $entry =~ m{score\\s*=\\s*(\\d+)}) {\n                $aln->score($1);\n            }\n            $seqchar = '';\n            undef $name;\n            last;\n        } elsif ( $entry =~ m{^>.+$}xms) {\n            if ( defined $name ) {\n                my $seq = $self->_process_seq($name, $seqchar);\n                $aln->add_seq($seq);\n            }\n            $seqchar = '';\n            $name = $entry;\n        } else {\n            $seqchar .= $entry;\n        }\n    }\n    \n    # this catches last sequence if '=' is not present (Mauve)\n    if ( defined $name ) {\n        my $seq = $self->_process_seq($name, $seqchar);\n        $aln->add_seq($seq);\n    }\n    $aln->num_sequences ? return $aln : return;\n}\n\n=head2 write_aln\n\n Title   : write_aln\n Usage   : $stream->write_aln(@aln)\n Function: writes the $aln object into the stream in xmfa format\n Returns : 1 for success and 0 for error\n Args    : L<Bio::Align::AlignI> object\n\nSee L<Bio::Align::AlignI>\n\n\nsub write_aln {\n    my ($self,@aln) = @_;\n    my $width = $self->width;\n    my ($seq,$desc,$rseq,$name,$count,$length,$seqsub,$start,$end,$strand,$id);\n\n    foreach my $aln (@aln) {\n        if( ! $aln || ! $aln->isa('Bio::Align::AlignI')  ) { \n            $self->warn(\"Must provide a Bio::Align::AlignI object when calling write_aln\");\n            next;\n        }\n        #if( $self->force_displayname_flat ) {\n        #    $aln->set_displayname_flat(1);\n        #}\n        my $seqct = 1;\n        foreach $rseq ( $aln->each_seq() ) {\n            ($start, $end, $strand, $id) = ($rseq->start, $rseq->end, $rseq->strand || 0,\n                                            $rseq->display_id);\n            $strand = ($strand == 1)  ? '+' :\n                      ($strand == -1) ? '-' :\n                      '';\n            $name = sprintf(\"%d:%d-%d %s %s\",$seqct,$start,$end,$strand,$id);\n            $seq  = $rseq->seq();\n            $desc = $rseq->description || '';\n            $self->_print (\">$name $desc\\n\") or return ;\t\n            $count = 0;\n            $length = length($seq);\n            if(defined $seq && $length > 0) {\n            $seq =~ s/(.{1,$width})/$1\\n/g;\n            } else {\n            $seq = \"\\n\";\n            }\n            $self->_print($seq) || return 0;\n            $seqct++;\n        }\n        my $alndesc = '';\n        $alndesc = \"score = \".$aln->score if ($aln->score);\n        $self->_print(\"= $alndesc\\n\") || return 0;\n        \n    }\n    $self->flush if $self->_flush_on_write && defined $self->_fh;\n    return 1;\n}\n\n=head2 _get_len\n\n Title   : _get_len\n Usage   : \n Function: determine number of alphabetic chars\n Returns : integer\n Args    : sequence string","label":"_get_len($self,$seq)"},"kind":12,"range":{"start":{"line":194,"character":0},"end":{"line":198,"character":9999}},"line":194},{"name":"CORE","kind":12,"containerName":"length","line":197},{"line":212,"range":{"start":{"line":212,"character":0},"end":{"line":217,"character":9999}},"kind":12,"children":[{"definition":"my","localvar":"my","kind":13,"containerName":"width","name":"$self","line":213},{"containerName":"width","kind":13,"name":"$self","line":215},{"containerName":"width","kind":13,"name":"$self","line":216},{"kind":13,"containerName":"width","name":"$WIDTH","line":216}],"containerName":"main::","name":"width","definition":"sub"},{"definition":"sub","detail":"($self,$entry,$seq)","children":[{"name":"$self","containerName":"_process_seq","localvar":"my","kind":13,"line":222,"definition":"my"},{"line":222,"kind":13,"containerName":"_process_seq","name":"$entry"},{"line":222,"name":"$seq","containerName":"_process_seq","kind":13},{"line":223,"localvar":"my","containerName":"_process_seq","kind":13,"name":"$start","definition":"my"},{"containerName":"_process_seq","kind":13,"name":"$end","line":223},{"line":223,"name":"$strand","kind":13,"containerName":"_process_seq"},{"line":223,"name":"$seqname","containerName":"_process_seq","kind":13},{"name":"$desc","containerName":"_process_seq","kind":13,"line":223},{"kind":13,"containerName":"_process_seq","name":"$all","line":223},{"name":"$entry","kind":13,"containerName":"_process_seq","line":225},{"line":226,"containerName":"_process_seq","kind":13,"name":"$start"},{"name":"$end","containerName":"_process_seq","kind":13,"line":226},{"name":"$seqname","containerName":"_process_seq","kind":13,"line":226},{"name":"$desc","containerName":"_process_seq","kind":13,"line":226},{"line":227,"name":"$strand","kind":13,"containerName":"_process_seq"},{"containerName":"_process_seq","kind":13,"name":"$self","line":229},{"containerName":"_process_seq","kind":12,"name":"throw","line":229},{"line":231,"kind":13,"localvar":"my","containerName":"_process_seq","name":"$seqobj","definition":"my"},{"line":231,"kind":12,"containerName":"_process_seq","name":"new"},{"name":"$strand","kind":13,"containerName":"_process_seq","line":233},{"line":234,"kind":13,"containerName":"_process_seq","name":"$seq"},{"name":"$seqname","kind":13,"containerName":"_process_seq","line":235},{"line":236,"name":"$desc","containerName":"_process_seq","kind":13},{"name":"$all","kind":13,"containerName":"_process_seq","line":236},{"containerName":"_process_seq","kind":13,"name":"$start","line":237},{"containerName":"_process_seq","kind":13,"name":"$end","line":238},{"containerName":"_process_seq","kind":13,"name":"$self","line":240},{"name":"debug","containerName":"_process_seq","kind":12,"line":240},{"kind":13,"containerName":"_process_seq","name":"$seqobj","line":241}],"containerName":"main::","name":"_process_seq","signature":{"label":"_process_seq($self,$entry,$seq)","documentation":"###### PRIVATE #######","parameters":[{"label":"$self"},{"label":"$entry"},{"label":"$seq"}]},"line":221,"kind":12,"range":{"start":{"character":0,"line":221},"end":{"line":242,"character":9999}}},{"line":231,"name":"Bio","kind":12,"containerName":"LocatableSeq"}]}