{"vars":[{"name":"base","containerName":"","kind":2,"line":80},{"definition":"sub","containerName":"main::","name":"next_aln","children":[{"line":96,"containerName":"next_aln","localvar":"my","kind":13,"name":"$self","definition":"my"},{"definition":"my","line":97,"name":"$entry","localvar":"my","containerName":"next_aln","kind":13},{"kind":13,"localvar":"my","containerName":"next_aln","name":"$start","line":98,"definition":"my"},{"line":98,"containerName":"next_aln","kind":13,"name":"$end"},{"line":98,"name":"%align","kind":13,"containerName":"next_aln"},{"line":98,"name":"$name","kind":13,"containerName":"next_aln"},{"name":"$seqname","kind":13,"containerName":"next_aln","line":98},{"line":98,"containerName":"next_aln","kind":13,"name":"%hash"},{"name":"@c2name","containerName":"next_aln","kind":13,"line":98},{"containerName":"next_aln","kind":13,"name":"%accession","line":98},{"name":"%desc","kind":13,"containerName":"next_aln","line":98},{"line":99,"name":"$aln","kind":13,"localvar":"my","containerName":"next_aln","definition":"my"},{"line":99,"containerName":"next_aln","kind":12,"name":"new"},{"kind":13,"containerName":"next_aln","name":"$entry","line":105},{"name":"$self","kind":13,"containerName":"next_aln","line":105},{"name":"_readline","kind":12,"containerName":"next_aln","line":105},{"name":"$entry","containerName":"next_aln","kind":13,"line":106},{"name":"$accession","kind":13,"containerName":"next_aln","line":107},{"kind":13,"containerName":"next_aln","name":"$entry","line":109},{"line":110,"name":"$desc","kind":13,"containerName":"next_aln"},{"line":111,"name":"$entry","containerName":"next_aln","kind":13},{"definition":"my","name":"$name","localvar":"my","containerName":"next_aln","kind":13,"line":112},{"line":112,"kind":13,"containerName":"next_aln","name":"$seq"},{"kind":13,"containerName":"next_aln","name":"$align","line":114},{"name":"$name","kind":13,"containerName":"next_aln","line":114},{"line":115,"containerName":"next_aln","kind":13,"name":"@c2name"},{"name":"$name","containerName":"next_aln","kind":13,"line":115},{"line":117,"name":"$align","kind":13,"containerName":"next_aln"},{"name":"$name","kind":13,"containerName":"next_aln","line":117},{"containerName":"next_aln","kind":13,"name":"$seq","line":117},{"name":"$name","localvar":"my","containerName":"next_aln","kind":13,"line":122,"definition":"my"},{"kind":13,"containerName":"next_aln","name":"@c2name","line":122},{"line":124,"name":"$name","containerName":"next_aln","kind":13},{"name":"$seqname","containerName":"next_aln","kind":13,"line":125},{"name":"$start","kind":13,"containerName":"next_aln","line":126},{"name":"$end","kind":13,"containerName":"next_aln","line":127},{"containerName":"next_aln","kind":13,"name":"$seqname","line":129},{"name":"$name","containerName":"next_aln","kind":13,"line":129},{"line":130,"containerName":"next_aln","kind":13,"name":"$start"},{"containerName":"next_aln","kind":13,"name":"$end","line":131},{"containerName":"next_aln","kind":13,"name":"$align","line":131},{"line":131,"name":"$name","kind":13,"containerName":"next_aln"},{"line":133,"localvar":"my","containerName":"next_aln","kind":13,"name":"$seq","definition":"my"},{"name":"new","containerName":"next_aln","kind":12,"line":134},{"line":134,"name":"$align","containerName":"next_aln","kind":13},{"containerName":"next_aln","kind":13,"name":"$name","line":134},{"name":"$seqname","containerName":"next_aln","kind":13,"line":135},{"kind":13,"containerName":"next_aln","name":"$start","line":136},{"containerName":"next_aln","kind":13,"name":"$end","line":137},{"line":138,"name":"$desc","containerName":"next_aln","kind":13},{"containerName":"next_aln","kind":13,"name":"$name","line":138},{"containerName":"next_aln","kind":13,"name":"$accession","line":139},{"containerName":"next_aln","kind":13,"name":"$name","line":139},{"line":142,"name":"$aln","kind":13,"containerName":"next_aln"},{"line":142,"kind":12,"containerName":"next_aln","name":"add_seq"},{"line":142,"containerName":"next_aln","kind":13,"name":"$seq"},{"name":"$aln","kind":13,"containerName":"next_aln","line":145},{"name":"$aln","containerName":"next_aln","kind":13,"line":145},{"line":145,"containerName":"next_aln","kind":12,"name":"num_sequences"}],"range":{"start":{"line":95,"character":0},"end":{"character":9999,"line":147}},"kind":12,"line":95},{"name":"Bio","containerName":"SimpleAlign","kind":12,"line":99},{"containerName":"LocatableSeq","kind":12,"name":"Bio","line":133},{"containerName":"main::","name":"write_aln","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"write_aln","name":"$self","line":162},{"line":162,"containerName":"write_aln","kind":13,"name":"@aln"},{"definition":"my","line":163,"name":"$namestr","localvar":"my","containerName":"write_aln","kind":13},{"line":163,"kind":13,"containerName":"write_aln","name":"$seq"},{"line":163,"name":"$add","kind":13,"containerName":"write_aln"},{"definition":"my","name":"$maxn","localvar":"my","kind":13,"containerName":"write_aln","line":164},{"definition":"my","line":165,"kind":13,"localvar":"my","containerName":"write_aln","name":"$aln"},{"line":165,"kind":13,"containerName":"write_aln","name":"@aln"},{"line":166,"name":"$maxn","containerName":"write_aln","kind":13},{"containerName":"write_aln","kind":13,"name":"$aln","line":166},{"name":"maxdisplayname_length","containerName":"write_aln","kind":12,"line":166},{"line":167,"kind":13,"containerName":"write_aln","name":"$seq"},{"line":167,"kind":13,"containerName":"write_aln","name":"$aln"},{"line":167,"kind":12,"containerName":"write_aln","name":"each_seq"},{"line":168,"name":"$namestr","containerName":"write_aln","kind":13},{"containerName":"write_aln","kind":13,"name":"$aln","line":168},{"line":168,"name":"displayname","kind":12,"containerName":"write_aln"},{"name":"$seq","kind":13,"containerName":"write_aln","line":168},{"line":168,"containerName":"write_aln","kind":12,"name":"get_nse"},{"kind":13,"containerName":"write_aln","name":"$add","line":169},{"name":"$maxn","containerName":"write_aln","kind":13,"line":169},{"name":"$namestr","containerName":"write_aln","kind":13,"line":169},{"kind":13,"containerName":"write_aln","name":"$namestr","line":170},{"line":170,"kind":13,"containerName":"write_aln","name":"$add"},{"line":171,"kind":13,"containerName":"write_aln","name":"$self"},{"line":171,"containerName":"write_aln","kind":12,"name":"_print"},{"line":171,"name":"$namestr","kind":13,"containerName":"write_aln"},{"name":"$seq","kind":13,"containerName":"write_aln","line":171},{"line":171,"containerName":"write_aln","kind":12,"name":"seq"},{"name":"$self","kind":13,"containerName":"write_aln","line":174},{"line":174,"kind":12,"containerName":"write_aln","name":"flush"},{"name":"$self","containerName":"write_aln","kind":13,"line":174},{"line":174,"name":"_flush_on_write","kind":12,"containerName":"write_aln"},{"kind":13,"containerName":"write_aln","name":"$self","line":174},{"name":"_fh","containerName":"write_aln","kind":12,"line":174}],"detail":"($self,@aln)","definition":"sub","range":{"end":{"line":176,"character":9999},"start":{"line":161,"character":0}},"kind":12,"line":161,"signature":{"documentation":"1;\n# $Id: selex.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::AlignIO::selex\n\n#   based on the Bio::SeqIO::selex module\n#       by Ewan Birney <birney@ebi.ac.uk>\n#       and Lincoln Stein  <lstein@cshl.org>\n#\n#       and the SimpleAlign.pm module of Ewan Birney\n#\n# Copyright Peter Schattner\n#\n# You may distribute this module under the same terms as perl itself\n# _history\n# September 5, 2000\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::AlignIO::selex - selex sequence input/output stream\n\n=head1 SYNOPSIS\n\n  # Do not use this module directly.  Use it via the L<Bio::AlignIO> class.\n\n  use Bio::AlignIO;\n  use strict;\n\n  my $in = Bio::AlignIO->new(-format => 'selex',\n                             -file   => 't/data/testaln.selex');\n  while( my $aln = $in->next_aln ) {\n\n  }\n\n=head1 DESCRIPTION\n\nThis object can transform L<Bio::Align::AlignI> objects to and from selex flat\nfile databases.\n\n=head1 FEEDBACK\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Peter Schattner\n\nEmail: schattner@alum.mit.edu\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::AlignIO::selex;\nuse strict;\n\nuse base qw(Bio::AlignIO);\n\n=head2 next_aln\n\n Title   : next_aln\n Usage   : $aln = $stream->next_aln()\n Function: returns the next alignment in the stream. Tries to read *all* selex\n          It reads all non whitespace characters in the alignment\n          area. For selexs with weird gaps (eg ~~~) map them by using\n          $al->map_chars('~','-')\n Returns : L<Bio::Align::AlignI> object\n Args    : NONE\n\n\nsub next_aln {\n    my $self = shift;\n    my $entry;\n    my ($start,$end,%align,$name,$seqname,%hash,@c2name, %accession,%desc);\n    my $aln =  Bio::SimpleAlign->new(-source => 'selex');\n\n    # in selex format, every non-blank line that does not start\n    # with '#=' is an alignment segment; the '#=' lines are mark up lines.\n    # Of particular interest are the '#=GF <name/st-ed> AC <accession>'\n    # lines, which give accession numbers for each segment\n    while( $entry = $self->_readline) {\n        if( $entry =~ /^\\#=GS\\s+(\\S+)\\s+AC\\s+(\\S+)/ ) {\n\t    $accession{ $1 } = $2;\n\t    next;\n\t} elsif( $entry =~ /^\\#=GS\\s+(\\S+)\\s+DE\\s+(.+)\\s*$/ ) {\n\t    $desc{$1} .= $2;\n\t} elsif ( $entry =~ /^([^\\#]\\S+)\\s+([A-Za-z\\.\\-\\*]+)\\s*/ ) {\n\t    my ($name,$seq) = ($1,$2);\n\n\t    if( ! defined $align{$name}  ) {\n\t\tpush @c2name, $name;\n\t    }\n\t    $align{$name} .= $seq;\n\t}\n    }\n    # ok... now we can make the sequences\n\n    foreach my $name ( @c2name ) {\n\n\tif( $name =~ /(\\S+)\\/(\\d+)-(\\d+)/ ) {\n\t    $seqname = $1;\n\t    $start = $2;\n\t    $end = $3;\n\t} else {\n\t    $seqname=$name;\n\t    $start = 1;\n\t    $end = length($align{$name});\n\t}\n\tmy $seq = Bio::LocatableSeq->new\n\t    ('-seq'              => $align{$name},\n\t     '-display_id'       => $seqname,\n\t     '-start'            => $start,\n\t     '-end'              => $end,\n\t     '-description'      => $desc{$name},\n\t     '-accession_number' => $accession{$name},\n\t     );\n\n\t$aln->add_seq($seq);\n    }\n\n    return $aln if $aln->num_sequences;\n    return;\n}\n\n\n=head2 write_aln\n\n Title   : write_aln\n Usage   : $stream->write_aln(@aln)\n Function: writes the $aln object into the stream in selex format\n Returns : 1 for success and 0 for error\n Args    : L<Bio::Align::AlignI> object","parameters":[{"label":"$self"},{"label":"@aln"}],"label":"write_aln($self,@aln)"}}],"version":5}