{"vars":[{"line":80,"name":"vars","kind":2,"containerName":""},{"line":85,"name":"base","kind":2,"containerName":""},{"containerName":null,"kind":13,"name":"$EMBOSSTitleLen","line":88},{"line":89,"containerName":null,"kind":13,"name":"$EMBOSSLineLen"},{"kind":12,"range":{"end":{"character":9999,"line":96},"start":{"line":92,"character":0}},"line":92,"signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"","label":"_initialize($self,@args)"},"name":"_initialize","containerName":"main::","children":[{"definition":"my","line":93,"containerName":"_initialize","localvar":"my","kind":13,"name":"$self"},{"line":93,"name":"@args","kind":13,"containerName":"_initialize"},{"line":94,"kind":13,"containerName":"_initialize","name":"$self"},{"name":"@args","kind":13,"containerName":"_initialize","line":94},{"name":"$self","kind":13,"containerName":"_initialize","line":95}],"detail":"($self,@args)","definition":"sub"},{"line":94,"containerName":"_initialize","kind":12,"name":"SUPER"},{"children":[{"line":110,"containerName":"next_aln","localvar":"my","kind":13,"name":"$self","definition":"my"},{"line":111,"kind":13,"localvar":"my","containerName":"next_aln","name":"$seenbegin","definition":"my"},{"definition":"my","line":112,"kind":13,"localvar":"my","containerName":"next_aln","name":"%data"},{"line":123,"name":"$self","containerName":"next_aln","kind":13},{"definition":"my","localvar":"my","kind":13,"containerName":"next_aln","name":"%names","line":126},{"line":127,"kind":13,"containerName":"next_aln","name":"$self"},{"line":127,"name":"_readline","kind":12,"containerName":"next_aln"},{"line":130,"name":"$seenbegin","kind":13,"containerName":"next_aln"},{"definition":"my","line":134,"name":"$name1","localvar":"my","kind":13,"containerName":"next_aln"},{"line":134,"kind":13,"containerName":"next_aln","name":"$name2"},{"containerName":"next_aln","kind":13,"name":"$name1","line":135},{"kind":13,"containerName":"next_aln","name":"$data","line":136},{"line":137,"containerName":"next_aln","kind":13,"name":"$name1"},{"name":"$name2","containerName":"next_aln","kind":13,"line":137},{"line":139,"kind":13,"containerName":"next_aln","name":"$data"},{"containerName":"next_aln","kind":13,"name":"$data","line":141},{"line":141,"name":"$name1","containerName":"next_aln","kind":13},{"line":142,"kind":13,"containerName":"next_aln","name":"$data"},{"line":142,"name":"$name2","containerName":"next_aln","kind":13},{"name":"$self","kind":13,"containerName":"next_aln","line":144},{"containerName":"next_aln","kind":13,"name":"$data","line":144},{"line":147,"containerName":"next_aln","kind":13,"name":"$data"},{"kind":13,"containerName":"next_aln","name":"$data","line":148},{"definition":"my","line":149,"name":"$nm","localvar":"my","kind":13,"containerName":"next_aln"},{"name":"$nm","kind":13,"containerName":"next_aln","line":150},{"kind":13,"containerName":"next_aln","name":"$nm","line":150},{"containerName":"next_aln","kind":13,"name":"$EMBOSSTitleLen","line":150},{"line":151,"name":"$names","kind":13,"containerName":"next_aln"},{"line":151,"name":"$nm","kind":13,"containerName":"next_aln"},{"line":152,"name":"$nm","containerName":"next_aln","kind":13},{"line":152,"name":"$names","kind":13,"containerName":"next_aln"},{"name":"$nm","containerName":"next_aln","kind":13,"line":152},{"name":"$names","containerName":"next_aln","kind":13,"line":154},{"name":"$nm","containerName":"next_aln","kind":13,"line":154},{"containerName":"next_aln","kind":13,"name":"$data","line":155},{"line":155,"name":"$nm","kind":13,"containerName":"next_aln"},{"line":156,"containerName":"next_aln","kind":13,"name":"$data"},{"definition":"my","name":"$count","kind":13,"localvar":"my","containerName":"next_aln","line":158},{"name":"$seenbegin","kind":13,"containerName":"next_aln","line":159},{"definition":"my","line":160,"name":"@current","localvar":"my","containerName":"next_aln","kind":13},{"localvar":"my","containerName":"next_aln","kind":13,"name":"$align_other","line":162,"definition":"my"},{"definition":"my","line":163,"name":"$delayed","containerName":"next_aln","localvar":"my","kind":13},{"line":164,"kind":13,"containerName":"next_aln","name":"$count"},{"line":164,"containerName":"next_aln","kind":13,"name":"$count"},{"definition":"my","localvar":"my","kind":13,"containerName":"next_aln","name":"@l","line":165},{"definition":"my","name":"$seq","kind":13,"localvar":"my","containerName":"next_aln","line":166},{"kind":13,"containerName":"next_aln","name":"$align","line":166},{"name":"$start","kind":13,"containerName":"next_aln","line":166},{"kind":13,"containerName":"next_aln","name":"$end","line":166},{"containerName":"next_aln","kind":13,"name":"$count","line":167},{"line":167,"name":"$data","kind":13,"containerName":"next_aln"},{"line":169,"containerName":"next_aln","kind":13,"name":"$start"},{"name":"$align","containerName":"next_aln","kind":13,"line":169},{"line":169,"kind":13,"containerName":"next_aln","name":"$end"},{"line":169,"name":"@l","kind":13,"containerName":"next_aln"},{"kind":13,"containerName":"next_aln","name":"@l","line":170},{"name":"$align","kind":13,"containerName":"next_aln","line":171},{"line":172,"name":"$seq","kind":13,"containerName":"next_aln"},{"line":172,"name":"$start","containerName":"next_aln","kind":13},{"line":172,"kind":13,"containerName":"next_aln","name":"$end"},{"name":"@l","containerName":"next_aln","kind":13,"line":173},{"line":174,"name":"$seq","kind":13,"containerName":"next_aln"},{"line":174,"name":"$start","kind":13,"containerName":"next_aln"},{"line":174,"name":"$align","kind":13,"containerName":"next_aln"},{"line":174,"kind":13,"containerName":"next_aln","name":"$end"},{"containerName":"next_aln","kind":13,"name":"@l","line":174},{"line":177,"name":"$seqname","localvar":"my","kind":13,"containerName":"next_aln","definition":"my"},{"kind":13,"containerName":"next_aln","name":"$count","line":177},{"containerName":"next_aln","kind":13,"name":"$data","line":178},{"name":"$seqname","containerName":"next_aln","kind":13,"line":178},{"name":"$align","kind":13,"containerName":"next_aln","line":178},{"name":"$data","containerName":"next_aln","kind":13,"line":179},{"line":179,"containerName":"next_aln","kind":13,"name":"$seqname"},{"line":179,"kind":13,"containerName":"next_aln","name":"$start"},{"line":180,"containerName":"next_aln","kind":13,"name":"$data"},{"kind":13,"containerName":"next_aln","name":"$seqname","line":180},{"name":"$end","containerName":"next_aln","kind":13,"line":180},{"line":181,"name":"$current","containerName":"next_aln","kind":13},{"line":181,"name":"$count","kind":13,"containerName":"next_aln"},{"kind":13,"containerName":"next_aln","name":"$start","line":181},{"name":"$align","containerName":"next_aln","kind":13,"line":181},{"line":185,"name":"$data","kind":13,"containerName":"next_aln"},{"kind":13,"containerName":"next_aln","name":"$count","line":189},{"line":190,"name":"$self","containerName":"next_aln","kind":13},{"name":"_readline","kind":12,"containerName":"next_aln","line":190},{"line":193,"kind":13,"containerName":"next_aln","name":"$data"},{"containerName":"next_aln","localvar":"my","kind":13,"name":"$s1","line":196,"definition":"my"},{"name":"$s2","containerName":"next_aln","kind":13,"line":196},{"name":"$data","containerName":"next_aln","kind":13,"line":196},{"line":196,"containerName":"next_aln","kind":13,"name":"$data"},{"definition":"my","containerName":"next_aln","localvar":"my","kind":13,"name":"$d","line":198},{"line":198,"name":"$current","containerName":"next_aln","kind":13},{"line":198,"kind":13,"containerName":"next_aln","name":"$current"},{"name":"$d","kind":13,"containerName":"next_aln","line":199},{"name":"$current","kind":13,"containerName":"next_aln","line":201},{"line":202,"containerName":"next_aln","kind":13,"name":"$s1"},{"containerName":"next_aln","kind":13,"name":"$d","line":202},{"name":"$s1","containerName":"next_aln","kind":13,"line":202},{"line":203,"name":"$data","containerName":"next_aln","kind":13},{"name":"$d","containerName":"next_aln","kind":13,"line":203},{"line":203,"name":"$data","kind":13,"containerName":"next_aln"},{"name":"$s1","kind":13,"containerName":"next_aln","line":205},{"name":"$d","containerName":"next_aln","kind":13,"line":205},{"line":206,"name":"$data","kind":13,"containerName":"next_aln"},{"line":206,"containerName":"next_aln","kind":13,"name":"$d"},{"line":208,"kind":13,"containerName":"next_aln","name":"$d"},{"line":209,"kind":13,"containerName":"next_aln","name":"$current"},{"line":210,"name":"$s2","kind":13,"containerName":"next_aln"},{"kind":13,"containerName":"next_aln","name":"$d","line":210},{"name":"$s2","kind":13,"containerName":"next_aln","line":210},{"name":"$data","containerName":"next_aln","kind":13,"line":211},{"name":"$d","kind":13,"containerName":"next_aln","line":211},{"line":211,"name":"$data","containerName":"next_aln","kind":13},{"containerName":"next_aln","kind":13,"name":"$s2","line":213},{"name":"$d","kind":13,"containerName":"next_aln","line":213},{"name":"$data","kind":13,"containerName":"next_aln","line":214},{"name":"$d","kind":13,"containerName":"next_aln","line":214},{"kind":13,"containerName":"next_aln","name":"$seenbegin","line":221},{"definition":"my","line":222,"localvar":"my","kind":13,"containerName":"next_aln","name":"$aln"},{"line":222,"name":"new","containerName":"next_aln","kind":12},{"line":222,"name":"$self","kind":13,"containerName":"next_aln"},{"line":222,"name":"verbose","kind":12,"containerName":"next_aln"},{"kind":13,"containerName":"next_aln","name":"$data","line":223},{"kind":13,"containerName":"next_aln","name":"$data","line":224},{"containerName":"next_aln","localvar":"my","kind":13,"name":"$seqname","line":226,"definition":"my"},{"name":"$data","containerName":"next_aln","kind":13,"line":227},{"kind":13,"containerName":"next_aln","name":"$seqname","line":227},{"name":"$data","containerName":"next_aln","kind":13,"line":228},{"name":"$seqname","containerName":"next_aln","kind":13,"line":228},{"name":"$seqname","kind":13,"containerName":"next_aln","line":228},{"definition":"my","line":229,"localvar":"my","containerName":"next_aln","kind":13,"name":"$seq"},{"line":229,"name":"new","containerName":"next_aln","kind":12},{"name":"$data","kind":13,"containerName":"next_aln","line":229},{"line":229,"containerName":"next_aln","kind":13,"name":"$seqname"},{"name":"$data","containerName":"next_aln","kind":13,"line":230},{"kind":13,"containerName":"next_aln","name":"$seqname","line":230},{"line":231,"kind":13,"containerName":"next_aln","name":"$data"},{"containerName":"next_aln","kind":13,"name":"$seqname","line":231},{"name":"$data","kind":13,"containerName":"next_aln","line":232},{"line":232,"kind":13,"containerName":"next_aln","name":"$seqname"},{"name":"$aln","containerName":"next_aln","kind":13,"line":234},{"line":234,"name":"add_seq","kind":12,"containerName":"next_aln"},{"kind":13,"containerName":"next_aln","name":"$seq","line":234},{"line":236,"name":"$aln","containerName":"next_aln","kind":13}],"containerName":"main::","name":"next_aln","definition":"sub","detail":"($self)","line":109,"kind":12,"range":{"start":{"line":109,"character":0},"end":{"character":9999,"line":237}},"signature":{"label":"next_aln($self)","documentation":"1;\n# $Id: emboss.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::AlignIO::emboss\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::AlignIO::emboss - Parse EMBOSS alignment output (from applications water and needle)\n\n=head1 SYNOPSIS\n\n    # do not use the object directly\n    use Bio::AlignIO;\n    # read in an alignment from the EMBOSS program water\n    my $in = Bio::AlignIO->new(-format => 'emboss',\n                              -file   => 'seq.water');\n    while( my $aln = $in->next_aln ) {\n    # do something with the alignment\n    }\n\n=head1 DESCRIPTION\n\nThis object handles parsing and writing pairwise sequence alignments\nfrom the EMBOSS suite.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::AlignIO::emboss;\nuse vars qw($EMBOSSTitleLen $EMBOSSLineLen);\nuse strict;\n\nuse Bio::LocatableSeq;\n\nuse base qw(Bio::AlignIO);\n\nBEGIN {\n    $EMBOSSTitleLen    = 13;\n    $EMBOSSLineLen     = 50;\n}\n\nsub _initialize {\n    my($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    $self->{'_type'} = undef;\n}\n\n=head2 next_aln\n\n Title   : next_aln\n Usage   : $aln = $stream->next_aln()\n Function: returns the next alignment in the stream.\n Returns : L<Bio::Align::AlignI> object - returns 0 on end of file\n\t    or on error\n Args    : NONE","parameters":[{"label":"$self"}]}},{"kind":12,"name":"BOTTOM","line":188},{"kind":12,"containerName":"SimpleAlign","name":"Bio","line":222},{"kind":12,"containerName":"LocatableSeq","name":"Bio","line":229},{"containerName":"main::","name":"write_aln","children":[{"localvar":"my","containerName":"write_aln","kind":13,"name":"$self","line":251,"definition":"my"},{"line":251,"containerName":"write_aln","kind":13,"name":"@aln"},{"line":253,"name":"$self","kind":13,"containerName":"write_aln"},{"line":253,"containerName":"write_aln","kind":12,"name":"throw"}],"detail":"($self,@aln)","definition":"sub","kind":12,"range":{"start":{"character":0,"line":250},"end":{"line":254,"character":9999}},"line":250,"signature":{"documentation":"1;\n# $Id: emboss.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::AlignIO::emboss\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::AlignIO::emboss - Parse EMBOSS alignment output (from applications water and needle)\n\n=head1 SYNOPSIS\n\n    # do not use the object directly\n    use Bio::AlignIO;\n    # read in an alignment from the EMBOSS program water\n    my $in = Bio::AlignIO->new(-format => 'emboss',\n                              -file   => 'seq.water');\n    while( my $aln = $in->next_aln ) {\n    # do something with the alignment\n    }\n\n=head1 DESCRIPTION\n\nThis object handles parsing and writing pairwise sequence alignments\nfrom the EMBOSS suite.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::AlignIO::emboss;\nuse vars qw($EMBOSSTitleLen $EMBOSSLineLen);\nuse strict;\n\nuse Bio::LocatableSeq;\n\nuse base qw(Bio::AlignIO);\n\nBEGIN {\n    $EMBOSSTitleLen    = 13;\n    $EMBOSSLineLen     = 50;\n}\n\nsub _initialize {\n    my($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    $self->{'_type'} = undef;\n}\n\n=head2 next_aln\n\n Title   : next_aln\n Usage   : $aln = $stream->next_aln()\n Function: returns the next alignment in the stream.\n Returns : L<Bio::Align::AlignI> object - returns 0 on end of file\n\t    or on error\n Args    : NONE\n\n\nsub next_aln {\n    my ($self) = @_;\n    my $seenbegin = 0;\n    my %data = ( 'seq1' => {\n\t\t     'start'=> undef,\n\t\t     'end'=> undef,\n\t\t     'name' => '',\n\t\t     'data' => '' },\n\t\t 'seq2' => {\n\t\t     'start'=> undef,\n\t\t     'end'=> undef,\n\t\t     'name' => '',\n\t\t     'data' => '' },\n\t\t 'align' => '',\n\t\t 'type'  => $self->{'_type'},  # to restore type from\n\t\t                                     # previous aln if possible\n\t\t );\n    my %names;\n    while( defined($_ = $self->_readline) ) {\n\tnext if( /^\\#?\\s+$/ || /^\\#+\\s*$/ );\n\tif( /^\\#(\\=|\\-)+\\s*$/) {\n\t    last if( $seenbegin);\n\t} elsif( /(Local|Global):\\s*(\\S+)\\s+vs\\s+(\\S+)/ ||\n\t\t /^\\#\\s+Program:\\s+(\\S+)/ )\n\t{\n\t    my ($name1,$name2) = ($2,$3);\n\t    if( ! defined $name1 ) { # Handle EMBOSS 2.2.X\n\t\t$data{'type'} = $1;\n\t\t$name1 = $name2 = '';\n\t    } else {\n\t\t$data{'type'} = $1 eq 'Local' ? 'water' : 'needle';\n\t    }\n\t    $data{'seq1'}->{'name'} = $name1;\n\t    $data{'seq2'}->{'name'} = $name2;\n\n\t    $self->{'_type'} = $data{'type'};\n\n\t} elsif( /Score:\\s+(\\S+)/ ) {\n\t    $data{'score'} = $1;\n\t} elsif( /^\\#\\s+(1|2):\\s+(\\S+)/ && !  $data{\"seq$1\"}->{'name'} ) {\n\t    my $nm = $2;\n\t    $nm = substr($nm,0,$EMBOSSTitleLen); # emboss has a max seq length\n\t    if( $names{$nm} ) {\n\t\t$nm .= \"-\". $names{$nm};\n\t    }\n\t    $names{$nm}++;\n\t    $data{\"seq$1\"}->{'name'} = $nm;\n\t} elsif( $data{'seq1'}->{'name'} &&\n\t\t /^\\Q$data{'seq1'}->{'name'}/ ) {\n\t    my $count = 0;\n\t    $seenbegin = 1;\n\t    my @current;\n\t    while( defined ($_) ) {\n\t\tmy $align_other = '';\n\t\tmy $delayed;\n\t\tif($count == 0 || $count == 2 ) {\n\t\t    my @l = split;\n\t\t    my ($seq,$align,$start,$end);\n\t\t    if( $count == 2 && $data{'seq2'}->{'name'} eq '' ) {\n\t\t\t# weird boundary condition\n\t\t\t($start,$align,$end) = @l;\n\t\t    } elsif( @l == 3 ) {\n\t\t\t$align = '';\n\t\t\t($seq,$start,$end) = @l\n\t\t    } else {\n\t\t\t($seq,$start,$align,$end) = @l;\n \t\t    }\n\n\t\t    my $seqname = sprintf(\"seq%d\", ($count == 0) ? '1' : '2');\n\t\t    $data{$seqname}->{'data'} .= $align;\n\t\t    $data{$seqname}->{'start'} ||= $start;\n\t\t    $data{$seqname}->{'end'} = $end;\n\t\t    $current[$count] = [ $start,$align || ''];\n\t\t} else {\n\t\t    s/^\\s+//;\n\t\t    s/\\s+$//;\n\t\t    $data{'align'} .= $_;\n\t\t}\n\n\t      BOTTOM:\n\t\tlast if( $count++ == 2);\n\t\t$_ = $self->_readline();\n\t    }\n\n\t    if( $data{'type'} eq 'needle' ) {\n\t\t# which ever one is shorter we want to bring it up to\n\t\t# length.  Man this stinks.\n\t\tmy ($s1,$s2) =  ($data{'seq1'}, $data{'seq2'});\n\n\t\tmy $d = length($current[0]->[1]) - length($current[2]->[1]);\n\t\tif( $d < 0 ) { # s1 is smaller, need to add some\n\t\t    # compare the starting points for this alignment line\n\t\t    if( $current[0]->[0] <= 1 ) {\n\t\t\t$s1->{'data'} = ('-' x abs($d)) . $s1->{'data'};\n\t\t\t$data{'align'} = (' 'x abs($d)).$data{'align'};\n\t\t    } else {\n\t\t\t$s1->{'data'} .= '-' x abs($d);\n\t\t\t$data{'align'} .= ' 'x abs($d);\n\t\t    }\n\t\t} elsif( $d > 0) { # s2 is smaller, need to add some\n\t\t    if( $current[2]->[0] <= 1 ) {\n\t\t\t$s2->{'data'} = ('-' x abs($d)) . $s2->{'data'};\n\t\t\t$data{'align'} = (' 'x abs($d)).$data{'align'};\n\t\t    } else {\n\t\t\t$s2->{'data'} .= '-' x abs($d);\n\t\t\t$data{'align'} .= ' 'x abs($d);\n\t\t    }\n\t\t}\n\t    }\n\n\t}\n    }\n    return unless $seenbegin;\n    my $aln =  Bio::SimpleAlign->new(-verbose => $self->verbose(),\n\t\t\t\t     -score   => $data{'score'},\n\t\t\t\t     -source => \"EMBOSS-\".$data{'type'});\n\n    foreach my $seqname ( qw(seq1 seq2) ) {\n\treturn unless ( defined $data{$seqname} );\n\t$data{$seqname}->{'name'} ||= $seqname;\n\tmy $seq = Bio::LocatableSeq->new('-seq' => $data{$seqname}->{'data'},\n\t\t\t\t\t'-id'  => $data{$seqname}->{'name'},\n\t\t\t\t\t'-start'=> $data{$seqname}->{'start'},\n\t\t\t\t\t'-end' => $data{$seqname}->{'end'},\n\t\t\t\t\t);\n\t$aln->add_seq($seq);\n    }\n    return $aln;\n}\n\n=head2 write_aln\n\n Title   : write_aln\n Usage   : $stream->write_aln(@aln)\n Function: writes the $aln object into the stream in emboss format\n Returns : 1 for success and 0 for error\n Args    : L<Bio::Align::AlignI> object","parameters":[{"label":"$self"},{"label":"@aln"}],"label":"write_aln($self,@aln)"}}],"version":5}