{"vars":[{"name":"vars","containerName":"","kind":2,"line":79},{"name":"$GapChars","kind":13,"containerName":null,"line":83},{"containerName":"","kind":2,"name":"strict","line":83},{"kind":2,"containerName":"","name":"base","line":85},{"signature":{"label":"number_of_comparable_bases($self,$aln)","documentation":"1;\n# $Id: PairwiseStatistics.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::PairwiseStatistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::PairwiseStatistics - Base statistic object for Pairwise Alignments\n\n=head1 SYNOPSIS\n\n  use strict;\n  my $stats = Bio::Align::PairwiseStatistics->new();\n\n  # get alignment object of two sequences somehow\n  my $pwaln;\n  print $stats->number_of_comparable_bases($pwaln);\n  my $score = $stats->score_nuc($pwaln);\n\n\n=head1 DESCRIPTION\n\nCalculate pairwise statistics.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::PairwiseStatistics;\nuse vars qw($GapChars);\nuse strict;\n\n\nBEGIN { $GapChars = '(\\.|\\-)'; }\n\nuse base qw(Bio::Root::Root Bio::Align::StatisticsI);\n\n=head2 number_of_comparable_bases\n\n Title   : number_of_comparable_bases\n Usage   : my $bases = $stat->number_of_comparable_bases($aln);\n Function: Returns the count of the number of bases that can be\n           compared (L) in this alignment ( length - gaps)\n Returns : integer\n Args    : L<Bio::Align::AlignI>","parameters":[{"label":"$self"},{"label":"$aln"}]},"line":99,"range":{"start":{"character":0,"line":99},"end":{"line":111,"character":9999}},"kind":12,"definition":"sub","detail":"($self,$aln)","children":[{"line":100,"kind":13,"localvar":"my","containerName":"number_of_comparable_bases","name":"$self","definition":"my"},{"line":100,"name":"$aln","containerName":"number_of_comparable_bases","kind":13},{"line":101,"containerName":"number_of_comparable_bases","kind":13,"name":"$aln"},{"line":101,"kind":13,"containerName":"number_of_comparable_bases","name":"$aln"},{"kind":12,"containerName":"number_of_comparable_bases","name":"isa","line":101},{"containerName":"number_of_comparable_bases","kind":13,"name":"$self","line":102},{"name":"throw","containerName":"number_of_comparable_bases","kind":12,"line":102},{"line":105,"containerName":"number_of_comparable_bases","kind":13,"name":"$aln"},{"containerName":"number_of_comparable_bases","kind":12,"name":"num_sequences","line":105},{"name":"$self","kind":13,"containerName":"number_of_comparable_bases","line":106},{"name":"throw","kind":12,"containerName":"number_of_comparable_bases","line":106},{"name":"$aln","containerName":"number_of_comparable_bases","kind":13,"line":107},{"containerName":"number_of_comparable_bases","kind":12,"name":"num_sequences","line":107},{"definition":"my","containerName":"number_of_comparable_bases","localvar":"my","kind":13,"name":"$L","line":109},{"line":109,"name":"$aln","containerName":"number_of_comparable_bases","kind":13},{"line":109,"kind":12,"containerName":"number_of_comparable_bases","name":"length"},{"line":109,"kind":13,"containerName":"number_of_comparable_bases","name":"$self"},{"line":109,"containerName":"number_of_comparable_bases","kind":12,"name":"number_of_gaps"},{"name":"$aln","containerName":"number_of_comparable_bases","kind":13,"line":109},{"line":110,"name":"$L","containerName":"number_of_comparable_bases","kind":13}],"name":"number_of_comparable_bases","containerName":"main::"},{"signature":{"parameters":[{"label":"$self"},{"label":"$aln"}],"documentation":"1;\n# $Id: PairwiseStatistics.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::PairwiseStatistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::PairwiseStatistics - Base statistic object for Pairwise Alignments\n\n=head1 SYNOPSIS\n\n  use strict;\n  my $stats = Bio::Align::PairwiseStatistics->new();\n\n  # get alignment object of two sequences somehow\n  my $pwaln;\n  print $stats->number_of_comparable_bases($pwaln);\n  my $score = $stats->score_nuc($pwaln);\n\n\n=head1 DESCRIPTION\n\nCalculate pairwise statistics.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::PairwiseStatistics;\nuse vars qw($GapChars);\nuse strict;\n\n\nBEGIN { $GapChars = '(\\.|\\-)'; }\n\nuse base qw(Bio::Root::Root Bio::Align::StatisticsI);\n\n=head2 number_of_comparable_bases\n\n Title   : number_of_comparable_bases\n Usage   : my $bases = $stat->number_of_comparable_bases($aln);\n Function: Returns the count of the number of bases that can be\n           compared (L) in this alignment ( length - gaps)\n Returns : integer\n Args    : L<Bio::Align::AlignI>\n\n\n\nsub number_of_comparable_bases{\n   my ($self,$aln) = @_;\n  if ( ! defined $aln || ! $aln->isa('Bio::Align::AlignI') ) {\n    $self->throw(\"Must provide a Bio::Align::AlignI compliant object to \".\n      \"Bio::Align::PairwiseStatistics\");\n       return 0;\n  } elsif ( $aln->num_sequences != 2 ) { \n    $self->throw(\"Only pairwise calculations supported. Found \".\n      $aln->num_sequences.\" sequences in alignment\\n\");\n   }\n   my $L = $aln->length - $self->number_of_gaps($aln);\n   return $L;\n}\n\n=head2 number_of_differences\n\n Title   : number_of_differences\n Usage   : my $nd = $stat->number_of_distances($aln);\n Function: Returns the number of differences between two sequences\n Returns : integer\n Args    : L<Bio::Align::AlignI>","label":"number_of_differences($self,$aln)"},"line":124,"kind":12,"range":{"start":{"character":0,"line":124},"end":{"character":9999,"line":150}},"definition":"sub","detail":"($self,$aln)","children":[{"line":125,"name":"$self","kind":13,"localvar":"my","containerName":"number_of_differences","definition":"my"},{"name":"$aln","containerName":"number_of_differences","kind":13,"line":125},{"kind":13,"containerName":"number_of_differences","name":"$aln","line":126},{"line":126,"name":"$aln","containerName":"number_of_differences","kind":13},{"line":126,"name":"isa","kind":12,"containerName":"number_of_differences"},{"name":"$self","containerName":"number_of_differences","kind":13,"line":127},{"line":127,"name":"throw","kind":12,"containerName":"number_of_differences"},{"line":129,"kind":13,"containerName":"number_of_differences","name":"$aln"},{"line":129,"name":"num_sequences","kind":12,"containerName":"number_of_differences"},{"line":130,"name":"$self","kind":13,"containerName":"number_of_differences"},{"name":"throw","kind":12,"containerName":"number_of_differences","line":130},{"line":131,"kind":13,"containerName":"number_of_differences","name":"$aln"},{"containerName":"number_of_differences","kind":12,"name":"num_sequences","line":131},{"line":133,"localvar":"my","containerName":"number_of_differences","kind":13,"name":"@seqs","definition":"my"},{"definition":"my","line":134,"name":"$seq","kind":13,"localvar":"my","containerName":"number_of_differences"},{"containerName":"number_of_differences","kind":13,"name":"$aln","line":134},{"kind":12,"containerName":"number_of_differences","name":"each_seq","line":134},{"line":135,"containerName":"number_of_differences","kind":13,"name":"@seqs"},{"line":135,"name":"$seq","kind":13,"containerName":"number_of_differences"},{"kind":12,"containerName":"number_of_differences","name":"seq","line":135},{"definition":"my","containerName":"number_of_differences","localvar":"my","kind":13,"name":"$firstseq","line":137},{"line":137,"kind":13,"containerName":"number_of_differences","name":"@seqs"},{"definition":"my","name":"$diffcount","kind":13,"localvar":"my","containerName":"number_of_differences","line":139},{"localvar":"my","containerName":"number_of_differences","kind":13,"name":"$i","line":140,"definition":"my"},{"name":"$i","containerName":"number_of_differences","kind":13,"line":140},{"name":"$aln","containerName":"number_of_differences","kind":13,"line":140},{"containerName":"number_of_differences","kind":12,"name":"length","line":140},{"name":"$i","containerName":"number_of_differences","kind":13,"line":140},{"line":141,"containerName":"number_of_differences","kind":13,"name":"$firstseq"},{"containerName":"number_of_differences","kind":13,"name":"$i","line":141},{"line":142,"name":"$seq","localvar":"my","containerName":"number_of_differences","kind":13,"definition":"my"},{"line":142,"kind":13,"containerName":"number_of_differences","name":"@seqs"},{"line":143,"name":"$seq","containerName":"number_of_differences","kind":13},{"line":143,"containerName":"number_of_differences","kind":13,"name":"$i"},{"kind":13,"containerName":"number_of_differences","name":"$firstseq","line":144},{"name":"$i","kind":13,"containerName":"number_of_differences","line":144},{"line":144,"containerName":"number_of_differences","kind":13,"name":"$seq"},{"line":144,"name":"$i","containerName":"number_of_differences","kind":13},{"line":145,"kind":13,"containerName":"number_of_differences","name":"$diffcount"},{"line":149,"containerName":"number_of_differences","kind":13,"name":"$diffcount"}],"containerName":"main::","name":"number_of_differences"},{"kind":12,"range":{"end":{"line":175,"character":9999},"start":{"line":163,"character":0}},"line":163,"signature":{"documentation":"1;\n# $Id: PairwiseStatistics.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::PairwiseStatistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::PairwiseStatistics - Base statistic object for Pairwise Alignments\n\n=head1 SYNOPSIS\n\n  use strict;\n  my $stats = Bio::Align::PairwiseStatistics->new();\n\n  # get alignment object of two sequences somehow\n  my $pwaln;\n  print $stats->number_of_comparable_bases($pwaln);\n  my $score = $stats->score_nuc($pwaln);\n\n\n=head1 DESCRIPTION\n\nCalculate pairwise statistics.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::PairwiseStatistics;\nuse vars qw($GapChars);\nuse strict;\n\n\nBEGIN { $GapChars = '(\\.|\\-)'; }\n\nuse base qw(Bio::Root::Root Bio::Align::StatisticsI);\n\n=head2 number_of_comparable_bases\n\n Title   : number_of_comparable_bases\n Usage   : my $bases = $stat->number_of_comparable_bases($aln);\n Function: Returns the count of the number of bases that can be\n           compared (L) in this alignment ( length - gaps)\n Returns : integer\n Args    : L<Bio::Align::AlignI>\n\n\n\nsub number_of_comparable_bases{\n   my ($self,$aln) = @_;\n  if ( ! defined $aln || ! $aln->isa('Bio::Align::AlignI') ) {\n    $self->throw(\"Must provide a Bio::Align::AlignI compliant object to \".\n      \"Bio::Align::PairwiseStatistics\");\n       return 0;\n  } elsif ( $aln->num_sequences != 2 ) { \n    $self->throw(\"Only pairwise calculations supported. Found \".\n      $aln->num_sequences.\" sequences in alignment\\n\");\n   }\n   my $L = $aln->length - $self->number_of_gaps($aln);\n   return $L;\n}\n\n=head2 number_of_differences\n\n Title   : number_of_differences\n Usage   : my $nd = $stat->number_of_distances($aln);\n Function: Returns the number of differences between two sequences\n Returns : integer\n Args    : L<Bio::Align::AlignI>\n\n\n\nsub number_of_differences{\n   my ($self,$aln) = @_;\n    if( ! defined $aln || ! $aln->isa('Bio::Align::AlignI') ) {\n    $self->throw(\"Must provide a Bio::Align::AlignI compliant object to \".\n      \"Bio::Align::PairwiseStatistics\");\n  } elsif ( $aln->num_sequences != 2 ) { \n    $self->throw(\"Only pairwise calculations supported. Found \".\n      $aln->num_sequences.\" sequences in alignment\\n\");\n    }\n   my (@seqs);\n  foreach my $seq ( $aln->each_seq ) {\n       push @seqs, [ split(//,$seq->seq())];\n   }\n   my $firstseq = shift @seqs;\n  #my $secondseq = shift @seqs;\n   my $diffcount = 0;\n   for (my $i = 0;$i<$aln->length; $i++ ) {\n    next if ( $firstseq->[$i]  =~ /^$GapChars$/ );\n       foreach my $seq ( @seqs ) {\n      next if ( $seq->[$i]  =~ /^$GapChars$/ );\n\t   if( $firstseq->[$i] ne $seq->[$i] ) {\n\t       $diffcount++;\n\t   }\n       }\n   }\n   return $diffcount;\n}\n\n=head2 number_of_gaps\n\n Title   : number_of_gaps\n Usage   : my $nd = $stat->number_of_gaps($aln);\n Function: Returns the number of gapped positions among sequences in alignment\n Returns : integer\n Args    : L<Bio::Align::AlignI>","parameters":[{"label":"$self"},{"label":"$aln"}],"label":"number_of_gaps($self,$aln)"},"name":"number_of_gaps","containerName":"main::","children":[{"definition":"my","localvar":"my","containerName":"number_of_gaps","kind":13,"name":"$self","line":164},{"line":164,"name":"$aln","kind":13,"containerName":"number_of_gaps"},{"line":165,"name":"$aln","containerName":"number_of_gaps","kind":13},{"containerName":"number_of_gaps","kind":13,"name":"$aln","line":165},{"containerName":"number_of_gaps","kind":12,"name":"isa","line":165},{"kind":13,"containerName":"number_of_gaps","name":"$self","line":166},{"line":166,"kind":12,"containerName":"number_of_gaps","name":"throw"},{"line":168,"containerName":"number_of_gaps","kind":13,"name":"$aln"},{"line":168,"containerName":"number_of_gaps","kind":12,"name":"num_sequences"},{"line":169,"kind":13,"containerName":"number_of_gaps","name":"$self"},{"line":169,"name":"throw","kind":12,"containerName":"number_of_gaps"},{"kind":13,"containerName":"number_of_gaps","name":"$aln","line":170},{"containerName":"number_of_gaps","kind":12,"name":"num_sequences","line":170},{"line":172,"name":"$gapline","localvar":"my","kind":13,"containerName":"number_of_gaps","definition":"my"},{"line":172,"kind":13,"containerName":"number_of_gaps","name":"$aln"},{"name":"gap_line","containerName":"number_of_gaps","kind":12,"line":172},{"line":174,"name":"$gapline","kind":13,"containerName":"number_of_gaps"}],"detail":"($self,$aln)","definition":"sub"},{"detail":"($self,@args)","definition":"sub","name":"score_nuc","containerName":"main::","children":[{"line":204,"name":"$self","kind":13,"localvar":"my","containerName":"score_nuc","definition":"my"},{"line":204,"name":"@args","kind":13,"containerName":"score_nuc"},{"name":"$aln","localvar":"my","kind":13,"containerName":"score_nuc","line":205,"definition":"my"},{"line":205,"name":"$match","kind":13,"containerName":"score_nuc"},{"name":"$mismatch","kind":13,"containerName":"score_nuc","line":205},{"line":205,"name":"$gap_open","kind":13,"containerName":"score_nuc"},{"name":"$gap_ext","containerName":"score_nuc","kind":13,"line":205},{"containerName":"score_nuc","kind":13,"name":"$self","line":205},{"line":205,"name":"_rearrange","kind":12,"containerName":"score_nuc"},{"line":207,"name":"@args","kind":13,"containerName":"score_nuc"},{"line":208,"kind":13,"containerName":"score_nuc","name":"$aln"},{"containerName":"score_nuc","kind":13,"name":"$aln","line":208},{"line":208,"name":"isa","kind":12,"containerName":"score_nuc"},{"name":"$self","containerName":"score_nuc","kind":13,"line":209},{"line":209,"kind":12,"containerName":"score_nuc","name":"throw"},{"line":211,"name":"$aln","containerName":"score_nuc","kind":13},{"line":211,"name":"num_sequences","kind":12,"containerName":"score_nuc"},{"name":"$self","kind":13,"containerName":"score_nuc","line":212},{"containerName":"score_nuc","kind":12,"name":"throw","line":212},{"line":213,"containerName":"score_nuc","kind":13,"name":"$aln"},{"line":213,"name":"num_sequences","containerName":"score_nuc","kind":12},{"line":215,"name":"$seq1","localvar":"my","containerName":"score_nuc","kind":13,"definition":"my"},{"name":"$aln","containerName":"score_nuc","kind":13,"line":215},{"kind":12,"containerName":"score_nuc","name":"get_seq_by_pos","line":215},{"localvar":"my","containerName":"score_nuc","kind":13,"name":"$seq2","line":216,"definition":"my"},{"name":"$aln","containerName":"score_nuc","kind":13,"line":216},{"kind":12,"containerName":"score_nuc","name":"get_seq_by_pos","line":216},{"containerName":"score_nuc","kind":13,"name":"$seq1","line":217},{"line":217,"name":"alphabet","kind":12,"containerName":"score_nuc"},{"kind":13,"containerName":"score_nuc","name":"$seq1","line":217},{"line":217,"containerName":"score_nuc","kind":12,"name":"alphabet"},{"line":218,"kind":13,"containerName":"score_nuc","name":"$seq2"},{"name":"alphabet","kind":12,"containerName":"score_nuc","line":218},{"name":"$seq2","containerName":"score_nuc","kind":13,"line":218},{"name":"alphabet","containerName":"score_nuc","kind":12,"line":218},{"line":219,"name":"$self","kind":13,"containerName":"score_nuc"},{"containerName":"score_nuc","kind":12,"name":"throw","line":219},{"line":221,"containerName":"score_nuc","kind":13,"name":"$match"},{"name":"$mismatch","kind":13,"containerName":"score_nuc","line":222},{"line":223,"name":"$gap_open","kind":13,"containerName":"score_nuc"},{"line":224,"name":"$gap_ext","containerName":"score_nuc","kind":13},{"line":225,"name":"$score","kind":13,"localvar":"my","containerName":"score_nuc","definition":"my"},{"name":"$prevres1","localvar":"my","kind":13,"containerName":"score_nuc","line":226,"definition":"my"},{"line":227,"containerName":"score_nuc","localvar":"my","kind":13,"name":"$prevres2","definition":"my"},{"line":228,"name":"$pos","localvar":"my","kind":13,"containerName":"score_nuc","definition":"my"},{"name":"$pos","kind":13,"containerName":"score_nuc","line":228},{"kind":13,"containerName":"score_nuc","name":"$aln","line":228},{"line":228,"kind":12,"containerName":"score_nuc","name":"length"},{"line":228,"kind":13,"containerName":"score_nuc","name":"$pos"},{"containerName":"score_nuc","localvar":"my","kind":13,"name":"$res1","line":229,"definition":"my"},{"line":229,"name":"$seq1","kind":13,"containerName":"score_nuc"},{"containerName":"score_nuc","kind":12,"name":"subseq","line":229},{"line":229,"containerName":"score_nuc","kind":13,"name":"$pos"},{"name":"$pos","containerName":"score_nuc","kind":13,"line":229},{"line":230,"name":"$res2","kind":13,"localvar":"my","containerName":"score_nuc","definition":"my"},{"line":230,"name":"$seq2","containerName":"score_nuc","kind":13},{"kind":12,"containerName":"score_nuc","name":"subseq","line":230},{"line":230,"kind":13,"containerName":"score_nuc","name":"$pos"},{"containerName":"score_nuc","kind":13,"name":"$pos","line":230},{"kind":13,"containerName":"score_nuc","name":"$res1","line":231},{"line":231,"name":"$res2","kind":13,"containerName":"score_nuc"},{"kind":13,"containerName":"score_nuc","name":"$res1","line":232},{"line":232,"containerName":"score_nuc","kind":13,"name":"$res2"},{"containerName":"score_nuc","kind":13,"name":"$score","line":233},{"name":"$match","kind":13,"containerName":"score_nuc","line":233},{"line":235,"name":"$score","kind":13,"containerName":"score_nuc"},{"line":235,"kind":13,"containerName":"score_nuc","name":"$mismatch"},{"definition":"my","containerName":"score_nuc","localvar":"my","kind":13,"name":"$open","line":238},{"line":239,"containerName":"score_nuc","kind":13,"name":"$res1"},{"kind":13,"containerName":"score_nuc","name":"$res2","line":239},{"definition":"my","line":240,"containerName":"score_nuc","localvar":"my","kind":13,"name":"$prevres"},{"line":240,"name":"$prevres1","kind":13,"containerName":"score_nuc"},{"line":241,"containerName":"score_nuc","kind":13,"name":"$prevres"},{"name":"$prevres2","containerName":"score_nuc","kind":13,"line":241},{"name":"$res2","containerName":"score_nuc","kind":13,"line":241},{"line":242,"name":"$open","containerName":"score_nuc","kind":13},{"containerName":"score_nuc","kind":13,"name":"$prevres","line":242},{"line":244,"name":"$open","containerName":"score_nuc","kind":13},{"line":244,"name":"$prevres1","kind":13,"containerName":"score_nuc"},{"name":"$prevres2","containerName":"score_nuc","kind":13,"line":244},{"line":246,"containerName":"score_nuc","kind":13,"name":"$open"},{"containerName":"score_nuc","kind":13,"name":"$score","line":247},{"name":"$gap_open","kind":13,"containerName":"score_nuc","line":247},{"name":"$score","containerName":"score_nuc","kind":13,"line":249},{"kind":13,"containerName":"score_nuc","name":"$gap_ext","line":249},{"name":"$prevres1","kind":13,"containerName":"score_nuc","line":252},{"line":252,"name":"$res1","containerName":"score_nuc","kind":13},{"kind":13,"containerName":"score_nuc","name":"$prevres2","line":253},{"kind":13,"containerName":"score_nuc","name":"$res2","line":253},{"containerName":"score_nuc","kind":13,"name":"$score","line":255}],"signature":{"documentation":"1;\n# $Id: PairwiseStatistics.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::PairwiseStatistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::PairwiseStatistics - Base statistic object for Pairwise Alignments\n\n=head1 SYNOPSIS\n\n  use strict;\n  my $stats = Bio::Align::PairwiseStatistics->new();\n\n  # get alignment object of two sequences somehow\n  my $pwaln;\n  print $stats->number_of_comparable_bases($pwaln);\n  my $score = $stats->score_nuc($pwaln);\n\n\n=head1 DESCRIPTION\n\nCalculate pairwise statistics.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::PairwiseStatistics;\nuse vars qw($GapChars);\nuse strict;\n\n\nBEGIN { $GapChars = '(\\.|\\-)'; }\n\nuse base qw(Bio::Root::Root Bio::Align::StatisticsI);\n\n=head2 number_of_comparable_bases\n\n Title   : number_of_comparable_bases\n Usage   : my $bases = $stat->number_of_comparable_bases($aln);\n Function: Returns the count of the number of bases that can be\n           compared (L) in this alignment ( length - gaps)\n Returns : integer\n Args    : L<Bio::Align::AlignI>\n\n\n\nsub number_of_comparable_bases{\n   my ($self,$aln) = @_;\n  if ( ! defined $aln || ! $aln->isa('Bio::Align::AlignI') ) {\n    $self->throw(\"Must provide a Bio::Align::AlignI compliant object to \".\n      \"Bio::Align::PairwiseStatistics\");\n       return 0;\n  } elsif ( $aln->num_sequences != 2 ) { \n    $self->throw(\"Only pairwise calculations supported. Found \".\n      $aln->num_sequences.\" sequences in alignment\\n\");\n   }\n   my $L = $aln->length - $self->number_of_gaps($aln);\n   return $L;\n}\n\n=head2 number_of_differences\n\n Title   : number_of_differences\n Usage   : my $nd = $stat->number_of_distances($aln);\n Function: Returns the number of differences between two sequences\n Returns : integer\n Args    : L<Bio::Align::AlignI>\n\n\n\nsub number_of_differences{\n   my ($self,$aln) = @_;\n    if( ! defined $aln || ! $aln->isa('Bio::Align::AlignI') ) {\n    $self->throw(\"Must provide a Bio::Align::AlignI compliant object to \".\n      \"Bio::Align::PairwiseStatistics\");\n  } elsif ( $aln->num_sequences != 2 ) { \n    $self->throw(\"Only pairwise calculations supported. Found \".\n      $aln->num_sequences.\" sequences in alignment\\n\");\n    }\n   my (@seqs);\n  foreach my $seq ( $aln->each_seq ) {\n       push @seqs, [ split(//,$seq->seq())];\n   }\n   my $firstseq = shift @seqs;\n  #my $secondseq = shift @seqs;\n   my $diffcount = 0;\n   for (my $i = 0;$i<$aln->length; $i++ ) {\n    next if ( $firstseq->[$i]  =~ /^$GapChars$/ );\n       foreach my $seq ( @seqs ) {\n      next if ( $seq->[$i]  =~ /^$GapChars$/ );\n\t   if( $firstseq->[$i] ne $seq->[$i] ) {\n\t       $diffcount++;\n\t   }\n       }\n   }\n   return $diffcount;\n}\n\n=head2 number_of_gaps\n\n Title   : number_of_gaps\n Usage   : my $nd = $stat->number_of_gaps($aln);\n Function: Returns the number of gapped positions among sequences in alignment\n Returns : integer\n Args    : L<Bio::Align::AlignI>\n\n\n\nsub number_of_gaps{\n   my ($self,$aln) = @_;\n  if ( ! defined $aln || ! $aln->isa('Bio::Align::AlignI') ) {\n    $self->throw(\"Must provide a Bio::Align::AlignI compliant object to \".\n      \"Bio::Align::PairwiseStatistics\");\n  } elsif ( $aln->num_sequences != 2 ) { \n    $self->throw(\"Only pairwise calculations supported. Found \".\n      $aln->num_sequences.\" sequences in alignment\\n\");\n    }\n   my $gapline = $aln->gap_line;\n   # this will count the number of '-' characters\n   return $gapline =~ tr/-/-/;\n}\n\n\n=head2 score_nuc\n\n Title   : score_nuc\n Usage   : my $score = $stat->score_nuc($aln);\n             or\n           my $score = $stat->score_nuc(\n             -aln =>$aln,\n             -match    => 1,\n             -mismatch => -1,\n             -gap_open => -1,\n             -gap_ext  => -1\n           );\n Function: Calculate the score of an alignment of 2 nucleic acid sequences. The\n           scoring parameters can be specified. Otherwise the blastn default\n           parameters are used: match = 2, mismatch = -3, gap opening = -5, gap\n           extension = -2\n Returns : alignment score (number)\n Args    : L<Bio::Align::AlignI>\n           match score [optional]\n           mismatch score [optional]\n           gap opening score [optional]\n           gap extension score [optional]","parameters":[{"label":"$self"},{"label":"@args"}],"label":"score_nuc($self,@args)"},"kind":12,"range":{"start":{"character":0,"line":203},"end":{"character":9999,"line":256}},"line":203}],"version":5}