{"vars":[{"line":99,"kind":2,"containerName":"","name":"base"},{"children":[{"name":"$self","kind":13,"localvar":"my","containerName":"add_seq","line":121,"definition":"my"},{"kind":13,"containerName":"add_seq","name":"$self","line":122},{"kind":12,"containerName":"add_seq","name":"throw_not_implemented","line":122}],"name":"add_seq","containerName":"main::","definition":"sub","detail":"($self)","line":120,"kind":12,"range":{"end":{"line":123,"character":9999},"start":{"line":120,"character":0}},"signature":{"label":"add_seq($self)","documentation":"1;\n# $Id: AlignI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::AlignI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::AlignI - An interface for describing sequence alignments.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Align::AlignI somehow - typically using Bio::AlignIO system\n  # some descriptors\n  print $aln->length, \"\\n\";\n  print $aln->num_residues, \"\\n\";\n  print $aln->is_flush, \"\\n\";\n  print $aln->num_sequences, \"\\n\";\n  print $aln->percentage_identity, \"\\n\";\n  print $aln->consensus_string(50), \"\\n\";\n\n  # find the position in the alignment for a sequence location\n  $pos = $aln->column_from_residue_number('1433_LYCES', 14); # = 6;\n\n  # extract sequences and check values for the alignment column $pos\n  foreach $seq ($aln->each_seq) {\n      $res = $seq->subseq($pos, $pos);\n      $count{$res}++;\n  }\n  foreach $res (keys %count) {\n      printf \"Res: %s  Count: %2d\\n\", $res, $count{$res};\n  }\n\n=head1 DESCRIPTION\n\nThis interface describes the basis for alignment objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::AlignI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $myalign->add_seq($newseq);\n Function  : Adds another sequence to the alignment. *Does not* align\n             it - just adds it to the hashes.\n Returns   : None\n Argument  : a Bio::LocatableSeq object\n             order (optional)\n\nSee L<Bio::LocatableSeq> for more information.","parameters":[{"label":"$self"}]}},{"definition":"sub","detail":"($self)","children":[{"definition":"my","line":136,"name":"$self","containerName":"remove_seq","localvar":"my","kind":13},{"line":137,"name":"$self","containerName":"remove_seq","kind":13},{"name":"throw_not_implemented","kind":12,"containerName":"remove_seq","line":137}],"containerName":"main::","name":"remove_seq","signature":{"label":"remove_seq($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: AlignI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::AlignI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::AlignI - An interface for describing sequence alignments.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Align::AlignI somehow - typically using Bio::AlignIO system\n  # some descriptors\n  print $aln->length, \"\\n\";\n  print $aln->num_residues, \"\\n\";\n  print $aln->is_flush, \"\\n\";\n  print $aln->num_sequences, \"\\n\";\n  print $aln->percentage_identity, \"\\n\";\n  print $aln->consensus_string(50), \"\\n\";\n\n  # find the position in the alignment for a sequence location\n  $pos = $aln->column_from_residue_number('1433_LYCES', 14); # = 6;\n\n  # extract sequences and check values for the alignment column $pos\n  foreach $seq ($aln->each_seq) {\n      $res = $seq->subseq($pos, $pos);\n      $count{$res}++;\n  }\n  foreach $res (keys %count) {\n      printf \"Res: %s  Count: %2d\\n\", $res, $count{$res};\n  }\n\n=head1 DESCRIPTION\n\nThis interface describes the basis for alignment objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::AlignI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $myalign->add_seq($newseq);\n Function  : Adds another sequence to the alignment. *Does not* align\n             it - just adds it to the hashes.\n Returns   : None\n Argument  : a Bio::LocatableSeq object\n             order (optional)\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $aln->remove_seq($seq);\n Function  : Removes a single sequence from an alignment\n Returns   :\n Argument  : a Bio::LocatableSeq object"},"line":135,"kind":12,"range":{"start":{"line":135,"character":0},"end":{"character":9999,"line":138}}},{"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: AlignI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::AlignI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::AlignI - An interface for describing sequence alignments.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Align::AlignI somehow - typically using Bio::AlignIO system\n  # some descriptors\n  print $aln->length, \"\\n\";\n  print $aln->num_residues, \"\\n\";\n  print $aln->is_flush, \"\\n\";\n  print $aln->num_sequences, \"\\n\";\n  print $aln->percentage_identity, \"\\n\";\n  print $aln->consensus_string(50), \"\\n\";\n\n  # find the position in the alignment for a sequence location\n  $pos = $aln->column_from_residue_number('1433_LYCES', 14); # = 6;\n\n  # extract sequences and check values for the alignment column $pos\n  foreach $seq ($aln->each_seq) {\n      $res = $seq->subseq($pos, $pos);\n      $count{$res}++;\n  }\n  foreach $res (keys %count) {\n      printf \"Res: %s  Count: %2d\\n\", $res, $count{$res};\n  }\n\n=head1 DESCRIPTION\n\nThis interface describes the basis for alignment objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::AlignI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $myalign->add_seq($newseq);\n Function  : Adds another sequence to the alignment. *Does not* align\n             it - just adds it to the hashes.\n Returns   : None\n Argument  : a Bio::LocatableSeq object\n             order (optional)\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $aln->remove_seq($seq);\n Function  : Removes a single sequence from an alignment\n Returns   :\n Argument  : a Bio::LocatableSeq object\n\n\nsub remove_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 purge\n\n Title   : purge\n Usage   : $aln->purge(0.7);\n Function:\n\n           Removes sequences above whatever %id.\n\n           This function will grind on large alignments. Beware!\n           (perhaps not ideally implemented)\n\n Example :\n Returns : An array of the removed sequences\n Argument:","label":"purge($self)"},"kind":12,"range":{"start":{"character":0,"line":158},"end":{"line":161,"character":9999}},"line":158,"detail":"($self)","definition":"sub","name":"purge","containerName":"main::","children":[{"line":159,"localvar":"my","containerName":"purge","kind":13,"name":"$self","definition":"my"},{"name":"$self","kind":13,"containerName":"purge","line":160},{"kind":12,"containerName":"purge","name":"throw_not_implemented","line":160}]},{"signature":{"label":"sort_alphabetically($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: AlignI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::AlignI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::AlignI - An interface for describing sequence alignments.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Align::AlignI somehow - typically using Bio::AlignIO system\n  # some descriptors\n  print $aln->length, \"\\n\";\n  print $aln->num_residues, \"\\n\";\n  print $aln->is_flush, \"\\n\";\n  print $aln->num_sequences, \"\\n\";\n  print $aln->percentage_identity, \"\\n\";\n  print $aln->consensus_string(50), \"\\n\";\n\n  # find the position in the alignment for a sequence location\n  $pos = $aln->column_from_residue_number('1433_LYCES', 14); # = 6;\n\n  # extract sequences and check values for the alignment column $pos\n  foreach $seq ($aln->each_seq) {\n      $res = $seq->subseq($pos, $pos);\n      $count{$res}++;\n  }\n  foreach $res (keys %count) {\n      printf \"Res: %s  Count: %2d\\n\", $res, $count{$res};\n  }\n\n=head1 DESCRIPTION\n\nThis interface describes the basis for alignment objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::AlignI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $myalign->add_seq($newseq);\n Function  : Adds another sequence to the alignment. *Does not* align\n             it - just adds it to the hashes.\n Returns   : None\n Argument  : a Bio::LocatableSeq object\n             order (optional)\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $aln->remove_seq($seq);\n Function  : Removes a single sequence from an alignment\n Returns   :\n Argument  : a Bio::LocatableSeq object\n\n\nsub remove_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 purge\n\n Title   : purge\n Usage   : $aln->purge(0.7);\n Function:\n\n           Removes sequences above whatever %id.\n\n           This function will grind on large alignments. Beware!\n           (perhaps not ideally implemented)\n\n Example :\n Returns : An array of the removed sequences\n Argument:\n\n\n\nsub purge {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 sort_alphabetically\n\n Title     : sort_alphabetically\n Usage     : $ali->sort_alphabetically\n Function  : \n\n             Changes the order of the alignment to alphabetical on name \n             followed by numerical by number.\n\n Returns   : an array\n Argument  : "},"line":177,"kind":12,"range":{"end":{"line":180,"character":9999},"start":{"line":177,"character":0}},"definition":"sub","detail":"($self)","children":[{"kind":13,"localvar":"my","containerName":"sort_alphabetically","name":"$self","line":178,"definition":"my"},{"containerName":"sort_alphabetically","kind":13,"name":"$self","line":179},{"line":179,"kind":12,"containerName":"sort_alphabetically","name":"throw_not_implemented"}],"name":"sort_alphabetically","containerName":"main::"},{"detail":"($self)","definition":"sub","containerName":"main::","name":"each_seq","children":[{"line":197,"name":"$self","kind":13,"localvar":"my","containerName":"each_seq","definition":"my"},{"name":"$self","kind":13,"containerName":"each_seq","line":198},{"line":198,"name":"throw_not_implemented","kind":12,"containerName":"each_seq"}],"signature":{"documentation":"1;\n# $Id: AlignI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::AlignI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::AlignI - An interface for describing sequence alignments.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Align::AlignI somehow - typically using Bio::AlignIO system\n  # some descriptors\n  print $aln->length, \"\\n\";\n  print $aln->num_residues, \"\\n\";\n  print $aln->is_flush, \"\\n\";\n  print $aln->num_sequences, \"\\n\";\n  print $aln->percentage_identity, \"\\n\";\n  print $aln->consensus_string(50), \"\\n\";\n\n  # find the position in the alignment for a sequence location\n  $pos = $aln->column_from_residue_number('1433_LYCES', 14); # = 6;\n\n  # extract sequences and check values for the alignment column $pos\n  foreach $seq ($aln->each_seq) {\n      $res = $seq->subseq($pos, $pos);\n      $count{$res}++;\n  }\n  foreach $res (keys %count) {\n      printf \"Res: %s  Count: %2d\\n\", $res, $count{$res};\n  }\n\n=head1 DESCRIPTION\n\nThis interface describes the basis for alignment objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::AlignI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $myalign->add_seq($newseq);\n Function  : Adds another sequence to the alignment. *Does not* align\n             it - just adds it to the hashes.\n Returns   : None\n Argument  : a Bio::LocatableSeq object\n             order (optional)\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $aln->remove_seq($seq);\n Function  : Removes a single sequence from an alignment\n Returns   :\n Argument  : a Bio::LocatableSeq object\n\n\nsub remove_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 purge\n\n Title   : purge\n Usage   : $aln->purge(0.7);\n Function:\n\n           Removes sequences above whatever %id.\n\n           This function will grind on large alignments. Beware!\n           (perhaps not ideally implemented)\n\n Example :\n Returns : An array of the removed sequences\n Argument:\n\n\n\nsub purge {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 sort_alphabetically\n\n Title     : sort_alphabetically\n Usage     : $ali->sort_alphabetically\n Function  : \n\n             Changes the order of the alignment to alphabetical on name \n             followed by numerical by number.\n\n Returns   : an array\n Argument  : \n\n\nsub sort_alphabetically {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Sequence selection methods\n\nMethods returning one or more sequences objects.\n\n=head2 each_seq\n\n Title     : each_seq\n Usage     : foreach $seq ( $align->each_seq() ) \n Function  : Gets an array of Seq objects from the alignment\n Returns   : an array\n Argument  : ","parameters":[{"label":"$self"}],"label":"each_seq($self)"},"kind":12,"range":{"end":{"character":9999,"line":199},"start":{"character":0,"line":196}},"line":196},{"range":{"end":{"character":9999,"line":219},"start":{"line":216,"character":0}},"kind":12,"line":216,"signature":{"label":"each_alphabetically($self)","documentation":"1;\n# $Id: AlignI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::AlignI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::AlignI - An interface for describing sequence alignments.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Align::AlignI somehow - typically using Bio::AlignIO system\n  # some descriptors\n  print $aln->length, \"\\n\";\n  print $aln->num_residues, \"\\n\";\n  print $aln->is_flush, \"\\n\";\n  print $aln->num_sequences, \"\\n\";\n  print $aln->percentage_identity, \"\\n\";\n  print $aln->consensus_string(50), \"\\n\";\n\n  # find the position in the alignment for a sequence location\n  $pos = $aln->column_from_residue_number('1433_LYCES', 14); # = 6;\n\n  # extract sequences and check values for the alignment column $pos\n  foreach $seq ($aln->each_seq) {\n      $res = $seq->subseq($pos, $pos);\n      $count{$res}++;\n  }\n  foreach $res (keys %count) {\n      printf \"Res: %s  Count: %2d\\n\", $res, $count{$res};\n  }\n\n=head1 DESCRIPTION\n\nThis interface describes the basis for alignment objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::AlignI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $myalign->add_seq($newseq);\n Function  : Adds another sequence to the alignment. *Does not* align\n             it - just adds it to the hashes.\n Returns   : None\n Argument  : a Bio::LocatableSeq object\n             order (optional)\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $aln->remove_seq($seq);\n Function  : Removes a single sequence from an alignment\n Returns   :\n Argument  : a Bio::LocatableSeq object\n\n\nsub remove_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 purge\n\n Title   : purge\n Usage   : $aln->purge(0.7);\n Function:\n\n           Removes sequences above whatever %id.\n\n           This function will grind on large alignments. Beware!\n           (perhaps not ideally implemented)\n\n Example :\n Returns : An array of the removed sequences\n Argument:\n\n\n\nsub purge {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 sort_alphabetically\n\n Title     : sort_alphabetically\n Usage     : $ali->sort_alphabetically\n Function  : \n\n             Changes the order of the alignment to alphabetical on name \n             followed by numerical by number.\n\n Returns   : an array\n Argument  : \n\n\nsub sort_alphabetically {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Sequence selection methods\n\nMethods returning one or more sequences objects.\n\n=head2 each_seq\n\n Title     : each_seq\n Usage     : foreach $seq ( $align->each_seq() ) \n Function  : Gets an array of Seq objects from the alignment\n Returns   : an array\n Argument  : \n\n\nsub each_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_alphabetically\n\n Title     : each_alphabetically\n Usage     : foreach $seq ( $ali->each_alphabetically() )\n Function  :\n\n             Returns an array of sequence object sorted alphabetically \n             by name and then by start point.\n             Does not change the order of the alignment\n\n Returns   : \n Argument  : ","parameters":[{"label":"$self"}]},"containerName":"main::","name":"each_alphabetically","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"each_alphabetically","line":217},{"line":218,"name":"$self","containerName":"each_alphabetically","kind":13},{"name":"throw_not_implemented","kind":12,"containerName":"each_alphabetically","line":218}],"detail":"($self)","definition":"sub"},{"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: AlignI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::AlignI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::AlignI - An interface for describing sequence alignments.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Align::AlignI somehow - typically using Bio::AlignIO system\n  # some descriptors\n  print $aln->length, \"\\n\";\n  print $aln->num_residues, \"\\n\";\n  print $aln->is_flush, \"\\n\";\n  print $aln->num_sequences, \"\\n\";\n  print $aln->percentage_identity, \"\\n\";\n  print $aln->consensus_string(50), \"\\n\";\n\n  # find the position in the alignment for a sequence location\n  $pos = $aln->column_from_residue_number('1433_LYCES', 14); # = 6;\n\n  # extract sequences and check values for the alignment column $pos\n  foreach $seq ($aln->each_seq) {\n      $res = $seq->subseq($pos, $pos);\n      $count{$res}++;\n  }\n  foreach $res (keys %count) {\n      printf \"Res: %s  Count: %2d\\n\", $res, $count{$res};\n  }\n\n=head1 DESCRIPTION\n\nThis interface describes the basis for alignment objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::AlignI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $myalign->add_seq($newseq);\n Function  : Adds another sequence to the alignment. *Does not* align\n             it - just adds it to the hashes.\n Returns   : None\n Argument  : a Bio::LocatableSeq object\n             order (optional)\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $aln->remove_seq($seq);\n Function  : Removes a single sequence from an alignment\n Returns   :\n Argument  : a Bio::LocatableSeq object\n\n\nsub remove_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 purge\n\n Title   : purge\n Usage   : $aln->purge(0.7);\n Function:\n\n           Removes sequences above whatever %id.\n\n           This function will grind on large alignments. Beware!\n           (perhaps not ideally implemented)\n\n Example :\n Returns : An array of the removed sequences\n Argument:\n\n\n\nsub purge {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 sort_alphabetically\n\n Title     : sort_alphabetically\n Usage     : $ali->sort_alphabetically\n Function  : \n\n             Changes the order of the alignment to alphabetical on name \n             followed by numerical by number.\n\n Returns   : an array\n Argument  : \n\n\nsub sort_alphabetically {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Sequence selection methods\n\nMethods returning one or more sequences objects.\n\n=head2 each_seq\n\n Title     : each_seq\n Usage     : foreach $seq ( $align->each_seq() ) \n Function  : Gets an array of Seq objects from the alignment\n Returns   : an array\n Argument  : \n\n\nsub each_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_alphabetically\n\n Title     : each_alphabetically\n Usage     : foreach $seq ( $ali->each_alphabetically() )\n Function  :\n\n             Returns an array of sequence object sorted alphabetically \n             by name and then by start point.\n             Does not change the order of the alignment\n\n Returns   : \n Argument  : \n\n\nsub each_alphabetically {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_seq_with_id\n\n Title     : each_seq_with_id\n Usage     : foreach $seq ( $align->each_seq_with_id() ) \n Function  : \n\n             Gets an array of Seq objects from the\n             alignment, the contents being those sequences\n             with the given name (there may be more than one)\n\n Returns   : an array\n Argument  : a seq name","label":"each_seq_with_id($self)"},"range":{"start":{"line":236,"character":0},"end":{"character":9999,"line":239}},"kind":12,"line":236,"detail":"($self)","definition":"sub","name":"each_seq_with_id","containerName":"main::","children":[{"line":237,"kind":13,"localvar":"my","containerName":"each_seq_with_id","name":"$self","definition":"my"},{"name":"$self","containerName":"each_seq_with_id","kind":13,"line":238},{"line":238,"name":"throw_not_implemented","kind":12,"containerName":"each_seq_with_id"}]},{"signature":{"label":"get_seq_by_pos($self)","documentation":"1;\n# $Id: AlignI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::AlignI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::AlignI - An interface for describing sequence alignments.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Align::AlignI somehow - typically using Bio::AlignIO system\n  # some descriptors\n  print $aln->length, \"\\n\";\n  print $aln->num_residues, \"\\n\";\n  print $aln->is_flush, \"\\n\";\n  print $aln->num_sequences, \"\\n\";\n  print $aln->percentage_identity, \"\\n\";\n  print $aln->consensus_string(50), \"\\n\";\n\n  # find the position in the alignment for a sequence location\n  $pos = $aln->column_from_residue_number('1433_LYCES', 14); # = 6;\n\n  # extract sequences and check values for the alignment column $pos\n  foreach $seq ($aln->each_seq) {\n      $res = $seq->subseq($pos, $pos);\n      $count{$res}++;\n  }\n  foreach $res (keys %count) {\n      printf \"Res: %s  Count: %2d\\n\", $res, $count{$res};\n  }\n\n=head1 DESCRIPTION\n\nThis interface describes the basis for alignment objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::AlignI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $myalign->add_seq($newseq);\n Function  : Adds another sequence to the alignment. *Does not* align\n             it - just adds it to the hashes.\n Returns   : None\n Argument  : a Bio::LocatableSeq object\n             order (optional)\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $aln->remove_seq($seq);\n Function  : Removes a single sequence from an alignment\n Returns   :\n Argument  : a Bio::LocatableSeq object\n\n\nsub remove_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 purge\n\n Title   : purge\n Usage   : $aln->purge(0.7);\n Function:\n\n           Removes sequences above whatever %id.\n\n           This function will grind on large alignments. Beware!\n           (perhaps not ideally implemented)\n\n Example :\n Returns : An array of the removed sequences\n Argument:\n\n\n\nsub purge {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 sort_alphabetically\n\n Title     : sort_alphabetically\n Usage     : $ali->sort_alphabetically\n Function  : \n\n             Changes the order of the alignment to alphabetical on name \n             followed by numerical by number.\n\n Returns   : an array\n Argument  : \n\n\nsub sort_alphabetically {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Sequence selection methods\n\nMethods returning one or more sequences objects.\n\n=head2 each_seq\n\n Title     : each_seq\n Usage     : foreach $seq ( $align->each_seq() ) \n Function  : Gets an array of Seq objects from the alignment\n Returns   : an array\n Argument  : \n\n\nsub each_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_alphabetically\n\n Title     : each_alphabetically\n Usage     : foreach $seq ( $ali->each_alphabetically() )\n Function  :\n\n             Returns an array of sequence object sorted alphabetically \n             by name and then by start point.\n             Does not change the order of the alignment\n\n Returns   : \n Argument  : \n\n\nsub each_alphabetically {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_seq_with_id\n\n Title     : each_seq_with_id\n Usage     : foreach $seq ( $align->each_seq_with_id() ) \n Function  : \n\n             Gets an array of Seq objects from the\n             alignment, the contents being those sequences\n             with the given name (there may be more than one)\n\n Returns   : an array\n Argument  : a seq name\n\n\nsub each_seq_with_id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 get_seq_by_pos\n\n Title     : get_seq_by_pos\n Usage     : $seq = $aln->get_seq_by_pos(3) # third sequence from the alignment\n Function  : \n\n             Gets a sequence based on its position in the alignment.\n             Numbering starts from 1.  Sequence positions larger than\n             num_sequences() will throw an error.\n\n Returns   : a Bio::LocatableSeq object\n Argument  : positive integer for the sequence position","parameters":[{"label":"$self"}]},"range":{"end":{"character":9999,"line":259},"start":{"line":256,"character":0}},"kind":12,"line":256,"detail":"($self)","definition":"sub","name":"get_seq_by_pos","containerName":"main::","children":[{"definition":"my","line":257,"name":"$self","kind":13,"localvar":"my","containerName":"get_seq_by_pos"},{"line":258,"containerName":"get_seq_by_pos","kind":13,"name":"$self"},{"line":258,"name":"throw_not_implemented","containerName":"get_seq_by_pos","kind":12}]},{"containerName":"main::","name":"select","children":[{"name":"$self","localvar":"my","containerName":"select","kind":13,"line":283,"definition":"my"},{"line":284,"kind":13,"containerName":"select","name":"$self"},{"line":284,"name":"throw_not_implemented","kind":12,"containerName":"select"}],"detail":"($self)","definition":"sub","range":{"start":{"character":0,"line":282},"end":{"line":285,"character":9999}},"kind":12,"line":282,"signature":{"label":"select($self)","documentation":"1;\n# $Id: AlignI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::AlignI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::AlignI - An interface for describing sequence alignments.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Align::AlignI somehow - typically using Bio::AlignIO system\n  # some descriptors\n  print $aln->length, \"\\n\";\n  print $aln->num_residues, \"\\n\";\n  print $aln->is_flush, \"\\n\";\n  print $aln->num_sequences, \"\\n\";\n  print $aln->percentage_identity, \"\\n\";\n  print $aln->consensus_string(50), \"\\n\";\n\n  # find the position in the alignment for a sequence location\n  $pos = $aln->column_from_residue_number('1433_LYCES', 14); # = 6;\n\n  # extract sequences and check values for the alignment column $pos\n  foreach $seq ($aln->each_seq) {\n      $res = $seq->subseq($pos, $pos);\n      $count{$res}++;\n  }\n  foreach $res (keys %count) {\n      printf \"Res: %s  Count: %2d\\n\", $res, $count{$res};\n  }\n\n=head1 DESCRIPTION\n\nThis interface describes the basis for alignment objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::AlignI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $myalign->add_seq($newseq);\n Function  : Adds another sequence to the alignment. *Does not* align\n             it - just adds it to the hashes.\n Returns   : None\n Argument  : a Bio::LocatableSeq object\n             order (optional)\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $aln->remove_seq($seq);\n Function  : Removes a single sequence from an alignment\n Returns   :\n Argument  : a Bio::LocatableSeq object\n\n\nsub remove_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 purge\n\n Title   : purge\n Usage   : $aln->purge(0.7);\n Function:\n\n           Removes sequences above whatever %id.\n\n           This function will grind on large alignments. Beware!\n           (perhaps not ideally implemented)\n\n Example :\n Returns : An array of the removed sequences\n Argument:\n\n\n\nsub purge {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 sort_alphabetically\n\n Title     : sort_alphabetically\n Usage     : $ali->sort_alphabetically\n Function  : \n\n             Changes the order of the alignment to alphabetical on name \n             followed by numerical by number.\n\n Returns   : an array\n Argument  : \n\n\nsub sort_alphabetically {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Sequence selection methods\n\nMethods returning one or more sequences objects.\n\n=head2 each_seq\n\n Title     : each_seq\n Usage     : foreach $seq ( $align->each_seq() ) \n Function  : Gets an array of Seq objects from the alignment\n Returns   : an array\n Argument  : \n\n\nsub each_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_alphabetically\n\n Title     : each_alphabetically\n Usage     : foreach $seq ( $ali->each_alphabetically() )\n Function  :\n\n             Returns an array of sequence object sorted alphabetically \n             by name and then by start point.\n             Does not change the order of the alignment\n\n Returns   : \n Argument  : \n\n\nsub each_alphabetically {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_seq_with_id\n\n Title     : each_seq_with_id\n Usage     : foreach $seq ( $align->each_seq_with_id() ) \n Function  : \n\n             Gets an array of Seq objects from the\n             alignment, the contents being those sequences\n             with the given name (there may be more than one)\n\n Returns   : an array\n Argument  : a seq name\n\n\nsub each_seq_with_id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 get_seq_by_pos\n\n Title     : get_seq_by_pos\n Usage     : $seq = $aln->get_seq_by_pos(3) # third sequence from the alignment\n Function  : \n\n             Gets a sequence based on its position in the alignment.\n             Numbering starts from 1.  Sequence positions larger than\n             num_sequences() will throw an error.\n\n Returns   : a Bio::LocatableSeq object\n Argument  : positive integer for the sequence position\n\n\nsub get_seq_by_pos {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Create new alignments\n\nThe result of these methods are horizontal or vertical subsets of the\ncurrent MSE.\n\n=head2 select\n\n Title     : select\n Usage     : $aln2 = $aln->select(1, 3) # three first sequences\n Function  : \n\n             Creates a new alignment from a continuous subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for the first sequence\n             positive integer for the last sequence to include (optional)","parameters":[{"label":"$self"}]}},{"name":"select_noncont","containerName":"main::","children":[{"definition":"my","containerName":"select_noncont","localvar":"my","kind":13,"name":"$self","line":304},{"kind":13,"containerName":"select_noncont","name":"$self","line":305},{"containerName":"select_noncont","kind":12,"name":"throw_not_implemented","line":305}],"detail":"($self)","definition":"sub","kind":12,"range":{"end":{"character":9999,"line":306},"start":{"character":0,"line":303}},"line":303,"signature":{"documentation":"1;\n# $Id: AlignI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::AlignI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::AlignI - An interface for describing sequence alignments.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Align::AlignI somehow - typically using Bio::AlignIO system\n  # some descriptors\n  print $aln->length, \"\\n\";\n  print $aln->num_residues, \"\\n\";\n  print $aln->is_flush, \"\\n\";\n  print $aln->num_sequences, \"\\n\";\n  print $aln->percentage_identity, \"\\n\";\n  print $aln->consensus_string(50), \"\\n\";\n\n  # find the position in the alignment for a sequence location\n  $pos = $aln->column_from_residue_number('1433_LYCES', 14); # = 6;\n\n  # extract sequences and check values for the alignment column $pos\n  foreach $seq ($aln->each_seq) {\n      $res = $seq->subseq($pos, $pos);\n      $count{$res}++;\n  }\n  foreach $res (keys %count) {\n      printf \"Res: %s  Count: %2d\\n\", $res, $count{$res};\n  }\n\n=head1 DESCRIPTION\n\nThis interface describes the basis for alignment objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::AlignI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $myalign->add_seq($newseq);\n Function  : Adds another sequence to the alignment. *Does not* align\n             it - just adds it to the hashes.\n Returns   : None\n Argument  : a Bio::LocatableSeq object\n             order (optional)\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $aln->remove_seq($seq);\n Function  : Removes a single sequence from an alignment\n Returns   :\n Argument  : a Bio::LocatableSeq object\n\n\nsub remove_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 purge\n\n Title   : purge\n Usage   : $aln->purge(0.7);\n Function:\n\n           Removes sequences above whatever %id.\n\n           This function will grind on large alignments. Beware!\n           (perhaps not ideally implemented)\n\n Example :\n Returns : An array of the removed sequences\n Argument:\n\n\n\nsub purge {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 sort_alphabetically\n\n Title     : sort_alphabetically\n Usage     : $ali->sort_alphabetically\n Function  : \n\n             Changes the order of the alignment to alphabetical on name \n             followed by numerical by number.\n\n Returns   : an array\n Argument  : \n\n\nsub sort_alphabetically {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Sequence selection methods\n\nMethods returning one or more sequences objects.\n\n=head2 each_seq\n\n Title     : each_seq\n Usage     : foreach $seq ( $align->each_seq() ) \n Function  : Gets an array of Seq objects from the alignment\n Returns   : an array\n Argument  : \n\n\nsub each_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_alphabetically\n\n Title     : each_alphabetically\n Usage     : foreach $seq ( $ali->each_alphabetically() )\n Function  :\n\n             Returns an array of sequence object sorted alphabetically \n             by name and then by start point.\n             Does not change the order of the alignment\n\n Returns   : \n Argument  : \n\n\nsub each_alphabetically {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_seq_with_id\n\n Title     : each_seq_with_id\n Usage     : foreach $seq ( $align->each_seq_with_id() ) \n Function  : \n\n             Gets an array of Seq objects from the\n             alignment, the contents being those sequences\n             with the given name (there may be more than one)\n\n Returns   : an array\n Argument  : a seq name\n\n\nsub each_seq_with_id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 get_seq_by_pos\n\n Title     : get_seq_by_pos\n Usage     : $seq = $aln->get_seq_by_pos(3) # third sequence from the alignment\n Function  : \n\n             Gets a sequence based on its position in the alignment.\n             Numbering starts from 1.  Sequence positions larger than\n             num_sequences() will throw an error.\n\n Returns   : a Bio::LocatableSeq object\n Argument  : positive integer for the sequence position\n\n\nsub get_seq_by_pos {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Create new alignments\n\nThe result of these methods are horizontal or vertical subsets of the\ncurrent MSE.\n\n=head2 select\n\n Title     : select\n Usage     : $aln2 = $aln->select(1, 3) # three first sequences\n Function  : \n\n             Creates a new alignment from a continuous subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for the first sequence\n             positive integer for the last sequence to include (optional)\n\n\nsub select {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 select_noncont\n\n Title     : select_noncont\n Usage     : $aln2 = $aln->select_noncont(1, 3) # first and 3rd sequences\n Function  : \n\n             Creates a new alignment from a subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Args      : array of integers for the sequences","parameters":[{"label":"$self"}],"label":"select_noncont($self)"}},{"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: AlignI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::AlignI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::AlignI - An interface for describing sequence alignments.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Align::AlignI somehow - typically using Bio::AlignIO system\n  # some descriptors\n  print $aln->length, \"\\n\";\n  print $aln->num_residues, \"\\n\";\n  print $aln->is_flush, \"\\n\";\n  print $aln->num_sequences, \"\\n\";\n  print $aln->percentage_identity, \"\\n\";\n  print $aln->consensus_string(50), \"\\n\";\n\n  # find the position in the alignment for a sequence location\n  $pos = $aln->column_from_residue_number('1433_LYCES', 14); # = 6;\n\n  # extract sequences and check values for the alignment column $pos\n  foreach $seq ($aln->each_seq) {\n      $res = $seq->subseq($pos, $pos);\n      $count{$res}++;\n  }\n  foreach $res (keys %count) {\n      printf \"Res: %s  Count: %2d\\n\", $res, $count{$res};\n  }\n\n=head1 DESCRIPTION\n\nThis interface describes the basis for alignment objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::AlignI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $myalign->add_seq($newseq);\n Function  : Adds another sequence to the alignment. *Does not* align\n             it - just adds it to the hashes.\n Returns   : None\n Argument  : a Bio::LocatableSeq object\n             order (optional)\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $aln->remove_seq($seq);\n Function  : Removes a single sequence from an alignment\n Returns   :\n Argument  : a Bio::LocatableSeq object\n\n\nsub remove_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 purge\n\n Title   : purge\n Usage   : $aln->purge(0.7);\n Function:\n\n           Removes sequences above whatever %id.\n\n           This function will grind on large alignments. Beware!\n           (perhaps not ideally implemented)\n\n Example :\n Returns : An array of the removed sequences\n Argument:\n\n\n\nsub purge {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 sort_alphabetically\n\n Title     : sort_alphabetically\n Usage     : $ali->sort_alphabetically\n Function  : \n\n             Changes the order of the alignment to alphabetical on name \n             followed by numerical by number.\n\n Returns   : an array\n Argument  : \n\n\nsub sort_alphabetically {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Sequence selection methods\n\nMethods returning one or more sequences objects.\n\n=head2 each_seq\n\n Title     : each_seq\n Usage     : foreach $seq ( $align->each_seq() ) \n Function  : Gets an array of Seq objects from the alignment\n Returns   : an array\n Argument  : \n\n\nsub each_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_alphabetically\n\n Title     : each_alphabetically\n Usage     : foreach $seq ( $ali->each_alphabetically() )\n Function  :\n\n             Returns an array of sequence object sorted alphabetically \n             by name and then by start point.\n             Does not change the order of the alignment\n\n Returns   : \n Argument  : \n\n\nsub each_alphabetically {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_seq_with_id\n\n Title     : each_seq_with_id\n Usage     : foreach $seq ( $align->each_seq_with_id() ) \n Function  : \n\n             Gets an array of Seq objects from the\n             alignment, the contents being those sequences\n             with the given name (there may be more than one)\n\n Returns   : an array\n Argument  : a seq name\n\n\nsub each_seq_with_id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 get_seq_by_pos\n\n Title     : get_seq_by_pos\n Usage     : $seq = $aln->get_seq_by_pos(3) # third sequence from the alignment\n Function  : \n\n             Gets a sequence based on its position in the alignment.\n             Numbering starts from 1.  Sequence positions larger than\n             num_sequences() will throw an error.\n\n Returns   : a Bio::LocatableSeq object\n Argument  : positive integer for the sequence position\n\n\nsub get_seq_by_pos {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Create new alignments\n\nThe result of these methods are horizontal or vertical subsets of the\ncurrent MSE.\n\n=head2 select\n\n Title     : select\n Usage     : $aln2 = $aln->select(1, 3) # three first sequences\n Function  : \n\n             Creates a new alignment from a continuous subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for the first sequence\n             positive integer for the last sequence to include (optional)\n\n\nsub select {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 select_noncont\n\n Title     : select_noncont\n Usage     : $aln2 = $aln->select_noncont(1, 3) # first and 3rd sequences\n Function  : \n\n             Creates a new alignment from a subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Args      : array of integers for the sequences\n\n\nsub select_noncont {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 slice\n\n Title     : slice\n Usage     : $aln2 = $aln->slice(20, 30)\n Function  : \n\n             Creates a slice from the alignment inclusive of start and\n             end columns.  Sequences with no residues in the slice are\n             excluded from the new alignment and a warning is printed.\n             Slice beyond the length of the sequence does not do\n             padding.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for start column \n             positive integer for end column ","label":"slice($self)"},"range":{"start":{"character":0,"line":326},"end":{"character":9999,"line":329}},"kind":12,"line":326,"detail":"($self)","definition":"sub","name":"slice","containerName":"main::","children":[{"definition":"my","line":327,"name":"$self","localvar":"my","kind":13,"containerName":"slice"},{"line":328,"containerName":"slice","kind":13,"name":"$self"},{"line":328,"name":"throw_not_implemented","containerName":"slice","kind":12}]},{"signature":{"label":"map_chars($self)","documentation":"1;\n# $Id: AlignI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::AlignI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::AlignI - An interface for describing sequence alignments.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Align::AlignI somehow - typically using Bio::AlignIO system\n  # some descriptors\n  print $aln->length, \"\\n\";\n  print $aln->num_residues, \"\\n\";\n  print $aln->is_flush, \"\\n\";\n  print $aln->num_sequences, \"\\n\";\n  print $aln->percentage_identity, \"\\n\";\n  print $aln->consensus_string(50), \"\\n\";\n\n  # find the position in the alignment for a sequence location\n  $pos = $aln->column_from_residue_number('1433_LYCES', 14); # = 6;\n\n  # extract sequences and check values for the alignment column $pos\n  foreach $seq ($aln->each_seq) {\n      $res = $seq->subseq($pos, $pos);\n      $count{$res}++;\n  }\n  foreach $res (keys %count) {\n      printf \"Res: %s  Count: %2d\\n\", $res, $count{$res};\n  }\n\n=head1 DESCRIPTION\n\nThis interface describes the basis for alignment objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::AlignI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $myalign->add_seq($newseq);\n Function  : Adds another sequence to the alignment. *Does not* align\n             it - just adds it to the hashes.\n Returns   : None\n Argument  : a Bio::LocatableSeq object\n             order (optional)\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $aln->remove_seq($seq);\n Function  : Removes a single sequence from an alignment\n Returns   :\n Argument  : a Bio::LocatableSeq object\n\n\nsub remove_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 purge\n\n Title   : purge\n Usage   : $aln->purge(0.7);\n Function:\n\n           Removes sequences above whatever %id.\n\n           This function will grind on large alignments. Beware!\n           (perhaps not ideally implemented)\n\n Example :\n Returns : An array of the removed sequences\n Argument:\n\n\n\nsub purge {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 sort_alphabetically\n\n Title     : sort_alphabetically\n Usage     : $ali->sort_alphabetically\n Function  : \n\n             Changes the order of the alignment to alphabetical on name \n             followed by numerical by number.\n\n Returns   : an array\n Argument  : \n\n\nsub sort_alphabetically {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Sequence selection methods\n\nMethods returning one or more sequences objects.\n\n=head2 each_seq\n\n Title     : each_seq\n Usage     : foreach $seq ( $align->each_seq() ) \n Function  : Gets an array of Seq objects from the alignment\n Returns   : an array\n Argument  : \n\n\nsub each_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_alphabetically\n\n Title     : each_alphabetically\n Usage     : foreach $seq ( $ali->each_alphabetically() )\n Function  :\n\n             Returns an array of sequence object sorted alphabetically \n             by name and then by start point.\n             Does not change the order of the alignment\n\n Returns   : \n Argument  : \n\n\nsub each_alphabetically {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_seq_with_id\n\n Title     : each_seq_with_id\n Usage     : foreach $seq ( $align->each_seq_with_id() ) \n Function  : \n\n             Gets an array of Seq objects from the\n             alignment, the contents being those sequences\n             with the given name (there may be more than one)\n\n Returns   : an array\n Argument  : a seq name\n\n\nsub each_seq_with_id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 get_seq_by_pos\n\n Title     : get_seq_by_pos\n Usage     : $seq = $aln->get_seq_by_pos(3) # third sequence from the alignment\n Function  : \n\n             Gets a sequence based on its position in the alignment.\n             Numbering starts from 1.  Sequence positions larger than\n             num_sequences() will throw an error.\n\n Returns   : a Bio::LocatableSeq object\n Argument  : positive integer for the sequence position\n\n\nsub get_seq_by_pos {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Create new alignments\n\nThe result of these methods are horizontal or vertical subsets of the\ncurrent MSE.\n\n=head2 select\n\n Title     : select\n Usage     : $aln2 = $aln->select(1, 3) # three first sequences\n Function  : \n\n             Creates a new alignment from a continuous subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for the first sequence\n             positive integer for the last sequence to include (optional)\n\n\nsub select {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 select_noncont\n\n Title     : select_noncont\n Usage     : $aln2 = $aln->select_noncont(1, 3) # first and 3rd sequences\n Function  : \n\n             Creates a new alignment from a subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Args      : array of integers for the sequences\n\n\nsub select_noncont {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 slice\n\n Title     : slice\n Usage     : $aln2 = $aln->slice(20, 30)\n Function  : \n\n             Creates a slice from the alignment inclusive of start and\n             end columns.  Sequences with no residues in the slice are\n             excluded from the new alignment and a warning is printed.\n             Slice beyond the length of the sequence does not do\n             padding.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for start column \n             positive integer for end column \n\n\nsub slice {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Change sequences within the MSE\n\nThese methods affect characters in all sequences without changing the\nalignment.\n\n\n=head2 map_chars\n\n Title     : map_chars\n Usage     : $ali->map_chars('\\.','-')\n Function  : \n\n             Does a s/$arg1/$arg2/ on the sequences. Useful for gap\n             characters\n\n             Notice that the from (arg1) is interpreted as a regex,\n             so be careful about quoting meta characters (eg\n             $ali->map_chars('.','-') wont do what you want)\n\n Returns   : None\n Argument  : 'from' rexexp\n             'to' string","parameters":[{"label":"$self"}]},"range":{"end":{"line":359,"character":9999},"start":{"line":356,"character":0}},"kind":12,"line":356,"detail":"($self)","definition":"sub","name":"map_chars","containerName":"main::","children":[{"definition":"my","localvar":"my","containerName":"map_chars","kind":13,"name":"$self","line":357},{"name":"$self","containerName":"map_chars","kind":13,"line":358},{"containerName":"map_chars","kind":12,"name":"throw_not_implemented","line":358}]},{"children":[{"name":"$self","localvar":"my","kind":13,"containerName":"uppercase","line":372,"definition":"my"},{"name":"$self","containerName":"uppercase","kind":13,"line":373},{"line":373,"name":"throw_not_implemented","kind":12,"containerName":"uppercase"}],"containerName":"main::","name":"uppercase","definition":"sub","detail":"($self)","line":371,"range":{"start":{"line":371,"character":0},"end":{"character":9999,"line":374}},"kind":12,"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: AlignI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::AlignI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::AlignI - An interface for describing sequence alignments.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Align::AlignI somehow - typically using Bio::AlignIO system\n  # some descriptors\n  print $aln->length, \"\\n\";\n  print $aln->num_residues, \"\\n\";\n  print $aln->is_flush, \"\\n\";\n  print $aln->num_sequences, \"\\n\";\n  print $aln->percentage_identity, \"\\n\";\n  print $aln->consensus_string(50), \"\\n\";\n\n  # find the position in the alignment for a sequence location\n  $pos = $aln->column_from_residue_number('1433_LYCES', 14); # = 6;\n\n  # extract sequences and check values for the alignment column $pos\n  foreach $seq ($aln->each_seq) {\n      $res = $seq->subseq($pos, $pos);\n      $count{$res}++;\n  }\n  foreach $res (keys %count) {\n      printf \"Res: %s  Count: %2d\\n\", $res, $count{$res};\n  }\n\n=head1 DESCRIPTION\n\nThis interface describes the basis for alignment objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::AlignI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $myalign->add_seq($newseq);\n Function  : Adds another sequence to the alignment. *Does not* align\n             it - just adds it to the hashes.\n Returns   : None\n Argument  : a Bio::LocatableSeq object\n             order (optional)\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $aln->remove_seq($seq);\n Function  : Removes a single sequence from an alignment\n Returns   :\n Argument  : a Bio::LocatableSeq object\n\n\nsub remove_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 purge\n\n Title   : purge\n Usage   : $aln->purge(0.7);\n Function:\n\n           Removes sequences above whatever %id.\n\n           This function will grind on large alignments. Beware!\n           (perhaps not ideally implemented)\n\n Example :\n Returns : An array of the removed sequences\n Argument:\n\n\n\nsub purge {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 sort_alphabetically\n\n Title     : sort_alphabetically\n Usage     : $ali->sort_alphabetically\n Function  : \n\n             Changes the order of the alignment to alphabetical on name \n             followed by numerical by number.\n\n Returns   : an array\n Argument  : \n\n\nsub sort_alphabetically {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Sequence selection methods\n\nMethods returning one or more sequences objects.\n\n=head2 each_seq\n\n Title     : each_seq\n Usage     : foreach $seq ( $align->each_seq() ) \n Function  : Gets an array of Seq objects from the alignment\n Returns   : an array\n Argument  : \n\n\nsub each_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_alphabetically\n\n Title     : each_alphabetically\n Usage     : foreach $seq ( $ali->each_alphabetically() )\n Function  :\n\n             Returns an array of sequence object sorted alphabetically \n             by name and then by start point.\n             Does not change the order of the alignment\n\n Returns   : \n Argument  : \n\n\nsub each_alphabetically {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_seq_with_id\n\n Title     : each_seq_with_id\n Usage     : foreach $seq ( $align->each_seq_with_id() ) \n Function  : \n\n             Gets an array of Seq objects from the\n             alignment, the contents being those sequences\n             with the given name (there may be more than one)\n\n Returns   : an array\n Argument  : a seq name\n\n\nsub each_seq_with_id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 get_seq_by_pos\n\n Title     : get_seq_by_pos\n Usage     : $seq = $aln->get_seq_by_pos(3) # third sequence from the alignment\n Function  : \n\n             Gets a sequence based on its position in the alignment.\n             Numbering starts from 1.  Sequence positions larger than\n             num_sequences() will throw an error.\n\n Returns   : a Bio::LocatableSeq object\n Argument  : positive integer for the sequence position\n\n\nsub get_seq_by_pos {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Create new alignments\n\nThe result of these methods are horizontal or vertical subsets of the\ncurrent MSE.\n\n=head2 select\n\n Title     : select\n Usage     : $aln2 = $aln->select(1, 3) # three first sequences\n Function  : \n\n             Creates a new alignment from a continuous subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for the first sequence\n             positive integer for the last sequence to include (optional)\n\n\nsub select {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 select_noncont\n\n Title     : select_noncont\n Usage     : $aln2 = $aln->select_noncont(1, 3) # first and 3rd sequences\n Function  : \n\n             Creates a new alignment from a subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Args      : array of integers for the sequences\n\n\nsub select_noncont {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 slice\n\n Title     : slice\n Usage     : $aln2 = $aln->slice(20, 30)\n Function  : \n\n             Creates a slice from the alignment inclusive of start and\n             end columns.  Sequences with no residues in the slice are\n             excluded from the new alignment and a warning is printed.\n             Slice beyond the length of the sequence does not do\n             padding.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for start column \n             positive integer for end column \n\n\nsub slice {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Change sequences within the MSE\n\nThese methods affect characters in all sequences without changing the\nalignment.\n\n\n=head2 map_chars\n\n Title     : map_chars\n Usage     : $ali->map_chars('\\.','-')\n Function  : \n\n             Does a s/$arg1/$arg2/ on the sequences. Useful for gap\n             characters\n\n             Notice that the from (arg1) is interpreted as a regex,\n             so be careful about quoting meta characters (eg\n             $ali->map_chars('.','-') wont do what you want)\n\n Returns   : None\n Argument  : 'from' rexexp\n             'to' string\n\n\nsub map_chars {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 uppercase\n\n Title     : uppercase()\n Usage     : $ali->uppercase()\n Function  : Sets all the sequences to uppercase\n Returns   : \n Argument  : ","label":"uppercase($self)"}},{"signature":{"documentation":"1;\n# $Id: AlignI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::AlignI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::AlignI - An interface for describing sequence alignments.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Align::AlignI somehow - typically using Bio::AlignIO system\n  # some descriptors\n  print $aln->length, \"\\n\";\n  print $aln->num_residues, \"\\n\";\n  print $aln->is_flush, \"\\n\";\n  print $aln->num_sequences, \"\\n\";\n  print $aln->percentage_identity, \"\\n\";\n  print $aln->consensus_string(50), \"\\n\";\n\n  # find the position in the alignment for a sequence location\n  $pos = $aln->column_from_residue_number('1433_LYCES', 14); # = 6;\n\n  # extract sequences and check values for the alignment column $pos\n  foreach $seq ($aln->each_seq) {\n      $res = $seq->subseq($pos, $pos);\n      $count{$res}++;\n  }\n  foreach $res (keys %count) {\n      printf \"Res: %s  Count: %2d\\n\", $res, $count{$res};\n  }\n\n=head1 DESCRIPTION\n\nThis interface describes the basis for alignment objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::AlignI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $myalign->add_seq($newseq);\n Function  : Adds another sequence to the alignment. *Does not* align\n             it - just adds it to the hashes.\n Returns   : None\n Argument  : a Bio::LocatableSeq object\n             order (optional)\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $aln->remove_seq($seq);\n Function  : Removes a single sequence from an alignment\n Returns   :\n Argument  : a Bio::LocatableSeq object\n\n\nsub remove_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 purge\n\n Title   : purge\n Usage   : $aln->purge(0.7);\n Function:\n\n           Removes sequences above whatever %id.\n\n           This function will grind on large alignments. Beware!\n           (perhaps not ideally implemented)\n\n Example :\n Returns : An array of the removed sequences\n Argument:\n\n\n\nsub purge {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 sort_alphabetically\n\n Title     : sort_alphabetically\n Usage     : $ali->sort_alphabetically\n Function  : \n\n             Changes the order of the alignment to alphabetical on name \n             followed by numerical by number.\n\n Returns   : an array\n Argument  : \n\n\nsub sort_alphabetically {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Sequence selection methods\n\nMethods returning one or more sequences objects.\n\n=head2 each_seq\n\n Title     : each_seq\n Usage     : foreach $seq ( $align->each_seq() ) \n Function  : Gets an array of Seq objects from the alignment\n Returns   : an array\n Argument  : \n\n\nsub each_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_alphabetically\n\n Title     : each_alphabetically\n Usage     : foreach $seq ( $ali->each_alphabetically() )\n Function  :\n\n             Returns an array of sequence object sorted alphabetically \n             by name and then by start point.\n             Does not change the order of the alignment\n\n Returns   : \n Argument  : \n\n\nsub each_alphabetically {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_seq_with_id\n\n Title     : each_seq_with_id\n Usage     : foreach $seq ( $align->each_seq_with_id() ) \n Function  : \n\n             Gets an array of Seq objects from the\n             alignment, the contents being those sequences\n             with the given name (there may be more than one)\n\n Returns   : an array\n Argument  : a seq name\n\n\nsub each_seq_with_id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 get_seq_by_pos\n\n Title     : get_seq_by_pos\n Usage     : $seq = $aln->get_seq_by_pos(3) # third sequence from the alignment\n Function  : \n\n             Gets a sequence based on its position in the alignment.\n             Numbering starts from 1.  Sequence positions larger than\n             num_sequences() will throw an error.\n\n Returns   : a Bio::LocatableSeq object\n Argument  : positive integer for the sequence position\n\n\nsub get_seq_by_pos {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Create new alignments\n\nThe result of these methods are horizontal or vertical subsets of the\ncurrent MSE.\n\n=head2 select\n\n Title     : select\n Usage     : $aln2 = $aln->select(1, 3) # three first sequences\n Function  : \n\n             Creates a new alignment from a continuous subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for the first sequence\n             positive integer for the last sequence to include (optional)\n\n\nsub select {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 select_noncont\n\n Title     : select_noncont\n Usage     : $aln2 = $aln->select_noncont(1, 3) # first and 3rd sequences\n Function  : \n\n             Creates a new alignment from a subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Args      : array of integers for the sequences\n\n\nsub select_noncont {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 slice\n\n Title     : slice\n Usage     : $aln2 = $aln->slice(20, 30)\n Function  : \n\n             Creates a slice from the alignment inclusive of start and\n             end columns.  Sequences with no residues in the slice are\n             excluded from the new alignment and a warning is printed.\n             Slice beyond the length of the sequence does not do\n             padding.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for start column \n             positive integer for end column \n\n\nsub slice {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Change sequences within the MSE\n\nThese methods affect characters in all sequences without changing the\nalignment.\n\n\n=head2 map_chars\n\n Title     : map_chars\n Usage     : $ali->map_chars('\\.','-')\n Function  : \n\n             Does a s/$arg1/$arg2/ on the sequences. Useful for gap\n             characters\n\n             Notice that the from (arg1) is interpreted as a regex,\n             so be careful about quoting meta characters (eg\n             $ali->map_chars('.','-') wont do what you want)\n\n Returns   : None\n Argument  : 'from' rexexp\n             'to' string\n\n\nsub map_chars {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 uppercase\n\n Title     : uppercase()\n Usage     : $ali->uppercase()\n Function  : Sets all the sequences to uppercase\n Returns   : \n Argument  : \n\n\nsub uppercase {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_line\n\n Title    : match_line()\n Usage    : $align->match_line()\n Function : Generates a match line - much like consensus string\n            except that a line indicating the '*' for a match.\n Argument : (optional) Match line characters ('*' by default)\n            (optional) Strong match char (':' by default)\n            (optional) Weak match char ('.' by default)","parameters":[{"label":"$self"}],"label":"match_line($self)"},"line":388,"kind":12,"range":{"start":{"character":0,"line":388},"end":{"character":9999,"line":391}},"definition":"sub","detail":"($self)","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"match_line","name":"$self","line":389},{"kind":13,"containerName":"match_line","name":"$self","line":390},{"kind":12,"containerName":"match_line","name":"throw_not_implemented","line":390}],"containerName":"main::","name":"match_line"},{"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: AlignI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::AlignI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::AlignI - An interface for describing sequence alignments.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Align::AlignI somehow - typically using Bio::AlignIO system\n  # some descriptors\n  print $aln->length, \"\\n\";\n  print $aln->num_residues, \"\\n\";\n  print $aln->is_flush, \"\\n\";\n  print $aln->num_sequences, \"\\n\";\n  print $aln->percentage_identity, \"\\n\";\n  print $aln->consensus_string(50), \"\\n\";\n\n  # find the position in the alignment for a sequence location\n  $pos = $aln->column_from_residue_number('1433_LYCES', 14); # = 6;\n\n  # extract sequences and check values for the alignment column $pos\n  foreach $seq ($aln->each_seq) {\n      $res = $seq->subseq($pos, $pos);\n      $count{$res}++;\n  }\n  foreach $res (keys %count) {\n      printf \"Res: %s  Count: %2d\\n\", $res, $count{$res};\n  }\n\n=head1 DESCRIPTION\n\nThis interface describes the basis for alignment objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::AlignI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $myalign->add_seq($newseq);\n Function  : Adds another sequence to the alignment. *Does not* align\n             it - just adds it to the hashes.\n Returns   : None\n Argument  : a Bio::LocatableSeq object\n             order (optional)\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $aln->remove_seq($seq);\n Function  : Removes a single sequence from an alignment\n Returns   :\n Argument  : a Bio::LocatableSeq object\n\n\nsub remove_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 purge\n\n Title   : purge\n Usage   : $aln->purge(0.7);\n Function:\n\n           Removes sequences above whatever %id.\n\n           This function will grind on large alignments. Beware!\n           (perhaps not ideally implemented)\n\n Example :\n Returns : An array of the removed sequences\n Argument:\n\n\n\nsub purge {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 sort_alphabetically\n\n Title     : sort_alphabetically\n Usage     : $ali->sort_alphabetically\n Function  : \n\n             Changes the order of the alignment to alphabetical on name \n             followed by numerical by number.\n\n Returns   : an array\n Argument  : \n\n\nsub sort_alphabetically {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Sequence selection methods\n\nMethods returning one or more sequences objects.\n\n=head2 each_seq\n\n Title     : each_seq\n Usage     : foreach $seq ( $align->each_seq() ) \n Function  : Gets an array of Seq objects from the alignment\n Returns   : an array\n Argument  : \n\n\nsub each_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_alphabetically\n\n Title     : each_alphabetically\n Usage     : foreach $seq ( $ali->each_alphabetically() )\n Function  :\n\n             Returns an array of sequence object sorted alphabetically \n             by name and then by start point.\n             Does not change the order of the alignment\n\n Returns   : \n Argument  : \n\n\nsub each_alphabetically {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_seq_with_id\n\n Title     : each_seq_with_id\n Usage     : foreach $seq ( $align->each_seq_with_id() ) \n Function  : \n\n             Gets an array of Seq objects from the\n             alignment, the contents being those sequences\n             with the given name (there may be more than one)\n\n Returns   : an array\n Argument  : a seq name\n\n\nsub each_seq_with_id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 get_seq_by_pos\n\n Title     : get_seq_by_pos\n Usage     : $seq = $aln->get_seq_by_pos(3) # third sequence from the alignment\n Function  : \n\n             Gets a sequence based on its position in the alignment.\n             Numbering starts from 1.  Sequence positions larger than\n             num_sequences() will throw an error.\n\n Returns   : a Bio::LocatableSeq object\n Argument  : positive integer for the sequence position\n\n\nsub get_seq_by_pos {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Create new alignments\n\nThe result of these methods are horizontal or vertical subsets of the\ncurrent MSE.\n\n=head2 select\n\n Title     : select\n Usage     : $aln2 = $aln->select(1, 3) # three first sequences\n Function  : \n\n             Creates a new alignment from a continuous subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for the first sequence\n             positive integer for the last sequence to include (optional)\n\n\nsub select {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 select_noncont\n\n Title     : select_noncont\n Usage     : $aln2 = $aln->select_noncont(1, 3) # first and 3rd sequences\n Function  : \n\n             Creates a new alignment from a subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Args      : array of integers for the sequences\n\n\nsub select_noncont {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 slice\n\n Title     : slice\n Usage     : $aln2 = $aln->slice(20, 30)\n Function  : \n\n             Creates a slice from the alignment inclusive of start and\n             end columns.  Sequences with no residues in the slice are\n             excluded from the new alignment and a warning is printed.\n             Slice beyond the length of the sequence does not do\n             padding.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for start column \n             positive integer for end column \n\n\nsub slice {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Change sequences within the MSE\n\nThese methods affect characters in all sequences without changing the\nalignment.\n\n\n=head2 map_chars\n\n Title     : map_chars\n Usage     : $ali->map_chars('\\.','-')\n Function  : \n\n             Does a s/$arg1/$arg2/ on the sequences. Useful for gap\n             characters\n\n             Notice that the from (arg1) is interpreted as a regex,\n             so be careful about quoting meta characters (eg\n             $ali->map_chars('.','-') wont do what you want)\n\n Returns   : None\n Argument  : 'from' rexexp\n             'to' string\n\n\nsub map_chars {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 uppercase\n\n Title     : uppercase()\n Usage     : $ali->uppercase()\n Function  : Sets all the sequences to uppercase\n Returns   : \n Argument  : \n\n\nsub uppercase {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_line\n\n Title    : match_line()\n Usage    : $align->match_line()\n Function : Generates a match line - much like consensus string\n            except that a line indicating the '*' for a match.\n Argument : (optional) Match line characters ('*' by default)\n            (optional) Strong match char (':' by default)\n            (optional) Weak match char ('.' by default)\n\n\nsub match_line {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match\n\n Title     : match()\n Usage     : $ali->match()\n Function  : \n\n             Goes through all columns and changes residues that are\n             identical to residue in first sequence to match '.'\n             character. Sets match_char.\n\n             USE WITH CARE: Most MSE formats do not support match\n             characters in sequences, so this is mostly for output\n             only. NEXUS format (Bio::AlignIO::nexus) can handle\n             it.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'","label":"match($self)"},"line":413,"kind":12,"range":{"end":{"character":9999,"line":416},"start":{"character":0,"line":413}},"definition":"sub","detail":"($self)","children":[{"line":414,"localvar":"my","containerName":"match","kind":13,"name":"$self","definition":"my"},{"kind":13,"containerName":"match","name":"$self","line":415},{"line":415,"containerName":"match","kind":12,"name":"throw_not_implemented"}],"name":"match","containerName":"main::"},{"line":431,"range":{"start":{"line":431,"character":0},"end":{"character":9999,"line":434}},"kind":12,"signature":{"label":"unmatch($self)","documentation":"1;\n# $Id: AlignI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::AlignI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::AlignI - An interface for describing sequence alignments.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Align::AlignI somehow - typically using Bio::AlignIO system\n  # some descriptors\n  print $aln->length, \"\\n\";\n  print $aln->num_residues, \"\\n\";\n  print $aln->is_flush, \"\\n\";\n  print $aln->num_sequences, \"\\n\";\n  print $aln->percentage_identity, \"\\n\";\n  print $aln->consensus_string(50), \"\\n\";\n\n  # find the position in the alignment for a sequence location\n  $pos = $aln->column_from_residue_number('1433_LYCES', 14); # = 6;\n\n  # extract sequences and check values for the alignment column $pos\n  foreach $seq ($aln->each_seq) {\n      $res = $seq->subseq($pos, $pos);\n      $count{$res}++;\n  }\n  foreach $res (keys %count) {\n      printf \"Res: %s  Count: %2d\\n\", $res, $count{$res};\n  }\n\n=head1 DESCRIPTION\n\nThis interface describes the basis for alignment objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::AlignI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $myalign->add_seq($newseq);\n Function  : Adds another sequence to the alignment. *Does not* align\n             it - just adds it to the hashes.\n Returns   : None\n Argument  : a Bio::LocatableSeq object\n             order (optional)\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $aln->remove_seq($seq);\n Function  : Removes a single sequence from an alignment\n Returns   :\n Argument  : a Bio::LocatableSeq object\n\n\nsub remove_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 purge\n\n Title   : purge\n Usage   : $aln->purge(0.7);\n Function:\n\n           Removes sequences above whatever %id.\n\n           This function will grind on large alignments. Beware!\n           (perhaps not ideally implemented)\n\n Example :\n Returns : An array of the removed sequences\n Argument:\n\n\n\nsub purge {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 sort_alphabetically\n\n Title     : sort_alphabetically\n Usage     : $ali->sort_alphabetically\n Function  : \n\n             Changes the order of the alignment to alphabetical on name \n             followed by numerical by number.\n\n Returns   : an array\n Argument  : \n\n\nsub sort_alphabetically {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Sequence selection methods\n\nMethods returning one or more sequences objects.\n\n=head2 each_seq\n\n Title     : each_seq\n Usage     : foreach $seq ( $align->each_seq() ) \n Function  : Gets an array of Seq objects from the alignment\n Returns   : an array\n Argument  : \n\n\nsub each_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_alphabetically\n\n Title     : each_alphabetically\n Usage     : foreach $seq ( $ali->each_alphabetically() )\n Function  :\n\n             Returns an array of sequence object sorted alphabetically \n             by name and then by start point.\n             Does not change the order of the alignment\n\n Returns   : \n Argument  : \n\n\nsub each_alphabetically {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_seq_with_id\n\n Title     : each_seq_with_id\n Usage     : foreach $seq ( $align->each_seq_with_id() ) \n Function  : \n\n             Gets an array of Seq objects from the\n             alignment, the contents being those sequences\n             with the given name (there may be more than one)\n\n Returns   : an array\n Argument  : a seq name\n\n\nsub each_seq_with_id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 get_seq_by_pos\n\n Title     : get_seq_by_pos\n Usage     : $seq = $aln->get_seq_by_pos(3) # third sequence from the alignment\n Function  : \n\n             Gets a sequence based on its position in the alignment.\n             Numbering starts from 1.  Sequence positions larger than\n             num_sequences() will throw an error.\n\n Returns   : a Bio::LocatableSeq object\n Argument  : positive integer for the sequence position\n\n\nsub get_seq_by_pos {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Create new alignments\n\nThe result of these methods are horizontal or vertical subsets of the\ncurrent MSE.\n\n=head2 select\n\n Title     : select\n Usage     : $aln2 = $aln->select(1, 3) # three first sequences\n Function  : \n\n             Creates a new alignment from a continuous subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for the first sequence\n             positive integer for the last sequence to include (optional)\n\n\nsub select {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 select_noncont\n\n Title     : select_noncont\n Usage     : $aln2 = $aln->select_noncont(1, 3) # first and 3rd sequences\n Function  : \n\n             Creates a new alignment from a subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Args      : array of integers for the sequences\n\n\nsub select_noncont {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 slice\n\n Title     : slice\n Usage     : $aln2 = $aln->slice(20, 30)\n Function  : \n\n             Creates a slice from the alignment inclusive of start and\n             end columns.  Sequences with no residues in the slice are\n             excluded from the new alignment and a warning is printed.\n             Slice beyond the length of the sequence does not do\n             padding.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for start column \n             positive integer for end column \n\n\nsub slice {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Change sequences within the MSE\n\nThese methods affect characters in all sequences without changing the\nalignment.\n\n\n=head2 map_chars\n\n Title     : map_chars\n Usage     : $ali->map_chars('\\.','-')\n Function  : \n\n             Does a s/$arg1/$arg2/ on the sequences. Useful for gap\n             characters\n\n             Notice that the from (arg1) is interpreted as a regex,\n             so be careful about quoting meta characters (eg\n             $ali->map_chars('.','-') wont do what you want)\n\n Returns   : None\n Argument  : 'from' rexexp\n             'to' string\n\n\nsub map_chars {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 uppercase\n\n Title     : uppercase()\n Usage     : $ali->uppercase()\n Function  : Sets all the sequences to uppercase\n Returns   : \n Argument  : \n\n\nsub uppercase {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_line\n\n Title    : match_line()\n Usage    : $align->match_line()\n Function : Generates a match line - much like consensus string\n            except that a line indicating the '*' for a match.\n Argument : (optional) Match line characters ('*' by default)\n            (optional) Strong match char (':' by default)\n            (optional) Weak match char ('.' by default)\n\n\nsub match_line {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match\n\n Title     : match()\n Usage     : $ali->match()\n Function  : \n\n             Goes through all columns and changes residues that are\n             identical to residue in first sequence to match '.'\n             character. Sets match_char.\n\n             USE WITH CARE: Most MSE formats do not support match\n             characters in sequences, so this is mostly for output\n             only. NEXUS format (Bio::AlignIO::nexus) can handle\n             it.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub match {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 unmatch\n\n Title     : unmatch()\n Usage     : $ali->unmatch()\n Function  : \n\n             Undoes the effect of method match. Unsets match_char.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'","parameters":[{"label":"$self"}]},"children":[{"name":"$self","localvar":"my","kind":13,"containerName":"unmatch","line":432,"definition":"my"},{"kind":13,"containerName":"unmatch","name":"$self","line":433},{"line":433,"containerName":"unmatch","kind":12,"name":"throw_not_implemented"}],"name":"unmatch","containerName":"main::","definition":"sub","detail":"($self)"},{"name":"id","containerName":"main::","children":[{"definition":"my","line":456,"name":"$self","containerName":"id","localvar":"my","kind":13},{"name":"$self","kind":13,"containerName":"id","line":457},{"line":457,"kind":12,"containerName":"id","name":"throw_not_implemented"}],"detail":"($self)","definition":"sub","kind":12,"range":{"end":{"line":458,"character":9999},"start":{"character":0,"line":455}},"line":455,"signature":{"label":"id($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: AlignI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::AlignI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::AlignI - An interface for describing sequence alignments.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Align::AlignI somehow - typically using Bio::AlignIO system\n  # some descriptors\n  print $aln->length, \"\\n\";\n  print $aln->num_residues, \"\\n\";\n  print $aln->is_flush, \"\\n\";\n  print $aln->num_sequences, \"\\n\";\n  print $aln->percentage_identity, \"\\n\";\n  print $aln->consensus_string(50), \"\\n\";\n\n  # find the position in the alignment for a sequence location\n  $pos = $aln->column_from_residue_number('1433_LYCES', 14); # = 6;\n\n  # extract sequences and check values for the alignment column $pos\n  foreach $seq ($aln->each_seq) {\n      $res = $seq->subseq($pos, $pos);\n      $count{$res}++;\n  }\n  foreach $res (keys %count) {\n      printf \"Res: %s  Count: %2d\\n\", $res, $count{$res};\n  }\n\n=head1 DESCRIPTION\n\nThis interface describes the basis for alignment objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::AlignI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $myalign->add_seq($newseq);\n Function  : Adds another sequence to the alignment. *Does not* align\n             it - just adds it to the hashes.\n Returns   : None\n Argument  : a Bio::LocatableSeq object\n             order (optional)\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $aln->remove_seq($seq);\n Function  : Removes a single sequence from an alignment\n Returns   :\n Argument  : a Bio::LocatableSeq object\n\n\nsub remove_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 purge\n\n Title   : purge\n Usage   : $aln->purge(0.7);\n Function:\n\n           Removes sequences above whatever %id.\n\n           This function will grind on large alignments. Beware!\n           (perhaps not ideally implemented)\n\n Example :\n Returns : An array of the removed sequences\n Argument:\n\n\n\nsub purge {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 sort_alphabetically\n\n Title     : sort_alphabetically\n Usage     : $ali->sort_alphabetically\n Function  : \n\n             Changes the order of the alignment to alphabetical on name \n             followed by numerical by number.\n\n Returns   : an array\n Argument  : \n\n\nsub sort_alphabetically {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Sequence selection methods\n\nMethods returning one or more sequences objects.\n\n=head2 each_seq\n\n Title     : each_seq\n Usage     : foreach $seq ( $align->each_seq() ) \n Function  : Gets an array of Seq objects from the alignment\n Returns   : an array\n Argument  : \n\n\nsub each_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_alphabetically\n\n Title     : each_alphabetically\n Usage     : foreach $seq ( $ali->each_alphabetically() )\n Function  :\n\n             Returns an array of sequence object sorted alphabetically \n             by name and then by start point.\n             Does not change the order of the alignment\n\n Returns   : \n Argument  : \n\n\nsub each_alphabetically {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_seq_with_id\n\n Title     : each_seq_with_id\n Usage     : foreach $seq ( $align->each_seq_with_id() ) \n Function  : \n\n             Gets an array of Seq objects from the\n             alignment, the contents being those sequences\n             with the given name (there may be more than one)\n\n Returns   : an array\n Argument  : a seq name\n\n\nsub each_seq_with_id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 get_seq_by_pos\n\n Title     : get_seq_by_pos\n Usage     : $seq = $aln->get_seq_by_pos(3) # third sequence from the alignment\n Function  : \n\n             Gets a sequence based on its position in the alignment.\n             Numbering starts from 1.  Sequence positions larger than\n             num_sequences() will throw an error.\n\n Returns   : a Bio::LocatableSeq object\n Argument  : positive integer for the sequence position\n\n\nsub get_seq_by_pos {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Create new alignments\n\nThe result of these methods are horizontal or vertical subsets of the\ncurrent MSE.\n\n=head2 select\n\n Title     : select\n Usage     : $aln2 = $aln->select(1, 3) # three first sequences\n Function  : \n\n             Creates a new alignment from a continuous subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for the first sequence\n             positive integer for the last sequence to include (optional)\n\n\nsub select {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 select_noncont\n\n Title     : select_noncont\n Usage     : $aln2 = $aln->select_noncont(1, 3) # first and 3rd sequences\n Function  : \n\n             Creates a new alignment from a subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Args      : array of integers for the sequences\n\n\nsub select_noncont {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 slice\n\n Title     : slice\n Usage     : $aln2 = $aln->slice(20, 30)\n Function  : \n\n             Creates a slice from the alignment inclusive of start and\n             end columns.  Sequences with no residues in the slice are\n             excluded from the new alignment and a warning is printed.\n             Slice beyond the length of the sequence does not do\n             padding.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for start column \n             positive integer for end column \n\n\nsub slice {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Change sequences within the MSE\n\nThese methods affect characters in all sequences without changing the\nalignment.\n\n\n=head2 map_chars\n\n Title     : map_chars\n Usage     : $ali->map_chars('\\.','-')\n Function  : \n\n             Does a s/$arg1/$arg2/ on the sequences. Useful for gap\n             characters\n\n             Notice that the from (arg1) is interpreted as a regex,\n             so be careful about quoting meta characters (eg\n             $ali->map_chars('.','-') wont do what you want)\n\n Returns   : None\n Argument  : 'from' rexexp\n             'to' string\n\n\nsub map_chars {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 uppercase\n\n Title     : uppercase()\n Usage     : $ali->uppercase()\n Function  : Sets all the sequences to uppercase\n Returns   : \n Argument  : \n\n\nsub uppercase {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_line\n\n Title    : match_line()\n Usage    : $align->match_line()\n Function : Generates a match line - much like consensus string\n            except that a line indicating the '*' for a match.\n Argument : (optional) Match line characters ('*' by default)\n            (optional) Strong match char (':' by default)\n            (optional) Weak match char ('.' by default)\n\n\nsub match_line {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match\n\n Title     : match()\n Usage     : $ali->match()\n Function  : \n\n             Goes through all columns and changes residues that are\n             identical to residue in first sequence to match '.'\n             character. Sets match_char.\n\n             USE WITH CARE: Most MSE formats do not support match\n             characters in sequences, so this is mostly for output\n             only. NEXUS format (Bio::AlignIO::nexus) can handle\n             it.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub match {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 unmatch\n\n Title     : unmatch()\n Usage     : $ali->unmatch()\n Function  : \n\n             Undoes the effect of method match. Unsets match_char.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub unmatch {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head1 MSE attibutes\n\nMethods for setting and reading the MSE attributes. \n\nNote that the methods defining character semantics depend on the user\nto set them sensibly.  They are needed only by certain input/output\nmethods. Unset them by setting to an empty string ('').\n\n=head2 id\n\n Title     : id\n Usage     : $myalign->id(\"Ig\")\n Function  : Gets/sets the id field of the alignment\n Returns   : An id string\n Argument  : An id string (optional)"}},{"children":[{"definition":"my","line":473,"containerName":"missing_char","localvar":"my","kind":13,"name":"$self"},{"containerName":"missing_char","kind":13,"name":"$self","line":474},{"line":474,"containerName":"missing_char","kind":12,"name":"throw_not_implemented"}],"containerName":"main::","name":"missing_char","definition":"sub","detail":"($self)","line":472,"kind":12,"range":{"start":{"line":472,"character":0},"end":{"line":475,"character":9999}},"signature":{"label":"missing_char($self)","documentation":"1;\n# $Id: AlignI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::AlignI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::AlignI - An interface for describing sequence alignments.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Align::AlignI somehow - typically using Bio::AlignIO system\n  # some descriptors\n  print $aln->length, \"\\n\";\n  print $aln->num_residues, \"\\n\";\n  print $aln->is_flush, \"\\n\";\n  print $aln->num_sequences, \"\\n\";\n  print $aln->percentage_identity, \"\\n\";\n  print $aln->consensus_string(50), \"\\n\";\n\n  # find the position in the alignment for a sequence location\n  $pos = $aln->column_from_residue_number('1433_LYCES', 14); # = 6;\n\n  # extract sequences and check values for the alignment column $pos\n  foreach $seq ($aln->each_seq) {\n      $res = $seq->subseq($pos, $pos);\n      $count{$res}++;\n  }\n  foreach $res (keys %count) {\n      printf \"Res: %s  Count: %2d\\n\", $res, $count{$res};\n  }\n\n=head1 DESCRIPTION\n\nThis interface describes the basis for alignment objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::AlignI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $myalign->add_seq($newseq);\n Function  : Adds another sequence to the alignment. *Does not* align\n             it - just adds it to the hashes.\n Returns   : None\n Argument  : a Bio::LocatableSeq object\n             order (optional)\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $aln->remove_seq($seq);\n Function  : Removes a single sequence from an alignment\n Returns   :\n Argument  : a Bio::LocatableSeq object\n\n\nsub remove_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 purge\n\n Title   : purge\n Usage   : $aln->purge(0.7);\n Function:\n\n           Removes sequences above whatever %id.\n\n           This function will grind on large alignments. Beware!\n           (perhaps not ideally implemented)\n\n Example :\n Returns : An array of the removed sequences\n Argument:\n\n\n\nsub purge {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 sort_alphabetically\n\n Title     : sort_alphabetically\n Usage     : $ali->sort_alphabetically\n Function  : \n\n             Changes the order of the alignment to alphabetical on name \n             followed by numerical by number.\n\n Returns   : an array\n Argument  : \n\n\nsub sort_alphabetically {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Sequence selection methods\n\nMethods returning one or more sequences objects.\n\n=head2 each_seq\n\n Title     : each_seq\n Usage     : foreach $seq ( $align->each_seq() ) \n Function  : Gets an array of Seq objects from the alignment\n Returns   : an array\n Argument  : \n\n\nsub each_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_alphabetically\n\n Title     : each_alphabetically\n Usage     : foreach $seq ( $ali->each_alphabetically() )\n Function  :\n\n             Returns an array of sequence object sorted alphabetically \n             by name and then by start point.\n             Does not change the order of the alignment\n\n Returns   : \n Argument  : \n\n\nsub each_alphabetically {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_seq_with_id\n\n Title     : each_seq_with_id\n Usage     : foreach $seq ( $align->each_seq_with_id() ) \n Function  : \n\n             Gets an array of Seq objects from the\n             alignment, the contents being those sequences\n             with the given name (there may be more than one)\n\n Returns   : an array\n Argument  : a seq name\n\n\nsub each_seq_with_id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 get_seq_by_pos\n\n Title     : get_seq_by_pos\n Usage     : $seq = $aln->get_seq_by_pos(3) # third sequence from the alignment\n Function  : \n\n             Gets a sequence based on its position in the alignment.\n             Numbering starts from 1.  Sequence positions larger than\n             num_sequences() will throw an error.\n\n Returns   : a Bio::LocatableSeq object\n Argument  : positive integer for the sequence position\n\n\nsub get_seq_by_pos {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Create new alignments\n\nThe result of these methods are horizontal or vertical subsets of the\ncurrent MSE.\n\n=head2 select\n\n Title     : select\n Usage     : $aln2 = $aln->select(1, 3) # three first sequences\n Function  : \n\n             Creates a new alignment from a continuous subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for the first sequence\n             positive integer for the last sequence to include (optional)\n\n\nsub select {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 select_noncont\n\n Title     : select_noncont\n Usage     : $aln2 = $aln->select_noncont(1, 3) # first and 3rd sequences\n Function  : \n\n             Creates a new alignment from a subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Args      : array of integers for the sequences\n\n\nsub select_noncont {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 slice\n\n Title     : slice\n Usage     : $aln2 = $aln->slice(20, 30)\n Function  : \n\n             Creates a slice from the alignment inclusive of start and\n             end columns.  Sequences with no residues in the slice are\n             excluded from the new alignment and a warning is printed.\n             Slice beyond the length of the sequence does not do\n             padding.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for start column \n             positive integer for end column \n\n\nsub slice {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Change sequences within the MSE\n\nThese methods affect characters in all sequences without changing the\nalignment.\n\n\n=head2 map_chars\n\n Title     : map_chars\n Usage     : $ali->map_chars('\\.','-')\n Function  : \n\n             Does a s/$arg1/$arg2/ on the sequences. Useful for gap\n             characters\n\n             Notice that the from (arg1) is interpreted as a regex,\n             so be careful about quoting meta characters (eg\n             $ali->map_chars('.','-') wont do what you want)\n\n Returns   : None\n Argument  : 'from' rexexp\n             'to' string\n\n\nsub map_chars {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 uppercase\n\n Title     : uppercase()\n Usage     : $ali->uppercase()\n Function  : Sets all the sequences to uppercase\n Returns   : \n Argument  : \n\n\nsub uppercase {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_line\n\n Title    : match_line()\n Usage    : $align->match_line()\n Function : Generates a match line - much like consensus string\n            except that a line indicating the '*' for a match.\n Argument : (optional) Match line characters ('*' by default)\n            (optional) Strong match char (':' by default)\n            (optional) Weak match char ('.' by default)\n\n\nsub match_line {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match\n\n Title     : match()\n Usage     : $ali->match()\n Function  : \n\n             Goes through all columns and changes residues that are\n             identical to residue in first sequence to match '.'\n             character. Sets match_char.\n\n             USE WITH CARE: Most MSE formats do not support match\n             characters in sequences, so this is mostly for output\n             only. NEXUS format (Bio::AlignIO::nexus) can handle\n             it.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub match {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 unmatch\n\n Title     : unmatch()\n Usage     : $ali->unmatch()\n Function  : \n\n             Undoes the effect of method match. Unsets match_char.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub unmatch {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head1 MSE attibutes\n\nMethods for setting and reading the MSE attributes. \n\nNote that the methods defining character semantics depend on the user\nto set them sensibly.  They are needed only by certain input/output\nmethods. Unset them by setting to an empty string ('').\n\n=head2 id\n\n Title     : id\n Usage     : $myalign->id(\"Ig\")\n Function  : Gets/sets the id field of the alignment\n Returns   : An id string\n Argument  : An id string (optional)\n\n\nsub id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 missing_char\n\n Title     : missing_char\n Usage     : $myalign->missing_char(\"?\")\n Function  : Gets/sets the missing_char attribute of the alignment\n             It is generally recommended to set it to 'n' or 'N' \n             for nucleotides and to 'X' for protein. \n Returns   : An missing_char string,\n Argument  : An missing_char string (optional)","parameters":[{"label":"$self"}]}},{"children":[{"containerName":"match_char","localvar":"my","kind":13,"name":"$self","line":488,"definition":"my"},{"line":489,"kind":13,"containerName":"match_char","name":"$self"},{"name":"throw_not_implemented","kind":12,"containerName":"match_char","line":489}],"name":"match_char","containerName":"main::","definition":"sub","detail":"($self)","line":487,"range":{"end":{"character":9999,"line":490},"start":{"line":487,"character":0}},"kind":12,"signature":{"label":"match_char($self)","documentation":"1;\n# $Id: AlignI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::AlignI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::AlignI - An interface for describing sequence alignments.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Align::AlignI somehow - typically using Bio::AlignIO system\n  # some descriptors\n  print $aln->length, \"\\n\";\n  print $aln->num_residues, \"\\n\";\n  print $aln->is_flush, \"\\n\";\n  print $aln->num_sequences, \"\\n\";\n  print $aln->percentage_identity, \"\\n\";\n  print $aln->consensus_string(50), \"\\n\";\n\n  # find the position in the alignment for a sequence location\n  $pos = $aln->column_from_residue_number('1433_LYCES', 14); # = 6;\n\n  # extract sequences and check values for the alignment column $pos\n  foreach $seq ($aln->each_seq) {\n      $res = $seq->subseq($pos, $pos);\n      $count{$res}++;\n  }\n  foreach $res (keys %count) {\n      printf \"Res: %s  Count: %2d\\n\", $res, $count{$res};\n  }\n\n=head1 DESCRIPTION\n\nThis interface describes the basis for alignment objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::AlignI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $myalign->add_seq($newseq);\n Function  : Adds another sequence to the alignment. *Does not* align\n             it - just adds it to the hashes.\n Returns   : None\n Argument  : a Bio::LocatableSeq object\n             order (optional)\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $aln->remove_seq($seq);\n Function  : Removes a single sequence from an alignment\n Returns   :\n Argument  : a Bio::LocatableSeq object\n\n\nsub remove_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 purge\n\n Title   : purge\n Usage   : $aln->purge(0.7);\n Function:\n\n           Removes sequences above whatever %id.\n\n           This function will grind on large alignments. Beware!\n           (perhaps not ideally implemented)\n\n Example :\n Returns : An array of the removed sequences\n Argument:\n\n\n\nsub purge {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 sort_alphabetically\n\n Title     : sort_alphabetically\n Usage     : $ali->sort_alphabetically\n Function  : \n\n             Changes the order of the alignment to alphabetical on name \n             followed by numerical by number.\n\n Returns   : an array\n Argument  : \n\n\nsub sort_alphabetically {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Sequence selection methods\n\nMethods returning one or more sequences objects.\n\n=head2 each_seq\n\n Title     : each_seq\n Usage     : foreach $seq ( $align->each_seq() ) \n Function  : Gets an array of Seq objects from the alignment\n Returns   : an array\n Argument  : \n\n\nsub each_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_alphabetically\n\n Title     : each_alphabetically\n Usage     : foreach $seq ( $ali->each_alphabetically() )\n Function  :\n\n             Returns an array of sequence object sorted alphabetically \n             by name and then by start point.\n             Does not change the order of the alignment\n\n Returns   : \n Argument  : \n\n\nsub each_alphabetically {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_seq_with_id\n\n Title     : each_seq_with_id\n Usage     : foreach $seq ( $align->each_seq_with_id() ) \n Function  : \n\n             Gets an array of Seq objects from the\n             alignment, the contents being those sequences\n             with the given name (there may be more than one)\n\n Returns   : an array\n Argument  : a seq name\n\n\nsub each_seq_with_id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 get_seq_by_pos\n\n Title     : get_seq_by_pos\n Usage     : $seq = $aln->get_seq_by_pos(3) # third sequence from the alignment\n Function  : \n\n             Gets a sequence based on its position in the alignment.\n             Numbering starts from 1.  Sequence positions larger than\n             num_sequences() will throw an error.\n\n Returns   : a Bio::LocatableSeq object\n Argument  : positive integer for the sequence position\n\n\nsub get_seq_by_pos {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Create new alignments\n\nThe result of these methods are horizontal or vertical subsets of the\ncurrent MSE.\n\n=head2 select\n\n Title     : select\n Usage     : $aln2 = $aln->select(1, 3) # three first sequences\n Function  : \n\n             Creates a new alignment from a continuous subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for the first sequence\n             positive integer for the last sequence to include (optional)\n\n\nsub select {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 select_noncont\n\n Title     : select_noncont\n Usage     : $aln2 = $aln->select_noncont(1, 3) # first and 3rd sequences\n Function  : \n\n             Creates a new alignment from a subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Args      : array of integers for the sequences\n\n\nsub select_noncont {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 slice\n\n Title     : slice\n Usage     : $aln2 = $aln->slice(20, 30)\n Function  : \n\n             Creates a slice from the alignment inclusive of start and\n             end columns.  Sequences with no residues in the slice are\n             excluded from the new alignment and a warning is printed.\n             Slice beyond the length of the sequence does not do\n             padding.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for start column \n             positive integer for end column \n\n\nsub slice {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Change sequences within the MSE\n\nThese methods affect characters in all sequences without changing the\nalignment.\n\n\n=head2 map_chars\n\n Title     : map_chars\n Usage     : $ali->map_chars('\\.','-')\n Function  : \n\n             Does a s/$arg1/$arg2/ on the sequences. Useful for gap\n             characters\n\n             Notice that the from (arg1) is interpreted as a regex,\n             so be careful about quoting meta characters (eg\n             $ali->map_chars('.','-') wont do what you want)\n\n Returns   : None\n Argument  : 'from' rexexp\n             'to' string\n\n\nsub map_chars {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 uppercase\n\n Title     : uppercase()\n Usage     : $ali->uppercase()\n Function  : Sets all the sequences to uppercase\n Returns   : \n Argument  : \n\n\nsub uppercase {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_line\n\n Title    : match_line()\n Usage    : $align->match_line()\n Function : Generates a match line - much like consensus string\n            except that a line indicating the '*' for a match.\n Argument : (optional) Match line characters ('*' by default)\n            (optional) Strong match char (':' by default)\n            (optional) Weak match char ('.' by default)\n\n\nsub match_line {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match\n\n Title     : match()\n Usage     : $ali->match()\n Function  : \n\n             Goes through all columns and changes residues that are\n             identical to residue in first sequence to match '.'\n             character. Sets match_char.\n\n             USE WITH CARE: Most MSE formats do not support match\n             characters in sequences, so this is mostly for output\n             only. NEXUS format (Bio::AlignIO::nexus) can handle\n             it.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub match {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 unmatch\n\n Title     : unmatch()\n Usage     : $ali->unmatch()\n Function  : \n\n             Undoes the effect of method match. Unsets match_char.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub unmatch {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head1 MSE attibutes\n\nMethods for setting and reading the MSE attributes. \n\nNote that the methods defining character semantics depend on the user\nto set them sensibly.  They are needed only by certain input/output\nmethods. Unset them by setting to an empty string ('').\n\n=head2 id\n\n Title     : id\n Usage     : $myalign->id(\"Ig\")\n Function  : Gets/sets the id field of the alignment\n Returns   : An id string\n Argument  : An id string (optional)\n\n\nsub id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 missing_char\n\n Title     : missing_char\n Usage     : $myalign->missing_char(\"?\")\n Function  : Gets/sets the missing_char attribute of the alignment\n             It is generally recommended to set it to 'n' or 'N' \n             for nucleotides and to 'X' for protein. \n Returns   : An missing_char string,\n Argument  : An missing_char string (optional)\n\n\nsub missing_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_char\n\n Title     : match_char\n Usage     : $myalign->match_char('.')\n Function  : Gets/sets the match_char attribute of the alignment\n Returns   : An match_char string,\n Argument  : An match_char string (optional)","parameters":[{"label":"$self"}]}},{"range":{"start":{"line":502,"character":0},"end":{"character":9999,"line":505}},"kind":12,"line":502,"signature":{"documentation":"1;\n# $Id: AlignI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::AlignI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::AlignI - An interface for describing sequence alignments.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Align::AlignI somehow - typically using Bio::AlignIO system\n  # some descriptors\n  print $aln->length, \"\\n\";\n  print $aln->num_residues, \"\\n\";\n  print $aln->is_flush, \"\\n\";\n  print $aln->num_sequences, \"\\n\";\n  print $aln->percentage_identity, \"\\n\";\n  print $aln->consensus_string(50), \"\\n\";\n\n  # find the position in the alignment for a sequence location\n  $pos = $aln->column_from_residue_number('1433_LYCES', 14); # = 6;\n\n  # extract sequences and check values for the alignment column $pos\n  foreach $seq ($aln->each_seq) {\n      $res = $seq->subseq($pos, $pos);\n      $count{$res}++;\n  }\n  foreach $res (keys %count) {\n      printf \"Res: %s  Count: %2d\\n\", $res, $count{$res};\n  }\n\n=head1 DESCRIPTION\n\nThis interface describes the basis for alignment objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::AlignI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $myalign->add_seq($newseq);\n Function  : Adds another sequence to the alignment. *Does not* align\n             it - just adds it to the hashes.\n Returns   : None\n Argument  : a Bio::LocatableSeq object\n             order (optional)\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $aln->remove_seq($seq);\n Function  : Removes a single sequence from an alignment\n Returns   :\n Argument  : a Bio::LocatableSeq object\n\n\nsub remove_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 purge\n\n Title   : purge\n Usage   : $aln->purge(0.7);\n Function:\n\n           Removes sequences above whatever %id.\n\n           This function will grind on large alignments. Beware!\n           (perhaps not ideally implemented)\n\n Example :\n Returns : An array of the removed sequences\n Argument:\n\n\n\nsub purge {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 sort_alphabetically\n\n Title     : sort_alphabetically\n Usage     : $ali->sort_alphabetically\n Function  : \n\n             Changes the order of the alignment to alphabetical on name \n             followed by numerical by number.\n\n Returns   : an array\n Argument  : \n\n\nsub sort_alphabetically {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Sequence selection methods\n\nMethods returning one or more sequences objects.\n\n=head2 each_seq\n\n Title     : each_seq\n Usage     : foreach $seq ( $align->each_seq() ) \n Function  : Gets an array of Seq objects from the alignment\n Returns   : an array\n Argument  : \n\n\nsub each_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_alphabetically\n\n Title     : each_alphabetically\n Usage     : foreach $seq ( $ali->each_alphabetically() )\n Function  :\n\n             Returns an array of sequence object sorted alphabetically \n             by name and then by start point.\n             Does not change the order of the alignment\n\n Returns   : \n Argument  : \n\n\nsub each_alphabetically {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_seq_with_id\n\n Title     : each_seq_with_id\n Usage     : foreach $seq ( $align->each_seq_with_id() ) \n Function  : \n\n             Gets an array of Seq objects from the\n             alignment, the contents being those sequences\n             with the given name (there may be more than one)\n\n Returns   : an array\n Argument  : a seq name\n\n\nsub each_seq_with_id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 get_seq_by_pos\n\n Title     : get_seq_by_pos\n Usage     : $seq = $aln->get_seq_by_pos(3) # third sequence from the alignment\n Function  : \n\n             Gets a sequence based on its position in the alignment.\n             Numbering starts from 1.  Sequence positions larger than\n             num_sequences() will throw an error.\n\n Returns   : a Bio::LocatableSeq object\n Argument  : positive integer for the sequence position\n\n\nsub get_seq_by_pos {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Create new alignments\n\nThe result of these methods are horizontal or vertical subsets of the\ncurrent MSE.\n\n=head2 select\n\n Title     : select\n Usage     : $aln2 = $aln->select(1, 3) # three first sequences\n Function  : \n\n             Creates a new alignment from a continuous subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for the first sequence\n             positive integer for the last sequence to include (optional)\n\n\nsub select {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 select_noncont\n\n Title     : select_noncont\n Usage     : $aln2 = $aln->select_noncont(1, 3) # first and 3rd sequences\n Function  : \n\n             Creates a new alignment from a subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Args      : array of integers for the sequences\n\n\nsub select_noncont {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 slice\n\n Title     : slice\n Usage     : $aln2 = $aln->slice(20, 30)\n Function  : \n\n             Creates a slice from the alignment inclusive of start and\n             end columns.  Sequences with no residues in the slice are\n             excluded from the new alignment and a warning is printed.\n             Slice beyond the length of the sequence does not do\n             padding.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for start column \n             positive integer for end column \n\n\nsub slice {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Change sequences within the MSE\n\nThese methods affect characters in all sequences without changing the\nalignment.\n\n\n=head2 map_chars\n\n Title     : map_chars\n Usage     : $ali->map_chars('\\.','-')\n Function  : \n\n             Does a s/$arg1/$arg2/ on the sequences. Useful for gap\n             characters\n\n             Notice that the from (arg1) is interpreted as a regex,\n             so be careful about quoting meta characters (eg\n             $ali->map_chars('.','-') wont do what you want)\n\n Returns   : None\n Argument  : 'from' rexexp\n             'to' string\n\n\nsub map_chars {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 uppercase\n\n Title     : uppercase()\n Usage     : $ali->uppercase()\n Function  : Sets all the sequences to uppercase\n Returns   : \n Argument  : \n\n\nsub uppercase {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_line\n\n Title    : match_line()\n Usage    : $align->match_line()\n Function : Generates a match line - much like consensus string\n            except that a line indicating the '*' for a match.\n Argument : (optional) Match line characters ('*' by default)\n            (optional) Strong match char (':' by default)\n            (optional) Weak match char ('.' by default)\n\n\nsub match_line {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match\n\n Title     : match()\n Usage     : $ali->match()\n Function  : \n\n             Goes through all columns and changes residues that are\n             identical to residue in first sequence to match '.'\n             character. Sets match_char.\n\n             USE WITH CARE: Most MSE formats do not support match\n             characters in sequences, so this is mostly for output\n             only. NEXUS format (Bio::AlignIO::nexus) can handle\n             it.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub match {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 unmatch\n\n Title     : unmatch()\n Usage     : $ali->unmatch()\n Function  : \n\n             Undoes the effect of method match. Unsets match_char.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub unmatch {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head1 MSE attibutes\n\nMethods for setting and reading the MSE attributes. \n\nNote that the methods defining character semantics depend on the user\nto set them sensibly.  They are needed only by certain input/output\nmethods. Unset them by setting to an empty string ('').\n\n=head2 id\n\n Title     : id\n Usage     : $myalign->id(\"Ig\")\n Function  : Gets/sets the id field of the alignment\n Returns   : An id string\n Argument  : An id string (optional)\n\n\nsub id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 missing_char\n\n Title     : missing_char\n Usage     : $myalign->missing_char(\"?\")\n Function  : Gets/sets the missing_char attribute of the alignment\n             It is generally recommended to set it to 'n' or 'N' \n             for nucleotides and to 'X' for protein. \n Returns   : An missing_char string,\n Argument  : An missing_char string (optional)\n\n\nsub missing_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_char\n\n Title     : match_char\n Usage     : $myalign->match_char('.')\n Function  : Gets/sets the match_char attribute of the alignment\n Returns   : An match_char string,\n Argument  : An match_char string (optional)\n\n\nsub match_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 gap_char\n\n Title     : gap_char\n Usage     : $myalign->gap_char('-')\n Function  : Gets/sets the gap_char attribute of the alignment\n Returns   : An gap_char string, defaults to '-'\n Argument  : An gap_char string (optional)","parameters":[{"label":"$self"}],"label":"gap_char($self)"},"containerName":"main::","name":"gap_char","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"gap_char","line":503},{"name":"$self","kind":13,"containerName":"gap_char","line":504},{"line":504,"kind":12,"containerName":"gap_char","name":"throw_not_implemented"}],"detail":"($self)","definition":"sub"},{"signature":{"label":"symbol_chars($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: AlignI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::AlignI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::AlignI - An interface for describing sequence alignments.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Align::AlignI somehow - typically using Bio::AlignIO system\n  # some descriptors\n  print $aln->length, \"\\n\";\n  print $aln->num_residues, \"\\n\";\n  print $aln->is_flush, \"\\n\";\n  print $aln->num_sequences, \"\\n\";\n  print $aln->percentage_identity, \"\\n\";\n  print $aln->consensus_string(50), \"\\n\";\n\n  # find the position in the alignment for a sequence location\n  $pos = $aln->column_from_residue_number('1433_LYCES', 14); # = 6;\n\n  # extract sequences and check values for the alignment column $pos\n  foreach $seq ($aln->each_seq) {\n      $res = $seq->subseq($pos, $pos);\n      $count{$res}++;\n  }\n  foreach $res (keys %count) {\n      printf \"Res: %s  Count: %2d\\n\", $res, $count{$res};\n  }\n\n=head1 DESCRIPTION\n\nThis interface describes the basis for alignment objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::AlignI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $myalign->add_seq($newseq);\n Function  : Adds another sequence to the alignment. *Does not* align\n             it - just adds it to the hashes.\n Returns   : None\n Argument  : a Bio::LocatableSeq object\n             order (optional)\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $aln->remove_seq($seq);\n Function  : Removes a single sequence from an alignment\n Returns   :\n Argument  : a Bio::LocatableSeq object\n\n\nsub remove_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 purge\n\n Title   : purge\n Usage   : $aln->purge(0.7);\n Function:\n\n           Removes sequences above whatever %id.\n\n           This function will grind on large alignments. Beware!\n           (perhaps not ideally implemented)\n\n Example :\n Returns : An array of the removed sequences\n Argument:\n\n\n\nsub purge {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 sort_alphabetically\n\n Title     : sort_alphabetically\n Usage     : $ali->sort_alphabetically\n Function  : \n\n             Changes the order of the alignment to alphabetical on name \n             followed by numerical by number.\n\n Returns   : an array\n Argument  : \n\n\nsub sort_alphabetically {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Sequence selection methods\n\nMethods returning one or more sequences objects.\n\n=head2 each_seq\n\n Title     : each_seq\n Usage     : foreach $seq ( $align->each_seq() ) \n Function  : Gets an array of Seq objects from the alignment\n Returns   : an array\n Argument  : \n\n\nsub each_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_alphabetically\n\n Title     : each_alphabetically\n Usage     : foreach $seq ( $ali->each_alphabetically() )\n Function  :\n\n             Returns an array of sequence object sorted alphabetically \n             by name and then by start point.\n             Does not change the order of the alignment\n\n Returns   : \n Argument  : \n\n\nsub each_alphabetically {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_seq_with_id\n\n Title     : each_seq_with_id\n Usage     : foreach $seq ( $align->each_seq_with_id() ) \n Function  : \n\n             Gets an array of Seq objects from the\n             alignment, the contents being those sequences\n             with the given name (there may be more than one)\n\n Returns   : an array\n Argument  : a seq name\n\n\nsub each_seq_with_id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 get_seq_by_pos\n\n Title     : get_seq_by_pos\n Usage     : $seq = $aln->get_seq_by_pos(3) # third sequence from the alignment\n Function  : \n\n             Gets a sequence based on its position in the alignment.\n             Numbering starts from 1.  Sequence positions larger than\n             num_sequences() will throw an error.\n\n Returns   : a Bio::LocatableSeq object\n Argument  : positive integer for the sequence position\n\n\nsub get_seq_by_pos {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Create new alignments\n\nThe result of these methods are horizontal or vertical subsets of the\ncurrent MSE.\n\n=head2 select\n\n Title     : select\n Usage     : $aln2 = $aln->select(1, 3) # three first sequences\n Function  : \n\n             Creates a new alignment from a continuous subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for the first sequence\n             positive integer for the last sequence to include (optional)\n\n\nsub select {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 select_noncont\n\n Title     : select_noncont\n Usage     : $aln2 = $aln->select_noncont(1, 3) # first and 3rd sequences\n Function  : \n\n             Creates a new alignment from a subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Args      : array of integers for the sequences\n\n\nsub select_noncont {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 slice\n\n Title     : slice\n Usage     : $aln2 = $aln->slice(20, 30)\n Function  : \n\n             Creates a slice from the alignment inclusive of start and\n             end columns.  Sequences with no residues in the slice are\n             excluded from the new alignment and a warning is printed.\n             Slice beyond the length of the sequence does not do\n             padding.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for start column \n             positive integer for end column \n\n\nsub slice {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Change sequences within the MSE\n\nThese methods affect characters in all sequences without changing the\nalignment.\n\n\n=head2 map_chars\n\n Title     : map_chars\n Usage     : $ali->map_chars('\\.','-')\n Function  : \n\n             Does a s/$arg1/$arg2/ on the sequences. Useful for gap\n             characters\n\n             Notice that the from (arg1) is interpreted as a regex,\n             so be careful about quoting meta characters (eg\n             $ali->map_chars('.','-') wont do what you want)\n\n Returns   : None\n Argument  : 'from' rexexp\n             'to' string\n\n\nsub map_chars {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 uppercase\n\n Title     : uppercase()\n Usage     : $ali->uppercase()\n Function  : Sets all the sequences to uppercase\n Returns   : \n Argument  : \n\n\nsub uppercase {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_line\n\n Title    : match_line()\n Usage    : $align->match_line()\n Function : Generates a match line - much like consensus string\n            except that a line indicating the '*' for a match.\n Argument : (optional) Match line characters ('*' by default)\n            (optional) Strong match char (':' by default)\n            (optional) Weak match char ('.' by default)\n\n\nsub match_line {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match\n\n Title     : match()\n Usage     : $ali->match()\n Function  : \n\n             Goes through all columns and changes residues that are\n             identical to residue in first sequence to match '.'\n             character. Sets match_char.\n\n             USE WITH CARE: Most MSE formats do not support match\n             characters in sequences, so this is mostly for output\n             only. NEXUS format (Bio::AlignIO::nexus) can handle\n             it.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub match {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 unmatch\n\n Title     : unmatch()\n Usage     : $ali->unmatch()\n Function  : \n\n             Undoes the effect of method match. Unsets match_char.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub unmatch {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head1 MSE attibutes\n\nMethods for setting and reading the MSE attributes. \n\nNote that the methods defining character semantics depend on the user\nto set them sensibly.  They are needed only by certain input/output\nmethods. Unset them by setting to an empty string ('').\n\n=head2 id\n\n Title     : id\n Usage     : $myalign->id(\"Ig\")\n Function  : Gets/sets the id field of the alignment\n Returns   : An id string\n Argument  : An id string (optional)\n\n\nsub id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 missing_char\n\n Title     : missing_char\n Usage     : $myalign->missing_char(\"?\")\n Function  : Gets/sets the missing_char attribute of the alignment\n             It is generally recommended to set it to 'n' or 'N' \n             for nucleotides and to 'X' for protein. \n Returns   : An missing_char string,\n Argument  : An missing_char string (optional)\n\n\nsub missing_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_char\n\n Title     : match_char\n Usage     : $myalign->match_char('.')\n Function  : Gets/sets the match_char attribute of the alignment\n Returns   : An match_char string,\n Argument  : An match_char string (optional)\n\n\nsub match_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 gap_char\n\n Title     : gap_char\n Usage     : $myalign->gap_char('-')\n Function  : Gets/sets the gap_char attribute of the alignment\n Returns   : An gap_char string, defaults to '-'\n Argument  : An gap_char string (optional)\n\n\nsub gap_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 symbol_chars\n\n Title   : symbol_chars\n Usage   : my @symbolchars = $aln->symbol_chars;\n Function: Returns all the seen symbols (other than gaps)\n Returns : array of characters that are the seen symbols\n Argument: boolean to include the gap/missing/match characters"},"line":517,"range":{"start":{"character":0,"line":517},"end":{"character":9999,"line":520}},"kind":12,"definition":"sub","detail":"($self)","children":[{"line":518,"containerName":"symbol_chars","localvar":"my","kind":13,"name":"$self","definition":"my"},{"name":"$self","kind":13,"containerName":"symbol_chars","line":519},{"containerName":"symbol_chars","kind":12,"name":"throw_not_implemented","line":519}],"name":"symbol_chars","containerName":"main::"},{"definition":"sub","detail":"($self)","children":[{"definition":"my","name":"$self","containerName":"consensus_string","localvar":"my","kind":13,"line":542},{"line":543,"kind":13,"containerName":"consensus_string","name":"$self"},{"kind":12,"containerName":"consensus_string","name":"throw_not_implemented","line":543}],"name":"consensus_string","containerName":"main::","signature":{"label":"consensus_string($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: AlignI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::AlignI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::AlignI - An interface for describing sequence alignments.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Align::AlignI somehow - typically using Bio::AlignIO system\n  # some descriptors\n  print $aln->length, \"\\n\";\n  print $aln->num_residues, \"\\n\";\n  print $aln->is_flush, \"\\n\";\n  print $aln->num_sequences, \"\\n\";\n  print $aln->percentage_identity, \"\\n\";\n  print $aln->consensus_string(50), \"\\n\";\n\n  # find the position in the alignment for a sequence location\n  $pos = $aln->column_from_residue_number('1433_LYCES', 14); # = 6;\n\n  # extract sequences and check values for the alignment column $pos\n  foreach $seq ($aln->each_seq) {\n      $res = $seq->subseq($pos, $pos);\n      $count{$res}++;\n  }\n  foreach $res (keys %count) {\n      printf \"Res: %s  Count: %2d\\n\", $res, $count{$res};\n  }\n\n=head1 DESCRIPTION\n\nThis interface describes the basis for alignment objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::AlignI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $myalign->add_seq($newseq);\n Function  : Adds another sequence to the alignment. *Does not* align\n             it - just adds it to the hashes.\n Returns   : None\n Argument  : a Bio::LocatableSeq object\n             order (optional)\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $aln->remove_seq($seq);\n Function  : Removes a single sequence from an alignment\n Returns   :\n Argument  : a Bio::LocatableSeq object\n\n\nsub remove_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 purge\n\n Title   : purge\n Usage   : $aln->purge(0.7);\n Function:\n\n           Removes sequences above whatever %id.\n\n           This function will grind on large alignments. Beware!\n           (perhaps not ideally implemented)\n\n Example :\n Returns : An array of the removed sequences\n Argument:\n\n\n\nsub purge {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 sort_alphabetically\n\n Title     : sort_alphabetically\n Usage     : $ali->sort_alphabetically\n Function  : \n\n             Changes the order of the alignment to alphabetical on name \n             followed by numerical by number.\n\n Returns   : an array\n Argument  : \n\n\nsub sort_alphabetically {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Sequence selection methods\n\nMethods returning one or more sequences objects.\n\n=head2 each_seq\n\n Title     : each_seq\n Usage     : foreach $seq ( $align->each_seq() ) \n Function  : Gets an array of Seq objects from the alignment\n Returns   : an array\n Argument  : \n\n\nsub each_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_alphabetically\n\n Title     : each_alphabetically\n Usage     : foreach $seq ( $ali->each_alphabetically() )\n Function  :\n\n             Returns an array of sequence object sorted alphabetically \n             by name and then by start point.\n             Does not change the order of the alignment\n\n Returns   : \n Argument  : \n\n\nsub each_alphabetically {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_seq_with_id\n\n Title     : each_seq_with_id\n Usage     : foreach $seq ( $align->each_seq_with_id() ) \n Function  : \n\n             Gets an array of Seq objects from the\n             alignment, the contents being those sequences\n             with the given name (there may be more than one)\n\n Returns   : an array\n Argument  : a seq name\n\n\nsub each_seq_with_id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 get_seq_by_pos\n\n Title     : get_seq_by_pos\n Usage     : $seq = $aln->get_seq_by_pos(3) # third sequence from the alignment\n Function  : \n\n             Gets a sequence based on its position in the alignment.\n             Numbering starts from 1.  Sequence positions larger than\n             num_sequences() will throw an error.\n\n Returns   : a Bio::LocatableSeq object\n Argument  : positive integer for the sequence position\n\n\nsub get_seq_by_pos {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Create new alignments\n\nThe result of these methods are horizontal or vertical subsets of the\ncurrent MSE.\n\n=head2 select\n\n Title     : select\n Usage     : $aln2 = $aln->select(1, 3) # three first sequences\n Function  : \n\n             Creates a new alignment from a continuous subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for the first sequence\n             positive integer for the last sequence to include (optional)\n\n\nsub select {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 select_noncont\n\n Title     : select_noncont\n Usage     : $aln2 = $aln->select_noncont(1, 3) # first and 3rd sequences\n Function  : \n\n             Creates a new alignment from a subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Args      : array of integers for the sequences\n\n\nsub select_noncont {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 slice\n\n Title     : slice\n Usage     : $aln2 = $aln->slice(20, 30)\n Function  : \n\n             Creates a slice from the alignment inclusive of start and\n             end columns.  Sequences with no residues in the slice are\n             excluded from the new alignment and a warning is printed.\n             Slice beyond the length of the sequence does not do\n             padding.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for start column \n             positive integer for end column \n\n\nsub slice {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Change sequences within the MSE\n\nThese methods affect characters in all sequences without changing the\nalignment.\n\n\n=head2 map_chars\n\n Title     : map_chars\n Usage     : $ali->map_chars('\\.','-')\n Function  : \n\n             Does a s/$arg1/$arg2/ on the sequences. Useful for gap\n             characters\n\n             Notice that the from (arg1) is interpreted as a regex,\n             so be careful about quoting meta characters (eg\n             $ali->map_chars('.','-') wont do what you want)\n\n Returns   : None\n Argument  : 'from' rexexp\n             'to' string\n\n\nsub map_chars {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 uppercase\n\n Title     : uppercase()\n Usage     : $ali->uppercase()\n Function  : Sets all the sequences to uppercase\n Returns   : \n Argument  : \n\n\nsub uppercase {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_line\n\n Title    : match_line()\n Usage    : $align->match_line()\n Function : Generates a match line - much like consensus string\n            except that a line indicating the '*' for a match.\n Argument : (optional) Match line characters ('*' by default)\n            (optional) Strong match char (':' by default)\n            (optional) Weak match char ('.' by default)\n\n\nsub match_line {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match\n\n Title     : match()\n Usage     : $ali->match()\n Function  : \n\n             Goes through all columns and changes residues that are\n             identical to residue in first sequence to match '.'\n             character. Sets match_char.\n\n             USE WITH CARE: Most MSE formats do not support match\n             characters in sequences, so this is mostly for output\n             only. NEXUS format (Bio::AlignIO::nexus) can handle\n             it.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub match {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 unmatch\n\n Title     : unmatch()\n Usage     : $ali->unmatch()\n Function  : \n\n             Undoes the effect of method match. Unsets match_char.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub unmatch {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head1 MSE attibutes\n\nMethods for setting and reading the MSE attributes. \n\nNote that the methods defining character semantics depend on the user\nto set them sensibly.  They are needed only by certain input/output\nmethods. Unset them by setting to an empty string ('').\n\n=head2 id\n\n Title     : id\n Usage     : $myalign->id(\"Ig\")\n Function  : Gets/sets the id field of the alignment\n Returns   : An id string\n Argument  : An id string (optional)\n\n\nsub id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 missing_char\n\n Title     : missing_char\n Usage     : $myalign->missing_char(\"?\")\n Function  : Gets/sets the missing_char attribute of the alignment\n             It is generally recommended to set it to 'n' or 'N' \n             for nucleotides and to 'X' for protein. \n Returns   : An missing_char string,\n Argument  : An missing_char string (optional)\n\n\nsub missing_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_char\n\n Title     : match_char\n Usage     : $myalign->match_char('.')\n Function  : Gets/sets the match_char attribute of the alignment\n Returns   : An match_char string,\n Argument  : An match_char string (optional)\n\n\nsub match_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 gap_char\n\n Title     : gap_char\n Usage     : $myalign->gap_char('-')\n Function  : Gets/sets the gap_char attribute of the alignment\n Returns   : An gap_char string, defaults to '-'\n Argument  : An gap_char string (optional)\n\n\nsub gap_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 symbol_chars\n\n Title   : symbol_chars\n Usage   : my @symbolchars = $aln->symbol_chars;\n Function: Returns all the seen symbols (other than gaps)\n Returns : array of characters that are the seen symbols\n Argument: boolean to include the gap/missing/match characters\n\n\nsub symbol_chars{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Alignment descriptors\n\nThese read only methods describe the MSE in various ways. \n\n\n=head2 consensus_string\n\n Title     : consensus_string\n Usage     : $str = $ali->consensus_string($threshold_percent)\n Function  : Makes a strict consensus \n Returns   : consensus string\n Argument  : Optional threshold ranging from 0 to 100.\n             The consensus residue has to appear at least threshold %\n             of the sequences at a given location, otherwise a '?'\n             character will be placed at that location.\n             (Default value = 0%)"},"line":541,"range":{"start":{"line":541,"character":0},"end":{"line":544,"character":9999}},"kind":12},{"definition":"sub","detail":"($self)","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"consensus_iupac","line":569},{"line":570,"name":"$self","kind":13,"containerName":"consensus_iupac"},{"name":"throw_not_implemented","containerName":"consensus_iupac","kind":12,"line":570}],"name":"consensus_iupac","containerName":"main::","signature":{"label":"consensus_iupac($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: AlignI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::AlignI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::AlignI - An interface for describing sequence alignments.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Align::AlignI somehow - typically using Bio::AlignIO system\n  # some descriptors\n  print $aln->length, \"\\n\";\n  print $aln->num_residues, \"\\n\";\n  print $aln->is_flush, \"\\n\";\n  print $aln->num_sequences, \"\\n\";\n  print $aln->percentage_identity, \"\\n\";\n  print $aln->consensus_string(50), \"\\n\";\n\n  # find the position in the alignment for a sequence location\n  $pos = $aln->column_from_residue_number('1433_LYCES', 14); # = 6;\n\n  # extract sequences and check values for the alignment column $pos\n  foreach $seq ($aln->each_seq) {\n      $res = $seq->subseq($pos, $pos);\n      $count{$res}++;\n  }\n  foreach $res (keys %count) {\n      printf \"Res: %s  Count: %2d\\n\", $res, $count{$res};\n  }\n\n=head1 DESCRIPTION\n\nThis interface describes the basis for alignment objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::AlignI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $myalign->add_seq($newseq);\n Function  : Adds another sequence to the alignment. *Does not* align\n             it - just adds it to the hashes.\n Returns   : None\n Argument  : a Bio::LocatableSeq object\n             order (optional)\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $aln->remove_seq($seq);\n Function  : Removes a single sequence from an alignment\n Returns   :\n Argument  : a Bio::LocatableSeq object\n\n\nsub remove_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 purge\n\n Title   : purge\n Usage   : $aln->purge(0.7);\n Function:\n\n           Removes sequences above whatever %id.\n\n           This function will grind on large alignments. Beware!\n           (perhaps not ideally implemented)\n\n Example :\n Returns : An array of the removed sequences\n Argument:\n\n\n\nsub purge {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 sort_alphabetically\n\n Title     : sort_alphabetically\n Usage     : $ali->sort_alphabetically\n Function  : \n\n             Changes the order of the alignment to alphabetical on name \n             followed by numerical by number.\n\n Returns   : an array\n Argument  : \n\n\nsub sort_alphabetically {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Sequence selection methods\n\nMethods returning one or more sequences objects.\n\n=head2 each_seq\n\n Title     : each_seq\n Usage     : foreach $seq ( $align->each_seq() ) \n Function  : Gets an array of Seq objects from the alignment\n Returns   : an array\n Argument  : \n\n\nsub each_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_alphabetically\n\n Title     : each_alphabetically\n Usage     : foreach $seq ( $ali->each_alphabetically() )\n Function  :\n\n             Returns an array of sequence object sorted alphabetically \n             by name and then by start point.\n             Does not change the order of the alignment\n\n Returns   : \n Argument  : \n\n\nsub each_alphabetically {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_seq_with_id\n\n Title     : each_seq_with_id\n Usage     : foreach $seq ( $align->each_seq_with_id() ) \n Function  : \n\n             Gets an array of Seq objects from the\n             alignment, the contents being those sequences\n             with the given name (there may be more than one)\n\n Returns   : an array\n Argument  : a seq name\n\n\nsub each_seq_with_id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 get_seq_by_pos\n\n Title     : get_seq_by_pos\n Usage     : $seq = $aln->get_seq_by_pos(3) # third sequence from the alignment\n Function  : \n\n             Gets a sequence based on its position in the alignment.\n             Numbering starts from 1.  Sequence positions larger than\n             num_sequences() will throw an error.\n\n Returns   : a Bio::LocatableSeq object\n Argument  : positive integer for the sequence position\n\n\nsub get_seq_by_pos {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Create new alignments\n\nThe result of these methods are horizontal or vertical subsets of the\ncurrent MSE.\n\n=head2 select\n\n Title     : select\n Usage     : $aln2 = $aln->select(1, 3) # three first sequences\n Function  : \n\n             Creates a new alignment from a continuous subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for the first sequence\n             positive integer for the last sequence to include (optional)\n\n\nsub select {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 select_noncont\n\n Title     : select_noncont\n Usage     : $aln2 = $aln->select_noncont(1, 3) # first and 3rd sequences\n Function  : \n\n             Creates a new alignment from a subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Args      : array of integers for the sequences\n\n\nsub select_noncont {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 slice\n\n Title     : slice\n Usage     : $aln2 = $aln->slice(20, 30)\n Function  : \n\n             Creates a slice from the alignment inclusive of start and\n             end columns.  Sequences with no residues in the slice are\n             excluded from the new alignment and a warning is printed.\n             Slice beyond the length of the sequence does not do\n             padding.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for start column \n             positive integer for end column \n\n\nsub slice {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Change sequences within the MSE\n\nThese methods affect characters in all sequences without changing the\nalignment.\n\n\n=head2 map_chars\n\n Title     : map_chars\n Usage     : $ali->map_chars('\\.','-')\n Function  : \n\n             Does a s/$arg1/$arg2/ on the sequences. Useful for gap\n             characters\n\n             Notice that the from (arg1) is interpreted as a regex,\n             so be careful about quoting meta characters (eg\n             $ali->map_chars('.','-') wont do what you want)\n\n Returns   : None\n Argument  : 'from' rexexp\n             'to' string\n\n\nsub map_chars {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 uppercase\n\n Title     : uppercase()\n Usage     : $ali->uppercase()\n Function  : Sets all the sequences to uppercase\n Returns   : \n Argument  : \n\n\nsub uppercase {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_line\n\n Title    : match_line()\n Usage    : $align->match_line()\n Function : Generates a match line - much like consensus string\n            except that a line indicating the '*' for a match.\n Argument : (optional) Match line characters ('*' by default)\n            (optional) Strong match char (':' by default)\n            (optional) Weak match char ('.' by default)\n\n\nsub match_line {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match\n\n Title     : match()\n Usage     : $ali->match()\n Function  : \n\n             Goes through all columns and changes residues that are\n             identical to residue in first sequence to match '.'\n             character. Sets match_char.\n\n             USE WITH CARE: Most MSE formats do not support match\n             characters in sequences, so this is mostly for output\n             only. NEXUS format (Bio::AlignIO::nexus) can handle\n             it.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub match {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 unmatch\n\n Title     : unmatch()\n Usage     : $ali->unmatch()\n Function  : \n\n             Undoes the effect of method match. Unsets match_char.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub unmatch {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head1 MSE attibutes\n\nMethods for setting and reading the MSE attributes. \n\nNote that the methods defining character semantics depend on the user\nto set them sensibly.  They are needed only by certain input/output\nmethods. Unset them by setting to an empty string ('').\n\n=head2 id\n\n Title     : id\n Usage     : $myalign->id(\"Ig\")\n Function  : Gets/sets the id field of the alignment\n Returns   : An id string\n Argument  : An id string (optional)\n\n\nsub id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 missing_char\n\n Title     : missing_char\n Usage     : $myalign->missing_char(\"?\")\n Function  : Gets/sets the missing_char attribute of the alignment\n             It is generally recommended to set it to 'n' or 'N' \n             for nucleotides and to 'X' for protein. \n Returns   : An missing_char string,\n Argument  : An missing_char string (optional)\n\n\nsub missing_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_char\n\n Title     : match_char\n Usage     : $myalign->match_char('.')\n Function  : Gets/sets the match_char attribute of the alignment\n Returns   : An match_char string,\n Argument  : An match_char string (optional)\n\n\nsub match_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 gap_char\n\n Title     : gap_char\n Usage     : $myalign->gap_char('-')\n Function  : Gets/sets the gap_char attribute of the alignment\n Returns   : An gap_char string, defaults to '-'\n Argument  : An gap_char string (optional)\n\n\nsub gap_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 symbol_chars\n\n Title   : symbol_chars\n Usage   : my @symbolchars = $aln->symbol_chars;\n Function: Returns all the seen symbols (other than gaps)\n Returns : array of characters that are the seen symbols\n Argument: boolean to include the gap/missing/match characters\n\n\nsub symbol_chars{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Alignment descriptors\n\nThese read only methods describe the MSE in various ways. \n\n\n=head2 consensus_string\n\n Title     : consensus_string\n Usage     : $str = $ali->consensus_string($threshold_percent)\n Function  : Makes a strict consensus \n Returns   : consensus string\n Argument  : Optional threshold ranging from 0 to 100.\n             The consensus residue has to appear at least threshold %\n             of the sequences at a given location, otherwise a '?'\n             character will be placed at that location.\n             (Default value = 0%)\n\n\nsub consensus_string {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 consensus_iupac\n\n Title     : consensus_iupac\n Usage     : $str = $ali->consensus_iupac()\n Function  : \n\n             Makes a consensus using IUPAC ambiguity codes from DNA\n             and RNA. The output is in upper case except when gaps in\n             a column force output to be in lower case.\n\n             Note that if your alignment sequences contain a lot of\n             IUPAC ambiquity codes you often have to manually set\n             alphabet.  Bio::PrimarySeq::_guess_type thinks they\n             indicate a protein sequence.\n\n Returns   : consensus string\n Argument  : none\n Throws    : on protein sequences"},"line":568,"range":{"start":{"character":0,"line":568},"end":{"character":9999,"line":571}},"kind":12},{"definition":"sub","detail":"($self)","children":[{"line":589,"localvar":"my","kind":13,"containerName":"is_flush","name":"$self","definition":"my"},{"line":590,"containerName":"is_flush","kind":13,"name":"$self"},{"line":590,"containerName":"is_flush","kind":12,"name":"throw_not_implemented"}],"name":"is_flush","containerName":"main::","signature":{"documentation":"1;\n# $Id: AlignI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::AlignI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::AlignI - An interface for describing sequence alignments.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Align::AlignI somehow - typically using Bio::AlignIO system\n  # some descriptors\n  print $aln->length, \"\\n\";\n  print $aln->num_residues, \"\\n\";\n  print $aln->is_flush, \"\\n\";\n  print $aln->num_sequences, \"\\n\";\n  print $aln->percentage_identity, \"\\n\";\n  print $aln->consensus_string(50), \"\\n\";\n\n  # find the position in the alignment for a sequence location\n  $pos = $aln->column_from_residue_number('1433_LYCES', 14); # = 6;\n\n  # extract sequences and check values for the alignment column $pos\n  foreach $seq ($aln->each_seq) {\n      $res = $seq->subseq($pos, $pos);\n      $count{$res}++;\n  }\n  foreach $res (keys %count) {\n      printf \"Res: %s  Count: %2d\\n\", $res, $count{$res};\n  }\n\n=head1 DESCRIPTION\n\nThis interface describes the basis for alignment objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::AlignI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $myalign->add_seq($newseq);\n Function  : Adds another sequence to the alignment. *Does not* align\n             it - just adds it to the hashes.\n Returns   : None\n Argument  : a Bio::LocatableSeq object\n             order (optional)\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $aln->remove_seq($seq);\n Function  : Removes a single sequence from an alignment\n Returns   :\n Argument  : a Bio::LocatableSeq object\n\n\nsub remove_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 purge\n\n Title   : purge\n Usage   : $aln->purge(0.7);\n Function:\n\n           Removes sequences above whatever %id.\n\n           This function will grind on large alignments. Beware!\n           (perhaps not ideally implemented)\n\n Example :\n Returns : An array of the removed sequences\n Argument:\n\n\n\nsub purge {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 sort_alphabetically\n\n Title     : sort_alphabetically\n Usage     : $ali->sort_alphabetically\n Function  : \n\n             Changes the order of the alignment to alphabetical on name \n             followed by numerical by number.\n\n Returns   : an array\n Argument  : \n\n\nsub sort_alphabetically {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Sequence selection methods\n\nMethods returning one or more sequences objects.\n\n=head2 each_seq\n\n Title     : each_seq\n Usage     : foreach $seq ( $align->each_seq() ) \n Function  : Gets an array of Seq objects from the alignment\n Returns   : an array\n Argument  : \n\n\nsub each_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_alphabetically\n\n Title     : each_alphabetically\n Usage     : foreach $seq ( $ali->each_alphabetically() )\n Function  :\n\n             Returns an array of sequence object sorted alphabetically \n             by name and then by start point.\n             Does not change the order of the alignment\n\n Returns   : \n Argument  : \n\n\nsub each_alphabetically {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_seq_with_id\n\n Title     : each_seq_with_id\n Usage     : foreach $seq ( $align->each_seq_with_id() ) \n Function  : \n\n             Gets an array of Seq objects from the\n             alignment, the contents being those sequences\n             with the given name (there may be more than one)\n\n Returns   : an array\n Argument  : a seq name\n\n\nsub each_seq_with_id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 get_seq_by_pos\n\n Title     : get_seq_by_pos\n Usage     : $seq = $aln->get_seq_by_pos(3) # third sequence from the alignment\n Function  : \n\n             Gets a sequence based on its position in the alignment.\n             Numbering starts from 1.  Sequence positions larger than\n             num_sequences() will throw an error.\n\n Returns   : a Bio::LocatableSeq object\n Argument  : positive integer for the sequence position\n\n\nsub get_seq_by_pos {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Create new alignments\n\nThe result of these methods are horizontal or vertical subsets of the\ncurrent MSE.\n\n=head2 select\n\n Title     : select\n Usage     : $aln2 = $aln->select(1, 3) # three first sequences\n Function  : \n\n             Creates a new alignment from a continuous subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for the first sequence\n             positive integer for the last sequence to include (optional)\n\n\nsub select {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 select_noncont\n\n Title     : select_noncont\n Usage     : $aln2 = $aln->select_noncont(1, 3) # first and 3rd sequences\n Function  : \n\n             Creates a new alignment from a subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Args      : array of integers for the sequences\n\n\nsub select_noncont {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 slice\n\n Title     : slice\n Usage     : $aln2 = $aln->slice(20, 30)\n Function  : \n\n             Creates a slice from the alignment inclusive of start and\n             end columns.  Sequences with no residues in the slice are\n             excluded from the new alignment and a warning is printed.\n             Slice beyond the length of the sequence does not do\n             padding.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for start column \n             positive integer for end column \n\n\nsub slice {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Change sequences within the MSE\n\nThese methods affect characters in all sequences without changing the\nalignment.\n\n\n=head2 map_chars\n\n Title     : map_chars\n Usage     : $ali->map_chars('\\.','-')\n Function  : \n\n             Does a s/$arg1/$arg2/ on the sequences. Useful for gap\n             characters\n\n             Notice that the from (arg1) is interpreted as a regex,\n             so be careful about quoting meta characters (eg\n             $ali->map_chars('.','-') wont do what you want)\n\n Returns   : None\n Argument  : 'from' rexexp\n             'to' string\n\n\nsub map_chars {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 uppercase\n\n Title     : uppercase()\n Usage     : $ali->uppercase()\n Function  : Sets all the sequences to uppercase\n Returns   : \n Argument  : \n\n\nsub uppercase {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_line\n\n Title    : match_line()\n Usage    : $align->match_line()\n Function : Generates a match line - much like consensus string\n            except that a line indicating the '*' for a match.\n Argument : (optional) Match line characters ('*' by default)\n            (optional) Strong match char (':' by default)\n            (optional) Weak match char ('.' by default)\n\n\nsub match_line {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match\n\n Title     : match()\n Usage     : $ali->match()\n Function  : \n\n             Goes through all columns and changes residues that are\n             identical to residue in first sequence to match '.'\n             character. Sets match_char.\n\n             USE WITH CARE: Most MSE formats do not support match\n             characters in sequences, so this is mostly for output\n             only. NEXUS format (Bio::AlignIO::nexus) can handle\n             it.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub match {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 unmatch\n\n Title     : unmatch()\n Usage     : $ali->unmatch()\n Function  : \n\n             Undoes the effect of method match. Unsets match_char.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub unmatch {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head1 MSE attibutes\n\nMethods for setting and reading the MSE attributes. \n\nNote that the methods defining character semantics depend on the user\nto set them sensibly.  They are needed only by certain input/output\nmethods. Unset them by setting to an empty string ('').\n\n=head2 id\n\n Title     : id\n Usage     : $myalign->id(\"Ig\")\n Function  : Gets/sets the id field of the alignment\n Returns   : An id string\n Argument  : An id string (optional)\n\n\nsub id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 missing_char\n\n Title     : missing_char\n Usage     : $myalign->missing_char(\"?\")\n Function  : Gets/sets the missing_char attribute of the alignment\n             It is generally recommended to set it to 'n' or 'N' \n             for nucleotides and to 'X' for protein. \n Returns   : An missing_char string,\n Argument  : An missing_char string (optional)\n\n\nsub missing_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_char\n\n Title     : match_char\n Usage     : $myalign->match_char('.')\n Function  : Gets/sets the match_char attribute of the alignment\n Returns   : An match_char string,\n Argument  : An match_char string (optional)\n\n\nsub match_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 gap_char\n\n Title     : gap_char\n Usage     : $myalign->gap_char('-')\n Function  : Gets/sets the gap_char attribute of the alignment\n Returns   : An gap_char string, defaults to '-'\n Argument  : An gap_char string (optional)\n\n\nsub gap_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 symbol_chars\n\n Title   : symbol_chars\n Usage   : my @symbolchars = $aln->symbol_chars;\n Function: Returns all the seen symbols (other than gaps)\n Returns : array of characters that are the seen symbols\n Argument: boolean to include the gap/missing/match characters\n\n\nsub symbol_chars{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Alignment descriptors\n\nThese read only methods describe the MSE in various ways. \n\n\n=head2 consensus_string\n\n Title     : consensus_string\n Usage     : $str = $ali->consensus_string($threshold_percent)\n Function  : Makes a strict consensus \n Returns   : consensus string\n Argument  : Optional threshold ranging from 0 to 100.\n             The consensus residue has to appear at least threshold %\n             of the sequences at a given location, otherwise a '?'\n             character will be placed at that location.\n             (Default value = 0%)\n\n\nsub consensus_string {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 consensus_iupac\n\n Title     : consensus_iupac\n Usage     : $str = $ali->consensus_iupac()\n Function  : \n\n             Makes a consensus using IUPAC ambiguity codes from DNA\n             and RNA. The output is in upper case except when gaps in\n             a column force output to be in lower case.\n\n             Note that if your alignment sequences contain a lot of\n             IUPAC ambiquity codes you often have to manually set\n             alphabet.  Bio::PrimarySeq::_guess_type thinks they\n             indicate a protein sequence.\n\n Returns   : consensus string\n Argument  : none\n Throws    : on protein sequences\n\n\n\nsub consensus_iupac {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 is_flush\n\n Title     : is_flush\n Usage     : if( $ali->is_flush() )\n           : \n           :\n Function  : Tells you whether the alignment \n           : is flush, ie all of the same length\n           : \n           :\n Returns   : 1 or 0\n Argument  : ","parameters":[{"label":"$self"}],"label":"is_flush($self)"},"line":588,"range":{"end":{"line":591,"character":9999},"start":{"line":588,"character":0}},"kind":12},{"children":[{"name":"$self","kind":13,"localvar":"my","containerName":"length","line":605,"definition":"my"},{"name":"$self","kind":13,"containerName":"length","line":606},{"line":606,"kind":12,"containerName":"length","name":"throw_not_implemented"}],"name":"length","containerName":"main::","definition":"sub","detail":"($self)","line":604,"kind":12,"range":{"end":{"character":9999,"line":607},"start":{"line":604,"character":0}},"signature":{"label":"length($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: AlignI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::AlignI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::AlignI - An interface for describing sequence alignments.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Align::AlignI somehow - typically using Bio::AlignIO system\n  # some descriptors\n  print $aln->length, \"\\n\";\n  print $aln->num_residues, \"\\n\";\n  print $aln->is_flush, \"\\n\";\n  print $aln->num_sequences, \"\\n\";\n  print $aln->percentage_identity, \"\\n\";\n  print $aln->consensus_string(50), \"\\n\";\n\n  # find the position in the alignment for a sequence location\n  $pos = $aln->column_from_residue_number('1433_LYCES', 14); # = 6;\n\n  # extract sequences and check values for the alignment column $pos\n  foreach $seq ($aln->each_seq) {\n      $res = $seq->subseq($pos, $pos);\n      $count{$res}++;\n  }\n  foreach $res (keys %count) {\n      printf \"Res: %s  Count: %2d\\n\", $res, $count{$res};\n  }\n\n=head1 DESCRIPTION\n\nThis interface describes the basis for alignment objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::AlignI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $myalign->add_seq($newseq);\n Function  : Adds another sequence to the alignment. *Does not* align\n             it - just adds it to the hashes.\n Returns   : None\n Argument  : a Bio::LocatableSeq object\n             order (optional)\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $aln->remove_seq($seq);\n Function  : Removes a single sequence from an alignment\n Returns   :\n Argument  : a Bio::LocatableSeq object\n\n\nsub remove_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 purge\n\n Title   : purge\n Usage   : $aln->purge(0.7);\n Function:\n\n           Removes sequences above whatever %id.\n\n           This function will grind on large alignments. Beware!\n           (perhaps not ideally implemented)\n\n Example :\n Returns : An array of the removed sequences\n Argument:\n\n\n\nsub purge {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 sort_alphabetically\n\n Title     : sort_alphabetically\n Usage     : $ali->sort_alphabetically\n Function  : \n\n             Changes the order of the alignment to alphabetical on name \n             followed by numerical by number.\n\n Returns   : an array\n Argument  : \n\n\nsub sort_alphabetically {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Sequence selection methods\n\nMethods returning one or more sequences objects.\n\n=head2 each_seq\n\n Title     : each_seq\n Usage     : foreach $seq ( $align->each_seq() ) \n Function  : Gets an array of Seq objects from the alignment\n Returns   : an array\n Argument  : \n\n\nsub each_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_alphabetically\n\n Title     : each_alphabetically\n Usage     : foreach $seq ( $ali->each_alphabetically() )\n Function  :\n\n             Returns an array of sequence object sorted alphabetically \n             by name and then by start point.\n             Does not change the order of the alignment\n\n Returns   : \n Argument  : \n\n\nsub each_alphabetically {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_seq_with_id\n\n Title     : each_seq_with_id\n Usage     : foreach $seq ( $align->each_seq_with_id() ) \n Function  : \n\n             Gets an array of Seq objects from the\n             alignment, the contents being those sequences\n             with the given name (there may be more than one)\n\n Returns   : an array\n Argument  : a seq name\n\n\nsub each_seq_with_id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 get_seq_by_pos\n\n Title     : get_seq_by_pos\n Usage     : $seq = $aln->get_seq_by_pos(3) # third sequence from the alignment\n Function  : \n\n             Gets a sequence based on its position in the alignment.\n             Numbering starts from 1.  Sequence positions larger than\n             num_sequences() will throw an error.\n\n Returns   : a Bio::LocatableSeq object\n Argument  : positive integer for the sequence position\n\n\nsub get_seq_by_pos {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Create new alignments\n\nThe result of these methods are horizontal or vertical subsets of the\ncurrent MSE.\n\n=head2 select\n\n Title     : select\n Usage     : $aln2 = $aln->select(1, 3) # three first sequences\n Function  : \n\n             Creates a new alignment from a continuous subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for the first sequence\n             positive integer for the last sequence to include (optional)\n\n\nsub select {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 select_noncont\n\n Title     : select_noncont\n Usage     : $aln2 = $aln->select_noncont(1, 3) # first and 3rd sequences\n Function  : \n\n             Creates a new alignment from a subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Args      : array of integers for the sequences\n\n\nsub select_noncont {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 slice\n\n Title     : slice\n Usage     : $aln2 = $aln->slice(20, 30)\n Function  : \n\n             Creates a slice from the alignment inclusive of start and\n             end columns.  Sequences with no residues in the slice are\n             excluded from the new alignment and a warning is printed.\n             Slice beyond the length of the sequence does not do\n             padding.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for start column \n             positive integer for end column \n\n\nsub slice {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Change sequences within the MSE\n\nThese methods affect characters in all sequences without changing the\nalignment.\n\n\n=head2 map_chars\n\n Title     : map_chars\n Usage     : $ali->map_chars('\\.','-')\n Function  : \n\n             Does a s/$arg1/$arg2/ on the sequences. Useful for gap\n             characters\n\n             Notice that the from (arg1) is interpreted as a regex,\n             so be careful about quoting meta characters (eg\n             $ali->map_chars('.','-') wont do what you want)\n\n Returns   : None\n Argument  : 'from' rexexp\n             'to' string\n\n\nsub map_chars {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 uppercase\n\n Title     : uppercase()\n Usage     : $ali->uppercase()\n Function  : Sets all the sequences to uppercase\n Returns   : \n Argument  : \n\n\nsub uppercase {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_line\n\n Title    : match_line()\n Usage    : $align->match_line()\n Function : Generates a match line - much like consensus string\n            except that a line indicating the '*' for a match.\n Argument : (optional) Match line characters ('*' by default)\n            (optional) Strong match char (':' by default)\n            (optional) Weak match char ('.' by default)\n\n\nsub match_line {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match\n\n Title     : match()\n Usage     : $ali->match()\n Function  : \n\n             Goes through all columns and changes residues that are\n             identical to residue in first sequence to match '.'\n             character. Sets match_char.\n\n             USE WITH CARE: Most MSE formats do not support match\n             characters in sequences, so this is mostly for output\n             only. NEXUS format (Bio::AlignIO::nexus) can handle\n             it.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub match {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 unmatch\n\n Title     : unmatch()\n Usage     : $ali->unmatch()\n Function  : \n\n             Undoes the effect of method match. Unsets match_char.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub unmatch {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head1 MSE attibutes\n\nMethods for setting and reading the MSE attributes. \n\nNote that the methods defining character semantics depend on the user\nto set them sensibly.  They are needed only by certain input/output\nmethods. Unset them by setting to an empty string ('').\n\n=head2 id\n\n Title     : id\n Usage     : $myalign->id(\"Ig\")\n Function  : Gets/sets the id field of the alignment\n Returns   : An id string\n Argument  : An id string (optional)\n\n\nsub id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 missing_char\n\n Title     : missing_char\n Usage     : $myalign->missing_char(\"?\")\n Function  : Gets/sets the missing_char attribute of the alignment\n             It is generally recommended to set it to 'n' or 'N' \n             for nucleotides and to 'X' for protein. \n Returns   : An missing_char string,\n Argument  : An missing_char string (optional)\n\n\nsub missing_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_char\n\n Title     : match_char\n Usage     : $myalign->match_char('.')\n Function  : Gets/sets the match_char attribute of the alignment\n Returns   : An match_char string,\n Argument  : An match_char string (optional)\n\n\nsub match_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 gap_char\n\n Title     : gap_char\n Usage     : $myalign->gap_char('-')\n Function  : Gets/sets the gap_char attribute of the alignment\n Returns   : An gap_char string, defaults to '-'\n Argument  : An gap_char string (optional)\n\n\nsub gap_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 symbol_chars\n\n Title   : symbol_chars\n Usage   : my @symbolchars = $aln->symbol_chars;\n Function: Returns all the seen symbols (other than gaps)\n Returns : array of characters that are the seen symbols\n Argument: boolean to include the gap/missing/match characters\n\n\nsub symbol_chars{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Alignment descriptors\n\nThese read only methods describe the MSE in various ways. \n\n\n=head2 consensus_string\n\n Title     : consensus_string\n Usage     : $str = $ali->consensus_string($threshold_percent)\n Function  : Makes a strict consensus \n Returns   : consensus string\n Argument  : Optional threshold ranging from 0 to 100.\n             The consensus residue has to appear at least threshold %\n             of the sequences at a given location, otherwise a '?'\n             character will be placed at that location.\n             (Default value = 0%)\n\n\nsub consensus_string {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 consensus_iupac\n\n Title     : consensus_iupac\n Usage     : $str = $ali->consensus_iupac()\n Function  : \n\n             Makes a consensus using IUPAC ambiguity codes from DNA\n             and RNA. The output is in upper case except when gaps in\n             a column force output to be in lower case.\n\n             Note that if your alignment sequences contain a lot of\n             IUPAC ambiquity codes you often have to manually set\n             alphabet.  Bio::PrimarySeq::_guess_type thinks they\n             indicate a protein sequence.\n\n Returns   : consensus string\n Argument  : none\n Throws    : on protein sequences\n\n\n\nsub consensus_iupac {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 is_flush\n\n Title     : is_flush\n Usage     : if( $ali->is_flush() )\n           : \n           :\n Function  : Tells you whether the alignment \n           : is flush, ie all of the same length\n           : \n           :\n Returns   : 1 or 0\n Argument  : \n\n\nsub is_flush {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 length\n\n Title     : length()\n Usage     : $len = $ali->length() \n Function  : Returns the maximum length of the alignment.\n             To be sure the alignment is a block, use is_flush\n Returns   : integer\n Argument  : "}},{"name":"maxname_length","containerName":"main::","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"maxname_length","kind":13,"line":624},{"kind":13,"containerName":"maxname_length","name":"$self","line":625},{"line":625,"name":"throw_not_implemented","containerName":"maxname_length","kind":12}],"detail":"($self)","definition":"sub","range":{"start":{"line":623,"character":0},"end":{"line":626,"character":9999}},"kind":12,"line":623,"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: AlignI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::AlignI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::AlignI - An interface for describing sequence alignments.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Align::AlignI somehow - typically using Bio::AlignIO system\n  # some descriptors\n  print $aln->length, \"\\n\";\n  print $aln->num_residues, \"\\n\";\n  print $aln->is_flush, \"\\n\";\n  print $aln->num_sequences, \"\\n\";\n  print $aln->percentage_identity, \"\\n\";\n  print $aln->consensus_string(50), \"\\n\";\n\n  # find the position in the alignment for a sequence location\n  $pos = $aln->column_from_residue_number('1433_LYCES', 14); # = 6;\n\n  # extract sequences and check values for the alignment column $pos\n  foreach $seq ($aln->each_seq) {\n      $res = $seq->subseq($pos, $pos);\n      $count{$res}++;\n  }\n  foreach $res (keys %count) {\n      printf \"Res: %s  Count: %2d\\n\", $res, $count{$res};\n  }\n\n=head1 DESCRIPTION\n\nThis interface describes the basis for alignment objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::AlignI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $myalign->add_seq($newseq);\n Function  : Adds another sequence to the alignment. *Does not* align\n             it - just adds it to the hashes.\n Returns   : None\n Argument  : a Bio::LocatableSeq object\n             order (optional)\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $aln->remove_seq($seq);\n Function  : Removes a single sequence from an alignment\n Returns   :\n Argument  : a Bio::LocatableSeq object\n\n\nsub remove_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 purge\n\n Title   : purge\n Usage   : $aln->purge(0.7);\n Function:\n\n           Removes sequences above whatever %id.\n\n           This function will grind on large alignments. Beware!\n           (perhaps not ideally implemented)\n\n Example :\n Returns : An array of the removed sequences\n Argument:\n\n\n\nsub purge {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 sort_alphabetically\n\n Title     : sort_alphabetically\n Usage     : $ali->sort_alphabetically\n Function  : \n\n             Changes the order of the alignment to alphabetical on name \n             followed by numerical by number.\n\n Returns   : an array\n Argument  : \n\n\nsub sort_alphabetically {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Sequence selection methods\n\nMethods returning one or more sequences objects.\n\n=head2 each_seq\n\n Title     : each_seq\n Usage     : foreach $seq ( $align->each_seq() ) \n Function  : Gets an array of Seq objects from the alignment\n Returns   : an array\n Argument  : \n\n\nsub each_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_alphabetically\n\n Title     : each_alphabetically\n Usage     : foreach $seq ( $ali->each_alphabetically() )\n Function  :\n\n             Returns an array of sequence object sorted alphabetically \n             by name and then by start point.\n             Does not change the order of the alignment\n\n Returns   : \n Argument  : \n\n\nsub each_alphabetically {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_seq_with_id\n\n Title     : each_seq_with_id\n Usage     : foreach $seq ( $align->each_seq_with_id() ) \n Function  : \n\n             Gets an array of Seq objects from the\n             alignment, the contents being those sequences\n             with the given name (there may be more than one)\n\n Returns   : an array\n Argument  : a seq name\n\n\nsub each_seq_with_id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 get_seq_by_pos\n\n Title     : get_seq_by_pos\n Usage     : $seq = $aln->get_seq_by_pos(3) # third sequence from the alignment\n Function  : \n\n             Gets a sequence based on its position in the alignment.\n             Numbering starts from 1.  Sequence positions larger than\n             num_sequences() will throw an error.\n\n Returns   : a Bio::LocatableSeq object\n Argument  : positive integer for the sequence position\n\n\nsub get_seq_by_pos {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Create new alignments\n\nThe result of these methods are horizontal or vertical subsets of the\ncurrent MSE.\n\n=head2 select\n\n Title     : select\n Usage     : $aln2 = $aln->select(1, 3) # three first sequences\n Function  : \n\n             Creates a new alignment from a continuous subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for the first sequence\n             positive integer for the last sequence to include (optional)\n\n\nsub select {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 select_noncont\n\n Title     : select_noncont\n Usage     : $aln2 = $aln->select_noncont(1, 3) # first and 3rd sequences\n Function  : \n\n             Creates a new alignment from a subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Args      : array of integers for the sequences\n\n\nsub select_noncont {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 slice\n\n Title     : slice\n Usage     : $aln2 = $aln->slice(20, 30)\n Function  : \n\n             Creates a slice from the alignment inclusive of start and\n             end columns.  Sequences with no residues in the slice are\n             excluded from the new alignment and a warning is printed.\n             Slice beyond the length of the sequence does not do\n             padding.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for start column \n             positive integer for end column \n\n\nsub slice {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Change sequences within the MSE\n\nThese methods affect characters in all sequences without changing the\nalignment.\n\n\n=head2 map_chars\n\n Title     : map_chars\n Usage     : $ali->map_chars('\\.','-')\n Function  : \n\n             Does a s/$arg1/$arg2/ on the sequences. Useful for gap\n             characters\n\n             Notice that the from (arg1) is interpreted as a regex,\n             so be careful about quoting meta characters (eg\n             $ali->map_chars('.','-') wont do what you want)\n\n Returns   : None\n Argument  : 'from' rexexp\n             'to' string\n\n\nsub map_chars {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 uppercase\n\n Title     : uppercase()\n Usage     : $ali->uppercase()\n Function  : Sets all the sequences to uppercase\n Returns   : \n Argument  : \n\n\nsub uppercase {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_line\n\n Title    : match_line()\n Usage    : $align->match_line()\n Function : Generates a match line - much like consensus string\n            except that a line indicating the '*' for a match.\n Argument : (optional) Match line characters ('*' by default)\n            (optional) Strong match char (':' by default)\n            (optional) Weak match char ('.' by default)\n\n\nsub match_line {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match\n\n Title     : match()\n Usage     : $ali->match()\n Function  : \n\n             Goes through all columns and changes residues that are\n             identical to residue in first sequence to match '.'\n             character. Sets match_char.\n\n             USE WITH CARE: Most MSE formats do not support match\n             characters in sequences, so this is mostly for output\n             only. NEXUS format (Bio::AlignIO::nexus) can handle\n             it.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub match {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 unmatch\n\n Title     : unmatch()\n Usage     : $ali->unmatch()\n Function  : \n\n             Undoes the effect of method match. Unsets match_char.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub unmatch {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head1 MSE attibutes\n\nMethods for setting and reading the MSE attributes. \n\nNote that the methods defining character semantics depend on the user\nto set them sensibly.  They are needed only by certain input/output\nmethods. Unset them by setting to an empty string ('').\n\n=head2 id\n\n Title     : id\n Usage     : $myalign->id(\"Ig\")\n Function  : Gets/sets the id field of the alignment\n Returns   : An id string\n Argument  : An id string (optional)\n\n\nsub id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 missing_char\n\n Title     : missing_char\n Usage     : $myalign->missing_char(\"?\")\n Function  : Gets/sets the missing_char attribute of the alignment\n             It is generally recommended to set it to 'n' or 'N' \n             for nucleotides and to 'X' for protein. \n Returns   : An missing_char string,\n Argument  : An missing_char string (optional)\n\n\nsub missing_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_char\n\n Title     : match_char\n Usage     : $myalign->match_char('.')\n Function  : Gets/sets the match_char attribute of the alignment\n Returns   : An match_char string,\n Argument  : An match_char string (optional)\n\n\nsub match_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 gap_char\n\n Title     : gap_char\n Usage     : $myalign->gap_char('-')\n Function  : Gets/sets the gap_char attribute of the alignment\n Returns   : An gap_char string, defaults to '-'\n Argument  : An gap_char string (optional)\n\n\nsub gap_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 symbol_chars\n\n Title   : symbol_chars\n Usage   : my @symbolchars = $aln->symbol_chars;\n Function: Returns all the seen symbols (other than gaps)\n Returns : array of characters that are the seen symbols\n Argument: boolean to include the gap/missing/match characters\n\n\nsub symbol_chars{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Alignment descriptors\n\nThese read only methods describe the MSE in various ways. \n\n\n=head2 consensus_string\n\n Title     : consensus_string\n Usage     : $str = $ali->consensus_string($threshold_percent)\n Function  : Makes a strict consensus \n Returns   : consensus string\n Argument  : Optional threshold ranging from 0 to 100.\n             The consensus residue has to appear at least threshold %\n             of the sequences at a given location, otherwise a '?'\n             character will be placed at that location.\n             (Default value = 0%)\n\n\nsub consensus_string {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 consensus_iupac\n\n Title     : consensus_iupac\n Usage     : $str = $ali->consensus_iupac()\n Function  : \n\n             Makes a consensus using IUPAC ambiguity codes from DNA\n             and RNA. The output is in upper case except when gaps in\n             a column force output to be in lower case.\n\n             Note that if your alignment sequences contain a lot of\n             IUPAC ambiquity codes you often have to manually set\n             alphabet.  Bio::PrimarySeq::_guess_type thinks they\n             indicate a protein sequence.\n\n Returns   : consensus string\n Argument  : none\n Throws    : on protein sequences\n\n\n\nsub consensus_iupac {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 is_flush\n\n Title     : is_flush\n Usage     : if( $ali->is_flush() )\n           : \n           :\n Function  : Tells you whether the alignment \n           : is flush, ie all of the same length\n           : \n           :\n Returns   : 1 or 0\n Argument  : \n\n\nsub is_flush {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 length\n\n Title     : length()\n Usage     : $len = $ali->length() \n Function  : Returns the maximum length of the alignment.\n             To be sure the alignment is a block, use is_flush\n Returns   : integer\n Argument  : \n\n\nsub length {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 maxname_length\n\n Title     : maxname_length\n Usage     : $ali->maxname_length()\n Function  : \n\n             Gets the maximum length of the displayname in the\n             alignment. Used in writing out various MSE formats.\n\n Returns   : integer\n Argument  : ","label":"maxname_length($self)"}},{"kind":12,"range":{"end":{"line":642,"character":9999},"start":{"line":639,"character":0}},"line":639,"signature":{"label":"num_residues($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: AlignI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::AlignI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::AlignI - An interface for describing sequence alignments.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Align::AlignI somehow - typically using Bio::AlignIO system\n  # some descriptors\n  print $aln->length, \"\\n\";\n  print $aln->num_residues, \"\\n\";\n  print $aln->is_flush, \"\\n\";\n  print $aln->num_sequences, \"\\n\";\n  print $aln->percentage_identity, \"\\n\";\n  print $aln->consensus_string(50), \"\\n\";\n\n  # find the position in the alignment for a sequence location\n  $pos = $aln->column_from_residue_number('1433_LYCES', 14); # = 6;\n\n  # extract sequences and check values for the alignment column $pos\n  foreach $seq ($aln->each_seq) {\n      $res = $seq->subseq($pos, $pos);\n      $count{$res}++;\n  }\n  foreach $res (keys %count) {\n      printf \"Res: %s  Count: %2d\\n\", $res, $count{$res};\n  }\n\n=head1 DESCRIPTION\n\nThis interface describes the basis for alignment objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::AlignI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $myalign->add_seq($newseq);\n Function  : Adds another sequence to the alignment. *Does not* align\n             it - just adds it to the hashes.\n Returns   : None\n Argument  : a Bio::LocatableSeq object\n             order (optional)\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $aln->remove_seq($seq);\n Function  : Removes a single sequence from an alignment\n Returns   :\n Argument  : a Bio::LocatableSeq object\n\n\nsub remove_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 purge\n\n Title   : purge\n Usage   : $aln->purge(0.7);\n Function:\n\n           Removes sequences above whatever %id.\n\n           This function will grind on large alignments. Beware!\n           (perhaps not ideally implemented)\n\n Example :\n Returns : An array of the removed sequences\n Argument:\n\n\n\nsub purge {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 sort_alphabetically\n\n Title     : sort_alphabetically\n Usage     : $ali->sort_alphabetically\n Function  : \n\n             Changes the order of the alignment to alphabetical on name \n             followed by numerical by number.\n\n Returns   : an array\n Argument  : \n\n\nsub sort_alphabetically {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Sequence selection methods\n\nMethods returning one or more sequences objects.\n\n=head2 each_seq\n\n Title     : each_seq\n Usage     : foreach $seq ( $align->each_seq() ) \n Function  : Gets an array of Seq objects from the alignment\n Returns   : an array\n Argument  : \n\n\nsub each_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_alphabetically\n\n Title     : each_alphabetically\n Usage     : foreach $seq ( $ali->each_alphabetically() )\n Function  :\n\n             Returns an array of sequence object sorted alphabetically \n             by name and then by start point.\n             Does not change the order of the alignment\n\n Returns   : \n Argument  : \n\n\nsub each_alphabetically {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_seq_with_id\n\n Title     : each_seq_with_id\n Usage     : foreach $seq ( $align->each_seq_with_id() ) \n Function  : \n\n             Gets an array of Seq objects from the\n             alignment, the contents being those sequences\n             with the given name (there may be more than one)\n\n Returns   : an array\n Argument  : a seq name\n\n\nsub each_seq_with_id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 get_seq_by_pos\n\n Title     : get_seq_by_pos\n Usage     : $seq = $aln->get_seq_by_pos(3) # third sequence from the alignment\n Function  : \n\n             Gets a sequence based on its position in the alignment.\n             Numbering starts from 1.  Sequence positions larger than\n             num_sequences() will throw an error.\n\n Returns   : a Bio::LocatableSeq object\n Argument  : positive integer for the sequence position\n\n\nsub get_seq_by_pos {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Create new alignments\n\nThe result of these methods are horizontal or vertical subsets of the\ncurrent MSE.\n\n=head2 select\n\n Title     : select\n Usage     : $aln2 = $aln->select(1, 3) # three first sequences\n Function  : \n\n             Creates a new alignment from a continuous subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for the first sequence\n             positive integer for the last sequence to include (optional)\n\n\nsub select {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 select_noncont\n\n Title     : select_noncont\n Usage     : $aln2 = $aln->select_noncont(1, 3) # first and 3rd sequences\n Function  : \n\n             Creates a new alignment from a subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Args      : array of integers for the sequences\n\n\nsub select_noncont {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 slice\n\n Title     : slice\n Usage     : $aln2 = $aln->slice(20, 30)\n Function  : \n\n             Creates a slice from the alignment inclusive of start and\n             end columns.  Sequences with no residues in the slice are\n             excluded from the new alignment and a warning is printed.\n             Slice beyond the length of the sequence does not do\n             padding.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for start column \n             positive integer for end column \n\n\nsub slice {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Change sequences within the MSE\n\nThese methods affect characters in all sequences without changing the\nalignment.\n\n\n=head2 map_chars\n\n Title     : map_chars\n Usage     : $ali->map_chars('\\.','-')\n Function  : \n\n             Does a s/$arg1/$arg2/ on the sequences. Useful for gap\n             characters\n\n             Notice that the from (arg1) is interpreted as a regex,\n             so be careful about quoting meta characters (eg\n             $ali->map_chars('.','-') wont do what you want)\n\n Returns   : None\n Argument  : 'from' rexexp\n             'to' string\n\n\nsub map_chars {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 uppercase\n\n Title     : uppercase()\n Usage     : $ali->uppercase()\n Function  : Sets all the sequences to uppercase\n Returns   : \n Argument  : \n\n\nsub uppercase {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_line\n\n Title    : match_line()\n Usage    : $align->match_line()\n Function : Generates a match line - much like consensus string\n            except that a line indicating the '*' for a match.\n Argument : (optional) Match line characters ('*' by default)\n            (optional) Strong match char (':' by default)\n            (optional) Weak match char ('.' by default)\n\n\nsub match_line {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match\n\n Title     : match()\n Usage     : $ali->match()\n Function  : \n\n             Goes through all columns and changes residues that are\n             identical to residue in first sequence to match '.'\n             character. Sets match_char.\n\n             USE WITH CARE: Most MSE formats do not support match\n             characters in sequences, so this is mostly for output\n             only. NEXUS format (Bio::AlignIO::nexus) can handle\n             it.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub match {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 unmatch\n\n Title     : unmatch()\n Usage     : $ali->unmatch()\n Function  : \n\n             Undoes the effect of method match. Unsets match_char.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub unmatch {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head1 MSE attibutes\n\nMethods for setting and reading the MSE attributes. \n\nNote that the methods defining character semantics depend on the user\nto set them sensibly.  They are needed only by certain input/output\nmethods. Unset them by setting to an empty string ('').\n\n=head2 id\n\n Title     : id\n Usage     : $myalign->id(\"Ig\")\n Function  : Gets/sets the id field of the alignment\n Returns   : An id string\n Argument  : An id string (optional)\n\n\nsub id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 missing_char\n\n Title     : missing_char\n Usage     : $myalign->missing_char(\"?\")\n Function  : Gets/sets the missing_char attribute of the alignment\n             It is generally recommended to set it to 'n' or 'N' \n             for nucleotides and to 'X' for protein. \n Returns   : An missing_char string,\n Argument  : An missing_char string (optional)\n\n\nsub missing_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_char\n\n Title     : match_char\n Usage     : $myalign->match_char('.')\n Function  : Gets/sets the match_char attribute of the alignment\n Returns   : An match_char string,\n Argument  : An match_char string (optional)\n\n\nsub match_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 gap_char\n\n Title     : gap_char\n Usage     : $myalign->gap_char('-')\n Function  : Gets/sets the gap_char attribute of the alignment\n Returns   : An gap_char string, defaults to '-'\n Argument  : An gap_char string (optional)\n\n\nsub gap_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 symbol_chars\n\n Title   : symbol_chars\n Usage   : my @symbolchars = $aln->symbol_chars;\n Function: Returns all the seen symbols (other than gaps)\n Returns : array of characters that are the seen symbols\n Argument: boolean to include the gap/missing/match characters\n\n\nsub symbol_chars{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Alignment descriptors\n\nThese read only methods describe the MSE in various ways. \n\n\n=head2 consensus_string\n\n Title     : consensus_string\n Usage     : $str = $ali->consensus_string($threshold_percent)\n Function  : Makes a strict consensus \n Returns   : consensus string\n Argument  : Optional threshold ranging from 0 to 100.\n             The consensus residue has to appear at least threshold %\n             of the sequences at a given location, otherwise a '?'\n             character will be placed at that location.\n             (Default value = 0%)\n\n\nsub consensus_string {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 consensus_iupac\n\n Title     : consensus_iupac\n Usage     : $str = $ali->consensus_iupac()\n Function  : \n\n             Makes a consensus using IUPAC ambiguity codes from DNA\n             and RNA. The output is in upper case except when gaps in\n             a column force output to be in lower case.\n\n             Note that if your alignment sequences contain a lot of\n             IUPAC ambiquity codes you often have to manually set\n             alphabet.  Bio::PrimarySeq::_guess_type thinks they\n             indicate a protein sequence.\n\n Returns   : consensus string\n Argument  : none\n Throws    : on protein sequences\n\n\n\nsub consensus_iupac {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 is_flush\n\n Title     : is_flush\n Usage     : if( $ali->is_flush() )\n           : \n           :\n Function  : Tells you whether the alignment \n           : is flush, ie all of the same length\n           : \n           :\n Returns   : 1 or 0\n Argument  : \n\n\nsub is_flush {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 length\n\n Title     : length()\n Usage     : $len = $ali->length() \n Function  : Returns the maximum length of the alignment.\n             To be sure the alignment is a block, use is_flush\n Returns   : integer\n Argument  : \n\n\nsub length {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 maxname_length\n\n Title     : maxname_length\n Usage     : $ali->maxname_length()\n Function  : \n\n             Gets the maximum length of the displayname in the\n             alignment. Used in writing out various MSE formats.\n\n Returns   : integer\n Argument  : \n\n\nsub maxname_length {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 num_residues\n\n Title     : num_residues\n Usage     : $no = $ali->num_residues\n Function  : number of residues in total in the alignment\n Returns   : integer\n Argument  :\n Note      : replaces no_residues"},"name":"num_residues","containerName":"main::","children":[{"line":640,"name":"$self","localvar":"my","containerName":"num_residues","kind":13,"definition":"my"},{"line":641,"name":"$self","containerName":"num_residues","kind":13},{"kind":12,"containerName":"num_residues","name":"throw_not_implemented","line":641}],"detail":"($self)","definition":"sub"},{"signature":{"label":"num_sequences($self)","documentation":"1;\n# $Id: AlignI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::AlignI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::AlignI - An interface for describing sequence alignments.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Align::AlignI somehow - typically using Bio::AlignIO system\n  # some descriptors\n  print $aln->length, \"\\n\";\n  print $aln->num_residues, \"\\n\";\n  print $aln->is_flush, \"\\n\";\n  print $aln->num_sequences, \"\\n\";\n  print $aln->percentage_identity, \"\\n\";\n  print $aln->consensus_string(50), \"\\n\";\n\n  # find the position in the alignment for a sequence location\n  $pos = $aln->column_from_residue_number('1433_LYCES', 14); # = 6;\n\n  # extract sequences and check values for the alignment column $pos\n  foreach $seq ($aln->each_seq) {\n      $res = $seq->subseq($pos, $pos);\n      $count{$res}++;\n  }\n  foreach $res (keys %count) {\n      printf \"Res: %s  Count: %2d\\n\", $res, $count{$res};\n  }\n\n=head1 DESCRIPTION\n\nThis interface describes the basis for alignment objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::AlignI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $myalign->add_seq($newseq);\n Function  : Adds another sequence to the alignment. *Does not* align\n             it - just adds it to the hashes.\n Returns   : None\n Argument  : a Bio::LocatableSeq object\n             order (optional)\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $aln->remove_seq($seq);\n Function  : Removes a single sequence from an alignment\n Returns   :\n Argument  : a Bio::LocatableSeq object\n\n\nsub remove_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 purge\n\n Title   : purge\n Usage   : $aln->purge(0.7);\n Function:\n\n           Removes sequences above whatever %id.\n\n           This function will grind on large alignments. Beware!\n           (perhaps not ideally implemented)\n\n Example :\n Returns : An array of the removed sequences\n Argument:\n\n\n\nsub purge {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 sort_alphabetically\n\n Title     : sort_alphabetically\n Usage     : $ali->sort_alphabetically\n Function  : \n\n             Changes the order of the alignment to alphabetical on name \n             followed by numerical by number.\n\n Returns   : an array\n Argument  : \n\n\nsub sort_alphabetically {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Sequence selection methods\n\nMethods returning one or more sequences objects.\n\n=head2 each_seq\n\n Title     : each_seq\n Usage     : foreach $seq ( $align->each_seq() ) \n Function  : Gets an array of Seq objects from the alignment\n Returns   : an array\n Argument  : \n\n\nsub each_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_alphabetically\n\n Title     : each_alphabetically\n Usage     : foreach $seq ( $ali->each_alphabetically() )\n Function  :\n\n             Returns an array of sequence object sorted alphabetically \n             by name and then by start point.\n             Does not change the order of the alignment\n\n Returns   : \n Argument  : \n\n\nsub each_alphabetically {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_seq_with_id\n\n Title     : each_seq_with_id\n Usage     : foreach $seq ( $align->each_seq_with_id() ) \n Function  : \n\n             Gets an array of Seq objects from the\n             alignment, the contents being those sequences\n             with the given name (there may be more than one)\n\n Returns   : an array\n Argument  : a seq name\n\n\nsub each_seq_with_id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 get_seq_by_pos\n\n Title     : get_seq_by_pos\n Usage     : $seq = $aln->get_seq_by_pos(3) # third sequence from the alignment\n Function  : \n\n             Gets a sequence based on its position in the alignment.\n             Numbering starts from 1.  Sequence positions larger than\n             num_sequences() will throw an error.\n\n Returns   : a Bio::LocatableSeq object\n Argument  : positive integer for the sequence position\n\n\nsub get_seq_by_pos {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Create new alignments\n\nThe result of these methods are horizontal or vertical subsets of the\ncurrent MSE.\n\n=head2 select\n\n Title     : select\n Usage     : $aln2 = $aln->select(1, 3) # three first sequences\n Function  : \n\n             Creates a new alignment from a continuous subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for the first sequence\n             positive integer for the last sequence to include (optional)\n\n\nsub select {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 select_noncont\n\n Title     : select_noncont\n Usage     : $aln2 = $aln->select_noncont(1, 3) # first and 3rd sequences\n Function  : \n\n             Creates a new alignment from a subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Args      : array of integers for the sequences\n\n\nsub select_noncont {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 slice\n\n Title     : slice\n Usage     : $aln2 = $aln->slice(20, 30)\n Function  : \n\n             Creates a slice from the alignment inclusive of start and\n             end columns.  Sequences with no residues in the slice are\n             excluded from the new alignment and a warning is printed.\n             Slice beyond the length of the sequence does not do\n             padding.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for start column \n             positive integer for end column \n\n\nsub slice {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Change sequences within the MSE\n\nThese methods affect characters in all sequences without changing the\nalignment.\n\n\n=head2 map_chars\n\n Title     : map_chars\n Usage     : $ali->map_chars('\\.','-')\n Function  : \n\n             Does a s/$arg1/$arg2/ on the sequences. Useful for gap\n             characters\n\n             Notice that the from (arg1) is interpreted as a regex,\n             so be careful about quoting meta characters (eg\n             $ali->map_chars('.','-') wont do what you want)\n\n Returns   : None\n Argument  : 'from' rexexp\n             'to' string\n\n\nsub map_chars {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 uppercase\n\n Title     : uppercase()\n Usage     : $ali->uppercase()\n Function  : Sets all the sequences to uppercase\n Returns   : \n Argument  : \n\n\nsub uppercase {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_line\n\n Title    : match_line()\n Usage    : $align->match_line()\n Function : Generates a match line - much like consensus string\n            except that a line indicating the '*' for a match.\n Argument : (optional) Match line characters ('*' by default)\n            (optional) Strong match char (':' by default)\n            (optional) Weak match char ('.' by default)\n\n\nsub match_line {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match\n\n Title     : match()\n Usage     : $ali->match()\n Function  : \n\n             Goes through all columns and changes residues that are\n             identical to residue in first sequence to match '.'\n             character. Sets match_char.\n\n             USE WITH CARE: Most MSE formats do not support match\n             characters in sequences, so this is mostly for output\n             only. NEXUS format (Bio::AlignIO::nexus) can handle\n             it.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub match {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 unmatch\n\n Title     : unmatch()\n Usage     : $ali->unmatch()\n Function  : \n\n             Undoes the effect of method match. Unsets match_char.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub unmatch {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head1 MSE attibutes\n\nMethods for setting and reading the MSE attributes. \n\nNote that the methods defining character semantics depend on the user\nto set them sensibly.  They are needed only by certain input/output\nmethods. Unset them by setting to an empty string ('').\n\n=head2 id\n\n Title     : id\n Usage     : $myalign->id(\"Ig\")\n Function  : Gets/sets the id field of the alignment\n Returns   : An id string\n Argument  : An id string (optional)\n\n\nsub id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 missing_char\n\n Title     : missing_char\n Usage     : $myalign->missing_char(\"?\")\n Function  : Gets/sets the missing_char attribute of the alignment\n             It is generally recommended to set it to 'n' or 'N' \n             for nucleotides and to 'X' for protein. \n Returns   : An missing_char string,\n Argument  : An missing_char string (optional)\n\n\nsub missing_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_char\n\n Title     : match_char\n Usage     : $myalign->match_char('.')\n Function  : Gets/sets the match_char attribute of the alignment\n Returns   : An match_char string,\n Argument  : An match_char string (optional)\n\n\nsub match_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 gap_char\n\n Title     : gap_char\n Usage     : $myalign->gap_char('-')\n Function  : Gets/sets the gap_char attribute of the alignment\n Returns   : An gap_char string, defaults to '-'\n Argument  : An gap_char string (optional)\n\n\nsub gap_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 symbol_chars\n\n Title   : symbol_chars\n Usage   : my @symbolchars = $aln->symbol_chars;\n Function: Returns all the seen symbols (other than gaps)\n Returns : array of characters that are the seen symbols\n Argument: boolean to include the gap/missing/match characters\n\n\nsub symbol_chars{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Alignment descriptors\n\nThese read only methods describe the MSE in various ways. \n\n\n=head2 consensus_string\n\n Title     : consensus_string\n Usage     : $str = $ali->consensus_string($threshold_percent)\n Function  : Makes a strict consensus \n Returns   : consensus string\n Argument  : Optional threshold ranging from 0 to 100.\n             The consensus residue has to appear at least threshold %\n             of the sequences at a given location, otherwise a '?'\n             character will be placed at that location.\n             (Default value = 0%)\n\n\nsub consensus_string {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 consensus_iupac\n\n Title     : consensus_iupac\n Usage     : $str = $ali->consensus_iupac()\n Function  : \n\n             Makes a consensus using IUPAC ambiguity codes from DNA\n             and RNA. The output is in upper case except when gaps in\n             a column force output to be in lower case.\n\n             Note that if your alignment sequences contain a lot of\n             IUPAC ambiquity codes you often have to manually set\n             alphabet.  Bio::PrimarySeq::_guess_type thinks they\n             indicate a protein sequence.\n\n Returns   : consensus string\n Argument  : none\n Throws    : on protein sequences\n\n\n\nsub consensus_iupac {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 is_flush\n\n Title     : is_flush\n Usage     : if( $ali->is_flush() )\n           : \n           :\n Function  : Tells you whether the alignment \n           : is flush, ie all of the same length\n           : \n           :\n Returns   : 1 or 0\n Argument  : \n\n\nsub is_flush {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 length\n\n Title     : length()\n Usage     : $len = $ali->length() \n Function  : Returns the maximum length of the alignment.\n             To be sure the alignment is a block, use is_flush\n Returns   : integer\n Argument  : \n\n\nsub length {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 maxname_length\n\n Title     : maxname_length\n Usage     : $ali->maxname_length()\n Function  : \n\n             Gets the maximum length of the displayname in the\n             alignment. Used in writing out various MSE formats.\n\n Returns   : integer\n Argument  : \n\n\nsub maxname_length {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 num_residues\n\n Title     : num_residues\n Usage     : $no = $ali->num_residues\n Function  : number of residues in total in the alignment\n Returns   : integer\n Argument  :\n Note      : replaces no_residues\n\n\nsub num_residues {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 num_sequences\n\n Title     : num_sequences\n Usage     : $depth = $ali->num_sequences\n Function  : number of sequence in the sequence alignment\n Returns   : integer\n Argument  : None\n Note      : replaces no_sequences","parameters":[{"label":"$self"}]},"kind":12,"range":{"start":{"character":0,"line":655},"end":{"character":9999,"line":658}},"line":655,"detail":"($self)","definition":"sub","containerName":"main::","name":"num_sequences","children":[{"definition":"my","containerName":"num_sequences","localvar":"my","kind":13,"name":"$self","line":656},{"line":657,"containerName":"num_sequences","kind":13,"name":"$self"},{"line":657,"containerName":"num_sequences","kind":12,"name":"throw_not_implemented"}]},{"detail":"($self)","definition":"sub","containerName":"main::","name":"percentage_identity","children":[{"line":672,"name":"$self","containerName":"percentage_identity","localvar":"my","kind":13,"definition":"my"},{"line":673,"name":"$self","kind":13,"containerName":"percentage_identity"},{"line":673,"containerName":"percentage_identity","kind":12,"name":"throw_not_implemented"}],"signature":{"label":"percentage_identity($self)","documentation":"1;\n# $Id: AlignI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::AlignI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::AlignI - An interface for describing sequence alignments.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Align::AlignI somehow - typically using Bio::AlignIO system\n  # some descriptors\n  print $aln->length, \"\\n\";\n  print $aln->num_residues, \"\\n\";\n  print $aln->is_flush, \"\\n\";\n  print $aln->num_sequences, \"\\n\";\n  print $aln->percentage_identity, \"\\n\";\n  print $aln->consensus_string(50), \"\\n\";\n\n  # find the position in the alignment for a sequence location\n  $pos = $aln->column_from_residue_number('1433_LYCES', 14); # = 6;\n\n  # extract sequences and check values for the alignment column $pos\n  foreach $seq ($aln->each_seq) {\n      $res = $seq->subseq($pos, $pos);\n      $count{$res}++;\n  }\n  foreach $res (keys %count) {\n      printf \"Res: %s  Count: %2d\\n\", $res, $count{$res};\n  }\n\n=head1 DESCRIPTION\n\nThis interface describes the basis for alignment objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::AlignI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $myalign->add_seq($newseq);\n Function  : Adds another sequence to the alignment. *Does not* align\n             it - just adds it to the hashes.\n Returns   : None\n Argument  : a Bio::LocatableSeq object\n             order (optional)\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $aln->remove_seq($seq);\n Function  : Removes a single sequence from an alignment\n Returns   :\n Argument  : a Bio::LocatableSeq object\n\n\nsub remove_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 purge\n\n Title   : purge\n Usage   : $aln->purge(0.7);\n Function:\n\n           Removes sequences above whatever %id.\n\n           This function will grind on large alignments. Beware!\n           (perhaps not ideally implemented)\n\n Example :\n Returns : An array of the removed sequences\n Argument:\n\n\n\nsub purge {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 sort_alphabetically\n\n Title     : sort_alphabetically\n Usage     : $ali->sort_alphabetically\n Function  : \n\n             Changes the order of the alignment to alphabetical on name \n             followed by numerical by number.\n\n Returns   : an array\n Argument  : \n\n\nsub sort_alphabetically {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Sequence selection methods\n\nMethods returning one or more sequences objects.\n\n=head2 each_seq\n\n Title     : each_seq\n Usage     : foreach $seq ( $align->each_seq() ) \n Function  : Gets an array of Seq objects from the alignment\n Returns   : an array\n Argument  : \n\n\nsub each_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_alphabetically\n\n Title     : each_alphabetically\n Usage     : foreach $seq ( $ali->each_alphabetically() )\n Function  :\n\n             Returns an array of sequence object sorted alphabetically \n             by name and then by start point.\n             Does not change the order of the alignment\n\n Returns   : \n Argument  : \n\n\nsub each_alphabetically {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_seq_with_id\n\n Title     : each_seq_with_id\n Usage     : foreach $seq ( $align->each_seq_with_id() ) \n Function  : \n\n             Gets an array of Seq objects from the\n             alignment, the contents being those sequences\n             with the given name (there may be more than one)\n\n Returns   : an array\n Argument  : a seq name\n\n\nsub each_seq_with_id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 get_seq_by_pos\n\n Title     : get_seq_by_pos\n Usage     : $seq = $aln->get_seq_by_pos(3) # third sequence from the alignment\n Function  : \n\n             Gets a sequence based on its position in the alignment.\n             Numbering starts from 1.  Sequence positions larger than\n             num_sequences() will throw an error.\n\n Returns   : a Bio::LocatableSeq object\n Argument  : positive integer for the sequence position\n\n\nsub get_seq_by_pos {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Create new alignments\n\nThe result of these methods are horizontal or vertical subsets of the\ncurrent MSE.\n\n=head2 select\n\n Title     : select\n Usage     : $aln2 = $aln->select(1, 3) # three first sequences\n Function  : \n\n             Creates a new alignment from a continuous subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for the first sequence\n             positive integer for the last sequence to include (optional)\n\n\nsub select {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 select_noncont\n\n Title     : select_noncont\n Usage     : $aln2 = $aln->select_noncont(1, 3) # first and 3rd sequences\n Function  : \n\n             Creates a new alignment from a subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Args      : array of integers for the sequences\n\n\nsub select_noncont {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 slice\n\n Title     : slice\n Usage     : $aln2 = $aln->slice(20, 30)\n Function  : \n\n             Creates a slice from the alignment inclusive of start and\n             end columns.  Sequences with no residues in the slice are\n             excluded from the new alignment and a warning is printed.\n             Slice beyond the length of the sequence does not do\n             padding.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for start column \n             positive integer for end column \n\n\nsub slice {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Change sequences within the MSE\n\nThese methods affect characters in all sequences without changing the\nalignment.\n\n\n=head2 map_chars\n\n Title     : map_chars\n Usage     : $ali->map_chars('\\.','-')\n Function  : \n\n             Does a s/$arg1/$arg2/ on the sequences. Useful for gap\n             characters\n\n             Notice that the from (arg1) is interpreted as a regex,\n             so be careful about quoting meta characters (eg\n             $ali->map_chars('.','-') wont do what you want)\n\n Returns   : None\n Argument  : 'from' rexexp\n             'to' string\n\n\nsub map_chars {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 uppercase\n\n Title     : uppercase()\n Usage     : $ali->uppercase()\n Function  : Sets all the sequences to uppercase\n Returns   : \n Argument  : \n\n\nsub uppercase {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_line\n\n Title    : match_line()\n Usage    : $align->match_line()\n Function : Generates a match line - much like consensus string\n            except that a line indicating the '*' for a match.\n Argument : (optional) Match line characters ('*' by default)\n            (optional) Strong match char (':' by default)\n            (optional) Weak match char ('.' by default)\n\n\nsub match_line {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match\n\n Title     : match()\n Usage     : $ali->match()\n Function  : \n\n             Goes through all columns and changes residues that are\n             identical to residue in first sequence to match '.'\n             character. Sets match_char.\n\n             USE WITH CARE: Most MSE formats do not support match\n             characters in sequences, so this is mostly for output\n             only. NEXUS format (Bio::AlignIO::nexus) can handle\n             it.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub match {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 unmatch\n\n Title     : unmatch()\n Usage     : $ali->unmatch()\n Function  : \n\n             Undoes the effect of method match. Unsets match_char.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub unmatch {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head1 MSE attibutes\n\nMethods for setting and reading the MSE attributes. \n\nNote that the methods defining character semantics depend on the user\nto set them sensibly.  They are needed only by certain input/output\nmethods. Unset them by setting to an empty string ('').\n\n=head2 id\n\n Title     : id\n Usage     : $myalign->id(\"Ig\")\n Function  : Gets/sets the id field of the alignment\n Returns   : An id string\n Argument  : An id string (optional)\n\n\nsub id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 missing_char\n\n Title     : missing_char\n Usage     : $myalign->missing_char(\"?\")\n Function  : Gets/sets the missing_char attribute of the alignment\n             It is generally recommended to set it to 'n' or 'N' \n             for nucleotides and to 'X' for protein. \n Returns   : An missing_char string,\n Argument  : An missing_char string (optional)\n\n\nsub missing_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_char\n\n Title     : match_char\n Usage     : $myalign->match_char('.')\n Function  : Gets/sets the match_char attribute of the alignment\n Returns   : An match_char string,\n Argument  : An match_char string (optional)\n\n\nsub match_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 gap_char\n\n Title     : gap_char\n Usage     : $myalign->gap_char('-')\n Function  : Gets/sets the gap_char attribute of the alignment\n Returns   : An gap_char string, defaults to '-'\n Argument  : An gap_char string (optional)\n\n\nsub gap_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 symbol_chars\n\n Title   : symbol_chars\n Usage   : my @symbolchars = $aln->symbol_chars;\n Function: Returns all the seen symbols (other than gaps)\n Returns : array of characters that are the seen symbols\n Argument: boolean to include the gap/missing/match characters\n\n\nsub symbol_chars{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Alignment descriptors\n\nThese read only methods describe the MSE in various ways. \n\n\n=head2 consensus_string\n\n Title     : consensus_string\n Usage     : $str = $ali->consensus_string($threshold_percent)\n Function  : Makes a strict consensus \n Returns   : consensus string\n Argument  : Optional threshold ranging from 0 to 100.\n             The consensus residue has to appear at least threshold %\n             of the sequences at a given location, otherwise a '?'\n             character will be placed at that location.\n             (Default value = 0%)\n\n\nsub consensus_string {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 consensus_iupac\n\n Title     : consensus_iupac\n Usage     : $str = $ali->consensus_iupac()\n Function  : \n\n             Makes a consensus using IUPAC ambiguity codes from DNA\n             and RNA. The output is in upper case except when gaps in\n             a column force output to be in lower case.\n\n             Note that if your alignment sequences contain a lot of\n             IUPAC ambiquity codes you often have to manually set\n             alphabet.  Bio::PrimarySeq::_guess_type thinks they\n             indicate a protein sequence.\n\n Returns   : consensus string\n Argument  : none\n Throws    : on protein sequences\n\n\n\nsub consensus_iupac {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 is_flush\n\n Title     : is_flush\n Usage     : if( $ali->is_flush() )\n           : \n           :\n Function  : Tells you whether the alignment \n           : is flush, ie all of the same length\n           : \n           :\n Returns   : 1 or 0\n Argument  : \n\n\nsub is_flush {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 length\n\n Title     : length()\n Usage     : $len = $ali->length() \n Function  : Returns the maximum length of the alignment.\n             To be sure the alignment is a block, use is_flush\n Returns   : integer\n Argument  : \n\n\nsub length {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 maxname_length\n\n Title     : maxname_length\n Usage     : $ali->maxname_length()\n Function  : \n\n             Gets the maximum length of the displayname in the\n             alignment. Used in writing out various MSE formats.\n\n Returns   : integer\n Argument  : \n\n\nsub maxname_length {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 num_residues\n\n Title     : num_residues\n Usage     : $no = $ali->num_residues\n Function  : number of residues in total in the alignment\n Returns   : integer\n Argument  :\n Note      : replaces no_residues\n\n\nsub num_residues {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 num_sequences\n\n Title     : num_sequences\n Usage     : $depth = $ali->num_sequences\n Function  : number of sequence in the sequence alignment\n Returns   : integer\n Argument  : None\n Note      : replaces no_sequences\n\n\nsub num_sequences {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 percentage_identity\n\n Title   : percentage_identity\n Usage   : $id = $align->percentage_identity\n Function: The function calculates the percentage identity of the alignment\n Returns : The percentage identity of the alignment (as defined by the \n\t   implementation)\n Argument: None","parameters":[{"label":"$self"}]},"kind":12,"range":{"end":{"line":674,"character":9999},"start":{"character":0,"line":671}},"line":671},{"detail":"($self)","definition":"sub","name":"overall_percentage_identity","containerName":"main::","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"overall_percentage_identity","line":688},{"name":"$self","kind":13,"containerName":"overall_percentage_identity","line":689},{"containerName":"overall_percentage_identity","kind":12,"name":"throw_not_implemented","line":689}],"signature":{"label":"overall_percentage_identity($self)","documentation":"1;\n# $Id: AlignI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::AlignI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::AlignI - An interface for describing sequence alignments.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Align::AlignI somehow - typically using Bio::AlignIO system\n  # some descriptors\n  print $aln->length, \"\\n\";\n  print $aln->num_residues, \"\\n\";\n  print $aln->is_flush, \"\\n\";\n  print $aln->num_sequences, \"\\n\";\n  print $aln->percentage_identity, \"\\n\";\n  print $aln->consensus_string(50), \"\\n\";\n\n  # find the position in the alignment for a sequence location\n  $pos = $aln->column_from_residue_number('1433_LYCES', 14); # = 6;\n\n  # extract sequences and check values for the alignment column $pos\n  foreach $seq ($aln->each_seq) {\n      $res = $seq->subseq($pos, $pos);\n      $count{$res}++;\n  }\n  foreach $res (keys %count) {\n      printf \"Res: %s  Count: %2d\\n\", $res, $count{$res};\n  }\n\n=head1 DESCRIPTION\n\nThis interface describes the basis for alignment objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::AlignI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $myalign->add_seq($newseq);\n Function  : Adds another sequence to the alignment. *Does not* align\n             it - just adds it to the hashes.\n Returns   : None\n Argument  : a Bio::LocatableSeq object\n             order (optional)\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $aln->remove_seq($seq);\n Function  : Removes a single sequence from an alignment\n Returns   :\n Argument  : a Bio::LocatableSeq object\n\n\nsub remove_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 purge\n\n Title   : purge\n Usage   : $aln->purge(0.7);\n Function:\n\n           Removes sequences above whatever %id.\n\n           This function will grind on large alignments. Beware!\n           (perhaps not ideally implemented)\n\n Example :\n Returns : An array of the removed sequences\n Argument:\n\n\n\nsub purge {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 sort_alphabetically\n\n Title     : sort_alphabetically\n Usage     : $ali->sort_alphabetically\n Function  : \n\n             Changes the order of the alignment to alphabetical on name \n             followed by numerical by number.\n\n Returns   : an array\n Argument  : \n\n\nsub sort_alphabetically {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Sequence selection methods\n\nMethods returning one or more sequences objects.\n\n=head2 each_seq\n\n Title     : each_seq\n Usage     : foreach $seq ( $align->each_seq() ) \n Function  : Gets an array of Seq objects from the alignment\n Returns   : an array\n Argument  : \n\n\nsub each_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_alphabetically\n\n Title     : each_alphabetically\n Usage     : foreach $seq ( $ali->each_alphabetically() )\n Function  :\n\n             Returns an array of sequence object sorted alphabetically \n             by name and then by start point.\n             Does not change the order of the alignment\n\n Returns   : \n Argument  : \n\n\nsub each_alphabetically {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_seq_with_id\n\n Title     : each_seq_with_id\n Usage     : foreach $seq ( $align->each_seq_with_id() ) \n Function  : \n\n             Gets an array of Seq objects from the\n             alignment, the contents being those sequences\n             with the given name (there may be more than one)\n\n Returns   : an array\n Argument  : a seq name\n\n\nsub each_seq_with_id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 get_seq_by_pos\n\n Title     : get_seq_by_pos\n Usage     : $seq = $aln->get_seq_by_pos(3) # third sequence from the alignment\n Function  : \n\n             Gets a sequence based on its position in the alignment.\n             Numbering starts from 1.  Sequence positions larger than\n             num_sequences() will throw an error.\n\n Returns   : a Bio::LocatableSeq object\n Argument  : positive integer for the sequence position\n\n\nsub get_seq_by_pos {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Create new alignments\n\nThe result of these methods are horizontal or vertical subsets of the\ncurrent MSE.\n\n=head2 select\n\n Title     : select\n Usage     : $aln2 = $aln->select(1, 3) # three first sequences\n Function  : \n\n             Creates a new alignment from a continuous subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for the first sequence\n             positive integer for the last sequence to include (optional)\n\n\nsub select {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 select_noncont\n\n Title     : select_noncont\n Usage     : $aln2 = $aln->select_noncont(1, 3) # first and 3rd sequences\n Function  : \n\n             Creates a new alignment from a subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Args      : array of integers for the sequences\n\n\nsub select_noncont {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 slice\n\n Title     : slice\n Usage     : $aln2 = $aln->slice(20, 30)\n Function  : \n\n             Creates a slice from the alignment inclusive of start and\n             end columns.  Sequences with no residues in the slice are\n             excluded from the new alignment and a warning is printed.\n             Slice beyond the length of the sequence does not do\n             padding.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for start column \n             positive integer for end column \n\n\nsub slice {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Change sequences within the MSE\n\nThese methods affect characters in all sequences without changing the\nalignment.\n\n\n=head2 map_chars\n\n Title     : map_chars\n Usage     : $ali->map_chars('\\.','-')\n Function  : \n\n             Does a s/$arg1/$arg2/ on the sequences. Useful for gap\n             characters\n\n             Notice that the from (arg1) is interpreted as a regex,\n             so be careful about quoting meta characters (eg\n             $ali->map_chars('.','-') wont do what you want)\n\n Returns   : None\n Argument  : 'from' rexexp\n             'to' string\n\n\nsub map_chars {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 uppercase\n\n Title     : uppercase()\n Usage     : $ali->uppercase()\n Function  : Sets all the sequences to uppercase\n Returns   : \n Argument  : \n\n\nsub uppercase {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_line\n\n Title    : match_line()\n Usage    : $align->match_line()\n Function : Generates a match line - much like consensus string\n            except that a line indicating the '*' for a match.\n Argument : (optional) Match line characters ('*' by default)\n            (optional) Strong match char (':' by default)\n            (optional) Weak match char ('.' by default)\n\n\nsub match_line {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match\n\n Title     : match()\n Usage     : $ali->match()\n Function  : \n\n             Goes through all columns and changes residues that are\n             identical to residue in first sequence to match '.'\n             character. Sets match_char.\n\n             USE WITH CARE: Most MSE formats do not support match\n             characters in sequences, so this is mostly for output\n             only. NEXUS format (Bio::AlignIO::nexus) can handle\n             it.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub match {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 unmatch\n\n Title     : unmatch()\n Usage     : $ali->unmatch()\n Function  : \n\n             Undoes the effect of method match. Unsets match_char.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub unmatch {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head1 MSE attibutes\n\nMethods for setting and reading the MSE attributes. \n\nNote that the methods defining character semantics depend on the user\nto set them sensibly.  They are needed only by certain input/output\nmethods. Unset them by setting to an empty string ('').\n\n=head2 id\n\n Title     : id\n Usage     : $myalign->id(\"Ig\")\n Function  : Gets/sets the id field of the alignment\n Returns   : An id string\n Argument  : An id string (optional)\n\n\nsub id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 missing_char\n\n Title     : missing_char\n Usage     : $myalign->missing_char(\"?\")\n Function  : Gets/sets the missing_char attribute of the alignment\n             It is generally recommended to set it to 'n' or 'N' \n             for nucleotides and to 'X' for protein. \n Returns   : An missing_char string,\n Argument  : An missing_char string (optional)\n\n\nsub missing_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_char\n\n Title     : match_char\n Usage     : $myalign->match_char('.')\n Function  : Gets/sets the match_char attribute of the alignment\n Returns   : An match_char string,\n Argument  : An match_char string (optional)\n\n\nsub match_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 gap_char\n\n Title     : gap_char\n Usage     : $myalign->gap_char('-')\n Function  : Gets/sets the gap_char attribute of the alignment\n Returns   : An gap_char string, defaults to '-'\n Argument  : An gap_char string (optional)\n\n\nsub gap_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 symbol_chars\n\n Title   : symbol_chars\n Usage   : my @symbolchars = $aln->symbol_chars;\n Function: Returns all the seen symbols (other than gaps)\n Returns : array of characters that are the seen symbols\n Argument: boolean to include the gap/missing/match characters\n\n\nsub symbol_chars{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Alignment descriptors\n\nThese read only methods describe the MSE in various ways. \n\n\n=head2 consensus_string\n\n Title     : consensus_string\n Usage     : $str = $ali->consensus_string($threshold_percent)\n Function  : Makes a strict consensus \n Returns   : consensus string\n Argument  : Optional threshold ranging from 0 to 100.\n             The consensus residue has to appear at least threshold %\n             of the sequences at a given location, otherwise a '?'\n             character will be placed at that location.\n             (Default value = 0%)\n\n\nsub consensus_string {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 consensus_iupac\n\n Title     : consensus_iupac\n Usage     : $str = $ali->consensus_iupac()\n Function  : \n\n             Makes a consensus using IUPAC ambiguity codes from DNA\n             and RNA. The output is in upper case except when gaps in\n             a column force output to be in lower case.\n\n             Note that if your alignment sequences contain a lot of\n             IUPAC ambiquity codes you often have to manually set\n             alphabet.  Bio::PrimarySeq::_guess_type thinks they\n             indicate a protein sequence.\n\n Returns   : consensus string\n Argument  : none\n Throws    : on protein sequences\n\n\n\nsub consensus_iupac {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 is_flush\n\n Title     : is_flush\n Usage     : if( $ali->is_flush() )\n           : \n           :\n Function  : Tells you whether the alignment \n           : is flush, ie all of the same length\n           : \n           :\n Returns   : 1 or 0\n Argument  : \n\n\nsub is_flush {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 length\n\n Title     : length()\n Usage     : $len = $ali->length() \n Function  : Returns the maximum length of the alignment.\n             To be sure the alignment is a block, use is_flush\n Returns   : integer\n Argument  : \n\n\nsub length {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 maxname_length\n\n Title     : maxname_length\n Usage     : $ali->maxname_length()\n Function  : \n\n             Gets the maximum length of the displayname in the\n             alignment. Used in writing out various MSE formats.\n\n Returns   : integer\n Argument  : \n\n\nsub maxname_length {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 num_residues\n\n Title     : num_residues\n Usage     : $no = $ali->num_residues\n Function  : number of residues in total in the alignment\n Returns   : integer\n Argument  :\n Note      : replaces no_residues\n\n\nsub num_residues {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 num_sequences\n\n Title     : num_sequences\n Usage     : $depth = $ali->num_sequences\n Function  : number of sequence in the sequence alignment\n Returns   : integer\n Argument  : None\n Note      : replaces no_sequences\n\n\nsub num_sequences {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 percentage_identity\n\n Title   : percentage_identity\n Usage   : $id = $align->percentage_identity\n Function: The function calculates the percentage identity of the alignment\n Returns : The percentage identity of the alignment (as defined by the \n\t   implementation)\n Argument: None\n\n\nsub percentage_identity{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 overall_percentage_identity\n\n Title   : overall_percentage_identity\n Usage   : $id = $align->overall_percentage_identity\n Function: The function calculates the percentage identity of \n           the conserved columns\n Returns : The percentage identity of the conserved columns\n Args    : None","parameters":[{"label":"$self"}]},"kind":12,"range":{"end":{"character":9999,"line":690},"start":{"line":687,"character":0}},"line":687},{"name":"average_percentage_identity","containerName":"main::","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"average_percentage_identity","name":"$self","line":705},{"kind":13,"containerName":"average_percentage_identity","name":"$self","line":706},{"name":"throw_not_implemented","kind":12,"containerName":"average_percentage_identity","line":706}],"detail":"($self)","definition":"sub","range":{"end":{"line":707,"character":9999},"start":{"line":704,"character":0}},"kind":12,"line":704,"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: AlignI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::AlignI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::AlignI - An interface for describing sequence alignments.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Align::AlignI somehow - typically using Bio::AlignIO system\n  # some descriptors\n  print $aln->length, \"\\n\";\n  print $aln->num_residues, \"\\n\";\n  print $aln->is_flush, \"\\n\";\n  print $aln->num_sequences, \"\\n\";\n  print $aln->percentage_identity, \"\\n\";\n  print $aln->consensus_string(50), \"\\n\";\n\n  # find the position in the alignment for a sequence location\n  $pos = $aln->column_from_residue_number('1433_LYCES', 14); # = 6;\n\n  # extract sequences and check values for the alignment column $pos\n  foreach $seq ($aln->each_seq) {\n      $res = $seq->subseq($pos, $pos);\n      $count{$res}++;\n  }\n  foreach $res (keys %count) {\n      printf \"Res: %s  Count: %2d\\n\", $res, $count{$res};\n  }\n\n=head1 DESCRIPTION\n\nThis interface describes the basis for alignment objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::AlignI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $myalign->add_seq($newseq);\n Function  : Adds another sequence to the alignment. *Does not* align\n             it - just adds it to the hashes.\n Returns   : None\n Argument  : a Bio::LocatableSeq object\n             order (optional)\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $aln->remove_seq($seq);\n Function  : Removes a single sequence from an alignment\n Returns   :\n Argument  : a Bio::LocatableSeq object\n\n\nsub remove_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 purge\n\n Title   : purge\n Usage   : $aln->purge(0.7);\n Function:\n\n           Removes sequences above whatever %id.\n\n           This function will grind on large alignments. Beware!\n           (perhaps not ideally implemented)\n\n Example :\n Returns : An array of the removed sequences\n Argument:\n\n\n\nsub purge {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 sort_alphabetically\n\n Title     : sort_alphabetically\n Usage     : $ali->sort_alphabetically\n Function  : \n\n             Changes the order of the alignment to alphabetical on name \n             followed by numerical by number.\n\n Returns   : an array\n Argument  : \n\n\nsub sort_alphabetically {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Sequence selection methods\n\nMethods returning one or more sequences objects.\n\n=head2 each_seq\n\n Title     : each_seq\n Usage     : foreach $seq ( $align->each_seq() ) \n Function  : Gets an array of Seq objects from the alignment\n Returns   : an array\n Argument  : \n\n\nsub each_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_alphabetically\n\n Title     : each_alphabetically\n Usage     : foreach $seq ( $ali->each_alphabetically() )\n Function  :\n\n             Returns an array of sequence object sorted alphabetically \n             by name and then by start point.\n             Does not change the order of the alignment\n\n Returns   : \n Argument  : \n\n\nsub each_alphabetically {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_seq_with_id\n\n Title     : each_seq_with_id\n Usage     : foreach $seq ( $align->each_seq_with_id() ) \n Function  : \n\n             Gets an array of Seq objects from the\n             alignment, the contents being those sequences\n             with the given name (there may be more than one)\n\n Returns   : an array\n Argument  : a seq name\n\n\nsub each_seq_with_id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 get_seq_by_pos\n\n Title     : get_seq_by_pos\n Usage     : $seq = $aln->get_seq_by_pos(3) # third sequence from the alignment\n Function  : \n\n             Gets a sequence based on its position in the alignment.\n             Numbering starts from 1.  Sequence positions larger than\n             num_sequences() will throw an error.\n\n Returns   : a Bio::LocatableSeq object\n Argument  : positive integer for the sequence position\n\n\nsub get_seq_by_pos {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Create new alignments\n\nThe result of these methods are horizontal or vertical subsets of the\ncurrent MSE.\n\n=head2 select\n\n Title     : select\n Usage     : $aln2 = $aln->select(1, 3) # three first sequences\n Function  : \n\n             Creates a new alignment from a continuous subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for the first sequence\n             positive integer for the last sequence to include (optional)\n\n\nsub select {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 select_noncont\n\n Title     : select_noncont\n Usage     : $aln2 = $aln->select_noncont(1, 3) # first and 3rd sequences\n Function  : \n\n             Creates a new alignment from a subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Args      : array of integers for the sequences\n\n\nsub select_noncont {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 slice\n\n Title     : slice\n Usage     : $aln2 = $aln->slice(20, 30)\n Function  : \n\n             Creates a slice from the alignment inclusive of start and\n             end columns.  Sequences with no residues in the slice are\n             excluded from the new alignment and a warning is printed.\n             Slice beyond the length of the sequence does not do\n             padding.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for start column \n             positive integer for end column \n\n\nsub slice {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Change sequences within the MSE\n\nThese methods affect characters in all sequences without changing the\nalignment.\n\n\n=head2 map_chars\n\n Title     : map_chars\n Usage     : $ali->map_chars('\\.','-')\n Function  : \n\n             Does a s/$arg1/$arg2/ on the sequences. Useful for gap\n             characters\n\n             Notice that the from (arg1) is interpreted as a regex,\n             so be careful about quoting meta characters (eg\n             $ali->map_chars('.','-') wont do what you want)\n\n Returns   : None\n Argument  : 'from' rexexp\n             'to' string\n\n\nsub map_chars {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 uppercase\n\n Title     : uppercase()\n Usage     : $ali->uppercase()\n Function  : Sets all the sequences to uppercase\n Returns   : \n Argument  : \n\n\nsub uppercase {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_line\n\n Title    : match_line()\n Usage    : $align->match_line()\n Function : Generates a match line - much like consensus string\n            except that a line indicating the '*' for a match.\n Argument : (optional) Match line characters ('*' by default)\n            (optional) Strong match char (':' by default)\n            (optional) Weak match char ('.' by default)\n\n\nsub match_line {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match\n\n Title     : match()\n Usage     : $ali->match()\n Function  : \n\n             Goes through all columns and changes residues that are\n             identical to residue in first sequence to match '.'\n             character. Sets match_char.\n\n             USE WITH CARE: Most MSE formats do not support match\n             characters in sequences, so this is mostly for output\n             only. NEXUS format (Bio::AlignIO::nexus) can handle\n             it.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub match {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 unmatch\n\n Title     : unmatch()\n Usage     : $ali->unmatch()\n Function  : \n\n             Undoes the effect of method match. Unsets match_char.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub unmatch {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head1 MSE attibutes\n\nMethods for setting and reading the MSE attributes. \n\nNote that the methods defining character semantics depend on the user\nto set them sensibly.  They are needed only by certain input/output\nmethods. Unset them by setting to an empty string ('').\n\n=head2 id\n\n Title     : id\n Usage     : $myalign->id(\"Ig\")\n Function  : Gets/sets the id field of the alignment\n Returns   : An id string\n Argument  : An id string (optional)\n\n\nsub id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 missing_char\n\n Title     : missing_char\n Usage     : $myalign->missing_char(\"?\")\n Function  : Gets/sets the missing_char attribute of the alignment\n             It is generally recommended to set it to 'n' or 'N' \n             for nucleotides and to 'X' for protein. \n Returns   : An missing_char string,\n Argument  : An missing_char string (optional)\n\n\nsub missing_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_char\n\n Title     : match_char\n Usage     : $myalign->match_char('.')\n Function  : Gets/sets the match_char attribute of the alignment\n Returns   : An match_char string,\n Argument  : An match_char string (optional)\n\n\nsub match_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 gap_char\n\n Title     : gap_char\n Usage     : $myalign->gap_char('-')\n Function  : Gets/sets the gap_char attribute of the alignment\n Returns   : An gap_char string, defaults to '-'\n Argument  : An gap_char string (optional)\n\n\nsub gap_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 symbol_chars\n\n Title   : symbol_chars\n Usage   : my @symbolchars = $aln->symbol_chars;\n Function: Returns all the seen symbols (other than gaps)\n Returns : array of characters that are the seen symbols\n Argument: boolean to include the gap/missing/match characters\n\n\nsub symbol_chars{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Alignment descriptors\n\nThese read only methods describe the MSE in various ways. \n\n\n=head2 consensus_string\n\n Title     : consensus_string\n Usage     : $str = $ali->consensus_string($threshold_percent)\n Function  : Makes a strict consensus \n Returns   : consensus string\n Argument  : Optional threshold ranging from 0 to 100.\n             The consensus residue has to appear at least threshold %\n             of the sequences at a given location, otherwise a '?'\n             character will be placed at that location.\n             (Default value = 0%)\n\n\nsub consensus_string {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 consensus_iupac\n\n Title     : consensus_iupac\n Usage     : $str = $ali->consensus_iupac()\n Function  : \n\n             Makes a consensus using IUPAC ambiguity codes from DNA\n             and RNA. The output is in upper case except when gaps in\n             a column force output to be in lower case.\n\n             Note that if your alignment sequences contain a lot of\n             IUPAC ambiquity codes you often have to manually set\n             alphabet.  Bio::PrimarySeq::_guess_type thinks they\n             indicate a protein sequence.\n\n Returns   : consensus string\n Argument  : none\n Throws    : on protein sequences\n\n\n\nsub consensus_iupac {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 is_flush\n\n Title     : is_flush\n Usage     : if( $ali->is_flush() )\n           : \n           :\n Function  : Tells you whether the alignment \n           : is flush, ie all of the same length\n           : \n           :\n Returns   : 1 or 0\n Argument  : \n\n\nsub is_flush {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 length\n\n Title     : length()\n Usage     : $len = $ali->length() \n Function  : Returns the maximum length of the alignment.\n             To be sure the alignment is a block, use is_flush\n Returns   : integer\n Argument  : \n\n\nsub length {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 maxname_length\n\n Title     : maxname_length\n Usage     : $ali->maxname_length()\n Function  : \n\n             Gets the maximum length of the displayname in the\n             alignment. Used in writing out various MSE formats.\n\n Returns   : integer\n Argument  : \n\n\nsub maxname_length {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 num_residues\n\n Title     : num_residues\n Usage     : $no = $ali->num_residues\n Function  : number of residues in total in the alignment\n Returns   : integer\n Argument  :\n Note      : replaces no_residues\n\n\nsub num_residues {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 num_sequences\n\n Title     : num_sequences\n Usage     : $depth = $ali->num_sequences\n Function  : number of sequence in the sequence alignment\n Returns   : integer\n Argument  : None\n Note      : replaces no_sequences\n\n\nsub num_sequences {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 percentage_identity\n\n Title   : percentage_identity\n Usage   : $id = $align->percentage_identity\n Function: The function calculates the percentage identity of the alignment\n Returns : The percentage identity of the alignment (as defined by the \n\t   implementation)\n Argument: None\n\n\nsub percentage_identity{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 overall_percentage_identity\n\n Title   : overall_percentage_identity\n Usage   : $id = $align->overall_percentage_identity\n Function: The function calculates the percentage identity of \n           the conserved columns\n Returns : The percentage identity of the conserved columns\n Args    : None\n\n\nsub overall_percentage_identity{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 average_percentage_identity\n\n Title   : average_percentage_identity\n Usage   : $id = $align->average_percentage_identity\n Function: The function uses a fast method to calculate the average \n           percentage identity of the alignment\n Returns : The average percentage identity of the alignment\n Args    : None","label":"average_percentage_identity($self)"}},{"signature":{"label":"column_from_residue_number($self)","documentation":"1;\n# $Id: AlignI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::AlignI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::AlignI - An interface for describing sequence alignments.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Align::AlignI somehow - typically using Bio::AlignIO system\n  # some descriptors\n  print $aln->length, \"\\n\";\n  print $aln->num_residues, \"\\n\";\n  print $aln->is_flush, \"\\n\";\n  print $aln->num_sequences, \"\\n\";\n  print $aln->percentage_identity, \"\\n\";\n  print $aln->consensus_string(50), \"\\n\";\n\n  # find the position in the alignment for a sequence location\n  $pos = $aln->column_from_residue_number('1433_LYCES', 14); # = 6;\n\n  # extract sequences and check values for the alignment column $pos\n  foreach $seq ($aln->each_seq) {\n      $res = $seq->subseq($pos, $pos);\n      $count{$res}++;\n  }\n  foreach $res (keys %count) {\n      printf \"Res: %s  Count: %2d\\n\", $res, $count{$res};\n  }\n\n=head1 DESCRIPTION\n\nThis interface describes the basis for alignment objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::AlignI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $myalign->add_seq($newseq);\n Function  : Adds another sequence to the alignment. *Does not* align\n             it - just adds it to the hashes.\n Returns   : None\n Argument  : a Bio::LocatableSeq object\n             order (optional)\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $aln->remove_seq($seq);\n Function  : Removes a single sequence from an alignment\n Returns   :\n Argument  : a Bio::LocatableSeq object\n\n\nsub remove_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 purge\n\n Title   : purge\n Usage   : $aln->purge(0.7);\n Function:\n\n           Removes sequences above whatever %id.\n\n           This function will grind on large alignments. Beware!\n           (perhaps not ideally implemented)\n\n Example :\n Returns : An array of the removed sequences\n Argument:\n\n\n\nsub purge {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 sort_alphabetically\n\n Title     : sort_alphabetically\n Usage     : $ali->sort_alphabetically\n Function  : \n\n             Changes the order of the alignment to alphabetical on name \n             followed by numerical by number.\n\n Returns   : an array\n Argument  : \n\n\nsub sort_alphabetically {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Sequence selection methods\n\nMethods returning one or more sequences objects.\n\n=head2 each_seq\n\n Title     : each_seq\n Usage     : foreach $seq ( $align->each_seq() ) \n Function  : Gets an array of Seq objects from the alignment\n Returns   : an array\n Argument  : \n\n\nsub each_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_alphabetically\n\n Title     : each_alphabetically\n Usage     : foreach $seq ( $ali->each_alphabetically() )\n Function  :\n\n             Returns an array of sequence object sorted alphabetically \n             by name and then by start point.\n             Does not change the order of the alignment\n\n Returns   : \n Argument  : \n\n\nsub each_alphabetically {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_seq_with_id\n\n Title     : each_seq_with_id\n Usage     : foreach $seq ( $align->each_seq_with_id() ) \n Function  : \n\n             Gets an array of Seq objects from the\n             alignment, the contents being those sequences\n             with the given name (there may be more than one)\n\n Returns   : an array\n Argument  : a seq name\n\n\nsub each_seq_with_id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 get_seq_by_pos\n\n Title     : get_seq_by_pos\n Usage     : $seq = $aln->get_seq_by_pos(3) # third sequence from the alignment\n Function  : \n\n             Gets a sequence based on its position in the alignment.\n             Numbering starts from 1.  Sequence positions larger than\n             num_sequences() will throw an error.\n\n Returns   : a Bio::LocatableSeq object\n Argument  : positive integer for the sequence position\n\n\nsub get_seq_by_pos {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Create new alignments\n\nThe result of these methods are horizontal or vertical subsets of the\ncurrent MSE.\n\n=head2 select\n\n Title     : select\n Usage     : $aln2 = $aln->select(1, 3) # three first sequences\n Function  : \n\n             Creates a new alignment from a continuous subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for the first sequence\n             positive integer for the last sequence to include (optional)\n\n\nsub select {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 select_noncont\n\n Title     : select_noncont\n Usage     : $aln2 = $aln->select_noncont(1, 3) # first and 3rd sequences\n Function  : \n\n             Creates a new alignment from a subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Args      : array of integers for the sequences\n\n\nsub select_noncont {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 slice\n\n Title     : slice\n Usage     : $aln2 = $aln->slice(20, 30)\n Function  : \n\n             Creates a slice from the alignment inclusive of start and\n             end columns.  Sequences with no residues in the slice are\n             excluded from the new alignment and a warning is printed.\n             Slice beyond the length of the sequence does not do\n             padding.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for start column \n             positive integer for end column \n\n\nsub slice {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Change sequences within the MSE\n\nThese methods affect characters in all sequences without changing the\nalignment.\n\n\n=head2 map_chars\n\n Title     : map_chars\n Usage     : $ali->map_chars('\\.','-')\n Function  : \n\n             Does a s/$arg1/$arg2/ on the sequences. Useful for gap\n             characters\n\n             Notice that the from (arg1) is interpreted as a regex,\n             so be careful about quoting meta characters (eg\n             $ali->map_chars('.','-') wont do what you want)\n\n Returns   : None\n Argument  : 'from' rexexp\n             'to' string\n\n\nsub map_chars {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 uppercase\n\n Title     : uppercase()\n Usage     : $ali->uppercase()\n Function  : Sets all the sequences to uppercase\n Returns   : \n Argument  : \n\n\nsub uppercase {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_line\n\n Title    : match_line()\n Usage    : $align->match_line()\n Function : Generates a match line - much like consensus string\n            except that a line indicating the '*' for a match.\n Argument : (optional) Match line characters ('*' by default)\n            (optional) Strong match char (':' by default)\n            (optional) Weak match char ('.' by default)\n\n\nsub match_line {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match\n\n Title     : match()\n Usage     : $ali->match()\n Function  : \n\n             Goes through all columns and changes residues that are\n             identical to residue in first sequence to match '.'\n             character. Sets match_char.\n\n             USE WITH CARE: Most MSE formats do not support match\n             characters in sequences, so this is mostly for output\n             only. NEXUS format (Bio::AlignIO::nexus) can handle\n             it.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub match {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 unmatch\n\n Title     : unmatch()\n Usage     : $ali->unmatch()\n Function  : \n\n             Undoes the effect of method match. Unsets match_char.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub unmatch {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head1 MSE attibutes\n\nMethods for setting and reading the MSE attributes. \n\nNote that the methods defining character semantics depend on the user\nto set them sensibly.  They are needed only by certain input/output\nmethods. Unset them by setting to an empty string ('').\n\n=head2 id\n\n Title     : id\n Usage     : $myalign->id(\"Ig\")\n Function  : Gets/sets the id field of the alignment\n Returns   : An id string\n Argument  : An id string (optional)\n\n\nsub id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 missing_char\n\n Title     : missing_char\n Usage     : $myalign->missing_char(\"?\")\n Function  : Gets/sets the missing_char attribute of the alignment\n             It is generally recommended to set it to 'n' or 'N' \n             for nucleotides and to 'X' for protein. \n Returns   : An missing_char string,\n Argument  : An missing_char string (optional)\n\n\nsub missing_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_char\n\n Title     : match_char\n Usage     : $myalign->match_char('.')\n Function  : Gets/sets the match_char attribute of the alignment\n Returns   : An match_char string,\n Argument  : An match_char string (optional)\n\n\nsub match_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 gap_char\n\n Title     : gap_char\n Usage     : $myalign->gap_char('-')\n Function  : Gets/sets the gap_char attribute of the alignment\n Returns   : An gap_char string, defaults to '-'\n Argument  : An gap_char string (optional)\n\n\nsub gap_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 symbol_chars\n\n Title   : symbol_chars\n Usage   : my @symbolchars = $aln->symbol_chars;\n Function: Returns all the seen symbols (other than gaps)\n Returns : array of characters that are the seen symbols\n Argument: boolean to include the gap/missing/match characters\n\n\nsub symbol_chars{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Alignment descriptors\n\nThese read only methods describe the MSE in various ways. \n\n\n=head2 consensus_string\n\n Title     : consensus_string\n Usage     : $str = $ali->consensus_string($threshold_percent)\n Function  : Makes a strict consensus \n Returns   : consensus string\n Argument  : Optional threshold ranging from 0 to 100.\n             The consensus residue has to appear at least threshold %\n             of the sequences at a given location, otherwise a '?'\n             character will be placed at that location.\n             (Default value = 0%)\n\n\nsub consensus_string {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 consensus_iupac\n\n Title     : consensus_iupac\n Usage     : $str = $ali->consensus_iupac()\n Function  : \n\n             Makes a consensus using IUPAC ambiguity codes from DNA\n             and RNA. The output is in upper case except when gaps in\n             a column force output to be in lower case.\n\n             Note that if your alignment sequences contain a lot of\n             IUPAC ambiquity codes you often have to manually set\n             alphabet.  Bio::PrimarySeq::_guess_type thinks they\n             indicate a protein sequence.\n\n Returns   : consensus string\n Argument  : none\n Throws    : on protein sequences\n\n\n\nsub consensus_iupac {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 is_flush\n\n Title     : is_flush\n Usage     : if( $ali->is_flush() )\n           : \n           :\n Function  : Tells you whether the alignment \n           : is flush, ie all of the same length\n           : \n           :\n Returns   : 1 or 0\n Argument  : \n\n\nsub is_flush {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 length\n\n Title     : length()\n Usage     : $len = $ali->length() \n Function  : Returns the maximum length of the alignment.\n             To be sure the alignment is a block, use is_flush\n Returns   : integer\n Argument  : \n\n\nsub length {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 maxname_length\n\n Title     : maxname_length\n Usage     : $ali->maxname_length()\n Function  : \n\n             Gets the maximum length of the displayname in the\n             alignment. Used in writing out various MSE formats.\n\n Returns   : integer\n Argument  : \n\n\nsub maxname_length {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 num_residues\n\n Title     : num_residues\n Usage     : $no = $ali->num_residues\n Function  : number of residues in total in the alignment\n Returns   : integer\n Argument  :\n Note      : replaces no_residues\n\n\nsub num_residues {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 num_sequences\n\n Title     : num_sequences\n Usage     : $depth = $ali->num_sequences\n Function  : number of sequence in the sequence alignment\n Returns   : integer\n Argument  : None\n Note      : replaces no_sequences\n\n\nsub num_sequences {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 percentage_identity\n\n Title   : percentage_identity\n Usage   : $id = $align->percentage_identity\n Function: The function calculates the percentage identity of the alignment\n Returns : The percentage identity of the alignment (as defined by the \n\t   implementation)\n Argument: None\n\n\nsub percentage_identity{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 overall_percentage_identity\n\n Title   : overall_percentage_identity\n Usage   : $id = $align->overall_percentage_identity\n Function: The function calculates the percentage identity of \n           the conserved columns\n Returns : The percentage identity of the conserved columns\n Args    : None\n\n\nsub overall_percentage_identity{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 average_percentage_identity\n\n Title   : average_percentage_identity\n Usage   : $id = $align->average_percentage_identity\n Function: The function uses a fast method to calculate the average \n           percentage identity of the alignment\n Returns : The average percentage identity of the alignment\n Args    : None\n\n\nsub average_percentage_identity{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Alignment positions\n\nMethods to map a sequence position into an alignment column and back.\ncolumn_from_residue_number() does the former. The latter is really a\nproperty of the sequence object and can done using\nL<Bio::LocatableSeq::location_from_column>:\n\n    # select somehow a sequence from the alignment, e.g.\n    my $seq = $aln->get_seq_by_pos(1);\n    #$loc is undef or Bio::LocationI object\n    my $loc = $seq->location_from_column(5);\n\n\n=head2 column_from_residue_number\n\n Title   : column_from_residue_number\n Usage   : $col = $ali->column_from_residue_number( $seqname, $resnumber)\n Function:\n\n           This function gives the position in the alignment\n           (i.e. column number) of the given residue number in the\n           sequence with the given name. For example, for the\n           alignment\n\n  \t     Seq1/91-97 AC..DEF.GH\n  \t     Seq2/24-30 ACGG.RTY..\n  \t     Seq3/43-51 AC.DDEFGHI\n\n           column_from_residue_number( \"Seq1\", 94 ) returns 6.\n           column_from_residue_number( \"Seq2\", 25 ) returns 2.\n           column_from_residue_number( \"Seq3\", 50 ) returns 9.\n\n           An exception is thrown if the residue number would lie\n           outside the length of the alignment\n           (e.g. column_from_residue_number( \"Seq2\", 22 )\n\n\t  Note: If the parent sequence is represented by more than one\n\t  alignment sequence and the residue number is present in\n\t  them, this method finds only the first one.\n\n Returns : A column number for the position in the alignment of the\n           given residue in the given sequence (1 = first column)\n Args    : A sequence id/name (not a name/start-end)\n           A residue number in the whole sequence (not just that\n           segment of it in the alignment)","parameters":[{"label":"$self"}]},"line":757,"kind":12,"range":{"start":{"character":0,"line":757},"end":{"character":9999,"line":760}},"definition":"sub","detail":"($self)","children":[{"name":"$self","localvar":"my","containerName":"column_from_residue_number","kind":13,"line":758,"definition":"my"},{"containerName":"column_from_residue_number","kind":13,"name":"$self","line":759},{"line":759,"name":"throw_not_implemented","kind":12,"containerName":"column_from_residue_number"}],"containerName":"main::","name":"column_from_residue_number"},{"definition":"sub","detail":"($self)","children":[{"definition":"my","line":781,"localvar":"my","kind":13,"containerName":"displayname","name":"$self"},{"line":782,"containerName":"displayname","kind":13,"name":"$self"},{"kind":12,"containerName":"displayname","name":"throw_not_implemented","line":782}],"name":"displayname","containerName":"main::","signature":{"label":"displayname($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: AlignI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::AlignI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::AlignI - An interface for describing sequence alignments.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Align::AlignI somehow - typically using Bio::AlignIO system\n  # some descriptors\n  print $aln->length, \"\\n\";\n  print $aln->num_residues, \"\\n\";\n  print $aln->is_flush, \"\\n\";\n  print $aln->num_sequences, \"\\n\";\n  print $aln->percentage_identity, \"\\n\";\n  print $aln->consensus_string(50), \"\\n\";\n\n  # find the position in the alignment for a sequence location\n  $pos = $aln->column_from_residue_number('1433_LYCES', 14); # = 6;\n\n  # extract sequences and check values for the alignment column $pos\n  foreach $seq ($aln->each_seq) {\n      $res = $seq->subseq($pos, $pos);\n      $count{$res}++;\n  }\n  foreach $res (keys %count) {\n      printf \"Res: %s  Count: %2d\\n\", $res, $count{$res};\n  }\n\n=head1 DESCRIPTION\n\nThis interface describes the basis for alignment objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::AlignI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $myalign->add_seq($newseq);\n Function  : Adds another sequence to the alignment. *Does not* align\n             it - just adds it to the hashes.\n Returns   : None\n Argument  : a Bio::LocatableSeq object\n             order (optional)\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $aln->remove_seq($seq);\n Function  : Removes a single sequence from an alignment\n Returns   :\n Argument  : a Bio::LocatableSeq object\n\n\nsub remove_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 purge\n\n Title   : purge\n Usage   : $aln->purge(0.7);\n Function:\n\n           Removes sequences above whatever %id.\n\n           This function will grind on large alignments. Beware!\n           (perhaps not ideally implemented)\n\n Example :\n Returns : An array of the removed sequences\n Argument:\n\n\n\nsub purge {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 sort_alphabetically\n\n Title     : sort_alphabetically\n Usage     : $ali->sort_alphabetically\n Function  : \n\n             Changes the order of the alignment to alphabetical on name \n             followed by numerical by number.\n\n Returns   : an array\n Argument  : \n\n\nsub sort_alphabetically {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Sequence selection methods\n\nMethods returning one or more sequences objects.\n\n=head2 each_seq\n\n Title     : each_seq\n Usage     : foreach $seq ( $align->each_seq() ) \n Function  : Gets an array of Seq objects from the alignment\n Returns   : an array\n Argument  : \n\n\nsub each_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_alphabetically\n\n Title     : each_alphabetically\n Usage     : foreach $seq ( $ali->each_alphabetically() )\n Function  :\n\n             Returns an array of sequence object sorted alphabetically \n             by name and then by start point.\n             Does not change the order of the alignment\n\n Returns   : \n Argument  : \n\n\nsub each_alphabetically {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_seq_with_id\n\n Title     : each_seq_with_id\n Usage     : foreach $seq ( $align->each_seq_with_id() ) \n Function  : \n\n             Gets an array of Seq objects from the\n             alignment, the contents being those sequences\n             with the given name (there may be more than one)\n\n Returns   : an array\n Argument  : a seq name\n\n\nsub each_seq_with_id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 get_seq_by_pos\n\n Title     : get_seq_by_pos\n Usage     : $seq = $aln->get_seq_by_pos(3) # third sequence from the alignment\n Function  : \n\n             Gets a sequence based on its position in the alignment.\n             Numbering starts from 1.  Sequence positions larger than\n             num_sequences() will throw an error.\n\n Returns   : a Bio::LocatableSeq object\n Argument  : positive integer for the sequence position\n\n\nsub get_seq_by_pos {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Create new alignments\n\nThe result of these methods are horizontal or vertical subsets of the\ncurrent MSE.\n\n=head2 select\n\n Title     : select\n Usage     : $aln2 = $aln->select(1, 3) # three first sequences\n Function  : \n\n             Creates a new alignment from a continuous subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for the first sequence\n             positive integer for the last sequence to include (optional)\n\n\nsub select {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 select_noncont\n\n Title     : select_noncont\n Usage     : $aln2 = $aln->select_noncont(1, 3) # first and 3rd sequences\n Function  : \n\n             Creates a new alignment from a subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Args      : array of integers for the sequences\n\n\nsub select_noncont {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 slice\n\n Title     : slice\n Usage     : $aln2 = $aln->slice(20, 30)\n Function  : \n\n             Creates a slice from the alignment inclusive of start and\n             end columns.  Sequences with no residues in the slice are\n             excluded from the new alignment and a warning is printed.\n             Slice beyond the length of the sequence does not do\n             padding.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for start column \n             positive integer for end column \n\n\nsub slice {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Change sequences within the MSE\n\nThese methods affect characters in all sequences without changing the\nalignment.\n\n\n=head2 map_chars\n\n Title     : map_chars\n Usage     : $ali->map_chars('\\.','-')\n Function  : \n\n             Does a s/$arg1/$arg2/ on the sequences. Useful for gap\n             characters\n\n             Notice that the from (arg1) is interpreted as a regex,\n             so be careful about quoting meta characters (eg\n             $ali->map_chars('.','-') wont do what you want)\n\n Returns   : None\n Argument  : 'from' rexexp\n             'to' string\n\n\nsub map_chars {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 uppercase\n\n Title     : uppercase()\n Usage     : $ali->uppercase()\n Function  : Sets all the sequences to uppercase\n Returns   : \n Argument  : \n\n\nsub uppercase {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_line\n\n Title    : match_line()\n Usage    : $align->match_line()\n Function : Generates a match line - much like consensus string\n            except that a line indicating the '*' for a match.\n Argument : (optional) Match line characters ('*' by default)\n            (optional) Strong match char (':' by default)\n            (optional) Weak match char ('.' by default)\n\n\nsub match_line {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match\n\n Title     : match()\n Usage     : $ali->match()\n Function  : \n\n             Goes through all columns and changes residues that are\n             identical to residue in first sequence to match '.'\n             character. Sets match_char.\n\n             USE WITH CARE: Most MSE formats do not support match\n             characters in sequences, so this is mostly for output\n             only. NEXUS format (Bio::AlignIO::nexus) can handle\n             it.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub match {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 unmatch\n\n Title     : unmatch()\n Usage     : $ali->unmatch()\n Function  : \n\n             Undoes the effect of method match. Unsets match_char.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub unmatch {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head1 MSE attibutes\n\nMethods for setting and reading the MSE attributes. \n\nNote that the methods defining character semantics depend on the user\nto set them sensibly.  They are needed only by certain input/output\nmethods. Unset them by setting to an empty string ('').\n\n=head2 id\n\n Title     : id\n Usage     : $myalign->id(\"Ig\")\n Function  : Gets/sets the id field of the alignment\n Returns   : An id string\n Argument  : An id string (optional)\n\n\nsub id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 missing_char\n\n Title     : missing_char\n Usage     : $myalign->missing_char(\"?\")\n Function  : Gets/sets the missing_char attribute of the alignment\n             It is generally recommended to set it to 'n' or 'N' \n             for nucleotides and to 'X' for protein. \n Returns   : An missing_char string,\n Argument  : An missing_char string (optional)\n\n\nsub missing_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_char\n\n Title     : match_char\n Usage     : $myalign->match_char('.')\n Function  : Gets/sets the match_char attribute of the alignment\n Returns   : An match_char string,\n Argument  : An match_char string (optional)\n\n\nsub match_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 gap_char\n\n Title     : gap_char\n Usage     : $myalign->gap_char('-')\n Function  : Gets/sets the gap_char attribute of the alignment\n Returns   : An gap_char string, defaults to '-'\n Argument  : An gap_char string (optional)\n\n\nsub gap_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 symbol_chars\n\n Title   : symbol_chars\n Usage   : my @symbolchars = $aln->symbol_chars;\n Function: Returns all the seen symbols (other than gaps)\n Returns : array of characters that are the seen symbols\n Argument: boolean to include the gap/missing/match characters\n\n\nsub symbol_chars{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Alignment descriptors\n\nThese read only methods describe the MSE in various ways. \n\n\n=head2 consensus_string\n\n Title     : consensus_string\n Usage     : $str = $ali->consensus_string($threshold_percent)\n Function  : Makes a strict consensus \n Returns   : consensus string\n Argument  : Optional threshold ranging from 0 to 100.\n             The consensus residue has to appear at least threshold %\n             of the sequences at a given location, otherwise a '?'\n             character will be placed at that location.\n             (Default value = 0%)\n\n\nsub consensus_string {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 consensus_iupac\n\n Title     : consensus_iupac\n Usage     : $str = $ali->consensus_iupac()\n Function  : \n\n             Makes a consensus using IUPAC ambiguity codes from DNA\n             and RNA. The output is in upper case except when gaps in\n             a column force output to be in lower case.\n\n             Note that if your alignment sequences contain a lot of\n             IUPAC ambiquity codes you often have to manually set\n             alphabet.  Bio::PrimarySeq::_guess_type thinks they\n             indicate a protein sequence.\n\n Returns   : consensus string\n Argument  : none\n Throws    : on protein sequences\n\n\n\nsub consensus_iupac {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 is_flush\n\n Title     : is_flush\n Usage     : if( $ali->is_flush() )\n           : \n           :\n Function  : Tells you whether the alignment \n           : is flush, ie all of the same length\n           : \n           :\n Returns   : 1 or 0\n Argument  : \n\n\nsub is_flush {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 length\n\n Title     : length()\n Usage     : $len = $ali->length() \n Function  : Returns the maximum length of the alignment.\n             To be sure the alignment is a block, use is_flush\n Returns   : integer\n Argument  : \n\n\nsub length {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 maxname_length\n\n Title     : maxname_length\n Usage     : $ali->maxname_length()\n Function  : \n\n             Gets the maximum length of the displayname in the\n             alignment. Used in writing out various MSE formats.\n\n Returns   : integer\n Argument  : \n\n\nsub maxname_length {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 num_residues\n\n Title     : num_residues\n Usage     : $no = $ali->num_residues\n Function  : number of residues in total in the alignment\n Returns   : integer\n Argument  :\n Note      : replaces no_residues\n\n\nsub num_residues {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 num_sequences\n\n Title     : num_sequences\n Usage     : $depth = $ali->num_sequences\n Function  : number of sequence in the sequence alignment\n Returns   : integer\n Argument  : None\n Note      : replaces no_sequences\n\n\nsub num_sequences {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 percentage_identity\n\n Title   : percentage_identity\n Usage   : $id = $align->percentage_identity\n Function: The function calculates the percentage identity of the alignment\n Returns : The percentage identity of the alignment (as defined by the \n\t   implementation)\n Argument: None\n\n\nsub percentage_identity{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 overall_percentage_identity\n\n Title   : overall_percentage_identity\n Usage   : $id = $align->overall_percentage_identity\n Function: The function calculates the percentage identity of \n           the conserved columns\n Returns : The percentage identity of the conserved columns\n Args    : None\n\n\nsub overall_percentage_identity{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 average_percentage_identity\n\n Title   : average_percentage_identity\n Usage   : $id = $align->average_percentage_identity\n Function: The function uses a fast method to calculate the average \n           percentage identity of the alignment\n Returns : The average percentage identity of the alignment\n Args    : None\n\n\nsub average_percentage_identity{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Alignment positions\n\nMethods to map a sequence position into an alignment column and back.\ncolumn_from_residue_number() does the former. The latter is really a\nproperty of the sequence object and can done using\nL<Bio::LocatableSeq::location_from_column>:\n\n    # select somehow a sequence from the alignment, e.g.\n    my $seq = $aln->get_seq_by_pos(1);\n    #$loc is undef or Bio::LocationI object\n    my $loc = $seq->location_from_column(5);\n\n\n=head2 column_from_residue_number\n\n Title   : column_from_residue_number\n Usage   : $col = $ali->column_from_residue_number( $seqname, $resnumber)\n Function:\n\n           This function gives the position in the alignment\n           (i.e. column number) of the given residue number in the\n           sequence with the given name. For example, for the\n           alignment\n\n  \t     Seq1/91-97 AC..DEF.GH\n  \t     Seq2/24-30 ACGG.RTY..\n  \t     Seq3/43-51 AC.DDEFGHI\n\n           column_from_residue_number( \"Seq1\", 94 ) returns 6.\n           column_from_residue_number( \"Seq2\", 25 ) returns 2.\n           column_from_residue_number( \"Seq3\", 50 ) returns 9.\n\n           An exception is thrown if the residue number would lie\n           outside the length of the alignment\n           (e.g. column_from_residue_number( \"Seq2\", 22 )\n\n\t  Note: If the parent sequence is represented by more than one\n\t  alignment sequence and the residue number is present in\n\t  them, this method finds only the first one.\n\n Returns : A column number for the position in the alignment of the\n           given residue in the given sequence (1 = first column)\n Args    : A sequence id/name (not a name/start-end)\n           A residue number in the whole sequence (not just that\n           segment of it in the alignment)\n\n\nsub column_from_residue_number {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Sequence names\n\nMethods to manipulate the display name. The default name based on the\nsequence id and subsequence positions can be overridden in various\nways.\n\n=head2 displayname\n\n Title     : displayname\n Usage     : $myalign->displayname(\"Ig\", \"IgA\")\n Function  : Gets/sets the display name of a sequence in the alignment\n           :\n Returns   : A display name string\n Argument  : name of the sequence\n             displayname of the sequence (optional)"},"line":780,"range":{"start":{"character":0,"line":780},"end":{"character":9999,"line":783}},"kind":12},{"line":799,"kind":12,"range":{"end":{"line":802,"character":9999},"start":{"character":0,"line":799}},"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: AlignI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::AlignI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::AlignI - An interface for describing sequence alignments.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Align::AlignI somehow - typically using Bio::AlignIO system\n  # some descriptors\n  print $aln->length, \"\\n\";\n  print $aln->num_residues, \"\\n\";\n  print $aln->is_flush, \"\\n\";\n  print $aln->num_sequences, \"\\n\";\n  print $aln->percentage_identity, \"\\n\";\n  print $aln->consensus_string(50), \"\\n\";\n\n  # find the position in the alignment for a sequence location\n  $pos = $aln->column_from_residue_number('1433_LYCES', 14); # = 6;\n\n  # extract sequences and check values for the alignment column $pos\n  foreach $seq ($aln->each_seq) {\n      $res = $seq->subseq($pos, $pos);\n      $count{$res}++;\n  }\n  foreach $res (keys %count) {\n      printf \"Res: %s  Count: %2d\\n\", $res, $count{$res};\n  }\n\n=head1 DESCRIPTION\n\nThis interface describes the basis for alignment objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::AlignI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $myalign->add_seq($newseq);\n Function  : Adds another sequence to the alignment. *Does not* align\n             it - just adds it to the hashes.\n Returns   : None\n Argument  : a Bio::LocatableSeq object\n             order (optional)\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $aln->remove_seq($seq);\n Function  : Removes a single sequence from an alignment\n Returns   :\n Argument  : a Bio::LocatableSeq object\n\n\nsub remove_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 purge\n\n Title   : purge\n Usage   : $aln->purge(0.7);\n Function:\n\n           Removes sequences above whatever %id.\n\n           This function will grind on large alignments. Beware!\n           (perhaps not ideally implemented)\n\n Example :\n Returns : An array of the removed sequences\n Argument:\n\n\n\nsub purge {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 sort_alphabetically\n\n Title     : sort_alphabetically\n Usage     : $ali->sort_alphabetically\n Function  : \n\n             Changes the order of the alignment to alphabetical on name \n             followed by numerical by number.\n\n Returns   : an array\n Argument  : \n\n\nsub sort_alphabetically {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Sequence selection methods\n\nMethods returning one or more sequences objects.\n\n=head2 each_seq\n\n Title     : each_seq\n Usage     : foreach $seq ( $align->each_seq() ) \n Function  : Gets an array of Seq objects from the alignment\n Returns   : an array\n Argument  : \n\n\nsub each_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_alphabetically\n\n Title     : each_alphabetically\n Usage     : foreach $seq ( $ali->each_alphabetically() )\n Function  :\n\n             Returns an array of sequence object sorted alphabetically \n             by name and then by start point.\n             Does not change the order of the alignment\n\n Returns   : \n Argument  : \n\n\nsub each_alphabetically {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_seq_with_id\n\n Title     : each_seq_with_id\n Usage     : foreach $seq ( $align->each_seq_with_id() ) \n Function  : \n\n             Gets an array of Seq objects from the\n             alignment, the contents being those sequences\n             with the given name (there may be more than one)\n\n Returns   : an array\n Argument  : a seq name\n\n\nsub each_seq_with_id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 get_seq_by_pos\n\n Title     : get_seq_by_pos\n Usage     : $seq = $aln->get_seq_by_pos(3) # third sequence from the alignment\n Function  : \n\n             Gets a sequence based on its position in the alignment.\n             Numbering starts from 1.  Sequence positions larger than\n             num_sequences() will throw an error.\n\n Returns   : a Bio::LocatableSeq object\n Argument  : positive integer for the sequence position\n\n\nsub get_seq_by_pos {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Create new alignments\n\nThe result of these methods are horizontal or vertical subsets of the\ncurrent MSE.\n\n=head2 select\n\n Title     : select\n Usage     : $aln2 = $aln->select(1, 3) # three first sequences\n Function  : \n\n             Creates a new alignment from a continuous subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for the first sequence\n             positive integer for the last sequence to include (optional)\n\n\nsub select {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 select_noncont\n\n Title     : select_noncont\n Usage     : $aln2 = $aln->select_noncont(1, 3) # first and 3rd sequences\n Function  : \n\n             Creates a new alignment from a subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Args      : array of integers for the sequences\n\n\nsub select_noncont {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 slice\n\n Title     : slice\n Usage     : $aln2 = $aln->slice(20, 30)\n Function  : \n\n             Creates a slice from the alignment inclusive of start and\n             end columns.  Sequences with no residues in the slice are\n             excluded from the new alignment and a warning is printed.\n             Slice beyond the length of the sequence does not do\n             padding.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for start column \n             positive integer for end column \n\n\nsub slice {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Change sequences within the MSE\n\nThese methods affect characters in all sequences without changing the\nalignment.\n\n\n=head2 map_chars\n\n Title     : map_chars\n Usage     : $ali->map_chars('\\.','-')\n Function  : \n\n             Does a s/$arg1/$arg2/ on the sequences. Useful for gap\n             characters\n\n             Notice that the from (arg1) is interpreted as a regex,\n             so be careful about quoting meta characters (eg\n             $ali->map_chars('.','-') wont do what you want)\n\n Returns   : None\n Argument  : 'from' rexexp\n             'to' string\n\n\nsub map_chars {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 uppercase\n\n Title     : uppercase()\n Usage     : $ali->uppercase()\n Function  : Sets all the sequences to uppercase\n Returns   : \n Argument  : \n\n\nsub uppercase {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_line\n\n Title    : match_line()\n Usage    : $align->match_line()\n Function : Generates a match line - much like consensus string\n            except that a line indicating the '*' for a match.\n Argument : (optional) Match line characters ('*' by default)\n            (optional) Strong match char (':' by default)\n            (optional) Weak match char ('.' by default)\n\n\nsub match_line {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match\n\n Title     : match()\n Usage     : $ali->match()\n Function  : \n\n             Goes through all columns and changes residues that are\n             identical to residue in first sequence to match '.'\n             character. Sets match_char.\n\n             USE WITH CARE: Most MSE formats do not support match\n             characters in sequences, so this is mostly for output\n             only. NEXUS format (Bio::AlignIO::nexus) can handle\n             it.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub match {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 unmatch\n\n Title     : unmatch()\n Usage     : $ali->unmatch()\n Function  : \n\n             Undoes the effect of method match. Unsets match_char.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub unmatch {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head1 MSE attibutes\n\nMethods for setting and reading the MSE attributes. \n\nNote that the methods defining character semantics depend on the user\nto set them sensibly.  They are needed only by certain input/output\nmethods. Unset them by setting to an empty string ('').\n\n=head2 id\n\n Title     : id\n Usage     : $myalign->id(\"Ig\")\n Function  : Gets/sets the id field of the alignment\n Returns   : An id string\n Argument  : An id string (optional)\n\n\nsub id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 missing_char\n\n Title     : missing_char\n Usage     : $myalign->missing_char(\"?\")\n Function  : Gets/sets the missing_char attribute of the alignment\n             It is generally recommended to set it to 'n' or 'N' \n             for nucleotides and to 'X' for protein. \n Returns   : An missing_char string,\n Argument  : An missing_char string (optional)\n\n\nsub missing_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_char\n\n Title     : match_char\n Usage     : $myalign->match_char('.')\n Function  : Gets/sets the match_char attribute of the alignment\n Returns   : An match_char string,\n Argument  : An match_char string (optional)\n\n\nsub match_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 gap_char\n\n Title     : gap_char\n Usage     : $myalign->gap_char('-')\n Function  : Gets/sets the gap_char attribute of the alignment\n Returns   : An gap_char string, defaults to '-'\n Argument  : An gap_char string (optional)\n\n\nsub gap_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 symbol_chars\n\n Title   : symbol_chars\n Usage   : my @symbolchars = $aln->symbol_chars;\n Function: Returns all the seen symbols (other than gaps)\n Returns : array of characters that are the seen symbols\n Argument: boolean to include the gap/missing/match characters\n\n\nsub symbol_chars{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Alignment descriptors\n\nThese read only methods describe the MSE in various ways. \n\n\n=head2 consensus_string\n\n Title     : consensus_string\n Usage     : $str = $ali->consensus_string($threshold_percent)\n Function  : Makes a strict consensus \n Returns   : consensus string\n Argument  : Optional threshold ranging from 0 to 100.\n             The consensus residue has to appear at least threshold %\n             of the sequences at a given location, otherwise a '?'\n             character will be placed at that location.\n             (Default value = 0%)\n\n\nsub consensus_string {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 consensus_iupac\n\n Title     : consensus_iupac\n Usage     : $str = $ali->consensus_iupac()\n Function  : \n\n             Makes a consensus using IUPAC ambiguity codes from DNA\n             and RNA. The output is in upper case except when gaps in\n             a column force output to be in lower case.\n\n             Note that if your alignment sequences contain a lot of\n             IUPAC ambiquity codes you often have to manually set\n             alphabet.  Bio::PrimarySeq::_guess_type thinks they\n             indicate a protein sequence.\n\n Returns   : consensus string\n Argument  : none\n Throws    : on protein sequences\n\n\n\nsub consensus_iupac {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 is_flush\n\n Title     : is_flush\n Usage     : if( $ali->is_flush() )\n           : \n           :\n Function  : Tells you whether the alignment \n           : is flush, ie all of the same length\n           : \n           :\n Returns   : 1 or 0\n Argument  : \n\n\nsub is_flush {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 length\n\n Title     : length()\n Usage     : $len = $ali->length() \n Function  : Returns the maximum length of the alignment.\n             To be sure the alignment is a block, use is_flush\n Returns   : integer\n Argument  : \n\n\nsub length {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 maxname_length\n\n Title     : maxname_length\n Usage     : $ali->maxname_length()\n Function  : \n\n             Gets the maximum length of the displayname in the\n             alignment. Used in writing out various MSE formats.\n\n Returns   : integer\n Argument  : \n\n\nsub maxname_length {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 num_residues\n\n Title     : num_residues\n Usage     : $no = $ali->num_residues\n Function  : number of residues in total in the alignment\n Returns   : integer\n Argument  :\n Note      : replaces no_residues\n\n\nsub num_residues {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 num_sequences\n\n Title     : num_sequences\n Usage     : $depth = $ali->num_sequences\n Function  : number of sequence in the sequence alignment\n Returns   : integer\n Argument  : None\n Note      : replaces no_sequences\n\n\nsub num_sequences {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 percentage_identity\n\n Title   : percentage_identity\n Usage   : $id = $align->percentage_identity\n Function: The function calculates the percentage identity of the alignment\n Returns : The percentage identity of the alignment (as defined by the \n\t   implementation)\n Argument: None\n\n\nsub percentage_identity{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 overall_percentage_identity\n\n Title   : overall_percentage_identity\n Usage   : $id = $align->overall_percentage_identity\n Function: The function calculates the percentage identity of \n           the conserved columns\n Returns : The percentage identity of the conserved columns\n Args    : None\n\n\nsub overall_percentage_identity{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 average_percentage_identity\n\n Title   : average_percentage_identity\n Usage   : $id = $align->average_percentage_identity\n Function: The function uses a fast method to calculate the average \n           percentage identity of the alignment\n Returns : The average percentage identity of the alignment\n Args    : None\n\n\nsub average_percentage_identity{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Alignment positions\n\nMethods to map a sequence position into an alignment column and back.\ncolumn_from_residue_number() does the former. The latter is really a\nproperty of the sequence object and can done using\nL<Bio::LocatableSeq::location_from_column>:\n\n    # select somehow a sequence from the alignment, e.g.\n    my $seq = $aln->get_seq_by_pos(1);\n    #$loc is undef or Bio::LocationI object\n    my $loc = $seq->location_from_column(5);\n\n\n=head2 column_from_residue_number\n\n Title   : column_from_residue_number\n Usage   : $col = $ali->column_from_residue_number( $seqname, $resnumber)\n Function:\n\n           This function gives the position in the alignment\n           (i.e. column number) of the given residue number in the\n           sequence with the given name. For example, for the\n           alignment\n\n  \t     Seq1/91-97 AC..DEF.GH\n  \t     Seq2/24-30 ACGG.RTY..\n  \t     Seq3/43-51 AC.DDEFGHI\n\n           column_from_residue_number( \"Seq1\", 94 ) returns 6.\n           column_from_residue_number( \"Seq2\", 25 ) returns 2.\n           column_from_residue_number( \"Seq3\", 50 ) returns 9.\n\n           An exception is thrown if the residue number would lie\n           outside the length of the alignment\n           (e.g. column_from_residue_number( \"Seq2\", 22 )\n\n\t  Note: If the parent sequence is represented by more than one\n\t  alignment sequence and the residue number is present in\n\t  them, this method finds only the first one.\n\n Returns : A column number for the position in the alignment of the\n           given residue in the given sequence (1 = first column)\n Args    : A sequence id/name (not a name/start-end)\n           A residue number in the whole sequence (not just that\n           segment of it in the alignment)\n\n\nsub column_from_residue_number {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Sequence names\n\nMethods to manipulate the display name. The default name based on the\nsequence id and subsequence positions can be overridden in various\nways.\n\n=head2 displayname\n\n Title     : displayname\n Usage     : $myalign->displayname(\"Ig\", \"IgA\")\n Function  : Gets/sets the display name of a sequence in the alignment\n           :\n Returns   : A display name string\n Argument  : name of the sequence\n             displayname of the sequence (optional)\n\n\nsub displayname {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 set_displayname_count\n\n Title     : set_displayname_count\n Usage     : $ali->set_displayname_count\n Function  : \n\n             Sets the names to be name_# where # is the number of\n             times this name has been used.\n\n Returns   : None \n Argument  : None","label":"set_displayname_count($self)"},"children":[{"name":"$self","localvar":"my","containerName":"set_displayname_count","kind":13,"line":800,"definition":"my"},{"kind":13,"containerName":"set_displayname_count","name":"$self","line":801},{"line":801,"name":"throw_not_implemented","containerName":"set_displayname_count","kind":12}],"containerName":"main::","name":"set_displayname_count","definition":"sub","detail":"($self)"},{"containerName":"main::","name":"set_displayname_flat","children":[{"line":816,"name":"$self","localvar":"my","containerName":"set_displayname_flat","kind":13,"definition":"my"},{"line":817,"kind":13,"containerName":"set_displayname_flat","name":"$self"},{"line":817,"kind":12,"containerName":"set_displayname_flat","name":"throw_not_implemented"}],"detail":"($self)","definition":"sub","kind":12,"range":{"end":{"line":818,"character":9999},"start":{"character":0,"line":815}},"line":815,"signature":{"documentation":"1;\n# $Id: AlignI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::AlignI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::AlignI - An interface for describing sequence alignments.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Align::AlignI somehow - typically using Bio::AlignIO system\n  # some descriptors\n  print $aln->length, \"\\n\";\n  print $aln->num_residues, \"\\n\";\n  print $aln->is_flush, \"\\n\";\n  print $aln->num_sequences, \"\\n\";\n  print $aln->percentage_identity, \"\\n\";\n  print $aln->consensus_string(50), \"\\n\";\n\n  # find the position in the alignment for a sequence location\n  $pos = $aln->column_from_residue_number('1433_LYCES', 14); # = 6;\n\n  # extract sequences and check values for the alignment column $pos\n  foreach $seq ($aln->each_seq) {\n      $res = $seq->subseq($pos, $pos);\n      $count{$res}++;\n  }\n  foreach $res (keys %count) {\n      printf \"Res: %s  Count: %2d\\n\", $res, $count{$res};\n  }\n\n=head1 DESCRIPTION\n\nThis interface describes the basis for alignment objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::AlignI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $myalign->add_seq($newseq);\n Function  : Adds another sequence to the alignment. *Does not* align\n             it - just adds it to the hashes.\n Returns   : None\n Argument  : a Bio::LocatableSeq object\n             order (optional)\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $aln->remove_seq($seq);\n Function  : Removes a single sequence from an alignment\n Returns   :\n Argument  : a Bio::LocatableSeq object\n\n\nsub remove_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 purge\n\n Title   : purge\n Usage   : $aln->purge(0.7);\n Function:\n\n           Removes sequences above whatever %id.\n\n           This function will grind on large alignments. Beware!\n           (perhaps not ideally implemented)\n\n Example :\n Returns : An array of the removed sequences\n Argument:\n\n\n\nsub purge {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 sort_alphabetically\n\n Title     : sort_alphabetically\n Usage     : $ali->sort_alphabetically\n Function  : \n\n             Changes the order of the alignment to alphabetical on name \n             followed by numerical by number.\n\n Returns   : an array\n Argument  : \n\n\nsub sort_alphabetically {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Sequence selection methods\n\nMethods returning one or more sequences objects.\n\n=head2 each_seq\n\n Title     : each_seq\n Usage     : foreach $seq ( $align->each_seq() ) \n Function  : Gets an array of Seq objects from the alignment\n Returns   : an array\n Argument  : \n\n\nsub each_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_alphabetically\n\n Title     : each_alphabetically\n Usage     : foreach $seq ( $ali->each_alphabetically() )\n Function  :\n\n             Returns an array of sequence object sorted alphabetically \n             by name and then by start point.\n             Does not change the order of the alignment\n\n Returns   : \n Argument  : \n\n\nsub each_alphabetically {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_seq_with_id\n\n Title     : each_seq_with_id\n Usage     : foreach $seq ( $align->each_seq_with_id() ) \n Function  : \n\n             Gets an array of Seq objects from the\n             alignment, the contents being those sequences\n             with the given name (there may be more than one)\n\n Returns   : an array\n Argument  : a seq name\n\n\nsub each_seq_with_id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 get_seq_by_pos\n\n Title     : get_seq_by_pos\n Usage     : $seq = $aln->get_seq_by_pos(3) # third sequence from the alignment\n Function  : \n\n             Gets a sequence based on its position in the alignment.\n             Numbering starts from 1.  Sequence positions larger than\n             num_sequences() will throw an error.\n\n Returns   : a Bio::LocatableSeq object\n Argument  : positive integer for the sequence position\n\n\nsub get_seq_by_pos {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Create new alignments\n\nThe result of these methods are horizontal or vertical subsets of the\ncurrent MSE.\n\n=head2 select\n\n Title     : select\n Usage     : $aln2 = $aln->select(1, 3) # three first sequences\n Function  : \n\n             Creates a new alignment from a continuous subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for the first sequence\n             positive integer for the last sequence to include (optional)\n\n\nsub select {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 select_noncont\n\n Title     : select_noncont\n Usage     : $aln2 = $aln->select_noncont(1, 3) # first and 3rd sequences\n Function  : \n\n             Creates a new alignment from a subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Args      : array of integers for the sequences\n\n\nsub select_noncont {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 slice\n\n Title     : slice\n Usage     : $aln2 = $aln->slice(20, 30)\n Function  : \n\n             Creates a slice from the alignment inclusive of start and\n             end columns.  Sequences with no residues in the slice are\n             excluded from the new alignment and a warning is printed.\n             Slice beyond the length of the sequence does not do\n             padding.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for start column \n             positive integer for end column \n\n\nsub slice {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Change sequences within the MSE\n\nThese methods affect characters in all sequences without changing the\nalignment.\n\n\n=head2 map_chars\n\n Title     : map_chars\n Usage     : $ali->map_chars('\\.','-')\n Function  : \n\n             Does a s/$arg1/$arg2/ on the sequences. Useful for gap\n             characters\n\n             Notice that the from (arg1) is interpreted as a regex,\n             so be careful about quoting meta characters (eg\n             $ali->map_chars('.','-') wont do what you want)\n\n Returns   : None\n Argument  : 'from' rexexp\n             'to' string\n\n\nsub map_chars {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 uppercase\n\n Title     : uppercase()\n Usage     : $ali->uppercase()\n Function  : Sets all the sequences to uppercase\n Returns   : \n Argument  : \n\n\nsub uppercase {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_line\n\n Title    : match_line()\n Usage    : $align->match_line()\n Function : Generates a match line - much like consensus string\n            except that a line indicating the '*' for a match.\n Argument : (optional) Match line characters ('*' by default)\n            (optional) Strong match char (':' by default)\n            (optional) Weak match char ('.' by default)\n\n\nsub match_line {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match\n\n Title     : match()\n Usage     : $ali->match()\n Function  : \n\n             Goes through all columns and changes residues that are\n             identical to residue in first sequence to match '.'\n             character. Sets match_char.\n\n             USE WITH CARE: Most MSE formats do not support match\n             characters in sequences, so this is mostly for output\n             only. NEXUS format (Bio::AlignIO::nexus) can handle\n             it.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub match {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 unmatch\n\n Title     : unmatch()\n Usage     : $ali->unmatch()\n Function  : \n\n             Undoes the effect of method match. Unsets match_char.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub unmatch {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head1 MSE attibutes\n\nMethods for setting and reading the MSE attributes. \n\nNote that the methods defining character semantics depend on the user\nto set them sensibly.  They are needed only by certain input/output\nmethods. Unset them by setting to an empty string ('').\n\n=head2 id\n\n Title     : id\n Usage     : $myalign->id(\"Ig\")\n Function  : Gets/sets the id field of the alignment\n Returns   : An id string\n Argument  : An id string (optional)\n\n\nsub id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 missing_char\n\n Title     : missing_char\n Usage     : $myalign->missing_char(\"?\")\n Function  : Gets/sets the missing_char attribute of the alignment\n             It is generally recommended to set it to 'n' or 'N' \n             for nucleotides and to 'X' for protein. \n Returns   : An missing_char string,\n Argument  : An missing_char string (optional)\n\n\nsub missing_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_char\n\n Title     : match_char\n Usage     : $myalign->match_char('.')\n Function  : Gets/sets the match_char attribute of the alignment\n Returns   : An match_char string,\n Argument  : An match_char string (optional)\n\n\nsub match_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 gap_char\n\n Title     : gap_char\n Usage     : $myalign->gap_char('-')\n Function  : Gets/sets the gap_char attribute of the alignment\n Returns   : An gap_char string, defaults to '-'\n Argument  : An gap_char string (optional)\n\n\nsub gap_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 symbol_chars\n\n Title   : symbol_chars\n Usage   : my @symbolchars = $aln->symbol_chars;\n Function: Returns all the seen symbols (other than gaps)\n Returns : array of characters that are the seen symbols\n Argument: boolean to include the gap/missing/match characters\n\n\nsub symbol_chars{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Alignment descriptors\n\nThese read only methods describe the MSE in various ways. \n\n\n=head2 consensus_string\n\n Title     : consensus_string\n Usage     : $str = $ali->consensus_string($threshold_percent)\n Function  : Makes a strict consensus \n Returns   : consensus string\n Argument  : Optional threshold ranging from 0 to 100.\n             The consensus residue has to appear at least threshold %\n             of the sequences at a given location, otherwise a '?'\n             character will be placed at that location.\n             (Default value = 0%)\n\n\nsub consensus_string {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 consensus_iupac\n\n Title     : consensus_iupac\n Usage     : $str = $ali->consensus_iupac()\n Function  : \n\n             Makes a consensus using IUPAC ambiguity codes from DNA\n             and RNA. The output is in upper case except when gaps in\n             a column force output to be in lower case.\n\n             Note that if your alignment sequences contain a lot of\n             IUPAC ambiquity codes you often have to manually set\n             alphabet.  Bio::PrimarySeq::_guess_type thinks they\n             indicate a protein sequence.\n\n Returns   : consensus string\n Argument  : none\n Throws    : on protein sequences\n\n\n\nsub consensus_iupac {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 is_flush\n\n Title     : is_flush\n Usage     : if( $ali->is_flush() )\n           : \n           :\n Function  : Tells you whether the alignment \n           : is flush, ie all of the same length\n           : \n           :\n Returns   : 1 or 0\n Argument  : \n\n\nsub is_flush {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 length\n\n Title     : length()\n Usage     : $len = $ali->length() \n Function  : Returns the maximum length of the alignment.\n             To be sure the alignment is a block, use is_flush\n Returns   : integer\n Argument  : \n\n\nsub length {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 maxname_length\n\n Title     : maxname_length\n Usage     : $ali->maxname_length()\n Function  : \n\n             Gets the maximum length of the displayname in the\n             alignment. Used in writing out various MSE formats.\n\n Returns   : integer\n Argument  : \n\n\nsub maxname_length {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 num_residues\n\n Title     : num_residues\n Usage     : $no = $ali->num_residues\n Function  : number of residues in total in the alignment\n Returns   : integer\n Argument  :\n Note      : replaces no_residues\n\n\nsub num_residues {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 num_sequences\n\n Title     : num_sequences\n Usage     : $depth = $ali->num_sequences\n Function  : number of sequence in the sequence alignment\n Returns   : integer\n Argument  : None\n Note      : replaces no_sequences\n\n\nsub num_sequences {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 percentage_identity\n\n Title   : percentage_identity\n Usage   : $id = $align->percentage_identity\n Function: The function calculates the percentage identity of the alignment\n Returns : The percentage identity of the alignment (as defined by the \n\t   implementation)\n Argument: None\n\n\nsub percentage_identity{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 overall_percentage_identity\n\n Title   : overall_percentage_identity\n Usage   : $id = $align->overall_percentage_identity\n Function: The function calculates the percentage identity of \n           the conserved columns\n Returns : The percentage identity of the conserved columns\n Args    : None\n\n\nsub overall_percentage_identity{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 average_percentage_identity\n\n Title   : average_percentage_identity\n Usage   : $id = $align->average_percentage_identity\n Function: The function uses a fast method to calculate the average \n           percentage identity of the alignment\n Returns : The average percentage identity of the alignment\n Args    : None\n\n\nsub average_percentage_identity{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Alignment positions\n\nMethods to map a sequence position into an alignment column and back.\ncolumn_from_residue_number() does the former. The latter is really a\nproperty of the sequence object and can done using\nL<Bio::LocatableSeq::location_from_column>:\n\n    # select somehow a sequence from the alignment, e.g.\n    my $seq = $aln->get_seq_by_pos(1);\n    #$loc is undef or Bio::LocationI object\n    my $loc = $seq->location_from_column(5);\n\n\n=head2 column_from_residue_number\n\n Title   : column_from_residue_number\n Usage   : $col = $ali->column_from_residue_number( $seqname, $resnumber)\n Function:\n\n           This function gives the position in the alignment\n           (i.e. column number) of the given residue number in the\n           sequence with the given name. For example, for the\n           alignment\n\n  \t     Seq1/91-97 AC..DEF.GH\n  \t     Seq2/24-30 ACGG.RTY..\n  \t     Seq3/43-51 AC.DDEFGHI\n\n           column_from_residue_number( \"Seq1\", 94 ) returns 6.\n           column_from_residue_number( \"Seq2\", 25 ) returns 2.\n           column_from_residue_number( \"Seq3\", 50 ) returns 9.\n\n           An exception is thrown if the residue number would lie\n           outside the length of the alignment\n           (e.g. column_from_residue_number( \"Seq2\", 22 )\n\n\t  Note: If the parent sequence is represented by more than one\n\t  alignment sequence and the residue number is present in\n\t  them, this method finds only the first one.\n\n Returns : A column number for the position in the alignment of the\n           given residue in the given sequence (1 = first column)\n Args    : A sequence id/name (not a name/start-end)\n           A residue number in the whole sequence (not just that\n           segment of it in the alignment)\n\n\nsub column_from_residue_number {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Sequence names\n\nMethods to manipulate the display name. The default name based on the\nsequence id and subsequence positions can be overridden in various\nways.\n\n=head2 displayname\n\n Title     : displayname\n Usage     : $myalign->displayname(\"Ig\", \"IgA\")\n Function  : Gets/sets the display name of a sequence in the alignment\n           :\n Returns   : A display name string\n Argument  : name of the sequence\n             displayname of the sequence (optional)\n\n\nsub displayname {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 set_displayname_count\n\n Title     : set_displayname_count\n Usage     : $ali->set_displayname_count\n Function  : \n\n             Sets the names to be name_# where # is the number of\n             times this name has been used.\n\n Returns   : None \n Argument  : None\n\n\nsub set_displayname_count {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 set_displayname_flat\n\n Title     : set_displayname_flat\n Usage     : $ali->set_displayname_flat()\n Function  : Makes all the sequences be displayed as just their name,\n             not name/start-end\n Returns   : 1\n Argument  : None","parameters":[{"label":"$self"}],"label":"set_displayname_flat($self)"}},{"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: AlignI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::AlignI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::AlignI - An interface for describing sequence alignments.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Align::AlignI somehow - typically using Bio::AlignIO system\n  # some descriptors\n  print $aln->length, \"\\n\";\n  print $aln->num_residues, \"\\n\";\n  print $aln->is_flush, \"\\n\";\n  print $aln->num_sequences, \"\\n\";\n  print $aln->percentage_identity, \"\\n\";\n  print $aln->consensus_string(50), \"\\n\";\n\n  # find the position in the alignment for a sequence location\n  $pos = $aln->column_from_residue_number('1433_LYCES', 14); # = 6;\n\n  # extract sequences and check values for the alignment column $pos\n  foreach $seq ($aln->each_seq) {\n      $res = $seq->subseq($pos, $pos);\n      $count{$res}++;\n  }\n  foreach $res (keys %count) {\n      printf \"Res: %s  Count: %2d\\n\", $res, $count{$res};\n  }\n\n=head1 DESCRIPTION\n\nThis interface describes the basis for alignment objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::AlignI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $myalign->add_seq($newseq);\n Function  : Adds another sequence to the alignment. *Does not* align\n             it - just adds it to the hashes.\n Returns   : None\n Argument  : a Bio::LocatableSeq object\n             order (optional)\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $aln->remove_seq($seq);\n Function  : Removes a single sequence from an alignment\n Returns   :\n Argument  : a Bio::LocatableSeq object\n\n\nsub remove_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 purge\n\n Title   : purge\n Usage   : $aln->purge(0.7);\n Function:\n\n           Removes sequences above whatever %id.\n\n           This function will grind on large alignments. Beware!\n           (perhaps not ideally implemented)\n\n Example :\n Returns : An array of the removed sequences\n Argument:\n\n\n\nsub purge {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 sort_alphabetically\n\n Title     : sort_alphabetically\n Usage     : $ali->sort_alphabetically\n Function  : \n\n             Changes the order of the alignment to alphabetical on name \n             followed by numerical by number.\n\n Returns   : an array\n Argument  : \n\n\nsub sort_alphabetically {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Sequence selection methods\n\nMethods returning one or more sequences objects.\n\n=head2 each_seq\n\n Title     : each_seq\n Usage     : foreach $seq ( $align->each_seq() ) \n Function  : Gets an array of Seq objects from the alignment\n Returns   : an array\n Argument  : \n\n\nsub each_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_alphabetically\n\n Title     : each_alphabetically\n Usage     : foreach $seq ( $ali->each_alphabetically() )\n Function  :\n\n             Returns an array of sequence object sorted alphabetically \n             by name and then by start point.\n             Does not change the order of the alignment\n\n Returns   : \n Argument  : \n\n\nsub each_alphabetically {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_seq_with_id\n\n Title     : each_seq_with_id\n Usage     : foreach $seq ( $align->each_seq_with_id() ) \n Function  : \n\n             Gets an array of Seq objects from the\n             alignment, the contents being those sequences\n             with the given name (there may be more than one)\n\n Returns   : an array\n Argument  : a seq name\n\n\nsub each_seq_with_id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 get_seq_by_pos\n\n Title     : get_seq_by_pos\n Usage     : $seq = $aln->get_seq_by_pos(3) # third sequence from the alignment\n Function  : \n\n             Gets a sequence based on its position in the alignment.\n             Numbering starts from 1.  Sequence positions larger than\n             num_sequences() will throw an error.\n\n Returns   : a Bio::LocatableSeq object\n Argument  : positive integer for the sequence position\n\n\nsub get_seq_by_pos {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Create new alignments\n\nThe result of these methods are horizontal or vertical subsets of the\ncurrent MSE.\n\n=head2 select\n\n Title     : select\n Usage     : $aln2 = $aln->select(1, 3) # three first sequences\n Function  : \n\n             Creates a new alignment from a continuous subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for the first sequence\n             positive integer for the last sequence to include (optional)\n\n\nsub select {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 select_noncont\n\n Title     : select_noncont\n Usage     : $aln2 = $aln->select_noncont(1, 3) # first and 3rd sequences\n Function  : \n\n             Creates a new alignment from a subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Args      : array of integers for the sequences\n\n\nsub select_noncont {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 slice\n\n Title     : slice\n Usage     : $aln2 = $aln->slice(20, 30)\n Function  : \n\n             Creates a slice from the alignment inclusive of start and\n             end columns.  Sequences with no residues in the slice are\n             excluded from the new alignment and a warning is printed.\n             Slice beyond the length of the sequence does not do\n             padding.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for start column \n             positive integer for end column \n\n\nsub slice {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Change sequences within the MSE\n\nThese methods affect characters in all sequences without changing the\nalignment.\n\n\n=head2 map_chars\n\n Title     : map_chars\n Usage     : $ali->map_chars('\\.','-')\n Function  : \n\n             Does a s/$arg1/$arg2/ on the sequences. Useful for gap\n             characters\n\n             Notice that the from (arg1) is interpreted as a regex,\n             so be careful about quoting meta characters (eg\n             $ali->map_chars('.','-') wont do what you want)\n\n Returns   : None\n Argument  : 'from' rexexp\n             'to' string\n\n\nsub map_chars {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 uppercase\n\n Title     : uppercase()\n Usage     : $ali->uppercase()\n Function  : Sets all the sequences to uppercase\n Returns   : \n Argument  : \n\n\nsub uppercase {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_line\n\n Title    : match_line()\n Usage    : $align->match_line()\n Function : Generates a match line - much like consensus string\n            except that a line indicating the '*' for a match.\n Argument : (optional) Match line characters ('*' by default)\n            (optional) Strong match char (':' by default)\n            (optional) Weak match char ('.' by default)\n\n\nsub match_line {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match\n\n Title     : match()\n Usage     : $ali->match()\n Function  : \n\n             Goes through all columns and changes residues that are\n             identical to residue in first sequence to match '.'\n             character. Sets match_char.\n\n             USE WITH CARE: Most MSE formats do not support match\n             characters in sequences, so this is mostly for output\n             only. NEXUS format (Bio::AlignIO::nexus) can handle\n             it.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub match {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 unmatch\n\n Title     : unmatch()\n Usage     : $ali->unmatch()\n Function  : \n\n             Undoes the effect of method match. Unsets match_char.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub unmatch {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head1 MSE attibutes\n\nMethods for setting and reading the MSE attributes. \n\nNote that the methods defining character semantics depend on the user\nto set them sensibly.  They are needed only by certain input/output\nmethods. Unset them by setting to an empty string ('').\n\n=head2 id\n\n Title     : id\n Usage     : $myalign->id(\"Ig\")\n Function  : Gets/sets the id field of the alignment\n Returns   : An id string\n Argument  : An id string (optional)\n\n\nsub id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 missing_char\n\n Title     : missing_char\n Usage     : $myalign->missing_char(\"?\")\n Function  : Gets/sets the missing_char attribute of the alignment\n             It is generally recommended to set it to 'n' or 'N' \n             for nucleotides and to 'X' for protein. \n Returns   : An missing_char string,\n Argument  : An missing_char string (optional)\n\n\nsub missing_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_char\n\n Title     : match_char\n Usage     : $myalign->match_char('.')\n Function  : Gets/sets the match_char attribute of the alignment\n Returns   : An match_char string,\n Argument  : An match_char string (optional)\n\n\nsub match_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 gap_char\n\n Title     : gap_char\n Usage     : $myalign->gap_char('-')\n Function  : Gets/sets the gap_char attribute of the alignment\n Returns   : An gap_char string, defaults to '-'\n Argument  : An gap_char string (optional)\n\n\nsub gap_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 symbol_chars\n\n Title   : symbol_chars\n Usage   : my @symbolchars = $aln->symbol_chars;\n Function: Returns all the seen symbols (other than gaps)\n Returns : array of characters that are the seen symbols\n Argument: boolean to include the gap/missing/match characters\n\n\nsub symbol_chars{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Alignment descriptors\n\nThese read only methods describe the MSE in various ways. \n\n\n=head2 consensus_string\n\n Title     : consensus_string\n Usage     : $str = $ali->consensus_string($threshold_percent)\n Function  : Makes a strict consensus \n Returns   : consensus string\n Argument  : Optional threshold ranging from 0 to 100.\n             The consensus residue has to appear at least threshold %\n             of the sequences at a given location, otherwise a '?'\n             character will be placed at that location.\n             (Default value = 0%)\n\n\nsub consensus_string {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 consensus_iupac\n\n Title     : consensus_iupac\n Usage     : $str = $ali->consensus_iupac()\n Function  : \n\n             Makes a consensus using IUPAC ambiguity codes from DNA\n             and RNA. The output is in upper case except when gaps in\n             a column force output to be in lower case.\n\n             Note that if your alignment sequences contain a lot of\n             IUPAC ambiquity codes you often have to manually set\n             alphabet.  Bio::PrimarySeq::_guess_type thinks they\n             indicate a protein sequence.\n\n Returns   : consensus string\n Argument  : none\n Throws    : on protein sequences\n\n\n\nsub consensus_iupac {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 is_flush\n\n Title     : is_flush\n Usage     : if( $ali->is_flush() )\n           : \n           :\n Function  : Tells you whether the alignment \n           : is flush, ie all of the same length\n           : \n           :\n Returns   : 1 or 0\n Argument  : \n\n\nsub is_flush {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 length\n\n Title     : length()\n Usage     : $len = $ali->length() \n Function  : Returns the maximum length of the alignment.\n             To be sure the alignment is a block, use is_flush\n Returns   : integer\n Argument  : \n\n\nsub length {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 maxname_length\n\n Title     : maxname_length\n Usage     : $ali->maxname_length()\n Function  : \n\n             Gets the maximum length of the displayname in the\n             alignment. Used in writing out various MSE formats.\n\n Returns   : integer\n Argument  : \n\n\nsub maxname_length {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 num_residues\n\n Title     : num_residues\n Usage     : $no = $ali->num_residues\n Function  : number of residues in total in the alignment\n Returns   : integer\n Argument  :\n Note      : replaces no_residues\n\n\nsub num_residues {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 num_sequences\n\n Title     : num_sequences\n Usage     : $depth = $ali->num_sequences\n Function  : number of sequence in the sequence alignment\n Returns   : integer\n Argument  : None\n Note      : replaces no_sequences\n\n\nsub num_sequences {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 percentage_identity\n\n Title   : percentage_identity\n Usage   : $id = $align->percentage_identity\n Function: The function calculates the percentage identity of the alignment\n Returns : The percentage identity of the alignment (as defined by the \n\t   implementation)\n Argument: None\n\n\nsub percentage_identity{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 overall_percentage_identity\n\n Title   : overall_percentage_identity\n Usage   : $id = $align->overall_percentage_identity\n Function: The function calculates the percentage identity of \n           the conserved columns\n Returns : The percentage identity of the conserved columns\n Args    : None\n\n\nsub overall_percentage_identity{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 average_percentage_identity\n\n Title   : average_percentage_identity\n Usage   : $id = $align->average_percentage_identity\n Function: The function uses a fast method to calculate the average \n           percentage identity of the alignment\n Returns : The average percentage identity of the alignment\n Args    : None\n\n\nsub average_percentage_identity{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Alignment positions\n\nMethods to map a sequence position into an alignment column and back.\ncolumn_from_residue_number() does the former. The latter is really a\nproperty of the sequence object and can done using\nL<Bio::LocatableSeq::location_from_column>:\n\n    # select somehow a sequence from the alignment, e.g.\n    my $seq = $aln->get_seq_by_pos(1);\n    #$loc is undef or Bio::LocationI object\n    my $loc = $seq->location_from_column(5);\n\n\n=head2 column_from_residue_number\n\n Title   : column_from_residue_number\n Usage   : $col = $ali->column_from_residue_number( $seqname, $resnumber)\n Function:\n\n           This function gives the position in the alignment\n           (i.e. column number) of the given residue number in the\n           sequence with the given name. For example, for the\n           alignment\n\n  \t     Seq1/91-97 AC..DEF.GH\n  \t     Seq2/24-30 ACGG.RTY..\n  \t     Seq3/43-51 AC.DDEFGHI\n\n           column_from_residue_number( \"Seq1\", 94 ) returns 6.\n           column_from_residue_number( \"Seq2\", 25 ) returns 2.\n           column_from_residue_number( \"Seq3\", 50 ) returns 9.\n\n           An exception is thrown if the residue number would lie\n           outside the length of the alignment\n           (e.g. column_from_residue_number( \"Seq2\", 22 )\n\n\t  Note: If the parent sequence is represented by more than one\n\t  alignment sequence and the residue number is present in\n\t  them, this method finds only the first one.\n\n Returns : A column number for the position in the alignment of the\n           given residue in the given sequence (1 = first column)\n Args    : A sequence id/name (not a name/start-end)\n           A residue number in the whole sequence (not just that\n           segment of it in the alignment)\n\n\nsub column_from_residue_number {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Sequence names\n\nMethods to manipulate the display name. The default name based on the\nsequence id and subsequence positions can be overridden in various\nways.\n\n=head2 displayname\n\n Title     : displayname\n Usage     : $myalign->displayname(\"Ig\", \"IgA\")\n Function  : Gets/sets the display name of a sequence in the alignment\n           :\n Returns   : A display name string\n Argument  : name of the sequence\n             displayname of the sequence (optional)\n\n\nsub displayname {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 set_displayname_count\n\n Title     : set_displayname_count\n Usage     : $ali->set_displayname_count\n Function  : \n\n             Sets the names to be name_# where # is the number of\n             times this name has been used.\n\n Returns   : None \n Argument  : None\n\n\nsub set_displayname_count {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 set_displayname_flat\n\n Title     : set_displayname_flat\n Usage     : $ali->set_displayname_flat()\n Function  : Makes all the sequences be displayed as just their name,\n             not name/start-end\n Returns   : 1\n Argument  : None\n\n\nsub set_displayname_flat {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 set_displayname_normal\n\n Title     : set_displayname_normal\n Usage     : $ali->set_displayname_normal() \n Function  : Makes all the sequences be displayed as name/start-end\n Returns   : None\n Argument  : None","label":"set_displayname_normal($self)"},"kind":12,"range":{"start":{"line":830,"character":0},"end":{"character":9999,"line":833}},"line":830,"detail":"($self)","definition":"sub","name":"set_displayname_normal","containerName":"main::","children":[{"line":831,"containerName":"set_displayname_normal","localvar":"my","kind":13,"name":"$self","definition":"my"},{"name":"$self","kind":13,"containerName":"set_displayname_normal","line":832},{"line":832,"name":"throw_not_implemented","kind":12,"containerName":"set_displayname_normal"}]},{"definition":"sub","children":[{"line":850,"containerName":"no_residues","kind":12,"name":"deprecated"}],"name":"no_residues","containerName":"main::","line":848,"range":{"start":{"character":0,"line":848},"end":{"line":851,"character":9999}},"kind":12},{"definition":"sub","children":[{"line":866,"kind":12,"containerName":"no_sequences","name":"deprecated"}],"name":"no_sequences","containerName":"main::","line":864,"range":{"start":{"line":864,"character":0},"end":{"character":9999,"line":867}},"kind":12}],"version":5}