{"version":5,"vars":[{"kind":2,"line":141,"name":"base","containerName":""},{"range":{"start":{"character":0,"line":163},"end":{"character":9999,"line":166}},"name":"seq","children":[{"kind":13,"line":164,"containerName":"seq","definition":"my","name":"$self","localvar":"my"},{"kind":13,"line":165,"name":"$self","containerName":"seq"},{"kind":12,"line":165,"name":"throw_not_implemented","containerName":"seq"}],"line":163,"kind":12,"signature":{"documentation":"1;\n# $Id: PrimarySeqI.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::PrimarySeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PrimarySeqI [Developers] - Interface definition for a Bio::PrimarySeq\n\n=head1 SYNOPSIS\n\n\n    # Bio::PrimarySeqI is the interface class for sequences.\n\n    # If you are a newcomer to bioperl, you should\n    # start with Bio::Seq documentation. This\n    # documentation is mainly for developers using\n    # Bioperl.\n\n    # to test this is a seq object\n\n    $obj->isa(\"Bio::PrimarySeqI\") ||\n      $obj->throw(\"$obj does not implement the Bio::PrimarySeqI interface\");\n\n    # accessors\n\n    $string    = $obj->seq();\n    $substring = $obj->subseq(12,50);\n    $display   = $obj->display_id(); # for human display\n    $id        = $obj->primary_id(); # unique id for this object,\n                                     # implementation defined\n    $unique_key= $obj->accession_number();\n                       # unique biological id\n\n    # object manipulation\n\n    eval {\n\t$rev    = $obj->revcom();\n    };\n    if( $@ ) {\n\t$obj->throw(-class => 'Bio::Root::Exception',\n                    -text => \"Could not reverse complement. \".\n\t\t             \"Probably not DNA. Actual exception\\n$@\\n\",\n                    -value => $@);\n    }\n\n    $trunc = $obj->trunc(12,50);\n\n    # $rev and $trunc are Bio::PrimarySeqI compliant objects\n\n\n=head1 DESCRIPTION\n\nThis object defines an abstract interface to basic sequence\ninformation - for most users of the package the documentation (and\nmethods) in this class are not useful - this is a developers only\nclass which defines what methods have to be implmented by other Perl\nobjects to comply to the Bio::PrimarySeqI interface. Go \"perldoc\nBio::Seq\" or \"man Bio::Seq\" for more information on the main class for\nsequences.\n\n\nPrimarySeq is an object just for the sequence and its name(s), nothing\nmore. Seq is the larger object complete with features. There is a pure\nperl implementation of this in Bio::PrimarySeq. If you just want to\nuse Bio::PrimarySeq objects, then please read that module first. This\nmodule defines the interface, and is of more interest to people who\nwant to wrap their own Perl Objects/RDBs/FileSystems etc in way that\nthey \"are\" bioperl sequence objects, even though it is not using Perl\nto store the sequence etc.\n\n\nThis interface defines what bioperl consideres necessary to \"be\" a\nsequence, without providing an implementation of this. (An\nimplementation is provided in Bio::PrimarySeq). If you want to provide\na Bio::PrimarySeq 'compliant' object which in fact wraps another\nobject/database/out-of-perl experience, then this is the correct thing\nto wrap, generally by providing a wrapper class which would inheriet\nfrom your object and this Bio::PrimarySeqI interface. The wrapper class\nthen would have methods lists in the \"Implementation Specific\nFunctions\" which would provide these methods for your object.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n \nPlease direct usage questions or support issues to the mailing list:\n  \nL<bioperl-l@bioperl.org>\n  \nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@sanger.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PrimarySeqI;\nuse strict;\nuse Bio::Tools::CodonTable;\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Implementation Specific Functions\n\nThese functions are the ones that a specific implementation must\ndefine.\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard),\n           but implementations are suggested to keep an open mind about\n           case (some users... want mixed case!)\n Returns : A scalar\n Status  : Virtual","parameters":[{"label":"$self"}],"label":"seq($self)"},"detail":"($self)","definition":"sub","containerName":"main::"},{"containerName":"main::","definition":"sub","detail":"($self)","signature":{"documentation":"1;\n# $Id: PrimarySeqI.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::PrimarySeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PrimarySeqI [Developers] - Interface definition for a Bio::PrimarySeq\n\n=head1 SYNOPSIS\n\n\n    # Bio::PrimarySeqI is the interface class for sequences.\n\n    # If you are a newcomer to bioperl, you should\n    # start with Bio::Seq documentation. This\n    # documentation is mainly for developers using\n    # Bioperl.\n\n    # to test this is a seq object\n\n    $obj->isa(\"Bio::PrimarySeqI\") ||\n      $obj->throw(\"$obj does not implement the Bio::PrimarySeqI interface\");\n\n    # accessors\n\n    $string    = $obj->seq();\n    $substring = $obj->subseq(12,50);\n    $display   = $obj->display_id(); # for human display\n    $id        = $obj->primary_id(); # unique id for this object,\n                                     # implementation defined\n    $unique_key= $obj->accession_number();\n                       # unique biological id\n\n    # object manipulation\n\n    eval {\n\t$rev    = $obj->revcom();\n    };\n    if( $@ ) {\n\t$obj->throw(-class => 'Bio::Root::Exception',\n                    -text => \"Could not reverse complement. \".\n\t\t             \"Probably not DNA. Actual exception\\n$@\\n\",\n                    -value => $@);\n    }\n\n    $trunc = $obj->trunc(12,50);\n\n    # $rev and $trunc are Bio::PrimarySeqI compliant objects\n\n\n=head1 DESCRIPTION\n\nThis object defines an abstract interface to basic sequence\ninformation - for most users of the package the documentation (and\nmethods) in this class are not useful - this is a developers only\nclass which defines what methods have to be implmented by other Perl\nobjects to comply to the Bio::PrimarySeqI interface. Go \"perldoc\nBio::Seq\" or \"man Bio::Seq\" for more information on the main class for\nsequences.\n\n\nPrimarySeq is an object just for the sequence and its name(s), nothing\nmore. Seq is the larger object complete with features. There is a pure\nperl implementation of this in Bio::PrimarySeq. If you just want to\nuse Bio::PrimarySeq objects, then please read that module first. This\nmodule defines the interface, and is of more interest to people who\nwant to wrap their own Perl Objects/RDBs/FileSystems etc in way that\nthey \"are\" bioperl sequence objects, even though it is not using Perl\nto store the sequence etc.\n\n\nThis interface defines what bioperl consideres necessary to \"be\" a\nsequence, without providing an implementation of this. (An\nimplementation is provided in Bio::PrimarySeq). If you want to provide\na Bio::PrimarySeq 'compliant' object which in fact wraps another\nobject/database/out-of-perl experience, then this is the correct thing\nto wrap, generally by providing a wrapper class which would inheriet\nfrom your object and this Bio::PrimarySeqI interface. The wrapper class\nthen would have methods lists in the \"Implementation Specific\nFunctions\" which would provide these methods for your object.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n \nPlease direct usage questions or support issues to the mailing list:\n  \nL<bioperl-l@bioperl.org>\n  \nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@sanger.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PrimarySeqI;\nuse strict;\nuse Bio::Tools::CodonTable;\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Implementation Specific Functions\n\nThese functions are the ones that a specific implementation must\ndefine.\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard),\n           but implementations are suggested to keep an open mind about\n           case (some users... want mixed case!)\n Returns : A scalar\n Status  : Virtual\n\n\nsub seq {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n Function: returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n\n           Start cannot be larger than end but can be equal\n\n Returns : a string\n Args    :\n Status  : Virtual","parameters":[{"label":"$self"}],"label":"subseq($self)"},"kind":12,"line":184,"children":[{"kind":13,"line":185,"name":"$self","definition":"my","containerName":"subseq","localvar":"my"},{"containerName":"subseq","name":"$self","line":186,"kind":13},{"name":"throw_not_implemented","containerName":"subseq","kind":12,"line":186}],"name":"subseq","range":{"start":{"character":0,"line":184},"end":{"line":187,"character":9999}}},{"range":{"start":{"character":0,"line":215},"end":{"line":218,"character":9999}},"name":"display_id","line":215,"children":[{"line":216,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"display_id"},{"kind":13,"line":217,"name":"$self","containerName":"display_id"},{"kind":12,"line":217,"name":"throw_not_implemented","containerName":"display_id"}],"kind":12,"detail":"($self)","signature":{"label":"display_id($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: PrimarySeqI.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::PrimarySeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PrimarySeqI [Developers] - Interface definition for a Bio::PrimarySeq\n\n=head1 SYNOPSIS\n\n\n    # Bio::PrimarySeqI is the interface class for sequences.\n\n    # If you are a newcomer to bioperl, you should\n    # start with Bio::Seq documentation. This\n    # documentation is mainly for developers using\n    # Bioperl.\n\n    # to test this is a seq object\n\n    $obj->isa(\"Bio::PrimarySeqI\") ||\n      $obj->throw(\"$obj does not implement the Bio::PrimarySeqI interface\");\n\n    # accessors\n\n    $string    = $obj->seq();\n    $substring = $obj->subseq(12,50);\n    $display   = $obj->display_id(); # for human display\n    $id        = $obj->primary_id(); # unique id for this object,\n                                     # implementation defined\n    $unique_key= $obj->accession_number();\n                       # unique biological id\n\n    # object manipulation\n\n    eval {\n\t$rev    = $obj->revcom();\n    };\n    if( $@ ) {\n\t$obj->throw(-class => 'Bio::Root::Exception',\n                    -text => \"Could not reverse complement. \".\n\t\t             \"Probably not DNA. Actual exception\\n$@\\n\",\n                    -value => $@);\n    }\n\n    $trunc = $obj->trunc(12,50);\n\n    # $rev and $trunc are Bio::PrimarySeqI compliant objects\n\n\n=head1 DESCRIPTION\n\nThis object defines an abstract interface to basic sequence\ninformation - for most users of the package the documentation (and\nmethods) in this class are not useful - this is a developers only\nclass which defines what methods have to be implmented by other Perl\nobjects to comply to the Bio::PrimarySeqI interface. Go \"perldoc\nBio::Seq\" or \"man Bio::Seq\" for more information on the main class for\nsequences.\n\n\nPrimarySeq is an object just for the sequence and its name(s), nothing\nmore. Seq is the larger object complete with features. There is a pure\nperl implementation of this in Bio::PrimarySeq. If you just want to\nuse Bio::PrimarySeq objects, then please read that module first. This\nmodule defines the interface, and is of more interest to people who\nwant to wrap their own Perl Objects/RDBs/FileSystems etc in way that\nthey \"are\" bioperl sequence objects, even though it is not using Perl\nto store the sequence etc.\n\n\nThis interface defines what bioperl consideres necessary to \"be\" a\nsequence, without providing an implementation of this. (An\nimplementation is provided in Bio::PrimarySeq). If you want to provide\na Bio::PrimarySeq 'compliant' object which in fact wraps another\nobject/database/out-of-perl experience, then this is the correct thing\nto wrap, generally by providing a wrapper class which would inheriet\nfrom your object and this Bio::PrimarySeqI interface. The wrapper class\nthen would have methods lists in the \"Implementation Specific\nFunctions\" which would provide these methods for your object.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n \nPlease direct usage questions or support issues to the mailing list:\n  \nL<bioperl-l@bioperl.org>\n  \nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@sanger.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PrimarySeqI;\nuse strict;\nuse Bio::Tools::CodonTable;\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Implementation Specific Functions\n\nThese functions are the ones that a specific implementation must\ndefine.\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard),\n           but implementations are suggested to keep an open mind about\n           case (some users... want mixed case!)\n Returns : A scalar\n Status  : Virtual\n\n\nsub seq {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n Function: returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n\n           Start cannot be larger than end but can be equal\n\n Returns : a string\n Args    :\n Status  : Virtual\n\n\nsub subseq{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, aka the common name of the Sequence object.\n\n           The semantics of this is that it is the most likely string\n           to be used as an identifier of the sequence, and likely to\n           have \"human\" readability.  The id is equivalent to the ID\n           field of the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id\n           to embed other information. Bioperl does not use any\n           embedded information in the ID field, and people are\n           encouraged to use other mechanisms (accession field for\n           example, or extending the sequence object) to solve this.\n\n           Notice that $seq->id() maps to this function, mainly for\n           legacy/convience issues\n Returns : A string\n Args    : None\n Status  : Virtual"},"containerName":"main::","definition":"sub"},{"range":{"end":{"character":9999,"line":244},"start":{"character":0,"line":241}},"name":"accession_number","signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: PrimarySeqI.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::PrimarySeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PrimarySeqI [Developers] - Interface definition for a Bio::PrimarySeq\n\n=head1 SYNOPSIS\n\n\n    # Bio::PrimarySeqI is the interface class for sequences.\n\n    # If you are a newcomer to bioperl, you should\n    # start with Bio::Seq documentation. This\n    # documentation is mainly for developers using\n    # Bioperl.\n\n    # to test this is a seq object\n\n    $obj->isa(\"Bio::PrimarySeqI\") ||\n      $obj->throw(\"$obj does not implement the Bio::PrimarySeqI interface\");\n\n    # accessors\n\n    $string    = $obj->seq();\n    $substring = $obj->subseq(12,50);\n    $display   = $obj->display_id(); # for human display\n    $id        = $obj->primary_id(); # unique id for this object,\n                                     # implementation defined\n    $unique_key= $obj->accession_number();\n                       # unique biological id\n\n    # object manipulation\n\n    eval {\n\t$rev    = $obj->revcom();\n    };\n    if( $@ ) {\n\t$obj->throw(-class => 'Bio::Root::Exception',\n                    -text => \"Could not reverse complement. \".\n\t\t             \"Probably not DNA. Actual exception\\n$@\\n\",\n                    -value => $@);\n    }\n\n    $trunc = $obj->trunc(12,50);\n\n    # $rev and $trunc are Bio::PrimarySeqI compliant objects\n\n\n=head1 DESCRIPTION\n\nThis object defines an abstract interface to basic sequence\ninformation - for most users of the package the documentation (and\nmethods) in this class are not useful - this is a developers only\nclass which defines what methods have to be implmented by other Perl\nobjects to comply to the Bio::PrimarySeqI interface. Go \"perldoc\nBio::Seq\" or \"man Bio::Seq\" for more information on the main class for\nsequences.\n\n\nPrimarySeq is an object just for the sequence and its name(s), nothing\nmore. Seq is the larger object complete with features. There is a pure\nperl implementation of this in Bio::PrimarySeq. If you just want to\nuse Bio::PrimarySeq objects, then please read that module first. This\nmodule defines the interface, and is of more interest to people who\nwant to wrap their own Perl Objects/RDBs/FileSystems etc in way that\nthey \"are\" bioperl sequence objects, even though it is not using Perl\nto store the sequence etc.\n\n\nThis interface defines what bioperl consideres necessary to \"be\" a\nsequence, without providing an implementation of this. (An\nimplementation is provided in Bio::PrimarySeq). If you want to provide\na Bio::PrimarySeq 'compliant' object which in fact wraps another\nobject/database/out-of-perl experience, then this is the correct thing\nto wrap, generally by providing a wrapper class which would inheriet\nfrom your object and this Bio::PrimarySeqI interface. The wrapper class\nthen would have methods lists in the \"Implementation Specific\nFunctions\" which would provide these methods for your object.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n \nPlease direct usage questions or support issues to the mailing list:\n  \nL<bioperl-l@bioperl.org>\n  \nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@sanger.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PrimarySeqI;\nuse strict;\nuse Bio::Tools::CodonTable;\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Implementation Specific Functions\n\nThese functions are the ones that a specific implementation must\ndefine.\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard),\n           but implementations are suggested to keep an open mind about\n           case (some users... want mixed case!)\n Returns : A scalar\n Status  : Virtual\n\n\nsub seq {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n Function: returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n\n           Start cannot be larger than end but can be equal\n\n Returns : a string\n Args    :\n Status  : Virtual\n\n\nsub subseq{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, aka the common name of the Sequence object.\n\n           The semantics of this is that it is the most likely string\n           to be used as an identifier of the sequence, and likely to\n           have \"human\" readability.  The id is equivalent to the ID\n           field of the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id\n           to embed other information. Bioperl does not use any\n           embedded information in the ID field, and people are\n           encouraged to use other mechanisms (accession field for\n           example, or extending the sequence object) to solve this.\n\n           Notice that $seq->id() maps to this function, mainly for\n           legacy/convience issues\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub display_id {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 accession_number\n\n Title   : accession_number\n Usage   : $unique_biological_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number. For sequences from established\n           databases, the implementors should try to use the correct\n           accession number. Notice that primary_id() provides the\n           unique id for the implemetation, allowing multiple objects\n           to have the same accession number in a particular implementation.\n\n           For sequences with no accession number, this method should return\n           \"unknown\".\n Returns : A string\n Args    : None\n Status  : Virtual","label":"accession_number($self,@args)"},"detail":"($self,@args)","definition":"sub","containerName":"main::","children":[{"localvar":"my","containerName":"accession_number","name":"$self","definition":"my","line":242,"kind":13},{"containerName":"accession_number","name":"@args","kind":13,"line":242},{"line":243,"kind":13,"containerName":"accession_number","name":"$self"},{"containerName":"accession_number","name":"throw_not_implemented","kind":12,"line":243}],"line":241,"kind":12},{"definition":"sub","containerName":"main::","signature":{"label":"primary_id($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: PrimarySeqI.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::PrimarySeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PrimarySeqI [Developers] - Interface definition for a Bio::PrimarySeq\n\n=head1 SYNOPSIS\n\n\n    # Bio::PrimarySeqI is the interface class for sequences.\n\n    # If you are a newcomer to bioperl, you should\n    # start with Bio::Seq documentation. This\n    # documentation is mainly for developers using\n    # Bioperl.\n\n    # to test this is a seq object\n\n    $obj->isa(\"Bio::PrimarySeqI\") ||\n      $obj->throw(\"$obj does not implement the Bio::PrimarySeqI interface\");\n\n    # accessors\n\n    $string    = $obj->seq();\n    $substring = $obj->subseq(12,50);\n    $display   = $obj->display_id(); # for human display\n    $id        = $obj->primary_id(); # unique id for this object,\n                                     # implementation defined\n    $unique_key= $obj->accession_number();\n                       # unique biological id\n\n    # object manipulation\n\n    eval {\n\t$rev    = $obj->revcom();\n    };\n    if( $@ ) {\n\t$obj->throw(-class => 'Bio::Root::Exception',\n                    -text => \"Could not reverse complement. \".\n\t\t             \"Probably not DNA. Actual exception\\n$@\\n\",\n                    -value => $@);\n    }\n\n    $trunc = $obj->trunc(12,50);\n\n    # $rev and $trunc are Bio::PrimarySeqI compliant objects\n\n\n=head1 DESCRIPTION\n\nThis object defines an abstract interface to basic sequence\ninformation - for most users of the package the documentation (and\nmethods) in this class are not useful - this is a developers only\nclass which defines what methods have to be implmented by other Perl\nobjects to comply to the Bio::PrimarySeqI interface. Go \"perldoc\nBio::Seq\" or \"man Bio::Seq\" for more information on the main class for\nsequences.\n\n\nPrimarySeq is an object just for the sequence and its name(s), nothing\nmore. Seq is the larger object complete with features. There is a pure\nperl implementation of this in Bio::PrimarySeq. If you just want to\nuse Bio::PrimarySeq objects, then please read that module first. This\nmodule defines the interface, and is of more interest to people who\nwant to wrap their own Perl Objects/RDBs/FileSystems etc in way that\nthey \"are\" bioperl sequence objects, even though it is not using Perl\nto store the sequence etc.\n\n\nThis interface defines what bioperl consideres necessary to \"be\" a\nsequence, without providing an implementation of this. (An\nimplementation is provided in Bio::PrimarySeq). If you want to provide\na Bio::PrimarySeq 'compliant' object which in fact wraps another\nobject/database/out-of-perl experience, then this is the correct thing\nto wrap, generally by providing a wrapper class which would inheriet\nfrom your object and this Bio::PrimarySeqI interface. The wrapper class\nthen would have methods lists in the \"Implementation Specific\nFunctions\" which would provide these methods for your object.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n \nPlease direct usage questions or support issues to the mailing list:\n  \nL<bioperl-l@bioperl.org>\n  \nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@sanger.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PrimarySeqI;\nuse strict;\nuse Bio::Tools::CodonTable;\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Implementation Specific Functions\n\nThese functions are the ones that a specific implementation must\ndefine.\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard),\n           but implementations are suggested to keep an open mind about\n           case (some users... want mixed case!)\n Returns : A scalar\n Status  : Virtual\n\n\nsub seq {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n Function: returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n\n           Start cannot be larger than end but can be equal\n\n Returns : a string\n Args    :\n Status  : Virtual\n\n\nsub subseq{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, aka the common name of the Sequence object.\n\n           The semantics of this is that it is the most likely string\n           to be used as an identifier of the sequence, and likely to\n           have \"human\" readability.  The id is equivalent to the ID\n           field of the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id\n           to embed other information. Bioperl does not use any\n           embedded information in the ID field, and people are\n           encouraged to use other mechanisms (accession field for\n           example, or extending the sequence object) to solve this.\n\n           Notice that $seq->id() maps to this function, mainly for\n           legacy/convience issues\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub display_id {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 accession_number\n\n Title   : accession_number\n Usage   : $unique_biological_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number. For sequences from established\n           databases, the implementors should try to use the correct\n           accession number. Notice that primary_id() provides the\n           unique id for the implemetation, allowing multiple objects\n           to have the same accession number in a particular implementation.\n\n           For sequences with no accession number, this method should return\n           \"unknown\".\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub accession_number {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_implementation_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their\n           own object ids in a way the implementaiton can control\n           clients can expect one id to map to one object.\n\n           For sequences with no accession number, this method should\n           return a stringified memory location.\n\n           [Note this method name is likely to change in 1.3]\n\n Returns : A string\n Args    : None\n Status  : Virtual"},"detail":"($self,@args)","kind":12,"children":[{"kind":13,"line":270,"name":"$self","definition":"my","containerName":"primary_id","localvar":"my"},{"line":270,"kind":13,"containerName":"primary_id","name":"@args"},{"containerName":"primary_id","name":"$self","kind":13,"line":271},{"name":"throw_not_implemented","containerName":"primary_id","line":271,"kind":12}],"line":269,"name":"primary_id","range":{"start":{"character":0,"line":269},"end":{"line":272,"character":9999}}},{"name":"can_call_new","range":{"end":{"line":305,"character":9999},"start":{"character":0,"line":299}},"containerName":"main::","definition":"sub","detail":"($self,@args)","signature":{"label":"can_call_new($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: PrimarySeqI.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::PrimarySeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PrimarySeqI [Developers] - Interface definition for a Bio::PrimarySeq\n\n=head1 SYNOPSIS\n\n\n    # Bio::PrimarySeqI is the interface class for sequences.\n\n    # If you are a newcomer to bioperl, you should\n    # start with Bio::Seq documentation. This\n    # documentation is mainly for developers using\n    # Bioperl.\n\n    # to test this is a seq object\n\n    $obj->isa(\"Bio::PrimarySeqI\") ||\n      $obj->throw(\"$obj does not implement the Bio::PrimarySeqI interface\");\n\n    # accessors\n\n    $string    = $obj->seq();\n    $substring = $obj->subseq(12,50);\n    $display   = $obj->display_id(); # for human display\n    $id        = $obj->primary_id(); # unique id for this object,\n                                     # implementation defined\n    $unique_key= $obj->accession_number();\n                       # unique biological id\n\n    # object manipulation\n\n    eval {\n\t$rev    = $obj->revcom();\n    };\n    if( $@ ) {\n\t$obj->throw(-class => 'Bio::Root::Exception',\n                    -text => \"Could not reverse complement. \".\n\t\t             \"Probably not DNA. Actual exception\\n$@\\n\",\n                    -value => $@);\n    }\n\n    $trunc = $obj->trunc(12,50);\n\n    # $rev and $trunc are Bio::PrimarySeqI compliant objects\n\n\n=head1 DESCRIPTION\n\nThis object defines an abstract interface to basic sequence\ninformation - for most users of the package the documentation (and\nmethods) in this class are not useful - this is a developers only\nclass which defines what methods have to be implmented by other Perl\nobjects to comply to the Bio::PrimarySeqI interface. Go \"perldoc\nBio::Seq\" or \"man Bio::Seq\" for more information on the main class for\nsequences.\n\n\nPrimarySeq is an object just for the sequence and its name(s), nothing\nmore. Seq is the larger object complete with features. There is a pure\nperl implementation of this in Bio::PrimarySeq. If you just want to\nuse Bio::PrimarySeq objects, then please read that module first. This\nmodule defines the interface, and is of more interest to people who\nwant to wrap their own Perl Objects/RDBs/FileSystems etc in way that\nthey \"are\" bioperl sequence objects, even though it is not using Perl\nto store the sequence etc.\n\n\nThis interface defines what bioperl consideres necessary to \"be\" a\nsequence, without providing an implementation of this. (An\nimplementation is provided in Bio::PrimarySeq). If you want to provide\na Bio::PrimarySeq 'compliant' object which in fact wraps another\nobject/database/out-of-perl experience, then this is the correct thing\nto wrap, generally by providing a wrapper class which would inheriet\nfrom your object and this Bio::PrimarySeqI interface. The wrapper class\nthen would have methods lists in the \"Implementation Specific\nFunctions\" which would provide these methods for your object.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n \nPlease direct usage questions or support issues to the mailing list:\n  \nL<bioperl-l@bioperl.org>\n  \nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@sanger.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PrimarySeqI;\nuse strict;\nuse Bio::Tools::CodonTable;\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Implementation Specific Functions\n\nThese functions are the ones that a specific implementation must\ndefine.\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard),\n           but implementations are suggested to keep an open mind about\n           case (some users... want mixed case!)\n Returns : A scalar\n Status  : Virtual\n\n\nsub seq {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n Function: returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n\n           Start cannot be larger than end but can be equal\n\n Returns : a string\n Args    :\n Status  : Virtual\n\n\nsub subseq{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, aka the common name of the Sequence object.\n\n           The semantics of this is that it is the most likely string\n           to be used as an identifier of the sequence, and likely to\n           have \"human\" readability.  The id is equivalent to the ID\n           field of the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id\n           to embed other information. Bioperl does not use any\n           embedded information in the ID field, and people are\n           encouraged to use other mechanisms (accession field for\n           example, or extending the sequence object) to solve this.\n\n           Notice that $seq->id() maps to this function, mainly for\n           legacy/convience issues\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub display_id {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 accession_number\n\n Title   : accession_number\n Usage   : $unique_biological_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number. For sequences from established\n           databases, the implementors should try to use the correct\n           accession number. Notice that primary_id() provides the\n           unique id for the implemetation, allowing multiple objects\n           to have the same accession number in a particular implementation.\n\n           For sequences with no accession number, this method should return\n           \"unknown\".\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub accession_number {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_implementation_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their\n           own object ids in a way the implementaiton can control\n           clients can expect one id to map to one object.\n\n           For sequences with no accession number, this method should\n           return a stringified memory location.\n\n           [Note this method name is likely to change in 1.3]\n\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub primary_id {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 can_call_new\n\n Title   : can_call_new\n Usage   : if( $obj->can_call_new ) {\n             $newobj = $obj->new( %param );\n\t }\n Function: can_call_new returns 1 or 0 depending\n           on whether an implementation allows new\n           constructor to be called. If a new constructor\n           is allowed, then it should take the followed hashed\n           constructor list.\n\n           $myobject->new( -seq => $sequence_as_string,\n\t\t\t   -display_id  => $id\n\t\t\t   -accession_number => $accession\n\t\t\t   -alphabet => 'dna',\n\t\t\t   );\n Example :\n Returns : 1 or 0\n Args    :"},"kind":12,"line":299,"children":[{"kind":13,"line":300,"name":"$self","definition":"my","containerName":"can_call_new","localvar":"my"},{"line":300,"kind":13,"name":"@args","containerName":"can_call_new"}]},{"name":"alphabet","range":{"end":{"character":9999,"line":329},"start":{"line":326,"character":0}},"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"alphabet($self)","documentation":"1;\n# $Id: PrimarySeqI.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::PrimarySeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PrimarySeqI [Developers] - Interface definition for a Bio::PrimarySeq\n\n=head1 SYNOPSIS\n\n\n    # Bio::PrimarySeqI is the interface class for sequences.\n\n    # If you are a newcomer to bioperl, you should\n    # start with Bio::Seq documentation. This\n    # documentation is mainly for developers using\n    # Bioperl.\n\n    # to test this is a seq object\n\n    $obj->isa(\"Bio::PrimarySeqI\") ||\n      $obj->throw(\"$obj does not implement the Bio::PrimarySeqI interface\");\n\n    # accessors\n\n    $string    = $obj->seq();\n    $substring = $obj->subseq(12,50);\n    $display   = $obj->display_id(); # for human display\n    $id        = $obj->primary_id(); # unique id for this object,\n                                     # implementation defined\n    $unique_key= $obj->accession_number();\n                       # unique biological id\n\n    # object manipulation\n\n    eval {\n\t$rev    = $obj->revcom();\n    };\n    if( $@ ) {\n\t$obj->throw(-class => 'Bio::Root::Exception',\n                    -text => \"Could not reverse complement. \".\n\t\t             \"Probably not DNA. Actual exception\\n$@\\n\",\n                    -value => $@);\n    }\n\n    $trunc = $obj->trunc(12,50);\n\n    # $rev and $trunc are Bio::PrimarySeqI compliant objects\n\n\n=head1 DESCRIPTION\n\nThis object defines an abstract interface to basic sequence\ninformation - for most users of the package the documentation (and\nmethods) in this class are not useful - this is a developers only\nclass which defines what methods have to be implmented by other Perl\nobjects to comply to the Bio::PrimarySeqI interface. Go \"perldoc\nBio::Seq\" or \"man Bio::Seq\" for more information on the main class for\nsequences.\n\n\nPrimarySeq is an object just for the sequence and its name(s), nothing\nmore. Seq is the larger object complete with features. There is a pure\nperl implementation of this in Bio::PrimarySeq. If you just want to\nuse Bio::PrimarySeq objects, then please read that module first. This\nmodule defines the interface, and is of more interest to people who\nwant to wrap their own Perl Objects/RDBs/FileSystems etc in way that\nthey \"are\" bioperl sequence objects, even though it is not using Perl\nto store the sequence etc.\n\n\nThis interface defines what bioperl consideres necessary to \"be\" a\nsequence, without providing an implementation of this. (An\nimplementation is provided in Bio::PrimarySeq). If you want to provide\na Bio::PrimarySeq 'compliant' object which in fact wraps another\nobject/database/out-of-perl experience, then this is the correct thing\nto wrap, generally by providing a wrapper class which would inheriet\nfrom your object and this Bio::PrimarySeqI interface. The wrapper class\nthen would have methods lists in the \"Implementation Specific\nFunctions\" which would provide these methods for your object.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n \nPlease direct usage questions or support issues to the mailing list:\n  \nL<bioperl-l@bioperl.org>\n  \nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@sanger.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PrimarySeqI;\nuse strict;\nuse Bio::Tools::CodonTable;\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Implementation Specific Functions\n\nThese functions are the ones that a specific implementation must\ndefine.\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard),\n           but implementations are suggested to keep an open mind about\n           case (some users... want mixed case!)\n Returns : A scalar\n Status  : Virtual\n\n\nsub seq {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n Function: returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n\n           Start cannot be larger than end but can be equal\n\n Returns : a string\n Args    :\n Status  : Virtual\n\n\nsub subseq{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, aka the common name of the Sequence object.\n\n           The semantics of this is that it is the most likely string\n           to be used as an identifier of the sequence, and likely to\n           have \"human\" readability.  The id is equivalent to the ID\n           field of the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id\n           to embed other information. Bioperl does not use any\n           embedded information in the ID field, and people are\n           encouraged to use other mechanisms (accession field for\n           example, or extending the sequence object) to solve this.\n\n           Notice that $seq->id() maps to this function, mainly for\n           legacy/convience issues\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub display_id {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 accession_number\n\n Title   : accession_number\n Usage   : $unique_biological_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number. For sequences from established\n           databases, the implementors should try to use the correct\n           accession number. Notice that primary_id() provides the\n           unique id for the implemetation, allowing multiple objects\n           to have the same accession number in a particular implementation.\n\n           For sequences with no accession number, this method should return\n           \"unknown\".\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub accession_number {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_implementation_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their\n           own object ids in a way the implementaiton can control\n           clients can expect one id to map to one object.\n\n           For sequences with no accession number, this method should\n           return a stringified memory location.\n\n           [Note this method name is likely to change in 1.3]\n\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub primary_id {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 can_call_new\n\n Title   : can_call_new\n Usage   : if( $obj->can_call_new ) {\n             $newobj = $obj->new( %param );\n\t }\n Function: can_call_new returns 1 or 0 depending\n           on whether an implementation allows new\n           constructor to be called. If a new constructor\n           is allowed, then it should take the followed hashed\n           constructor list.\n\n           $myobject->new( -seq => $sequence_as_string,\n\t\t\t   -display_id  => $id\n\t\t\t   -accession_number => $accession\n\t\t\t   -alphabet => 'dna',\n\t\t\t   );\n Example :\n Returns : 1 or 0\n Args    :\n\n\n\nsub can_call_new{\n   my ($self,@args) = @_;\n\n   # we default to 0 here\n\n   return 0;\n}\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Returns the type of sequence being one of\n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n           This is not called <type> because this would cause\n           upgrade problems from the 0.5 and earlier Seq objects.\n\n Returns : a string either 'dna','rna','protein'. NB - the object must\n           make a call of the type - if there is no type specified it\n           has to guess.\n Args    : none\n Status  : Virtual","parameters":[{"label":"$self"}]},"kind":12,"line":326,"children":[{"containerName":"alphabet","name":"$self","definition":"my","localvar":"my","kind":13,"line":327},{"kind":13,"line":328,"containerName":"alphabet","name":"$self"},{"containerName":"alphabet","name":"throw_not_implemented","kind":12,"line":328}]},{"range":{"start":{"character":0,"line":331},"end":{"character":9999,"line":336}},"name":"moltype","signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"","label":"moltype($self,@args)"},"detail":"($self,@args)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":332,"containerName":"moltype","definition":"my","name":"$self","localvar":"my"},{"name":"@args","containerName":"moltype","kind":13,"line":332},{"containerName":"moltype","name":"$self","kind":13,"line":334},{"containerName":"moltype","name":"warn","kind":12,"line":334},{"name":"$self","containerName":"moltype","line":335,"kind":13},{"containerName":"moltype","name":"alphabet","line":335,"kind":12},{"containerName":"moltype","name":"@args","line":335,"kind":13}],"line":331,"kind":12},{"range":{"end":{"line":438,"character":9999},"start":{"line":382,"character":0}},"name":"revcom","children":[{"kind":13,"line":383,"name":"$self","definition":"my","containerName":"revcom","localvar":"my"},{"localvar":"my","definition":"my","name":"$t","containerName":"revcom","line":387,"kind":13},{"kind":13,"line":387,"containerName":"revcom","name":"$self"},{"containerName":"revcom","name":"alphabet","line":387,"kind":12},{"line":389,"kind":13,"name":"$t","containerName":"revcom"},{"line":390,"kind":13,"name":"$self","containerName":"revcom"},{"name":"throw","containerName":"revcom","kind":12,"line":390},{"line":394,"kind":13,"name":"$t","containerName":"revcom"},{"name":"$t","containerName":"revcom","line":394,"kind":13},{"kind":13,"line":395,"name":"$self","containerName":"revcom"},{"name":"can","containerName":"revcom","kind":12,"line":395},{"containerName":"revcom","name":"$self","line":396,"kind":13},{"containerName":"revcom","name":"warn","kind":12,"line":396},{"containerName":"revcom","name":"$str","definition":"my","localvar":"my","kind":13,"line":406},{"name":"$self","containerName":"revcom","kind":13,"line":406},{"containerName":"revcom","name":"seq","line":406,"kind":12},{"name":"$t","containerName":"revcom","line":410,"kind":13},{"kind":13,"line":411,"containerName":"revcom","name":"$str"},{"containerName":"revcom","name":"$str","kind":13,"line":416},{"localvar":"my","name":"$revseq","definition":"my","containerName":"revcom","line":417,"kind":13},{"line":417,"kind":13,"name":"$str","containerName":"revcom"},{"containerName":"revcom","name":"$t","line":419,"kind":13},{"containerName":"revcom","name":"$revseq","line":420,"kind":13},{"kind":13,"line":423,"containerName":"revcom","name":"$seqclass","definition":"my","localvar":"my"},{"name":"$self","containerName":"revcom","kind":13,"line":424},{"kind":12,"line":424,"name":"can_call_new","containerName":"revcom"},{"kind":13,"line":425,"containerName":"revcom","name":"$seqclass"},{"kind":13,"line":425,"containerName":"revcom","name":"$self"},{"name":"$seqclass","containerName":"revcom","kind":13,"line":427},{"line":428,"kind":13,"name":"$self","containerName":"revcom"},{"line":428,"kind":12,"name":"_attempt_to_load_Seq","containerName":"revcom"},{"localvar":"my","containerName":"revcom","definition":"my","name":"$out","line":430,"kind":13},{"containerName":"revcom","name":"$seqclass","kind":13,"line":430},{"name":"new","containerName":"revcom","line":430,"kind":12},{"line":430,"kind":13,"name":"$revseq","containerName":"revcom"},{"name":"$self","containerName":"revcom","kind":13,"line":431},{"containerName":"revcom","name":"display_id","line":431,"kind":12},{"name":"$self","containerName":"revcom","kind":13,"line":432},{"containerName":"revcom","name":"accession_number","kind":12,"line":432},{"containerName":"revcom","name":"$self","line":433,"kind":13},{"containerName":"revcom","name":"alphabet","line":433,"kind":12},{"line":434,"kind":13,"containerName":"revcom","name":"$self"},{"line":434,"kind":12,"name":"desc","containerName":"revcom"},{"kind":13,"line":436,"name":"$out","containerName":"revcom"}],"line":382,"kind":12,"signature":{"documentation":"1;\n# $Id: PrimarySeqI.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::PrimarySeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PrimarySeqI [Developers] - Interface definition for a Bio::PrimarySeq\n\n=head1 SYNOPSIS\n\n\n    # Bio::PrimarySeqI is the interface class for sequences.\n\n    # If you are a newcomer to bioperl, you should\n    # start with Bio::Seq documentation. This\n    # documentation is mainly for developers using\n    # Bioperl.\n\n    # to test this is a seq object\n\n    $obj->isa(\"Bio::PrimarySeqI\") ||\n      $obj->throw(\"$obj does not implement the Bio::PrimarySeqI interface\");\n\n    # accessors\n\n    $string    = $obj->seq();\n    $substring = $obj->subseq(12,50);\n    $display   = $obj->display_id(); # for human display\n    $id        = $obj->primary_id(); # unique id for this object,\n                                     # implementation defined\n    $unique_key= $obj->accession_number();\n                       # unique biological id\n\n    # object manipulation\n\n    eval {\n\t$rev    = $obj->revcom();\n    };\n    if( $@ ) {\n\t$obj->throw(-class => 'Bio::Root::Exception',\n                    -text => \"Could not reverse complement. \".\n\t\t             \"Probably not DNA. Actual exception\\n$@\\n\",\n                    -value => $@);\n    }\n\n    $trunc = $obj->trunc(12,50);\n\n    # $rev and $trunc are Bio::PrimarySeqI compliant objects\n\n\n=head1 DESCRIPTION\n\nThis object defines an abstract interface to basic sequence\ninformation - for most users of the package the documentation (and\nmethods) in this class are not useful - this is a developers only\nclass which defines what methods have to be implmented by other Perl\nobjects to comply to the Bio::PrimarySeqI interface. Go \"perldoc\nBio::Seq\" or \"man Bio::Seq\" for more information on the main class for\nsequences.\n\n\nPrimarySeq is an object just for the sequence and its name(s), nothing\nmore. Seq is the larger object complete with features. There is a pure\nperl implementation of this in Bio::PrimarySeq. If you just want to\nuse Bio::PrimarySeq objects, then please read that module first. This\nmodule defines the interface, and is of more interest to people who\nwant to wrap their own Perl Objects/RDBs/FileSystems etc in way that\nthey \"are\" bioperl sequence objects, even though it is not using Perl\nto store the sequence etc.\n\n\nThis interface defines what bioperl consideres necessary to \"be\" a\nsequence, without providing an implementation of this. (An\nimplementation is provided in Bio::PrimarySeq). If you want to provide\na Bio::PrimarySeq 'compliant' object which in fact wraps another\nobject/database/out-of-perl experience, then this is the correct thing\nto wrap, generally by providing a wrapper class which would inheriet\nfrom your object and this Bio::PrimarySeqI interface. The wrapper class\nthen would have methods lists in the \"Implementation Specific\nFunctions\" which would provide these methods for your object.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n \nPlease direct usage questions or support issues to the mailing list:\n  \nL<bioperl-l@bioperl.org>\n  \nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@sanger.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PrimarySeqI;\nuse strict;\nuse Bio::Tools::CodonTable;\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Implementation Specific Functions\n\nThese functions are the ones that a specific implementation must\ndefine.\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard),\n           but implementations are suggested to keep an open mind about\n           case (some users... want mixed case!)\n Returns : A scalar\n Status  : Virtual\n\n\nsub seq {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n Function: returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n\n           Start cannot be larger than end but can be equal\n\n Returns : a string\n Args    :\n Status  : Virtual\n\n\nsub subseq{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, aka the common name of the Sequence object.\n\n           The semantics of this is that it is the most likely string\n           to be used as an identifier of the sequence, and likely to\n           have \"human\" readability.  The id is equivalent to the ID\n           field of the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id\n           to embed other information. Bioperl does not use any\n           embedded information in the ID field, and people are\n           encouraged to use other mechanisms (accession field for\n           example, or extending the sequence object) to solve this.\n\n           Notice that $seq->id() maps to this function, mainly for\n           legacy/convience issues\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub display_id {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 accession_number\n\n Title   : accession_number\n Usage   : $unique_biological_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number. For sequences from established\n           databases, the implementors should try to use the correct\n           accession number. Notice that primary_id() provides the\n           unique id for the implemetation, allowing multiple objects\n           to have the same accession number in a particular implementation.\n\n           For sequences with no accession number, this method should return\n           \"unknown\".\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub accession_number {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_implementation_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their\n           own object ids in a way the implementaiton can control\n           clients can expect one id to map to one object.\n\n           For sequences with no accession number, this method should\n           return a stringified memory location.\n\n           [Note this method name is likely to change in 1.3]\n\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub primary_id {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 can_call_new\n\n Title   : can_call_new\n Usage   : if( $obj->can_call_new ) {\n             $newobj = $obj->new( %param );\n\t }\n Function: can_call_new returns 1 or 0 depending\n           on whether an implementation allows new\n           constructor to be called. If a new constructor\n           is allowed, then it should take the followed hashed\n           constructor list.\n\n           $myobject->new( -seq => $sequence_as_string,\n\t\t\t   -display_id  => $id\n\t\t\t   -accession_number => $accession\n\t\t\t   -alphabet => 'dna',\n\t\t\t   );\n Example :\n Returns : 1 or 0\n Args    :\n\n\n\nsub can_call_new{\n   my ($self,@args) = @_;\n\n   # we default to 0 here\n\n   return 0;\n}\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Returns the type of sequence being one of\n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n           This is not called <type> because this would cause\n           upgrade problems from the 0.5 and earlier Seq objects.\n\n Returns : a string either 'dna','rna','protein'. NB - the object must\n           make a call of the type - if there is no type specified it\n           has to guess.\n Args    : none\n Status  : Virtual\n\n\n\nsub alphabet{\n    my ( $self ) = @_;\n    $self->throw_not_implemented();\n}\n\nsub moltype{\n   my ($self,@args) = @_;\n\n   $self->warn(\"moltype: pre v1.0 method. Calling alphabet() instead...\");\n   $self->alphabet(@args);\n}\n\n\n=head1 Optional Implementation Functions\n\nThe following functions rely on the above functions. An\nimplementing class does not need to provide these functions, as they\nwill be provided by this class, but is free to override these\nfunctions.\n\nAll of revcom(), trunc(), and translate() create new sequence\nobjects. They will call new() on the class of the sequence object\ninstance passed as argument, unless can_call_new() returns FALSE. In\nthe latter case a Bio::PrimarySeq object will be created. Implementors\nwhich really want to control how objects are created (eg, for object\npersistence over a database, or objects in a CORBA framework), they\nare encouraged to override these methods\n\n=head2 revcom\n\n Title   : revcom\n Usage   : $rev = $seq->revcom()\n Function: Produces a new Bio::PrimarySeqI implementing object which\n           is the reversed complement of the sequence. For protein\n           sequences this throws an exception of \"Sequence is a\n           protein. Cannot revcom\"\n\n           The id is the same id as the original sequence, and the\n           accession number is also indentical. If someone wants to\n           track that this sequence has be reversed, it needs to\n           define its own extensions\n\n           To do an inplace edit of an object you can go:\n\n           $seq = $seq->revcom();\n\n           This of course, causes Perl to handle the garbage\n           collection of the old object, but it is roughly speaking as\n           efficient as an inplace edit.\n\n Returns : A new (fresh) Bio::PrimarySeqI object\n Args    : none","parameters":[{"label":"$self"}],"label":"revcom($self)"},"detail":"($self)","definition":"sub","containerName":"main::"},{"line":419,"kind":12,"containerName":"reverse","name":"CORE"},{"range":{"start":{"line":453,"character":0},"end":{"character":9999,"line":486}},"name":"trunc","signature":{"label":"trunc($self,$start,$end)","parameters":[{"label":"$self"},{"label":"$start"},{"label":"$end"}],"documentation":"1;\n# $Id: PrimarySeqI.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::PrimarySeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PrimarySeqI [Developers] - Interface definition for a Bio::PrimarySeq\n\n=head1 SYNOPSIS\n\n\n    # Bio::PrimarySeqI is the interface class for sequences.\n\n    # If you are a newcomer to bioperl, you should\n    # start with Bio::Seq documentation. This\n    # documentation is mainly for developers using\n    # Bioperl.\n\n    # to test this is a seq object\n\n    $obj->isa(\"Bio::PrimarySeqI\") ||\n      $obj->throw(\"$obj does not implement the Bio::PrimarySeqI interface\");\n\n    # accessors\n\n    $string    = $obj->seq();\n    $substring = $obj->subseq(12,50);\n    $display   = $obj->display_id(); # for human display\n    $id        = $obj->primary_id(); # unique id for this object,\n                                     # implementation defined\n    $unique_key= $obj->accession_number();\n                       # unique biological id\n\n    # object manipulation\n\n    eval {\n\t$rev    = $obj->revcom();\n    };\n    if( $@ ) {\n\t$obj->throw(-class => 'Bio::Root::Exception',\n                    -text => \"Could not reverse complement. \".\n\t\t             \"Probably not DNA. Actual exception\\n$@\\n\",\n                    -value => $@);\n    }\n\n    $trunc = $obj->trunc(12,50);\n\n    # $rev and $trunc are Bio::PrimarySeqI compliant objects\n\n\n=head1 DESCRIPTION\n\nThis object defines an abstract interface to basic sequence\ninformation - for most users of the package the documentation (and\nmethods) in this class are not useful - this is a developers only\nclass which defines what methods have to be implmented by other Perl\nobjects to comply to the Bio::PrimarySeqI interface. Go \"perldoc\nBio::Seq\" or \"man Bio::Seq\" for more information on the main class for\nsequences.\n\n\nPrimarySeq is an object just for the sequence and its name(s), nothing\nmore. Seq is the larger object complete with features. There is a pure\nperl implementation of this in Bio::PrimarySeq. If you just want to\nuse Bio::PrimarySeq objects, then please read that module first. This\nmodule defines the interface, and is of more interest to people who\nwant to wrap their own Perl Objects/RDBs/FileSystems etc in way that\nthey \"are\" bioperl sequence objects, even though it is not using Perl\nto store the sequence etc.\n\n\nThis interface defines what bioperl consideres necessary to \"be\" a\nsequence, without providing an implementation of this. (An\nimplementation is provided in Bio::PrimarySeq). If you want to provide\na Bio::PrimarySeq 'compliant' object which in fact wraps another\nobject/database/out-of-perl experience, then this is the correct thing\nto wrap, generally by providing a wrapper class which would inheriet\nfrom your object and this Bio::PrimarySeqI interface. The wrapper class\nthen would have methods lists in the \"Implementation Specific\nFunctions\" which would provide these methods for your object.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n \nPlease direct usage questions or support issues to the mailing list:\n  \nL<bioperl-l@bioperl.org>\n  \nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@sanger.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PrimarySeqI;\nuse strict;\nuse Bio::Tools::CodonTable;\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Implementation Specific Functions\n\nThese functions are the ones that a specific implementation must\ndefine.\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard),\n           but implementations are suggested to keep an open mind about\n           case (some users... want mixed case!)\n Returns : A scalar\n Status  : Virtual\n\n\nsub seq {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n Function: returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n\n           Start cannot be larger than end but can be equal\n\n Returns : a string\n Args    :\n Status  : Virtual\n\n\nsub subseq{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, aka the common name of the Sequence object.\n\n           The semantics of this is that it is the most likely string\n           to be used as an identifier of the sequence, and likely to\n           have \"human\" readability.  The id is equivalent to the ID\n           field of the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id\n           to embed other information. Bioperl does not use any\n           embedded information in the ID field, and people are\n           encouraged to use other mechanisms (accession field for\n           example, or extending the sequence object) to solve this.\n\n           Notice that $seq->id() maps to this function, mainly for\n           legacy/convience issues\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub display_id {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 accession_number\n\n Title   : accession_number\n Usage   : $unique_biological_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number. For sequences from established\n           databases, the implementors should try to use the correct\n           accession number. Notice that primary_id() provides the\n           unique id for the implemetation, allowing multiple objects\n           to have the same accession number in a particular implementation.\n\n           For sequences with no accession number, this method should return\n           \"unknown\".\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub accession_number {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_implementation_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their\n           own object ids in a way the implementaiton can control\n           clients can expect one id to map to one object.\n\n           For sequences with no accession number, this method should\n           return a stringified memory location.\n\n           [Note this method name is likely to change in 1.3]\n\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub primary_id {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 can_call_new\n\n Title   : can_call_new\n Usage   : if( $obj->can_call_new ) {\n             $newobj = $obj->new( %param );\n\t }\n Function: can_call_new returns 1 or 0 depending\n           on whether an implementation allows new\n           constructor to be called. If a new constructor\n           is allowed, then it should take the followed hashed\n           constructor list.\n\n           $myobject->new( -seq => $sequence_as_string,\n\t\t\t   -display_id  => $id\n\t\t\t   -accession_number => $accession\n\t\t\t   -alphabet => 'dna',\n\t\t\t   );\n Example :\n Returns : 1 or 0\n Args    :\n\n\n\nsub can_call_new{\n   my ($self,@args) = @_;\n\n   # we default to 0 here\n\n   return 0;\n}\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Returns the type of sequence being one of\n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n           This is not called <type> because this would cause\n           upgrade problems from the 0.5 and earlier Seq objects.\n\n Returns : a string either 'dna','rna','protein'. NB - the object must\n           make a call of the type - if there is no type specified it\n           has to guess.\n Args    : none\n Status  : Virtual\n\n\n\nsub alphabet{\n    my ( $self ) = @_;\n    $self->throw_not_implemented();\n}\n\nsub moltype{\n   my ($self,@args) = @_;\n\n   $self->warn(\"moltype: pre v1.0 method. Calling alphabet() instead...\");\n   $self->alphabet(@args);\n}\n\n\n=head1 Optional Implementation Functions\n\nThe following functions rely on the above functions. An\nimplementing class does not need to provide these functions, as they\nwill be provided by this class, but is free to override these\nfunctions.\n\nAll of revcom(), trunc(), and translate() create new sequence\nobjects. They will call new() on the class of the sequence object\ninstance passed as argument, unless can_call_new() returns FALSE. In\nthe latter case a Bio::PrimarySeq object will be created. Implementors\nwhich really want to control how objects are created (eg, for object\npersistence over a database, or objects in a CORBA framework), they\nare encouraged to override these methods\n\n=head2 revcom\n\n Title   : revcom\n Usage   : $rev = $seq->revcom()\n Function: Produces a new Bio::PrimarySeqI implementing object which\n           is the reversed complement of the sequence. For protein\n           sequences this throws an exception of \"Sequence is a\n           protein. Cannot revcom\"\n\n           The id is the same id as the original sequence, and the\n           accession number is also indentical. If someone wants to\n           track that this sequence has be reversed, it needs to\n           define its own extensions\n\n           To do an inplace edit of an object you can go:\n\n           $seq = $seq->revcom();\n\n           This of course, causes Perl to handle the garbage\n           collection of the old object, but it is roughly speaking as\n           efficient as an inplace edit.\n\n Returns : A new (fresh) Bio::PrimarySeqI object\n Args    : none\n\n\n\nsub revcom{\n   my ($self) = @_;\n\n\n   # check the type is good first.\n   my $t = $self->alphabet;\n\n   if( $t eq 'protein' ) {\n       $self->throw(-class => 'Bio::Root::Exception',\n\t\t    -text  => \"Sequence is a protein. Cannot revcom\");\n   }\n\n   if( $t ne 'dna' && $t ne 'rna' ) {\n       if( $self->can('warn') ) {\n\t   $self->warn(\"Sequence is not dna or rna, but [$t]. \".\n\t\t       \"Attempting to revcom, but unsure if this is right\");\n       } else {\n\t   warn(\"[$self] Sequence is not dna or rna, but [$t]. \".\n\t\t\"Attempting to revcom, but unsure if this is right\");\n       }\n   }\n\n   # yank out the sequence string\n\n   my $str = $self->seq();\n\n   # if is RNA - map to DNA then map back\n\n   if( $t eq 'rna' ) {\n       $str =~ tr/uU/tT/;\n   }\n\n   # revcom etc...\n\n   $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n   my $revseq = CORE::reverse $str;\n\n   if( $t eq 'rna' ) {\n       $revseq =~ tr/tT/uU/;\n   }\n\n   my $seqclass;\n   if($self->can_call_new()) {\n       $seqclass = ref($self);\n   } else {\n       $seqclass = 'Bio::PrimarySeq';\n       $self->_attempt_to_load_Seq();\n   }\n   my $out = $seqclass->new( '-seq' => $revseq,\n\t\t\t     '-display_id'  => $self->display_id,\n\t\t\t     '-accession_number' => $self->accession_number,\n\t\t\t     '-alphabet' => $self->alphabet,\n\t\t\t     '-desc' => $self->desc()\n\t\t\t     );\n   return $out;\n\n}\n\n=head2 trunc\n\n Title   : trunc\n Usage   : $subseq = $myseq->trunc(10,100);\n Function: Provides a truncation of a sequence,\n\n Example :\n Returns : a fresh Bio::PrimarySeqI implementing object\n Args    : Two integers denoting first and last base of the sub-sequence."},"detail":"($self,$start,$end)","definition":"sub","containerName":"main::","children":[{"name":"$self","definition":"my","containerName":"trunc","localvar":"my","kind":13,"line":454},{"containerName":"trunc","name":"$start","kind":13,"line":454},{"containerName":"trunc","name":"$end","kind":13,"line":454},{"kind":13,"line":456,"containerName":"trunc","name":"$str","definition":"my","localvar":"my"},{"kind":13,"line":457,"name":"$start","containerName":"trunc"},{"containerName":"trunc","name":"$start","kind":13,"line":457},{"containerName":"trunc","name":"$start","kind":13,"line":458},{"containerName":"trunc","name":"isa","line":458,"kind":12},{"line":459,"kind":13,"containerName":"trunc","name":"$str"},{"containerName":"trunc","name":"$self","line":459,"kind":13},{"line":459,"kind":12,"containerName":"trunc","name":"subseq"},{"kind":13,"line":459,"containerName":"trunc","name":"$start"},{"kind":13,"line":460,"containerName":"trunc","name":"$end"},{"name":"$self","containerName":"trunc","line":461,"kind":13},{"line":461,"kind":12,"name":"throw","containerName":"trunc"},{"kind":13,"line":462,"name":"$end","containerName":"trunc"},{"containerName":"trunc","name":"$start","line":462,"kind":13},{"kind":13,"line":463,"definition":"my","name":"$msg","containerName":"trunc","localvar":"my"},{"containerName":"trunc","name":"$self","kind":13,"line":466},{"line":466,"kind":12,"containerName":"trunc","name":"throw"},{"line":466,"kind":13,"containerName":"trunc","name":"$msg"},{"kind":13,"line":468,"containerName":"trunc","name":"$str"},{"line":468,"kind":13,"name":"$self","containerName":"trunc"},{"name":"subseq","containerName":"trunc","kind":12,"line":468},{"name":"$start","containerName":"trunc","kind":13,"line":468},{"containerName":"trunc","name":"$end","line":468,"kind":13},{"line":471,"kind":13,"localvar":"my","containerName":"trunc","name":"$seqclass","definition":"my"},{"containerName":"trunc","name":"$self","line":472,"kind":13},{"containerName":"trunc","name":"can_call_new","kind":12,"line":472},{"kind":13,"line":473,"containerName":"trunc","name":"$seqclass"},{"line":473,"kind":13,"containerName":"trunc","name":"$self"},{"line":475,"kind":13,"containerName":"trunc","name":"$seqclass"},{"name":"$self","containerName":"trunc","kind":13,"line":476},{"containerName":"trunc","name":"_attempt_to_load_Seq","kind":12,"line":476},{"definition":"my","name":"$out","containerName":"trunc","localvar":"my","kind":13,"line":479},{"name":"$seqclass","containerName":"trunc","line":479,"kind":13},{"containerName":"trunc","name":"new","line":479,"kind":12},{"containerName":"trunc","name":"$str","line":479,"kind":13},{"name":"$self","containerName":"trunc","kind":13,"line":480},{"line":480,"kind":12,"containerName":"trunc","name":"display_id"},{"containerName":"trunc","name":"$self","line":481,"kind":13},{"name":"accession_number","containerName":"trunc","line":481,"kind":12},{"line":482,"kind":13,"name":"$self","containerName":"trunc"},{"containerName":"trunc","name":"alphabet","line":482,"kind":12},{"line":483,"kind":13,"containerName":"trunc","name":"$self"},{"line":483,"kind":12,"containerName":"trunc","name":"desc"},{"containerName":"trunc","name":"$out","kind":13,"line":485}],"line":453,"kind":12},{"name":"translate","range":{"end":{"character":9999,"line":612},"start":{"character":0,"line":518}},"containerName":"main::","definition":"sub","detail":"($stop,$unknown,$frame,$tableid,$fullCDS,$throw)","signature":{"parameters":[{"label":"$stop"},{"label":"$unknown"},{"label":"$frame"},{"label":"$tableid"},{"label":"$fullCDS"},{"label":"$throw"}],"documentation":"1;\n# $Id: PrimarySeqI.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::PrimarySeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PrimarySeqI [Developers] - Interface definition for a Bio::PrimarySeq\n\n=head1 SYNOPSIS\n\n\n    # Bio::PrimarySeqI is the interface class for sequences.\n\n    # If you are a newcomer to bioperl, you should\n    # start with Bio::Seq documentation. This\n    # documentation is mainly for developers using\n    # Bioperl.\n\n    # to test this is a seq object\n\n    $obj->isa(\"Bio::PrimarySeqI\") ||\n      $obj->throw(\"$obj does not implement the Bio::PrimarySeqI interface\");\n\n    # accessors\n\n    $string    = $obj->seq();\n    $substring = $obj->subseq(12,50);\n    $display   = $obj->display_id(); # for human display\n    $id        = $obj->primary_id(); # unique id for this object,\n                                     # implementation defined\n    $unique_key= $obj->accession_number();\n                       # unique biological id\n\n    # object manipulation\n\n    eval {\n\t$rev    = $obj->revcom();\n    };\n    if( $@ ) {\n\t$obj->throw(-class => 'Bio::Root::Exception',\n                    -text => \"Could not reverse complement. \".\n\t\t             \"Probably not DNA. Actual exception\\n$@\\n\",\n                    -value => $@);\n    }\n\n    $trunc = $obj->trunc(12,50);\n\n    # $rev and $trunc are Bio::PrimarySeqI compliant objects\n\n\n=head1 DESCRIPTION\n\nThis object defines an abstract interface to basic sequence\ninformation - for most users of the package the documentation (and\nmethods) in this class are not useful - this is a developers only\nclass which defines what methods have to be implmented by other Perl\nobjects to comply to the Bio::PrimarySeqI interface. Go \"perldoc\nBio::Seq\" or \"man Bio::Seq\" for more information on the main class for\nsequences.\n\n\nPrimarySeq is an object just for the sequence and its name(s), nothing\nmore. Seq is the larger object complete with features. There is a pure\nperl implementation of this in Bio::PrimarySeq. If you just want to\nuse Bio::PrimarySeq objects, then please read that module first. This\nmodule defines the interface, and is of more interest to people who\nwant to wrap their own Perl Objects/RDBs/FileSystems etc in way that\nthey \"are\" bioperl sequence objects, even though it is not using Perl\nto store the sequence etc.\n\n\nThis interface defines what bioperl consideres necessary to \"be\" a\nsequence, without providing an implementation of this. (An\nimplementation is provided in Bio::PrimarySeq). If you want to provide\na Bio::PrimarySeq 'compliant' object which in fact wraps another\nobject/database/out-of-perl experience, then this is the correct thing\nto wrap, generally by providing a wrapper class which would inheriet\nfrom your object and this Bio::PrimarySeqI interface. The wrapper class\nthen would have methods lists in the \"Implementation Specific\nFunctions\" which would provide these methods for your object.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n \nPlease direct usage questions or support issues to the mailing list:\n  \nL<bioperl-l@bioperl.org>\n  \nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@sanger.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PrimarySeqI;\nuse strict;\nuse Bio::Tools::CodonTable;\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Implementation Specific Functions\n\nThese functions are the ones that a specific implementation must\ndefine.\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard),\n           but implementations are suggested to keep an open mind about\n           case (some users... want mixed case!)\n Returns : A scalar\n Status  : Virtual\n\n\nsub seq {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n Function: returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n\n           Start cannot be larger than end but can be equal\n\n Returns : a string\n Args    :\n Status  : Virtual\n\n\nsub subseq{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, aka the common name of the Sequence object.\n\n           The semantics of this is that it is the most likely string\n           to be used as an identifier of the sequence, and likely to\n           have \"human\" readability.  The id is equivalent to the ID\n           field of the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id\n           to embed other information. Bioperl does not use any\n           embedded information in the ID field, and people are\n           encouraged to use other mechanisms (accession field for\n           example, or extending the sequence object) to solve this.\n\n           Notice that $seq->id() maps to this function, mainly for\n           legacy/convience issues\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub display_id {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 accession_number\n\n Title   : accession_number\n Usage   : $unique_biological_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number. For sequences from established\n           databases, the implementors should try to use the correct\n           accession number. Notice that primary_id() provides the\n           unique id for the implemetation, allowing multiple objects\n           to have the same accession number in a particular implementation.\n\n           For sequences with no accession number, this method should return\n           \"unknown\".\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub accession_number {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_implementation_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their\n           own object ids in a way the implementaiton can control\n           clients can expect one id to map to one object.\n\n           For sequences with no accession number, this method should\n           return a stringified memory location.\n\n           [Note this method name is likely to change in 1.3]\n\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub primary_id {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 can_call_new\n\n Title   : can_call_new\n Usage   : if( $obj->can_call_new ) {\n             $newobj = $obj->new( %param );\n\t }\n Function: can_call_new returns 1 or 0 depending\n           on whether an implementation allows new\n           constructor to be called. If a new constructor\n           is allowed, then it should take the followed hashed\n           constructor list.\n\n           $myobject->new( -seq => $sequence_as_string,\n\t\t\t   -display_id  => $id\n\t\t\t   -accession_number => $accession\n\t\t\t   -alphabet => 'dna',\n\t\t\t   );\n Example :\n Returns : 1 or 0\n Args    :\n\n\n\nsub can_call_new{\n   my ($self,@args) = @_;\n\n   # we default to 0 here\n\n   return 0;\n}\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Returns the type of sequence being one of\n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n           This is not called <type> because this would cause\n           upgrade problems from the 0.5 and earlier Seq objects.\n\n Returns : a string either 'dna','rna','protein'. NB - the object must\n           make a call of the type - if there is no type specified it\n           has to guess.\n Args    : none\n Status  : Virtual\n\n\n\nsub alphabet{\n    my ( $self ) = @_;\n    $self->throw_not_implemented();\n}\n\nsub moltype{\n   my ($self,@args) = @_;\n\n   $self->warn(\"moltype: pre v1.0 method. Calling alphabet() instead...\");\n   $self->alphabet(@args);\n}\n\n\n=head1 Optional Implementation Functions\n\nThe following functions rely on the above functions. An\nimplementing class does not need to provide these functions, as they\nwill be provided by this class, but is free to override these\nfunctions.\n\nAll of revcom(), trunc(), and translate() create new sequence\nobjects. They will call new() on the class of the sequence object\ninstance passed as argument, unless can_call_new() returns FALSE. In\nthe latter case a Bio::PrimarySeq object will be created. Implementors\nwhich really want to control how objects are created (eg, for object\npersistence over a database, or objects in a CORBA framework), they\nare encouraged to override these methods\n\n=head2 revcom\n\n Title   : revcom\n Usage   : $rev = $seq->revcom()\n Function: Produces a new Bio::PrimarySeqI implementing object which\n           is the reversed complement of the sequence. For protein\n           sequences this throws an exception of \"Sequence is a\n           protein. Cannot revcom\"\n\n           The id is the same id as the original sequence, and the\n           accession number is also indentical. If someone wants to\n           track that this sequence has be reversed, it needs to\n           define its own extensions\n\n           To do an inplace edit of an object you can go:\n\n           $seq = $seq->revcom();\n\n           This of course, causes Perl to handle the garbage\n           collection of the old object, but it is roughly speaking as\n           efficient as an inplace edit.\n\n Returns : A new (fresh) Bio::PrimarySeqI object\n Args    : none\n\n\n\nsub revcom{\n   my ($self) = @_;\n\n\n   # check the type is good first.\n   my $t = $self->alphabet;\n\n   if( $t eq 'protein' ) {\n       $self->throw(-class => 'Bio::Root::Exception',\n\t\t    -text  => \"Sequence is a protein. Cannot revcom\");\n   }\n\n   if( $t ne 'dna' && $t ne 'rna' ) {\n       if( $self->can('warn') ) {\n\t   $self->warn(\"Sequence is not dna or rna, but [$t]. \".\n\t\t       \"Attempting to revcom, but unsure if this is right\");\n       } else {\n\t   warn(\"[$self] Sequence is not dna or rna, but [$t]. \".\n\t\t\"Attempting to revcom, but unsure if this is right\");\n       }\n   }\n\n   # yank out the sequence string\n\n   my $str = $self->seq();\n\n   # if is RNA - map to DNA then map back\n\n   if( $t eq 'rna' ) {\n       $str =~ tr/uU/tT/;\n   }\n\n   # revcom etc...\n\n   $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n   my $revseq = CORE::reverse $str;\n\n   if( $t eq 'rna' ) {\n       $revseq =~ tr/tT/uU/;\n   }\n\n   my $seqclass;\n   if($self->can_call_new()) {\n       $seqclass = ref($self);\n   } else {\n       $seqclass = 'Bio::PrimarySeq';\n       $self->_attempt_to_load_Seq();\n   }\n   my $out = $seqclass->new( '-seq' => $revseq,\n\t\t\t     '-display_id'  => $self->display_id,\n\t\t\t     '-accession_number' => $self->accession_number,\n\t\t\t     '-alphabet' => $self->alphabet,\n\t\t\t     '-desc' => $self->desc()\n\t\t\t     );\n   return $out;\n\n}\n\n=head2 trunc\n\n Title   : trunc\n Usage   : $subseq = $myseq->trunc(10,100);\n Function: Provides a truncation of a sequence,\n\n Example :\n Returns : a fresh Bio::PrimarySeqI implementing object\n Args    : Two integers denoting first and last base of the sub-sequence.\n\n\n\nsub trunc{\n   my ($self,$start,$end) = @_;\n\n   my $str;\n   if( defined $start && ref($start) &&\n       $start->isa('Bio::LocationI') ) {\n       $str = $self->subseq($start); # start is a location actually\n   } elsif( !$end ) {\n       $self->throw(\"trunc start,end -- there was no end for $start\");\n   } elsif( $end < $start ) {\n       my $msg = \"start [$start] is greater than end [$end]. \\n\".\n\t   \"If you want to truncated and reverse complement, \\n\".\n\t       \"you must call trunc followed by revcom. Sorry.\";\n       $self->throw($msg);\n   } else {\n       $str = $self->subseq($start,$end);\n   }\n\n   my $seqclass;\n   if($self->can_call_new()) {\n       $seqclass = ref($self);\n   } else {\n       $seqclass = 'Bio::PrimarySeq';\n       $self->_attempt_to_load_Seq();\n   }\n\n   my $out = $seqclass->new( '-seq' => $str,\n\t\t\t     '-display_id'  => $self->display_id,\n\t\t\t     '-accession_number' => $self->accession_number,\n\t\t\t     '-alphabet' => $self->alphabet,\n\t\t\t     '-desc' => $self->desc()\n\t\t\t     );\n   return $out;\n}\n\n\n=head2 translate\n\n Title   : translate\n Usage   : $protein_seq_obj = $dna_seq_obj->translate\n\n Function:\n\n           Provides the translation of the DNA sequence using full\n           IUPAC ambiguities in DNA/RNA and amino acid codes.\n\n           The full CDS translation is identical to EMBL/TREMBL\n           database translation. Note that the trailing terminator\n           character is removed before returning the translation\n           object.\n\n           Note: if you set $dna_seq_obj->verbose(1) you will get a\n           warning if the first codon is not a valid initiator.\n\n\n Returns : A Bio::PrimarySeqI implementing object\n Args    : character for terminator (optional) defaults to '*'\n           character for unknown amino acid (optional) defaults to 'X'\n           frame (optional) valid values 0, 1, 2, defaults to 0\n           codon table id (optional) defaults to 1\n           complete coding sequence expected, defaults to 0 (false)\n           boolean, throw exception if not complete CDS (true) or defaults to warning (false)","label":"translate($stop,$unknown,$frame,$tableid,$fullCDS,$throw)"},"kind":12,"line":518,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"translate","line":519,"kind":13},{"name":"$stop","definition":"my","containerName":"translate","localvar":"my","kind":13,"line":520},{"name":"$unknown","containerName":"translate","line":520,"kind":13},{"containerName":"translate","name":"$frame","kind":13,"line":520},{"kind":13,"line":520,"name":"$tableid","containerName":"translate"},{"name":"$fullCDS","containerName":"translate","line":520,"kind":13},{"line":520,"kind":13,"containerName":"translate","name":"$throw"},{"line":521,"kind":13,"localvar":"my","containerName":"translate","definition":"my","name":"$i"},{"containerName":"translate","name":"$len","kind":13,"line":521},{"line":521,"kind":13,"name":"$output","containerName":"translate"},{"kind":13,"line":522,"name":"$codon","definition":"my","containerName":"translate","localvar":"my"},{"localvar":"my","containerName":"translate","definition":"my","name":"$aa","line":523,"kind":13},{"containerName":"translate","name":"$stop","kind":13,"line":526},{"kind":13,"line":526,"containerName":"translate","name":"$stop"},{"line":526,"kind":13,"containerName":"translate","name":"$stop"},{"kind":13,"line":527,"containerName":"translate","name":"$unknown"},{"name":"$unknown","containerName":"translate","kind":13,"line":527},{"kind":13,"line":527,"name":"$unknown","containerName":"translate"},{"name":"$frame","containerName":"translate","kind":13,"line":528},{"line":528,"kind":13,"name":"$frame","containerName":"translate"},{"name":"$frame","containerName":"translate","kind":13,"line":528},{"kind":13,"line":531,"containerName":"translate","name":"$tableid"},{"containerName":"translate","name":"$tableid","line":531,"kind":13},{"line":531,"kind":13,"name":"$tableid","containerName":"translate"},{"line":534,"kind":13,"name":"$self","containerName":"translate"},{"name":"alphabet","containerName":"translate","kind":12,"line":534},{"containerName":"translate","name":"$self","line":535,"kind":13},{"containerName":"translate","name":"throw","kind":12,"line":535},{"name":"$frame","containerName":"translate","kind":13,"line":540},{"name":"$frame","containerName":"translate","line":540,"kind":13},{"name":"$frame","containerName":"translate","line":540,"kind":13},{"containerName":"translate","name":"$self","line":541,"kind":13},{"name":"throw","containerName":"translate","line":541,"kind":12},{"containerName":"translate","name":"$frame","kind":13,"line":543},{"localvar":"my","containerName":"translate","name":"$codonTable","definition":"my","line":547,"kind":13},{"name":"new","containerName":"translate","line":547,"kind":12},{"containerName":"translate","name":"$tableid","line":547,"kind":13},{"kind":13,"line":549,"definition":"my","name":"$seq","containerName":"translate","localvar":"my"},{"name":"$self","containerName":"translate","kind":13,"line":549},{"name":"seq","containerName":"translate","kind":12,"line":549},{"line":552,"kind":13,"name":"$frame","containerName":"translate"},{"kind":13,"line":553,"containerName":"translate","name":"$seq"},{"containerName":"translate","name":"$seq","line":553,"kind":13},{"kind":13,"line":553,"containerName":"translate","name":"$frame"},{"kind":13,"line":557,"containerName":"translate","name":"$output"},{"name":"$codonTable","containerName":"translate","kind":13,"line":557},{"kind":12,"line":557,"name":"translate","containerName":"translate"},{"containerName":"translate","name":"$seq","line":557,"kind":13},{"kind":13,"line":559,"containerName":"translate","name":"$output"},{"kind":13,"line":560,"name":"$output","containerName":"translate"},{"containerName":"translate","name":"$fullCDS","kind":13,"line":563},{"kind":13,"line":564,"containerName":"translate","name":"$id","definition":"my","localvar":"my"},{"line":564,"kind":13,"name":"$self","containerName":"translate"},{"kind":12,"line":564,"containerName":"translate","name":"display_id"},{"name":"$output","containerName":"translate","line":566,"kind":13},{"containerName":"translate","name":"$stop","kind":13,"line":566},{"name":"$output","containerName":"translate","line":567,"kind":13},{"line":569,"kind":13,"name":"$throw","containerName":"translate"},{"kind":13,"line":569,"containerName":"translate","name":"$self"},{"kind":12,"line":569,"name":"throw","containerName":"translate"},{"containerName":"translate","name":"$output","line":570,"kind":13},{"line":571,"kind":13,"name":"$output","containerName":"translate"},{"containerName":"translate","name":"$self","kind":13,"line":572},{"containerName":"translate","name":"warn","line":572,"kind":12},{"name":"$output","containerName":"translate","line":572,"kind":13},{"kind":13,"line":575,"containerName":"translate","name":"$output"},{"line":576,"kind":13,"name":"$throw","containerName":"translate"},{"line":576,"kind":13,"name":"$self","containerName":"translate"},{"containerName":"translate","name":"throw","kind":12,"line":576},{"kind":13,"line":578,"name":"$self","containerName":"translate"},{"kind":12,"line":578,"name":"warn","containerName":"translate"},{"line":581,"kind":13,"containerName":"translate","name":"$output"},{"line":582,"kind":13,"containerName":"translate","name":"$codonTable"},{"kind":12,"line":582,"containerName":"translate","name":"is_start_codon"},{"containerName":"translate","name":"$seq","kind":13,"line":582},{"line":583,"kind":13,"name":"$output","containerName":"translate"},{"line":583,"kind":13,"containerName":"translate","name":"$output"},{"line":585,"kind":13,"containerName":"translate","name":"$throw"},{"name":"$self","containerName":"translate","line":586,"kind":13},{"name":"throw","containerName":"translate","line":586,"kind":12},{"name":"$seq","containerName":"translate","kind":13,"line":587},{"kind":13,"line":588,"containerName":"translate","name":"$seq"},{"containerName":"translate","name":"$self","kind":13,"line":590},{"containerName":"translate","name":"warn","line":590,"kind":12},{"localvar":"my","containerName":"translate","definition":"my","name":"$seqclass","line":595,"kind":13},{"containerName":"translate","name":"$self","kind":13,"line":596},{"containerName":"translate","name":"can_call_new","kind":12,"line":596},{"kind":13,"line":597,"containerName":"translate","name":"$seqclass"},{"name":"$self","containerName":"translate","line":597,"kind":13},{"name":"$seqclass","containerName":"translate","line":599,"kind":13},{"kind":13,"line":600,"name":"$self","containerName":"translate"},{"containerName":"translate","name":"_attempt_to_load_Seq","line":600,"kind":12},{"kind":13,"line":602,"containerName":"translate","definition":"my","name":"$out","localvar":"my"},{"containerName":"translate","name":"$seqclass","kind":13,"line":602},{"line":602,"kind":12,"containerName":"translate","name":"new"},{"name":"$output","containerName":"translate","kind":13,"line":602},{"kind":13,"line":603,"containerName":"translate","name":"$self"},{"kind":12,"line":603,"containerName":"translate","name":"display_id"},{"line":604,"kind":13,"containerName":"translate","name":"$self"},{"name":"accession_number","containerName":"translate","kind":12,"line":604},{"name":"$self","containerName":"translate","line":607,"kind":13},{"containerName":"translate","name":"desc","line":607,"kind":12},{"line":610,"kind":13,"containerName":"translate","name":"$out"}]},{"containerName":"Tools::CodonTable","name":"Bio","kind":12,"line":547},{"range":{"start":{"line":627,"character":0},"end":{"character":9999,"line":631}},"name":"id","detail":"($self)","signature":{"label":"id($self)","documentation":"1;\n# $Id: PrimarySeqI.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::PrimarySeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PrimarySeqI [Developers] - Interface definition for a Bio::PrimarySeq\n\n=head1 SYNOPSIS\n\n\n    # Bio::PrimarySeqI is the interface class for sequences.\n\n    # If you are a newcomer to bioperl, you should\n    # start with Bio::Seq documentation. This\n    # documentation is mainly for developers using\n    # Bioperl.\n\n    # to test this is a seq object\n\n    $obj->isa(\"Bio::PrimarySeqI\") ||\n      $obj->throw(\"$obj does not implement the Bio::PrimarySeqI interface\");\n\n    # accessors\n\n    $string    = $obj->seq();\n    $substring = $obj->subseq(12,50);\n    $display   = $obj->display_id(); # for human display\n    $id        = $obj->primary_id(); # unique id for this object,\n                                     # implementation defined\n    $unique_key= $obj->accession_number();\n                       # unique biological id\n\n    # object manipulation\n\n    eval {\n\t$rev    = $obj->revcom();\n    };\n    if( $@ ) {\n\t$obj->throw(-class => 'Bio::Root::Exception',\n                    -text => \"Could not reverse complement. \".\n\t\t             \"Probably not DNA. Actual exception\\n$@\\n\",\n                    -value => $@);\n    }\n\n    $trunc = $obj->trunc(12,50);\n\n    # $rev and $trunc are Bio::PrimarySeqI compliant objects\n\n\n=head1 DESCRIPTION\n\nThis object defines an abstract interface to basic sequence\ninformation - for most users of the package the documentation (and\nmethods) in this class are not useful - this is a developers only\nclass which defines what methods have to be implmented by other Perl\nobjects to comply to the Bio::PrimarySeqI interface. Go \"perldoc\nBio::Seq\" or \"man Bio::Seq\" for more information on the main class for\nsequences.\n\n\nPrimarySeq is an object just for the sequence and its name(s), nothing\nmore. Seq is the larger object complete with features. There is a pure\nperl implementation of this in Bio::PrimarySeq. If you just want to\nuse Bio::PrimarySeq objects, then please read that module first. This\nmodule defines the interface, and is of more interest to people who\nwant to wrap their own Perl Objects/RDBs/FileSystems etc in way that\nthey \"are\" bioperl sequence objects, even though it is not using Perl\nto store the sequence etc.\n\n\nThis interface defines what bioperl consideres necessary to \"be\" a\nsequence, without providing an implementation of this. (An\nimplementation is provided in Bio::PrimarySeq). If you want to provide\na Bio::PrimarySeq 'compliant' object which in fact wraps another\nobject/database/out-of-perl experience, then this is the correct thing\nto wrap, generally by providing a wrapper class which would inheriet\nfrom your object and this Bio::PrimarySeqI interface. The wrapper class\nthen would have methods lists in the \"Implementation Specific\nFunctions\" which would provide these methods for your object.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n \nPlease direct usage questions or support issues to the mailing list:\n  \nL<bioperl-l@bioperl.org>\n  \nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@sanger.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PrimarySeqI;\nuse strict;\nuse Bio::Tools::CodonTable;\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Implementation Specific Functions\n\nThese functions are the ones that a specific implementation must\ndefine.\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard),\n           but implementations are suggested to keep an open mind about\n           case (some users... want mixed case!)\n Returns : A scalar\n Status  : Virtual\n\n\nsub seq {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n Function: returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n\n           Start cannot be larger than end but can be equal\n\n Returns : a string\n Args    :\n Status  : Virtual\n\n\nsub subseq{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, aka the common name of the Sequence object.\n\n           The semantics of this is that it is the most likely string\n           to be used as an identifier of the sequence, and likely to\n           have \"human\" readability.  The id is equivalent to the ID\n           field of the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id\n           to embed other information. Bioperl does not use any\n           embedded information in the ID field, and people are\n           encouraged to use other mechanisms (accession field for\n           example, or extending the sequence object) to solve this.\n\n           Notice that $seq->id() maps to this function, mainly for\n           legacy/convience issues\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub display_id {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 accession_number\n\n Title   : accession_number\n Usage   : $unique_biological_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number. For sequences from established\n           databases, the implementors should try to use the correct\n           accession number. Notice that primary_id() provides the\n           unique id for the implemetation, allowing multiple objects\n           to have the same accession number in a particular implementation.\n\n           For sequences with no accession number, this method should return\n           \"unknown\".\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub accession_number {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_implementation_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their\n           own object ids in a way the implementaiton can control\n           clients can expect one id to map to one object.\n\n           For sequences with no accession number, this method should\n           return a stringified memory location.\n\n           [Note this method name is likely to change in 1.3]\n\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub primary_id {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 can_call_new\n\n Title   : can_call_new\n Usage   : if( $obj->can_call_new ) {\n             $newobj = $obj->new( %param );\n\t }\n Function: can_call_new returns 1 or 0 depending\n           on whether an implementation allows new\n           constructor to be called. If a new constructor\n           is allowed, then it should take the followed hashed\n           constructor list.\n\n           $myobject->new( -seq => $sequence_as_string,\n\t\t\t   -display_id  => $id\n\t\t\t   -accession_number => $accession\n\t\t\t   -alphabet => 'dna',\n\t\t\t   );\n Example :\n Returns : 1 or 0\n Args    :\n\n\n\nsub can_call_new{\n   my ($self,@args) = @_;\n\n   # we default to 0 here\n\n   return 0;\n}\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Returns the type of sequence being one of\n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n           This is not called <type> because this would cause\n           upgrade problems from the 0.5 and earlier Seq objects.\n\n Returns : a string either 'dna','rna','protein'. NB - the object must\n           make a call of the type - if there is no type specified it\n           has to guess.\n Args    : none\n Status  : Virtual\n\n\n\nsub alphabet{\n    my ( $self ) = @_;\n    $self->throw_not_implemented();\n}\n\nsub moltype{\n   my ($self,@args) = @_;\n\n   $self->warn(\"moltype: pre v1.0 method. Calling alphabet() instead...\");\n   $self->alphabet(@args);\n}\n\n\n=head1 Optional Implementation Functions\n\nThe following functions rely on the above functions. An\nimplementing class does not need to provide these functions, as they\nwill be provided by this class, but is free to override these\nfunctions.\n\nAll of revcom(), trunc(), and translate() create new sequence\nobjects. They will call new() on the class of the sequence object\ninstance passed as argument, unless can_call_new() returns FALSE. In\nthe latter case a Bio::PrimarySeq object will be created. Implementors\nwhich really want to control how objects are created (eg, for object\npersistence over a database, or objects in a CORBA framework), they\nare encouraged to override these methods\n\n=head2 revcom\n\n Title   : revcom\n Usage   : $rev = $seq->revcom()\n Function: Produces a new Bio::PrimarySeqI implementing object which\n           is the reversed complement of the sequence. For protein\n           sequences this throws an exception of \"Sequence is a\n           protein. Cannot revcom\"\n\n           The id is the same id as the original sequence, and the\n           accession number is also indentical. If someone wants to\n           track that this sequence has be reversed, it needs to\n           define its own extensions\n\n           To do an inplace edit of an object you can go:\n\n           $seq = $seq->revcom();\n\n           This of course, causes Perl to handle the garbage\n           collection of the old object, but it is roughly speaking as\n           efficient as an inplace edit.\n\n Returns : A new (fresh) Bio::PrimarySeqI object\n Args    : none\n\n\n\nsub revcom{\n   my ($self) = @_;\n\n\n   # check the type is good first.\n   my $t = $self->alphabet;\n\n   if( $t eq 'protein' ) {\n       $self->throw(-class => 'Bio::Root::Exception',\n\t\t    -text  => \"Sequence is a protein. Cannot revcom\");\n   }\n\n   if( $t ne 'dna' && $t ne 'rna' ) {\n       if( $self->can('warn') ) {\n\t   $self->warn(\"Sequence is not dna or rna, but [$t]. \".\n\t\t       \"Attempting to revcom, but unsure if this is right\");\n       } else {\n\t   warn(\"[$self] Sequence is not dna or rna, but [$t]. \".\n\t\t\"Attempting to revcom, but unsure if this is right\");\n       }\n   }\n\n   # yank out the sequence string\n\n   my $str = $self->seq();\n\n   # if is RNA - map to DNA then map back\n\n   if( $t eq 'rna' ) {\n       $str =~ tr/uU/tT/;\n   }\n\n   # revcom etc...\n\n   $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n   my $revseq = CORE::reverse $str;\n\n   if( $t eq 'rna' ) {\n       $revseq =~ tr/tT/uU/;\n   }\n\n   my $seqclass;\n   if($self->can_call_new()) {\n       $seqclass = ref($self);\n   } else {\n       $seqclass = 'Bio::PrimarySeq';\n       $self->_attempt_to_load_Seq();\n   }\n   my $out = $seqclass->new( '-seq' => $revseq,\n\t\t\t     '-display_id'  => $self->display_id,\n\t\t\t     '-accession_number' => $self->accession_number,\n\t\t\t     '-alphabet' => $self->alphabet,\n\t\t\t     '-desc' => $self->desc()\n\t\t\t     );\n   return $out;\n\n}\n\n=head2 trunc\n\n Title   : trunc\n Usage   : $subseq = $myseq->trunc(10,100);\n Function: Provides a truncation of a sequence,\n\n Example :\n Returns : a fresh Bio::PrimarySeqI implementing object\n Args    : Two integers denoting first and last base of the sub-sequence.\n\n\n\nsub trunc{\n   my ($self,$start,$end) = @_;\n\n   my $str;\n   if( defined $start && ref($start) &&\n       $start->isa('Bio::LocationI') ) {\n       $str = $self->subseq($start); # start is a location actually\n   } elsif( !$end ) {\n       $self->throw(\"trunc start,end -- there was no end for $start\");\n   } elsif( $end < $start ) {\n       my $msg = \"start [$start] is greater than end [$end]. \\n\".\n\t   \"If you want to truncated and reverse complement, \\n\".\n\t       \"you must call trunc followed by revcom. Sorry.\";\n       $self->throw($msg);\n   } else {\n       $str = $self->subseq($start,$end);\n   }\n\n   my $seqclass;\n   if($self->can_call_new()) {\n       $seqclass = ref($self);\n   } else {\n       $seqclass = 'Bio::PrimarySeq';\n       $self->_attempt_to_load_Seq();\n   }\n\n   my $out = $seqclass->new( '-seq' => $str,\n\t\t\t     '-display_id'  => $self->display_id,\n\t\t\t     '-accession_number' => $self->accession_number,\n\t\t\t     '-alphabet' => $self->alphabet,\n\t\t\t     '-desc' => $self->desc()\n\t\t\t     );\n   return $out;\n}\n\n\n=head2 translate\n\n Title   : translate\n Usage   : $protein_seq_obj = $dna_seq_obj->translate\n\n Function:\n\n           Provides the translation of the DNA sequence using full\n           IUPAC ambiguities in DNA/RNA and amino acid codes.\n\n           The full CDS translation is identical to EMBL/TREMBL\n           database translation. Note that the trailing terminator\n           character is removed before returning the translation\n           object.\n\n           Note: if you set $dna_seq_obj->verbose(1) you will get a\n           warning if the first codon is not a valid initiator.\n\n\n Returns : A Bio::PrimarySeqI implementing object\n Args    : character for terminator (optional) defaults to '*'\n           character for unknown amino acid (optional) defaults to 'X'\n           frame (optional) valid values 0, 1, 2, defaults to 0\n           codon table id (optional) defaults to 1\n           complete coding sequence expected, defaults to 0 (false)\n           boolean, throw exception if not complete CDS (true) or defaults to warning (false)\n\n\nsub translate {\n    my($self) = shift;\n    my($stop, $unknown, $frame, $tableid, $fullCDS, $throw) = @_;\n    my($i, $len, $output) = (0,0,'');\n    my($codon)   = \"\";\n    my $aa;\n\n    ## User can pass in symbol for stop and unknown codons\n    unless(defined($stop) and $stop ne '')    { $stop = \"*\"; }\n    unless(defined($unknown) and $unknown ne '') { $unknown = \"X\"; }\n    unless(defined($frame) and $frame ne '') { $frame = 0; }\n\n    ## the codon table ID\n    unless(defined($tableid) and $tableid ne '')    { $tableid = 1; }\n\n    ##Error if monomer is \"Amino\"\n    if ($self->alphabet eq 'protein') {\n\t$self->throw(-class => 'Bio::Root::Exception',\n\t\t     -text => \"Can't translate an amino acid sequence.\")\n    }\n\n    ##Error if frame is not 0, 1 or 2\n    unless ($frame == 0 or $frame == 1 or $frame == 2) {\n\t$self->throw(-class => 'Bio::Root::BadParameter',\n\t\t     -text   => \"Valid values for frame are 0, 1, 2, not [$frame].\",\n\t\t     -value => $frame);\n    }\n\n    #warns if ID is invalid\n    my $codonTable = Bio::Tools::CodonTable->new( -id => $tableid);\n\n    my ($seq) = $self->seq();\n\n    # deal with frame offset.\n    if( $frame ) {\n\t$seq = substr ($seq,$frame);\n    }\n\n    # Translate it\n    $output = $codonTable->translate($seq);\n    # Use user-input stop/unknown\n    $output =~ s/\\*/$stop/g;\n    $output =~ s/X/$unknown/g;\n\t\n    # only if we are expecting to translate a complete coding region\n    if ($fullCDS) {\n\tmy $id = $self->display_id;\n\t#remove the stop character\n\tif( substr($output,-1,1) eq $stop ) {\n\t    chop $output;\n\t} else {\n\t    $throw && $self->throw(-class => 'Bio::Root::Exception',\n\t\t\t\t   -text  => \"Seq [$id]: Not using a valid terminator codon!: \". substr($output,-1,1),\n\t\t\t\t   -value => substr($output,-1,1));\n\t    $self->warn(\"Seq [$id]: Not using a valid terminator codon!: \". substr($output,-1,1));\n\t}\n\t# test if there are terminator characters inside the protein sequence!\n\tif ($output =~ /\\*/) {\n\t    $throw && $self->throw(-class => 'Bio::Root::Exception',\n\t\t\t\t   -text  => \"Seq [$id]: Terminator codon inside CDS!\");\n\t    $self->warn(\"Seq [$id]: Terminator codon inside CDS!\");\n\t}\n\t# if the initiator codon is not ATG, the amino acid needs to changed into M\n\tif ( substr($output,0,1) ne 'M' ) {\n\t    if ($codonTable->is_start_codon(substr($seq, 0, 3)) ) {\n\t\t$output = 'M'. substr($output,1);\n\t    }\n\t    elsif ($throw) {\n\t\t$self->throw(-class => 'Bio::Root::Exception',\n\t\t\t     -text => \"Seq [$id]: Not using a valid initiator codon!: \". substr($seq, 0, 3),\n\t\t\t     -value => substr($seq, 0, 3));\n\t    } else {\n\t\t$self->warn(\"Seq [$id]: Not using a valid initiator codon!\");\n\t    }\n\t}\n    }\n\n    my $seqclass;\n    if($self->can_call_new()) {\n\t$seqclass = ref($self);\n    } else {\n\t$seqclass = 'Bio::PrimarySeq';\n\t$self->_attempt_to_load_Seq();\n    }\n    my $out = $seqclass->new( '-seq' => $output,\n\t\t\t      '-display_id'  => $self->display_id,\n\t\t\t      '-accession_number' => $self->accession_number,\n\t\t\t      # is there anything wrong with retaining the\n\t\t\t      # description?\n\t\t\t      '-desc' => $self->desc(),\n\t\t\t      '-alphabet' => 'protein'\n\t\t\t    );\n    return $out;\n\n}\n\n=head2 id\n\n Title   : id\n Usage   : $id = $seq->id()\n Function: ID of the sequence. This should normally be (and actually is in\n           the implementation provided here) just a synonym for display_id().\n Example :\n Returns : A string.\n Args    :","parameters":[{"label":"$self"}]},"containerName":"main::","definition":"sub","line":627,"children":[{"kind":13,"line":628,"containerName":"id","name":"$self","definition":"my","localvar":"my"},{"name":"$self","containerName":"id","line":630,"kind":13},{"name":"display_id","containerName":"id","line":630,"kind":12}],"kind":12},{"definition":"sub","containerName":"main::","signature":{"label":"length($self)","documentation":"1;\n# $Id: PrimarySeqI.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::PrimarySeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PrimarySeqI [Developers] - Interface definition for a Bio::PrimarySeq\n\n=head1 SYNOPSIS\n\n\n    # Bio::PrimarySeqI is the interface class for sequences.\n\n    # If you are a newcomer to bioperl, you should\n    # start with Bio::Seq documentation. This\n    # documentation is mainly for developers using\n    # Bioperl.\n\n    # to test this is a seq object\n\n    $obj->isa(\"Bio::PrimarySeqI\") ||\n      $obj->throw(\"$obj does not implement the Bio::PrimarySeqI interface\");\n\n    # accessors\n\n    $string    = $obj->seq();\n    $substring = $obj->subseq(12,50);\n    $display   = $obj->display_id(); # for human display\n    $id        = $obj->primary_id(); # unique id for this object,\n                                     # implementation defined\n    $unique_key= $obj->accession_number();\n                       # unique biological id\n\n    # object manipulation\n\n    eval {\n\t$rev    = $obj->revcom();\n    };\n    if( $@ ) {\n\t$obj->throw(-class => 'Bio::Root::Exception',\n                    -text => \"Could not reverse complement. \".\n\t\t             \"Probably not DNA. Actual exception\\n$@\\n\",\n                    -value => $@);\n    }\n\n    $trunc = $obj->trunc(12,50);\n\n    # $rev and $trunc are Bio::PrimarySeqI compliant objects\n\n\n=head1 DESCRIPTION\n\nThis object defines an abstract interface to basic sequence\ninformation - for most users of the package the documentation (and\nmethods) in this class are not useful - this is a developers only\nclass which defines what methods have to be implmented by other Perl\nobjects to comply to the Bio::PrimarySeqI interface. Go \"perldoc\nBio::Seq\" or \"man Bio::Seq\" for more information on the main class for\nsequences.\n\n\nPrimarySeq is an object just for the sequence and its name(s), nothing\nmore. Seq is the larger object complete with features. There is a pure\nperl implementation of this in Bio::PrimarySeq. If you just want to\nuse Bio::PrimarySeq objects, then please read that module first. This\nmodule defines the interface, and is of more interest to people who\nwant to wrap their own Perl Objects/RDBs/FileSystems etc in way that\nthey \"are\" bioperl sequence objects, even though it is not using Perl\nto store the sequence etc.\n\n\nThis interface defines what bioperl consideres necessary to \"be\" a\nsequence, without providing an implementation of this. (An\nimplementation is provided in Bio::PrimarySeq). If you want to provide\na Bio::PrimarySeq 'compliant' object which in fact wraps another\nobject/database/out-of-perl experience, then this is the correct thing\nto wrap, generally by providing a wrapper class which would inheriet\nfrom your object and this Bio::PrimarySeqI interface. The wrapper class\nthen would have methods lists in the \"Implementation Specific\nFunctions\" which would provide these methods for your object.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n \nPlease direct usage questions or support issues to the mailing list:\n  \nL<bioperl-l@bioperl.org>\n  \nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@sanger.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PrimarySeqI;\nuse strict;\nuse Bio::Tools::CodonTable;\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Implementation Specific Functions\n\nThese functions are the ones that a specific implementation must\ndefine.\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard),\n           but implementations are suggested to keep an open mind about\n           case (some users... want mixed case!)\n Returns : A scalar\n Status  : Virtual\n\n\nsub seq {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n Function: returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n\n           Start cannot be larger than end but can be equal\n\n Returns : a string\n Args    :\n Status  : Virtual\n\n\nsub subseq{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, aka the common name of the Sequence object.\n\n           The semantics of this is that it is the most likely string\n           to be used as an identifier of the sequence, and likely to\n           have \"human\" readability.  The id is equivalent to the ID\n           field of the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id\n           to embed other information. Bioperl does not use any\n           embedded information in the ID field, and people are\n           encouraged to use other mechanisms (accession field for\n           example, or extending the sequence object) to solve this.\n\n           Notice that $seq->id() maps to this function, mainly for\n           legacy/convience issues\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub display_id {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 accession_number\n\n Title   : accession_number\n Usage   : $unique_biological_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number. For sequences from established\n           databases, the implementors should try to use the correct\n           accession number. Notice that primary_id() provides the\n           unique id for the implemetation, allowing multiple objects\n           to have the same accession number in a particular implementation.\n\n           For sequences with no accession number, this method should return\n           \"unknown\".\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub accession_number {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_implementation_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their\n           own object ids in a way the implementaiton can control\n           clients can expect one id to map to one object.\n\n           For sequences with no accession number, this method should\n           return a stringified memory location.\n\n           [Note this method name is likely to change in 1.3]\n\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub primary_id {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 can_call_new\n\n Title   : can_call_new\n Usage   : if( $obj->can_call_new ) {\n             $newobj = $obj->new( %param );\n\t }\n Function: can_call_new returns 1 or 0 depending\n           on whether an implementation allows new\n           constructor to be called. If a new constructor\n           is allowed, then it should take the followed hashed\n           constructor list.\n\n           $myobject->new( -seq => $sequence_as_string,\n\t\t\t   -display_id  => $id\n\t\t\t   -accession_number => $accession\n\t\t\t   -alphabet => 'dna',\n\t\t\t   );\n Example :\n Returns : 1 or 0\n Args    :\n\n\n\nsub can_call_new{\n   my ($self,@args) = @_;\n\n   # we default to 0 here\n\n   return 0;\n}\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Returns the type of sequence being one of\n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n           This is not called <type> because this would cause\n           upgrade problems from the 0.5 and earlier Seq objects.\n\n Returns : a string either 'dna','rna','protein'. NB - the object must\n           make a call of the type - if there is no type specified it\n           has to guess.\n Args    : none\n Status  : Virtual\n\n\n\nsub alphabet{\n    my ( $self ) = @_;\n    $self->throw_not_implemented();\n}\n\nsub moltype{\n   my ($self,@args) = @_;\n\n   $self->warn(\"moltype: pre v1.0 method. Calling alphabet() instead...\");\n   $self->alphabet(@args);\n}\n\n\n=head1 Optional Implementation Functions\n\nThe following functions rely on the above functions. An\nimplementing class does not need to provide these functions, as they\nwill be provided by this class, but is free to override these\nfunctions.\n\nAll of revcom(), trunc(), and translate() create new sequence\nobjects. They will call new() on the class of the sequence object\ninstance passed as argument, unless can_call_new() returns FALSE. In\nthe latter case a Bio::PrimarySeq object will be created. Implementors\nwhich really want to control how objects are created (eg, for object\npersistence over a database, or objects in a CORBA framework), they\nare encouraged to override these methods\n\n=head2 revcom\n\n Title   : revcom\n Usage   : $rev = $seq->revcom()\n Function: Produces a new Bio::PrimarySeqI implementing object which\n           is the reversed complement of the sequence. For protein\n           sequences this throws an exception of \"Sequence is a\n           protein. Cannot revcom\"\n\n           The id is the same id as the original sequence, and the\n           accession number is also indentical. If someone wants to\n           track that this sequence has be reversed, it needs to\n           define its own extensions\n\n           To do an inplace edit of an object you can go:\n\n           $seq = $seq->revcom();\n\n           This of course, causes Perl to handle the garbage\n           collection of the old object, but it is roughly speaking as\n           efficient as an inplace edit.\n\n Returns : A new (fresh) Bio::PrimarySeqI object\n Args    : none\n\n\n\nsub revcom{\n   my ($self) = @_;\n\n\n   # check the type is good first.\n   my $t = $self->alphabet;\n\n   if( $t eq 'protein' ) {\n       $self->throw(-class => 'Bio::Root::Exception',\n\t\t    -text  => \"Sequence is a protein. Cannot revcom\");\n   }\n\n   if( $t ne 'dna' && $t ne 'rna' ) {\n       if( $self->can('warn') ) {\n\t   $self->warn(\"Sequence is not dna or rna, but [$t]. \".\n\t\t       \"Attempting to revcom, but unsure if this is right\");\n       } else {\n\t   warn(\"[$self] Sequence is not dna or rna, but [$t]. \".\n\t\t\"Attempting to revcom, but unsure if this is right\");\n       }\n   }\n\n   # yank out the sequence string\n\n   my $str = $self->seq();\n\n   # if is RNA - map to DNA then map back\n\n   if( $t eq 'rna' ) {\n       $str =~ tr/uU/tT/;\n   }\n\n   # revcom etc...\n\n   $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n   my $revseq = CORE::reverse $str;\n\n   if( $t eq 'rna' ) {\n       $revseq =~ tr/tT/uU/;\n   }\n\n   my $seqclass;\n   if($self->can_call_new()) {\n       $seqclass = ref($self);\n   } else {\n       $seqclass = 'Bio::PrimarySeq';\n       $self->_attempt_to_load_Seq();\n   }\n   my $out = $seqclass->new( '-seq' => $revseq,\n\t\t\t     '-display_id'  => $self->display_id,\n\t\t\t     '-accession_number' => $self->accession_number,\n\t\t\t     '-alphabet' => $self->alphabet,\n\t\t\t     '-desc' => $self->desc()\n\t\t\t     );\n   return $out;\n\n}\n\n=head2 trunc\n\n Title   : trunc\n Usage   : $subseq = $myseq->trunc(10,100);\n Function: Provides a truncation of a sequence,\n\n Example :\n Returns : a fresh Bio::PrimarySeqI implementing object\n Args    : Two integers denoting first and last base of the sub-sequence.\n\n\n\nsub trunc{\n   my ($self,$start,$end) = @_;\n\n   my $str;\n   if( defined $start && ref($start) &&\n       $start->isa('Bio::LocationI') ) {\n       $str = $self->subseq($start); # start is a location actually\n   } elsif( !$end ) {\n       $self->throw(\"trunc start,end -- there was no end for $start\");\n   } elsif( $end < $start ) {\n       my $msg = \"start [$start] is greater than end [$end]. \\n\".\n\t   \"If you want to truncated and reverse complement, \\n\".\n\t       \"you must call trunc followed by revcom. Sorry.\";\n       $self->throw($msg);\n   } else {\n       $str = $self->subseq($start,$end);\n   }\n\n   my $seqclass;\n   if($self->can_call_new()) {\n       $seqclass = ref($self);\n   } else {\n       $seqclass = 'Bio::PrimarySeq';\n       $self->_attempt_to_load_Seq();\n   }\n\n   my $out = $seqclass->new( '-seq' => $str,\n\t\t\t     '-display_id'  => $self->display_id,\n\t\t\t     '-accession_number' => $self->accession_number,\n\t\t\t     '-alphabet' => $self->alphabet,\n\t\t\t     '-desc' => $self->desc()\n\t\t\t     );\n   return $out;\n}\n\n\n=head2 translate\n\n Title   : translate\n Usage   : $protein_seq_obj = $dna_seq_obj->translate\n\n Function:\n\n           Provides the translation of the DNA sequence using full\n           IUPAC ambiguities in DNA/RNA and amino acid codes.\n\n           The full CDS translation is identical to EMBL/TREMBL\n           database translation. Note that the trailing terminator\n           character is removed before returning the translation\n           object.\n\n           Note: if you set $dna_seq_obj->verbose(1) you will get a\n           warning if the first codon is not a valid initiator.\n\n\n Returns : A Bio::PrimarySeqI implementing object\n Args    : character for terminator (optional) defaults to '*'\n           character for unknown amino acid (optional) defaults to 'X'\n           frame (optional) valid values 0, 1, 2, defaults to 0\n           codon table id (optional) defaults to 1\n           complete coding sequence expected, defaults to 0 (false)\n           boolean, throw exception if not complete CDS (true) or defaults to warning (false)\n\n\nsub translate {\n    my($self) = shift;\n    my($stop, $unknown, $frame, $tableid, $fullCDS, $throw) = @_;\n    my($i, $len, $output) = (0,0,'');\n    my($codon)   = \"\";\n    my $aa;\n\n    ## User can pass in symbol for stop and unknown codons\n    unless(defined($stop) and $stop ne '')    { $stop = \"*\"; }\n    unless(defined($unknown) and $unknown ne '') { $unknown = \"X\"; }\n    unless(defined($frame) and $frame ne '') { $frame = 0; }\n\n    ## the codon table ID\n    unless(defined($tableid) and $tableid ne '')    { $tableid = 1; }\n\n    ##Error if monomer is \"Amino\"\n    if ($self->alphabet eq 'protein') {\n\t$self->throw(-class => 'Bio::Root::Exception',\n\t\t     -text => \"Can't translate an amino acid sequence.\")\n    }\n\n    ##Error if frame is not 0, 1 or 2\n    unless ($frame == 0 or $frame == 1 or $frame == 2) {\n\t$self->throw(-class => 'Bio::Root::BadParameter',\n\t\t     -text   => \"Valid values for frame are 0, 1, 2, not [$frame].\",\n\t\t     -value => $frame);\n    }\n\n    #warns if ID is invalid\n    my $codonTable = Bio::Tools::CodonTable->new( -id => $tableid);\n\n    my ($seq) = $self->seq();\n\n    # deal with frame offset.\n    if( $frame ) {\n\t$seq = substr ($seq,$frame);\n    }\n\n    # Translate it\n    $output = $codonTable->translate($seq);\n    # Use user-input stop/unknown\n    $output =~ s/\\*/$stop/g;\n    $output =~ s/X/$unknown/g;\n\t\n    # only if we are expecting to translate a complete coding region\n    if ($fullCDS) {\n\tmy $id = $self->display_id;\n\t#remove the stop character\n\tif( substr($output,-1,1) eq $stop ) {\n\t    chop $output;\n\t} else {\n\t    $throw && $self->throw(-class => 'Bio::Root::Exception',\n\t\t\t\t   -text  => \"Seq [$id]: Not using a valid terminator codon!: \". substr($output,-1,1),\n\t\t\t\t   -value => substr($output,-1,1));\n\t    $self->warn(\"Seq [$id]: Not using a valid terminator codon!: \". substr($output,-1,1));\n\t}\n\t# test if there are terminator characters inside the protein sequence!\n\tif ($output =~ /\\*/) {\n\t    $throw && $self->throw(-class => 'Bio::Root::Exception',\n\t\t\t\t   -text  => \"Seq [$id]: Terminator codon inside CDS!\");\n\t    $self->warn(\"Seq [$id]: Terminator codon inside CDS!\");\n\t}\n\t# if the initiator codon is not ATG, the amino acid needs to changed into M\n\tif ( substr($output,0,1) ne 'M' ) {\n\t    if ($codonTable->is_start_codon(substr($seq, 0, 3)) ) {\n\t\t$output = 'M'. substr($output,1);\n\t    }\n\t    elsif ($throw) {\n\t\t$self->throw(-class => 'Bio::Root::Exception',\n\t\t\t     -text => \"Seq [$id]: Not using a valid initiator codon!: \". substr($seq, 0, 3),\n\t\t\t     -value => substr($seq, 0, 3));\n\t    } else {\n\t\t$self->warn(\"Seq [$id]: Not using a valid initiator codon!\");\n\t    }\n\t}\n    }\n\n    my $seqclass;\n    if($self->can_call_new()) {\n\t$seqclass = ref($self);\n    } else {\n\t$seqclass = 'Bio::PrimarySeq';\n\t$self->_attempt_to_load_Seq();\n    }\n    my $out = $seqclass->new( '-seq' => $output,\n\t\t\t      '-display_id'  => $self->display_id,\n\t\t\t      '-accession_number' => $self->accession_number,\n\t\t\t      # is there anything wrong with retaining the\n\t\t\t      # description?\n\t\t\t      '-desc' => $self->desc(),\n\t\t\t      '-alphabet' => 'protein'\n\t\t\t    );\n    return $out;\n\n}\n\n=head2 id\n\n Title   : id\n Usage   : $id = $seq->id()\n Function: ID of the sequence. This should normally be (and actually is in\n           the implementation provided here) just a synonym for display_id().\n Example :\n Returns : A string.\n Args    :\n\n\n\nsub  id {\n   my ($self)= @_;\n\n   return $self->display_id();\n}\n\n\n=head2 length\n\n Title   : length\n Usage   : $len = $seq->length()\n Function:\n Example :\n Returns : integer representing the length of the sequence.\n Args    :","parameters":[{"label":"$self"}]},"detail":"($self)","kind":12,"children":[{"localvar":"my","containerName":"length","name":"$self","definition":"my","line":647,"kind":13},{"line":648,"kind":13,"containerName":"length","name":"$self"},{"containerName":"length","name":"throw_not_implemented","kind":12,"line":648}],"line":646,"name":"length","range":{"end":{"line":649,"character":9999},"start":{"line":646,"character":0}}},{"name":"desc","range":{"end":{"line":667,"character":9999},"start":{"character":0,"line":664}},"kind":12,"line":664,"children":[{"containerName":"desc","name":"$self","definition":"my","localvar":"my","kind":13,"line":665},{"name":"$value","containerName":"desc","kind":13,"line":665},{"name":"$self","containerName":"desc","kind":13,"line":666},{"name":"throw_not_implemented","containerName":"desc","line":666,"kind":12}],"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"label":"desc($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: PrimarySeqI.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::PrimarySeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PrimarySeqI [Developers] - Interface definition for a Bio::PrimarySeq\n\n=head1 SYNOPSIS\n\n\n    # Bio::PrimarySeqI is the interface class for sequences.\n\n    # If you are a newcomer to bioperl, you should\n    # start with Bio::Seq documentation. This\n    # documentation is mainly for developers using\n    # Bioperl.\n\n    # to test this is a seq object\n\n    $obj->isa(\"Bio::PrimarySeqI\") ||\n      $obj->throw(\"$obj does not implement the Bio::PrimarySeqI interface\");\n\n    # accessors\n\n    $string    = $obj->seq();\n    $substring = $obj->subseq(12,50);\n    $display   = $obj->display_id(); # for human display\n    $id        = $obj->primary_id(); # unique id for this object,\n                                     # implementation defined\n    $unique_key= $obj->accession_number();\n                       # unique biological id\n\n    # object manipulation\n\n    eval {\n\t$rev    = $obj->revcom();\n    };\n    if( $@ ) {\n\t$obj->throw(-class => 'Bio::Root::Exception',\n                    -text => \"Could not reverse complement. \".\n\t\t             \"Probably not DNA. Actual exception\\n$@\\n\",\n                    -value => $@);\n    }\n\n    $trunc = $obj->trunc(12,50);\n\n    # $rev and $trunc are Bio::PrimarySeqI compliant objects\n\n\n=head1 DESCRIPTION\n\nThis object defines an abstract interface to basic sequence\ninformation - for most users of the package the documentation (and\nmethods) in this class are not useful - this is a developers only\nclass which defines what methods have to be implmented by other Perl\nobjects to comply to the Bio::PrimarySeqI interface. Go \"perldoc\nBio::Seq\" or \"man Bio::Seq\" for more information on the main class for\nsequences.\n\n\nPrimarySeq is an object just for the sequence and its name(s), nothing\nmore. Seq is the larger object complete with features. There is a pure\nperl implementation of this in Bio::PrimarySeq. If you just want to\nuse Bio::PrimarySeq objects, then please read that module first. This\nmodule defines the interface, and is of more interest to people who\nwant to wrap their own Perl Objects/RDBs/FileSystems etc in way that\nthey \"are\" bioperl sequence objects, even though it is not using Perl\nto store the sequence etc.\n\n\nThis interface defines what bioperl consideres necessary to \"be\" a\nsequence, without providing an implementation of this. (An\nimplementation is provided in Bio::PrimarySeq). If you want to provide\na Bio::PrimarySeq 'compliant' object which in fact wraps another\nobject/database/out-of-perl experience, then this is the correct thing\nto wrap, generally by providing a wrapper class which would inheriet\nfrom your object and this Bio::PrimarySeqI interface. The wrapper class\nthen would have methods lists in the \"Implementation Specific\nFunctions\" which would provide these methods for your object.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n \nPlease direct usage questions or support issues to the mailing list:\n  \nL<bioperl-l@bioperl.org>\n  \nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@sanger.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PrimarySeqI;\nuse strict;\nuse Bio::Tools::CodonTable;\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Implementation Specific Functions\n\nThese functions are the ones that a specific implementation must\ndefine.\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard),\n           but implementations are suggested to keep an open mind about\n           case (some users... want mixed case!)\n Returns : A scalar\n Status  : Virtual\n\n\nsub seq {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n Function: returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n\n           Start cannot be larger than end but can be equal\n\n Returns : a string\n Args    :\n Status  : Virtual\n\n\nsub subseq{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, aka the common name of the Sequence object.\n\n           The semantics of this is that it is the most likely string\n           to be used as an identifier of the sequence, and likely to\n           have \"human\" readability.  The id is equivalent to the ID\n           field of the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id\n           to embed other information. Bioperl does not use any\n           embedded information in the ID field, and people are\n           encouraged to use other mechanisms (accession field for\n           example, or extending the sequence object) to solve this.\n\n           Notice that $seq->id() maps to this function, mainly for\n           legacy/convience issues\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub display_id {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 accession_number\n\n Title   : accession_number\n Usage   : $unique_biological_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number. For sequences from established\n           databases, the implementors should try to use the correct\n           accession number. Notice that primary_id() provides the\n           unique id for the implemetation, allowing multiple objects\n           to have the same accession number in a particular implementation.\n\n           For sequences with no accession number, this method should return\n           \"unknown\".\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub accession_number {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_implementation_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their\n           own object ids in a way the implementaiton can control\n           clients can expect one id to map to one object.\n\n           For sequences with no accession number, this method should\n           return a stringified memory location.\n\n           [Note this method name is likely to change in 1.3]\n\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub primary_id {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 can_call_new\n\n Title   : can_call_new\n Usage   : if( $obj->can_call_new ) {\n             $newobj = $obj->new( %param );\n\t }\n Function: can_call_new returns 1 or 0 depending\n           on whether an implementation allows new\n           constructor to be called. If a new constructor\n           is allowed, then it should take the followed hashed\n           constructor list.\n\n           $myobject->new( -seq => $sequence_as_string,\n\t\t\t   -display_id  => $id\n\t\t\t   -accession_number => $accession\n\t\t\t   -alphabet => 'dna',\n\t\t\t   );\n Example :\n Returns : 1 or 0\n Args    :\n\n\n\nsub can_call_new{\n   my ($self,@args) = @_;\n\n   # we default to 0 here\n\n   return 0;\n}\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Returns the type of sequence being one of\n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n           This is not called <type> because this would cause\n           upgrade problems from the 0.5 and earlier Seq objects.\n\n Returns : a string either 'dna','rna','protein'. NB - the object must\n           make a call of the type - if there is no type specified it\n           has to guess.\n Args    : none\n Status  : Virtual\n\n\n\nsub alphabet{\n    my ( $self ) = @_;\n    $self->throw_not_implemented();\n}\n\nsub moltype{\n   my ($self,@args) = @_;\n\n   $self->warn(\"moltype: pre v1.0 method. Calling alphabet() instead...\");\n   $self->alphabet(@args);\n}\n\n\n=head1 Optional Implementation Functions\n\nThe following functions rely on the above functions. An\nimplementing class does not need to provide these functions, as they\nwill be provided by this class, but is free to override these\nfunctions.\n\nAll of revcom(), trunc(), and translate() create new sequence\nobjects. They will call new() on the class of the sequence object\ninstance passed as argument, unless can_call_new() returns FALSE. In\nthe latter case a Bio::PrimarySeq object will be created. Implementors\nwhich really want to control how objects are created (eg, for object\npersistence over a database, or objects in a CORBA framework), they\nare encouraged to override these methods\n\n=head2 revcom\n\n Title   : revcom\n Usage   : $rev = $seq->revcom()\n Function: Produces a new Bio::PrimarySeqI implementing object which\n           is the reversed complement of the sequence. For protein\n           sequences this throws an exception of \"Sequence is a\n           protein. Cannot revcom\"\n\n           The id is the same id as the original sequence, and the\n           accession number is also indentical. If someone wants to\n           track that this sequence has be reversed, it needs to\n           define its own extensions\n\n           To do an inplace edit of an object you can go:\n\n           $seq = $seq->revcom();\n\n           This of course, causes Perl to handle the garbage\n           collection of the old object, but it is roughly speaking as\n           efficient as an inplace edit.\n\n Returns : A new (fresh) Bio::PrimarySeqI object\n Args    : none\n\n\n\nsub revcom{\n   my ($self) = @_;\n\n\n   # check the type is good first.\n   my $t = $self->alphabet;\n\n   if( $t eq 'protein' ) {\n       $self->throw(-class => 'Bio::Root::Exception',\n\t\t    -text  => \"Sequence is a protein. Cannot revcom\");\n   }\n\n   if( $t ne 'dna' && $t ne 'rna' ) {\n       if( $self->can('warn') ) {\n\t   $self->warn(\"Sequence is not dna or rna, but [$t]. \".\n\t\t       \"Attempting to revcom, but unsure if this is right\");\n       } else {\n\t   warn(\"[$self] Sequence is not dna or rna, but [$t]. \".\n\t\t\"Attempting to revcom, but unsure if this is right\");\n       }\n   }\n\n   # yank out the sequence string\n\n   my $str = $self->seq();\n\n   # if is RNA - map to DNA then map back\n\n   if( $t eq 'rna' ) {\n       $str =~ tr/uU/tT/;\n   }\n\n   # revcom etc...\n\n   $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n   my $revseq = CORE::reverse $str;\n\n   if( $t eq 'rna' ) {\n       $revseq =~ tr/tT/uU/;\n   }\n\n   my $seqclass;\n   if($self->can_call_new()) {\n       $seqclass = ref($self);\n   } else {\n       $seqclass = 'Bio::PrimarySeq';\n       $self->_attempt_to_load_Seq();\n   }\n   my $out = $seqclass->new( '-seq' => $revseq,\n\t\t\t     '-display_id'  => $self->display_id,\n\t\t\t     '-accession_number' => $self->accession_number,\n\t\t\t     '-alphabet' => $self->alphabet,\n\t\t\t     '-desc' => $self->desc()\n\t\t\t     );\n   return $out;\n\n}\n\n=head2 trunc\n\n Title   : trunc\n Usage   : $subseq = $myseq->trunc(10,100);\n Function: Provides a truncation of a sequence,\n\n Example :\n Returns : a fresh Bio::PrimarySeqI implementing object\n Args    : Two integers denoting first and last base of the sub-sequence.\n\n\n\nsub trunc{\n   my ($self,$start,$end) = @_;\n\n   my $str;\n   if( defined $start && ref($start) &&\n       $start->isa('Bio::LocationI') ) {\n       $str = $self->subseq($start); # start is a location actually\n   } elsif( !$end ) {\n       $self->throw(\"trunc start,end -- there was no end for $start\");\n   } elsif( $end < $start ) {\n       my $msg = \"start [$start] is greater than end [$end]. \\n\".\n\t   \"If you want to truncated and reverse complement, \\n\".\n\t       \"you must call trunc followed by revcom. Sorry.\";\n       $self->throw($msg);\n   } else {\n       $str = $self->subseq($start,$end);\n   }\n\n   my $seqclass;\n   if($self->can_call_new()) {\n       $seqclass = ref($self);\n   } else {\n       $seqclass = 'Bio::PrimarySeq';\n       $self->_attempt_to_load_Seq();\n   }\n\n   my $out = $seqclass->new( '-seq' => $str,\n\t\t\t     '-display_id'  => $self->display_id,\n\t\t\t     '-accession_number' => $self->accession_number,\n\t\t\t     '-alphabet' => $self->alphabet,\n\t\t\t     '-desc' => $self->desc()\n\t\t\t     );\n   return $out;\n}\n\n\n=head2 translate\n\n Title   : translate\n Usage   : $protein_seq_obj = $dna_seq_obj->translate\n\n Function:\n\n           Provides the translation of the DNA sequence using full\n           IUPAC ambiguities in DNA/RNA and amino acid codes.\n\n           The full CDS translation is identical to EMBL/TREMBL\n           database translation. Note that the trailing terminator\n           character is removed before returning the translation\n           object.\n\n           Note: if you set $dna_seq_obj->verbose(1) you will get a\n           warning if the first codon is not a valid initiator.\n\n\n Returns : A Bio::PrimarySeqI implementing object\n Args    : character for terminator (optional) defaults to '*'\n           character for unknown amino acid (optional) defaults to 'X'\n           frame (optional) valid values 0, 1, 2, defaults to 0\n           codon table id (optional) defaults to 1\n           complete coding sequence expected, defaults to 0 (false)\n           boolean, throw exception if not complete CDS (true) or defaults to warning (false)\n\n\nsub translate {\n    my($self) = shift;\n    my($stop, $unknown, $frame, $tableid, $fullCDS, $throw) = @_;\n    my($i, $len, $output) = (0,0,'');\n    my($codon)   = \"\";\n    my $aa;\n\n    ## User can pass in symbol for stop and unknown codons\n    unless(defined($stop) and $stop ne '')    { $stop = \"*\"; }\n    unless(defined($unknown) and $unknown ne '') { $unknown = \"X\"; }\n    unless(defined($frame) and $frame ne '') { $frame = 0; }\n\n    ## the codon table ID\n    unless(defined($tableid) and $tableid ne '')    { $tableid = 1; }\n\n    ##Error if monomer is \"Amino\"\n    if ($self->alphabet eq 'protein') {\n\t$self->throw(-class => 'Bio::Root::Exception',\n\t\t     -text => \"Can't translate an amino acid sequence.\")\n    }\n\n    ##Error if frame is not 0, 1 or 2\n    unless ($frame == 0 or $frame == 1 or $frame == 2) {\n\t$self->throw(-class => 'Bio::Root::BadParameter',\n\t\t     -text   => \"Valid values for frame are 0, 1, 2, not [$frame].\",\n\t\t     -value => $frame);\n    }\n\n    #warns if ID is invalid\n    my $codonTable = Bio::Tools::CodonTable->new( -id => $tableid);\n\n    my ($seq) = $self->seq();\n\n    # deal with frame offset.\n    if( $frame ) {\n\t$seq = substr ($seq,$frame);\n    }\n\n    # Translate it\n    $output = $codonTable->translate($seq);\n    # Use user-input stop/unknown\n    $output =~ s/\\*/$stop/g;\n    $output =~ s/X/$unknown/g;\n\t\n    # only if we are expecting to translate a complete coding region\n    if ($fullCDS) {\n\tmy $id = $self->display_id;\n\t#remove the stop character\n\tif( substr($output,-1,1) eq $stop ) {\n\t    chop $output;\n\t} else {\n\t    $throw && $self->throw(-class => 'Bio::Root::Exception',\n\t\t\t\t   -text  => \"Seq [$id]: Not using a valid terminator codon!: \". substr($output,-1,1),\n\t\t\t\t   -value => substr($output,-1,1));\n\t    $self->warn(\"Seq [$id]: Not using a valid terminator codon!: \". substr($output,-1,1));\n\t}\n\t# test if there are terminator characters inside the protein sequence!\n\tif ($output =~ /\\*/) {\n\t    $throw && $self->throw(-class => 'Bio::Root::Exception',\n\t\t\t\t   -text  => \"Seq [$id]: Terminator codon inside CDS!\");\n\t    $self->warn(\"Seq [$id]: Terminator codon inside CDS!\");\n\t}\n\t# if the initiator codon is not ATG, the amino acid needs to changed into M\n\tif ( substr($output,0,1) ne 'M' ) {\n\t    if ($codonTable->is_start_codon(substr($seq, 0, 3)) ) {\n\t\t$output = 'M'. substr($output,1);\n\t    }\n\t    elsif ($throw) {\n\t\t$self->throw(-class => 'Bio::Root::Exception',\n\t\t\t     -text => \"Seq [$id]: Not using a valid initiator codon!: \". substr($seq, 0, 3),\n\t\t\t     -value => substr($seq, 0, 3));\n\t    } else {\n\t\t$self->warn(\"Seq [$id]: Not using a valid initiator codon!\");\n\t    }\n\t}\n    }\n\n    my $seqclass;\n    if($self->can_call_new()) {\n\t$seqclass = ref($self);\n    } else {\n\t$seqclass = 'Bio::PrimarySeq';\n\t$self->_attempt_to_load_Seq();\n    }\n    my $out = $seqclass->new( '-seq' => $output,\n\t\t\t      '-display_id'  => $self->display_id,\n\t\t\t      '-accession_number' => $self->accession_number,\n\t\t\t      # is there anything wrong with retaining the\n\t\t\t      # description?\n\t\t\t      '-desc' => $self->desc(),\n\t\t\t      '-alphabet' => 'protein'\n\t\t\t    );\n    return $out;\n\n}\n\n=head2 id\n\n Title   : id\n Usage   : $id = $seq->id()\n Function: ID of the sequence. This should normally be (and actually is in\n           the implementation provided here) just a synonym for display_id().\n Example :\n Returns : A string.\n Args    :\n\n\n\nsub  id {\n   my ($self)= @_;\n\n   return $self->display_id();\n}\n\n\n=head2 length\n\n Title   : length\n Usage   : $len = $seq->length()\n Function:\n Example :\n Returns : integer representing the length of the sequence.\n Args    :\n\n\n\nsub  length {\n   my ($self)= @_;\n   $self->throw_not_implemented();\n}\n\n=head2 desc\n\n Title   : desc\n Usage   : $seq->desc($newval);\n           $description = $seq->desc();\n Function: Get/set description text for a seq object\n Example :\n Returns : value of desc\n Args    : newvalue (optional)"}},{"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: PrimarySeqI.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::PrimarySeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PrimarySeqI [Developers] - Interface definition for a Bio::PrimarySeq\n\n=head1 SYNOPSIS\n\n\n    # Bio::PrimarySeqI is the interface class for sequences.\n\n    # If you are a newcomer to bioperl, you should\n    # start with Bio::Seq documentation. This\n    # documentation is mainly for developers using\n    # Bioperl.\n\n    # to test this is a seq object\n\n    $obj->isa(\"Bio::PrimarySeqI\") ||\n      $obj->throw(\"$obj does not implement the Bio::PrimarySeqI interface\");\n\n    # accessors\n\n    $string    = $obj->seq();\n    $substring = $obj->subseq(12,50);\n    $display   = $obj->display_id(); # for human display\n    $id        = $obj->primary_id(); # unique id for this object,\n                                     # implementation defined\n    $unique_key= $obj->accession_number();\n                       # unique biological id\n\n    # object manipulation\n\n    eval {\n\t$rev    = $obj->revcom();\n    };\n    if( $@ ) {\n\t$obj->throw(-class => 'Bio::Root::Exception',\n                    -text => \"Could not reverse complement. \".\n\t\t             \"Probably not DNA. Actual exception\\n$@\\n\",\n                    -value => $@);\n    }\n\n    $trunc = $obj->trunc(12,50);\n\n    # $rev and $trunc are Bio::PrimarySeqI compliant objects\n\n\n=head1 DESCRIPTION\n\nThis object defines an abstract interface to basic sequence\ninformation - for most users of the package the documentation (and\nmethods) in this class are not useful - this is a developers only\nclass which defines what methods have to be implmented by other Perl\nobjects to comply to the Bio::PrimarySeqI interface. Go \"perldoc\nBio::Seq\" or \"man Bio::Seq\" for more information on the main class for\nsequences.\n\n\nPrimarySeq is an object just for the sequence and its name(s), nothing\nmore. Seq is the larger object complete with features. There is a pure\nperl implementation of this in Bio::PrimarySeq. If you just want to\nuse Bio::PrimarySeq objects, then please read that module first. This\nmodule defines the interface, and is of more interest to people who\nwant to wrap their own Perl Objects/RDBs/FileSystems etc in way that\nthey \"are\" bioperl sequence objects, even though it is not using Perl\nto store the sequence etc.\n\n\nThis interface defines what bioperl consideres necessary to \"be\" a\nsequence, without providing an implementation of this. (An\nimplementation is provided in Bio::PrimarySeq). If you want to provide\na Bio::PrimarySeq 'compliant' object which in fact wraps another\nobject/database/out-of-perl experience, then this is the correct thing\nto wrap, generally by providing a wrapper class which would inheriet\nfrom your object and this Bio::PrimarySeqI interface. The wrapper class\nthen would have methods lists in the \"Implementation Specific\nFunctions\" which would provide these methods for your object.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n \nPlease direct usage questions or support issues to the mailing list:\n  \nL<bioperl-l@bioperl.org>\n  \nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@sanger.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PrimarySeqI;\nuse strict;\nuse Bio::Tools::CodonTable;\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Implementation Specific Functions\n\nThese functions are the ones that a specific implementation must\ndefine.\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard),\n           but implementations are suggested to keep an open mind about\n           case (some users... want mixed case!)\n Returns : A scalar\n Status  : Virtual\n\n\nsub seq {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n Function: returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n\n           Start cannot be larger than end but can be equal\n\n Returns : a string\n Args    :\n Status  : Virtual\n\n\nsub subseq{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, aka the common name of the Sequence object.\n\n           The semantics of this is that it is the most likely string\n           to be used as an identifier of the sequence, and likely to\n           have \"human\" readability.  The id is equivalent to the ID\n           field of the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id\n           to embed other information. Bioperl does not use any\n           embedded information in the ID field, and people are\n           encouraged to use other mechanisms (accession field for\n           example, or extending the sequence object) to solve this.\n\n           Notice that $seq->id() maps to this function, mainly for\n           legacy/convience issues\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub display_id {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 accession_number\n\n Title   : accession_number\n Usage   : $unique_biological_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number. For sequences from established\n           databases, the implementors should try to use the correct\n           accession number. Notice that primary_id() provides the\n           unique id for the implemetation, allowing multiple objects\n           to have the same accession number in a particular implementation.\n\n           For sequences with no accession number, this method should return\n           \"unknown\".\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub accession_number {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_implementation_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their\n           own object ids in a way the implementaiton can control\n           clients can expect one id to map to one object.\n\n           For sequences with no accession number, this method should\n           return a stringified memory location.\n\n           [Note this method name is likely to change in 1.3]\n\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub primary_id {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 can_call_new\n\n Title   : can_call_new\n Usage   : if( $obj->can_call_new ) {\n             $newobj = $obj->new( %param );\n\t }\n Function: can_call_new returns 1 or 0 depending\n           on whether an implementation allows new\n           constructor to be called. If a new constructor\n           is allowed, then it should take the followed hashed\n           constructor list.\n\n           $myobject->new( -seq => $sequence_as_string,\n\t\t\t   -display_id  => $id\n\t\t\t   -accession_number => $accession\n\t\t\t   -alphabet => 'dna',\n\t\t\t   );\n Example :\n Returns : 1 or 0\n Args    :\n\n\n\nsub can_call_new{\n   my ($self,@args) = @_;\n\n   # we default to 0 here\n\n   return 0;\n}\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Returns the type of sequence being one of\n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n           This is not called <type> because this would cause\n           upgrade problems from the 0.5 and earlier Seq objects.\n\n Returns : a string either 'dna','rna','protein'. NB - the object must\n           make a call of the type - if there is no type specified it\n           has to guess.\n Args    : none\n Status  : Virtual\n\n\n\nsub alphabet{\n    my ( $self ) = @_;\n    $self->throw_not_implemented();\n}\n\nsub moltype{\n   my ($self,@args) = @_;\n\n   $self->warn(\"moltype: pre v1.0 method. Calling alphabet() instead...\");\n   $self->alphabet(@args);\n}\n\n\n=head1 Optional Implementation Functions\n\nThe following functions rely on the above functions. An\nimplementing class does not need to provide these functions, as they\nwill be provided by this class, but is free to override these\nfunctions.\n\nAll of revcom(), trunc(), and translate() create new sequence\nobjects. They will call new() on the class of the sequence object\ninstance passed as argument, unless can_call_new() returns FALSE. In\nthe latter case a Bio::PrimarySeq object will be created. Implementors\nwhich really want to control how objects are created (eg, for object\npersistence over a database, or objects in a CORBA framework), they\nare encouraged to override these methods\n\n=head2 revcom\n\n Title   : revcom\n Usage   : $rev = $seq->revcom()\n Function: Produces a new Bio::PrimarySeqI implementing object which\n           is the reversed complement of the sequence. For protein\n           sequences this throws an exception of \"Sequence is a\n           protein. Cannot revcom\"\n\n           The id is the same id as the original sequence, and the\n           accession number is also indentical. If someone wants to\n           track that this sequence has be reversed, it needs to\n           define its own extensions\n\n           To do an inplace edit of an object you can go:\n\n           $seq = $seq->revcom();\n\n           This of course, causes Perl to handle the garbage\n           collection of the old object, but it is roughly speaking as\n           efficient as an inplace edit.\n\n Returns : A new (fresh) Bio::PrimarySeqI object\n Args    : none\n\n\n\nsub revcom{\n   my ($self) = @_;\n\n\n   # check the type is good first.\n   my $t = $self->alphabet;\n\n   if( $t eq 'protein' ) {\n       $self->throw(-class => 'Bio::Root::Exception',\n\t\t    -text  => \"Sequence is a protein. Cannot revcom\");\n   }\n\n   if( $t ne 'dna' && $t ne 'rna' ) {\n       if( $self->can('warn') ) {\n\t   $self->warn(\"Sequence is not dna or rna, but [$t]. \".\n\t\t       \"Attempting to revcom, but unsure if this is right\");\n       } else {\n\t   warn(\"[$self] Sequence is not dna or rna, but [$t]. \".\n\t\t\"Attempting to revcom, but unsure if this is right\");\n       }\n   }\n\n   # yank out the sequence string\n\n   my $str = $self->seq();\n\n   # if is RNA - map to DNA then map back\n\n   if( $t eq 'rna' ) {\n       $str =~ tr/uU/tT/;\n   }\n\n   # revcom etc...\n\n   $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n   my $revseq = CORE::reverse $str;\n\n   if( $t eq 'rna' ) {\n       $revseq =~ tr/tT/uU/;\n   }\n\n   my $seqclass;\n   if($self->can_call_new()) {\n       $seqclass = ref($self);\n   } else {\n       $seqclass = 'Bio::PrimarySeq';\n       $self->_attempt_to_load_Seq();\n   }\n   my $out = $seqclass->new( '-seq' => $revseq,\n\t\t\t     '-display_id'  => $self->display_id,\n\t\t\t     '-accession_number' => $self->accession_number,\n\t\t\t     '-alphabet' => $self->alphabet,\n\t\t\t     '-desc' => $self->desc()\n\t\t\t     );\n   return $out;\n\n}\n\n=head2 trunc\n\n Title   : trunc\n Usage   : $subseq = $myseq->trunc(10,100);\n Function: Provides a truncation of a sequence,\n\n Example :\n Returns : a fresh Bio::PrimarySeqI implementing object\n Args    : Two integers denoting first and last base of the sub-sequence.\n\n\n\nsub trunc{\n   my ($self,$start,$end) = @_;\n\n   my $str;\n   if( defined $start && ref($start) &&\n       $start->isa('Bio::LocationI') ) {\n       $str = $self->subseq($start); # start is a location actually\n   } elsif( !$end ) {\n       $self->throw(\"trunc start,end -- there was no end for $start\");\n   } elsif( $end < $start ) {\n       my $msg = \"start [$start] is greater than end [$end]. \\n\".\n\t   \"If you want to truncated and reverse complement, \\n\".\n\t       \"you must call trunc followed by revcom. Sorry.\";\n       $self->throw($msg);\n   } else {\n       $str = $self->subseq($start,$end);\n   }\n\n   my $seqclass;\n   if($self->can_call_new()) {\n       $seqclass = ref($self);\n   } else {\n       $seqclass = 'Bio::PrimarySeq';\n       $self->_attempt_to_load_Seq();\n   }\n\n   my $out = $seqclass->new( '-seq' => $str,\n\t\t\t     '-display_id'  => $self->display_id,\n\t\t\t     '-accession_number' => $self->accession_number,\n\t\t\t     '-alphabet' => $self->alphabet,\n\t\t\t     '-desc' => $self->desc()\n\t\t\t     );\n   return $out;\n}\n\n\n=head2 translate\n\n Title   : translate\n Usage   : $protein_seq_obj = $dna_seq_obj->translate\n\n Function:\n\n           Provides the translation of the DNA sequence using full\n           IUPAC ambiguities in DNA/RNA and amino acid codes.\n\n           The full CDS translation is identical to EMBL/TREMBL\n           database translation. Note that the trailing terminator\n           character is removed before returning the translation\n           object.\n\n           Note: if you set $dna_seq_obj->verbose(1) you will get a\n           warning if the first codon is not a valid initiator.\n\n\n Returns : A Bio::PrimarySeqI implementing object\n Args    : character for terminator (optional) defaults to '*'\n           character for unknown amino acid (optional) defaults to 'X'\n           frame (optional) valid values 0, 1, 2, defaults to 0\n           codon table id (optional) defaults to 1\n           complete coding sequence expected, defaults to 0 (false)\n           boolean, throw exception if not complete CDS (true) or defaults to warning (false)\n\n\nsub translate {\n    my($self) = shift;\n    my($stop, $unknown, $frame, $tableid, $fullCDS, $throw) = @_;\n    my($i, $len, $output) = (0,0,'');\n    my($codon)   = \"\";\n    my $aa;\n\n    ## User can pass in symbol for stop and unknown codons\n    unless(defined($stop) and $stop ne '')    { $stop = \"*\"; }\n    unless(defined($unknown) and $unknown ne '') { $unknown = \"X\"; }\n    unless(defined($frame) and $frame ne '') { $frame = 0; }\n\n    ## the codon table ID\n    unless(defined($tableid) and $tableid ne '')    { $tableid = 1; }\n\n    ##Error if monomer is \"Amino\"\n    if ($self->alphabet eq 'protein') {\n\t$self->throw(-class => 'Bio::Root::Exception',\n\t\t     -text => \"Can't translate an amino acid sequence.\")\n    }\n\n    ##Error if frame is not 0, 1 or 2\n    unless ($frame == 0 or $frame == 1 or $frame == 2) {\n\t$self->throw(-class => 'Bio::Root::BadParameter',\n\t\t     -text   => \"Valid values for frame are 0, 1, 2, not [$frame].\",\n\t\t     -value => $frame);\n    }\n\n    #warns if ID is invalid\n    my $codonTable = Bio::Tools::CodonTable->new( -id => $tableid);\n\n    my ($seq) = $self->seq();\n\n    # deal with frame offset.\n    if( $frame ) {\n\t$seq = substr ($seq,$frame);\n    }\n\n    # Translate it\n    $output = $codonTable->translate($seq);\n    # Use user-input stop/unknown\n    $output =~ s/\\*/$stop/g;\n    $output =~ s/X/$unknown/g;\n\t\n    # only if we are expecting to translate a complete coding region\n    if ($fullCDS) {\n\tmy $id = $self->display_id;\n\t#remove the stop character\n\tif( substr($output,-1,1) eq $stop ) {\n\t    chop $output;\n\t} else {\n\t    $throw && $self->throw(-class => 'Bio::Root::Exception',\n\t\t\t\t   -text  => \"Seq [$id]: Not using a valid terminator codon!: \". substr($output,-1,1),\n\t\t\t\t   -value => substr($output,-1,1));\n\t    $self->warn(\"Seq [$id]: Not using a valid terminator codon!: \". substr($output,-1,1));\n\t}\n\t# test if there are terminator characters inside the protein sequence!\n\tif ($output =~ /\\*/) {\n\t    $throw && $self->throw(-class => 'Bio::Root::Exception',\n\t\t\t\t   -text  => \"Seq [$id]: Terminator codon inside CDS!\");\n\t    $self->warn(\"Seq [$id]: Terminator codon inside CDS!\");\n\t}\n\t# if the initiator codon is not ATG, the amino acid needs to changed into M\n\tif ( substr($output,0,1) ne 'M' ) {\n\t    if ($codonTable->is_start_codon(substr($seq, 0, 3)) ) {\n\t\t$output = 'M'. substr($output,1);\n\t    }\n\t    elsif ($throw) {\n\t\t$self->throw(-class => 'Bio::Root::Exception',\n\t\t\t     -text => \"Seq [$id]: Not using a valid initiator codon!: \". substr($seq, 0, 3),\n\t\t\t     -value => substr($seq, 0, 3));\n\t    } else {\n\t\t$self->warn(\"Seq [$id]: Not using a valid initiator codon!\");\n\t    }\n\t}\n    }\n\n    my $seqclass;\n    if($self->can_call_new()) {\n\t$seqclass = ref($self);\n    } else {\n\t$seqclass = 'Bio::PrimarySeq';\n\t$self->_attempt_to_load_Seq();\n    }\n    my $out = $seqclass->new( '-seq' => $output,\n\t\t\t      '-display_id'  => $self->display_id,\n\t\t\t      '-accession_number' => $self->accession_number,\n\t\t\t      # is there anything wrong with retaining the\n\t\t\t      # description?\n\t\t\t      '-desc' => $self->desc(),\n\t\t\t      '-alphabet' => 'protein'\n\t\t\t    );\n    return $out;\n\n}\n\n=head2 id\n\n Title   : id\n Usage   : $id = $seq->id()\n Function: ID of the sequence. This should normally be (and actually is in\n           the implementation provided here) just a synonym for display_id().\n Example :\n Returns : A string.\n Args    :\n\n\n\nsub  id {\n   my ($self)= @_;\n\n   return $self->display_id();\n}\n\n\n=head2 length\n\n Title   : length\n Usage   : $len = $seq->length()\n Function:\n Example :\n Returns : integer representing the length of the sequence.\n Args    :\n\n\n\nsub  length {\n   my ($self)= @_;\n   $self->throw_not_implemented();\n}\n\n=head2 desc\n\n Title   : desc\n Usage   : $seq->desc($newval);\n           $description = $seq->desc();\n Function: Get/set description text for a seq object\n Example :\n Returns : value of desc\n Args    : newvalue (optional)\n\n\n\nsub desc {\n   my ($self,$value) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 is_circular\n\n Title   : is_circular\n Usage   : if( $obj->is_circular) { /Do Something/ }\n Function: Returns true if the molecule is circular\n Returns : Boolean value\n Args    : none","label":"is_circular($self,$value)"},"kind":12,"line":680,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"is_circular","line":681,"kind":13},{"line":681,"kind":13,"containerName":"is_circular","name":"$value"},{"name":"$value","containerName":"is_circular","kind":13,"line":682},{"containerName":"is_circular","name":"$self","line":683,"kind":13},{"containerName":"is_circular","name":"$value","line":683,"kind":13},{"kind":13,"line":685,"name":"$self","containerName":"is_circular"}],"name":"is_circular","range":{"end":{"character":9999,"line":686},"start":{"line":680,"character":0}}},{"kind":12,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"_attempt_to_load_Seq","line":706,"kind":13},{"containerName":"_attempt_to_load_Seq","name":"$main","kind":13,"line":708},{"line":715,"kind":13,"localvar":"my","name":"$text","definition":"my","containerName":"_attempt_to_load_Seq"},{"kind":13,"line":721,"name":"$self","containerName":"_attempt_to_load_Seq"},{"name":"throw","containerName":"_attempt_to_load_Seq","line":721,"kind":12}],"line":705,"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: PrimarySeqI.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::PrimarySeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PrimarySeqI [Developers] - Interface definition for a Bio::PrimarySeq\n\n=head1 SYNOPSIS\n\n\n    # Bio::PrimarySeqI is the interface class for sequences.\n\n    # If you are a newcomer to bioperl, you should\n    # start with Bio::Seq documentation. This\n    # documentation is mainly for developers using\n    # Bioperl.\n\n    # to test this is a seq object\n\n    $obj->isa(\"Bio::PrimarySeqI\") ||\n      $obj->throw(\"$obj does not implement the Bio::PrimarySeqI interface\");\n\n    # accessors\n\n    $string    = $obj->seq();\n    $substring = $obj->subseq(12,50);\n    $display   = $obj->display_id(); # for human display\n    $id        = $obj->primary_id(); # unique id for this object,\n                                     # implementation defined\n    $unique_key= $obj->accession_number();\n                       # unique biological id\n\n    # object manipulation\n\n    eval {\n\t$rev    = $obj->revcom();\n    };\n    if( $@ ) {\n\t$obj->throw(-class => 'Bio::Root::Exception',\n                    -text => \"Could not reverse complement. \".\n\t\t             \"Probably not DNA. Actual exception\\n$@\\n\",\n                    -value => $@);\n    }\n\n    $trunc = $obj->trunc(12,50);\n\n    # $rev and $trunc are Bio::PrimarySeqI compliant objects\n\n\n=head1 DESCRIPTION\n\nThis object defines an abstract interface to basic sequence\ninformation - for most users of the package the documentation (and\nmethods) in this class are not useful - this is a developers only\nclass which defines what methods have to be implmented by other Perl\nobjects to comply to the Bio::PrimarySeqI interface. Go \"perldoc\nBio::Seq\" or \"man Bio::Seq\" for more information on the main class for\nsequences.\n\n\nPrimarySeq is an object just for the sequence and its name(s), nothing\nmore. Seq is the larger object complete with features. There is a pure\nperl implementation of this in Bio::PrimarySeq. If you just want to\nuse Bio::PrimarySeq objects, then please read that module first. This\nmodule defines the interface, and is of more interest to people who\nwant to wrap their own Perl Objects/RDBs/FileSystems etc in way that\nthey \"are\" bioperl sequence objects, even though it is not using Perl\nto store the sequence etc.\n\n\nThis interface defines what bioperl consideres necessary to \"be\" a\nsequence, without providing an implementation of this. (An\nimplementation is provided in Bio::PrimarySeq). If you want to provide\na Bio::PrimarySeq 'compliant' object which in fact wraps another\nobject/database/out-of-perl experience, then this is the correct thing\nto wrap, generally by providing a wrapper class which would inheriet\nfrom your object and this Bio::PrimarySeqI interface. The wrapper class\nthen would have methods lists in the \"Implementation Specific\nFunctions\" which would provide these methods for your object.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n \nPlease direct usage questions or support issues to the mailing list:\n  \nL<bioperl-l@bioperl.org>\n  \nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@sanger.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PrimarySeqI;\nuse strict;\nuse Bio::Tools::CodonTable;\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Implementation Specific Functions\n\nThese functions are the ones that a specific implementation must\ndefine.\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard),\n           but implementations are suggested to keep an open mind about\n           case (some users... want mixed case!)\n Returns : A scalar\n Status  : Virtual\n\n\nsub seq {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n Function: returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n\n           Start cannot be larger than end but can be equal\n\n Returns : a string\n Args    :\n Status  : Virtual\n\n\nsub subseq{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, aka the common name of the Sequence object.\n\n           The semantics of this is that it is the most likely string\n           to be used as an identifier of the sequence, and likely to\n           have \"human\" readability.  The id is equivalent to the ID\n           field of the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id\n           to embed other information. Bioperl does not use any\n           embedded information in the ID field, and people are\n           encouraged to use other mechanisms (accession field for\n           example, or extending the sequence object) to solve this.\n\n           Notice that $seq->id() maps to this function, mainly for\n           legacy/convience issues\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub display_id {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 accession_number\n\n Title   : accession_number\n Usage   : $unique_biological_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number. For sequences from established\n           databases, the implementors should try to use the correct\n           accession number. Notice that primary_id() provides the\n           unique id for the implemetation, allowing multiple objects\n           to have the same accession number in a particular implementation.\n\n           For sequences with no accession number, this method should return\n           \"unknown\".\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub accession_number {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_implementation_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their\n           own object ids in a way the implementaiton can control\n           clients can expect one id to map to one object.\n\n           For sequences with no accession number, this method should\n           return a stringified memory location.\n\n           [Note this method name is likely to change in 1.3]\n\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub primary_id {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 can_call_new\n\n Title   : can_call_new\n Usage   : if( $obj->can_call_new ) {\n             $newobj = $obj->new( %param );\n\t }\n Function: can_call_new returns 1 or 0 depending\n           on whether an implementation allows new\n           constructor to be called. If a new constructor\n           is allowed, then it should take the followed hashed\n           constructor list.\n\n           $myobject->new( -seq => $sequence_as_string,\n\t\t\t   -display_id  => $id\n\t\t\t   -accession_number => $accession\n\t\t\t   -alphabet => 'dna',\n\t\t\t   );\n Example :\n Returns : 1 or 0\n Args    :\n\n\n\nsub can_call_new{\n   my ($self,@args) = @_;\n\n   # we default to 0 here\n\n   return 0;\n}\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Returns the type of sequence being one of\n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n           This is not called <type> because this would cause\n           upgrade problems from the 0.5 and earlier Seq objects.\n\n Returns : a string either 'dna','rna','protein'. NB - the object must\n           make a call of the type - if there is no type specified it\n           has to guess.\n Args    : none\n Status  : Virtual\n\n\n\nsub alphabet{\n    my ( $self ) = @_;\n    $self->throw_not_implemented();\n}\n\nsub moltype{\n   my ($self,@args) = @_;\n\n   $self->warn(\"moltype: pre v1.0 method. Calling alphabet() instead...\");\n   $self->alphabet(@args);\n}\n\n\n=head1 Optional Implementation Functions\n\nThe following functions rely on the above functions. An\nimplementing class does not need to provide these functions, as they\nwill be provided by this class, but is free to override these\nfunctions.\n\nAll of revcom(), trunc(), and translate() create new sequence\nobjects. They will call new() on the class of the sequence object\ninstance passed as argument, unless can_call_new() returns FALSE. In\nthe latter case a Bio::PrimarySeq object will be created. Implementors\nwhich really want to control how objects are created (eg, for object\npersistence over a database, or objects in a CORBA framework), they\nare encouraged to override these methods\n\n=head2 revcom\n\n Title   : revcom\n Usage   : $rev = $seq->revcom()\n Function: Produces a new Bio::PrimarySeqI implementing object which\n           is the reversed complement of the sequence. For protein\n           sequences this throws an exception of \"Sequence is a\n           protein. Cannot revcom\"\n\n           The id is the same id as the original sequence, and the\n           accession number is also indentical. If someone wants to\n           track that this sequence has be reversed, it needs to\n           define its own extensions\n\n           To do an inplace edit of an object you can go:\n\n           $seq = $seq->revcom();\n\n           This of course, causes Perl to handle the garbage\n           collection of the old object, but it is roughly speaking as\n           efficient as an inplace edit.\n\n Returns : A new (fresh) Bio::PrimarySeqI object\n Args    : none\n\n\n\nsub revcom{\n   my ($self) = @_;\n\n\n   # check the type is good first.\n   my $t = $self->alphabet;\n\n   if( $t eq 'protein' ) {\n       $self->throw(-class => 'Bio::Root::Exception',\n\t\t    -text  => \"Sequence is a protein. Cannot revcom\");\n   }\n\n   if( $t ne 'dna' && $t ne 'rna' ) {\n       if( $self->can('warn') ) {\n\t   $self->warn(\"Sequence is not dna or rna, but [$t]. \".\n\t\t       \"Attempting to revcom, but unsure if this is right\");\n       } else {\n\t   warn(\"[$self] Sequence is not dna or rna, but [$t]. \".\n\t\t\"Attempting to revcom, but unsure if this is right\");\n       }\n   }\n\n   # yank out the sequence string\n\n   my $str = $self->seq();\n\n   # if is RNA - map to DNA then map back\n\n   if( $t eq 'rna' ) {\n       $str =~ tr/uU/tT/;\n   }\n\n   # revcom etc...\n\n   $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n   my $revseq = CORE::reverse $str;\n\n   if( $t eq 'rna' ) {\n       $revseq =~ tr/tT/uU/;\n   }\n\n   my $seqclass;\n   if($self->can_call_new()) {\n       $seqclass = ref($self);\n   } else {\n       $seqclass = 'Bio::PrimarySeq';\n       $self->_attempt_to_load_Seq();\n   }\n   my $out = $seqclass->new( '-seq' => $revseq,\n\t\t\t     '-display_id'  => $self->display_id,\n\t\t\t     '-accession_number' => $self->accession_number,\n\t\t\t     '-alphabet' => $self->alphabet,\n\t\t\t     '-desc' => $self->desc()\n\t\t\t     );\n   return $out;\n\n}\n\n=head2 trunc\n\n Title   : trunc\n Usage   : $subseq = $myseq->trunc(10,100);\n Function: Provides a truncation of a sequence,\n\n Example :\n Returns : a fresh Bio::PrimarySeqI implementing object\n Args    : Two integers denoting first and last base of the sub-sequence.\n\n\n\nsub trunc{\n   my ($self,$start,$end) = @_;\n\n   my $str;\n   if( defined $start && ref($start) &&\n       $start->isa('Bio::LocationI') ) {\n       $str = $self->subseq($start); # start is a location actually\n   } elsif( !$end ) {\n       $self->throw(\"trunc start,end -- there was no end for $start\");\n   } elsif( $end < $start ) {\n       my $msg = \"start [$start] is greater than end [$end]. \\n\".\n\t   \"If you want to truncated and reverse complement, \\n\".\n\t       \"you must call trunc followed by revcom. Sorry.\";\n       $self->throw($msg);\n   } else {\n       $str = $self->subseq($start,$end);\n   }\n\n   my $seqclass;\n   if($self->can_call_new()) {\n       $seqclass = ref($self);\n   } else {\n       $seqclass = 'Bio::PrimarySeq';\n       $self->_attempt_to_load_Seq();\n   }\n\n   my $out = $seqclass->new( '-seq' => $str,\n\t\t\t     '-display_id'  => $self->display_id,\n\t\t\t     '-accession_number' => $self->accession_number,\n\t\t\t     '-alphabet' => $self->alphabet,\n\t\t\t     '-desc' => $self->desc()\n\t\t\t     );\n   return $out;\n}\n\n\n=head2 translate\n\n Title   : translate\n Usage   : $protein_seq_obj = $dna_seq_obj->translate\n\n Function:\n\n           Provides the translation of the DNA sequence using full\n           IUPAC ambiguities in DNA/RNA and amino acid codes.\n\n           The full CDS translation is identical to EMBL/TREMBL\n           database translation. Note that the trailing terminator\n           character is removed before returning the translation\n           object.\n\n           Note: if you set $dna_seq_obj->verbose(1) you will get a\n           warning if the first codon is not a valid initiator.\n\n\n Returns : A Bio::PrimarySeqI implementing object\n Args    : character for terminator (optional) defaults to '*'\n           character for unknown amino acid (optional) defaults to 'X'\n           frame (optional) valid values 0, 1, 2, defaults to 0\n           codon table id (optional) defaults to 1\n           complete coding sequence expected, defaults to 0 (false)\n           boolean, throw exception if not complete CDS (true) or defaults to warning (false)\n\n\nsub translate {\n    my($self) = shift;\n    my($stop, $unknown, $frame, $tableid, $fullCDS, $throw) = @_;\n    my($i, $len, $output) = (0,0,'');\n    my($codon)   = \"\";\n    my $aa;\n\n    ## User can pass in symbol for stop and unknown codons\n    unless(defined($stop) and $stop ne '')    { $stop = \"*\"; }\n    unless(defined($unknown) and $unknown ne '') { $unknown = \"X\"; }\n    unless(defined($frame) and $frame ne '') { $frame = 0; }\n\n    ## the codon table ID\n    unless(defined($tableid) and $tableid ne '')    { $tableid = 1; }\n\n    ##Error if monomer is \"Amino\"\n    if ($self->alphabet eq 'protein') {\n\t$self->throw(-class => 'Bio::Root::Exception',\n\t\t     -text => \"Can't translate an amino acid sequence.\")\n    }\n\n    ##Error if frame is not 0, 1 or 2\n    unless ($frame == 0 or $frame == 1 or $frame == 2) {\n\t$self->throw(-class => 'Bio::Root::BadParameter',\n\t\t     -text   => \"Valid values for frame are 0, 1, 2, not [$frame].\",\n\t\t     -value => $frame);\n    }\n\n    #warns if ID is invalid\n    my $codonTable = Bio::Tools::CodonTable->new( -id => $tableid);\n\n    my ($seq) = $self->seq();\n\n    # deal with frame offset.\n    if( $frame ) {\n\t$seq = substr ($seq,$frame);\n    }\n\n    # Translate it\n    $output = $codonTable->translate($seq);\n    # Use user-input stop/unknown\n    $output =~ s/\\*/$stop/g;\n    $output =~ s/X/$unknown/g;\n\t\n    # only if we are expecting to translate a complete coding region\n    if ($fullCDS) {\n\tmy $id = $self->display_id;\n\t#remove the stop character\n\tif( substr($output,-1,1) eq $stop ) {\n\t    chop $output;\n\t} else {\n\t    $throw && $self->throw(-class => 'Bio::Root::Exception',\n\t\t\t\t   -text  => \"Seq [$id]: Not using a valid terminator codon!: \". substr($output,-1,1),\n\t\t\t\t   -value => substr($output,-1,1));\n\t    $self->warn(\"Seq [$id]: Not using a valid terminator codon!: \". substr($output,-1,1));\n\t}\n\t# test if there are terminator characters inside the protein sequence!\n\tif ($output =~ /\\*/) {\n\t    $throw && $self->throw(-class => 'Bio::Root::Exception',\n\t\t\t\t   -text  => \"Seq [$id]: Terminator codon inside CDS!\");\n\t    $self->warn(\"Seq [$id]: Terminator codon inside CDS!\");\n\t}\n\t# if the initiator codon is not ATG, the amino acid needs to changed into M\n\tif ( substr($output,0,1) ne 'M' ) {\n\t    if ($codonTable->is_start_codon(substr($seq, 0, 3)) ) {\n\t\t$output = 'M'. substr($output,1);\n\t    }\n\t    elsif ($throw) {\n\t\t$self->throw(-class => 'Bio::Root::Exception',\n\t\t\t     -text => \"Seq [$id]: Not using a valid initiator codon!: \". substr($seq, 0, 3),\n\t\t\t     -value => substr($seq, 0, 3));\n\t    } else {\n\t\t$self->warn(\"Seq [$id]: Not using a valid initiator codon!\");\n\t    }\n\t}\n    }\n\n    my $seqclass;\n    if($self->can_call_new()) {\n\t$seqclass = ref($self);\n    } else {\n\t$seqclass = 'Bio::PrimarySeq';\n\t$self->_attempt_to_load_Seq();\n    }\n    my $out = $seqclass->new( '-seq' => $output,\n\t\t\t      '-display_id'  => $self->display_id,\n\t\t\t      '-accession_number' => $self->accession_number,\n\t\t\t      # is there anything wrong with retaining the\n\t\t\t      # description?\n\t\t\t      '-desc' => $self->desc(),\n\t\t\t      '-alphabet' => 'protein'\n\t\t\t    );\n    return $out;\n\n}\n\n=head2 id\n\n Title   : id\n Usage   : $id = $seq->id()\n Function: ID of the sequence. This should normally be (and actually is in\n           the implementation provided here) just a synonym for display_id().\n Example :\n Returns : A string.\n Args    :\n\n\n\nsub  id {\n   my ($self)= @_;\n\n   return $self->display_id();\n}\n\n\n=head2 length\n\n Title   : length\n Usage   : $len = $seq->length()\n Function:\n Example :\n Returns : integer representing the length of the sequence.\n Args    :\n\n\n\nsub  length {\n   my ($self)= @_;\n   $self->throw_not_implemented();\n}\n\n=head2 desc\n\n Title   : desc\n Usage   : $seq->desc($newval);\n           $description = $seq->desc();\n Function: Get/set description text for a seq object\n Example :\n Returns : value of desc\n Args    : newvalue (optional)\n\n\n\nsub desc {\n   my ($self,$value) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 is_circular\n\n Title   : is_circular\n Usage   : if( $obj->is_circular) { /Do Something/ }\n Function: Returns true if the molecule is circular\n Returns : Boolean value\n Args    : none\n\n\nsub is_circular{\n    my ($self,$value) = @_;\n    if (defined $value) {\n\t$self->{'_is_circular'} = $value;\n    }\n    return $self->{'_is_circular'};\n}\n\n=head1 Private functions\n\nThese are some private functions for the PrimarySeqI interface. You do not\nneed to implement these functions\n\n=head2 _attempt_to_load_Seq\n\n Title   : _attempt_to_load_Seq\n Usage   :\n Function:\n Example :\n Returns :\n Args    :","parameters":[{"label":"$self"}],"label":"_attempt_to_load_Seq($self)"},"detail":"($self)","name":"_attempt_to_load_Seq","range":{"end":{"character":9999,"line":729},"start":{"character":0,"line":705}}},{"line":714,"kind":12,"name":"Bio","containerName":"PrimarySeq"}]}